*-------------------------------------------------------------------------------------------------------------------------
* Covid questoinnaire
*-------------------------------------------------------------------------------------------------------------------------
use "${dataw8}_ca",clear

*-----------------------------------------------------------------------------------------
* Merge with other datasets
*-----------------------------------------------------------------------------------------
merge 1:1 mergeid using "${dataw8}_cv_r", nogen keep(3) 		///
	keepusing(gender yrbirth mobirth age2020 coupleid8 			///
		mergeidp8 agep2020 hhsize int_year_ca int_month_ca)
	
merge 1:1 mergeid using "${dataw8}_gv_weights", nogen keep(3) 	///
	keepusing(subsample cchw_w8_ca cciw_w8_ca)
*-----------------------------------------------------------------------------------------


*-----------------------------------------------------------------------------------------
* Technical variables & socio-demographic
*-----------------------------------------------------------------------------------------
gen couple=coupleid8!=""
gen birth_month=mobirth 	if mobirth>=1 & mobirth<=12
rename yrbirth 	birth_year
rename age2020 age
gen agep=agep2020 			if agep2020>0
gen female=gender==2
label var couple 			"Living in a couple"
label var birth_year		"Year of birth"
label var age				"Age"
label var agep				"Age of the partner"
label var female			"Women"
local varlist "mergeid country hhid8 subsample cchw_w8_ca cciw_w8_ca int_year_ca int_month_ca" 
local varlist "`varlist' female birth_year birth_month age couple coupleid8 mergeidp8 agep" 
*-----------------------------------------------------------------------------------------


*-----------------------------------------------------------------------------------------
* Country & Macro regions
*-----------------------------------------------------------------------------------------
gen AT=country==11 
gen DE=country==12 
gen SE=country==13 
gen NL=country==14 
gen ES=country==15 
gen IT=country==16 
gen FR=country==17 
gen DK=country==18 
gen GR=country==19 
gen CH=country==20 
gen BE=country==23 
gen IL=country==25 
gen CZ=country==28 
gen PL=country==29 
gen IE=country==30 
gen LU=country==31 
gen HU=country==32 
gen PT=country==33 
gen SI=country==34 
gen EE=country==35 
gen HR=country==47 
gen LT=country==48 
gen BG=country==51 
gen CY=country==53 
gen FI=country==55 
gen LV=country==57 
gen MT=country==59 
gen RO=country==61 
gen SK=country==63 
recode country 	(11 20 12 14 23 17 31=1 "French-German") 		///
				(18 13 55=2 "North") 							///
				(19 16 15 33 59 53=3 "South") 					///
				(28 29 32 34 35 47 48 51 57 61 63=4 "East")		,gen(macroreg)
local varlist "`varlist' macroreg AT DE SE NL ES FR DK GR CH BE IL IT CZ PL IE LU HU PT SI EE HR LT BG CY FI LV MT RO SK exrate"
*-----------------------------------------------------------------------------------------
	

	
*-----------------------------------------------------------------------------------------
* Section W - Work	
*-----------------------------------------------------------------------------------------
gen empl_0c  =(caep805_==1)		 			if (caep805_==1|caep805_==5)
lab var empl_0c 							"Work: employed or self-employed when COVID-19 broke out"

gen pwork  =caw010			 				if (caw010_>=1 & caw010_<=4)
lab var pwork 								"Work: place of work since outbreak"

gen u_r=(empl_0c==1|empl_0c==.)
gen u_1c  =(caw002_==1)		 				if u_r==1 & (caw002_==1|caw002_==5)
lab var u_1c								"Work: unemployed, laid off or business closed due to COVID-19"

gen u_spell_1c = caw003						if caw002_==1 & caw003>=0
lab var u_spell_1c							"Work: weeks of unemployment during COVID-19"
	
gen wfh_1c=caw010==1|caw010==3				if empl_0c==1 & inrange(caw010,1,4)
lab var wfh_1c								"Working From Home"

gen wfo_1c=caw010==2|caw010==3				if empl_0c==1 & inrange(caw010,1,4)
lab var wfo_1c								"Working From Office"

gen computer_1c  =caw012==1		 			if (caw012_==1|caw012_==5|caw012_==9)
lab var computer_1c 						"Work: learned new computer skills"

gen internet_1c  =caw013==1		 			if (caw013==1|caw013==5|caw013==9)
lab var computer_1c 						"Work: learned new computer skills"

gen dpiw_1c  =caw016_==1					if (caw016_==1|caw016_==5)
lab var dpiw_1c 							"Work: Protection at work"

gen safew_1c  =caw017						if (caw017_==1|caw017_==2|caw017_==3|caw017_==4)
lab var safew_1c 							"Work: Perceived safety at work"

gen hoursw_0c  =caw020						if caw020>=0
lab var hoursw_0c 							"Work: Weekly hours before Covid"

gen dec_hoursw_1c  =caw021==1				if caw021==1|caw021==5
lab var dec_hoursw_1c						"Work: Reduced weekly hours bc Covid"

gen low_hoursw_1c  =caw022					if caw022>=0
lab var low_hoursw_1c						"Work: Lowest weekly hours bc Covid"

gen inc_hoursw_1c  =caw024==1				if caw024==1|caw024==5
lab var inc_hoursw_1c						"Work: Increased weekly hours bc Covid"

gen high_hoursw_1c  =caw025					if caw025>=0
lab var high_hoursw_1c						"Work: Highest weekly hours bc Covid"

local varlist "`varlist' empl_0c pwork u_1c u_spell_1c computer_1c internet_1c dpiw_1c safew_1c hoursw_0c dec_hoursw_1c low_hoursw_1c inc_hoursw_1c high_hoursw_1c"
*-----------------------------------------------------------------------------------------


*-----------------------------------------------------------------------------------------
* Respondent Section E – Economic situation
*-----------------------------------------------------------------------------------------
// Identify MAIN respondents (address some issues: NO main respondents or 2 main respondents)
gen sec_e_resp=(cae001_==1)								// Initial definition
sort hhid8 mergeid
bys hhid8: egen num_fr=total(sec_e_resp)
sort hhid8 mergeid
bys hhid8: gen first_hhid=_n==1

replace sec_e_resp=1 if num_fr==0 & first_hhid==1		// Households with no selected respodent: minimum mergeid 
drop num_fr
sort hhid8 mergeid
bys hhid8: egen num_fr=total(sec_e_resp)

gen temp1=cahh017 	if cahh017>0 & cahh017!=.			// Households with two selected respodent: maximum number of available answers 
gen temp2=cae003_	if cae003_==1|cae003_==5
gen temp3=cae004_1	if cae004_1==0|cae004_1==1
gen temp4=cae004_2	if cae004_2==0|cae004_2==1
gen temp5=cae004_3	if cae004_3==0|cae004_3==1
gen temp6=cae004_4	if cae004_4==0|cae004_4==1
gen temp7=cae004_97	if cae004_97==0|cae004_97==1
gen temp8=cae005	if cae005>=0 & cae005!=.
gen temp9=caco007_	if caco007_>=1 & caco007_<=4
egen answers=rownonmiss(temp?)
sort hhid8 mergeid
bys hhid8: egen Answers_max=max(answers)
replace sec_e_resp=0 if num_fr==2 & answers!=Answers_max
drop temp? answers Answers_max num_fr 
sort hhid8 mergeid
bys hhid8: egen num_fr=total(sec_e_resp)

replace sec_e_resp=0 if num_fr==2 & first_hhid!=1		// Households with two selected respodent: minimum mergeid 
drop num_fr
sort hhid8 mergeid
bys hhid8: egen num_fr=total(sec_e_resp)
drop num_fr 

// Income
noi replace cahh017=. 								if cahh017==9999|cahh017==99999|cahh017==999999|cahh017==9999999										
gen mthinc_0c   =cahh017/exrate						if sec_e_resp==1 & cahh017>0 
lab var mthinc_0c	  								"Economic: overall monthly household income before Covid"

gen finsupport_1c =cae003_==1						if sec_e_resp==1 & (cae003_==1|cae003_==5)
lab var finsupport_1c	 							"Economic: received financial support bc Covid"

replace cae004_1=.									if sec_e_resp!=1 | cae004_1<0
replace cae004_2=.									if sec_e_resp!=1 | cae004_2<0
replace cae004_3=.									if sec_e_resp!=1 | cae004_3<0
replace cae004_4=.									if sec_e_resp!=1 | cae004_4<0
replace cae004_97=.									if sec_e_resp!=1 | cae004_97<0

replace cae005=. 									if cae005==9999|cae005==99999|cae005==999999|cae005==9999999
gen low_mthinc_1c  =cae005/exrate				 	if sec_e_resp==1 & cae005>=0 
lab var low_mthinc_1c 								"Economic: lowest overall monthly household income since outbreak"

gen distress_1c=caco007								if sec_e_resp==1 & (caco007>=1 & caco007<=4)
lab var distress_1c 								"Economic: Financial distress"
label value distress_1c caco007_
gen pregpay_1c=cae011==1							if sec_e_resp==1 & (cae011==1 | cae011==5)
lab var pregpay_1c 									"Economic: Postponement of regular payments"
label value pregpay_1c yesno2
gen saverosion_1c=cae012==1							if sec_e_resp==1 & (cae012==1 | cae012==5)
lab var saverosion_1c 								"Economic: Erosion of savings"
label value distress_1c yesno2
local varlist "`varlist' sec_e_resp mthinc_0c finsupport_1c cae004_* low_mthinc_1c distress_1c pregpay_1c saverosion_1c"
*-----------------------------------------------------------------------------------------


*-----------------------------------------------------------------------------------------
* Section C
*-----------------------------------------------------------------------------------------
*recode cac004 (1=1) (5=0) (-1 -2 -9 = .),gen(has_covid) 
gen covidtp_r=1
gen has_covid =(cac004_==1)		 			if covidtp_r==1 & (cac004_==1|cac004_==5)
lab var has_covid				 			"COVID-19: anyone tested positive"

local varlist "`varlist' has_covid"
*-----------------------------------------------------------------------------------------


*-----------------------------------------------------------------------------------------
* Section H
*-----------------------------------------------------------------------------------------
gen csphus_r=1
gen delta_health_covid=cah002_ 		 			if csphus_r==1 & (cah002_>=1 & cah002_<=3)
lab var delta_health_covid 		 				"Health: change in self-perceived health during the outbreak (cah002_)"

gen sphus_r=1
gen sphus_0c=caph003_ 		 	if sphus_r==1 & (caph003_>=1 & caph003_<=5)
lab var sphus_0c 	 			"Health: self-perceived health US before the outbreak"

local varlist "`varlist' delta_health_covid sphus_0c"
*-----------------------------------------------------------------------------------------




/*
// renaming
// label vars
label define comparison 1 Improved 2 Worsened 3 Equal
label define graduation 1 Excellent 2 "Very good" 3 "Good" 4 "Fair" 5 "Poor" 6 "Never used"
label define yes_no 	0 No 1 yes
label define place_work 1 Home 2 Usual 3 Both 4 Other

label value place_work 				place_work
label value health_covid 			comparison
label value health_before_covid 	graduation
label value financial_covid has_covid employed_covid u_1c reduced_hours_covid computer_covid yes_no
*/


compress
sort mergeid 
keep `varlist'
save "${data}\covid_completo",replace
drop if subsample=="Eg-S08"|country==25|country==30|country==33
keep if age>=${age_min}
keep if age<=${age_max}
save "${data}\covid",replace
*-------------------------------------------------------------------------------------------------------------------------



