*-------------------------------------------------------------------------------------------------------------------------
* Standard questionnaire
*-------------------------------------------------------------------------------------------------------------------------
use "${dataw8}_dn", clear
merge 1:1 mergeid using "${dataw8}_cv_r", nogen keep(3) 	///
	keepusing(gender yrbirth mobirth age2020 coupleid8 		///
			  mergeidp8 agep2020 hhsize int_year 			///
			  int_month nursinghome)
		  
merge 1:1 mergeid using "${dataw8}_technical_variables", nogen 		///
	keep(3) keepusing(fam_resp fin_resp hou_resp mn024_ mn101)
		
merge 1:1 mergeid using "${dataw8}_gv_weights", nogen keep(3) 		///
	keepusing(subsample cchw_w8_main cciw_w8_main cchw_w8_main_ca 	///
			  cciw_w8_main_ca mergeid hhid8 country)
			  
merge 1:1 mergeid using "${dataw8}_gv_health", nogen keep(3) 		///
	keepusing(sphus euro* gali chronicw8 adl adl2 mobility mobilit2 mobilit3 iadl iadl2 phactiv maxgrip)
	
merge 1:1 mergeid using "${data}/bmi", nogen keep(3) 		

merge 1:1 mergeid using "${dataw8}_gv_children", nogen  keep(3) 	///
	keepusing(ch_gender_* ch_yrbirth_* ch_marital_status_* 			///
		ch_occupation_* ch_fin_gave_* ch_fin_received_* 			///
		ch_school_education_*)

merge 1:1 mergeid using "${dataw8}_ch", nogen  keep(3) 				///
	keepusing(ch001)

merge 1:1 mergeid using "${dataw8}_ep", nogen keep(3)				///
	keepusing(ep* exrate)

merge 1:1 mergeid using "${data}/technology", nogen keep(3) 		

merge 1:1 mergeid using "${dataw8}_ch", nogen keep(3) 				///
	keepusing(ch005* ch006* ch001_)

merge 1:1 mergeid using "${dataw8}_ph", nogen keep(3)				///
	keepusing(ph003 ph061)

merge 1:1 mergeid using "${dataw8}_hh", nogen keep(3)				///
	keepusing(hh*)

merge 1:1 mergeid using "${data}/schooling", nogen keep(3) 			///
	keepusing(isced1997_r isced1997_sp)

cap drop ep009 ep018 ep010
merge 1:1 mergeid using "${data}/recover_ep", nogen keep(3) 		///
	keepusing(ep009 ep018 ep011 ep010)

cap drop dn007
merge 1:1 mergeid using "${data}/demographics", nogen keep(3) 		///
	keepusing(dn007)

merge 1:1 mergeid using "${data}/cognitive", nogen keep(3) 

merge 1:1 mergeid using "${data}/big5", nogen keep(3) 
*-----------------------------------------------------------------------------------------



*-----------------------------------------------------------------------------------------
* Technical variables
*-----------------------------------------------------------------------------------------
#delimit; 

local varlist "mergeid country hhid8 int_year int_month fam_resp 
	fin_resp hou_resp subsample cchw_w8_main cciw_w8_main 
	cchw_w8_main_ca cciw_w8_main_ca sphus nursinghome";

#delimit cr
*-----------------------------------------------------------------------------------------


*-----------------------------------------------------------------------------------------
* Country & Macro regions
*-----------------------------------------------------------------------------------------
gen AT=country==11 
gen DE=country==12 
gen SE=country==13 
gen NL=country==14 
gen ES=country==15 
gen IT=country==16 
gen FR=country==17 
gen DK=country==18 
gen GR=country==19 
gen CH=country==20 
gen BE=country==23 
gen IL=country==25 
gen CZ=country==28 
gen PL=country==29 
gen IE=country==30 
gen LU=country==31 
gen HU=country==32 
gen PT=country==33 
gen SI=country==34 
gen EE=country==35 
gen HR=country==47 
gen LT=country==48 
gen BG=country==51 
gen CY=country==53 
gen FI=country==55 
gen LV=country==57 
gen MT=country==59 
gen RO=country==61 
gen SK=country==63 
recode country 	(11 20 12 14 23 17 31=1 "French-German") 		///
				(18 13 55=2 "North") 							///
				(19 16 15 33 59 53=3 "South") 					///
				(28 29 32 34 35 47 48 51 57 61 63=4 "East")		,gen(macroreg)
local varlist "`varlist' macroreg AT DE SE NL ES FR DK GR CH BE IL IT CZ PL IE LU HU PT SI EE HR LT BG CY FI LV MT RO SK exrate"
*noi tab macroreg, mis
*-----------------------------------------------------------------------------------------



*-----------------------------------------------------------------------------------------
* Basic socio-demographic characteristics
*-----------------------------------------------------------------------------------------
gen couple=coupleid8!=""
gen birth_month=mobirth 	if mobirth>=1 & mobirth<=12
rename yrbirth 	birth_year
rename age2020 age
gen agep=agep2020 			if agep2020>0
gen female=gender==2
gen straniero=dn007==5		if dn007==1|dn007==5
*recode dn014 (1=1 Married) (2=2 Partnership) (3=3 "Married, live separate") (4=4 "Never married") (5=5 Divorced) (6=6 Widow) (-1 -2=.),gen(marital_status)
*noi tab marital_status, mis nol
label var couple 			"Living in a couple"
label var birth_year		"Year of birth"
label var age				"Age"
label var agep				"Age of the partner"
label var female			"Women"
label var straniero			"Foreigner"
local varlist "`varlist' female birth_year birth_month age couple coupleid8 mergeidp8 agep straniero"
*-----------------------------------------------------------------------------------------



*-----------------------------------------------------------------------------------------
* Children
*-----------------------------------------------------------------------------------------
gen children=ch001 										if fam_resp==1 & (ch001>=0 & ch001<=20) 
bys hhid8 : egen tmp=max(children)
replace children=tmp 									if ch001==. 
label var children "\# of children"
drop tmp
gen children2=0 										if fam_resp==1 
gen sons=0 												if fam_resp==1 
gen sons_0_18=0 										if fam_resp==1
gen sons_19_24=0 										if fam_resp==1
gen sons_25p=0 											if fam_resp==1
gen daughters=0 										if fam_resp==1
gen daughters_0_18=0 									if fam_resp==1
gen daughters_19_24=0 									if fam_resp==1
gen daughters_25p=0 									if fam_resp==1
forvalues sdj=1/20 {
	replace children2=children2+(ch_gender_`sdj'!=.) 				if fam_resp==1 
	
	replace sons=sons+(ch_gender_`sdj'==1) 							if fam_resp==1 & ch_gender_`sdj'>0 & ch_gender_`sdj'<.
	replace sons=.													if fam_resp==1 & (ch_gender_`sdj'<0) 

	replace sons_0_18 =sons_0_18+((ch_gender_`sdj'==1)				///
								&(2020-ch006_`sdj'>=0) 				///
								&(2020-ch006_`sdj'<=18))  			if fam_resp==1 & ch_gender_`sdj'>0 & ch006_`sdj'>0 & ch006_`sdj'<.
	replace sons_0_18=.												if fam_resp==1 & (ch_gender_`sdj'<0|ch006_`sdj'<0)

	replace sons_19_24=sons_19_24+((ch_gender_`sdj'==1)				///
								&(2020-ch006_`sdj'>=19) 			///
								&(2020-ch006_`sdj'<=24))  			if fam_resp==1 & ch_gender_`sdj'>0 & ch006_`sdj'>0 & ch006_`sdj'<.
	replace sons_19_24=.											if fam_resp==1 & (ch_gender_`sdj'<0|ch006_`sdj'<0)

	replace sons_25p  =sons_25p+((ch_gender_`sdj'==1)				///
								&(2020-ch006_`sdj'>=25) 			///
								&(2020-ch006_`sdj'<.))  			if fam_resp==1 & ch_gender_`sdj'>0 & ch006_`sdj'>0 & ch006_`sdj'<.
	replace sons_25p=.												if fam_resp==1 & (ch_gender_`sdj'<0|ch006_`sdj'<0)

	replace daughters=daughters+(ch_gender_`sdj'==2) 				if fam_resp==1 & ch_gender_`sdj'>0 & ch_gender_`sdj'<.
	replace daughters=.												if fam_resp==1 & (ch_gender_`sdj'<0)
	
	replace daughters_0_18 =daughters_0_18+((ch_gender_`sdj'==2)	///
								&(2020-ch006_`sdj'>=0) 				///
								&(2020-ch006_`sdj'<=18))  			if fam_resp==1 & ch_gender_`sdj'>0 & ch006_`sdj'>0 & ch006_`sdj'<.
	replace daughters_0_18=.										if fam_resp==1 & (ch_gender_`sdj'<0|ch006_`sdj'<0)

	replace daughters_19_24=daughters_19_24+((ch_gender_`sdj'==2)	///
								&(2020-ch006_`sdj'>=19) 			///
								&(2020-ch006_`sdj'<=24))  			if fam_resp==1 & ch_gender_`sdj'>0 & ch006_`sdj'>0 & ch006_`sdj'<.
	replace daughters_19_24=.										if fam_resp==1 & (ch_gender_`sdj'<0|ch006_`sdj'<0)

	replace daughters_25p  =daughters_25p+((ch_gender_`sdj'==2)		///
								&(2020-ch006_`sdj'>=25) 			///
								&(2020-ch006_`sdj'<.))  			if fam_resp==1 & ch_gender_`sdj'>0 & ch006_`sdj'>0 & ch006_`sdj'<.
	replace daughters_25p=.											if fam_resp==1 & (ch_gender_`sdj'<0|ch006_`sdj'<0)
} 

* Attenzione: children2 deve essere alla fine della lista
foreach xx in sons sons_0_18 sons_19_24 sons_25p daughters daughters_0_18 daughters_19_24 daughters_25p children2 {
	replace `xx'=.										if fam_resp==1 & children==. & children2==0
	bys hhid8: egen tmp=max(`xx')						
	replace `xx'=tmp 									if `xx'==. 
	drop tmp
}

noi tab children children2 if fam_resp==1, mis 
noi compare children children2 							if fam_resp==1
noi sum children children2 sons sons_0_18 sons_19_24 sons_25p daughters daughters_0_18 daughters_19_24 daughters_25p
local varlist "`varlist' children children2 sons sons_0_18 sons_19_24 sons_25p daughters daughters_0_18 daughters_19_24 daughters_25p"
*-----------------------------------------------------------------------------------------



*-----------------------------------------------------------------------------------------
* Cognitive abilities
*-----------------------------------------------------------------------------------------
local varlist "`varlist' reading writing orienti memory irecall drecall recall fluency numeracy numeracy2"
*-----------------------------------------------------------------------------------------


*-----------------------------------------------------------------------------------------
* Big5
*-----------------------------------------------------------------------------------------
rename bfi10_* big5_*
local varlist "`varlist' big5_extra big5_agree big5_consc big5_neuro big5_open"
*-----------------------------------------------------------------------------------------

*-----------------------------------------------------------------------------------------
* Current job situation (ep005)
*-----------------------------------------------------------------------------------------
gen currentjob=ep005 if ep005>0 & ep005!=.
lab val currentjob ep005_
label var currentjob 	"Current working status (Pre-Covid)"
gen pens_0s=currentjob==1 if currentjob!=.
gen empl_0s=currentjob==2 if currentjob!=.
gen u_0s=currentjob==3 if currentjob!=.
gen lforce_0s=empl_0s+u_0s
label var pens_0s 	"Retired (Pre-Covid)"
label var empl_0s 	"Employed (Pre-Covid)"
label var u_0s 		"Unemployed (Pre-Covid)"
label var lforce_0s "Labour force participation (Pre-Covid)"


* Did pay work (ep002)
replace ep002_=. if ep002_<0													
label var ep002_ 		"Did some paid job in the past 4 week"

gen worker=(currentjob==2 | ep002_==1)	if currentjob!=. | ep002_!=.
label var worker "Either employee or did some paid workers, no matter the job status"
tab currentjob  ep002_,m nolabel

* Tenure
gen tenure=2020-ep010

* Type of work 
gen public=(ep009_==2) 			if worker==1 & (ep009_==1|ep009_==2|ep009_==3)
replace public=0				if worker==0 
label var public 		"Public sector (Pre-Covid)"
gen selfemployed=(ep009_==3) 	if worker==1 & (ep009_==1|ep009_==2|ep009_==3)
replace selfemployed=0			if worker==0 
label var selfemployed 	"Self employed (Pre-Covid)"
noi tab currentjob public, mis 
noi tab currentjob selfemp, mis 
ren ep018 sector
label var sector 		"Sector of activity (Pre-Covid)"
noi tab sector currentjob , mis 
gen temporary=(ep011==1|ep011==3) if ep011!=.
replace temporary=0				if worker==0|selfemployed==1
label var temporary 	"Temporary worker"
gen partime=ep013<=20			if ep013!=.
label var partime 		"Part-time worker"

foreach i in ep026_ ep027_ ep028_ ep029_ ep030_ ep031_ ep032_ ep033_ ep034_ ep035_ {
	replace `i'=. if `i'!=1 & `i'!=2 & `i'!=3 & `i'!=4
}
ren ep026_  jobsat_0s
ren ep027_  jobfisic_0s
ren ep028_  jobpress_0s
ren ep029_  jobdecide_0s
ren ep030_  jobskill_0s
ren ep031_  jobsup_0s
ren ep032_  jobrecog_0s
ren ep033_  jobpay_0s
ren ep034_  jobprosp_0s
ren ep035_  jobsecure_0s

local varlist "`varlist' currentjob worker public selfemployed sector temporary pens_0s empl_0s u_0s lforce_0s partime tenure  jobsat_0s jobfisic_0s jobpress_0s jobdecide_0s jobskill_0s jobsup_0s jobrecog_0s jobpay_0s jobprosp_0s jobsecure_0s"
*-----------------------------------------------------------------------------------------



*-----------------------------------------------------------------------------------------
* Health measures
*-----------------------------------------------------------------------------------------
recode sphus (-1 -2 = .)
label var sphus "Self perceived health status - US scale"
gen job_limited=ph061==1 if ph061==1|ph061==5
label var job_limited "Health problems limiting paid work"
forvalues i=1/12 {
	replace euro`i'=. if euro12<0
}
ren euro1		health_depression
ren euro2		health_pessimism
ren euro3		health_suicidality
ren euro4		health_guilt
ren euro5		health_sleep
ren euro6		health_interest
ren euro7		health_irritability
ren euro8		health_appetite
ren euro9		health_fatigue
ren euro10 		health_concentration
ren euro11 		health_enjoyment
ren euro12 		health_tearfulness
ren adl 		health_daily_limit_number
ren chronicw8 	health_chronic
ren eurod 		health_depress_scale
foreach i in gali iadl mobility bmi {
	replace `i'=.  if `i'<0
}
ren gali		health_limited
ren iadl 		health_instr_limit_number
ren phactiv		health_physical_inactivity
#delimit;
local varlist "`varlist' health_daily_limit_number health_chronic 
health_chronic health_depression health_pessimism health_suicidality health_guilt health_sleep health_interest health_irritability health_appetite health_fatigue health_concentration health_enjoyment health_tearfulness
health_depress_scale health_limited health_instr_limit_number maxgrip mobility health_physical_inactivity job_limited bmi"
;
#delimit cr;
*-----------------------------------------------------------------------------------------


*-----------------------------------------------------------------------------------------
* recoding
*-----------------------------------------------------------------------------------------
recode ep036 (1=1 "Yes") (5=0 "No") (-1 -2 = .),gen(want_retirement)
recode ep337 (1=1 "Yes") (5=0 "No") (-1 -2 = .),gen(look_job)
recode ep204 (1=1 "Yes") (5=0 "No") (-1 -2 = .),gen(earning_last_year)
recode ep097 (1=1 "Yes") (5=0 "No") (-1 -2 = .),gen(entitled_to_pension)
recode hh010 (1=1 "Yes") (5=0 "No") (-1 -2 = .),gen(received_financial_aid)
local varlist "`varlist' want_retirement look_job earning_last_year entitled_to_pension received_financial_aid"
*-----------------------------------------------------------------------------------------


*-----------------------------------------------------------------------------------------
* Education
* http://uis.unesco.org/sites/default/files/documents/international-standard-classification-of-education-1997-en_0.pdf
*-----------------------------------------------------------------------------------------
gen broad_education=irecode(isced1997_r,1,4,6)   if isced1997_r!=95 & isced1997_r!=.
gen basic_education =inlist(isced1997_r,0,1,2) 	 if isced1997_r!=95 & isced1997_r!=.
gen secondary_education=(isced1997_r==3) if isced1997_r!=95 & isced1997_r!=.
gen tertiary_education  =inlist(isced1997_r,4,5,6) if isced1997_r!=95 & isced1997_r!=.

gen low_education=inrange(isced1997_r,0,3) if isced1997_r!=95 & isced1997_r!=.

label var basic_education 			"Basic edu."
label var secondary_education 		"Secondary edu."
label var tertiary_education 		"Tertiary edu."
local varlist "`varlist' broad_education basic_education secondary_education tertiary_education low_education"
*-----------------------------------------------------------------------------------------


*-----------------------------------------------------------------------------------------
* Technology
*-----------------------------------------------------------------------------------------
gen currjobpc=it001==1						if it001==1|it001==5
gen lastjobpc=it002==1						if it002==1|it002==5
gen jobpc=currjobpc
replace jobpc=lastjobpc 					if jobpc==. & lastjobpc!=.
gen skillpc=it003							if (it003==1|it003==2|it003==3|it003==4|it003==5|it003==6)
gen skillpc_good=(skillpc>=1 & skillpc<=3)	if skillpc<.
gen skillpc_fair=(skillpc==4)				if skillpc<.
gen skillpc_poor=(skillpc==5 | skillpc==6)	if skillpc<.

label var currjobpc					"Current job needs PC"
label var lastjobpc					"Last job needs PC"
label var jobpc						"Job needs PC"
label var skillpc					"Self-reported skill PC"
local varlist "`varlist' jobpc skillpc skillpc_good skillpc_fair skillpc_poor"
*-----------------------------------------------------------------------------------------



*-----------------------------------------------------------------------------------------
/*
foreach lvbl in /*hh011*/ ep609e_1 ep609e_2 ep609e_3 ep609e_4 ep609e_5 /*ep205*/ ep013 ep024 ep328 ep329 ep005 ep009 ep811 it003_ ch001_ ph003 isced1997_r isced1997_sp {
	replace  `lvbl'= . if `lvbl'<0
}
gen broad_education=irecode(isced1997_r,1,4,6)
// renaming
rename ep024 	number_employees
*rename ep205	net_wage
rename ep329	retirement_year
rename ep328	retirement_month
rename it003_ 	pc_skills
rename ch001_ 	number_children
rename ep098d? 	pension_? 
rename ep609e_? 	expected_amount_pension_? 
*rename hh011 	amount_financial_aid

// label vars
label define job_def	1 Retired 2 Employed 3 Unemployed 4 Sick 5 Homemaker
label define pension_def 1 "Public old" 2 "Public early"  3 Disability 4 "Private old" 5 "Private early"

label value pc_skills 					health_status graduation
label value received_financial_aid entitled_to_pension earning_last_year want_retirement look_job yes_no
label value current_job_situation 		job_def
label value  pension_? 					pension_def	 
foreach lifgh in sector {
	replace `lifgh'=. if `lifgh'<0
}
recode sector (.=15 "Other situations") (1=1 Agriculture) (2 3 4=2 Manufacturing) (5 = 3 Construction) (6 8 = 4 "Retail\&Transport") (7 = 5 "Hotels \& Rest.") (9 10 = 6 "Financial serv.") (11 12 13 14 = 7 Public),gen(broad_sector)
*/
*-----------------------------------------------------------------------------------------



*-----------------------------------------------------------------------------------------
* Store data
*-----------------------------------------------------------------------------------------
compress
sort mergeid 
keep `varlist'
save "${data}\standard_completo",replace
drop if subsample=="Eg-S08"|country==25|country==30|country==33
drop if nursinghome==1															// They are not asked the EP part
keep if age>=${age_min}
keep if age<=${age_max}
save "${data}\standard",replace
*-------------------------------------------------------------------------------------------------------------------------



