qui {


*--------------------------------------------------------------------------------------------
*	Demographics
*--------------------------------------------------------------------------------------------
	use "${dataw8}_dn",clear
	foreach ww of numlist 7 6 5 4 2 1 {
		merge 1:1 mergeid using "${dataw`ww'}_dn", update keepusing(dn007)
		keep if _merge!=2
		drop _merge
	}
	keep mergeid country language dn007
	save "${data}/demographics",replace
*--------------------------------------------------------------------------------------------


*--------------------------------------------------------------------------------------------
*	Schooling
*--------------------------------------------------------------------------------------------
	use "${dataw8}_gv_isced",clear
	sum isced1997_r isced1997_sp
	replace isced1997_r=. 	if isced1997_r<0|isced1997_r==97
	replace isced1997_sp=. 	if isced1997_sp<0|isced1997_sp==97
	foreach ww of numlist 7 6 5 4 2 1 {
		merge 1:1 mergeid using "${dataw`ww'}_gv_isced", update keepusing(language isced1997_r isced1997_sp)
		keep if _merge!=2
		drop _m
		replace isced1997_r=. 	if isced1997_r<0|isced1997_r==97
		replace isced1997_sp=. 	if isced1997_sp<0|isced1997_sp==97
	}
	keep mergeid country language isced1997_r isced1997_sp
	save "${data}/schooling",replace
*--------------------------------------------------------------------------------------------


*--------------------------------------------------------------------------------------------
*	EP (sectors)
*--------------------------------------------------------------------------------------------
	use "${dataw8}_ep",clear
	keep mergeid ep009_ ep018_ ep811 ep013 ep010_
	rename ep811 ep011
	replace ep009_=. if ep009_<0
	replace ep018_=. if ep018_<0
	replace ep011=. if ep011<0
	foreach ww of numlist 7 6 5 4 2 1 {
		if `ww'==1 {
			merge 1:1 mergeid using "${dataw`ww'}_ep", update keepusing(ep009_1 ep011_1 ep010_1)
			keep if _merge!=2
			drop _merge
			replace ep009_1=. if ep009_1<0
			replace ep009_=ep009_1 if ep009_==. & ep009_1!=.
			replace ep011_1=. if ep011_1<0
			replace ep011=ep011_1 if ep011==. & ep011_1!=.
			replace ep010_1=. if ep010_1<0
			replace ep010_=ep010_1 if ep010_==. & ep010_1!=.
		}
		else{
			merge 1:1 mergeid using "${dataw`ww'}_ep", update keepusing(ep009_ ep018 ep011 ep010 )
			keep if _merge!=2
			drop _merge
			replace ep009_=. if ep009_<0
			replace ep018_=. if ep018_<0
			replace ep011=. if ep011<0
			replace ep010_=. if ep010_<0
		}
	}
	keep mergeid ep009_ ep018_ ep011 ep010_ 
	save "${data}/recover_ep",replace
*--------------------------------------------------------------------------------------------



*--------------------------------------------------------------------------------------------
*	Technology
*--------------------------------------------------------------------------------------------
	use "${dataw8}_it",clear
	foreach ww of numlist 7 6 5 {
		merge 1:1 mergeid using "${dataw`ww'}_it", update 
		keep if _merge!=2
		drop _m
	}
	save "${data}/technology",replace
*--------------------------------------------------------------------------------------------




*--------------------------------------------------------------------------------------------
*	Cognitive abilities
*--------------------------------------------------------------------------------------------
	use "${dataw8}_cf",clear
	merge 1:1 mergeid using "${dataw8}_technical_variables", keepusing(fam_resp fin_resp hou_resp mn024_ mn101)
	keep if _merge!=2
	drop _merge
	local selvar "mergeid hhid8 country" 

	
	* Self rated reading skills (cf001)
	noi di _n _n _n _n in gr "{hline 75}" _n "Self rated reading skills" _n "{hline 75}"
	local refvar "cf001_"
	local wlist "7 6 5 4 2 1"
	rename `refvar' `refvar'w8
	foreach ww of local wlist {
		merge mergeid using "${dataw`ww'}_cf", keep(`refvar') sort 
		keep if _merge!=2
		drop _merge
		rename `refvar' `refvar'w`ww'
	}
	rename `refvar'w8 `refvar' 
	noi tab cf001_ mn101, mis
	gen reading=cf001_ 					if (cf001_>=1 & cf001_<=5)
	replace reading=cf001_w7			if (cf001_w7>=1 & cf001_w7<=5) & reading==.
	replace reading=cf001_w6			if (cf001_w6>=1 & cf001_w6<=5) & reading==.
	replace reading=cf001_w5			if (cf001_w5>=1 & cf001_w5<=5) & reading==.
	replace reading=cf001_w4			if (cf001_w4>=1 & cf001_w4<=5) & reading==.
	replace reading=cf001_w2			if (cf001_w2>=1 & cf001_w2<=5) & reading==.
	replace reading=cf001_w1			if (cf001_w1>=1 & cf001_w1<=5) & reading==.
	noi tab reading mn101, mis nol
	lab def reading 1 "Excellent" 2 "Very good" 3 "Good" 4 "Fair" 5"Poor"
	lab val reading reading
	lab var reading 	"Self rated reading skills"
	local selvar "`selvar' reading" 

	
	
	* Self rated writing skills (cf002_)
	noi di _n _n _n _n in gr "{hline 75}" _n "Self rated writing skills" _n "{hline 75}"
	local refvar "cf002_"
	local wlist "7 6 5 4 2 1"
	rename `refvar' `refvar'w8
	foreach ww of local wlist {
		merge mergeid using "${dataw`ww'}_cf", keep(`refvar') sort
		keep if _merge!=2
		drop _merge
		*recode `refvar' (98 = -2) (99 = -1)
		rename `refvar' `refvar'w`ww'
	}
	rename `refvar'w8 `refvar' 
	noi tab cf002_ mn101, mis
	gen writing=cf002_ 					if (cf002_>=1 & cf002_<=5)
	replace writing=cf002_w7			if (cf002_w7>=1 & cf002_w7<=5) & writing==.
	replace writing=cf002_w6			if (cf002_w6>=1 & cf002_w6<=5) & writing==.
	replace writing=cf002_w5			if (cf002_w5>=1 & cf002_w5<=5) & writing==.
	replace writing=cf002_w4			if (cf002_w4>=1 & cf002_w4<=5) & writing==.
	replace writing=cf002_w2			if (cf002_w2>=1 & cf002_w2<=5) & writing==.
	replace writing=cf002_w1			if (cf002_w1>=1 & cf002_w1<=5) & writing==.
	noi tab writing mn101, mis nol
	lab def writing 1 "Excellent" 2 "Very good" 3 "Good" 4 "Fair" 5"Poor"
	lab val writing writing
	lab var writing 	"Self rated writing skills"
	local selvar "`selvar' writing"
	
	
	
	* Orientation in time (orienti - cf003_ cf004_ cf005_ cf006_)
	noi di _n _n _n _n in gr "{hline 75}" _n "Orienti" _n "{hline 75}"
	local refvarlist "cf003_ cf004_ cf005_ cf006_"					
	foreach vv of local refvarlist {
		noi tab `vv', mis nol
		replace `vv'=. 						if (`vv'<0 |`vv'>2)
		noi tab `vv', mis nol
	}
	egen orienti = anycount(cf003_ cf004_ cf005_ cf006_), values(1)
	egen orimis  = rmiss(cf003_ cf004_ cf005_ cf006_) 		 
	recode orienti 0=. 									if orimis==4 
	lab var orienti 	"Orientation in time score"
	noi tab orienti mn101, mis 
	local selvar "`selvar' orienti"	

	
	
	* Self rated memory
	noi di _n _n _n _n in gr "{hline 75}" _n "Self rated memory" _n "{hline 75}"
	gen memory=cf103_ 			if cf103_>=1 & cf103_<=5
	lab var memory   "Self rated memory"
	lab def memory 1 "Excellent" 2 "Very good" 3 "Good" 4 "Fair" 5"Poor"
	lab val memory memory
	noi tab memory mn101, mis 
	local selvar "`selvar' memory"
	
	
	* Recall 
	noi di _n _n _n _n in gr "{hline 75}" _n "Immediate and delayed recall" _n "{hline 75}"
	egen irecall = rowtotal(cf104 cf105 cf106 cf107)		if cf104!=.|cf105!=.|cf106!=.|cf107!=.
	noi tab irecall mn101_, mis
	lab var irecall   "Immediate recall"
	
	egen drecall = rowtotal(cf113 cf114 cf115 cf116)		if cf113!=.|cf114!=.|cf115!=.|cf116!=.
	noi tab drecall mn101_, mis
	lab var drecall   "Delayed recall"

	noi tab irecall drecall, mis
	gen recall=irecall+drecall
	*noi tab recall, mis
	local selvar "`selvar' irecall drecall recall"

	
	* Fluency 
	noi di _n _n _n _n in gr "{hline 75}" _n "Fluency" _n "{hline 75}"
	gen fluency=cf010_ 		if cf010_>=0 & cf010_<=100
	*noi tab fluency mn101_, mis
	lab var fluency   "Fluency test score"
	local selvar "`selvar' fluency"
	
	
	* Numeracy 
	noi di _n _n _n _n in gr "{hline 75}" _n "Numeracy" _n "{hline 75}"

	local refvarlist "cf012_ cf013_ cf014_ cf015_"
	local wlist "7 6 5 4 2 1"
	foreach refvar of local refvarlist {
		rename `refvar' `refvar'w8
		foreach ww of local wlist {
			merge mergeid using "${dataw`ww'}_cf", keep(`refvar') sort
			keep if _merge!=2
			drop _merge
			rename `refvar' `refvar'w`ww'
		}
		*noi tab `refvar'w8 mn101, mis

		gen `refvar'= `refvar'w8 			if (`refvar'w8>=1 & `refvar'w8<=97)
		replace `refvar'=`refvar'w7			if (`refvar'w7>=1 & `refvar'w7<=97) & `refvar'==.
		replace `refvar'=`refvar'w6			if (`refvar'w6>=1 & `refvar'w6<=97) & `refvar'==.
		replace `refvar'=`refvar'w5			if (`refvar'w5>=1 & `refvar'w5<=97) & `refvar'==.
		replace `refvar'=`refvar'w4			if (`refvar'w4>=1 & `refvar'w4<=97) & `refvar'==.
		replace `refvar'=`refvar'w2			if (`refvar'w2>=1 & `refvar'w2<=97) & `refvar'==.
		replace `refvar'=`refvar'w1			if (`refvar'w1>=1 & `refvar'w1<=97) & `refvar'==.
		
		*noi tab `refvar' mn101, mis
	}

	gen numeracy = .
	replace numeracy = 3 if cf012_==1
	replace numeracy = 2 if cf012_!=1 & cf013_==1 
	replace numeracy = 1 if cf012_!=1 & cf013_!=1 
	replace numeracy = 4 if cf012_==1 & cf014_==1
	replace numeracy = 5 if cf012_==1 & cf014_==1 & cf015_==1
	replace numeracy = . if cf012_==. & cf013_==. & cf014_==. & cf015_==.
	*noi tab numeracy mn101, mis
	lab var numeracy   "Numeracy test score"
	local selvar "`selvar' numeracy"

	
	
	* Numeracy2: subtraction
	local vlist "cf108 cf109 cf110 cf111 cf112"
	foreach vv of local vlist {
		replace `vv'_=. 	if (`vv'_<0|`vv'_> 999)
	}
	gen count_cf108_ = 1 if cf108_==93
	gen count_cf109_ = 1 if cf109_==cf108_-7 & cf109_!=.
	gen count_cf110_ = 1 if cf110_==cf109_-7 & cf110_!=.
	gen count_cf111_ = 1 if cf111_==cf110_-7 & cf111_!=.
	gen count_cf112_ = 1 if cf112_==cf111_-7 & cf112_!=.
	recode count_cf108_ .=0
	recode count_cf109_ .=0
	recode count_cf110_ .=0
	recode count_cf111_ .=0
	recode count_cf112_ .=0
	gen numeracy2 = count_cf108_ + count_cf109_ + count_cf110_ + count_cf111_ + count_cf112_
	recode numeracy2 0=. 	if cf108_ ==.
	lab var numeracy2   "Numeracy in subtraction test score"
	noi tab numeracy2 mn101, mis nol
	local selvar "`selvar' numeracy2"
	
	order `selvar'
	keep `selvar'
	save "${data}/cognitive",replace
*--------------------------------------------------------------------------------------------


*--------------------------------------------------------------------------------------------
* Big5
*--------------------------------------------------------------------------------------------
	use "${dataw8}_gv_big5",clear
	merge 1:1 mergeid using "${dataw7}_gv_big5", update 
	keep if _merge!=2
	drop _merge
	save "${data}/big5",replace
*--------------------------------------------------------------------------------------------

*--------------------------------------------------------------------------------------------
* Health
*--------------------------------------------------------------------------------------------
	use "${dataw8}_gv_health",clear
	foreach ww of numlist 7 6 5 4 2 1 {
		merge 1:1 mergeid using "${dataw`ww'}_gv_health", update keepusing(bmi)
		keep if _merge!=2
		drop _merge
	}
	keep mergeid country language bmi
	save "${data}/bmi",replace
*--------------------------------------------------------------------------------------------
}
