(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 12.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     79984,       1549]
NotebookOptionsPosition[     78257,       1513]
NotebookOutlinePosition[     78594,       1528]
CellTagsIndexPosition[     78551,       1525]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"LRT", "[", "site_", "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"source", ",", "data", ",", "tmp", ",", "i"}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
      "source", "=", "\"\</home/rsteinig/prediction_perfect.dat\>\""}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"data", "=", 
       RowBox[{"Import", "[", "source", "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"tmp", "=", 
       RowBox[{"{", "}"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"For", "[", 
       RowBox[{
        RowBox[{"i", "=", "1"}], ",", 
        RowBox[{"i", "\[LessEqual]", " ", 
         RowBox[{"Length", "[", "data", "]"}]}], ",", 
        RowBox[{"i", "++"}], ",", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"Length", "[", 
             RowBox[{"data", "[", 
              RowBox[{"[", "i", "]"}], "]"}], "]"}], "\[Equal]", "3"}], ",", 
           "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{"If", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"data", "[", 
                RowBox[{"[", 
                 RowBox[{"i", ",", "1"}], "]"}], "]"}], " ", "\[Equal]", 
               "site"}], ",", "\[IndentingNewLine]", 
              RowBox[{
               RowBox[{"tmp", "=", 
                RowBox[{"Append", "[", 
                 RowBox[{"tmp", ",", 
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{"data", "[", 
                    RowBox[{"[", 
                    RowBox[{"i", ",", "2"}], "]"}], "]"}], ",", 
                    RowBox[{
                    RowBox[{"data", "[", 
                    RowBox[{"[", 
                    RowBox[{"i", ",", "3"}], "]"}], "]"}], "/", "0.05"}]}], 
                   "}"}]}], "]"}]}], ";"}]}], "\[IndentingNewLine]", "]"}], 
            ";"}]}], "\[IndentingNewLine]", "]"}], ";"}]}], 
       "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"data", "=", "tmp"}], ";", "\[IndentingNewLine]", 
      RowBox[{"tmp", "=", 
       RowBox[{"{", "}"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"For", "[", 
       RowBox[{
        RowBox[{"i", "=", 
         RowBox[{"Length", "[", "data", "]"}]}], ",", 
        RowBox[{"i", ">", "1"}], ",", 
        RowBox[{"i", "--"}], ",", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"tmp", "=", 
          RowBox[{"Append", "[", 
           RowBox[{"tmp", ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"-", 
               RowBox[{"data", "[", 
                RowBox[{"[", 
                 RowBox[{"i", ",", "1"}], "]"}], "]"}]}], ",", 
              RowBox[{"data", "[", 
               RowBox[{"[", 
                RowBox[{"i", ",", "2"}], "]"}], "]"}]}], "}"}]}], "]"}]}], 
         ";"}]}], "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"data", "=", 
       RowBox[{"Join", "[", 
        RowBox[{"tmp", ",", "data"}], "]"}]}], ";", "\[IndentingNewLine]", 
      "data"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"f", "=", 
   RowBox[{"Interpolation", "[", 
    RowBox[{"LRT", "[", "25", "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"f", "[", "t", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", 
     RowBox[{"-", "100"}], ",", "100"}], "}"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0.4"}], "}"}]}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.86938232453403*^9, 3.869382390054947*^9}, {
   3.869382480555532*^9, 3.869382806328741*^9}, {3.869383266669777*^9, 
   3.8693832698816833`*^9}, {3.8693833245735273`*^9, 3.86938336289152*^9}, {
   3.86938407062304*^9, 3.8693843244130993`*^9}, 3.869385233053306*^9, 
   3.869387360862966*^9, {3.869550551862997*^9, 3.8695505631621103`*^9}, {
   3.869550594844036*^9, 3.8695507092596283`*^9}, {3.873256872042965*^9, 
   3.873256912218914*^9}, {3.873256962734668*^9, 3.873256999996262*^9}, {
   3.873257030016303*^9, 3.87325703897302*^9}, {3.873257119126308*^9, 
   3.8732571338140583`*^9}, {3.873260734976071*^9, 3.873260763638888*^9}, {
   3.8732625988513927`*^9, 3.873262612394637*^9}, 3.8733565661510077`*^9, {
   3.873356780169342*^9, 3.8733567972398033`*^9}, {3.8736206974927807`*^9, 
   3.873620783822814*^9}, {3.8737063211329527`*^9, 3.873706326315112*^9}, {
   3.87372238189321*^9, 3.873722382497401*^9}},
 CellLabel->"In[63]:=",ExpressionUUID->"d3dd7bdc-5c3b-4985-be56-e2f3b074a335"],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    TagBox[
     {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], Opacity[
      1.], LineBox[CompressedData["
1:eJwU13c81t8XAHChkpTZMjJLoWFv57H3yHwSkmRFaZDRkGQUkSThi5SRZEVl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       "]]},
     Annotation[#, "Charting`Private`Tag$506893238#1"]& ]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, 
     Charting`ScaledFrameTicks[{Identity, Identity}]}, {Automatic, 
     Charting`ScaledFrameTicks[{Identity, Identity}]}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{-99.99999591836735, 99.99999591836735}, {0, 0.4}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {0, 0}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{{3.869384184663787*^9, 3.869384244633994*^9}, {
   3.869384282825447*^9, 3.86938437031783*^9}, 3.869384405097123*^9, {
   3.8693844416474543`*^9, 3.869384471483036*^9}, {3.869385074759831*^9, 
   3.869385097811634*^9}, 3.869385234236541*^9, 3.869386218541669*^9, {
   3.869386955754107*^9, 3.8693869724403687`*^9}, 3.869387373464653*^9, 
   3.8693907232145853`*^9, 3.869392371761091*^9, {3.869550544772904*^9, 
   3.8695506507081623`*^9}, 3.869550711864399*^9, 3.869550760930245*^9, {
   3.8695511533581667`*^9, 3.869551180496192*^9}, 3.8695512498394737`*^9, 
   3.869552168517226*^9, 3.869555390159384*^9, 3.8695637079266243`*^9, 
   3.8696287628134203`*^9, {3.873256876601721*^9, 3.873256912767817*^9}, {
   3.873256969355776*^9, 3.873257000434114*^9}, {3.8732570321896677`*^9, 
   3.873257039483294*^9}, {3.873257119952709*^9, 3.873257134370208*^9}, 
   3.873257475995376*^9, 3.873258006257373*^9, 3.8732607650388527`*^9, 
   3.8732610087878637`*^9, 3.873261917084276*^9, 3.873262628375535*^9, {
   3.873356801017173*^9, 3.873356820232361*^9}, {3.8736207197125807`*^9, 
   3.8736207842218246`*^9}, 3.873653137022702*^9, 3.873706354249971*^9, 
   3.8737068280851192`*^9, {3.873722375402248*^9, 3.873722383002396*^9}, 
   3.8737740284994097`*^9},
 CellLabel->"Out[65]=",ExpressionUUID->"18bac4df-4a13-42a2-8877-b22a40212c96"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"profile", "[", "t_", "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"result", ",", "s", ",", "site", ",", "f", ",", "i"}], "}"}], 
     ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"result", "=", 
       RowBox[{"{", "}"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"s", "=", "0"}], ";", "\[IndentingNewLine]", 
      RowBox[{"For", "[", 
       RowBox[{
        RowBox[{"site", "=", "1"}], ",", 
        RowBox[{"site", "\[LessEqual]", "50"}], ",", 
        RowBox[{"site", "++"}], ",", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"f", "=", 
          RowBox[{"Interpolation", "[", 
           RowBox[{"LRT", "[", "site", "]"}], "]"}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"result", "=", 
          RowBox[{"Append", "[", 
           RowBox[{"result", ",", 
            RowBox[{"{", 
             RowBox[{"site", ",", 
              RowBox[{"f", "[", "t", "]"}]}], "}"}]}], "]"}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"s", "+=", 
          RowBox[{"f", "[", "t", "]"}]}], ";", "\[IndentingNewLine]", 
         RowBox[{"Clear", "[", "f", "]"}], ";"}]}], "\[IndentingNewLine]", 
       "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"(*", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"For", "[", 
         RowBox[{
          RowBox[{"site", "=", "11"}], ",", 
          RowBox[{"site", "\[LessEqual]", "19"}], ",", 
          RowBox[{"site", "++"}], ",", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"f", "=", 
            RowBox[{"Interpolation", "[", 
             RowBox[{"LRT", "[", "site", "]"}], "]"}]}], ";", 
           "\[IndentingNewLine]", 
           RowBox[{"result", "=", 
            RowBox[{"Append", "[", 
             RowBox[{"result", ",", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"site", "-", "10"}], ",", 
                RowBox[{"f", "[", "t", "]"}]}], "}"}]}], "]"}]}], ";", 
           "\[IndentingNewLine]", 
           RowBox[{"s", "+=", 
            RowBox[{"f", "[", "t", "]"}]}], ";", "\[IndentingNewLine]", 
           RowBox[{"Clear", "[", "f", "]"}], ";"}]}], "\[IndentingNewLine]", 
         "]"}], ";"}], "\[IndentingNewLine]", "*)"}], "\[IndentingNewLine]", 
      RowBox[{"For", "[", 
       RowBox[{
        RowBox[{"i", "=", "1"}], ",", 
        RowBox[{"i", "\[LessEqual]", 
         RowBox[{"Length", "[", "result", "]"}]}], ",", 
        RowBox[{"i", "++"}], ",", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{
          RowBox[{"result", "[", 
           RowBox[{"[", 
            RowBox[{"i", ",", "2"}], "]"}], "]"}], "/=", "s"}], ";"}]}], 
       "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", "result"}]}],
     "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"ListPlot", "[", 
  RowBox[{
   RowBox[{"profile", "[", "25", "]"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.8732571712976227`*^9, 3.8732573245526543`*^9}, {
  3.873257366977491*^9, 3.873257462674264*^9}, {3.873257518188384*^9, 
  3.87325760598202*^9}, {3.873258108299727*^9, 3.873258108619267*^9}, {
  3.8732581589326*^9, 3.873258159548003*^9}, {3.8732582221654377`*^9, 
  3.8732582488055477`*^9}, {3.873258359721026*^9, 3.873258449448698*^9}, {
  3.873620822030614*^9, 3.873620833902083*^9}, {3.873722399399555*^9, 
  3.8737223997468357`*^9}, {3.873722450471611*^9, 3.873722450945548*^9}},
 CellLabel->"In[66]:=",ExpressionUUID->"0201c7df-b927-4043-a620-766dddfc8d8b"],

Cell[BoxData[
 GraphicsBox[{{}, {
    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.011000000000000001`],
      AbsoluteThickness[1.6], PointBox[CompressedData["
1:eJxTTMoPSmViYGAwAmIQDQEf7JMXhwQ371pjBxVw+HtsRl7bvP1QPofDDt0O
xfQ/F6B8AYeZiwML4s4/hPJFHFI+ul4Ws/gE5Us4MCfsStqvy2QP4cs4vJ80
xYRxgyCUr+CQ8fAgn8FxBShfyeHWPb/S42z6UL6Kw6zzP+aaf7WG8tUcnrq+
4i/r8YDyNRwmFEkLtjKEQvlaDr9SuCtLGxOhfB2HkpJs7dl5OVC+nsN82yez
vteVQfkGDhs7vLM/hjdC+YYOC/0PZmzn74LyjRze6FwP+yw6Gco3dnjF1sZo
5jgbyjdxaFmiGbzt1yIo39ThyhbjhlOnVkL5Zg6yXDeudshshPLNHTi1jvqH
GmyD8i0cXLkL0wXU90D5lg7T8sunBPYehPKt0OSt0fTboJlvi2a/HZr77NHc
74DqvwYHNP87ooZPgyNa+Dmhhm+DE1r4O6PGT4MzWvy5oMZvgwta/Luipo8G
V7T04+aAkr4a3NDSnztq+mxwR0u/Hqjpu8HDATX9ezpsqGRKflsz0w4A46vV
Ng==
      "]]}, {
     {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
      0.011000000000000001`], AbsoluteThickness[1.6]}, {}}, {
     {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
      0.011000000000000001`], AbsoluteThickness[1.6]}, {}}}, {{}, {}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  Method->{
   "OptimizePlotMarkers" -> True, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{0, 50.}, {0, 0.13712520360320174`}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.02], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{{3.8732574635853853`*^9, 3.873257480886776*^9}, 
   3.873257559599558*^9, {3.8732575902668657`*^9, 3.8732576245161123`*^9}, 
   3.873258009991062*^9, 3.873258111056052*^9, 3.8732581618046837`*^9, {
   3.8732582253371677`*^9, 3.873258251087874*^9}, {3.873258380862301*^9, 
   3.8732584516046267`*^9}, 3.873260774358306*^9, 3.873261010865634*^9, 
   3.873261918995885*^9, 3.8732626305539293`*^9, 3.8733568222342587`*^9, 
   3.873620838864826*^9, 3.873653141448524*^9, 3.873706362466444*^9, 
   3.8737068364555883`*^9, {3.873722394718197*^9, 3.873722402711587*^9}, 
   3.873722453887143*^9, 3.873774030708007*^9},
 CellLabel->"Out[67]=",ExpressionUUID->"eb0a4432-63d4-42e4-b2f8-7a9baea96044"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"width", "[", "t_", "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"moment1", ",", "moment2", ",", "p", ",", "i"}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"moment1", "=", "0"}], ";", "\[IndentingNewLine]", 
      RowBox[{"moment2", "=", "0"}], ";", "\[IndentingNewLine]", 
      RowBox[{"p", "=", 
       RowBox[{"profile", "[", "t", "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"For", "[", 
       RowBox[{
        RowBox[{"i", "=", "1"}], ",", 
        RowBox[{"i", "\[LessEqual]", 
         RowBox[{"Length", "[", "p", "]"}]}], ",", 
        RowBox[{"i", "++"}], ",", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"moment1", "+=", 
          RowBox[{
           RowBox[{
            RowBox[{"p", "[", 
             RowBox[{"[", 
              RowBox[{"i", ",", "1"}], "]"}], "]"}], "^", "1"}], "*", 
           RowBox[{"p", "[", 
            RowBox[{"[", 
             RowBox[{"i", ",", "2"}], "]"}], "]"}]}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"moment2", "+=", 
          RowBox[{
           RowBox[{
            RowBox[{"p", "[", 
             RowBox[{"[", 
              RowBox[{"i", ",", "1"}], "]"}], "]"}], "^", "2"}], "*", 
           RowBox[{"p", "[", 
            RowBox[{"[", 
             RowBox[{"i", ",", "2"}], "]"}], "]"}]}]}], ";"}]}], 
       "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"result", "=", 
       RowBox[{"moment2", "-", 
        RowBox[{"moment1", "^", "2"}]}]}], ";", "\[IndentingNewLine]", 
      "result"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Sqrt", "[", 
  RowBox[{"width", "[", "25", "]"}], "]"}]}], "Input",
 CellChangeTimes->{{3.873257634805764*^9, 3.8732577953283587`*^9}, {
  3.873257827961215*^9, 3.873257979843461*^9}, {3.8732580301083603`*^9, 
  3.873258057619318*^9}, {3.873258165868535*^9, 3.873258215661079*^9}, {
  3.873258260630231*^9, 3.873258260789844*^9}, {3.873258432440804*^9, 
  3.8732584579371634`*^9}},
 CellLabel->"In[68]:=",ExpressionUUID->"85dbf077-cab0-4dd2-800c-d449b89332b7"],

Cell[BoxData["4.011330164771792`"], "Output",
 CellChangeTimes->{
  3.873257724206128*^9, {3.8732577818030653`*^9, 3.873257797675549*^9}, {
   3.87325785422574*^9, 3.873257865276861*^9}, {3.8732579018344383`*^9, 
   3.873257982847035*^9}, {3.8732580411907587`*^9, 3.873258059825844*^9}, {
   3.873258168526802*^9, 3.8732582181540937`*^9}, {3.873258258213798*^9, 
   3.8732582629738607`*^9}, {3.873258414435013*^9, 3.873258460274481*^9}, 
   3.873260780582613*^9, 3.873261012984497*^9, 3.873261921045829*^9, 
   3.8732626324708843`*^9, 3.873356824205217*^9, 3.873620857284708*^9, 
   3.873653145888906*^9, 3.8737063705861464`*^9, 3.873706845132944*^9, 
   3.873722479291758*^9, 3.8737740329314947`*^9},
 CellLabel->"Out[69]=",ExpressionUUID->"97e4ea23-aae3-421f-a68f-50c78ff8d254"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"n", "=", "100"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"data", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"i", "/", "n"}], "*", "100.0"}], ",", 
       RowBox[{"width", "[", 
        RowBox[{
         RowBox[{"i", "/", "n"}], "*", "100.0"}], "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "0", ",", "n"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Export", "[", 
  RowBox[{"\"\</home/rsteinig/variance_perfect.dat\>\"", ",", "data"}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.8732584907528343`*^9, 3.873258578289963*^9}, {
   3.873258654107025*^9, 3.8732586676436377`*^9}, {3.873258831262053*^9, 
   3.873258831405669*^9}, {3.873259083362152*^9, 3.87325908350565*^9}, {
   3.87326071958009*^9, 3.873260719747451*^9}, {3.873260843293455*^9, 
   3.873260843421335*^9}, {3.8732609506074247`*^9, 3.873260993151742*^9}, {
   3.873261907501844*^9, 3.873261909326009*^9}, 3.873262592304783*^9, 
   3.873356774695786*^9, {3.87362068872194*^9, 3.87362068942559*^9}, {
   3.873620873547221*^9, 3.873620880154482*^9}, {3.8737062962516623`*^9, 
   3.873706300280878*^9}, {3.873706812283283*^9, 3.87370681326921*^9}},
 CellLabel->"In[70]:=",ExpressionUUID->"77fc5448-c488-426f-a2b2-3daea7854dc2"],

Cell[BoxData[
 TemplateBox[{
  "Divide","indet",
   "\"Indeterminate expression \\!\\(\\*FractionBox[\\\"0.`\\\", \\\"0.`\\\"]\
\\) encountered.\"",2,71,9,19407940480670664135,"Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.873620889176889*^9, 3.873653150377149*^9, 
  3.873706378813305*^9, 3.8737068536201468`*^9, 3.8737225111839314`*^9, 
  3.8737740351736813`*^9},
 CellLabel->
  "During evaluation of \
In[70]:=",ExpressionUUID->"2dda4a5b-920b-43b3-9c19-f802f50d6d86"],

Cell[BoxData[
 TemplateBox[{
  "Divide","indet",
   "\"Indeterminate expression \\!\\(\\*FractionBox[\\\"0.`\\\", \\\"0.`\\\"]\
\\) encountered.\"",2,71,10,19407940480670664135,"Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.873620889176889*^9, 3.873653150377149*^9, 
  3.873706378813305*^9, 3.8737068536201468`*^9, 3.8737225111839314`*^9, 
  3.873774035180354*^9},
 CellLabel->
  "During evaluation of \
In[70]:=",ExpressionUUID->"18ca3376-0bb5-44f8-bcd1-968c0ead4712"],

Cell[BoxData[
 TemplateBox[{
  "Divide","indet",
   "\"Indeterminate expression \\!\\(\\*FractionBox[\\\"0.`\\\", \\\"0.`\\\"]\
\\) encountered.\"",2,71,11,19407940480670664135,"Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.873620889176889*^9, 3.873653150377149*^9, 
  3.873706378813305*^9, 3.8737068536201468`*^9, 3.8737225111839314`*^9, 
  3.87377403518461*^9},
 CellLabel->
  "During evaluation of \
In[70]:=",ExpressionUUID->"fe868587-811e-4503-a9e3-14d5708495ae"],

Cell[BoxData[
 TemplateBox[{
  "General","stop",
   "\"Further output of \\!\\(\\*StyleBox[RowBox[{\\\"Divide\\\", \\\"::\\\", \
\\\"indet\\\"}], \\\"MessageName\\\"]\\) will be suppressed during this \
calculation.\"",2,71,12,19407940480670664135,"Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.873620889176889*^9, 3.873653150377149*^9, 
  3.873706378813305*^9, 3.8737068536201468`*^9, 3.8737225111839314`*^9, 
  3.8737740351885433`*^9},
 CellLabel->
  "During evaluation of \
In[70]:=",ExpressionUUID->"383f505f-930e-4ce5-8b9c-fc2014045db2"],

Cell[BoxData["\<\"/home/rsteinig/variance_perfect.dat\"\>"], "Output",
 CellChangeTimes->{3.873258567062436*^9, 3.873258600352825*^9, 
  3.8732586922012577`*^9, 3.873258955534821*^9, 3.873259188276381*^9, 
  3.873260743139703*^9, 3.8732608039469957`*^9, 3.8732608858572187`*^9, 
  3.8732610562971287`*^9, 3.8732621161869907`*^9, 3.8732628301957912`*^9, 
  3.873357025271522*^9, 3.87362110933814*^9, 3.873653375046927*^9, 
  3.87370679652687*^9, 3.873707663733802*^9, 3.8737227280871696`*^9, 
  3.873774261020495*^9},
 CellLabel->"Out[72]=",ExpressionUUID->"09dc15a9-b984-4508-ba71-fc07a5b3a783"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"plot1", "=", 
   RowBox[{"ListLogLogPlot", "[", "data", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"plot2", "=", 
   RowBox[{"LogLogPlot", "[", 
    RowBox[{
     RowBox[{"0.66", "*", "x"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "1", ",", "100"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Show", "[", 
  RowBox[{"plot1", ",", "plot2"}], "]"}]}], "Input",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmViYGAQAWIQ/WV/QO/y228cGyaETADRXaVKs0F00DofMH3rwfNV
IPpSb+VGEJ0ldmgPiLYKe3sQROtLcN4E0XNEjB+A6G0vRJ6A6BeOES9A9DuF
17wrgDTPhQw+EL3tlLIyiJbZeF8dRHuEenqB5b2CAkD0ReHlC0F0UNCdJSA6
QsN2LYi2Cw9YB6J7t3TsANHdEufB9JSXi86CaJ8PUedA9JmVM9lWAmkOhR1c
IPqAgMsWEP3tvvpWEK10XmPudSAtF6sDptO5Jy0C0cuemi8G0bPsZk6MuPPG
ccVFw/kg+kXu2cUg2iiCfxmI7hGcGJABpLdteB8GogH0Nruz
  "],
 CellLabel->"In[73]:=",ExpressionUUID->"6e6252c1-cceb-4315-83a3-184b37c32e83"],

Cell[BoxData[
 GraphicsBox[{{{}, {
     {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.009166666666666668],
       AbsoluteThickness[1.6], PointBox[CompressedData["
1:eJw1VAlQlGcSHWZg7v+f75+F4YoCRleOCQhyKvg/WKE8uAOlIiaATiCCBAMG
AoqIeCAeAxIrmOiiEkUGhiiF4VCMGA5NJBAWUCPlgeGIFy4oxwgsu2S7qqur
q6u6ut57/axiPgtVcTkczpbZ/G/9fxhktFpXvXl0/ZXH5LSPfT+bJtiiDL9y
i5XwKtL/PP6a3Tdebu6j7mPn5m/Zx3FW/iENz9mlR16Mef84wS491zvQr3vN
ci1tJyWad6xBceaDi5Zv2PURTtrPF8ywXlSn4GzlGJusWc5ePstBDQZcxn6f
+Gu/HkK/31GWWKtjFeHV9ZfiuRhZG++tTZ5i/d12/9Bnz8OXJYNHlzMz7K7T
nVcVj3moFHx1b3gZByGHHe309+ljv3VFetATDkrrexS33zOAv+vN5pe79GCx
KsBDUWaAzpDv1KYiLubu54MSbatS5HORvnvyRnwZH8Xn9Du/Z3jYnx+/LMNC
gBEPSWTOPh6UVfp816MCPHxpmcib5CG/LznDZ0yAiz+teXE1Th+XtJ8V2m8U
YowYPtnyqz5am7xSU+qEyFjhqTJbYoDhqo6pXUYiVJhFbW4/aoAJZcHOCwki
PJr6aPJUvwHm8BPhtX3xy7sefNwxG/6zkIhhQ+g97+Xxoc7h1TzcJMbdVe0O
3F4+Fq450R1RKsYx8dcd7XYCzJ++87P7sBjrN3v2700W4JtuycR5Fwl6Nmq0
pE6ACLv8VW1pEjRExFbMcISIb61p6KyVILgypuKwrxAdNV2jd8clqNpg3LJr
rxBvqdo971ykyIqNsmppFKJpRPZhxHYpJo39m1dyRZjjVwrHgZthSk8RrrUs
e2ndJ4Wzp8uxf6eKUOp9s6nZlILeRKvbVKUI3dTBuIlACvarnRWcARGoz52W
d2ZT8Ag6XyKeL0Zg+VFfVTWFtUqTba1BYnzgZR92vZ/Cs99LnjftEYN5bqgY
VtC4kX7CzqhKjH+EvXM18KORF6L8MLNPjJJb576QpNCYrikJuCeXIMFHfY0+
Q+OXv4f6+LASXBlWO5jdoeGqMXLripdgR32wp/s4jQdw7Gj5WoJ1/9OnDPdf
RK93b5Kg0rz8h9/WyhB7zCTI/pUEM5yQmagUGXy78wIsjaVYfVFbtuhbGU7b
9FVkr5BC47kgzvqmDM8sfjnEfiKF9G+NqUlDMvQYDSWWHpFiZLpuQ7aAwDC3
M8f7shTBCbY/vzEl6Avt3ljQI8WGkxVnjJQEuTstkh5OSBHg19z01Itga0DX
auE8Cl/atEyoggjGhMmGMV4U8pxUD76JIghXucWQKApUgvzZwe0Eb4e2+9Rl
zeL2YHGOQzZBV0rRp9qzFMxN+gbzCwg+PmRb0NxIYe7/CJYLP23ofkxhh03h
8YLLBBm6GzlyPRrn319z37mRIGBrpvM6CxofMNavT3YQ/DNsyelATxoebfXF
zY8IsoNa95ZF0Kg3KzxV+4pg0cH12shUGlbesbk7pgmyTPxqHI7TuNW9cFQn
ZaD76g5fraXBrhuNDDRncGZf7omk2zT6HRYsTbRhIKw8Mej4B415mnfdkW4M
DmseRZhO04gUnD1p7sugvX9bgbWJDPLBHxs1oQx8w6/sNnaUwdPJ/wAdxSDI
ZGFRyWoZbALfN/TdxqDtfpuTPEaG5EuVucHpDC7zNj45libDyqy0KccDDPwT
p5zK1TLM+Q+DRcZGCe6lMqhOnedmFDMYojp0PzXIkP005sjTcgbl7ZXfDXXJ
8C/VW5F1LYOw2N7ST57LID43/pFfE4NodZarVI/A79rQVnQwOBneE8mXEvzG
Fugb9zIobq3ir1QQRG3fpLs9yGDAR+MabDnL2yGt8aZRBjv3b6gttSUgSkfz
thkG3y42HalzJmiIXHRjvkSOaIt7xrkrCFLiLjQEKeSoDkyrJ6sIkrpHGqOt
5NA37V1sG0JQdP1CarhSjr0xecPVEbM6uzqVZecmR1uwwP7VZoLxEkHmU285
uF668F8TZvu1fwj3+Mvh/vHkGqMvZnWXMn5Fb50czdJqI10mgd08hWlstBxF
SwqnGw4QzPmzHKrRJJciNcF/AJolk7c=
       "]]}, {
      {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
       0.009166666666666668], AbsoluteThickness[1.6]}, {}}, {
      {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
       0.009166666666666668], AbsoluteThickness[
       1.6]}, {}}}, {{}, {}}}, {{{}, {}, 
     TagBox[
      {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], 
       Opacity[1.], LineBox[CompressedData["
1:eJwVxX0803kcAPCZMeZhPz8lFb1UI3Ed7kYz8v30MB2n1sOri3kajpXqNJKi
jfPw6hIpZ6NSnC4PcfWaPOTxV6uUQoQwRCl0SZ6qZc7u7o/36706OGJPKJlE
Iu34z/8X5l46H8M+6SZjNctasxWEjVPoTQFjP6qTUW6VJCiIT0uOOzsyBOiJ
DZSlHFQQvOTFxZWMGDRkVl24yUVBGNTLg+iM04iucf3yXy/7iNEehrEuIxtF
NyekpFv2EZ1vu99rMYqQM4/ls+N2D9F8+FtvCqMa1ccVkVrbuoint3wPrjd/
jFaIaQ8i8Vai7+gNlvxdB7LzMqpf5nePeC0M4Z4u6kFCaxHbKbGIuDmTu3fo
1SCaG9w5dmbXDfRSkHN1vPcVuihUeWkz5chduoZmq36DWLYMFb21DdUoaajG
ZBwlKoIFf0q6kdeZ/LAlX/9GJar0Kh6vH93z+UypWT6JPNpyv3a0DiObsgVP
SeIUGmjJS91aM4JiORuUs1PTSKQmvSVJR1HdYgM/RjyLFoVrqqiyd0ife31L
0PQcysOnT/ZLJ9BOYmIoIukzYszGVyhrPyKJx0gQw1CJepOcBuwPTKOJcHt/
JP6K7K8n9fzYO4OYZYPG8QYqdGLU/txZwRxKS3611TJxAT1rZDY6DHxC3ac4
dlNLF5FpdU7JQsQXtDbDW80vUCNBc+nJIwtKtNksiGGWSoKmyKX3t/0yj8ZJ
TVaX9miAsevQI1Cr0DKHF6FPDcggzFVzrkX/gzwmN2VzH5Kh2+RZcembRRRV
t88qLE0TJN7xIYedSWDZZTpj506B7cItdk6zJGhfOLsyja4FMxcrvTPrNUBU
/tNGl24tyOMmHNucSIby2y0ZV9K1oWvX55ZrbE0YfjDDydxHBXKwWVIOmQLS
1Q9YbEwH7jR+iIYGCnD1Ppg7PtIBYbGJr8sxLSBpNfHl6bqwpuDjlcdsbXD2
9Bwmb6eB71iUue6cNoTniRu66XqQ5lo8319PhbUQ0OP7VA84g6eXBJ/QgaEj
khFmkj5o6BEWLva6kFV6ake+pwFU/VCYWvhFFzqY9LlGiiHMdrAcHspooN22
WxnRZgjWh+Icj8fpgdvc+8moLDrwLyz9JnazPqjLTS9IrDCw0PQNdJjXh/6o
331qUzHoTd41FSs3gDhFyF3WOAame6YbYkSGkEvl5w9vNQJe2TvRIyYdal2Z
t3YXGYHUJPNyiYoOucsC/MwoOGwYnYnN42Gwgi2X1WrhUKqzv32THwYX/ayo
PlQcbGzrLAf8MZD+MSmT0HBYdzSp3TQIgwzbeCrdCAeLeWOrTAEGiSi/XGMV
DsaGjh3JxzAQCF7rjG3EQekYsy78HAajZ9wDUpxxiPHuP6VzHoOfy27cXuuC
w6dY9LzwAgb86cgAvhsO0wRVNJKFAS9Os6JvGw7vPXKe+13GwCuDEdiyG4dB
/xoRtxiDJ7LfKsL34uCbYN75oQQDj64JXd19OCgKfrVOK8XAfXllBccbh54x
j87HNzFA1zg0IgCHdqHCekslBo0PSwL9+Thws9zEw1UYuI4bVKqCcGitKugU
38GAteFFICsUh2ZVuLiuDoMqLrvyRRgO21c96/RpwMAx8iot+gAOTfD9emUj
BhVZZL5xOA6ckGyx9C4G31WHVcoO4XA/RdXJlGPwL7wXLHA=
        "]]},
      Annotation[#, "Charting`Private`Tag$507187172#1"]& ]}, {}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{-0.19388086286495004`, -0.8955407300240223},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{
     Charting`ScaledTicks[{Log, Exp}], 
     Charting`ScaledFrameTicks[{Log, Exp}]}, {
     Charting`ScaledTicks[{Log, Exp}], 
     Charting`ScaledFrameTicks[{Log, Exp}]}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  Method->{
   "OptimizePlotMarkers" -> True, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Exp[#]& )[
         Part[#, 1]], 
        (Exp[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Exp[#]& )[
         Part[#, 1]], 
        (Exp[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{-0.19388086286495004`, 
   4.605170185988092}, {-0.8955407300240223, 4.141209445018011}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.02], 
     Scaled[0.05]}},
  Ticks->FrontEndValueCache[{
     Charting`ScaledTicks[{Log, Exp}], 
     Charting`ScaledTicks[{Log, Exp}]}, {{{0., 
       FormBox["1", TraditionalForm], {0.01, 0.}, {
        AbsoluteThickness[0.1]}}, {1.6094379124341003`, 
       FormBox["5", TraditionalForm], {0.01, 0.}, {
        AbsoluteThickness[0.1]}}, {2.302585092994046, 
       FormBox["10", TraditionalForm], {0.01, 0.}, {
        AbsoluteThickness[0.1]}}, {3.912023005428146, 
       FormBox["50", TraditionalForm], {0.01, 0.}, {
        AbsoluteThickness[0.1]}}, {4.605170185988092, 
       FormBox["100", TraditionalForm], {0.01, 0.}, {
        AbsoluteThickness[0.1]}}, {-0.6931471805599453, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-0.5108256237659907, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-0.35667494393873245`, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-0.2231435513142097, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-0.10536051565782628`, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {0.6931471805599453, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {1.0986122886681098`, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {1.3862943611198906`, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {1.791759469228055, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {1.9459101490553132`, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {2.0794415416798357`, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {2.1972245773362196`, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {2.995732273553991, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {3.4011973816621555`, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {3.6888794541139363`, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {4.0943445622221, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {4.248495242049359, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {4.382026634673881, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {4.499809670330265, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {5.298317366548036, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {5.703782474656201, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {5.991464547107982, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {6.214608098422191, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {6.309918278226516, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {6.396929655216146, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {6.476972362889683, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}}, {{-0.6931471805599453, 
       FormBox[
        TagBox[
         InterpretationBox["\"0.5\"", 0.5, AutoDelete -> True], NumberForm[#, {
           DirectedInfinity[1], 1}]& ], TraditionalForm], {0.01, 0.}, {
        AbsoluteThickness[0.1]}}, {0., 
       FormBox["1", TraditionalForm], {0.01, 0.}, {
        AbsoluteThickness[0.1]}}, {1.6094379124341003`, 
       FormBox["5", TraditionalForm], {0.01, 0.}, {
        AbsoluteThickness[0.1]}}, {2.302585092994046, 
       FormBox["10", TraditionalForm], {0.01, 0.}, {
        AbsoluteThickness[0.1]}}, {3.912023005428146, 
       FormBox["50", TraditionalForm], {0.01, 0.}, {
        AbsoluteThickness[0.1]}}, {-0.5108256237659907, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-0.35667494393873245`, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-0.2231435513142097, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-0.10536051565782628`, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {0.6931471805599453, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {1.0986122886681098`, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {1.3862943611198906`, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {1.791759469228055, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {1.9459101490553132`, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {2.0794415416798357`, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {2.1972245773362196`, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {2.995732273553991, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {3.4011973816621555`, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {3.6888794541139363`, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {4.0943445622221, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {4.248495242049359, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {4.382026634673881, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {4.499809670330265, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {4.605170185988092, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {4.700480365792417, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {4.787491742782046, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {4.867534450455582, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {4.941642422609304, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {5.0106352940962555`, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {5.075173815233827, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {5.135798437050262, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {5.19295685089021, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}}}]]], "Output",
 CellChangeTimes->{{3.8736212278194513`*^9, 3.873621242115079*^9}, {
   3.8736212812257147`*^9, 3.87362129690418*^9}, {3.873653375115796*^9, 
   3.8736534324107924`*^9}, 3.8737067965810013`*^9, 3.87370766379736*^9, 
   3.873774261133741*^9},
 CellLabel->"Out[75]=",ExpressionUUID->"ea14d790-5bfc-4275-b28e-94e7d719247a"]
}, Open  ]]
},
WindowSize->{1324, 911},
WindowMargins->{{423, Automatic}, {156, Automatic}},
FrontEndVersion->"12.0 for Linux x86 (64-bit) (April 8, 2019)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[580, 22, 4631, 108, 469, "Input",ExpressionUUID->"d3dd7bdc-5c3b-4985-be56-e2f3b074a335"],
Cell[5214, 132, 43793, 733, 261, "Output",ExpressionUUID->"18bac4df-4a13-42a2-8877-b22a40212c96"]
}, Open  ]],
Cell[CellGroupData[{
Cell[49044, 870, 3577, 82, 515, "Input",ExpressionUUID->"0201c7df-b927-4043-a620-766dddfc8d8b"],
Cell[52624, 954, 2651, 58, 244, "Output",ExpressionUUID->"eb0a4432-63d4-42e4-b2f8-7a9baea96044"]
}, Open  ]],
Cell[CellGroupData[{
Cell[55312, 1017, 2146, 52, 262, "Input",ExpressionUUID->"85dbf077-cab0-4dd2-800c-d449b89332b7"],
Cell[57461, 1071, 780, 11, 35, "Output",ExpressionUUID->"97e4ea23-aae3-421f-a68f-50c78ff8d254"]
}, Open  ]],
Cell[CellGroupData[{
Cell[58278, 1087, 1341, 29, 78, "Input",ExpressionUUID->"77fc5448-c488-426f-a2b2-3daea7854dc2"],
Cell[59622, 1118, 495, 11, 43, "Message",ExpressionUUID->"2dda4a5b-920b-43b3-9c19-f802f50d6d86"],
Cell[60120, 1131, 494, 11, 43, "Message",ExpressionUUID->"18ca3376-0bb5-44f8-bcd1-968c0ead4712"],
Cell[60617, 1144, 493, 11, 43, "Message",ExpressionUUID->"fe868587-811e-4503-a9e3-14d5708495ae"],
Cell[61113, 1157, 567, 12, 23, "Message",ExpressionUUID->"383f505f-930e-4ce5-8b9c-fc2014045db2"],
Cell[61683, 1171, 595, 8, 35, "Output",ExpressionUUID->"09dc15a9-b984-4508-ba71-fc07a5b3a783"]
}, Open  ]],
Cell[CellGroupData[{
Cell[62315, 1184, 918, 23, 78, "Input",ExpressionUUID->"6e6252c1-cceb-4315-83a3-184b37c32e83"],
Cell[63236, 1209, 15005, 301, 279, "Output",ExpressionUUID->"ea14d790-5bfc-4275-b28e-94e7d719247a"]
}, Open  ]]
}
]
*)

