(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 12.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[    333567,       6303]
NotebookOptionsPosition[    312660,       6067]
NotebookOutlinePosition[    312997,       6082]
CellTagsIndexPosition[    312954,       6079]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"Gaussian", "[", 
    RowBox[{"t_", ",", "x_", ",", "size_", ",", "diff_"}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", "v", "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"v", "=", 
       RowBox[{
        RowBox[{"Exp", "[", 
         RowBox[{
          RowBox[{"-", "2"}], "*", "diff", "*", "t"}], "]"}], "*", 
        RowBox[{"BesselI", "[", 
         RowBox[{
          RowBox[{"Abs", "[", 
           RowBox[{"x", "-", 
            RowBox[{"size", "/", "2"}]}], "]"}], ",", 
          RowBox[{"2", "*", "diff", "*", "t"}]}], "]"}]}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"v", "\[LessEqual]", 
         RowBox[{"10", "^", 
          RowBox[{"{", 
           RowBox[{"-", "8"}], "}"}]}]}], ",", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"v", "=", "0"}], ";"}]}], "\[IndentingNewLine]", "]"}], ";", 
      "\[IndentingNewLine]", "v"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Gaussian", "[", 
    RowBox[{"t", ",", "25", ",", "50", ",", "0.6"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "100"}], "}"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.8736187502567053`*^9, 3.87361887755127*^9}, {
  3.8736190304969387`*^9, 3.873619039056479*^9}, {3.87361914428722*^9, 
  3.873619239578684*^9}, {3.873619270189785*^9, 3.873619289722753*^9}, {
  3.873619361229183*^9, 3.8736193698980703`*^9}, {3.873619458284018*^9, 
  3.87361945864634*^9}, {3.8736537706593513`*^9, 3.8736537797299013`*^9}, {
  3.8736542884499474`*^9, 3.873654288619337*^9}, {3.873721584626231*^9, 
  3.873721587726698*^9}, {3.873721974540954*^9, 3.873721984425894*^9}},
 CellLabel->"In[48]:=",ExpressionUUID->"57fc7b0e-5888-4a6a-a6ba-8b2b2211964d"],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    TagBox[
     {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], Opacity[
      1.], LineBox[CompressedData["
1:eJwVlnc4FYwXx5FKUVnlVpJsXhkNL5JzkMhKMi4aXhQRIRWljGSTJCMjrhWy
s+Li2qOESOblZqakrLLuz++P83yfz/N8nvN9zn/niOUtg2tMDAwMbZvz/xR4
up6SyEdR5nT4d2iF/hNKWcQPO9i+Aoq7dlNK/yxQ3HJTxWzzYOJXQ8ti/Q9o
lHG22WZbDVwmg6yz9TPgsZdeRk+qg2s9rOVjX75BVIS68lpoE1jHxPsJ/p2G
5pAuzUWbj6Cmo+CVZj4Fc75sk25ZnXCWEKT1Mn4SHtbliS8nfQL249lsCpMT
EIVLufOhvSAnsJarGj0Ogp6xv5x9++BqbNdM5uoY5JOVTszdHwBD7ifNhTZj
0KL4uPy7DRU0Ur7fXzD8CtlKXI9O5o2A28s6ZaseGvwasH7lmjUKCe+v5Qyb
0+DRARba76SvcMhz+Ge6+yjUl5tuORY/BpE5Rw8as4/CTtNsIefNXv7Lb+g9
2SMQHa1n8zN0EnTlGFwejFBhWC4pQCpwCsj1C46GslQQ+vwr08F3Gpxo6mEj
gcOQz/3i+8z9GTB5Qf7spD8Erc8GnKdsfkJbsN+p8+IDEBAT1fJcdg7Kmqvr
HHP6QdIWzI7nzcFPg3LXELl+cNn+7IFL1i/otrH3qTbug729CmycYr8hlmMp
8dKPL1CWTosvSPsN9SWq89sCvsCG+omquaR5OHDkvWNJcy8k7x3SC+dbgIfl
AucvOfbCmfEnVOn4BeC1tfPR5+mFYN9ehlvRixD+mCDl7fIZCHX31X6ELgMl
ict8h1YPVEQIdoew/oH9RtPje7f1wBXL99aSgX8ghplSd7W+G1IZ+fzsff+C
XrNXtJpGN2h0Nu5jZVoB33rRXTms3fAt6VZGlucKuFuS3/zu/ASySGmevr8K
TslFo1VWn6B7j51p4J9VWI/Yc4NP+hO4UTm/id1dgwz3imHWtS6oemTNauu8
DtNVswd1X3aBFnm73oQNHfwVTtGrJjpBlm65uG+ODt7ePRHW5Z0Qwn+1XVCJ
AXf+ekgzCu0EV8t3dwzrGbA9bKfCV/lOODPhVF/czYjjX5uuqCd0gLw/H6Gd
wIT2ISvPqG4dICn23n7iEhPOPDX4ds2oA7jsRLl4xplwIyqIm5OjA2g/hv5z
W9yCtSO51WuCH+FzWHBxuAIz2mStWhCm2qFVWmFH5kNmvKDxjTUspx0KnSPz
+7ZuxanqskkjpXbwXtSiK+7bhsWD18cO2n4A/vXS+HU5FozWJicenWsD7sRr
c3sfsKCIbkDL4YY2YAGuM1LVLKhXWbRn4GUb/PRynLmisQPjiK6fIzXboIpZ
WLHGZCduPUied3/TCoVpXaFf4nZiZdBSGY9/K6Sf9Rqdo+7EUZ1DKoaWrRAW
MBBwxJYV91258E/MgVa4zBbR6+PGhsM8/xn1P2sB/Rz4J66SDb2fqfevOrXA
Gb0fj4oYdiHBbEYuQb8FJMM1RcYCdmFvGDXUgKMF1rjoruqxu5F0qs/jeEwz
fNglt4P5Mju2+3+yeljeBF3anDHtHuwoe3HLte3JTfAlcFYkNp4dOUXK3IcC
mmBsa8YZqUF2VE+MLbIxbYK1dR4vojkH8rFTM9vWG0Fi9u/SG1NOHGnd15Zt
0Agykp+f3HPnxMMlZ+kGyo0gZ1fIrRrLiSX7/NdkJRpBdcLuWO8XTozYe9nk
OVMjmA4PODASuTDPppSjpbgBAtrJY0bG3Fhd1qMFwg0QxvbyNv9dbkyp+Fiy
zNUAkVp3mWZecON76bf+/UwN8KpRit+rhxt7Xj9O5R2th5KqV+ZZhnvR9mdA
sderehjP9e7aMNiHGa7ry6qC9aD6VL0m4zwBFWQPaPGr1YGX1tvMLkcC+qUy
axnK1UHVVsHn66EE9CQl1ieL14GiB8P1i+8JWGZ0pM+fvQ6O36hgpWvuxyM2
ZxPvUWtBSE3WxFj1AI6EWwileNfCtmXeWeaTvBizh93QuIcCZwqDe6UNeZFW
EaUs3UYBH4eVGrPbvDhyrMBtP4UCG197n+cX8GKBaDfPkRwKLHdEKFySOoRH
Brk6l59QYCqL5UmRKB9mzBxfjlOkwDXplV2yu/hRdfEge3puDegM+KcR+Phx
o5E2REqrgRP+e08zSPPj9Y1k5dz4GmCmytz8qM+PL9jbeOeCaoAUZtPqEMmP
jwzLhHlta4D6o9sv6+ARvG7f+GdRqAZM3+TRBSUE0Ny4Vjb+fDUg8XQ06ykB
LPphdroEq0GMuU1qXlsAt6/RvMZlq+GP+cTlWgcBlHExm/ThroYo1kOVFgUC
2H+K1l/UXwWf7ILcEuQFcUGvMLnBrgp0xa/92qchhJZRQQWeMWRYCb5TMWQs
hEqumjspIWR4PfvkSep1IVwlOJqwe5OB+W36/mN+QmiQM2nx5QYZ3ilPqeg2
COEl+wZlViUyiBjaRzxWE0aW3aWPx2mVwODpfHwORLB1rqOgXqEScke910vO
i+CWR6etIqUrwfxMRNPDqyL44+0XnlvClVCyo8ic1VME5z9Gn1LnqISbkQuP
RapEkOo6qucyXQF9mfe6LymJ4qln3TrVcRVQ2P3wTou8GCb3J41mba+A10+s
LWnnxPDOh8CsP+vvIFFO+/yqmRiyPJMb0l94B0ExBPGjD8Ww9VfySf7Rd2B1
qWgwnCKG7Z9OFMtXvAPusSk1opY4uj4Ifq7i/A7uzl/knDSXwLNDVH0cK4dT
nBJ5zJ6SuCT/c72TVgbtjGYtH55KIs1vuM5qoAwsfgV+jUqSRCnRVKm1T2Xg
2zHNI14rifKOym3YsOmHZXrpbj2K+spL7ITXmz6ruEFU8FHkDZJ/tuS46TOL
LYrGSGHoxckzJxnLwGY1IiGNKIPEXdv4N06WQqTe9zp3CxlkXjQRuCJTCjXJ
6t90bWUwnm9DoVaiFAiaf+SW7skgq0Tki6jDpdAcebnjbLQMOlp03Lm1oxTE
pcS2TPXIYNDgybdDQyUwY0G2lbgoi3EaBP+QwBK41Th5PE/3GIYJhQjrzhRD
kNk24fWbJzCd2UXJp/ItWDU9uC5rK4dzitpsjK1FQNm+/4K9qTyW/+stTftb
CLIcXlHTroqo3qzHXHOsECzmT0vq3VTCkNgiK5fQAkhObOBdDlXGYroojfw9
H4rCFAe6DBDzlfMW0q7kg+u70/oJOirow78ldqMtD6pb034HmqviDhX1HPfB
XLihoUC+QVTDqFWK/fruXIh/LVtsb3cG+4aFJ++r5MCzebK30z111N9zr3zW
7w1MZN25a+tyFld+V3BPjWVD/dmIGB8fDUyzmR4fxmxgPN9Pe+qliTQeuo5n
QRYwqJQwJrmfw1uKCsPSR7MggGdZt8tfC6lZOX820jLBycyqdvmxNkYowrnf
Upkw6n3CGl7oYIR+i9Pi29fA/Ty2PzBZF8e4dxML1F5DOruEe1OcHobTLlww
o2YAxeWwumj2eVzraZzvu5cBifxJvKcN9XGgxVSl52AGkD1WGGw79NHloMPt
+IZ0OKK9fU3Q5ALqWOTvlrmZDm8/igf3dV/AQ0wVlpd40yGkcUOG/7IBEno9
8H5LGjy/PW1nMWiAEYl3FDU90zb/S749AqYXkUuu8I2JQhpkim9tdR25iOdk
E5jt5lJh2wLjfsoVQ1T9N2ZtNjcVMmQKHiVOGuJSoK91gl0qiFtm6a07GKHn
y6f9bBKpMHCuvNBoxgi5N6j7Z3+mQFfK/aNw2xg5wxvjuIpS4E/RBSWB38Z4
c07NTdojBehlLsV+jiboQVbK4tJMAW2Zs+oeiyYoZh0qY8qRAk2XpW/Y3yZi
UDzF+CuVBJxWthUJd4gYHCE8tmOTr9gm7+q4R8Tv1rQwmWESLLlwFZ7wIGLo
KR2lR4MkEApYXln33WQHsaUDfSTwKqwOCY8iovhzjRHTLhIobtfPLy4n4uG4
Aosf9STwYwtkmqog4rb2pyE8m9zJUWt4oIqIvq+Xu1XqSGDLe+Lvo1oimixo
VURRSBAtS1DVbNvcV6I3pFJFggXzkU/9g0QcadZwTiglAf63X2QXlYiMmm2W
LSUkCL5u4AajRNTruu20WEwCAed63tRxIpoJHxzRfUuCC36vrznMEvHyKjc7
QwEJ4oNHS1/NEdF7jZMmmU+CqfADO7t+EzHKlbnDNG/znriQXLllIpYLZtKL
ckjwPqmB4cZfIqay6auMviEBT/qGQdwqEWU7OhN3b7Jl9r9pH9aJyKYjRlDK
JkFuvtMynU7Eqqu6OTeySPA/aBIYSQ==
       "]]},
     Annotation[#, "Charting`Private`Tag$5380286#1"]& ]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{Automatic, Automatic},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, 
     Charting`ScaledFrameTicks[{Identity, Identity}]}, {Automatic, 
     Charting`ScaledFrameTicks[{Identity, Identity}]}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{All, All},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.873619464683241*^9, 3.873619507305369*^9, 3.873619569396953*^9, 
   3.8736205523087893`*^9, 3.873621456216241*^9, 3.873653639359182*^9, 
   3.8736536975794163`*^9, {3.873653760167653*^9, 3.873653786127996*^9}, 
   3.8736540435956*^9, 3.873654306981906*^9, 3.873654361670475*^9, {
   3.87372152584033*^9, 3.8737215885040607`*^9}, 3.873721902197706*^9, 
   3.8737219860986147`*^9, 3.873722123470373*^9, 3.873722998977186*^9},
 CellLabel->"Out[49]=",ExpressionUUID->"3c53ac5b-4c58-411f-ae93-e34bdac5acde"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"LRT", "[", "site_", "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"source", ",", "data", ",", "tmp", ",", "i"}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"(*", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{
       "source", "=", 
        "\"\</home/rsteinig/Dropbox/Projects/Tjark/Lindblad/results/plotdata/\
reference1_fengping.dat\>\""}], ";", "\[IndentingNewLine]", 
       RowBox[{"data", "=", 
        RowBox[{"Import", "[", "source", "]"}]}], ";"}], 
      "\[IndentingNewLine]", "*)"}], "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"data", "=", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"i", "/", "1000"}], "*", "100.0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"i", ",", "0", ",", "1000"}], "}"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"tmp", "=", 
       RowBox[{"{", "}"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"(*", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"For", "[", 
         RowBox[{
          RowBox[{"i", "=", "1"}], ",", 
          RowBox[{"i", "\[LessEqual]", " ", 
           RowBox[{"Length", "[", "data", "]"}]}], ",", 
          RowBox[{"i", "++"}], ",", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"Length", "[", 
               RowBox[{"data", "[", 
                RowBox[{"[", "i", "]"}], "]"}], "]"}], "\[Equal]", "3"}], ",",
              "\[IndentingNewLine]", 
             RowBox[{
              RowBox[{"If", "[", 
               RowBox[{
                RowBox[{
                 RowBox[{"data", "[", 
                  RowBox[{"[", 
                   RowBox[{"i", ",", "1"}], "]"}], "]"}], " ", "\[Equal]", 
                 "site"}], ",", "\[IndentingNewLine]", 
                RowBox[{
                 RowBox[{"tmp", "=", 
                  RowBox[{"Append", "[", 
                   RowBox[{"tmp", ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"data", "[", 
                    RowBox[{"[", 
                    RowBox[{"i", ",", "2"}], "]"}], "]"}], ",", 
                    RowBox[{"data", "[", 
                    RowBox[{"[", 
                    RowBox[{"i", ",", "3"}], "]"}], "]"}]}], "}"}]}], "]"}]}],
                  ";"}]}], "\[IndentingNewLine]", "]"}], ";"}]}], 
            "\[IndentingNewLine]", "]"}], ";"}]}], "\[IndentingNewLine]", 
         "]"}], ";"}], "\[IndentingNewLine]", "*)"}], "\[IndentingNewLine]", 
      RowBox[{"For", "[", 
       RowBox[{
        RowBox[{"i", "=", "1"}], ",", 
        RowBox[{"i", "\[LessEqual]", " ", 
         RowBox[{"Length", "[", "data", "]"}]}], ",", 
        RowBox[{"i", "++"}], ",", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"tmp", "=", 
          RowBox[{"Append", "[", 
           RowBox[{"tmp", ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"data", "[", 
               RowBox[{"[", 
                RowBox[{"i", ",", "1"}], "]"}], "]"}], ",", 
              RowBox[{"Gaussian", "[", 
               RowBox[{
                RowBox[{"data", "[", 
                 RowBox[{"[", 
                  RowBox[{"i", ",", "1"}], "]"}], "]"}], ",", "site", ",", 
                "50", ",", "0.6"}], "]"}]}], "}"}]}], "]"}]}], ";"}]}], 
       "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"data", "=", "tmp"}], ";", "\[IndentingNewLine]", 
      RowBox[{"tmp", "=", 
       RowBox[{"{", "}"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"For", "[", 
       RowBox[{
        RowBox[{"i", "=", 
         RowBox[{"Length", "[", "data", "]"}]}], ",", 
        RowBox[{"i", ">", "1"}], ",", 
        RowBox[{"i", "--"}], ",", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"tmp", "=", 
          RowBox[{"Append", "[", 
           RowBox[{"tmp", ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"-", 
               RowBox[{"data", "[", 
                RowBox[{"[", 
                 RowBox[{"i", ",", "1"}], "]"}], "]"}]}], ",", 
              RowBox[{"data", "[", 
               RowBox[{"[", 
                RowBox[{"i", ",", "2"}], "]"}], "]"}]}], "}"}]}], "]"}]}], 
         ";"}]}], "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"data", "=", 
       RowBox[{"Join", "[", 
        RowBox[{"tmp", ",", "data"}], "]"}]}], ";", "\[IndentingNewLine]", 
      "data"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"f", "=", 
   RowBox[{"Interpolation", "[", 
    RowBox[{"LRT", "[", "25", "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"f", "[", "t", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", 
     RowBox[{"-", "100"}], ",", "100"}], "}"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"0", ",", "1"}], "}"}]}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.86938232453403*^9, 3.869382390054947*^9}, {
   3.869382480555532*^9, 3.869382806328741*^9}, {3.869383266669777*^9, 
   3.8693832698816833`*^9}, {3.8693833245735273`*^9, 3.86938336289152*^9}, {
   3.86938407062304*^9, 3.8693843244130993`*^9}, 3.869385233053306*^9, 
   3.869387360862966*^9, {3.869550551862997*^9, 3.8695505631621103`*^9}, {
   3.869550594844036*^9, 3.8695507092596283`*^9}, {3.87345516384824*^9, 
   3.8734552121289473`*^9}, {3.873455498313601*^9, 3.8734555187028627`*^9}, {
   3.873514489915431*^9, 3.8735144913790607`*^9}, {3.873618070566557*^9, 
   3.873618234262352*^9}, {3.873618266104377*^9, 3.873618294275991*^9}, {
   3.873618325927466*^9, 3.873618388403919*^9}, {3.873618484442897*^9, 
   3.873618533942417*^9}, {3.873618593719944*^9, 3.873618593814205*^9}, {
   3.873618860244094*^9, 3.873618860546303*^9}, {3.87361909104043*^9, 
   3.873619120940372*^9}, {3.873619448462263*^9, 3.873619449897271*^9}, {
   3.8736536696714153`*^9, 3.87365368711038*^9}, {3.873653754871973*^9, 
   3.873653756738838*^9}, {3.8736542917599792`*^9, 3.8736543026997833`*^9}, {
   3.873721595334257*^9, 3.873721600156065*^9}, {3.8737219927694683`*^9, 
   3.8737219995952997`*^9}},
 CellLabel->"In[50]:=",ExpressionUUID->"d3dd7bdc-5c3b-4985-be56-e2f3b074a335"],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    TagBox[
     {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], Opacity[
      1.], LineBox[CompressedData["
1:eJw1mHc0Fn70x80IRR4jMys7m2TdD6GICPGUkopQ0rJChTTsRH2t0COlrMfe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       "]]},
     Annotation[#, "Charting`Private`Tag$5381541#1"]& ]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, 
     Charting`ScaledFrameTicks[{Identity, Identity}]}, {Automatic, 
     Charting`ScaledFrameTicks[{Identity, Identity}]}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{-99.99999591836735, 99.99999591836735}, {0, 1}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {0, 0}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{{3.869384184663787*^9, 3.869384244633994*^9}, {
   3.869384282825447*^9, 3.86938437031783*^9}, 3.869384405097123*^9, {
   3.8693844416474543`*^9, 3.869384471483036*^9}, {3.869385074759831*^9, 
   3.869385097811634*^9}, 3.869385234236541*^9, 3.869386218541669*^9, {
   3.869386955754107*^9, 3.8693869724403687`*^9}, 3.869387373464653*^9, 
   3.8693907232145853`*^9, 3.869392371761091*^9, {3.869550544772904*^9, 
   3.8695506507081623`*^9}, 3.869550711864399*^9, 3.869550760930245*^9, {
   3.8695511533581667`*^9, 3.869551180496192*^9}, 3.8695512498394737`*^9, 
   3.869552168517226*^9, 3.869555390159384*^9, 3.8695637079266243`*^9, 
   3.8696287628134203`*^9, 3.869803023943268*^9, 3.8698037025632963`*^9, 
   3.869803798306566*^9, 3.869804263509691*^9, 3.8698050382992573`*^9, 
   3.869829769536755*^9, 3.873184479703043*^9, 3.873186006477044*^9, 
   3.873186424736109*^9, 3.873187847090081*^9, 3.8731890792899513`*^9, 
   3.873342157289585*^9, {3.873455166281947*^9, 3.8734552125943117`*^9}, {
   3.8734554791837893`*^9, 3.873455519485914*^9}, 3.873455741846871*^9, {
   3.873455797389883*^9, 3.8734558290529346`*^9}, 3.873457727351554*^9, 
   3.873459790792042*^9, 3.8734603589486027`*^9, 3.873472184632039*^9, 
   3.873514510340909*^9, 3.873514600272512*^9, {3.873618243636848*^9, 
   3.8736182951484756`*^9}, {3.8736183273670673`*^9, 3.873618389214027*^9}, {
   3.8736184975109987`*^9, 3.873618534358481*^9}, 3.8736185942358637`*^9, {
   3.873618853820307*^9, 3.873618880019265*^9}, {3.873619071429481*^9, 
   3.873619161071679*^9}, 3.8736192450880623`*^9, 3.873619330976128*^9, 
   3.873619404002943*^9, {3.873619443902948*^9, 3.8736194508668833`*^9}, 
   3.873619509957307*^9, 3.8736195736286917`*^9, 3.873620552374996*^9, 
   3.873621456276369*^9, 3.8736536394218893`*^9, 3.873653697815517*^9, {
   3.8736537604071007`*^9, 3.8736537863668327`*^9}, 3.873654043736158*^9, 
   3.8736543103192663`*^9, 3.8736543617332487`*^9, {3.8737215363572283`*^9, 
   3.873721561209475*^9}, 3.873721600968606*^9, 3.8737219023177643`*^9, 
   3.873722000106887*^9, 3.873722123567378*^9, 3.873722999042905*^9},
 CellLabel->"Out[52]=",ExpressionUUID->"f87f5bdf-0d4a-43b3-ae4d-0170e6429161"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"JumpTimes", "[", 
    RowBox[{"tmax_", ",", "gamma_"}], "]"}], " ", ":=", " ", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"s", ",", "l", ",", "r", ",", "tau"}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"s", "=", "0"}], ";", "\[IndentingNewLine]", 
      RowBox[{"l", "=", 
       RowBox[{"{", "0", "}"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"While", "[", 
       RowBox[{
        RowBox[{"s", "\[LessEqual]", "tmax"}], ",", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"r", "=", 
          RowBox[{"RandomReal", "[", 
           RowBox[{"{", 
            RowBox[{"0", ",", "1"}], "}"}], "]"}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"tau", "=", 
          RowBox[{
           RowBox[{"-", 
            RowBox[{"Log", "[", "r", "]"}]}], "/", "gamma"}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"s", "+=", "tau"}], ";", "\[IndentingNewLine]", 
         RowBox[{"t", "=", 
          RowBox[{"tau", "+", 
           RowBox[{"l", "[", 
            RowBox[{"[", 
             RowBox[{"Length", "[", "l", "]"}], "]"}], "]"}]}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{"t", "\[LessEqual]", "tmax"}], ",", "\[IndentingNewLine]", 
           
           RowBox[{
            RowBox[{"l", "=", 
             RowBox[{"Append", "[", 
              RowBox[{"l", ",", "t"}], "]"}]}], ";"}]}], 
          "\[IndentingNewLine]", "]"}], ";"}]}], "\[IndentingNewLine]", "]"}],
       ";", "\[IndentingNewLine]", "l"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"JumpTimes", "[", 
  RowBox[{"50.0", ",", "0.1"}], "]"}]}], "Input",
 CellChangeTimes->{{3.869381442681048*^9, 3.869381876596469*^9}, {
   3.869381963255755*^9, 3.869381965028845*^9}, {3.869381996638918*^9, 
   3.8693820280036097`*^9}, {3.869382071111865*^9, 3.869382218790571*^9}, {
   3.869384997373003*^9, 3.869384997721064*^9}, {3.8693852679972277`*^9, 
   3.869385268122386*^9}, {3.869385732061214*^9, 3.869385743081196*^9}, 
   3.873184487669973*^9, {3.873455230557749*^9, 3.873455230941844*^9}, {
   3.8736195212398567`*^9, 3.8736195218476677`*^9}, {3.873654319791081*^9, 
   3.873654328458994*^9}},
 CellLabel->"In[53]:=",ExpressionUUID->"2c60896b-6ac5-4f51-b54c-40dfa7c069f3"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0", ",", "21.958114265724706`", ",", "27.644287755807746`", ",", 
   "35.55034986447822`", ",", "41.738059437883514`", ",", 
   "43.278337876465855`", ",", "47.332757913791006`"}], "}"}]], "Output",
 CellChangeTimes->{{3.869382134424259*^9, 3.86938217754292*^9}, {
   3.869382223037713*^9, 3.8693822464290743`*^9}, 3.869382563644615*^9, {
   3.869382645862286*^9, 3.8693826617915173`*^9}, {3.869382695436873*^9, 
   3.869382711682995*^9}, {3.869382822071212*^9, 3.869382825985718*^9}, 
   3.869383239620104*^9, {3.869383273024214*^9, 3.869383300556292*^9}, 
   3.869383445306903*^9, {3.869383477340433*^9, 3.8693834968533373`*^9}, 
   3.86938411503539*^9, {3.8693843344863358`*^9, 3.869384405129631*^9}, {
   3.869384441743548*^9, 3.869384471571041*^9}, 3.8693849984037647`*^9, {
   3.869385074946742*^9, 3.869385097928307*^9}, {3.8693852582628393`*^9, 
   3.869385274165526*^9}, {3.869385739708774*^9, 3.869385751797388*^9}, 
   3.8693862186891403`*^9, {3.869386955902215*^9, 3.869386972645295*^9}, 
   3.869387373551251*^9, 3.869390723321747*^9, 3.869392371855854*^9, {
   3.86955071668981*^9, 3.869550719703253*^9}, 3.869550763361332*^9, {
   3.8695511552733517`*^9, 3.8695511821437674`*^9}, 3.869551251828808*^9, 
   3.869552168532598*^9, 3.869555390181077*^9, 3.869563708785119*^9, 
   3.869628762824834*^9, 3.869803027688385*^9, 3.869803702578848*^9, 
   3.86980379842255*^9, 3.869804263614017*^9, 3.8698050383158913`*^9, 
   3.8698297696130877`*^9, {3.8731844824555264`*^9, 3.873184488502222*^9}, 
   3.873186006599737*^9, 3.873186424780864*^9, 3.873187847167676*^9, 
   3.873189079306612*^9, 3.873342157306017*^9, 3.873455231950808*^9, 
   3.873455331427218*^9, 3.8734554821616573`*^9, 3.873455522589035*^9, 
   3.873455743887446*^9, {3.873455797483893*^9, 3.87345582915547*^9}, 
   3.873457727442313*^9, 3.87345979086417*^9, 3.873460359025124*^9, 
   3.873472184710022*^9, 3.873514514324563*^9, 3.8735146003595333`*^9, 
   3.873619522993835*^9, 3.8736195937996492`*^9, 3.873620552394125*^9, 
   3.873621456293318*^9, 3.873653639433146*^9, 3.8736536978314867`*^9, {
   3.873653760423852*^9, 3.8736537863823566`*^9}, 3.8736540437526817`*^9, {
   3.87365431377046*^9, 3.87365432899619*^9}, 3.873654361746955*^9, {
   3.873721539327158*^9, 3.873721561224391*^9}, 3.873721604616283*^9, 
   3.873721902334626*^9, 3.873722004266876*^9, 3.87372212357893*^9, 
   3.873722999057694*^9},
 CellLabel->"Out[54]=",ExpressionUUID->"f39335d3-59c4-409b-88f6-4706294c62cd"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"Dynamics", "[", 
    RowBox[{"l_", ",", "tmax_", ",", "site_"}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "mu", ",", "x", ",", "i", ",", "t", ",", "a", ",", "n", ",", "data"}], 
      "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"mu", "=", "0.1"}], ";", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"g", "[", "x_", "]"}], "=", "0"}], ";", "\[IndentingNewLine]", 
      
      RowBox[{"fsite", "=", 
       RowBox[{"Interpolation", "[", 
        RowBox[{"LRT", "[", "site", "]"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"gsite", "[", "x_", "]"}], "=", "0"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"For", "[", 
       RowBox[{
        RowBox[{"i", "=", "2"}], ",", 
        RowBox[{"i", "\[LessEqual]", " ", 
         RowBox[{"Length", "[", "l", "]"}]}], ",", 
        RowBox[{"i", "++"}], ",", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"t", "=", 
          RowBox[{"l", "[", 
           RowBox[{"[", "i", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
         RowBox[{"Clear", "[", "h", "]"}], ";", "\[IndentingNewLine]", 
         RowBox[{"Clear", "[", "hsite", "]"}], ";", "\[IndentingNewLine]", 
         RowBox[{"a", "=", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"mu", "-", 
             RowBox[{"2", "*", 
              RowBox[{"g", "[", "t", "]"}]}]}], ")"}], "/", 
           RowBox[{"(", 
            RowBox[{"2", "-", 
             RowBox[{"4", "*", "mu", "*", 
              RowBox[{"g", "[", "t", "]"}]}]}], ")"}]}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"(*", 
          RowBox[{
           RowBox[{"Print", "[", "a", "]"}], ";"}], "*)"}], 
         "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"h", "[", "x_", "]"}], "=", 
          RowBox[{
           RowBox[{"g", "[", "x", "]"}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"a", "-", 
              RowBox[{"g", "[", "t", "]"}]}], ")"}], "*", 
            RowBox[{"UnitStep", "[", 
             RowBox[{"x", "-", "t"}], "]"}], "*", 
            RowBox[{"f", "[", 
             RowBox[{"x", "-", "t"}], "]"}]}]}]}], ";", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"hsite", "[", "x_", "]"}], "=", 
          RowBox[{
           RowBox[{"gsite", "[", "x", "]"}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"a", "-", 
              RowBox[{"g", "[", "t", "]"}]}], ")"}], "*", 
            RowBox[{"UnitStep", "[", 
             RowBox[{"x", "-", "t"}], "]"}], "*", 
            RowBox[{"fsite", "[", 
             RowBox[{"x", "-", "t"}], "]"}]}]}]}], ";", "\[IndentingNewLine]", 
         RowBox[{"Clear", "[", "g", "]"}], ";", "\[IndentingNewLine]", 
         RowBox[{"Clear", "[", "gsite", "]"}], ";", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"g", "[", "x_", "]"}], "=", 
          RowBox[{"h", "[", "x", "]"}]}], ";", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"gsite", "[", "x_", "]"}], "=", 
          RowBox[{"hsite", "[", "x", "]"}]}], ";"}]}], "\[IndentingNewLine]", 
       "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"n", "=", "100"}], ";", "\[IndentingNewLine]", 
      RowBox[{"data", "=", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"i", "*", 
            RowBox[{"tmax", "/", "n"}]}], ",", 
           RowBox[{"gsite", "[", 
            RowBox[{"i", "*", 
             RowBox[{"tmax", "/", "n"}]}], "]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"i", ",", "0", ",", "n"}], "}"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", "data"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"ListPlot", "[", 
  RowBox[{
   RowBox[{"Dynamics", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "10", ",", "20", ",", "30", ",", "40", ",", "50"}], 
      "}"}], ",", "50.0", ",", "25"}], "]"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0.05"}], "}"}]}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.8693830808262787`*^9, 3.869383184983239*^9}, {
   3.869383228748538*^9, 3.869383230425487*^9}, 3.869383289261693*^9, {
   3.8693834027638607`*^9, 3.869384021291087*^9}, {3.8693850023964157`*^9, 
   3.869385002713499*^9}, 3.869385654141893*^9, {3.8693858797877197`*^9, 
   3.869385906121483*^9}, {3.869385974766115*^9, 3.869385975098041*^9}, {
   3.869386283054698*^9, 3.8693862933246593`*^9}, {3.869386402334516*^9, 
   3.869386447468981*^9}, {3.869387251887371*^9, 3.869387286699239*^9}, {
   3.8695507745343246`*^9, 3.869550777637645*^9}, {3.869550820743869*^9, 
   3.869550826846632*^9}, {3.869550867407881*^9, 3.8695508800299797`*^9}, {
   3.869550930312374*^9, 3.869551116555766*^9}, {3.8695511615084133`*^9, 
   3.8695511905007563`*^9}, {3.869551224076708*^9, 3.869551225261381*^9}, {
   3.8695512811386433`*^9, 3.869551330556384*^9}, {3.869555380465838*^9, 
   3.869555382717444*^9}, {3.8698031163110867`*^9, 3.869803277575761*^9}, {
   3.87318599495006*^9, 3.873185999246708*^9}, {3.8731877849509706`*^9, 
   3.873187787893962*^9}, {3.873455321730605*^9, 3.873455351406787*^9}, 
   3.8734557564537363`*^9, {3.8734577128352633`*^9, 3.8734577156171*^9}, {
   3.8735145210823507`*^9, 3.873514533056464*^9}, {3.873619598315696*^9, 
   3.873619629291245*^9}, {3.8736204389259043`*^9, 3.873620439030436*^9}, {
   3.873653276879809*^9, 3.873653277917934*^9}, {3.873653476230359*^9, 
   3.873653477238035*^9}, {3.873653541506826*^9, 3.873653542546576*^9}, {
   3.873653622703105*^9, 3.873653622879034*^9}, {3.873654335200008*^9, 
   3.8736543361425343`*^9}, {3.8737216180039587`*^9, 3.873721618544298*^9}, {
   3.873722011998466*^9, 3.873722013195013*^9}},
 CellLabel->"In[55]:=",ExpressionUUID->"ae8be8f4-e682-4437-ade4-f7603461378f"],

Cell[BoxData[
 GraphicsBox[{{}, {
    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.009166666666666668], 
     AbsoluteThickness[1.6], PointBox[CompressedData["
1:eJxt1H9Qk3UcB/AnnTo0Taeg4lJYMGxMmCD7CdubsbGpaBeWFqeXoLNCVI4Q
EfnxVGA6jR8KGoZ0Hhv92mUZKDO1FT/iWOVpWKIiWNoRR4nlKad2F56f5w+/
13P33HOvez/ff97v557QjC2pjjEcxzlG74fP/7/6TY97mPEIYw6PU8RYzPhJ
xlMZSxjPYBzEeBbjYMZSxnMZhzAOZSxj/AzjMByqfXh9TL2Ew9q6Zh1/tJ4s
R75h1pCiuIYcgYErTeEHf64kz8fFrjUPClfsJT+LdRcPt8/5dRdZAb1K+96E
vJ3kSIwX9QzpXaVkJepW/ta0Ne5t8gIEeDWV9RPfIkdBLA2d/dPUN8nRkPxw
J7XXwJNVULr26q6OL3lkXoWIqqhNy1qLKF+IlIqDJ7NchZQvRFp60fS2hh2U
xyC4P/XrtFMFlMfAYs0eWDq4nfJY7CsX3S1SkPlYbLZZgrIL8ilfhMyWQydW
uhspX4TSwZTIyxmHKY/D5HmyXWGqA5THwfaLeoOmcB/larykloxtfI765NV4
4dZxd8A371KuQcaJne/f+GwP5Ro86LswfVWQk3It0rIre13fU9+8Fpj352yP
9x3KdVj7QZTzyx+pf14H157T3vljhD30KAoZaS9eVka5HnfjvTMneoR9DOiW
2steDibzBqz/94b3XI2wVzy0zj+Ob5KS+XgcWyFT1niE/RJwtPxmPGcl8wnQ
yrq7G64LexrR+W1Inhluyo0Qd+gsb5yvo9yEylyNO71O6M+EoVbV5tuO/ZQD
8pQl414vqTIRkfOiorfKIPQJ9AS2Ge/Vlz+yD5jxyYee3dFCv4kwpufUKkT0
/SIRyk//2iAXC30nYmDatCd6oqhvXyKGOwdfCcjeTefNcPib7wR2UP8wY0FF
8VP3lMIeZvhr+o6dOUJ7+MyoLW5aHyYT9klCdIn+iywP7YEkXL3UnKs2CXsl
4Sv1bbejh/bxJcFZ3b9NUkDmLPA4Iw2G1S46b0HO3MDOv/OpP94Cl/9027Xf
qT+fBZGBTXmKsdV03opxZxtHupbS9wgrLvkLueFw6pO3QlQvj6hdTn36Rn1B
NcWcUkHnkyEuk1cv0VK/SEZ7+POvfrec+uWTcS3g+raNpdSvb/T9s67OK+eo
X86Gllu2LZIYMmxYLJlSmnuE+uZtyKpK0Kx+Wujfhs//0Td3NAj923EzYfuO
sFgy7DD2Z27UdQn92+E59VHEhNfIPjsy75/kzkwS/k+L0bd2lV/a0mD6Dxlc
bj4=
      "]]}, {
     {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.009166666666666668],
       AbsoluteThickness[1.6]}, {}}, {
     {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.009166666666666668],
       AbsoluteThickness[1.6]}, {}}}, {{}, {}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  Method->{
   "OptimizePlotMarkers" -> True, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{0, 50.}, {0, 0.05}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {0, 0}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{{3.869383752889895*^9, 3.869383781064934*^9}, {
   3.869383813568427*^9, 3.869383987894019*^9}, {3.8693840216793423`*^9, 
   3.869384050343465*^9}, 3.869384115252144*^9, {3.869384336693667*^9, 
   3.869384405162464*^9}, {3.869384441786237*^9, 3.86938447160915*^9}, 
   3.8693849735622*^9, 3.869385005136201*^9, {3.8693850749986343`*^9, 
   3.869385097964218*^9}, 3.869385275439053*^9, 3.8693856550303698`*^9, 
   3.869385753039441*^9, 3.8693858374631557`*^9, {3.869385887489669*^9, 
   3.869385906778304*^9}, 3.869385975874991*^9, {3.869386132304744*^9, 
   3.8693861334562693`*^9}, 3.8693862187559357`*^9, {3.869386288098418*^9, 
   3.8693862964162407`*^9}, {3.869386403250371*^9, 3.8693864555621777`*^9}, 
   3.869386846816882*^9, {3.8693869559619627`*^9, 3.869386972707016*^9}, {
   3.869387252517036*^9, 3.869387287270467*^9}, 3.869387373610215*^9, 
   3.8693907233775043`*^9, 3.869392371916718*^9, {3.8695508704490347`*^9, 
   3.869550880716942*^9}, 3.869550952011992*^9, {3.86955114368151*^9, 
   3.869551295733129*^9}, 3.8695513314571733`*^9, 3.8695521689046288`*^9, 
   3.869555390576476*^9, 3.8695637254074097`*^9, 3.869628763294752*^9, {
   3.8698031976502943`*^9, 3.869803278548143*^9}, 3.869803330226098*^9, 
   3.869803702938292*^9, 3.869803798806394*^9, 3.869804264017774*^9, 
   3.86980503867915*^9, 3.869829770026256*^9, 3.873184498018159*^9, 
   3.873186007264233*^9, 3.8731864252511997`*^9, 3.8731878475538282`*^9, 
   3.873189079672587*^9, 3.87334215767428*^9, {3.873455316133647*^9, 
   3.873455352096637*^9}, 3.873455486304785*^9, 3.873455525100338*^9, {
   3.8734557453943977`*^9, 3.873455764522423*^9}, {3.873455797557427*^9, 
   3.873455829231153*^9}, 3.8734577275292587`*^9, 3.87345979093513*^9, 
   3.873460359091761*^9, 3.873472184783554*^9, {3.8735145293883543`*^9, 
   3.873514533593783*^9}, 3.8735146004144382`*^9, {3.8736196234281397`*^9, 
   3.873619629870181*^9}, 3.873620441631703*^9, 3.8736205524352283`*^9, 
   3.8736214563348*^9, 3.873653639483693*^9, 3.8736536979457407`*^9, {
   3.8736537605159693`*^9, 3.8736537864808693`*^9}, 3.873654043844529*^9, {
   3.8736543316391563`*^9, 3.87365436178759*^9}, {3.8737215427447987`*^9, 
   3.873721561282218*^9}, {3.873721610252239*^9, 3.873721619216776*^9}, 
   3.873721902393038*^9, 3.873722014317802*^9, 3.873722123621545*^9, 
   3.87372299910026*^9},
 CellLabel->"Out[56]=",ExpressionUUID->"ad2ddd4b-65b3-4d47-abad-76560f43c4db"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"AverageDynamics", "[", 
    RowBox[{"tmax_", ",", "gamma_", ",", "samples_"}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"l", ",", "data", ",", "s", ",", "i", ",", "site", ",", "j"}], 
      "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"l", "=", 
       RowBox[{"JumpTimes", "[", 
        RowBox[{"tmax", ",", "gamma"}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"Print", "[", "l", "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"data", "=", 
       RowBox[{"{", "}"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"For", "[", 
       RowBox[{
        RowBox[{"site", "=", "1"}], ",", 
        RowBox[{"site", "\[LessEqual]", "50"}], ",", 
        RowBox[{"site", "++"}], ",", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"data", "=", 
          RowBox[{"Append", "[", 
           RowBox[{"data", ",", 
            RowBox[{"Dynamics", "[", 
             RowBox[{"l", ",", "tmax", ",", "site"}], "]"}]}], "]"}]}], 
         ";"}]}], "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"s", "=", "data"}], ";", "\[IndentingNewLine]", 
      RowBox[{"For", "[", 
       RowBox[{
        RowBox[{"i", "=", "2"}], ",", 
        RowBox[{"i", "\[LessEqual]", "samples"}], ",", 
        RowBox[{"i", "++"}], ",", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"Mod", "[", 
             RowBox[{"i", ",", "50"}], "]"}], "\[Equal]", "0"}], ",", 
           "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{"Print", "[", "i", "]"}], ";"}]}], "\[IndentingNewLine]", 
          "]"}], ";", "\[IndentingNewLine]", 
         RowBox[{"data", "=", 
          RowBox[{"{", "}"}]}], ";", "\[IndentingNewLine]", 
         RowBox[{"l", "=", 
          RowBox[{"JumpTimes", "[", 
           RowBox[{"tmax", ",", "gamma"}], "]"}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"For", "[", 
          RowBox[{
           RowBox[{"site", "=", "1"}], ",", 
           RowBox[{"site", "\[LessEqual]", "50"}], ",", 
           RowBox[{"site", "++"}], ",", "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{"data", "=", 
             RowBox[{"Append", "[", 
              RowBox[{"data", ",", 
               RowBox[{"Dynamics", "[", 
                RowBox[{"l", ",", "tmax", ",", "site"}], "]"}]}], "]"}]}], 
            ";"}]}], "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
         RowBox[{"For", "[", 
          RowBox[{
           RowBox[{"site", "=", "1"}], ",", 
           RowBox[{"site", "\[LessEqual]", "50"}], ",", 
           RowBox[{"site", "++"}], ",", "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{"For", "[", 
             RowBox[{
              RowBox[{"j", "=", "1"}], ",", 
              RowBox[{"j", "<=", 
               RowBox[{"Length", "[", 
                RowBox[{"data", "[", 
                 RowBox[{"[", "site", "]"}], "]"}], "]"}]}], ",", 
              RowBox[{"j", "++"}], ",", "\[IndentingNewLine]", 
              RowBox[{
               RowBox[{
                RowBox[{"s", "[", 
                 RowBox[{"[", 
                  RowBox[{"site", ",", "j", ",", "2"}], "]"}], "]"}], "+=", 
                RowBox[{"data", "[", 
                 RowBox[{"[", 
                  RowBox[{"site", ",", "j", ",", "2"}], "]"}], "]"}]}], 
               ";"}]}], "\[IndentingNewLine]", "]"}], ";"}]}], 
          "\[IndentingNewLine]", "]"}], ";"}]}], "\[IndentingNewLine]", "]"}],
       ";", "\[IndentingNewLine]", 
      RowBox[{"For", "[", 
       RowBox[{
        RowBox[{"site", "=", "1"}], ",", 
        RowBox[{"site", "\[LessEqual]", "50"}], ",", 
        RowBox[{"site", "++"}], ",", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"For", "[", 
          RowBox[{
           RowBox[{"j", "=", "1"}], ",", 
           RowBox[{"j", "\[LessEqual]", " ", 
            RowBox[{"Length", "[", 
             RowBox[{"s", "[", 
              RowBox[{"[", "site", "]"}], "]"}], "]"}]}], ",", 
           RowBox[{"j", "++"}], ",", "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{
             RowBox[{"s", "[", 
              RowBox[{"[", 
               RowBox[{"site", ",", "j", ",", "2"}], "]"}], "]"}], "/=", 
             "samples"}], ";"}]}], "\[IndentingNewLine]", "]"}], ";"}]}], 
       "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", "s"}]}], 
    "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"result", "=", 
   RowBox[{"AverageDynamics", "[", 
    RowBox[{"100.0", ",", "0.1", ",", "10000"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ListPlot", "[", 
   RowBox[{"result", ",", 
    RowBox[{"PlotRange", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0.05"}], "}"}]}]}], "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ConvertResult", "[", "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"site", ",", "j"}], "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"For", "[", 
       RowBox[{
        RowBox[{"site", "=", "1"}], ",", 
        RowBox[{"site", "\[LessEqual]", "50"}], ",", 
        RowBox[{"site", "++"}], ",", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"For", "[", 
          RowBox[{
           RowBox[{"j", "=", "1"}], ",", 
           RowBox[{"j", "\[LessEqual]", " ", 
            RowBox[{"Length", "[", 
             RowBox[{"result", "[", 
              RowBox[{"[", "site", "]"}], "]"}], "]"}]}], ",", 
           RowBox[{"j", "++"}], ",", "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{
             RowBox[{"result", "[", 
              RowBox[{"[", 
               RowBox[{"site", ",", "j"}], "]"}], "]"}], "=", 
             RowBox[{"{", 
              RowBox[{"site", ",", 
               RowBox[{"result", "[", 
                RowBox[{"[", 
                 RowBox[{"site", ",", "j", ",", "1"}], "]"}], "]"}], ",", 
               RowBox[{"result", "[", 
                RowBox[{"[", 
                 RowBox[{"site", ",", "j", ",", "2"}], "]"}], "]"}]}], 
              "}"}]}], ";"}]}], "\[IndentingNewLine]", "]"}], ";"}]}], 
       "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"data", "=", 
       RowBox[{"{", "}"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"(*", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"For", "[", 
         RowBox[{
          RowBox[{"site", "=", "11"}], ",", 
          RowBox[{"site", "\[LessEqual]", " ", "20"}], ",", 
          RowBox[{"site", "++"}], ",", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"data", "=", 
            RowBox[{"Append", "[", 
             RowBox[{"data", ",", 
              RowBox[{"result", "[", 
               RowBox[{"[", "site", "]"}], "]"}]}], "]"}]}], ";", 
           "\[IndentingNewLine]", 
           RowBox[{"data", "=", 
            RowBox[{"Append", "[", 
             RowBox[{"data", ",", 
              RowBox[{"{", "\"\<\>\"", "}"}]}], "]"}]}], ";"}]}], 
         "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
        RowBox[{"For", "[", 
         RowBox[{
          RowBox[{"site", "=", "1"}], ",", 
          RowBox[{"site", "<", " ", "11"}], ",", 
          RowBox[{"site", "++"}], ",", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"data", "=", 
            RowBox[{"Append", "[", 
             RowBox[{"data", ",", 
              RowBox[{"result", "[", 
               RowBox[{"[", "site", "]"}], "]"}]}], "]"}]}], ";", 
           "\[IndentingNewLine]", 
           RowBox[{"data", "=", 
            RowBox[{"Append", "[", 
             RowBox[{"data", ",", 
              RowBox[{"{", "\"\<\>\"", "}"}]}], "]"}]}], ";"}]}], 
         "\[IndentingNewLine]", "]"}], ";"}], "\[IndentingNewLine]", "*)"}], 
      "\[IndentingNewLine]", 
      RowBox[{"For", "[", 
       RowBox[{
        RowBox[{"site", "=", "1"}], ",", 
        RowBox[{"site", "\[LessEqual]", " ", "50"}], ",", 
        RowBox[{"site", "++"}], ",", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"data", "=", 
          RowBox[{"Append", "[", 
           RowBox[{"data", ",", 
            RowBox[{"result", "[", 
             RowBox[{"[", "site", "]"}], "]"}]}], "]"}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"data", "=", 
          RowBox[{"Append", "[", 
           RowBox[{"data", ",", 
            RowBox[{"{", "\"\<\>\"", "}"}]}], "]"}]}], ";"}]}], 
       "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"result", "=", 
       RowBox[{"Flatten", "[", 
        RowBox[{"data", ",", "1"}], "]"}]}], ";"}]}], "\[IndentingNewLine]", 
    "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ConvertResult", "[", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Export", "[", 
  RowBox[{"\"\</home/rsteinig/prediction_perfect.dat\>\"", ",", "result"}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.869384680650875*^9, 3.869384981066822*^9}, {
   3.869385080780333*^9, 3.869385081097096*^9}, {3.869385127597068*^9, 
   3.869385186937264*^9}, {3.8693852879555387`*^9, 3.869385292378841*^9}, {
   3.869385347122353*^9, 3.8693853512250967`*^9}, {3.869385479533023*^9, 
   3.869385511577338*^9}, 3.869385559149295*^9, {3.869386185102252*^9, 
   3.869386209801724*^9}, {3.869386499582264*^9, 3.8693867106827307`*^9}, {
   3.869386742174733*^9, 3.869386823246338*^9}, {3.869386891758718*^9, 
   3.869386892187235*^9}, 3.869386952174752*^9, {3.8693870226225643`*^9, 
   3.86938702493897*^9}, {3.8693871152148438`*^9, 3.869387185310936*^9}, {
   3.8693872157428923`*^9, 3.8693872300431213`*^9}, {3.869387306785063*^9, 
   3.86938733871905*^9}, {3.8693874170555696`*^9, 3.86938742292343*^9}, {
   3.869390568112082*^9, 3.869390645075499*^9}, {3.869390700623083*^9, 
   3.869390716383162*^9}, 3.869390750976474*^9, {3.869391105863196*^9, 
   3.869391108931583*^9}, {3.869391651114599*^9, 3.8693916572361107`*^9}, 
   3.8693918011463423`*^9, {3.8693923602506647`*^9, 3.869392364228984*^9}, {
   3.86939335839485*^9, 3.869393363042889*^9}, {3.869551562698032*^9, 
   3.869551758410886*^9}, {3.86955179385211*^9, 3.869551794043009*^9}, {
   3.869551844238326*^9, 3.869551847821639*^9}, 3.8695518824247713`*^9, {
   3.869551915606978*^9, 3.869552044310719*^9}, {3.869552089858502*^9, 
   3.869552158888233*^9}, {3.869552323757848*^9, 3.869552450645014*^9}, {
   3.869552505472313*^9, 3.869552511501607*^9}, {3.869552558298688*^9, 
   3.869552684512248*^9}, {3.8695527819943132`*^9, 3.869552791233398*^9}, {
   3.8695529291831217`*^9, 3.869552981933014*^9}, {3.869553092617182*^9, 
   3.8695531019756517`*^9}, {3.869553146944129*^9, 3.869553147367036*^9}, {
   3.869554113798326*^9, 3.869554205013688*^9}, {3.869554236894998*^9, 
   3.8695542528797092`*^9}, {3.8695542861279488`*^9, 
   3.8695543334879837`*^9}, {3.869554374585094*^9, 3.869554376809273*^9}, {
   3.869554423866905*^9, 3.869554450386392*^9}, {3.869555602037032*^9, 
   3.8695556271652727`*^9}, {3.869555769306286*^9, 3.869555769751108*^9}, {
   3.869555832265006*^9, 3.869555857992688*^9}, {3.869555958394001*^9, 
   3.869556030763*^9}, 3.8695560886831417`*^9, {3.869556133404284*^9, 
   3.869556168756226*^9}, {3.8695563038055067`*^9, 3.8695563878071423`*^9}, {
   3.869556481787642*^9, 3.869556513141345*^9}, {3.8695566391992598`*^9, 
   3.8695566934942627`*^9}, {3.86955676353611*^9, 3.869556767871091*^9}, {
   3.869556863708552*^9, 3.869556876209042*^9}, {3.869556918278223*^9, 
   3.869556919793543*^9}, 3.8695570254193497`*^9, 3.869563689137718*^9, {
   3.869628727657803*^9, 3.869628755227305*^9}, {3.8698033439154*^9, 
   3.869803359416931*^9}, {3.8698034147253933`*^9, 3.8698034236203814`*^9}, {
   3.8698035780411987`*^9, 3.869803631064176*^9}, {3.869803674412877*^9, 
   3.869803693511792*^9}, {3.869803841530798*^9, 3.869803841666142*^9}, {
   3.8698042560094357`*^9, 3.869804257025201*^9}, {3.869805024764929*^9, 
   3.8698050294516497`*^9}, {3.8698130795062723`*^9, 3.8698130972130213`*^9}, 
   3.8698297606762037`*^9, {3.87318445052559*^9, 3.873184469703539*^9}, 
   3.873184664906846*^9, {3.873185974051001*^9, 3.873185987572731*^9}, {
   3.873186386746572*^9, 3.873186393129364*^9}, 3.873186570493311*^9, {
   3.873187760844708*^9, 3.873187776537649*^9}, 3.873189063706675*^9, 
   3.873342126439752*^9, {3.8734555313463297`*^9, 3.873455574002521*^9}, {
   3.873455616192144*^9, 3.8734556857612667`*^9}, {3.873455788089448*^9, 
   3.873455788482462*^9}, {3.8734558229034567`*^9, 3.8734558230729837`*^9}, {
   3.873456072723217*^9, 3.87345608737783*^9}, {3.8734561229499073`*^9, 
   3.8734561248174543`*^9}, 3.873456157522367*^9, 3.873456401958171*^9, 
   3.873459424963848*^9, {3.873470635912879*^9, 3.873470650864567*^9}, {
   3.873514542226233*^9, 3.873514597062265*^9}, {3.873619530664901*^9, 
   3.873619531464328*^9}, 3.8736195835613127`*^9, {3.8736196504590063`*^9, 
   3.87361972203008*^9}, 3.873619799163172*^9, {3.873619930747134*^9, 
   3.873619931560623*^9}, {3.873621442836164*^9, 3.873621443391616*^9}, {
   3.873653468264592*^9, 3.873653469637652*^9}, {3.8736535581620283`*^9, 
   3.873653597455496*^9}, {3.873653627833064*^9, 3.8736536361100397`*^9}, {
   3.873654353168373*^9, 3.8736543564302683`*^9}, {3.873706240150465*^9, 
   3.873706245898329*^9}, {3.873721552208314*^9, 3.8737215527364693`*^9}, {
   3.8737216247902107`*^9, 3.87372164837013*^9}, {3.873722018503085*^9, 
   3.873722042766274*^9}, {3.87372212011271*^9, 3.873722120287896*^9}, {
   3.8737229338830357`*^9, 3.873722934137479*^9}},
 CellLabel->"In[57]:=",ExpressionUUID->"2f1f2b09-d711-4b94-8c60-a97a4c4a6fb2"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0", ",", "7.314205193481708`", ",", "12.994761157879896`", ",", 
   "24.05190305630139`", ",", "35.31743902299256`", ",", 
   "44.085990823581135`", ",", "58.30261094897524`"}], "}"}]], "Print",
 CellChangeTimes->{
  3.873460359121327*^9, 3.873472184817514*^9, 3.873514600528822*^9, {
   3.873619706528304*^9, 3.873619723121772*^9}, 3.87361979983558*^9, 
   3.873619938604599*^9, 3.873620552458734*^9, 3.873621456358457*^9, 
   3.8736536395043993`*^9, 3.873653697978847*^9, {3.8736537605376453`*^9, 
   3.873653786501913*^9}, 3.87365404387046*^9, 3.873654361803931*^9, {
   3.87372155376371*^9, 3.873721561299271*^9}, 3.873721650734617*^9, 
   3.8737219024108458`*^9, 3.873722043428874*^9, 3.873722123634899*^9, 
   3.873722999119816*^9},
 CellLabel->
  "During evaluation of \
In[57]:=",ExpressionUUID->"b921f7a6-337e-44a7-98e6-65f77d6df808"],

Cell[BoxData["50"], "Print",
 CellChangeTimes->{
  3.873460359121327*^9, 3.873472184817514*^9, 3.873514600528822*^9, {
   3.873619706528304*^9, 3.873619723121772*^9}, 3.87361979983558*^9, 
   3.873619938604599*^9, 3.873620552458734*^9, 3.873621456358457*^9, 
   3.8736536395043993`*^9, 3.873653697978847*^9, {3.8736537605376453`*^9, 
   3.873653786501913*^9}, 3.87365404387046*^9, 3.873654361803931*^9, {
   3.87372155376371*^9, 3.873721561299271*^9}, 3.873721650734617*^9, 
   3.8737219024108458`*^9, 3.873722043428874*^9, 3.873722123634899*^9, 
   3.873723076490487*^9},
 CellLabel->
  "During evaluation of \
In[57]:=",ExpressionUUID->"8d88991d-179d-4ffa-abdd-7ff4fb204bc1"],

Cell[BoxData["100"], "Print",
 CellChangeTimes->{
  3.873460359121327*^9, 3.873472184817514*^9, 3.873514600528822*^9, {
   3.873619706528304*^9, 3.873619723121772*^9}, 3.87361979983558*^9, 
   3.873619938604599*^9, 3.873620552458734*^9, 3.873621456358457*^9, 
   3.8736536395043993`*^9, 3.873653697978847*^9, {3.8736537605376453`*^9, 
   3.873653786501913*^9}, 3.87365404387046*^9, 3.873654361803931*^9, {
   3.87372155376371*^9, 3.873721561299271*^9}, 3.873721650734617*^9, 
   3.8737219024108458`*^9, 3.873722043428874*^9, 3.873722123634899*^9, 
   3.873723155903432*^9},
 CellLabel->
  "During evaluation of \
In[57]:=",ExpressionUUID->"dff9de3c-1644-4ca1-bd2d-2675d7fc31bb"],

Cell[BoxData["150"], "Print",
 CellChangeTimes->{
  3.873460359121327*^9, 3.873472184817514*^9, 3.873514600528822*^9, {
   3.873619706528304*^9, 3.873619723121772*^9}, 3.87361979983558*^9, 
   3.873619938604599*^9, 3.873620552458734*^9, 3.873621456358457*^9, 
   3.8736536395043993`*^9, 3.873653697978847*^9, {3.8736537605376453`*^9, 
   3.873653786501913*^9}, 3.87365404387046*^9, 3.873654361803931*^9, {
   3.87372155376371*^9, 3.873721561299271*^9}, 3.873721650734617*^9, 
   3.8737219024108458`*^9, 3.873722043428874*^9, 3.873722123634899*^9, 
   3.873723234480323*^9},
 CellLabel->
  "During evaluation of \
In[57]:=",ExpressionUUID->"2e88c905-5baf-480e-b6a9-02587fa2e3f4"],

Cell[BoxData["200"], "Print",
 CellChangeTimes->{
  3.873460359121327*^9, 3.873472184817514*^9, 3.873514600528822*^9, {
   3.873619706528304*^9, 3.873619723121772*^9}, 3.87361979983558*^9, 
   3.873619938604599*^9, 3.873620552458734*^9, 3.873621456358457*^9, 
   3.8736536395043993`*^9, 3.873653697978847*^9, {3.8736537605376453`*^9, 
   3.873653786501913*^9}, 3.87365404387046*^9, 3.873654361803931*^9, {
   3.87372155376371*^9, 3.873721561299271*^9}, 3.873721650734617*^9, 
   3.8737219024108458`*^9, 3.873722043428874*^9, 3.873722123634899*^9, 
   3.873723312653884*^9},
 CellLabel->
  "During evaluation of \
In[57]:=",ExpressionUUID->"859da008-7dec-4a9f-a938-32f835b40cb5"],

Cell[BoxData["250"], "Print",
 CellChangeTimes->{
  3.873460359121327*^9, 3.873472184817514*^9, 3.873514600528822*^9, {
   3.873619706528304*^9, 3.873619723121772*^9}, 3.87361979983558*^9, 
   3.873619938604599*^9, 3.873620552458734*^9, 3.873621456358457*^9, 
   3.8736536395043993`*^9, 3.873653697978847*^9, {3.8736537605376453`*^9, 
   3.873653786501913*^9}, 3.87365404387046*^9, 3.873654361803931*^9, {
   3.87372155376371*^9, 3.873721561299271*^9}, 3.873721650734617*^9, 
   3.8737219024108458`*^9, 3.873722043428874*^9, 3.873722123634899*^9, 
   3.8737233909888678`*^9},
 CellLabel->
  "During evaluation of \
In[57]:=",ExpressionUUID->"e9f76aae-7bdb-41c4-83f6-7df270d84809"],

Cell[BoxData["300"], "Print",
 CellChangeTimes->{
  3.873460359121327*^9, 3.873472184817514*^9, 3.873514600528822*^9, {
   3.873619706528304*^9, 3.873619723121772*^9}, 3.87361979983558*^9, 
   3.873619938604599*^9, 3.873620552458734*^9, 3.873621456358457*^9, 
   3.8736536395043993`*^9, 3.873653697978847*^9, {3.8736537605376453`*^9, 
   3.873653786501913*^9}, 3.87365404387046*^9, 3.873654361803931*^9, {
   3.87372155376371*^9, 3.873721561299271*^9}, 3.873721650734617*^9, 
   3.8737219024108458`*^9, 3.873722043428874*^9, 3.873722123634899*^9, 
   3.873723469675411*^9},
 CellLabel->
  "During evaluation of \
In[57]:=",ExpressionUUID->"8bacb917-6654-45c0-9219-eb876e88e58b"],

Cell[BoxData["350"], "Print",
 CellChangeTimes->{
  3.873460359121327*^9, 3.873472184817514*^9, 3.873514600528822*^9, {
   3.873619706528304*^9, 3.873619723121772*^9}, 3.87361979983558*^9, 
   3.873619938604599*^9, 3.873620552458734*^9, 3.873621456358457*^9, 
   3.8736536395043993`*^9, 3.873653697978847*^9, {3.8736537605376453`*^9, 
   3.873653786501913*^9}, 3.87365404387046*^9, 3.873654361803931*^9, {
   3.87372155376371*^9, 3.873721561299271*^9}, 3.873721650734617*^9, 
   3.8737219024108458`*^9, 3.873722043428874*^9, 3.873722123634899*^9, 
   3.873723547523081*^9},
 CellLabel->
  "During evaluation of \
In[57]:=",ExpressionUUID->"5f5704b9-24c0-439e-a370-f005fd7a719f"],

Cell[BoxData["400"], "Print",
 CellChangeTimes->{
  3.873460359121327*^9, 3.873472184817514*^9, 3.873514600528822*^9, {
   3.873619706528304*^9, 3.873619723121772*^9}, 3.87361979983558*^9, 
   3.873619938604599*^9, 3.873620552458734*^9, 3.873621456358457*^9, 
   3.8736536395043993`*^9, 3.873653697978847*^9, {3.8736537605376453`*^9, 
   3.873653786501913*^9}, 3.87365404387046*^9, 3.873654361803931*^9, {
   3.87372155376371*^9, 3.873721561299271*^9}, 3.873721650734617*^9, 
   3.8737219024108458`*^9, 3.873722043428874*^9, 3.873722123634899*^9, 
   3.873723625994879*^9},
 CellLabel->
  "During evaluation of \
In[57]:=",ExpressionUUID->"7768daf9-3f91-499d-a5c6-66367dba54aa"],

Cell[BoxData["450"], "Print",
 CellChangeTimes->{
  3.873460359121327*^9, 3.873472184817514*^9, 3.873514600528822*^9, {
   3.873619706528304*^9, 3.873619723121772*^9}, 3.87361979983558*^9, 
   3.873619938604599*^9, 3.873620552458734*^9, 3.873621456358457*^9, 
   3.8736536395043993`*^9, 3.873653697978847*^9, {3.8736537605376453`*^9, 
   3.873653786501913*^9}, 3.87365404387046*^9, 3.873654361803931*^9, {
   3.87372155376371*^9, 3.873721561299271*^9}, 3.873721650734617*^9, 
   3.8737219024108458`*^9, 3.873722043428874*^9, 3.873722123634899*^9, 
   3.873723706792057*^9},
 CellLabel->
  "During evaluation of \
In[57]:=",ExpressionUUID->"e1908e47-bf7d-4323-90f8-28f9a678b0aa"],

Cell[BoxData["500"], "Print",
 CellChangeTimes->{
  3.873460359121327*^9, 3.873472184817514*^9, 3.873514600528822*^9, {
   3.873619706528304*^9, 3.873619723121772*^9}, 3.87361979983558*^9, 
   3.873619938604599*^9, 3.873620552458734*^9, 3.873621456358457*^9, 
   3.8736536395043993`*^9, 3.873653697978847*^9, {3.8736537605376453`*^9, 
   3.873653786501913*^9}, 3.87365404387046*^9, 3.873654361803931*^9, {
   3.87372155376371*^9, 3.873721561299271*^9}, 3.873721650734617*^9, 
   3.8737219024108458`*^9, 3.873722043428874*^9, 3.873722123634899*^9, 
   3.8737237869700823`*^9},
 CellLabel->
  "During evaluation of \
In[57]:=",ExpressionUUID->"c455a718-c54d-463e-b5b4-85016dd072f7"],

Cell[BoxData["550"], "Print",
 CellChangeTimes->{
  3.873460359121327*^9, 3.873472184817514*^9, 3.873514600528822*^9, {
   3.873619706528304*^9, 3.873619723121772*^9}, 3.87361979983558*^9, 
   3.873619938604599*^9, 3.873620552458734*^9, 3.873621456358457*^9, 
   3.8736536395043993`*^9, 3.873653697978847*^9, {3.8736537605376453`*^9, 
   3.873653786501913*^9}, 3.87365404387046*^9, 3.873654361803931*^9, {
   3.87372155376371*^9, 3.873721561299271*^9}, 3.873721650734617*^9, 
   3.8737219024108458`*^9, 3.873722043428874*^9, 3.873722123634899*^9, 
   3.873723865473668*^9},
 CellLabel->
  "During evaluation of \
In[57]:=",ExpressionUUID->"e79cff44-99e0-4351-a734-be7b595f17dc"],

Cell[BoxData["600"], "Print",
 CellChangeTimes->{
  3.873460359121327*^9, 3.873472184817514*^9, 3.873514600528822*^9, {
   3.873619706528304*^9, 3.873619723121772*^9}, 3.87361979983558*^9, 
   3.873619938604599*^9, 3.873620552458734*^9, 3.873621456358457*^9, 
   3.8736536395043993`*^9, 3.873653697978847*^9, {3.8736537605376453`*^9, 
   3.873653786501913*^9}, 3.87365404387046*^9, 3.873654361803931*^9, {
   3.87372155376371*^9, 3.873721561299271*^9}, 3.873721650734617*^9, 
   3.8737219024108458`*^9, 3.873722043428874*^9, 3.873722123634899*^9, 
   3.873723944129406*^9},
 CellLabel->
  "During evaluation of \
In[57]:=",ExpressionUUID->"fd17cc11-4293-42c0-9f75-73eae639ce7b"],

Cell[BoxData["650"], "Print",
 CellChangeTimes->{
  3.873460359121327*^9, 3.873472184817514*^9, 3.873514600528822*^9, {
   3.873619706528304*^9, 3.873619723121772*^9}, 3.87361979983558*^9, 
   3.873619938604599*^9, 3.873620552458734*^9, 3.873621456358457*^9, 
   3.8736536395043993`*^9, 3.873653697978847*^9, {3.8736537605376453`*^9, 
   3.873653786501913*^9}, 3.87365404387046*^9, 3.873654361803931*^9, {
   3.87372155376371*^9, 3.873721561299271*^9}, 3.873721650734617*^9, 
   3.8737219024108458`*^9, 3.873722043428874*^9, 3.873722123634899*^9, 
   3.8737240235057497`*^9},
 CellLabel->
  "During evaluation of \
In[57]:=",ExpressionUUID->"7a3a9f54-8489-48a7-a3bb-f896bea7c05d"],

Cell[BoxData["700"], "Print",
 CellChangeTimes->{
  3.873460359121327*^9, 3.873472184817514*^9, 3.873514600528822*^9, {
   3.873619706528304*^9, 3.873619723121772*^9}, 3.87361979983558*^9, 
   3.873619938604599*^9, 3.873620552458734*^9, 3.873621456358457*^9, 
   3.8736536395043993`*^9, 3.873653697978847*^9, {3.8736537605376453`*^9, 
   3.873653786501913*^9}, 3.87365404387046*^9, 3.873654361803931*^9, {
   3.87372155376371*^9, 3.873721561299271*^9}, 3.873721650734617*^9, 
   3.8737219024108458`*^9, 3.873722043428874*^9, 3.873722123634899*^9, 
   3.873724100999502*^9},
 CellLabel->
  "During evaluation of \
In[57]:=",ExpressionUUID->"54cc68c4-2eb5-40db-ad97-631dd11fa683"],

Cell[BoxData["750"], "Print",
 CellChangeTimes->{
  3.873460359121327*^9, 3.873472184817514*^9, 3.873514600528822*^9, {
   3.873619706528304*^9, 3.873619723121772*^9}, 3.87361979983558*^9, 
   3.873619938604599*^9, 3.873620552458734*^9, 3.873621456358457*^9, 
   3.8736536395043993`*^9, 3.873653697978847*^9, {3.8736537605376453`*^9, 
   3.873653786501913*^9}, 3.87365404387046*^9, 3.873654361803931*^9, {
   3.87372155376371*^9, 3.873721561299271*^9}, 3.873721650734617*^9, 
   3.8737219024108458`*^9, 3.873722043428874*^9, 3.873722123634899*^9, 
   3.873724180034786*^9},
 CellLabel->
  "During evaluation of \
In[57]:=",ExpressionUUID->"f4c7841f-1c18-4eb2-840a-21ce48ceacba"],

Cell[BoxData["800"], "Print",
 CellChangeTimes->{
  3.873460359121327*^9, 3.873472184817514*^9, 3.873514600528822*^9, {
   3.873619706528304*^9, 3.873619723121772*^9}, 3.87361979983558*^9, 
   3.873619938604599*^9, 3.873620552458734*^9, 3.873621456358457*^9, 
   3.8736536395043993`*^9, 3.873653697978847*^9, {3.8736537605376453`*^9, 
   3.873653786501913*^9}, 3.87365404387046*^9, 3.873654361803931*^9, {
   3.87372155376371*^9, 3.873721561299271*^9}, 3.873721650734617*^9, 
   3.8737219024108458`*^9, 3.873722043428874*^9, 3.873722123634899*^9, 
   3.873724258250898*^9},
 CellLabel->
  "During evaluation of \
In[57]:=",ExpressionUUID->"a0bf7ec9-0226-4d09-b050-d49f85198404"],

Cell[BoxData["850"], "Print",
 CellChangeTimes->{
  3.873460359121327*^9, 3.873472184817514*^9, 3.873514600528822*^9, {
   3.873619706528304*^9, 3.873619723121772*^9}, 3.87361979983558*^9, 
   3.873619938604599*^9, 3.873620552458734*^9, 3.873621456358457*^9, 
   3.8736536395043993`*^9, 3.873653697978847*^9, {3.8736537605376453`*^9, 
   3.873653786501913*^9}, 3.87365404387046*^9, 3.873654361803931*^9, {
   3.87372155376371*^9, 3.873721561299271*^9}, 3.873721650734617*^9, 
   3.8737219024108458`*^9, 3.873722043428874*^9, 3.873722123634899*^9, 
   3.873724336126183*^9},
 CellLabel->
  "During evaluation of \
In[57]:=",ExpressionUUID->"ec590334-9ce0-44e7-84fa-5eb881b51310"],

Cell[BoxData["900"], "Print",
 CellChangeTimes->{
  3.873460359121327*^9, 3.873472184817514*^9, 3.873514600528822*^9, {
   3.873619706528304*^9, 3.873619723121772*^9}, 3.87361979983558*^9, 
   3.873619938604599*^9, 3.873620552458734*^9, 3.873621456358457*^9, 
   3.8736536395043993`*^9, 3.873653697978847*^9, {3.8736537605376453`*^9, 
   3.873653786501913*^9}, 3.87365404387046*^9, 3.873654361803931*^9, {
   3.87372155376371*^9, 3.873721561299271*^9}, 3.873721650734617*^9, 
   3.8737219024108458`*^9, 3.873722043428874*^9, 3.873722123634899*^9, 
   3.8737244130305767`*^9},
 CellLabel->
  "During evaluation of \
In[57]:=",ExpressionUUID->"b1d49e63-74d0-490b-b476-eba08ce96c46"],

Cell[BoxData["950"], "Print",
 CellChangeTimes->{
  3.873460359121327*^9, 3.873472184817514*^9, 3.873514600528822*^9, {
   3.873619706528304*^9, 3.873619723121772*^9}, 3.87361979983558*^9, 
   3.873619938604599*^9, 3.873620552458734*^9, 3.873621456358457*^9, 
   3.8736536395043993`*^9, 3.873653697978847*^9, {3.8736537605376453`*^9, 
   3.873653786501913*^9}, 3.87365404387046*^9, 3.873654361803931*^9, {
   3.87372155376371*^9, 3.873721561299271*^9}, 3.873721650734617*^9, 
   3.8737219024108458`*^9, 3.873722043428874*^9, 3.873722123634899*^9, 
   3.8737244906599283`*^9},
 CellLabel->
  "During evaluation of \
In[57]:=",ExpressionUUID->"132597a9-c9bb-40e7-9bd2-f1cf5ffe86fd"],

Cell[BoxData["1000"], "Print",
 CellChangeTimes->{
  3.873460359121327*^9, 3.873472184817514*^9, 3.873514600528822*^9, {
   3.873619706528304*^9, 3.873619723121772*^9}, 3.87361979983558*^9, 
   3.873619938604599*^9, 3.873620552458734*^9, 3.873621456358457*^9, 
   3.8736536395043993`*^9, 3.873653697978847*^9, {3.8736537605376453`*^9, 
   3.873653786501913*^9}, 3.87365404387046*^9, 3.873654361803931*^9, {
   3.87372155376371*^9, 3.873721561299271*^9}, 3.873721650734617*^9, 
   3.8737219024108458`*^9, 3.873722043428874*^9, 3.873722123634899*^9, 
   3.873724569886199*^9},
 CellLabel->
  "During evaluation of \
In[57]:=",ExpressionUUID->"55261e13-bb1f-45bf-8632-31b90eb3dbe2"],

Cell[BoxData["1050"], "Print",
 CellChangeTimes->{
  3.873460359121327*^9, 3.873472184817514*^9, 3.873514600528822*^9, {
   3.873619706528304*^9, 3.873619723121772*^9}, 3.87361979983558*^9, 
   3.873619938604599*^9, 3.873620552458734*^9, 3.873621456358457*^9, 
   3.8736536395043993`*^9, 3.873653697978847*^9, {3.8736537605376453`*^9, 
   3.873653786501913*^9}, 3.87365404387046*^9, 3.873654361803931*^9, {
   3.87372155376371*^9, 3.873721561299271*^9}, 3.873721650734617*^9, 
   3.8737219024108458`*^9, 3.873722043428874*^9, 3.873722123634899*^9, 
   3.8737246492231627`*^9},
 CellLabel->
  "During evaluation of \
In[57]:=",ExpressionUUID->"5327b3ff-828d-46ce-a2c8-f4254b14f796"],

Cell[BoxData["1100"], "Print",
 CellChangeTimes->{
  3.873460359121327*^9, 3.873472184817514*^9, 3.873514600528822*^9, {
   3.873619706528304*^9, 3.873619723121772*^9}, 3.87361979983558*^9, 
   3.873619938604599*^9, 3.873620552458734*^9, 3.873621456358457*^9, 
   3.8736536395043993`*^9, 3.873653697978847*^9, {3.8736537605376453`*^9, 
   3.873653786501913*^9}, 3.87365404387046*^9, 3.873654361803931*^9, {
   3.87372155376371*^9, 3.873721561299271*^9}, 3.873721650734617*^9, 
   3.8737219024108458`*^9, 3.873722043428874*^9, 3.873722123634899*^9, 
   3.87372472812494*^9},
 CellLabel->
  "During evaluation of \
In[57]:=",ExpressionUUID->"27b715a9-6eae-44b3-aeee-4723f24f3866"],

Cell[BoxData["1150"], "Print",
 CellChangeTimes->{
  3.873460359121327*^9, 3.873472184817514*^9, 3.873514600528822*^9, {
   3.873619706528304*^9, 3.873619723121772*^9}, 3.87361979983558*^9, 
   3.873619938604599*^9, 3.873620552458734*^9, 3.873621456358457*^9, 
   3.8736536395043993`*^9, 3.873653697978847*^9, {3.8736537605376453`*^9, 
   3.873653786501913*^9}, 3.87365404387046*^9, 3.873654361803931*^9, {
   3.87372155376371*^9, 3.873721561299271*^9}, 3.873721650734617*^9, 
   3.8737219024108458`*^9, 3.873722043428874*^9, 3.873722123634899*^9, 
   3.8737248067088327`*^9},
 CellLabel->
  "During evaluation of \
In[57]:=",ExpressionUUID->"adf734ac-ff65-46be-9720-0159a4e57e9a"],

Cell[BoxData["1200"], "Print",
 CellChangeTimes->{
  3.873460359121327*^9, 3.873472184817514*^9, 3.873514600528822*^9, {
   3.873619706528304*^9, 3.873619723121772*^9}, 3.87361979983558*^9, 
   3.873619938604599*^9, 3.873620552458734*^9, 3.873621456358457*^9, 
   3.8736536395043993`*^9, 3.873653697978847*^9, {3.8736537605376453`*^9, 
   3.873653786501913*^9}, 3.87365404387046*^9, 3.873654361803931*^9, {
   3.87372155376371*^9, 3.873721561299271*^9}, 3.873721650734617*^9, 
   3.8737219024108458`*^9, 3.873722043428874*^9, 3.873722123634899*^9, 
   3.873724884949292*^9},
 CellLabel->
  "During evaluation of \
In[57]:=",ExpressionUUID->"eb05bb3e-10b6-4d25-a666-b3c2a9e4bc6c"],

Cell[BoxData["1250"], "Print",
 CellChangeTimes->{
  3.873460359121327*^9, 3.873472184817514*^9, 3.873514600528822*^9, {
   3.873619706528304*^9, 3.873619723121772*^9}, 3.87361979983558*^9, 
   3.873619938604599*^9, 3.873620552458734*^9, 3.873621456358457*^9, 
   3.8736536395043993`*^9, 3.873653697978847*^9, {3.8736537605376453`*^9, 
   3.873653786501913*^9}, 3.87365404387046*^9, 3.873654361803931*^9, {
   3.87372155376371*^9, 3.873721561299271*^9}, 3.873721650734617*^9, 
   3.8737219024108458`*^9, 3.873722043428874*^9, 3.873722123634899*^9, 
   3.873724963860703*^9},
 CellLabel->
  "During evaluation of \
In[57]:=",ExpressionUUID->"47550f38-9d07-407e-89ad-99aa316b5bfd"],

Cell[BoxData["1300"], "Print",
 CellChangeTimes->{
  3.873460359121327*^9, 3.873472184817514*^9, 3.873514600528822*^9, {
   3.873619706528304*^9, 3.873619723121772*^9}, 3.87361979983558*^9, 
   3.873619938604599*^9, 3.873620552458734*^9, 3.873621456358457*^9, 
   3.8736536395043993`*^9, 3.873653697978847*^9, {3.8736537605376453`*^9, 
   3.873653786501913*^9}, 3.87365404387046*^9, 3.873654361803931*^9, {
   3.87372155376371*^9, 3.873721561299271*^9}, 3.873721650734617*^9, 
   3.8737219024108458`*^9, 3.873722043428874*^9, 3.873722123634899*^9, 
   3.873725043784926*^9},
 CellLabel->
  "During evaluation of \
In[57]:=",ExpressionUUID->"cf67b998-b620-43ae-8641-93cc6ee100f0"],

Cell[BoxData["1350"], "Print",
 CellChangeTimes->{
  3.873460359121327*^9, 3.873472184817514*^9, 3.873514600528822*^9, {
   3.873619706528304*^9, 3.873619723121772*^9}, 3.87361979983558*^9, 
   3.873619938604599*^9, 3.873620552458734*^9, 3.873621456358457*^9, 
   3.8736536395043993`*^9, 3.873653697978847*^9, {3.8736537605376453`*^9, 
   3.873653786501913*^9}, 3.87365404387046*^9, 3.873654361803931*^9, {
   3.87372155376371*^9, 3.873721561299271*^9}, 3.873721650734617*^9, 
   3.8737219024108458`*^9, 3.873722043428874*^9, 3.873722123634899*^9, 
   3.873725121531868*^9},
 CellLabel->
  "During evaluation of \
In[57]:=",ExpressionUUID->"6e6040a0-9f07-4c81-b432-42e6f134cc91"],

Cell[BoxData["1400"], "Print",
 CellChangeTimes->{
  3.873460359121327*^9, 3.873472184817514*^9, 3.873514600528822*^9, {
   3.873619706528304*^9, 3.873619723121772*^9}, 3.87361979983558*^9, 
   3.873619938604599*^9, 3.873620552458734*^9, 3.873621456358457*^9, 
   3.8736536395043993`*^9, 3.873653697978847*^9, {3.8736537605376453`*^9, 
   3.873653786501913*^9}, 3.87365404387046*^9, 3.873654361803931*^9, {
   3.87372155376371*^9, 3.873721561299271*^9}, 3.873721650734617*^9, 
   3.8737219024108458`*^9, 3.873722043428874*^9, 3.873722123634899*^9, 
   3.873725200048463*^9},
 CellLabel->
  "During evaluation of \
In[57]:=",ExpressionUUID->"464985e3-b79e-4743-88ae-0cf2579394de"],

Cell[BoxData["1450"], "Print",
 CellChangeTimes->{
  3.873460359121327*^9, 3.873472184817514*^9, 3.873514600528822*^9, {
   3.873619706528304*^9, 3.873619723121772*^9}, 3.87361979983558*^9, 
   3.873619938604599*^9, 3.873620552458734*^9, 3.873621456358457*^9, 
   3.8736536395043993`*^9, 3.873653697978847*^9, {3.8736537605376453`*^9, 
   3.873653786501913*^9}, 3.87365404387046*^9, 3.873654361803931*^9, {
   3.87372155376371*^9, 3.873721561299271*^9}, 3.873721650734617*^9, 
   3.8737219024108458`*^9, 3.873722043428874*^9, 3.873722123634899*^9, 
   3.873725278450253*^9},
 CellLabel->
  "During evaluation of \
In[57]:=",ExpressionUUID->"e86f8112-78d5-4426-ae07-6d7b14cfe809"],

Cell[BoxData["1500"], "Print",
 CellChangeTimes->{
  3.873460359121327*^9, 3.873472184817514*^9, 3.873514600528822*^9, {
   3.873619706528304*^9, 3.873619723121772*^9}, 3.87361979983558*^9, 
   3.873619938604599*^9, 3.873620552458734*^9, 3.873621456358457*^9, 
   3.8736536395043993`*^9, 3.873653697978847*^9, {3.8736537605376453`*^9, 
   3.873653786501913*^9}, 3.87365404387046*^9, 3.873654361803931*^9, {
   3.87372155376371*^9, 3.873721561299271*^9}, 3.873721650734617*^9, 
   3.8737219024108458`*^9, 3.873722043428874*^9, 3.873722123634899*^9, 
   3.8737253566462297`*^9},
 CellLabel->
  "During evaluation of \
In[57]:=",ExpressionUUID->"af81e591-ecdd-475d-82e9-8a266cda31b9"],

Cell[BoxData["1550"], "Print",
 CellChangeTimes->{
  3.873460359121327*^9, 3.873472184817514*^9, 3.873514600528822*^9, {
   3.873619706528304*^9, 3.873619723121772*^9}, 3.87361979983558*^9, 
   3.873619938604599*^9, 3.873620552458734*^9, 3.873621456358457*^9, 
   3.8736536395043993`*^9, 3.873653697978847*^9, {3.8736537605376453`*^9, 
   3.873653786501913*^9}, 3.87365404387046*^9, 3.873654361803931*^9, {
   3.87372155376371*^9, 3.873721561299271*^9}, 3.873721650734617*^9, 
   3.8737219024108458`*^9, 3.873722043428874*^9, 3.873722123634899*^9, 
   3.873725434222971*^9},
 CellLabel->
  "During evaluation of \
In[57]:=",ExpressionUUID->"006e60fb-f7fa-443f-b491-fb000ad730c1"],

Cell[BoxData["1600"], "Print",
 CellChangeTimes->{
  3.873460359121327*^9, 3.873472184817514*^9, 3.873514600528822*^9, {
   3.873619706528304*^9, 3.873619723121772*^9}, 3.87361979983558*^9, 
   3.873619938604599*^9, 3.873620552458734*^9, 3.873621456358457*^9, 
   3.8736536395043993`*^9, 3.873653697978847*^9, {3.8736537605376453`*^9, 
   3.873653786501913*^9}, 3.87365404387046*^9, 3.873654361803931*^9, {
   3.87372155376371*^9, 3.873721561299271*^9}, 3.873721650734617*^9, 
   3.8737219024108458`*^9, 3.873722043428874*^9, 3.873722123634899*^9, 
   3.873725514026573*^9},
 CellLabel->
  "During evaluation of \
In[57]:=",ExpressionUUID->"a5c6e86b-3961-4174-9850-d6bbf19403b0"],

Cell[BoxData["1650"], "Print",
 CellChangeTimes->{
  3.873460359121327*^9, 3.873472184817514*^9, 3.873514600528822*^9, {
   3.873619706528304*^9, 3.873619723121772*^9}, 3.87361979983558*^9, 
   3.873619938604599*^9, 3.873620552458734*^9, 3.873621456358457*^9, 
   3.8736536395043993`*^9, 3.873653697978847*^9, {3.8736537605376453`*^9, 
   3.873653786501913*^9}, 3.87365404387046*^9, 3.873654361803931*^9, {
   3.87372155376371*^9, 3.873721561299271*^9}, 3.873721650734617*^9, 
   3.8737219024108458`*^9, 3.873722043428874*^9, 3.873722123634899*^9, 
   3.8737255934025717`*^9},
 CellLabel->
  "During evaluation of \
In[57]:=",ExpressionUUID->"52995203-5bbf-40a0-8861-632fc5282448"],

Cell[BoxData["1700"], "Print",
 CellChangeTimes->{
  3.873460359121327*^9, 3.873472184817514*^9, 3.873514600528822*^9, {
   3.873619706528304*^9, 3.873619723121772*^9}, 3.87361979983558*^9, 
   3.873619938604599*^9, 3.873620552458734*^9, 3.873621456358457*^9, 
   3.8736536395043993`*^9, 3.873653697978847*^9, {3.8736537605376453`*^9, 
   3.873653786501913*^9}, 3.87365404387046*^9, 3.873654361803931*^9, {
   3.87372155376371*^9, 3.873721561299271*^9}, 3.873721650734617*^9, 
   3.8737219024108458`*^9, 3.873722043428874*^9, 3.873722123634899*^9, 
   3.8737256729019814`*^9},
 CellLabel->
  "During evaluation of \
In[57]:=",ExpressionUUID->"eb0e7b57-f5b5-4acd-8978-baa36d559521"],

Cell[BoxData["1750"], "Print",
 CellChangeTimes->{
  3.873460359121327*^9, 3.873472184817514*^9, 3.873514600528822*^9, {
   3.873619706528304*^9, 3.873619723121772*^9}, 3.87361979983558*^9, 
   3.873619938604599*^9, 3.873620552458734*^9, 3.873621456358457*^9, 
   3.8736536395043993`*^9, 3.873653697978847*^9, {3.8736537605376453`*^9, 
   3.873653786501913*^9}, 3.87365404387046*^9, 3.873654361803931*^9, {
   3.87372155376371*^9, 3.873721561299271*^9}, 3.873721650734617*^9, 
   3.8737219024108458`*^9, 3.873722043428874*^9, 3.873722123634899*^9, 
   3.8737257524247437`*^9},
 CellLabel->
  "During evaluation of \
In[57]:=",ExpressionUUID->"1aa86244-03d3-48e9-b9c4-e28a8ecaba44"],

Cell[BoxData["1800"], "Print",
 CellChangeTimes->{
  3.873460359121327*^9, 3.873472184817514*^9, 3.873514600528822*^9, {
   3.873619706528304*^9, 3.873619723121772*^9}, 3.87361979983558*^9, 
   3.873619938604599*^9, 3.873620552458734*^9, 3.873621456358457*^9, 
   3.8736536395043993`*^9, 3.873653697978847*^9, {3.8736537605376453`*^9, 
   3.873653786501913*^9}, 3.87365404387046*^9, 3.873654361803931*^9, {
   3.87372155376371*^9, 3.873721561299271*^9}, 3.873721650734617*^9, 
   3.8737219024108458`*^9, 3.873722043428874*^9, 3.873722123634899*^9, 
   3.873725832397623*^9},
 CellLabel->
  "During evaluation of \
In[57]:=",ExpressionUUID->"00bddfdf-d836-4e31-8305-e5985545049e"],

Cell[BoxData["1850"], "Print",
 CellChangeTimes->{
  3.873460359121327*^9, 3.873472184817514*^9, 3.873514600528822*^9, {
   3.873619706528304*^9, 3.873619723121772*^9}, 3.87361979983558*^9, 
   3.873619938604599*^9, 3.873620552458734*^9, 3.873621456358457*^9, 
   3.8736536395043993`*^9, 3.873653697978847*^9, {3.8736537605376453`*^9, 
   3.873653786501913*^9}, 3.87365404387046*^9, 3.873654361803931*^9, {
   3.87372155376371*^9, 3.873721561299271*^9}, 3.873721650734617*^9, 
   3.8737219024108458`*^9, 3.873722043428874*^9, 3.873722123634899*^9, 
   3.8737259106300097`*^9},
 CellLabel->
  "During evaluation of \
In[57]:=",ExpressionUUID->"746dd437-cdbf-4e57-bad3-54743d38c661"],

Cell[BoxData["1900"], "Print",
 CellChangeTimes->{
  3.873460359121327*^9, 3.873472184817514*^9, 3.873514600528822*^9, {
   3.873619706528304*^9, 3.873619723121772*^9}, 3.87361979983558*^9, 
   3.873619938604599*^9, 3.873620552458734*^9, 3.873621456358457*^9, 
   3.8736536395043993`*^9, 3.873653697978847*^9, {3.8736537605376453`*^9, 
   3.873653786501913*^9}, 3.87365404387046*^9, 3.873654361803931*^9, {
   3.87372155376371*^9, 3.873721561299271*^9}, 3.873721650734617*^9, 
   3.8737219024108458`*^9, 3.873722043428874*^9, 3.873722123634899*^9, 
   3.87372598962276*^9},
 CellLabel->
  "During evaluation of \
In[57]:=",ExpressionUUID->"c4a070b2-1f42-4256-b602-b2917b26b0bd"],

Cell[BoxData["1950"], "Print",
 CellChangeTimes->{
  3.873460359121327*^9, 3.873472184817514*^9, 3.873514600528822*^9, {
   3.873619706528304*^9, 3.873619723121772*^9}, 3.87361979983558*^9, 
   3.873619938604599*^9, 3.873620552458734*^9, 3.873621456358457*^9, 
   3.8736536395043993`*^9, 3.873653697978847*^9, {3.8736537605376453`*^9, 
   3.873653786501913*^9}, 3.87365404387046*^9, 3.873654361803931*^9, {
   3.87372155376371*^9, 3.873721561299271*^9}, 3.873721650734617*^9, 
   3.8737219024108458`*^9, 3.873722043428874*^9, 3.873722123634899*^9, 
   3.873726069290053*^9},
 CellLabel->
  "During evaluation of \
In[57]:=",ExpressionUUID->"7025460b-ba94-4cc4-a946-b907d910580f"],

Cell[BoxData["2000"], "Print",
 CellChangeTimes->{
  3.873460359121327*^9, 3.873472184817514*^9, 3.873514600528822*^9, {
   3.873619706528304*^9, 3.873619723121772*^9}, 3.87361979983558*^9, 
   3.873619938604599*^9, 3.873620552458734*^9, 3.873621456358457*^9, 
   3.8736536395043993`*^9, 3.873653697978847*^9, {3.8736537605376453`*^9, 
   3.873653786501913*^9}, 3.87365404387046*^9, 3.873654361803931*^9, {
   3.87372155376371*^9, 3.873721561299271*^9}, 3.873721650734617*^9, 
   3.8737219024108458`*^9, 3.873722043428874*^9, 3.873722123634899*^9, 
   3.873726147892231*^9},
 CellLabel->
  "During evaluation of \
In[57]:=",ExpressionUUID->"9601e2b9-2f44-43c9-a2f1-9e5c6e82e09b"],

Cell[BoxData["2050"], "Print",
 CellChangeTimes->{
  3.873460359121327*^9, 3.873472184817514*^9, 3.873514600528822*^9, {
   3.873619706528304*^9, 3.873619723121772*^9}, 3.87361979983558*^9, 
   3.873619938604599*^9, 3.873620552458734*^9, 3.873621456358457*^9, 
   3.8736536395043993`*^9, 3.873653697978847*^9, {3.8736537605376453`*^9, 
   3.873653786501913*^9}, 3.87365404387046*^9, 3.873654361803931*^9, {
   3.87372155376371*^9, 3.873721561299271*^9}, 3.873721650734617*^9, 
   3.8737219024108458`*^9, 3.873722043428874*^9, 3.873722123634899*^9, 
   3.873726226500655*^9},
 CellLabel->
  "During evaluation of \
In[57]:=",ExpressionUUID->"7d6a6ba5-8191-4fe4-a6e0-4c8e310f7f5e"],

Cell[BoxData["2100"], "Print",
 CellChangeTimes->{
  3.873460359121327*^9, 3.873472184817514*^9, 3.873514600528822*^9, {
   3.873619706528304*^9, 3.873619723121772*^9}, 3.87361979983558*^9, 
   3.873619938604599*^9, 3.873620552458734*^9, 3.873621456358457*^9, 
   3.8736536395043993`*^9, 3.873653697978847*^9, {3.8736537605376453`*^9, 
   3.873653786501913*^9}, 3.87365404387046*^9, 3.873654361803931*^9, {
   3.87372155376371*^9, 3.873721561299271*^9}, 3.873721650734617*^9, 
   3.8737219024108458`*^9, 3.873722043428874*^9, 3.873722123634899*^9, 
   3.873726304849172*^9},
 CellLabel->
  "During evaluation of \
In[57]:=",ExpressionUUID->"e0bf8cf7-c113-42d8-8ebf-8fce73c9361c"],

Cell[BoxData["2150"], "Print",
 CellChangeTimes->{
  3.873460359121327*^9, 3.873472184817514*^9, 3.873514600528822*^9, {
   3.873619706528304*^9, 3.873619723121772*^9}, 3.87361979983558*^9, 
   3.873619938604599*^9, 3.873620552458734*^9, 3.873621456358457*^9, 
   3.8736536395043993`*^9, 3.873653697978847*^9, {3.8736537605376453`*^9, 
   3.873653786501913*^9}, 3.87365404387046*^9, 3.873654361803931*^9, {
   3.87372155376371*^9, 3.873721561299271*^9}, 3.873721650734617*^9, 
   3.8737219024108458`*^9, 3.873722043428874*^9, 3.873722123634899*^9, 
   3.873726382752989*^9},
 CellLabel->
  "During evaluation of \
In[57]:=",ExpressionUUID->"f07687b6-9e93-46ce-a36a-7dd45f43d2ce"],

Cell[BoxData["2200"], "Print",
 CellChangeTimes->{
  3.873460359121327*^9, 3.873472184817514*^9, 3.873514600528822*^9, {
   3.873619706528304*^9, 3.873619723121772*^9}, 3.87361979983558*^9, 
   3.873619938604599*^9, 3.873620552458734*^9, 3.873621456358457*^9, 
   3.8736536395043993`*^9, 3.873653697978847*^9, {3.8736537605376453`*^9, 
   3.873653786501913*^9}, 3.87365404387046*^9, 3.873654361803931*^9, {
   3.87372155376371*^9, 3.873721561299271*^9}, 3.873721650734617*^9, 
   3.8737219024108458`*^9, 3.873722043428874*^9, 3.873722123634899*^9, 
   3.873726461741716*^9},
 CellLabel->
  "During evaluation of \
In[57]:=",ExpressionUUID->"bbcebb05-f38b-4066-921f-cb4722d1500b"],

Cell[BoxData["2250"], "Print",
 CellChangeTimes->{
  3.873460359121327*^9, 3.873472184817514*^9, 3.873514600528822*^9, {
   3.873619706528304*^9, 3.873619723121772*^9}, 3.87361979983558*^9, 
   3.873619938604599*^9, 3.873620552458734*^9, 3.873621456358457*^9, 
   3.8736536395043993`*^9, 3.873653697978847*^9, {3.8736537605376453`*^9, 
   3.873653786501913*^9}, 3.87365404387046*^9, 3.873654361803931*^9, {
   3.87372155376371*^9, 3.873721561299271*^9}, 3.873721650734617*^9, 
   3.8737219024108458`*^9, 3.873722043428874*^9, 3.873722123634899*^9, 
   3.873726539919458*^9},
 CellLabel->
  "During evaluation of \
In[57]:=",ExpressionUUID->"57489057-1dea-4771-89e8-82b928582ced"],

Cell[BoxData["2300"], "Print",
 CellChangeTimes->{
  3.873460359121327*^9, 3.873472184817514*^9, 3.873514600528822*^9, {
   3.873619706528304*^9, 3.873619723121772*^9}, 3.87361979983558*^9, 
   3.873619938604599*^9, 3.873620552458734*^9, 3.873621456358457*^9, 
   3.8736536395043993`*^9, 3.873653697978847*^9, {3.8736537605376453`*^9, 
   3.873653786501913*^9}, 3.87365404387046*^9, 3.873654361803931*^9, {
   3.87372155376371*^9, 3.873721561299271*^9}, 3.873721650734617*^9, 
   3.8737219024108458`*^9, 3.873722043428874*^9, 3.873722123634899*^9, 
   3.873726619510173*^9},
 CellLabel->
  "During evaluation of \
In[57]:=",ExpressionUUID->"2dcbcb74-0814-47bc-b961-56e3c24fff66"],

Cell[BoxData["2350"], "Print",
 CellChangeTimes->{
  3.873460359121327*^9, 3.873472184817514*^9, 3.873514600528822*^9, {
   3.873619706528304*^9, 3.873619723121772*^9}, 3.87361979983558*^9, 
   3.873619938604599*^9, 3.873620552458734*^9, 3.873621456358457*^9, 
   3.8736536395043993`*^9, 3.873653697978847*^9, {3.8736537605376453`*^9, 
   3.873653786501913*^9}, 3.87365404387046*^9, 3.873654361803931*^9, {
   3.87372155376371*^9, 3.873721561299271*^9}, 3.873721650734617*^9, 
   3.8737219024108458`*^9, 3.873722043428874*^9, 3.873722123634899*^9, 
   3.8737266974423*^9},
 CellLabel->
  "During evaluation of \
In[57]:=",ExpressionUUID->"200a6e5e-c19c-4fb0-8541-b27094f8028a"],

Cell[BoxData["2400"], "Print",
 CellChangeTimes->{
  3.873460359121327*^9, 3.873472184817514*^9, 3.873514600528822*^9, {
   3.873619706528304*^9, 3.873619723121772*^9}, 3.87361979983558*^9, 
   3.873619938604599*^9, 3.873620552458734*^9, 3.873621456358457*^9, 
   3.8736536395043993`*^9, 3.873653697978847*^9, {3.8736537605376453`*^9, 
   3.873653786501913*^9}, 3.87365404387046*^9, 3.873654361803931*^9, {
   3.87372155376371*^9, 3.873721561299271*^9}, 3.873721650734617*^9, 
   3.8737219024108458`*^9, 3.873722043428874*^9, 3.873722123634899*^9, 
   3.873726776283493*^9},
 CellLabel->
  "During evaluation of \
In[57]:=",ExpressionUUID->"2f661c28-2263-47a9-a374-fd1c452cccbf"],

Cell[BoxData["2450"], "Print",
 CellChangeTimes->{
  3.873460359121327*^9, 3.873472184817514*^9, 3.873514600528822*^9, {
   3.873619706528304*^9, 3.873619723121772*^9}, 3.87361979983558*^9, 
   3.873619938604599*^9, 3.873620552458734*^9, 3.873621456358457*^9, 
   3.8736536395043993`*^9, 3.873653697978847*^9, {3.8736537605376453`*^9, 
   3.873653786501913*^9}, 3.87365404387046*^9, 3.873654361803931*^9, {
   3.87372155376371*^9, 3.873721561299271*^9}, 3.873721650734617*^9, 
   3.8737219024108458`*^9, 3.873722043428874*^9, 3.873722123634899*^9, 
   3.8737268547719183`*^9},
 CellLabel->
  "During evaluation of \
In[57]:=",ExpressionUUID->"19d8aafb-560a-4d57-b95c-2a232aa7c2b4"],

Cell[BoxData["2500"], "Print",
 CellChangeTimes->{
  3.873460359121327*^9, 3.873472184817514*^9, 3.873514600528822*^9, {
   3.873619706528304*^9, 3.873619723121772*^9}, 3.87361979983558*^9, 
   3.873619938604599*^9, 3.873620552458734*^9, 3.873621456358457*^9, 
   3.8736536395043993`*^9, 3.873653697978847*^9, {3.8736537605376453`*^9, 
   3.873653786501913*^9}, 3.87365404387046*^9, 3.873654361803931*^9, {
   3.87372155376371*^9, 3.873721561299271*^9}, 3.873721650734617*^9, 
   3.8737219024108458`*^9, 3.873722043428874*^9, 3.873722123634899*^9, 
   3.873726933162777*^9},
 CellLabel->
  "During evaluation of \
In[57]:=",ExpressionUUID->"cbeef492-9746-48c3-afe0-25e1429f7683"],

Cell[BoxData["2550"], "Print",
 CellChangeTimes->{
  3.873460359121327*^9, 3.873472184817514*^9, 3.873514600528822*^9, {
   3.873619706528304*^9, 3.873619723121772*^9}, 3.87361979983558*^9, 
   3.873619938604599*^9, 3.873620552458734*^9, 3.873621456358457*^9, 
   3.8736536395043993`*^9, 3.873653697978847*^9, {3.8736537605376453`*^9, 
   3.873653786501913*^9}, 3.87365404387046*^9, 3.873654361803931*^9, {
   3.87372155376371*^9, 3.873721561299271*^9}, 3.873721650734617*^9, 
   3.8737219024108458`*^9, 3.873722043428874*^9, 3.873722123634899*^9, 
   3.8737270111291647`*^9},
 CellLabel->
  "During evaluation of \
In[57]:=",ExpressionUUID->"af1b22d4-24e1-4e5c-bc79-3a805a9deb65"],

Cell[BoxData["2600"], "Print",
 CellChangeTimes->{
  3.873460359121327*^9, 3.873472184817514*^9, 3.873514600528822*^9, {
   3.873619706528304*^9, 3.873619723121772*^9}, 3.87361979983558*^9, 
   3.873619938604599*^9, 3.873620552458734*^9, 3.873621456358457*^9, 
   3.8736536395043993`*^9, 3.873653697978847*^9, {3.8736537605376453`*^9, 
   3.873653786501913*^9}, 3.87365404387046*^9, 3.873654361803931*^9, {
   3.87372155376371*^9, 3.873721561299271*^9}, 3.873721650734617*^9, 
   3.8737219024108458`*^9, 3.873722043428874*^9, 3.873722123634899*^9, 
   3.873727089705963*^9},
 CellLabel->
  "During evaluation of \
In[57]:=",ExpressionUUID->"ca3f61bd-e4c4-45a6-b91c-bed36c1fda32"],

Cell[BoxData["2650"], "Print",
 CellChangeTimes->{
  3.873460359121327*^9, 3.873472184817514*^9, 3.873514600528822*^9, {
   3.873619706528304*^9, 3.873619723121772*^9}, 3.87361979983558*^9, 
   3.873619938604599*^9, 3.873620552458734*^9, 3.873621456358457*^9, 
   3.8736536395043993`*^9, 3.873653697978847*^9, {3.8736537605376453`*^9, 
   3.873653786501913*^9}, 3.87365404387046*^9, 3.873654361803931*^9, {
   3.87372155376371*^9, 3.873721561299271*^9}, 3.873721650734617*^9, 
   3.8737219024108458`*^9, 3.873722043428874*^9, 3.873722123634899*^9, 
   3.873727169174025*^9},
 CellLabel->
  "During evaluation of \
In[57]:=",ExpressionUUID->"3dbf5aa9-3033-455e-8dd9-e322b1a2e31c"],

Cell[BoxData["2700"], "Print",
 CellChangeTimes->{
  3.873460359121327*^9, 3.873472184817514*^9, 3.873514600528822*^9, {
   3.873619706528304*^9, 3.873619723121772*^9}, 3.87361979983558*^9, 
   3.873619938604599*^9, 3.873620552458734*^9, 3.873621456358457*^9, 
   3.8736536395043993`*^9, 3.873653697978847*^9, {3.8736537605376453`*^9, 
   3.873653786501913*^9}, 3.87365404387046*^9, 3.873654361803931*^9, {
   3.87372155376371*^9, 3.873721561299271*^9}, 3.873721650734617*^9, 
   3.8737219024108458`*^9, 3.873722043428874*^9, 3.873722123634899*^9, 
   3.873727248198577*^9},
 CellLabel->
  "During evaluation of \
In[57]:=",ExpressionUUID->"83039675-f9aa-48c4-a8f5-4d22a34b2222"],

Cell[BoxData["2750"], "Print",
 CellChangeTimes->{
  3.873460359121327*^9, 3.873472184817514*^9, 3.873514600528822*^9, {
   3.873619706528304*^9, 3.873619723121772*^9}, 3.87361979983558*^9, 
   3.873619938604599*^9, 3.873620552458734*^9, 3.873621456358457*^9, 
   3.8736536395043993`*^9, 3.873653697978847*^9, {3.8736537605376453`*^9, 
   3.873653786501913*^9}, 3.87365404387046*^9, 3.873654361803931*^9, {
   3.87372155376371*^9, 3.873721561299271*^9}, 3.873721650734617*^9, 
   3.8737219024108458`*^9, 3.873722043428874*^9, 3.873722123634899*^9, 
   3.873727327338848*^9},
 CellLabel->
  "During evaluation of \
In[57]:=",ExpressionUUID->"b06d4e36-ede3-4d04-8cf6-5c0a71cee5d5"],

Cell[BoxData["2800"], "Print",
 CellChangeTimes->{
  3.873460359121327*^9, 3.873472184817514*^9, 3.873514600528822*^9, {
   3.873619706528304*^9, 3.873619723121772*^9}, 3.87361979983558*^9, 
   3.873619938604599*^9, 3.873620552458734*^9, 3.873621456358457*^9, 
   3.8736536395043993`*^9, 3.873653697978847*^9, {3.8736537605376453`*^9, 
   3.873653786501913*^9}, 3.87365404387046*^9, 3.873654361803931*^9, {
   3.87372155376371*^9, 3.873721561299271*^9}, 3.873721650734617*^9, 
   3.8737219024108458`*^9, 3.873722043428874*^9, 3.873722123634899*^9, 
   3.873727405357355*^9},
 CellLabel->
  "During evaluation of \
In[57]:=",ExpressionUUID->"19b3c102-09ef-4c8c-bc83-6605eb2919d2"],

Cell[BoxData["2850"], "Print",
 CellChangeTimes->{
  3.873460359121327*^9, 3.873472184817514*^9, 3.873514600528822*^9, {
   3.873619706528304*^9, 3.873619723121772*^9}, 3.87361979983558*^9, 
   3.873619938604599*^9, 3.873620552458734*^9, 3.873621456358457*^9, 
   3.8736536395043993`*^9, 3.873653697978847*^9, {3.8736537605376453`*^9, 
   3.873653786501913*^9}, 3.87365404387046*^9, 3.873654361803931*^9, {
   3.87372155376371*^9, 3.873721561299271*^9}, 3.873721650734617*^9, 
   3.8737219024108458`*^9, 3.873722043428874*^9, 3.873722123634899*^9, 
   3.873727485336432*^9},
 CellLabel->
  "During evaluation of \
In[57]:=",ExpressionUUID->"04258376-50aa-460e-bb07-7e748b0d3e99"],

Cell[BoxData["2900"], "Print",
 CellChangeTimes->{
  3.873460359121327*^9, 3.873472184817514*^9, 3.873514600528822*^9, {
   3.873619706528304*^9, 3.873619723121772*^9}, 3.87361979983558*^9, 
   3.873619938604599*^9, 3.873620552458734*^9, 3.873621456358457*^9, 
   3.8736536395043993`*^9, 3.873653697978847*^9, {3.8736537605376453`*^9, 
   3.873653786501913*^9}, 3.87365404387046*^9, 3.873654361803931*^9, {
   3.87372155376371*^9, 3.873721561299271*^9}, 3.873721650734617*^9, 
   3.8737219024108458`*^9, 3.873722043428874*^9, 3.873722123634899*^9, 
   3.873727563166671*^9},
 CellLabel->
  "During evaluation of \
In[57]:=",ExpressionUUID->"d4e79008-9076-4111-81c5-80bbfd5988ea"],

Cell[BoxData["2950"], "Print",
 CellChangeTimes->{
  3.873460359121327*^9, 3.873472184817514*^9, 3.873514600528822*^9, {
   3.873619706528304*^9, 3.873619723121772*^9}, 3.87361979983558*^9, 
   3.873619938604599*^9, 3.873620552458734*^9, 3.873621456358457*^9, 
   3.8736536395043993`*^9, 3.873653697978847*^9, {3.8736537605376453`*^9, 
   3.873653786501913*^9}, 3.87365404387046*^9, 3.873654361803931*^9, {
   3.87372155376371*^9, 3.873721561299271*^9}, 3.873721650734617*^9, 
   3.8737219024108458`*^9, 3.873722043428874*^9, 3.873722123634899*^9, 
   3.8737276412177343`*^9},
 CellLabel->
  "During evaluation of \
In[57]:=",ExpressionUUID->"b2afb492-ae3e-4ba6-b912-196e652fd63b"],

Cell[BoxData["3000"], "Print",
 CellChangeTimes->{
  3.873460359121327*^9, 3.873472184817514*^9, 3.873514600528822*^9, {
   3.873619706528304*^9, 3.873619723121772*^9}, 3.87361979983558*^9, 
   3.873619938604599*^9, 3.873620552458734*^9, 3.873621456358457*^9, 
   3.8736536395043993`*^9, 3.873653697978847*^9, {3.8736537605376453`*^9, 
   3.873653786501913*^9}, 3.87365404387046*^9, 3.873654361803931*^9, {
   3.87372155376371*^9, 3.873721561299271*^9}, 3.873721650734617*^9, 
   3.8737219024108458`*^9, 3.873722043428874*^9, 3.873722123634899*^9, 
   3.873727718967355*^9},
 CellLabel->
  "During evaluation of \
In[57]:=",ExpressionUUID->"f2a1e509-fee5-4496-8869-4d014508c78e"],

Cell[BoxData["3050"], "Print",
 CellChangeTimes->{
  3.873460359121327*^9, 3.873472184817514*^9, 3.873514600528822*^9, {
   3.873619706528304*^9, 3.873619723121772*^9}, 3.87361979983558*^9, 
   3.873619938604599*^9, 3.873620552458734*^9, 3.873621456358457*^9, 
   3.8736536395043993`*^9, 3.873653697978847*^9, {3.8736537605376453`*^9, 
   3.873653786501913*^9}, 3.87365404387046*^9, 3.873654361803931*^9, {
   3.87372155376371*^9, 3.873721561299271*^9}, 3.873721650734617*^9, 
   3.8737219024108458`*^9, 3.873722043428874*^9, 3.873722123634899*^9, 
   3.873727796889888*^9},
 CellLabel->
  "During evaluation of \
In[57]:=",ExpressionUUID->"5a3316c9-bd57-4df0-8c2a-15547255091d"],

Cell[BoxData["3100"], "Print",
 CellChangeTimes->{
  3.873460359121327*^9, 3.873472184817514*^9, 3.873514600528822*^9, {
   3.873619706528304*^9, 3.873619723121772*^9}, 3.87361979983558*^9, 
   3.873619938604599*^9, 3.873620552458734*^9, 3.873621456358457*^9, 
   3.8736536395043993`*^9, 3.873653697978847*^9, {3.8736537605376453`*^9, 
   3.873653786501913*^9}, 3.87365404387046*^9, 3.873654361803931*^9, {
   3.87372155376371*^9, 3.873721561299271*^9}, 3.873721650734617*^9, 
   3.8737219024108458`*^9, 3.873722043428874*^9, 3.873722123634899*^9, 
   3.873727874517449*^9},
 CellLabel->
  "During evaluation of \
In[57]:=",ExpressionUUID->"84083f87-a213-4b6b-9469-e7c4e684eae9"],

Cell[BoxData["3150"], "Print",
 CellChangeTimes->{
  3.873460359121327*^9, 3.873472184817514*^9, 3.873514600528822*^9, {
   3.873619706528304*^9, 3.873619723121772*^9}, 3.87361979983558*^9, 
   3.873619938604599*^9, 3.873620552458734*^9, 3.873621456358457*^9, 
   3.8736536395043993`*^9, 3.873653697978847*^9, {3.8736537605376453`*^9, 
   3.873653786501913*^9}, 3.87365404387046*^9, 3.873654361803931*^9, {
   3.87372155376371*^9, 3.873721561299271*^9}, 3.873721650734617*^9, 
   3.8737219024108458`*^9, 3.873722043428874*^9, 3.873722123634899*^9, 
   3.873727951522026*^9},
 CellLabel->
  "During evaluation of \
In[57]:=",ExpressionUUID->"24a129a2-b43e-4c37-acee-4b3a45b5619d"],

Cell[BoxData["3200"], "Print",
 CellChangeTimes->{
  3.873460359121327*^9, 3.873472184817514*^9, 3.873514600528822*^9, {
   3.873619706528304*^9, 3.873619723121772*^9}, 3.87361979983558*^9, 
   3.873619938604599*^9, 3.873620552458734*^9, 3.873621456358457*^9, 
   3.8736536395043993`*^9, 3.873653697978847*^9, {3.8736537605376453`*^9, 
   3.873653786501913*^9}, 3.87365404387046*^9, 3.873654361803931*^9, {
   3.87372155376371*^9, 3.873721561299271*^9}, 3.873721650734617*^9, 
   3.8737219024108458`*^9, 3.873722043428874*^9, 3.873722123634899*^9, 
   3.8737280294285088`*^9},
 CellLabel->
  "During evaluation of \
In[57]:=",ExpressionUUID->"980612e9-f83f-4a13-b75d-32347360de51"],

Cell[BoxData["3250"], "Print",
 CellChangeTimes->{
  3.873460359121327*^9, 3.873472184817514*^9, 3.873514600528822*^9, {
   3.873619706528304*^9, 3.873619723121772*^9}, 3.87361979983558*^9, 
   3.873619938604599*^9, 3.873620552458734*^9, 3.873621456358457*^9, 
   3.8736536395043993`*^9, 3.873653697978847*^9, {3.8736537605376453`*^9, 
   3.873653786501913*^9}, 3.87365404387046*^9, 3.873654361803931*^9, {
   3.87372155376371*^9, 3.873721561299271*^9}, 3.873721650734617*^9, 
   3.8737219024108458`*^9, 3.873722043428874*^9, 3.873722123634899*^9, 
   3.87372810685109*^9},
 CellLabel->
  "During evaluation of \
In[57]:=",ExpressionUUID->"6d9c1fb1-6440-4ada-8482-a2776e4142b8"],

Cell[BoxData["3300"], "Print",
 CellChangeTimes->{
  3.873460359121327*^9, 3.873472184817514*^9, 3.873514600528822*^9, {
   3.873619706528304*^9, 3.873619723121772*^9}, 3.87361979983558*^9, 
   3.873619938604599*^9, 3.873620552458734*^9, 3.873621456358457*^9, 
   3.8736536395043993`*^9, 3.873653697978847*^9, {3.8736537605376453`*^9, 
   3.873653786501913*^9}, 3.87365404387046*^9, 3.873654361803931*^9, {
   3.87372155376371*^9, 3.873721561299271*^9}, 3.873721650734617*^9, 
   3.8737219024108458`*^9, 3.873722043428874*^9, 3.873722123634899*^9, 
   3.873728185200616*^9},
 CellLabel->
  "During evaluation of \
In[57]:=",ExpressionUUID->"9be5115c-3b5d-4f05-a599-4f173b0151d4"],

Cell[BoxData["3350"], "Print",
 CellChangeTimes->{
  3.873460359121327*^9, 3.873472184817514*^9, 3.873514600528822*^9, {
   3.873619706528304*^9, 3.873619723121772*^9}, 3.87361979983558*^9, 
   3.873619938604599*^9, 3.873620552458734*^9, 3.873621456358457*^9, 
   3.8736536395043993`*^9, 3.873653697978847*^9, {3.8736537605376453`*^9, 
   3.873653786501913*^9}, 3.87365404387046*^9, 3.873654361803931*^9, {
   3.87372155376371*^9, 3.873721561299271*^9}, 3.873721650734617*^9, 
   3.8737219024108458`*^9, 3.873722043428874*^9, 3.873722123634899*^9, 
   3.873728262794917*^9},
 CellLabel->
  "During evaluation of \
In[57]:=",ExpressionUUID->"af36ebca-9bf9-4ae6-8dec-ed4703e725ff"],

Cell[BoxData["3400"], "Print",
 CellChangeTimes->{
  3.873460359121327*^9, 3.873472184817514*^9, 3.873514600528822*^9, {
   3.873619706528304*^9, 3.873619723121772*^9}, 3.87361979983558*^9, 
   3.873619938604599*^9, 3.873620552458734*^9, 3.873621456358457*^9, 
   3.8736536395043993`*^9, 3.873653697978847*^9, {3.8736537605376453`*^9, 
   3.873653786501913*^9}, 3.87365404387046*^9, 3.873654361803931*^9, {
   3.87372155376371*^9, 3.873721561299271*^9}, 3.873721650734617*^9, 
   3.8737219024108458`*^9, 3.873722043428874*^9, 3.873722123634899*^9, 
   3.873728340834942*^9},
 CellLabel->
  "During evaluation of \
In[57]:=",ExpressionUUID->"c33be4e8-ac34-4e66-bf40-89b8b6ecdc1b"],

Cell[BoxData["3450"], "Print",
 CellChangeTimes->{
  3.873460359121327*^9, 3.873472184817514*^9, 3.873514600528822*^9, {
   3.873619706528304*^9, 3.873619723121772*^9}, 3.87361979983558*^9, 
   3.873619938604599*^9, 3.873620552458734*^9, 3.873621456358457*^9, 
   3.8736536395043993`*^9, 3.873653697978847*^9, {3.8736537605376453`*^9, 
   3.873653786501913*^9}, 3.87365404387046*^9, 3.873654361803931*^9, {
   3.87372155376371*^9, 3.873721561299271*^9}, 3.873721650734617*^9, 
   3.8737219024108458`*^9, 3.873722043428874*^9, 3.873722123634899*^9, 
   3.873728419174274*^9},
 CellLabel->
  "During evaluation of \
In[57]:=",ExpressionUUID->"881bab28-7a7a-4469-97ae-30ddf2f19f81"],

Cell[BoxData["3500"], "Print",
 CellChangeTimes->{
  3.873460359121327*^9, 3.873472184817514*^9, 3.873514600528822*^9, {
   3.873619706528304*^9, 3.873619723121772*^9}, 3.87361979983558*^9, 
   3.873619938604599*^9, 3.873620552458734*^9, 3.873621456358457*^9, 
   3.8736536395043993`*^9, 3.873653697978847*^9, {3.8736537605376453`*^9, 
   3.873653786501913*^9}, 3.87365404387046*^9, 3.873654361803931*^9, {
   3.87372155376371*^9, 3.873721561299271*^9}, 3.873721650734617*^9, 
   3.8737219024108458`*^9, 3.873722043428874*^9, 3.873722123634899*^9, 
   3.873728497794059*^9},
 CellLabel->
  "During evaluation of \
In[57]:=",ExpressionUUID->"79273bf2-e581-47ab-bba2-ba2fb811e2a4"],

Cell[BoxData["3550"], "Print",
 CellChangeTimes->{
  3.873460359121327*^9, 3.873472184817514*^9, 3.873514600528822*^9, {
   3.873619706528304*^9, 3.873619723121772*^9}, 3.87361979983558*^9, 
   3.873619938604599*^9, 3.873620552458734*^9, 3.873621456358457*^9, 
   3.8736536395043993`*^9, 3.873653697978847*^9, {3.8736537605376453`*^9, 
   3.873653786501913*^9}, 3.87365404387046*^9, 3.873654361803931*^9, {
   3.87372155376371*^9, 3.873721561299271*^9}, 3.873721650734617*^9, 
   3.8737219024108458`*^9, 3.873722043428874*^9, 3.873722123634899*^9, 
   3.873728575423641*^9},
 CellLabel->
  "During evaluation of \
In[57]:=",ExpressionUUID->"d47ba68f-1cfb-4f62-90c6-4d3500e829bf"],

Cell[BoxData["3600"], "Print",
 CellChangeTimes->{
  3.873460359121327*^9, 3.873472184817514*^9, 3.873514600528822*^9, {
   3.873619706528304*^9, 3.873619723121772*^9}, 3.87361979983558*^9, 
   3.873619938604599*^9, 3.873620552458734*^9, 3.873621456358457*^9, 
   3.8736536395043993`*^9, 3.873653697978847*^9, {3.8736537605376453`*^9, 
   3.873653786501913*^9}, 3.87365404387046*^9, 3.873654361803931*^9, {
   3.87372155376371*^9, 3.873721561299271*^9}, 3.873721650734617*^9, 
   3.8737219024108458`*^9, 3.873722043428874*^9, 3.873722123634899*^9, 
   3.873728653853161*^9},
 CellLabel->
  "During evaluation of \
In[57]:=",ExpressionUUID->"040ff2cc-ac77-4b1d-be85-04db873b0963"],

Cell[BoxData["3650"], "Print",
 CellChangeTimes->{
  3.873460359121327*^9, 3.873472184817514*^9, 3.873514600528822*^9, {
   3.873619706528304*^9, 3.873619723121772*^9}, 3.87361979983558*^9, 
   3.873619938604599*^9, 3.873620552458734*^9, 3.873621456358457*^9, 
   3.8736536395043993`*^9, 3.873653697978847*^9, {3.8736537605376453`*^9, 
   3.873653786501913*^9}, 3.87365404387046*^9, 3.873654361803931*^9, {
   3.87372155376371*^9, 3.873721561299271*^9}, 3.873721650734617*^9, 
   3.8737219024108458`*^9, 3.873722043428874*^9, 3.873722123634899*^9, 
   3.873728731001128*^9},
 CellLabel->
  "During evaluation of \
In[57]:=",ExpressionUUID->"e492d38e-64b4-41be-8fef-33fa48c07a92"],

Cell[BoxData["3700"], "Print",
 CellChangeTimes->{
  3.873460359121327*^9, 3.873472184817514*^9, 3.873514600528822*^9, {
   3.873619706528304*^9, 3.873619723121772*^9}, 3.87361979983558*^9, 
   3.873619938604599*^9, 3.873620552458734*^9, 3.873621456358457*^9, 
   3.8736536395043993`*^9, 3.873653697978847*^9, {3.8736537605376453`*^9, 
   3.873653786501913*^9}, 3.87365404387046*^9, 3.873654361803931*^9, {
   3.87372155376371*^9, 3.873721561299271*^9}, 3.873721650734617*^9, 
   3.8737219024108458`*^9, 3.873722043428874*^9, 3.873722123634899*^9, 
   3.873728809983386*^9},
 CellLabel->
  "During evaluation of \
In[57]:=",ExpressionUUID->"df913c9f-2f90-4716-8f1d-049ef0ae7700"],

Cell[BoxData["3750"], "Print",
 CellChangeTimes->{
  3.873460359121327*^9, 3.873472184817514*^9, 3.873514600528822*^9, {
   3.873619706528304*^9, 3.873619723121772*^9}, 3.87361979983558*^9, 
   3.873619938604599*^9, 3.873620552458734*^9, 3.873621456358457*^9, 
   3.8736536395043993`*^9, 3.873653697978847*^9, {3.8736537605376453`*^9, 
   3.873653786501913*^9}, 3.87365404387046*^9, 3.873654361803931*^9, {
   3.87372155376371*^9, 3.873721561299271*^9}, 3.873721650734617*^9, 
   3.8737219024108458`*^9, 3.873722043428874*^9, 3.873722123634899*^9, 
   3.873728889187048*^9},
 CellLabel->
  "During evaluation of \
In[57]:=",ExpressionUUID->"da6d1f6b-15ac-404a-9ab4-6d57f815531b"],

Cell[BoxData["3800"], "Print",
 CellChangeTimes->{
  3.873460359121327*^9, 3.873472184817514*^9, 3.873514600528822*^9, {
   3.873619706528304*^9, 3.873619723121772*^9}, 3.87361979983558*^9, 
   3.873619938604599*^9, 3.873620552458734*^9, 3.873621456358457*^9, 
   3.8736536395043993`*^9, 3.873653697978847*^9, {3.8736537605376453`*^9, 
   3.873653786501913*^9}, 3.87365404387046*^9, 3.873654361803931*^9, {
   3.87372155376371*^9, 3.873721561299271*^9}, 3.873721650734617*^9, 
   3.8737219024108458`*^9, 3.873722043428874*^9, 3.873722123634899*^9, 
   3.873728967604491*^9},
 CellLabel->
  "During evaluation of \
In[57]:=",ExpressionUUID->"eb071710-3957-419f-b290-7b7c0ff05aa9"],

Cell[BoxData["3850"], "Print",
 CellChangeTimes->{
  3.873460359121327*^9, 3.873472184817514*^9, 3.873514600528822*^9, {
   3.873619706528304*^9, 3.873619723121772*^9}, 3.87361979983558*^9, 
   3.873619938604599*^9, 3.873620552458734*^9, 3.873621456358457*^9, 
   3.8736536395043993`*^9, 3.873653697978847*^9, {3.8736537605376453`*^9, 
   3.873653786501913*^9}, 3.87365404387046*^9, 3.873654361803931*^9, {
   3.87372155376371*^9, 3.873721561299271*^9}, 3.873721650734617*^9, 
   3.8737219024108458`*^9, 3.873722043428874*^9, 3.873722123634899*^9, 
   3.873729047068879*^9},
 CellLabel->
  "During evaluation of \
In[57]:=",ExpressionUUID->"e14e4978-e236-4648-a6ae-e028bdf85db2"],

Cell[BoxData["3900"], "Print",
 CellChangeTimes->{
  3.873460359121327*^9, 3.873472184817514*^9, 3.873514600528822*^9, {
   3.873619706528304*^9, 3.873619723121772*^9}, 3.87361979983558*^9, 
   3.873619938604599*^9, 3.873620552458734*^9, 3.873621456358457*^9, 
   3.8736536395043993`*^9, 3.873653697978847*^9, {3.8736537605376453`*^9, 
   3.873653786501913*^9}, 3.87365404387046*^9, 3.873654361803931*^9, {
   3.87372155376371*^9, 3.873721561299271*^9}, 3.873721650734617*^9, 
   3.8737219024108458`*^9, 3.873722043428874*^9, 3.873722123634899*^9, 
   3.8737291266331577`*^9},
 CellLabel->
  "During evaluation of \
In[57]:=",ExpressionUUID->"25e8e22d-0aec-4b4b-a881-e44d8dcc84a0"],

Cell[BoxData["3950"], "Print",
 CellChangeTimes->{
  3.873460359121327*^9, 3.873472184817514*^9, 3.873514600528822*^9, {
   3.873619706528304*^9, 3.873619723121772*^9}, 3.87361979983558*^9, 
   3.873619938604599*^9, 3.873620552458734*^9, 3.873621456358457*^9, 
   3.8736536395043993`*^9, 3.873653697978847*^9, {3.8736537605376453`*^9, 
   3.873653786501913*^9}, 3.87365404387046*^9, 3.873654361803931*^9, {
   3.87372155376371*^9, 3.873721561299271*^9}, 3.873721650734617*^9, 
   3.8737219024108458`*^9, 3.873722043428874*^9, 3.873722123634899*^9, 
   3.873729205635703*^9},
 CellLabel->
  "During evaluation of \
In[57]:=",ExpressionUUID->"e5d86611-b3f6-4cfa-8bb2-d7784dc5ed5a"],

Cell[BoxData["4000"], "Print",
 CellChangeTimes->{
  3.873460359121327*^9, 3.873472184817514*^9, 3.873514600528822*^9, {
   3.873619706528304*^9, 3.873619723121772*^9}, 3.87361979983558*^9, 
   3.873619938604599*^9, 3.873620552458734*^9, 3.873621456358457*^9, 
   3.8736536395043993`*^9, 3.873653697978847*^9, {3.8736537605376453`*^9, 
   3.873653786501913*^9}, 3.87365404387046*^9, 3.873654361803931*^9, {
   3.87372155376371*^9, 3.873721561299271*^9}, 3.873721650734617*^9, 
   3.8737219024108458`*^9, 3.873722043428874*^9, 3.873722123634899*^9, 
   3.873729284399363*^9},
 CellLabel->
  "During evaluation of \
In[57]:=",ExpressionUUID->"79bfa3b6-fafc-4647-a13b-683542d3890d"],

Cell[BoxData["4050"], "Print",
 CellChangeTimes->{
  3.873460359121327*^9, 3.873472184817514*^9, 3.873514600528822*^9, {
   3.873619706528304*^9, 3.873619723121772*^9}, 3.87361979983558*^9, 
   3.873619938604599*^9, 3.873620552458734*^9, 3.873621456358457*^9, 
   3.8736536395043993`*^9, 3.873653697978847*^9, {3.8736537605376453`*^9, 
   3.873653786501913*^9}, 3.87365404387046*^9, 3.873654361803931*^9, {
   3.87372155376371*^9, 3.873721561299271*^9}, 3.873721650734617*^9, 
   3.8737219024108458`*^9, 3.873722043428874*^9, 3.873722123634899*^9, 
   3.873729363309519*^9},
 CellLabel->
  "During evaluation of \
In[57]:=",ExpressionUUID->"d6e9c9d9-d1d6-451f-bce5-bb20009e0868"],

Cell[BoxData["4100"], "Print",
 CellChangeTimes->{
  3.873460359121327*^9, 3.873472184817514*^9, 3.873514600528822*^9, {
   3.873619706528304*^9, 3.873619723121772*^9}, 3.87361979983558*^9, 
   3.873619938604599*^9, 3.873620552458734*^9, 3.873621456358457*^9, 
   3.8736536395043993`*^9, 3.873653697978847*^9, {3.8736537605376453`*^9, 
   3.873653786501913*^9}, 3.87365404387046*^9, 3.873654361803931*^9, {
   3.87372155376371*^9, 3.873721561299271*^9}, 3.873721650734617*^9, 
   3.8737219024108458`*^9, 3.873722043428874*^9, 3.873722123634899*^9, 
   3.8737294411371813`*^9},
 CellLabel->
  "During evaluation of \
In[57]:=",ExpressionUUID->"0b3fbce9-c009-422f-8eba-285e9feabbe3"],

Cell[BoxData["4150"], "Print",
 CellChangeTimes->{
  3.873460359121327*^9, 3.873472184817514*^9, 3.873514600528822*^9, {
   3.873619706528304*^9, 3.873619723121772*^9}, 3.87361979983558*^9, 
   3.873619938604599*^9, 3.873620552458734*^9, 3.873621456358457*^9, 
   3.8736536395043993`*^9, 3.873653697978847*^9, {3.8736537605376453`*^9, 
   3.873653786501913*^9}, 3.87365404387046*^9, 3.873654361803931*^9, {
   3.87372155376371*^9, 3.873721561299271*^9}, 3.873721650734617*^9, 
   3.8737219024108458`*^9, 3.873722043428874*^9, 3.873722123634899*^9, 
   3.873729519815611*^9},
 CellLabel->
  "During evaluation of \
In[57]:=",ExpressionUUID->"3c265ded-4335-4554-9b9b-a9ecaaa0faa6"],

Cell[BoxData["4200"], "Print",
 CellChangeTimes->{
  3.873460359121327*^9, 3.873472184817514*^9, 3.873514600528822*^9, {
   3.873619706528304*^9, 3.873619723121772*^9}, 3.87361979983558*^9, 
   3.873619938604599*^9, 3.873620552458734*^9, 3.873621456358457*^9, 
   3.8736536395043993`*^9, 3.873653697978847*^9, {3.8736537605376453`*^9, 
   3.873653786501913*^9}, 3.87365404387046*^9, 3.873654361803931*^9, {
   3.87372155376371*^9, 3.873721561299271*^9}, 3.873721650734617*^9, 
   3.8737219024108458`*^9, 3.873722043428874*^9, 3.873722123634899*^9, 
   3.8737295975311527`*^9},
 CellLabel->
  "During evaluation of \
In[57]:=",ExpressionUUID->"b899c8d9-287f-4bbc-a70d-3246976491f9"],

Cell[BoxData["4250"], "Print",
 CellChangeTimes->{
  3.873460359121327*^9, 3.873472184817514*^9, 3.873514600528822*^9, {
   3.873619706528304*^9, 3.873619723121772*^9}, 3.87361979983558*^9, 
   3.873619938604599*^9, 3.873620552458734*^9, 3.873621456358457*^9, 
   3.8736536395043993`*^9, 3.873653697978847*^9, {3.8736537605376453`*^9, 
   3.873653786501913*^9}, 3.87365404387046*^9, 3.873654361803931*^9, {
   3.87372155376371*^9, 3.873721561299271*^9}, 3.873721650734617*^9, 
   3.8737219024108458`*^9, 3.873722043428874*^9, 3.873722123634899*^9, 
   3.8737296761228724`*^9},
 CellLabel->
  "During evaluation of \
In[57]:=",ExpressionUUID->"0b527b13-2003-4870-be71-3cc13eb40576"],

Cell[BoxData["4300"], "Print",
 CellChangeTimes->{
  3.873460359121327*^9, 3.873472184817514*^9, 3.873514600528822*^9, {
   3.873619706528304*^9, 3.873619723121772*^9}, 3.87361979983558*^9, 
   3.873619938604599*^9, 3.873620552458734*^9, 3.873621456358457*^9, 
   3.8736536395043993`*^9, 3.873653697978847*^9, {3.8736537605376453`*^9, 
   3.873653786501913*^9}, 3.87365404387046*^9, 3.873654361803931*^9, {
   3.87372155376371*^9, 3.873721561299271*^9}, 3.873721650734617*^9, 
   3.8737219024108458`*^9, 3.873722043428874*^9, 3.873722123634899*^9, 
   3.87372975388729*^9},
 CellLabel->
  "During evaluation of \
In[57]:=",ExpressionUUID->"5b1e7916-d375-4c22-9a60-f1331743aeb9"],

Cell[BoxData["4350"], "Print",
 CellChangeTimes->{
  3.873460359121327*^9, 3.873472184817514*^9, 3.873514600528822*^9, {
   3.873619706528304*^9, 3.873619723121772*^9}, 3.87361979983558*^9, 
   3.873619938604599*^9, 3.873620552458734*^9, 3.873621456358457*^9, 
   3.8736536395043993`*^9, 3.873653697978847*^9, {3.8736537605376453`*^9, 
   3.873653786501913*^9}, 3.87365404387046*^9, 3.873654361803931*^9, {
   3.87372155376371*^9, 3.873721561299271*^9}, 3.873721650734617*^9, 
   3.8737219024108458`*^9, 3.873722043428874*^9, 3.873722123634899*^9, 
   3.873729831361703*^9},
 CellLabel->
  "During evaluation of \
In[57]:=",ExpressionUUID->"206a5a3a-3cd1-4f2a-9881-ae55e34f9815"],

Cell[BoxData["4400"], "Print",
 CellChangeTimes->{
  3.873460359121327*^9, 3.873472184817514*^9, 3.873514600528822*^9, {
   3.873619706528304*^9, 3.873619723121772*^9}, 3.87361979983558*^9, 
   3.873619938604599*^9, 3.873620552458734*^9, 3.873621456358457*^9, 
   3.8736536395043993`*^9, 3.873653697978847*^9, {3.8736537605376453`*^9, 
   3.873653786501913*^9}, 3.87365404387046*^9, 3.873654361803931*^9, {
   3.87372155376371*^9, 3.873721561299271*^9}, 3.873721650734617*^9, 
   3.8737219024108458`*^9, 3.873722043428874*^9, 3.873722123634899*^9, 
   3.873729909288398*^9},
 CellLabel->
  "During evaluation of \
In[57]:=",ExpressionUUID->"a613d189-37b9-49c3-96aa-64a2fb1b0238"],

Cell[BoxData["4450"], "Print",
 CellChangeTimes->{
  3.873460359121327*^9, 3.873472184817514*^9, 3.873514600528822*^9, {
   3.873619706528304*^9, 3.873619723121772*^9}, 3.87361979983558*^9, 
   3.873619938604599*^9, 3.873620552458734*^9, 3.873621456358457*^9, 
   3.8736536395043993`*^9, 3.873653697978847*^9, {3.8736537605376453`*^9, 
   3.873653786501913*^9}, 3.87365404387046*^9, 3.873654361803931*^9, {
   3.87372155376371*^9, 3.873721561299271*^9}, 3.873721650734617*^9, 
   3.8737219024108458`*^9, 3.873722043428874*^9, 3.873722123634899*^9, 
   3.8737299869658327`*^9},
 CellLabel->
  "During evaluation of \
In[57]:=",ExpressionUUID->"cd59f579-b25f-469a-a82b-de9e9257f578"],

Cell[BoxData["4500"], "Print",
 CellChangeTimes->{
  3.873460359121327*^9, 3.873472184817514*^9, 3.873514600528822*^9, {
   3.873619706528304*^9, 3.873619723121772*^9}, 3.87361979983558*^9, 
   3.873619938604599*^9, 3.873620552458734*^9, 3.873621456358457*^9, 
   3.8736536395043993`*^9, 3.873653697978847*^9, {3.8736537605376453`*^9, 
   3.873653786501913*^9}, 3.87365404387046*^9, 3.873654361803931*^9, {
   3.87372155376371*^9, 3.873721561299271*^9}, 3.873721650734617*^9, 
   3.8737219024108458`*^9, 3.873722043428874*^9, 3.873722123634899*^9, 
   3.873730064767839*^9},
 CellLabel->
  "During evaluation of \
In[57]:=",ExpressionUUID->"845088ad-b3db-484b-868b-2e850f82612a"],

Cell[BoxData["4550"], "Print",
 CellChangeTimes->{
  3.873460359121327*^9, 3.873472184817514*^9, 3.873514600528822*^9, {
   3.873619706528304*^9, 3.873619723121772*^9}, 3.87361979983558*^9, 
   3.873619938604599*^9, 3.873620552458734*^9, 3.873621456358457*^9, 
   3.8736536395043993`*^9, 3.873653697978847*^9, {3.8736537605376453`*^9, 
   3.873653786501913*^9}, 3.87365404387046*^9, 3.873654361803931*^9, {
   3.87372155376371*^9, 3.873721561299271*^9}, 3.873721650734617*^9, 
   3.8737219024108458`*^9, 3.873722043428874*^9, 3.873722123634899*^9, 
   3.873730143535828*^9},
 CellLabel->
  "During evaluation of \
In[57]:=",ExpressionUUID->"3bf0f3c7-8533-4f50-b51f-eb4e11abd951"],

Cell[BoxData["4600"], "Print",
 CellChangeTimes->{
  3.873460359121327*^9, 3.873472184817514*^9, 3.873514600528822*^9, {
   3.873619706528304*^9, 3.873619723121772*^9}, 3.87361979983558*^9, 
   3.873619938604599*^9, 3.873620552458734*^9, 3.873621456358457*^9, 
   3.8736536395043993`*^9, 3.873653697978847*^9, {3.8736537605376453`*^9, 
   3.873653786501913*^9}, 3.87365404387046*^9, 3.873654361803931*^9, {
   3.87372155376371*^9, 3.873721561299271*^9}, 3.873721650734617*^9, 
   3.8737219024108458`*^9, 3.873722043428874*^9, 3.873722123634899*^9, 
   3.873730221331071*^9},
 CellLabel->
  "During evaluation of \
In[57]:=",ExpressionUUID->"3d7f1f0d-601f-4dae-b142-502b9abc8031"],

Cell[BoxData["4650"], "Print",
 CellChangeTimes->{
  3.873460359121327*^9, 3.873472184817514*^9, 3.873514600528822*^9, {
   3.873619706528304*^9, 3.873619723121772*^9}, 3.87361979983558*^9, 
   3.873619938604599*^9, 3.873620552458734*^9, 3.873621456358457*^9, 
   3.8736536395043993`*^9, 3.873653697978847*^9, {3.8736537605376453`*^9, 
   3.873653786501913*^9}, 3.87365404387046*^9, 3.873654361803931*^9, {
   3.87372155376371*^9, 3.873721561299271*^9}, 3.873721650734617*^9, 
   3.8737219024108458`*^9, 3.873722043428874*^9, 3.873722123634899*^9, 
   3.873730298858725*^9},
 CellLabel->
  "During evaluation of \
In[57]:=",ExpressionUUID->"ed51d079-cc21-4a60-b472-6651f81b7a50"],

Cell[BoxData["4700"], "Print",
 CellChangeTimes->{
  3.873460359121327*^9, 3.873472184817514*^9, 3.873514600528822*^9, {
   3.873619706528304*^9, 3.873619723121772*^9}, 3.87361979983558*^9, 
   3.873619938604599*^9, 3.873620552458734*^9, 3.873621456358457*^9, 
   3.8736536395043993`*^9, 3.873653697978847*^9, {3.8736537605376453`*^9, 
   3.873653786501913*^9}, 3.87365404387046*^9, 3.873654361803931*^9, {
   3.87372155376371*^9, 3.873721561299271*^9}, 3.873721650734617*^9, 
   3.8737219024108458`*^9, 3.873722043428874*^9, 3.873722123634899*^9, 
   3.873730376911232*^9},
 CellLabel->
  "During evaluation of \
In[57]:=",ExpressionUUID->"67d8f7a1-11b3-4aca-8c02-081c75cbc7ea"],

Cell[BoxData["4750"], "Print",
 CellChangeTimes->{
  3.873460359121327*^9, 3.873472184817514*^9, 3.873514600528822*^9, {
   3.873619706528304*^9, 3.873619723121772*^9}, 3.87361979983558*^9, 
   3.873619938604599*^9, 3.873620552458734*^9, 3.873621456358457*^9, 
   3.8736536395043993`*^9, 3.873653697978847*^9, {3.8736537605376453`*^9, 
   3.873653786501913*^9}, 3.87365404387046*^9, 3.873654361803931*^9, {
   3.87372155376371*^9, 3.873721561299271*^9}, 3.873721650734617*^9, 
   3.8737219024108458`*^9, 3.873722043428874*^9, 3.873722123634899*^9, 
   3.8737304557618723`*^9},
 CellLabel->
  "During evaluation of \
In[57]:=",ExpressionUUID->"23e1b32a-fc2d-4ece-8bac-6deba79a2b9e"],

Cell[BoxData["4800"], "Print",
 CellChangeTimes->{
  3.873460359121327*^9, 3.873472184817514*^9, 3.873514600528822*^9, {
   3.873619706528304*^9, 3.873619723121772*^9}, 3.87361979983558*^9, 
   3.873619938604599*^9, 3.873620552458734*^9, 3.873621456358457*^9, 
   3.8736536395043993`*^9, 3.873653697978847*^9, {3.8736537605376453`*^9, 
   3.873653786501913*^9}, 3.87365404387046*^9, 3.873654361803931*^9, {
   3.87372155376371*^9, 3.873721561299271*^9}, 3.873721650734617*^9, 
   3.8737219024108458`*^9, 3.873722043428874*^9, 3.873722123634899*^9, 
   3.873730534350812*^9},
 CellLabel->
  "During evaluation of \
In[57]:=",ExpressionUUID->"de4901e8-a6fd-49cb-9ffa-8b3b7a8fc695"],

Cell[BoxData["4850"], "Print",
 CellChangeTimes->{
  3.873460359121327*^9, 3.873472184817514*^9, 3.873514600528822*^9, {
   3.873619706528304*^9, 3.873619723121772*^9}, 3.87361979983558*^9, 
   3.873619938604599*^9, 3.873620552458734*^9, 3.873621456358457*^9, 
   3.8736536395043993`*^9, 3.873653697978847*^9, {3.8736537605376453`*^9, 
   3.873653786501913*^9}, 3.87365404387046*^9, 3.873654361803931*^9, {
   3.87372155376371*^9, 3.873721561299271*^9}, 3.873721650734617*^9, 
   3.8737219024108458`*^9, 3.873722043428874*^9, 3.873722123634899*^9, 
   3.873730613766344*^9},
 CellLabel->
  "During evaluation of \
In[57]:=",ExpressionUUID->"038c3198-f0d0-41df-bcc7-466c6f156137"],

Cell[BoxData["4900"], "Print",
 CellChangeTimes->{
  3.873460359121327*^9, 3.873472184817514*^9, 3.873514600528822*^9, {
   3.873619706528304*^9, 3.873619723121772*^9}, 3.87361979983558*^9, 
   3.873619938604599*^9, 3.873620552458734*^9, 3.873621456358457*^9, 
   3.8736536395043993`*^9, 3.873653697978847*^9, {3.8736537605376453`*^9, 
   3.873653786501913*^9}, 3.87365404387046*^9, 3.873654361803931*^9, {
   3.87372155376371*^9, 3.873721561299271*^9}, 3.873721650734617*^9, 
   3.8737219024108458`*^9, 3.873722043428874*^9, 3.873722123634899*^9, 
   3.873730691160035*^9},
 CellLabel->
  "During evaluation of \
In[57]:=",ExpressionUUID->"d85692c2-9b10-4573-81f4-b91d93064b31"],

Cell[BoxData["4950"], "Print",
 CellChangeTimes->{
  3.873460359121327*^9, 3.873472184817514*^9, 3.873514600528822*^9, {
   3.873619706528304*^9, 3.873619723121772*^9}, 3.87361979983558*^9, 
   3.873619938604599*^9, 3.873620552458734*^9, 3.873621456358457*^9, 
   3.8736536395043993`*^9, 3.873653697978847*^9, {3.8736537605376453`*^9, 
   3.873653786501913*^9}, 3.87365404387046*^9, 3.873654361803931*^9, {
   3.87372155376371*^9, 3.873721561299271*^9}, 3.873721650734617*^9, 
   3.8737219024108458`*^9, 3.873722043428874*^9, 3.873722123634899*^9, 
   3.8737307690841427`*^9},
 CellLabel->
  "During evaluation of \
In[57]:=",ExpressionUUID->"173efa63-6581-455b-ad4c-2c4df1ba6d09"],

Cell[BoxData["5000"], "Print",
 CellChangeTimes->{
  3.873460359121327*^9, 3.873472184817514*^9, 3.873514600528822*^9, {
   3.873619706528304*^9, 3.873619723121772*^9}, 3.87361979983558*^9, 
   3.873619938604599*^9, 3.873620552458734*^9, 3.873621456358457*^9, 
   3.8736536395043993`*^9, 3.873653697978847*^9, {3.8736537605376453`*^9, 
   3.873653786501913*^9}, 3.87365404387046*^9, 3.873654361803931*^9, {
   3.87372155376371*^9, 3.873721561299271*^9}, 3.873721650734617*^9, 
   3.8737219024108458`*^9, 3.873722043428874*^9, 3.873722123634899*^9, 
   3.87373084794058*^9},
 CellLabel->
  "During evaluation of \
In[57]:=",ExpressionUUID->"85ead3a3-5031-410a-b617-2d1f3d1c6101"],

Cell[BoxData["5050"], "Print",
 CellChangeTimes->{
  3.873460359121327*^9, 3.873472184817514*^9, 3.873514600528822*^9, {
   3.873619706528304*^9, 3.873619723121772*^9}, 3.87361979983558*^9, 
   3.873619938604599*^9, 3.873620552458734*^9, 3.873621456358457*^9, 
   3.8736536395043993`*^9, 3.873653697978847*^9, {3.8736537605376453`*^9, 
   3.873653786501913*^9}, 3.87365404387046*^9, 3.873654361803931*^9, {
   3.87372155376371*^9, 3.873721561299271*^9}, 3.873721650734617*^9, 
   3.8737219024108458`*^9, 3.873722043428874*^9, 3.873722123634899*^9, 
   3.8737309266148252`*^9},
 CellLabel->
  "During evaluation of \
In[57]:=",ExpressionUUID->"fb003eec-e871-4adf-b95f-03c9ce09f2f9"],

Cell[BoxData["5100"], "Print",
 CellChangeTimes->{
  3.873460359121327*^9, 3.873472184817514*^9, 3.873514600528822*^9, {
   3.873619706528304*^9, 3.873619723121772*^9}, 3.87361979983558*^9, 
   3.873619938604599*^9, 3.873620552458734*^9, 3.873621456358457*^9, 
   3.8736536395043993`*^9, 3.873653697978847*^9, {3.8736537605376453`*^9, 
   3.873653786501913*^9}, 3.87365404387046*^9, 3.873654361803931*^9, {
   3.87372155376371*^9, 3.873721561299271*^9}, 3.873721650734617*^9, 
   3.8737219024108458`*^9, 3.873722043428874*^9, 3.873722123634899*^9, 
   3.8737310052426367`*^9},
 CellLabel->
  "During evaluation of \
In[57]:=",ExpressionUUID->"a8658c2c-0bc1-47b5-bfdd-e128f8b3da9c"],

Cell[BoxData["5150"], "Print",
 CellChangeTimes->{
  3.873460359121327*^9, 3.873472184817514*^9, 3.873514600528822*^9, {
   3.873619706528304*^9, 3.873619723121772*^9}, 3.87361979983558*^9, 
   3.873619938604599*^9, 3.873620552458734*^9, 3.873621456358457*^9, 
   3.8736536395043993`*^9, 3.873653697978847*^9, {3.8736537605376453`*^9, 
   3.873653786501913*^9}, 3.87365404387046*^9, 3.873654361803931*^9, {
   3.87372155376371*^9, 3.873721561299271*^9}, 3.873721650734617*^9, 
   3.8737219024108458`*^9, 3.873722043428874*^9, 3.873722123634899*^9, 
   3.8737310830377502`*^9},
 CellLabel->
  "During evaluation of \
In[57]:=",ExpressionUUID->"1aa69d6c-d470-4bbf-a418-094fbc1a0603"],

Cell[BoxData["5200"], "Print",
 CellChangeTimes->{
  3.873460359121327*^9, 3.873472184817514*^9, 3.873514600528822*^9, {
   3.873619706528304*^9, 3.873619723121772*^9}, 3.87361979983558*^9, 
   3.873619938604599*^9, 3.873620552458734*^9, 3.873621456358457*^9, 
   3.8736536395043993`*^9, 3.873653697978847*^9, {3.8736537605376453`*^9, 
   3.873653786501913*^9}, 3.87365404387046*^9, 3.873654361803931*^9, {
   3.87372155376371*^9, 3.873721561299271*^9}, 3.873721650734617*^9, 
   3.8737219024108458`*^9, 3.873722043428874*^9, 3.873722123634899*^9, 
   3.8737311616727858`*^9},
 CellLabel->
  "During evaluation of \
In[57]:=",ExpressionUUID->"6ddbe458-4459-4556-97e9-6e10e07f4085"],

Cell[BoxData["5250"], "Print",
 CellChangeTimes->{
  3.873460359121327*^9, 3.873472184817514*^9, 3.873514600528822*^9, {
   3.873619706528304*^9, 3.873619723121772*^9}, 3.87361979983558*^9, 
   3.873619938604599*^9, 3.873620552458734*^9, 3.873621456358457*^9, 
   3.8736536395043993`*^9, 3.873653697978847*^9, {3.8736537605376453`*^9, 
   3.873653786501913*^9}, 3.87365404387046*^9, 3.873654361803931*^9, {
   3.87372155376371*^9, 3.873721561299271*^9}, 3.873721650734617*^9, 
   3.8737219024108458`*^9, 3.873722043428874*^9, 3.873722123634899*^9, 
   3.873731239680595*^9},
 CellLabel->
  "During evaluation of \
In[57]:=",ExpressionUUID->"1a3fda3e-6503-4feb-8802-b7a14335483f"],

Cell[BoxData["5300"], "Print",
 CellChangeTimes->{
  3.873460359121327*^9, 3.873472184817514*^9, 3.873514600528822*^9, {
   3.873619706528304*^9, 3.873619723121772*^9}, 3.87361979983558*^9, 
   3.873619938604599*^9, 3.873620552458734*^9, 3.873621456358457*^9, 
   3.8736536395043993`*^9, 3.873653697978847*^9, {3.8736537605376453`*^9, 
   3.873653786501913*^9}, 3.87365404387046*^9, 3.873654361803931*^9, {
   3.87372155376371*^9, 3.873721561299271*^9}, 3.873721650734617*^9, 
   3.8737219024108458`*^9, 3.873722043428874*^9, 3.873722123634899*^9, 
   3.87373131945991*^9},
 CellLabel->
  "During evaluation of \
In[57]:=",ExpressionUUID->"127ff80f-5a1d-49f0-bfd0-d4bb9463d15c"],

Cell[BoxData["5350"], "Print",
 CellChangeTimes->{
  3.873460359121327*^9, 3.873472184817514*^9, 3.873514600528822*^9, {
   3.873619706528304*^9, 3.873619723121772*^9}, 3.87361979983558*^9, 
   3.873619938604599*^9, 3.873620552458734*^9, 3.873621456358457*^9, 
   3.8736536395043993`*^9, 3.873653697978847*^9, {3.8736537605376453`*^9, 
   3.873653786501913*^9}, 3.87365404387046*^9, 3.873654361803931*^9, {
   3.87372155376371*^9, 3.873721561299271*^9}, 3.873721650734617*^9, 
   3.8737219024108458`*^9, 3.873722043428874*^9, 3.873722123634899*^9, 
   3.873731396965788*^9},
 CellLabel->
  "During evaluation of \
In[57]:=",ExpressionUUID->"3f761bed-0a65-454b-b680-2380ce28706d"],

Cell[BoxData["5400"], "Print",
 CellChangeTimes->{
  3.873460359121327*^9, 3.873472184817514*^9, 3.873514600528822*^9, {
   3.873619706528304*^9, 3.873619723121772*^9}, 3.87361979983558*^9, 
   3.873619938604599*^9, 3.873620552458734*^9, 3.873621456358457*^9, 
   3.8736536395043993`*^9, 3.873653697978847*^9, {3.8736537605376453`*^9, 
   3.873653786501913*^9}, 3.87365404387046*^9, 3.873654361803931*^9, {
   3.87372155376371*^9, 3.873721561299271*^9}, 3.873721650734617*^9, 
   3.8737219024108458`*^9, 3.873722043428874*^9, 3.873722123634899*^9, 
   3.873731474694968*^9},
 CellLabel->
  "During evaluation of \
In[57]:=",ExpressionUUID->"ab333564-b0eb-4152-9163-2b5a50fece97"],

Cell[BoxData["5450"], "Print",
 CellChangeTimes->{
  3.873460359121327*^9, 3.873472184817514*^9, 3.873514600528822*^9, {
   3.873619706528304*^9, 3.873619723121772*^9}, 3.87361979983558*^9, 
   3.873619938604599*^9, 3.873620552458734*^9, 3.873621456358457*^9, 
   3.8736536395043993`*^9, 3.873653697978847*^9, {3.8736537605376453`*^9, 
   3.873653786501913*^9}, 3.87365404387046*^9, 3.873654361803931*^9, {
   3.87372155376371*^9, 3.873721561299271*^9}, 3.873721650734617*^9, 
   3.8737219024108458`*^9, 3.873722043428874*^9, 3.873722123634899*^9, 
   3.873731553245001*^9},
 CellLabel->
  "During evaluation of \
In[57]:=",ExpressionUUID->"8c12f57a-06a8-4f17-86b9-58843db57833"],

Cell[BoxData["5500"], "Print",
 CellChangeTimes->{
  3.873460359121327*^9, 3.873472184817514*^9, 3.873514600528822*^9, {
   3.873619706528304*^9, 3.873619723121772*^9}, 3.87361979983558*^9, 
   3.873619938604599*^9, 3.873620552458734*^9, 3.873621456358457*^9, 
   3.8736536395043993`*^9, 3.873653697978847*^9, {3.8736537605376453`*^9, 
   3.873653786501913*^9}, 3.87365404387046*^9, 3.873654361803931*^9, {
   3.87372155376371*^9, 3.873721561299271*^9}, 3.873721650734617*^9, 
   3.8737219024108458`*^9, 3.873722043428874*^9, 3.873722123634899*^9, 
   3.873731629848111*^9},
 CellLabel->
  "During evaluation of \
In[57]:=",ExpressionUUID->"f80f9062-8b11-4deb-9e6c-cc41bf4f2cb3"],

Cell[BoxData["5550"], "Print",
 CellChangeTimes->{
  3.873460359121327*^9, 3.873472184817514*^9, 3.873514600528822*^9, {
   3.873619706528304*^9, 3.873619723121772*^9}, 3.87361979983558*^9, 
   3.873619938604599*^9, 3.873620552458734*^9, 3.873621456358457*^9, 
   3.8736536395043993`*^9, 3.873653697978847*^9, {3.8736537605376453`*^9, 
   3.873653786501913*^9}, 3.87365404387046*^9, 3.873654361803931*^9, {
   3.87372155376371*^9, 3.873721561299271*^9}, 3.873721650734617*^9, 
   3.8737219024108458`*^9, 3.873722043428874*^9, 3.873722123634899*^9, 
   3.873731707040834*^9},
 CellLabel->
  "During evaluation of \
In[57]:=",ExpressionUUID->"70849470-fc52-4cbf-bd0f-badc670c210e"],

Cell[BoxData["5600"], "Print",
 CellChangeTimes->{
  3.873460359121327*^9, 3.873472184817514*^9, 3.873514600528822*^9, {
   3.873619706528304*^9, 3.873619723121772*^9}, 3.87361979983558*^9, 
   3.873619938604599*^9, 3.873620552458734*^9, 3.873621456358457*^9, 
   3.8736536395043993`*^9, 3.873653697978847*^9, {3.8736537605376453`*^9, 
   3.873653786501913*^9}, 3.87365404387046*^9, 3.873654361803931*^9, {
   3.87372155376371*^9, 3.873721561299271*^9}, 3.873721650734617*^9, 
   3.8737219024108458`*^9, 3.873722043428874*^9, 3.873722123634899*^9, 
   3.87373178521905*^9},
 CellLabel->
  "During evaluation of \
In[57]:=",ExpressionUUID->"6a2dff69-335e-424c-9c64-05b8a7649943"],

Cell[BoxData["5650"], "Print",
 CellChangeTimes->{
  3.873460359121327*^9, 3.873472184817514*^9, 3.873514600528822*^9, {
   3.873619706528304*^9, 3.873619723121772*^9}, 3.87361979983558*^9, 
   3.873619938604599*^9, 3.873620552458734*^9, 3.873621456358457*^9, 
   3.8736536395043993`*^9, 3.873653697978847*^9, {3.8736537605376453`*^9, 
   3.873653786501913*^9}, 3.87365404387046*^9, 3.873654361803931*^9, {
   3.87372155376371*^9, 3.873721561299271*^9}, 3.873721650734617*^9, 
   3.8737219024108458`*^9, 3.873722043428874*^9, 3.873722123634899*^9, 
   3.873731863116646*^9},
 CellLabel->
  "During evaluation of \
In[57]:=",ExpressionUUID->"ac48039e-3813-42bd-ad6b-ab468784fb97"],

Cell[BoxData["5700"], "Print",
 CellChangeTimes->{
  3.873460359121327*^9, 3.873472184817514*^9, 3.873514600528822*^9, {
   3.873619706528304*^9, 3.873619723121772*^9}, 3.87361979983558*^9, 
   3.873619938604599*^9, 3.873620552458734*^9, 3.873621456358457*^9, 
   3.8736536395043993`*^9, 3.873653697978847*^9, {3.8736537605376453`*^9, 
   3.873653786501913*^9}, 3.87365404387046*^9, 3.873654361803931*^9, {
   3.87372155376371*^9, 3.873721561299271*^9}, 3.873721650734617*^9, 
   3.8737219024108458`*^9, 3.873722043428874*^9, 3.873722123634899*^9, 
   3.873731940516327*^9},
 CellLabel->
  "During evaluation of \
In[57]:=",ExpressionUUID->"0def96d2-4410-443d-b807-a43e62278ae5"],

Cell[BoxData["5750"], "Print",
 CellChangeTimes->{
  3.873460359121327*^9, 3.873472184817514*^9, 3.873514600528822*^9, {
   3.873619706528304*^9, 3.873619723121772*^9}, 3.87361979983558*^9, 
   3.873619938604599*^9, 3.873620552458734*^9, 3.873621456358457*^9, 
   3.8736536395043993`*^9, 3.873653697978847*^9, {3.8736537605376453`*^9, 
   3.873653786501913*^9}, 3.87365404387046*^9, 3.873654361803931*^9, {
   3.87372155376371*^9, 3.873721561299271*^9}, 3.873721650734617*^9, 
   3.8737219024108458`*^9, 3.873722043428874*^9, 3.873722123634899*^9, 
   3.873732018987096*^9},
 CellLabel->
  "During evaluation of \
In[57]:=",ExpressionUUID->"f7a2a186-3436-495d-9f8e-e04da53d1c98"],

Cell[BoxData["5800"], "Print",
 CellChangeTimes->{
  3.873460359121327*^9, 3.873472184817514*^9, 3.873514600528822*^9, {
   3.873619706528304*^9, 3.873619723121772*^9}, 3.87361979983558*^9, 
   3.873619938604599*^9, 3.873620552458734*^9, 3.873621456358457*^9, 
   3.8736536395043993`*^9, 3.873653697978847*^9, {3.8736537605376453`*^9, 
   3.873653786501913*^9}, 3.87365404387046*^9, 3.873654361803931*^9, {
   3.87372155376371*^9, 3.873721561299271*^9}, 3.873721650734617*^9, 
   3.8737219024108458`*^9, 3.873722043428874*^9, 3.873722123634899*^9, 
   3.87373209746727*^9},
 CellLabel->
  "During evaluation of \
In[57]:=",ExpressionUUID->"f20c0bd2-8c77-4373-b6ca-9c34dba8fb86"],

Cell[BoxData["5850"], "Print",
 CellChangeTimes->{
  3.873460359121327*^9, 3.873472184817514*^9, 3.873514600528822*^9, {
   3.873619706528304*^9, 3.873619723121772*^9}, 3.87361979983558*^9, 
   3.873619938604599*^9, 3.873620552458734*^9, 3.873621456358457*^9, 
   3.8736536395043993`*^9, 3.873653697978847*^9, {3.8736537605376453`*^9, 
   3.873653786501913*^9}, 3.87365404387046*^9, 3.873654361803931*^9, {
   3.87372155376371*^9, 3.873721561299271*^9}, 3.873721650734617*^9, 
   3.8737219024108458`*^9, 3.873722043428874*^9, 3.873722123634899*^9, 
   3.8737321754888563`*^9},
 CellLabel->
  "During evaluation of \
In[57]:=",ExpressionUUID->"6a818a07-97fc-4ef5-bbc4-73615ddf4a49"],

Cell[BoxData["5900"], "Print",
 CellChangeTimes->{
  3.873460359121327*^9, 3.873472184817514*^9, 3.873514600528822*^9, {
   3.873619706528304*^9, 3.873619723121772*^9}, 3.87361979983558*^9, 
   3.873619938604599*^9, 3.873620552458734*^9, 3.873621456358457*^9, 
   3.8736536395043993`*^9, 3.873653697978847*^9, {3.8736537605376453`*^9, 
   3.873653786501913*^9}, 3.87365404387046*^9, 3.873654361803931*^9, {
   3.87372155376371*^9, 3.873721561299271*^9}, 3.873721650734617*^9, 
   3.8737219024108458`*^9, 3.873722043428874*^9, 3.873722123634899*^9, 
   3.873732253702559*^9},
 CellLabel->
  "During evaluation of \
In[57]:=",ExpressionUUID->"a1e35d4c-aa2d-4cc9-95f3-243311a6473d"],

Cell[BoxData["5950"], "Print",
 CellChangeTimes->{
  3.873460359121327*^9, 3.873472184817514*^9, 3.873514600528822*^9, {
   3.873619706528304*^9, 3.873619723121772*^9}, 3.87361979983558*^9, 
   3.873619938604599*^9, 3.873620552458734*^9, 3.873621456358457*^9, 
   3.8736536395043993`*^9, 3.873653697978847*^9, {3.8736537605376453`*^9, 
   3.873653786501913*^9}, 3.87365404387046*^9, 3.873654361803931*^9, {
   3.87372155376371*^9, 3.873721561299271*^9}, 3.873721650734617*^9, 
   3.8737219024108458`*^9, 3.873722043428874*^9, 3.873722123634899*^9, 
   3.8737323329735126`*^9},
 CellLabel->
  "During evaluation of \
In[57]:=",ExpressionUUID->"4f58cc5c-38ed-4c08-b079-d9eee7f42661"],

Cell[BoxData["6000"], "Print",
 CellChangeTimes->{
  3.873460359121327*^9, 3.873472184817514*^9, 3.873514600528822*^9, {
   3.873619706528304*^9, 3.873619723121772*^9}, 3.87361979983558*^9, 
   3.873619938604599*^9, 3.873620552458734*^9, 3.873621456358457*^9, 
   3.8736536395043993`*^9, 3.873653697978847*^9, {3.8736537605376453`*^9, 
   3.873653786501913*^9}, 3.87365404387046*^9, 3.873654361803931*^9, {
   3.87372155376371*^9, 3.873721561299271*^9}, 3.873721650734617*^9, 
   3.8737219024108458`*^9, 3.873722043428874*^9, 3.873722123634899*^9, 
   3.873732412174282*^9},
 CellLabel->
  "During evaluation of \
In[57]:=",ExpressionUUID->"296a6bfc-804b-4a14-875e-e12272f2f7f4"],

Cell[BoxData["6050"], "Print",
 CellChangeTimes->{
  3.873460359121327*^9, 3.873472184817514*^9, 3.873514600528822*^9, {
   3.873619706528304*^9, 3.873619723121772*^9}, 3.87361979983558*^9, 
   3.873619938604599*^9, 3.873620552458734*^9, 3.873621456358457*^9, 
   3.8736536395043993`*^9, 3.873653697978847*^9, {3.8736537605376453`*^9, 
   3.873653786501913*^9}, 3.87365404387046*^9, 3.873654361803931*^9, {
   3.87372155376371*^9, 3.873721561299271*^9}, 3.873721650734617*^9, 
   3.8737219024108458`*^9, 3.873722043428874*^9, 3.873722123634899*^9, 
   3.873732490693633*^9},
 CellLabel->
  "During evaluation of \
In[57]:=",ExpressionUUID->"ff0463f9-0357-44fc-b7c6-e543ae2eae4b"],

Cell[BoxData["6100"], "Print",
 CellChangeTimes->{
  3.873460359121327*^9, 3.873472184817514*^9, 3.873514600528822*^9, {
   3.873619706528304*^9, 3.873619723121772*^9}, 3.87361979983558*^9, 
   3.873619938604599*^9, 3.873620552458734*^9, 3.873621456358457*^9, 
   3.8736536395043993`*^9, 3.873653697978847*^9, {3.8736537605376453`*^9, 
   3.873653786501913*^9}, 3.87365404387046*^9, 3.873654361803931*^9, {
   3.87372155376371*^9, 3.873721561299271*^9}, 3.873721650734617*^9, 
   3.8737219024108458`*^9, 3.873722043428874*^9, 3.873722123634899*^9, 
   3.873732569047051*^9},
 CellLabel->
  "During evaluation of \
In[57]:=",ExpressionUUID->"62c41720-4a8c-4f53-9b9c-d098fee9182d"],

Cell[BoxData["6150"], "Print",
 CellChangeTimes->{
  3.873460359121327*^9, 3.873472184817514*^9, 3.873514600528822*^9, {
   3.873619706528304*^9, 3.873619723121772*^9}, 3.87361979983558*^9, 
   3.873619938604599*^9, 3.873620552458734*^9, 3.873621456358457*^9, 
   3.8736536395043993`*^9, 3.873653697978847*^9, {3.8736537605376453`*^9, 
   3.873653786501913*^9}, 3.87365404387046*^9, 3.873654361803931*^9, {
   3.87372155376371*^9, 3.873721561299271*^9}, 3.873721650734617*^9, 
   3.8737219024108458`*^9, 3.873722043428874*^9, 3.873722123634899*^9, 
   3.87373264689058*^9},
 CellLabel->
  "During evaluation of \
In[57]:=",ExpressionUUID->"ea3dca47-d4c4-4492-b75d-22aaafab2bd2"],

Cell[BoxData["6200"], "Print",
 CellChangeTimes->{
  3.873460359121327*^9, 3.873472184817514*^9, 3.873514600528822*^9, {
   3.873619706528304*^9, 3.873619723121772*^9}, 3.87361979983558*^9, 
   3.873619938604599*^9, 3.873620552458734*^9, 3.873621456358457*^9, 
   3.8736536395043993`*^9, 3.873653697978847*^9, {3.8736537605376453`*^9, 
   3.873653786501913*^9}, 3.87365404387046*^9, 3.873654361803931*^9, {
   3.87372155376371*^9, 3.873721561299271*^9}, 3.873721650734617*^9, 
   3.8737219024108458`*^9, 3.873722043428874*^9, 3.873722123634899*^9, 
   3.873732724524562*^9},
 CellLabel->
  "During evaluation of \
In[57]:=",ExpressionUUID->"969ad794-98e2-4273-86a2-d2b609a211a4"],

Cell[BoxData["6250"], "Print",
 CellChangeTimes->{
  3.873460359121327*^9, 3.873472184817514*^9, 3.873514600528822*^9, {
   3.873619706528304*^9, 3.873619723121772*^9}, 3.87361979983558*^9, 
   3.873619938604599*^9, 3.873620552458734*^9, 3.873621456358457*^9, 
   3.8736536395043993`*^9, 3.873653697978847*^9, {3.8736537605376453`*^9, 
   3.873653786501913*^9}, 3.87365404387046*^9, 3.873654361803931*^9, {
   3.87372155376371*^9, 3.873721561299271*^9}, 3.873721650734617*^9, 
   3.8737219024108458`*^9, 3.873722043428874*^9, 3.873722123634899*^9, 
   3.873732802439622*^9},
 CellLabel->
  "During evaluation of \
In[57]:=",ExpressionUUID->"83b6d1bb-64a5-4ef3-bf31-6ee5d8066a37"],

Cell[BoxData["6300"], "Print",
 CellChangeTimes->{
  3.873460359121327*^9, 3.873472184817514*^9, 3.873514600528822*^9, {
   3.873619706528304*^9, 3.873619723121772*^9}, 3.87361979983558*^9, 
   3.873619938604599*^9, 3.873620552458734*^9, 3.873621456358457*^9, 
   3.8736536395043993`*^9, 3.873653697978847*^9, {3.8736537605376453`*^9, 
   3.873653786501913*^9}, 3.87365404387046*^9, 3.873654361803931*^9, {
   3.87372155376371*^9, 3.873721561299271*^9}, 3.873721650734617*^9, 
   3.8737219024108458`*^9, 3.873722043428874*^9, 3.873722123634899*^9, 
   3.873732879846957*^9},
 CellLabel->
  "During evaluation of \
In[57]:=",ExpressionUUID->"1d3153c7-7944-4ea9-bafe-62566576d9a5"],

Cell[BoxData["6350"], "Print",
 CellChangeTimes->{
  3.873460359121327*^9, 3.873472184817514*^9, 3.873514600528822*^9, {
   3.873619706528304*^9, 3.873619723121772*^9}, 3.87361979983558*^9, 
   3.873619938604599*^9, 3.873620552458734*^9, 3.873621456358457*^9, 
   3.8736536395043993`*^9, 3.873653697978847*^9, {3.8736537605376453`*^9, 
   3.873653786501913*^9}, 3.87365404387046*^9, 3.873654361803931*^9, {
   3.87372155376371*^9, 3.873721561299271*^9}, 3.873721650734617*^9, 
   3.8737219024108458`*^9, 3.873722043428874*^9, 3.873722123634899*^9, 
   3.87373295755517*^9},
 CellLabel->
  "During evaluation of \
In[57]:=",ExpressionUUID->"3c511339-9d5e-46ae-9a9b-33f41dbe4d07"],

Cell[BoxData["6400"], "Print",
 CellChangeTimes->{
  3.873460359121327*^9, 3.873472184817514*^9, 3.873514600528822*^9, {
   3.873619706528304*^9, 3.873619723121772*^9}, 3.87361979983558*^9, 
   3.873619938604599*^9, 3.873620552458734*^9, 3.873621456358457*^9, 
   3.8736536395043993`*^9, 3.873653697978847*^9, {3.8736537605376453`*^9, 
   3.873653786501913*^9}, 3.87365404387046*^9, 3.873654361803931*^9, {
   3.87372155376371*^9, 3.873721561299271*^9}, 3.873721650734617*^9, 
   3.8737219024108458`*^9, 3.873722043428874*^9, 3.873722123634899*^9, 
   3.873733035809154*^9},
 CellLabel->
  "During evaluation of \
In[57]:=",ExpressionUUID->"935d6440-2bd4-4ce1-8c12-8e2a776b819c"],

Cell[BoxData["6450"], "Print",
 CellChangeTimes->{
  3.873460359121327*^9, 3.873472184817514*^9, 3.873514600528822*^9, {
   3.873619706528304*^9, 3.873619723121772*^9}, 3.87361979983558*^9, 
   3.873619938604599*^9, 3.873620552458734*^9, 3.873621456358457*^9, 
   3.8736536395043993`*^9, 3.873653697978847*^9, {3.8736537605376453`*^9, 
   3.873653786501913*^9}, 3.87365404387046*^9, 3.873654361803931*^9, {
   3.87372155376371*^9, 3.873721561299271*^9}, 3.873721650734617*^9, 
   3.8737219024108458`*^9, 3.873722043428874*^9, 3.873722123634899*^9, 
   3.873733113953574*^9},
 CellLabel->
  "During evaluation of \
In[57]:=",ExpressionUUID->"48190296-32ac-4f74-9aa5-70dca3d9a072"],

Cell[BoxData["6500"], "Print",
 CellChangeTimes->{
  3.873460359121327*^9, 3.873472184817514*^9, 3.873514600528822*^9, {
   3.873619706528304*^9, 3.873619723121772*^9}, 3.87361979983558*^9, 
   3.873619938604599*^9, 3.873620552458734*^9, 3.873621456358457*^9, 
   3.8736536395043993`*^9, 3.873653697978847*^9, {3.8736537605376453`*^9, 
   3.873653786501913*^9}, 3.87365404387046*^9, 3.873654361803931*^9, {
   3.87372155376371*^9, 3.873721561299271*^9}, 3.873721650734617*^9, 
   3.8737219024108458`*^9, 3.873722043428874*^9, 3.873722123634899*^9, 
   3.873733192710114*^9},
 CellLabel->
  "During evaluation of \
In[57]:=",ExpressionUUID->"9ddbfc4d-df8f-4fc1-9aff-7dc86beb4138"],

Cell[BoxData["6550"], "Print",
 CellChangeTimes->{
  3.873460359121327*^9, 3.873472184817514*^9, 3.873514600528822*^9, {
   3.873619706528304*^9, 3.873619723121772*^9}, 3.87361979983558*^9, 
   3.873619938604599*^9, 3.873620552458734*^9, 3.873621456358457*^9, 
   3.8736536395043993`*^9, 3.873653697978847*^9, {3.8736537605376453`*^9, 
   3.873653786501913*^9}, 3.87365404387046*^9, 3.873654361803931*^9, {
   3.87372155376371*^9, 3.873721561299271*^9}, 3.873721650734617*^9, 
   3.8737219024108458`*^9, 3.873722043428874*^9, 3.873722123634899*^9, 
   3.873733271120186*^9},
 CellLabel->
  "During evaluation of \
In[57]:=",ExpressionUUID->"100d10a0-696e-4c38-af49-749ddf510de9"],

Cell[BoxData["6600"], "Print",
 CellChangeTimes->{
  3.873460359121327*^9, 3.873472184817514*^9, 3.873514600528822*^9, {
   3.873619706528304*^9, 3.873619723121772*^9}, 3.87361979983558*^9, 
   3.873619938604599*^9, 3.873620552458734*^9, 3.873621456358457*^9, 
   3.8736536395043993`*^9, 3.873653697978847*^9, {3.8736537605376453`*^9, 
   3.873653786501913*^9}, 3.87365404387046*^9, 3.873654361803931*^9, {
   3.87372155376371*^9, 3.873721561299271*^9}, 3.873721650734617*^9, 
   3.8737219024108458`*^9, 3.873722043428874*^9, 3.873722123634899*^9, 
   3.873733349270941*^9},
 CellLabel->
  "During evaluation of \
In[57]:=",ExpressionUUID->"3d56ce73-c8c7-489a-986d-ed7209c87ec7"],

Cell[BoxData["6650"], "Print",
 CellChangeTimes->{
  3.873460359121327*^9, 3.873472184817514*^9, 3.873514600528822*^9, {
   3.873619706528304*^9, 3.873619723121772*^9}, 3.87361979983558*^9, 
   3.873619938604599*^9, 3.873620552458734*^9, 3.873621456358457*^9, 
   3.8736536395043993`*^9, 3.873653697978847*^9, {3.8736537605376453`*^9, 
   3.873653786501913*^9}, 3.87365404387046*^9, 3.873654361803931*^9, {
   3.87372155376371*^9, 3.873721561299271*^9}, 3.873721650734617*^9, 
   3.8737219024108458`*^9, 3.873722043428874*^9, 3.873722123634899*^9, 
   3.873733427293748*^9},
 CellLabel->
  "During evaluation of \
In[57]:=",ExpressionUUID->"c27b2844-9d9b-4216-b302-a5a744471687"],

Cell[BoxData["6700"], "Print",
 CellChangeTimes->{
  3.873460359121327*^9, 3.873472184817514*^9, 3.873514600528822*^9, {
   3.873619706528304*^9, 3.873619723121772*^9}, 3.87361979983558*^9, 
   3.873619938604599*^9, 3.873620552458734*^9, 3.873621456358457*^9, 
   3.8736536395043993`*^9, 3.873653697978847*^9, {3.8736537605376453`*^9, 
   3.873653786501913*^9}, 3.87365404387046*^9, 3.873654361803931*^9, {
   3.87372155376371*^9, 3.873721561299271*^9}, 3.873721650734617*^9, 
   3.8737219024108458`*^9, 3.873722043428874*^9, 3.873722123634899*^9, 
   3.873733506239777*^9},
 CellLabel->
  "During evaluation of \
In[57]:=",ExpressionUUID->"c60fe071-a478-464a-ba2b-6f0f20ae5ba1"],

Cell[BoxData["6750"], "Print",
 CellChangeTimes->{
  3.873460359121327*^9, 3.873472184817514*^9, 3.873514600528822*^9, {
   3.873619706528304*^9, 3.873619723121772*^9}, 3.87361979983558*^9, 
   3.873619938604599*^9, 3.873620552458734*^9, 3.873621456358457*^9, 
   3.8736536395043993`*^9, 3.873653697978847*^9, {3.8736537605376453`*^9, 
   3.873653786501913*^9}, 3.87365404387046*^9, 3.873654361803931*^9, {
   3.87372155376371*^9, 3.873721561299271*^9}, 3.873721650734617*^9, 
   3.8737219024108458`*^9, 3.873722043428874*^9, 3.873722123634899*^9, 
   3.873733584962227*^9},
 CellLabel->
  "During evaluation of \
In[57]:=",ExpressionUUID->"41deb5d2-509e-4807-8fac-b09a2c84c05f"],

Cell[BoxData["6800"], "Print",
 CellChangeTimes->{
  3.873460359121327*^9, 3.873472184817514*^9, 3.873514600528822*^9, {
   3.873619706528304*^9, 3.873619723121772*^9}, 3.87361979983558*^9, 
   3.873619938604599*^9, 3.873620552458734*^9, 3.873621456358457*^9, 
   3.8736536395043993`*^9, 3.873653697978847*^9, {3.8736537605376453`*^9, 
   3.873653786501913*^9}, 3.87365404387046*^9, 3.873654361803931*^9, {
   3.87372155376371*^9, 3.873721561299271*^9}, 3.873721650734617*^9, 
   3.8737219024108458`*^9, 3.873722043428874*^9, 3.873722123634899*^9, 
   3.873733663388377*^9},
 CellLabel->
  "During evaluation of \
In[57]:=",ExpressionUUID->"db6cc5f6-6a3f-4023-b689-1cd63fd46bb7"],

Cell[BoxData["6850"], "Print",
 CellChangeTimes->{
  3.873460359121327*^9, 3.873472184817514*^9, 3.873514600528822*^9, {
   3.873619706528304*^9, 3.873619723121772*^9}, 3.87361979983558*^9, 
   3.873619938604599*^9, 3.873620552458734*^9, 3.873621456358457*^9, 
   3.8736536395043993`*^9, 3.873653697978847*^9, {3.8736537605376453`*^9, 
   3.873653786501913*^9}, 3.87365404387046*^9, 3.873654361803931*^9, {
   3.87372155376371*^9, 3.873721561299271*^9}, 3.873721650734617*^9, 
   3.8737219024108458`*^9, 3.873722043428874*^9, 3.873722123634899*^9, 
   3.87373374182829*^9},
 CellLabel->
  "During evaluation of \
In[57]:=",ExpressionUUID->"a1e1ff9b-63b6-4710-811a-bca369829012"],

Cell[BoxData["6900"], "Print",
 CellChangeTimes->{
  3.873460359121327*^9, 3.873472184817514*^9, 3.873514600528822*^9, {
   3.873619706528304*^9, 3.873619723121772*^9}, 3.87361979983558*^9, 
   3.873619938604599*^9, 3.873620552458734*^9, 3.873621456358457*^9, 
   3.8736536395043993`*^9, 3.873653697978847*^9, {3.8736537605376453`*^9, 
   3.873653786501913*^9}, 3.87365404387046*^9, 3.873654361803931*^9, {
   3.87372155376371*^9, 3.873721561299271*^9}, 3.873721650734617*^9, 
   3.8737219024108458`*^9, 3.873722043428874*^9, 3.873722123634899*^9, 
   3.873733819328314*^9},
 CellLabel->
  "During evaluation of \
In[57]:=",ExpressionUUID->"a9cd0907-a45c-4f1b-9068-67d00ece49c2"],

Cell[BoxData["6950"], "Print",
 CellChangeTimes->{
  3.873460359121327*^9, 3.873472184817514*^9, 3.873514600528822*^9, {
   3.873619706528304*^9, 3.873619723121772*^9}, 3.87361979983558*^9, 
   3.873619938604599*^9, 3.873620552458734*^9, 3.873621456358457*^9, 
   3.8736536395043993`*^9, 3.873653697978847*^9, {3.8736537605376453`*^9, 
   3.873653786501913*^9}, 3.87365404387046*^9, 3.873654361803931*^9, {
   3.87372155376371*^9, 3.873721561299271*^9}, 3.873721650734617*^9, 
   3.8737219024108458`*^9, 3.873722043428874*^9, 3.873722123634899*^9, 
   3.8737338964672956`*^9},
 CellLabel->
  "During evaluation of \
In[57]:=",ExpressionUUID->"60443f85-7165-4fdc-8b68-c6892918cb1a"],

Cell[BoxData["7000"], "Print",
 CellChangeTimes->{
  3.873460359121327*^9, 3.873472184817514*^9, 3.873514600528822*^9, {
   3.873619706528304*^9, 3.873619723121772*^9}, 3.87361979983558*^9, 
   3.873619938604599*^9, 3.873620552458734*^9, 3.873621456358457*^9, 
   3.8736536395043993`*^9, 3.873653697978847*^9, {3.8736537605376453`*^9, 
   3.873653786501913*^9}, 3.87365404387046*^9, 3.873654361803931*^9, {
   3.87372155376371*^9, 3.873721561299271*^9}, 3.873721650734617*^9, 
   3.8737219024108458`*^9, 3.873722043428874*^9, 3.873722123634899*^9, 
   3.873733974413576*^9},
 CellLabel->
  "During evaluation of \
In[57]:=",ExpressionUUID->"bd4c3358-b411-4531-a829-fae300c88b22"],

Cell[BoxData["7050"], "Print",
 CellChangeTimes->{
  3.873460359121327*^9, 3.873472184817514*^9, 3.873514600528822*^9, {
   3.873619706528304*^9, 3.873619723121772*^9}, 3.87361979983558*^9, 
   3.873619938604599*^9, 3.873620552458734*^9, 3.873621456358457*^9, 
   3.8736536395043993`*^9, 3.873653697978847*^9, {3.8736537605376453`*^9, 
   3.873653786501913*^9}, 3.87365404387046*^9, 3.873654361803931*^9, {
   3.87372155376371*^9, 3.873721561299271*^9}, 3.873721650734617*^9, 
   3.8737219024108458`*^9, 3.873722043428874*^9, 3.873722123634899*^9, 
   3.873734052406601*^9},
 CellLabel->
  "During evaluation of \
In[57]:=",ExpressionUUID->"e02c3218-ebbb-4991-b6cf-3ee6174e8ba7"],

Cell[BoxData["7100"], "Print",
 CellChangeTimes->{
  3.873460359121327*^9, 3.873472184817514*^9, 3.873514600528822*^9, {
   3.873619706528304*^9, 3.873619723121772*^9}, 3.87361979983558*^9, 
   3.873619938604599*^9, 3.873620552458734*^9, 3.873621456358457*^9, 
   3.8736536395043993`*^9, 3.873653697978847*^9, {3.8736537605376453`*^9, 
   3.873653786501913*^9}, 3.87365404387046*^9, 3.873654361803931*^9, {
   3.87372155376371*^9, 3.873721561299271*^9}, 3.873721650734617*^9, 
   3.8737219024108458`*^9, 3.873722043428874*^9, 3.873722123634899*^9, 
   3.873734130326624*^9},
 CellLabel->
  "During evaluation of \
In[57]:=",ExpressionUUID->"68252b67-5b01-48be-814b-daa748c92c23"],

Cell[BoxData["7150"], "Print",
 CellChangeTimes->{
  3.873460359121327*^9, 3.873472184817514*^9, 3.873514600528822*^9, {
   3.873619706528304*^9, 3.873619723121772*^9}, 3.87361979983558*^9, 
   3.873619938604599*^9, 3.873620552458734*^9, 3.873621456358457*^9, 
   3.8736536395043993`*^9, 3.873653697978847*^9, {3.8736537605376453`*^9, 
   3.873653786501913*^9}, 3.87365404387046*^9, 3.873654361803931*^9, {
   3.87372155376371*^9, 3.873721561299271*^9}, 3.873721650734617*^9, 
   3.8737219024108458`*^9, 3.873722043428874*^9, 3.873722123634899*^9, 
   3.873734208078726*^9},
 CellLabel->
  "During evaluation of \
In[57]:=",ExpressionUUID->"eef656ce-bfc0-409f-b345-032f131275b7"],

Cell[BoxData["7200"], "Print",
 CellChangeTimes->{
  3.873460359121327*^9, 3.873472184817514*^9, 3.873514600528822*^9, {
   3.873619706528304*^9, 3.873619723121772*^9}, 3.87361979983558*^9, 
   3.873619938604599*^9, 3.873620552458734*^9, 3.873621456358457*^9, 
   3.8736536395043993`*^9, 3.873653697978847*^9, {3.8736537605376453`*^9, 
   3.873653786501913*^9}, 3.87365404387046*^9, 3.873654361803931*^9, {
   3.87372155376371*^9, 3.873721561299271*^9}, 3.873721650734617*^9, 
   3.8737219024108458`*^9, 3.873722043428874*^9, 3.873722123634899*^9, 
   3.873734287424165*^9},
 CellLabel->
  "During evaluation of \
In[57]:=",ExpressionUUID->"36d9b3b5-4202-4caf-a264-a7967d2f9c5b"],

Cell[BoxData["7250"], "Print",
 CellChangeTimes->{
  3.873460359121327*^9, 3.873472184817514*^9, 3.873514600528822*^9, {
   3.873619706528304*^9, 3.873619723121772*^9}, 3.87361979983558*^9, 
   3.873619938604599*^9, 3.873620552458734*^9, 3.873621456358457*^9, 
   3.8736536395043993`*^9, 3.873653697978847*^9, {3.8736537605376453`*^9, 
   3.873653786501913*^9}, 3.87365404387046*^9, 3.873654361803931*^9, {
   3.87372155376371*^9, 3.873721561299271*^9}, 3.873721650734617*^9, 
   3.8737219024108458`*^9, 3.873722043428874*^9, 3.873722123634899*^9, 
   3.87373436561874*^9},
 CellLabel->
  "During evaluation of \
In[57]:=",ExpressionUUID->"5d506e2d-dfc3-4f75-97ac-48cc83527adb"],

Cell[BoxData["7300"], "Print",
 CellChangeTimes->{
  3.873460359121327*^9, 3.873472184817514*^9, 3.873514600528822*^9, {
   3.873619706528304*^9, 3.873619723121772*^9}, 3.87361979983558*^9, 
   3.873619938604599*^9, 3.873620552458734*^9, 3.873621456358457*^9, 
   3.8736536395043993`*^9, 3.873653697978847*^9, {3.8736537605376453`*^9, 
   3.873653786501913*^9}, 3.87365404387046*^9, 3.873654361803931*^9, {
   3.87372155376371*^9, 3.873721561299271*^9}, 3.873721650734617*^9, 
   3.8737219024108458`*^9, 3.873722043428874*^9, 3.873722123634899*^9, 
   3.873734443803011*^9},
 CellLabel->
  "During evaluation of \
In[57]:=",ExpressionUUID->"7a49d6b1-bdb9-4d0f-8f7b-bf155adf14f1"],

Cell[BoxData["7350"], "Print",
 CellChangeTimes->{
  3.873460359121327*^9, 3.873472184817514*^9, 3.873514600528822*^9, {
   3.873619706528304*^9, 3.873619723121772*^9}, 3.87361979983558*^9, 
   3.873619938604599*^9, 3.873620552458734*^9, 3.873621456358457*^9, 
   3.8736536395043993`*^9, 3.873653697978847*^9, {3.8736537605376453`*^9, 
   3.873653786501913*^9}, 3.87365404387046*^9, 3.873654361803931*^9, {
   3.87372155376371*^9, 3.873721561299271*^9}, 3.873721650734617*^9, 
   3.8737219024108458`*^9, 3.873722043428874*^9, 3.873722123634899*^9, 
   3.873734521888585*^9},
 CellLabel->
  "During evaluation of \
In[57]:=",ExpressionUUID->"7dc43fdc-6d79-445e-a1ee-850191dcd88c"],

Cell[BoxData["7400"], "Print",
 CellChangeTimes->{
  3.873460359121327*^9, 3.873472184817514*^9, 3.873514600528822*^9, {
   3.873619706528304*^9, 3.873619723121772*^9}, 3.87361979983558*^9, 
   3.873619938604599*^9, 3.873620552458734*^9, 3.873621456358457*^9, 
   3.8736536395043993`*^9, 3.873653697978847*^9, {3.8736537605376453`*^9, 
   3.873653786501913*^9}, 3.87365404387046*^9, 3.873654361803931*^9, {
   3.87372155376371*^9, 3.873721561299271*^9}, 3.873721650734617*^9, 
   3.8737219024108458`*^9, 3.873722043428874*^9, 3.873722123634899*^9, 
   3.873734600784349*^9},
 CellLabel->
  "During evaluation of \
In[57]:=",ExpressionUUID->"7c23ebc3-4b9a-43c8-b14b-6c81db02aebb"],

Cell[BoxData["7450"], "Print",
 CellChangeTimes->{
  3.873460359121327*^9, 3.873472184817514*^9, 3.873514600528822*^9, {
   3.873619706528304*^9, 3.873619723121772*^9}, 3.87361979983558*^9, 
   3.873619938604599*^9, 3.873620552458734*^9, 3.873621456358457*^9, 
   3.8736536395043993`*^9, 3.873653697978847*^9, {3.8736537605376453`*^9, 
   3.873653786501913*^9}, 3.87365404387046*^9, 3.873654361803931*^9, {
   3.87372155376371*^9, 3.873721561299271*^9}, 3.873721650734617*^9, 
   3.8737219024108458`*^9, 3.873722043428874*^9, 3.873722123634899*^9, 
   3.873734678971946*^9},
 CellLabel->
  "During evaluation of \
In[57]:=",ExpressionUUID->"9d712f02-c9ab-40fe-aa1a-ebaaef8d093d"],

Cell[BoxData["7500"], "Print",
 CellChangeTimes->{
  3.873460359121327*^9, 3.873472184817514*^9, 3.873514600528822*^9, {
   3.873619706528304*^9, 3.873619723121772*^9}, 3.87361979983558*^9, 
   3.873619938604599*^9, 3.873620552458734*^9, 3.873621456358457*^9, 
   3.8736536395043993`*^9, 3.873653697978847*^9, {3.8736537605376453`*^9, 
   3.873653786501913*^9}, 3.87365404387046*^9, 3.873654361803931*^9, {
   3.87372155376371*^9, 3.873721561299271*^9}, 3.873721650734617*^9, 
   3.8737219024108458`*^9, 3.873722043428874*^9, 3.873722123634899*^9, 
   3.873734756283751*^9},
 CellLabel->
  "During evaluation of \
In[57]:=",ExpressionUUID->"6500dc65-89c7-4270-85fe-a1342944b363"],

Cell[BoxData["7550"], "Print",
 CellChangeTimes->{
  3.873460359121327*^9, 3.873472184817514*^9, 3.873514600528822*^9, {
   3.873619706528304*^9, 3.873619723121772*^9}, 3.87361979983558*^9, 
   3.873619938604599*^9, 3.873620552458734*^9, 3.873621456358457*^9, 
   3.8736536395043993`*^9, 3.873653697978847*^9, {3.8736537605376453`*^9, 
   3.873653786501913*^9}, 3.87365404387046*^9, 3.873654361803931*^9, {
   3.87372155376371*^9, 3.873721561299271*^9}, 3.873721650734617*^9, 
   3.8737219024108458`*^9, 3.873722043428874*^9, 3.873722123634899*^9, 
   3.873734834530377*^9},
 CellLabel->
  "During evaluation of \
In[57]:=",ExpressionUUID->"0ca858b5-15f9-4d5d-b71b-bef5cabe3e2f"],

Cell[BoxData["7600"], "Print",
 CellChangeTimes->{
  3.873460359121327*^9, 3.873472184817514*^9, 3.873514600528822*^9, {
   3.873619706528304*^9, 3.873619723121772*^9}, 3.87361979983558*^9, 
   3.873619938604599*^9, 3.873620552458734*^9, 3.873621456358457*^9, 
   3.8736536395043993`*^9, 3.873653697978847*^9, {3.8736537605376453`*^9, 
   3.873653786501913*^9}, 3.87365404387046*^9, 3.873654361803931*^9, {
   3.87372155376371*^9, 3.873721561299271*^9}, 3.873721650734617*^9, 
   3.8737219024108458`*^9, 3.873722043428874*^9, 3.873722123634899*^9, 
   3.8737349125758247`*^9},
 CellLabel->
  "During evaluation of \
In[57]:=",ExpressionUUID->"b8879076-d7c8-4f9e-a86d-a199baea8a60"],

Cell[BoxData["7650"], "Print",
 CellChangeTimes->{
  3.873460359121327*^9, 3.873472184817514*^9, 3.873514600528822*^9, {
   3.873619706528304*^9, 3.873619723121772*^9}, 3.87361979983558*^9, 
   3.873619938604599*^9, 3.873620552458734*^9, 3.873621456358457*^9, 
   3.8736536395043993`*^9, 3.873653697978847*^9, {3.8736537605376453`*^9, 
   3.873653786501913*^9}, 3.87365404387046*^9, 3.873654361803931*^9, {
   3.87372155376371*^9, 3.873721561299271*^9}, 3.873721650734617*^9, 
   3.8737219024108458`*^9, 3.873722043428874*^9, 3.873722123634899*^9, 
   3.873734989996922*^9},
 CellLabel->
  "During evaluation of \
In[57]:=",ExpressionUUID->"2da2f058-2b41-4cdb-be89-be57561d0889"],

Cell[BoxData["7700"], "Print",
 CellChangeTimes->{
  3.873460359121327*^9, 3.873472184817514*^9, 3.873514600528822*^9, {
   3.873619706528304*^9, 3.873619723121772*^9}, 3.87361979983558*^9, 
   3.873619938604599*^9, 3.873620552458734*^9, 3.873621456358457*^9, 
   3.8736536395043993`*^9, 3.873653697978847*^9, {3.8736537605376453`*^9, 
   3.873653786501913*^9}, 3.87365404387046*^9, 3.873654361803931*^9, {
   3.87372155376371*^9, 3.873721561299271*^9}, 3.873721650734617*^9, 
   3.8737219024108458`*^9, 3.873722043428874*^9, 3.873722123634899*^9, 
   3.8737350680574093`*^9},
 CellLabel->
  "During evaluation of \
In[57]:=",ExpressionUUID->"20282d97-579f-44c8-ac37-1ad68df5655c"],

Cell[BoxData["7750"], "Print",
 CellChangeTimes->{
  3.873460359121327*^9, 3.873472184817514*^9, 3.873514600528822*^9, {
   3.873619706528304*^9, 3.873619723121772*^9}, 3.87361979983558*^9, 
   3.873619938604599*^9, 3.873620552458734*^9, 3.873621456358457*^9, 
   3.8736536395043993`*^9, 3.873653697978847*^9, {3.8736537605376453`*^9, 
   3.873653786501913*^9}, 3.87365404387046*^9, 3.873654361803931*^9, {
   3.87372155376371*^9, 3.873721561299271*^9}, 3.873721650734617*^9, 
   3.8737219024108458`*^9, 3.873722043428874*^9, 3.873722123634899*^9, 
   3.873735146972248*^9},
 CellLabel->
  "During evaluation of \
In[57]:=",ExpressionUUID->"7460e073-a7ff-4b75-9d81-b3c66d58c0c6"],

Cell[BoxData["7800"], "Print",
 CellChangeTimes->{
  3.873460359121327*^9, 3.873472184817514*^9, 3.873514600528822*^9, {
   3.873619706528304*^9, 3.873619723121772*^9}, 3.87361979983558*^9, 
   3.873619938604599*^9, 3.873620552458734*^9, 3.873621456358457*^9, 
   3.8736536395043993`*^9, 3.873653697978847*^9, {3.8736537605376453`*^9, 
   3.873653786501913*^9}, 3.87365404387046*^9, 3.873654361803931*^9, {
   3.87372155376371*^9, 3.873721561299271*^9}, 3.873721650734617*^9, 
   3.8737219024108458`*^9, 3.873722043428874*^9, 3.873722123634899*^9, 
   3.8737352243071117`*^9},
 CellLabel->
  "During evaluation of \
In[57]:=",ExpressionUUID->"bcc1d2bc-4348-40c9-9d3e-991fa5a927ee"],

Cell[BoxData["7850"], "Print",
 CellChangeTimes->{
  3.873460359121327*^9, 3.873472184817514*^9, 3.873514600528822*^9, {
   3.873619706528304*^9, 3.873619723121772*^9}, 3.87361979983558*^9, 
   3.873619938604599*^9, 3.873620552458734*^9, 3.873621456358457*^9, 
   3.8736536395043993`*^9, 3.873653697978847*^9, {3.8736537605376453`*^9, 
   3.873653786501913*^9}, 3.87365404387046*^9, 3.873654361803931*^9, {
   3.87372155376371*^9, 3.873721561299271*^9}, 3.873721650734617*^9, 
   3.8737219024108458`*^9, 3.873722043428874*^9, 3.873722123634899*^9, 
   3.873735302764674*^9},
 CellLabel->
  "During evaluation of \
In[57]:=",ExpressionUUID->"469df03a-0373-47f0-ad34-517c1f72b584"],

Cell[BoxData["7900"], "Print",
 CellChangeTimes->{
  3.873460359121327*^9, 3.873472184817514*^9, 3.873514600528822*^9, {
   3.873619706528304*^9, 3.873619723121772*^9}, 3.87361979983558*^9, 
   3.873619938604599*^9, 3.873620552458734*^9, 3.873621456358457*^9, 
   3.8736536395043993`*^9, 3.873653697978847*^9, {3.8736537605376453`*^9, 
   3.873653786501913*^9}, 3.87365404387046*^9, 3.873654361803931*^9, {
   3.87372155376371*^9, 3.873721561299271*^9}, 3.873721650734617*^9, 
   3.8737219024108458`*^9, 3.873722043428874*^9, 3.873722123634899*^9, 
   3.873735381019279*^9},
 CellLabel->
  "During evaluation of \
In[57]:=",ExpressionUUID->"084f2042-6925-4f6c-97bb-05919e9f3d09"],

Cell[BoxData["7950"], "Print",
 CellChangeTimes->{
  3.873460359121327*^9, 3.873472184817514*^9, 3.873514600528822*^9, {
   3.873619706528304*^9, 3.873619723121772*^9}, 3.87361979983558*^9, 
   3.873619938604599*^9, 3.873620552458734*^9, 3.873621456358457*^9, 
   3.8736536395043993`*^9, 3.873653697978847*^9, {3.8736537605376453`*^9, 
   3.873653786501913*^9}, 3.87365404387046*^9, 3.873654361803931*^9, {
   3.87372155376371*^9, 3.873721561299271*^9}, 3.873721650734617*^9, 
   3.8737219024108458`*^9, 3.873722043428874*^9, 3.873722123634899*^9, 
   3.8737354593699903`*^9},
 CellLabel->
  "During evaluation of \
In[57]:=",ExpressionUUID->"ad999000-e7c8-4da1-8262-405e36ef229b"],

Cell[BoxData["8000"], "Print",
 CellChangeTimes->{
  3.873460359121327*^9, 3.873472184817514*^9, 3.873514600528822*^9, {
   3.873619706528304*^9, 3.873619723121772*^9}, 3.87361979983558*^9, 
   3.873619938604599*^9, 3.873620552458734*^9, 3.873621456358457*^9, 
   3.8736536395043993`*^9, 3.873653697978847*^9, {3.8736537605376453`*^9, 
   3.873653786501913*^9}, 3.87365404387046*^9, 3.873654361803931*^9, {
   3.87372155376371*^9, 3.873721561299271*^9}, 3.873721650734617*^9, 
   3.8737219024108458`*^9, 3.873722043428874*^9, 3.873722123634899*^9, 
   3.873735537894641*^9},
 CellLabel->
  "During evaluation of \
In[57]:=",ExpressionUUID->"2120e966-aa56-46f2-ae8c-2eb76ee2225d"],

Cell[BoxData["8050"], "Print",
 CellChangeTimes->{
  3.873460359121327*^9, 3.873472184817514*^9, 3.873514600528822*^9, {
   3.873619706528304*^9, 3.873619723121772*^9}, 3.87361979983558*^9, 
   3.873619938604599*^9, 3.873620552458734*^9, 3.873621456358457*^9, 
   3.8736536395043993`*^9, 3.873653697978847*^9, {3.8736537605376453`*^9, 
   3.873653786501913*^9}, 3.87365404387046*^9, 3.873654361803931*^9, {
   3.87372155376371*^9, 3.873721561299271*^9}, 3.873721650734617*^9, 
   3.8737219024108458`*^9, 3.873722043428874*^9, 3.873722123634899*^9, 
   3.873735616293358*^9},
 CellLabel->
  "During evaluation of \
In[57]:=",ExpressionUUID->"f4a17087-8811-486d-b668-0b3e26dac0d4"],

Cell[BoxData["8100"], "Print",
 CellChangeTimes->{
  3.873460359121327*^9, 3.873472184817514*^9, 3.873514600528822*^9, {
   3.873619706528304*^9, 3.873619723121772*^9}, 3.87361979983558*^9, 
   3.873619938604599*^9, 3.873620552458734*^9, 3.873621456358457*^9, 
   3.8736536395043993`*^9, 3.873653697978847*^9, {3.8736537605376453`*^9, 
   3.873653786501913*^9}, 3.87365404387046*^9, 3.873654361803931*^9, {
   3.87372155376371*^9, 3.873721561299271*^9}, 3.873721650734617*^9, 
   3.8737219024108458`*^9, 3.873722043428874*^9, 3.873722123634899*^9, 
   3.873735693893798*^9},
 CellLabel->
  "During evaluation of \
In[57]:=",ExpressionUUID->"be6b15db-5fc2-4ee7-9919-a256376575f7"],

Cell[BoxData["8150"], "Print",
 CellChangeTimes->{
  3.873460359121327*^9, 3.873472184817514*^9, 3.873514600528822*^9, {
   3.873619706528304*^9, 3.873619723121772*^9}, 3.87361979983558*^9, 
   3.873619938604599*^9, 3.873620552458734*^9, 3.873621456358457*^9, 
   3.8736536395043993`*^9, 3.873653697978847*^9, {3.8736537605376453`*^9, 
   3.873653786501913*^9}, 3.87365404387046*^9, 3.873654361803931*^9, {
   3.87372155376371*^9, 3.873721561299271*^9}, 3.873721650734617*^9, 
   3.8737219024108458`*^9, 3.873722043428874*^9, 3.873722123634899*^9, 
   3.873735772075368*^9},
 CellLabel->
  "During evaluation of \
In[57]:=",ExpressionUUID->"66f914e7-64d2-4081-a10d-3b9ff138d960"],

Cell[BoxData["8200"], "Print",
 CellChangeTimes->{
  3.873460359121327*^9, 3.873472184817514*^9, 3.873514600528822*^9, {
   3.873619706528304*^9, 3.873619723121772*^9}, 3.87361979983558*^9, 
   3.873619938604599*^9, 3.873620552458734*^9, 3.873621456358457*^9, 
   3.8736536395043993`*^9, 3.873653697978847*^9, {3.8736537605376453`*^9, 
   3.873653786501913*^9}, 3.87365404387046*^9, 3.873654361803931*^9, {
   3.87372155376371*^9, 3.873721561299271*^9}, 3.873721650734617*^9, 
   3.8737219024108458`*^9, 3.873722043428874*^9, 3.873722123634899*^9, 
   3.873735850733149*^9},
 CellLabel->
  "During evaluation of \
In[57]:=",ExpressionUUID->"a043e048-51c3-4d11-8127-4affc64eed9b"],

Cell[BoxData["8250"], "Print",
 CellChangeTimes->{
  3.873460359121327*^9, 3.873472184817514*^9, 3.873514600528822*^9, {
   3.873619706528304*^9, 3.873619723121772*^9}, 3.87361979983558*^9, 
   3.873619938604599*^9, 3.873620552458734*^9, 3.873621456358457*^9, 
   3.8736536395043993`*^9, 3.873653697978847*^9, {3.8736537605376453`*^9, 
   3.873653786501913*^9}, 3.87365404387046*^9, 3.873654361803931*^9, {
   3.87372155376371*^9, 3.873721561299271*^9}, 3.873721650734617*^9, 
   3.8737219024108458`*^9, 3.873722043428874*^9, 3.873722123634899*^9, 
   3.873735929458952*^9},
 CellLabel->
  "During evaluation of \
In[57]:=",ExpressionUUID->"e57b84ba-d7fd-45a7-9728-2ff14cf5b286"],

Cell[BoxData["8300"], "Print",
 CellChangeTimes->{
  3.873460359121327*^9, 3.873472184817514*^9, 3.873514600528822*^9, {
   3.873619706528304*^9, 3.873619723121772*^9}, 3.87361979983558*^9, 
   3.873619938604599*^9, 3.873620552458734*^9, 3.873621456358457*^9, 
   3.8736536395043993`*^9, 3.873653697978847*^9, {3.8736537605376453`*^9, 
   3.873653786501913*^9}, 3.87365404387046*^9, 3.873654361803931*^9, {
   3.87372155376371*^9, 3.873721561299271*^9}, 3.873721650734617*^9, 
   3.8737219024108458`*^9, 3.873722043428874*^9, 3.873722123634899*^9, 
   3.873736008193214*^9},
 CellLabel->
  "During evaluation of \
In[57]:=",ExpressionUUID->"c6d6ef2f-7b39-4686-a166-956c8663e143"],

Cell[BoxData["8350"], "Print",
 CellChangeTimes->{
  3.873460359121327*^9, 3.873472184817514*^9, 3.873514600528822*^9, {
   3.873619706528304*^9, 3.873619723121772*^9}, 3.87361979983558*^9, 
   3.873619938604599*^9, 3.873620552458734*^9, 3.873621456358457*^9, 
   3.8736536395043993`*^9, 3.873653697978847*^9, {3.8736537605376453`*^9, 
   3.873653786501913*^9}, 3.87365404387046*^9, 3.873654361803931*^9, {
   3.87372155376371*^9, 3.873721561299271*^9}, 3.873721650734617*^9, 
   3.8737219024108458`*^9, 3.873722043428874*^9, 3.873722123634899*^9, 
   3.8737360863199883`*^9},
 CellLabel->
  "During evaluation of \
In[57]:=",ExpressionUUID->"de299edd-30cf-4217-9bfb-d8fa03767e4b"],

Cell[BoxData["8400"], "Print",
 CellChangeTimes->{
  3.873460359121327*^9, 3.873472184817514*^9, 3.873514600528822*^9, {
   3.873619706528304*^9, 3.873619723121772*^9}, 3.87361979983558*^9, 
   3.873619938604599*^9, 3.873620552458734*^9, 3.873621456358457*^9, 
   3.8736536395043993`*^9, 3.873653697978847*^9, {3.8736537605376453`*^9, 
   3.873653786501913*^9}, 3.87365404387046*^9, 3.873654361803931*^9, {
   3.87372155376371*^9, 3.873721561299271*^9}, 3.873721650734617*^9, 
   3.8737219024108458`*^9, 3.873722043428874*^9, 3.873722123634899*^9, 
   3.87373616366576*^9},
 CellLabel->
  "During evaluation of \
In[57]:=",ExpressionUUID->"bdbc4d73-b6ff-46ad-b867-cc187a7c0c71"],

Cell[BoxData["8450"], "Print",
 CellChangeTimes->{
  3.873460359121327*^9, 3.873472184817514*^9, 3.873514600528822*^9, {
   3.873619706528304*^9, 3.873619723121772*^9}, 3.87361979983558*^9, 
   3.873619938604599*^9, 3.873620552458734*^9, 3.873621456358457*^9, 
   3.8736536395043993`*^9, 3.873653697978847*^9, {3.8736537605376453`*^9, 
   3.873653786501913*^9}, 3.87365404387046*^9, 3.873654361803931*^9, {
   3.87372155376371*^9, 3.873721561299271*^9}, 3.873721650734617*^9, 
   3.8737219024108458`*^9, 3.873722043428874*^9, 3.873722123634899*^9, 
   3.873736241527421*^9},
 CellLabel->
  "During evaluation of \
In[57]:=",ExpressionUUID->"554eb7eb-0985-419a-8e16-91c62c3695b6"],

Cell[BoxData["8500"], "Print",
 CellChangeTimes->{
  3.873460359121327*^9, 3.873472184817514*^9, 3.873514600528822*^9, {
   3.873619706528304*^9, 3.873619723121772*^9}, 3.87361979983558*^9, 
   3.873619938604599*^9, 3.873620552458734*^9, 3.873621456358457*^9, 
   3.8736536395043993`*^9, 3.873653697978847*^9, {3.8736537605376453`*^9, 
   3.873653786501913*^9}, 3.87365404387046*^9, 3.873654361803931*^9, {
   3.87372155376371*^9, 3.873721561299271*^9}, 3.873721650734617*^9, 
   3.8737219024108458`*^9, 3.873722043428874*^9, 3.873722123634899*^9, 
   3.873736319419105*^9},
 CellLabel->
  "During evaluation of \
In[57]:=",ExpressionUUID->"cb42688a-b2e7-4b5c-992d-cdf02f22afdc"],

Cell[BoxData["8550"], "Print",
 CellChangeTimes->{
  3.873460359121327*^9, 3.873472184817514*^9, 3.873514600528822*^9, {
   3.873619706528304*^9, 3.873619723121772*^9}, 3.87361979983558*^9, 
   3.873619938604599*^9, 3.873620552458734*^9, 3.873621456358457*^9, 
   3.8736536395043993`*^9, 3.873653697978847*^9, {3.8736537605376453`*^9, 
   3.873653786501913*^9}, 3.87365404387046*^9, 3.873654361803931*^9, {
   3.87372155376371*^9, 3.873721561299271*^9}, 3.873721650734617*^9, 
   3.8737219024108458`*^9, 3.873722043428874*^9, 3.873722123634899*^9, 
   3.8737363971552877`*^9},
 CellLabel->
  "During evaluation of \
In[57]:=",ExpressionUUID->"1d733694-99f5-4474-9292-d1bcf73fbf0d"],

Cell[BoxData["8600"], "Print",
 CellChangeTimes->{
  3.873460359121327*^9, 3.873472184817514*^9, 3.873514600528822*^9, {
   3.873619706528304*^9, 3.873619723121772*^9}, 3.87361979983558*^9, 
   3.873619938604599*^9, 3.873620552458734*^9, 3.873621456358457*^9, 
   3.8736536395043993`*^9, 3.873653697978847*^9, {3.8736537605376453`*^9, 
   3.873653786501913*^9}, 3.87365404387046*^9, 3.873654361803931*^9, {
   3.87372155376371*^9, 3.873721561299271*^9}, 3.873721650734617*^9, 
   3.8737219024108458`*^9, 3.873722043428874*^9, 3.873722123634899*^9, 
   3.873736476832642*^9},
 CellLabel->
  "During evaluation of \
In[57]:=",ExpressionUUID->"d98c395c-ca79-4102-a631-c075204cb05a"],

Cell[BoxData["8650"], "Print",
 CellChangeTimes->{
  3.873460359121327*^9, 3.873472184817514*^9, 3.873514600528822*^9, {
   3.873619706528304*^9, 3.873619723121772*^9}, 3.87361979983558*^9, 
   3.873619938604599*^9, 3.873620552458734*^9, 3.873621456358457*^9, 
   3.8736536395043993`*^9, 3.873653697978847*^9, {3.8736537605376453`*^9, 
   3.873653786501913*^9}, 3.87365404387046*^9, 3.873654361803931*^9, {
   3.87372155376371*^9, 3.873721561299271*^9}, 3.873721650734617*^9, 
   3.8737219024108458`*^9, 3.873722043428874*^9, 3.873722123634899*^9, 
   3.873736554329163*^9},
 CellLabel->
  "During evaluation of \
In[57]:=",ExpressionUUID->"73bd28a8-1bd5-4eef-bfd7-64cb23cd35a2"],

Cell[BoxData["8700"], "Print",
 CellChangeTimes->{
  3.873460359121327*^9, 3.873472184817514*^9, 3.873514600528822*^9, {
   3.873619706528304*^9, 3.873619723121772*^9}, 3.87361979983558*^9, 
   3.873619938604599*^9, 3.873620552458734*^9, 3.873621456358457*^9, 
   3.8736536395043993`*^9, 3.873653697978847*^9, {3.8736537605376453`*^9, 
   3.873653786501913*^9}, 3.87365404387046*^9, 3.873654361803931*^9, {
   3.87372155376371*^9, 3.873721561299271*^9}, 3.873721650734617*^9, 
   3.8737219024108458`*^9, 3.873722043428874*^9, 3.873722123634899*^9, 
   3.873736633940855*^9},
 CellLabel->
  "During evaluation of \
In[57]:=",ExpressionUUID->"13b12b3a-76a4-42b8-a644-1b332a312b8d"],

Cell[BoxData["8750"], "Print",
 CellChangeTimes->{
  3.873460359121327*^9, 3.873472184817514*^9, 3.873514600528822*^9, {
   3.873619706528304*^9, 3.873619723121772*^9}, 3.87361979983558*^9, 
   3.873619938604599*^9, 3.873620552458734*^9, 3.873621456358457*^9, 
   3.8736536395043993`*^9, 3.873653697978847*^9, {3.8736537605376453`*^9, 
   3.873653786501913*^9}, 3.87365404387046*^9, 3.873654361803931*^9, {
   3.87372155376371*^9, 3.873721561299271*^9}, 3.873721650734617*^9, 
   3.8737219024108458`*^9, 3.873722043428874*^9, 3.873722123634899*^9, 
   3.873736712743197*^9},
 CellLabel->
  "During evaluation of \
In[57]:=",ExpressionUUID->"6c423ec5-15db-4e81-8a94-31978edd7c98"],

Cell[BoxData["8800"], "Print",
 CellChangeTimes->{
  3.873460359121327*^9, 3.873472184817514*^9, 3.873514600528822*^9, {
   3.873619706528304*^9, 3.873619723121772*^9}, 3.87361979983558*^9, 
   3.873619938604599*^9, 3.873620552458734*^9, 3.873621456358457*^9, 
   3.8736536395043993`*^9, 3.873653697978847*^9, {3.8736537605376453`*^9, 
   3.873653786501913*^9}, 3.87365404387046*^9, 3.873654361803931*^9, {
   3.87372155376371*^9, 3.873721561299271*^9}, 3.873721650734617*^9, 
   3.8737219024108458`*^9, 3.873722043428874*^9, 3.873722123634899*^9, 
   3.8737367909253483`*^9},
 CellLabel->
  "During evaluation of \
In[57]:=",ExpressionUUID->"b5a1bd65-869b-4f20-a05d-195eac02f075"],

Cell[BoxData["8850"], "Print",
 CellChangeTimes->{
  3.873460359121327*^9, 3.873472184817514*^9, 3.873514600528822*^9, {
   3.873619706528304*^9, 3.873619723121772*^9}, 3.87361979983558*^9, 
   3.873619938604599*^9, 3.873620552458734*^9, 3.873621456358457*^9, 
   3.8736536395043993`*^9, 3.873653697978847*^9, {3.8736537605376453`*^9, 
   3.873653786501913*^9}, 3.87365404387046*^9, 3.873654361803931*^9, {
   3.87372155376371*^9, 3.873721561299271*^9}, 3.873721650734617*^9, 
   3.8737219024108458`*^9, 3.873722043428874*^9, 3.873722123634899*^9, 
   3.873736869523877*^9},
 CellLabel->
  "During evaluation of \
In[57]:=",ExpressionUUID->"9f07ee7c-9f04-452d-98ff-e766f332653e"],

Cell[BoxData["8900"], "Print",
 CellChangeTimes->{
  3.873460359121327*^9, 3.873472184817514*^9, 3.873514600528822*^9, {
   3.873619706528304*^9, 3.873619723121772*^9}, 3.87361979983558*^9, 
   3.873619938604599*^9, 3.873620552458734*^9, 3.873621456358457*^9, 
   3.8736536395043993`*^9, 3.873653697978847*^9, {3.8736537605376453`*^9, 
   3.873653786501913*^9}, 3.87365404387046*^9, 3.873654361803931*^9, {
   3.87372155376371*^9, 3.873721561299271*^9}, 3.873721650734617*^9, 
   3.8737219024108458`*^9, 3.873722043428874*^9, 3.873722123634899*^9, 
   3.8737369484517736`*^9},
 CellLabel->
  "During evaluation of \
In[57]:=",ExpressionUUID->"ec30ad86-c39d-4f3f-9441-22617cf2a7a2"],

Cell[BoxData["8950"], "Print",
 CellChangeTimes->{
  3.873460359121327*^9, 3.873472184817514*^9, 3.873514600528822*^9, {
   3.873619706528304*^9, 3.873619723121772*^9}, 3.87361979983558*^9, 
   3.873619938604599*^9, 3.873620552458734*^9, 3.873621456358457*^9, 
   3.8736536395043993`*^9, 3.873653697978847*^9, {3.8736537605376453`*^9, 
   3.873653786501913*^9}, 3.87365404387046*^9, 3.873654361803931*^9, {
   3.87372155376371*^9, 3.873721561299271*^9}, 3.873721650734617*^9, 
   3.8737219024108458`*^9, 3.873722043428874*^9, 3.873722123634899*^9, 
   3.8737370267717943`*^9},
 CellLabel->
  "During evaluation of \
In[57]:=",ExpressionUUID->"095b2641-e636-4e34-8dd4-f0addee76171"],

Cell[BoxData["9000"], "Print",
 CellChangeTimes->{
  3.873460359121327*^9, 3.873472184817514*^9, 3.873514600528822*^9, {
   3.873619706528304*^9, 3.873619723121772*^9}, 3.87361979983558*^9, 
   3.873619938604599*^9, 3.873620552458734*^9, 3.873621456358457*^9, 
   3.8736536395043993`*^9, 3.873653697978847*^9, {3.8736537605376453`*^9, 
   3.873653786501913*^9}, 3.87365404387046*^9, 3.873654361803931*^9, {
   3.87372155376371*^9, 3.873721561299271*^9}, 3.873721650734617*^9, 
   3.8737219024108458`*^9, 3.873722043428874*^9, 3.873722123634899*^9, 
   3.873737105744319*^9},
 CellLabel->
  "During evaluation of \
In[57]:=",ExpressionUUID->"93fca4b9-fbfe-4945-be7b-41696befad92"],

Cell[BoxData["9050"], "Print",
 CellChangeTimes->{
  3.873460359121327*^9, 3.873472184817514*^9, 3.873514600528822*^9, {
   3.873619706528304*^9, 3.873619723121772*^9}, 3.87361979983558*^9, 
   3.873619938604599*^9, 3.873620552458734*^9, 3.873621456358457*^9, 
   3.8736536395043993`*^9, 3.873653697978847*^9, {3.8736537605376453`*^9, 
   3.873653786501913*^9}, 3.87365404387046*^9, 3.873654361803931*^9, {
   3.87372155376371*^9, 3.873721561299271*^9}, 3.873721650734617*^9, 
   3.8737219024108458`*^9, 3.873722043428874*^9, 3.873722123634899*^9, 
   3.8737371842569027`*^9},
 CellLabel->
  "During evaluation of \
In[57]:=",ExpressionUUID->"69f340ee-2768-4925-b225-36b2f2539c91"],

Cell[BoxData["9100"], "Print",
 CellChangeTimes->{
  3.873460359121327*^9, 3.873472184817514*^9, 3.873514600528822*^9, {
   3.873619706528304*^9, 3.873619723121772*^9}, 3.87361979983558*^9, 
   3.873619938604599*^9, 3.873620552458734*^9, 3.873621456358457*^9, 
   3.8736536395043993`*^9, 3.873653697978847*^9, {3.8736537605376453`*^9, 
   3.873653786501913*^9}, 3.87365404387046*^9, 3.873654361803931*^9, {
   3.87372155376371*^9, 3.873721561299271*^9}, 3.873721650734617*^9, 
   3.8737219024108458`*^9, 3.873722043428874*^9, 3.873722123634899*^9, 
   3.8737372635728292`*^9},
 CellLabel->
  "During evaluation of \
In[57]:=",ExpressionUUID->"99fd3319-353c-4067-936c-ec9b07f5c659"],

Cell[BoxData["9150"], "Print",
 CellChangeTimes->{
  3.873460359121327*^9, 3.873472184817514*^9, 3.873514600528822*^9, {
   3.873619706528304*^9, 3.873619723121772*^9}, 3.87361979983558*^9, 
   3.873619938604599*^9, 3.873620552458734*^9, 3.873621456358457*^9, 
   3.8736536395043993`*^9, 3.873653697978847*^9, {3.8736537605376453`*^9, 
   3.873653786501913*^9}, 3.87365404387046*^9, 3.873654361803931*^9, {
   3.87372155376371*^9, 3.873721561299271*^9}, 3.873721650734617*^9, 
   3.8737219024108458`*^9, 3.873722043428874*^9, 3.873722123634899*^9, 
   3.873737341951915*^9},
 CellLabel->
  "During evaluation of \
In[57]:=",ExpressionUUID->"dbc7e31c-060a-4e8b-ac3f-b0de289c67fe"],

Cell[BoxData["9200"], "Print",
 CellChangeTimes->{
  3.873460359121327*^9, 3.873472184817514*^9, 3.873514600528822*^9, {
   3.873619706528304*^9, 3.873619723121772*^9}, 3.87361979983558*^9, 
   3.873619938604599*^9, 3.873620552458734*^9, 3.873621456358457*^9, 
   3.8736536395043993`*^9, 3.873653697978847*^9, {3.8736537605376453`*^9, 
   3.873653786501913*^9}, 3.87365404387046*^9, 3.873654361803931*^9, {
   3.87372155376371*^9, 3.873721561299271*^9}, 3.873721650734617*^9, 
   3.8737219024108458`*^9, 3.873722043428874*^9, 3.873722123634899*^9, 
   3.8737374201414223`*^9},
 CellLabel->
  "During evaluation of \
In[57]:=",ExpressionUUID->"a679ce6b-8c53-4b31-a98c-df1799e45e42"],

Cell[BoxData["9250"], "Print",
 CellChangeTimes->{
  3.873460359121327*^9, 3.873472184817514*^9, 3.873514600528822*^9, {
   3.873619706528304*^9, 3.873619723121772*^9}, 3.87361979983558*^9, 
   3.873619938604599*^9, 3.873620552458734*^9, 3.873621456358457*^9, 
   3.8736536395043993`*^9, 3.873653697978847*^9, {3.8736537605376453`*^9, 
   3.873653786501913*^9}, 3.87365404387046*^9, 3.873654361803931*^9, {
   3.87372155376371*^9, 3.873721561299271*^9}, 3.873721650734617*^9, 
   3.8737219024108458`*^9, 3.873722043428874*^9, 3.873722123634899*^9, 
   3.873737498499498*^9},
 CellLabel->
  "During evaluation of \
In[57]:=",ExpressionUUID->"1d198430-0892-49a3-80d9-5ca6e93c7433"],

Cell[BoxData["9300"], "Print",
 CellChangeTimes->{
  3.873460359121327*^9, 3.873472184817514*^9, 3.873514600528822*^9, {
   3.873619706528304*^9, 3.873619723121772*^9}, 3.87361979983558*^9, 
   3.873619938604599*^9, 3.873620552458734*^9, 3.873621456358457*^9, 
   3.8736536395043993`*^9, 3.873653697978847*^9, {3.8736537605376453`*^9, 
   3.873653786501913*^9}, 3.87365404387046*^9, 3.873654361803931*^9, {
   3.87372155376371*^9, 3.873721561299271*^9}, 3.873721650734617*^9, 
   3.8737219024108458`*^9, 3.873722043428874*^9, 3.873722123634899*^9, 
   3.8737375774774513`*^9},
 CellLabel->
  "During evaluation of \
In[57]:=",ExpressionUUID->"f148e867-7b7d-4408-998a-e02f1ac79f77"],

Cell[BoxData["9350"], "Print",
 CellChangeTimes->{
  3.873460359121327*^9, 3.873472184817514*^9, 3.873514600528822*^9, {
   3.873619706528304*^9, 3.873619723121772*^9}, 3.87361979983558*^9, 
   3.873619938604599*^9, 3.873620552458734*^9, 3.873621456358457*^9, 
   3.8736536395043993`*^9, 3.873653697978847*^9, {3.8736537605376453`*^9, 
   3.873653786501913*^9}, 3.87365404387046*^9, 3.873654361803931*^9, {
   3.87372155376371*^9, 3.873721561299271*^9}, 3.873721650734617*^9, 
   3.8737219024108458`*^9, 3.873722043428874*^9, 3.873722123634899*^9, 
   3.873737655538106*^9},
 CellLabel->
  "During evaluation of \
In[57]:=",ExpressionUUID->"145d978d-2bea-405f-b437-1a3d5e81b6af"],

Cell[BoxData["9400"], "Print",
 CellChangeTimes->{
  3.873460359121327*^9, 3.873472184817514*^9, 3.873514600528822*^9, {
   3.873619706528304*^9, 3.873619723121772*^9}, 3.87361979983558*^9, 
   3.873619938604599*^9, 3.873620552458734*^9, 3.873621456358457*^9, 
   3.8736536395043993`*^9, 3.873653697978847*^9, {3.8736537605376453`*^9, 
   3.873653786501913*^9}, 3.87365404387046*^9, 3.873654361803931*^9, {
   3.87372155376371*^9, 3.873721561299271*^9}, 3.873721650734617*^9, 
   3.8737219024108458`*^9, 3.873722043428874*^9, 3.873722123634899*^9, 
   3.8737377336164827`*^9},
 CellLabel->
  "During evaluation of \
In[57]:=",ExpressionUUID->"b278eddb-c56d-421e-84e8-858111575859"],

Cell[BoxData["9450"], "Print",
 CellChangeTimes->{
  3.873460359121327*^9, 3.873472184817514*^9, 3.873514600528822*^9, {
   3.873619706528304*^9, 3.873619723121772*^9}, 3.87361979983558*^9, 
   3.873619938604599*^9, 3.873620552458734*^9, 3.873621456358457*^9, 
   3.8736536395043993`*^9, 3.873653697978847*^9, {3.8736537605376453`*^9, 
   3.873653786501913*^9}, 3.87365404387046*^9, 3.873654361803931*^9, {
   3.87372155376371*^9, 3.873721561299271*^9}, 3.873721650734617*^9, 
   3.8737219024108458`*^9, 3.873722043428874*^9, 3.873722123634899*^9, 
   3.873737810737227*^9},
 CellLabel->
  "During evaluation of \
In[57]:=",ExpressionUUID->"2d252bb4-5673-4d5b-bb4c-3e9d4f790dd7"],

Cell[BoxData["9500"], "Print",
 CellChangeTimes->{
  3.873460359121327*^9, 3.873472184817514*^9, 3.873514600528822*^9, {
   3.873619706528304*^9, 3.873619723121772*^9}, 3.87361979983558*^9, 
   3.873619938604599*^9, 3.873620552458734*^9, 3.873621456358457*^9, 
   3.8736536395043993`*^9, 3.873653697978847*^9, {3.8736537605376453`*^9, 
   3.873653786501913*^9}, 3.87365404387046*^9, 3.873654361803931*^9, {
   3.87372155376371*^9, 3.873721561299271*^9}, 3.873721650734617*^9, 
   3.8737219024108458`*^9, 3.873722043428874*^9, 3.873722123634899*^9, 
   3.87373788842736*^9},
 CellLabel->
  "During evaluation of \
In[57]:=",ExpressionUUID->"4b9f9d5c-ea80-4ddd-a7da-88e369f55532"],

Cell[BoxData["9550"], "Print",
 CellChangeTimes->{
  3.873460359121327*^9, 3.873472184817514*^9, 3.873514600528822*^9, {
   3.873619706528304*^9, 3.873619723121772*^9}, 3.87361979983558*^9, 
   3.873619938604599*^9, 3.873620552458734*^9, 3.873621456358457*^9, 
   3.8736536395043993`*^9, 3.873653697978847*^9, {3.8736537605376453`*^9, 
   3.873653786501913*^9}, 3.87365404387046*^9, 3.873654361803931*^9, {
   3.87372155376371*^9, 3.873721561299271*^9}, 3.873721650734617*^9, 
   3.8737219024108458`*^9, 3.873722043428874*^9, 3.873722123634899*^9, 
   3.873737966691188*^9},
 CellLabel->
  "During evaluation of \
In[57]:=",ExpressionUUID->"528571ff-34fe-41d9-8929-c42acd0707e9"],

Cell[BoxData["9600"], "Print",
 CellChangeTimes->{
  3.873460359121327*^9, 3.873472184817514*^9, 3.873514600528822*^9, {
   3.873619706528304*^9, 3.873619723121772*^9}, 3.87361979983558*^9, 
   3.873619938604599*^9, 3.873620552458734*^9, 3.873621456358457*^9, 
   3.8736536395043993`*^9, 3.873653697978847*^9, {3.8736537605376453`*^9, 
   3.873653786501913*^9}, 3.87365404387046*^9, 3.873654361803931*^9, {
   3.87372155376371*^9, 3.873721561299271*^9}, 3.873721650734617*^9, 
   3.8737219024108458`*^9, 3.873722043428874*^9, 3.873722123634899*^9, 
   3.873738044891809*^9},
 CellLabel->
  "During evaluation of \
In[57]:=",ExpressionUUID->"86b21564-1e51-49e9-916e-51665952d1a5"],

Cell[BoxData["9650"], "Print",
 CellChangeTimes->{
  3.873460359121327*^9, 3.873472184817514*^9, 3.873514600528822*^9, {
   3.873619706528304*^9, 3.873619723121772*^9}, 3.87361979983558*^9, 
   3.873619938604599*^9, 3.873620552458734*^9, 3.873621456358457*^9, 
   3.8736536395043993`*^9, 3.873653697978847*^9, {3.8736537605376453`*^9, 
   3.873653786501913*^9}, 3.87365404387046*^9, 3.873654361803931*^9, {
   3.87372155376371*^9, 3.873721561299271*^9}, 3.873721650734617*^9, 
   3.8737219024108458`*^9, 3.873722043428874*^9, 3.873722123634899*^9, 
   3.8737381236866503`*^9},
 CellLabel->
  "During evaluation of \
In[57]:=",ExpressionUUID->"f74f857a-6a62-423f-b0f8-3f6c2402028b"],

Cell[BoxData["9700"], "Print",
 CellChangeTimes->{
  3.873460359121327*^9, 3.873472184817514*^9, 3.873514600528822*^9, {
   3.873619706528304*^9, 3.873619723121772*^9}, 3.87361979983558*^9, 
   3.873619938604599*^9, 3.873620552458734*^9, 3.873621456358457*^9, 
   3.8736536395043993`*^9, 3.873653697978847*^9, {3.8736537605376453`*^9, 
   3.873653786501913*^9}, 3.87365404387046*^9, 3.873654361803931*^9, {
   3.87372155376371*^9, 3.873721561299271*^9}, 3.873721650734617*^9, 
   3.8737219024108458`*^9, 3.873722043428874*^9, 3.873722123634899*^9, 
   3.8737382009108887`*^9},
 CellLabel->
  "During evaluation of \
In[57]:=",ExpressionUUID->"e5d40135-f8b7-47a8-8819-1f5b716f84b2"],

Cell[BoxData["9750"], "Print",
 CellChangeTimes->{
  3.873460359121327*^9, 3.873472184817514*^9, 3.873514600528822*^9, {
   3.873619706528304*^9, 3.873619723121772*^9}, 3.87361979983558*^9, 
   3.873619938604599*^9, 3.873620552458734*^9, 3.873621456358457*^9, 
   3.8736536395043993`*^9, 3.873653697978847*^9, {3.8736537605376453`*^9, 
   3.873653786501913*^9}, 3.87365404387046*^9, 3.873654361803931*^9, {
   3.87372155376371*^9, 3.873721561299271*^9}, 3.873721650734617*^9, 
   3.8737219024108458`*^9, 3.873722043428874*^9, 3.873722123634899*^9, 
   3.873738278701921*^9},
 CellLabel->
  "During evaluation of \
In[57]:=",ExpressionUUID->"6cffac7f-a45d-4aca-b3a6-164bdccf247e"],

Cell[BoxData["9800"], "Print",
 CellChangeTimes->{
  3.873460359121327*^9, 3.873472184817514*^9, 3.873514600528822*^9, {
   3.873619706528304*^9, 3.873619723121772*^9}, 3.87361979983558*^9, 
   3.873619938604599*^9, 3.873620552458734*^9, 3.873621456358457*^9, 
   3.8736536395043993`*^9, 3.873653697978847*^9, {3.8736537605376453`*^9, 
   3.873653786501913*^9}, 3.87365404387046*^9, 3.873654361803931*^9, {
   3.87372155376371*^9, 3.873721561299271*^9}, 3.873721650734617*^9, 
   3.8737219024108458`*^9, 3.873722043428874*^9, 3.873722123634899*^9, 
   3.8737383562647133`*^9},
 CellLabel->
  "During evaluation of \
In[57]:=",ExpressionUUID->"2b36696a-0f6f-4df8-b239-cfe9e7a23b52"],

Cell[BoxData["9850"], "Print",
 CellChangeTimes->{
  3.873460359121327*^9, 3.873472184817514*^9, 3.873514600528822*^9, {
   3.873619706528304*^9, 3.873619723121772*^9}, 3.87361979983558*^9, 
   3.873619938604599*^9, 3.873620552458734*^9, 3.873621456358457*^9, 
   3.8736536395043993`*^9, 3.873653697978847*^9, {3.8736537605376453`*^9, 
   3.873653786501913*^9}, 3.87365404387046*^9, 3.873654361803931*^9, {
   3.87372155376371*^9, 3.873721561299271*^9}, 3.873721650734617*^9, 
   3.8737219024108458`*^9, 3.873722043428874*^9, 3.873722123634899*^9, 
   3.873738433727745*^9},
 CellLabel->
  "During evaluation of \
In[57]:=",ExpressionUUID->"adec84ba-aec6-4e22-9fa2-16f2b13bd4e6"],

Cell[BoxData["9900"], "Print",
 CellChangeTimes->{
  3.873460359121327*^9, 3.873472184817514*^9, 3.873514600528822*^9, {
   3.873619706528304*^9, 3.873619723121772*^9}, 3.87361979983558*^9, 
   3.873619938604599*^9, 3.873620552458734*^9, 3.873621456358457*^9, 
   3.8736536395043993`*^9, 3.873653697978847*^9, {3.8736537605376453`*^9, 
   3.873653786501913*^9}, 3.87365404387046*^9, 3.873654361803931*^9, {
   3.87372155376371*^9, 3.873721561299271*^9}, 3.873721650734617*^9, 
   3.8737219024108458`*^9, 3.873722043428874*^9, 3.873722123634899*^9, 
   3.873738512103215*^9},
 CellLabel->
  "During evaluation of \
In[57]:=",ExpressionUUID->"6b7e2243-8d05-4404-9cb9-d5a317d8291b"],

Cell[BoxData["9950"], "Print",
 CellChangeTimes->{
  3.873460359121327*^9, 3.873472184817514*^9, 3.873514600528822*^9, {
   3.873619706528304*^9, 3.873619723121772*^9}, 3.87361979983558*^9, 
   3.873619938604599*^9, 3.873620552458734*^9, 3.873621456358457*^9, 
   3.8736536395043993`*^9, 3.873653697978847*^9, {3.8736537605376453`*^9, 
   3.873653786501913*^9}, 3.87365404387046*^9, 3.873654361803931*^9, {
   3.87372155376371*^9, 3.873721561299271*^9}, 3.873721650734617*^9, 
   3.8737219024108458`*^9, 3.873722043428874*^9, 3.873722123634899*^9, 
   3.8737385899771843`*^9},
 CellLabel->
  "During evaluation of \
In[57]:=",ExpressionUUID->"4036d42d-a2dc-4318-bd4f-b87b0a82cecc"],

Cell[BoxData["10000"], "Print",
 CellChangeTimes->{
  3.873460359121327*^9, 3.873472184817514*^9, 3.873514600528822*^9, {
   3.873619706528304*^9, 3.873619723121772*^9}, 3.87361979983558*^9, 
   3.873619938604599*^9, 3.873620552458734*^9, 3.873621456358457*^9, 
   3.8736536395043993`*^9, 3.873653697978847*^9, {3.8736537605376453`*^9, 
   3.873653786501913*^9}, 3.87365404387046*^9, 3.873654361803931*^9, {
   3.87372155376371*^9, 3.873721561299271*^9}, 3.873721650734617*^9, 
   3.8737219024108458`*^9, 3.873722043428874*^9, 3.873722123634899*^9, 
   3.873738668639233*^9},
 CellLabel->
  "During evaluation of \
In[57]:=",ExpressionUUID->"3b51f9fe-7e71-4708-b262-d6724358684d"]
}, Open  ]],

Cell[BoxData[
 GraphicsBox[{{}, {{
     {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
       NCache[
        Rational[1, 360], 0.002777777777777778]], AbsoluteThickness[1.6], 
      PointBox[CompressedData["
1:eJxti3lQFGQYh1FR7iDiTAK5hLhddrmX/YHcy7EsCyxSGQQ4psYqpLUeQDAG
FOsspIEziheMDPclhRvSLEckZ4RN4NRyjIiSIiQxBJTNvn/2zbzzzfM+72OZ
mslP366iopL+av77//8tcRZfM8scalv1ogXGpd1ZcqdTPkpUB9dQR7xqF+ar
ZD2Y2lqr5k5MEBtAXDDfF+gBPyWboKe4RTE9ISU2g3Rh6/e8x+PEe3DlGwWL
z9RiK9kK4pYaz7RGb2Ib5CRrWj9lpBLvRVFbm0fh+QJie7xrxXV0Zt8kdkD+
9JkQ47UuYifoZ4jOOaxMELsg8fZk+sbyU2I3CG/ImrzYKv5K3odjV5PHm4+/
TszAjujNs5F5lsTu0GV6zreUuBEz0aXaFT3YwSZmocI5e9RDHE7sgcHeZZn3
moDYE6P9xn6zt94n9sJhYeOZ0bLDxN4YO/fseq5RFrEPRu1HVljdp4l9oba7
nf+kJZ/YDzaFdzZb3/uCmI1ZDcVR7apSYn/kffxL2pcr5cQcFDsl3L999Box
4KBumb8VWaXkXEA+P9zwt38t+QAofHbM5TCbyQegp3b4QO2n7eQDoXggf7Se
30k+EIvhRpISZjf5/Xi8TUNys1JOfj8C6vk1pZJ+8kEYtdMV/aQ9SD4I7cUi
9b9KR8kHw/uyg0vniXHywZgyuBifXfuAfAgqndRSJgMnyYcgo61wpsT/N/Kh
iBxJl2rxp8mHot7+3lSmbJZ8GK4zzX42SnlEPgzT8rwLFwIXyIdjg7ceE/fB
IvlwjMh9p+W9z8lHoOFsvanhnRfkI8D+81D5gboV8lysBUkyZH0vyXMhVW28
5bFrjXwkBItL8R1H1slHYj6m3918bYN8FMSNA1/71f1DPgrj2lOyD4O2cZQ+
GlpFXfei+7crOTcaJxhSyVsHVcnHoPqSTYq19i7yMbjGbSuqGlYjz4Ouj+jS
TLWGksHD+ZOMU/oXteieh3KerDqjQkfJ3Tw8jHmZoNmmS30sfCUzMdJlPepj
kcc0Fx4y0qc+FqzWBZWvgt+gPhZLT+QhlrkG1PMReoKbZ9RnSD0fOj9653xi
bEw9H251390Izzahng/BtwubRQ9NqY8DI2nhI0/eburjkBPbejdqxIz6OAww
tur6ksypj4PrWIT95ecW1Asgasi2OfjDHuoF8LddvVt21ZJ6wau+ICBNbEW9
AL+2spIGkq2pj0dN49CzzkAb6uNhMSbjuLnaUh+P6treOQvLvdTHo9k2cSrH
xI76BJwubZIEG9pTn4ClHoUi3fht6hPAqaxznzB3oD4BJ++nHv/c0ZH6RNTN
VRiK2E7UJyK5ZIj1mcCZ+kRoevYXNYlcqE/EziOdWX9IXakXQjy7mW/4jhv1
QjRZWRTXvyDOFULvim1ZR9E+6oXoinoz3MmGQX0Sjm3t9FP9nsH5F9iPvVA=

       "]]}, 
     {RGBColor[0.880722, 0.611041, 0.142051], PointSize[
       NCache[
        Rational[1, 360], 0.002777777777777778]], AbsoluteThickness[1.6], 
      PointBox[CompressedData["
1:eJxty39Q03Ucx/Exf0FoighMAhlgxg/FOZSNIfByUxQYsI2NTTwEEWamNcXj
x6WngJBpjR9aJiXc2AVYchg/c1cIJUKKC1BUDuYvElBBpZBFqZTd3n/2vfvc
9x6f5+flnqyRpTIZDEbq6/Pf//+/8dCc3Gtyq0JJIF3gxP1TVsLkCwILrTEQ
z3wrg5MfZPECtMInwunx3LUWL0KA07ixQ7yXzEKc68qiuqkWsgt2H7gvcu6f
JrMRcHnqxY1SbrDFHlgyMLljuDCRvBTi6pFXD5R55GX4Vv9n2Y+sCrIXcrkC
j9Wqn8k+GPuFXdZWMkBejhWO9sYp9R9kPxy20+TN95kdYjEHoQnPh29/yCKv
QnbEF0r5Ym8yFym5mSM27nyyP/aMc9zef7qBvBon2nnXeX/LyGsQU9RRzd6X
SA7Avqz9Lc/td5J5UE/odobH7iPz0f5IUZf92wFyIG5ovx7wY+aTBZDf6dpa
2KUlB0FVxOp2OPcZeS1yD9psu8Q+TQ5Gcylb/aRdTw6BaFnn7XlVZ8ihkCS5
DxruniMDkW1hdyXSBouzAZ5qM+NhsYH6OuRt/ctTf7WF+jp4lUSP6wsuUhei
jKXe6djdQV0I+XGNxtpwlboIYTVPe8y+PdRFuGi1v7A0oZf6enB0DcozU7eo
r8c/zZoE7kwT9Q2IHAnNOC26R30DLrzM1oa3DVIPg2Hb5Mr0I0PUw+Aa8WpW
fNFD6hvR3M/vchgcpb4Rx7cPTFYeekZ9EzzPZgonG3+nvgmp0ZnBxt4J6uEo
+NI2sNLVTD0cszO54vPFU9QjsMPwMMuL+4J6BOZo3thjzZimHonrgj6B70FG
qKVHQviNqXbanmkxQ4wQ5vT2xz/NoC7G2cZareTjWdSjEHUpfc6xHXOoR6HZ
rEsfTrShHo07naZD1XttqUfD1rHpTefSedRjkFp+T5syOJ96DIxJM0tMbDvq
Eix0qNSVJSy0GBI4rbvhd6TKnt6/7uaMd8unF1ncKkGCi2nsebIj7aV479e2
l/m9TrSX4qv4vnJF7GLaS2E3evTmtrvOtJeiJExaU5HlQnsZFElWBxe7LaG9
DMwHQzPqr7nRXoam8dMddZfZtJfhqFpoX/ydO+1j4Vu99uZoqQftY9Fd9lGO
odiT9rGozpGcfPbJUtrHImvi88bcT9+mvRxbTv1Qoz6xjPZy1AYLtQW6d2gv
x1i/vmKs3ov2ctRJd5WnGb1pr8CZtPPH7J740F6BUQ+/W4aFy2mvgO9EUdqW
kBW0V+BRkOflIY0f7eMw5TPYs7FqJe3jwL8SP5efxqF9HFgicUql/SraxyHp
WV//0PdkhhIfnNT7P9nKpb0Sx1rPLqi39qe9Et4xT80rGsmtSlgP6GTylNW0
V8E/3Xm/i+Ma2qvgnhLVdOAKOVuFtN2moF05AbRXocGtj3dHwKP9ZhRy+MZO
My/0X9+tvhY=
       "]]}, 
     {RGBColor[0.560181, 0.691569, 0.194885], PointSize[
       NCache[
        Rational[1, 360], 0.002777777777777778]], AbsoluteThickness[1.6], 
      PointBox[CompressedData["
1:eJxty3lQ1GUcx/FtCYZTRIwAcThcIFC5kWuBD+vCcssesCtxiQdoEEFxiAEC
IhaYGkdy1UBAGdQM4c4yKoQEGYfEAs0oYa4mIJQOokSCYDb7/bPfzDO/eT3v
52OemCY4zGQwGIdfnf/+//8t+l6Q92sfr2j1oAuYJfGGg0xVvJRUB++DfP+A
6evkzVC0u563Teawld6K2vMx7pp9jWRD1BR33M+r/JNsgiPfzPeNqlp7K22G
iawzRmqfSMgW6FeZj23tLCKzIG5s4Xy71EK2ArPSKnv8ST/5LXBqv5oafKgg
26Jv26O6iyMr5F0wzilU61bo+ChtBy27+2kX1c3JDtj0Um7vP+NIdsRCdWf6
4Gk/shPuvpdqWmQdQXbGzeaE7+AbQ3bBckFk4ruVSWRXLK885c3NZJD3oLBB
K8fAPY/shhQb+0gHRQnZHex7tRvDk+fIHig9UKce/Wk12RO74x2Ku3hfkL0w
VXbchunZQmbD+Wph5i1uO9kbb77QWBg6+T3ZB8v5x6bSb8nIvljS5FtahvSQ
AVGUxu2Z9T6lTwJOE6M6eqU3qPshoYib4jYxQt0Px47WB4XnyqlzEKZhs9a7
MUmdg+tZwjgVxm3qexF4uXSnaukd6nvRdqM1jxt+jzoX0lUPdjnrAXUuOOmO
KnnBc9T98RpTf16/f4G6P9aZKmasqsfUA2BUM/fwUsIT6gH4LNdlWLv1KXUe
mpK57FiTv6nz8Oxamzdr4B/qgdj4cm1wrHGNeiASXeNLZJ0b1IMg2ZIarrHB
8FX2IMwwXswxephKM4JhHjMQ4V/7OvVgWK+7RYVWqFEPQe90vXbBJXXqIVj5
uN7Q844m9VAIDPNVR+10qIfieeNiS8HnutTD0CAu8uEa6FEPQ3NcTnVZyhbq
4bDPlj6zHtenHo600j8yrXhvUN+HK5E/vn9u2ID6PjQM+/xwJN6QegRGy5lT
bUxjpRGB2YkT9tHSbfQ+AiJN57Cj2duV7o2AXnS18c1AU9rzkeW8W/1qpRnt
+dB6NCj7utyc9nzEnOBeY5Vb0J4Phm3+mEXFDtoLMJ8gO1TVyKK9AL8fFHWl
yixpL0CPyztLdZNWtBcgpEDurvvcmvZCzA0XDEhZNrQXwlPou/qh2Jb2QsRX
dWTwL+ykvRCcUflW0/FdtBfBo9zITG5kR3sRFLmZXoJke9qL8NsVE7+f4hxo
L0KA546fL2s70j4SgWsjAfPdZEQieLDXRJLhRPtXXT6Zu2zjTPtI6G6qSZY+
IDOioPdycbCsyYX2Ueh4u/tQykFX2kdBa+Kj2WDrPbSPwvRZqwXjx2SGGCHO
Wuu/yNxoL0aGbUxz7Cl32ouxYZp6QCb0oL0Yd8+2SscsPWkvQefKgGXDKhkS
eDSVsDePe9FeArXZofLt7WzaSzBUfKqz64w37ffjL0Xi/l+TfHz/BYostEk=

       "]]}, 
     {RGBColor[0.922526, 0.385626, 0.209179], PointSize[
       NCache[
        Rational[1, 360], 0.002777777777777778]], AbsoluteThickness[1.6], 
      PointBox[CompressedData["
1:eJxty3801Xccx/GbHTU/j9+/K65fES6X6zf3xfUzXNd1uX7EIj+aY8sIrTXk
V07ToSPLicoNqU0nJuocW9OEYqnrxEisJaaTxZix5Wjbue8/9z3nc77n8Xl+
XibJh4WpcgwGI/Xf89///79l7nja3w3nljbd6AIBrcVsd41ADxnfh9BqaubZ
i02yGjp2ra+aFOZ5yqyFL4cPjWwrlpL18MEJ6WD7tI6XzEboFarWvy4TkI1R
ymb7ytsUkpk4X5uz6hvbQjbD0Ia0VPfJANkCzdqJF/LUXpL3oEA7Z4ltuEW2
huWa3oGgcU1vmW1wwjHOtTbfkmyHxd18SWacG9ke8WMl6avxwWQH+C02NFXe
EZPZeHY2+0NVRirZEcNKG3cetX1CdsKTgn6lzz4/Tuagyz6py9CgnOyMDocV
XWlNNdkFSryEFD1mHdkVnE8jTPkGErIbmmaPxnV81Up2R8JZyfcN29vJHqgx
SXbWDO4ie+KCyVCpymAP2Qt2R/K0+ON3yd6YKu3WOF0zQObCwOn2T/vZP5KB
B175LPlUqcxFQE7Lu4Vl1zHqPoh/zXxa0DhJ3QdXg7f7qbTOUPdF0Vza6NTe
F9R98dhr4tblxDnqPNjMuder/L5AnYfJUW9t3YVF6n5QTS874t28TN0P6nY3
VhKUVqn7I0NxPr786zXq/thfUz3SXr5BPQCX6ioyv7n4lnoAnB/oLXmsbVEP
hLLp3b5F/21cWQ+EgvRY0V8O78nMCEKLKlMljStPPQim/UMnf/h4B/VgZB4T
t57uVaAeDK0RBSsOR5n6PnSu/xmu81CV+j48X+O7c++pUQ+BipWDdMxRg3oI
Hg/vbEzr0qQeCuNb/QfkgrWph4I3Mmvb+UaHehhyTe/PHL+iRz0MOwbVkxOy
DKjz0cbJ1QkLNaLOx1bUojHXfRf1cLytUH6uttOYejhe3c/mL5mbUBeg/aOA
yusuTJkhwKV0i1BPoSm9F8B8oyr9VK6ZzL0CzCZuypVJzGkfgZCeox264xa0
j0C5+aNzNpp7aB+Bpnz9qrYYK9pHIPVaREDhFWvaC1GRGZD8xeZe2gtRrBlb
3x1nS3shHvbUTMz12tFeiKT5P5oKdO1pH4lh3pRb1igZkejDtLXbGQfaR6LE
db1zKJJN+0jkivomtQ0caS+Cpzr3sNJLMkSoPr9p2NDhRHsRnGJ/TbpdzKG9
CJWsgcsCsTPtozD69Kp5FMuF9lHg/JJh1K3oSvso3BzPuHbwFbk3Cha/Fc+F
DbvRPhorIo/5lHZ32kdD/p3+vbo6D9pHw6rq58bJEk/aR6NUIfu6brYX7cXg
JrJYvIPetBfjW8mh0lAxl/Zi3Ax9o6lhCdqL8d2Z2tjpJjIjBmkShywG04f2
MbjRlt+fIyEXxSD8ov4Ei+lL+xgommm72jaTGbEwEO0+mWLJ4/4DvperFA==

       "]]}, 
     {RGBColor[0.528488, 0.470624, 0.701351], PointSize[
       NCache[
        Rational[1, 360], 0.002777777777777778]], AbsoluteThickness[1.6], 
      PointBox[CompressedData["
1:eJxty3lQ1GUcx/HlcjkUiSVDROQIkivOZYEF9rNcC3IusMuPkWOWRIfkEGJU
JJEYhE0TZSRwgRIwCjAw1LyQI1Mw0AYEZgQCDBJKLSEFDIypZr9/9pt55jev
5/18zJIzo1JUWSxWyr/nv///f/OClIagl7fzxJ50AXtOtba8/hhfSU0cbj/P
sUpy81JaDwLBIZWEuGayAYYiR8fTTrC8lTaExMY63crJl2yMJI/W2tGe/WRT
qO56nFipfo5sDv1dVbLFrF7y26iy7beXTsySrTB1Ra17oljVR+nt6KysLRgb
30y2wb6hdvnKcweyHcwzmDn5oJD8LhaaFHF/C6PIjpgq/KbaZI+M7IQ7Lu79
ModMsjNuhnpkeBw+RHbBV+W7B73yjpJdcayzuaf6xikyF9s8w9ZrWyrIbhhp
4W+ciagn81BzxLxz83wT2R0jwmS+1tM2sgee5XwsH+VeI3viVPdUqJlmN5mP
ay1f6BuM3SZ74cL1yqm01j6yNw7mhAQqBgfIPkjNmJJ5PR0mC/DZeNtzrUuj
ZMBUv3C1iTeldAHwfmfKYtv309SF8B3O1lNlZqkLMfbL5d+Sk55Q98V0Y1GO
6aM/qPuipvH47Kb5Bep+cLULmjx58SV1P2QyW2UGN5ap+2NhddlTR2uVuj9U
Jmc2NNatUQ9ApQanbNFXRaDsAdA+GjIysFNNaVYgHtllc11qNKgHYiy4Wzqo
rkldhEkF96aoQpu6CNETKblbxBuoB8GNx3w4YaRHPQhrl9anCurfoB6MUOYh
M+LDoR6MT3tyra7OG1DfgXTBnPOLq5uo74DqK9Gz0nJD6iE44iRnSoqNqIcg
4YmsbvCEMfVQWDsVnd3ZbEI9FPG1PKd1GabUw3DXMysuucyMehj6En16HbrM
qYfjdZ9heNyyBfVw5A2ohPV6WFKPgNuB1OmkYivqEbDtLNnKnniHeiS2vFVi
f9bbWmlEwiF8rlSz0YbeRyLfrIJnbmyndHckKsT8Wz8o7GkvxlrmyplxUwfa
i5EQeP2kgnGkvRh5M9XpEksn2ovhVz8UWrpEZkVBuvj6ruM9Z9pH4S9OhtD6
SxfaR6Gk8eLj94pcaR8Fs7Ffu+7t5tI+GqfzmY6IMDfaR6N9uOHbhzwe7aMh
z3+1L9rKnfbR+C5e1nLe0IP2MWjtare4r+tJ+xioWQs+OafJp30MdLBab7TO
i/YxYO8psDNhe9NeAre9iysKHR/aS8DNu/MilyOgvQTamcvako2gvQQH2Htx
vILMkuLNzy90SLYJaS9F/NrBjuYmcoEUf/qslBdwfWkvRbNh/ZX7t8isWOT+
ZHpZLvajfSy2h50RNP5MLohF3YMlW4sP/GkfiwcpDWnzGgG0ZzDc/6MBu4oM
BvGi09JEh0DaM8jWzSr8/Q65m8FopS776wQR7ePwkfr+rLIlkeAfSf2u8A==

       "]]}, 
     {RGBColor[0.772079, 0.431554, 0.102387], PointSize[
       NCache[
        Rational[1, 360], 0.002777777777777778]], AbsoluteThickness[1.6], 
      PointBox[CompressedData["
1:eJxty38w1Hkcx/H1M875UYT82ENij3P5tfJ7X9ayfi4Wa9XkV+mEIpnazKm9
W53qLqe6CXOJOcc06TQnJRGbX23XqfaI011M5lyHGHTHyNHdzb7/vO/MZ77z
+Dw/L9uMPGGmOoPByPz3/Pf//2+eY7xRXzKyUOdLFxC+mGcN7x7wU1EHZm23
r+iV5/urbIRfx6XjR08+J5vAuvLiN5pLLgEqm+PWn00Bae05ZCvUn6vqtbG8
TLaBx7Hyus6QfrIdvhZM5tzs+INsDwvHqY0Sbe1AlR1wV7tsoVRiQ2bhuYLt
Lcpik53AT9MqPPYojPwB8uOn6qfsdpI/hJg1ytM6sJ/sio6vRJww5lGyG6KY
/BLnERnZHTZ2Yx0fe5STPZDRpb6WnFRF9oSk4umgqWkdmY0nL4aVLU8ayV7Q
uRaUv/f6DfIO7Ls22/GlQzvZG4ELhhErkd1kH4ytJZ+wZCnIvlCaHhm8J3hM
9kPPwketl14Pkv1xZ49PEf/dUXIAzINeWZZrjpMDIf7iZH/Z8gSZg/VQaeni
3O9kwMDauk3j0IzKUmCbnBc9y52nHoSWX0wFn1m8ph6EByVeqT9xl6hz0ZtX
EWHYtUKdi6aaH3rdzq9RD8aAkHmiYJzBUfVgvLf06HjfVg2VGTxseduiZFZo
UefBXm3aOstXh3oIZOlmPVkGetRD4CdZ07tvbEA9FJLjYnlJvRH1UDycUjpE
7dxEnQ+pt8WuVJYJdT7GFqpChw1NqYfh24zln9uNzKmHoftz+QMDZwvq4ch5
I03pTrGiHg7RTAG7q5FJPQIytSrdxVM21CPQqM0XyxS21CPBfVXNLTLZSj0S
2Y/f6W/LtacehSuH5cdtlduoR+HTksPrZ4McqUdjpPq+5ehdFvVozHlW+z4L
caIugEdNcNm+UWfqAvT5KkVxEhfqMdB8edUi12479RjsKSg62JPjSj0WR1IV
rNuRbiojFu/L72xYdXWn97HYVeyQXmDpobI8Fu6n/nLR1POkfRwafBrsLr4l
Iw6Fc0P9+its2sdhs/mtM7HLXrSPQ2Nq3mjwmx20F2JiuslxQM2H9kK08mXr
Sn1f2gthFqWt4c30o70QuXubV39z96d9PCZF24c6IwNoH4/sBM/axqxA2sfD
5vv56nOnObSPx4VJ+0vOSaB9AtIUF0oOzZCRAN7TDXNnPwmifQIqdG+KC7dw
aZ+ATQ37081vkBmJsBCk9B4QBNM+Ee6eV9OyZsjSRMz6sf3/Ps2jfSJW7r0s
tXYKob0IFZo9dfKHZIhwJqbY7tnBUNqL0HLd58cUYz7tRag8r1Eb3EZmJOE7
t/HB4rQw2ifB+XLxoLpuOO2TIFqcClA0k+VJSBjpnOjZHUF7MQTTpV0zupG0
F6O2eWiN3UqWilHTisXKzCjai8HLzrfS2xxN+2Ssdo44yvqiOf8A3Eyxkw==

       "]]}, 
     {RGBColor[0.363898, 0.618501, 0.782349], PointSize[
       NCache[
        Rational[1, 360], 0.002777777777777778]], AbsoluteThickness[1.6], 
      PointBox[CompressedData["
1:eJxty39Q03Ucx/HvEYWKweBQXCABAvJDOcZvxsZewBjj9zbGBhekcFESEUZ5
IewETosE3YWASkDAAZESVIKpTGNCCEVHx48kfnoRERXyS/lh5FHd3n/2vfvc
9x6f5+dlk5IpS9VjGCb13/Pf//+/ZQF7MetHWe4aly5gumYw99mEEU/HHXhi
PqJyTG0is3B6VDnbWWrM19kMB5JaPj8zn0DeB1tbk94p7zKyJVhpC3P6u7vJ
1hA3yWYctufJtvj49v3q7F07A3S2w13jN7vsku3IDnCpmjZ86MQjO0J5o5gj
YUnJzgirOpreeyGFfAh2JXtLNXlZZFe0yZvdR14oILuhdGFcZN1+nszBy9fV
9sVvXSa7Y6mlq9bCq57sgYLBm5ZXmBayJ3qMTBtT7K+TvZDxwCDcav4O2Ru3
D88lrZR/Q/ZBXeWlRxXN/WRfzF4tU+d7DpH9UFnyd+czBaNkLtrZ+0enR6bI
/ghIV40db5gh86BY1/su8685Mh/63bwMzcaf5ABcmB5jnRxeJgtQmjIk2tzx
mAxcbFpdmand0DkfsNQ3PKGo2aIeCEtVYZiePiPQ9UDs7Dw1wc7U05kJQnJX
oPCo6bPUg1DuXcpnLRlQD0bL7yK1+3OG1IMRPXVrqybeiLoQgZ/oaQoesagL
4ZPT6Lv4kyn1EHxQy2nVTppRD8FAaJGJyfZe6iKk52rifhWwqYsQsKeozr3G
gnoo3NLP5k5bWlEPBafnzPqRRGvqYmRMsCWSWzbUxXiqct22sj9APQyLzqcc
G2vsqIdhv8Hlla8cHaiHI/IO19hOe5B6OJb70qNvpjpRj8DKF7N7eGwX6hFY
Ny6cemf8EPVIsJZLK+yvuFKPxLA+71xhkBv1KGT/ZuS86c2hHgWBtCexm+NO
PRodZmueve4e1KPxxvla/5/9PKnH4HDjqnpR5EU9Bs0G1572J3hTl6B2esFG
keWjMyR4nFWfm/ahL72XwERpem6mzU9nrQQODWkr1ZNc2kth/15JQfYuHu2l
OOvamxzD59NeiiOFi/uYEwG0l+KVkLcrj30poL0M/KC8Tz1OgvYyKE00RQ8t
AmkvQ3lUVeWglqyVYUBs1fHDa0G0j4WFU/HWKCuY9rHwa/O6Oq4h58diUKEW
9h0T0j4WTl/Xq0rMQ2gvx2SBre/BPjLk6GYbluTkiGgvh//q8VGVayjt5Wg1
V5W9OEtm4vCST7VaXimmfRzKPSsGnpeH0T4Oiqr5Br5ROO3jsDU31Hr/WzKj
wL32j8b734+gvQKY3P06KySS9grEXpxdvaQfRXsFhjvuJip6yIwScz4PJgWF
0bRXou4Gd1kcHkN7Jd5VNTh7GEhor0RTHvf0vTQyEw9+Ecdi7Hsy4tG57dKU
6ialfTz+KBFuvFpG1sZjZumXjdFNMpOA8YYn19qSZIJ/AFWstcI=
       "]]}, 
     {RGBColor[1, 0.75, 0], PointSize[
       NCache[
        Rational[1, 360], 0.002777777777777778]], AbsoluteThickness[1.6], 
      PointBox[CompressedData["
1:eJxt0mswXHccxvHVDjJBKqm4a5YkiC0hWHf77K7LYi27dpcmSqIhIjGttI2O
tC4ZJkRGEgnRDjHuklViBCVxqYaRlBUdIq1MMe1Q1zKkaKKazv5e9sycOfM5
3/O8+h/zmI8lsW8xGIzYN/d/z/+/ljm9led+zxvx9aAXqIha72SMijxV3IGz
qHks/GyCrIt0hfOlYn14qawHo98m0wcjs8iGyC61K51hPiSbolMrybBfc4bM
xKvznfXysZ3eKltAZ78r94bAmnwANTqJyQX6PLIlZi+pRQ4zw8nW0I5r7a0/
lEC2gdt9c3lbfwr5fYxLU12mOTlkO2yOjuVVuxSS7XHH5FRcXlI52QFXOnta
avZ/Sz6Cq62Jg7O7WsiOmPCq85w26CY7wem7Sf43HX1kZ6R1Pfeb8xois3Gm
qf/l8T9HyC6IvlZbpjg3TnYFU0ejhF81RXbD0kVN/YqgabI7fu6bV3Y8mCd7
4Mun7MAFtRWyJ2oPT6zmFq2RvdDqFnilpWaD7I0XQsbNXqctMgcHmdfqXS3U
OHS8yH+RrHd68W2V04HdSxsrjVsa1LlYbjSZyZLupM6FmW2B4p1VHeo8MBaM
Z40XdanzcLPqTFSI+rvU+cgdeCY/yttLnY+hwmMvpZUG1H2g+PHi594sY+o+
EAjucv55ZkrdF2UnXy/F1uyj7ouxxaLbRiJz6n4oK/96OvsXC+p+iF8zSFB+
cYC6P+I3r4fds7ak7o+2xwamS7NW1AVY3RMp4D48RF2AkrZVq6hSFvUApDW7
FKzl21IPQHHxYsO9wsPUA5HZL+4zG7WnHohSZc5cybQD9SBkm6axFNtHqAdB
qGXDMWA6URfigUNAZJO/M3UhrgqaToSeZ1MPhqFHzl+dChfqwehJWasemnGl
LoJIo21bYuNOXYS5Zsc7Rp96UA+BCbsyY+17T+ohOKWt3Xpf35t66Jv/bWSK
lcRRGaEo8R3SLYwHfR+KHqbpez4mXJW7Q7G5z+jXnKdkhhjqliFZ4mwe7cUI
r+ntyuLxaS/GxR2ZTbu3yd1iaJf8tDXZ4UN7CZrLXtVNpPrSXgIHZpfr31w/
2ktQGu1wwUzTn/YSxHU/ustWkhlhOHb5lszxloD2Ydhrv/6hWkwA7cPQeGF7
Pc8ukPZhsNd2r33ymsyQYsw+kV8xEER7KY672y5r3hbSXgrlVKPNH58E016K
QZeRJ46+ItrLINVL0Bo3DqG9DFtRs9eVK+R0GQaLKtq3T4bSXgZFbkZZwzCZ
IYfUspyx7C2mvRwDujf02+vI6XI01J09qmkiob0cVgXqycM5ZEY4PDY2fPZs
khEO84X8Rz/Eh9E+HG1VI4aTz8nd4SioTsk8ESClfQTYE/6nee1kRGAz5mDA
VywZ7SOQuh7Sr11C7o5ANGu6YX6XnPYfIEb9o2W9DDnnX6mAvJ4=
       "]]}, 
     {RGBColor[0.647624, 0.37816, 0.614037], PointSize[
       NCache[
        Rational[1, 360], 0.002777777777777778]], AbsoluteThickness[1.6], 
      PointBox[CompressedData["
1:eJxty3lM02ccx/HasNDQBRjHBDcHKofIKWcpRz/chQItvZFrg7ExUS53OB2I
bOFQUFM5nGIk2BkWJkJlWkClMygIU8OighLYOCqCOnGQTXSWbeH7537Jk19e
z/v5bMjMF2czGQxG9r/nv///fwu8K6YtRVGztUF0geWllkc3A2qCV8lChU1M
i9rSKmTV5jjN/m1ziks+2QovHnAz3a62k23w9w9rNgnVU+R3UbL/mn7bYZPQ
VdvjUvlYmmeFK3kjrksGngnKo8kOYM00Hlv8KZ3shLfHz698wCkibwYnQ+h8
M/Jr8hYwspx4kloV2Q2Pm+vzer5tInvgOV/UlXqvleyFYq5Hj7vdBfJWSD99
ptIO6cjeuBOTd3ZP+QDZB/UVo8VlwmGyLy4fdDDL6h4h+0Gn2DDbqvmV7A+V
tPVGm2aGHACnhXVfflUyT+ZgD0dtFdqyQA6E5sSsWerJJTIXP2fk5nc6LZOD
sEtU/rpQYCAHY3uzoVbPYvJWHYLh13uZZbw3yKGo2znJ6x5ikXnQVzb4xJ57
kwxUeXTV9X5mvupSwPyP8Ca1zoJ6GJ4+WC5p5FhTD0MtK+fxtfG11MNhY1rj
aNu+jno4vJwNmbnn1lOPQKL+llnXTnvqEZifZm+Ztt1IPRLG+1IHFsc2UY9E
sYPb56fOO1KPwo0R+/tHmpypR0EXe2Hqk2YX6tHQHrg70ad1pR4N7sOkj/2m
3anH4JQdX60296Ieg5e6Pk1k4FbqfPy4mCAOyfWmzkewZ06h8IwP9VhMZq5Z
4M77Uo9Fp7vKpNffn3ocjh42unj8YAD1OCQ6sRarH3GoC+CXm8KUJXCpC8AO
1B7XdAVRj8c3XVpDtnsI9XiMjh419WoJpZ4AWW+j65wVqCegYJdcZXyfzEiE
IPr6kLQpjHoi2Gfujmu2h1MXwvtkmtCIE0FdCJfvZb5urEjqIqiKC4JNx8gQ
QVvY0XeoPYrei2BicW9OVRm9ap0I/L/YDYysGNonwS4orPoKj0/7JLTYXk3u
fC+W9kloZO8VD66QdUk4a23YPTcVR3sxnia67XjVL6C9GDYTdor5tnjai6Gv
fV/f1JBAezFG7Cu5JmWJtJfgncncJ2/lCWkvwZNf2laG3UW0l6Bx0LhI/h1Z
J4Emraynen0S7aVQqvj7c+vJkKJgIr15zkxMeykuZtQEG6rIOikG7HM0TUYS
2svgfiusY2AfGTJ0Gyz8816RS2XQWh87UvWFlPYyzA8OZ1kukRlyfMT0PG1U
KKO9HHcsnarlv5NL5Yjp7mpk7pDTXo5ex6BK5jyZoYAhWe4mylHQXoHbL9oq
9Q/JpQqsPdHffSlbSXsFKi/XGW7PkBlKCA4d0Nh+mEx7JRZfstNqp8mlSmx8
3t/BzdpGeyV2p3vUG0+TGcnw1egc/sxM4f0DWYK6GA==
       "]]}, 
     {RGBColor[0.571589, 0.586483, 0.], PointSize[
       NCache[
        Rational[1, 360], 0.002777777777777778]], AbsoluteThickness[1.6], 
      PointBox[CompressedData["
1:eJxt0X9Q03Ucx3EYd6joyegg5VcMmoDx+8do/NyL32yDDcZ+ANoGEyK6m78w
CggYh+SpZcoiuMBDUnDpMkoNoqTRwKJQEa/iOJUOhZGYxhDw9KQft3f/9b37
3Pce3+fn9dfXW71LUsKwsbEp+ef8+/7/50/eVLCpdGp8OpY+ABFjwUshP8ZZ
uRbjIc4lppSMeKuZMDwU1Z9sayc7g+HqLup4NEHejJoE5fRK9ZoEqz2gNduP
3fYLIrMQUPsguvGegOwDw9aUyfbFHWQ2uirWfKGxqyT7wqJ8cGtj/WGyPy49
PVCxM66N/BJKuvu8J4b15ECcbBjOqWVcJAdDNSm/yrlmJIeigmNQvNA+Qg5D
qCDxReWX4+RwMJLUfTfUk+QIbHJkedxfN02OhNdSVFm83RyZgyr3LrUh+iE5
ChfNHcsVdxbJL8O2NtN94bfHZC5uBzWx4zpWydGQ6mNDXtcxeFbHoErTxCvk
2ZNj8X5B3AWR3IEch2LdaY1iciM5HieE6z1rZp3ICfj568qPjrY4k3nQb7mU
1aLdxPvv9zbLdB2NnW5WawFJaHqE2xNP6omwS2pztAyxqCdCXNbPYet9qCch
dq/3oeRuNvUkjHECb04N+FJPRjsz3LZ6wZ96MnStu/84FB9APQWGPf2nqz8O
op6CUcsG7YRjKPVUhPpG/JVcEEY9FQPswbWBPeHU09BR6bguximSehr2Dupa
XWo41NMxNn95uXgxino6hG9X6a6Uc6lnICCyuOvRs2jqGWB7HR6oOxZLnY/7
wh6hS3A8dT7iqszL228kUBfg1MjQ4zqAugAuSzM6qXsidSHsr5cbGE/IWiGG
txYdLLqZRD0Tcw6OYv53ydQzkdypX2k6m0I9C+fCPsjd3JpKPQua+W7mhQNp
1EVw//0zU2JVOnURWrv7F47vyqAuhsZ1wbW7lE9djJhXTSauWkA9G2dm7+g4
KqHVyMZztzaU1Cgz6X42NFdU2yyqLKuN2Viccpt7c4eI9jmY9a3ps7wmpn0O
LNJ3+GxuNu1zYDpa8XzPN2RjDjqPONQzk3JoL0H+WUtb9A9kSKBKHBn2Ekto
L8GzqLBTvb+QjRI4X51kLStzaZ+Lc6z50jEzGbn4XPOuOXaPlPa5WC2Lyg5+
SjbmYme/8sPjjTLaS9F/TLZSx5TTXopm8YztaBtZKwWTadP5lp+C9lI0lHy6
peY82UYGXhNHdJ2XR3sZhoYG+ZpRslYG+2/39/Lz82kvA+sn/xOqWbKNHN7X
fMv05QW0l+P7aieTp+022svRdTCj+asjZKMcOp+5e294bKe9AsMtqTOZZ8hQ
4DyX28vlvkJ7Barvjn8ScZlsVGBfVI8fV6qkfR5C5L+OYJqMPOgYReqM3Sra
52G93mwnWCUb85C6z7OBlVZI+3zcdfTf7/xeIe9vSgSseA==
       "]]}, 
     {RGBColor[0.915, 0.3325, 0.2125], PointSize[
       NCache[
        Rational[1, 360], 0.002777777777777778]], AbsoluteThickness[1.6], 
      PointBox[CompressedData["
1:eJxty3lQ1GUcx/GFQkiaQETOdpT7WIpTNjmWz+6ysCywwN6ccRORQ6DQiAlL
iKiBSBISh5ZNmCMhkjEMccUxQkVxxIAF5BQpYikosFkg1fD9s9/MM795Pe/n
Y5WcLUnTZjAYaf+e//7//y0HMF32fTA46upHF9DXC76jb7XDf5t6aFYPt8xf
P0o2RLHpmdPHJ4fJxuh32Hh2vEaLs20zuOaLcmafdyG/iKwSj1JNmpi8Dzav
r+/9Zmcm2RpVVzsKH8yoybZospLPNRw8R7ZH1jNDrB9nPyY7Iv937Xb7Q21k
Z9S7T9uXtveSXSA2Nbir9d4I+WUUjVQuSCsmyW4QpY6d+ap2luyOjdJbDzXW
C2QPuOXHNXUfvk/2hOrNxKSdXo/IXvCd1k3LrdSQ98P4kcLC+adNsjeKPukw
ulalHbBtNmrudBaudOwgv4LeI6ZCxwx98gEENbL4pyIMyT44Jxoc93HfTfbF
9amBVbNoE7IfLM6W+bjcNCf7Q2sqXWh1lEnmIMbTr9y5cx85AMsJxReXZ6zJ
wJp5bLXU3G7baqD6wXpzc4EDdS6a73XFcTecqHNxafRKelCjC3UeTsZeHvol
zpU6D5at2h7mTHfqfJT3Wspt6zyo85Fd8DjX3M6LeiAq+82cjnXvpx6IfhHz
24lkNnUBuEseyw3GB6gLoMkdG4+f8KEeBFZw4Rfn6/2oB6EgfVExms2hHowW
1U0O1wHUg+EnSo27YMmlLsSqOGNXvzGPuhC29z/bzDHiUw9B+UNOcZ5xIPUQ
tC14TbxvIaAuwtPUWzoXbIOoi2Bb/bNerEcw9VCMCQ4X1fOF1ENhZHClxlUV
Qj0MtYyR+cVsEfUwDJTIOXWnQ6mHQzN38Inpp2HUw8E7+VEPezicuhhJt/e0
ji2JqYvx+dLWjTndSOoRiOEn62bWk9URWNW65vanaxT1SIzxh9aODJERCbFs
8oX5WAm9j4TF7gzHPY/JfZEQNZV9b/iulPZRMLrhHzZgI6N9FBICp/P2dpPV
UXg7i11hppTTPgruPd22l1bIDAkyT/WatJYraC+BcPLicW9HJe0lYJ5InXYa
JPdJ0B6v6CtMVNFeCoFow8d5kwwp8i5XV1rVRdNeinXWU3kMO4b2Uvy14nTs
6x/IDBlGfTkxr+XG0l4GfV54l7NhHO1lSJn4dVOvhdwnQ/xcicHfofG0l2Ox
tLbgyT0y5NB4qeI3yxJoL8d5t7R4hv2rtJcji/1H5cYAmaGAwKTfZd0tkfYK
3I56ye63IrJaAVbqVOHwd+Q+BVwXg99pZCbRXokea++cpDfIUELguVWx60uy
Wom1Q/VOV59Lpr0SDToWbSwVmaGCYcpc19kmMlTolszpz6yS1Sp0vrVcucVL
ob0KAzZGmTpVZEY0Wj70X7g7nxLwDyadroc=
       "]]}, 
     {RGBColor[0.40082222609352647`, 0.5220066643438841, 0.85], PointSize[
       NCache[
        Rational[1, 360], 0.002777777777777778]], AbsoluteThickness[1.6], 
      PointBox[CompressedData["
1:eJxt0WtQVHUcxvGD4gKRBgGtQBo4Ci4gl7XlIiw83JbrssteAQEVZDfExBli
kGpyBWGCmAxlS5BLQQwMidwqCkVWoyDSACnAjAA1AgRiGESKimz4vezM/OfM
53z/z6tjm5QuSdnEMEzK0/Pf+/+fRT/rLI5Lh022D33AzhvOL5QW+/M3aAg2
L8Om5Voj2QQXlrTd+4TLZHPcibTP4artfTe8HckGf3lbNInIL6L4n7L21wxP
kG1Q7e95c/SlfPIulDFXP000u0TejfUG9/6anstkO8w+vtddmXqVvBdHmqzq
7BZ6yA4YqJ/Kszg1RHaC6KyEd31qjOwMY82HLU4PfiW7gn9HM9HVs0B2Q0Zz
Y7fPo2UyF82FJgezKtfI+1H9tfSMXa+e34ZfRtvb2sIuNYvMQyp7izKvzZjs
jpWKtuMVIyZkD7TvnPUtcDYne6Lv4eWSuV/YZC8Ure1wOzdtTT6AV5/Z/J5i
jw3ZG7WKdzr0c3aRffB6tsVHGqM9ZD4859mp/R32ZF8UbHtTOFziQPbDDOvi
88nv7yMDfu0qe8tDrhvWAM3C3qbsLVzq/rAsqKqt7dxP3R8DMzfGHuXzqAeA
y59kSg97UA+AqMB0YTXMi3ogfnquzDwmwJt6IELZqnL9MD71IBS1OhqLEvyo
B+FuxDg/uAvUg2F9Qq1kDftTD4aBOM70g6UA6gJwcl0da82DqAvAuytzmfAO
ph4CTtrKwh9qAfUQGK+YmNZdDKEeiuXb3W9U3Q6lHop4t+yMSlY49TC4jGXk
JgVGUA/DtkmPhMbcSOrhKDR7tiWwR0g9HIzt7+NzW0XUI8BS1QR96SimHoG0
YsZiYJDMRKKhwOIt2+xo6pHQG7xuoLWVUBdC/8m37mbfkTVCcBuStHmZUupR
KOSWtA3byKhHoc+8krN0i8yIIHbxqO/OllMX4djJue0+9grqYlw5vt4Z8iMZ
YiSlRbiP5irpvhiCxVPycW7MhnViVCFrRHSfzERjsbTfcMf5WNpHw/6+45kD
AXG0j8ZqlHT90hJZF42c0/EqXs1B2ksQXsf//k9pPO0leKXG9fyEfgLtJUif
ESjufUbWSTDbbL51QpVIeylaPlavP2Afor0UF3hxgz/3kjVSTFaeC57wOUx7
KXaf/W00QEtmZOAYqT4vnidDhr6Jo0O9wUdoL8Oadeu7DyvIOhmEJiebJh+T
GTmKnjQldgqTaC8HJ2vVKrOWrJHDdbG8mvU3WSfH6tTUcLosmfYKxFoYVlz5
hAwF3DLrb+o2HaW9Anps7XxNLFmnePq/rpXLm8mMEkvTod5DrBTaK7G6mQ+r
BLJGiW9MrKL2tpF1Sjik+QjWDFW0j0F31oqwOJGMGPyQv3hruo2sicHIV6eP
MUZq2sfAKc/JcCSBzMTCyzLli7RWtd+/KNyvHQ==
       "]]}, 
     {RGBColor[0.9728288904374106, 0.621644452187053, 0.07336199581899142], 
      PointSize[
       NCache[
        Rational[1, 360], 0.002777777777777778]], AbsoluteThickness[1.6], 
      PointBox[CompressedData["
1:eJxty30sHHYcx/GjVmaVdCZ0HrKy40ar9VDm6dynHs8d7pk7qh5a9MY66/og
Nul1qBjxkFlpqoqOoJt21HXbdXN1qKmVmaLVEpqyInrrlqAyXRffP/dLfvnl
9XvnY5/ykTjVkMFgpL66/73/f/Scf5SlVZaq7gD6QJymOs/AJoe9SRM0ufxU
h+VH5O1IaHZTXnN9J3DTFmgKZN4sj4wi70DfTIbb/HQW2RbNZS5c6bYS8k48
lXNLzhc0kB1QU9vvW9h6nczE+F9/F1Tye8hOOCR/4Tm2bYT8HpgV0azgtkdk
FwxvCIub5+fIu9FUfsG6rl9P3oPIvnh9evkK2Q26spBJ9cJLsjsYwRe3bF01
4mzaA8Vmys4375uSPSGYyGuyH9pO3oduq7mbokYLshfOHh9zynq2g+yNdW99
6+g3duT38YVJYx7jqD3ZB4pCs2vJbCbZF4KawSrnYBbZD8OOl3nqXBeyPzJs
Ph7zWnQlB6BN3Md40ONGZuOXjYK5L694kANR35Ks7WreR+aAP7KqkGq8yUB8
kVVhxKzPplWAh6dfQLWtP/X9uJNUEe+vZFPfD818sdT9Nod6EDQTr/X+bL2f
ehBW3Nh3KhVB1IOxZ3BGcvlSMPVXPlGzfnIphHoIltWGb9VxwqiH4IyllV97
dTj1UDzh3XYIWeFSD0U0z7XoWRyPehg6HKpyRDo+9TCcKnXa+oZbFPVwFJs4
7u2ui6YejtoJjaDCVEidi8QYyfjRPrKKi/nsbxdH80TUI2Bj99CiPkhMPQKf
lC+ttxtKqPMgSH+8a0lHVvHAHl24tPeslDof/K86pMkRMup87Jo1ZKWZxVCP
xKSkh8EcIasi8XSm2PLzqljqUSjZqH95JEFOPQq9ywFt3e8qqEeDJT2dmrNA
VkWjd7K4/7Pv4qgLYKUYMv8+O566APdaehJscYC6EP06I/UF44RNQwiNXvyb
8xBZJURF+8BxzbmDm9YKsXNtWRd6MJH2IqgdY6enzJNoL8LzJdbrJSfJKhES
194+z3xA1oowEGb3awM7mfZi+FSe3mJQT4YY949N3/I1SqG9GA/H+erwdLJW
DJbZp12OA2SGBEUzQ8/v7j5Eewl0Z7JrA8vIKgk4CVOKrD/JWgl+qKtxTpIc
pr0U1jJRvWknGVK4Hw7SZ1qm0l4KwXrReP4pslYKsdncOeEEmSFDbv7jsbs+
abSXgduSmb9RTVbJUCR7UTO1StbKYJo9vPqhPJ32MXiivG535QYZMfC6NelY
aXmE9jEI6UjrdzpB1sbgx06HgqTfyYxYMNuN/wh0V9I+Fr5pC4NdpWRVLNZb
p/JnFsnaWIQd0402cD+gvRz3ylNmDRvJkMMeV1kGBhm0l2PNmKe8eICslSO3
MPjr8RtkhgLjG0FrV80zOf8CCx697A==
       "]]}, 
     {RGBColor[0.736782672705901, 0.358, 0.5030266573755369], PointSize[
       NCache[
        Rational[1, 360], 0.002777777777777778]], AbsoluteThickness[1.6], 
      PointBox[CompressedData["
1:eJxty3tMU2ccxvGuSEInIAJjjDlwFRABlUuVi9A+tJRbrW0P5VqRi+CQO8IS
IMiOogw2Lh0wREnYzIguEDLDYIAZ7iyIqxInsE3iTKNmCF5wE4l0IJtz4bf/
dpI3J5/3+z7vZhQyWXwej5f16vz7///vqcRmytGkjxCE0gVMYwc8Gjb2kS0w
8VeZ53VnS/GabVC6tHnCMSuCbI9upvO1Qr9isiNErvx+0ayevAmHuId3ZH1f
kjdDfFg27s6MkIUoMOzInXlwneyKTLuVpKO7bpPdob+Tx9w4N0v2ANdj9mC4
dYHsidDA44Nt48tkbwRMuzCTtnzJmnegc6dT/pN0C7IPStbp+APGDWRfzBob
Vzi5PdkPszJ3jfPut8j+mA7WO7RfciaLcPnPgjdFBULyLqyvW2Kmx9zIu5Gb
52z368Ft5ACIyozvN8q3kwOxQX1MaNbvQw7CS0Vt+cYZP3IwvDzG22J9d5H3
wMlKUO56JoAcgpT0jrF7m4LJoTC3T1tdHAwhi8FW+p7+6bCELIGUeSQ/4RhG
Bs5vz+bb1UjXzAICl8LAmVUZ9TCIHBYMiko59TBsvSiM6zKLpC7FD/dEH6ma
o6hLsXyl5/Y3W2Ooy/A8dWhRMaqgLsNSx0DVh5lK6uEQi451z72uoh6Olfmg
QVOymrocQ9zUthY/DXU5uptyMiwtGeoRqBVz9d5zZDYCFm9Y93KjsdQjodti
u//MWS31SOROKUab2DjqUTBeK/65Ii2eehRaBXW5gWEJ1KPRdVH/93lhIvVo
OMnd8nvWJVGPgfLz0nD3OTIbA5NReWX1ajJ1BUJsnzXb9eqoK/C0r9ZXrd9P
fS/EJ3RTp0tSqO9FXd9I5634A9SVKHlR1rASlEpdCenMzKlS6zTq+xAQdHT6
6gdkdh/Oinzsnz/9r6vwuELa9Ud6OnUVUv1tVP1TZJ4aLzsWrSWyjDVDjcqJ
nNL6r8msGr8p9y60bzm4Zk4NQ9W6pLQWMk8Dr7J0g5GfSXsNqh+tGtcfIbMa
BO/Jd7h/l8xpkF297JKpyqI9A4HIar56hAwGmY1vn5Z4HaI9g1SZQ0VzO5lj
sOzBepWZv0f7WPSaXWiaLyYjFl+MX7r52EhmY6Fo9eKORGfTPhYTDvyHVf1k
nhYd2v4Za5fDtNei3uqrTcI6MqvFiOn7U0PPyJwWNXmbJ6d0ObSPw33BcE3x
ZTLiEHTNLuVT71zax+FyTnmVuJXMxeGXBo7Je0HmxSP0plvyOxl5tI9H24/f
hqsMZDYecn2j5uX2fNq/en/B45ZnC5mXAIN/6a0bJjISUPTZivSJroD2Cajf
+fHd49+RuQSMpmdbfiIspH0iHJcGWMeTZCRi2dCmcpojs4lIGU65r3Aton0i
HmtDvK5qybwkzE/+fs78ZJHkH+P9sX4=
       "]]}, 
     {RGBColor[0.28026441037696703`, 0.715, 0.4292089322474965], PointSize[
       NCache[
        Rational[1, 360], 0.002777777777777778]], AbsoluteThickness[1.6], 
      PointBox[CompressedData["
1:eJxty3lM02ccx/EOmTAugcksoCC4AboGucEC9sNRWqDQ0huqICig3MrYgRh+
BCQoCed0CRLCphtmcuh0o/4jHeAKzAM2YKAYzKwCSgTdWMYYbC58/W9P8suT
1+/9fFzS8qXpRiwWK/3V99/9/2eR92mNkJ34UBxKP5D55YJZkecM2RQ7Nt4p
tK8O2rtuaxQ3+A+3/ZFL3owt01F2lfcbyGw4Zvbaemm7yFvRM+ads3a0n7wd
8olRt0LDGNkVJ2pKHW2PG8jv4mDsRcsA8QuyG86Wtxv7WK6QPaDlFqU4T2/g
rXsXktJfzjYNmJM56BUmxN9rsyV7onj57PUXwWyyF5wNf/ada3Eie+NeV99a
+WNXsg9Cr3bZ7XrgRvbF5V4Z38nnfbIfFofK+m9P7yb7Q+U5NddV4EMOQMd4
zLWnbH9yIOQNPectngSSg3BJ7DJRMcYl78HGtA/6bxpCyVxUtJR+dLEK5GAY
RjPfS+WEk0Ow2nehKHcqghyKtwat3uj/jE/ei+1P7Fry9wvIPIx1Ct+p4kST
gbu1I3Uc49h1M4B1qrHfyUci6mGob1Qu/TAYTz0MmR5Pv7XXSKiH47b7rK+F
PIF6OL4fMHlwWCylHgErTXnTI5GMegTCmcIZX5GceiQ6z1j+/Xacgnokbhxn
jUOspM6HsmSytFiqos6H+9im2QqlmnoUdBndJTs1idSjcLnNdS7oQBJ1Ae42
sEOr0zXUBTjdaWS7lrWPuhB6u+fsYwX7qQuh0d8JGSpKph6NoH/4HvPFKdSj
oTZ09k7zDlCPQW34j7N2vWQmBpx2TpN5ZCr1WFi7V85dvUlmYvFhdZbJBkEa
dREKguoHn+vJjAi1Uy1JecKD1OOwxUF865MBMhOHlH1RRmbCQ9TjIVhULrD1
ZCYeRoUsfMFPpy7GZsHnU+f7yIwYw76ZzdvCMqhLYKHrXtl0gwwJ2sPqWou5
mfRegq/lDgrNd2SdBOJlw+8d3odpn4BwU/+due1kJODxtda4RrcjtE9As0cJ
17GVrEsAL19zkmWfRXspChoMVrx6MqQYYoJGfzLNpr0UzcGjXG0pWSfF9bkO
h/klMkuGGP1EXXZ2Du1lGD5TpvZ7SGZkMPnLrIEvz6W9DPmTyeatejJLjpE8
ZwOfm0d7Oco8Apf2tJMZOdgjHx8p3ZZPezlElZpz9jVklgJ1t7pOma+RoUCs
1rHqUkAB7RXgXfEMXssl6xRYmX/TdfUCmaXEoWSF9qv7ZCiRwZTbLtscpb0S
MXHBOS8FZJ0SO/qcr9SfILNU0Gb9Mjz+DRkqPPP6ual35vVehZzJVaFy6zHa
q9Bdl7S7UUJmqVF+eqCnuIIMNaQ2C41WWjKjRn3ZbyGSZ6/3r97bVLuEORXS
PhHx7TElv0oKef8CjVaw6w==
       "]]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
       NCache[
        Rational[1, 360], 0.002777777777777778]], AbsoluteThickness[1.6], 
      PointBox[CompressedData["
1:eJxty3lQ1GUcx/FfBIQQjhiHcYStBrIDSBwS535gWWCFBXbZCxUhYFFOEcOA
BH4mYQM43AWIObAcHmWITseMwibHKMIEDFDOGIjQlJVyGXEMdAxf/+uZeeaZ
1/Oez5txxyQqLYZhVP/e/97/P3O8OjNfF7fjlT70gfT21bqRRAvfTeqhaKbO
sa8/nrwN7rlWAz7VlWRjCP7QGcvxvkHegb9+4vT3DdwnW6KCv4U3cWuSvBPB
y3ZrDj3PyBz8qnq8Iy1vlbwbwlcFG9wJbd6mbfDyw9wbYTe3kvegYKukJvyo
CZmLvCah3lStJdkeuYuXe2MyOWRHlA3/UGm+05bshK/lw9aiMHvy21B+xF2P
W3UiO8Ns8rP5fB1XsgviRzlCzwB3sit+XjeMS+rwJLvBfznHjAn1Je+D8XQC
p0TXj+yO6Upfv9llf/I7ePDBsJVsLYDsgZRYddmGQRDZEw57H30rshOSvWBX
Iuq5Lw4he6OqxbndoVBE9oGrSXGLuCuc7IuOQXmP6UtiMg+HrYtMJt6SkIHv
zxprFYgiN80CexqddAvfl1L3g/7jH0POqGXU/aAei2EshuXU/dGT/sh08W8F
dX+s5x+Wde6Nos7Hn4NtZ11iD1DnQ518yUC/4iD1AMR9Mz6w9t0h6gEI8dbX
6luIpi7AlW23arm7YqgLoL6eeiTHLpZ6INiq+uoVDZkNhF6aIkFX+S71IIyU
P/+q+hmZDQL3qbCmvjCOejDU3aUNhubx1IPxhof7gZlrZEaI/t/sdc34CdSF
uNp4jnthnMzsRxBfqyQlSUV9P0zO2YRnrZGZEExUvR78ZWki9RCMWjCNRlZH
qIfiysXzJp9+TmZDUZ+6bufldZS6CF8YCqdX7pJZEWwXDjoNyZKohyH0kCHn
9hSZDYPghGVWd2oy9XAM1WQmP1kis+E4jUXsY1OoR8BBoNN5TS9104iAhfoU
N7KczEbApvmhs7VZ2qY1EWgo1WwYXCAzYuzuTvp4Oyed9mJkN7dbOrSSWTE6
S+64Ku2O0V4MEXp4FVfJjASnCptqk00zaC8B+L+0lMvJrASZovE5j0/IGgmq
5/vuqcbITCSaJFUXXzM+TvtIKKVLT/kSMhuJspmxB8tlZE0kpNvbrrsNkhkp
il1tbTe2ZNJeiroOVacskMxKMTZXNM77kKyRYqjRqLzrNpmRoXcxemZ8+cVe
ht+dMhyLXE7QXoZS72C3gTSyRobyM0+iWtvIjBwppUt+RlNkyHF56Ka2vvl7
tJejouCuS5mErJFDNVSW31hMZhSob5zN498hQ4EFo96M7JUXewUuxc97852y
aK/AYNvp7NZEMqPE+ZmI580NZCihPVub7zdCZpUQzIgU+a+cpL0S97p2SaK9
yUwUmjSjE5MZJ3n/AIvvs+w=
       "]]}, 
     {RGBColor[0.880722, 0.611041, 0.142051], PointSize[
       NCache[
        Rational[1, 360], 0.002777777777777778]], AbsoluteThickness[1.6], 
      PointBox[CompressedData["
1:eJxty3lQ1GUcx/FF5HCRI2NaBIpDAmblDBeF3OUDuNywByyHYnJfxqXcNfAL
5QpBgRECCgszzS0sYk1OtxFIG5YCBGx0hjKBoJQjoRl0tBq+/tcz88wzr+c9
H4u4TGniFhaLlfjv/e/9/7PsUTc0y92VNcGnD5hyVBVP24MFm9SGc9aNNVdR
DdkAWrn5j7P5CrIhLpd6qmvajZONsL/MxaxZPkc2RX1HfYWR1t9kcyQqrOXc
oK0em7aEcVfyoy3WBmQrcArvX3dQccjWuDhaatb4vjnZFuMLbNmfa6+TuViw
UTu+ZGJHtsP4al/yTJ4z2QEf+7DH7tjzyE7oazubYrzbjeyMgpT+T2yT+eQ3
8N12n97ahyC7IOFVvUoJvMl78N5rzcuLl4RkHsoelbSft/Iju2LeL2Pk4VcB
5L1o09IZlgUGk/chd11bs2lFRHZD0kpX6JRYQnaHQmU2uPiFlPwmBh+EaoRs
DyPvR7VIrJmWISPz0WI9WT4wHk4WoPaPysPD+yLJHnAxfStj5VwUGejR3VvS
q3Vo0wyg18o92ZMZTd0TTjt+iDozfZi6J6wHz1fOCo5Q98KxdRvPXmkMdS98
Lo3yOqkRS90bkVdK3eTfkhlvNL8k0NdNjaN+APLWGYuqnfHUD2B16lag2i0y
S4hTHQO+0fkJ1IVw9eLpVFklUveBGbeNU/oTmfHBUlrqN/7vJFH3RVO6jeV9
q2TqvliujUn3U5FZftjIaxLl56RQ94Oagc6JdONU6v4wjt2mxr1OZvyxsyeo
7NO4NOoBSCtPshzdepR6AK4ldZq3XCCzAjFrm7CuLnybeiDuTjpG6f5GZgXB
Kieh4lpJOvUgOHUZPtEwyaAejJH4z26vd5GZYGis/eJSG5xJPQSsD15JnXxA
ZkJgUnM5OYOfRV0EnU6D/rsVZEaE76s6fLvHXnQxdtQOZGubZG8aYrCv3D49
FE9mxOg5/ZHbopysFKPtmepS1l9klgRz3G59mfsx2ktQ5HjPoZEhMxIEN3zZ
uWeYrJQg8FmDvZPOcdpLkVYtklSIyJCCPxfi6N5AZqQYqjdq9J8iK6Xob3kq
Vxjl0D4URVGz1SUHyQgFd+PJvLyVzISi7GoX2+seWRmKD4sn0v1Nc2kfhu6j
Tvk3D5ERhjJeashgC5kJgzqnWc/rZ7IyDEN1wzwhJ4/2MvQ3FV9UhZEhw0T5
WNGdOjIjw7zFrlMxo2SlDAqtidgj7Hzah0PB5zA/CskIx4Yg/GoHQ2bCIWjf
2Pa8h6wMR5s978Lw4xf7CBT/WvOyrkMB7SNwhj/zfDqJzESAtSS02X2OrIzA
1yML0expMisSNtFng4r0CmkfidqbfQeLhWQmEgEj4mKjd8nKSPD1C4oCOsms
KNwws1w1/L3Q4x/8Lqv4
       "]]}, 
     {RGBColor[0.560181, 0.691569, 0.194885], PointSize[
       NCache[
        Rational[1, 360], 0.002777777777777778]], AbsoluteThickness[1.6], 
      PointBox[CompressedData["
1:eJxty39M1HUcx/EvDIWEkJBdyJjkBUryowP5/ete/D5AjrvjfokgB0SnYAKC
iCdwXx04JSgaiTAZQoA0DssCB8OGR2UzbIDyS5AtG2pBFlEwoCSq8b7/+m6f
fff4PD+v3ek5kkxjhmEy/z3//f//+41fk9hjvKG1DqELFE3nxua9WkI2w/kl
uUXK3S6yFerZOzEcTJBtMCqtOLatdYFsC5X23ZFZrhF/0/Y4Yqq9LnTaTn4N
nzfeFQdxdpK5GLi8vJR3nkt2hJ9S8sto2xvkPZBabLnc/oxHdkb7hbrQz3K8
yfsg1FiZcVMDyK4wW34gbrnGJ7ujuVh9sr0hjMyDbdN36f3lkWQPKAqGfKou
CsieaFl81D/WEkfeDzu3qO5vRoRkLwyZmsdqtorJ3uiNuFL/cYeE7IOsarv5
vEQp2Rf7tsQ8zt2Qkf2gs+3sK72uIPtjyVEapUs+SA6A2iJjAxaHyIEY9IlQ
3bmVTA4C9+xY509Zh8nBGEs75dxqoSKHoOf5kr/jrMF8iHnRLS29aWQgNntX
zu+V6ZtmAePHRZo/UjOoh0KUpFliPd6iHoqyNuvnWqNM6mEI9pY0zg2T2TAI
UuqcrjW8TT0cFzNU0iq1mno4jDqU5Wd5R6hHYEEluKleIbMR6F49bO7yxVHq
kZgr03t+WZpFPRK1FfGBfvxs6lGoHV/hdKyT2SgYc1SHPPuOUY9Gz6DDremC
d6hHY2HmnqLR7Th1AfLf3HpD+4TMChDRPNdUWZ9DPQZ+5sHTaXtyqccg137K
21RLZmJR0bmjtmPC0GPx5ObXCXFuedTjUOn8ldfiOTIbB241/6/WSUM/gP6J
vZNHXU5QP4BQbwk3rJTMxGM8zXXeY8TQ49Gskq9jdz51IfYKG65q88isEBNV
VvlGA4aegJRXvk8d315APQGOwvGX1lPIjAi+5jqzXB0ZItxeXSh3WDW8F0G3
y//ERvjJTetF6LJj8ra9T2bE+PCBnSWmyBAj1SRY1sYtpL0YIy+yTUKyyXox
0kXqYtMuMiPBzpkXhUZ/kiHBWpLD6zycor0EK1n5mkvlZL0E7ROhgx6DZCYR
vyafcbWwLKJ9In78yGlkv5jMJiKi5gqvp4asT0TfBm+laZzMSBEdzgyucE7T
XoqfH62fHlCQWSncraaqTOrIeim6r3bobk+SGRkk3w4tznM0tJchNVXgWywj
szIUBo9y1TVkvQzLkdY3mkbIjByfZA8HOr18hvZy8CV2E2sCMitHreV7cpcy
sl6OT92OPx3sJzMKhBvZPJ1dNewV8BExaRrPYtorcIkXZP9BNlmvQMDkwzX3
VjKjxEOndlHSDBlKVN/X/bDDpoT2SsxqV4XJcWS9En9r7w17nSMzB3G/ZOhZ
fW8J/x+6jLJL
       "]]}, 
     {RGBColor[0.922526, 0.385626, 0.209179], PointSize[
       NCache[
        Rational[1, 360], 0.002777777777777778]], AbsoluteThickness[1.6], 
      PointBox[CompressedData["
1:eJxty39M1HUcx/EviCnDAO1AQlgK0SEjp0AHAnIvfpyA/DzuF8cwEIJDIPkh
HsQvvwyGqBiS0EJYIV2hQAOntQOv4ySdphM1kB+FjhBpSuYR6A0iFq33/dd3
++y7x+f5eW1LyYlLM2UYJm31/Pv//0/PvyaXLboqYwLoApyEckx1XCCvx/am
vqB55zGyNc4d07rKvV+SOWhOe2NFFmjO/892sL8w/mJidjPZARneXTG+Z5zJ
W8HxulerWnInOyG95yw34ZUn+W0kxqikThxf8juYWixBbyLIrnic+kxVPBNM
doNzo4+iuTmU7A7TTu3HRfkR5B2o0ylGQlJjyDuhjv2kS3VJSN4F/uRne8Y1
IrIHuq0yv/e/LSF74kRyoWpiQkb2QqbTMNdJLye/hzlDblLtmkQyD+qs75Jy
bN4ne0P+MEku2JRM9sGfeYMuVnYHyLvRfv6HmntbUsi+GO7oXChyTCX7YV6Y
smLn+AHZHzxRPk9jn0beA17uTR7HNp0cgBb9lLDNUkHmQyw/U/euWQYZ8I9W
lv30iswCjlV+356cOUg9EA5d0/pdQ5nUA9EW0lkyo8miHoRPj1cvDXyZTT0I
HRvsf6s69iH1YNT9fP31NRmHqAejq1/t5SnIoR6ChXxvvwqrXOoheCteuf5K
MZkRQL5oEEinjV0A65Gx+uLIPOp7UT7Qx0ZfIrN70SMXjP1ql089FNdPFP3i
XkZmQ6HdODvMnTT2MAQYTv/4JPAw9TCsRI9sLWgjM+G482Ctu9akgHo4zLen
l32VRGb2Yd3f2WkuGmPfh9uVjiayzUeoR2A6o2etOI/MRuBor/4095axR2LU
7GTb4DYl9Uj8UWdfJCwiM1FQL6vSe+8YexSCrpksbnUqpB6NxzaXM7qPkNlo
pJe+Ka26aewxuGGZpD1nX0Q9BoUGD8OLLDITi1HzuwtRGjJioWppNf3c4iN6
HwvZ/EXuuJysi8VrHoVcs3YyIwTv6Sk3t3kyhOBnOtbuDyimvRBb9nfZna0h
61Z730PuyH0yEweOPj/cwb6E9nG44Rk+pDxAZuNQL8kKmGon6+JgYbvckvKc
zIigMNlgsPEopb0I69T3bR2UZHa1m78creol60ToUD+/LFsmM2JUZocdagwo
o70Yrkt33cJYMiuGOLbPkHeVrBPj1u+nGpZNymkvwZOaesFQIBkSNB3OFk2y
ZFYCTm1/lmU/WSfBuKNDqWTZuJdC/2hRO+BzlPZSfFMfZJtbQGalaHX5OqWi
m6yTghe+8+rGZ2RGBpvOpjHrTSztZeg/7vXXgx1kVoaK3eOPEiLIOhlmG1wn
2xVkJh5zXq2tmkrjPh4uSovAxi+M+3gIzivcPa8Y9/FwSz442DBi3MtRrX5a
fXGO5f8DWqq7dA==
       "]]}, 
     {RGBColor[0.528488, 0.470624, 0.701351], PointSize[
       NCache[
        Rational[1, 360], 0.002777777777777778]], AbsoluteThickness[1.6], 
      PointBox[CompressedData["
1:eJxty39M1HUcx/HvGQE6RSKbsHXyUwIiIvl1/LzXIXDoyQF3cHcYBh6/Q34f
4KGch8AEFeaPcgopIKC5AWVQkKKRlagI6gQ3EEj5daVFSTAZBFTz/f2vz/bZ
Z4/Pa09LZYYkYRXDMAn/3v/e/z9/8vM8l/bEnjrkRx8oKnWb2rmpn2yI+I6w
0zYxC2RjfPi8NLFKaMJ/5Q3QKf/u5CmtyKZQq9scojqcyG/DsjhH36jPnWyB
ntfN26Z4fLIVeiLNXELfCyDboKxeduaLlWCyLdI0j+ucOWKyHQY6DNbOHAsn
O2B9LjOyaB9BdoTJ+5L81m4Z2Ql2McNZKYlRZGccyHm4qum1aPIHGMwwmMw7
9xF5CwYDQmoPV8WSXeBoILs7Nbab7ArPB2+Kf30njuyGG/dmnzYmx5Pdca/e
UoiGBLIHzFSBLq1DiWQemgx5LYZrk8mesNzwhKfmpZC9sD7YLb4k9mOyN1wt
e090lKSSfZD4jaz3ZcMesi/Cd4p9vLrSyH7oDE5cGRlIJ/OxwL1tUzSVQQbU
/AdG0erMV9YCG8dSx42XyIwA3JGbsXGaLNoFqFIff351icz4g1OedOFFQTbt
/jBXnemvmyMzW1GTUK3/V1oO7VtRFrfbfHSczARAxqlQJctVtAdgXmH8tO0W
mQmERnx0zpCXS3sgrhU6au40kpkgZIV4iLgmebQHIWcgyOmX/WRGCOmR4ZaF
SXYXghv91u2kkHzag1Gz7oeV/FayNhgRNmfLV5vupX0bkr3byu8UkLXbkCuu
tPz0Mbtvx0mTMmmTl5r27eD+rDyhOE1mRLCw/7riyiy7i2A49yTzSmgB7Tsw
DL0i6SWydgdm+5WLtZx9tIdA3bxmtl1B1oagb3PK9HQLu4tRcXXISqu3n3Yx
cnXd1UVRZCYUheOeUQ3N7B6KL/l7r11kCmkPw3rvyWWBhIwwfJYfI0w4T9aG
YcXed9T5BbkrDM84oZs7/TTUh6N67o0V5yNkhMPK66HX+UdkbTi+FSh2DVkc
oD4c3x/1MRtLITMSiM7d99ZdJkOCr2x/mxmfJ2slKOUptyjNtdRLoLxhd31Q
QGakmLCzadeLJ0OK7Ebz36dLyVophoPydacusr0U6+ydauZvsX0ESkasJ4yf
sX0ELusyJv9YU0R9BFqclpM175K7IuC5y597VkRmItGObAapZERCUSJ8JDnM
9pFYTLHV7/mc7SPRV+to2nGT7WXgWqfPuk+wvQzOqz2+S+IcpF6Gu77leWmb
yF0yjNb2pgZ6kxk56o8fejkkJ0OOkks+mQ4qtpfDOF1lFHiM7eUQWf806dbE
9gp8Un+9UtfN9grMZPw4Ix9newUubMy8X7nM9gocbK6L2WdWTH0U0puXBAau
xfx/AC8/uSg=
       "]]}, 
     {RGBColor[0.772079, 0.431554, 0.102387], PointSize[
       NCache[
        Rational[1, 360], 0.002777777777777778]], AbsoluteThickness[1.6], 
      PointBox[CompressedData["
1:eJxty3lQ1GUcx/EfYBI6ECA7oFFSLAYCKnJtyMJnYWGRBRZ2l12wQGaJKxgu
OeVaD1InC4jRTIRkFxjcgHBElEgEFYa0gA4VzSGsJoiYsEYgpOkav89/PTPP
PPN6PvN+SZMjTzHmOC7l3/vf+//nUWDX8Ue2fMNAAH1Ay11N8G9aJT+LDW4G
x/ADGwOf2hKRH1iotwndyDaIb7z75pJEQLZDaYSX4jYviGwP/aFPDLk1YWQH
yG27XYVyGfllLDgcW2NvryDzscKLOfX8CRV5C3SJjf7WFnvIznBetUwWViSQ
tyJ2SXumOyeJ7IY0nx++37JJQ96GiehfNGafJpN3wFl/5MUBVQrZA2MT0amY
SyXvhLT3SYm8MJ3sCbtrv579ezmD7AWZbnzCNz+T7I317h82zz/MIvvAb1d4
XqYkm+yLnge6YnlLDlkAj9nzI/LyXPKrMOYbta9zzCP7Qe1+Rz0xwrwLDn3m
Csf0fLI/ZKfrBFPP7CMLkfck22q2iTkA60d4Pd2eBeRAjHtZX7s+zAxcDvJe
nVEWPrUW+GZudjxkmsyJ0JFiouEyimgXQXbp3febFshcEC6aufedyS+mPQij
GTWi5d/IXDAWOmsn8rNLaA/G2tKa6dYZMifGG+cSbqwmlNIuRoHBuPfKl2Qu
BIn19x1/DN5PewhqJzcU3+khc6GwqlryFPLLaA+FYZNJ9lt1ZE6Ch2U+vfv+
ZLsE1/tcayZTymkPQ3mGzoUbI2vDcKnRTDDmWUH7bnRLeppHTpK1u/Ftm2xd
1DLbw1Ex0B5TqKqkPRxfr/BEmh4yJ0X1DotGzqqKdilOVbQaBjPJXAS87meW
2Q2zPQJdOVn6wxZa2iMhvhlQYuJH1kbi8tzqUlYK26MQ2qUXDdSyPQqaqYaG
4X62y2Cqu2Bv/BPbZRCLbljKnjtAezTahs/qy3zJiMa5qqLttxLJ2miEfp4r
SK0mD0bjnY/FLq99xPoY+C3VlsxPsD4GGTbBSbcXWR+DLH9vp+mNB6mPQe53
+72ShWRODht+S0FBEhly1J/+q/LeQbJWjsdBFzsbW1gvh8ty2nuuI6xX4I8r
7bz+GdYrYG1TKdhsdoh6BYy2jw5Jt5IHFQhDvMcrUjKnRI95q+l4JhlKCMLr
piOPs16Jezdrpe4drFfimKg1SXOL9bG48Hhn3oOfWR+LAVunySrTw9TH4oj5
/MwePnkwFu1OsXVDIHMquPV/9fbc62SokPfZ6IJ1KetVOLl3ajz+BOtVSG8e
6k86z3o1JGNjaeZfsF6Njr0HnEpnWa/G0eR0xaxJNfVq1LgadzptJnNxWNE3
mBr5kRGH6er6xTYlWRuHu2uv/m6Rw/o4rHEt8lg8yvp4vJDNmxPrqgP/AYiB
tpo=
       "]]}, 
     {RGBColor[0.363898, 0.618501, 0.782349], PointSize[
       NCache[
        Rational[1, 360], 0.002777777777777778]], AbsoluteThickness[1.6], 
      PointBox[CompressedData["
1:eJxty39M1HUcx/EviGDyY0CAhJr8kLQURX7Jj+Rex4FwcMBxB8eRHRPpYMAx
EDl+yK8D5IcwkHJBIYPFj4EwfogVpgKXWhIFaFngKDYDVs6ZoCkVktV4f/7r
s3322ePz3MvuWJpEqctxnPLf+9/7/2eJNzPSlvXwlyVf+kCi0/PGh6G2vHVu
woSzRY37e+5kUygj+3T4SgHZAimxbglfPRORrTF/M/fBYpaUvA15Ud/cUCXI
ybaQPC8civBSkO3xufZLn+knR8k7sa3Gp+JX73jya/C07hHMpynJuyHpvfjb
19WJ5DcwsPHKOeOGJPJeyDMkJ5LqUsj7cKSgYWk8K5XsDH79p/vVkjTyAfyZ
GjTVciad7IKuWOXGqtTjZFeYX72QrgnIILtB8beLo9DyBNkdm+JejNfOMntg
ZrzlesW5TPJB2Op1vrxVpiZ74q+Y+ubthllkL3SLVENGw8ze6K21iIlVZZN9
MKEaaZVa55DfhNnmB3ORV5kPoWRt9+MReS7ZF8udfqkry8w8ZDp6Pf3w9Eky
8Lu8wfXR1rx1a4D2G8W1JufJHB9n8p4smHnkU+djLGc1LWSUzPkht8N6yoRf
QN0PznfCjsVqyZwAenMr+5t9CqkLYPF2sc1Pg2TOHwp/RfH7u4qo+yM1cUuD
YSOZC0BBqXFPib6GegCaBioPFPHI3GFMmLbs8M5m/TCG0ioUr/ayHgjeYr7e
2D3WAxEYwuuqsyqmHoRVz+qefcFkTRBShxwOavJYF0JYavyiv5t1IYKD+48I
77IejHBrGeYNSqgHw1zQcknHg8yFYE+uTZd5POshMMivzZiuZV0EvTsJxjGX
WRehqeek8OkC66F4/Z60ycy0lHoolJYKmyYfMhcGN50lh+RE1sOgmuos+fZd
1sOhe1Rd9ugy6+HY3PySuePPrIuh+shuYM3g1Lohxhb12VqRE1kjxo+TGy6t
RpC1YthcCeR5ZpG5CPwQXdWX3cj2ESjj6kdeGWb7CFw7VVoyO8f2Efis/vud
vVwZ7SV457Ze+aIdGRKcTpjeu8YnaySotnfafjOOrJWgqE1fm1vC9lIsDk8W
+LWxvRRWneH2Y9fZXgqTHtcwqwW2lyInYQaTG8ppH4kYdcyzPxzIiMStaHFR
ioCsicTZiduauDiyNhLlnmMuHYVsHwWJtlNY08j2UUjWHxmRf8L2Uej++P53
dVNsHwXzpITjs/fZXgbzVl21Wq+C9jKMDjrL7+4ga2S4pWw3CvIha2Vw8rVZ
no8ic9GI7xOft01n+2jIzPZ4JVexfTT62xsP+XawfTQCl97a5TjK9nJwE5OD
bTNsL0frNXGx4DHbyyG6sGLsZlhJezm+uJj5gaUDmYuBkY0i19u7kvcPp06y
HA==
       "]]}, 
     {RGBColor[1, 0.75, 0], PointSize[
       NCache[
        Rational[1, 360], 0.002777777777777778]], AbsoluteThickness[1.6], 
      PointBox[CompressedData["
1:eJxty39M1HUcx/HzigA5FZqChVAH4sDoOIRDEDpeAh4/Djg4OO6IIrFQWA1Q
wuOH0FdQfpalgsRg0AnTLDEk49f4GUPFTAQCOWVRiCIQG5Q0JYbVen/+67N9
9tnj89xLuC9ZGc/n8Xjx/9x/3/8/C972ntWVg5esvekDa6xsYm2cQDbCaZsU
8XN5CrIp2iy/WBd/TE3eCPEZ7pmd5TvkzUiuK7tvbvEueQuKbG35ear95Fdx
45Pr12bfSiTb4I7ggCrG+QPyVljOSKLNZ5PI2+BnwpU1NaeQ7VGV6Vty6eFB
8nZIArU/NAlSyY4QCd+/XGj9IVmE/uWBjlWHNLIYGQmbrq46HiY7Y+7mcrSl
rZa8A0FdNVtGBelkFxh17E1zWGR2xa6JHXzD3gyyBEs5I0YpxZlkNzjljFrX
KLLIOyEONpmPMTlCdkeP29lfRvuYPTD0fEC7/5Fs8i7o+R1chWsO2RMn/yi1
zvuV2QsbAjwzB7I/Ir+BA1PlFa7GHFmKhgGBe7Ga2RvC7w1vaGuZgf1nu3rK
HpE5YHlSkO4rOkp9N1KH7l3JP0zmduOWVa3oXhPrPhhranO/v8i6D8bhNJ0p
zqXuiweaghLzRDLni88zHRZddaz74fHk+eTkMdb9cOZloXzRNI/6Hmxcti6/
EETm9iBruu+z2lzWZXhYNWnb08y6DN9VvqC9NsO6P1IsFL9bWB2j7g9BU+pt
SyWZF4Bqbrve8SjrAWh8KnVPqGc9ENnDI7qOO6wHwszMWG1gcJx6EHyGspSl
zmQuCA+cxU/FsazL4X1ewnkVsC7HRanQvqOB9WCsaX5b0a5nPRivSebtUvj5
1EOw2fmRwZyIzIXA4dn0lORN1kMxEWfBDeezHooZ0XL92nrWFTCs6jI1H2Zd
gcL32uL6H7MeBp5u8Po6i4L/jDB4lBrmJnqQuTBojGRqgxhydxiaqmNTF7PJ
vHDkHfReu7OG7cMRunROONHO9uHY19d8KHic7cNx85ukJ4YrbK+Ey0Qrv+il
QtorIa0rtjRzI3NK/La1/Me9keRuJUo6vTY0ppF5EdAFyE45l7F9BEquX61M
v8L2ETARdN4NHGb7CEy3JssSFtk+EqNTGfoLZkW0j8SC1jC04HUyF4mfEzxq
5/zJ3ZH4ui4hqSWOzFOhMWJcvpDO9ir8dSvkxMgJtlfhW71L1lfn2F4FY7uP
e/7sZPsorGR8qu0aY/somJ/sbeAtsX0UAlrlRq7ri2kfhZbOKlncNjJPjdWQ
lk39UjLUsBnMLpjXkDk1Tl38aaXgENuroS8Jqv6yiO01uFxxWndXx/YamK7v
TVK3sb0G9bNuxy1us70GLw5LpfIpto+GaaeN2StPir3/BkaVuxk=
       "]]}, 
     {RGBColor[0.647624, 0.37816, 0.614037], PointSize[
       NCache[
        Rational[1, 360], 0.002777777777777778]], AbsoluteThickness[1.6], 
      PointBox[CompressedData["
1:eJxty39M1HUcx/HTIs9fEILGIEKBkEgq9JCfeq9Djt8/747j+GGsGjAsYSA/
zcMDAY1fim1ppMmOnYT/GI1fMkbQHBwSZmDACdZExIgfOYgfMQbV9n7/13f7
7LvH5/l57fswTZa4WSAQJP57/vv///dCXCnR9YeOScV0gbUrCpnBNZYsRM/z
qJt22o/Ir6Kjbrik47UUsjkm7OwmykxSyRZIyfq2VilIJ7+OjMmXE0WDGeS9
WLvzoN5Tk0m2xZ+1l1tNTbLJ9lB/YBNzrzCH7IBnhyznxN/lkh0xdW7XvoKV
PLITfFpK7550/JR8AP0L9r3v7z9DfgcD+r1/hSjU5PeQnPtL487IfLIL2saD
PXeJz5IPIslxXv6DhYZ8CKIYQ0NOMVuEorwM6ehjtivGGgM7vMUF5MNI+2ZH
XrOW7YYXtcjKXGG7Y3HLXenp+EKyB6YmT7RfaGR74up2B6tps3NkL7jqkGCI
Y3tDtL1F//d19hFMn/GKr3rKPoplY/cnboeLyGL8XmV+Me40GygYMHLJaiBr
gNm4I8NvrXOXICD8ZnyyTzF1CbpiVgvupJMFPqjKSTA7e4u7DzYJd0Z7j3M/
hmT9pU8emJZQPwZt3YTlih9Z4Av18HTB0SzuvghazTBYNXOXYvdkQ+avs9yl
8Esdazplc566Hxay6/dUhpA1fqgs6nuclMvdHwdKHPwnb3P3h//TFHnLOPcA
rH9dWit96QL1AHT5ro9ssycLApH+3FloFMo9EOPdIyXRau5BOFnbmx+i4x4E
abne+s373IOhFSwdT5rhHoyG2+2bhi0+ox4C0SuqJ/YeZE0IDFZuyt+SuIci
oz1Y73yVeyg6K9Ke/dHFPQxXJmRfLk5xD0P9pdJi3dZS6uGwXe1R/2RP1oRj
XlLj5iLmHgGhcCjMK4GMCMSubavJV/P7CFxzlBwXVZM7I7Cj7/7Bni7eR8Jv
7sY57RDvI1Hdbrrn1izvI+HUX+joZlJG+0gM5g/M422yQIbF/bKhMTEZMqj0
U1+sxJA1Mgzm9qXI1LyXwVl9w3TwOu/lMAv7vmWjjfdyTPqVfbUxwns5fu6a
m5mb570cW0pmdF7m5bRXoNbI4l7ou2QokNfqu7VNQtYo8HDUxv9RLLlTAZHe
4OPwMe+j4BQZsNydz/soNAdfzJ4q530USmrKvH11vI9C0vSy1qSD90roW61N
JI94r0S9e3z9iSXeK6Eqj/dcElbQXonl3PwfFW+QBdGothnttXUlIxpNu2Mv
WyrJmmgUSdecmhJ5H43Nmpz2kTzeq2A4pZMXfM57FVys7bti63ivwrWJUo+y
Ft6rsKA0Xkjt4X0MJMYN3RsPK8T/AJJ5yso=
       "]]}, 
     {RGBColor[0.571589, 0.586483, 0.], PointSize[
       NCache[
        Rational[1, 360], 0.002777777777777778]], AbsoluteThickness[1.6], 
      PointBox[CompressedData["
1:eJxty3lQ1GUcx/ENShDGDAYdBYZYkXAd5L4EhA/3sRzLssvuCnHImQ4jOGRy
hD8EkcsgkggaIMxrhKX0DwSFAVNkKKVNLkWRkNQMBonkCsRser7/9cz85pnX
7/18+PsOihPVeDxe4pvv3/v/z6x7alq84NKhZHf2AypHy5uGj9OYNbEWt/nu
Yn0G83touHmkNPrXT5j1UGPisCpXZDFvQYFb14CkKZvZEMv8toXz9p8yG+O6
/rvXTg/kMm+D63Dzq8ZIjnk79JbO2TXOkz+A4kqpml18HvMOBIb4rX6lc4x5
J1L3XXzmWUE2h7Zv51qsUT6zBe6K+vVn28lW8DK1KfU0KGC2xrj42/Wfp5Jt
YOSvbCx55zizLUy+K28dsybbIddQJyU6k2wP13zzwa0jZAdkqXq7dHcXMjvi
RV2Te/5RshO2xXz5Q+098m4IJ08YTItPMDtj5tad6JwqsgteW44v7lGSXTFW
ef3khiHyHlzQ3ln3fmQRsxvUf7xj4FNDdofxaYtNxefJQH6NedLxAWYO0L+h
lP3pXcy6B8ymvYQfxTFzHojmu628nU7dE5FZ7g3KMeqeyKmbiGm/T90LIxpC
k0CzEta94Cl70uYpY+Z5Y1ozT9ATR90bZyvLK4euUvdBkm8oP2aKug9iddbZ
FuiUsu6L/SpeQ7Y9M+eLJW1dQaKCuh9u1w8m1DZQ90OKx/anRdeo+2MhqLMl
up+6PzLuBqjaVNQD0PO0LKp8hXoA1Mcu2wQ6lbEeiMWhOY3nHzNzgZh2mu8b
zqUuRO3XGbk/lVAXQm1qVMLrpR6E0o6jZQsPqAfhw7zizBark6wHo8l93aC6
DTMXjDmLjqScauohCBIqXrZkUg/BL61V+/9ooR4KlfzAz+vpPReKxty49MOd
1EWoObCpbfU5M0Q4E/TgdvA8vRdBX7D51V69z/5ztwiRYY/MfnNh5oWhq37j
pNYuZoThiPxZaaeEmQtDn2BpITeD9mEQThys3lpDezFmmmMS+utoL8Yht1rH
v6/QXgzd5ok0Pq+c7cWwO5N8o/Av2ofjXmP2aNdG1hGOmVMvFEpTZi4cC7+7
RMttaB+OS8vjxn4cM08Ctat2gp4U2kvg7Gz7ckc67SV466LSOrmC9hI8vBUQ
11FGeynOtvLve1fTXoqQHktJRS/tpTg8+U3hYiftpRjV0DKSztI+AsvxazPm
GyrYPgJRry/0DKszcxFIcZmae6LN3B0Bqajoe8MtzDwZ5sYzNSMFtJeBf7l7
14Ab7WV4pKESOnjQXoa9sbMjj4W0l0N35dhIeBTt5UjktPraRbSXQ24afK5O
QXs5vkjztT2VQHsFUqyqYh++8T98YckQ
       "]]}, 
     {RGBColor[0.915, 0.3325, 0.2125], PointSize[
       NCache[
        Rational[1, 360], 0.002777777777777778]], AbsoluteThickness[1.6], 
      PointBox[CompressedData["
1:eJxty39M1HUcx/HTIs9fEILGIEKBkEgq9JCfeq9Djt8/747j+GGsGjAsYSA/
zcMDAY1fim1ppMmOnYT/GI1fMkbQHBwSZmDACdZExIgfOYgfMQbV9n7/13f7
7LvH5/l57fswTZa4WSAQJP57/vv///dCXCnR9YeOScV0gbUrCpnBNZYsRM/z
qJt22o/Ir6Kjbrik47UUsjkm7OwmykxSyRZIyfq2VilIJ7+OjMmXE0WDGeS9
WLvzoN5Tk0m2xZ+1l1tNTbLJ9lB/YBNzrzCH7IBnhyznxN/lkh0xdW7XvoKV
PLITfFpK7550/JR8AP0L9r3v7z9DfgcD+r1/hSjU5PeQnPtL487IfLIL2saD
PXeJz5IPIslxXv6DhYZ8CKIYQ0NOMVuEorwM6ehjtivGGgM7vMUF5MNI+2ZH
XrOW7YYXtcjKXGG7Y3HLXenp+EKyB6YmT7RfaGR74up2B6tps3NkL7jqkGCI
Y3tDtL1F//d19hFMn/GKr3rKPoplY/cnboeLyGL8XmV+Me40GygYMHLJaiBr
gNm4I8NvrXOXICD8ZnyyTzF1CbpiVgvupJMFPqjKSTA7e4u7DzYJd0Z7j3M/
hmT9pU8emJZQPwZt3YTlih9Z4Av18HTB0SzuvghazTBYNXOXYvdkQ+avs9yl
8Esdazplc566Hxay6/dUhpA1fqgs6nuclMvdHwdKHPwnb3P3h//TFHnLOPcA
rH9dWit96QL1AHT5ro9ssycLApH+3FloFMo9EOPdIyXRau5BOFnbmx+i4x4E
abne+s373IOhFSwdT5rhHoyG2+2bhi0+ox4C0SuqJ/YeZE0IDFZuyt+SuIci
oz1Y73yVeyg6K9Ke/dHFPQxXJmRfLk5xD0P9pdJi3dZS6uGwXe1R/2RP1oRj
XlLj5iLmHgGhcCjMK4GMCMSubavJV/P7CFxzlBwXVZM7I7Cj7/7Bni7eR8Jv
7sY57RDvI1Hdbrrn1izvI+HUX+joZlJG+0gM5g/M422yQIbF/bKhMTEZMqj0
U1+sxJA1Mgzm9qXI1LyXwVl9w3TwOu/lMAv7vmWjjfdyTPqVfbUxwns5fu6a
m5mb570cW0pmdF7m5bRXoNbI4l7ou2QokNfqu7VNQtYo8HDUxv9RLLlTAZHe
4OPwMe+j4BQZsNydz/soNAdfzJ4q530USmrKvH11vI9C0vSy1qSD90roW61N
JI94r0S9e3z9iSXeK6Eqj/dcElbQXonl3PwfFW+QBdGothnttXUlIxpNu2Mv
WyrJmmgUSdecmhJ5H43Nmpz2kTzeq2A4pZMXfM57FVys7bti63ivwrWJUo+y
Ft6rsKA0Xkjt4X0MJMYN3RsPK8T/AJJ5yso=
       "]]}, 
     {RGBColor[0.40082222609352647`, 0.5220066643438841, 0.85], PointSize[
       NCache[
        Rational[1, 360], 0.002777777777777778]], AbsoluteThickness[1.6], 
      PointBox[CompressedData["
1:eJxty39M1HUcx/HzigA5FZqChVAH4sDoOIRDEDpeAh4/Djg4OO6IIrFQWA1Q
wuOH0FdQfpalgsRg0AnTLDEk49f4GUPFTAQCOWVRiCIQG5Q0JYbVen/+67N9
9tnj89xLuC9ZGc/n8Xjx/9x/3/8/C972ntWVg5esvekDa6xsYm2cQDbCaZsU
8XN5CrIp2iy/WBd/TE3eCPEZ7pmd5TvkzUiuK7tvbvEueQuKbG35ear95Fdx
45Pr12bfSiTb4I7ggCrG+QPyVljOSKLNZ5PI2+BnwpU1NaeQ7VGV6Vty6eFB
8nZIArU/NAlSyY4QCd+/XGj9IVmE/uWBjlWHNLIYGQmbrq46HiY7Y+7mcrSl
rZa8A0FdNVtGBelkFxh17E1zWGR2xa6JHXzD3gyyBEs5I0YpxZlkNzjljFrX
KLLIOyEONpmPMTlCdkeP29lfRvuYPTD0fEC7/5Fs8i7o+R1chWsO2RMn/yi1
zvuV2QsbAjwzB7I/Ir+BA1PlFa7GHFmKhgGBe7Ga2RvC7w1vaGuZgf1nu3rK
HpE5YHlSkO4rOkp9N1KH7l3JP0zmduOWVa3oXhPrPhhranO/v8i6D8bhNJ0p
zqXuiweaghLzRDLni88zHRZddaz74fHk+eTkMdb9cOZloXzRNI/6Hmxcti6/
EETm9iBruu+z2lzWZXhYNWnb08y6DN9VvqC9NsO6P1IsFL9bWB2j7g9BU+pt
SyWZF4Bqbrve8SjrAWh8KnVPqGc9ENnDI7qOO6wHwszMWG1gcJx6EHyGspSl
zmQuCA+cxU/FsazL4X1ewnkVsC7HRanQvqOB9WCsaX5b0a5nPRivSebtUvj5
1EOw2fmRwZyIzIXA4dn0lORN1kMxEWfBDeezHooZ0XL92nrWFTCs6jI1H2Zd
gcL32uL6H7MeBp5u8Po6i4L/jDB4lBrmJnqQuTBojGRqgxhydxiaqmNTF7PJ
vHDkHfReu7OG7cMRunROONHO9uHY19d8KHic7cNx85ukJ4YrbK+Ey0Qrv+il
QtorIa0rtjRzI3NK/La1/Me9keRuJUo6vTY0ppF5EdAFyE45l7F9BEquX61M
v8L2ETARdN4NHGb7CEy3JssSFtk+EqNTGfoLZkW0j8SC1jC04HUyF4mfEzxq
5/zJ3ZH4ui4hqSWOzFOhMWJcvpDO9ir8dSvkxMgJtlfhW71L1lfn2F4FY7uP
e/7sZPsorGR8qu0aY/somJ/sbeAtsX0UAlrlRq7ri2kfhZbOKlncNjJPjdWQ
lk39UjLUsBnMLpjXkDk1Tl38aaXgENuroS8Jqv6yiO01uFxxWndXx/YamK7v
TVK3sb0G9bNuxy1us70GLw5LpfIpto+GaaeN2StPir3/BkaVuxk=
       "]]}, 
     {RGBColor[0.9728288904374106, 0.621644452187053, 0.07336199581899142], 
      PointSize[
       NCache[
        Rational[1, 360], 0.002777777777777778]], AbsoluteThickness[1.6], 
      PointBox[CompressedData["
1:eJxty39M1HUcx/EviGDyY0CAhJr8kLQURX7Jj+Rex4FwcMBxB8eRHRPpYMAx
EDl+yK8D5IcwkHJBIYPFj4EwfogVpgKXWhIFaFngKDYDVs6ZoCkVktV4f/7r
s3322ePz3MvuWJpEqctxnPLf+9/7/2eJNzPSlvXwlyVf+kCi0/PGh6G2vHVu
woSzRY37e+5kUygj+3T4SgHZAimxbglfPRORrTF/M/fBYpaUvA15Ud/cUCXI
ybaQPC8civBSkO3xufZLn+knR8k7sa3Gp+JX73jya/C07hHMpynJuyHpvfjb
19WJ5DcwsPHKOeOGJPJeyDMkJ5LqUsj7cKSgYWk8K5XsDH79p/vVkjTyAfyZ
GjTVciad7IKuWOXGqtTjZFeYX72QrgnIILtB8beLo9DyBNkdm+JejNfOMntg
ZrzlesW5TPJB2Op1vrxVpiZ74q+Y+ubthllkL3SLVENGw8ze6K21iIlVZZN9
MKEaaZVa55DfhNnmB3ORV5kPoWRt9+MReS7ZF8udfqkry8w8ZDp6Pf3w9Eky
8Lu8wfXR1rx1a4D2G8W1JufJHB9n8p4smHnkU+djLGc1LWSUzPkht8N6yoRf
QN0PznfCjsVqyZwAenMr+5t9CqkLYPF2sc1Pg2TOHwp/RfH7u4qo+yM1cUuD
YSOZC0BBqXFPib6GegCaBioPFPHI3GFMmLbs8M5m/TCG0ioUr/ayHgjeYr7e
2D3WAxEYwuuqsyqmHoRVz+qefcFkTRBShxwOavJYF0JYavyiv5t1IYKD+48I
77IejHBrGeYNSqgHw1zQcknHg8yFYE+uTZd5POshMMivzZiuZV0EvTsJxjGX
WRehqeek8OkC66F4/Z60ycy0lHoolJYKmyYfMhcGN50lh+RE1sOgmuos+fZd
1sOhe1Rd9ugy6+HY3PySuePPrIuh+shuYM3g1Lohxhb12VqRE1kjxo+TGy6t
RpC1YthcCeR5ZpG5CPwQXdWX3cj2ESjj6kdeGWb7CFw7VVoyO8f2Efis/vud
vVwZ7SV457Ze+aIdGRKcTpjeu8YnaySotnfafjOOrJWgqE1fm1vC9lIsDk8W
+LWxvRRWneH2Y9fZXgqTHtcwqwW2lyInYQaTG8ppH4kYdcyzPxzIiMStaHFR
ioCsicTZiduauDiyNhLlnmMuHYVsHwWJtlNY08j2UUjWHxmRf8L2Uej++P53
dVNsHwXzpITjs/fZXgbzVl21Wq+C9jKMDjrL7+4ga2S4pWw3CvIha2Vw8rVZ
no8ic9GI7xOft01n+2jIzPZ4JVexfTT62xsP+XawfTQCl97a5TjK9nJwE5OD
bTNsL0frNXGx4DHbyyG6sGLsZlhJezm+uJj5gaUDmYuBkY0i19u7kvcPp06y
HA==
       "]]}, 
     {RGBColor[0.736782672705901, 0.358, 0.5030266573755369], PointSize[
       NCache[
        Rational[1, 360], 0.002777777777777778]], AbsoluteThickness[1.6], 
      PointBox[CompressedData["
1:eJxty3lQ1GUcx/EfYBI6ECA7oFFSLAYCKnJtyMJnYWGRBRZ2l12wQGaJKxgu
OeVaD1InC4jRTIRkFxjcgHBElEgEFYa0gA4VzSGsJoiYsEYgpOkav89/PTPP
PPN6PvN+SZMjTzHmOC7l3/vf+//nUWDX8Ue2fMNAAH1Ay11N8G9aJT+LDW4G
x/ADGwOf2hKRH1iotwndyDaIb7z75pJEQLZDaYSX4jYviGwP/aFPDLk1YWQH
yG27XYVyGfllLDgcW2NvryDzscKLOfX8CRV5C3SJjf7WFnvIznBetUwWViSQ
tyJ2SXumOyeJ7IY0nx++37JJQ96GiehfNGafJpN3wFl/5MUBVQrZA2MT0amY
SyXvhLT3SYm8MJ3sCbtrv579ezmD7AWZbnzCNz+T7I317h82zz/MIvvAb1d4
XqYkm+yLnge6YnlLDlkAj9nzI/LyXPKrMOYbta9zzCP7Qe1+Rz0xwrwLDn3m
Csf0fLI/ZKfrBFPP7CMLkfck22q2iTkA60d4Pd2eBeRAjHtZX7s+zAxcDvJe
nVEWPrUW+GZudjxkmsyJ0JFiouEyimgXQXbp3febFshcEC6aufedyS+mPQij
GTWi5d/IXDAWOmsn8rNLaA/G2tKa6dYZMifGG+cSbqwmlNIuRoHBuPfKl2Qu
BIn19x1/DN5PewhqJzcU3+khc6GwqlryFPLLaA+FYZNJ9lt1ZE6Ch2U+vfv+
ZLsE1/tcayZTymkPQ3mGzoUbI2vDcKnRTDDmWUH7bnRLeppHTpK1u/Ftm2xd
1DLbw1Ex0B5TqKqkPRxfr/BEmh4yJ0X1DotGzqqKdilOVbQaBjPJXAS87meW
2Q2zPQJdOVn6wxZa2iMhvhlQYuJH1kbi8tzqUlYK26MQ2qUXDdSyPQqaqYaG
4X62y2Cqu2Bv/BPbZRCLbljKnjtAezTahs/qy3zJiMa5qqLttxLJ2miEfp4r
SK0mD0bjnY/FLq99xPoY+C3VlsxPsD4GGTbBSbcXWR+DLH9vp+mNB6mPQe53
+72ShWRODht+S0FBEhly1J/+q/LeQbJWjsdBFzsbW1gvh8ty2nuuI6xX4I8r
7bz+GdYrYG1TKdhsdoh6BYy2jw5Jt5IHFQhDvMcrUjKnRI95q+l4JhlKCMLr
piOPs16Jezdrpe4drFfimKg1SXOL9bG48Hhn3oOfWR+LAVunySrTw9TH4oj5
/MwePnkwFu1OsXVDIHMquPV/9fbc62SokPfZ6IJ1KetVOLl3ajz+BOtVSG8e
6k86z3o1JGNjaeZfsF6Njr0HnEpnWa/G0eR0xaxJNfVq1LgadzptJnNxWNE3
mBr5kRGH6er6xTYlWRuHu2uv/m6Rw/o4rHEt8lg8yvp4vJDNmxPrqgP/AYiB
tpo=
       "]]}, 
     {RGBColor[0.28026441037696703`, 0.715, 0.4292089322474965], PointSize[
       NCache[
        Rational[1, 360], 0.002777777777777778]], AbsoluteThickness[1.6], 
      PointBox[CompressedData["
1:eJxty39M1HUcx/HvGQE6RSKbsHXyUwIiIvl1/LzXIXDoyQF3cHcYBh6/Q34f
4KGch8AEFeaPcgopIKC5AWVQkKKRlagI6gQ3EEj5daVFSTAZBFTz/f2vz/bZ
Z4/Pa09LZYYkYRXDMAn/3v/e/z9/8vM8l/bEnjrkRx8oKnWb2rmpn2yI+I6w
0zYxC2RjfPi8NLFKaMJ/5Q3QKf/u5CmtyKZQq9scojqcyG/DsjhH36jPnWyB
ntfN26Z4fLIVeiLNXELfCyDboKxeduaLlWCyLdI0j+ucOWKyHQY6DNbOHAsn
O2B9LjOyaB9BdoTJ+5L81m4Z2Ql2McNZKYlRZGccyHm4qum1aPIHGMwwmMw7
9xF5CwYDQmoPV8WSXeBoILs7Nbab7ArPB2+Kf30njuyGG/dmnzYmx5Pdca/e
UoiGBLIHzFSBLq1DiWQemgx5LYZrk8mesNzwhKfmpZC9sD7YLb4k9mOyN1wt
e090lKSSfZD4jaz3ZcMesi/Cd4p9vLrSyH7oDE5cGRlIJ/OxwL1tUzSVQQbU
/AdG0erMV9YCG8dSx42XyIwA3JGbsXGaLNoFqFIff351icz4g1OedOFFQTbt
/jBXnemvmyMzW1GTUK3/V1oO7VtRFrfbfHSczARAxqlQJctVtAdgXmH8tO0W
mQmERnx0zpCXS3sgrhU6au40kpkgZIV4iLgmebQHIWcgyOmX/WRGCOmR4ZaF
SXYXghv91u2kkHzag1Gz7oeV/FayNhgRNmfLV5vupX0bkr3byu8UkLXbkCuu
tPz0Mbtvx0mTMmmTl5r27eD+rDyhOE1mRLCw/7riyiy7i2A49yTzSmgB7Tsw
DL0i6SWydgdm+5WLtZx9tIdA3bxmtl1B1oagb3PK9HQLu4tRcXXISqu3n3Yx
cnXd1UVRZCYUheOeUQ3N7B6KL/l7r11kCmkPw3rvyWWBhIwwfJYfI0w4T9aG
YcXed9T5BbkrDM84oZs7/TTUh6N67o0V5yNkhMPK66HX+UdkbTi+FSh2DVkc
oD4c3x/1MRtLITMSiM7d99ZdJkOCr2x/mxmfJ2slKOUptyjNtdRLoLxhd31Q
QGakmLCzadeLJ0OK7Ebz36dLyVophoPydacusr0U6+ydauZvsX0ESkasJ4yf
sX0ELusyJv9YU0R9BFqclpM175K7IuC5y597VkRmItGObAapZERCUSJ8JDnM
9pFYTLHV7/mc7SPRV+to2nGT7WXgWqfPuk+wvQzOqz2+S+IcpF6Gu77leWmb
yF0yjNb2pgZ6kxk56o8fejkkJ0OOkks+mQ4qtpfDOF1lFHiM7eUQWf806dbE
9gp8Un+9UtfN9grMZPw4Ix9newUubMy8X7nM9gocbK6L2WdWTH0U0puXBAau
xfx/AC8/uSg=
       "]]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
       NCache[
        Rational[1, 360], 0.002777777777777778]], AbsoluteThickness[1.6], 
      PointBox[CompressedData["
1:eJxty39M1HUcx/EviCnDAO1AQlgK0SEjp0AHAnIvfpyA/DzuF8cwEIJDIPkh
HsQvvwyGqBiS0EJYIV2hQAOntQOv4ySdphM1kB+FjhBpSuYR6A0iFq33/dd3
++y7x+f5eW1LyYlLM2UYJm31/Pv//0/PvyaXLboqYwLoApyEckx1XCCvx/am
vqB55zGyNc4d07rKvV+SOWhOe2NFFmjO/892sL8w/mJidjPZARneXTG+Z5zJ
W8HxulerWnInOyG95yw34ZUn+W0kxqikThxf8juYWixBbyLIrnic+kxVPBNM
doNzo4+iuTmU7A7TTu3HRfkR5B2o0ylGQlJjyDuhjv2kS3VJSN4F/uRne8Y1
IrIHuq0yv/e/LSF74kRyoWpiQkb2QqbTMNdJLye/hzlDblLtmkQyD+qs75Jy
bN4ne0P+MEku2JRM9sGfeYMuVnYHyLvRfv6HmntbUsi+GO7oXChyTCX7YV6Y
smLn+AHZHzxRPk9jn0beA17uTR7HNp0cgBb9lLDNUkHmQyw/U/euWQYZ8I9W
lv30iswCjlV+356cOUg9EA5d0/pdQ5nUA9EW0lkyo8miHoRPj1cvDXyZTT0I
HRvsf6s69iH1YNT9fP31NRmHqAejq1/t5SnIoR6ChXxvvwqrXOoheCteuf5K
MZkRQL5oEEinjV0A65Gx+uLIPOp7UT7Qx0ZfIrN70SMXjP1ql089FNdPFP3i
XkZmQ6HdODvMnTT2MAQYTv/4JPAw9TCsRI9sLWgjM+G482Ctu9akgHo4zLen
l32VRGb2Yd3f2WkuGmPfh9uVjiayzUeoR2A6o2etOI/MRuBor/4095axR2LU
7GTb4DYl9Uj8UWdfJCwiM1FQL6vSe+8YexSCrpksbnUqpB6NxzaXM7qPkNlo
pJe+Ka26aewxuGGZpD1nX0Q9BoUGD8OLLDITi1HzuwtRGjJioWppNf3c4iN6
HwvZ/EXuuJysi8VrHoVcs3YyIwTv6Sk3t3kyhOBnOtbuDyimvRBb9nfZna0h
61Z730PuyH0yEweOPj/cwb6E9nG44Rk+pDxAZuNQL8kKmGon6+JgYbvckvKc
zIigMNlgsPEopb0I69T3bR2UZHa1m78creol60ToUD+/LFsmM2JUZocdagwo
o70Yrkt33cJYMiuGOLbPkHeVrBPj1u+nGpZNymkvwZOaesFQIBkSNB3OFk2y
ZFYCTm1/lmU/WSfBuKNDqWTZuJdC/2hRO+BzlPZSfFMfZJtbQGalaHX5OqWi
m6yTghe+8+rGZ2RGBpvOpjHrTSztZeg/7vXXgx1kVoaK3eOPEiLIOhlmG1wn
2xVkJh5zXq2tmkrjPh4uSovAxi+M+3gIzivcPa8Y9/FwSz442DBi3MtRrX5a
fXGO5f8DWqq7dA==
       "]]}, 
     {RGBColor[0.880722, 0.611041, 0.142051], PointSize[
       NCache[
        Rational[1, 360], 0.002777777777777778]], AbsoluteThickness[1.6], 
      PointBox[CompressedData["
1:eJxty39M1HUcx/EvDIWEkJBdyJjkBUryowP5/ete/D5AjrvjfokgB0SnYAKC
iCdwXx04JSgaiTAZQoA0DssCB8OGR2UzbIDyS5AtG2pBFlEwoCSq8b7/+m6f
fff4PD+v3ek5kkxjhmEy/z3//f//+41fk9hjvKG1DqELFE3nxua9WkI2w/kl
uUXK3S6yFerZOzEcTJBtMCqtOLatdYFsC5X23ZFZrhF/0/Y4Yqq9LnTaTn4N
nzfeFQdxdpK5GLi8vJR3nkt2hJ9S8sto2xvkPZBabLnc/oxHdkb7hbrQz3K8
yfsg1FiZcVMDyK4wW34gbrnGJ7ujuVh9sr0hjMyDbdN36f3lkWQPKAqGfKou
CsieaFl81D/WEkfeDzu3qO5vRoRkLwyZmsdqtorJ3uiNuFL/cYeE7IOsarv5
vEQp2Rf7tsQ8zt2Qkf2gs+3sK72uIPtjyVEapUs+SA6A2iJjAxaHyIEY9IlQ
3bmVTA4C9+xY509Zh8nBGEs75dxqoSKHoOf5kr/jrMF8iHnRLS29aWQgNntX
zu+V6ZtmAePHRZo/UjOoh0KUpFliPd6iHoqyNuvnWqNM6mEI9pY0zg2T2TAI
UuqcrjW8TT0cFzNU0iq1mno4jDqU5Wd5R6hHYEEluKleIbMR6F49bO7yxVHq
kZgr03t+WZpFPRK1FfGBfvxs6lGoHV/hdKyT2SgYc1SHPPuOUY9Gz6DDremC
d6hHY2HmnqLR7Th1AfLf3HpD+4TMChDRPNdUWZ9DPQZ+5sHTaXtyqccg137K
21RLZmJR0bmjtmPC0GPx5ObXCXFuedTjUOn8ldfiOTIbB241/6/WSUM/gP6J
vZNHXU5QP4BQbwk3rJTMxGM8zXXeY8TQ49Gskq9jdz51IfYKG65q88isEBNV
VvlGA4aegJRXvk8d315APQGOwvGX1lPIjAi+5jqzXB0ZItxeXSh3WDW8F0G3
y//ERvjJTetF6LJj8ra9T2bE+PCBnSWmyBAj1SRY1sYtpL0YIy+yTUKyyXox
0kXqYtMuMiPBzpkXhUZ/kiHBWpLD6zycor0EK1n5mkvlZL0E7ROhgx6DZCYR
vyafcbWwLKJ9In78yGlkv5jMJiKi5gqvp4asT0TfBm+laZzMSBEdzgyucE7T
XoqfH62fHlCQWSncraaqTOrIeim6r3bobk+SGRkk3w4tznM0tJchNVXgWywj
szIUBo9y1TVkvQzLkdY3mkbIjByfZA8HOr18hvZy8CV2E2sCMitHreV7cpcy
sl6OT92OPx3sJzMKhBvZPJ1dNewV8BExaRrPYtorcIkXZP9BNlmvQMDkwzX3
VjKjxEOndlHSDBlKVN/X/bDDpoT2SsxqV4XJcWS9En9r7w17nSMzB3G/ZOhZ
fW8J/x+6jLJL
       "]]}, 
     {RGBColor[0.560181, 0.691569, 0.194885], PointSize[
       NCache[
        Rational[1, 360], 0.002777777777777778]], AbsoluteThickness[1.6], 
      PointBox[CompressedData["
1:eJxty3lQ1GUcx/FF5HCRI2NaBIpDAmblDBeF3OUDuNywByyHYnJfxqXcNfAL
5QpBgRECCgszzS0sYk1OtxFIG5YCBGx0hjKBoJQjoRl0tBq+/tcz88wzr+c9
H4u4TGniFhaLlfjv/e/9/7PsUTc0y92VNcGnD5hyVBVP24MFm9SGc9aNNVdR
DdkAWrn5j7P5CrIhLpd6qmvajZONsL/MxaxZPkc2RX1HfYWR1t9kcyQqrOXc
oK0em7aEcVfyoy3WBmQrcArvX3dQccjWuDhaatb4vjnZFuMLbNmfa6+TuViw
UTu+ZGJHtsP4al/yTJ4z2QEf+7DH7tjzyE7oazubYrzbjeyMgpT+T2yT+eQ3
8N12n97ahyC7IOFVvUoJvMl78N5rzcuLl4RkHsoelbSft/Iju2LeL2Pk4VcB
5L1o09IZlgUGk/chd11bs2lFRHZD0kpX6JRYQnaHQmU2uPiFlPwmBh+EaoRs
DyPvR7VIrJmWISPz0WI9WT4wHk4WoPaPysPD+yLJHnAxfStj5VwUGejR3VvS
q3Vo0wyg18o92ZMZTd0TTjt+iDozfZi6J6wHz1fOCo5Q98KxdRvPXmkMdS98
Lo3yOqkRS90bkVdK3eTfkhlvNL8k0NdNjaN+APLWGYuqnfHUD2B16lag2i0y
S4hTHQO+0fkJ1IVw9eLpVFklUveBGbeNU/oTmfHBUlrqN/7vJFH3RVO6jeV9
q2TqvliujUn3U5FZftjIaxLl56RQ94Oagc6JdONU6v4wjt2mxr1OZvyxsyeo
7NO4NOoBSCtPshzdepR6AK4ldZq3XCCzAjFrm7CuLnybeiDuTjpG6f5GZgXB
Kieh4lpJOvUgOHUZPtEwyaAejJH4z26vd5GZYGis/eJSG5xJPQSsD15JnXxA
ZkJgUnM5OYOfRV0EnU6D/rsVZEaE76s6fLvHXnQxdtQOZGubZG8aYrCv3D49
FE9mxOg5/ZHbopysFKPtmepS1l9klgRz3G59mfsx2ktQ5HjPoZEhMxIEN3zZ
uWeYrJQg8FmDvZPOcdpLkVYtklSIyJCCPxfi6N5AZqQYqjdq9J8iK6Xob3kq
Vxjl0D4URVGz1SUHyQgFd+PJvLyVzISi7GoX2+seWRmKD4sn0v1Nc2kfhu6j
Tvk3D5ERhjJeashgC5kJgzqnWc/rZ7IyDEN1wzwhJ4/2MvQ3FV9UhZEhw0T5
WNGdOjIjw7zFrlMxo2SlDAqtidgj7Hzah0PB5zA/CskIx4Yg/GoHQ2bCIWjf
2Pa8h6wMR5s978Lw4xf7CBT/WvOyrkMB7SNwhj/zfDqJzESAtSS02X2OrIzA
1yML0expMisSNtFng4r0CmkfidqbfQeLhWQmEgEj4mKjd8nKSPD1C4oCOsms
KNwws1w1/L3Q4x/8Lqv4
       "]]}, 
     {RGBColor[0.922526, 0.385626, 0.209179], PointSize[
       NCache[
        Rational[1, 360], 0.002777777777777778]], AbsoluteThickness[1.6], 
      PointBox[CompressedData["
1:eJxty3lQ1GUcx/FfBIQQjhiHcYStBrIDSBwS535gWWCFBXbZCxUhYFFOEcOA
BH4mYQM43AWIObAcHmWITseMwibHKMIEDFDOGIjQlJVyGXEMdAxf/+uZeeaZ
1/Oez5txxyQqLYZhVP/e/97/P3O8OjNfF7fjlT70gfT21bqRRAvfTeqhaKbO
sa8/nrwN7rlWAz7VlWRjCP7QGcvxvkHegb9+4vT3DdwnW6KCv4U3cWuSvBPB
y3ZrDj3PyBz8qnq8Iy1vlbwbwlcFG9wJbd6mbfDyw9wbYTe3kvegYKukJvyo
CZmLvCah3lStJdkeuYuXe2MyOWRHlA3/UGm+05bshK/lw9aiMHvy21B+xF2P
W3UiO8Ns8rP5fB1XsgviRzlCzwB3sit+XjeMS+rwJLvBfznHjAn1Je+D8XQC
p0TXj+yO6Upfv9llf/I7ePDBsJVsLYDsgZRYddmGQRDZEw57H30rshOSvWBX
Iuq5Lw4he6OqxbndoVBE9oGrSXGLuCuc7IuOQXmP6UtiMg+HrYtMJt6SkIHv
zxprFYgiN80CexqddAvfl1L3g/7jH0POqGXU/aAei2EshuXU/dGT/sh08W8F
dX+s5x+Wde6Nos7Hn4NtZ11iD1DnQ518yUC/4iD1AMR9Mz6w9t0h6gEI8dbX
6luIpi7AlW23arm7YqgLoL6eeiTHLpZ6INiq+uoVDZkNhF6aIkFX+S71IIyU
P/+q+hmZDQL3qbCmvjCOejDU3aUNhubx1IPxhof7gZlrZEaI/t/sdc34CdSF
uNp4jnthnMzsRxBfqyQlSUV9P0zO2YRnrZGZEExUvR78ZWki9RCMWjCNRlZH
qIfiysXzJp9+TmZDUZ+6bufldZS6CF8YCqdX7pJZEWwXDjoNyZKohyH0kCHn
9hSZDYPghGVWd2oy9XAM1WQmP1kis+E4jUXsY1OoR8BBoNN5TS9104iAhfoU
N7KczEbApvmhs7VZ2qY1EWgo1WwYXCAzYuzuTvp4Oyed9mJkN7dbOrSSWTE6
S+64Ku2O0V4MEXp4FVfJjASnCptqk00zaC8B+L+0lMvJrASZovE5j0/IGgmq
5/vuqcbITCSaJFUXXzM+TvtIKKVLT/kSMhuJspmxB8tlZE0kpNvbrrsNkhkp
il1tbTe2ZNJeiroOVacskMxKMTZXNM77kKyRYqjRqLzrNpmRoXcxemZ8+cVe
ht+dMhyLXE7QXoZS72C3gTSyRobyM0+iWtvIjBwppUt+RlNkyHF56Ka2vvl7
tJejouCuS5mErJFDNVSW31hMZhSob5zN498hQ4EFo96M7JUXewUuxc97852y
aK/AYNvp7NZEMqPE+ZmI580NZCihPVub7zdCZpUQzIgU+a+cpL0S97p2SaK9
yUwUmjSjE5MZJ3n/AIvvs+w=
       "]]}, 
     {RGBColor[0.528488, 0.470624, 0.701351], PointSize[
       NCache[
        Rational[1, 360], 0.002777777777777778]], AbsoluteThickness[1.6], 
      PointBox[CompressedData["
1:eJxty3lM02ccx/EOmTAugcksoCC4AboGucEC9sNRWqDQ0huqICig3MrYgRh+
BCQoCed0CRLCphtmcuh0o/4jHeAKzAM2YKAYzKwCSgTdWMYYbC58/W9P8suT
1+/9fFzS8qXpRiwWK/3V99/9/2eR92mNkJ34UBxKP5D55YJZkecM2RQ7Nt4p
tK8O2rtuaxQ3+A+3/ZFL3owt01F2lfcbyGw4Zvbaemm7yFvRM+ads3a0n7wd
8olRt0LDGNkVJ2pKHW2PG8jv4mDsRcsA8QuyG86Wtxv7WK6QPaDlFqU4T2/g
rXsXktJfzjYNmJM56BUmxN9rsyV7onj57PUXwWyyF5wNf/ada3Eie+NeV99a
+WNXsg9Cr3bZ7XrgRvbF5V4Z38nnfbIfFofK+m9P7yb7Q+U5NddV4EMOQMd4
zLWnbH9yIOQNPectngSSg3BJ7DJRMcYl78HGtA/6bxpCyVxUtJR+dLEK5GAY
RjPfS+WEk0Ow2nehKHcqghyKtwat3uj/jE/ei+1P7Fry9wvIPIx1Ct+p4kST
gbu1I3Uc49h1M4B1qrHfyUci6mGob1Qu/TAYTz0MmR5Pv7XXSKiH47b7rK+F
PIF6OL4fMHlwWCylHgErTXnTI5GMegTCmcIZX5GceiQ6z1j+/Xacgnokbhxn
jUOspM6HsmSytFiqos6H+9im2QqlmnoUdBndJTs1idSjcLnNdS7oQBJ1Ae42
sEOr0zXUBTjdaWS7lrWPuhB6u+fsYwX7qQuh0d8JGSpKph6NoH/4HvPFKdSj
oTZ09k7zDlCPQW34j7N2vWQmBpx2TpN5ZCr1WFi7V85dvUlmYvFhdZbJBkEa
dREKguoHn+vJjAi1Uy1JecKD1OOwxUF865MBMhOHlH1RRmbCQ9TjIVhULrD1
ZCYeRoUsfMFPpy7GZsHnU+f7yIwYw76ZzdvCMqhLYKHrXtl0gwwJ2sPqWou5
mfRegq/lDgrNd2SdBOJlw+8d3odpn4BwU/+due1kJODxtda4RrcjtE9As0cJ
17GVrEsAL19zkmWfRXspChoMVrx6MqQYYoJGfzLNpr0UzcGjXG0pWSfF9bkO
h/klMkuGGP1EXXZ2Du1lGD5TpvZ7SGZkMPnLrIEvz6W9DPmTyeatejJLjpE8
ZwOfm0d7Oco8Apf2tJMZOdgjHx8p3ZZPezlElZpz9jVklgJ1t7pOma+RoUCs
1rHqUkAB7RXgXfEMXssl6xRYmX/TdfUCmaXEoWSF9qv7ZCiRwZTbLtscpb0S
MXHBOS8FZJ0SO/qcr9SfILNU0Gb9Mjz+DRkqPPP6ual35vVehZzJVaFy6zHa
q9Bdl7S7UUJmqVF+eqCnuIIMNaQ2C41WWjKjRn3ZbyGSZ6/3r97bVLuEORXS
PhHx7TElv0oKef8CjVaw6w==
       "]]}, 
     {RGBColor[0.772079, 0.431554, 0.102387], PointSize[
       NCache[
        Rational[1, 360], 0.002777777777777778]], AbsoluteThickness[1.6], 
      PointBox[CompressedData["
1:eJxty3tMU2ccxvGuSEInIAJjjDlwFRABlUuVi9A+tJRbrW0P5VqRi+CQO8IS
IMiOogw2Lh0wREnYzIguEDLDYIAZ7iyIqxInsE3iTKNmCF5wE4l0IJtz4bf/
dpI3J5/3+z7vZhQyWXwej5f16vz7///vqcRmytGkjxCE0gVMYwc8Gjb2kS0w
8VeZ53VnS/GabVC6tHnCMSuCbI9upvO1Qr9isiNErvx+0ayevAmHuId3ZH1f
kjdDfFg27s6MkIUoMOzInXlwneyKTLuVpKO7bpPdob+Tx9w4N0v2ANdj9mC4
dYHsidDA44Nt48tkbwRMuzCTtnzJmnegc6dT/pN0C7IPStbp+APGDWRfzBob
Vzi5PdkPszJ3jfPut8j+mA7WO7RfciaLcPnPgjdFBULyLqyvW2Kmx9zIu5Gb
52z368Ft5ACIyozvN8q3kwOxQX1MaNbvQw7CS0Vt+cYZP3IwvDzG22J9d5H3
wMlKUO56JoAcgpT0jrF7m4LJoTC3T1tdHAwhi8FW+p7+6bCELIGUeSQ/4RhG
Bs5vz+bb1UjXzAICl8LAmVUZ9TCIHBYMiko59TBsvSiM6zKLpC7FD/dEH6ma
o6hLsXyl5/Y3W2Ooy/A8dWhRMaqgLsNSx0DVh5lK6uEQi451z72uoh6Olfmg
QVOymrocQ9zUthY/DXU5uptyMiwtGeoRqBVz9d5zZDYCFm9Y93KjsdQjodti
u//MWS31SOROKUab2DjqUTBeK/65Ii2eehRaBXW5gWEJ1KPRdVH/93lhIvVo
OMnd8nvWJVGPgfLz0nD3OTIbA5NReWX1ajJ1BUJsnzXb9eqoK/C0r9ZXrd9P
fS/EJ3RTp0tSqO9FXd9I5634A9SVKHlR1rASlEpdCenMzKlS6zTq+xAQdHT6
6gdkdh/Oinzsnz/9r6vwuELa9Ud6OnUVUv1tVP1TZJ4aLzsWrSWyjDVDjcqJ
nNL6r8msGr8p9y60bzm4Zk4NQ9W6pLQWMk8Dr7J0g5GfSXsNqh+tGtcfIbMa
BO/Jd7h/l8xpkF297JKpyqI9A4HIar56hAwGmY1vn5Z4HaI9g1SZQ0VzO5lj
sOzBepWZv0f7WPSaXWiaLyYjFl+MX7r52EhmY6Fo9eKORGfTPhYTDvyHVf1k
nhYd2v4Za5fDtNei3uqrTcI6MqvFiOn7U0PPyJwWNXmbJ6d0ObSPw33BcE3x
ZTLiEHTNLuVT71zax+FyTnmVuJXMxeGXBo7Je0HmxSP0plvyOxl5tI9H24/f
hqsMZDYecn2j5uX2fNq/en/B45ZnC5mXAIN/6a0bJjISUPTZivSJroD2Cajf
+fHd49+RuQSMpmdbfiIspH0iHJcGWMeTZCRi2dCmcpojs4lIGU65r3Aton0i
HmtDvK5qybwkzE/+fs78ZJHkH+P9sX4=
       "]]}, 
     {RGBColor[0.363898, 0.618501, 0.782349], PointSize[
       NCache[
        Rational[1, 360], 0.002777777777777778]], AbsoluteThickness[1.6], 
      PointBox[CompressedData["
1:eJxty30sHHYcx/GjVmaVdCZ0HrKy40ar9VDm6dynHs8d7pk7qh5a9MY66/og
Nul1qBjxkFlpqoqOoJt21HXbdXN1qKmVmaLVEpqyInrrlqAyXRffP/dLfvnl
9XvnY5/ykTjVkMFgpL66/73/f/Scf5SlVZaq7gD6QJymOs/AJoe9SRM0ufxU
h+VH5O1IaHZTXnN9J3DTFmgKZN4sj4wi70DfTIbb/HQW2RbNZS5c6bYS8k48
lXNLzhc0kB1QU9vvW9h6nczE+F9/F1Tye8hOOCR/4Tm2bYT8HpgV0azgtkdk
FwxvCIub5+fIu9FUfsG6rl9P3oPIvnh9evkK2Q26spBJ9cJLsjsYwRe3bF01
4mzaA8Vmys4375uSPSGYyGuyH9pO3oduq7mbokYLshfOHh9zynq2g+yNdW99
6+g3duT38YVJYx7jqD3ZB4pCs2vJbCbZF4KawSrnYBbZD8OOl3nqXBeyPzJs
Ph7zWnQlB6BN3Md40ONGZuOXjYK5L694kANR35Ks7WreR+aAP7KqkGq8yUB8
kVVhxKzPplWAh6dfQLWtP/X9uJNUEe+vZFPfD818sdT9Nod6EDQTr/X+bL2f
ehBW3Nh3KhVB1IOxZ3BGcvlSMPVXPlGzfnIphHoIltWGb9VxwqiH4IyllV97
dTj1UDzh3XYIWeFSD0U0z7XoWRyPehg6HKpyRDo+9TCcKnXa+oZbFPVwFJs4
7u2ui6YejtoJjaDCVEidi8QYyfjRPrKKi/nsbxdH80TUI2Bj99CiPkhMPQKf
lC+ttxtKqPMgSH+8a0lHVvHAHl24tPeslDof/K86pMkRMup87Jo1ZKWZxVCP
xKSkh8EcIasi8XSm2PLzqljqUSjZqH95JEFOPQq9ywFt3e8qqEeDJT2dmrNA
VkWjd7K4/7Pv4qgLYKUYMv8+O566APdaehJscYC6EP06I/UF44RNQwiNXvyb
8xBZJURF+8BxzbmDm9YKsXNtWRd6MJH2IqgdY6enzJNoL8LzJdbrJSfJKhES
194+z3xA1oowEGb3awM7mfZi+FSe3mJQT4YY949N3/I1SqG9GA/H+erwdLJW
DJbZp12OA2SGBEUzQ8/v7j5Eewl0Z7JrA8vIKgk4CVOKrD/JWgl+qKtxTpIc
pr0U1jJRvWknGVK4Hw7SZ1qm0l4KwXrReP4pslYKsdncOeEEmSFDbv7jsbs+
abSXgduSmb9RTVbJUCR7UTO1StbKYJo9vPqhPJ32MXiivG535QYZMfC6NelY
aXmE9jEI6UjrdzpB1sbgx06HgqTfyYxYMNuN/wh0V9I+Fr5pC4NdpWRVLNZb
p/JnFsnaWIQd0402cD+gvRz3ylNmDRvJkMMeV1kGBhm0l2PNmKe8eICslSO3
MPjr8RtkhgLjG0FrV80zOf8CCx697A==
       "]]}, 
     {RGBColor[1, 0.75, 0], PointSize[
       NCache[
        Rational[1, 360], 0.002777777777777778]], AbsoluteThickness[1.6], 
      PointBox[CompressedData["
1:eJxt0WtQVHUcxvGD4gKRBgGtQBo4Ci4gl7XlIiw83JbrssteAQEVZDfExBli
kGpyBWGCmAxlS5BLQQwMidwqCkVWoyDSACnAjAA1AgRiGESKimz4vezM/OfM
53z/z6tjm5QuSdnEMEzK0/Pf+/+fRT/rLI5Lh022D33AzhvOL5QW+/M3aAg2
L8Om5Voj2QQXlrTd+4TLZHPcibTP4artfTe8HckGf3lbNInIL6L4n7L21wxP
kG1Q7e95c/SlfPIulDFXP000u0TejfUG9/6anstkO8w+vtddmXqVvBdHmqzq
7BZ6yA4YqJ/Kszg1RHaC6KyEd31qjOwMY82HLU4PfiW7gn9HM9HVs0B2Q0Zz
Y7fPo2UyF82FJgezKtfI+1H9tfSMXa+e34ZfRtvb2sIuNYvMQyp7izKvzZjs
jpWKtuMVIyZkD7TvnPUtcDYne6Lv4eWSuV/YZC8Ure1wOzdtTT6AV5/Z/J5i
jw3ZG7WKdzr0c3aRffB6tsVHGqM9ZD4859mp/R32ZF8UbHtTOFziQPbDDOvi
88nv7yMDfu0qe8tDrhvWAM3C3qbsLVzq/rAsqKqt7dxP3R8DMzfGHuXzqAeA
y59kSg97UA+AqMB0YTXMi3ogfnquzDwmwJt6IELZqnL9MD71IBS1OhqLEvyo
B+FuxDg/uAvUg2F9Qq1kDftTD4aBOM70g6UA6gJwcl0da82DqAvAuytzmfAO
ph4CTtrKwh9qAfUQGK+YmNZdDKEeiuXb3W9U3Q6lHop4t+yMSlY49TC4jGXk
JgVGUA/DtkmPhMbcSOrhKDR7tiWwR0g9HIzt7+NzW0XUI8BS1QR96SimHoG0
YsZiYJDMRKKhwOIt2+xo6pHQG7xuoLWVUBdC/8m37mbfkTVCcBuStHmZUupR
KOSWtA3byKhHoc+8krN0i8yIIHbxqO/OllMX4djJue0+9grqYlw5vt4Z8iMZ
YiSlRbiP5irpvhiCxVPycW7MhnViVCFrRHSfzERjsbTfcMf5WNpHw/6+45kD
AXG0j8ZqlHT90hJZF42c0/EqXs1B2ksQXsf//k9pPO0leKXG9fyEfgLtJUif
ESjufUbWSTDbbL51QpVIeylaPlavP2Afor0UF3hxgz/3kjVSTFaeC57wOUx7
KXaf/W00QEtmZOAYqT4vnidDhr6Jo0O9wUdoL8Oadeu7DyvIOhmEJiebJh+T
GTmKnjQldgqTaC8HJ2vVKrOWrJHDdbG8mvU3WSfH6tTUcLosmfYKxFoYVlz5
hAwF3DLrb+o2HaW9Anps7XxNLFmnePq/rpXLm8mMEkvTod5DrBTaK7G6mQ+r
BLJGiW9MrKL2tpF1Sjik+QjWDFW0j0F31oqwOJGMGPyQv3hruo2sicHIV6eP
MUZq2sfAKc/JcCSBzMTCyzLli7RWtd+/KNyvHQ==
       "]]}, 
     {RGBColor[0.647624, 0.37816, 0.614037], PointSize[
       NCache[
        Rational[1, 360], 0.002777777777777778]], AbsoluteThickness[1.6], 
      PointBox[CompressedData["
1:eJxty3lQ1GUcx/GFQkiaQETOdpT7WIpTNjmWz+6ysCywwN6ccRORQ6DQiAlL
iKiBSBISh5ZNmCMhkjEMccUxQkVxxIAF5BQpYikosFkg1fD9s9/MM795Pe/n
Y5WcLUnTZjAYaf+e//7//y0HMF32fTA46upHF9DXC76jb7XDf5t6aFYPt8xf
P0o2RLHpmdPHJ4fJxuh32Hh2vEaLs20zuOaLcmafdyG/iKwSj1JNmpi8Dzav
r+/9Zmcm2RpVVzsKH8yoybZospLPNRw8R7ZH1jNDrB9nPyY7Iv937Xb7Q21k
Z9S7T9uXtveSXSA2Nbir9d4I+WUUjVQuSCsmyW4QpY6d+ap2luyOjdJbDzXW
C2QPuOXHNXUfvk/2hOrNxKSdXo/IXvCd1k3LrdSQ98P4kcLC+adNsjeKPukw
ulalHbBtNmrudBaudOwgv4LeI6ZCxwx98gEENbL4pyIMyT44Jxoc93HfTfbF
9amBVbNoE7IfLM6W+bjcNCf7Q2sqXWh1lEnmIMbTr9y5cx85AMsJxReXZ6zJ
wJp5bLXU3G7baqD6wXpzc4EDdS6a73XFcTecqHNxafRKelCjC3UeTsZeHvol
zpU6D5at2h7mTHfqfJT3Wspt6zyo85Fd8DjX3M6LeiAq+82cjnXvpx6IfhHz
24lkNnUBuEseyw3GB6gLoMkdG4+f8KEeBFZw4Rfn6/2oB6EgfVExms2hHowW
1U0O1wHUg+EnSo27YMmlLsSqOGNXvzGPuhC29z/bzDHiUw9B+UNOcZ5xIPUQ
tC14TbxvIaAuwtPUWzoXbIOoi2Bb/bNerEcw9VCMCQ4X1fOF1ENhZHClxlUV
Qj0MtYyR+cVsEfUwDJTIOXWnQ6mHQzN38Inpp2HUw8E7+VEPezicuhhJt/e0
ji2JqYvx+dLWjTndSOoRiOEn62bWk9URWNW65vanaxT1SIzxh9aODJERCbFs
8oX5WAm9j4TF7gzHPY/JfZEQNZV9b/iulPZRMLrhHzZgI6N9FBICp/P2dpPV
UXg7i11hppTTPgruPd22l1bIDAkyT/WatJYraC+BcPLicW9HJe0lYJ5InXYa
JPdJ0B6v6CtMVNFeCoFow8d5kwwp8i5XV1rVRdNeinXWU3kMO4b2Uvy14nTs
6x/IDBlGfTkxr+XG0l4GfV54l7NhHO1lSJn4dVOvhdwnQ/xcicHfofG0l2Ox
tLbgyT0y5NB4qeI3yxJoL8d5t7R4hv2rtJcji/1H5cYAmaGAwKTfZd0tkfYK
3I56ye63IrJaAVbqVOHwd+Q+BVwXg99pZCbRXokea++cpDfIUELguVWx60uy
Wom1Q/VOV59Lpr0SDToWbSwVmaGCYcpc19kmMlTolszpz6yS1Sp0vrVcucVL
ob0KAzZGmTpVZEY0Wj70X7g7nxLwDyadroc=
       "]]}, 
     {RGBColor[0.571589, 0.586483, 0.], PointSize[
       NCache[
        Rational[1, 360], 0.002777777777777778]], AbsoluteThickness[1.6], 
      PointBox[CompressedData["
1:eJxt0X9Q03Ucx3EYd6joyegg5VcMmoDx+8do/NyL32yDDcZ+ANoGEyK6m78w
CggYh+SpZcoiuMBDUnDpMkoNoqTRwKJQEa/iOJUOhZGYxhDw9KQft3f/9b37
3Pce3+fn9dfXW71LUsKwsbEp+ef8+/7/50/eVLCpdGp8OpY+ABFjwUshP8ZZ
uRbjIc4lppSMeKuZMDwU1Z9sayc7g+HqLup4NEHejJoE5fRK9ZoEqz2gNduP
3fYLIrMQUPsguvGegOwDw9aUyfbFHWQ2uirWfKGxqyT7wqJ8cGtj/WGyPy49
PVCxM66N/BJKuvu8J4b15ECcbBjOqWVcJAdDNSm/yrlmJIeigmNQvNA+Qg5D
qCDxReWX4+RwMJLUfTfUk+QIbHJkedxfN02OhNdSVFm83RyZgyr3LrUh+iE5
ChfNHcsVdxbJL8O2NtN94bfHZC5uBzWx4zpWydGQ6mNDXtcxeFbHoErTxCvk
2ZNj8X5B3AWR3IEch2LdaY1iciM5HieE6z1rZp3ICfj568qPjrY4k3nQb7mU
1aLdxPvv9zbLdB2NnW5WawFJaHqE2xNP6omwS2pztAyxqCdCXNbPYet9qCch
dq/3oeRuNvUkjHECb04N+FJPRjsz3LZ6wZ96MnStu/84FB9APQWGPf2nqz8O
op6CUcsG7YRjKPVUhPpG/JVcEEY9FQPswbWBPeHU09BR6bguximSehr2Dupa
XWo41NMxNn95uXgxino6hG9X6a6Uc6lnICCyuOvRs2jqGWB7HR6oOxZLnY/7
wh6hS3A8dT7iqszL228kUBfg1MjQ4zqAugAuSzM6qXsidSHsr5cbGE/IWiGG
txYdLLqZRD0Tcw6OYv53ydQzkdypX2k6m0I9C+fCPsjd3JpKPQua+W7mhQNp
1EVw//0zU2JVOnURWrv7F47vyqAuhsZ1wbW7lE9djJhXTSauWkA9G2dm7+g4
KqHVyMZztzaU1Cgz6X42NFdU2yyqLKuN2Viccpt7c4eI9jmY9a3ps7wmpn0O
LNJ3+GxuNu1zYDpa8XzPN2RjDjqPONQzk3JoL0H+WUtb9A9kSKBKHBn2Ekto
L8GzqLBTvb+QjRI4X51kLStzaZ+Lc6z50jEzGbn4XPOuOXaPlPa5WC2Lyg5+
SjbmYme/8sPjjTLaS9F/TLZSx5TTXopm8YztaBtZKwWTadP5lp+C9lI0lHy6
peY82UYGXhNHdJ2XR3sZhoYG+ZpRslYG+2/39/Lz82kvA+sn/xOqWbKNHN7X
fMv05QW0l+P7aieTp+022svRdTCj+asjZKMcOp+5e294bKe9AsMtqTOZZ8hQ
4DyX28vlvkJ7Barvjn8ScZlsVGBfVI8fV6qkfR5C5L+OYJqMPOgYReqM3Sra
52G93mwnWCUb85C6z7OBlVZI+3zcdfTf7/xeIe9vSgSseA==
       "]]}, 
     {RGBColor[0.915, 0.3325, 0.2125], PointSize[
       NCache[
        Rational[1, 360], 0.002777777777777778]], AbsoluteThickness[1.6], 
      PointBox[CompressedData["
1:eJxty3lM02ccx/HasNDQBRjHBDcHKofIKWcpRz/chQItvZFrg7ExUS53OB2I
bOFQUFM5nGIk2BkWJkJlWkClMygIU8OighLYOCqCOnGQTXSWbeH7537Jk19e
z/v5bMjMF2czGQxG9r/nv///fwu8K6YtRVGztUF0geWllkc3A2qCV8lChU1M
i9rSKmTV5jjN/m1ziks+2QovHnAz3a62k23w9w9rNgnVU+R3UbL/mn7bYZPQ
VdvjUvlYmmeFK3kjrksGngnKo8kOYM00Hlv8KZ3shLfHz698wCkibwYnQ+h8
M/Jr8hYwspx4kloV2Q2Pm+vzer5tInvgOV/UlXqvleyFYq5Hj7vdBfJWSD99
ptIO6cjeuBOTd3ZP+QDZB/UVo8VlwmGyLy4fdDDL6h4h+0Gn2DDbqvmV7A+V
tPVGm2aGHACnhXVfflUyT+ZgD0dtFdqyQA6E5sSsWerJJTIXP2fk5nc6LZOD
sEtU/rpQYCAHY3uzoVbPYvJWHYLh13uZZbw3yKGo2znJ6x5ikXnQVzb4xJ57
kwxUeXTV9X5mvupSwPyP8Ca1zoJ6GJ4+WC5p5FhTD0MtK+fxtfG11MNhY1rj
aNu+jno4vJwNmbnn1lOPQKL+llnXTnvqEZifZm+Ztt1IPRLG+1IHFsc2UY9E
sYPb56fOO1KPwo0R+/tHmpypR0EXe2Hqk2YX6tHQHrg70ad1pR4N7sOkj/2m
3anH4JQdX60296Ieg5e6Pk1k4FbqfPy4mCAOyfWmzkewZ06h8IwP9VhMZq5Z
4M77Uo9Fp7vKpNffn3ocjh42unj8YAD1OCQ6sRarH3GoC+CXm8KUJXCpC8AO
1B7XdAVRj8c3XVpDtnsI9XiMjh419WoJpZ4AWW+j65wVqCegYJdcZXyfzEiE
IPr6kLQpjHoi2Gfujmu2h1MXwvtkmtCIE0FdCJfvZb5urEjqIqiKC4JNx8gQ
QVvY0XeoPYrei2BicW9OVRm9ap0I/L/YDYysGNonwS4orPoKj0/7JLTYXk3u
fC+W9kloZO8VD66QdUk4a23YPTcVR3sxnia67XjVL6C9GDYTdor5tnjai6Gv
fV/f1JBAezFG7Cu5JmWJtJfgncncJ2/lCWkvwZNf2laG3UW0l6Bx0LhI/h1Z
J4Emraynen0S7aVQqvj7c+vJkKJgIr15zkxMeykuZtQEG6rIOikG7HM0TUYS
2svgfiusY2AfGTJ0Gyz8816RS2XQWh87UvWFlPYyzA8OZ1kukRlyfMT0PG1U
KKO9HHcsnarlv5NL5Yjp7mpk7pDTXo5ex6BK5jyZoYAhWe4mylHQXoHbL9oq
9Q/JpQqsPdHffSlbSXsFKi/XGW7PkBlKCA4d0Nh+mEx7JRZfstNqp8mlSmx8
3t/BzdpGeyV2p3vUG0+TGcnw1egc/sxM4f0DWYK6GA==
       "]]}, 
     {RGBColor[0.40082222609352647`, 0.5220066643438841, 0.85], PointSize[
       NCache[
        Rational[1, 360], 0.002777777777777778]], AbsoluteThickness[1.6], 
      PointBox[CompressedData["
1:eJxt0mswXHccxvHVDjJBKqm4a5YkiC0hWHf77K7LYi27dpcmSqIhIjGttI2O
tC4ZJkRGEgnRDjHuklViBCVxqYaRlBUdIq1MMe1Q1zKkaKKazv5e9sycOfM5
3/O8+h/zmI8lsW8xGIzYN/d/z/+/ljm9led+zxvx9aAXqIha72SMijxV3IGz
qHks/GyCrIt0hfOlYn14qawHo98m0wcjs8iGyC61K51hPiSbolMrybBfc4bM
xKvznfXysZ3eKltAZ78r94bAmnwANTqJyQX6PLIlZi+pRQ4zw8nW0I5r7a0/
lEC2gdt9c3lbfwr5fYxLU12mOTlkO2yOjuVVuxSS7XHH5FRcXlI52QFXOnta
avZ/Sz6Cq62Jg7O7WsiOmPCq85w26CY7wem7Sf43HX1kZ6R1Pfeb8xois3Gm
qf/l8T9HyC6IvlZbpjg3TnYFU0ejhF81RXbD0kVN/YqgabI7fu6bV3Y8mCd7
4Mun7MAFtRWyJ2oPT6zmFq2RvdDqFnilpWaD7I0XQsbNXqctMgcHmdfqXS3U
OHS8yH+RrHd68W2V04HdSxsrjVsa1LlYbjSZyZLupM6FmW2B4p1VHeo8MBaM
Z40XdanzcLPqTFSI+rvU+cgdeCY/yttLnY+hwmMvpZUG1H2g+PHi594sY+o+
EAjucv55ZkrdF2UnXy/F1uyj7ouxxaLbRiJz6n4oK/96OvsXC+p+iF8zSFB+
cYC6P+I3r4fds7ak7o+2xwamS7NW1AVY3RMp4D48RF2AkrZVq6hSFvUApDW7
FKzl21IPQHHxYsO9wsPUA5HZL+4zG7WnHohSZc5cybQD9SBkm6axFNtHqAdB
qGXDMWA6URfigUNAZJO/M3UhrgqaToSeZ1MPhqFHzl+dChfqwehJWasemnGl
LoJIo21bYuNOXYS5Zsc7Rp96UA+BCbsyY+17T+ohOKWt3Xpf35t66Jv/bWSK
lcRRGaEo8R3SLYwHfR+KHqbpez4mXJW7Q7G5z+jXnKdkhhjqliFZ4mwe7cUI
r+ntyuLxaS/GxR2ZTbu3yd1iaJf8tDXZ4UN7CZrLXtVNpPrSXgIHZpfr31w/
2ktQGu1wwUzTn/YSxHU/ustWkhlhOHb5lszxloD2Ydhrv/6hWkwA7cPQeGF7
Pc8ukPZhsNd2r33ymsyQYsw+kV8xEER7KY672y5r3hbSXgrlVKPNH58E016K
QZeRJ46+ItrLINVL0Bo3DqG9DFtRs9eVK+R0GQaLKtq3T4bSXgZFbkZZwzCZ
IYfUspyx7C2mvRwDujf02+vI6XI01J09qmkiob0cVgXqycM5ZEY4PDY2fPZs
khEO84X8Rz/Eh9E+HG1VI4aTz8nd4SioTsk8ESClfQTYE/6nee1kRGAz5mDA
VywZ7SOQuh7Sr11C7o5ANGu6YX6XnPYfIEb9o2W9DDnnX6mAvJ4=
       "]]}, 
     {RGBColor[0.9728288904374106, 0.621644452187053, 0.07336199581899142], 
      PointSize[
       NCache[
        Rational[1, 360], 0.002777777777777778]], AbsoluteThickness[1.6], 
      PointBox[CompressedData["
1:eJxty39Q03Ucx/HvEYWKweBQXCABAvJDOcZvxsZewBjj9zbGBhekcFESEUZ5
IewETosE3YWASkDAAZESVIKpTGNCCEVHx48kfnoRERXyS/lh5FHd3n/2vfvc
9x6f5+dlk5IpS9VjGCb13/Pf//+/ZQF7MetHWe4aly5gumYw99mEEU/HHXhi
PqJyTG0is3B6VDnbWWrM19kMB5JaPj8zn0DeB1tbk94p7zKyJVhpC3P6u7vJ
1hA3yWYctufJtvj49v3q7F07A3S2w13jN7vsku3IDnCpmjZ86MQjO0J5o5gj
YUnJzgirOpreeyGFfAh2JXtLNXlZZFe0yZvdR14oILuhdGFcZN1+nszBy9fV
9sVvXSa7Y6mlq9bCq57sgYLBm5ZXmBayJ3qMTBtT7K+TvZDxwCDcav4O2Ru3
D88lrZR/Q/ZBXeWlRxXN/WRfzF4tU+d7DpH9UFnyd+czBaNkLtrZ+0enR6bI
/ghIV40db5gh86BY1/su8685Mh/63bwMzcaf5ABcmB5jnRxeJgtQmjIk2tzx
mAxcbFpdmand0DkfsNQ3PKGo2aIeCEtVYZiePiPQ9UDs7Dw1wc7U05kJQnJX
oPCo6bPUg1DuXcpnLRlQD0bL7yK1+3OG1IMRPXVrqybeiLoQgZ/oaQoesagL
4ZPT6Lv4kyn1EHxQy2nVTppRD8FAaJGJyfZe6iKk52rifhWwqYsQsKeozr3G
gnoo3NLP5k5bWlEPBafnzPqRRGvqYmRMsCWSWzbUxXiqct22sj9APQyLzqcc
G2vsqIdhv8Hlla8cHaiHI/IO19hOe5B6OJb70qNvpjpRj8DKF7N7eGwX6hFY
Ny6cemf8EPVIsJZLK+yvuFKPxLA+71xhkBv1KGT/ZuS86c2hHgWBtCexm+NO
PRodZmueve4e1KPxxvla/5/9PKnH4HDjqnpR5EU9Bs0G1572J3hTl6B2esFG
keWjMyR4nFWfm/ahL72XwERpem6mzU9nrQQODWkr1ZNc2kth/15JQfYuHu2l
OOvamxzD59NeiiOFi/uYEwG0l+KVkLcrj30poL0M/KC8Tz1OgvYyKE00RQ8t
AmkvQ3lUVeWglqyVYUBs1fHDa0G0j4WFU/HWKCuY9rHwa/O6Oq4h58diUKEW
9h0T0j4WTl/Xq0rMQ2gvx2SBre/BPjLk6GYbluTkiGgvh//q8VGVayjt5Wg1
V5W9OEtm4vCST7VaXimmfRzKPSsGnpeH0T4Oiqr5Br5ROO3jsDU31Hr/WzKj
wL32j8b734+gvQKY3P06KySS9grEXpxdvaQfRXsFhjvuJip6yIwScz4PJgWF
0bRXou4Gd1kcHkN7Jd5VNTh7GEhor0RTHvf0vTQyEw9+Ecdi7Hsy4tG57dKU
6ialfTz+KBFuvFpG1sZjZumXjdFNMpOA8YYn19qSZIJ/AFWstcI=
       "]]}, 
     {RGBColor[0.736782672705901, 0.358, 0.5030266573755369], PointSize[
       NCache[
        Rational[1, 360], 0.002777777777777778]], AbsoluteThickness[1.6], 
      PointBox[CompressedData["
1:eJxty38w1Hkcx/H1M875UYT82ENij3P5tfJ7X9ayfi4Wa9XkV+mEIpnazKm9
W53qLqe6CXOJOcc06TQnJRGbX23XqfaI011M5lyHGHTHyNHdzb7/vO/MZ77z
+Dw/L9uMPGGmOoPByPz3/Pf//2+eY7xRXzKyUOdLFxC+mGcN7x7wU1EHZm23
r+iV5/urbIRfx6XjR08+J5vAuvLiN5pLLgEqm+PWn00Bae05ZCvUn6vqtbG8
TLaBx7Hyus6QfrIdvhZM5tzs+INsDwvHqY0Sbe1AlR1wV7tsoVRiQ2bhuYLt
Lcpik53AT9MqPPYojPwB8uOn6qfsdpI/hJg1ytM6sJ/sio6vRJww5lGyG6KY
/BLnERnZHTZ2Yx0fe5STPZDRpb6WnFRF9oSk4umgqWkdmY0nL4aVLU8ayV7Q
uRaUv/f6DfIO7Ls22/GlQzvZG4ELhhErkd1kH4ytJZ+wZCnIvlCaHhm8J3hM
9kPPwketl14Pkv1xZ49PEf/dUXIAzINeWZZrjpMDIf7iZH/Z8gSZg/VQaeni
3O9kwMDauk3j0IzKUmCbnBc9y52nHoSWX0wFn1m8ph6EByVeqT9xl6hz0ZtX
EWHYtUKdi6aaH3rdzq9RD8aAkHmiYJzBUfVgvLf06HjfVg2VGTxseduiZFZo
UefBXm3aOstXh3oIZOlmPVkGetRD4CdZ07tvbEA9FJLjYnlJvRH1UDycUjpE
7dxEnQ+pt8WuVJYJdT7GFqpChw1NqYfh24zln9uNzKmHoftz+QMDZwvq4ch5
I03pTrGiHg7RTAG7q5FJPQIytSrdxVM21CPQqM0XyxS21CPBfVXNLTLZSj0S
2Y/f6W/LtacehSuH5cdtlduoR+HTksPrZ4McqUdjpPq+5ehdFvVozHlW+z4L
caIugEdNcNm+UWfqAvT5KkVxEhfqMdB8edUi12479RjsKSg62JPjSj0WR1IV
rNuRbiojFu/L72xYdXWn97HYVeyQXmDpobI8Fu6n/nLR1POkfRwafBrsLr4l
Iw6Fc0P9+its2sdhs/mtM7HLXrSPQ2Nq3mjwmx20F2JiuslxQM2H9kK08mXr
Sn1f2gthFqWt4c30o70QuXubV39z96d9PCZF24c6IwNoH4/sBM/axqxA2sfD
5vv56nOnObSPx4VJ+0vOSaB9AtIUF0oOzZCRAN7TDXNnPwmifQIqdG+KC7dw
aZ+ATQ37081vkBmJsBCk9B4QBNM+Ee6eV9OyZsjSRMz6sf3/Ps2jfSJW7r0s
tXYKob0IFZo9dfKHZIhwJqbY7tnBUNqL0HLd58cUYz7tRag8r1Eb3EZmJOE7
t/HB4rQw2ifB+XLxoLpuOO2TIFqcClA0k+VJSBjpnOjZHUF7MQTTpV0zupG0
F6O2eWiN3UqWilHTisXKzCjai8HLzrfS2xxN+2Ssdo44yvqiOf8A3Eyxkw==

       "]]}, 
     {RGBColor[0.28026441037696703`, 0.715, 0.4292089322474965], PointSize[
       NCache[
        Rational[1, 360], 0.002777777777777778]], AbsoluteThickness[1.6], 
      PointBox[CompressedData["
1:eJxty3lQ1GUcx/HlcjkUiSVDROQIkivOZYEF9rNcC3IusMuPkWOWRIfkEGJU
JJEYhE0TZSRwgRIwCjAw1LyQI1Mw0AYEZgQCDBJKLSEFDIypZr9/9pt55jev
5/18zJIzo1JUWSxWyr/nv///f/OClIagl7fzxJ50AXtOtba8/hhfSU0cbj/P
sUpy81JaDwLBIZWEuGayAYYiR8fTTrC8lTaExMY63crJl2yMJI/W2tGe/WRT
qO56nFipfo5sDv1dVbLFrF7y26iy7beXTsySrTB1Ra17oljVR+nt6KysLRgb
30y2wb6hdvnKcweyHcwzmDn5oJD8LhaaFHF/C6PIjpgq/KbaZI+M7IQ7Lu79
ModMsjNuhnpkeBw+RHbBV+W7B73yjpJdcayzuaf6xikyF9s8w9ZrWyrIbhhp
4W+ciagn81BzxLxz83wT2R0jwmS+1tM2sgee5XwsH+VeI3viVPdUqJlmN5mP
ay1f6BuM3SZ74cL1yqm01j6yNw7mhAQqBgfIPkjNmJJ5PR0mC/DZeNtzrUuj
ZMBUv3C1iTeldAHwfmfKYtv309SF8B3O1lNlZqkLMfbL5d+Sk55Q98V0Y1GO
6aM/qPuipvH47Kb5Bep+cLULmjx58SV1P2QyW2UGN5ap+2NhddlTR2uVuj9U
Jmc2NNatUQ9ApQanbNFXRaDsAdA+GjIysFNNaVYgHtllc11qNKgHYiy4Wzqo
rkldhEkF96aoQpu6CNETKblbxBuoB8GNx3w4YaRHPQhrl9anCurfoB6MUOYh
M+LDoR6MT3tyra7OG1DfgXTBnPOLq5uo74DqK9Gz0nJD6iE44iRnSoqNqIcg
4YmsbvCEMfVQWDsVnd3ZbEI9FPG1PKd1GabUw3DXMysuucyMehj6En16HbrM
qYfjdZ9heNyyBfVw5A2ohPV6WFKPgNuB1OmkYivqEbDtLNnKnniHeiS2vFVi
f9bbWmlEwiF8rlSz0YbeRyLfrIJnbmyndHckKsT8Wz8o7GkvxlrmyplxUwfa
i5EQeP2kgnGkvRh5M9XpEksn2ovhVz8UWrpEZkVBuvj6ruM9Z9pH4S9OhtD6
SxfaR6Gk8eLj94pcaR8Fs7Ffu+7t5tI+GqfzmY6IMDfaR6N9uOHbhzwe7aMh
z3+1L9rKnfbR+C5e1nLe0IP2MWjtare4r+tJ+xioWQs+OafJp30MdLBab7TO
i/YxYO8psDNhe9NeAre9iysKHR/aS8DNu/MilyOgvQTamcvako2gvQQH2Htx
vILMkuLNzy90SLYJaS9F/NrBjuYmcoEUf/qslBdwfWkvRbNh/ZX7t8isWOT+
ZHpZLvajfSy2h50RNP5MLohF3YMlW4sP/GkfiwcpDWnzGgG0ZzDc/6MBu4oM
BvGi09JEh0DaM8jWzSr8/Q65m8FopS776wQR7ePwkfr+rLIlkeAfSf2u8A==

       "]]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
       NCache[
        Rational[1, 360], 0.002777777777777778]], AbsoluteThickness[1.6], 
      PointBox[CompressedData["
1:eJxty3801Xccx/GbHTU/j9+/K65fES6X6zf3xfUzXNd1uX7EIj+aY8sIrTXk
V07ToSPLicoNqU0nJuocW9OEYqnrxEisJaaTxZix5Wjbue8/9z3nc77n8Xl+
XibJh4WpcgwGI/Xf89///79l7nja3w3nljbd6AIBrcVsd41ADxnfh9BqaubZ
i02yGjp2ra+aFOZ5yqyFL4cPjWwrlpL18MEJ6WD7tI6XzEboFarWvy4TkI1R
ymb7ytsUkpk4X5uz6hvbQjbD0Ia0VPfJANkCzdqJF/LUXpL3oEA7Z4ltuEW2
huWa3oGgcU1vmW1wwjHOtTbfkmyHxd18SWacG9ke8WMl6avxwWQH+C02NFXe
EZPZeHY2+0NVRirZEcNKG3cetX1CdsKTgn6lzz4/Tuagyz6py9CgnOyMDocV
XWlNNdkFSryEFD1mHdkVnE8jTPkGErIbmmaPxnV81Up2R8JZyfcN29vJHqgx
SXbWDO4ie+KCyVCpymAP2Qt2R/K0+ON3yd6YKu3WOF0zQObCwOn2T/vZP5KB
B175LPlUqcxFQE7Lu4Vl1zHqPoh/zXxa0DhJ3QdXg7f7qbTOUPdF0Vza6NTe
F9R98dhr4tblxDnqPNjMuder/L5AnYfJUW9t3YVF6n5QTS874t28TN0P6nY3
VhKUVqn7I0NxPr786zXq/thfUz3SXr5BPQCX6ioyv7n4lnoAnB/oLXmsbVEP
hLLp3b5F/21cWQ+EgvRY0V8O78nMCEKLKlMljStPPQim/UMnf/h4B/VgZB4T
t57uVaAeDK0RBSsOR5n6PnSu/xmu81CV+j48X+O7c++pUQ+BipWDdMxRg3oI
Hg/vbEzr0qQeCuNb/QfkgrWph4I3Mmvb+UaHehhyTe/PHL+iRz0MOwbVkxOy
DKjz0cbJ1QkLNaLOx1bUojHXfRf1cLytUH6uttOYejhe3c/mL5mbUBeg/aOA
yusuTJkhwKV0i1BPoSm9F8B8oyr9VK6ZzL0CzCZuypVJzGkfgZCeox264xa0
j0C5+aNzNpp7aB+Bpnz9qrYYK9pHIPVaREDhFWvaC1GRGZD8xeZe2gtRrBlb
3x1nS3shHvbUTMz12tFeiKT5P5oKdO1pH4lh3pRb1igZkejDtLXbGQfaR6LE
db1zKJJN+0jkivomtQ0caS+Cpzr3sNJLMkSoPr9p2NDhRHsRnGJ/TbpdzKG9
CJWsgcsCsTPtozD69Kp5FMuF9lHg/JJh1K3oSvso3BzPuHbwFbk3Cha/Fc+F
DbvRPhorIo/5lHZ32kdD/p3+vbo6D9pHw6rq58bJEk/aR6NUIfu6brYX7cXg
JrJYvIPetBfjW8mh0lAxl/Zi3Ax9o6lhCdqL8d2Z2tjpJjIjBmkShywG04f2
MbjRlt+fIyEXxSD8ov4Ei+lL+xgommm72jaTGbEwEO0+mWLJ4/4DvperFA==

       "]]}, 
     {RGBColor[0.880722, 0.611041, 0.142051], PointSize[
       NCache[
        Rational[1, 360], 0.002777777777777778]], AbsoluteThickness[1.6], 
      PointBox[CompressedData["
1:eJxty3lQ1GUcx/FtCYZTRIwAcThcIFC5kWuBD+vCcssesCtxiQdoEEFxiAEC
IhaYGkdy1UBAGdQM4c4yKoQEGYfEAs0oYa4mIJQOokSCYDb7/bPfzDO/eT3v
52OemCY4zGQwGIdfnf/+//8t+l6Q92sfr2j1oAuYJfGGg0xVvJRUB++DfP+A
6evkzVC0u563Teawld6K2vMx7pp9jWRD1BR33M+r/JNsgiPfzPeNqlp7K22G
iawzRmqfSMgW6FeZj23tLCKzIG5s4Xy71EK2ArPSKnv8ST/5LXBqv5oafKgg
26Jv26O6iyMr5F0wzilU61bo+ChtBy27+2kX1c3JDtj0Um7vP+NIdsRCdWf6
4Gk/shPuvpdqWmQdQXbGzeaE7+AbQ3bBckFk4ruVSWRXLK885c3NZJD3oLBB
K8fAPY/shhQb+0gHRQnZHex7tRvDk+fIHig9UKce/Wk12RO74x2Ku3hfkL0w
VXbchunZQmbD+Wph5i1uO9kbb77QWBg6+T3ZB8v5x6bSb8nIvljS5FtahvSQ
AVGUxu2Z9T6lTwJOE6M6eqU3qPshoYib4jYxQt0Px47WB4XnyqlzEKZhs9a7
MUmdg+tZwjgVxm3qexF4uXSnaukd6nvRdqM1jxt+jzoX0lUPdjnrAXUuOOmO
KnnBc9T98RpTf16/f4G6P9aZKmasqsfUA2BUM/fwUsIT6gH4LNdlWLv1KXUe
mpK57FiTv6nz8Oxamzdr4B/qgdj4cm1wrHGNeiASXeNLZJ0b1IMg2ZIarrHB
8FX2IMwwXswxephKM4JhHjMQ4V/7OvVgWK+7RYVWqFEPQe90vXbBJXXqIVj5
uN7Q844m9VAIDPNVR+10qIfieeNiS8HnutTD0CAu8uEa6FEPQ3NcTnVZyhbq
4bDPlj6zHtenHo600j8yrXhvUN+HK5E/vn9u2ID6PjQM+/xwJN6QegRGy5lT
bUxjpRGB2YkT9tHSbfQ+AiJN57Cj2duV7o2AXnS18c1AU9rzkeW8W/1qpRnt
+dB6NCj7utyc9nzEnOBeY5Vb0J4Phm3+mEXFDtoLMJ8gO1TVyKK9AL8fFHWl
yixpL0CPyztLdZNWtBcgpEDurvvcmvZCzA0XDEhZNrQXwlPou/qh2Jb2QsRX
dWTwL+ykvRCcUflW0/FdtBfBo9zITG5kR3sRFLmZXoJke9qL8NsVE7+f4hxo
L0KA546fL2s70j4SgWsjAfPdZEQieLDXRJLhRPtXXT6Zu2zjTPtI6G6qSZY+
IDOioPdycbCsyYX2Ueh4u/tQykFX2kdBa+Kj2WDrPbSPwvRZqwXjx2SGGCHO
Wuu/yNxoL0aGbUxz7Cl32ouxYZp6QCb0oL0Yd8+2SscsPWkvQefKgGXDKhkS
eDSVsDePe9FeArXZofLt7WzaSzBUfKqz64w37ffjL0Xi/l+TfHz/BYostEk=

       "]]}, 
     {RGBColor[0.560181, 0.691569, 0.194885], PointSize[
       NCache[
        Rational[1, 360], 0.002777777777777778]], AbsoluteThickness[1.6], 
      PointBox[CompressedData["
1:eJxty39Q03Ucx/Exf0FoighMAhlgxg/FOZSNIfByUxQYsI2NTTwEEWamNcXj
x6WngJBpjR9aJiXc2AVYchg/c1cIJUKKC1BUDuYvElBBpZBFqZTd3n/2vfvc
9x6f5+flnqyRpTIZDEbq6/Pf//+/8dCc3Gtyq0JJIF3gxP1TVsLkCwILrTEQ
z3wrg5MfZPECtMInwunx3LUWL0KA07ixQ7yXzEKc68qiuqkWsgt2H7gvcu6f
JrMRcHnqxY1SbrDFHlgyMLljuDCRvBTi6pFXD5R55GX4Vv9n2Y+sCrIXcrkC
j9Wqn8k+GPuFXdZWMkBejhWO9sYp9R9kPxy20+TN95kdYjEHoQnPh29/yCKv
QnbEF0r5Ym8yFym5mSM27nyyP/aMc9zef7qBvBon2nnXeX/LyGsQU9RRzd6X
SA7Avqz9Lc/td5J5UE/odobH7iPz0f5IUZf92wFyIG5ovx7wY+aTBZDf6dpa
2KUlB0FVxOp2OPcZeS1yD9psu8Q+TQ5Gcylb/aRdTw6BaFnn7XlVZ8ihkCS5
DxruniMDkW1hdyXSBouzAZ5qM+NhsYH6OuRt/ctTf7WF+jp4lUSP6wsuUhei
jKXe6djdQV0I+XGNxtpwlboIYTVPe8y+PdRFuGi1v7A0oZf6enB0DcozU7eo
r8c/zZoE7kwT9Q2IHAnNOC26R30DLrzM1oa3DVIPg2Hb5Mr0I0PUw+Aa8WpW
fNFD6hvR3M/vchgcpb4Rx7cPTFYeekZ9EzzPZgonG3+nvgmp0ZnBxt4J6uEo
+NI2sNLVTD0cszO54vPFU9QjsMPwMMuL+4J6BOZo3thjzZimHonrgj6B70FG
qKVHQviNqXbanmkxQ4wQ5vT2xz/NoC7G2cZareTjWdSjEHUpfc6xHXOoR6HZ
rEsfTrShHo07naZD1XttqUfD1rHpTefSedRjkFp+T5syOJ96DIxJM0tMbDvq
Eix0qNSVJSy0GBI4rbvhd6TKnt6/7uaMd8unF1ncKkGCi2nsebIj7aV479e2
l/m9TrSX4qv4vnJF7GLaS2E3evTmtrvOtJeiJExaU5HlQnsZFElWBxe7LaG9
DMwHQzPqr7nRXoam8dMddZfZtJfhqFpoX/ydO+1j4Vu99uZoqQftY9Fd9lGO
odiT9rGozpGcfPbJUtrHImvi88bcT9+mvRxbTv1Qoz6xjPZy1AYLtQW6d2gv
x1i/vmKs3ov2ctRJd5WnGb1pr8CZtPPH7J740F6BUQ+/W4aFy2mvgO9EUdqW
kBW0V+BRkOflIY0f7eMw5TPYs7FqJe3jwL8SP5efxqF9HFgicUql/SraxyHp
WV//0PdkhhIfnNT7P9nKpb0Sx1rPLqi39qe9Et4xT80rGsmtSlgP6GTylNW0
V8E/3Xm/i+Ma2qvgnhLVdOAKOVuFtN2moF05AbRXocGtj3dHwKP9ZhRy+MZO
My/0X9+tvhY=
       "]]}, 
     {RGBColor[0.922526, 0.385626, 0.209179], PointSize[
       NCache[
        Rational[1, 360], 0.002777777777777778]], AbsoluteThickness[1.6], 
      PointBox[CompressedData["
1:eJxti3lQFGQYh1FR7iDiTAK5hLhddrmX/YHcy7EsCyxSGQQ4psYqpLUeQDAG
FOsspIEziheMDPclhRvSLEckZ4RN4NRyjIiSIiQxBJTNvn/2zbzzzfM+72OZ
mslP366iopL+av77//8tcRZfM8scalv1ogXGpd1ZcqdTPkpUB9dQR7xqF+ar
ZD2Y2lqr5k5MEBtAXDDfF+gBPyWboKe4RTE9ISU2g3Rh6/e8x+PEe3DlGwWL
z9RiK9kK4pYaz7RGb2Ib5CRrWj9lpBLvRVFbm0fh+QJie7xrxXV0Zt8kdkD+
9JkQ47UuYifoZ4jOOaxMELsg8fZk+sbyU2I3CG/ImrzYKv5K3odjV5PHm4+/
TszAjujNs5F5lsTu0GV6zreUuBEz0aXaFT3YwSZmocI5e9RDHE7sgcHeZZn3
moDYE6P9xn6zt94n9sJhYeOZ0bLDxN4YO/fseq5RFrEPRu1HVljdp4l9oba7
nf+kJZ/YDzaFdzZb3/uCmI1ZDcVR7apSYn/kffxL2pcr5cQcFDsl3L999Box
4KBumb8VWaXkXEA+P9zwt38t+QAofHbM5TCbyQegp3b4QO2n7eQDoXggf7Se
30k+EIvhRpISZjf5/Xi8TUNys1JOfj8C6vk1pZJ+8kEYtdMV/aQ9SD4I7cUi
9b9KR8kHw/uyg0vniXHywZgyuBifXfuAfAgqndRSJgMnyYcgo61wpsT/N/Kh
iBxJl2rxp8mHot7+3lSmbJZ8GK4zzX42SnlEPgzT8rwLFwIXyIdjg7ceE/fB
IvlwjMh9p+W9z8lHoOFsvanhnRfkI8D+81D5gboV8lysBUkyZH0vyXMhVW28
5bFrjXwkBItL8R1H1slHYj6m3918bYN8FMSNA1/71f1DPgrj2lOyD4O2cZQ+
GlpFXfei+7crOTcaJxhSyVsHVcnHoPqSTYq19i7yMbjGbSuqGlYjz4Ouj+jS
TLWGksHD+ZOMU/oXteieh3KerDqjQkfJ3Tw8jHmZoNmmS30sfCUzMdJlPepj
kcc0Fx4y0qc+FqzWBZWvgt+gPhZLT+QhlrkG1PMReoKbZ9RnSD0fOj9653xi
bEw9H251390Izzahng/BtwubRQ9NqY8DI2nhI0/eburjkBPbejdqxIz6OAww
tur6ksypj4PrWIT95ecW1Asgasi2OfjDHuoF8LddvVt21ZJ6wau+ICBNbEW9
AL+2spIGkq2pj0dN49CzzkAb6uNhMSbjuLnaUh+P6treOQvLvdTHo9k2cSrH
xI76BJwubZIEG9pTn4ClHoUi3fht6hPAqaxznzB3oD4BJ++nHv/c0ZH6RNTN
VRiK2E7UJyK5ZIj1mcCZ+kRoevYXNYlcqE/EziOdWX9IXakXQjy7mW/4jhv1
QjRZWRTXvyDOFULvim1ZR9E+6oXoinoz3MmGQX0Sjm3t9FP9nsH5F9iPvVA=

       "]]}, 
     {RGBColor[0.528488, 0.470624, 0.701351], PointSize[
       NCache[
        Rational[1, 360], 0.002777777777777778]], AbsoluteThickness[1.6], 
      PointBox[CompressedData["
1:eJxti3kwHAYUhxEjcWTcZzLEGXWNu661P1nXOpa1WGmyCMIIRmwkiqQkmm3F
0YYwEToyLZFIGq2kytbVkTGmiKzUTBJak0hQZ8RV1dB29v3ZN/Pmzfe++YwT
MiNOysnIyJz8d/+7/z9vmU32Fk2xQ3Vu9MDwMfktyY69hxT3gXG/NT+0UMlT
ymp4MC/2rOmpJ9bCDIu92Oe730vKenBkV9uU2yYSH4T+batD+f23iQ+hore3
vtt2itgEHUcl3Vl2WgwpmyFHv3juzlkmsQU6B0LeLXISiS3x3Hczce5yEbEV
zLkqwuXRm8Q2uHfhsZNGXAexHap7irbWdCTE9iiIHC5bmX1N7IC1t09cV0s3
iR2hMz6UPNSyz1vKTkiuUV48zNEjdoZ1hkvmm0YLYheIWu0euRs4E7viwe+F
6qs6PsQfYmBi1Ht+PZjYDUOZvRNC/WhidwymX7vFWY4n9kB2q739J4xUYk8s
FCQJbPlCYi/4bvU1S1TyiBnQu7AwwDK8ROwN42mRC8SfEzPh8NEkQ6vqS2Kg
f9AuzXaqSsqFgDxzo+lRTh15Hyi3a/5QzfqavA/GlBzDOs2ayB+BYo/IVOf9
PfJHkDO29PHf69+TZ6GzgndGVbGNPAvBrrvJnQNi8r7YOjF4mmnaS94XCi3v
yg2D+sj7QW25fkj3VT95PxwfOC9KWvuFvD/2hiQWh10ZIe+P6fNX569Fj5IP
gM7G5b+MnMbIB2BCb3MuJe4Z+UD8FqLVtjs5Tj4QXwQtrad2TJJnw+tcwmml
P1+SZ8MxvirM2vc1+SAYBQXsOPdNkw/CzGZRu0vOH+SD4X8q2cc6YYF8MNqv
3+2WFS2TD0HSdxuxbOEK+RC0jqg4jDJXyYeiy63jWLbNOvlQaIwpVe+4bZLn
4L6sQNsleYs8B80WolOSh9vkw7BTeTbjkvkO+TCUHFg0OHdchin14WDPiVV/
/VFWyggH1yMt3cR8j5QLw7Gdd4vxTYO8lHvDkXGxNKrSVYF6LjjOZ+KsxvdS
z4Wc6dLGjQpF6rmYfTHys4ZAmXoulEpeloo99lMfgaIY9bQ2a1XqI6DGSp3X
uK5GfQRUTFvm1BvUqY9AT7O4bKpDg3oedLNq9a8+16SeB+1UjsR4jzb1PDCm
9RRrXXWo50GY+8RdJluX+kiU9c9o8n7Soz4Szy4aV1SqGFAfifSup8q9KQeo
j8Tmyrf+Y0MHqY9Cw8j2Z489DamPAlMhubHxoRH1UVjIr7typ/YQ9VEQlBvt
Tp8wpj4aSqKbpgq2JtRH49N0I57se+LCaBjUi/mjElPqo+GXbSgU3jWjno/A
4jfxL4rNqeej6+lsilyGBfV8tBXk8l9FHqaej27dvMosH0vqY+AHtkGT4wfU
xyBWkFmSa2lFfQxUA+XsJk2sqY/BDUHbxrCxDfVH8dVsTZmnuS3zH/J4uZU=

       "]]}}, {
     {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
       NCache[
        Rational[1, 360], 0.002777777777777778]], AbsoluteThickness[1.6]}, 
     {RGBColor[0.880722, 0.611041, 0.142051], PointSize[
       NCache[
        Rational[1, 360], 0.002777777777777778]], AbsoluteThickness[1.6]}, 
     {RGBColor[0.560181, 0.691569, 0.194885], PointSize[
       NCache[
        Rational[1, 360], 0.002777777777777778]], AbsoluteThickness[1.6]}, 
     {RGBColor[0.922526, 0.385626, 0.209179], PointSize[
       NCache[
        Rational[1, 360], 0.002777777777777778]], AbsoluteThickness[1.6]}, 
     {RGBColor[0.528488, 0.470624, 0.701351], PointSize[
       NCache[
        Rational[1, 360], 0.002777777777777778]], AbsoluteThickness[1.6]}, 
     {RGBColor[0.772079, 0.431554, 0.102387], PointSize[
       NCache[
        Rational[1, 360], 0.002777777777777778]], AbsoluteThickness[1.6]}, 
     {RGBColor[0.363898, 0.618501, 0.782349], PointSize[
       NCache[
        Rational[1, 360], 0.002777777777777778]], AbsoluteThickness[1.6]}, 
     {RGBColor[1, 0.75, 0], PointSize[
       NCache[
        Rational[1, 360], 0.002777777777777778]], AbsoluteThickness[1.6]}, 
     {RGBColor[0.647624, 0.37816, 0.614037], PointSize[
       NCache[
        Rational[1, 360], 0.002777777777777778]], AbsoluteThickness[1.6]}, 
     {RGBColor[0.571589, 0.586483, 0.], PointSize[
       NCache[
        Rational[1, 360], 0.002777777777777778]], AbsoluteThickness[1.6]}, 
     {RGBColor[0.915, 0.3325, 0.2125], PointSize[
       NCache[
        Rational[1, 360], 0.002777777777777778]], AbsoluteThickness[1.6]}, 
     {RGBColor[0.40082222609352647`, 0.5220066643438841, 0.85], PointSize[
       NCache[
        Rational[1, 360], 0.002777777777777778]], AbsoluteThickness[1.6]}, 
     {RGBColor[0.9728288904374106, 0.621644452187053, 0.07336199581899142], 
      PointSize[
       NCache[
        Rational[1, 360], 0.002777777777777778]], AbsoluteThickness[1.6]}, 
     {RGBColor[0.736782672705901, 0.358, 0.5030266573755369], PointSize[
       NCache[
        Rational[1, 360], 0.002777777777777778]], AbsoluteThickness[1.6]}, 
     {RGBColor[0.28026441037696703`, 0.715, 0.4292089322474965], PointSize[
       NCache[
        Rational[1, 360], 0.002777777777777778]], AbsoluteThickness[1.6]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
       NCache[
        Rational[1, 360], 0.002777777777777778]], AbsoluteThickness[1.6]}, 
     {RGBColor[0.880722, 0.611041, 0.142051], PointSize[
       NCache[
        Rational[1, 360], 0.002777777777777778]], AbsoluteThickness[1.6]}, 
     {RGBColor[0.560181, 0.691569, 0.194885], PointSize[
       NCache[
        Rational[1, 360], 0.002777777777777778]], AbsoluteThickness[1.6]}, 
     {RGBColor[0.922526, 0.385626, 0.209179], PointSize[
       NCache[
        Rational[1, 360], 0.002777777777777778]], AbsoluteThickness[1.6]}, 
     {RGBColor[0.528488, 0.470624, 0.701351], PointSize[
       NCache[
        Rational[1, 360], 0.002777777777777778]], AbsoluteThickness[1.6]}, 
     {RGBColor[0.772079, 0.431554, 0.102387], PointSize[
       NCache[
        Rational[1, 360], 0.002777777777777778]], AbsoluteThickness[1.6]}, 
     {RGBColor[0.363898, 0.618501, 0.782349], PointSize[
       NCache[
        Rational[1, 360], 0.002777777777777778]], AbsoluteThickness[1.6]}, 
     {RGBColor[1, 0.75, 0], PointSize[
       NCache[
        Rational[1, 360], 0.002777777777777778]], AbsoluteThickness[1.6]}, 
     {RGBColor[0.647624, 0.37816, 0.614037], PointSize[
       NCache[
        Rational[1, 360], 0.002777777777777778]], AbsoluteThickness[1.6]}, 
     {RGBColor[0.571589, 0.586483, 0.], PointSize[
       NCache[
        Rational[1, 360], 0.002777777777777778]], AbsoluteThickness[1.6]}, 
     {RGBColor[0.915, 0.3325, 0.2125], PointSize[
       NCache[
        Rational[1, 360], 0.002777777777777778]], AbsoluteThickness[1.6]}, 
     {RGBColor[0.40082222609352647`, 0.5220066643438841, 0.85], PointSize[
       NCache[
        Rational[1, 360], 0.002777777777777778]], AbsoluteThickness[1.6]}, 
     {RGBColor[0.9728288904374106, 0.621644452187053, 0.07336199581899142], 
      PointSize[
       NCache[
        Rational[1, 360], 0.002777777777777778]], AbsoluteThickness[1.6]}, 
     {RGBColor[0.736782672705901, 0.358, 0.5030266573755369], PointSize[
       NCache[
        Rational[1, 360], 0.002777777777777778]], AbsoluteThickness[1.6]}, 
     {RGBColor[0.28026441037696703`, 0.715, 0.4292089322474965], PointSize[
       NCache[
        Rational[1, 360], 0.002777777777777778]], AbsoluteThickness[1.6]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
       NCache[
        Rational[1, 360], 0.002777777777777778]], AbsoluteThickness[1.6]}, 
     {RGBColor[0.880722, 0.611041, 0.142051], PointSize[
       NCache[
        Rational[1, 360], 0.002777777777777778]], AbsoluteThickness[1.6]}, 
     {RGBColor[0.560181, 0.691569, 0.194885], PointSize[
       NCache[
        Rational[1, 360], 0.002777777777777778]], AbsoluteThickness[1.6]}, 
     {RGBColor[0.922526, 0.385626, 0.209179], PointSize[
       NCache[
        Rational[1, 360], 0.002777777777777778]], AbsoluteThickness[1.6]}, 
     {RGBColor[0.528488, 0.470624, 0.701351], PointSize[
       NCache[
        Rational[1, 360], 0.002777777777777778]], AbsoluteThickness[1.6]}, 
     {RGBColor[0.772079, 0.431554, 0.102387], PointSize[
       NCache[
        Rational[1, 360], 0.002777777777777778]], AbsoluteThickness[1.6]}, 
     {RGBColor[0.363898, 0.618501, 0.782349], PointSize[
       NCache[
        Rational[1, 360], 0.002777777777777778]], AbsoluteThickness[1.6]}, 
     {RGBColor[1, 0.75, 0], PointSize[
       NCache[
        Rational[1, 360], 0.002777777777777778]], AbsoluteThickness[1.6]}, 
     {RGBColor[0.647624, 0.37816, 0.614037], PointSize[
       NCache[
        Rational[1, 360], 0.002777777777777778]], AbsoluteThickness[1.6]}, 
     {RGBColor[0.571589, 0.586483, 0.], PointSize[
       NCache[
        Rational[1, 360], 0.002777777777777778]], AbsoluteThickness[1.6]}, 
     {RGBColor[0.915, 0.3325, 0.2125], PointSize[
       NCache[
        Rational[1, 360], 0.002777777777777778]], AbsoluteThickness[1.6]}, 
     {RGBColor[0.40082222609352647`, 0.5220066643438841, 0.85], PointSize[
       NCache[
        Rational[1, 360], 0.002777777777777778]], AbsoluteThickness[1.6]}, 
     {RGBColor[0.9728288904374106, 0.621644452187053, 0.07336199581899142], 
      PointSize[
       NCache[
        Rational[1, 360], 0.002777777777777778]], AbsoluteThickness[1.6]}, 
     {RGBColor[0.736782672705901, 0.358, 0.5030266573755369], PointSize[
       NCache[
        Rational[1, 360], 0.002777777777777778]], AbsoluteThickness[1.6]}, 
     {RGBColor[0.28026441037696703`, 0.715, 0.4292089322474965], PointSize[
       NCache[
        Rational[1, 360], 0.002777777777777778]], AbsoluteThickness[1.6]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
       NCache[
        Rational[1, 360], 0.002777777777777778]], AbsoluteThickness[1.6]}, 
     {RGBColor[0.880722, 0.611041, 0.142051], PointSize[
       NCache[
        Rational[1, 360], 0.002777777777777778]], AbsoluteThickness[1.6]}, 
     {RGBColor[0.560181, 0.691569, 0.194885], PointSize[
       NCache[
        Rational[1, 360], 0.002777777777777778]], AbsoluteThickness[1.6]}, 
     {RGBColor[0.922526, 0.385626, 0.209179], PointSize[
       NCache[
        Rational[1, 360], 0.002777777777777778]], AbsoluteThickness[1.6]}, 
     {RGBColor[0.528488, 0.470624, 0.701351], PointSize[
       NCache[
        Rational[1, 360], 0.002777777777777778]], AbsoluteThickness[
      1.6]}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}}, {
     {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
       NCache[
        Rational[1, 360], 0.002777777777777778]], AbsoluteThickness[1.6]}, 
     {RGBColor[0.880722, 0.611041, 0.142051], PointSize[
       NCache[
        Rational[1, 360], 0.002777777777777778]], AbsoluteThickness[1.6]}, 
     {RGBColor[0.560181, 0.691569, 0.194885], PointSize[
       NCache[
        Rational[1, 360], 0.002777777777777778]], AbsoluteThickness[1.6]}, 
     {RGBColor[0.922526, 0.385626, 0.209179], PointSize[
       NCache[
        Rational[1, 360], 0.002777777777777778]], AbsoluteThickness[1.6]}, 
     {RGBColor[0.528488, 0.470624, 0.701351], PointSize[
       NCache[
        Rational[1, 360], 0.002777777777777778]], AbsoluteThickness[1.6]}, 
     {RGBColor[0.772079, 0.431554, 0.102387], PointSize[
       NCache[
        Rational[1, 360], 0.002777777777777778]], AbsoluteThickness[1.6]}, 
     {RGBColor[0.363898, 0.618501, 0.782349], PointSize[
       NCache[
        Rational[1, 360], 0.002777777777777778]], AbsoluteThickness[1.6]}, 
     {RGBColor[1, 0.75, 0], PointSize[
       NCache[
        Rational[1, 360], 0.002777777777777778]], AbsoluteThickness[1.6]}, 
     {RGBColor[0.647624, 0.37816, 0.614037], PointSize[
       NCache[
        Rational[1, 360], 0.002777777777777778]], AbsoluteThickness[1.6]}, 
     {RGBColor[0.571589, 0.586483, 0.], PointSize[
       NCache[
        Rational[1, 360], 0.002777777777777778]], AbsoluteThickness[1.6]}, 
     {RGBColor[0.915, 0.3325, 0.2125], PointSize[
       NCache[
        Rational[1, 360], 0.002777777777777778]], AbsoluteThickness[1.6]}, 
     {RGBColor[0.40082222609352647`, 0.5220066643438841, 0.85], PointSize[
       NCache[
        Rational[1, 360], 0.002777777777777778]], AbsoluteThickness[1.6]}, 
     {RGBColor[0.9728288904374106, 0.621644452187053, 0.07336199581899142], 
      PointSize[
       NCache[
        Rational[1, 360], 0.002777777777777778]], AbsoluteThickness[1.6]}, 
     {RGBColor[0.736782672705901, 0.358, 0.5030266573755369], PointSize[
       NCache[
        Rational[1, 360], 0.002777777777777778]], AbsoluteThickness[1.6]}, 
     {RGBColor[0.28026441037696703`, 0.715, 0.4292089322474965], PointSize[
       NCache[
        Rational[1, 360], 0.002777777777777778]], AbsoluteThickness[1.6]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
       NCache[
        Rational[1, 360], 0.002777777777777778]], AbsoluteThickness[1.6]}, 
     {RGBColor[0.880722, 0.611041, 0.142051], PointSize[
       NCache[
        Rational[1, 360], 0.002777777777777778]], AbsoluteThickness[1.6]}, 
     {RGBColor[0.560181, 0.691569, 0.194885], PointSize[
       NCache[
        Rational[1, 360], 0.002777777777777778]], AbsoluteThickness[1.6]}, 
     {RGBColor[0.922526, 0.385626, 0.209179], PointSize[
       NCache[
        Rational[1, 360], 0.002777777777777778]], AbsoluteThickness[1.6]}, 
     {RGBColor[0.528488, 0.470624, 0.701351], PointSize[
       NCache[
        Rational[1, 360], 0.002777777777777778]], AbsoluteThickness[1.6]}, 
     {RGBColor[0.772079, 0.431554, 0.102387], PointSize[
       NCache[
        Rational[1, 360], 0.002777777777777778]], AbsoluteThickness[1.6]}, 
     {RGBColor[0.363898, 0.618501, 0.782349], PointSize[
       NCache[
        Rational[1, 360], 0.002777777777777778]], AbsoluteThickness[1.6]}, 
     {RGBColor[1, 0.75, 0], PointSize[
       NCache[
        Rational[1, 360], 0.002777777777777778]], AbsoluteThickness[1.6]}, 
     {RGBColor[0.647624, 0.37816, 0.614037], PointSize[
       NCache[
        Rational[1, 360], 0.002777777777777778]], AbsoluteThickness[1.6]}, 
     {RGBColor[0.571589, 0.586483, 0.], PointSize[
       NCache[
        Rational[1, 360], 0.002777777777777778]], AbsoluteThickness[1.6]}, 
     {RGBColor[0.915, 0.3325, 0.2125], PointSize[
       NCache[
        Rational[1, 360], 0.002777777777777778]], AbsoluteThickness[1.6]}, 
     {RGBColor[0.40082222609352647`, 0.5220066643438841, 0.85], PointSize[
       NCache[
        Rational[1, 360], 0.002777777777777778]], AbsoluteThickness[1.6]}, 
     {RGBColor[0.9728288904374106, 0.621644452187053, 0.07336199581899142], 
      PointSize[
       NCache[
        Rational[1, 360], 0.002777777777777778]], AbsoluteThickness[1.6]}, 
     {RGBColor[0.736782672705901, 0.358, 0.5030266573755369], PointSize[
       NCache[
        Rational[1, 360], 0.002777777777777778]], AbsoluteThickness[1.6]}, 
     {RGBColor[0.28026441037696703`, 0.715, 0.4292089322474965], PointSize[
       NCache[
        Rational[1, 360], 0.002777777777777778]], AbsoluteThickness[1.6]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
       NCache[
        Rational[1, 360], 0.002777777777777778]], AbsoluteThickness[1.6]}, 
     {RGBColor[0.880722, 0.611041, 0.142051], PointSize[
       NCache[
        Rational[1, 360], 0.002777777777777778]], AbsoluteThickness[1.6]}, 
     {RGBColor[0.560181, 0.691569, 0.194885], PointSize[
       NCache[
        Rational[1, 360], 0.002777777777777778]], AbsoluteThickness[1.6]}, 
     {RGBColor[0.922526, 0.385626, 0.209179], PointSize[
       NCache[
        Rational[1, 360], 0.002777777777777778]], AbsoluteThickness[1.6]}, 
     {RGBColor[0.528488, 0.470624, 0.701351], PointSize[
       NCache[
        Rational[1, 360], 0.002777777777777778]], AbsoluteThickness[1.6]}, 
     {RGBColor[0.772079, 0.431554, 0.102387], PointSize[
       NCache[
        Rational[1, 360], 0.002777777777777778]], AbsoluteThickness[1.6]}, 
     {RGBColor[0.363898, 0.618501, 0.782349], PointSize[
       NCache[
        Rational[1, 360], 0.002777777777777778]], AbsoluteThickness[1.6]}, 
     {RGBColor[1, 0.75, 0], PointSize[
       NCache[
        Rational[1, 360], 0.002777777777777778]], AbsoluteThickness[1.6]}, 
     {RGBColor[0.647624, 0.37816, 0.614037], PointSize[
       NCache[
        Rational[1, 360], 0.002777777777777778]], AbsoluteThickness[1.6]}, 
     {RGBColor[0.571589, 0.586483, 0.], PointSize[
       NCache[
        Rational[1, 360], 0.002777777777777778]], AbsoluteThickness[1.6]}, 
     {RGBColor[0.915, 0.3325, 0.2125], PointSize[
       NCache[
        Rational[1, 360], 0.002777777777777778]], AbsoluteThickness[1.6]}, 
     {RGBColor[0.40082222609352647`, 0.5220066643438841, 0.85], PointSize[
       NCache[
        Rational[1, 360], 0.002777777777777778]], AbsoluteThickness[1.6]}, 
     {RGBColor[0.9728288904374106, 0.621644452187053, 0.07336199581899142], 
      PointSize[
       NCache[
        Rational[1, 360], 0.002777777777777778]], AbsoluteThickness[1.6]}, 
     {RGBColor[0.736782672705901, 0.358, 0.5030266573755369], PointSize[
       NCache[
        Rational[1, 360], 0.002777777777777778]], AbsoluteThickness[1.6]}, 
     {RGBColor[0.28026441037696703`, 0.715, 0.4292089322474965], PointSize[
       NCache[
        Rational[1, 360], 0.002777777777777778]], AbsoluteThickness[1.6]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
       NCache[
        Rational[1, 360], 0.002777777777777778]], AbsoluteThickness[1.6]}, 
     {RGBColor[0.880722, 0.611041, 0.142051], PointSize[
       NCache[
        Rational[1, 360], 0.002777777777777778]], AbsoluteThickness[1.6]}, 
     {RGBColor[0.560181, 0.691569, 0.194885], PointSize[
       NCache[
        Rational[1, 360], 0.002777777777777778]], AbsoluteThickness[1.6]}, 
     {RGBColor[0.922526, 0.385626, 0.209179], PointSize[
       NCache[
        Rational[1, 360], 0.002777777777777778]], AbsoluteThickness[1.6]}, 
     {RGBColor[0.528488, 0.470624, 0.701351], PointSize[
       NCache[
        Rational[1, 360], 0.002777777777777778]], AbsoluteThickness[
      1.6]}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}}}, {{}, {}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  Method->{
   "OptimizePlotMarkers" -> True, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{0, 100.}, {0, 0.05}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {0, 0}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{3.873722045364892*^9, 3.8737222823750677`*^9, 
  3.8737386705462303`*^9},
 CellLabel->"Out[59]=",ExpressionUUID->"fde81db0-fcbd-4978-a4ab-d422d0c1961b"],

Cell[BoxData["\<\"/home/rsteinig/prediction_perfect.dat\"\>"], "Output",
 CellChangeTimes->{3.873722045364892*^9, 3.8737222823750677`*^9, 
  3.873738670672777*^9},
 CellLabel->"Out[62]=",ExpressionUUID->"0901b08f-8c22-4e75-a252-db2ccbd700e2"]
}, Open  ]]
},
WindowSize->{1321, 911},
WindowMargins->{{364, Automatic}, {208, Automatic}},
FrontEndVersion->"12.0 for Linux x86 (64-bit) (April 8, 2019)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[580, 22, 1898, 44, 170, "Input",ExpressionUUID->"57fc7b0e-5888-4a6a-a6ba-8b2b2211964d"],
Cell[2481, 68, 6531, 126, 247, "Output",ExpressionUUID->"3c53ac5b-4c58-411f-ae93-e34bdac5acde"]
}, Open  ]],
Cell[CellGroupData[{
Cell[9049, 199, 6345, 148, 653, "Input",ExpressionUUID->"d3dd7bdc-5c3b-4985-be56-e2f3b074a335"],
Cell[15397, 349, 11776, 205, 261, "Output",ExpressionUUID->"f87f5bdf-0d4a-43b3-ae4d-0170e6429161"]
}, Open  ]],
Cell[CellGroupData[{
Cell[27210, 559, 2373, 56, 331, "Input",ExpressionUUID->"2c60896b-6ac5-4f51-b54c-40dfa7c069f3"],
Cell[29586, 617, 2507, 37, 35, "Output",ExpressionUUID->"f39335d3-59c4-409b-88f6-4706294c62cd"]
}, Open  ]],
Cell[CellGroupData[{
Cell[32130, 659, 5908, 131, 515, "Input",ExpressionUUID->"ae8be8f4-e682-4437-ade4-f7603461378f"],
Cell[38041, 792, 5053, 92, 254, "Output",ExpressionUUID->"ad2ddd4b-65b3-4d47-abad-76560f43c4db"]
}, Open  ]],
Cell[CellGroupData[{
Cell[43131, 889, 13718, 287, 1320, "Input",ExpressionUUID->"2f1f2b09-d711-4b94-8c60-a97a4c4a6fb2"],
Cell[CellGroupData[{
Cell[56874, 1180, 886, 17, 25, "Print",ExpressionUUID->"b921f7a6-337e-44a7-98e6-65f77d6df808"],
Cell[57763, 1199, 677, 12, 25, "Print",ExpressionUUID->"8d88991d-179d-4ffa-abdd-7ff4fb204bc1"],
Cell[58443, 1213, 678, 12, 25, "Print",ExpressionUUID->"dff9de3c-1644-4ca1-bd2d-2675d7fc31bb"],
Cell[59124, 1227, 678, 12, 25, "Print",ExpressionUUID->"2e88c905-5baf-480e-b6a9-02587fa2e3f4"],
Cell[59805, 1241, 678, 12, 25, "Print",ExpressionUUID->"859da008-7dec-4a9f-a938-32f835b40cb5"],
Cell[60486, 1255, 680, 12, 25, "Print",ExpressionUUID->"e9f76aae-7bdb-41c4-83f6-7df270d84809"],
Cell[61169, 1269, 678, 12, 25, "Print",ExpressionUUID->"8bacb917-6654-45c0-9219-eb876e88e58b"],
Cell[61850, 1283, 678, 12, 25, "Print",ExpressionUUID->"5f5704b9-24c0-439e-a370-f005fd7a719f"],
Cell[62531, 1297, 678, 12, 25, "Print",ExpressionUUID->"7768daf9-3f91-499d-a5c6-66367dba54aa"],
Cell[63212, 1311, 678, 12, 25, "Print",ExpressionUUID->"e1908e47-bf7d-4323-90f8-28f9a678b0aa"],
Cell[63893, 1325, 680, 12, 25, "Print",ExpressionUUID->"c455a718-c54d-463e-b5b4-85016dd072f7"],
Cell[64576, 1339, 678, 12, 25, "Print",ExpressionUUID->"e79cff44-99e0-4351-a734-be7b595f17dc"],
Cell[65257, 1353, 678, 12, 25, "Print",ExpressionUUID->"fd17cc11-4293-42c0-9f75-73eae639ce7b"],
Cell[65938, 1367, 680, 12, 25, "Print",ExpressionUUID->"7a3a9f54-8489-48a7-a3bb-f896bea7c05d"],
Cell[66621, 1381, 678, 12, 25, "Print",ExpressionUUID->"54cc68c4-2eb5-40db-ad97-631dd11fa683"],
Cell[67302, 1395, 678, 12, 25, "Print",ExpressionUUID->"f4c7841f-1c18-4eb2-840a-21ce48ceacba"],
Cell[67983, 1409, 678, 12, 25, "Print",ExpressionUUID->"a0bf7ec9-0226-4d09-b050-d49f85198404"],
Cell[68664, 1423, 678, 12, 25, "Print",ExpressionUUID->"ec590334-9ce0-44e7-84fa-5eb881b51310"],
Cell[69345, 1437, 680, 12, 25, "Print",ExpressionUUID->"b1d49e63-74d0-490b-b476-eba08ce96c46"],
Cell[70028, 1451, 680, 12, 25, "Print",ExpressionUUID->"132597a9-c9bb-40e7-9bd2-f1cf5ffe86fd"],
Cell[70711, 1465, 679, 12, 25, "Print",ExpressionUUID->"55261e13-bb1f-45bf-8632-31b90eb3dbe2"],
Cell[71393, 1479, 681, 12, 25, "Print",ExpressionUUID->"5327b3ff-828d-46ce-a2c8-f4254b14f796"],
Cell[72077, 1493, 678, 12, 25, "Print",ExpressionUUID->"27b715a9-6eae-44b3-aeee-4723f24f3866"],
Cell[72758, 1507, 681, 12, 25, "Print",ExpressionUUID->"adf734ac-ff65-46be-9720-0159a4e57e9a"],
Cell[73442, 1521, 679, 12, 25, "Print",ExpressionUUID->"eb05bb3e-10b6-4d25-a666-b3c2a9e4bc6c"],
Cell[74124, 1535, 679, 12, 25, "Print",ExpressionUUID->"47550f38-9d07-407e-89ad-99aa316b5bfd"],
Cell[74806, 1549, 679, 12, 25, "Print",ExpressionUUID->"cf67b998-b620-43ae-8641-93cc6ee100f0"],
Cell[75488, 1563, 679, 12, 25, "Print",ExpressionUUID->"6e6040a0-9f07-4c81-b432-42e6f134cc91"],
Cell[76170, 1577, 679, 12, 25, "Print",ExpressionUUID->"464985e3-b79e-4743-88ae-0cf2579394de"],
Cell[76852, 1591, 679, 12, 25, "Print",ExpressionUUID->"e86f8112-78d5-4426-ae07-6d7b14cfe809"],
Cell[77534, 1605, 681, 12, 25, "Print",ExpressionUUID->"af81e591-ecdd-475d-82e9-8a266cda31b9"],
Cell[78218, 1619, 679, 12, 25, "Print",ExpressionUUID->"006e60fb-f7fa-443f-b491-fb000ad730c1"],
Cell[78900, 1633, 679, 12, 25, "Print",ExpressionUUID->"a5c6e86b-3961-4174-9850-d6bbf19403b0"],
Cell[79582, 1647, 681, 12, 25, "Print",ExpressionUUID->"52995203-5bbf-40a0-8861-632fc5282448"],
Cell[80266, 1661, 681, 12, 25, "Print",ExpressionUUID->"eb0e7b57-f5b5-4acd-8978-baa36d559521"],
Cell[80950, 1675, 681, 12, 25, "Print",ExpressionUUID->"1aa86244-03d3-48e9-b9c4-e28a8ecaba44"],
Cell[81634, 1689, 679, 12, 25, "Print",ExpressionUUID->"00bddfdf-d836-4e31-8305-e5985545049e"],
Cell[82316, 1703, 681, 12, 25, "Print",ExpressionUUID->"746dd437-cdbf-4e57-bad3-54743d38c661"],
Cell[83000, 1717, 678, 12, 25, "Print",ExpressionUUID->"c4a070b2-1f42-4256-b602-b2917b26b0bd"],
Cell[83681, 1731, 679, 12, 25, "Print",ExpressionUUID->"7025460b-ba94-4cc4-a946-b907d910580f"],
Cell[84363, 1745, 679, 12, 25, "Print",ExpressionUUID->"9601e2b9-2f44-43c9-a2f1-9e5c6e82e09b"],
Cell[85045, 1759, 679, 12, 25, "Print",ExpressionUUID->"7d6a6ba5-8191-4fe4-a6e0-4c8e310f7f5e"],
Cell[85727, 1773, 679, 12, 25, "Print",ExpressionUUID->"e0bf8cf7-c113-42d8-8ebf-8fce73c9361c"],
Cell[86409, 1787, 679, 12, 25, "Print",ExpressionUUID->"f07687b6-9e93-46ce-a36a-7dd45f43d2ce"],
Cell[87091, 1801, 679, 12, 25, "Print",ExpressionUUID->"bbcebb05-f38b-4066-921f-cb4722d1500b"],
Cell[87773, 1815, 679, 12, 25, "Print",ExpressionUUID->"57489057-1dea-4771-89e8-82b928582ced"],
Cell[88455, 1829, 679, 12, 25, "Print",ExpressionUUID->"2dcbcb74-0814-47bc-b961-56e3c24fff66"],
Cell[89137, 1843, 677, 12, 25, "Print",ExpressionUUID->"200a6e5e-c19c-4fb0-8541-b27094f8028a"],
Cell[89817, 1857, 679, 12, 25, "Print",ExpressionUUID->"2f661c28-2263-47a9-a374-fd1c452cccbf"],
Cell[90499, 1871, 681, 12, 25, "Print",ExpressionUUID->"19d8aafb-560a-4d57-b95c-2a232aa7c2b4"],
Cell[91183, 1885, 679, 12, 25, "Print",ExpressionUUID->"cbeef492-9746-48c3-afe0-25e1429f7683"],
Cell[91865, 1899, 681, 12, 25, "Print",ExpressionUUID->"af1b22d4-24e1-4e5c-bc79-3a805a9deb65"],
Cell[92549, 1913, 679, 12, 25, "Print",ExpressionUUID->"ca3f61bd-e4c4-45a6-b91c-bed36c1fda32"],
Cell[93231, 1927, 679, 12, 25, "Print",ExpressionUUID->"3dbf5aa9-3033-455e-8dd9-e322b1a2e31c"],
Cell[93913, 1941, 679, 12, 25, "Print",ExpressionUUID->"83039675-f9aa-48c4-a8f5-4d22a34b2222"],
Cell[94595, 1955, 679, 12, 25, "Print",ExpressionUUID->"b06d4e36-ede3-4d04-8cf6-5c0a71cee5d5"],
Cell[95277, 1969, 679, 12, 25, "Print",ExpressionUUID->"19b3c102-09ef-4c8c-bc83-6605eb2919d2"],
Cell[95959, 1983, 679, 12, 25, "Print",ExpressionUUID->"04258376-50aa-460e-bb07-7e748b0d3e99"],
Cell[96641, 1997, 679, 12, 25, "Print",ExpressionUUID->"d4e79008-9076-4111-81c5-80bbfd5988ea"],
Cell[97323, 2011, 681, 12, 25, "Print",ExpressionUUID->"b2afb492-ae3e-4ba6-b912-196e652fd63b"],
Cell[98007, 2025, 679, 12, 25, "Print",ExpressionUUID->"f2a1e509-fee5-4496-8869-4d014508c78e"],
Cell[98689, 2039, 679, 12, 25, "Print",ExpressionUUID->"5a3316c9-bd57-4df0-8c2a-15547255091d"],
Cell[99371, 2053, 679, 12, 25, "Print",ExpressionUUID->"84083f87-a213-4b6b-9469-e7c4e684eae9"],
Cell[100053, 2067, 679, 12, 25, "Print",ExpressionUUID->"24a129a2-b43e-4c37-acee-4b3a45b5619d"],
Cell[100735, 2081, 681, 12, 25, "Print",ExpressionUUID->"980612e9-f83f-4a13-b75d-32347360de51"],
Cell[101419, 2095, 678, 12, 25, "Print",ExpressionUUID->"6d9c1fb1-6440-4ada-8482-a2776e4142b8"],
Cell[102100, 2109, 679, 12, 25, "Print",ExpressionUUID->"9be5115c-3b5d-4f05-a599-4f173b0151d4"],
Cell[102782, 2123, 679, 12, 25, "Print",ExpressionUUID->"af36ebca-9bf9-4ae6-8dec-ed4703e725ff"],
Cell[103464, 2137, 679, 12, 25, "Print",ExpressionUUID->"c33be4e8-ac34-4e66-bf40-89b8b6ecdc1b"],
Cell[104146, 2151, 679, 12, 25, "Print",ExpressionUUID->"881bab28-7a7a-4469-97ae-30ddf2f19f81"],
Cell[104828, 2165, 679, 12, 25, "Print",ExpressionUUID->"79273bf2-e581-47ab-bba2-ba2fb811e2a4"],
Cell[105510, 2179, 679, 12, 25, "Print",ExpressionUUID->"d47ba68f-1cfb-4f62-90c6-4d3500e829bf"],
Cell[106192, 2193, 679, 12, 25, "Print",ExpressionUUID->"040ff2cc-ac77-4b1d-be85-04db873b0963"],
Cell[106874, 2207, 679, 12, 25, "Print",ExpressionUUID->"e492d38e-64b4-41be-8fef-33fa48c07a92"],
Cell[107556, 2221, 679, 12, 25, "Print",ExpressionUUID->"df913c9f-2f90-4716-8f1d-049ef0ae7700"],
Cell[108238, 2235, 679, 12, 25, "Print",ExpressionUUID->"da6d1f6b-15ac-404a-9ab4-6d57f815531b"],
Cell[108920, 2249, 679, 12, 25, "Print",ExpressionUUID->"eb071710-3957-419f-b290-7b7c0ff05aa9"],
Cell[109602, 2263, 679, 12, 25, "Print",ExpressionUUID->"e14e4978-e236-4648-a6ae-e028bdf85db2"],
Cell[110284, 2277, 681, 12, 25, "Print",ExpressionUUID->"25e8e22d-0aec-4b4b-a881-e44d8dcc84a0"],
Cell[110968, 2291, 679, 12, 25, "Print",ExpressionUUID->"e5d86611-b3f6-4cfa-8bb2-d7784dc5ed5a"],
Cell[111650, 2305, 679, 12, 25, "Print",ExpressionUUID->"79bfa3b6-fafc-4647-a13b-683542d3890d"],
Cell[112332, 2319, 679, 12, 25, "Print",ExpressionUUID->"d6e9c9d9-d1d6-451f-bce5-bb20009e0868"],
Cell[113014, 2333, 681, 12, 25, "Print",ExpressionUUID->"0b3fbce9-c009-422f-8eba-285e9feabbe3"],
Cell[113698, 2347, 679, 12, 25, "Print",ExpressionUUID->"3c265ded-4335-4554-9b9b-a9ecaaa0faa6"],
Cell[114380, 2361, 681, 12, 25, "Print",ExpressionUUID->"b899c8d9-287f-4bbc-a70d-3246976491f9"],
Cell[115064, 2375, 681, 12, 25, "Print",ExpressionUUID->"0b527b13-2003-4870-be71-3cc13eb40576"],
Cell[115748, 2389, 678, 12, 25, "Print",ExpressionUUID->"5b1e7916-d375-4c22-9a60-f1331743aeb9"],
Cell[116429, 2403, 679, 12, 25, "Print",ExpressionUUID->"206a5a3a-3cd1-4f2a-9881-ae55e34f9815"],
Cell[117111, 2417, 679, 12, 25, "Print",ExpressionUUID->"a613d189-37b9-49c3-96aa-64a2fb1b0238"],
Cell[117793, 2431, 681, 12, 25, "Print",ExpressionUUID->"cd59f579-b25f-469a-a82b-de9e9257f578"],
Cell[118477, 2445, 679, 12, 25, "Print",ExpressionUUID->"845088ad-b3db-484b-868b-2e850f82612a"],
Cell[119159, 2459, 679, 12, 25, "Print",ExpressionUUID->"3bf0f3c7-8533-4f50-b51f-eb4e11abd951"],
Cell[119841, 2473, 679, 12, 25, "Print",ExpressionUUID->"3d7f1f0d-601f-4dae-b142-502b9abc8031"],
Cell[120523, 2487, 679, 12, 25, "Print",ExpressionUUID->"ed51d079-cc21-4a60-b472-6651f81b7a50"],
Cell[121205, 2501, 679, 12, 25, "Print",ExpressionUUID->"67d8f7a1-11b3-4aca-8c02-081c75cbc7ea"],
Cell[121887, 2515, 681, 12, 25, "Print",ExpressionUUID->"23e1b32a-fc2d-4ece-8bac-6deba79a2b9e"],
Cell[122571, 2529, 679, 12, 25, "Print",ExpressionUUID->"de4901e8-a6fd-49cb-9ffa-8b3b7a8fc695"],
Cell[123253, 2543, 679, 12, 25, "Print",ExpressionUUID->"038c3198-f0d0-41df-bcc7-466c6f156137"],
Cell[123935, 2557, 679, 12, 25, "Print",ExpressionUUID->"d85692c2-9b10-4573-81f4-b91d93064b31"],
Cell[124617, 2571, 681, 12, 25, "Print",ExpressionUUID->"173efa63-6581-455b-ad4c-2c4df1ba6d09"],
Cell[125301, 2585, 678, 12, 25, "Print",ExpressionUUID->"85ead3a3-5031-410a-b617-2d1f3d1c6101"],
Cell[125982, 2599, 681, 12, 25, "Print",ExpressionUUID->"fb003eec-e871-4adf-b95f-03c9ce09f2f9"],
Cell[126666, 2613, 681, 12, 25, "Print",ExpressionUUID->"a8658c2c-0bc1-47b5-bfdd-e128f8b3da9c"],
Cell[127350, 2627, 681, 12, 25, "Print",ExpressionUUID->"1aa69d6c-d470-4bbf-a418-094fbc1a0603"],
Cell[128034, 2641, 681, 12, 25, "Print",ExpressionUUID->"6ddbe458-4459-4556-97e9-6e10e07f4085"],
Cell[128718, 2655, 679, 12, 25, "Print",ExpressionUUID->"1a3fda3e-6503-4feb-8802-b7a14335483f"],
Cell[129400, 2669, 678, 12, 25, "Print",ExpressionUUID->"127ff80f-5a1d-49f0-bfd0-d4bb9463d15c"],
Cell[130081, 2683, 679, 12, 25, "Print",ExpressionUUID->"3f761bed-0a65-454b-b680-2380ce28706d"],
Cell[130763, 2697, 679, 12, 25, "Print",ExpressionUUID->"ab333564-b0eb-4152-9163-2b5a50fece97"],
Cell[131445, 2711, 679, 12, 25, "Print",ExpressionUUID->"8c12f57a-06a8-4f17-86b9-58843db57833"],
Cell[132127, 2725, 679, 12, 25, "Print",ExpressionUUID->"f80f9062-8b11-4deb-9e6c-cc41bf4f2cb3"],
Cell[132809, 2739, 679, 12, 25, "Print",ExpressionUUID->"70849470-fc52-4cbf-bd0f-badc670c210e"],
Cell[133491, 2753, 678, 12, 25, "Print",ExpressionUUID->"6a2dff69-335e-424c-9c64-05b8a7649943"],
Cell[134172, 2767, 679, 12, 25, "Print",ExpressionUUID->"ac48039e-3813-42bd-ad6b-ab468784fb97"],
Cell[134854, 2781, 679, 12, 25, "Print",ExpressionUUID->"0def96d2-4410-443d-b807-a43e62278ae5"],
Cell[135536, 2795, 679, 12, 25, "Print",ExpressionUUID->"f7a2a186-3436-495d-9f8e-e04da53d1c98"],
Cell[136218, 2809, 678, 12, 25, "Print",ExpressionUUID->"f20c0bd2-8c77-4373-b6ca-9c34dba8fb86"],
Cell[136899, 2823, 681, 12, 25, "Print",ExpressionUUID->"6a818a07-97fc-4ef5-bbc4-73615ddf4a49"],
Cell[137583, 2837, 679, 12, 25, "Print",ExpressionUUID->"a1e35d4c-aa2d-4cc9-95f3-243311a6473d"],
Cell[138265, 2851, 681, 12, 25, "Print",ExpressionUUID->"4f58cc5c-38ed-4c08-b079-d9eee7f42661"],
Cell[138949, 2865, 679, 12, 25, "Print",ExpressionUUID->"296a6bfc-804b-4a14-875e-e12272f2f7f4"],
Cell[139631, 2879, 679, 12, 25, "Print",ExpressionUUID->"ff0463f9-0357-44fc-b7c6-e543ae2eae4b"],
Cell[140313, 2893, 679, 12, 25, "Print",ExpressionUUID->"62c41720-4a8c-4f53-9b9c-d098fee9182d"],
Cell[140995, 2907, 678, 12, 25, "Print",ExpressionUUID->"ea3dca47-d4c4-4492-b75d-22aaafab2bd2"],
Cell[141676, 2921, 679, 12, 25, "Print",ExpressionUUID->"969ad794-98e2-4273-86a2-d2b609a211a4"],
Cell[142358, 2935, 679, 12, 25, "Print",ExpressionUUID->"83b6d1bb-64a5-4ef3-bf31-6ee5d8066a37"],
Cell[143040, 2949, 679, 12, 25, "Print",ExpressionUUID->"1d3153c7-7944-4ea9-bafe-62566576d9a5"],
Cell[143722, 2963, 678, 12, 25, "Print",ExpressionUUID->"3c511339-9d5e-46ae-9a9b-33f41dbe4d07"],
Cell[144403, 2977, 679, 12, 25, "Print",ExpressionUUID->"935d6440-2bd4-4ce1-8c12-8e2a776b819c"],
Cell[145085, 2991, 679, 12, 25, "Print",ExpressionUUID->"48190296-32ac-4f74-9aa5-70dca3d9a072"],
Cell[145767, 3005, 679, 12, 25, "Print",ExpressionUUID->"9ddbfc4d-df8f-4fc1-9aff-7dc86beb4138"],
Cell[146449, 3019, 679, 12, 25, "Print",ExpressionUUID->"100d10a0-696e-4c38-af49-749ddf510de9"],
Cell[147131, 3033, 679, 12, 25, "Print",ExpressionUUID->"3d56ce73-c8c7-489a-986d-ed7209c87ec7"],
Cell[147813, 3047, 679, 12, 25, "Print",ExpressionUUID->"c27b2844-9d9b-4216-b302-a5a744471687"],
Cell[148495, 3061, 679, 12, 25, "Print",ExpressionUUID->"c60fe071-a478-464a-ba2b-6f0f20ae5ba1"],
Cell[149177, 3075, 679, 12, 25, "Print",ExpressionUUID->"41deb5d2-509e-4807-8fac-b09a2c84c05f"],
Cell[149859, 3089, 679, 12, 25, "Print",ExpressionUUID->"db6cc5f6-6a3f-4023-b689-1cd63fd46bb7"],
Cell[150541, 3103, 678, 12, 25, "Print",ExpressionUUID->"a1e1ff9b-63b6-4710-811a-bca369829012"],
Cell[151222, 3117, 679, 12, 25, "Print",ExpressionUUID->"a9cd0907-a45c-4f1b-9068-67d00ece49c2"],
Cell[151904, 3131, 681, 12, 25, "Print",ExpressionUUID->"60443f85-7165-4fdc-8b68-c6892918cb1a"],
Cell[152588, 3145, 679, 12, 25, "Print",ExpressionUUID->"bd4c3358-b411-4531-a829-fae300c88b22"],
Cell[153270, 3159, 679, 12, 25, "Print",ExpressionUUID->"e02c3218-ebbb-4991-b6cf-3ee6174e8ba7"],
Cell[153952, 3173, 679, 12, 25, "Print",ExpressionUUID->"68252b67-5b01-48be-814b-daa748c92c23"],
Cell[154634, 3187, 679, 12, 25, "Print",ExpressionUUID->"eef656ce-bfc0-409f-b345-032f131275b7"],
Cell[155316, 3201, 679, 12, 25, "Print",ExpressionUUID->"36d9b3b5-4202-4caf-a264-a7967d2f9c5b"],
Cell[155998, 3215, 678, 12, 25, "Print",ExpressionUUID->"5d506e2d-dfc3-4f75-97ac-48cc83527adb"],
Cell[156679, 3229, 679, 12, 25, "Print",ExpressionUUID->"7a49d6b1-bdb9-4d0f-8f7b-bf155adf14f1"],
Cell[157361, 3243, 679, 12, 25, "Print",ExpressionUUID->"7dc43fdc-6d79-445e-a1ee-850191dcd88c"],
Cell[158043, 3257, 679, 12, 25, "Print",ExpressionUUID->"7c23ebc3-4b9a-43c8-b14b-6c81db02aebb"],
Cell[158725, 3271, 679, 12, 25, "Print",ExpressionUUID->"9d712f02-c9ab-40fe-aa1a-ebaaef8d093d"],
Cell[159407, 3285, 679, 12, 25, "Print",ExpressionUUID->"6500dc65-89c7-4270-85fe-a1342944b363"],
Cell[160089, 3299, 679, 12, 25, "Print",ExpressionUUID->"0ca858b5-15f9-4d5d-b71b-bef5cabe3e2f"],
Cell[160771, 3313, 681, 12, 25, "Print",ExpressionUUID->"b8879076-d7c8-4f9e-a86d-a199baea8a60"],
Cell[161455, 3327, 679, 12, 25, "Print",ExpressionUUID->"2da2f058-2b41-4cdb-be89-be57561d0889"],
Cell[162137, 3341, 681, 12, 25, "Print",ExpressionUUID->"20282d97-579f-44c8-ac37-1ad68df5655c"],
Cell[162821, 3355, 679, 12, 25, "Print",ExpressionUUID->"7460e073-a7ff-4b75-9d81-b3c66d58c0c6"],
Cell[163503, 3369, 681, 12, 25, "Print",ExpressionUUID->"bcc1d2bc-4348-40c9-9d3e-991fa5a927ee"],
Cell[164187, 3383, 679, 12, 25, "Print",ExpressionUUID->"469df03a-0373-47f0-ad34-517c1f72b584"],
Cell[164869, 3397, 679, 12, 25, "Print",ExpressionUUID->"084f2042-6925-4f6c-97bb-05919e9f3d09"],
Cell[165551, 3411, 681, 12, 25, "Print",ExpressionUUID->"ad999000-e7c8-4da1-8262-405e36ef229b"],
Cell[166235, 3425, 679, 12, 25, "Print",ExpressionUUID->"2120e966-aa56-46f2-ae8c-2eb76ee2225d"],
Cell[166917, 3439, 679, 12, 25, "Print",ExpressionUUID->"f4a17087-8811-486d-b668-0b3e26dac0d4"],
Cell[167599, 3453, 679, 12, 25, "Print",ExpressionUUID->"be6b15db-5fc2-4ee7-9919-a256376575f7"],
Cell[168281, 3467, 679, 12, 25, "Print",ExpressionUUID->"66f914e7-64d2-4081-a10d-3b9ff138d960"],
Cell[168963, 3481, 679, 12, 25, "Print",ExpressionUUID->"a043e048-51c3-4d11-8127-4affc64eed9b"],
Cell[169645, 3495, 679, 12, 25, "Print",ExpressionUUID->"e57b84ba-d7fd-45a7-9728-2ff14cf5b286"],
Cell[170327, 3509, 679, 12, 25, "Print",ExpressionUUID->"c6d6ef2f-7b39-4686-a166-956c8663e143"],
Cell[171009, 3523, 681, 12, 25, "Print",ExpressionUUID->"de299edd-30cf-4217-9bfb-d8fa03767e4b"],
Cell[171693, 3537, 678, 12, 25, "Print",ExpressionUUID->"bdbc4d73-b6ff-46ad-b867-cc187a7c0c71"],
Cell[172374, 3551, 679, 12, 25, "Print",ExpressionUUID->"554eb7eb-0985-419a-8e16-91c62c3695b6"],
Cell[173056, 3565, 679, 12, 25, "Print",ExpressionUUID->"cb42688a-b2e7-4b5c-992d-cdf02f22afdc"],
Cell[173738, 3579, 681, 12, 25, "Print",ExpressionUUID->"1d733694-99f5-4474-9292-d1bcf73fbf0d"],
Cell[174422, 3593, 679, 12, 25, "Print",ExpressionUUID->"d98c395c-ca79-4102-a631-c075204cb05a"],
Cell[175104, 3607, 679, 12, 25, "Print",ExpressionUUID->"73bd28a8-1bd5-4eef-bfd7-64cb23cd35a2"],
Cell[175786, 3621, 679, 12, 25, "Print",ExpressionUUID->"13b12b3a-76a4-42b8-a644-1b332a312b8d"],
Cell[176468, 3635, 679, 12, 25, "Print",ExpressionUUID->"6c423ec5-15db-4e81-8a94-31978edd7c98"],
Cell[177150, 3649, 681, 12, 25, "Print",ExpressionUUID->"b5a1bd65-869b-4f20-a05d-195eac02f075"],
Cell[177834, 3663, 679, 12, 25, "Print",ExpressionUUID->"9f07ee7c-9f04-452d-98ff-e766f332653e"],
Cell[178516, 3677, 681, 12, 25, "Print",ExpressionUUID->"ec30ad86-c39d-4f3f-9441-22617cf2a7a2"],
Cell[179200, 3691, 681, 12, 25, "Print",ExpressionUUID->"095b2641-e636-4e34-8dd4-f0addee76171"],
Cell[179884, 3705, 679, 12, 25, "Print",ExpressionUUID->"93fca4b9-fbfe-4945-be7b-41696befad92"],
Cell[180566, 3719, 681, 12, 25, "Print",ExpressionUUID->"69f340ee-2768-4925-b225-36b2f2539c91"],
Cell[181250, 3733, 681, 12, 25, "Print",ExpressionUUID->"99fd3319-353c-4067-936c-ec9b07f5c659"],
Cell[181934, 3747, 679, 12, 25, "Print",ExpressionUUID->"dbc7e31c-060a-4e8b-ac3f-b0de289c67fe"],
Cell[182616, 3761, 681, 12, 25, "Print",ExpressionUUID->"a679ce6b-8c53-4b31-a98c-df1799e45e42"],
Cell[183300, 3775, 679, 12, 25, "Print",ExpressionUUID->"1d198430-0892-49a3-80d9-5ca6e93c7433"],
Cell[183982, 3789, 681, 12, 25, "Print",ExpressionUUID->"f148e867-7b7d-4408-998a-e02f1ac79f77"],
Cell[184666, 3803, 679, 12, 25, "Print",ExpressionUUID->"145d978d-2bea-405f-b437-1a3d5e81b6af"],
Cell[185348, 3817, 681, 12, 25, "Print",ExpressionUUID->"b278eddb-c56d-421e-84e8-858111575859"],
Cell[186032, 3831, 679, 12, 25, "Print",ExpressionUUID->"2d252bb4-5673-4d5b-bb4c-3e9d4f790dd7"],
Cell[186714, 3845, 678, 12, 25, "Print",ExpressionUUID->"4b9f9d5c-ea80-4ddd-a7da-88e369f55532"],
Cell[187395, 3859, 679, 12, 25, "Print",ExpressionUUID->"528571ff-34fe-41d9-8929-c42acd0707e9"],
Cell[188077, 3873, 679, 12, 25, "Print",ExpressionUUID->"86b21564-1e51-49e9-916e-51665952d1a5"],
Cell[188759, 3887, 681, 12, 25, "Print",ExpressionUUID->"f74f857a-6a62-423f-b0f8-3f6c2402028b"],
Cell[189443, 3901, 681, 12, 25, "Print",ExpressionUUID->"e5d40135-f8b7-47a8-8819-1f5b716f84b2"],
Cell[190127, 3915, 679, 12, 25, "Print",ExpressionUUID->"6cffac7f-a45d-4aca-b3a6-164bdccf247e"],
Cell[190809, 3929, 681, 12, 25, "Print",ExpressionUUID->"2b36696a-0f6f-4df8-b239-cfe9e7a23b52"],
Cell[191493, 3943, 679, 12, 25, "Print",ExpressionUUID->"adec84ba-aec6-4e22-9fa2-16f2b13bd4e6"],
Cell[192175, 3957, 679, 12, 25, "Print",ExpressionUUID->"6b7e2243-8d05-4404-9cb9-d5a317d8291b"],
Cell[192857, 3971, 681, 12, 25, "Print",ExpressionUUID->"4036d42d-a2dc-4318-bd4f-b87b0a82cecc"],
Cell[193541, 3985, 680, 12, 25, "Print",ExpressionUUID->"3b51f9fe-7e71-4708-b262-d6724358684d"]
}, Open  ]],
Cell[194236, 4000, 118163, 2059, 253, "Output",ExpressionUUID->"fde81db0-fcbd-4978-a4ab-d422d0c1961b"],
Cell[312402, 6061, 242, 3, 92, "Output",ExpressionUUID->"0901b08f-8c22-4e75-a252-db2ccbd700e2"]
}, Open  ]]
}
]
*)

