dir="../results/plotdata"

set terminal epslatex size 3.5,2.62 standalone color colortext 10
set output sprintf("%s.tex",outputname)

set size 1.0,0.65
set multiplot

########### color-palettes ####################################################
gpscriptdir="."
#gpscriptdir="~/PhD/share/plotting"
palette="ylrd.pal"
load gpscriptdir."/".palette
set palette negative

########################################################

set origin 0,0
set size 1.0,0.65

set ylabel '$\langle S_r^z(t) \rangle / (\mu/2)$' offset 0,0
set xlabel '$t \, J$' offset 0,0

xmin = 0
xmax = 50
set xrange [xmin:xmax]
set xtics 0,10,50 offset 0,0
set mxtics 1

ymin = 0
ymax = 0.4
set yrange [ymin:ymax]
set ytics 0,0.4,0.4
set mytics 3

set key at graph 0.32, 0.95 samplen 1

unset colorbox

mod(x,m)=x-(floor(x/m)*m)

plot for  [i=0:4] sprintf("< awk '$1==%d' %s/prediction_all_amplitudes_01.dat",mod(i+10,20)+1,dir) using 2:($3/0.05):(i) every 20 title '' with points pt 6 ps 1.2 lw 2 lc palette

plot for [i=0:4] sprintf("< awk '$2==%d' %s/L4_untypical_Quantum_chain_density_L20_Delta1.5_g0.1000_m0.1000_N_E101260_t50.0_dt0.01.dat",i,dir) using 1:(0.5*($3-0.5)/0.05):(i) ti '' w l  dt 1 lw 3 lc palette 

p  NaN ti 'Eq.~(11)' with points pt 6 ps 1 lw 2 lc rgb "black",\
    NaN ti 'data' with lines  dt 1      lw 3 lc rgb "black" 


unset arrow
unset label
unset object

unset logscale x
unset logscale y
