set terminal epslatex size 3.5,2.62 standalone color colortext 10
set output sprintf("%s.tex",outputname)

set size 1.0,0.65
set multiplot

########################################################

set origin 0,0
set size 1.0,0.65

set ylabel '$\Sigma^2(t)$' offset 0,0
set xlabel '$t \, J$' offset 0,0

set log x
xmin = 1
xmax = 100
set xrange [xmin:xmax]
#set xtics 0,100,100 offset 0,0
#set mxtics 10

set log y
ymin = 0.1
ymax = 100
set yrange [ymin:ymax]
#set ytics 0,100,100
#set mytics 10

set key at graph 1.0, 0.4 samplen 1

plot "../results/plotdata//perfect/variance_perfect_50.dat"  using 1:2         title 'Eq.\ (11), $N=50$'  with points pt 6 ps 1 lw 1 lc rgb "red" ,\
     "../results/plotdata//perfect/variance_perfect_100.dat" using 1:2 every 2 title 'Eq.\ (11), $N=100$' with points pt 7 ps 1 lw 1 lc rgb "orange" ,\
     0.66*x                                                        title '$0.66 \, t J$'      with lines dt 1 lw 4 lc rgb "black"
      
unset arrow
unset label
unset object

unset logscale x
unset logscale y
