dir="../results/plotdata"

set terminal epslatex size 3.5,2.62 standalone color colortext 10
set output sprintf("%s.tex",outputname)

set size 1.0,1.8
set multiplot

########### color-palettes ####################################################
gpscriptdir="."
#gpscriptdir="~/PhD/share/plotting"
palette="rdylbu.pal"
load gpscriptdir."/".palette
#set palette negative            

########################################################

set origin 0,1.2
set size 1.0,0.6

set ylabel '$\langle S_{r_0}^z(t) \rangle / (\mu/2)$' offset 0,0
set xlabel '' offset 0,0

xmin = 0
xmax = 50
set xrange [xmin:xmax]
set xtics 0,10,50 offset 0,0
set mxtics 1
set xtics ("" 0, "" 10, "" 20, "" 30, "" 40, "" 50)

ymin = 0
ymax = 1
set yrange [ymin:ymax]
set ytics 0,0.5,1
set mytics 5

unset colorbox

set label '(a)' at graph 0.05, 0.85

set key box width 0 height 0.2 opaque
set key at graph 0.97, 0.95 samplen 1

vlw=3
vplw=2

plot '../results/plotdata/prediction_1_amplitudes.dat' using 1:($2/0.05):(0)           title '$\gamma/J = 1.00$' with lines dt 1       lw vlw lc palette ,\
     '../results/plotdata/prediction_1_fengping_amplitudes.dat'   using 1:($2/0.05):(0) every 75  title ''                  with points pt 4 ps 1 lw vplw lc palette ,\
     '../results/plotdata/prediction_05_amplitudes.dat'           using 1:($2/0.05):(1)           title '$\gamma/J = 0.50$' with lines dt 1       lw vlw lc palette ,\
     '../results/plotdata/prediction_05_fengping_amplitudes.dat'  using 1:($2/0.05):(1) every 75  title ''                  with points pt 4 ps 1 lw vplw lc palette ,\
     '../results/plotdata/prediction_025_amplitudes.dat'          using 1:($2/0.05):(2)           title '$\gamma/J = 0.25$' with lines dt 1       lw vlw lc palette,\
     '../results/plotdata/prediction_025_fengping_amplitudes.dat' using 1:($2/0.05):(2) every 75  title ''                  with points pt 4 ps 1 lw vplw lc palette ,\
     '../results/plotdata/prediction_01_amplitudes.dat'           using 1:($2/0.05):(2.8)           title '$\gamma/J = 0.10$' with lines dt 1       lw vlw lc palette ,\
     '../results/plotdata/prediction_01_fengping_amplitudes.dat'  using 1:($2/0.05):(2.8) every 75  title ''                  with points pt 4 ps 1 lw vplw lc palette ,\
     '../results/plotdata/prediction_001_amplitudes.dat'          using 1:($2/0.05):(4)           title '$\gamma/J = 0.01$' with lines dt 1       lw vlw lc palette ,\
     '../results/plotdata/prediction_001_fengping_amplitudes.dat' using 1:($2/0.05):(4) every 75  title ''                  with points pt 4 ps 1 lw vplw lc palette ,\
     '../results/plotdata/reference2.dat'                         using 1:(2*($2-0.5)):(6)        title '$\gamma/J = 0.00$' with lines dt 1       lw vlw lc palette 

unset arrow
unset label
unset object

unset logscale x
unset logscale y

########################################################

set origin 0,0.65
set size 1.0,0.65

set ylabel '$\langle S_{r_0}^z(t) \rangle / (\mu/2)$' offset 0,0
set xlabel '$t \, J$' offset 0,0

xmin = 0
xmax = 50
set xrange [xmin:xmax]
set xtics 0,10,50 offset 0,0
set mxtics 1

ymin = 0
ymax = 1
set yrange [ymin:ymax]
set ytics 0,0.5,1
set mytics 5

set label '(b)' at graph 0.05, 0.85

set key box width 2.5 height 0.2 opaque
set key at graph 0.97, 0.95 samplen 1

set arrow from 25,0 to 25,0.70 lw 2 lc rgb 'black' head filled front
set label '$\gamma$' at graph 0.52, 0.70

plot '../results/plotdata/prediction_1_mod_amplitudes.dat'            using 1:($2/0.05):(0)          title ''       with lines dt 1       lw vlw lc palette ,\
     '../results/plotdata/prediction_1_mod_fengping_amplitudes.dat'   using 1:($2/0.05):(0) every 75 title ''       with points pt 4 ps 1 lw vplw lc palette ,\
     '../results/plotdata/prediction_05_mod_amplitudes.dat'           using 1:($2/0.05):(1)          title ''       with lines dt 1       lw vlw lc palette ,\
     '../results/plotdata/prediction_05_mod_fengping_amplitudes.dat'  using 1:($2/0.05):(1) every 75 title ''       with points pt 4 ps 1 lw vplw lc palette ,\
     '../results/plotdata/prediction_025_mod_amplitudes.dat'          using 1:($2/0.05):(2)          title ''       with lines dt 1       lw vlw lc palette ,\
     '../results/plotdata/prediction_025_mod_fengping_amplitudes.dat' using 1:($2/0.05):(2) every 75 title ''       with points pt 4 ps 1 lw vplw lc palette ,\
     '../results/plotdata/prediction_01_mod_amplitudes.dat'           using 1:($2/0.05):(2.8)          title ''       with lines dt 1       lw vlw lc palette ,\
     '../results/plotdata/prediction_01_mod_fengping_amplitudes.dat'  using 1:($2/0.05):(2.8) every 75 title ''       with points pt 4 ps 1 lw vplw lc palette ,\
     '../results/plotdata/prediction_001_mod_amplitudes.dat'          using 1:($2/0.05):(4)          title '' with lines dt 1       lw vlw lc palette ,\
     '../results/plotdata/prediction_001_mod_fengping_amplitudes.dat' using 1:($2/0.05):(4) every 75 title '' with points pt 4 ps 1 lw vplw lc palette ,\
     '../results/plotdata/reference2.dat'                         using 1:(0*($2-0.5)):(6)        title '' with lines dt 1       lw vlw lc palette ,\
     
p  NaN ti '$N=20$' with lines dt 1       lw vlw lc rgb "black",\
    NaN ti '$N=36$' with points pt 4 ps 1 lw vplw lc rgb "black" 

unset arrow
unset label
unset object

unset logscale x
unset logscale y

########################################################

set origin 0.02,0
set size 1.06,0.75

set xlabel '$t \, J$' offset 0,0
set ylabel '$r$' offset -1.5,0

set label '(c) $\gamma/J = 0.1$ in (b)' at graph 0.05, 0.85 front textcolor rgb "white" 

xmin =  0
xmax = 50
set xrange [xmin:xmax]
set xtics 0,10,50 offset 0,0
set mxtics 1

ymin =  1
ymax = 20
set yrange [ymin:ymax]
set ytics 1,19,20 offset 0,0
set mytics 1

zmin = -0.0001
zmax =  0.02
set zrange [zmin:zmax]
set ztics 0,0.01,0.02

set pm3d corners2color c2
set view map
set palette defined (0 0 1 0, 0.3333 0 0 1, 0.6667 1 0 0, 1 1 0.6471 0 )
set palette positive
#set cbtics 0,0.5,0.5 offset 0,0
unset colorbox
unset key

L = 20
shift = 1
mod(x,m) = x - (floor(x/m)*m)

splot '../results/plotdata//prediction_all_amplitudes_01.dat' using 2:1:3 title '' with pm3

unset arrow
unset label
unset object
