dir="../results/plotdata"

set terminal epslatex size 3.5,2.62 standalone color colortext 10
set output sprintf("%s.tex",outputname)

set size 1.0,1.33
set multiplot

########### color-palettes ####################################################
gpscriptdir="."
#gpscriptdir="~/PhD/share/plotting"
palette="ylrd.pal"
load gpscriptdir."/".palette
set palette negative

########################################################

set origin 0,0.85
set size 1.0,0.50

set ylabel '$\langle S_r^z(t) \rangle / (\mu/2)$' offset 0,0
set xlabel '' offset 0,0

set label '(a) $\gamma/J = 0.1$' at graph 0.65, 0.15

xmin = 0
xmax = 50
set xrange [xmin:xmax]
set xtics 0,10,50 offset 0,0
set mxtics 1
set xtics ("" 10, "" 20, "" 30, "" 40, "" 50)

ymin = 0
ymax = 0.3
set yrange [ymin:ymax]
set ytics 0,0.3,0.3
set mytics 3

set arrow from 28,0.27 to 28,0.0 lw 2 lc rgb 'black' head filled front
set label '$l=0$' at graph 0.42, 0.9
set label '$l=4$' at graph 0.42, 0.1

unset colorbox

set key at graph 0.27, 0.95 samplen 0

mod(x,m)=x-(floor(x/m)*m)

plot for [i=0:4] sprintf("< awk '$2==%d' %s/L4_Quantum_chain_density_L20_Delta1.5_g0.1000_m0.1000_N_E401420_t50.0_dt0.01.dat",i,dir) using 1:(0.5*($3-0.5)/0.05):(i) ti '' w l  dt 1 lw 3 lc palette 

plot for  [i=0:4] sprintf("< awk '$1==%d' %s/prediction_all_amplitudes_01.dat",mod(i+10,20)+1,dir) using 2:($3/0.05):(i) every 20 title '' with points pt 6 ps 1.2 lw 2 lc palette,\
    for  [i=0:4] sprintf("< awk '$1==%d' %s/prediction_all_amplitudes_01_fengping.dat",mod(i+18,36)+1,dir) using 2:($3/0.05)  every 4  title '' with points pt 7 ps 1.2 lw 2 lc rgb "black" 

p  NaN ti '$N=20$' with points pt 6 ps 1.2 lw 2 lc rgb "black",\
    NaN ti '$N=36$' with points pt 7 ps 1.2 lw 2 lc rgb "black" 
# NaN ti 'data' w p pt 6 ps 1 lw 2 lc rgb "black"


unset arrow
unset label
unset object

unset logscale x
unset logscale y

########################################################

set origin 0,0.45
set size 1.0,0.50

set ylabel '$\langle S_r^z(t) \rangle / (\mu/2)$' offset 0,0
set xlabel '' offset 0,0

set label '(b) $\gamma/J = 1.0$' at graph 0.65, 0.15

xmin = 0
xmax = 50
set xrange [xmin:xmax]
set xtics 0,10,50 offset 0,0
set mxtics 1
set xtics ("" 10, "" 20, "" 30, "" 40, "" 50)

ymin = 0
ymax = 0.5
set yrange [ymin:ymax]
set ytics 0,0.5,0.5
set mytics 5

set key at graph 0.27, 0.95 samplen 0
    
plot for [i=0:4] sprintf("< awk '$2==%d' %s/L4_Quantum_chain_density_L20_Delta1.5_g1.0000_m0.1000_N_E245080_t50.0_dt0.01.dat",i,dir) using 1:(0.5*($3-0.5)/0.05):(i) ti '' w l  dt 1 lw 3 lc palette 

plot for  [i=0:4] sprintf("< awk '$1==%d' %s/prediction_all_amplitudes_1.dat",mod(i+10,20)+1,dir) using 2:($3/0.05):(i) every 20 title '' with points pt 6 ps 1.2 lw 2 lc palette,\
    for  [i=0:4] sprintf("< awk '$1==%d' %s/prediction_all_amplitudes_1_fengping.dat",mod(i+18,36)+1,dir) using 2:($3/0.05)  every 4  title '' with points pt 7 ps 1.2 lw 2 lc rgb "black" 

unset arrow
unset label
unset object

unset logscale x
unset logscale y

########################################################

set origin 0,0
set size 1.0,0.55

set ylabel '$\langle S_r^z(t) \rangle / (\mu/2)$' offset 0,0
set xlabel '$t \, J$' offset 0,0

set label '(c) $\mu = 1.0$' at graph 0.65, 0.15

xmin = -.0
xmax = 50.
set xrange [xmin:xmax]
set xtics 0,10,50 offset 0,0
set mxtics 1

ymin = -.0
ymax = 0.4
set yrange [ymin:ymax]
set ytics 0,0.4,0.4
set mytics 4

set key at graph 0.32, 0.95 samplen 1
    
plot for [i=0:4] sprintf("< awk '$2==%d' %s/L4_Quantum_chain_density_L20_Delta1.5_g0.1000_m1.0000_N_E61200_t50.0_dt0.01.dat",i,dir) using 1:(0.5*($3-0.5)/0.5):(i) ti '' w l  dt 1 lw 3 lc palette 

plot for  [i=0:4] sprintf("< awk '$1==%d' %s/prediction_all_amplitudes_01_1.dat",mod(i+10,20)+1,dir) using 2:($3/0.5):(i) every 20 title '' with points pt 6 ps 1.2 lw 2 lc palette,\
    for  [i=0:4] sprintf("< awk '$1==%d' %s/prediction_all_amplitudes_01_1_fengping.dat",mod(i+18,36)+1,dir) using 2:($3/0.5)  every 4  title '' with points pt 7 ps 1.2 lw 2 lc rgb "black" 

p  NaN ti 'Eq.~(11)' with points pt 6 ps 1 lw 2 lc rgb "black",\
    NaN ti 'data' with lines  dt 1      lw 3 lc rgb "black" 
# NaN ti 'data' w p pt 6 ps 1 lw 2 lc rgb "black"

      
unset arrow
unset label
unset object

unset logscale x
unset logscale y
