set terminal epslatex size 3.5,2.62 standalone color colortext 10
set output sprintf("%s.tex",outputname)

set size 1.0,0.86
set multiplot

########################################################

set origin 0,0.40
set size 0.60,0.49

set ylabel '$\bar{d}_r(t)$' offset 2,0
set xlabel '' offset 0,0

set label '(a) $t J = 5$' at graph 0.05, 0.88

xmin = 1
xmax = 20
set xrange [xmin:xmax]
set xtics 1,19,20 offset 0,0
set mxtics 1
set xtics ("" 1, "" 20)

ymin = -0.001
ymax =  0.020
set yrange [ymin:ymax]
set ytics 0,0.020,0.020
set mytics 4

set key at graph 0.98, 0.8 samplen 0

L = 20
shift = 1
mod(x,m) = x - (floor(x/m)*m)

A = 0.009
x0 = 11
sigma = 3.1
f(x) = A*exp(-(x-x0)**2/sigma**2)

plot '../results/plotdata//testa2_5.dat'       using (mod($1+L/2,L)+shift):($2-0.5) title 'data' with points pt 6 ps 1 lw 1 lc rgb "orange" ,\
     '../results/plotdata//Eq20_profiles5.dat' using 1:3                            title ''     with points pt 2 ps 1 lw 1 lc rgb "red" ,\
     f(x)                                                               title ''     with lines  dt 1      lw 2 lc rgb "blue"

unset arrow
unset label
unset object

unset logscale x
unset logscale y

########################################################

set origin 0.52,0.40
set size 0.48,0.49

set ylabel '' offset 0,0
set xlabel '' offset 0,0

set label '(b) $t J = 15$' at graph 0.05, 0.88

xmin = 1
xmax = 20
set xrange [xmin:xmax]
set xtics 1,19,20 offset 0,0
set mxtics 1
set xtics ("" 1, "" 20)

ymin = -0.001
ymax =  0.020
set yrange [ymin:ymax]
set ytics 0,0.020,0.020
set mytics 4
set ytics ("" 0, "" 0.005, "" 0.010, "" 0.015, "" 0.020)

set key at graph 0.98, 0.8 samplen 0

L = 20
shift = 1
mod(x,m) = x - (floor(x/m)*m)

set style fill noborder

plot '../results/plotdata//testa2_15.dat'       using (mod($1+L/2,L)+shift):($2-0.5) title ''           with points pt 6 ps 1 lw 1 lc rgb "orange" ,\
     '../results/plotdata//Eq20_profiles15.dat' using 1:3                            title 'Eq.\ (11)'  with points pt 2 ps 1 lw 1 lc rgb "red" ,\
     
unset arrow
unset label
unset object

unset logscale x
unset logscale y

########################################################

set origin 0,0
set size 0.60,0.50

set ylabel '$\bar{d}_r(t)$' offset 2,0
set xlabel '$r$' offset 0,1

set label '(c) $t J = 25$' at graph 0.05, 0.88

xmin = 1
xmax = 20
set xrange [xmin:xmax]
set xtics 1,19,20 offset 0,0
set mxtics 1

ymin = -0.001
ymax =  0.020
set yrange [ymin:ymax]
set ytics 0,0.020,0.020
set mytics 4

set key at graph 0.35, 0.3 samplen 1

L = 20
shift = 1
mod(x,m) = x - (floor(x/m)*m)

set style fill pattern 4

plot 0.0027 with filledcurve y1=0 title '' lc rgb "blue" ,\
     '../results/plotdata//testa2_25.dat' using (mod($1+L/2,L)+shift):($2-0.5) title '' with points pt 6 ps 1 lw 1 lc rgb "orange" ,\
     '../results/plotdata//Eq20_profiles25.dat' using 1:3                      title '' with points pt 2 ps 1 lw 1 lc rgb "red"
     
unset arrow
unset label
unset object

unset logscale x
unset logscale y

########################################################

set origin 0.52,0
set size 0.48,0.50

set ylabel '' offset 0,0
set xlabel '$r$' offset 0,1

set label '(d) $t J = 35$' at graph 0.05, 0.88

xmin = 1
xmax = 20
set xrange [xmin:xmax]
set xtics 1,19,20 offset 0,0
set mxtics 1

ymin = -0.001
ymax =  0.020
set yrange [ymin:ymax]
set ytics 0,0.020,0.020
set mytics 4
set ytics ("" 0, "" 0.005, "" 0.010, "" 0.015, "" 0.020)

set key at graph 0.35, 0.3 samplen 1

L = 20
shift = 1
mod(x,m) = x - (floor(x/m)*m)

set style fill pattern 4

plot 0.0047 with filledcurve y1=0 title '' lc rgb "blue" ,\
     '../results/plotdata//testa2_35.dat'       using (mod($1+L/2,L)+shift):($2-0.5) title '' with points pt 6 ps 1 lw 1 lc rgb "orange" ,\
     '../results/plotdata//Eq20_profiles35.dat' using 1:3                            title '' with points pt 2 ps 1 lw 1 lc rgb "red"

unset arrow
unset label
unset object

unset logscale x
unset logscale y
