set terminal epslatex size 3.5,2.62 standalone color colortext 10
set output sprintf("%s.tex",outputname)

set size 1.0,1.0
set multiplot

########################################################

set origin 0,0.48
set size 1.0,0.55

set ylabel '$d_{r_0}(t)$' offset 1.5,0
set xlabel '' offset 0,0

set label '(a) $L_1, L_1, \ldots$' at graph 0.65, 0.10

set label '\colorbox{white}{$2 \langle S_{r_0}^z(t) S_{r_0}^z(0) \rangle$}' at graph 0.24, 0.77 front
set arrow from 15,0.3 to 15,0.05 lw 2 lc rgb 'black' head filled front

xmin = 0
xmax = 50
set xrange [xmin:xmax]
set xtics 0,10,50 offset 0,0
set mxtics 1
set xtics ("" 10, "" 20, "" 30, "" 40, "" 50)

ymin = -0.1
ymax =  0.5
set yrange [ymin:ymax]
set ytics 0,0.5,0.5
set mytics 5

set key at graph 0.51, 0.15 samplen 0.5 width -3 vertical maxrows 1

plot '../results/plotdata//testb2.dat'     using 1:($2-0.5) title 'data'       with points pt 6 ps 1 lw 1 lc rgb "orange" ,\
     '../results/plotdata//reference2.dat' using 1:($2-0.5) title ''           with lines  dt 1      lw 2 lc rgb "blue" ,\
     '../results/plotdata//compb.dat'      using 1:2        title 'Eq.\ (11)'  with lines  dt 1      lw 2 lc rgb "red" ,\
     0.5/20                                     title ''           with lines  dt 2      lw 2 lc rgb "gray"

unset arrow
unset label
unset object

unset logscale x
unset logscale y

#####################################################

set origin 0.045,0
set size 0.955,0.60

set ylabel '$\bar{d}_{r_0}(t) / (\mu/2)$' offset 0,0
set xlabel '$t \, J$' offset 0,0.4

set label '(b) $\mu = 0.1$' at graph 0.65, 0.10

set label 'Fig.\ 3' at graph 0.04, 0.76
set arrow from 5,0.6 to 5,0.2 lw 2 lc rgb 'black' head filled front

xmin = 0
xmax = 50
set xrange [xmin:xmax]
set xtics 0,10,50 offset 0,0
set mxtics 1

ymin = -0.2
ymax =  1.0
set yrange [ymin:ymax]
set ytics 0,1.0,1.0
set mytics 5

set key at graph 0.31, 0.15 samplen 0.5 width -3 vertical maxrows 1

plot '../results/plotdata//testa2.dat'     using 1:(($2-0.5)/0.05)     title ''          with points pt 6 ps 1 lw 1 lc rgb "orange" ,\
     '../results/plotdata//reference2.dat' using 1:(0.1*($2-0.5)/0.05) title ''          with lines  dt 1      lw 2 lc rgb "blue" ,\
     '../results/plotdata//Eq20.dat'       using 1:($2/0.05)           title ''          with lines  dt 1      lw 2 lc rgb "red" ,\
     '../results/plotdata//amplitudes.dat' using 1:($2/0.05)           title 'Eq.\ (12)' with points pt 2 ps 1 lw 2 lc rgb "green" ,\
     1.0/20                                                title ''          with lines  dt 2      lw 2 lc rgb "gray"
     
unset arrow
unset label
unset object

unset logscale x
unset logscale y
