set terminal epslatex size 3.5,2.62 standalone color colortext 10
set output sprintf("%s.tex",outputname)

set size 1.0,0.9
set multiplot


########################################################

set origin 0.025,0.40
set size 1.05,0.55

#set xlabel '$t \, J$' offset 0,0
set ylabel '$r$' offset -1,0

set label '(b) $\Delta =1.5, \mu = \gamma/J = 0.1$' at graph 0.03, 0.85 front textcolor rgb "white" 

xmin =  0
xmax = 50
set xrange [xmin:xmax]
set xtics 0,10,50 offset 0,0
set mxtics 1


ymin =  1
ymax = 20
set yrange [ymin:ymax]
set ytics 1,19,20 offset 0,0
set mytics 1

zmin = -0.0001
zmax =  0.02
set zrange [zmin:zmax]
set ztics 0,0.01,0.02

set pm3d corners2color c2
set view map
set palette defined (0 0 1 0, 0.3333 0 0 1, 0.6667 1 0 0, 1 1 0.6471 0 )
#unset cbtics 0,0.01,0.02 offset 0,0
unset colorbox
unset key

L = 20
shift = 1
mod(x,m) = x - (floor(x/m)*m)

#splot 'plotdata/prediction_all_amplitudes_01.dat' using 1:2:3 title '' with pm3

splot '../results/plotdata//L4_Quantum_chain_density_L20_Delta1.5_g0.1000_m0.1000_N_E401420_t50.0_dt0.01.dat_sort' using 2:1:(0.5*($3-0.5)) title '' with pm3

unset arrow
unset label
unset object

########################################################

set origin 0,0
set size 1.0,0.5

set ylabel '$\Sigma^2(t)$' offset 0,0
set xlabel '$t \, J$' offset 0,0.6

set label '(c)' at graph 0.03, 0.85 front textcolor rgb "black" 

unset colorbox

set log x
xmin = 1
xmax = 50
set xrange [xmin:xmax]
#set xtics 0,10,50 offset 0,0
set mxtics 10

set xtics add ('$50$' 50)

set log y
ymin =  0.1
ymax = 40
set yrange [ymin:ymax]
set ytics 0.1,10,100
set mytics 10

set key at graph 1.0, 0.6 samplen 2

plot "../results/plotdata//variance1.dat"  title '$\Delta = 1.0$'                      with points pt 6 ps 1 lw 1 lc rgb "red" ,\
     "../results/plotdata//variance15.dat" title '$\Delta = 1.5$'                      with points pt 4 ps 1 lw 1 lc rgb "orange" ,\
     "../results/plotdata//variance15_1.dat" title '$\Delta = 1.5$ ($\gamma / J = 1.0$)' with lines dt 1 lw 4 lc rgb "blue"

set key at graph 0.45, 0.92 samplen 2

plot 0.4*x**(4.0/3.0)          title '$\propto t^{4/3}$'                   with lines dt 2 lw 4 lc rgb "black" ,\
     0.6*x                     title '$\propto t$'                         with lines dt 3 lw 4 lc rgb "black"
      
unset arrow
unset label
unset object

unset logscale x
unset logscale y
