  @Test
  def checkDronesSimple(): Unit = {

    val manager = OWLManager.createOWLOntologyManager()
    val factory = manager.getOWLDataFactory()
    def owlClass(name: String): OWLClass = {
      factory.getOWLClass(IRI.create("http://www.semanticweb.org/alisa/ontologies/2023/concrete-domain/drone-fractions#" + name))
    }

    val classificationResult = testCase("/simple/cd1/drones/drones.owl",
 "/simple/cd1/drones/drones.txt")

    assertFalse(classificationResult(owlClass("Status"))(owlClass("AllSensorsAreImpaired")))
    assert(classificationResult(owlClass("Status"))(owlClass("HalfSensorsAreImpaired")))
    assertFalse(classificationResult(owlClass("Status"))(owlClass("QuarterSensorsAreImpaired")))
    assert(classificationResult(owlClass("Status"))(owlClass("AllPropellersAreNonoperating")))
    assertFalse(classificationResult(owlClass("Status"))(owlClass("HalfPropellersAreNonoperating")))
  }
