 @Test
  def testCoffeeProportionSmall(): Unit = {

    val manager = OWLManager.createOWLOntologyManager()
    val factory = manager.getOWLDataFactory()
    def owlClass(name: String): OWLClass = {
      factory.getOWLClass(IRI.create("http://www.semanticweb.org/alisa/ontologies/2022/concrete-domain/" + name))
    }

    setOntFile("/simple/cd1/coffee.owl")
    setConFile("/simple/cd1/coffee.txt")

    setClassificationResult(testCase(ontFile, conFile))

    assertAndProve(owlClass("Order"), owlClass("TotalAmount"), drawProof = false)

    assertAndProve(owlClass("Order"), owlClass("Americano"), drawProof = false)
    assertAndProve(owlClass("Order"), owlClass("BlackCoffee"), drawProof = false)
    assertAndProve(owlClass("Order"), owlClass("FlatWhite"), drawProof = false)
    assertAndProve(owlClass("Order"), owlClass("Latte"), drawProof = false)
    assertAndProve(owlClass("Order"), owlClass("Capuccino"), drawProof = false)
    assertAndProve(owlClass("Order"), owlClass("Ristretto"), drawProof = false)
    assertAndProve(owlClass("Order"), owlClass("Macchiato"), drawProof = false)
  }
