import random
import sys

def gen_objects(n,env,mysize):
    output = list()
    
    list_obj = ["Human", "Drone", "Tree"]
    if env != "Sunny":
        list_obj.append("WetDrone")
        
    half = round(n/2)
    for i in range(half): #first object are always at risk
        o = Object(random.choice(list_obj), random.randint(1, 6),env,mysize)
        while not o.risk:
            o = Object(random.choice(list_obj), random.randint(1, 6),env,mysize)
        output.append(o)
    for i in range(n - half):
        o = Object(random.choice(list_obj), random.randint(7, 15),env,mysize)
        while o.risk:
            o = Object(random.choice(list_obj), random.randint(1, 6),env,mysize)
        output.append(o)
    return output

SmallDroneOpDistances = {
    "SafeOpDist": 1,
    "SafeOpDistLowVis": 3,
    "SafeOpDistMovObj": 2,
    "SafeOpDistMovObjLowVis": 5
}

BigDroneOpDistances = {
    "SafeOpDist": 3,
    "SafeOpDistLowVis": 5,
    "SafeOpDistMovObj": 4,
    "SafeOpDistMovObjLowVis": 7
}

class Object:
  def __init__(self, type, distance,env,mysize):
    self.type = type

    self.env = env
    self.distance = distance
    if (type == "WetDrone"):
        self.reqsafedistance = "SafeOpDistMovObjLowVis"
    elif env == "Sunny":
        if type == "Tree":
            self.reqsafedistance = "SafeOpDist"
        else: #Human or Drone
            self.reqsafedistance = "SafeOpDistMovObj"
    else: #rainy, snowy, foggy
        if type == "Tree":
            self.reqsafedistance = "SafeOpDistLowVis"
        else: #Human or Drone
            self.reqsafedistance = "SafeOpDistMovObjLowVis"

    if ((mysize == "Big") and (BigDroneOpDistances[self.reqsafedistance] < distance)) or ((mysize == "Small") and (SmallDroneOpDistances[self.reqsafedistance] < distance)):
        self.risk = False
    else:
        self.risk = True
        
  def __str__(self):
    return f"My drone is {mysize}. Object {self.type} at {self.distance} under {self.env} is risky:{self.risk}"

def write_constraints(myworld, filename,mysize):
#start creating a constraint file
    content = "PREFIX : <http://www.semanticweb.org/alisa/ontologies/2023/concrete-domain/drone-distance#> \n\n"
    content += f"# my drone is {mysize} \n"
    if mysize == "Big":
        weight = random.randint(1000, 10000) #in grams
    else:
        weight = random.randint(100, 999) #in grams
    content += f"MyWeight: hasWeight = {int(weight)} \n\n"
    for i in range(len(myworld)):
        content += f"# Obj{i} is unsafe: {myworld[i].risk}\n"
        content += f"Obj{i}-d: distance = {int(myworld[i].distance)} \n"
        for j in range(4):
            if mysize == "Small":
                e = int(myworld[i].distance)-list(SmallDroneOpDistances.values())[j]
            else:
                e = int(myworld[i].distance)-list(BigDroneOpDistances.values())[j]
            content += f"Obj{i}-e{j}: epsilon{j} = {e} \n"
        content += "\n"
    
    content += "\n##### TBox constrains - OperatingDistances (always hold by gen.py wrt a size)\n\n"
    k = 0
    for j in ["OpDist","OpDistLowVis","OpDistMovObj","OpDistMovObjLowVis"]:
        content += f"{j}Small: epsilon{k} + {list(SmallDroneOpDistances.values())[k]} = distance\n\n"
        k += 1
    k = 0
    for j in ["OpDist","OpDistLowVis","OpDistMovObj","OpDistMovObjLowVis"]:
        content += f"{j}Big: epsilon{k} + {list(BigDroneOpDistances.values())[k]} = distance\n\n"
        k += 1
    content +="\n##### TBox constrains (to be checked by the reasoner for different situations)\n\nSafeOpDist: epsilon0 > 0\n\nSafeOpDistLowVis: epsilon1 > 0\n\nSafeOpDistMovObj: epsilon2 > 0\n\nSafeOpDistMovObjLowVis: epsilon3 > 0\n\nBig: hasWeight > 1000\n\nSmall: hasWeight > 100\n\n"
    #last construction forces to define a concept even if my drone is not Big

    try:
        f = open(filename, "x")
    except:
        rewrite = input("The constraint file already exists. Do you want to re-write it? (y/n)\n")
        if rewrite == 'n':
            exit
        f = open(filename, "w")
    f.write(content)
    f.close()

def write_ontology(myworld,env,filename,mysize):
    content = "@prefix : <http://www.semanticweb.org/alisa/ontologies/2023/concrete-domain/drone-distance#> .\n@prefix owl: <http://www.w3.org/2002/07/owl#> .\n@prefix rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#> .\n@prefix xml: <http://www.w3.org/XML/1998/namespace> .\n@prefix xsd: <http://www.w3.org/2001/XMLSchema#> .\n@prefix rdfs: <http://www.w3.org/2000/01/rdf-schema#> .\n@base <http://www.semanticweb.org/alisa/ontologies/2023/concrete-domain/drone-distance> .\n\n<http://www.semanticweb.org/alisa/ontologies/2023/concrete-domain/drone-distance> rdf:type owl:Ontology .\n\n #################################################################\n#    Object Properties\n#################################################################\n\n :environment rdf:type owl:ObjectProperty.\n\n :nearme rdf:type owl:ObjectProperty .\n\n :exists rdf:type owl:ObjectProperty .\n\n#################################################################\n#    Data properties\n#################################################################\n\n"
    
    for j in ["distance","epsilon0","epsilon1","epsilon2","epsilon3","hasWeight"]:
        content += f" :{j} rdf:type owl:DatatypeProperty ;\n          rdfs:domain :Object ;\n                                                                                       rdfs:range owl:real .\n\n"
    content += "#################################################################\n#    Classes\n#################################################################\n\n"
    content += ":Object rdf:type owl:Class .\n\n:PartiallySafe rdf:type owl:Class .\n\n:MyDroneSize rdf:type owl:Class .\n\n:ABoxConstraints rdf:type owl:Class .\n\n:SafeSmall rdf:type owl:Class .\n\n:SafeBig rdf:type owl:Class .\n\n:Sunny rdf:type owl:Class .\n\n:ConstraintsOfPresence rdf:type owl:Class .\n\n:MyWeight rdf:type owl:Class .\n\n:SafeDistances rdf:type owl:Class .\n\n:LowVisibility rdf:type owl:Class ;\n               owl:disjointWith :Object .\n\n"

    content += ":World rdf:type owl:Class ;\n       rdfs:subClassOf [ owl:intersectionOf ( "
    for i in range(len(myworld)):
        content += f"[ rdf:type owl:Restriction ;\n                                                owl:onProperty :exists ;\n                                                owl:someValuesFrom :MyObj{i}\n                                              ]\n                                              "
    content += ") ;\n                         rdf:type owl:Class\n                       ] .\n\n"
    for i in range(len(myworld)):
        for j in ["d","e0","e1","e2","e3"]:
            content += f":Obj{i}-{j} rdf:type owl:Class ;\n          rdfs:subClassOf :ABoxConstraints .\n\n"
        content += f":MyObj{i} rdf:type owl:Class ;\n                                                                             owl:equivalentClass [ owl:intersectionOf ("
        for j in ["d","e0","e1","e2","e3"]:
            content += f":Obj{i}-{j}\n                                                   "
        content += f":{myworld[i].type}\n"
        content += f"                                                   [ rdf:type owl:Restriction ;\n                                                     owl:onProperty :environment ;\n                                                     owl:someValuesFrom :{env}\n                                                   ]"
        content += f"                                                   [ rdf:type owl:Restriction ;\n                                                     owl:onProperty :nearme ;\n                                                     owl:someValuesFrom :MyWeight\n                                                   ]"
        content +="\n                                                 ) ;\n                              rdf:type owl:Class\n                            ] ;\n        rdfs:subClassOf :ABoxConstraints .\n\n"
    for i in ["MovingObject","StaticObject"]:
        content += f":{i} rdf:type owl:Class ; \n                                                                              rdfs:subClassOf :Object .\n"
    content += ":Tree rdf:type owl:Class ; \n                                                                              rdfs:subClassOf :StaticObject .\n"
    for i in ["Human","Drone"]:
        content += f":{i} rdf:type owl:Class ; \n                                                                              rdfs:subClassOf :MovingObject .\n"
    content += ":WetDrone rdf:type owl:Class ;\n          rdfs:subClassOf :Drone ,\n                          [ rdf:type owl:Restriction ;\n                            owl:onProperty :environment ;\n                            owl:someValuesFrom :LowVisibility\n                          ] .\n"

    for k in ["Small","Big"]:
        content += f":{k} rdf:type owl:Class ; \n                                                                              rdfs:subClassOf :MyDroneSize .\n"
        for i in ["OpDist","OpDistLowVis","OpDistMovObj","OpDistMovObjLowVis"]:
            content += f":{i}{k} rdf:type owl:Class ; \n                                                                              rdfs:subClassOf :ConstraintsOfPresence .\n"
    for i in ["SafeOpDist","SafeOpDistLowVis","SafeOpDistMovObj","SafeOpDistMovObjLowVis"]:
        content += f":{i} rdf:type owl:Class ; \n                                                                              rdfs:subClassOf :SafeDistances .\n"
    for i in ["Rainy","Snowy","Foggy"]:
        content += f":{i} rdf:type owl:Class ; \n                                                                              rdfs:subClassOf :LowVisibility .\n"
        
    content += "#################################################################\n#    Individuals\n#################################################################\n\n"
    
    for i in range(len(myworld)):
            content += f":o{i} rdf:type owl:NamedIndividual ,\n               :MyObj{i} .\n"

    content += "#################################################################\n#    General axioms\n#################################################################\n\n"
    for i in ["Big", "Small"]:
        content += f"[ owl:intersectionOf ( :SafeOpDist\n                       :OpDist{i}\n                       :Tree\n                       [ rdf:type owl:Restriction ;\n                         owl:onProperty :environment ;\n                         owl:someValuesFrom :Sunny\n                       ]\n                       [ rdf:type owl:Restriction ;\n                         owl:onProperty :nearme ;\n                         owl:someValuesFrom :{i}\n                       ]\n                     ) ;\n  rdf:type owl:Class ;\n  rdfs:subClassOf :Safe{i}\n] .\n\n"
        content += f"[ owl:intersectionOf ( :SafeOpDistMovObj\n                        :OpDistMovObj{i}\n                        :MovingObject\n                       [ rdf:type owl:Restriction ;\n                         owl:onProperty :environment ;\n                         owl:someValuesFrom :Sunny\n                       ]\n                       [ rdf:type owl:Restriction ;\n                         owl:onProperty :nearme ;\n                         owl:someValuesFrom :{i}\n                       ]\n                     ) ;\n  rdf:type owl:Class ;\n  rdfs:subClassOf :Safe{i}\n] .\n\n"
        content += f"[ owl:intersectionOf ( :SafeOpDistMovObjLowVis\n                       :OpDistMovObjLowVis{i}\n                         :MovingObject\n                       [ rdf:type owl:Restriction ;\n                         owl:onProperty :environment ;\n                         owl:someValuesFrom :LowVisibility\n                       ]\n                       [ rdf:type owl:Restriction ;\n                         owl:onProperty :nearme ;\n                         owl:someValuesFrom :{i}\n                       ]\n                     ) ;\n  rdf:type owl:Class ;\n  rdfs:subClassOf :Safe{i}\n] .\n\n"
        content += f"[ owl:intersectionOf ( :SafeOpDistLowVis\n                       :OpDistLowVis{i}\n                       :Tree\n                       [ rdf:type owl:Restriction ;\n                         owl:onProperty :environment ;\n                         owl:someValuesFrom :LowVisibility\n                       ]\n                       [ rdf:type owl:Restriction ;\n                         owl:onProperty :nearme ;\n                         owl:someValuesFrom :{i}\n                       ]\n                     ) ;\n  rdf:type owl:Class ;\n  rdfs:subClassOf :Safe{i}\n] .\n\n"
    
    num_safe_obj = 0
    for i in range (len(myworld)):
        if not myworld[i].risk:
            num_safe_obj += 1
    
    if num_safe_obj == 0:
        print("there are no safe obj in the world")
    else:
        if num_safe_obj > 1:
            content += "[ owl:intersectionOf ( "
        for i in range (len(myworld)):
            if not myworld[i].risk:
                content += f"[ rdf:type owl:Restriction ;\n                         owl:onProperty :exists ;\n                         owl:someValuesFrom [ owl:intersectionOf ( :MyObj{i}\n                                                                   :Safe{mysize}\n                                                                 ) ;\n                                              rdf:type owl:Class\n                                            ]"
                if num_safe_obj > 1:
                    content += "\n                       ]\n                       "
        if num_safe_obj > 1:
            content += ") ;\n  rdf:type owl:Class"
        content += ";\n  rdfs:subClassOf :PartiallySafe\n] . \n\n"

    try:
        f = open(filename, "x")
    except:
        rewrite = input("The ontology file already exists. Do you want to re-write it? (y/n)\n")
        if rewrite == 'n':
            exit
        f = open(filename, "w")
    f.write(content)
    f.close()

def write_test(myworld,filename,const,onto,mysize):
    content = f"  @Test\n  def testDDistSbj{len(myworld)}():"
    content +=" Unit = {\n\n    val manager = OWLManager.createOWLOntologyManager()\n    val factory = manager.getOWLDataFactory()\n    def owlClass(name: String): OWLClass = {\n      factory.getOWLClass(IRI.create(\"http://www.semanticweb.org/alisa/ontologies/2023/concrete-domain/drone-distance#\" + name))\n    }\n\n    val classificationResult = testCase(\"/scalable/cd2/drones-subj/"
    content += f"{onto}"
    content += "\",\n \"/scalable/cd2/drones-subj/"
    content += f"{const}"
    content += "\")\n\n"

    for i in range (len(myworld)):
        #for j in ["OpDist","OpDistLowVis","OpDistMovObj","OpDistMovObjLowVis"]:
        #    content += f"    assert(classificationResult(owlClass(\"MyObj{i}\"))(owlClass(\"{j}{mysize}\")))\n"
        content += "    assert"
        if myworld[i].risk:
            content += "False"
        content += f"(classificationResult(owlClass(\"MyObj{i}\"))(owlClass(\"Safe{mysize}\")))\n"
        
    content += "\n  }"
    try:
        f = open(filename, "x")
    except:
        rewrite = input("The test file already exists. Do you want to re-write it? (y/n)\n")
        if rewrite == 'n':
            exit
        f = open(filename, "w")
    f.write(content)
    f.close()

def main():
    args = sys.argv[1:]
    # 1. Check for the arg pattern:
    #   python3 gen.py 3 {-name example}
    if len(args) == 0:
            print("Error: the parameter is missing. Give any value for the number of objects")
            return
    if len(args) != 1 and len(args) != 3 :
        print("The arguments do not follow the pattern. Try again")
        return
    try:
        num = int(args[0])
        constraint_filename = f"instances/ddist{num}.txt"
        ontology_filename = f"instances/ddist{num}.owl"
        test_filename = f"instances/ddist{num}.scala"
    except:
        print("Error: give a int value for the number of products")
        return
    if len(args) == 3:
        if args[1]=="-name":
            constraint_filename = f"{args[2]}.txt"
            ontology_filename = f"{args[2]}.owl"
        else:
            print("Error: forgotten the keyword -name")
            return
    
    env = random.choice(["Sunny","Rainy","Snowy","Foggy"])
    mysize = random.choice(["Big","Small"]) #more than 1 kg or less
    myworld = gen_objects(num,env,mysize)
    
    #for i in myworld:
    #    print(i)
    write_constraints(myworld,constraint_filename,mysize)
    write_ontology(myworld,env,ontology_filename,mysize)
    #write_test(myworld,test_filename,constraint_filename,ontology_filename,mysize)

if __name__ == "__main__":
    main()

