import random
import sys
import numpy as np

list_obj = ["Human", "Drone", "Tree"]
list_dist = ["OpDist", "OpDistLowVis", "OpDistMovObj", "OpDistMovObjLowVis"]

# 1= SafeOpDist, 2 = SafeOpDistLowVis, 3 = SafeOpDistMovObj, 4 = SafeOpDistMovObjLowVis
SmallDroneOpDistances = {
    1 : 1,
    2 : 3,
    3 : 2,
    4 : 5
}

BigDroneOpDistances = {
    1 : 3,
    2 : 5,
    3 : 4,
    4 : 7
}

def gen_objects(nob,ndr,env):
    n = nob + ndr
    objs = list()
    for i in range(ndr):
        objs.append(Object("Drone",env))
    for i in range(nob):
        objs.append(Object(random.choice(["Human","Tree"]),env))
        
    b = np.random.randint(1,12+1,size=(n,n))
    b_symm = (b + b.T)/2
    distances = b_symm.astype(int)
    
    for i in range(n):
        distances[i][i] = 0

    #safety matrix
    safeties = np.random.randint(0,0+1,size=(n,n))
    for i in range(n):
        for j in range(n):
            if i != j:
                if objs[i].type in ["Tree","Human"] and objs[j].type in ["Tree","Human"]:
                    safeties[i][j] = 0
                elif env == "Sunny": #there are "dry" drones among these 2 objects
                    if objs[i].type == "Tree" or objs[j].type == "Tree":
                        safeties[i][j] = 1      # SafeOpDist
                    else: #Human or Drone
                        safeties[i][j] = 3      #SafeOpDistMovObj
                else: #rainy, snowy, foggy
                    if objs[i].type == "Tree" or objs[j].type == "Tree":
                        safeties[i][j] = 2      # SafeOpDistLowVis
                    else: #Human or Drone
                        safeties[i][j] = 4      # SafeOpDistMovObjLowVis
    
    #check if the distance violates the requirement
    ifrisk = np.random.randint(0,0+1,size=(n,n))
    for i in range(n):
        for j in range(n):
            if i != j and (objs[i].type == "Drone" or objs[j].type == "Drone"):
                if objs[i].size == "Big" or objs[j].size == "Big":
                    ifrisk[i][j] = int(BigDroneOpDistances[safeties[i][j]] >= distances[i][j])
                else:
                    ifrisk[i][j] = int(SmallDroneOpDistances[safeties[i][j]] >= distances[i][j])

    return [objs, distances, safeties, ifrisk]

class Object:
  def __init__(self, type, env):
    self.type = type
    if type == "Drone":
        self.size = random.choice(["Big","Small"]) #more than 1 kg or less
        if env != "Sunny":
            self.ifwet = random.choice([True,False])
        else:
            self.ifwet = False
            
    else:
        self.ifwet = None
        self.size = None
        
  def __str__(self):
    return f"Object {self.type}, size: {self.size}, ifwet: {self.ifwet} "

def write_constraints(myworld, filename):
#start creating a constraint file
    content = "PREFIX : <http://www.semanticweb.org/alisa/ontologies/2023/concrete-domain/drone-distance-1#> \n\n"
    objs = myworld[0]
    for i in range(len(objs)):
        for k in range(i):
            content += f"# Conn{i}-{k} is unsafe: {myworld[3][i][k]}\n"
            content += f"Conn{i}-{k}-d: distance = {int(myworld[1][i][k])} \n"
            if objs[i].type == "Drone" or objs[k].type == "Drone":
                for j in range(4):
                    if (objs[i].size == "Small" and objs[k].size == "Small") or (objs[i].size == "Small" and objs[k].type != "Drone") or (objs[k].size == "Small" and objs[i].type != "Drone"):
                        e = int(myworld[1][i][k])-list(SmallDroneOpDistances.values())[j]
                    else:
                        e = int(myworld[1][i][k])-list(BigDroneOpDistances.values())[j]
                    content += f"Conn{i}-{k}-e{j}: epsilon{j} = {e} \n"
            content += "\n"
    
    content += "\n##### TBox constrains - OperatingDistances (always hold by gen.py wrt a size)\n\n"
    k = 0
    for j in list_dist:
        content += f"{j}Small: epsilon{k} + {list(SmallDroneOpDistances.values())[k]} = distance\n\n"
        k += 1
    k = 0
    for j in list_dist:
        content += f"{j}Big: epsilon{k} + {list(BigDroneOpDistances.values())[k]} = distance\n\n"
        k += 1
    content +="\n##### TBox constrains (to be checked by the reasoner for different situations)\n\nSafeOpDist: epsilon0 > 0\n\nSafeOpDistLowVis: epsilon1 > 0\n\nSafeOpDistMovObj: epsilon2 > 0\n\nSafeOpDistMovObjLowVis: epsilon3 > 0\n\n"

    try:
        f = open(filename, "x")
    except:
        rewrite = input("The constraint file already exists. Do you want to re-write it? (y/n)\n")
        if rewrite == 'n':
            exit
        f = open(filename, "w")
    f.write(content)
    f.close()

def write_ontology(myworld,env,filename):
    content = "@prefix : <http://www.semanticweb.org/alisa/ontologies/2023/concrete-domain/drone-distance-1#> .\n@prefix owl: <http://www.w3.org/2002/07/owl#> .\n@prefix rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#> .\n@prefix xml: <http://www.w3.org/XML/1998/namespace> .\n@prefix xsd: <http://www.w3.org/2001/XMLSchema#> .\n@prefix rdfs: <http://www.w3.org/2000/01/rdf-schema#> .\n@base <http://www.semanticweb.org/alisa/ontologies/2023/concrete-domain/drone-distance-1#> .\n\n<http://www.semanticweb.org/alisa/ontologies/2023/concrete-domain/drone-distance-1#> rdf:type owl:Ontology .\n\n #################################################################\n#    Object Properties\n#################################################################\n\n :environment rdf:type owl:ObjectProperty .\n\n :hasSize rdf:type owl:ObjectProperty .\n\n :exists rdf:type owl:ObjectProperty .\n\n :connectedTo rdf:type owl:ObjectProperty .\n\n "
    objs = myworld[0]
    for i in ["a","b"]:
        content += f" :roleConn-{i} rdf:type owl:ObjectProperty ;\n              rdfs:domain :ConnectionPoint ;\n              rdfs:range :Object .\n\n"
    content += "#################################################################\n#    Data properties\n#################################################################\n\n"
    for j in ["distance","epsilon0","epsilon1","epsilon2","epsilon3"]:
        content += f" :{j} rdf:type owl:DatatypeProperty ;\n          rdfs:domain :ConnectionPoint ;\n                                                                                       rdfs:range owl:real .\n\n"
    content += "#################################################################\n#    Classes\n#################################################################\n\n"
    content += " :Object rdf:type owl:Class .\n\n :PartiallySafe rdf:type owl:Class .\n\n :ABoxConstraints rdf:type owl:Class .\n\n :ConnectionPoint rdf:type owl:Class ;\n          rdfs:subClassOf :ABoxConstraints .\n\n :Safe rdf:type owl:Class .\n\n :Sunny rdf:type owl:Class .\n\n :ConstraintsOfPresence rdf:type owl:Class .\n\n :SafeDistances rdf:type owl:Class .\n\n :LowVisibility rdf:type owl:Class ;\n               owl:disjointWith :Object .\n\n"

    content += " :World rdf:type owl:Class ;\n       rdfs:subClassOf [ owl:intersectionOf ( "
    for i in range(len(objs)):
        for k in range(i):
            content += f"[ rdf:type owl:Restriction ;\n                                                owl:onProperty :exists ;\n                                                owl:someValuesFrom :Conn{i}-{k}\n                                              ]\n                                              "
    content += ") ;\n                         rdf:type owl:Class\n                       ] .\n\n"

    for i in range(len(objs)):
        for k in range(i):
            for j in ["d","e0","e1","e2","e3"]:
                content += f" :Conn{i}-{k}-{j} rdf:type owl:Class ;\n          rdfs:subClassOf :ABoxConstraints .\n\n"
            content += f" :Conn{i}-{k} rdf:type owl:Class ;\n                                                                             rdfs:subClassOf [ owl:intersectionOf ( "
            for j in ["d","e0","e1","e2","e3"]:
                content += f" :Conn{i}-{k}-{j}\n                                                   "
            #check if any a drone
            if objs[i].type == "Drone":
                drone = i
                notdrone = k
            else :
                drone = k
                notdrone = i
            content += f") ;\n                              rdf:type owl:Class\n                            ] ;\n        rdfs:subClassOf :ConnectionPoint ,\n                         [ owl:intersectionOf ( [ rdf:type owl:Restriction ;\n                                                  owl:onProperty :roleConn-a ;\n                                                  owl:someValuesFrom :Obj{drone}\n                                                ]\n                                                [ rdf:type owl:Restriction ;\n                                                  owl:onProperty :roleConn-b ;\n                                                  owl:someValuesFrom :Obj{notdrone}\n                                                ]\n                                              ) ;\n                           rdf:type owl:Class\n                         ] .\n\n"
    #objs
    for i in range(len(objs)):
        content += f":Obj{i} rdf:type owl:Class ;\n      rdfs:subClassOf :ABoxConstraints ,\n                      [ owl:intersectionOf ( :{objs[i].type} \n"
        content += f"                                                   [ rdf:type owl:Restriction ;\n                                                     owl:onProperty :environment ;\n                                                     owl:someValuesFrom :{env}\n                                                   ]"
        if (objs[i].type == "Drone"):
            if objs[i].ifwet:
                content += "          :WetDrone\n"
            content += f"                                                   [ rdf:type owl:Restriction ;\n                                                     owl:onProperty :hasSize ;\n                                                     owl:someValuesFrom :{objs[i].size}\n                                                   ]\n"
            
        content += ") ;\n                              rdf:type owl:Class\n                            ] "
        for k in range(len(objs)):
            if (i != k):
                content += f",\n                      [ rdf:type owl:Restriction ;\n                        owl:onProperty :connectedTo ;\n                        owl:someValuesFrom  :Conn{max(i,k)}-{min(i,k)}\n                      ] "
        content += " .\n\n"

    for i in ["MovingObject","StaticObject","Independent"]:
        content += f":{i} rdf:type owl:Class ; \n                                                                              rdfs:subClassOf :Object .\n"
    content += " :Tree rdf:type owl:Class ; \n                                                                              rdfs:subClassOf :StaticObject .\n"
    for i in ["Human","Drone"]:
        content += f" :{i} rdf:type owl:Class ; \n                                                                              rdfs:subClassOf :MovingObject .\n"
    for i in ["Tree","Drone"]:
        content += f" :{i} rdf:type owl:Class ; \n                                                                              rdfs:subClassOf :Independent .\n"
    content += " :WetDrone rdf:type owl:Class ;\n          rdfs:subClassOf :Drone ,\n                          [ rdf:type owl:Restriction ;\n                            owl:onProperty :environment ;\n                            owl:someValuesFrom :LowVisibility\n                          ] .\n"

    for k in ["Small","Big"]:
        content += f" :{k} rdf:type owl:Class ; \n                                                                              rdfs:subClassOf :DroneSize .\n"
        for i in list_dist:
            content += f" :{i}{k} rdf:type owl:Class ; \n                                                                              rdfs:subClassOf :ConstraintsOfPresence .\n"
    
        content += f" :Epsilon{k} rdf:type owl:Class ; \n                                                                              owl:equivalentClass [ owl:intersectionOf ("
        for i in list_dist:
            content += f" :{i}{k}\n                                                   "
        content += ") ;\n                              rdf:type owl:Class\n                            ] ;\n        rdfs:subClassOf :ConstraintsOfPresence .\n"
    for i in list_dist:
        content += f" :Safe{i} rdf:type owl:Class ; \n                                                                              rdfs:subClassOf :SafeDistances .\n"
    for i in ["Rainy","Snowy","Foggy"]:
        content += f" :{i} rdf:type owl:Class ; \n                                                                              rdfs:subClassOf :LowVisibility .\n"
    #for ALC
    content += " :SafeDrone rdf:type owl:Class ;\n           owl:equivalentClass [ owl:intersectionOf ( :Drone\n                                                      [ rdf:type owl:Restriction ;\n                                                        owl:onProperty :connectedTo ;\n                                                        owl:allValuesFrom :Safe\n                                                      ]\n                                                    ) ;\n                                 rdf:type owl:Class\n                               ] ."
        
    #content += "#################################################################\n#    Individuals\n#################################################################\n\n"
    
    #for i in range(len(objs)):
    #        content += f":o{i} rdf:type owl:NamedIndividual ,\n               :MyObj{i} .\n"

    content += "#################################################################\n#    General axioms\n#################################################################\n\n"

    dist2obj = {
        "OpDist" : "Tree",
        "OpDistLowVis" : "Tree",
        "OpDistMovObj" : "MovingObject",
        "OpDistMovObjLowVis" : "MovingObject"
}
    dist2weather = {
        "OpDist" : "Sunny",
        "OpDistLowVis" : "LowVisibility",
        "OpDistMovObj" : "Sunny",
        "OpDistMovObjLowVis" : "LowVisibility"
}

    for j in list_dist:
        for i in ["Big", "Small"]:
            content += f"[ owl:intersectionOf ( :Epsilon{i}\n                       :Safe{j}\n                       [ rdf:type owl:Restriction ;\n                                                owl:onProperty :roleConn-b ;\n                                                owl:someValuesFrom [ owl:intersectionOf ( [ rdf:type owl:Restriction ;\n                                                owl:onProperty :environment ;\n                                                owl:someValuesFrom :{dist2weather[j]}\n                                              ]\n                                              :{dist2obj[j]}\n                                              ) ;\n                         rdf:type owl:Class\n                       ]\n                                            ]\n                       [ rdf:type owl:Restriction ;\n                         owl:onProperty :roleConn-a ;\n                         owl:someValuesFrom [ rdf:type owl:Restriction ;\n                                              owl:onProperty :hasSize ;\n                                              owl:someValuesFrom :{i}\n                                            ]\n                       ]\n                     ) ;\n  rdf:type owl:Class ;\n  rdfs:subClassOf :Safe\n] .\n\n"
    for j in ["OpDistMovObj", "OpDistMovObjLowVis"]:
        content += f"[ owl:intersectionOf ( :EpsilonBig\n                       :Safe{j}\n                       [ rdf:type owl:Restriction ;\n                                                owl:onProperty :roleConn-a ;\n                                                owl:someValuesFrom [ owl:intersectionOf ( [ rdf:type owl:Restriction ;\n                                                owl:onProperty :environment ;\n                                                owl:someValuesFrom :{dist2weather[j]}\n                                              ]\n                                              :{dist2obj[j]}\n                                              ) ;\n                         rdf:type owl:Class\n                       ]\n                                            ]\n                       [ rdf:type owl:Restriction ;\n                         owl:onProperty :roleConn-b ;\n                         owl:someValuesFrom [ rdf:type owl:Restriction ;\n                                              owl:onProperty :hasSize ;\n                                              owl:someValuesFrom :Big\n                                            ]\n                       ]\n                     ) ;\n  rdf:type owl:Class ;\n  rdfs:subClassOf :Safe\n] .\n\n"
        
    safeties = myworld[2]
    ifrisk = myworld[3]
    num_safe_conn = 0
    for i in range(len(objs)):
        for k in range(i):
            if safeties[i][k] > 0 and ifrisk[i][k] == 0:
                num_safe_conn += 1
    
    if num_safe_conn == 0:
        print("Error: there are no safe conn in the world and World is not Partially Safe")
    else:
        if num_safe_conn > 1:
            content += "[ owl:intersectionOf ( "
        for i in range(len(objs)):
            for k in range(i):
                if safeties[i][k] > 0 and ifrisk[i][k] == 0:
                    content += f"[ rdf:type owl:Restriction ;\n                         owl:onProperty :exists ;\n                         owl:someValuesFrom [ owl:intersectionOf ( :Conn{i}-{k}\n                                                                   :Safe\n                                                                 ) ;\n                                              rdf:type owl:Class\n                                            ]"
                    if num_safe_conn > 1:
                        content += "\n                       ]\n                       "
        if num_safe_conn > 1:
            content += ") ;\n  rdf:type owl:Class"
        content += ";\n  rdfs:subClassOf :PartiallySafe\n] . \n\n"
        

    try:
        f = open(filename, "x")
    except:
        rewrite = input("The ontology file already exists. Do you want to re-write it? (y/n)\n")
        if rewrite == 'n':
            exit
        f = open(filename, "w")
    f.write(content)
    f.close()

def write_test(num,myworld,filename,const,onto):
    content = f"  @Test\n  def testDDistObj{num}():"
    content +=" Unit = {\n\n    val manager = OWLManager.createOWLOntologyManager()\n    val factory = manager.getOWLDataFactory()\n    def owlClass(name: String): OWLClass = {\n      factory.getOWLClass(IRI.create(\"http://www.semanticweb.org/alisa/ontologies/2023/concrete-domain/drone-distance-1#\" + name))\n    }\n\n    val classificationResult = testCase(\"/scalable/cd2/drones-obj/"
    content += f"{onto}"
    content += "\",\n \"/scalable/cd2/drones-obj/"
    content += f"{const}"
    content += "\")\n\n"

    objs = myworld[0]
    safeties = myworld[2]
    ifrisk = myworld[3]
    
    #for i in range (len(objs)):
    #    for j in range(i):
    #        if objs[i].type == "Drone" or objs[j].type == "Drone":
    #            if objs[i].size == "Big" or objs[j].size == "Big":
    #                s = "Big"
    #            else:
    #                s = "Small"
    #            content += f"    assert(classificationResult(owlClass(\"Conn{i}-{j}\"))(owlClass(\"Epsilon{s}\")))\n"
    #content += "\n"
    
    for i in range (len(objs)):
        for j in range(i):
            if safeties[i][j] > 0:
                content += "    assert"
                if ifrisk[i][j] > 0:
                    content += "False"
                content += f"(classificationResult(owlClass(\"Conn{i}-{j}\"))(owlClass(\"Safe\")))\n"
        
    content += "  }"
    
    try:
        f = open(filename, "x")
    except:
        rewrite = input("The test file already exists. Do you want to re-write it? (y/n)\n")
        if rewrite == 'n':
            exit
        f = open(filename, "w")
    f.write(content)
    f.close()

def write_test_alc(num,myworld,filename,const,onto):
    content = f"  @Test\n  def testDDistObjALC{num}():"
    content +=" Unit = {\n\n    val manager = OWLManager.createOWLOntologyManager()\n    val factory = manager.getOWLDataFactory()\n    def owlClass(name: String): OWLClass = {\n      factory.getOWLClass(IRI.create(\"http://www.semanticweb.org/alisa/ontologies/2023/concrete-domain/drone-distance-1#\" + name))\n    }\n\n    val classificationResult = testCase(\"/scalable2-1/"
    content += f"{onto}"
    content += "\",\n \"/scalable2-1/"
    content += f"{const}"
    content += "\")\n\n"

    objs = myworld[0]
    safeties = myworld[2]
    ifrisk = myworld[3]
    
    for i in range (len(objs)):
        if objs[i].type == "Drone":
            content += "    assert"
            risky = False
            for j in range (len(objs)):
                if ifrisk[i][j] > 0:
                    risky = True
            if risky:
                content += "False"
            content += f"(classificationResult(owlClass(\"Obj{i}\"))(owlClass(\"SafeDrone\")))\n"
        
    content += "\n  }"
    
    try:
        f = open(filename, "x")
    except:
        rewrite = input("The test file already exists. Do you want to re-write it? (y/n)\n")
        if rewrite == 'n':
            exit
        f = open(filename, "w")
    f.write(content)
    f.close()
    
def main():
    args = sys.argv[1:]
    # 1. Check for the arg pattern:
    #   python3 gen.py 3 {-name example}
    if len(args) == 0:
            print("Error: the parameter is missing. Give any value for the number of objects")
            return
    if len(args) != 2 and len(args) != 4 :
        print("The arguments do not follow the pattern. Try again")
        return
    try:
        num = int(args[1])
        numdr = int(args[0])
        constraint_filename = f"instances/ddist{numdr}_{num}.txt"
        ontology_filename = f"instances/ddist{numdr}_{num}.owl"
        test_filename = f"instances/ddist{numdr}_{num}.scala"
        test_filename_alc = f"instances/ddist{numdr}_{num}_alc.scala"
    except:
        print("Error: give a int value for the number of drones and objects")
        return
    if len(args) == 4:
        if args[2]=="-name":
            constraint_filename = f"{args[3]}.txt"
            ontology_filename = f"{args[3]}.owl"
        else:
            print("Error: forgotten the keyword -name")
            return
    if num < 0:
        print("Negative number of world objects\n") #drones are not included
        return
    if numdr <= 0:
        print("invalid number of drones \n")
        return
    
    env = random.choice(["Sunny","Rainy","Snowy","Foggy"])
    myworld = gen_objects(num,numdr,env)
    
    print(env)
    for i in myworld[0]:
        print(i)
    print("\nDistances")
    print(myworld[1])
    print("\nWhich safety")
    print(myworld[2])
    print("\nIfrisk")
    print(myworld[3])
    write_constraints(myworld,constraint_filename)
    write_ontology(myworld,env,ontology_filename)
    #write_test(num,myworld,test_filename,constraint_filename,ontology_filename)
    #write_test_alc(num,myworld,test_filename_alc,constraint_filename,ontology_filename)
if __name__ == "__main__":
    main()

