#Example
exampledayintake = { #in grams
    "apple": 200,
    "milk": 500,
    "potato": 2000,
    "veg1": 100
}

Carbohydrates =    { #in grams per 100 grams, taken from https://www.wchc.nhs.uk/content/uploads/2019/11/Carbohydrate-reference-tables.pdf
  "apple": 12,
  "banana": 15,
  "grapes": 15,
  "kiwi": 9,
  "mango": 14,
  "orange": 6,
  "peach": 7,
  "pear": 9,
  "pineapple": 10,
  "watermelon": 7,
  "bread": 50,
  "chickpeas": 16,
  "spaghetti": 70,
  "sausage": 9,
  "ketchup": 33,
  "potato": 17,
  "milk": 5,
  "yogurt": 7
}

Protein =    { #in grams per 100 grams, taken from Google
  "apple": 0.3,
  "banana": 1.1,
  "grapes": 0.6,
  "kiwi": 1.1,
  "mango": 0.8,
  "orange": 0.9,
  "peach": 0.7,
  "pear": 0.4,
  "pineapple": 0.5,
  "watermelon": 0.6,
  "bread": 9,
  "chickpeas": 19,
  "spaghetti": 6,
  "sausage": 14,
  "ketchup": 1.3,
  "potato": 2,
  "milk": 3.4,
  "yogurt": 10
}

Fat =    { #in grams per 100 grams, taken from Google
  "apple": 0.2,
  "banana": 0.3,
  "grapes": 0.4,
  "kiwi": 0.5,
  "mango": 0.4,
  "orange": 0.1,
  "peach": 0.5,
  "pear": 0.1,
  "pineapple": 0.1,
  "watermelon": 0.2,
  "bread": 3.2,
  "chickpeas": 6,
  "spaghetti": 0.9,
  "sausage": 31,
  "ketchup": 0.2,
  "potato": 0.1,
  "milk": 1,
  "yogurt": 0.4
}

import random
import sys

class Product:
    def weight(self,name,weight):
        self.name = name
        self.weight = weight
        if name in Carbohydrates:
            self.carbs_g = weight / 100 * Carbohydrates[name]
            self.protein_g = weight / 100 * Protein[name]
            self.fat_g = weight / 100 * Fat[name]
        else: #the product is not in the list
            self.carbs_g = weight / 100 * random.randint(0, 100)
            self.protein_g = random.randint(0, weight - self.carbs_g)
            self.fat_g = weight - self.carbs_g - self.protein_g
    #Carbohydrates provide 4 calories per gram, protein provides 4 calories per gram, and fat provides 9 calories per gram.
        self.carbs_cal = round(self.carbs_g * 4)
        self.protein_cal = round(self.protein_g * 4)
        self.fat_cal = round(self.fat_g * 9)
        
    def diet(self,name,d):
        self.name = name
        totalcal = 100 * random.randint(1, 200) #20kkal is the max
        self.carbs_cal = totalcal * d.carbs_proc
        self.protein_cal = totalcal * d.protein_proc
        self.fat_cal = totalcal * d.fat_proc
        
        #just for symmetricity
        self.carbs_g = round(self.carbs_cal / 4)
        self.protein_g = round(self.protein_cal / 4)
        self.fat_g = round(self.fat_cal / 9)
        self.weight = self.carbs_g + self.protein_g + self.fat_g

    def __init__(self, name, w):
        if isinstance(w,int):
            self.weight(name,w)
        else: #Diet
            self.diet(name,w)
            
    def __str__(self):
        return f"{self.name}--({int(self.carbs_cal)},{int(self.protein_cal)},{int(self.fat_cal)})"

#deprecated
def gramsTocalories(dayintake,ifdiet):
    output = []
    for k in dayintake:
        p = Product(k,dayintake[k])
        output.append(p)
    diet = options[ifdiet]
    sum_carbs = 0
    sum_protein = 0
    sum_fat = 0
    for k in range(len(output)-1):
        sum_carbs += output[k].carbs_cal
        sum_protein += output[k].protein_cal
        sum_fat += output[k].fat_cal
    output[-1].fat_cal = 100 * (sum_carbs + sum_protein) + 99 * sum_fat
    output[-1].carbs_cal = int(diet.carbs_proc / diet.fat_proc * (sum_fat + output[-1].fat_cal) - sum_carbs)
    output[-1].protein_cal = int(diet.protein_proc / diet.fat_proc * (sum_fat + output[-1].fat_cal) - sum_protein)

    return output
    
def checkIfdiet(dayintake,diet):
    sum_carbs = 0
    sum_protein = 0
    sum_fat = 0
    for k in dayintake:
        sum_carbs += k.carbs_cal
        sum_protein += k.protein_cal
        sum_fat += k.fat_cal
    sum = sum_carbs + sum_protein + sum_fat
    
    if (sum_carbs == diet.carbs_proc * sum) and (sum_fat == diet.fat_proc * sum) and (sum_protein == diet.protein_proc * sum):
        print("\nworks\n")

def gen_dayintake(n):
    output = dict()
    if n <= len(Carbohydrates):
        prod = random.sample(list(Carbohydrates), k=(n-1))
        for i in prod:
            output[i] = 100 *  random.randint(0, 50)
        output["prod0"] = 100 *  random.randint(0, 50)
    else:
        for i in list(Carbohydrates):
            output[i] = 100 *  random.randint(0, 50)
        for i in range (n - len(Carbohydrates)):
            output[f"prod{i}"] = 100 *  random.randint(0, 50)
    return output

class Diet:
  def __init__(self, carbs_proc,protein_proc,fat_proc):
    self.carbs_proc = carbs_proc
    self.protein_proc = protein_proc
    self.fat_proc = fat_proc
    
diets = {"fc": "FullCarbs",
        "ff": "FullFat",
        "fp": "FullProtein",
        "lc": "LowerCarb",
        "lcf": "LowerCarb&Fat",
        "wb": "Well-balanced"
}

options = {"fc" : Diet(1,0,0),
           "ff" : Diet(0,0,1),
           "fp" : Diet(0,1,0),
           "lc" : Diet(0.45,0.25,0.3),
           "lcf" : Diet(0.45,0.3,0.25),
           "wb" : Diet(0.55,0.2,0.25)
}

def gen_dayintake_diet(n,ifdiet):

    diet = options[ifdiet]
    output = []
    for i in range (n):
        p = Product(f"prod{i}",diet)
        output.append(p)
    return output

def write_constraints(mydaycalories, totalcalories, filename):
#start creating a constraint file
    content = "#my day intake description and constraints\nPREFIX : <http://www.semanticweb.org/alisa/ontologies/2023/concrete-domain/diet#> \n\n"
    for i in range(len(mydaycalories)):
        content += f"MyProduct{i}-1: \n 1 * had-{mydaycalories[i].name}-c \n = {int(mydaycalories[i].carbs_cal)} \n"
        content += f"MyProduct{i}-2: \n 1 * had-{mydaycalories[i].name}-p \n = {int(mydaycalories[i].protein_cal)} \n"
        content += f"MyProduct{i}-3: \n 1 * had-{mydaycalories[i].name}-f \n = {int(mydaycalories[i].fat_cal)} \n"
        content += "\n"
    content += f"MyProduct-total: \n 1 * had-total \n = {int(totalcalories)} \n"
    
    content += "\n##### TBox constrains\n\nTotalAmount:\n 1 * had-total \n"
    for i in mydaycalories:
        content += f" -1 * had-{i.name}-c \n -1 * had-{i.name}-p \n -1 * had-{i.name}-f \n"
    content += " = 0\n"

    content += "\nFullCarbs:\n 1 * had-total \n"
    for i in mydaycalories:
        content += f" -1 * had-{i.name}-c \n"
    content += " = 0\n"

    content += "\nFullProtein:\n 1 * had-total \n"
    for i in mydaycalories:
        content += f" -1 * had-{i.name}-p \n"
    content += " = 0\n"

    content += "\nFullFat:\n 1 * had-total \n"
    for i in mydaycalories:
        content += f" -1 * had-{i.name}-f \n"
    content += " = 0\n"

    content += "\nCarbs55:\n 11 * had-total \n"
    for i in mydaycalories:
        content += f" -20 * had-{i.name}-c \n"
    content += " = 0\n"

    content += "\nCarbs45:\n 9 * had-total \n"
    for i in mydaycalories:
        content += f" -20 * had-{i.name}-c \n"
    content += " = 0\n"

    content += "\nProtein30:\n 3 * had-total \n"
    for i in mydaycalories:
        content += f" -10 * had-{i.name}-p \n"
    content += " = 0\n"

    content += "\nProtein25:\n 1 * had-total \n"
    for i in mydaycalories:
        content += f" -4 * had-{i.name}-p \n"
    content += " = 0\n"

    content += "\nProtein20:\n 1 * had-total \n"
    for i in mydaycalories:
        content += f" -5 * had-{i.name}-p \n"
    content += " = 0\n"

    content += "\nFat30:\n 3 * had-total \n"
    for i in mydaycalories:
        content += f" -10 * had-{i.name}-f \n"
    content += " = 0\n"

    content += "\nFat25:\n 1 * had-total \n"
    for i in mydaycalories:
        content += f" -4 * had-{i.name}-f \n"
    content += " = 0\n"

    try:
        f = open(filename, "x")
    except:
        rewrite = input("The constraint file already exists. Do you want to re-write it? (y/n)\n")
        if rewrite == 'n':
            exit
        f = open(filename, "w")
    f.write(content)
    f.close()

def write_ontology(mydaycalories,totalcalories,filename):
    content = "#my day intake ontology\n@prefix : <http://www.semanticweb.org/alisa/ontologies/2023/concrete-domain/diet#> .\n@prefix owl: <http://www.w3.org/2002/07/owl#> .\n@prefix rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#> .\n@prefix xml: <http://www.w3.org/XML/1998/namespace> .\n@prefix xsd: <http://www.w3.org/2001/XMLSchema#> .\n@prefix rdfs: <http://www.w3.org/2000/01/rdf-schema#> .\n@base <http://www.semanticweb.org/alisa/ontologies/2023/concrete-domain/diet#> .\n\n<http://www.semanticweb.org/alisa/ontologies/2023/concrete-domain/diet#> rdf:type owl:Ontology .\n\n #################################################################\n#    Data properties\n#################################################################\n\n"
    
    for i in range(len(mydaycalories)):
        for j in ['c','p','f']:
            content += f"<http://www.semanticweb.org/alisa/ontologies/2023/concrete-domain/diet#had-{mydaycalories[i].name}-{j}> rdf:type owl:DatatypeProperty ;\n                                                                                       rdfs:range owl:real .\n\n"
    content += f"<http://www.semanticweb.org/alisa/ontologies/2023/concrete-domain/diet#had-total> rdf:type owl:DatatypeProperty ;\n                                                                                       rdfs:range owl:real .\n\n\n"
    content += "#################################################################\n#    Classes\n#################################################################\n\n"
    content += "<http://www.semanticweb.org/alisa/ontologies/2023/concrete-domain/diet#ABoxConstraints> rdf:type owl:Class .\n\n <http://www.semanticweb.org/alisa/ontologies/2023/concrete-domain/diet#ConstraintsOfPresence> rdf:type owl:Class .\n\n <http://www.semanticweb.org/alisa/ontologies/2023/concrete-domain/diet#Diet> rdf:type owl:Class .\n\n <http://www.semanticweb.org/alisa/ontologies/2023/concrete-domain/diet#TotalAmount> rdf:type owl:Class .\n\n"

    for i in range(len(mydaycalories)):
        for j in [1,2,3]:
            content += f"<http://www.semanticweb.org/alisa/ontologies/2023/concrete-domain/diet#MyProduct{i}-{j}> rdf:type owl:Class ;\n                                                                            rdfs:subClassOf <http://www.semanticweb.org/alisa/ontologies/2023/concrete-domain/diet#ABoxConstraints> .\n"
    content += f"<http://www.semanticweb.org/alisa/ontologies/2023/concrete-domain/diet#MyProduct-total> rdf:type owl:Class ;\n                                                                            rdfs:subClassOf <http://www.semanticweb.org/alisa/ontologies/2023/concrete-domain/diet#ABoxConstraints> .\n"
    content += "<http://www.semanticweb.org/alisa/ontologies/2023/concrete-domain/diet#MyDayDiet> rdf:type owl:Class ;\n                                                                             owl:equivalentClass [ owl:intersectionOf ("
    for i in range(len(mydaycalories)):
        for j in [1,2,3]:
            content += f"<http://www.semanticweb.org/alisa/ontologies/2023/concrete-domain/diet#MyProduct{i}-{j}>\n                                                                                                                       "
    content += "<http://www.semanticweb.org/alisa/ontologies/2023/concrete-domain/diet#MyProduct-total>\n                                                                                                                       ) ;                                                                                                   rdf:type owl:Class\n                                                                                                 ] . \n\n"
    for i in ["Carbs55","Carbs45","Protein30","Protein25","Protein20","Fat30","Fat25"]:
        content += f"<http://www.semanticweb.org/alisa/ontologies/2023/concrete-domain/diet#{i}> rdf:type owl:Class ; \n                                                                              rdfs:subClassOf <http://www.semanticweb.org/alisa/ontologies/2023/concrete-domain/diet#ConstraintsOfPresence> .\n"
    for i in ["FullCarbs","FullProtein","FullFat"]:
        content += f"<http://www.semanticweb.org/alisa/ontologies/2023/concrete-domain/diet#{i}> rdf:type owl:Class ; \n                                                                              rdfs:subClassOf <http://www.semanticweb.org/alisa/ontologies/2023/concrete-domain/diet#Diet> .\n"
        
#well-balanced, 55% carbs, 20% protein, 25% fat.
    content += "\n<http://www.semanticweb.org/alisa/ontologies/2023/concrete-domain/diet#Well-balanced> rdf:type owl:Class ;\n                                                                         owl:equivalentClass [ owl:intersectionOf ( <http://www.semanticweb.org/alisa/ontologies/2023/concrete-domain/diet#Carbs55>\n                                                                                                                    <http://www.semanticweb.org/alisa/ontologies/2023/concrete-domain/diet#Protein20>\n                                                                                                                    <http://www.semanticweb.org/alisa/ontologies/2023/concrete-domain/diet#Fat25>\n                                                                                                                  ) ;\n                                                                                               rdf:type owl:Class\n                                                                                             ] ;\n                                                                         rdfs:subClassOf <http://www.semanticweb.org/alisa/ontologies/2023/concrete-domain/diet#Diet> .\n\n"
#lower carb, 45% carbs, 25% protein, 30% fat,
    content += "\n<http://www.semanticweb.org/alisa/ontologies/2023/concrete-domain/diet#LowerCarb> rdf:type owl:Class ;\n                                                                         owl:equivalentClass [ owl:intersectionOf ( <http://www.semanticweb.org/alisa/ontologies/2023/concrete-domain/diet#Carbs45>\n                                                                                                                    <http://www.semanticweb.org/alisa/ontologies/2023/concrete-domain/diet#Protein25>\n                                                                                                                    <http://www.semanticweb.org/alisa/ontologies/2023/concrete-domain/diet#Fat30>\n                                                                                                                  ) ;\n                                                                                               rdf:type owl:Class\n                                                                                             ] ;\n                                                                         rdfs:subClassOf <http://www.semanticweb.org/alisa/ontologies/2023/concrete-domain/diet#Diet> .\n\n"
#lower carb&fat, 45% carbs, 30% protein and 25% fat
    content += "\n<http://www.semanticweb.org/alisa/ontologies/2023/concrete-domain/diet#LowerCarb&Fat> rdf:type owl:Class ;\n                                                                         owl:equivalentClass [ owl:intersectionOf ( <http://www.semanticweb.org/alisa/ontologies/2023/concrete-domain/diet#Carbs45>\n                                                                                                                    <http://www.semanticweb.org/alisa/ontologies/2023/concrete-domain/diet#Protein30>\n                                                                                                                    <http://www.semanticweb.org/alisa/ontologies/2023/concrete-domain/diet#Fat25>\n                                                                                                                  ) ;\n                                                                                               rdf:type owl:Class\n                                                                                             ] ;\n                                                                         rdfs:subClassOf <http://www.semanticweb.org/alisa/ontologies/2023/concrete-domain/diet#Diet> .\n\n"

    content += "#################################################################\n#    Individuals\n#################################################################\n\n<http://www.semanticweb.org/alisa/ontologies/2023/concrete-domain/diet#theday> rdf:type owl:NamedIndividual ,\n                                                                    <http://www.semanticweb.org/alisa/ontologies/2023/concrete-domain/diet#MyDayDiet> .\n"

    try:
        f = open(filename, "x")
    except:
        rewrite = input("The ontology file already exists. Do you want to re-write it? (y/n)\n")
        if rewrite == 'n':
            exit
        f = open(filename, "w")
    f.write(content)
    f.close()

def write_test(ifdiet,test_filename,ontology_filename,constraint_filename):
    content = "  @Test\n  def testDiet1(): Unit = {\n\n    val manager = OWLManager.createOWLOntologyManager()\n    val factory = manager.getOWLDataFactory()\n    def owlClass(name: String): OWLClass = {\n      factory.getOWLClass(IRI.create(\"http://www.semanticweb.org/alisa/ontologies/2023/concrete-domain/diet#\" + name))\n    }\n\n    val classificationResult = testCase(\"/scalable/cd1/diet/"
    content += f"{ontology_filename}"
    content += "\", \"/scalable/cd1/diet/"
    content += f"{constraint_filename}"
    content += "\")\n\n    assert(classificationResult(owlClass(\"MyDayDiet\"))(owlClass(\"TotalAmount\")))\n"
    
    for i in diets:
        content += "    assert("
        if i != ifdiet:
            content += "!"
        content += f"classificationResult(owlClass(\"MyDayDiet\"))(owlClass(\"{diets[i]}\")))\n"
    content += "\n  }"
  
    try:
        f = open(test_filename, "x")
    except:
        rewrite = input("The scala file already exists. Do you want to re-write it? (y/n)\n")
        if rewrite == 'n':
            exit
        f = open(test_filename, "w")
    f.write(content)
    f.close()
    
def write_java(ifdiet,java_filename,ontology_filename,constraint_filename):
    content = "        initialise(\"src/test/resources/scalable/cd1/diet/"
    content += ontology_filename
    content += "\", \"src/test/resources/scalable/cd1/diet/"
    content += constraint_filename
    content += "\", \"http://www.semanticweb.org/alisa/ontologies/2023/concrete-domain/diet#\", ReasonerName.Elk, ConcreteDomainName.LinearConstraints); \n        experimentWith(\"MyDayDiet\",\""
    content += diets[ifdiet]
    content += "\");//true\n        experimentWith(\"MyDayDiet\",\""
    if ifdiet == "wb":
        i = "lcf"
    else:
        i = "wb"
    content += diets[i]
    content += "\");//false\n"
    
    try:
        f = open(java_filename, "x")
    except:
        rewrite = input("The scala file already exists. Do you want to re-write it? (y/n)\n")
        if rewrite == 'n':
            exit
        f = open(java_filename, "w")
    f.write(content)
    f.close()

def main():
    args = sys.argv[1:]
    ifdiet = 0
    # 1. Check for the arg pattern:
    #   python3 gen.py 3 {-diet fc} {-name example}
    if len(args) == 0:
            print("Error: the parameter is missing. Give any value for the number of products")
            return
    if len(args) != 1 and len(args) != 3 and len(args) != 5:
        print("The arguments do not follow the pattern. Try again")
        return
    try:
        num = int(args[0])
        constraint_filename = f"instances/diet{num}.txt"
        ontology_filename = f"instances/diet{num}.owl"
        test_filename = f"instances/diet{num}.scala"
        java_filename = f"instances/diet{num}.java"
    except:
        print("Error: give a int value for the number of products")
        return
    if len(args) == 3:
        if args[1]=="-name":
            constraint_filename = f"instances/{args[2]}.txt"
            ontology_filename = f"instances/{args[2]}.owl"
            test_filename = f"instances/{args[2]}.scala"
            java_filename = f"instances/{args[2]}.java"
        else:
            if args[1]=="-diet":
                ifdiet = args[2]
            else:
                print("Error: forgotten the keyword -name or -diet")
                return
    if len(args) == 5:
        if args[1]=="-name" and args[3]=="-diet":
            constraint_filename = f"instances/{args[2]}.txt"
            ontology_filename = f"instances/{args[2]}.owl"
            test_filename = f"instances/{args[2]}.scala"
            java_filename = f"instances/{args[2]}.java"
            ifdiet = args[4]
        else:
            if args[3]=="-name" and args[1]=="-diet":
                constraint_filename = f"instances/{args[4]}.txt"
                ontology_filename = f"instances/{args[4]}.owl"
                test_filename = f"instances/{args[4]}.scala"
                java_filename = f"instances/{args[4]}.java"
                ifdiet = args[2]
            else:
                print("Error: forgotten the keyword -name and -diet")
                return
    if ifdiet not in {0,"fc","ff","fp","lc","lcf","wb"}:
        print("Error: your diet does not correspond any of the patterns fc,ff,fp,lc,lcf,wb")
        return
        
    if ifdiet == 0:
        ifdiet = random.choice(["fc","ff","fp","lc","lcf","wb"])
    #if (num > 1) and ifdiet in ["lc","lcf","wb"]:
    #    mydayintake = gen_dayintake(num)
    #    mydaycalories = gramsTocalories(mydayintake,ifdiet)
    #else:
    mydaycalories = gen_dayintake_diet(num,ifdiet)
    
    #print(ifdiet)
    #for k in mydaycalories:
    #    print(k)
    #checkIfdiet(mydaycalories,options[ifdiet])
    
    totalcalories = 0
    for i in mydaycalories:
        totalcalories += i.carbs_cal + i.protein_cal + i.fat_cal
    write_constraints(mydaycalories,totalcalories,constraint_filename)
    write_ontology(mydaycalories,totalcalories,ontology_filename)
    #write_test(ifdiet,test_filename,ontology_filename,constraint_filename)
    #write_java(ifdiet,java_filename,ontology_filename,constraint_filename)

if __name__ == "__main__":
    main()

