import random
import sys
from numpy.linalg import matrix_rank
import numpy as np

datapropertiesNum = 5

class LC:
    def __init__(self, activeNum):
        self.data = dict()
        for i in range(datapropertiesNum):
            self.data[i] = 0
        self.data['S'] = 0 #for sum
        if (activeNum < 0) or (activeNum > datapropertiesNum):
            print("Error: wrong number of active data properties")
            return
        elif activeNum == 0:
            return
        else:
            active = random.sample(range(datapropertiesNum),activeNum)
            for i in active:
                self.data[i] = random.randint(-20,20)
            self.data.update({'S': random.randint(-20,20)})

    def isEmpty(self):
        empty = True
        i = 0
        while empty and i < datapropertiesNum:
            if self.data[i] != 0:
                empty = False
            i += 1
        return empty
    
    def __str__(self):
        string = ""
        for i in range(datapropertiesNum):
            if self.data[i] != 0:
                string += f"\t{self.data[i]} * num{i}\n"
        string += f"\t= {self.data['S']}\n"
        return string

def lin(lc_array): #produce a LC which is a lin combination of lc_array
    result = LC(0)
    coef = []
    allzeros = True
    for j in range(len(lc_array)):
        #print(lc_array[j])
        coef.append (random.randint(-2,2))
        if coef[-1] != 0:
            allzeros = False
    if allzeros:
        coef[0] = 1
    for i in range(datapropertiesNum):
        for j in range(len(lc_array)):
            result.data[i] += coef[j] * lc_array[j].data[i]
    for j in range(len(lc_array)):
        result.data['S'] += coef[j] * lc_array[j].data['S']
    if result.isEmpty():
        #print(result)
        print("Failed to generate CD constraints: Error in lin combination \n ")
        for j in range(len(lc_array)):
            print(lc_array[j])
        exit
    return result
        
def gen_list(num):
#generate a list of independant constraints
    list = []
    coefficient_matrix = np.array([np.zeros(datapropertiesNum)])
    augmented_matrix = np.array([np.zeros(datapropertiesNum + 1)])
    while len(list) < min(datapropertiesNum , num + 1):
        lc_candidate = LC(random.randint(2,datapropertiesNum))
        my_row = [i for i in lc_candidate.data.values()]
#A linear system is consistent if and only if its coefficient matrix has the same rank as does its augmented matrix
        coefficient_matrix = np.r_[ coefficient_matrix, np.array([my_row[:-1]]) ]
        augmented_matrix = np.r_[ augmented_matrix, np.array([my_row]) ]
        if matrix_rank(augmented_matrix) == matrix_rank(coefficient_matrix):
            list.append(lc_candidate)
    while len(list) < num + 1:
        lc_candidate = lin(random.sample(list, 3))
        my_row = [i for i in lc_candidate.data.values()]
        coefficient_matrix = np.r_[ coefficient_matrix, np.array([my_row[:-1]]) ]
        augmented_matrix = np.r_[ augmented_matrix, np.array([my_row]) ]
        if matrix_rank(augmented_matrix) == matrix_rank(coefficient_matrix):
            list.append(lc_candidate)
    #print(coefficient_matrix)
    #print(augmented_matrix)
    return list

def write_constraints(num, filename):
    list = gen_list(num)

#start creating a constraint file
    content = "PREFIX : <http://www.semanticweb.org/alisa/ontologies/2023/concrete-domain/artificial#> \n\n"

    content += f"LC:\n {list[0]} \n"
    for i in range(num):
        content += f"LC{i}:\n {list[i+1]} \n"
        if i > 1:
            content += f"LC{i}-prime:\n {lin([list[0],list[i-1],list[i],list[i+1]])} \n"
        else:
            content += f"LC{i}-prime:\n {lin([list[0],list[i],list[i+1]])} \n"

    try:
        f = open(filename, "x")
    except:
        rewrite = input("The constraint file already exists. Do you want to re-write it? (y/n)\n")
        if rewrite == 'n':
            exit
        f = open(filename, "w")
    f.write(content)
    f.close()

def write_ontology(num,filename):
    content = "@prefix : <http://www.semanticweb.org/alisa/ontologies/2023/concrete-domain/artificial#> .\n@prefix owl: <http://www.w3.org/2002/07/owl#> .\n@prefix rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#> .\n@prefix xml: <http://www.w3.org/XML/1998/namespace> .\n@prefix xsd: <http://www.w3.org/2001/XMLSchema#> .\n@prefix rdfs: <http://www.w3.org/2000/01/rdf-schema#> .\n@base <http://www.semanticweb.org/alisa/ontologies/2023/concrete-domain/artificial#> .\n\n<http://www.semanticweb.org/alisa/ontologies/2023/concrete-domain/artificial#> rdf:type owl:Ontology .\n\n #################################################################\n#    Object Properties\n#################################################################\n\n :r rdf:type owl:ObjectProperty.\n\n #################################################################\n#    Data properties\n#################################################################\n\n"
    
    for i in range(datapropertiesNum):
        content += f":num{i} rdf:type owl:DatatypeProperty ;\n                                                                                       rdfs:range owl:real .\n\n"
    content += "#################################################################\n#    Classes\n#################################################################\n\n"
    content += ":B rdf:type owl:Class .\n\n :LC rdf:type owl:Class .\n\n"
    content += " :A rdf:type owl:Class ;\n          rdfs:subClassOf [ rdf:type owl:Restriction ;\n                            owl:onProperty :r ;\n                            owl:someValuesFrom [ owl:intersectionOf ( :C0\n                                                                      :LC\n                                                                    ) ;\n                                                 rdf:type owl:Class\n                                               ]\n                          ] .\n\n"
    
    for i in range(num):
        content += f" :LC{i} rdf:type owl:Class .\n\n :LC{i}-prime rdf:type owl:Class .\n\n"
    
    ### Fake values
    #for j in range(num):
    #    content += f" :F{j}"
    #    content += " rdf:type owl:Class ; \n          owl:equivalentClass [ owl:intersectionOf ( :LC\n                                                   "
    #    for i in range(j+1):
    #            content += f":LC{i}\n                                                   "
    #    content += ") ;\n                              rdf:type owl:Class ] .\n\n "
    ###
    
    for i in range(num-1):
        content += f" :C{i} rdf:type owl:Class ;\n                                                                            rdfs:subClassOf :LC{i} .\n\n :C{i}-prime rdf:type owl:Class ;\n          rdfs:subClassOf [ rdf:type owl:Restriction ;\n                            owl:onProperty :r ;\n                            owl:someValuesFrom [ owl:intersectionOf ( :C{i+1}\n                                                                      :LC\n"
        if i > 0:
            content += f"                                                                      :LC{i-1}\n"
        if i > 1:
            content += f"                                                                      :LC{i-2}\n"
        content += f"                                                                      :LC{i}\n"
        content += "                                                                    ) ;\n                                                 rdf:type owl:Class\n                                               ]\n                          ] .\n\n"
    content += f" :C{num-1} rdf:type owl:Class ;\n                                                                            rdfs:subClassOf :LC{num-1} .\n\n :C{num-1}-prime rdf:type owl:Class ;\n          rdfs:subClassOf :B .\n\n"
        
    content += "#################################################################\n#    General axioms\n#################################################################\n\n"
    for i in range(num):
        content += f"[ rdf:type owl:Restriction ;\n  owl:onProperty :r ;\n  owl:someValuesFrom [ owl:intersectionOf ( :C{i}\n                                            :LC{i}-prime\n                                          ) ;\n                       rdf:type owl:Class\n                     ] ;\n  rdfs:subClassOf :C{i}-prime\n] .\n"
    try:
        f = open(filename, "x")
    except:
        rewrite = input("The ontology file already exists. Do you want to re-write it? (y/n)\n")
        if rewrite == 'n':
            exit
        f = open(filename, "w")
    f.write(content)
    f.close()

def write_test(num,test_filename,ontology_filename,constraint_filename):
    content = f"  @Test\n  def testArtificial{num}"
    content += "(): Unit = {\n\n    val manager = OWLManager.createOWLOntologyManager()\n    val factory = manager.getOWLDataFactory()\n    def owlClass(name: String): OWLClass = {\n      factory.getOWLClass(IRI.create(\"http://www.semanticweb.org/alisa/ontologies/2023/concrete-domain/artificial#\" + name))\n    }\n\n    val classificationResult = testCase(\"/scalable/cd1/artificial/"
    content += f"{ontology_filename}"
    content += "\", \"/scalable/cd1/artificial/"
    content += f"{constraint_filename}"
    content += "\")\n\n    assert(classificationResult(owlClass(\"A\"))(owlClass(\"B\")))\n"
    content += "  }"
    try:
        f = open(test_filename, "x")
    except:
        rewrite = input("The scala file already exists. Do you want to re-write it? (y/n)\n")
        if rewrite == 'n':
            exit
        f = open(test_filename, "w")
    f.write(content)
    f.close()
    
def write_java(num,java_filename,ontology_filename,constraint_filename):
    content = "        initialise(\"src/test/resources/scalable/cd1/artificial/"
    content += ontology_filename
    content += "\", \"src/test/resources/scalable/cd1/artificial/"
    content += constraint_filename
    content += "\", \"http://www.semanticweb.org/alisa/ontologies/2023/concrete-domain/artificial#\", ReasonerName.Elk, ConcreteDomainName.LinearConstraints); \n        experimentWith(\"A\",\"B\");//true\n        experimentWith(\"LC0\",\"A\");//false\n"
    
    try:
        f = open(java_filename, "x")
    except:
        rewrite = input("The scala file already exists. Do you want to re-write it? (y/n)\n")
        if rewrite == 'n':
            exit
        f = open(java_filename, "w")
    f.write(content)
    f.close()

def main():
    args = sys.argv[1:]
    # 1. Check for the arg pattern:
    #   python3 gen.py 3 {-name example}
    if len(args) == 0:
            print("Error: the parameter is missing. Give any value for the number of products")
            return
    if len(args) != 1 and len(args) != 3 :
        print("The arguments do not follow the pattern. Try again")
        return
    try:
        num = int(args[0])
        constraint_filename = f"instances/artificial{num}.txt"
        ontology_filename = f"instances/artificial{num}.owl"
        test_filename = f"instances/artificial{num}.scala"
        java_filename = f"instances/artificial{num}.java"
    except:
        print("Error: give a int value as a parameter")
        return
    if len(args) == 3:
        if args[1]=="-name":
            constraint_filename = f"instances/{args[2]}.txt"
            ontology_filename = f"instances/{args[2]}.owl"
            test_filename = f"instances/{args[2]}.scala"
            java_filename = f"instances/{args[2]}.scala"
        else:
            print("Error: forgotten the keyword -name")
            return
    print(num)
    print("\n")
    write_ontology(num,ontology_filename)
    write_constraints(num,constraint_filename)
    #write_test(num,test_filename,ontology_filename,constraint_filename)
    #write_java(num,java_filename,ontology_filename,constraint_filename)


if __name__ == "__main__":
    main()

