This README file contains instructions on how to use the tool and re-run the experiment described in the paper.

The results of the experiment and the the computation time comparisons between our tool and Z3 can be found in **results.csv** and **timeZ3vsCD.csv** respectively.

* * *

#### <u>Getting Z3</u>



As part of our experiment, we compare the performance of our tool with Z3 solver.  
Before running the experiment, follow these steps to get Z3:

1.  Clone the Z3 repository ([https://github.com/Z3Prover/z3](https://github.com/Z3Prover/z3))
2.  In the root directory of Z3, run the following:
    1.  `python scripts/mk_make.py --java`
    2.  `cd build`
    3.  `make`
3.  After it is done, in the build directory, you should be able to find either:
    *   **libz3.so** and **libz3java.so**,
    *   or **libz3.dylib** and **libz3java.dylib**Which you need to copy to **experiment/z3Lib**.



* * *

#### <u>Running the Experiment</u>



Requirement: Java 8 (or Higher).  
To run the experiment, first make sure that the user account you will use to run the experiment has no Java process running.  
In **experiment/**, run

<pre> ./watcher.sh -u [your-user-name] </pre>

to start the experiment. To include Z3 time comparisons, run the previous command with `-z`.

* * *

#### <u>Using the Tool</u>



If you want to try the tool without running the full experiment, you can run it as in the following example:  

<pre>
java -cp cd.jar de.tu_dresden.lat.App
     -o src/test/resources/scalable/cd1/diet/instances/diet1a.owl 
     -c src/test/resources/scalable/cd1/diet/instances/diet1a.txt 
     -a "&lt;http://www.semanticweb.org/alisa/ontologies/2023/concrete-domain/diet#MyDayDiet&gt; <= &lt;http://www.semanticweb.org/alisa/ontologies/2023/concrete-domain/diet#Well-balanced&gt;" 
     -r Elk
     -cd linearConstraints
</pre>

You can also add the following additional options:

*   `-png`: to generate a PNG of the explanation
*   `-ee`: to enable correctness tests for the generated explanation
*   `-es`: to enable tracking of reasoning and explanation stats

To enable Z3 tests for CD reasoning, you need to set "`concrete-domain-reasoner.enableZ3Checks`" to true (`java -Dconcrete-domain-reasoner.enableZ3Checks=true -cp cd.jar de.tu_dresden.lat.App ...`)