!*****************************************************************
! This subroutine performs the VRC-TST calculations
! The references of the theoretical details for this implementation are:
!   1) Georgievskii Y. and Klippenstein S.J. JCP 2003, 118, 5442.
!   2) Georgievskii Y. and Klippenstein S.J. JPC A 2003, 107, 9776.
! It uses SPRNG random number generator for parallel Monte Carlo 
! integration.
!
! Called by
!
!   main
!
! By Jingjing Zheng Oct. 2007; MPI implementation on May 2008
!
!****************************************************************
!
      subroutine vrctst(irank,isize)
      use perconparam
      use common_inc
      use rate_const
      use cm
      use keyword_interface
!
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      include 'mpif.h'
!     SPRNG Related
#define SIMPLE_SPRNG
#define USE_MPI 1
#include "sprng_f.h"
      SPRNG_POINTER stream
!     parameter (maxe=16,maxj=60,jstep=5)
!     parameter (maxe=16,maxj=60)
!     parameter (maxs=90)
      dimension qcvt(maxs,40),qcvt2(maxs,40),qt(40),qt2(40),ip(2),
     *          err1(maxs,40),sabs(maxs),
     *          rcvt(40),rmute(40),rmutej(40),deltg(maxs,40),
     *          eqconst(40),rcvtr(40),rmuter(40),rmutejr(40)
      dimension etot(40,maxe),dnej(maxs,40,maxe,0:maxj),
     *          dne(maxs,40,maxe),dnee(maxs,40,maxe)
      dimension dnee2(maxs,40,maxe),dnej2(maxs,40,maxe,0:maxj),
     *          err2(maxs,40,maxe),err3(maxs,40,maxe,0:maxj)
      dimension dnejt(40,maxe,0:maxj),dnet(40,maxe),dneet(40,maxe)
     *          ,dnee2t(40,maxe),dnej2t(40,maxe,0:maxj)
      dimension endpts(2),bmuvt(maxe),tmuvt(maxe),wmuvt(maxe)
      dimension xpt(3),gpt(3)
      dimension tmp_mpi_qcvt(maxs,40),tmp_mpi_qcvt2(maxs,40),
     *          tmp_mpi_dnee(maxs,40,maxe),tmp_mpi_dne(maxs,40,maxe),
     *          tmp_mpi_dnej(maxs,40,maxe,0:maxj)
      dimension tmp_mpi_dnee2(maxs,40,maxe),
     *          tmp_mpi_dnej2(maxs,40,maxe,0:maxj)
      dimension iminc(40)
!
! add Feb 1 2010
      dimension nes(10),nessub(10),mpi_nes(10)

!     dimension tmp_mpi_1(2000000),tmp_mpi_2(2000000)
!     integer checkPT,seed
!
      dimension QVSV(N6TM)
      character*14 restart
      character*3  AFLAG
      logical      debug
      debug=.false.
! 
!     write the header for VRC-TST
!
      write(fu6,1000) 
      write(fu15,2000)
      write(fu15,2100)
      write(fu15,2200)

      do i = 1, 10
        nes(i) = 0
      enddo
!
      jmax=jmax/jstep
      if(jmax.gt.maxj) then
        write(fu6,*) 'Angular momentum quantum number J exceeds the ',
     *              'limit of array with the current JSTEP. '
        write(fu6,*) 'Increas MAXJ value in param.inc, or increase ',
     *               'JSTEP in the input file'
        stop 
      endif
!     initialize some array and variables for VRC-TST
!
      call initvrc
!
!     Check 2*svl should larger than the distance 
!     between any pivotpoint pairs those are within the same reactant 
!
!     svl2=4.0d0*svl*svl
!     do jtype = 1, 2
!      if(npvt(jtype).ge.2) then
!       do n1=1,npvt(jtype)
!       do n2=n1+1,npvt(jtype) 
!         dist=0.0d0
!         do k = 2, 0, -1
!          dist=dist+(xpp(n1*3-k,jtype)-xpp(n2*3-k,jtype))**2
!         enddo
!         if (dist.gt.svl2) then
!          svl2=dist
!          svl = 0.5d0*dsqrt(dist)
!          write(fu6,'(a24,f5.2)') 'change lower s bound to ', svl
!         endif
!       enddo
!       enddo
!      endif
!     enddo
!
!    make sure s is larger than the sum of two reactive atom van der Walls
!    radii plus the corresponding pivot point to the atom distance
!
!     call checks  
!
!     Check the number of dividing surfaces 
!
      ndvs=(svu-svl)/svs
      if(ndvs.gt.maxs) then
        write(fu6,*) 'Number of dividing surfaces exceeds the maximum ',
     *               'value ',maxs,', change MAXS value in param.inc'
        stop
      endif
!
      nc   = maxs*40
      nme  = nc*maxe
      nmej = nme*(maxj+1)
!
!
!     Initialize the array ENDPTS which is used in the gaussq subroutine
!
      endpts(1) = 0.D0                                                 
      endpts(2) = 0.D0         
      nemvt=nniter
! 
!     calculate reduced mass of two reactants
!
      r1mas=0.0d0
      do I= 1, nratom(1)
        r1mas = r1mas + svmas(iatsv(i,1))
      enddo
      r2mas=0.0d0
      do I= 1, nratom(2)
        r2mas = r2mas + svmas(iatsv(i,2))
      enddo
      redmf = (r1mas*r2mas)/(r1mas+r2mas)
!
!     Loop over the different lengthes of reaction coordinate vector s
!
      is=1
      sabs(is)=svl
!
      write(fu6,*) 'Running at the stage: '
      do while (sabs(is).le.svu)
        write(fu6,'(a3,f5.2)') 's= ',sabs(is)/gufac6
!
!     We use Modified Lagged Fibonacci Generator in SPRNG as default
!     which corrpesonds to igtype = 4
!
        iseed = 985456376
        stream = init_sprng(igtype,iseed,SPRNG_DEFAULT)
!     write(fu6,*) ' The following generator is used in SPRNG:'
        junk = print_sprng()
!
!     Determine nodes and weigths for Gauss-Laguerre quadrature
!
        call gaussq (6,nniter,0.0d0,0.0d0,0,ENDPTS,BMUVT,TMUVT,WMUVT) 
!
        ne0=0
        dele=-0.2d0*1.593601d-3
!       el=-3.0d0/ckcal
        do itemp=1,ntemp
           bkt=bk*temp(itemp)
           qcvt(is,itemp)=0.0d0
           qcvt2(is,itemp)=0.0d0
!          perr1(is,itemp)=0.0d0
!          perr2(is,itemp)=0.0d0
           do i=1,nemvt+ne0
             dne(is,itemp,i)=0.0d0
             dnee(is,itemp,i)=0.0d0
             dnee2(is,itemp,i)=0.0d0
             if(i.le.nemvt) then
              etot(itemp,i)=bkt*tmuvt(i)
             else
              etot(itemp,i)=dble(i-nemvt)*dele
             endif
             do j=0,jmax
               dnej(is,itemp,i,j)=0.0d0
               dnej2(is,itemp,i,j)=0.0d0
             enddo
           enddo
         enddo
         ntotp1=npvt(1)
         ntotp2=npvt(2)
         npp=0
         nacp=0
!
!        MPI Load Balance Checking
!        MPI_t1 = MPI_Wtime()
!        gtype = 2
!        checkPT = 0
!        print *, 'Check Pointing indicator ',checkPT
!        print *,' -1 for a continue run '
!        print *,'  0 for a run whose randum numbers can be reproduced'
!        print *,'  1 for a new run starting from any random numbers'
!        if(irank.lt.10) then
!        write(restart, '("../restart.00",I1)') irank
!        write(*, *) ' ID=', irank, ' Restart is named as ',restart
!        else if (irank.ge.10.and.irank.lt.100) then
!        write(restart, '("../restart.0",I2)') irank
!        write(*, *) ' ID=', irank, ' Restart is named as ',restart
!        else if (irank.ge.100.and.irank.lt.1000) then
!        write(restart, '("../restart.",I3)') irank
!        write(*, *) ' ID=', irank, ' Restart is named as ',restart
!        end if
!
!        if(checkPT.eq.0) then
!          For a run to repeat the previous random numbers
!          iseed = 985456376
!          stream = init_sprng(igtype,iseed,SPRNG_DEFAULT)
!
!        else if (checkPT.eq.1) then
!          for a new run
!          iseed = make_sprng_seed() !produce a new seed each time program is run
!          stream = init_sprng(igtype,iseed,SPRNG_DEFAULT)
!        else if (checkPT.eq.-1) then
!        for a continue run
!          open(130, file = restart, status = 'old', form = 'unformatted')
!          read(130) size
!          read(130) buffer1
!          stream = unpack_sprng(buffer1)
!          close(130)
!        endif
!
!      loop over all the facets in the MDS
!
         do i1=1, ntotp1
           do i2=1, ntotp2
             ip(1)=i1
             ip(2)=i2
c            if(svrc(i1,i2).le.0.0) goto 210
             npp=npp+1
             call vrcnej(ip,sabs(is),nemvt+ne0,qt,qt2,etot,dnet,dnejt,
     *       dnej2t,dneet,dnee2t,na,irank,isize,stream,nessub)          
              nacp=nacp+na
             do itemp=1, ntemp
               qcvt(is,itemp)=qcvt(is,itemp)+qt(itemp)
               qcvt2(is,itemp)=qcvt2(is,itemp)+qt2(itemp)
!              perr1(is,itemp)=perr1(is,itemp)+sig1(itemp)
!              perr2(is,itemp)=perr2(is,itemp)+sig2(itemp)
               do i=1,nemvt+ne0
!                write(fu6,2500) etot(i)*ckcal,dnet(i)
                 dne(is,itemp,i)=dne(is,itemp,i)+dnet(itemp,i)
                 dnee(is,itemp,i)=dnee(is,itemp,i)+dneet(itemp,i)
                 dnee2(is,itemp,i)=dnee2(is,itemp,i)+dnee2t(itemp,i)
                 do j=0,jmax
                  dnej(is,itemp,i,j)=dnej(is,itemp,i,j)+dnejt(itemp,i,j)
               dnej2(is,itemp,i,j)=dnej2(is,itemp,i,j)+dnej2t(itemp,i,j)
!                write(fu6,2540) etot(itemp,i)*ckcal,j*jstep,dnejt(itemp,i,j)
                 enddo
               enddo
             enddo
!
             do ne = 1, 10
               nes(ne)=nes(ne) + nessub(ne)
             enddo
           enddo
        enddo
!
        sabs(is+1) = sabs(is) + svs     
        is=is+1
!
      enddo 

      nsstep=is-1
  
!     write(fu6,*) 'Coming to MPI Reduction part now'
!
!      Synchronization  
      CALL MPI_Barrier(MPI_COMM_WORLD, ierr)
!
!      check the time used for MPI_Reduce
      time1 = MPI_Wtime()    
!     
!      Collect the results from each processor and sum them to processor 0
!
      CALL MPI_Reduce(qcvt,tmp_mpi_qcvt,nc,MPI_DOUBLE_PRECISION, 
     *MPI_SUM, 0, MPI_COMM_WORLD, ierr)
!
      Call MPI_Barrier(MPI_COMM_WORLD, ierr)
      CALL MPI_Reduce(qcvt2,tmp_mpi_qcvt2,nc,MPI_DOUBLE_PRECISION,
     *MPI_SUM, 0, MPI_COMM_WORLD, ierr)
!
!     Call MPI_Barrier(MPI_COMM_WORLD, ierr)
!     CALL MPI_Reduce(perr2,tmp_mpi_perr2,nc,MPI_DOUBLE_PRECISION,
!    *MPI_SUM, 0, MPI_COMM_WORLD, ierr)
!
      Call MPI_Barrier(MPI_COMM_WORLD, ierr)
      CALL MPI_Reduce(dnee,tmp_mpi_dnee,nme,MPI_DOUBLE_PRECISION,
     *MPI_SUM, 0, MPI_COMM_WORLD, ierr)
!
      Call MPI_Barrier(MPI_COMM_WORLD, ierr)
      CALL MPI_Reduce(dnee2,tmp_mpi_dnee2,nme,MPI_DOUBLE_PRECISION,
     *MPI_SUM, 0, MPI_COMM_WORLD, ierr)
!
      Call MPI_Barrier(MPI_COMM_WORLD, ierr)
      CALL MPI_Reduce(dne,tmp_mpi_dne,nme,MPI_DOUBLE_PRECISION,
     *MPI_SUM, 0, MPI_COMM_WORLD, ierr)
!
      Call MPI_Barrier(MPI_COMM_WORLD, ierr)
      CALL MPI_Reduce(dnej,tmp_mpi_dnej,nmej,MPI_DOUBLE_PRECISION,
     *MPI_SUM, 0, MPI_COMM_WORLD, ierr)

      Call MPI_Barrier(MPI_COMM_WORLD, ierr)
      CALL MPI_Reduce(dnej2,tmp_mpi_dnej2,nmej,MPI_DOUBLE_PRECISION,
     *MPI_SUM, 0, MPI_COMM_WORLD, ierr)

      CALL MPI_Barrier(MPI_COMM_WORLD, ierr)
!
      CALL MPI_Reduce(nes,mpi_nes,10,MPI_INTEGER,
     *MPI_SUM, 0, MPI_COMM_WORLD, ierr)
!
      CALL MPI_Barrier(MPI_COMM_WORLD, ierr)     
!
      dtime = MPI_Wtime() - time1
      IF (irank.eq.0) then
        write(fu6,'(a16,F10.4,a7)') 
     * 'MPI Reduce time = ',dtime,' second'
      endif
!             
!    Starting using Rank 0 to calculate final results
!
      if(irank.eq.0) then
!
!    statistics of energy distribution 
!
          do ne = 1, 10
            if (ne.eq.1) then
              write(fu6,'(a26,I8)')
     *        'No. of repulsive energies ',mpi_nes(ne)
            elseif (ne.eq.10) then
               write(fu6,'(a8,F5.2,I8)')'   V <= ',-8.d0,mpi_nes(ne)
            else
               write(fu6,'(F5.2,a8,F5.2,I8)')-1.*(ne-1),
     *         ' < V <= ',-1.*(ne-2),mpi_nes(ne)
            endif
          enddo
!
          nacp=nacp*isize
          write(fu6,2110) nacp
!
!    Number of available states N(s,T,E), N(s,T,E,J) 
!
          do is=1,nsstep
            do itemp=1, ntemp
              qcvt(is,itemp) = tmp_mpi_qcvt(is,itemp)/dble(nacp)
!
! ............... Average percentage error of Monte Carlo Integration
!
!             perr1(is,itemp)=tmp_mpi_perr1(is,itemp)/dble(nacp)
!             perr2(is,itemp)=tmp_mpi_perr2(is,itemp)/dble(nacp)
              qcvt2(is,itemp) = tmp_mpi_qcvt2(is,itemp)/dble(nacp)
!             terr=perr1(is,itemp)**2-perr2(is,itemp)
              terr=qcvt(is,itemp)**2-qcvt2(is,itemp)
!             err(is,itemp)=1.0d2*dsqrt(abs(terr/dble(nacp)))/perr1(is,itemp)0128JZ10
!             err1(is,itemp)=1.0d2*dsqrt(abs(terr/dble(nacp)))/qcvt(is,itemp)
              err1(is,itemp)=67.45*dsqrt(abs(terr/dble(nacp)))/
     *        qcvt(is,itemp)
            end do

            do itemp=1,ntemp
!             write(fu6,2430) temp(itemp)
!             write(fu6,2420)
!             qcvt(is,itemp)=qcvt(is,itemp)/dble(nacp)
              do i=1,nemvt+ne0
                dne(is,itemp,i)=tmp_mpi_dne(is,itemp,i)/dble(nacp)
                dnee(is,itemp,i)=tmp_mpi_dnee(is,itemp,i)/dble(nacp)
                dnee2(is,itemp,i)=tmp_mpi_dnee2(is,itemp,i)/dble(nacp)
!
!   estimate MC errors for each N(E) 
!
                terr=dnee(is,itemp,i)**2-dnee2(is,itemp,i)
                err2(is,itemp,i)=67.45*dsqrt(abs(terr/dble(nacp)))/
     *                        dnee(is,itemp,i)
!               write(fu6,2500) etot(itemp,i)*ckcal,dne(is,itemp,i),
!    *                     dnee(is,itemp,i)
              enddo
!             write(fu6,2520)
              do i=1,nemvt+ne0
                do j=0,jmax
                  dnej(is,itemp,i,j)=tmp_mpi_dnej(is,itemp,i,j)/
     *            dble(nacp)
                  dnej2(is,itemp,i,j)=tmp_mpi_dnej2(is,itemp,i,j)/
     *            dble(nacp)
!                 dnej(is,itemp,i,j)=dnej(is,itemp,i,j)/dble(nacp)
!                 write(fu6,2540)etot(itemp,i)*ckcal,j*jstep,dnej(is,itemp,i,j)
!    
!   estimate MC errors for each N(E) 
!          
                  terr=dnej(is,itemp,i,j)**2-dnej2(is,itemp,i,j)
                  if (dnej(is,itemp,i,j).gt.0.) then
                    err3(is,itemp,i,j)=67.45*dsqrt(abs(terr/dble(nacp)))
     *              /dnej(is,itemp,i,j)
                  else
                    err3(is,itemp,i,j)= 0.0
                  endif
! 
                enddo
              enddo
            enddo
          enddo
!          
!    END of calculating number of available states N(s,T,E), N(s,T,E,J)
!
!    output the N(E)
!
          ncol=4
          if(mod(nemvt+ne0,ncol).eq.0) then
           nl = (nemvt+ne0)/ncol-1
          else
           nl = (nemvt+ne0)/ncol
          endif
          write(fu6,2500)
          do itemp = 1, ntemp
             write(fu6,'(/a6,F8.1,a2)') '   T =',temp(itemp),' K'
             write(fu6,2510)
             do ie = 0, nl
               k2 = nemvt+ne0-ncol*(ie+1)
               if (k2. ge. 0) then
                 write(fu6,2520) (etot(itemp,ncol*ie+k)*ckcal,k=1,ncol)
                 do is = 1, nsstep
                    write(fu6,2530) sabs(is)/gufac6,
     *                   (dnee(is,itemp,ncol*ie+k),
     *                  err2(is,itemp,ncol*ie+k),k=1,ncol)
                 enddo
               else 
                 k2 = -k2
                 write(fu6,2520) (etot(itemp,ncol*ie+k)*ckcal,k=1,k2)
                 do is = 1, nsstep
                   write(fu6,2530) sabs(is)/gufac6,
     *                  (dnee(is,itemp,ncol*ie+k),
     *                   err2(is,itemp,ncol*ie+k),k=1,k2) 
                 enddo
               endif
             enddo
          enddo
!
!     output the N(E,J)
!
          ncol=3
          write(fu6,2550)
          do itemp = 1, ntemp
            do ie = 1, nemvt+ne0
!
              write(fu6,2560) temp(itemp),etot(itemp,ie)*ckcal
              write(fu6,2570)
              do j = 0, jmax/(ncol+1)
                 k2=jmax - ncol*(j+1)
                 if (k2.ge.0) then
                   write(fu6,2580) ((j*(ncol+1)+k)*jstep,k=0,ncol)
                   do is = 1, nsstep
                     write(fu6,2590) sabs(is)/gufac6,
     *                    (dnej(is,itemp,ie,j*(ncol+1)+k),
     *                     err3(is,itemp,ie,j*(ncol+1)+k),k=0,ncol)
                   enddo
                 else
                   k2 = -k2
                   write(fu6,2580) ((j*(ncol+1)+k)*jstep,k=0,k2)
                   do is = 1, nsstep
                     write(fu6,2590) sabs(is)/gufac6,
     *                    (dnej(is,itemp,ie,j*(ncol+1)+k),
     *                     err3(is,itemp,ie,j*(ncol+1)+k),k=0,k2)
                   enddo
                 endif
              enddo          
            enddo
          enddo
!
          do itemp=1, ntemp
             bkt=bk*temp(itemp)
!
!    Reactant translational, rotational, and electronic partition functions
!    Some pieces of following codes are take from subroutine rate
!    we only consider A + B -> AB case here.
!
!    Two Reactants
! ............... TRANSLATION
!
            if (icode(1).gt.0.or.icode(2).gt.0) then
              qtr = ((redmf*bkt)/tpi)**1.5D0
              qtrcc = qtr*conk0
!             if(debug) write(fu6,*) 'Qtr= ',qtrcc
            else 
              qtr = 1.0d0
              qtrcc = 1.0d0
            endif             
!
! ............... ROTATION
!
            if (icode(1).gt.0.and.icode(2).gt.0) then
             qrr=rpart(fmom(1),bkt,icode(1))*rpart(fmom(2),bkt,icode(2))
!            if(debug) write(fu6,*) 'Qrot= ', qrr
            else if(icode(1).gt.0.and.lgs(34).ne.0) then
             qrr= rpart(fmom(1),bkt,icode(1))
            else
             qrr= 1.0d0
            endif 
!
! ............... ElECTRONIC
!
            qer= epart(1,bkt)*epart(2,bkt)
!           if(debug) write(fu6,*) 'Qer= ',qer
!
            ptotr=sigmaf*(1.0d0/tpi)/(qtrcc*qrr*qer)
!
!   Calculations for equilibrium constants and reverse rate
!
            IF (ibrate.eq.1) THEN

!
!   One  PRODUCT
!   .....................  TRANSLATION
!
              IF (ICODE(3) .GT. 0 .AND. LGS(34) .NE. 0) THEN       
                 QTP = ((REDMR*BKT)/(2.0D0*PI))**1.5D0             
                 QTPCC = QTP*CONK0                                 
              ELSE                                                 
                 QTP = 1.0D0                                       
                 QTPCC = 1.0D0                                     
              ENDIF                                                
!
!   ................ ROTATION
!
              IF (ICODE(3) .GT. 0) THEN
                QRP = RPART(FMOM(3),BKT,ICODE(3))
              ELSE                                                 
                QRP = 1.0D0                                       
              ENDIF                                                
!
!   ...............  ELECTRONIC
!
              QEP = EPART(3,BKT)
!
              ptotp=sigmar*(1.0d0/tpi)/(qtpcc*qrp*qep)     
!
!    REACTANT AND PRODUCT VIBRATIONAL PFS
!
              FAC37 = DBLE(LGS(37))*LOG(10.0D0)                         6/13T89
              IOP = 1
              IBEG = 1
!*            PROD = 1.0D0                                              6/13T89
              SUM = 0.0D0                                               6/13T89
              AFLAG = '   '
              IF (LGS(5).GE.21) AFLAG = 'SET'                           6/30YL91
              DO IY = 1, 2 
                IF (NF(IY).NE.0.AND.LGS2(15).EQ.0) THEN                 1106YL92
                   IENDR = NF(IY)+IBEG-1
                   J = 1
                   DO IX = IBEG, IENDR
!                    IF (AFLAG.EQ.'SET') LGS(5) = MODER(IY,J)           0317Yc99
                     LGS(5) = MODER(IY,J)                               0317Yc99
                     L0 = LRP(IX)
                     IKBM = IX
                     IF (LGS(5).EQ.9) THEN                              6/30YL91
                        IF (IY .EQ. 1) THEN
                           IMHR = NF(1)+1-IX
                        ELSE
                           IMHR = NF(1)+NF(2)+1-IX
                        ENDIF
                        IF (IY.EQ.2) THEN
                           IXI = IX - NF(1)
                        ELSE
                          IXI = IX
                        ENDIF
                        QVSV(IX)=HRPART(0.d0,WER(IX),TORMI(IY,IXI,1),   1020BE06
     *                  BKT,IY,IXI,IMHR)                                1020BE06
                     ELSE                                               ..
                        QVSV(IX)=VPART(WER(IX),XER(IX),BKT,DEMIN,IOP,   ..
     *                  Y00R(IX))                                       ..
                     ENDIF                                              6/30YL91
                     J = J+1
!*                   PROD = PROD*QVSV(IX)                               6/13T89
                     SUM = SUM + LOG(QVSV(IX))                          6/13T89
                  ENDDO
!                 IF (LGS2(12) .NE. 0) THEN
!                 0719WH94
! Commented by Lucas; it should be changed to the following line
! so that under HO approximation, vib P.F. of R and P shold not be
! changed
                  IF ((LGS2(12).NE.0).AND.(LGS2(12).NE.1)) THEN         2017Lucas
                    IM = NF(1)+1-IWR
                    SUM = SUM - LOG(QVSV(1)*QVSV(IM))                   0719WH94
                    CALL QTQVIB(BKT,QVIBF,QVIBR)                        0719WH94
                    QVSV(1)  = QVIBF                                    0719WH94
                    QVSV(IM) = QVIBR                                    0719WH94
                    IF (IM .EQ. 1) QVSV(IM) = QVIBF                     0719WH94
                    SUM = SUM + LOG(QVIBF*QVIBR)                        0719WH94
                  ENDIF
!
                ELSEIF (NF(IY).NE.0.AND.LGS2(15).NE.0) THEN             1106YL92
                  NMOD = NF(IY)                                         ..
                  EGRNDT = EGRNDR(IY)                                   ..
                  DUMMY = PTQVIB(NMOD,N3TM,EGRNDT,EFNDTR(IBEG),         ..
     *                          WER(IBEG),BKT)                          ..
                  PROD = PROD * DUMMY                                   ..
                  SUM = SUM + LOG(DUMMY)                                ..
                ENDIF                                                   1106YL92
                IBEG = IBEG+NF(IY)
                IOP = IOP+1
              ENDDO
              SUMRE = SUM                                               0423TA02
              QVR = EXP(SUM+FAC37)                                      6/13T89
              IBEGP = IBEG
              SUM = 0.0D0                                               6/13T89
              EMAX = DEMIN-EPRD
              IVP = 4
!             IF (LGS(6).EQ.2) IVP = 3
              IVP = 3                                                   0111JZ10
              DO IY = 3, IVP
                IF (NF(IY).NE.0.AND.LGS2(15).EQ.0) THEN                 1106YL92
                   IENDP = NF(IY)+IBEG-1
                   J = 1
                   DO IX = IBEG, IENDP
                     LGS(5) = MODER(IY,J)                               0317Yc99
                     L0 = LRP(IX)
                     IKBM = IX
                     IF (LGS(5).EQ.9) THEN                              6/30YL91
                       IF (IY .EQ. 3) THEN                              0615WH94
                          IMHR = NF(1)+NF(2)+NF(3)+1-IX                 0615WH94
                       ELSE                                             0615WH94
                          IMHR = NF(1)+NF(2)+NF(3)+NF(4)+1-IX           0615WH94
                       ENDIF     
                       IF (IY.EQ.4) THEN
                         IXI = IX - NF(1) - NF(2) - NF(3)
                       ELSE
                         IXI = IX - NF(1) - NF(2)
                       ENDIF
                       QVSV(IX)=HRPART(0.d0,WER(IX),TORMI(IY,IXI,1),    1020BE06
     *                               BKT,IY,IXI,IMHR)                   1020BE06
                     ELSE                                               ..
                       QVSV(IX)=VPART(WER(IX),XER(IX),BKT,EMAX,IOP,     ..
     *                              Y00R(IX))                           ..
                     ENDIF                                              6/30YL91
                     J = J+1
!*                   PROD = PROD*QVSV(IX)                               6/13T89
                    SUM = SUM + LOG(QVSV(IX))                           6/13T89
                  ENDDO
                ELSEIF (NF(IY).NE.0.AND.LGS2(15).NE.0) THEN             1106YL92
                  EGRNDT = EGRNDR(IY)                                   ..
                  NMOD = NF(IY)                                         ..
                  DUMMY = PTQVIB(NMOD,N3TM,EGRNDT,EFNDTR(IBEG),         ..
     *                        WER(IBEG),BKT)                            ..
                  PROD = PROD * DUMMY                                   ..
                  SUM = SUM + LOG(DUMMY)                                ..
                ENDIF                                                   1106YL92
                IBEG = IBEG+NF(IY)
                IOP = IOP+1
              ENDDO
              SUMPR = SUM                                               0423TA02
              QVP = EXP(SUM+FAC37)                                      6/13T89
!
!     Equilibrium constants
!
              eqconst(itemp) = ptotr*qvp/(ptotp*qvr)*exp(-eprd/bkt)
!
!    END of calculations for equilibrim constants and reverse rates
            ENDIF
!
!
! ...............Canonical TST RATE CONSTANT
!
            imin = 1
            qmin=qcvt(1,itemp)
            smin=sabs(imin)
            do is=1,nsstep-1
!              if(qcvt(is,itemp).gt.qcvt(is+1,itemp)) then
               if(qmin.gt.qcvt(is+1,itemp)) then
                 qmin = qcvt(is+1,itemp)
                 imin = is+1
                 smin=sabs(imin)
               endif
! 
! ...............Calculate Generalized TS DeltaG at CVT level 
!
               deltg(is,itemp) =LOG(bkt/(tpi*ptotr*epart(5,bkt)*
     *                        qcvt(is,itemp)))
               deltg(is,itemp) =deltg(is,itemp)*rconst*temp(itemp)
!
            enddo
!
            deltg(is,itemp) =LOG(bkt/(tpi*ptotr*epart(5,bkt)*
     *                      qcvt(is,itemp)))
            deltg(is,itemp) =deltg(is,itemp)*rconst*temp(itemp)
!
            iminc(itemp) = imin
            if(imin.ne.1.and.imin.ne.nsstep) then
              k = imin-2
              do i = 1, 3
                xpt(i) = sabs(k+i)
                gpt(i) = qcvt(k+i,itemp)
               enddo
               if(gpt(2).lt.gpt(1).and.gpt(2).lt.gpt(3).and.
     *           gpt(2).gt.0.0d0) then
                 call trept(1,xpt,gpt,smin,qmin)
                 if(qmin.lt.0.d0) qmin=gpt(2)
!                write(fu6,*) xpt(1),xpt(2),xpt(3),smin
!                write(fu6,*) gpt(1),gpt(2),gpt(3),qmin
               endif
!            write(fu6,*) 'nsstep= ',nsstep,'imin= ',imin
!            write(fu6,*) 'Three Point Fit'
            endif
            rcvt(itemp)=ptotr*epart(5,bkt)*qmin*cnvrt
            rcvtr(itemp)=rcvt(itemp)/eqconst(itemp)
            scvt(itemp)=smin
!
!
! ...............Microcanonical RATE
!
            qmute=0.0d0
            qmute0=0.0d0
            do ie=1,nemvt+ne0
              qmin = dnee(1,itemp,ie)
              imin=1
              do is = 1, nsstep-1
!               if(dnee(is,itemp,ie).gt.dnee(is+1,itemp,ie)) then
                if(qmin.gt.dnee(is+1,itemp,ie)) then
                  qmin = dnee(is+1,itemp,ie)
                  imin = is+1
                endif
              enddo    
              if(imin.ne.1.and.imin.ne.nsstep) then
                k = imin - 2
                do i=1, 3
                  xpt(i)=sabs(k+i)
                  gpt(i)=dnee(k+i,itemp,ie)
                enddo           
                if(gpt(2).lt.gpt(1).and.gpt(2).lt.gpt(3).and.
     *          gpt(2).gt.0.0d0) then
                   call trept(1,xpt,gpt,smin,qmin)
                   if(qmin.lt.0.d0) qmin=gpt(2)
!                  write(fu6,*) xpt(1),xpt(2),xpt(3),smin
!                  write(fu6,*) gpt(1),gpt(2),gpt(3),qmin
                endif
!               if (qmin.gt.gpt(2)) then
!                 write(fu6,*) 'warning: a max is found instead of min',
!    *            'T= ',temp(itemp),'E= ',etot(xpt(2),ie)
!               endif
            elseif((imin.eq.1.or.imin.eq.nsstep).and.qmin.gt.1.d0) then
                write(fu6,2120) sabs(imin)/gufac6,temp(itemp), 
     *                          etot(itemp,ie)*ckcal
              endif
              if(ie.le.nemvt) then
                qmute=qmute+qmin*wmuvt(ie)
              else
                if(ie.eq.nemvt+1.or.ie.eq.nemvt+ne0) then
                  qmute0=qmute0+qmin*exp(-etot(itemp,ie)/bkt)
                elseif(mod(ie-nemvt,2).eq.0) then
                  qmute0=qmute0+2.0d0*qmin*exp(-etot(itemp,ie)/bkt)
                else
                  qmute0=qmute0+4.0d0*qmin*exp(-etot(itemp,ie)/bkt)
                endif
              endif
            enddo
            qmute=qmute*bkt+qmute0*abs(dele)/3.0d0
            rmute(itemp)=ptotr*epart(5,bkt)*qmute*cnvrt
            rmuter(itemp)=rmute(itemp)/eqconst(itemp)
!
! ...............E,J-resolved Microcanonical RATE
!
            qmutej=0.0d0
            qmutej0=0.0d0
!           write(fu6,*) ' Minimized N(E,J) at E,J-resolved level, T= ', 
!    *                   temp(itemp)
            do ie=1, nemvt+ne0
              do ij=0, jmax     
!               dnejt(itemp,ie,ij)=dnej(1,itemp,ie,ij)
                qmin=dnej(1,itemp,ie,ij)
                imin=1
                do is=1, nsstep-1
!                 if(dnej(is,itemp,ie,ij).gt.dnej(is+1,itemp,ie,ij)) then
                  if(qmin.gt.dnej(is+1,itemp,ie,ij)) then
!                     dnejt(itemp,ie,ij)=dnej(is+1,itemp,ie,ij)
                      qmin=dnej(is+1,itemp,ie,ij)
                      imin = is+1
                  endif
                enddo
                if(imin.ne.1.and.imin.ne.nsstep) then
                   k = imin - 2
                   do i=1,3
                     xpt(i)=sabs(k+i)
                     gpt(i)=dnej(k+i,itemp,ie,ij)
                   enddo
                   if(gpt(2).lt.gpt(1).and.gpt(2).lt.gpt(3).and.
     *             gpt(2).gt.0.0d0) then
                   call trept(1,xpt,gpt,smin,qmin)
                     if(qmin.lt.0.d0) qmin=gpt(2)
!                    write(fu6,*) xpt(1),xpt(2),xpt(3),smin
!                    write(fu6,*) gpt(1),gpt(2),gpt(3),qmin
                   endif
                   if (qmin.gt.gpt(2)) then
!                   write(fu6,2130)  sabs(imin)/gufac6,temp(itemp),
!    +              etot(imin,ie)*ckcal,ij*jstep    
                    qmin=dnej(imin,itemp,ie,ij)
                   endif
             elseif((imin.eq.1.or.imin.eq.nsstep).and.qmin.gt.1.d0) then
                   write(fu6,2130) sabs(imin)/gufac6,temp(itemp),
     *                             etot(itemp,ie)*ckcal,ij*jstep
                endif
                dnejt(itemp,ie,ij)=qmin
!               write(fu6, *) 'E= ',etot(itemp,ie),' J= ',ij,' N(E,J)= ',
!    *                        dnejt(itemp,ie,ij)
              enddo
            enddo

!            write(fu6,*) ' Minimized N(E) at E,J-resolved level, T= ', 
!    *                    temp(itemp)
            do ie=1,nemvt+ne0
              dnet(itemp,ie)=0.0d0
            enddo
            do ie=1,nemvt+ne0
              do ij=0,jmax
                if(ij.eq.0.or.ij.eq.jmax) then
                  dnet(itemp,ie)=dnet(itemp,ie)+dnejt(itemp,ie,ij)
                elseif(mod(ij,2).eq.0.and.ij.ne.jmax) then
                  dnet(itemp,ie)=dnet(itemp,ie)+2.0d0*dnejt(itemp,ie,ij)
                else
                  dnet(itemp,ie)=dnet(itemp,ie)+4.0d0*dnejt(itemp,ie,ij)
                endif
              enddo
              dnet(itemp,ie)=dnet(itemp,ie)*jstep/3.0d0
!             write(fu6,*) 'E= ',etot(itemp,ie)*ckcal,'N(E)= ',
!    *                     dnet(itemp,ie) 
              if(ie.le.nemvt) then
                qmutej=qmutej+dnet(itemp,ie)*wmuvt(ie)
              else
                if(ie.eq.nemvt+1.or.ie.eq.nemvt+ne0) then
                  qmutej0=qmutej0+dnet(itemp,ie)*exp(-etot(itemp,ie)/
     *            bkt)
                elseif(mod(ie-nemvt,2).eq.0) then
                  qmutej0=qmutej0+2.0d0*dnet(itemp,ie)*
     *            exp(-etot(itemp,ie)/bkt)
                else
                  qmutej0=qmutej0+4.0d0*dnet(itemp,ie)*
     *            exp(-etot(itemp,ie)/bkt)
                endif
              endif
            enddo
            qmutej=qmutej*bkt+qmutej0*abs(dele)/3.0d0
            rmutej(itemp)=ptotr*epart(5,bkt)*qmutej*cnvrt
            rmutejr(itemp)=rmutej(itemp)/eqconst(itemp)
!
            write(fu15,2400) temp(itemp),rcvt(itemp),rmute(itemp),
     *                       rmutej(itemp)
!
          enddo 
!
!         output the free energy along reaction coordinate
!         at canonical level
!
          write(fu6,2230)
          ncol=6
          nr = ntemp/ncol
          if (mod(ntemp,ncol).eq.0) nr = nr  - 1  
          do kt = 0,nr
            k2 = ntemp-ncol*(kt+1)
            if (k2.ge.0) then
               write(fu6,2430)(temp(ncol*kt+k1),k1=1,ncol)
            else
               k2 = -k2
               write(fu6,2430)(temp(ncol*kt+k1),k1=1,k2)
            endif
            do ks = 1, nsstep
               if (k2.ge.0) then
                 write(fu6,2240)sabs(ks)/gufac6,
     *           (deltg(ks,ncol*kt+k1),k1=1,ncol)
               else 
                 k2 = - k2
                 write(fu6,2240)sabs(ks)/gufac6,
     *          (deltg(ks,ncol*kt+k1),k1=1,k2)
               endif
             enddo
          enddo
!
!       output the rate constants 
!
!       Forward CVT RATE
!
          write(fu6,2250)
          do itemp=1,ntemp       
            imin = iminc(itemp)
            write(fu6,2300) temp(itemp),rcvt(itemp),scvt(itemp)/gufac6,
     *                      err1(imin,itemp)
          enddo
!
!       Forward muVT and E,J-muVT RATE
!
          write(fu6,2260)
          write(fu6,2270)
          do itemp=1,ntemp
            write(fu6,2320) temp(itemp),rmute(itemp),rmutej(itemp)
          enddo
!
!      output the equilibrium constant and reverse rate
!
          write(fu6,3000)
          IF (ibrate.eq.1) THEN
            do itemp=1,ntemp
              write(fu6,3100) temp(itemp),rcvtr(itemp),rmuter(itemp),
     *                        rmutejr(itemp)
            enddo
            write(fu6,3200)
            do itemp=1,ntemp
             write(fu6,3300) temp(itemp),eqconst(itemp),
     *                       1.0d0/eqconst(itemp)
            enddo
          ENDIF
!
!   The follwoing is used for debug and exploring work
!
!         write(fu6,*) 'MC error in % for integrals in CVT'
!         ncol=6
!         nr = ntemp/ncol
!         if (mod(ntemp,ncol).eq.0) nr = nr  - 1  
!         do kt = 0,nr
!           k2 = ntemp-ncol*(kt+1)
!           if (k2.ge.0) then
!           write(fu6,2430)(temp(ncol*kt+k1),k1=1,ncol)
!           else
!           k2 = -k2
!           write(fu6,2430)(temp(ncol*kt+k1),k1=1,k2)
!           endif
!           do ks = 1, nsstep
!             if (k2.ge.0) then
!             write(fu6,2240)sabs(ks)/gufac6,
!    *             (err1(ks,ncol*kt+k1),k1=1,ncol)
!             else 
!             k2 = - k2
!             write(fu6,2240)sabs(ks)/gufac6,
!    *             (err1(ks,ncol*kt+k1),k1=1,k2)
!             endif
!           enddo
!         enddo
!  
!
!
      ENDIF ! IF ( IRANK.EQ.0 ) THEN
!
1000  format(//80('-'),/25X,'Starting VRC-VTST calculations',/,80('-'))
2000  format(1X,'The following are VRC-VTST calculation results.')
2100  format(/1X,'Summary of forward rate constants ',
     *      '(cm**3 molecule-1 s-1) :')
2110  format(/3X,'Total number of sampling for each dividing surface is'
     *       ,I8)
2120  format(/3X,'warning: N(E) min reach the boundary of s at: ','s=',
     *       f4.1,1X,'T=',f7.2,1X,'E=',f6.2)
2130  format(/3X,'warning: N(E,J) min reach the boundary of s at: ',
     *       's= ',f4.1,1X,'T=',f7.2,1X,'E=',f6.2,2X,'J=',I4)
2200  format(/4X,'T(K)',10X,'CVT',6X,'muVT(E)',3X,'muVT(E,J)')
2230  format(/3X,20('-'),'Free Energy using CVT (kcal/mol)',20('-'),/)
2240  format(4X,f5.2,7X,6f9.2)
2250  format(/3X,16('-'),'Canonical Rate Constants (cm**3 molecule-1 s-1
     *)',16('-'),/)
2260  format(/3X,13('-'),'Mirocanonical Rate Constants ',
     *        '(cm**3 molecule-1 s-1)',13('-'),/)
2270  format(/4X,'T(K)',5X,'muVT',10X,'E,J-muVT')
2300  format(3X,'CVT (',F7.2,') = ',1PE15.7,4X,0P,'s = ',f6.2,5X,
     *       'MC error(%) = ',f8.2)
c2320  format(3X,'muVT (',F7.2,') = ',1PE15.7)
2320  format(3X,F7.2,1PE15.7,0P,1PE15.7)
2340  format(3X,'E,J-muVT (',F7.2,') = ',1PE15.7)
2400  format(1X,f8.2,5X,1PE10.2,0P,1PE10.2,0P,1PE10.2)
2420  format(1X,'E (kcal/mol)',4X,'E,J-resolved N(E)',4X,
     *       'E-resolved N(E)')
2430  format(/5X,'s',4X,'T(K)= ',6f9.1,/)
c2500  format(2X,f8.2,6X,1PE12.4,0P,9X,1PE12.4)
c2520  format(/1X,'E (kcal/mol)',7X,'J',9X,'N(E,J)')
c2540  format(2X,f8.2,8X,I3,5X,1PE12.4)
2500  format(/80('*')/,'*',24X,'Number of available states N(E)',23X,'*'
     *       ,/80('*'))
2510  format(/4X,'s',4X,16('~'),' E (kcal/mol) ',16('~'),/)
2520  format(7X,4(F12.2,5X))
2530  format(F7.2,1PE12.4,'(',F5.1,'%)',0P,1PE12.4,'(',F5.1,'%)',0P,
     * 1PE12.4,'(',F5.1,'%)',0P,1PE12.4,'(',F5.1,'%)')
2550  format(/80('*')/,'*',23X,'Number of available states N(E,J)',22X,
     *       '*',/80('*'))
2560  format(/3X,12('*'),'Temperature =',F8.1,' K',2X,'Total Energy =',
     *       F8.2,' kcal/mol',12('*')) 
2570  format(/4X,'s',4X,15('~'),' Total angular momentum quantum number 
     *J ',15('~'),/)
2580  format(7X,4(12X,I4))
2590  format(F7.2,1PE10.2'(',F5.1,'%)',3(0P,1PE10.2,'(',F5.1,'%)'))
3000  format(/3X,24('-'),'Reverse Rate Constants (s-1)',24('-'),/,
     *       4X,'Temp(K)',6X,'CVT',14X,'muVT',12X,'E,J-muVT',/)
3100  format(3X,F7.2,1PE15.7,4X,0P,1PE15.7,0P,1PE15.7)
3200  format(/3X,11('-'),'Equilibrium Constants (cm**3/molecule or molec
     *ule/cm**3)',11('-'),/,4X,'Temp(K)',4X,'Forward',8X,'Reverse',/)
3300  format(3X,F7.2,1PE15.7,0P,1PE15.7,0P)
      return
      end subroutine vrctst
!
!
      subroutine vrcnej(ip,sabs,nemvt,qt,qt2,etot,dne,dnej,dnej2,dnee,
     * dnee2,nacp,irank,isize,stream,nessub)
      use perconparam
      use common_inc
      use rate_const
      use cm
!
!*******************************************************************
!
! subroutine to calculate number of available states of transitional modes 
! using VRC-TST algorithm at canonical, microcanonical, and E-J resolved 
! microcanonical level.
!
!*******************************************************************
!
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      include 'mpif.h'
!     include 'param.inc'
!     include 'percon.inc'
!     include 'common.inc'
      logical debug,lclose
!     parameter (maxe=16,maxj=60,jstep=5)
!     parameter (maxe=16,maxj=60)
      dimension xrcm(3,2),tp(3),dpcom(2),xtemp(n3tm)
      dimension nrfd(2),ct(2),st(2),cph(2),sph(2),cps(2),sps(2),
     *          ainv(3,3),a12inv(3),svec(3),usvec(3)
      dimension dd(2,3),fpmoi(5,3),fpvec(5,3,3),dmcint(40),dmc2(40),
     *          ip(2),xpprot(n3pt,2),qt(40),qt2(40),abc(5,3)
      dimension dnej(40,maxe,0:maxj),dne(40,maxe),etot(40,maxe),
     *          dnee(40,maxe),dnee2(40,maxe),dnej2(40,maxe,0:maxj)
!  
! added Feb. 1 2010
!
      dimension nessub(10) 
!     SPRNG Related
#define SIMPLE_SPRNG
#define USE_MPI 1
#include "sprng_f.h"
      SPRNG_POINTER stream
!
      debug=.false.

      do i = 1,10
        nessub(i) = 0
      enddo
!
!     sabs=svrc(ip(1),ip(2))
! initialize array dnej(e,j)
!
      do itemp=1,ntemp
        do i=1,nemvt
          dne(itemp,i)=0.0d0
          dnee(itemp,i)=0.0d0
          dnee2(itemp,i)=0.0d0
          do j=0,jmax
            dnej(itemp,i,j)=0.0d0
            dnej2(itemp,i,j)=0.0d0
          enddo
        enddo
      enddo
!
! calculate coordinates of each fragment relative to its pivot point
!     
      do j=1,2
!
         do k=2,0,-1
           xtemp(3-k)=xpp(3*ip(j)-k,j)
         enddo
         ntot=npvt(j)
         do i=1,ntot
            inum=ippsv(i,j)
            do k=2,0,-1
               xpp(inum*3-k,j)=xpp(inum*3-k,j) - xtemp(3-k)
            enddo
         enddo
!
         ntot=nratom(j)
         do i=1,ntot
           inum=iatsv(i,j)
           do k=2,0,-1
              xrp(inum*3-k)=xrp(inum*3-k) - xtemp(3-k)
           enddo
        enddo
!
      enddo
!
! calculate center of mass of two reatants in their separated status
!
      do j=1,2
        do i=1,n3tm
        xtemp(i)=xrp(i)
        enddo
        call reactcom(j,tp,xtemp)
        do ix=1,3
          xrcm(ix,j)=tp(ix)
        enddo
      enddo
! 
! calculate the length of vector connecting COM of each fragment and 
! corresponding pivot point
!
      do j=1,2
        dtmp = 0.0d0
        do ix = 2, 0, -1
          dtmp= dtmp + (xrcm(3-ix,j)-xpp(3*ip(j)-ix,j))**2
        enddo
        dpcom(j) = dsqrt(dtmp)
      enddo
!
!  nmona is the number of monoatomic fragment
!  nrfd(i) is the rotational freedom of fragments
!  trot is total orientational freedom 
!
      nmona=0
      ntrot=3
      do j=1,2
        If (icode(j).eq.4) then
          nrfd(j)=3
        else if(icode(j).eq.3.or.icode(j).eq.2) then
          nrfd(j)=2
        else if(icode(j).eq.1) then
          nrfd(j)=0
          nmona=nmona+1
        else
          write(fu6,*)'The type of reactant is not correct'
          stop
        endif
        ntrot=ntrot+nrfd(j)
      enddo
!
! Initialize MC integration array
!
       do itemp=1,ntemp
          dmcint(itemp)=0.0d0
          dmc2(itemp)=0.0d0
       enddo
!
       do j=1,2
         if(icode(j).gt.1) call pmoi(j,0,fpmoi,fpvec,abc)
       enddo
!
       prodi=1.0d0
!
       do j=1,2
!      
!        Atomic species case
!
          if(icode(j).eq.1) then
            cycle 
!
!        Linear species case 
!         
          else if (icode(j).eq.2.or.icode(j).eq.3) then
             prodi=prodi*tpi*fpmoi(j,1)
!
!        Nonlinear species case
!
          else
             do irf=1,3
!             write(fu6,*) 'J, I, MOI',fpmoi(j,irf)
              prodi=prodi*dsqrt(tpi*fpmoi(j,irf))
             enddo
          endif
!       
       enddo
!
! Starting Crude Monte Carlo integration 
! NCM is total number of steps for MC integration 
!
      if(nmc.le.isize) then
        nmcrank=1
      elseif (mod(nmc,isize).eq.0) then
        nmcrank=nmc/isize
      else
        nmcrank=nmc/isize + 1
      endif
      nacp=0
!     imc=0
!     write(fu6,*) 'NMCRANK = ',nmcrank
      do 700 while (nacp.lt.nmcrank)
!
! sample the geometric paramters randomly
! obtain the randomly determined solid angles (theta,phi,psi) for
! the two fragments and for the line of two pivot points
!
        do j=1,2        
        if(icode(j).eq.1) then
          ct(j)=1.0d0
          st(j)=1.0d0
          cycle 
         endif
         ct(j)=2.0d0*(sprng(stream)-0.5d0)
         st(j)=sin(dacos(ct(j)))
         if(nrfd(j).ge.2) then
            tpang=tpi*sprng(stream)
            cph(j)=dcos(tpang)
            sph(j)=dsin(tpang)
         endif
         if(nrfd(j).eq.3) then
            tpang=tpi*sprng(stream)
            cps(j)=dcos(tpang)
            sps(j)=dsin(tpang)
         endif
        enddo
!       write(fu6,*)'cos(theta1) = ',ct(1)
!       write(fu6,*)'cos(theta2) = ',ct(2)
        ct12  = 2.0d0*(sprng(stream)-0.5d0)
        st12  = sin(dacos(ct12))
        cot12 = ct12/st12
        phi12 = tpi*sprng(stream)
        cp12  = cos(phi12)
        sp12  = sin(phi12)
!       write(fu6,*)'sin(theta12) = ',st12
!
! calculate vector s and positions of fragments
!
! 1) First step is to determine pivot point 2 space coordinates
!    Here we put the pivot point 1 at origin
!    Acutually this step determines the vector of reaction coordinate s
!    
        a12inv(1) = st12*cp12
        a12inv(2) = st12*sp12
        a12inv(3) = ct12
        do i=1,3
          svec(i)=a12inv(i)*sabs
          usvec(i)=a12inv(i)
        enddo
!
! 2) determine fragment 1 and 2 space-fixed coordinates
!    and also other pivot points coordinates
!
       do j=1,2
!
        if(icode(j).eq.1) then
         iam=iatsv(1,j)
         inum=ippsv(1,j)
         do k=2, 0, -1
          x(3*iam-k) = svec(3-k)
          xpprot(3*inum-k,j)= svec(3-k)
         enddo
!        if(debug) write(fu6,5000) iam,(x(3*iam-k)/gufac6,k=2,0,-1)
!        if(debug) write(fu6,5020) j,inum,
!    *               (xpprot(3*inum-k,j)/gufac6,k=2,0,-1)
         cycle
        endif
        if(icode(j).eq.2.or.icode(j).eq.3) then
          sps(j)=0.0d0
          cps(j)=1.0d0
        endif
!
        ainv(1,1)= -sps(j)*sph(j)+ct(j)*cph(j)*cps(j)
        ainv(1,2)= -cps(j)*sph(j)-ct(j)*cph(j)*sps(j)
        ainv(1,3)=   st(j)*cph(j)
        ainv(2,1)=  sps(j)*cph(j)+ct(j)*sph(j)*cps(j)
        ainv(2,2)=  cps(j)*cph(j)-ct(j)*sph(j)*sps(j)
        ainv(2,3)=   st(j)*sph(j)
        ainv(3,1)= -cps(j)* st(j)
        ainv(3,2)=  sps(j)* st(j)
        ainv(3,3)=   ct(j)
!
! fragement 1 and 2 coordinates
!
        ntotr = nratom(j)
!
        do i=1,ntotr 
          iam = iatsv(i,j)
          do k1=2, 0, -1
             x(3*iam-k1) = 0.0d0
             do k2=2, 0, -1
               x(3*iam-k1) = x(3*iam-k1) + ainv(3-k1,3-k2)*xrp(3*iam-k2)
             enddo
          enddo
!         
          if (j.eq.2) then
            do k=2, 0, -1
              x(3*iam-k)=x(3*iam-k)+svec(3-k)
            enddo
          endif
!            if(debug) write(fu6,5000) iam,(x(3*iam-k)/gufac6,k=2,0,-1)
!5000         format(5X,I2,5X,3f12.6)
 
         enddo
!
! the other pivot point coordinates
!
         ntotp = npvt(j)
!         
         do i=1,ntotp
           inum= ippsv(i,j)
           do k1=2, 0, -1
             xpprot(3*inum-k1,j) = 0.0d0
             do k2=2, 0, -1
              xpprot(3*inum-k1,j)=xpprot(3*inum-k1,j) + ainv(3-k1,3-k2)*
     *                           xpp(3*inum-k2,j)
             enddo
           enddo
!
           if(j.eq.2) then
             do k=2, 0, -1
               xpprot(3*inum-k,j) = xpprot(3*inum-k,j) + svec(3-k)
             enddo
           endif
!          if(debug) write(fu6,5020) j,inum,
!    *               (xpprot(3*inum-k,j)/gufac6,k=2,0,-1)
!5020       format(3X,2I2,5X,3f12.6)

         enddo
        enddo
!
! check the distances between all pivot point pairs
!
        do i1=1,npvt(1)
          do i2=1,npvt(2)
            dpp = 0.0d0
            if(i1.ne.ip(1).or.i2.ne.ip(2)) then
              do k = 2, 0, -1
                dpp=dpp+(xpprot(3*i1-k,1)-xpprot(3*i2-k,2))**2 
              enddo
              dpp=dsqrt(dpp)
!             spp=svrc(i1,i2)
              spp=sabs
              if(dpp.le.spp) goto 700
            endif
          enddo
        enddo
!
! output the geometry for debugging purpose
!
        nacp=nacp+1
        if(debug) then
          write(fu6,5001) nacp
          write(fu6,5010) (svec(k)/gufac6,k=1,3)
          do j=1,2
            do i1=1,nratom(j)
              iam=iatsv(i1,j)
              write(fu6,5000) iam,(x(3*iam-k)/gufac6,k=2,0,-1)
            enddo
            do i2=1,npvt(j)
              inum=ippsv(i2,j)
              write(fu6,5020) j,inum, 
     *                       (xpprot(3*inum-k,j)/gufac6,k=2,0,-1)
            enddo
          enddo
        endif
!
5010    format(5X,'P2',5X,3f12.6)
5000    format(5X,I2,5X,3f12.6)
5001    format(/,'No.',I4,' Monte Carlo point',/)
5020    format(3X,2I2,5X,3f12.6)
!
! check the repulsivity of H atoms on the separated fragments
!
!       call hrepul (vrep)
!       if(debug) write(fu6,*) ' H atoms repulsivity: ', vrep
!
! 3. Potential Energy
!
! If there is very close contact between two fragments, set v=1.0 hartree
!       call repul(lclose)
!       if(lclose) then
!         v=1.0
!         goto 292
!       endif
        call ehook(0,0)
!       if(vfac.ne.1.0d0.and.vfac.ne.0.0d0) v=v*vfac
!       write(fu6,*) ' Potential Energy: ', V
!
! statistic energy distribution
!
        do ne = 2, 9
          eh = -dble(ne-2)/ckcal
          el = -dble(ne-1)/ckcal
          if (v.le.eh.and.v.gt.el) then
             nessub(ne) = nessub(ne) + 1
          endif
        enddo 
        if (v.gt.0.0) nessub(1) = nessub(1) +1
        if (v.lt.-8.d0/ckcal) nessub(10) = nessub(10) + 1
!
! 4. determine the vector d1 or d2 connecting each fragment center of mass
!    and corresponding pivot point
!
        do j=1,2
          call reactcom(j,tp,x)
          do ix=1,3
            xrcm(ix,j)=tp(ix)
          enddo
        enddo
!
        do j=1,2
          do k=1,3
            if(j.eq.1) then
              dd(j,k)= 0.0d0 - xrcm(k,j)    
            else
              dd(j,k)= svec(k) - xrcm(k,j)
            endif
          enddo
         enddo
!
! 5. calculate each fragment moments of inertia and the unit vectors along 
!    principal axis
         do j=1,2
           if(icode(j).gt.1) call pmoi(j,0,fpmoi,fpvec,abc)
         enddo
!
! DEBUG
!
!        if(debug) then
!          do iam=1, natom
!            write(fu6,5000) iam,(x(3*iam-k)/gufac6,k=2,0,-1)
!          enddo
!        endif
!
! 6. calculate Kinematic factor PHI
!
         phik=0.0d0
         do j=1,2
           tt=0.0d0
!
!  Atomic species case
!
           if(icode(j).eq.1) then
             cycle 
!
!  Linear species case
!
           else if (icode(j).eq.2.or.icode(j).eq.3) then
             do i=1,3
               tt=usvec(i)*fpvec(j,3,i)+tt
             enddo
             phik=phik+redmf*(dpcom(j)**2)*(1.0d0-tt**2)/fpmoi(j,1)
!
!  Nonlinear species case
!
           else
             tp(1)=usvec(2)*dd(j,3)-usvec(3)*dd(j,2)
             tp(2)=usvec(3)*dd(j,1)-usvec(1)*dd(j,3)
             tp(3)=usvec(1)*dd(j,2)-usvec(2)*dd(j,1)
             do irf=1,3
               do k=1,3
                 tt=tt+tp(k)*fpvec(j,irf,k)
               enddo
               phik=phik+redmf*(tt**2)/fpmoi(j,irf)
             enddo
           endif
          enddo
          phik=dsqrt(1.0d0+phik)
          if(debug) write(fu6,5100) phik
5100      format(2X,'Kinematic factor PHI',2X,f6.3)
!
! 7) Loop over temperatures 
!
         do itemp=1, ntemp
           bkt=bk*temp(itemp)
           tt=phik*exp(-1.0d0*v/bkt)
           dmcint(itemp)=dmcint(itemp)+tt
           dmc2(itemp)=dmc2(itemp)+tt**2
           if(debug) write(fu6,*) ' PHI*Exp(-V/kT) ',tt
         enddo
!
!*****************************************************
!          
! calculate N(E,J,Q) (J. Zheng March 31 2008)
!      
!*****************************************************
!      
         call pmoi(5,0,fpmoi,fpvec,abc)
         piq=1.0d0
         do irf=1,3
           piq=piq*dsqrt(tpi*fpmoi(5,irf))
         enddo
!        
! loop over angular momentum J ,total energy E, and temperature
!        
         do itemp=1,ntemp
           do ie=1,nemvt
             te=etot(itemp,ie)-v
             if(te.gt.0.0d0) then
               tmp=phik*te**(dble(ntrot)/2.0d0-0.5d0)
               dnee(itemp,ie)=dnee(itemp,ie)+tmp
               dnee2(itemp,ie)=dnee2(itemp,ie)+tmp**2
             endif
             do ij=0, jmax
               j=ij*jstep
               rj=dble(j)
!
!              if (j.eq.0) rj=0.5d0
!              call averjn(te,rj,abc,ntrot-3,dnejq,v)
!              d1 = dnejq
               call averj(te,rj,abc,ntrot-3,dnejq)
!              d2 = dnejq
!              if (d1.gt.0.0) then
!                write(fu6,'(f8.2,2X,E12.4,2X,E12.4)') (d2-d1)/d1*100.0,d1,d2
!              endif
!
!              if(j.eq.0) write(fu6,*) 'J = ',J,'  N(E,J,Q) = ',dnejq
!              if (j.eq.0) then
              dnejq=dnejq*phik*redmf*(2.0d0*rj+1.0d0)**2*(sabs**2)*2.0d0
     *       *(pi**(nmona-1))*prodi/dgamma(dble(ntrot)/2.0d0-1.0d0)/piq
!              else
!                dnejq=dnejq*phik*redmf*dble(j)**2*(sabs**2)*8.0d0*
!    *           (pi**(nmona-1))*prodi/dgamma(dble(ntrot)/2.0d0-1.0d0)/piq
!              endif
!       write(fu6,*) 'J = ',J,'  N(E,J,Q) = ',dnejq
               dnej(itemp,ie,ij)=dnej(itemp,ie,ij)+dnejq
               dnej2(itemp,ie,ij)=dnej2(itemp,ie,ij)+dnejq**2
!              dne(ie)=dne(ie)+dnejq
             enddo
           enddo
      enddo

700   continue ! end of do
701   continue
!
! out of Monte Carlo Sampling
!cccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
!
! loop over temperature 
!
      do itemp=1, ntemp
!       sig1(itemp)=dmcint(itemp)
!       sig2(itemp)=dmc2(itemp)
!
! percentage error of Monte Carlo
!
!       if(debug) write(fu6,5200) temp(itemp),dmcint(itemp),sig2(itemp)
5200    format(2X,'Monte Carlo Integration <PHI*exp(-v/bkt)>: ',f8.2,
     *         E15.6,f8.2,'%')
!
        do i=1,nemvt
          tmp = 2.0d0*redmf*(sabs**2)*(pi**(nmona-2))*prodi/
     *         dgamma(dble(ntrot)/2.0d0+0.5d0)
          dnee(itemp,i)=dnee(itemp,i)*tmp
          dnee2(itemp,i)=dnee2(itemp,i)*tmp**2
        enddo
!
! sum over J to calculate N(E). This is only used for checking purpose
!
        do i=1,nemvt
          do j=0,jmax
            if(j.eq.0.or.j.eq.jmax) then 
              dne(itemp,i)=dne(itemp,i)+dnej(itemp,i,j)
            elseif(mod(j,2).eq.0.and.j.ne.jmax) then
              dne(itemp,i)=dne(itemp,i)+2.0d0*dnej(itemp,i,j)
            else
              dne(itemp,i)=dne(itemp,i)+4.0d0*dnej(itemp,i,j)
            endif
          enddo
          dne(itemp,i)=dne(itemp,i)*jstep/3.0d0
        enddo
!
        bkt=bk*temp(itemp)
        qt(itemp)=2.0d0*redmf*(pi**(nmona-2))*(sabs**2)*
     *             (bkt**((dble(ntrot)+1.0d0)/2.0d0))
     *             *prodi*dmcint(itemp)
        qt2(itemp)=(qt(itemp)/dmcint(itemp))**2*dmc2(itemp)
!
!       if(debug) write(fu6,*) 'Qtransitional ',qt(itemp)
      enddo
!
      return
      end subroutine vrcnej
!*********************************************************************
!
! REACTCOM
!
!********************************************************************
!
! subroutine to calculate center of mass for reactants
!
      subroutine reactcom(jtype,xcm,xdum)
      use perconparam
      use common_inc
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
!     include 'param.inc'
!     include 'percon.inc'
!     include 'common.inc'
      dimension xcm(3),xdum(n3tm)
!
! jtype must be less than 5
!
      do i=1,3
       xcm(i) = 0.0d0
      enddo
!
      ntot = nratom(jtype)      
      totm = 0.0d0
      do i = 1, ntot
        inum = iatsv(i,jtype)
!       totm = totm + svmas(label(inum))
        totm = totm + amass(3*iatom(i))**2
      enddo
!
!      do 50 i =1,ntot
!         inum = iatsv(i,jtype)
!         do 60 k=2, 0, -1
!           xcm(3-k)= xcm(3-k) + xdum(inum*3-k)*svmas(label(inum))
!60       continue
!50    continue
! 
!      do 80 i = 1, 3
!        xcm(i) = xcm(i)/totm
!80    continue
!
      DO K = 1, 3
        SUM = 0.D00
        DO I = 1, ntot 
          INUM = IATSV(I,jtype)
          SUM = SUM+XDUM(3*(INUM-1)+K)*AMASS(3*(IATOM(I)-1)+K)**2
        ENDDO
        XCM(K) = SUM/TOTM
      ENDDO 

      return
      end subroutine reactcom
!***********************************************************************
!  PMOI
!***********************************************************************
!
      SUBROUTINE pmoi (IOP,IMPR,FPMOI,FPVEC,ABC)
      use perconparam
      use common_inc
!     
!     This subroutine is modified based on CENTER to calculate principal
!     moment of inertia IA, IB, and IC and  their unit vector along the 
!     ith principal axis. It is used for VRC-TST calculations.
!     01/25/07 by JZ
!
!     TRANSLATES CENTER OF MASS OF SYSTEM TO SADDLE POINT OR TO
!     C. O. M. OF A REACTANT OR PRODUCT SPECIES
!     IOP=1 OR 2 FOR REACTANTS, IOP=3 OR 4 FOR PRODUCTS
!     IOP=5 FOR A SYSTEM AS A WHOLE
!     ALSO CALCULATES MOMEMT OF INERTIA OR PRODUCT OF ALL 3
!     FOR S. P. OR REACTANT OR PRODUCT
!
!     CALLED BY:
!            VRCNEJ
!     CALLS:
!            RSPDRV
!
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
!
!     include 'param.inc'
!     include 'percon.inc'
!     include 'common.inc'
!
      LOGICAL LDEBUG                                                    1106YL92
!*
      DIMENSION XCM(3),TENS(3,3,3),ISCR(3),SCR1(3),SCR2(3)              1106YL92
      DIMENSION FPMOI(5,3),FPVEC(5,3,3),ABC(5,3),ROT(3,3)
!
      DATA TENS / 5*0.0D0,-1.0D0,0.0D0,1.0D0,3*0.0D0,1.0D0,3*0.0D0,
     *            -1.0D0,3*0.0D0,-1.0D0,0.0D0,1.0D0,5*0.0D0 /
!
!
      LDEBUG = .FALSE.                                                  1106YL92
!     LPTBCR = LGS2(15)
      IF (LDEBUG) THEN
      IF(IOP.EQ.1.OR.IOP.EQ.2) THEN
      WRITE(FU6,1400) IOP
      ELSE IF (IOP.EQ.5) THEN
      WRITE(FU6,1410) 
      ENDIF
      ENDIF

      IBEG = 1
      IEND = NATOM
      IF (IOP.LT.5) IEND = NRATOM(IOP)
      TOTM = 0.D00
      DO I = IBEG, IEND
         INUM = IATSV(I,IOP)
         TOTM = TOTM+AMASS(3*IATOM(I))**2
      ENDDO
      DO K = 1, 3
         SUM = 0.D00
         DO I = IBEG, IEND
            INUM = IATSV(I,IOP)
            SUM = SUM+X(3*(INUM-1)+K)*AMASS(3*(IATOM(I)-1)+K)**2
         ENDDO 
         XCM(K) = SUM/TOTM
!
!         MOVE C. O. M. OF FULL SYSTEM TO C. O. M. OF SPECIES IOP
!
         DO I = K, N3, 3
            X(I) = X(I)-XCM(K)
         ENDDO
      ENDDO
      IF (IMPR.EQ.1) WRITE (FU6,1000) (XCM(K),K=1,3)                    1125JC97
!
!     COMPUTE  MOMENT OF INERTIA IN A.U.
!
      IF (ICODE(IOP).LE.3) THEN
!
!         LINEAR MOLECULE
!         ALIGN MOLECULE WITH X-AXIS FOR MORATE
!         BUT ALONG Z-AXIS FOR POLYRATE TESTRUNS
!         IOLIN =1,2,3 MEANS X,Y,Z AXIS.
!
         SUM = 0.0D0
         JV = 1
         T = ABS(X(1))+ABS(X(2))+ABS(X(3))
         IF (T.LT.1.0D-08) JV = 4
         XX1 = X(JV)
         X2 = X(JV+1)
         X3 = X(JV+2)
         DO I = IBEG, IEND
            L = 3*IATSV(I,IOP)-2
            TX = (X(L)**2+X(L+1)**2+X(L+2)**2)
            SUM = SUM+TX*AMASS(L)**2
         ENDDO
         DO I = 1, 3
            DO J = 1, 3
              FPVEC(IOP,I,J)=0.0D0
            ENDDO
         ENDDO
         I1= 3*IATSV(1,IOP)-2
         I2= 3*IATSV(2,IOP)-2
         TT=DSQRT((X(I1)-X(I2))**2+(X(I1+1)-X(I2+1))**2+
     *            (X(I1+2)-X(I2+2))**2)
         FPVEC(IOP,3,1)=DABS(X(I1)-X(I2))/TT
         FPVEC(IOP,3,2)=DABS(X(I1+1)-X(I2+1))/TT
         FPVEC(IOP,3,3)=DABS(X(I1+2)-X(I2+2))/TT          
!        XMOM = SUM
!        FMOM(IOP) = REDM*SUM
         FPMOI(IOP,1)= SUM*REDM
         FPMOI(IOP,2)=FPMOI(IOP,1)
         FPMOI(IOP,3)=0.0d0
!
! Calculate rotational constants A,B,C; linear molecule has no A, and B=C
! We simply set A = 0.0
         ABC(IOP,1) = 0.0D0
         ABC(IOP,2) = 0.5D0/FPMOI(IOP,2)
         ABC(IOP,3) = ABC(IOP,2)
!
         IF (LDEBUG) WRITE (FU6,1300) (FPMOI(IOP,I), I=1,3)             0125JZ07
         IF (LDEBUG) WRITE (FU6,1310) (ABC(IOP,I)*AUTOCM, I=1,3)
         IF (LDEBUG) WRITE(FU6,219) ((FPVEC(IOP,I,J),I=1,3),J=1,3)
!
      ELSE
!
!         NON-LINEAR MOLECULE -- FIND PRINCIPAL MOMENT OF INERTIA TENSOR
!         IA, IB, and IC AS WELL AS UNIT VECTOR ALONG WITH PRINCIPAL AXIS
!
         DO I = 1, 3
            DO J = 1, 3
               ROT(I,J) = 0.0D0
            ENDDO
         ENDDO
         DO I = IBEG, IEND
            L = 3*IATSV(I,IOP)-2
            ROT(1,1) = ROT(1,1)+(X(L+1)**2+
     *                 X(L+2)**2)*AMASS(L)**2
            ROT(1,2) = ROT(1,2)-X(L)*X(L+1)*AMASS(L)**2
            ROT(1,3) = ROT(1,3)-X(L)*X(L+2)*AMASS(L)**2
            ROT(2,2) = ROT(2,2)+(X(L)**2+
     *                 X(L+2)**2)*AMASS(L)**2
            ROT(2,3) = ROT(2,3)-X(L+1)*X(L+2)*AMASS(L)**2
            ROT(3,3) = ROT(3,3)+(X(L)**2+
     *                 X(L+1)**2)*AMASS(L)**2
         ENDDO
         ROT(2,1) = ROT(1,2)
         ROT(3,1) = ROT(1,3)
         ROT(3,2) = ROT(2,3)

            DO I = 1, 3                                                 1106YL92
               BEROT(I) = 0.D0                                          1106YL92
               DO J = 1, 3                                              1106YL92
                  PVEC(I,J) = 0.D0                                      1106YL92
               ENDDO
            ENDDO
            CALL RSPDRV(3,3,ROT,BEROT,1,PVEC,SCR1,SCR2,IERR)            1106YL92
            FMOM(IOP) = BEROT(1)*BEROT(2)*BEROT(3)*REDM**3              0601YC98

            DO I = 1, 3                                                 0125JZ07
              FPMOI(IOP,I)=BEROT(I)*REDM                                0125JZ07
              ABC(IOP,I)=0.5D0/FPMOI(IOP,I)
              DO J = 1, 3                                               0125JZ07
                FPVEC(IOP,I,J) = PVEC(I,J)                               0125JZ07
              ENDDO
            ENDDO

      IF (LDEBUG) WRITE (FU6,1300) (FPMOI(IOP,I), I=1,3)                0125JZ07
      IF (LDEBUG) WRITE (FU6,1310) (ABC(IOP,I)*AUTOCM, I=1,3)
      IF (LDEBUG) WRITE(FU6,219) ((FPVEC(IOP,I,J),I=1,3),J=1,3)    
       
      ENDIF
!     IF (ICODE(IOP).LE.3.AND.IMPR.EQ.1) WRITE (FU6,1100) FMOM(IOP)     1125JC97
!     IF (ICODE(IOP).GT.3.AND.IMPR.EQ.1) WRITE (FU6,1200) FMOM(IOP)     1125JC97
!
!       MOVE C. O. M. AND UNIT VECTOR ALONG WITH PRINCIPAL AXIS BACK
!
      DO K = 1, 3
        DO I = K, N3, 3
          X(I) = X(I) + XCM(K)
        ENDDO
        IF(ICODE(IOP).GT.3) THEN
        DO J = 1, 3
          FPVEC(IOP,J,K) = FPVEC(IOP,J,K) + XCM(K)
        ENDDO
        ENDIF
      ENDDO
      RETURN
!
  219 FORMAT(' corresponding eigenvectors:', 3(/,5X,3F15.10))           1106YL92
 1000 FORMAT(/1X,'New center of mass is at ',3(E15.6),                  0610WH94
     1       /1X,'bohrs with respect to previous origin.')
 1100 FORMAT(1X,'Moment of inertia (a.u.) = ',E14.6)
 1200 FORMAT(1X,'Products of three principal moments of inertia ',      1110DL89
     1'(a.u.) = ',E14.6)                                                0610WH94
 1300 FORMAT(1X,'Principal moment of inertia (a.u.) =',3E14.6)          0119JZ07
 1310 FORMAT(1X,'Rotational constants (in wavenumber)',3E14.6)
 1400 FORMAT(/1X,'For REACTANT ',I1)
 1410 FORMAT(/1X,'For GENERILIZED TS STATE')
!
      END SUBROUTINE pmoi
!********************************************************************
! CROSSPROD
!********************************************************************
!
      subroutine crossprod(A,B,C)
!  This subroutine is to calculate two vectors cross product
!  A x B = C
      implicit none
      double precision, intent(in) :: A(3), B(3)
      double precision, intent(out) :: C(3)

      C(1) = A(2)*B(3) - A(3)*B(2)
      C(2) = A(3)*B(1) - A(1)*B(3)
      C(3) = A(1)*B(2) - A(2)*B(1)
!
      return
      END subroutine crossprod
!******************************************************************
! SAVEXRP
!******************************************************************
!
      subroutine savexrp
      use perconparam
      use common_inc
      use cm
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
!
!     include 'param.inc'
!     include 'percon.inc'
!     include 'common.inc'
!
! calculate coordinates of each fragment and the other pivot points 
! relative to the 1st pivot point of reactant 1
!     
      do j=1,2
!
         ntot=npvt(j)
         do i=1,ntot
            inum=ippsv(i,j)
            do k=2,0,-1
               xpp(inum*3-k,j)=xpvt(inum*3-k,j) - xpvt(3-k,j)
            enddo
         enddo
!
         ntot=nratom(j)
         do i=1,ntot
            inum=iatsv(i,j)
            do k=2,0,-1
               xrp(inum*3-k)=xr(inum*3-k,1) - xpvt(3-k,j)
            enddo
         enddo
!
      enddo
!
      return
      end subroutine savexrp
!******************************************************************
!
! AVERJ
!
!******************************************************************
!
      subroutine averj(te,rj,abc,nv,dnejq)
!
! This subrotine is to calculate the averaging over all possible 
! orientations of the vector J while its length is fixed -- <...>_omega_J
! in Eq. 2.39 in JCP V118, 5442, 2003.
!
!    called by
!              vrcnej
!    call
!              betai
!        
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
!
      PARAMETER (PI = 3.141592654D0, TPI = 6.283185307D0)
      dimension abc(5,3)
!
! Here we use composite Simpson's rule to do numerical integral
! nint must be even
!
      np=50
      dzai=tpi/dble(np)
      dnejq=0.0d0
      s=dble(nv)
      a=abc(5,1)
      b=abc(5,2)
      c=abc(5,3)
!
!     rj = dble(j)
!     if (j.eq.0) rj=0.5
!
!    CASE 1: C*(J+0.5)**2<= E-V <= A*(J+0.5)**2
!
      if (te.le.a*rj*(rj+1.0).and.te.ge.c*rj*(rj+1.0)) then      
!     if (te.le.a*(rj+0.5d0)**2.and.te.ge.c*(rj+0.5d0)**2) then      
!     if (te.le.a*rj*rj.and.te.ge.c*rj*rj) then
!   
        do i=0,np
          zai=dble(i)*dzai
          bs=b*(dsin(zai))**2.d0+c*(dcos(zai))**2.d0
          e1=te-bs*rj*(rj+1.0d0)
!         e1=te-bs*(rj+0.5d0)**2
!         e1=te-bs*rj*rj
          if (e1.lt.0.) cycle 
          amb=dsqrt(a-bs)
          term = (e1**(s/2.d0))/amb
          if(i.eq.0.or.i.eq.np) then
            dnejq=dnejq + term
          elseif(i.ne.0.and.i.ne.np.and.mod(i,2).eq.0) then
            dnejq=dnejq + 2.0d0*term
          else
            dnejq=dnejq + 4.0d0*term
          endif
        enddo
        dnejq=dnejq*dgamma(0.5d0)*dgamma(s/2.d0+0.5d0)/dgamma(s/2.d0
     *        +1.d0)*(rj+0.5d0)
!       dnejq=dnejq*dgamma(0.5d0)*dgamma(s/2.d0+0.5d0)/dgamma(s/2.d0
!    *        +1.d0)*rj
!
!    CASE 2: A*J*(J+1) <= E-V s is even
!
      elseif(te.ge.a*rj*(rj+1.d0).and.mod(nv,2).eq.0) then
!     elseif(te.ge.a*(rj+0.5d0)**2.and.mod(nv,2).eq.0) then
!     elseif(te.gt.a*rj*rj.and.mod(nv,2).eq.0) then
        term=0.5d0**(s/2.d0-1.d0)
        do iv = 1, nv/2
           term=term*(1.0d0+dble(iv-1)*2.0d0)
        enddo
        term=term/dgamma(s/2.0d0+1.d0)
        e2=te-a*rj*(rj+1.d0)
!       e2=te-a*(rj+0.5d0)**2
!       e2=te-a*rj*rj
        do i=0,np
          zai=dble(i)*dzai
          bs=b*(dsin(zai))**2.d0+c*(dcos(zai))**2.d0
          e1=te-bs*rj*(rj+1.d0)
!         e1=te-bs*(rj+0.5d0)**2
!         e1=te-bs*rj*rj
          amb=dsqrt(a-bs)
!
          term1=tt1(nv/2-1,e1,e2,0)*(2.0d0*rj+1.0d0)
!         term1=tt1(nv/2-1,e1,e2,0)*2.0d0*rj
          term2=term*(e1**(s/2.0d0))/amb
          tmp = (2.d0*rj+1.d0)*amb/2.0d0/dsqrt(e1)
!         if(tmp-1.d0.gt.0.d0.and.tmp-1.d0.le.1.d-3) then
            term2=term2*dasin(min(1.d0,tmp))
!         else
!           goto 30
!         endif
          if(i.eq.0.or.i.eq.np) then
            dnejq=dnejq + term1 + term2
          elseif(i.ne.0.and.i.ne.np.and.mod(i,2).eq.0) then
            dnejq=dnejq + 2.0d0*(term1+term2)
          else
            dnejq=dnejq + 4.0d0*(term1+term2)
          endif
        enddo
        dnejq=dnejq*(rj+0.5d0)
!       dnejq=dnejq*rj
!
!    CASE 3: A*J*(J+1) <= E-V s is odd
!
      elseif(te.ge.a*rj*(rj+1.d0).and.mod(nv,2).eq.1) then
!     elseif(te.ge.a*(rj+0.5d0)**2.and.mod(nv,2).eq.1) then
          e1=te-bs*rj*(rj+1.0d0)
          e2=te-a*rj*(rj+1.0d0)
!         e1=te-bs*(rj+0.5d0)**2
!         e2=te-a*(rj+0.5d0)**2
          do i = 0, np 
          zai=dble(i)*dzai
          bs=b*(dsin(zai))**2+c*(dcos(zai))**2
          amb=dsqrt(a-bs)
  
!           tmp = (rj+0.5)*amb/dsqrt(e1)
!           if (abs(tmp).gt.1.0) goto 40
  
          if(i.eq.0.or.i.eq.np) then
            dnejq = dnejq + tt1((nv-1)/2,e1,e2,1)
          elseif(i.ne.0.and.i.ne.np.and.mod(i,2).eq.0) then
            dnejq = dnejq + 2.d0*tt1((nv-1)/2,e1,e2,1)
          elseif(mod(i,2).eq.1) then
            dnejq = dnejq + 4.d0*tt1((nv-1)/2,e1,e2,1)
          endif
          enddo
        dnejq=dnejq*(rj+0.5d0)*(2.d0*rj+1.d0)
      endif
!
      dnejq=dnejq*dzai/3.0d0/(pi*(2.0*rj+1.0)**2)
!     dnejq=dnejq*dzai/3.0d0/(pi*4.0*rj*rj)
!
      return
      end subroutine averj
!
      FUNCTION tt1(nn,e1,e2,id)
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
       if(id.eq.0) then
         ns = (nn+1)*2
       else
         ns = 2*nn+1
       endif
       tt1 = 0.0d0
      do iv = 0, nn
         ll1 = 1
         do j = 1, iv
            ll1 = ll1*(ns-1+(j-1)*(-2))
         enddo
         ll2 = 1
         do j = 1, iv+1
!           if (ns+(j-1)*(-2).eq.0) then
!             stop 'll = 0'
!           endif
            ll2 = ll2*(ns+(j-1)*(-2))
         enddo
         r = dble(ll1)/dble(ll2)
         p = dble(ns)/2.d0-0.5d0-dble(iv)
         tt1 = tt1 + r*(e1**iv)*(e2**p)
      enddo
      return
      end FUNCTION tt1
!
!******************************************************************
!
! INITVRC
!
!*****************************************************************
!
      subroutine initvrc
      use perconparam
      use common_inc
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
!     include 'param.inc'
!     include 'percon.inc'
!     include 'common.inc'
!
! In VRC-TST calculation, START section is not give in the fu5 file
! therefore, the array iatsv need to be initialized.
!
      i=1
      do j=1,2
       do n=1,nratom(j)
         iatsv(i,5)=iatsv(n,j)
         i=i+1
       enddo
      enddo
      return
      end subroutine initvrc

      subroutine averjn(te,rj,abc,nv,dnejq,vq)
      use perconparam
      use common_inc
!
! This subrotine is to calculate the averaging over all possible 
! orientations of the vector J while its length is fixed -- <...>_omega_J
! in Eq. 2.39 in JCP V118, 5442, 2003.
! Numerically evaluate two dimensional integral using Monte Carlo method
!    called by
!              vrcnej
!    call
!              betai
!        
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
!
!     include 'param.inc'
!     include 'percon.inc'
!     include 'common.inc'
!#define SIMPLE_SPRNG
!#define USE_MPI 1
!#include "sprng_f.h"
!     SPRNG_POINTER st
!
      dimension abc(5,3)
!
! Here we use composite Simpson's rule to do numerical integral
! nint must be even
!
!     iseed=9987345
      iseed=-10
!     st = init_sprng(4,iseed,SPRNG_DEFAULT)
      nmctemp=4000
!     dzai=tpi/dble(nint)
!     dk=dble(j)/dble(nint)
      dnejq=0.0d0
      vv=(dble(nv)-1.0d0)/2.0d0
!
!
! replace j by j+0.5
!
!     rj=dble(j)
!     if(j.eq.0) rj = 0.5d0
!
      a=abc(5,1)
      do i=1, nmctemp
        zai=tpi*sprng(st)
        k=rj*(1.0d0-2.0d0*sprng(st))
        bs=abc(5,2)*dsin(zai)**2+abc(5,3)*dcos(zai)**2
        term=te-bs*rj*(rj+1)-(a-bs)*k*k
!       term=te-bs*rj*rj-(a-bs)*k*k
!       term=te-bs*(rj+0.5d0)**2-(a-bs)*k*k
        if(term.lt.0) cycle
        dnejq=dnejq+term**vv
      enddo
!     dnejq=dnejq/dble(nmctemp)
      dnejq=dnejq/dble(nmctemp)

      return
      end subroutine averjn
!
      subroutine checks
      use perconparam
      use common_inc
      use cm
!    This subroutine is to make sure s is larger than the sum of two 
!    reactive atom van der Walls radii plus the corresponding 
!    pivot point to the atom distance
!  
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
!     include 'param.inc'
!     include 'percon.inc'
!     include 'common.inc'
      dimension drm(2)
      do jtype =1, 2
        drm(jtype) = 0.0d0
        ntot = npvt(jtype)
! 
        do i = 1, ntot
          inum=ippsv(i,jtype)
          d = 0.0d0
          do k = 2 ,0, -1
            d=d+(xpp(inum*3-k,jtype)-xrp(ip2r(inum,jtype)*3-k))**2
          enddo
          d = dsqrt(d) + xvdw(ip2r(inum,jtype))
!         d = dsqrt(d) 
          if(d.gt.drm(jtype)) drm(jtype) = d
        enddo
      enddo
!     dd = drm(1) + drm(2)
      dd = max(drm(1),drm(2))
      if (svl.lt.dd) then
         svl = dd
         write(fu6,'(a24,f5.2)') '  The smallerst s is changed to ', svl
      endif
      return
      end subroutine checks
