! Subroutine that deletes old outputfiles
        subroutine delete_old_units
        implicit none
        logical :: exist
        inquire(file='poly.fu6',exist=exist)
        if(exist)call delete_file('poly.fu6')
        inquire(file='poly.fu14',exist=exist)
        if(exist)call delete_file('poly.fu14')
        inquire(file='poly.fu15',exist=exist)
        if(exist)call delete_file('poly.fu15')
        inquire(file='poly.fu22',exist=exist)
        if(exist)call delete_file('poly.fu22')
        inquire(file='esp.fu61',exist=exist)
        if(exist)call delete_file('esp.fu61')
        end subroutine delete_old_units

! Delete a file 
        subroutine delete_file(fname)
        implicit none
        character(*) fname
        open(unit=111,file=trim(fname),status='old')
        close(111,status='delete')
        end subroutine delete_file

! Connected to interface get_file
        subroutine opened_file2table(num_unit,ndim,table)
        implicit none
        character(80), pointer :: table(:)
        character(80) :: a
        integer, intent(in) :: num_unit 
        integer, intent(out) :: ndim
        integer :: n, io, i
        rewind (num_unit)
        n=0
        do
          read(num_unit,'(a80)',iostat=io)a
          n=n+1
          if(io/=0)exit
        end do
        if(associated(table))nullify(table)
        allocate(table(n)); table(:)(:)=' '
        rewind(num_unit)
        ndim=n
        do i=1,ndim
          read(num_unit,'(a80)',iostat=io)a
          table(i)=a
        end do
        end subroutine opened_file2table

        subroutine closed_file2table(filename,ndim,table)
        implicit none
        character(80), pointer :: table(:)
        character(80) :: a
        character(*), intent(in) :: filename
        integer, intent(out) :: ndim
        integer :: num_unit, i, io, n
        num_unit=151
        open(unit=num_unit,file=filename,status='old')
        rewind (num_unit)
        n=0
        do
          read(num_unit,'(a80)',iostat=io)a
          if(io/=0)exit
          n=n+1
        end do
        if(associated(table))nullify(table)
        allocate(table(n)); table(:)(:)=' '
        rewind(num_unit)
        ndim=n
        do i=1,ndim
          read(num_unit,'(a80)',iostat=io)a
          table(i)=a
        end do
        close(unit=num_unit,status='keep')
        end subroutine closed_file2table

       subroutine low2up(string)
       use upplow
       implicit none
       character(*), intent(inout) :: string
       integer :: ll, i, j
       ll=len(string)
       do i=1,ll
        do j=1,26
         if(ichar(string(i:i)).eq.ichar(lower(j)))then
           string(i:i)=upper(j)
           exit   
         end if
        end do
       end do
       end subroutine low2up
