C***********************************************************************
C     ICFDIAG
C***********************************************************************
c 
      SUBROUTINE icfdiag (IOP,ISSAD)
      use common_inc
      use rate_const; use cm
      use perconparam; use intbsv
c
c     ICFDIAG is the main driver for the internal coordinate generalized
c     normal mode analysis as described by "Reaction-Path Potential 
C     and Vibrational Frequencies in Terms of Curvilinear Internal 
C     Coordinates," C. F. Jackels, Z. Gu, and D. G. Truhlar, Journal of 
C     Chemical Physics 102, 3188-3201 (1995).  and "Reaction-Path Dynamics 
C     in Curvilinear Internal Coordinates Including Torsions," K. A. Nguyen, 
C     C. F. Jackels, and D. G. Truhlar, Journal of Chemical Physics 104, 
C     6491-6496 (1996).
c
C     CALLED BY:
C              NORMOD,IRFGT0,RPHRD2
C
C     CALLS:
C          PROJCT,PRSQ,TRANS,TRANSF,CENTR1,CENTRAL,FORMBT,MATX,VECMAG,
C          BMAT1,BTEN1,BMAT5,BTEN5,BMAT2,BTEN2,ANGLCS,FORMA,FORMF,
C          DORPRD,PROJF,FORMG,GFDIAG,VECCON,ICSAVE,BTENTR
C
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
C
C    SET UP STORAGE THAT IS LOCAL TO THE INTERNAL COORD ROUTINES
C         
C
      DIMENSION BTEN(N3TM*N3TM*N3TM),BTEND(N3TM*N3TM*N3TM)
     *,USCR(N3TM,N3TM,N3TM) 
     *, BMAT(N3TM*N3TM), BT(N3TM*N3TM), SCR(N3TM*N3TM)
     *, FX(N3TM*N3TM), BMATD(N3TM*N3TM), AMAT(N3TM*N3TM)
     *, GMAT(N3TM*N3TM), FXINT(N3TM*N3TM), AVEC(N3TM*N3TM)
     *, AMASIN(N3TM*N3TM),sumx(1)
     *, XX(N3TM), DXX(N3TM), XXDIFF(3,N3TM), RDIFF(N3TM)
     *, DXINT(N3TM), FREQIC(N3TM), DXT(N3TM),iscr(n3tm*n3tm)
C
C      EQUIVALENCE LOCAL STORAGE TO SCRATCH COMMON REGION
C
      LOGICAL ICPR
      LOGICAL  ISSAD                                                    0317YC99
C
      DATA ONE/1.0D00/,ZERO/0.0D00/
c
      INTPRJ = 1
      IF(LGS2(39).LE.2.AND.NATOM.GT.3) THEN
         WRITE(FU6,*) ' Option int1 is only available for triatomics!'
         STOP
      ENDIF
      IF(LGS2(39).GE.3) GOTO 9999
C
      IF (S.GE.SDEBG1.AND.S.LE.SDEBG2) THEN
	 ICPR = .TRUE.
      ELSE
	 ICPR = .FALSE.
      ENDIF
      IF (ISSAD) ICPR=.FALSE.                                           0317YC99
C     CALL SUBROUTINE PROJCT HERE INSTEAD OF BELOW
C     TO TEST THE USE OF PROJECTION METHOD
C     BEFORE FORMING THE FORCE CONSTANT MATRIX IN 
C     INTERNAL COORDINATES
C
c      IF(INTPRJ.EQ.0) CALL PROJCT
      IF(.NOT.ISSAD.AND.INTPRJ.EQ.0) CALL PROJCT                        0317YC99
      NCART = N3
C
C      MAKE LOCAL COPIES OF POSITION, GRADIENT, AND HESSIAN
C
      IJ = 0
      DO 20 I = 1, N3
      XX(I) = X(I)
      DXX(I) = DX(I)
      DO 10 J = 1, N3
	 IJ = IJ +1
	 FX(IJ) = F(I,J)
 10   CONTINUE
 20   CONTINUE
C
C     PROJECT OUT TRANS/ROT/CART GRAD FROM CART HESSIAN
C     PREPARES VARIOUS ARRAYS FOR OTHER PURPOSES
C
c      IF(INTPRJ.EQ.1) CALL PROJCT
      IF(.NOT.ISSAD.AND.INTPRJ.EQ.1) CALL PROJCT                        0317YC99
C
C     DEBUGGING INFORMATION
C

      IF(ICPR)THEN
         WRITE(FU6,*)'LSAVE=',LSAVE
         ISHFT=6      
         WRITE(FU6,'(/,
     >   '' *** (ICFDIAG: CARTESIAN FREQUENCIES ***'')')
         ISHFT=6
         WRITE(FU6,'(4E19.6)')(FREQ(I+ISHFT)*AUTOCM,I=1,N3-6)
         WRITE(FU6,'(/,
     >  '' *** (ICFDIAG: CARTESIAN COORDINATES ***'')')
         WRITE(FU6,'(1X,3E20.7)')(XX(I),I=1,N3)
         WRITE(FU6,'(/,
     >   '' *** (ICFDIAG: DXMAG AND DXNORM ***'')')
         WRITE(FU6,'(2E20.7)')DXMAG,DXNORM
         WRITE(6,'(/,
     >   '' *** (ICFDIAG: CARTESIAN GRADIENTS ***'')')
         WRITE(FU6,'(1X,3E20.7)')(DXX(I),I=1,N3)
         WRITE(FU6,*)'MASS-WEIGHTED FORCE CONSTANT MATRIX'
         CALL PRSQ(FX,N3,N3,N3,N3,FU6)
      ENDIF
C
C     CONVERT GRADIENT, POSITIONS, AND FORCE CONSTANT MATRIX FROM
C     MASS WEIGHTED CARTESIANS TO CARTESIANS
C
      CALL TRANS(2,N3,AMASS,XX,DXX)
      CALL TRANSF(2,N3,AMASS,FX)
C
C     UNSCALE AND UNNORMALIZE THE GRADIENT.  IT HAD BEEN SCALED IN MW 
C     COORDS SO THAT LARGEST ELEMENT WAS UNITY AND NORMALIZED SO THAT
C     NORM WAS ONE.  THESE TWO FACTORS ARE COMBINED IN DXMAG.  AFTER THIS
C     THE GRADIENT IS UNSCALED, UNNORMALIZED, AND IN CARTESIAN COORDS
C  
      DO 40 I = 1,NCART
      DXX(I) = DXX(I) * DXMAG
   40 CONTINUE
C  
C  IN DEBUG MODE, PRINT OUT THE CARTESIAN GRADIENT
C  
      IF(ICPR)THEN
         WRITE(FU6,'(/,
     >  '' *** (ICFDIAG: UNSCALED CARTESIAN COORDINATES ***'')')
         WRITE(FU6,'(1X,3F20.7)')(XX(I),I=1,N3)
         WRITE(FU6,'(/,
     >  '' *** (ICFDIAG: UNSCALED AND UNNORMALIZED ***'')')
         WRITE(FU6,*)'*** CARTESIAN GRADIENTS ***'
         WRITE(FU6,'(1X,3F20.7)')(DXX(I),I=1,N3)
      ENDIF
C
C  DETERMINE WHAT TYPE OF MOLECULE IS BEING TREATED
C     MOLTYP = 1 (COLLINEAR TRIATOMIC)
C     MOLTYP = 2 (BENT TRIATOMIC)
C     MOLTYP = 3 (6 ATOMS, C3V, AS IN CH3 + H2)
C
      IF((ICODE(5).EQ.3).AND.(NATOM.EQ.3))THEN
	 MOLTYP = 1
      ELSEIF ((ICODE(5).EQ.4).AND.(NATOM.EQ.3))THEN
	 MOLTYP = 2
      ELSEIF (NATOM.EQ.6) THEN
	 MOLTYP = 3
      ELSE
	 WRITE(FU6,9920)ICODE(5),NATOM
	 STOP
 9920    FORMAT(1X,'ERROR IN ICDRIV ASSIGNING MOLECULE TYPE '
     &   ,'ICODE(5) AND NATOM = ',2I5)
      ENDIF
C
C     DETERMINE INDEXES FOR THE ATOMS IN THE MOLECULE AND
C     DEFINE VARIABLES DEPENDENT ON MOLECULE TYPE
C
      IF (MOLTYP.EQ.1) THEN
C
C        NUMBER OF INTERNAL COORDINATES IS 4
C        2 CART DIFFERENCES YIELD 6 COORDINATES
C        THE ORDER OF THE FOUR INTERNAL COORDINATES IS: RIJ,RIK,PHI-X,PHI-Y 
C
         NINT = 4
         NDIFF = 2
	 CALL CENTR1(XX,N3TM,INDI,INDJ,INDK,FU6)
      ELSEIF (MOLTYP.EQ.2) THEN
C
C        THREE INTERNAL, TWO DIFFERENCE COORDINATES
C
	 NINT=3
	 NDIFF=2
	 SING = ZERO
	 COSG = ZERO
	 IND1 = 1
	 IND2 = 2
	 IND3 = 3
	 CALL CENTRAL(SING,COSG,IND1,IND2,IND3,INDI,INDJ,INDK,XX,N3TM)
      ELSEIF (MOLTYP.EQ.3) THEN
C
C        CASE FOR CH3 + H2
C        TWELVE INTERNAL COORDINATES, FIVE DIFFERENCE CARTESIANS
C        ONE LINEAR HHC BEND, THREE HCH BENDS WITH AXIS, TWO HCH BENDS
C        NOT ON AXIS.
C
	 NINT = 12
	 NDIFF = 5
	 IND1 = 1
	 IND2 = 2
	 IND3 = 3
	 IND4 = 4
	 IND5 = 5
	 IND6 = 6
	 INDF1 = 1
	 INDF2 = 2
	 INDF3 = 3
	 INDF4 = 4
	 INDF5 = 5
      ENDIF
C
      NDCART = NDIFF*3
C 
C     FORM THE TRANSFORMATION MATRIX FROM CARTESIANS TO DIFF CARTS
C     THIS MATRIX IS DIMENSION (NDIFF X NCART)
C 
      IF (MOLTYP .EQ.1) THEN
C
C        THE ORDER OF THE DIFFERENCE CARTESIANS IS: (RJ-RI), (RK-RI)
C
         INDINT = 1
         CALL FORMBT(BT,NDCART,NCART,INDI,INDJ,INDINT)
         INDINT = 2
         CALL FORMBT(BT,NDCART,NCART,INDI,INDK,INDINT)
C
      ELSEIF(MOLTYP.EQ.2)THEN
C
C        ADD CALLS TO FORMBT FOR THE TWO DIFFERENCE CARTESIANS
C        IN THE BENT TRIATOMIC CASE
C
         INDINT = 1
         CALL FORMBT(BT,NDCART,NCART,INDI,INDJ,INDINT)
         INDINT = 2
         CALL FORMBT(BT,NDCART,NCART,INDI,INDK,INDINT)
C
      ELSEIF(MOLTYP.EQ.3)THEN
C
C        ADD CALLS FOR THE 6 ATOM CASE
C        THE H1 - H6 COORDINATE   R16
C
	 INDINT = INDF1
	 CALL FORMBT(BT,NDCART,NCART,IND1,IND6,INDINT)
C
C        THE C5 - H1 COORDINATE
C
	 INDINT = INDF2
	 CALL FORMBT(BT,NDCART,NCART,IND1,IND5,INDINT)
C
C        THE C5 - H4 COORDINATE
C
	 INDINT = INDF3
	 CALL FORMBT(BT,NDCART,NCART,IND5,IND4,INDINT)
C
C        THE C5 - H3 COORDINATE
C
	 INDINT = INDF4
	 CALL FORMBT(BT,NDCART,NCART,IND5,IND3,INDINT)
C
C     THE C5 - H2 COORDINATE
C
	 INDINT = INDF5
	 CALL FORMBT(BT,NDCART,NCART,IND5,IND2,INDINT)
      ENDIF
      IF(ICPR)THEN
C
      WRITE(FU6,9168) INDI,INDJ,INDK
 9168 FORMAT(1X,'INDI,INDJ,INDK= ',3I3)
      ENDIF
C
C     FORM THE DIFFERENCE CARTESIANS BY MULTIPLYING THE CARTESIAN
C     COORDINATES BY THE TRANSFORMATION MATRIX.  
C
      CALL MATX(XXDIFF,1,BT,1,XX,1,NDCART,NCART,NCART,1)
C
C     OBTAIN THE MAGNITUDES OF THE NDIFF DIFFERENCE VECTORS
C
      CALL VECMAG(XXDIFF,NDCART,NDIFF,RDIFF)
C
      IF (ICPR)THEN
         WRITE(FU6,9060)(XXDIFF(I,1),I=1,NDCART)
         WRITE(FU6,9061)(RDIFF(I),I=1,NDIFF)    
         WRITE(FU6,'(''BT'')')
         CALL PRSQ(BT,NDCART,NCART,NDCART,NCART,FU6)
 9060    FORMAT(1X,'XXDIFF',3E20.7)
 9061    FORMAT(1X,'RDIFF',3E20.7)
      ENDIF
C
C     FORM THE BMATRIX ELEMENTS FOR THE INTERNAL COORDINATES 
C     IN TERMS OF THE DIFFERENCE CARTESIANS IN BMATD
C     ALSO FORM THE SECOND DERIVATIVE TENSOR ELEMENTS IN TERMS
C     OF THE SAME DIFFERENCE CARTESIANS
C
      IF (MOLTYP.EQ.1)THEN
C
C        FOR INTERNAL COORD #1(RIJ)  IN DIFF CARTS
C
         INDINT = 1
         INDDC = 1
         CALL BMAT1(BMATD,NINT,NDCART,XXDIFF,RDIFF,INDDC,INDINT)
         INDINT = 1
         INDDC = 1 
         CALL BTEN1(BTEND,BMATD,NINT,NDIFF,RDIFF,INDDC,INDINT)
C
C        INTERNAL COORD #2 (RIK) IN DIFF CARTS
C
         INDINT = 2
         INDDC = 2
         CALL BMAT1(BMATD,NINT,NDCART,XXDIFF,RDIFF,INDDC,INDINT)
         INDINT = 2
         INDDC = 2
         CALL BTEN1(BTEND,BMATD,NINT,NDIFF,RDIFF,INDDC,INDINT)
C
C.       INTERNAL COORD #3-4, The DOUBLY DEGENERTE LINEAR BEND
C        BETWEEN DIFF CART VECTORS 1 AND 2
C
         INDDC1 = 1
         INDDC2 = 2
         INDINT=3
         CALL BMAT5(BMATD,NINT,NDCART,XXDIFF,RDIFF,INDDC1,INDDC2
     &   ,INDINT)
         INDDC1 = 1
         INDDC2 = 2
         INDINT = 3
         CALL BTEN5(BTEND,NINT,NDIFF,RDIFF,INDDC1,INDDC2,INDINT)
C
      ELSEIF (MOLTYP.EQ.2) THEN
C
	 INDDC = 1
	 INDINT = 1
	 CALL BMAT1(BMATD,NINT,NDCART,XXDIFF,RDIFF,INDDC,INDINT)
	 INDDC = 1
	 INDINT = 1
	 CALL BTEN1(BTEND,BMATD,NINT,NDIFF,RDIFF,INDDC,INDINT)
	 INDDC = 2
	 INDINT = 2 
	 CALL BMAT1(BMATD,NINT,NDCART,XXDIFF,RDIFF,INDDC,INDINT)
	 INDDC = 2
	 INDINT = 2 
	 CALL BTEN1(BTEND,BMATD,NINT,NDIFF,RDIFF,INDDC,INDINT)
	 INDINT = 3
	 INDDC1 = 1
	 INDDC2 = 2
	 CALL BMAT2(BMATD,NINT,NDCART,SING,COSG,RDIFF,INDDC1,
     &   INDDC2,INDINT)
	 INDINT = 3
	 INDDC1 = 1
	 INDDC2 = 2
	 CALL BTEN2(BTEND,NINT,NDIFF,BMATD,SING,COSG,RDIFF,INDDC1,
     &   INDDC2,INDINT)
C
      ELSEIF (MOLTYP.EQ.3) THEN
C
C        TREAT THE FIVE BOND STRETCHING COORDINATES
C        R16
C
	 INDINT = 1
	 INDDC = INDF1
         CALL BMAT1(BMATD,NINT,NDCART,XXDIFF,RDIFF,INDDC,INDINT)
         CALL BTEN1(BTEND,BMATD,NINT,NDIFF,RDIFF,INDDC,INDINT)
	 INDINT = INDINT + 1
C
C        R51, INDINT EQUAL 2
C
	 INDDC = INDF2
         CALL BMAT1(BMATD,NINT,NDCART,XXDIFF,RDIFF,INDDC,INDINT)
         CALL BTEN1(BTEND,BMATD,NINT,NDIFF,RDIFF,INDDC,INDINT)
	 INDINT = INDINT + 1
C
C        R54, INDINT EQUAL 3
C
	 INDDC = INDF3
         CALL BMAT1(BMATD,NINT,NDCART,XXDIFF,RDIFF,INDDC,INDINT)
         CALL BTEN1(BTEND,BMATD,NINT,NDIFF,RDIFF,INDDC,INDINT)
	 INDINT = INDINT + 1
C
C        R53, INDINT EQUAL 4
C
	 INDDC = INDF4
         CALL BMAT1(BMATD,NINT,NDCART,XXDIFF,RDIFF,INDDC,INDINT)
         CALL BTEN1(BTEND,BMATD,NINT,NDIFF,RDIFF,INDDC,INDINT)
	 INDINT = INDINT + 1
C
C        R52, INDINT EQUAL 5
C
	 INDDC = INDF5
	 CALL BMAT1(BMATD,NINT,NDCART,XXDIFF,RDIFF,INDDC,INDINT)
         CALL BTEN1(BTEND,BMATD,NINT,NDIFF,RDIFF,INDDC,INDINT)
	 INDINT = INDINT + 1
C
C        TREAT THE DEGENERATE LINEAR C5-H1-H6 BEND, INDINT EQUAL 6&7
C        ANGLE DEFINED BY DIFF VECTORS 1 AND 2
C        CHECK THE VALUE OF COSINE OF ANGLE TO MAKE SURE IT IS LINEAR
C        TRAP CALLS WITH VALUES MORE THAN 1 DEGREE FROM LINEAR
C
         CALL ANGLCS(RDIFF,XXDIFF,NDIFF,INDF1,INDF2,COSG,SING)
	 IF (dabs(SING) .GT. 1.75D-02) THEN
	    WRITE(FU6,9921)COSG,SING
 9921       FORMAT(1X,'ERROR IN LINEAR C5-H1-H6 BEND - NONLINEAR',
     &      ' COS,SIN= ',2E20.7)
	    STOP
	 ENDIF
C
C        THE SCR REGION PASSES A TRANSFORMATION MATRIX BETWEEN MAT5X AND
C        BTEN5X.  THIS TRANSF TAKES THE MOLECULE TO A FRAME THAT HAS THE
C        LINEAR BEND ALONG THE Z AXIS.
C
         INDDC1 = INDF1
	 INDDC2 = INDF2
         CALL BMAT5X(BMATD,NINT,NDCART,XXDIFF,RDIFF,SCR,
     &   INDDC1,INDDC2,INDINT)
         CALL BTEN5X(BTEND,NINT,NDIFF,RDIFF,SCR,INDDC1,INDDC2,INDINT)
	 INDINT = INDINT + 2
C
C        TREAT THE NONLINEAR VALENCE ANGLE BENDS.  THE CALL MUST PROVIDE
C        VALUES OF THE SINE AND COSINE OF THE VALENCE ANGLE
C        THETA H1-C5-H4, INDINT = 8
C
         INDDC1 = -INDF2
         INDDC2 = INDF3
         CALL ANGLCS(RDIFF,XXDIFF,NDIFF,INDDC1,INDDC2,COSG,SING)
	 CALL BMAT2(BMATD,NINT,NDCART,SING,COSG,RDIFF,INDDC1,
     &   INDDC2,INDINT)
	 CALL BTEN2(BTEND,NINT,NDIFF,BMATD,SING,COSG,RDIFF,INDDC1,
     &   INDDC2,INDINT)
	 INDINT = INDINT + 1
C
C        THETA H1-C5-H3, INDINT = 9
C
         INDDC1 = -INDF2
         INDDC2 = INDF4
         CALL ANGLCS(RDIFF,XXDIFF,NDIFF,INDDC1,INDDC2,COSG,SING)
	 CALL BMAT2(BMATD,NINT,NDCART,SING,COSG,RDIFF,INDDC1,
     &   INDDC2,INDINT)
	 CALL BTEN2(BTEND,NINT,NDIFF,BMATD,SING,COSG,RDIFF,INDDC1,
     &   INDDC2,INDINT)
	 INDINT = INDINT + 1
C
C        THETA H1-C5-H2, INDINT = 10
C
         INDDC1 = -INDF2
         INDDC2 = INDF5
         CALL ANGLCS(RDIFF,XXDIFF,NDIFF,INDDC1,INDDC2,COSG,SING)
	 CALL BMAT2(BMATD,NINT,NDCART,SING,COSG,RDIFF,INDDC1,
     &   INDDC2,INDINT)
	 CALL BTEN2(BTEND,NINT,NDIFF,BMATD,SING,COSG,RDIFF,INDDC1,
     &   INDDC2,INDINT)
	 INDINT = INDINT + 1
C
C        THETA H2-C5-H3, INDINT = 11
C
         INDDC1 = INDF5
         INDDC2 = INDF4
         CALL ANGLCS(RDIFF,XXDIFF,NDIFF,INDDC1,INDDC2,COSG,SING)
	 CALL BMAT2(BMATD,NINT,NDCART,SING,COSG,RDIFF,INDDC1,
     &   INDDC2,INDINT)
	 CALL BTEN2(BTEND,NINT,NDIFF,BMATD,SING,COSG,RDIFF,INDDC1,
     &   INDDC2,INDINT)
	 INDINT = INDINT + 1
C
C        THETA H3-C5-H4, INDINT = 12
C
         INDDC1 = INDF4
         INDDC2 = INDF3
         CALL ANGLCS(RDIFF,XXDIFF,NDIFF,INDDC1,INDDC2,COSG,SING)
	 CALL BMAT2(BMATD,NINT,NDCART,SING,COSG,RDIFF,INDDC1,
     &   INDDC2,INDINT)
	 CALL BTEN2(BTEND,NINT,NDIFF,BMATD,SING,COSG,RDIFF,INDDC1,
     &   INDDC2,INDINT)
      ENDIF
C
C     TO TRANSFORM THE B MATRIX FROM DIFF CARTS TO CARTESIANS
C     POST MULTIPLY BY THE BT TRANSFORMATION 
C     BMAT CONTAINS THE WILSON BMATRIX IN REGULAR CARTESIANS
C
      CALL MATX(BMAT,1,BMATD,1,BT,1,NINT,NDCART,NDCART,NCART)
C       
      IF (ICPR)THEN
         WRITE(FU6,9064)
         CALL PRSQ(BMATD,NINT,NDCART,NINT,NDCART,FU6)
         WRITE(FU6,9065)
         CALL PRSQ(BMAT,NINT,NCART,NINT,NCART,FU6) 
 9064    FORMAT(1X,'BMATD',/,(1X,6E13.4))
 9065    FORMAT(1X,'BMAT',/,(1X,9E9.1))
       ENDIF
C
C     CALL BTENTR TO TRANSFORM THE SET OF BTENSORS FROM DIFFERENCE
C     CARTESIANS TO CARTESIANS
C
      CALL BTENTR(BTEN,BTEND,BT,SCR,NCART,NDCART,NINT)
C
C     DEBUGGIN STATEMENTS PRINT OUT BTEN AND BTEND TENSORS
C
      IF(ICPR)THEN
         WRITE(FU6,*)' BTEN TENSOR'
         ISHFT = 1
         ISHFTD = 1
         DO 8910 I = 1, NINT
          WRITE(FU6,*)' BTEN for INTERNAL COORDINATE NO ',I
          CALL PRSQ(BTEN(ISHFT),NCART,NCART,NCART,NCART,FU6)
          WRITE(FU6,*)' BTEND for INTERNAL COORDINATE NO ',I
          CALL PRSQ(BTEND(ISHFTD),NDCART,NDCART,NCART,NCART,FU6)
          ISHFT=ISHFT+NCART*NCART
          ISHFTD = ISHFTD + NDCART*NDCART
 8910    CONTINUE
       ENDIF
C
C     CALL FORMA TO FORM THE INVERSE MASS MATRIX AND THE GENERALIZED
C     INVERSE OF THE BMATRIX FOLLOWING PULAY.  AMAT IS THE BMAT INVERSE
C     AND AMASIN IS THE INVERSE MASS MATRIX
C
      CALL FORMA(AMAT,BMAT,USCR,SCR,AMASS,REDM,
     &       AMASIN,NINT,NCART)
C
C     DEBUGGIN STATEMENTS TO CHECK ON INVERSE
C
      IF(ICPR)THEN
         CALL MATX(SCR,1,BMAT,1,AMAT,1,NINT,NCART,NCART,NINT)
         WRITE(FU6,'(''AMAT'')')
         CALL PRSQ(AMAT,NCART,NINT,NCART,NINT,FU6)
         WRITE(FU6,'(''BMAT*AMAT'')')
         CALL PRSQ(SCR,NINT,NINT,NINT,NINT,FU6)
C
C   CHECK ON THE COMMUTATION OF THIS PRODUCT
C
         WRITE(FU6,'(''AMAT*BMAT'')')
         CALL MATX(SCR,1,AMAT,1,BMAT,1,NCART,NINT,NINT,NCART)
         CALL PRSQ(SCR,NCART,NCART,NCART,NCART,FU6)
      ENDIF
C
C     CONVERT GRADIENT IN CARTESIANS TO INTERNAL COORDINATES
C     G(int) = A-tr*G(carts)
C
      CALL MATX(DXINT,1,AMAT,0,DXX,1,NCART,NINT,NCART,1)
C
C     TRANSFORM THE FORCE CONSTANT MATRIX FROM CARTESIANS TO INTERNALS
C
      CALL FORMF(FX,FXINT,AMAT,BTEN,DXINT,NCART,NINT,USCR,SCR)
C
C     SCALING THE FORCE CONSTANT MATRIX (not scale the SPt)             1227PJ00
C                                
      IF(( IFCFAC .EQ. 1) .and. (issad .eqv. .false.)) THEN
         CALL FCSCL(FXINT, NINT, 6)
      ENDIF
C
      IF (ICPR)THEN
         WRITE(FU6,9057)DXMAG,DXNORM
         WRITE(FU6,9050) (DXX(I),I=1,NCART)
         CALL DOTPRD(DXX,DXX,SUMX(1),NCART)
         WRITE(FU6,*)' NORM-SQ OF CART GRAD =',sumx(1)
         WRITE(FU6,9051) (DXINT(I), I=1,NINT)
         CALL MATX(SCR,1,BMAT,1,BMAT,0,NINT,NCART,NINT,NCART)
         CALL MATX(AVEC,1,SCR,1,DXINT,1,NINT,NINT,NINT,1)
         CALL MATX(SUMX,1,DXINT,0,AVEC,1,NINT,1,NINT,1)
         WRITE(FU6,*)'NORM SQUARED OF INTERNAL GRAD =',SUMX(1)  
         WRITE(FU6,'(''CARTESIAN F-MATRIX'')')
         CALL PRSQ(FX,NCART,NCART,NCART,NCART,FU6)
         WRITE(FU6,'(''INTERNAL F-MATRIX'')')
         CALL PRSQ(FXINT,NINT,NINT,NINT,NINT,FU6)
 9050    FORMAT(1X,'CARTESIAN GRADIENT',/,(4E19.6))
 9051    FORMAT(1X,'INTERNAL COORD GRAD',/,(4E19.6))
 9057    FORMAT(1X,'CART GRADIENT DXMAG, DXNORM = ',2E20.7)    
         WRITE(FU6,*)' BTEN TENSOR AFTER TRANSF TO INTERNALS'
         ISHFT = 1
         DO 8911 I = 1, NINT
            WRITE(FU6,*)' BTEN for INTERNAL COORDINATE NO ',I
            CALL PRSQ(USCR(ISHFT,1,1),NINT,NINT,NINT,NINT,FU6)
            ISHFT=ISHFT+NINT*NINT   
 8911    CONTINUE
      ENDIF
C 
C     FORM THE KINETIC ENERGY MATRIX IN INTERNAL COORDINATES IN GMAT
C
      IF(INTPRJ.EQ.0) THEN
        CALL FORMG(GMAT,BMAT,AMASS,REDM,SCR,USCR,NINT,NCART)
C
C     REPLACED WITH IN LINE CALLS TO MATX
C     FORM G = B*(1/M)*B-tr
C
      ELSE
        CALL MATX(SCR,1,AMASIN,1,BMAT,0,NCART,NCART,NINT,NCART)
        CALL MATX(GMAT,1,BMAT,1,SCR,1,NINT,NCART,NCART,NINT)
      ENDIF
C
C     THE METRIC FORMED AND USED IN PROJF IS THE SAME AS THE WILSON
C     G-MATRIX.  IT HAS BEEN PLACED IN THE REGIONS GMAT BY THE
C     PREVIOUS CALL TO PROJF
C
C     SINCE THE FORCE CONSTANT IS PROJECTED IN THE CARTESIAN SPACE
C     NO NEED PROJECTION IN INTERNAL SPACE
C
c      IF(INTPRJ.EQ.1) THEN
      IF(.NOT.ISSAD.AND.INTPRJ.EQ.1) THEN                               0317YC99
C
C     FORM THE PROJECTION OPERATOR AND PROJECT THE GRADIENT FROM FX
C
       CALL PROJF(FXINT,DXINT,BMAT,SCR,USCR,USCR(1,1,2),GMAT
     &,AMASIN,NINT,NCART) 
C
       IF (ICPR)THEN
         WRITE(FU6,9056)
 9056    FORMAT(1X,'PROJ -RIGHT, FOLLOWED BY PROJ -LEFT')
         CALL PRSQ(USCR,NINT,NINT,NINT,NINT,FU6)
         CALL PRSQ(USCR(1,1,2),NINT,NINT,NINT,NINT,FU6)
       ENDIF
      ENDIF
C
      IF (ICPR)THEN
         WRITE(FU6,*)'AFTER CALLS TO PROJF AND FORMG'
         WRITE(FU6,'(''INTERNAL F-MATRIX'')')
         CALL PRSQ(FXINT,NINT,NINT,NINT,NINT,FU6)
         WRITE(FU6,'(''GMAT'')')
         CALL PRSQ(GMAT,NINT,NINT,NINT,NINT,FU6)
C 
C        FOR DEBUGGING PURPOSES, FORM GF PRODUCT AND PRINT OUT
C 
         CALL MATX(SCR,1,GMAT,1,FXINT,1,NINT,NINT,NINT,NINT)
         WRITE(FU6,'(''GF PRODUCT'')')
         CALL PRSQ(SCR,NINT,NINT,NINT,NINT,FU6)
       ENDIF
C
C     OBTAIN THE FREQUENCIES AND NORMAL MODES
C
      CALL GFDIAG(ISSAD,GMAT,FXINT,FREQIC,AVEC,
     *            SCR,USCR,USCR(1,1,2),NINT)
C
C     PRINT RESULTS
C
      IF(ICPR)THEN
         WRITE(FU6,9910)(AUTOCM*FREQIC(I),I=1,NINT)
         WRITE(FU6,'(''UNNORMALIZED NORMAL MODE VECTORS'')')
         CALL PRSQ(AVEC,NINT,NINT,NINT,NINT,FU6)
 9910    FORMAT(1X,'VIBRATIONAL FREQUENCIES IN CM-1',
     *   /,(1X,4E19.6))
      ENDIF
C
C     CONVERT THE EIGENVECTORS FROM INTERNAL TO MASS WGTED CARTESIAN COORDINATES
C
      CALL VECCON(AVEC,GMAT,AMAT,SCR,USCR,USCR(1,1,2)       
     &,AMASS,NINT,NCART,.false.)                                        0626YC97
c
c   move the unbound mode to first position for later calculation
c
      IF (ISSAD) THEN                                                   0317YC99
        FREQ(1) = FREQIC(1)                                             0317YC99
        DO J = 1, NCART                                                 0317YC99
          COF(J,1) = AVEC(J)                                            0317YC99
        ENDDO                                                           0317YC99
      ENDIF                                                             0317YC99
C
C      PRINT RESULTS
C
      IF(ICPR)THEN
         WRITE(FU6,9914)
         CALL PRSQ(AVEC,NCART,NINT,NCART,NINT,FU6)
 9914    FORMAT(1X,'AFTER VECCON, NORMAL MODE VECTORS IN MW CARTS')
      ENDIF
C
C     STORE THE FREQUENCIES
C     EIGENVECTORS INTO THE EXPECTED REGION, OVERWRITING THE CARTESIAN
C     INFORMATION ALREADY OBTAINED
C
      CALL ICSAVE(ISSAD,IOP,AVEC,FREQIC,USCR,USCR(1,1,2),SCR
     &               ,NINT,NCART)
C
      IF(ICPR)THEN
         WRITE(FU6,9916)
         CALL PRSQ(COF,N3TM,NCART,N3TM,NCART,FU6)
 9916    FORMAT(1X,'FULL SET OF CART NORMAL MODE VECTORS ')
C
C        check the orthogonality of final vectors
C
         INDS = 1
         DO 200 I = 1,NCART 
	 DO 190 J = 1,NCART
               SCR(INDS) = COF(J,I)
               INDS = INDS + 1
  190       CONTINUE
  200    CONTINUE
C
C        FORM THE OVERLAP MATRIX OF THE VECTORS
C        USCR = SCR(tr)*SCR
C
         CALL MATX (USCR,1,SCR,0,SCR,1,NCART,NCART,NCART,NCART)
         WRITE(FU6,9917)
 9917    FORMAT(1X,'OVERLAP MATRIX')
         CALL PRSQ(USCR,NCART,NCART,NCART,NCART,FU6)
      ENDIF
C
 9999 IF(LGS2(39).GE.3) CALL CVCOOR(IOP,ISSAD)
C     RETURN
      END subroutine icfdiag
C***********************************************************************
C    ICSAVE
C***********************************************************************
C
      SUBROUTINE icsave(ISSAD,IOP,COFINT,FRQINT,TCOF,SCR1,SCR2,N1,N2)
      use common_inc
      use perconparam,only : fu6,n3tm
      use kintcm
C
C     ICSAVE COPIES FREQUENCIES AND EIGENVECTORS FOR BOUND
C     MODES FROM INTERNAL COORDINATE WORK SPACES TO USUAL
C     SPACES USED BY CARTESIAN COORDINATE PROCEDURES.
C
C     CALLED BY:
C              ICFDIAG
C
C     CALLS:
C          MATX,JACSCF,ABSORD,OVRLP
C
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
C
      DIMENSION COFINT(N2,N1),FRQINT(N1),TCOF(N2),SCR1(N2,N2)
     &          ,SCR2(N2*N2),iscr(n3tm)
      LOGICAL LWRITE
      LOGICAL   ISSAD                                                   0317YC99
      DATA EPSX/1.0D-10/,ZERO/0.0D00/,ONE/1.0D00/
C
c  initialize 
c
      IF (ISSAD) THEN                                                   0317YC99
        IBBEG=2                                                         0317YC99
      ELSE                                                              0317YC99
        IBBEG = 1                                                       0317YC99
      ENDIF                                                             0317YC99
      LGS4 = LGS(4)                               
      LGS9 = LGS(9)                               
      IF(iabs(LGS9).GE.2) LWRITE = LGS4.GT.0 .OR. 
     *    (SOB.LT.SOE .AND. S.GE.SOB .AND. S.LE.SOE) .OR.   
     *    (SOE.LT.SOB .AND. S.GE.SOE .AND. S.LE.SOB)       
C
      NC = N2
      NI = N1
      N3M7 = NF(5)
      NEND = N3

      call  fdiag_mem(nend)

C
C  ZERO OUT THE COEFFICIENT MATRIX
C
      DO 20 I = IBBEG,NC                                                0317YC99
	 DO 10 J = 1,N3TM
	    COF(J,I) = ZERO
   10    CONTINUE
   20 CONTINUE
C
C     FORM THE PROJECTION OPERATOR FOR THE BOUND MODE VIBRATIONAL 
C     NORMAL MODE EIGEN VECTORs
C     SCR2 = COFINT * COFINT(tr)
C
      ISHFTI = 2; scr2=0.d00
      CALL MATX (SCR2,-1,COFINT(1,ISHFTI),1,COFINT(1,ISHFTI),0,
     &           NC,NI-1,NC,NI-1)

      
C
C      SUBTRACT THE PROJECTOR FROM THE UNIT MATRIX
C
      INDS = 0
      DO 40 I =1,NC
         DO 30 J = 1,I-1 
            SCR2(INDS+J) = -SCR2(INDS+J)
   30    CONTINUE
         SCR2(INDS+I) = ONE - SCR2(INDS+I)
         INDS = INDS+I
   40 CONTINUE



C
C     DIAGONALIZE THE PROJECTED UNIT MATRIX AND ORDER THE RESULTING
C     EIGENVALUES AND EIGENVECTORS.  THE PROJECTED BOUND MODES SHOULD
C     CORRESPOND TO ZERO EIGENVECTORS
C
      scr1=0.d00
      CALL JACSCF (SCR2,SCR1,TCOF,NC,-1,EPSX)


      CALL ABSORD (SCR1,TCOF,ISCR,SCR2(NC+1),NC,NC,NC)


C
C     PLACE THE EIGENVECTORS OF THE UNBOUND MODES INTO THE FIRST LOCATIONS
C     OF COF.  THESE WILL CORRESPOND TO THE NONZERO EIGENVALUES OF THE
C     PROJECTED UNIT MATRIX.  AS EIEGENVECTORS OF THE PROJECTED FORCE CONSTANT
C     MATRIX THEY WILL BE ASSIGNED ZERO EIGENVALUES IN FREQ.
C
      IEND = NEND - N3M7
      ISHFTI = N3M7
      DO 80 I = IBBEG, IEND                                             0317YC99
         FREQ(I) = ZERO
         DO 70 J = 1,NEND
            COF(J,I) = SCR1(J,ISHFTI+I)
   70    CONTINUE
   80 CONTINUE
C
C     FILL THE REST OF THE COF AND FREQ ARRAYS WITH THE VECTORS AND
C     FREQUENCIES DETERMINED DURING THE INTERNAL COORDINATE NORMAL MODE
C     ANALYSIS
C
      ISHFTC = NEND - N3M7
      ISHFTI = 1
      DO 120 I = 1, N3M7
        FREQ(ISHFTC + I) = FRQINT(ISHFTI + I)
        DO 110 J = 1, NEND
          COF(J,ISHFTC+I) = COFINT(J,ISHFTI+I)
  110   CONTINUE
  120 CONTINUE


C
C        add a sort to the bounded modes                                0601YC98
C
      DO I = 1, N3M7 - 1                                                0601YC98
        DO J = I+ 1, N3M7                                               0601YC98
           IF (FREQ(ISHFTC+I).GT.FREQ(ISHFTC+J)) THEN                   0601YC98
                TEMPF = FREQ(ISHFTC+I)                                  0601YC98
                FREQ(ISHFTC+I) = FREQ(ISHFTC+J)                         0601YC98
                FREQ(ISHFTC+J) = TEMPF                                  0601YC98
                DO K = 1, NEND                                          0601YC98
                  TMCOF = COF(K,ISHFTC+I)                               0601YC98
                  COF(K,ISHFTC+I) = COF(K, ISHFTC+J)                    0601YC98
                  COF(K,ISHFTC+J) = TMCOF                               0601YC98
                ENDDO                                                   0601YC98
           ENDIF                                                        0601YC98
        ENDDO                                                           0601YC98
      ENDDO                                                             0601YC98
C
C     THE FOLLOWING CODE IS LIFTED FROM SUBROUTINE FDIAG
C     IT REORDERS THE VECTORS/FREQUENCIES ACCORDING TO THE
C     CONVENTIONS EXPECTED BY POLYRATE
C
C     Calculate the overlap integral and check the frequency matching
C
      IF (IOP.GT.0.AND.LGS(9).NE.0.AND.INDPH.NE.0.AND.IREORD.NE.0) CALL 1210YC96
     *                         OVRLP(LWRITE,N3,N3M7,COF,COFX,FREQ,S) 
C
C     Change phase of each eigenvector so that the largest component is
C     always positive
C
      DO 230 J = 1, NEND                                        
         COFMAX = 0.0D0                                       
         IMAXX = IN1(J)  
         IF (iabs(LGS(9)).GE.2.AND.INDPH.NE.0)                
     *      A = SGN1(J) *dsign(1.0D0,COF(IMAXX,J))           
         DO 210 I = 1, NEND                                
            IF (dabs(COF(I,J)).GT.(COFMAX+EPSX)) THEN      
               COFMAX = dabs(COF(I,J))                    
               IMAXX = I                                
            ENDIF 
  210    CONTINUE 
         IF (iabs(LGS(9)) .LT. 2 .OR. INDPH .EQ. 0)                      
     *      A = dsign(1.0D0,COF(IMAXX,J)) 
         DO 225 I = 1,NEND                                             
            COF(I,J) = A*COF(I,J)              
            COFX(I,J) = COF(I,J)              
  225    CONTINUE                            
         IF (iabs(LGS(9)).GE.2) THEN         
            IN1(J) = IMAXX                 
            SGN1(J) = dsign(1.0D0,COF(IMAXX,J))  
         ENDIF                                 
  230 CONTINUE                                
C
      IF (IOP .GT. 0 .AND. INDPH.EQ.0)  THEN   
          DO 260 I = 1, NEND                  
             DO 250 K = 1,NEND               
                CSV(K,I) = COF(K,I)         
  250        CONTINUE                      
             IF (iabs(LGS(9)).GE.2) THEN   
                SGN2(I) = SGN1(I)        
                IN2(I) = IN1(I)         
             ENDIF                     
  260     CONTINUE                    
       ELSEIF (IOP .LT.0) THEN       
          DO 350 K = 1, NEND        
             DO 310 I = 1, N3      
                    TCOF(I) = 0.D0  
  310        CONTINUE              
             DO 320 I = 1, NEND   
                    TCOF(IND(I)) =  COF(I,K)  
  320        CONTINUE                        
             DO 330 I = 1, N3               
                    COF(I,K) = TCOF(I)     
  330        CONTINUE                     
  350     CONTINUE                       
      ENDIF                             
      RETURN
      END SUBROUTINE icsave
C***********************************************************************
C     ANGLCS
C***********************************************************************
C
      SUBROUTINE anglcs(R,XD,N1,INDDX1,INDDX2,COSX,SINX)
C
C     ANGLCS COMPUTES THE COSINE AND SINE
C     OF THE VALENCE ANGLE BETWEEN TWO DIFFERENCE CARTESIAN
C     VECTORS.  IT IS ASSUMED THAT THE ANGLE IS
C     DEFINED TO BE BETWEEN ZERO AND PI
C     ARRAY R CONTAINS THE VECTOR MAGNITUDES
C     ARRAY XD CONTAINS THE VECTOR XYZ COMPONENTS
C
C     CALLED BY:
C              ICFDIAG
C
C     CALLS:
C          DOTPRD
C
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
C
      DIMENSION R(N1),XD(3*N1)
      DATA ONE/1.0D00/,ZERO/0.0D00/
C
      INDD1 = IABS(INDDX1)
      INDD2 = IABS(INDDX2)
      LENV = 3
      IND1 = (INDD1-1)*3
      IND2 = (INDD2-1)*3
C
C     FOR THE DOT PRODUCT OF THE TWO VECTORS
C
      CALL DOTPRD(XD(IND1+1),XD(IND2+1),DPRD,LENV)
      COSX = DPRD/(R(INDD1)*R(INDD2))
      SQARG = ONE - COSX*COSX
      IF(SQARG.LT.ZERO) SQARG = ZERO
      SINX = dsqrt(SQARG)
      RETURN
      END SUBROUTINE anglcs
C
C***********************************************************************
C     VECCON
C***********************************************************************
C
      SUBROUTINE veccon (VEC,G,A,SCR1,SCR2,SCR3,AMASS,N1,N2,REDUN)
      use perconparam
C
C     VECCON NORMALIZES THE NORMAL MODE VECTORS AND
C     CONVERTS THEM TO MASS SCALED CARTESIANS
C
C     CALLED BY:
C              ICFDIAG,CVCOOR
C     CALLS:
C          LIN,MATX,TRANS,DOTPRD
C
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
C
      DIMENSION VEC(N2,N2),G(N1,N1),SCR1(N1,N1),SCR2(N1,N1)
     &,SCR3(N1,N1),A(N2,N1),AMASS(N2)
      LOGICAL REDUN
      DATA ONE/1.0D00/,ZERO/0.0D00/
      NI = N1
      NC = N2
C
C     FORM THE INVERSE OF THE UNNORMALIZED VECTOR MATRIX IN SCR1
C
      DET = ZERO
      IF (REDUN) THEN
          CALL MTINV2(VEC,NI,NI,SCR1)
C         CALL MTINV2(VEC,NC,NI,SCR1)
      ELSE
          CALL LIN (VEC,SCR1,SCR1,SCR2,DET,1,NI,NI,0,NI)
      ENDIF
C
C     FORM THE PRODUCT (LINV)*G*(LINV-tr) IN SCR3
C
      CALL MATX (SCR2,1,G,1,SCR1,0,NI,NI,NI,NI)
      CALL MATX (SCR3,1,SCR1,1,SCR2,1,NI,NI,NI,NI)
C
C     FORM THE WEIGHT MATRIX IN SCR2 FROM DIAG ELEMENTS OF SCR3
C
      DO 20 I = 1,NI
         DO 10 J = 1,NI
               SCR2(J,I) = ZERO
   10    CONTINUE
         SCR2(I,I) = DSQRT(SCR3(I,I))
   20 CONTINUE
C
C  FORM THE PRODUCT A*(script L)*(wgt)
C
      CALL MATX(SCR1,1,VEC,1,SCR2,1,NI,NI,NI,NI)
      CALL MATX(VEC,1,A,1,SCR1,1,NC,NI,NI,NI)
C
C     CONVERT THE CARTESIAN VECTORS TO MASS SCALED CARTESIANS
C     THE SCRATCH REGION IS A DUMMY FOR THE GRADIENT IN THE CALL.
C     RENORMALIZE TO AGREE WITH THE CONVENTION IN POLYRATE
C
      DO 40 I = 1, NI
         CALL TRANS (1,NC,AMASS,VEC(1,I),SCR3)
         SUM = ZERO
         CALL DOTPRD(VEC(1,I),VEC(1,I),SUM,NC)
         SUM = dsqrt(SUM)
        DO 30 J =1, NC
           IF (SUM.NE.0.0d0) VEC(J,I) = VEC(J,I)/SUM
  30    CONTINUE
C         IF(SUM.NE.0d0) VEC(:,:) = VEC(:,:)/SUM
   40 CONTINUE
      RETURN
      END SUBROUTINE veccon
C
C***********************************************************************
C     CENTR1
C***********************************************************************
C
      SUBROUTINE centr1(XX,N1,INDI,INDJ,INDK,IFU6)
C
C     SUBROUTINE CENTR1 DETERMINES THE RELATIVE INDEX  
C     ASSIGNMENTS FOR A LINEAR TRIATOMIC SYSTEM.
C     ATOM I IS PLACED IN THE CENTER AND THE J-K
C     ASSIGNMENTS ARE MADE ARBITRARILY
C
C     CALLED BY:
C              ICFDIAG
C
C     CALLS:
C          DPR123
C
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      DIMENSION XX(N1)
C
C     DETERMINE WHICH ATOM IS CENTRAL ONE IN LINEAR TRIATOMIC
C     IF THE DOT PRODUCT BETWEEN Rij AND Rik IS NEGATIVE, THE
C     ATOM NUMBER i IS THE CENTRAL ATOM 
C
      NLEN = N1
      IND1 = 1
      IND2 = 2
      IND3 = 3
      CALL DPR123(IND1,IND2,IND3,XX,NLEN,DPS)
      IF(DPS.LT.0.0D0) THEN
	 INDI=IND2
	 INDJ=IND1
	 INDK=IND3
      ELSE
	  CALL DPR123(IND3,IND1,IND2,XX,NLEN,DPS)
	  IF(DPS.LT.0.0D0) THEN
	     INDI=IND1
	     INDJ=IND3
	     INDK=IND2
          ELSE
	     CALL DPR123(IND2,IND3,IND1,XX,NLEN,DPS)
	     IF(DPS.LT.0.0D0) THEN
	        INDI=IND3
	        INDJ=IND2
		INDK=IND1
	     ELSE
		WRITE(IFU6,9900)
 9900		FORMAT(1X,'ERROR FINDING MOL CONFIG IN ICDRIV')
		STOP
	     ENDIF
          ENDIF
      ENDIF
      RETURN
      END SUBROUTINE centr1
C
C***********************************************************************
C     GFDIAG
C***********************************************************************
C
      SUBROUTINE gfdiag(ISSAD,G,F,ALAMBD,AVEC,SCR1,SCR2,SCR3,N1)
C
C     THIS ROUTINE EFFECTIVELY DIAGONALIZES THE UNSYMMETRIC
C     GF MATRIX, FORMED BY PRODUCT OF G*F.  THE METHOD IS
C     GIVEN IN MCINTOSH AND MICHAELIAN AND IS DUE TO
C     MYAZAWA.  ONLY SYMMETRIC MATRICES ARE DIAGONALIZED HERE.
C     THE GF PRODUCT IS NEVER EXPLICITLY FORMED
C
C     CALLED BY:
C              ICFDIAG,CVCOOR
C     CALLS:
C          JACSCF,MATX,ABSORD
C
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      DIMENSION G(N1,N1),F(N1,N1),ALAMBD(N1)
     *,AVEC(N1,N1),SCR1(N1*N1),SCR2(N1,N1)
     *,SCR3(N1,N1),iscr(n1,n1)
      LOGICAL  ISSAD                                                    0317YC99
      DATA ONE/1.0D00/,ZERO/0.0D00/,EPS/1.D-10/
      NI = N1
C
C   FORM IN SCR1 THE UPPER HALF OF THE SYMMETRIC G MATRIX
C
      IND = 1
      DO 20 J = 1,NI
      DO 10 I = 1,J  
	 SCR1(IND) = G(I,J)
	 IND = IND + 1
   10 CONTINUE
   20 CONTINUE
C
C DIAGONALIZE THE G MATRIX
C
      CALL JACSCF(SCR1,AVEC,ALAMBD,NI,-1,EPS)
C
C     NPCK = NI*(NI+1)/2
C     IERR = 0
C     MATZ = 1
C     CALL RSPP(NI,NI,NPCK,SCR1,ALAMBD,MATZ,AVEC,SCR2,SCR3,IERR)
C
C     TAKE THE SQUARE ROOTS OF THE EIGENVALUES AND EXPAND INTO
C     SQUARE MATRIX 
C     ZERO OUT THE SCR2 MATRIX
C
      DO 40 I = 1,NI
      DO 30 J = 1,NI
	 SCR2(J,I) = ZERO
   30 CONTINUE
   40 CONTINUE 
C
C     REPLACE DIAGONAL ELEMENTS WITH SQUARE ROOTS OF EIGENVALUES
C     CHECK (IN DEBUGGING) TO MAKE SURE THESE ARE POSITIVE
C
C     Add logi here to check if the eigenvalue is essentially
C     zero even though it might be negative.  As a first pass -
C     use a tolerance of 10(-18).  this was added by R. Steckler
C     3/26/97
c     3/30/97 change to 10(-12)  YC
C
      DO 50 I = 1,NI
         IF (dabs(ALAMBD(I)).LT.1.D-12) ALAMBD(I) = 0.0D0                0326RS97
         IF (ALAMBD(I).GE.ZERO)THEN
           SCR2(I,I) = dsqrt(ALAMBD(I))
         ELSE
           WRITE(6,*)'ERROR IN GFDIAG, NEGATIVE SQUARE ROOT'
           WRITE(6,*)'I,LAMDA(I)=',I,ALAMBD(I)
           STOP
         ENDIF
   50 CONTINUE
c
C     FORM THE PRODUCT A = Z*dsqrt(P)
C
      CALL MATX(SCR3,1,AVEC,1,SCR2,1,NI,NI,NI,NI)
C
C     FORM THE PRODUCT A-tr*F*A, WHICH IS SYMMETRIC
C
      CALL MATX(SCR2,1,F,1,SCR3,1,NI,NI,NI,NI)
      CALL MATX(SCR1,-1,SCR3,0,SCR2,1,NI,NI,NI,NI)
C
C     DIAGONALIZE THE A-tr*F*A matrix
C
      CALL JACSCF(SCR1,SCR2,ALAMBD,NI,-1,EPS)
C
C     IERR = 0
C     CALL RSPP(NI,NI,NPCK,SCR1,ALAMBD,MATZ,SCR2,AVEC(1,1) 
C    &,AVEC(1,2),IERR)
C
C     CONVERT EIGENVALUES TO FREQUENCIES, PRESERVING THE SIGN
C
      DO 70 I = 1,NI
	 ALAMBD(I) = dsqrt(dabs(ALAMBD(I)))*dsign(ONE,ALAMBD(I))
   70 CONTINUE
C
C     FORM EIGENVECTORS OF GF PRODUCT AS L = A*Y
C
      CALL MATX(AVEC,1,SCR3,1,SCR2,1,NI,NI,NI,NI)
C
C     ORDER THE FREQS AND VECTORS IN ASCENDING ORDER by ABS VALUE
C
      iscr=0
      IF (ISSAD) THEN  
        CALL ABSORD1(AVEC,ALAMBD,ISCR,SCR2,NI,NI,NI)
      else                                                              0317YC99
        CALL ABSORD(AVEC,ALAMBD,iscr,SCR2,NI,NI,NI)
      ENDIF                                                             0317YC99
      RETURN
      END SUBROUTINE gfdiag
C
C***********************************************************************
C     FORMG
C***********************************************************************
C
      SUBROUTINE formg(G,B,AMASS,REDM,SCR,AMAS2,N1,N2)
C
C     CALLED BY:
C              ICFDIAG
C     CALLS:
C          MATX
C
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      DIMENSION G(N1,N1),B(N1,N2),AMASS(N2),SCR(N2,N2)
      DIMENSION AMAS2(N2,N2)
      DATA ONE/1.0D00/,ZERO/0.0D00/
C
      NC = N2
      NI = N1
C 
C     ZERO OUT THE MASS MATRIX
C 
      DO 20 J = 1,NC
      DO 10 I = 1,NC
	 AMAS2(I,J) = ZERO
   10 CONTINUE
   20 CONTINUE
C 
C     SET THE DIAGONAL ELEMENTS EQUAL TO 1/M.
C     AMASS HAS A REDUCED MASS FACTOR INCLUDED
C 
      DO 30 I = 1,NC
      AMAS2(I,I) = ONE/(REDM*AMASS(I)*AMASS(I))
   30 CONTINUE
C 
C     FORM G = B*(1/M)*B-tr
C 
      CALL MATX(SCR,1,AMAS2,1,B,0,NC,NC,NI,NC)
      CALL MATX(G,1,B,1,SCR,1,NI,NC,NC,NI)
      RETURN
      END SUBROUTINE formg
C
C***********************************************************************
C     PROJF
C***********************************************************************
C
      SUBROUTINE projf(F,DX,B,SCR,PRT,PLFT,GSTAR
     &,AMASIN,N1,N2)
C
C     CALLED BY:
C              ICFDIAG
C     CALLS:
C          MATX
C
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      DIMENSION F(N1,N1),DX(N1),SCR(N2,N2),PRT(N1,N1)
      DIMENSION B(N1,N2),GSTAR(N1,N1),PLFT(N1,N1)
      DIMENSION AMASIN(N2,N2),sum(1)
      DATA ONE/1.0D00/,ZERO/0.0D00/
C
      NI = N1
      NC = N2
C
C     THE FORCE CONSTANT MATRIX IS A TENSOR OF DOUBLY COVARIANT
C     RANK.  THE GRADIENT IS A FIRST ORDER COVARIANT TENSOR.
C 
C            
C     A DOT PRODUCT LIKE V-tr*V MUST BE BETWEEN ONE CONTRAVARIENT
C     AND ONE COVARIENT TENSOR.  THE METRIC IS USED TO RAISE THE
C     NECESSARY INDECES.
C
C     FORM THE METRIC IN RECIPROCAL SPACE, I.E. THE CONTRAVARIENT
C     METRIC.  THIS METRIC TENSOR CAN RAISE ONE INDEX
C     UPON MULTIPLICATION 
C     FORM THE METRIC GSTAR = B*invmass*B-tr
C     CALL MATX(GSTAR,1,B,1,B,0,NI,NC,NI,NC)
C
C     no need to find GMAT again, it is read in
C      CALL MATX(PRT,1,AMASIN,1,B,0,NC,NC,NI,NC)
C      CALL MATX(GSTAR,1,B,1,PRT,1,NI,NC,NC,NI)
C
C     THE GRADIENT TO BE PROJECTED SHOULD BE NORMALIZED
C     FIND THENORMALIZATION CONSTANT
C
      SUM = ZERO
C
C     FORM THE PRODUCT GRAD-tr*GSTAR*GRAD
C     SUM SHOULD CONTAIN THE SQUARE OF THE NORM, OR
C     THE DOT PRODUCT
C
      CALL MATX(SCR,1,GSTAR,1,DX,1,NI,NI,NI,1)
      CALL MATX(SUM,1,DX,0,SCR,1,NI,1,NI,1 )
C
C     FORM THE OPERATOR P, BY FORMING THE V*V-tr PRODUCT
C     BOTH INDECES ARE COVARIENT HERE
C
      CALL MATX(SCR,1,DX,1,DX,0,NI,1,NI,1)
C
C     FORM THE RIGHT SIDE PROJECTOR BY RAISING  THE FIRST
C     INDEX WITH GSTAR.  INDEX 1 IS THEN CONTRAVARIENT
C
      CALL MATX(PRT,1,GSTAR,1,SCR,1,NI,NI,NI,NI)
C
C     FORM THE LEFT SIDE PROJECTOR BY RAISING THE SECOND
C    INDEX WITH GSTAR.  INDEX 2 IS THEN CONTRAVARIENT
C
      CALL MATX(PLFT,1,SCR,1,GSTAR,1,NI,NI,NI,NI)
C
C     ALTERNATIVELY, PLFT SHOULD BE TRANSPOSE OF PRT
C
C     NORMALIZE THE PRODUCT ABOVE AND SUBTRACT FROM
C     UNIT MATRIX TO FORM THE COMPLEMENT OF PROJECTION OPERATOR
C
      DO 30 J = 1,NI
      DO 20 I = 1,NI
	 PRT(I,J) = -PRT(I,J)/SUM(1)     
	 PLFT(I,J) =-PLFT(I,J)/SUM(1)
   20 CONTINUE
   30 CONTINUE
      DO 40 I = 1,NI
	 PRT (I,I) = ONE + PRT (I,I)
	 PLFT(I,I) = ONE + PLFT(I,I)
   40 CONTINUE
C
C     PRE AND POST MULTIPLY F BY P      
C     F IS DOUBLY COVARIANT.  PRT and PLFT are  A 2D RANK MIXED TENSOR.
C     CONTRACTION RESULTS IN A RESULT THAT IS DOUBLE COVARIENT.
C
      CALL MATX(SCR,1,PLFT,1,F,1,NI,NI,NI,NI)
      CALL MATX(F,1,SCR,1,PRT,1,NI,NI,NI,NI)
C
      RETURN
      END SUBROUTINE projf


C
C***********************************************************************
C     FORMF
C***********************************************************************
C
      SUBROUTINE formf(FC,FINT,A,BTEN,DXINT,NC,NINT,SCR,SCR2)
C
C     CALLED BY:
C              ICFDIAG
C     CALLS:
C          MATX
C


	IMPLICIT DOUBLE PRECISION (A-H,O-Z)
	DIMENSION FC(NC,NC),FINT(NINT,NINT),A(NC,NINT)
     *,BTEN(NC,NC,NINT),DXINT(NINT),SCR(NINT,NINT,NINT),SCR2(1)
       DATA ZERO /0.0D00/, ONE /1.0D00/

C
C      FORM THE PRODUCT A-tr*FC*A AND PLACE IN FINT
C
      CALL MATX (SCR2,1,FC,1,A,1,NC,NC,NC,NINT)
      CALL MATX (FINT,1,A,0,SCR2,1,NC,NINT,NC,NINT)
C
C     FOR EACH INTERNAL COORDINATE FORM THE PRODUCT A-tr*(BTEN)*A
C     MULTIPLY BY THE CORRESPONDING ELEMENT OF THE GRADIENT AND SUBTRACT
C     FROM THE PARTIALLY FORMED FINT MATRIX
C
      DO 100 K = 1,NINT
	 CALL MATX (SCR2,1,BTEN(1,1,K),1,A,1,NC,NC,NC,NINT)
	 CALL MATX (SCR(1,1,K),1,A,0,SCR2,1,NC,NINT,NC,NINT)
C
C    IF DX IS CALCULATED AS THE NEGATIVE GRADIENT, CHANGE THE
C    SIGN BEFORE USING HERE.
C
         GRAD = DXINT(K)
	 DO 90 J = 1,NINT
	    DO 80 I = 1,NINT
	       FINT(I,J) = FINT(I,J) - GRAD*SCR(I,J,K)
   80       CONTINUE
   90    CONTINUE
  100 CONTINUE
      RETURN
      END SUBROUTINE formf
C
C***********************************************************************
C     FORMA
C***********************************************************************
C
      SUBROUTINE forma (A,B,SCR2,SCR,AMASS,REDM,U,NINT,NC)
C
C     FORMA FORMS THE INVERSE MATRIX IN AU IN THE U REGION
C     IT THEN FORMS THE GENERALIZED INVERSE OF THE B MATRIX
C     BY THE PULAY PRESCRIPTION AND PLACES IT IN THE A REGION
C     A = (U)(B-tr)(B*U*B-tr)**(-1)
C
C     CALLED BY:
C              ICFDIAG
C     CALLS:
C          MATX,LIN
C
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      DIMENSION A(NC,NINT),B(NINT,NC),U(NC,NC),SCR(NC,NC)
      DIMENSION AMASS(NC),SCR2(NC,NC)
      DATA ZERO /0.0D00/,ONE/1.0D00/
C
C  FORM AN NC BY NC UNIT MATRIX IN U     
C
      DO 20 I = 1, NC  
      DO 10 J = 1,NC
         U(J,I) = ZERO
   10 CONTINUE
   20 CONTINUE
C
      DO 25 I = 1,NC
         U(I,I) = ONE/(REDM*AMASS(I)*AMASS(I))
   25 CONTINUE
C
C     FORM THE PRODUCT B*u*B-tr
C
      CALL MATX(SCR,1,U,1,B,0,NC,NC,NINT,NC)
C
C     STORE B*u*B-tr IN A
C
      CALL MATX(A,1,B,1,SCR,1,NINT,NC,NC,NINT)
C
C     GET INVERSE OF b*u*b-tr IN SCR
C
      CALL LIN(A,SCR,SCR,SCR2,DET,1,NINT,NINT,0,NINT)
C
C     FORM PRODUCT U*Btr*(SCR) in A
C
      CALL MATX(SCR2,1,B,0,SCR,1,NINT,NC,NINT,NINT)
      CALL MATX(A,1,U,1,SCR2,1,NC,NC,NC,NINT)
C
C     MATRIX A IS THE GENERALIZED INVERSE OF B
C
      RETURN
      END SUBROUTINE forma
C
C***********************************************************************
C     BTENTR
C***********************************************************************
C
      SUBROUTINE btentr(B,BX,BTRANS,SCR,NC,NDC,NINT)
C
C     CALLED BY:
C              ICFDIAG
C
C     CALLS:
C          MATX
C
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      DIMENSION B(NC,NC,NINT),BX(NDC,NDC,NINT)
      DIMENSION BTRANS(NDC,NC),SCR(NDC,NC)
C
C     LOOP OVER THE SET OF INTERNAL COORDINATES,EACH OF
C     WHICH HAS BTENSOR TO TRANSFORM
C     POST MULTIPLY BY BT AND PREMULTIPLY BY BT-TRANSPOSE
C
      DO 50 N = 1,NINT
	CALL MATX(SCR,1,BX(1,1,N),1,BTRANS,1,NDC,NDC,NDC,NC)
	CALL MATX(B(1,1,N),1,BTRANS,0,SCR,1,NDC,NC,NDC,NC)
   50 CONTINUE
      RETURN
      END SUBROUTINE btentr
C
C***********************************************************************
C     BTEN5
C***********************************************************************
C
      SUBROUTINE bten5(BTENS,NINT,NDIF,R,INDDX1,INDDX2,INDINX)
C
C     DEFINES THE 2D DERIVATIVE BTENSOR ELEMENTS FOR THE
C     DEGENERATE LINEAR BEND IN TERMS OF THE DIFFERENCE CARTESIAN
C     VECTORS THAT DEFINE ITS BONDS.
C
C     CALLED BY:
C              ICFDIAG
C
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      DIMENSION BTENS(3*NDIF,3*NDIF,NINT),R(NDIF)
      DATA ZERO/0.0D00/, ONE/1.0D00/
C
      NDC = 3*NDIF
      INDDC1 = INDDX1
      INDDC2 = INDDX2
      INDINT = INDINX
C
C     ZERO OUT THE BTENSOR ELEMENT (MATRIX)
C
      DO 30 I = 1,NDC
	DO 30 J = 1,NDC
		BTENS(J,I,INDINT) = ZERO
		BTENS(J,I,INDINT+1) = ZERO
   30 CONTINUE
C
C     ONLY NON ZERO ARE OFF DIAGONAL WITHIN SAME DIFFERENCE CARTESIAN
C     WITH ONE COMPONENT ALONG MOLECULAR AXIS (Z-AXIS)
C     AND WITHA THE OTHER OPPOSITE OF THE X OR Y LABEL ON THE ANGLE ITSELF
C     I.E. FOR PHI(X), THERE ARE ONLY YZ, and yz, DERIVATIVES
C
      DO 60 K = 1,2
         IF (K.EQ.1) THEN
	    INDDC = INDDC1
	    ANUM = -ONE/(R(INDDC)*R(INDDC))
         ELSE
	    INDDC = INDDC2        
	    ANUM = ONE/(R(INDDC)*R(INDDC))
         ENDIF
         INDC = (INDDC-1)*3
         BTENS(INDC+2,INDC+3,INDINT) = ANUM
         BTENS(INDC+3,INDC+2,INDINT) = ANUM
         BTENS(INDC+1,INDC+3,INDINT+1) = ANUM
         BTENS(INDC+3,INDC+1,INDINT+1) = ANUM
   60 CONTINUE
      RETURN
      END SUBROUTINE bten5
C
C***********************************************************************
C      BTEN5X
C***********************************************************************
C
       SUBROUTINE bten5x(BTENS,NINT,NDIF,R,T,INDDX1,INDDX2,INDINX)
C
C      DEFINES THE 2D DERIVATIVE BTENSOR ELEMENTS FOR THE
C      DEGENERATE LINEAR BEND IN TERMS OF THE DIFFERENCE CARTESIAN
C      VECTORS THAT DEFINE ITS BONDS.
C
C      CALLED BY:
C               ICFDIAG
C
       IMPLICIT DOUBLE PRECISION (A-H,O-Z)
C
       DIMENSION BTENS(3*NDIF,3*NDIF,NINT),R(NDIF)
       DIMENSION T(3,3)
       DATA ZERO/0.0D00/, ONE/1.0D00/
C
C     DERIVATIVES HAVE SAME VALUES FOR NEGATIVE BOND VECTORS
C     AS FOR PROPERLY DIRECTED ONES.  CHANGE BACK TO POSITIVE.
C
      NDC = 3*NDIF
      INDDC1 = IABS(INDDX1)
      INDDC2 = IABS(INDDX2)
      INDINT = INDINX
C
C      ZERO OUT THE BTENSOR ELEMENT (MATRIX)
C
      DO 30 I = 1,NDC
	DO 30 J = 1,NDC
		BTENS(J,I,INDINT) = ZERO
		BTENS(J,I,INDINT+1) = ZERO
   30 CONTINUE
C
C     ONLY NON ZERO ARE OFF DIAGONAL WITHIN SAME DIFFERENCE CARTESIAN
C     WITH ONE COMPONENT ALONG MOLECULAR AXIS (Z-AXIS)
C     AND WITHA THE OTHER OPPOSITE OF THE X OR Y LABEL ON THE ANGLE ITSELF
C     I.E. FOR PHI(X), THERE ARE ONLY YZ, and yz, DERIVATIVES
C     THE TENSOR ELEMENTS ARE COMPUTED ORIGINALLY IN THE PRIMED (NEW)
C     COORDINATE SYSTEM, WITH Z ALIGNED ALONG THE MOLECULAR AXIS.
C     THE TENSOR IS THEN TRANSFORMED WITH T MATRIX TO THE ORIGINAL SYSTEM.
C     IN THE PRIMED SYSTEM EACH LAYER OF THE TENSOR HAS ONLY 4 NONZERO
C     ELEMENTS.  THE COMPUTATION AND TRANSFORMATION ARE COMBINED BELOW
C     K IS LOOPING OVER THE TWO DIFFERENCE CARTESIANS
C
      DO 60 K = 1,2
         IF (K.EQ.1) THEN
	    INDDC = INDDC1
	    ANUM = -ONE/(R(INDDC)*R(INDDC))
         ELSE
	    INDDC = INDDC2        
	    ANUM = ONE/(R(INDDC)*R(INDDC))
         ENDIF
      INDC = (INDDC-1)*3
         DO 55 I = 1,3
	    DO 50 J=1,3
               BTENS(INDC+J,INDC+I,INDINT) = 
     &                        ANUM*(T(I,2)*T(J,3)+T(I,3)*T(J,2))
               BTENS(INDC+J,INDC+I,INDINT+1) =
     &                         ANUM*(T(I,1)*T(J,3)+T(I,3)*T(J,1))
   50       CONTINUE
   55    CONTINUE
   60 CONTINUE
      RETURN
      END SUBROUTINE bten5x
C
C***********************************************************************
C     BTEN1
C***********************************************************************
C
      SUBROUTINE bten1(BTENS,BMAT,NINT,NDIF,R,INDDCX,INDINX)
C
C     FORMS THE BTENSOR 2D DERIVATIVE ELEMENTS FOR
C     A BOND LENGTH INTERNAL COORDINATE IN TERMS OF ITS
C     FIRST DERIVATIVES (BMAT) AND MAGNITUDES OF DIFF CARTESIANS.
C
C     CALLED BY:
C              ICFDIAG
C
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      DIMENSION BTENS(3*NDIF,3*NDIF,NINT),bMAT(NINT,3*NDIF)
      DIMENSION R(NDIF)   
      DATA ZERO/0.0D00/, ONE/1.0D00/
C
      INDDC = INDDCX
      INDINT = INDINX
      NDC = 3*NDIF
      INDC = (INDDC -1)*3
C
C     ZERO OUT THE BTENSOR ELEMENT (MATRIX)
C
      DO 30 I = 1,NDC
      DO 30 J = 1,NDC
         BTENS(J,I,INDINT) = ZERO
   30 CONTINUE
C
C     DIAGONAL ELEMENTS
C
      DO 50 I = 1,3
	 BTENS(INDC+I,INDC+I,INDINT) =
     &   (ONE - BMAT(INDINT,INDC+I)**2)/R(INDDC)
	 IF (I.GT.1) THEN
	    DO 40 J = 1, I-1
	       BTENS(INDC+J,INDC+I,INDINT) = -BMAT(INDINT,INDC+J)
     &         *BMAT(INDINT,INDC+I)/R(INDDC)
	       BTENS(INDC+I,INDC+J,INDINT) = BTENS(INDC+J,INDC+I,INDINT)
   40       CONTINUE
	 ENDIF
   50 CONTINUE
      RETURN 
      END SUBROUTINE bten1
C
C***********************************************************************
C     VECMAG
C***********************************************************************
C
      SUBROUTINE vecmag(X,N3,N,R)
C
C     OBTAINS THE MAGNITUDES OF A SET OF VECTORS
C
C     CALLED BY:
C              CENTRAL,ICFDIAG
C
      IMPLICIT DOUBLE PRECISION(A-H,O-Z)
      DIMENSION X(N3),R(N)
      DATA ZERO/0.0D00/
C
      INDX = 0
      IEND = N
      DO 30 I = 1,IEND
      R(I) = ZERO
      DO 20 J =1,3
      R(I) = R(I) + X(INDX+J)*X(INDX+J)
   20 CONTINUE
       R(I) = dsqrt(R(I))
       INDX = INDX + 3
   30 CONTINUE
      RETURN
      END SUBROUTINE vecmag
C
C***********************************************************************
C     BMAT5X
C***********************************************************************
C
      SUBROUTINE bmat5x(B,NROW,NCOL,X,R,T,INDDX1,INDDX2,INDINT)
C
C     BMAT5 FORMS THE BMATRIX ROWS CORRESPONDING TO DEGENERATE
C     LINEAR BENDS.  THE INPUT IS IN THE TWO DIFFERENCE CARTESIANS
C     DEFINING THE LINEAR TRIATOMC.  THE DEFINITIONS OF THE BENDS
C     ARE THOSE OF HOY ET AL AND DIFFER IN SIGN FROM THOSE OF
C     SUZUKI 
C     THIS VERSION OF THE SUBROUTINE IS GENERAL AND FIRST DETERMINES
C     A TRANSFORMATION MATRIX TO ROTATE THE COORDINATE SYSTEM SUCH
C     THAT THE MOLECULE LIES ALONG THE Z AXIS.
C
C     CALLED BY:
C              ICFDIAG
C
C     CALLS:
C          XPROD
C
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      DIMENSION B(NROW,NCOL),X(NCOL),R(NCOL),T(3,3)
      DIMENSION PX(3),PY(3),PZ(3),V(3)
      DATA ZERO/0.0D00/,ONE/1.0D00/ 
C
C     DERIVATIVES HAVE SAME VALUES FOR NEGATIVE BOND VECTORS
C     AS FOR PROPERLY DIRECTED ONES.  CHANGE BACK TO POSITIVE.
C
      INDDC1 = IABS(INDDX1)
      INDDC2 = IABS(INDDX2)
C
C     THE NONZERO ELEMENTS ARE GIVEN BY 1/Z ior 1/z  
C     OF THE STRETCH COORDINATE.
C
      INDC1 = (INDDC1 -1 )*3
      INDC2 = (INDDC2 -1 )*3
C
C     ZERO OUT THE CORRECT ROWS OF B MATRIX
C
       J=INDINT
       IEND = NCOL
       DO 10 I = 1,IEND
          B(J,I) = ZERO
          B(J+1,I) = ZERO
   10  CONTINUE
C
C      SET UP A RIGHT HANDED COORDINATE SYSTEM.  THE Z AXIS COINCIDES
C      WITH THE FIRST DIFFERENCE CARTESIAN VECTOR
C      SET UP AN AUXILLIARY VECTOR V TO USE IN GENERATING PX AND PY
C
      DO 20 I = 1,3
	 PZ(I) = X(INDC1 + I)
	 V(I)  = ONE
   20 CONTINUE
C
C      FIND UY PERPENDICULAR TO PZ AND TO V
C
      CALL XPROD (V,PZ,PY)
C
C     FIND PX PERPENDICULAR TO PY AND PZ
C
      CALL XPROD (PY,PZ,PX)
C
C     NORMALIZE THE THREE UNIT VECTORS
C
      PXMG = ZERO
      PYMG = ZERO
      DO 30 I = 1,3
         PXMG = PXMG + PX(I)*PX(I)
         PYMG = PYMG + PY(I)*PY(I)
   30 CONTINUE
      PXMG = dsqrt(PXMG)
      PYMG = dsqrt(PYMG)
      PZMG = R(INDDC1) 
C
C    FILL THE TRANSFORMATION MATRIX WITH THE DIRECTION COSINES OF
C    THE NEW (PRIMED) COORDINATE SYSTEM (PX,PY,PZ).
C
      DO 40 I = 1,3
	 T(I,1) = PX(I)/PXMG
	 T(I,2) = PY(I)/PYMG
	 T(I,3) = PZ(I)/PZMG
   40 CONTINUE
C
C     TRANSFORM THE TWO DIFFERENCE CARTESIANS TO THE NEW (PRIMED)
C     SYSTEM.  IN THE PRIMED SYSTEM, THE ONLY NONZERO COORDINATES
C     ARE IN THE PZ-DIRECTION.
C
      Z1 = ZERO
      Z2 = ZERO
      DO 50 I = 1,3
	 Z1 = Z1 + T(I,3)*X(INDC1 + I)
	 Z2 = Z2 + T(I,3)*X(INDC2 + I)
   50 CONTINUE
C
C     IN THE PRIMED (NEW) SYSTEM, THE BMATRIX HAS AS USUAL JUST TWO
C     NONZERO ELEMENTS PER ROW, FORMED BY RECIPROCALS OF Z1 AND Z1.
C     THIS IS THEN TRANSFORMED BACK INTO THE ORIGINAL UNPRIMED FRAME
C     THESE OPERATIONS ARE COMBINED BELOW
C
C     J-TH INTERNAL COORDINATE IS THE ONE LABELLED AS (-X) BY HOY
C     THE J+1-TH COORDINATE IS LABELLED AS (Y) IN HOY
C
      DO 60 I = 1,3
         B(J,INDC1+I) = T(I,2)/Z1
         B(J,INDC2+I) = -T(I,2)/Z2
         B(J+1,INDC1+I) = T(I,1)/Z1
         B(J+1,INDC2+I) = -T(I,1)/Z2
   60 CONTINUE
      RETURN
      END SUBROUTINE bmat5x
C
C***********************************************************************
C     BMAT5
C***********************************************************************
C
      SUBROUTINE bmat5(B,NROW,NCOL,X,R,INDDC1,INDDC2,INDINT)
C
C     BMAT5 FORMS THE BMATRIX ROWS CORRESPONDING TO DEGENERATE
C     LINEAR BENDS.  THE INPUT IS IN THE TWO DIFFERENCE CARTESIANS
C     DEFINING THE LINEAR TRIATOMC.  THE DEFINITIONS OF THE BENDS
C     ARE THOSE OF HOY ET AL AND DIFFER IN SIGN FROM THOSE OF
C     SUZUKI 
C
C     CALLED BY:
C              ICFDIAG
C
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      DIMENSION B(NROW,NCOL),X(NCOL),R(NCOL)
      DATA ZERO/0.0D00/,ONE/1.0D00/ 
C
C    THE NONZERO ELEMENTS ARE GIVEN BY 1/Z ior 1/z  
C    OF THE STRETCH COORDINATE.
C
      INDC1 = (INDDC1 -1 )*3
      INDC2 = (INDDC2 -1 )*3
C
C     ZERO OUT THE CORRECT ROWS OF B MATRIX
C
      J=INDINT
      IEND = NCOL
      DO 10 I = 1,IEND
          B(J,I) = ZERO
          B(J+1,I) = ZERO
   10 CONTINUE
C
C     J-TH INTERNAL COORDINATE IS THE ONE LABELLED AS (-X) BY HOY
C     THE J+1-TH COORDINATE IS LABELLED AS (Y) IN HOY
C
      B(J,INDC1+2) = ONE/X(INDC1+3)
      B(J,INDC2+2) = -ONE/X(INDC2+3)
      B(J+1,INDC1+1) = ONE/X(INDC1+3)
      B(J+1,INDC2+1) = -ONE/X(INDC2+3)
      RETURN
      END SUBROUTINE bmat5
C
C***********************************************************************
C     BMAT1
C***********************************************************************
C
      SUBROUTINE bmat1(B,NROW,NCOL,X,R,INDDC,INDINT)
C
C   BMAT1 FORMS THE BMATRIX ROW CORRESPONDING TO A LINEAR STRETCH
C   COORDINATE BETWEEN ATOM J AND ATOM I.  THE INPUT IS IN THE
C   FORM OF DIFFERENCE CARTESIANS.
C
C     CALLED BY:
C              ICFDIAG
C
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      DIMENSION B(NROW,NCOL),X(NCOL),R(NCOL)
      DATA ZERO/0.0D00/
C
C THE NONZERO ELEMENT IS GIVEN BY X/R,Y/R,Z/R, WHERE R IS MAGNITUDE.
C  OF THE STRETCH COORDINATE.
C
      INDC = (INDDC -1 )*3
C
C ZERO OUT THE CORRECT ROW OF B MATRIX
C
       J=INDINT
       IEND = NCOL
       DO 10 I = 1,IEND
          B(J,I) = ZERO
   10  CONTINUE
       DO 30 I = 1,3
          B(J,INDC+I) = X(INDC+I)/R(INDDC)
   30 CONTINUE
      RETURN
      END SUBROUTINE bmat1
C
C***********************************************************************
C     FORMBT
C***********************************************************************
C
      SUBROUTINE formbt(BT,NDCART,NCART,INDI,INDJ,IND)
C
C  THIS SUBROUTINE FORMS ONE XYZ-BAND OF THE TRANSFORMATION MATRIX FROM 
C  CARTESIAN COORDINATES TO DIFFERENCE CARTESIANS
C  THE COORDINATE IS DEFINED AS RJ - RI  
C  INDI POINTS TO RI, INDJ TO RJ, AND IND TO THE DIFF CARTESIAN
C
C     CALLED BY:
C              ICFDIAG
C
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      DIMENSION BT(NDCART,NCART)
      DATA ZERO/0.0D0/, ONE/1.0D0/
      SAVE ZERO,ONE
C
      INI = (INDI-1)*3
      INJ = (INDJ-1)*3
      IN = (IND-1)*3
      DO 10 I = 1,3     
         DO  5 J = 1,NCART
            BT(IN+I,J) = ZERO  
    5    CONTINUE
   10 CONTINUE
C
      DO 30 I = 1,3
	 BT(IN +I,INJ+I) = ONE   
	 BT(IN +I,INI+I) = -ONE    
   30 CONTINUE
      RETURN
      END SUBROUTINE formbt
C
C***********************************************************************
C     DPR123
C***********************************************************************
C
      SUBROUTINE dpr123(IND1,IND2,IND3,X,NLEN,DPROD)
C
C  DPR123 COMPUTES THE DOT PRODUCT BETWEEN TWO VECTORS .
C  FIRST VECTOR POINTS FROM ATOM 2 TO ATOM 1
C  SECOND VECTOR POINTS FROM ATOM 2 TO ATOM 3
C
C     CALLED BY:
C              CENTR1,CENTRAL
C
C     CALLS:
C          DOTPRD 
C
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      DIMENSION X(NLEN), R1(3),R2(3)
C
      LENV = 3
      IN1=(IND1-1)*LENV
      IN2=(IND2-1)*LENV
      IN3=(IND3-1)*LENV
      DO 20 I = 1,LENV
         R1(I) = X(IN1+I) - X(IN2+I)
         R2(I) = X(IN3+I) - X(IN2+I)
   20 CONTINUE
      CALL DOTPRD(R1,R2,DPROD,LENV)
      RETURN
      END SUBROUTINE dpr123
C
C***********************************************************************
C     DOTPRD
C***********************************************************************
C
      SUBROUTINE dotprd(X,Y,PROD,N)
C
C  SUBROUTINE DOTPRD COMPUTES THE DOT PRODUCT
C  BETWEEN TWO VECTORS OF DIMENSION N
C
C     CALLED BY:
C              ANGLCS,DPR123,ICFDIAG,VECCON
C
      IMPLICIT DOUBLE PRECISION(A-H,O-Z)
      DIMENSION X(N),Y(N) 
C
      PROD = 0.0D00
      DO 10 I = 1,N
         PROD = PROD + X(I)*Y(I)
   10 CONTINUE
      RETURN
      END SUBROUTINE dotprd
C
C***********************************************************************
C     XPROD
C***********************************************************************
C
      SUBROUTINE xprod(X,Y,Z)
C
C  FORMS THE CROSS PRODUCT OF VECTORS X AND Y, PLACING THE RESULT
C  IN VECTOR Z.  ALL VECTORS ARE THREE DIMENSIONAL.
C
C     CALLED BY:
C              BMAT5X
C
      IMPLICIT DOUBLE PRECISION(A-H,O-Z)
      DIMENSION X(3),Y(3),Z(3)
      Z(1) = X(2)*Y(3) - X(3)*Y(2)
      Z(2) = X(3)*Y(1) - X(1)*Y(3)
      Z(3) = X(1)*Y(2) - X(2)*Y(1)
      RETURN
      END SUBROUTINE xprod
C
C***********************************************************************
C     TRANSF
C***********************************************************************
C
      SUBROUTINE transf (IOP,N3,AMASS,F)
      use perconparam
C
C     CONVERTS CARTESIAN TO MASS-WEIGHTED COORDINATES (IOP=1)
C     OR MASS-WEIGHTED TO CARTESIAN COORDINATES (IOP=2)
C
C     CALLED BY:
C              ICFDIAG
C
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
C
      DIMENSION F(N3,N3),AMASS(N3TM)
C
      DO 20 J=1, N3
      DO 10 I = 1, J 
         IF (IOP.EQ.2) THEN
            F(I,J) = F(I,J)*AMASS(I)*AMASS(J)
         ELSE
            F(I,J) = F(I,J)/(AMASS(I)*AMASS(J))
         ENDIF
	 F(J,I) = F(I,J) 
   10 CONTINUE
   20 CONTINUE
      RETURN
      END SUBROUTINE transf
C
C***********************************************************************
C     ABSORD
C***********************************************************************
C
      SUBROUTINE absord(C,D,N,X,IA,IB,NBASIS)
C
C   ORDER THE IB LOWEST EIGENVALUES D AND EIGENVECTORS C
C   FROM A SET OF IA EIGENVECTORS OF LENGTH NBASIS
C   N AND X ARE SCRATCH REGIONS OF LENGTH IA AND NBASIS
C   MODIFIED TO USE ABSOLUTE VALUES
C
C     CALLED BY:
C              GFDIAG,ICSAVE
C
C     1's changed to *'s in arrays                                       1020BE05
      IMPLICIT DOUBLE PRECISION(A-H,O-Z)
      DIMENSION C(*),D(*),N(*),X(*)                                      1020BE05
C
      NA=NBASIS
      DO 105 I=1,IA
105   N(I)=I
      IN=IA-1
      IF(IN.LE.0) GO TO 200
      DO 115 I=1,IN
      DO 110 J=1,I
      K=I-J+1
      IF(dabs(D(K+1)).GE.dabs(D(K)))GO TO 115
      X(1)=D(K)
      D(K)=D(K+1)
      D(K+1)=X(1)
      JA=N(K)
      N(K)=N(K+1)
      N(K+1)=JA
110   CONTINUE
115   CONTINUE
      IF(IB+1.GE.IA) GO TO 126
      IC=IB+1
      DO 125 I=IC,IN
      DO 120 J=IC,I
      K=I-J+IC
      IF(N(K+1).GE.N(K)) GO TO 125
      X(1)=D(K)
      D(K)=D(K+1)
      D(K+1)=X(1)
      JA=N(K)
      N(K)=N(K+1)
      N(K+1)=JA
120   CONTINUE
125   CONTINUE
126   CONTINUE
C          REARRANGE EIGENVECTORS
      KH=0
150   KH=KH+1
      IF(KH.GE.IA)GO TO 200
      K=N(KH)
      IF(KH.EQ.K) GO TO 150
      IF(K.EQ.0) GO TO 150
      IG=NA*K
      IH=IG
      DO 155 I=1,NA
      X(I)=C(IH)
155   IH=IH-1
130   KL=N(K)
      N(K)=0
      K=KL
      IH=NA*K
      IN=IG
      IG=IH
      DO 135 I=1,NA
      C(IN)=C(IH)
      IN=IN-1
135   IH=IH-1
      IF(K.NE.KH) GO TO 130
      DO 145 I=1,NA
      C(IG)=X(I)
145   IG=IG-1
      GO TO 150
200   RETURN
      END SUBROUTINE absord
C
C***********************************************************************
C     BMAT2
C***********************************************************************
C
      SUBROUTINE bmat2(B,NROW,NCOL,SINGX,COSGX,R,INDDX1,INDDX2,INDINT)
C
C   FORMS THE BMATRIX ROWS CORRESPONDING SPECIFICLY FOR THE BENT TRIATOMIC.
C
C     ROW R IS INDDC1, WHILE ROW r is INDDC2
C     SIN(GAMMA) IS DEFINED AS SING, AND COS(GAMMA) IS COSG
C     THE B MATRIX CONTAIN THE PARTIAL DERIVATIVES
C     THE R MATRIX CONTAIN R AND r TERMS
C     THE X MATRIX IS DEFINED BY (INTERNAL) Q=BX
C     INDC1 AND INDC2 ALLOW US TO TO PINPOINT THE COLUMN WE WANT
C     COLUMN X=INDC1+1, Y=INDC1+1, Z=INDC1+1
C     INDC1 DENOTE TERMS LIKE (XYZ), WHILE INDC2 INVOLVE (xyz)
C
C     CALLED BY:
C              ICFDIAG
C
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      DIMENSION B(NROW,NCOL),R(NCOL/3)
      DATA ZERO/0.0D00/,ONE/1.0D00/ 
C 
C THE NONZERO ELEMENTS ARE GIVEN BY 1/Z ior 1/z  
C OF THE STRETCH COORDINATE.
C
      INDDC1 = INDDX1
      INDDC2 = INDDX2
C     TEST SIGNX
       SIGNX=ONE
       IF(INDDC1 .LT. 0) THEN
          SIGNX=-SIGNX
          INDDC1=IABS(INDDC1)
       END IF
       IF(INDDC2 .LT. 0) THEN
          SIGNX=-1*SIGNX
          INDDC2=IABS(INDDC2)
       END IF
       COSG=COSGX
       SING=SINGX
      INDC1 = (INDDC1 -1 )*3
      INDC2 = (INDDC2 -1 )*3
C
C ZERO OUT THE CORRECT ROWS OF B MATRIX
C
       J=INDINT
       IEND = NCOL
       DO 10 I = 1,IEND
          B(J,I) = ZERO
 10    CONTINUE
       

C     THE FOLLOWING EQUATIONS FOR THE FIRST DERIVATIVE OF GAMMMA WITH
C     RESPECT TO THE INTERNAL COORDINATES ARE FROM "LEAST-SQUARES
C     ADJUSTMENT OF ANHARMONIC POTENTIAL CONSTANTS", BY PARISEAU ET AL,
C     PUBLISHED IN JCP, P.2337, 1 APRIL 1965
C
C J-TH INTERNAL COORDINATE IS THE ONE LABELLED AS (-X) BY HOY
C     THE J+1-TH COORDINATE IS LABELLED AS (Y) IN HOY
C
      SR1=SING*R(INDDC1)*SIGNX
      SR2=SING*R(INDDC2)*SIGNX
C
      DO 50 K=1,3
         B(J,INDC1+K)=(COSG*B(INDDC1,INDC1+K)-B(INDDC2,INDC2+K))
     &/SR1
         B(J,INDC2+K)=(COSG*B(INDDC2,INDC2+K)-B(INDDC1,INDC1+K))
     &/SR2
 50   CONTINUE
      RETURN
      END SUBROUTINE bmat2
C
C***********************************************************************
C      BTEN2 
C***********************************************************************
C
       SUBROUTINE bten2(BTENS,NINT,NDIF,B,SINGX,COSGX,R,INDDX1,INDDX2,
     &INDINT)
C
C THE BENT TRIATOMIC 2D DERIVATIVE BTENSOR ELEMENTS
C
C      CALLED BY:
C               ICFDIAG
C
       IMPLICIT DOUBLE PRECISION (A-H,O-Z)
       DIMENSION BTENS(3*NDIF,3*NDIF,NINT),R(NDIF),B(NINT,3*NDIF)
       DATA ZERO/0.0D00/, ONE/1.0D00/
C
       INDDC1 = INDDX1
       INDDC2 = INDDX2
       NDC = 3*NDIF
C     TEST SIGNX
       SIGNX=ONE
       IF(INDDC1 .LT. 0) THEN
          SIGNX=-SIGNX
          INDDC1=IABS(INDDC1)
       END IF
       IF(INDDC2 .LT. 0) THEN
          SIGNX=-1*SIGNX
          INDDC2=IABS(INDDC2)
       END IF
       COSG=COSGX
       SING=SINGX
C
C  ZERO OUT THE BTENSOR ELEMENT (MATRIX)
C
       DO 30 I = 1,NDC
          DO 30 J = 1,NDC
		BTENS(J,I,INDINT) = ZERO
 30    CONTINUE
C
C  ONLY NON ZERO ARE OFF DIAGONAL WITHIN SAME DIFFERENCE CARTESIAN
C   WITH ONE COMPONENT ALONG MOLECULAR AXIS (Z-AXIS)
C   AND WITHA THE OTHER OPPOSITE OF THE X OR Y LABEL ON THE ANGLE ITSELF
C.    I.E. FOR PHI(X), THERE ARE ONLY YZ, and yz, DERIVATIVES
C
       CONST=(1/SING)*SIGNX
       CSTMX=(1/(R(INDDC1)*R(INDDC2)))
       INC1=INDDC1
       INC2=INDDC2
      DO 40 INDEX=1,2
   	IF (INDEX .EQ. 2) THEN
   		INC1=INDDC2
   		INC2=INDDC1
   	END IF
        INDC1 = (INC1 -1 )*3
        INDC2 = (INC2 -1 )*3
C
C     THE FOLLOWING EQUATIONS FOR THE SECOND DERIVATIVE OF GAMMMA WITH
C     RESPECT TO THE INTERNAL COORDINATES ARE FROM "LEAST-SQUARES
C     ADJUSTMENT OF ANHARMONIC POTENTIAL CONSTANTS", BY PARISEAU ET AL,
C     PUBLISHED IN JCP, P.2337, 1 APRIL 1965
C
        CSTAA=(1/(R(INC1)**2))
        DO 60 L=1,3
           DO 60 M=1,3
               IF (L .EQ. M) THEN
C
C     TAKES CARE OF Aa and aA 2ND DERIVATIVE CASES
C
		   IF (INDEX .EQ. 1) THEN
                       BTENS(INDC1+L,INDC2+M,INDINT)=CONST*(CSTMX*(
     &                 B(INC1,INDC1+L)**2+B(INC2,INDC2+L)**2-
     &                 B(INC1,INDC1+L)*B(INC2,INDC2+M)*COSG-1)-COSG
     &                 *(B(INDINT,INDC1+L)*B(INDINT,INDC2+M)))
                 	
                       BTENS(INDC2+M,INDC1+L,INDINT)=BTENS(INDC1+L,
     &                 INDC2+M,INDINT)
     	           END IF
C
C     TAKES CARE OF AA and aa 2ND DERIVATIVE CASES
C
	           BTENS(INDC1+L,INDC1+M,INDINT)=CONST*(CSTAA
     &           *(2*B(INC2,INDC2+L)*B(INC1,INDC1+L)+COSG*(1-3
     &           *(B(INC1,INDC1+L)**2)))-COSG*(B(INDINT,INDC1+L)**2))

               ELSE
C
C     ALSO CONSIDE Ab and aB 2ND DERIVATIVE CASES
C     NOTE:  Ab 2nd deriv .ne. aB 2nd deriv!!!
C

                   BTENS(INDC1+L,INDC2+M,INDINT)=CONST*(CSTMX
     &           *(B(INC1,INDC1+L)*B(INC1,INDC1+M)
     &           +B(INC2,INDC2+L)*B(INC2,INDC2+M)-B(INC1,INDC1+L)
     &           *B(INC2,INDC2+M)*COSG)-COSG*(B(INDINT,INDC1+L)
     &           *B(INDINT,INDC2+M)))
C
C     TAKES CARE OF AB and ab 2ND DERIVATIVE CASES
C
                  IF(L .LT. M) THEN
                     BTENS(INDC1+L,INDC1+M,INDINT)=CONST*(CSTAA
     &           *(B(INC1,INDC1+L)*B(INC2,INDC2+M)+
     &           B(INC2,INDC2+L)*B(INC1,INDC1+M)-3*B(INC1,INDC1+L)
     &           *B(INC1,INDC1+M)*COSG)-COSG*(B(INDINT,INDC1+L)*
     &           B(INDINT,INDC1+M)))
                 
                     BTENS(INDC1+M,INDC1+L,INDINT)=BTENS(INDC1+L,INDC1+M
     &           ,INDINT)
                 END IF
               END IF
  60   CONTINUE
 40   CONTINUE
      RETURN
      END SUBROUTINE bten2
C
C***********************************************************************
C     CENTRAL  
C***********************************************************************
C
      SUBROUTINE central(SING,COSG,IND1,IND2,IND3,INDI,INDJ,INDK,X,N3TM)
C
C     DETERMINES WHICH ATOM IS THE CENTRAL ATOM FOR A BENT TRIATOMIC
C     BY USING BOND LENGTH.  ALSO CALCULATES BOND ANGLE GAMMA.     
C     NOTE:  ATOM NUMBER i IS THE CENTRAL ATOM                    
C
C     CALLED BY:
C              ICFDIAG
C     CALLS:
C          VECMAG,DPR123
C
      IMPLICIT DOUBLE PRECISION(A-H,O-Z)
      DIMENSION X(N3TM), R12(3), R23(3), R13(3), RIJ(3), RIK(3)
      dimension :: vmag12(1),VMAG23(1),VMAG13(1),VMAGIJ(1),VMAGIK(1)
      DATA ZERO/0.0D00/, ONE/1.0D00/, PI/3.141592654D00/
C
      LENV=3
      NLEN=N3TM
      IN1=(IND1-1)*LENV
      IN2=(IND2-1)*LENV    
      IN3=(IND3-1)*LENV
      DO 94 I=1, LENV
         R12(I)=X(IN2+I)-X(IN1+I)
         R23(I)=X(IN3+I)-X(IN2+I)
         R13(I)=X(IN3+I)-X(IN1+I)
 94   CONTINUE
      CALL VECMAG(R12,LENV,1,VMAG12)
      CALL VECMAG(R23,LENV,1,VMAG23)
      CALL VECMAG(R13,LENV,1,VMAG13)
      IF(VMAG13(1).GT.VMAG23(1).AND.VMAG23(1).GT.VMAG12(1)) THEN
         INDI=IND2
         INDJ=IND1
         INDK=IND3
      ELSE IF(VMAG23(1) .GT. VMAG13(1).AND. VMAG13(1).GT. VMAG12(1))THEN
         INDI=IND1
         INDJ=IND2
         INDK=IND3
      ELSE IF(VMAG12(1).GT.VMAG23(1).AND.VMAG23(1).GT.VMAG13(1)) THEN
         INDI=IND3
         INDJ=IND2
         INDK=IND1
      ELSE IF(VMAG23(1).GT.VMAG12(1).AND.VMAG12(1).GT.VMAG13(1)) THEN
         INDI=IND1
         INDJ=IND3
         INDK=IND2
      ELSE IF(VMAG13(1).GT.VMAG12(1).AND.VMAG12(1).GT.VMAG23(1)) THEN
         INDI=IND2
         INDJ=IND3
         INDK=IND1
      ELSE
         INDI=IND3
         INDJ=IND1
         INDK=IND2
      ENDIF
      LENV=3
      INI=(INDI-1)*LENV
      INJ=(INDJ-1)*LENV    
      INK=(INDK-1)*LENV
      DO 20 I=1, LENV
         RIJ(I)= X(INJ+I)-X(INI+I)
         RIK(I)= X(INK+I)-X(INI+I)
 20      CONTINUE
      CALL VECMAG(RIJ,LENV,1,VMAGIJ)
      CALL VECMAG(RIK,LENV,1,VMAGIK)
      CALL DPR123(INDJ,INDI,INDK,X,NLEN,DPS)
      COSG=DPS/(VMAGIJ(1)*VMAGIK(1))
      GAMMA=ACOS(COSG)
      SING=SIN(GAMMA)
      KAMMAN=NINT((GAMMA/PI)*180.0D+5)/1.0D+5
      IF ((KAMMAN .EQ. 180) .OR. (KAMMAN .EQ. ZERO)) THEN
         PRINT *, 'LINEAR CONFIGUR., POSS. ERROR W/ MOLECULE TYPE '
      ELSE IF(VMAGIJ(1).GT. VMAGIK(1)) THEN
C        PRINT *, 'R=VMAGIJ    AND     r=VMAGIK'
      ELSE IF(VMAGIK(1).GT. VMAGIJ(1)) THEN
C        PRINT *, 'R=VMAGIK    AND     r=VMAGIJ'
      END IF
      RETURN
      END SUBROUTINE central
C
C***********************************************************************
C     JACSCF
C***********************************************************************
C
      SUBROUTINE jacscf(A,B,C,NAA,NQQ,EPLON)
C
C          FIND ALL EIGENVALUES AND EIGENVECTORS OF A(*) BY THE
C          JACOBI METHOD.
C
C          THIS PROGRAM TREATS THE ORTHOGONAL CASE (S=1)
C      A(*) - INPUT MATRIX TO BE DIAGONALIZED. (THIS MATRIX
C             IS STORED IN LOWER TRIANGULAR FORM AND IS
C             IS DESTROYED DURING THE CALCULATION)
C      B(*) - UPON EXITING THIS ROUTINE THIS ARRAY CONTAINS THE
C             EIGENVECTORS STORED IN A RECTANGULAR COMPACT FORM
C      C(*) - UPON EXITING THIS ROUTINE THIS ARRAY CONTAINS THE
C             EIGENVALUES.
C             NAA=DIMENSION OF A
C             NQ=-1 CAUSES B TO BE CLEARED TO A UNIT MATRIX
C             NQ>0 B(*) CONTAINS AN NAA BY NQ ARRAY WHICH WILL BE
C                  MULTIPLIED BY THE EIGENVECTOR MATRIX.
C             NQ SHOULD NOT BE DIMENSIONED<NAA IF NQ>0.
C            ROUTINE.
C      EPSLON IS THE CONVERGENCE CRITERIA FOR OFF DIAGONAL ELEMENTS
C
C     CALLED BY:
C              GFDIAG,ISAVE
C
      IMPLICIT DOUBLE PRECISION(A-H,O-Z)
      DIMENSION A(*),B(*),C(*)
      DATA ZERO/0.0D0/, HALF/0.5D0/, ONE/1.0D0/, TWO/2.0D0/,
     *     THREE/3.0D0/,SCALE/0.909090909/,SC2/0.95238095/

 
       zero=0.d00; half=0.5d00; one=1.d00; two=2.d00; three=3.d00
       sc2=0.95238095d00
       scale=0.909090909d00
      !sc2=0.5d00
C
C     XMCHEP IS A MACHINE DEPENDENT PARAMETER SPECIFYING RELATIVE PREC.
C
      EPSLON=ONE
50    CONTINUE
      XMCHEP = EPSLON
      EPSLON    = EPSLON*HALF
      TEST   = ONE + EPSLON
      IF (TEST.NE.ONE) GO TO 50
      XMCHEP = (XMCHEP + XMCHEP)*10.0D0
C
      NQ=NQQ
      NA=NAA
      NAM=NA-1
C   SET B TO UNIT MATRIX IF NQ .LE. 0
      IF(NQ.GT.0) GO TO 120
         K=1
         NQ=NA
         DO 115 I=1,NA
            DO 110 J=1,NA
               IF(I.EQ.J) GO TO 100
                  B(K)=ZERO
                  GO TO 105
100            CONTINUE
               B(K)=ONE
105            CONTINUE
               K=K+1
110         CONTINUE
115      CONTINUE

C
C      --- DETERMINE INITIAL AND FINAL THRESHOLDS ---
C
120   CONTINUE
      IF(NAM)325,310,125
125   CONTINUE
      K=1
      SUM1=ZERO
      DO 155 I=2,NA
         IM=I-1
         DO 150 J=1,IM
            SUM1=SUM1+DABS(A(K))
            K=K+1
150      CONTINUE
         K=K+1
155   CONTINUE


      T=(NA*(NA-1))/2.0D0
      SUM1=SUM1/T
      K=1
      AMAX=A(1)
      AMIN=A(1)
      DO 160 J=2,NA
         K=K+J
         IF(A(K).GT.AMAX) AMAX=A(K)
         IF(A(K).LT.AMIN) AMIN=A(K)
160   CONTINUE


      T=(AMAX-AMIN)/DFLOAT(NA)+SUM1*TWO

      THRSHG=EPSLON*T

      THRESH=SUM1
      IF(THRESH.LT.THRSHG) THRESH=THRSHG



C<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<< BEGIN PROGRAM LOOP 180
180   CONTINUE
      K=1
      N=0
      JD=1
      KD=0
      DO 270 J=2,NA
         JD=JD+J
         JJ=J-1
         KD=KD+NQ
         DO 265 I=1,JJ
C
C      --- TEST FOR LARGE OFF DIAGONAL ELEMENT ---
C
            IF(dabs(A(K+I)).LE.THRESH) GO TO 265
C
C      --- COMPUTE ROTATION MATRIX ---
C
               N=N+1
               ID=I*(I+1)/2
               ALPHA=(A(JD)-A(ID))/(TWO*A(K+I))
               T=DSIGN(ONE/(dabs(ALPHA)+dsqrt(ONE+ALPHA*ALPHA)),ALPHA)
               CA=dsqrt(ONE+T*T)
               CC=ONE/CA
               S=-CC*T
C
C      --- APPLY ROTATION TO ELEMENTS I,I  I,J  J,J ---
C
               A(JD)=A(JD)+A(K+I)*T
               A(ID)=A(ID)-A(K+I)*T
               A(K+I)=ZERO
               KA=JD-J
               KB=ID-I
               KC=(I-1)*NQ
C
C      --- APPLY ROTATION TO VECTOR MATRIX ---
C
               DO 215 L=1,NQ
                  B(KD+L)=-S*B(KC+L)+CC*B(KD+L)
                  B(KC+L)=CA*B(KC+L)-T*B(KD+L)
215            CONTINUE
C
C      --- APPLY ROTATION TO REST OF OPERATOR MATRIX ---
C
               L1=I-1
               L3=J-2
               DO 220 L=1,L1
                  A(KA+L)=-S*A(KB+L)+CC*A(KA+L)
                  A(KB+L)=CA*A(KB+L)-T*A(KA+L)
220            CONTINUE
               KA=KA+1
               KB=KB+I
               DO 225 L=I,L3
                  KB=KB+L
                  A(KA+L)=-S*A(KB)+CC*A(KA+L)
                  A(KB)= CA*A(KB)-T*A(KA+L)
225            CONTINUE
               KA=KA+J-1
               KB=KB+J-1
               DO 230 L=J,NAM
                  KA=KA+L
                  KB=KB+L
                  A(KA)=-S*A(KB)+CC*A(KA)
                  A(KB)=CA*A(KB)-T*A(KA)
230            CONTINUE
265      CONTINUE

         K=K+J
270   CONTINUE
      
C
C      --- TEST FOR CONVERGENCE (THRESH=THRSHG AND N=0) ---
C
      IF(THRESH.EQ.THRSHG) GO TO 285
         THRESH=THRESH*SCALE
         SCALE=SCALE*SC2
         IF(THRESH.GT.THRSHG) GO TO 290
         THRESH=THRSHG
         GO TO 290
  285 IF(N.EQ.0) GO TO 310
  290  CONTINUE
      GO TO 180
C>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>> END PROGRAM LOOP 180
310   CONTINUE
      LL=0
      DO 320 L=1,NA
         LL=LL+L
         C(L)=A(LL)
320   CONTINUE
325   CONTINUE
      RETURN
      END SUBROUTINE jacscf
C
C***********************************************************************
C     MATX
C***********************************************************************
C
      SUBROUTINE matx(A,IA,B,IB,C,IC,NRB,NCB,NRC,NCC)
C
C          GENERAL PURPOSE MATRIX MULTIPLICATION
C
C     A = B * C
C
C  ON INPUT:
C  --------
C        B(C)  INPUT REGION(S)
C        IB(IC)  INDICATOR FOR REGION B(C)
C             (+1) - B(C) IS FULL RECTANGULAR ARRAY
C             ( 0) - TRANSPOSE OF B(C) WILL BE USED
C             (-1) - B(C) IS SYMMETRIC UPPER TRIANGULAR ARRAY WITH
C                       NRB ROWS AND COLUMNS
C             (-2) - B(C) IS UPPER TRIANGULAR ARRAY WITH ZERO LOWER HALF
C             (-3) - B(C) IS UPPER TRIANGULAR ARRAY WITH ZERO LOWER HALF
C                       *AND* THE TRANSPOSE OF B(C) WILL BE USED
C        NRB(NRC) - NUMBER OF ROWS OF ARRAYB(C)
C        NCB(NCC) - NUMBER OF COLUMNS OF ARRAY B(C)
C
C  ON OUTPUT:
C  ---------
C        OUTPUT REGION
C        IA  INDICATOR FOR REGIONA
C             (+1) - FULL RECTANGULAR REGION PRODUCED IN A
C             ( 0) - TRANSPOSE OF A IS STORED IN A
C             (-1) - ONLY UPPER TRIANGULAR PART OF A IS STORED IN A
C     IF REQUIRED PRODUCT DOES NOT EXIST, PRINT ERROR AND STOP.
C
C     CALLED BY:
C              BENTR,FORMA,FORMF,FORMG,GFDIAG,ICFDIAG,ICSAVE,PROJF,
C              VECCON
C
      IMPLICIT DOUBLE PRECISION(A-H,O-Z)
      DIMENSION A(*),B(*),C(*)
      DATA ZERO/0.0D0/
C
C     TRANSFER PARAMETERS TO INTERNAL STORAGE
C
      INA=IA
      INB=IB
      INC=IC
      NRBA=NRB
      NCBA=NCB
      NRCA=NRC
      NCCA=NCC
C     SET UP ROW, COLUMN, AND SUM DIMENSIONS
      IF(INB)100,105,110
  100 NROW=NRBA
      NSUM=NRBA
      GO TO 115
  105 NROW=NCBA
      NSUM=NRBA
      GO TO 115
  110 NROW=NRBA
      NSUM=NCBA
  115 IF(INC)120,125,130
  120 NCOL=NRCA
      NSUMC=NRCA
      GO TO 135
  125 NCOL=NRCA
      NSUMC=NCCA
      GO TO 135
  130 NCOL=NCCA
      NSUMC=NRCA
C     CHECK CONSISTENCY OF DIMENSIONS
  135 IF(NSUM-NSUMC) 315,140,315
  140 IF(INA) 145,150,150
  145 IF(NROW-NCOL) 315,150,315
C     INITIATE A(K)=A(J,I) ( OR A(I,J) IF IA=0)
  150 K=1
      I=1
  155 J=1
  160 A(K)=ZERO
      DO 245 L=1,NSUM
C     LOCATE B(J,L) OR B(L,J)
      IF(INB)165,190,195
  165 IF (J-L) 180,185,170
  170 IF (INB+2) 175,245,175
  175 LB=L+(J*(J-1))/2
      GO TO 200
  180 IF (INB+3) 185,245,185
  185 LB=J+(L*(L-1))/2
      GO TO 200
  190 LB=L+(J-1)*NRBA
      GO TO 200
  195 LB=J+(L-1)*NRBA
C     LOCATE C(L,I) OR C(I,L)
  200 IF(INC)205,230,235
  205 IF (I-L) 210,220,215
  210 IF (INC+2) 225,245,225
  215 IF (INC+3) 220,245,220
  220 LC=L+(I*(I-1))/2
      GO TO 240
  225 LC=I+(L*(L-1))/2
      GO TO 240
  230 LC=I+(L-1)*NRCA
      GO TO 240
  235 LC=L+(I-1)*NRCA
240   A(K)=(A(K)+(B(LB)*C(LC)))
  245 CONTINUE
C     LOOP ON I,J
      K=K+1
      IF(INA)250,270,290
  250 IF(J-I)255,260,255
  255 J=J+1
      GO TO 160
  260 IF(I-NCOL)265,310,265
  265 I=I+1
      GO TO 155
  270 IF(I-NCOL)275,280,275
  275 I=I+1
      GO TO 160
  280 IF(J-NROW)285,310,285
  285 J=J+1
      I=1
      GO TO 160
  290 IF(J-NROW)295,300,295
  295 J=J+1
      GO TO 160
  300 IF(I-NCOL)305,310,305
  305 I=I+1
      GO TO 155
  310 RETURN
C
C      --- ERROR HALT ---
C
315   CONTINUE
      WRITE(6,901)
901   FORMAT(1X,'ERROR IN MATRIX MULTIPLY SUBROUTINE DIMENSIONS')
      STOP
      END SUBROUTINE matx
C
C***********************************************************************
C     LIN
C***********************************************************************
C
      SUBROUTINE lin(S,B,Y,T,DET,IND,NS,NRB,NCB,NRY)
C
C            SOLVE A SET OF SIMULTANEOUS LINEAR EQUATIONS
C
C                S * Y = B  (SOLVE FOR Y)
C
C            AND EVALUATE THE DETERMINANT OF S.
C
C    QUANTUM CHEMISTRY GROUP - THE UNIVERSITY OF WASHINGTON - SEATTLE
C
C      THE INVERSE OF S(*) WILL BE FOUND IF NCB=0 ON INPUT.
C      ONLY THE DETERMINANT OF S(*) WILL BE FOUND IF NCB=-1 ON INPUT.
C
C   ON INPUT:
C   --------
C        S(*) - ARRAY CONTAINING THE ELEMENTS OF LEFT HAND ARRAY
C        B(*) - ARRAY OF DIMENSION NRB ROWS BY NCB COLUMNS
C               (WHERE NRB IS >= NS)
C        IND  = 0 IF S IS A SYMMETRIC UPPER TRIANGULAR ARRAY.
C             = 1 IF S IS A SQUARE ARRAY
C        NS   - DIMENSION OF S(*), IE. IF S(*) IS SQUARE THIS IS THE
C               NUMBER OF ROWS OR COLUMNS IN S(*).
C        NRB  - NO. OF ROWS OF THE REGION IN WHICH B(*) IS STORED
C        NCB  - NO. OF COLUMNS OF MATRIX B(*)
C        NRY  - NO. OF ROWS DESIRED IN OUTPUT REGION Y(*)
C
C  ON OUTPUT:
C  ---------
C        OUTPUT WILL BE IN SAME FORMAT AS ARRAY S(*)
C        Y - RECTANGULAR ARRAY OF DIMENSION NS BY NCB AND
C             MAY BE STORED IN Y WITH NRY AS THE NO. OF ROWS
C             (AS LONG AS NRY IS GREATER THAN OR EQUAL TO NS)
C   SCRATCH STORAGE
C        T - DIMENSION NS BY (NS+NCB)
C
C    IF S IS STORED AS SQUARE, T(1) AND S(1) MAY COINCIDE.
C      IF SO, S WILL BE DESTROYED.
C    T(NS**2+1) AND B(1) MAY COINCIDE.
C      IF SO, B WILL BE DESTROYED.
C    Y(1) AND B(1) MAY COINCIDE.
C      IF SO, B WILL BE REPLACED BY Y.
C  HENCE,FOR MINIMUM MEMORY USE, ENTER WITH S ALREADY IN SQUARE
C  FORM, B(1)=S(NS**2+1)=Y(1) AND T(1)=S(1)
C
C     CALLED BY:
C              FORMA,VECCON
C
      IMPLICIT DOUBLE PRECISION(A-H,O-Z)
      DIMENSION S(*),B(*),Y(*),T(*)                                     1020BE05
      DATA ZERO/0.0D0/, TENM9/1.0D-10/, ONE/1.0D0/
C
      NDIM=NS
      NRDIM=NRB
      NCOL=NCB
      NRXDIM=NRY
      IERR=0
      ITIME=2
      NMAX=NDIM
      NMIN=NMAX-1
      NMXSQR=NMAX*NMAX
      NST=NMXSQR+1
      NMAXP=NMAX+1
      SMAX=ZERO
C
C     --- TEST FORMAT OF S(*) ---
C
      IF(IND.EQ.0) GO TO 110
C
C     --- MOVE SQUARE S(*) INTO T(*) ---
C
         DO 100 I=1,NMXSQR
            T(I)=S(I)
            SMAX=MAX(SMAX,dabs(S(I)))
100      CONTINUE
         GO TO 140
110   CONTINUE
      K=1
      IDIM=0
      DO 130 I=1,NMAX
         IJ=I
         JI=IDIM+1
         DO 120 J=1,I
            T(IJ)=S(K)
            T(JI)=S(K)
            SMAX=MAX(SMAX,dabs(S(I)))
            JI=JI+1
            K=K+1
            IJ=IJ+NMAX
120      CONTINUE
         IDIM=IDIM+NMAX
130   CONTINUE
140   CONTINUE
C
C     --- SET THRESHOLD FOR SMALL DIAGONAL ELEMENTS ---
C
      THRESH=SMAX*TENM9
      IF(NCOL.GT.0) GO TO 170
      IF(NCOL.LT.0) GO TO 195
C
C     --- INVERSE WANTED, SET UNIT MATRIX INTO T(*) ---
C
         NCT=NMAX+NMAX
         IJ=NCT*NMAX
         DO 150 I=NST,IJ
            T(I)=ZERO
150      CONTINUE
         IDIM=NMXSQR-NMAX
         DO 160 I=1,NMAX
            IDIM=IDIM+NMAXP
            T(IDIM)=ONE
160      CONTINUE
         GO TO 200
C
C     --- SOLUTION TO LINEAR EQUATIONS WANTED.  PUT B(*) INTO T(*) ---
C
170   CONTINUE
      NCT=NMAX+NCOL
      K=NMXSQR
      IDIM=0
      DO 190 I=1,NCOL
         JI=K
         IJ=IDIM
         DO 180 J=1,NMAX
            JI=JI+1
            IJ=IJ+1
            T(JI)=B(IJ)
180      CONTINUE
         K=K+NMAX
         IDIM=IDIM+NRDIM
190   CONTINUE
      GO TO 200
C  ONLY DETERMINANT WANTED
195   CONTINUE
      NCT=NMAX
200   CONTINUE
      DET=ONE
      IN=0
C
C     --- ELIMINATION TO MAKE LOWER TRIANGLE OF S(*) ALL ZEROES ---
C
      IF(NMIN.EQ.0) GO TO 265
         DO 260 I=1,NMIN
            IMAX=I
            JS=I+1
C  SELECT MAXIMUM ELEMENT IN COLUMN AS PIVOT
            DO 210 J=JS,NMAX
               JN=IN+J
               IMN=IN+IMAX
               TDIFF=dabs(T(JN))-dabs(T(IMN))
               IF(TDIFF.GT.ZERO) IMAX=J
210         CONTINUE
            IMIMAX=I-IMAX
            IF(IMIMAX.EQ.0) GO TO 230
C  INTERCHANGE ROWS TO BRING MAXIMUM ELEMENT TO PIVOT POSITION
               JI=I+IN
               DET=-DET
               IMN=IMAX+IN
               DO 220 J=I,NCT
                  X=T(JI)
                  T(JI)=T(IMN)
                  T(IMN)=X
                  JI=JI+NMAX
                  IMN=IMN+NMAX
220            CONTINUE
230         CONTINUE
               II=I+IN
C  IF MAXIMUM ELEMENT IS ZERO, THE MATRIX IS SINGULAR
            IF(T(II).EQ.ZERO) GO TO 998
C  ELIMINATION ON COLUMN I, STARTING IN ROW I+1
            DO 250 J=JS,NMAX
               JI=J+IN
               IF(T(JI).EQ.ZERO) GO TO 250
                  X=-T(JI)/T(II)
                  IJ=II+NMAX
                  IMN=JI+NMAX
                  DO 240 K=JS,NCT
                     T(IMN)=T(IMN)+X*T(IJ)
                     IJ=IJ+NMAX
                     IMN=IMN+NMAX
240               CONTINUE
250         CONTINUE
            IN=IN+NMAX
260      CONTINUE
C  EVALUATE DETERMINANT AS PRODUCT OF DIAGONAL ELEMENTS.
C  TEST IF ANY DIAGONAL ELEMENT IS SMALL.
  265     CONTINUE
            IFSM=0
            J=1
            DO 270 I=1,NMAX
               DET=DET*T(J)
               IF(dabs(T(J)).LE.THRESH) IFSM=J
               J=J+NMAX+1
270         CONTINUE
C  RETURN IF ONLY DETERMINANT WAS WANTED
            IF(NCOL.LT.0)RETURN
            IF(IFSM.NE.0) GO TO 999
            IF(NMIN.EQ.0) GO TO 320
C  ELIMINATE UPPER TRIANGLE OF S
            IN=NMXSQR-NMAX
         DO 310 I=1,NMIN
            IA=NMAXP-I
            II=IN+IA
            IJ=IN+1
            DO 300 J=2,IA
               IF(T(IJ).EQ.ZERO) GO TO 295
                  X=-T(IJ)/T(II)
                  JI=NMXSQR+J-1
                  IMN=NMXSQR+IA
                  DO 290 K=NMAXP,NCT
                     T(JI)=T(JI)+X*T(IMN)
                     JI=JI+NMAX
                     IMN=IMN+NMAX
290               CONTINUE
  295             CONTINUE
                  IJ=IJ+1
300         CONTINUE
            IN=IN-NMAX
310      CONTINUE
C  DIVIDE BY DIAGONALS OF S
320   CONTINUE
      IF(NCOL.NE.0) GO TO 22
      K=1
      IN=0
      IF(IND.EQ.0)GO TO 231
C  SOLVING LINEAR EQUATION, OR S INVERSE, S NOT SYMMETRIC
      JUP=NMAX
      GO TO 232
 22   IN=0
      JUP=NCOL
232   DO 43 I=1,NMAX
      IJ=NMXSQR+I
      II=IN+I
      IX=I
      DO 44 J=1,JUP
      Y(IX)=T(IJ)/T(II)
      IJ=IJ+NMAX
      IX=IX+NRXDIM
  44  CONTINUE
      IN=IN+NMAX
  43  CONTINUE
      RETURN
C  S INVERSE, STORED AS UPPER TRIANGLE SYMMETRIC
231   CONTINUE
      DO 45 I=1,NMAX
      II=IN+I
      JI=NMXSQR+I
      DO 46 J=1,I
      Y(K)=T(JI)/T(II)
      K=K+1
      JI=JI+NMAX
  46  CONTINUE
      IN=IN+NMAX
  45  CONTINUE
      GO TO 1000
C
C      --- ERROR BRANCH ---
C
998   CONTINUE
      IF(NCOL.LT.0) THEN
        DET=ZERO
      ELSE
        WRITE(6,900)
900   FORMAT(1X,52HTHE MAXIMUM ELEMENT IS ZERO. THE MATRIX IS SINGULAR.)
        STOP
      END IF
      GO TO 1000
999   CONTINUE
        WRITE(6,910) T(IFSM),THRESH
910   FORMAT(1X,'A DIAGONAL ELEMENT IS SMALLER THAN THRESHOLD.',/,
     *1X,'ELEMENT =',E12.5,' THRESHOLD =',E12.5)
        STOP
1000  CONTINUE
      RETURN
C...END OF LIN
      END SUBROUTINE lin
