!***********************************************************************
!  EHOOK
!***********************************************************************
!
      subroutine ehook(mw,iproc)
!      use common_inc
!      use perconparam; use kintcm; use cm
      use common_inc, only : n3, amass, x, dx, lezer0, ezer0, lgs, v
      use perconparam, only : n3tm
      use kintcm, only : ipot
      use cm, only : lbath
!
!     This routine was added on June 2, 1994.  It is the driver for
!     the energy routines in the modular version of POLYRATE.
!
!     This routine optionally accepts either unscaled (mw=0) or mass-scaled 
!     Cartesian coordinates and transforms them to Cartesian coordinates (mw=1).
!     The energy is computed using the Cartesian coordinates.  If the
!     mass-scaled option was chosen (mw=1), the coordinates are
!     transformed back to mass-scaled at the end.  

!     To add a new potential driver, one just needs to add a new block to 
!     the 'if block' with a call to a routine that accepts Cartesian 
!     coordinates (non-mass-scaled) and returns the energy.
!
!     Driver for energetics
!       The appropriate potential will be called according to the POTENTIAL 
!       keyword set in the GENERAL section.  This keyword is passed 
!       through the ipot variable:
!
!           ipot               potential
!
!            0                 hooks
!            1                 unit30/unit40
!            2                 ACES
!            3                 unit29
!
      implicit none
      integer, intent(in) :: mw, iproc
      double precision :: fmat(n3tm,n3tm)
!
!      write (6,*) '%%%%%%%%%% calling ehook  %%%%%%%%%%%%%'
!
!     Optionally convert the mass-scaled coordinates to Cartesian
!
      if (mw.eq.1) call ytrans(2,n3,amass,x,dx)                         !0723PF97
!
!     Compute the potential using the appropriate routines
!
      if (ipot.eq.0.and.lgs(30).le.0) then                              !1024YC96
         call surf(v,x,dx,n3tm)
!      else if (ipot.eq.1) then
!         call mopeg(v,x,dx,.false.,n3tm)
      else if (ipot.eq.2) then
         call acalc(1,fmat,n3tm)
      endif
!
!     Put the energy at an appropriate zero of energy
!
      if (lezer0) v = v-ezer0                     
!
!     new format, the bath term is a function of X instead of S
!
      IF (LBATH) THEN                                                   !0317YC99 
        CALL EFFBATH(0)
      ENDIF                                                             !0317YC99
!
!     Optionally transform back to mass-scaled coordinates
!
      if (mw.eq.1) call ytrans(1,n3,amass,x,dx)                         !0714PF97
!
      return
      end subroutine ehook                                       
!
!***********************************************************************
!  GHOOK 
!***********************************************************************
!
      subroutine ghook(mw,iproc)
!     use common_inc
!     use perconparam; use kintcm; use cm
      use common_inc, only : n3, amass, x, dx, ezer0, lezer0, lgs, v
      use perconparam, only : n3tm
      use kintcm, only : ipot
      use cm, only : lbath
!
!     This routine was added on June 2, 1994.  It is the driver for
!     the first derivative routines in the modular version of POLYRATE.
!
!     This routine optionally accepts the mass-scaled Cartesian 
!     coordinates and transforms them to Cartesian coordinates (mw=1).
!     The Cartesian coordinates are used when computing the energy and
!     first derivatives of the energy with respect to each Cartesian 
!     coordinate.  If the mass-scaled option was chosen (mw=1), the 
!     coordinates and first derivatives are transformed back to mass-
!     scaled coordinates at the end.  
!
!     To add a new potential driver, one just needs to add a new block to 
!     the 'if block' with a call to a routine that accepts Cartesian 
!     coordinates (non-mass-scaled) and returns the energy and first
!     derivatives.
!
!     Driver for gradients
!       The appropriate potential will be called according to the POTENTIAL 
!       keyword set in the GENERAL section.  This keyword is passed 
!       through the ipot variable:
!
!           ipot               potential
!
!            0                 hooks
!            1                 unit30/unit40
!            2                 ACES
!            3                 unit29
!
!
      implicit none
      integer, intent(in) :: mw, iproc
      double precision :: fmat(n3tm,n3tm)
!
!      write (6,*) '%%%%%%%%%% calling ghook  %%%%%%%%%%%%%'
!
!     Optionally convert the mass-scaled coordinates to Cartesian coordinates
!
      if (mw.eq.1) call ytrans(2,n3,amass,x,dx)                         !0714PF97
!
!     Compute the potential using the appropriate routines
!
      if (ipot.eq.0.and.lgs(30).le.0) then                              !1024YC96

         call surf(v,x,dx,n3tm)
!
!     PUT THE LINKING ROUTINE WITH ELECTRONIC STRUCTURE PROGRAM HERE 
!     IT SHOULD RETURN THE ENERGY (DENOTED BY V)
!                          GRADIENTS (DENOTED BY DX)
!
!      else if (ipot.eq.1) then
!         call mopeg(v,x,dx,.true.,n3tm)
      else if (ipot.eq.2) then
          call acalc(2,fmat,n3tm)
      end if
!
!     Put the energy at an appropriate zero of energy
!
      if (lezer0) v = v-ezer0
!
!   calculate the derivative and energy, should be in Cartesian coord
! 
      IF (LBATH) THEN                                                   !0317YC99
        CALL EFFBATH(1)
      ENDIF                                                             !0317YC99
!
!     Transfer back to mass-scaled coordinates
!
      if (mw.eq.1) call ytrans(1,n3,amass,x,dx)                         !0714PF97
!
      return
      end subroutine ghook                                          
!
!***********************************************************************
!  OHOOK
!***********************************************************************
!
      subroutine ohook (iop,iproc)
!     use common_inc
!     use perconparam; use kintcm; use cm
      use common_inc, only : n3, amass, x, dx, lezer0, ezer0, lgs, v
      use perconparam, only : n3tm
      use kintcm, only : ipot, igpot, ief, ieft, jniter
      use cm, only : lbath, convg, convgt
      use dxiz, only : dlx2
!
!     This routine was rewrittenadded on June 6, 1994.  It is the driver
!     for the geometry optimization in the modular version of POLYRATE.
!
!     This routine optionally accepts a initial guess to the Cartesian
!     coordinates of the full system and returns the optimized geometry
!     and energy
!
!     The geometry is optimized for a given chemical species:
!         For IOP = 1, or 2; the chemical species is reactant 1 or 2.
!         For IOP = 3, or 4; the chemical species is product 1 or 2.
!         For IOP = 5, the chemical species is the saddle point.
!
!     To add a new potential driver, one just needs to add a new block to 
!     the 'if block' with a call to a routine that accepts the initial
!     guess Cartesians (x) and returns the optimized geometry in the
!     array x and the energy (V).
!
!     Driver for optimization
!       The appropriate potential will be called according to the POTGEOM 
!       keyword set in the GENERAL section.  This keyword is passed 
!       through the ispot variable:
!
!           igpot              Method from
!
!            0                 POLYRATE subprogram NEWT
!            1                 ohook
!            2                 ACES
!
!
      implicit none 
      integer, intent(in) :: iop, iproc
      double precision :: fmat(n3tm,n3tm)
!
!      write (6,*) '%%%%%%%%%% calling ohook  %%%%%%%%%%%%%'
!
!     Set-up the geometry arrays for the different potentials.
!
      if (igpot.eq.0) then
        call gsetp(iop)
      else if (igpot.eq.1) then
        call gsetp(iop)
!       call gsetm(iop)
      else if (ipot.eq.2) then
        if (iop.eq.5) call gseta
      else if (ipot.eq.3) then
      end if
!
!     Compute the optimized geometry
!
      if (igpot.eq.0) then
        if (ieft.eq.1.and.iop.eq.5) then                                !0317YC99
          call efmain(iop,dlx2,convg,convgt,jniter)                     !0317YC99
        elseif (ief.eq.1.and.iop.ne.5) then                             !0317YC99
          call efmain(iop,dlx2,convg,convgt,jniter)                     !0317YC99
        else
          call newt(iop)
        endif
      else if (igpot.eq.1) then
        call ynewt(iop,iproc)                                           !0227BL05
!        call gsetm(iop)
!        call mopopt(iop)
      else if (ipot.eq.2) then
         call acalc(4,fmat,n3tm)
      else if (ipot.eq.3) then
      end if
!
!     Put the energy at an appropriate zero of energy
!
      if (lezer0) v = v-ezer0
!
      return
      end subroutine ohook                                        
!***********************************************************************
!  PREP
!***********************************************************************
!
      subroutine prep
!     use common_inc
!     use perconparam; use kintcm
      use perconparam, only : n3tm
      use kintcm, only : ipot, ispot, igpot
!
!     This routine was added on July 12, 1994.  It is the driver for
!     all preparation routines needed to set up an electronic structure
!     calculation.
!
!     This routine is called after all POLYRATE input has been read in
!     and before the table of input is written to fu6.  It is also
!     before any calculations are done.  This routine should be used
!     to call any electronic structure preparation routines.  No 
!     prep code should be written directly in this subroutine.  Everything
!     must be put in a separate subroutine.
!
!     To add a new potential driver, one just needs to add a new block to 
!     the 'if block' with a call to the appropriate routine.
!
!     This routine is called if the user specifies that the potential,
!     second derivatives or geometry optimizations are not to be done
!     using an analytic surface with the POLYRATE routines.  The method
!     used is given by the variable ipot, ispot, and/or igpot.
!
!      ipot,ispot,igpot         potential
!
!            0                  analytic PES
!            1                  MOPAC
!            2                  ACES
!            3                  GAMESS
!
!
      implicit none 
!
!
!      write (6,*) '%%%%%%%%%% calling prep  %%%%%%%%%%%%%'
!
!     Call the appropriate prep routines
!
      if (ipot .eq. 0) call setup(n3tm)                                 !1220WH94
!      if (ipot.eq.1.or.ispot.eq.1.or.igpot.eq.1) then
!         call mopset(NATOMS)
!      if (ipot .eq. 1) call mopset(NATOMS)                             0317YC97
      if (ipot.eq.2.or.ispot.eq.2.or.igpot.eq.2) then

      end if
!
      return
      end subroutine prep                                         
!
!***********************************************************************
!  PREPJ
!***********************************************************************
!
      subroutine prepj(jtype)
!      use common_inc
!      use perconparam; use kintcm; use cm
      use kintcm, only : ipot, ispot, igpot
!
!     This routine was added on May 23, 1995.  It is the species dependent
!     driver for all preparation routines needed to set up an electronic 
!     structure calculation.  Any initializations that are dependent
!     on wheter the reactants, products, saddle point, or generalized
!     transition state is computed should be done here.  JTYPE specifies
!     the species:
!
!           JTYPE               Species
!             1                 Reactant #1
!             2                 Reactant #2
!             3                 Product #1
!             4                 Product #2
!             5                 Saddle point
!             6                 Generalized transition states
!             7                 Reactant well                           0729PF97
!             8                 Product well                            0729PF97
!
!     This routine is called after each respective call to stvarj.
!     No prep code should be written directly in this subroutine.
!     Everything must be put in a separate subroutine.
!
!     To add a new potential driver, one just needs to add a new block to
!     the 'if block' with a call to the appropriate routine.
!
!     This routine is called if the user specifies that the potential,
!     second derivatives or geometry optimizations are not to be done
!     using an analytic surface with the POLYRATE routines.  The method
!     used is given by the variable ipot, ispot, and/or igpot.
!
!      ipot,ispot,igpot         potential
!
!            0                  analytic PES
!            1                  MOPAC
!            2                  ACES
!            3                  GAMESS
!
!
      implicit none
      integer, intent(in) :: jtype
!
!      write (6,*) '%%%%%%%%%% calling prepj  %%%%%%%%%%%%%'
!
!     Set the variables that are needed for all potentials
!
      if (jtype.ne.6) then
         call stlgsj(jtype)
         call stvarj(jtype)
      end if
!
!     Call the appropriate prep routines
!
      if (ipot.eq.1.or.ispot.eq.1.or.igpot.eq.1) then
      else if (ipot.eq.2.or.ispot.eq.2.or.igpot.eq.2) then
         call aceset(jtype)
      end if
!
      return
      end subroutine prepj
!***********************************************************************
!  HHOOK 
!***********************************************************************
!
      subroutine hhook(xii,fmat,sstp,nend,mw,icent,iproc)
!      use common_inc
!      use perconparam; use kintcm; use cm
!
      use perconparam,only : n3tm
      use common_inc, only : n3, amass, x, dx, lezer0, lgs, v, ezer0
      use kintcm, only : ipot, ispot
      use cm, only : lbath
!
!     This routine was added on June 6, 1994.  It is the driver for
!     the second derivative routines in the modular version of POLYRATE.
!
!     This routine optionally accepts the mass-scaled Cartesian 
!     coordinates and transforms them to Cartesian coordinates (mw=1).
!     The Cartesian coordinates are used when computing the energy and
!     second derivatives of the energy with respect to each Cartesian 
!     coordinate.  If the mass-scaled option was chosen (mw=1), the 
!     coordinates and first derivatives are transformed back to mass-
!     scaled at the end.  
!
!     To add a new potential driver, one just needs to add a new block to 
!     the 'if block' with a call to a routine that accepts Cartesian 
!     coordinates (non-mass-scaled) and returns the Hessian matrix (F)
!
!     Driver for Hessian
!       The appropriate potential will be called according to the HESSCAL 
!       keyword set in the SECOND section.  This keyword is passed 
!       through the ispot variable:
!
!           ispot              Method
!
!            0                 Numerical difference of ghook 
!            1                 hhook 
!            2                 ACES
!            3                 GAMESS
!
!
      implicit none
      double precision :: xii(n3tm), fmat(n3tm,n3tm)
      double precision :: sstp
      integer, intent(in) :: nend, mw, icent, iproc
      integer :: i 
!
!
!      write (6,*) '%%%%%%%%%% calling hhook  %%%%%%%%%%%%%'
!      write (6,*) 'IPROC IS: ',iproc

       if (iproc .ne. 0) then
         do i=1,n3tm
           x(i)=xii(i)
         enddo
       endif
!
!     Optionally convert the mass-scaled coordinates to Cartesian coordinates
!
      if (mw.eq.1) call ytrans(2,n3,amass,x,dx)                         !0714PF97
!
!     Compute the potential using the appropriate routines
!
      if (ispot.eq.0) then
          if(lgs(25) .eq. 0) then
             if(icent.eq.0) call ysecen(xii,fmat,mw,sstp)               !0714PF97
             if(icent.eq.1) call ysecep(mw,sstp,nend,iproc)             !0714PF97
          else if(lgs(25) .eq. 1) then
                call yderv2(nend,iproc)                                 !1117BL04
          else if(lgs(25) .eq. 2) then
                call yder24(nend)                                       !0714PF97
          endif
!
! HHOOK must also return the gradient
!

           call surf(v,x,dx,n3tm)
! 
      else if (ispot.eq.1) then      
!
! For POLYRATE, the HHOOK and GHOOK options in SECOND section for the
! keyword HESSCAL accomplish the same thing                             0317YC97
!
           if(lgs(25) .eq. 0) then
             if(icent.eq.0) call ysecen(xii,fmat,mw,sstp)               !0714PF97
             if(icent.eq.1) call ysecep(mw,sstp,nend,iproc)             !0714PF97
          else if(lgs(25) .eq. 1) then
                call yderv2(nend,iproc)                                 !0714PF97
          else if(lgs(25) .eq. 2) then
                call yder24(nend)                                       !0714PF97
          endif
!
! HHOOK must also return the gradient
!
           call surf(v,x,dx,n3tm)
!
!
! OR PUT IN YOUR CODE.  HERE IS AN EXAMPLE FOR MOPAC                    0317YC99
!
!          call mophes(xii, fmat, n3tm)                                 1220WH94
!
!          if (LBATH.AND.LFOPT) THEN
!             F1 = PI*PI*REDM/(16.0d0*FRICT)
!             F2 = F1/FRICT
!             DO I = 1,NEND-1
!               FMAT(NEND,I) = -F2*DIFFU(I)
!      >                   /(amass(ind(nend))*amass(ind(i)))
!               FMAT(I,NEND) = FMAT(NEND,I) 
!             ENDDO
!             FMAT(NEND,NEND)=F2
!     >                  /(amass(ind(nend))*amass(ind(nend)))
!
!     this is just a check to mimic the hhook call, however, the 'gas phase'
!     hessian is not pure in this case because mixing is added, however
!     the following lines are required for the pure gas phase hessian cases
!
!             DO I = 1,NEND-1
!              DO J = 1,I
!                FMAT(I,J) = FMAT(I,J)+F2*DIFFU(I)*DIFFU(J)
!     >                       /(amass(ind(i))*amass(ind(j)))
!                FMAT(J,I) = FMAT(I,J) 
!              ENDDO
!             ENDDO
!          endif
!
!          do 100 i = 1, nend
!             do 100 j = 1, i 
!                fmat(i,j) = fmat(i,j) / (amass(ind(i))*amass(ind(j)))  0117WH95
!                fmat(j,i) = fmat(i,j)
! 100       continue

      else if (ipot.eq.2) then
         call acalc(3,fmat,n3tm)
      else if (ipot.eq.3) then
      end if
!
!
!     Put the energy at an appropriate zero of energy
      if (lezer0) v = v-ezer0
!
!
!   calculate the derivative and energy, should be in Cartesian coord
!
      IF (LBATH) THEN                                                   !0317YC99
        CALL EFFBATH(2)
      ENDIF                                                             !0317YC99
!
!     Transfer back to mass-scaled coordinates
      if (mw.eq.1) call ytrans(1,n3,amass,x,dx)                         !0714PF97
!
!      write (6,*) '%%%%%%%%%% exiting hhook  %%%%%%%%%%%%%'
      return
!
      end subroutine hhook                                        
! ***********************************************************************
! YTRANS
! ***********************************************************************
!
      subroutine ytrans(iop,n3,amass,x,dx)
      use perconparam, only : n3tm
!
!     This subroutine was added by Patton Fast on July 14, 1997.  It is a
!     duplicate copy of the TRANS routine in POLYRATE.
!
      implicit none
      integer, intent(in) :: iop, n3
      double precision, intent(in) :: amass(n3tm)
      double precision, intent(inout) :: x(n3tm), dx(n3tm)
! Local variables
      integer :: i
!
      DO i = 1, N3
         IF (IOP.EQ.2) THEN
            DX(I) = DX(I)*AMASS(I)
            X(I) = X(I)/AMASS(I)
         ELSE IF (IOP.EQ.1) THEN
            DX(I) = DX(I)/AMASS(I)
            X(I) = X(I)*AMASS(I)
         ELSE 
            stop 'Error in ytrans iop can be only 1 or 2'
         ENDIF
      ENDDO
      RETURN
      END subroutine ytrans
!
! ************************************************************************
! YDERV2
! ************************************************************************
!
      subroutine yderv2(n,iproc)
!     use common_inc
!     use perconparam
!
      use common_inc, only : n3, amass, x, dx, lezer0,  ezer0, lgs, v, f, ind
      use common_inc, only : v, derstp
      use perconparam, only  : n3tm
      use kintcm, only : ipot
      use cm, only : lbath
!
!     This subroutine was added by Patton Fast on July 14, 1997.  It is a
!     duplicate copy of the DERIV2 routine in POLYRATE.
!
      implicit none
      integer, intent(in) :: n, iproc
      double precision :: V00, STP2, XOLD, V10, XIOLD, XJOLD, V11, VN1N1, V1N1
      integer :: i, j
!
      CALL EHOOK(0,iproc)
!
      V00 = V
      STP2 = DERSTP**2
      DO i = 1, N
         XOLD = X(IND(i))
         X(IND(I)) = X(IND(i))+DERSTP
!          
         CALL EHOOK(0,iproc)
!
         V10 = V
         X(IND(I)) = XOLD-DERSTP
         CALL EHOOK(0,iproc)      
!
         F(I,I) = (V10-2.0D0*V00+V)/(STP2*AMASS(IND(I))**2)
         X(IND(I)) = XOLD
      ENDDO
      DO I = 1, N-1
         DO J = I+1, N
            XIOLD = X(IND(I))
            XJOLD = X(IND(J))
            X(IND(I)) = X(IND(I))+DERSTP
            X(IND(J)) = X(IND(J))+DERSTP
            CALL EHOOK(0,iproc) 
!
            V11 = V
            X(IND(J)) = XJOLD-DERSTP
            CALL EHOOK(0,iproc) 
!
            V1N1 = V
            X(IND(I)) = XIOLD-DERSTP
            CALL EHOOK(0,iproc) 
!
            VN1N1 = V
            X(IND(J)) = XJOLD+DERSTP
            CALL EHOOK(0,iproc)
!
            F(I,J) = (V11-V1N1-V+VN1N1)/(4.0D0*STP2*AMASS(IND(I))*AMASS(IND(J)))
            F(J,I) = F(I,J)
            X(IND(I)) = XIOLD
            X(IND(J)) = XJOLD
         ENDDO
      ENDDO
      RETURN
      END subroutine yderv2
!
! ************************************************************************
! YDER24
! ************************************************************************
!
      subroutine yder24(nend)
!     use common_inc
!     use perconparam
      use perconparam, only : n3tm
      use common_inc, only : n3, dlx, x, dx, f, amass, ind
!
!     This subroutine was added by Patton Fast on July 14, 1997.  It is a 
!     duplicate copy of the DERIV24 routine in POLYRATE.
!
      implicit none
      integer, intent(in) :: nend
      double precision :: XXI(n3tm), f2(n3tm), h
      integer :: i, j, iproc
!
      H = DLX
!
!     SAVE INITIAL GEOMETRY SO IT CAN BE RESTORED AT THE END
!
      DO i = 1, N3
         XXI(i) = X(i)
      ENDDO
!
!     COMPUTE THE DERIVATIVE BY USING STEP SIZES OF H AND 2H
!
      DO I = 1, NEND
         X(IND(I)) = XXI(IND(I))-2.0D0*H
         call ghook(0,iproc)
!
         DO J = 1, I
            F2(J) = DX(IND(J))
         ENDDO 
         X(IND(I)) = XXI(IND(I))+2.0D0*H
         call ghook(0,iproc)
!
         DO J = 1, I
            F2(J) = DX(IND(J))-F2(J)
         ENDDO 
         X(IND(I)) = XXI(IND(I))-H
         call ghook(0,iproc)
!
         DO J = 1, I
            F(I,J) = DX(IND(J))
         ENDDO
         X(IND(I)) = XXI(IND(I))+H
         call ghook(0,iproc) 
!
         DO J = 1, I
            F(I,J) = (8.0D0*(DX(IND(J))-F(I,J))-F2(J))/(12.0D0*H)
            F(I,J) = F(I,J)/(AMASS(IND(I))*AMASS(IND(J)))
            f(j,i) = f(i,j)
         ENDDO 
         X(IND(I)) = XXI(IND(I))
      ENDDO 
      RETURN
      END subroutine yder24
!
! ***********************************************************************
! YSECEN
! ***********************************************************************
!
      subroutine ysecen(xii,fmat,mw,sstp)
!     use common_inc
      use perconparam, only : n3tm
      use common_inc, only : n3, x, dx, v, amass
!
!     This subroutine was added by Patton Fast on July 14, 1997.  It is a 
!     duplicate copy of the SECCEN routine in POLYRATE.
!
      implicit none
      integer, intent(in) :: mw
      double precision, intent(in) :: sstp
      double precision, intent(inout) :: xii(n3tm),fmat(n3tm,n3tm)
      double precision :: dx0(n3tm), h2
      integer :: i, j, iproc
!
!     save original gradient
!
      do i=1,n3 
         dx0(i) = dx(i)
      enddo
!
!     Optionally transform to Cartesian coordinates
      if (mw.eq.1) call trans(2,n3,amass,xii,dx)
!
!     Calculation of the force constant matrix using central differences
!         (second derivatives of the energy with respect to x) 
!
      h2=2.0d0*sstp
      do i=1,n3 
         x(i)=xii(i)-sstp
         call ghook(0,iproc)
!
         do j=1,i 
             fmat(i,j)=dx(j)
         enddo
!
         x(i)=xii(i)+sstp
         call ghook(0,iproc)
!
          do j=1,i
            fmat(i,j)=(dx(j)-fmat(i,j))/(h2*amass(i)*amass(j))
            fmat(j,i) = fmat(i,j)
          enddo 
          x(i)=xii(i)
      enddo
!
!     Optionally restore X to mass-scaled coordinates
!
      if (mw.eq.1) call trans(1,n3,amass,xii,dx)
!
      do i=1,n3 
         dx(i) = dx0(i)
      enddo
      return
      end subroutine ysecen
!
! **********************************************************************
! YSECEP
! **********************************************************************
!
      subroutine ysecep(mw,sstp,nend,iproc)
!     use common_inc
!     use perconparam
      use common_inc, only : x, dx, amass, ind, f, n3
      use perconparam, only : n3tm
!
!     This subroutine was added by Patton Fast on July 14, 1997.  It is a 
!     duplicate copy of the SECCEP routine in POLYRATE.
!
      implicit none
      integer, intent(in) :: mw, nend, iproc
      double precision :: sstp
      double precision :: xxi(n3tm), dx0(n3tm), h2
      integer :: i, j
!
!     Save initial geometry and gradient so it can be restored at the end
!
      do i = 1, n3
         xxi(i) = x(i)
         dx0(i) = dx(i)
      enddo
!
!     Optionally transform to Cartesian coordinates
      if (mw.eq.1) call trans(2,n3,amass,x,dx)
!
!     Calculation of the force constant matrix using central differences
!         (second derivatives of the energy with respect to x) 
!
      h2=2.0d0*sstp
      do i=1,nend 
         x(ind(i))=xxi(ind(i))-sstp
!
         call ghook(0,iproc)
!
         do  j=1,i 
             f(i,j)=dx(ind(j))
         enddo
!
         x(ind(i))=xxi(ind(i))+sstp
         call ghook(0,iproc)
!
          do j=1,i
            f(i,j)=(dx(ind(j))-f(i,j))/(h2*amass(ind(i))*amass(ind(j)))
            f(j,i) = f(i,j)
          enddo
          x(ind(i))=xxi(ind(i))
      enddo
      do i=1,n3 
        dx(i)=dx0(i)
      enddo
!
!     Optionally restore X to mass-scaled coordinates
!
      if (mw.eq.1) call trans(1,n3,amass,xxi,dx)
!
      return
      end subroutine ysecep
!
! ***********************************************************************
! YNEWT
! ***********************************************************************
!
      subroutine ynewt(iop,iproc)
!      use common_inc
!      use perconparam
!      use kintcm; use cm
!      use keyword_interface
      use common_inc, only : n3, ind, ndim, niter, amass, nratom, v, iatom, x, dx, f
      use perconparam, only : eps, fu6, ckcal, natom, n3tm
      use cm, only : convg, convgt, stptol, iprxnt, scale
      use kintcm, only : ihrec, ihrect, ihunit, ibfgs, ibfgst, iretry
      use dxiz, only : dlx2
      use keyword_interface, only : iunit6, gufac6
! 
!     This subroutine was added by Patton Fast on July 14, 1997. It is a 
!     duplicate copy of the NEWT routine in POLYRATE.
!
      implicit none
      integer :: iop, iproc
      integer :: work(n3tm)
      logical :: linmin, fail
      double precision :: hessin(n3tm, n3tm), bfgs1(n3tm, n3tm), bfgs2(n3tm, n3tm)
      double precision :: xxi(n3tm), x0(n3tm), dx0(n3tm)
      double precision :: deltag(n3tm), gtol, h2, gcomp, abgc, stepc, dgxdot, detf
      double precision :: abxxi, cnvg, stepmx, fret
      integer :: i, j, l, ncount, nrecal, n, its, mxind, idorec, jrank
      integer :: lstr, lend
!
      IPROC = 0
      NCOUNT = 0
      NRECAL = 0
      N = NDIM(IOP)
!
!--Next two lines commented here to avoid printing the header
!  for V and X data when NOPRINT is selected 
!
!     WRITE(FU6,1000)
!     WRITE(FU6,1010) (IND(I),I=1,N)
!
!  Set flag for type of search performed: 
!
      cnvg  =  convg
      idorec = ihrec
      linmin=.true.
      IF (IOP .GT. 4) THEN
          ihunit = 0                        
          cnvg  =  convgt
          idorec = ihrect
          ibfgs = ibfgst
          linmin=.false.
      ENDIF
!
!  Set up the default convergent values for the energy and derivative.
!
      IF(CNVG .LE. EPS) THEN
         GTOL = 1.0D-7
      ELSE
         GTOL = CNVG
      ENDIF
      IF(NITER .LT. 0) GOTO 300
      H2 = 2.0D0*DLX2
!
!  Calculate starting energy and gradient.
!
      call ghook(0,iproc)
!
      GCOMP = ABS(DX(IND(1)))
      DO I = 2,N 
         ABGC= ABS(DX(IND(I)))
         If (GCOMP.lt.ABGC)  GCOMP=ABGC
      ENDDO
!
!  Check if the geometry is already optimized
!
      IF(GCOMP.LE.GTOL) THEN  
        WRITE(FU6,*) '     Starting Geometry is a stationary point.'    
        RETURN                                                         
      ENDIF                                                           
!
!  Do initial inverse Hessian
!
      IF( ihunit .ne. 0 ) then
        do j=1,n
           do i=1,n
              hessin(i,j) = 0.0D0
           enddo
        enddo
        do i=1,n
           hessin(i,i)=1.0D0
        enddo
      else
          call hhook(x,f,dlx2,n,0,1,iproc)
          DO I = 1,N
             DO J = 1,I
                HESSIN(I,J) = F(I,J)*AMASS(ind(I))*AMASS(ind(J))
                HESSIN(J,I) = HESSIN(I,J)
             ENDDO
          ENDDO
          CALL MXLNEQ(HESSIN,N,N3TM,DETF,JRANK,EPS,WORK,0,N)            
      ENDIF
!
!  Main loop over iteration
!
      DO ITS = 1,NITER
        DO I = 1,N3
           DX0(I) = DX(I)
           X0(I) = X(I)
        ENDDO
!
!  Calculate Newton-Raphson step
!
        DO I = 1,N
           XXI(I) = 0.0D0
           DO J = 1,N
              XXI(I) = XXI(I) - HESSIN(I,J)*DX0(IND(J))
           ENDDO
        ENDDO
        STEPC = ABS(XXI(1))
        MXIND = 1
        DO I = 2,N
           ABXXI= ABS(XXI(I))
           If (STEPC.lt.ABXXI)  then 
             STEPC=ABXXI
             MXIND=I
           endif
        ENDDO
!
!   ...then Scale the Newton-Raphson step
!
        stepmx = scale/stepc
        IF (linmin) then
           CALL LINMN(X0,XXI,N,FRET, stepmx)
           stepc=abs(xxi(mxind))
        else if (stepc .gt. scale) then
           do i=1,n
             xxi(i)= xxi(i)*stepmx
           enddo
        endif
!
!   Move to new geometry and calculate new energy and gradient
!
        DO I = 1,N 
           X(IND(I)) = X0(IND(I)) + XXI(I) 
        ENDDO
        call ghook(0,iproc) 
!
        GCOMP = ABS(DX(IND(1)))
        DO I = 2,N 
           ABGC= ABS(DX(IND(I)))
           If (GCOMP.lt.ABGC)  GCOMP=ABGC
        ENDDO
!
! Test for convergence
!
        IF(GCOMP.LE.GTOL) THEN 
          WRITE(FU6,1300) ITS
          GOTO 300
        ENDIF
        IF (STEPC .LT. STPTOL) THEN
           FAIL=.TRUE.
           write(fu6,1350)
           if(iretry .eq. 0) GOTO 300
        ENDIF
        If(FAIL) then 
           write(fu6,'("Switching to full Newton")')
           idorec=1
           nrecal=idorec
           linmin=.false.
           FAIL=.False.
        ElSE
           NRECAL=NRECAL+1
        ENDIF
!
!  Write out the information at the ITS iteration.
!
!
!--Header for extra printing when PRINT is active
!
        IF (IPRXNT .NE. 0 .AND. ITS .LT. 2) THEN
         WRITE(FU6,1000) 
         WRITE(FU6,1010)
        ENDIF
        If (iprxnt .ne. 0) then 
         DO J = 1,N 
           IF (J .LT. 2) THEN 
              write(fu6,1020) ITS, V, IND(J), X(IND(J)), DX(IND(J)) 
           ELSE
              write(fu6,1030) IND(J), X(IND(J)), DX(IND(J)) 
           ENDIF
         ENDDO
!          write(fu6,'("Step = ",I4)') ITS
!          WRITE(FU6,1100) V,(X(IND(I)),I=1,N)
!          IF(LGS(1).EQ.2) WRITE(FU6,1200)(DX(IND(I)),I=1,N)
!       endif
        endif
!
!  Calculate new inverse hessian
!
        if( NRECAL .eq. idorec ) then
          NRECAL=0
          If(iprxnt.ne.0) write(fu6,'("Hessian recalculated")')  
!   get exact inverse hessian
           call hhook(x,f,dlx2,n,0,1,iproc)
          DO I = 1,N
             DO J = 1,I
                HESSIN(I,J) = F(I,J)*AMASS(ind(I))*AMASS(ind(J))
                HESSIN(J,I) = HESSIN(I,J)
             ENDDO
          ENDDO
          CALL MXLNEQ(HESSIN,N,N3TM,DETF,JRANK,EPS,WORK,0,N)            
        ELSE
          IF(ibfgs .eq. 1) then
!
!   do BFGS update
!
             If(iprxnt.ne.0) write(fu6, &
                '("Hessian updated using BFGS formula")')
             do i=1,N
               deltag(i)= dx(ind(i)) - dx0(ind(i))
             enddo
             dgxdot=0.0d0
    
             do i=1,N
                dgxdot = dgxdot + xxi(i)*deltag(i)
             enddo
!
!   ... build ( I - Dx(Dg)t/DOT(Dx,Dg) )
!
             do j=1,N
                do i=1,N
                   BFGS1(i,j)= -XXI(I)*deltag(j) / dgxdot
                enddo
             enddo
             do i=1,N
                BFGS1(i,i)= 1.0d0 + BFGS1(i,i)
             enddo
!
!   ... calculate (BFGS1)(HESSIN)(BFGS1)t
!
             call DGEMM('N','T',N, N, N, 1.0d0, HESSIN, N3TM,  &
                        BFGS1, N3TM, 0.0d0, BFGS2, N3TM)
             call DGEMM('N','N',N, N, N, 1.0d0, BFGS1, N3TM,  &
                        BFGS2, N3TM, 0.0d0, HESSIN, N3TM)
!
!   ... and add Dx(Dx)t/DOT(Dx,Dg) to it.
!
             do j=1,N
               do i=1,N
                 HESSIN(i,j) = HESSIN(i,j) + xxi(i)*xxi(j)/dgxdot
               enddo
             enddo
          ELSE
            If (iprxnt .ne. 0) write(fu6,'("Hessian kept frozen")')
          ENDIF
        ENDIF
! End main loop
      ENDDO
!
! Maximum number of iterations exceeded
!
      WRITE(FU6,1400)
      FAIL=.TRUE.
 300  CONTINUE   ! Goto
!
! Write out the final results
!
!     WRITE(FU6,1700)
      IF(IUNIT6.EQ.1) WRITE(FU6,1700)                                   !0405JZ07
      IF(IUNIT6.EQ.0) WRITE(FU6,1702)                                   !0405JZ07
      WRITE(FU6,1710)

      IF (IOP .NE. 5) THEN
         DO J = 1,NRATOM(IOP)
            LSTR = 3 * IATOM(J) - 2
            LEND = LSTR + 2
            WRITE(FU6,1800) IATOM(J),(X(L)/GUFAC6,L=LSTR,LEND)          !0405JZ07
         ENDDO
!
         WRITE(FU6,1712)                                                !0405JZ07
         WRITE(FU6,1720)
         DO J = 1,NRATOM(IOP)
            LSTR = 3 * IATOM(J) - 2
            LEND = LSTR + 2
            WRITE(FU6,1800) IATOM(J),(DX(L),L=LSTR,LEND)
         ENDDO
      ELSE
         DO J = 1, NATOM
            LSTR = 3 * J - 2
            LEND = LSTR + 2
            WRITE(FU6,1800) J,(X(L)/GUFAC6,L=LSTR,LEND)                 !0405JZ07
         ENDDO
!
         WRITE(FU6,1712)                                                !0405JZ07
         WRITE(FU6,1720)
         DO J = 1, NATOM
            LSTR = 3 * J - 2
            LEND = LSTR + 2
            WRITE(FU6,1800) J,(DX(L),L=LSTR,LEND)
         ENDDO
!
      ENDIF
!
      WRITE(FU6,1600) V,V*CKCAL 
      IF (FAIL) STOP
      RETURN
!
 1000 FORMAT(/1X,'Energy (a.u.), geometry (unscaled a.u.) and ', &
       'gradient at each',/,1x,'optimization iteration')
!1010 FORMAT(1X,'      V         ',' X(i),i=',3I16,/,(25X,3I16))
 1010 FORMAT(/1X,'Step',10X,'V',8X,'IND',9X,'X',14X,'DX',/,1X,68('-'))
 1020 FORMAT(1X,I3,2X,1P,E16.8,I3,3X,2(E16.8))
 1030 FORMAT(22X,I3,3X,2(E16.8))
 1100 FORMAT (/1X,1P,E16.8,8X,3E16.6,/,(25X,3E16.6))
 1200 FORMAT ( 18X,'DX(i)',1P,/,(25X,3E16.6)) 
 1300 FORMAT(/,' Search has converged after ',I4,' iterations')
 1350 FORMAT('Max. displacement component change smaller than STPTOL.')
 1400 FORMAT(/,' MAXIMUM NUMBER OF ITERATIONS EXCEEDED',/)
 1600 FORMAT (/,'  V = ',1PE16.8,' hartrees  (',0P,F16.8,' kcal/mol)')
!1700 FORMAT (/1X,'Final geometry and derivatives in unscaled',
!    * ' Cartesians (a.u.)')
 1700 FORMAT (/1X,'Final geometry in unscaled Cartesians (bohrs)')      !0405JZ07
 1702 FORMAT (/1X,'Final geometry in unscaled Cartesians (angstroms)')  !0405JZ07
 1710 FORMAT(/1X,4HAtom,11X,'X',15X,'Y',15X,'Z',/)
 1712 FORMAT (/1X,'Final derivatives in unscaled Cartesians (a.u.)')    !0405JZ07
 1720 FORMAT(/1X,4HAtom,11X,'DX',14X,'DY',14X,'DZ',/)
 1800 FORMAT (1X,I3,4X,1P,3E16.6)
!
      END subroutine ynewt
