!
         SUBROUTINE surf (V, X, DX, N3TM)
         use potcm4
!
!   This is a driver routine which can be used to link a calling program
!   that supplies the cartesian coordinates in an array X in the parameter
!   list with a potential energy surface routine that accepts the position
!   of the atoms in internal coordinates.  This routine will convert the 
!   cartesian coordinates to internal coordinates by calling the subprogram
!   COORD4 and call the potential energy function POTEN.  This subprogram 
!   will take the energy and the derivatives of the energy with respect to
!   the internal coordinates calculated in POTEN and convert the derivatives
!   to derivatives with respect to the atomic cartesians.  The energy and
!   the derivatives with respect to the cartesians are passed to the calling
!   program through V and DV, respectively, in the parameter list.  
!   All calculations are in hartree atomic units.
!
!   This subprogram assumes that the potential energy function that will
!   be called to obtain the energy and the derivatives of the energy with 
!   respect to the internal coordinates is in the following form:
!        1) the subprogram name is POTEN
!        2) the subprogram POTEN has no argument list, all information is 
!           passed to and from the potential energy subprogram through 
!           the common block POTCM:
!                                   /POTCM/ R(6), VTOT, DVDR(6)
!           where R(6)   : array of the internal coordinates in bohr
!                 V      : energy in hartree atomic units
!                 DVDR(6): array of the derivatives of the energy with respect
!                          to the internal coordinates in atomic units.
!
!   The integer N3TM which is also passed is used to dimension the 
!   arrays X and DX and needs to be greater than or equal to 3 * NATOMS
!   where NATOMS is the number of atoms represented by this potential.
!
         implicit none
         integer, intent(in) :: N3TM
         real(8), intent(in) :: X(N3TM)
         double precision, intent(out) :: V, DX(N3TM)
!        COMMON /POTCM/ R(6), VTOT, DVDR(6)
!        COMMON /POTCCM/ NSURF, NDER, NDUM(8)
!
!   Transform the cartesian coordinates to internal coordinates.
!
         CALL COORD4(X, N3TM)
!
!   Calculate the energy.
!
         CALL POTEN
         V = VTOT
!
!   Transform the derivatives of the energy with respect to the internal 
!   coordinates to derivatives with respect to the atomic cartesians.
!
         IF (NDER .EQ. 1) CALL CHAIN4(X, DX, N3TM)
!
         RETURN
         END subroutine surf
!*****
