!
         SUBROUTINE surf (V, X, DX, N3TM)
         use potcm3
!
!   This is a driver routine which can be used to link a calling program
!   that supplies the cartesian coordinates in an array X in the parameter
!   list with a potential energy surface routine that accepts the position
!   of the atoms in internal coordinates.  This routine will convert the 
!   cartesian coordinates to internal coordinates by calling the subprogram
!   COORD3, and call the potential energy function POT.  It will take the 
!   energy and the derivatives of the energy with respect to the internal 
!   coordinates from POT, convert the derivatives to derivatives with respect 
!   to cartesian coordinates by calling the subprogram CHAIN3, and pass this 
!   information to the calling routine through the parameters in the parameter
!   list.  All calculations are carried out in hartree atomic units. 
!
!   This subprogram assumes that the potential energy function that will
!   be called to obtain the energy and the derivatives of the energy
!   with respect to the internal coordinates has the following form:
!        1) the subprogram name is POT
!        2) the subprogram POT has no argument list, all information is 
!           passed to and from the potential energy subprogram through
!           the common block POTCM:
!                                   /POTCM/R(3), ENERGY, DEDR(3)
!           where R(3)    : array containing the internal coordinates in bohr
!                 ENERGY  : energy in hartree atomic units
!                 DEDR(3) : array containing the derivatives of the energy with
!                           respect to the internal coordinates.
!
!   The integer N3TM which is also passed is used to dimension the 
!   arrays X and DX and needs to be greater than or equal to 3 * NATOMS
!   where NATOMS is the number of atoms represented by this potential.
!
         implicit none
         integer, intent(in) :: n3tm
         double precision, intent(in) :: x(n3tm)
         double precision, intent(out) :: v, dx(n3tm)
!
!        COMMON /POTCM/ R(3),ENERGY,DER(3)
!        COMMON /POTCCM/ NSURF, NDER, NDUM(8)
!
         CALL COORD3(X, N3TM)
         CALL POT
!
         V = ENERGY
!
         IF (NDER .EQ. 1) CALL CHAIN3(X, DX, N3TM)
!        CALL CHAIN3(X, DX, N3TM)
!
         RETURN
         END subroutine surf
!*****
