!
         SUBROUTINE setup (N3TM)
!
!   This is a generic SETUP subprogram for a three body system.  This 
!   subprogram checks the value of N3TM and calls the subprogram PREPOT,
!   which initializes the parameters for the potential energy routine.
!
         implicit none
!         IMPLICIT DOUBLE PRECISION (A-H,O-Z)
!
!   N3TMMN = 3 * NATOMS
!   NATOMS = the number of atoms represented by this potential function
!
!   The variable N3TMMN is the minimum value of N3TM allowed to be 
!   passed by the calling routine for the number of cartesian 
!   coordinates needed to represent the full system represented by this 
!   potential energy surface routine.
!   N3TM must be greater than or equal to N3TMMN.
!
         integer, intent(in) :: n3tm
         integer, parameter :: n3tmmn = 9 

!         PARAMETER (N3TMMN = 9)
!
!   Check the number of cartesian coordinates set by the calling program.
!
         IF (N3TM .LT. N3TMMN) THEN
             WRITE (6, 1000) N3TM, N3TMMN
             STOP 'SETUP 1'
         ENDIF
!
         CALL PREPOT
!
         RETURN
!
1000     FORMAT(/,2X,T5,'WARNING: N3TM is set equal to ',I3, &
                        ' but this potential routine', &
                /,2X,T14,'requires N3TM be greater than or ', &
                         'equal to ',I3,/)
!
         END subroutine setup
!*****
