!
      SUBROUTINE prepot
      use potcm3
!
!   Sys.: HO2
!   Ref.: C. F. Melius and R. J. Blint
!         Chem. Phys. Lett. 64, 183 (1979).
!
!        PREPOT must be called once before any calls to POT.
!        The potential parameters are included in DATA statements.
!        The coordinates, potential energy, and the derivatives of the 
!        potential energy with respect to the coordinates are passed 
!        through the common block POTCM:
!                  /POTCM/ R(3), V, DVDR(3).
!        All information passed through the common block POTCM is in 
!        hartree atomic units.  
!
!   The the flags that indicate what calculations should be carried out in 
!   the potential routine are passed through the common block POTCCM:
!                  /POTCCM/ NSURF, NDER, NDUM(8)
!   where:
!        NSURF - which electronic state should be used.
!                This option is not used for this potential as only the 
!                ground electronic state is available.
!        NDER  = 0 => no derivatives should be calculated
!        NDER  = 1 => calculate first derivatives
!        NDUM  - these 8 integer values can be used to flag options
!                within the potential; in this potential these options 
!                are not used.
!        
!CCCCCCCCCCCCCCCCCCCCCCCCCCCCC
!         GENERAL INFORMATION
!CCCCCCCCCCCCCCCCCCCCCCCCCCCCC
!
!          THE POTENTIAL CONSISTS OF THREE MORSE TERMS FOR
!          THE THREE DIATOMICS, HO,OO, AND HO RESPECTIVELY
!          PLUS TWO INTERACTION TERMS.
!
!          EACH POTENTIAL TERM WILL BE CALCULATED INDIVIDUALLY
!          TO SIMPLIFY READING THE CODE.
!
!CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
!          DEFINE VARIABLES, ARRAYS, AND COMMON BLOCK
!CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
!
      implicit none
      double precision :: DCSTH(3),DV(3),GAMMA(3),JUNK(4),C(5,3,3),A(5),DA(5,3), &
       REQ(3),DE(3),EXPO(3),DEXPO(3),DMEW(3),B(5,3),DB(5,3,3),DPROD1(3)   &
       ,DPROD2(3),DSEC(3),DTHIRD(3),DPROD3(3)
      double precision :: NUM, DENOM, MEW, ZEV, ZEROAD, ZKCAL
      double precision :: ALPHA, BETA, VAB, VBC, VAC
      integer :: IT
!
!      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
!
!      DOUBLE PRECISION NUM,DENOM,GAMMA,JUNK,EXPO,DEXPO,MEW
!
!     COMMON /POTCM/ R(3),ENERGY,DER(3)
!     COMMON /POTCCM/ NSURF, NDER, NDUM(8)
!
!      DIMENSION DCSTH(3),DV(3),GAMMA(3),JUNK(4),C(5,3,3),A(5),DA(5,3),  
!     *   REQ(3),DE(3),EXPO(3),DEXPO(3),DMEW(3),B(5,3),DB(5,3,3),DPROD1(3
!     *   ),DPROD2(3),DSEC(3),DTHIRD(3),DPROD3(3)
!
!CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
!          READ IN THE CONSTANTS
!CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
!
      DATA C / 77.45D0, -0.4071D0, -0.508D0, &
               0.1489D0, 1.013D0, -10.495D0, &
               9.1484D0, 10.273D0, 0.0D0, 0.0D0, &
               -3.050D0, -33.78D0, -22.951D0, 0.0D0, &
               0.0D0, -1.3699D0, 0.4101D0, 0.3411D0, &
               16.906D0, 0.0005637D0, -0.6359D0, &
               -0.06253D0, -0.1225D0, 0.0D0, 0.0D0, &
               -0.00906D0, 0.4435D0, 0.7439D0, 0.0D0, 0.0D0, &
               -0.3498D0, 0.6617D0, 0.8677D0, 1.3858D0, &
               233.36D0, -4.756D0, -1.626D0, &
               0.6337D0, 0.0D0, 0.0D0, -476.32D0, &
               -1.2104D0, -1.2762D0, 0.0D0, 0.0D0 /
!   The array DE contains the dissociation energies in hartree atomic units.
      DATA DE / 0.1559D0, 0.1779D0, 0.1559D0/
!   The array GAMMA contains the Morse Betas in reciprocal bohrs.
      DATA GAMMA / 1.2670D0, 1.4694D0, 1.2670D0/
!   The array REQ contains the equilibrium bond lengths in bohr.
      DATA REQ / 1.8460D0, 2.3158D0, 1.8460D0/
!   The variable ZEROAD contains the constant added to the energy in hartree 
!   atomic units.  
      DATA ZEROAD /-0.022000295721D0/
!
!   Set the flags for the type of calculations to be performed.
!
      NDER = 1
!
!          SET ALPHA, UNITS: RECIPROCAL BOHR
!
      ALPHA = 0.9172D0
!
!          SET BETA, UNITS: RECIPROCAL BOHR
!
      BETA = 1.4694D0
!
!   Echo potential paramters to unit 6.
!
      WRITE (6,1000)
      WRITE (6,1050) (DE(IT),IT=1,3)
      WRITE (6,1150) (GAMMA(IT),IT=1,3)
      WRITE (6,1200) (REQ(IT),IT=1,3)
!   Convert ZEROAD to eV and kcal/mol and echo to unit 6.
      ZEV = ZEROAD*27.21106D0
      ZKCAL = ZEROAD*627.5095D0
      WRITE (6,1300) ZEROAD,ZEV,ZKCAL
!
!CCCCCCCCCCC
!
1000  FORMAT (/, 2X, T5, 'PREPOT has been called for H + OO',  &
              /, 2X, T5, 'Potential energy function by Melius ',  &
                         'and Blint',  &
              //, 2X, T5, 'Potential energy surface parameters:',  &
              /, 2X, T5, 'Bond', T47, 'H-O', T58, 'O-O', T69, 'O-H')
 1050 FORMAT(2X,T10,'Dissociation energies (hartrees):',  &
             T44, F10.5, T55, F10.5, T66, F10.5)
 1150 FORMAT(2X,T10,'Morse betas (reciprocal bohr):',  &
             T44, F10.5, T55, F10.5, T66, F10.5)
 1200 FORMAT(2X,T10,'Equilibrium bond lengths (bohr):',  &
             T44, F10.5, T55, F10.5, T66, F10.5)
 1300 FORMAT(2X,T10,'Constant added to the energy:',  &
             T55, 1PE20.10,' hartree atomic units',  &
             /,2X,T55,1PE20.10,' eV',/,2X,T55,1PE20.10,' kcal/mol') 
!
      RETURN
      END subroutine prepot
!
!CCCCCCCCCCC
!
!CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
!        MOVE ONTO THE MAIN PART OF THE ROUTINE
!CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
!
!     ENTRY POT
      subroutine pot
      use potcm3
      implicit none
!      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
!
      double precision :: NUM,DENOM,MEW
     
      double precision :: DCSTH(3),DV(3),GAMMA(3),JUNK(4),C(5,3,3),A(5),DA(5,3), &
         REQ(3),DE(3),EXPO(3),DEXPO(3),DMEW(3),B(5,3),DB(5,3,3),DPROD1(3   &
         ),DPROD2(3),DSEC(3),DTHIRD(3),DPROD3(3)
      double precision :: RAB, RAC, RBC, CSTH, PROD1, PROD2, PROD3, SECOND, THIRD
      double precision :: ALPHA, BETA, VAB, VBC, VAC, ZETAD, ZKCAL, ZEROAD, ZEV
      INTEGER :: IT, IT1, I, J
!
!CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
!          READ IN THE CONSTANTS
!CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
!
      DATA C / 77.45D0, -0.4071D0, -0.508D0,  &
               0.1489D0, 1.013D0, -10.495D0,  &
               9.1484D0, 10.273D0, 0.0D0, 0.0D0,  &
               -3.050D0, -33.78D0, -22.951D0, 0.0D0,  &
               0.0D0, -1.3699D0, 0.4101D0, 0.3411D0,  &
               16.906D0, 0.0005637D0, -0.6359D0,  &
               -0.06253D0, -0.1225D0, 0.0D0, 0.0D0,  &
               -0.00906D0, 0.4435D0, 0.7439D0, 0.0D0, 0.0D0,  &
               -0.3498D0, 0.6617D0, 0.8677D0, 1.3858D0,  &
               233.36D0, -4.756D0, -1.626D0,  &
               0.6337D0, 0.0D0, 0.0D0, -476.32D0,  &
               -1.2104D0, -1.2762D0, 0.0D0, 0.0D0 /
!   The array DE contains the dissociation energies in hartree atomic units.
      DATA DE / 0.1559D0, 0.1779D0, 0.1559D0/
!   The array GAMMA contains the Morse Betas in reciprocal bohrs.
      DATA GAMMA / 1.2670D0, 1.4694D0, 1.2670D0/
!   The array REQ contains the equilibrium bond lengths in bohr.
      DATA REQ / 1.8460D0, 2.3158D0, 1.8460D0/
!   The variable ZEROAD contains the constant added to the energy in hartree 
!   atomic units.  
      DATA ZEROAD /-0.022000295721D0/
!          SET ALPHA, UNITS: RECIPROCAL BOHR
!
      ALPHA = 0.9172D0
!
!          SET BETA, UNITS: RECIPROCAL BOHR
!
      BETA = 1.4694D0
!
!   Echo potential paramters to unit 6.
!   Convert ZEROAD to eV and kcal/mol and echo to unit 6.
      ZEV = ZEROAD*27.21106D0
      ZKCAL = ZEROAD*627.5095D0
!
!CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
!         SET RAB,RBC,AND RAC
!CCCCCCCCCCCCCCCCCCCCCCCCCCCC
!
      RBC = R(2)
!
!           RAB IS DEFINED AS THE SMALLER OF R(1) AND R(3)
!           RAC IS DEFINED AS THE LARGER OF R(1) AND R(3)
!
      IF (R(1).GT.R(3)) then 
         RAB = R(3)
         RAC = R(1)
      else
         RAB = R(1)
         RAC = R(3)
      endif
!      IF (R(1).GT.R(3)) GO TO 40
!
!      RAB = R(1)
!      RAC = R(3)
!      GO TO 50
!
!   40 RAB = R(3)
!      RAC = R(1)
!   50 CONTINUE
!
!CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
!          CALCULATE USEFUL EXPONENTIALS
!CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
!
      EXPO(1) = EXP(-ALPHA*RAB)
      EXPO(2) = EXP(-BETA*RBC)
      EXPO(3) = EXP(-ALPHA*RAC)
!
!          AND THEIR DERIVATIVES
!
         IF (NDER .EQ. 1) THEN
             DEXPO(1) = -ALPHA*EXPO(1)
             DEXPO(2) = -BETA*EXPO(2)
             DEXPO(3) = -ALPHA*EXPO(3)
         ENDIF
!
!CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
!          CALCULATE VAB AND DV(1)
!CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
!
!          THE POTENTIAL CALCULATED HERE AND THE POTENTIALS VAC AND VBC
!          CORRESPOND TO THE VOH POTENTIAL DESCRIBED IN EQUATION 3.
!          DV(1) IS THE DERIVATIVE OF THIS TERM WITH RESPECT TO RAB.
!
      JUNK(1) = EXP(GAMMA(1)*(REQ(1)-RAB))
      VAB = DE(1)*(JUNK(1)*JUNK(1)-2.0D0*JUNK(1))
      IF (NDER .EQ. 1) DV(1) = 2.0D0*DE(1)*(1.0D0-JUNK(1))*GAMMA(1)*JUNK(1)
!
!CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
!          CALCULATE VAC AND DV(3)
!CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
!
      JUNK(1) = EXP(GAMMA(3)*(REQ(3)-RAC))
      VAC = DE(3)*(JUNK(1)*JUNK(1)-2.0D0*JUNK(1))
      IF (NDER .EQ. 1) DV(3) = 2.0D0*DE(3)*(1.0D0-JUNK(1))*GAMMA(3)*JUNK(1)
!
!CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
!          CALCULATE VBC AND DV(2)
!CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
!
      JUNK(1) = EXP(GAMMA(2)*(REQ(2)-RBC))
      VBC = DE(2)*(JUNK(1)*JUNK(1)-2.0D0*JUNK(1))
      IF (NDER .EQ. 1) DV(2) = -2.0D0*DE(2)*(JUNK(1)-1.0D0)*GAMMA(2)*JUNK(1)
!
!CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
!          CALCULATE CSTH AND DERIVATIVES
!CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
!
!          TH IS THE BEND ANGLE OF THE THREE ATOM SYSTEM.
!          IT IS NEVER USED USED EXPLICITELY WITHIN THE PROGRAM
!          HOWEVER COSINE(TH) IS.  COSINE(TH) IS CALCULATED
!          FROM THE LAW OF COSINES)
!
      NUM = RBC*RBC+RAB*RAB-RAC*RAC
      DENOM = 2.0D0*RAB*RBC
!
      CSTH = NUM/DENOM
!
      IF (NDER .EQ. 1) THEN
          DCSTH(1) = (2.0D0*RAB/DENOM)-(2.0D0*RBC)*CSTH/DENOM
          DCSTH(2) = (2.0D0*RBC/DENOM)-(2.0D0*RAB)*CSTH/DENOM
          DCSTH(3) = -(2.0D0*RAC/DENOM)
      ENDIF
!
!CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
!          CALCULATE THE B IJ 'S--SEE EQUATION 5
!CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
!
      DO I = 1, 5
         DO J = 1, 3
            B(I,J) = C(I,J,1)*(1.0D0+C(I,J,2)*CSTH*(1.0D0+C(I,J,3)*CSTH))
!
!               CALCULATE THE DERIVATIVES TOO.
!
            IF (NDER .EQ. 1) THEN
                DO IT = 1, 3
                      DB(I,J,IT) = C(I,J,1)*C(I,J,2)*(CSTH*C(I,J,3)*DCSTH(IT)+DCSTH(IT)*(1.0D0+C(I,J,3)*CSTH))
                ENDDO
            ENDIF
         ENDDO 
      ENDDO
!
!CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
!          NEXT CALCULATE MEW--SEE EQUATION FOUR
!CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
!
      MEW = EXPO(2)-0.02538745816335D0
      IF (NDER .EQ. 1) THEN
          DMEW(2) = -BETA*EXPO(2)
          DMEW(1) = 0.0D0
          DMEW(3) = 0.0D0
      ENDIF
!
!CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
!          NOW CALCULATE A I 'S AND DERIVATIVES--SEE EQUATION 4
!CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
!
      DO IT = 1, 5
         JUNK(1) = 1.0D0+B(IT,3)*MEW
         JUNK(2) = MEW*B(IT,2)
         JUNK(3) = 1.0D0+JUNK(2)*JUNK(1)
!
         A(IT) = B(IT,1)*JUNK(3)
         IF (NDER .EQ. 1) THEN
             DO IT1 = 1, 3
                   DA(IT,IT1) = DB(IT,1,IT1)*JUNK(3)+B(IT,1)*   &
                                ((DB(IT,2,IT1)*MEW+B(IT,2)*DMEW(IT1))* &
                                JUNK(1)+JUNK(2)*(DB(IT,3,IT1)*MEW+ &
                                B(IT,3)*DMEW(IT1)))
             ENDDO
         ENDIF
      ENDDO
!
!CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
!          CALCULATE THE SECOND TERM IN EQUATION THREE
!CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
!
      PROD1 = EXPO(1)*EXPO(3)*A(1)
!
      PROD2 = 1.0D0+(A(3)*RAB*RAC)/(RAB+RAC)
!
      IF (NDER .EQ. 1) THEN
          DPROD1(1) = DEXPO(1)*EXPO(3)*A(1)+EXPO(1)*EXPO(3)*DA(1,1)
          DPROD1(2) = EXPO(1)*EXPO(3)*DA(1,2)
          DPROD1(3) = DEXPO(3)*EXPO(1)*A(1)+EXPO(1)*EXPO(3)*DA(1,3)
!
          DPROD2(2) = (DA(3,2)*RAB*RAC)/(RAB+RAC)
          DPROD2(1) = ((DA(3,1)*RAB*RAC+A(3)*RAC)*(RAB+RAC)-  &
                       (A(3)*RAB*RAC))/((RAB+RAC)*(RAB+RAC))
          DPROD2(3) = ((DA(3,3)*RAB*RAC+A(3)*RAB)*(RAB+RAC)-  &
                       (A(3)*RAB*RAC))/((RAB+RAC)*(RAB+RAC))
      ENDIF
!
!          CALCULATE PROD3
!
      PROD3 = 1.0D0+A(2)*(RAB+RAC)*PROD2
!
      IF (NDER .EQ. 1) THEN
          DO IT = 1, 3
                 DPROD3(IT) = DA(2,IT)*(RAB+RAC)*PROD2+A(2)*(RAB+RAC)*DPROD2(IT)
             !   IF (IT.EQ.2) GO TO 110
                 IF (IT.EQ.2) CYCLE
                 DPROD3(IT) = DPROD3(IT)+A(2)*PROD2
          ENDDO
      ENDIF
!
      SECOND = PROD1*PROD3
!
      IF (NDER .EQ. 1) THEN
          DO IT = 1, 3
                 DSEC(IT) = PROD1*DPROD3(IT)+DPROD1(IT)*PROD3
          ENDDO
      ENDIF
!
!CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
!          CALCULATE THE THIRD TERM
!CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
!
      JUNK(1) = EXPO(1)+EXPO(3)
      JUNK(2) = (1.0D0+A(5)*(RAB+RAC))
!
      THIRD = JUNK(1)*EXPO(2)*A(4)*JUNK(2)
!
      IF (NDER .EQ. 1) THEN
          DO IT1 = 1, 2
                 IT = 1
                 IF (IT1.EQ.2) IT = 3
                 DTHIRD(IT) = DEXPO(IT)*EXPO(2)*A(4)*JUNK(2)+   & 
                              JUNK(1)*EXPO(2)*DA(4,IT)*JUNK(2)+ & 
                              JUNK(1)*EXPO(2)*A(4)*(DA(5,IT)*  &
                              (RAB+RAC)+A(5))
          ENDDO 
          DTHIRD(2) = JUNK(1)*(DEXPO(2)*A(4)*JUNK(2)+EXPO(2)*(DA(4,2)* &
                      JUNK(2)+A(4)*(DA(5,2)*(RAB+RAC))))
      ENDIF
!
!CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
!          FINALLY SUM IT ALL UP
!CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
!
      ENERGY = VAB+VAC+VBC+SECOND+THIRD+DE(2)
      ENERGY = ENERGY+ZEROAD
!
      IF (NDER .EQ. 1) THEN
          do IT = 1, 3
                 DEDR(IT) = DV(IT)+DSEC(IT)+DTHIRD(IT)
          ENDDO 
!
!          IF (R(1).LT.R(3)) GO TO 160
!          JUNK(1) = DEDR(3)
!          DEDR(3) = DEDR(1)
!          DEDR(1) = JUNK(1)
!  160     CONTINUE
          IF (R(1).LT.R(3)) then
            continue
          else 
            JUNK(1) = DEDR(3)
            DEDR(3) = DEDR(1)
            DEDR(1) = JUNK(1)
          endif
      ENDIF
!
!CCCCCCCCCCCCCCC
!
      RETURN
!
!CCCCCCCCCCCCCCC
!
      END subroutine pot
!
