!
!  This file provides dummy SURF and SETUP routines for unit fu30 input cases.
!
      SUBROUTINE SURF (V, X, DX, N3TM)
! 
!   This potential routine is a dummy routine which, if called, will
!   write an error message to unit 6 and stop.
!
!
      implicit none
      integer :: n3tm
      double precision :: v, x(n3tm), dx(n3tm)
!
         WRITE (6, 100) 
  100    FORMAT(/,5X,60('*'),//,10X, &
                'THIS POTENTIAL IS A DUMMY POTENTIAL AND SHOULD ',/,10X, &
                'NOT BE CALLED FOR ENERGIES AND/OR DERIVATIVES.', &
                //,5X,60('*'))
!
         STOP 'SURF 1'
!
         END
!*****
!
      SUBROUTINE SETUP (N3TM)
      implicit none
      integer,intent(in)  :: n3tm
!
!   This is the SETUP routine for the dummy potential.  It checks that
!   it is called with the number of cartesians set greater than zero
!   and returns.
!
!   N3TMMN = 3 * NATOMS
!   NATOMS = the number of atoms represented by this potential function
!
!   The variable N3TMMN is the minimum value of N3TM allowed to be 
!   passed by the calling routine for the number of cartesian 
!   coordinates needed to represent the full system represented by this 
!   potential energy surface routine.
!   N3TM must be greater than or equal to N3TMMN.
!
      integer, parameter :: N3TMMN = 0
!
      IF (N3TM .LT. N3TMMN) THEN
!
!  CHECK THE NUMBER OF CARTESIAN COORDINATES SET BY THE CALLING PROGRAM
!
          WRITE (6, 1000) N3TM, N3TMMN
          STOP 'SETUP 1'
      ENDIF
!
1000  FORMAT(/,2X,T5,'WARNING: N3TM is set equal to ',I3, &
                    ' but this potential routine', &
             /,2X,T14,'requires N3TM be greater than or ', &
                         'equal to ',I3,/)
!
      RETURN
!
      END
!*****
