!
         SUBROUTINE coord4(X, N3TM)
         use potcm4, only : r
!
!   This subprogram transforms the coordinates from atomic cartesians
!   to interatomic distances for a four-body system, ABCD.
!   The integer N3TM, passed by the calling routine, must be greater than 
!   or equal to 12.
!   The convention assumed in this subprogram is as follows:
!                  X(1)  - X(3)  : X, Y, Z of atom A
!                  X(4)  - X(6)  : X, Y, Z of atom B
!                  X(7)  - X(9)  : X, Y, Z of atom C
!                  X(10) - X(12) : X, Y, Z of atom D
!                  R(1) = R(A-B)
!                  R(2) = R(A-C)
!                  R(3) = R(A-D)
!                  R(4) = R(B-C)
!                  R(5) = R(B-D)
!                  R(6) = R(C-D)
!
         implicit none
         integer, intent(in) :: N3TM
         real(8), intent(in) :: X(N3TM)
         integer :: m, i, itim, k, l, j
!        COMMON /POTCM/ R(6), ENERGY, DEDR(6)
!         real(8), intent(in) ::  X(N3TM)
!
         M = 0
         do i = 1, 3
               ITIM = 4-i
               K    = 3*(i-1)+1
               L    = K
            do j = 1, ITIM
                  M = M+1
                  L = L+3
                  R(M) = SQRT((X(K)-X(L))**2 + (X(K+1)-X(L+1))**2 + (X(K+2)-X(L+2))**2)
            enddo
         enddo
!
         RETURN
         END subroutine coord4
!*****
