!
      SUBROUTINE coord3(X, N3TM)
      use potcm3, only : r, energy, dedr
!
      implicit none
      integer, intent(in) :: n3tm
      double precision, intent(inout) :: x(n3tm)
      integer :: m, k, l, j
!
!   This subprogram transforms the coordinates of a three-body system, ABC,
!   from atomic cartesians to interatomic distances.  
!   The integer, N3TM, passed by the calling routine must be greater than or
!   equal to 9.  
!   The convention assumed in this subprogram is as follows:
!                  X(1) - X(3) : X, Y, Z of atom A
!                  X(4) - X(6) : X, Y, Z of atom B
!                  X(7) - X(9) : X, Y, Z of atom C
!                  R(1) = R(A-B)
!                  R(2) = R(B-C)
!                  R(3) = R(C-A)
!
         M = 0
         K = -2
         L = 1
         do j = 1, 3
               M = M+1
               K = K+3
               L = L+3
               IF (j.EQ.3) L = 1
               R(M) = SQRT((X(K)-X(L))**2 + (X(K+1)-X(L+1))**2 + (X(K+2)-X(L+2))**2)
         enddo 
!
         RETURN
         END subroutine coord3
!*****
