       module cmcmod
       double precision :: D(3),RE(3),BETA(3),Z(3),DELZ,ZSLP,RM, &
       AQ1,AQ2,AQ3,AQ4,AQ5,AALP2,AALP3,AALP4,AALP5, &
       CO1,RECO,EASYM,R2,DZDR(3),ZPO(3),OP3Z(3),TOP3Z(3), &
       ZP3(3),TZP3(3),DO4Z(3),B(3), &
       R(3),ELLR,DEDR(3),RC, &
       A1(171),A2(171),A3(171),A4(171),A5(171),ALF(171), &
       BET(171),X1EQ(171),X2EQ(171),FI(171),FIJ(171),AR2,TAR2,BR2, &
       ALR2,BTR2,ATET,BTET,CTET,RH,RHC,RHS, &
       A6(171),A7(171),RCT,BTP
!
!        COMMON/LRINCM/D(3),RE(3),BETA(3),Z(3),DELZ,ZSLP,RM,
!     2       AQ1,AQ2,AQ3,AQ4,AQ5,AALP2,AALP3,AALP4,AALP5,
!     2       CO1,RECO,EASYM,R2,DZDR(3),ZPO(3),OP3Z(3),TOP3Z(3),
!     2       ZP3(3),TZP3(3),DO4Z(3),B(3)
!        COMMON/LLRCM/R(3),ELLR,DEDR(3),RC
!        COMMON/VBINCM/A1(171),A2(171),A3(171),A4(171),A5(171),ALF(171),
!     2       BET(171),X1EQ(171),X2EQ(171),FI(171),FIJ(171),AR2,TAR2,BR2
!     2       ,ALR2,BTR2,ATET,BTET,CTET,RH,RHC,RHS                       
!     2       ,A6(171),A7(171),RCT,BTP                                   
!
       end module cmcmod
                                                                        
                                                                        
        SUBROUTINE SETUP(N3TM) 
        implicit none
        integer :: n3tm
        integer,parameter :: n3tmmn=18
!        IMPLICIT DOUBLE PRECISION (A-H,O-Z) 
!        COMMON/LRINCM/D(3),RE(3),BETA(3),Z(3),DELZ,ZSLP,RM,             &
!     &       AQ1,AQ2,AQ3,AQ4,AQ5,AALP2,AALP3,AALP4,AALP5,               &
!     &       CO1,RECO,EASYM,R2,DZDR(3),ZPO(3),OP3Z(3),TOP3Z(3),         &
!     &       ZP3(3),TZP3(3),DO4Z(3),B(3)                                
!        COMMON/VBINCM/A1(171),A2(171),A3(171),A4(171),A5(171),ALF(171), &
!     &       BET(171),X1EQ(171),X2EQ(171),FI(171),FIJ(171),AR2,TAR2,BR2 &
!     &       ,ALR2,BTR2,ATET,BTET,CTET,RH,RHC,RHS                       &
!     &       ,A6(171),A7(171),RCT,BTP                                   
!       DIMENSION FC(18,18,5)                                           
!       DIMENSION AL(7),BT(7)                                           
!    The above lines were commented because the variables are not used. 
!                                                                       
!   N3TMMN = 3 * NATMAX                                                 
!   NATMAX = the number of atoms represented by this potential function 
!                                                                       
!   The variable N3TMMN is the miNImum value of N3TM allowed to be      
!   passed by the calling routine fOR the number of cartesian           
!   coordinates needed to represent the full system represented by this 
!   potential energy surface routine.                                   
!   N3TM must be greater than OR equal to N3TMMN.                       
!                                                                       
!      PARAMETER (N3TMMN = 18) 
!                                                                       
!  CHECK THE NUMBER OF CARTESIAN COORDINATES SET BY THE CALLING PROGRAM 
!                                                                       
      IF (N3TM .LT. N3TMMN) THEN 
          WRITE (6, 1000) N3TM, N3TMMN 
          STOP 'SETUP 1' 
      ENDIF 
!                                                                       
!  OPEN THE FILES WHICH CONTAIN THE POTENTIAL DATA                      
!                                                                       
       OPEN (UNIT=2, FILE='potcmc2.dat', STATUS='OLD',                  &
             FORM='FORMATTED', ERR=100)                                 
!                                                                       
       OPEN (UNIT=4, FILE='potcmc1.dat', STATUS='OLD',                  &
             FORM='FORMATTED', ERR=100)                                 
!                                                                       
        WRITE (6, 1100) 
        CALL PRELLR 
        CALL PREPOT 
!                                                                       
!  CLOSE THE POTENTIAL DATA FILES                                       
!                                                                       
       CLOSE (UNIT=2) 
       CLOSE (UNIT=4) 
!                                                                       
 1000    FORMAT(/,2X,T5,'WARNING: N3TM is set equal to ',I3,            &
                        ' but this potential routine',                  &
                /,2X,T14,'requires N3TM be greater than or ',           &
                         'equal to ',I3,/)                              
 1100   FORMAT(/,2X,T5,'Setup has been called for the ClCH3Cl ',        &
                       'surface S')                                     
!                                                                       
        RETURN 
!                                                                       
  100 WRITE(6,*)'ERROR OPENING POTENTIAL DATA FILE' 
      STOP 'SETUP 2' 
!                                                                       
      END subroutine setup                                            
!                                                                       
!     PREPOT FOR LEPSLR                                                 
      SUBROUTINE PRELLR 
      use cmcmod, only : &
      D,RE,BETA,Z,DELZ,ZSLP,RM, &
      AQ1,AQ2,AQ3,AQ4,AQ5,AALP2,AALP3,AALP4,AALP5, &
      CO1,RECO,EASYM,R2,DZDR,ZPO,OP3Z,TOP3Z, &
      ZP3,TZP3,DO4Z,B
      implicit none
      double precision :: conv2, conv3
      integer :: i
!      IMPLICIT DOUBLE PRECISION (A-H,O-Z) 

!      COMMON/LRINCM/D(3),RE(3),BETA(3),Z(3),DELZ,ZSLP,RM,               &
!     &       AQ1,AQ2,AQ3,AQ4,AQ5,AALP2,AALP3,AALP4,AALP5,               &
!     &       CO1,RECO,EASYM,R2,DZDR(3),ZPO(3),OP3Z(3),TOP3Z(3),         &
!     &       ZP3(3),TZP3(3),DO4Z(3),B(3)                                
      R2 = DSQRT(2.0D0) 
!                                                                       
!   READ POTENTIAL ENERGY SURFACE PARAMETERS                            
!        ENERGIES IN KCAL/MOL, LENGTHS IN ANGSTOMS                      
!        DELZ,ZSLP UNITLESS, RM IN ANGSTROM                             
      READ (4,501) (D(I),RE(I),BETA(I),Z(I),I = 1,3) 
      READ (4,501)  DELZ,ZSLP,RM 
  501 FORMAT (4F20.5) 
!   READ IN LONG RANGE TERM PARAMETERS                                  
!        AQ1 IN INVERSE ANGSTROM, AQ4 IN ANGSTROM                       
!        CO1 IN INVERSE ANGSTROM, RECO IN ANGSTROM                      
!        ALL ELSE UNITLESS                                              
!   NOTE:THERE IS NO AALP1, DUE TO A CHANGE IN FNAL FORM ON 8/1/88      
      READ (4,501) AQ1,AQ2,AQ3,AQ4 
      READ (4,501) AALP2,AALP3,AALP4,AALP5 
      READ (4,501) CO1,RECO,AQ5 
!                                                                       
      EASYM = 0.55149589D0 
      WRITE (6,602) D,RE,BETA,Z 
      WRITE (6,604) DELZ,ZSLP,RM 
      WRITE (6,603) AQ1,AQ2,AQ3,AQ4,AQ5,AALP2,AALP3,AALP4,AALP5,        &
         CO1,RECO,EASYM                                                 
  602 FORMAT (/,2X,T5,'Potential energy surface parameters for VLEPS',  &
              /,2X,T5, 'Bond', T47, 'ClMe', T58, 'MeCl', T69, 'ClCl',   &
              /, 2X, T5, 'Dissociation energies (kcal/mol):',           &
              T44, F10.5, T55, F10.5, T66, F10.5,                       &
              /, 2X, T5, 'Equilibrium bond lengths (Angstroms):',       &
              T44, F10.5, T55, F10.5, T66, F10.5,                       &
              /, 2X, T5, 'Morse beta parameters (Angstroms**-1):',      &
              T44, F10.5, T55, F10.5, T66, F10.5,                       &
              /, 2X, T5, 'Sato parameters:',                            &
              T44, F10.5, T55, F10.5, T66, F10.5)                       
!                                                                       
  603 FORMAT(/,2X,T5,'Parameters for the long range term',              &
             /,2X,T5,'Charge fit coeff. (1-5)',T44,3(F10.5,1X),         &
             /,2X,T44,2(F10.5,1X),                                      &
             /,2X,T5,'Polarizability fit coeff. (1-4)',                 &
                  T44,3(F10.5,1X),/,2X,T44,F10.5,                       &
             /,2X,T5,'Cut off coeff. (1,2)',T44,2(F10.5,1X),            &
             /,2X,T5,'Reactant energy',T44,F13.8)                       
  604 FORMAT (/,2X,T5,'Sato switching',T44,3(F10.5,1X)) 
      DO I = 1,3 
!   CONVERT TO ATOMIC UNITS                                             
        D(I)=D(I)/627.5095D0 
        RE(I) = RE(I)/0.52917706D0 
        BETA(I) = BETA(I)*0.52917706D0 
      END DO 
      RM = RM/0.52917706D0 
      ZSLP = ZSLP*0.52917706D0 
!   COMPUTE USEFUL CONSTANTS                                            
      DZDR(3) = 0.D0 
      ZPO(3) = 1.0D0 + Z(3) 
      OP3Z(3) = 1.0D0 + 3.0D0*Z(3) 
      TOP3Z(3) = 2.0D0*OP3Z(3) 
      ZP3(3) = Z(3) + 3.0D0 
      TZP3(3) = 2.0D0*ZP3(3) 
      DO4Z(3) = D(3)/4.0D0/ZPO(3) 
      B(3) = BETA(3)*DO4Z(3)*2.0D0 
!   CONVERT LONG RANGE PARAMETERS TO ATOMIC UNITS ALSO                  
      CONV2 = (0.52917706D0)**2 
      CONV3 = (0.52917706D0)*CONV2 
      AQ1 = AQ1*0.52917706D0 
      AQ4 = AQ4/0.52917706D0 
      AQ5 = AQ5*CONV2 
      AALP2 = AALP2/CONV3 
      AALP3 = AALP3/CONV3 
      AALP4 = AALP4/CONV3 
      AALP5 = AALP5/CONV3 
      CO1 = CO1*0.52917706D0 
      RECO = RECO/0.52917706D0 
      EASYM = EASYM/627.5095D0 
       write(6,*) 'easym',easym 
      RETURN 
      END SUBROUTINE PRELLR 

        SUBROUTINE PREPOT 
        use cmcmod, only : &
        D,RE,BETA,Z,DELZ,ZSLP,RM, &
        AQ1,AQ2,AQ3,AQ4,AQ5,AALP2,AALP3,AALP4,AALP5, &
        CO1,RECO,EASYM,R2,DZDR,ZPO,OP3Z,TOP3Z, &
        ZP3,TZP3,DO4Z,B, &
        A1,A2,A3,A4,A5,ALF, &
        BET,X1EQ,X2EQ,FI,FIJ,AR2,TAR2,BR2, &
        ALR2,BTR2,ATET,BTET,CTET,RH,RHC,RHS, &
        A6,A7,RCT,BTP
        implicit none
        double precision :: FC(18,18,5),AL(7),BT(7)
        double precision :: AD13,AD15,AD23,AD25,AD41,ANGBOR
        double precision :: ARG,ARGLN,ATH,ATH2,ATH4,BRANG2,CA2
        double precision :: D12,D13,D15,D21,D23,D25,D35,D42,D43,D45,DA5A1,DG2,DG4,DUM
        double precision :: G2,G4,GAM6,GAM7,GAUS2,GAUS4,GT,GTIL2,GTIL4
        double precision :: PI,POLY
        double precision :: RA2515,RA4151,RADCN,RAT,RCE4,RCE8,RCF,RCT2
        double precision :: X16,X17,XINV,TH2,TH4,TPRT
        integer :: MAXRD,NDUM,NIJ
        integer :: i,j,k
!
!        IMPLICIT DOUBLE PRECISION (A-H,O-Z) 
!
!        COMMON/LRINCM/D(3),RE(3),BETA(3),Z(3),DELZ,ZSLP,RM,             &
!     &       AQ1,AQ2,AQ3,AQ4,AQ5,AALP2,AALP3,AALP4,AALP5,               &
!     &       CO1,RECO,EASYM,R2,DZDR(3),ZPO(3),OP3Z(3),TOP3Z(3),         &
!     &       ZP3(3),TZP3(3),DO4Z(3),B(3)                                
!        COMMON/VBINCM/A1(171),A2(171),A3(171),A4(171),A5(171),ALF(171), &
!     &       BET(171),X1EQ(171),X2EQ(171),FI(171),FIJ(171),AR2,TAR2,BR2 &
!     &       ,ALR2,BTR2,ATET,BTET,CTET,RH,RHC,RHS                       &
!     &       ,A6(171),A7(171),RCT,BTP                                   
!        DIMENSION FC(18,18,5) 
!        DIMENSION AL(7),BT(7) 
!       READ IN OTHER CONSTANTS, AND CONVERT TO ATOMIC UNITS            
        READ(2,462) AR2,BR2,ALR2,BTR2 
        READ(2,462) ATET,BTET,CTET 
        READ(2,462) RH 
  462   FORMAT(4F20.5) 
        WRITE(6,463) AR2,BR2,ALR2,BTR2,ATET,BTET,CTET,RH 
  463   FORMAT(/,1X,'Parameters for the equilibrium cartesian coords ', &
         'as a fcn of RC',/1X,'for R2',14X,4F10.5/1X,'for THETA',11X,   &
          3F10.5/1X,'CH distance',9X,1F10.5/)                           
!       CONVERT TO ATOMIC UNITS AND RADIANS                             
        BRANG2 = 0.52917706D0*0.52917706D0 
        ANGBOR = 1.D0/0.52917706D0 
        PI = ACOS(-1.0D0) 
        RADCN = PI/180.D0 
        AR2 = AR2*ANGBOR 
        BR2 = BR2*ANGBOR 
        ALR2 = ALR2*ANGBOR 
        BTR2 = BTR2*BRANG2 
        ATET = ATET*RADCN 
        BTET = BTET*0.52917706D0 
        CTET = CTET*RADCN 
        RH = RH*ANGBOR 
!       COMPUTE USEFUL CONSTANTS                                        
        TAR2 = 2.0D0 * AR2 
        RHC = RH*0.5D0 
        RHS = RH*SQRT(3.D0)*0.5D0 
!       READ IN CARTESIAN FORCE CONTSTANTS FROM ABINITIO CALCULATIONS   
        DO I=1,18 
          IF(I.LE.5)THEN 
            MAXRD = I 
          ELSE 
            MAXRD = 5 
          END IF 
          DO K=1,5 
            READ(2,500) NDUM,(FC(I,J,K),J=1,MAXRD) 
          ENDDO
        ENDDO
  500   FORMAT(I3,5F14.6) 
        DO I=6,18 
          IF(I.LE.10)THEN 
            MAXRD = I 
          ELSE 
            MAXRD = 10 
          END IF 
          DO K=1,5 
            READ(2,500) NDUM,(FC(I,J,K),J=6,MAXRD) 
          ENDDO
        ENDDO
        DO I=11,18 
          IF(I.LE.15)THEN 
            MAXRD = I 
          ELSE 
            MAXRD = 15 
          END IF 
          DO K=1,5 
            READ(2,500) NDUM,(FC(I,J,K),J=11,MAXRD) 
          ENDDO
        ENDDO
        DO I=16,18 
          DO K=1,5 
            READ(2,500) NDUM,(FC(I,J,K),J=16,I) 
          ENDDO
        ENDDO
!       COMPUTE FITS TO FORCE CONSTANTS, IN EH/A0**2                    
        BTP = 0.25D0 
        RCT =  2.54273315D0 
        RCF =  -RCT 
        RCT2 = RCT*RCT 
        RCE4 = EXP(-4.D0*RCT2) 
        RCE8 = RCE4*RCE4 
        DUM = 1.0D0 
        AL(1) = 0.403D0 
        AL(3) = 0.234D0 
        AL(6) = 0.88D0 
        AL(7) = 0.40D0 
        BT(3) = 0.58D0 
        BT(6) = 0.7D0 
        BT(7) = 0.15D0 
        GAM6 = 1.18D0 
        GAM7 = 2.20D0 
        X16 = -2.14D0 
        X17 = -2.40D0 
        DO I=1,18 
         DO J=1,I 
           NIJ = ((I*I - I)/2  + 1 + (J-1) ) 
           DA5A1 = ABS(FC(I,J,5)) - ABS(FC(I,J,1)) 
           D15 = FC(I,J,1) - FC(I,J,5) 
           D13 = FC(I,J,1) - FC(I,J,3) 
           AD15 = ABS(D15) 
           AD13 = ABS(D13) 
           AD23 = ABS(FC(I,J,2) - FC(I,J,3)) 
           AD25 = ABS(FC(I,J,2) - FC(I,J,5)) 
           AD41 = ABS(FC(I,J,4) - FC(I,J,1)) 
          IF(D13.NE.0.0D0)THEN 
           IF(DA5A1.EQ.0.D0)THEN 
             FI(NIJ) = FC(I,J,3) 
             FIJ(NIJ) = D13 
             IF(AD15.EQ.0.0D0)THEN 
               IF(AD13.LT.AD23)THEN 
                 A1(NIJ) = 1.0D0 
                 A2(NIJ) = -1.0D0 
                 A3(NIJ) = 0.0D0 
                 A5(NIJ) = 0.0D0 
                 A6(NIJ) = 0.0D0 
                 A7(NIJ) = 0.0D0 
                 X1EQ(NIJ) = 0.0D0 
                 X2EQ(NIJ) = DUM 
                 ALF(NIJ) = AL(1) 
                 BET(NIJ) = DUM 
                 XINV = 1.0D0/RCT2 
                 D21 = FC(I,J,2) - FC(I,J,1) 
                 GT = 1.D0 + EXP( AL(1)*RCT2 ) * (D21/D13) 
                 A4(NIJ) = XINV * GT 
               ELSE 
                 A1(NIJ) = 1.0D0 
                 A2(NIJ) = -1.0D0 
                 A3(NIJ) = 0.0D0 
                 A4(NIJ) = 0.0D0 
                 A5(NIJ) = 0.0D0 
                 A6(NIJ) = 0.0D0 
                 A7(NIJ) = 0.0D0 
                 X1EQ(NIJ) = 0.0D0 
                 X2EQ(NIJ) = DUM 
                 D12 = FC(I,J,1) - FC(I,J,2) 
                 RAT = (D12/D13) 
                 ALF(NIJ) = -(1.0D0/RCT2)*LOG(RAT) 
                 BET(NIJ) = DUM 
               END IF 
             ELSE 
               IF(AD13.LT.AD23)THEN 
                 A1(NIJ) = 0.0D0 
                 A2(NIJ) = 0.0D0 
                 A4(NIJ) = 0.0D0 
                 A5(NIJ) = 1.0D0 
                 A6(NIJ) = 0.0D0 
                 A7(NIJ) = 0.0D0 
                 X1EQ(NIJ) = 0.0D0 
                 X2EQ(NIJ) = 0.0D0 
                 ALF(NIJ) = AL(3) 
                 BET(NIJ) = BT(3) 
                 TH2 = TANH( BT(3) * RCT ) 
                 D23 = FC(I,J,2) - FC(I,J,3) 
                 RAT = EXP( AL(3)*RCT2 ) / RCT 
                 A3(NIJ) = RAT * ( (D23/D13) - TH2 ) 
               ELSE 
                 A1(NIJ) = 0.0D0 
                 A2(NIJ) = 0.0D0 
                 A3(NIJ) = 0.0D0 
                 A4(NIJ) = 0.0D0 
                 A5(NIJ) = 1.0D0 
                 A6(NIJ) = 0.0D0 
                 A7(NIJ) = 0.0D0 
                 X1EQ(NIJ) = DUM 
                 X2EQ(NIJ) = 0.0D0 
                 ALF(NIJ) = DUM 
                 D23 = FC(I,J,2) - FC(I,J,3) 
                 RAT = D23/D13 
                 ATH = 0.5D0*LOG((1.D0 + RAT)/(1.D0 - RAT)) 
                 BET(NIJ) = (1.D0/RCT) * ATH 
               END IF 
             END IF 
           ELSE 
             FI(NIJ) = FC(I,J,5) 
             FIJ(NIJ) = D15 
             RA2515 = AD25/AD15 
             RA4151 = AD41/AD15 
             IF(RA2515.GT.1.05D0)THEN 
               IF(FC(I,J,1).EQ.0.0D0) THEN 
                 A1(NIJ) = 0.50D0 
                 A3(NIJ) = 0.0D0 
                 A4(NIJ) = 0.0D0 
                 A5(NIJ) = 0.50D0 
                 ALF(NIJ) = AL(6) 
                 BET(NIJ) = BT(6) 
                 X1EQ(NIJ) = - X16 
                 D21 = FC(I,J,2) - FC(I,J,1) 
                 A2(NIJ) = GAM6 * (D21/D15) 
                 CA2 = A2(NIJ) * EXP(-AL(6) * X16 * X16 ) 
                 D35 = FC(I,J,3) - FC(I,J,5) 
                 RAT = D35 / D15 
                 ARGLN = (RAT - CA2)/(1.0D0 - RAT + CA2) 
                 X2EQ(NIJ) = - LOG(ARGLN) / (2.0D0 * BT(6)) 
                 GTIL4 = .5D0 + .5D0*TANH(BET(NIJ)*(RCF-X2EQ(NIJ)))     &
                        + A2(NIJ)*EXP(-ALF(NIJ)*(RCF-X1EQ(NIJ))**2)     
                 GTIL2 = .5D0 + .5D0*TANH(BET(NIJ)*(RCT-X2EQ(NIJ)))     &
                        + A2(NIJ)*EXP(-ALF(NIJ)*(RCT-X1EQ(NIJ))**2)     
                 D25 = FC(I,J,2) - FC(I,J,5) 
                 D45 = FC(I,J,4) - FC(I,J,5) 
                 G2 = D25/D15 
                 G4 = D45/D15 
                 DG2 = G2 - GTIL2 
                 DG4 = G4 - GTIL4 
                 A6(NIJ) = (DG2 + DG4*RCE4)/(RCF*(RCE8 - 1.D0) ) 
                 A7(NIJ) = (DG4 + DG2*RCE4)/(RCT*(RCE8 - 1.D0) ) 
               ELSE 
                 A1(NIJ) = 0.50D0 
                 A3(NIJ) = 0.0D0 
                 A4(NIJ) = 0.0D0 
                 A5(NIJ) = 0.50D0 
                 ALF(NIJ) = AL(7) 
                 BET(NIJ) = BT(7) 
                 X1EQ(NIJ) = - X17 
                 D21 = FC(I,J,2) - FC(I,J,1) 
                 A2(NIJ) = GAM7 * (D21/D15) 
                 CA2 = A2(NIJ) * EXP(-AL(7) * X17 * X17 ) 
                 D35 = FC(I,J,3) - FC(I,J,5) 
                 RAT = D35 / D15 
                 ARGLN = (RAT - CA2)/(1.0D0 - RAT + CA2) 
                 X2EQ(NIJ) = - LOG(ARGLN) / (2.0D0 * BT(7)) 
                 GTIL4 = .5D0 + .5D0*TANH(BET(NIJ)*(RCF-X2EQ(NIJ)))     &
                        + A2(NIJ)*EXP(-ALF(NIJ)*(RCF-X1EQ(NIJ))**2)     
                 GTIL2 = .5D0 + .5D0*TANH(BET(NIJ)*(RCT-X2EQ(NIJ)))     &
                        + A2(NIJ)*EXP(-ALF(NIJ)*(RCT-X1EQ(NIJ))**2)     
                 D25 = FC(I,J,2) - FC(I,J,5) 
                 D45 = FC(I,J,4) - FC(I,J,5) 
                 G2 = D25/D15 
                 G4 = D45/D15 
                 DG2 = G2 - GTIL2 
                 DG4 = G4 - GTIL4 
                 A6(NIJ) = (DG2 + DG4*RCE4)/(RCF*(RCE8 - 1.D0) ) 
                 A7(NIJ) = (DG4 + DG2*RCE4)/(RCT*(RCE8 - 1.D0) ) 
               END IF 
             ELSE 
               IF(RA4151.GT.1.05D0)THEN 
                 IF(FC(I,J,5).EQ.0.0D0)THEN 
                   A1(NIJ) = 0.50D0 
                   A3(NIJ) = 0.0D0 
                   A4(NIJ) = 0.0D0 
                   A5(NIJ) = 0.50D0 
                   ALF(NIJ) = AL(6) 
                   BET(NIJ) = BT(6) 
                   X1EQ(NIJ) = X16 
                   D45 = FC(I,J,4) - FC(I,J,5) 
                   A2(NIJ) = GAM6 * (D45/D15) 
                   CA2 = A2(NIJ) * EXP(-AL(6) * X16 * X16 ) 
                   D35 = FC(I,J,3) - FC(I,J,5) 
                   RAT = D35 / D15 
                   ARGLN = (RAT - CA2)/(1.0D0 - RAT + CA2) 
                   X2EQ(NIJ) = - LOG(ARGLN) / (2.0D0 * BT(6)) 
                   GTIL4 = .5D0 + .5D0*TANH(BET(NIJ)*(RCF-X2EQ(NIJ)))   &
                        + A2(NIJ)*EXP(-ALF(NIJ)*(RCF-X1EQ(NIJ))**2)     
                   GTIL2 = .5D0 + .5D0*TANH(BET(NIJ)*(RCT-X2EQ(NIJ)))   &
                        + A2(NIJ)*EXP(-ALF(NIJ)*(RCT-X1EQ(NIJ))**2)     
                   D25 = FC(I,J,2) - FC(I,J,5) 
                   D45 = FC(I,J,4) - FC(I,J,5) 
                   G2 = D25/D15 
                   G4 = D45/D15 
                   DG2 = G2 - GTIL2 
                   DG4 = G4 - GTIL4 
                   A6(NIJ) = (DG2 + DG4*RCE4)/(RCF*(RCE8 - 1.D0) ) 
                   A7(NIJ) = (DG4 + DG2*RCE4)/(RCT*(RCE8 - 1.D0) ) 
                 ELSE 
                   A1(NIJ) = 0.50D0 
                   A3(NIJ) = 0.0D0 
                   A4(NIJ) = 0.0D0 
                   A5(NIJ) = 0.50D0 
                   ALF(NIJ) = AL(7) 
                   BET(NIJ) = BT(7) 
                   X1EQ(NIJ) = X17 
                   D45 = FC(I,J,4) - FC(I,J,5) 
                   A2(NIJ) = GAM7 * (D45/D15) 
                   CA2 = A2(NIJ) * EXP(-AL(7) * X17 * X17 ) 
                   D35 = FC(I,J,3) - FC(I,J,5) 
                   RAT = D35 / D15 
                   ARGLN = (RAT - CA2)/(1.0D0 - RAT + CA2) 
                   X2EQ(NIJ) = - LOG(ARGLN) / (2.0D0 * BT(7)) 
                   GTIL4 = .5D0 + .5D0*TANH(BET(NIJ)*(RCF-X2EQ(NIJ)))   &
                        + A2(NIJ)*EXP(-ALF(NIJ)*(RCF-X1EQ(NIJ))**2)     
                   GTIL2 = .5D0 + .5D0*TANH(BET(NIJ)*(RCT-X2EQ(NIJ)))   &
                        + A2(NIJ)*EXP(-ALF(NIJ)*(RCT-X1EQ(NIJ))**2)     
                   D25 = FC(I,J,2) - FC(I,J,5) 
                   D45 = FC(I,J,4) - FC(I,J,5) 
                   G2 = D25/D15 
                   G4 = D45/D15 
                   DG2 = G2 - GTIL2 
                   DG4 = G4 - GTIL4 
                   A6(NIJ) = (DG2 + DG4*RCE4)/(RCF*(RCE8 - 1.D0) ) 
                   A7(NIJ) = (DG4 + DG2*RCE4)/(RCT*(RCE8 - 1.D0) ) 
                 END IF 
               ELSE 
                 A1(NIJ) = 0.50D0 
                 A3(NIJ) = 0.0D0 
                 A4(NIJ) = 0.0D0 
                 A5(NIJ) = 0.50D0 
                 A6(NIJ) = 0.0D0 
                 A7(NIJ) = 0.0D0 
                 X1EQ(NIJ) = 0.0D0 
                 X2EQ(NIJ) = 0.0D0 
                 D35 = FC(I,J,3) - FC(I,J,5) 
                 D25 = FC(I,J,2) - FC(I,J,5) 
                 D42 = FC(I,J,4) - FC(I,J,2) 
                 A2(NIJ) = (D35/D15) - 0.5D0 
                 RAT = (D15 + D42)/(D15 - D42) 
                 BET(NIJ) = -(0.5D0/RCT)*LOG(RAT) 
                 TPRT = 0.5D0 + 0.5D0*TANH(BET(NIJ)*RCT) 
                 ARG = ( (D25/D15) - TPRT )/A2(NIJ) 
                 IF (ARG.LE.0.0D0) THEN 
!                 this applies only to (4,1),(5,2),(16,1) and (17,2)    
!                 which are related by symmetry. Later try to fit with  
!                 one of the type 6 forms?                              
                  ALF(NIJ) = 1.0D0 
                 ELSE 
                 ALF(NIJ) = - (1.D0/RCT2)*LOG(ARG) 
                 END IF 
               END IF 
             END IF 
           END IF 
          ELSE 
            A1(NIJ) = 0.0D0 
            A2(NIJ) = 0.0D0 
            A3(NIJ) = 0.0D0 
            A4(NIJ) = 0.0D0 
            A5(NIJ) = 0.0D0 
            A6(NIJ) = 0.0D0 
            A7(NIJ) = 0.0D0 
            X1EQ(NIJ) = DUM 
            X2EQ(NIJ) = DUM 
            ALF(NIJ) = DUM 
            BET(NIJ) = DUM 
            FI(NIJ) = FC(I,J,1) 
            FIJ(NIJ) = 0.0D0 
          END IF 
          IF(NIJ.EQ.7.OR.NIJ.EQ.12.OR.NIJ.EQ.121.OR.NIJ.EQ.138)THEN 
            POLY = A2(NIJ) 
            GAUS2 = EXP(-ALF(NIJ)*(RCT-X1EQ(NIJ))**2) 
            GAUS4 = EXP(-ALF(NIJ)*(RCF-X1EQ(NIJ))**2) 
            ATH2 = BET(NIJ)*(RCT-X2EQ(NIJ)) 
            ATH4 = BET(NIJ)*(RCF-X2EQ(NIJ)) 
            TH2 = A5(NIJ)*TANH(ATH2) 
            TH4 = A5(NIJ)*TANH(ATH4) 
            GTIL2 = A1(NIJ) + GAUS2*POLY + TH2 
            GTIL4 = A1(NIJ) + GAUS4*POLY + TH4 
            D15 = FC(I,J,1) - FC(I,J,5) 
            D25 = FC(I,J,2) - FC(I,J,5) 
            D45 = FC(I,J,4) - FC(I,J,5) 
            G2 = D25/D15 
            G4 = D45/D15 
            DG2 = G2 - GTIL2 
            DG4 = G4 - GTIL4 
            A6(NIJ) = (DG2 + DG4*RCE4)/(RCF*(RCE8 - 1.D0) ) 
            A7(NIJ) = (DG4 + DG2*RCE4)/(RCT*(RCE8 - 1.D0) ) 
          END IF 
          IF(NIJ.EQ.36.OR.NIJ.EQ.64.OR.NIJ.EQ.100)THEN 
            ALF(36) = 1.0 
            BET(64) = ABS(BET(64)) 
            BET(100) = ABS(BET(100)) 
            POLY = A2(NIJ) 
            GAUS2 = EXP(-ALF(NIJ)*(RCT-X1EQ(NIJ))**2) 
            GAUS4 = EXP(-ALF(NIJ)*(RCF-X1EQ(NIJ))**2) 
            ATH2 = BET(NIJ)*(RCT-X2EQ(NIJ)) 
            ATH4 = BET(NIJ)*(RCF-X2EQ(NIJ)) 
            TH2 = A5(NIJ)*TANH(ATH2) 
            TH4 = A5(NIJ)*TANH(ATH4) 
            GTIL2 = A1(NIJ) + GAUS2*POLY + TH2 
            GTIL4 = A1(NIJ) + GAUS4*POLY + TH4 
            D13 = FC(I,J,1) - FC(I,J,3) 
            D23 = FC(I,J,2) - FC(I,J,3) 
            D43 = FC(I,J,4) - FC(I,J,3) 
            G2 = D23/D13 
            G4 = D43/D13 
            DG2 = G2 - GTIL2 
            DG4 = G4 - GTIL4 
            A6(NIJ) = (DG2 + DG4*RCE4)/(RCF*(RCE8 - 1.D0) ) 
            A7(NIJ) = (DG4 + DG2*RCE4)/(RCT*(RCE8 - 1.D0) ) 
          END IF 
         ENDDO
        ENDDO
        RETURN 
      END SUBROUTINE PREPOT 
!                                                                       
!   ClCH3Cl (gas-phase) potential energy surface S of Tucker et al.     
!                                                                       
        SUBROUTINE SURF(V, X, DX, N3TM) 
        use cmcmod
        implicit none
        integer, intent(in) :: N3TM
        double precision :: ATH, BRC, CORR, CORRT, CSHBRC, CTETA, DCTET, DFDRP, DRPDRC,  &
        DSTET, EVIB, EXR2, G, GAUS, GAUS2, GAUS4, &
        POLY, R1F, R1S, R2F, R2S, R3S, RC2, RPD, RPD2, RPG, STETA, SUM0, SUM1, SUM2, SUM3, &
        SUMI, SUMK, T2R2, TETA, TG6, TH, TR2, TRM1, TRM12, TRM2, TRM3, TRM6, TRMC, TRMC1, TRMC2
        double precision :: V
        double precision :: X(N3TM), DX(N3TM)
        double precision :: FFIT(18,18)
        double precision :: DR1DX(18),DR2DX(18),DR3DX(18),XND(18),XN(18),X0(18)
        double precision :: DU3BDX(18),DUVBDX(18),DUVBDY(18)
        double precision :: DRCDX(18),DX0DRC(18),DFDRC(18,18),DKDX(18)
        integer :: ix, i, j
        integer ::  ID, IE, IY, IZ, JE, KD, KK, NIJ
!        IMPLICIT DOUBLE PRECISION (A-H,O-Z) 
!        COMMON/LRINCM/D(3),RE(3),BETA(3),Z(3),DELZ,ZSLP,RM,             &
!     &       AQ1,AQ2,AQ3,AQ4,AQ5,AALP2,AALP3,AALP4,AALP5,               &
!     &       CO1,RECO,EASYM,R2,DZDR(3),ZPO(3),OP3Z(3),TOP3Z(3),         &
!     &       ZP3(3),TZP3(3),DO4Z(3),B(3)                                
!        COMMON/LLRCM/R(3),ELLR,DEDR(3),RC 
!        COMMON/VBINCM/A1(171),A2(171),A3(171),A4(171),A5(171),ALF(171), &
!     &       BET(171),X1EQ(171),X2EQ(171),FI(171),FIJ(171),AR2,TAR2,BR2 &
!     &       ,ALR2,BTR2,ATET,BTET,CTET,RH,RHC,RHS                       &
!     &       ,A6(171),A7(171),RCT,BTP                                   
!        DIMENSION X(N3TM), DX(N3TM) 
!        DIMENSION FFIT(18,18) 
!        DIMENSION DR1DX(18),DR2DX(18),DR3DX(18),XND(18),XN(18),X0(18) 
!        DIMENSION DU3BDX(18),DUVBDX(18),DUVBDY(18) 
!        DIMENSION DRCDX(18),DX0DRC(18),DFDRC(18,18),DKDX(18) 
!       FIND NEW X,Y,Z COORDINATES, XN                                  
        DO IX=1,16,3 
          IY = IX + 1 
          IZ = IX + 2 
          XN(IX) = X(IX) - X(1) 
          XN(IY) = X(IY) - X(2) 
          XN(IZ) = X(IZ) - X(3) 
        ENDDO
!       FIND R1,R2,R3                                                   
        R1S = (X(1)-X(4))**2 + (X(2)-X(5))**2 + (X(3)-X(6))**2 
        R2S = (X(1)-X(16))**2 + (X(2)-X(17))**2 + (X(3)-X(18))**2 
        R3S = (X(4)-X(16))**2 + (X(5)-X(17))**2 + (X(6)-X(18))**2 
        R(1) = SQRT(R1S) 
        R(2) = SQRT(R2S) 
        R(3) = SQRT(R3S) 
!       FIND RC,RC2, AND THE 3 BODY ENREGY AND DERIVATIVES              
        CALL POTLLR 
        RC2 = RC*RC 
        write(6,*) Rc2 
!       EVALUATE THE NIJ CARTESIAN FORCE CONSTANTS AT RC                
!       ALSO EVALUATE THE NIJ DERIVATIVES OF THESE FORCE CONTSTS. W.R.T.
        DO I=1,18 
          DO J=1,I 
            NIJ = ((I*I - I)/2  + 1 + (J-1) ) 
            POLY = A2(NIJ) + A3(NIJ)*RC + A4(NIJ)*RC2 
            GAUS = EXP(-ALF(NIJ)*(RC-X1EQ(NIJ))**2) 
            GAUS2 = EXP(-(RC-RCT)**2) 
            GAUS4 = EXP(-(RC+RCT)**2) 
            CORRT = (A6(NIJ)*GAUS2 + A7(NIJ)*GAUS4) 
            CORR = RC * CORRT 
            ATH = BET(NIJ)*(RC-X2EQ(NIJ)) 
            TH = A5(NIJ)*TANH(ATH) 
            G = A1(NIJ) + GAUS*POLY + TH + CORR 
            FFIT(I,J) = FI(NIJ) + FIJ(NIJ)*G 
            TRM1 = -2.D0*ALF(NIJ)*(RC-X1EQ(NIJ))*POLY 
            TRM2 = A3(NIJ) + 2.0D0*A4(NIJ)*RC 
            TRM12 = GAUS*(TRM1 + TRM2) 
            TRMC1 = -2.D0*(RC-RCT)*A6(NIJ)*GAUS2 
            TRMC2 = -2.D0*(RC+RCT)*A7(NIJ)*GAUS4 
            TRMC = CORRT + RC * (TRMC1 + TRMC2) 
            IF(ABS(ATH).GE.44.44D0) THEN 
             TRM3 = 0.D0 
            ELSE 
             TRM3 = BET(NIJ)*A5(NIJ)/(COSH(ATH)*COSH(ATH)) 
            END IF 
            DFDRC(I,J) = FIJ(NIJ)*( TRM12 + TRM3 + TRMC ) 
          ENDDO
        ENDDO
!       NOW FIND THE EQUILIBRIUM VALUES OF X(I) AT RC                   
!       COMPUTE R1(RC),R2(RC) AND THETA(RC)                             
        TR2 = RC/TAR2 
        T2R2 = SQRT(TR2*TR2 + 1.0D0) 
        EXR2 = ALR2 * EXP(-BTR2*RC2) 
        R2F = AR2 * ( TR2 + T2R2 ) + BR2 + EXR2 
        R1F = R2F - RC 
        TETA = -ATET*TANH(BTET*RC) + CTET 
        STETA = SIN(TETA) 
        CTETA = COS(TETA) 
!       EVALUATE THE CORRECTION TO K(18,6)                              
        RPD = R(3) - (R1F + R2F) 
        RPD2 = RPD**2 
        RPG = EXP(-BTP*RPD2) 
        DFDRP = - FFIT(18,6) * 2.0*BTP*RPD * RPG 
        FFIT(18,6) = FFIT(18,6)*RPG 
!       EVALUATE THE EQUILIBRIUM VALUES                                 
        X0(1) =  0.D0 
        X0(2) =  0.D0 
        X0(3) =  0.D0 
        X0(4) =  0.D0 
        X0(5) =  0.D0 
        X0(6) =  R1F 
        X0(7) =  RH*STETA 
        X0(8) =  0.D0 
        X0(9) = -RH*CTETA 
        X0(10) = -RHC*STETA 
        X0(11) = -RHS*STETA 
        X0(12) = -RH*CTETA 
        X0(13) = -RHC*STETA 
        X0(14) =  RHS*STETA 
        X0(15) = -RH*CTETA 
        X0(16) = 0.D0 
        X0(17) = 0.D0 
        X0(18) = -R2F 
!       NOW EVALUATE THE DISPLACEMENT CARTESIANS, XND                   
        DO IX=1,18 
          XND(IX) = XN(IX) - X0(IX) 
        ENDDO
!       NOW EVALUATE UVIB                                               
!       NOTE THAT BECAUSE WE FIX C AT (0,0,0), XND(1)-XND(3) ARE ALWAYS 
!       ZERO, AND THUS WE EXCLUDE THEM FROM THE ENERGY SUM. NOTE THAT   
!       THE ASSOCIATED FORCE CONSTANTS, ALTHOUGH THEY PLAY NO ROLE IN TH
!       ENERGY DETERMINATION, DO HELP DETERMINE THE DERIVATIVES.        
        SUM1 = 0.0D0 
        DO IE=4,18 
          DO JE=4,IE 
            SUM1 = SUM1 + FFIT(IE,JE)*XND(IE)*XND(JE) 
          ENDDO
        ENDDO
        SUM2 = 0.0D0 
        DO IE=4,18 
          SUM2 = SUM2 + 0.5D0*FFIT(IE,IE)*XND(IE)*XND(IE) 
        ENDDO
        EVIB = SUM1 - SUM2 
!       ADD UVIB AND ULLR                                               
        V = EVIB + ELLR 
!       NOW EVALUATE (BY THE CHAIN RULE) DULLR/DXI                      
        DO ID=1,3 
          DR1DX(ID) = (X(ID) - X(ID+3))/R(1) 
          DR2DX(ID) = (X(ID) - X(ID+15))/R(2) 
        ENDDO
        DO ID=4,6 
          DR1DX(ID) = (X(ID) - X(ID-3))/R(1) 
          DR3DX(ID) = (X(ID) - X(ID+12))/R(3) 
        ENDDO
        DO ID=16,18 
          DR2DX(ID) = (X(ID) - X(ID-15))/R(2) 
          DR3DX(ID) = (X(ID) - X(ID-12))/R(3) 
        ENDDO
        DO ID=1,3 
          DU3BDX(ID) = DEDR(1)*DR1DX(ID) + DEDR(2)*DR2DX(ID) 
        ENDDO
        DO ID=4,6 
          DU3BDX(ID) = DEDR(1)*DR1DX(ID) + DEDR(3)*DR3DX(ID) 
        ENDDO
        DO ID=16,18 
          DU3BDX(ID) = DEDR(2)*DR2DX(ID) + DEDR(3)*DR3DX(ID) 
        ENDDO
        DO ID=7,15 
          DU3BDX(ID) = 0.0D0 
        ENDDO
!       FIND DRC/DX(KD) FOR KD=1-6,16-18                                
        DO KD=1,3 
         DRCDX(KD) = DR2DX(KD) - DR1DX(KD) 
        ENDDO
        DO KD=4,6 
         DRCDX(KD) =  - DR1DX(KD) 
        ENDDO
        DO KD=16,18 
         DRCDX(KD) = DR2DX(KD) 
        ENDDO
!       FIND DX0(KD)/DRC                                                
        DO KD=1,5 
         DX0DRC(KD) = 0.D0 
        ENDDO
        TG6 = 2.D0*BTR2*RC*EXR2 
        TRM6 = TR2/T2R2 
        BRC = BTET*RC 
        IF(ABS(BRC).GE.44.44D0) THEN 
          CSHBRC = 0.D0 
        ELSE 
          CSHBRC = 1.D0/(COSH(BRC)*COSH(BRC)) 
        END IF 
        DSTET = -ATET*BTET*CTETA*CSHBRC 
        DCTET =  ATET*BTET*STETA*CSHBRC 
        DX0DRC(6) = -0.5D0*(1.D0 - TRM6) - TG6 
        DX0DRC(7) = RH*DSTET 
        DX0DRC(8) = 0.D0 
        DX0DRC(9) = -RH*DCTET 
        DX0DRC(10) = -RHC*DSTET 
        DX0DRC(11) = -RHS*DSTET 
        DX0DRC(12) = DX0DRC(9) 
        DX0DRC(13) = DX0DRC(10) 
        DX0DRC(14) = -DX0DRC(11) 
        DX0DRC(15) = DX0DRC(9) 
        DX0DRC(16) = 0.D0 
        DX0DRC(17) = 0.D0 
        DX0DRC(18) = -0.5D0*(1.D0 + TRM6) + TG6 
!       EVALUATE D(R30)/D(RC) WHICH IS NEEDED FOR DFDRC(18,6)           
        DRPDRC = DX0DRC(6) - DX0DRC(18) 
        DFDRC(18,6) = DFDRC(18,6) * RPG - DFDRP*DRPDRC 
!       NOW EVALUATE DUVIB/DXND(K)                                      
        DO KD=1,18 
         SUM3 = 0.0D0 
         DO ID=1,KD 
           SUM3 = SUM3 + FFIT(KD,ID) * XND(ID) 
         ENDDO
         DO ID=KD+1,18 
           SUM3 = SUM3 + FFIT(ID,KD) * XND(ID) 
         ENDDO
         DUVBDX(KD) = SUM3 
        ENDDO
!       CORRECT THE DERIVATIVES OF X(1),X(2),X(3) FOR THE FACT THAT WE  
!       NEED THE DERIVATIVE WITH RESPECT TO X, NOT WITH RESPECT TO XN   
        SUM1 = 0.D0 
        SUM2 = 0.D0 
        SUM3 = 0.D0 
        DO J=4,16,3 
         SUM1 = SUM1 - DUVBDX(J) 
         SUM2 = SUM2 - DUVBDX(J+1) 
         SUM3 = SUM3 - DUVBDX(J+2) 
        ENDDO
        DUVBDX(1) = SUM1 
        DUVBDX(2) = SUM2 
        DUVBDX(3) = SUM3 
!       ADD FOR KD=1-6,16-18, ADD THE CHAIN RULE TERM FOR DX0DX(KD)     
        DO KD=1,6 
         SUM0 = 0.D0 
         DO ID=1,18 
          SUM0 = SUM0 + DUVBDX(ID)*DX0DRC(ID) 
         ENDDO
         DUVBDY(KD) = DUVBDX(KD) - DRCDX(KD)*SUM0 
        ENDDO
        DO KD=16,18 
         SUM0 = 0.D0 
         DO ID=1,18 
          SUM0 = SUM0 + DUVBDX(ID)*DX0DRC(ID) 
         ENDDO
         DUVBDY(KD) = DUVBDX(KD) - DRCDX(KD)*SUM0 
        ENDDO
        DO KD=7,15 
         DUVBDY(KD) = DUVBDX(KD) 
        ENDDO
!       NOW ADD THE DERIVATIVE TERMS DO TO THE DEPENDENCE OF THE FC'S ON
        DR3DX(1) = 0.D0 
        DR3DX(2) = 0.D0 
        DR3DX(3) = 0.D0 
        DO KK=1,6 
         SUMK = 0.0D0 
         SUMI = 0.0D0 
         DO I=1,18 
          DO J=1,I 
           SUMK = SUMK + DFDRC(I,J)*XND(I)*XND(J) 
          ENDDO
          SUMI = SUMI + DFDRC(I,I)*XND(I)*XND(I) 
         ENDDO
         DKDX(KK) = DRCDX(KK)*(SUMK - 0.5D0*SUMI)                       &
                    + DR3DX(KK) * DFDRP*XND(18)*XND(6)                  
        ENDDO
        DO KK=16,18 
         SUMK = 0.0D0 
         SUMI = 0.0D0 
         DO I=1,18 
          DO J=1,I 
           SUMK = SUMK + DFDRC(I,J)*XND(I)*XND(J) 
          ENDDO
          SUMI = SUMI + DFDRC(I,I)*XND(I)*XND(I) 
         ENDDO
         DKDX(KK) = DRCDX(KK)*(SUMK - 0.5D0*SUMI)                       &
                    + DR3DX(KK) * DFDRP*XND(18)*XND(6)                  
        ENDDO
        DO KK=1,6 
         DUVBDY(KK) = DUVBDY(KK) + DKDX(KK) 
        ENDDO
        DO KK=16,18 
         DUVBDY(KK) = DUVBDY(KK) + DKDX(KK) 
        ENDDO
!       ADD PARTIAL DERIVATIVES TO YEILD DX(I)                          
        DO KD=1,18 
          DX(KD) = DUVBDY(KD) + DU3BDX(KD) 
        ENDDO
        RETURN 
      END SUBROUTINE SURF
!                                                                       
!                                                                       
!                                                                       
!     ENTRY POT FOR LEPSLR                                              
      SUBROUTINE POTLLR 
      use cmcmod, only : &
      D,RE,BETA,Z,DELZ,ZSLP,RM, &
      AQ1,AQ2,AQ3,AQ4,AQ5,AALP2,AALP3,AALP4,AALP5, &
      CO1,RECO,EASYM,R2,DZDR,ZPO,OP3Z,TOP3Z, &
      ZP3,TZP3,DO4Z,B, &
      R,ELLR,DEDR,RC
      implicit none
      double precision :: X(3),COUL(3),EXCH(3)
      double precision :: QRC(3),ALPH(3),QRC2(3)
      double precision :: COTRM(3),ULRI(3)
      double precision :: CTARG1(3)
      double precision :: TD(3),DCDR(3),ALPP(3),QP(3),QP3(3)
      double precision ::  AQ22, AQR3, ARGTH, ARGTHP, ARGZ, CC, CMNS, COF,  &
       CPLS, CZ, DAQR3, DEDRZ, DEGDR1, &
       DEGDR2, DEGDRC, DULR1, DULR2, DULR3, E, EGAU, FACTH, FACTHP, &
       RAD, RC3, RDIF, RI2, RI3, RI4, RI5, S, SDULR1, SDULR2, SDULR3, SUM1, &
       SUM2, SUM3, T, TA, TA1, TA1A, TA1B, TA3, TA3A, TA3B, TDULR1, TDULR2, TDULR3, &
       TMP1, TMP3, TQ, TQ1, TQ3, TRMIJ, TZ, UEL, UINDI, UINDJ, ULR, ZTMP
      integer :: i, j
!
!      IMPLICIT DOUBLE PRECISION (A-H,O-Z) 
!      COMMON/LRINCM/D(3),RE(3),BETA(3),Z(3),DELZ,ZSLP,RM,               &
!     &       AQ1,AQ2,AQ3,AQ4,AQ5,AALP2,AALP3,AALP4,AALP5,               &
!     &       CO1,RECO,EASYM,R2,DZDR(3),ZPO(3),OP3Z(3),TOP3Z(3),         &
!     &       ZP3(3),TZP3(3),DO4Z(3),B(3)                                
!      COMMON/LLRCM/R(3),E,DEDR(3),RC 
!      DIMENSION X(3),COUL(3),EXCH(3) 
!      DIMENSION QRC(3),ALPH(3),QRC2(3) 
!!     DIMENSION COTRM(3),ULRI(3),AQR(3),AQR4(3)                         
!      DIMENSION COTRM(3),ULRI(3) 
!      DIMENSION CTARG1(3) 
!      DIMENSION TD(3),DCDR(3),ALPP(3),QP(3),QP3(3) 
      DO I=1,2 
       ARGZ = ZSLP*(R(I) - RM) 
       ZTMP = Z(I) + DELZ*0.5D0*(1.D0 + TANH(ARGZ) ) 
       IF(ABS(ARGZ).GE.44.44D0) THEN 
         CZ = 1.D36 
       ELSE 
         CZ = (COSH(ARGZ))**2 
       END IF 
       DZDR(I) = 0.5D0*DELZ*ZSLP/CZ 
!   COMPUTE USEFUL CONSTANTS                                            
       ZPO(I) = 1.0D0 + ZTMP 
       OP3Z(I) = 1.0D0 + 3.0D0*ZTMP 
       TOP3Z(I) = 2.0D0*OP3Z(I) 
       ZP3(I) = ZTMP + 3.0D0 
       TZP3(I) = 2.0D0*ZP3(I) 
       DO4Z(I) = D(I)/4.0D0/ZPO(I) 
       B(I) = BETA(I)*DO4Z(I)*2.0D0 
      ENDDO
      S = 0.0D0 
      DO I = 1,3 
        X(I) = EXP(-BETA(I)*(R(I)-RE(I))) 
        COUL(I) = DO4Z(I)*(ZP3(I)*X(I)-TOP3Z(I))*X(I) 
        EXCH(I) = DO4Z(I)*(OP3Z(I)*X(I)-TZP3(I))*X(I) 
        S = S+EXCH(I) 
      ENDDO
      RAD = SQRT((EXCH(1)-EXCH(2))**2+(EXCH(2)-EXCH(3))**2+             &
            (EXCH(3)-EXCH(1))**2)                                       
      ELLR = -RAD/R2 
      DO I = 1,3 
        DEDR(I) = 0.D0 
        IF(X(I).LT.1.D-30) THEN
         continue
        ELSE 
          TZ = (3.0D0*EXCH(I)-S)/R2 
          T= TZ*(OP3Z(I)*X(I)-ZP3(I)) 
!                                                                       
!     PRINT OUT A WARNING IF DIVIDE BY ZERO IS GOING TO OCCUR--NOTE     
!     THIS WILL NOT BE PRINTED OUT FOR THE CASE OF 0/0.                 
          IF(ABS(RAD).LT.1.D-32.AND.ABS(T).GT.1.D-12) THEN 
            WRITE(6,6000) T,RAD 
 6000   FORMAT(' IN LEPS POTENTIAL T,RAD=',1P,2E15.7,'  T/RAD SET TO T') 
          ELSE IF(ABS(RAD).GT.1.D-32) THEN 
            T = T/RAD 
            TZ = TZ/RAD 
          END IF 
!                                                                       
          DEDRZ = DZDR(I)*(DO4Z(I)*X(I)*(X(I)-6.D0)-(COUL(I)/ZPO(I)) -      &
                TZ*(DO4Z(I)*X(I)*(3.D0*X(I)-2.D0) - (EXCH(I)/ZPO(I))))    
          DEDR(I) = B(I)*X(I)*(T                                            &
                  -ZP3(I)*X(I)+OP3Z(I)) + DEDRZ                           
        ENDIF
        ELLR = ELLR+COUL(I) 
      ENDDO
      ELLR = ELLR+D(2) 
!     NOW ADD THE LONG RANGE TERM                                       
!     R(1) = R(CL-CH3), R(2) = R(CH3-CL') , R(3) = R(CL-CL')            
!     WHERE CL' IS THE LEAVING GROUP                                    
      RC = R(2) - R(1) 
      RC3 = -RC 
      FACTH = RC - AQ4 
      FACTHP = RC3 - AQ4 
      AQR3 = AQ1*(1.D0-EXP(-AQ5*R(3)**2)) 
      ARGTH = AQR3*FACTH 
      ARGTHP = AQR3*FACTHP 
      QRC(1) = AQ3 + AQ2*0.5D0*(TANH(ARGTH)+ 1.0D0) 
      QRC(3) = AQ3 + AQ2*0.5D0*(TANH(ARGTHP)+ 1.0D0) 
      QRC(2) = -1.0D0 - QRC(1) -QRC(3) 
      QRC2(1) = QRC(1)**2 
      QRC2(3) = QRC(3)**2 
      QRC2(2) = QRC(2)**2 
      ALPH(1) = AALP2*QRC(1) + AALP3 
      ALPH(3) = AALP2*QRC(3) + AALP3 
      ALPH(2) = AALP4*QRC(2) + AALP5 
!     The index in alphp is the index of the associated charge-         
!     permanent dipole distance                                         
!     NOTE: THE PRESCRIPTION USED TO COVER ALL IJ PAIRS IS WRITTEN      
!     IN SUCH A WAY THAT THE R(I) AS DEFINED ABOVE GIVE THE CORRECT     
!     DISTANCE R-IJ; EG. R(I) = R-IJ                                    
      ULR = 0.0D0 
      DO I=1,3 
        J = I + 1 
        IF(J.GT.3) J = 1 
!       THIS IF IS TO AVOID DIVIDE BY ZEROES                            
        IF(R(I).NE.0.D0)THEN 
          RI2 = R(I)**2 
          RI4 = R(I)**4 
          RDIF = R(I) - RECO 
          CTARG1(I) = CO1*RDIF 
          COTRM(I) =(0.5D0*(1.0D0+TANH(CTARG1(I)) ))**2 
          UEL = (QRC(I)*QRC(J)) /  R(I) 
          UINDI = (ALPH(I)*QRC2(J)) / (2.0D0 * RI4) 
          UINDJ = (ALPH(J)*QRC2(I)) / (2.0D0 * RI4) 
!         TRMIJ = UEL + UPERM - UINDI - UINDJ (UPERM=0; IT'S UNDEFINED) 
          TRMIJ = UEL - UINDI - UINDJ 
        ELSE 
          TRMIJ = 0.0D0 
        END IF 
        ULRI(I) = TRMIJ 
!       NOTE: IF R=0 SUCH THAT TRMIJ IS SET = 0.0, THIS TRMIJ ALREADY   
!       "INCLUDES" THE COTRM--HOWEVER, SINCE COTRM IS 0 FOR R=0, RE-    
!       MULTIPLYING IT IS INCONSEQUENTIAL                               
        TRMIJ = COTRM(I)*TRMIJ 
        ULR = TRMIJ + ULR 
      END DO 
      ELLR = ELLR + ULR 
      ELLR = ELLR + EASYM 
!     ADD A GAUSSIAN IN RC TO LOWER THE BARRIER TO THE SEMIEMPERICAL VAL
      COF = 2.0D0*(0.52917706D0**2) 
      EGAU = -0.002278850D0*EXP(-COF*(RC**2)) 
      ELLR = ELLR + EGAU 
      DEGDRC = -2.D0*COF*RC*EGAU 
      DEGDR1 = -DEGDRC 
      DEGDR2 = DEGDRC 
!     NOW CALCULATE DERIVATIVES OF ULR                                  
!     THE NEXT 2 SETS OF IF STATEMENTS WERE INSERTED TO AVOID OVERFLOW  
!     ON THE VAX WHEN TRYING TO CALCULATE CPLS +/OR CMNS                
!     THEY CAN BE SET DIFFERENTLY ON THE CRAY WHERE MUCH HIGHER         
!     EXPONENTIALS ARE ALLOWED (YEILDING SLIGHTLY MORE ACCURATE         
!     DERIVATIVES FOR VERY LARGE VALUES OF RC)                          
      IF(ABS(ARGTH).GE.44.44D0) THEN 
        CPLS = 1.D36 
      ELSE 
        CPLS = (COSH(ARGTH))**2 
      END IF 
      IF(ABS(ARGTHP).GE.44.44D0) THEN 
        CMNS = 1.D36 
      ELSE 
        CMNS = (COSH(ARGTHP))**2 
      END IF 
      AQ22 = 0.5D0*AQ2 
      QP(1) = AQ22*AQR3/CPLS 
      QP(3) = - AQ22*AQR3/CMNS 
      QP(2) = -(QP(1) + QP(3)) 
      DAQR3 = AQ1*AQ5*2.D0*R(3)*EXP(-(AQ5*R(3)**2)) 
      QP3(1) = AQ22*DAQR3*FACTH/CPLS 
      QP3(3) = AQ22*DAQR3*FACTHP/CMNS 
      QP3(2) = -(QP3(1) + QP3(3)) 
      ALPP(1) = AALP2 
      ALPP(2) = AALP4 
      ALPP(3) = ALPP(1) 
      SUM1 = 0.D0 
      SUM2 = 0.D0 
      SUM3 = 0.D0 
      DO I=1,3 
        J = I+1 
        IF(J.GT.3) J=1 
        RI2 = R(I)**2 
        RI3 = RI2*R(I) 
        RI4 = RI2*RI2 
        RI5 = RI3*RI2 
        TQ1 = -(QP(I)*QRC(J)+QRC(I)*QP(J))/R(I) 
        TA1A = (ALPP(I)*QP(I)*QRC2(J) + 2.D0*ALPH(I)*QRC(J)*QP(J) ) 
        TA1B = (ALPP(J)*QP(J)*QRC2(I) + 2.D0*ALPH(J)*QRC(I)*QP(I) ) 
        TA1 = (TA1A + TA1B)/(2.D0*RI4) 
        TMP1 = (TQ1 + TA1) 
        DULR1 = TMP1*COTRM(I) 
        DULR2 = - DULR1 
        TQ3 = (QP3(I)*QRC(J)+QRC(I)*QP3(J))/R(I) 
        TA3A =-(ALPP(I)*QP3(I)*QRC2(J) + 2.D0*ALPH(I)*QRC(J)*QP3(J) ) 
        TA3B =-(ALPP(J)*QP3(J)*QRC2(I) + 2.D0*ALPH(J)*QRC(I)*QP3(I) ) 
        TA3 = (TA3A + TA3B)/(2.D0*RI4) 
        TMP3 = (TQ3 + TA3) 
        DULR3 = TMP3*COTRM(I) 
        TQ = - QRC(I)*QRC(J)/RI2 
        TA = 2.D0*(ALPH(I)*QRC2(J) + ALPH(J)*QRC2(I))/RI5 
        SUM1 = DULR1 + SUM1 
        SUM2 = DULR2 + SUM2 
        SUM3 = DULR3 + SUM3 
        TD(I) = (TQ + TA)*COTRM(I) 
        IF(ABS(CTARG1(I)).GE.44.44D0) THEN 
          CC = 1.D36 
        ELSE 
          CC = (COSH(CTARG1(I)))**2 
        END IF 
        DCDR(I) = SQRT(COTRM(I))*CO1/CC 
      END DO 
      SDULR1 = SUM1 + TD(1) 
      SDULR2 = SUM2 + TD(2) 
      SDULR3 = SUM3 + TD(3) 
      TDULR1 = SDULR1 + ULRI(1)*DCDR(1) 
      TDULR2 = SDULR2 + ULRI(2)*DCDR(2) 
      TDULR3 = SDULR3 + ULRI(3)*DCDR(3) 
      DEDR(1) = TDULR1 + DEDR(1) + DEGDR1 
      DEDR(2) = TDULR2 + DEDR(2) + DEGDR2 
      DEDR(3) = TDULR3 + DEDR(3) 
 9373 CONTINUE 
      RETURN 
      END SUBROUTINE POTLLR 
