!
      SUBROUTINE chain4(X, DX, N3TM)
      use potcm4, only : r, dvdr
!
!   This subprogram uses the chain rule to calculate the derivatives of
!   the energy with respect to the cartesian coordinates from the derivatives
!   with respect to the internal coordinates for a four-body system, ABCD.
!   The integer N3TM, passed by the calling routine, must be greater than or 
!   equal to 12.
!   The convention assumed in this subprogram is as follows:
!                  R(1) : R(A-B)
!                  R(2) : R(A-C)
!                  R(3) : R(A-D)
!                  R(4) : R(B-C)
!                  R(5) : R(B-D)
!                  R(6) : R(C-D)
!                  X(1)  - X(3)  : X, Y, Z for atom A
!                  X(4)  - X(6)  : X, Y, Z for atom B
!                  X(7)  - X(9)  : X, Y, Z for atom C
!                  X(10) - X(12) : X, Y, Z for atom D
!
         implicit none
         integer, intent(in) :: N3TM
         real(8), intent(in) :: X(N3TM)
         real(8), intent(out) :: DX(N3TM)
         real(8) :: Y(6)
         integer :: i
         do i = 1, 6
           Y(i) = DVDR(i)/R(i)
         enddo
!
         DX(1) = (X(1)-X(4))*Y(1)+(X(1)-X(7))*Y(2)+(X(1)-X(10))*Y(3)
         DX(2) = (X(2)-X(5))*Y(1)+(X(2)-X(8))*Y(2)+(X(2)-X(11))*Y(3)
         DX(3) = (X(3)-X(6))*Y(1)+(X(3)-X(9))*Y(2)+(X(3)-X(12))*Y(3)
         DX(4) = (X(4)-X(1))*Y(1)+(X(4)-X(7))*Y(4)+(X(4)-X(10))*Y(5)
         DX(5) = (X(5)-X(2))*Y(1)+(X(5)-X(8))*Y(4)+(X(5)-X(11))*Y(5)
         DX(6) = (X(6)-X(3))*Y(1)+(X(6)-X(9))*Y(4)+(X(6)-X(12))*Y(5)
         DX(7) = (X(7)-X(1))*Y(2)+(X(7)-X(4))*Y(4)+(X(7)-X(10))*Y(6)
         DX(8) = (X(8)-X(2))*Y(2)+(X(8)-X(5))*Y(4)+(X(8)-X(11))*Y(6)
         DX(9) = (X(9)-X(3))*Y(2)+(X(9)-X(6))*Y(4)+(X(9)-X(12))*Y(6)
         DX(10) = (X(10)-X(1))*Y(3)+(X(10)-X(4))*Y(5)+(X(10)-X(7))*Y(6)
         DX(11) = (X(11)-X(2))*Y(3)+(X(11)-X(5))*Y(5)+(X(11)-X(8))*Y(6)
         DX(12) = (X(12)-X(3))*Y(3)+(X(12)-X(6))*Y(5)+(X(12)-X(9))*Y(6)
!
         RETURN
         END subroutine chain4
!*****
