      SUBROUTINE chain3(X, DX, N3TM)
      use potcm3, only : r,dedr
      implicit none
      integer, intent(in) :: n3tm
      double precision, intent(in) :: x(n3tm)
      double precision, intent(out) :: dx(n3tm)
      double precision :: y(3)
      integer :: i
!
!   This subprogram uses the chain rule to calculate the derivatives of the
!   energy with respect to the cartesian coordinates from the derivatives
!   with respect to the internal coordinates for a three-body system.
!   The integer, N3TM, passed by the calling program must be greater than 
!   or equal to 9.
!   The convention assumed in this program is as follows:
!                  R(1) = R(A-B)
!                  R(2) = R(B-C)
!                  R(3) = R(C-A)
!                  X(1) - X(3) : X, Y, Z for atom A
!                  X(4) - X(6) : X, Y, Z for atom B
!                  X(7) - X(9) : X, Y, Z for atom C
!
         do i = 1, 3
               Y(i) = DEDR(i)/R(i)
         enddo
!
         DX(1) = (X(1)-X(4))*Y(1)-(X(7)-X(1))*Y(3)
         DX(2) = (X(2)-X(5))*Y(1)-(X(8)-X(2))*Y(3)
         DX(3) = (X(3)-X(6))*Y(1)-(X(9)-X(3))*Y(3)
         DX(4) = -(X(1)-X(4))*Y(1)+(X(4)-X(7))*Y(2)
         DX(5) = -(X(2)-X(5))*Y(1)+(X(5)-X(8))*Y(2)
         DX(6) = -(X(3)-X(6))*Y(1)+(X(6)-X(9))*Y(2)
         DX(7) = -(X(4)-X(7))*Y(2)+(X(7)-X(1))*Y(3)
         DX(8) = -(X(5)-X(8))*Y(2)+(X(8)-X(2))*Y(3)
         DX(9) = -(X(6)-X(9))*Y(2)+(X(9)-X(3))*Y(3)
!
         RETURN
         END subroutine chain3
