  module PTPACM
  implicit none
  save
! parameters
  integer, parameter :: N3ATOM = 75
  integer, parameter :: ISURF = 5
  integer, parameter :: JSURF = ISURF*(ISURF+1)/2
  double precision, parameter :: PI = 3.141592653589793D0
  integer, parameter :: NATOM = 25
! variable definitions
  character(len=75) :: REF(5)
!      COMMON/PT1CM/ R(N3ATOM), ENGYGS, DEGSDR(N3ATOM)
  double precision :: R(N3ATOM), ENGYGS, DEGSDR(N3ATOM)
!      COMMON/PT3CM/ EZERO(ISURF+1)
  double precision :: EZERO(ISURF+1)
!      COMMON/PT4CM/ ENGYES(ISURF), DEESDR(N3ATOM,ISURF)
  double precision :: ENGYES(ISURF), DEESDR(N3ATOM,ISURF)
!      COMMON/PT5CM/ ENGYIJ(JSURF), DEIJDR(N3ATOM,JSURF)
  double precision :: ENGYIJ(JSURF), DEIJDR(N3ATOM,JSURF)
!      COMMON/INFOCM/ CARTNU(NATOM,3),INDEXES(NATOM),  &
!                     IRCTNT,NATOMS,ICARTR,MDER,MSURF,REF
  double precision ::  CARTNU(NATOM,3)
  integer :: INDEXES(NATOM),IRCTNT,NATOMS,ICARTR,MDER,MSURF
!      COMMON/USRICM/ CART(NATOM,3),ANUZERO,  &
!                     NULBL(NATOM),NFLAG(20),  &
!                     NASURF(ISURF+1,ISURF+1),NDER
  double precision ::  CART(NATOM,3),ANUZERO
  integer :: NULBL(NATOM),NFLAG(20),NASURF(ISURF+1,ISURF+1),NDER
!      COMMON/USROCM/ PENGYGS,PENGYES(ISURF),PENGYIJ(JSURF),DGSCART(NATOM,3),DESCART(NATOM,3,ISURF),DIJCART(NATOM,3,JSURF)
  double precision ::  PENGYGS,PENGYES(ISURF),PENGYIJ(JSURF),DGSCART(NATOM,3),DESCART(NATOM,3,ISURF),DIJCART(NATOM,3,JSURF)
!      COMMON /POTCM/ nnc,nnb,nnh(4),  &
!                     r0ch,d1ch,d3ch,  &
!                     a1ch,b1ch,c1ch,  &
!                     r0hh,d1hh,d3hh,ahh,  &
!                     r0cb,d1cb,d3cb,acb,  &
!                     a3s,b3s,aphi,bphi,cphi,  &
!                     atheta,btheta,ctheta,  &
!                     fch3,hch3,  &
!                     fkinf,ak,bk,aa1,aa2,aa3,aa4
  integer :: nnc,nnb,nnh(4)    
  double precision :: r0ch,d1ch,d3ch    
  double precision :: a1ch,b1ch,c1ch    
  double precision :: r0hh,d1hh,d3hh,ahh    
  double precision :: r0cb,d1cb,d3cb,acb    
  double precision :: a3s,b3s,aphi,bphi,cphi    
  double precision :: atheta,btheta,ctheta    
  double precision :: fch3,hch3    
  double precision :: fkinf,ak,bk,aa1,aa2,aa3,aa4
!       common /angles/  theta0(4,4),dtheta0(4,4,4)
  double precision :: theta0(4,4),dtheta0(4,4,4)
!       common /bonds/   rcb,rch(4),rbh(4)
  double precision :: rcb,rch(4),rbh(4)
!       common /coords/  tcb(3),tch(4,3),tbh(4,3)
  double precision :: tcb(3),tch(4,3),tbh(4,3)
!       common /delta1/  fdelta(4),hdelta(4)
  double precision :: fdelta(4),hdelta(4)
!       common /delta2/  dfdelta(4,4),dhdelta(4,4)
  double precision :: dfdelta(4,4),dhdelta(4,4)
!       common /force1/  fk0(4,4),f1(4),dfdc(4,4,4),dfdh(4,4,4)
  double precision :: fk0(4,4),f1(4),dfdc(4,4,4),dfdh(4,4,4)
!       common /fsw1/    a1s,b1s,a2s,b2s
  double precision :: a1s,b1s,a2s,b2s
!       common /ip1/     s1(4),ds1(4),s2(4),ds2(4)
  double precision :: s1(4),ds1(4),s2(4),ds2(4)
!       common /ndx/     nc(3),nhb(3),nh(4,3)
  integer :: nc(3),nhb(3),nh(4,3)
!       common /op1/     s3(4),ds3(4)
  double precision :: s3(4),ds3(4)
!       common /qpdot_pl/   q(150),pdot(150)
  double precision :: q(150),pdot(150)
!       common /switch1/ sphi(4),dsphi(4),stheta(4),dstheta(4)
  double precision :: sphi(4),dsphi(4),stheta(4),dstheta(4)
!
! Values
!
      DATA NASURF /1,35*0/
      DATA NDER /1/
      DATA NFLAG /1,1,15*0,6,0,0/
!
      DATA ANUZERO /0.0D0/
      DATA ICARTR,MSURF,MDER/1,0,1/
      DATA NULBL /25*0/
      DATA NATOMS /6/
      DATA nnc     /2/
      DATA nnb     /6/
      DATA nnh     /3,4,5,1/
      DATA r0ch    /   1.09397d0/
      DATA d1ch    / 112.230d0/
      DATA d3ch    /  38.834d0/
      DATA a1ch    /   1.71300d0/
      DATA b1ch    /   0.13500d0/
      DATA c1ch    /   6.61404d0/
      DATA r0hh    /   0.74191d0/
      DATA d1hh    / 109.458d0/
      DATA d3hh    /  39.664d0/
      DATA ahh     /   1.9457d0/
      DATA r0cb    /   1.09397d0/
      DATA d1cb    /  26.409d0/
      DATA d3cb    /  20.063d0/
      DATA acb     /   1.8530285d0/
      DATA a3s     /   0.1419147d0/
      DATA b3s     /  -0.3068450d0/
      DATA aphi    /   0.5287903d0/
      DATA bphi    /   0.4006638d0/
      DATA cphi    /   1.9209937d0/
      DATA atheta  /   0.9078714d0/
      DATA btheta  /   0.3548859d0/
      DATA ctheta  /   1.8915497d0/
      DATA fch3    /   0.0957500d0/
      DATA hch3    /   0.1915000d0/
      DATA fkinf   /   0.4077000d0/
      DATA ak      /   0.1260000d0/
      DATA bk      /  10.7132d0/
      DATA aa1     /   3.213952d0/
      DATA aa2     /   1.599963d0/
      DATA aa3     /   2.165953d0/
      DATA aa4     /  11.569977d0/

      END module PTPACM

