# POLYRATE

Computer Program for the Calculation of Chemical Reaction Rates for Polyatomics

# Build Status

![example workflow](https://github.com/rmeanapa/polyrate/actions/workflows/build_and_test.yml/badge.svg)

# Description

Polyrate 22 is a suite of computer programs for the calculation of chemical
reaction rates of polyatomic species (including atoms and diatoms as special cases) by
variational transition state theory (VTST); conventional transition state theory is also
supported. Polyrate 22 (called Polyrate for short) consists of the main program,
called Polyrate, and a set of utility codes,
Polyrate can calculate the rate constants for both bimolecular reactions and
unimolecular reactions, and it can be applied to reactions in the gas-phase, liquid-solution
phase, or solid-state and to gas-solid-interface reactions. Polyrate can perform variational
transition state theory (VTST) calculations on gas-phase reactions with both tight and
loose transition states. For tight transition states it uses the reaction-path (RP)
variational transition state theory developed by Garrett and Truhlar, and for loose
transition states it uses variable-reaction-coordinate (VRC) variational transition state
theory developed by Georgievskii and Klippenstein.
The RP methods used for tight transition states are conventional transition state
theory, canonical variational transition state theory (CVT), and microcanonical
variational transition state theory ( μVT) with multidimensional semiclassical
approximations for tunneling and nonclassical reflection. The tunneling approximations
available are zero-curvature tunneling (ZCT), small-curvature tunneling (SSCT), large-
curvature- tunneling (LCT), and optimized multidimensional tunneling (OMT). The SCT
option is the centrifugal dominant semiclassical adiabatic ground-state tunneling, and the
LCT options include both LC3 and LC4 including tunneling into excited states. One may
also treat specific vibrational states of selected modes with translational, rotational, and
other vibrational modes treated thermally.
For RP calculations, several options are available for reaction paths, vibrations
transverse to the reaction path, and transition state dividing surfaces. Generalized-
transition-state dividing surfaces may be defined on the basis of gradient directions in
isoinertial coordinates or by the re-orientation of the dividing surface algorithm. Reaction
paths may be calculated by the Euler steepest-descent, Euler stabilization, Page-McIver,
or variational-reaction-path algorithms. Vibrations away from the reaction path may be
defined by rectilinear (not recommended), nonredundant curvilinear, or redundant
curvilinear coordinates. Vibrational frequencies may be unscaled (not recommended) or
scaled.
For VRC calculations, rate constants may be calculated for canonical or
microcanonical ensembles or energy-and-total-angular-momentum resolved
microcanonical ensembles. VRC calculations are most appropriate for barrierless
association reactions. Both single-faceted and multifaceted dividing surfaces are
supported.
Pressure-dependent rate constants for elementary reactions can be computed using
system-specific quantum RRK theory (SS-QRRK) with the information obtained from
high-pressure-limit VTST calculation as input by using the SS-QRRK utility code. The
SS-QRRK utility program is part of the Polyrate distribution, and its usage is described in
a separate manual.

Potential energy surfaces may be analytic functions evaluated by subroutines, or
they may be implicit surfaces defined by electronic structure input files or interface
subroutines containing energies, gradients, and force constants (Hessians). The use of
electronic structure calculations to calculate rate constants or other dynamical quantities
without an analytic potential energy surface is called direct dynamics.
Analytic surfaces may be used for variational transition state theory and any of the
types of tunneling calculations, single-level and dual-level calculations based solely on
electronic structure input files may be used for variational transition state theory and
zero-curvature or small-curvature tunneling, and dual-level calculations based on using
an analytic potential energy surface as the lower level and using an electronic structure
input file as the higher level may be used for variational transition state theory and any of
the types of tunneling calculations.
Polyrate supports six options for direct dynamics, namely (i) straight single-level
direct dynamics, (ii) zero-order interpolated variational transition state theory (IVTST-0),
(iii) first-order interpolated variational transition state theory (IVTST-1), (iv) interpolated
variational transition state theory by mapping (IVTST-M), (v) variational transition state
theory with interpolated single-point energies (VTST-ISPE), and (vi) variational
transition state theory with interpolated optimized corrections (VTST-IOC). VTST-IOC
and VTST-ISPE are examples of dual-level direct dynamics; and VTST-IOC is also
called triple-slash dynamics (///), where the triple slash denotes higher-order corrections
of the geometries at which energetic and Hessian corrections are calculated. Dual-level
methods may be applied with electronic structure data for both levels (dual-level direct
dynamics), or it may be applied with an analytical potential energy surface for the lower
level and electronic structure data for the higher level. When dual-level methods are
employed with electronic structure data for both levels, the lower level may be either
straight direct dynamics or IVTST-M.
This version of Polyrate contains 112 test runs, and 46 of these are for direct
dynamics calculations; 85 of the test runs are single-level runs, and 27 are dual-level
calculations.
Polyrate is designed to be used in conjunction with interfaces to electronic
structure programs for direct dynamics. 

# Documentation
PDF manual

# Installation & Testing

# Authors

Rubén Meana-Pañeda,\* Jingjing Zheng, Junwei Lucas Bao, 
Shuxia Zhang, Benjamin J. Lynch, José C. Corchado, Yao-Yuan Chuang,
Patton L. Fast, Wei-Ping Hu, Yi-Ping Liu, Gillian C. Lynch, Kiet A. Nguyen,
Charles F. Jackels, Antonio Fernandez Ramos, Benjamin A. Ellingson, Vasilios S. Melissas,
Jordi Villà, Ivan Rossi, Elena. L. Coitiño, Jingzhi Pu, Titus V. Albu
Department of Chemistry and Supercomputing Institute
University of Minnesota, Minneapolis, Minnesota 55455

\* National Heart, Lung and Blood Institute, National Institutes of Health, Bethesda, Maryland

Artur Ratkiewicz
Institute of Chemistry, University of Bialystok, Poland

Rozeanne Steckler
Northwest Alliance for Computational Science & Engineering
Oregon State University, Corvallis, Oregon 97331

Bruce C. Garrett
Environmental Molecular Sciences Laboratory
Pacific Northwest Laboratory
Richland, Washington 99352

Alan D. Isaacson
Department of Chemistry and Biochemistry
Miami University Oxford, Ohio 45056

and Donald G. Truhlar
Department of Chemistry and Supercomputing Institute
University of Minnesota, Minneapolis, Minnesota 55455 

# Citations 

 Polyrate citation, JCP style
J. Zheng, J. L. Bao, R. Meana-Pañeda, S. Zhang, B. J. Lynch, J. C. Corchado, Y.-Y. Chuang, P. L. Fast, W.-P. Hu, Y.-P. Liu, G. C. Lynch, K. A. Nguyen, C. F. Jackels, A. Fernandez Ramos, B. A. Ellingson, V. S. Melissas, J. Villà, I. Rossi, E. L. Coitiño, J. Pu, T. V. Albu, A. Ratkiewicz, R. Steckler, B. C. Garrett, A. D. Isaacson, and D. G. Truhlar, Polyrate-version 2017-C (University of Minnesota, Minneapolis, MN, 2017).

Polyrate citation, ACS style
Zheng, J.; Bao, J. L.; Meana-Pañeda, R.; Zhang, S.; Lynch, B. J.; Corchado, J. C.; Chuang, Y.-Y.; Fast, P. L.; Hu, W.-P.; Liu, Y.-P.; Lynch, G. C.; Nguyen, K. A.; Jackels, C. F.; Fernandez Ramos, A.;Ellingson, B. A.; Melissas, V. S.; Villà, J. Rossi, I.; Coitiño, E. L.; Pu, J.; Albu, T. V.; Ratkiewicz, A.; Steckler, R.; Garrett, B. C.; Isaacson, A. D.; Truhlar, D. G. Polyrate-version 2017-C; University of Minnesota: Minneapolis, 2017. 

# Bibliography

Bibliography of publications based in whole or in part on Polyrate.
Polyrate users will find it useful to consult two book chapters that summarize many of the methods used in the Polyrate code:
  (1) The GTST book chapter:
        "Generalized Transition State Theory," D. G. Truhlar, A. D. Isaacson, and B. C. Garrett, in Theory of Chemical Reaction Dynamics, edited by M. Baer (CRC Press, Boca Raton, FL, 1985), Vol. 4, pp. 65-137. pdf
        Errata for Book Chapter "Generalized Transition State Theory"
  (2) The VTST/MT book chapter:
        "Variational Transition State Theory with Multidimensional Tunneling," A. Fernandez-Ramos, B. A. Ellingson, B. C. Garrett, and D. G. Truhlar, in Reviews in Computational Chemistry, Vol. 23 edited by K. B. Lipkowitz and T. R. Cundari (Wiley-VCH, Hoboken, NJ, 2007), pp. 125-232. pdf
  (3) Review:
        "Variational Transition State Theory: Theoretical Framework and Recent Developments," J. L. Bao and D. G. Truhlar, Chemical Society Reviews 46, 7548-7596 (2017). pdf


# Licence

POLYRATE is licensed under the Apache License, Version 2.0.
The manual of POLYRATE is licensed under CC-BY-4.0.

