# LI-6800
Authors: Stanislaus J. Schymanski*, Emmanuella Osuebi-Iyke

Luxembourg Institute of Science and Technology, Environmental Research and Innovation Department

*stanislaus.schymanski@list.lu

Copyright © 2019-2023 Luxembourg Institute of Science and Technology. All Rights Reserved.

The code in this repository is distributed under the terms of the [GNU General Public License 3.0](https://www.gnu.org/licenses/gpl-3.0.html) or any later version, unless stated otherwise. All other material is licensed under a [Creative Commons Attribution 4.0 International license](https://creativecommons.org/licenses/by/4.0/), unless stated otherwise.

## General purpose
This repository contains python scripts to import data files from a LI-COR LI-6800, re-calculate fluxes and plot results. Associated Jupyter notebooks illustrate their use. 

This is a renku project available at [https://renkulab.io/projects/wave/li-6800](https://renkulab.io/projects/wave/li-6800), which can be run on renkulab.io or imported from its corresponding gitlab address [https://renkulab.io/gitlab/wave/li-6800](https://renkulab.io/gitlab/wave/li-6800). To import the scripts into another renku project, execute in the parent folder of your other project:
```
renku --no-external-storage dataset add --create modules_li_6800 \
--source 'modules/*' git@renkulab.io:wave/li-6800.git
```
This will save the modules foler in `data/modules_li_6800`. 

You can also import each file separately by executing in a jupyter notebook:
```
# Create dataset modules_LI-6800
ds_name = 'modules_LI-6800'
result = subprocess.run(['renku', 'dataset', 'create', ds_name], 
                        capture_output=True, cwd=parent)
print(result.stdout.decode())
print(result.stderr.decode())

# Files to be added
source_link = 'git@renkulab.io:wave/li-6800.git'
files = ['computing.py',
 '__init__.py',
 'Mathematical_model_equations_definitions.py',
 'Mathematical_model_variable_definitions.py',
 'plotting.py',
 '__pycache__',
 'reading.py']
for file in files:
    cmdlist = ['renku', '--no-external-storage', 'dataset', 'add',
               ds_name, '--source', 'modules/'+file, source_link]
    result = subprocess.run(cmdlist, 
                        capture_output=True, cwd=parent)
    print('\n' + file)
    print(result.stdout.decode())
    print(result.stderr.decode())
```


If you would like to have it e.g. just in the base folder, simply move it using renku:
```
renku mv data/modules_LI_6800/ modules_LI_6800/
```

Then you can import and use the scripts as shown in [notebooks/read_plot.ipynb](notebooks/read_plot.ipynb).


## Repository structure

- [data](data): 
Example data files

- [notebooks](notebooks):
Jupyter notebooks with code and documentation, demonstrating derivations
of equations and use of python scripts.

    - [GC_Fluxes_Computations_equations.ipynb](notebooks/GC_Fluxes_Computations_equations.ipynb):
    This jupyter notebook defines variables and derives equations for calculating 
    gas exchange rates from original data collected by a LI-COR 
    Portable Photosynthesis System, the LI-6800.

    - [read_plot.ipynb](notebooks/read_plot.ipynb):
    This jupyter notebook tests and illustrates the importing and use of 
    the equations and scripts in [modules](modules).

- [modules](modules):
Python files (.py) for importing elsewhere.

    - [Mathematical_model_variable_definitions.py](modules/Mathematical_model_variable_definitions.py):
    Python module with variable definitions.

    - [Mathematical_model_equations_definitions.py](modules/Mathematical_model_equations_definitions.py):
    Python module with equation definitions.

    - [plotting.py](modules/plotting.py):
    Python module with plotting functions.
    
    - [read_plot.ipynb](modules/read_plot.ipynb):
    Jupyter notebook with examples for data import, calculations and plotting.

# Instructions for use in renkulab.io

## Introduction

This is a Renku project - basically a git repository with some
bells and whistles. You can access it at [https://renkulab.io/projects/wave/li-6800](https://renkulab.io/projects/wave/li-6800)

## Working with the project

The simplest way to start your project is right from the Renku
platform - just click on the `Environments` tab and start a new session.
This will start an interactive environment right in your browser.

To work with the project anywhere outside the Renku platform,
click the `Settings` tab where you will find the
git repo URLs - use `git` to clone the project on whichever machine you want.

### Changing interactive environment dependencies

Initially we install a very minimal set of packages to keep the images small.
However, you can add python and conda packages in `requirements.txt` and
`environment.yml` to your heart's content. If you need more fine-grained
control over your environment, please see [the documentation](https://renku.readthedocs.io/en/latest/user/advanced_interfaces.html#dockerfile-modifications).

## Project configuration

Project options can be found in `.renku/renku.ini`. In this
project there is currently only one option, which specifies
the default type of environment to open, in this case `/lab` for
JupyterLab. You may also choose `/tree` to get to the "classic" Jupyter
interface.

