
## Research compendium for 'Unravelling technological behaviors through core reduction intensity. The case of the early Protoaurignacian assemblage from Fumane Cave' 

### Compendium DOI:

[![DOI](here link)


### Maintainers of this repository:

[![ORCiD](https://img.shields.io/badge/ORCiD-0000--0001--7349--5401-green.svg)](http:// + orcid link) Diego Lombao (<dlombao@iphes.cat>)
[![ORCiD](https://img.shields.io/badge/ORCiD-0000--0001--7349--5401-green.svg)](https://orcid.org/0000-0002-3255-1005) Armando Falcucci (<armando.falcucci@uni-tuebingen.de>)

### Published in:

Diego Lombao, Armando Falcucci, Elena Moos, Marco Peresani (2023) Unravelling technological behaviour through core reduction intensity. The case of the early Protoaurignacian assemblage from Fumane Cave. [![DOI](https://zenodo.org/badge/DOI/.svg)](aa link doi of zenodo or other preprint source) 

### Abstract:

This paper investigates core reduction intensity in the early Protoaurignacian lithic assemblage from Fumane Cave in northeastern Italy. Here, reduction intensity was used as a means to characterize blank selection strategies and raw material management, explore the variability of knapping strategies throughout the reduction sequence by reconstructing the operatory field of core assemblages, and finally address the relationship between blades and bladelets. The latter aspect was particularly important to gain insights into the behavioral and chrono-cultural significance of laminar productions in the framework of the Aurignacian technocomplex. In order to meet these goals, experimental work was conducted thanks to 3D scanning technology to compare different methods and variables for measuring reduction intensity, including the percentage of non-cortical surface, the Scar Density Index (SDI), and a novel adaptation of the Volumetric Reconstruction Method (VRM). Results demonstrate the effectiveness and potential of adapting VRM for studying reduction intensity in Upper Paleolithic laminar cores, and the provided R scripts and datasets will enable this method to be applied to other contexts with little or no modification of the workflow. The reduction intensity measures applied to the Protoaurignacian assemblage from Fumane Cave reveal slight variations depending on the abundance and proximity of available raw materials selected for blank production. Not surprisingly, the most abundant raw material variety – the Maiolica – has the largest number of less reduced cores, although reduction is fairly high across all cores discarded at the site. The observed variability in the operatory field and the interrelation between blade and bladelet productions underscore the complexity and flexibility of Protoaurignacian human behavior, which also complicate a definitive separation between the operatory fields of blade and bladelet productions. These findings are particularly important to emphasize the importance of considering reduction intensity when examining technological variability and human behavior in Aurignacian studies. We hope that the proposed adaptation of the VRM and the effective combination with other measures of reduction will allow future studies to rightfully incorporate reduction intensity as a temporal component in studies on stone tool production to enhance our understanding of the adaptive behaviors of Homo sapiens in diverse ecological settings and better frame the development of the Upper Paleolithic.

### Keywords:

Protoaurignacian; Lithic Technology; Reduction Intensity; Cores; VRM; Experimental Archaeology; Fumane Cave

### Overview of contents and how to reproduce:

This repository contains the codes and datasets for reproducing the results of the experimental (`1_Experimental_Results`) and archaeological (`2_Archaeological_Results`) analyses. Readers can start their own analyses by using the R Markdown files and the datasets. Please, download the complete repository and reproduce the results using `Reduction_Intensity_Protoaurignacian.Rproj` and opening the two folders.
This repository also contains the 3D models of the cores "3D Experimental cores" and the supplementary tables (Supplementary Material.docx") used in this research.


### Licenses:

Code: __MIT__ <http://opensource.org/licenses/MIT>, copyright holder: Diego Lombao (2023).

Data and intellectual work: __Creative Commons Attribution 4.0 International License__ (http://creativecommons.org/licenses/by/4.0/), copyright holder: the authors (2023).