# Met4FoF tutorials

In this subfolder you find all tutorials specifically provided to support the
understanding and simplify the use of the produced software packages.

## Table of content

- [Tutorials descriptions](#Tutorials-descriptions)
    - [agentMET4FOF_anomaly_detection](#agentMET4FOF_anomaly_detection)
    - [agentMET4FOF_bayesian_neural_network_ZeMA](#agentMET4FOF_bayesian_neural_network_ZeMA)
    - [agentMET4FOF_ml](#agentMET4FOF_ml)
    - [agentMET4FOF_sensors](#agentMET4FOF_sensors)
    - [agentMET4FOF_ZeMA_emc](#agentMET4FOF_ZeMA_emc)
    - [connect-agentMET4FOF-smartupunit](#connect-agentMET4FOF-smartupunit)
    - [PyDynamic_tutorials](#PyDynamic_tutorials)
    - [Strathcylde_AFRC_machine_learning_tutorials](#Strathcylde_AFRC_machine_learning_tutorials)
    - [ZeMA-machine-learning-tutorials](#ZeMA-machine-learning-tutorials)
- [Upstream links](#Upstream-links)

## Tutorials descriptions

### [agentMET4FOF_anomaly_detection](agentMET4FOF_anomaly_detection)

With the provided code, which is based on agentMET4FOF, we showcase an agent-based
machine learning approach for online anomaly detection of (in our case simulated)
sensor readings.

### [agentMET4FOF_bayesian_neural_network_ZeMA](agentMET4FOF_bayesian_neural_network_ZeMA)

This is an implementation of the agent-based approach for the [ZEMA dataset ![DOI
](https://zenodo.org/badge/DOI/10.5281/zenodo.1323611.svg
)](https://doi.org/10.5281/zenodo.1323611) on condition monitoring of a hydraulic
system.

### [agentMET4FOF_ml](agentMET4FOF_ml)

This is an implementation of an agent-based approach to machine learning utilizing the
external Python library [_scikit-multiflow_](https://scikit-multiflow.github.io/).

### [agentMET4FOF_sensors](agentMET4FOF_sensors)

This is an implementation of an agent-based approach to interconnect hardware sensors
from the manufacturer _Seneca_ and processing the produced data streams including sensor
data buffering as part of the agents' implementation.

### [agentMET4FOF_ZeMA_emc](agentMET4FOF_ZeMA_emc)

This is an implementation of the agent-based approach for the [ZEMA dataset ![DOI
](https://zenodo.org/badge/DOI/10.5281/zenodo.1323611.svg
)](https://doi.org/10.5281/zenodo.1323611)
on condition monitoring of a hydraulic system.

### [connect-agentMET4FOF-smartupunit](connect-agentMET4FOF-smartupunit)

This code serves to connect the SmartUp Unit developed in WP1 to agentMET4FOF.

### [PyDynamic_tutorials](PyDynamic_tutorials)

We prepared a collection of tutorials and examples to document, explain and illustrate
the possibilities offered by [_PyDynamic_](https://github.com/PTB-M4D/PyDynamic).

### [Strathcylde_AFRC_machine_learning_tutorials](Strathcylde_AFRC_machine_learning_tutorials)

Machine Learning tutorials oriented at beginners in data science. Methods are applied on
Strathcylde-s testbed data (Advanced Forming Research Centre | University of
Strathclyde).

### [ZeMA-machine-learning-tutorials](ZeMA-machine-learning-tutorials)

These notebooks were developed on the basis of previous work on Machine Learning methods
applied on ZeMA's testbed data of the co-author [Haris Lulic
](mailto:haris.lulic@met.gov.ba).

## Upstream links

The collected code originates from GitHub repositories which are of course directly
accessible as well. The respective links are the following:

- [agentMET4FOF_anomaly_detection](https://github.com/Met4FoF/agentMET4FOF_anomaly_detection)
- [agentMET4FOF_bayesian_neural_network_ZeMA](https://github.com/Met4FoF/agentMET4FOF_bayesian_neural_network_ZeMA)
- [agentMET4FOF_ml](https://github.com/Met4FoF/agentMET4FOF_ml.git)
- [agentMET4FOF_sensors](https://github.com/Met4FoF/agentMET4FOF_sensors.git)
- [agentMET4FOF_ZeMA_emc](https://github.com/Met4FoF/agentMET4FOF_ZeMA_emc.git)
- [connect-agentMET4FOF-smartupunit](https://github.com/Met4FoF/connect-agentMET4FOF-smartupunit)
- [PyDynamic_tutorials](https://github.com/PTB-M4D/PyDynamic_tutorials.git)
- [Strathcylde_AFRC_machine_learning_tutorials](https://github.com/harislulic/Strathcylde_AFRC_machine_learning_tutorials.git)
- [ZeMA-machine-learning-tutorials](https://github.com/harislulic/ZeMA-machine-learning-tutorials.git)