from sympy.physics.units import convert_to
from essm import Eq, e
from essm.equations import Equation
from essm.variables import Variable
from essm.variables.utils import generate_metadata_table
from essm.variables.units import derive_unit, derive_baseunit, markdown, SI
from essm.variables.units import joule, kelvin, kilogram, meter, pascal, second, watt, newton,mol
import sys
import math
import glob
import os
import warnings
import importlib
import pandas as pd
import numpy as np
import matplotlib as mpl
import matplotlib.pyplot as plt
import matplotlib.dates as md
from matplotlib.dates import DateFormatter
from sympy import latex, N, solve
from numpy import arange
from datetime import datetime, timedelta 
from sympy.printing.theanocode import theano_function


# Defining fonts to use later on
font_S = {'family':'serif' , 'color':'black' , 'weight':'normal' , 'size': 14,}
font = {'family':'serif' , 'color':'black' , 'weight':'normal' , 'size': 20,}
font_L = {'family':'serif' , 'color':'black' , 'weight':'normal' , 'size': 26,}

"""To skip rows other than the header"""
def skip(x,z):
    if z == 1:
        y = [i for i in range(2,x)]
        x1 = [0]
        result = x1 + y
    if z == 0:
        result = [i for i in range(1,x)]
    return(result)

#Reading data"""
def Data_read(x,z):
    df = pd.read_csv(open(x, 'rb'), delimiter=';',skiprows = skip(4,z),dtype={'P_Bot':np.float64},na_values=['*******','Invalid value!']) 
    df['timestamp'] = pd.to_datetime(df['Date/Time'],format = '%Y-%m-%d %H:%M:%S')
    df['timestamp'] = df['timestamp'].dt.strftime('%Y-%m-%d %H:%M:%S')
    df.index = df['timestamp']   
    return(df)

#Reading data"""
def Data_read2(x,z):
    df = pd.read_csv(open(x, 'rb'), delimiter=';',skiprows = skip(3,z),dtype={'P_Bot':np.float64},na_values=['*******','Invalid value!']) 
    df['timestamp'] = pd.to_datetime(df['Date/Time'],format = '%d/%m/%Y  %H:%M:%S')
    df['timestamp'] = df['timestamp'].dt.strftime('%Y-%m-%d %H:%M:%S')
    df.index = df['timestamp']
    if 'P_Top ' in df.columns:
        df = df.rename(columns={'P_Top ':'P_Top','P_Bot ':'P_Bot','Sensirion ':'Sensirion'})
    return(df)

#Reading and calibrating data for the membrane setup'''
def Data_read_mem(x,vdict,z):
    df = pd.read_csv(open(x, 'rb'), delimiter=';',skiprows = skip(4,z),dtype={'P_Bot':np.float64},na_values=['*******','Invalid value!']) 
    df['timestamp'] = pd.to_datetime(df['Date/Time'],format = '%Y-%m-%d %H:%M:%S')
    df.index = df['timestamp']
    df['Pt'] = (df['P_Top']*vdict[m_top]+vdict[b_top]).astype("float")-900. #the 900 is the approximate difference between the sensors which is used if no calibration for the difference is done
    df['Pb'] = (df['P_Bot']*vdict[m_bot]+vdict[b_bot]).astype("float")
    df['Flow'] = 2*(df['Sensirion']-5) #in uL/min
    
    return(df)

#Calibrating the read data for only one setup"""

def calib_s(x,vdict):
    """Calibrating the read data for only one setup"""
    df = x
    z = vdict[calib1_time_1]
    
    if z == 0:

        df['Pt'] = (df['P_Top']*vdict[m_top]+vdict[b_top]).astype("float")-900. #the 900 is the approximate difference between the sensors which is used if no calibration for the difference is done
        df['Pb'] = (df['P_Bot']*vdict[m_bot]+vdict[b_bot]).astype("float")
        df['Flow'] = 24*(df['Sensirion']-5)

    if z != 0:
        y = vdict[date_1]+' '+vdict[calib1_time_1]+':00'
        a = datetime.strptime(y, '%Y-%m-%d %H:%M:%S') + timedelta(minutes=5)

        b = datetime.strptime(y, '%Y-%m-%d %H:%M:%S') + timedelta(minutes=10)
        c = b + timedelta(minutes=5)

        d = b + timedelta(minutes=10)
        e = d + timedelta(minutes=5)

        f = d + timedelta(minutes=10)
        g = f + timedelta(minutes=5)

        h = f + timedelta(minutes=10)
        i = h + timedelta(minutes=5)

        j = h + timedelta(minutes=10)
        k = j + timedelta(minutes=5)

        a = datetime.strftime(a, '%Y-%m-%d %H:%M:%S')
        b = datetime.strftime(b, '%Y-%m-%d %H:%M:%S')
        c = datetime.strftime(c, '%Y-%m-%d %H:%M:%S')
        d = datetime.strftime(d, '%Y-%m-%d %H:%M:%S')
        e = datetime.strftime(e, '%Y-%m-%d %H:%M:%S')
        f = datetime.strftime(f, '%Y-%m-%d %H:%M:%S')
        g = datetime.strftime(g, '%Y-%m-%d %H:%M:%S')
        h = datetime.strftime(h, '%Y-%m-%d %H:%M:%S')
        i = datetime.strftime(i, '%Y-%m-%d %H:%M:%S')
        j = datetime.strftime(j, '%Y-%m-%d %H:%M:%S')
        k = datetime.strftime(k, '%Y-%m-%d %H:%M:%S')

        V = [5, df['Sensirion'].loc[y:a].mean() \
             , df['Sensirion'].loc[b:c].mean(), df['Sensirion'].loc[d:e].mean(),df['Sensirion'].loc[f:g].mean(), df['Sensirion'].loc[h:i].mean(),df['Sensirion'].loc[j:k].mean()]

        Flow = [0,25,15,5,-25,-15,-5]
        fit = np.polyfit(V,Flow,1)
        fit_fn = np.poly1d(fit)

        m,b = np.polyfit(V, Flow, 1)

        df['Pt_temp'] = (df['P_Top'])*vdict[m_top]+vdict[b_top]
        df['Pb'] = (df['P_Bot']*vdict[m_bot]+vdict[b_bot]).astype("float")
        pdiff = df['Pt_temp'].loc[y:k].mean()-df['Pb'].loc[y:k].mean()
        df['Pt'] = df['Pt_temp']-pdiff
        
        df['Flow'] = m*df['Sensirion']+b
    
    return(df)

#Calibrating the read data for up to 3 setups"""

def calib_3(x,vdict):
    """Calibrating data for flow and pressure in all the different channels"""
    df = x
    z = vdict[date_1]+' '+vdict[calib1_time_1]+':00'
    cal = vdict[calib_fr]
    
    # Check which setups are used in the data and only analyze those, this avoids any errors if setup 2 is not in the data for example.
    # This also allows us to make a list to be looped over for each of the 3 setups.
    flows = []
    if 'F1 ' in df.columns:
        flows.append(1)
    if 'F2 ' in df.columns:
        flows.append(2)
    if 'F3 ' in df.columns:
        flows.append(3)
    
    for i in flows:

        if z != 0:
            # Select 5 minute timeframes of each flowrate section based on the calbration starting time  
            a = datetime.strptime(z, '%Y-%m-%d %H:%M:%S') + timedelta(minutes=5)
            b = datetime.strptime(z, '%Y-%m-%d %H:%M:%S') + timedelta(minutes=10)
            c = b + timedelta(minutes=5)

            d = b + timedelta(minutes=10)
            e = d + timedelta(minutes=5)

            f = d + timedelta(minutes=10)
            g = f + timedelta(minutes=5)

            h = f + timedelta(minutes=10)
            io = h + timedelta(minutes=5)

            j = h + timedelta(minutes=10)
            k = j + timedelta(minutes=5)
            
            l = k + timedelta(minutes=10)
            mo = l + timedelta(minutes=5)

            
            # Return calculated values to the correct form for date/time use
            a = datetime.strftime(a, '%Y-%m-%d %H:%M:%S')
            b = datetime.strftime(b, '%Y-%m-%d %H:%M:%S')
            c = datetime.strftime(c, '%Y-%m-%d %H:%M:%S')
            d = datetime.strftime(d, '%Y-%m-%d %H:%M:%S')
            e = datetime.strftime(e, '%Y-%m-%d %H:%M:%S')
            f = datetime.strftime(f, '%Y-%m-%d %H:%M:%S')
            g = datetime.strftime(g, '%Y-%m-%d %H:%M:%S')
            h = datetime.strftime(h, '%Y-%m-%d %H:%M:%S')
            io = datetime.strftime(io, '%Y-%m-%d %H:%M:%S')
            j = datetime.strftime(j, '%Y-%m-%d %H:%M:%S')
            k = datetime.strftime(k, '%Y-%m-%d %H:%M:%S')
            l = datetime.strftime(l, '%Y-%m-%d %H:%M:%S')
            mo = datetime.strftime(mo, '%Y-%m-%d %H:%M:%S')

            
            # Make a list with the voltage values of flow from the calibration
            df_fl = df['F'+str(i)+' ']

            V = [df_fl.loc[z:a].median(),df_fl.loc[b:c].median(),\
                 df_fl.loc[d:e].median(),df_fl.loc[f:g].median(),\
                 df_fl.loc[h:io].median(),df_fl.loc[j:k].median(),df_fl.loc[l:mo].median()]

            # Choose a list of the actual flow rate values applied by the syringe
            if cal == 60.:
                Flow = [0.,60.,40.,20.,-60.,-40.,-20.]
            if cal == 25:
                Flow = [0,25,15,5,-25,-15,-5]           
            
            fit = np.polyfit(V,Flow,1)
            fit_fn = np.poly1d(fit)

            m,b = np.polyfit(V, Flow, 1)
            
            # Equation to convert voltage values to flow values in uL/min
            df['Flow'+str(i)] = m*df_fl+b

            if 1 in flows:
                pdiff1 = df['P_1T '].loc[z:k].mean()-df['P_1B '].loc[z:k].mean()     
                df['P1t'] = (df['P_1T ']-pdiff1)*2*101325/0.073+101325
                df['P1b'] = df['P_1B ']*2*101325/0.073+101325    

            if 2 in flows:    
                pdiff2 = df['P_2T '].loc[z:k].mean()-df['P_2B '].loc[z:k].mean()
                df['P2t'] = (df['P_2T ']-pdiff2)*2*101325/0.073+101325
                df['P2b'] = df['P_2B ']*2*101325/0.073+101325

            if 3 in flows:
                # Pressures based on calibration calculations
                df['P3t_temp'] = (df['P_3T ']*vdict[m_top]+vdict[b_top]).astype("float")
                df['P3b'] = (df['P_3B ']*vdict[m_bot]+vdict[b_bot]).astype("float")
                # Offset at atmospheric pressure
                pdiff1 = df['P3t_temp'].loc[z:a].median()-df['P3b'].loc[z:a].median()
                
                calib2 = vdict[calib2_time_1] 
                
                if calib2 == 0:
                    df['P3t'] = (df['P3t_temp']-pdiff1).astype("float")
                
                if calib2 != 0: 
                    # Timeframe to choose pressure offset at low pressure
                    tp_e = vdict[date_1]+' '+vdict[calib2_time_2]+':00'
                    tp_b = datetime.strftime(datetime.strptime(tp_e, '%Y-%m-%d %H:%M:%S') - timedelta(minutes=5), '%Y-%m-%d %H:%M:%S')
                    # Offset at low pressure
                    pdiff2 = df['P3t_temp'].loc[tp_b:tp_e].median()-df['P3b'].loc[tp_b:tp_e].median()
                    #Slope and intercept of offset vs pressure measured as the difference changes between low and high pressure
                    m_corr = (pdiff1-pdiff2)/(df['P3b'].loc[z:a].median()-df['P3b'].loc[tp_b:tp_e].median())
                    b_corr = pdiff2 - m_corr*df['P3b'].loc[tp_b:tp_e].median()
                    # Pressure value based on offset
                    df['P3t'] = (df['P3t_temp']-(df['P3b']*m_corr+b_corr)).astype("float")
                
    return(df)

def calib_3p(x,vdict):
    """"""
    df = x
    z = vdict[date_1]+' '+vdict[calib1_time_1]+':00'
    cal = vdict[calib_fr]
    
    # Check which setups are used in the data and only analyze those, this avoids any errors if setup 2 is not in the data for example.
    # This also allows us to make a list to be looped over for each of the 3 setups.
    flows = []
    if 'F1 ' in df.columns:
        flows.append(1)
    if 'F2 ' in df.columns:
        flows.append(2)
    if 'F3 ' in df.columns:
        flows.append(3)
    
    for i in flows:

        if z != 0:
            # Select 5 minute timeframes of each flowrate section based on the calbration starting time  
            a = datetime.strptime(z, '%Y-%m-%d %H:%M:%S') + timedelta(minutes=5)
            b = datetime.strptime(z, '%Y-%m-%d %H:%M:%S') + timedelta(minutes=10)
            c = b + timedelta(minutes=5)

            d = b + timedelta(minutes=10)
            e = d + timedelta(minutes=5)

            f = d + timedelta(minutes=10)
            g = f + timedelta(minutes=5)

            #h = f + timedelta(minutes=10)
            #io = h + timedelta(minutes=5)

            #j = h + timedelta(minutes=10)
            #k = j + timedelta(minutes=5)
            
            #l = k + timedelta(minutes=10)
            #mo = l + timedelta(minutes=5)

            
            # Return calculated values to the correct form for date/time use
            a = datetime.strftime(a, '%Y-%m-%d %H:%M:%S')
            b = datetime.strftime(b, '%Y-%m-%d %H:%M:%S')
            c = datetime.strftime(c, '%Y-%m-%d %H:%M:%S')
            d = datetime.strftime(d, '%Y-%m-%d %H:%M:%S')
            e = datetime.strftime(e, '%Y-%m-%d %H:%M:%S')
            f = datetime.strftime(f, '%Y-%m-%d %H:%M:%S')
            g = datetime.strftime(g, '%Y-%m-%d %H:%M:%S')
            #h = datetime.strftime(h, '%Y-%m-%d %H:%M:%S')
            #io = datetime.strftime(io, '%Y-%m-%d %H:%M:%S')
            #j = datetime.strftime(j, '%Y-%m-%d %H:%M:%S')
            #k = datetime.strftime(k, '%Y-%m-%d %H:%M:%S')
            #l = datetime.strftime(l, '%Y-%m-%d %H:%M:%S')
            #mo = datetime.strftime(mo, '%Y-%m-%d %H:%M:%S')

            
            # Make a list with the voltage values of flow from the calibration
            df_fl = df['F'+str(i)+' ']

            V = [df_fl.loc[z:a].median(),df_fl.loc[b:c].median(),\
                 df_fl.loc[d:e].median(),df_fl.loc[f:g].median()]#, \df_fl.loc[h:io].median(), \df_fl.loc[j:k].median(),df_fl.loc[l:mo].median()

            # Choose a list of the actual flow rate values applied by the syringe
            if cal == 60.:
                Flow = [0.,60.,40.,20.]
                #,-60.,-40.,-20.
            if cal == 25:
                Flow = [0,25,15,5,-25,-15,-5]           
            
            fit = np.polyfit(V,Flow,1)
            fit_fn = np.poly1d(fit)

            m,b = np.polyfit(V, Flow, 1)
            
            # Equation to convert voltage values to flow values in uL/min
            df['Flow'+str(i)] = m*df_fl+b
            
            # Timeframe to choose pressure offset at low pressure
            tp_e = vdict[date_1]+' '+vdict[calib2_time_2]+':00'
            tp_b = datetime.strftime(datetime.strptime(tp_e, '%Y-%m-%d %H:%M:%S') - timedelta(minutes=5), '%Y-%m-%d %H:%M:%S')

            if 1 in flows:
                pdiff1 = df['P_1T '].loc[z:k].mean()-df['P_1B '].loc[z:k].mean()     
                df['P1t'] = (df['P_1T ']-pdiff1)*2*101325/0.073+101325
                df['P1b'] = df['P_1B ']*2*101325/0.073+101325    

            if 2 in flows:    
                pdiff2 = df['P_2T '].loc[z:k].mean()-df['P_2B '].loc[z:k].mean()
                df['P2t'] = (df['P_2T ']-pdiff2)*2*101325/0.073+101325
                df['P2b'] = df['P_2B ']*2*101325/0.073+101325

            if 3 in flows:
                # Pressures based on calibration calculations
                df['P3t_temp'] = (df['P_3T '])*m_top.subs(Variable.__defaults__)+b_top.subs(Variable.__defaults__)
                df['P3b'] = (df['P_3B ']*m_bot.subs(Variable.__defaults__)+b_bot.subs(Variable.__defaults__)).astype("float")
                # Offset at atmospheric pressure
                pdiff1 = df['P3t_temp'].loc[z:a].median()-df['P3b'].loc[z:a].median()
                # Offset at low pressure
                pdiff2 = df['P3t_temp'].loc[tp_b:tp_e].median()-df['P3b'].loc[tp_b:tp_e].median()
                #Slope and intercept of offset vs pressure measured as the difference changes between low and high pressure
                m_corr = (pdiff1-pdiff2)/(df['P3b'].loc[z:a].median()-df['P3b'].loc[tp_b:tp_e].median())
                b_corr = pdiff2 - m_corr*df['P3b'].loc[tp_b:tp_e].median()
                # Pressure value based on offset
                df['P3t'] = (df['P3t_temp']-(df['P3b']*m_corr+b_corr)).astype("float")
                
    return(df)

class L(Variable):
    """length of the twig"""
    unit = meter
    
class L_1(Variable):
    """length of the twig on location 1"""
    unit = meter

class L_2(Variable):
    """length of the twig on location 2"""
    unit = meter
    
class L_3(Variable):
    """length of the twig on location 3"""
    unit = meter

class d1(Variable):
    """diameter1 of the twig"""
    unit = meter
    latex_name = 'd_1'
    
class d2(Variable):
    """diameter2 of the twig"""
    unit = meter
    latex_name = 'd_2'
    
class date_1(Variable):
    """date of the experiment, add more of these variables if needed"""
    unit = 1

class date_2(Variable):
    """second date of the experiment, add more of these variables if needed"""
    unit = 1
    
class calib1_time_1(Variable):
    """time of first calibration for the flow sensor"""
    unit = 1
    
class calib_fr(Variable):
    """flow rate maximum of the used calibration"""
    unit = 1
    
class calib2_time_1(Variable):
    """time of second calibration for the pressure"""
    unit = 1
    
class calib2_time_2(Variable):
    """end time of second calibration for the pressure"""
    unit = 1
    
class start_time(Variable):
    """start time of the experiment"""
    unit = 1
    
class end_time(Variable):
    """end time of the experiment"""
    unit = 1
    
class m_bot (Variable):
    '''slope value of top pressure sensor'''
    latex_name = 'm_{b}'
    
class b_bot (Variable):
    '''y-intercept value of top pressure sensor'''
    latex_name = 'b_{b}'
    
class m_top (Variable):
    '''slope value of top pressure sensor'''
    latex_name = 'm_{t}'
    
class b_top (Variable):
    '''y-intercept value of top pressure sensor'''
    latex_name = 'b_{t}'

def plot_k(x,vdict,z):
    """Plot conductivity of a dataframe with the timing"""
    dfk = x
    
    d_span = vdict[date_2] #Check if there is a second date present to use    
    if d_span == 0:
        dfk_plot = dfk.loc[vdict[date_1]+' '+vdict[start_time]+':00':vdict[date_1]+' '+vdict[end_time]+':00']
    if d_span != 0:
        dfk_plot = dfk.loc[vdict[date_1]+' '+vdict[start_time]+':00':vdict[date_2]+' '+vdict[end_time]+':00']
    dfk_plot['t_elapsed'] = (pd.to_datetime(dfk_plot['timestamp'],format='%Y-%m-%d %H:%M:%S')-datetime.strptime(dfk_plot.index[0],'%Y-%m-%d %H:%M:%S')).astype("timedelta64[s]")/3600
    color = 'tab:orange'
    plt.ylabel('Conductivity ($kg m^{-1} Pa^{-1} s^{-1}$)',fontdict=font)# we already handled the x-label with ax1
    plt.plot(dfk_plot['t_elapsed'] , dfk_plot['conductivity'],color=color, lw=3)
    plt.tick_params(axis='y',labelsize = 17)
    plt.tick_params(axis='x', length=7, labelsize = 17)
    plt.ylim(0.,z)
    plt.grid()
    plt.xlabel('Time elapsed (hours)',fontdict=font)
    
def plot_k3(x,vdict,y,z):
    dfk = x
    
    d_span = vdict[date_2] #Check if there is a second date present to use    
    if d_span == 0:
        dfk_plot = dfk.loc[vdict[date_1]+' '+vdict[start_time]+':00':vdict[date_1]+' '+vdict[end_time]+':00']
    if d_span != 0:
        dfk_plot = dfk.loc[vdict[date_1]+' '+vdict[start_time]+':00':vdict[date_2]+' '+vdict[end_time]+':00']
        
    dfk_plot['t_elapsed'] = (pd.to_datetime(dfk_plot['timestamp'],format='%Y-%m-%d %H:%M:%S')-datetime.strptime(dfk_plot.index[0],'%Y-%m-%d %H:%M:%S')).astype("timedelta64[s]")/3600
    color = 'tab:orange'
    plt.ylabel('Conductivity ($kg m^{-1} Pa^{-1} s^{-1}$)',fontdict=font)# we already handled the x-label with ax1
    plt.plot(dfk_plot['t_elapsed'] , dfk_plot['conductivity'+str(y)],color=color, lw=3)
    plt.tick_params(axis='y',labelsize = 17)
    plt.tick_params(axis='x', length=7, labelsize = 17)
    plt.ylim(0.,z)
    plt.grid()
    plt.xlabel('Time elapsed (hours)',fontdict=font)   

    plt.tight_layout()  # otherwise the right y-label is slightly clipped
    
def plot_F3(x,vdict,y,z):
    dfk = x
    
    d_span = vdict[date_2] #Check if there is a second date present to use    
    if d_span == 0:
        dfk_plot = dfk.loc[vdict[date_1]+' '+vdict[start_time]+':00':vdict[date_1]+' '+vdict[end_time]+':00']
    if d_span != 0:
        dfk_plot = dfk.loc[vdict[date_1]+' '+vdict[start_time]+':00':vdict[date_2]+' '+vdict[end_time]+':00']
        
    dfk_plot['t_elapsed'] = (pd.to_datetime(dfk_plot['timestamp'],format='%Y-%m-%d %H:%M:%S')-datetime.strptime(dfk_plot.index[0],'%Y-%m-%d %H:%M:%S')).astype("timedelta64[s]")/3600
    color = 'tab:orange'
    plt.ylabel('Flow ($\mu L min^{-1}$)',fontdict=font)# we already handled the x-label with ax1
    plt.plot(dfk_plot['t_elapsed'] , dfk_plot['Flow'+str(y)],color=color, lw=3)
    plt.tick_params(axis='y',labelsize = 17)
    plt.tick_params(axis='x', length=7, labelsize = 17)
    plt.ylim(0.,z)
    plt.grid()
    plt.xlabel('Time elapsed (hours)',fontdict=font)   

    plt.tight_layout()  # otherwise the right y-label is slightly clipped