#!/bin/sh
#compiles and runs the model


texfile=$1
outfile=$2


file=${outfile##*/}
file_short=${file%".pdf"*}
outdir=${outfile%$file*}

texfile_short=${texfile##*/}
src_dir=${texfile%$texfile_short*}

echo $file
echo $file_short
echo $outdir
echo $src_dir

mkdir .renku/tmp/

#go over texfile and find all inputs
echo "Image files: "

grep "\includegraphics" $texfile | while read -r line ; do

   part1=${line#*{}
   file=${part1%'}'*}

   file_short=${file#*/}

   #find file in repository 
   file2=$(find data/ -type f | grep $file_short)

   #write all inputs to .renku/tmp/inputs.txt if it exists
   if test -f "$file2"; then
    echo $file2 >> .renku/tmp/inputs.txt 
    echo $file2
   fi



done


echo "Bib-files: "
grep -F "\bibliography{" $texfile | while read -r line ; do

   part1=${line#*{}
   file=${part1%'}'*}

   file_short=${file#*/}
   
   #find file in repository 
   file2=$(find src/ -type f | grep $file_short)

   echo $file2

   #write all inputs to .renku/tmp/inputs.txt
   echo $file2 >> .renku/tmp/inputs.txt

done


echo "Style-files: "
grep -F "\documentclass[" $texfile | while read -r line ; do

   part1=${line#*{}
   file=${part1%'}'*}
   
   file_short=${file#*/}

   #find file in repository 
   file2=$(find src/ -type f | grep $file_short.bst)

   #write all inputs to .renku/tmp/inputs.txt
   echo $file2
   echo $file2 >> .renku/tmp/inputs.txt  

   file2=$(find src/ -type f | grep $file_short.cfg)   
   echo $file2
   echo $file2 >> .renku/tmp/inputs.txt
   
   file2=$(find src/ -type f | grep $file_short.cls)   
   echo $file2   
   echo $file2 >> .renku/tmp/inputs.txt
done


cd $src_dir


#compile the pdf
pdflatex -jobname $file_short $texfile_short 
bibtex $file_short
pdflatex -jobname $file_short $texfile_short 
pdflatex -jobname $file_short $texfile_short 

cd -

#move files to output dir. 
cp $src_dir$file_short.pdf $outdir$file_short.pdf

rm $src_dir$file_short.aux
rm $src_dir$file_short.log
rm $src_dir$file_short.bbl
rm $src_dir$file_short.blg
rm $src_dir$file_short.pdf


