The repository that also shows the lineage of how files are connected can be found in the [renkulab version](https://renkulab.io/projects/louis.krieger/plantwatertransport).

# Experiments and notebooks relating to plant water transport

Need to `pip install essm`, `pip install theano`, and `pip install iapws` before using notebooks.

## Contents:

### Paper 1:

All [renku commands](https://renkulab.io/gitlab/louis.krieger/plantwatertransport/-/blob/498ceaa281eda57ba6f53eb015d722182a142d80/notebooks/paper1/renku_commands_paper1) are run from the home folder of the repository. 

1. First the graph are created from the notebook [graphs_for_paper.ipynb](https://renkulab.io/gitlab/louis.krieger/plantwatertransport/-/blob/498ceaa281eda57ba6f53eb015d722182a142d80/notebooks/paper1/graphs_for_paper.ipynb) using the first renku command.

2. Followed by using those graphs to compile the paper itself from [paper1.tex](https://renkulab.io/gitlab/louis.krieger/plantwatertransport/-/blob/498ceaa281eda57ba6f53eb015d722182a142d80/writing/paper1/paper1.tex) with the second command. 

Additional notebooks where the graphs are a bit more in context can be found in the [paper1 subfolder in notebooks](https://renkulab.io/gitlab/louis.krieger/plantwatertransport/-/tree/writing/notebooks/paper1):

- [Measuring_effects_of_low_pressure_on_twigs.ipynb](https://renkulab.io/gitlab/louis.krieger/plantwatertransport/-/blob/498ceaa281eda57ba6f53eb015d722182a142d80/notebooks/paper1/Measuring_effects_of_low_pressure_on_twigs.ipynb): Master notebook for analyzing results of cavitation inducing experiments in twigs with membrane setup.

- [constant_flow_water.ipynb](https://renkulab.io/gitlab/louis.krieger/plantwatertransport/-/blob/498ceaa281eda57ba6f53eb015d722182a142d80/notebooks/paper1/constant_flow_water.ipynb): Notebook looking at running flow through a twig with water in a single direction.

- [Sperry_gravitational-stress.ipynb](https://renkulab.io/gitlab/louis.krieger/plantwatertransport/-/blob/498ceaa281eda57ba6f53eb015d722182a142d80/notebooks/paper1/Sperry_gravitational-stress.ipynb): Notebook with the Sperry gravitational experiment, stress application experiments, and the leak and storage experiment.


### Other files that are not organized yet ---

- [Analysis](notebooks/Analysis): Folder containing jupyter notebooks to analyse results of experiments.

    - [Transforming_measuring_effects_into_dataframe.ipynb](notebooks/Analysis/Transforming_measuring_effects_into_dataframe.ipynb): General notebook containing all membrane setup experiments.

    - [25uLmin_flow_with_bench_vise.ipynb](notebooks/Analysis/25uLmin_flow_with_bench_vise.ipynb): Results from experiment with twig and bench vise.

    - [Back_and_forth_KCl.ipynb](notebooks/Analysis/back_and_forth_KCl.ipynb): Notebook looking at running flow back and forth vs a twig with 10mM KCl solution.

    - [Back_and_forth_water+oxalic.ipynb](notebooks/Analysis/back_and_forth_water+oxalic.ipynb): Notebook looking at running flow back and forth vs a twig while swapping between water and 10mM oxalic acid solution.

    - [Back_and_forth_water.ipynb](notebooks/Analysis/back_and_forth_water.ipynb): Notebook looking at running flow back and forth vs a twig with water.

    - [closing_valve_with_syringe_pump.ipynb](notebooks/Analysis/closing_valve_with_syringe_pump.ipynb): Experimental results obtained from syringe pump setup.

    - [Pull_syringe_and_return.ipynb](notebooks/Analysis/Pull_syringe_and_return.ipynb): Notebook looking at the pressure pattern in the syringe setup when reduced quickly and returned.
    
    - [Test_pressure_sensor_bypass.ipynb](notebooks/Analysis/Test_pressure_sensor_bypass.ipynb): Notebook containing test for bypass valve system which allows for sensors to measure both sides of the twig individually.

    - [Torres-Ruiz_2012_experiment_trials.ipynb](notebooks/Analysis/Torres-Ruiz_2012_experiment_trials.ipynb): Notebook looking at various experiments while also looking at 'passive flow'.

    - [triple_setup_quick_analysis.ipynb](notebooks/Analysis/triple_setup_quick_analysis.ipynb): Notebook to quickly check the triple setup before adding to the appropriate notebook.

    - [output](notebooks/Analysis/output): Folder containing all graphs and outputs from the notebooks in [Analysis](Analysis).

    - [definitions.py](notebooks/Analysis/definitions.py): python file containing definitions for reading and graphing data from experiments. 

    - [cryo_test_analysis.ipynb](notebooks/Analysis/cryo_test_analysis.ipynb): Notebook to test cryo analysis of some samples.

    - [Test_pressure_sensor_bypass.ipynb](notebooks/Analysis/Test_pressure_sensor_bypass.ipynb): Notebook with experiment testing the effect of the pressure calibration using the bypass.

- [extra_calculations](notebooks/extra_calculations): Folder containing base calculations that are imported into the other notebooks in [Analysis](notebooks/Analysis).
    - [Air_entry_calculations.ipynb](notebooks/extra_calculations/Air_entry_calculations.ipynb): File for calculating the air entry of pores.
    - [Capillary_flow_calculations.ipynb](notebooks/extra_calculations/Capillary_flow_calculations.ipynb): File for calculating pressure drop along a capillary using the Hagen-Poisseuille equation.
    - [Intrinsic_permeability.ipynb](notebooks/extra_calculations/Intrinsic_permeability.ipynb): File to create equations for intrinsic permeability calculations in other notebooks. 
    - [Converting_Cochard_2002_to_jupyter.ipynb](notebooks/extra_calculations/Converting_Cochard_2002_to_jupyter.ipynb): Notebook redoing calculations from the mentioned paper.
    - [Pressure_in_siphon.ipynb](notebooks/extra_calculations/Pressure_in_siphon.ipynb): Notebook calculating a pressure vs position profile in a siphon.

- [hardware](hardware): Folder containing all the hardware used with their calibration.
    - [calibrations](hardware/calibrations): Folder containing the calibration notebooks of each hardware piece. The .py files with the calibration equations and variables are found in [output](hardware/calibrations/output)

- [data](data/my_data): Folder containing all own data for the notebooks.

- [images](images): Folder containing images from FLIR camera and drawings used in the notebooks and write-ups.
 
- [writing](writing): Folder containing the different write-ups from experiments in this project.
    - [paper1](writing/paper1): Folder containing latex file for first paper written based on results.
    - [Experimental_setup](writing/Experimental_setup): Folder containing latex file discussing the experimental setup overall.
    - [back_and_forth](writing/back_and_forth): Folder containing latex file discussing experiments related to directionality and pressure.
