from sympy.physics.units import convert_to
from essm import Eq, e
from essm.equations import Equation
from essm.variables import Variable
from essm.variables.utils import generate_metadata_table
from essm.variables.units import derive_unit, derive_baseunit, markdown, SI
from essm.variables.units import joule, kelvin, kilogram, meter, pascal, second, watt, newton,mol
import sys
import math
import glob
import os
import warnings
import importlib
import pandas as pd
import numpy as np
import matplotlib as mpl
import matplotlib.pyplot as plt
import matplotlib.dates as md
from matplotlib.dates import DateFormatter
from sympy import latex
from sympy import N
from numpy import arange
from datetime import datetime, timedelta 
from sympy.printing.theanocode import theano_function


# Defining fonts to use later on
font_S = {'family':'serif' , 'color':'black' , 'weight':'normal' , 'size': 14,}
font = {'family':'serif' , 'color':'black' , 'weight':'normal' , 'size': 20,}
font_L = {'family':'serif' , 'color':'black' , 'weight':'normal' , 'size': 26,}

#To skip rows other than the header"""
def skip(x,z):
    if z == 1:
        y = [i for i in range(2,x)]
        x1 = [0]
        result = x1 + y
    if z == 0:
        result = [i for i in range(1,x)]
    return(result)

#Reading data"""
def Data_read(x,z):
	df = pd.read_csv(open(x, 'rb'), delimiter=';',skiprows = skip(4,z),dtype={'P_Bot':np.float64},na_values=['*******','Invalid value!']) 
	df['timestamp'] = pd.to_datetime(df['Date/Time'],format = '%Y-%m-%d %H:%M:%S')
	df.index = df['timestamp']   
	return(df)

#Reading data"""
def Data_read2(x,z):
    df = pd.read_csv(open(x, 'rb'), delimiter=';',skiprows = skip(3,z),dtype={'P_Bot':np.float64},na_values=['*******','Invalid value!']) 
    df['timestamp'] = pd.to_datetime(df['Date/Time'],format = '%d/%m/%Y  %H:%M:%S')
    df['timestamp'] = df['timestamp'].dt.strftime('%Y-%m-%d %H:%M:%S')
    df.index = df['timestamp']
    if 'P_Top ' in df.columns:
        df = df.rename(columns={'P_Top ':'P_Top','P_Bot ':'P_Bot','Sensirion ':'Sensirion'})
    return(df)

#Calibrating the read data for only one setup"""

def calib_s(x,y):
    df = x
    
    if y == 0:

        df['Pt'] = df['P_Top']*1326758.43219573+98240.22024059
        df['Pb'] = df['P_Bot']*1345529.78563436+99723.3403640686
        df['Flow'] = 24*(df['Sensirion']-5)

    if y != 0:
        a = datetime.strptime(y, '%Y-%m-%d %H:%M:%S') + timedelta(minutes=5)

        b = datetime.strptime(y, '%Y-%m-%d %H:%M:%S') + timedelta(minutes=10)
        c = b + timedelta(minutes=5)

        d = b + timedelta(minutes=10)
        e = d + timedelta(minutes=5)

        f = d + timedelta(minutes=10)
        g = f + timedelta(minutes=5)

        h = f + timedelta(minutes=10)
        i = h + timedelta(minutes=5)

        j = h + timedelta(minutes=10)
        k = j + timedelta(minutes=5)

        a = datetime.strftime(a, '%Y-%m-%d %H:%M:%S')
        b = datetime.strftime(b, '%Y-%m-%d %H:%M:%S')
        c = datetime.strftime(c, '%Y-%m-%d %H:%M:%S')
        d = datetime.strftime(d, '%Y-%m-%d %H:%M:%S')
        e = datetime.strftime(e, '%Y-%m-%d %H:%M:%S')
        f = datetime.strftime(f, '%Y-%m-%d %H:%M:%S')
        g = datetime.strftime(g, '%Y-%m-%d %H:%M:%S')
        h = datetime.strftime(h, '%Y-%m-%d %H:%M:%S')
        i = datetime.strftime(i, '%Y-%m-%d %H:%M:%S')
        j = datetime.strftime(j, '%Y-%m-%d %H:%M:%S')
        k = datetime.strftime(k, '%Y-%m-%d %H:%M:%S')

        V = [5, df['Sensirion'].loc[y:a].mean() \
             , df['Sensirion'].loc[b:c].mean(), df['Sensirion'].loc[d:e].mean(),df['Sensirion'].loc[f:g].mean(), df['Sensirion'].loc[h:i].mean(),df['Sensirion'].loc[j:k].mean()]

        #pdiff = df['P_Top'].loc[y:k].mean()-df['P_Bot'].loc[y:k].mean()
        Flow = [0,25,15,5,-25,-15,-5]
        fit = np.polyfit(V,Flow,1)
        fit_fn = np.poly1d(fit)

        m,b = np.polyfit(V, Flow, 1)

        df['Pt_temp'] = (df['P_Top'])*1326758.43219573+98240.22024059
        df['Pb'] = df['P_Bot']*1345529.78563436+99723.3403640686
        pdiff = df['Pt_temp'].loc[y:k].mean()-df['Pb'].loc[y:k].mean()
        df['Pt'] = df['Pt_temp']+pdiff
        
        df['Flow'] = m*df['Sensirion']+b

    df.loc[df['Flow'] > 0., 'Syringe'] = 25. #turn data to either 25 or -25
    df.loc[df['Flow'] < 0., 'Syringe'] = -25.
    df['Fdiff'] = - df['Flow'] + df['Syringe']
    
    return(df)

#Calibrating the read data for up to 3 setups"""

def calib_3(x,z,cal):
    df = x
    
    flows = []
    if 'F1 ' in df.columns:
        flows.append(1)
    if 'F2 ' in df.columns:
        flows.append(2)
    if 'F3 ' in df.columns:
        flows.append(3)
    
    for i in flows:
        
        
    
        #if z == 0:
        
         #   df['Flow'+str(i)] = -24*(df['F'+str(i)+' ']-5)
          #  df.loc[df['Flow'+str(i)] > 0., 'Syringe'+str(i)] = 25. #turn data to either 25 or -25
           # df.loc[df['Flow'+str(i)] < 0., 'Syringe'+str(i)] = -25.
            
            #if 1 in flows:
                    
             #   df['P1t'] = (df['P_1T '])*2*101325/0.073+101325-900
#                df['P1b'] = df['P_1B ']*2*101325/0.073+101325    

 #           if 2 in flows:    
                
  #              df['P2t'] = (df['P_2T '])*2*101325/0.073+101325
   #             df['P2b'] = df['P_2B ']*2*101325/0.073+101325

    #        if 3 in flows:
                
     #           df['P3t'] = (df['P_3T '])*1326758.43219573+98240.22024059
      #          df['P3b'] = df['P_3B ']*1345529.78563436+99723.3403640686

        if z != 0:
        
            a = datetime.strptime(z, '%Y-%m-%d %H:%M:%S') + timedelta(minutes=5)
            b = datetime.strptime(z, '%Y-%m-%d %H:%M:%S') + timedelta(minutes=10)
            c = b + timedelta(minutes=5)

            d = b + timedelta(minutes=10)
            e = d + timedelta(minutes=5)

            f = d + timedelta(minutes=10)
            g = f + timedelta(minutes=5)

            h = f + timedelta(minutes=10)
            io = h + timedelta(minutes=5)

            j = h + timedelta(minutes=10)
            k = j + timedelta(minutes=5)

            a = datetime.strftime(a, '%Y-%m-%d %H:%M:%S')
            b = datetime.strftime(b, '%Y-%m-%d %H:%M:%S')
            c = datetime.strftime(c, '%Y-%m-%d %H:%M:%S')
            d = datetime.strftime(d, '%Y-%m-%d %H:%M:%S')
            e = datetime.strftime(e, '%Y-%m-%d %H:%M:%S')
            f = datetime.strftime(f, '%Y-%m-%d %H:%M:%S')
            g = datetime.strftime(g, '%Y-%m-%d %H:%M:%S')
            h = datetime.strftime(h, '%Y-%m-%d %H:%M:%S')
            io = datetime.strftime(io, '%Y-%m-%d %H:%M:%S')
            j = datetime.strftime(j, '%Y-%m-%d %H:%M:%S')
            k = datetime.strftime(k, '%Y-%m-%d %H:%M:%S')

            df_fl = df['F'+str(i)+' ']

            V = [5,df_fl.loc[z:a].mean(),df_fl.loc[b:c].mean(),\
                 df_fl.loc[d:e].mean(),df_fl.loc[f:g].mean(), \
                 df_fl.loc[h:io].mean(), \
                 df_fl.loc[j:k].mean()]

            pdiff = df['P_'+str(i)+'T '].loc[z:k].mean()-df['P_'+str(i)+'B '].loc[z:k].mean()
            
            if cal == 60.:
                Flow = [0.,60.,40.,20.,-60.,-40.,-20.]
            if cal == 25:
                Flow = [0,25,15,5,-25,-15,-5]           
            
            fit = np.polyfit(V,Flow,1)
            fit_fn = np.poly1d(fit)

            m,b = np.polyfit(V, Flow, 1)

            df['Flow'+str(i)] = m*df_fl+b        

            df.loc[df['Flow'+str(i)] > 0., 'Syringe'+str(i)] = 25. #turn data to either 25 or -25
            df.loc[df['Flow'+str(i)] < 0., 'Syringe'+str(i)] = -25.
            df['Fdiff'+str(i)] = - df['Flow'+str(i)] + df['Syringe'+str(i)]
        
            if 1 in flows:
                pdiff1 = df['P_1T '].loc[z:k].mean()-df['P_1B '].loc[z:k].mean()     
                df['P1t'] = (df['P_1T ']-pdiff1)*2*101325/0.073+101325
                df['P1b'] = df['P_1B ']*2*101325/0.073+101325    

            if 2 in flows:    
                pdiff2 = df['P_2T '].loc[z:k].mean()-df['P_2B '].loc[z:k].mean()
                df['P2t'] = (df['P_2T ']-pdiff2)*2*101325/0.073+101325
                df['P2b'] = df['P_2B ']*2*101325/0.073+101325

            if 3 in flows:
                df['P3t_temp'] = (df['P_3T '])*1326758.43219573+98240.22024059
                df['P3b'] = df['P_3B ']*1345529.78563436+99723.3403640686
                pdiff = df['P3t_temp'].loc[z:a].mean()-df['P3b'].loc[z:a].mean()
                df['P3t'] = df['P3t_temp']-pdiff
                
    return(df)

#Calibrating the read data for up to 3 setups without space in titles of columns"""

def calib_3n(x,z):
    df = x
    
    flows = []
    if 'F1' in df.columns:
        flows.append(1)
    if 'F2' in df.columns:
        flows.append(2)
    if 'F3' in df.columns:
        flows.append(3)
    
    for i in flows:
        
        
    
        if z == 0:
        
            df['Flow'+str(i)] = -24*(df['F'+str(i)]-5)
            df.loc[df['Flow'+str(i)] > 0., 'Syringe'+str(i)] = 25. #turn data to either 25 or -25
            df.loc[df['Flow'+str(i)] < 0., 'Syringe'+str(i)] = -25.
            
            if 1 in flows:
                    
                df['P1t'] = (df['P_1T'])*2*101325/0.073+101325-900
                df['P1b'] = df['P_1B']*2*101325/0.073+101325    

            if 2 in flows:    
                
                df['P2t'] = (df['P_2T'])*2*101325/0.073+101325
                df['P2b'] = df['P_2B']*2*101325/0.073+101325

            if 3 in flows:
                
                df['P3t'] = (df['P_3T'])*1326758.43219573+98240.22024059
                df['P3b'] = df['P_3B']*1345529.78563436+99723.3403640686

        if z != 0:
        
            a = datetime.strptime(z, '%Y-%m-%d %H:%M:%S') + timedelta(minutes=5)
            b = datetime.strptime(z, '%Y-%m-%d %H:%M:%S') + timedelta(minutes=10)
            c = b + timedelta(minutes=5)

            d = b + timedelta(minutes=10)
            e = d + timedelta(minutes=5)

            f = d + timedelta(minutes=10)
            g = f + timedelta(minutes=5)

            h = f + timedelta(minutes=10)
            io = h + timedelta(minutes=5)

            j = h + timedelta(minutes=10)
            k = j + timedelta(minutes=5)

            a = datetime.strftime(a, '%Y-%m-%d %H:%M:%S')
            b = datetime.strftime(b, '%Y-%m-%d %H:%M:%S')
            c = datetime.strftime(c, '%Y-%m-%d %H:%M:%S')
            d = datetime.strftime(d, '%Y-%m-%d %H:%M:%S')
            e = datetime.strftime(e, '%Y-%m-%d %H:%M:%S')
            f = datetime.strftime(f, '%Y-%m-%d %H:%M:%S')
            g = datetime.strftime(g, '%Y-%m-%d %H:%M:%S')
            h = datetime.strftime(h, '%Y-%m-%d %H:%M:%S')
            io = datetime.strftime(io, '%Y-%m-%d %H:%M:%S')
            j = datetime.strftime(j, '%Y-%m-%d %H:%M:%S')
            k = datetime.strftime(k, '%Y-%m-%d %H:%M:%S')

            df_fl = df['F'+str(i)]

            V = [5,df_fl.loc[z:a].mean(),df_fl.loc[b:c].mean(),\
                 df_fl.loc[d:e].mean(),df_fl.loc[f:g].mean(), \
                 df_fl.loc[h:io].mean(), \
                 df_fl.loc[j:k].mean()]

            pdiff = df['P_'+str(i)+'T'].loc[z:k].mean()-df['P_'+str(i)+'B'].loc[z:k].mean()
            Flow = [0,60,40,20,-60,-40,-20]
            fit = np.polyfit(V,Flow,1)
            fit_fn = np.poly1d(fit)

            m,b = np.polyfit(V, Flow, 1)

            df['Flow'+str(i)] = m*df_fl+b        

            df.loc[df['Flow'+str(i)] > 0., 'Syringe'+str(i)] = 25. #turn data to either 25 or -25
            df.loc[df['Flow'+str(i)] < 0., 'Syringe'+str(i)] = -25.
            df['Fdiff'+str(i)] = - df['Flow'+str(i)] + df['Syringe'+str(i)]
        
            if 1 in flows:
                pdiff1 = df['P_1T'].loc[z:k].mean()-df['P_1B'].loc[z:k].mean()     
                df['P1t'] = (df['P_1T']-pdiff1)*2*101325/0.073+101325
                df['P1b'] = df['P_1B']*2*101325/0.073+101325    

            if 2 in flows:    
                pdiff2 = df['P_2T'].loc[z:k].mean()-df['P_2B'].loc[z:k].mean()
                df['P2t'] = (df['P_2T']-pdiff2)*2*101325/0.073+101325
                df['P2b'] = df['P_2B']*2*101325/0.073+101325

            if 3 in flows:
                pdiff3 = df['P_3T'].loc[z:k].mean()-df['P_3B'].loc[z:k].mean()
                df['P3t'] = (df['P_3T']-pdiff3)*1326758.43219573+98240.22024059
                df['P3b'] = df['P_3B']*1345529.78563436+99723.3403640686
                
    return(df)


#Plotting all main columns for one setup"""

def plot_all_s(a,b):
	fig, ax = plt.subplots(nrows=2, ncols=1,figsize=(13,8),sharex=True)
	fig.subplots_adjust(right=0.7)
	a.plot(y=['Flow'], color=['blue'],use_index=True,ax=ax[1],lw=4)
	ax[1].set_ylabel("Flow ($\mu L$ $min^{-1}$)", fontdict=font)
	a.plot(y=['Pt' ,'Pb'],color=['darkgreen','brown'],use_index=True, ax=ax[0],lw=4)
	a.plot(y=['permeability'],color=['orange'],use_index=True,secondary_y=True, ax=ax[0],lw=1)
	ax[0].set_ylabel('Pressure (Pa)', fontdict=font)
	ax[1].set_xlabel("Time", fontdict=font)
	plt.ylabel("k ($m^2$)", fontdict=font)
	plt.ylim(0.,b)
	ax[1].legend(bbox_to_anchor=(1.23, 0.95))
	ax[0].legend([ax[0].right_ax.get_lines()[0],ax[0].get_lines()[0], ax[0].get_lines()[1]],\
          ['Permeability of the twig','Pressure after twig (Right)','Pressure before twig (Right)'], bbox_to_anchor=(1.1, 0.2))
    #ax[0].annotate('System failure',xy =('2019-06-22 14:00:17',0.), xytext=('2019-06-22 10:00:00',-5000.),arrowprops = dict(facecolor = 'black'))
    #ax[1].text('2021-02-02 16:50:17',80,'RS',fontdict=font)
	ax[1].axhline(y=25.,linestyle='dashed',color="darkslategrey")
	ax[1].axhline(y=-25.,linestyle='dashed',color="darkslategrey")
	fig.subplots_adjust(hspace=0)
	ax[0].tick_params(axis='both', which='both', labelsize=17)
	ax[1].tick_params(axis='y', which='both', labelsize=17)
	ax[1].tick_params(axis='x', which='both', labelsize=17, rotation = 45)
	ax[1].axhline(y=0.,linestyle='dashed',color="darkslategrey")
	plt.tick_params(axis='y', labelsize=17)
    
    
#Plotting all main columns for one setup"""

def plot_all_s(x,b,t1,kK):
    
    if kK == 'k':
        kK = 'permeability'
        label = 'k ($m^2$)'
    if kK == 'K':
        kK = 'conductivity'
        label = 'K ($m s^{-1 }$)'
    
    dfF = x
    dfF['t_elapsed'] = (pd.to_datetime(dfF['timestamp'],format='%Y-%m-%d %H:%M:%S')-datetime.strptime(t1,'%Y-%m-%d %H:%M:%S')).astype("timedelta64[s]")/3600
    dfF.index = dfF['t_elapsed']
    
    fig, ax = plt.subplots(nrows=2, ncols=1,figsize=(13,8),sharex=True)
    fig.subplots_adjust(right=0.7)
    dfF.plot(y=['Flow'], color=['blue'],use_index=True,ax=ax[1],lw=4)
    ax[1].set_ylabel("Flow ($\mu L$ $min^{-1}$)", fontdict=font)
    dfF.plot(y=['Pt' ,'Pb'],color=['darkgreen','brown'],use_index=True, ax=ax[0],lw=4)
    dfF.plot(y=[str(kK)],color=['orange'],use_index=True,secondary_y=True, ax=ax[0],lw=1)
    ax[0].set_ylabel('Pressure (Pa)', fontdict=font)
    ax[1].set_xlabel("Time", fontdict=font)
    plt.ylabel(label, fontdict=font)
    plt.ylim(0.,b)
    ax[1].legend(bbox_to_anchor=(1.23, 0.95))
    ax[0].legend([ax[0].right_ax.get_lines()[0],ax[0].get_lines()[0], ax[0].get_lines()[1]],\
          [str(kK) + 'of the twig','Pressure after twig (Right)','Pressure before twig (Right)'], bbox_to_anchor=(1.1, 0.2))
    fig.subplots_adjust(hspace=0)
    ax[0].tick_params(axis='both', which='both', labelsize=17)
    ax[1].tick_params(axis='both', which='both', labelsize=17)
    ax[1].axhline(y=0.,linestyle='dashed',color="darkslategrey")
    plt.tick_params(axis='y', labelsize=17)
    

#Plotting flow and pressure"""

def plot_FP(x,z,t1):

    dfF = x
    dfF['t_elapsed'] = (pd.to_datetime(dfF['timestamp'],format='%Y-%m-%d %H:%M:%S')-datetime.strptime(t1,'%Y-%m-%d %H:%M:%S')).astype("timedelta64[s]")/3600
    dfF.index = dfF['t_elapsed']
    
    fig, ax = plt.subplots(nrows=2, ncols=1,figsize=(13,8),sharex=True)
    
    dfF.plot(y=['Flow'+str(z)], color=['blue'],use_index=True,ax=ax[1],lw=4)
    ax[1].set_ylabel("Flow ($\mu L$ $min^{-1}$)", fontdict=font)
    dfF.plot(y=['P'+str(z)+'t' ,'P'+str(z)+'b'],color=['darkgreen','brown'],use_index=True, ax=ax[0],lw=4)
    
    ax[0].set_ylabel('Pressure (Pa)', fontdict=font)
    ax[1].set_xlabel('Time elapsed (hours)', fontdict=font)
    ax[1].set_zorder(-1)
    ax[1].get_legend().remove()
    ax[0].legend([ax[0].get_lines()[1], ax[0].get_lines()[0],ax[1].get_lines()[0]],\
          ['Pressure before twig','Pressure after twig','Flow'], bbox_to_anchor=(0.25, 0.))
    #ax[0].annotate('System failure',xy =('2019-06-22 14:00:17',0.), xytext=('2019-06-22 10:00:00',-5000.),arrowprops = dict(facecolor = 'black'))
    #ax[1].text('2021-02-02 16:50:17',80,'RS',fontdict=font)
    fig.subplots_adjust(hspace=0)
    ax[0].tick_params(axis='both', which='both', labelsize=17)
    ax[1].tick_params(axis='both', which='both', labelsize=17)
    plt.tick_params(axis='y', labelsize=17)
    
#Plotting all main columns for up to 3 setups"""

def plot_all_3(x,b,z,t1,kK):
    if kK == 'k':
        kK = 'permeability'
        label = 'k ($m^2$)'
    if kK == 'K':
        kK = 'conductivity'
        label = 'K ($m s^{-1}$)'
    
    dfF = x
    dfF['t_elapsed'] = (pd.to_datetime(dfF['timestamp'],format='%Y-%m-%d %H:%M:%S')-datetime.strptime(t1,'%Y-%m-%d %H:%M:%S')).astype("timedelta64[s]")/3600
    dfF.index = dfF['t_elapsed']
    
    fig, ax = plt.subplots(nrows=2, ncols=1,figsize=(13,8),sharex=True)
    fig.subplots_adjust(right=0.7)
    
    dfF.plot(y=['Flow'+str(z)], color=['blue'],use_index=True,ax=ax[1],lw=4)
    ax[1].set_ylabel("Flow ($\mu L$ $min^{-1}$)", fontdict=font)
    dfF.plot(y=['P'+str(z)+'t' ,'P'+str(z)+'b'],color=['darkgreen','brown'],use_index=True, ax=ax[0],lw=4)
    dfF.plot(y=[str(kK)+str(z)],color=['orange'],use_index=True,secondary_y=True, ax=ax[0],lw=1)
    ax[0].set_ylabel('Pressure (Pa)', fontdict=font)
    ax[1].set_xlabel('Time elapsed (hours)', fontdict=font)
    plt.ylabel(label, fontdict=font)
    plt.ylim(0.,b)
    ax[1].set_zorder(-1)
    ax[1].get_legend().remove()
    ax[0].legend([ax[0].right_ax.get_lines()[0],ax[0].get_lines()[0], ax[0].get_lines()[1],ax[1].get_lines()[0]],\
        [str(kK) + 'of the twig (Right)','Pressure after twig (Left)','Pressure before twig (Left)','Flow'], bbox_to_anchor=(1., 0.9))
    ax[0].grid()
    ax[1].grid()
    #ax[0].annotate('System failure',xy =('2019-06-22 14:00:17',0.), xytext=('2019-06-22 10:00:00',-5000.),arrowprops = dict(facecolor = 'black'))
    #ax[1].text('2021-02-02 16:50:17',80,'RS',fontdict=font)
    ax[1].axhline(y=25.,linestyle='dashed',color="darkslategrey")
    #ax[1].axhline(y=-25.,linestyle='dashed',color="darkslategrey")
    fig.subplots_adjust(hspace=0)
    ax[0].tick_params(axis='both', which='both', labelsize=17)
    ax[1].tick_params(axis='both', which='both', labelsize=17)
    ax[1].axhline(y=0.,linestyle='dashed',color="darkslategrey")
    plt.tick_params(axis='y', labelsize=17)

    
#Plotting all main columns for up to 3 setups but with syring permeability"""
    
def plot_all_3S(x,b,z,t1):
    dfF = x
    dfF['t_elapsed'] = (pd.to_datetime(dfF['timestamp'],format='%Y-%m-%d %H:%M:%S')-datetime.strptime(t1,'%Y-%m-%d %H:%M:%S')).astype("timedelta64[s]")/3600
    dfF.index = dfF['t_elapsed']
    
    fig, ax = plt.subplots(nrows=2, ncols=1,figsize=(13,8),sharex=True)
    fig.subplots_adjust(right=0.7)
    
    dfF.plot(y=['Flow'+str(z)], color=['blue'],use_index=True,ax=ax[1],lw=4)
    ax[1].set_ylabel("Flow ($\mu L$ $min^{-1}$)", fontdict=font)
    dfF.plot(y=['P'+str(z)+'t' ,'P'+str(z)+'b'],color=['darkgreen','brown'],use_index=True, ax=ax[0],lw=4)
    dfF.plot(y=['permeability_S'+str(z)],color=['orange'],use_index=True,secondary_y=True, ax=ax[0],lw=1)
    ax[0].set_ylabel('Pressure (Pa)', fontdict=font)
    ax[1].set_xlabel('Time elapsed (hours)', fontdict=font)
    plt.ylabel("k ($m^2$)", fontdict=font)
    plt.ylim(0.,b)
    ax[1].legend(bbox_to_anchor=(1.23, 0.95))
    ax[0].legend([ax[0].right_ax.get_lines()[0],ax[0].get_lines()[0], ax[0].get_lines()[1]],\
          ['Permeability of the twig','Pressure after twig (Right)','Pressure before twig (Right)'], bbox_to_anchor=(1.1, 0.2))
    #ax[0].annotate('System failure',xy =('2019-06-22 14:00:17',0.), xytext=('2019-06-22 10:00:00',-5000.),arrowprops = dict(facecolor = 'black'))
    #ax[1].text('2021-02-02 16:50:17',80,'RS',fontdict=font)
    ax[1].axhline(y=25.,linestyle='dashed',color="darkslategrey")
    ax[1].axhline(y=-25.,linestyle='dashed',color="darkslategrey")
    fig.subplots_adjust(hspace=0)
    ax[0].tick_params(axis='both', which='both', labelsize=17)
    ax[1].tick_params(axis='both', which='both', labelsize=17)
    ax[1].axhline(y=0.,linestyle='dashed',color="darkslategrey")
    plt.tick_params(axis='y', labelsize=17)
    
#Plotting 2 for up to 3 setups"""

def plot_fk3(x,b,c,z,t1):
    dfF = x
    dfF['t_elapsed'] = (pd.to_datetime(dfF['timestamp'],format='%Y-%m-%d %H:%M:%S')-datetime.strptime(t1,'%Y-%m-%d %H:%M:%S')).astype("timedelta64[s]")/3600
    dfF.index = dfF['t_elapsed']
    
    fig, ax = plt.subplots()
    fig.subplots_adjust(right=0.75)

    twin1 = ax.twinx()
    p1, = ax.plot(dfF['Flow'+str(z)],"b-", label="Flow (in $\mu$L/min)")
    p2, = twin1.plot(dfF['permeability'+str(z)],'tab:orange', label="k (in $m^2$)")
    ax.set_ylim(0., c)
    twin1.set_ylim(0., b)

    ax.set_xlabel("Time elapsed (h)", font)
    ax.set_ylabel("Flow ($\mu L$ $min^{-1}$)",font)
    twin1.set_ylabel("k ($m^2$)",font)

    tkw = dict(size=4, width=1.5)

    ax.yaxis.label.set_color(p1.get_color())
    twin1.yaxis.label.set_color(p2.get_color())

    ax.tick_params(axis='y')
    twin1.tick_params(axis='y')
    ax.tick_params(axis='x')

    ax.legend(handles=[p1, p2])


#Plot k for single setup
    
def plot_k(x,y,z):
    dfk = x
    dfk['t_elapsed'] = (pd.to_datetime(dfk['timestamp'],format='%Y-%m-%d %H:%M:%S')-datetime.strptime(y,'%Y-%m-%d %H:%M:%S')).astype("timedelta64[s]")/3600
    color = 'tab:orange'
    plt.ylabel('Permeability ($m^{2}$)',fontdict=font)# we already handled the x-label with ax1
    plt.plot(dfk['t_elapsed'] , dfk['permeability'],color=color, lw=3)
    plt.tick_params(axis='y',labelsize = 17)
    plt.tick_params(axis='x', length=7, labelsize = 17)
    plt.ylim(0.,z)
    plt.xlabel('Time elapsed (hours)',fontdict=font)
    

    plt.tight_layout()  # otherwise the right y-label is slightly clipped

    
def plot_k3(x,y,z,i):
    dfk = x
    dfk['t_elapsed'] = (pd.to_datetime(dfk['timestamp'],format='%Y-%m-%d %H:%M:%S')-datetime.strptime(y,'%Y-%m-%d %H:%M:%S')).astype("timedelta64[s]")/3600
    color = 'tab:orange'
    plt.ylabel('Permeability ($m^{2}$)',fontdict=font)# we already handled the x-label with ax1
    plt.plot(dfk['t_elapsed'] , dfk['permeability'+str(i)],color=color, lw=3)
    plt.tick_params(axis='y',labelsize = 17)
    plt.tick_params(axis='x', length=7, labelsize = 17)
    plt.ylim(0.,z)
    plt.xlabel('Time elapsed (hours)',fontdict=font)    

    plt.tight_layout()  # otherwise the right y-label is slightly clipped

    
#Plot just one line"""

def plot_F3(x,y,t1):
    dfF = x
    dfF['t_elapsed'] = (pd.to_datetime(dfF['timestamp'],format='%Y-%m-%d %H:%M:%S')-datetime.strptime(t1,'%Y-%m-%d %H:%M:%S')).astype("timedelta64[s]")/3600
    color = 'tab:orange'
    plt.plot(dfF['t_elapsed'], dfF[y], color='blue', lw=3)
    plt.tick_params(axis='y',labelsize = 17)
    plt.tick_params(axis='x', length=7, labelsize = 17)
    plt.xlabel('Time elapsed (hours)',fontdict=font)

    plt.tight_layout()  # otherwise the right y-label is slightly clipped

    #,'Flow2','Flow3' ,'brown','blue']