# -*- coding: utf-8 -*-
#
# This file is for use with essm.
# Copyright (C) 2022 ETH Zurich, Swiss Data Science Center.
#
# essm is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public License as
# published by the Free Software Foundation; either version 2 of the
# License, or (at your option) any later version.
#
# essm is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with essm; if not, write to the
# Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
# MA 02111-1307, USA.
"""Variables defined in notebooks/calibrations/P_sensor_calibration.ipynb and dependencies."""

from essm.variables import Variable


class m_bot(Variable):
    """slope value of top pressure sensor"""

    name = 'm_bot'
    unit = 1
    assumptions = {'real': True}
    latex_name = 'm_{b}'
    default = 1345529.785634362


class b_bot(Variable):
    """y-intercept value of top pressure sensor"""

    name = 'b_bot'
    unit = 1
    assumptions = {'real': True}
    latex_name = 'b_{b}'
    default = 99723.34036406862


class m_top(Variable):
    """slope value of top pressure sensor"""

    name = 'm_top'
    unit = 1
    assumptions = {'real': True}
    latex_name = 'm_{t}'
    default = 1326758.432195732


class b_top(Variable):
    """y-intercept value of top pressure sensor"""

    name = 'b_top'
    unit = 1
    assumptions = {'real': True}
    latex_name = 'b_{t}'
    default = 98240.22024058939


__all__ = (
    'm_bot',
    'b_bot',
    'm_top',
    'b_top',
)
