"""GOATOOLS GOEA on 2015 Gjoneska data using go-basic.obo: fmt(1.2) rel(2017-01-12) 47,943 GO Terms"""

# Created: 2017-01-13
import collections as cx

nt_fields = [
    "p_uncorrected",
    "study_count",
    "study_n",
    "namespace",
    "p_fdr_bh",
    "study_items",
    "NS",
    "pop_items",
    "pop_n",
    "p_sm_bonferroni",
    "is_obsolete",
    "GO",
    "name",
    "pop_count",
    "alt_ids",
    "level",
    "depth",
    "enrichment",
    "Cluster",
    "geneid_set",
    "symbols",
    "symbol_set",
    "geneids",
    "format_txt",
    "hdr_idx",
    "is_hdrgo",
    "is_usrgo",
    "hdr1usr01",
    "dcnt",
    "D1",
    "GO_name",
]

Nt = cx.namedtuple("Nt", " ".join(nt_fields))

# 147 items
nts = [
    Nt(p_uncorrected='', study_count='', study_n='', namespace='', p_fdr_bh='', study_items='', NS='BP', pop_items='', pop_n='', p_sm_bonferroni='', is_obsolete='', GO='GO:0019222', name='', pop_count='', alt_ids='', level=3, depth=3, enrichment='', Cluster='', geneid_set='', symbols='', symbol_set='', geneids='', format_txt=1, hdr_idx=1, is_hdrgo=True, is_usrgo=False, hdr1usr01='*', dcnt=3356, D1='A', GO_name='regulation of metabolic process'),
    Nt(p_uncorrected=1.3624160646516914e-07, study_count=10, study_n=624, namespace='biological_process', p_fdr_bh=2.7160481309918127e-05, study_items=set([u'ENSMUSG00000001517', u'ENSMUSG00000029521', u'ENSMUSG00000027715', u'ENSMUSG00000054115', u'ENSMUSG00000032113', u'ENSMUSG00000023067', u'ENSMUSG00000017716', u'ENSMUSG00000030867', u'ENSMUSG00000026779', u'ENSMUSG00000020525']), NS='BP', pop_items=set([u'ENSMUSG00000029516', u'ENSMUSG00000054115', u'ENSMUSG00000027425', u'ENSMUSG00000017716', u'ENSMUSG00000036438', u'ENSMUSG00000030752', u'ENSMUSG00000040584', u'ENSMUSG00000032113', u'ENSMUSG00000001175', u'ENSMUSG00000035390', u'ENSMUSG00000030867', u'ENSMUSG00000040021', u'ENSMUSG00000026779', u'ENSMUSG00000019370', u'ENSMUSG00000025226', u'ENSMUSG00000024286', u'ENSMUSG00000001517', u'ENSMUSG00000029521', u'ENSMUSG00000037343', u'ENSMUSG00000020525', u'ENSMUSG00000000296', u'ENSMUSG00000053046', u'ENSMUSG00000027715', u'ENSMUSG00000023067', u'ENSMUSG00000028926', u'ENSMUSG00000007656', u'ENSMUSG00000051177']), pop_n=13836, p_sm_bonferroni=0.0020641965795537777, is_obsolete=False, GO='GO:0000086', name='G2/M transition of mitotic cell cycle', pop_count=27, alt_ids=[], level=5, depth=5, enrichment='e', Cluster='Transient Increase', geneid_set=set([u'ENSMUSG00000001517', u'ENSMUSG00000029521', u'ENSMUSG00000027715', u'ENSMUSG00000023067', u'ENSMUSG00000032113', u'ENSMUSG00000054115', u'ENSMUSG00000017716', u'ENSMUSG00000030867', u'ENSMUSG00000026779', u'ENSMUSG00000020525']), symbols=u'Birc5 Ccna2 Cdkn1a Chek1 Chek2 Foxm1 Mastl Plk1 Ppm1d Skp2', symbol_set=set([u'Ppm1d', u'Ccna2', u'Plk1', u'Cdkn1a', u'Mastl', u'Foxm1', u'Skp2', u'Chek2', u'Birc5', u'Chek1']), geneids='ENSMUSG00000001517 ENSMUSG00000029521 ENSMUSG00000054115 ENSMUSG00000027715 ENSMUSG00000017716 ENSMUSG00000032113 ENSMUSG00000023067 ENSMUSG00000030867 ENSMUSG00000026779 ENSMUSG00000020525', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=0, D1='B', GO_name='G2/M transition of mitotic cell cycle'),
    Nt(p_uncorrected=3.5260394490306786e-07, study_count=13, study_n=624, namespace='biological_process', p_fdr_bh=6.211979499100444e-05, study_items=set([u'ENSMUSG00000028896', u'ENSMUSG00000028212', u'ENSMUSG00000032477', u'ENSMUSG00000041238', u'ENSMUSG00000023067', u'ENSMUSG00000028068', u'ENSMUSG00000054115', u'ENSMUSG00000002068', u'ENSMUSG00000025358', u'ENSMUSG00000028551', u'ENSMUSG00000050410', u'ENSMUSG00000033364', u'ENSMUSG00000007080']), NS='BP', pop_items=set([u'ENSMUSG00000079259', u'ENSMUSG00000028333', u'ENSMUSG00000053819', u'ENSMUSG00000028068', u'ENSMUSG00000028680', u'ENSMUSG00000020516', u'ENSMUSG00000032119', u'ENSMUSG00000050410', u'ENSMUSG00000024617', u'ENSMUSG00000057897', u'ENSMUSG00000003031', u'ENSMUSG00000005732', u'ENSMUSG00000040957', u'ENSMUSG00000033364', u'ENSMUSG00000007080', u'ENSMUSG00000028156', u'ENSMUSG00000041238', u'ENSMUSG00000021379', u'ENSMUSG00000000532', u'ENSMUSG00000032405', u'ENSMUSG00000033016', u'ENSMUSG00000040021', u'ENSMUSG00000070348', u'ENSMUSG00000021820', u'ENSMUSG00000039960', u'ENSMUSG00000022018', u'ENSMUSG00000040274', u'ENSMUSG00000028212', u'ENSMUSG00000054115', u'ENSMUSG00000021701', u'ENSMUSG00000025809', u'ENSMUSG00000026836', u'ENSMUSG00000002068', u'ENSMUSG00000027552', u'ENSMUSG00000033417', u'ENSMUSG00000031155', u'ENSMUSG00000017561', u'ENSMUSG00000022105', u'ENSMUSG00000000184', u'ENSMUSG00000021959', u'ENSMUSG00000028896', u'ENSMUSG00000041229', u'ENSMUSG00000032477', u'ENSMUSG00000023067', u'ENSMUSG00000028161', u'ENSMUSG00000021103', u'ENSMUSG00000028551', u'ENSMUSG00000025358', u'ENSMUSG00000006728', u'ENSMUSG00000028495', u'ENSMUSG00000043866', u'ENSMUSG00000031490']), pop_n=13836, p_sm_bonferroni=0.005342302369226381, is_obsolete=False, GO='GO:0000082', name='G1/S transition of mitotic cell cycle', pop_count=52, alt_ids=[], level=5, depth=5, enrichment='e', Cluster='Transient Increase', geneid_set=set([u'ENSMUSG00000028896', u'ENSMUSG00000028212', u'ENSMUSG00000028551', u'ENSMUSG00000032477', u'ENSMUSG00000041238', u'ENSMUSG00000054115', u'ENSMUSG00000028068', u'ENSMUSG00000023067', u'ENSMUSG00000002068', u'ENSMUSG00000025358', u'ENSMUSG00000050410', u'ENSMUSG00000033364', u'ENSMUSG00000007080']), symbols=u'Ccne1 Ccne2 Cdc25a Cdk2 Cdkn1a Cdkn2c Iqgap3 Pole Rbbp8 Rcc1 Skp2 Tcf19 Usp37', symbol_set=set([u'Rcc1', u'Rbbp8', u'Skp2', u'Cdkn2c', u'Ccne2', u'Cdc25a', u'Ccne1', u'Pole', u'Cdk2', u'Usp37', u'Tcf19', u'Cdkn1a', u'Iqgap3']), geneids='ENSMUSG00000028896 ENSMUSG00000028212 ENSMUSG00000028551 ENSMUSG00000032477 ENSMUSG00000041238 ENSMUSG00000054115 ENSMUSG00000028068 ENSMUSG00000023067 ENSMUSG00000002068 ENSMUSG00000025358 ENSMUSG00000050410 ENSMUSG00000033364 ENSMUSG00000007080', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=0, D1='B', GO_name='G1/S transition of mitotic cell cycle'),
    Nt(p_uncorrected=2.512388532377029e-11, study_count=24, study_n=624, namespace='biological_process', p_fdr_bh=3.774646010782965e-08, study_items=set([u'ENSMUSG00000032661', u'ENSMUSG00000046718', u'ENSMUSG00000036986', u'ENSMUSG00000074896', u'ENSMUSG00000041827', u'ENSMUSG00000023341', u'ENSMUSG00000039236', u'ENSMUSG00000018899', u'ENSMUSG00000027514', u'ENSMUSG00000024079', u'ENSMUSG00000029561', u'ENSMUSG00000017830', u'ENSMUSG00000034855', u'ENSMUSG00000029605', u'ENSMUSG00000026896', u'ENSMUSG00000035692', u'ENSMUSG00000034459', u'ENSMUSG00000032344', u'ENSMUSG00000040296', u'ENSMUSG00000020641', u'ENSMUSG00000040033', u'ENSMUSG00000045932', u'ENSMUSG00000020108', u'ENSMUSG00000000386']), NS='BP', pop_items=set([u'ENSMUSG00000029826', u'ENSMUSG00000045322', u'ENSMUSG00000070583', u'ENSMUSG00000024079', u'ENSMUSG00000009585', u'ENSMUSG00000020455', u'ENSMUSG00000024978', u'ENSMUSG00000021494', u'ENSMUSG00000022476', u'ENSMUSG00000066568', u'ENSMUSG00000061298', u'ENSMUSG00000017707', u'ENSMUSG00000037523', u'ENSMUSG00000038628', u'ENSMUSG00000020115', u'ENSMUSG00000000776', u'ENSMUSG00000026395', u'ENSMUSG00000056144', u'ENSMUSG00000039236', u'ENSMUSG00000066800', u'ENSMUSG00000029605', u'ENSMUSG00000026896', u'ENSMUSG00000061286', u'ENSMUSG00000078566', u'ENSMUSG00000003234', u'ENSMUSG00000045932', u'ENSMUSG00000020108', u'ENSMUSG00000000275', u'ENSMUSG00000027951', u'ENSMUSG00000036986', u'ENSMUSG00000056851', u'ENSMUSG00000041415', u'ENSMUSG00000035834', u'ENSMUSG00000003184', u'ENSMUSG00000047123', u'ENSMUSG00000036908', u'ENSMUSG00000057948', u'ENSMUSG00000021703', u'ENSMUSG00000022901', u'ENSMUSG00000030789', u'ENSMUSG00000044583', u'ENSMUSG00000034855', u'ENSMUSG00000024349', u'ENSMUSG00000032369', u'ENSMUSG00000035692', u'ENSMUSG00000034459', u'ENSMUSG00000034453', u'ENSMUSG00000022865', u'ENSMUSG00000020641', u'ENSMUSG00000040033', u'ENSMUSG00000025532', u'ENSMUSG00000000386', u'ENSMUSG00000079339', u'ENSMUSG00000032661', u'ENSMUSG00000029417', u'ENSMUSG00000030314', u'ENSMUSG00000027427', u'ENSMUSG00000026928', u'ENSMUSG00000046718', u'ENSMUSG00000030793', u'ENSMUSG00000074896', u'ENSMUSG00000031639', u'ENSMUSG00000062488', u'ENSMUSG00000028099', u'ENSMUSG00000022971', u'ENSMUSG00000032178', u'ENSMUSG00000030880', u'ENSMUSG00000035086', u'ENSMUSG00000027514', u'ENSMUSG00000033450', u'ENSMUSG00000030247', u'ENSMUSG00000029561', u'ENSMUSG00000029165', u'ENSMUSG00000020783', u'ENSMUSG00000030249', u'ENSMUSG00000025492', u'ENSMUSG00000027598', u'ENSMUSG00000032344', u'ENSMUSG00000057329', u'ENSMUSG00000027639', u'ENSMUSG00000040296', u'ENSMUSG00000032690', u'ENSMUSG00000032691', u'ENSMUSG00000022965', u'ENSMUSG00000022967', u'ENSMUSG00000019726', u'ENSMUSG00000022969', u'ENSMUSG00000037921', u'ENSMUSG00000029771', u'ENSMUSG00000020009', u'ENSMUSG00000040264', u'ENSMUSG00000043279', u'ENSMUSG00000024810', u'ENSMUSG00000041827', u'ENSMUSG00000022051', u'ENSMUSG00000017830', u'ENSMUSG00000023341', u'ENSMUSG00000040613', u'ENSMUSG00000018899', u'ENSMUSG00000060591', u'ENSMUSG00000010047', u'ENSMUSG00000005102', u'ENSMUSG00000034259', u'ENSMUSG00000038884']), pop_n=13836, p_sm_bonferroni=3.806519865404436e-07, is_obsolete=False, GO='GO:0051607', name='defense response to virus', pop_count=104, alt_ids=[], level=3, depth=6, enrichment='e', Cluster='Transient Increase', geneid_set=set([u'ENSMUSG00000032661', u'ENSMUSG00000039236', u'ENSMUSG00000018899', u'ENSMUSG00000027514', u'ENSMUSG00000024079', u'ENSMUSG00000046718', u'ENSMUSG00000036986', u'ENSMUSG00000029561', u'ENSMUSG00000017830', u'ENSMUSG00000074896', u'ENSMUSG00000034855', u'ENSMUSG00000029605', u'ENSMUSG00000026896', u'ENSMUSG00000041827', u'ENSMUSG00000035692', u'ENSMUSG00000034459', u'ENSMUSG00000032344', u'ENSMUSG00000023341', u'ENSMUSG00000040296', u'ENSMUSG00000020641', u'ENSMUSG00000040033', u'ENSMUSG00000045932', u'ENSMUSG00000020108', u'ENSMUSG00000000386']), symbols=u'Bst2 Cxcl10 Ddit4 Ddx58 Dhx58 Eif2ak2 Ifih1 Ifit1 Ifit2 Ifit3 Irf1 Isg15 Isg20 Mb21d1 Mx1 Mx2 Oas1b Oas3 Oasl1 Oasl2 Pml Rsad2 Stat2 Zbp1', symbol_set=set(['Mb21d1', u'Mx1', u'Irf1', u'Zbp1', u'Eif2ak2', u'Oas3', u'Isg20', u'Stat2', u'Oasl2', u'Ifih1', u'Oasl1', u'Ddx58', u'Ddit4', u'Dhx58', u'Mx2', u'Rsad2', u'Isg15', u'Bst2', u'Pml', u'Cxcl10', u'Oas1b', u'Ifit3', u'Ifit2', u'Ifit1']), geneids='ENSMUSG00000032661 ENSMUSG00000023341 ENSMUSG00000024079 ENSMUSG00000036986 ENSMUSG00000074896 ENSMUSG00000041827 ENSMUSG00000017830 ENSMUSG00000039236 ENSMUSG00000018899 ENSMUSG00000027514 ENSMUSG00000046718 ENSMUSG00000029561 ENSMUSG00000034855 ENSMUSG00000029605 ENSMUSG00000026896 ENSMUSG00000035692 ENSMUSG00000034459 ENSMUSG00000032344 ENSMUSG00000040296 ENSMUSG00000020641 ENSMUSG00000040033 ENSMUSG00000045932 ENSMUSG00000020108 ENSMUSG00000000386', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=3, D1='FL', GO_name='defense response to virus'),
    Nt(p_uncorrected=0.000352948400217597, study_count=3, study_n=624, namespace='biological_process', p_fdr_bh=0.025224156658947224, study_items=set([u'ENSMUSG00000026622', u'ENSMUSG00000032113', u'ENSMUSG00000012443']), NS='BP', pop_items=set([u'ENSMUSG00000026622', u'ENSMUSG00000012443', u'ENSMUSG00000037443', u'ENSMUSG00000032113']), pop_n=13836, p_sm_bonferroni=1.0, is_obsolete=False, GO='GO:0046602', name='regulation of mitotic centrosome separation', pop_count=4, alt_ids=[], level=7, depth=9, enrichment='e', Cluster='Transient Increase', geneid_set=set([u'ENSMUSG00000026622', u'ENSMUSG00000032113', u'ENSMUSG00000012443']), symbols=u'Chek1 Kif11 Nek2', symbol_set=set([u'Nek2', u'Kif11', u'Chek1']), geneids='ENSMUSG00000026622 ENSMUSG00000012443 ENSMUSG00000032113', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=2, D1='A', GO_name='regulation of mitotic centrosome separation'),
    Nt(p_uncorrected=0.00012860653072037162, study_count=4, study_n=624, namespace='biological_process', p_fdr_bh=0.010589769276871469, study_items=set([u'ENSMUSG00000019214', u'ENSMUSG00000033970', u'ENSMUSG00000029363', u'ENSMUSG00000022881']), NS='BP', pop_items=set([u'ENSMUSG00000023104', u'ENSMUSG00000057113', u'ENSMUSG00000019214', u'ENSMUSG00000022881', u'ENSMUSG00000046691', u'ENSMUSG00000033970', u'ENSMUSG00000029363']), pop_n=13836, p_sm_bonferroni=1.0, is_obsolete=False, GO='GO:1900264', name='positive regulation of DNA-directed DNA polymerase activity', pop_count=7, alt_ids=[], level=6, depth=10, enrichment='e', Cluster='Transient Increase', geneid_set=set([u'ENSMUSG00000019214', u'ENSMUSG00000033970', u'ENSMUSG00000029363', u'ENSMUSG00000022881']), symbols=u'Chtf18 Rfc3 Rfc4 Rfc5', symbol_set=set([u'Rfc5', u'Rfc4', u'Rfc3', u'Chtf18']), geneids='ENSMUSG00000019214 ENSMUSG00000033970 ENSMUSG00000029363 ENSMUSG00000022881', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=0, D1='A', GO_name='positive regulation of DNA-directed DNA polymerase activity'),
    Nt(p_uncorrected=1.2205757473020354e-08, study_count=15, study_n=624, namespace='biological_process', p_fdr_bh=3.3652195774610893e-06, study_items=set([u'ENSMUSG00000028224', u'ENSMUSG00000021569', u'ENSMUSG00000029521', u'ENSMUSG00000022906', u'ENSMUSG00000020380', u'ENSMUSG00000028702', u'ENSMUSG00000033762', u'ENSMUSG00000034206', u'ENSMUSG00000049502', u'ENSMUSG00000035958', u'ENSMUSG00000017146', u'ENSMUSG00000002748', u'ENSMUSG00000059552', u'ENSMUSG00000041147', u'ENSMUSG00000022034']), NS='BP', pop_items=set([u'ENSMUSG00000028224', u'ENSMUSG00000025932', u'ENSMUSG00000060657', u'ENSMUSG00000026496', u'ENSMUSG00000021569', u'ENSMUSG00000029003', u'ENSMUSG00000025878', u'ENSMUSG00000033762', u'ENSMUSG00000031201', u'ENSMUSG00000020697', u'ENSMUSG00000031583', u'ENSMUSG00000059552', u'ENSMUSG00000028411', u'ENSMUSG00000031715', u'ENSMUSG00000073436', u'ENSMUSG00000024926', u'ENSMUSG00000003549', u'ENSMUSG00000049717', u'ENSMUSG00000020380', u'ENSMUSG00000031820', u'ENSMUSG00000028886', u'ENSMUSG00000034206', u'ENSMUSG00000017146', u'ENSMUSG00000021144', u'ENSMUSG00000002748', u'ENSMUSG00000090083', u'ENSMUSG00000032705', u'ENSMUSG00000023249', u'ENSMUSG00000022034', u'ENSMUSG00000035234', u'ENSMUSG00000025612', u'ENSMUSG00000026648', u'ENSMUSG00000022906', u'ENSMUSG00000029521', u'ENSMUSG00000031928', u'ENSMUSG00000034154', u'ENSMUSG00000041147', u'ENSMUSG00000022672', u'ENSMUSG00000035958', u'ENSMUSG00000028452', u'ENSMUSG00000026187', u'ENSMUSG00000043535', u'ENSMUSG00000037032', u'ENSMUSG00000024151', u'ENSMUSG00000022471', u'ENSMUSG00000030051', u'ENSMUSG00000037761', u'ENSMUSG00000021177', u'ENSMUSG00000022314', u'ENSMUSG00000028702', u'ENSMUSG00000052139', u'ENSMUSG00000049502', u'ENSMUSG00000014074', u'ENSMUSG00000021615', u'ENSMUSG00000037149']), pop_n=13836, p_sm_bonferroni=0.00018492943147373138, is_obsolete=False, GO='GO:0006302', name='double-strand break repair', pop_count=55, alt_ids=[], level=6, depth=8, enrichment='e', Cluster='Transient Increase', geneid_set=set([u'ENSMUSG00000028224', u'ENSMUSG00000021569', u'ENSMUSG00000022034', u'ENSMUSG00000029521', u'ENSMUSG00000022906', u'ENSMUSG00000020380', u'ENSMUSG00000028702', u'ENSMUSG00000033762', u'ENSMUSG00000034206', u'ENSMUSG00000049502', u'ENSMUSG00000035958', u'ENSMUSG00000017146', u'ENSMUSG00000002748', u'ENSMUSG00000059552', u'ENSMUSG00000041147']), symbols=u'Baz1b Brca1 Brca2 Chek2 Dtx3l Esco2 Nbn Parp9 Polq Rad50 Rad54l Recql4 Tdp2 Trip13 Trp53', symbol_set=set([u'Dtx3l', u'Recql4', u'Brca2', u'Parp9', u'Polq', u'Trp53', u'Rad54l', u'Esco2', u'Brca1', u'Baz1b', u'Nbn', u'Rad50', u'Trip13', u'Chek2', u'Tdp2']), geneids='ENSMUSG00000028224 ENSMUSG00000021569 ENSMUSG00000029521 ENSMUSG00000022906 ENSMUSG00000020380 ENSMUSG00000028702 ENSMUSG00000033762 ENSMUSG00000034206 ENSMUSG00000049502 ENSMUSG00000035958 ENSMUSG00000017146 ENSMUSG00000002748 ENSMUSG00000059552 ENSMUSG00000041147 ENSMUSG00000022034', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=11, D1='BDF', GO_name='double-strand break repair'),
    Nt(p_uncorrected=8.726761340227559e-12, study_count=17, study_n=624, namespace='biological_process', p_fdr_bh=3.774646010782965e-08, study_items=set([u'ENSMUSG00000041827', u'ENSMUSG00000032661', u'ENSMUSG00000039236', u'ENSMUSG00000032508', u'ENSMUSG00000034459', u'ENSMUSG00000024079', u'ENSMUSG00000079017', u'ENSMUSG00000023341', u'ENSMUSG00000046718', u'ENSMUSG00000040296', u'ENSMUSG00000029561', u'ENSMUSG00000017830', u'ENSMUSG00000020641', u'ENSMUSG00000045932', u'ENSMUSG00000026896', u'ENSMUSG00000029605', u'ENSMUSG00000000386']), NS='BP', pop_items=set([u'ENSMUSG00000032661', u'ENSMUSG00000023341', u'ENSMUSG00000045322', u'ENSMUSG00000007659', u'ENSMUSG00000027951', u'ENSMUSG00000070583', u'ENSMUSG00000046718', u'ENSMUSG00000026469', u'ENSMUSG00000031639', u'ENSMUSG00000041827', u'ENSMUSG00000010051', u'ENSMUSG00000032508', u'ENSMUSG00000053175', u'ENSMUSG00000079017', u'ENSMUSG00000029826', u'ENSMUSG00000040725', u'ENSMUSG00000033777', u'ENSMUSG00000052776', u'ENSMUSG00000026896', u'ENSMUSG00000039236', u'ENSMUSG00000017830', u'ENSMUSG00000024079', u'ENSMUSG00000060591', u'ENSMUSG00000029561', u'ENSMUSG00000029605', u'ENSMUSG00000008683', u'ENSMUSG00000010047', u'ENSMUSG00000025492', u'ENSMUSG00000030421', u'ENSMUSG00000034459', u'ENSMUSG00000020075', u'ENSMUSG00000000787', u'ENSMUSG00000027770', u'ENSMUSG00000040296', u'ENSMUSG00000032690', u'ENSMUSG00000020641', u'ENSMUSG00000051451', u'ENSMUSG00000045932', u'ENSMUSG00000037921', u'ENSMUSG00000037149', u'ENSMUSG00000000386']), pop_n=13836, p_sm_bonferroni=1.3221916106578775e-07, is_obsolete=False, GO='GO:0009615', name='response to virus', pop_count=41, alt_ids=[], level=5, depth=5, enrichment='e', Cluster='Transient Increase', geneid_set=set([u'ENSMUSG00000032661', u'ENSMUSG00000039236', u'ENSMUSG00000017830', u'ENSMUSG00000046718', u'ENSMUSG00000024079', u'ENSMUSG00000029561', u'ENSMUSG00000029605', u'ENSMUSG00000026896', u'ENSMUSG00000041827', u'ENSMUSG00000032508', u'ENSMUSG00000034459', u'ENSMUSG00000079017', u'ENSMUSG00000023341', u'ENSMUSG00000040296', u'ENSMUSG00000020641', u'ENSMUSG00000045932', u'ENSMUSG00000000386']), symbols=u'Bst2 Ddx58 Dhx58 Eif2ak2 Ifi27l2a Ifih1 Ifit1 Ifit2 Isg20 Mx1 Mx2 Myd88 Oas1b Oas3 Oasl1 Oasl2 Rsad2', symbol_set=set([u'Ifit2', u'Ifih1', u'Myd88', u'Dhx58', u'Mx2', u'Mx1', u'Eif2ak2', u'Oasl2', u'Ddx58', u'Oasl1', u'Oas3', u'Bst2', u'Isg20', u'Ifi27l2a', u'Oas1b', u'Rsad2', u'Ifit1']), geneids='ENSMUSG00000041827 ENSMUSG00000032661 ENSMUSG00000039236 ENSMUSG00000032508 ENSMUSG00000017830 ENSMUSG00000046718 ENSMUSG00000079017 ENSMUSG00000023341 ENSMUSG00000024079 ENSMUSG00000040296 ENSMUSG00000034459 ENSMUSG00000029561 ENSMUSG00000020641 ENSMUSG00000045932 ENSMUSG00000000386 ENSMUSG00000029605 ENSMUSG00000026896', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=13, D1='F', GO_name='response to virus'),
    Nt(p_uncorrected='', study_count='', study_n='', namespace='', p_fdr_bh='', study_items='', NS='BP', pop_items='', pop_n='', p_sm_bonferroni='', is_obsolete='', GO='GO:0009617', name='', pop_count='', alt_ids='', level=5, depth=5, enrichment='', Cluster='', geneid_set='', symbols='', symbol_set='', geneids='', format_txt=1, hdr_idx=1, is_hdrgo=True, is_usrgo=False, hdr1usr01='*', dcnt=12, D1='F', GO_name='response to bacterium'),
    Nt(p_uncorrected=0.0002480312688115781, study_count=4, study_n=624, namespace='biological_process', p_fdr_bh=0.01888402891338804, study_items=set([u'ENSMUSG00000024056', u'ENSMUSG00000028678', u'ENSMUSG00000045328', u'ENSMUSG00000040599']), NS='BP', pop_items=set([u'ENSMUSG00000047710', u'ENSMUSG00000029554', u'ENSMUSG00000028678', u'ENSMUSG00000045328', u'ENSMUSG00000029253', u'ENSMUSG00000024056', u'ENSMUSG00000079614', u'ENSMUSG00000040599']), pop_n=13836, p_sm_bonferroni=1.0, is_obsolete=False, GO='GO:0051315', name='attachment of mitotic spindle microtubules to kinetochore', pop_count=8, alt_ids=['GO:0051314'], level=4, depth=4, enrichment='e', Cluster='Transient Increase', geneid_set=set([u'ENSMUSG00000024056', u'ENSMUSG00000028678', u'ENSMUSG00000045328', u'ENSMUSG00000040599']), symbols=u'Cenpe Kif2c Mis12 Ndc80', symbol_set=set([u'Mis12', u'Cenpe', u'Ndc80', u'Kif2c']), geneids='ENSMUSG00000024056 ENSMUSG00000028678 ENSMUSG00000045328 ENSMUSG00000040599', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=2, D1='B', GO_name='attachment of mitotic spindle microtubules to kinetochore'),
    Nt(p_uncorrected=2.327303960478811e-06, study_count=9, study_n=624, namespace='biological_process', p_fdr_bh=0.0003326507764642874, study_items=set([u'ENSMUSG00000069910', u'ENSMUSG00000041431', u'ENSMUSG00000028873', u'ENSMUSG00000028678', u'ENSMUSG00000045328', u'ENSMUSG00000041498', u'ENSMUSG00000068744', u'ENSMUSG00000027115', u'ENSMUSG00000030677']), NS='BP', pop_items=set([u'ENSMUSG00000033916', u'ENSMUSG00000045328', u'ENSMUSG00000025371', u'ENSMUSG00000028419', u'ENSMUSG00000038467', u'ENSMUSG00000009907', u'ENSMUSG00000030677', u'ENSMUSG00000024370', u'ENSMUSG00000041431', u'ENSMUSG00000028678', u'ENSMUSG00000004364', u'ENSMUSG00000041498', u'ENSMUSG00000032264', u'ENSMUSG00000001440', u'ENSMUSG00000027115', u'ENSMUSG00000035086', u'ENSMUSG00000069910', u'ENSMUSG00000068744', u'ENSMUSG00000004771', u'ENSMUSG00000021958', u'ENSMUSG00000061024', u'ENSMUSG00000022064', u'ENSMUSG00000028873', u'ENSMUSG00000034190', u'ENSMUSG00000031913', u'ENSMUSG00000004843', u'ENSMUSG00000000743', u'ENSMUSG00000079614']), pop_n=13836, p_sm_bonferroni=0.03526098230521446, is_obsolete=False, GO='GO:0007080', name='mitotic metaphase plate congression', pop_count=28, alt_ids=[], level=4, depth=7, enrichment='e', Cluster='Transient Increase', geneid_set=set([u'ENSMUSG00000069910', u'ENSMUSG00000041431', u'ENSMUSG00000028873', u'ENSMUSG00000028678', u'ENSMUSG00000045328', u'ENSMUSG00000041498', u'ENSMUSG00000068744', u'ENSMUSG00000027115', u'ENSMUSG00000030677']), symbols=u'Ccnb1 Cdca8 Cenpe Kif14 Kif18a Kif22 Kif2c Psrc1 Spdl1', symbol_set=set([u'Ccnb1', 'Spdl1', u'Cenpe', u'Kif18a', u'Psrc1', u'Kif22', u'Kif14', u'Cdca8', u'Kif2c']), geneids='ENSMUSG00000069910 ENSMUSG00000041431 ENSMUSG00000028873 ENSMUSG00000028678 ENSMUSG00000045328 ENSMUSG00000041498 ENSMUSG00000068744 ENSMUSG00000027115 ENSMUSG00000030677', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=0, D1='BG', GO_name='mitotic metaphase plate congression'),
    Nt(p_uncorrected=3.898358886864664e-11, study_count=54, study_n=624, namespace='biological_process', p_fdr_bh=3.774646010782965e-08, study_items=set([u'ENSMUSG00000002297', u'ENSMUSG00000046591', u'ENSMUSG00000030528', u'ENSMUSG00000022881', u'ENSMUSG00000029730', u'ENSMUSG00000033762', u'ENSMUSG00000024691', u'ENSMUSG00000019214', u'ENSMUSG00000024833', u'ENSMUSG00000002835', u'ENSMUSG00000035842', u'ENSMUSG00000038685', u'ENSMUSG00000041859', u'ENSMUSG00000029363', u'ENSMUSG00000007080', u'ENSMUSG00000030978', u'ENSMUSG00000028884', u'ENSMUSG00000042557', u'ENSMUSG00000026355', u'ENSMUSG00000031821', u'ENSMUSG00000030726', u'ENSMUSG00000002870', u'ENSMUSG00000056394', u'ENSMUSG00000034206', u'ENSMUSG00000028587', u'ENSMUSG00000017146', u'ENSMUSG00000027353', u'ENSMUSG00000040204', u'ENSMUSG00000027342', u'ENSMUSG00000033970', u'ENSMUSG00000024742', u'ENSMUSG00000038644', u'ENSMUSG00000028693', u'ENSMUSG00000026669', u'ENSMUSG00000022673', u'ENSMUSG00000031669', u'ENSMUSG00000000028', u'ENSMUSG00000021668', u'ENSMUSG00000023953', u'ENSMUSG00000031353', u'ENSMUSG00000017499', u'ENSMUSG00000027067', u'ENSMUSG00000037474', u'ENSMUSG00000005410', u'ENSMUSG00000045102', u'ENSMUSG00000026134', u'ENSMUSG00000031697', u'ENSMUSG00000022945', u'ENSMUSG00000036875', u'ENSMUSG00000006585', u'ENSMUSG00000020471', u'ENSMUSG00000025395', u'ENSMUSG00000020649', u'ENSMUSG00000027454']), NS='BP', pop_items=set([u'ENSMUSG00000046591', u'ENSMUSG00000029191', u'ENSMUSG00000021668', u'ENSMUSG00000020697', u'ENSMUSG00000031583', u'ENSMUSG00000001911', u'ENSMUSG00000046691', u'ENSMUSG00000038425', u'ENSMUSG00000046101', u'ENSMUSG00000058301', u'ENSMUSG00000007080', u'ENSMUSG00000031353', u'ENSMUSG00000027067', u'ENSMUSG00000020718', u'ENSMUSG00000028587', u'ENSMUSG00000006678', u'ENSMUSG00000017146', u'ENSMUSG00000020752', u'ENSMUSG00000019841', u'ENSMUSG00000033717', u'ENSMUSG00000030685', u'ENSMUSG00000033762', u'ENSMUSG00000025218', u'ENSMUSG00000035726', u'ENSMUSG00000036875', u'ENSMUSG00000002835', u'ENSMUSG00000048170', u'ENSMUSG00000029012', u'ENSMUSG00000037991', u'ENSMUSG00000029730', u'ENSMUSG00000024691', u'ENSMUSG00000019214', u'ENSMUSG00000045102', u'ENSMUSG00000035842', u'ENSMUSG00000038685', u'ENSMUSG00000002870', u'ENSMUSG00000025209', u'ENSMUSG00000030978', u'ENSMUSG00000028884', u'ENSMUSG00000052751', u'ENSMUSG00000033970', u'ENSMUSG00000027430', u'ENSMUSG00000057236', u'ENSMUSG00000008575', u'ENSMUSG00000029703', u'ENSMUSG00000026970', u'ENSMUSG00000037262', u'ENSMUSG00000024854', u'ENSMUSG00000055053', u'ENSMUSG00000040044', u'ENSMUSG00000037474', u'ENSMUSG00000030779', u'ENSMUSG00000026134', u'ENSMUSG00000026037', u'ENSMUSG00000006585', u'ENSMUSG00000020649', u'ENSMUSG00000026761', u'ENSMUSG00000002297', u'ENSMUSG00000032740', u'ENSMUSG00000024137', u'ENSMUSG00000024833', u'ENSMUSG00000030528', u'ENSMUSG00000029363', u'ENSMUSG00000070544', u'ENSMUSG00000026283', u'ENSMUSG00000000028', u'ENSMUSG00000042557', u'ENSMUSG00000049717', u'ENSMUSG00000038909', u'ENSMUSG00000026355', u'ENSMUSG00000031821', u'ENSMUSG00000034206', u'ENSMUSG00000020228', u'ENSMUSG00000040204', u'ENSMUSG00000024742', u'ENSMUSG00000039176', u'ENSMUSG00000022292', u'ENSMUSG00000035367', u'ENSMUSG00000000934', u'ENSMUSG00000017615', u'ENSMUSG00000026669', u'ENSMUSG00000022881', u'ENSMUSG00000028565', u'ENSMUSG00000023104', u'ENSMUSG00000031546', u'ENSMUSG00000005410', u'ENSMUSG00000029014', u'ENSMUSG00000027342', u'ENSMUSG00000021392', u'ENSMUSG00000025395', u'ENSMUSG00000027454', u'ENSMUSG00000030330', u'ENSMUSG00000039738', u'ENSMUSG00000021400', u'ENSMUSG00000020471', u'ENSMUSG00000041859', u'ENSMUSG00000063550', u'ENSMUSG00000031536', u'ENSMUSG00000030726', u'ENSMUSG00000056394', u'ENSMUSG00000027353', u'ENSMUSG00000000751', u'ENSMUSG00000038644', u'ENSMUSG00000011114', u'ENSMUSG00000068428', u'ENSMUSG00000021276', u'ENSMUSG00000028693', u'ENSMUSG00000022673', u'ENSMUSG00000031669', u'ENSMUSG00000023953', u'ENSMUSG00000017499', u'ENSMUSG00000029911', u'ENSMUSG00000012483', u'ENSMUSG00000031697', u'ENSMUSG00000022945']), pop_n=13836, p_sm_bonferroni=5.906403549488652e-07, is_obsolete=False, GO='GO:0006260', name='DNA replication', pop_count=115, alt_ids=['GO:0055133'], level=5, depth=7, enrichment='e', Cluster='Transient Increase', geneid_set=set([u'ENSMUSG00000002297', u'ENSMUSG00000046591', u'ENSMUSG00000031669', u'ENSMUSG00000029730', u'ENSMUSG00000033762', u'ENSMUSG00000024691', u'ENSMUSG00000019214', u'ENSMUSG00000024833', u'ENSMUSG00000002835', u'ENSMUSG00000035842', u'ENSMUSG00000030528', u'ENSMUSG00000041859', u'ENSMUSG00000038685', u'ENSMUSG00000007080', u'ENSMUSG00000030978', u'ENSMUSG00000028884', u'ENSMUSG00000042557', u'ENSMUSG00000026355', u'ENSMUSG00000031821', u'ENSMUSG00000030726', u'ENSMUSG00000029363', u'ENSMUSG00000056394', u'ENSMUSG00000034206', u'ENSMUSG00000028587', u'ENSMUSG00000017146', u'ENSMUSG00000027353', u'ENSMUSG00000040204', u'ENSMUSG00000031697', u'ENSMUSG00000033970', u'ENSMUSG00000024742', u'ENSMUSG00000038644', u'ENSMUSG00000028693', u'ENSMUSG00000026669', u'ENSMUSG00000022673', u'ENSMUSG00000022881', u'ENSMUSG00000000028', u'ENSMUSG00000021668', u'ENSMUSG00000023953', u'ENSMUSG00000031353', u'ENSMUSG00000017499', u'ENSMUSG00000027067', u'ENSMUSG00000037474', u'ENSMUSG00000005410', u'ENSMUSG00000045102', u'ENSMUSG00000026134', u'ENSMUSG00000002870', u'ENSMUSG00000027342', u'ENSMUSG00000027454', u'ENSMUSG00000036875', u'ENSMUSG00000006585', u'ENSMUSG00000020471', u'ENSMUSG00000025395', u'ENSMUSG00000020649', u'ENSMUSG00000022945']), symbols=u'Blm Brca1 Cdc45 Cdc6 Cdt1 Chaf1a Chaf1b Chtf18 Dbf4 Ddx11 Dna2 Dtl Fam111a Fen1 Gins1 Gins2 Gins3 Lig1 Mcm10 Mcm2 Mcm3 Mcm4 Mcm5 Mcm6 Mcm7 Mcm8 Nasp Orc1 Orc6 Pclaf Pcna Pola2 Pold1 Pold2 Pold3 Pole Polh Polk Poln Polq Prim1 Prim2 Rbbp7 Recql4 Rfc3 Rfc4 Rfc5 Rpa2 Rrm1 Rrm2 Rtel1 Sin3a Ssrp1 Ticrr', symbol_set=set([u'Mcm7', u'Mcm10', 'Ticrr', u'Recql4', u'Rfc5', u'Rfc4', u'Chaf1b', u'Rbbp7', u'Rfc3', u'Orc1', u'Blm', u'Mcm6', u'Mcm5', u'Pold3', u'Chaf1a', u'Mcm2', u'Prim2', u'Pold1', u'Cdc6', u'Sin3a', u'Brca1', u'Cdt1', u'Rpa2', u'Orc6', u'Lig1', u'Chtf18', 'Pclaf', u'Mcm8', u'Gins2', u'Gins3', u'Nasp', u'Gins1', u'Dtl', u'Fen1', u'Rrm2', u'Rrm1', u'Poln', u'Fam111a', u'Pcna', u'Pola2', u'Dna2', u'Polq', u'Ddx11', u'Ssrp1', u'Pold2', u'Pole', u'Mcm4', u'Dbf4', u'Cdc45', u'Mcm3', u'Rtel1', u'Polk', u'Prim1', u'Polh']), geneids='ENSMUSG00000002297 ENSMUSG00000046591 ENSMUSG00000038685 ENSMUSG00000056394 ENSMUSG00000031669 ENSMUSG00000029730 ENSMUSG00000021668 ENSMUSG00000024691 ENSMUSG00000019214 ENSMUSG00000024833 ENSMUSG00000002835 ENSMUSG00000035842 ENSMUSG00000030528 ENSMUSG00000041859 ENSMUSG00000002870 ENSMUSG00000007080 ENSMUSG00000030978 ENSMUSG00000000028 ENSMUSG00000031353 ENSMUSG00000026355 ENSMUSG00000031821 ENSMUSG00000030726 ENSMUSG00000029363 ENSMUSG00000027067 ENSMUSG00000034206 ENSMUSG00000028587 ENSMUSG00000017146 ENSMUSG00000027353 ENSMUSG00000040204 ENSMUSG00000031697 ENSMUSG00000033970 ENSMUSG00000024742 ENSMUSG00000038644 ENSMUSG00000028693 ENSMUSG00000026669 ENSMUSG00000022673 ENSMUSG00000022881 ENSMUSG00000028884 ENSMUSG00000033762 ENSMUSG00000023953 ENSMUSG00000042557 ENSMUSG00000017499 ENSMUSG00000037474 ENSMUSG00000005410 ENSMUSG00000045102 ENSMUSG00000026134 ENSMUSG00000027342 ENSMUSG00000027454 ENSMUSG00000036875 ENSMUSG00000006585 ENSMUSG00000020471 ENSMUSG00000025395 ENSMUSG00000020649 ENSMUSG00000022945', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=23, D1='BD', GO_name='DNA replication'),
    Nt(p_uncorrected=2.8613647443791696e-09, study_count=9, study_n=624, namespace='biological_process', p_fdr_bh=9.223944094061446e-07, study_items=set([u'ENSMUSG00000030726', u'ENSMUSG00000034206', u'ENSMUSG00000045102', u'ENSMUSG00000020471', u'ENSMUSG00000022881', u'ENSMUSG00000031697', u'ENSMUSG00000033970', u'ENSMUSG00000029363', u'ENSMUSG00000038644']), NS='BP', pop_items=set([u'ENSMUSG00000023104', u'ENSMUSG00000024854', u'ENSMUSG00000034206', u'ENSMUSG00000020228', u'ENSMUSG00000018449', u'ENSMUSG00000030726', u'ENSMUSG00000035021', u'ENSMUSG00000045102', u'ENSMUSG00000031697', u'ENSMUSG00000022881', u'ENSMUSG00000020471', u'ENSMUSG00000048170', u'ENSMUSG00000033970', u'ENSMUSG00000029363', u'ENSMUSG00000038644']), pop_n=13836, p_sm_bonferroni=4.3352537242088796e-05, is_obsolete=False, GO='GO:0006261', name='DNA-dependent DNA replication', pop_count=15, alt_ids=['GO:0006262', 'GO:0006263'], level=6, depth=8, enrichment='e', Cluster='Transient Increase', geneid_set=set([u'ENSMUSG00000030726', u'ENSMUSG00000034206', u'ENSMUSG00000045102', u'ENSMUSG00000020471', u'ENSMUSG00000022881', u'ENSMUSG00000031697', u'ENSMUSG00000033970', u'ENSMUSG00000029363', u'ENSMUSG00000038644']), symbols=u'Orc6 Pold1 Pold2 Pold3 Poln Polq Rfc3 Rfc4 Rfc5', symbol_set=set([u'Polq', u'Pold1', u'Orc6', u'Rfc4', u'Rfc3', u'Rfc5', u'Pold2', u'Pold3', u'Poln']), geneids='ENSMUSG00000030726 ENSMUSG00000034206 ENSMUSG00000045102 ENSMUSG00000031697 ENSMUSG00000022881 ENSMUSG00000020471 ENSMUSG00000033970 ENSMUSG00000029363 ENSMUSG00000038644', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=19, D1='BD', GO_name='DNA-dependent DNA replication'),
    Nt(p_uncorrected=4.462381350505715e-05, study_count=6, study_n=624, namespace='biological_process', p_fdr_bh=0.004599288424592659, study_items=set([u'ENSMUSG00000028896', u'ENSMUSG00000031004', u'ENSMUSG00000045328', u'ENSMUSG00000024795', u'ENSMUSG00000022070', u'ENSMUSG00000019773']), NS='BP', pop_items=set([u'ENSMUSG00000035198', u'ENSMUSG00000028896', u'ENSMUSG00000041117', u'ENSMUSG00000018965', u'ENSMUSG00000031004', u'ENSMUSG00000040327', u'ENSMUSG00000045328', u'ENSMUSG00000019773', u'ENSMUSG00000035576', u'ENSMUSG00000024795', u'ENSMUSG00000015095', u'ENSMUSG00000022070', u'ENSMUSG00000029062', u'ENSMUSG00000006699', u'ENSMUSG00000038545', u'ENSMUSG00000033900']), pop_n=13836, p_sm_bonferroni=0.6760953984151209, is_obsolete=False, GO='GO:0007088', name='regulation of mitotic nuclear division', pop_count=16, alt_ids=[], level=6, depth=7, enrichment='e', Cluster='Transient Increase', geneid_set=set([u'ENSMUSG00000028896', u'ENSMUSG00000022070', u'ENSMUSG00000031004', u'ENSMUSG00000024795', u'ENSMUSG00000045328', u'ENSMUSG00000019773']), symbols=u'Bora Cenpe Fbxo5 Kif20b Mki67 Rcc1', symbol_set=set([u'Rcc1', u'Mki67', u'Cenpe', u'Fbxo5', u'Kif20b', 'Bora']), geneids='ENSMUSG00000028896 ENSMUSG00000031004 ENSMUSG00000045328 ENSMUSG00000024795 ENSMUSG00000022070 ENSMUSG00000019773', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=63, D1='A', GO_name='regulation of mitotic nuclear division'),
    Nt(p_uncorrected=6.144408662089696e-07, study_count=6, study_n=624, namespace='biological_process', p_fdr_bh=0.00010118906047752281, study_items=set([u'ENSMUSG00000026355', u'ENSMUSG00000029730', u'ENSMUSG00000020914', u'ENSMUSG00000027323', u'ENSMUSG00000022673', u'ENSMUSG00000002870']), NS='BP', pop_items=set([u'ENSMUSG00000025209', u'ENSMUSG00000026355', u'ENSMUSG00000029730', u'ENSMUSG00000020914', u'ENSMUSG00000017485', u'ENSMUSG00000022673', u'ENSMUSG00000043991', u'ENSMUSG00000027323', u'ENSMUSG00000002870']), pop_n=13836, p_sm_bonferroni=0.009309393563932098, is_obsolete=False, GO='GO:0006268', name='DNA unwinding involved in DNA replication', pop_count=9, alt_ids=[], level=8, depth=8, enrichment='e', Cluster='Transient Increase', geneid_set=set([u'ENSMUSG00000002870', u'ENSMUSG00000022673', u'ENSMUSG00000026355', u'ENSMUSG00000029730', u'ENSMUSG00000020914', u'ENSMUSG00000027323']), symbols=u'Mcm2 Mcm4 Mcm6 Mcm7 Rad51 Top2a', symbol_set=set([u'Mcm7', u'Mcm6', u'Mcm4', u'Mcm2', u'Rad51', u'Top2a']), geneids='ENSMUSG00000026355 ENSMUSG00000029730 ENSMUSG00000020914 ENSMUSG00000027323 ENSMUSG00000022673 ENSMUSG00000002870', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=5, D1='BH', GO_name='DNA unwinding involved in DNA replication'),
    Nt(p_uncorrected=0.000352948400217597, study_count=3, study_n=624, namespace='biological_process', p_fdr_bh=0.025224156658947224, study_items=set([u'ENSMUSG00000035842', u'ENSMUSG00000005413', u'ENSMUSG00000039994']), NS='BP', pop_items=set([u'ENSMUSG00000035842', u'ENSMUSG00000005413', u'ENSMUSG00000066150', u'ENSMUSG00000039994']), pop_n=13836, p_sm_bonferroni=1.0, is_obsolete=False, GO='GO:0072719', name='cellular response to cisplatin', pop_count=4, alt_ids=[], level=4, depth=4, enrichment='e', Cluster='Transient Increase', geneid_set=set([u'ENSMUSG00000035842', u'ENSMUSG00000005413', u'ENSMUSG00000039994']), symbols=u'Ddx11 Hmox1 Timeless', symbol_set=set([u'Timeless', u'Hmox1', u'Ddx11']), geneids='ENSMUSG00000035842 ENSMUSG00000005413 ENSMUSG00000039994', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=0, D1='BF', GO_name='cellular response to cisplatin'),
    Nt(p_uncorrected=1.9760055974876353e-06, study_count=8, study_n=624, namespace='biological_process', p_fdr_bh=0.00028786981545706885, study_items=set([u'ENSMUSG00000028718', u'ENSMUSG00000027959', u'ENSMUSG00000025474', u'ENSMUSG00000041147', u'ENSMUSG00000000759', u'ENSMUSG00000068394', u'ENSMUSG00000017146', u'ENSMUSG00000024542']), NS='BP', pop_items=set([u'ENSMUSG00000028718', u'ENSMUSG00000033904', u'ENSMUSG00000027959', u'ENSMUSG00000064128', u'ENSMUSG00000027263', u'ENSMUSG00000051786', u'ENSMUSG00000033790', u'ENSMUSG00000025474', u'ENSMUSG00000024542', u'ENSMUSG00000025437', u'ENSMUSG00000000759', u'ENSMUSG00000024790', u'ENSMUSG00000017146', u'ENSMUSG00000040549', u'ENSMUSG00000035390', u'ENSMUSG00000068394', u'ENSMUSG00000041147', u'ENSMUSG00000022678', u'ENSMUSG00000071176', u'ENSMUSG00000020580', u'ENSMUSG00000032534']), pop_n=13836, p_sm_bonferroni=0.02993846080753516, is_obsolete=False, GO='GO:0051298', name='centrosome duplication', pop_count=21, alt_ids=[], level=3, depth=6, enrichment='e', Cluster='Transient Increase', geneid_set=set([u'ENSMUSG00000028718', u'ENSMUSG00000027959', u'ENSMUSG00000025474', u'ENSMUSG00000041147', u'ENSMUSG00000000759', u'ENSMUSG00000068394', u'ENSMUSG00000017146', u'ENSMUSG00000024542']), symbols=u'Brca1 Brca2 Cep152 Cep192 Sass6 Stil Tubgcp2 Tubgcp3', symbol_set=set([u'Brca1', u'Cep152', u'Brca2', u'Stil', u'Cep192', u'Sass6', u'Tubgcp2', u'Tubgcp3']), geneids='ENSMUSG00000028718 ENSMUSG00000027959 ENSMUSG00000025474 ENSMUSG00000024542 ENSMUSG00000000759 ENSMUSG00000068394 ENSMUSG00000017146 ENSMUSG00000041147', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=0, D1='BH', GO_name='centrosome duplication'),
    Nt(p_uncorrected=5.377740471406626e-11, study_count=72, study_n=624, namespace='biological_process', p_fdr_bh=3.774646010782965e-08, study_items=set([u'ENSMUSG00000028224', u'ENSMUSG00000032815', u'ENSMUSG00000020380', u'ENSMUSG00000038685', u'ENSMUSG00000039748', u'ENSMUSG00000034023', u'ENSMUSG00000021668', u'ENSMUSG00000024974', u'ENSMUSG00000045102', u'ENSMUSG00000025358', u'ENSMUSG00000002835', u'ENSMUSG00000035842', u'ENSMUSG00000030528', u'ENSMUSG00000049932', u'ENSMUSG00000056394', u'ENSMUSG00000044702', u'ENSMUSG00000036086', u'ENSMUSG00000028560', u'ENSMUSG00000028884', u'ENSMUSG00000041238', u'ENSMUSG00000032113', u'ENSMUSG00000019942', u'ENSMUSG00000039187', u'ENSMUSG00000030726', u'ENSMUSG00000030677', u'ENSMUSG00000027067', u'ENSMUSG00000034206', u'ENSMUSG00000035958', u'ENSMUSG00000017146', u'ENSMUSG00000027353', u'ENSMUSG00000028702', u'ENSMUSG00000040204', u'ENSMUSG00000034329', u'ENSMUSG00000061607', u'ENSMUSG00000007080', u'ENSMUSG00000024742', u'ENSMUSG00000032409', u'ENSMUSG00000038644', u'ENSMUSG00000022906', u'ENSMUSG00000001517', u'ENSMUSG00000029521', u'ENSMUSG00000035365', u'ENSMUSG00000051768', u'ENSMUSG00000030346', u'ENSMUSG00000027433', u'ENSMUSG00000041147', u'ENSMUSG00000073705', u'ENSMUSG00000005566', u'ENSMUSG00000030254', u'ENSMUSG00000045751', u'ENSMUSG00000031311', u'ENSMUSG00000023953', u'ENSMUSG00000009628', u'ENSMUSG00000051235', u'ENSMUSG00000046591', u'ENSMUSG00000001228', u'ENSMUSG00000032555', u'ENSMUSG00000036097', u'ENSMUSG00000041133', u'ENSMUSG00000026196', u'ENSMUSG00000027323', u'ENSMUSG00000002221', u'ENSMUSG00000049502', u'ENSMUSG00000005370', u'ENSMUSG00000027342', u'ENSMUSG00000042489', u'ENSMUSG00000020608', u'ENSMUSG00000036875', u'ENSMUSG00000034218', u'ENSMUSG00000020471', u'ENSMUSG00000022945', u'ENSMUSG00000038774']), NS='BP', pop_items=set([u'ENSMUSG00000028224', u'ENSMUSG00000047617', u'ENSMUSG00000026496', u'ENSMUSG00000047757', u'ENSMUSG00000000902', u'ENSMUSG00000029191', u'ENSMUSG00000021668', u'ENSMUSG00000024974', u'ENSMUSG00000022400', u'ENSMUSG00000025358', u'ENSMUSG00000031583', u'ENSMUSG00000030726', u'ENSMUSG00000039615', u'ENSMUSG00000074781', u'ENSMUSG00000029591', u'ENSMUSG00000030750', u'ENSMUSG00000038425', u'ENSMUSG00000058301', u'ENSMUSG00000007080', u'ENSMUSG00000027845', u'ENSMUSG00000028560', u'ENSMUSG00000018841', u'ENSMUSG00000022471', u'ENSMUSG00000028933', u'ENSMUSG00000020380', u'ENSMUSG00000025612', u'ENSMUSG00000027067', u'ENSMUSG00000019470', u'ENSMUSG00000030322', u'ENSMUSG00000017146', u'ENSMUSG00000020752', u'ENSMUSG00000045482', u'ENSMUSG00000022248', u'ENSMUSG00000019841', u'ENSMUSG00000007646', u'ENSMUSG00000021103', u'ENSMUSG00000025261', u'ENSMUSG00000032498', u'ENSMUSG00000039748', u'ENSMUSG00000021400', u'ENSMUSG00000030166', u'ENSMUSG00000029521', u'ENSMUSG00000021690', u'ENSMUSG00000018189', u'ENSMUSG00000003868', u'ENSMUSG00000021694', u'ENSMUSG00000041147', u'ENSMUSG00000005566', u'ENSMUSG00000062270', u'ENSMUSG00000009628', u'ENSMUSG00000028629', u'ENSMUSG00000025218', u'ENSMUSG00000024151', u'ENSMUSG00000032555', u'ENSMUSG00000030051', u'ENSMUSG00000061288', u'ENSMUSG00000022314', u'ENSMUSG00000020697', u'ENSMUSG00000010461', u'ENSMUSG00000047989', u'ENSMUSG00000032409', u'ENSMUSG00000036875', u'ENSMUSG00000019857', u'ENSMUSG00000026429', u'ENSMUSG00000025269', u'ENSMUSG00000059772', u'ENSMUSG00000025932', u'ENSMUSG00000017291', u'ENSMUSG00000003813', u'ENSMUSG00000021470', u'ENSMUSG00000028329', u'ENSMUSG00000025939', u'ENSMUSG00000021264', u'ENSMUSG00000034023', u'ENSMUSG00000069495', u'ENSMUSG00000034021', u'ENSMUSG00000030271', u'ENSMUSG00000018449', u'ENSMUSG00000041974', u'ENSMUSG00000035842', u'ENSMUSG00000022945', u'ENSMUSG00000028411', u'ENSMUSG00000059263', u'ENSMUSG00000030677', u'ENSMUSG00000038569', u'ENSMUSG00000078578', u'ENSMUSG00000073684', u'ENSMUSG00000028884', u'ENSMUSG00000020287', u'ENSMUSG00000028886', u'ENSMUSG00000034345', u'ENSMUSG00000001707', u'ENSMUSG00000022710', u'ENSMUSG00000043987', u'ENSMUSG00000014850', u'ENSMUSG00000003549', u'ENSMUSG00000024767', u'ENSMUSG00000036023', u'ENSMUSG00000006599', u'ENSMUSG00000036781', u'ENSMUSG00000021287', u'ENSMUSG00000029202', u'ENSMUSG00000035354', u'ENSMUSG00000022906', u'ENSMUSG00000027433', u'ENSMUSG00000021461', u'ENSMUSG00000031347', u'ENSMUSG00000049300', u'ENSMUSG00000014243', u'ENSMUSG00000021615', u'ENSMUSG00000009640', u'ENSMUSG00000069089', u'ENSMUSG00000024824', u'ENSMUSG00000002963', u'ENSMUSG00000025144', u'ENSMUSG00000024906', u'ENSMUSG00000031095', u'ENSMUSG00000039850', u'ENSMUSG00000043535', u'ENSMUSG00000020474', u'ENSMUSG00000051768', u'ENSMUSG00000022545', u'ENSMUSG00000024854', u'ENSMUSG00000037570', u'ENSMUSG00000021597', u'ENSMUSG00000036097', u'ENSMUSG00000029387', u'ENSMUSG00000024943', u'ENSMUSG00000034154', u'ENSMUSG00000027323', u'ENSMUSG00000021635', u'ENSMUSG00000022672', u'ENSMUSG00000042489', u'ENSMUSG00000034218', u'ENSMUSG00000028426', u'ENSMUSG00000038225', u'ENSMUSG00000021639', u'ENSMUSG00000038774', u'ENSMUSG00000030094', u'ENSMUSG00000031229', u'ENSMUSG00000020718', u'ENSMUSG00000031820', u'ENSMUSG00000055932', u'ENSMUSG00000027424', u'ENSMUSG00000026842', u'ENSMUSG00000027933', u'ENSMUSG00000020413', u'ENSMUSG00000045751', u'ENSMUSG00000026196', u'ENSMUSG00000025159', u'ENSMUSG00000020415', u'ENSMUSG00000046806', u'ENSMUSG00000032815', u'ENSMUSG00000030655', u'ENSMUSG00000030528', u'ENSMUSG00000038544', u'ENSMUSG00000030400', u'ENSMUSG00000073436', u'ENSMUSG00000036086', u'ENSMUSG00000031311', u'ENSMUSG00000041238', u'ENSMUSG00000034206', u'ENSMUSG00000031826', u'ENSMUSG00000039187', u'ENSMUSG00000066440', u'ENSMUSG00000032376', u'ENSMUSG00000032267', u'ENSMUSG00000079036', u'ENSMUSG00000091971', u'ENSMUSG00000024735', u'ENSMUSG00000028991', u'ENSMUSG00000030493', u'ENSMUSG00000014074', u'ENSMUSG00000020156', u'ENSMUSG00000054051', u'ENSMUSG00000041133', u'ENSMUSG00000025384', u'ENSMUSG00000004018', u'ENSMUSG00000001524', u'ENSMUSG00000024740', u'ENSMUSG00000026914', u'ENSMUSG00000022292', u'ENSMUSG00000061755', u'ENSMUSG00000033458', u'ENSMUSG00000033596', u'ENSMUSG00000028820', u'ENSMUSG00000035365', u'ENSMUSG00000057113', u'ENSMUSG00000039623', u'ENSMUSG00000059586', u'ENSMUSG00000002109', u'ENSMUSG00000037262', u'ENSMUSG00000035726', u'ENSMUSG00000040204', u'ENSMUSG00000009555', u'ENSMUSG00000049717', u'ENSMUSG00000030254', u'ENSMUSG00000034329', u'ENSMUSG00000020390', u'ENSMUSG00000030079', u'ENSMUSG00000026187', u'ENSMUSG00000051235', u'ENSMUSG00000033102', u'ENSMUSG00000046591', u'ENSMUSG00000055884', u'ENSMUSG00000037487', u'ENSMUSG00000058298', u'ENSMUSG00000031201', u'ENSMUSG00000037761', u'ENSMUSG00000028089', u'ENSMUSG00000031422', u'ENSMUSG00000028702', u'ENSMUSG00000024742', u'ENSMUSG00000002221', u'ENSMUSG00000032298', u'ENSMUSG00000027671', u'ENSMUSG00000006288', u'ENSMUSG00000026048', u'ENSMUSG00000026219', u'ENSMUSG00000043909', u'ENSMUSG00000002835', u'ENSMUSG00000092118', u'ENSMUSG00000090083', u'ENSMUSG00000025878', u'ENSMUSG00000039738', u'ENSMUSG00000055401', u'ENSMUSG00000020471', u'ENSMUSG00000044627', u'ENSMUSG00000068264', u'ENSMUSG00000035960', u'ENSMUSG00000030034', u'ENSMUSG00000040850', u'ENSMUSG00000031446', u'ENSMUSG00000038685', u'ENSMUSG00000044702', u'ENSMUSG00000031536', u'ENSMUSG00000031928', u'ENSMUSG00000049932', u'ENSMUSG00000020235', u'ENSMUSG00000036061', u'ENSMUSG00000032113', u'ENSMUSG00000019942', u'ENSMUSG00000029003', u'ENSMUSG00000070520', u'ENSMUSG00000056394', u'ENSMUSG00000040455', u'ENSMUSG00000034674', u'ENSMUSG00000005370', u'ENSMUSG00000026107', u'ENSMUSG00000058594', u'ENSMUSG00000027353', u'ENSMUSG00000024317', u'ENSMUSG00000027342', u'ENSMUSG00000061607', u'ENSMUSG00000000751', u'ENSMUSG00000035234', u'ENSMUSG00000038644', u'ENSMUSG00000026648', u'ENSMUSG00000032119', u'ENSMUSG00000027577', u'ENSMUSG00000023932', u'ENSMUSG00000001517', u'ENSMUSG00000029920', u'ENSMUSG00000030346', u'ENSMUSG00000021276', u'ENSMUSG00000090112', u'ENSMUSG00000024382', u'ENSMUSG00000026082', u'ENSMUSG00000073705', u'ENSMUSG00000030451', u'ENSMUSG00000035958', u'ENSMUSG00000025066', u'ENSMUSG00000015971', u'ENSMUSG00000040865', u'ENSMUSG00000033454', u'ENSMUSG00000023953', u'ENSMUSG00000031986', u'ENSMUSG00000030744', u'ENSMUSG00000037355', u'ENSMUSG00000025077', u'ENSMUSG00000001228', u'ENSMUSG00000030983', u'ENSMUSG00000028453', u'ENSMUSG00000028452', u'ENSMUSG00000040174', u'ENSMUSG00000061589', u'ENSMUSG00000025374', u'ENSMUSG00000036611', u'ENSMUSG00000035401', u'ENSMUSG00000012483', u'ENSMUSG00000052139', u'ENSMUSG00000049502', u'ENSMUSG00000051238', u'ENSMUSG00000016308', u'ENSMUSG00000020608', u'ENSMUSG00000045102', u'ENSMUSG00000042185', u'ENSMUSG00000021177', u'ENSMUSG00000079109', u'ENSMUSG00000006335']), pop_n=13836, p_sm_bonferroni=8.14781458822818e-07, is_obsolete=False, GO='GO:0006281', name='DNA repair', pop_count=300, alt_ids=[], level=5, depth=7, enrichment='e', Cluster='Transient Increase', geneid_set=set([u'ENSMUSG00000028224', u'ENSMUSG00000046591', u'ENSMUSG00000021668', u'ENSMUSG00000024974', u'ENSMUSG00000026196', u'ENSMUSG00000025358', u'ENSMUSG00000030254', u'ENSMUSG00000030528', u'ENSMUSG00000007080', u'ENSMUSG00000036086', u'ENSMUSG00000041238', u'ENSMUSG00000020380', u'ENSMUSG00000039187', u'ENSMUSG00000027067', u'ENSMUSG00000034206', u'ENSMUSG00000017146', u'ENSMUSG00000040204', u'ENSMUSG00000034329', u'ENSMUSG00000041133', u'ENSMUSG00000024742', u'ENSMUSG00000039748', u'ENSMUSG00000029521', u'ENSMUSG00000035365', u'ENSMUSG00000001228', u'ENSMUSG00000041147', u'ENSMUSG00000005566', u'ENSMUSG00000028560', u'ENSMUSG00000009628', u'ENSMUSG00000051235', u'ENSMUSG00000032555', u'ENSMUSG00000028702', u'ENSMUSG00000002221', u'ENSMUSG00000027342', u'ENSMUSG00000036875', u'ENSMUSG00000020471', u'ENSMUSG00000032815', u'ENSMUSG00000034023', u'ENSMUSG00000045102', u'ENSMUSG00000002835', u'ENSMUSG00000035842', u'ENSMUSG00000038685', u'ENSMUSG00000049932', u'ENSMUSG00000056394', u'ENSMUSG00000044702', u'ENSMUSG00000028884', u'ENSMUSG00000032113', u'ENSMUSG00000019942', u'ENSMUSG00000030726', u'ENSMUSG00000030677', u'ENSMUSG00000027353', u'ENSMUSG00000061607', u'ENSMUSG00000032409', u'ENSMUSG00000038644', u'ENSMUSG00000022906', u'ENSMUSG00000001517', u'ENSMUSG00000030346', u'ENSMUSG00000027433', u'ENSMUSG00000073705', u'ENSMUSG00000035958', u'ENSMUSG00000045751', u'ENSMUSG00000031311', u'ENSMUSG00000023953', u'ENSMUSG00000051768', u'ENSMUSG00000036097', u'ENSMUSG00000027323', u'ENSMUSG00000049502', u'ENSMUSG00000005370', u'ENSMUSG00000042489', u'ENSMUSG00000020608', u'ENSMUSG00000034218', u'ENSMUSG00000022945', u'ENSMUSG00000038774']), symbols=u'Apitd1 Ascc3 Atm Atr Bard1 Blm Brca1 Brca2 Brip1 Cdk1 Cdk2 Chaf1a Chaf1b Chek1 Chek2 Clspn Ddx11 Dna2 Dtx3l Exo1 Fam178a Fanca Fancd2 Fanci Fen1 Foxm1 Gen1 H2afx Kif22 Lig1 Mcm8 Mdc1 Mms22l Msh6 Nbn Nono Palb2 Parp9 Parpbp Paxip1 Pclaf Pcna Pold1 Pold2 Pold3 Pole Polh Polk Poln Polq Rad18 Rad50 Rad51 Rad51ap1 Rad54l Rbbp8 Rpa2 Rtel1 Smc1a Smc3 Smc6 Ssrp1 Tdp2 Tex15 Ticrr Topbp1 Trim28 Uhrf1 Usp1 Xrcc1 Xrn2 Zranb3', symbol_set=set([u'Rbbp8', 'Ticrr', 'Parpbp', u'Usp1', u'Palb2', u'Mdc1', u'H2afx', u'Msh6', u'Gen1', u'Blm', u'Pold1', u'Pold2', u'Pold3', u'Chaf1a', u'Dtx3l', u'Chaf1b', u'Ascc3', u'Kif22', u'Chek2', u'Tdp2', u'Chek1', u'Brca1', u'Brca2', u'Topbp1', u'Bard1', u'Smc3', u'Clspn', u'Cdk2', u'Rpa2', u'Rad54l', u'Foxm1', u'Lig1', u'Xrn2', u'Rad50', u'Xrcc1', u'Brip1', u'Mcm8', u'Mms22l', u'Pcna', u'Apitd1', u'Atm', u'Rad51', u'Zranb3', u'Tex15', u'Nono', u'Rad18', u'Smc6', u'Fen1', u'Rad51ap1', u'Fancd2', 'Pclaf', u'Paxip1', u'Fam178a', u'Smc1a', u'Atr', u'Dna2', u'Trim28', u'Parp9', u'Polq', u'Ddx11', u'Ssrp1', u'Exo1', u'Cdk1', u'Pole', u'Nbn', u'Fanca', u'Poln', u'Rtel1', u'Polk', u'Uhrf1', u'Fanci', u'Polh']), geneids='ENSMUSG00000028224 ENSMUSG00000032815 ENSMUSG00000019942 ENSMUSG00000038685 ENSMUSG00000039748 ENSMUSG00000045102 ENSMUSG00000034023 ENSMUSG00000021668 ENSMUSG00000024974 ENSMUSG00000026196 ENSMUSG00000025358 ENSMUSG00000002835 ENSMUSG00000035842 ENSMUSG00000030528 ENSMUSG00000049932 ENSMUSG00000030677 ENSMUSG00000007080 ENSMUSG00000036086 ENSMUSG00000031311 ENSMUSG00000028884 ENSMUSG00000041238 ENSMUSG00000032113 ENSMUSG00000020380 ENSMUSG00000039187 ENSMUSG00000030726 ENSMUSG00000056394 ENSMUSG00000027067 ENSMUSG00000034206 ENSMUSG00000035958 ENSMUSG00000017146 ENSMUSG00000027353 ENSMUSG00000040204 ENSMUSG00000034329 ENSMUSG00000041133 ENSMUSG00000044702 ENSMUSG00000024742 ENSMUSG00000032409 ENSMUSG00000038644 ENSMUSG00000022906 ENSMUSG00000001517 ENSMUSG00000029521 ENSMUSG00000035365 ENSMUSG00000051768 ENSMUSG00000030346 ENSMUSG00000027433 ENSMUSG00000041147 ENSMUSG00000073705 ENSMUSG00000005566 ENSMUSG00000030254 ENSMUSG00000045751 ENSMUSG00000028560 ENSMUSG00000023953 ENSMUSG00000009628 ENSMUSG00000051235 ENSMUSG00000061607 ENSMUSG00000046591 ENSMUSG00000001228 ENSMUSG00000032555 ENSMUSG00000036097 ENSMUSG00000028702 ENSMUSG00000027323 ENSMUSG00000002221 ENSMUSG00000049502 ENSMUSG00000005370 ENSMUSG00000027342 ENSMUSG00000042489 ENSMUSG00000020608 ENSMUSG00000036875 ENSMUSG00000034218 ENSMUSG00000020471 ENSMUSG00000022945 ENSMUSG00000038774', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=45, D1='BDF', GO_name='DNA repair'),
    Nt(p_uncorrected=0.0006920361223044611, study_count=4, study_n=624, namespace='biological_process', p_fdr_bh=0.0468082111117629, study_items=set([u'ENSMUSG00000034394', u'ENSMUSG00000020185', u'ENSMUSG00000046179', u'ENSMUSG00000025758']), NS='BP', pop_items=set([u'ENSMUSG00000034394', u'ENSMUSG00000030551', u'ENSMUSG00000020185', u'ENSMUSG00000035247', u'ENSMUSG00000053113', u'ENSMUSG00000022855', u'ENSMUSG00000027087', u'ENSMUSG00000046179', u'ENSMUSG00000040857', u'ENSMUSG00000025758']), pop_n=13836, p_sm_bonferroni=1.0, is_obsolete=False, GO='GO:0060707', name='trophoblast giant cell differentiation', pop_count=10, alt_ids=[], level=4, depth=6, enrichment='e', Cluster='Transient Increase', geneid_set=set([u'ENSMUSG00000034394', u'ENSMUSG00000020185', u'ENSMUSG00000046179', u'ENSMUSG00000025758']), symbols=u'E2f7 E2f8 Lif Plk4', symbol_set=set([u'E2f7', u'Lif', u'Plk4', u'E2f8']), geneids='ENSMUSG00000034394 ENSMUSG00000020185 ENSMUSG00000046179 ENSMUSG00000025758', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=0, D1='BCEK', GO_name='trophoblast giant cell differentiation'),
    Nt(p_uncorrected=0.0002480312688115781, study_count=4, study_n=624, namespace='biological_process', p_fdr_bh=0.01888402891338804, study_items=set([u'ENSMUSG00000035842', u'ENSMUSG00000039994', u'ENSMUSG00000030528', u'ENSMUSG00000027323']), NS='BP', pop_items=set([u'ENSMUSG00000000838', u'ENSMUSG00000029110', u'ENSMUSG00000031229', u'ENSMUSG00000039994', u'ENSMUSG00000027323', u'ENSMUSG00000035842', u'ENSMUSG00000041974', u'ENSMUSG00000030528']), pop_n=13836, p_sm_bonferroni=1.0, is_obsolete=False, GO='GO:0072711', name='cellular response to hydroxyurea', pop_count=8, alt_ids=[], level=5, depth=5, enrichment='e', Cluster='Transient Increase', geneid_set=set([u'ENSMUSG00000035842', u'ENSMUSG00000039994', u'ENSMUSG00000030528', u'ENSMUSG00000027323']), symbols=u'Blm Ddx11 Rad51 Timeless', symbol_set=set([u'Blm', u'Timeless', u'Rad51', u'Ddx11']), geneids='ENSMUSG00000035842 ENSMUSG00000039994 ENSMUSG00000030528 ENSMUSG00000027323', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=0, D1='BF', GO_name='cellular response to hydroxyurea'),
    Nt(p_uncorrected=1.4034325060506728e-08, study_count=12, study_n=624, namespace='biological_process', p_fdr_bh=3.797036767709597e-06, study_items=set([u'ENSMUSG00000030978', u'ENSMUSG00000067455', u'ENSMUSG00000069267', u'ENSMUSG00000069266', u'ENSMUSG00000069265', u'ENSMUSG00000069273', u'ENSMUSG00000069274', u'ENSMUSG00000061482', u'ENSMUSG00000074403', u'ENSMUSG00000060093', u'ENSMUSG00000064288', u'ENSMUSG00000020649']), NS='BP', pop_items=set([u'ENSMUSG00000067455', u'ENSMUSG00000063887', u'ENSMUSG00000017390', u'ENSMUSG00000060678', u'ENSMUSG00000060639', u'ENSMUSG00000074403', u'ENSMUSG00000041936', u'ENSMUSG00000005534', u'ENSMUSG00000030978', u'ENSMUSG00000022471', u'ENSMUSG00000026245', u'ENSMUSG00000069273', u'ENSMUSG00000069274', u'ENSMUSG00000091405', u'ENSMUSG00000027253', u'ENSMUSG00000069305', u'ENSMUSG00000069306', u'ENSMUSG00000060981', u'ENSMUSG00000031641', u'ENSMUSG00000003808', u'ENSMUSG00000024109', u'ENSMUSG00000038240', u'ENSMUSG00000063895', u'ENSMUSG00000034826', u'ENSMUSG00000032231', u'ENSMUSG00000026784', u'ENSMUSG00000041959', u'ENSMUSG00000069267', u'ENSMUSG00000069266', u'ENSMUSG00000069265', u'ENSMUSG00000061482', u'ENSMUSG00000060093', u'ENSMUSG00000064288', u'ENSMUSG00000020649']), pop_n=13836, p_sm_bonferroni=0.00021263405899173742, is_obsolete=False, GO='GO:0051290', name='protein heterotetramerization', pop_count=34, alt_ids=[], level=8, depth=8, enrichment='e', Cluster='Transient Increase', geneid_set=set([u'ENSMUSG00000030978', u'ENSMUSG00000067455', u'ENSMUSG00000069267', u'ENSMUSG00000069266', u'ENSMUSG00000069265', u'ENSMUSG00000069273', u'ENSMUSG00000069274', u'ENSMUSG00000061482', u'ENSMUSG00000074403', u'ENSMUSG00000060093', u'ENSMUSG00000064288', u'ENSMUSG00000020649']), symbols=u'Hist1h3a Hist1h3b Hist1h3e Hist1h4a Hist1h4b Hist1h4d Hist1h4f Hist1h4j Hist1h4k Hist2h3b Rrm1 Rrm2', symbol_set=set([u'Hist1h4b', u'Hist1h4a', u'Hist1h4f', u'Hist1h4d', u'Hist1h4k', u'Hist1h4j', u'Hist1h3b', u'Hist1h3a', u'Hist2h3b', u'Rrm1', u'Hist1h3e', u'Rrm2']), geneids='ENSMUSG00000030978 ENSMUSG00000067455 ENSMUSG00000069267 ENSMUSG00000069266 ENSMUSG00000069265 ENSMUSG00000069273 ENSMUSG00000069274 ENSMUSG00000061482 ENSMUSG00000074403 ENSMUSG00000060093 ENSMUSG00000064288 ENSMUSG00000020649', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=0, D1='BH', GO_name='protein heterotetramerization'),
    Nt(p_uncorrected=0.0004954910889564514, study_count=8, study_n=624, namespace='biological_process', p_fdr_bh=0.03427938579351231, study_items=set([u'ENSMUSG00000058385', u'ENSMUSG00000054717', u'ENSMUSG00000032508', u'ENSMUSG00000047246', u'ENSMUSG00000040253', u'ENSMUSG00000062727', u'ENSMUSG00000006445', u'ENSMUSG00000069268']), NS='BP', pop_items=set([u'ENSMUSG00000058385', u'ENSMUSG00000040264', u'ENSMUSG00000015950', u'ENSMUSG00000028874', u'ENSMUSG00000026928', u'ENSMUSG00000067212', u'ENSMUSG00000035279', u'ENSMUSG00000028362', u'ENSMUSG00000062727', u'ENSMUSG00000028268', u'ENSMUSG00000022191', u'ENSMUSG00000022575', u'ENSMUSG00000052593', u'ENSMUSG00000032508', u'ENSMUSG00000069516', u'ENSMUSG00000079641', u'ENSMUSG00000016024', u'ENSMUSG00000020115', u'ENSMUSG00000041135', u'ENSMUSG00000029298', u'ENSMUSG00000054717', u'ENSMUSG00000029468', u'ENSMUSG00000072115', u'ENSMUSG00000068854', u'ENSMUSG00000040253', u'ENSMUSG00000027695', u'ENSMUSG00000037071', u'ENSMUSG00000021194', u'ENSMUSG00000003283', u'ENSMUSG00000028270', u'ENSMUSG00000018102', u'ENSMUSG00000062210', u'ENSMUSG00000006445', u'ENSMUSG00000060802', u'ENSMUSG00000027995', u'ENSMUSG00000047246', u'ENSMUSG00000020399', u'ENSMUSG00000038058', u'ENSMUSG00000024300', u'ENSMUSG00000079614', u'ENSMUSG00000032041', u'ENSMUSG00000069268']), pop_n=13836, p_sm_bonferroni=1.0, is_obsolete=False, GO='GO:0050830', name='defense response to Gram-positive bacterium', pop_count=42, alt_ids=[], level=6, depth=7, enrichment='e', Cluster='Transient Increase', geneid_set=set([u'ENSMUSG00000058385', u'ENSMUSG00000054717', u'ENSMUSG00000032508', u'ENSMUSG00000047246', u'ENSMUSG00000040253', u'ENSMUSG00000062727', u'ENSMUSG00000006445', u'ENSMUSG00000069268']), symbols=u'Epha2 Gbp7 Hist1h2be Hist1h2bf Hist1h2bg Hist1h2bk Hmgb2 Myd88', symbol_set=set([u'Hmgb2', u'Gbp7', u'Epha2', u'Hist1h2be', u'Hist1h2bf', u'Hist1h2bg', u'Myd88', u'Hist1h2bk']), geneids='ENSMUSG00000058385 ENSMUSG00000054717 ENSMUSG00000032508 ENSMUSG00000047246 ENSMUSG00000040253 ENSMUSG00000062727 ENSMUSG00000006445 ENSMUSG00000069268', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=0, D1='F', GO_name='defense response to Gram-positive bacterium'),
    Nt(p_uncorrected=0.0002480312688115781, study_count=4, study_n=624, namespace='biological_process', p_fdr_bh=0.01888402891338804, study_items=set([u'ENSMUSG00000039356', u'ENSMUSG00000031527', u'ENSMUSG00000027752', u'ENSMUSG00000030929']), NS='BP', pop_items=set([u'ENSMUSG00000031527', u'ENSMUSG00000027752', u'ENSMUSG00000027714', u'ENSMUSG00000033423', u'ENSMUSG00000028322', u'ENSMUSG00000039356', u'ENSMUSG00000025785', u'ENSMUSG00000030929']), pop_n=13836, p_sm_bonferroni=1.0, is_obsolete=False, GO='GO:0000467', name="exonucleolytic trimming to generate mature 3'-end of 5.8S rRNA from tricistronic rRNA transcript (SSU-rRNA, 5.8S rRNA, LSU-rRNA)", pop_count=8, alt_ids=[], level=8, depth=11, enrichment='e', Cluster='Transient Increase', geneid_set=set([u'ENSMUSG00000039356', u'ENSMUSG00000031527', u'ENSMUSG00000027752', u'ENSMUSG00000030929']), symbols=u'Eri1 Eri2 Exosc2 Exosc8', symbol_set=set([u'Exosc2', u'Exosc8', u'Eri2', u'Eri1']), geneids='ENSMUSG00000039356 ENSMUSG00000031527 ENSMUSG00000027752 ENSMUSG00000030929', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=0, D1='BD', GO_name="exonucleolytic trimming to generate mature 3'-end of 5.8S rRNA from tricistronic rRNA transcript (SSU-rRNA, 5.8S rRNA, LSU-rRNA)"),
    Nt(p_uncorrected=1.0342107187712268e-07, study_count=7, study_n=624, namespace='biological_process', p_fdr_bh=2.176295361125397e-05, study_items=set([u'ENSMUSG00000028312', u'ENSMUSG00000038252', u'ENSMUSG00000034349', u'ENSMUSG00000027306', u'ENSMUSG00000034906', u'ENSMUSG00000035024', u'ENSMUSG00000015880']), NS='BP', pop_items=set([u'ENSMUSG00000047777', u'ENSMUSG00000028312', u'ENSMUSG00000002625', u'ENSMUSG00000038252', u'ENSMUSG00000034349', u'ENSMUSG00000027306', u'ENSMUSG00000024045', u'ENSMUSG00000034906', u'ENSMUSG00000035024', u'ENSMUSG00000015880', u'ENSMUSG00000000743']), pop_n=13836, p_sm_bonferroni=0.0015669326600102858, is_obsolete=False, GO='GO:0007076', name='mitotic chromosome condensation', pop_count=11, alt_ids=[], level=4, depth=8, enrichment='e', Cluster='Transient Increase', geneid_set=set([u'ENSMUSG00000034906', u'ENSMUSG00000035024', u'ENSMUSG00000028312', u'ENSMUSG00000015880', u'ENSMUSG00000038252', u'ENSMUSG00000034349', u'ENSMUSG00000027306']), symbols=u'Ncapd2 Ncapd3 Ncapg Ncaph Nusap1 Smc2 Smc4', symbol_set=set([u'Nusap1', u'Smc2', u'Smc4', u'Ncapd2', u'Ncapd3', u'Ncaph', u'Ncapg']), geneids='ENSMUSG00000028312 ENSMUSG00000038252 ENSMUSG00000034349 ENSMUSG00000027306 ENSMUSG00000034906 ENSMUSG00000035024 ENSMUSG00000015880', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=2, D1='BH', GO_name='mitotic chromosome condensation'),
    Nt(p_uncorrected=1.8374158794264207e-07, study_count=5, study_n=624, namespace='biological_process', p_fdr_bh=3.569062562716628e-05, study_items=set([u'ENSMUSG00000038252', u'ENSMUSG00000034349', u'ENSMUSG00000035024', u'ENSMUSG00000034906', u'ENSMUSG00000028312']), NS='BP', pop_items=set([u'ENSMUSG00000034906', u'ENSMUSG00000034349', u'ENSMUSG00000035024', u'ENSMUSG00000038252', u'ENSMUSG00000028312']), pop_n=13836, p_sm_bonferroni=0.00278386879891897, is_obsolete=False, GO='GO:0010032', name='meiotic chromosome condensation', pop_count=5, alt_ids=[], level=4, depth=8, enrichment='e', Cluster='Transient Increase', geneid_set=set([u'ENSMUSG00000038252', u'ENSMUSG00000034349', u'ENSMUSG00000035024', u'ENSMUSG00000034906', u'ENSMUSG00000028312']), symbols=u'Ncapd2 Ncapd3 Ncaph Smc2 Smc4', symbol_set=set([u'Smc2', u'Ncaph', u'Smc4', u'Ncapd2', u'Ncapd3']), geneids='ENSMUSG00000034906 ENSMUSG00000034349 ENSMUSG00000035024 ENSMUSG00000038252 ENSMUSG00000028312', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=0, D1='BHK', GO_name='meiotic chromosome condensation'),
    Nt(p_uncorrected=0.00013052614287701152, study_count=8, study_n=624, namespace='biological_process', p_fdr_bh=0.010689738328268117, study_items=set([u'ENSMUSG00000027699', u'ENSMUSG00000003779', u'ENSMUSG00000032254', u'ENSMUSG00000017716', u'ENSMUSG00000041147', u'ENSMUSG00000030867', u'ENSMUSG00000038943', u'ENSMUSG00000024660']), NS='BP', pop_items=set([u'ENSMUSG00000026491', u'ENSMUSG00000029516', u'ENSMUSG00000029518', u'ENSMUSG00000027937', u'ENSMUSG00000033628', u'ENSMUSG00000017716', u'ENSMUSG00000017639', u'ENSMUSG00000031729', u'ENSMUSG00000025035', u'ENSMUSG00000070923', u'ENSMUSG00000022443', u'ENSMUSG00000003779', u'ENSMUSG00000028447', u'ENSMUSG00000036580', u'ENSMUSG00000066440', u'ENSMUSG00000030867', u'ENSMUSG00000015932', u'ENSMUSG00000002233', u'ENSMUSG00000037098', u'ENSMUSG00000024660', u'ENSMUSG00000004771', u'ENSMUSG00000036782', u'ENSMUSG00000035086', u'ENSMUSG00000027699', u'ENSMUSG00000033900', u'ENSMUSG00000041147', u'ENSMUSG00000021375', u'ENSMUSG00000038943', u'ENSMUSG00000004451', u'ENSMUSG00000032254', u'ENSMUSG00000008859', u'ENSMUSG00000054364', u'ENSMUSG00000026276', u'ENSMUSG00000032322', u'ENSMUSG00000007659']), pop_n=13836, p_sm_bonferroni=1.0, is_obsolete=False, GO='GO:0000910', name='cytokinesis', pop_count=35, alt_ids=['GO:0007104', 'GO:0016288', 'GO:0033205'], level=3, depth=3, enrichment='e', Cluster='Transient Increase', geneid_set=set([u'ENSMUSG00000027699', u'ENSMUSG00000003779', u'ENSMUSG00000032254', u'ENSMUSG00000017716', u'ENSMUSG00000041147', u'ENSMUSG00000030867', u'ENSMUSG00000038943', u'ENSMUSG00000024660']), symbols=u'Birc5 Brca2 Ect2 Incenp Kif20a Kif23 Plk1 Prc1', symbol_set=set([u'Incenp', u'Brca2', u'Ect2', u'Plk1', u'Birc5', u'Kif23', u'Prc1', u'Kif20a']), geneids='ENSMUSG00000027699 ENSMUSG00000003779 ENSMUSG00000032254 ENSMUSG00000017716 ENSMUSG00000041147 ENSMUSG00000030867 ENSMUSG00000038943 ENSMUSG00000024660', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=10, D1='B', GO_name='cytokinesis'),
    Nt(p_uncorrected=9.131151172475021e-05, study_count=3, study_n=624, namespace='biological_process', p_fdr_bh=0.008090413532992342, study_items=set([u'ENSMUSG00000038685', u'ENSMUSG00000027342', u'ENSMUSG00000036875']), NS='BP', pop_items=set([u'ENSMUSG00000038685', u'ENSMUSG00000027342', u'ENSMUSG00000036875']), pop_n=13836, p_sm_bonferroni=1.0, is_obsolete=False, GO='GO:1902990', name='mitotic telomere maintenance via semi-conservative replication', pop_count=3, alt_ids=[], level=4, depth=9, enrichment='e', Cluster='Transient Increase', geneid_set=set([u'ENSMUSG00000038685', u'ENSMUSG00000027342', u'ENSMUSG00000036875']), symbols=u'Dna2 Pcna Rtel1', symbol_set=set([u'Pcna', u'Rtel1', u'Dna2']), geneids='ENSMUSG00000038685 ENSMUSG00000027342 ENSMUSG00000036875', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=0, D1='ABCDH', GO_name='mitotic telomere maintenance via semi-conservative replication'),
    Nt(p_uncorrected=9.548068345280445e-07, study_count=7, study_n=624, namespace='biological_process', p_fdr_bh=0.00015389657819079151, study_items=set([u'ENSMUSG00000008976', u'ENSMUSG00000067455', u'ENSMUSG00000069266', u'ENSMUSG00000069274', u'ENSMUSG00000061482', u'ENSMUSG00000060093', u'ENSMUSG00000064288']), NS='BP', pop_items=set([u'ENSMUSG00000008976', u'ENSMUSG00000067455', u'ENSMUSG00000060981', u'ENSMUSG00000060678', u'ENSMUSG00000060639', u'ENSMUSG00000069266', u'ENSMUSG00000069274', u'ENSMUSG00000061482', u'ENSMUSG00000060093', u'ENSMUSG00000030538', u'ENSMUSG00000064288', u'ENSMUSG00000069305', u'ENSMUSG00000069306', u'ENSMUSG00000091405']), pop_n=13836, p_sm_bonferroni=0.014466278349934403, is_obsolete=False, GO='GO:0045653', name='negative regulation of megakaryocyte differentiation', pop_count=14, alt_ids=[], level=7, depth=8, enrichment='e', Cluster='Transient Increase', geneid_set=set([u'ENSMUSG00000008976', u'ENSMUSG00000069266', u'ENSMUSG00000067455', u'ENSMUSG00000069274', u'ENSMUSG00000061482', u'ENSMUSG00000060093', u'ENSMUSG00000064288']), symbols=u'Gabpa Hist1h4a Hist1h4b Hist1h4d Hist1h4f Hist1h4j Hist1h4k', symbol_set=set([u'Hist1h4b', u'Hist1h4a', u'Hist1h4f', u'Hist1h4d', u'Hist1h4k', u'Hist1h4j', u'Gabpa']), geneids='ENSMUSG00000008976 ENSMUSG00000067455 ENSMUSG00000069266 ENSMUSG00000069274 ENSMUSG00000061482 ENSMUSG00000060093 ENSMUSG00000064288', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=0, D1='A', GO_name='negative regulation of megakaryocyte differentiation'),
    Nt(p_uncorrected=0.000722549994700679, study_count=5, study_n=624, namespace='biological_process', p_fdr_bh=0.048439623759778706, study_items=set([u'ENSMUSG00000020290', u'ENSMUSG00000047735', u'ENSMUSG00000011179', u'ENSMUSG00000029521', u'ENSMUSG00000020184']), NS='BP', pop_items=set([u'ENSMUSG00000027654', u'ENSMUSG00000020290', u'ENSMUSG00000017221', u'ENSMUSG00000044734', u'ENSMUSG00000029521', u'ENSMUSG00000020349', u'ENSMUSG00000006699', u'ENSMUSG00000006058', u'ENSMUSG00000020184', u'ENSMUSG00000030530', u'ENSMUSG00000010517', u'ENSMUSG00000020634', u'ENSMUSG00000011179', u'ENSMUSG00000055116', u'ENSMUSG00000006998', u'ENSMUSG00000047735', u'ENSMUSG00000026229']), pop_n=13836, p_sm_bonferroni=1.0, is_obsolete=False, GO='GO:0042176', name='regulation of protein catabolic process', pop_count=17, alt_ids=[], level=5, depth=6, enrichment='e', Cluster='Transient Increase', geneid_set=set([u'ENSMUSG00000020290', u'ENSMUSG00000047735', u'ENSMUSG00000011179', u'ENSMUSG00000020184', u'ENSMUSG00000029521']), symbols=u'Chek2 Mdm2 Odc1 Samd9l Xpo1', symbol_set=set([u'Xpo1', u'Samd9l', u'Mdm2', u'Chek2', u'Odc1']), geneids='ENSMUSG00000020290 ENSMUSG00000047735 ENSMUSG00000011179 ENSMUSG00000029521 ENSMUSG00000020184', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=65, D1='A', GO_name='regulation of protein catabolic process'),
    Nt(p_uncorrected=6.018241857743234e-09, study_count=33, study_n=624, namespace='biological_process', p_fdr_bh=1.8236476477333547e-06, study_items=set([u'ENSMUSG00000032661', u'ENSMUSG00000070034', u'ENSMUSG00000024079', u'ENSMUSG00000074151', u'ENSMUSG00000036986', u'ENSMUSG00000074896', u'ENSMUSG00000041827', u'ENSMUSG00000032508', u'ENSMUSG00000023341', u'ENSMUSG00000028633', u'ENSMUSG00000054072', u'ENSMUSG00000021624', u'ENSMUSG00000039748', u'ENSMUSG00000039236', u'ENSMUSG00000054717', u'ENSMUSG00000018899', u'ENSMUSG00000027514', u'ENSMUSG00000046718', u'ENSMUSG00000046879', u'ENSMUSG00000029561', u'ENSMUSG00000017830', u'ENSMUSG00000029605', u'ENSMUSG00000026896', u'ENSMUSG00000037321', u'ENSMUSG00000034459', u'ENSMUSG00000032344', u'ENSMUSG00000040296', u'ENSMUSG00000025498', u'ENSMUSG00000020641', u'ENSMUSG00000001123', u'ENSMUSG00000045932', u'ENSMUSG00000034218', u'ENSMUSG00000000386']), NS='BP', pop_items=set([u'ENSMUSG00000035834', u'ENSMUSG00000045322', u'ENSMUSG00000028874', u'ENSMUSG00000004730', u'ENSMUSG00000021703', u'ENSMUSG00000024079', u'ENSMUSG00000074151', u'ENSMUSG00000060586', u'ENSMUSG00000016481', u'ENSMUSG00000024338', u'ENSMUSG00000055172', u'ENSMUSG00000036887', u'ENSMUSG00000009585', u'ENSMUSG00000031805', u'ENSMUSG00000022476', u'ENSMUSG00000024371', u'ENSMUSG00000042228', u'ENSMUSG00000017707', u'ENSMUSG00000032035', u'ENSMUSG00000071369', u'ENSMUSG00000026399', u'ENSMUSG00000037523', u'ENSMUSG00000038628', u'ENSMUSG00000020115', u'ENSMUSG00000000776', u'ENSMUSG00000019843', u'ENSMUSG00000015217', u'ENSMUSG00000035629', u'ENSMUSG00000039748', u'ENSMUSG00000039236', u'ENSMUSG00000049686', u'ENSMUSG00000024164', u'ENSMUSG00000035279', u'ENSMUSG00000024045', u'ENSMUSG00000038128', u'ENSMUSG00000075705', u'ENSMUSG00000041187', u'ENSMUSG00000038517', u'ENSMUSG00000046034', u'ENSMUSG00000062593', u'ENSMUSG00000029605', u'ENSMUSG00000026896', u'ENSMUSG00000037321', u'ENSMUSG00000037649', u'ENSMUSG00000014599', u'ENSMUSG00000000275', u'ENSMUSG00000024789', u'ENSMUSG00000051439', u'ENSMUSG00000038058', u'ENSMUSG00000025512', u'ENSMUSG00000050199', u'ENSMUSG00000034889', u'ENSMUSG00000024621', u'ENSMUSG00000027951', u'ENSMUSG00000020437', u'ENSMUSG00000070390', u'ENSMUSG00000036986', u'ENSMUSG00000030751', u'ENSMUSG00000025139', u'ENSMUSG00000000134', u'ENSMUSG00000026883', u'ENSMUSG00000015837', u'ENSMUSG00000032691', u'ENSMUSG00000018446', u'ENSMUSG00000018899', u'ENSMUSG00000028885', u'ENSMUSG00000029826', u'ENSMUSG00000028633', u'ENSMUSG00000027646', u'ENSMUSG00000003184', u'ENSMUSG00000047123', u'ENSMUSG00000024767', u'ENSMUSG00000016024', u'ENSMUSG00000054072', u'ENSMUSG00000036908', u'ENSMUSG00000037860', u'ENSMUSG00000036905', u'ENSMUSG00000032312', u'ENSMUSG00000061232', u'ENSMUSG00000001123', u'ENSMUSG00000031392', u'ENSMUSG00000028099', u'ENSMUSG00000055204', u'ENSMUSG00000022901', u'ENSMUSG00000045932', u'ENSMUSG00000033777', u'ENSMUSG00000059883', u'ENSMUSG00000027598', u'ENSMUSG00000030263', u'ENSMUSG00000039936', u'ENSMUSG00000003283', u'ENSMUSG00000051212', u'ENSMUSG00000044583', u'ENSMUSG00000023915', u'ENSMUSG00000002688', u'ENSMUSG00000022636', u'ENSMUSG00000021583', u'ENSMUSG00000078942', u'ENSMUSG00000031838', u'ENSMUSG00000078945', u'ENSMUSG00000025702', u'ENSMUSG00000027639', u'ENSMUSG00000033307', u'ENSMUSG00000024610', u'ENSMUSG00000000787', u'ENSMUSG00000034453', u'ENSMUSG00000026288', u'ENSMUSG00000028793', u'ENSMUSG00000034218', u'ENSMUSG00000023990', u'ENSMUSG00000025532', u'ENSMUSG00000060550', u'ENSMUSG00000000386', u'ENSMUSG00000052384', u'ENSMUSG00000070034', u'ENSMUSG00000028064', u'ENSMUSG00000027427', u'ENSMUSG00000026928', u'ENSMUSG00000000732', u'ENSMUSG00000020399', u'ENSMUSG00000046718', u'ENSMUSG00000013707', u'ENSMUSG00000030793', u'ENSMUSG00000021457', u'ENSMUSG00000074896', u'ENSMUSG00000024948', u'ENSMUSG00000031639', u'ENSMUSG00000020823', u'ENSMUSG00000025498', u'ENSMUSG00000047798', u'ENSMUSG00000026285', u'ENSMUSG00000032508', u'ENSMUSG00000024339', u'ENSMUSG00000002602', u'ENSMUSG00000053647', u'ENSMUSG00000060591', u'ENSMUSG00000041439', u'ENSMUSG00000032076', u'ENSMUSG00000024235', u'ENSMUSG00000001150', u'ENSMUSG00000027508', u'ENSMUSG00000036896', u'ENSMUSG00000071203', u'ENSMUSG00000079547', u'ENSMUSG00000030880', u'ENSMUSG00000041135', u'ENSMUSG00000024392', u'ENSMUSG00000022575', u'ENSMUSG00000021624', u'ENSMUSG00000020707', u'ENSMUSG00000038213', u'ENSMUSG00000057058', u'ENSMUSG00000027514', u'ENSMUSG00000037731', u'ENSMUSG00000030122', u'ENSMUSG00000024349', u'ENSMUSG00000033454', u'ENSMUSG00000022514', u'ENSMUSG00000022887', u'ENSMUSG00000036469', u'ENSMUSG00000023973', u'ENSMUSG00000043496', u'ENSMUSG00000020573', u'ENSMUSG00000034652', u'ENSMUSG00000036712', u'ENSMUSG00000025492', u'ENSMUSG00000032109', u'ENSMUSG00000060802', u'ENSMUSG00000029798', u'ENSMUSG00000032344', u'ENSMUSG00000059456', u'ENSMUSG00000026117', u'ENSMUSG00000040296', u'ENSMUSG00000032690', u'ENSMUSG00000040751', u'ENSMUSG00000032905', u'ENSMUSG00000020476', u'ENSMUSG00000004707', u'ENSMUSG00000038160', u'ENSMUSG00000038495', u'ENSMUSG00000001128', u'ENSMUSG00000029771', u'ENSMUSG00000058818', u'ENSMUSG00000040264', u'ENSMUSG00000056851', u'ENSMUSG00000032661', u'ENSMUSG00000067212', u'ENSMUSG00000038521', u'ENSMUSG00000036594', u'ENSMUSG00000031750', u'ENSMUSG00000022508', u'ENSMUSG00000073421', u'ENSMUSG00000041827', u'ENSMUSG00000050335', u'ENSMUSG00000044811', u'ENSMUSG00000026471', u'ENSMUSG00000017830', u'ENSMUSG00000019256', u'ENSMUSG00000023341', u'ENSMUSG00000023224', u'ENSMUSG00000015947', u'ENSMUSG00000020641', u'ENSMUSG00000026778', u'ENSMUSG00000039005', u'ENSMUSG00000026648', u'ENSMUSG00000028059', u'ENSMUSG00000028191', u'ENSMUSG00000054717', u'ENSMUSG00000038260', u'ENSMUSG00000046879', u'ENSMUSG00000021277', u'ENSMUSG00000030748', u'ENSMUSG00000033538', u'ENSMUSG00000028291', u'ENSMUSG00000029217', u'ENSMUSG00000051256', u'ENSMUSG00000066839', u'ENSMUSG00000073411', u'ENSMUSG00000005102', u'ENSMUSG00000029561', u'ENSMUSG00000029915', u'ENSMUSG00000027995', u'ENSMUSG00000044827', u'ENSMUSG00000043279', u'ENSMUSG00000027164', u'ENSMUSG00000026365', u'ENSMUSG00000032322', u'ENSMUSG00000032041', u'ENSMUSG00000034459', u'ENSMUSG00000045038', u'ENSMUSG00000021423', u'ENSMUSG00000038147', u'ENSMUSG00000052889', u'ENSMUSG00000050132', u'ENSMUSG00000032737']), pop_n=13836, p_sm_bonferroni=9.118238238666775e-05, is_obsolete=False, GO='GO:0002376', name='immune system process', pop_count=235, alt_ids=[], level=1, depth=1, enrichment='e', Cluster='Transient Increase', geneid_set=set([u'ENSMUSG00000032661', u'ENSMUSG00000070034', u'ENSMUSG00000024079', u'ENSMUSG00000074151', u'ENSMUSG00000036986', u'ENSMUSG00000074896', u'ENSMUSG00000041827', u'ENSMUSG00000032508', u'ENSMUSG00000023341', u'ENSMUSG00000028633', u'ENSMUSG00000054072', u'ENSMUSG00000021624', u'ENSMUSG00000039748', u'ENSMUSG00000039236', u'ENSMUSG00000054717', u'ENSMUSG00000018899', u'ENSMUSG00000027514', u'ENSMUSG00000046718', u'ENSMUSG00000046879', u'ENSMUSG00000029561', u'ENSMUSG00000017830', u'ENSMUSG00000029605', u'ENSMUSG00000026896', u'ENSMUSG00000037321', u'ENSMUSG00000034459', u'ENSMUSG00000032344', u'ENSMUSG00000040296', u'ENSMUSG00000025498', u'ENSMUSG00000020641', u'ENSMUSG00000001123', u'ENSMUSG00000045932', u'ENSMUSG00000034218', u'ENSMUSG00000000386']), symbols=u'Atm Bst2 Cd180 Ctps Ddx58 Dhx58 Eif2ak2 Exo1 Hmgb2 Ifih1 Ifit1 Ifit2 Ifit3 Iigp1 Irf1 Irf7 Irgm1 Isg20 Lgals9 Mb21d1 Mx1 Mx2 Myd88 Nlrc5 Oas1b Oas3 Oasl1 Oasl2 Pml Rsad2 Sp110 Tap1 Zbp1', symbol_set=set([u'Lgals9', 'Mb21d1', u'Sp110', u'Mx1', u'Iigp1', u'Irf1', u'Irf7', u'Zbp1', u'Eif2ak2', u'Oas3', u'Isg20', u'Nlrc5', u'Tap1', u'Atm', u'Ddx58', u'Oas1b', u'Oasl2', u'Ifih1', u'Oasl1', u'Irgm1', u'Ctps', u'Myd88', u'Dhx58', u'Hmgb2', u'Exo1', u'Mx2', u'Ifit2', u'Bst2', u'Pml', u'Cd180', u'Ifit3', u'Rsad2', u'Ifit1']), geneids='ENSMUSG00000032661 ENSMUSG00000023341 ENSMUSG00000070034 ENSMUSG00000024079 ENSMUSG00000074151 ENSMUSG00000036986 ENSMUSG00000074896 ENSMUSG00000041827 ENSMUSG00000032508 ENSMUSG00000017830 ENSMUSG00000028633 ENSMUSG00000054072 ENSMUSG00000021624 ENSMUSG00000039748 ENSMUSG00000039236 ENSMUSG00000054717 ENSMUSG00000018899 ENSMUSG00000027514 ENSMUSG00000046718 ENSMUSG00000046879 ENSMUSG00000029561 ENSMUSG00000029605 ENSMUSG00000026896 ENSMUSG00000037321 ENSMUSG00000034459 ENSMUSG00000032344 ENSMUSG00000040296 ENSMUSG00000025498 ENSMUSG00000020641 ENSMUSG00000001123 ENSMUSG00000045932 ENSMUSG00000034218 ENSMUSG00000000386', format_txt=1, hdr_idx=1, is_hdrgo=True, is_usrgo=True, hdr1usr01='**', dcnt=572, D1='L', GO_name='immune system process'),
    Nt(p_uncorrected=1.976111142578265e-05, study_count=4, study_n=624, namespace='biological_process', p_fdr_bh=0.002185405833664474, study_items=set([u'ENSMUSG00000007080', u'ENSMUSG00000038644', u'ENSMUSG00000030726', u'ENSMUSG00000021668']), NS='BP', pop_items=set([u'ENSMUSG00000007080', u'ENSMUSG00000038644', u'ENSMUSG00000030726', u'ENSMUSG00000049717', u'ENSMUSG00000021668']), pop_n=13836, p_sm_bonferroni=0.29940059921203294, is_obsolete=False, GO='GO:0006297', name='nucleotide-excision repair, DNA gap filling', pop_count=5, alt_ids=[], level=5, depth=7, enrichment='e', Cluster='Transient Increase', geneid_set=set([u'ENSMUSG00000021668', u'ENSMUSG00000038644', u'ENSMUSG00000030726', u'ENSMUSG00000007080']), symbols=u'Pold1 Pold3 Pole Polk', symbol_set=set([u'Pold1', u'Pole', u'Pold3', u'Polk']), geneids='ENSMUSG00000021668 ENSMUSG00000038644 ENSMUSG00000030726 ENSMUSG00000007080', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=0, D1='BD', GO_name='nucleotide-excision repair, DNA gap filling'),
    Nt(p_uncorrected=2.7262250045263463e-11, study_count=15, study_n=624, namespace='biological_process', p_fdr_bh=3.774646010782965e-08, study_items=set([u'ENSMUSG00000017499', u'ENSMUSG00000028212', u'ENSMUSG00000032555', u'ENSMUSG00000005410', u'ENSMUSG00000026355', u'ENSMUSG00000022673', u'ENSMUSG00000002068', u'ENSMUSG00000026669', u'ENSMUSG00000024833', u'ENSMUSG00000031697', u'ENSMUSG00000029283', u'ENSMUSG00000000028', u'ENSMUSG00000029730', u'ENSMUSG00000041859', u'ENSMUSG00000002870']), NS='BP', pop_items=set([u'ENSMUSG00000029730', u'ENSMUSG00000024833', u'ENSMUSG00000041859', u'ENSMUSG00000002870', u'ENSMUSG00000000028', u'ENSMUSG00000021597', u'ENSMUSG00000026355', u'ENSMUSG00000006678', u'ENSMUSG00000026761', u'ENSMUSG00000028212', u'ENSMUSG00000068428', u'ENSMUSG00000002068', u'ENSMUSG00000026669', u'ENSMUSG00000022673', u'ENSMUSG00000031546', u'ENSMUSG00000017499', u'ENSMUSG00000032555', u'ENSMUSG00000040044', u'ENSMUSG00000005410', u'ENSMUSG00000031697', u'ENSMUSG00000029283', u'ENSMUSG00000029012']), pop_n=13836, p_sm_bonferroni=4.130503504357867e-07, is_obsolete=False, GO='GO:0006270', name='DNA replication initiation', pop_count=22, alt_ids=['GO:0042024'], level=5, depth=7, enrichment='e', Cluster='Transient Increase', geneid_set=set([u'ENSMUSG00000017499', u'ENSMUSG00000028212', u'ENSMUSG00000032555', u'ENSMUSG00000005410', u'ENSMUSG00000026355', u'ENSMUSG00000024833', u'ENSMUSG00000002068', u'ENSMUSG00000026669', u'ENSMUSG00000022673', u'ENSMUSG00000031697', u'ENSMUSG00000029283', u'ENSMUSG00000000028', u'ENSMUSG00000029730', u'ENSMUSG00000041859', u'ENSMUSG00000002870']), symbols=u'Ccne1 Ccne2 Cdc45 Cdc6 Cdc7 Mcm10 Mcm2 Mcm3 Mcm4 Mcm5 Mcm6 Mcm7 Orc6 Pola2 Topbp1', symbol_set=set([u'Pola2', u'Orc6', u'Mcm10', u'Topbp1', u'Ccne2', u'Ccne1', u'Mcm7', u'Mcm6', u'Mcm5', u'Mcm4', u'Mcm3', u'Mcm2', u'Cdc45', u'Cdc6', u'Cdc7']), geneids='ENSMUSG00000017499 ENSMUSG00000028212 ENSMUSG00000000028 ENSMUSG00000005410 ENSMUSG00000026355 ENSMUSG00000024833 ENSMUSG00000002068 ENSMUSG00000026669 ENSMUSG00000022673 ENSMUSG00000031697 ENSMUSG00000029283 ENSMUSG00000032555 ENSMUSG00000029730 ENSMUSG00000041859 ENSMUSG00000002870', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=7, D1='BD', GO_name='DNA replication initiation'),
    Nt(p_uncorrected=1.0053914461965553e-06, study_count=11, study_n=624, namespace='biological_process', p_fdr_bh=0.00016034406106656853, study_items=set([u'ENSMUSG00000028211', u'ENSMUSG00000030641', u'ENSMUSG00000003873', u'ENSMUSG00000057789', u'ENSMUSG00000059552', u'ENSMUSG00000032477', u'ENSMUSG00000027342', u'ENSMUSG00000020897', u'ENSMUSG00000022033', u'ENSMUSG00000032409', u'ENSMUSG00000038644']), NS='BP', pop_items=set([u'ENSMUSG00000020366', u'ENSMUSG00000003873', u'ENSMUSG00000073616', u'ENSMUSG00000029535', u'ENSMUSG00000022521', u'ENSMUSG00000021264', u'ENSMUSG00000059552', u'ENSMUSG00000059263', u'ENSMUSG00000030641', u'ENSMUSG00000029026', u'ENSMUSG00000041417', u'ENSMUSG00000028914', u'ENSMUSG00000032267', u'ENSMUSG00000036940', u'ENSMUSG00000004655', u'ENSMUSG00000014074', u'ENSMUSG00000020897', u'ENSMUSG00000022033', u'ENSMUSG00000026142', u'ENSMUSG00000032409', u'ENSMUSG00000038644', u'ENSMUSG00000028211', u'ENSMUSG00000000838', u'ENSMUSG00000030268', u'ENSMUSG00000034154', u'ENSMUSG00000003868', u'ENSMUSG00000033454', u'ENSMUSG00000055024', u'ENSMUSG00000019889', u'ENSMUSG00000031314', u'ENSMUSG00000031652', u'ENSMUSG00000022545', u'ENSMUSG00000032477', u'ENSMUSG00000005102', u'ENSMUSG00000057789', u'ENSMUSG00000023353', u'ENSMUSG00000028086', u'ENSMUSG00000027342', u'ENSMUSG00000002342', u'ENSMUSG00000021116']), pop_n=13836, p_sm_bonferroni=0.01523268580132401, is_obsolete=False, GO='GO:0034644', name='cellular response to UV', pop_count=40, alt_ids=[], level=6, depth=6, enrichment='e', Cluster='Transient Increase', geneid_set=set([u'ENSMUSG00000028211', u'ENSMUSG00000030641', u'ENSMUSG00000003873', u'ENSMUSG00000022033', u'ENSMUSG00000020897', u'ENSMUSG00000027342', u'ENSMUSG00000059552', u'ENSMUSG00000038644', u'ENSMUSG00000057789', u'ENSMUSG00000032409', u'ENSMUSG00000032477']), symbols=u'Atr Aurkb Bak1 Bax Cdc25a Ddias Pbk Pcna Pold1 Trp53 Trp53inp1', symbol_set=set(['Ddias', u'Pcna', u'Trp53', u'Cdc25a', u'Bax', u'Bak1', u'Pold1', u'Trp53inp1', u'Atr', u'Aurkb', u'Pbk']), geneids='ENSMUSG00000028211 ENSMUSG00000030641 ENSMUSG00000003873 ENSMUSG00000057789 ENSMUSG00000059552 ENSMUSG00000027342 ENSMUSG00000020897 ENSMUSG00000038644 ENSMUSG00000022033 ENSMUSG00000032409 ENSMUSG00000032477', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=7, D1='BF', GO_name='cellular response to UV'),
    Nt(p_uncorrected=3.4475572661038637e-11, study_count=86, study_n=624, namespace='biological_process', p_fdr_bh=3.774646010782965e-08, study_items=set([u'ENSMUSG00000040084', u'ENSMUSG00000034349', u'ENSMUSG00000027469', u'ENSMUSG00000042029', u'ENSMUSG00000045328', u'ENSMUSG00000024974', u'ENSMUSG00000025358', u'ENSMUSG00000022177', u'ENSMUSG00000022070', u'ENSMUSG00000027379', u'ENSMUSG00000020897', u'ENSMUSG00000019773', u'ENSMUSG00000062510', u'ENSMUSG00000029521', u'ENSMUSG00000051378', u'ENSMUSG00000037313', u'ENSMUSG00000001855', u'ENSMUSG00000027715', u'ENSMUSG00000032254', u'ENSMUSG00000006398', u'ENSMUSG00000072082', u'ENSMUSG00000027496', u'ENSMUSG00000024660', u'ENSMUSG00000026622', u'ENSMUSG00000078762', u'ENSMUSG00000028873', u'ENSMUSG00000027306', u'ENSMUSG00000024056', u'ENSMUSG00000048922', u'ENSMUSG00000034906', u'ENSMUSG00000032397', u'ENSMUSG00000021965', u'ENSMUSG00000031478', u'ENSMUSG00000030867', u'ENSMUSG00000047534', u'ENSMUSG00000032400', u'ENSMUSG00000028312', u'ENSMUSG00000021115', u'ENSMUSG00000043065', u'ENSMUSG00000032477', u'ENSMUSG00000026683', u'ENSMUSG00000027326', u'ENSMUSG00000027635', u'ENSMUSG00000040034', u'ENSMUSG00000012443', u'ENSMUSG00000029414', u'ENSMUSG00000028066', u'ENSMUSG00000001403', u'ENSMUSG00000002055', u'ENSMUSG00000051220', u'ENSMUSG00000033364', u'ENSMUSG00000041431', u'ENSMUSG00000041238', u'ENSMUSG00000039994', u'ENSMUSG00000027331', u'ENSMUSG00000020492', u'ENSMUSG00000041133', u'ENSMUSG00000024989', u'ENSMUSG00000028896', u'ENSMUSG00000045273', u'ENSMUSG00000058290', u'ENSMUSG00000033952', u'ENSMUSG00000038252', u'ENSMUSG00000025001', u'ENSMUSG00000040599', u'ENSMUSG00000032218', u'ENSMUSG00000029472', u'ENSMUSG00000024795', u'ENSMUSG00000031756', u'ENSMUSG00000023940', u'ENSMUSG00000023505', u'ENSMUSG00000028678', u'ENSMUSG00000026779', u'ENSMUSG00000020326', u'ENSMUSG00000069910', u'ENSMUSG00000074476', u'ENSMUSG00000021374', u'ENSMUSG00000073705', u'ENSMUSG00000068744', u'ENSMUSG00000019942', u'ENSMUSG00000017499', u'ENSMUSG00000020808', u'ENSMUSG00000017716', u'ENSMUSG00000029910', u'ENSMUSG00000035024', u'ENSMUSG00000005233']), NS='BP', pop_items=set([u'ENSMUSG00000040084', u'ENSMUSG00000019942', u'ENSMUSG00000026491', u'ENSMUSG00000024073', u'ENSMUSG00000029516', u'ENSMUSG00000026965', u'ENSMUSG00000027330', u'ENSMUSG00000027469', u'ENSMUSG00000042029', u'ENSMUSG00000045328', u'ENSMUSG00000006005', u'ENSMUSG00000024974', u'ENSMUSG00000025358', u'ENSMUSG00000018509', u'ENSMUSG00000025001', u'ENSMUSG00000030649', u'ENSMUSG00000024370', u'ENSMUSG00000033088', u'ENSMUSG00000025616', u'ENSMUSG00000024277', u'ENSMUSG00000022177', u'ENSMUSG00000011589', u'ENSMUSG00000041769', u'ENSMUSG00000022070', u'ENSMUSG00000020752', u'ENSMUSG00000020897', u'ENSMUSG00000015120', u'ENSMUSG00000075266', u'ENSMUSG00000019773', u'ENSMUSG00000026779', u'ENSMUSG00000062510', u'ENSMUSG00000027654', u'ENSMUSG00000029521', u'ENSMUSG00000012429', u'ENSMUSG00000031176', u'ENSMUSG00000021693', u'ENSMUSG00000048930', u'ENSMUSG00000027550', u'ENSMUSG00000033392', u'ENSMUSG00000019988', u'ENSMUSG00000051378', u'ENSMUSG00000037313', u'ENSMUSG00000021959', u'ENSMUSG00000031347', u'ENSMUSG00000001855', u'ENSMUSG00000033323', u'ENSMUSG00000027496', u'ENSMUSG00000022314', u'ENSMUSG00000002546', u'ENSMUSG00000027306', u'ENSMUSG00000072082', u'ENSMUSG00000030965', u'ENSMUSG00000027715', u'ENSMUSG00000020107', u'ENSMUSG00000031971', u'ENSMUSG00000026622', u'ENSMUSG00000025925', u'ENSMUSG00000035439', u'ENSMUSG00000036977', u'ENSMUSG00000032254', u'ENSMUSG00000020745', u'ENSMUSG00000029430', u'ENSMUSG00000020415', u'ENSMUSG00000024056', u'ENSMUSG00000066149', u'ENSMUSG00000005233', u'ENSMUSG00000034021', u'ENSMUSG00000048922', u'ENSMUSG00000034906', u'ENSMUSG00000070923', u'ENSMUSG00000025135', u'ENSMUSG00000028214', u'ENSMUSG00000032397', u'ENSMUSG00000031644', u'ENSMUSG00000021965', u'ENSMUSG00000047126', u'ENSMUSG00000034349', u'ENSMUSG00000030867', u'ENSMUSG00000040021', u'ENSMUSG00000019907', u'ENSMUSG00000047534', u'ENSMUSG00000015149', u'ENSMUSG00000032400', u'ENSMUSG00000004936', u'ENSMUSG00000036782', u'ENSMUSG00000035351', u'ENSMUSG00000031010', u'ENSMUSG00000029466', u'ENSMUSG00000045210', u'ENSMUSG00000026426', u'ENSMUSG00000028312', u'ENSMUSG00000031016', u'ENSMUSG00000034290', u'ENSMUSG00000066979', u'ENSMUSG00000021115', u'ENSMUSG00000028549', u'ENSMUSG00000025144', u'ENSMUSG00000046010', u'ENSMUSG00000039130', u'ENSMUSG00000028896', u'ENSMUSG00000002365', u'ENSMUSG00000032477', u'ENSMUSG00000026683', u'ENSMUSG00000029385', u'ENSMUSG00000027326', u'ENSMUSG00000027635', u'ENSMUSG00000024943', u'ENSMUSG00000040034', u'ENSMUSG00000028495', u'ENSMUSG00000024576', u'ENSMUSG00000012443', u'ENSMUSG00000035342', u'ENSMUSG00000079555', u'ENSMUSG00000017421', u'ENSMUSG00000029414', u'ENSMUSG00000036923', u'ENSMUSG00000028066', u'ENSMUSG00000001403', u'ENSMUSG00000029554', u'ENSMUSG00000002055', u'ENSMUSG00000075324', u'ENSMUSG00000024137', u'ENSMUSG00000051220', u'ENSMUSG00000028478', u'ENSMUSG00000036777', u'ENSMUSG00000022678', u'ENSMUSG00000036779', u'ENSMUSG00000033364', u'ENSMUSG00000030397', u'ENSMUSG00000006398', u'ENSMUSG00000021595', u'ENSMUSG00000041431', u'ENSMUSG00000040945', u'ENSMUSG00000039994', u'ENSMUSG00000031820', u'ENSMUSG00000027331', u'ENSMUSG00000043065', u'ENSMUSG00000031787', u'ENSMUSG00000032264', u'ENSMUSG00000090083', u'ENSMUSG00000020492', u'ENSMUSG00000022978', u'ENSMUSG00000019923', u'ENSMUSG00000061665', u'ENSMUSG00000021258', u'ENSMUSG00000027379', u'ENSMUSG00000020235', u'ENSMUSG00000030079', u'ENSMUSG00000028873', u'ENSMUSG00000059586', u'ENSMUSG00000045273', u'ENSMUSG00000058290', u'ENSMUSG00000014668', u'ENSMUSG00000038416', u'ENSMUSG00000033952', u'ENSMUSG00000038252', u'ENSMUSG00000078762', u'ENSMUSG00000029166', u'ENSMUSG00000040599', u'ENSMUSG00000029176', u'ENSMUSG00000024795', u'ENSMUSG00000024989', u'ENSMUSG00000032218', u'ENSMUSG00000037286', u'ENSMUSG00000041133', u'ENSMUSG00000033209', u'ENSMUSG00000026749', u'ENSMUSG00000071350', u'ENSMUSG00000035048', u'ENSMUSG00000041408', u'ENSMUSG00000025410', u'ENSMUSG00000024790', u'ENSMUSG00000036672', u'ENSMUSG00000022802', u'ENSMUSG00000021918', u'ENSMUSG00000047777', u'ENSMUSG00000041238', u'ENSMUSG00000021537', u'ENSMUSG00000044502', u'ENSMUSG00000019794', u'ENSMUSG00000062380', u'ENSMUSG00000053333', u'ENSMUSG00000029472', u'ENSMUSG00000017716', u'ENSMUSG00000029910', u'ENSMUSG00000031201', u'ENSMUSG00000021365', u'ENSMUSG00000031756', u'ENSMUSG00000048170', u'ENSMUSG00000023940', u'ENSMUSG00000025077', u'ENSMUSG00000014355', u'ENSMUSG00000026276', u'ENSMUSG00000027285', u'ENSMUSG00000033900', u'ENSMUSG00000021374', u'ENSMUSG00000024660', u'ENSMUSG00000023505', u'ENSMUSG00000029253', u'ENSMUSG00000028447', u'ENSMUSG00000027937', u'ENSMUSG00000018651', u'ENSMUSG00000029003', u'ENSMUSG00000040102', u'ENSMUSG00000022750', u'ENSMUSG00000038619', u'ENSMUSG00000001833', u'ENSMUSG00000029684', u'ENSMUSG00000020326', u'ENSMUSG00000069910', u'ENSMUSG00000028059', u'ENSMUSG00000029501', u'ENSMUSG00000040549', u'ENSMUSG00000025862', u'ENSMUSG00000074476', u'ENSMUSG00000034154', u'ENSMUSG00000028678', u'ENSMUSG00000064302', u'ENSMUSG00000041840', u'ENSMUSG00000073705', u'ENSMUSG00000068744', u'ENSMUSG00000030105', u'ENSMUSG00000073700', u'ENSMUSG00000042364', u'ENSMUSG00000040250', u'ENSMUSG00000030744', u'ENSMUSG00000052087', u'ENSMUSG00000017499', u'ENSMUSG00000049327', u'ENSMUSG00000053046', u'ENSMUSG00000031478', u'ENSMUSG00000043987', u'ENSMUSG00000020808', u'ENSMUSG00000032435', u'ENSMUSG00000031529', u'ENSMUSG00000040667', u'ENSMUSG00000030428', u'ENSMUSG00000052139', u'ENSMUSG00000028851', u'ENSMUSG00000032534', u'ENSMUSG00000035024', u'ENSMUSG00000027479', u'ENSMUSG00000019873', u'ENSMUSG00000031371', u'ENSMUSG00000007656', u'ENSMUSG00000015971', u'ENSMUSG00000032733', u'ENSMUSG00000079614', u'ENSMUSG00000031858']), pop_n=13836, p_sm_bonferroni=5.223394013873964e-07, is_obsolete=False, GO='GO:0007067', name='mitotic nuclear division', pop_count=249, alt_ids=[], level=4, depth=6, enrichment='e', Cluster='Transient Increase', geneid_set=set([u'ENSMUSG00000029414', u'ENSMUSG00000040084', u'ENSMUSG00000031478', u'ENSMUSG00000028066', u'ENSMUSG00000001403', u'ENSMUSG00000033952', u'ENSMUSG00000027469', u'ENSMUSG00000037313', u'ENSMUSG00000045328', u'ENSMUSG00000024974', u'ENSMUSG00000025358', u'ENSMUSG00000051220', u'ENSMUSG00000033364', u'ENSMUSG00000041431', u'ENSMUSG00000041238', u'ENSMUSG00000039994', u'ENSMUSG00000022177', u'ENSMUSG00000027331', u'ENSMUSG00000022070', u'ENSMUSG00000027379', u'ENSMUSG00000024056', u'ENSMUSG00000020897', u'ENSMUSG00000020492', u'ENSMUSG00000041133', u'ENSMUSG00000024989', u'ENSMUSG00000019773', u'ENSMUSG00000062510', u'ENSMUSG00000029521', u'ENSMUSG00000028896', u'ENSMUSG00000045273', u'ENSMUSG00000058290', u'ENSMUSG00000024660', u'ENSMUSG00000038252', u'ENSMUSG00000051378', u'ENSMUSG00000042029', u'ENSMUSG00000025001', u'ENSMUSG00000040599', u'ENSMUSG00000001855', u'ENSMUSG00000002055', u'ENSMUSG00000027715', u'ENSMUSG00000032254', u'ENSMUSG00000006398', u'ENSMUSG00000072082', u'ENSMUSG00000027496', u'ENSMUSG00000026622', u'ENSMUSG00000078762', u'ENSMUSG00000028873', u'ENSMUSG00000027306', u'ENSMUSG00000029472', u'ENSMUSG00000048922', u'ENSMUSG00000024795', u'ENSMUSG00000034906', u'ENSMUSG00000031756', u'ENSMUSG00000032218', u'ENSMUSG00000023940', u'ENSMUSG00000032397', u'ENSMUSG00000021374', u'ENSMUSG00000023505', u'ENSMUSG00000021965', u'ENSMUSG00000034349', u'ENSMUSG00000030867', u'ENSMUSG00000047534', u'ENSMUSG00000026779', u'ENSMUSG00000032400', u'ENSMUSG00000020326', u'ENSMUSG00000069910', u'ENSMUSG00000028312', u'ENSMUSG00000074476', u'ENSMUSG00000028678', u'ENSMUSG00000021115', u'ENSMUSG00000073705', u'ENSMUSG00000068744', u'ENSMUSG00000019942', u'ENSMUSG00000017499', u'ENSMUSG00000043065', u'ENSMUSG00000032477', u'ENSMUSG00000026683', u'ENSMUSG00000020808', u'ENSMUSG00000027326', u'ENSMUSG00000027635', u'ENSMUSG00000017716', u'ENSMUSG00000029910', u'ENSMUSG00000040034', u'ENSMUSG00000035024', u'ENSMUSG00000005233', u'ENSMUSG00000012443']), symbols=u'Anapc5 Apitd1 Aspm Aurka Aurkb Birc5 Bora Bub1 Bub1b Ccna2 Ccnb1 Ccnb2 Ccnf Ccng1 Cdc20 Cdc25a Cdc6 Cdca2 Cdca3 Cdca8 Cdk1 Cdk2 Cenpe Cenph Cenpn Cep55 Chek2 Dsn1 Ercc6l Espl1 Fam64a Fbxo5 Haus4 Haus5 Hells Incenp Kif11 Kif18b Kif20b Kif23 Kif2c Knl1 Knstrn Kntc1 Mad2l1 Mastl Mis12 Mis18bp1 Ncapd2 Ncapd3 Ncapg2 Ncaph Ndc80 Nek2 Nek3 Nsl1 Nuf2 Nup153 Nup214 Nup43 Nusap1 Plk1 Pmf1 Psrc1 Rbbp8 Rcc1 Sgol1 Ska2 Ska3 Smc1a Smc2 Smc3 Smc4 Spag5 Spc24 Spc25 Spdl1 Spice1 Tacc3 Timeless Tipin Tpx2 Ube2c Usp37 Vrk1 Zwilch', symbol_set=set([u'Rbbp8', 'Spdl1', u'Cep55', u'Ccnf', u'Ncapg2', u'Mis12', u'Chek2', u'Ccng1', 'Ska3', 'Ska2', u'Fam64a', u'Cenpn', u'Ccna2', u'Cenph', u'Cenpe', u'Tacc3', u'Dsn1', u'Ncapd2', u'Ncapd3', u'Kif11', u'Smc1a', u'Rcc1', u'Cdc25a', u'Ccnb2', u'Ccnb1', u'Aspm', u'Ndc80', u'Cdc6', u'Tpx2', u'Mad2l1', u'Pmf1', u'Bub1b', u'Anapc5', u'Ercc6l', u'Aurka', u'Aurkb', u'Spc25', u'Spc24', u'Hells', u'Kntc1', u'Timeless', u'Incenp', u'Spag5', u'Cdk1', u'Cdk2', u'Ncaph', u'Nup214', 'Bora', u'Nuf2', u'Haus4', u'Haus5', u'Spice1', u'Nek2', u'Nek3', u'Sgol1', u'Kif18b', u'Nsl1', u'Nusap1', u'Tipin', u'Cdc20', u'Fbxo5', u'Zwilch', 'Knstrn', u'Psrc1', u'Mis18bp1', u'Ube2c', u'Cdca2', u'Cdca3', u'Espl1', u'Bub1', u'Cdca8', u'Kif20b', u'Smc3', u'Smc2', u'Mastl', u'Smc4', u'Kif23', u'Apitd1', u'Nup153', 'Knl1', u'Vrk1', u'Plk1', u'Usp37', u'Birc5', u'Nup43', u'Kif2c']), geneids='ENSMUSG00000040084 ENSMUSG00000019942 ENSMUSG00000027469 ENSMUSG00000037313 ENSMUSG00000045328 ENSMUSG00000024974 ENSMUSG00000025358 ENSMUSG00000022177 ENSMUSG00000022070 ENSMUSG00000027379 ENSMUSG00000033952 ENSMUSG00000019773 ENSMUSG00000062510 ENSMUSG00000029521 ENSMUSG00000051378 ENSMUSG00000042029 ENSMUSG00000001855 ENSMUSG00000027715 ENSMUSG00000032254 ENSMUSG00000027306 ENSMUSG00000072082 ENSMUSG00000027496 ENSMUSG00000024660 ENSMUSG00000026622 ENSMUSG00000078762 ENSMUSG00000028873 ENSMUSG00000024056 ENSMUSG00000048922 ENSMUSG00000034906 ENSMUSG00000032397 ENSMUSG00000021965 ENSMUSG00000034349 ENSMUSG00000030867 ENSMUSG00000047534 ENSMUSG00000032400 ENSMUSG00000028312 ENSMUSG00000021115 ENSMUSG00000043065 ENSMUSG00000032477 ENSMUSG00000026683 ENSMUSG00000027326 ENSMUSG00000027635 ENSMUSG00000040034 ENSMUSG00000012443 ENSMUSG00000029414 ENSMUSG00000028066 ENSMUSG00000001403 ENSMUSG00000002055 ENSMUSG00000051220 ENSMUSG00000033364 ENSMUSG00000006398 ENSMUSG00000041431 ENSMUSG00000041238 ENSMUSG00000039994 ENSMUSG00000027331 ENSMUSG00000020492 ENSMUSG00000041133 ENSMUSG00000024989 ENSMUSG00000028896 ENSMUSG00000045273 ENSMUSG00000058290 ENSMUSG00000020897 ENSMUSG00000038252 ENSMUSG00000025001 ENSMUSG00000040599 ENSMUSG00000032218 ENSMUSG00000029472 ENSMUSG00000024795 ENSMUSG00000031756 ENSMUSG00000023940 ENSMUSG00000023505 ENSMUSG00000028678 ENSMUSG00000026779 ENSMUSG00000020326 ENSMUSG00000069910 ENSMUSG00000074476 ENSMUSG00000021374 ENSMUSG00000073705 ENSMUSG00000068744 ENSMUSG00000017499 ENSMUSG00000031478 ENSMUSG00000020808 ENSMUSG00000017716 ENSMUSG00000029910 ENSMUSG00000035024 ENSMUSG00000005233', format_txt=1, hdr_idx=1, is_hdrgo=True, is_usrgo=True, hdr1usr01='**', dcnt=1, D1='BH', GO_name='mitotic nuclear division'),
    Nt(p_uncorrected=0.000430543497990217, study_count=4, study_n=624, namespace='biological_process', p_fdr_bh=0.03019983582430453, study_items=set([u'ENSMUSG00000017499', u'ENSMUSG00000030867', u'ENSMUSG00000045328', u'ENSMUSG00000001403']), NS='BP', pop_items=set([u'ENSMUSG00000017499', u'ENSMUSG00000026749', u'ENSMUSG00000024370', u'ENSMUSG00000029176', u'ENSMUSG00000001403', u'ENSMUSG00000066149', u'ENSMUSG00000045328', u'ENSMUSG00000030867', u'ENSMUSG00000036977']), pop_n=13836, p_sm_bonferroni=1.0, is_obsolete=False, GO='GO:0030071', name='regulation of mitotic metaphase/anaphase transition', pop_count=9, alt_ids=[], level=7, depth=10, enrichment='e', Cluster='Transient Increase', geneid_set=set([u'ENSMUSG00000017499', u'ENSMUSG00000030867', u'ENSMUSG00000045328', u'ENSMUSG00000001403']), symbols=u'Cdc6 Cenpe Plk1 Ube2c', symbol_set=set([u'Plk1', u'Cenpe', u'Ube2c', u'Cdc6']), geneids='ENSMUSG00000017499 ENSMUSG00000030867 ENSMUSG00000045328 ENSMUSG00000001403', format_txt=1, hdr_idx=1, is_hdrgo=True, is_usrgo=True, hdr1usr01='**', dcnt=11, D1='A', GO_name='regulation of mitotic metaphase/anaphase transition'),
    Nt(p_uncorrected=2.327303960478811e-06, study_count=9, study_n=624, namespace='biological_process', p_fdr_bh=0.0003326507764642874, study_items=set([u'ENSMUSG00000003873', u'ENSMUSG00000025647', u'ENSMUSG00000002083', u'ENSMUSG00000018983', u'ENSMUSG00000024521', u'ENSMUSG00000027490', u'ENSMUSG00000036986', u'ENSMUSG00000034457', u'ENSMUSG00000059552']), NS='BP', pop_items=set([u'ENSMUSG00000003873', u'ENSMUSG00000018983', u'ENSMUSG00000030793', u'ENSMUSG00000020267', u'ENSMUSG00000036986', u'ENSMUSG00000059552', u'ENSMUSG00000026510', u'ENSMUSG00000027663', u'ENSMUSG00000000552', u'ENSMUSG00000052676', u'ENSMUSG00000030888', u'ENSMUSG00000020719', u'ENSMUSG00000021285', u'ENSMUSG00000037492', u'ENSMUSG00000021690', u'ENSMUSG00000003068', u'ENSMUSG00000004637', u'ENSMUSG00000026278', u'ENSMUSG00000027016', u'ENSMUSG00000025647', u'ENSMUSG00000002083', u'ENSMUSG00000034457', u'ENSMUSG00000021481', u'ENSMUSG00000027490', u'ENSMUSG00000040463', u'ENSMUSG00000024521', u'ENSMUSG00000019851', u'ENSMUSG00000038967']), pop_n=13836, p_sm_bonferroni=0.03526098230521446, is_obsolete=False, GO='GO:0072332', name='intrinsic apoptotic signaling pathway by p53 class mediator', pop_count=28, alt_ids=[], level=5, depth=7, enrichment='e', Cluster='Transient Increase', geneid_set=set([u'ENSMUSG00000003873', u'ENSMUSG00000025647', u'ENSMUSG00000002083', u'ENSMUSG00000018983', u'ENSMUSG00000024521', u'ENSMUSG00000027490', u'ENSMUSG00000036986', u'ENSMUSG00000034457', u'ENSMUSG00000059552']), symbols=u'Bax Bbc3 E2f1 E2f2 Eda2r Pmaip1 Pml Shisa5 Trp53', symbol_set=set([u'Eda2r', u'Pmaip1', u'E2f2', u'E2f1', u'Trp53', u'Bax', u'Shisa5', u'Pml', u'Bbc3']), geneids='ENSMUSG00000003873 ENSMUSG00000025647 ENSMUSG00000002083 ENSMUSG00000018983 ENSMUSG00000024521 ENSMUSG00000027490 ENSMUSG00000036986 ENSMUSG00000034457 ENSMUSG00000059552', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=2, D1='AB', GO_name='intrinsic apoptotic signaling pathway by p53 class mediator'),
    Nt(p_uncorrected=9.131151172475021e-05, study_count=3, study_n=624, namespace='biological_process', p_fdr_bh=0.008090413532992342, study_items=set([u'ENSMUSG00000020897', u'ENSMUSG00000069910', u'ENSMUSG00000017716']), NS='BP', pop_items=set([u'ENSMUSG00000020897', u'ENSMUSG00000069910', u'ENSMUSG00000017716']), pop_n=13836, p_sm_bonferroni=1.0, is_obsolete=False, GO='GO:0031577', name='spindle checkpoint', pop_count=3, alt_ids=[], level=3, depth=7, enrichment='e', Cluster='Transient Increase', geneid_set=set([u'ENSMUSG00000020897', u'ENSMUSG00000069910', u'ENSMUSG00000017716']), symbols=u'Aurkb Birc5 Spdl1', symbol_set=set([u'Birc5', u'Aurkb', 'Spdl1']), geneids='ENSMUSG00000020897 ENSMUSG00000069910 ENSMUSG00000017716', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=8, D1='AB', GO_name='spindle checkpoint'),
    Nt(p_uncorrected=0.000161263723064093, study_count=8, study_n=624, namespace='biological_process', p_fdr_bh=0.012996312064596133, study_items=set([u'ENSMUSG00000052833', u'ENSMUSG00000017716', u'ENSMUSG00000020380', u'ENSMUSG00000023067', u'ENSMUSG00000030867', u'ENSMUSG00000062248', u'ENSMUSG00000037214', u'ENSMUSG00000019773']), NS='BP', pop_items=set([u'ENSMUSG00000028249', u'ENSMUSG00000023067', u'ENSMUSG00000018697', u'ENSMUSG00000029635', u'ENSMUSG00000025083', u'ENSMUSG00000029026', u'ENSMUSG00000022346', u'ENSMUSG00000020380', u'ENSMUSG00000030867', u'ENSMUSG00000039128', u'ENSMUSG00000020950', u'ENSMUSG00000025224', u'ENSMUSG00000020063', u'ENSMUSG00000075334', u'ENSMUSG00000038481', u'ENSMUSG00000019773', u'ENSMUSG00000020052', u'ENSMUSG00000021466', u'ENSMUSG00000033862', u'ENSMUSG00000031176', u'ENSMUSG00000024042', u'ENSMUSG00000040250', u'ENSMUSG00000052833', u'ENSMUSG00000031155', u'ENSMUSG00000034974', u'ENSMUSG00000018669', u'ENSMUSG00000035828', u'ENSMUSG00000036712', u'ENSMUSG00000037664', u'ENSMUSG00000017716', u'ENSMUSG00000012483', u'ENSMUSG00000033209', u'ENSMUSG00000062248', u'ENSMUSG00000024454', u'ENSMUSG00000022105', u'ENSMUSG00000037214']), pop_n=13836, p_sm_bonferroni=1.0, is_obsolete=False, GO='GO:0007346', name='regulation of mitotic cell cycle', pop_count=36, alt_ids=[], level=5, depth=5, enrichment='e', Cluster='Transient Increase', geneid_set=set([u'ENSMUSG00000052833', u'ENSMUSG00000023067', u'ENSMUSG00000020380', u'ENSMUSG00000017716', u'ENSMUSG00000030867', u'ENSMUSG00000062248', u'ENSMUSG00000037214', u'ENSMUSG00000019773']), symbols=u'Birc5 Cdkn1a Cks2 Fbxo5 Plk1 Rad50 Sae1 Thap1', symbol_set=set([u'Thap1', u'Plk1', u'Cks2', u'Birc5', u'Sae1', u'Fbxo5', u'Rad50', u'Cdkn1a']), geneids='ENSMUSG00000052833 ENSMUSG00000017716 ENSMUSG00000020380 ENSMUSG00000023067 ENSMUSG00000030867 ENSMUSG00000062248 ENSMUSG00000037214 ENSMUSG00000019773', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=175, D1='A', GO_name='regulation of mitotic cell cycle'),
    Nt(p_uncorrected=0.00018502014117979695, study_count=6, study_n=624, namespace='biological_process', p_fdr_bh=0.014524560409404683, study_items=set([u'ENSMUSG00000041238', u'ENSMUSG00000037474', u'ENSMUSG00000032113', u'ENSMUSG00000030867', u'ENSMUSG00000017146', u'ENSMUSG00000042489']), NS='BP', pop_items=set([u'ENSMUSG00000059981', u'ENSMUSG00000026749', u'ENSMUSG00000017291', u'ENSMUSG00000041238', u'ENSMUSG00000020235', u'ENSMUSG00000037474', u'ENSMUSG00000032113', u'ENSMUSG00000031820', u'ENSMUSG00000025878', u'ENSMUSG00000052139', u'ENSMUSG00000030867', u'ENSMUSG00000031201', u'ENSMUSG00000035486', u'ENSMUSG00000042489', u'ENSMUSG00000016528', u'ENSMUSG00000035390', u'ENSMUSG00000035032', u'ENSMUSG00000033102', u'ENSMUSG00000035234', u'ENSMUSG00000017146']), pop_n=13836, p_sm_bonferroni=1.0, is_obsolete=False, GO='GO:0031572', name='G2 DNA damage checkpoint', pop_count=20, alt_ids=[], level=5, depth=9, enrichment='e', Cluster='Transient Increase', geneid_set=set([u'ENSMUSG00000030867', u'ENSMUSG00000017146', u'ENSMUSG00000041238', u'ENSMUSG00000037474', u'ENSMUSG00000032113', u'ENSMUSG00000042489']), symbols=u'Brca1 Chek1 Clspn Dtl Plk1 Rbbp8', symbol_set=set([u'Brca1', u'Rbbp8', u'Clspn', u'Plk1', u'Dtl', u'Chek1']), geneids='ENSMUSG00000041238 ENSMUSG00000037474 ENSMUSG00000032113 ENSMUSG00000030867 ENSMUSG00000017146 ENSMUSG00000042489', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=1, D1='ABF', GO_name='G2 DNA damage checkpoint'),
    Nt(p_uncorrected='', study_count='', study_n='', namespace='', p_fdr_bh='', study_items='', NS='BP', pop_items='', pop_n='', p_sm_bonferroni='', is_obsolete='', GO='GO:0044699', name='', pop_count='', alt_ids='', level=1, depth=1, enrichment='', Cluster='', geneid_set='', symbols='', symbol_set='', geneids='', format_txt=1, hdr_idx=1, is_hdrgo=True, is_usrgo=False, hdr1usr01='*', dcnt=9858, D1='C', GO_name='single-organism process'),
    Nt(p_uncorrected=0.00012860653072037162, study_count=4, study_n=624, namespace='biological_process', p_fdr_bh=0.010589769276871469, study_items=set([u'ENSMUSG00000036086', u'ENSMUSG00000030528', u'ENSMUSG00000005370', u'ENSMUSG00000030254']), NS='BP', pop_items=set([u'ENSMUSG00000036086', u'ENSMUSG00000014850', u'ENSMUSG00000020697', u'ENSMUSG00000005370', u'ENSMUSG00000030254', u'ENSMUSG00000030528', u'ENSMUSG00000024151']), pop_n=13836, p_sm_bonferroni=1.0, is_obsolete=False, GO='GO:0045910', name='negative regulation of DNA recombination', pop_count=7, alt_ids=[], level=7, depth=8, enrichment='e', Cluster='Transient Increase', geneid_set=set([u'ENSMUSG00000036086', u'ENSMUSG00000030528', u'ENSMUSG00000005370', u'ENSMUSG00000030254']), symbols=u'Blm Msh6 Rad18 Zranb3', symbol_set=set([u'Blm', u'Rad18', u'Msh6', u'Zranb3']), geneids='ENSMUSG00000036086 ENSMUSG00000030528 ENSMUSG00000005370 ENSMUSG00000030254', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=18, D1='A', GO_name='negative regulation of DNA recombination'),
    Nt(p_uncorrected=2.000325641521453e-09, study_count=24, study_n=624, namespace='biological_process', p_fdr_bh=7.215936617783699e-07, study_items=set([u'ENSMUSG00000009035', u'ENSMUSG00000037321', u'ENSMUSG00000033033', u'ENSMUSG00000041879', u'ENSMUSG00000025134', u'ENSMUSG00000003779', u'ENSMUSG00000022142', u'ENSMUSG00000023015', u'ENSMUSG00000006930', u'ENSMUSG00000018167', u'ENSMUSG00000027115', u'ENSMUSG00000027699', u'ENSMUSG00000028693', u'ENSMUSG00000021371', u'ENSMUSG00000036992', u'ENSMUSG00000052798', u'ENSMUSG00000026088', u'ENSMUSG00000020290', u'ENSMUSG00000001855', u'ENSMUSG00000024097', u'ENSMUSG00000024737', u'ENSMUSG00000036678', u'ENSMUSG00000019874', u'ENSMUSG00000040034']), NS='BP', pop_items=set([u'ENSMUSG00000020198', u'ENSMUSG00000002015', u'ENSMUSG00000006005', u'ENSMUSG00000018379', u'ENSMUSG00000046027', u'ENSMUSG00000028437', u'ENSMUSG00000034402', u'ENSMUSG00000049866', u'ENSMUSG00000034951', u'ENSMUSG00000034958', u'ENSMUSG00000018770', u'ENSMUSG00000023923', u'ENSMUSG00000071253', u'ENSMUSG00000024045', u'ENSMUSG00000021567', u'ENSMUSG00000052459', u'ENSMUSG00000052456', u'ENSMUSG00000045100', u'ENSMUSG00000017288', u'ENSMUSG00000053453', u'ENSMUSG00000021764', u'ENSMUSG00000021339', u'ENSMUSG00000018196', u'ENSMUSG00000015243', u'ENSMUSG00000024197', u'ENSMUSG00000024191', u'ENSMUSG00000010392', u'ENSMUSG00000018999', u'ENSMUSG00000032806', u'ENSMUSG00000058569', u'ENSMUSG00000036760', u'ENSMUSG00000022807', u'ENSMUSG00000030662', u'ENSMUSG00000021589', u'ENSMUSG00000020219', u'ENSMUSG00000024990', u'ENSMUSG00000027533', u'ENSMUSG00000041654', u'ENSMUSG00000027534', u'ENSMUSG00000007207', u'ENSMUSG00000059363', u'ENSMUSG00000020986', u'ENSMUSG00000033685', u'ENSMUSG00000024535', u'ENSMUSG00000024530', u'ENSMUSG00000036565', u'ENSMUSG00000024533', u'ENSMUSG00000041236', u'ENSMUSG00000030884', u'ENSMUSG00000047767', u'ENSMUSG00000030082', u'ENSMUSG00000059742', u'ENSMUSG00000030247', u'ENSMUSG00000030245', u'ENSMUSG00000030534', u'ENSMUSG00000031337', u'ENSMUSG00000030249', u'ENSMUSG00000031333', u'ENSMUSG00000026111', u'ENSMUSG00000031934', u'ENSMUSG00000015112', u'ENSMUSG00000000197', u'ENSMUSG00000039781', u'ENSMUSG00000025872', u'ENSMUSG00000062078', u'ENSMUSG00000034145', u'ENSMUSG00000047789', u'ENSMUSG00000031753', u'ENSMUSG00000031202', u'ENSMUSG00000031755', u'ENSMUSG00000031209', u'ENSMUSG00000056296', u'ENSMUSG00000026576', u'ENSMUSG00000026577', u'ENSMUSG00000031684', u'ENSMUSG00000040740', u'ENSMUSG00000003226', u'ENSMUSG00000038267', u'ENSMUSG00000036814', u'ENSMUSG00000038260', u'ENSMUSG00000058975', u'ENSMUSG00000009647', u'ENSMUSG00000047187', u'ENSMUSG00000029175', u'ENSMUSG00000022272', u'ENSMUSG00000024259', u'ENSMUSG00000042590', u'ENSMUSG00000029757', u'ENSMUSG00000043463', u'ENSMUSG00000046562', u'ENSMUSG00000016252', u'ENSMUSG00000018459', u'ENSMUSG00000034320', u'ENSMUSG00000042604', u'ENSMUSG00000034893', u'ENSMUSG00000052533', u'ENSMUSG00000020189', u'ENSMUSG00000046032', u'ENSMUSG00000049922', u'ENSMUSG00000028532', u'ENSMUSG00000035722', u'ENSMUSG00000018740', u'ENSMUSG00000020740', u'ENSMUSG00000020745', u'ENSMUSG00000020744', u'ENSMUSG00000021577', u'ENSMUSG00000063698', u'ENSMUSG00000044982', u'ENSMUSG00000067825', u'ENSMUSG00000032017', u'ENSMUSG00000044528', u'ENSMUSG00000078676', u'ENSMUSG00000019906', u'ENSMUSG00000021771', u'ENSMUSG00000004931', u'ENSMUSG00000027438', u'ENSMUSG00000022905', u'ENSMUSG00000022200', u'ENSMUSG00000043885', u'ENSMUSG00000078812', u'ENSMUSG00000019838', u'ENSMUSG00000030102', u'ENSMUSG00000004843', u'ENSMUSG00000079657', u'ENSMUSG00000001260', u'ENSMUSG00000004849', u'ENSMUSG00000071014', u'ENSMUSG00000038462', u'ENSMUSG00000038467', u'ENSMUSG00000030109', u'ENSMUSG00000037685', u'ENSMUSG00000030650', u'ENSMUSG00000037681', u'ENSMUSG00000021591', u'ENSMUSG00000033272', u'ENSMUSG00000037771', u'ENSMUSG00000014077', u'ENSMUSG00000024983', u'ENSMUSG00000001082', u'ENSMUSG00000032902', u'ENSMUSG00000037190', u'ENSMUSG00000027291', u'ENSMUSG00000036570', u'ENSMUSG00000000131', u'ENSMUSG00000036578', u'ENSMUSG00000041736', u'ENSMUSG00000027340', u'ENSMUSG00000002105', u'ENSMUSG00000059734', u'ENSMUSG00000054934', u'ENSMUSG00000020704', u'ENSMUSG00000030500', u'ENSMUSG00000055407', u'ENSMUSG00000031913', u'ENSMUSG00000031924', u'ENSMUSG00000041828', u'ENSMUSG00000025867', u'ENSMUSG00000034152', u'ENSMUSG00000030340', u'ENSMUSG00000021375', u'ENSMUSG00000021371', u'ENSMUSG00000051256', u'ENSMUSG00000031327', u'ENSMUSG00000026568', u'ENSMUSG00000031691', u'ENSMUSG00000031696', u'ENSMUSG00000025366', u'ENSMUSG00000031109', u'ENSMUSG00000073678', u'ENSMUSG00000031105', u'ENSMUSG00000038257', u'ENSMUSG00000005949', u'ENSMUSG00000003072', u'ENSMUSG00000057378', u'ENSMUSG00000034088', u'ENSMUSG00000029924', u'ENSMUSG00000046822', u'ENSMUSG00000043673', u'ENSMUSG00000026819', u'ENSMUSG00000028744', u'ENSMUSG00000025607', u'ENSMUSG00000042616', u'ENSMUSG00000021114', u'ENSMUSG00000029430', u'ENSMUSG00000029434', u'ENSMUSG00000033386', u'ENSMUSG00000037997', u'ENSMUSG00000009292', u'ENSMUSG00000035594', u'ENSMUSG00000028419', u'ENSMUSG00000028412', u'ENSMUSG00000025134', u'ENSMUSG00000035681', u'ENSMUSG00000035933', u'ENSMUSG00000016024', u'ENSMUSG00000021606', u'ENSMUSG00000020734', u'ENSMUSG00000032314', u'ENSMUSG00000013160', u'ENSMUSG00000064329', u'ENSMUSG00000044465', u'ENSMUSG00000016756', u'ENSMUSG00000017756', u'ENSMUSG00000017754', u'ENSMUSG00000061306', u'ENSMUSG00000019935', u'ENSMUSG00000027429', u'ENSMUSG00000027423', u'ENSMUSG00000027422', u'ENSMUSG00000039908', u'ENSMUSG00000033998', u'ENSMUSG00000019804', u'ENSMUSG00000078713', u'ENSMUSG00000019802', u'ENSMUSG00000032264', u'ENSMUSG00000054720', u'ENSMUSG00000032269', u'ENSMUSG00000027519', u'ENSMUSG00000058740', u'ENSMUSG00000058743', u'ENSMUSG00000038412', u'ENSMUSG00000037762', u'ENSMUSG00000024737', u'ENSMUSG00000022808', u'ENSMUSG00000062797', u'ENSMUSG00000022800', u'ENSMUSG00000062421', u'ENSMUSG00000040188', u'ENSMUSG00000019066', u'ENSMUSG00000038520', u'ENSMUSG00000019790', u'ENSMUSG00000041695', u'ENSMUSG00000024957', u'ENSMUSG00000027282', u'ENSMUSG00000027287', u'ENSMUSG00000050732', u'ENSMUSG00000079020', u'ENSMUSG00000030647', u'ENSMUSG00000051735', u'ENSMUSG00000041216', u'ENSMUSG00000030519', u'ENSMUSG00000031596', u'ENSMUSG00000037234', u'ENSMUSG00000037344', u'ENSMUSG00000037434', u'ENSMUSG00000037341', u'ENSMUSG00000031916', u'ENSMUSG00000027994', u'ENSMUSG00000027775', u'ENSMUSG00000030428', u'ENSMUSG00000026177', u'ENSMUSG00000022100', u'ENSMUSG00000025858', u'ENSMUSG00000006576', u'ENSMUSG00000031775', u'ENSMUSG00000040164', u'ENSMUSG00000026553', u'ENSMUSG00000038740', u'ENSMUSG00000066232', u'ENSMUSG00000063873', u'ENSMUSG00000031176', u'ENSMUSG00000035325', u'ENSMUSG00000029608', u'ENSMUSG00000063895', u'ENSMUSG00000026959', u'ENSMUSG00000017765', u'ENSMUSG00000049562', u'ENSMUSG00000022257', u'ENSMUSG00000039347', u'ENSMUSG00000025920', u'ENSMUSG00000066151', u'ENSMUSG00000066152', u'ENSMUSG00000026824', u'ENSMUSG00000021124', u'ENSMUSG00000021127', u'ENSMUSG00000057388', u'ENSMUSG00000020432', u'ENSMUSG00000020435', u'ENSMUSG00000020436', u'ENSMUSG00000028648', u'ENSMUSG00000024065', u'ENSMUSG00000028645', u'ENSMUSG00000034187', u'ENSMUSG00000005881', u'ENSMUSG00000002043', u'ENSMUSG00000034854', u'ENSMUSG00000068264', u'ENSMUSG00000017978', u'ENSMUSG00000066150', u'ENSMUSG00000016346', u'ENSMUSG00000074030', u'ENSMUSG00000020723', u'ENSMUSG00000069806', u'ENSMUSG00000009378', u'ENSMUSG00000042312', u'ENSMUSG00000045053', u'ENSMUSG00000053395', u'ENSMUSG00000020651', u'ENSMUSG00000020650', u'ENSMUSG00000061315', u'ENSMUSG00000017740', u'ENSMUSG00000061536', u'ENSMUSG00000044894', u'ENSMUSG00000032101', u'ENSMUSG00000032458', u'ENSMUSG00000060279', u'ENSMUSG00000053025', u'ENSMUSG00000001240', u'ENSMUSG00000045302', u'ENSMUSG00000032127', u'ENSMUSG00000044252', u'ENSMUSG00000017412', u'ENSMUSG00000024099', u'ENSMUSG00000001440', u'ENSMUSG00000024097', u'ENSMUSG00000024096', u'ENSMUSG00000054423', u'ENSMUSG00000020088', u'ENSMUSG00000067150', u'ENSMUSG00000024941', u'ENSMUSG00000019785', u'ENSMUSG00000031532', u'ENSMUSG00000030982', u'ENSMUSG00000060216', u'ENSMUSG00000030987', u'ENSMUSG00000027162', u'ENSMUSG00000027163', u'ENSMUSG00000027166', u'ENSMUSG00000024891', u'ENSMUSG00000051726', u'ENSMUSG00000024897', u'ENSMUSG00000020882', u'ENSMUSG00000027365', u'ENSMUSG00000040373', u'ENSMUSG00000033720', u'ENSMUSG00000003872', u'ENSMUSG00000026499', u'ENSMUSG00000030298', u'ENSMUSG00000043614', u'ENSMUSG00000020865', u'ENSMUSG00000037242', u'ENSMUSG00000027706', u'ENSMUSG00000037408', u'ENSMUSG00000004056', u'ENSMUSG00000000374', u'ENSMUSG00000031904', u'ENSMUSG00000019478', u'ENSMUSG00000015023', u'ENSMUSG00000006567', u'ENSMUSG00000021357', u'ENSMUSG00000003585', u'ENSMUSG00000027012', u'ENSMUSG00000027010', u'ENSMUSG00000031343', u'ENSMUSG00000027015', u'ENSMUSG00000006611', u'ENSMUSG00000026389', u'ENSMUSG00000022003', u'ENSMUSG00000026385', u'ENSMUSG00000025935', u'ENSMUSG00000026944', u'ENSMUSG00000029632', u'ENSMUSG00000003617', u'ENSMUSG00000029125', u'ENSMUSG00000068874', u'ENSMUSG00000040441', u'ENSMUSG00000075600', u'ENSMUSG00000020402', u'ENSMUSG00000029705', u'ENSMUSG00000022538', u'ENSMUSG00000028655', u'ENSMUSG00000089774', u'ENSMUSG00000048796', u'ENSMUSG00000034190', u'ENSMUSG00000060882', u'ENSMUSG00000029415', u'ENSMUSG00000029416', u'ENSMUSG00000002059', u'ENSMUSG00000002058', u'ENSMUSG00000078441', u'ENSMUSG00000002052', u'ENSMUSG00000035919', u'ENSMUSG00000038291', u'ENSMUSG00000046480', u'ENSMUSG00000028096', u'ENSMUSG00000013275', u'ENSMUSG00000021629', u'ENSMUSG00000004902', u'ENSMUSG00000034826', u'ENSMUSG00000001436', u'ENSMUSG00000024663', u'ENSMUSG00000028385', u'ENSMUSG00000017774', u'ENSMUSG00000036291', u'ENSMUSG00000024392', u'ENSMUSG00000036298', u'ENSMUSG00000063796', u'ENSMUSG00000032118', u'ENSMUSG00000032449', u'ENSMUSG00000032112', u'ENSMUSG00000002985', u'ENSMUSG00000002984', u'ENSMUSG00000019861', u'ENSMUSG00000021432', u'ENSMUSG00000024150', u'ENSMUSG00000024403', u'ENSMUSG00000019868', u'ENSMUSG00000027575', u'ENSMUSG00000022822', u'ENSMUSG00000022829', u'ENSMUSG00000032842', u'ENSMUSG00000054099', u'ENSMUSG00000054414', u'ENSMUSG00000022199', u'ENSMUSG00000000743', u'ENSMUSG00000008036', u'ENSMUSG00000032939', u'ENSMUSG00000026718', u'ENSMUSG00000056185', u'ENSMUSG00000036435', u'ENSMUSG00000054894', u'ENSMUSG00000030754', u'ENSMUSG00000074909', u'ENSMUSG00000024378', u'ENSMUSG00000030629', u'ENSMUSG00000020386', u'ENSMUSG00000001986', u'ENSMUSG00000062683', u'ENSMUSG00000004110', u'ENSMUSG00000018800', u'ENSMUSG00000020873', u'ENSMUSG00000027397', u'ENSMUSG00000020876', u'ENSMUSG00000037257', u'ENSMUSG00000031574', u'ENSMUSG00000000560', u'ENSMUSG00000092083', u'ENSMUSG00000005510', u'ENSMUSG00000027716', u'ENSMUSG00000026159', u'ENSMUSG00000031974', u'ENSMUSG00000022758', u'ENSMUSG00000040569', u'ENSMUSG00000031979', u'ENSMUSG00000030172', u'ENSMUSG00000031488', u'ENSMUSG00000027953', u'ENSMUSG00000027950', u'ENSMUSG00000027957', u'ENSMUSG00000030376', u'ENSMUSG00000005357', u'ENSMUSG00000006519', u'ENSMUSG00000031378', u'ENSMUSG00000031808', u'ENSMUSG00000030287', u'ENSMUSG00000041945', u'ENSMUSG00000023017', u'ENSMUSG00000023015', u'ENSMUSG00000040414', u'ENSMUSG00000022841', u'ENSMUSG00000022013', u'ENSMUSG00000022012', u'ENSMUSG00000000811', u'ENSMUSG00000070939', u'ENSMUSG00000031156', u'ENSMUSG00000031158', u'ENSMUSG00000020524', u'ENSMUSG00000056832', u'ENSMUSG00000047037', u'ENSMUSG00000028758', u'ENSMUSG00000020411', u'ENSMUSG00000003731', u'ENSMUSG00000025892', u'ENSMUSG00000046329', u'ENSMUSG00000029392', u'ENSMUSG00000074582', u'ENSMUSG00000026878', u'ENSMUSG00000052395', u'ENSMUSG00000061244', u'ENSMUSG00000029408', u'ENSMUSG00000029401', u'ENSMUSG00000029407', u'ENSMUSG00000029406', u'ENSMUSG00000029405', u'ENSMUSG00000046079', u'ENSMUSG00000048439', u'ENSMUSG00000034274', u'ENSMUSG00000042797', u'ENSMUSG00000035674', u'ENSMUSG00000006641', u'ENSMUSG00000066595', u'ENSMUSG00000021730', u'ENSMUSG00000021733', u'ENSMUSG00000028049', u'ENSMUSG00000064370', u'ENSMUSG00000025161', u'ENSMUSG00000049969', u'ENSMUSG00000032051', u'ENSMUSG00000020671', u'ENSMUSG00000032725', u'ENSMUSG00000024384', u'ENSMUSG00000017781', u'ENSMUSG00000018470', u'ENSMUSG00000019302', u'ENSMUSG00000032435', u'ENSMUSG00000032122', u'ENSMUSG00000019874', u'ENSMUSG00000044786', u'ENSMUSG00000079614', u'ENSMUSG00000024411', u'ENSMUSG00000020261', u'ENSMUSG00000002957', u'ENSMUSG00000032548', u'ENSMUSG00000032549', u'ENSMUSG00000026705', u'ENSMUSG00000033147', u'ENSMUSG00000055371', u'ENSMUSG00000030761', u'ENSMUSG00000033419', u'ENSMUSG00000001998', u'ENSMUSG00000037646', u'ENSMUSG00000037089', u'ENSMUSG00000041779', u'ENSMUSG00000000171', u'ENSMUSG00000041771', u'ENSMUSG00000060992', u'ENSMUSG00000038602', u'ENSMUSG00000033981', u'ENSMUSG00000014444', u'ENSMUSG00000021852', u'ENSMUSG00000041797', u'ENSMUSG00000020843', u'ENSMUSG00000005674', u'ENSMUSG00000061808', u'ENSMUSG00000020283', u'ENSMUSG00000041319', u'ENSMUSG00000023267', u'ENSMUSG00000018900', u'ENSMUSG00000000399', u'ENSMUSG00000018909', u'ENSMUSG00000023460', u'ENSMUSG00000055026', u'ENSMUSG00000000958', u'ENSMUSG00000004655', u'ENSMUSG00000031367', u'ENSMUSG00000031813', u'ENSMUSG00000003452', u'ENSMUSG00000026032', u'ENSMUSG00000041313', u'ENSMUSG00000031633', u'ENSMUSG00000031144', u'ENSMUSG00000031143', u'ENSMUSG00000029359', u'ENSMUSG00000031149', u'ENSMUSG00000038319', u'ENSMUSG00000026455', u'ENSMUSG00000040048', u'ENSMUSG00000049550', u'ENSMUSG00000062110', u'ENSMUSG00000011658', u'ENSMUSG00000035242', u'ENSMUSG00000038366', u'ENSMUSG00000020464', u'ENSMUSG00000057193', u'ENSMUSG00000028879', u'ENSMUSG00000022350', u'ENSMUSG00000022354', u'ENSMUSG00000025885', u'ENSMUSG00000034602', u'ENSMUSG00000069072', u'ENSMUSG00000020590', u'ENSMUSG00000025393', u'ENSMUSG00000032602', u'ENSMUSG00000009013', u'ENSMUSG00000061273', u'ENSMUSG00000029470', u'ENSMUSG00000025371', u'ENSMUSG00000023861', u'ENSMUSG00000057069', u'ENSMUSG00000034867', u'ENSMUSG00000035392', u'ENSMUSG00000034462', u'ENSMUSG00000021700', u'ENSMUSG00000028051', u'ENSMUSG00000064367', u'ENSMUSG00000063406', u'ENSMUSG00000064360', u'ENSMUSG00000064363', u'ENSMUSG00000045404', u'ENSMUSG00000028293', u'ENSMUSG00000064368', u'ENSMUSG00000035805', u'ENSMUSG00000028452', u'ENSMUSG00000032733', u'ENSMUSG00000032042', u'ENSMUSG00000018481', u'ENSMUSG00000039016', u'ENSMUSG00000064210', u'ENSMUSG00000045246', u'ENSMUSG00000064181', u'ENSMUSG00000053293', u'ENSMUSG00000053291', u'ENSMUSG00000032422', u'ENSMUSG00000020111', u'ENSMUSG00000075316', u'ENSMUSG00000024287', u'ENSMUSG00000062785', u'ENSMUSG00000039838', u'ENSMUSG00000002949', u'ENSMUSG00000032554', u'ENSMUSG00000036636', u'ENSMUSG00000054364', u'ENSMUSG00000020078', u'ENSMUSG00000024772', u'ENSMUSG00000019518', u'ENSMUSG00000019194', u'ENSMUSG00000024357', u'ENSMUSG00000018661', u'ENSMUSG00000024604', u'ENSMUSG00000037656', u'ENSMUSG00000073639', u'ENSMUSG00000037098', u'ENSMUSG00000071172', u'ENSMUSG00000014158', u'ENSMUSG00000018861', u'ENSMUSG00000024597', u'ENSMUSG00000004394', u'ENSMUSG00000058076', u'ENSMUSG00000027809', u'ENSMUSG00000027808', u'ENSMUSG00000027804', u'ENSMUSG00000020290', u'ENSMUSG00000005069', u'ENSMUSG00000021619', u'ENSMUSG00000023259', u'ENSMUSG00000037475', u'ENSMUSG00000027737', u'ENSMUSG00000037386', u'ENSMUSG00000041891', u'ENSMUSG00000031950', u'ENSMUSG00000041329', u'ENSMUSG00000040543', u'ENSMUSG00000027739', u'ENSMUSG00000040236', u'ENSMUSG00000010803', u'ENSMUSG00000015013', u'ENSMUSG00000061904', u'ENSMUSG00000004626', u'ENSMUSG00000026198', u'ENSMUSG00000026280', u'ENSMUSG00000030741', u'ENSMUSG00000030805', u'ENSMUSG00000030806', u'ENSMUSG00000026289', u'ENSMUSG00000051111', u'ENSMUSG00000023030', u'ENSMUSG00000023032', u'ENSMUSG00000023033', u'ENSMUSG00000026514', u'ENSMUSG00000066278', u'ENSMUSG00000019734', u'ENSMUSG00000026519', u'ENSMUSG00000025968', u'ENSMUSG00000000838', u'ENSMUSG00000022295', u'ENSMUSG00000022299', u'ENSMUSG00000051331', u'ENSMUSG00000031600', u'ENSMUSG00000025816', u'ENSMUSG00000029088', u'ENSMUSG00000071424', u'ENSMUSG00000031731', u'ENSMUSG00000026463', u'ENSMUSG00000025428', u'ENSMUSG00000022722', u'ENSMUSG00000003623', u'ENSMUSG00000019731', u'ENSMUSG00000060671', u'ENSMUSG00000031834', u'ENSMUSG00000059534', u'ENSMUSG00000020476', u'ENSMUSG00000003153', u'ENSMUSG00000022342', u'ENSMUSG00000028847', u'ENSMUSG00000029468', u'ENSMUSG00000029467', u'ENSMUSG00000039156', u'ENSMUSG00000029462', u'ENSMUSG00000025340', u'ENSMUSG00000026853', u'ENSMUSG00000034473', u'ENSMUSG00000042682', u'ENSMUSG00000028607', u'ENSMUSG00000025986', u'ENSMUSG00000028603', u'ENSMUSG00000034258', u'ENSMUSG00000028609', u'ENSMUSG00000021072', u'ENSMUSG00000021079', u'ENSMUSG00000029518', u'ENSMUSG00000002395', u'ENSMUSG00000028020', u'ENSMUSG00000042195', u'ENSMUSG00000064351', u'ENSMUSG00000064354', u'ENSMUSG00000064356', u'ENSMUSG00000064357', u'ENSMUSG00000025189', u'ENSMUSG00000028931', u'ENSMUSG00000018677', u'ENSMUSG00000018672', u'ENSMUSG00000036026', u'ENSMUSG00000028330', u'ENSMUSG00000001576', u'ENSMUSG00000032096', u'ENSMUSG00000016637', u'ENSMUSG00000045503', u'ENSMUSG00000042229', u'ENSMUSG00000032382', u'ENSMUSG00000002718', u'ENSMUSG00000053519', u'ENSMUSG00000042359', u'ENSMUSG00000020100', u'ENSMUSG00000032412', u'ENSMUSG00000018585', u'ENSMUSG00000018583', u'ENSMUSG00000018589', u'ENSMUSG00000036391', u'ENSMUSG00000000711', u'ENSMUSG00000058248', u'ENSMUSG00000019210', u'ENSMUSG00000044749', u'ENSMUSG00000032890', u'ENSMUSG00000032892', u'ENSMUSG00000062580', u'ENSMUSG00000002372', u'ENSMUSG00000002379', u'ENSMUSG00000001376', u'ENSMUSG00000051853', u'ENSMUSG00000026726', u'ENSMUSG00000033161', u'ENSMUSG00000024900', u'ENSMUSG00000024613', u'ENSMUSG00000024581', u'ENSMUSG00000024583', u'ENSMUSG00000049313', u'ENSMUSG00000026614', u'ENSMUSG00000039714', u'ENSMUSG00000020829', u'ENSMUSG00000020823', u'ENSMUSG00000030704', u'ENSMUSG00000000538', u'ENSMUSG00000030495', u'ENSMUSG00000041881', u'ENSMUSG00000019432', u'ENSMUSG00000063354', u'ENSMUSG00000033615', u'ENSMUSG00000014550', u'ENSMUSG00000039623', u'ENSMUSG00000040594', u'ENSMUSG00000040848', u'ENSMUSG00000063145', u'ENSMUSG00000057060', u'ENSMUSG00000005656', u'ENSMUSG00000040938', u'ENSMUSG00000040447', u'ENSMUSG00000019726', u'ENSMUSG00000040118', u'ENSMUSG00000038717', u'ENSMUSG00000003438', u'ENSMUSG00000040896', u'ENSMUSG00000021248', u'ENSMUSG00000030237', u'ENSMUSG00000025979', u'ENSMUSG00000030235', u'ENSMUSG00000021240', u'ENSMUSG00000051329', u'ENSMUSG00000029073', u'ENSMUSG00000031617', u'ENSMUSG00000049686', u'ENSMUSG00000045665', u'ENSMUSG00000026470', u'ENSMUSG00000022756', u'ENSMUSG00000039530', u'ENSMUSG00000031059', u'ENSMUSG00000020440', u'ENSMUSG00000029212', u'ENSMUSG00000029211', u'ENSMUSG00000049624', u'ENSMUSG00000025572', u'ENSMUSG00000034667', u'ENSMUSG00000028854', u'ENSMUSG00000007653', u'ENSMUSG00000021660', u'ENSMUSG00000009035', u'ENSMUSG00000021669', u'ENSMUSG00000022404', u'ENSMUSG00000025351', u'ENSMUSG00000025354', u'ENSMUSG00000028614', u'ENSMUSG00000025993', u'ENSMUSG00000036943', u'ENSMUSG00000034247', u'ENSMUSG00000034714', u'ENSMUSG00000021062', u'ENSMUSG00000028581', u'ENSMUSG00000061455', u'ENSMUSG00000016319', u'ENSMUSG00000034484', u'ENSMUSG00000025759', u'ENSMUSG00000020620', u'ENSMUSG00000020628', u'ENSMUSG00000028033', u'ENSMUSG00000064345', u'ENSMUSG00000064341', u'ENSMUSG00000013698', u'ENSMUSG00000052584', u'ENSMUSG00000028923', u'ENSMUSG00000031342', u'ENSMUSG00000050856', u'ENSMUSG00000002416', u'ENSMUSG00000079316', u'ENSMUSG00000021474', u'ENSMUSG00000024112', u'ENSMUSG00000067851', u'ENSMUSG00000010066', u'ENSMUSG00000037916', u'ENSMUSG00000032402', u'ENSMUSG00000020132', u'ENSMUSG00000020056', u'ENSMUSG00000015575', u'ENSMUSG00000033379', u'ENSMUSG00000017664', u'ENSMUSG00000021983', u'ENSMUSG00000002365', u'ENSMUSG00000032570', u'ENSMUSG00000021877', u'ENSMUSG00000024758', u'ENSMUSG00000040322', u'ENSMUSG00000042364', u'ENSMUSG00000010064', u'ENSMUSG00000019087', u'ENSMUSG00000019080', u'ENSMUSG00000019082', u'ENSMUSG00000050192', u'ENSMUSG00000033579', u'ENSMUSG00000024339', u'ENSMUSG00000010663', u'ENSMUSG00000033577', u'ENSMUSG00000001729', u'ENSMUSG00000010110', u'ENSMUSG00000024935', u'ENSMUSG00000020903', u'ENSMUSG00000023236', u'ENSMUSG00000037455', u'ENSMUSG00000063882', u'ENSMUSG00000038496', u'ENSMUSG00000038497', u'ENSMUSG00000015759', u'ENSMUSG00000039637', u'ENSMUSG00000031997', u'ENSMUSG00000031993', u'ENSMUSG00000055013', u'ENSMUSG00000031441', u'ENSMUSG00000040584', u'ENSMUSG00000027822', u'ENSMUSG00000027827', u'ENSMUSG00000026260', u'ENSMUSG00000031539', u'ENSMUSG00000019715', u'ENSMUSG00000031840', u'ENSMUSG00000004285', u'ENSMUSG00000026065', u'ENSMUSG00000021278', u'ENSMUSG00000062169', u'ENSMUSG00000031667', u'ENSMUSG00000026088', u'ENSMUSG00000022180', u'ENSMUSG00000056870', u'ENSMUSG00000039529', u'ENSMUSG00000038039', u'ENSMUSG00000052026', u'ENSMUSG00000003378', u'ENSMUSG00000020454', u'ENSMUSG00000022560', u'ENSMUSG00000009731', u'ENSMUSG00000003779', u'ENSMUSG00000047459', u'ENSMUSG00000022365', u'ENSMUSG00000034659', u'ENSMUSG00000015968', u'ENSMUSG00000012535', u'ENSMUSG00000034656', u'ENSMUSG00000013593', u'ENSMUSG00000023830', u'ENSMUSG00000025324', u'ENSMUSG00000024247', u'ENSMUSG00000042759', u'ENSMUSG00000048677', u'ENSMUSG00000025212', u'ENSMUSG00000034723', u'ENSMUSG00000020585', u'ENSMUSG00000029535', u'ENSMUSG00000028552', u'ENSMUSG00000028550', u'ENSMUSG00000052688', u'ENSMUSG00000025036', u'ENSMUSG00000025035', u'ENSMUSG00000028559', u'ENSMUSG00000028955', u'ENSMUSG00000062949', u'ENSMUSG00000024104', u'ENSMUSG00000024101', u'ENSMUSG00000033965', u'ENSMUSG00000006273', u'ENSMUSG00000042246', u'ENSMUSG00000039194', u'ENSMUSG00000020128', u'ENSMUSG00000002771', u'ENSMUSG00000060090', u'ENSMUSG00000002778', u'ENSMUSG00000070304', u'ENSMUSG00000020022', u'ENSMUSG00000014402', u'ENSMUSG00000032180', u'ENSMUSG00000044768', u'ENSMUSG00000017679', u'ENSMUSG00000021991', u'ENSMUSG00000019894', u'ENSMUSG00000032504', u'ENSMUSG00000024038', u'ENSMUSG00000001150', u'ENSMUSG00000024030', u'ENSMUSG00000024036', u'ENSMUSG00000027699', u'ENSMUSG00000032988', u'ENSMUSG00000002319', u'ENSMUSG00000033106', u'ENSMUSG00000024327', u'ENSMUSG00000037606', u'ENSMUSG00000079436', u'ENSMUSG00000000605', u'ENSMUSG00000020331', u'ENSMUSG00000020334', u'ENSMUSG00000019146', u'ENSMUSG00000033033', u'ENSMUSG00000024818', u'ENSMUSG00000010122', u'ENSMUSG00000033039', u'ENSMUSG00000022548', u'ENSMUSG00000055334', u'ENSMUSG00000024924', u'ENSMUSG00000079055', u'ENSMUSG00000079056', u'ENSMUSG00000030720', u'ENSMUSG00000030727', u'ENSMUSG00000038486', u'ENSMUSG00000015747', u'ENSMUSG00000051497', u'ENSMUSG00000034216', u'ENSMUSG00000059336', u'ENSMUSG00000030452', u'ENSMUSG00000030450', u'ENSMUSG00000031988', u'ENSMUSG00000030108', u'ENSMUSG00000040693', u'ENSMUSG00000007097', u'ENSMUSG00000027673', u'ENSMUSG00000020805', u'ENSMUSG00000020806', u'ENSMUSG00000070639', u'ENSMUSG00000031529', u'ENSMUSG00000040667', u'ENSMUSG00000027076', u'ENSMUSG00000003411', u'ENSMUSG00000063172', u'ENSMUSG00000020102', u'ENSMUSG00000033365', u'ENSMUSG00000021265', u'ENSMUSG00000029054', u'ENSMUSG00000036882', u'ENSMUSG00000031672', u'ENSMUSG00000039105', u'ENSMUSG00000004610', u'ENSMUSG00000031297', u'ENSMUSG00000026411', u'ENSMUSG00000038023', u'ENSMUSG00000022774', u'ENSMUSG00000038026', u'ENSMUSG00000038024', u'ENSMUSG00000007670', u'ENSMUSG00000056268', u'ENSMUSG00000031075', u'ENSMUSG00000026895', u'ENSMUSG00000009907', u'ENSMUSG00000039463', u'ENSMUSG00000021687', u'ENSMUSG00000021686', u'ENSMUSG00000022427', u'ENSMUSG00000022551', u'ENSMUSG00000025204', u'ENSMUSG00000028631', u'ENSMUSG00000035351', u'ENSMUSG00000066705', u'ENSMUSG00000009470', u'ENSMUSG00000039050', u'ENSMUSG00000089911', u'ENSMUSG00000025868', u'ENSMUSG00000046402', u'ENSMUSG00000028542', u'ENSMUSG00000043301', u'ENSMUSG00000074575', u'ENSMUSG00000034353', u'ENSMUSG00000028127', u'ENSMUSG00000028125', u'ENSMUSG00000052566', u'ENSMUSG00000020484', u'ENSMUSG00000034445', u'ENSMUSG00000016427', u'ENSMUSG00000020483', u'ENSMUSG00000042529', u'ENSMUSG00000033916', u'ENSMUSG00000008892', u'ENSMUSG00000024130', u'ENSMUSG00000028158', u'ENSMUSG00000018733', u'ENSMUSG00000018736', u'ENSMUSG00000035770', u'ENSMUSG00000037933', u'ENSMUSG00000020153', u'ENSMUSG00000053897', u'ENSMUSG00000032193', u'ENSMUSG00000002908', u'ENSMUSG00000036078', u'ENSMUSG00000032519', u'ENSMUSG00000023169', u'ENSMUSG00000032511', u'ENSMUSG00000002346', u'ENSMUSG00000032513', u'ENSMUSG00000036678', u'ENSMUSG00000021520', u'ENSMUSG00000024797', u'ENSMUSG00000024792', u'ENSMUSG00000019558', u'ENSMUSG00000024480', u'ENSMUSG00000024487', u'ENSMUSG00000024646', u'ENSMUSG00000079111', u'ENSMUSG00000022956', u'ENSMUSG00000024645', u'ENSMUSG00000037610', u'ENSMUSG00000024319', u'ENSMUSG00000027115', u'ENSMUSG00000019173', u'ENSMUSG00000048249', u'ENSMUSG00000033007', u'ENSMUSG00000030737', u'ENSMUSG00000014606', u'ENSMUSG00000000792', u'ENSMUSG00000037321', u'ENSMUSG00000037325', u'ENSMUSG00000055078', u'ENSMUSG00000050556', u'ENSMUSG00000041879', u'ENSMUSG00000020817', u'ENSMUSG00000027663', u'ENSMUSG00000020810', u'ENSMUSG00000040907', u'ENSMUSG00000026797', u'ENSMUSG00000026792', u'ENSMUSG00000026791', u'ENSMUSG00000030592', u'ENSMUSG00000051154', u'ENSMUSG00000062444', u'ENSMUSG00000049299', u'ENSMUSG00000031862', u'ENSMUSG00000031865', u'ENSMUSG00000063142', u'ENSMUSG00000030209', u'ENSMUSG00000059149', u'ENSMUSG00000048076', u'ENSMUSG00000015342', u'ENSMUSG00000039509', u'ENSMUSG00000015340', u'ENSMUSG00000024592', u'ENSMUSG00000022094', u'ENSMUSG00000055782', u'ENSMUSG00000040875', u'ENSMUSG00000060961', u'ENSMUSG00000056073', u'ENSMUSG00000040010', u'ENSMUSG00000022765', u'ENSMUSG00000022763', u'ENSMUSG00000031242', u'ENSMUSG00000021326', u'ENSMUSG00000005802', u'ENSMUSG00000056258', u'ENSMUSG00000003352', u'ENSMUSG00000036989', u'ENSMUSG00000040701', u'ENSMUSG00000026339', u'ENSMUSG00000029822', u'ENSMUSG00000034109', u'ENSMUSG00000009687', u'ENSMUSG00000035189', u'ENSMUSG00000029221', u'ENSMUSG00000033676', u'ENSMUSG00000011884', u'ENSMUSG00000025235', u'ENSMUSG00000046230', u'ENSMUSG00000021038', u'ENSMUSG00000025781', u'ENSMUSG00000048497', u'ENSMUSG00000053317', u'ENSMUSG00000032741', u'ENSMUSG00000028572', u'ENSMUSG00000025651', u'ENSMUSG00000009863', u'ENSMUSG00000042644', u'ENSMUSG00000028970', u'ENSMUSG00000028973', u'ENSMUSG00000028975', u'ENSMUSG00000028976', u'ENSMUSG00000050822', u'ENSMUSG00000064068', u'ENSMUSG00000006057', u'ENSMUSG00000070570', u'ENSMUSG00000006058', u'ENSMUSG00000028373', u'ENSMUSG00000024121', u'ENSMUSG00000024120', u'ENSMUSG00000052798', u'ENSMUSG00000064267', u'ENSMUSG00000018707', u'ENSMUSG00000052310', u'ENSMUSG00000020149', u'ENSMUSG00000020142', u'ENSMUSG00000024012', u'ENSMUSG00000020003', u'ENSMUSG00000018566', u'ENSMUSG00000018567', u'ENSMUSG00000044708', u'ENSMUSG00000036196', u'ENSMUSG00000044367', u'ENSMUSG00000019943', u'ENSMUSG00000061171', u'ENSMUSG00000036667', u'ENSMUSG00000014294', u'ENSMUSG00000001138', u'ENSMUSG00000044147', u'ENSMUSG00000024787', u'ENSMUSG00000058441', u'ENSMUSG00000073988', u'ENSMUSG00000022949', u'ENSMUSG00000037624', u'ENSMUSG00000022946', u'ENSMUSG00000027787', u'ENSMUSG00000027782', u'ENSMUSG00000033793', u'ENSMUSG00000032839', u'ENSMUSG00000024875', u'ENSMUSG00000059003', u'ENSMUSG00000024870', u'ENSMUSG00000024873', u'ENSMUSG00000001918', u'ENSMUSG00000033124', u'ENSMUSG00000001827', u'ENSMUSG00000021929', u'ENSMUSG00000024270', u'ENSMUSG00000050144', u'ENSMUSG00000033128', u'ENSMUSG00000020955', u'ENSMUSG00000020952', u'ENSMUSG00000041609', u'ENSMUSG00000062526', u'ENSMUSG00000054808', u'ENSMUSG00000059316', u'ENSMUSG00000027879', u'ENSMUSG00000026781', u'ENSMUSG00000030058', u'ENSMUSG00000015653', u'ENSMUSG00000027099', u'ENSMUSG00000054702', u'ENSMUSG00000049281', u'ENSMUSG00000027896', u'ENSMUSG00000027894', u'ENSMUSG00000027895', u'ENSMUSG00000027577', u'ENSMUSG00000004567', u'ENSMUSG00000055681', u'ENSMUSG00000022159', u'ENSMUSG00000031479', u'ENSMUSG00000022150', u'ENSMUSG00000004364', u'ENSMUSG00000040022', u'ENSMUSG00000026433', u'ENSMUSG00000040029', u'ENSMUSG00000030302', u'ENSMUSG00000034111', u'ENSMUSG00000030301', u'ENSMUSG00000030307', u'ENSMUSG00000030304', u'ENSMUSG00000038102', u'ENSMUSG00000036992', u'ENSMUSG00000029146', u'ENSMUSG00000063801', u'ENSMUSG00000022338', u'ENSMUSG00000025793', u'ENSMUSG00000025792', u'ENSMUSG00000025790', u'ENSMUSG00000026927', u'ENSMUSG00000005907', u'ENSMUSG00000003033', u'ENSMUSG00000003037', u'ENSMUSG00000020792', u'ENSMUSG00000028789', u'ENSMUSG00000034593', u'ENSMUSG00000034591', u'ENSMUSG00000025221', u'ENSMUSG00000040430', u'ENSMUSG00000034203', u'ENSMUSG00000038212', u'ENSMUSG00000013495', u'ENSMUSG00000029763', u'ENSMUSG00000077450', u'ENSMUSG00000047959', u'ENSMUSG00000032757', u'ENSMUSG00000032754', u'ENSMUSG00000029560', u'ENSMUSG00000039048', u'ENSMUSG00000025006', u'ENSMUSG00000034973', u'ENSMUSG00000004980', u'ENSMUSG00000062995', u'ENSMUSG00000045973', u'ENSMUSG00000028962', u'ENSMUSG00000033938', u'ENSMUSG00000006024', u'ENSMUSG00000020175', u'ENSMUSG00000008301', u'ENSMUSG00000028367', u'ENSMUSG00000028007', u'ENSMUSG00000042078', u'ENSMUSG00000063550', u'ENSMUSG00000035152', u'ENSMUSG00000042476', u'ENSMUSG00000032353', u'ENSMUSG00000009090', u'ENSMUSG00000050963', u'ENSMUSG00000002741', u'ENSMUSG00000074345', u'ENSMUSG00000021541', u'ENSMUSG00000024069', u'ENSMUSG00000068747', u'ENSMUSG00000042271', u'ENSMUSG00000036057', u'ENSMUSG00000019971', u'ENSMUSG00000063646', u'ENSMUSG00000021831', u'ENSMUSG00000064105', u'ENSMUSG00000048827', u'ENSMUSG00000006930', u'ENSMUSG00000005225', u'ENSMUSG00000041078', u'ENSMUSG00000022935', u'ENSMUSG00000024664', u'ENSMUSG00000024665', u'ENSMUSG00000041073', u'ENSMUSG00000037490', u'ENSMUSG00000022890', u'ENSMUSG00000020739', u'ENSMUSG00000038456', u'ENSMUSG00000024687', u'ENSMUSG00000038690', u'ENSMUSG00000010154', u'ENSMUSG00000074968', u'ENSMUSG00000033792', u'ENSMUSG00000030688', u'ENSMUSG00000001855', u'ENSMUSG00000054477', u'ENSMUSG00000005354', u'ENSMUSG00000033486', u'ENSMUSG00000022843', u'ENSMUSG00000020946', u'ENSMUSG00000044216', u'ENSMUSG00000041670', u'ENSMUSG00000054277', u'ENSMUSG00000022848', u'ENSMUSG00000039672', u'ENSMUSG00000041815', u'ENSMUSG00000050373', u'ENSMUSG00000019590', u'ENSMUSG00000026220', u'ENSMUSG00000004771', u'ENSMUSG00000036534', u'ENSMUSG00000030869', u'ENSMUSG00000027882', u'ENSMUSG00000027884', u'ENSMUSG00000027887', u'ENSMUSG00000038077', u'ENSMUSG00000041920', u'ENSMUSG00000004319', u'ENSMUSG00000004317', u'ENSMUSG00000022142', u'ENSMUSG00000040034', u'ENSMUSG00000031791', u'ENSMUSG00000030310', u'ENSMUSG00000030314', u'ENSMUSG00000038115', u'ENSMUSG00000001985', u'ENSMUSG00000022855', u'ENSMUSG00000029151', u'ENSMUSG00000051355', u'ENSMUSG00000040722', u'ENSMUSG00000040724', u'ENSMUSG00000028136', u'ENSMUSG00000029802', u'ENSMUSG00000015090', u'ENSMUSG00000049659', u'ENSMUSG00000007041', u'ENSMUSG00000021013', u'ENSMUSG00000020541', u'ENSMUSG00000020788', u'ENSMUSG00000028773', u'ENSMUSG00000020783', u'ENSMUSG00000022450', u'ENSMUSG00000022452', u'ENSMUSG00000004113', u'ENSMUSG00000034560', u'ENSMUSG00000034566', u'ENSMUSG00000029790', u'ENSMUSG00000007458', u'ENSMUSG00000029571', u'ENSMUSG00000023942', u'ENSMUSG00000034789', u'ENSMUSG00000049872', u'ENSMUSG00000053119', u'ENSMUSG00000038844', u'ENSMUSG00000028998', u'ENSMUSG00000028999', u'ENSMUSG00000020163', u'ENSMUSG00000028420', u'ENSMUSG00000028354', u'ENSMUSG00000034940', u'ENSMUSG00000032327', u'ENSMUSG00000018761', u'ENSMUSG00000032328', u'ENSMUSG00000075224', u'ENSMUSG00000017639', u'ENSMUSG00000018507', u'ENSMUSG00000052428', u'ENSMUSG00000018167', u'ENSMUSG00000021824', u'ENSMUSG00000054640', u'ENSMUSG00000020375', u'ENSMUSG00000027411', u'ENSMUSG00000000563', u'ENSMUSG00000048833', u'ENSMUSG00000048832', u'ENSMUSG00000032258', u'ENSMUSG00000021952', u'ENSMUSG00000021486', u'ENSMUSG00000079677', u'ENSMUSG00000021484', u'ENSMUSG00000079477', u'ENSMUSG00000050017', u'ENSMUSG00000010095', u'ENSMUSG00000000794', u'ENSMUSG00000005360', u'ENSMUSG00000030872', u'ENSMUSG00000037152', u'ENSMUSG00000027522', u'ENSMUSG00000027255', u'ENSMUSG00000026491', u'ENSMUSG00000023089', u'ENSMUSG00000023088', u'ENSMUSG00000020993', u'ENSMUSG00000024851', u'ENSMUSG00000041710', u'ENSMUSG00000037579', u'ENSMUSG00000041488', u'ENSMUSG00000004768', u'ENSMUSG00000041482', u'ENSMUSG00000049265', u'ENSMUSG00000030091', u'ENSMUSG00000030096', u'ENSMUSG00000030525', u'ENSMUSG00000027742', u'ENSMUSG00000027748', u'ENSMUSG00000030279', u'ENSMUSG00000003528', u'ENSMUSG00000053799', u'ENSMUSG00000022132', u'ENSMUSG00000081534', u'ENSMUSG00000030327', u'ENSMUSG00000017831', u'ENSMUSG00000073725', u'ENSMUSG00000031482', u'ENSMUSG00000031232', u'ENSMUSG00000021313', u'ENSMUSG00000051343', u'ENSMUSG00000057914', u'ENSMUSG00000029016', u'ENSMUSG00000026342', u'ENSMUSG00000031129', u'ENSMUSG00000020570', u'ENSMUSG00000026904', u'ENSMUSG00000022663', u'ENSMUSG00000022664', u'ENSMUSG00000025484', u'ENSMUSG00000022265', u'ENSMUSG00000025241', u'ENSMUSG00000025243', u'ENSMUSG00000042870', u'ENSMUSG00000066189', u'ENSMUSG00000005089', u'ENSMUSG00000028693', u'ENSMUSG00000047976', u'ENSMUSG00000023959', u'ENSMUSG00000041417', u'ENSMUSG00000022462', u'ENSMUSG00000038301', u'ENSMUSG00000002820', u'ENSMUSG00000021171', u'ENSMUSG00000028982', u'ENSMUSG00000035226']), pop_n=13836, p_sm_bonferroni=3.0306933794691535e-05, is_obsolete=False, GO='GO:0006810', name='transport', pop_count=1426, alt_ids=['GO:0015457', 'GO:0015460'], level=3, depth=3, enrichment='p', Cluster='Transient Increase', geneid_set=set([u'ENSMUSG00000027699', u'ENSMUSG00000009035', u'ENSMUSG00000028693', u'ENSMUSG00000037321', u'ENSMUSG00000033033', u'ENSMUSG00000021371', u'ENSMUSG00000036992', u'ENSMUSG00000052798', u'ENSMUSG00000026088', u'ENSMUSG00000041879', u'ENSMUSG00000025134', u'ENSMUSG00000020290', u'ENSMUSG00000001855', u'ENSMUSG00000003779', u'ENSMUSG00000019874', u'ENSMUSG00000024097', u'ENSMUSG00000023015', u'ENSMUSG00000006930', u'ENSMUSG00000024737', u'ENSMUSG00000018167', u'ENSMUSG00000036678', u'ENSMUSG00000022142', u'ENSMUSG00000040034', u'ENSMUSG00000027115']), symbols=u'Aaas Alyref Calhm2 Ect2 Fabp7 Hap1 Ipo9 Kif18a Kif20a Mcur1 Mitd1 Nasp Nup107 Nup155 Nup214 Nup43 Nxt1 Racgap1 Slc15a3 Srsf7 Stard3 Tap1 Tmem184b Xpo1', symbol_set=set([u'Srsf7', u'Calhm2', u'Racgap1', u'Mitd1', u'Tmem184b', u'Kif20a', u'Hap1', u'Ect2', u'Nup107', u'Kif18a', u'Nup155', u'Stard3', 'Mcur1', u'Tap1', u'Nasp', u'Xpo1', u'Aaas', u'Alyref', u'Nup43', u'Fabp7', u'Nxt1', u'Ipo9', u'Nup214', u'Slc15a3']), geneids='ENSMUSG00000009035 ENSMUSG00000037321 ENSMUSG00000033033 ENSMUSG00000041879 ENSMUSG00000025134 ENSMUSG00000003779 ENSMUSG00000019874 ENSMUSG00000023015 ENSMUSG00000006930 ENSMUSG00000018167 ENSMUSG00000027115 ENSMUSG00000027699 ENSMUSG00000028693 ENSMUSG00000021371 ENSMUSG00000036992 ENSMUSG00000052798 ENSMUSG00000026088 ENSMUSG00000020290 ENSMUSG00000001855 ENSMUSG00000024097 ENSMUSG00000024737 ENSMUSG00000036678 ENSMUSG00000022142 ENSMUSG00000040034', format_txt=1, hdr_idx=1, is_hdrgo=True, is_usrgo=True, hdr1usr01='**', dcnt=1661, D1='G', GO_name='transport'),
    Nt(p_uncorrected='', study_count='', study_n='', namespace='', p_fdr_bh='', study_items='', NS='BP', pop_items='', pop_n='', p_sm_bonferroni='', is_obsolete='', GO='GO:0034097', name='', pop_count='', alt_ids='', level=4, depth=4, enrichment='', Cluster='', geneid_set='', symbols='', symbol_set='', geneids='', format_txt=1, hdr_idx=1, is_hdrgo=True, is_usrgo=False, hdr1usr01='*', dcnt=59, D1='F', GO_name='response to cytokine'),
    Nt(p_uncorrected=1.8374158794264207e-07, study_count=5, study_n=624, namespace='biological_process', p_fdr_bh=3.569062562716628e-05, study_items=set([u'ENSMUSG00000069267', u'ENSMUSG00000069273', u'ENSMUSG00000069265', u'ENSMUSG00000025358', u'ENSMUSG00000074403']), NS='BP', pop_items=set([u'ENSMUSG00000069267', u'ENSMUSG00000069265', u'ENSMUSG00000069273', u'ENSMUSG00000025358', u'ENSMUSG00000074403']), pop_n=13836, p_sm_bonferroni=0.00278386879891897, is_obsolete=False, GO='GO:0060968', name='regulation of gene silencing', pop_count=5, alt_ids=[], level=4, depth=6, enrichment='e', Cluster='Transient Increase', geneid_set=set([u'ENSMUSG00000069267', u'ENSMUSG00000069265', u'ENSMUSG00000069273', u'ENSMUSG00000025358', u'ENSMUSG00000074403']), symbols=u'Cdk2 Hist1h3a Hist1h3b Hist1h3e Hist2h3b', symbol_set=set([u'Hist1h3b', u'Cdk2', u'Hist1h3a', u'Hist2h3b', u'Hist1h3e']), geneids='ENSMUSG00000069267 ENSMUSG00000069273 ENSMUSG00000069265 ENSMUSG00000025358 ENSMUSG00000074403', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=50, D1='A', GO_name='regulation of gene silencing'),
    Nt(p_uncorrected='', study_count='', study_n='', namespace='', p_fdr_bh='', study_items='', NS='BP', pop_items='', pop_n='', p_sm_bonferroni='', is_obsolete='', GO='GO:0050792', name='', pop_count='', alt_ids='', level=4, depth=5, enrichment='', Cluster='', geneid_set='', symbols='', symbol_set='', geneids='', format_txt=1, hdr_idx=1, is_hdrgo=True, is_usrgo=False, hdr1usr01='*', dcnt=59, D1='A', GO_name='regulation of viral process'),
    Nt(p_uncorrected=2.150403809074074e-05, study_count=3, study_n=624, namespace='biological_process', p_fdr_bh=0.0023439401518907405, study_items=set([u'ENSMUSG00000033033', u'ENSMUSG00000023015', u'ENSMUSG00000021371']), NS='BP', pop_items=set([u'ENSMUSG00000033720', u'ENSMUSG00000023015', u'ENSMUSG00000028020', u'ENSMUSG00000055078', u'ENSMUSG00000050556', u'ENSMUSG00000037242', u'ENSMUSG00000064356', u'ENSMUSG00000064357', u'ENSMUSG00000034402', u'ENSMUSG00000028931', u'ENSMUSG00000040907', u'ENSMUSG00000037408', u'ENSMUSG00000030592', u'ENSMUSG00000051154', u'ENSMUSG00000018770', u'ENSMUSG00000063142', u'ENSMUSG00000030209', u'ENSMUSG00000049686', u'ENSMUSG00000015340', u'ENSMUSG00000006567', u'ENSMUSG00000022094', u'ENSMUSG00000018459', u'ENSMUSG00000053519', u'ENSMUSG00000031343', u'ENSMUSG00000052459', u'ENSMUSG00000006611', u'ENSMUSG00000060961', u'ENSMUSG00000056073', u'ENSMUSG00000026389', u'ENSMUSG00000032412', u'ENSMUSG00000018585', u'ENSMUSG00000018589', u'ENSMUSG00000021339', u'ENSMUSG00000058248', u'ENSMUSG00000019210', u'ENSMUSG00000005802', u'ENSMUSG00000056258', u'ENSMUSG00000003352', u'ENSMUSG00000003617', u'ENSMUSG00000009687', u'ENSMUSG00000020402', u'ENSMUSG00000036760', u'ENSMUSG00000025189', u'ENSMUSG00000000563', u'ENSMUSG00000033161', u'ENSMUSG00000089774', u'ENSMUSG00000029221', u'ENSMUSG00000041654', u'ENSMUSG00000025781', u'ENSMUSG00000039105', u'ENSMUSG00000026614', u'ENSMUSG00000032741', u'ENSMUSG00000059363', u'ENSMUSG00000036565', u'ENSMUSG00000046480', u'ENSMUSG00000028096', u'ENSMUSG00000013275', u'ENSMUSG00000042644', u'ENSMUSG00000021629', u'ENSMUSG00000063354', u'ENSMUSG00000006057', u'ENSMUSG00000059742', u'ENSMUSG00000024121', u'ENSMUSG00000030247', u'ENSMUSG00000064267', u'ENSMUSG00000022935', u'ENSMUSG00000052310', u'ENSMUSG00000031934', u'ENSMUSG00000040118', u'ENSMUSG00000038717', u'ENSMUSG00000060882', u'ENSMUSG00000044708', u'ENSMUSG00000030237', u'ENSMUSG00000030235', u'ENSMUSG00000034145', u'ENSMUSG00000063796', u'ENSMUSG00000022890', u'ENSMUSG00000031209', u'ENSMUSG00000036196', u'ENSMUSG00000026576', u'ENSMUSG00000031684', u'ENSMUSG00000022199', u'ENSMUSG00000019943', u'ENSMUSG00000002984', u'ENSMUSG00000061171', u'ENSMUSG00000024403', u'ENSMUSG00000001138', u'ENSMUSG00000022758', u'ENSMUSG00000027577', u'ENSMUSG00000038260', u'ENSMUSG00000058975', u'ENSMUSG00000009647', u'ENSMUSG00000040693', u'ENSMUSG00000029212', u'ENSMUSG00000058441', u'ENSMUSG00000029211', u'ENSMUSG00000025572', u'ENSMUSG00000022949', u'ENSMUSG00000054414', u'ENSMUSG00000020723', u'ENSMUSG00000028854', u'ENSMUSG00000037624', u'ENSMUSG00000007653', u'ENSMUSG00000032839', u'ENSMUSG00000054894', u'ENSMUSG00000059003', u'ENSMUSG00000036534', u'ENSMUSG00000025993', u'ENSMUSG00000024270', u'ENSMUSG00000001985', u'ENSMUSG00000016252', u'ENSMUSG00000038319', u'ENSMUSG00000042604', u'ENSMUSG00000062683', u'ENSMUSG00000004110', u'ENSMUSG00000004113', u'ENSMUSG00000028033', u'ENSMUSG00000000560', u'ENSMUSG00000092083', u'ENSMUSG00000027716', u'ENSMUSG00000015653', u'ENSMUSG00000049281', u'ENSMUSG00000040569', u'ENSMUSG00000010803', u'ENSMUSG00000021474', u'ENSMUSG00000024112', u'ENSMUSG00000027895', u'ENSMUSG00000040896', u'ENSMUSG00000038267', u'ENSMUSG00000063698', u'ENSMUSG00000030376', u'ENSMUSG00000004567', u'ENSMUSG00000019087', u'ENSMUSG00000030287', u'ENSMUSG00000023017', u'ENSMUSG00000032017', u'ENSMUSG00000040414', u'ENSMUSG00000036026', u'ENSMUSG00000021771', u'ENSMUSG00000030302', u'ENSMUSG00000015575', u'ENSMUSG00000033379', u'ENSMUSG00000020524', u'ENSMUSG00000034591', u'ENSMUSG00000032570', u'ENSMUSG00000047037', u'ENSMUSG00000001260', u'ENSMUSG00000025790', u'ENSMUSG00000020411', u'ENSMUSG00000010064', u'ENSMUSG00000010066', u'ENSMUSG00000030650', u'ENSMUSG00000025892', u'ENSMUSG00000025221', u'ENSMUSG00000027130', u'ENSMUSG00000002105', u'ENSMUSG00000020704', u'ENSMUSG00000047959', u'ENSMUSG00000032754', u'ENSMUSG00000035805', u'ENSMUSG00000046079', u'ENSMUSG00000030000', u'ENSMUSG00000020805', u'ENSMUSG00000044216', u'ENSMUSG00000036578', u'ENSMUSG00000006641', u'ENSMUSG00000041736', u'ENSMUSG00000027340', u'ENSMUSG00000038497', u'ENSMUSG00000013495', u'ENSMUSG00000070639', u'ENSMUSG00000021730', u'ENSMUSG00000021733', u'ENSMUSG00000054934', u'ENSMUSG00000031997', u'ENSMUSG00000030500', u'ENSMUSG00000027827', u'ENSMUSG00000050963', u'ENSMUSG00000004285', u'ENSMUSG00000017765', u'ENSMUSG00000026065', u'ENSMUSG00000021541', u'ENSMUSG00000030340', u'ENSMUSG00000024069', u'ENSMUSG00000074575', u'ENSMUSG00000018470', u'ENSMUSG00000021371', u'ENSMUSG00000019302', u'ENSMUSG00000023169', u'ENSMUSG00000064105', u'ENSMUSG00000038257', u'ENSMUSG00000048827', u'ENSMUSG00000003378', u'ENSMUSG00000003072', u'ENSMUSG00000009731', u'ENSMUSG00000057378', u'ENSMUSG00000018900', u'ENSMUSG00000034659', u'ENSMUSG00000041078', u'ENSMUSG00000015968', u'ENSMUSG00000046822', u'ENSMUSG00000043673', u'ENSMUSG00000034656', u'ENSMUSG00000033147', u'ENSMUSG00000038690', u'ENSMUSG00000033792', u'ENSMUSG00000033793', u'ENSMUSG00000054477', u'ENSMUSG00000048677', u'ENSMUSG00000045246', u'ENSMUSG00000025212', u'ENSMUSG00000036570', u'ENSMUSG00000033486', u'ENSMUSG00000022843', u'ENSMUSG00000021114', u'ENSMUSG00000041771', u'ENSMUSG00000033981', u'ENSMUSG00000014444', u'ENSMUSG00000009292', u'ENSMUSG00000035594', u'ENSMUSG00000025036', u'ENSMUSG00000039672', u'ENSMUSG00000005674', u'ENSMUSG00000035681', u'ENSMUSG00000068323', u'ENSMUSG00000023267', u'ENSMUSG00000035112', u'ENSMUSG00000020734', u'ENSMUSG00000032313', u'ENSMUSG00000028962', u'ENSMUSG00000064329', u'ENSMUSG00000027884', u'ENSMUSG00000038077', u'ENSMUSG00000006273', u'ENSMUSG00000055026', u'ENSMUSG00000042246', u'ENSMUSG00000004319', u'ENSMUSG00000004317', u'ENSMUSG00000017756', u'ENSMUSG00000061306', u'ENSMUSG00000002771', u'ENSMUSG00000019935', u'ENSMUSG00000075224', u'ENSMUSG00000038115', u'ENSMUSG00000034714', u'ENSMUSG00000039908', u'ENSMUSG00000001986', u'ENSMUSG00000029151', u'ENSMUSG00000021991', u'ENSMUSG00000019894', u'ENSMUSG00000034320', u'ENSMUSG00000033998', u'ENSMUSG00000040724', u'ENSMUSG00000007041', u'ENSMUSG00000025428', u'ENSMUSG00000032269', u'ENSMUSG00000058740', u'ENSMUSG00000038366', u'ENSMUSG00000058743', u'ENSMUSG00000020788', u'ENSMUSG00000022452', u'ENSMUSG00000024327', u'ENSMUSG00000034566', u'ENSMUSG00000079436', u'ENSMUSG00000000605', u'ENSMUSG00000020331', u'ENSMUSG00000025393', u'ENSMUSG00000020334', u'ENSMUSG00000019146', u'ENSMUSG00000029470', u'ENSMUSG00000041695', u'ENSMUSG00000033033', u'ENSMUSG00000000197', u'ENSMUSG00000024957', u'ENSMUSG00000013160', u'ENSMUSG00000045665', u'ENSMUSG00000049872', u'ENSMUSG00000079055', u'ENSMUSG00000079056', u'ENSMUSG00000034462', u'ENSMUSG00000051497', u'ENSMUSG00000028051', u'ENSMUSG00000031791', u'ENSMUSG00000030452', u'ENSMUSG00000030102', u'ENSMUSG00000045404', u'ENSMUSG00000007097', u'ENSMUSG00000037344', u'ENSMUSG00000037434', u'ENSMUSG00000037341', u'ENSMUSG00000027994', u'ENSMUSG00000030428', u'ENSMUSG00000026177', u'ENSMUSG00000064210', u'ENSMUSG00000006576', u'ENSMUSG00000070304', u'ENSMUSG00000090122', u'ENSMUSG00000031775', u'ENSMUSG00000029054', u'ENSMUSG00000018507', u'ENSMUSG00000052428', u'ENSMUSG00000040164', u'ENSMUSG00000020111', u'ENSMUSG00000075316', u'ENSMUSG00000038023', u'ENSMUSG00000054640', u'ENSMUSG00000063873', u'ENSMUSG00000038026', u'ENSMUSG00000028532', u'ENSMUSG00000031075', u'ENSMUSG00000048833', u'ENSMUSG00000026959', u'ENSMUSG00000032554', u'ENSMUSG00000036636', u'ENSMUSG00000039463', u'ENSMUSG00000039347', u'ENSMUSG00000066150', u'ENSMUSG00000066152', u'ENSMUSG00000026824', u'ENSMUSG00000020432', u'ENSMUSG00000020436', u'ENSMUSG00000019194', u'ENSMUSG00000000794', u'ENSMUSG00000000792', u'ENSMUSG00000050856', u'ENSMUSG00000028631', u'ENSMUSG00000037656', u'ENSMUSG00000014158', u'ENSMUSG00000066705', u'ENSMUSG00000024597', u'ENSMUSG00000033676', u'ENSMUSG00000043301', u'ENSMUSG00000070570', u'ENSMUSG00000023259', u'ENSMUSG00000041710', u'ENSMUSG00000016346', u'ENSMUSG00000037579', u'ENSMUSG00000045962', u'ENSMUSG00000041329', u'ENSMUSG00000041482', u'ENSMUSG00000049265', u'ENSMUSG00000042529', u'ENSMUSG00000008892', u'ENSMUSG00000069806', u'ENSMUSG00000030525', u'ENSMUSG00000045053', u'ENSMUSG00000027748', u'ENSMUSG00000053395', u'ENSMUSG00000023030', u'ENSMUSG00000023032', u'ENSMUSG00000023033', u'ENSMUSG00000022132', u'ENSMUSG00000017740', u'ENSMUSG00000019734', u'ENSMUSG00000026519', u'ENSMUSG00000027950', u'ENSMUSG00000022295', u'ENSMUSG00000053897', u'ENSMUSG00000021313', u'ENSMUSG00000051331', u'ENSMUSG00000002908', u'ENSMUSG00000054720', u'ENSMUSG00000029088', u'ENSMUSG00000071424', u'ENSMUSG00000026463', u'ENSMUSG00000057914', u'ENSMUSG00000032511', u'ENSMUSG00000029016', u'ENSMUSG00000031129', u'ENSMUSG00000026904', u'ENSMUSG00000028420', u'ENSMUSG00000017412', u'ENSMUSG00000019558', u'ENSMUSG00000022342', u'ENSMUSG00000022956', u'ENSMUSG00000037610', u'ENSMUSG00000062785', u'ENSMUSG00000066189', u'ENSMUSG00000029468', u'ENSMUSG00000029467', u'ENSMUSG00000039156', u'ENSMUSG00000047976', u'ENSMUSG00000033007', u'ENSMUSG00000023959', u'ENSMUSG00000031532', u'ENSMUSG00000042682', u'ENSMUSG00000022462', u'ENSMUSG00000025986', u'ENSMUSG00000030987', u'ENSMUSG00000030737', u'ENSMUSG00000027163', u'ENSMUSG00000051726', u'ENSMUSG00000020882', u'ENSMUSG00000027365', u'ENSMUSG00000040373']), pop_n=13836, p_sm_bonferroni=0.32580768111281294, is_obsolete=False, GO='GO:0006811', name='ion transport', pop_count=395, alt_ids=[], level=4, depth=4, enrichment='p', Cluster='Transient Increase', geneid_set=set([u'ENSMUSG00000033033', u'ENSMUSG00000023015', u'ENSMUSG00000021371']), symbols=u'Calhm2 Mcur1 Racgap1', symbol_set=set([u'Racgap1', 'Mcur1', u'Calhm2']), geneids='ENSMUSG00000033033 ENSMUSG00000023015 ENSMUSG00000021371', format_txt=1, hdr_idx=1, is_hdrgo=True, is_usrgo=True, hdr1usr01='**', dcnt=657, D1='G', GO_name='ion transport'),
    Nt(p_uncorrected='', study_count='', study_n='', namespace='', p_fdr_bh='', study_items='', NS='BP', pop_items='', pop_n='', p_sm_bonferroni='', is_obsolete='', GO='GO:0050790', name='', pop_count='', alt_ids='', level=3, depth=3, enrichment='', Cluster='', geneid_set='', symbols='', symbol_set='', geneids='', format_txt=1, hdr_idx=1, is_hdrgo=True, is_usrgo=False, hdr1usr01='*', dcnt=639, D1='A', GO_name='regulation of catalytic activity'),
    Nt(p_uncorrected=2.2796759490055655e-05, study_count=8, study_n=624, namespace='biological_process', p_fdr_bh=0.0024670978788130945, study_items=set([u'ENSMUSG00000027699', u'ENSMUSG00000002083', u'ENSMUSG00000030346', u'ENSMUSG00000023067', u'ENSMUSG00000027323', u'ENSMUSG00000035455', u'ENSMUSG00000059552', u'ENSMUSG00000030528']), NS='BP', pop_items=set([u'ENSMUSG00000036390', u'ENSMUSG00000055762', u'ENSMUSG00000020413', u'ENSMUSG00000044627', u'ENSMUSG00000059552', u'ENSMUSG00000041974', u'ENSMUSG00000030528', u'ENSMUSG00000038569', u'ENSMUSG00000029238', u'ENSMUSG00000048668', u'ENSMUSG00000053914', u'ENSMUSG00000037461', u'ENSMUSG00000022248', u'ENSMUSG00000020063', u'ENSMUSG00000059923', u'ENSMUSG00000027699', u'ENSMUSG00000030346', u'ENSMUSG00000034154', u'ENSMUSG00000021215', u'ENSMUSG00000024824', u'ENSMUSG00000022184', u'ENSMUSG00000002083', u'ENSMUSG00000023067', u'ENSMUSG00000054364', u'ENSMUSG00000027323', u'ENSMUSG00000035455', u'ENSMUSG00000053436', u'ENSMUSG00000064289']), pop_n=13836, p_sm_bonferroni=0.3453937030338332, is_obsolete=False, GO='GO:0071479', name='cellular response to ionizing radiation', pop_count=28, alt_ids=[], level=5, depth=5, enrichment='e', Cluster='Transient Increase', geneid_set=set([u'ENSMUSG00000027699', u'ENSMUSG00000002083', u'ENSMUSG00000030346', u'ENSMUSG00000023067', u'ENSMUSG00000027323', u'ENSMUSG00000035455', u'ENSMUSG00000059552', u'ENSMUSG00000030528']), symbols=u'Bbc3 Blm Cdkn1a Ect2 Fignl1 Rad51 Rad51ap1 Trp53', symbol_set=set([u'Ect2', u'Trp53', u'Cdkn1a', u'Fignl1', u'Blm', u'Rad51ap1', u'Rad51', u'Bbc3']), geneids='ENSMUSG00000027699 ENSMUSG00000002083 ENSMUSG00000030346 ENSMUSG00000023067 ENSMUSG00000027323 ENSMUSG00000035455 ENSMUSG00000059552 ENSMUSG00000030528', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=2, D1='BF', GO_name='cellular response to ionizing radiation'),
    Nt(p_uncorrected=0.00046048838074520853, study_count=7, study_n=624, namespace='biological_process', p_fdr_bh=0.0321514260676067, study_items=set([u'ENSMUSG00000068606', u'ENSMUSG00000046879', u'ENSMUSG00000037321', u'ENSMUSG00000078853', u'ENSMUSG00000078921', u'ENSMUSG00000034855', u'ENSMUSG00000024308']), NS='BP', pop_items=set([u'ENSMUSG00000029417', u'ENSMUSG00000058163', u'ENSMUSG00000026656', u'ENSMUSG00000035279', u'ENSMUSG00000037321', u'ENSMUSG00000078920', u'ENSMUSG00000078921', u'ENSMUSG00000031639', u'ENSMUSG00000073555', u'ENSMUSG00000024927', u'ENSMUSG00000015396', u'ENSMUSG00000022556', u'ENSMUSG00000061353', u'ENSMUSG00000002603', u'ENSMUSG00000023078', u'ENSMUSG00000027447', u'ENSMUSG00000068606', u'ENSMUSG00000069874', u'ENSMUSG00000046879', u'ENSMUSG00000030120', u'ENSMUSG00000030341', u'ENSMUSG00000078853', u'ENSMUSG00000034855', u'ENSMUSG00000029371', u'ENSMUSG00000069893', u'ENSMUSG00000024610', u'ENSMUSG00000044827', u'ENSMUSG00000090942', u'ENSMUSG00000018819', u'ENSMUSG00000038058', u'ENSMUSG00000079227', u'ENSMUSG00000024308']), pop_n=13836, p_sm_bonferroni=1.0, is_obsolete=False, GO='GO:0006952', name='defense response', pop_count=32, alt_ids=['GO:0002217', 'GO:0042829'], level=3, depth=3, enrichment='e', Cluster='Transient Increase', geneid_set=set([u'ENSMUSG00000037321', u'ENSMUSG00000078853', u'ENSMUSG00000078921', u'ENSMUSG00000068606', u'ENSMUSG00000034855', u'ENSMUSG00000046879', u'ENSMUSG00000024308']), symbols=u'Cxcl10 Gm4841 Igtp Irgm1 Tap1 Tapbp Tgtp2', symbol_set=set([u'Tap1', u'Gm4841', u'Tgtp2', u'Tapbp', u'Igtp', u'Cxcl10', u'Irgm1']), geneids='ENSMUSG00000068606 ENSMUSG00000046879 ENSMUSG00000037321 ENSMUSG00000078853 ENSMUSG00000078921 ENSMUSG00000034855 ENSMUSG00000024308', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=93, D1='F', GO_name='defense response'),
    Nt(p_uncorrected=1.7206633078450607e-06, study_count=7, study_n=624, namespace='biological_process', p_fdr_bh=0.000255585978207456, study_items=set([u'ENSMUSG00000027496', u'ENSMUSG00000002055', u'ENSMUSG00000021572', u'ENSMUSG00000020897', u'ENSMUSG00000027331', u'ENSMUSG00000033952', u'ENSMUSG00000012443']), NS='BP', pop_items=set([u'ENSMUSG00000018474', u'ENSMUSG00000027496', u'ENSMUSG00000002055', u'ENSMUSG00000001151', u'ENSMUSG00000021572', u'ENSMUSG00000020897', u'ENSMUSG00000027331', u'ENSMUSG00000040549', u'ENSMUSG00000033952', u'ENSMUSG00000005732', u'ENSMUSG00000012443', u'ENSMUSG00000074749', u'ENSMUSG00000026857', u'ENSMUSG00000035354', u'ENSMUSG00000052087']), pop_n=13836, p_sm_bonferroni=0.026069769777160516, is_obsolete=False, GO='GO:0007051', name='spindle organization', pop_count=15, alt_ids=['GO:0043146'], level=3, depth=6, enrichment='e', Cluster='Transient Increase', geneid_set=set([u'ENSMUSG00000020897', u'ENSMUSG00000027331', u'ENSMUSG00000033952', u'ENSMUSG00000027496', u'ENSMUSG00000012443', u'ENSMUSG00000002055', u'ENSMUSG00000021572']), symbols=u'Aspm Aurka Aurkb Cep72 Kif11 Knstrn Spag5', symbol_set=set(['Knstrn', u'Cep72', u'Aspm', u'Spag5', u'Aurka', u'Aurkb', u'Kif11']), geneids='ENSMUSG00000027496 ENSMUSG00000002055 ENSMUSG00000021572 ENSMUSG00000033952 ENSMUSG00000027331 ENSMUSG00000020897 ENSMUSG00000012443', format_txt=1, hdr_idx=1, is_hdrgo=True, is_usrgo=True, hdr1usr01='**', dcnt=24, D1='BCH', GO_name='spindle organization'),
    Nt(p_uncorrected='', study_count='', study_n='', namespace='', p_fdr_bh='', study_items='', NS='BP', pop_items='', pop_n='', p_sm_bonferroni='', is_obsolete='', GO='GO:0006950', name='', pop_count='', alt_ids='', level=2, depth=2, enrichment='', Cluster='', geneid_set='', symbols='', symbol_set='', geneids='', format_txt=1, hdr_idx=1, is_hdrgo=True, is_usrgo=False, hdr1usr01='*', dcnt=491, D1='F', GO_name='response to stress'),
    Nt(p_uncorrected=0.00014991499902937172, study_count=13, study_n=624, namespace='biological_process', p_fdr_bh=0.012146321659326262, study_items=set([u'ENSMUSG00000041827', u'ENSMUSG00000034394', u'ENSMUSG00000032661', u'ENSMUSG00000032508', u'ENSMUSG00000027399', u'ENSMUSG00000022074', u'ENSMUSG00000029561', u'ENSMUSG00000016496', u'ENSMUSG00000034855', u'ENSMUSG00000035352', u'ENSMUSG00000018930', u'ENSMUSG00000029605', u'ENSMUSG00000002699']), NS='BP', pop_items=set([u'ENSMUSG00000045322', u'ENSMUSG00000026656', u'ENSMUSG00000032661', u'ENSMUSG00000059327', u'ENSMUSG00000060586', u'ENSMUSG00000031778', u'ENSMUSG00000002015', u'ENSMUSG00000061353', u'ENSMUSG00000029371', u'ENSMUSG00000023078', u'ENSMUSG00000021796', u'ENSMUSG00000022074', u'ENSMUSG00000036103', u'ENSMUSG00000079362', u'ENSMUSG00000006014', u'ENSMUSG00000027399', u'ENSMUSG00000029605', u'ENSMUSG00000000982', u'ENSMUSG00000037649', u'ENSMUSG00000045827', u'ENSMUSG00000032251', u'ENSMUSG00000029287', u'ENSMUSG00000020941', u'ENSMUSG00000024778', u'ENSMUSG00000031165', u'ENSMUSG00000022425', u'ENSMUSG00000061132', u'ENSMUSG00000032402', u'ENSMUSG00000036867', u'ENSMUSG00000035352', u'ENSMUSG00000061232', u'ENSMUSG00000034116', u'ENSMUSG00000039217', u'ENSMUSG00000044583', u'ENSMUSG00000034855', u'ENSMUSG00000022637', u'ENSMUSG00000031706', u'ENSMUSG00000037370', u'ENSMUSG00000032369', u'ENSMUSG00000001016', u'ENSMUSG00000017344', u'ENSMUSG00000024610', u'ENSMUSG00000026321', u'ENSMUSG00000034987', u'ENSMUSG00000021508', u'ENSMUSG00000022148', u'ENSMUSG00000079227', u'ENSMUSG00000052384', u'ENSMUSG00000029417', u'ENSMUSG00000056216', u'ENSMUSG00000019122', u'ENSMUSG00000002699', u'ENSMUSG00000073421', u'ENSMUSG00000032508', u'ENSMUSG00000018927', u'ENSMUSG00000079547', u'ENSMUSG00000008318', u'ENSMUSG00000029561', u'ENSMUSG00000056749', u'ENSMUSG00000036469', u'ENSMUSG00000033510', u'ENSMUSG00000028776', u'ENSMUSG00000060802', u'ENSMUSG00000026117', u'ENSMUSG00000032690', u'ENSMUSG00000022468', u'ENSMUSG00000039304', u'ENSMUSG00000018930', u'ENSMUSG00000030339', u'ENSMUSG00000006342', u'ENSMUSG00000028362', u'ENSMUSG00000024793', u'ENSMUSG00000005533', u'ENSMUSG00000041827', u'ENSMUSG00000021846', u'ENSMUSG00000038642', u'ENSMUSG00000039004', u'ENSMUSG00000034394', u'ENSMUSG00000030341', u'ENSMUSG00000016496', u'ENSMUSG00000073411', u'ENSMUSG00000035385', u'ENSMUSG00000027995', u'ENSMUSG00000044827', u'ENSMUSG00000036594', u'ENSMUSG00000027164', u'ENSMUSG00000041515', u'ENSMUSG00000028599']), pop_n=13836, p_sm_bonferroni=1.0, is_obsolete=False, GO='GO:0006955', name='immune response', pop_count=88, alt_ids=[], level=2, depth=2, enrichment='e', Cluster='Transient Increase', geneid_set=set([u'ENSMUSG00000041827', u'ENSMUSG00000034394', u'ENSMUSG00000032661', u'ENSMUSG00000035352', u'ENSMUSG00000032508', u'ENSMUSG00000034855', u'ENSMUSG00000029561', u'ENSMUSG00000016496', u'ENSMUSG00000022074', u'ENSMUSG00000027399', u'ENSMUSG00000018930', u'ENSMUSG00000029605', u'ENSMUSG00000002699']), symbols=u'Ccl12 Ccl4 Cd274 Cxcl10 Il1a Lcp2 Lif Myd88 Oas1b Oas3 Oasl1 Oasl2 Tnfrsf10b', symbol_set=set([u'Lif', u'Oas1b', u'Ccl4', u'Cd274', u'Oasl2', u'Ccl12', u'Oasl1', u'Lcp2', u'Tnfrsf10b', u'Oas3', u'Il1a', u'Cxcl10', u'Myd88']), geneids='ENSMUSG00000041827 ENSMUSG00000034394 ENSMUSG00000032661 ENSMUSG00000035352 ENSMUSG00000032508 ENSMUSG00000029561 ENSMUSG00000034855 ENSMUSG00000027399 ENSMUSG00000016496 ENSMUSG00000022074 ENSMUSG00000002699 ENSMUSG00000018930 ENSMUSG00000029605', format_txt=1, hdr_idx=1, is_hdrgo=True, is_usrgo=True, hdr1usr01='**', dcnt=107, D1='FL', GO_name='immune response'),
    Nt(p_uncorrected=8.529826491330587e-05, study_count=9, study_n=624, namespace='biological_process', p_fdr_bh=0.007977493899391959, study_items=set([u'ENSMUSG00000046591', u'ENSMUSG00000032555', u'ENSMUSG00000003873', u'ENSMUSG00000030609', u'ENSMUSG00000028702', u'ENSMUSG00000027323', u'ENSMUSG00000017146', u'ENSMUSG00000034218', u'ENSMUSG00000078773']), NS='BP', pop_items=set([u'ENSMUSG00000025932', u'ENSMUSG00000046591', u'ENSMUSG00000003873', u'ENSMUSG00000018841', u'ENSMUSG00000027933', u'ENSMUSG00000031201', u'ENSMUSG00000025374', u'ENSMUSG00000027323', u'ENSMUSG00000038544', u'ENSMUSG00000024926', u'ENSMUSG00000030994', u'ENSMUSG00000031644', u'ENSMUSG00000022471', u'ENSMUSG00000020381', u'ENSMUSG00000031820', u'ENSMUSG00000028886', u'ENSMUSG00000026510', u'ENSMUSG00000026107', u'ENSMUSG00000017146', u'ENSMUSG00000021144', u'ENSMUSG00000000148', u'ENSMUSG00000090083', u'ENSMUSG00000021287', u'ENSMUSG00000007646', u'ENSMUSG00000078773', u'ENSMUSG00000035234', u'ENSMUSG00000026648', u'ENSMUSG00000068917', u'ENSMUSG00000033596', u'ENSMUSG00000014074', u'ENSMUSG00000032267', u'ENSMUSG00000022672', u'ENSMUSG00000025878', u'ENSMUSG00000040782', u'ENSMUSG00000032555', u'ENSMUSG00000049717', u'ENSMUSG00000028702', u'ENSMUSG00000030609', u'ENSMUSG00000052139', u'ENSMUSG00000021615', u'ENSMUSG00000034218', u'ENSMUSG00000003068']), pop_n=13836, p_sm_bonferroni=1.0, is_obsolete=False, GO='GO:0010212', name='response to ionizing radiation', pop_count=42, alt_ids=[], level=4, depth=4, enrichment='e', Cluster='Transient Increase', geneid_set=set([u'ENSMUSG00000046591', u'ENSMUSG00000032555', u'ENSMUSG00000003873', u'ENSMUSG00000030609', u'ENSMUSG00000028702', u'ENSMUSG00000027323', u'ENSMUSG00000017146', u'ENSMUSG00000034218', u'ENSMUSG00000078773']), symbols=u'Aen Atm Bax Brca1 Rad51 Rad54b Rad54l Ticrr Topbp1', symbol_set=set([u'Brca1', 'Ticrr', u'Topbp1', u'Rad54l', u'Atm', u'Bax', u'Rad54b', u'Rad51', u'Aen']), geneids='ENSMUSG00000046591 ENSMUSG00000032555 ENSMUSG00000003873 ENSMUSG00000030609 ENSMUSG00000028702 ENSMUSG00000027323 ENSMUSG00000017146 ENSMUSG00000034218 ENSMUSG00000078773', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=5, D1='F', GO_name='response to ionizing radiation'),
    Nt(p_uncorrected=1.0613331792342115e-06, study_count=5, study_n=624, namespace='biological_process', p_fdr_bh=0.00016408427549568916, study_items=set([u'ENSMUSG00000034218', u'ENSMUSG00000020380', u'ENSMUSG00000002068', u'ENSMUSG00000028212', u'ENSMUSG00000027323']), NS='BP', pop_items=set([u'ENSMUSG00000028212', u'ENSMUSG00000031229', u'ENSMUSG00000020380', u'ENSMUSG00000002068', u'ENSMUSG00000027323', u'ENSMUSG00000034218']), pop_n=13836, p_sm_bonferroni=0.016080258998577537, is_obsolete=False, GO='GO:0070192', name='chromosome organization involved in meiotic cell cycle', pop_count=6, alt_ids=[], level=3, depth=5, enrichment='e', Cluster='Transient Increase', geneid_set=set([u'ENSMUSG00000034218', u'ENSMUSG00000020380', u'ENSMUSG00000028212', u'ENSMUSG00000002068', u'ENSMUSG00000027323']), symbols=u'Atm Ccne1 Ccne2 Rad50 Rad51', symbol_set=set([u'Ccne2', u'Ccne1', u'Atm', u'Rad51', u'Rad50']), geneids='ENSMUSG00000034218 ENSMUSG00000020380 ENSMUSG00000028212 ENSMUSG00000002068 ENSMUSG00000027323', format_txt=1, hdr_idx=1, is_hdrgo=True, is_usrgo=True, hdr1usr01='**', dcnt=17, D1='BHK', GO_name='chromosome organization involved in meiotic cell cycle'),
    Nt(p_uncorrected=0.0003012446800247431, study_count=7, study_n=624, namespace='biological_process', p_fdr_bh=0.022049073174178178, study_items=set([u'ENSMUSG00000003873', u'ENSMUSG00000002083', u'ENSMUSG00000024521', u'ENSMUSG00000036986', u'ENSMUSG00000059552', u'ENSMUSG00000057789', u'ENSMUSG00000019979']), NS='BP', pop_items=set([u'ENSMUSG00000003873', u'ENSMUSG00000024392', u'ENSMUSG00000036986', u'ENSMUSG00000056501', u'ENSMUSG00000059552', u'ENSMUSG00000026883', u'ENSMUSG00000029203', u'ENSMUSG00000020715', u'ENSMUSG00000028914', u'ENSMUSG00000027006', u'ENSMUSG00000027313', u'ENSMUSG00000023010', u'ENSMUSG00000071369', u'ENSMUSG00000025408', u'ENSMUSG00000057789', u'ENSMUSG00000022812', u'ENSMUSG00000036932', u'ENSMUSG00000030102', u'ENSMUSG00000033538', u'ENSMUSG00000031668', u'ENSMUSG00000031628', u'ENSMUSG00000042682', u'ENSMUSG00000042406', u'ENSMUSG00000053046', u'ENSMUSG00000019979', u'ENSMUSG00000002083', u'ENSMUSG00000024521', u'ENSMUSG00000020484', u'ENSMUSG00000021831', u'ENSMUSG00000057329']), pop_n=13836, p_sm_bonferroni=1.0, is_obsolete=False, GO='GO:0070059', name='intrinsic apoptotic signaling pathway in response to endoplasmic reticulum stress', pop_count=30, alt_ids=[], level=5, depth=7, enrichment='e', Cluster='Transient Increase', geneid_set=set([u'ENSMUSG00000036986', u'ENSMUSG00000003873', u'ENSMUSG00000002083', u'ENSMUSG00000059552', u'ENSMUSG00000024521', u'ENSMUSG00000057789', u'ENSMUSG00000019979']), symbols=u'Apaf1 Bak1 Bax Bbc3 Pmaip1 Pml Trp53', symbol_set=set([u'Pmaip1', u'Trp53', u'Bax', u'Bak1', u'Pml', u'Bbc3', u'Apaf1']), geneids='ENSMUSG00000019979 ENSMUSG00000002083 ENSMUSG00000024521 ENSMUSG00000036986 ENSMUSG00000059552 ENSMUSG00000057789 ENSMUSG00000003873', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=1, D1='ABF', GO_name='intrinsic apoptotic signaling pathway in response to endoplasmic reticulum stress'),
    Nt(p_uncorrected=0.00012860653072037162, study_count=4, study_n=624, namespace='biological_process', p_fdr_bh=0.010589769276871469, study_items=set([u'ENSMUSG00000035842', u'ENSMUSG00000039994', u'ENSMUSG00000001517', u'ENSMUSG00000036097']), NS='BP', pop_items=set([u'ENSMUSG00000032565', u'ENSMUSG00000001517', u'ENSMUSG00000021597', u'ENSMUSG00000036097', u'ENSMUSG00000039994', u'ENSMUSG00000035842', u'ENSMUSG00000041974']), pop_n=13836, p_sm_bonferroni=1.0, is_obsolete=False, GO='GO:2000781', name='positive regulation of double-strand break repair', pop_count=7, alt_ids=[], level=7, depth=9, enrichment='e', Cluster='Transient Increase', geneid_set=set([u'ENSMUSG00000035842', u'ENSMUSG00000039994', u'ENSMUSG00000001517', u'ENSMUSG00000036097']), symbols=u'Ddx11 Fam178a Foxm1 Timeless', symbol_set=set([u'Foxm1', u'Timeless', u'Fam178a', u'Ddx11']), geneids='ENSMUSG00000035842 ENSMUSG00000039994 ENSMUSG00000001517 ENSMUSG00000036097', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=2, D1='A', GO_name='positive regulation of double-strand break repair'),
    Nt(p_uncorrected='', study_count='', study_n='', namespace='', p_fdr_bh='', study_items='', NS='BP', pop_items='', pop_n='', p_sm_bonferroni='', is_obsolete='', GO='GO:0050896', name='', pop_count='', alt_ids='', level=1, depth=1, enrichment='', Cluster='', geneid_set='', symbols='', symbol_set='', geneids='', format_txt=1, hdr_idx=1, is_hdrgo=True, is_usrgo=False, hdr1usr01='*', dcnt=2241, D1='F', GO_name='response to stimulus'),
    Nt(p_uncorrected=8.945577520622059e-06, study_count=8, study_n=624, namespace='biological_process', p_fdr_bh=0.001075670198531308, study_items=set([u'ENSMUSG00000028718', u'ENSMUSG00000028896', u'ENSMUSG00000027883', u'ENSMUSG00000041431', u'ENSMUSG00000027496', u'ENSMUSG00000024056', u'ENSMUSG00000005233', u'ENSMUSG00000020897']), NS='BP', pop_items=set([u'ENSMUSG00000035198', u'ENSMUSG00000024056', u'ENSMUSG00000027883', u'ENSMUSG00000025337', u'ENSMUSG00000037020', u'ENSMUSG00000028718', u'ENSMUSG00000040729', u'ENSMUSG00000041431', u'ENSMUSG00000024096', u'ENSMUSG00000031516', u'ENSMUSG00000023345', u'ENSMUSG00000001151', u'ENSMUSG00000021701', u'ENSMUSG00000020897', u'ENSMUSG00000058070', u'ENSMUSG00000021693', u'ENSMUSG00000040250', u'ENSMUSG00000064302', u'ENSMUSG00000033392', u'ENSMUSG00000028896', u'ENSMUSG00000027496', u'ENSMUSG00000032479', u'ENSMUSG00000005233', u'ENSMUSG00000028832', u'ENSMUSG00000025410']), pop_n=13836, p_sm_bonferroni=0.1355344450149448, is_obsolete=False, GO='GO:0007052', name='mitotic spindle organization', pop_count=25, alt_ids=['GO:0043148'], level=4, depth=7, enrichment='e', Cluster='Transient Increase', geneid_set=set([u'ENSMUSG00000028718', u'ENSMUSG00000028896', u'ENSMUSG00000027883', u'ENSMUSG00000041431', u'ENSMUSG00000027496', u'ENSMUSG00000024056', u'ENSMUSG00000005233', u'ENSMUSG00000020897']), symbols=u'Aurka Aurkb Ccnb1 Gpsm2 Ndc80 Rcc1 Spc25 Stil', symbol_set=set([u'Rcc1', u'Stil', u'Ndc80', u'Ccnb1', u'Aurka', u'Aurkb', u'Gpsm2', u'Spc25']), geneids='ENSMUSG00000028718 ENSMUSG00000028896 ENSMUSG00000027883 ENSMUSG00000041431 ENSMUSG00000027496 ENSMUSG00000024056 ENSMUSG00000005233 ENSMUSG00000020897', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=5, D1='BCH', GO_name='mitotic spindle organization'),
    Nt(p_uncorrected=0.000352948400217597, study_count=3, study_n=624, namespace='biological_process', p_fdr_bh=0.025224156658947224, study_items=set([u'ENSMUSG00000017550', u'ENSMUSG00000022960', u'ENSMUSG00000004642']), NS='BP', pop_items=set([u'ENSMUSG00000017550', u'ENSMUSG00000022960', u'ENSMUSG00000046010', u'ENSMUSG00000004642']), pop_n=13836, p_sm_bonferroni=1.0, is_obsolete=False, GO='GO:0033260', name='nuclear DNA replication', pop_count=4, alt_ids=[], level=4, depth=10, enrichment='e', Cluster='Transient Increase', geneid_set=set([u'ENSMUSG00000017550', u'ENSMUSG00000022960', u'ENSMUSG00000004642']), symbols=u'Atad5 Donson Slbp', symbol_set=set([u'Atad5', u'Slbp', u'Donson']), geneids='ENSMUSG00000017550 ENSMUSG00000022960 ENSMUSG00000004642', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=3, D1='BD', GO_name='nuclear DNA replication'),
    Nt(p_uncorrected=0.000352948400217597, study_count=3, study_n=624, namespace='biological_process', p_fdr_bh=0.025224156658947224, study_items=set([u'ENSMUSG00000027342', u'ENSMUSG00000029730', u'ENSMUSG00000027490']), NS='BP', pop_items=set([u'ENSMUSG00000022105', u'ENSMUSG00000027342', u'ENSMUSG00000029730', u'ENSMUSG00000027490']), pop_n=13836, p_sm_bonferroni=1.0, is_obsolete=False, GO='GO:0071466', name='cellular response to xenobiotic stimulus', pop_count=4, alt_ids=[], level=4, depth=4, enrichment='e', Cluster='Transient Increase', geneid_set=set([u'ENSMUSG00000027342', u'ENSMUSG00000029730', u'ENSMUSG00000027490']), symbols=u'E2f1 Mcm7 Pcna', symbol_set=set([u'Pcna', u'Mcm7', u'E2f1']), geneids='ENSMUSG00000027342 ENSMUSG00000029730 ENSMUSG00000027490', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=0, D1='BF', GO_name='cellular response to xenobiotic stimulus'),
    Nt(p_uncorrected=5.716066791862708e-05, study_count=4, study_n=624, namespace='biological_process', p_fdr_bh=0.005735372712815357, study_items=set([u'ENSMUSG00000023940', u'ENSMUSG00000034906', u'ENSMUSG00000034349', u'ENSMUSG00000028312']), NS='BP', pop_items=set([u'ENSMUSG00000032498', u'ENSMUSG00000028312', u'ENSMUSG00000041408', u'ENSMUSG00000034349', u'ENSMUSG00000034906', u'ENSMUSG00000023940']), pop_n=13836, p_sm_bonferroni=0.8660412796351189, is_obsolete=False, GO='GO:0045132', name='meiotic chromosome segregation', pop_count=6, alt_ids=[], level=3, depth=5, enrichment='e', Cluster='Transient Increase', geneid_set=set([u'ENSMUSG00000023940', u'ENSMUSG00000034906', u'ENSMUSG00000034349', u'ENSMUSG00000028312']), symbols=u'Ncaph Sgol1 Smc2 Smc4', symbol_set=set([u'Smc4', u'Smc2', u'Sgol1', u'Ncaph']), geneids='ENSMUSG00000023940 ENSMUSG00000034906 ENSMUSG00000034349 ENSMUSG00000028312', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=7, D1='BCK', GO_name='meiotic chromosome segregation'),
    Nt(p_uncorrected=2.452210095801524e-05, study_count=7, study_n=624, namespace='biological_process', p_fdr_bh=0.0026349954015240347, study_items=set([u'ENSMUSG00000030641', u'ENSMUSG00000029521', u'ENSMUSG00000023067', u'ENSMUSG00000059552', u'ENSMUSG00000034218', u'ENSMUSG00000049932', u'ENSMUSG00000032409']), NS='BP', pop_items=set([u'ENSMUSG00000032409', u'ENSMUSG00000030641', u'ENSMUSG00000029110', u'ENSMUSG00000022471', u'ENSMUSG00000034345', u'ENSMUSG00000026187', u'ENSMUSG00000009406', u'ENSMUSG00000023067', u'ENSMUSG00000029521', u'ENSMUSG00000053110', u'ENSMUSG00000020694', u'ENSMUSG00000036940', u'ENSMUSG00000031583', u'ENSMUSG00000032060', u'ENSMUSG00000007659', u'ENSMUSG00000034218', u'ENSMUSG00000049932', u'ENSMUSG00000038984', u'ENSMUSG00000059552', u'ENSMUSG00000038418', u'ENSMUSG00000034659']), pop_n=13836, p_sm_bonferroni=0.3715343516148889, is_obsolete=False, GO='GO:0071480', name='cellular response to gamma radiation', pop_count=21, alt_ids=[], level=6, depth=6, enrichment='e', Cluster='Transient Increase', geneid_set=set([u'ENSMUSG00000034218', u'ENSMUSG00000030641', u'ENSMUSG00000029521', u'ENSMUSG00000059552', u'ENSMUSG00000049932', u'ENSMUSG00000023067', u'ENSMUSG00000032409']), symbols=u'Atm Atr Cdkn1a Chek2 Ddias H2afx Trp53', symbol_set=set(['Ddias', u'Trp53', u'Cdkn1a', u'Atm', u'H2afx', u'Atr', u'Chek2']), geneids='ENSMUSG00000030641 ENSMUSG00000029521 ENSMUSG00000023067 ENSMUSG00000059552 ENSMUSG00000034218 ENSMUSG00000049932 ENSMUSG00000032409', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=0, D1='BF', GO_name='cellular response to gamma radiation'),
    Nt(p_uncorrected='', study_count='', study_n='', namespace='', p_fdr_bh='', study_items='', NS='BP', pop_items='', pop_n='', p_sm_bonferroni='', is_obsolete='', GO='GO:0030154', name='', pop_count='', alt_ids='', level=4, depth=4, enrichment='', Cluster='', geneid_set='', symbols='', symbol_set='', geneids='', format_txt=1, hdr_idx=1, is_hdrgo=True, is_usrgo=False, hdr1usr01='*', dcnt=513, D1='BCE', GO_name='cell differentiation'),
    Nt(p_uncorrected=3.58209532492208e-08, study_count=10, study_n=624, namespace='biological_process', p_fdr_bh=8.349588656599144e-06, study_items=set([u'ENSMUSG00000041827', u'ENSMUSG00000032661', u'ENSMUSG00000039236', u'ENSMUSG00000035692', u'ENSMUSG00000024079', u'ENSMUSG00000023341', u'ENSMUSG00000046718', u'ENSMUSG00000024691', u'ENSMUSG00000020641', u'ENSMUSG00000029605']), NS='BP', pop_items=set([u'ENSMUSG00000032661', u'ENSMUSG00000023341', u'ENSMUSG00000062604', u'ENSMUSG00000027951', u'ENSMUSG00000024079', u'ENSMUSG00000063268', u'ENSMUSG00000066800', u'ENSMUSG00000024691', u'ENSMUSG00000009585', u'ENSMUSG00000041827', u'ENSMUSG00000010175', u'ENSMUSG00000029826', u'ENSMUSG00000037523', u'ENSMUSG00000032178', u'ENSMUSG00000039236', u'ENSMUSG00000046718', u'ENSMUSG00000060591', u'ENSMUSG00000038884', u'ENSMUSG00000029605', u'ENSMUSG00000025492', u'ENSMUSG00000032369', u'ENSMUSG00000035692', u'ENSMUSG00000004865', u'ENSMUSG00000020641']), pop_n=13836, p_sm_bonferroni=0.0005427232626789443, is_obsolete=False, GO='GO:0045071', name='negative regulation of viral genome replication', pop_count=24, alt_ids=[], level=7, depth=8, enrichment='e', Cluster='Transient Increase', geneid_set=set([u'ENSMUSG00000041827', u'ENSMUSG00000032661', u'ENSMUSG00000039236', u'ENSMUSG00000035692', u'ENSMUSG00000046718', u'ENSMUSG00000023341', u'ENSMUSG00000024079', u'ENSMUSG00000024691', u'ENSMUSG00000020641', u'ENSMUSG00000029605']), symbols=u'Bst2 Eif2ak2 Fam111a Isg15 Isg20 Mx2 Oas1b Oas3 Oasl1 Rsad2', symbol_set=set([u'Eif2ak2', u'Mx2', u'Oasl1', u'Oas3', u'Isg15', u'Bst2', u'Isg20', u'Oas1b', u'Rsad2', u'Fam111a']), geneids='ENSMUSG00000041827 ENSMUSG00000032661 ENSMUSG00000039236 ENSMUSG00000035692 ENSMUSG00000046718 ENSMUSG00000023341 ENSMUSG00000024079 ENSMUSG00000024691 ENSMUSG00000020641 ENSMUSG00000029605', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=2, D1='A', GO_name='negative regulation of viral genome replication'),
    Nt(p_uncorrected=6.805064957364015e-10, study_count=8, study_n=624, namespace='biological_process', p_fdr_bh=2.6436804915133895e-07, study_items=set([u'ENSMUSG00000019942', u'ENSMUSG00000028312', u'ENSMUSG00000038252', u'ENSMUSG00000034349', u'ENSMUSG00000020914', u'ENSMUSG00000034906', u'ENSMUSG00000035024', u'ENSMUSG00000042029']), NS='BP', pop_items=set([u'ENSMUSG00000047777', u'ENSMUSG00000008690', u'ENSMUSG00000028312', u'ENSMUSG00000038252', u'ENSMUSG00000019942', u'ENSMUSG00000020914', u'ENSMUSG00000034906', u'ENSMUSG00000035024', u'ENSMUSG00000034349', u'ENSMUSG00000042029']), pop_n=13836, p_sm_bonferroni=1.031035391690222e-05, is_obsolete=False, GO='GO:0030261', name='chromosome condensation', pop_count=10, alt_ids=['GO:0000068'], level=7, depth=7, enrichment='e', Cluster='Transient Increase', geneid_set=set([u'ENSMUSG00000034349', u'ENSMUSG00000028312', u'ENSMUSG00000038252', u'ENSMUSG00000019942', u'ENSMUSG00000020914', u'ENSMUSG00000034906', u'ENSMUSG00000035024', u'ENSMUSG00000042029']), symbols=u'Cdk1 Ncapd2 Ncapd3 Ncapg2 Ncaph Smc2 Smc4 Top2a', symbol_set=set([u'Ncapg2', u'Smc2', u'Smc4', u'Ncapd2', u'Ncapd3', u'Cdk1', u'Ncaph', u'Top2a']), geneids='ENSMUSG00000034349 ENSMUSG00000028312 ENSMUSG00000038252 ENSMUSG00000019942 ENSMUSG00000020914 ENSMUSG00000034906 ENSMUSG00000035024 ENSMUSG00000042029', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=5, D1='BH', GO_name='chromosome condensation'),
    Nt(p_uncorrected='', study_count='', study_n='', namespace='', p_fdr_bh='', study_items='', NS='BP', pop_items='', pop_n='', p_sm_bonferroni='', is_obsolete='', GO='GO:0034641', name='', pop_count='', alt_ids='', level=3, depth=3, enrichment='', Cluster='', geneid_set='', symbols='', symbol_set='', geneids='', format_txt=1, hdr_idx=1, is_hdrgo=True, is_usrgo=False, hdr1usr01='*', dcnt=2095, D1='BD', GO_name='cellular nitrogen compound metabolic process'),
    Nt(p_uncorrected=2.8290260638386237e-06, study_count=11, study_n=624, namespace='biological_process', p_fdr_bh=0.0003947433489227972, study_items=set([u'ENSMUSG00000032397', u'ENSMUSG00000036086', u'ENSMUSG00000037474', u'ENSMUSG00000024521', u'ENSMUSG00000023067', u'ENSMUSG00000036986', u'ENSMUSG00000059552', u'ENSMUSG00000005370', u'ENSMUSG00000030254', u'ENSMUSG00000040204', u'ENSMUSG00000028560']), NS='BP', pop_items=set([u'ENSMUSG00000018199', u'ENSMUSG00000020413', u'ENSMUSG00000059552', u'ENSMUSG00000018449', u'ENSMUSG00000030254', u'ENSMUSG00000050697', u'ENSMUSG00000025076', u'ENSMUSG00000030400', u'ENSMUSG00000032397', u'ENSMUSG00000036086', u'ENSMUSG00000030994', u'ENSMUSG00000037355', u'ENSMUSG00000028914', u'ENSMUSG00000045193', u'ENSMUSG00000035390', u'ENSMUSG00000028329', u'ENSMUSG00000051675', u'ENSMUSG00000040204', u'ENSMUSG00000054051', u'ENSMUSG00000034485', u'ENSMUSG00000026048', u'ENSMUSG00000033712', u'ENSMUSG00000026641', u'ENSMUSG00000002109', u'ENSMUSG00000024382', u'ENSMUSG00000021694', u'ENSMUSG00000026082', u'ENSMUSG00000024947', u'ENSMUSG00000002948', u'ENSMUSG00000031628', u'ENSMUSG00000028560', u'ENSMUSG00000031986', u'ENSMUSG00000024242', u'ENSMUSG00000036986', u'ENSMUSG00000022545', u'ENSMUSG00000020390', u'ENSMUSG00000037474', u'ENSMUSG00000024521', u'ENSMUSG00000023067', u'ENSMUSG00000005370', u'ENSMUSG00000028960', u'ENSMUSG00000021936', u'ENSMUSG00000038225', u'ENSMUSG00000016308']), pop_n=13836, p_sm_bonferroni=0.042862573893218986, is_obsolete=False, GO='GO:0009411', name='response to UV', pop_count=44, alt_ids=[], level=5, depth=5, enrichment='e', Cluster='Transient Increase', geneid_set=set([u'ENSMUSG00000032397', u'ENSMUSG00000036086', u'ENSMUSG00000037474', u'ENSMUSG00000024521', u'ENSMUSG00000023067', u'ENSMUSG00000036986', u'ENSMUSG00000040204', u'ENSMUSG00000005370', u'ENSMUSG00000030254', u'ENSMUSG00000059552', u'ENSMUSG00000028560']), symbols=u'Cdkn1a Dtl Msh6 Pclaf Pmaip1 Pml Rad18 Tipin Trp53 Usp1 Zranb3', symbol_set=set([u'Rad18', u'Pmaip1', u'Zranb3', u'Dtl', u'Usp1', u'Cdkn1a', u'Tipin', u'Msh6', u'Trp53', u'Pml', 'Pclaf']), geneids='ENSMUSG00000032397 ENSMUSG00000036086 ENSMUSG00000037474 ENSMUSG00000024521 ENSMUSG00000023067 ENSMUSG00000036986 ENSMUSG00000059552 ENSMUSG00000005370 ENSMUSG00000030254 ENSMUSG00000040204 ENSMUSG00000028560', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=16, D1='F', GO_name='response to UV'),
    Nt(p_uncorrected=2.4973461286259312e-11, study_count=33, study_n=624, namespace='biological_process', p_fdr_bh=3.774646010782965e-08, study_items=set([u'ENSMUSG00000028678', u'ENSMUSG00000028066', u'ENSMUSG00000036928', u'ENSMUSG00000024056', u'ENSMUSG00000002055', u'ENSMUSG00000045328', u'ENSMUSG00000048922', u'ENSMUSG00000031756', u'ENSMUSG00000023940', u'ENSMUSG00000021965', u'ENSMUSG00000031478', u'ENSMUSG00000020914', u'ENSMUSG00000027331', u'ENSMUSG00000017146', u'ENSMUSG00000027379', u'ENSMUSG00000024660', u'ENSMUSG00000020492', u'ENSMUSG00000022034', u'ENSMUSG00000062510', u'ENSMUSG00000045273', u'ENSMUSG00000058290', u'ENSMUSG00000040599', u'ENSMUSG00000012443', u'ENSMUSG00000028896', u'ENSMUSG00000027326', u'ENSMUSG00000027635', u'ENSMUSG00000017716', u'ENSMUSG00000040034', u'ENSMUSG00000005233', u'ENSMUSG00000044783', u'ENSMUSG00000026622', u'ENSMUSG00000026605', u'ENSMUSG00000026039']), NS='BP', pop_items=set([u'ENSMUSG00000047777', u'ENSMUSG00000031478', u'ENSMUSG00000028066', u'ENSMUSG00000036928', u'ENSMUSG00000024056', u'ENSMUSG00000002055', u'ENSMUSG00000045328', u'ENSMUSG00000017716', u'ENSMUSG00000048922', u'ENSMUSG00000030105', u'ENSMUSG00000020694', u'ENSMUSG00000031756', u'ENSMUSG00000020415', u'ENSMUSG00000023940', u'ENSMUSG00000030400', u'ENSMUSG00000039298', u'ENSMUSG00000070544', u'ENSMUSG00000026039', u'ENSMUSG00000042567', u'ENSMUSG00000021965', u'ENSMUSG00000052087', u'ENSMUSG00000028678', u'ENSMUSG00000020914', u'ENSMUSG00000018736', u'ENSMUSG00000015120', u'ENSMUSG00000022779', u'ENSMUSG00000027331', u'ENSMUSG00000037443', u'ENSMUSG00000017146', u'ENSMUSG00000005982', u'ENSMUSG00000024660', u'ENSMUSG00000020492', u'ENSMUSG00000022978', u'ENSMUSG00000035351', u'ENSMUSG00000016319', u'ENSMUSG00000035354', u'ENSMUSG00000062510', u'ENSMUSG00000031010', u'ENSMUSG00000000787', u'ENSMUSG00000027379', u'ENSMUSG00000025862', u'ENSMUSG00000034290', u'ENSMUSG00000026857', u'ENSMUSG00000066979', u'ENSMUSG00000007564', u'ENSMUSG00000045273', u'ENSMUSG00000058290', u'ENSMUSG00000026426', u'ENSMUSG00000029253', u'ENSMUSG00000017421', u'ENSMUSG00000026605', u'ENSMUSG00000022678', u'ENSMUSG00000040599', u'ENSMUSG00000026275', u'ENSMUSG00000030744', u'ENSMUSG00000012443', u'ENSMUSG00000028896', u'ENSMUSG00000022034', u'ENSMUSG00000005698', u'ENSMUSG00000032381', u'ENSMUSG00000075266', u'ENSMUSG00000027326', u'ENSMUSG00000027635', u'ENSMUSG00000037286', u'ENSMUSG00000030965', u'ENSMUSG00000026749', u'ENSMUSG00000004865', u'ENSMUSG00000071350', u'ENSMUSG00000040034', u'ENSMUSG00000005233', u'ENSMUSG00000044783', u'ENSMUSG00000003662', u'ENSMUSG00000026622', u'ENSMUSG00000025159', u'ENSMUSG00000036672', u'ENSMUSG00000079614', u'ENSMUSG00000031858', u'ENSMUSG00000024002', u'ENSMUSG00000022314']), pop_n=13836, p_sm_bonferroni=3.7837291194811483e-07, is_obsolete=False, GO='GO:0007059', name='chromosome segregation', pop_count=79, alt_ids=[], level=3, depth=3, enrichment='e', Cluster='Transient Increase', geneid_set=set([u'ENSMUSG00000031478', u'ENSMUSG00000028066', u'ENSMUSG00000036928', u'ENSMUSG00000024056', u'ENSMUSG00000002055', u'ENSMUSG00000045328', u'ENSMUSG00000048922', u'ENSMUSG00000031756', u'ENSMUSG00000023940', u'ENSMUSG00000026039', u'ENSMUSG00000021965', u'ENSMUSG00000028678', u'ENSMUSG00000020914', u'ENSMUSG00000027331', u'ENSMUSG00000017146', u'ENSMUSG00000027379', u'ENSMUSG00000024660', u'ENSMUSG00000020492', u'ENSMUSG00000022034', u'ENSMUSG00000062510', u'ENSMUSG00000045273', u'ENSMUSG00000058290', u'ENSMUSG00000040599', u'ENSMUSG00000028896', u'ENSMUSG00000027326', u'ENSMUSG00000027635', u'ENSMUSG00000017716', u'ENSMUSG00000040034', u'ENSMUSG00000005233', u'ENSMUSG00000044783', u'ENSMUSG00000026622', u'ENSMUSG00000026605', u'ENSMUSG00000012443']), symbols=u'Birc5 Brca1 Bub1 Cdca2 Cenpe Cenpf Cenph Cenpn Dsn1 Esco2 Espl1 Hjurp Incenp Kif11 Kif2c Knl1 Knstrn Mis12 Ndc80 Nek2 Nek3 Nsl1 Nup43 Pmf1 Rcc1 Sgol1 Sgol2a Ska2 Ska3 Spag5 Spc25 Stag3 Top2a', symbol_set=set([u'Nsl1', u'Esco2', u'Cdca2', u'Espl1', u'Rcc1', u'Mis12', u'Ndc80', u'Top2a', u'Brca1', u'Nek2', u'Nek3', u'Pmf1', u'Sgol1', 'Ska3', 'Ska2', 'Knl1', u'Spc25', 'Knstrn', u'Cenpn', u'Bub1', u'Cenph', u'Cenpf', u'Cenpe', u'Dsn1', u'Kif11', u'Incenp', u'Hjurp', 'Sgol2a', u'Stag3', u'Birc5', u'Spag5', u'Nup43', u'Kif2c']), geneids='ENSMUSG00000031478 ENSMUSG00000028066 ENSMUSG00000036928 ENSMUSG00000024056 ENSMUSG00000002055 ENSMUSG00000045328 ENSMUSG00000048922 ENSMUSG00000031756 ENSMUSG00000023940 ENSMUSG00000021965 ENSMUSG00000028678 ENSMUSG00000020914 ENSMUSG00000040599 ENSMUSG00000027331 ENSMUSG00000017146 ENSMUSG00000027379 ENSMUSG00000024660 ENSMUSG00000020492 ENSMUSG00000022034 ENSMUSG00000062510 ENSMUSG00000045273 ENSMUSG00000058290 ENSMUSG00000026039 ENSMUSG00000028896 ENSMUSG00000027326 ENSMUSG00000027635 ENSMUSG00000017716 ENSMUSG00000040034 ENSMUSG00000005233 ENSMUSG00000044783 ENSMUSG00000026622 ENSMUSG00000026605 ENSMUSG00000012443', format_txt=1, hdr_idx=1, is_hdrgo=True, is_usrgo=True, hdr1usr01='**', dcnt=11, D1='BC', GO_name='chromosome segregation'),
    Nt(p_uncorrected=7.659860435627715e-11, study_count=149, study_n=624, namespace='biological_process', p_fdr_bh=4.697020473576398e-08, study_items=set([u'ENSMUSG00000028224', u'ENSMUSG00000040084', u'ENSMUSG00000034349', u'ENSMUSG00000027469', u'ENSMUSG00000042029', u'ENSMUSG00000045328', u'ENSMUSG00000024974', u'ENSMUSG00000025358', u'ENSMUSG00000059552', u'ENSMUSG00000024056', u'ENSMUSG00000032782', u'ENSMUSG00000020380', u'ENSMUSG00000022177', u'ENSMUSG00000046179', u'ENSMUSG00000028282', u'ENSMUSG00000022070', u'ENSMUSG00000017861', u'ENSMUSG00000027379', u'ENSMUSG00000033952', u'ENSMUSG00000038252', u'ENSMUSG00000062510', u'ENSMUSG00000029521', u'ENSMUSG00000020185', u'ENSMUSG00000002068', u'ENSMUSG00000041147', u'ENSMUSG00000016477', u'ENSMUSG00000051378', u'ENSMUSG00000037313', u'ENSMUSG00000027715', u'ENSMUSG00000032254', u'ENSMUSG00000043065', u'ENSMUSG00000072082', u'ENSMUSG00000027490', u'ENSMUSG00000037725', u'ENSMUSG00000027496', u'ENSMUSG00000029283', u'ENSMUSG00000024660', u'ENSMUSG00000021115', u'ENSMUSG00000078762', u'ENSMUSG00000038482', u'ENSMUSG00000005410', u'ENSMUSG00000027306', u'ENSMUSG00000027959', u'ENSMUSG00000023908', u'ENSMUSG00000031004', u'ENSMUSG00000006398', u'ENSMUSG00000034023', u'ENSMUSG00000029730', u'ENSMUSG00000048922', u'ENSMUSG00000019214', u'ENSMUSG00000034906', u'ENSMUSG00000028551', u'ENSMUSG00000049932', u'ENSMUSG00000002870', u'ENSMUSG00000032397', u'ENSMUSG00000035683', u'ENSMUSG00000037544', u'ENSMUSG00000021965', u'ENSMUSG00000027641', u'ENSMUSG00000023015', u'ENSMUSG00000030867', u'ENSMUSG00000047534', u'ENSMUSG00000032400', u'ENSMUSG00000028312', u'ENSMUSG00000026622', u'ENSMUSG00000020525', u'ENSMUSG00000028896', u'ENSMUSG00000032477', u'ENSMUSG00000026683', u'ENSMUSG00000027326', u'ENSMUSG00000027635', u'ENSMUSG00000022673', u'ENSMUSG00000023067', u'ENSMUSG00000040034', u'ENSMUSG00000042489', u'ENSMUSG00000006585', u'ENSMUSG00000012443', u'ENSMUSG00000029414', u'ENSMUSG00000002297', u'ENSMUSG00000028066', u'ENSMUSG00000001403', u'ENSMUSG00000036928', u'ENSMUSG00000002055', u'ENSMUSG00000051220', u'ENSMUSG00000033364', u'ENSMUSG00000000028', u'ENSMUSG00000041431', u'ENSMUSG00000041238', u'ENSMUSG00000039994', u'ENSMUSG00000026355', u'ENSMUSG00000039187', u'ENSMUSG00000027331', u'ENSMUSG00000018983', u'ENSMUSG00000020492', u'ENSMUSG00000041133', u'ENSMUSG00000022034', u'ENSMUSG00000024989', u'ENSMUSG00000017146', u'ENSMUSG00000027699', u'ENSMUSG00000020897', u'ENSMUSG00000037214', u'ENSMUSG00000025001', u'ENSMUSG00000040599', u'ENSMUSG00000046591', u'ENSMUSG00000028873', u'ENSMUSG00000019773', u'ENSMUSG00000003824', u'ENSMUSG00000006715', u'ENSMUSG00000035310', u'ENSMUSG00000029472', u'ENSMUSG00000024795', u'ENSMUSG00000002835', u'ENSMUSG00000032218', u'ENSMUSG00000023940', u'ENSMUSG00000041859', u'ENSMUSG00000030641', u'ENSMUSG00000023505', u'ENSMUSG00000032113', u'ENSMUSG00000019942', u'ENSMUSG00000056394', u'ENSMUSG00000026779', u'ENSMUSG00000027353', u'ENSMUSG00000062248', u'ENSMUSG00000061607', u'ENSMUSG00000020326', u'ENSMUSG00000069910', u'ENSMUSG00000028212', u'ENSMUSG00000001517', u'ENSMUSG00000074476', u'ENSMUSG00000028678', u'ENSMUSG00000028693', u'ENSMUSG00000034218', u'ENSMUSG00000073705', u'ENSMUSG00000068744', u'ENSMUSG00000038943', u'ENSMUSG00000026088', u'ENSMUSG00000026039', u'ENSMUSG00000058729', u'ENSMUSG00000017499', u'ENSMUSG00000001228', u'ENSMUSG00000031478', u'ENSMUSG00000020808', u'ENSMUSG00000017716', u'ENSMUSG00000029910', u'ENSMUSG00000036202', u'ENSMUSG00000035024', u'ENSMUSG00000005233', u'ENSMUSG00000044783', u'ENSMUSG00000022945']), NS='BP', pop_items=set([u'ENSMUSG00000066842', u'ENSMUSG00000040084', u'ENSMUSG00000046591', u'ENSMUSG00000026491', u'ENSMUSG00000029516', u'ENSMUSG00000006005', u'ENSMUSG00000046691', u'ENSMUSG00000059248', u'ENSMUSG00000038393', u'ENSMUSG00000035131', u'ENSMUSG00000017146', u'ENSMUSG00000020752', u'ENSMUSG00000015120', u'ENSMUSG00000019773', u'ENSMUSG00000049680', u'ENSMUSG00000012429', u'ENSMUSG00000024042', u'ENSMUSG00000018983', u'ENSMUSG00000019988', u'ENSMUSG00000068154', u'ENSMUSG00000031347', u'ENSMUSG00000035048', u'ENSMUSG00000023067', u'ENSMUSG00000026389', u'ENSMUSG00000019917', u'ENSMUSG00000020107', u'ENSMUSG00000048170', u'ENSMUSG00000028873', u'ENSMUSG00000027306', u'ENSMUSG00000036390', u'ENSMUSG00000031242', u'ENSMUSG00000066149', u'ENSMUSG00000048922', u'ENSMUSG00000019214', u'ENSMUSG00000070923', u'ENSMUSG00000033209', u'ENSMUSG00000002870', u'ENSMUSG00000031644', u'ENSMUSG00000032562', u'ENSMUSG00000021965', u'ENSMUSG00000047126', u'ENSMUSG00000024190', u'ENSMUSG00000029127', u'ENSMUSG00000047534', u'ENSMUSG00000079562', u'ENSMUSG00000036782', u'ENSMUSG00000031010', u'ENSMUSG00000038344', u'ENSMUSG00000031016', u'ENSMUSG00000057236', u'ENSMUSG00000021948', u'ENSMUSG00000028790', u'ENSMUSG00000029253', u'ENSMUSG00000069089', u'ENSMUSG00000046240', u'ENSMUSG00000028896', u'ENSMUSG00000037664', u'ENSMUSG00000029385', u'ENSMUSG00000036850', u'ENSMUSG00000034218', u'ENSMUSG00000035342', u'ENSMUSG00000029414', u'ENSMUSG00000029554', u'ENSMUSG00000002055', u'ENSMUSG00000028478', u'ENSMUSG00000072214', u'ENSMUSG00000045969', u'ENSMUSG00000000028', u'ENSMUSG00000041238', u'ENSMUSG00000028693', u'ENSMUSG00000030061', u'ENSMUSG00000029147', u'ENSMUSG00000035469', u'ENSMUSG00000027331', u'ENSMUSG00000027330', u'ENSMUSG00000020492', u'ENSMUSG00000027339', u'ENSMUSG00000030498', u'ENSMUSG00000031906', u'ENSMUSG00000033900', u'ENSMUSG00000046707', u'ENSMUSG00000063358', u'ENSMUSG00000064302', u'ENSMUSG00000035486', u'ENSMUSG00000037214', u'ENSMUSG00000030538', u'ENSMUSG00000040599', u'ENSMUSG00000022978', u'ENSMUSG00000037286', u'ENSMUSG00000032064', u'ENSMUSG00000039781', u'ENSMUSG00000003824', u'ENSMUSG00000021537', u'ENSMUSG00000030330', u'ENSMUSG00000031201', u'ENSMUSG00000021365', u'ENSMUSG00000057469', u'ENSMUSG00000052957', u'ENSMUSG00000071533', u'ENSMUSG00000031723', u'ENSMUSG00000023505', u'ENSMUSG00000032113', u'ENSMUSG00000029004', u'ENSMUSG00000029003', u'ENSMUSG00000031729', u'ENSMUSG00000014956', u'ENSMUSG00000036106', u'ENSMUSG00000042903', u'ENSMUSG00000056596', u'ENSMUSG00000022750', u'ENSMUSG00000025408', u'ENSMUSG00000061607', u'ENSMUSG00000024151', u'ENSMUSG00000035032', u'ENSMUSG00000044147', u'ENSMUSG00000022673', u'ENSMUSG00000017421', u'ENSMUSG00000022678', u'ENSMUSG00000058729', u'ENSMUSG00000017499', u'ENSMUSG00000011831', u'ENSMUSG00000053046', u'ENSMUSG00000029176', u'ENSMUSG00000029910', u'ENSMUSG00000036202', u'ENSMUSG00000028851', u'ENSMUSG00000005233', u'ENSMUSG00000007656', u'ENSMUSG00000015971', u'ENSMUSG00000000743', u'ENSMUSG00000025907', u'ENSMUSG00000022945', u'ENSMUSG00000019942', u'ENSMUSG00000051378', u'ENSMUSG00000024974', u'ENSMUSG00000020694', u'ENSMUSG00000020697', u'ENSMUSG00000025358', u'ENSMUSG00000059552', u'ENSMUSG00000030752', u'ENSMUSG00000024370', u'ENSMUSG00000033088', u'ENSMUSG00000025616', u'ENSMUSG00000048668', u'ENSMUSG00000020380', u'ENSMUSG00000024277', u'ENSMUSG00000041769', u'ENSMUSG00000024576', u'ENSMUSG00000031913', u'ENSMUSG00000020897', u'ENSMUSG00000060475', u'ENSMUSG00000021103', u'ENSMUSG00000032498', u'ENSMUSG00000029521', u'ENSMUSG00000033712', u'ENSMUSG00000033713', u'ENSMUSG00000038619', u'ENSMUSG00000023932', u'ENSMUSG00000020185', u'ENSMUSG00000002068', u'ENSMUSG00000045038', u'ENSMUSG00000039660', u'ENSMUSG00000037313', u'ENSMUSG00000027654', u'ENSMUSG00000005699', u'ENSMUSG00000027715', u'ENSMUSG00000042506', u'ENSMUSG00000008859', u'ENSMUSG00000028926', u'ENSMUSG00000035437', u'ENSMUSG00000031878', u'ENSMUSG00000026622', u'ENSMUSG00000035439', u'ENSMUSG00000016477', u'ENSMUSG00000020745', u'ENSMUSG00000062234', u'ENSMUSG00000027959', u'ENSMUSG00000046731', u'ENSMUSG00000036777', u'ENSMUSG00000030966', u'ENSMUSG00000030272', u'ENSMUSG00000028059', u'ENSMUSG00000034021', u'ENSMUSG00000032397', u'ENSMUSG00000014859', u'ENSMUSG00000032411', u'ENSMUSG00000031371', u'ENSMUSG00000026027', u'ENSMUSG00000032010', u'ENSMUSG00000040021', u'ENSMUSG00000066357', u'ENSMUSG00000032400', u'ENSMUSG00000022018', u'ENSMUSG00000026426', u'ENSMUSG00000034290', u'ENSMUSG00000000708', u'ENSMUSG00000031155', u'ENSMUSG00000020525', u'ENSMUSG00000031095', u'ENSMUSG00000078762', u'ENSMUSG00000002365', u'ENSMUSG00000032477', u'ENSMUSG00000028351', u'ENSMUSG00000006585', u'ENSMUSG00000012443', u'ENSMUSG00000079555', u'ENSMUSG00000052062', u'ENSMUSG00000036923', u'ENSMUSG00000026927', u'ENSMUSG00000036928', u'ENSMUSG00000031820', u'ENSMUSG00000003031', u'ENSMUSG00000020415', u'ENSMUSG00000036779', u'ENSMUSG00000010067', u'ENSMUSG00000003039', u'ENSMUSG00000057614', u'ENSMUSG00000021595', u'ENSMUSG00000024293', u'ENSMUSG00000049717', u'ENSMUSG00000024235', u'ENSMUSG00000041133', u'ENSMUSG00000036840', u'ENSMUSG00000024989', u'ENSMUSG00000036845', u'ENSMUSG00000035086', u'ENSMUSG00000057110', u'ENSMUSG00000001228', u'ENSMUSG00000059586', u'ENSMUSG00000049327', u'ENSMUSG00000033751', u'ENSMUSG00000025001', u'ENSMUSG00000046179', u'ENSMUSG00000001034', u'ENSMUSG00000025316', u'ENSMUSG00000033054', u'ENSMUSG00000046550', u'ENSMUSG00000005410', u'ENSMUSG00000026749', u'ENSMUSG00000028969', u'ENSMUSG00000038990', u'ENSMUSG00000014402', u'ENSMUSG00000047777', u'ENSMUSG00000033628', u'ENSMUSG00000028282', u'ENSMUSG00000014355', u'ENSMUSG00000041859', u'ENSMUSG00000004085', u'ENSMUSG00000028447', u'ENSMUSG00000031921', u'ENSMUSG00000000355', u'ENSMUSG00000018654', u'ENSMUSG00000055128', u'ENSMUSG00000040102', u'ENSMUSG00000035024', u'ENSMUSG00000026064', u'ENSMUSG00000027479', u'ENSMUSG00000069910', u'ENSMUSG00000028212', u'ENSMUSG00000001517', u'ENSMUSG00000068428', u'ENSMUSG00000025862', u'ENSMUSG00000021276', u'ENSMUSG00000034154', u'ENSMUSG00000024068', u'ENSMUSG00000021375', u'ENSMUSG00000073705', u'ENSMUSG00000068744', u'ENSMUSG00000052934', u'ENSMUSG00000073700', u'ENSMUSG00000031666', u'ENSMUSG00000026088', u'ENSMUSG00000029062', u'ENSMUSG00000004451', u'ENSMUSG00000032733', u'ENSMUSG00000031660', u'ENSMUSG00000042275', u'ENSMUSG00000032435', u'ENSMUSG00000017716', u'ENSMUSG00000060860', u'ENSMUSG00000032534', u'ENSMUSG00000062248', u'ENSMUSG00000026361', u'ENSMUSG00000026360', u'ENSMUSG00000079614', u'ENSMUSG00000000001', u'ENSMUSG00000020307', u'ENSMUSG00000026965', u'ENSMUSG00000038252', u'ENSMUSG00000020263', u'ENSMUSG00000045328', u'ENSMUSG00000020516', u'ENSMUSG00000026883', u'ENSMUSG00000022369', u'ENSMUSG00000029161', u'ENSMUSG00000011589', u'ENSMUSG00000070348', u'ENSMUSG00000017861', u'ENSMUSG00000025269', u'ENSMUSG00000000902', u'ENSMUSG00000024660', u'ENSMUSG00000075266', u'ENSMUSG00000062510', u'ENSMUSG00000039231', u'ENSMUSG00000029684', u'ENSMUSG00000056305', u'ENSMUSG00000021693', u'ENSMUSG00000040250', u'ENSMUSG00000033417', u'ENSMUSG00000058013', u'ENSMUSG00000036432', u'ENSMUSG00000036306', u'ENSMUSG00000027496', u'ENSMUSG00000042750', u'ENSMUSG00000027490', u'ENSMUSG00000030965', u'ENSMUSG00000021115', u'ENSMUSG00000036977', u'ENSMUSG00000067787', u'ENSMUSG00000029430', u'ENSMUSG00000023908', u'ENSMUSG00000018509', u'ENSMUSG00000034906', u'ENSMUSG00000028551', u'ENSMUSG00000025035', u'ENSMUSG00000040957', u'ENSMUSG00000025135', u'ENSMUSG00000045636', u'ENSMUSG00000035683', u'ENSMUSG00000050379', u'ENSMUSG00000037544', u'ENSMUSG00000000552', u'ENSMUSG00000040385', u'ENSMUSG00000027641', u'ENSMUSG00000034349', u'ENSMUSG00000027646', u'ENSMUSG00000030867', u'ENSMUSG00000039128', u'ENSMUSG00000015149', u'ENSMUSG00000004771', u'ENSMUSG00000091337', u'ENSMUSG00000028312', u'ENSMUSG00000055024', u'ENSMUSG00000031314', u'ENSMUSG00000026683', u'ENSMUSG00000041408', u'ENSMUSG00000022141', u'ENSMUSG00000040034', u'ENSMUSG00000026039', u'ENSMUSG00000075324', u'ENSMUSG00000034165', u'ENSMUSG00000031386', u'ENSMUSG00000004591', u'ENSMUSG00000027469', u'ENSMUSG00000051220', u'ENSMUSG00000019873', u'ENSMUSG00000033364', u'ENSMUSG00000044345', u'ENSMUSG00000029026', u'ENSMUSG00000039994', u'ENSMUSG00000032504', u'ENSMUSG00000026355', u'ENSMUSG00000021866', u'ENSMUSG00000032264', u'ENSMUSG00000090083', u'ENSMUSG00000025812', u'ENSMUSG00000020232', u'ENSMUSG00000063065', u'ENSMUSG00000027379', u'ENSMUSG00000020235', u'ENSMUSG00000014668', u'ENSMUSG00000038416', u'ENSMUSG00000043987', u'ENSMUSG00000022456', u'ENSMUSG00000044641', u'ENSMUSG00000034563', u'ENSMUSG00000032218', u'ENSMUSG00000065954', u'ENSMUSG00000022961', u'ENSMUSG00000006728', u'ENSMUSG00000024790', u'ENSMUSG00000022802', u'ENSMUSG00000021395', u'ENSMUSG00000019794', u'ENSMUSG00000053333', u'ENSMUSG00000029472', u'ENSMUSG00000028680', u'ENSMUSG00000023940', u'ENSMUSG00000025077', u'ENSMUSG00000024817', u'ENSMUSG00000027285', u'ENSMUSG00000030641', u'ENSMUSG00000011960', u'ENSMUSG00000024558', u'ENSMUSG00000030649', u'ENSMUSG00000028678', u'ENSMUSG00000035390', u'ENSMUSG00000018821', u'ENSMUSG00000085793', u'ENSMUSG00000028999', u'ENSMUSG00000026779', u'ENSMUSG00000027353', u'ENSMUSG00000004031', u'ENSMUSG00000038482', u'ENSMUSG00000011114', u'ENSMUSG00000029501', u'ENSMUSG00000041840', u'ENSMUSG00000030105', u'ENSMUSG00000038943', u'ENSMUSG00000042364', u'ENSMUSG00000027550', u'ENSMUSG00000040860', u'ENSMUSG00000052087', u'ENSMUSG00000005102', u'ENSMUSG00000020808', u'ENSMUSG00000031529', u'ENSMUSG00000021671', u'ENSMUSG00000026276', u'ENSMUSG00000041997', u'ENSMUSG00000022105', u'ENSMUSG00000031858', u'ENSMUSG00000003068', u'ENSMUSG00000028224', u'ENSMUSG00000033444', u'ENSMUSG00000024073', u'ENSMUSG00000069631', u'ENSMUSG00000042029', u'ENSMUSG00000023572', u'ENSMUSG00000017639', u'ENSMUSG00000022089', u'ENSMUSG00000022178', u'ENSMUSG00000032782', u'ENSMUSG00000016128', u'ENSMUSG00000022177', u'ENSMUSG00000022070', u'ENSMUSG00000040760', u'ENSMUSG00000033952', u'ENSMUSG00000053119', u'ENSMUSG00000022772', u'ENSMUSG00000024286', u'ENSMUSG00000035828', u'ENSMUSG00000020372', u'ENSMUSG00000031176', u'ENSMUSG00000031971', u'ENSMUSG00000020272', u'ENSMUSG00000038241', u'ENSMUSG00000041147', u'ENSMUSG00000033392', u'ENSMUSG00000049932', u'ENSMUSG00000018217', u'ENSMUSG00000042508', u'ENSMUSG00000021959', u'ENSMUSG00000023015', u'ENSMUSG00000033323', u'ENSMUSG00000021483', u'ENSMUSG00000032254', u'ENSMUSG00000002546', u'ENSMUSG00000043065', u'ENSMUSG00000009907', u'ENSMUSG00000037725', u'ENSMUSG00000029283', u'ENSMUSG00000025925', u'ENSMUSG00000022314', u'ENSMUSG00000031004', u'ENSMUSG00000068580', u'ENSMUSG00000006398', u'ENSMUSG00000029730', u'ENSMUSG00000072082', u'ENSMUSG00000020271', u'ENSMUSG00000041096', u'ENSMUSG00000030602', u'ENSMUSG00000037098', u'ENSMUSG00000035351', u'ENSMUSG00000074476', u'ENSMUSG00000050930', u'ENSMUSG00000066979', u'ENSMUSG00000021548', u'ENSMUSG00000028549', u'ENSMUSG00000025144', u'ENSMUSG00000046010', u'ENSMUSG00000039130', u'ENSMUSG00000030079', u'ENSMUSG00000048416', u'ENSMUSG00000027326', u'ENSMUSG00000027635', u'ENSMUSG00000020074', u'ENSMUSG00000021635', u'ENSMUSG00000020486', u'ENSMUSG00000042489', u'ENSMUSG00000040549', u'ENSMUSG00000007815', u'ENSMUSG00000002297', u'ENSMUSG00000028066', u'ENSMUSG00000001403', u'ENSMUSG00000027937', u'ENSMUSG00000024137', u'ENSMUSG00000031309', u'ENSMUSG00000030397', u'ENSMUSG00000040943', u'ENSMUSG00000038902', u'ENSMUSG00000041431', u'ENSMUSG00000040945', u'ENSMUSG00000038822', u'ENSMUSG00000053647', u'ENSMUSG00000039187', u'ENSMUSG00000044502', u'ENSMUSG00000066440', u'ENSMUSG00000032376', u'ENSMUSG00000026510', u'ENSMUSG00000031787', u'ENSMUSG00000024056', u'ENSMUSG00000078652', u'ENSMUSG00000022034', u'ENSMUSG00000019923', u'ENSMUSG00000032171', u'ENSMUSG00000021258', u'ENSMUSG00000034023', u'ENSMUSG00000021256', u'ENSMUSG00000026753', u'ENSMUSG00000029166', u'ENSMUSG00000042129', u'ENSMUSG00000026349', u'ENSMUSG00000071350', u'ENSMUSG00000061665', u'ENSMUSG00000036672', u'ENSMUSG00000021918', u'ENSMUSG00000056214', u'ENSMUSG00000006715', u'ENSMUSG00000035310', u'ENSMUSG00000027699', u'ENSMUSG00000056394', u'ENSMUSG00000019256', u'ENSMUSG00000024795', u'ENSMUSG00000002835', u'ENSMUSG00000033502', u'ENSMUSG00000001833', u'ENSMUSG00000002635', u'ENSMUSG00000020326', u'ENSMUSG00000071723', u'ENSMUSG00000040274', u'ENSMUSG00000044783', u'ENSMUSG00000007721', u'ENSMUSG00000031478', u'ENSMUSG00000029466', u'ENSMUSG00000026646', u'ENSMUSG00000024943', u'ENSMUSG00000024944', u'ENSMUSG00000042688', u'ENSMUSG00000030744', u'ENSMUSG00000000184', u'ENSMUSG00000030983', u'ENSMUSG00000052139', u'ENSMUSG00000027363']), pop_n=13836, p_sm_bonferroni=1.160545454601955e-06, is_obsolete=False, GO='GO:0007049', name='cell cycle', pop_count=553, alt_ids=[], level=3, depth=3, enrichment='e', Cluster='Transient Increase', geneid_set=set([u'ENSMUSG00000028224', u'ENSMUSG00000040084', u'ENSMUSG00000023015', u'ENSMUSG00000027469', u'ENSMUSG00000037313', u'ENSMUSG00000045328', u'ENSMUSG00000024974', u'ENSMUSG00000025358', u'ENSMUSG00000059552', u'ENSMUSG00000020326', u'ENSMUSG00000032782', u'ENSMUSG00000020380', u'ENSMUSG00000022177', u'ENSMUSG00000040599', u'ENSMUSG00000022070', u'ENSMUSG00000017861', u'ENSMUSG00000027379', u'ENSMUSG00000033952', u'ENSMUSG00000038252', u'ENSMUSG00000062510', u'ENSMUSG00000029521', u'ENSMUSG00000020185', u'ENSMUSG00000002068', u'ENSMUSG00000041147', u'ENSMUSG00000051378', u'ENSMUSG00000042029', u'ENSMUSG00000027715', u'ENSMUSG00000032254', u'ENSMUSG00000043065', u'ENSMUSG00000072082', u'ENSMUSG00000027490', u'ENSMUSG00000037725', u'ENSMUSG00000027496', u'ENSMUSG00000029283', u'ENSMUSG00000021115', u'ENSMUSG00000078762', u'ENSMUSG00000038482', u'ENSMUSG00000028873', u'ENSMUSG00000027306', u'ENSMUSG00000027959', u'ENSMUSG00000023908', u'ENSMUSG00000031004', u'ENSMUSG00000024056', u'ENSMUSG00000034023', u'ENSMUSG00000029730', u'ENSMUSG00000048922', u'ENSMUSG00000019214', u'ENSMUSG00000034906', u'ENSMUSG00000028551', u'ENSMUSG00000049932', u'ENSMUSG00000002870', u'ENSMUSG00000032397', u'ENSMUSG00000035683', u'ENSMUSG00000037544', u'ENSMUSG00000021965', u'ENSMUSG00000027641', u'ENSMUSG00000034349', u'ENSMUSG00000030867', u'ENSMUSG00000047534', u'ENSMUSG00000032400', u'ENSMUSG00000028312', u'ENSMUSG00000026622', u'ENSMUSG00000020525', u'ENSMUSG00000028896', u'ENSMUSG00000032477', u'ENSMUSG00000026683', u'ENSMUSG00000027326', u'ENSMUSG00000027635', u'ENSMUSG00000073705', u'ENSMUSG00000023067', u'ENSMUSG00000040034', u'ENSMUSG00000042489', u'ENSMUSG00000006585', u'ENSMUSG00000012443', u'ENSMUSG00000029414', u'ENSMUSG00000002297', u'ENSMUSG00000028066', u'ENSMUSG00000001403', u'ENSMUSG00000036928', u'ENSMUSG00000002055', u'ENSMUSG00000051220', u'ENSMUSG00000033364', u'ENSMUSG00000006398', u'ENSMUSG00000000028', u'ENSMUSG00000041431', u'ENSMUSG00000041238', u'ENSMUSG00000039994', u'ENSMUSG00000026355', u'ENSMUSG00000039187', u'ENSMUSG00000027331', u'ENSMUSG00000018983', u'ENSMUSG00000020492', u'ENSMUSG00000041133', u'ENSMUSG00000022034', u'ENSMUSG00000024989', u'ENSMUSG00000017146', u'ENSMUSG00000027699', u'ENSMUSG00000024660', u'ENSMUSG00000037214', u'ENSMUSG00000025001', u'ENSMUSG00000046179', u'ENSMUSG00000046591', u'ENSMUSG00000005410', u'ENSMUSG00000019773', u'ENSMUSG00000003824', u'ENSMUSG00000006715', u'ENSMUSG00000035310', u'ENSMUSG00000029472', u'ENSMUSG00000024795', u'ENSMUSG00000002835', u'ENSMUSG00000020897', u'ENSMUSG00000032218', u'ENSMUSG00000028282', u'ENSMUSG00000041859', u'ENSMUSG00000030641', u'ENSMUSG00000023505', u'ENSMUSG00000032113', u'ENSMUSG00000019942', u'ENSMUSG00000056394', u'ENSMUSG00000026779', u'ENSMUSG00000027353', u'ENSMUSG00000035024', u'ENSMUSG00000061607', u'ENSMUSG00000016477', u'ENSMUSG00000069910', u'ENSMUSG00000023940', u'ENSMUSG00000028212', u'ENSMUSG00000001517', u'ENSMUSG00000074476', u'ENSMUSG00000028678', u'ENSMUSG00000028693', u'ENSMUSG00000034218', u'ENSMUSG00000022673', u'ENSMUSG00000068744', u'ENSMUSG00000038943', u'ENSMUSG00000026088', u'ENSMUSG00000026039', u'ENSMUSG00000058729', u'ENSMUSG00000017499', u'ENSMUSG00000001228', u'ENSMUSG00000031478', u'ENSMUSG00000020808', u'ENSMUSG00000017716', u'ENSMUSG00000029910', u'ENSMUSG00000036202', u'ENSMUSG00000062248', u'ENSMUSG00000005233', u'ENSMUSG00000044783', u'ENSMUSG00000022945']), symbols=u'Anapc5 Apitd1 Aspm Atm Aurka Aurkb Birc5 Bora Brca1 Brca2 Bub1 Bub1b Casp8ap2 Ccna2 Ccnb1 Ccnb2 Ccne1 Ccne2 Ccnf Ccng1 Cdc20 Cdc25a Cdc45 Cdc6 Cdc7 Cdca2 Cdca3 Cdca8 Cdk1 Cdk2 Cdkn1a Cdkn2c Cdt1 Cenpe Cep55 Chaf1a Chaf1b Chek1 Chek2 Chtf18 Ckap2 Cks2 Clspn Cntrob Dbf4 Ddias Dlgap5 Dsn1 E2f1 E2f2 E2f3 E2f7 E2f8 Ect2 Ercc6l Esco2 Fam64a Fancd2 Fanci Fbxo5 Foxm1 Gmnn H2afx Haus4 Haus5 Hells Hjurp Incenp Kif11 Kif18b Kif20b Kif23 Kif2c Knl1 Knstrn Kntc1 Lig1 Lin54 Lin9 Mad2l1 Mastl Mcm2 Mcm3 Mcm4 Mcm5 Mcm6 Mcm7 Mcm8 Mdc1 Melk Mis12 Mis18bp1 Mitd1 Mki67 Mybl2 Nasp Nbn Ncapd2 Ncapd3 Ncapg2 Ncaph Ndc80 Nek2 Nek3 Nsl1 Nuf2 Nup43 Nusap1 Pkmyt1 Plk1 Pmf1 Ppm1d Prc1 Psrc1 Racgap1 Rad50 Rbbp8 Rbl1 Rcc1 Rif1 Sass6 Sgol1 Sgol2a Ska2 Ska3 Smc1a Smc2 Smc3 Smc4 Spag5 Spc24 Spc25 Spdl1 Spice1 Stag3 Syce2 Tacc3 Tfdp1 Thap1 Ticrr Timeless Tipin Tpx2 Trp53 Ube2c Uhrf1 Usp37 Vrk1 Zwilch', symbol_set=set([u'Ncapg2', u'Rif1', 'Ticrr', 'Spdl1', u'Cep55', u'Mitd1', u'Thap1', u'Melk', u'Ccnf', u'Rbbp8', u'Mis12', u'Chek2', u'Tfdp1', u'Chek1', 'Sgol2a', u'Clspn', u'Ccng1', 'Ska3', 'Ska2', u'Fam64a', u'Mybl2', u'Lig1', u'Ccna2', 'Knl1', 'Ddias', u'Cenpe', u'Tacc3', u'Dsn1', u'Ncapd2', u'Ncapd3', u'Syce2', u'Kif11', u'Ckap2', u'Prc1', u'Smc1a', u'Rcc1', u'Hjurp', u'Cdc25a', u'Lin54', u'Casp8ap2', 'Knstrn', u'Ccnb2', u'Ccnb1', u'Racgap1', u'Aspm', u'Mdc1', u'Ndc80', u'Cdc6', u'Cdc7', u'Brca1', u'Tpx2', u'Brca2', u'Pmf1', u'Bub1b', u'Anapc5', u'Ercc6l', u'Cdt1', u'Aurka', u'Aurkb', u'Spc25', u'Nbn', u'Hells', u'Timeless', u'Cdkn1a', u'Kntc1', u'Incenp', u'Lin9', u'Stag3', u'Spag5', u'Cdk1', u'Cdk2', u'Ncaph', u'Gmnn', u'Uhrf1', 'Bora', u'Mki67', u'Nuf2', u'Esco2', u'Haus4', u'Haus5', u'Spice1', u'Nek2', u'Nek3', u'Ect2', u'Sgol1', u'Kif18b', u'Cdca3', u'Foxm1', u'Cks2', u'E2f7', u'Nasp', u'Ppm1d', u'E2f3', u'E2f2', u'E2f1', u'Ccne2', u'Ccne1', u'Pkmyt1', u'E2f8', u'Nsl1', u'Fancd2', u'Cdca2', u'Nusap1', u'Tipin', u'Cdc20', u'Sass6', u'Zwilch', u'Mcm3', u'Cdkn2c', u'Psrc1', u'Fbxo5', u'Mis18bp1', u'Ube2c', u'H2afx', u'Mcm7', u'Mcm6', u'Mcm5', u'Mcm4', u'Chaf1a', u'Mcm2', u'Chaf1b', u'Bub1', u'Cdca8', u'Mcm8', u'Kif20b', u'Smc3', u'Smc2', u'Mastl', u'Smc4', u'Kif23', u'Apitd1', u'Chtf18', u'Rad50', u'Vrk1', u'Rbl1', u'Trp53', u'Plk1', u'Atm', u'Cntrob', u'Mad2l1', u'Usp37', u'Birc5', u'Spc24', u'Nup43', u'Dbf4', u'Kif2c', u'Dlgap5', u'Cdc45', u'Fanci']), geneids='ENSMUSG00000028224 ENSMUSG00000040084 ENSMUSG00000028678 ENSMUSG00000027469 ENSMUSG00000042029 ENSMUSG00000045328 ENSMUSG00000024974 ENSMUSG00000025358 ENSMUSG00000038482 ENSMUSG00000059552 ENSMUSG00000032782 ENSMUSG00000020380 ENSMUSG00000022177 ENSMUSG00000046179 ENSMUSG00000028282 ENSMUSG00000022070 ENSMUSG00000017861 ENSMUSG00000027379 ENSMUSG00000020897 ENSMUSG00000019773 ENSMUSG00000062510 ENSMUSG00000029521 ENSMUSG00000020185 ENSMUSG00000002068 ENSMUSG00000041147 ENSMUSG00000051378 ENSMUSG00000037313 ENSMUSG00000027715 ENSMUSG00000032254 ENSMUSG00000027306 ENSMUSG00000072082 ENSMUSG00000027490 ENSMUSG00000037725 ENSMUSG00000027496 ENSMUSG00000029283 ENSMUSG00000021115 ENSMUSG00000078762 ENSMUSG00000016477 ENSMUSG00000005410 ENSMUSG00000027959 ENSMUSG00000023908 ENSMUSG00000031004 ENSMUSG00000018983 ENSMUSG00000034023 ENSMUSG00000029730 ENSMUSG00000048922 ENSMUSG00000019214 ENSMUSG00000034906 ENSMUSG00000028551 ENSMUSG00000049932 ENSMUSG00000002870 ENSMUSG00000032397 ENSMUSG00000035683 ENSMUSG00000037544 ENSMUSG00000021965 ENSMUSG00000027641 ENSMUSG00000023015 ENSMUSG00000033364 ENSMUSG00000030867 ENSMUSG00000047534 ENSMUSG00000034349 ENSMUSG00000032400 ENSMUSG00000028312 ENSMUSG00000026622 ENSMUSG00000020525 ENSMUSG00000028896 ENSMUSG00000032477 ENSMUSG00000026683 ENSMUSG00000027326 ENSMUSG00000027635 ENSMUSG00000073705 ENSMUSG00000023067 ENSMUSG00000040034 ENSMUSG00000042489 ENSMUSG00000006585 ENSMUSG00000026039 ENSMUSG00000029414 ENSMUSG00000002297 ENSMUSG00000028066 ENSMUSG00000001403 ENSMUSG00000033952 ENSMUSG00000036928 ENSMUSG00000002055 ENSMUSG00000051220 ENSMUSG00000032218 ENSMUSG00000006398 ENSMUSG00000000028 ENSMUSG00000041431 ENSMUSG00000041238 ENSMUSG00000039994 ENSMUSG00000026355 ENSMUSG00000039187 ENSMUSG00000027331 ENSMUSG00000024056 ENSMUSG00000020492 ENSMUSG00000041133 ENSMUSG00000022034 ENSMUSG00000024989 ENSMUSG00000017146 ENSMUSG00000027699 ENSMUSG00000024660 ENSMUSG00000038252 ENSMUSG00000037214 ENSMUSG00000025001 ENSMUSG00000040599 ENSMUSG00000046591 ENSMUSG00000028873 ENSMUSG00000003824 ENSMUSG00000006715 ENSMUSG00000035310 ENSMUSG00000029472 ENSMUSG00000024795 ENSMUSG00000002835 ENSMUSG00000023940 ENSMUSG00000041859 ENSMUSG00000030641 ENSMUSG00000023505 ENSMUSG00000032113 ENSMUSG00000019942 ENSMUSG00000056394 ENSMUSG00000026779 ENSMUSG00000027353 ENSMUSG00000062248 ENSMUSG00000061607 ENSMUSG00000020326 ENSMUSG00000069910 ENSMUSG00000028212 ENSMUSG00000001517 ENSMUSG00000074476 ENSMUSG00000028693 ENSMUSG00000034218 ENSMUSG00000022673 ENSMUSG00000068744 ENSMUSG00000038943 ENSMUSG00000026088 ENSMUSG00000012443 ENSMUSG00000058729 ENSMUSG00000017499 ENSMUSG00000001228 ENSMUSG00000031478 ENSMUSG00000043065 ENSMUSG00000020808 ENSMUSG00000017716 ENSMUSG00000029910 ENSMUSG00000036202 ENSMUSG00000035024 ENSMUSG00000005233 ENSMUSG00000044783 ENSMUSG00000022945', format_txt=1, hdr_idx=1, is_hdrgo=True, is_usrgo=True, hdr1usr01='**', dcnt=12, D1='BC', GO_name='cell cycle'),
    Nt(p_uncorrected=3.913269289633273e-08, study_count=7, study_n=624, namespace='biological_process', p_fdr_bh=8.849245224960258e-06, study_items=set([u'ENSMUSG00000069910', u'ENSMUSG00000040084', u'ENSMUSG00000038379', u'ENSMUSG00000027326', u'ENSMUSG00000019942', u'ENSMUSG00000020897', u'ENSMUSG00000040599']), NS='BP', pop_items=set([u'ENSMUSG00000069910', u'ENSMUSG00000022369', u'ENSMUSG00000047710', u'ENSMUSG00000038379', u'ENSMUSG00000027326', u'ENSMUSG00000019942', u'ENSMUSG00000040084', u'ENSMUSG00000032264', u'ENSMUSG00000020897', u'ENSMUSG00000040599']), pop_n=13836, p_sm_bonferroni=0.0005928994300723373, is_obsolete=False, GO='GO:0034501', name='protein localization to kinetochore', pop_count=10, alt_ids=[], level=8, depth=8, enrichment='e', Cluster='Transient Increase', geneid_set=set([u'ENSMUSG00000069910', u'ENSMUSG00000040084', u'ENSMUSG00000038379', u'ENSMUSG00000020897', u'ENSMUSG00000027326', u'ENSMUSG00000019942', u'ENSMUSG00000040599']), symbols=u'Aurkb Bub1b Cdk1 Knl1 Mis12 Spdl1 Ttk', symbol_set=set([u'Aurkb', u'Bub1b', 'Spdl1', u'Ttk', u'Cdk1', 'Knl1', u'Mis12']), geneids='ENSMUSG00000069910 ENSMUSG00000040084 ENSMUSG00000038379 ENSMUSG00000027326 ENSMUSG00000019942 ENSMUSG00000020897 ENSMUSG00000040599', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=3, D1='G', GO_name='protein localization to kinetochore'),
    Nt(p_uncorrected=2.839880208077678e-06, study_count=10, study_n=624, namespace='biological_process', p_fdr_bh=0.0003947433489227972, study_items=set([u'ENSMUSG00000028224', u'ENSMUSG00000028212', u'ENSMUSG00000028884', u'ENSMUSG00000020380', u'ENSMUSG00000002068', u'ENSMUSG00000020898', u'ENSMUSG00000034218', u'ENSMUSG00000038685', u'ENSMUSG00000036875', u'ENSMUSG00000030528']), NS='BP', pop_items=set([u'ENSMUSG00000028224', u'ENSMUSG00000026496', u'ENSMUSG00000042694', u'ENSMUSG00000018841', u'ENSMUSG00000030528', u'ENSMUSG00000031583', u'ENSMUSG00000035960', u'ENSMUSG00000030655', u'ENSMUSG00000038685', u'ENSMUSG00000058301', u'ENSMUSG00000027845', u'ENSMUSG00000028884', u'ENSMUSG00000022471', u'ENSMUSG00000031921', u'ENSMUSG00000020380', u'ENSMUSG00000038000', u'ENSMUSG00000020898', u'ENSMUSG00000023249', u'ENSMUSG00000000751', u'ENSMUSG00000024811', u'ENSMUSG00000026648', u'ENSMUSG00000028212', u'ENSMUSG00000033430', u'ENSMUSG00000002068', u'ENSMUSG00000022672', u'ENSMUSG00000038290', u'ENSMUSG00000026187', u'ENSMUSG00000091971', u'ENSMUSG00000022545', u'ENSMUSG00000022184', u'ENSMUSG00000000568', u'ENSMUSG00000029676', u'ENSMUSG00000032410', u'ENSMUSG00000036875', u'ENSMUSG00000034218', u'ENSMUSG00000025925']), pop_n=13836, p_sm_bonferroni=0.0430270250325849, is_obsolete=False, GO='GO:0000723', name='telomere maintenance', pop_count=36, alt_ids=[], level=5, depth=7, enrichment='e', Cluster='Transient Increase', geneid_set=set([u'ENSMUSG00000028224', u'ENSMUSG00000028212', u'ENSMUSG00000028884', u'ENSMUSG00000020380', u'ENSMUSG00000002068', u'ENSMUSG00000020898', u'ENSMUSG00000034218', u'ENSMUSG00000038685', u'ENSMUSG00000036875', u'ENSMUSG00000030528']), symbols=u'Atm Blm Ccne1 Ccne2 Ctc1 Dna2 Nbn Rad50 Rpa2 Rtel1', symbol_set=set([u'Atm', u'Ccne2', 'Ctc1', u'Ccne1', u'Rpa2', u'Blm', u'Dna2', u'Nbn', u'Rad50', u'Rtel1']), geneids='ENSMUSG00000028224 ENSMUSG00000028212 ENSMUSG00000028884 ENSMUSG00000020380 ENSMUSG00000002068 ENSMUSG00000020898 ENSMUSG00000034218 ENSMUSG00000030528 ENSMUSG00000036875 ENSMUSG00000038685', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=15, D1='ABDH', GO_name='telomere maintenance'),
    Nt(p_uncorrected=9.548068345280445e-07, study_count=7, study_n=624, namespace='biological_process', p_fdr_bh=0.00015389657819079151, study_items=set([u'ENSMUSG00000028884', u'ENSMUSG00000030346', u'ENSMUSG00000032113', u'ENSMUSG00000027323', u'ENSMUSG00000035455', u'ENSMUSG00000038685', u'ENSMUSG00000009628']), NS='BP', pop_items=set([u'ENSMUSG00000028884', u'ENSMUSG00000030346', u'ENSMUSG00000032113', u'ENSMUSG00000052144', u'ENSMUSG00000033430', u'ENSMUSG00000027323', u'ENSMUSG00000035455', u'ENSMUSG00000036940', u'ENSMUSG00000030697', u'ENSMUSG00000041974', u'ENSMUSG00000038685', u'ENSMUSG00000009628', u'ENSMUSG00000034748', u'ENSMUSG00000075324']), pop_n=13836, p_sm_bonferroni=0.014466278349934403, is_obsolete=False, GO='GO:0010569', name='regulation of double-strand break repair via homologous recombination', pop_count=14, alt_ids=[], level=7, depth=9, enrichment='e', Cluster='Transient Increase', geneid_set=set([u'ENSMUSG00000035455', u'ENSMUSG00000028884', u'ENSMUSG00000030346', u'ENSMUSG00000032113', u'ENSMUSG00000038685', u'ENSMUSG00000009628', u'ENSMUSG00000027323']), symbols=u'Chek1 Fignl1 Rad51 Rad51ap1 Rpa2 Rtel1 Tex15', symbol_set=set([u'Fignl1', u'Tex15', u'Rpa2', u'Rad51ap1', u'Rad51', u'Rtel1', u'Chek1']), geneids='ENSMUSG00000028884 ENSMUSG00000030346 ENSMUSG00000032113 ENSMUSG00000027323 ENSMUSG00000035455 ENSMUSG00000038685 ENSMUSG00000009628', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=4, D1='A', GO_name='regulation of double-strand break repair via homologous recombination'),
    Nt(p_uncorrected=2.9401082193258835e-06, study_count=7, study_n=624, namespace='biological_process', p_fdr_bh=0.00040495981482733146, study_items=set([u'ENSMUSG00000031004', u'ENSMUSG00000027496', u'ENSMUSG00000025474', u'ENSMUSG00000027323', u'ENSMUSG00000024974', u'ENSMUSG00000000759', u'ENSMUSG00000041133']), NS='BP', pop_items=set([u'ENSMUSG00000032498', u'ENSMUSG00000051786', u'ENSMUSG00000027263', u'ENSMUSG00000031004', u'ENSMUSG00000027496', u'ENSMUSG00000025474', u'ENSMUSG00000027323', u'ENSMUSG00000032410', u'ENSMUSG00000005493', u'ENSMUSG00000000759', u'ENSMUSG00000024974', u'ENSMUSG00000068117', u'ENSMUSG00000041133', u'ENSMUSG00000000751', u'ENSMUSG00000033790', u'ENSMUSG00000079109']), pop_n=13836, p_sm_bonferroni=0.044545579631006464, is_obsolete=False, GO='GO:0007126', name='meiotic nuclear division', pop_count=16, alt_ids=[], level=3, depth=6, enrichment='e', Cluster='Transient Increase', geneid_set=set([u'ENSMUSG00000024974', u'ENSMUSG00000000759', u'ENSMUSG00000031004', u'ENSMUSG00000027496', u'ENSMUSG00000041133', u'ENSMUSG00000025474', u'ENSMUSG00000027323']), symbols=u'Aurka Mki67 Rad51 Smc1a Smc3 Tubgcp2 Tubgcp3', symbol_set=set([u'Smc1a', u'Mki67', u'Smc3', u'Aurka', u'Rad51', u'Tubgcp2', u'Tubgcp3']), geneids='ENSMUSG00000031004 ENSMUSG00000027496 ENSMUSG00000025474 ENSMUSG00000027323 ENSMUSG00000024974 ENSMUSG00000000759 ENSMUSG00000041133', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=9, D1='BHK', GO_name='meiotic nuclear division'),
    Nt(p_uncorrected=7.750347293209027e-11, study_count=16, study_n=624, namespace='biological_process', p_fdr_bh=4.697020473576398e-08, study_items=set([u'ENSMUSG00000028224', u'ENSMUSG00000021569', u'ENSMUSG00000041238', u'ENSMUSG00000039748', u'ENSMUSG00000036928', u'ENSMUSG00000020380', u'ENSMUSG00000041133', u'ENSMUSG00000003824', u'ENSMUSG00000024974', u'ENSMUSG00000027496', u'ENSMUSG00000025358', u'ENSMUSG00000026622', u'ENSMUSG00000026039', u'ENSMUSG00000049932', u'ENSMUSG00000019303', u'ENSMUSG00000009628']), NS='BP', pop_items=set([u'ENSMUSG00000028224', u'ENSMUSG00000060657', u'ENSMUSG00000020349', u'ENSMUSG00000021569', u'ENSMUSG00000036928', u'ENSMUSG00000024974', u'ENSMUSG00000005493', u'ENSMUSG00000025358', u'ENSMUSG00000049932', u'ENSMUSG00000031928', u'ENSMUSG00000036196', u'ENSMUSG00000041238', u'ENSMUSG00000032221', u'ENSMUSG00000020380', u'ENSMUSG00000002190', u'ENSMUSG00000009628', u'ENSMUSG00000015149', u'ENSMUSG00000026039', u'ENSMUSG00000024033', u'ENSMUSG00000020152', u'ENSMUSG00000039748', u'ENSMUSG00000025862', u'ENSMUSG00000066979', u'ENSMUSG00000033392', u'ENSMUSG00000043410', u'ENSMUSG00000068117', u'ENSMUSG00000019303', u'ENSMUSG00000029279', u'ENSMUSG00000027496', u'ENSMUSG00000042396', u'ENSMUSG00000041133', u'ENSMUSG00000026341', u'ENSMUSG00000003824', u'ENSMUSG00000063576', u'ENSMUSG00000026622', u'ENSMUSG00000015597', u'ENSMUSG00000041775', u'ENSMUSG00000005893', u'ENSMUSG00000021395', u'ENSMUSG00000079470']), pop_n=13836, p_sm_bonferroni=1.1742551183940996e-06, is_obsolete=False, GO='GO:0051321', name='meiotic cell cycle', pop_count=40, alt_ids=[], level=3, depth=4, enrichment='e', Cluster='Transient Increase', geneid_set=set([u'ENSMUSG00000028224', u'ENSMUSG00000021569', u'ENSMUSG00000039748', u'ENSMUSG00000036928', u'ENSMUSG00000024974', u'ENSMUSG00000025358', u'ENSMUSG00000049932', u'ENSMUSG00000019303', u'ENSMUSG00000026039', u'ENSMUSG00000041238', u'ENSMUSG00000027496', u'ENSMUSG00000020380', u'ENSMUSG00000009628', u'ENSMUSG00000026622', u'ENSMUSG00000041133', u'ENSMUSG00000003824']), symbols=u'Aurka Cdk2 Exo1 H2afx Nbn Nek2 Psmc3ip Rad50 Rbbp8 Sgol2a Smc1a Smc3 Stag3 Syce2 Tex15 Trip13', symbol_set=set([u'Smc1a', u'Rbbp8', u'Nek2', 'Sgol2a', u'Tex15', u'Stag3', u'Smc3', u'Exo1', u'H2afx', u'Psmc3ip', u'Cdk2', u'Syce2', u'Nbn', u'Rad50', u'Trip13', u'Aurka']), geneids='ENSMUSG00000028224 ENSMUSG00000021569 ENSMUSG00000041238 ENSMUSG00000039748 ENSMUSG00000027496 ENSMUSG00000020380 ENSMUSG00000041133 ENSMUSG00000009628 ENSMUSG00000024974 ENSMUSG00000036928 ENSMUSG00000025358 ENSMUSG00000026622 ENSMUSG00000026039 ENSMUSG00000049932 ENSMUSG00000019303 ENSMUSG00000003824', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=3, D1='BCK', GO_name='meiotic cell cycle'),
    Nt(p_uncorrected=9.97694118363845e-11, study_count=20, study_n=624, namespace='biological_process', p_fdr_bh=5.3985941383323624e-08, study_items=set([u'ENSMUSG00000035266', u'ENSMUSG00000028224', u'ENSMUSG00000049932', u'ENSMUSG00000028884', u'ENSMUSG00000027353', u'ENSMUSG00000041238', u'ENSMUSG00000030346', u'ENSMUSG00000059323', u'ENSMUSG00000020380', u'ENSMUSG00000028702', u'ENSMUSG00000041147', u'ENSMUSG00000034218', u'ENSMUSG00000017146', u'ENSMUSG00000020608', u'ENSMUSG00000045751', u'ENSMUSG00000030528', u'ENSMUSG00000027323', u'ENSMUSG00000078773', u'ENSMUSG00000051235', u'ENSMUSG00000044702']), NS='BP', pop_items=set([u'ENSMUSG00000028224', u'ENSMUSG00000026914', u'ENSMUSG00000018841', u'ENSMUSG00000059323', u'ENSMUSG00000074781', u'ENSMUSG00000020413', u'ENSMUSG00000045751', u'ENSMUSG00000025374', u'ENSMUSG00000021264', u'ENSMUSG00000041974', u'ENSMUSG00000030528', u'ENSMUSG00000049932', u'ENSMUSG00000044702', u'ENSMUSG00000028884', u'ENSMUSG00000041238', u'ENSMUSG00000028933', u'ENSMUSG00000020380', u'ENSMUSG00000053914', u'ENSMUSG00000066440', u'ENSMUSG00000026434', u'ENSMUSG00000026107', u'ENSMUSG00000017146', u'ENSMUSG00000020752', u'ENSMUSG00000024317', u'ENSMUSG00000044627', u'ENSMUSG00000032705', u'ENSMUSG00000021287', u'ENSMUSG00000000751', u'ENSMUSG00000078773', u'ENSMUSG00000035266', u'ENSMUSG00000033458', u'ENSMUSG00000030750', u'ENSMUSG00000027353', u'ENSMUSG00000058298', u'ENSMUSG00000030346', u'ENSMUSG00000039623', u'ENSMUSG00000014243', u'ENSMUSG00000034154', u'ENSMUSG00000022545', u'ENSMUSG00000041147', u'ENSMUSG00000024943', u'ENSMUSG00000051238', u'ENSMUSG00000030243', u'ENSMUSG00000031072', u'ENSMUSG00000062270', u'ENSMUSG00000068264', u'ENSMUSG00000020608', u'ENSMUSG00000025066', u'ENSMUSG00000051235', u'ENSMUSG00000042541', u'ENSMUSG00000039738', u'ENSMUSG00000025218', u'ENSMUSG00000007646', u'ENSMUSG00000059586', u'ENSMUSG00000028702', u'ENSMUSG00000012483', u'ENSMUSG00000032512', u'ENSMUSG00000030166', u'ENSMUSG00000034218', u'ENSMUSG00000028820', u'ENSMUSG00000027323']), pop_n=13836, p_sm_bonferroni=1.5116063587330615e-06, is_obsolete=False, GO='GO:0000724', name='double-strand break repair via homologous recombination', pop_count=61, alt_ids=['GO:0016924'], level=7, depth=9, enrichment='e', Cluster='Transient Increase', geneid_set=set([u'ENSMUSG00000035266', u'ENSMUSG00000028224', u'ENSMUSG00000020608', u'ENSMUSG00000030346', u'ENSMUSG00000059323', u'ENSMUSG00000041147', u'ENSMUSG00000045751', u'ENSMUSG00000030528', u'ENSMUSG00000049932', u'ENSMUSG00000051235', u'ENSMUSG00000044702', u'ENSMUSG00000028884', u'ENSMUSG00000041238', u'ENSMUSG00000020380', u'ENSMUSG00000028702', u'ENSMUSG00000027323', u'ENSMUSG00000017146', u'ENSMUSG00000027353', u'ENSMUSG00000034218', u'ENSMUSG00000078773']), symbols=u'Atm Blm Brca1 Brca2 Gen1 H2afx Helq Mcm8 Mms22l Nbn Palb2 Rad50 Rad51 Rad51ap1 Rad54b Rad54l Rbbp8 Rpa2 Smc6 Tonsl', symbol_set=set([u'Brca1', u'Brca2', u'Helq', u'Rad54b', u'Rad54l', u'Palb2', u'Tonsl', u'H2afx', u'Mms22l', u'Atm', u'Smc6', u'Blm', u'Rad51ap1', u'Rbbp8', u'Nbn', u'Rad51', u'Rad50', u'Gen1', u'Rpa2', u'Mcm8']), geneids='ENSMUSG00000028224 ENSMUSG00000035266 ENSMUSG00000049932 ENSMUSG00000028884 ENSMUSG00000020608 ENSMUSG00000041238 ENSMUSG00000030346 ENSMUSG00000059323 ENSMUSG00000020380 ENSMUSG00000028702 ENSMUSG00000027323 ENSMUSG00000045751 ENSMUSG00000017146 ENSMUSG00000027353 ENSMUSG00000034218 ENSMUSG00000030528 ENSMUSG00000041147 ENSMUSG00000078773 ENSMUSG00000051235 ENSMUSG00000044702', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=3, D1='BDF', GO_name='double-strand break repair via homologous recombination'),
    Nt(p_uncorrected=6.079901029339501e-07, study_count=10, study_n=624, namespace='biological_process', p_fdr_bh=0.00010118906047752281, study_items=set([u'ENSMUSG00000071516', u'ENSMUSG00000049932', u'ENSMUSG00000068855', u'ENSMUSG00000061991', u'ENSMUSG00000069272', u'ENSMUSG00000069302', u'ENSMUSG00000069301', u'ENSMUSG00000025001', u'ENSMUSG00000061615', u'ENSMUSG00000063021']), NS='BP', pop_items=set([u'ENSMUSG00000002052', u'ENSMUSG00000049932', u'ENSMUSG00000071516', u'ENSMUSG00000040007', u'ENSMUSG00000031358', u'ENSMUSG00000069270', u'ENSMUSG00000069272', u'ENSMUSG00000020086', u'ENSMUSG00000069301', u'ENSMUSG00000069302', u'ENSMUSG00000039477', u'ENSMUSG00000047669', u'ENSMUSG00000031393', u'ENSMUSG00000039231', u'ENSMUSG00000039741', u'ENSMUSG00000068855', u'ENSMUSG00000060032', u'ENSMUSG00000023977', u'ENSMUSG00000078851', u'ENSMUSG00000063689', u'ENSMUSG00000062270', u'ENSMUSG00000025001', u'ENSMUSG00000061615', u'ENSMUSG00000031422', u'ENSMUSG00000015937', u'ENSMUSG00000061991', u'ENSMUSG00000037894', u'ENSMUSG00000048154', u'ENSMUSG00000063021', u'ENSMUSG00000025578', u'ENSMUSG00000041126']), pop_n=13836, p_sm_bonferroni=0.009211658049552278, is_obsolete=False, GO='GO:0006342', name='chromatin silencing', pop_count=31, alt_ids=['GO:0016440'], level=4, depth=11, enrichment='e', Cluster='Transient Increase', geneid_set=set([u'ENSMUSG00000071516', u'ENSMUSG00000061615', u'ENSMUSG00000068855', u'ENSMUSG00000061991', u'ENSMUSG00000069272', u'ENSMUSG00000063021', u'ENSMUSG00000069301', u'ENSMUSG00000069302', u'ENSMUSG00000049932', u'ENSMUSG00000025001']), symbols=u'H2afx Hells Hist1h2ab Hist1h2ae Hist1h2af Hist1h2ag Hist1h2ah Hist1h2ai Hist1h2ak Hist2h2ac', symbol_set=set([u'Hells', u'H2afx', u'Hist1h2ai', u'Hist1h2ah', u'Hist1h2ak', u'Hist1h2ae', u'Hist1h2ag', u'Hist1h2af', u'Hist2h2ac', u'Hist1h2ab']), geneids='ENSMUSG00000071516 ENSMUSG00000061615 ENSMUSG00000068855 ENSMUSG00000061991 ENSMUSG00000069272 ENSMUSG00000069302 ENSMUSG00000069301 ENSMUSG00000025001 ENSMUSG00000049932 ENSMUSG00000063021', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=9, D1='ABCH', GO_name='chromatin silencing'),
    Nt(p_uncorrected=3.126181591424736e-06, study_count=6, study_n=624, namespace='biological_process', p_fdr_bh=0.000426709705330416, study_items=set([u'ENSMUSG00000028212', u'ENSMUSG00000036928', u'ENSMUSG00000034023', u'ENSMUSG00000002068', u'ENSMUSG00000034329', u'ENSMUSG00000009628']), NS='BP', pop_items=set([u'ENSMUSG00000032498', u'ENSMUSG00000031928', u'ENSMUSG00000028212', u'ENSMUSG00000036817', u'ENSMUSG00000036928', u'ENSMUSG00000034023', u'ENSMUSG00000002068', u'ENSMUSG00000005493', u'ENSMUSG00000028614', u'ENSMUSG00000034329', u'ENSMUSG00000009628']), pop_n=13836, p_sm_bonferroni=0.04736477729167617, is_obsolete=False, GO='GO:0007129', name='synapsis', pop_count=11, alt_ids=[], level=4, depth=6, enrichment='e', Cluster='Transient Increase', geneid_set=set([u'ENSMUSG00000028212', u'ENSMUSG00000036928', u'ENSMUSG00000034329', u'ENSMUSG00000034023', u'ENSMUSG00000009628', u'ENSMUSG00000002068']), symbols=u'Brip1 Ccne1 Ccne2 Fancd2 Stag3 Tex15', symbol_set=set([u'Ccne2', u'Stag3', u'Ccne1', u'Tex15', u'Fancd2', u'Brip1']), geneids='ENSMUSG00000028212 ENSMUSG00000036928 ENSMUSG00000034023 ENSMUSG00000002068 ENSMUSG00000034329 ENSMUSG00000009628', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=0, D1='BHK', GO_name='synapsis'),
    Nt(p_uncorrected='', study_count='', study_n='', namespace='', p_fdr_bh='', study_items='', NS='BP', pop_items='', pop_n='', p_sm_bonferroni='', is_obsolete='', GO='GO:0051179', name='', pop_count='', alt_ids='', level=1, depth=1, enrichment='', Cluster='', geneid_set='', symbols='', symbol_set='', geneids='', format_txt=1, hdr_idx=1, is_hdrgo=True, is_usrgo=False, hdr1usr01='*', dcnt=2176, D1='G', GO_name='localization'),
    Nt(p_uncorrected=0.00012860653072037162, study_count=4, study_n=624, namespace='biological_process', p_fdr_bh=0.010589769276871469, study_items=set([u'ENSMUSG00000062727', u'ENSMUSG00000058385', u'ENSMUSG00000047246', u'ENSMUSG00000069268']), NS='BP', pop_items=set([u'ENSMUSG00000058385', u'ENSMUSG00000047246', u'ENSMUSG00000068854', u'ENSMUSG00000079641', u'ENSMUSG00000018102', u'ENSMUSG00000062727', u'ENSMUSG00000069268']), pop_n=13836, p_sm_bonferroni=1.0, is_obsolete=False, GO='GO:0002227', name='innate immune response in mucosa', pop_count=7, alt_ids=[], level=4, depth=5, enrichment='e', Cluster='Transient Increase', geneid_set=set([u'ENSMUSG00000062727', u'ENSMUSG00000058385', u'ENSMUSG00000047246', u'ENSMUSG00000069268']), symbols=u'Hist1h2be Hist1h2bf Hist1h2bg Hist1h2bk', symbol_set=set([u'Hist1h2be', u'Hist1h2bf', u'Hist1h2bg', u'Hist1h2bk']), geneids='ENSMUSG00000062727 ENSMUSG00000058385 ENSMUSG00000047246 ENSMUSG00000069268', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=0, D1='FL', GO_name='innate immune response in mucosa'),
    Nt(p_uncorrected='', study_count='', study_n='', namespace='', p_fdr_bh='', study_items='', NS='BP', pop_items='', pop_n='', p_sm_bonferroni='', is_obsolete='', GO='GO:0032501', name='', pop_count='', alt_ids='', level=1, depth=1, enrichment='', Cluster='', geneid_set='', symbols='', symbol_set='', geneids='', format_txt=1, hdr_idx=1, is_hdrgo=True, is_usrgo=False, hdr1usr01='*', dcnt=1011, D1='J', GO_name='multicellular organismal process'),
    Nt(p_uncorrected='', study_count='', study_n='', namespace='', p_fdr_bh='', study_items='', NS='BP', pop_items='', pop_n='', p_sm_bonferroni='', is_obsolete='', GO='GO:0008283', name='', pop_count='', alt_ids='', level=2, depth=2, enrichment='', Cluster='', geneid_set='', symbols='', symbol_set='', geneids='', format_txt=1, hdr_idx=1, is_hdrgo=True, is_usrgo=False, hdr1usr01='*', dcnt=159, D1='C', GO_name='cell proliferation'),
    Nt(p_uncorrected=1.8083719736883525e-05, study_count=6, study_n=624, namespace='biological_process', p_fdr_bh=0.002044674908459122, study_items=set([u'ENSMUSG00000028224', u'ENSMUSG00000020380', u'ENSMUSG00000033762', u'ENSMUSG00000035842', u'ENSMUSG00000038685', u'ENSMUSG00000038774']), NS='BP', pop_items=set([u'ENSMUSG00000028224', u'ENSMUSG00000031928', u'ENSMUSG00000022471', u'ENSMUSG00000026187', u'ENSMUSG00000020380', u'ENSMUSG00000029676', u'ENSMUSG00000033762', u'ENSMUSG00000020079', u'ENSMUSG00000030243', u'ENSMUSG00000035842', u'ENSMUSG00000031583', u'ENSMUSG00000038685', u'ENSMUSG00000037149', u'ENSMUSG00000038774']), pop_n=13836, p_sm_bonferroni=0.27398643773352227, is_obsolete=False, GO='GO:0032508', name='DNA duplex unwinding', pop_count=14, alt_ids=[], level=7, depth=7, enrichment='e', Cluster='Transient Increase', geneid_set=set([u'ENSMUSG00000028224', u'ENSMUSG00000038774', u'ENSMUSG00000035842', u'ENSMUSG00000038685', u'ENSMUSG00000020380', u'ENSMUSG00000033762']), symbols=u'Ascc3 Ddx11 Nbn Rad50 Recql4 Rtel1', symbol_set=set([u'Recql4', u'Ddx11', u'Nbn', u'Rad50', u'Ascc3', u'Rtel1']), geneids='ENSMUSG00000028224 ENSMUSG00000020380 ENSMUSG00000033762 ENSMUSG00000035842 ENSMUSG00000038685 ENSMUSG00000038774', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=7, D1='BH', GO_name='DNA duplex unwinding'),
    Nt(p_uncorrected=5.1275332748780534e-11, study_count=93, study_n=624, namespace='biological_process', p_fdr_bh=3.774646010782965e-08, study_items=set([u'ENSMUSG00000028224', u'ENSMUSG00000046591', u'ENSMUSG00000003873', u'ENSMUSG00000046295', u'ENSMUSG00000021668', u'ENSMUSG00000024974', u'ENSMUSG00000025358', u'ENSMUSG00000059552', u'ENSMUSG00000007080', u'ENSMUSG00000020380', u'ENSMUSG00000027067', u'ENSMUSG00000025507', u'ENSMUSG00000017146', u'ENSMUSG00000020898', u'ENSMUSG00000034329', u'ENSMUSG00000039748', u'ENSMUSG00000029521', u'ENSMUSG00000020185', u'ENSMUSG00000041147', u'ENSMUSG00000009628', u'ENSMUSG00000032555', u'ENSMUSG00000023067', u'ENSMUSG00000036875', u'ENSMUSG00000038644', u'ENSMUSG00000032815', u'ENSMUSG00000034023', u'ENSMUSG00000029730', u'ENSMUSG00000045102', u'ENSMUSG00000035842', u'ENSMUSG00000038685', u'ENSMUSG00000049932', u'ENSMUSG00000056394', u'ENSMUSG00000032397', u'ENSMUSG00000028884', u'ENSMUSG00000030609', u'ENSMUSG00000078773', u'ENSMUSG00000032409', u'ENSMUSG00000022906', u'ENSMUSG00000045751', u'ENSMUSG00000031311', u'ENSMUSG00000051768', u'ENSMUSG00000036097', u'ENSMUSG00000037474', u'ENSMUSG00000027323', u'ENSMUSG00000005370', u'ENSMUSG00000042489', u'ENSMUSG00000034218', u'ENSMUSG00000027242', u'ENSMUSG00000038774', u'ENSMUSG00000026196', u'ENSMUSG00000030254', u'ENSMUSG00000030528', u'ENSMUSG00000036086', u'ENSMUSG00000041238', u'ENSMUSG00000039994', u'ENSMUSG00000039187', u'ENSMUSG00000020914', u'ENSMUSG00000034206', u'ENSMUSG00000040204', u'ENSMUSG00000041133', u'ENSMUSG00000024742', u'ENSMUSG00000035365', u'ENSMUSG00000026669', u'ENSMUSG00000005481', u'ENSMUSG00000028560', u'ENSMUSG00000051235', u'ENSMUSG00000024521', u'ENSMUSG00000028702', u'ENSMUSG00000002221', u'ENSMUSG00000035764', u'ENSMUSG00000027342', u'ENSMUSG00000020471', u'ENSMUSG00000002835', u'ENSMUSG00000044702', u'ENSMUSG00000030641', u'ENSMUSG00000032113', u'ENSMUSG00000030726', u'ENSMUSG00000027353', u'ENSMUSG00000002748', u'ENSMUSG00000061607', u'ENSMUSG00000036822', u'ENSMUSG00000001517', u'ENSMUSG00000030346', u'ENSMUSG00000073705', u'ENSMUSG00000035958', u'ENSMUSG00000023953', u'ENSMUSG00000017550', u'ENSMUSG00000001228', u'ENSMUSG00000002083', u'ENSMUSG00000036202', u'ENSMUSG00000049502', u'ENSMUSG00000020608', u'ENSMUSG00000022945']), NS='BP', pop_items=set([u'ENSMUSG00000033721', u'ENSMUSG00000047617', u'ENSMUSG00000026496', u'ENSMUSG00000003873', u'ENSMUSG00000047757', u'ENSMUSG00000053914', u'ENSMUSG00000046591', u'ENSMUSG00000031583', u'ENSMUSG00000016528', u'ENSMUSG00000041974', u'ENSMUSG00000007080', u'ENSMUSG00000027845', u'ENSMUSG00000027663', u'ENSMUSG00000028933', u'ENSMUSG00000027067', u'ENSMUSG00000019470', u'ENSMUSG00000017146', u'ENSMUSG00000020752', u'ENSMUSG00000021400', u'ENSMUSG00000030166', u'ENSMUSG00000042228', u'ENSMUSG00000059981', u'ENSMUSG00000031347', u'ENSMUSG00000061288', u'ENSMUSG00000023067', u'ENSMUSG00000035726', u'ENSMUSG00000026439', u'ENSMUSG00000026429', u'ENSMUSG00000025932', u'ENSMUSG00000036390', u'ENSMUSG00000039615', u'ENSMUSG00000025939', u'ENSMUSG00000069495', u'ENSMUSG00000024429', u'ENSMUSG00000056394', u'ENSMUSG00000073684', u'ENSMUSG00000031644', u'ENSMUSG00000053175', u'ENSMUSG00000022710', u'ENSMUSG00000024193', u'ENSMUSG00000024767', u'ENSMUSG00000006599', u'ENSMUSG00000036781', u'ENSMUSG00000046806', u'ENSMUSG00000021133', u'ENSMUSG00000058761', u'ENSMUSG00000069089', u'ENSMUSG00000024906', u'ENSMUSG00000022545', u'ENSMUSG00000029387', u'ENSMUSG00000005370', u'ENSMUSG00000034218', u'ENSMUSG00000038225', u'ENSMUSG00000027242', u'ENSMUSG00000068264', u'ENSMUSG00000025159', u'ENSMUSG00000030400', u'ENSMUSG00000041238', u'ENSMUSG00000020914', u'ENSMUSG00000030493', u'ENSMUSG00000040204', u'ENSMUSG00000004018', u'ENSMUSG00000092118', u'ENSMUSG00000025269', u'ENSMUSG00000051768', u'ENSMUSG00000039623', u'ENSMUSG00000063358', u'ENSMUSG00000035486', u'ENSMUSG00000030538', u'ENSMUSG00000026187', u'ENSMUSG00000031422', u'ENSMUSG00000035764', u'ENSMUSG00000021245', u'ENSMUSG00000025878', u'ENSMUSG00000031201', u'ENSMUSG00000025077', u'ENSMUSG00000044702', u'ENSMUSG00000003549', u'ENSMUSG00000036061', u'ENSMUSG00000032113', u'ENSMUSG00000029003', u'ENSMUSG00000061175', u'ENSMUSG00000038005', u'ENSMUSG00000062270', u'ENSMUSG00000061607', u'ENSMUSG00000024151', u'ENSMUSG00000005871', u'ENSMUSG00000022672', u'ENSMUSG00000017550', u'ENSMUSG00000001228', u'ENSMUSG00000012483', u'ENSMUSG00000036202', u'ENSMUSG00000015971', u'ENSMUSG00000064289', u'ENSMUSG00000079109', u'ENSMUSG00000046295', u'ENSMUSG00000021668', u'ENSMUSG00000024974', u'ENSMUSG00000020694', u'ENSMUSG00000020697', u'ENSMUSG00000025358', u'ENSMUSG00000030726', u'ENSMUSG00000029591', u'ENSMUSG00000030750', u'ENSMUSG00000030994', u'ENSMUSG00000022471', u'ENSMUSG00000030990', u'ENSMUSG00000025616', u'ENSMUSG00000020381', u'ENSMUSG00000020380', u'ENSMUSG00000020898', u'ENSMUSG00000034329', u'ENSMUSG00000037487', u'ENSMUSG00000035234', u'ENSMUSG00000029524', u'ENSMUSG00000039748', u'ENSMUSG00000029521', u'ENSMUSG00000033712', u'ENSMUSG00000023932', u'ENSMUSG00000020185', u'ENSMUSG00000003868', u'ENSMUSG00000042185', u'ENSMUSG00000038069', u'ENSMUSG00000031575', u'ENSMUSG00000030051', u'ENSMUSG00000021615', u'ENSMUSG00000059772', u'ENSMUSG00000017291', u'ENSMUSG00000021470', u'ENSMUSG00000028329', u'ENSMUSG00000034023', u'ENSMUSG00000030271', u'ENSMUSG00000045102', u'ENSMUSG00000022945', u'ENSMUSG00000032397', u'ENSMUSG00000078578', u'ENSMUSG00000014850', u'ENSMUSG00000042349', u'ENSMUSG00000078671', u'ENSMUSG00000002661', u'ENSMUSG00000078773', u'ENSMUSG00000032409', u'ENSMUSG00000022906', u'ENSMUSG00000002963', u'ENSMUSG00000031628', u'ENSMUSG00000031095', u'ENSMUSG00000049717', u'ENSMUSG00000036097', u'ENSMUSG00000028354', u'ENSMUSG00000018841', u'ENSMUSG00000031820', u'ENSMUSG00000026842', u'ENSMUSG00000020413', u'ENSMUSG00000028669', u'ENSMUSG00000020415', u'ENSMUSG00000030655', u'ENSMUSG00000010067', u'ENSMUSG00000038544', u'ENSMUSG00000021597', u'ENSMUSG00000006288', u'ENSMUSG00000036278', u'ENSMUSG00000025899', u'ENSMUSG00000034206', u'ENSMUSG00000020228', u'ENSMUSG00000014074', u'ENSMUSG00000000148', u'ENSMUSG00000001729', u'ENSMUSG00000041133', u'ENSMUSG00000025384', u'ENSMUSG00000033458', u'ENSMUSG00000033596', u'ENSMUSG00000001924', u'ENSMUSG00000059586', u'ENSMUSG00000002109', u'ENSMUSG00000026669', u'ENSMUSG00000005481', u'ENSMUSG00000009555', u'ENSMUSG00000028560', u'ENSMUSG00000055884', u'ENSMUSG00000024521', u'ENSMUSG00000027342', u'ENSMUSG00000026219', u'ENSMUSG00000043909', u'ENSMUSG00000021258', u'ENSMUSG00000055401', u'ENSMUSG00000040850', u'ENSMUSG00000031446', u'ENSMUSG00000031536', u'ENSMUSG00000031928', u'ENSMUSG00000049932', u'ENSMUSG00000037355', u'ENSMUSG00000028914', u'ENSMUSG00000035401', u'ENSMUSG00000026107', u'ENSMUSG00000058594', u'ENSMUSG00000002748', u'ENSMUSG00000003813', u'ENSMUSG00000001517', u'ENSMUSG00000030346', u'ENSMUSG00000021276', u'ENSMUSG00000090112', u'ENSMUSG00000024382', u'ENSMUSG00000026082', u'ENSMUSG00000073705', u'ENSMUSG00000052934', u'ENSMUSG00000035390', u'ENSMUSG00000033454', u'ENSMUSG00000040174', u'ENSMUSG00000002083', u'ENSMUSG00000019970', u'ENSMUSG00000049502', u'ENSMUSG00000032534', u'ENSMUSG00000053436', u'ENSMUSG00000006335', u'ENSMUSG00000027544', u'ENSMUSG00000074781', u'ENSMUSG00000038425', u'ENSMUSG00000029920', u'ENSMUSG00000025507', u'ENSMUSG00000070348', u'ENSMUSG00000028820', u'ENSMUSG00000022248', u'ENSMUSG00000020063', u'ENSMUSG00000039354', u'ENSMUSG00000007646', u'ENSMUSG00000025261', u'ENSMUSG00000039231', u'ENSMUSG00000020423', u'ENSMUSG00000021690', u'ENSMUSG00000021694', u'ENSMUSG00000021287', u'ENSMUSG00000028629', u'ENSMUSG00000025218', u'ENSMUSG00000022400', u'ENSMUSG00000047989', u'ENSMUSG00000036875', u'ENSMUSG00000068205', u'ENSMUSG00000059552', u'ENSMUSG00000035842', u'ENSMUSG00000028411', u'ENSMUSG00000059263', u'ENSMUSG00000020287', u'ENSMUSG00000000552', u'ENSMUSG00000034345', u'ENSMUSG00000037461', u'ENSMUSG00000018750', u'ENSMUSG00000021461', u'ENSMUSG00000014243', u'ENSMUSG00000031311', u'ENSMUSG00000031314', u'ENSMUSG00000037262', u'ENSMUSG00000022141', u'ENSMUSG00000048668', u'ENSMUSG00000038774', u'ENSMUSG00000031229', u'ENSMUSG00000055932', u'ENSMUSG00000027424', u'ENSMUSG00000036086', u'ENSMUSG00000029026', u'ENSMUSG00000039994', u'ENSMUSG00000032267', u'ENSMUSG00000090083', u'ENSMUSG00000054051', u'ENSMUSG00000079235', u'ENSMUSG00000024742', u'ENSMUSG00000001524', u'ENSMUSG00000024740', u'ENSMUSG00000026914', u'ENSMUSG00000038369', u'ENSMUSG00000063065', u'ENSMUSG00000035365', u'ENSMUSG00000044167', u'ENSMUSG00000020546', u'ENSMUSG00000043987', u'ENSMUSG00000030079', u'ENSMUSG00000033102', u'ENSMUSG00000037761', u'ENSMUSG00000057329', u'ENSMUSG00000028702', u'ENSMUSG00000024735', u'ENSMUSG00000020471', u'ENSMUSG00000027104', u'ENSMUSG00000032498', u'ENSMUSG00000028680', u'ENSMUSG00000039738', u'ENSMUSG00000025374', u'ENSMUSG00000030034', u'ENSMUSG00000035960', u'ENSMUSG00000030641', u'ENSMUSG00000037111', u'ENSMUSG00000070520', u'ENSMUSG00000027353', u'ENSMUSG00000030451', u'ENSMUSG00000028426', u'ENSMUSG00000040865', u'ENSMUSG00000031986', u'ENSMUSG00000027671', u'ENSMUSG00000028453', u'ENSMUSG00000028452', u'ENSMUSG00000041997', u'ENSMUSG00000020608', u'ENSMUSG00000026077', u'ENSMUSG00000028224', u'ENSMUSG00000000355', u'ENSMUSG00000021264', u'ENSMUSG00000053110', u'ENSMUSG00000038028', u'ENSMUSG00000019841', u'ENSMUSG00000019969', u'ENSMUSG00000024283', u'ENSMUSG00000018189', u'ENSMUSG00000041147', u'ENSMUSG00000003068', u'ENSMUSG00000009628', u'ENSMUSG00000032555', u'ENSMUSG00000022314', u'ENSMUSG00000038644', u'ENSMUSG00000061436', u'ENSMUSG00000032815', u'ENSMUSG00000029730', u'ENSMUSG00000038685', u'ENSMUSG00000028884', u'ENSMUSG00000030609', u'ENSMUSG00000029238', u'ENSMUSG00000035354', u'ENSMUSG00000034154', u'ENSMUSG00000049300', u'ENSMUSG00000004221', u'ENSMUSG00000024824', u'ENSMUSG00000045751', u'ENSMUSG00000025144', u'ENSMUSG00000043535', u'ENSMUSG00000028089', u'ENSMUSG00000024854', u'ENSMUSG00000037570', u'ENSMUSG00000037474', u'ENSMUSG00000030779', u'ENSMUSG00000028086', u'ENSMUSG00000027323', u'ENSMUSG00000021635', u'ENSMUSG00000035105', u'ENSMUSG00000042489', u'ENSMUSG00000021639', u'ENSMUSG00000030094', u'ENSMUSG00000027933', u'ENSMUSG00000026196', u'ENSMUSG00000030254', u'ENSMUSG00000030528', u'ENSMUSG00000073436', u'ENSMUSG00000031826', u'ENSMUSG00000039187', u'ENSMUSG00000066440', u'ENSMUSG00000032376', u'ENSMUSG00000040433', u'ENSMUSG00000020156', u'ENSMUSG00000026048', u'ENSMUSG00000022292', u'ENSMUSG00000061755', u'ENSMUSG00000000838', u'ENSMUSG00000030322', u'ENSMUSG00000020032', u'ENSMUSG00000061759', u'ENSMUSG00000051238', u'ENSMUSG00000051235', u'ENSMUSG00000020235', u'ENSMUSG00000010461', u'ENSMUSG00000032512', u'ENSMUSG00000002221', u'ENSMUSG00000032298', u'ENSMUSG00000021911', u'ENSMUSG00000019432', u'ENSMUSG00000021918', u'ENSMUSG00000060862', u'ENSMUSG00000020474', u'ENSMUSG00000022508', u'ENSMUSG00000002835', u'ENSMUSG00000044627', u'ENSMUSG00000047388', u'ENSMUSG00000058298', u'ENSMUSG00000022346', u'ENSMUSG00000030086', u'ENSMUSG00000034674', u'ENSMUSG00000024317', u'ENSMUSG00000000751', u'ENSMUSG00000036822', u'ENSMUSG00000026648', u'ENSMUSG00000024943', u'ENSMUSG00000035958', u'ENSMUSG00000024947', u'ENSMUSG00000058317', u'ENSMUSG00000025066', u'ENSMUSG00000023953', u'ENSMUSG00000030744', u'ENSMUSG00000037032', u'ENSMUSG00000030983', u'ENSMUSG00000020390', u'ENSMUSG00000028886', u'ENSMUSG00000027164', u'ENSMUSG00000052139', u'ENSMUSG00000016308']), pop_n=13836, p_sm_bonferroni=7.768725664767739e-07, is_obsolete=False, GO='GO:0006974', name='cellular response to DNA damage stimulus', pop_count=400, alt_ids=['GO:0034984'], level=4, depth=4, enrichment='e', Cluster='Transient Increase', geneid_set=set([u'ENSMUSG00000028224', u'ENSMUSG00000046591', u'ENSMUSG00000003873', u'ENSMUSG00000046295', u'ENSMUSG00000021668', u'ENSMUSG00000024974', u'ENSMUSG00000026196', u'ENSMUSG00000025358', u'ENSMUSG00000030254', u'ENSMUSG00000059552', u'ENSMUSG00000030528', u'ENSMUSG00000007080', u'ENSMUSG00000036086', u'ENSMUSG00000041238', u'ENSMUSG00000034206', u'ENSMUSG00000039994', u'ENSMUSG00000020380', u'ENSMUSG00000039187', u'ENSMUSG00000020914', u'ENSMUSG00000027067', u'ENSMUSG00000025507', u'ENSMUSG00000017146', u'ENSMUSG00000020898', u'ENSMUSG00000040204', u'ENSMUSG00000034329', u'ENSMUSG00000041133', u'ENSMUSG00000024742', u'ENSMUSG00000039748', u'ENSMUSG00000029521', u'ENSMUSG00000035365', u'ENSMUSG00000001228', u'ENSMUSG00000020185', u'ENSMUSG00000041147', u'ENSMUSG00000005481', u'ENSMUSG00000028560', u'ENSMUSG00000009628', u'ENSMUSG00000051235', u'ENSMUSG00000032555', u'ENSMUSG00000024521', u'ENSMUSG00000002083', u'ENSMUSG00000023067', u'ENSMUSG00000028702', u'ENSMUSG00000002221', u'ENSMUSG00000035764', u'ENSMUSG00000027342', u'ENSMUSG00000036875', u'ENSMUSG00000002835', u'ENSMUSG00000036822', u'ENSMUSG00000032815', u'ENSMUSG00000034023', u'ENSMUSG00000029730', u'ENSMUSG00000045102', u'ENSMUSG00000020471', u'ENSMUSG00000035842', u'ENSMUSG00000038685', u'ENSMUSG00000049932', u'ENSMUSG00000056394', u'ENSMUSG00000044702', u'ENSMUSG00000032397', u'ENSMUSG00000030641', u'ENSMUSG00000028884', u'ENSMUSG00000030609', u'ENSMUSG00000032113', u'ENSMUSG00000030726', u'ENSMUSG00000027353', u'ENSMUSG00000002748', u'ENSMUSG00000061607', u'ENSMUSG00000078773', u'ENSMUSG00000032409', u'ENSMUSG00000038644', u'ENSMUSG00000022906', u'ENSMUSG00000001517', u'ENSMUSG00000030346', u'ENSMUSG00000073705', u'ENSMUSG00000035958', u'ENSMUSG00000036202', u'ENSMUSG00000045751', u'ENSMUSG00000031311', u'ENSMUSG00000023953', u'ENSMUSG00000017550', u'ENSMUSG00000051768', u'ENSMUSG00000026669', u'ENSMUSG00000036097', u'ENSMUSG00000037474', u'ENSMUSG00000027323', u'ENSMUSG00000049502', u'ENSMUSG00000005370', u'ENSMUSG00000042489', u'ENSMUSG00000020608', u'ENSMUSG00000034218', u'ENSMUSG00000027242', u'ENSMUSG00000022945', u'ENSMUSG00000038774']), symbols=u'Aen Ankle1 Apitd1 Ascc3 Atad5 Atm Atr Bard1 Bax Baz1b Bbc3 Blm Brca1 Brca2 Brip1 Cdk2 Cdkn1a Chaf1a Chaf1b Chek1 Chek2 Clspn Ctc1 Ddias Ddx11 Ddx39 Dna2 Dtl Dtx3l E2f7 Exo1 Fam178a Fanca Fancd2 Fanci Fbxo45 Fen1 Foxm1 Gen1 H2afx Lig1 Mcm10 Mcm7 Mcm8 Mdc1 Mms22l Msh6 Nbn Nono Palb2 Parp9 Parpbp Paxip1 Pclaf Pcna Pidd1 Pmaip1 Pold1 Pold2 Pold3 Pole Polh Polk Poln Polq Rad18 Rad50 Rad51 Rad51ap1 Rad54b Rad54l Rbbp8 Rif1 Rpa2 Rtel1 Smc1a Smc3 Smc6 Ssrp1 Tdp2 Tex15 Ticrr Timeless Tipin Top2a Topbp1 Topors Trp53 Uhrf1 Usp1 Wdr76 Xrcc1 Zranb3', symbol_set=set([u'Rbbp8', u'Rif1', 'Ticrr', u'Usp1', u'Msh6', u'Paxip1', u'Smc6', u'Chek2', u'Tdp2', u'Top2a', u'Mms22l', u'Rad51ap1', u'Brip1', u'Topors', u'Smc1a', u'Atad5', 'Ctc1', u'Rad18', u'Bax', 'Pidd1', u'Fam178a', u'Dtx3l', u'Polq', u'Ddx11', u'Pole', u'Poln', u'Rtel1', u'Polk', u'Polh', 'Parpbp', u'Palb2', u'Mdc1', u'Blm', u'Fbxo45', u'Brca2', u'Rpa2', u'Rad54l', u'Baz1b', u'Lig1', u'Xrcc1', 'Pclaf', u'Chek1', u'Wdr76', u'Rad54b', u'Nono', u'Cdkn1a', u'Timeless', u'Bbc3', u'Dna2', u'Parp9', u'Ssrp1', u'Exo1', u'Cdk2', u'Fen1', u'Uhrf1', u'Mcm10', u'Clspn', u'Gen1', u'Pold1', u'Pold2', u'Pold3', u'Bard1', u'Foxm1', 'Ddias', u'Pmaip1', u'Dtl', u'Tex15', u'Fancd2', u'Aen', u'Tipin', u'Nbn', u'E2f7', u'Brca1', u'H2afx', u'Mcm7', u'Chaf1a', u'Chaf1b', u'Ascc3', u'Mcm8', u'Topbp1', u'Smc3', u'Apitd1', u'Rad51', u'Rad50', u'Ankle1', u'Zranb3', u'Trp53', u'Atm', u'Atr', u'Ddx39', u'Pcna', u'Fanca', u'Fanci']), geneids='ENSMUSG00000028224 ENSMUSG00000046591 ENSMUSG00000003873 ENSMUSG00000046295 ENSMUSG00000021668 ENSMUSG00000024974 ENSMUSG00000025358 ENSMUSG00000059552 ENSMUSG00000007080 ENSMUSG00000020380 ENSMUSG00000027067 ENSMUSG00000025507 ENSMUSG00000017146 ENSMUSG00000020898 ENSMUSG00000034329 ENSMUSG00000039748 ENSMUSG00000029521 ENSMUSG00000020185 ENSMUSG00000041147 ENSMUSG00000009628 ENSMUSG00000032555 ENSMUSG00000023067 ENSMUSG00000036875 ENSMUSG00000038644 ENSMUSG00000032815 ENSMUSG00000034023 ENSMUSG00000029730 ENSMUSG00000045102 ENSMUSG00000035842 ENSMUSG00000038685 ENSMUSG00000049932 ENSMUSG00000056394 ENSMUSG00000032397 ENSMUSG00000028884 ENSMUSG00000030609 ENSMUSG00000078773 ENSMUSG00000032409 ENSMUSG00000022906 ENSMUSG00000045751 ENSMUSG00000031311 ENSMUSG00000051768 ENSMUSG00000036097 ENSMUSG00000037474 ENSMUSG00000027323 ENSMUSG00000005370 ENSMUSG00000042489 ENSMUSG00000034218 ENSMUSG00000027242 ENSMUSG00000038774 ENSMUSG00000026196 ENSMUSG00000030254 ENSMUSG00000030528 ENSMUSG00000036086 ENSMUSG00000041238 ENSMUSG00000039994 ENSMUSG00000039187 ENSMUSG00000020914 ENSMUSG00000034206 ENSMUSG00000040204 ENSMUSG00000041133 ENSMUSG00000024742 ENSMUSG00000035365 ENSMUSG00000026669 ENSMUSG00000005481 ENSMUSG00000028560 ENSMUSG00000051235 ENSMUSG00000024521 ENSMUSG00000028702 ENSMUSG00000002221 ENSMUSG00000035764 ENSMUSG00000027342 ENSMUSG00000020471 ENSMUSG00000002835 ENSMUSG00000044702 ENSMUSG00000030641 ENSMUSG00000032113 ENSMUSG00000030726 ENSMUSG00000027353 ENSMUSG00000002748 ENSMUSG00000061607 ENSMUSG00000036822 ENSMUSG00000001517 ENSMUSG00000030346 ENSMUSG00000073705 ENSMUSG00000035958 ENSMUSG00000023953 ENSMUSG00000017550 ENSMUSG00000001228 ENSMUSG00000002083 ENSMUSG00000036202 ENSMUSG00000049502 ENSMUSG00000020608 ENSMUSG00000022945', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=80, D1='BF', GO_name='cellular response to DNA damage stimulus'),
    Nt(p_uncorrected='', study_count='', study_n='', namespace='', p_fdr_bh='', study_items='', NS='BP', pop_items='', pop_n='', p_sm_bonferroni='', is_obsolete='', GO='GO:0045595', name='', pop_count='', alt_ids='', level=4, depth=4, enrichment='', Cluster='', geneid_set='', symbols='', symbol_set='', geneids='', format_txt=1, hdr_idx=1, is_hdrgo=True, is_usrgo=False, hdr1usr01='*', dcnt=864, D1='A', GO_name='regulation of cell differentiation'),
    Nt(p_uncorrected=9.181792629849965e-06, study_count=5, study_n=624, namespace='biological_process', p_fdr_bh=0.0010783979855415258, study_items=set([u'ENSMUSG00000036986', u'ENSMUSG00000059552', u'ENSMUSG00000023067', u'ENSMUSG00000020184', u'ENSMUSG00000025507']), NS='BP', pop_items=set([u'ENSMUSG00000036986', u'ENSMUSG00000029863', u'ENSMUSG00000076431', u'ENSMUSG00000023067', u'ENSMUSG00000020184', u'ENSMUSG00000045867', u'ENSMUSG00000025507', u'ENSMUSG00000059552']), pop_n=13836, p_sm_bonferroni=0.13911334013485682, is_obsolete=False, GO='GO:0006977', name='DNA damage response, signal transduction by p53 class mediator resulting in cell cycle arrest', pop_count=8, alt_ids=[], level=6, depth=11, enrichment='e', Cluster='Transient Increase', geneid_set=set([u'ENSMUSG00000036986', u'ENSMUSG00000059552', u'ENSMUSG00000023067', u'ENSMUSG00000020184', u'ENSMUSG00000025507']), symbols=u'Cdkn1a Mdm2 Pidd1 Pml Trp53', symbol_set=set([u'Pml', u'Cdkn1a', 'Pidd1', u'Mdm2', u'Trp53']), geneids='ENSMUSG00000036986 ENSMUSG00000025507 ENSMUSG00000023067 ENSMUSG00000020184 ENSMUSG00000059552', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=0, D1='ABF', GO_name='DNA damage response, signal transduction by p53 class mediator resulting in cell cycle arrest'),
    Nt(p_uncorrected='', study_count='', study_n='', namespace='', p_fdr_bh='', study_items='', NS='BP', pop_items='', pop_n='', p_sm_bonferroni='', is_obsolete='', GO='GO:0098542', name='', pop_count='', alt_ids='', level=4, depth=5, enrichment='', Cluster='', geneid_set='', symbols='', symbol_set='', geneids='', format_txt=1, hdr_idx=1, is_hdrgo=True, is_usrgo=False, hdr1usr01='*', dcnt=37, D1='F', GO_name='defense response to other organism'),
    Nt(p_uncorrected=5.337213979495868e-08, study_count=11, study_n=624, namespace='biological_process', p_fdr_bh=1.1552018429048844e-05, study_items=set([u'ENSMUSG00000037725', u'ENSMUSG00000029177', u'ENSMUSG00000034311', u'ENSMUSG00000032254', u'ENSMUSG00000023015', u'ENSMUSG00000027306', u'ENSMUSG00000030867', u'ENSMUSG00000002307', u'ENSMUSG00000003779', u'ENSMUSG00000026088', u'ENSMUSG00000024989']), NS='BP', pop_items=set([u'ENSMUSG00000029516', u'ENSMUSG00000027306', u'ENSMUSG00000038467', u'ENSMUSG00000036777', u'ENSMUSG00000042364', u'ENSMUSG00000038545', u'ENSMUSG00000001833', u'ENSMUSG00000037725', u'ENSMUSG00000003779', u'ENSMUSG00000023015', u'ENSMUSG00000030867', u'ENSMUSG00000024989', u'ENSMUSG00000069601', u'ENSMUSG00000037855', u'ENSMUSG00000056201', u'ENSMUSG00000028832', u'ENSMUSG00000005871', u'ENSMUSG00000024068', u'ENSMUSG00000022961', u'ENSMUSG00000029177', u'ENSMUSG00000026088', u'ENSMUSG00000002365', u'ENSMUSG00000025235', u'ENSMUSG00000032254', u'ENSMUSG00000034311', u'ENSMUSG00000006906', u'ENSMUSG00000002307', u'ENSMUSG00000020900', u'ENSMUSG00000020315', u'ENSMUSG00000032733', u'ENSMUSG00000027363']), pop_n=13836, p_sm_bonferroni=0.000808641290033419, is_obsolete=False, GO='GO:0000281', name='mitotic cytokinesis', pop_count=31, alt_ids=[], level=4, depth=5, enrichment='e', Cluster='Transient Increase', geneid_set=set([u'ENSMUSG00000030867', u'ENSMUSG00000029177', u'ENSMUSG00000027306', u'ENSMUSG00000032254', u'ENSMUSG00000023015', u'ENSMUSG00000034311', u'ENSMUSG00000037725', u'ENSMUSG00000002307', u'ENSMUSG00000003779', u'ENSMUSG00000026088', u'ENSMUSG00000024989']), symbols=u'Cenpa Cep55 Ckap2 Daxx Kif20a Kif23 Kif4 Mitd1 Nusap1 Plk1 Racgap1', symbol_set=set([u'Daxx', u'Nusap1', u'Plk1', u'Kif4', u'Cep55', u'Kif23', u'Racgap1', u'Cenpa', u'Ckap2', u'Mitd1', u'Kif20a']), geneids='ENSMUSG00000030867 ENSMUSG00000003779 ENSMUSG00000034311 ENSMUSG00000032254 ENSMUSG00000023015 ENSMUSG00000027306 ENSMUSG00000002307 ENSMUSG00000037725 ENSMUSG00000029177 ENSMUSG00000026088 ENSMUSG00000024989', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=1, D1='B', GO_name='mitotic cytokinesis'),
    Nt(p_uncorrected=1.4774031261817023e-06, study_count=6, study_n=624, namespace='biological_process', p_fdr_bh=0.00022162509668097993, study_items=set([u'ENSMUSG00000024056', u'ENSMUSG00000028678', u'ENSMUSG00000043065', u'ENSMUSG00000045328', u'ENSMUSG00000026605', u'ENSMUSG00000030677']), NS='BP', pop_items=set([u'ENSMUSG00000027654', u'ENSMUSG00000028214', u'ENSMUSG00000020628', u'ENSMUSG00000024056', u'ENSMUSG00000028678', u'ENSMUSG00000043065', u'ENSMUSG00000045328', u'ENSMUSG00000026605', u'ENSMUSG00000023919', u'ENSMUSG00000030677']), pop_n=13836, p_sm_bonferroni=0.022384134764778973, is_obsolete=False, GO='GO:0051310', name='metaphase plate congression', pop_count=10, alt_ids=[], level=5, depth=6, enrichment='e', Cluster='Transient Increase', geneid_set=set([u'ENSMUSG00000026605', u'ENSMUSG00000024056', u'ENSMUSG00000028678', u'ENSMUSG00000043065', u'ENSMUSG00000030677', u'ENSMUSG00000045328']), symbols=u'Cenpe Cenpf Kif22 Kif2c Ndc80 Spice1', symbol_set=set([u'Cenpf', u'Cenpe', u'Kif22', u'Spice1', u'Ndc80', u'Kif2c']), geneids='ENSMUSG00000024056 ENSMUSG00000028678 ENSMUSG00000043065 ENSMUSG00000045328 ENSMUSG00000026605 ENSMUSG00000030677', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=4, D1='G', GO_name='metaphase plate congression'),
    Nt(p_uncorrected=1.976111142578265e-05, study_count=4, study_n=624, namespace='biological_process', p_fdr_bh=0.002185405833664474, study_items=set([u'ENSMUSG00000017499', u'ENSMUSG00000045328', u'ENSMUSG00000030254', u'ENSMUSG00000020608']), NS='BP', pop_items=set([u'ENSMUSG00000017499', u'ENSMUSG00000030254', u'ENSMUSG00000024943', u'ENSMUSG00000045328', u'ENSMUSG00000020608']), pop_n=13836, p_sm_bonferroni=0.29940059921203294, is_obsolete=False, GO='GO:0051984', name='positive regulation of chromosome segregation', pop_count=5, alt_ids=[], level=5, depth=5, enrichment='e', Cluster='Transient Increase', geneid_set=set([u'ENSMUSG00000017499', u'ENSMUSG00000030254', u'ENSMUSG00000045328', u'ENSMUSG00000020608']), symbols=u'Cdc6 Cenpe Rad18 Smc6', symbol_set=set([u'Cenpe', u'Rad18', u'Cdc6', u'Smc6']), geneids='ENSMUSG00000017499 ENSMUSG00000045328 ENSMUSG00000030254 ENSMUSG00000020608', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=26, D1='A', GO_name='positive regulation of chromosome segregation'),
    Nt(p_uncorrected=2.89924240239775e-05, study_count=6, study_n=624, namespace='biological_process', p_fdr_bh=0.0030717777369740074, study_items=set([u'ENSMUSG00000021569', u'ENSMUSG00000032555', u'ENSMUSG00000020380', u'ENSMUSG00000027323', u'ENSMUSG00000019214', u'ENSMUSG00000005370']), NS='BP', pop_items=set([u'ENSMUSG00000032498', u'ENSMUSG00000021569', u'ENSMUSG00000007646', u'ENSMUSG00000032555', u'ENSMUSG00000018841', u'ENSMUSG00000005493', u'ENSMUSG00000020380', u'ENSMUSG00000014850', u'ENSMUSG00000027323', u'ENSMUSG00000019214', u'ENSMUSG00000005370', u'ENSMUSG00000028933', u'ENSMUSG00000021287', u'ENSMUSG00000024151', u'ENSMUSG00000032534']), pop_n=13836, p_sm_bonferroni=0.4392642163872831, is_obsolete=False, GO='GO:0007131', name='reciprocal meiotic recombination', pop_count=15, alt_ids=['GO:0000021', 'GO:0007145'], level=3, depth=9, enrichment='e', Cluster='Transient Increase', geneid_set=set([u'ENSMUSG00000021569', u'ENSMUSG00000005370', u'ENSMUSG00000032555', u'ENSMUSG00000019214', u'ENSMUSG00000020380', u'ENSMUSG00000027323']), symbols=u'Chtf18 Msh6 Rad50 Rad51 Topbp1 Trip13', symbol_set=set([u'Chtf18', u'Topbp1', u'Msh6', u'Rad51', u'Rad50', u'Trip13']), geneids='ENSMUSG00000021569 ENSMUSG00000032555 ENSMUSG00000020380 ENSMUSG00000027323 ENSMUSG00000019214 ENSMUSG00000005370', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=0, D1='BDK', GO_name='reciprocal meiotic recombination'),
    Nt(p_uncorrected=3.830456154235559e-05, study_count=5, study_n=624, namespace='biological_process', p_fdr_bh=0.004030225082834927, study_items=set([u'ENSMUSG00000059552', u'ENSMUSG00000023067', u'ENSMUSG00000001517', u'ENSMUSG00000029521', u'ENSMUSG00000041147']), NS='BP', pop_items=set([u'ENSMUSG00000061436', u'ENSMUSG00000024926', u'ENSMUSG00000029026', u'ENSMUSG00000001517', u'ENSMUSG00000029521', u'ENSMUSG00000030330', u'ENSMUSG00000023067', u'ENSMUSG00000025665', u'ENSMUSG00000041147', u'ENSMUSG00000059552']), pop_n=13836, p_sm_bonferroni=0.5803524119282295, is_obsolete=False, GO='GO:0006978', name='DNA damage response, signal transduction by p53 class mediator resulting in transcription of p21 class mediator', pop_count=10, alt_ids=[], level=6, depth=8, enrichment='e', Cluster='Transient Increase', geneid_set=set([u'ENSMUSG00000059552', u'ENSMUSG00000001517', u'ENSMUSG00000023067', u'ENSMUSG00000029521', u'ENSMUSG00000041147']), symbols=u'Brca2 Cdkn1a Chek2 Foxm1 Trp53', symbol_set=set([u'Chek2', u'Cdkn1a', u'Brca2', u'Foxm1', u'Trp53']), geneids='ENSMUSG00000059552 ENSMUSG00000023067 ENSMUSG00000001517 ENSMUSG00000029521 ENSMUSG00000041147', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=0, D1='ABF', GO_name='DNA damage response, signal transduction by p53 class mediator resulting in transcription of p21 class mediator'),
    Nt(p_uncorrected=0.0002694261654455126, study_count=1, study_n=624, namespace='biological_process', p_fdr_bh=0.020108747944162373, study_items=set([u'ENSMUSG00000037321']), NS='BP', pop_items=set([u'ENSMUSG00000033720', u'ENSMUSG00000032839', u'ENSMUSG00000024096', u'ENSMUSG00000037321', u'ENSMUSG00000045246', u'ENSMUSG00000022404', u'ENSMUSG00000020865', u'ENSMUSG00000018507', u'ENSMUSG00000050556', u'ENSMUSG00000009731', u'ENSMUSG00000057378', u'ENSMUSG00000034402', u'ENSMUSG00000040164', u'ENSMUSG00000002984', u'ENSMUSG00000024270', u'ENSMUSG00000050144', u'ENSMUSG00000026791', u'ENSMUSG00000034320', u'ENSMUSG00000030592', u'ENSMUSG00000042604', u'ENSMUSG00000029924', u'ENSMUSG00000015968', u'ENSMUSG00000004110', u'ENSMUSG00000054640', u'ENSMUSG00000063873', u'ENSMUSG00000016319', u'ENSMUSG00000025759', u'ENSMUSG00000020620', u'ENSMUSG00000037490', u'ENSMUSG00000071253', u'ENSMUSG00000040584', u'ENSMUSG00000026819', u'ENSMUSG00000092083', u'ENSMUSG00000028033', u'ENSMUSG00000030102', u'ENSMUSG00000021432', u'ENSMUSG00000020873', u'ENSMUSG00000039838', u'ENSMUSG00000048833', u'ENSMUSG00000033147', u'ENSMUSG00000022094', u'ENSMUSG00000018459', u'ENSMUSG00000055782', u'ENSMUSG00000027010', u'ENSMUSG00000036949', u'ENSMUSG00000048677', u'ENSMUSG00000025212', u'ENSMUSG00000036636', u'ENSMUSG00000027716', u'ENSMUSG00000033486', u'ENSMUSG00000020805', u'ENSMUSG00000037089', u'ENSMUSG00000031974', u'ENSMUSG00000020102', u'ENSMUSG00000022003', u'ENSMUSG00000039463', u'ENSMUSG00000040569', u'ENSMUSG00000041771', u'ENSMUSG00000020744', u'ENSMUSG00000018999', u'ENSMUSG00000021474', u'ENSMUSG00000024112', u'ENSMUSG00000021265', u'ENSMUSG00000027895', u'ENSMUSG00000024818', u'ENSMUSG00000040896', u'ENSMUSG00000022822', u'ENSMUSG00000009292', u'ENSMUSG00000002346', u'ENSMUSG00000045100', u'ENSMUSG00000030376', u'ENSMUSG00000025036', u'ENSMUSG00000029016', u'ENSMUSG00000005802', u'ENSMUSG00000056258', u'ENSMUSG00000005674', u'ENSMUSG00000028645', u'ENSMUSG00000031378', u'ENSMUSG00000035681', u'ENSMUSG00000030287', u'ENSMUSG00000041945', u'ENSMUSG00000022843', u'ENSMUSG00000019080', u'ENSMUSG00000000197', u'ENSMUSG00000000792', u'ENSMUSG00000037455', u'ENSMUSG00000028631', u'ENSMUSG00000018900', u'ENSMUSG00000026220', u'ENSMUSG00000021771', u'ENSMUSG00000014158', u'ENSMUSG00000032313', u'ENSMUSG00000024597', u'ENSMUSG00000064329', u'ENSMUSG00000031333', u'ENSMUSG00000033965', u'ENSMUSG00000038077', u'ENSMUSG00000055296', u'ENSMUSG00000023088', u'ENSMUSG00000020402', u'ENSMUSG00000041920', u'ENSMUSG00000066595', u'ENSMUSG00000000605', u'ENSMUSG00000019838', u'ENSMUSG00000020331', u'ENSMUSG00000028127', u'ENSMUSG00000023259', u'ENSMUSG00000029221', u'ENSMUSG00000004319', u'ENSMUSG00000041710', u'ENSMUSG00000016346', u'ENSMUSG00000037579', u'ENSMUSG00000017756', u'ENSMUSG00000020334', u'ENSMUSG00000041654', u'ENSMUSG00000019935', u'ENSMUSG00000008892', u'ENSMUSG00000026614', u'ENSMUSG00000032741', u'ENSMUSG00000037434', u'ENSMUSG00000040322', u'ENSMUSG00000009378', u'ENSMUSG00000031633', u'ENSMUSG00000039908', u'ENSMUSG00000020829', u'ENSMUSG00000029151', u'ENSMUSG00000027896', u'ENSMUSG00000026198', u'ENSMUSG00000019082', u'ENSMUSG00000038319', u'ENSMUSG00000045053', u'ENSMUSG00000024339', u'ENSMUSG00000017740', u'ENSMUSG00000027748', u'ENSMUSG00000051111', u'ENSMUSG00000013275', u'ENSMUSG00000042644', u'ENSMUSG00000040724', u'ENSMUSG00000020651', u'ENSMUSG00000089774', u'ENSMUSG00000021629', u'ENSMUSG00000023033', u'ENSMUSG00000029802', u'ENSMUSG00000028976', u'ENSMUSG00000075316', u'ENSMUSG00000001082', u'ENSMUSG00000038212', u'ENSMUSG00000050822', u'ENSMUSG00000002105', u'ENSMUSG00000063354', u'ENSMUSG00000029408', u'ENSMUSG00000047959', u'ENSMUSG00000004902', u'ENSMUSG00000070570', u'ENSMUSG00000030089', u'ENSMUSG00000059742', u'ENSMUSG00000053897', u'ENSMUSG00000032754', u'ENSMUSG00000046329', u'ENSMUSG00000021313', u'ENSMUSG00000046822', u'ENSMUSG00000032988', u'ENSMUSG00000051331', u'ENSMUSG00000030249', u'ENSMUSG00000064267', u'ENSMUSG00000063698', u'ENSMUSG00000004113', u'ENSMUSG00000029650', u'ENSMUSG00000058248', u'ENSMUSG00000024327', u'ENSMUSG00000037762', u'ENSMUSG00000032511', u'ENSMUSG00000052310', u'ENSMUSG00000031934', u'ENSMUSG00000028970', u'ENSMUSG00000015112', u'ENSMUSG00000040447', u'ENSMUSG00000050953', u'ENSMUSG00000006641', u'ENSMUSG00000053025', u'ENSMUSG00000027340', u'ENSMUSG00000004317', u'ENSMUSG00000038497', u'ENSMUSG00000024036', u'ENSMUSG00000060882', u'ENSMUSG00000043673', u'ENSMUSG00000032902', u'ENSMUSG00000040441', u'ENSMUSG00000021730', u'ENSMUSG00000031129', u'ENSMUSG00000021240', u'ENSMUSG00000063796', u'ENSMUSG00000036298', u'ENSMUSG00000018566', u'ENSMUSG00000031997', u'ENSMUSG00000030500', u'ENSMUSG00000027775', u'ENSMUSG00000010122', u'ENSMUSG00000042078', u'ENSMUSG00000059149', u'ENSMUSG00000036196', u'ENSMUSG00000003153', u'ENSMUSG00000003528', u'ENSMUSG00000025161', u'ENSMUSG00000032449', u'ENSMUSG00000022342', u'ENSMUSG00000027827', u'ENSMUSG00000044367', u'ENSMUSG00000022199', u'ENSMUSG00000042476', u'ENSMUSG00000032114', u'ENSMUSG00000038178', u'ENSMUSG00000050963', u'ENSMUSG00000062785', u'ENSMUSG00000027074', u'ENSMUSG00000017765', u'ENSMUSG00000038486', u'ENSMUSG00000026065', u'ENSMUSG00000038267', u'ENSMUSG00000038260', u'ENSMUSG00000058975', u'ENSMUSG00000021541', u'ENSMUSG00000028973', u'ENSMUSG00000028051', u'ENSMUSG00000024069', u'ENSMUSG00000074575', u'ENSMUSG00000047976', u'ENSMUSG00000030450', u'ENSMUSG00000032842', u'ENSMUSG00000079055', u'ENSMUSG00000030741', u'ENSMUSG00000054099', u'ENSMUSG00000058441', u'ENSMUSG00000037344', u'ENSMUSG00000025986', u'ENSMUSG00000049624', u'ENSMUSG00000037341', u'ENSMUSG00000034656', u'ENSMUSG00000034258', u'ENSMUSG00000032122', u'ENSMUSG00000089911', u'ENSMUSG00000051726', u'ENSMUSG00000054414', u'ENSMUSG00000024650', u'ENSMUSG00000028854', u'ENSMUSG00000027365', u'ENSMUSG00000040938', u'ENSMUSG00000063142']), pop_n=13836, p_sm_bonferroni=1.0, is_obsolete=False, GO='GO:0055085', name='transmembrane transport', pop_count=248, alt_ids=[], level=4, depth=4, enrichment='p', Cluster='Transient Increase', geneid_set=set([u'ENSMUSG00000037321']), symbols=u'Tap1', symbol_set=set([u'Tap1']), geneids='ENSMUSG00000037321', format_txt=1, hdr_idx=1, is_hdrgo=True, is_usrgo=True, hdr1usr01='**', dcnt=338, D1='G', GO_name='transmembrane transport'),
    Nt(p_uncorrected='', study_count='', study_n='', namespace='', p_fdr_bh='', study_items='', NS='BP', pop_items='', pop_n='', p_sm_bonferroni='', is_obsolete='', GO='GO:0051983', name='', pop_count='', alt_ids='', level=4, depth=4, enrichment='', Cluster='', geneid_set='', symbols='', symbol_set='', geneids='', format_txt=1, hdr_idx=1, is_hdrgo=True, is_usrgo=False, hdr1usr01='*', dcnt=113, D1='A', GO_name='regulation of chromosome segregation'),
    Nt(p_uncorrected=2.0487717169098736e-08, study_count=12, study_n=624, namespace='biological_process', p_fdr_bh=5.351886255672671e-06, study_items=set([u'ENSMUSG00000034349', u'ENSMUSG00000028312', u'ENSMUSG00000028873', u'ENSMUSG00000020380', u'ENSMUSG00000028702', u'ENSMUSG00000041147', u'ENSMUSG00000024974', u'ENSMUSG00000020898', u'ENSMUSG00000059552', u'ENSMUSG00000041133', u'ENSMUSG00000030528', u'ENSMUSG00000032409']), NS='BP', pop_items=set([u'ENSMUSG00000034349', u'ENSMUSG00000018841', u'ENSMUSG00000024054', u'ENSMUSG00000024974', u'ENSMUSG00000049878', u'ENSMUSG00000020415', u'ENSMUSG00000021264', u'ENSMUSG00000059552', u'ENSMUSG00000030528', u'ENSMUSG00000031928', u'ENSMUSG00000003549', u'ENSMUSG00000049717', u'ENSMUSG00000022346', u'ENSMUSG00000020380', u'ENSMUSG00000028820', u'ENSMUSG00000020898', u'ENSMUSG00000024174', u'ENSMUSG00000041133', u'ENSMUSG00000000751', u'ENSMUSG00000075266', u'ENSMUSG00000032409', u'ENSMUSG00000026648', u'ENSMUSG00000028214', u'ENSMUSG00000028312', u'ENSMUSG00000032565', u'ENSMUSG00000005871', u'ENSMUSG00000041147', u'ENSMUSG00000074797', u'ENSMUSG00000046010', u'ENSMUSG00000042275', u'ENSMUSG00000008690', u'ENSMUSG00000028873', u'ENSMUSG00000028702', u'ENSMUSG00000029676', u'ENSMUSG00000036672']), pop_n=13836, p_sm_bonferroni=0.000310409402829015, is_obsolete=False, GO='GO:0051276', name='chromosome organization', pop_count=35, alt_ids=['GO:0007001', 'GO:0051277'], level=4, depth=4, enrichment='e', Cluster='Transient Increase', geneid_set=set([u'ENSMUSG00000020380', u'ENSMUSG00000028312', u'ENSMUSG00000028873', u'ENSMUSG00000034349', u'ENSMUSG00000028702', u'ENSMUSG00000041147', u'ENSMUSG00000024974', u'ENSMUSG00000020898', u'ENSMUSG00000059552', u'ENSMUSG00000041133', u'ENSMUSG00000030528', u'ENSMUSG00000032409']), symbols=u'Atr Blm Brca2 Cdca8 Ctc1 Rad50 Rad54l Smc1a Smc2 Smc3 Smc4 Trp53', symbol_set=set([u'Smc1a', u'Brca2', u'Trp53', u'Rad54l', 'Ctc1', u'Smc3', u'Smc2', u'Smc4', u'Blm', u'Atr', u'Rad50', u'Cdca8']), geneids='ENSMUSG00000034349 ENSMUSG00000028312 ENSMUSG00000028873 ENSMUSG00000020380 ENSMUSG00000028702 ENSMUSG00000041147 ENSMUSG00000024974 ENSMUSG00000020898 ENSMUSG00000059552 ENSMUSG00000030528 ENSMUSG00000041133 ENSMUSG00000032409', format_txt=1, hdr_idx=1, is_hdrgo=True, is_usrgo=True, hdr1usr01='**', dcnt=111, D1='BH', GO_name='chromosome organization'),
    Nt(p_uncorrected='', study_count='', study_n='', namespace='', p_fdr_bh='', study_items='', NS='BP', pop_items='', pop_n='', p_sm_bonferroni='', is_obsolete='', GO='GO:0008637', name='', pop_count='', alt_ids='', level=5, depth=5, enrichment='', Cluster='', geneid_set='', symbols='', symbol_set='', geneids='', format_txt=1, hdr_idx=1, is_hdrgo=True, is_usrgo=False, hdr1usr01='*', dcnt=7, D1='BH', GO_name='apoptotic mitochondrial changes'),
    Nt(p_uncorrected='', study_count='', study_n='', namespace='', p_fdr_bh='', study_items='', NS='BP', pop_items='', pop_n='', p_sm_bonferroni='', is_obsolete='', GO='GO:0007568', name='', pop_count='', alt_ids='', level=3, depth=3, enrichment='', Cluster='', geneid_set='', symbols='', symbol_set='', geneids='', format_txt=1, hdr_idx=1, is_hdrgo=True, is_usrgo=False, hdr1usr01='*', dcnt=18, D1='CE', GO_name='aging'),
    Nt(p_uncorrected=4.022772597795271e-08, study_count=13, study_n=624, namespace='biological_process', p_fdr_bh=8.963092298411199e-06, study_items=set([u'ENSMUSG00000029521', u'ENSMUSG00000003873', u'ENSMUSG00000005413', u'ENSMUSG00000024521', u'ENSMUSG00000027490', u'ENSMUSG00000041147', u'ENSMUSG00000036986', u'ENSMUSG00000005370', u'ENSMUSG00000017146', u'ENSMUSG00000034218', u'ENSMUSG00000057789', u'ENSMUSG00000006445', u'ENSMUSG00000036822']), NS='BP', pop_items=set([u'ENSMUSG00000021871', u'ENSMUSG00000006360', u'ENSMUSG00000028329', u'ENSMUSG00000036986', u'ENSMUSG00000062762', u'ENSMUSG00000027381', u'ENSMUSG00000024959', u'ENSMUSG00000003873', u'ENSMUSG00000031536', u'ENSMUSG00000041417', u'ENSMUSG00000028914', u'ENSMUSG00000022346', u'ENSMUSG00000043099', u'ENSMUSG00000003541', u'ENSMUSG00000068329', u'ENSMUSG00000042349', u'ENSMUSG00000006818', u'ENSMUSG00000061175', u'ENSMUSG00000017146', u'ENSMUSG00000020063', u'ENSMUSG00000024151', u'ENSMUSG00000034485', u'ENSMUSG00000036822', u'ENSMUSG00000032498', u'ENSMUSG00000057329', u'ENSMUSG00000038612', u'ENSMUSG00000029521', u'ENSMUSG00000030322', u'ENSMUSG00000030341', u'ENSMUSG00000022672', u'ENSMUSG00000054051', u'ENSMUSG00000041147', u'ENSMUSG00000006445', u'ENSMUSG00000026278', u'ENSMUSG00000005413', u'ENSMUSG00000024521', u'ENSMUSG00000030990', u'ENSMUSG00000027490', u'ENSMUSG00000005370', u'ENSMUSG00000007659', u'ENSMUSG00000034218', u'ENSMUSG00000089682', u'ENSMUSG00000057789', u'ENSMUSG00000028599']), pop_n=13836, p_sm_bonferroni=0.0006094902762919615, is_obsolete=False, GO='GO:0008630', name='intrinsic apoptotic signaling pathway in response to DNA damage', pop_count=44, alt_ids=[], level=5, depth=7, enrichment='e', Cluster='Transient Increase', geneid_set=set([u'ENSMUSG00000029521', u'ENSMUSG00000005413', u'ENSMUSG00000024521', u'ENSMUSG00000027490', u'ENSMUSG00000041147', u'ENSMUSG00000036986', u'ENSMUSG00000005370', u'ENSMUSG00000017146', u'ENSMUSG00000034218', u'ENSMUSG00000036822', u'ENSMUSG00000057789', u'ENSMUSG00000006445', u'ENSMUSG00000003873']), symbols=u'Atm Bak1 Bax Brca1 Brca2 Chek2 E2f1 Epha2 Hmox1 Msh6 Pmaip1 Pml Topors', symbol_set=set([u'Brca1', u'Brca2', u'Pmaip1', u'E2f1', u'Atm', u'Hmox1', u'Epha2', u'Msh6', u'Bak1', u'Bax', u'Pml', u'Chek2', u'Topors']), geneids='ENSMUSG00000003873 ENSMUSG00000005413 ENSMUSG00000024521 ENSMUSG00000027490 ENSMUSG00000041147 ENSMUSG00000036986 ENSMUSG00000005370 ENSMUSG00000017146 ENSMUSG00000034218 ENSMUSG00000036822 ENSMUSG00000057789 ENSMUSG00000006445 ENSMUSG00000029521', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=1, D1='ABF', GO_name='intrinsic apoptotic signaling pathway in response to DNA damage'),
    Nt(p_uncorrected=0.000430543497990217, study_count=4, study_n=624, namespace='biological_process', p_fdr_bh=0.03019983582430453, study_items=set([u'ENSMUSG00000039748', u'ENSMUSG00000020380', u'ENSMUSG00000024742', u'ENSMUSG00000036875']), NS='BP', pop_items=set([u'ENSMUSG00000039748', u'ENSMUSG00000020380', u'ENSMUSG00000032026', u'ENSMUSG00000040482', u'ENSMUSG00000024824', u'ENSMUSG00000036875', u'ENSMUSG00000032705', u'ENSMUSG00000024742', u'ENSMUSG00000038569']), pop_n=13836, p_sm_bonferroni=1.0, is_obsolete=False, GO='GO:0090305', name='nucleic acid phosphodiester bond hydrolysis', pop_count=9, alt_ids=[], level=5, depth=6, enrichment='e', Cluster='Transient Increase', geneid_set=set([u'ENSMUSG00000039748', u'ENSMUSG00000020380', u'ENSMUSG00000024742', u'ENSMUSG00000036875']), symbols=u'Dna2 Exo1 Fen1 Rad50', symbol_set=set([u'Exo1', u'Fen1', u'Dna2', u'Rad50']), geneids='ENSMUSG00000039748 ENSMUSG00000020380 ENSMUSG00000024742 ENSMUSG00000036875', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=58, D1='BD', GO_name='nucleic acid phosphodiester bond hydrolysis'),
    Nt(p_uncorrected=2.1385239695277385e-07, study_count=9, study_n=624, namespace='biological_process', p_fdr_bh=3.857235316942234e-05, study_items=set([u'ENSMUSG00000067455', u'ENSMUSG00000027018', u'ENSMUSG00000028693', u'ENSMUSG00000069266', u'ENSMUSG00000069274', u'ENSMUSG00000061482', u'ENSMUSG00000060093', u'ENSMUSG00000064288', u'ENSMUSG00000005470']), NS='BP', pop_items=set([u'ENSMUSG00000067455', u'ENSMUSG00000060678', u'ENSMUSG00000060639', u'ENSMUSG00000020196', u'ENSMUSG00000019857', u'ENSMUSG00000031229', u'ENSMUSG00000069274', u'ENSMUSG00000091405', u'ENSMUSG00000039473', u'ENSMUSG00000002319', u'ENSMUSG00000069305', u'ENSMUSG00000069306', u'ENSMUSG00000060981', u'ENSMUSG00000057236', u'ENSMUSG00000028693', u'ENSMUSG00000060093', u'ENSMUSG00000027018', u'ENSMUSG00000022702', u'ENSMUSG00000069266', u'ENSMUSG00000061482', u'ENSMUSG00000005470', u'ENSMUSG00000064288']), pop_n=13836, p_sm_bonferroni=0.0032400776662314767, is_obsolete=False, GO='GO:0006336', name='DNA replication-independent nucleosome assembly', pop_count=22, alt_ids=[], level=7, depth=8, enrichment='e', Cluster='Transient Increase', geneid_set=set([u'ENSMUSG00000067455', u'ENSMUSG00000027018', u'ENSMUSG00000028693', u'ENSMUSG00000069266', u'ENSMUSG00000069274', u'ENSMUSG00000061482', u'ENSMUSG00000060093', u'ENSMUSG00000064288', u'ENSMUSG00000005470']), symbols=u'Asf1b Hat1 Hist1h4a Hist1h4b Hist1h4d Hist1h4f Hist1h4j Hist1h4k Nasp', symbol_set=set([u'Hist1h4b', u'Nasp', u'Hist1h4f', u'Hist1h4d', u'Hat1', u'Hist1h4j', u'Hist1h4a', u'Hist1h4k', u'Asf1b']), geneids='ENSMUSG00000067455 ENSMUSG00000069266 ENSMUSG00000027018 ENSMUSG00000028693 ENSMUSG00000060093 ENSMUSG00000069274 ENSMUSG00000061482 ENSMUSG00000005470 ENSMUSG00000064288', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=1, D1='BH', GO_name='DNA replication-independent nucleosome assembly'),
    Nt(p_uncorrected=2.1385239695277385e-07, study_count=9, study_n=624, namespace='biological_process', p_fdr_bh=3.857235316942234e-05, study_items=set([u'ENSMUSG00000036086', u'ENSMUSG00000059323', u'ENSMUSG00000027323', u'ENSMUSG00000035842', u'ENSMUSG00000073705', u'ENSMUSG00000027342', u'ENSMUSG00000045751', u'ENSMUSG00000038685', u'ENSMUSG00000030528']), NS='BP', pop_items=set([u'ENSMUSG00000031229', u'ENSMUSG00000059323', u'ENSMUSG00000031583', u'ENSMUSG00000035842', u'ENSMUSG00000038685', u'ENSMUSG00000030528', u'ENSMUSG00000073436', u'ENSMUSG00000036086', u'ENSMUSG00000026434', u'ENSMUSG00000058594', u'ENSMUSG00000039354', u'ENSMUSG00000024287', u'ENSMUSG00000061755', u'ENSMUSG00000009555', u'ENSMUSG00000045751', u'ENSMUSG00000025144', u'ENSMUSG00000024906', u'ENSMUSG00000055884', u'ENSMUSG00000073705', u'ENSMUSG00000027323', u'ENSMUSG00000027342', u'ENSMUSG00000038225']), pop_n=13836, p_sm_bonferroni=0.0032400776662314767, is_obsolete=False, GO='GO:0031297', name='replication fork processing', pop_count=22, alt_ids=[], level=6, depth=8, enrichment='e', Cluster='Transient Increase', geneid_set=set([u'ENSMUSG00000036086', u'ENSMUSG00000059323', u'ENSMUSG00000027323', u'ENSMUSG00000045751', u'ENSMUSG00000073705', u'ENSMUSG00000027342', u'ENSMUSG00000035842', u'ENSMUSG00000038685', u'ENSMUSG00000030528']), symbols=u'Apitd1 Blm Ddx11 Mms22l Pcna Rad51 Rtel1 Tonsl Zranb3', symbol_set=set([u'Pcna', u'Zranb3', u'Ddx11', u'Tonsl', u'Mms22l', u'Apitd1', u'Blm', u'Rad51', u'Rtel1']), geneids='ENSMUSG00000036086 ENSMUSG00000059323 ENSMUSG00000027323 ENSMUSG00000045751 ENSMUSG00000073705 ENSMUSG00000027342 ENSMUSG00000035842 ENSMUSG00000030528 ENSMUSG00000038685', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=3, D1='BD', GO_name='replication fork processing'),
    Nt(p_uncorrected=4.084711977912572e-11, study_count=30, study_n=624, namespace='biological_process', p_fdr_bh=3.774646010782965e-08, study_items=set([u'ENSMUSG00000058385', u'ENSMUSG00000067455', u'ENSMUSG00000058773', u'ENSMUSG00000002835', u'ENSMUSG00000074403', u'ENSMUSG00000062727', u'ENSMUSG00000002870', u'ENSMUSG00000064168', u'ENSMUSG00000002307', u'ENSMUSG00000049539', u'ENSMUSG00000069308', u'ENSMUSG00000069273', u'ENSMUSG00000069274', u'ENSMUSG00000069300', u'ENSMUSG00000069310', u'ENSMUSG00000075031', u'ENSMUSG00000028693', u'ENSMUSG00000060093', u'ENSMUSG00000029177', u'ENSMUSG00000047246', u'ENSMUSG00000052565', u'ENSMUSG00000069267', u'ENSMUSG00000069266', u'ENSMUSG00000069265', u'ENSMUSG00000061482', u'ENSMUSG00000005470', u'ENSMUSG00000064288', u'ENSMUSG00000056895', u'ENSMUSG00000022945', u'ENSMUSG00000069268']), NS='BP', pop_items=set([u'ENSMUSG00000054766', u'ENSMUSG00000058385', u'ENSMUSG00000028333', u'ENSMUSG00000067455', u'ENSMUSG00000031229', u'ENSMUSG00000058773', u'ENSMUSG00000059119', u'ENSMUSG00000058799', u'ENSMUSG00000002835', u'ENSMUSG00000032187', u'ENSMUSG00000074403', u'ENSMUSG00000062727', u'ENSMUSG00000031715', u'ENSMUSG00000002870', u'ENSMUSG00000055733', u'ENSMUSG00000064168', u'ENSMUSG00000002307', u'ENSMUSG00000049539', u'ENSMUSG00000024921', u'ENSMUSG00000041096', u'ENSMUSG00000047514', u'ENSMUSG00000024335', u'ENSMUSG00000051627', u'ENSMUSG00000069308', u'ENSMUSG00000049516', u'ENSMUSG00000015749', u'ENSMUSG00000069273', u'ENSMUSG00000069274', u'ENSMUSG00000035623', u'ENSMUSG00000020086', u'ENSMUSG00000069300', u'ENSMUSG00000038984', u'ENSMUSG00000060639', u'ENSMUSG00000069306', u'ENSMUSG00000091405', u'ENSMUSG00000082229', u'ENSMUSG00000075031', u'ENSMUSG00000018974', u'ENSMUSG00000060981', u'ENSMUSG00000005982', u'ENSMUSG00000005470', u'ENSMUSG00000057113', u'ENSMUSG00000052565', u'ENSMUSG00000068854', u'ENSMUSG00000060743', u'ENSMUSG00000055430', u'ENSMUSG00000028693', u'ENSMUSG00000019857', u'ENSMUSG00000016559', u'ENSMUSG00000039485', u'ENSMUSG00000028759', u'ENSMUSG00000015937', u'ENSMUSG00000018102', u'ENSMUSG00000055067', u'ENSMUSG00000031540', u'ENSMUSG00000056895', u'ENSMUSG00000036181', u'ENSMUSG00000060678', u'ENSMUSG00000029177', u'ENSMUSG00000000567', u'ENSMUSG00000047246', u'ENSMUSG00000090112', u'ENSMUSG00000069305', u'ENSMUSG00000069267', u'ENSMUSG00000069266', u'ENSMUSG00000069265', u'ENSMUSG00000061482', u'ENSMUSG00000060093', u'ENSMUSG00000064288', u'ENSMUSG00000069268', u'ENSMUSG00000021767', u'ENSMUSG00000022945', u'ENSMUSG00000069310']), pop_n=13836, p_sm_bonferroni=6.188747117735338e-07, is_obsolete=False, GO='GO:0006334', name='nucleosome assembly', pop_count=73, alt_ids=[], level=6, depth=7, enrichment='e', Cluster='Transient Increase', geneid_set=set([u'ENSMUSG00000069267', u'ENSMUSG00000058385', u'ENSMUSG00000075031', u'ENSMUSG00000067455', u'ENSMUSG00000005470', u'ENSMUSG00000058773', u'ENSMUSG00000028693', u'ENSMUSG00000060093', u'ENSMUSG00000002835', u'ENSMUSG00000074403', u'ENSMUSG00000062727', u'ENSMUSG00000029177', u'ENSMUSG00000069268', u'ENSMUSG00000002870', u'ENSMUSG00000064168', u'ENSMUSG00000069308', u'ENSMUSG00000049539', u'ENSMUSG00000047246', u'ENSMUSG00000052565', u'ENSMUSG00000002307', u'ENSMUSG00000069266', u'ENSMUSG00000069265', u'ENSMUSG00000069273', u'ENSMUSG00000069274', u'ENSMUSG00000061482', u'ENSMUSG00000069300', u'ENSMUSG00000064288', u'ENSMUSG00000056895', u'ENSMUSG00000022945', u'ENSMUSG00000069310']), symbols=u'Asf1b Cenpa Chaf1a Chaf1b Daxx Hist1h1a Hist1h1b Hist1h1d Hist1h2bb Hist1h2be Hist1h2bf Hist1h2bg Hist1h2bh Hist1h2bj Hist1h2bk Hist1h2bp Hist1h3a Hist1h3b Hist1h3c Hist1h3e Hist1h4a Hist1h4b Hist1h4d Hist1h4f Hist1h4j Hist1h4k Hist2h3b Hist3h2ba Mcm2 Nasp', symbol_set=set([u'Daxx', u'Hist1h2bp', u'Hist1h2be', u'Hist1h2bf', u'Hist1h2bg', u'Chaf1a', u'Mcm2', u'Hist1h2bb', u'Chaf1b', u'Hist1h2bh', u'Asf1b', u'Hist1h2bk', u'Hist1h4b', u'Hist1h4a', u'Hist1h4f', u'Hist1h4d', u'Hist1h4k', u'Hist1h4j', u'Hist1h2bj', u'Nasp', u'Cenpa', u'Hist3h2ba', u'Hist1h3b', u'Hist1h3c', u'Hist1h3a', u'Hist2h3b', u'Hist1h3e', u'Hist1h1d', u'Hist1h1a', u'Hist1h1b']), geneids='ENSMUSG00000058385 ENSMUSG00000067455 ENSMUSG00000058773 ENSMUSG00000002835 ENSMUSG00000074403 ENSMUSG00000062727 ENSMUSG00000002870 ENSMUSG00000064168 ENSMUSG00000002307 ENSMUSG00000049539 ENSMUSG00000069308 ENSMUSG00000069273 ENSMUSG00000069274 ENSMUSG00000069300 ENSMUSG00000069310 ENSMUSG00000075031 ENSMUSG00000028693 ENSMUSG00000005470 ENSMUSG00000029177 ENSMUSG00000047246 ENSMUSG00000052565 ENSMUSG00000069267 ENSMUSG00000069266 ENSMUSG00000069265 ENSMUSG00000061482 ENSMUSG00000060093 ENSMUSG00000064288 ENSMUSG00000069268 ENSMUSG00000022945 ENSMUSG00000056895', format_txt=1, hdr_idx=1, is_hdrgo=True, is_usrgo=True, hdr1usr01='**', dcnt=3, D1='BH', GO_name='nucleosome assembly'),
    Nt(p_uncorrected=4.4593414733267585e-12, study_count=15, study_n=624, namespace='biological_process', p_fdr_bh=3.774646010782965e-08, study_items=set([u'ENSMUSG00000067455', u'ENSMUSG00000027018', u'ENSMUSG00000028693', u'ENSMUSG00000069267', u'ENSMUSG00000069266', u'ENSMUSG00000069265', u'ENSMUSG00000069273', u'ENSMUSG00000069274', u'ENSMUSG00000061482', u'ENSMUSG00000074403', u'ENSMUSG00000060093', u'ENSMUSG00000002835', u'ENSMUSG00000064288', u'ENSMUSG00000005470', u'ENSMUSG00000022945']), NS='BP', pop_items=set([u'ENSMUSG00000067455', u'ENSMUSG00000060678', u'ENSMUSG00000060639', u'ENSMUSG00000002835', u'ENSMUSG00000074403', u'ENSMUSG00000069273', u'ENSMUSG00000069274', u'ENSMUSG00000091405', u'ENSMUSG00000002319', u'ENSMUSG00000060093', u'ENSMUSG00000069306', u'ENSMUSG00000060981', u'ENSMUSG00000057236', u'ENSMUSG00000028693', u'ENSMUSG00000005470', u'ENSMUSG00000027018', u'ENSMUSG00000069305', u'ENSMUSG00000069267', u'ENSMUSG00000069266', u'ENSMUSG00000069265', u'ENSMUSG00000061482', u'ENSMUSG00000019857', u'ENSMUSG00000064288', u'ENSMUSG00000022945']), pop_n=13836, p_sm_bonferroni=6.756348266237371e-08, is_obsolete=False, GO='GO:0006335', name='DNA replication-dependent nucleosome assembly', pop_count=24, alt_ids=[], level=7, depth=8, enrichment='e', Cluster='Transient Increase', geneid_set=set([u'ENSMUSG00000067455', u'ENSMUSG00000027018', u'ENSMUSG00000028693', u'ENSMUSG00000069267', u'ENSMUSG00000069266', u'ENSMUSG00000069265', u'ENSMUSG00000069273', u'ENSMUSG00000069274', u'ENSMUSG00000061482', u'ENSMUSG00000074403', u'ENSMUSG00000060093', u'ENSMUSG00000002835', u'ENSMUSG00000064288', u'ENSMUSG00000005470', u'ENSMUSG00000022945']), symbols=u'Asf1b Chaf1a Chaf1b Hat1 Hist1h3a Hist1h3b Hist1h3e Hist1h4a Hist1h4b Hist1h4d Hist1h4f Hist1h4j Hist1h4k Hist2h3b Nasp', symbol_set=set([u'Hist1h4b', u'Nasp', u'Hist1h4f', u'Hist1h4d', u'Hat1', u'Hist1h4j', u'Chaf1b', u'Hist1h4a', u'Hist1h3b', u'Hist1h4k', u'Hist1h3a', u'Chaf1a', u'Hist2h3b', u'Hist1h3e', u'Asf1b']), geneids='ENSMUSG00000067455 ENSMUSG00000069266 ENSMUSG00000027018 ENSMUSG00000028693 ENSMUSG00000069267 ENSMUSG00000060093 ENSMUSG00000069265 ENSMUSG00000069273 ENSMUSG00000002835 ENSMUSG00000061482 ENSMUSG00000074403 ENSMUSG00000005470 ENSMUSG00000069274 ENSMUSG00000064288 ENSMUSG00000022945', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=0, D1='BH', GO_name='DNA replication-dependent nucleosome assembly'),
    Nt(p_uncorrected=5.716066791862708e-05, study_count=4, study_n=624, namespace='biological_process', p_fdr_bh=0.005735372712815357, study_items=set([u'ENSMUSG00000020897', u'ENSMUSG00000032254', u'ENSMUSG00000023015', u'ENSMUSG00000034311']), NS='BP', pop_items=set([u'ENSMUSG00000050930', u'ENSMUSG00000032254', u'ENSMUSG00000023015', u'ENSMUSG00000034311', u'ENSMUSG00000020897', u'ENSMUSG00000033502']), pop_n=13836, p_sm_bonferroni=0.8660412796351189, is_obsolete=False, GO='GO:0051256', name='mitotic spindle midzone assembly', pop_count=6, alt_ids=[], level=4, depth=5, enrichment='e', Cluster='Transient Increase', geneid_set=set([u'ENSMUSG00000020897', u'ENSMUSG00000032254', u'ENSMUSG00000023015', u'ENSMUSG00000034311']), symbols=u'Aurkb Kif23 Kif4 Racgap1', symbol_set=set([u'Racgap1', u'Kif4', u'Kif23', u'Aurkb']), geneids='ENSMUSG00000020897 ENSMUSG00000032254 ENSMUSG00000023015 ENSMUSG00000034311', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=0, D1='BCH', GO_name='mitotic spindle midzone assembly'),
    Nt(p_uncorrected='', study_count='', study_n='', namespace='', p_fdr_bh='', study_items='', NS='BP', pop_items='', pop_n='', p_sm_bonferroni='', is_obsolete='', GO='GO:0080134', name='', pop_count='', alt_ids='', level=4, depth=4, enrichment='', Cluster='', geneid_set='', symbols='', symbol_set='', geneids='', format_txt=1, hdr_idx=1, is_hdrgo=True, is_usrgo=False, hdr1usr01='*', dcnt=960, D1='A', GO_name='regulation of response to stress'),
    Nt(p_uncorrected=4.804111827681834e-06, study_count=7, study_n=624, namespace='biological_process', p_fdr_bh=0.0005917650268390852, study_items=set([u'ENSMUSG00000038644', u'ENSMUSG00000021668', u'ENSMUSG00000025574', u'ENSMUSG00000007080', u'ENSMUSG00000023953', u'ENSMUSG00000056394', u'ENSMUSG00000058729']), NS='BP', pop_items=set([u'ENSMUSG00000031536', u'ENSMUSG00000026082', u'ENSMUSG00000025218', u'ENSMUSG00000049717', u'ENSMUSG00000007080', u'ENSMUSG00000035824', u'ENSMUSG00000014301', u'ENSMUSG00000021668', u'ENSMUSG00000038845', u'ENSMUSG00000020697', u'ENSMUSG00000025574', u'ENSMUSG00000019997', u'ENSMUSG00000038425', u'ENSMUSG00000038644', u'ENSMUSG00000023953', u'ENSMUSG00000056394', u'ENSMUSG00000058729']), pop_n=13836, p_sm_bonferroni=0.07278709830120746, is_obsolete=False, GO='GO:0071897', name='DNA biosynthetic process', pop_count=17, alt_ids=[], level=5, depth=7, enrichment='e', Cluster='Transient Increase', geneid_set=set([u'ENSMUSG00000058729', u'ENSMUSG00000025574', u'ENSMUSG00000007080', u'ENSMUSG00000021668', u'ENSMUSG00000023953', u'ENSMUSG00000056394', u'ENSMUSG00000038644']), symbols=u'Lig1 Lin9 Pold1 Pole Polh Polk Tk1', symbol_set=set([u'Lin9', u'Pold1', u'Pole', u'Lig1', u'Tk1', u'Polk', u'Polh']), geneids='ENSMUSG00000021668 ENSMUSG00000058729 ENSMUSG00000025574 ENSMUSG00000007080 ENSMUSG00000023953 ENSMUSG00000056394 ENSMUSG00000038644', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=19, D1='BD', GO_name='DNA biosynthetic process'),
    Nt(p_uncorrected=0.0002616703282067204, study_count=5, study_n=624, namespace='biological_process', p_fdr_bh=0.01962657001316842, study_items=set([u'ENSMUSG00000032113', u'ENSMUSG00000041147', u'ENSMUSG00000044702', u'ENSMUSG00000027454', u'ENSMUSG00000042029']), NS='BP', pop_items=set([u'ENSMUSG00000018736', u'ENSMUSG00000031546', u'ENSMUSG00000029547', u'ENSMUSG00000032113', u'ENSMUSG00000024735', u'ENSMUSG00000015697', u'ENSMUSG00000044702', u'ENSMUSG00000023980', u'ENSMUSG00000027454', u'ENSMUSG00000042029', u'ENSMUSG00000025337', u'ENSMUSG00000041147', u'ENSMUSG00000032078', u'ENSMUSG00000024002']), pop_n=13836, p_sm_bonferroni=1.0, is_obsolete=False, GO='GO:0001833', name='inner cell mass cell proliferation', pop_count=14, alt_ids=[], level=3, depth=3, enrichment='e', Cluster='Transient Increase', geneid_set=set([u'ENSMUSG00000032113', u'ENSMUSG00000044702', u'ENSMUSG00000042029', u'ENSMUSG00000027454', u'ENSMUSG00000041147']), symbols=u'Brca2 Chek1 Gins1 Ncapg2 Palb2', symbol_set=set([u'Gins1', u'Palb2', u'Ncapg2', u'Brca2', u'Chek1']), geneids='ENSMUSG00000032113 ENSMUSG00000042029 ENSMUSG00000044702 ENSMUSG00000027454 ENSMUSG00000041147', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=0, D1='C', GO_name='inner cell mass cell proliferation'),
    Nt(p_uncorrected=9.131151172475021e-05, study_count=3, study_n=624, namespace='biological_process', p_fdr_bh=0.008090413532992342, study_items=set([u'ENSMUSG00000034349', u'ENSMUSG00000045273', u'ENSMUSG00000028312']), NS='BP', pop_items=set([u'ENSMUSG00000034349', u'ENSMUSG00000045273', u'ENSMUSG00000028312']), pop_n=13836, p_sm_bonferroni=1.0, is_obsolete=False, GO='GO:0051383', name='kinetochore organization', pop_count=3, alt_ids=[], level=5, depth=5, enrichment='e', Cluster='Transient Increase', geneid_set=set([u'ENSMUSG00000034349', u'ENSMUSG00000045273', u'ENSMUSG00000028312']), symbols=u'Cenph Smc2 Smc4', symbol_set=set([u'Smc2', u'Smc4', u'Cenph']), geneids='ENSMUSG00000034349 ENSMUSG00000045273 ENSMUSG00000028312', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=1, D1='BH', GO_name='kinetochore organization'),
    Nt(p_uncorrected=0.000430543497990217, study_count=4, study_n=624, namespace='biological_process', p_fdr_bh=0.03019983582430453, study_items=set([u'ENSMUSG00000073705', u'ENSMUSG00000029177', u'ENSMUSG00000040599', u'ENSMUSG00000045273']), NS='BP', pop_items=set([u'ENSMUSG00000038902', u'ENSMUSG00000029177', u'ENSMUSG00000045273', u'ENSMUSG00000029253', u'ENSMUSG00000073705', u'ENSMUSG00000025144', u'ENSMUSG00000075266', u'ENSMUSG00000040599', u'ENSMUSG00000036672']), pop_n=13836, p_sm_bonferroni=1.0, is_obsolete=False, GO='GO:0051382', name='kinetochore assembly', pop_count=9, alt_ids=['GO:0000069'], level=5, depth=7, enrichment='e', Cluster='Transient Increase', geneid_set=set([u'ENSMUSG00000073705', u'ENSMUSG00000029177', u'ENSMUSG00000040599', u'ENSMUSG00000045273']), symbols=u'Apitd1 Cenpa Cenph Mis12', symbol_set=set([u'Mis12', u'Cenph', u'Cenpa', u'Apitd1']), geneids='ENSMUSG00000073705 ENSMUSG00000029177 ENSMUSG00000040599 ENSMUSG00000045273', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=0, D1='BH', GO_name='kinetochore assembly'),
    Nt(p_uncorrected=4.099215555456427e-06, study_count=4, study_n=624, namespace='biological_process', p_fdr_bh=0.000521909368745549, study_items=set([u'ENSMUSG00000036928', u'ENSMUSG00000007589', u'ENSMUSG00000009628', u'ENSMUSG00000038379']), NS='BP', pop_items=set([u'ENSMUSG00000036928', u'ENSMUSG00000007589', u'ENSMUSG00000009628', u'ENSMUSG00000038379']), pop_n=13836, p_sm_bonferroni=0.06210721488072033, is_obsolete=False, GO='GO:0034502', name='protein localization to chromosome', pop_count=4, alt_ids=[], level=6, depth=6, enrichment='e', Cluster='Transient Increase', geneid_set=set([u'ENSMUSG00000036928', u'ENSMUSG00000007589', u'ENSMUSG00000009628', u'ENSMUSG00000038379']), symbols=u'Stag3 Tex15 Tinf2 Ttk', symbol_set=set([u'Tinf2', u'Stag3', u'Ttk', u'Tex15']), geneids='ENSMUSG00000036928 ENSMUSG00000007589 ENSMUSG00000009628 ENSMUSG00000038379', format_txt=1, hdr_idx=1, is_hdrgo=True, is_usrgo=True, hdr1usr01='**', dcnt=22, D1='G', GO_name='protein localization to chromosome'),
    Nt(p_uncorrected='', study_count='', study_n='', namespace='', p_fdr_bh='', study_items='', NS='BP', pop_items='', pop_n='', p_sm_bonferroni='', is_obsolete='', GO='GO:0097190', name='', pop_count='', alt_ids='', level=3, depth=5, enrichment='', Cluster='', geneid_set='', symbols='', symbol_set='', geneids='', format_txt=1, hdr_idx=1, is_hdrgo=True, is_usrgo=False, hdr1usr01='*', dcnt=22, D1='AB', GO_name='apoptotic signaling pathway'),
    Nt(p_uncorrected=9.181792629849965e-06, study_count=5, study_n=624, namespace='biological_process', p_fdr_bh=0.0010783979855415258, study_items=set([u'ENSMUSG00000023940', u'ENSMUSG00000024056', u'ENSMUSG00000027326', u'ENSMUSG00000045328', u'ENSMUSG00000026683']), NS='BP', pop_items=set([u'ENSMUSG00000026683', u'ENSMUSG00000024056', u'ENSMUSG00000027326', u'ENSMUSG00000066979', u'ENSMUSG00000045328', u'ENSMUSG00000030965', u'ENSMUSG00000017421', u'ENSMUSG00000023940']), pop_n=13836, p_sm_bonferroni=0.13911334013485682, is_obsolete=False, GO='GO:0008608', name='attachment of spindle microtubules to kinetochore', pop_count=8, alt_ids=['GO:0051313'], level=3, depth=3, enrichment='e', Cluster='Transient Increase', geneid_set=set([u'ENSMUSG00000023940', u'ENSMUSG00000024056', u'ENSMUSG00000027326', u'ENSMUSG00000045328', u'ENSMUSG00000026683']), symbols=u'Cenpe Knl1 Ndc80 Nuf2 Sgol1', symbol_set=set([u'Cenpe', u'Ndc80', u'Sgol1', 'Knl1', u'Nuf2']), geneids='ENSMUSG00000023940 ENSMUSG00000024056 ENSMUSG00000027326 ENSMUSG00000045328 ENSMUSG00000026683', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=8, D1='B', GO_name='attachment of spindle microtubules to kinetochore'),
    Nt(p_uncorrected=6.079901029339501e-07, study_count=10, study_n=624, namespace='biological_process', p_fdr_bh=0.00010118906047752281, study_items=set([u'ENSMUSG00000068606', u'ENSMUSG00000018899', u'ENSMUSG00000034459', u'ENSMUSG00000039997', u'ENSMUSG00000046879', u'ENSMUSG00000078853', u'ENSMUSG00000078921', u'ENSMUSG00000054072', u'ENSMUSG00000026104', u'ENSMUSG00000074896']), NS='BP', pop_items=set([u'ENSMUSG00000040264', u'ENSMUSG00000020307', u'ENSMUSG00000058163', u'ENSMUSG00000009293', u'ENSMUSG00000078922', u'ENSMUSG00000078920', u'ENSMUSG00000078921', u'ENSMUSG00000036199', u'ENSMUSG00000028268', u'ENSMUSG00000029203', u'ENSMUSG00000073555', u'ENSMUSG00000021494', u'ENSMUSG00000043263', u'ENSMUSG00000039997', u'ENSMUSG00000068329', u'ENSMUSG00000054072', u'ENSMUSG00000026104', u'ENSMUSG00000037860', u'ENSMUSG00000068606', u'ENSMUSG00000018899', u'ENSMUSG00000069874', u'ENSMUSG00000046879', u'ENSMUSG00000073489', u'ENSMUSG00000078853', u'ENSMUSG00000020464', u'ENSMUSG00000028270', u'ENSMUSG00000069893', u'ENSMUSG00000024349', u'ENSMUSG00000034459', u'ENSMUSG00000090942', u'ENSMUSG00000074896']), pop_n=13836, p_sm_bonferroni=0.009211658049552278, is_obsolete=False, GO='GO:0035458', name='cellular response to interferon-beta', pop_count=31, alt_ids=[], level=6, depth=6, enrichment='e', Cluster='Transient Increase', geneid_set=set([u'ENSMUSG00000068606', u'ENSMUSG00000018899', u'ENSMUSG00000034459', u'ENSMUSG00000039997', u'ENSMUSG00000046879', u'ENSMUSG00000078853', u'ENSMUSG00000078921', u'ENSMUSG00000054072', u'ENSMUSG00000026104', u'ENSMUSG00000074896']), symbols=u'Gm4841 Ifi203 Ifit1 Ifit3 Igtp Iigp1 Irf1 Irgm1 Stat1 Tgtp2', symbol_set=set([u'Irf1', u'Stat1', u'Gm4841', u'Tgtp2', u'Ifi203', u'Igtp', u'Ifit3', u'Iigp1', u'Ifit1', u'Irgm1']), geneids='ENSMUSG00000068606 ENSMUSG00000018899 ENSMUSG00000034459 ENSMUSG00000039997 ENSMUSG00000046879 ENSMUSG00000078853 ENSMUSG00000078921 ENSMUSG00000054072 ENSMUSG00000026104 ENSMUSG00000074896', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=0, D1='BF', GO_name='cellular response to interferon-beta'),
    Nt(p_uncorrected=2.0341930676437693e-07, study_count=10, study_n=624, namespace='biological_process', p_fdr_bh=3.8049455762803394e-05, study_items=set([u'ENSMUSG00000006398', u'ENSMUSG00000029521', u'ENSMUSG00000043065', u'ENSMUSG00000027469', u'ENSMUSG00000017716', u'ENSMUSG00000025474', u'ENSMUSG00000000759', u'ENSMUSG00000017861', u'ENSMUSG00000026622', u'ENSMUSG00000012443']), NS='BP', pop_items=set([u'ENSMUSG00000002546', u'ENSMUSG00000043065', u'ENSMUSG00000027469', u'ENSMUSG00000029521', u'ENSMUSG00000006398', u'ENSMUSG00000047126', u'ENSMUSG00000029029', u'ENSMUSG00000033186', u'ENSMUSG00000017861', u'ENSMUSG00000001440', u'ENSMUSG00000071176', u'ENSMUSG00000000759', u'ENSMUSG00000033900', u'ENSMUSG00000021693', u'ENSMUSG00000017421', u'ENSMUSG00000004771', u'ENSMUSG00000033790', u'ENSMUSG00000051786', u'ENSMUSG00000022064', u'ENSMUSG00000031328', u'ENSMUSG00000017716', u'ENSMUSG00000025474', u'ENSMUSG00000030965', u'ENSMUSG00000027263', u'ENSMUSG00000026622', u'ENSMUSG00000027475', u'ENSMUSG00000012443', u'ENSMUSG00000007815']), pop_n=13836, p_sm_bonferroni=0.0030820059167870747, is_obsolete=False, GO='GO:0090307', name='mitotic spindle assembly', pop_count=28, alt_ids=[], level=5, depth=8, enrichment='e', Cluster='Transient Increase', geneid_set=set([u'ENSMUSG00000029521', u'ENSMUSG00000043065', u'ENSMUSG00000027469', u'ENSMUSG00000006398', u'ENSMUSG00000017716', u'ENSMUSG00000025474', u'ENSMUSG00000000759', u'ENSMUSG00000017861', u'ENSMUSG00000026622', u'ENSMUSG00000012443']), symbols=u'Birc5 Cdc20 Chek2 Kif11 Mybl2 Nek2 Spice1 Tpx2 Tubgcp2 Tubgcp3', symbol_set=set([u'Tpx2', u'Mybl2', u'Nek2', u'Birc5', u'Cdc20', u'Kif11', u'Spice1', u'Tubgcp2', u'Tubgcp3', u'Chek2']), geneids='ENSMUSG00000043065 ENSMUSG00000029521 ENSMUSG00000006398 ENSMUSG00000027469 ENSMUSG00000017716 ENSMUSG00000025474 ENSMUSG00000000759 ENSMUSG00000017861 ENSMUSG00000026622 ENSMUSG00000012443', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=0, D1='BCH', GO_name='mitotic spindle assembly'),
    Nt(p_uncorrected='', study_count='', study_n='', namespace='', p_fdr_bh='', study_items='', NS='BP', pop_items='', pop_n='', p_sm_bonferroni='', is_obsolete='', GO='GO:0022402', name='', pop_count='', alt_ids='', level=2, depth=2, enrichment='', Cluster='', geneid_set='', symbols='', symbol_set='', geneids='', format_txt=1, hdr_idx=1, is_hdrgo=True, is_usrgo=False, hdr1usr01='*', dcnt=478, D1='B', GO_name='cell cycle process'),
    Nt(p_uncorrected='', study_count='', study_n='', namespace='', p_fdr_bh='', study_items='', NS='BP', pop_items='', pop_n='', p_sm_bonferroni='', is_obsolete='', GO='GO:0008219', name='', pop_count='', alt_ids='', level=3, depth=3, enrichment='', Cluster='', geneid_set='', symbols='', symbol_set='', geneids='', format_txt=1, hdr_idx=1, is_hdrgo=True, is_usrgo=False, hdr1usr01='*', dcnt=107, D1='BC', GO_name='cell death'),
    Nt(p_uncorrected='', study_count='', study_n='', namespace='', p_fdr_bh='', study_items='', NS='BP', pop_items='', pop_n='', p_sm_bonferroni='', is_obsolete='', GO='GO:0010941', name='', pop_count='', alt_ids='', level=4, depth=4, enrichment='', Cluster='', geneid_set='', symbols='', symbol_set='', geneids='', format_txt=1, hdr_idx=1, is_hdrgo=True, is_usrgo=False, hdr1usr01='*', dcnt=335, D1='A', GO_name='regulation of cell death'),
    Nt(p_uncorrected=2.89924240239775e-05, study_count=6, study_n=624, namespace='biological_process', p_fdr_bh=0.0030717777369740074, study_items=set([u'ENSMUSG00000032815', u'ENSMUSG00000009628', u'ENSMUSG00000019214', u'ENSMUSG00000034218', u'ENSMUSG00000027115', u'ENSMUSG00000026039']), NS='BP', pop_items=set([u'ENSMUSG00000032498', u'ENSMUSG00000032815', u'ENSMUSG00000019214', u'ENSMUSG00000059970', u'ENSMUSG00000021245', u'ENSMUSG00000042500', u'ENSMUSG00000026646', u'ENSMUSG00000009628', u'ENSMUSG00000028871', u'ENSMUSG00000063415', u'ENSMUSG00000026039', u'ENSMUSG00000034218', u'ENSMUSG00000041912', u'ENSMUSG00000027115', u'ENSMUSG00000029279']), pop_n=13836, p_sm_bonferroni=0.4392642163872831, is_obsolete=False, GO='GO:0007140', name='male meiosis', pop_count=15, alt_ids=[], level=4, depth=7, enrichment='e', Cluster='Transient Increase', geneid_set=set([u'ENSMUSG00000032815', u'ENSMUSG00000019214', u'ENSMUSG00000034218', u'ENSMUSG00000026039', u'ENSMUSG00000027115', u'ENSMUSG00000009628']), symbols=u'Atm Chtf18 Fanca Kif18a Sgol2a Tex15', symbol_set=set([u'Fanca', 'Sgol2a', u'Tex15', u'Atm', u'Kif18a', u'Chtf18']), geneids='ENSMUSG00000032815 ENSMUSG00000027115 ENSMUSG00000019214 ENSMUSG00000034218 ENSMUSG00000026039 ENSMUSG00000009628', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=0, D1='BHK', GO_name='male meiosis'),
    Nt(p_uncorrected='', study_count='', study_n='', namespace='', p_fdr_bh='', study_items='', NS='BP', pop_items='', pop_n='', p_sm_bonferroni='', is_obsolete='', GO='GO:0006325', name='', pop_count='', alt_ids='', level=4, depth=4, enrichment='', Cluster='', geneid_set='', symbols='', symbol_set='', geneids='', format_txt=1, hdr_idx=1, is_hdrgo=True, is_usrgo=False, hdr1usr01='*', dcnt=185, D1='BH', GO_name='chromatin organization'),
    Nt(p_uncorrected=6.48431637746412e-05, study_count=7, study_n=624, namespace='biological_process', p_fdr_bh=0.006338314673223154, study_items=set([u'ENSMUSG00000003873', u'ENSMUSG00000034023', u'ENSMUSG00000041147', u'ENSMUSG00000036986', u'ENSMUSG00000059552', u'ENSMUSG00000057789', u'ENSMUSG00000029521']), NS='BP', pop_items=set([u'ENSMUSG00000021871', u'ENSMUSG00000003873', u'ENSMUSG00000034023', u'ENSMUSG00000036986', u'ENSMUSG00000050697', u'ENSMUSG00000059552', u'ENSMUSG00000029026', u'ENSMUSG00000048787', u'ENSMUSG00000028933', u'ENSMUSG00000006818', u'ENSMUSG00000063856', u'ENSMUSG00000038028', u'ENSMUSG00000054051', u'ENSMUSG00000040613', u'ENSMUSG00000026395', u'ENSMUSG00000029521', u'ENSMUSG00000041147', u'ENSMUSG00000022672', u'ENSMUSG00000024947', u'ENSMUSG00000049717', u'ENSMUSG00000057789', u'ENSMUSG00000057329', u'ENSMUSG00000022346', u'ENSMUSG00000021615']), pop_n=13836, p_sm_bonferroni=0.9824387743495889, is_obsolete=False, GO='GO:0010332', name='response to gamma radiation', pop_count=24, alt_ids=[], level=5, depth=5, enrichment='e', Cluster='Transient Increase', geneid_set=set([u'ENSMUSG00000036986', u'ENSMUSG00000003873', u'ENSMUSG00000059552', u'ENSMUSG00000057789', u'ENSMUSG00000034023', u'ENSMUSG00000029521', u'ENSMUSG00000041147']), symbols=u'Bak1 Bax Brca2 Chek2 Fancd2 Pml Trp53', symbol_set=set([u'Brca2', u'Trp53', u'Bax', u'Bak1', u'Fancd2', u'Pml', u'Chek2']), geneids='ENSMUSG00000003873 ENSMUSG00000034023 ENSMUSG00000041147 ENSMUSG00000036986 ENSMUSG00000059552 ENSMUSG00000057789 ENSMUSG00000029521', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=1, D1='F', GO_name='response to gamma radiation'),
    Nt(p_uncorrected=0.00011390587371645838, study_count=7, study_n=624, namespace='biological_process', p_fdr_bh=0.009750214082926898, study_items=set([u'ENSMUSG00000028896', u'ENSMUSG00000027469', u'ENSMUSG00000022177', u'ENSMUSG00000024542', u'ENSMUSG00000078762', u'ENSMUSG00000012443', u'ENSMUSG00000019773']), NS='BP', pop_items=set([u'ENSMUSG00000027469', u'ENSMUSG00000033705', u'ENSMUSG00000024790', u'ENSMUSG00000027285', u'ENSMUSG00000018501', u'ENSMUSG00000025162', u'ENSMUSG00000041415', u'ENSMUSG00000031371', u'ENSMUSG00000022177', u'ENSMUSG00000063870', u'ENSMUSG00000038047', u'ENSMUSG00000019773', u'ENSMUSG00000001525', u'ENSMUSG00000033900', u'ENSMUSG00000034154', u'ENSMUSG00000041840', u'ENSMUSG00000078762', u'ENSMUSG00000030744', u'ENSMUSG00000028896', u'ENSMUSG00000035439', u'ENSMUSG00000002546', u'ENSMUSG00000031529', u'ENSMUSG00000024542', u'ENSMUSG00000024454', u'ENSMUSG00000012443', u'ENSMUSG00000079555']), pop_n=13836, p_sm_bonferroni=1.0, is_obsolete=False, GO='GO:0051225', name='spindle assembly', pop_count=26, alt_ids=['GO:0051226', 'GO:0051227'], level=4, depth=7, enrichment='e', Cluster='Transient Increase', geneid_set=set([u'ENSMUSG00000019773', u'ENSMUSG00000028896', u'ENSMUSG00000078762', u'ENSMUSG00000012443', u'ENSMUSG00000027469', u'ENSMUSG00000022177', u'ENSMUSG00000024542']), symbols=u'Cep192 Fbxo5 Haus4 Haus5 Kif11 Rcc1 Tpx2', symbol_set=set([u'Rcc1', u'Tpx2', u'Haus4', u'Haus5', u'Cep192', u'Fbxo5', u'Kif11']), geneids='ENSMUSG00000028896 ENSMUSG00000027469 ENSMUSG00000022177 ENSMUSG00000024542 ENSMUSG00000078762 ENSMUSG00000012443 ENSMUSG00000019773', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=12, D1='BCH', GO_name='spindle assembly'),
    Nt(p_uncorrected=6.987878234184759e-11, study_count=94, study_n=624, namespace='biological_process', p_fdr_bh=4.603188831571012e-08, study_items=set([u'ENSMUSG00000040084', u'ENSMUSG00000023015', u'ENSMUSG00000027469', u'ENSMUSG00000042029', u'ENSMUSG00000045328', u'ENSMUSG00000024974', u'ENSMUSG00000025358', u'ENSMUSG00000032782', u'ENSMUSG00000022177', u'ENSMUSG00000022070', u'ENSMUSG00000027379', u'ENSMUSG00000020897', u'ENSMUSG00000019773', u'ENSMUSG00000062510', u'ENSMUSG00000029521', u'ENSMUSG00000002068', u'ENSMUSG00000051378', u'ENSMUSG00000037313', u'ENSMUSG00000027715', u'ENSMUSG00000032254', u'ENSMUSG00000006398', u'ENSMUSG00000072082', u'ENSMUSG00000027496', u'ENSMUSG00000029283', u'ENSMUSG00000024660', u'ENSMUSG00000026622', u'ENSMUSG00000078762', u'ENSMUSG00000032218', u'ENSMUSG00000027306', u'ENSMUSG00000024056', u'ENSMUSG00000048922', u'ENSMUSG00000034906', u'ENSMUSG00000056394', u'ENSMUSG00000032397', u'ENSMUSG00000021965', u'ENSMUSG00000034349', u'ENSMUSG00000030867', u'ENSMUSG00000041498', u'ENSMUSG00000047534', u'ENSMUSG00000032400', u'ENSMUSG00000028312', u'ENSMUSG00000021115', u'ENSMUSG00000028896', u'ENSMUSG00000032477', u'ENSMUSG00000026683', u'ENSMUSG00000027326', u'ENSMUSG00000027635', u'ENSMUSG00000003824', u'ENSMUSG00000040034', u'ENSMUSG00000026039', u'ENSMUSG00000029414', u'ENSMUSG00000028066', u'ENSMUSG00000001403', u'ENSMUSG00000002055', u'ENSMUSG00000051220', u'ENSMUSG00000033364', u'ENSMUSG00000041431', u'ENSMUSG00000041238', u'ENSMUSG00000039994', u'ENSMUSG00000027331', u'ENSMUSG00000020492', u'ENSMUSG00000041133', u'ENSMUSG00000024989', u'ENSMUSG00000027699', u'ENSMUSG00000033952', u'ENSMUSG00000038252', u'ENSMUSG00000025001', u'ENSMUSG00000040599', u'ENSMUSG00000028873', u'ENSMUSG00000028678', u'ENSMUSG00000029472', u'ENSMUSG00000024795', u'ENSMUSG00000023940', u'ENSMUSG00000023505', u'ENSMUSG00000019942', u'ENSMUSG00000026779', u'ENSMUSG00000035024', u'ENSMUSG00000020326', u'ENSMUSG00000069910', u'ENSMUSG00000028212', u'ENSMUSG00000074476', u'ENSMUSG00000073705', u'ENSMUSG00000068744', u'ENSMUSG00000038943', u'ENSMUSG00000026088', u'ENSMUSG00000012443', u'ENSMUSG00000017499', u'ENSMUSG00000031478', u'ENSMUSG00000043065', u'ENSMUSG00000020808', u'ENSMUSG00000017716', u'ENSMUSG00000029910', u'ENSMUSG00000062248', u'ENSMUSG00000005233']), NS='BP', pop_items=set([u'ENSMUSG00000066842', u'ENSMUSG00000029414', u'ENSMUSG00000040084', u'ENSMUSG00000000001', u'ENSMUSG00000026491', u'ENSMUSG00000051378', u'ENSMUSG00000024073', u'ENSMUSG00000029516', u'ENSMUSG00000026965', u'ENSMUSG00000027330', u'ENSMUSG00000027469', u'ENSMUSG00000042029', u'ENSMUSG00000045328', u'ENSMUSG00000006005', u'ENSMUSG00000024974', u'ENSMUSG00000020697', u'ENSMUSG00000025358', u'ENSMUSG00000017639', u'ENSMUSG00000022089', u'ENSMUSG00000027937', u'ENSMUSG00000025001', u'ENSMUSG00000059248', u'ENSMUSG00000030649', u'ENSMUSG00000024370', u'ENSMUSG00000022456', u'ENSMUSG00000033088', u'ENSMUSG00000001403', u'ENSMUSG00000032782', u'ENSMUSG00000039128', u'ENSMUSG00000025616', u'ENSMUSG00000040250', u'ENSMUSG00000024277', u'ENSMUSG00000022177', u'ENSMUSG00000011589', u'ENSMUSG00000041769', u'ENSMUSG00000070348', u'ENSMUSG00000022070', u'ENSMUSG00000020752', u'ENSMUSG00000020897', u'ENSMUSG00000053119', u'ENSMUSG00000022772', u'ENSMUSG00000015120', u'ENSMUSG00000075266', u'ENSMUSG00000019773', u'ENSMUSG00000026779', u'ENSMUSG00000024286', u'ENSMUSG00000027654', u'ENSMUSG00000029521', u'ENSMUSG00000012429', u'ENSMUSG00000056305', u'ENSMUSG00000031176', u'ENSMUSG00000021693', u'ENSMUSG00000017421', u'ENSMUSG00000032400', u'ENSMUSG00000002068', u'ENSMUSG00000027550', u'ENSMUSG00000011831', u'ENSMUSG00000033392', u'ENSMUSG00000058013', u'ENSMUSG00000045038', u'ENSMUSG00000019988', u'ENSMUSG00000039660', u'ENSMUSG00000037313', u'ENSMUSG00000022678', u'ENSMUSG00000021959', u'ENSMUSG00000026276', u'ENSMUSG00000031347', u'ENSMUSG00000005699', u'ENSMUSG00000033323', u'ENSMUSG00000027496', u'ENSMUSG00000022314', u'ENSMUSG00000002546', u'ENSMUSG00000006398', u'ENSMUSG00000028926', u'ENSMUSG00000009907', u'ENSMUSG00000019917', u'ENSMUSG00000027285', u'ENSMUSG00000020107', u'ENSMUSG00000031971', u'ENSMUSG00000021115', u'ENSMUSG00000025925', u'ENSMUSG00000035439', u'ENSMUSG00000036977', u'ENSMUSG00000004591', u'ENSMUSG00000020745', u'ENSMUSG00000027306', u'ENSMUSG00000029430', u'ENSMUSG00000064128', u'ENSMUSG00000020415', u'ENSMUSG00000031242', u'ENSMUSG00000069910', u'ENSMUSG00000008859', u'ENSMUSG00000066149', u'ENSMUSG00000018509', u'ENSMUSG00000034021', u'ENSMUSG00000072082', u'ENSMUSG00000034906', u'ENSMUSG00000028212', u'ENSMUSG00000025035', u'ENSMUSG00000070923', u'ENSMUSG00000040957', u'ENSMUSG00000056394', u'ENSMUSG00000025135', u'ENSMUSG00000032397', u'ENSMUSG00000000743', u'ENSMUSG00000050379', u'ENSMUSG00000032562', u'ENSMUSG00000040385', u'ENSMUSG00000021965', u'ENSMUSG00000047126', u'ENSMUSG00000023015', u'ENSMUSG00000021375', u'ENSMUSG00000030867', u'ENSMUSG00000040021', u'ENSMUSG00000041498', u'ENSMUSG00000047534', u'ENSMUSG00000015149', u'ENSMUSG00000034349', u'ENSMUSG00000029472', u'ENSMUSG00000037098', u'ENSMUSG00000036782', u'ENSMUSG00000035351', u'ENSMUSG00000021276', u'ENSMUSG00000006728', u'ENSMUSG00000031010', u'ENSMUSG00000029466', u'ENSMUSG00000029283', u'ENSMUSG00000028312', u'ENSMUSG00000050930', u'ENSMUSG00000034290', u'ENSMUSG00000066979', u'ENSMUSG00000038902', u'ENSMUSG00000026622', u'ENSMUSG00000069089', u'ENSMUSG00000007721', u'ENSMUSG00000028549', u'ENSMUSG00000025144', u'ENSMUSG00000046010', u'ENSMUSG00000039130', u'ENSMUSG00000028896', u'ENSMUSG00000007815', u'ENSMUSG00000002365', u'ENSMUSG00000032477', u'ENSMUSG00000029253', u'ENSMUSG00000075324', u'ENSMUSG00000029385', u'ENSMUSG00000027326', u'ENSMUSG00000027635', u'ENSMUSG00000024943', u'ENSMUSG00000003824', u'ENSMUSG00000020486', u'ENSMUSG00000040034', u'ENSMUSG00000040549', u'ENSMUSG00000024576', u'ENSMUSG00000012443', u'ENSMUSG00000035342', u'ENSMUSG00000079555', u'ENSMUSG00000024660', u'ENSMUSG00000033444', u'ENSMUSG00000052062', u'ENSMUSG00000036923', u'ENSMUSG00000028066', u'ENSMUSG00000079562', u'ENSMUSG00000026927', u'ENSMUSG00000033952', u'ENSMUSG00000029554', u'ENSMUSG00000002055', u'ENSMUSG00000038943', u'ENSMUSG00000024137', u'ENSMUSG00000051220', u'ENSMUSG00000028478', u'ENSMUSG00000036777', u'ENSMUSG00000042364', u'ENSMUSG00000036779', u'ENSMUSG00000033364', u'ENSMUSG00000030397', u'ENSMUSG00000057614', u'ENSMUSG00000072214', u'ENSMUSG00000021595', u'ENSMUSG00000041431', u'ENSMUSG00000041238', u'ENSMUSG00000039994', u'ENSMUSG00000021483', u'ENSMUSG00000032504', u'ENSMUSG00000031820', u'ENSMUSG00000027331', u'ENSMUSG00000066440', u'ENSMUSG00000021866', u'ENSMUSG00000043065', u'ENSMUSG00000031787', u'ENSMUSG00000032264', u'ENSMUSG00000005233', u'ENSMUSG00000024056', u'ENSMUSG00000090083', u'ENSMUSG00000020492', u'ENSMUSG00000022978', u'ENSMUSG00000019923', u'ENSMUSG00000025812', u'ENSMUSG00000035086', u'ENSMUSG00000027699', u'ENSMUSG00000021258', u'ENSMUSG00000057110', u'ENSMUSG00000033900', u'ENSMUSG00000020235', u'ENSMUSG00000030079', u'ENSMUSG00000034165', u'ENSMUSG00000028873', u'ENSMUSG00000059586', u'ENSMUSG00000014668', u'ENSMUSG00000038416', u'ENSMUSG00000043987', u'ENSMUSG00000038252', u'ENSMUSG00000049717', u'ENSMUSG00000035486', u'ENSMUSG00000078762', u'ENSMUSG00000022105', u'ENSMUSG00000030538', u'ENSMUSG00000029166', u'ENSMUSG00000048922', u'ENSMUSG00000040599', u'ENSMUSG00000029176', u'ENSMUSG00000044641', u'ENSMUSG00000040274', u'ENSMUSG00000026349', u'ENSMUSG00000032254', u'ENSMUSG00000024795', u'ENSMUSG00000024989', u'ENSMUSG00000032218', u'ENSMUSG00000030965', u'ENSMUSG00000037286', u'ENSMUSG00000041133', u'ENSMUSG00000033209', u'ENSMUSG00000026749', u'ENSMUSG00000071350', u'ENSMUSG00000065954', u'ENSMUSG00000035048', u'ENSMUSG00000041408', u'ENSMUSG00000036672', u'ENSMUSG00000022802', u'ENSMUSG00000021918', u'ENSMUSG00000028969', u'ENSMUSG00000038990', u'ENSMUSG00000056214', u'ENSMUSG00000014402', u'ENSMUSG00000047777', u'ENSMUSG00000032479', u'ENSMUSG00000021537', u'ENSMUSG00000044502', u'ENSMUSG00000019794', u'ENSMUSG00000027715', u'ENSMUSG00000027379', u'ENSMUSG00000053333', u'ENSMUSG00000033628', u'ENSMUSG00000017716', u'ENSMUSG00000031201', u'ENSMUSG00000021365', u'ENSMUSG00000024790', u'ENSMUSG00000048170', u'ENSMUSG00000023940', u'ENSMUSG00000025077', u'ENSMUSG00000014355', u'ENSMUSG00000011960', u'ENSMUSG00000026426', u'ENSMUSG00000031016', u'ENSMUSG00000001833', u'ENSMUSG00000040945', u'ENSMUSG00000023505', u'ENSMUSG00000028447', u'ENSMUSG00000052087', u'ENSMUSG00000019942', u'ENSMUSG00000029003', u'ENSMUSG00000031729', u'ENSMUSG00000014956', u'ENSMUSG00000040102', u'ENSMUSG00000022750', u'ENSMUSG00000038619', u'ENSMUSG00000060860', u'ENSMUSG00000035024', u'ENSMUSG00000029684', u'ENSMUSG00000020326', u'ENSMUSG00000068580', u'ENSMUSG00000028059', u'ENSMUSG00000029501', u'ENSMUSG00000061665', u'ENSMUSG00000025862', u'ENSMUSG00000074476', u'ENSMUSG00000034154', u'ENSMUSG00000028678', u'ENSMUSG00000024068', u'ENSMUSG00000044147', u'ENSMUSG00000041840', u'ENSMUSG00000073705', u'ENSMUSG00000068744', u'ENSMUSG00000030105', u'ENSMUSG00000073700', u'ENSMUSG00000031644', u'ENSMUSG00000026088', u'ENSMUSG00000049327', u'ENSMUSG00000004451', u'ENSMUSG00000026039', u'ENSMUSG00000030744', u'ENSMUSG00000000184', u'ENSMUSG00000017499', u'ENSMUSG00000042275', u'ENSMUSG00000053046', u'ENSMUSG00000031478', u'ENSMUSG00000064302', u'ENSMUSG00000020808', u'ENSMUSG00000062510', u'ENSMUSG00000032435', u'ENSMUSG00000031529', u'ENSMUSG00000029910', u'ENSMUSG00000033502', u'ENSMUSG00000031913', u'ENSMUSG00000052139', u'ENSMUSG00000028851', u'ENSMUSG00000032534', u'ENSMUSG00000062248', u'ENSMUSG00000027479', u'ENSMUSG00000019873', u'ENSMUSG00000031371', u'ENSMUSG00000007656', u'ENSMUSG00000015971', u'ENSMUSG00000032733', u'ENSMUSG00000079614', u'ENSMUSG00000031858', u'ENSMUSG00000026683']), pop_n=13836, p_sm_bonferroni=1.058733431261333e-06, is_obsolete=False, GO='GO:0051301', name='cell division', pop_count=327, alt_ids=[], level=3, depth=3, enrichment='e', Cluster='Transient Increase', geneid_set=set([u'ENSMUSG00000029414', u'ENSMUSG00000040084', u'ENSMUSG00000034349', u'ENSMUSG00000028066', u'ENSMUSG00000001403', u'ENSMUSG00000033952', u'ENSMUSG00000027469', u'ENSMUSG00000037313', u'ENSMUSG00000045328', u'ENSMUSG00000024974', u'ENSMUSG00000025358', u'ENSMUSG00000051220', u'ENSMUSG00000033364', u'ENSMUSG00000041431', u'ENSMUSG00000032782', u'ENSMUSG00000039994', u'ENSMUSG00000022177', u'ENSMUSG00000043065', u'ENSMUSG00000027331', u'ENSMUSG00000022070', u'ENSMUSG00000027379', u'ENSMUSG00000024056', u'ENSMUSG00000020897', u'ENSMUSG00000020492', u'ENSMUSG00000041133', u'ENSMUSG00000024989', u'ENSMUSG00000019773', u'ENSMUSG00000062510', u'ENSMUSG00000027699', u'ENSMUSG00000029521', u'ENSMUSG00000002068', u'ENSMUSG00000024660', u'ENSMUSG00000038252', u'ENSMUSG00000051378', u'ENSMUSG00000042029', u'ENSMUSG00000025001', u'ENSMUSG00000040599', u'ENSMUSG00000012443', u'ENSMUSG00000002055', u'ENSMUSG00000027715', u'ENSMUSG00000032254', u'ENSMUSG00000006398', u'ENSMUSG00000072082', u'ENSMUSG00000027496', u'ENSMUSG00000029283', u'ENSMUSG00000026622', u'ENSMUSG00000078762', u'ENSMUSG00000032218', u'ENSMUSG00000041238', u'ENSMUSG00000027306', u'ENSMUSG00000029472', u'ENSMUSG00000048922', u'ENSMUSG00000024795', u'ENSMUSG00000034906', u'ENSMUSG00000023940', u'ENSMUSG00000056394', u'ENSMUSG00000032397', u'ENSMUSG00000023505', u'ENSMUSG00000021965', u'ENSMUSG00000023015', u'ENSMUSG00000030867', u'ENSMUSG00000041498', u'ENSMUSG00000047534', u'ENSMUSG00000026779', u'ENSMUSG00000032400', u'ENSMUSG00000062248', u'ENSMUSG00000020326', u'ENSMUSG00000019942', u'ENSMUSG00000069910', u'ENSMUSG00000028212', u'ENSMUSG00000028312', u'ENSMUSG00000031478', u'ENSMUSG00000074476', u'ENSMUSG00000028678', u'ENSMUSG00000021115', u'ENSMUSG00000073705', u'ENSMUSG00000068744', u'ENSMUSG00000038943', u'ENSMUSG00000026088', u'ENSMUSG00000028873', u'ENSMUSG00000017499', u'ENSMUSG00000028896', u'ENSMUSG00000032477', u'ENSMUSG00000026683', u'ENSMUSG00000020808', u'ENSMUSG00000027326', u'ENSMUSG00000027635', u'ENSMUSG00000017716', u'ENSMUSG00000029910', u'ENSMUSG00000003824', u'ENSMUSG00000040034', u'ENSMUSG00000035024', u'ENSMUSG00000005233', u'ENSMUSG00000026039']), symbols=u'Anapc5 Apitd1 Aspm Aurka Aurkb Birc5 Bora Bub1 Bub1b Ccna2 Ccnb1 Ccnb2 Ccne1 Ccne2 Ccnf Ccng1 Cdc20 Cdc25a Cdc6 Cdc7 Cdca2 Cdca3 Cdca8 Cdk1 Cdk2 Cenpe Cep55 Chek2 Cks2 Cntrob Dsn1 Ect2 Ercc6l Fam64a Fbxo5 Haus4 Haus5 Hells Incenp Kif11 Kif14 Kif18b Kif20b Kif23 Kif2c Knl1 Knstrn Kntc1 Lig1 Mad2l1 Mastl Mis12 Mis18bp1 Mitd1 Ncapd2 Ncapd3 Ncapg2 Ncaph Ndc80 Nek2 Nek3 Nsl1 Nuf2 Nup43 Nusap1 Plk1 Pmf1 Prc1 Psrc1 Racgap1 Rbbp8 Rcc1 Sgol1 Sgol2a Ska2 Ska3 Smc1a Smc2 Smc3 Smc4 Spag5 Spc24 Spc25 Spdl1 Spice1 Syce2 Tacc3 Timeless Tipin Tpx2 Ube2c Usp37 Vrk1 Zwilch', symbol_set=set([u'Ncapg2', 'Spdl1', u'Cep55', u'Mitd1', u'Ccnf', u'Rbbp8', u'Mis12', u'Chek2', 'Sgol2a', u'Ccng1', 'Ska3', 'Ska2', u'Fam64a', u'Lig1', u'Ccna2', u'Cenpe', u'Tacc3', u'Dsn1', u'Ncapd2', u'Ncapd3', u'Kif14', u'Syce2', u'Kif11', u'Prc1', u'Smc1a', u'Rcc1', u'Cdc25a', u'Ccnb2', u'Ccnb1', u'Racgap1', u'Aspm', u'Ndc80', u'Cdc6', u'Cdc7', u'Tpx2', u'Mad2l1', u'Pmf1', u'Bub1b', u'Anapc5', u'Ercc6l', u'Aurka', u'Aurkb', u'Spc25', u'Spc24', u'Hells', u'Kntc1', u'Timeless', u'Incenp', u'Spag5', u'Cdk1', u'Cdk2', u'Ncaph', 'Bora', u'Nuf2', u'Haus4', u'Haus5', u'Spice1', u'Nek2', u'Nek3', u'Ect2', u'Sgol1', u'Kif18b', u'Cks2', u'Nsl1', u'Ccne2', u'Ccne1', u'Nusap1', u'Tipin', u'Cdc20', u'Fbxo5', u'Zwilch', 'Knstrn', u'Psrc1', u'Mis18bp1', u'Ube2c', u'Cdca2', u'Cdca3', u'Bub1', u'Cdca8', u'Kif20b', u'Smc3', u'Smc2', u'Mastl', u'Smc4', u'Kif23', u'Apitd1', 'Knl1', u'Vrk1', u'Plk1', u'Cntrob', u'Usp37', u'Birc5', u'Nup43', u'Kif2c']), geneids='ENSMUSG00000040084 ENSMUSG00000034349 ENSMUSG00000027469 ENSMUSG00000037313 ENSMUSG00000045328 ENSMUSG00000024974 ENSMUSG00000025358 ENSMUSG00000032782 ENSMUSG00000022177 ENSMUSG00000022070 ENSMUSG00000027379 ENSMUSG00000033952 ENSMUSG00000019773 ENSMUSG00000062510 ENSMUSG00000029521 ENSMUSG00000002068 ENSMUSG00000051378 ENSMUSG00000042029 ENSMUSG00000027715 ENSMUSG00000032254 ENSMUSG00000027306 ENSMUSG00000072082 ENSMUSG00000027496 ENSMUSG00000029283 ENSMUSG00000024660 ENSMUSG00000026622 ENSMUSG00000078762 ENSMUSG00000028873 ENSMUSG00000006398 ENSMUSG00000048922 ENSMUSG00000034906 ENSMUSG00000056394 ENSMUSG00000032397 ENSMUSG00000021965 ENSMUSG00000023015 ENSMUSG00000030867 ENSMUSG00000041498 ENSMUSG00000047534 ENSMUSG00000032400 ENSMUSG00000028312 ENSMUSG00000021115 ENSMUSG00000043065 ENSMUSG00000032477 ENSMUSG00000026683 ENSMUSG00000027326 ENSMUSG00000027635 ENSMUSG00000003824 ENSMUSG00000040034 ENSMUSG00000026039 ENSMUSG00000029414 ENSMUSG00000028066 ENSMUSG00000001403 ENSMUSG00000002055 ENSMUSG00000051220 ENSMUSG00000033364 ENSMUSG00000041431 ENSMUSG00000041238 ENSMUSG00000039994 ENSMUSG00000027331 ENSMUSG00000024056 ENSMUSG00000020492 ENSMUSG00000041133 ENSMUSG00000024989 ENSMUSG00000027699 ENSMUSG00000028896 ENSMUSG00000020897 ENSMUSG00000038252 ENSMUSG00000025001 ENSMUSG00000040599 ENSMUSG00000032218 ENSMUSG00000028678 ENSMUSG00000029472 ENSMUSG00000024795 ENSMUSG00000023940 ENSMUSG00000023505 ENSMUSG00000019942 ENSMUSG00000026779 ENSMUSG00000062248 ENSMUSG00000020326 ENSMUSG00000069910 ENSMUSG00000028212 ENSMUSG00000074476 ENSMUSG00000073705 ENSMUSG00000068744 ENSMUSG00000038943 ENSMUSG00000026088 ENSMUSG00000012443 ENSMUSG00000017499 ENSMUSG00000031478 ENSMUSG00000020808 ENSMUSG00000017716 ENSMUSG00000029910 ENSMUSG00000035024 ENSMUSG00000005233', format_txt=1, hdr_idx=1, is_hdrgo=True, is_usrgo=True, hdr1usr01='**', dcnt=54, D1='BC', GO_name='cell division'),
    Nt(p_uncorrected=6.48431637746412e-05, study_count=7, study_n=624, namespace='biological_process', p_fdr_bh=0.006338314673223154, study_items=set([u'ENSMUSG00000017499', u'ENSMUSG00000027699', u'ENSMUSG00000032254', u'ENSMUSG00000023015', u'ENSMUSG00000024795', u'ENSMUSG00000041498', u'ENSMUSG00000020897']), NS='BP', pop_items=set([u'ENSMUSG00000029516', u'ENSMUSG00000024795', u'ENSMUSG00000018509', u'ENSMUSG00000005533', u'ENSMUSG00000023015', u'ENSMUSG00000004591', u'ENSMUSG00000004364', u'ENSMUSG00000041498', u'ENSMUSG00000027330', u'ENSMUSG00000020897', u'ENSMUSG00000053119', u'ENSMUSG00000019433', u'ENSMUSG00000060735', u'ENSMUSG00000027699', u'ENSMUSG00000050930', u'ENSMUSG00000024068', u'ENSMUSG00000045038', u'ENSMUSG00000026991', u'ENSMUSG00000056763', u'ENSMUSG00000017499', u'ENSMUSG00000032259', u'ENSMUSG00000032254', u'ENSMUSG00000027475', u'ENSMUSG00000007815']), pop_n=13836, p_sm_bonferroni=0.9824387743495889, is_obsolete=False, GO='GO:0032467', name='positive regulation of cytokinesis', pop_count=24, alt_ids=['GO:0071777'], level=6, depth=7, enrichment='e', Cluster='Transient Increase', geneid_set=set([u'ENSMUSG00000017499', u'ENSMUSG00000027699', u'ENSMUSG00000041498', u'ENSMUSG00000024795', u'ENSMUSG00000020897', u'ENSMUSG00000032254', u'ENSMUSG00000023015']), symbols=u'Aurkb Cdc6 Ect2 Kif14 Kif20b Kif23 Racgap1', symbol_set=set([u'Ect2', u'Racgap1', u'Kif23', u'Kif14', u'Aurkb', u'Kif20b', u'Cdc6']), geneids='ENSMUSG00000017499 ENSMUSG00000027699 ENSMUSG00000032254 ENSMUSG00000023015 ENSMUSG00000024795 ENSMUSG00000041498 ENSMUSG00000020897', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=18, D1='A', GO_name='positive regulation of cytokinesis'),
    Nt(p_uncorrected=0.00012842189570401926, study_count=10, study_n=624, namespace='biological_process', p_fdr_bh=0.010589769276871469, study_items=set([u'ENSMUSG00000003873', u'ENSMUSG00000002083', u'ENSMUSG00000024521', u'ENSMUSG00000036986', u'ENSMUSG00000004446', u'ENSMUSG00000026104', u'ENSMUSG00000028282', u'ENSMUSG00000019979', u'ENSMUSG00000057789', u'ENSMUSG00000025507']), NS='BP', pop_items=set([u'ENSMUSG00000003955', u'ENSMUSG00000024012', u'ENSMUSG00000003873', u'ENSMUSG00000029433', u'ENSMUSG00000021576', u'ENSMUSG00000039168', u'ENSMUSG00000030793', u'ENSMUSG00000036986', u'ENSMUSG00000028282', u'ENSMUSG00000003031', u'ENSMUSG00000030110', u'ENSMUSG00000004446', u'ENSMUSG00000024959', u'ENSMUSG00000026029', u'ENSMUSG00000028914', u'ENSMUSG00000022346', u'ENSMUSG00000039959', u'ENSMUSG00000004069', u'ENSMUSG00000023030', u'ENSMUSG00000025507', u'ENSMUSG00000048376', u'ENSMUSG00000032402', u'ENSMUSG00000038007', u'ENSMUSG00000026104', u'ENSMUSG00000019979', u'ENSMUSG00000057789', u'ENSMUSG00000079465', u'ENSMUSG00000024066', u'ENSMUSG00000000915', u'ENSMUSG00000028191', u'ENSMUSG00000020372', u'ENSMUSG00000036932', u'ENSMUSG00000033075', u'ENSMUSG00000025889', u'ENSMUSG00000024789', u'ENSMUSG00000022883', u'ENSMUSG00000031668', u'ENSMUSG00000051234', u'ENSMUSG00000026278', u'ENSMUSG00000025980', u'ENSMUSG00000028452', u'ENSMUSG00000031523', u'ENSMUSG00000002083', u'ENSMUSG00000024521', u'ENSMUSG00000028128', u'ENSMUSG00000070390', u'ENSMUSG00000032691', u'ENSMUSG00000045867', u'ENSMUSG00000027381', u'ENSMUSG00000032532', u'ENSMUSG00000038058', u'ENSMUSG00000014771', u'ENSMUSG00000041241', u'ENSMUSG00000032965']), pop_n=13836, p_sm_bonferroni=1.0, is_obsolete=False, GO='GO:0006919', name='activation of cysteine-type endopeptidase activity involved in apoptotic process', pop_count=54, alt_ids=[], level=9, depth=13, enrichment='e', Cluster='Transient Increase', geneid_set=set([u'ENSMUSG00000003873', u'ENSMUSG00000002083', u'ENSMUSG00000024521', u'ENSMUSG00000036986', u'ENSMUSG00000028282', u'ENSMUSG00000026104', u'ENSMUSG00000004446', u'ENSMUSG00000057789', u'ENSMUSG00000025507', u'ENSMUSG00000019979']), symbols=u'Apaf1 Bak1 Bax Bbc3 Bid Casp8ap2 Pidd1 Pmaip1 Pml Stat1', symbol_set=set([u'Pmaip1', u'Stat1', u'Casp8ap2', u'Bax', u'Bak1', u'Pml', u'Bbc3', 'Pidd1', u'Bid', u'Apaf1']), geneids='ENSMUSG00000019979 ENSMUSG00000002083 ENSMUSG00000024521 ENSMUSG00000036986 ENSMUSG00000025507 ENSMUSG00000028282 ENSMUSG00000026104 ENSMUSG00000004446 ENSMUSG00000057789 ENSMUSG00000003873', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=1, D1='A', GO_name='activation of cysteine-type endopeptidase activity involved in apoptotic process'),
    Nt(p_uncorrected=4.7830996364588304e-08, study_count=29, study_n=624, namespace='biological_process', p_fdr_bh=1.0502716317679384e-05, study_items=set([u'ENSMUSG00000032661', u'ENSMUSG00000070034', u'ENSMUSG00000046718', u'ENSMUSG00000074151', u'ENSMUSG00000036986', u'ENSMUSG00000074896', u'ENSMUSG00000041827', u'ENSMUSG00000032508', u'ENSMUSG00000023341', u'ENSMUSG00000054072', u'ENSMUSG00000021624', u'ENSMUSG00000039236', u'ENSMUSG00000054717', u'ENSMUSG00000018899', u'ENSMUSG00000027514', u'ENSMUSG00000024079', u'ENSMUSG00000046879', u'ENSMUSG00000029561', u'ENSMUSG00000017830', u'ENSMUSG00000005566', u'ENSMUSG00000029605', u'ENSMUSG00000026896', u'ENSMUSG00000034459', u'ENSMUSG00000025498', u'ENSMUSG00000040296', u'ENSMUSG00000032344', u'ENSMUSG00000020641', u'ENSMUSG00000045932', u'ENSMUSG00000000386']), NS='BP', pop_items=set([u'ENSMUSG00000028099', u'ENSMUSG00000035834', u'ENSMUSG00000045322', u'ENSMUSG00000028874', u'ENSMUSG00000031103', u'ENSMUSG00000021703', u'ENSMUSG00000024079', u'ENSMUSG00000074151', u'ENSMUSG00000016481', u'ENSMUSG00000055172', u'ENSMUSG00000036887', u'ENSMUSG00000009585', u'ENSMUSG00000020455', u'ENSMUSG00000047123', u'ENSMUSG00000022476', u'ENSMUSG00000024371', u'ENSMUSG00000042228', u'ENSMUSG00000000266', u'ENSMUSG00000017707', u'ENSMUSG00000071369', u'ENSMUSG00000026399', u'ENSMUSG00000037523', u'ENSMUSG00000038628', u'ENSMUSG00000020115', u'ENSMUSG00000076617', u'ENSMUSG00000000776', u'ENSMUSG00000019843', u'ENSMUSG00000035235', u'ENSMUSG00000015217', u'ENSMUSG00000028530', u'ENSMUSG00000039236', u'ENSMUSG00000036908', u'ENSMUSG00000024164', u'ENSMUSG00000026842', u'ENSMUSG00000020275', u'ENSMUSG00000024045', u'ENSMUSG00000015340', u'ENSMUSG00000075705', u'ENSMUSG00000025280', u'ENSMUSG00000022791', u'ENSMUSG00000005566', u'ENSMUSG00000026596', u'ENSMUSG00000029605', u'ENSMUSG00000026896', u'ENSMUSG00000025199', u'ENSMUSG00000014599', u'ENSMUSG00000022607', u'ENSMUSG00000030966', u'ENSMUSG00000032312', u'ENSMUSG00000051439', u'ENSMUSG00000038058', u'ENSMUSG00000025512', u'ENSMUSG00000050199', u'ENSMUSG00000026154', u'ENSMUSG00000001366', u'ENSMUSG00000000275', u'ENSMUSG00000027951', u'ENSMUSG00000021326', u'ENSMUSG00000070390', u'ENSMUSG00000036986', u'ENSMUSG00000025139', u'ENSMUSG00000004707', u'ENSMUSG00000025034', u'ENSMUSG00000026883', u'ENSMUSG00000058715', u'ENSMUSG00000032691', u'ENSMUSG00000018446', u'ENSMUSG00000006519', u'ENSMUSG00000027995', u'ENSMUSG00000028885', u'ENSMUSG00000029826', u'ENSMUSG00000027646', u'ENSMUSG00000003184', u'ENSMUSG00000031805', u'ENSMUSG00000016024', u'ENSMUSG00000054072', u'ENSMUSG00000051675', u'ENSMUSG00000037860', u'ENSMUSG00000036905', u'ENSMUSG00000004933', u'ENSMUSG00000031392', u'ENSMUSG00000060591', u'ENSMUSG00000055204', u'ENSMUSG00000041000', u'ENSMUSG00000045932', u'ENSMUSG00000072115', u'ENSMUSG00000033777', u'ENSMUSG00000059883', u'ENSMUSG00000027598', u'ENSMUSG00000003283', u'ENSMUSG00000033124', u'ENSMUSG00000044583', u'ENSMUSG00000002688', u'ENSMUSG00000039853', u'ENSMUSG00000078942', u'ENSMUSG00000078945', u'ENSMUSG00000027639', u'ENSMUSG00000033307', u'ENSMUSG00000034889', u'ENSMUSG00000000787', u'ENSMUSG00000034453', u'ENSMUSG00000020641', u'ENSMUSG00000024457', u'ENSMUSG00000023992', u'ENSMUSG00000025532', u'ENSMUSG00000000386', u'ENSMUSG00000052384', u'ENSMUSG00000070034', u'ENSMUSG00000027427', u'ENSMUSG00000026928', u'ENSMUSG00000035279', u'ENSMUSG00000030793', u'ENSMUSG00000021457', u'ENSMUSG00000074896', u'ENSMUSG00000024948', u'ENSMUSG00000031639', u'ENSMUSG00000020823', u'ENSMUSG00000028041', u'ENSMUSG00000025498', u'ENSMUSG00000032508', u'ENSMUSG00000002602', u'ENSMUSG00000053647', u'ENSMUSG00000053158', u'ENSMUSG00000024621', u'ENSMUSG00000066232', u'ENSMUSG00000036896', u'ENSMUSG00000025225', u'ENSMUSG00000071203', u'ENSMUSG00000030880', u'ENSMUSG00000032175', u'ENSMUSG00000041135', u'ENSMUSG00000014932', u'ENSMUSG00000021624', u'ENSMUSG00000020707', u'ENSMUSG00000017830', u'ENSMUSG00000046879', u'ENSMUSG00000024349', u'ENSMUSG00000033454', u'ENSMUSG00000022514', u'ENSMUSG00000022887', u'ENSMUSG00000023973', u'ENSMUSG00000043496', u'ENSMUSG00000057982', u'ENSMUSG00000036712', u'ENSMUSG00000025492', u'ENSMUSG00000032109', u'ENSMUSG00000060802', u'ENSMUSG00000029798', u'ENSMUSG00000032344', u'ENSMUSG00000059456', u'ENSMUSG00000026117', u'ENSMUSG00000040296', u'ENSMUSG00000032690', u'ENSMUSG00000056851', u'ENSMUSG00000038160', u'ENSMUSG00000022043', u'ENSMUSG00000034317', u'ENSMUSG00000001128', u'ENSMUSG00000029771', u'ENSMUSG00000013707', u'ENSMUSG00000032661', u'ENSMUSG00000038521', u'ENSMUSG00000020399', u'ENSMUSG00000031750', u'ENSMUSG00000046718', u'ENSMUSG00000024927', u'ENSMUSG00000031537', u'ENSMUSG00000024483', u'ENSMUSG00000050335', u'ENSMUSG00000032688', u'ENSMUSG00000026471', u'ENSMUSG00000032905', u'ENSMUSG00000038517', u'ENSMUSG00000023341', u'ENSMUSG00000000127', u'ENSMUSG00000023224', u'ENSMUSG00000015947', u'ENSMUSG00000027514', u'ENSMUSG00000002983', u'ENSMUSG00000039005', u'ENSMUSG00000041827', u'ENSMUSG00000028059', u'ENSMUSG00000054717', u'ENSMUSG00000018899', u'ENSMUSG00000021277', u'ENSMUSG00000024789', u'ENSMUSG00000033538', u'ENSMUSG00000028291', u'ENSMUSG00000029217', u'ENSMUSG00000022575', u'ENSMUSG00000066839', u'ENSMUSG00000029561', u'ENSMUSG00000029915', u'ENSMUSG00000056612', u'ENSMUSG00000044827', u'ENSMUSG00000028163', u'ENSMUSG00000043279', u'ENSMUSG00000026365', u'ENSMUSG00000032322', u'ENSMUSG00000034459', u'ENSMUSG00000039936', u'ENSMUSG00000021423', u'ENSMUSG00000038147', u'ENSMUSG00000050132', u'ENSMUSG00000032041', u'ENSMUSG00000046034']), pop_n=13836, p_sm_bonferroni=0.0007246874259198774, is_obsolete=False, GO='GO:0045087', name='innate immune response', pop_count=206, alt_ids=['GO:0002226'], level=3, depth=4, enrichment='e', Cluster='Transient Increase', geneid_set=set([u'ENSMUSG00000032344', u'ENSMUSG00000032661', u'ENSMUSG00000039236', u'ENSMUSG00000070034', u'ENSMUSG00000018899', u'ENSMUSG00000027514', u'ENSMUSG00000024079', u'ENSMUSG00000046718', u'ENSMUSG00000074151', u'ENSMUSG00000036986', u'ENSMUSG00000029561', u'ENSMUSG00000017830', u'ENSMUSG00000074896', u'ENSMUSG00000054717', u'ENSMUSG00000029605', u'ENSMUSG00000026896', u'ENSMUSG00000041827', u'ENSMUSG00000032508', u'ENSMUSG00000034459', u'ENSMUSG00000046879', u'ENSMUSG00000023341', u'ENSMUSG00000040296', u'ENSMUSG00000025498', u'ENSMUSG00000020641', u'ENSMUSG00000054072', u'ENSMUSG00000045932', u'ENSMUSG00000005566', u'ENSMUSG00000000386', u'ENSMUSG00000021624']), symbols=u'Bst2 Cd180 Ddx58 Dhx58 Eif2ak2 Hmgb2 Ifih1 Ifit1 Ifit2 Ifit3 Iigp1 Irf1 Irf7 Irgm1 Isg20 Mb21d1 Mx1 Mx2 Myd88 Nlrc5 Oas1b Oas3 Oasl1 Oasl2 Pml Rsad2 Sp110 Trim28 Zbp1', symbol_set=set(['Mb21d1', u'Sp110', u'Mx1', u'Iigp1', u'Irf1', u'Irf7', u'Zbp1', u'Eif2ak2', u'Oas3', u'Isg20', u'Nlrc5', u'Cd180', u'Oasl2', u'Ifih1', u'Oasl1', u'Irgm1', u'Ddx58', u'Oas1b', u'Trim28', u'Dhx58', u'Hmgb2', u'Mx2', u'Ifit2', u'Bst2', u'Pml', u'Myd88', u'Ifit3', u'Rsad2', u'Ifit1']), geneids='ENSMUSG00000032661 ENSMUSG00000023341 ENSMUSG00000070034 ENSMUSG00000024079 ENSMUSG00000074151 ENSMUSG00000036986 ENSMUSG00000074896 ENSMUSG00000041827 ENSMUSG00000032508 ENSMUSG00000017830 ENSMUSG00000054072 ENSMUSG00000021624 ENSMUSG00000039236 ENSMUSG00000054717 ENSMUSG00000018899 ENSMUSG00000027514 ENSMUSG00000046718 ENSMUSG00000046879 ENSMUSG00000029561 ENSMUSG00000005566 ENSMUSG00000029605 ENSMUSG00000026896 ENSMUSG00000034459 ENSMUSG00000032344 ENSMUSG00000040296 ENSMUSG00000025498 ENSMUSG00000020641 ENSMUSG00000045932 ENSMUSG00000000386', format_txt=1, hdr_idx=1, is_hdrgo=True, is_usrgo=True, hdr1usr01='**', dcnt=26, D1='FL', GO_name='innate immune response'),
    Nt(p_uncorrected='', study_count='', study_n='', namespace='', p_fdr_bh='', study_items='', NS='BP', pop_items='', pop_n='', p_sm_bonferroni='', is_obsolete='', GO='GO:0006461', name='', pop_count='', alt_ids='', level=5, depth=5, enrichment='', Cluster='', geneid_set='', symbols='', symbol_set='', geneids='', format_txt=1, hdr_idx=1, is_hdrgo=True, is_usrgo=False, hdr1usr01='*', dcnt=170, D1='BH', GO_name='protein complex assembly'),
    Nt(p_uncorrected=0.00012860653072037162, study_count=4, study_n=624, namespace='biological_process', p_fdr_bh=0.010589769276871469, study_items=set([u'ENSMUSG00000027469', u'ENSMUSG00000022070', u'ENSMUSG00000068744', u'ENSMUSG00000037313']), NS='BP', pop_items=set([u'ENSMUSG00000027469', u'ENSMUSG00000022070', u'ENSMUSG00000032855', u'ENSMUSG00000037313', u'ENSMUSG00000023249', u'ENSMUSG00000047126', u'ENSMUSG00000068744']), pop_n=13836, p_sm_bonferroni=1.0, is_obsolete=False, GO='GO:0060236', name='regulation of mitotic spindle organization', pop_count=7, alt_ids=[], level=7, depth=9, enrichment='e', Cluster='Transient Increase', geneid_set=set([u'ENSMUSG00000027469', u'ENSMUSG00000022070', u'ENSMUSG00000068744', u'ENSMUSG00000037313']), symbols=u'Bora Psrc1 Tacc3 Tpx2', symbol_set=set([u'Tpx2', u'Tacc3', u'Psrc1', 'Bora']), geneids='ENSMUSG00000027469 ENSMUSG00000022070 ENSMUSG00000068744 ENSMUSG00000037313', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=6, D1='A', GO_name='regulation of mitotic spindle organization'),
    Nt(p_uncorrected=4.79364473285348e-07, study_count=8, study_n=624, namespace='biological_process', p_fdr_bh=8.348104752581963e-05, study_items=set([u'ENSMUSG00000040084', u'ENSMUSG00000038379', u'ENSMUSG00000045328', u'ENSMUSG00000029910', u'ENSMUSG00000024542', u'ENSMUSG00000030867', u'ENSMUSG00000027379', u'ENSMUSG00000034218']), NS='BP', pop_items=set([u'ENSMUSG00000040084', u'ENSMUSG00000024537', u'ENSMUSG00000022750', u'ENSMUSG00000038379', u'ENSMUSG00000029910', u'ENSMUSG00000029554', u'ENSMUSG00000066979', u'ENSMUSG00000045328', u'ENSMUSG00000006005', u'ENSMUSG00000005871', u'ENSMUSG00000030867', u'ENSMUSG00000034509', u'ENSMUSG00000032264', u'ENSMUSG00000017421', u'ENSMUSG00000027379', u'ENSMUSG00000034218', u'ENSMUSG00000025925', u'ENSMUSG00000024542']), pop_n=13836, p_sm_bonferroni=0.007262851134746308, is_obsolete=False, GO='GO:0007094', name='mitotic spindle assembly checkpoint', pop_count=18, alt_ids=[], level=5, depth=13, enrichment='e', Cluster='Transient Increase', geneid_set=set([u'ENSMUSG00000040084', u'ENSMUSG00000038379', u'ENSMUSG00000045328', u'ENSMUSG00000029910', u'ENSMUSG00000024542', u'ENSMUSG00000030867', u'ENSMUSG00000027379', u'ENSMUSG00000034218']), symbols=u'Atm Bub1 Bub1b Cenpe Cep192 Mad2l1 Plk1 Ttk', symbol_set=set([u'Mad2l1', u'Bub1', u'Bub1b', u'Plk1', u'Cenpe', u'Atm', u'Cep192', u'Ttk']), geneids='ENSMUSG00000040084 ENSMUSG00000038379 ENSMUSG00000045328 ENSMUSG00000029910 ENSMUSG00000024542 ENSMUSG00000030867 ENSMUSG00000027379 ENSMUSG00000034218', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=0, D1='AB', GO_name='mitotic spindle assembly checkpoint'),
    Nt(p_uncorrected=9.573736428560848e-05, study_count=6, study_n=624, namespace='biological_process', p_fdr_bh=0.008384490209776035, study_items=set([u'ENSMUSG00000002083', u'ENSMUSG00000028702', u'ENSMUSG00000059552', u'ENSMUSG00000005370', u'ENSMUSG00000034218', u'ENSMUSG00000078773']), NS='BP', pop_items=set([u'ENSMUSG00000029104', u'ENSMUSG00000021268', u'ENSMUSG00000036273', u'ENSMUSG00000026288', u'ENSMUSG00000002083', u'ENSMUSG00000004263', u'ENSMUSG00000056999', u'ENSMUSG00000028702', u'ENSMUSG00000039428', u'ENSMUSG00000005370', u'ENSMUSG00000026048', u'ENSMUSG00000057637', u'ENSMUSG00000059552', u'ENSMUSG00000026380', u'ENSMUSG00000024151', u'ENSMUSG00000078773', u'ENSMUSG00000034218', u'ENSMUSG00000030652']), pop_n=13836, p_sm_bonferroni=1.0, is_obsolete=False, GO='GO:0008340', name='determination of adult lifespan', pop_count=18, alt_ids=[], level=3, depth=3, enrichment='e', Cluster='Transient Increase', geneid_set=set([u'ENSMUSG00000034218', u'ENSMUSG00000005370', u'ENSMUSG00000002083', u'ENSMUSG00000059552', u'ENSMUSG00000078773', u'ENSMUSG00000028702']), symbols=u'Atm Bbc3 Msh6 Rad54b Rad54l Trp53', symbol_set=set([u'Rad54b', u'Trp53', u'Rad54l', u'Atm', u'Msh6', u'Bbc3']), geneids='ENSMUSG00000002083 ENSMUSG00000028702 ENSMUSG00000059552 ENSMUSG00000005370 ENSMUSG00000034218 ENSMUSG00000078773', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=0, D1='CJ', GO_name='determination of adult lifespan'),
    Nt(p_uncorrected=0.00017467511089396258, study_count=5, study_n=624, namespace='biological_process', p_fdr_bh=0.013790477588226161, study_items=set([u'ENSMUSG00000027715', u'ENSMUSG00000026605', u'ENSMUSG00000041498', u'ENSMUSG00000025358', u'ENSMUSG00000020898']), NS='BP', pop_items=set([u'ENSMUSG00000040274', u'ENSMUSG00000034402', u'ENSMUSG00000027499', u'ENSMUSG00000027715', u'ENSMUSG00000053819', u'ENSMUSG00000025358', u'ENSMUSG00000041498', u'ENSMUSG00000063275', u'ENSMUSG00000026778', u'ENSMUSG00000006728', u'ENSMUSG00000020898', u'ENSMUSG00000026605', u'ENSMUSG00000021932']), pop_n=13836, p_sm_bonferroni=1.0, is_obsolete=False, GO='GO:0010389', name='regulation of G2/M transition of mitotic cell cycle', pop_count=13, alt_ids=[], level=7, depth=8, enrichment='e', Cluster='Transient Increase', geneid_set=set([u'ENSMUSG00000027715', u'ENSMUSG00000026605', u'ENSMUSG00000041498', u'ENSMUSG00000025358', u'ENSMUSG00000020898']), symbols=u'Ccna2 Cdk2 Cenpf Ctc1 Kif14', symbol_set=set([u'Kif14', u'Cenpf', u'Cdk2', u'Ccna2', 'Ctc1']), geneids='ENSMUSG00000027715 ENSMUSG00000026605 ENSMUSG00000041498 ENSMUSG00000025358 ENSMUSG00000020898', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=14, D1='A', GO_name='regulation of G2/M transition of mitotic cell cycle'),
    Nt(p_uncorrected=0.0006920361223044611, study_count=4, study_n=624, namespace='biological_process', p_fdr_bh=0.0468082111117629, study_items=set([u'ENSMUSG00000004446', u'ENSMUSG00000028224', u'ENSMUSG00000041133', u'ENSMUSG00000029521']), NS='BP', pop_items=set([u'ENSMUSG00000028224', u'ENSMUSG00000059923', u'ENSMUSG00000036390', u'ENSMUSG00000029521', u'ENSMUSG00000028914', u'ENSMUSG00000030990', u'ENSMUSG00000026842', u'ENSMUSG00000053436', u'ENSMUSG00000004446', u'ENSMUSG00000041133']), pop_n=13836, p_sm_bonferroni=1.0, is_obsolete=False, GO='GO:0042770', name='signal transduction in response to DNA damage', pop_count=10, alt_ids=[], level=4, depth=6, enrichment='e', Cluster='Transient Increase', geneid_set=set([u'ENSMUSG00000004446', u'ENSMUSG00000028224', u'ENSMUSG00000041133', u'ENSMUSG00000029521']), symbols=u'Bid Chek2 Nbn Smc1a', symbol_set=set([u'Smc1a', u'Bid', u'Chek2', u'Nbn']), geneids='ENSMUSG00000004446 ENSMUSG00000028224 ENSMUSG00000041133 ENSMUSG00000029521', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=11, D1='ABF', GO_name='signal transduction in response to DNA damage'),
    Nt(p_uncorrected=2.6139984942594557e-09, study_count=12, study_n=624, namespace='biological_process', p_fdr_bh=9.088283859667372e-07, study_items=set([u'ENSMUSG00000029521', u'ENSMUSG00000025647', u'ENSMUSG00000002083', u'ENSMUSG00000024521', u'ENSMUSG00000023067', u'ENSMUSG00000030609', u'ENSMUSG00000036986', u'ENSMUSG00000059552', u'ENSMUSG00000020108', u'ENSMUSG00000041147', u'ENSMUSG00000041801', u'ENSMUSG00000036822']), NS='BP', pop_items=set([u'ENSMUSG00000061436', u'ENSMUSG00000024392', u'ENSMUSG00000030793', u'ENSMUSG00000036986', u'ENSMUSG00000059552', u'ENSMUSG00000029026', u'ENSMUSG00000030609', u'ENSMUSG00000030990', u'ENSMUSG00000028630', u'ENSMUSG00000032267', u'ENSMUSG00000034659', u'ENSMUSG00000004071', u'ENSMUSG00000020063', u'ENSMUSG00000024151', u'ENSMUSG00000036822', u'ENSMUSG00000029521', u'ENSMUSG00000073489', u'ENSMUSG00000041147', u'ENSMUSG00000055024', u'ENSMUSG00000036781', u'ENSMUSG00000041801', u'ENSMUSG00000008730', u'ENSMUSG00000030717', u'ENSMUSG00000025647', u'ENSMUSG00000002083', u'ENSMUSG00000024521', u'ENSMUSG00000053175', u'ENSMUSG00000023067', u'ENSMUSG00000021039', u'ENSMUSG00000020108']), pop_n=13836, p_sm_bonferroni=3.9604691186525016e-05, is_obsolete=False, GO='GO:0042771', name='intrinsic apoptotic signaling pathway in response to DNA damage by p53 class mediator', pop_count=30, alt_ids=[], level=6, depth=8, enrichment='e', Cluster='Transient Increase', geneid_set=set([u'ENSMUSG00000029521', u'ENSMUSG00000025647', u'ENSMUSG00000002083', u'ENSMUSG00000024521', u'ENSMUSG00000023067', u'ENSMUSG00000030609', u'ENSMUSG00000036986', u'ENSMUSG00000059552', u'ENSMUSG00000020108', u'ENSMUSG00000041147', u'ENSMUSG00000041801', u'ENSMUSG00000036822']), symbols=u'Aen Bbc3 Brca2 Cdkn1a Chek2 Ddit4 Phlda3 Pmaip1 Pml Shisa5 Topors Trp53', symbol_set=set([u'Brca2', u'Pmaip1', u'Trp53', u'Cdkn1a', u'Shisa5', u'Pml', u'Ddit4', u'Bbc3', u'Topors', u'Chek2', u'Phlda3', u'Aen']), geneids='ENSMUSG00000029521 ENSMUSG00000025647 ENSMUSG00000002083 ENSMUSG00000024521 ENSMUSG00000023067 ENSMUSG00000030609 ENSMUSG00000036986 ENSMUSG00000059552 ENSMUSG00000020108 ENSMUSG00000041147 ENSMUSG00000041801 ENSMUSG00000036822', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=0, D1='ABF', GO_name='intrinsic apoptotic signaling pathway in response to DNA damage by p53 class mediator'),
    Nt(p_uncorrected=1.5039379199994453e-10, study_count=19, study_n=624, namespace='biological_process', p_fdr_bh=7.350375298681159e-08, study_items=set([u'ENSMUSG00000031311', u'ENSMUSG00000039748', u'ENSMUSG00000020380', u'ENSMUSG00000054717', u'ENSMUSG00000030346', u'ENSMUSG00000027433', u'ENSMUSG00000033762', u'ENSMUSG00000056394', u'ENSMUSG00000002221', u'ENSMUSG00000049932', u'ENSMUSG00000017146', u'ENSMUSG00000020608', u'ENSMUSG00000041147', u'ENSMUSG00000028884', u'ENSMUSG00000038685', u'ENSMUSG00000027323', u'ENSMUSG00000019303', u'ENSMUSG00000030528', u'ENSMUSG00000044702']), NS='BP', pop_items=set([u'ENSMUSG00000059772', u'ENSMUSG00000024906', u'ENSMUSG00000018841', u'ENSMUSG00000033762', u'ENSMUSG00000039738', u'ENSMUSG00000020474', u'ENSMUSG00000018449', u'ENSMUSG00000047989', u'ENSMUSG00000031583', u'ENSMUSG00000012483', u'ENSMUSG00000021264', u'ENSMUSG00000030034', u'ENSMUSG00000030750', u'ENSMUSG00000030528', u'ENSMUSG00000049932', u'ENSMUSG00000038685', u'ENSMUSG00000073436', u'ENSMUSG00000003549', u'ENSMUSG00000028884', u'ENSMUSG00000022471', u'ENSMUSG00000028933', u'ENSMUSG00000019303', u'ENSMUSG00000020380', u'ENSMUSG00000025612', u'ENSMUSG00000070520', u'ENSMUSG00000056394', u'ENSMUSG00000041974', u'ENSMUSG00000017146', u'ENSMUSG00000020752', u'ENSMUSG00000062270', u'ENSMUSG00000021287', u'ENSMUSG00000044702', u'ENSMUSG00000026648', u'ENSMUSG00000039748', u'ENSMUSG00000018189', u'ENSMUSG00000054717', u'ENSMUSG00000025269', u'ENSMUSG00000030346', u'ENSMUSG00000020608', u'ENSMUSG00000014243', u'ENSMUSG00000027433', u'ENSMUSG00000003868', u'ENSMUSG00000041147', u'ENSMUSG00000024943', u'ENSMUSG00000027671', u'ENSMUSG00000030243', u'ENSMUSG00000015971', u'ENSMUSG00000040865', u'ENSMUSG00000031311', u'ENSMUSG00000026187', u'ENSMUSG00000043535', u'ENSMUSG00000035960', u'ENSMUSG00000030079', u'ENSMUSG00000037262', u'ENSMUSG00000000751', u'ENSMUSG00000037570', u'ENSMUSG00000049717', u'ENSMUSG00000037761', u'ENSMUSG00000059586', u'ENSMUSG00000020697', u'ENSMUSG00000034154', u'ENSMUSG00000027323', u'ENSMUSG00000020079', u'ENSMUSG00000002221', u'ENSMUSG00000051238', u'ENSMUSG00000007646', u'ENSMUSG00000030166', u'ENSMUSG00000021615', u'ENSMUSG00000042185', u'ENSMUSG00000006335']), pop_n=13836, p_sm_bonferroni=2.2786163425911594e-06, is_obsolete=False, GO='GO:0006310', name='DNA recombination', pop_count=70, alt_ids=[], level=5, depth=7, enrichment='e', Cluster='Transient Increase', geneid_set=set([u'ENSMUSG00000039748', u'ENSMUSG00000054717', u'ENSMUSG00000030346', u'ENSMUSG00000030528', u'ENSMUSG00000027433', u'ENSMUSG00000033762', u'ENSMUSG00000038685', u'ENSMUSG00000031311', u'ENSMUSG00000019303', u'ENSMUSG00000056394', u'ENSMUSG00000044702', u'ENSMUSG00000049932', u'ENSMUSG00000028884', u'ENSMUSG00000020380', u'ENSMUSG00000027323', u'ENSMUSG00000002221', u'ENSMUSG00000017146', u'ENSMUSG00000020608', u'ENSMUSG00000041147']), symbols=u'Blm Brca1 Brca2 Exo1 H2afx Hmgb2 Lig1 Nono Palb2 Paxip1 Psmc3ip Rad50 Rad51 Rad51ap1 Recql4 Rpa2 Rtel1 Smc6 Xrn2', symbol_set=set([u'Brca1', u'Recql4', u'Smc6', u'Rad51', u'Nono', u'Hmgb2', u'Palb2', u'Exo1', u'H2afx', u'Psmc3ip', u'Rpa2', u'Blm', u'Rad51ap1', u'Brca2', u'Lig1', u'Xrn2', u'Rad50', u'Paxip1', u'Rtel1']), geneids='ENSMUSG00000039748 ENSMUSG00000027433 ENSMUSG00000028884 ENSMUSG00000056394 ENSMUSG00000030346 ENSMUSG00000020380 ENSMUSG00000027323 ENSMUSG00000033762 ENSMUSG00000002221 ENSMUSG00000049932 ENSMUSG00000017146 ENSMUSG00000020608 ENSMUSG00000041147 ENSMUSG00000054717 ENSMUSG00000030528 ENSMUSG00000031311 ENSMUSG00000019303 ENSMUSG00000038685 ENSMUSG00000044702', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=52, D1='BD', GO_name='DNA recombination'),
    Nt(p_uncorrected=5.467793990178798e-11, study_count=14, study_n=624, namespace='biological_process', p_fdr_bh=3.774646010782965e-08, study_items=set([u'ENSMUSG00000062510', u'ENSMUSG00000029177', u'ENSMUSG00000024056', u'ENSMUSG00000028873', u'ENSMUSG00000027635', u'ENSMUSG00000027306', u'ENSMUSG00000029910', u'ENSMUSG00000058290', u'ENSMUSG00000040599', u'ENSMUSG00000030867', u'ENSMUSG00000027331', u'ENSMUSG00000051378', u'ENSMUSG00000026622', u'ENSMUSG00000002055']), NS='BP', pop_items=set([u'ENSMUSG00000029516', u'ENSMUSG00000024056', u'ENSMUSG00000002055', u'ENSMUSG00000031922', u'ENSMUSG00000030867', u'ENSMUSG00000027331', u'ENSMUSG00000032264', u'ENSMUSG00000022750', u'ENSMUSG00000019923', u'ENSMUSG00000062510', u'ENSMUSG00000034154', u'ENSMUSG00000066979', u'ENSMUSG00000058290', u'ENSMUSG00000017421', u'ENSMUSG00000051378', u'ENSMUSG00000040599', u'ENSMUSG00000029177', u'ENSMUSG00000028873', u'ENSMUSG00000027635', u'ENSMUSG00000027306', u'ENSMUSG00000029910', u'ENSMUSG00000019813', u'ENSMUSG00000026622']), pop_n=13836, p_sm_bonferroni=8.284254674519896e-07, is_obsolete=False, GO='GO:0000070', name='mitotic sister chromatid segregation', pop_count=23, alt_ids=['GO:0016359'], level=4, depth=6, enrichment='e', Cluster='Transient Increase', geneid_set=set([u'ENSMUSG00000062510', u'ENSMUSG00000029177', u'ENSMUSG00000024056', u'ENSMUSG00000028873', u'ENSMUSG00000027635', u'ENSMUSG00000027306', u'ENSMUSG00000029910', u'ENSMUSG00000058290', u'ENSMUSG00000030867', u'ENSMUSG00000027331', u'ENSMUSG00000051378', u'ENSMUSG00000026622', u'ENSMUSG00000002055', u'ENSMUSG00000040599']), symbols=u'Cdca8 Cenpa Dsn1 Espl1 Kif18b Knstrn Mad2l1 Mis12 Ndc80 Nek2 Nsl1 Nusap1 Plk1 Spag5', symbol_set=set([u'Nsl1', 'Knstrn', u'Mad2l1', u'Nusap1', u'Plk1', u'Spag5', u'Dsn1', u'Cenpa', u'Kif18b', u'Espl1', u'Mis12', u'Nek2', u'Cdca8', u'Ndc80']), geneids='ENSMUSG00000062510 ENSMUSG00000029177 ENSMUSG00000024056 ENSMUSG00000002055 ENSMUSG00000027635 ENSMUSG00000027306 ENSMUSG00000029910 ENSMUSG00000058290 ENSMUSG00000040599 ENSMUSG00000030867 ENSMUSG00000027331 ENSMUSG00000051378 ENSMUSG00000026622 ENSMUSG00000028873', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=0, D1='BCH', GO_name='mitotic sister chromatid segregation'),
    Nt(p_uncorrected=8.945577520622059e-06, study_count=8, study_n=624, namespace='biological_process', p_fdr_bh=0.001075670198531308, study_items=set([u'ENSMUSG00000032397', u'ENSMUSG00000028224', u'ENSMUSG00000029521', u'ENSMUSG00000032113', u'ENSMUSG00000027490', u'ENSMUSG00000042489', u'ENSMUSG00000034218', u'ENSMUSG00000032409']), NS='BP', pop_items=set([u'ENSMUSG00000028224', u'ENSMUSG00000020413', u'ENSMUSG00000004085', u'ENSMUSG00000038569', u'ENSMUSG00000032119', u'ENSMUSG00000029238', u'ENSMUSG00000032113', u'ENSMUSG00000037461', u'ENSMUSG00000032267', u'ENSMUSG00000022248', u'ENSMUSG00000032409', u'ENSMUSG00000053436', u'ENSMUSG00000032397', u'ENSMUSG00000029521', u'ENSMUSG00000024824', u'ENSMUSG00000040843', u'ENSMUSG00000043733', u'ENSMUSG00000013698', u'ENSMUSG00000061589', u'ENSMUSG00000027490', u'ENSMUSG00000021635', u'ENSMUSG00000042489', u'ENSMUSG00000043909', u'ENSMUSG00000034218', u'ENSMUSG00000048668']), pop_n=13836, p_sm_bonferroni=0.1355344450149448, is_obsolete=False, GO='GO:0000077', name='DNA damage checkpoint', pop_count=25, alt_ids=[], level=4, depth=8, enrichment='e', Cluster='Transient Increase', geneid_set=set([u'ENSMUSG00000032397', u'ENSMUSG00000028224', u'ENSMUSG00000029521', u'ENSMUSG00000032113', u'ENSMUSG00000027490', u'ENSMUSG00000042489', u'ENSMUSG00000034218', u'ENSMUSG00000032409']), symbols=u'Atm Atr Chek1 Chek2 Clspn E2f1 Nbn Tipin', symbol_set=set([u'Atm', u'E2f1', u'Clspn', u'Tipin', u'Atr', u'Nbn', u'Chek2', u'Chek1']), geneids='ENSMUSG00000028224 ENSMUSG00000032397 ENSMUSG00000029521 ENSMUSG00000032113 ENSMUSG00000027490 ENSMUSG00000042489 ENSMUSG00000034218 ENSMUSG00000032409', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=6, D1='ABF', GO_name='DNA damage checkpoint'),
    Nt(p_uncorrected=5.716066791862708e-05, study_count=4, study_n=624, namespace='biological_process', p_fdr_bh=0.005735372712815357, study_items=set([u'ENSMUSG00000032397', u'ENSMUSG00000006585', u'ENSMUSG00000042489', u'ENSMUSG00000036875']), NS='BP', pop_items=set([u'ENSMUSG00000032397', u'ENSMUSG00000042489', u'ENSMUSG00000024824', u'ENSMUSG00000036875', u'ENSMUSG00000006585', u'ENSMUSG00000038569']), pop_n=13836, p_sm_bonferroni=0.8660412796351189, is_obsolete=False, GO='GO:0000076', name='DNA replication checkpoint', pop_count=6, alt_ids=[], level=4, depth=8, enrichment='e', Cluster='Transient Increase', geneid_set=set([u'ENSMUSG00000032397', u'ENSMUSG00000006585', u'ENSMUSG00000042489', u'ENSMUSG00000036875']), symbols=u'Cdt1 Clspn Dna2 Tipin', symbol_set=set([u'Clspn', u'Cdt1', u'Dna2', u'Tipin']), geneids='ENSMUSG00000006585 ENSMUSG00000032397 ENSMUSG00000042489 ENSMUSG00000036875', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=2, D1='AB', GO_name='DNA replication checkpoint'),
    Nt(p_uncorrected=1.5588440593918757e-09, study_count=21, study_n=624, namespace='biological_process', p_fdr_bh=5.904511585961577e-07, study_items=set([u'ENSMUSG00000052684', u'ENSMUSG00000028212', u'ENSMUSG00000003873', u'ENSMUSG00000059552', u'ENSMUSG00000018983', u'ENSMUSG00000027641', u'ENSMUSG00000037313', u'ENSMUSG00000054115', u'ENSMUSG00000072082', u'ENSMUSG00000002068', u'ENSMUSG00000035455', u'ENSMUSG00000023067', u'ENSMUSG00000001855', u'ENSMUSG00000026779', u'ENSMUSG00000027490', u'ENSMUSG00000037474', u'ENSMUSG00000040204', u'ENSMUSG00000020326', u'ENSMUSG00000057789', u'ENSMUSG00000034218', u'ENSMUSG00000020493']), NS='BP', pop_items=set([u'ENSMUSG00000003873', u'ENSMUSG00000020262', u'ENSMUSG00000023572', u'ENSMUSG00000059552', u'ENSMUSG00000048661', u'ENSMUSG00000018841', u'ENSMUSG00000052837', u'ENSMUSG00000025616', u'ENSMUSG00000070348', u'ENSMUSG00000028580', u'ENSMUSG00000028820', u'ENSMUSG00000025917', u'ENSMUSG00000026395', u'ENSMUSG00000026812', u'ENSMUSG00000020372', u'ENSMUSG00000027552', u'ENSMUSG00000002068', u'ENSMUSG00000037313', u'ENSMUSG00000002496', u'ENSMUSG00000001855', u'ENSMUSG00000057367', u'ENSMUSG00000023067', u'ENSMUSG00000072082', u'ENSMUSG00000027490', u'ENSMUSG00000033949', u'ENSMUSG00000015656', u'ENSMUSG00000039474', u'ENSMUSG00000036390', u'ENSMUSG00000071076', u'ENSMUSG00000018983', u'ENSMUSG00000025217', u'ENSMUSG00000055116', u'ENSMUSG00000040957', u'ENSMUSG00000052684', u'ENSMUSG00000014859', u'ENSMUSG00000022557', u'ENSMUSG00000027641', u'ENSMUSG00000027646', u'ENSMUSG00000015149', u'ENSMUSG00000057789', u'ENSMUSG00000022018', u'ENSMUSG00000051177', u'ENSMUSG00000038344', u'ENSMUSG00000009681', u'ENSMUSG00000032968', u'ENSMUSG00000037373', u'ENSMUSG00000037474', u'ENSMUSG00000035455', u'ENSMUSG00000034218', u'ENSMUSG00000034165', u'ENSMUSG00000020349', u'ENSMUSG00000021453', u'ENSMUSG00000026842', u'ENSMUSG00000013663', u'ENSMUSG00000024537', u'ENSMUSG00000054115', u'ENSMUSG00000030061', u'ENSMUSG00000034201', u'ENSMUSG00000020430', u'ENSMUSG00000020493', u'ENSMUSG00000066043', u'ENSMUSG00000021514', u'ENSMUSG00000015312', u'ENSMUSG00000020950', u'ENSMUSG00000057113', u'ENSMUSG00000025809', u'ENSMUSG00000021901', u'ENSMUSG00000046707', u'ENSMUSG00000040204', u'ENSMUSG00000040687', u'ENSMUSG00000007872', u'ENSMUSG00000057329', u'ENSMUSG00000022961', u'ENSMUSG00000006728', u'ENSMUSG00000029385', u'ENSMUSG00000038990', u'ENSMUSG00000027684', u'ENSMUSG00000033862', u'ENSMUSG00000000282', u'ENSMUSG00000041459', u'ENSMUSG00000085795', u'ENSMUSG00000026779', u'ENSMUSG00000063015', u'ENSMUSG00000056917', u'ENSMUSG00000003228', u'ENSMUSG00000020326', u'ENSMUSG00000055866', u'ENSMUSG00000028212', u'ENSMUSG00000056596', u'ENSMUSG00000005871', u'ENSMUSG00000031666', u'ENSMUSG00000000184', u'ENSMUSG00000027852', u'ENSMUSG00000004040', u'ENSMUSG00000041415', u'ENSMUSG00000019970', u'ENSMUSG00000022105']), pop_n=13836, p_sm_bonferroni=2.361804634384631e-05, is_obsolete=False, GO='GO:0051726', name='regulation of cell cycle', pop_count=97, alt_ids=['GO:0000074'], level=4, depth=4, enrichment='e', Cluster='Transient Increase', geneid_set=set([u'ENSMUSG00000028212', u'ENSMUSG00000003873', u'ENSMUSG00000018983', u'ENSMUSG00000002068', u'ENSMUSG00000034218', u'ENSMUSG00000037313', u'ENSMUSG00000059552', u'ENSMUSG00000052684', u'ENSMUSG00000020493', u'ENSMUSG00000001855', u'ENSMUSG00000037474', u'ENSMUSG00000027641', u'ENSMUSG00000054115', u'ENSMUSG00000072082', u'ENSMUSG00000027490', u'ENSMUSG00000035455', u'ENSMUSG00000023067', u'ENSMUSG00000026779', u'ENSMUSG00000040204', u'ENSMUSG00000057789', u'ENSMUSG00000020326']), symbols=u'Atm Bak1 Bax Ccne1 Ccne2 Ccnf Ccng1 Cdkn1a Dtl E2f1 E2f2 Fignl1 Jun Mastl Nup214 Pclaf Prr11 Rbl1 Skp2 Tacc3 Trp53', symbol_set=set([u'Dtl', u'Ccne1', u'Skp2', u'E2f2', u'E2f1', u'Trp53', u'Ccne2', u'Mastl', u'Cdkn1a', u'Tacc3', u'Jun', u'Bax', u'Fignl1', u'Ccng1', u'Ccnf', u'Prr11', u'Nup214', 'Pclaf', u'Atm', u'Bak1', u'Rbl1']), geneids='ENSMUSG00000040204 ENSMUSG00000001855 ENSMUSG00000003873 ENSMUSG00000059552 ENSMUSG00000054115 ENSMUSG00000018983 ENSMUSG00000027641 ENSMUSG00000037474 ENSMUSG00000023067 ENSMUSG00000027490 ENSMUSG00000002068 ENSMUSG00000072082 ENSMUSG00000035455 ENSMUSG00000034218 ENSMUSG00000028212 ENSMUSG00000026779 ENSMUSG00000037313 ENSMUSG00000020493 ENSMUSG00000052684 ENSMUSG00000057789 ENSMUSG00000020326', format_txt=1, hdr_idx=1, is_hdrgo=True, is_usrgo=True, hdr1usr01='**', dcnt=412, D1='A', GO_name='regulation of cell cycle'),
    Nt(p_uncorrected='', study_count='', study_n='', namespace='', p_fdr_bh='', study_items='', NS='BP', pop_items='', pop_n='', p_sm_bonferroni='', is_obsolete='', GO='GO:0032204', name='', pop_count='', alt_ids='', level=4, depth=7, enrichment='', Cluster='', geneid_set='', symbols='', symbol_set='', geneids='', format_txt=1, hdr_idx=1, is_hdrgo=True, is_usrgo=False, hdr1usr01='*', dcnt=32, D1='A', GO_name='regulation of telomere maintenance'),
    Nt(p_uncorrected=4.099215555456427e-06, study_count=4, study_n=624, namespace='biological_process', p_fdr_bh=0.000521909368745549, study_items=set([u'ENSMUSG00000059552', u'ENSMUSG00000034218', u'ENSMUSG00000032409', u'ENSMUSG00000020898']), NS='BP', pop_items=set([u'ENSMUSG00000034218', u'ENSMUSG00000059552', u'ENSMUSG00000032409', u'ENSMUSG00000020898']), pop_n=13836, p_sm_bonferroni=0.06210721488072033, is_obsolete=False, GO='GO:0090399', name='replicative senescence', pop_count=4, alt_ids=[], level=5, depth=5, enrichment='e', Cluster='Transient Increase', geneid_set=set([u'ENSMUSG00000059552', u'ENSMUSG00000034218', u'ENSMUSG00000032409', u'ENSMUSG00000020898']), symbols=u'Atm Atr Ctc1 Trp53', symbol_set=set(['Ctc1', u'Atm', u'Atr', u'Trp53']), geneids='ENSMUSG00000034218 ENSMUSG00000059552 ENSMUSG00000032409 ENSMUSG00000020898', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=0, D1='BCE', GO_name='replicative senescence'),
    Nt(p_uncorrected=6.761987816954612e-05, study_count=5, study_n=624, namespace='biological_process', p_fdr_bh=0.006525533593291677, study_items=set([u'ENSMUSG00000036986', u'ENSMUSG00000028224', u'ENSMUSG00000038685', u'ENSMUSG00000020380', u'ENSMUSG00000007589']), NS='BP', pop_items=set([u'ENSMUSG00000028224', u'ENSMUSG00000031928', u'ENSMUSG00000020380', u'ENSMUSG00000042354', u'ENSMUSG00000031229', u'ENSMUSG00000031921', u'ENSMUSG00000007589', u'ENSMUSG00000036986', u'ENSMUSG00000038685', u'ENSMUSG00000034748', u'ENSMUSG00000027770']), pop_n=13836, p_sm_bonferroni=1.0, is_obsolete=False, GO='GO:0032206', name='positive regulation of telomere maintenance', pop_count=11, alt_ids=[], level=5, depth=8, enrichment='e', Cluster='Transient Increase', geneid_set=set([u'ENSMUSG00000036986', u'ENSMUSG00000028224', u'ENSMUSG00000038685', u'ENSMUSG00000020380', u'ENSMUSG00000007589']), symbols=u'Nbn Pml Rad50 Rtel1 Tinf2', symbol_set=set([u'Pml', u'Tinf2', u'Rtel1', u'Nbn', u'Rad50']), geneids='ENSMUSG00000028224 ENSMUSG00000020380 ENSMUSG00000036986 ENSMUSG00000007589 ENSMUSG00000038685', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=10, D1='A', GO_name='positive regulation of telomere maintenance'),
    Nt(p_uncorrected=1.2481129335863986e-07, study_count=14, study_n=624, namespace='biological_process', p_fdr_bh=2.5904327475024004e-05, study_items=set([u'ENSMUSG00000012443', u'ENSMUSG00000003779', u'ENSMUSG00000024301', u'ENSMUSG00000005237', u'ENSMUSG00000034311', u'ENSMUSG00000032254', u'ENSMUSG00000028678', u'ENSMUSG00000045328', u'ENSMUSG00000024795', u'ENSMUSG00000041498', u'ENSMUSG00000051378', u'ENSMUSG00000036768', u'ENSMUSG00000027115', u'ENSMUSG00000030677']), NS='BP', pop_items=set([u'ENSMUSG00000026494', u'ENSMUSG00000018707', u'ENSMUSG00000032489', u'ENSMUSG00000063077', u'ENSMUSG00000029757', u'ENSMUSG00000033705', u'ENSMUSG00000010021', u'ENSMUSG00000024795', u'ENSMUSG00000018395', u'ENSMUSG00000022629', u'ENSMUSG00000028438', u'ENSMUSG00000030677', u'ENSMUSG00000020821', u'ENSMUSG00000021843', u'ENSMUSG00000003779', u'ENSMUSG00000028678', u'ENSMUSG00000022262', u'ENSMUSG00000047459', u'ENSMUSG00000035770', u'ENSMUSG00000038844', u'ENSMUSG00000041498', u'ENSMUSG00000014602', u'ENSMUSG00000021288', u'ENSMUSG00000037933', u'ENSMUSG00000027115', u'ENSMUSG00000031788', u'ENSMUSG00000004187', u'ENSMUSG00000026764', u'ENSMUSG00000021693', u'ENSMUSG00000060176', u'ENSMUSG00000045328', u'ENSMUSG00000021375', u'ENSMUSG00000060012', u'ENSMUSG00000028758', u'ENSMUSG00000051378', u'ENSMUSG00000036768', u'ENSMUSG00000024862', u'ENSMUSG00000027012', u'ENSMUSG00000052273', u'ENSMUSG00000021879', u'ENSMUSG00000020668', u'ENSMUSG00000032254', u'ENSMUSG00000032435', u'ENSMUSG00000034311', u'ENSMUSG00000047193', u'ENSMUSG00000041642', u'ENSMUSG00000005237', u'ENSMUSG00000023999', u'ENSMUSG00000074657', u'ENSMUSG00000021076', u'ENSMUSG00000024301', u'ENSMUSG00000027475', u'ENSMUSG00000012443', u'ENSMUSG00000006740', u'ENSMUSG00000033826', u'ENSMUSG00000050382']), pop_n=13836, p_sm_bonferroni=0.0018910159056767526, is_obsolete=False, GO='GO:0007018', name='microtubule-based movement', pop_count=56, alt_ids=[], level=4, depth=4, enrichment='e', Cluster='Transient Increase', geneid_set=set([u'ENSMUSG00000030677', u'ENSMUSG00000003779', u'ENSMUSG00000051378', u'ENSMUSG00000024795', u'ENSMUSG00000045328', u'ENSMUSG00000032254', u'ENSMUSG00000028678', u'ENSMUSG00000034311', u'ENSMUSG00000027115', u'ENSMUSG00000005237', u'ENSMUSG00000041498', u'ENSMUSG00000024301', u'ENSMUSG00000012443', u'ENSMUSG00000036768']), symbols=u'Cenpe Dnah2 Kif11 Kif14 Kif15 Kif18a Kif18b Kif20a Kif20b Kif22 Kif23 Kif2c Kif4 Kifc5b', symbol_set=set(['Dnah2', u'Kif11', u'Cenpe', u'Kif18a', u'Kif23', u'Kif18b', u'Kif14', u'Kif15', u'Kifc5b', u'Kif22', u'Kif20b', u'Kif4', u'Kif2c', u'Kif20a']), geneids='ENSMUSG00000003779 ENSMUSG00000051378 ENSMUSG00000024795 ENSMUSG00000045328 ENSMUSG00000032254 ENSMUSG00000028678 ENSMUSG00000034311 ENSMUSG00000030677 ENSMUSG00000005237 ENSMUSG00000041498 ENSMUSG00000024301 ENSMUSG00000036768 ENSMUSG00000012443 ENSMUSG00000027115', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=78, D1='BC', GO_name='microtubule-based movement'),
    Nt(p_uncorrected=1.7006735838089953e-05, study_count=7, study_n=624, namespace='biological_process', p_fdr_bh=0.0019520382930522794, study_items=set([u'ENSMUSG00000003873', u'ENSMUSG00000002083', u'ENSMUSG00000024521', u'ENSMUSG00000004446', u'ENSMUSG00000059552', u'ENSMUSG00000057789', u'ENSMUSG00000052684']), NS='BP', pop_items=set([u'ENSMUSG00000026278', u'ENSMUSG00000004446', u'ENSMUSG00000020366', u'ENSMUSG00000003873', u'ENSMUSG00000002083', u'ENSMUSG00000029026', u'ENSMUSG00000024521', u'ENSMUSG00000003438', u'ENSMUSG00000006818', u'ENSMUSG00000002797', u'ENSMUSG00000022789', u'ENSMUSG00000019054', u'ENSMUSG00000032532', u'ENSMUSG00000007659', u'ENSMUSG00000059552', u'ENSMUSG00000024959', u'ENSMUSG00000057789', u'ENSMUSG00000057329', u'ENSMUSG00000033792', u'ENSMUSG00000052684']), pop_n=13836, p_sm_bonferroni=0.25766905468290086, is_obsolete=False, GO='GO:0001836', name='release of cytochrome c from mitochondria', pop_count=20, alt_ids=[], level=6, depth=6, enrichment='e', Cluster='Transient Increase', geneid_set=set([u'ENSMUSG00000059552', u'ENSMUSG00000003873', u'ENSMUSG00000002083', u'ENSMUSG00000004446', u'ENSMUSG00000024521', u'ENSMUSG00000057789', u'ENSMUSG00000052684']), symbols=u'Bak1 Bax Bbc3 Bid Jun Pmaip1 Trp53', symbol_set=set([u'Pmaip1', u'Trp53', u'Bid', u'Jun', u'Bax', u'Bak1', u'Bbc3']), geneids='ENSMUSG00000003873 ENSMUSG00000002083 ENSMUSG00000024521 ENSMUSG00000059552 ENSMUSG00000004446 ENSMUSG00000057789 ENSMUSG00000052684', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=0, D1='BH', GO_name='release of cytochrome c from mitochondria'),
    Nt(p_uncorrected=1.8083719736883525e-05, study_count=6, study_n=624, namespace='biological_process', p_fdr_bh=0.002044674908459122, study_items=set([u'ENSMUSG00000027959', u'ENSMUSG00000032782', u'ENSMUSG00000021572', u'ENSMUSG00000025358', u'ENSMUSG00000068394', u'ENSMUSG00000025758']), NS='BP', pop_items=set([u'ENSMUSG00000033904', u'ENSMUSG00000027959', u'ENSMUSG00000064128', u'ENSMUSG00000032782', u'ENSMUSG00000020807', u'ENSMUSG00000031347', u'ENSMUSG00000021572', u'ENSMUSG00000025358', u'ENSMUSG00000032534', u'ENSMUSG00000068394', u'ENSMUSG00000036403', u'ENSMUSG00000025758', u'ENSMUSG00000037020', u'ENSMUSG00000039298']), pop_n=13836, p_sm_bonferroni=0.27398643773352227, is_obsolete=False, GO='GO:0007099', name='centriole replication', pop_count=14, alt_ids=['GO:0032054'], level=3, depth=6, enrichment='e', Cluster='Transient Increase', geneid_set=set([u'ENSMUSG00000027959', u'ENSMUSG00000025358', u'ENSMUSG00000068394', u'ENSMUSG00000032782', u'ENSMUSG00000021572', u'ENSMUSG00000025758']), symbols=u'Cdk2 Cep152 Cep72 Cntrob Plk4 Sass6', symbol_set=set([u'Cep152', u'Plk4', u'Cntrob', u'Cdk2', u'Sass6', u'Cep72']), geneids='ENSMUSG00000027959 ENSMUSG00000032782 ENSMUSG00000021572 ENSMUSG00000025358 ENSMUSG00000068394 ENSMUSG00000025758', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=0, D1='BCH', GO_name='centriole replication'),
    Nt(p_uncorrected=0.0002616703282067204, study_count=5, study_n=624, namespace='biological_process', p_fdr_bh=0.01962657001316842, study_items=set([u'ENSMUSG00000035266', u'ENSMUSG00000039748', u'ENSMUSG00000025574', u'ENSMUSG00000020914', u'ENSMUSG00000027323']), NS='BP', pop_items=set([u'ENSMUSG00000035266', u'ENSMUSG00000039748', u'ENSMUSG00000022545', u'ENSMUSG00000026496', u'ENSMUSG00000020914', u'ENSMUSG00000017485', u'ENSMUSG00000025159', u'ENSMUSG00000055884', u'ENSMUSG00000025574', u'ENSMUSG00000031583', u'ENSMUSG00000039354', u'ENSMUSG00000024906', u'ENSMUSG00000003812', u'ENSMUSG00000027323']), pop_n=13836, p_sm_bonferroni=1.0, is_obsolete=False, GO='GO:0006259', name='DNA metabolic process', pop_count=14, alt_ids=['GO:0055132'], level=4, depth=6, enrichment='e', Cluster='Transient Increase', geneid_set=set([u'ENSMUSG00000035266', u'ENSMUSG00000039748', u'ENSMUSG00000027323', u'ENSMUSG00000020914', u'ENSMUSG00000025574']), symbols=u'Exo1 Helq Rad51 Tk1 Top2a', symbol_set=set([u'Exo1', u'Helq', u'Tk1', u'Rad51', u'Top2a']), geneids='ENSMUSG00000035266 ENSMUSG00000039748 ENSMUSG00000027323 ENSMUSG00000020914 ENSMUSG00000025574', format_txt=1, hdr_idx=1, is_hdrgo=True, is_usrgo=True, hdr1usr01='**', dcnt=302, D1='BD', GO_name='DNA metabolic process'),
    Nt(p_uncorrected=6.63436507852268e-05, study_count=6, study_n=624, namespace='biological_process', p_fdr_bh=0.0064434144426087905, study_items=set([u'ENSMUSG00000028224', u'ENSMUSG00000032555', u'ENSMUSG00000019942', u'ENSMUSG00000039187', u'ENSMUSG00000030528', u'ENSMUSG00000020326']), NS='BP', pop_items=set([u'ENSMUSG00000028224', u'ENSMUSG00000031928', u'ENSMUSG00000003541', u'ENSMUSG00000032555', u'ENSMUSG00000030322', u'ENSMUSG00000021597', u'ENSMUSG00000061288', u'ENSMUSG00000020381', u'ENSMUSG00000019942', u'ENSMUSG00000039187', u'ENSMUSG00000042903', u'ENSMUSG00000030994', u'ENSMUSG00000028821', u'ENSMUSG00000018669', u'ENSMUSG00000024906', u'ENSMUSG00000030528', u'ENSMUSG00000020326']), pop_n=13836, p_sm_bonferroni=1.0, is_obsolete=False, GO='GO:0007095', name='mitotic G2 DNA damage checkpoint', pop_count=17, alt_ids=[], level=5, depth=11, enrichment='e', Cluster='Transient Increase', geneid_set=set([u'ENSMUSG00000028224', u'ENSMUSG00000032555', u'ENSMUSG00000030528', u'ENSMUSG00000019942', u'ENSMUSG00000039187', u'ENSMUSG00000020326']), symbols=u'Blm Ccng1 Cdk1 Fanci Nbn Topbp1', symbol_set=set([u'Topbp1', u'Ccng1', u'Blm', u'Cdk1', u'Nbn', u'Fanci']), geneids='ENSMUSG00000028224 ENSMUSG00000032555 ENSMUSG00000019942 ENSMUSG00000039187 ENSMUSG00000030528 ENSMUSG00000020326', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=0, D1='ABF', GO_name='mitotic G2 DNA damage checkpoint'),
    Nt(p_uncorrected=8.658111398305377e-05, study_count=7, study_n=624, namespace='biological_process', p_fdr_bh=0.007998722304617364, study_items=set([u'ENSMUSG00000029414', u'ENSMUSG00000028224', u'ENSMUSG00000038379', u'ENSMUSG00000032113', u'ENSMUSG00000029910', u'ENSMUSG00000032400', u'ENSMUSG00000041133']), NS='BP', pop_items=set([u'ENSMUSG00000028224', u'ENSMUSG00000029414', u'ENSMUSG00000038379', u'ENSMUSG00000027933', u'ENSMUSG00000020413', u'ENSMUSG00000043991', u'ENSMUSG00000025374', u'ENSMUSG00000034509', u'ENSMUSG00000002603', u'ENSMUSG00000032113', u'ENSMUSG00000000126', u'ENSMUSG00000032264', u'ENSMUSG00000026107', u'ENSMUSG00000045482', u'ENSMUSG00000041133', u'ENSMUSG00000019923', u'ENSMUSG00000021701', u'ENSMUSG00000032400', u'ENSMUSG00000014668', u'ENSMUSG00000004895', u'ENSMUSG00000025499', u'ENSMUSG00000029910', u'ENSMUSG00000021635', u'ENSMUSG00000028495', u'ENSMUSG00000007659']), pop_n=13836, p_sm_bonferroni=1.0, is_obsolete=False, GO='GO:0007093', name='mitotic cell cycle checkpoint', pop_count=25, alt_ids=['GO:0031575', 'GO:0071780'], level=3, depth=7, enrichment='e', Cluster='Transient Increase', geneid_set=set([u'ENSMUSG00000029414', u'ENSMUSG00000028224', u'ENSMUSG00000038379', u'ENSMUSG00000032400', u'ENSMUSG00000032113', u'ENSMUSG00000041133', u'ENSMUSG00000029910']), symbols=u'Chek1 Kntc1 Mad2l1 Nbn Smc1a Ttk Zwilch', symbol_set=set([u'Smc1a', u'Mad2l1', u'Kntc1', u'Ttk', u'Nbn', u'Zwilch', u'Chek1']), geneids='ENSMUSG00000028224 ENSMUSG00000029414 ENSMUSG00000038379 ENSMUSG00000032113 ENSMUSG00000029910 ENSMUSG00000032400 ENSMUSG00000041133', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=18, D1='AB', GO_name='mitotic cell cycle checkpoint'),
    Nt(p_uncorrected=7.499341564904797e-05, study_count=40, study_n=624, namespace='biological_process', p_fdr_bh=0.00714607069496054, study_items=set([u'ENSMUSG00000040084', u'ENSMUSG00000070034', u'ENSMUSG00000003873', u'ENSMUSG00000027469', u'ENSMUSG00000036986', u'ENSMUSG00000040483', u'ENSMUSG00000059552', u'ENSMUSG00000002870', u'ENSMUSG00000029521', u'ENSMUSG00000002307', u'ENSMUSG00000030641', u'ENSMUSG00000035683', u'ENSMUSG00000032508', u'ENSMUSG00000035293', u'ENSMUSG00000019942', u'ENSMUSG00000025507', u'ENSMUSG00000028282', u'ENSMUSG00000027379', u'ENSMUSG00000022074', u'ENSMUSG00000057789', u'ENSMUSG00000028211', u'ENSMUSG00000055612', u'ENSMUSG00000018899', u'ENSMUSG00000041801', u'ENSMUSG00000006445', u'ENSMUSG00000040734', u'ENSMUSG00000004446', u'ENSMUSG00000019979', u'ENSMUSG00000025647', u'ENSMUSG00000002083', u'ENSMUSG00000005413', u'ENSMUSG00000024521', u'ENSMUSG00000017716', u'ENSMUSG00000027490', u'ENSMUSG00000030609', u'ENSMUSG00000037725', u'ENSMUSG00000000037', u'ENSMUSG00000045932', u'ENSMUSG00000020108', u'ENSMUSG00000046607']), NS='BP', pop_items=set([u'ENSMUSG00000040084', u'ENSMUSG00000003873', u'ENSMUSG00000002015', u'ENSMUSG00000028029', u'ENSMUSG00000020190', u'ENSMUSG00000027381', u'ENSMUSG00000027387', u'ENSMUSG00000050088', u'ENSMUSG00000037242', u'ENSMUSG00000004637', u'ENSMUSG00000020817', u'ENSMUSG00000027663', u'ENSMUSG00000030849', u'ENSMUSG00000068220', u'ENSMUSG00000030847', u'ENSMUSG00000030846', u'ENSMUSG00000034958', u'ENSMUSG00000020755', u'ENSMUSG00000021408', u'ENSMUSG00000024044', u'ENSMUSG00000030204', u'ENSMUSG00000031887', u'ENSMUSG00000045502', u'ENSMUSG00000006445', u'ENSMUSG00000042350', u'ENSMUSG00000027016', u'ENSMUSG00000080268', u'ENSMUSG00000041837', u'ENSMUSG00000078566', u'ENSMUSG00000002307', u'ENSMUSG00000038058', u'ENSMUSG00000020108', u'ENSMUSG00000054676', u'ENSMUSG00000022763', u'ENSMUSG00000019851', u'ENSMUSG00000019850', u'ENSMUSG00000024290', u'ENSMUSG00000036986', u'ENSMUSG00000026942', u'ENSMUSG00000018209', u'ENSMUSG00000002870', u'ENSMUSG00000021886', u'ENSMUSG00000031642', u'ENSMUSG00000032244', u'ENSMUSG00000047123', u'ENSMUSG00000021285', u'ENSMUSG00000037860', u'ENSMUSG00000057789', u'ENSMUSG00000021948', u'ENSMUSG00000020402', u'ENSMUSG00000026834', u'ENSMUSG00000032965', u'ENSMUSG00000011958', u'ENSMUSG00000037787', u'ENSMUSG00000078942', u'ENSMUSG00000078945', u'ENSMUSG00000000787', u'ENSMUSG00000007613', u'ENSMUSG00000036850', u'ENSMUSG00000070034', u'ENSMUSG00000020715', u'ENSMUSG00000030793', u'ENSMUSG00000031781', u'ENSMUSG00000027835', u'ENSMUSG00000025157', u'ENSMUSG00000004056', u'ENSMUSG00000028578', u'ENSMUSG00000028470', u'ENSMUSG00000021143', u'ENSMUSG00000028974', u'ENSMUSG00000038828', u'ENSMUSG00000030498', u'ENSMUSG00000046707', u'ENSMUSG00000063358', u'ENSMUSG00000027900', u'ENSMUSG00000014349', u'ENSMUSG00000030538', u'ENSMUSG00000026181', u'ENSMUSG00000031429', u'ENSMUSG00000038914', u'ENSMUSG00000040687', u'ENSMUSG00000045867', u'ENSMUSG00000050953', u'ENSMUSG00000014791', u'ENSMUSG00000019647', u'ENSMUSG00000025876', u'ENSMUSG00000024012', u'ENSMUSG00000030339', u'ENSMUSG00000024392', u'ENSMUSG00000030330', u'ENSMUSG00000018567', u'ENSMUSG00000022892', u'ENSMUSG00000004446', u'ENSMUSG00000018411', u'ENSMUSG00000022051', u'ENSMUSG00000044813', u'ENSMUSG00000019942', u'ENSMUSG00000035105', u'ENSMUSG00000063856', u'ENSMUSG00000010517', u'ENSMUSG00000025408', u'ENSMUSG00000003228', u'ENSMUSG00000018899', u'ENSMUSG00000031112', u'ENSMUSG00000019261', u'ENSMUSG00000000581', u'ENSMUSG00000044636', u'ENSMUSG00000026879', u'ENSMUSG00000053046', u'ENSMUSG00000024712', u'ENSMUSG00000002524', u'ENSMUSG00000020097', u'ENSMUSG00000007659', u'ENSMUSG00000020099', u'ENSMUSG00000032440', u'ENSMUSG00000036432', u'ENSMUSG00000024975', u'ENSMUSG00000020696', u'ENSMUSG00000059552', u'ENSMUSG00000015850', u'ENSMUSG00000030629', u'ENSMUSG00000027177', u'ENSMUSG00000027379', u'ENSMUSG00000005583', u'ENSMUSG00000038612', u'ENSMUSG00000020623', u'ENSMUSG00000029521', u'ENSMUSG00000033712', u'ENSMUSG00000039745', u'ENSMUSG00000034930', u'ENSMUSG00000037316', u'ENSMUSG00000038068', u'ENSMUSG00000035828', u'ENSMUSG00000013698', u'ENSMUSG00000004069', u'ENSMUSG00000035283', u'ENSMUSG00000021610', u'ENSMUSG00000031878', u'ENSMUSG00000004748', u'ENSMUSG00000017291', u'ENSMUSG00000021576', u'ENSMUSG00000017386', u'ENSMUSG00000063694', u'ENSMUSG00000018446', u'ENSMUSG00000026389', u'ENSMUSG00000026029', u'ENSMUSG00000022150', u'ENSMUSG00000028163', u'ENSMUSG00000023010', u'ENSMUSG00000023011', u'ENSMUSG00000026430', u'ENSMUSG00000074170', u'ENSMUSG00000055612', u'ENSMUSG00000031155', u'ENSMUSG00000039913', u'ENSMUSG00000031628', u'ENSMUSG00000078812', u'ENSMUSG00000070934', u'ENSMUSG00000040734', u'ENSMUSG00000003604', u'ENSMUSG00000024182', u'ENSMUSG00000024758', u'ENSMUSG00000022339', u'ENSMUSG00000089682', u'ENSMUSG00000053647', u'ENSMUSG00000026842', u'ENSMUSG00000009772', u'ENSMUSG00000030654', u'ENSMUSG00000003039', u'ENSMUSG00000038545', u'ENSMUSG00000026510', u'ENSMUSG00000042724', u'ENSMUSG00000024235', u'ENSMUSG00000027131', u'ENSMUSG00000000148', u'ENSMUSG00000020225', u'ENSMUSG00000001082', u'ENSMUSG00000041135', u'ENSMUSG00000035086', u'ENSMUSG00000025008', u'ENSMUSG00000039701', u'ENSMUSG00000001729', u'ENSMUSG00000028563', u'ENSMUSG00000034974', u'ENSMUSG00000028145', u'ENSMUSG00000022781', u'ENSMUSG00000027598', u'ENSMUSG00000025647', u'ENSMUSG00000005413', u'ENSMUSG00000024521', u'ENSMUSG00000020902', u'ENSMUSG00000024526', u'ENSMUSG00000035900', u'ENSMUSG00000026749', u'ENSMUSG00000000037', u'ENSMUSG00000043866', u'ENSMUSG00000072872', u'ENSMUSG00000028969', u'ENSMUSG00000003955', u'ENSMUSG00000017390', u'ENSMUSG00000038084', u'ENSMUSG00000040990', u'ENSMUSG00000028289', u'ENSMUSG00000063410', u'ENSMUSG00000028282', u'ENSMUSG00000028284', u'ENSMUSG00000045078', u'ENSMUSG00000028443', u'ENSMUSG00000032688', u'ENSMUSG00000028914', u'ENSMUSG00000050965', u'ENSMUSG00000040451', u'ENSMUSG00000003812', u'ENSMUSG00000004328', u'ENSMUSG00000028211', u'ENSMUSG00000000915', u'ENSMUSG00000025860', u'ENSMUSG00000036840', u'ENSMUSG00000021277', u'ENSMUSG00000024382', u'ENSMUSG00000030341', u'ENSMUSG00000035683', u'ENSMUSG00000031667', u'ENSMUSG00000004451', u'ENSMUSG00000022185', u'ENSMUSG00000019979', u'ENSMUSG00000002083', u'ENSMUSG00000019970', u'ENSMUSG00000056870', u'ENSMUSG00000032532', u'ENSMUSG00000021831', u'ENSMUSG00000006335', u'ENSMUSG00000027469', u'ENSMUSG00000068921', u'ENSMUSG00000020267', u'ENSMUSG00000020516', u'ENSMUSG00000019579', u'ENSMUSG00000026883', u'ENSMUSG00000029610', u'ENSMUSG00000024191', u'ENSMUSG00000002250', u'ENSMUSG00000029104', u'ENSMUSG00000039959', u'ENSMUSG00000025507', u'ENSMUSG00000020063', u'ENSMUSG00000029681', u'ENSMUSG00000029686', u'ENSMUSG00000019054', u'ENSMUSG00000042750', u'ENSMUSG00000027490', u'ENSMUSG00000045932', u'ENSMUSG00000025764', u'ENSMUSG00000029433', u'ENSMUSG00000009112', u'ENSMUSG00000023905', u'ENSMUSG00000029535', u'ENSMUSG00000046432', u'ENSMUSG00000037062', u'ENSMUSG00000028416', u'ENSMUSG00000027649', u'ENSMUSG00000016918', u'ENSMUSG00000041319', u'ENSMUSG00000000552', u'ENSMUSG00000028959', u'ENSMUSG00000035293', u'ENSMUSG00000027313', u'ENSMUSG00000068329', u'ENSMUSG00000004071', u'ENSMUSG00000048232', u'ENSMUSG00000052752', u'ENSMUSG00000000392', u'ENSMUSG00000026142', u'ENSMUSG00000039126', u'ENSMUSG00000062209', u'ENSMUSG00000071337', u'ENSMUSG00000001419', u'ENSMUSG00000064246', u'ENSMUSG00000055024', u'ENSMUSG00000064326', u'ENSMUSG00000032369', u'ENSMUSG00000030814', u'ENSMUSG00000026031', u'ENSMUSG00000032000', u'ENSMUSG00000034160', u'ENSMUSG00000013973', u'ENSMUSG00000020340', u'ENSMUSG00000017670', u'ENSMUSG00000021868', u'ENSMUSG00000032463', u'ENSMUSG00000029026', u'ENSMUSG00000029020', u'ENSMUSG00000032508', u'ENSMUSG00000032504', u'ENSMUSG00000071203', u'ENSMUSG00000021514', u'ENSMUSG00000022329', u'ENSMUSG00000063065', u'ENSMUSG00000036932', u'ENSMUSG00000044167', u'ENSMUSG00000024349', u'ENSMUSG00000002820', u'ENSMUSG00000057666', u'ENSMUSG00000032212', u'ENSMUSG00000025888', u'ENSMUSG00000044647', u'ENSMUSG00000025499', u'ENSMUSG00000057329', u'ENSMUSG00000039304', u'ENSMUSG00000015950', u'ENSMUSG00000038160', u'ENSMUSG00000037608', u'ENSMUSG00000039164', u'ENSMUSG00000009013', u'ENSMUSG00000029474', u'ENSMUSG00000039168', u'ENSMUSG00000028680', u'ENSMUSG00000025373', u'ENSMUSG00000025375', u'ENSMUSG00000025076', u'ENSMUSG00000024959', u'ENSMUSG00000030641', u'ENSMUSG00000027193', u'ENSMUSG00000040093', u'ENSMUSG00000079056', u'ENSMUSG00000024887', u'ENSMUSG00000006651', u'ENSMUSG00000015312', u'ENSMUSG00000035873', u'ENSMUSG00000028191', u'ENSMUSG00000058638', u'ENSMUSG00000030102', u'ENSMUSG00000045409', u'ENSMUSG00000026278', u'ENSMUSG00000031523', u'ENSMUSG00000027997', u'ENSMUSG00000070730', u'ENSMUSG00000019461', u'ENSMUSG00000026078', u'ENSMUSG00000014771', u'ENSMUSG00000022105', u'ENSMUSG00000052889', u'ENSMUSG00000024073', u'ENSMUSG00000021559', u'ENSMUSG00000040483', u'ENSMUSG00000026094', u'ENSMUSG00000002486', u'ENSMUSG00000002489', u'ENSMUSG00000004591', u'ENSMUSG00000022174', u'ENSMUSG00000071369', u'ENSMUSG00000038028', u'ENSMUSG00000022074', u'ENSMUSG00000019969', u'ENSMUSG00000020376', u'ENSMUSG00000024287', u'ENSMUSG00000020372', u'ENSMUSG00000075707', u'ENSMUSG00000003068', u'ENSMUSG00000002948', u'ENSMUSG00000078970', u'ENSMUSG00000033256', u'ENSMUSG00000002265', u'ENSMUSG00000062762', u'ENSMUSG00000057367', u'ENSMUSG00000022314', u'ENSMUSG00000021486', u'ENSMUSG00000054364', u'ENSMUSG00000037725', u'ENSMUSG00000043668', u'ENSMUSG00000063626', u'ENSMUSG00000060538', u'ENSMUSG00000020074', u'ENSMUSG00000024778', u'ENSMUSG00000061436', u'ENSMUSG00000036285', u'ENSMUSG00000056313', u'ENSMUSG00000013663', u'ENSMUSG00000054499', u'ENSMUSG00000066900', u'ENSMUSG00000015837', u'ENSMUSG00000046607', u'ENSMUSG00000060534', u'ENSMUSG00000028883', u'ENSMUSG00000030609', u'ENSMUSG00000030602', u'ENSMUSG00000028630', u'ENSMUSG00000092035', u'ENSMUSG00000020205', u'ENSMUSG00000059921', u'ENSMUSG00000059920', u'ENSMUSG00000029027', u'ENSMUSG00000067787', u'ENSMUSG00000024826', u'ENSMUSG00000025024', u'ENSMUSG00000023915', u'ENSMUSG00000028549', u'ENSMUSG00000030417', u'ENSMUSG00000041801', u'ENSMUSG00000027804', u'ENSMUSG00000044340', u'ENSMUSG00000024500', u'ENSMUSG00000057530', u'ENSMUSG00000030774', u'ENSMUSG00000041241', u'ENSMUSG00000020484', u'ENSMUSG00000030898', u'ENSMUSG00000035104', u'ENSMUSG00000020077', u'ENSMUSG00000019428', u'ENSMUSG00000048756', u'ENSMUSG00000035109', u'ENSMUSG00000032580', u'ENSMUSG00000027937', u'ENSMUSG00000021453', u'ENSMUSG00000047496', u'ENSMUSG00000062210', u'ENSMUSG00000030557', u'ENSMUSG00000026285', u'ENSMUSG00000026288', u'ENSMUSG00000021127', u'ENSMUSG00000070814', u'ENSMUSG00000032076', u'ENSMUSG00000020650', u'ENSMUSG00000020653', u'ENSMUSG00000023034', u'ENSMUSG00000040435', u'ENSMUSG00000078652', u'ENSMUSG00000041028', u'ENSMUSG00000032194', u'ENSMUSG00000004535', u'ENSMUSG00000033352', u'ENSMUSG00000031536', u'ENSMUSG00000059866', u'ENSMUSG00000032515', u'ENSMUSG00000022043', u'ENSMUSG00000030400', u'ENSMUSG00000021910', u'ENSMUSG00000010911', u'ENSMUSG00000002580', u'ENSMUSG00000041112', u'ENSMUSG00000017716', u'ENSMUSG00000043991', u'ENSMUSG00000022500', u'ENSMUSG00000058325', u'ENSMUSG00000029863', u'ENSMUSG00000010608', u'ENSMUSG00000002688', u'ENSMUSG00000037752', u'ENSMUSG00000053436', u'ENSMUSG00000026767', u'ENSMUSG00000078578', u'ENSMUSG00000025060', u'ENSMUSG00000030744', u'ENSMUSG00000037032', u'ENSMUSG00000054252', u'ENSMUSG00000052139', u'ENSMUSG00000042675', u'ENSMUSG00000018819']), pop_n=13836, p_sm_bonferroni=1.0, is_obsolete=False, GO='GO:0006915', name='apoptotic process', pop_count=458, alt_ids=['GO:0006917', 'GO:0008632'], level=5, depth=5, enrichment='e', Cluster='Transient Increase', geneid_set=set([u'ENSMUSG00000040084', u'ENSMUSG00000070034', u'ENSMUSG00000003873', u'ENSMUSG00000027469', u'ENSMUSG00000036986', u'ENSMUSG00000040483', u'ENSMUSG00000059552', u'ENSMUSG00000002870', u'ENSMUSG00000018899', u'ENSMUSG00000037725', u'ENSMUSG00000030641', u'ENSMUSG00000035683', u'ENSMUSG00000032508', u'ENSMUSG00000035293', u'ENSMUSG00000019942', u'ENSMUSG00000025507', u'ENSMUSG00000028282', u'ENSMUSG00000027379', u'ENSMUSG00000022074', u'ENSMUSG00000057789', u'ENSMUSG00000028211', u'ENSMUSG00000055612', u'ENSMUSG00000029521', u'ENSMUSG00000041801', u'ENSMUSG00000006445', u'ENSMUSG00000040734', u'ENSMUSG00000004446', u'ENSMUSG00000019979', u'ENSMUSG00000025647', u'ENSMUSG00000002083', u'ENSMUSG00000005413', u'ENSMUSG00000024521', u'ENSMUSG00000017716', u'ENSMUSG00000027490', u'ENSMUSG00000030609', u'ENSMUSG00000002307', u'ENSMUSG00000000037', u'ENSMUSG00000045932', u'ENSMUSG00000020108', u'ENSMUSG00000046607']), symbols=u'Aen Apaf1 Bak1 Bax Bbc3 Bid Birc5 Bub1 Bub1b Casp8ap2 Cdca7 Cdk1 Chek2 Ckap2 Daxx Ddias Ddit4 E2f1 Epha2 G2e3 Hmox1 Hrk Ifit2 Irf1 Mcm2 Melk Myd88 Phlda3 Pidd1 Pmaip1 Pml Ppp1r13l Scml2 Shisa5 Sp110 Tnfrsf10b Tpx2 Trp53 Trp53inp1 Xaf1', symbol_set=set([u'Daxx', u'Hmox1', u'Tnfrsf10b', u'Irf1', u'Mcm2', u'Hrk', u'Sp110', u'Pmaip1', u'Chek2', u'Phlda3', u'Tpx2', u'Bub1b', u'Bid', u'G2e3', u'Epha2', u'Bak1', u'Shisa5', u'Apaf1', 'Ddias', u'Bub1', u'E2f1', u'Trp53', u'Xaf1', u'Bax', 'Pidd1', u'Scml2', u'Ckap2', u'Bbc3', u'Aen', u'Ppp1r13l', u'Ddit4', u'Melk', u'Casp8ap2', u'Ifit2', u'Cdk1', u'Trp53inp1', u'Pml', u'Myd88', u'Birc5', u'Cdca7']), geneids='ENSMUSG00000040084 ENSMUSG00000070034 ENSMUSG00000003873 ENSMUSG00000027469 ENSMUSG00000036986 ENSMUSG00000004446 ENSMUSG00000028282 ENSMUSG00000059552 ENSMUSG00000002870 ENSMUSG00000029521 ENSMUSG00000037725 ENSMUSG00000030641 ENSMUSG00000032508 ENSMUSG00000030609 ENSMUSG00000035293 ENSMUSG00000019942 ENSMUSG00000025507 ENSMUSG00000040483 ENSMUSG00000027379 ENSMUSG00000022074 ENSMUSG00000057789 ENSMUSG00000028211 ENSMUSG00000055612 ENSMUSG00000018899 ENSMUSG00000035683 ENSMUSG00000041801 ENSMUSG00000006445 ENSMUSG00000040734 ENSMUSG00000019979 ENSMUSG00000025647 ENSMUSG00000002083 ENSMUSG00000005413 ENSMUSG00000024521 ENSMUSG00000017716 ENSMUSG00000027490 ENSMUSG00000002307 ENSMUSG00000000037 ENSMUSG00000045932 ENSMUSG00000020108 ENSMUSG00000046607', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=78, D1='BC', GO_name='apoptotic process'),
    Nt(p_uncorrected=1.0613331792342115e-06, study_count=5, study_n=624, namespace='biological_process', p_fdr_bh=0.00016408427549568916, study_items=set([u'ENSMUSG00000026622', u'ENSMUSG00000027699', u'ENSMUSG00000002055', u'ENSMUSG00000023015', u'ENSMUSG00000027331']), NS='BP', pop_items=set([u'ENSMUSG00000027699', u'ENSMUSG00000002055', u'ENSMUSG00000023015', u'ENSMUSG00000005871', u'ENSMUSG00000027331', u'ENSMUSG00000026622']), pop_n=13836, p_sm_bonferroni=0.016080258998577537, is_obsolete=False, GO='GO:0051988', name='regulation of attachment of spindle microtubules to kinetochore', pop_count=6, alt_ids=[], level=5, depth=6, enrichment='e', Cluster='Transient Increase', geneid_set=set([u'ENSMUSG00000026622', u'ENSMUSG00000027699', u'ENSMUSG00000002055', u'ENSMUSG00000023015', u'ENSMUSG00000027331']), symbols=u'Ect2 Knstrn Nek2 Racgap1 Spag5', symbol_set=set([u'Racgap1', 'Knstrn', u'Spag5', u'Nek2', u'Ect2']), geneids='ENSMUSG00000026622 ENSMUSG00000027699 ENSMUSG00000002055 ENSMUSG00000023015 ENSMUSG00000027331', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=9, D1='A', GO_name='regulation of attachment of spindle microtubules to kinetochore'),
]
