"""GOATOOLS GOEA on 2015 Gjoneska data using go-basic.obo: fmt(1.2) rel(2017-01-12) 47,943 GO Terms"""

# Created: 2017-01-13
import collections as cx

nt_fields = [
    "p_uncorrected",
    "study_count",
    "study_n",
    "namespace",
    "p_fdr_bh",
    "study_items",
    "NS",
    "pop_items",
    "pop_n",
    "p_sm_bonferroni",
    "is_obsolete",
    "GO",
    "name",
    "pop_count",
    "alt_ids",
    "level",
    "depth",
    "enrichment",
    "Cluster",
    "geneid_set",
    "symbols",
    "symbol_set",
    "geneids",
    "format_txt",
    "hdr_idx",
    "is_hdrgo",
    "is_usrgo",
    "hdr1usr01",
    "dcnt",
    "D1",
    "GO_name",
]

Nt = cx.namedtuple("Nt", " ".join(nt_fields))

# 163 items
nts = [
    Nt(p_uncorrected=0.0005660627202574551, study_count=6, study_n=1397, namespace='biological_process', p_fdr_bh=0.042041256248140695, study_items=set([u'ENSMUSG00000002365', u'ENSMUSG00000002985', u'ENSMUSG00000021340', u'ENSMUSG00000070509', u'ENSMUSG00000032733', u'ENSMUSG00000028599']), NS='BP', pop_items=set([u'ENSMUSG00000033717', u'ENSMUSG00000002365', u'ENSMUSG00000025473', u'ENSMUSG00000028082', u'ENSMUSG00000053510', u'ENSMUSG00000002985', u'ENSMUSG00000031555', u'ENSMUSG00000021340', u'ENSMUSG00000070509', u'ENSMUSG00000032733', u'ENSMUSG00000027257', u'ENSMUSG00000028599']), pop_n=13836, p_sm_bonferroni=1.0, is_obsolete=False, GO='GO:0051044', name='positive regulation of membrane protein ectodomain proteolysis', pop_count=12, alt_ids=[], level=7, depth=9, enrichment='e', Cluster='Late Increase', geneid_set=set([u'ENSMUSG00000002985', u'ENSMUSG00000002365', u'ENSMUSG00000021340', u'ENSMUSG00000070509', u'ENSMUSG00000032733', u'ENSMUSG00000028599']), symbols=u'Apoe Gpld1 Rgma Snx33 Snx9 Tnfrsf1b', symbol_set=set([u'Apoe', u'Tnfrsf1b', u'Snx9', u'Gpld1', u'Snx33', u'Rgma']), geneids='ENSMUSG00000002365 ENSMUSG00000002985 ENSMUSG00000021340 ENSMUSG00000070509 ENSMUSG00000032733 ENSMUSG00000028599', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=0, D1='A', GO_name='positive regulation of membrane protein ectodomain proteolysis'),
    Nt(p_uncorrected='', study_count='', study_n='', namespace='', p_fdr_bh='', study_items='', NS='BP', pop_items='', pop_n='', p_sm_bonferroni='', is_obsolete='', GO='GO:0019222', name='', pop_count='', alt_ids='', level=3, depth=3, enrichment='', Cluster='', geneid_set='', symbols='', symbol_set='', geneids='', format_txt=1, hdr_idx=1, is_hdrgo=True, is_usrgo=False, hdr1usr01='*', dcnt=3356, D1='A', GO_name='regulation of metabolic process'),
    Nt(p_uncorrected=0.0006749090679732751, study_count=9, study_n=1397, namespace='biological_process', p_fdr_bh=0.04869308232791949, study_items=set([u'ENSMUSG00000037016', u'ENSMUSG00000040055', u'ENSMUSG00000021477', u'ENSMUSG00000056966', u'ENSMUSG00000047797', u'ENSMUSG00000050953', u'ENSMUSG00000020758', u'ENSMUSG00000046352', u'ENSMUSG00000069170']), NS='BP', pop_items=set([u'ENSMUSG00000021477', u'ENSMUSG00000057123', u'ENSMUSG00000068615', u'ENSMUSG00000059049', u'ENSMUSG00000020716', u'ENSMUSG00000030376', u'ENSMUSG00000023960', u'ENSMUSG00000034687', u'ENSMUSG00000002799', u'ENSMUSG00000046352', u'ENSMUSG00000037016', u'ENSMUSG00000079055', u'ENSMUSG00000047797', u'ENSMUSG00000027314', u'ENSMUSG00000027276', u'ENSMUSG00000050234', u'ENSMUSG00000054640', u'ENSMUSG00000020758', u'ENSMUSG00000040055', u'ENSMUSG00000020393', u'ENSMUSG00000056966', u'ENSMUSG00000043448', u'ENSMUSG00000050953', u'ENSMUSG00000034520', u'ENSMUSG00000014773', u'ENSMUSG00000069170']), pop_n=13836, p_sm_bonferroni=1.0, is_obsolete=False, GO='GO:0007154', name='cell communication', pop_count=26, alt_ids=[], level=2, depth=2, enrichment='e', Cluster='Late Increase', geneid_set=set([u'ENSMUSG00000037016', u'ENSMUSG00000040055', u'ENSMUSG00000021477', u'ENSMUSG00000047797', u'ENSMUSG00000056966', u'ENSMUSG00000050953', u'ENSMUSG00000020758', u'ENSMUSG00000046352', u'ENSMUSG00000069170']), symbols=u'Adgrv1 Ctsl Frem2 Gja1 Gjb1 Gjb2 Gjb6 Gjc3 Itgb4', symbol_set=set([u'Gja1', u'Ctsl', u'Itgb4', u'Gjb1', u'Gjb2', u'Gjc3', u'Gjb6', u'Frem2', 'Adgrv1']), geneids='ENSMUSG00000021477 ENSMUSG00000040055 ENSMUSG00000037016 ENSMUSG00000056966 ENSMUSG00000047797 ENSMUSG00000050953 ENSMUSG00000020758 ENSMUSG00000046352 ENSMUSG00000069170', format_txt=1, hdr_idx=1, is_hdrgo=True, is_usrgo=True, hdr1usr01='**', dcnt=203, D1='B', GO_name='cell communication'),
    Nt(p_uncorrected=1.1699459778512715e-06, study_count=15, study_n=1397, namespace='biological_process', p_fdr_bh=0.0003475657158906787, study_items=set([u'ENSMUSG00000022912', u'ENSMUSG00000027082', u'ENSMUSG00000026249', u'ENSMUSG00000024164', u'ENSMUSG00000039109', u'ENSMUSG00000028128', u'ENSMUSG00000001930', u'ENSMUSG00000027712', u'ENSMUSG00000074743', u'ENSMUSG00000048376', u'ENSMUSG00000032006', u'ENSMUSG00000023961', u'ENSMUSG00000031451', u'ENSMUSG00000024899', u'ENSMUSG00000023224']), NS='BP', pop_items=set([u'ENSMUSG00000022912', u'ENSMUSG00000028128', u'ENSMUSG00000064210', u'ENSMUSG00000039109', u'ENSMUSG00000001930', u'ENSMUSG00000025856', u'ENSMUSG00000021686', u'ENSMUSG00000005804', u'ENSMUSG00000023961', u'ENSMUSG00000042328', u'ENSMUSG00000025188', u'ENSMUSG00000032202', u'ENSMUSG00000026249', u'ENSMUSG00000057531', u'ENSMUSG00000026579', u'ENSMUSG00000056724', u'ENSMUSG00000023224', u'ENSMUSG00000048376', u'ENSMUSG00000036353', u'ENSMUSG00000027082', u'ENSMUSG00000024164', u'ENSMUSG00000000489', u'ENSMUSG00000050761', u'ENSMUSG00000031451', u'ENSMUSG00000057667', u'ENSMUSG00000031196', u'ENSMUSG00000028019', u'ENSMUSG00000025314', u'ENSMUSG00000074811', u'ENSMUSG00000027712', u'ENSMUSG00000014418', u'ENSMUSG00000032006', u'ENSMUSG00000019726', u'ENSMUSG00000074743', u'ENSMUSG00000022766', u'ENSMUSG00000024899', u'ENSMUSG00000009207']), pop_n=13836, p_sm_bonferroni=0.017725851510424617, is_obsolete=False, GO='GO:0007596', name='blood coagulation', pop_count=37, alt_ids=[], level=4, depth=5, enrichment='e', Cluster='Late Increase', geneid_set=set([u'ENSMUSG00000022912', u'ENSMUSG00000026249', u'ENSMUSG00000024164', u'ENSMUSG00000039109', u'ENSMUSG00000028128', u'ENSMUSG00000001930', u'ENSMUSG00000027712', u'ENSMUSG00000074743', u'ENSMUSG00000048376', u'ENSMUSG00000032006', u'ENSMUSG00000023961', u'ENSMUSG00000031451', u'ENSMUSG00000024899', u'ENSMUSG00000027082', u'ENSMUSG00000023224']), symbols=u'Anxa5 C3 Enpp4 F13a1 F2r F3 Gas6 Papss2 Pdgfd Pros1 Serpine2 Serping1 Tfpi Thbd Vwf', symbol_set=set([u'F3', u'Anxa5', u'Enpp4', u'Pros1', u'Serping1', u'F2r', u'Papss2', u'Pdgfd', u'Tfpi', u'C3', u'F13a1', u'Vwf', u'Thbd', u'Serpine2', u'Gas6']), geneids='ENSMUSG00000022912 ENSMUSG00000026249 ENSMUSG00000024164 ENSMUSG00000039109 ENSMUSG00000028128 ENSMUSG00000001930 ENSMUSG00000074743 ENSMUSG00000027712 ENSMUSG00000023224 ENSMUSG00000048376 ENSMUSG00000032006 ENSMUSG00000023961 ENSMUSG00000031451 ENSMUSG00000024899 ENSMUSG00000027082', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=0, D1='ACJ', GO_name='blood coagulation'),
    Nt(p_uncorrected=2.0577977694134848e-10, study_count=23, study_n=1397, namespace='biological_process', p_fdr_bh=3.0597720239381384e-07, study_items=set([u'ENSMUSG00000035273', u'ENSMUSG00000089661', u'ENSMUSG00000027381', u'ENSMUSG00000026193', u'ENSMUSG00000019997', u'ENSMUSG00000025351', u'ENSMUSG00000005397', u'ENSMUSG00000022505', u'ENSMUSG00000047793', u'ENSMUSG00000006386', u'ENSMUSG00000042284', u'ENSMUSG00000002980', u'ENSMUSG00000022817', u'ENSMUSG00000020758', u'ENSMUSG00000027111', u'ENSMUSG00000026043', u'ENSMUSG00000027962', u'ENSMUSG00000025809', u'ENSMUSG00000016494', u'ENSMUSG00000017344', u'ENSMUSG00000037902', u'ENSMUSG00000053024', u'ENSMUSG00000019920']), NS='BP', pop_items=set([u'ENSMUSG00000026043', u'ENSMUSG00000059049', u'ENSMUSG00000035273', u'ENSMUSG00000059327', u'ENSMUSG00000089661', u'ENSMUSG00000027381', u'ENSMUSG00000031990', u'ENSMUSG00000042284', u'ENSMUSG00000026193', u'ENSMUSG00000040998', u'ENSMUSG00000019997', u'ENSMUSG00000025351', u'ENSMUSG00000005397', u'ENSMUSG00000022505', u'ENSMUSG00000029860', u'ENSMUSG00000027009', u'ENSMUSG00000002489', u'ENSMUSG00000006386', u'ENSMUSG00000006932', u'ENSMUSG00000078716', u'ENSMUSG00000002980', u'ENSMUSG00000021806', u'ENSMUSG00000022817', u'ENSMUSG00000015605', u'ENSMUSG00000020758', u'ENSMUSG00000027087', u'ENSMUSG00000019920', u'ENSMUSG00000027962', u'ENSMUSG00000026812', u'ENSMUSG00000025809', u'ENSMUSG00000026768', u'ENSMUSG00000029528', u'ENSMUSG00000004098', u'ENSMUSG00000016494', u'ENSMUSG00000031555', u'ENSMUSG00000031980', u'ENSMUSG00000002808', u'ENSMUSG00000037712', u'ENSMUSG00000020689', u'ENSMUSG00000033327', u'ENSMUSG00000025609', u'ENSMUSG00000017344', u'ENSMUSG00000000290', u'ENSMUSG00000025473', u'ENSMUSG00000047793', u'ENSMUSG00000037902', u'ENSMUSG00000053024', u'ENSMUSG00000027111', u'ENSMUSG00000030890', u'ENSMUSG00000062352', u'ENSMUSG00000007815', u'ENSMUSG00000028969']), pop_n=13836, p_sm_bonferroni=3.117769400438371e-06, is_obsolete=False, GO='GO:0007160', name='cell-matrix adhesion', pop_count=52, alt_ids=[], level=4, depth=4, enrichment='e', Cluster='Late Increase', geneid_set=set([u'ENSMUSG00000027962', u'ENSMUSG00000035273', u'ENSMUSG00000025809', u'ENSMUSG00000089661', u'ENSMUSG00000027381', u'ENSMUSG00000016494', u'ENSMUSG00000026193', u'ENSMUSG00000019997', u'ENSMUSG00000025351', u'ENSMUSG00000005397', u'ENSMUSG00000022505', u'ENSMUSG00000017344', u'ENSMUSG00000047793', u'ENSMUSG00000006386', u'ENSMUSG00000042284', u'ENSMUSG00000037902', u'ENSMUSG00000053024', u'ENSMUSG00000002980', u'ENSMUSG00000022817', u'ENSMUSG00000019920', u'ENSMUSG00000020758', u'ENSMUSG00000027111', u'ENSMUSG00000026043']), symbols=u'Bcam Bcl2l11 Cd34 Cd63 Cntn2 Col3a1 Ctgf Emp2 Fn1 Hpse Itga1 Itga6 Itgb1 Itgb4 Itgb5 Lims1 Mia Nid1 Sirpa Sned1 Tek Vcam1 Vtn', symbol_set=set([u'Hpse', u'Bcam', u'Sirpa', 'Mia', u'Vtn', u'Ctgf', u'Itgb1', u'Itgb5', u'Fn1', u'Cd34', u'Lims1', u'Emp2', u'Vcam1', u'Sned1', u'Col3a1', u'Bcl2l11', u'Itgb4', u'Tek', u'Cd63', u'Itga1', u'Itga6', u'Cntn2', u'Nid1']), geneids='ENSMUSG00000035273 ENSMUSG00000089661 ENSMUSG00000027381 ENSMUSG00000026193 ENSMUSG00000019997 ENSMUSG00000025351 ENSMUSG00000005397 ENSMUSG00000022505 ENSMUSG00000047793 ENSMUSG00000006386 ENSMUSG00000042284 ENSMUSG00000026043 ENSMUSG00000022817 ENSMUSG00000020758 ENSMUSG00000027111 ENSMUSG00000002980 ENSMUSG00000027962 ENSMUSG00000025809 ENSMUSG00000016494 ENSMUSG00000017344 ENSMUSG00000037902 ENSMUSG00000053024 ENSMUSG00000019920', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=9, D1='P', GO_name='cell-matrix adhesion'),
    Nt(p_uncorrected=6.729307650236889e-05, study_count=6, study_n=1397, namespace='biological_process', p_fdr_bh=0.008932395565025017, study_items=set([u'ENSMUSG00000041309', u'ENSMUSG00000036098', u'ENSMUSG00000031425', u'ENSMUSG00000053024', u'ENSMUSG00000044708', u'ENSMUSG00000021379']), NS='BP', pop_items=set([u'ENSMUSG00000049612', u'ENSMUSG00000041309', u'ENSMUSG00000036098', u'ENSMUSG00000048001', u'ENSMUSG00000054252', u'ENSMUSG00000031425', u'ENSMUSG00000053024', u'ENSMUSG00000044708', u'ENSMUSG00000021379']), pop_n=13836, p_sm_bonferroni=1.0, is_obsolete=False, GO='GO:0022010', name='central nervous system myelination', pop_count=9, alt_ids=[], level=6, depth=6, enrichment='e', Cluster='Late Increase', geneid_set=set([u'ENSMUSG00000053024', u'ENSMUSG00000044708', u'ENSMUSG00000041309', u'ENSMUSG00000036098', u'ENSMUSG00000021379', u'ENSMUSG00000031425']), symbols=u'Cntn2 Id4 Kcnj10 Myrf Nkx6-2 Plp1', symbol_set=set([u'Kcnj10', u'Id4', u'Cntn2', u'Plp1', 'Myrf', 'Nkx6-2']), geneids='ENSMUSG00000041309 ENSMUSG00000036098 ENSMUSG00000031425 ENSMUSG00000053024 ENSMUSG00000044708 ENSMUSG00000021379', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=0, D1='BC', GO_name='central nervous system myelination'),
    Nt(p_uncorrected=3.527805482915541e-05, study_count=12, study_n=1397, namespace='biological_process', p_fdr_bh=0.005090455321109845, study_items=set([u'ENSMUSG00000031385', u'ENSMUSG00000025608', u'ENSMUSG00000053062', u'ENSMUSG00000057103', u'ENSMUSG00000053646', u'ENSMUSG00000024300', u'ENSMUSG00000006369', u'ENSMUSG00000054693', u'ENSMUSG00000036606', u'ENSMUSG00000024696', u'ENSMUSG00000022309', u'ENSMUSG00000041417']), NS='BP', pop_items=set([u'ENSMUSG00000031385', u'ENSMUSG00000057103', u'ENSMUSG00000021451', u'ENSMUSG00000024696', u'ENSMUSG00000006369', u'ENSMUSG00000029245', u'ENSMUSG00000018166', u'ENSMUSG00000048826', u'ENSMUSG00000028519', u'ENSMUSG00000030671', u'ENSMUSG00000032087', u'ENSMUSG00000022309', u'ENSMUSG00000041417', u'ENSMUSG00000050272', u'ENSMUSG00000053646', u'ENSMUSG00000000530', u'ENSMUSG00000036606', u'ENSMUSG00000031841', u'ENSMUSG00000020659', u'ENSMUSG00000038453', u'ENSMUSG00000056201', u'ENSMUSG00000021549', u'ENSMUSG00000031740', u'ENSMUSG00000015829', u'ENSMUSG00000002900', u'ENSMUSG00000022231', u'ENSMUSG00000025608', u'ENSMUSG00000053062', u'ENSMUSG00000054693', u'ENSMUSG00000028364', u'ENSMUSG00000024300', u'ENSMUSG00000054855']), pop_n=13836, p_sm_bonferroni=0.5344978087165336, is_obsolete=False, GO='GO:0007162', name='negative regulation of cell adhesion', pop_count=32, alt_ids=[], level=4, depth=5, enrichment='e', Cluster='Late Increase', geneid_set=set([u'ENSMUSG00000031385', u'ENSMUSG00000025608', u'ENSMUSG00000053062', u'ENSMUSG00000057103', u'ENSMUSG00000053646', u'ENSMUSG00000024696', u'ENSMUSG00000006369', u'ENSMUSG00000054693', u'ENSMUSG00000036606', u'ENSMUSG00000024300', u'ENSMUSG00000022309', u'ENSMUSG00000041417']), symbols=u'Adam10 Angpt1 Fbln1 Jam2 Lpxn Myo1f Nat8f1 Pik3r1 Plxnb1 Plxnb2 Plxnb3 Podxl', symbol_set=set([u'Plxnb2', u'Plxnb3', u'Plxnb1', u'Jam2', u'Lpxn', u'Myo1f', u'Adam10', 'Nat8f1', u'Podxl', u'Pik3r1', u'Fbln1', u'Angpt1']), geneids='ENSMUSG00000022309 ENSMUSG00000025608 ENSMUSG00000053062 ENSMUSG00000057103 ENSMUSG00000053646 ENSMUSG00000024300 ENSMUSG00000006369 ENSMUSG00000054693 ENSMUSG00000036606 ENSMUSG00000024696 ENSMUSG00000031385 ENSMUSG00000041417', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=86, D1='A', GO_name='negative regulation of cell adhesion'),
    Nt(p_uncorrected=5.755456364731974e-10, study_count=114, study_n=1397, namespace='biological_process', p_fdr_bh=3.963678153729734e-07, study_items=set([u'ENSMUSG00000042594', u'ENSMUSG00000045087', u'ENSMUSG00000015355', u'ENSMUSG00000042190', u'ENSMUSG00000018500', u'ENSMUSG00000022799', u'ENSMUSG00000001761', u'ENSMUSG00000029101', u'ENSMUSG00000016128', u'ENSMUSG00000001768', u'ENSMUSG00000004591', u'ENSMUSG00000036606', u'ENSMUSG00000037523', u'ENSMUSG00000028583', u'ENSMUSG00000020611', u'ENSMUSG00000000732', u'ENSMUSG00000060477', u'ENSMUSG00000020591', u'ENSMUSG00000039031', u'ENSMUSG00000032714', u'ENSMUSG00000063506', u'ENSMUSG00000034930', u'ENSMUSG00000024960', u'ENSMUSG00000059013', u'ENSMUSG00000000567', u'ENSMUSG00000061718', u'ENSMUSG00000026424', u'ENSMUSG00000052056', u'ENSMUSG00000002147', u'ENSMUSG00000032766', u'ENSMUSG00000037999', u'ENSMUSG00000021136', u'ENSMUSG00000031486', u'ENSMUSG00000030272', u'ENSMUSG00000031714', u'ENSMUSG00000056529', u'ENSMUSG00000029309', u'ENSMUSG00000044456', u'ENSMUSG00000058099', u'ENSMUSG00000041417', u'ENSMUSG00000032562', u'ENSMUSG00000040229', u'ENSMUSG00000040552', u'ENSMUSG00000042626', u'ENSMUSG00000016028', u'ENSMUSG00000062209', u'ENSMUSG00000033777', u'ENSMUSG00000059883', u'ENSMUSG00000064325', u'ENSMUSG00000038349', u'ENSMUSG00000051212', u'ENSMUSG00000044583', u'ENSMUSG00000036402', u'ENSMUSG00000035697', u'ENSMUSG00000028121', u'ENSMUSG00000024610', u'ENSMUSG00000007613', u'ENSMUSG00000029816', u'ENSMUSG00000020122', u'ENSMUSG00000024998', u'ENSMUSG00000048865', u'ENSMUSG00000033446', u'ENSMUSG00000031385', u'ENSMUSG00000021756', u'ENSMUSG00000025795', u'ENSMUSG00000052142', u'ENSMUSG00000053965', u'ENSMUSG00000039904', u'ENSMUSG00000020919', u'ENSMUSG00000004558', u'ENSMUSG00000053646', u'ENSMUSG00000033278', u'ENSMUSG00000024620', u'ENSMUSG00000031785', u'ENSMUSG00000030494', u'ENSMUSG00000000149', u'ENSMUSG00000059810', u'ENSMUSG00000042129', u'ENSMUSG00000022297', u'ENSMUSG00000030536', u'ENSMUSG00000027339', u'ENSMUSG00000004633', u'ENSMUSG00000005125', u'ENSMUSG00000062312', u'ENSMUSG00000050953', u'ENSMUSG00000022122', u'ENSMUSG00000069170', u'ENSMUSG00000039167', u'ENSMUSG00000029778', u'ENSMUSG00000026678', u'ENSMUSG00000021366', u'ENSMUSG00000008734', u'ENSMUSG00000045382', u'ENSMUSG00000057672', u'ENSMUSG00000027765', u'ENSMUSG00000004730', u'ENSMUSG00000048376', u'ENSMUSG00000036949', u'ENSMUSG00000039005', u'ENSMUSG00000045092', u'ENSMUSG00000021709', u'ENSMUSG00000028214', u'ENSMUSG00000047875', u'ENSMUSG00000031216', u'ENSMUSG00000031451', u'ENSMUSG00000025584', u'ENSMUSG00000004451', u'ENSMUSG00000074794', u'ENSMUSG00000004043', u'ENSMUSG00000044827', u'ENSMUSG00000028163', u'ENSMUSG00000052336', u'ENSMUSG00000026173', u'ENSMUSG00000018819']), NS='BP', pop_items=set([u'ENSMUSG00000053199', u'ENSMUSG00000029513', u'ENSMUSG00000029512', u'ENSMUSG00000028184', u'ENSMUSG00000047904', u'ENSMUSG00000003974', u'ENSMUSG00000020196', u'ENSMUSG00000042190', u'ENSMUSG00000056679', u'ENSMUSG00000050558', u'ENSMUSG00000038894', u'ENSMUSG00000045005', u'ENSMUSG00000027995', u'ENSMUSG00000038390', u'ENSMUSG00000052229', u'ENSMUSG00000005057', u'ENSMUSG00000027669', u'ENSMUSG00000035133', u'ENSMUSG00000013033', u'ENSMUSG00000062312', u'ENSMUSG00000026167', u'ENSMUSG00000038587', u'ENSMUSG00000031906', u'ENSMUSG00000030595', u'ENSMUSG00000023886', u'ENSMUSG00000020611', u'ENSMUSG00000055471', u'ENSMUSG00000048779', u'ENSMUSG00000022391', u'ENSMUSG00000049892', u'ENSMUSG00000063506', u'ENSMUSG00000021408', u'ENSMUSG00000040495', u'ENSMUSG00000031887', u'ENSMUSG00000004677', u'ENSMUSG00000042228', u'ENSMUSG00000002496', u'ENSMUSG00000052821', u'ENSMUSG00000042429', u'ENSMUSG00000040407', u'ENSMUSG00000032413', u'ENSMUSG00000026424', u'ENSMUSG00000026425', u'ENSMUSG00000028634', u'ENSMUSG00000026942', u'ENSMUSG00000018209', u'ENSMUSG00000044667', u'ENSMUSG00000058715', u'ENSMUSG00000056529', u'ENSMUSG00000043895', u'ENSMUSG00000033389', u'ENSMUSG00000044288', u'ENSMUSG00000021886', u'ENSMUSG00000019828', u'ENSMUSG00000032562', u'ENSMUSG00000001173', u'ENSMUSG00000047123', u'ENSMUSG00000070366', u'ENSMUSG00000021136', u'ENSMUSG00000009681', u'ENSMUSG00000022122', u'ENSMUSG00000035268', u'ENSMUSG00000038349', u'ENSMUSG00000024122', u'ENSMUSG00000044067', u'ENSMUSG00000036402', u'ENSMUSG00000024639', u'ENSMUSG00000028656', u'ENSMUSG00000028894', u'ENSMUSG00000036246', u'ENSMUSG00000024610', u'ENSMUSG00000036362', u'ENSMUSG00000055980', u'ENSMUSG00000007613', u'ENSMUSG00000036856', u'ENSMUSG00000027247', u'ENSMUSG00000035615', u'ENSMUSG00000037148', u'ENSMUSG00000024998', u'ENSMUSG00000033446', u'ENSMUSG00000039106', u'ENSMUSG00000020716', u'ENSMUSG00000061393', u'ENSMUSG00000055723', u'ENSMUSG00000024830', u'ENSMUSG00000025154', u'ENSMUSG00000046793', u'ENSMUSG00000027584', u'ENSMUSG00000020919', u'ENSMUSG00000036564', u'ENSMUSG00000000538', u'ENSMUSG00000045613', u'ENSMUSG00000000532', u'ENSMUSG00000045967', u'ENSMUSG00000000530', u'ENSMUSG00000000531', u'ENSMUSG00000046093', u'ENSMUSG00000030494', u'ENSMUSG00000034997', u'ENSMUSG00000027335', u'ENSMUSG00000029778', u'ENSMUSG00000028978', u'ENSMUSG00000027339', u'ENSMUSG00000018634', u'ENSMUSG00000048216', u'ENSMUSG00000049295', u'ENSMUSG00000030084', u'ENSMUSG00000021721', u'ENSMUSG00000063358', u'ENSMUSG00000041907', u'ENSMUSG00000030536', u'ENSMUSG00000044562', u'ENSMUSG00000004633', u'ENSMUSG00000031543', u'ENSMUSG00000000441', u'ENSMUSG00000005125', u'ENSMUSG00000031932', u'ENSMUSG00000040836', u'ENSMUSG00000026113', u'ENSMUSG00000045867', u'ENSMUSG00000028080', u'ENSMUSG00000050953', u'ENSMUSG00000031834', u'ENSMUSG00000011171', u'ENSMUSG00000025876', u'ENSMUSG00000046961', u'ENSMUSG00000021366', u'ENSMUSG00000045382', u'ENSMUSG00000052920', u'ENSMUSG00000015501', u'ENSMUSG00000023755', u'ENSMUSG00000031616', u'ENSMUSG00000068696', u'ENSMUSG00000039087', u'ENSMUSG00000023055', u'ENSMUSG00000049532', u'ENSMUSG00000033597', u'ENSMUSG00000032528', u'ENSMUSG00000003228', u'ENSMUSG00000027577', u'ENSMUSG00000048078', u'ENSMUSG00000031111', u'ENSMUSG00000045318', u'ENSMUSG00000024789', u'ENSMUSG00000025584', u'ENSMUSG00000024787', u'ENSMUSG00000044149', u'ENSMUSG00000040061', u'ENSMUSG00000033342', u'ENSMUSG00000049744', u'ENSMUSG00000022580', u'ENSMUSG00000050132', u'ENSMUSG00000020099', u'ENSMUSG00000042594', u'ENSMUSG00000045502', u'ENSMUSG00000048251', u'ENSMUSG00000048865', u'ENSMUSG00000021669', u'ENSMUSG00000024974', u'ENSMUSG00000028108', u'ENSMUSG00000025358', u'ENSMUSG00000023800', u'ENSMUSG00000030766', u'ENSMUSG00000001761', u'ENSMUSG00000001768', u'ENSMUSG00000037523', u'ENSMUSG00000028583', u'ENSMUSG00000021109', u'ENSMUSG00000050783', u'ENSMUSG00000052539', u'ENSMUSG00000060477', u'ENSMUSG00000020591', u'ENSMUSG00000039031', u'ENSMUSG00000032714', u'ENSMUSG00000032492', u'ENSMUSG00000034930', u'ENSMUSG00000049929', u'ENSMUSG00000061950', u'ENSMUSG00000031570', u'ENSMUSG00000000567', u'ENSMUSG00000035283', u'ENSMUSG00000026786', u'ENSMUSG00000008859', u'ENSMUSG00000035431', u'ENSMUSG00000040563', u'ENSMUSG00000050199', u'ENSMUSG00000023473', u'ENSMUSG00000002413', u'ENSMUSG00000002147', u'ENSMUSG00000041468', u'ENSMUSG00000040016', u'ENSMUSG00000062232', u'ENSMUSG00000031486', u'ENSMUSG00000027950', u'ENSMUSG00000030272', u'ENSMUSG00000021478', u'ENSMUSG00000059173', u'ENSMUSG00000068798', u'ENSMUSG00000051043', u'ENSMUSG00000031714', u'ENSMUSG00000044456', u'ENSMUSG00000041417', u'ENSMUSG00000023015', u'ENSMUSG00000040146', u'ENSMUSG00000019907', u'ENSMUSG00000038760', u'ENSMUSG00000018593', u'ENSMUSG00000026430', u'ENSMUSG00000040029', u'ENSMUSG00000021772', u'ENSMUSG00000031392', u'ENSMUSG00000031398', u'ENSMUSG00000042804', u'ENSMUSG00000070939', u'ENSMUSG00000051212', u'ENSMUSG00000044674', u'ENSMUSG00000022637', u'ENSMUSG00000029146', u'ENSMUSG00000019889', u'ENSMUSG00000032470', u'ENSMUSG00000053164', u'ENSMUSG00000026322', u'ENSMUSG00000053004', u'ENSMUSG00000024182', u'ENSMUSG00000024451', u'ENSMUSG00000029816', u'ENSMUSG00000037872', u'ENSMUSG00000079227', u'ENSMUSG00000032766', u'ENSMUSG00000010660', u'ENSMUSG00000025795', u'ENSMUSG00000052142', u'ENSMUSG00000029713', u'ENSMUSG00000028782', u'ENSMUSG00000010067', u'ENSMUSG00000057614', u'ENSMUSG00000015396', u'ENSMUSG00000062190', u'ENSMUSG00000057722', u'ENSMUSG00000021549', u'ENSMUSG00000047259', u'ENSMUSG00000033278', u'ENSMUSG00000024620', u'ENSMUSG00000024235', u'ENSMUSG00000025225', u'ENSMUSG00000001729', u'ENSMUSG00000050663', u'ENSMUSG00000034209', u'ENSMUSG00000076432', u'ENSMUSG00000059588', u'ENSMUSG00000029765', u'ENSMUSG00000033450', u'ENSMUSG00000036501', u'ENSMUSG00000033697', u'ENSMUSG00000067629', u'ENSMUSG00000059456', u'ENSMUSG00000027223', u'ENSMUSG00000024524', u'ENSMUSG00000034471', u'ENSMUSG00000034472', u'ENSMUSG00000004043', u'ENSMUSG00000004040', u'ENSMUSG00000023192', u'ENSMUSG00000020176', u'ENSMUSG00000008734', u'ENSMUSG00000062585', u'ENSMUSG00000016664', u'ENSMUSG00000056755', u'ENSMUSG00000073557', u'ENSMUSG00000028284', u'ENSMUSG00000050534', u'ENSMUSG00000027765', u'ENSMUSG00000041354', u'ENSMUSG00000004730', u'ENSMUSG00000026069', u'ENSMUSG00000031842', u'ENSMUSG00000026104', u'ENSMUSG00000039005', u'ENSMUSG00000045092', u'ENSMUSG00000030222', u'ENSMUSG00000069601', u'ENSMUSG00000028214', u'ENSMUSG00000024387', u'ENSMUSG00000021277', u'ENSMUSG00000030047', u'ENSMUSG00000030341', u'ENSMUSG00000031216', u'ENSMUSG00000031214', u'ENSMUSG00000021373', u'ENSMUSG00000068036', u'ENSMUSG00000031748', u'ENSMUSG00000004451', u'ENSMUSG00000029064', u'ENSMUSG00000056055', u'ENSMUSG00000049907', u'ENSMUSG00000026566', u'ENSMUSG00000044827', u'ENSMUSG00000078624', u'ENSMUSG00000027297', u'ENSMUSG00000021936', u'ENSMUSG00000043004', u'ENSMUSG00000007989', u'ENSMUSG00000045322', u'ENSMUSG00000049148', u'ENSMUSG00000024798', u'ENSMUSG00000020516', u'ENSMUSG00000026888', u'ENSMUSG00000074785', u'ENSMUSG00000026883', u'ENSMUSG00000029101', u'ENSMUSG00000024462', u'ENSMUSG00000002885', u'ENSMUSG00000036606', u'ENSMUSG00000025507', u'ENSMUSG00000039358', u'ENSMUSG00000043670', u'ENSMUSG00000041075', u'ENSMUSG00000050029', u'ENSMUSG00000052298', u'ENSMUSG00000021699', u'ENSMUSG00000041380', u'ENSMUSG00000032826', u'ENSMUSG00000034009', u'ENSMUSG00000004952', u'ENSMUSG00000058396', u'ENSMUSG00000015355', u'ENSMUSG00000028136', u'ENSMUSG00000024960', u'ENSMUSG00000059013', u'ENSMUSG00000022489', u'ENSMUSG00000041225', u'ENSMUSG00000021057', u'ENSMUSG00000021051', u'ENSMUSG00000034330', u'ENSMUSG00000016028', u'ENSMUSG00000052056', u'ENSMUSG00000004591', u'ENSMUSG00000036437', u'ENSMUSG00000019699', u'ENSMUSG00000029430', u'ENSMUSG00000037999', u'ENSMUSG00000037992', u'ENSMUSG00000025139', u'ENSMUSG00000021466', u'ENSMUSG00000028004', u'ENSMUSG00000028005', u'ENSMUSG00000031561', u'ENSMUSG00000052681', u'ENSMUSG00000049807', u'ENSMUSG00000037014', u'ENSMUSG00000028522', u'ENSMUSG00000037010', u'ENSMUSG00000025739', u'ENSMUSG00000035835', u'ENSMUSG00000000001', u'ENSMUSG00000045730', u'ENSMUSG00000040653', u'ENSMUSG00000040229', u'ENSMUSG00000018500', u'ENSMUSG00000032641', u'ENSMUSG00000040552', u'ENSMUSG00000018909', u'ENSMUSG00000051177', u'ENSMUSG00000062209', u'ENSMUSG00000046722', u'ENSMUSG00000030265', u'ENSMUSG00000024109', u'ENSMUSG00000064325', u'ENSMUSG00000063446', u'ENSMUSG00000044583', u'ENSMUSG00000042249', u'ENSMUSG00000004798', u'ENSMUSG00000028172', u'ENSMUSG00000030545', u'ENSMUSG00000052372', u'ENSMUSG00000032360', u'ENSMUSG00000040133', u'ENSMUSG00000000149', u'ENSMUSG00000040033', u'ENSMUSG00000002489', u'ENSMUSG00000020122', u'ENSMUSG00000020121', u'ENSMUSG00000022148', u'ENSMUSG00000016128', u'ENSMUSG00000063234', u'ENSMUSG00000034165', u'ENSMUSG00000031385', u'ENSMUSG00000030629', u'ENSMUSG00000000732', u'ENSMUSG00000021303', u'ENSMUSG00000029090', u'ENSMUSG00000031639', u'ENSMUSG00000021994', u'ENSMUSG00000019235', u'ENSMUSG00000002910', u'ENSMUSG00000039904', u'ENSMUSG00000032508', u'ENSMUSG00000004558', u'ENSMUSG00000053113', u'ENSMUSG00000047415', u'ENSMUSG00000049791', u'ENSMUSG00000037846', u'ENSMUSG00000022329', u'ENSMUSG00000063065', u'ENSMUSG00000056222', u'ENSMUSG00000021067', u'ENSMUSG00000038205', u'ENSMUSG00000020541', u'ENSMUSG00000058297', u'ENSMUSG00000043398', u'ENSMUSG00000050288', u'ENSMUSG00000052151', u'ENSMUSG00000022514', u'ENSMUSG00000074886', u'ENSMUSG00000089872', u'ENSMUSG00000022799', u'ENSMUSG00000033569', u'ENSMUSG00000025499', u'ENSMUSG00000038607', u'ENSMUSG00000037605', u'ENSMUSG00000006728', u'ENSMUSG00000049112', u'ENSMUSG00000036834', u'ENSMUSG00000069170', u'ENSMUSG00000032911', u'ENSMUSG00000039167', u'ENSMUSG00000044014', u'ENSMUSG00000058230', u'ENSMUSG00000049336', u'ENSMUSG00000016933', u'ENSMUSG00000026678', u'ENSMUSG00000029470', u'ENSMUSG00000029576', u'ENSMUSG00000041696', u'ENSMUSG00000034781', u'ENSMUSG00000023868', u'ENSMUSG00000050730', u'ENSMUSG00000050600', u'ENSMUSG00000052087', u'ENSMUSG00000020937', u'ENSMUSG00000041624', u'ENSMUSG00000000127', u'ENSMUSG00000024883', u'ENSMUSG00000030257', u'ENSMUSG00000048376', u'ENSMUSG00000056486', u'ENSMUSG00000041741', u'ENSMUSG00000041219', u'ENSMUSG00000036949', u'ENSMUSG00000021709', u'ENSMUSG00000017386', u'ENSMUSG00000026482', u'ENSMUSG00000028195', u'ENSMUSG00000049583', u'ENSMUSG00000028057', u'ENSMUSG00000027531', u'ENSMUSG00000016496', u'ENSMUSG00000031451', u'ENSMUSG00000031450', u'ENSMUSG00000031453', u'ENSMUSG00000050541', u'ENSMUSG00000026102', u'ENSMUSG00000027852', u'ENSMUSG00000031523', u'ENSMUSG00000041444', u'ENSMUSG00000023353', u'ENSMUSG00000052336', u'ENSMUSG00000026173', u'ENSMUSG00000016150', u'ENSMUSG00000026072', u'ENSMUSG00000032041', u'ENSMUSG00000045087', u'ENSMUSG00000021552', u'ENSMUSG00000087141', u'ENSMUSG00000021559', u'ENSMUSG00000063239', u'ENSMUSG00000000861', u'ENSMUSG00000029055', u'ENSMUSG00000044337', u'ENSMUSG00000017631', u'ENSMUSG00000036882', u'ENSMUSG00000019990', u'ENSMUSG00000029053', u'ENSMUSG00000031355', u'ENSMUSG00000004347', u'ENSMUSG00000040009', u'ENSMUSG00000047344', u'ENSMUSG00000044933', u'ENSMUSG00000026000', u'ENSMUSG00000022176', u'ENSMUSG00000040003', u'ENSMUSG00000018166', u'ENSMUSG00000066232', u'ENSMUSG00000049511', u'ENSMUSG00000022074', u'ENSMUSG00000004815', u'ENSMUSG00000024176', u'ENSMUSG00000033256', u'ENSMUSG00000024287', u'ENSMUSG00000000766', u'ENSMUSG00000038128', u'ENSMUSG00000074794', u'ENSMUSG00000039831', u'ENSMUSG00000029602', u'ENSMUSG00000057315', u'ENSMUSG00000032259', u'ENSMUSG00000061718', u'ENSMUSG00000075270', u'ENSMUSG00000054162', u'ENSMUSG00000063626', u'ENSMUSG00000024778', u'ENSMUSG00000038811', u'ENSMUSG00000026821', u'ENSMUSG00000032812', u'ENSMUSG00000021684', u'ENSMUSG00000015709', u'ENSMUSG00000069094', u'ENSMUSG00000047842', u'ENSMUSG00000060216', u'ENSMUSG00000030671', u'ENSMUSG00000029309', u'ENSMUSG00000058099', u'ENSMUSG00000050164', u'ENSMUSG00000022490', u'ENSMUSG00000034226', u'ENSMUSG00000024211', u'ENSMUSG00000027523', u'ENSMUSG00000036904', u'ENSMUSG00000042626', u'ENSMUSG00000059921', u'ENSMUSG00000032773', u'ENSMUSG00000033777', u'ENSMUSG00000059883', u'ENSMUSG00000039059', u'ENSMUSG00000023915', u'ENSMUSG00000046159', u'ENSMUSG00000035697', u'ENSMUSG00000028121', u'ENSMUSG00000091735', u'ENSMUSG00000028945', u'ENSMUSG00000026626', u'ENSMUSG00000027634', u'ENSMUSG00000034987', u'ENSMUSG00000024858', u'ENSMUSG00000030898', u'ENSMUSG00000034792', u'ENSMUSG00000004768', u'ENSMUSG00000039116', u'ENSMUSG00000032586', u'ENSMUSG00000030093', u'ENSMUSG00000021756', u'ENSMUSG00000033910', u'ENSMUSG00000059203', u'ENSMUSG00000021759', u'ENSMUSG00000068740', u'ENSMUSG00000038069', u'ENSMUSG00000048027', u'ENSMUSG00000050511', u'ENSMUSG00000052783', u'ENSMUSG00000060450', u'ENSMUSG00000030525', u'ENSMUSG00000030259', u'ENSMUSG00000053965', u'ENSMUSG00000035172', u'ENSMUSG00000051615', u'ENSMUSG00000071658', u'ENSMUSG00000040125', u'ENSMUSG00000036894', u'ENSMUSG00000053646', u'ENSMUSG00000053647', u'ENSMUSG00000031785', u'ENSMUSG00000035773', u'ENSMUSG00000045875', u'ENSMUSG00000059810', u'ENSMUSG00000032177', u'ENSMUSG00000038668', u'ENSMUSG00000017837', u'ENSMUSG00000022297', u'ENSMUSG00000067586', u'ENSMUSG00000032192', u'ENSMUSG00000057455', u'ENSMUSG00000042129', u'ENSMUSG00000001127', u'ENSMUSG00000060735', u'ENSMUSG00000049649', u'ENSMUSG00000048965', u'ENSMUSG00000030733', u'ENSMUSG00000041119', u'ENSMUSG00000027568', u'ENSMUSG00000074939', u'ENSMUSG00000026867', u'ENSMUSG00000039809', u'ENSMUSG00000043999', u'ENSMUSG00000057672', u'ENSMUSG00000029641', u'ENSMUSG00000021448', u'ENSMUSG00000024096', u'ENSMUSG00000036357', u'ENSMUSG00000017843', u'ENSMUSG00000036353', u'ENSMUSG00000049044', u'ENSMUSG00000058881', u'ENSMUSG00000043659', u'ENSMUSG00000048240', u'ENSMUSG00000040276', u'ENSMUSG00000021676', u'ENSMUSG00000026640', u'ENSMUSG00000047875', u'ENSMUSG00000039154', u'ENSMUSG00000046280', u'ENSMUSG00000030123', u'ENSMUSG00000020684', u'ENSMUSG00000009828', u'ENSMUSG00000034255', u'ENSMUSG00000036452', u'ENSMUSG00000038910', u'ENSMUSG00000039585', u'ENSMUSG00000020392', u'ENSMUSG00000036591', u'ENSMUSG00000028163', u'ENSMUSG00000027164', u'ENSMUSG00000068037', u'ENSMUSG00000018819', u'ENSMUSG00000040372']), pop_n=13836, p_sm_bonferroni=8.720091938205414e-06, is_obsolete=False, GO='GO:0007165', name='signal transduction', pop_count=624, alt_ids=['GO:0023033'], level=2, depth=4, enrichment='e', Cluster='Late Increase', geneid_set=set([u'ENSMUSG00000048865', u'ENSMUSG00000042594', u'ENSMUSG00000031385', u'ENSMUSG00000021756', u'ENSMUSG00000045087', u'ENSMUSG00000024620', u'ENSMUSG00000000732', u'ENSMUSG00000015355', u'ENSMUSG00000042190', u'ENSMUSG00000053965', u'ENSMUSG00000018500', u'ENSMUSG00000039904', u'ENSMUSG00000024960', u'ENSMUSG00000001761', u'ENSMUSG00000029101', u'ENSMUSG00000004558', u'ENSMUSG00000004043', u'ENSMUSG00000016128', u'ENSMUSG00000033278', u'ENSMUSG00000001768', u'ENSMUSG00000004591', u'ENSMUSG00000021709', u'ENSMUSG00000036606', u'ENSMUSG00000031785', u'ENSMUSG00000030494', u'ENSMUSG00000037523', u'ENSMUSG00000028583', u'ENSMUSG00000059810', u'ENSMUSG00000042129', u'ENSMUSG00000020611', u'ENSMUSG00000052142', u'ENSMUSG00000060477', u'ENSMUSG00000020591', u'ENSMUSG00000039031', u'ENSMUSG00000022297', u'ENSMUSG00000000149', u'ENSMUSG00000032714', u'ENSMUSG00000063506', u'ENSMUSG00000034930', u'ENSMUSG00000030536', u'ENSMUSG00000022799', u'ENSMUSG00000059013', u'ENSMUSG00000027339', u'ENSMUSG00000004633', u'ENSMUSG00000036949', u'ENSMUSG00000000567', u'ENSMUSG00000005125', u'ENSMUSG00000062312', u'ENSMUSG00000050953', u'ENSMUSG00000061718', u'ENSMUSG00000026424', u'ENSMUSG00000022122', u'ENSMUSG00000039005', u'ENSMUSG00000052056', u'ENSMUSG00000002147', u'ENSMUSG00000069170', u'ENSMUSG00000032766', u'ENSMUSG00000039167', u'ENSMUSG00000037999', u'ENSMUSG00000062209', u'ENSMUSG00000031486', u'ENSMUSG00000029778', u'ENSMUSG00000030272', u'ENSMUSG00000026678', u'ENSMUSG00000021366', u'ENSMUSG00000025795', u'ENSMUSG00000008734', u'ENSMUSG00000045382', u'ENSMUSG00000031714', u'ENSMUSG00000056529', u'ENSMUSG00000029309', u'ENSMUSG00000044456', u'ENSMUSG00000058099', u'ENSMUSG00000041417', u'ENSMUSG00000032562', u'ENSMUSG00000052336', u'ENSMUSG00000020919', u'ENSMUSG00000004730', u'ENSMUSG00000048376', u'ENSMUSG00000040229', u'ENSMUSG00000040552', u'ENSMUSG00000057672', u'ENSMUSG00000042626', u'ENSMUSG00000016028', u'ENSMUSG00000045092', u'ENSMUSG00000021136', u'ENSMUSG00000047875', u'ENSMUSG00000028214', u'ENSMUSG00000027765', u'ENSMUSG00000033777', u'ENSMUSG00000059883', u'ENSMUSG00000064325', u'ENSMUSG00000038349', u'ENSMUSG00000031216', u'ENSMUSG00000051212', u'ENSMUSG00000044583', u'ENSMUSG00000031451', u'ENSMUSG00000036402', u'ENSMUSG00000025584', u'ENSMUSG00000033446', u'ENSMUSG00000004451', u'ENSMUSG00000035697', u'ENSMUSG00000028121', u'ENSMUSG00000074794', u'ENSMUSG00000024610', u'ENSMUSG00000044827', u'ENSMUSG00000028163', u'ENSMUSG00000018819', u'ENSMUSG00000007613', u'ENSMUSG00000026173', u'ENSMUSG00000029816', u'ENSMUSG00000020122', u'ENSMUSG00000053646', u'ENSMUSG00000024998']), symbols=u'Adcyap1r1 Adgra2 Adgre1 Adgrg1 Adgrl4 Adgrv1 Adora2b Arap2 Arhgap18 Arhgap22 Arhgap30 Arhgap31 Arrdc3 Bcar3 C3ar1 Camk1 Cd48 Cd74 Celsr1 Chn2 Cmklr1 Cx3cr1 Cxcr4 Ednrb Egfr Erbb2 Erbb4 Erbin F2r Fzd6 Gab1 Gas6 Gem Gja1 Gna12 Gna13 Gnai2 Gng11 Gng12 Gpnmb Gpr157 Gpr183 Gpr34 Gpr37 Gpr37l1 Gprc5b Hhip Hivep1 Hmha1 Icosl Il6st Iqgap1 Irak2 Irak4 Lpar6 Lsp1 Mavs Ndrg1 Ndrg2 Nfam1 Nfkb1 Ntsr2 P2ry1 Pde5a Pde8a Pdgfrb Pdpn Pik3r1 Pkn1 Pkn2 Plcb3 Plcd4 Plce1 Plcl1 Plxnb1 Plxnb2 Plxnb3 Ppp1r1b Ptafr Ptprm Ralb Rasal3 Rassf2 Rassf3 Rassf4 Rgs12 Rgs3 Rgs5 Rhpn2 Rin2 Rin3 Rtkn S1pr1 S1pr5 Sh2b3 Sh2d3c Shc1 Slc39a12 Smo Smoc1 Sox9 Sparcl1 Stard13 Stard8 Stat5a Stat5b Stat6 Syde1 Tgfbr1 Tlr1 Tlr13 Tlr4 Tlr7 Zfp217', symbol_set=set([u'Slc39a12', u'Gab1', u'Nfkb1', u'Iqgap1', u'Pde5a', u'Lsp1', u'Rin3', u'Rin2', u'Rgs5', u'Stard8', u'Rgs3', u'Hmha1', u'Plce1', u'Gnai2', u'Arap2', u'Cx3cr1', u'F2r', 'Adgrl4', u'Sox9', u'Cxcr4', u'Zfp217', u'Erbb2', u'Plcb3', u'Fzd6', u'Erbb4', u'C3ar1', u'Egfr', u'Rtkn', u'Stat5b', u'Stat5a', u'Ptprm', u'Gas6', u'Pkn1', u'Pkn2', 'Adgre1', u'Gpnmb', u'Smo', u'Tlr13', u'Sh2b3', u'Irak2', u'Irak4', u'Gprc5b', u'Ppp1r1b', u'Gpr157', u'Gna12', u'Gna13', u'Ndrg1', u'Ndrg2', u'Hivep1', u'Stat6', u'Shc1', u'Adcyap1r1', u'Rgs12', 'Erbin', u'Gng11', u'Gng12', u'Syde1', u'Plcd4', u'Tlr1', u'Tlr7', u'Tlr4', u'Smoc1', u'Adora2b', u'Rhpn2', u'Pdpn', u'Plcl1', u'Arhgap30', u'Arhgap31', u'Ptafr', 'Adgrv1', u'Lpar6', u'Ralb', u'Cd74', u'Gja1', u'Ntsr2', u'Gem', u'Celsr1', u'Arhgap22', u'Pik3r1', u'P2ry1', u'Pdgfrb', u'S1pr1', u'Gpr183', u'S1pr5', 'Adgrg1', u'Cmklr1', u'Nfam1', u'Arrdc3', u'Rasal3', u'Icosl', u'Arhgap18', u'Plxnb2', u'Plxnb3', u'Mavs', u'Gpr37l1', u'Tgfbr1', u'Stard13', u'Camk1', u'Rassf3', u'Rassf2', u'Rassf4', u'Plxnb1', u'Ednrb', u'Gpr34', u'Gpr37', u'Hhip', u'Cd48', u'Chn2', u'Sparcl1', u'Il6st', 'Adgra2', u'Sh2d3c', u'Pde8a', u'Bcar3']), geneids='ENSMUSG00000042594 ENSMUSG00000045087 ENSMUSG00000015355 ENSMUSG00000042190 ENSMUSG00000018500 ENSMUSG00000022799 ENSMUSG00000001761 ENSMUSG00000029101 ENSMUSG00000016128 ENSMUSG00000001768 ENSMUSG00000004591 ENSMUSG00000036606 ENSMUSG00000037523 ENSMUSG00000028583 ENSMUSG00000020611 ENSMUSG00000052142 ENSMUSG00000060477 ENSMUSG00000020591 ENSMUSG00000039031 ENSMUSG00000032714 ENSMUSG00000063506 ENSMUSG00000034930 ENSMUSG00000024960 ENSMUSG00000059013 ENSMUSG00000000567 ENSMUSG00000061718 ENSMUSG00000026424 ENSMUSG00000052056 ENSMUSG00000002147 ENSMUSG00000032766 ENSMUSG00000037999 ENSMUSG00000062209 ENSMUSG00000031486 ENSMUSG00000030272 ENSMUSG00000031714 ENSMUSG00000056529 ENSMUSG00000029309 ENSMUSG00000044456 ENSMUSG00000058099 ENSMUSG00000041417 ENSMUSG00000032562 ENSMUSG00000040229 ENSMUSG00000040552 ENSMUSG00000042626 ENSMUSG00000016028 ENSMUSG00000021136 ENSMUSG00000033777 ENSMUSG00000059883 ENSMUSG00000064325 ENSMUSG00000038349 ENSMUSG00000051212 ENSMUSG00000044583 ENSMUSG00000036402 ENSMUSG00000035697 ENSMUSG00000028121 ENSMUSG00000024610 ENSMUSG00000007613 ENSMUSG00000029816 ENSMUSG00000020122 ENSMUSG00000024998 ENSMUSG00000048865 ENSMUSG00000033446 ENSMUSG00000031385 ENSMUSG00000021756 ENSMUSG00000025795 ENSMUSG00000000732 ENSMUSG00000053965 ENSMUSG00000039904 ENSMUSG00000020919 ENSMUSG00000004558 ENSMUSG00000053646 ENSMUSG00000033278 ENSMUSG00000024620 ENSMUSG00000031785 ENSMUSG00000030494 ENSMUSG00000000149 ENSMUSG00000059810 ENSMUSG00000042129 ENSMUSG00000022297 ENSMUSG00000030536 ENSMUSG00000027339 ENSMUSG00000004633 ENSMUSG00000005125 ENSMUSG00000062312 ENSMUSG00000050953 ENSMUSG00000022122 ENSMUSG00000069170 ENSMUSG00000039167 ENSMUSG00000029778 ENSMUSG00000026678 ENSMUSG00000021366 ENSMUSG00000008734 ENSMUSG00000045382 ENSMUSG00000057672 ENSMUSG00000027765 ENSMUSG00000004730 ENSMUSG00000048376 ENSMUSG00000036949 ENSMUSG00000039005 ENSMUSG00000045092 ENSMUSG00000021709 ENSMUSG00000028214 ENSMUSG00000047875 ENSMUSG00000031216 ENSMUSG00000031451 ENSMUSG00000025584 ENSMUSG00000004451 ENSMUSG00000074794 ENSMUSG00000004043 ENSMUSG00000044827 ENSMUSG00000028163 ENSMUSG00000052336 ENSMUSG00000026173 ENSMUSG00000018819', format_txt=1, hdr_idx=1, is_hdrgo=True, is_usrgo=True, hdr1usr01='**', dcnt=724, D1='AB', GO_name='signal transduction'),
    Nt(p_uncorrected=2.2053392296695387e-09, study_count=34, study_n=1397, namespace='biological_process', p_fdr_bh=1.2851190257201223e-06, study_items=set([u'ENSMUSG00000039167', u'ENSMUSG00000059498', u'ENSMUSG00000030798', u'ENSMUSG00000031486', u'ENSMUSG00000029778', u'ENSMUSG00000030352', u'ENSMUSG00000001761', u'ENSMUSG00000029669', u'ENSMUSG00000027215', u'ENSMUSG00000040747', u'ENSMUSG00000004730', u'ENSMUSG00000031785', u'ENSMUSG00000056492', u'ENSMUSG00000026656', u'ENSMUSG00000006736', u'ENSMUSG00000016028', u'ENSMUSG00000022297', u'ENSMUSG00000030124', u'ENSMUSG00000047875', u'ENSMUSG00000030342', u'ENSMUSG00000020122', u'ENSMUSG00000030577', u'ENSMUSG00000021457', u'ENSMUSG00000037031', u'ENSMUSG00000039646', u'ENSMUSG00000032796', u'ENSMUSG00000027858', u'ENSMUSG00000062312', u'ENSMUSG00000038855', u'ENSMUSG00000025511', u'ENSMUSG00000025510', u'ENSMUSG00000037706', u'ENSMUSG00000028599', u'ENSMUSG00000069170']), NS='BP', pop_items=set([u'ENSMUSG00000059498', u'ENSMUSG00000067377', u'ENSMUSG00000028184', u'ENSMUSG00000026656', u'ENSMUSG00000030352', u'ENSMUSG00000036437', u'ENSMUSG00000045005', u'ENSMUSG00000029053', u'ENSMUSG00000001761', u'ENSMUSG00000029669', u'ENSMUSG00000001763', u'ENSMUSG00000002885', u'ENSMUSG00000023078', u'ENSMUSG00000013033', u'ENSMUSG00000041075', u'ENSMUSG00000019843', u'ENSMUSG00000079465', u'ENSMUSG00000027944', u'ENSMUSG00000032492', u'ENSMUSG00000039936', u'ENSMUSG00000030577', u'ENSMUSG00000038855', u'ENSMUSG00000058254', u'ENSMUSG00000052821', u'ENSMUSG00000032796', u'ENSMUSG00000025511', u'ENSMUSG00000025510', u'ENSMUSG00000023473', u'ENSMUSG00000050558', u'ENSMUSG00000031486', u'ENSMUSG00000028004', u'ENSMUSG00000058715', u'ENSMUSG00000034342', u'ENSMUSG00000050164', u'ENSMUSG00000004366', u'ENSMUSG00000034730', u'ENSMUSG00000056492', u'ENSMUSG00000032641', u'ENSMUSG00000036904', u'ENSMUSG00000027524', u'ENSMUSG00000016028', u'ENSMUSG00000031391', u'ENSMUSG00000028790', u'ENSMUSG00000019647', u'ENSMUSG00000044674', u'ENSMUSG00000022637', u'ENSMUSG00000039646', u'ENSMUSG00000033307', u'ENSMUSG00000032577', u'ENSMUSG00000022146', u'ENSMUSG00000037706', u'ENSMUSG00000039116', u'ENSMUSG00000030798', u'ENSMUSG00000027931', u'ENSMUSG00000037824', u'ENSMUSG00000021457', u'ENSMUSG00000029090', u'ENSMUSG00000028782', u'ENSMUSG00000031980', u'ENSMUSG00000028152', u'ENSMUSG00000032508', u'ENSMUSG00000000532', u'ENSMUSG00000031785', u'ENSMUSG00000006736', u'ENSMUSG00000018634', u'ENSMUSG00000022297', u'ENSMUSG00000059588', u'ENSMUSG00000008090', u'ENSMUSG00000030124', u'ENSMUSG00000050288', u'ENSMUSG00000049791', u'ENSMUSG00000029276', u'ENSMUSG00000007989', u'ENSMUSG00000068686', u'ENSMUSG00000033569', u'ENSMUSG00000031932', u'ENSMUSG00000059456', u'ENSMUSG00000026111', u'ENSMUSG00000062312', u'ENSMUSG00000037605', u'ENSMUSG00000039542', u'ENSMUSG00000011171', u'ENSMUSG00000069170', u'ENSMUSG00000039167', u'ENSMUSG00000025875', u'ENSMUSG00000044014', u'ENSMUSG00000029778', u'ENSMUSG00000020577', u'ENSMUSG00000068696', u'ENSMUSG00000027215', u'ENSMUSG00000040747', u'ENSMUSG00000027217', u'ENSMUSG00000004730', u'ENSMUSG00000015947', u'ENSMUSG00000032528', u'ENSMUSG00000006494', u'ENSMUSG00000026640', u'ENSMUSG00000047875', u'ENSMUSG00000030342', u'ENSMUSG00000030341', u'ENSMUSG00000016496', u'ENSMUSG00000068740', u'ENSMUSG00000020122', u'ENSMUSG00000037031', u'ENSMUSG00000047139', u'ENSMUSG00000056962', u'ENSMUSG00000027858', u'ENSMUSG00000025475', u'ENSMUSG00000032324', u'ENSMUSG00000020605', u'ENSMUSG00000032041', u'ENSMUSG00000028599']), pop_n=13836, p_sm_bonferroni=3.341309466872318e-05, is_obsolete=False, GO='GO:0007166', name='cell surface receptor signaling pathway', pop_count=112, alt_ids=[], level=3, depth=5, enrichment='e', Cluster='Late Increase', geneid_set=set([u'ENSMUSG00000039167', u'ENSMUSG00000059498', u'ENSMUSG00000030798', u'ENSMUSG00000031486', u'ENSMUSG00000029778', u'ENSMUSG00000030352', u'ENSMUSG00000001761', u'ENSMUSG00000029669', u'ENSMUSG00000027215', u'ENSMUSG00000040747', u'ENSMUSG00000004730', u'ENSMUSG00000031785', u'ENSMUSG00000056492', u'ENSMUSG00000026656', u'ENSMUSG00000006736', u'ENSMUSG00000016028', u'ENSMUSG00000022297', u'ENSMUSG00000030124', u'ENSMUSG00000047875', u'ENSMUSG00000030342', u'ENSMUSG00000037706', u'ENSMUSG00000030577', u'ENSMUSG00000021457', u'ENSMUSG00000037031', u'ENSMUSG00000039646', u'ENSMUSG00000032796', u'ENSMUSG00000027858', u'ENSMUSG00000062312', u'ENSMUSG00000038855', u'ENSMUSG00000025511', u'ENSMUSG00000025510', u'ENSMUSG00000020122', u'ENSMUSG00000069170', u'ENSMUSG00000028599']), symbols=u'Adcyap1r1 Adgra2 Adgre1 Adgrf5 Adgrg1 Adgrl4 Adgrv1 Cd151 Cd22 Cd37 Cd53 Cd81 Cd82 Cd9 Celsr1 Egfr Erbb2 Fcgr2b Fcgr3 Fzd6 Gpr157 Itpkb Lag3 Lama1 Smo Syk Tnfrsf1b Tspan12 Tspan15 Tspan2 Tspan31 Tspan4 Tspan9 Vasn', symbol_set=set([u'Tspan15', u'Tspan2', u'Fcgr2b', u'Smo', u'Tspan4', 'Adgrv1', u'Tspan9', u'Cd53', u'Gpr157', u'Syk', u'Tnfrsf1b', u'Cd37', u'Cd151', u'Tspan31', u'Cd9', u'Cd81', 'Adgre1', u'Tspan12', u'Cd82', 'Adgrf5', u'Celsr1', u'Lag3', 'Adgrl4', u'Vasn', u'Adcyap1r1', u'Erbb2', u'Lama1', u'Fzd6', u'Cd22', u'Egfr', 'Adgra2', 'Adgrg1', u'Itpkb', u'Fcgr3']), geneids='ENSMUSG00000039167 ENSMUSG00000059498 ENSMUSG00000030798 ENSMUSG00000031486 ENSMUSG00000029778 ENSMUSG00000021457 ENSMUSG00000001761 ENSMUSG00000029669 ENSMUSG00000027215 ENSMUSG00000040747 ENSMUSG00000004730 ENSMUSG00000031785 ENSMUSG00000056492 ENSMUSG00000026656 ENSMUSG00000006736 ENSMUSG00000016028 ENSMUSG00000022297 ENSMUSG00000030124 ENSMUSG00000047875 ENSMUSG00000030342 ENSMUSG00000037706 ENSMUSG00000030577 ENSMUSG00000030352 ENSMUSG00000037031 ENSMUSG00000039646 ENSMUSG00000032796 ENSMUSG00000027858 ENSMUSG00000062312 ENSMUSG00000038855 ENSMUSG00000025511 ENSMUSG00000025510 ENSMUSG00000020122 ENSMUSG00000069170 ENSMUSG00000028599', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=339, D1='AB', GO_name='cell surface receptor signaling pathway'),
    Nt(p_uncorrected=0.0005569991698150257, study_count=17, study_n=1397, namespace='biological_process', p_fdr_bh=0.042041256248140695, study_items=set([u'ENSMUSG00000062209', u'ENSMUSG00000068335', u'ENSMUSG00000022309', u'ENSMUSG00000026674', u'ENSMUSG00000003534', u'ENSMUSG00000055254', u'ENSMUSG00000029710', u'ENSMUSG00000024620', u'ENSMUSG00000029648', u'ENSMUSG00000021457', u'ENSMUSG00000032537', u'ENSMUSG00000062312', u'ENSMUSG00000028874', u'ENSMUSG00000020122', u'ENSMUSG00000006386', u'ENSMUSG00000020357', u'ENSMUSG00000014932']), NS='BP', pop_items=set([u'ENSMUSG00000020170', u'ENSMUSG00000009376', u'ENSMUSG00000003534', u'ENSMUSG00000027560', u'ENSMUSG00000026674', u'ENSMUSG00000042817', u'ENSMUSG00000030110', u'ENSMUSG00000006445', u'ENSMUSG00000021457', u'ENSMUSG00000028664', u'ENSMUSG00000028289', u'ENSMUSG00000029245', u'ENSMUSG00000029710', u'ENSMUSG00000002699', u'ENSMUSG00000005534', u'ENSMUSG00000031805', u'ENSMUSG00000005672', u'ENSMUSG00000028661', u'ENSMUSG00000005533', u'ENSMUSG00000029231', u'ENSMUSG00000022309', u'ENSMUSG00000029869', u'ENSMUSG00000024620', u'ENSMUSG00000006386', u'ENSMUSG00000018166', u'ENSMUSG00000027316', u'ENSMUSG00000062312', u'ENSMUSG00000032911', u'ENSMUSG00000049107', u'ENSMUSG00000027508', u'ENSMUSG00000004933', u'ENSMUSG00000048482', u'ENSMUSG00000040631', u'ENSMUSG00000032175', u'ENSMUSG00000019843', u'ENSMUSG00000014932', u'ENSMUSG00000026235', u'ENSMUSG00000025089', u'ENSMUSG00000035305', u'ENSMUSG00000062209', u'ENSMUSG00000024621', u'ENSMUSG00000020541', u'ENSMUSG00000029648', u'ENSMUSG00000059146', u'ENSMUSG00000020357', u'ENSMUSG00000032312', u'ENSMUSG00000003283', u'ENSMUSG00000022791', u'ENSMUSG00000005958', u'ENSMUSG00000029217', u'ENSMUSG00000019986', u'ENSMUSG00000042228', u'ENSMUSG00000055254', u'ENSMUSG00000028530', u'ENSMUSG00000068335', u'ENSMUSG00000055540', u'ENSMUSG00000014599', u'ENSMUSG00000022103', u'ENSMUSG00000062960', u'ENSMUSG00000026117', u'ENSMUSG00000028874', u'ENSMUSG00000028876', u'ENSMUSG00000032537', u'ENSMUSG00000027297', u'ENSMUSG00000020312', u'ENSMUSG00000032336', u'ENSMUSG00000020122', u'ENSMUSG00000055471', u'ENSMUSG00000052504', u'ENSMUSG00000053141', u'ENSMUSG00000035109']), pop_n=13836, p_sm_bonferroni=1.0, is_obsolete=False, GO='GO:0007169', name='transmembrane receptor protein tyrosine kinase signaling pathway', pop_count=71, alt_ids=[], level=5, depth=7, enrichment='e', Cluster='Late Increase', geneid_set=set([u'ENSMUSG00000062209', u'ENSMUSG00000026674', u'ENSMUSG00000021457', u'ENSMUSG00000006386', u'ENSMUSG00000029710', u'ENSMUSG00000020357', u'ENSMUSG00000055254', u'ENSMUSG00000062312', u'ENSMUSG00000068335', u'ENSMUSG00000022309', u'ENSMUSG00000024620', u'ENSMUSG00000029648', u'ENSMUSG00000032537', u'ENSMUSG00000028874', u'ENSMUSG00000020122', u'ENSMUSG00000003534', u'ENSMUSG00000014932']), symbols=u'Angpt1 Ddr1 Ddr2 Dok1 Egfr Ephb1 Ephb4 Erbb2 Erbb4 Fgr Flt1 Flt4 Ntrk2 Pdgfrb Syk Tek Yes1', symbol_set=set([u'Erbb2', u'Pdgfrb', u'Tek', u'Erbb4', u'Ephb4', u'Ephb1', u'Ddr2', u'Ddr1', u'Egfr', u'Ntrk2', u'Syk', u'Dok1', u'Fgr', u'Flt4', u'Angpt1', u'Yes1', u'Flt1']), geneids='ENSMUSG00000026674 ENSMUSG00000068335 ENSMUSG00000022309 ENSMUSG00000062209 ENSMUSG00000029648 ENSMUSG00000055254 ENSMUSG00000029710 ENSMUSG00000024620 ENSMUSG00000006386 ENSMUSG00000021457 ENSMUSG00000032537 ENSMUSG00000062312 ENSMUSG00000028874 ENSMUSG00000020122 ENSMUSG00000003534 ENSMUSG00000014932 ENSMUSG00000020357', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=75, D1='AB', GO_name='transmembrane receptor protein tyrosine kinase signaling pathway'),
    Nt(p_uncorrected=0.00032651490339852745, study_count=7, study_n=1397, namespace='biological_process', p_fdr_bh=0.029622917972401734, study_items=set([u'ENSMUSG00000027562', u'ENSMUSG00000032554', u'ENSMUSG00000059089', u'ENSMUSG00000021457', u'ENSMUSG00000029304', u'ENSMUSG00000024940', u'ENSMUSG00000020122']), NS='BP', pop_items=set([u'ENSMUSG00000043252', u'ENSMUSG00000019087', u'ENSMUSG00000027562', u'ENSMUSG00000032554', u'ENSMUSG00000047259', u'ENSMUSG00000025473', u'ENSMUSG00000030201', u'ENSMUSG00000021457', u'ENSMUSG00000029304', u'ENSMUSG00000024940', u'ENSMUSG00000022797', u'ENSMUSG00000059089', u'ENSMUSG00000033871', u'ENSMUSG00000020122', u'ENSMUSG00000020689']), pop_n=13836, p_sm_bonferroni=1.0, is_obsolete=False, GO='GO:0045780', name='positive regulation of bone resorption', pop_count=15, alt_ids=[], level=5, depth=7, enrichment='e', Cluster='Late Increase', geneid_set=set([u'ENSMUSG00000029304', u'ENSMUSG00000024940', u'ENSMUSG00000027562', u'ENSMUSG00000032554', u'ENSMUSG00000020122', u'ENSMUSG00000059089', u'ENSMUSG00000021457']), symbols=u'Car2 Egfr Fcgr4 Ltbp3 Spp1 Syk Trf', symbol_set=set([u'Ltbp3', u'Car2', u'Egfr', u'Trf', u'Syk', u'Spp1', u'Fcgr4']), geneids='ENSMUSG00000027562 ENSMUSG00000032554 ENSMUSG00000059089 ENSMUSG00000021457 ENSMUSG00000029304 ENSMUSG00000024940 ENSMUSG00000020122', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=0, D1='A', GO_name='positive regulation of bone resorption'),
    Nt(p_uncorrected=0.00012608849052898094, study_count=13, study_n=1397, namespace='biological_process', p_fdr_bh=0.014141665233879386, study_items=set([u'ENSMUSG00000020919', u'ENSMUSG00000037820', u'ENSMUSG00000004043', u'ENSMUSG00000037411', u'ENSMUSG00000032035', u'ENSMUSG00000002897', u'ENSMUSG00000018927', u'ENSMUSG00000008734', u'ENSMUSG00000019122', u'ENSMUSG00000020122', u'ENSMUSG00000038642', u'ENSMUSG00000024810', u'ENSMUSG00000039005']), NS='BP', pop_items=set([u'ENSMUSG00000055447', u'ENSMUSG00000045322', u'ENSMUSG00000020681', u'ENSMUSG00000034786', u'ENSMUSG00000019122', u'ENSMUSG00000031639', u'ENSMUSG00000021994', u'ENSMUSG00000024810', u'ENSMUSG00000031778', u'ENSMUSG00000031616', u'ENSMUSG00000020919', u'ENSMUSG00000037820', u'ENSMUSG00000050965', u'ENSMUSG00000029238', u'ENSMUSG00000032035', u'ENSMUSG00000026069', u'ENSMUSG00000018927', u'ENSMUSG00000035352', u'ENSMUSG00000014158', u'ENSMUSG00000038481', u'ENSMUSG00000039005', u'ENSMUSG00000056220', u'ENSMUSG00000037411', u'ENSMUSG00000020400', u'ENSMUSG00000030341', u'ENSMUSG00000024789', u'ENSMUSG00000038642', u'ENSMUSG00000020122', u'ENSMUSG00000010047', u'ENSMUSG00000000982', u'ENSMUSG00000025980', u'ENSMUSG00000000562', u'ENSMUSG00000035385', u'ENSMUSG00000025473', u'ENSMUSG00000027995', u'ENSMUSG00000032193', u'ENSMUSG00000002897', u'ENSMUSG00000004043', u'ENSMUSG00000008734', u'ENSMUSG00000018930', u'ENSMUSG00000079227']), pop_n=13836, p_sm_bonferroni=1.0, is_obsolete=False, GO='GO:0050729', name='positive regulation of inflammatory response', pop_count=41, alt_ids=[], level=6, depth=7, enrichment='e', Cluster='Late Increase', geneid_set=set([u'ENSMUSG00000020919', u'ENSMUSG00000037820', u'ENSMUSG00000004043', u'ENSMUSG00000037411', u'ENSMUSG00000032035', u'ENSMUSG00000038642', u'ENSMUSG00000018927', u'ENSMUSG00000002897', u'ENSMUSG00000019122', u'ENSMUSG00000020122', u'ENSMUSG00000008734', u'ENSMUSG00000024810', u'ENSMUSG00000039005']), symbols=u'Ccl6 Ccl9 Ctss Egfr Ets1 Gprc5b Il17ra Il33 Serpine1 Stat5a Stat5b Tgm2 Tlr4', symbol_set=set([u'Tgm2', u'Ccl6', u'Ccl9', u'Egfr', u'Stat5b', u'Stat5a', u'Ets1', u'Il33', u'Tlr4', u'Ctss', u'Serpine1', u'Il17ra', u'Gprc5b']), geneids='ENSMUSG00000020919 ENSMUSG00000037820 ENSMUSG00000004043 ENSMUSG00000037411 ENSMUSG00000032035 ENSMUSG00000038642 ENSMUSG00000018927 ENSMUSG00000008734 ENSMUSG00000019122 ENSMUSG00000020122 ENSMUSG00000002897 ENSMUSG00000024810 ENSMUSG00000039005', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=32, D1='A', GO_name='positive regulation of inflammatory response'),
    Nt(p_uncorrected='', study_count='', study_n='', namespace='', p_fdr_bh='', study_items='', NS='BP', pop_items='', pop_n='', p_sm_bonferroni='', is_obsolete='', GO='GO:0009617', name='', pop_count='', alt_ids='', level=5, depth=5, enrichment='', Cluster='', geneid_set='', symbols='', symbol_set='', geneids='', format_txt=1, hdr_idx=1, is_hdrgo=True, is_usrgo=False, hdr1usr01='*', dcnt=12, D1='F', GO_name='response to bacterium'),
    Nt(p_uncorrected=3.527805482915541e-05, study_count=12, study_n=1397, namespace='biological_process', p_fdr_bh=0.005090455321109845, study_items=set([u'ENSMUSG00000027239', u'ENSMUSG00000026249', u'ENSMUSG00000021127', u'ENSMUSG00000005360', u'ENSMUSG00000005089', u'ENSMUSG00000020932', u'ENSMUSG00000063856', u'ENSMUSG00000048376', u'ENSMUSG00000044786', u'ENSMUSG00000020734', u'ENSMUSG00000020758', u'ENSMUSG00000045817']), NS='BP', pop_items=set([u'ENSMUSG00000003873', u'ENSMUSG00000021127', u'ENSMUSG00000039202', u'ENSMUSG00000068923', u'ENSMUSG00000025856', u'ENSMUSG00000021998', u'ENSMUSG00000059003', u'ENSMUSG00000027239', u'ENSMUSG00000026249', u'ENSMUSG00000005360', u'ENSMUSG00000020932', u'ENSMUSG00000063856', u'ENSMUSG00000048376', u'ENSMUSG00000028992', u'ENSMUSG00000020734', u'ENSMUSG00000020758', u'ENSMUSG00000021134', u'ENSMUSG00000005089', u'ENSMUSG00000021256', u'ENSMUSG00000000489', u'ENSMUSG00000032462', u'ENSMUSG00000064023', u'ENSMUSG00000002948', u'ENSMUSG00000031628', u'ENSMUSG00000033352', u'ENSMUSG00000045817', u'ENSMUSG00000006800', u'ENSMUSG00000027496', u'ENSMUSG00000035385', u'ENSMUSG00000044786', u'ENSMUSG00000028969', u'ENSMUSG00000019850']), pop_n=13836, p_sm_bonferroni=0.5344978087165336, is_obsolete=False, GO='GO:0009611', name='response to wounding', pop_count=32, alt_ids=['GO:0002245'], level=3, depth=3, enrichment='e', Cluster='Late Increase', geneid_set=set([u'ENSMUSG00000027239', u'ENSMUSG00000026249', u'ENSMUSG00000021127', u'ENSMUSG00000005089', u'ENSMUSG00000005360', u'ENSMUSG00000020932', u'ENSMUSG00000063856', u'ENSMUSG00000048376', u'ENSMUSG00000044786', u'ENSMUSG00000020734', u'ENSMUSG00000020758', u'ENSMUSG00000045817']), symbols=u'F2r Gfap Gpx1 Grin2c Itgb4 Mdk Serpine2 Slc1a2 Slc1a3 Zfp36 Zfp36l1 Zfp36l2', symbol_set=set([u'Mdk', u'Itgb4', u'Grin2c', u'Zfp36l1', u'Zfp36l2', u'Gpx1', u'F2r', u'Zfp36', u'Serpine2', u'Gfap', u'Slc1a2', u'Slc1a3']), geneids='ENSMUSG00000027239 ENSMUSG00000026249 ENSMUSG00000021127 ENSMUSG00000005089 ENSMUSG00000005360 ENSMUSG00000020932 ENSMUSG00000063856 ENSMUSG00000048376 ENSMUSG00000044786 ENSMUSG00000020734 ENSMUSG00000020758 ENSMUSG00000045817', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=14, D1='F', GO_name='response to wounding'),
    Nt(p_uncorrected=0.0002666544464035524, study_count=16, study_n=1397, namespace='biological_process', p_fdr_bh=0.02525050948412639, study_items=set([u'ENSMUSG00000027168', u'ENSMUSG00000007655', u'ENSMUSG00000025352', u'ENSMUSG00000043456', u'ENSMUSG00000036634', u'ENSMUSG00000025809', u'ENSMUSG00000061517', u'ENSMUSG00000019803', u'ENSMUSG00000026176', u'ENSMUSG00000026424', u'ENSMUSG00000020644', u'ENSMUSG00000074637', u'ENSMUSG00000053024', u'ENSMUSG00000026923', u'ENSMUSG00000021318', u'ENSMUSG00000021379']), NS='BP', pop_items=set([u'ENSMUSG00000028224', u'ENSMUSG00000024294', u'ENSMUSG00000026923', u'ENSMUSG00000029516', u'ENSMUSG00000020458', u'ENSMUSG00000008999', u'ENSMUSG00000032064', u'ENSMUSG00000022892', u'ENSMUSG00000029249', u'ENSMUSG00000025352', u'ENSMUSG00000025466', u'ENSMUSG00000028156', u'ENSMUSG00000029026', u'ENSMUSG00000043456', u'ENSMUSG00000052534', u'ENSMUSG00000018160', u'ENSMUSG00000021318', u'ENSMUSG00000048001', u'ENSMUSG00000022528', u'ENSMUSG00000040289', u'ENSMUSG00000037296', u'ENSMUSG00000027276', u'ENSMUSG00000019803', u'ENSMUSG00000064293', u'ENSMUSG00000020950', u'ENSMUSG00000003814', u'ENSMUSG00000026424', u'ENSMUSG00000040785', u'ENSMUSG00000048756', u'ENSMUSG00000020052', u'ENSMUSG00000020160', u'ENSMUSG00000007655', u'ENSMUSG00000025809', u'ENSMUSG00000027434', u'ENSMUSG00000021743', u'ENSMUSG00000020454', u'ENSMUSG00000033952', u'ENSMUSG00000061517', u'ENSMUSG00000032097', u'ENSMUSG00000014773', u'ENSMUSG00000029603', u'ENSMUSG00000039830', u'ENSMUSG00000021379', u'ENSMUSG00000038146', u'ENSMUSG00000037032', u'ENSMUSG00000027168', u'ENSMUSG00000041351', u'ENSMUSG00000036208', u'ENSMUSG00000005102', u'ENSMUSG00000036634', u'ENSMUSG00000050071', u'ENSMUSG00000024735', u'ENSMUSG00000026176', u'ENSMUSG00000041544', u'ENSMUSG00000053024', u'ENSMUSG00000020644', u'ENSMUSG00000074637', u'ENSMUSG00000047139', u'ENSMUSG00000032329', u'ENSMUSG00000007815', u'ENSMUSG00000039298']), pop_n=13836, p_sm_bonferroni=1.0, is_obsolete=False, GO='GO:0045665', name='negative regulation of neuron differentiation', pop_count=61, alt_ids=[], level=7, depth=8, enrichment='e', Cluster='Late Increase', geneid_set=set([u'ENSMUSG00000061517', u'ENSMUSG00000025809', u'ENSMUSG00000026923', u'ENSMUSG00000025352', u'ENSMUSG00000021318', u'ENSMUSG00000021379', u'ENSMUSG00000053024', u'ENSMUSG00000027168', u'ENSMUSG00000043456', u'ENSMUSG00000036634', u'ENSMUSG00000019803', u'ENSMUSG00000026176', u'ENSMUSG00000026424', u'ENSMUSG00000020644', u'ENSMUSG00000074637', u'ENSMUSG00000007655']), symbols=u'Cav1 Cntn2 Ctdsp1 Gdf11 Gli3 Gpr37l1 Id2 Id4 Itgb1 Mag Notch1 Nr2e1 Pax6 Sox2 Sox21 Zfp536', symbol_set=set([u'Sox21', u'Itgb1', u'Gpr37l1', u'Id2', u'Id4', u'Zfp536', u'Notch1', u'Cntn2', u'Gli3', u'Pax6', u'Nr2e1', u'Mag', u'Sox2', u'Ctdsp1', u'Gdf11', u'Cav1']), geneids='ENSMUSG00000026923 ENSMUSG00000007655 ENSMUSG00000043456 ENSMUSG00000036634 ENSMUSG00000025809 ENSMUSG00000027168 ENSMUSG00000019803 ENSMUSG00000026176 ENSMUSG00000061517 ENSMUSG00000026424 ENSMUSG00000020644 ENSMUSG00000074637 ENSMUSG00000025352 ENSMUSG00000021318 ENSMUSG00000021379 ENSMUSG00000053024', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=46, D1='A', GO_name='negative regulation of neuron differentiation'),
    Nt(p_uncorrected=0.0001538136428217577, study_count=6, study_n=1397, namespace='biological_process', p_fdr_bh=0.016411006997724215, study_items=set([u'ENSMUSG00000004207', u'ENSMUSG00000026424', u'ENSMUSG00000015839', u'ENSMUSG00000025584', u'ENSMUSG00000039904', u'ENSMUSG00000014776']), NS='BP', pop_items=set([u'ENSMUSG00000032939', u'ENSMUSG00000004207', u'ENSMUSG00000036273', u'ENSMUSG00000028367', u'ENSMUSG00000028964', u'ENSMUSG00000026424', u'ENSMUSG00000015839', u'ENSMUSG00000025584', u'ENSMUSG00000014776', u'ENSMUSG00000039904']), pop_n=13836, p_sm_bonferroni=1.0, is_obsolete=False, GO='GO:1903206', name='negative regulation of hydrogen peroxide-induced cell death', pop_count=10, alt_ids=[], level=7, depth=9, enrichment='e', Cluster='Late Increase', geneid_set=set([u'ENSMUSG00000004207', u'ENSMUSG00000026424', u'ENSMUSG00000015839', u'ENSMUSG00000025584', u'ENSMUSG00000014776', u'ENSMUSG00000039904']), symbols=u'Gpr37 Gpr37l1 Nfe2l2 Nol3 Pde8a Psap', symbol_set=set([u'Gpr37l1', u'Nfe2l2', u'Psap', u'Nol3', u'Pde8a', u'Gpr37']), geneids='ENSMUSG00000004207 ENSMUSG00000026424 ENSMUSG00000015839 ENSMUSG00000025584 ENSMUSG00000014776 ENSMUSG00000039904', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=4, D1='A', GO_name='negative regulation of hydrogen peroxide-induced cell death'),
    Nt(p_uncorrected=5.366282028437046e-06, study_count=15, study_n=1397, namespace='biological_process', p_fdr_bh=0.0011933586106024233, study_items=set([u'ENSMUSG00000030317', u'ENSMUSG00000026249', u'ENSMUSG00000017466', u'ENSMUSG00000021585', u'ENSMUSG00000037411', u'ENSMUSG00000023224', u'ENSMUSG00000046186', u'ENSMUSG00000030111', u'ENSMUSG00000037254', u'ENSMUSG00000020044', u'ENSMUSG00000021091', u'ENSMUSG00000027082', u'ENSMUSG00000025780', u'ENSMUSG00000006522', u'ENSMUSG00000027447']), NS='BP', pop_items=set([u'ENSMUSG00000032959', u'ENSMUSG00000024073', u'ENSMUSG00000044177', u'ENSMUSG00000060147', u'ENSMUSG00000028108', u'ENSMUSG00000017466', u'ENSMUSG00000050074', u'ENSMUSG00000030111', u'ENSMUSG00000022892', u'ENSMUSG00000027834', u'ENSMUSG00000028476', u'ENSMUSG00000021223', u'ENSMUSG00000025650', u'ENSMUSG00000044734', u'ENSMUSG00000026249', u'ENSMUSG00000005054', u'ENSMUSG00000026315', u'ENSMUSG00000027315', u'ENSMUSG00000023224', u'ENSMUSG00000001131', u'ENSMUSG00000020044', u'ENSMUSG00000027082', u'ENSMUSG00000027447', u'ENSMUSG00000037411', u'ENSMUSG00000055653', u'ENSMUSG00000023336', u'ENSMUSG00000037254', u'ENSMUSG00000021091', u'ENSMUSG00000006522', u'ENSMUSG00000047557', u'ENSMUSG00000021585', u'ENSMUSG00000030317', u'ENSMUSG00000017716', u'ENSMUSG00000068129', u'ENSMUSG00000027859', u'ENSMUSG00000046186', u'ENSMUSG00000022766', u'ENSMUSG00000054162', u'ENSMUSG00000025780', u'ENSMUSG00000038224', u'ENSMUSG00000074227']), pop_n=13836, p_sm_bonferroni=0.08130453901284969, is_obsolete=False, GO='GO:0010466', name='negative regulation of peptidase activity', pop_count=41, alt_ids=[], level=6, depth=9, enrichment='e', Cluster='Late Increase', geneid_set=set([u'ENSMUSG00000046186', u'ENSMUSG00000026249', u'ENSMUSG00000030317', u'ENSMUSG00000021585', u'ENSMUSG00000037411', u'ENSMUSG00000023224', u'ENSMUSG00000017466', u'ENSMUSG00000030111', u'ENSMUSG00000021091', u'ENSMUSG00000020044', u'ENSMUSG00000037254', u'ENSMUSG00000027082', u'ENSMUSG00000025780', u'ENSMUSG00000006522', u'ENSMUSG00000027447']), symbols=u'A2m Cast Cd109 Cst3 Itih2 Itih3 Itih5 Serpina3n Serpine1 Serpine2 Serping1 Tfpi Timp2 Timp3 Timp4', symbol_set=set([u'Timp4', u'Timp3', u'Timp2', u'Serpina3n', u'Cd109', u'A2m', u'Cast', u'Serping1', u'Tfpi', u'Cst3', u'Itih3', u'Itih2', u'Itih5', u'Serpine1', u'Serpine2']), geneids='ENSMUSG00000030317 ENSMUSG00000026249 ENSMUSG00000017466 ENSMUSG00000021585 ENSMUSG00000037411 ENSMUSG00000023224 ENSMUSG00000046186 ENSMUSG00000030111 ENSMUSG00000037254 ENSMUSG00000020044 ENSMUSG00000021091 ENSMUSG00000027082 ENSMUSG00000025780 ENSMUSG00000006522 ENSMUSG00000027447', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=20, D1='A', GO_name='negative regulation of peptidase activity'),
    Nt(p_uncorrected=0.0003405348230112812, study_count=11, study_n=1397, namespace='biological_process', p_fdr_bh=0.03052924913280427, study_items=set([u'ENSMUSG00000024913', u'ENSMUSG00000026923', u'ENSMUSG00000025239', u'ENSMUSG00000007872', u'ENSMUSG00000042745', u'ENSMUSG00000020644', u'ENSMUSG00000074637', u'ENSMUSG00000031565', u'ENSMUSG00000033016', u'ENSMUSG00000026185', u'ENSMUSG00000036192']), NS='BP', pop_items=set([u'ENSMUSG00000026923', u'ENSMUSG00000021451', u'ENSMUSG00000042745', u'ENSMUSG00000031565', u'ENSMUSG00000046791', u'ENSMUSG00000036192', u'ENSMUSG00000026313', u'ENSMUSG00000022475', u'ENSMUSG00000024098', u'ENSMUSG00000017119', u'ENSMUSG00000021943', u'ENSMUSG00000033016', u'ENSMUSG00000032402', u'ENSMUSG00000039286', u'ENSMUSG00000000142', u'ENSMUSG00000006958', u'ENSMUSG00000040274', u'ENSMUSG00000023087', u'ENSMUSG00000021466', u'ENSMUSG00000038260', u'ENSMUSG00000024913', u'ENSMUSG00000024947', u'ENSMUSG00000008855', u'ENSMUSG00000026185', u'ENSMUSG00000043252', u'ENSMUSG00000025239', u'ENSMUSG00000037573', u'ENSMUSG00000007872', u'ENSMUSG00000031548', u'ENSMUSG00000048616', u'ENSMUSG00000066613', u'ENSMUSG00000020644', u'ENSMUSG00000074637', u'ENSMUSG00000029050']), pop_n=13836, p_sm_bonferroni=1.0, is_obsolete=False, GO='GO:0045668', name='negative regulation of osteoblast differentiation', pop_count=34, alt_ids=[], level=6, depth=6, enrichment='e', Cluster='Late Increase', geneid_set=set([u'ENSMUSG00000020644', u'ENSMUSG00000026923', u'ENSMUSG00000025239', u'ENSMUSG00000007872', u'ENSMUSG00000033016', u'ENSMUSG00000042745', u'ENSMUSG00000074637', u'ENSMUSG00000031565', u'ENSMUSG00000024913', u'ENSMUSG00000026185', u'ENSMUSG00000036192']), symbols=u'Fgfr1 Id1 Id2 Id3 Igfbp5 Limd1 Lrp5 Nfatc1 Notch1 Rorb Sox2', symbol_set=set([u'Nfatc1', u'Lrp5', u'Id3', u'Id2', u'Notch1', u'Id1', u'Rorb', u'Igfbp5', u'Sox2', u'Limd1', u'Fgfr1']), geneids='ENSMUSG00000042745 ENSMUSG00000026923 ENSMUSG00000025239 ENSMUSG00000007872 ENSMUSG00000033016 ENSMUSG00000020644 ENSMUSG00000074637 ENSMUSG00000031565 ENSMUSG00000024913 ENSMUSG00000026185 ENSMUSG00000036192', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=1, D1='A', GO_name='negative regulation of osteoblast differentiation'),
    Nt(p_uncorrected=7.454993613436451e-08, study_count=11, study_n=1397, namespace='biological_process', p_fdr_bh=3.4227457041568385e-05, study_items=set([u'ENSMUSG00000022912', u'ENSMUSG00000000552', u'ENSMUSG00000023224', u'ENSMUSG00000039109', u'ENSMUSG00000028128', u'ENSMUSG00000001930', u'ENSMUSG00000027712', u'ENSMUSG00000074743', u'ENSMUSG00000048376', u'ENSMUSG00000023961', u'ENSMUSG00000027082']), NS='BP', pop_items=set([u'ENSMUSG00000022912', u'ENSMUSG00000026579', u'ENSMUSG00000000552', u'ENSMUSG00000023224', u'ENSMUSG00000039109', u'ENSMUSG00000028128', u'ENSMUSG00000001930', u'ENSMUSG00000027712', u'ENSMUSG00000074743', u'ENSMUSG00000048376', u'ENSMUSG00000050761', u'ENSMUSG00000036353', u'ENSMUSG00000023961', u'ENSMUSG00000022766', u'ENSMUSG00000031196', u'ENSMUSG00000027082', u'ENSMUSG00000021814']), pop_n=13836, p_sm_bonferroni=0.0011295060823717567, is_obsolete=False, GO='GO:0007599', name='hemostasis', pop_count=17, alt_ids=[], level=4, depth=4, enrichment='e', Cluster='Late Increase', geneid_set=set([u'ENSMUSG00000022912', u'ENSMUSG00000000552', u'ENSMUSG00000074743', u'ENSMUSG00000039109', u'ENSMUSG00000028128', u'ENSMUSG00000001930', u'ENSMUSG00000027712', u'ENSMUSG00000023224', u'ENSMUSG00000048376', u'ENSMUSG00000023961', u'ENSMUSG00000027082']), symbols=u'Anxa5 Enpp4 F13a1 F2r F3 Pros1 Serping1 Tfpi Thbd Vwf Zfp385a', symbol_set=set([u'F3', u'Anxa5', u'Enpp4', u'Pros1', u'F2r', u'Serping1', u'Tfpi', u'F13a1', u'Thbd', u'Zfp385a', u'Vwf']), geneids='ENSMUSG00000022912 ENSMUSG00000000552 ENSMUSG00000074743 ENSMUSG00000039109 ENSMUSG00000028128 ENSMUSG00000001930 ENSMUSG00000027712 ENSMUSG00000023224 ENSMUSG00000048376 ENSMUSG00000023961 ENSMUSG00000027082', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=2, D1='A', GO_name='hemostasis'),
    Nt(p_uncorrected=2.638866589098148e-06, study_count=36, study_n=1397, namespace='biological_process', p_fdr_bh=0.0007135923513655597, study_items=set([u'ENSMUSG00000030339', u'ENSMUSG00000046731', u'ENSMUSG00000035158', u'ENSMUSG00000026923', u'ENSMUSG00000003031', u'ENSMUSG00000031565', u'ENSMUSG00000034957', u'ENSMUSG00000033579', u'ENSMUSG00000038393', u'ENSMUSG00000030849', u'ENSMUSG00000032440', u'ENSMUSG00000053158', u'ENSMUSG00000053110', u'ENSMUSG00000023031', u'ENSMUSG00000034462', u'ENSMUSG00000021822', u'ENSMUSG00000021025', u'ENSMUSG00000040613', u'ENSMUSG00000014932', u'ENSMUSG00000042626', u'ENSMUSG00000020053', u'ENSMUSG00000027318', u'ENSMUSG00000037815', u'ENSMUSG00000001552', u'ENSMUSG00000025283', u'ENSMUSG00000037706', u'ENSMUSG00000021318', u'ENSMUSG00000029371', u'ENSMUSG00000039191', u'ENSMUSG00000000567', u'ENSMUSG00000005125', u'ENSMUSG00000037411', u'ENSMUSG00000028874', u'ENSMUSG00000020122', u'ENSMUSG00000002147', u'ENSMUSG00000028599']), NS='BP', pop_items=set([u'ENSMUSG00000020937', u'ENSMUSG00000024073', u'ENSMUSG00000026923', u'ENSMUSG00000029417', u'ENSMUSG00000000127', u'ENSMUSG00000004665', u'ENSMUSG00000059552', u'ENSMUSG00000024793', u'ENSMUSG00000002799', u'ENSMUSG00000034957', u'ENSMUSG00000002250', u'ENSMUSG00000038393', u'ENSMUSG00000030849', u'ENSMUSG00000052837', u'ENSMUSG00000023078', u'ENSMUSG00000006932', u'ENSMUSG00000046058', u'ENSMUSG00000053110', u'ENSMUSG00000052534', u'ENSMUSG00000015647', u'ENSMUSG00000022074', u'ENSMUSG00000020063', u'ENSMUSG00000019843', u'ENSMUSG00000025915', u'ENSMUSG00000034462', u'ENSMUSG00000055471', u'ENSMUSG00000029687', u'ENSMUSG00000030201', u'ENSMUSG00000006014', u'ENSMUSG00000039239', u'ENSMUSG00000041147', u'ENSMUSG00000025283', u'ENSMUSG00000022791', u'ENSMUSG00000038518', u'ENSMUSG00000028530', u'ENSMUSG00000042354', u'ENSMUSG00000000567', u'ENSMUSG00000022114', u'ENSMUSG00000037411', u'ENSMUSG00000005125', u'ENSMUSG00000002413', u'ENSMUSG00000002147', u'ENSMUSG00000032815', u'ENSMUSG00000046731', u'ENSMUSG00000071076', u'ENSMUSG00000062232', u'ENSMUSG00000032487', u'ENSMUSG00000034021', u'ENSMUSG00000028552', u'ENSMUSG00000058248', u'ENSMUSG00000021466', u'ENSMUSG00000028413', u'ENSMUSG00000031565', u'ENSMUSG00000024513', u'ENSMUSG00000014859', u'ENSMUSG00000024515', u'ENSMUSG00000069255', u'ENSMUSG00000027646', u'ENSMUSG00000032405', u'ENSMUSG00000018593', u'ENSMUSG00000004933', u'ENSMUSG00000042626', u'ENSMUSG00000020053', u'ENSMUSG00000020052', u'ENSMUSG00000055612', u'ENSMUSG00000033579', u'ENSMUSG00000001552', u'ENSMUSG00000003283', u'ENSMUSG00000004099', u'ENSMUSG00000034855', u'ENSMUSG00000028466', u'ENSMUSG00000033373', u'ENSMUSG00000039191', u'ENSMUSG00000033307', u'ENSMUSG00000026321', u'ENSMUSG00000051510', u'ENSMUSG00000018604', u'ENSMUSG00000035105', u'ENSMUSG00000024778', u'ENSMUSG00000020122', u'ENSMUSG00000031954', u'ENSMUSG00000030093', u'ENSMUSG00000035277', u'ENSMUSG00000034165', u'ENSMUSG00000020716', u'ENSMUSG00000027428', u'ENSMUSG00000032740', u'ENSMUSG00000067336', u'ENSMUSG00000027937', u'ENSMUSG00000026842', u'ENSMUSG00000026596', u'ENSMUSG00000029552', u'ENSMUSG00000003032', u'ENSMUSG00000032968', u'ENSMUSG00000003031', u'ENSMUSG00000018166', u'ENSMUSG00000009073', u'ENSMUSG00000027276', u'ENSMUSG00000032508', u'ENSMUSG00000002603', u'ENSMUSG00000010660', u'ENSMUSG00000053158', u'ENSMUSG00000034612', u'ENSMUSG00000023031', u'ENSMUSG00000028364', u'ENSMUSG00000021025', u'ENSMUSG00000032175', u'ENSMUSG00000004018', u'ENSMUSG00000032171', u'ENSMUSG00000017146', u'ENSMUSG00000056220', u'ENSMUSG00000008318', u'ENSMUSG00000044167', u'ENSMUSG00000021822', u'ENSMUSG00000030538', u'ENSMUSG00000021318', u'ENSMUSG00000029371', u'ENSMUSG00000022607', u'ENSMUSG00000059456', u'ENSMUSG00000028874', u'ENSMUSG00000014932', u'ENSMUSG00000022508', u'ENSMUSG00000024431', u'ENSMUSG00000006728', u'ENSMUSG00000022724', u'ENSMUSG00000030339', u'ENSMUSG00000021109', u'ENSMUSG00000027684', u'ENSMUSG00000031618', u'ENSMUSG00000043991', u'ENSMUSG00000038976', u'ENSMUSG00000004446', u'ENSMUSG00000058454', u'ENSMUSG00000032113', u'ENSMUSG00000032440', u'ENSMUSG00000035158', u'ENSMUSG00000042662', u'ENSMUSG00000056596', u'ENSMUSG00000040613', u'ENSMUSG00000037815', u'ENSMUSG00000036822', u'ENSMUSG00000040274', u'ENSMUSG00000047250', u'ENSMUSG00000001517', u'ENSMUSG00000027318', u'ENSMUSG00000035890', u'ENSMUSG00000030341', u'ENSMUSG00000030748', u'ENSMUSG00000028759', u'ENSMUSG00000037706', u'ENSMUSG00000029217', u'ENSMUSG00000024955', u'ENSMUSG00000055320', u'ENSMUSG00000019970', u'ENSMUSG00000012483', u'ENSMUSG00000028599']), pop_n=13836, p_sm_bonferroni=0.03998146769142604, is_obsolete=False, GO='GO:0042127', name='regulation of cell proliferation', pop_count=156, alt_ids=[], level=4, depth=4, enrichment='e', Cluster='Late Increase', geneid_set=set([u'ENSMUSG00000030339', u'ENSMUSG00000046731', u'ENSMUSG00000053158', u'ENSMUSG00000026923', u'ENSMUSG00000003031', u'ENSMUSG00000031565', u'ENSMUSG00000034957', u'ENSMUSG00000033579', u'ENSMUSG00000038393', u'ENSMUSG00000030849', u'ENSMUSG00000032440', u'ENSMUSG00000035158', u'ENSMUSG00000053110', u'ENSMUSG00000023031', u'ENSMUSG00000034462', u'ENSMUSG00000021822', u'ENSMUSG00000021025', u'ENSMUSG00000040613', u'ENSMUSG00000014932', u'ENSMUSG00000042626', u'ENSMUSG00000020053', u'ENSMUSG00000027318', u'ENSMUSG00000037815', u'ENSMUSG00000001552', u'ENSMUSG00000025283', u'ENSMUSG00000020122', u'ENSMUSG00000021318', u'ENSMUSG00000029371', u'ENSMUSG00000039191', u'ENSMUSG00000000567', u'ENSMUSG00000005125', u'ENSMUSG00000037411', u'ENSMUSG00000028874', u'ENSMUSG00000037706', u'ENSMUSG00000002147', u'ENSMUSG00000028599']), symbols=u'Adam33 Apobec1 Cd81 Cdkn1b Cebpa Cela1 Ctnna1 Cxcl5 Egfr Fa2h Fes Fgfr1 Fgfr2 Fgr Gli3 Igf1 Jup Kctd11 Ltbr Mitf Ndrg1 Nfkbia Notch1 Pkd2 Plau Rbpj Sat1 Serpine1 Shc1 Sox9 Stat6 Tgfbr2 Tnfrsf1b Txnip Yap1 Yes1', symbol_set=set([u'Ltbr', u'Igf1', u'Cxcl5', u'Sat1', u'Rbpj', u'Apobec1', u'Fes', u'Yes1', u'Yap1', u'Tnfrsf1b', u'Pkd2', u'Nfkbia', u'Notch1', u'Plau', u'Serpine1', u'Jup', u'Adam33', u'Mitf', u'Ndrg1', u'Fgfr2', u'Cela1', u'Tgfbr2', u'Kctd11', u'Shc1', u'Cd81', u'Cdkn1b', u'Sox9', u'Txnip', u'Ctnna1', u'Cebpa', u'Stat6', u'Egfr', u'Fa2h', u'Gli3', u'Fgfr1', u'Fgr']), geneids='ENSMUSG00000026923 ENSMUSG00000046731 ENSMUSG00000053158 ENSMUSG00000030339 ENSMUSG00000003031 ENSMUSG00000031565 ENSMUSG00000034957 ENSMUSG00000027318 ENSMUSG00000038393 ENSMUSG00000030849 ENSMUSG00000032440 ENSMUSG00000035158 ENSMUSG00000053110 ENSMUSG00000023031 ENSMUSG00000034462 ENSMUSG00000021822 ENSMUSG00000021025 ENSMUSG00000040613 ENSMUSG00000014932 ENSMUSG00000042626 ENSMUSG00000020053 ENSMUSG00000033579 ENSMUSG00000037815 ENSMUSG00000001552 ENSMUSG00000025283 ENSMUSG00000037706 ENSMUSG00000021318 ENSMUSG00000029371 ENSMUSG00000039191 ENSMUSG00000000567 ENSMUSG00000005125 ENSMUSG00000037411 ENSMUSG00000028874 ENSMUSG00000020122 ENSMUSG00000002147 ENSMUSG00000028599', format_txt=1, hdr_idx=1, is_hdrgo=True, is_usrgo=True, hdr1usr01='**', dcnt=271, D1='A', GO_name='regulation of cell proliferation'),
    Nt(p_uncorrected=0.00047594319969878284, study_count=4, study_n=1397, namespace='biological_process', p_fdr_bh=0.0381597084052771, study_items=set([u'ENSMUSG00000037254', u'ENSMUSG00000025780', u'ENSMUSG00000006522', u'ENSMUSG00000010051']), NS='BP', pop_items=set([u'ENSMUSG00000021476', u'ENSMUSG00000010051', u'ENSMUSG00000025780', u'ENSMUSG00000006522', u'ENSMUSG00000037254']), pop_n=13836, p_sm_bonferroni=1.0, is_obsolete=False, GO='GO:0030212', name='hyaluronan metabolic process', pop_count=5, alt_ids=[], level=7, depth=7, enrichment='e', Cluster='Late Increase', geneid_set=set([u'ENSMUSG00000037254', u'ENSMUSG00000025780', u'ENSMUSG00000006522', u'ENSMUSG00000010051']), symbols=u'Hyal1 Itih2 Itih3 Itih5', symbol_set=set([u'Itih3', u'Itih2', u'Itih5', u'Hyal1']), geneids='ENSMUSG00000010051 ENSMUSG00000025780 ENSMUSG00000006522 ENSMUSG00000037254', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=2, D1='D', GO_name='hyaluronan metabolic process'),
    Nt(p_uncorrected=0.0002542801430457328, study_count=10, study_n=1397, namespace='biological_process', p_fdr_bh=0.024230178913747787, study_items=set([u'ENSMUSG00000022488', u'ENSMUSG00000059498', u'ENSMUSG00000050335', u'ENSMUSG00000042284', u'ENSMUSG00000021457', u'ENSMUSG00000029304', u'ENSMUSG00000018927', u'ENSMUSG00000019122', u'ENSMUSG00000039115', u'ENSMUSG00000028859']), NS='BP', pop_items=set([u'ENSMUSG00000033721', u'ENSMUSG00000059498', u'ENSMUSG00000021457', u'ENSMUSG00000029304', u'ENSMUSG00000019122', u'ENSMUSG00000058715', u'ENSMUSG00000031778', u'ENSMUSG00000028525', u'ENSMUSG00000050335', u'ENSMUSG00000032114', u'ENSMUSG00000042284', u'ENSMUSG00000050965', u'ENSMUSG00000018927', u'ENSMUSG00000025224', u'ENSMUSG00000035352', u'ENSMUSG00000027524', u'ENSMUSG00000021699', u'ENSMUSG00000034116', u'ENSMUSG00000030786', u'ENSMUSG00000039621', u'ENSMUSG00000000982', u'ENSMUSG00000022488', u'ENSMUSG00000000290', u'ENSMUSG00000035385', u'ENSMUSG00000022865', u'ENSMUSG00000039115', u'ENSMUSG00000028859', u'ENSMUSG00000018930']), pop_n=13836, p_sm_bonferroni=1.0, is_obsolete=False, GO='GO:0030593', name='neutrophil chemotaxis', pop_count=28, alt_ids=[], level=5, depth=10, enrichment='e', Cluster='Late Increase', geneid_set=set([u'ENSMUSG00000022488', u'ENSMUSG00000059498', u'ENSMUSG00000050335', u'ENSMUSG00000042284', u'ENSMUSG00000021457', u'ENSMUSG00000029304', u'ENSMUSG00000018927', u'ENSMUSG00000019122', u'ENSMUSG00000039115', u'ENSMUSG00000028859']), symbols=u'Ccl6 Ccl9 Csf3r Fcgr3 Itga1 Itga9 Lgals3 Nckap1l Spp1 Syk', symbol_set=set([u'Itga9', u'Nckap1l', u'Ccl6', u'Syk', u'Itga1', u'Ccl9', u'Spp1', u'Csf3r', u'Lgals3', u'Fcgr3']), geneids='ENSMUSG00000022488 ENSMUSG00000059498 ENSMUSG00000050335 ENSMUSG00000042284 ENSMUSG00000021457 ENSMUSG00000029304 ENSMUSG00000018927 ENSMUSG00000019122 ENSMUSG00000039115 ENSMUSG00000028859', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=0, D1='BCLM', GO_name='neutrophil chemotaxis'),
    Nt(p_uncorrected=1.2161003049694163e-05, study_count=18, study_n=1397, namespace='biological_process', p_fdr_bh=0.00219346853816567, study_items=set([u'ENSMUSG00000045092', u'ENSMUSG00000022488', u'ENSMUSG00000040759', u'ENSMUSG00000053158', u'ENSMUSG00000032434', u'ENSMUSG00000024620', u'ENSMUSG00000029648', u'ENSMUSG00000020573', u'ENSMUSG00000052336', u'ENSMUSG00000042190', u'ENSMUSG00000018927', u'ENSMUSG00000019122', u'ENSMUSG00000045382', u'ENSMUSG00000040552', u'ENSMUSG00000056529', u'ENSMUSG00000029371', u'ENSMUSG00000018819', u'ENSMUSG00000020143']), NS='BP', pop_items=set([u'ENSMUSG00000029417', u'ENSMUSG00000033220', u'ENSMUSG00000021732', u'ENSMUSG00000053158', u'ENSMUSG00000016495', u'ENSMUSG00000020573', u'ENSMUSG00000022425', u'ENSMUSG00000042190', u'ENSMUSG00000019122', u'ENSMUSG00000034902', u'ENSMUSG00000045382', u'ENSMUSG00000044337', u'ENSMUSG00000005672', u'ENSMUSG00000029231', u'ENSMUSG00000001847', u'ENSMUSG00000001741', u'ENSMUSG00000061353', u'ENSMUSG00000031778', u'ENSMUSG00000028195', u'ENSMUSG00000023078', u'ENSMUSG00000029648', u'ENSMUSG00000000127', u'ENSMUSG00000018927', u'ENSMUSG00000018920', u'ENSMUSG00000020739', u'ENSMUSG00000035352', u'ENSMUSG00000052516', u'ENSMUSG00000040552', u'ENSMUSG00000045092', u'ENSMUSG00000054717', u'ENSMUSG00000024620', u'ENSMUSG00000055633', u'ENSMUSG00000009281', u'ENSMUSG00000041688', u'ENSMUSG00000031558', u'ENSMUSG00000022883', u'ENSMUSG00000034855', u'ENSMUSG00000028466', u'ENSMUSG00000042228', u'ENSMUSG00000029371', u'ENSMUSG00000000982', u'ENSMUSG00000022488', u'ENSMUSG00000030770', u'ENSMUSG00000032128', u'ENSMUSG00000052821', u'ENSMUSG00000040759', u'ENSMUSG00000035385', u'ENSMUSG00000032434', u'ENSMUSG00000018819', u'ENSMUSG00000042632', u'ENSMUSG00000052336', u'ENSMUSG00000032436', u'ENSMUSG00000056529', u'ENSMUSG00000001123', u'ENSMUSG00000039936', u'ENSMUSG00000031875', u'ENSMUSG00000018930', u'ENSMUSG00000079227', u'ENSMUSG00000020143']), pop_n=13836, p_sm_bonferroni=0.18425135720591626, is_obsolete=False, GO='GO:0006935', name='chemotaxis', pop_count=59, alt_ids=[], level=3, depth=3, enrichment='e', Cluster='Late Increase', geneid_set=set([u'ENSMUSG00000045092', u'ENSMUSG00000024620', u'ENSMUSG00000020573', u'ENSMUSG00000042190', u'ENSMUSG00000019122', u'ENSMUSG00000045382', u'ENSMUSG00000056529', u'ENSMUSG00000029371', u'ENSMUSG00000022488', u'ENSMUSG00000040759', u'ENSMUSG00000032434', u'ENSMUSG00000053158', u'ENSMUSG00000029648', u'ENSMUSG00000052336', u'ENSMUSG00000018927', u'ENSMUSG00000040552', u'ENSMUSG00000018819', u'ENSMUSG00000020143']), symbols=u'C3ar1 Ccl6 Ccl9 Cmklr1 Cmtm5 Cmtm6 Cx3cr1 Cxcl5 Cxcr4 Dock2 Fes Flt1 Lsp1 Nckap1l Pdgfrb Pik3cg Ptafr S1pr1', symbol_set=set([u'C3ar1', u'Pdgfrb', u'Nckap1l', u'Cxcl5', u'Cx3cr1', u'Dock2', u'Cmtm6', u'S1pr1', u'Ccl9', u'Pik3cg', u'Ptafr', u'Fes', u'Cxcr4', u'Ccl6', u'Flt1', u'Cmklr1', u'Lsp1', u'Cmtm5']), geneids='ENSMUSG00000045092 ENSMUSG00000022488 ENSMUSG00000040759 ENSMUSG00000053158 ENSMUSG00000032434 ENSMUSG00000024620 ENSMUSG00000029648 ENSMUSG00000020573 ENSMUSG00000052336 ENSMUSG00000042190 ENSMUSG00000018927 ENSMUSG00000019122 ENSMUSG00000045382 ENSMUSG00000040552 ENSMUSG00000056529 ENSMUSG00000029371 ENSMUSG00000018819 ENSMUSG00000020143', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=109, D1='M', GO_name='chemotaxis'),
    Nt(p_uncorrected=1.6596883481999508e-10, study_count=3, study_n=1397, namespace='biological_process', p_fdr_bh=3.0597720239381384e-07, study_items=set([u'ENSMUSG00000010461', u'ENSMUSG00000029003', u'ENSMUSG00000025612']), NS='BP', pop_items=set([u'ENSMUSG00000028224', u'ENSMUSG00000047617', u'ENSMUSG00000026496', u'ENSMUSG00000047757', u'ENSMUSG00000000902', u'ENSMUSG00000029191', u'ENSMUSG00000021668', u'ENSMUSG00000024974', u'ENSMUSG00000022400', u'ENSMUSG00000025358', u'ENSMUSG00000031583', u'ENSMUSG00000030726', u'ENSMUSG00000039615', u'ENSMUSG00000074781', u'ENSMUSG00000029591', u'ENSMUSG00000030750', u'ENSMUSG00000038425', u'ENSMUSG00000058301', u'ENSMUSG00000007080', u'ENSMUSG00000027845', u'ENSMUSG00000028560', u'ENSMUSG00000018841', u'ENSMUSG00000022471', u'ENSMUSG00000028933', u'ENSMUSG00000020380', u'ENSMUSG00000025612', u'ENSMUSG00000027067', u'ENSMUSG00000019470', u'ENSMUSG00000030322', u'ENSMUSG00000017146', u'ENSMUSG00000020752', u'ENSMUSG00000045482', u'ENSMUSG00000022248', u'ENSMUSG00000019841', u'ENSMUSG00000007646', u'ENSMUSG00000021103', u'ENSMUSG00000025261', u'ENSMUSG00000032498', u'ENSMUSG00000039748', u'ENSMUSG00000021400', u'ENSMUSG00000030166', u'ENSMUSG00000029521', u'ENSMUSG00000021690', u'ENSMUSG00000018189', u'ENSMUSG00000003868', u'ENSMUSG00000021694', u'ENSMUSG00000041147', u'ENSMUSG00000005566', u'ENSMUSG00000062270', u'ENSMUSG00000009628', u'ENSMUSG00000028629', u'ENSMUSG00000025218', u'ENSMUSG00000024151', u'ENSMUSG00000032555', u'ENSMUSG00000030051', u'ENSMUSG00000061288', u'ENSMUSG00000022314', u'ENSMUSG00000020697', u'ENSMUSG00000010461', u'ENSMUSG00000047989', u'ENSMUSG00000032409', u'ENSMUSG00000036875', u'ENSMUSG00000019857', u'ENSMUSG00000026429', u'ENSMUSG00000025269', u'ENSMUSG00000059772', u'ENSMUSG00000025932', u'ENSMUSG00000017291', u'ENSMUSG00000003813', u'ENSMUSG00000021470', u'ENSMUSG00000028329', u'ENSMUSG00000025939', u'ENSMUSG00000021264', u'ENSMUSG00000034023', u'ENSMUSG00000069495', u'ENSMUSG00000034021', u'ENSMUSG00000030271', u'ENSMUSG00000018449', u'ENSMUSG00000041974', u'ENSMUSG00000035842', u'ENSMUSG00000022945', u'ENSMUSG00000028411', u'ENSMUSG00000059263', u'ENSMUSG00000030677', u'ENSMUSG00000038569', u'ENSMUSG00000078578', u'ENSMUSG00000073684', u'ENSMUSG00000028884', u'ENSMUSG00000020287', u'ENSMUSG00000028886', u'ENSMUSG00000034345', u'ENSMUSG00000001707', u'ENSMUSG00000022710', u'ENSMUSG00000043987', u'ENSMUSG00000014850', u'ENSMUSG00000003549', u'ENSMUSG00000024767', u'ENSMUSG00000036023', u'ENSMUSG00000006599', u'ENSMUSG00000036781', u'ENSMUSG00000021287', u'ENSMUSG00000029202', u'ENSMUSG00000035354', u'ENSMUSG00000022906', u'ENSMUSG00000027433', u'ENSMUSG00000021461', u'ENSMUSG00000031347', u'ENSMUSG00000049300', u'ENSMUSG00000014243', u'ENSMUSG00000021615', u'ENSMUSG00000009640', u'ENSMUSG00000069089', u'ENSMUSG00000024824', u'ENSMUSG00000002963', u'ENSMUSG00000025144', u'ENSMUSG00000024906', u'ENSMUSG00000031095', u'ENSMUSG00000039850', u'ENSMUSG00000043535', u'ENSMUSG00000020474', u'ENSMUSG00000051768', u'ENSMUSG00000022545', u'ENSMUSG00000024854', u'ENSMUSG00000037570', u'ENSMUSG00000021597', u'ENSMUSG00000036097', u'ENSMUSG00000029387', u'ENSMUSG00000024943', u'ENSMUSG00000034154', u'ENSMUSG00000027323', u'ENSMUSG00000021635', u'ENSMUSG00000022672', u'ENSMUSG00000042489', u'ENSMUSG00000034218', u'ENSMUSG00000028426', u'ENSMUSG00000038225', u'ENSMUSG00000021639', u'ENSMUSG00000038774', u'ENSMUSG00000030094', u'ENSMUSG00000031229', u'ENSMUSG00000020718', u'ENSMUSG00000031820', u'ENSMUSG00000055932', u'ENSMUSG00000027424', u'ENSMUSG00000026842', u'ENSMUSG00000027933', u'ENSMUSG00000020413', u'ENSMUSG00000045751', u'ENSMUSG00000026196', u'ENSMUSG00000025159', u'ENSMUSG00000020415', u'ENSMUSG00000046806', u'ENSMUSG00000032815', u'ENSMUSG00000030655', u'ENSMUSG00000030528', u'ENSMUSG00000038544', u'ENSMUSG00000030400', u'ENSMUSG00000073436', u'ENSMUSG00000036086', u'ENSMUSG00000031311', u'ENSMUSG00000041238', u'ENSMUSG00000034206', u'ENSMUSG00000031826', u'ENSMUSG00000039187', u'ENSMUSG00000066440', u'ENSMUSG00000032376', u'ENSMUSG00000032267', u'ENSMUSG00000079036', u'ENSMUSG00000091971', u'ENSMUSG00000024735', u'ENSMUSG00000028991', u'ENSMUSG00000030493', u'ENSMUSG00000014074', u'ENSMUSG00000020156', u'ENSMUSG00000054051', u'ENSMUSG00000041133', u'ENSMUSG00000025384', u'ENSMUSG00000004018', u'ENSMUSG00000001524', u'ENSMUSG00000024740', u'ENSMUSG00000026914', u'ENSMUSG00000022292', u'ENSMUSG00000061755', u'ENSMUSG00000033458', u'ENSMUSG00000033596', u'ENSMUSG00000028820', u'ENSMUSG00000035365', u'ENSMUSG00000057113', u'ENSMUSG00000039623', u'ENSMUSG00000059586', u'ENSMUSG00000002109', u'ENSMUSG00000037262', u'ENSMUSG00000035726', u'ENSMUSG00000040204', u'ENSMUSG00000009555', u'ENSMUSG00000049717', u'ENSMUSG00000030254', u'ENSMUSG00000034329', u'ENSMUSG00000020390', u'ENSMUSG00000030079', u'ENSMUSG00000026187', u'ENSMUSG00000051235', u'ENSMUSG00000033102', u'ENSMUSG00000046591', u'ENSMUSG00000055884', u'ENSMUSG00000037487', u'ENSMUSG00000058298', u'ENSMUSG00000031201', u'ENSMUSG00000037761', u'ENSMUSG00000028089', u'ENSMUSG00000031422', u'ENSMUSG00000028702', u'ENSMUSG00000024742', u'ENSMUSG00000002221', u'ENSMUSG00000032298', u'ENSMUSG00000027671', u'ENSMUSG00000006288', u'ENSMUSG00000026048', u'ENSMUSG00000026219', u'ENSMUSG00000043909', u'ENSMUSG00000002835', u'ENSMUSG00000092118', u'ENSMUSG00000090083', u'ENSMUSG00000025878', u'ENSMUSG00000039738', u'ENSMUSG00000055401', u'ENSMUSG00000020471', u'ENSMUSG00000044627', u'ENSMUSG00000068264', u'ENSMUSG00000035960', u'ENSMUSG00000030034', u'ENSMUSG00000040850', u'ENSMUSG00000031446', u'ENSMUSG00000038685', u'ENSMUSG00000044702', u'ENSMUSG00000031536', u'ENSMUSG00000031928', u'ENSMUSG00000049932', u'ENSMUSG00000020235', u'ENSMUSG00000036061', u'ENSMUSG00000032113', u'ENSMUSG00000019942', u'ENSMUSG00000029003', u'ENSMUSG00000070520', u'ENSMUSG00000056394', u'ENSMUSG00000040455', u'ENSMUSG00000034674', u'ENSMUSG00000005370', u'ENSMUSG00000026107', u'ENSMUSG00000058594', u'ENSMUSG00000027353', u'ENSMUSG00000024317', u'ENSMUSG00000027342', u'ENSMUSG00000061607', u'ENSMUSG00000000751', u'ENSMUSG00000035234', u'ENSMUSG00000038644', u'ENSMUSG00000026648', u'ENSMUSG00000032119', u'ENSMUSG00000027577', u'ENSMUSG00000023932', u'ENSMUSG00000001517', u'ENSMUSG00000029920', u'ENSMUSG00000030346', u'ENSMUSG00000021276', u'ENSMUSG00000090112', u'ENSMUSG00000024382', u'ENSMUSG00000026082', u'ENSMUSG00000073705', u'ENSMUSG00000030451', u'ENSMUSG00000035958', u'ENSMUSG00000025066', u'ENSMUSG00000015971', u'ENSMUSG00000040865', u'ENSMUSG00000033454', u'ENSMUSG00000023953', u'ENSMUSG00000031986', u'ENSMUSG00000030744', u'ENSMUSG00000037355', u'ENSMUSG00000025077', u'ENSMUSG00000001228', u'ENSMUSG00000030983', u'ENSMUSG00000028453', u'ENSMUSG00000028452', u'ENSMUSG00000040174', u'ENSMUSG00000061589', u'ENSMUSG00000025374', u'ENSMUSG00000036611', u'ENSMUSG00000035401', u'ENSMUSG00000012483', u'ENSMUSG00000052139', u'ENSMUSG00000049502', u'ENSMUSG00000051238', u'ENSMUSG00000016308', u'ENSMUSG00000020608', u'ENSMUSG00000045102', u'ENSMUSG00000042185', u'ENSMUSG00000021177', u'ENSMUSG00000079109', u'ENSMUSG00000006335']), pop_n=13836, p_sm_bonferroni=2.5145938163577457e-06, is_obsolete=False, GO='GO:0006281', name='DNA repair', pop_count=300, alt_ids=[], level=5, depth=7, enrichment='p', Cluster='Late Increase', geneid_set=set([u'ENSMUSG00000010461', u'ENSMUSG00000025612', u'ENSMUSG00000029003']), symbols=u'Bach1 Eya4 Mad2l2', symbol_set=set([u'Mad2l2', u'Eya4', u'Bach1']), geneids='ENSMUSG00000010461 ENSMUSG00000029003 ENSMUSG00000025612', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=45, D1='BDF', GO_name='DNA repair'),
    Nt(p_uncorrected=4.164206981138891e-06, study_count=24, study_n=1397, namespace='biological_process', p_fdr_bh=0.0009858109370505521, study_items=set([u'ENSMUSG00000003031', u'ENSMUSG00000024330', u'ENSMUSG00000031565', u'ENSMUSG00000046352', u'ENSMUSG00000041235', u'ENSMUSG00000005360', u'ENSMUSG00000049555', u'ENSMUSG00000033577', u'ENSMUSG00000063856', u'ENSMUSG00000041607', u'ENSMUSG00000001506', u'ENSMUSG00000020733', u'ENSMUSG00000048707', u'ENSMUSG00000038127', u'ENSMUSG00000012819', u'ENSMUSG00000039701', u'ENSMUSG00000023959', u'ENSMUSG00000030516', u'ENSMUSG00000040055', u'ENSMUSG00000030739', u'ENSMUSG00000010461', u'ENSMUSG00000056966', u'ENSMUSG00000074637', u'ENSMUSG00000069170']), NS='BP', pop_items=set([u'ENSMUSG00000021665', u'ENSMUSG00000073678', u'ENSMUSG00000005360', u'ENSMUSG00000026655', u'ENSMUSG00000055078', u'ENSMUSG00000002799', u'ENSMUSG00000046352', u'ENSMUSG00000037405', u'ENSMUSG00000030029', u'ENSMUSG00000041607', u'ENSMUSG00000020953', u'ENSMUSG00000015968', u'ENSMUSG00000011751', u'ENSMUSG00000063142', u'ENSMUSG00000038127', u'ENSMUSG00000038248', u'ENSMUSG00000030761', u'ENSMUSG00000052353', u'ENSMUSG00000022483', u'ENSMUSG00000091455', u'ENSMUSG00000020733', u'ENSMUSG00000032419', u'ENSMUSG00000039137', u'ENSMUSG00000026825', u'ENSMUSG00000027950', u'ENSMUSG00000021636', u'ENSMUSG00000031565', u'ENSMUSG00000063810', u'ENSMUSG00000029821', u'ENSMUSG00000028631', u'ENSMUSG00000052613', u'ENSMUSG00000021779', u'ENSMUSG00000027254', u'ENSMUSG00000052512', u'ENSMUSG00000039474', u'ENSMUSG00000030302', u'ENSMUSG00000062372', u'ENSMUSG00000033676', u'ENSMUSG00000031628', u'ENSMUSG00000022982', u'ENSMUSG00000039488', u'ENSMUSG00000000303', u'ENSMUSG00000025232', u'ENSMUSG00000024182', u'ENSMUSG00000005371', u'ENSMUSG00000024456', u'ENSMUSG00000074637', u'ENSMUSG00000019935', u'ENSMUSG00000031028', u'ENSMUSG00000060147', u'ENSMUSG00000003031', u'ENSMUSG00000024330', u'ENSMUSG00000035910', u'ENSMUSG00000041235', u'ENSMUSG00000049555', u'ENSMUSG00000033577', u'ENSMUSG00000023033', u'ENSMUSG00000049791', u'ENSMUSG00000036006', u'ENSMUSG00000048707', u'ENSMUSG00000025813', u'ENSMUSG00000020704', u'ENSMUSG00000039701', u'ENSMUSG00000057322', u'ENSMUSG00000040055', u'ENSMUSG00000002504', u'ENSMUSG00000010461', u'ENSMUSG00000069170', u'ENSMUSG00000032913', u'ENSMUSG00000056755', u'ENSMUSG00000022141', u'ENSMUSG00000063919', u'ENSMUSG00000063856', u'ENSMUSG00000025246', u'ENSMUSG00000001506', u'ENSMUSG00000075470', u'ENSMUSG00000022114', u'ENSMUSG00000027966', u'ENSMUSG00000012819', u'ENSMUSG00000023959', u'ENSMUSG00000030516', u'ENSMUSG00000030739', u'ENSMUSG00000005103', u'ENSMUSG00000056966', u'ENSMUSG00000007653', u'ENSMUSG00000039529', u'ENSMUSG00000030905', u'ENSMUSG00000024411']), pop_n=13836, p_sm_bonferroni=0.06309189997123534, is_obsolete=False, GO='GO:0007605', name='sensory perception of sound', pop_count=88, alt_ids=[], level=6, depth=6, enrichment='e', Cluster='Late Increase', geneid_set=set([u'ENSMUSG00000038127', u'ENSMUSG00000056966', u'ENSMUSG00000003031', u'ENSMUSG00000039701', u'ENSMUSG00000049555', u'ENSMUSG00000023959', u'ENSMUSG00000031565', u'ENSMUSG00000030516', u'ENSMUSG00000046352', u'ENSMUSG00000040055', u'ENSMUSG00000030739', u'ENSMUSG00000010461', u'ENSMUSG00000041235', u'ENSMUSG00000005360', u'ENSMUSG00000024330', u'ENSMUSG00000033577', u'ENSMUSG00000063856', u'ENSMUSG00000012819', u'ENSMUSG00000041607', u'ENSMUSG00000074637', u'ENSMUSG00000001506', u'ENSMUSG00000020733', u'ENSMUSG00000048707', u'ENSMUSG00000069170']), symbols=u'Adgrv1 Ccdc50 Cdh23 Cdkn1b Chd7 Clic5 Col11a2 Col1a1 Eya4 Fgfr1 Gjb2 Gjb6 Gjc3 Gpx1 Mbp Myh14 Myo6 Slc1a3 Slc9a3r1 Sox2 Tjp1 Tmie Tprn Usp53', symbol_set=set([u'Gjc3', 'Adgrv1', u'Ccdc50', u'Clic5', u'Slc9a3r1', u'Myo6', u'Tmie', u'Gpx1', u'Fgfr1', u'Myh14', u'Cdkn1b', u'Cdh23', u'Tjp1', u'Col1a1', u'Sox2', u'Slc1a3', u'Col11a2', u'Chd7', u'Tprn', u'Gjb2', u'Usp53', u'Gjb6', u'Eya4', u'Mbp']), geneids='ENSMUSG00000003031 ENSMUSG00000024330 ENSMUSG00000031565 ENSMUSG00000046352 ENSMUSG00000041235 ENSMUSG00000005360 ENSMUSG00000049555 ENSMUSG00000033577 ENSMUSG00000063856 ENSMUSG00000041607 ENSMUSG00000001506 ENSMUSG00000020733 ENSMUSG00000048707 ENSMUSG00000038127 ENSMUSG00000012819 ENSMUSG00000039701 ENSMUSG00000023959 ENSMUSG00000030516 ENSMUSG00000040055 ENSMUSG00000030739 ENSMUSG00000010461 ENSMUSG00000056966 ENSMUSG00000074637 ENSMUSG00000069170', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=0, D1='J', GO_name='sensory perception of sound'),
    Nt(p_uncorrected='', study_count='', study_n='', namespace='', p_fdr_bh='', study_items='', NS='BP', pop_items='', pop_n='', p_sm_bonferroni='', is_obsolete='', GO='GO:0060548', name='', pop_count='', alt_ids='', level=5, depth=5, enrichment='', Cluster='', geneid_set='', symbols='', symbol_set='', geneids='', format_txt=1, hdr_idx=1, is_hdrgo=True, is_usrgo=False, hdr1usr01='*', dcnt=110, D1='A', GO_name='negative regulation of cell death'),
    Nt(p_uncorrected=1.3206719688726623e-05, study_count=28, study_n=1397, namespace='biological_process', p_fdr_bh=0.0023148545191130497, study_items=set([u'ENSMUSG00000049521', u'ENSMUSG00000031385', u'ENSMUSG00000039031', u'ENSMUSG00000042312', u'ENSMUSG00000026193', u'ENSMUSG00000041598', u'ENSMUSG00000039960', u'ENSMUSG00000053646', u'ENSMUSG00000053158', u'ENSMUSG00000036606', u'ENSMUSG00000075284', u'ENSMUSG00000028583', u'ENSMUSG00000032050', u'ENSMUSG00000020611', u'ENSMUSG00000020733', u'ENSMUSG00000015745', u'ENSMUSG00000024048', u'ENSMUSG00000052397', u'ENSMUSG00000000149', u'ENSMUSG00000026830', u'ENSMUSG00000023008', u'ENSMUSG00000019978', u'ENSMUSG00000025239', u'ENSMUSG00000030739', u'ENSMUSG00000028874', u'ENSMUSG00000033208', u'ENSMUSG00000022272', u'ENSMUSG00000024143']), NS='BP', pop_items=set([u'ENSMUSG00000021665', u'ENSMUSG00000063531', u'ENSMUSG00000030695', u'ENSMUSG00000030447', u'ENSMUSG00000036533', u'ENSMUSG00000022788', u'ENSMUSG00000037405', u'ENSMUSG00000058230', u'ENSMUSG00000036606', u'ENSMUSG00000020953', u'ENSMUSG00000024576', u'ENSMUSG00000022770', u'ENSMUSG00000025265', u'ENSMUSG00000019843', u'ENSMUSG00000020611', u'ENSMUSG00000024048', u'ENSMUSG00000039031', u'ENSMUSG00000029528', u'ENSMUSG00000003345', u'ENSMUSG00000022099', u'ENSMUSG00000033066', u'ENSMUSG00000025609', u'ENSMUSG00000059981', u'ENSMUSG00000000982', u'ENSMUSG00000004462', u'ENSMUSG00000032384', u'ENSMUSG00000029838', u'ENSMUSG00000032253', u'ENSMUSG00000029283', u'ENSMUSG00000020900', u'ENSMUSG00000021115', u'ENSMUSG00000021814', u'ENSMUSG00000022914', u'ENSMUSG00000032812', u'ENSMUSG00000004568', u'ENSMUSG00000025132', u'ENSMUSG00000029636', u'ENSMUSG00000005672', u'ENSMUSG00000073563', u'ENSMUSG00000020284', u'ENSMUSG00000061136', u'ENSMUSG00000035352', u'ENSMUSG00000037712', u'ENSMUSG00000020733', u'ENSMUSG00000046722', u'ENSMUSG00000026830', u'ENSMUSG00000003283', u'ENSMUSG00000022433', u'ENSMUSG00000033377', u'ENSMUSG00000030770', u'ENSMUSG00000023008', u'ENSMUSG00000002205', u'ENSMUSG00000029381', u'ENSMUSG00000024451', u'ENSMUSG00000086040', u'ENSMUSG00000024456', u'ENSMUSG00000031954', u'ENSMUSG00000031385', u'ENSMUSG00000028064', u'ENSMUSG00000064090', u'ENSMUSG00000021451', u'ENSMUSG00000042312', u'ENSMUSG00000026193', u'ENSMUSG00000022443', u'ENSMUSG00000035863', u'ENSMUSG00000030707', u'ENSMUSG00000053646', u'ENSMUSG00000053158', u'ENSMUSG00000024621', u'ENSMUSG00000024232', u'ENSMUSG00000000149', u'ENSMUSG00000015766', u'ENSMUSG00000038668', u'ENSMUSG00000030498', u'ENSMUSG00000054150', u'ENSMUSG00000052397', u'ENSMUSG00000039629', u'ENSMUSG00000028583', u'ENSMUSG00000034974', u'ENSMUSG00000025239', u'ENSMUSG00000031523', u'ENSMUSG00000022607', u'ENSMUSG00000059456', u'ENSMUSG00000028906', u'ENSMUSG00000028874', u'ENSMUSG00000033208', u'ENSMUSG00000049521', u'ENSMUSG00000038013', u'ENSMUSG00000063663', u'ENSMUSG00000025372', u'ENSMUSG00000015599', u'ENSMUSG00000055805', u'ENSMUSG00000052298', u'ENSMUSG00000090100', u'ENSMUSG00000040990', u'ENSMUSG00000034868', u'ENSMUSG00000031207', u'ENSMUSG00000022272', u'ENSMUSG00000039960', u'ENSMUSG00000025162', u'ENSMUSG00000045664', u'ENSMUSG00000075284', u'ENSMUSG00000032050', u'ENSMUSG00000015745', u'ENSMUSG00000046768', u'ENSMUSG00000024044', u'ENSMUSG00000025348', u'ENSMUSG00000062960', u'ENSMUSG00000023951', u'ENSMUSG00000019978', u'ENSMUSG00000030739', u'ENSMUSG00000005103', u'ENSMUSG00000035385', u'ENSMUSG00000049744', u'ENSMUSG00000041598', u'ENSMUSG00000024143']), pop_n=13836, p_sm_bonferroni=0.20009501000389707, is_obsolete=False, GO='GO:0008360', name='regulation of cell shape', pop_count=116, alt_ids=['GO:0045788', 'GO:0045789'], level=3, depth=6, enrichment='e', Cluster='Late Increase', geneid_set=set([u'ENSMUSG00000024048', u'ENSMUSG00000039031', u'ENSMUSG00000031385', u'ENSMUSG00000000149', u'ENSMUSG00000026830', u'ENSMUSG00000052397', u'ENSMUSG00000022272', u'ENSMUSG00000042312', u'ENSMUSG00000026193', u'ENSMUSG00000041598', u'ENSMUSG00000039960', u'ENSMUSG00000025239', u'ENSMUSG00000019978', u'ENSMUSG00000023008', u'ENSMUSG00000030739', u'ENSMUSG00000036606', u'ENSMUSG00000053646', u'ENSMUSG00000053158', u'ENSMUSG00000028874', u'ENSMUSG00000033208', u'ENSMUSG00000049521', u'ENSMUSG00000075284', u'ENSMUSG00000028583', u'ENSMUSG00000032050', u'ENSMUSG00000024143', u'ENSMUSG00000020611', u'ENSMUSG00000020733', u'ENSMUSG00000015745']), symbols=u'Arhgap18 Cdc42ep1 Cdc42ep4 Epb41l2 Ermn Ezr Fes Fgr Fmnl3 Fn1 Gna12 Gna13 Limd1 Myh14 Myl12a Myo10 Pdpn Plekho1 Plxnb1 Plxnb2 Plxnb3 Rdx Rhoq Rhou S100a13 S100b Slc9a3r1 Wipf1', symbol_set=set([u'Fn1', u'Pdpn', u'Fes', u'Wipf1', u'Arhgap18', u'Plxnb2', u'Plxnb3', 'Epb41l2', u'Myl12a', u'Rhoq', u'Rhou', u'Gna12', u'Gna13', u'S100a13', u'S100b', u'Myh14', u'Fmnl3', u'Cdc42ep1', u'Rdx', u'Cdc42ep4', u'Plxnb1', u'Limd1', u'Plekho1', u'Ermn', u'Ezr', u'Myo10', u'Slc9a3r1', u'Fgr']), geneids='ENSMUSG00000049521 ENSMUSG00000031385 ENSMUSG00000052397 ENSMUSG00000042312 ENSMUSG00000026193 ENSMUSG00000022272 ENSMUSG00000039960 ENSMUSG00000053646 ENSMUSG00000053158 ENSMUSG00000036606 ENSMUSG00000075284 ENSMUSG00000028583 ENSMUSG00000032050 ENSMUSG00000020611 ENSMUSG00000020733 ENSMUSG00000015745 ENSMUSG00000024048 ENSMUSG00000039031 ENSMUSG00000000149 ENSMUSG00000026830 ENSMUSG00000025239 ENSMUSG00000019978 ENSMUSG00000023008 ENSMUSG00000030739 ENSMUSG00000028874 ENSMUSG00000033208 ENSMUSG00000041598 ENSMUSG00000024143', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=27, D1='A', GO_name='regulation of cell shape'),
    Nt(p_uncorrected=6.729307650236889e-05, study_count=6, study_n=1397, namespace='biological_process', p_fdr_bh=0.008932395565025017, study_items=set([u'ENSMUSG00000028603', u'ENSMUSG00000021242', u'ENSMUSG00000024030', u'ENSMUSG00000024413', u'ENSMUSG00000035237', u'ENSMUSG00000015243']), NS='BP', pop_items=set([u'ENSMUSG00000028603', u'ENSMUSG00000021242', u'ENSMUSG00000032193', u'ENSMUSG00000009907', u'ENSMUSG00000037936', u'ENSMUSG00000024030', u'ENSMUSG00000024413', u'ENSMUSG00000035237', u'ENSMUSG00000015243']), pop_n=13836, p_sm_bonferroni=1.0, is_obsolete=False, GO='GO:0030301', name='cholesterol transport', pop_count=9, alt_ids=[], level=6, depth=7, enrichment='e', Cluster='Late Increase', geneid_set=set([u'ENSMUSG00000028603', u'ENSMUSG00000024030', u'ENSMUSG00000021242', u'ENSMUSG00000024413', u'ENSMUSG00000035237', u'ENSMUSG00000015243']), symbols=u'Abca1 Abcg1 Lcat Npc1 Npc2 Scp2', symbol_set=set([u'Abcg1', u'Lcat', u'Scp2', u'Npc2', u'Npc1', u'Abca1']), geneids='ENSMUSG00000015243 ENSMUSG00000021242 ENSMUSG00000024030 ENSMUSG00000024413 ENSMUSG00000035237 ENSMUSG00000028603', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=9, D1='CG', GO_name='cholesterol transport'),
    Nt(p_uncorrected=0.0003094455308920858, study_count=6, study_n=1397, namespace='biological_process', p_fdr_bh=0.028243429147867424, study_items=set([u'ENSMUSG00000015243', u'ENSMUSG00000002985', u'ENSMUSG00000017754', u'ENSMUSG00000021025', u'ENSMUSG00000024030', u'ENSMUSG00000060601']), NS='BP', pop_items=set([u'ENSMUSG00000040249', u'ENSMUSG00000021466', u'ENSMUSG00000015243', u'ENSMUSG00000035722', u'ENSMUSG00000002108', u'ENSMUSG00000002985', u'ENSMUSG00000017754', u'ENSMUSG00000020063', u'ENSMUSG00000021025', u'ENSMUSG00000024030', u'ENSMUSG00000060601']), pop_n=13836, p_sm_bonferroni=1.0, is_obsolete=False, GO='GO:0010875', name='positive regulation of cholesterol efflux', pop_count=11, alt_ids=[], level=8, depth=9, enrichment='e', Cluster='Late Increase', geneid_set=set([u'ENSMUSG00000002985', u'ENSMUSG00000017754', u'ENSMUSG00000015243', u'ENSMUSG00000021025', u'ENSMUSG00000024030', u'ENSMUSG00000060601']), symbols=u'Abca1 Abcg1 Apoe Nfkbia Nr1h2 Pltp', symbol_set=set([u'Abcg1', u'Apoe', u'Nfkbia', u'Pltp', u'Abca1', u'Nr1h2']), geneids='ENSMUSG00000015243 ENSMUSG00000002985 ENSMUSG00000017754 ENSMUSG00000021025 ENSMUSG00000024030 ENSMUSG00000060601', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=0, D1='A', GO_name='positive regulation of cholesterol efflux'),
    Nt(p_uncorrected='', study_count='', study_n='', namespace='', p_fdr_bh='', study_items='', NS='BP', pop_items='', pop_n='', p_sm_bonferroni='', is_obsolete='', GO='GO:0045791', name='', pop_count='', alt_ids='', level=4, depth=5, enrichment='', Cluster='', geneid_set='', symbols='', symbol_set='', geneids='', format_txt=1, hdr_idx=1, is_hdrgo=True, is_usrgo=False, hdr1usr01='*', dcnt=46, D1='BCEH', GO_name='cell morphogenesis'),
    Nt(p_uncorrected=0.0005604058041305602, study_count=3, study_n=1397, namespace='biological_process', p_fdr_bh=0.042041256248140695, study_items=set([u'ENSMUSG00000003559', u'ENSMUSG00000022842', u'ENSMUSG00000000326']), NS='BP', pop_items=set([u'ENSMUSG00000029004', u'ENSMUSG00000026492', u'ENSMUSG00000030350', u'ENSMUSG00000051062', u'ENSMUSG00000020691', u'ENSMUSG00000027384', u'ENSMUSG00000041975', u'ENSMUSG00000029206', u'ENSMUSG00000031671', u'ENSMUSG00000004268', u'ENSMUSG00000037134', u'ENSMUSG00000050312', u'ENSMUSG00000059851', u'ENSMUSG00000018809', u'ENSMUSG00000026707', u'ENSMUSG00000028331', u'ENSMUSG00000039231', u'ENSMUSG00000029687', u'ENSMUSG00000021891', u'ENSMUSG00000028233', u'ENSMUSG00000049882', u'ENSMUSG00000056770', u'ENSMUSG00000039662', u'ENSMUSG00000039660', u'ENSMUSG00000057406', u'ENSMUSG00000055660', u'ENSMUSG00000021488', u'ENSMUSG00000021951', u'ENSMUSG00000022160', u'ENSMUSG00000030960', u'ENSMUSG00000022842', u'ENSMUSG00000006920', u'ENSMUSG00000038056', u'ENSMUSG00000041396', u'ENSMUSG00000006307', u'ENSMUSG00000028247', u'ENSMUSG00000029097', u'ENSMUSG00000033706', u'ENSMUSG00000036983', u'ENSMUSG00000033439', u'ENSMUSG00000004561', u'ENSMUSG00000046441', u'ENSMUSG00000035529', u'ENSMUSG00000033554', u'ENSMUSG00000034639', u'ENSMUSG00000010554', u'ENSMUSG00000042742', u'ENSMUSG00000057234', u'ENSMUSG00000035601', u'ENSMUSG00000021773', u'ENSMUSG00000038046', u'ENSMUSG00000040557', u'ENSMUSG00000049300', u'ENSMUSG00000030264', u'ENSMUSG00000026723', u'ENSMUSG00000054619', u'ENSMUSG00000039345', u'ENSMUSG00000004099', u'ENSMUSG00000032579', u'ENSMUSG00000022544', u'ENSMUSG00000035456', u'ENSMUSG00000048154', u'ENSMUSG00000005378', u'ENSMUSG00000026603', u'ENSMUSG00000025956', u'ENSMUSG00000042496', u'ENSMUSG00000026857', u'ENSMUSG00000029557', u'ENSMUSG00000074890', u'ENSMUSG00000032185', u'ENSMUSG00000044763', u'ENSMUSG00000034442', u'ENSMUSG00000021595', u'ENSMUSG00000062198', u'ENSMUSG00000025899', u'ENSMUSG00000026694', u'ENSMUSG00000002028', u'ENSMUSG00000030888', u'ENSMUSG00000001909', u'ENSMUSG00000037525', u'ENSMUSG00000075028', u'ENSMUSG00000036009', u'ENSMUSG00000006732', u'ENSMUSG00000020150', u'ENSMUSG00000020706', u'ENSMUSG00000020230', u'ENSMUSG00000039620', u'ENSMUSG00000018405', u'ENSMUSG00000061759', u'ENSMUSG00000049327', u'ENSMUSG00000090266', u'ENSMUSG00000021311', u'ENSMUSG00000021692', u'ENSMUSG00000026986', u'ENSMUSG00000024246', u'ENSMUSG00000024082', u'ENSMUSG00000028706', u'ENSMUSG00000000326', u'ENSMUSG00000041733', u'ENSMUSG00000022721', u'ENSMUSG00000020661', u'ENSMUSG00000062937', u'ENSMUSG00000071037', u'ENSMUSG00000019795', u'ENSMUSG00000024019', u'ENSMUSG00000019792', u'ENSMUSG00000038279', u'ENSMUSG00000030505', u'ENSMUSG00000071350', u'ENSMUSG00000060950', u'ENSMUSG00000013787', u'ENSMUSG00000023110', u'ENSMUSG00000024726', u'ENSMUSG00000029726', u'ENSMUSG00000060098', u'ENSMUSG00000051730', u'ENSMUSG00000044791', u'ENSMUSG00000038646', u'ENSMUSG00000054823', u'ENSMUSG00000009535', u'ENSMUSG00000047583', u'ENSMUSG00000028053', u'ENSMUSG00000045098', u'ENSMUSG00000026646', u'ENSMUSG00000021376', u'ENSMUSG00000055067', u'ENSMUSG00000036893', u'ENSMUSG00000028114', u'ENSMUSG00000037111', u'ENSMUSG00000000916', u'ENSMUSG00000053286', u'ENSMUSG00000003559', u'ENSMUSG00000038384', u'ENSMUSG00000029179', u'ENSMUSG00000015697', u'ENSMUSG00000029913', u'ENSMUSG00000004127', u'ENSMUSG00000022948', u'ENSMUSG00000067369', u'ENSMUSG00000025747']), pop_n=13836, p_sm_bonferroni=1.0, is_obsolete=False, GO='GO:0032259', name='methylation', pop_count=140, alt_ids=[], level=2, depth=2, enrichment='p', Cluster='Late Increase', geneid_set=set([u'ENSMUSG00000003559', u'ENSMUSG00000022842', u'ENSMUSG00000000326']), symbols=u'As3mt Comt Ece2', symbol_set=set([u'Comt', u'As3mt', u'Ece2']), geneids='ENSMUSG00000003559 ENSMUSG00000022842 ENSMUSG00000000326', format_txt=1, hdr_idx=1, is_hdrgo=True, is_usrgo=True, hdr1usr01='**', dcnt=120, D1='D', GO_name='methylation'),
    Nt(p_uncorrected='', study_count='', study_n='', namespace='', p_fdr_bh='', study_items='', NS='BP', pop_items='', pop_n='', p_sm_bonferroni='', is_obsolete='', GO='GO:0016192', name='', pop_count='', alt_ids='', level=4, depth=4, enrichment='', Cluster='', geneid_set='', symbols='', symbol_set='', geneids='', format_txt=1, hdr_idx=1, is_hdrgo=True, is_usrgo=False, hdr1usr01='*', dcnt=139, D1='G', GO_name='vesicle-mediated transport'),
    Nt(p_uncorrected=0.000466815928665906, study_count=17, study_n=1397, namespace='biological_process', p_fdr_bh=0.0381597084052771, study_items=set([u'ENSMUSG00000048402', u'ENSMUSG00000040711', u'ENSMUSG00000052430', u'ENSMUSG00000004894', u'ENSMUSG00000000567', u'ENSMUSG00000007613', u'ENSMUSG00000041235', u'ENSMUSG00000029661', u'ENSMUSG00000024940', u'ENSMUSG00000024330', u'ENSMUSG00000021614', u'ENSMUSG00000004892', u'ENSMUSG00000025352', u'ENSMUSG00000027808', u'ENSMUSG00000050335', u'ENSMUSG00000027339', u'ENSMUSG00000001506']), NS='BP', pop_items=set([u'ENSMUSG00000026739', u'ENSMUSG00000021665', u'ENSMUSG00000050295', u'ENSMUSG00000018604', u'ENSMUSG00000079317', u'ENSMUSG00000044177', u'ENSMUSG00000007613', u'ENSMUSG00000025854', u'ENSMUSG00000057123', u'ENSMUSG00000033762', u'ENSMUSG00000004894', u'ENSMUSG00000034781', u'ENSMUSG00000024330', u'ENSMUSG00000004892', u'ENSMUSG00000025352', u'ENSMUSG00000002799', u'ENSMUSG00000048402', u'ENSMUSG00000026313', u'ENSMUSG00000022206', u'ENSMUSG00000050335', u'ENSMUSG00000007594', u'ENSMUSG00000048616', u'ENSMUSG00000002603', u'ENSMUSG00000041235', u'ENSMUSG00000029661', u'ENSMUSG00000006445', u'ENSMUSG00000038000', u'ENSMUSG00000026042', u'ENSMUSG00000032402', u'ENSMUSG00000022952', u'ENSMUSG00000027523', u'ENSMUSG00000001506', u'ENSMUSG00000063632', u'ENSMUSG00000032492', u'ENSMUSG00000006958', u'ENSMUSG00000066324', u'ENSMUSG00000032179', u'ENSMUSG00000002103', u'ENSMUSG00000076431', u'ENSMUSG00000028053', u'ENSMUSG00000008090', u'ENSMUSG00000026917', u'ENSMUSG00000006932', u'ENSMUSG00000039239', u'ENSMUSG00000039153', u'ENSMUSG00000066687', u'ENSMUSG00000024940', u'ENSMUSG00000061393', u'ENSMUSG00000031668', u'ENSMUSG00000062115', u'ENSMUSG00000028560', u'ENSMUSG00000027339', u'ENSMUSG00000057322', u'ENSMUSG00000032368', u'ENSMUSG00000040711', u'ENSMUSG00000052430', u'ENSMUSG00000024247', u'ENSMUSG00000000567', u'ENSMUSG00000027808', u'ENSMUSG00000037664', u'ENSMUSG00000022483', u'ENSMUSG00000002341', u'ENSMUSG00000025232', u'ENSMUSG00000021613', u'ENSMUSG00000054452', u'ENSMUSG00000021835', u'ENSMUSG00000021614', u'ENSMUSG00000027204', u'ENSMUSG00000024639', u'ENSMUSG00000063172']), pop_n=13836, p_sm_bonferroni=1.0, is_obsolete=False, GO='GO:0001501', name='skeletal system development', pop_count=70, alt_ids=[], level=4, depth=4, enrichment='e', Cluster='Late Increase', geneid_set=set([u'ENSMUSG00000004894', u'ENSMUSG00000024330', u'ENSMUSG00000004892', u'ENSMUSG00000025352', u'ENSMUSG00000050335', u'ENSMUSG00000027339', u'ENSMUSG00000001506', u'ENSMUSG00000048402', u'ENSMUSG00000040711', u'ENSMUSG00000052430', u'ENSMUSG00000000567', u'ENSMUSG00000024940', u'ENSMUSG00000041235', u'ENSMUSG00000029661', u'ENSMUSG00000007613', u'ENSMUSG00000021614', u'ENSMUSG00000027808']), symbols=u'Bcan Bmpr1b Chd7 Col11a2 Col1a1 Col1a2 Gdf11 Gli2 Hapln2 Lgals3 Ltbp3 Rassf2 Serp1 Sh3pxd2b Sox9 Tgfbr1 Vcan', symbol_set=set([u'Bcan', u'Tgfbr1', u'Ltbp3', u'Chd7', u'Col11a2', u'Rassf2', u'Vcan', u'Serp1', u'Gli2', u'Sh3pxd2b', u'Bmpr1b', u'Sox9', u'Col1a2', u'Col1a1', u'Lgals3', u'Gdf11', u'Hapln2']), geneids='ENSMUSG00000048402 ENSMUSG00000024940 ENSMUSG00000040711 ENSMUSG00000050335 ENSMUSG00000000567 ENSMUSG00000007613 ENSMUSG00000052430 ENSMUSG00000027808 ENSMUSG00000041235 ENSMUSG00000024330 ENSMUSG00000004894 ENSMUSG00000029661 ENSMUSG00000021614 ENSMUSG00000004892 ENSMUSG00000025352 ENSMUSG00000001506 ENSMUSG00000027339', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=2, D1='E', GO_name='skeletal system development'),
    Nt(p_uncorrected=8.343432165785023e-06, study_count=21, study_n=1397, namespace='biological_process', p_fdr_bh=0.0016206582146642166, study_items=set([u'ENSMUSG00000020053', u'ENSMUSG00000027253', u'ENSMUSG00000022309', u'ENSMUSG00000017344', u'ENSMUSG00000015133', u'ENSMUSG00000024610', u'ENSMUSG00000021702', u'ENSMUSG00000027293', u'ENSMUSG00000029999', u'ENSMUSG00000028864', u'ENSMUSG00000021457', u'ENSMUSG00000022781', u'ENSMUSG00000042453', u'ENSMUSG00000076617', u'ENSMUSG00000000058', u'ENSMUSG00000028517', u'ENSMUSG00000037706', u'ENSMUSG00000023992', u'ENSMUSG00000025809', u'ENSMUSG00000014932', u'ENSMUSG00000039005']), NS='BP', pop_items=set([u'ENSMUSG00000032911', u'ENSMUSG00000048583', u'ENSMUSG00000022831', u'ENSMUSG00000021732', u'ENSMUSG00000021451', u'ENSMUSG00000026842', u'ENSMUSG00000005087', u'ENSMUSG00000021457', u'ENSMUSG00000022781', u'ENSMUSG00000022425', u'ENSMUSG00000041936', u'ENSMUSG00000059552', u'ENSMUSG00000028517', u'ENSMUSG00000027954', u'ENSMUSG00000042453', u'ENSMUSG00000021702', u'ENSMUSG00000000555', u'ENSMUSG00000022309', u'ENSMUSG00000028613', u'ENSMUSG00000015133', u'ENSMUSG00000002603', u'ENSMUSG00000000489', u'ENSMUSG00000050310', u'ENSMUSG00000027646', u'ENSMUSG00000028864', u'ENSMUSG00000049107', u'ENSMUSG00000034997', u'ENSMUSG00000019966', u'ENSMUSG00000024142', u'ENSMUSG00000004815', u'ENSMUSG00000076617', u'ENSMUSG00000027253', u'ENSMUSG00000041135', u'ENSMUSG00000014932', u'ENSMUSG00000039005', u'ENSMUSG00000027944', u'ENSMUSG00000034394', u'ENSMUSG00000028059', u'ENSMUSG00000027947', u'ENSMUSG00000055737', u'ENSMUSG00000037405', u'ENSMUSG00000025809', u'ENSMUSG00000029231', u'ENSMUSG00000029999', u'ENSMUSG00000021549', u'ENSMUSG00000055022', u'ENSMUSG00000024789', u'ENSMUSG00000022791', u'ENSMUSG00000003068', u'ENSMUSG00000024962', u'ENSMUSG00000027293', u'ENSMUSG00000029217', u'ENSMUSG00000031980', u'ENSMUSG00000042228', u'ENSMUSG00000023951', u'ENSMUSG00000020689', u'ENSMUSG00000023992', u'ENSMUSG00000028991', u'ENSMUSG00000068748', u'ENSMUSG00000024486', u'ENSMUSG00000033307', u'ENSMUSG00000025810', u'ENSMUSG00000054252', u'ENSMUSG00000062991', u'ENSMUSG00000059456', u'ENSMUSG00000020053', u'ENSMUSG00000017344', u'ENSMUSG00000032532', u'ENSMUSG00000024610', u'ENSMUSG00000037706', u'ENSMUSG00000047139', u'ENSMUSG00000060216', u'ENSMUSG00000000058', u'ENSMUSG00000048915']), pop_n=13836, p_sm_bonferroni=0.1264113407438089, is_obsolete=False, GO='GO:0050731', name='positive regulation of peptidyl-tyrosine phosphorylation', pop_count=74, alt_ids=[], level=9, depth=10, enrichment='e', Cluster='Late Increase', geneid_set=set([u'ENSMUSG00000020053', u'ENSMUSG00000021702', u'ENSMUSG00000037706', u'ENSMUSG00000029999', u'ENSMUSG00000021457', u'ENSMUSG00000022781', u'ENSMUSG00000027293', u'ENSMUSG00000028517', u'ENSMUSG00000023992', u'ENSMUSG00000022309', u'ENSMUSG00000017344', u'ENSMUSG00000024610', u'ENSMUSG00000025809', u'ENSMUSG00000028864', u'ENSMUSG00000014932', u'ENSMUSG00000042453', u'ENSMUSG00000015133', u'ENSMUSG00000076617', u'ENSMUSG00000027253', u'ENSMUSG00000000058', u'ENSMUSG00000039005']), symbols=u'Angpt1 Cav2 Cd74 Cd81 Ehd4 Hgf Igf1 Ighm Itgb1 Lrp4 Lrrk1 Pak2 Plpp3 Reln Syk Tgfa Thbs4 Tlr4 Trem2 Vtn Yes1', symbol_set=set([u'Tgfa', u'Cd74', 'Plpp3', u'Igf1', u'Lrrk1', u'Lrp4', u'Cd81', u'Thbs4', u'Vtn', u'Syk', u'Ehd4', u'Yes1', u'Tlr4', u'Trem2', u'Hgf', u'Itgb1', u'Angpt1', u'Cav2', u'Ighm', u'Pak2', u'Reln']), geneids='ENSMUSG00000020053 ENSMUSG00000029999 ENSMUSG00000027253 ENSMUSG00000022309 ENSMUSG00000017344 ENSMUSG00000028517 ENSMUSG00000024610 ENSMUSG00000021702 ENSMUSG00000027293 ENSMUSG00000025809 ENSMUSG00000028864 ENSMUSG00000021457 ENSMUSG00000022781 ENSMUSG00000042453 ENSMUSG00000076617 ENSMUSG00000015133 ENSMUSG00000014932 ENSMUSG00000023992 ENSMUSG00000037706 ENSMUSG00000000058 ENSMUSG00000039005', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=17, D1='A', GO_name='positive regulation of peptidyl-tyrosine phosphorylation'),
    Nt(p_uncorrected=8.77365150954995e-07, study_count=49, study_n=1397, namespace='biological_process', p_fdr_bh=0.00027693665421081517, study_items=set([u'ENSMUSG00000029771', u'ENSMUSG00000052384', u'ENSMUSG00000000732', u'ENSMUSG00000038521', u'ENSMUSG00000013707', u'ENSMUSG00000021457', u'ENSMUSG00000017707', u'ENSMUSG00000036887', u'ENSMUSG00000024371', u'ENSMUSG00000050335', u'ENSMUSG00000026285', u'ENSMUSG00000044811', u'ENSMUSG00000026471', u'ENSMUSG00000004730', u'ENSMUSG00000003184', u'ENSMUSG00000032035', u'ENSMUSG00000023224', u'ENSMUSG00000037523', u'ENSMUSG00000036908', u'ENSMUSG00000028874', u'ENSMUSG00000034652', u'ENSMUSG00000022575', u'ENSMUSG00000039005', u'ENSMUSG00000058818', u'ENSMUSG00000060591', u'ENSMUSG00000020573', u'ENSMUSG00000029915', u'ENSMUSG00000022901', u'ENSMUSG00000024164', u'ENSMUSG00000033777', u'ENSMUSG00000059883', u'ENSMUSG00000051212', u'ENSMUSG00000044583', u'ENSMUSG00000060586', u'ENSMUSG00000002602', u'ENSMUSG00000078942', u'ENSMUSG00000023990', u'ENSMUSG00000078945', u'ENSMUSG00000025702', u'ENSMUSG00000051439', u'ENSMUSG00000024610', u'ENSMUSG00000044827', u'ENSMUSG00000020399', u'ENSMUSG00000004707', u'ENSMUSG00000026288', u'ENSMUSG00000026365', u'ENSMUSG00000038495', u'ENSMUSG00000032737', u'ENSMUSG00000038147']), NS='BP', pop_items=set([u'ENSMUSG00000035834', u'ENSMUSG00000045322', u'ENSMUSG00000028874', u'ENSMUSG00000004730', u'ENSMUSG00000021703', u'ENSMUSG00000024079', u'ENSMUSG00000074151', u'ENSMUSG00000060586', u'ENSMUSG00000016481', u'ENSMUSG00000024338', u'ENSMUSG00000055172', u'ENSMUSG00000036887', u'ENSMUSG00000009585', u'ENSMUSG00000031805', u'ENSMUSG00000022476', u'ENSMUSG00000024371', u'ENSMUSG00000042228', u'ENSMUSG00000017707', u'ENSMUSG00000032035', u'ENSMUSG00000071369', u'ENSMUSG00000026399', u'ENSMUSG00000037523', u'ENSMUSG00000038628', u'ENSMUSG00000020115', u'ENSMUSG00000000776', u'ENSMUSG00000019843', u'ENSMUSG00000015217', u'ENSMUSG00000035629', u'ENSMUSG00000039748', u'ENSMUSG00000039236', u'ENSMUSG00000049686', u'ENSMUSG00000024164', u'ENSMUSG00000035279', u'ENSMUSG00000024045', u'ENSMUSG00000038128', u'ENSMUSG00000075705', u'ENSMUSG00000041187', u'ENSMUSG00000038517', u'ENSMUSG00000046034', u'ENSMUSG00000062593', u'ENSMUSG00000029605', u'ENSMUSG00000026896', u'ENSMUSG00000037321', u'ENSMUSG00000037649', u'ENSMUSG00000014599', u'ENSMUSG00000000275', u'ENSMUSG00000024789', u'ENSMUSG00000051439', u'ENSMUSG00000038058', u'ENSMUSG00000025512', u'ENSMUSG00000050199', u'ENSMUSG00000034889', u'ENSMUSG00000024621', u'ENSMUSG00000027951', u'ENSMUSG00000020437', u'ENSMUSG00000070390', u'ENSMUSG00000036986', u'ENSMUSG00000030751', u'ENSMUSG00000025139', u'ENSMUSG00000000134', u'ENSMUSG00000026883', u'ENSMUSG00000015837', u'ENSMUSG00000032691', u'ENSMUSG00000018446', u'ENSMUSG00000018899', u'ENSMUSG00000028885', u'ENSMUSG00000029826', u'ENSMUSG00000028633', u'ENSMUSG00000027646', u'ENSMUSG00000003184', u'ENSMUSG00000047123', u'ENSMUSG00000024767', u'ENSMUSG00000016024', u'ENSMUSG00000054072', u'ENSMUSG00000036908', u'ENSMUSG00000037860', u'ENSMUSG00000036905', u'ENSMUSG00000032312', u'ENSMUSG00000061232', u'ENSMUSG00000001123', u'ENSMUSG00000031392', u'ENSMUSG00000028099', u'ENSMUSG00000055204', u'ENSMUSG00000022901', u'ENSMUSG00000045932', u'ENSMUSG00000033777', u'ENSMUSG00000059883', u'ENSMUSG00000027598', u'ENSMUSG00000030263', u'ENSMUSG00000039936', u'ENSMUSG00000003283', u'ENSMUSG00000051212', u'ENSMUSG00000044583', u'ENSMUSG00000023915', u'ENSMUSG00000002688', u'ENSMUSG00000022636', u'ENSMUSG00000021583', u'ENSMUSG00000078942', u'ENSMUSG00000031838', u'ENSMUSG00000078945', u'ENSMUSG00000025702', u'ENSMUSG00000027639', u'ENSMUSG00000033307', u'ENSMUSG00000024610', u'ENSMUSG00000000787', u'ENSMUSG00000034453', u'ENSMUSG00000026288', u'ENSMUSG00000028793', u'ENSMUSG00000034218', u'ENSMUSG00000023990', u'ENSMUSG00000025532', u'ENSMUSG00000060550', u'ENSMUSG00000000386', u'ENSMUSG00000052384', u'ENSMUSG00000070034', u'ENSMUSG00000028064', u'ENSMUSG00000027427', u'ENSMUSG00000026928', u'ENSMUSG00000000732', u'ENSMUSG00000020399', u'ENSMUSG00000046718', u'ENSMUSG00000013707', u'ENSMUSG00000030793', u'ENSMUSG00000021457', u'ENSMUSG00000074896', u'ENSMUSG00000024948', u'ENSMUSG00000031639', u'ENSMUSG00000020823', u'ENSMUSG00000025498', u'ENSMUSG00000047798', u'ENSMUSG00000026285', u'ENSMUSG00000032508', u'ENSMUSG00000024339', u'ENSMUSG00000002602', u'ENSMUSG00000053647', u'ENSMUSG00000060591', u'ENSMUSG00000041439', u'ENSMUSG00000032076', u'ENSMUSG00000024235', u'ENSMUSG00000001150', u'ENSMUSG00000027508', u'ENSMUSG00000036896', u'ENSMUSG00000071203', u'ENSMUSG00000079547', u'ENSMUSG00000030880', u'ENSMUSG00000041135', u'ENSMUSG00000024392', u'ENSMUSG00000022575', u'ENSMUSG00000021624', u'ENSMUSG00000020707', u'ENSMUSG00000038213', u'ENSMUSG00000057058', u'ENSMUSG00000027514', u'ENSMUSG00000037731', u'ENSMUSG00000030122', u'ENSMUSG00000024349', u'ENSMUSG00000033454', u'ENSMUSG00000022514', u'ENSMUSG00000022887', u'ENSMUSG00000036469', u'ENSMUSG00000023973', u'ENSMUSG00000043496', u'ENSMUSG00000020573', u'ENSMUSG00000034652', u'ENSMUSG00000036712', u'ENSMUSG00000025492', u'ENSMUSG00000032109', u'ENSMUSG00000060802', u'ENSMUSG00000029798', u'ENSMUSG00000032344', u'ENSMUSG00000059456', u'ENSMUSG00000026117', u'ENSMUSG00000040296', u'ENSMUSG00000032690', u'ENSMUSG00000040751', u'ENSMUSG00000032905', u'ENSMUSG00000020476', u'ENSMUSG00000004707', u'ENSMUSG00000038160', u'ENSMUSG00000038495', u'ENSMUSG00000001128', u'ENSMUSG00000029771', u'ENSMUSG00000058818', u'ENSMUSG00000040264', u'ENSMUSG00000056851', u'ENSMUSG00000032661', u'ENSMUSG00000067212', u'ENSMUSG00000038521', u'ENSMUSG00000036594', u'ENSMUSG00000031750', u'ENSMUSG00000022508', u'ENSMUSG00000073421', u'ENSMUSG00000041827', u'ENSMUSG00000050335', u'ENSMUSG00000044811', u'ENSMUSG00000026471', u'ENSMUSG00000017830', u'ENSMUSG00000019256', u'ENSMUSG00000023341', u'ENSMUSG00000023224', u'ENSMUSG00000015947', u'ENSMUSG00000020641', u'ENSMUSG00000026778', u'ENSMUSG00000039005', u'ENSMUSG00000026648', u'ENSMUSG00000028059', u'ENSMUSG00000028191', u'ENSMUSG00000054717', u'ENSMUSG00000038260', u'ENSMUSG00000046879', u'ENSMUSG00000021277', u'ENSMUSG00000030748', u'ENSMUSG00000033538', u'ENSMUSG00000028291', u'ENSMUSG00000029217', u'ENSMUSG00000051256', u'ENSMUSG00000066839', u'ENSMUSG00000073411', u'ENSMUSG00000005102', u'ENSMUSG00000029561', u'ENSMUSG00000029915', u'ENSMUSG00000027995', u'ENSMUSG00000044827', u'ENSMUSG00000043279', u'ENSMUSG00000027164', u'ENSMUSG00000026365', u'ENSMUSG00000032322', u'ENSMUSG00000032041', u'ENSMUSG00000034459', u'ENSMUSG00000045038', u'ENSMUSG00000021423', u'ENSMUSG00000038147', u'ENSMUSG00000052889', u'ENSMUSG00000050132', u'ENSMUSG00000032737']), pop_n=13836, p_sm_bonferroni=0.01329295940211913, is_obsolete=False, GO='GO:0002376', name='immune system process', pop_count=235, alt_ids=[], level=1, depth=1, enrichment='e', Cluster='Late Increase', geneid_set=set([u'ENSMUSG00000029771', u'ENSMUSG00000052384', u'ENSMUSG00000000732', u'ENSMUSG00000038521', u'ENSMUSG00000013707', u'ENSMUSG00000021457', u'ENSMUSG00000003184', u'ENSMUSG00000036887', u'ENSMUSG00000020399', u'ENSMUSG00000024371', u'ENSMUSG00000050335', u'ENSMUSG00000026285', u'ENSMUSG00000026288', u'ENSMUSG00000044811', u'ENSMUSG00000026471', u'ENSMUSG00000004730', u'ENSMUSG00000017707', u'ENSMUSG00000032035', u'ENSMUSG00000023224', u'ENSMUSG00000037523', u'ENSMUSG00000036908', u'ENSMUSG00000060586', u'ENSMUSG00000034652', u'ENSMUSG00000039005', u'ENSMUSG00000058818', u'ENSMUSG00000059883', u'ENSMUSG00000020573', u'ENSMUSG00000022901', u'ENSMUSG00000024164', u'ENSMUSG00000033777', u'ENSMUSG00000060591', u'ENSMUSG00000051212', u'ENSMUSG00000044583', u'ENSMUSG00000022575', u'ENSMUSG00000051439', u'ENSMUSG00000078942', u'ENSMUSG00000038495', u'ENSMUSG00000078945', u'ENSMUSG00000025702', u'ENSMUSG00000029915', u'ENSMUSG00000024610', u'ENSMUSG00000044827', u'ENSMUSG00000028874', u'ENSMUSG00000004707', u'ENSMUSG00000002602', u'ENSMUSG00000026365', u'ENSMUSG00000023990', u'ENSMUSG00000032737', u'ENSMUSG00000038147']), symbols=u'Adgre1 Axl C1qa C1s1 C2 C3 Cd14 Cd300a Cd300c2 Cd74 Cd84 Cd86 Cfh Clec5a Ets1 Fgr Gpr183 Gsdmd H2-Eb1 Havcr2 Icosl Ifitm2 Inpp5d Inppl1 Irak4 Irf3 Irf5 Lgals3 Ly9 March8 Mavs Mr1 Naip2 Naip6 Nrros Otud7b Pdcd1 Pik3cg Pirb Serinc3 Serping1 Syk Tfeb Tlr1 Tlr13 Tlr4 Tlr7 Tnfaip8l2 Unc93b1', symbol_set=set([u'Ifitm2', u'Cd84', u'Tnfaip8l2', 'Cd300c2', u'Naip6', 'Adgre1', u'Mr1', u'Naip2', u'Cd14', u'Tlr13', u'Fgr', u'Lgals3', u'Mavs', 'March8', u'Irak4', u'Irf3', u'Icosl', u'Irf5', u'Tfeb', u'Syk', u'Ly9', u'C1qa', u'Pik3cg', u'Tlr1', 'H2-Eb1', u'C3', u'C2', u'Havcr2', u'Tlr7', u'Cd74', u'Clec5a', 'Pirb', u'Cd86', u'Serping1', u'Inpp5d', u'Axl', u'Pdcd1', u'Otud7b', 'C1s1', u'Inppl1', u'Cfh', u'Gpr183', u'Gsdmd', u'Serinc3', u'Ets1', 'Nrros', u'Tlr4', u'Unc93b1', u'Cd300a']), geneids='ENSMUSG00000029771 ENSMUSG00000013707 ENSMUSG00000044811 ENSMUSG00000000732 ENSMUSG00000038495 ENSMUSG00000052384 ENSMUSG00000021457 ENSMUSG00000017707 ENSMUSG00000036887 ENSMUSG00000024371 ENSMUSG00000050335 ENSMUSG00000026285 ENSMUSG00000002602 ENSMUSG00000026471 ENSMUSG00000004730 ENSMUSG00000060591 ENSMUSG00000003184 ENSMUSG00000032035 ENSMUSG00000023224 ENSMUSG00000037523 ENSMUSG00000036908 ENSMUSG00000028874 ENSMUSG00000060586 ENSMUSG00000034652 ENSMUSG00000039005 ENSMUSG00000058818 ENSMUSG00000038521 ENSMUSG00000020573 ENSMUSG00000022901 ENSMUSG00000024164 ENSMUSG00000033777 ENSMUSG00000059883 ENSMUSG00000051212 ENSMUSG00000044583 ENSMUSG00000022575 ENSMUSG00000051439 ENSMUSG00000078942 ENSMUSG00000038147 ENSMUSG00000078945 ENSMUSG00000025702 ENSMUSG00000029915 ENSMUSG00000024610 ENSMUSG00000044827 ENSMUSG00000020399 ENSMUSG00000004707 ENSMUSG00000026288 ENSMUSG00000026365 ENSMUSG00000023990 ENSMUSG00000032737', format_txt=1, hdr_idx=1, is_hdrgo=True, is_usrgo=True, hdr1usr01='**', dcnt=572, D1='L', GO_name='immune system process'),
    Nt(p_uncorrected=0.0003532773969541797, study_count=10, study_n=1397, namespace='biological_process', p_fdr_bh=0.031301203750016236, study_items=set([u'ENSMUSG00000026674', u'ENSMUSG00000024529', u'ENSMUSG00000024087', u'ENSMUSG00000032231', u'ENSMUSG00000024330', u'ENSMUSG00000007613', u'ENSMUSG00000029661', u'ENSMUSG00000001506', u'ENSMUSG00000070436', u'ENSMUSG00000026043']), NS='BP', pop_items=set([u'ENSMUSG00000026674', u'ENSMUSG00000050295', u'ENSMUSG00000020716', u'ENSMUSG00000029661', u'ENSMUSG00000028641', u'ENSMUSG00000036446', u'ENSMUSG00000061013', u'ENSMUSG00000030607', u'ENSMUSG00000024330', u'ENSMUSG00000034205', u'ENSMUSG00000026042', u'ENSMUSG00000026043', u'ENSMUSG00000001506', u'ENSMUSG00000027966', u'ENSMUSG00000039239', u'ENSMUSG00000026837', u'ENSMUSG00000024529', u'ENSMUSG00000036545', u'ENSMUSG00000033792', u'ENSMUSG00000022371', u'ENSMUSG00000033327', u'ENSMUSG00000024087', u'ENSMUSG00000032231', u'ENSMUSG00000022483', u'ENSMUSG00000019916', u'ENSMUSG00000007613', u'ENSMUSG00000004846', u'ENSMUSG00000070436', u'ENSMUSG00000038224']), pop_n=13836, p_sm_bonferroni=1.0, is_obsolete=False, GO='GO:0030199', name='collagen fibril organization', pop_count=29, alt_ids=[], level=4, depth=5, enrichment='e', Cluster='Late Increase', geneid_set=set([u'ENSMUSG00000026674', u'ENSMUSG00000024529', u'ENSMUSG00000024087', u'ENSMUSG00000032231', u'ENSMUSG00000024330', u'ENSMUSG00000007613', u'ENSMUSG00000029661', u'ENSMUSG00000001506', u'ENSMUSG00000070436', u'ENSMUSG00000026043']), symbols=u'Anxa2 Col11a2 Col1a1 Col1a2 Col3a1 Cyp1b1 Ddr2 Lox Serpinh1 Tgfbr1', symbol_set=set([u'Tgfbr1', u'Anxa2', u'Cyp1b1', u'Col11a2', u'Ddr2', u'Col1a2', u'Col1a1', u'Col3a1', u'Lox', u'Serpinh1']), geneids='ENSMUSG00000026674 ENSMUSG00000024529 ENSMUSG00000024087 ENSMUSG00000032231 ENSMUSG00000029661 ENSMUSG00000024330 ENSMUSG00000007613 ENSMUSG00000026043 ENSMUSG00000001506 ENSMUSG00000070436', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=0, D1='BCH', GO_name='collagen fibril organization'),
    Nt(p_uncorrected=0.00047594319969878284, study_count=4, study_n=1397, namespace='biological_process', p_fdr_bh=0.0381597084052771, study_items=set([u'ENSMUSG00000042010', u'ENSMUSG00000060601', u'ENSMUSG00000042349', u'ENSMUSG00000024164']), NS='BP', pop_items=set([u'ENSMUSG00000039428', u'ENSMUSG00000024164', u'ENSMUSG00000060601', u'ENSMUSG00000042349', u'ENSMUSG00000042010']), pop_n=13836, p_sm_bonferroni=1.0, is_obsolete=False, GO='GO:0010884', name='positive regulation of lipid storage', pop_count=5, alt_ids=[], level=4, depth=5, enrichment='e', Cluster='Late Increase', geneid_set=set([u'ENSMUSG00000024164', u'ENSMUSG00000060601', u'ENSMUSG00000042349', u'ENSMUSG00000042010']), symbols=u'Acacb C3 Ikbke Nr1h2', symbol_set=set([u'C3', u'Acacb', u'Nr1h2', u'Ikbke']), geneids='ENSMUSG00000060601 ENSMUSG00000042010 ENSMUSG00000042349 ENSMUSG00000024164', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=2, D1='A', GO_name='positive regulation of lipid storage'),
    Nt(p_uncorrected=0.0005660627202574551, study_count=6, study_n=1397, namespace='biological_process', p_fdr_bh=0.042041256248140695, study_items=set([u'ENSMUSG00000027878', u'ENSMUSG00000035158', u'ENSMUSG00000024940', u'ENSMUSG00000027339', u'ENSMUSG00000024913', u'ENSMUSG00000037370']), NS='BP', pop_items=set([u'ENSMUSG00000027878', u'ENSMUSG00000030201', u'ENSMUSG00000035158', u'ENSMUSG00000027164', u'ENSMUSG00000006445', u'ENSMUSG00000024940', u'ENSMUSG00000050199', u'ENSMUSG00000003070', u'ENSMUSG00000049511', u'ENSMUSG00000027339', u'ENSMUSG00000024913', u'ENSMUSG00000037370']), pop_n=13836, p_sm_bonferroni=1.0, is_obsolete=False, GO='GO:0046849', name='bone remodeling', pop_count=12, alt_ids=[], level=4, depth=4, enrichment='e', Cluster='Late Increase', geneid_set=set([u'ENSMUSG00000027878', u'ENSMUSG00000024940', u'ENSMUSG00000027339', u'ENSMUSG00000035158', u'ENSMUSG00000024913', u'ENSMUSG00000037370']), symbols=u'Enpp1 Lrp5 Ltbp3 Mitf Notch2 Rassf2', symbol_set=set([u'Ltbp3', u'Lrp5', u'Rassf2', u'Notch2', u'Enpp1', u'Mitf']), geneids='ENSMUSG00000027878 ENSMUSG00000035158 ENSMUSG00000024940 ENSMUSG00000027339 ENSMUSG00000024913 ENSMUSG00000037370', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=0, D1='CJ', GO_name='bone remodeling'),
    Nt(p_uncorrected=0.0005660627202574551, study_count=6, study_n=1397, namespace='biological_process', p_fdr_bh=0.042041256248140695, study_items=set([u'ENSMUSG00000031903', u'ENSMUSG00000026317', u'ENSMUSG00000030720', u'ENSMUSG00000035891', u'ENSMUSG00000020097', u'ENSMUSG00000025353']), NS='BP', pop_items=set([u'ENSMUSG00000020097', u'ENSMUSG00000038150', u'ENSMUSG00000026317', u'ENSMUSG00000030720', u'ENSMUSG00000021759', u'ENSMUSG00000035891', u'ENSMUSG00000021669', u'ENSMUSG00000026097', u'ENSMUSG00000031903', u'ENSMUSG00000038007', u'ENSMUSG00000025353', u'ENSMUSG00000030760']), pop_n=13836, p_sm_bonferroni=1.0, is_obsolete=False, GO='GO:0006672', name='ceramide metabolic process', pop_count=12, alt_ids=[], level=5, depth=7, enrichment='e', Cluster='Late Increase', geneid_set=set([u'ENSMUSG00000031903', u'ENSMUSG00000020097', u'ENSMUSG00000026317', u'ENSMUSG00000025353', u'ENSMUSG00000030720', u'ENSMUSG00000035891']), symbols=u'Cerk Cln3 Cln8 Ormdl2 Pla2g15 Sgpl1', symbol_set=set([u'Pla2g15', u'Sgpl1', u'Ormdl2', u'Cerk', u'Cln3', u'Cln8']), geneids='ENSMUSG00000031903 ENSMUSG00000026317 ENSMUSG00000030720 ENSMUSG00000035891 ENSMUSG00000020097 ENSMUSG00000025353', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=18, D1='BCD', GO_name='ceramide metabolic process'),
    Nt(p_uncorrected=1.0493412144829355e-06, study_count=6, study_n=1397, namespace='biological_process', p_fdr_bh=0.0003179713748126191, study_items=set([u'ENSMUSG00000022912', u'ENSMUSG00000026249', u'ENSMUSG00000027712', u'ENSMUSG00000002985', u'ENSMUSG00000074743', u'ENSMUSG00000016494']), NS='BP', pop_items=set([u'ENSMUSG00000022912', u'ENSMUSG00000026249', u'ENSMUSG00000027712', u'ENSMUSG00000002985', u'ENSMUSG00000074743', u'ENSMUSG00000016494']), pop_n=13836, p_sm_bonferroni=0.015898568740630954, is_obsolete=False, GO='GO:0030195', name='negative regulation of blood coagulation', pop_count=6, alt_ids=[], level=5, depth=8, enrichment='e', Cluster='Late Increase', geneid_set=set([u'ENSMUSG00000002985', u'ENSMUSG00000074743', u'ENSMUSG00000022912', u'ENSMUSG00000026249', u'ENSMUSG00000016494', u'ENSMUSG00000027712']), symbols=u'Anxa5 Apoe Cd34 Pros1 Serpine2 Thbd', symbol_set=set([u'Apoe', u'Anxa5', u'Pros1', u'Cd34', u'Thbd', u'Serpine2']), geneids='ENSMUSG00000022912 ENSMUSG00000026249 ENSMUSG00000027712 ENSMUSG00000002985 ENSMUSG00000074743 ENSMUSG00000016494', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=9, D1='A', GO_name='negative regulation of blood coagulation'),
    Nt(p_uncorrected=2.453835471009441e-05, study_count=6, study_n=1397, namespace='biological_process', p_fdr_bh=0.003793679716455514, study_items=set([u'ENSMUSG00000035273', u'ENSMUSG00000040152', u'ENSMUSG00000037411', u'ENSMUSG00000048376', u'ENSMUSG00000015839', u'ENSMUSG00000023961']), NS='BP', pop_items=set([u'ENSMUSG00000040152', u'ENSMUSG00000035273', u'ENSMUSG00000037411', u'ENSMUSG00000005161', u'ENSMUSG00000048376', u'ENSMUSG00000022099', u'ENSMUSG00000023961', u'ENSMUSG00000015839']), pop_n=13836, p_sm_bonferroni=0.3717806122126404, is_obsolete=False, GO='GO:0030194', name='positive regulation of blood coagulation', pop_count=8, alt_ids=[], level=5, depth=8, enrichment='e', Cluster='Late Increase', geneid_set=set([u'ENSMUSG00000048376', u'ENSMUSG00000015839', u'ENSMUSG00000040152', u'ENSMUSG00000035273', u'ENSMUSG00000023961', u'ENSMUSG00000037411']), symbols=u'Enpp4 F2r Hpse Nfe2l2 Serpine1 Thbs1', symbol_set=set([u'Hpse', u'Nfe2l2', u'Enpp4', u'Thbs1', u'F2r', u'Serpine1']), geneids='ENSMUSG00000035273 ENSMUSG00000040152 ENSMUSG00000037411 ENSMUSG00000048376 ENSMUSG00000015839 ENSMUSG00000023961', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=10, D1='A', GO_name='positive regulation of blood coagulation'),
    Nt(p_uncorrected='', study_count='', study_n='', namespace='', p_fdr_bh='', study_items='', NS='BP', pop_items='', pop_n='', p_sm_bonferroni='', is_obsolete='', GO='GO:0022604', name='', pop_count='', alt_ids='', level=5, depth=5, enrichment='', Cluster='', geneid_set='', symbols='', symbol_set='', geneids='', format_txt=1, hdr_idx=1, is_hdrgo=True, is_usrgo=False, hdr1usr01='*', dcnt=108, D1='A', GO_name='regulation of cell morphogenesis'),
    Nt(p_uncorrected=0.00044925982953889274, study_count=5, study_n=1397, namespace='biological_process', p_fdr_bh=0.03781519820746535, study_items=set([u'ENSMUSG00000026674', u'ENSMUSG00000001506', u'ENSMUSG00000003534', u'ENSMUSG00000031273', u'ENSMUSG00000031274']), NS='BP', pop_items=set([u'ENSMUSG00000026674', u'ENSMUSG00000031273', u'ENSMUSG00000031274', u'ENSMUSG00000031503', u'ENSMUSG00000031502', u'ENSMUSG00000001506', u'ENSMUSG00000003534', u'ENSMUSG00000079465']), pop_n=13836, p_sm_bonferroni=1.0, is_obsolete=False, GO='GO:0038063', name='collagen-activated tyrosine kinase receptor signaling pathway', pop_count=8, alt_ids=[], level=5, depth=8, enrichment='e', Cluster='Late Increase', geneid_set=set([u'ENSMUSG00000026674', u'ENSMUSG00000001506', u'ENSMUSG00000003534', u'ENSMUSG00000031273', u'ENSMUSG00000031274']), symbols=u'Col1a1 Col4a5 Col4a6 Ddr1 Ddr2', symbol_set=set([u'Ddr2', u'Col4a6', u'Col4a5', u'Ddr1', u'Col1a1']), geneids='ENSMUSG00000026674 ENSMUSG00000001506 ENSMUSG00000003534 ENSMUSG00000031273 ENSMUSG00000031274', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=0, D1='AB', GO_name='collagen-activated tyrosine kinase receptor signaling pathway'),
    Nt(p_uncorrected=6.243276362722664e-09, study_count=43, study_n=1397, namespace='biological_process', p_fdr_bh=3.3782814347003956e-06, study_items=set([u'ENSMUSG00000022836', u'ENSMUSG00000026923', u'ENSMUSG00000028874', u'ENSMUSG00000022150', u'ENSMUSG00000028780', u'ENSMUSG00000028228', u'ENSMUSG00000068290', u'ENSMUSG00000027985', u'ENSMUSG00000020828', u'ENSMUSG00000026193', u'ENSMUSG00000045382', u'ENSMUSG00000032035', u'ENSMUSG00000041417', u'ENSMUSG00000026697', u'ENSMUSG00000029648', u'ENSMUSG00000028864', u'ENSMUSG00000036585', u'ENSMUSG00000021904', u'ENSMUSG00000028583', u'ENSMUSG00000021822', u'ENSMUSG00000032050', u'ENSMUSG00000001506', u'ENSMUSG00000027111', u'ENSMUSG00000020053', u'ENSMUSG00000062209', u'ENSMUSG00000020372', u'ENSMUSG00000032135', u'ENSMUSG00000024620', u'ENSMUSG00000025809', u'ENSMUSG00000027695', u'ENSMUSG00000032359', u'ENSMUSG00000040552', u'ENSMUSG00000048376', u'ENSMUSG00000045092', u'ENSMUSG00000040152', u'ENSMUSG00000054693', u'ENSMUSG00000007613', u'ENSMUSG00000042524', u'ENSMUSG00000032006', u'ENSMUSG00000029816', u'ENSMUSG00000024300', u'ENSMUSG00000020122', u'ENSMUSG00000053475']), NS='BP', pop_items=set([u'ENSMUSG00000022836', u'ENSMUSG00000063531', u'ENSMUSG00000028228', u'ENSMUSG00000025856', u'ENSMUSG00000027985', u'ENSMUSG00000028431', u'ENSMUSG00000038894', u'ENSMUSG00000030110', u'ENSMUSG00000031778', u'ENSMUSG00000026697', u'ENSMUSG00000061353', u'ENSMUSG00000002489', u'ENSMUSG00000035133', u'ENSMUSG00000032035', u'ENSMUSG00000028583', u'ENSMUSG00000021822', u'ENSMUSG00000057969', u'ENSMUSG00000033717', u'ENSMUSG00000020372', u'ENSMUSG00000040254', u'ENSMUSG00000039239', u'ENSMUSG00000000489', u'ENSMUSG00000039936', u'ENSMUSG00000068154', u'ENSMUSG00000039621', u'ENSMUSG00000042228', u'ENSMUSG00000001506', u'ENSMUSG00000024965', u'ENSMUSG00000052353', u'ENSMUSG00000040152', u'ENSMUSG00000014599', u'ENSMUSG00000066551', u'ENSMUSG00000069135', u'ENSMUSG00000025499', u'ENSMUSG00000053475', u'ENSMUSG00000020074', u'ENSMUSG00000028249', u'ENSMUSG00000063450', u'ENSMUSG00000026193', u'ENSMUSG00000021478', u'ENSMUSG00000005672', u'ENSMUSG00000029231', u'ENSMUSG00000037685', u'ENSMUSG00000052593', u'ENSMUSG00000041417', u'ENSMUSG00000028195', u'ENSMUSG00000022150', u'ENSMUSG00000025207', u'ENSMUSG00000032402', u'ENSMUSG00000051675', u'ENSMUSG00000004936', u'ENSMUSG00000040552', u'ENSMUSG00000027087', u'ENSMUSG00000020053', u'ENSMUSG00000062209', u'ENSMUSG00000024101', u'ENSMUSG00000004056', u'ENSMUSG00000023088', u'ENSMUSG00000026836', u'ENSMUSG00000020859', u'ENSMUSG00000034855', u'ENSMUSG00000028466', u'ENSMUSG00000028019', u'ENSMUSG00000045991', u'ENSMUSG00000030774', u'ENSMUSG00000055980', u'ENSMUSG00000020484', u'ENSMUSG00000007613', u'ENSMUSG00000042524', u'ENSMUSG00000024456', u'ENSMUSG00000029816', u'ENSMUSG00000020122', u'ENSMUSG00000030890', u'ENSMUSG00000038777', u'ENSMUSG00000000627', u'ENSMUSG00000026923', u'ENSMUSG00000028064', u'ENSMUSG00000021451', u'ENSMUSG00000000957', u'ENSMUSG00000020828', u'ENSMUSG00000028780', u'ENSMUSG00000027835', u'ENSMUSG00000021224', u'ENSMUSG00000034684', u'ENSMUSG00000030707', u'ENSMUSG00000030805', u'ENSMUSG00000026121', u'ENSMUSG00000002603', u'ENSMUSG00000053647', u'ENSMUSG00000024620', u'ENSMUSG00000024621', u'ENSMUSG00000028864', u'ENSMUSG00000050357', u'ENSMUSG00000021904', u'ENSMUSG00000049107', u'ENSMUSG00000018920', u'ENSMUSG00000004655', u'ENSMUSG00000020659', u'ENSMUSG00000020689', u'ENSMUSG00000022031', u'ENSMUSG00000032135', u'ENSMUSG00000025809', u'ENSMUSG00000029291', u'ENSMUSG00000027695', u'ENSMUSG00000030530', u'ENSMUSG00000030539', u'ENSMUSG00000034974', u'ENSMUSG00000024397', u'ENSMUSG00000002900', u'ENSMUSG00000022607', u'ENSMUSG00000059456', u'ENSMUSG00000028874', u'ENSMUSG00000002580', u'ENSMUSG00000021338', u'ENSMUSG00000017774', u'ENSMUSG00000037926', u'ENSMUSG00000030538', u'ENSMUSG00000061878', u'ENSMUSG00000055723', u'ENSMUSG00000054836', u'ENSMUSG00000068290', u'ENSMUSG00000054693', u'ENSMUSG00000018565', u'ENSMUSG00000054808', u'ENSMUSG00000026864', u'ENSMUSG00000021360', u'ENSMUSG00000045382', u'ENSMUSG00000005534', u'ENSMUSG00000005871', u'ENSMUSG00000005533', u'ENSMUSG00000023348', u'ENSMUSG00000024486', u'ENSMUSG00000068566', u'ENSMUSG00000029648', u'ENSMUSG00000000127', u'ENSMUSG00000036585', u'ENSMUSG00000036106', u'ENSMUSG00000050965', u'ENSMUSG00000048376', u'ENSMUSG00000085795', u'ENSMUSG00000031841', u'ENSMUSG00000032050', u'ENSMUSG00000032359', u'ENSMUSG00000026064', u'ENSMUSG00000027358', u'ENSMUSG00000027111', u'ENSMUSG00000032006', u'ENSMUSG00000045092', u'ENSMUSG00000038264', u'ENSMUSG00000059146', u'ENSMUSG00000000555', u'ENSMUSG00000046761', u'ENSMUSG00000026479', u'ENSMUSG00000001435', u'ENSMUSG00000031740', u'ENSMUSG00000024789', u'ENSMUSG00000016496', u'ENSMUSG00000025586', u'ENSMUSG00000042682', u'ENSMUSG00000062960', u'ENSMUSG00000023951', u'ENSMUSG00000068748', u'ENSMUSG00000001227', u'ENSMUSG00000031955', u'ENSMUSG00000021835', u'ENSMUSG00000024300', u'ENSMUSG00000021936', u'ENSMUSG00000052133']), pop_n=13836, p_sm_bonferroni=9.459188017161108e-05, is_obsolete=False, GO='GO:0030335', name='positive regulation of cell migration', pop_count=168, alt_ids=[], level=6, depth=7, enrichment='e', Cluster='Late Increase', geneid_set=set([u'ENSMUSG00000022836', u'ENSMUSG00000026923', u'ENSMUSG00000026697', u'ENSMUSG00000026193', u'ENSMUSG00000028228', u'ENSMUSG00000068290', u'ENSMUSG00000029648', u'ENSMUSG00000020828', u'ENSMUSG00000028780', u'ENSMUSG00000045382', u'ENSMUSG00000036585', u'ENSMUSG00000041417', u'ENSMUSG00000040552', u'ENSMUSG00000022150', u'ENSMUSG00000027985', u'ENSMUSG00000028864', u'ENSMUSG00000032035', u'ENSMUSG00000021904', u'ENSMUSG00000028583', u'ENSMUSG00000021822', u'ENSMUSG00000032050', u'ENSMUSG00000001506', u'ENSMUSG00000027111', u'ENSMUSG00000020053', u'ENSMUSG00000062209', u'ENSMUSG00000020372', u'ENSMUSG00000032135', u'ENSMUSG00000024620', u'ENSMUSG00000025809', u'ENSMUSG00000027695', u'ENSMUSG00000032359', u'ENSMUSG00000048376', u'ENSMUSG00000054693', u'ENSMUSG00000045092', u'ENSMUSG00000040152', u'ENSMUSG00000028874', u'ENSMUSG00000007613', u'ENSMUSG00000042524', u'ENSMUSG00000032006', u'ENSMUSG00000029816', u'ENSMUSG00000024300', u'ENSMUSG00000020122', u'ENSMUSG00000053475']), symbols=u'Adam10 C3ar1 Col1a1 Cpne3 Ctsh Cxcr4 Dab2 Ddrgk1 Egfr Erbb4 Ets1 F2r Fgf1 Fgr Flt1 Fn1 Gpnmb Hgf Igf1 Itga6 Itgb1 Lef1 Mcam Mylk Myo1f Myoc Notch1 Pdgfd Pdgfrb Pdpn Pik3r1 Plau Pld1 Pld2 Rack1 Rdx S1pr1 Sema3c Sema3g Sun2 Tgfbr1 Thbs1 Tnfaip6', symbol_set=set([u'Igf1', u'Pdgfd', u'Fn1', u'Cpne3', u'Cxcr4', u'Mylk', u'Pdpn', u'Mcam', u'Hgf', u'Dab2', u'Lef1', u'Fgr', u'Itgb1', u'Pld1', u'Pld2', u'Sun2', u'Notch1', u'Plau', u'Adam10', u'Ctsh', u'Tgfbr1', u'Tnfaip6', u'Rdx', u'Thbs1', u'F2r', u'Myo1f', u'Pik3r1', u'Col1a1', u'Fgf1', u'Flt1', u'Pdgfrb', u'Sema3c', u'Erbb4', u'Sema3g', u'C3ar1', u'S1pr1', u'Egfr', u'Gpnmb', u'Itga6', u'Ets1', u'Ddrgk1', u'Myoc', 'Rack1']), geneids='ENSMUSG00000022836 ENSMUSG00000026923 ENSMUSG00000022150 ENSMUSG00000024620 ENSMUSG00000028780 ENSMUSG00000028228 ENSMUSG00000068290 ENSMUSG00000029648 ENSMUSG00000020828 ENSMUSG00000026193 ENSMUSG00000045382 ENSMUSG00000036585 ENSMUSG00000040552 ENSMUSG00000026697 ENSMUSG00000027985 ENSMUSG00000028864 ENSMUSG00000032035 ENSMUSG00000021904 ENSMUSG00000028583 ENSMUSG00000021822 ENSMUSG00000032050 ENSMUSG00000001506 ENSMUSG00000027111 ENSMUSG00000020053 ENSMUSG00000062209 ENSMUSG00000020372 ENSMUSG00000032135 ENSMUSG00000025809 ENSMUSG00000027695 ENSMUSG00000032359 ENSMUSG00000048376 ENSMUSG00000041417 ENSMUSG00000054693 ENSMUSG00000045092 ENSMUSG00000040152 ENSMUSG00000028874 ENSMUSG00000007613 ENSMUSG00000042524 ENSMUSG00000032006 ENSMUSG00000029816 ENSMUSG00000024300 ENSMUSG00000020122 ENSMUSG00000053475', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=67, D1='A', GO_name='positive regulation of cell migration'),
    Nt(p_uncorrected=1.959724226719881e-05, study_count=50, study_n=1397, namespace='biological_process', p_fdr_bh=0.003227367582503578, study_items=set([u'ENSMUSG00000028042', u'ENSMUSG00000062078', u'ENSMUSG00000057103', u'ENSMUSG00000013584', u'ENSMUSG00000006369', u'ENSMUSG00000068290', u'ENSMUSG00000015839', u'ENSMUSG00000026193', u'ENSMUSG00000019997', u'ENSMUSG00000024810', u'ENSMUSG00000033016', u'ENSMUSG00000035873', u'ENSMUSG00000030849', u'ENSMUSG00000041417', u'ENSMUSG00000035158', u'ENSMUSG00000027985', u'ENSMUSG00000018654', u'ENSMUSG00000034462', u'ENSMUSG00000042745', u'ENSMUSG00000032050', u'ENSMUSG00000032359', u'ENSMUSG00000006611', u'ENSMUSG00000022018', u'ENSMUSG00000019920', u'ENSMUSG00000052397', u'ENSMUSG00000039005', u'ENSMUSG00000026728', u'ENSMUSG00000055435', u'ENSMUSG00000040711', u'ENSMUSG00000031451', u'ENSMUSG00000031760', u'ENSMUSG00000021379', u'ENSMUSG00000055254', u'ENSMUSG00000026879', u'ENSMUSG00000025321', u'ENSMUSG00000027168', u'ENSMUSG00000032369', u'ENSMUSG00000039191', u'ENSMUSG00000000567', u'ENSMUSG00000037411', u'ENSMUSG00000028163', u'ENSMUSG00000031425', u'ENSMUSG00000062312', u'ENSMUSG00000026177', u'ENSMUSG00000050953', u'ENSMUSG00000001761', u'ENSMUSG00000020644', u'ENSMUSG00000025902', u'ENSMUSG00000060601', u'ENSMUSG00000007655']), NS='BP', pop_items=set([u'ENSMUSG00000029513', u'ENSMUSG00000045322', u'ENSMUSG00000009376', u'ENSMUSG00000062604', u'ENSMUSG00000027544', u'ENSMUSG00000059327', u'ENSMUSG00000027314', u'ENSMUSG00000000861', u'ENSMUSG00000028433', u'ENSMUSG00000001288', u'ENSMUSG00000028434', u'ENSMUSG00000021264', u'ENSMUSG00000028101', u'ENSMUSG00000019997', u'ENSMUSG00000023809', u'ENSMUSG00000033016', u'ENSMUSG00000002250', u'ENSMUSG00000019986', u'ENSMUSG00000030849', u'ENSMUSG00000001761', u'ENSMUSG00000018160', u'ENSMUSG00000031540', u'ENSMUSG00000018166', u'ENSMUSG00000004056', u'ENSMUSG00000026167', u'ENSMUSG00000017146', u'ENSMUSG00000027985', u'ENSMUSG00000021109', u'ENSMUSG00000004815', u'ENSMUSG00000024176', u'ENSMUSG00000005583', u'ENSMUSG00000063632', u'ENSMUSG00000001507', u'ENSMUSG00000034462', u'ENSMUSG00000026814', u'ENSMUSG00000032826', u'ENSMUSG00000028034', u'ENSMUSG00000059146', u'ENSMUSG00000039239', u'ENSMUSG00000020184', u'ENSMUSG00000048930', u'ENSMUSG00000000489', u'ENSMUSG00000003814', u'ENSMUSG00000040711', u'ENSMUSG00000039936', u'ENSMUSG00000017446', u'ENSMUSG00000019984', u'ENSMUSG00000031760', u'ENSMUSG00000031574', u'ENSMUSG00000025321', u'ENSMUSG00000003032', u'ENSMUSG00000033326', u'ENSMUSG00000005698', u'ENSMUSG00000000567', u'ENSMUSG00000014599', u'ENSMUSG00000000568', u'ENSMUSG00000037411', u'ENSMUSG00000040016', u'ENSMUSG00000045827', u'ENSMUSG00000029833', u'ENSMUSG00000027490', u'ENSMUSG00000039428', u'ENSMUSG00000026628', u'ENSMUSG00000024563', u'ENSMUSG00000041670', u'ENSMUSG00000015656', u'ENSMUSG00000030110', u'ENSMUSG00000060601', u'ENSMUSG00000002413', u'ENSMUSG00000020580', u'ENSMUSG00000050697', u'ENSMUSG00000071072', u'ENSMUSG00000020366', u'ENSMUSG00000020361', u'ENSMUSG00000022382', u'ENSMUSG00000037992', u'ENSMUSG00000004665', u'ENSMUSG00000062991', u'ENSMUSG00000059552', u'ENSMUSG00000015839', u'ENSMUSG00000022528', u'ENSMUSG00000023826', u'ENSMUSG00000006699', u'ENSMUSG00000046532', u'ENSMUSG00000004040', u'ENSMUSG00000067713', u'ENSMUSG00000041417', u'ENSMUSG00000022556', u'ENSMUSG00000041415', u'ENSMUSG00000029616', u'ENSMUSG00000026728', u'ENSMUSG00000027646', u'ENSMUSG00000003847', u'ENSMUSG00000010505', u'ENSMUSG00000032402', u'ENSMUSG00000042745', u'ENSMUSG00000017724', u'ENSMUSG00000004936', u'ENSMUSG00000014158', u'ENSMUSG00000006611', u'ENSMUSG00000022018', u'ENSMUSG00000001123', u'ENSMUSG00000026177', u'ENSMUSG00000039153', u'ENSMUSG00000054611', u'ENSMUSG00000030265', u'ENSMUSG00000027434', u'ENSMUSG00000035873', u'ENSMUSG00000032807', u'ENSMUSG00000055022', u'ENSMUSG00000003282', u'ENSMUSG00000004099', u'ENSMUSG00000055024', u'ENSMUSG00000031425', u'ENSMUSG00000030417', u'ENSMUSG00000028397', u'ENSMUSG00000042406', u'ENSMUSG00000032369', u'ENSMUSG00000026843', u'ENSMUSG00000039191', u'ENSMUSG00000000787', u'ENSMUSG00000057531', u'ENSMUSG00000051510', u'ENSMUSG00000039137', u'ENSMUSG00000037386', u'ENSMUSG00000020644', u'ENSMUSG00000021974', u'ENSMUSG00000031696', u'ENSMUSG00000039910', u'ENSMUSG00000079227', u'ENSMUSG00000053470', u'ENSMUSG00000025793', u'ENSMUSG00000028063', u'ENSMUSG00000035277', u'ENSMUSG00000036923', u'ENSMUSG00000024947', u'ENSMUSG00000034160', u'ENSMUSG00000031386', u'ENSMUSG00000023951', u'ENSMUSG00000004221', u'ENSMUSG00000028068', u'ENSMUSG00000006369', u'ENSMUSG00000033760', u'ENSMUSG00000052397', u'ENSMUSG00000022521', u'ENSMUSG00000037369', u'ENSMUSG00000029359', u'ENSMUSG00000026193', u'ENSMUSG00000031639', u'ENSMUSG00000027835', u'ENSMUSG00000030093', u'ENSMUSG00000031304', u'ENSMUSG00000032462', u'ENSMUSG00000061013', u'ENSMUSG00000047388', u'ENSMUSG00000002603', u'ENSMUSG00000053647', u'ENSMUSG00000000532', u'ENSMUSG00000029390', u'ENSMUSG00000030744', u'ENSMUSG00000040435', u'ENSMUSG00000028364', u'ENSMUSG00000032078', u'ENSMUSG00000019920', u'ENSMUSG00000005087', u'ENSMUSG00000013584', u'ENSMUSG00000034394', u'ENSMUSG00000055435', u'ENSMUSG00000021253', u'ENSMUSG00000008305', u'ENSMUSG00000006932', u'ENSMUSG00000021256', u'ENSMUSG00000032193', u'ENSMUSG00000042308', u'ENSMUSG00000039217', u'ENSMUSG00000026181', u'ENSMUSG00000054717', u'ENSMUSG00000038418', u'ENSMUSG00000037487', u'ENSMUSG00000025499', u'ENSMUSG00000022040', u'ENSMUSG00000040296', u'ENSMUSG00000062312', u'ENSMUSG00000050953', u'ENSMUSG00000028964', u'ENSMUSG00000020167', u'ENSMUSG00000041530', u'ENSMUSG00000037169', u'ENSMUSG00000027678', u'ENSMUSG00000001240', u'ENSMUSG00000028042', u'ENSMUSG00000062078', u'ENSMUSG00000057103', u'ENSMUSG00000039630', u'ENSMUSG00000021319', u'ENSMUSG00000068290', u'ENSMUSG00000000838', u'ENSMUSG00000031207', u'ENSMUSG00000037188', u'ENSMUSG00000036698', u'ENSMUSG00000024810', u'ENSMUSG00000063415', u'ENSMUSG00000032119', u'ENSMUSG00000022191', u'ENSMUSG00000032202', u'ENSMUSG00000090958', u'ENSMUSG00000024256', u'ENSMUSG00000027399', u'ENSMUSG00000005672', u'ENSMUSG00000023055', u'ENSMUSG00000019942', u'ENSMUSG00000035158', u'ENSMUSG00000031681', u'ENSMUSG00000028842', u'ENSMUSG00000038845', u'ENSMUSG00000055633', u'ENSMUSG00000036104', u'ENSMUSG00000021835', u'ENSMUSG00000040451', u'ENSMUSG00000045515', u'ENSMUSG00000002983', u'ENSMUSG00000032050', u'ENSMUSG00000032359', u'ENSMUSG00000028991', u'ENSMUSG00000022114', u'ENSMUSG00000027358', u'ENSMUSG00000039005', u'ENSMUSG00000028211', u'ENSMUSG00000040274', u'ENSMUSG00000006058', u'ENSMUSG00000069601', u'ENSMUSG00000029468', u'ENSMUSG00000018654', u'ENSMUSG00000042589', u'ENSMUSG00000056749', u'ENSMUSG00000042520', u'ENSMUSG00000030341', u'ENSMUSG00000016493', u'ENSMUSG00000031921', u'ENSMUSG00000045658', u'ENSMUSG00000042207', u'ENSMUSG00000031668', u'ENSMUSG00000031451', u'ENSMUSG00000050295', u'ENSMUSG00000031980', u'ENSMUSG00000021379', u'ENSMUSG00000055254', u'ENSMUSG00000026879', u'ENSMUSG00000020689', u'ENSMUSG00000027168', u'ENSMUSG00000007655', u'ENSMUSG00000005102', u'ENSMUSG00000027995', u'ENSMUSG00000022346', u'ENSMUSG00000028163', u'ENSMUSG00000032228', u'ENSMUSG00000028161', u'ENSMUSG00000027859', u'ENSMUSG00000048616', u'ENSMUSG00000058498', u'ENSMUSG00000053436', u'ENSMUSG00000022812', u'ENSMUSG00000053137', u'ENSMUSG00000025902', u'ENSMUSG00000021936', u'ENSMUSG00000014773', u'ENSMUSG00000060216']), pop_n=13836, p_sm_bonferroni=0.2969178175903292, is_obsolete=False, GO='GO:0010628', name='positive regulation of gene expression', pop_count=267, alt_ids=[], level=6, depth=6, enrichment='e', Cluster='Late Increase', geneid_set=set([u'ENSMUSG00000028042', u'ENSMUSG00000062078', u'ENSMUSG00000057103', u'ENSMUSG00000013584', u'ENSMUSG00000006369', u'ENSMUSG00000068290', u'ENSMUSG00000015839', u'ENSMUSG00000026193', u'ENSMUSG00000019997', u'ENSMUSG00000024810', u'ENSMUSG00000033016', u'ENSMUSG00000035873', u'ENSMUSG00000030849', u'ENSMUSG00000041417', u'ENSMUSG00000035158', u'ENSMUSG00000027985', u'ENSMUSG00000018654', u'ENSMUSG00000034462', u'ENSMUSG00000042745', u'ENSMUSG00000032050', u'ENSMUSG00000032359', u'ENSMUSG00000006611', u'ENSMUSG00000022018', u'ENSMUSG00000019920', u'ENSMUSG00000052397', u'ENSMUSG00000060601', u'ENSMUSG00000026728', u'ENSMUSG00000055435', u'ENSMUSG00000032369', u'ENSMUSG00000031451', u'ENSMUSG00000031760', u'ENSMUSG00000021379', u'ENSMUSG00000055254', u'ENSMUSG00000026879', u'ENSMUSG00000025321', u'ENSMUSG00000027168', u'ENSMUSG00000040711', u'ENSMUSG00000039191', u'ENSMUSG00000000567', u'ENSMUSG00000037411', u'ENSMUSG00000028163', u'ENSMUSG00000031425', u'ENSMUSG00000062312', u'ENSMUSG00000026177', u'ENSMUSG00000050953', u'ENSMUSG00000001761', u'ENSMUSG00000020644', u'ENSMUSG00000025902', u'ENSMUSG00000039005', u'ENSMUSG00000007655']), symbols=u'Aldh1a2 Cav1 Ctgf Ctsh Ddrgk1 Erbb2 Ezr Fbln1 Fgfr2 Fn1 Gas6 Gja1 Gsn Hfe Id1 Id2 Id4 Ikzf1 Il33 Itgb8 Lef1 Lims1 Maf Mitf Mt3 Nat8f1 Nfatc1 Nfe2l2 Nfkb1 Nr1h2 Ntrk2 Pawr Pax6 Pik3r1 Pkd2 Plp1 Plscr1 Qk Rbpj Rdx Rgcc Serpine1 Sh3pxd2b Slc11a1 Smo Sox17 Sox9 Tlr4 Vim Zbtb7b', symbol_set=set([u'Fn1', u'Zbtb7b', u'Mt3', u'Id4', u'Id2', u'Id1', u'Smo', u'Ctgf', u'Nfkb1', u'Lef1', u'Sox17', u'Ctsh', u'Gja1', u'Pkd2', 'Nat8f1', u'Serpine1', u'Lims1', u'Maf', u'Mitf', u'Cav1', u'Fgfr2', u'Rbpj', u'Nr1h2', u'Nfatc1', u'Itgb8', u'Slc11a1', u'Nfe2l2', u'Rdx', u'Ntrk2', u'Pax6', u'Pik3r1', 'Rgcc', u'Sh3pxd2b', u'Plp1', u'Qk', u'Hfe', u'Fbln1', u'Aldh1a2', u'Gsn', u'Erbb2', u'Plscr1', u'Ezr', u'Vim', u'Sox9', u'Il33', u'Tlr4', u'Ddrgk1', u'Pawr', u'Ikzf1', u'Gas6']), geneids='ENSMUSG00000028042 ENSMUSG00000062078 ENSMUSG00000057103 ENSMUSG00000013584 ENSMUSG00000006369 ENSMUSG00000068290 ENSMUSG00000015839 ENSMUSG00000026193 ENSMUSG00000019997 ENSMUSG00000024810 ENSMUSG00000033016 ENSMUSG00000035873 ENSMUSG00000030849 ENSMUSG00000001761 ENSMUSG00000035158 ENSMUSG00000027985 ENSMUSG00000018654 ENSMUSG00000041417 ENSMUSG00000034462 ENSMUSG00000042745 ENSMUSG00000032050 ENSMUSG00000032359 ENSMUSG00000006611 ENSMUSG00000022018 ENSMUSG00000019920 ENSMUSG00000052397 ENSMUSG00000060601 ENSMUSG00000039005 ENSMUSG00000026728 ENSMUSG00000055435 ENSMUSG00000040711 ENSMUSG00000031451 ENSMUSG00000031760 ENSMUSG00000021379 ENSMUSG00000055254 ENSMUSG00000026879 ENSMUSG00000025321 ENSMUSG00000027168 ENSMUSG00000032369 ENSMUSG00000039191 ENSMUSG00000000567 ENSMUSG00000037411 ENSMUSG00000028163 ENSMUSG00000031425 ENSMUSG00000062312 ENSMUSG00000026177 ENSMUSG00000050953 ENSMUSG00000020644 ENSMUSG00000025902 ENSMUSG00000007655', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=225, D1='A', GO_name='positive regulation of gene expression'),
    Nt(p_uncorrected=5.170053294202527e-05, study_count=13, study_n=1397, namespace='biological_process', p_fdr_bh=0.007186374078941513, study_items=set([u'ENSMUSG00000027878', u'ENSMUSG00000078942', u'ENSMUSG00000044827', u'ENSMUSG00000078945', u'ENSMUSG00000029484', u'ENSMUSG00000069516', u'ENSMUSG00000021948', u'ENSMUSG00000006403', u'ENSMUSG00000026177', u'ENSMUSG00000037523', u'ENSMUSG00000016206', u'ENSMUSG00000021457', u'ENSMUSG00000039191']), NS='BP', pop_items=set([u'ENSMUSG00000039191', u'ENSMUSG00000042286', u'ENSMUSG00000021457', u'ENSMUSG00000022894', u'ENSMUSG00000056501', u'ENSMUSG00000058715', u'ENSMUSG00000030059', u'ENSMUSG00000021948', u'ENSMUSG00000053175', u'ENSMUSG00000069516', u'ENSMUSG00000023078', u'ENSMUSG00000015947', u'ENSMUSG00000016024', u'ENSMUSG00000037523', u'ENSMUSG00000020953', u'ENSMUSG00000071203', u'ENSMUSG00000061232', u'ENSMUSG00000079362', u'ENSMUSG00000015950', u'ENSMUSG00000069874', u'ENSMUSG00000055204', u'ENSMUSG00000030341', u'ENSMUSG00000006403', u'ENSMUSG00000067847', u'ENSMUSG00000026878', u'ENSMUSG00000027878', u'ENSMUSG00000078942', u'ENSMUSG00000078945', u'ENSMUSG00000035692', u'ENSMUSG00000029484', u'ENSMUSG00000045827', u'ENSMUSG00000044827', u'ENSMUSG00000026177', u'ENSMUSG00000020149', u'ENSMUSG00000038058', u'ENSMUSG00000019726', u'ENSMUSG00000016206', u'ENSMUSG00000041515']), pop_n=13836, p_sm_bonferroni=0.7833147746046248, is_obsolete=False, GO='GO:0042742', name='defense response to bacterium', pop_count=38, alt_ids=['GO:0042830'], level=5, depth=6, enrichment='e', Cluster='Late Increase', geneid_set=set([u'ENSMUSG00000027878', u'ENSMUSG00000078942', u'ENSMUSG00000069516', u'ENSMUSG00000078945', u'ENSMUSG00000029484', u'ENSMUSG00000044827', u'ENSMUSG00000021948', u'ENSMUSG00000006403', u'ENSMUSG00000026177', u'ENSMUSG00000037523', u'ENSMUSG00000016206', u'ENSMUSG00000021457', u'ENSMUSG00000039191']), symbols=u'Adamts4 Anxa3 H2-M3 Lyz2 Mavs Naip2 Naip6 Notch2 Prkcd Rbpj Slc11a1 Syk Tlr1', symbol_set=set([u'Adamts4', u'Anxa3', u'Slc11a1', u'Syk', 'H2-M3', u'Naip6', u'Prkcd', u'Notch2', u'Naip2', u'Lyz2', u'Tlr1', u'Mavs', u'Rbpj']), geneids='ENSMUSG00000027878 ENSMUSG00000021948 ENSMUSG00000069516 ENSMUSG00000039191 ENSMUSG00000029484 ENSMUSG00000044827 ENSMUSG00000078942 ENSMUSG00000021457 ENSMUSG00000026177 ENSMUSG00000037523 ENSMUSG00000016206 ENSMUSG00000006403 ENSMUSG00000078945', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=8, D1='F', GO_name='defense response to bacterium'),
    Nt(p_uncorrected=0.000103529696452711, study_count=4, study_n=1397, namespace='biological_process', p_fdr_bh=0.012351011267362396, study_items=set([u'ENSMUSG00000002985', u'ENSMUSG00000040613', u'ENSMUSG00000015243', u'ENSMUSG00000035237']), NS='BP', pop_items=set([u'ENSMUSG00000002985', u'ENSMUSG00000040613', u'ENSMUSG00000015243', u'ENSMUSG00000035237']), pop_n=13836, p_sm_bonferroni=1.0, is_obsolete=False, GO='GO:0042158', name='lipoprotein biosynthetic process', pop_count=4, alt_ids=[], level=5, depth=6, enrichment='e', Cluster='Late Increase', geneid_set=set([u'ENSMUSG00000002985', u'ENSMUSG00000040613', u'ENSMUSG00000015243', u'ENSMUSG00000035237']), symbols=u'Abca1 Apobec1 Apoe Lcat', symbol_set=set([u'Apobec1', u'Apoe', u'Lcat', u'Abca1']), geneids='ENSMUSG00000002985 ENSMUSG00000040613 ENSMUSG00000015243 ENSMUSG00000035237', format_txt=1, hdr_idx=1, is_hdrgo=True, is_usrgo=True, hdr1usr01='**', dcnt=3, D1='BD', GO_name='lipoprotein biosynthetic process'),
    Nt(p_uncorrected=0.00047594319969878284, study_count=4, study_n=1397, namespace='biological_process', p_fdr_bh=0.0381597084052771, study_items=set([u'ENSMUSG00000032066', u'ENSMUSG00000013584', u'ENSMUSG00000053279', u'ENSMUSG00000046402']), NS='BP', pop_items=set([u'ENSMUSG00000053279', u'ENSMUSG00000046402', u'ENSMUSG00000032066', u'ENSMUSG00000013584', u'ENSMUSG00000063415']), pop_n=13836, p_sm_bonferroni=1.0, is_obsolete=False, GO='GO:0042573', name='retinoic acid metabolic process', pop_count=5, alt_ids=[], level=4, depth=9, enrichment='e', Cluster='Late Increase', geneid_set=set([u'ENSMUSG00000053279', u'ENSMUSG00000046402', u'ENSMUSG00000032066', u'ENSMUSG00000013584']), symbols=u'Aldh1a1 Aldh1a2 Bco2 Rbp1', symbol_set=set([u'Rbp1', u'Aldh1a2', u'Aldh1a1', u'Bco2']), geneids='ENSMUSG00000032066 ENSMUSG00000013584 ENSMUSG00000053279 ENSMUSG00000046402', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=5, D1='ABCD', GO_name='retinoic acid metabolic process'),
    Nt(p_uncorrected=0.00017942947239235255, study_count=12, study_n=1397, namespace='biological_process', p_fdr_bh=0.01836848605551712, study_items=set([u'ENSMUSG00000045817', u'ENSMUSG00000000567', u'ENSMUSG00000021127', u'ENSMUSG00000037411', u'ENSMUSG00000022150', u'ENSMUSG00000007613', u'ENSMUSG00000051910', u'ENSMUSG00000032006', u'ENSMUSG00000026383', u'ENSMUSG00000007655', u'ENSMUSG00000004637', u'ENSMUSG00000014932']), NS='BP', pop_items=set([u'ENSMUSG00000026496', u'ENSMUSG00000026341', u'ENSMUSG00000021127', u'ENSMUSG00000022150', u'ENSMUSG00000005533', u'ENSMUSG00000045817', u'ENSMUSG00000002603', u'ENSMUSG00000041540', u'ENSMUSG00000027646', u'ENSMUSG00000000530', u'ENSMUSG00000051910', u'ENSMUSG00000034675', u'ENSMUSG00000022952', u'ENSMUSG00000028978', u'ENSMUSG00000026201', u'ENSMUSG00000019843', u'ENSMUSG00000014932', u'ENSMUSG00000001034', u'ENSMUSG00000004099', u'ENSMUSG00000030417', u'ENSMUSG00000004637', u'ENSMUSG00000029167', u'ENSMUSG00000021096', u'ENSMUSG00000010047', u'ENSMUSG00000005583', u'ENSMUSG00000019979', u'ENSMUSG00000000567', u'ENSMUSG00000022607', u'ENSMUSG00000031010', u'ENSMUSG00000025880', u'ENSMUSG00000031503', u'ENSMUSG00000007613', u'ENSMUSG00000032006', u'ENSMUSG00000026383', u'ENSMUSG00000007655', u'ENSMUSG00000037411', u'ENSMUSG00000017776']), pop_n=13836, p_sm_bonferroni=1.0, is_obsolete=False, GO='GO:0071560', name='cellular response to transforming growth factor beta stimulus', pop_count=37, alt_ids=[], level=4, depth=6, enrichment='e', Cluster='Late Increase', geneid_set=set([u'ENSMUSG00000045817', u'ENSMUSG00000000567', u'ENSMUSG00000021127', u'ENSMUSG00000037411', u'ENSMUSG00000022150', u'ENSMUSG00000014932', u'ENSMUSG00000007613', u'ENSMUSG00000051910', u'ENSMUSG00000032006', u'ENSMUSG00000026383', u'ENSMUSG00000007655', u'ENSMUSG00000004637']), symbols=u'Cav1 Dab2 Epb41l5 Pdgfd Serpine1 Sox6 Sox9 Tgfbr1 Wwox Yes1 Zfp36l1 Zfp36l2', symbol_set=set([u'Tgfbr1', u'Pdgfd', 'Epb41l5', u'Zfp36l1', u'Zfp36l2', u'Sox9', u'Wwox', u'Dab2', u'Sox6', u'Serpine1', u'Yes1', u'Cav1']), geneids='ENSMUSG00000045817 ENSMUSG00000000567 ENSMUSG00000021127 ENSMUSG00000037411 ENSMUSG00000022150 ENSMUSG00000007613 ENSMUSG00000051910 ENSMUSG00000026383 ENSMUSG00000004637 ENSMUSG00000007655 ENSMUSG00000014932 ENSMUSG00000032006', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=0, D1='BF', GO_name='cellular response to transforming growth factor beta stimulus'),
    Nt(p_uncorrected=0.0001538136428217577, study_count=6, study_n=1397, namespace='biological_process', p_fdr_bh=0.016411006997724215, study_items=set([u'ENSMUSG00000020919', u'ENSMUSG00000032698', u'ENSMUSG00000021127', u'ENSMUSG00000004043', u'ENSMUSG00000044786', u'ENSMUSG00000074622']), NS='BP', pop_items=set([u'ENSMUSG00000020919', u'ENSMUSG00000032698', u'ENSMUSG00000021127', u'ENSMUSG00000004043', u'ENSMUSG00000024359', u'ENSMUSG00000025223', u'ENSMUSG00000044786', u'ENSMUSG00000034201', u'ENSMUSG00000052040', u'ENSMUSG00000074622']), pop_n=13836, p_sm_bonferroni=1.0, is_obsolete=False, GO='GO:0045647', name='negative regulation of erythrocyte differentiation', pop_count=10, alt_ids=[], level=5, depth=8, enrichment='e', Cluster='Late Increase', geneid_set=set([u'ENSMUSG00000020919', u'ENSMUSG00000032698', u'ENSMUSG00000021127', u'ENSMUSG00000004043', u'ENSMUSG00000074622', u'ENSMUSG00000044786']), symbols=u'Lmo2 Mafb Stat5a Stat5b Zfp36 Zfp36l1', symbol_set=set([u'Lmo2', u'Stat5a', u'Zfp36l1', u'Stat5b', u'Zfp36', u'Mafb']), geneids='ENSMUSG00000020919 ENSMUSG00000032698 ENSMUSG00000021127 ENSMUSG00000004043 ENSMUSG00000044786 ENSMUSG00000074622', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=0, D1='A', GO_name='negative regulation of erythrocyte differentiation'),
    Nt(p_uncorrected='', study_count='', study_n='', namespace='', p_fdr_bh='', study_items='', NS='BP', pop_items='', pop_n='', p_sm_bonferroni='', is_obsolete='', GO='GO:0016044', name='', pop_count='', alt_ids='', level=3, depth=3, enrichment='', Cluster='', geneid_set='', symbols='', symbol_set='', geneids='', format_txt=1, hdr_idx=1, is_hdrgo=True, is_usrgo=False, hdr1usr01='*', dcnt=277, D1='BH', GO_name='membrane organization'),
    Nt(p_uncorrected=0.0001185863251297332, study_count=17, study_n=1397, namespace='biological_process', p_fdr_bh=0.013611374333640815, study_items=set([u'ENSMUSG00000045092', u'ENSMUSG00000020053', u'ENSMUSG00000032440', u'ENSMUSG00000030849', u'ENSMUSG00000039191', u'ENSMUSG00000040152', u'ENSMUSG00000059883', u'ENSMUSG00000024620', u'ENSMUSG00000020919', u'ENSMUSG00000032006', u'ENSMUSG00000020644', u'ENSMUSG00000020122', u'ENSMUSG00000040552', u'ENSMUSG00000056529', u'ENSMUSG00000037820', u'ENSMUSG00000032849', u'ENSMUSG00000042626']), NS='BP', pop_items=set([u'ENSMUSG00000020053', u'ENSMUSG00000044014', u'ENSMUSG00000037820', u'ENSMUSG00000048001', u'ENSMUSG00000032487', u'ENSMUSG00000024620', u'ENSMUSG00000020572', u'ENSMUSG00000024397', u'ENSMUSG00000020516', u'ENSMUSG00000026104', u'ENSMUSG00000028341', u'ENSMUSG00000056529', u'ENSMUSG00000031778', u'ENSMUSG00000005533', u'ENSMUSG00000006519', u'ENSMUSG00000026313', u'ENSMUSG00000020919', u'ENSMUSG00000030849', u'ENSMUSG00000024486', u'ENSMUSG00000022346', u'ENSMUSG00000001642', u'ENSMUSG00000032440', u'ENSMUSG00000053819', u'ENSMUSG00000032508', u'ENSMUSG00000050965', u'ENSMUSG00000028587', u'ENSMUSG00000032849', u'ENSMUSG00000031841', u'ENSMUSG00000001729', u'ENSMUSG00000040552', u'ENSMUSG00000028991', u'ENSMUSG00000021103', u'ENSMUSG00000042626', u'ENSMUSG00000022812', u'ENSMUSG00000021670', u'ENSMUSG00000027947', u'ENSMUSG00000059588', u'ENSMUSG00000017831', u'ENSMUSG00000054115', u'ENSMUSG00000039217', u'ENSMUSG00000059883', u'ENSMUSG00000052684', u'ENSMUSG00000000489', u'ENSMUSG00000029167', u'ENSMUSG00000031392', u'ENSMUSG00000024639', u'ENSMUSG00000038418', u'ENSMUSG00000020689', u'ENSMUSG00000021109', u'ENSMUSG00000045092', u'ENSMUSG00000039191', u'ENSMUSG00000040152', u'ENSMUSG00000022607', u'ENSMUSG00000005413', u'ENSMUSG00000061079', u'ENSMUSG00000027164', u'ENSMUSG00000021835', u'ENSMUSG00000032006', u'ENSMUSG00000020644', u'ENSMUSG00000020122', u'ENSMUSG00000038146', u'ENSMUSG00000038224', u'ENSMUSG00000023951']), pop_n=13836, p_sm_bonferroni=1.0, is_obsolete=False, GO='GO:0048661', name='positive regulation of smooth muscle cell proliferation', pop_count=63, alt_ids=[], level=6, depth=6, enrichment='e', Cluster='Late Increase', geneid_set=set([u'ENSMUSG00000045092', u'ENSMUSG00000020053', u'ENSMUSG00000037820', u'ENSMUSG00000059883', u'ENSMUSG00000056529', u'ENSMUSG00000032849', u'ENSMUSG00000020919', u'ENSMUSG00000030849', u'ENSMUSG00000039191', u'ENSMUSG00000040152', u'ENSMUSG00000032440', u'ENSMUSG00000024620', u'ENSMUSG00000032006', u'ENSMUSG00000020644', u'ENSMUSG00000020122', u'ENSMUSG00000040552', u'ENSMUSG00000042626']), symbols=u'Abcc4 C3ar1 Egfr Fgfr2 Id2 Igf1 Irak4 Pdgfd Pdgfrb Ptafr Rbpj S1pr1 Shc1 Stat5b Tgfbr2 Tgm2 Thbs1', symbol_set=set([u'Tgfbr2', u'Tgm2', u'Igf1', u'Pdgfd', u'Shc1', u'Pdgfrb', u'Egfr', u'S1pr1', u'Id2', u'Thbs1', u'Stat5b', u'Ptafr', u'C3ar1', u'Abcc4', u'Fgfr2', u'Rbpj', u'Irak4']), geneids='ENSMUSG00000020053 ENSMUSG00000045092 ENSMUSG00000020919 ENSMUSG00000030849 ENSMUSG00000039191 ENSMUSG00000037820 ENSMUSG00000032440 ENSMUSG00000024620 ENSMUSG00000059883 ENSMUSG00000032006 ENSMUSG00000020644 ENSMUSG00000020122 ENSMUSG00000040552 ENSMUSG00000056529 ENSMUSG00000040152 ENSMUSG00000032849 ENSMUSG00000042626', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=1, D1='A', GO_name='positive regulation of smooth muscle cell proliferation'),
    Nt(p_uncorrected=0.0002536817784465898, study_count=19, study_n=1397, namespace='biological_process', p_fdr_bh=0.024230178913747787, study_items=set([u'ENSMUSG00000021136', u'ENSMUSG00000031273', u'ENSMUSG00000050335', u'ENSMUSG00000017344', u'ENSMUSG00000000567', u'ENSMUSG00000006369', u'ENSMUSG00000026193', u'ENSMUSG00000042116', u'ENSMUSG00000043631', u'ENSMUSG00000020932', u'ENSMUSG00000019803', u'ENSMUSG00000089661', u'ENSMUSG00000035273', u'ENSMUSG00000031825', u'ENSMUSG00000045672', u'ENSMUSG00000005397', u'ENSMUSG00000015850', u'ENSMUSG00000029675', u'ENSMUSG00000029163']), NS='BP', pop_items=set([u'ENSMUSG00000070305', u'ENSMUSG00000020716', u'ENSMUSG00000035258', u'ENSMUSG00000046618', u'ENSMUSG00000022449', u'ENSMUSG00000006369', u'ENSMUSG00000021186', u'ENSMUSG00000040998', u'ENSMUSG00000031996', u'ENSMUSG00000024076', u'ENSMUSG00000032187', u'ENSMUSG00000022892', u'ENSMUSG00000028413', u'ENSMUSG00000057069', u'ENSMUSG00000005397', u'ENSMUSG00000015850', u'ENSMUSG00000028763', u'ENSMUSG00000034009', u'ENSMUSG00000029231', u'ENSMUSG00000027195', u'ENSMUSG00000028476', u'ENSMUSG00000050335', u'ENSMUSG00000035273', u'ENSMUSG00000053175', u'ENSMUSG00000031825', u'ENSMUSG00000028195', u'ENSMUSG00000027315', u'ENSMUSG00000043631', u'ENSMUSG00000020932', u'ENSMUSG00000019803', u'ENSMUSG00000006651', u'ENSMUSG00000036356', u'ENSMUSG00000042961', u'ENSMUSG00000036040', u'ENSMUSG00000022665', u'ENSMUSG00000025225', u'ENSMUSG00000013150', u'ENSMUSG00000023886', u'ENSMUSG00000049001', u'ENSMUSG00000026141', u'ENSMUSG00000020674', u'ENSMUSG00000021136', u'ENSMUSG00000031273', u'ENSMUSG00000033933', u'ENSMUSG00000039254', u'ENSMUSG00000058297', u'ENSMUSG00000026768', u'ENSMUSG00000039239', u'ENSMUSG00000001435', u'ENSMUSG00000029131', u'ENSMUSG00000015659', u'ENSMUSG00000026193', u'ENSMUSG00000089661', u'ENSMUSG00000029163', u'ENSMUSG00000015829', u'ENSMUSG00000045672', u'ENSMUSG00000069895', u'ENSMUSG00000031980', u'ENSMUSG00000033792', u'ENSMUSG00000037032', u'ENSMUSG00000038463', u'ENSMUSG00000033327', u'ENSMUSG00000029345', u'ENSMUSG00000000567', u'ENSMUSG00000022607', u'ENSMUSG00000017344', u'ENSMUSG00000032558', u'ENSMUSG00000042116', u'ENSMUSG00000029675', u'ENSMUSG00000045576', u'ENSMUSG00000027750', u'ENSMUSG00000025289', u'ENSMUSG00000029307', u'ENSMUSG00000030400', u'ENSMUSG00000032572', u'ENSMUSG00000029207', u'ENSMUSG00000021831', u'ENSMUSG00000035493', u'ENSMUSG00000004098']), pop_n=13836, p_sm_bonferroni=1.0, is_obsolete=False, GO='GO:0030198', name='extracellular matrix organization', pop_count=79, alt_ids=[], level=4, depth=4, enrichment='e', Cluster='Late Increase', geneid_set=set([u'ENSMUSG00000021136', u'ENSMUSG00000031273', u'ENSMUSG00000035273', u'ENSMUSG00000006369', u'ENSMUSG00000029675', u'ENSMUSG00000089661', u'ENSMUSG00000026193', u'ENSMUSG00000045672', u'ENSMUSG00000005397', u'ENSMUSG00000015850', u'ENSMUSG00000029163', u'ENSMUSG00000050335', u'ENSMUSG00000017344', u'ENSMUSG00000000567', u'ENSMUSG00000031825', u'ENSMUSG00000042116', u'ENSMUSG00000043631', u'ENSMUSG00000020932', u'ENSMUSG00000019803']), symbols=u'Adamtsl4 Col27a1 Col4a6 Crispld2 Ecm2 Eln Emilin1 Fbln1 Fn1 Gfap Hpse Lgals3 Mia Nid1 Nr2e1 Smoc1 Sox9 Vtn Vwa1', symbol_set=set([u'Hpse', u'Crispld2', u'Eln', u'Adamtsl4', u'Fn1', 'Mia', u'Gfap', u'Nid1', u'Vtn', u'Emilin1', u'Col4a6', u'Col27a1', u'Sox9', u'Nr2e1', u'Lgals3', u'Smoc1', u'Vwa1', u'Ecm2', u'Fbln1']), geneids='ENSMUSG00000043631 ENSMUSG00000021136 ENSMUSG00000031273 ENSMUSG00000050335 ENSMUSG00000017344 ENSMUSG00000000567 ENSMUSG00000031825 ENSMUSG00000006369 ENSMUSG00000029675 ENSMUSG00000020932 ENSMUSG00000019803 ENSMUSG00000089661 ENSMUSG00000035273 ENSMUSG00000026193 ENSMUSG00000045672 ENSMUSG00000005397 ENSMUSG00000015850 ENSMUSG00000042116 ENSMUSG00000029163', format_txt=1, hdr_idx=1, is_hdrgo=True, is_usrgo=True, hdr1usr01='**', dcnt=25, D1='BCH', GO_name='extracellular matrix organization'),
    Nt(p_uncorrected=0.000103529696452711, study_count=4, study_n=1397, namespace='biological_process', p_fdr_bh=0.012351011267362396, study_items=set([u'ENSMUSG00000004043', u'ENSMUSG00000020919', u'ENSMUSG00000032238', u'ENSMUSG00000028150']), NS='BP', pop_items=set([u'ENSMUSG00000004043', u'ENSMUSG00000020919', u'ENSMUSG00000032238', u'ENSMUSG00000028150']), pop_n=13836, p_sm_bonferroni=1.0, is_obsolete=False, GO='GO:0019218', name='regulation of steroid metabolic process', pop_count=4, alt_ids=[], level=6, depth=6, enrichment='e', Cluster='Late Increase', geneid_set=set([u'ENSMUSG00000004043', u'ENSMUSG00000020919', u'ENSMUSG00000032238', u'ENSMUSG00000028150']), symbols=u'Rora Rorc Stat5a Stat5b', symbol_set=set([u'Stat5b', u'Stat5a', u'Rorc', u'Rora']), geneids='ENSMUSG00000004043 ENSMUSG00000020919 ENSMUSG00000032238 ENSMUSG00000028150', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=72, D1='A', GO_name='regulation of steroid metabolic process'),
    Nt(p_uncorrected='', study_count='', study_n='', namespace='', p_fdr_bh='', study_items='', NS='BP', pop_items='', pop_n='', p_sm_bonferroni='', is_obsolete='', GO='GO:0065008', name='', pop_count='', alt_ids='', level=2, depth=2, enrichment='', Cluster='', geneid_set='', symbols='', symbol_set='', geneids='', format_txt=1, hdr_idx=1, is_hdrgo=True, is_usrgo=False, hdr1usr01='*', dcnt=2334, D1='A', GO_name='regulation of biological quality'),
    Nt(p_uncorrected=5.81776650518607e-06, study_count=50, study_n=1397, namespace='biological_process', p_fdr_bh=0.0012414785960573823, study_items=set([u'ENSMUSG00000032766', u'ENSMUSG00000048960', u'ENSMUSG00000033446', u'ENSMUSG00000048120', u'ENSMUSG00000045087', u'ENSMUSG00000031486', u'ENSMUSG00000029778', u'ENSMUSG00000039167', u'ENSMUSG00000021457', u'ENSMUSG00000042190', u'ENSMUSG00000008734', u'ENSMUSG00000019122', u'ENSMUSG00000045382', u'ENSMUSG00000056529', u'ENSMUSG00000018500', u'ENSMUSG00000039904', u'ENSMUSG00000027765', u'ENSMUSG00000024960', u'ENSMUSG00000001761', u'ENSMUSG00000032562', u'ENSMUSG00000004730', u'ENSMUSG00000042644', u'ENSMUSG00000031785', u'ENSMUSG00000048376', u'ENSMUSG00000018927', u'ENSMUSG00000056492', u'ENSMUSG00000000149', u'ENSMUSG00000059810', u'ENSMUSG00000040552', u'ENSMUSG00000020611', u'ENSMUSG00000016028', u'ENSMUSG00000045092', u'ENSMUSG00000022297', u'ENSMUSG00000015243', u'ENSMUSG00000030168', u'ENSMUSG00000047875', u'ENSMUSG00000026678', u'ENSMUSG00000051212', u'ENSMUSG00000036402', u'ENSMUSG00000020573', u'ENSMUSG00000029371', u'ENSMUSG00000040229', u'ENSMUSG00000052336', u'ENSMUSG00000002985', u'ENSMUSG00000026424', u'ENSMUSG00000022122', u'ENSMUSG00000020591', u'ENSMUSG00000037820', u'ENSMUSG00000024998', u'ENSMUSG00000069170']), NS='BP', pop_items=set([u'ENSMUSG00000028184', u'ENSMUSG00000021719', u'ENSMUSG00000003974', u'ENSMUSG00000034009', u'ENSMUSG00000059495', u'ENSMUSG00000042190', u'ENSMUSG00000056679', u'ENSMUSG00000036437', u'ENSMUSG00000026360', u'ENSMUSG00000049511', u'ENSMUSG00000041977', u'ENSMUSG00000044337', u'ENSMUSG00000031778', u'ENSMUSG00000018500', u'ENSMUSG00000050164', u'ENSMUSG00000046207', u'ENSMUSG00000052229', u'ENSMUSG00000045087', u'ENSMUSG00000040009', u'ENSMUSG00000027669', u'ENSMUSG00000002885', u'ENSMUSG00000023078', u'ENSMUSG00000013033', u'ENSMUSG00000034730', u'ENSMUSG00000035620', u'ENSMUSG00000020599', u'ENSMUSG00000004815', u'ENSMUSG00000041075', u'ENSMUSG00000019775', u'ENSMUSG00000020611', u'ENSMUSG00000050558', u'ENSMUSG00000020591', u'ENSMUSG00000048779', u'ENSMUSG00000033717', u'ENSMUSG00000000766', u'ENSMUSG00000041380', u'ENSMUSG00000030168', u'ENSMUSG00000058396', u'ENSMUSG00000032641', u'ENSMUSG00000049929', u'ENSMUSG00000040495', u'ENSMUSG00000045502', u'ENSMUSG00000023830', u'ENSMUSG00000024960', u'ENSMUSG00000036904', u'ENSMUSG00000021219', u'ENSMUSG00000000982', u'ENSMUSG00000027335', u'ENSMUSG00000052821', u'ENSMUSG00000035283', u'ENSMUSG00000038811', u'ENSMUSG00000020901', u'ENSMUSG00000035431', u'ENSMUSG00000038760', u'ENSMUSG00000026424', u'ENSMUSG00000029713', u'ENSMUSG00000023473', u'ENSMUSG00000041468', u'ENSMUSG00000032766', u'ENSMUSG00000045092', u'ENSMUSG00000042429', u'ENSMUSG00000062232', u'ENSMUSG00000031486', u'ENSMUSG00000044674', u'ENSMUSG00000021478', u'ENSMUSG00000028004', u'ENSMUSG00000051043', u'ENSMUSG00000062585', u'ENSMUSG00000056529', u'ENSMUSG00000043895', u'ENSMUSG00000015243', u'ENSMUSG00000044288', u'ENSMUSG00000021886', u'ENSMUSG00000001847', u'ENSMUSG00000037014', u'ENSMUSG00000043999', u'ENSMUSG00000032562', u'ENSMUSG00000037010', u'ENSMUSG00000025739', u'ENSMUSG00000045005', u'ENSMUSG00000000001', u'ENSMUSG00000024211', u'ENSMUSG00000035773', u'ENSMUSG00000045730', u'ENSMUSG00000040229', u'ENSMUSG00000056492', u'ENSMUSG00000011171', u'ENSMUSG00000035352', u'ENSMUSG00000027523', u'ENSMUSG00000040552', u'ENSMUSG00000018909', u'ENSMUSG00000016028', u'ENSMUSG00000047875', u'ENSMUSG00000034116', u'ENSMUSG00000032773', u'ENSMUSG00000038390', u'ENSMUSG00000039059', u'ENSMUSG00000042804', u'ENSMUSG00000039904', u'ENSMUSG00000038530', u'ENSMUSG00000051212', u'ENSMUSG00000034855', u'ENSMUSG00000066406', u'ENSMUSG00000046159', u'ENSMUSG00000024639', u'ENSMUSG00000001761', u'ENSMUSG00000034353', u'ENSMUSG00000018930', u'ENSMUSG00000053164', u'ENSMUSG00000091735', u'ENSMUSG00000026322', u'ENSMUSG00000026527', u'ENSMUSG00000024186', u'ENSMUSG00000036362', u'ENSMUSG00000040133', u'ENSMUSG00000024858', u'ENSMUSG00000024462', u'ENSMUSG00000030898', u'ENSMUSG00000063239', u'ENSMUSG00000015085', u'ENSMUSG00000044933', u'ENSMUSG00000039116', u'ENSMUSG00000037872', u'ENSMUSG00000031955', u'ENSMUSG00000024998', u'ENSMUSG00000033917', u'ENSMUSG00000033446', u'ENSMUSG00000029417', u'ENSMUSG00000039106', u'ENSMUSG00000023192', u'ENSMUSG00000032259', u'ENSMUSG00000019122', u'ENSMUSG00000021303', u'ENSMUSG00000029090', u'ENSMUSG00000050199', u'ENSMUSG00000028782', u'ENSMUSG00000036402', u'ENSMUSG00000032360', u'ENSMUSG00000057614', u'ENSMUSG00000027584', u'ENSMUSG00000071658', u'ENSMUSG00000047259', u'ENSMUSG00000040125', u'ENSMUSG00000010660', u'ENSMUSG00000025475', u'ENSMUSG00000045967', u'ENSMUSG00000042644', u'ENSMUSG00000031785', u'ENSMUSG00000002985', u'ENSMUSG00000018927', u'ENSMUSG00000034997', u'ENSMUSG00000045875', u'ENSMUSG00000000149', u'ENSMUSG00000059810', u'ENSMUSG00000049791', u'ENSMUSG00000038668', u'ENSMUSG00000047904', u'ENSMUSG00000018634', u'ENSMUSG00000048216', u'ENSMUSG00000044067', u'ENSMUSG00000047415', u'ENSMUSG00000022297', u'ENSMUSG00000039358', u'ENSMUSG00000021721', u'ENSMUSG00000044014', u'ENSMUSG00000053647', u'ENSMUSG00000022131', u'ENSMUSG00000050288', u'ENSMUSG00000067586', u'ENSMUSG00000032192', u'ENSMUSG00000054843', u'ENSMUSG00000007989', u'ENSMUSG00000029371', u'ENSMUSG00000050511', u'ENSMUSG00000050783', u'ENSMUSG00000033569', u'ENSMUSG00000031932', u'ENSMUSG00000040836', u'ENSMUSG00000038607', u'ENSMUSG00000024524', u'ENSMUSG00000033220', u'ENSMUSG00000037605', u'ENSMUSG00000019433', u'ENSMUSG00000022122', u'ENSMUSG00000049112', u'ENSMUSG00000002459', u'ENSMUSG00000060735', u'ENSMUSG00000006127', u'ENSMUSG00000053004', u'ENSMUSG00000049649', u'ENSMUSG00000001240', u'ENSMUSG00000021457', u'ENSMUSG00000048960', u'ENSMUSG00000046961', u'ENSMUSG00000034987', u'ENSMUSG00000048965', u'ENSMUSG00000048120', u'ENSMUSG00000037820', u'ENSMUSG00000029778', u'ENSMUSG00000026678', u'ENSMUSG00000027568', u'ENSMUSG00000020573', u'ENSMUSG00000034781', u'ENSMUSG00000074939', u'ENSMUSG00000045382', u'ENSMUSG00000005534', u'ENSMUSG00000039809', u'ENSMUSG00000056755', u'ENSMUSG00000031616', u'ENSMUSG00000050534', u'ENSMUSG00000027765', u'ENSMUSG00000040016', u'ENSMUSG00000024798', u'ENSMUSG00000052087', u'ENSMUSG00000004730', u'ENSMUSG00000039167', u'ENSMUSG00000036357', u'ENSMUSG00000048376', u'ENSMUSG00000036353', u'ENSMUSG00000059588', u'ENSMUSG00000032528', u'ENSMUSG00000008734', u'ENSMUSG00000068696', u'ENSMUSG00000032492', u'ENSMUSG00000034792', u'ENSMUSG00000043659', u'ENSMUSG00000048240', u'ENSMUSG00000039621', u'ENSMUSG00000070337', u'ENSMUSG00000045318', u'ENSMUSG00000049583', u'ENSMUSG00000045613', u'ENSMUSG00000019828', u'ENSMUSG00000068747', u'ENSMUSG00000024789', u'ENSMUSG00000069170', u'ENSMUSG00000068037', u'ENSMUSG00000068740', u'ENSMUSG00000031748', u'ENSMUSG00000031980', u'ENSMUSG00000029064', u'ENSMUSG00000050541', u'ENSMUSG00000043398', u'ENSMUSG00000043004', u'ENSMUSG00000035385', u'ENSMUSG00000047507', u'ENSMUSG00000078624', u'ENSMUSG00000079227', u'ENSMUSG00000046793', u'ENSMUSG00000052336', u'ENSMUSG00000042671', u'ENSMUSG00000041907', u'ENSMUSG00000063234', u'ENSMUSG00000026475', u'ENSMUSG00000043843', u'ENSMUSG00000060216', u'ENSMUSG00000037624', u'ENSMUSG00000028172', u'ENSMUSG00000040372']), pop_n=13836, p_sm_bonferroni=0.08814498032007415, is_obsolete=False, GO='GO:0007186', name='G-protein coupled receptor signaling pathway', pop_count=259, alt_ids=[], level=3, depth=5, enrichment='e', Cluster='Late Increase', geneid_set=set([u'ENSMUSG00000032766', u'ENSMUSG00000048960', u'ENSMUSG00000033446', u'ENSMUSG00000048120', u'ENSMUSG00000045087', u'ENSMUSG00000031486', u'ENSMUSG00000029778', u'ENSMUSG00000039167', u'ENSMUSG00000021457', u'ENSMUSG00000042190', u'ENSMUSG00000008734', u'ENSMUSG00000019122', u'ENSMUSG00000045382', u'ENSMUSG00000056529', u'ENSMUSG00000018500', u'ENSMUSG00000039904', u'ENSMUSG00000027765', u'ENSMUSG00000001761', u'ENSMUSG00000032562', u'ENSMUSG00000004730', u'ENSMUSG00000042644', u'ENSMUSG00000031785', u'ENSMUSG00000048376', u'ENSMUSG00000018927', u'ENSMUSG00000056492', u'ENSMUSG00000000149', u'ENSMUSG00000059810', u'ENSMUSG00000040552', u'ENSMUSG00000020611', u'ENSMUSG00000016028', u'ENSMUSG00000045092', u'ENSMUSG00000022297', u'ENSMUSG00000015243', u'ENSMUSG00000030168', u'ENSMUSG00000047875', u'ENSMUSG00000026678', u'ENSMUSG00000020573', u'ENSMUSG00000051212', u'ENSMUSG00000036402', u'ENSMUSG00000024960', u'ENSMUSG00000029371', u'ENSMUSG00000040229', u'ENSMUSG00000052336', u'ENSMUSG00000002985', u'ENSMUSG00000026424', u'ENSMUSG00000022122', u'ENSMUSG00000020591', u'ENSMUSG00000037820', u'ENSMUSG00000024998', u'ENSMUSG00000069170']), symbols=u'Abca1 Adcyap1r1 Adgra2 Adgre1 Adgrf5 Adgrg1 Adgrl4 Adgrv1 Adipor2 Adora2b Apoe C3ar1 Ccl6 Ccl9 Celsr1 Cmklr1 Cx3cr1 Cxcl5 Cxcr4 Ednrb Entpd1 F2r Fzd6 Gna12 Gna13 Gnai2 Gng11 Gng12 Gpr157 Gpr183 Gpr34 Gpr37 Gpr37l1 Gprc5b Itpr3 Lpar6 Ntsr2 P2ry1 Pik3cg Plcb3 Plce1 Prex2 Ptafr Rgs3 Rgs5 S1pr1 S1pr5 Smo Syk Tgm2', symbol_set=set([u'Adora2b', u'Apoe', u'Cxcl5', u'Entpd1', u'Ntsr2', u'Abca1', 'Adgre1', u'Smo', u'Ptafr', u'Gng12', 'Adgrv1', u'Ccl6', u'Lpar6', u'Gprc5b', u'Adcyap1r1', u'Gpr157', u'Syk', u'Adipor2', u'Pik3cg', u'Rgs5', u'Gna12', u'Gna13', u'Rgs3', u'Itpr3', u'Gnai2', u'Gpr37l1', u'Tgm2', u'Plce1', u'Prex2', u'Cx3cr1', u'Ccl9', 'Adgrf5', u'Celsr1', u'F2r', 'Adgrl4', u'Cxcr4', u'Ednrb', u'P2ry1', u'Gpr34', u'Gpr37', u'Plcb3', u'Fzd6', u'C3ar1', u'S1pr1', u'Gpr183', u'Gng11', u'S1pr5', 'Adgra2', 'Adgrg1', u'Cmklr1']), geneids='ENSMUSG00000032766 ENSMUSG00000048960 ENSMUSG00000033446 ENSMUSG00000048120 ENSMUSG00000037820 ENSMUSG00000031486 ENSMUSG00000029778 ENSMUSG00000026678 ENSMUSG00000042644 ENSMUSG00000021457 ENSMUSG00000042190 ENSMUSG00000008734 ENSMUSG00000019122 ENSMUSG00000045382 ENSMUSG00000056529 ENSMUSG00000018500 ENSMUSG00000031785 ENSMUSG00000027765 ENSMUSG00000001761 ENSMUSG00000032562 ENSMUSG00000045087 ENSMUSG00000004730 ENSMUSG00000039167 ENSMUSG00000002985 ENSMUSG00000048376 ENSMUSG00000018927 ENSMUSG00000056492 ENSMUSG00000000149 ENSMUSG00000059810 ENSMUSG00000040552 ENSMUSG00000039904 ENSMUSG00000020611 ENSMUSG00000020591 ENSMUSG00000045092 ENSMUSG00000022297 ENSMUSG00000015243 ENSMUSG00000030168 ENSMUSG00000047875 ENSMUSG00000020573 ENSMUSG00000051212 ENSMUSG00000036402 ENSMUSG00000024960 ENSMUSG00000029371 ENSMUSG00000040229 ENSMUSG00000052336 ENSMUSG00000026424 ENSMUSG00000022122 ENSMUSG00000016028 ENSMUSG00000024998 ENSMUSG00000069170', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=100, D1='AB', GO_name='G-protein coupled receptor signaling pathway'),
    Nt(p_uncorrected='', study_count='', study_n='', namespace='', p_fdr_bh='', study_items='', NS='BP', pop_items='', pop_n='', p_sm_bonferroni='', is_obsolete='', GO='GO:0048646', name='', pop_count='', alt_ids='', level=2, depth=2, enrichment='', Cluster='', geneid_set='', symbols='', symbol_set='', geneids='', format_txt=1, hdr_idx=1, is_hdrgo=True, is_usrgo=False, hdr1usr01='*', dcnt=321, D1='E', GO_name='anatomical structure formation involved in morphogenesis'),
    Nt(p_uncorrected=2.423421839301542e-10, study_count=78, study_n=1397, namespace='biological_process', p_fdr_bh=3.0597720239381384e-07, study_items=set([u'ENSMUSG00000029919', u'ENSMUSG00000026922', u'ENSMUSG00000019359', u'ENSMUSG00000029413', u'ENSMUSG00000060675', u'ENSMUSG00000021242', u'ENSMUSG00000000594', u'ENSMUSG00000031483', u'ENSMUSG00000060002', u'ENSMUSG00000004270', u'ENSMUSG00000020538', u'ENSMUSG00000005615', u'ENSMUSG00000020828', u'ENSMUSG00000040997', u'ENSMUSG00000037686', u'ENSMUSG00000015714', u'ENSMUSG00000059447', u'ENSMUSG00000024978', u'ENSMUSG00000037697', u'ENSMUSG00000032883', u'ENSMUSG00000063856', u'ENSMUSG00000032540', u'ENSMUSG00000004207', u'ENSMUSG00000035686', u'ENSMUSG00000032349', u'ENSMUSG00000026003', u'ENSMUSG00000025203', u'ENSMUSG00000028223', u'ENSMUSG00000027984', u'ENSMUSG00000017754', u'ENSMUSG00000022175', u'ENSMUSG00000031903', u'ENSMUSG00000024998', u'ENSMUSG00000029925', u'ENSMUSG00000032281', u'ENSMUSG00000020646', u'ENSMUSG00000035376', u'ENSMUSG00000024665', u'ENSMUSG00000035237', u'ENSMUSG00000020777', u'ENSMUSG00000076435', u'ENSMUSG00000026701', u'ENSMUSG00000024164', u'ENSMUSG00000038633', u'ENSMUSG00000030168', u'ENSMUSG00000027695', u'ENSMUSG00000038349', u'ENSMUSG00000023913', u'ENSMUSG00000031591', u'ENSMUSG00000021884', u'ENSMUSG00000039206', u'ENSMUSG00000033579', u'ENSMUSG00000006390', u'ENSMUSG00000024781', u'ENSMUSG00000024960', u'ENSMUSG00000024413', u'ENSMUSG00000038173', u'ENSMUSG00000043733', u'ENSMUSG00000018574', u'ENSMUSG00000033174', u'ENSMUSG00000030711', u'ENSMUSG00000026457', u'ENSMUSG00000042010', u'ENSMUSG00000079057', u'ENSMUSG00000044788', u'ENSMUSG00000002475', u'ENSMUSG00000031918', u'ENSMUSG00000022548', u'ENSMUSG00000020097', u'ENSMUSG00000024900', u'ENSMUSG00000002985', u'ENSMUSG00000003623', u'ENSMUSG00000026173', u'ENSMUSG00000020333', u'ENSMUSG00000028497', u'ENSMUSG00000026600', u'ENSMUSG00000036833', u'ENSMUSG00000008035']), NS='BP', pop_items=set([u'ENSMUSG00000029513', u'ENSMUSG00000026499', u'ENSMUSG00000005615', u'ENSMUSG00000034926', u'ENSMUSG00000031467', u'ENSMUSG00000022853', u'ENSMUSG00000031903', u'ENSMUSG00000017146', u'ENSMUSG00000024164', u'ENSMUSG00000030168', u'ENSMUSG00000049721', u'ENSMUSG00000040875', u'ENSMUSG00000042010', u'ENSMUSG00000031349', u'ENSMUSG00000004270', u'ENSMUSG00000036138', u'ENSMUSG00000003271', u'ENSMUSG00000031168', u'ENSMUSG00000020538', u'ENSMUSG00000020532', u'ENSMUSG00000031641', u'ENSMUSG00000021884', u'ENSMUSG00000056553', u'ENSMUSG00000019822', u'ENSMUSG00000063810', u'ENSMUSG00000024764', u'ENSMUSG00000020937', u'ENSMUSG00000031835', u'ENSMUSG00000026726', u'ENSMUSG00000032807', u'ENSMUSG00000038349', u'ENSMUSG00000003123', u'ENSMUSG00000019139', u'ENSMUSG00000029311', u'ENSMUSG00000024900', u'ENSMUSG00000043733', u'ENSMUSG00000029314', u'ENSMUSG00000037071', u'ENSMUSG00000003721', u'ENSMUSG00000022548', u'ENSMUSG00000021036', u'ENSMUSG00000027533', u'ENSMUSG00000041653', u'ENSMUSG00000042632', u'ENSMUSG00000024998', u'ENSMUSG00000049313', u'ENSMUSG00000029413', u'ENSMUSG00000050697', u'ENSMUSG00000020828', u'ENSMUSG00000037366', u'ENSMUSG00000028470', u'ENSMUSG00000025153', u'ENSMUSG00000028093', u'ENSMUSG00000020917', u'ENSMUSG00000028158', u'ENSMUSG00000050211', u'ENSMUSG00000031906', u'ENSMUSG00000059743', u'ENSMUSG00000031337', u'ENSMUSG00000018796', u'ENSMUSG00000028381', u'ENSMUSG00000032349', u'ENSMUSG00000031545', u'ENSMUSG00000038910', u'ENSMUSG00000040938', u'ENSMUSG00000015214', u'ENSMUSG00000023021', u'ENSMUSG00000044968', u'ENSMUSG00000021242', u'ENSMUSG00000021364', u'ENSMUSG00000031613', u'ENSMUSG00000015714', u'ENSMUSG00000004207', u'ENSMUSG00000040061', u'ENSMUSG00000044408', u'ENSMUSG00000063856', u'ENSMUSG00000038007', u'ENSMUSG00000032281', u'ENSMUSG00000036810', u'ENSMUSG00000028672', u'ENSMUSG00000003363', u'ENSMUSG00000028670', u'ENSMUSG00000024781', u'ENSMUSG00000029919', u'ENSMUSG00000020097', u'ENSMUSG00000025903', u'ENSMUSG00000008035', u'ENSMUSG00000074064', u'ENSMUSG00000060675', u'ENSMUSG00000030759', u'ENSMUSG00000029598', u'ENSMUSG00000024978', u'ENSMUSG00000002985', u'ENSMUSG00000035239', u'ENSMUSG00000020892', u'ENSMUSG00000020891', u'ENSMUSG00000059316', u'ENSMUSG00000025198', u'ENSMUSG00000027875', u'ENSMUSG00000007783', u'ENSMUSG00000015659', u'ENSMUSG00000022525', u'ENSMUSG00000020745', u'ENSMUSG00000001467', u'ENSMUSG00000022383', u'ENSMUSG00000027952', u'ENSMUSG00000030275', u'ENSMUSG00000024052', u'ENSMUSG00000006517', u'ENSMUSG00000004565', u'ENSMUSG00000030283', u'ENSMUSG00000031808', u'ENSMUSG00000032018', u'ENSMUSG00000054469', u'ENSMUSG00000021770', u'ENSMUSG00000030303', u'ENSMUSG00000029134', u'ENSMUSG00000026922', u'ENSMUSG00000026925', u'ENSMUSG00000036775', u'ENSMUSG00000037686', u'ENSMUSG00000003131', u'ENSMUSG00000019359', u'ENSMUSG00000032883', u'ENSMUSG00000033579', u'ENSMUSG00000021594', u'ENSMUSG00000010663', u'ENSMUSG00000010660', u'ENSMUSG00000047250', u'ENSMUSG00000027134', u'ENSMUSG00000024981', u'ENSMUSG00000035376', u'ENSMUSG00000032902', u'ENSMUSG00000076435', u'ENSMUSG00000027984', u'ENSMUSG00000062908', u'ENSMUSG00000028145', u'ENSMUSG00000030711', u'ENSMUSG00000024526', u'ENSMUSG00000027346', u'ENSMUSG00000028048', u'ENSMUSG00000033629', u'ENSMUSG00000040997', u'ENSMUSG00000028910', u'ENSMUSG00000037295', u'ENSMUSG00000040451', u'ENSMUSG00000020777', u'ENSMUSG00000032051', u'ENSMUSG00000048755', u'ENSMUSG00000021273', u'ENSMUSG00000018574', u'ENSMUSG00000051413', u'ENSMUSG00000017715', u'ENSMUSG00000019877', u'ENSMUSG00000040774', u'ENSMUSG00000021786', u'ENSMUSG00000024413', u'ENSMUSG00000044788', u'ENSMUSG00000049148', u'ENSMUSG00000002250', u'ENSMUSG00000032540', u'ENSMUSG00000034088', u'ENSMUSG00000025465', u'ENSMUSG00000001211', u'ENSMUSG00000029925', u'ENSMUSG00000024664', u'ENSMUSG00000024665', u'ENSMUSG00000025509', u'ENSMUSG00000026701', u'ENSMUSG00000021696', u'ENSMUSG00000029330', u'ENSMUSG00000030682', u'ENSMUSG00000024960', u'ENSMUSG00000010651', u'ENSMUSG00000042759', u'ENSMUSG00000028749', u'ENSMUSG00000034330', u'ENSMUSG00000022040', u'ENSMUSG00000032487', u'ENSMUSG00000032485', u'ENSMUSG00000060002', u'ENSMUSG00000041220', u'ENSMUSG00000035596', u'ENSMUSG00000025137', u'ENSMUSG00000067713', u'ENSMUSG00000024843', u'ENSMUSG00000035686', u'ENSMUSG00000050370', u'ENSMUSG00000030861', u'ENSMUSG00000021608', u'ENSMUSG00000030869', u'ENSMUSG00000051177', u'ENSMUSG00000021468', u'ENSMUSG00000064247', u'ENSMUSG00000031708', u'ENSMUSG00000045294', u'ENSMUSG00000063568', u'ENSMUSG00000027035', u'ENSMUSG00000002475', u'ENSMUSG00000035069', u'ENSMUSG00000017754', u'ENSMUSG00000020646', u'ENSMUSG00000063235', u'ENSMUSG00000062054', u'ENSMUSG00000030316', u'ENSMUSG00000029098', u'ENSMUSG00000015568', u'ENSMUSG00000026457', u'ENSMUSG00000026456', u'ENSMUSG00000021518', u'ENSMUSG00000032262', u'ENSMUSG00000015090', u'ENSMUSG00000025428', u'ENSMUSG00000027698', u'ENSMUSG00000056220', u'ENSMUSG00000038205', u'ENSMUSG00000027695', u'ENSMUSG00000026853', u'ENSMUSG00000033105', u'ENSMUSG00000037697', u'ENSMUSG00000025495', u'ENSMUSG00000020593', u'ENSMUSG00000033192', u'ENSMUSG00000035237', u'ENSMUSG00000020333', u'ENSMUSG00000036834', u'ENSMUSG00000025393', u'ENSMUSG00000036833', u'ENSMUSG00000026675', u'ENSMUSG00000016933', u'ENSMUSG00000028518', u'ENSMUSG00000050737', u'ENSMUSG00000029482', u'ENSMUSG00000027195', u'ENSMUSG00000024924', u'ENSMUSG00000079057', u'ENSMUSG00000041193', u'ENSMUSG00000024887', u'ENSMUSG00000027357', u'ENSMUSG00000070644', u'ENSMUSG00000027359', u'ENSMUSG00000063275', u'ENSMUSG00000021703', u'ENSMUSG00000031591', u'ENSMUSG00000031918', u'ENSMUSG00000027999', u'ENSMUSG00000023452', u'ENSMUSG00000026173', u'ENSMUSG00000038633', u'ENSMUSG00000034000', u'ENSMUSG00000008206', u'ENSMUSG00000028223', u'ENSMUSG00000039519', u'ENSMUSG00000087141', u'ENSMUSG00000021263', u'ENSMUSG00000029059', u'ENSMUSG00000029055', u'ENSMUSG00000053846', u'ENSMUSG00000036880', u'ENSMUSG00000035735', u'ENSMUSG00000026003', u'ENSMUSG00000022175', u'ENSMUSG00000027412', u'ENSMUSG00000031278', u'ENSMUSG00000075703', u'ENSMUSG00000038173', u'ENSMUSG00000033327', u'ENSMUSG00000006390', u'ENSMUSG00000026307', u'ENSMUSG00000032558', u'ENSMUSG00000009905', u'ENSMUSG00000079477', u'ENSMUSG00000071072', u'ENSMUSG00000026820', u'ENSMUSG00000013663', u'ENSMUSG00000052160', u'ENSMUSG00000039202', u'ENSMUSG00000039206', u'ENSMUSG00000033174', u'ENSMUSG00000022425', u'ENSMUSG00000023827', u'ENSMUSG00000029233', u'ENSMUSG00000036257', u'ENSMUSG00000041544', u'ENSMUSG00000025203', u'ENSMUSG00000005447', u'ENSMUSG00000018865', u'ENSMUSG00000018861', u'ENSMUSG00000050931', u'ENSMUSG00000016194', u'ENSMUSG00000029545', u'ENSMUSG00000023913', u'ENSMUSG00000026623', u'ENSMUSG00000028467', u'ENSMUSG00000034354', u'ENSMUSG00000024507', u'ENSMUSG00000028944', u'ENSMUSG00000020484', u'ENSMUSG00000028497', u'ENSMUSG00000026600', u'ENSMUSG00000033917', u'ENSMUSG00000015016', u'ENSMUSG00000024132', u'ENSMUSG00000027932', u'ENSMUSG00000041939', u'ENSMUSG00000058793', u'ENSMUSG00000059447', u'ENSMUSG00000037270', u'ENSMUSG00000042410', u'ENSMUSG00000071657', u'ENSMUSG00000018042', u'ENSMUSG00000061313', u'ENSMUSG00000021259', u'ENSMUSG00000053898', u'ENSMUSG00000021252', u'ENSMUSG00000055923', u'ENSMUSG00000031483', u'ENSMUSG00000031604', u'ENSMUSG00000032193', u'ENSMUSG00000021759', u'ENSMUSG00000061666', u'ENSMUSG00000003623', u'ENSMUSG00000007038', u'ENSMUSG00000035314', u'ENSMUSG00000021003', u'ENSMUSG00000000594', u'ENSMUSG00000044626', u'ENSMUSG00000032854', u'ENSMUSG00000058454', u'ENSMUSG00000024799', u'ENSMUSG00000022617', u'ENSMUSG00000058966', u'ENSMUSG00000021670', u'ENSMUSG00000047878', u'ENSMUSG00000035246', u'ENSMUSG00000030747', u'ENSMUSG00000028885', u'ENSMUSG00000034254', u'ENSMUSG00000028607', u'ENSMUSG00000022463', u'ENSMUSG00000028601', u'ENSMUSG00000024892', u'ENSMUSG00000025745']), pop_n=13836, p_sm_bonferroni=3.6717264287257663e-06, is_obsolete=False, GO='GO:0006629', name='lipid metabolic process', pop_count=343, alt_ids=[], level=3, depth=3, enrichment='e', Cluster='Late Increase', geneid_set=set([u'ENSMUSG00000026922', u'ENSMUSG00000029413', u'ENSMUSG00000060675', u'ENSMUSG00000005615', u'ENSMUSG00000020828', u'ENSMUSG00000037686', u'ENSMUSG00000008035', u'ENSMUSG00000022175', u'ENSMUSG00000024978', u'ENSMUSG00000032883', u'ENSMUSG00000033579', u'ENSMUSG00000032540', u'ENSMUSG00000026457', u'ENSMUSG00000026003', u'ENSMUSG00000028223', u'ENSMUSG00000059447', u'ENSMUSG00000031903', u'ENSMUSG00000029925', u'ENSMUSG00000035376', u'ENSMUSG00000024665', u'ENSMUSG00000035237', u'ENSMUSG00000076435', u'ENSMUSG00000015714', u'ENSMUSG00000024164', u'ENSMUSG00000030168', u'ENSMUSG00000027695', u'ENSMUSG00000039206', u'ENSMUSG00000030711', u'ENSMUSG00000037697', u'ENSMUSG00000024960', u'ENSMUSG00000033174', u'ENSMUSG00000006390', u'ENSMUSG00000032349', u'ENSMUSG00000042010', u'ENSMUSG00000004270', u'ENSMUSG00000003623', u'ENSMUSG00000020333', u'ENSMUSG00000036833', u'ENSMUSG00000019359', u'ENSMUSG00000021242', u'ENSMUSG00000000594', u'ENSMUSG00000031483', u'ENSMUSG00000060002', u'ENSMUSG00000020538', u'ENSMUSG00000040997', u'ENSMUSG00000026701', u'ENSMUSG00000022548', u'ENSMUSG00000004207', u'ENSMUSG00000035686', u'ENSMUSG00000025203', u'ENSMUSG00000027984', u'ENSMUSG00000063856', u'ENSMUSG00000020777', u'ENSMUSG00000032281', u'ENSMUSG00000028497', u'ENSMUSG00000038173', u'ENSMUSG00000038349', u'ENSMUSG00000023913', u'ENSMUSG00000031591', u'ENSMUSG00000021884', u'ENSMUSG00000024781', u'ENSMUSG00000024900', u'ENSMUSG00000043733', u'ENSMUSG00000018574', u'ENSMUSG00000029919', u'ENSMUSG00000079057', u'ENSMUSG00000026600', u'ENSMUSG00000002475', u'ENSMUSG00000031918', u'ENSMUSG00000044788', u'ENSMUSG00000020097', u'ENSMUSG00000017754', u'ENSMUSG00000002985', u'ENSMUSG00000020646', u'ENSMUSG00000026173', u'ENSMUSG00000024413', u'ENSMUSG00000038633', u'ENSMUSG00000024998']), symbols=u'Abhd3 Abhd4 Abhd5 Acacb Acadl Acadvl Acox1 Acsbg1 Acsf2 Acsl3 Acsl6 Adipor1 Adipor2 Agpat2 Apod Apoe Asah1 Aspg C3 Cers2 Chpt1 Cpt1a Crot Cyp4v3 Daglb Ddhd1 Decr1 Degs1 Elovl1 Elovl5 Enpp6 Erlin2 Fa2h Fads2 Fads6 Gdpd2 Gm2a Gpam Gpx1 Hacd2 Hacd4 Hacl1 Hadh Hadhb Hpgds Lcat Lipa Lpcat3 Lrp10 Mboat2 Mgll Mid1ip1 Mtmr2 Naaa Npc1 Npc2 Pcyt1a Pla2g15 Pla2g16 Pla2g7 Plcb3 Plcd4 Plce1 Plcl1 Pld1 Pld2 Pltp Pnpla7 Prdx6 Psap Ptpn11 Scd2 Sgpl1 Soat1 Srebf1 Sult1a1 Tbxas1 Thrsp', symbol_set=set([u'Lrp10', u'Hadh', u'Apod', u'Aspg', 'Cers2', u'Degs1', u'Scd2', u'Acsl3', u'Ptpn11', u'Acox1', u'Acsl6', u'Thrsp', u'Sgpl1', u'Pla2g7', u'Apoe', 'Hacd2', u'Pltp', u'Acsbg1', u'Acadl', u'Mtmr2', u'Asah1', 'Hacd4', u'Cpt1a', u'Acadvl', u'Pld1', u'Pld2', u'Hadhb', u'Prdx6', u'Acacb', u'Soat1', u'Hpgds', u'Gpx1', u'Srebf1', u'Plce1', u'Agpat2', u'C3', u'Hacl1', u'Daglb', u'Fads2', u'Mgll', u'Fads6', u'Pla2g15', u'Pla2g16', u'Gpam', u'Adipor2', u'Tbxas1', u'Adipor1', u'Ddhd1', u'Psap', u'Sult1a1', u'Gdpd2', u'Chpt1', u'Decr1', u'Abhd4', u'Pcyt1a', u'Lipa', u'Plcb3', u'Naaa', u'Erlin2', u'Mboat2', u'Enpp6', u'Cyp4v3', u'Acsf2', u'Gm2a', u'Lcat', u'Fa2h', u'Plcl1', u'Npc1', u'Npc2', u'Plcd4', u'Elovl5', u'Pnpla7', u'Lpcat3', u'Elovl1', u'Abhd3', u'Crot', u'Mid1ip1', u'Abhd5']), geneids='ENSMUSG00000026922 ENSMUSG00000019359 ENSMUSG00000028223 ENSMUSG00000060675 ENSMUSG00000021242 ENSMUSG00000000594 ENSMUSG00000031483 ENSMUSG00000038349 ENSMUSG00000020538 ENSMUSG00000005615 ENSMUSG00000035237 ENSMUSG00000020828 ENSMUSG00000036833 ENSMUSG00000037686 ENSMUSG00000026701 ENSMUSG00000030711 ENSMUSG00000059447 ENSMUSG00000024978 ENSMUSG00000037697 ENSMUSG00000035686 ENSMUSG00000032883 ENSMUSG00000031903 ENSMUSG00000032540 ENSMUSG00000004207 ENSMUSG00000026457 ENSMUSG00000079057 ENSMUSG00000026003 ENSMUSG00000025203 ENSMUSG00000029413 ENSMUSG00000027984 ENSMUSG00000022175 ENSMUSG00000002985 ENSMUSG00000063856 ENSMUSG00000020777 ENSMUSG00000032281 ENSMUSG00000003623 ENSMUSG00000035376 ENSMUSG00000024665 ENSMUSG00000029925 ENSMUSG00000026173 ENSMUSG00000076435 ENSMUSG00000015714 ENSMUSG00000024164 ENSMUSG00000038633 ENSMUSG00000030168 ENSMUSG00000027695 ENSMUSG00000060002 ENSMUSG00000038173 ENSMUSG00000023913 ENSMUSG00000031591 ENSMUSG00000021884 ENSMUSG00000040997 ENSMUSG00000028497 ENSMUSG00000031918 ENSMUSG00000029919 ENSMUSG00000024781 ENSMUSG00000024960 ENSMUSG00000024900 ENSMUSG00000039206 ENSMUSG00000018574 ENSMUSG00000033174 ENSMUSG00000043733 ENSMUSG00000006390 ENSMUSG00000032349 ENSMUSG00000042010 ENSMUSG00000026600 ENSMUSG00000044788 ENSMUSG00000002475 ENSMUSG00000004270 ENSMUSG00000022548 ENSMUSG00000020097 ENSMUSG00000017754 ENSMUSG00000020646 ENSMUSG00000024998 ENSMUSG00000020333 ENSMUSG00000024413 ENSMUSG00000033579 ENSMUSG00000008035', format_txt=1, hdr_idx=1, is_hdrgo=True, is_usrgo=True, hdr1usr01='**', dcnt=661, D1='CD', GO_name='lipid metabolic process'),
    Nt(p_uncorrected=0.0006749090679732751, study_count=9, study_n=1397, namespace='biological_process', p_fdr_bh=0.04869308232791949, study_items=set([u'ENSMUSG00000022488', u'ENSMUSG00000024610', u'ENSMUSG00000057329', u'ENSMUSG00000029084', u'ENSMUSG00000051212', u'ENSMUSG00000037706', u'ENSMUSG00000076617', u'ENSMUSG00000039005', u'ENSMUSG00000026395']), NS='BP', pop_items=set([u'ENSMUSG00000033721', u'ENSMUSG00000026739', u'ENSMUSG00000031101', u'ENSMUSG00000027950', u'ENSMUSG00000027544', u'ENSMUSG00000022508', u'ENSMUSG00000038894', u'ENSMUSG00000047123', u'ENSMUSG00000020134', u'ENSMUSG00000076617', u'ENSMUSG00000005583', u'ENSMUSG00000039005', u'ENSMUSG00000020167', u'ENSMUSG00000029084', u'ENSMUSG00000022797', u'ENSMUSG00000017550', u'ENSMUSG00000022488', u'ENSMUSG00000025986', u'ENSMUSG00000033307', u'ENSMUSG00000024610', u'ENSMUSG00000057329', u'ENSMUSG00000023067', u'ENSMUSG00000051212', u'ENSMUSG00000037706', u'ENSMUSG00000026395', u'ENSMUSG00000032041']), pop_n=13836, p_sm_bonferroni=1.0, is_obsolete=False, GO='GO:0030890', name='positive regulation of B cell proliferation', pop_count=26, alt_ids=[], level=8, depth=9, enrichment='e', Cluster='Late Increase', geneid_set=set([u'ENSMUSG00000022488', u'ENSMUSG00000024610', u'ENSMUSG00000057329', u'ENSMUSG00000029084', u'ENSMUSG00000051212', u'ENSMUSG00000076617', u'ENSMUSG00000037706', u'ENSMUSG00000026395', u'ENSMUSG00000039005']), symbols=u'Bcl2 Cd38 Cd74 Cd81 Gpr183 Ighm Nckap1l Ptprc Tlr4', symbol_set=set([u'Cd74', u'Cd38', u'Nckap1l', u'Cd81', u'Gpr183', u'Ptprc', u'Tlr4', u'Ighm', u'Bcl2']), geneids='ENSMUSG00000022488 ENSMUSG00000024610 ENSMUSG00000057329 ENSMUSG00000029084 ENSMUSG00000051212 ENSMUSG00000076617 ENSMUSG00000037706 ENSMUSG00000026395 ENSMUSG00000039005', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=0, D1='A', GO_name='positive regulation of B cell proliferation'),
    Nt(p_uncorrected='', study_count='', study_n='', namespace='', p_fdr_bh='', study_items='', NS='BP', pop_items='', pop_n='', p_sm_bonferroni='', is_obsolete='', GO='GO:0050793', name='', pop_count='', alt_ids='', level=3, depth=3, enrichment='', Cluster='', geneid_set='', symbols='', symbol_set='', geneids='', format_txt=1, hdr_idx=1, is_hdrgo=True, is_usrgo=False, hdr1usr01='*', dcnt=1939, D1='A', GO_name='regulation of developmental process'),
    Nt(p_uncorrected='', study_count='', study_n='', namespace='', p_fdr_bh='', study_items='', NS='BP', pop_items='', pop_n='', p_sm_bonferroni='', is_obsolete='', GO='GO:0050790', name='', pop_count='', alt_ids='', level=3, depth=3, enrichment='', Cluster='', geneid_set='', symbols='', symbol_set='', geneids='', format_txt=1, hdr_idx=1, is_hdrgo=True, is_usrgo=False, hdr1usr01='*', dcnt=639, D1='A', GO_name='regulation of catalytic activity'),
    Nt(p_uncorrected=2.684625703111141e-06, study_count=12, study_n=1397, namespace='biological_process', p_fdr_bh=0.0007135923513655597, study_items=set([u'ENSMUSG00000046160', u'ENSMUSG00000017344', u'ENSMUSG00000000567', u'ENSMUSG00000041309', u'ENSMUSG00000036098', u'ENSMUSG00000051910', u'ENSMUSG00000027858', u'ENSMUSG00000006782', u'ENSMUSG00000062312', u'ENSMUSG00000033006', u'ENSMUSG00000021318', u'ENSMUSG00000055254']), NS='BP', pop_items=set([u'ENSMUSG00000020052', u'ENSMUSG00000031302', u'ENSMUSG00000046160', u'ENSMUSG00000021318', u'ENSMUSG00000079055', u'ENSMUSG00000027748', u'ENSMUSG00000041540', u'ENSMUSG00000006782', u'ENSMUSG00000051910', u'ENSMUSG00000024176', u'ENSMUSG00000021848', u'ENSMUSG00000029763', u'ENSMUSG00000039384', u'ENSMUSG00000033006', u'ENSMUSG00000039830', u'ENSMUSG00000055254', u'ENSMUSG00000068748', u'ENSMUSG00000025314', u'ENSMUSG00000017344', u'ENSMUSG00000000567', u'ENSMUSG00000041309', u'ENSMUSG00000036098', u'ENSMUSG00000062991', u'ENSMUSG00000027858', u'ENSMUSG00000062312', u'ENSMUSG00000028969']), pop_n=13836, p_sm_bonferroni=0.0406747640278369, is_obsolete=False, GO='GO:0048709', name='oligodendrocyte differentiation', pop_count=26, alt_ids=[], level=6, depth=6, enrichment='e', Cluster='Late Increase', geneid_set=set([u'ENSMUSG00000021318', u'ENSMUSG00000017344', u'ENSMUSG00000000567', u'ENSMUSG00000041309', u'ENSMUSG00000036098', u'ENSMUSG00000033006', u'ENSMUSG00000027858', u'ENSMUSG00000055254', u'ENSMUSG00000062312', u'ENSMUSG00000051910', u'ENSMUSG00000046160', u'ENSMUSG00000006782']), symbols=u'Cnp Erbb2 Gli3 Myrf Nkx6-2 Ntrk2 Olig1 Sox10 Sox6 Sox9 Tspan2 Vtn', symbol_set=set([u'Erbb2', u'Cnp', u'Sox10', u'Sox6', u'Ntrk2', u'Vtn', u'Tspan2', u'Gli3', u'Sox9', 'Myrf', 'Nkx6-2', u'Olig1']), geneids='ENSMUSG00000046160 ENSMUSG00000017344 ENSMUSG00000000567 ENSMUSG00000041309 ENSMUSG00000036098 ENSMUSG00000051910 ENSMUSG00000027858 ENSMUSG00000055254 ENSMUSG00000062312 ENSMUSG00000033006 ENSMUSG00000021318 ENSMUSG00000006782', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=2, D1='BCE', GO_name='oligodendrocyte differentiation'),
    Nt(p_uncorrected=5.585418836361845e-06, study_count=17, study_n=1397, namespace='biological_process', p_fdr_bh=0.00120892401128169, study_items=set([u'ENSMUSG00000027878', u'ENSMUSG00000024529', u'ENSMUSG00000020717', u'ENSMUSG00000035273', u'ENSMUSG00000021754', u'ENSMUSG00000037411', u'ENSMUSG00000028919', u'ENSMUSG00000016028', u'ENSMUSG00000062312', u'ENSMUSG00000026177', u'ENSMUSG00000026193', u'ENSMUSG00000026043', u'ENSMUSG00000021822', u'ENSMUSG00000020122', u'ENSMUSG00000001506', u'ENSMUSG00000007655', u'ENSMUSG00000017009']), NS='BP', pop_items=set([u'ENSMUSG00000028919', u'ENSMUSG00000035273', u'ENSMUSG00000021732', u'ENSMUSG00000040242', u'ENSMUSG00000026193', u'ENSMUSG00000022383', u'ENSMUSG00000021754', u'ENSMUSG00000028649', u'ENSMUSG00000024835', u'ENSMUSG00000022568', u'ENSMUSG00000004665', u'ENSMUSG00000028413', u'ENSMUSG00000037188', u'ENSMUSG00000021994', u'ENSMUSG00000002250', u'ENSMUSG00000026556', u'ENSMUSG00000020716', u'ENSMUSG00000026177', u'ENSMUSG00000002603', u'ENSMUSG00000020717', u'ENSMUSG00000056724', u'ENSMUSG00000045730', u'ENSMUSG00000026043', u'ENSMUSG00000039358', u'ENSMUSG00000021822', u'ENSMUSG00000001506', u'ENSMUSG00000020592', u'ENSMUSG00000016028', u'ENSMUSG00000026814', u'ENSMUSG00000029231', u'ENSMUSG00000039239', u'ENSMUSG00000023972', u'ENSMUSG00000033373', u'ENSMUSG00000035107', u'ENSMUSG00000004655', u'ENSMUSG00000027878', u'ENSMUSG00000024529', u'ENSMUSG00000007655', u'ENSMUSG00000030774', u'ENSMUSG00000037411', u'ENSMUSG00000035283', u'ENSMUSG00000032366', u'ENSMUSG00000052712', u'ENSMUSG00000062312', u'ENSMUSG00000048616', u'ENSMUSG00000027474', u'ENSMUSG00000020122', u'ENSMUSG00000008398', u'ENSMUSG00000017009', u'ENSMUSG00000031778', u'ENSMUSG00000028434']), pop_n=13836, p_sm_bonferroni=0.08462468078971831, is_obsolete=False, GO='GO:0042060', name='wound healing', pop_count=51, alt_ids=[], level=4, depth=4, enrichment='e', Cluster='Late Increase', geneid_set=set([u'ENSMUSG00000028919', u'ENSMUSG00000017009', u'ENSMUSG00000035273', u'ENSMUSG00000020717', u'ENSMUSG00000026193', u'ENSMUSG00000027878', u'ENSMUSG00000024529', u'ENSMUSG00000037411', u'ENSMUSG00000021754', u'ENSMUSG00000062312', u'ENSMUSG00000026177', u'ENSMUSG00000026043', u'ENSMUSG00000021822', u'ENSMUSG00000020122', u'ENSMUSG00000001506', u'ENSMUSG00000007655', u'ENSMUSG00000016028']), symbols=u'Arhgef19 Cav1 Celsr1 Col1a1 Col3a1 Egfr Erbb2 Fn1 Hpse Lox Map3k1 Notch2 Pecam1 Plau Sdc4 Serpine1 Slc11a1', symbol_set=set([u'Hpse', u'Pecam1', u'Celsr1', u'Fn1', u'Slc11a1', u'Arhgef19', u'Map3k1', u'Sdc4', u'Notch2', u'Egfr', u'Erbb2', u'Plau', u'Col1a1', u'Col3a1', u'Lox', u'Serpine1', u'Cav1']), geneids='ENSMUSG00000027878 ENSMUSG00000062312 ENSMUSG00000024529 ENSMUSG00000028919 ENSMUSG00000035273 ENSMUSG00000020717 ENSMUSG00000037411 ENSMUSG00000021754 ENSMUSG00000016028 ENSMUSG00000026193 ENSMUSG00000026177 ENSMUSG00000026043 ENSMUSG00000021822 ENSMUSG00000020122 ENSMUSG00000001506 ENSMUSG00000007655 ENSMUSG00000017009', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=1, D1='F', GO_name='wound healing'),
    Nt(p_uncorrected=4.40948885610569e-07, study_count=25, study_n=1397, namespace='biological_process', p_fdr_bh=0.00015536782711362166, study_items=set([u'ENSMUSG00000030339', u'ENSMUSG00000031714', u'ENSMUSG00000031565', u'ENSMUSG00000039904', u'ENSMUSG00000021948', u'ENSMUSG00000004207', u'ENSMUSG00000030849', u'ENSMUSG00000017466', u'ENSMUSG00000029648', u'ENSMUSG00000048376', u'ENSMUSG00000021846', u'ENSMUSG00000076617', u'ENSMUSG00000020591', u'ENSMUSG00000020053', u'ENSMUSG00000025809', u'ENSMUSG00000020357', u'ENSMUSG00000022091', u'ENSMUSG00000055254', u'ENSMUSG00000038147', u'ENSMUSG00000062312', u'ENSMUSG00000026424', u'ENSMUSG00000074637', u'ENSMUSG00000026395', u'ENSMUSG00000000058', u'ENSMUSG00000028599']), NS='BP', pop_items=set([u'ENSMUSG00000048583', u'ENSMUSG00000030339', u'ENSMUSG00000038119', u'ENSMUSG00000021732', u'ENSMUSG00000061578', u'ENSMUSG00000018849', u'ENSMUSG00000022091', u'ENSMUSG00000019579', u'ENSMUSG00000026883', u'ENSMUSG00000024793', u'ENSMUSG00000005534', u'ENSMUSG00000031714', u'ENSMUSG00000030842', u'ENSMUSG00000006699', u'ENSMUSG00000028661', u'ENSMUSG00000005533', u'ENSMUSG00000039904', u'ENSMUSG00000027001', u'ENSMUSG00000021948', u'ENSMUSG00000004207', u'ENSMUSG00000030849', u'ENSMUSG00000032547', u'ENSMUSG00000017466', u'ENSMUSG00000026395', u'ENSMUSG00000005672', u'ENSMUSG00000055254', u'ENSMUSG00000053647', u'ENSMUSG00000025809', u'ENSMUSG00000029648', u'ENSMUSG00000006932', u'ENSMUSG00000045730', u'ENSMUSG00000048376', u'ENSMUSG00000046532', u'ENSMUSG00000020657', u'ENSMUSG00000052752', u'ENSMUSG00000038668', u'ENSMUSG00000050541', u'ENSMUSG00000027358', u'ENSMUSG00000027087', u'ENSMUSG00000021846', u'ENSMUSG00000020053', u'ENSMUSG00000034394', u'ENSMUSG00000008318', u'ENSMUSG00000027947', u'ENSMUSG00000033862', u'ENSMUSG00000029468', u'ENSMUSG00000037499', u'ENSMUSG00000021408', u'ENSMUSG00000032807', u'ENSMUSG00000020427', u'ENSMUSG00000000489', u'ENSMUSG00000020859', u'ENSMUSG00000037014', u'ENSMUSG00000045038', u'ENSMUSG00000025856', u'ENSMUSG00000076617', u'ENSMUSG00000017446', u'ENSMUSG00000011958', u'ENSMUSG00000020357', u'ENSMUSG00000057455', u'ENSMUSG00000062960', u'ENSMUSG00000031565', u'ENSMUSG00000057722', u'ENSMUSG00000018334', u'ENSMUSG00000038147', u'ENSMUSG00000020689', u'ENSMUSG00000052253', u'ENSMUSG00000049489', u'ENSMUSG00000025499', u'ENSMUSG00000026321', u'ENSMUSG00000054252', u'ENSMUSG00000031980', u'ENSMUSG00000000058', u'ENSMUSG00000062312', u'ENSMUSG00000024304', u'ENSMUSG00000026424', u'ENSMUSG00000045875', u'ENSMUSG00000021974', u'ENSMUSG00000074637', u'ENSMUSG00000030890', u'ENSMUSG00000020591', u'ENSMUSG00000017493', u'ENSMUSG00000024778', u'ENSMUSG00000028599']), pop_n=13836, p_sm_bonferroni=0.006680816565885731, is_obsolete=False, GO='GO:0043410', name='positive regulation of MAPK cascade', pop_count=84, alt_ids=[], level=7, depth=10, enrichment='e', Cluster='Late Increase', geneid_set=set([u'ENSMUSG00000020053', u'ENSMUSG00000030339', u'ENSMUSG00000025809', u'ENSMUSG00000020357', u'ENSMUSG00000074637', u'ENSMUSG00000026395', u'ENSMUSG00000031714', u'ENSMUSG00000031565', u'ENSMUSG00000055254', u'ENSMUSG00000039904', u'ENSMUSG00000021948', u'ENSMUSG00000004207', u'ENSMUSG00000030849', u'ENSMUSG00000017466', u'ENSMUSG00000028599', u'ENSMUSG00000022091', u'ENSMUSG00000029648', u'ENSMUSG00000062312', u'ENSMUSG00000048376', u'ENSMUSG00000026424', u'ENSMUSG00000021846', u'ENSMUSG00000076617', u'ENSMUSG00000038147', u'ENSMUSG00000000058', u'ENSMUSG00000020591']), symbols=u'Cav2 Cd84 Erbb2 F2r Fgfr1 Fgfr2 Flt1 Flt4 Gab1 Gpr37 Gpr37l1 Igf1 Ighm Itgb1 Ltbr Ntrk2 Ntsr2 Peli2 Prkcd Psap Ptprc Sorbs3 Sox2 Timp2 Tnfrsf1b', symbol_set=set([u'Ltbr', u'Igf1', u'Peli2', u'Psap', u'Gab1', u'Sorbs3', u'Itgb1', u'Tnfrsf1b', u'Ntsr2', u'Fgfr2', u'Ighm', u'Fgfr1', u'Gpr37l1', u'Prkcd', u'Ntrk2', u'Cd84', u'F2r', u'Sox2', u'Flt4', u'Cav2', u'Gpr37', u'Flt1', u'Erbb2', u'Timp2', u'Ptprc']), geneids='ENSMUSG00000030339 ENSMUSG00000031714 ENSMUSG00000031565 ENSMUSG00000039904 ENSMUSG00000021948 ENSMUSG00000004207 ENSMUSG00000030849 ENSMUSG00000017466 ENSMUSG00000029648 ENSMUSG00000048376 ENSMUSG00000021846 ENSMUSG00000076617 ENSMUSG00000026395 ENSMUSG00000020053 ENSMUSG00000025809 ENSMUSG00000020357 ENSMUSG00000074637 ENSMUSG00000022091 ENSMUSG00000055254 ENSMUSG00000062312 ENSMUSG00000026424 ENSMUSG00000020591 ENSMUSG00000038147 ENSMUSG00000000058 ENSMUSG00000028599', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=30, D1='A', GO_name='positive regulation of MAPK cascade'),
    Nt(p_uncorrected='', study_count='', study_n='', namespace='', p_fdr_bh='', study_items='', NS='BP', pop_items='', pop_n='', p_sm_bonferroni='', is_obsolete='', GO='GO:0006950', name='', pop_count='', alt_ids='', level=2, depth=2, enrichment='', Cluster='', geneid_set='', symbols='', symbol_set='', geneids='', format_txt=1, hdr_idx=1, is_hdrgo=True, is_usrgo=False, hdr1usr01='*', dcnt=491, D1='F', GO_name='response to stress'),
    Nt(p_uncorrected=2.453835471009441e-05, study_count=6, study_n=1397, namespace='biological_process', p_fdr_bh=0.003793679716455514, study_items=set([u'ENSMUSG00000024371', u'ENSMUSG00000024164', u'ENSMUSG00000038521', u'ENSMUSG00000073418', u'ENSMUSG00000022018', u'ENSMUSG00000015451']), NS='BP', pop_items=set([u'ENSMUSG00000024371', u'ENSMUSG00000024164', u'ENSMUSG00000038521', u'ENSMUSG00000073418', u'ENSMUSG00000022887', u'ENSMUSG00000055172', u'ENSMUSG00000022018', u'ENSMUSG00000015451']), pop_n=13836, p_sm_bonferroni=0.3717806122126404, is_obsolete=False, GO='GO:0006956', name='complement activation', pop_count=8, alt_ids=[], level=3, depth=7, enrichment='e', Cluster='Late Increase', geneid_set=set([u'ENSMUSG00000024371', u'ENSMUSG00000024164', u'ENSMUSG00000038521', u'ENSMUSG00000022018', u'ENSMUSG00000015451', u'ENSMUSG00000073418']), symbols=u'C1s1 C2 C3 C4a C4b Rgcc', symbol_set=set(['C1s1', u'C4a', u'C4b', 'Rgcc', u'C3', u'C2']), geneids='ENSMUSG00000024371 ENSMUSG00000024164 ENSMUSG00000073418 ENSMUSG00000038521 ENSMUSG00000022018 ENSMUSG00000015451', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=4, D1='ADFL', GO_name='complement activation'),
    Nt(p_uncorrected=1.2889089627495307e-06, study_count=38, study_n=1397, namespace='biological_process', p_fdr_bh=0.00037554345566573344, study_items=set([u'ENSMUSG00000030339', u'ENSMUSG00000052384', u'ENSMUSG00000020573', u'ENSMUSG00000015839', u'ENSMUSG00000019122', u'ENSMUSG00000056529', u'ENSMUSG00000010051', u'ENSMUSG00000008845', u'ENSMUSG00000054509', u'ENSMUSG00000002602', u'ENSMUSG00000033350', u'ENSMUSG00000023031', u'ENSMUSG00000048376', u'ENSMUSG00000018927', u'ENSMUSG00000040552', u'ENSMUSG00000039004', u'ENSMUSG00000039005', u'ENSMUSG00000024164', u'ENSMUSG00000033777', u'ENSMUSG00000015340', u'ENSMUSG00000023913', u'ENSMUSG00000044583', u'ENSMUSG00000031425', u'ENSMUSG00000024781', u'ENSMUSG00000022575', u'ENSMUSG00000029371', u'ENSMUSG00000064246', u'ENSMUSG00000078942', u'ENSMUSG00000052430', u'ENSMUSG00000078945', u'ENSMUSG00000040152', u'ENSMUSG00000051439', u'ENSMUSG00000044827', u'ENSMUSG00000020399', u'ENSMUSG00000027858', u'ENSMUSG00000026177', u'ENSMUSG00000060477', u'ENSMUSG00000028599']), NS='BP', pop_items=set([u'ENSMUSG00000029199', u'ENSMUSG00000045322', u'ENSMUSG00000028029', u'ENSMUSG00000039145', u'ENSMUSG00000028108', u'ENSMUSG00000016528', u'ENSMUSG00000026883', u'ENSMUSG00000031778', u'ENSMUSG00000029053', u'ENSMUSG00000022475', u'ENSMUSG00000008845', u'ENSMUSG00000040552', u'ENSMUSG00000029371', u'ENSMUSG00000023078', u'ENSMUSG00000075316', u'ENSMUSG00000004698', u'ENSMUSG00000026778', u'ENSMUSG00000020592', u'ENSMUSG00000060477', u'ENSMUSG00000008855', u'ENSMUSG00000024164', u'ENSMUSG00000020275', u'ENSMUSG00000038128', u'ENSMUSG00000015340', u'ENSMUSG00000039936', u'ENSMUSG00000027399', u'ENSMUSG00000042228', u'ENSMUSG00000006445', u'ENSMUSG00000025199', u'ENSMUSG00000000982', u'ENSMUSG00000052821', u'ENSMUSG00000040152', u'ENSMUSG00000014599', u'ENSMUSG00000061762', u'ENSMUSG00000007836', u'ENSMUSG00000066551', u'ENSMUSG00000025512', u'ENSMUSG00000054008', u'ENSMUSG00000024778', u'ENSMUSG00000019850', u'ENSMUSG00000021180', u'ENSMUSG00000032487', u'ENSMUSG00000021680', u'ENSMUSG00000031425', u'ENSMUSG00000025139', u'ENSMUSG00000015839', u'ENSMUSG00000062585', u'ENSMUSG00000056529', u'ENSMUSG00000005672', u'ENSMUSG00000006519', u'ENSMUSG00000028885', u'ENSMUSG00000054509', u'ENSMUSG00000027312', u'ENSMUSG00000047123', u'ENSMUSG00000035352', u'ENSMUSG00000037860', u'ENSMUSG00000035356', u'ENSMUSG00000027087', u'ENSMUSG00000039217', u'ENSMUSG00000033777', u'ENSMUSG00000020400', u'ENSMUSG00000064246', u'ENSMUSG00000027221', u'ENSMUSG00000009281', u'ENSMUSG00000044583', u'ENSMUSG00000023915', u'ENSMUSG00000034855', u'ENSMUSG00000002688', u'ENSMUSG00000061878', u'ENSMUSG00000023913', u'ENSMUSG00000078942', u'ENSMUSG00000032508', u'ENSMUSG00000033307', u'ENSMUSG00000053004', u'ENSMUSG00000003283', u'ENSMUSG00000018476', u'ENSMUSG00000037872', u'ENSMUSG00000079227', u'ENSMUSG00000052384', u'ENSMUSG00000029417', u'ENSMUSG00000042286', u'ENSMUSG00000030793', u'ENSMUSG00000028577', u'ENSMUSG00000019122', u'ENSMUSG00000031639', u'ENSMUSG00000033467', u'ENSMUSG00000029026', u'ENSMUSG00000047557', u'ENSMUSG00000002602', u'ENSMUSG00000002603', u'ENSMUSG00000053647', u'ENSMUSG00000024621', u'ENSMUSG00000047250', u'ENSMUSG00000023031', u'ENSMUSG00000018927', u'ENSMUSG00000025225', u'ENSMUSG00000071203', u'ENSMUSG00000001729', u'ENSMUSG00000041135', u'ENSMUSG00000021624', u'ENSMUSG00000008318', u'ENSMUSG00000006344', u'ENSMUSG00000055633', u'ENSMUSG00000022074', u'ENSMUSG00000067586', u'ENSMUSG00000022514', u'ENSMUSG00000033350', u'ENSMUSG00000078945', u'ENSMUSG00000031536', u'ENSMUSG00000059866', u'ENSMUSG00000051439', u'ENSMUSG00000022040', u'ENSMUSG00000026117', u'ENSMUSG00000070390', u'ENSMUSG00000032691', u'ENSMUSG00000028964', u'ENSMUSG00000015950', u'ENSMUSG00000018932', u'ENSMUSG00000018930', u'ENSMUSG00000032911', u'ENSMUSG00000030339', u'ENSMUSG00000027684', u'ENSMUSG00000020573', u'ENSMUSG00000024952', u'ENSMUSG00000031750', u'ENSMUSG00000022508', u'ENSMUSG00000024793', u'ENSMUSG00000063415', u'ENSMUSG00000024927', u'ENSMUSG00000010051', u'ENSMUSG00000010054', u'ENSMUSG00000043496', u'ENSMUSG00000031681', u'ENSMUSG00000025083', u'ENSMUSG00000048376', u'ENSMUSG00000040451', u'ENSMUSG00000002983', u'ENSMUSG00000027358', u'ENSMUSG00000039004', u'ENSMUSG00000039005', u'ENSMUSG00000038264', u'ENSMUSG00000054717', u'ENSMUSG00000029468', u'ENSMUSG00000031537', u'ENSMUSG00000030341', u'ENSMUSG00000024789', u'ENSMUSG00000033538', u'ENSMUSG00000016495', u'ENSMUSG00000037731', u'ENSMUSG00000024781', u'ENSMUSG00000022575', u'ENSMUSG00000033885', u'ENSMUSG00000052430', u'ENSMUSG00000035385', u'ENSMUSG00000025473', u'ENSMUSG00000027995', u'ENSMUSG00000044827', u'ENSMUSG00000020399', u'ENSMUSG00000027858', u'ENSMUSG00000026177', u'ENSMUSG00000032322', u'ENSMUSG00000021936', u'ENSMUSG00000021423', u'ENSMUSG00000032041', u'ENSMUSG00000028599']), pop_n=13836, p_sm_bonferroni=0.01952825969461814, is_obsolete=False, GO='GO:0006954', name='inflammatory response', pop_count=165, alt_ids=[], level=4, depth=4, enrichment='e', Cluster='Late Increase', geneid_set=set([u'ENSMUSG00000030339', u'ENSMUSG00000020399', u'ENSMUSG00000052384', u'ENSMUSG00000020573', u'ENSMUSG00000015839', u'ENSMUSG00000019122', u'ENSMUSG00000056529', u'ENSMUSG00000010051', u'ENSMUSG00000008845', u'ENSMUSG00000054509', u'ENSMUSG00000002602', u'ENSMUSG00000029371', u'ENSMUSG00000023031', u'ENSMUSG00000048376', u'ENSMUSG00000018927', u'ENSMUSG00000040552', u'ENSMUSG00000039004', u'ENSMUSG00000039005', u'ENSMUSG00000024164', u'ENSMUSG00000033777', u'ENSMUSG00000015340', u'ENSMUSG00000023913', u'ENSMUSG00000044583', u'ENSMUSG00000024781', u'ENSMUSG00000022575', u'ENSMUSG00000033350', u'ENSMUSG00000064246', u'ENSMUSG00000078942', u'ENSMUSG00000052430', u'ENSMUSG00000078945', u'ENSMUSG00000040152', u'ENSMUSG00000051439', u'ENSMUSG00000044827', u'ENSMUSG00000031425', u'ENSMUSG00000027858', u'ENSMUSG00000026177', u'ENSMUSG00000060477', u'ENSMUSG00000028599']), symbols=u'Axl Bmp6 Bmpr1b C3 C3ar1 Ccl6 Ccl9 Cd14 Cd163 Cela1 Chil1 Chst2 Cxcl5 Cybb F2r Gsdmd Havcr2 Hyal1 Irak2 Lipa Ltbr Naip2 Naip6 Nfe2l2 Nrros Parp4 Pik3cg Pla2g7 Plp1 Ptafr Slc11a1 Thbs1 Tlr1 Tlr13 Tlr4 Tlr7 Tnfrsf1b Tspan2', symbol_set=set([u'Ltbr', u'Cxcl5', u'Cd163', u'Naip6', u'Naip2', u'Tspan2', u'Pla2g7', u'Cd14', u'Tlr13', u'Ptafr', u'Irak2', u'Tnfrsf1b', u'Pik3cg', u'C3', u'Havcr2', u'Cela1', u'Ccl6', u'Slc11a1', u'Nfe2l2', u'Hyal1', u'Ccl9', u'Thbs1', u'F2r', u'Bmpr1b', u'Plp1', u'Axl', u'Lipa', u'Bmp6', 'Chil1', u'Tlr7', u'Parp4', u'C3ar1', u'Gsdmd', u'Cybb', u'Tlr1', 'Nrros', u'Tlr4', u'Chst2']), geneids='ENSMUSG00000030339 ENSMUSG00000052384 ENSMUSG00000031425 ENSMUSG00000015839 ENSMUSG00000019122 ENSMUSG00000056529 ENSMUSG00000010051 ENSMUSG00000008845 ENSMUSG00000054509 ENSMUSG00000002602 ENSMUSG00000029371 ENSMUSG00000060477 ENSMUSG00000023031 ENSMUSG00000048376 ENSMUSG00000018927 ENSMUSG00000040552 ENSMUSG00000022575 ENSMUSG00000039005 ENSMUSG00000024164 ENSMUSG00000033777 ENSMUSG00000015340 ENSMUSG00000023913 ENSMUSG00000044583 ENSMUSG00000024781 ENSMUSG00000020573 ENSMUSG00000033350 ENSMUSG00000064246 ENSMUSG00000078942 ENSMUSG00000052430 ENSMUSG00000078945 ENSMUSG00000040152 ENSMUSG00000051439 ENSMUSG00000044827 ENSMUSG00000020399 ENSMUSG00000027858 ENSMUSG00000026177 ENSMUSG00000039004 ENSMUSG00000028599', format_txt=1, hdr_idx=1, is_hdrgo=True, is_usrgo=True, hdr1usr01='**', dcnt=25, D1='F', GO_name='inflammatory response'),
    Nt(p_uncorrected=4.164206981138891e-06, study_count=24, study_n=1397, namespace='biological_process', p_fdr_bh=0.0009858109370505521, study_items=set([u'ENSMUSG00000030339', u'ENSMUSG00000031165', u'ENSMUSG00000026656', u'ENSMUSG00000052384', u'ENSMUSG00000028362', u'ENSMUSG00000019122', u'ENSMUSG00000021796', u'ENSMUSG00000018927', u'ENSMUSG00000036103', u'ENSMUSG00000038642', u'ENSMUSG00000056216', u'ENSMUSG00000021846', u'ENSMUSG00000044583', u'ENSMUSG00000060586', u'ENSMUSG00000029371', u'ENSMUSG00000037370', u'ENSMUSG00000032369', u'ENSMUSG00000017344', u'ENSMUSG00000022468', u'ENSMUSG00000024610', u'ENSMUSG00000044827', u'ENSMUSG00000021508', u'ENSMUSG00000039004', u'ENSMUSG00000028599']), NS='BP', pop_items=set([u'ENSMUSG00000045322', u'ENSMUSG00000026656', u'ENSMUSG00000032661', u'ENSMUSG00000059327', u'ENSMUSG00000060586', u'ENSMUSG00000031778', u'ENSMUSG00000002015', u'ENSMUSG00000061353', u'ENSMUSG00000029371', u'ENSMUSG00000023078', u'ENSMUSG00000021796', u'ENSMUSG00000022074', u'ENSMUSG00000036103', u'ENSMUSG00000079362', u'ENSMUSG00000006014', u'ENSMUSG00000027399', u'ENSMUSG00000029605', u'ENSMUSG00000000982', u'ENSMUSG00000037649', u'ENSMUSG00000045827', u'ENSMUSG00000032251', u'ENSMUSG00000029287', u'ENSMUSG00000020941', u'ENSMUSG00000024778', u'ENSMUSG00000031165', u'ENSMUSG00000022425', u'ENSMUSG00000061132', u'ENSMUSG00000032402', u'ENSMUSG00000036867', u'ENSMUSG00000035352', u'ENSMUSG00000061232', u'ENSMUSG00000034116', u'ENSMUSG00000039217', u'ENSMUSG00000044583', u'ENSMUSG00000034855', u'ENSMUSG00000022637', u'ENSMUSG00000031706', u'ENSMUSG00000037370', u'ENSMUSG00000032369', u'ENSMUSG00000001016', u'ENSMUSG00000017344', u'ENSMUSG00000024610', u'ENSMUSG00000026321', u'ENSMUSG00000034987', u'ENSMUSG00000021508', u'ENSMUSG00000022148', u'ENSMUSG00000079227', u'ENSMUSG00000052384', u'ENSMUSG00000029417', u'ENSMUSG00000056216', u'ENSMUSG00000019122', u'ENSMUSG00000002699', u'ENSMUSG00000073421', u'ENSMUSG00000032508', u'ENSMUSG00000018927', u'ENSMUSG00000079547', u'ENSMUSG00000008318', u'ENSMUSG00000029561', u'ENSMUSG00000056749', u'ENSMUSG00000036469', u'ENSMUSG00000033510', u'ENSMUSG00000028776', u'ENSMUSG00000060802', u'ENSMUSG00000026117', u'ENSMUSG00000032690', u'ENSMUSG00000022468', u'ENSMUSG00000039304', u'ENSMUSG00000018930', u'ENSMUSG00000030339', u'ENSMUSG00000006342', u'ENSMUSG00000028362', u'ENSMUSG00000024793', u'ENSMUSG00000005533', u'ENSMUSG00000041827', u'ENSMUSG00000021846', u'ENSMUSG00000038642', u'ENSMUSG00000039004', u'ENSMUSG00000034394', u'ENSMUSG00000030341', u'ENSMUSG00000016496', u'ENSMUSG00000073411', u'ENSMUSG00000035385', u'ENSMUSG00000027995', u'ENSMUSG00000044827', u'ENSMUSG00000036594', u'ENSMUSG00000027164', u'ENSMUSG00000041515', u'ENSMUSG00000028599']), pop_n=13836, p_sm_bonferroni=0.06309189997123534, is_obsolete=False, GO='GO:0006955', name='immune response', pop_count=88, alt_ids=[], level=2, depth=2, enrichment='e', Cluster='Late Increase', geneid_set=set([u'ENSMUSG00000030339', u'ENSMUSG00000031165', u'ENSMUSG00000026656', u'ENSMUSG00000052384', u'ENSMUSG00000028362', u'ENSMUSG00000044583', u'ENSMUSG00000019122', u'ENSMUSG00000060586', u'ENSMUSG00000029371', u'ENSMUSG00000037370', u'ENSMUSG00000032369', u'ENSMUSG00000017344', u'ENSMUSG00000039004', u'ENSMUSG00000022468', u'ENSMUSG00000024610', u'ENSMUSG00000044827', u'ENSMUSG00000021796', u'ENSMUSG00000021508', u'ENSMUSG00000018927', u'ENSMUSG00000036103', u'ENSMUSG00000038642', u'ENSMUSG00000028599', u'ENSMUSG00000056216', u'ENSMUSG00000021846']), symbols=u'Bmp6 Bmpr1a Ccl6 Ccl9 Cd74 Cebpg Colec12 Ctss Cxcl14 Cxcl5 Endou Enpp1 Fcgr2b H2-Eb1 Ltbr Nrros Peli2 Plscr1 Tlr1 Tlr7 Tnfrsf1b Tnfsf8 Vtn Was', symbol_set=set([u'Ltbr', u'Cxcl5', u'Peli2', u'Fcgr2b', u'Vtn', u'Was', u'Cd74', u'Tnfrsf1b', u'Tnfsf8', 'H2-Eb1', u'Ctss', u'Tlr7', u'Ccl6', u'Ccl9', u'Bmpr1a', u'Endou', u'Bmp6', u'Cebpg', u'Plscr1', u'Enpp1', u'Tlr1', u'Colec12', 'Nrros', u'Cxcl14']), geneids='ENSMUSG00000030339 ENSMUSG00000031165 ENSMUSG00000026656 ENSMUSG00000052384 ENSMUSG00000028362 ENSMUSG00000019122 ENSMUSG00000021796 ENSMUSG00000018927 ENSMUSG00000036103 ENSMUSG00000038642 ENSMUSG00000039004 ENSMUSG00000021846 ENSMUSG00000056216 ENSMUSG00000044583 ENSMUSG00000060586 ENSMUSG00000029371 ENSMUSG00000037370 ENSMUSG00000032369 ENSMUSG00000017344 ENSMUSG00000022468 ENSMUSG00000024610 ENSMUSG00000044827 ENSMUSG00000021508 ENSMUSG00000028599', format_txt=1, hdr_idx=1, is_hdrgo=True, is_usrgo=True, hdr1usr01='**', dcnt=107, D1='FL', GO_name='immune response'),
    Nt(p_uncorrected=3.614732234018528e-06, study_count=8, study_n=1397, namespace='biological_process', p_fdr_bh=0.0009127801346269119, study_items=set([u'ENSMUSG00000026840', u'ENSMUSG00000026728', u'ENSMUSG00000031425', u'ENSMUSG00000020932', u'ENSMUSG00000027858', u'ENSMUSG00000052911', u'ENSMUSG00000031760', u'ENSMUSG00000039005']), NS='BP', pop_items=set([u'ENSMUSG00000035305', u'ENSMUSG00000026728', u'ENSMUSG00000003235', u'ENSMUSG00000031425', u'ENSMUSG00000021478', u'ENSMUSG00000026840', u'ENSMUSG00000020932', u'ENSMUSG00000027858', u'ENSMUSG00000014773', u'ENSMUSG00000031760', u'ENSMUSG00000052911', u'ENSMUSG00000039005']), pop_n=13836, p_sm_bonferroni=0.05476680807761472, is_obsolete=False, GO='GO:0014002', name='astrocyte development', pop_count=12, alt_ids=[], level=5, depth=6, enrichment='e', Cluster='Late Increase', geneid_set=set([u'ENSMUSG00000026728', u'ENSMUSG00000031425', u'ENSMUSG00000026840', u'ENSMUSG00000020932', u'ENSMUSG00000027858', u'ENSMUSG00000052911', u'ENSMUSG00000031760', u'ENSMUSG00000039005']), symbols=u'Gfap Lamb2 Lamc3 Mt3 Plp1 Tlr4 Tspan2 Vim', symbol_set=set([u'Mt3', u'Vim', u'Tspan2', u'Tlr4', u'Lamc3', u'Plp1', u'Lamb2', u'Gfap']), geneids='ENSMUSG00000026728 ENSMUSG00000031425 ENSMUSG00000027858 ENSMUSG00000026840 ENSMUSG00000020932 ENSMUSG00000052911 ENSMUSG00000031760 ENSMUSG00000039005', format_txt=1, hdr_idx=1, is_hdrgo=True, is_usrgo=True, hdr1usr01='**', dcnt=1, D1='BCE', GO_name='astrocyte development'),
    Nt(p_uncorrected=0.0005660627202574551, study_count=6, study_n=1397, namespace='biological_process', p_fdr_bh=0.042041256248140695, study_items=set([u'ENSMUSG00000024371', u'ENSMUSG00000024164', u'ENSMUSG00000038521', u'ENSMUSG00000023224', u'ENSMUSG00000036887', u'ENSMUSG00000076617']), NS='BP', pop_items=set([u'ENSMUSG00000024371', u'ENSMUSG00000024164', u'ENSMUSG00000038521', u'ENSMUSG00000016481', u'ENSMUSG00000023224', u'ENSMUSG00000026399', u'ENSMUSG00000055172', u'ENSMUSG00000036887', u'ENSMUSG00000076617', u'ENSMUSG00000036905', u'ENSMUSG00000018446', u'ENSMUSG00000036896']), pop_n=13836, p_sm_bonferroni=1.0, is_obsolete=False, GO='GO:0006958', name='complement activation, classical pathway', pop_count=12, alt_ids=[], level=4, depth=8, enrichment='e', Cluster='Late Increase', geneid_set=set([u'ENSMUSG00000023224', u'ENSMUSG00000024371', u'ENSMUSG00000024164', u'ENSMUSG00000036887', u'ENSMUSG00000076617', u'ENSMUSG00000038521']), symbols=u'C1qa C1s1 C2 C3 Ighm Serping1', symbol_set=set(['C1s1', u'C1qa', u'Serping1', u'C3', u'C2', u'Ighm']), geneids='ENSMUSG00000024371 ENSMUSG00000024164 ENSMUSG00000038521 ENSMUSG00000023224 ENSMUSG00000036887 ENSMUSG00000076617', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=0, D1='ADFL', GO_name='complement activation, classical pathway'),
    Nt(p_uncorrected=0.0003094455308920858, study_count=6, study_n=1397, namespace='biological_process', p_fdr_bh=0.028243429147867424, study_items=set([u'ENSMUSG00000027878', u'ENSMUSG00000026923', u'ENSMUSG00000039191', u'ENSMUSG00000034227', u'ENSMUSG00000051212', u'ENSMUSG00000023990']), NS='BP', pop_items=set([u'ENSMUSG00000027878', u'ENSMUSG00000026739', u'ENSMUSG00000015396', u'ENSMUSG00000005583', u'ENSMUSG00000039191', u'ENSMUSG00000034227', u'ENSMUSG00000026923', u'ENSMUSG00000000134', u'ENSMUSG00000051212', u'ENSMUSG00000023915', u'ENSMUSG00000023990']), pop_n=13836, p_sm_bonferroni=1.0, is_obsolete=False, GO='GO:0006959', name='humoral immune response', pop_count=11, alt_ids=[], level=3, depth=3, enrichment='e', Cluster='Late Increase', geneid_set=set([u'ENSMUSG00000027878', u'ENSMUSG00000026923', u'ENSMUSG00000051212', u'ENSMUSG00000039191', u'ENSMUSG00000034227', u'ENSMUSG00000023990']), symbols=u'Foxj1 Gpr183 Notch1 Notch2 Rbpj Tfeb', symbol_set=set([u'Foxj1', u'Tfeb', u'Rbpj', u'Gpr183', u'Notch1', u'Notch2']), geneids='ENSMUSG00000027878 ENSMUSG00000026923 ENSMUSG00000039191 ENSMUSG00000034227 ENSMUSG00000051212 ENSMUSG00000023990', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=12, D1='FL', GO_name='humoral immune response'),
    Nt(p_uncorrected=5.282834151899904e-05, study_count=7, study_n=1397, namespace='biological_process', p_fdr_bh=0.007276383657766858, study_items=set([u'ENSMUSG00000073889', u'ENSMUSG00000020919', u'ENSMUSG00000002602', u'ENSMUSG00000004043', u'ENSMUSG00000018654', u'ENSMUSG00000020644', u'ENSMUSG00000014361']), NS='BP', pop_items=set([u'ENSMUSG00000020167', u'ENSMUSG00000073889', u'ENSMUSG00000020919', u'ENSMUSG00000010054', u'ENSMUSG00000002602', u'ENSMUSG00000004043', u'ENSMUSG00000018654', u'ENSMUSG00000035247', u'ENSMUSG00000027109', u'ENSMUSG00000020644', u'ENSMUSG00000014361', u'ENSMUSG00000027298']), pop_n=13836, p_sm_bonferroni=0.8004022023543544, is_obsolete=False, GO='GO:0001779', name='natural killer cell differentiation', pop_count=12, alt_ids=[], level=5, depth=7, enrichment='e', Cluster='Late Increase', geneid_set=set([u'ENSMUSG00000073889', u'ENSMUSG00000020919', u'ENSMUSG00000020644', u'ENSMUSG00000014361', u'ENSMUSG00000002602', u'ENSMUSG00000004043', u'ENSMUSG00000018654']), symbols=u'Axl Id2 Ikzf1 Il11ra1 Mertk Stat5a Stat5b', symbol_set=set([u'Il11ra1', u'Id2', u'Stat5b', u'Stat5a', u'Mertk', u'Ikzf1', u'Axl']), geneids='ENSMUSG00000073889 ENSMUSG00000020919 ENSMUSG00000002602 ENSMUSG00000004043 ENSMUSG00000018654 ENSMUSG00000020644 ENSMUSG00000014361', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=1, D1='BCEL', GO_name='natural killer cell differentiation'),
    Nt(p_uncorrected=0.00010213272303415047, study_count=15, study_n=1397, namespace='biological_process', p_fdr_bh=0.012351011267362396, study_items=set([u'ENSMUSG00000020097', u'ENSMUSG00000032440', u'ENSMUSG00000062078', u'ENSMUSG00000001761', u'ENSMUSG00000021127', u'ENSMUSG00000030796', u'ENSMUSG00000006386', u'ENSMUSG00000075254', u'ENSMUSG00000053110', u'ENSMUSG00000032220', u'ENSMUSG00000033191', u'ENSMUSG00000025902', u'ENSMUSG00000022309', u'ENSMUSG00000007655', u'ENSMUSG00000055254']), NS='BP', pop_items=set([u'ENSMUSG00000026921', u'ENSMUSG00000022306', u'ENSMUSG00000021127', u'ENSMUSG00000021681', u'ENSMUSG00000030796', u'ENSMUSG00000006386', u'ENSMUSG00000032187', u'ENSMUSG00000001517', u'ENSMUSG00000044337', u'ENSMUSG00000038545', u'ENSMUSG00000026814', u'ENSMUSG00000022475', u'ENSMUSG00000022309', u'ENSMUSG00000001761', u'ENSMUSG00000052837', u'ENSMUSG00000002603', u'ENSMUSG00000032220', u'ENSMUSG00000040289', u'ENSMUSG00000006932', u'ENSMUSG00000006445', u'ENSMUSG00000053110', u'ENSMUSG00000032440', u'ENSMUSG00000044791', u'ENSMUSG00000000378', u'ENSMUSG00000074733', u'ENSMUSG00000069763', u'ENSMUSG00000075254', u'ENSMUSG00000007655', u'ENSMUSG00000049791', u'ENSMUSG00000029276', u'ENSMUSG00000041688', u'ENSMUSG00000039910', u'ENSMUSG00000072720', u'ENSMUSG00000019789', u'ENSMUSG00000044562', u'ENSMUSG00000055254', u'ENSMUSG00000004233', u'ENSMUSG00000025314', u'ENSMUSG00000062078', u'ENSMUSG00000022607', u'ENSMUSG00000007817', u'ENSMUSG00000062960', u'ENSMUSG00000028086', u'ENSMUSG00000020097', u'ENSMUSG00000002221', u'ENSMUSG00000029287', u'ENSMUSG00000034520', u'ENSMUSG00000033191', u'ENSMUSG00000025902', u'ENSMUSG00000034640', u'ENSMUSG00000001240']), pop_n=13836, p_sm_bonferroni=1.0, is_obsolete=False, GO='GO:0001570', name='vasculogenesis', pop_count=51, alt_ids=[], level=5, depth=5, enrichment='e', Cluster='Late Increase', geneid_set=set([u'ENSMUSG00000053110', u'ENSMUSG00000030796', u'ENSMUSG00000022309', u'ENSMUSG00000001761', u'ENSMUSG00000062078', u'ENSMUSG00000032440', u'ENSMUSG00000021127', u'ENSMUSG00000006386', u'ENSMUSG00000075254', u'ENSMUSG00000020097', u'ENSMUSG00000032220', u'ENSMUSG00000033191', u'ENSMUSG00000025902', u'ENSMUSG00000007655', u'ENSMUSG00000055254']), symbols=u'Angpt1 Cav1 Heg1 Myo1e Ntrk2 Qk Sgpl1 Smo Sox17 Tead2 Tek Tgfbr2 Tie1 Yap1 Zfp36l1', symbol_set=set([u'Cav1', u'Tgfbr2', u'Sgpl1', u'Tek', u'Heg1', u'Myo1e', u'Tie1', u'Zfp36l1', u'Ntrk2', u'Sox17', u'Smo', u'Tead2', u'Qk', u'Angpt1', u'Yap1']), geneids='ENSMUSG00000053110 ENSMUSG00000032220 ENSMUSG00000022309 ENSMUSG00000001761 ENSMUSG00000021127 ENSMUSG00000030796 ENSMUSG00000006386 ENSMUSG00000075254 ENSMUSG00000055254 ENSMUSG00000020097 ENSMUSG00000062078 ENSMUSG00000033191 ENSMUSG00000025902 ENSMUSG00000007655 ENSMUSG00000032440', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=2, D1='BCE', GO_name='vasculogenesis'),
    Nt(p_uncorrected=0.000103529696452711, study_count=4, study_n=1397, namespace='biological_process', p_fdr_bh=0.012351011267362396, study_items=set([u'ENSMUSG00000023224', u'ENSMUSG00000022912', u'ENSMUSG00000032231', u'ENSMUSG00000021822']), NS='BP', pop_items=set([u'ENSMUSG00000023224', u'ENSMUSG00000022912', u'ENSMUSG00000032231', u'ENSMUSG00000021822']), pop_n=13836, p_sm_bonferroni=1.0, is_obsolete=False, GO='GO:0042730', name='fibrinolysis', pop_count=4, alt_ids=[], level=6, depth=9, enrichment='e', Cluster='Late Increase', geneid_set=set([u'ENSMUSG00000023224', u'ENSMUSG00000022912', u'ENSMUSG00000032231', u'ENSMUSG00000021822']), symbols=u'Anxa2 Plau Pros1 Serping1', symbol_set=set([u'Anxa2', u'Serping1', u'Pros1', u'Plau']), geneids='ENSMUSG00000023224 ENSMUSG00000022912 ENSMUSG00000032231 ENSMUSG00000021822', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=0, D1='A', GO_name='fibrinolysis'),
    Nt(p_uncorrected='', study_count='', study_n='', namespace='', p_fdr_bh='', study_items='', NS='BP', pop_items='', pop_n='', p_sm_bonferroni='', is_obsolete='', GO='GO:0032368', name='', pop_count='', alt_ids='', level=5, depth=5, enrichment='', Cluster='', geneid_set='', symbols='', symbol_set='', geneids='', format_txt=1, hdr_idx=1, is_hdrgo=True, is_usrgo=False, hdr1usr01='*', dcnt=135, D1='A', GO_name='regulation of lipid transport'),
    Nt(p_uncorrected='', study_count='', study_n='', namespace='', p_fdr_bh='', study_items='', NS='BP', pop_items='', pop_n='', p_sm_bonferroni='', is_obsolete='', GO='GO:0050896', name='', pop_count='', alt_ids='', level=1, depth=1, enrichment='', Cluster='', geneid_set='', symbols='', symbol_set='', geneids='', format_txt=1, hdr_idx=1, is_hdrgo=True, is_usrgo=False, hdr1usr01='*', dcnt=2241, D1='F', GO_name='response to stimulus'),
    Nt(p_uncorrected=9.479048500726317e-05, study_count=13, study_n=1397, namespace='biological_process', p_fdr_bh=0.011869178829297887, study_items=set([u'ENSMUSG00000002365', u'ENSMUSG00000039361', u'ENSMUSG00000030720', u'ENSMUSG00000026656', u'ENSMUSG00000032440', u'ENSMUSG00000022150', u'ENSMUSG00000026712', u'ENSMUSG00000002985', u'ENSMUSG00000051439', u'ENSMUSG00000020828', u'ENSMUSG00000033039', u'ENSMUSG00000020122', u'ENSMUSG00000034652']), NS='BP', pop_items=set([u'ENSMUSG00000026825', u'ENSMUSG00000026712', u'ENSMUSG00000040249', u'ENSMUSG00000026656', u'ENSMUSG00000029716', u'ENSMUSG00000020476', u'ENSMUSG00000020828', u'ENSMUSG00000033039', u'ENSMUSG00000031302', u'ENSMUSG00000024924', u'ENSMUSG00000030720', u'ENSMUSG00000051504', u'ENSMUSG00000047126', u'ENSMUSG00000032440', u'ENSMUSG00000022150', u'ENSMUSG00000045730', u'ENSMUSG00000002985', u'ENSMUSG00000015947', u'ENSMUSG00000018920', u'ENSMUSG00000034652', u'ENSMUSG00000028656', u'ENSMUSG00000000915', u'ENSMUSG00000021278', u'ENSMUSG00000039361', u'ENSMUSG00000026726', u'ENSMUSG00000037295', u'ENSMUSG00000033335', u'ENSMUSG00000022797', u'ENSMUSG00000029146', u'ENSMUSG00000028657', u'ENSMUSG00000031078', u'ENSMUSG00000034255', u'ENSMUSG00000025492', u'ENSMUSG00000002365', u'ENSMUSG00000051439', u'ENSMUSG00000027070', u'ENSMUSG00000048058', u'ENSMUSG00000062234', u'ENSMUSG00000020122', u'ENSMUSG00000025393']), pop_n=13836, p_sm_bonferroni=1.0, is_obsolete=False, GO='GO:0006898', name='receptor-mediated endocytosis', pop_count=40, alt_ids=[], level=6, depth=6, enrichment='e', Cluster='Late Increase', geneid_set=set([u'ENSMUSG00000002365', u'ENSMUSG00000039361', u'ENSMUSG00000030720', u'ENSMUSG00000026656', u'ENSMUSG00000032440', u'ENSMUSG00000022150', u'ENSMUSG00000002985', u'ENSMUSG00000051439', u'ENSMUSG00000020828', u'ENSMUSG00000020122', u'ENSMUSG00000033039', u'ENSMUSG00000026712', u'ENSMUSG00000034652']), symbols=u'Apoe Cd14 Cd300a Cln3 Dab2 Egfr Fcgr2b Micall1 Mrc1 Picalm Pld2 Snx9 Tgfbr2', symbol_set=set([u'Tgfbr2', u'Apoe', u'Pld2', u'Mrc1', u'Micall1', u'Egfr', u'Snx9', u'Fcgr2b', u'Cd14', u'Cln3', u'Dab2', u'Cd300a', u'Picalm']), geneids='ENSMUSG00000002365 ENSMUSG00000039361 ENSMUSG00000030720 ENSMUSG00000026656 ENSMUSG00000032440 ENSMUSG00000022150 ENSMUSG00000026712 ENSMUSG00000002985 ENSMUSG00000051439 ENSMUSG00000020828 ENSMUSG00000033039 ENSMUSG00000020122 ENSMUSG00000034652', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=24, D1='G', GO_name='receptor-mediated endocytosis'),
    Nt(p_uncorrected=0.00034768873893544926, study_count=118, study_n=1397, namespace='biological_process', p_fdr_bh=0.03098724755065289, study_items=set([u'ENSMUSG00000061517', u'ENSMUSG00000029003', u'ENSMUSG00000048100', u'ENSMUSG00000031586', u'ENSMUSG00000002812', u'ENSMUSG00000033016', u'ENSMUSG00000034957', u'ENSMUSG00000038393', u'ENSMUSG00000025612', u'ENSMUSG00000004591', u'ENSMUSG00000032035', u'ENSMUSG00000053110', u'ENSMUSG00000062312', u'ENSMUSG00000051910', u'ENSMUSG00000033713', u'ENSMUSG00000063506', u'ENSMUSG00000061524', u'ENSMUSG00000030717', u'ENSMUSG00000027878', u'ENSMUSG00000040713', u'ENSMUSG00000000567', u'ENSMUSG00000007872', u'ENSMUSG00000000078', u'ENSMUSG00000026380', u'ENSMUSG00000060601', u'ENSMUSG00000052056', u'ENSMUSG00000002147', u'ENSMUSG00000061436', u'ENSMUSG00000039158', u'ENSMUSG00000041390', u'ENSMUSG00000020538', u'ENSMUSG00000015839', u'ENSMUSG00000024696', u'ENSMUSG00000048402', u'ENSMUSG00000047407', u'ENSMUSG00000051495', u'ENSMUSG00000035686', u'ENSMUSG00000034227', u'ENSMUSG00000003184', u'ENSMUSG00000015149', u'ENSMUSG00000042745', u'ENSMUSG00000021775', u'ENSMUSG00000034101', u'ENSMUSG00000062209', u'ENSMUSG00000000708', u'ENSMUSG00000025025', u'ENSMUSG00000029705', u'ENSMUSG00000000552', u'ENSMUSG00000039191', u'ENSMUSG00000036098', u'ENSMUSG00000053007', u'ENSMUSG00000031365', u'ENSMUSG00000007613', u'ENSMUSG00000015776', u'ENSMUSG00000020644', u'ENSMUSG00000074637', u'ENSMUSG00000023990', u'ENSMUSG00000061544', u'ENSMUSG00000026923', u'ENSMUSG00000020715', u'ENSMUSG00000030796', u'ENSMUSG00000030256', u'ENSMUSG00000020919', u'ENSMUSG00000028150', u'ENSMUSG00000041235', u'ENSMUSG00000019803', u'ENSMUSG00000024420', u'ENSMUSG00000024030', u'ENSMUSG00000039410', u'ENSMUSG00000074622', u'ENSMUSG00000020037', u'ENSMUSG00000030087', u'ENSMUSG00000055435', u'ENSMUSG00000026586', u'ENSMUSG00000020467', u'ENSMUSG00000040596', u'ENSMUSG00000032194', u'ENSMUSG00000021318', u'ENSMUSG00000025239', u'ENSMUSG00000052942', u'ENSMUSG00000010461', u'ENSMUSG00000002996', u'ENSMUSG00000008393', u'ENSMUSG00000029771', u'ENSMUSG00000028042', u'ENSMUSG00000032238', u'ENSMUSG00000038375', u'ENSMUSG00000021366', u'ENSMUSG00000020473', u'ENSMUSG00000046160', u'ENSMUSG00000057672', u'ENSMUSG00000035873', u'ENSMUSG00000035158', u'ENSMUSG00000027985', u'ENSMUSG00000018654', u'ENSMUSG00000038648', u'ENSMUSG00000036192', u'ENSMUSG00000038539', u'ENSMUSG00000024063', u'ENSMUSG00000021540', u'ENSMUSG00000048249', u'ENSMUSG00000058638', u'ENSMUSG00000029723', u'ENSMUSG00000033006', u'ENSMUSG00000031666', u'ENSMUSG00000025584', u'ENSMUSG00000031665', u'ENSMUSG00000021379', u'ENSMUSG00000027168', u'ENSMUSG00000038679', u'ENSMUSG00000043456', u'ENSMUSG00000004043', u'ENSMUSG00000028163', u'ENSMUSG00000004044', u'ENSMUSG00000025902', u'ENSMUSG00000037621', u'ENSMUSG00000038872', u'ENSMUSG00000021838']), NS='BP', pop_items=set([u'ENSMUSG00000028431', u'ENSMUSG00000004897', u'ENSMUSG00000028341', u'ENSMUSG00000038895', u'ENSMUSG00000034957', u'ENSMUSG00000020755', u'ENSMUSG00000045482', u'ENSMUSG00000023883', u'ENSMUSG00000022010', u'ENSMUSG00000033863', u'ENSMUSG00000028233', u'ENSMUSG00000024045', u'ENSMUSG00000042292', u'ENSMUSG00000036036', u'ENSMUSG00000021810', u'ENSMUSG00000002658', u'ENSMUSG00000001472', u'ENSMUSG00000020364', u'ENSMUSG00000022914', u'ENSMUSG00000020362', u'ENSMUSG00000064127', u'ENSMUSG00000078868', u'ENSMUSG00000015461', u'ENSMUSG00000078866', u'ENSMUSG00000015468', u'ENSMUSG00000032249', u'ENSMUSG00000019826', u'ENSMUSG00000024193', u'ENSMUSG00000021963', u'ENSMUSG00000048280', u'ENSMUSG00000070939', u'ENSMUSG00000054452', u'ENSMUSG00000000787', u'ENSMUSG00000037788', u'ENSMUSG00000005373', u'ENSMUSG00000063049', u'ENSMUSG00000063047', u'ENSMUSG00000005378', u'ENSMUSG00000037149', u'ENSMUSG00000020962', u'ENSMUSG00000063108', u'ENSMUSG00000030796', u'ENSMUSG00000038784', u'ENSMUSG00000039656', u'ENSMUSG00000030400', u'ENSMUSG00000010175', u'ENSMUSG00000030067', u'ENSMUSG00000041235', u'ENSMUSG00000027620', u'ENSMUSG00000030888', u'ENSMUSG00000015605', u'ENSMUSG00000026204', u'ENSMUSG00000030087', u'ENSMUSG00000055435', u'ENSMUSG00000038095', u'ENSMUSG00000056749', u'ENSMUSG00000037214', u'ENSMUSG00000024952', u'ENSMUSG00000031939', u'ENSMUSG00000031422', u'ENSMUSG00000031935', u'ENSMUSG00000062312', u'ENSMUSG00000048728', u'ENSMUSG00000025878', u'ENSMUSG00000021366', u'ENSMUSG00000005534', u'ENSMUSG00000023055', u'ENSMUSG00000029004', u'ENSMUSG00000029003', u'ENSMUSG00000031681', u'ENSMUSG00000042903', u'ENSMUSG00000062270', u'ENSMUSG00000031111', u'ENSMUSG00000009640', u'ENSMUSG00000028759', u'ENSMUSG00000025584', u'ENSMUSG00000025470', u'ENSMUSG00000029178', u'ENSMUSG00000029913', u'ENSMUSG00000025902', u'ENSMUSG00000025907', u'ENSMUSG00000026803', u'ENSMUSG00000061517', u'ENSMUSG00000029754', u'ENSMUSG00000029599', u'ENSMUSG00000047989', u'ENSMUSG00000022475', u'ENSMUSG00000022471', u'ENSMUSG00000025616', u'ENSMUSG00000039087', u'ENSMUSG00000025612', u'ENSMUSG00000016253', u'ENSMUSG00000052534', u'ENSMUSG00000021109', u'ENSMUSG00000026778', u'ENSMUSG00000059288', u'ENSMUSG00000021103', u'ENSMUSG00000035236', u'ENSMUSG00000020185', u'ENSMUSG00000032497', u'ENSMUSG00000018347', u'ENSMUSG00000025128', u'ENSMUSG00000068245', u'ENSMUSG00000025050', u'ENSMUSG00000034430', u'ENSMUSG00000035125', u'ENSMUSG00000066798', u'ENSMUSG00000032652', u'ENSMUSG00000059824', u'ENSMUSG00000006307', u'ENSMUSG00000017299', u'ENSMUSG00000024052', u'ENSMUSG00000045103', u'ENSMUSG00000044452', u'ENSMUSG00000002307', u'ENSMUSG00000053914', u'ENSMUSG00000021779', u'ENSMUSG00000023980', u'ENSMUSG00000078671', u'ENSMUSG00000021807', u'ENSMUSG00000004934', u'ENSMUSG00000021775', u'ENSMUSG00000020358', u'ENSMUSG00000045215', u'ENSMUSG00000049038', u'ENSMUSG00000027433', u'ENSMUSG00000027434', u'ENSMUSG00000053483', u'ENSMUSG00000039910', u'ENSMUSG00000044676', u'ENSMUSG00000053007', u'ENSMUSG00000021767', u'ENSMUSG00000021972', u'ENSMUSG00000060257', u'ENSMUSG00000024454', u'ENSMUSG00000079658', u'ENSMUSG00000078496', u'ENSMUSG00000050295', u'ENSMUSG00000053470', u'ENSMUSG00000021598', u'ENSMUSG00000036376', u'ENSMUSG00000024985', u'ENSMUSG00000075028', u'ENSMUSG00000041649', u'ENSMUSG00000037174', u'ENSMUSG00000076431', u'ENSMUSG00000026586', u'ENSMUSG00000033454', u'ENSMUSG00000038797', u'ENSMUSG00000021027', u'ENSMUSG00000055228', u'ENSMUSG00000033054', u'ENSMUSG00000024526', u'ENSMUSG00000000134', u'ENSMUSG00000055480', u'ENSMUSG00000043866', u'ENSMUSG00000026273', u'ENSMUSG00000038080', u'ENSMUSG00000030505', u'ENSMUSG00000041911', u'ENSMUSG00000071637', u'ENSMUSG00000000355', u'ENSMUSG00000027985', u'ENSMUSG00000031431', u'ENSMUSG00000038648', u'ENSMUSG00000026104', u'ENSMUSG00000004328', u'ENSMUSG00000048756', u'ENSMUSG00000034157', u'ENSMUSG00000021379', u'ENSMUSG00000026563', u'ENSMUSG00000026565', u'ENSMUSG00000047371', u'ENSMUSG00000023048', u'ENSMUSG00000031103', u'ENSMUSG00000038255', u'ENSMUSG00000020515', u'ENSMUSG00000022641', u'ENSMUSG00000046351', u'ENSMUSG00000020519', u'ENSMUSG00000022240', u'ENSMUSG00000029290', u'ENSMUSG00000025912', u'ENSMUSG00000025917', u'ENSMUSG00000039231', u'ENSMUSG00000026814', u'ENSMUSG00000029729', u'ENSMUSG00000020423', u'ENSMUSG00000020420', u'ENSMUSG00000009741', u'ENSMUSG00000042589', u'ENSMUSG00000029723', u'ENSMUSG00000011837', u'ENSMUSG00000089756', u'ENSMUSG00000028252', u'ENSMUSG00000005897', u'ENSMUSG00000052056', u'ENSMUSG00000035673', u'ENSMUSG00000021113', u'ENSMUSG00000009569', u'ENSMUSG00000037992', u'ENSMUSG00000029439', u'ENSMUSG00000032481', u'ENSMUSG00000062931', u'ENSMUSG00000035842', u'ENSMUSG00000048402', u'ENSMUSG00000034429', u'ENSMUSG00000028522', u'ENSMUSG00000043456', u'ENSMUSG00000034422', u'ENSMUSG00000025049', u'ENSMUSG00000018750', u'ENSMUSG00000091337', u'ENSMUSG00000060314', u'ENSMUSG00000054611', u'ENSMUSG00000001419', u'ENSMUSG00000042323', u'ENSMUSG00000044519', u'ENSMUSG00000020647', u'ENSMUSG00000020644', u'ENSMUSG00000053477', u'ENSMUSG00000023991', u'ENSMUSG00000045598', u'ENSMUSG00000023994', u'ENSMUSG00000004591', u'ENSMUSG00000047342', u'ENSMUSG00000019338', u'ENSMUSG00000018537', u'ENSMUSG00000017376', u'ENSMUSG00000061013', u'ENSMUSG00000036167', u'ENSMUSG00000019803', u'ENSMUSG00000060261', u'ENSMUSG00000024420', u'ENSMUSG00000091243', u'ENSMUSG00000001520', u'ENSMUSG00000001524', u'ENSMUSG00000078486', u'ENSMUSG00000020232', u'ENSMUSG00000058291', u'ENSMUSG00000038415', u'ENSMUSG00000038418', u'ENSMUSG00000024081', u'ENSMUSG00000044647', u'ENSMUSG00000037761', u'ENSMUSG00000037169', u'ENSMUSG00000015597', u'ENSMUSG00000062794', u'ENSMUSG00000040187', u'ENSMUSG00000059439', u'ENSMUSG00000024955', u'ENSMUSG00000037188', u'ENSMUSG00000059436', u'ENSMUSG00000024220', u'ENSMUSG00000001741', u'ENSMUSG00000050600', u'ENSMUSG00000070643', u'ENSMUSG00000041215', u'ENSMUSG00000041740', u'ENSMUSG00000027358', u'ENSMUSG00000026484', u'ENSMUSG00000063273', u'ENSMUSG00000049583', u'ENSMUSG00000058638', u'ENSMUSG00000005621', u'ENSMUSG00000055148', u'ENSMUSG00000037235', u'ENSMUSG00000037343', u'ENSMUSG00000030421', u'ENSMUSG00000056962', u'ENSMUSG00000004043', u'ENSMUSG00000004040', u'ENSMUSG00000027770', u'ENSMUSG00000004044', u'ENSMUSG00000026174', u'ENSMUSG00000022109', u'ENSMUSG00000022105', u'ENSMUSG00000038630', u'ENSMUSG00000015053', u'ENSMUSG00000073062', u'ENSMUSG00000000902', u'ENSMUSG00000046909', u'ENSMUSG00000030350', u'ENSMUSG00000004661', u'ENSMUSG00000031353', u'ENSMUSG00000040167', u'ENSMUSG00000051469', u'ENSMUSG00000004264', u'ENSMUSG00000051390', u'ENSMUSG00000023079', u'ENSMUSG00000031358', u'ENSMUSG00000040761', u'ENSMUSG00000063870', u'ENSMUSG00000039697', u'ENSMUSG00000057406', u'ENSMUSG00000029111', u'ENSMUSG00000029110', u'ENSMUSG00000057367', u'ENSMUSG00000061650', u'ENSMUSG00000034525', u'ENSMUSG00000043668', u'ENSMUSG00000028211', u'ENSMUSG00000038331', u'ENSMUSG00000024067', u'ENSMUSG00000015839', u'ENSMUSG00000037364', u'ENSMUSG00000036281', u'ENSMUSG00000028647', u'ENSMUSG00000028882', u'ENSMUSG00000028886', u'ENSMUSG00000052040', u'ENSMUSG00000045903', u'ENSMUSG00000042625', u'ENSMUSG00000024384', u'ENSMUSG00000037984', u'ENSMUSG00000008575', u'ENSMUSG00000028466', u'ENSMUSG00000028397', u'ENSMUSG00000008976', u'ENSMUSG00000035696', u'ENSMUSG00000048416', u'ENSMUSG00000035456', u'ENSMUSG00000007812', u'ENSMUSG00000042487', u'ENSMUSG00000021639', u'ENSMUSG00000070002', u'ENSMUSG00000054604', u'ENSMUSG00000028066', u'ENSMUSG00000046658', u'ENSMUSG00000006362', u'ENSMUSG00000074158', u'ENSMUSG00000026826', u'ENSMUSG00000004151', u'ENSMUSG00000028266', u'ENSMUSG00000013089', u'ENSMUSG00000042557', u'ENSMUSG00000044501', u'ENSMUSG00000061315', u'ENSMUSG00000020656', u'ENSMUSG00000018923', u'ENSMUSG00000059866', u'ENSMUSG00000044475', u'ENSMUSG00000002996', u'ENSMUSG00000002221', u'ENSMUSG00000010505', u'ENSMUSG00000024431', u'ENSMUSG00000008398', u'ENSMUSG00000071359', u'ENSMUSG00000006215', u'ENSMUSG00000054737', u'ENSMUSG00000045302', u'ENSMUSG00000020248', u'ENSMUSG00000019256', u'ENSMUSG00000043991', u'ENSMUSG00000058756', u'ENSMUSG00000078902', u'ENSMUSG00000049164', u'ENSMUSG00000022811', u'ENSMUSG00000063659', u'ENSMUSG00000038539', u'ENSMUSG00000038533', u'ENSMUSG00000038535', u'ENSMUSG00000033430', u'ENSMUSG00000024947', u'ENSMUSG00000021936', u'ENSMUSG00000024949', u'ENSMUSG00000019789', u'ENSMUSG00000059401', u'ENSMUSG00000030744', u'ENSMUSG00000027168', u'ENSMUSG00000020397', u'ENSMUSG00000091474', u'ENSMUSG00000020392', u'ENSMUSG00000027163', u'ENSMUSG00000027167', u'ENSMUSG00000020889', u'ENSMUSG00000027361', u'ENSMUSG00000006335', u'ENSMUSG00000022228', u'ENSMUSG00000026496', u'ENSMUSG00000026491', u'ENSMUSG00000026492', u'ENSMUSG00000039756', u'ENSMUSG00000039754', u'ENSMUSG00000031586', u'ENSMUSG00000031585', u'ENSMUSG00000027387', u'ENSMUSG00000030291', u'ENSMUSG00000030189', u'ENSMUSG00000056608', u'ENSMUSG00000030180', u'ENSMUSG00000031902', u'ENSMUSG00000031907', u'ENSMUSG00000004698', u'ENSMUSG00000038622', u'ENSMUSG00000022394', u'ENSMUSG00000036867', u'ENSMUSG00000059669', u'ENSMUSG00000003585', u'ENSMUSG00000057551', u'ENSMUSG00000056770', u'ENSMUSG00000026017', u'ENSMUSG00000026380', u'ENSMUSG00000025932', u'ENSMUSG00000090258', u'ENSMUSG00000031161', u'ENSMUSG00000069495', u'ENSMUSG00000020538', u'ENSMUSG00000029634', u'ENSMUSG00000029635', u'ENSMUSG00000043059', u'ENSMUSG00000049577', u'ENSMUSG00000031832', u'ENSMUSG00000029127', u'ENSMUSG00000034538', u'ENSMUSG00000038344', u'ENSMUSG00000021134', u'ENSMUSG00000038342', u'ENSMUSG00000039219', u'ENSMUSG00000002250', u'ENSMUSG00000057604', u'ENSMUSG00000029705', u'ENSMUSG00000028651', u'ENSMUSG00000028654', u'ENSMUSG00000028890', u'ENSMUSG00000029387', u'ENSMUSG00000028899', u'ENSMUSG00000007613', u'ENSMUSG00000025025', u'ENSMUSG00000036916', u'ENSMUSG00000070034', u'ENSMUSG00000020715', u'ENSMUSG00000059897', u'ENSMUSG00000020719', u'ENSMUSG00000002052', u'ENSMUSG00000025159', u'ENSMUSG00000046791', u'ENSMUSG00000046792', u'ENSMUSG00000015804', u'ENSMUSG00000070348', u'ENSMUSG00000035469', u'ENSMUSG00000052675', u'ENSMUSG00000012076', u'ENSMUSG00000071291', u'ENSMUSG00000028271', u'ENSMUSG00000038965', u'ENSMUSG00000045466', u'ENSMUSG00000042548', u'ENSMUSG00000028389', u'ENSMUSG00000020661', u'ENSMUSG00000092416', u'ENSMUSG00000002459', u'ENSMUSG00000002458', u'ENSMUSG00000045268', u'ENSMUSG00000039967', u'ENSMUSG00000032119', u'ENSMUSG00000061079', u'ENSMUSG00000059878', u'ENSMUSG00000067942', u'ENSMUSG00000071341', u'ENSMUSG00000008384', u'ENSMUSG00000002983', u'ENSMUSG00000044791', u'ENSMUSG00000032280', u'ENSMUSG00000022828', u'ENSMUSG00000000581', u'ENSMUSG00000036721', u'ENSMUSG00000054381', u'ENSMUSG00000033883', u'ENSMUSG00000033222', u'ENSMUSG00000002524', u'ENSMUSG00000010461', u'ENSMUSG00000000743', u'ENSMUSG00000007817', u'ENSMUSG00000020098', u'ENSMUSG00000040363', u'ENSMUSG00000023110', u'ENSMUSG00000058388', u'ENSMUSG00000038502', u'ENSMUSG00000049532', u'ENSMUSG00000054893', u'ENSMUSG00000001988', u'ENSMUSG00000038518', u'ENSMUSG00000027177', u'ENSMUSG00000020893', u'ENSMUSG00000038615', u'ENSMUSG00000033712', u'ENSMUSG00000033713', u'ENSMUSG00000003868', u'ENSMUSG00000005609', u'ENSMUSG00000054967', u'ENSMUSG00000031575', u'ENSMUSG00000050240', u'ENSMUSG00000005045', u'ENSMUSG00000000567', u'ENSMUSG00000000568', u'ENSMUSG00000056941', u'ENSMUSG00000025402', u'ENSMUSG00000026628', u'ENSMUSG00000062352', u'ENSMUSG00000022383', u'ENSMUSG00000031487', u'ENSMUSG00000027951', u'ENSMUSG00000022389', u'ENSMUSG00000055762', u'ENSMUSG00000056167', u'ENSMUSG00000031379', u'ENSMUSG00000014859', u'ENSMUSG00000026536', u'ENSMUSG00000031374', u'ENSMUSG00000026021', u'ENSMUSG00000038766', u'ENSMUSG00000056493', u'ENSMUSG00000031393', u'ENSMUSG00000055612', u'ENSMUSG00000034297', u'ENSMUSG00000031622', u'ENSMUSG00000003282', u'ENSMUSG00000031627', u'ENSMUSG00000031157', u'ENSMUSG00000022634', u'ENSMUSG00000031629', u'ENSMUSG00000022708', u'ENSMUSG00000029135', u'ENSMUSG00000022702', u'ENSMUSG00000047036', u'ENSMUSG00000057835', u'ENSMUSG00000012114', u'ENSMUSG00000035277', u'ENSMUSG00000036923', u'ENSMUSG00000066687', u'ENSMUSG00000022521', u'ENSMUSG00000020412', u'ENSMUSG00000028668', u'ENSMUSG00000029712', u'ENSMUSG00000020415', u'ENSMUSG00000022526', u'ENSMUSG00000029249', u'ENSMUSG00000022528', u'ENSMUSG00000003135', u'ENSMUSG00000029627', u'ENSMUSG00000028863', u'ENSMUSG00000020653', u'ENSMUSG00000066042', u'ENSMUSG00000009555', u'ENSMUSG00000025364', u'ENSMUSG00000025369', u'ENSMUSG00000062906', u'ENSMUSG00000008958', u'ENSMUSG00000034271', u'ENSMUSG00000025764', u'ENSMUSG00000035478', u'ENSMUSG00000072872', u'ENSMUSG00000028042', u'ENSMUSG00000001424', u'ENSMUSG00000021738', u'ENSMUSG00000008730', u'ENSMUSG00000028282', u'ENSMUSG00000028284', u'ENSMUSG00000035873', u'ENSMUSG00000042570', u'ENSMUSG00000018651', u'ENSMUSG00000035011', u'ENSMUSG00000018654', u'ENSMUSG00000032727', u'ENSMUSG00000001517', u'ENSMUSG00000054716', u'ENSMUSG00000045098', u'ENSMUSG00000079184', u'ENSMUSG00000024382', u'ENSMUSG00000045252', u'ENSMUSG00000042207', u'ENSMUSG00000078580', u'ENSMUSG00000059842', u'ENSMUSG00000021938', u'ENSMUSG00000074221', u'ENSMUSG00000024140', u'ENSMUSG00000019878', u'ENSMUSG00000027544', u'ENSMUSG00000020267', u'ENSMUSG00000001289', u'ENSMUSG00000001288', u'ENSMUSG00000001280', u'ENSMUSG00000048897', u'ENSMUSG00000039959', u'ENSMUSG00000053754', u'ENSMUSG00000002881', u'ENSMUSG00000017548', u'ENSMUSG00000051910', u'ENSMUSG00000037730', u'ENSMUSG00000014039', u'ENSMUSG00000020063', u'ENSMUSG00000079509', u'ENSMUSG00000063632', u'ENSMUSG00000040310', u'ENSMUSG00000061360', u'ENSMUSG00000024968', u'ENSMUSG00000042599', u'ENSMUSG00000030619', u'ENSMUSG00000024369', u'ENSMUSG00000037640', u'ENSMUSG00000027490', u'ENSMUSG00000032515', u'ENSMUSG00000024565', u'ENSMUSG00000024563', u'ENSMUSG00000024561', u'ENSMUSG00000024560', u'ENSMUSG00000041777', u'ENSMUSG00000090659', u'ENSMUSG00000055116', u'ENSMUSG00000000552', u'ENSMUSG00000008393', u'ENSMUSG00000037395', u'ENSMUSG00000037465', u'ENSMUSG00000032299', u'ENSMUSG00000015149', u'ENSMUSG00000018909', u'ENSMUSG00000062209', u'ENSMUSG00000072501', u'ENSMUSG00000055024', u'ENSMUSG00000030380', u'ENSMUSG00000031706', u'ENSMUSG00000030386', u'ENSMUSG00000040429', u'ENSMUSG00000037032', u'ENSMUSG00000031365', u'ENSMUSG00000051451', u'ENSMUSG00000048154', u'ENSMUSG00000003923', u'ENSMUSG00000031386', u'ENSMUSG00000042814', u'ENSMUSG00000025959', u'ENSMUSG00000025958', u'ENSMUSG00000005886', u'ENSMUSG00000057842', u'ENSMUSG00000025423', u'ENSMUSG00000034041', u'ENSMUSG00000062116', u'ENSMUSG00000034042', u'ENSMUSG00000038369', u'ENSMUSG00000020467', u'ENSMUSG00000046269', u'ENSMUSG00000089715', u'ENSMUSG00000027569', u'ENSMUSG00000029279', u'ENSMUSG00000046311', u'ENSMUSG00000025880', u'ENSMUSG00000047242', u'ENSMUSG00000006720', u'ENSMUSG00000039804', u'ENSMUSG00000029478', u'ENSMUSG00000009013', u'ENSMUSG00000029475', u'ENSMUSG00000028676', u'ENSMUSG00000028675', u'ENSMUSG00000035397', u'ENSMUSG00000034460', u'ENSMUSG00000028053', u'ENSMUSG00000074102', u'ENSMUSG00000038773', u'ENSMUSG00000028291', u'ENSMUSG00000028901', u'ENSMUSG00000038384', u'ENSMUSG00000035021', u'ENSMUSG00000016150', u'ENSMUSG00000038774', u'ENSMUSG00000045248', u'ENSMUSG00000052837', u'ENSMUSG00000059851', u'ENSMUSG00000044934', u'ENSMUSG00000036120', u'ENSMUSG00000024176', u'ENSMUSG00000055639', u'ENSMUSG00000024287', u'ENSMUSG00000024283', u'ENSMUSG00000045333', u'ENSMUSG00000020275', u'ENSMUSG00000027552', u'ENSMUSG00000027551', u'ENSMUSG00000041147', u'ENSMUSG00000054823', u'ENSMUSG00000039830', u'ENSMUSG00000039834', u'ENSMUSG00000021890', u'ENSMUSG00000037029', u'ENSMUSG00000006392', u'ENSMUSG00000037896', u'ENSMUSG00000020074', u'ENSMUSG00000026739', u'ENSMUSG00000060450', u'ENSMUSG00000066900', u'ENSMUSG00000024914', u'ENSMUSG00000024912', u'ENSMUSG00000041096', u'ENSMUSG00000030970', u'ENSMUSG00000030604', u'ENSMUSG00000041540', u'ENSMUSG00000005442', u'ENSMUSG00000049300', u'ENSMUSG00000003847', u'ENSMUSG00000033773', u'ENSMUSG00000004221', u'ENSMUSG00000024826', u'ENSMUSG00000090641', u'ENSMUSG00000027803', u'ENSMUSG00000059475', u'ENSMUSG00000059474', u'ENSMUSG00000001016', u'ENSMUSG00000001017', u'ENSMUSG00000070576', u'ENSMUSG00000033730', u'ENSMUSG00000015776', u'ENSMUSG00000043962', u'ENSMUSG00000026604', u'ENSMUSG00000043969', u'ENSMUSG00000026603', u'ENSMUSG00000027936', u'ENSMUSG00000033871', u'ENSMUSG00000030393', u'ENSMUSG00000030557', u'ENSMUSG00000026283', u'ENSMUSG00000030551', u'ENSMUSG00000041438', u'ENSMUSG00000040123', u'ENSMUSG00000023034', u'ENSMUSG00000003444', u'ENSMUSG00000069678', u'ENSMUSG00000038705', u'ENSMUSG00000022031', u'ENSMUSG00000047143', u'ENSMUSG00000062101', u'ENSMUSG00000046876', u'ENSMUSG00000055633', u'ENSMUSG00000021250', u'ENSMUSG00000049657', u'ENSMUSG00000073489', u'ENSMUSG00000021255', u'ENSMUSG00000026999', u'ENSMUSG00000057982', u'ENSMUSG00000054717', u'ENSMUSG00000031609', u'ENSMUSG00000040054', u'ENSMUSG00000045519', u'ENSMUSG00000022724', u'ENSMUSG00000034071', u'ENSMUSG00000038375', u'ENSMUSG00000022508', u'ENSMUSG00000020473', u'ENSMUSG00000020472', u'ENSMUSG00000003154', u'ENSMUSG00000022500', u'ENSMUSG00000029265', u'ENSMUSG00000057672', u'ENSMUSG00000047473', u'ENSMUSG00000029641', u'ENSMUSG00000022346', u'ENSMUSG00000028840', u'ENSMUSG00000058886', u'ENSMUSG00000034674', u'ENSMUSG00000058883', u'ENSMUSG00000034673', u'ENSMUSG00000058881', u'ENSMUSG00000015942', u'ENSMUSG00000039158', u'ENSMUSG00000013465', u'ENSMUSG00000056342', u'ENSMUSG00000039153', u'ENSMUSG00000042109', u'ENSMUSG00000048450', u'ENSMUSG00000043372', u'ENSMUSG00000052135', u'ENSMUSG00000047907', u'ENSMUSG00000002393', u'ENSMUSG00000023927', u'ENSMUSG00000042197', u'ENSMUSG00000034928', u'ENSMUSG00000038393', u'ENSMUSG00000018678', u'ENSMUSG00000033726', u'ENSMUSG00000046058', u'ENSMUSG00000035033', u'ENSMUSG00000017146', u'ENSMUSG00000063506', u'ENSMUSG00000017724', u'ENSMUSG00000014303', u'ENSMUSG00000068154', u'ENSMUSG00000019984', u'ENSMUSG00000018076', u'ENSMUSG00000032386', u'ENSMUSG00000080268', u'ENSMUSG00000035726', u'ENSMUSG00000032411', u'ENSMUSG00000019857', u'ENSMUSG00000032419', u'ENSMUSG00000033943', u'ENSMUSG00000027439', u'ENSMUSG00000062743', u'ENSMUSG00000048921', u'ENSMUSG00000067995', u'ENSMUSG00000032897', u'ENSMUSG00000039841', u'ENSMUSG00000053175', u'ENSMUSG00000017210', u'ENSMUSG00000037243', u'ENSMUSG00000037868', u'ENSMUSG00000002578', u'ENSMUSG00000058402', u'ENSMUSG00000032965', u'ENSMUSG00000054199', u'ENSMUSG00000033543', u'ENSMUSG00000005470', u'ENSMUSG00000026610', u'ENSMUSG00000024831', u'ENSMUSG00000050697', u'ENSMUSG00000030016', u'ENSMUSG00000020918', u'ENSMUSG00000020919', u'ENSMUSG00000027580', u'ENSMUSG00000027582', u'ENSMUSG00000027583', u'ENSMUSG00000027230', u'ENSMUSG00000000532', u'ENSMUSG00000050213', u'ENSMUSG00000000530', u'ENSMUSG00000037447', u'ENSMUSG00000061911', u'ENSMUSG00000030120', u'ENSMUSG00000003949', u'ENSMUSG00000040596', u'ENSMUSG00000006527', u'ENSMUSG00000051034', u'ENSMUSG00000026187', u'ENSMUSG00000031540', u'ENSMUSG00000041420', u'ENSMUSG00000023027', u'ENSMUSG00000003437', u'ENSMUSG00000003435', u'ENSMUSG00000038718', u'ENSMUSG00000026058', u'ENSMUSG00000030232', u'ENSMUSG00000021244', u'ENSMUSG00000031618', u'ENSMUSG00000057469', u'ENSMUSG00000048481', u'ENSMUSG00000063281', u'ENSMUSG00000049536', u'ENSMUSG00000003545', u'ENSMUSG00000047003', u'ENSMUSG00000056596', u'ENSMUSG00000025408', u'ENSMUSG00000003382', u'ENSMUSG00000048047', u'ENSMUSG00000006705', u'ENSMUSG00000063972', u'ENSMUSG00000026873', u'ENSMUSG00000026872', u'ENSMUSG00000029213', u'ENSMUSG00000029670', u'ENSMUSG00000025577', u'ENSMUSG00000015971', u'ENSMUSG00000038146', u'ENSMUSG00000025578', u'ENSMUSG00000069727', u'ENSMUSG00000016087', u'ENSMUSG00000021660', u'ENSMUSG00000028101', u'ENSMUSG00000029328', u'ENSMUSG00000034800', u'ENSMUSG00000025997', u'ENSMUSG00000057649', u'ENSMUSG00000034245', u'ENSMUSG00000028582', u'ENSMUSG00000020593', u'ENSMUSG00000020623', u'ENSMUSG00000029521', u'ENSMUSG00000028034', u'ENSMUSG00000023932', u'ENSMUSG00000042182', u'ENSMUSG00000042185', u'ENSMUSG00000018849', u'ENSMUSG00000016409', u'ENSMUSG00000035285', u'ENSMUSG00000042508', u'ENSMUSG00000042506', u'ENSMUSG00000050855', u'ENSMUSG00000002147', u'ENSMUSG00000021476', u'ENSMUSG00000079317', u'ENSMUSG00000001542', u'ENSMUSG00000053985', u'ENSMUSG00000049086', u'ENSMUSG00000016624', u'ENSMUSG00000018446', u'ENSMUSG00000045515', u'ENSMUSG00000042439', u'ENSMUSG00000032398', u'ENSMUSG00000032405', u'ENSMUSG00000032402', u'ENSMUSG00000078779', u'ENSMUSG00000020052', u'ENSMUSG00000000708', u'ENSMUSG00000002968', u'ENSMUSG00000044770', u'ENSMUSG00000017667', u'ENSMUSG00000039852', u'ENSMUSG00000036098', u'ENSMUSG00000053768', u'ENSMUSG00000040325', u'ENSMUSG00000040321', u'ENSMUSG00000024335', u'ENSMUSG00000050064', u'ENSMUSG00000005267', u'ENSMUSG00000055839', u'ENSMUSG00000022974', u'ENSMUSG00000055835', u'ENSMUSG00000000142', u'ENSMUSG00000026663', u'ENSMUSG00000049321', u'ENSMUSG00000049327', u'ENSMUSG00000024805', u'ENSMUSG00000030714', u'ENSMUSG00000024240', u'ENSMUSG00000027593', u'ENSMUSG00000027223', u'ENSMUSG00000067071', u'ENSMUSG00000043909', u'ENSMUSG00000056900', u'ENSMUSG00000054836', u'ENSMUSG00000033623', u'ENSMUSG00000039634', u'ENSMUSG00000041852', u'ENSMUSG00000063889', u'ENSMUSG00000040857', u'ENSMUSG00000023348', u'ENSMUSG00000041459', u'ENSMUSG00000030823', u'ENSMUSG00000027829', u'ENSMUSG00000040929', u'ENSMUSG00000003423', u'ENSMUSG00000014763', u'ENSMUSG00000014767', u'ENSMUSG00000030226', u'ENSMUSG00000029068', u'ENSMUSG00000051316', u'ENSMUSG00000031666', u'ENSMUSG00000031665', u'ENSMUSG00000031660', u'ENSMUSG00000051550', u'ENSMUSG00000023892', u'ENSMUSG00000004359', u'ENSMUSG00000029191', u'ENSMUSG00000057894', u'ENSMUSG00000009739', u'ENSMUSG00000029207', u'ENSMUSG00000020453', u'ENSMUSG00000063382', u'ENSMUSG00000026313', u'ENSMUSG00000003778', u'ENSMUSG00000022361', u'ENSMUSG00000022360', u'ENSMUSG00000046982', u'ENSMUSG00000017861', u'ENSMUSG00000028820', u'ENSMUSG00000062012', u'ENSMUSG00000015217', u'ENSMUSG00000029684', u'ENSMUSG00000029687', u'ENSMUSG00000030717', u'ENSMUSG00000057098', u'ENSMUSG00000024528', u'ENSMUSG00000057093', u'ENSMUSG00000025323', u'ENSMUSG00000034724', u'ENSMUSG00000035632', u'ENSMUSG00000028807', u'ENSMUSG00000052684', u'ENSMUSG00000035529', u'ENSMUSG00000062944', u'ENSMUSG00000034345', u'ENSMUSG00000028484', u'ENSMUSG00000028957', u'ENSMUSG00000028952', u'ENSMUSG00000045639', u'ENSMUSG00000052752', u'ENSMUSG00000007415', u'ENSMUSG00000050846', u'ENSMUSG00000033964', u'ENSMUSG00000022987', u'ENSMUSG00000018433', u'ENSMUSG00000063568', u'ENSMUSG00000042406', u'ENSMUSG00000016503', u'ENSMUSG00000039191', u'ENSMUSG00000068551', u'ENSMUSG00000060098', u'ENSMUSG00000013973', u'ENSMUSG00000062761', u'ENSMUSG00000032187', u'ENSMUSG00000032185', u'ENSMUSG00000019897', u'ENSMUSG00000019230', u'ENSMUSG00000039994', u'ENSMUSG00000039990', u'ENSMUSG00000021519', u'ENSMUSG00000001157', u'ENSMUSG00000001156', u'ENSMUSG00000074867', u'ENSMUSG00000024030', u'ENSMUSG00000021514', u'ENSMUSG00000078898', u'ENSMUSG00000048878', u'ENSMUSG00000044167', u'ENSMUSG00000015697', u'ENSMUSG00000036461', u'ENSMUSG00000038550', u'ENSMUSG00000032212', u'ENSMUSG00000024325', u'ENSMUSG00000022961', u'ENSMUSG00000027109', u'ENSMUSG00000041530', u'ENSMUSG00000030921', u'ENSMUSG00000027104', u'ENSMUSG00000037608', u'ENSMUSG00000020335', u'ENSMUSG00000033585', u'ENSMUSG00000049336', u'ENSMUSG00000025626', u'ENSMUSG00000036513', u'ENSMUSG00000033740', u'ENSMUSG00000030034', u'ENSMUSG00000024927', u'ENSMUSG00000024926', u'ENSMUSG00000000282', u'ENSMUSG00000024921', u'ENSMUSG00000058192', u'ENSMUSG00000037111', u'ENSMUSG00000027210', u'ENSMUSG00000070520', u'ENSMUSG00000038482', u'ENSMUSG00000049421', u'ENSMUSG00000051495', u'ENSMUSG00000051499', u'ENSMUSG00000031458', u'ENSMUSG00000030103', u'ENSMUSG00000048930', u'ENSMUSG00000074637', u'ENSMUSG00000040865', u'ENSMUSG00000055065', u'ENSMUSG00000020801', u'ENSMUSG00000027671', u'ENSMUSG00000030584', u'ENSMUSG00000027678', u'ENSMUSG00000026077', u'ENSMUSG00000040463', u'ENSMUSG00000030213', u'ENSMUSG00000000861', u'ENSMUSG00000040481', u'ENSMUSG00000021264', u'ENSMUSG00000042496', u'ENSMUSG00000022178', u'ENSMUSG00000040007', u'ENSMUSG00000049516', u'ENSMUSG00000038025', u'ENSMUSG00000007670', u'ENSMUSG00000043290', u'ENSMUSG00000032744', u'ENSMUSG00000056260', u'ENSMUSG00000033326', u'ENSMUSG00000026890', u'ENSMUSG00000031079', u'ENSMUSG00000040712', u'ENSMUSG00000040713', u'ENSMUSG00000014592', u'ENSMUSG00000026305', u'ENSMUSG00000029836', u'ENSMUSG00000029832', u'ENSMUSG00000029833', u'ENSMUSG00000057409', u'ENSMUSG00000035868', u'ENSMUSG00000061436', u'ENSMUSG00000023826', u'ENSMUSG00000046532', u'ENSMUSG00000025332', u'ENSMUSG00000022553', u'ENSMUSG00000022556', u'ENSMUSG00000029238', u'ENSMUSG00000034227', u'ENSMUSG00000028634', u'ENSMUSG00000003184', u'ENSMUSG00000042745', u'ENSMUSG00000074643', u'ENSMUSG00000021040', u'ENSMUSG00000035356', u'ENSMUSG00000048485', u'ENSMUSG00000057133', u'ENSMUSG00000028545', u'ENSMUSG00000028549', u'ENSMUSG00000069895', u'ENSMUSG00000045757', u'ENSMUSG00000060397', u'ENSMUSG00000045624', u'ENSMUSG00000028949', u'ENSMUSG00000045991', u'ENSMUSG00000056476', u'ENSMUSG00000020484', u'ENSMUSG00000018604', u'ENSMUSG00000028496', u'ENSMUSG00000020485', u'ENSMUSG00000061544', u'ENSMUSG00000028309', u'ENSMUSG00000024137', u'ENSMUSG00000031728', u'ENSMUSG00000067873', u'ENSMUSG00000007880', u'ENSMUSG00000038909', u'ENSMUSG00000032178', u'ENSMUSG00000020037', u'ENSMUSG00000020038', u'ENSMUSG00000032194', u'ENSMUSG00000036180', u'ENSMUSG00000052942', u'ENSMUSG00000053411', u'ENSMUSG00000044807', u'ENSMUSG00000002617', u'ENSMUSG00000039987', u'ENSMUSG00000054321', u'ENSMUSG00000039989', u'ENSMUSG00000024002', u'ENSMUSG00000037876', u'ENSMUSG00000055817', u'ENSMUSG00000062627', u'ENSMUSG00000032998', u'ENSMUSG00000036698', u'ENSMUSG00000036699', u'ENSMUSG00000054034', u'ENSMUSG00000024642', u'ENSMUSG00000022952', u'ENSMUSG00000040270', u'ENSMUSG00000048249', u'ENSMUSG00000026646', u'ENSMUSG00000033004', u'ENSMUSG00000033006', u'ENSMUSG00000092558', u'ENSMUSG00000066838', u'ENSMUSG00000036450', u'ENSMUSG00000024260', u'ENSMUSG00000055320', u'ENSMUSG00000036459', u'ENSMUSG00000020923', u'ENSMUSG00000000247', u'ENSMUSG00000059325', u'ENSMUSG00000048100', u'ENSMUSG00000030443', u'ENSMUSG00000030446', u'ENSMUSG00000027667', u'ENSMUSG00000026799', u'ENSMUSG00000055491', u'ENSMUSG00000027067', u'ENSMUSG00000051154', u'ENSMUSG00000049295', u'ENSMUSG00000031860', u'ENSMUSG00000019777', u'ENSMUSG00000039501', u'ENSMUSG00000030201', u'ENSMUSG00000039509', u'ENSMUSG00000021217', u'ENSMUSG00000022096', u'ENSMUSG00000071661', u'ENSMUSG00000051579', u'ENSMUSG00000061894', u'ENSMUSG00000003575', u'ENSMUSG00000038056', u'ENSMUSG00000061898', u'ENSMUSG00000022760', u'ENSMUSG00000021180', u'ENSMUSG00000032340', u'ENSMUSG00000021326', u'ENSMUSG00000021327', u'ENSMUSG00000036986', u'ENSMUSG00000036983', u'ENSMUSG00000036980', u'ENSMUSG00000003992', u'ENSMUSG00000009733', u'ENSMUSG00000022306', u'ENSMUSG00000049672', u'ENSMUSG00000006599', u'ENSMUSG00000028800', u'ENSMUSG00000034101', u'ENSMUSG00000017801', u'ENSMUSG00000057236', u'ENSMUSG00000028790', u'ENSMUSG00000069089', u'ENSMUSG00000003198', u'ENSMUSG00000008496', u'ENSMUSG00000025239', u'ENSMUSG00000029221', u'ENSMUSG00000043602', u'ENSMUSG00000046897', u'ENSMUSG00000021038', u'ENSMUSG00000021039', u'ENSMUSG00000048490', u'ENSMUSG00000025782', u'ENSMUSG00000039068', u'ENSMUSG00000002111', u'ENSMUSG00000061393', u'ENSMUSG00000032745', u'ENSMUSG00000025019', u'ENSMUSG00000028150', u'ENSMUSG00000061559', u'ENSMUSG00000038822', u'ENSMUSG00000021144', u'ENSMUSG00000006058', u'ENSMUSG00000046707', u'ENSMUSG00000024122', u'ENSMUSG00000024120', u'ENSMUSG00000042063', u'ENSMUSG00000052798', u'ENSMUSG00000053950', u'ENSMUSG00000007872', u'ENSMUSG00000042390', u'ENSMUSG00000032691', u'ENSMUSG00000002028', u'ENSMUSG00000053552', u'ENSMUSG00000079215', u'ENSMUSG00000022895', u'ENSMUSG00000018565', u'ENSMUSG00000015501', u'ENSMUSG00000036192', u'ENSMUSG00000061371', u'ENSMUSG00000067860', u'ENSMUSG00000039086', u'ENSMUSG00000061374', u'ENSMUSG00000002625', u'ENSMUSG00000053134', u'ENSMUSG00000039089', u'ENSMUSG00000019947', u'ENSMUSG00000001134', u'ENSMUSG00000021848', u'ENSMUSG00000018899', u'ENSMUSG00000013822', u'ENSMUSG00000051817', u'ENSMUSG00000061524', u'ENSMUSG00000039238', u'ENSMUSG00000036686', u'ENSMUSG00000058331', u'ENSMUSG00000044149', u'ENSMUSG00000058440', u'ENSMUSG00000032235', u'ENSMUSG00000017491', u'ENSMUSG00000002249', u'ENSMUSG00000032238', u'ENSMUSG00000024498', u'ENSMUSG00000008136', u'ENSMUSG00000053137', u'ENSMUSG00000037621', u'ENSMUSG00000041515', u'ENSMUSG00000022945', u'ENSMUSG00000057156', u'ENSMUSG00000048251', u'ENSMUSG00000044030', u'ENSMUSG00000001911', u'ENSMUSG00000001910', u'ENSMUSG00000059552', u'ENSMUSG00000033016', u'ENSMUSG00000033014', u'ENSMUSG00000037138', u'ENSMUSG00000036442', u'ENSMUSG00000024271', u'ENSMUSG00000020950', u'ENSMUSG00000037486', u'ENSMUSG00000005583', u'ENSMUSG00000071054', u'ENSMUSG00000072763', u'ENSMUSG00000005566', u'ENSMUSG00000000085', u'ENSMUSG00000027878', u'ENSMUSG00000037001', u'ENSMUSG00000005698', u'ENSMUSG00000026788', u'ENSMUSG00000037007', u'ENSMUSG00000027304', u'ENSMUSG00000030059', u'ENSMUSG00000019768', u'ENSMUSG00000015656', u'ENSMUSG00000060601', u'ENSMUSG00000031870', u'ENSMUSG00000048001', u'ENSMUSG00000030271', u'ENSMUSG00000074406', u'ENSMUSG00000006456', u'ENSMUSG00000055041', u'ENSMUSG00000055044', u'ENSMUSG00000050567', u'ENSMUSG00000031479', u'ENSMUSG00000026436', u'ENSMUSG00000061887', u'ENSMUSG00000026439', u'ENSMUSG00000030801', u'ENSMUSG00000062040', u'ENSMUSG00000031099', u'ENSMUSG00000056537', u'ENSMUSG00000040734', u'ENSMUSG00000040732', u'ENSMUSG00000063804', u'ENSMUSG00000005893', u'ENSMUSG00000022332', u'ENSMUSG00000022335', u'ENSMUSG00000090093', u'ENSMUSG00000022338', u'ENSMUSG00000006586', u'ENSMUSG00000026923', u'ENSMUSG00000044636', u'ENSMUSG00000003032', u'ENSMUSG00000009079', u'ENSMUSG00000075595', u'ENSMUSG00000022441', u'ENSMUSG00000022205', u'ENSMUSG00000028639', u'ENSMUSG00000042724', u'ENSMUSG00000034205', u'ENSMUSG00000025225', u'ENSMUSG00000038214', u'ENSMUSG00000015882', u'ENSMUSG00000074622', u'ENSMUSG00000001228', u'ENSMUSG00000002108', u'ENSMUSG00000029563', u'ENSMUSG00000069184', u'ENSMUSG00000034974', u'ENSMUSG00000025001', u'ENSMUSG00000046179', u'ENSMUSG00000028565', u'ENSMUSG00000046556', u'ENSMUSG00000025316', u'ENSMUSG00000035576', u'ENSMUSG00000025138', u'ENSMUSG00000066613', u'ENSMUSG00000021156', u'ENSMUSG00000042097', u'ENSMUSG00000039275', u'ENSMUSG00000020171', u'ENSMUSG00000028367', u'ENSMUSG00000033933', u'ENSMUSG00000008305', u'ENSMUSG00000021258', u'ENSMUSG00000062861', u'ENSMUSG00000029167', u'ENSMUSG00000035401', u'ENSMUSG00000035158', u'ENSMUSG00000042472', u'ENSMUSG00000002748', u'ENSMUSG00000021546', u'ENSMUSG00000054499', u'ENSMUSG00000024063', u'ENSMUSG00000021540', u'ENSMUSG00000035934', u'ENSMUSG00000021548', u'ENSMUSG00000068742', u'ENSMUSG00000068740', u'ENSMUSG00000049800', u'ENSMUSG00000035686', u'ENSMUSG00000002325', u'ENSMUSG00000017716', u'ENSMUSG00000019971', u'ENSMUSG00000053436', u'ENSMUSG00000001103', u'ENSMUSG00000061186', u'ENSMUSG00000021838', u'ENSMUSG00000031601', u'ENSMUSG00000013833', u'ENSMUSG00000033249', u'ENSMUSG00000002812', u'ENSMUSG00000028483', u'ENSMUSG00000058239', u'ENSMUSG00000032228', u'ENSMUSG00000058230', u'ENSMUSG00000006932', u'ENSMUSG00000021945', u'ENSMUSG00000041075', u'ENSMUSG00000027796', u'ENSMUSG00000079487', u'ENSMUSG00000059540', u'ENSMUSG00000038697', u'ENSMUSG00000024206', u'ENSMUSG00000055305', u'ENSMUSG00000024201', u'ENSMUSG00000000078', u'ENSMUSG00000071064', u'ENSMUSG00000049470', u'ENSMUSG00000030469', u'ENSMUSG00000074220', u'ENSMUSG00000039671', u'ENSMUSG00000033669', u'ENSMUSG00000037017', u'ENSMUSG00000024513', u'ENSMUSG00000030752', u'ENSMUSG00000037013', u'ENSMUSG00000024515', u'ENSMUSG00000027641', u'ENSMUSG00000040651', u'ENSMUSG00000026222', u'ENSMUSG00000027080', u'ENSMUSG00000048012', u'ENSMUSG00000073423', u'ENSMUSG00000031311', u'ENSMUSG00000031314', u'ENSMUSG00000071646', u'ENSMUSG00000005774', u'ENSMUSG00000055053', u'ENSMUSG00000051510', u'ENSMUSG00000011158', u'ENSMUSG00000040033', u'ENSMUSG00000038679', u'ENSMUSG00000030315', u'ENSMUSG00000031229', u'ENSMUSG00000038116', u'ENSMUSG00000056501', u'ENSMUSG00000051223', u'ENSMUSG00000051351', u'ENSMUSG00000029026', u'ENSMUSG00000051355', u'ENSMUSG00000047388', u'ENSMUSG00000018143', u'ENSMUSG00000040725', u'ENSMUSG00000047146', u'ENSMUSG00000047412', u'ENSMUSG00000015092', u'ENSMUSG00000047141', u'ENSMUSG00000049658', u'ENSMUSG00000039410', u'ENSMUSG00000021010', u'ENSMUSG00000026917', u'ENSMUSG00000026918', u'ENSMUSG00000032368', u'ENSMUSG00000025498', u'ENSMUSG00000049728', u'ENSMUSG00000057691', u'ENSMUSG00000025255', u'ENSMUSG00000042712', u'ENSMUSG00000069171', u'ENSMUSG00000029771', u'ENSMUSG00000009406', u'ENSMUSG00000059975', u'ENSMUSG00000028518', u'ENSMUSG00000035960', u'ENSMUSG00000046160', u'ENSMUSG00000046541', u'ENSMUSG00000038845', u'ENSMUSG00000036940', u'ENSMUSG00000085795', u'ENSMUSG00000068823', u'ENSMUSG00000016477', u'ENSMUSG00000020167', u'ENSMUSG00000020166', u'ENSMUSG00000002679', u'ENSMUSG00000020160', u'ENSMUSG00000064043', u'ENSMUSG00000028423', u'ENSMUSG00000028358', u'ENSMUSG00000023990', u'ENSMUSG00000021743', u'ENSMUSG00000052889', u'ENSMUSG00000032329', u'ENSMUSG00000033813', u'ENSMUSG00000035877', u'ENSMUSG00000024079', u'ENSMUSG00000067931', u'ENSMUSG00000015522', u'ENSMUSG00000018501', u'ENSMUSG00000068130', u'ENSMUSG00000068134', u'ENSMUSG00000078619', u'ENSMUSG00000059995', u'ENSMUSG00000018160', u'ENSMUSG00000032035', u'ENSMUSG00000053110', u'ENSMUSG00000054648', u'ENSMUSG00000019961', u'ENSMUSG00000030057', u'ENSMUSG00000018189', u'ENSMUSG00000048385', u'ENSMUSG00000019564', u'ENSMUSG00000027651', u'ENSMUSG00000002266', u'ENSMUSG00000021488', u'ENSMUSG00000030199', u'ENSMUSG00000021485', u'ENSMUSG00000032251', u'ENSMUSG00000036225', u'ENSMUSG00000006920', u'ENSMUSG00000051184', u'ENSMUSG00000093668', u'ENSMUSG00000071076', u'ENSMUSG00000018983', u'ENSMUSG00000015709', u'ENSMUSG00000041390', u'ENSMUSG00000030678', u'ENSMUSG00000024696', u'ENSMUSG00000036550', u'ENSMUSG00000037791', u'ENSMUSG00000024218', u'ENSMUSG00000058318', u'ENSMUSG00000055991', u'ENSMUSG00000001065', u'ENSMUSG00000022855', u'ENSMUSG00000075000', u'ENSMUSG00000030788', u'ENSMUSG00000072294', u'ENSMUSG00000007216', u'ENSMUSG00000004099', u'ENSMUSG00000020994', u'ENSMUSG00000008855', u'ENSMUSG00000037373', u'ENSMUSG00000030079', u'ENSMUSG00000037570', u'ENSMUSG00000027630', u'ENSMUSG00000005148', u'ENSMUSG00000041483', u'ENSMUSG00000038069', u'ENSMUSG00000030527', u'ENSMUSG00000030256', u'ENSMUSG00000021221', u'ENSMUSG00000070709', u'ENSMUSG00000040289', u'ENSMUSG00000026641', u'ENSMUSG00000074519', u'ENSMUSG00000021318', u'ENSMUSG00000029345', u'ENSMUSG00000026349', u'ENSMUSG00000051341', u'ENSMUSG00000029014', u'ENSMUSG00000047407', u'ENSMUSG00000022682', u'ENSMUSG00000079056', u'ENSMUSG00000034701', u'ENSMUSG00000035310', u'ENSMUSG00000011960', u'ENSMUSG00000003308', u'ENSMUSG00000043099', u'ENSMUSG00000025246', u'ENSMUSG00000042705', u'ENSMUSG00000034771', u'ENSMUSG00000072915', u'ENSMUSG00000034278', u'ENSMUSG00000075486', u'ENSMUSG00000015846', u'ENSMUSG00000015843', u'ENSMUSG00000025066', u'ENSMUSG00000029587', u'ENSMUSG00000022463', u'ENSMUSG00000067567', u'ENSMUSG00000046572', u'ENSMUSG00000028163', u'ENSMUSG00000060336', u'ENSMUSG00000036959', u'ENSMUSG00000038872', u'ENSMUSG00000021175']), pop_n=13836, p_sm_bonferroni=1.0, is_obsolete=False, GO='GO:0006355', name='regulation of transcription, DNA-templated', pop_count=1557, alt_ids=['GO:0032583', 'GO:0045449', 'GO:0061019'], level=6, depth=9, enrichment='p', Cluster='Late Increase', geneid_set=set([u'ENSMUSG00000029771', u'ENSMUSG00000061517', u'ENSMUSG00000020715', u'ENSMUSG00000035158', u'ENSMUSG00000030796', u'ENSMUSG00000026923', u'ENSMUSG00000048100', u'ENSMUSG00000031586', u'ENSMUSG00000018654', u'ENSMUSG00000030256', u'ENSMUSG00000002812', u'ENSMUSG00000019803', u'ENSMUSG00000033016', u'ENSMUSG00000034957', u'ENSMUSG00000038393', u'ENSMUSG00000020919', u'ENSMUSG00000028150', u'ENSMUSG00000041235', u'ENSMUSG00000025612', u'ENSMUSG00000004591', u'ENSMUSG00000032035', u'ENSMUSG00000053110', u'ENSMUSG00000051910', u'ENSMUSG00000024420', u'ENSMUSG00000024030', u'ENSMUSG00000039410', u'ENSMUSG00000074622', u'ENSMUSG00000020037', u'ENSMUSG00000030087', u'ENSMUSG00000033713', u'ENSMUSG00000055435', u'ENSMUSG00000026586', u'ENSMUSG00000063506', u'ENSMUSG00000061524', u'ENSMUSG00000052942', u'ENSMUSG00000020467', u'ENSMUSG00000040596', u'ENSMUSG00000032194', u'ENSMUSG00000021318', u'ENSMUSG00000039191', u'ENSMUSG00000027878', u'ENSMUSG00000040713', u'ENSMUSG00000030717', u'ENSMUSG00000043456', u'ENSMUSG00000000567', u'ENSMUSG00000007872', u'ENSMUSG00000062312', u'ENSMUSG00000010461', u'ENSMUSG00000000078', u'ENSMUSG00000026380', u'ENSMUSG00000060601', u'ENSMUSG00000052056', u'ENSMUSG00000002147', u'ENSMUSG00000061436', u'ENSMUSG00000038539', u'ENSMUSG00000004043', u'ENSMUSG00000041390', u'ENSMUSG00000028042', u'ENSMUSG00000002996', u'ENSMUSG00000028163', u'ENSMUSG00000038375', u'ENSMUSG00000020538', u'ENSMUSG00000015839', u'ENSMUSG00000020473', u'ENSMUSG00000024696', u'ENSMUSG00000046160', u'ENSMUSG00000057672', u'ENSMUSG00000048402', u'ENSMUSG00000047407', u'ENSMUSG00000025239', u'ENSMUSG00000021540', u'ENSMUSG00000035686', u'ENSMUSG00000008393', u'ENSMUSG00000034227', u'ENSMUSG00000029003', u'ENSMUSG00000027985', u'ENSMUSG00000003184', u'ENSMUSG00000035873', u'ENSMUSG00000038648', u'ENSMUSG00000015149', u'ENSMUSG00000042745', u'ENSMUSG00000036192', u'ENSMUSG00000021775', u'ENSMUSG00000034101', u'ENSMUSG00000039158', u'ENSMUSG00000062209', u'ENSMUSG00000024063', u'ENSMUSG00000051495', u'ENSMUSG00000048249', u'ENSMUSG00000058638', u'ENSMUSG00000000708', u'ENSMUSG00000029723', u'ENSMUSG00000033006', u'ENSMUSG00000025025', u'ENSMUSG00000029705', u'ENSMUSG00000037621', u'ENSMUSG00000031666', u'ENSMUSG00000025584', u'ENSMUSG00000031665', u'ENSMUSG00000021379', u'ENSMUSG00000027168', u'ENSMUSG00000038679', u'ENSMUSG00000000552', u'ENSMUSG00000036098', u'ENSMUSG00000053007', u'ENSMUSG00000031365', u'ENSMUSG00000032238', u'ENSMUSG00000004044', u'ENSMUSG00000007613', u'ENSMUSG00000021366', u'ENSMUSG00000015776', u'ENSMUSG00000021838', u'ENSMUSG00000020644', u'ENSMUSG00000025902', u'ENSMUSG00000074637', u'ENSMUSG00000038872', u'ENSMUSG00000023990', u'ENSMUSG00000061544']), symbols=u'Abcg1 Aebp1 Akna Arhgap22 Atf5 Atoh8 Bach1 Bhlhe41 Carhsp1 Cebpa Chd7 Creb3l2 Creb5 Crebrf Creg1 Ctnnd1 Cux1 Efemp1 Erbb2 Erbb4 Ern1 Ets1 Eya4 Flii Foxj1 Foxn3 Gli2 Gli3 Glis3 Hbp1 Hipk2 Hivep1 Id1 Id2 Id3 Id4 Ikzf1 Irf2bp2 Irf3 Irf5 Kank2 Kat2b Klf15 Klf6 Lbh Lef1 Limd1 Lpxn Mad2l2 Maf Mafb Mdfic Med22 Mitf Mxi1 Myrf Nfatc1 Nfe2l2 Nfkb1 Notch1 Notch2 Nr1d2 Nr1h2 Nr2e1 Nupr1 Olig1 Pawr Pax6 Pde8a Pkn1 Pkn2 Pogk Prdm16 Prrx1 Ptrf Rbl2 Rbpj Rbpms Rfx4 Rora Rorb Rorc Sall1 Samd4 Sirt2 Smad5 Sox10 Sox17 Sox2 Sox21 Sox6 Sox9 Srebf1 Stat5a Stat5b Stat6 Taf13 Tead2 Tfcp2l1 Tfeb Tgfbr1 Tgif1 Thrsp Trp53inp2 Trps1 Tsc22d4 Txnip Yap1 Zbtb7b Zfhx3 Zfp110 Zfp217 Zfp229 Zfp275 Zfp385a Zfp521 Zfp536 Zic2', symbol_set=set([u'Prdm16', u'Pogk', u'Tsc22d4', u'Cux1', u'Ptrf', u'Nfkb1', u'Nr1d2', u'Tgif1', u'Irf3', u'Irf5', u'Tfeb', u'Sox6', u'Zfhx3', u'Hbp1', u'Creb3l2', u'Klf6', u'Atf5', u'Abcg1', u'Efemp1', u'Mdfic', u'Sox9', u'Nr2e1', u'Sox2', u'Zfp217', u'Erbb2', u'Cebpa', u'Erbb4', u'Zfp110', u'Glis3', u'Stat6', u'Kat2b', u'Irf2bp2', u'Hipk2', u'Stat5a', u'Lbh', u'Mafb', u'Zfp385a', u'Thrsp', u'Zfp275', u'Zbtb7b', u'Pkn1', u'Rbpj', u'Pkn2', u'Yap1', u'Mad2l2', u'Creg1', u'Stat5b', u'Aebp1', u'Hivep1', u'Sox21', u'Nfe2l2', u'Samd4', u'Flii', u'Txnip', u'Limd1', u'Sirt2', u'Lpxn', u'Rfx4', u'Bhlhe41', u'Sox17', u'Trp53inp2', u'Sall1', u'Eya4', u'Olig1', u'Trps1', u'Bach1', 'Crebrf', u'Lef1', u'Klf15', u'Smad5', u'Nupr1', u'Zfp536', u'Notch1', u'Notch2', u'Tead2', u'Nr1h2', u'Nfatc1', u'Foxj1', u'Rorc', u'Rorb', u'Rora', u'Tfcp2l1', u'Taf13', u'Mitf', u'Pax6', u'Prrx1', 'Myrf', u'Akna', u'Zfp521', u'Creb5', u'Sox10', u'Srebf1', u'Ikzf1', u'Ern1', u'Id4', u'Id2', u'Id3', u'Id1', u'Ctnnd1', u'Zfp229', u'Mxi1', u'Rbpms', u'Maf', u'Atoh8', u'Carhsp1', u'Tgfbr1', u'Rbl2', u'Med22', u'Kank2', u'Chd7', u'Arhgap22', u'Gli2', u'Gli3', u'Ets1', u'Zic2', u'Pawr', u'Pde8a', u'Foxn3']), geneids='ENSMUSG00000061517 ENSMUSG00000035158 ENSMUSG00000048100 ENSMUSG00000031586 ENSMUSG00000002812 ENSMUSG00000033016 ENSMUSG00000034957 ENSMUSG00000038393 ENSMUSG00000025612 ENSMUSG00000004591 ENSMUSG00000032035 ENSMUSG00000053110 ENSMUSG00000062312 ENSMUSG00000051910 ENSMUSG00000052942 ENSMUSG00000033713 ENSMUSG00000063506 ENSMUSG00000061524 ENSMUSG00000029723 ENSMUSG00000027878 ENSMUSG00000040713 ENSMUSG00000000567 ENSMUSG00000007872 ENSMUSG00000000078 ENSMUSG00000026380 ENSMUSG00000060601 ENSMUSG00000052056 ENSMUSG00000002147 ENSMUSG00000061436 ENSMUSG00000038539 ENSMUSG00000041390 ENSMUSG00000020538 ENSMUSG00000015839 ENSMUSG00000024696 ENSMUSG00000043456 ENSMUSG00000048402 ENSMUSG00000047407 ENSMUSG00000051495 ENSMUSG00000035686 ENSMUSG00000034227 ENSMUSG00000003184 ENSMUSG00000015149 ENSMUSG00000042745 ENSMUSG00000021775 ENSMUSG00000034101 ENSMUSG00000062209 ENSMUSG00000000708 ENSMUSG00000025025 ENSMUSG00000029705 ENSMUSG00000025239 ENSMUSG00000036098 ENSMUSG00000053007 ENSMUSG00000031365 ENSMUSG00000007613 ENSMUSG00000015776 ENSMUSG00000020644 ENSMUSG00000074637 ENSMUSG00000038679 ENSMUSG00000061544 ENSMUSG00000026923 ENSMUSG00000020715 ENSMUSG00000030796 ENSMUSG00000030256 ENSMUSG00000020919 ENSMUSG00000028150 ENSMUSG00000041235 ENSMUSG00000019803 ENSMUSG00000024420 ENSMUSG00000024030 ENSMUSG00000039410 ENSMUSG00000074622 ENSMUSG00000020037 ENSMUSG00000030087 ENSMUSG00000055435 ENSMUSG00000026586 ENSMUSG00000020467 ENSMUSG00000040596 ENSMUSG00000032194 ENSMUSG00000021318 ENSMUSG00000039191 ENSMUSG00000030717 ENSMUSG00000010461 ENSMUSG00000002996 ENSMUSG00000008393 ENSMUSG00000029771 ENSMUSG00000028042 ENSMUSG00000032238 ENSMUSG00000038375 ENSMUSG00000021366 ENSMUSG00000020473 ENSMUSG00000046160 ENSMUSG00000036192 ENSMUSG00000035873 ENSMUSG00000029003 ENSMUSG00000027985 ENSMUSG00000018654 ENSMUSG00000038648 ENSMUSG00000057672 ENSMUSG00000039158 ENSMUSG00000024063 ENSMUSG00000021540 ENSMUSG00000048249 ENSMUSG00000058638 ENSMUSG00000033006 ENSMUSG00000031666 ENSMUSG00000025584 ENSMUSG00000031665 ENSMUSG00000021379 ENSMUSG00000027168 ENSMUSG00000023990 ENSMUSG00000000552 ENSMUSG00000004043 ENSMUSG00000028163 ENSMUSG00000004044 ENSMUSG00000025902 ENSMUSG00000037621 ENSMUSG00000038872 ENSMUSG00000021838', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=499, D1='A', GO_name='regulation of transcription, DNA-templated'),
    Nt(p_uncorrected=0.00044925982953889274, study_count=5, study_n=1397, namespace='biological_process', p_fdr_bh=0.03781519820746535, study_items=set([u'ENSMUSG00000037706', u'ENSMUSG00000039031', u'ENSMUSG00000053158', u'ENSMUSG00000004591', u'ENSMUSG00000057672']), NS='BP', pop_items=set([u'ENSMUSG00000039031', u'ENSMUSG00000053158', u'ENSMUSG00000042105', u'ENSMUSG00000004591', u'ENSMUSG00000038034', u'ENSMUSG00000036825', u'ENSMUSG00000037706', u'ENSMUSG00000057672']), pop_n=13836, p_sm_bonferroni=1.0, is_obsolete=False, GO='GO:2000145', name='regulation of cell motility', pop_count=8, alt_ids=[], level=4, depth=5, enrichment='e', Cluster='Late Increase', geneid_set=set([u'ENSMUSG00000037706', u'ENSMUSG00000039031', u'ENSMUSG00000053158', u'ENSMUSG00000004591', u'ENSMUSG00000057672']), symbols=u'Arhgap18 Cd81 Fes Pkn1 Pkn2', symbol_set=set([u'Cd81', u'Pkn1', u'Pkn2', u'Fes', u'Arhgap18']), geneids='ENSMUSG00000037706 ENSMUSG00000039031 ENSMUSG00000053158 ENSMUSG00000004591 ENSMUSG00000057672', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=228, D1='A', GO_name='regulation of cell motility'),
    Nt(p_uncorrected=0.00019073476594294486, study_count=7, study_n=1397, namespace='biological_process', p_fdr_bh=0.019011989728957616, study_items=set([u'ENSMUSG00000024529', u'ENSMUSG00000041423', u'ENSMUSG00000057329', u'ENSMUSG00000022150', u'ENSMUSG00000025931', u'ENSMUSG00000029304', u'ENSMUSG00000032278']), NS='BP', pop_items=set([u'ENSMUSG00000024529', u'ENSMUSG00000054717', u'ENSMUSG00000025950', u'ENSMUSG00000041423', u'ENSMUSG00000064225', u'ENSMUSG00000057329', u'ENSMUSG00000022150', u'ENSMUSG00000025931', u'ENSMUSG00000037348', u'ENSMUSG00000029304', u'ENSMUSG00000025246', u'ENSMUSG00000032278', u'ENSMUSG00000049112', u'ENSMUSG00000050541']), pop_n=13836, p_sm_bonferroni=1.0, is_obsolete=False, GO='GO:0048545', name='response to steroid hormone', pop_count=14, alt_ids=[], level=4, depth=5, enrichment='e', Cluster='Late Increase', geneid_set=set([u'ENSMUSG00000029304', u'ENSMUSG00000032278', u'ENSMUSG00000024529', u'ENSMUSG00000041423', u'ENSMUSG00000057329', u'ENSMUSG00000022150', u'ENSMUSG00000025931']), symbols=u'Bcl2 Dab2 Lox Paqr5 Paqr6 Paqr8 Spp1', symbol_set=set([u'Paqr8', u'Paqr5', u'Paqr6', u'Spp1', u'Dab2', u'Lox', u'Bcl2']), geneids='ENSMUSG00000024529 ENSMUSG00000041423 ENSMUSG00000057329 ENSMUSG00000022150 ENSMUSG00000025931 ENSMUSG00000029304 ENSMUSG00000032278', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=23, D1='F', GO_name='response to steroid hormone'),
    Nt(p_uncorrected=9.982446557349308e-07, study_count=5, study_n=1397, namespace='biological_process', p_fdr_bh=0.00030866132202122317, study_items=set([u'ENSMUSG00000031666', u'ENSMUSG00000010461', u'ENSMUSG00000041235', u'ENSMUSG00000018654', u'ENSMUSG00000057672']), NS='BP', pop_items=set([u'ENSMUSG00000040363', u'ENSMUSG00000039089', u'ENSMUSG00000000902', u'ENSMUSG00000039086', u'ENSMUSG00000023927', u'ENSMUSG00000042599', u'ENSMUSG00000020694', u'ENSMUSG00000030752', u'ENSMUSG00000018501', u'ENSMUSG00000029475', u'ENSMUSG00000026313', u'ENSMUSG00000022475', u'ENSMUSG00000003778', u'ENSMUSG00000056608', u'ENSMUSG00000025616', u'ENSMUSG00000040007', u'ENSMUSG00000053754', u'ENSMUSG00000031386', u'ENSMUSG00000036940', u'ENSMUSG00000031358', u'ENSMUSG00000017548', u'ENSMUSG00000029920', u'ENSMUSG00000028886', u'ENSMUSG00000004698', u'ENSMUSG00000063870', u'ENSMUSG00000019777', u'ENSMUSG00000035234', u'ENSMUSG00000038025', u'ENSMUSG00000057406', u'ENSMUSG00000022394', u'ENSMUSG00000039231', u'ENSMUSG00000024283', u'ENSMUSG00000029687', u'ENSMUSG00000025316', u'ENSMUSG00000003868', u'ENSMUSG00000039473', u'ENSMUSG00000021488', u'ENSMUSG00000005566', u'ENSMUSG00000029279', u'ENSMUSG00000005045', u'ENSMUSG00000038518', u'ENSMUSG00000052915', u'ENSMUSG00000031575', u'ENSMUSG00000008855', u'ENSMUSG00000030619', u'ENSMUSG00000056770', u'ENSMUSG00000005698', u'ENSMUSG00000029836', u'ENSMUSG00000042506', u'ENSMUSG00000024201', u'ENSMUSG00000002307', u'ENSMUSG00000037896', u'ENSMUSG00000006920', u'ENSMUSG00000025578', u'ENSMUSG00000019857', u'ENSMUSG00000070697', u'ENSMUSG00000021767', u'ENSMUSG00000032187', u'ENSMUSG00000025932', u'ENSMUSG00000038331', u'ENSMUSG00000006307', u'ENSMUSG00000031161', u'ENSMUSG00000069495', u'ENSMUSG00000032481', u'ENSMUSG00000025138', u'ENSMUSG00000066900', u'ENSMUSG00000022992', u'ENSMUSG00000031715', u'ENSMUSG00000025332', u'ENSMUSG00000034832', u'ENSMUSG00000034639', u'ENSMUSG00000023018', u'ENSMUSG00000041096', u'ENSMUSG00000027641', u'ENSMUSG00000058318', u'ENSMUSG00000053914', u'ENSMUSG00000024193', u'ENSMUSG00000078671', u'ENSMUSG00000028800', u'ENSMUSG00000022019', u'ENSMUSG00000026439', u'ENSMUSG00000057133', u'ENSMUSG00000049300', u'ENSMUSG00000054611', u'ENSMUSG00000057236', u'ENSMUSG00000031099', u'ENSMUSG00000038056', u'ENSMUSG00000042323', u'ENSMUSG00000029703', u'ENSMUSG00000004099', u'ENSMUSG00000015937', u'ENSMUSG00000028397', u'ENSMUSG00000031353', u'ENSMUSG00000030079', u'ENSMUSG00000028949', u'ENSMUSG00000030816', u'ENSMUSG00000053483', u'ENSMUSG00000059995', u'ENSMUSG00000024789', u'ENSMUSG00000027630', u'ENSMUSG00000030180', u'ENSMUSG00000025577', u'ENSMUSG00000060098', u'ENSMUSG00000063049', u'ENSMUSG00000024002', u'ENSMUSG00000024454', u'ENSMUSG00000022338', u'ENSMUSG00000018476', u'ENSMUSG00000005378', u'ENSMUSG00000059851', u'ENSMUSG00000026603', u'ENSMUSG00000028309', u'ENSMUSG00000024335', u'ENSMUSG00000034160', u'ENSMUSG00000031229', u'ENSMUSG00000038116', u'ENSMUSG00000040325', u'ENSMUSG00000037369', u'ENSMUSG00000050697', u'ENSMUSG00000032185', u'ENSMUSG00000023110', u'ENSMUSG00000046791', u'ENSMUSG00000021221', u'ENSMUSG00000040943', u'ENSMUSG00000026283', u'ENSMUSG00000035401', u'ENSMUSG00000007880', u'ENSMUSG00000038909', u'ENSMUSG00000041235', u'ENSMUSG00000031820', u'ENSMUSG00000028863', u'ENSMUSG00000032376', u'ENSMUSG00000047146', u'ENSMUSG00000030888', u'ENSMUSG00000034205', u'ENSMUSG00000005982', u'ENSMUSG00000021901', u'ENSMUSG00000038214', u'ENSMUSG00000053411', u'ENSMUSG00000030801', u'ENSMUSG00000020232', u'ENSMUSG00000026917', u'ENSMUSG00000014074', u'ENSMUSG00000059474', u'ENSMUSG00000045482', u'ENSMUSG00000026918', u'ENSMUSG00000049327', u'ENSMUSG00000090083', u'ENSMUSG00000015697', u'ENSMUSG00000006527', u'ENSMUSG00000034974', u'ENSMUSG00000025369', u'ENSMUSG00000062906', u'ENSMUSG00000008958', u'ENSMUSG00000030714', u'ENSMUSG00000024240', u'ENSMUSG00000031540', u'ENSMUSG00000040054', u'ENSMUSG00000024325', u'ENSMUSG00000042548', u'ENSMUSG00000031422', u'ENSMUSG00000066456', u'ENSMUSG00000029014', u'ENSMUSG00000035576', u'ENSMUSG00000029670', u'ENSMUSG00000002028', u'ENSMUSG00000024431', u'ENSMUSG00000020661', u'ENSMUSG00000021156', u'ENSMUSG00000078619', u'ENSMUSG00000039989', u'ENSMUSG00000037935', u'ENSMUSG00000021395', u'ENSMUSG00000037876', u'ENSMUSG00000030232', u'ENSMUSG00000020171', u'ENSMUSG00000047777', u'ENSMUSG00000022702', u'ENSMUSG00000035469', u'ENSMUSG00000057649', u'ENSMUSG00000038080', u'ENSMUSG00000024392', u'ENSMUSG00000030330', u'ENSMUSG00000062627', u'ENSMUSG00000025878', u'ENSMUSG00000027569', u'ENSMUSG00000031201', u'ENSMUSG00000033326', u'ENSMUSG00000028518', u'ENSMUSG00000026739', u'ENSMUSG00000029267', u'ENSMUSG00000071350', u'ENSMUSG00000057672', u'ENSMUSG00000024926', u'ENSMUSG00000018412', u'ENSMUSG00000034245', u'ENSMUSG00000013787', u'ENSMUSG00000029004', u'ENSMUSG00000018654', u'ENSMUSG00000010453', u'ENSMUSG00000034674', u'ENSMUSG00000037570', u'ENSMUSG00000020086', u'ENSMUSG00000044791', u'ENSMUSG00000062270', u'ENSMUSG00000037111', u'ENSMUSG00000002428', u'ENSMUSG00000029712', u'ENSMUSG00000089715', u'ENSMUSG00000024067', u'ENSMUSG00000054823', u'ENSMUSG00000029505', u'ENSMUSG00000028053', u'ENSMUSG00000045098', u'ENSMUSG00000090115', u'ENSMUSG00000026646', u'ENSMUSG00000031458', u'ENSMUSG00000021377', u'ENSMUSG00000009640', u'ENSMUSG00000026873', u'ENSMUSG00000042207', u'ENSMUSG00000024947', u'ENSMUSG00000032329', u'ENSMUSG00000031666', u'ENSMUSG00000055067', u'ENSMUSG00000036893', u'ENSMUSG00000048154', u'ENSMUSG00000037032', u'ENSMUSG00000001228', u'ENSMUSG00000027671', u'ENSMUSG00000005470', u'ENSMUSG00000067567', u'ENSMUSG00000038384', u'ENSMUSG00000056962', u'ENSMUSG00000038773', u'ENSMUSG00000029913', u'ENSMUSG00000052139', u'ENSMUSG00000010461', u'ENSMUSG00000049502', u'ENSMUSG00000041997', u'ENSMUSG00000036959', u'ENSMUSG00000022105', u'ENSMUSG00000053470', u'ENSMUSG00000052889', u'ENSMUSG00000015749']), pop_n=13836, p_sm_bonferroni=0.015124404779039936, is_obsolete=False, GO='GO:0016569', name='covalent chromatin modification', pop_count=245, alt_ids=[], level=5, depth=5, enrichment='p', Cluster='Late Increase', geneid_set=set([u'ENSMUSG00000031666', u'ENSMUSG00000010461', u'ENSMUSG00000041235', u'ENSMUSG00000018654', u'ENSMUSG00000057672']), symbols=u'Chd7 Eya4 Ikzf1 Pkn1 Rbl2', symbol_set=set([u'Pkn1', u'Eya4', u'Ikzf1', u'Chd7', u'Rbl2']), geneids='ENSMUSG00000010461 ENSMUSG00000031666 ENSMUSG00000041235 ENSMUSG00000018654 ENSMUSG00000057672', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=116, D1='BDH', GO_name='covalent chromatin modification'),
    Nt(p_uncorrected=8.308107797170725e-10, study_count=36, study_n=1397, namespace='biological_process', p_fdr_bh=5.47287570586668e-07, study_items=set([u'ENSMUSG00000028223', u'ENSMUSG00000033174', u'ENSMUSG00000024978', u'ENSMUSG00000032883', u'ENSMUSG00000033579', u'ENSMUSG00000032540', u'ENSMUSG00000020919', u'ENSMUSG00000026457', u'ENSMUSG00000026003', u'ENSMUSG00000025203', u'ENSMUSG00000027984', u'ENSMUSG00000059447', u'ENSMUSG00000031903', u'ENSMUSG00000029925', u'ENSMUSG00000032281', u'ENSMUSG00000003623', u'ENSMUSG00000035376', u'ENSMUSG00000024665', u'ENSMUSG00000020777', u'ENSMUSG00000076435', u'ENSMUSG00000024164', u'ENSMUSG00000030168', u'ENSMUSG00000034853', u'ENSMUSG00000029919', u'ENSMUSG00000024781', u'ENSMUSG00000024900', u'ENSMUSG00000018574', u'ENSMUSG00000006390', u'ENSMUSG00000032349', u'ENSMUSG00000042010', u'ENSMUSG00000004043', u'ENSMUSG00000044788', u'ENSMUSG00000020097', u'ENSMUSG00000028497', u'ENSMUSG00000020333', u'ENSMUSG00000038633']), NS='BP', pop_items=set([u'ENSMUSG00000029513', u'ENSMUSG00000074064', u'ENSMUSG00000028223', u'ENSMUSG00000029059', u'ENSMUSG00000024978', u'ENSMUSG00000036880', u'ENSMUSG00000032540', u'ENSMUSG00000026003', u'ENSMUSG00000025465', u'ENSMUSG00000021947', u'ENSMUSG00000031903', u'ENSMUSG00000029925', u'ENSMUSG00000024664', u'ENSMUSG00000020892', u'ENSMUSG00000027412', u'ENSMUSG00000024164', u'ENSMUSG00000031278', u'ENSMUSG00000030168', u'ENSMUSG00000021696', u'ENSMUSG00000033327', u'ENSMUSG00000010651', u'ENSMUSG00000006390', u'ENSMUSG00000007783', u'ENSMUSG00000036138', u'ENSMUSG00000071072', u'ENSMUSG00000026820', u'ENSMUSG00000022383', u'ENSMUSG00000032487', u'ENSMUSG00000024052', u'ENSMUSG00000033174', u'ENSMUSG00000048755', u'ENSMUSG00000020532', u'ENSMUSG00000031641', u'ENSMUSG00000031808', u'ENSMUSG00000036257', u'ENSMUSG00000025203', u'ENSMUSG00000022853', u'ENSMUSG00000067653', u'ENSMUSG00000030861', u'ENSMUSG00000021606', u'ENSMUSG00000002661', u'ENSMUSG00000030869', u'ENSMUSG00000029545', u'ENSMUSG00000032807', u'ENSMUSG00000037071', u'ENSMUSG00000034853', u'ENSMUSG00000031708', u'ENSMUSG00000024900', u'ENSMUSG00000024507', u'ENSMUSG00000028944', u'ENSMUSG00000028497', u'ENSMUSG00000015016', u'ENSMUSG00000024132', u'ENSMUSG00000027932', u'ENSMUSG00000036775', u'ENSMUSG00000050697', u'ENSMUSG00000029098', u'ENSMUSG00000021226', u'ENSMUSG00000025153', u'ENSMUSG00000032883', u'ENSMUSG00000033579', u'ENSMUSG00000020919', u'ENSMUSG00000026457', u'ENSMUSG00000010663', u'ENSMUSG00000047250', u'ENSMUSG00000059447', u'ENSMUSG00000024981', u'ENSMUSG00000032262', u'ENSMUSG00000015090', u'ENSMUSG00000035376', u'ENSMUSG00000017146', u'ENSMUSG00000076435', u'ENSMUSG00000053898', u'ENSMUSG00000038205', u'ENSMUSG00000055923', u'ENSMUSG00000026853', u'ENSMUSG00000062908', u'ENSMUSG00000018796', u'ENSMUSG00000028145', u'ENSMUSG00000025889', u'ENSMUSG00000032349', u'ENSMUSG00000031545', u'ENSMUSG00000042010', u'ENSMUSG00000041220', u'ENSMUSG00000024665', u'ENSMUSG00000002997', u'ENSMUSG00000003623', u'ENSMUSG00000020333', u'ENSMUSG00000033629', u'ENSMUSG00000021364', u'ENSMUSG00000028518', u'ENSMUSG00000031613', u'ENSMUSG00000050737', u'ENSMUSG00000055737', u'ENSMUSG00000029482', u'ENSMUSG00000028910', u'ENSMUSG00000028670', u'ENSMUSG00000027984', u'ENSMUSG00000024646', u'ENSMUSG00000020777', u'ENSMUSG00000032281', u'ENSMUSG00000027359', u'ENSMUSG00000059316', u'ENSMUSG00000055866', u'ENSMUSG00000063275', u'ENSMUSG00000067713', u'ENSMUSG00000024781', u'ENSMUSG00000018574', u'ENSMUSG00000028607', u'ENSMUSG00000029919', u'ENSMUSG00000028601', u'ENSMUSG00000004043', u'ENSMUSG00000038633', u'ENSMUSG00000020097', u'ENSMUSG00000043487', u'ENSMUSG00000025745', u'ENSMUSG00000021786', u'ENSMUSG00000025903', u'ENSMUSG00000044788']), pop_n=13836, p_sm_bonferroni=1.2587614123493365e-05, is_obsolete=False, GO='GO:0006631', name='fatty acid metabolic process', pop_count=119, alt_ids=[], level=4, depth=8, enrichment='e', Cluster='Late Increase', geneid_set=set([u'ENSMUSG00000028223', u'ENSMUSG00000033174', u'ENSMUSG00000024978', u'ENSMUSG00000032883', u'ENSMUSG00000033579', u'ENSMUSG00000032540', u'ENSMUSG00000020919', u'ENSMUSG00000026457', u'ENSMUSG00000026003', u'ENSMUSG00000025203', u'ENSMUSG00000027984', u'ENSMUSG00000059447', u'ENSMUSG00000031903', u'ENSMUSG00000029925', u'ENSMUSG00000032281', u'ENSMUSG00000028497', u'ENSMUSG00000035376', u'ENSMUSG00000024665', u'ENSMUSG00000020777', u'ENSMUSG00000076435', u'ENSMUSG00000024164', u'ENSMUSG00000030168', u'ENSMUSG00000034853', u'ENSMUSG00000006390', u'ENSMUSG00000024781', u'ENSMUSG00000024900', u'ENSMUSG00000018574', u'ENSMUSG00000029919', u'ENSMUSG00000032349', u'ENSMUSG00000042010', u'ENSMUSG00000004043', u'ENSMUSG00000038633', u'ENSMUSG00000020097', u'ENSMUSG00000003623', u'ENSMUSG00000020333', u'ENSMUSG00000044788']), symbols=u'Abhd5 Acacb Acadl Acadvl Acot11 Acox1 Acsbg1 Acsf2 Acsl3 Acsl6 Adipor1 Adipor2 C3 Cpt1a Crot Decr1 Degs1 Elovl1 Elovl5 Fa2h Fads2 Fads6 Gpam Hacd2 Hacd4 Hadh Hadhb Hpgds Lipa Mgll Pla2g15 Scd2 Sgpl1 Stat5a Stat5b Tbxas1', symbol_set=set([u'Hadh', u'Degs1', u'Scd2', u'Acsl3', u'Acox1', u'Acsl6', 'Hacd2', u'Acsbg1', u'Acadl', 'Hacd4', u'Cpt1a', u'Acadvl', u'Hadhb', u'Acacb', u'C3', u'Fads2', u'Fads6', u'Pla2g15', u'Sgpl1', u'Gpam', u'Adipor2', u'Tbxas1', u'Adipor1', u'Acot11', u'Decr1', u'Hpgds', u'Lipa', u'Acsf2', u'Mgll', u'Fa2h', u'Stat5b', u'Stat5a', u'Elovl5', u'Elovl1', u'Crot', u'Abhd5']), geneids='ENSMUSG00000028223 ENSMUSG00000033174 ENSMUSG00000024978 ENSMUSG00000032883 ENSMUSG00000033579 ENSMUSG00000032540 ENSMUSG00000020919 ENSMUSG00000026457 ENSMUSG00000026003 ENSMUSG00000025203 ENSMUSG00000027984 ENSMUSG00000059447 ENSMUSG00000031903 ENSMUSG00000020777 ENSMUSG00000032281 ENSMUSG00000003623 ENSMUSG00000035376 ENSMUSG00000024665 ENSMUSG00000029925 ENSMUSG00000076435 ENSMUSG00000024164 ENSMUSG00000030168 ENSMUSG00000034853 ENSMUSG00000029919 ENSMUSG00000024781 ENSMUSG00000024900 ENSMUSG00000018574 ENSMUSG00000006390 ENSMUSG00000032349 ENSMUSG00000042010 ENSMUSG00000004043 ENSMUSG00000044788 ENSMUSG00000020097 ENSMUSG00000028497 ENSMUSG00000020333 ENSMUSG00000038633', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=118, D1='BCD', GO_name='fatty acid metabolic process'),
    Nt(p_uncorrected=1.7619092326657575e-05, study_count=59, study_n=1397, namespace='biological_process', p_fdr_bh=0.0029660763093465434, study_items=set([u'ENSMUSG00000062031', u'ENSMUSG00000001891', u'ENSMUSG00000020715', u'ENSMUSG00000018574', u'ENSMUSG00000013584', u'ENSMUSG00000053279', u'ENSMUSG00000020231', u'ENSMUSG00000033705', u'ENSMUSG00000022781', u'ENSMUSG00000026922', u'ENSMUSG00000029455', u'ENSMUSG00000023961', u'ENSMUSG00000053965', u'ENSMUSG00000062646', u'ENSMUSG00000026200', u'ENSMUSG00000032883', u'ENSMUSG00000010051', u'ENSMUSG00000021592', u'ENSMUSG00000053398', u'ENSMUSG00000054545', u'ENSMUSG00000053644', u'ENSMUSG00000042251', u'ENSMUSG00000069516', u'ENSMUSG00000059447', u'ENSMUSG00000020777', u'ENSMUSG00000020774', u'ENSMUSG00000032281', u'ENSMUSG00000022253', u'ENSMUSG00000038173', u'ENSMUSG00000021417', u'ENSMUSG00000061838', u'ENSMUSG00000023921', u'ENSMUSG00000026701', u'ENSMUSG00000030272', u'ENSMUSG00000020766', u'ENSMUSG00000021238', u'ENSMUSG00000029446', u'ENSMUSG00000026956', u'ENSMUSG00000056536', u'ENSMUSG00000024899', u'ENSMUSG00000037370', u'ENSMUSG00000028603', u'ENSMUSG00000021069', u'ENSMUSG00000033540', u'ENSMUSG00000042010', u'ENSMUSG00000001773', u'ENSMUSG00000024978', u'ENSMUSG00000028164', u'ENSMUSG00000034707', u'ENSMUSG00000033059', u'ENSMUSG00000022842', u'ENSMUSG00000043943', u'ENSMUSG00000022453', u'ENSMUSG00000026003', u'ENSMUSG00000027452', u'ENSMUSG00000020333', u'ENSMUSG00000076435', u'ENSMUSG00000036833', u'ENSMUSG00000035948']), NS='BP', pop_items=set([u'ENSMUSG00000027971', u'ENSMUSG00000021665', u'ENSMUSG00000023262', u'ENSMUSG00000031266', u'ENSMUSG00000034000', u'ENSMUSG00000027977', u'ENSMUSG00000029695', u'ENSMUSG00000028189', u'ENSMUSG00000039145', u'ENSMUSG00000023921', u'ENSMUSG00000030826', u'ENSMUSG00000040482', u'ENSMUSG00000022040', u'ENSMUSG00000001891', u'ENSMUSG00000010025', u'ENSMUSG00000029455', u'ENSMUSG00000027384', u'ENSMUSG00000018509', u'ENSMUSG00000029591', u'ENSMUSG00000020456', u'ENSMUSG00000029780', u'ENSMUSG00000016918', u'ENSMUSG00000024978', u'ENSMUSG00000038422', u'ENSMUSG00000036880', u'ENSMUSG00000022477', u'ENSMUSG00000032786', u'ENSMUSG00000004383', u'ENSMUSG00000022471', u'ENSMUSG00000027088', u'ENSMUSG00000026003', u'ENSMUSG00000063730', u'ENSMUSG00000025465', u'ENSMUSG00000001211', u'ENSMUSG00000002550', u'ENSMUSG00000026005', u'ENSMUSG00000035239', u'ENSMUSG00000020604', u'ENSMUSG00000038028', u'ENSMUSG00000036875', u'ENSMUSG00000021069', u'ENSMUSG00000011752', u'ENSMUSG00000021417', u'ENSMUSG00000046598', u'ENSMUSG00000027371', u'ENSMUSG00000025509', u'ENSMUSG00000003865', u'ENSMUSG00000015027', u'ENSMUSG00000086784', u'ENSMUSG00000026701', u'ENSMUSG00000022110', u'ENSMUSG00000031278', u'ENSMUSG00000025534', u'ENSMUSG00000020277', u'ENSMUSG00000028232', u'ENSMUSG00000059316', u'ENSMUSG00000005378', u'ENSMUSG00000028032', u'ENSMUSG00000028405', u'ENSMUSG00000021196', u'ENSMUSG00000018574', u'ENSMUSG00000059288', u'ENSMUSG00000026956', u'ENSMUSG00000038886', u'ENSMUSG00000016179', u'ENSMUSG00000023832', u'ENSMUSG00000033065', u'ENSMUSG00000004035', u'ENSMUSG00000006800', u'ENSMUSG00000052353', u'ENSMUSG00000010651', u'ENSMUSG00000001773', u'ENSMUSG00000035948', u'ENSMUSG00000029119', u'ENSMUSG00000027710', u'ENSMUSG00000021957', u'ENSMUSG00000022842', u'ENSMUSG00000043943', u'ENSMUSG00000035637', u'ENSMUSG00000022253', u'ENSMUSG00000007833', u'ENSMUSG00000003575', u'ENSMUSG00000036138', u'ENSMUSG00000026623', u'ENSMUSG00000054008', u'ENSMUSG00000046312', u'ENSMUSG00000019850', u'ENSMUSG00000023961', u'ENSMUSG00000026694', u'ENSMUSG00000062031', u'ENSMUSG00000024892', u'ENSMUSG00000023960', u'ENSMUSG00000033703', u'ENSMUSG00000013584', u'ENSMUSG00000030272', u'ENSMUSG00000033705', u'ENSMUSG00000027875', u'ENSMUSG00000022781', u'ENSMUSG00000041939', u'ENSMUSG00000054659', u'ENSMUSG00000020256', u'ENSMUSG00000025885', u'ENSMUSG00000036412', u'ENSMUSG00000028601', u'ENSMUSG00000004565', u'ENSMUSG00000020532', u'ENSMUSG00000031562', u'ENSMUSG00000035847', u'ENSMUSG00000022620', u'ENSMUSG00000021460', u'ENSMUSG00000035936', u'ENSMUSG00000026335', u'ENSMUSG00000031808', u'ENSMUSG00000031467', u'ENSMUSG00000028885', u'ENSMUSG00000025041', u'ENSMUSG00000054469', u'ENSMUSG00000030970', u'ENSMUSG00000024601', u'ENSMUSG00000032648', u'ENSMUSG00000022853', u'ENSMUSG00000021048', u'ENSMUSG00000025153', u'ENSMUSG00000030861', u'ENSMUSG00000021608', u'ENSMUSG00000019810', u'ENSMUSG00000031969', u'ENSMUSG00000000168', u'ENSMUSG00000089917', u'ENSMUSG00000074264', u'ENSMUSG00000042010', u'ENSMUSG00000030268', u'ENSMUSG00000008763', u'ENSMUSG00000024644', u'ENSMUSG00000029545', u'ENSMUSG00000004789', u'ENSMUSG00000021238', u'ENSMUSG00000004099', u'ENSMUSG00000090150', u'ENSMUSG00000075270', u'ENSMUSG00000002963', u'ENSMUSG00000031583', u'ENSMUSG00000005667', u'ENSMUSG00000037373', u'ENSMUSG00000037370', u'ENSMUSG00000028393', u'ENSMUSG00000041718', u'ENSMUSG00000043445', u'ENSMUSG00000032281', u'ENSMUSG00000031299', u'ENSMUSG00000027639', u'ENSMUSG00000029201', u'ENSMUSG00000053644', u'ENSMUSG00000040820', u'ENSMUSG00000005142', u'ENSMUSG00000058488', u'ENSMUSG00000021748', u'ENSMUSG00000032294', u'ENSMUSG00000052605', u'ENSMUSG00000045594', u'ENSMUSG00000021036', u'ENSMUSG00000025068', u'ENSMUSG00000041653', u'ENSMUSG00000027605', u'ENSMUSG00000021033', u'ENSMUSG00000047454', u'ENSMUSG00000010914', u'ENSMUSG00000026922', u'ENSMUSG00000020715', u'ENSMUSG00000026615', u'ENSMUSG00000033857', u'ENSMUSG00000015016', u'ENSMUSG00000024132', u'ENSMUSG00000019883', u'ENSMUSG00000056536', u'ENSMUSG00000027932', u'ENSMUSG00000028479', u'ENSMUSG00000046561', u'ENSMUSG00000026192', u'ENSMUSG00000028467', u'ENSMUSG00000029098', u'ENSMUSG00000028737', u'ENSMUSG00000050211', u'ENSMUSG00000053965', u'ENSMUSG00000037049', u'ENSMUSG00000062646', u'ENSMUSG00000039308', u'ENSMUSG00000032883', u'ENSMUSG00000036086', u'ENSMUSG00000021592', u'ENSMUSG00000025270', u'ENSMUSG00000053398', u'ENSMUSG00000027134', u'ENSMUSG00000042642', u'ENSMUSG00000029456', u'ENSMUSG00000071650', u'ENSMUSG00000025899', u'ENSMUSG00000059447', u'ENSMUSG00000029063', u'ENSMUSG00000027332', u'ENSMUSG00000025220', u'ENSMUSG00000031781', u'ENSMUSG00000022570', u'ENSMUSG00000026200', u'ENSMUSG00000024981', u'ENSMUSG00000042082', u'ENSMUSG00000029314', u'ENSMUSG00000027698', u'ENSMUSG00000056220', u'ENSMUSG00000020231', u'ENSMUSG00000076435', u'ENSMUSG00000053898', u'ENSMUSG00000032263', u'ENSMUSG00000053279', u'ENSMUSG00000039620', u'ENSMUSG00000055923', u'ENSMUSG00000035245', u'ENSMUSG00000068762', u'ENSMUSG00000026687', u'ENSMUSG00000023456', u'ENSMUSG00000025815', u'ENSMUSG00000001755', u'ENSMUSG00000029376', u'ENSMUSG00000025007', u'ENSMUSG00000018796', u'ENSMUSG00000022453', u'ENSMUSG00000026558', u'ENSMUSG00000024085', u'ENSMUSG00000052738', u'ENSMUSG00000032348', u'ENSMUSG00000031545', u'ENSMUSG00000060803', u'ENSMUSG00000025648', u'ENSMUSG00000034371', u'ENSMUSG00000030774', u'ENSMUSG00000028274', u'ENSMUSG00000033059', u'ENSMUSG00000001323', u'ENSMUSG00000023026', u'ENSMUSG00000032298', u'ENSMUSG00000022962', u'ENSMUSG00000060376', u'ENSMUSG00000039307', u'ENSMUSG00000033554', u'ENSMUSG00000027452', u'ENSMUSG00000032293', u'ENSMUSG00000036646', u'ENSMUSG00000036833', u'ENSMUSG00000003123', u'ENSMUSG00000032295', u'ENSMUSG00000025877', u'ENSMUSG00000028164', u'ENSMUSG00000021003', u'ENSMUSG00000026670', u'ENSMUSG00000028048', u'ENSMUSG00000003746', u'ENSMUSG00000034707', u'ENSMUSG00000020475', u'ENSMUSG00000023827', u'ENSMUSG00000052920', u'ENSMUSG00000032854', u'ENSMUSG00000025232', u'ENSMUSG00000030036', u'ENSMUSG00000023868', u'ENSMUSG00000030271', u'ENSMUSG00000031758', u'ENSMUSG00000028766', u'ENSMUSG00000028673', u'ENSMUSG00000010051', u'ENSMUSG00000029326', u'ENSMUSG00000029009', u'ENSMUSG00000054545', u'ENSMUSG00000036061', u'ENSMUSG00000020333', u'ENSMUSG00000069516', u'ENSMUSG00000045316', u'ENSMUSG00000000628', u'ENSMUSG00000056999', u'ENSMUSG00000034674', u'ENSMUSG00000013629', u'ENSMUSG00000035561', u'ENSMUSG00000020777', u'ENSMUSG00000020774', u'ENSMUSG00000030088', u'ENSMUSG00000022425', u'ENSMUSG00000022814', u'ENSMUSG00000038173', u'ENSMUSG00000027359', u'ENSMUSG00000004032', u'ENSMUSG00000002428', u'ENSMUSG00000061838', u'ENSMUSG00000048755', u'ENSMUSG00000030978', u'ENSMUSG00000033192', u'ENSMUSG00000003809', u'ENSMUSG00000020766', u'ENSMUSG00000033540', u'ENSMUSG00000024068', u'ENSMUSG00000021273', u'ENSMUSG00000029482', u'ENSMUSG00000058135', u'ENSMUSG00000074576', u'ENSMUSG00000020917', u'ENSMUSG00000028980', u'ENSMUSG00000042684', u'ENSMUSG00000024899', u'ENSMUSG00000031985', u'ENSMUSG00000036257', u'ENSMUSG00000034254', u'ENSMUSG00000007038', u'ENSMUSG00000028454', u'ENSMUSG00000042251', u'ENSMUSG00000028603', u'ENSMUSG00000030630', u'ENSMUSG00000029446', u'ENSMUSG00000029916', u'ENSMUSG00000031284', u'ENSMUSG00000037012', u'ENSMUSG00000042632', u'ENSMUSG00000022186', u'ENSMUSG00000024556', u'ENSMUSG00000029247', u'ENSMUSG00000062908', u'ENSMUSG00000027207', u'ENSMUSG00000025745', u'ENSMUSG00000021786', u'ENSMUSG00000024885', u'ENSMUSG00000032047', u'ENSMUSG00000038871', u'ENSMUSG00000025579', u'ENSMUSG00000000340', u'ENSMUSG00000010047']), pop_n=13836, p_sm_bonferroni=0.26694686784118893, is_obsolete=False, GO='GO:0008152', name='metabolic process', pop_count=332, alt_ids=[], level=1, depth=1, enrichment='e', Cluster='Late Increase', geneid_set=set([u'ENSMUSG00000062031', u'ENSMUSG00000001891', u'ENSMUSG00000020715', u'ENSMUSG00000013584', u'ENSMUSG00000053279', u'ENSMUSG00000061838', u'ENSMUSG00000033705', u'ENSMUSG00000028164', u'ENSMUSG00000022781', u'ENSMUSG00000026922', u'ENSMUSG00000029455', u'ENSMUSG00000023961', u'ENSMUSG00000053965', u'ENSMUSG00000062646', u'ENSMUSG00000032883', u'ENSMUSG00000010051', u'ENSMUSG00000021592', u'ENSMUSG00000053398', u'ENSMUSG00000054545', u'ENSMUSG00000053644', u'ENSMUSG00000042251', u'ENSMUSG00000069516', u'ENSMUSG00000059447', u'ENSMUSG00000020777', u'ENSMUSG00000020774', u'ENSMUSG00000026200', u'ENSMUSG00000038173', u'ENSMUSG00000021417', u'ENSMUSG00000020231', u'ENSMUSG00000023921', u'ENSMUSG00000026701', u'ENSMUSG00000076435', u'ENSMUSG00000030272', u'ENSMUSG00000026003', u'ENSMUSG00000021238', u'ENSMUSG00000032281', u'ENSMUSG00000026956', u'ENSMUSG00000056536', u'ENSMUSG00000037370', u'ENSMUSG00000018574', u'ENSMUSG00000021069', u'ENSMUSG00000033540', u'ENSMUSG00000028603', u'ENSMUSG00000029446', u'ENSMUSG00000001773', u'ENSMUSG00000024978', u'ENSMUSG00000042010', u'ENSMUSG00000022453', u'ENSMUSG00000034707', u'ENSMUSG00000033059', u'ENSMUSG00000022842', u'ENSMUSG00000043943', u'ENSMUSG00000022253', u'ENSMUSG00000020766', u'ENSMUSG00000027452', u'ENSMUSG00000020333', u'ENSMUSG00000024899', u'ENSMUSG00000036833', u'ENSMUSG00000035948']), symbols=u'Acacb Acadl Acadvl Acox1 Acsbg1 Acsf2 Acsl3 Acsl6 Acss1 Acss3 Agpat2 Aldh1a1 Aldh1a2 Aldh2 Aldh6a1 Aldh7a1 Arsk Aspa Camk1 Dip2a Ece2 Eci2 Enpp1 Enpp4 Enpp6 Ern1 Folh1 Galk1 Ganc Glb1l Gns Gpam Hadhb Hyal1 Idua Lyz2 Manba Mut Naalad2 Nadk2 Naga Pak2 Papss2 Pde5a Pgghg Phgdh Pign Pm20d1 Pnpla7 Prdx6 Psph Pygb Pygl Scp2 Stard9 Suclg2 Uap1l1 Ugp2 Ugt1a6a', symbol_set=set([u'Mut', u'Aspa', u'Psph', 'Pgghg', u'Acsl3', u'Acox1', u'Acsl6', u'Suclg2', u'Ugt1a6a', u'Naalad2', u'Acsbg1', u'Glb1l', u'Pm20d1', u'Acss1', u'Pde5a', u'Folh1', u'Acadvl', u'Eci2', u'Hadhb', u'Prdx6', u'Pign', u'Lyz2', u'Stard9', u'Aldh1a2', u'Acadl', u'Pnpla7', u'Idua', u'Agpat2', u'Gns', u'Gpam', u'Acacb', u'Camk1', u'Hyal1', u'Scp2', u'Galk1', u'Aldh2', u'Arsk', u'Aldh6a1', u'Phgdh', u'Aldh7a1', 'Nadk2', u'Pygl', u'Aldh1a1', u'Ugp2', u'Acss3', u'Papss2', u'Manba', u'Enpp6', u'Dip2a', u'Enpp4', u'Pygb', u'Enpp1', u'Ganc', u'Uap1l1', u'Ern1', u'Naga', u'Acsf2', u'Pak2', u'Ece2']), geneids='ENSMUSG00000037370 ENSMUSG00000062031 ENSMUSG00000001891 ENSMUSG00000033540 ENSMUSG00000020715 ENSMUSG00000042251 ENSMUSG00000013584 ENSMUSG00000030272 ENSMUSG00000061838 ENSMUSG00000033705 ENSMUSG00000022781 ENSMUSG00000026922 ENSMUSG00000029455 ENSMUSG00000023961 ENSMUSG00000053965 ENSMUSG00000024978 ENSMUSG00000062646 ENSMUSG00000032883 ENSMUSG00000010051 ENSMUSG00000021592 ENSMUSG00000053398 ENSMUSG00000054545 ENSMUSG00000053644 ENSMUSG00000026003 ENSMUSG00000069516 ENSMUSG00000059447 ENSMUSG00000042010 ENSMUSG00000020777 ENSMUSG00000020774 ENSMUSG00000021069 ENSMUSG00000038173 ENSMUSG00000021417 ENSMUSG00000020231 ENSMUSG00000023921 ENSMUSG00000026701 ENSMUSG00000076435 ENSMUSG00000053279 ENSMUSG00000021238 ENSMUSG00000026200 ENSMUSG00000026956 ENSMUSG00000056536 ENSMUSG00000022453 ENSMUSG00000018574 ENSMUSG00000032281 ENSMUSG00000028603 ENSMUSG00000029446 ENSMUSG00000001773 ENSMUSG00000028164 ENSMUSG00000034707 ENSMUSG00000033059 ENSMUSG00000022842 ENSMUSG00000043943 ENSMUSG00000022253 ENSMUSG00000020766 ENSMUSG00000027452 ENSMUSG00000020333 ENSMUSG00000024899 ENSMUSG00000036833 ENSMUSG00000035948', format_txt=1, hdr_idx=1, is_hdrgo=True, is_usrgo=True, hdr1usr01='**', dcnt=6422, D1='D', GO_name='metabolic process'),
    Nt(p_uncorrected='', study_count='', study_n='', namespace='', p_fdr_bh='', study_items='', NS='BP', pop_items='', pop_n='', p_sm_bonferroni='', is_obsolete='', GO='GO:0006869', name='', pop_count='', alt_ids='', level=4, depth=5, enrichment='', Cluster='', geneid_set='', symbols='', symbol_set='', geneids='', format_txt=1, hdr_idx=1, is_hdrgo=True, is_usrgo=False, hdr1usr01='*', dcnt=96, D1='CG', GO_name='lipid transport'),
    Nt(p_uncorrected='', study_count='', study_n='', namespace='', p_fdr_bh='', study_items='', NS='BP', pop_items='', pop_n='', p_sm_bonferroni='', is_obsolete='', GO='GO:0030155', name='', pop_count='', alt_ids='', level=3, depth=3, enrichment='', Cluster='', geneid_set='', symbols='', symbol_set='', geneids='', format_txt=1, hdr_idx=1, is_hdrgo=True, is_usrgo=False, hdr1usr01='*', dcnt=248, D1='A', GO_name='regulation of cell adhesion'),
    Nt(p_uncorrected='', study_count='', study_n='', namespace='', p_fdr_bh='', study_items='', NS='BP', pop_items='', pop_n='', p_sm_bonferroni='', is_obsolete='', GO='GO:0030154', name='', pop_count='', alt_ids='', level=4, depth=4, enrichment='', Cluster='', geneid_set='', symbols='', symbol_set='', geneids='', format_txt=1, hdr_idx=1, is_hdrgo=True, is_usrgo=False, hdr1usr01='*', dcnt=513, D1='BCE', GO_name='cell differentiation'),
    Nt(p_uncorrected=0.00011971800929706283, study_count=20, study_n=1397, namespace='biological_process', p_fdr_bh=0.013637951570374429, study_items=set([u'ENSMUSG00000048402', u'ENSMUSG00000029994', u'ENSMUSG00000031665', u'ENSMUSG00000027253', u'ENSMUSG00000027187', u'ENSMUSG00000034462', u'ENSMUSG00000057329', u'ENSMUSG00000032220', u'ENSMUSG00000024620', u'ENSMUSG00000020097', u'ENSMUSG00000007613', u'ENSMUSG00000037003', u'ENSMUSG00000029705', u'ENSMUSG00000022893', u'ENSMUSG00000035342', u'ENSMUSG00000071711', u'ENSMUSG00000021318', u'ENSMUSG00000034101', u'ENSMUSG00000039004', u'ENSMUSG00000027381']), NS='BP', pop_items=set([u'ENSMUSG00000050295', u'ENSMUSG00000029436', u'ENSMUSG00000003873', u'ENSMUSG00000022292', u'ENSMUSG00000024392', u'ENSMUSG00000025035', u'ENSMUSG00000033282', u'ENSMUSG00000008999', u'ENSMUSG00000039239', u'ENSMUSG00000018395', u'ENSMUSG00000027381', u'ENSMUSG00000006932', u'ENSMUSG00000022893', u'ENSMUSG00000020692', u'ENSMUSG00000016918', u'ENSMUSG00000045515', u'ENSMUSG00000047824', u'ENSMUSG00000040943', u'ENSMUSG00000040040', u'ENSMUSG00000050332', u'ENSMUSG00000031644', u'ENSMUSG00000024515', u'ENSMUSG00000039994', u'ENSMUSG00000021318', u'ENSMUSG00000032220', u'ENSMUSG00000024620', u'ENSMUSG00000062563', u'ENSMUSG00000019947', u'ENSMUSG00000001151', u'ENSMUSG00000036862', u'ENSMUSG00000034462', u'ENSMUSG00000037664', u'ENSMUSG00000032855', u'ENSMUSG00000052516', u'ENSMUSG00000027253', u'ENSMUSG00000034101', u'ENSMUSG00000039004', u'ENSMUSG00000039474', u'ENSMUSG00000029994', u'ENSMUSG00000007613', u'ENSMUSG00000026812', u'ENSMUSG00000074733', u'ENSMUSG00000011179', u'ENSMUSG00000061393', u'ENSMUSG00000034292', u'ENSMUSG00000026768', u'ENSMUSG00000044042', u'ENSMUSG00000005871', u'ENSMUSG00000055653', u'ENSMUSG00000014303', u'ENSMUSG00000037003', u'ENSMUSG00000046743', u'ENSMUSG00000029705', u'ENSMUSG00000020681', u'ENSMUSG00000031980', u'ENSMUSG00000031665', u'ENSMUSG00000023951', u'ENSMUSG00000021835', u'ENSMUSG00000006800', u'ENSMUSG00000042797', u'ENSMUSG00000071711', u'ENSMUSG00000034910', u'ENSMUSG00000027187', u'ENSMUSG00000056962', u'ENSMUSG00000032558', u'ENSMUSG00000057329', u'ENSMUSG00000048402', u'ENSMUSG00000027777', u'ENSMUSG00000042460', u'ENSMUSG00000024713', u'ENSMUSG00000020097', u'ENSMUSG00000032327', u'ENSMUSG00000028344', u'ENSMUSG00000020319', u'ENSMUSG00000027204', u'ENSMUSG00000026605', u'ENSMUSG00000035342', u'ENSMUSG00000039801', u'ENSMUSG00000001105', u'ENSMUSG00000021650', u'ENSMUSG00000034640']), pop_n=13836, p_sm_bonferroni=1.0, is_obsolete=False, GO='GO:0001822', name='kidney development', pop_count=81, alt_ids=[], level=3, depth=4, enrichment='e', Cluster='Late Increase', geneid_set=set([u'ENSMUSG00000029994', u'ENSMUSG00000021318', u'ENSMUSG00000027381', u'ENSMUSG00000029705', u'ENSMUSG00000022893', u'ENSMUSG00000031665', u'ENSMUSG00000048402', u'ENSMUSG00000037003', u'ENSMUSG00000027187', u'ENSMUSG00000057329', u'ENSMUSG00000032220', u'ENSMUSG00000024620', u'ENSMUSG00000020097', u'ENSMUSG00000007613', u'ENSMUSG00000034462', u'ENSMUSG00000035342', u'ENSMUSG00000071711', u'ENSMUSG00000027253', u'ENSMUSG00000034101', u'ENSMUSG00000039004']), symbols=u'Adamts1 Anxa4 Bcl2 Bcl2l11 Bmp6 Cat Ctnnd1 Cux1 Gli2 Gli3 Lrp4 Lzts2 Mpst Myo1e Pdgfrb Pkd2 Sall1 Sgpl1 Tgfbr1 Tns2', symbol_set=set([u'Pdgfrb', u'Sgpl1', u'Bmp6', u'Bcl2l11', u'Anxa4', u'Lrp4', u'Cux1', u'Pkd2', u'Myo1e', u'Tgfbr1', u'Cat', u'Gli2', u'Gli3', u'Mpst', u'Sall1', u'Ctnnd1', 'Tns2', u'Adamts1', u'Lzts2', u'Bcl2']), geneids='ENSMUSG00000048402 ENSMUSG00000029994 ENSMUSG00000027253 ENSMUSG00000037003 ENSMUSG00000027187 ENSMUSG00000057329 ENSMUSG00000032220 ENSMUSG00000024620 ENSMUSG00000031665 ENSMUSG00000020097 ENSMUSG00000007613 ENSMUSG00000027381 ENSMUSG00000029705 ENSMUSG00000022893 ENSMUSG00000035342 ENSMUSG00000071711 ENSMUSG00000021318 ENSMUSG00000034101 ENSMUSG00000039004 ENSMUSG00000034462', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=12, D1='CE', GO_name='kidney development'),
    Nt(p_uncorrected='', study_count='', study_n='', namespace='', p_fdr_bh='', study_items='', NS='BP', pop_items='', pop_n='', p_sm_bonferroni='', is_obsolete='', GO='GO:0034641', name='', pop_count='', alt_ids='', level=3, depth=3, enrichment='', Cluster='', geneid_set='', symbols='', symbol_set='', geneids='', format_txt=1, hdr_idx=1, is_hdrgo=True, is_usrgo=False, hdr1usr01='*', dcnt=2095, D1='BD', GO_name='cellular nitrogen compound metabolic process'),
    Nt(p_uncorrected=0.00024238094422268013, study_count=14, study_n=1397, namespace='biological_process', p_fdr_bh=0.023540472345627093, study_items=set([u'ENSMUSG00000027168', u'ENSMUSG00000052430', u'ENSMUSG00000026317', u'ENSMUSG00000000567', u'ENSMUSG00000041235', u'ENSMUSG00000032796', u'ENSMUSG00000026840', u'ENSMUSG00000019803', u'ENSMUSG00000047407', u'ENSMUSG00000018654', u'ENSMUSG00000014361', u'ENSMUSG00000052911', u'ENSMUSG00000055254', u'ENSMUSG00000036192']), NS='BP', pop_items=set([u'ENSMUSG00000021557', u'ENSMUSG00000041235', u'ENSMUSG00000003873', u'ENSMUSG00000028222', u'ENSMUSG00000029064', u'ENSMUSG00000031028', u'ENSMUSG00000026840', u'ENSMUSG00000019971', u'ENSMUSG00000001289', u'ENSMUSG00000001288', u'ENSMUSG00000032012', u'ENSMUSG00000029050', u'ENSMUSG00000036192', u'ENSMUSG00000025188', u'ENSMUSG00000026317', u'ENSMUSG00000068323', u'ENSMUSG00000022843', u'ENSMUSG00000000247', u'ENSMUSG00000018654', u'ENSMUSG00000019803', u'ENSMUSG00000023328', u'ENSMUSG00000039577', u'ENSMUSG00000027378', u'ENSMUSG00000022111', u'ENSMUSG00000034739', u'ENSMUSG00000034394', u'ENSMUSG00000024176', u'ENSMUSG00000038122', u'ENSMUSG00000024169', u'ENSMUSG00000005871', u'ENSMUSG00000000489', u'ENSMUSG00000014361', u'ENSMUSG00000021608', u'ENSMUSG00000052911', u'ENSMUSG00000019986', u'ENSMUSG00000055254', u'ENSMUSG00000043059', u'ENSMUSG00000027168', u'ENSMUSG00000052430', u'ENSMUSG00000000567', u'ENSMUSG00000056962', u'ENSMUSG00000020900', u'ENSMUSG00000032796', u'ENSMUSG00000047407', u'ENSMUSG00000017491', u'ENSMUSG00000024990', u'ENSMUSG00000014773', u'ENSMUSG00000020212', u'ENSMUSG00000012609']), pop_n=13836, p_sm_bonferroni=1.0, is_obsolete=False, GO='GO:0060041', name='retina development in camera-type eye', pop_count=49, alt_ids=['GO:0002073'], level=3, depth=3, enrichment='e', Cluster='Late Increase', geneid_set=set([u'ENSMUSG00000027168', u'ENSMUSG00000052430', u'ENSMUSG00000026317', u'ENSMUSG00000000567', u'ENSMUSG00000041235', u'ENSMUSG00000032796', u'ENSMUSG00000026840', u'ENSMUSG00000019803', u'ENSMUSG00000047407', u'ENSMUSG00000018654', u'ENSMUSG00000014361', u'ENSMUSG00000052911', u'ENSMUSG00000055254', u'ENSMUSG00000036192']), symbols=u'Bmpr1b Chd7 Cln8 Ikzf1 Lama1 Lamb2 Lamc3 Mertk Nr2e1 Ntrk2 Pax6 Rorb Sox9 Tgif1', symbol_set=set([u'Lama1', u'Chd7', u'Rorb', u'Ntrk2', u'Bmpr1b', u'Sox9', u'Nr2e1', u'Mertk', u'Lamc3', u'Pax6', u'Lamb2', u'Ikzf1', u'Tgif1', u'Cln8']), geneids='ENSMUSG00000027168 ENSMUSG00000052430 ENSMUSG00000026317 ENSMUSG00000000567 ENSMUSG00000041235 ENSMUSG00000032796 ENSMUSG00000026840 ENSMUSG00000019803 ENSMUSG00000047407 ENSMUSG00000018654 ENSMUSG00000014361 ENSMUSG00000052911 ENSMUSG00000055254 ENSMUSG00000036192', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=0, D1='E', GO_name='retina development in camera-type eye'),
    Nt(p_uncorrected=0.0005300557577084851, study_count=7, study_n=1397, namespace='biological_process', p_fdr_bh=0.04118397325662184, study_items=set([u'ENSMUSG00000020053', u'ENSMUSG00000026923', u'ENSMUSG00000030087', u'ENSMUSG00000031425', u'ENSMUSG00000002274', u'ENSMUSG00000062312', u'ENSMUSG00000042453']), NS='BP', pop_items=set([u'ENSMUSG00000020053', u'ENSMUSG00000020052', u'ENSMUSG00000026923', u'ENSMUSG00000029337', u'ENSMUSG00000030087', u'ENSMUSG00000062991', u'ENSMUSG00000031425', u'ENSMUSG00000062312', u'ENSMUSG00000002274', u'ENSMUSG00000027612', u'ENSMUSG00000024304', u'ENSMUSG00000036766', u'ENSMUSG00000047261', u'ENSMUSG00000042453', u'ENSMUSG00000029603', u'ENSMUSG00000008575']), pop_n=13836, p_sm_bonferroni=1.0, is_obsolete=False, GO='GO:0010001', name='glial cell differentiation', pop_count=16, alt_ids=['GO:0007404', 'GO:0043360'], level=5, depth=5, enrichment='e', Cluster='Late Increase', geneid_set=set([u'ENSMUSG00000020053', u'ENSMUSG00000062312', u'ENSMUSG00000026923', u'ENSMUSG00000042453', u'ENSMUSG00000030087', u'ENSMUSG00000031425', u'ENSMUSG00000002274']), symbols=u'Erbb2 Igf1 Klf15 Metrn Notch1 Plp1 Reln', symbol_set=set([u'Erbb2', u'Igf1', u'Klf15', u'Metrn', u'Notch1', u'Reln', u'Plp1']), geneids='ENSMUSG00000020053 ENSMUSG00000026923 ENSMUSG00000030087 ENSMUSG00000031425 ENSMUSG00000002274 ENSMUSG00000062312 ENSMUSG00000042453', format_txt=1, hdr_idx=1, is_hdrgo=True, is_usrgo=True, hdr1usr01='**', dcnt=17, D1='BCE', GO_name='glial cell differentiation'),
    Nt(p_uncorrected='', study_count='', study_n='', namespace='', p_fdr_bh='', study_items='', NS='BP', pop_items='', pop_n='', p_sm_bonferroni='', is_obsolete='', GO='GO:0023051', name='', pop_count='', alt_ids='', level=3, depth=3, enrichment='', Cluster='', geneid_set='', symbols='', symbol_set='', geneids='', format_txt=1, hdr_idx=1, is_hdrgo=True, is_usrgo=False, hdr1usr01='*', dcnt=1395, D1='A', GO_name='regulation of signaling'),
    Nt(p_uncorrected=1.0426320645028554e-05, study_count=5, study_n=1397, namespace='biological_process', p_fdr_bh=0.0019264534645466785, study_items=set([u'ENSMUSG00000004043', u'ENSMUSG00000022488', u'ENSMUSG00000020919', u'ENSMUSG00000026395', u'ENSMUSG00000021457']), NS='BP', pop_items=set([u'ENSMUSG00000021457', u'ENSMUSG00000004043', u'ENSMUSG00000022488', u'ENSMUSG00000020919', u'ENSMUSG00000026395']), pop_n=13836, p_sm_bonferroni=0.15796918409282762, is_obsolete=False, GO='GO:0045588', name='positive regulation of gamma-delta T cell differentiation', pop_count=5, alt_ids=[], level=9, depth=10, enrichment='e', Cluster='Late Increase', geneid_set=set([u'ENSMUSG00000021457', u'ENSMUSG00000004043', u'ENSMUSG00000022488', u'ENSMUSG00000020919', u'ENSMUSG00000026395']), symbols=u'Nckap1l Ptprc Stat5a Stat5b Syk', symbol_set=set([u'Syk', u'Stat5b', u'Stat5a', u'Nckap1l', u'Ptprc']), geneids='ENSMUSG00000004043 ENSMUSG00000022488 ENSMUSG00000020919 ENSMUSG00000026395 ENSMUSG00000021457', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=0, D1='A', GO_name='positive regulation of gamma-delta T cell differentiation'),
    Nt(p_uncorrected=6.779918751091525e-05, study_count=20, study_n=1397, namespace='biological_process', p_fdr_bh=0.008932395565025017, study_items=set([u'ENSMUSG00000027962', u'ENSMUSG00000019920', u'ENSMUSG00000001946', u'ENSMUSG00000028583', u'ENSMUSG00000000567', u'ENSMUSG00000042626', u'ENSMUSG00000057329', u'ENSMUSG00000061665', u'ENSMUSG00000006386', u'ENSMUSG00000030428', u'ENSMUSG00000001552', u'ENSMUSG00000060843', u'ENSMUSG00000031871', u'ENSMUSG00000016494', u'ENSMUSG00000020122', u'ENSMUSG00000028517', u'ENSMUSG00000069170', u'ENSMUSG00000034101', u'ENSMUSG00000027111', u'ENSMUSG00000022687']), NS='BP', pop_items=set([u'ENSMUSG00000022770', u'ENSMUSG00000020994', u'ENSMUSG00000038119', u'ENSMUSG00000027111', u'ENSMUSG00000024395', u'ENSMUSG00000020340', u'ENSMUSG00000006411', u'ENSMUSG00000032012', u'ENSMUSG00000022665', u'ENSMUSG00000028517', u'ENSMUSG00000039844', u'ENSMUSG00000030428', u'ENSMUSG00000006699', u'ENSMUSG00000022443', u'ENSMUSG00000037405', u'ENSMUSG00000041378', u'ENSMUSG00000022865', u'ENSMUSG00000027009', u'ENSMUSG00000054889', u'ENSMUSG00000022568', u'ENSMUSG00000040511', u'ENSMUSG00000006932', u'ENSMUSG00000022656', u'ENSMUSG00000022240', u'ENSMUSG00000026587', u'ENSMUSG00000024304', u'ENSMUSG00000020598', u'ENSMUSG00000024421', u'ENSMUSG00000020659', u'ENSMUSG00000019969', u'ENSMUSG00000015605', u'ENSMUSG00000015002', u'ENSMUSG00000061665', u'ENSMUSG00000019920', u'ENSMUSG00000027962', u'ENSMUSG00000001946', u'ENSMUSG00000028583', u'ENSMUSG00000028195', u'ENSMUSG00000030786', u'ENSMUSG00000030201', u'ENSMUSG00000001552', u'ENSMUSG00000027435', u'ENSMUSG00000006386', u'ENSMUSG00000031558', u'ENSMUSG00000016494', u'ENSMUSG00000022687', u'ENSMUSG00000059674', u'ENSMUSG00000026991', u'ENSMUSG00000033060', u'ENSMUSG00000029790', u'ENSMUSG00000041957', u'ENSMUSG00000032011', u'ENSMUSG00000033327', u'ENSMUSG00000032174', u'ENSMUSG00000032518', u'ENSMUSG00000000567', u'ENSMUSG00000000290', u'ENSMUSG00000028909', u'ENSMUSG00000000303', u'ENSMUSG00000057329', u'ENSMUSG00000020902', u'ENSMUSG00000042626', u'ENSMUSG00000000325', u'ENSMUSG00000033487', u'ENSMUSG00000040037', u'ENSMUSG00000034101', u'ENSMUSG00000018171', u'ENSMUSG00000060843', u'ENSMUSG00000025812', u'ENSMUSG00000070047', u'ENSMUSG00000041734', u'ENSMUSG00000036915', u'ENSMUSG00000020122', u'ENSMUSG00000032855', u'ENSMUSG00000025473', u'ENSMUSG00000036099', u'ENSMUSG00000031871', u'ENSMUSG00000069170']), pop_n=13836, p_sm_bonferroni=1.0, is_obsolete=False, GO='GO:0016337', name='single organismal cell-cell adhesion', pop_count=78, alt_ids=[], level=3, depth=4, enrichment='e', Cluster='Late Increase', geneid_set=set([u'ENSMUSG00000027962', u'ENSMUSG00000001946', u'ENSMUSG00000027111', u'ENSMUSG00000001552', u'ENSMUSG00000016494', u'ENSMUSG00000028517', u'ENSMUSG00000031871', u'ENSMUSG00000022687', u'ENSMUSG00000000567', u'ENSMUSG00000057329', u'ENSMUSG00000006386', u'ENSMUSG00000030428', u'ENSMUSG00000060843', u'ENSMUSG00000061665', u'ENSMUSG00000028583', u'ENSMUSG00000020122', u'ENSMUSG00000069170', u'ENSMUSG00000034101', u'ENSMUSG00000042626', u'ENSMUSG00000019920']), symbols=u'Adgrv1 Bcl2 Boc Cd2ap Cd34 Cdh5 Ctnna3 Ctnnd1 Egfr Esam Itga6 Jup Lims1 Pdpn Plpp3 Shc1 Sox9 Tek Ttyh1 Vcam1', symbol_set=set(['Plpp3', u'Tek', u'Ctnnd1', u'Ttyh1', u'Egfr', u'Ctnna3', u'Cd34', u'Itga6', u'Cd2ap', u'Jup', u'Sox9', u'Vcam1', u'Esam', u'Pdpn', 'Adgrv1', u'Boc', u'Cdh5', u'Lims1', u'Shc1', u'Bcl2']), geneids='ENSMUSG00000027962 ENSMUSG00000001946 ENSMUSG00000028583 ENSMUSG00000000567 ENSMUSG00000069170 ENSMUSG00000042626 ENSMUSG00000057329 ENSMUSG00000061665 ENSMUSG00000001552 ENSMUSG00000006386 ENSMUSG00000030428 ENSMUSG00000060843 ENSMUSG00000031871 ENSMUSG00000016494 ENSMUSG00000028517 ENSMUSG00000020122 ENSMUSG00000022687 ENSMUSG00000034101 ENSMUSG00000027111 ENSMUSG00000019920', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=49, D1='CP', GO_name='single organismal cell-cell adhesion'),
    Nt(p_uncorrected=0.00047594319969878284, study_count=4, study_n=1397, namespace='biological_process', p_fdr_bh=0.0381597084052771, study_items=set([u'ENSMUSG00000063856', u'ENSMUSG00000020053', u'ENSMUSG00000028864', u'ENSMUSG00000037621']), NS='BP', pop_items=set([u'ENSMUSG00000020053', u'ENSMUSG00000009376', u'ENSMUSG00000063856', u'ENSMUSG00000028864', u'ENSMUSG00000037621']), pop_n=13836, p_sm_bonferroni=1.0, is_obsolete=False, GO='GO:0051450', name='myoblast proliferation', pop_count=5, alt_ids=[], level=3, depth=3, enrichment='e', Cluster='Late Increase', geneid_set=set([u'ENSMUSG00000063856', u'ENSMUSG00000020053', u'ENSMUSG00000028864', u'ENSMUSG00000037621']), symbols=u'Atoh8 Gpx1 Hgf Igf1', symbol_set=set([u'Gpx1', u'Hgf', u'Igf1', u'Atoh8']), geneids='ENSMUSG00000020053 ENSMUSG00000037621 ENSMUSG00000063856 ENSMUSG00000028864', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=1, D1='C', GO_name='myoblast proliferation'),
    Nt(p_uncorrected=0.00015597551367383584, study_count=9, study_n=1397, namespace='biological_process', p_fdr_bh=0.016411006997724215, study_items=set([u'ENSMUSG00000006301', u'ENSMUSG00000031387', u'ENSMUSG00000030317', u'ENSMUSG00000042010', u'ENSMUSG00000030720', u'ENSMUSG00000021585', u'ENSMUSG00000026923', u'ENSMUSG00000003849', u'ENSMUSG00000037166']), NS='BP', pop_items=set([u'ENSMUSG00000026923', u'ENSMUSG00000025873', u'ENSMUSG00000031387', u'ENSMUSG00000006301', u'ENSMUSG00000030317', u'ENSMUSG00000030720', u'ENSMUSG00000003849', u'ENSMUSG00000040652', u'ENSMUSG00000019907', u'ENSMUSG00000003421', u'ENSMUSG00000020114', u'ENSMUSG00000001131', u'ENSMUSG00000004931', u'ENSMUSG00000033712', u'ENSMUSG00000066037', u'ENSMUSG00000035242', u'ENSMUSG00000033792', u'ENSMUSG00000042010', u'ENSMUSG00000056612', u'ENSMUSG00000021585', u'ENSMUSG00000037166', u'ENSMUSG00000027499']), pop_n=13836, p_sm_bonferroni=1.0, is_obsolete=False, GO='GO:0043086', name='negative regulation of catalytic activity', pop_count=22, alt_ids=['GO:0048553'], level=4, depth=4, enrichment='e', Cluster='Late Increase', geneid_set=set([u'ENSMUSG00000006301', u'ENSMUSG00000030317', u'ENSMUSG00000031387', u'ENSMUSG00000042010', u'ENSMUSG00000030720', u'ENSMUSG00000021585', u'ENSMUSG00000026923', u'ENSMUSG00000003849', u'ENSMUSG00000037166']), symbols=u'Acacb Cast Cln3 Notch1 Nqo1 Ppp1r14a Renbp Timp4 Tmbim1', symbol_set=set([u'Renbp', u'Timp4', u'Acacb', u'Notch1', u'Nqo1', u'Cast', u'Cln3', u'Tmbim1', u'Ppp1r14a']), geneids='ENSMUSG00000006301 ENSMUSG00000003849 ENSMUSG00000030317 ENSMUSG00000021585 ENSMUSG00000030720 ENSMUSG00000042010 ENSMUSG00000026923 ENSMUSG00000037166 ENSMUSG00000031387', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=198, D1='A', GO_name='negative regulation of catalytic activity'),
    Nt(p_uncorrected=0.00017514223981674013, study_count=16, study_n=1397, namespace='biological_process', p_fdr_bh=0.018051565139207006, study_items=set([u'ENSMUSG00000021900', u'ENSMUSG00000001761', u'ENSMUSG00000000567', u'ENSMUSG00000004894', u'ENSMUSG00000007872', u'ENSMUSG00000041235', u'ENSMUSG00000061524', u'ENSMUSG00000016028', u'ENSMUSG00000026510', u'ENSMUSG00000031486', u'ENSMUSG00000041607', u'ENSMUSG00000021614', u'ENSMUSG00000042453', u'ENSMUSG00000021318', u'ENSMUSG00000030894', u'ENSMUSG00000053024']), NS='BP', pop_items=set([u'ENSMUSG00000021900', u'ENSMUSG00000033585', u'ENSMUSG00000013663', u'ENSMUSG00000031486', u'ENSMUSG00000015709', u'ENSMUSG00000066687', u'ENSMUSG00000004894', u'ENSMUSG00000000838', u'ENSMUSG00000010025', u'ENSMUSG00000028519', u'ENSMUSG00000018209', u'ENSMUSG00000037188', u'ENSMUSG00000032087', u'ENSMUSG00000022620', u'ENSMUSG00000035936', u'ENSMUSG00000029104', u'ENSMUSG00000041319', u'ENSMUSG00000001761', u'ENSMUSG00000049717', u'ENSMUSG00000021613', u'ENSMUSG00000030607', u'ENSMUSG00000007594', u'ENSMUSG00000041235', u'ENSMUSG00000026510', u'ENSMUSG00000042453', u'ENSMUSG00000000223', u'ENSMUSG00000022952', u'ENSMUSG00000041607', u'ENSMUSG00000042082', u'ENSMUSG00000021848', u'ENSMUSG00000032312', u'ENSMUSG00000022329', u'ENSMUSG00000016028', u'ENSMUSG00000029501', u'ENSMUSG00000020598', u'ENSMUSG00000021448', u'ENSMUSG00000072115', u'ENSMUSG00000031231', u'ENSMUSG00000061524', u'ENSMUSG00000039910', u'ENSMUSG00000026872', u'ENSMUSG00000033253', u'ENSMUSG00000021318', u'ENSMUSG00000042228', u'ENSMUSG00000059552', u'ENSMUSG00000029211', u'ENSMUSG00000032368', u'ENSMUSG00000000567', u'ENSMUSG00000007872', u'ENSMUSG00000022483', u'ENSMUSG00000002341', u'ENSMUSG00000004788', u'ENSMUSG00000048616', u'ENSMUSG00000022031', u'ENSMUSG00000053024', u'ENSMUSG00000006958', u'ENSMUSG00000021614', u'ENSMUSG00000021615', u'ENSMUSG00000030894']), pop_n=13836, p_sm_bonferroni=1.0, is_obsolete=False, GO='GO:0007417', name='central nervous system development', pop_count=59, alt_ids=[], level=4, depth=4, enrichment='e', Cluster='Late Increase', geneid_set=set([u'ENSMUSG00000021614', u'ENSMUSG00000031486', u'ENSMUSG00000061524', u'ENSMUSG00000004894', u'ENSMUSG00000053024', u'ENSMUSG00000021318', u'ENSMUSG00000001761', u'ENSMUSG00000000567', u'ENSMUSG00000007872', u'ENSMUSG00000041235', u'ENSMUSG00000026510', u'ENSMUSG00000041607', u'ENSMUSG00000021900', u'ENSMUSG00000042453', u'ENSMUSG00000030894', u'ENSMUSG00000016028']), symbols=u'Adgra2 Btd Celsr1 Chd7 Cntn2 Gli3 Hapln2 Id3 Mbp Reln Smo Sox9 Tpp1 Trp53bp2 Vcan Zic2', symbol_set=set([u'Smo', u'Sox9', u'Celsr1', u'Chd7', u'Btd', u'Tpp1', u'Vcan', u'Id3', u'Trp53bp2', u'Cntn2', u'Gli3', 'Adgra2', u'Zic2', u'Reln', u'Mbp', u'Hapln2']), geneids='ENSMUSG00000021900 ENSMUSG00000001761 ENSMUSG00000000567 ENSMUSG00000007872 ENSMUSG00000031486 ENSMUSG00000041235 ENSMUSG00000061524 ENSMUSG00000026510 ENSMUSG00000004894 ENSMUSG00000053024 ENSMUSG00000041607 ENSMUSG00000021614 ENSMUSG00000042453 ENSMUSG00000021318 ENSMUSG00000030894 ENSMUSG00000016028', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=0, D1='E', GO_name='central nervous system development'),
    Nt(p_uncorrected='', study_count='', study_n='', namespace='', p_fdr_bh='', study_items='', NS='BP', pop_items='', pop_n='', p_sm_bonferroni='', is_obsolete='', GO='GO:0050767', name='', pop_count='', alt_ids='', level=6, depth=6, enrichment='', Cluster='', geneid_set='', symbols='', symbol_set='', geneids='', format_txt=1, hdr_idx=1, is_hdrgo=True, is_usrgo=False, hdr1usr01='*', dcnt=208, D1='A', GO_name='regulation of neurogenesis'),
    Nt(p_uncorrected=0.0005660627202574551, study_count=6, study_n=1397, namespace='biological_process', p_fdr_bh=0.042041256248140695, study_items=set([u'ENSMUSG00000021948', u'ENSMUSG00000026288', u'ENSMUSG00000024610', u'ENSMUSG00000073418', u'ENSMUSG00000026656', u'ENSMUSG00000076617']), NS='BP', pop_items=set([u'ENSMUSG00000021948', u'ENSMUSG00000028191', u'ENSMUSG00000032508', u'ENSMUSG00000025498', u'ENSMUSG00000024610', u'ENSMUSG00000073418', u'ENSMUSG00000026288', u'ENSMUSG00000030748', u'ENSMUSG00000037649', u'ENSMUSG00000026656', u'ENSMUSG00000076617', u'ENSMUSG00000058715']), pop_n=13836, p_sm_bonferroni=1.0, is_obsolete=False, GO='GO:0016064', name='immunoglobulin mediated immune response', pop_count=12, alt_ids=[], level=6, depth=6, enrichment='e', Cluster='Late Increase', geneid_set=set([u'ENSMUSG00000021948', u'ENSMUSG00000076617', u'ENSMUSG00000026656', u'ENSMUSG00000026288', u'ENSMUSG00000024610', u'ENSMUSG00000073418']), symbols=u'C4b Cd74 Fcgr2b Ighm Inpp5d Prkcd', symbol_set=set([u'Cd74', u'Inpp5d', u'Fcgr2b', u'Prkcd', u'C4b', u'Ighm']), geneids='ENSMUSG00000021948 ENSMUSG00000026288 ENSMUSG00000024610 ENSMUSG00000073418 ENSMUSG00000026656 ENSMUSG00000076617', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=11, D1='FL', GO_name='immunoglobulin mediated immune response'),
    Nt(p_uncorrected='', study_count='', study_n='', namespace='', p_fdr_bh='', study_items='', NS='BP', pop_items='', pop_n='', p_sm_bonferroni='', is_obsolete='', GO='GO:0002521', name='', pop_count='', alt_ids='', level=5, depth=5, enrichment='', Cluster='', geneid_set='', symbols='', symbol_set='', geneids='', format_txt=1, hdr_idx=1, is_hdrgo=True, is_usrgo=False, hdr1usr01='*', dcnt=72, D1='BCE', GO_name='leukocyte differentiation'),
    Nt(p_uncorrected=0.00047594319969878284, study_count=4, study_n=1397, namespace='biological_process', p_fdr_bh=0.0381597084052771, study_items=set([u'ENSMUSG00000026288', u'ENSMUSG00000004043', u'ENSMUSG00000022488', u'ENSMUSG00000020919']), NS='BP', pop_items=set([u'ENSMUSG00000026288', u'ENSMUSG00000004043', u'ENSMUSG00000022488', u'ENSMUSG00000020919', u'ENSMUSG00000031304']), pop_n=13836, p_sm_bonferroni=1.0, is_obsolete=False, GO='GO:0045621', name='positive regulation of lymphocyte differentiation', pop_count=5, alt_ids=[], level=7, depth=8, enrichment='e', Cluster='Late Increase', geneid_set=set([u'ENSMUSG00000026288', u'ENSMUSG00000004043', u'ENSMUSG00000022488', u'ENSMUSG00000020919']), symbols=u'Inpp5d Nckap1l Stat5a Stat5b', symbol_set=set([u'Stat5b', u'Stat5a', u'Nckap1l', u'Inpp5d']), geneids='ENSMUSG00000026288 ENSMUSG00000004043 ENSMUSG00000022488 ENSMUSG00000020919', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=28, D1='A', GO_name='positive regulation of lymphocyte differentiation'),
    Nt(p_uncorrected=0.00015597551367383584, study_count=9, study_n=1397, namespace='biological_process', p_fdr_bh=0.016411006997724215, study_items=set([u'ENSMUSG00000019054', u'ENSMUSG00000020372', u'ENSMUSG00000032633', u'ENSMUSG00000020486', u'ENSMUSG00000027381', u'ENSMUSG00000022037', u'ENSMUSG00000074170', u'ENSMUSG00000007655', u'ENSMUSG00000020733']), NS='BP', pop_items=set([u'ENSMUSG00000003873', u'ENSMUSG00000002015', u'ENSMUSG00000062762', u'ENSMUSG00000027381', u'ENSMUSG00000059552', u'ENSMUSG00000022789', u'ENSMUSG00000029821', u'ENSMUSG00000027379', u'ENSMUSG00000022037', u'ENSMUSG00000074170', u'ENSMUSG00000036840', u'ENSMUSG00000020733', u'ENSMUSG00000020372', u'ENSMUSG00000032633', u'ENSMUSG00000019054', u'ENSMUSG00000026278', u'ENSMUSG00000002083', u'ENSMUSG00000051413', u'ENSMUSG00000002731', u'ENSMUSG00000020486', u'ENSMUSG00000007655', u'ENSMUSG00000037608']), pop_n=13836, p_sm_bonferroni=1.0, is_obsolete=False, GO='GO:2001244', name='positive regulation of intrinsic apoptotic signaling pathway', pop_count=22, alt_ids=[], level=7, depth=9, enrichment='e', Cluster='Late Increase', geneid_set=set([u'ENSMUSG00000027381', u'ENSMUSG00000020372', u'ENSMUSG00000032633', u'ENSMUSG00000020486', u'ENSMUSG00000019054', u'ENSMUSG00000022037', u'ENSMUSG00000074170', u'ENSMUSG00000007655', u'ENSMUSG00000020733']), symbols=u'Bcl2l11 Cav1 Clu Fis1 Flcn Plekhf1 Rack1 Sept4 Slc9a3r1', symbol_set=set([u'Flcn', u'Bcl2l11', u'Slc9a3r1', u'Plekhf1', u'Fis1', 'Sept4', u'Clu', u'Cav1', 'Rack1']), geneids='ENSMUSG00000027381 ENSMUSG00000020372 ENSMUSG00000032633 ENSMUSG00000020486 ENSMUSG00000019054 ENSMUSG00000022037 ENSMUSG00000074170 ENSMUSG00000007655 ENSMUSG00000020733', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=10, D1='A', GO_name='positive regulation of intrinsic apoptotic signaling pathway'),
    Nt(p_uncorrected=1.1941726761129497e-05, study_count=5, study_n=1397, namespace='biological_process', p_fdr_bh=0.002179868700697265, study_items=set([u'ENSMUSG00000062078', u'ENSMUSG00000027763', u'ENSMUSG00000050335', u'ENSMUSG00000006498', u'ENSMUSG00000028821']), NS='BP', pop_items=set([u'ENSMUSG00000028180', u'ENSMUSG00000030216', u'ENSMUSG00000039148', u'ENSMUSG00000062604', u'ENSMUSG00000021716', u'ENSMUSG00000021713', u'ENSMUSG00000032621', u'ENSMUSG00000018379', u'ENSMUSG00000020863', u'ENSMUSG00000024604', u'ENSMUSG00000031683', u'ENSMUSG00000059005', u'ENSMUSG00000021494', u'ENSMUSG00000001767', u'ENSMUSG00000005506', u'ENSMUSG00000046201', u'ENSMUSG00000032423', u'ENSMUSG00000040767', u'ENSMUSG00000019470', u'ENSMUSG00000061479', u'ENSMUSG00000028820', u'ENSMUSG00000028821', u'ENSMUSG00000034120', u'ENSMUSG00000022774', u'ENSMUSG00000021413', u'ENSMUSG00000007670', u'ENSMUSG00000024287', u'ENSMUSG00000028330', u'ENSMUSG00000018974', u'ENSMUSG00000034544', u'ENSMUSG00000033712', u'ENSMUSG00000056305', u'ENSMUSG00000020180', u'ENSMUSG00000023932', u'ENSMUSG00000032940', u'ENSMUSG00000030204', u'ENSMUSG00000034931', u'ENSMUSG00000028134', u'ENSMUSG00000028137', u'ENSMUSG00000059708', u'ENSMUSG00000030056', u'ENSMUSG00000031060', u'ENSMUSG00000034274', u'ENSMUSG00000027014', u'ENSMUSG00000035125', u'ENSMUSG00000031189', u'ENSMUSG00000003660', u'ENSMUSG00000042502', u'ENSMUSG00000054679', u'ENSMUSG00000053453', u'ENSMUSG00000015656', u'ENSMUSG00000021810', u'ENSMUSG00000034889', u'ENSMUSG00000078765', u'ENSMUSG00000004865', u'ENSMUSG00000027404', u'ENSMUSG00000090553', u'ENSMUSG00000029538', u'ENSMUSG00000024384', u'ENSMUSG00000029439', u'ENSMUSG00000055760', u'ENSMUSG00000038446', u'ENSMUSG00000035597', u'ENSMUSG00000003119', u'ENSMUSG00000018446', u'ENSMUSG00000060121', u'ENSMUSG00000025134', u'ENSMUSG00000028882', u'ENSMUSG00000041319', u'ENSMUSG00000028639', u'ENSMUSG00000060373', u'ENSMUSG00000031370', u'ENSMUSG00000030016', u'ENSMUSG00000061136', u'ENSMUSG00000040383', u'ENSMUSG00000078676', u'ENSMUSG00000028809', u'ENSMUSG00000005687', u'ENSMUSG00000071172', u'ENSMUSG00000022858', u'ENSMUSG00000027881', u'ENSMUSG00000021134', u'ENSMUSG00000020409', u'ENSMUSG00000029427', u'ENSMUSG00000039218', u'ENSMUSG00000028676', u'ENSMUSG00000041777', u'ENSMUSG00000025024', u'ENSMUSG00000020994', u'ENSMUSG00000031157', u'ENSMUSG00000022635', u'ENSMUSG00000031311', u'ENSMUSG00000024007', u'ENSMUSG00000008373', u'ENSMUSG00000029701', u'ENSMUSG00000037475', u'ENSMUSG00000061028', u'ENSMUSG00000023007', u'ENSMUSG00000002477', u'ENSMUSG00000007050', u'ENSMUSG00000043962', u'ENSMUSG00000040621', u'ENSMUSG00000037070', u'ENSMUSG00000022023', u'ENSMUSG00000059208', u'ENSMUSG00000050188', u'ENSMUSG00000032580', u'ENSMUSG00000074088', u'ENSMUSG00000020719', u'ENSMUSG00000029169', u'ENSMUSG00000052144', u'ENSMUSG00000033760', u'ENSMUSG00000028651', u'ENSMUSG00000034681', u'ENSMUSG00000037361', u'ENSMUSG00000009076', u'ENSMUSG00000008658', u'ENSMUSG00000037275', u'ENSMUSG00000020850', u'ENSMUSG00000043639', u'ENSMUSG00000040720', u'ENSMUSG00000040824', u'ENSMUSG00000027620', u'ENSMUSG00000021519', u'ENSMUSG00000011306', u'ENSMUSG00000008333', u'ENSMUSG00000005150', u'ENSMUSG00000001158', u'ENSMUSG00000032078', u'ENSMUSG00000022139', u'ENSMUSG00000025982', u'ENSMUSG00000066148', u'ENSMUSG00000029290', u'ENSMUSG00000031134', u'ENSMUSG00000092607', u'ENSMUSG00000029402', u'ENSMUSG00000016921', u'ENSMUSG00000029404', u'ENSMUSG00000005481', u'ENSMUSG00000037197', u'ENSMUSG00000032040', u'ENSMUSG00000029279', u'ENSMUSG00000004980', u'ENSMUSG00000028382', u'ENSMUSG00000061360', u'ENSMUSG00000021546', u'ENSMUSG00000004096', u'ENSMUSG00000027593', u'ENSMUSG00000060475', u'ENSMUSG00000033565', u'ENSMUSG00000024735', u'ENSMUSG00000022961', u'ENSMUSG00000056962', u'ENSMUSG00000038406', u'ENSMUSG00000002455', u'ENSMUSG00000063800', u'ENSMUSG00000003527', u'ENSMUSG00000026273', u'ENSMUSG00000025872', u'ENSMUSG00000062078', u'ENSMUSG00000039630', u'ENSMUSG00000035851', u'ENSMUSG00000041297', u'ENSMUSG00000000838', u'ENSMUSG00000044155', u'ENSMUSG00000042079', u'ENSMUSG00000002524', u'ENSMUSG00000028911', u'ENSMUSG00000031723', u'ENSMUSG00000030435', u'ENSMUSG00000027763', u'ENSMUSG00000078348', u'ENSMUSG00000024097', u'ENSMUSG00000015748', u'ENSMUSG00000063919', u'ENSMUSG00000037296', u'ENSMUSG00000006498', u'ENSMUSG00000037958', u'ENSMUSG00000068856', u'ENSMUSG00000021645', u'ENSMUSG00000031792', u'ENSMUSG00000030224', u'ENSMUSG00000021431', u'ENSMUSG00000031848', u'ENSMUSG00000033732', u'ENSMUSG00000026035', u'ENSMUSG00000002129', u'ENSMUSG00000020018', u'ENSMUSG00000007850', u'ENSMUSG00000074102', u'ENSMUSG00000021039', u'ENSMUSG00000090115', u'ENSMUSG00000029817', u'ENSMUSG00000031590', u'ENSMUSG00000022283', u'ENSMUSG00000002052', u'ENSMUSG00000024949', u'ENSMUSG00000030512', u'ENSMUSG00000050335', u'ENSMUSG00000021500', u'ENSMUSG00000010608', u'ENSMUSG00000033228', u'ENSMUSG00000022185', u'ENSMUSG00000028902', u'ENSMUSG00000029345', u'ENSMUSG00000016018', u'ENSMUSG00000027998', u'ENSMUSG00000036054', u'ENSMUSG00000033222', u'ENSMUSG00000041459', u'ENSMUSG00000024268', u'ENSMUSG00000028609', u'ENSMUSG00000019432', u'ENSMUSG00000025576', u'ENSMUSG00000020929', u'ENSMUSG00000039449', u'ENSMUSG00000027905']), pop_n=13836, p_sm_bonferroni=0.180929102157873, is_obsolete=False, GO='GO:0008380', name='RNA splicing', pop_count=217, alt_ids=['GO:0006395'], level=6, depth=8, enrichment='p', Cluster='Late Increase', geneid_set=set([u'ENSMUSG00000028821', u'ENSMUSG00000027763', u'ENSMUSG00000050335', u'ENSMUSG00000006498', u'ENSMUSG00000062078']), symbols=u'Lgals3 Mbnl1 Ptbp1 Qk Syf2', symbol_set=set([u'Lgals3', u'Mbnl1', u'Ptbp1', u'Syf2', u'Qk']), geneids='ENSMUSG00000028821 ENSMUSG00000006498 ENSMUSG00000050335 ENSMUSG00000062078 ENSMUSG00000027763', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=17, D1='BD', GO_name='RNA splicing'),
    Nt(p_uncorrected='', study_count='', study_n='', namespace='', p_fdr_bh='', study_items='', NS='BP', pop_items='', pop_n='', p_sm_bonferroni='', is_obsolete='', GO='GO:1903037', name='', pop_count='', alt_ids='', level=5, depth=5, enrichment='', Cluster='', geneid_set='', symbols='', symbol_set='', geneids='', format_txt=1, hdr_idx=1, is_hdrgo=True, is_usrgo=False, hdr1usr01='*', dcnt=155, D1='A', GO_name='regulation of leukocyte cell-cell adhesion'),
    Nt(p_uncorrected=4.943568246906912e-07, study_count=62, study_n=1397, namespace='biological_process', p_fdr_bh=0.00017022727842928777, study_items=set([u'ENSMUSG00000061436', u'ENSMUSG00000045092', u'ENSMUSG00000026923', u'ENSMUSG00000021756', u'ENSMUSG00000062209', u'ENSMUSG00000013584', u'ENSMUSG00000068290', u'ENSMUSG00000003031', u'ENSMUSG00000042312', u'ENSMUSG00000026193', u'ENSMUSG00000019997', u'ENSMUSG00000036585', u'ENSMUSG00000031565', u'ENSMUSG00000024913', u'ENSMUSG00000022505', u'ENSMUSG00000048402', u'ENSMUSG00000020919', u'ENSMUSG00000050335', u'ENSMUSG00000001761', u'ENSMUSG00000032562', u'ENSMUSG00000024620', u'ENSMUSG00000027985', u'ENSMUSG00000028864', u'ENSMUSG00000019803', u'ENSMUSG00000053110', u'ENSMUSG00000048376', u'ENSMUSG00000018500', u'ENSMUSG00000028821', u'ENSMUSG00000022037', u'ENSMUSG00000032359', u'ENSMUSG00000040152', u'ENSMUSG00000027447', u'ENSMUSG00000032725', u'ENSMUSG00000020053', u'ENSMUSG00000073889', u'ENSMUSG00000037706', u'ENSMUSG00000020422', u'ENSMUSG00000025809', u'ENSMUSG00000021822', u'ENSMUSG00000029999', u'ENSMUSG00000020357', u'ENSMUSG00000026674', u'ENSMUSG00000020467', u'ENSMUSG00000006333', u'ENSMUSG00000030849', u'ENSMUSG00000020122', u'ENSMUSG00000021379', u'ENSMUSG00000055254', u'ENSMUSG00000027878', u'ENSMUSG00000039191', u'ENSMUSG00000000567', u'ENSMUSG00000004043', u'ENSMUSG00000057329', u'ENSMUSG00000054693', u'ENSMUSG00000033208', u'ENSMUSG00000062312', u'ENSMUSG00000007613', u'ENSMUSG00000032006', u'ENSMUSG00000020644', u'ENSMUSG00000022122', u'ENSMUSG00000032035', u'ENSMUSG00000028982']), NS='BP', pop_items=set([u'ENSMUSG00000028224', u'ENSMUSG00000014773', u'ENSMUSG00000068154', u'ENSMUSG00000022831', u'ENSMUSG00000030093', u'ENSMUSG00000062604', u'ENSMUSG00000025856', u'ENSMUSG00000001288', u'ENSMUSG00000015994', u'ENSMUSG00000001910', u'ENSMUSG00000019997', u'ENSMUSG00000021342', u'ENSMUSG00000036585', u'ENSMUSG00000018500', u'ENSMUSG00000018501', u'ENSMUSG00000051790', u'ENSMUSG00000002250', u'ENSMUSG00000030849', u'ENSMUSG00000001761', u'ENSMUSG00000018160', u'ENSMUSG00000002489', u'ENSMUSG00000004043', u'ENSMUSG00000030846', u'ENSMUSG00000048376', u'ENSMUSG00000006932', u'ENSMUSG00000032035', u'ENSMUSG00000053110', u'ENSMUSG00000052534', u'ENSMUSG00000070348', u'ENSMUSG00000021732', u'ENSMUSG00000019966', u'ENSMUSG00000021109', u'ENSMUSG00000022770', u'ENSMUSG00000019777', u'ENSMUSG00000016319', u'ENSMUSG00000004266', u'ENSMUSG00000028333', u'ENSMUSG00000027947', u'ENSMUSG00000010797', u'ENSMUSG00000020422', u'ENSMUSG00000032492', u'ENSMUSG00000059146', u'ENSMUSG00000039239', u'ENSMUSG00000000489', u'ENSMUSG00000033417', u'ENSMUSG00000003814', u'ENSMUSG00000025499', u'ENSMUSG00000039662', u'ENSMUSG00000029337', u'ENSMUSG00000031537', u'ENSMUSG00000032397', u'ENSMUSG00000030760', u'ENSMUSG00000031575', u'ENSMUSG00000000561', u'ENSMUSG00000030057', u'ENSMUSG00000007888', u'ENSMUSG00000003228', u'ENSMUSG00000027651', u'ENSMUSG00000000567', u'ENSMUSG00000034724', u'ENSMUSG00000021822', u'ENSMUSG00000056947', u'ENSMUSG00000006398', u'ENSMUSG00000032253', u'ENSMUSG00000024477', u'ENSMUSG00000014599', u'ENSMUSG00000026628', u'ENSMUSG00000004508', u'ENSMUSG00000027087', u'ENSMUSG00000029283', u'ENSMUSG00000059456', u'ENSMUSG00000033940', u'ENSMUSG00000016477', u'ENSMUSG00000059363', u'ENSMUSG00000020074', u'ENSMUSG00000031870', u'ENSMUSG00000061436', u'ENSMUSG00000026672', u'ENSMUSG00000055447', u'ENSMUSG00000013663', u'ENSMUSG00000020362', u'ENSMUSG00000032487', u'ENSMUSG00000013584', u'ENSMUSG00000015709', u'ENSMUSG00000006517', u'ENSMUSG00000028019', u'ENSMUSG00000033208', u'ENSMUSG00000027835', u'ENSMUSG00000018442', u'ENSMUSG00000038894', u'ENSMUSG00000028444', u'ENSMUSG00000005672', u'ENSMUSG00000024913', u'ENSMUSG00000045515', u'ENSMUSG00000052684', u'ENSMUSG00000030283', u'ENSMUSG00000032565', u'ENSMUSG00000045983', u'ENSMUSG00000004473', u'ENSMUSG00000028639', u'ENSMUSG00000037010', u'ENSMUSG00000047146', u'ENSMUSG00000022528', u'ENSMUSG00000029838', u'ENSMUSG00000045730', u'ENSMUSG00000021779', u'ENSMUSG00000019803', u'ENSMUSG00000041498', u'ENSMUSG00000040359', u'ENSMUSG00000054263', u'ENSMUSG00000022010', u'ENSMUSG00000028800', u'ENSMUSG00000027523', u'ENSMUSG00000029053', u'ENSMUSG00000061887', u'ENSMUSG00000027524', u'ENSMUSG00000011179', u'ENSMUSG00000020053', u'ENSMUSG00000062209', u'ENSMUSG00000069135', u'ENSMUSG00000026313', u'ENSMUSG00000030265', u'ENSMUSG00000021175', u'ENSMUSG00000037706', u'ENSMUSG00000020357', u'ENSMUSG00000025358', u'ENSMUSG00000023912', u'ENSMUSG00000003283', u'ENSMUSG00000004791', u'ENSMUSG00000020902', u'ENSMUSG00000034855', u'ENSMUSG00000055254', u'ENSMUSG00000033373', u'ENSMUSG00000027803', u'ENSMUSG00000028397', u'ENSMUSG00000078812', u'ENSMUSG00000067847', u'ENSMUSG00000022540', u'ENSMUSG00000039191', u'ENSMUSG00000030774', u'ENSMUSG00000024997', u'ENSMUSG00000041710', u'ENSMUSG00000001300', u'ENSMUSG00000054693', u'ENSMUSG00000020467', u'ENSMUSG00000061353', u'ENSMUSG00000005373', u'ENSMUSG00000041488', u'ENSMUSG00000030898', u'ENSMUSG00000056481', u'ENSMUSG00000022146', u'ENSMUSG00000020644', u'ENSMUSG00000021974', u'ENSMUSG00000048154', u'ENSMUSG00000020122', u'ENSMUSG00000031393', u'ENSMUSG00000035109', u'ENSMUSG00000031380', u'ENSMUSG00000026923', u'ENSMUSG00000036923', u'ENSMUSG00000021670', u'ENSMUSG00000021756', u'ENSMUSG00000023951', u'ENSMUSG00000024620', u'ENSMUSG00000047945', u'ENSMUSG00000033762', u'ENSMUSG00000028261', u'ENSMUSG00000003031', u'ENSMUSG00000050697', u'ENSMUSG00000042312', u'ENSMUSG00000032185', u'ENSMUSG00000027878', u'ENSMUSG00000017548', u'ENSMUSG00000031723', u'ENSMUSG00000030397', u'ENSMUSG00000050192', u'ENSMUSG00000033249', u'ENSMUSG00000006134', u'ENSMUSG00000010175', u'ENSMUSG00000020919', u'ENSMUSG00000030805', u'ENSMUSG00000024927', u'ENSMUSG00000057342', u'ENSMUSG00000002603', u'ENSMUSG00000087679', u'ENSMUSG00000048001', u'ENSMUSG00000022382', u'ENSMUSG00000024621', u'ENSMUSG00000028864', u'ENSMUSG00000062960', u'ENSMUSG00000026193', u'ENSMUSG00000037992', u'ENSMUSG00000049107', u'ENSMUSG00000034997', u'ENSMUSG00000031314', u'ENSMUSG00000005469', u'ENSMUSG00000022037', u'ENSMUSG00000027506', u'ENSMUSG00000008683', u'ENSMUSG00000038984', u'ENSMUSG00000040152', u'ENSMUSG00000001131', u'ENSMUSG00000024232', u'ENSMUSG00000056220', u'ENSMUSG00000073616', u'ENSMUSG00000059588', u'ENSMUSG00000020235', u'ENSMUSG00000057113', u'ENSMUSG00000034165', u'ENSMUSG00000053647', u'ENSMUSG00000025809', u'ENSMUSG00000028821', u'ENSMUSG00000001435', u'ENSMUSG00000006356', u'ENSMUSG00000033751', u'ENSMUSG00000042228', u'ENSMUSG00000048402', u'ENSMUSG00000031601', u'ENSMUSG00000020063', u'ENSMUSG00000030538', u'ENSMUSG00000044562', u'ENSMUSG00000037846', u'ENSMUSG00000040274', u'ENSMUSG00000061589', u'ENSMUSG00000022607', u'ENSMUSG00000034563', u'ENSMUSG00000057329', u'ENSMUSG00000031548', u'ENSMUSG00000035000', u'ENSMUSG00000020496', u'ENSMUSG00000062312', u'ENSMUSG00000017491', u'ENSMUSG00000020515', u'ENSMUSG00000006728', u'ENSMUSG00000037169', u'ENSMUSG00000022122', u'ENSMUSG00000039781', u'ENSMUSG00000061878', u'ENSMUSG00000026674', u'ENSMUSG00000002731', u'ENSMUSG00000055817', u'ENSMUSG00000044014', u'ENSMUSG00000073889', u'ENSMUSG00000028364', u'ENSMUSG00000007613', u'ENSMUSG00000068290', u'ENSMUSG00000038279', u'ENSMUSG00000008730', u'ENSMUSG00000024795', u'ENSMUSG00000031750', u'ENSMUSG00000043991', u'ENSMUSG00000029287', u'ENSMUSG00000021360', u'ENSMUSG00000005534', u'ENSMUSG00000021994', u'ENSMUSG00000031616', u'ENSMUSG00000022505', u'ENSMUSG00000052957', u'ENSMUSG00000020484', u'ENSMUSG00000032187', u'ENSMUSG00000050335', u'ENSMUSG00000024486', u'ENSMUSG00000022346', u'ENSMUSG00000031446', u'ENSMUSG00000024073', u'ENSMUSG00000076431', u'ENSMUSG00000027985', u'ENSMUSG00000000127', u'ENSMUSG00000063632', u'ENSMUSG00000030525', u'ENSMUSG00000031565', u'ENSMUSG00000021835', u'ENSMUSG00000085795', u'ENSMUSG00000046532', u'ENSMUSG00000038007', u'ENSMUSG00000026104', u'ENSMUSG00000022425', u'ENSMUSG00000032359', u'ENSMUSG00000000751', u'ENSMUSG00000025403', u'ENSMUSG00000027447', u'ENSMUSG00000032725', u'ENSMUSG00000045092', u'ENSMUSG00000034394', u'ENSMUSG00000001517', u'ENSMUSG00000038260', u'ENSMUSG00000029231', u'ENSMUSG00000039153', u'ENSMUSG00000029999', u'ENSMUSG00000026479', u'ENSMUSG00000024789', u'ENSMUSG00000068037', u'ENSMUSG00000038943', u'ENSMUSG00000028291', u'ENSMUSG00000052593', u'ENSMUSG00000031980', u'ENSMUSG00000021379', u'ENSMUSG00000030890', u'ENSMUSG00000042680', u'ENSMUSG00000000184', u'ENSMUSG00000074698', u'ENSMUSG00000028982', u'ENSMUSG00000032006', u'ENSMUSG00000032562', u'ENSMUSG00000029175', u'ENSMUSG00000054387', u'ENSMUSG00000033220', u'ENSMUSG00000057506', u'ENSMUSG00000004040', u'ENSMUSG00000024256', u'ENSMUSG00000054252', u'ENSMUSG00000027859', u'ENSMUSG00000048616', u'ENSMUSG00000062352', u'ENSMUSG00000028249', u'ENSMUSG00000032532', u'ENSMUSG00000007659', u'ENSMUSG00000006333', u'ENSMUSG00000054302', u'ENSMUSG00000018604', u'ENSMUSG00000016308', u'ENSMUSG00000025578']), pop_n=13836, p_sm_bonferroni=0.0074900002508886615, is_obsolete=False, GO='GO:0008284', name='positive regulation of cell proliferation', pop_count=322, alt_ids=[], level=5, depth=5, enrichment='e', Cluster='Late Increase', geneid_set=set([u'ENSMUSG00000061436', u'ENSMUSG00000020053', u'ENSMUSG00000026923', u'ENSMUSG00000021756', u'ENSMUSG00000073889', u'ENSMUSG00000013584', u'ENSMUSG00000068290', u'ENSMUSG00000003031', u'ENSMUSG00000042312', u'ENSMUSG00000026193', u'ENSMUSG00000019997', u'ENSMUSG00000019803', u'ENSMUSG00000031565', u'ENSMUSG00000024913', u'ENSMUSG00000022505', u'ENSMUSG00000048402', u'ENSMUSG00000020919', u'ENSMUSG00000050335', u'ENSMUSG00000001761', u'ENSMUSG00000032562', u'ENSMUSG00000024620', u'ENSMUSG00000027985', u'ENSMUSG00000028864', u'ENSMUSG00000036585', u'ENSMUSG00000053110', u'ENSMUSG00000048376', u'ENSMUSG00000018500', u'ENSMUSG00000028821', u'ENSMUSG00000022037', u'ENSMUSG00000032359', u'ENSMUSG00000027447', u'ENSMUSG00000032725', u'ENSMUSG00000045092', u'ENSMUSG00000062209', u'ENSMUSG00000020422', u'ENSMUSG00000025809', u'ENSMUSG00000021822', u'ENSMUSG00000029999', u'ENSMUSG00000000567', u'ENSMUSG00000020357', u'ENSMUSG00000026674', u'ENSMUSG00000020467', u'ENSMUSG00000006333', u'ENSMUSG00000030849', u'ENSMUSG00000020122', u'ENSMUSG00000021379', u'ENSMUSG00000055254', u'ENSMUSG00000027878', u'ENSMUSG00000039191', u'ENSMUSG00000040152', u'ENSMUSG00000004043', u'ENSMUSG00000057329', u'ENSMUSG00000054693', u'ENSMUSG00000033208', u'ENSMUSG00000062312', u'ENSMUSG00000007613', u'ENSMUSG00000032006', u'ENSMUSG00000020644', u'ENSMUSG00000022122', u'ENSMUSG00000037706', u'ENSMUSG00000028982', u'ENSMUSG00000032035']), symbols=u'Adam10 Adora2b Aldh1a2 Bcl2 Cd81 Cdkn1b Clu Cst3 Ctgf Ctsh Ddr2 Ddrgk1 Ednrb Efemp1 Egfr Emp2 Erbb2 Erbb4 Ets1 F2r Fgf1 Fgfr1 Fgfr2 Flt4 Fn1 Folr2 Gli2 Gnai2 Hgf Hipk2 Id2 Id4 Igf1 Il11ra1 Il6st Itgb1 Lef1 Lgals3 Lrp5 Notch1 Notch2 Nr2e1 Ntrk2 Pdgfd Pdgfrb Plau Rbpj Rps9 S100a13 S100b S1pr1 Slc25a33 Smo Sox9 Stat5a Stat5b Syf2 Tgfa Tgfbr1 Thbs1 Tns3 Yap1', symbol_set=set([u'Adora2b', u'Igf1', u'Folr2', u'Fn1', u'Egfr', u'Id4', u'Id2', u'Smo', u'Hgf', u'Ctgf', u'Notch2', u'Lgals3', u'Clu', u'Lef1', u'Ednrb', u'Yap1', u'Ctsh', u'Lrp5', u'Ddr2', u'Notch1', u'Plau', u'Adam10', u'Cd81', u'Emp2', u'Fgf1', u'Slc25a33', u'Tns3', u'S100a13', u'Gnai2', u'Rbpj', u'Fgfr1', u'Tgfa', u'Itgb1', u'Tgfbr1', u'Syf2', u'S100b', u'Efemp1', u'Cdkn1b', u'Ntrk2', u'Thbs1', u'F2r', u'Sox9', u'Nr2e1', u'Pdgfd', u'Flt4', u'Aldh1a2', u'Erbb2', u'Pdgfrb', u'Erbb4', u'Hipk2', u'Fgfr2', u'S1pr1', u'Il11ra1', u'Il6st', u'Gli2', u'Stat5b', u'Stat5a', u'Ets1', u'Ddrgk1', u'Rps9', u'Cst3', u'Bcl2']), geneids='ENSMUSG00000061436 ENSMUSG00000026674 ENSMUSG00000026923 ENSMUSG00000036585 ENSMUSG00000021756 ENSMUSG00000073889 ENSMUSG00000013584 ENSMUSG00000068290 ENSMUSG00000003031 ENSMUSG00000042312 ENSMUSG00000026193 ENSMUSG00000019997 ENSMUSG00000032035 ENSMUSG00000031565 ENSMUSG00000024913 ENSMUSG00000018500 ENSMUSG00000048402 ENSMUSG00000020919 ENSMUSG00000030849 ENSMUSG00000001761 ENSMUSG00000032562 ENSMUSG00000024620 ENSMUSG00000027985 ENSMUSG00000028864 ENSMUSG00000019803 ENSMUSG00000053110 ENSMUSG00000048376 ENSMUSG00000022505 ENSMUSG00000021822 ENSMUSG00000022037 ENSMUSG00000032359 ENSMUSG00000040152 ENSMUSG00000027447 ENSMUSG00000032725 ENSMUSG00000020053 ENSMUSG00000062209 ENSMUSG00000037706 ENSMUSG00000020422 ENSMUSG00000025809 ENSMUSG00000028821 ENSMUSG00000029999 ENSMUSG00000020357 ENSMUSG00000020467 ENSMUSG00000020122 ENSMUSG00000050335 ENSMUSG00000021379 ENSMUSG00000055254 ENSMUSG00000027878 ENSMUSG00000045092 ENSMUSG00000039191 ENSMUSG00000000567 ENSMUSG00000004043 ENSMUSG00000057329 ENSMUSG00000054693 ENSMUSG00000033208 ENSMUSG00000062312 ENSMUSG00000007613 ENSMUSG00000032006 ENSMUSG00000020644 ENSMUSG00000022122 ENSMUSG00000006333 ENSMUSG00000028982', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=88, D1='A', GO_name='positive regulation of cell proliferation'),
    Nt(p_uncorrected=8.476830300089806e-06, study_count=51, study_n=1397, namespace='biological_process', p_fdr_bh=0.0016257272895779829, study_items=set([u'ENSMUSG00000026932', u'ENSMUSG00000026923', u'ENSMUSG00000030798', u'ENSMUSG00000013584', u'ENSMUSG00000003031', u'ENSMUSG00000036478', u'ENSMUSG00000021340', u'ENSMUSG00000025352', u'ENSMUSG00000018500', u'ENSMUSG00000028207', u'ENSMUSG00000034957', u'ENSMUSG00000059182', u'ENSMUSG00000030849', u'ENSMUSG00000026249', u'ENSMUSG00000017466', u'ENSMUSG00000026288', u'ENSMUSG00000032440', u'ENSMUSG00000038168', u'ENSMUSG00000042284', u'ENSMUSG00000031785', u'ENSMUSG00000048376', u'ENSMUSG00000015149', u'ENSMUSG00000007655', u'ENSMUSG00000032737', u'ENSMUSG00000022018', u'ENSMUSG00000020053', u'ENSMUSG00000062209', u'ENSMUSG00000038539', u'ENSMUSG00000003534', u'ENSMUSG00000025809', u'ENSMUSG00000030342', u'ENSMUSG00000000708', u'ENSMUSG00000024087', u'ENSMUSG00000032194', u'ENSMUSG00000021318', u'ENSMUSG00000027878', u'ENSMUSG00000027168', u'ENSMUSG00000037003', u'ENSMUSG00000040055', u'ENSMUSG00000039191', u'ENSMUSG00000000567', u'ENSMUSG00000005125', u'ENSMUSG00000057329', u'ENSMUSG00000020733', u'ENSMUSG00000047407', u'ENSMUSG00000050953', u'ENSMUSG00000041556', u'ENSMUSG00000035342', u'ENSMUSG00000000058', u'ENSMUSG00000031871', u'ENSMUSG00000018217']), NS='BP', pop_items=set([u'ENSMUSG00000024077', u'ENSMUSG00000003873', u'ENSMUSG00000047904', u'ENSMUSG00000000902', u'ENSMUSG00000020262', u'ENSMUSG00000024079', u'ENSMUSG00000008999', u'ENSMUSG00000031681', u'ENSMUSG00000031060', u'ENSMUSG00000001288', u'ENSMUSG00000034926', u'ENSMUSG00000059552', u'ENSMUSG00000025352', u'ENSMUSG00000029610', u'ENSMUSG00000006818', u'ENSMUSG00000023809', u'ENSMUSG00000018500', u'ENSMUSG00000034957', u'ENSMUSG00000026313', u'ENSMUSG00000022369', u'ENSMUSG00000021318', u'ENSMUSG00000030849', u'ENSMUSG00000026249', u'ENSMUSG00000052488', u'ENSMUSG00000024462', u'ENSMUSG00000006362', u'ENSMUSG00000040003', u'ENSMUSG00000006932', u'ENSMUSG00000005871', u'ENSMUSG00000057113', u'ENSMUSG00000034329', u'ENSMUSG00000020891', u'ENSMUSG00000032402', u'ENSMUSG00000027878', u'ENSMUSG00000026812', u'ENSMUSG00000027792', u'ENSMUSG00000020423', u'ENSMUSG00000032492', u'ENSMUSG00000020185', u'ENSMUSG00000020427', u'ENSMUSG00000022043', u'ENSMUSG00000004936', u'ENSMUSG00000025314', u'ENSMUSG00000003068', u'ENSMUSG00000068154', u'ENSMUSG00000052040', u'ENSMUSG00000027399', u'ENSMUSG00000038518', u'ENSMUSG00000042228', u'ENSMUSG00000000561', u'ENSMUSG00000002496', u'ENSMUSG00000037003', u'ENSMUSG00000005045', u'ENSMUSG00000004069', u'ENSMUSG00000000567', u'ENSMUSG00000032259', u'ENSMUSG00000042429', u'ENSMUSG00000023067', u'ENSMUSG00000029833', u'ENSMUSG00000022018', u'ENSMUSG00000035431', u'ENSMUSG00000024563', u'ENSMUSG00000025499', u'ENSMUSG00000062352', u'ENSMUSG00000031871', u'ENSMUSG00000037989', u'ENSMUSG00000013663', u'ENSMUSG00000062232', u'ENSMUSG00000032487', u'ENSMUSG00000048251', u'ENSMUSG00000013584', u'ENSMUSG00000011114', u'ENSMUSG00000034021', u'ENSMUSG00000036986', u'ENSMUSG00000021340', u'ENSMUSG00000028551', u'ENSMUSG00000036980', u'ENSMUSG00000026883', u'ENSMUSG00000020530', u'ENSMUSG00000024912', u'ENSMUSG00000046532', u'ENSMUSG00000028414', u'ENSMUSG00000015846', u'ENSMUSG00000037014', u'ENSMUSG00000022883', u'ENSMUSG00000027004', u'ENSMUSG00000022556', u'ENSMUSG00000024515', u'ENSMUSG00000001707', u'ENSMUSG00000002028', u'ENSMUSG00000029821', u'ENSMUSG00000027314', u'ENSMUSG00000029127', u'ENSMUSG00000015149', u'ENSMUSG00000066357', u'ENSMUSG00000036867', u'ENSMUSG00000026430', u'ENSMUSG00000028800', u'ENSMUSG00000069301', u'ENSMUSG00000057789', u'ENSMUSG00000020733', u'ENSMUSG00000026932', u'ENSMUSG00000062209', u'ENSMUSG00000021466', u'ENSMUSG00000059456', u'ENSMUSG00000030342', u'ENSMUSG00000071516', u'ENSMUSG00000000708', u'ENSMUSG00000034850', u'ENSMUSG00000026283', u'ENSMUSG00000031558', u'ENSMUSG00000031155', u'ENSMUSG00000030417', u'ENSMUSG00000008575', u'ENSMUSG00000019889', u'ENSMUSG00000041957', u'ENSMUSG00000039191', u'ENSMUSG00000037573', u'ENSMUSG00000042323', u'ENSMUSG00000033237', u'ENSMUSG00000063049', u'ENSMUSG00000041556', u'ENSMUSG00000026604', u'ENSMUSG00000037075', u'ENSMUSG00000035342', u'ENSMUSG00000029050', u'ENSMUSG00000026603', u'ENSMUSG00000026923', u'ENSMUSG00000030798', u'ENSMUSG00000020716', u'ENSMUSG00000038060', u'ENSMUSG00000042817', u'ENSMUSG00000006435', u'ENSMUSG00000029552', u'ENSMUSG00000003032', u'ENSMUSG00000003031', u'ENSMUSG00000029613', u'ENSMUSG00000029359', u'ENSMUSG00000036478', u'ENSMUSG00000033373', u'ENSMUSG00000029249', u'ENSMUSG00000009073', u'ENSMUSG00000020053', u'ENSMUSG00000015605', u'ENSMUSG00000029361', u'ENSMUSG00000010175', u'ENSMUSG00000029026', u'ENSMUSG00000017466', u'ENSMUSG00000032312', u'ENSMUSG00000026288', u'ENSMUSG00000002603', u'ENSMUSG00000029629', u'ENSMUSG00000053647', u'ENSMUSG00000024621', u'ENSMUSG00000000530', u'ENSMUSG00000031785', u'ENSMUSG00000048546', u'ENSMUSG00000020653', u'ENSMUSG00000035773', u'ENSMUSG00000032179', u'ENSMUSG00000021901', u'ENSMUSG00000028978', u'ENSMUSG00000021149', u'ENSMUSG00000000142', u'ENSMUSG00000022329', u'ENSMUSG00000035086', u'ENSMUSG00000072620', u'ENSMUSG00000076431', u'ENSMUSG00000033295', u'ENSMUSG00000021253', u'ENSMUSG00000024539', u'ENSMUSG00000045005', u'ENSMUSG00000037211', u'ENSMUSG00000029276', u'ENSMUSG00000035486', u'ENSMUSG00000027905', u'ENSMUSG00000038793', u'ENSMUSG00000030538', u'ENSMUSG00000021319', u'ENSMUSG00000059182', u'ENSMUSG00000008090', u'ENSMUSG00000021097', u'ENSMUSG00000056427', u'ENSMUSG00000026069', u'ENSMUSG00000025492', u'ENSMUSG00000000441', u'ENSMUSG00000040055', u'ENSMUSG00000028600', u'ENSMUSG00000005125', u'ENSMUSG00000005413', u'ENSMUSG00000057329', u'ENSMUSG00000031548', u'ENSMUSG00000011658', u'ENSMUSG00000047407', u'ENSMUSG00000017491', u'ENSMUSG00000050953', u'ENSMUSG00000031601', u'ENSMUSG00000003534', u'ENSMUSG00000004040', u'ENSMUSG00000014402', u'ENSMUSG00000023191', u'ENSMUSG00000066687', u'ENSMUSG00000033585', u'ENSMUSG00000028207', u'ENSMUSG00000021732', u'ENSMUSG00000053333', u'ENSMUSG00000028413', u'ENSMUSG00000025373', u'ENSMUSG00000022508', u'ENSMUSG00000037992', u'ENSMUSG00000050737', u'ENSMUSG00000028179', u'ENSMUSG00000024921', u'ENSMUSG00000042284', u'ENSMUSG00000032440', u'ENSMUSG00000025809', u'ENSMUSG00000030330', u'ENSMUSG00000000126', u'ENSMUSG00000038845', u'ENSMUSG00000050965', u'ENSMUSG00000048376', u'ENSMUSG00000022952', u'ENSMUSG00000031841', u'ENSMUSG00000003382', u'ENSMUSG00000052684', u'ENSMUSG00000022114', u'ENSMUSG00000027358', u'ENSMUSG00000044906', u'ENSMUSG00000028211', u'ENSMUSG00000034394', u'ENSMUSG00000034432', u'ENSMUSG00000030222', u'ENSMUSG00000038539', u'ENSMUSG00000018899', u'ENSMUSG00000039239', u'ENSMUSG00000024087', u'ENSMUSG00000026585', u'ENSMUSG00000038168', u'ENSMUSG00000055653', u'ENSMUSG00000024789', u'ENSMUSG00000024947', u'ENSMUSG00000025586', u'ENSMUSG00000018209', u'ENSMUSG00000031980', u'ENSMUSG00000022105', u'ENSMUSG00000031660', u'ENSMUSG00000068748', u'ENSMUSG00000027168', u'ENSMUSG00000007655', u'ENSMUSG00000018507', u'ENSMUSG00000031523', u'ENSMUSG00000028909', u'ENSMUSG00000045969', u'ENSMUSG00000027995', u'ENSMUSG00000036206', u'ENSMUSG00000054252', u'ENSMUSG00000048450', u'ENSMUSG00000018217', u'ENSMUSG00000042903', u'ENSMUSG00000034748', u'ENSMUSG00000020415', u'ENSMUSG00000021835', u'ENSMUSG00000040506', u'ENSMUSG00000026361', u'ENSMUSG00000014773', u'ENSMUSG00000021743', u'ENSMUSG00000000058', u'ENSMUSG00000032737', u'ENSMUSG00000032194']), pop_n=13836, p_sm_bonferroni=0.12843245587666066, is_obsolete=False, GO='GO:0008285', name='negative regulation of cell proliferation', pop_count=269, alt_ids=[], level=5, depth=5, enrichment='e', Cluster='Late Increase', geneid_set=set([u'ENSMUSG00000020053', u'ENSMUSG00000026923', u'ENSMUSG00000030798', u'ENSMUSG00000013584', u'ENSMUSG00000003031', u'ENSMUSG00000036478', u'ENSMUSG00000021340', u'ENSMUSG00000025352', u'ENSMUSG00000031871', u'ENSMUSG00000018500', u'ENSMUSG00000028207', u'ENSMUSG00000034957', u'ENSMUSG00000021318', u'ENSMUSG00000030849', u'ENSMUSG00000026249', u'ENSMUSG00000017466', u'ENSMUSG00000026288', u'ENSMUSG00000032440', u'ENSMUSG00000050953', u'ENSMUSG00000042284', u'ENSMUSG00000031785', u'ENSMUSG00000048376', u'ENSMUSG00000015149', u'ENSMUSG00000035342', u'ENSMUSG00000022018', u'ENSMUSG00000026932', u'ENSMUSG00000062209', u'ENSMUSG00000038539', u'ENSMUSG00000025809', u'ENSMUSG00000030342', u'ENSMUSG00000000708', u'ENSMUSG00000024087', u'ENSMUSG00000032194', u'ENSMUSG00000059182', u'ENSMUSG00000027878', u'ENSMUSG00000027168', u'ENSMUSG00000003534', u'ENSMUSG00000040055', u'ENSMUSG00000039191', u'ENSMUSG00000000567', u'ENSMUSG00000005125', u'ENSMUSG00000057329', u'ENSMUSG00000020733', u'ENSMUSG00000047407', u'ENSMUSG00000038168', u'ENSMUSG00000037003', u'ENSMUSG00000041556', u'ENSMUSG00000007655', u'ENSMUSG00000000058', u'ENSMUSG00000032737', u'ENSMUSG00000018217']), symbols=u'Adgrg1 Adora2b Aldh1a2 Asph Atf5 Bcl2 Btg1 Cav1 Cav2 Cd37 Cd9 Cdh5 Cdkn1b Cebpa Cyp1b1 Ddr1 Erbb4 F2r Fbxo2 Fgfr2 Gdf11 Gja1 Gjb6 Gli3 Gpld1 Igf1 Inpp5d Inppl1 Itga1 Itgb1 Kank2 Kat2b Lzts2 Nacc2 Ndrg1 Notch1 Notch2 P3h2 Pax6 Pmp22 Rbpj Rgcc Serpine2 Sirt2 Skap2 Slc9a3r1 Sox9 Tgfbr2 Tgif1 Timp2 Tns2', symbol_set=set([u'Adora2b', u'Igf1', u'Cyp1b1', u'Rbpj', u'Asph', u'Fgfr2', u'Lzts2', u'Tgif1', u'Itgb1', u'Gja1', u'Pmp22', u'Btg1', u'Skap2', u'Slc9a3r1', u'Ddr1', u'Notch1', u'Notch2', u'Cd37', u'Sox9', u'Aldh1a2', u'Atf5', u'Ndrg1', u'Cdh5', u'Cd9', u'Gdf11', u'Bcl2', u'Inppl1', u'Tgfbr2', u'Cdkn1b', u'F2r', u'Pax6', u'Kank2', 'P3h2', 'Rgcc', u'Nacc2', u'Cav2', u'Serpine2', u'Cav1', u'Sirt2', u'Cebpa', u'Inpp5d', u'Timp2', u'Erbb4', u'Itga1', u'Kat2b', u'Gjb6', u'Gli3', u'Fbxo2', u'Gpld1', 'Adgrg1', 'Tns2']), geneids='ENSMUSG00000026932 ENSMUSG00000026923 ENSMUSG00000028207 ENSMUSG00000013584 ENSMUSG00000003031 ENSMUSG00000036478 ENSMUSG00000021340 ENSMUSG00000025352 ENSMUSG00000018500 ENSMUSG00000030798 ENSMUSG00000034957 ENSMUSG00000059182 ENSMUSG00000030849 ENSMUSG00000026249 ENSMUSG00000017466 ENSMUSG00000026288 ENSMUSG00000032440 ENSMUSG00000050953 ENSMUSG00000042284 ENSMUSG00000031785 ENSMUSG00000048376 ENSMUSG00000015149 ENSMUSG00000035342 ENSMUSG00000022018 ENSMUSG00000041556 ENSMUSG00000020053 ENSMUSG00000062209 ENSMUSG00000038539 ENSMUSG00000003534 ENSMUSG00000025809 ENSMUSG00000030342 ENSMUSG00000000708 ENSMUSG00000037003 ENSMUSG00000018217 ENSMUSG00000021318 ENSMUSG00000027878 ENSMUSG00000027168 ENSMUSG00000024087 ENSMUSG00000040055 ENSMUSG00000039191 ENSMUSG00000000567 ENSMUSG00000005125 ENSMUSG00000057329 ENSMUSG00000020733 ENSMUSG00000047407 ENSMUSG00000038168 ENSMUSG00000032737 ENSMUSG00000007655 ENSMUSG00000000058 ENSMUSG00000031871 ENSMUSG00000032194', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=84, D1='A', GO_name='negative regulation of cell proliferation'),
    Nt(p_uncorrected='', study_count='', study_n='', namespace='', p_fdr_bh='', study_items='', NS='BP', pop_items='', pop_n='', p_sm_bonferroni='', is_obsolete='', GO='GO:0032501', name='', pop_count='', alt_ids='', level=1, depth=1, enrichment='', Cluster='', geneid_set='', symbols='', symbol_set='', geneids='', format_txt=1, hdr_idx=1, is_hdrgo=True, is_usrgo=False, hdr1usr01='*', dcnt=1011, D1='J', GO_name='multicellular organismal process'),
    Nt(p_uncorrected='', study_count='', study_n='', namespace='', p_fdr_bh='', study_items='', NS='BP', pop_items='', pop_n='', p_sm_bonferroni='', is_obsolete='', GO='GO:0015457', name='', pop_count='', alt_ids='', level=3, depth=3, enrichment='', Cluster='', geneid_set='', symbols='', symbol_set='', geneids='', format_txt=1, hdr_idx=1, is_hdrgo=True, is_usrgo=False, hdr1usr01='*', dcnt=1661, D1='G', GO_name='transport'),
    Nt(p_uncorrected=7.690733397979356e-06, study_count=11, study_n=1397, namespace='biological_process', p_fdr_bh=0.0015331881804313847, study_items=set([u'ENSMUSG00000063856', u'ENSMUSG00000027187', u'ENSMUSG00000026385', u'ENSMUSG00000002985', u'ENSMUSG00000024978', u'ENSMUSG00000043733', u'ENSMUSG00000020333', u'ENSMUSG00000007655', u'ENSMUSG00000040613', u'ENSMUSG00000024900', u'ENSMUSG00000020334']), NS='BP', pop_items=set([u'ENSMUSG00000024978', u'ENSMUSG00000063856', u'ENSMUSG00000002279', u'ENSMUSG00000032114', u'ENSMUSG00000028158', u'ENSMUSG00000018796', u'ENSMUSG00000002985', u'ENSMUSG00000040613', u'ENSMUSG00000031278', u'ENSMUSG00000037071', u'ENSMUSG00000045294', u'ENSMUSG00000024900', u'ENSMUSG00000043733', u'ENSMUSG00000033327', u'ENSMUSG00000003721', u'ENSMUSG00000042759', u'ENSMUSG00000031545', u'ENSMUSG00000027187', u'ENSMUSG00000025059', u'ENSMUSG00000020333', u'ENSMUSG00000020964', u'ENSMUSG00000026385', u'ENSMUSG00000020334', u'ENSMUSG00000007655']), pop_n=13836, p_sm_bonferroni=0.11652230171278523, is_obsolete=False, GO='GO:0006641', name='triglyceride metabolic process', pop_count=24, alt_ids=[], level=6, depth=7, enrichment='e', Cluster='Late Increase', geneid_set=set([u'ENSMUSG00000002985', u'ENSMUSG00000027187', u'ENSMUSG00000024978', u'ENSMUSG00000063856', u'ENSMUSG00000040613', u'ENSMUSG00000020334', u'ENSMUSG00000020333', u'ENSMUSG00000007655', u'ENSMUSG00000026385', u'ENSMUSG00000024900', u'ENSMUSG00000043733']), symbols=u'Acsl6 Apobec1 Apoe Cat Cav1 Cpt1a Dbi Gpam Gpx1 Ptpn11 Slc22a4', symbol_set=set([u'Dbi', u'Slc22a4', u'Apoe', u'Cpt1a', u'Ptpn11', u'Acsl6', u'Cat', u'Gpx1', u'Apobec1', u'Gpam', u'Cav1']), geneids='ENSMUSG00000063856 ENSMUSG00000027187 ENSMUSG00000026385 ENSMUSG00000002985 ENSMUSG00000040613 ENSMUSG00000043733 ENSMUSG00000020333 ENSMUSG00000007655 ENSMUSG00000024978 ENSMUSG00000024900 ENSMUSG00000020334', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=4, D1='BCD', GO_name='triglyceride metabolic process'),
    Nt(p_uncorrected='', study_count='', study_n='', namespace='', p_fdr_bh='', study_items='', NS='BP', pop_items='', pop_n='', p_sm_bonferroni='', is_obsolete='', GO='GO:0050877', name='', pop_count='', alt_ids='', level=3, depth=3, enrichment='', Cluster='', geneid_set='', symbols='', symbol_set='', geneids='', format_txt=1, hdr_idx=1, is_hdrgo=True, is_usrgo=False, hdr1usr01='*', dcnt=96, D1='J', GO_name='neurological system process'),
    Nt(p_uncorrected=1.0909046496907063e-09, study_count=9, study_n=1397, namespace='biological_process', p_fdr_bh=6.886790144776621e-07, study_items=set([u'ENSMUSG00000061436', u'ENSMUSG00000030994', u'ENSMUSG00000000552', u'ENSMUSG00000010461', u'ENSMUSG00000057329', u'ENSMUSG00000029003', u'ENSMUSG00000042349', u'ENSMUSG00000053110', u'ENSMUSG00000061175']), NS='BP', pop_items=set([u'ENSMUSG00000033721', u'ENSMUSG00000047617', u'ENSMUSG00000026496', u'ENSMUSG00000003873', u'ENSMUSG00000047757', u'ENSMUSG00000053914', u'ENSMUSG00000046591', u'ENSMUSG00000031583', u'ENSMUSG00000016528', u'ENSMUSG00000041974', u'ENSMUSG00000007080', u'ENSMUSG00000027845', u'ENSMUSG00000027663', u'ENSMUSG00000028933', u'ENSMUSG00000027067', u'ENSMUSG00000019470', u'ENSMUSG00000017146', u'ENSMUSG00000020752', u'ENSMUSG00000021400', u'ENSMUSG00000030166', u'ENSMUSG00000042228', u'ENSMUSG00000059981', u'ENSMUSG00000031347', u'ENSMUSG00000061288', u'ENSMUSG00000023067', u'ENSMUSG00000035726', u'ENSMUSG00000026439', u'ENSMUSG00000026429', u'ENSMUSG00000025932', u'ENSMUSG00000036390', u'ENSMUSG00000039615', u'ENSMUSG00000025939', u'ENSMUSG00000069495', u'ENSMUSG00000024429', u'ENSMUSG00000056394', u'ENSMUSG00000073684', u'ENSMUSG00000031644', u'ENSMUSG00000053175', u'ENSMUSG00000022710', u'ENSMUSG00000024193', u'ENSMUSG00000024767', u'ENSMUSG00000006599', u'ENSMUSG00000036781', u'ENSMUSG00000046806', u'ENSMUSG00000021133', u'ENSMUSG00000058761', u'ENSMUSG00000069089', u'ENSMUSG00000024906', u'ENSMUSG00000022545', u'ENSMUSG00000029387', u'ENSMUSG00000005370', u'ENSMUSG00000034218', u'ENSMUSG00000038225', u'ENSMUSG00000027242', u'ENSMUSG00000068264', u'ENSMUSG00000025159', u'ENSMUSG00000030400', u'ENSMUSG00000041238', u'ENSMUSG00000020914', u'ENSMUSG00000030493', u'ENSMUSG00000040204', u'ENSMUSG00000004018', u'ENSMUSG00000092118', u'ENSMUSG00000025269', u'ENSMUSG00000051768', u'ENSMUSG00000039623', u'ENSMUSG00000063358', u'ENSMUSG00000035486', u'ENSMUSG00000030538', u'ENSMUSG00000026187', u'ENSMUSG00000031422', u'ENSMUSG00000035764', u'ENSMUSG00000021245', u'ENSMUSG00000025878', u'ENSMUSG00000031201', u'ENSMUSG00000025077', u'ENSMUSG00000044702', u'ENSMUSG00000003549', u'ENSMUSG00000036061', u'ENSMUSG00000032113', u'ENSMUSG00000029003', u'ENSMUSG00000061175', u'ENSMUSG00000038005', u'ENSMUSG00000062270', u'ENSMUSG00000061607', u'ENSMUSG00000024151', u'ENSMUSG00000005871', u'ENSMUSG00000022672', u'ENSMUSG00000017550', u'ENSMUSG00000001228', u'ENSMUSG00000012483', u'ENSMUSG00000036202', u'ENSMUSG00000015971', u'ENSMUSG00000064289', u'ENSMUSG00000079109', u'ENSMUSG00000046295', u'ENSMUSG00000021668', u'ENSMUSG00000024974', u'ENSMUSG00000020694', u'ENSMUSG00000020697', u'ENSMUSG00000025358', u'ENSMUSG00000030726', u'ENSMUSG00000029591', u'ENSMUSG00000030750', u'ENSMUSG00000030994', u'ENSMUSG00000022471', u'ENSMUSG00000030990', u'ENSMUSG00000025616', u'ENSMUSG00000020381', u'ENSMUSG00000020380', u'ENSMUSG00000020898', u'ENSMUSG00000034329', u'ENSMUSG00000037487', u'ENSMUSG00000035234', u'ENSMUSG00000029524', u'ENSMUSG00000039748', u'ENSMUSG00000029521', u'ENSMUSG00000033712', u'ENSMUSG00000023932', u'ENSMUSG00000020185', u'ENSMUSG00000003868', u'ENSMUSG00000042185', u'ENSMUSG00000038069', u'ENSMUSG00000031575', u'ENSMUSG00000030051', u'ENSMUSG00000021615', u'ENSMUSG00000059772', u'ENSMUSG00000017291', u'ENSMUSG00000021470', u'ENSMUSG00000028329', u'ENSMUSG00000034023', u'ENSMUSG00000030271', u'ENSMUSG00000045102', u'ENSMUSG00000022945', u'ENSMUSG00000032397', u'ENSMUSG00000078578', u'ENSMUSG00000014850', u'ENSMUSG00000042349', u'ENSMUSG00000078671', u'ENSMUSG00000002661', u'ENSMUSG00000078773', u'ENSMUSG00000032409', u'ENSMUSG00000022906', u'ENSMUSG00000002963', u'ENSMUSG00000031628', u'ENSMUSG00000031095', u'ENSMUSG00000049717', u'ENSMUSG00000036097', u'ENSMUSG00000028354', u'ENSMUSG00000018841', u'ENSMUSG00000031820', u'ENSMUSG00000026842', u'ENSMUSG00000020413', u'ENSMUSG00000028669', u'ENSMUSG00000020415', u'ENSMUSG00000030655', u'ENSMUSG00000010067', u'ENSMUSG00000038544', u'ENSMUSG00000021597', u'ENSMUSG00000006288', u'ENSMUSG00000036278', u'ENSMUSG00000025899', u'ENSMUSG00000034206', u'ENSMUSG00000020228', u'ENSMUSG00000014074', u'ENSMUSG00000000148', u'ENSMUSG00000001729', u'ENSMUSG00000041133', u'ENSMUSG00000025384', u'ENSMUSG00000033458', u'ENSMUSG00000033596', u'ENSMUSG00000001924', u'ENSMUSG00000059586', u'ENSMUSG00000002109', u'ENSMUSG00000026669', u'ENSMUSG00000005481', u'ENSMUSG00000009555', u'ENSMUSG00000028560', u'ENSMUSG00000055884', u'ENSMUSG00000024521', u'ENSMUSG00000027342', u'ENSMUSG00000026219', u'ENSMUSG00000043909', u'ENSMUSG00000021258', u'ENSMUSG00000055401', u'ENSMUSG00000040850', u'ENSMUSG00000031446', u'ENSMUSG00000031536', u'ENSMUSG00000031928', u'ENSMUSG00000049932', u'ENSMUSG00000037355', u'ENSMUSG00000028914', u'ENSMUSG00000035401', u'ENSMUSG00000026107', u'ENSMUSG00000058594', u'ENSMUSG00000002748', u'ENSMUSG00000003813', u'ENSMUSG00000001517', u'ENSMUSG00000030346', u'ENSMUSG00000021276', u'ENSMUSG00000090112', u'ENSMUSG00000024382', u'ENSMUSG00000026082', u'ENSMUSG00000073705', u'ENSMUSG00000052934', u'ENSMUSG00000035390', u'ENSMUSG00000033454', u'ENSMUSG00000040174', u'ENSMUSG00000002083', u'ENSMUSG00000019970', u'ENSMUSG00000049502', u'ENSMUSG00000032534', u'ENSMUSG00000053436', u'ENSMUSG00000006335', u'ENSMUSG00000027544', u'ENSMUSG00000074781', u'ENSMUSG00000038425', u'ENSMUSG00000029920', u'ENSMUSG00000025507', u'ENSMUSG00000070348', u'ENSMUSG00000028820', u'ENSMUSG00000022248', u'ENSMUSG00000020063', u'ENSMUSG00000039354', u'ENSMUSG00000007646', u'ENSMUSG00000025261', u'ENSMUSG00000039231', u'ENSMUSG00000020423', u'ENSMUSG00000021690', u'ENSMUSG00000021694', u'ENSMUSG00000021287', u'ENSMUSG00000028629', u'ENSMUSG00000025218', u'ENSMUSG00000022400', u'ENSMUSG00000047989', u'ENSMUSG00000036875', u'ENSMUSG00000068205', u'ENSMUSG00000059552', u'ENSMUSG00000035842', u'ENSMUSG00000028411', u'ENSMUSG00000059263', u'ENSMUSG00000020287', u'ENSMUSG00000000552', u'ENSMUSG00000034345', u'ENSMUSG00000037461', u'ENSMUSG00000018750', u'ENSMUSG00000021461', u'ENSMUSG00000014243', u'ENSMUSG00000031311', u'ENSMUSG00000031314', u'ENSMUSG00000037262', u'ENSMUSG00000022141', u'ENSMUSG00000048668', u'ENSMUSG00000038774', u'ENSMUSG00000031229', u'ENSMUSG00000055932', u'ENSMUSG00000027424', u'ENSMUSG00000036086', u'ENSMUSG00000029026', u'ENSMUSG00000039994', u'ENSMUSG00000032267', u'ENSMUSG00000090083', u'ENSMUSG00000054051', u'ENSMUSG00000079235', u'ENSMUSG00000024742', u'ENSMUSG00000001524', u'ENSMUSG00000024740', u'ENSMUSG00000026914', u'ENSMUSG00000038369', u'ENSMUSG00000063065', u'ENSMUSG00000035365', u'ENSMUSG00000044167', u'ENSMUSG00000020546', u'ENSMUSG00000043987', u'ENSMUSG00000030079', u'ENSMUSG00000033102', u'ENSMUSG00000037761', u'ENSMUSG00000057329', u'ENSMUSG00000028702', u'ENSMUSG00000024735', u'ENSMUSG00000020471', u'ENSMUSG00000027104', u'ENSMUSG00000032498', u'ENSMUSG00000028680', u'ENSMUSG00000039738', u'ENSMUSG00000025374', u'ENSMUSG00000030034', u'ENSMUSG00000035960', u'ENSMUSG00000030641', u'ENSMUSG00000037111', u'ENSMUSG00000070520', u'ENSMUSG00000027353', u'ENSMUSG00000030451', u'ENSMUSG00000028426', u'ENSMUSG00000040865', u'ENSMUSG00000031986', u'ENSMUSG00000027671', u'ENSMUSG00000028453', u'ENSMUSG00000028452', u'ENSMUSG00000041997', u'ENSMUSG00000020608', u'ENSMUSG00000026077', u'ENSMUSG00000028224', u'ENSMUSG00000000355', u'ENSMUSG00000021264', u'ENSMUSG00000053110', u'ENSMUSG00000038028', u'ENSMUSG00000019841', u'ENSMUSG00000019969', u'ENSMUSG00000024283', u'ENSMUSG00000018189', u'ENSMUSG00000041147', u'ENSMUSG00000003068', u'ENSMUSG00000009628', u'ENSMUSG00000032555', u'ENSMUSG00000022314', u'ENSMUSG00000038644', u'ENSMUSG00000061436', u'ENSMUSG00000032815', u'ENSMUSG00000029730', u'ENSMUSG00000038685', u'ENSMUSG00000028884', u'ENSMUSG00000030609', u'ENSMUSG00000029238', u'ENSMUSG00000035354', u'ENSMUSG00000034154', u'ENSMUSG00000049300', u'ENSMUSG00000004221', u'ENSMUSG00000024824', u'ENSMUSG00000045751', u'ENSMUSG00000025144', u'ENSMUSG00000043535', u'ENSMUSG00000028089', u'ENSMUSG00000024854', u'ENSMUSG00000037570', u'ENSMUSG00000037474', u'ENSMUSG00000030779', u'ENSMUSG00000028086', u'ENSMUSG00000027323', u'ENSMUSG00000021635', u'ENSMUSG00000035105', u'ENSMUSG00000042489', u'ENSMUSG00000021639', u'ENSMUSG00000030094', u'ENSMUSG00000027933', u'ENSMUSG00000026196', u'ENSMUSG00000030254', u'ENSMUSG00000030528', u'ENSMUSG00000073436', u'ENSMUSG00000031826', u'ENSMUSG00000039187', u'ENSMUSG00000066440', u'ENSMUSG00000032376', u'ENSMUSG00000040433', u'ENSMUSG00000020156', u'ENSMUSG00000026048', u'ENSMUSG00000022292', u'ENSMUSG00000061755', u'ENSMUSG00000000838', u'ENSMUSG00000030322', u'ENSMUSG00000020032', u'ENSMUSG00000061759', u'ENSMUSG00000051238', u'ENSMUSG00000051235', u'ENSMUSG00000020235', u'ENSMUSG00000010461', u'ENSMUSG00000032512', u'ENSMUSG00000002221', u'ENSMUSG00000032298', u'ENSMUSG00000021911', u'ENSMUSG00000019432', u'ENSMUSG00000021918', u'ENSMUSG00000060862', u'ENSMUSG00000020474', u'ENSMUSG00000022508', u'ENSMUSG00000002835', u'ENSMUSG00000044627', u'ENSMUSG00000047388', u'ENSMUSG00000058298', u'ENSMUSG00000022346', u'ENSMUSG00000030086', u'ENSMUSG00000034674', u'ENSMUSG00000024317', u'ENSMUSG00000000751', u'ENSMUSG00000036822', u'ENSMUSG00000026648', u'ENSMUSG00000024943', u'ENSMUSG00000035958', u'ENSMUSG00000024947', u'ENSMUSG00000058317', u'ENSMUSG00000025066', u'ENSMUSG00000023953', u'ENSMUSG00000030744', u'ENSMUSG00000037032', u'ENSMUSG00000030983', u'ENSMUSG00000020390', u'ENSMUSG00000028886', u'ENSMUSG00000027164', u'ENSMUSG00000052139', u'ENSMUSG00000016308']), pop_n=13836, p_sm_bonferroni=1.652829634746389e-05, is_obsolete=False, GO='GO:0006974', name='cellular response to DNA damage stimulus', pop_count=400, alt_ids=['GO:0034984'], level=4, depth=4, enrichment='p', Cluster='Late Increase', geneid_set=set([u'ENSMUSG00000061436', u'ENSMUSG00000030994', u'ENSMUSG00000000552', u'ENSMUSG00000010461', u'ENSMUSG00000057329', u'ENSMUSG00000029003', u'ENSMUSG00000042349', u'ENSMUSG00000053110', u'ENSMUSG00000061175']), symbols=u'Bcl2 D7Ertd443e Eya4 Fnip2 Hipk2 Ikbke Mad2l2 Yap1 Zfp385a', symbol_set=set([u'Mad2l2', u'Fnip2', u'Hipk2', u'D7Ertd443e', u'Ikbke', u'Eya4', u'Yap1', u'Zfp385a', u'Bcl2']), geneids='ENSMUSG00000061436 ENSMUSG00000030994 ENSMUSG00000000552 ENSMUSG00000010461 ENSMUSG00000057329 ENSMUSG00000029003 ENSMUSG00000042349 ENSMUSG00000053110 ENSMUSG00000061175', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=80, D1='BF', GO_name='cellular response to DNA damage stimulus'),
    Nt(p_uncorrected='', study_count='', study_n='', namespace='', p_fdr_bh='', study_items='', NS='BP', pop_items='', pop_n='', p_sm_bonferroni='', is_obsolete='', GO='GO:0045595', name='', pop_count='', alt_ids='', level=4, depth=4, enrichment='', Cluster='', geneid_set='', symbols='', symbol_set='', geneids='', format_txt=1, hdr_idx=1, is_hdrgo=True, is_usrgo=False, hdr1usr01='*', dcnt=864, D1='A', GO_name='regulation of cell differentiation'),
    Nt(p_uncorrected=1.0334684029932976e-07, study_count=19, study_n=1397, namespace='biological_process', p_fdr_bh=4.4632003115795107e-05, study_items=set([u'ENSMUSG00000020053', u'ENSMUSG00000062209', u'ENSMUSG00000022309', u'ENSMUSG00000032841', u'ENSMUSG00000000567', u'ENSMUSG00000027187', u'ENSMUSG00000024620', u'ENSMUSG00000053646', u'ENSMUSG00000026697', u'ENSMUSG00000028874', u'ENSMUSG00000028864', u'ENSMUSG00000029648', u'ENSMUSG00000062312', u'ENSMUSG00000006386', u'ENSMUSG00000048376', u'ENSMUSG00000042453', u'ENSMUSG00000032006', u'ENSMUSG00000020828', u'ENSMUSG00000055254']), NS='BP', pop_items=set([u'ENSMUSG00000020053', u'ENSMUSG00000022831', u'ENSMUSG00000028874', u'ENSMUSG00000037992', u'ENSMUSG00000021451', u'ENSMUSG00000025856', u'ENSMUSG00000006386', u'ENSMUSG00000019579', u'ENSMUSG00000025017', u'ENSMUSG00000020828', u'ENSMUSG00000005533', u'ENSMUSG00000034342', u'ENSMUSG00000002250', u'ENSMUSG00000022309', u'ENSMUSG00000041354', u'ENSMUSG00000004266', u'ENSMUSG00000053646', u'ENSMUSG00000053647', u'ENSMUSG00000026697', u'ENSMUSG00000029648', u'ENSMUSG00000028864', u'ENSMUSG00000055254', u'ENSMUSG00000036106', u'ENSMUSG00000048376', u'ENSMUSG00000042453', u'ENSMUSG00000019929', u'ENSMUSG00000025422', u'ENSMUSG00000020063', u'ENSMUSG00000019843', u'ENSMUSG00000027944', u'ENSMUSG00000062209', u'ENSMUSG00000024620', u'ENSMUSG00000039217', u'ENSMUSG00000039239', u'ENSMUSG00000000489', u'ENSMUSG00000024789', u'ENSMUSG00000032841', u'ENSMUSG00000025326', u'ENSMUSG00000031980', u'ENSMUSG00000062960', u'ENSMUSG00000028019', u'ENSMUSG00000000562', u'ENSMUSG00000000567', u'ENSMUSG00000022607', u'ENSMUSG00000027187', u'ENSMUSG00000062991', u'ENSMUSG00000062312', u'ENSMUSG00000032006', u'ENSMUSG00000020099']), pop_n=13836, p_sm_bonferroni=0.0015658079773751452, is_obsolete=False, GO='GO:0014068', name='positive regulation of phosphatidylinositol 3-kinase signaling', pop_count=49, alt_ids=[], level=7, depth=8, enrichment='e', Cluster='Late Increase', geneid_set=set([u'ENSMUSG00000020053', u'ENSMUSG00000062209', u'ENSMUSG00000020828', u'ENSMUSG00000026697', u'ENSMUSG00000029648', u'ENSMUSG00000006386', u'ENSMUSG00000032841', u'ENSMUSG00000055254', u'ENSMUSG00000022309', u'ENSMUSG00000000567', u'ENSMUSG00000027187', u'ENSMUSG00000053646', u'ENSMUSG00000024620', u'ENSMUSG00000028874', u'ENSMUSG00000028864', u'ENSMUSG00000062312', u'ENSMUSG00000048376', u'ENSMUSG00000042453', u'ENSMUSG00000032006']), symbols=u'Angpt1 Cat Erbb2 Erbb4 F2r Fgr Flt1 Hgf Igf1 Myoc Ntrk2 Pdgfd Pdgfrb Pld2 Plxnb1 Prr5l Reln Sox9 Tek', symbol_set=set([u'Erbb2', u'Pdgfrb', u'Sox9', u'Igf1', u'Pdgfd', u'Erbb4', u'Pld2', u'F2r', u'Reln', u'Ntrk2', u'Cat', u'Hgf', u'Prr5l', u'Tek', u'Fgr', u'Myoc', u'Angpt1', u'Plxnb1', u'Flt1']), geneids='ENSMUSG00000020053 ENSMUSG00000029648 ENSMUSG00000022309 ENSMUSG00000032841 ENSMUSG00000000567 ENSMUSG00000027187 ENSMUSG00000026697 ENSMUSG00000053646 ENSMUSG00000024620 ENSMUSG00000006386 ENSMUSG00000028864 ENSMUSG00000028874 ENSMUSG00000062312 ENSMUSG00000048376 ENSMUSG00000042453 ENSMUSG00000032006 ENSMUSG00000020828 ENSMUSG00000062209 ENSMUSG00000055254', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=0, D1='A', GO_name='positive regulation of phosphatidylinositol 3-kinase signaling'),
    Nt(p_uncorrected=0.0005300557577084851, study_count=7, study_n=1397, namespace='biological_process', p_fdr_bh=0.04118397325662184, study_items=set([u'ENSMUSG00000000567', u'ENSMUSG00000038375', u'ENSMUSG00000024620', u'ENSMUSG00000024330', u'ENSMUSG00000016494', u'ENSMUSG00000019997', u'ENSMUSG00000025809']), NS='BP', pop_items=set([u'ENSMUSG00000022105', u'ENSMUSG00000019997', u'ENSMUSG00000051675', u'ENSMUSG00000000567', u'ENSMUSG00000001642', u'ENSMUSG00000025809', u'ENSMUSG00000024620', u'ENSMUSG00000072437', u'ENSMUSG00000024330', u'ENSMUSG00000003068', u'ENSMUSG00000016494', u'ENSMUSG00000022483', u'ENSMUSG00000027523', u'ENSMUSG00000020532', u'ENSMUSG00000035569', u'ENSMUSG00000038375']), pop_n=13836, p_sm_bonferroni=1.0, is_obsolete=False, GO='GO:0001894', name='tissue homeostasis', pop_count=16, alt_ids=[], level=5, depth=5, enrichment='e', Cluster='Late Increase', geneid_set=set([u'ENSMUSG00000016494', u'ENSMUSG00000000567', u'ENSMUSG00000019997', u'ENSMUSG00000038375', u'ENSMUSG00000024620', u'ENSMUSG00000025809', u'ENSMUSG00000024330']), symbols=u'Cd34 Col11a2 Ctgf Itgb1 Pdgfrb Sox9 Trp53inp2', symbol_set=set([u'Itgb1', u'Pdgfrb', u'Col11a2', u'Cd34', u'Trp53inp2', u'Ctgf', u'Sox9']), geneids='ENSMUSG00000000567 ENSMUSG00000025809 ENSMUSG00000024620 ENSMUSG00000024330 ENSMUSG00000016494 ENSMUSG00000019997 ENSMUSG00000038375', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=17, D1='A', GO_name='tissue homeostasis'),
    Nt(p_uncorrected='', study_count='', study_n='', namespace='', p_fdr_bh='', study_items='', NS='BP', pop_items='', pop_n='', p_sm_bonferroni='', is_obsolete='', GO='GO:0032879', name='', pop_count='', alt_ids='', level=3, depth=3, enrichment='', Cluster='', geneid_set='', symbols='', symbol_set='', geneids='', format_txt=1, hdr_idx=1, is_hdrgo=True, is_usrgo=False, hdr1usr01='*', dcnt=1780, D1='A', GO_name='regulation of localization'),
    Nt(p_uncorrected=0.00040655025693983187, study_count=12, study_n=1397, namespace='biological_process', p_fdr_bh=0.03560487250228551, study_items=set([u'ENSMUSG00000034957', u'ENSMUSG00000020053', u'ENSMUSG00000037016', u'ENSMUSG00000055435', u'ENSMUSG00000033577', u'ENSMUSG00000021508', u'ENSMUSG00000012819', u'ENSMUSG00000003031', u'ENSMUSG00000022175', u'ENSMUSG00000021318', u'ENSMUSG00000043733', u'ENSMUSG00000069170']), NS='BP', pop_items=set([u'ENSMUSG00000020053', u'ENSMUSG00000036923', u'ENSMUSG00000028333', u'ENSMUSG00000067212', u'ENSMUSG00000028785', u'ENSMUSG00000003031', u'ENSMUSG00000016528', u'ENSMUSG00000044667', u'ENSMUSG00000052613', u'ENSMUSG00000034957', u'ENSMUSG00000037016', u'ENSMUSG00000010175', u'ENSMUSG00000036256', u'ENSMUSG00000071637', u'ENSMUSG00000022175', u'ENSMUSG00000027276', u'ENSMUSG00000062563', u'ENSMUSG00000019906', u'ENSMUSG00000031963', u'ENSMUSG00000000378', u'ENSMUSG00000036905', u'ENSMUSG00000027358', u'ENSMUSG00000061232', u'ENSMUSG00000030302', u'ENSMUSG00000033577', u'ENSMUSG00000055435', u'ENSMUSG00000039239', u'ENSMUSG00000073489', u'ENSMUSG00000048482', u'ENSMUSG00000012819', u'ENSMUSG00000021318', u'ENSMUSG00000030761', u'ENSMUSG00000043733', u'ENSMUSG00000037649', u'ENSMUSG00000022483', u'ENSMUSG00000034701', u'ENSMUSG00000054252', u'ENSMUSG00000021508', u'ENSMUSG00000014773', u'ENSMUSG00000069170']), pop_n=13836, p_sm_bonferroni=1.0, is_obsolete=False, GO='GO:0048839', name='inner ear development', pop_count=40, alt_ids=[], level=3, depth=3, enrichment='e', Cluster='Late Increase', geneid_set=set([u'ENSMUSG00000034957', u'ENSMUSG00000020053', u'ENSMUSG00000021318', u'ENSMUSG00000037016', u'ENSMUSG00000055435', u'ENSMUSG00000033577', u'ENSMUSG00000021508', u'ENSMUSG00000012819', u'ENSMUSG00000003031', u'ENSMUSG00000022175', u'ENSMUSG00000043733', u'ENSMUSG00000069170']), symbols=u'Adgrv1 Cdh23 Cdkn1b Cebpa Cxcl14 Frem2 Gli3 Igf1 Lrp10 Maf Myo6 Ptpn11', symbol_set=set([u'Lrp10', u'Cebpa', u'Igf1', u'Frem2', u'Cdkn1b', u'Ptpn11', u'Cdh23', u'Myo6', u'Gli3', u'Maf', 'Adgrv1', u'Cxcl14']), geneids='ENSMUSG00000020053 ENSMUSG00000033577 ENSMUSG00000034957 ENSMUSG00000055435 ENSMUSG00000037016 ENSMUSG00000022175 ENSMUSG00000021508 ENSMUSG00000003031 ENSMUSG00000043733 ENSMUSG00000021318 ENSMUSG00000012819 ENSMUSG00000069170', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=1, D1='CE', GO_name='inner ear development'),
    Nt(p_uncorrected=2.684625703111141e-06, study_count=12, study_n=1397, namespace='biological_process', p_fdr_bh=0.0007135923513655597, study_items=set([u'ENSMUSG00000062209', u'ENSMUSG00000020919', u'ENSMUSG00000045817', u'ENSMUSG00000000567', u'ENSMUSG00000021127', u'ENSMUSG00000022150', u'ENSMUSG00000062312', u'ENSMUSG00000037742', u'ENSMUSG00000044786', u'ENSMUSG00000030536', u'ENSMUSG00000020122', u'ENSMUSG00000025584']), NS='BP', pop_items=set([u'ENSMUSG00000006304', u'ENSMUSG00000016933', u'ENSMUSG00000026883', u'ENSMUSG00000020919', u'ENSMUSG00000045817', u'ENSMUSG00000026234', u'ENSMUSG00000018160', u'ENSMUSG00000021127', u'ENSMUSG00000022150', u'ENSMUSG00000001729', u'ENSMUSG00000032078', u'ENSMUSG00000062209', u'ENSMUSG00000056201', u'ENSMUSG00000024122', u'ENSMUSG00000021549', u'ENSMUSG00000037316', u'ENSMUSG00000030536', u'ENSMUSG00000025584', u'ENSMUSG00000028771', u'ENSMUSG00000042680', u'ENSMUSG00000000567', u'ENSMUSG00000062312', u'ENSMUSG00000037742', u'ENSMUSG00000044786', u'ENSMUSG00000020122', u'ENSMUSG00000006127']), pop_n=13836, p_sm_bonferroni=0.0406747640278369, is_obsolete=False, GO='GO:0071364', name='cellular response to epidermal growth factor stimulus', pop_count=26, alt_ids=[], level=4, depth=6, enrichment='e', Cluster='Late Increase', geneid_set=set([u'ENSMUSG00000062209', u'ENSMUSG00000020919', u'ENSMUSG00000045817', u'ENSMUSG00000000567', u'ENSMUSG00000021127', u'ENSMUSG00000022150', u'ENSMUSG00000062312', u'ENSMUSG00000037742', u'ENSMUSG00000044786', u'ENSMUSG00000030536', u'ENSMUSG00000020122', u'ENSMUSG00000025584']), symbols=u'Dab2 Eef1a1 Egfr Erbb2 Erbb4 Iqgap1 Pde8a Sox9 Stat5b Zfp36 Zfp36l1 Zfp36l2', symbol_set=set([u'Erbb2', u'Erbb4', u'Eef1a1', u'Egfr', u'Zfp36l1', u'Zfp36l2', u'Pde8a', u'Stat5b', u'Zfp36', u'Sox9', u'Dab2', u'Iqgap1']), geneids='ENSMUSG00000062209 ENSMUSG00000020919 ENSMUSG00000045817 ENSMUSG00000000567 ENSMUSG00000021127 ENSMUSG00000022150 ENSMUSG00000062312 ENSMUSG00000037742 ENSMUSG00000044786 ENSMUSG00000030536 ENSMUSG00000020122 ENSMUSG00000025584', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=0, D1='BF', GO_name='cellular response to epidermal growth factor stimulus'),
    Nt(p_uncorrected=3.2676351330835494e-05, study_count=16, study_n=1397, namespace='biological_process', p_fdr_bh=0.004853719598171456, study_items=set([u'ENSMUSG00000020053', u'ENSMUSG00000010051', u'ENSMUSG00000026923', u'ENSMUSG00000030849', u'ENSMUSG00000001761', u'ENSMUSG00000000567', u'ENSMUSG00000062209', u'ENSMUSG00000026473', u'ENSMUSG00000029999', u'ENSMUSG00000036585', u'ENSMUSG00000062312', u'ENSMUSG00000021796', u'ENSMUSG00000042745', u'ENSMUSG00000020122', u'ENSMUSG00000039004', u'ENSMUSG00000006205']), NS='BP', pop_items=set([u'ENSMUSG00000025932', u'ENSMUSG00000026923', u'ENSMUSG00000036923', u'ENSMUSG00000021732', u'ENSMUSG00000039519', u'ENSMUSG00000033933', u'ENSMUSG00000029754', u'ENSMUSG00000018395', u'ENSMUSG00000028341', u'ENSMUSG00000021994', u'ENSMUSG00000021342', u'ENSMUSG00000024959', u'ENSMUSG00000052957', u'ENSMUSG00000010051', u'ENSMUSG00000030849', u'ENSMUSG00000001761', u'ENSMUSG00000022346', u'ENSMUSG00000026473', u'ENSMUSG00000002603', u'ENSMUSG00000036585', u'ENSMUSG00000024985', u'ENSMUSG00000021796', u'ENSMUSG00000023951', u'ENSMUSG00000032179', u'ENSMUSG00000039004', u'ENSMUSG00000006205', u'ENSMUSG00000020053', u'ENSMUSG00000062209', u'ENSMUSG00000042745', u'ENSMUSG00000029999', u'ENSMUSG00000021974', u'ENSMUSG00000039059', u'ENSMUSG00000029563', u'ENSMUSG00000020122', u'ENSMUSG00000058444', u'ENSMUSG00000020857', u'ENSMUSG00000062960', u'ENSMUSG00000033792', u'ENSMUSG00000000184', u'ENSMUSG00000034708', u'ENSMUSG00000000567', u'ENSMUSG00000025499', u'ENSMUSG00000031548', u'ENSMUSG00000032511', u'ENSMUSG00000032512', u'ENSMUSG00000062312', u'ENSMUSG00000030067', u'ENSMUSG00000021835', u'ENSMUSG00000019768', u'ENSMUSG00000037601', u'ENSMUSG00000048616', u'ENSMUSG00000032419']), pop_n=13836, p_sm_bonferroni=0.4950793990134886, is_obsolete=False, GO='GO:0050679', name='positive regulation of epithelial cell proliferation', pop_count=52, alt_ids=[], level=6, depth=6, enrichment='e', Cluster='Late Increase', geneid_set=set([u'ENSMUSG00000020053', u'ENSMUSG00000062209', u'ENSMUSG00000026923', u'ENSMUSG00000029999', u'ENSMUSG00000010051', u'ENSMUSG00000030849', u'ENSMUSG00000001761', u'ENSMUSG00000000567', u'ENSMUSG00000026473', u'ENSMUSG00000036585', u'ENSMUSG00000062312', u'ENSMUSG00000021796', u'ENSMUSG00000042745', u'ENSMUSG00000020122', u'ENSMUSG00000039004', u'ENSMUSG00000006205']), symbols=u'Bmp6 Bmpr1a Egfr Erbb2 Erbb4 Fgf1 Fgfr2 Glul Htra1 Hyal1 Id1 Igf1 Notch1 Smo Sox9 Tgfa', symbol_set=set([u'Tgfa', u'Erbb2', u'Igf1', u'Erbb4', u'Bmp6', u'Hyal1', u'Egfr', u'Notch1', u'Id1', u'Smo', u'Bmpr1a', u'Glul', u'Sox9', u'Fgfr2', u'Htra1', u'Fgf1']), geneids='ENSMUSG00000020053 ENSMUSG00000010051 ENSMUSG00000026923 ENSMUSG00000030849 ENSMUSG00000001761 ENSMUSG00000000567 ENSMUSG00000062209 ENSMUSG00000026473 ENSMUSG00000029999 ENSMUSG00000036585 ENSMUSG00000062312 ENSMUSG00000021796 ENSMUSG00000042745 ENSMUSG00000020122 ENSMUSG00000039004 ENSMUSG00000006205', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=17, D1='A', GO_name='positive regulation of epithelial cell proliferation'),
    Nt(p_uncorrected=0.00044925982953889274, study_count=5, study_n=1397, namespace='biological_process', p_fdr_bh=0.03781519820746535, study_items=set([u'ENSMUSG00000030342', u'ENSMUSG00000025809', u'ENSMUSG00000037706', u'ENSMUSG00000024413', u'ENSMUSG00000021457']), NS='BP', pop_items=set([u'ENSMUSG00000000290', u'ENSMUSG00000025809', u'ENSMUSG00000030342', u'ENSMUSG00000021457', u'ENSMUSG00000032193', u'ENSMUSG00000037706', u'ENSMUSG00000058715', u'ENSMUSG00000024413']), pop_n=13836, p_sm_bonferroni=1.0, is_obsolete=False, GO='GO:0071404', name='cellular response to low-density lipoprotein particle stimulus', pop_count=8, alt_ids=[], level=5, depth=6, enrichment='e', Cluster='Late Increase', geneid_set=set([u'ENSMUSG00000037706', u'ENSMUSG00000025809', u'ENSMUSG00000030342', u'ENSMUSG00000024413', u'ENSMUSG00000021457']), symbols=u'Cd81 Cd9 Itgb1 Npc1 Syk', symbol_set=set([u'Cd81', u'Itgb1', u'Npc1', u'Syk', u'Cd9']), geneids='ENSMUSG00000030342 ENSMUSG00000025809 ENSMUSG00000037706 ENSMUSG00000024413 ENSMUSG00000021457', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=0, D1='BF', GO_name='cellular response to low-density lipoprotein particle stimulus'),
    Nt(p_uncorrected='', study_count='', study_n='', namespace='', p_fdr_bh='', study_items='', NS='BP', pop_items='', pop_n='', p_sm_bonferroni='', is_obsolete='', GO='GO:0001817', name='', pop_count='', alt_ids='', level=4, depth=4, enrichment='', Cluster='', geneid_set='', symbols='', symbol_set='', geneids='', format_txt=1, hdr_idx=1, is_hdrgo=True, is_usrgo=False, hdr1usr01='*', dcnt=476, D1='A', GO_name='regulation of cytokine production'),
    Nt(p_uncorrected=0.00044925982953889274, study_count=5, study_n=1397, namespace='biological_process', p_fdr_bh=0.03781519820746535, study_items=set([u'ENSMUSG00000004043', u'ENSMUSG00000020919', u'ENSMUSG00000018654', u'ENSMUSG00000028150', u'ENSMUSG00000020644']), NS='BP', pop_items=set([u'ENSMUSG00000020167', u'ENSMUSG00000020919', u'ENSMUSG00000074272', u'ENSMUSG00000028150', u'ENSMUSG00000004043', u'ENSMUSG00000018654', u'ENSMUSG00000017412', u'ENSMUSG00000020644']), pop_n=13836, p_sm_bonferroni=1.0, is_obsolete=False, GO='GO:0048541', name="Peyer's patch development", pop_count=8, alt_ids=[], level=5, depth=6, enrichment='e', Cluster='Late Increase', geneid_set=set([u'ENSMUSG00000004043', u'ENSMUSG00000020919', u'ENSMUSG00000028150', u'ENSMUSG00000018654', u'ENSMUSG00000020644']), symbols=u'Id2 Ikzf1 Rorc Stat5a Stat5b', symbol_set=set([u'Stat5b', u'Stat5a', u'Rorc', u'Id2', u'Ikzf1']), geneids='ENSMUSG00000004043 ENSMUSG00000028150 ENSMUSG00000020919 ENSMUSG00000020644 ENSMUSG00000018654', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=0, D1='CE', GO_name="Peyer's patch development"),
    Nt(p_uncorrected=2.3544233556584554e-05, study_count=28, study_n=1397, namespace='biological_process', p_fdr_bh=0.003793679716455514, study_items=set([u'ENSMUSG00000037060', u'ENSMUSG00000019122', u'ENSMUSG00000019997', u'ENSMUSG00000027765', u'ENSMUSG00000022309', u'ENSMUSG00000024620', u'ENSMUSG00000006386', u'ENSMUSG00000048376', u'ENSMUSG00000018927', u'ENSMUSG00000039005', u'ENSMUSG00000062209', u'ENSMUSG00000024164', u'ENSMUSG00000020357', u'ENSMUSG00000064246', u'ENSMUSG00000051212', u'ENSMUSG00000023992', u'ENSMUSG00000031451', u'ENSMUSG00000030849', u'ENSMUSG00000025584', u'ENSMUSG00000031760', u'ENSMUSG00000043733', u'ENSMUSG00000024610', u'ENSMUSG00000020399', u'ENSMUSG00000026031', u'ENSMUSG00000032006', u'ENSMUSG00000029816', u'ENSMUSG00000020122', u'ENSMUSG00000020591']), NS='BP', pop_items=set([u'ENSMUSG00000023951', u'ENSMUSG00000025856', u'ENSMUSG00000027646', u'ENSMUSG00000019997', u'ENSMUSG00000044337', u'ENSMUSG00000031778', u'ENSMUSG00000029053', u'ENSMUSG00000037405', u'ENSMUSG00000030849', u'ENSMUSG00000004264', u'ENSMUSG00000020591', u'ENSMUSG00000000766', u'ENSMUSG00000041380', u'ENSMUSG00000024164', u'ENSMUSG00000000489', u'ENSMUSG00000004936', u'ENSMUSG00000041187', u'ENSMUSG00000026596', u'ENSMUSG00000027399', u'ENSMUSG00000024962', u'ENSMUSG00000031760', u'ENSMUSG00000000982', u'ENSMUSG00000032259', u'ENSMUSG00000035722', u'ENSMUSG00000060534', u'ENSMUSG00000066551', u'ENSMUSG00000019768', u'ENSMUSG00000038058', u'ENSMUSG00000059456', u'ENSMUSG00000039005', u'ENSMUSG00000002413', u'ENSMUSG00000013663', u'ENSMUSG00000062232', u'ENSMUSG00000037992', u'ENSMUSG00000047632', u'ENSMUSG00000037060', u'ENSMUSG00000068798', u'ENSMUSG00000039844', u'ENSMUSG00000052684', u'ENSMUSG00000029231', u'ENSMUSG00000022309', u'ENSMUSG00000027347', u'ENSMUSG00000028480', u'ENSMUSG00000006386', u'ENSMUSG00000031963', u'ENSMUSG00000035352', u'ENSMUSG00000014158', u'ENSMUSG00000018909', u'ENSMUSG00000022847', u'ENSMUSG00000062209', u'ENSMUSG00000020357', u'ENSMUSG00000064246', u'ENSMUSG00000051212', u'ENSMUSG00000028019', u'ENSMUSG00000033307', u'ENSMUSG00000024610', u'ENSMUSG00000028086', u'ENSMUSG00000026031', u'ENSMUSG00000032006', u'ENSMUSG00000029816', u'ENSMUSG00000023992', u'ENSMUSG00000038224', u'ENSMUSG00000031024', u'ENSMUSG00000026842', u'ENSMUSG00000030793', u'ENSMUSG00000019122', u'ENSMUSG00000019087', u'ENSMUSG00000036564', u'ENSMUSG00000041135', u'ENSMUSG00000002603', u'ENSMUSG00000053647', u'ENSMUSG00000024620', u'ENSMUSG00000024621', u'ENSMUSG00000046949', u'ENSMUSG00000018927', u'ENSMUSG00000034997', u'ENSMUSG00000045875', u'ENSMUSG00000020657', u'ENSMUSG00000025810', u'ENSMUSG00000005087', u'ENSMUSG00000030538', u'ENSMUSG00000000441', u'ENSMUSG00000025499', u'ENSMUSG00000001127', u'ENSMUSG00000018930', u'ENSMUSG00000044014', u'ENSMUSG00000021732', u'ENSMUSG00000063065', u'ENSMUSG00000021360', u'ENSMUSG00000040998', u'ENSMUSG00000052681', u'ENSMUSG00000027765', u'ENSMUSG00000024256', u'ENSMUSG00000041193', u'ENSMUSG00000053819', u'ENSMUSG00000031616', u'ENSMUSG00000038845', u'ENSMUSG00000050965', u'ENSMUSG00000048376', u'ENSMUSG00000022114', u'ENSMUSG00000027358', u'ENSMUSG00000043659', u'ENSMUSG00000021670', u'ENSMUSG00000038264', u'ENSMUSG00000074345', u'ENSMUSG00000043733', u'ENSMUSG00000042046', u'ENSMUSG00000020122', u'ENSMUSG00000031451', u'ENSMUSG00000025584', u'ENSMUSG00000062960', u'ENSMUSG00000042680', u'ENSMUSG00000020689', u'ENSMUSG00000035385', u'ENSMUSG00000027995', u'ENSMUSG00000054252', u'ENSMUSG00000020399', u'ENSMUSG00000021835', u'ENSMUSG00000035027', u'ENSMUSG00000060216', u'ENSMUSG00000032041']), pop_n=13836, p_sm_bonferroni=0.3567186826158126, is_obsolete=False, GO='GO:0070374', name='positive regulation of ERK1 and ERK2 cascade', pop_count=121, alt_ids=[], level=8, depth=11, enrichment='e', Cluster='Late Increase', geneid_set=set([u'ENSMUSG00000062209', u'ENSMUSG00000024164', u'ENSMUSG00000026031', u'ENSMUSG00000020399', u'ENSMUSG00000020357', u'ENSMUSG00000064246', u'ENSMUSG00000037060', u'ENSMUSG00000051212', u'ENSMUSG00000019122', u'ENSMUSG00000020122', u'ENSMUSG00000031451', u'ENSMUSG00000019997', u'ENSMUSG00000025584', u'ENSMUSG00000031760', u'ENSMUSG00000043733', u'ENSMUSG00000027765', u'ENSMUSG00000022309', u'ENSMUSG00000024610', u'ENSMUSG00000024620', u'ENSMUSG00000006386', u'ENSMUSG00000048376', u'ENSMUSG00000018927', u'ENSMUSG00000032006', u'ENSMUSG00000029816', u'ENSMUSG00000023992', u'ENSMUSG00000030849', u'ENSMUSG00000020591', u'ENSMUSG00000039005']), symbols=u'Angpt1 C3 Ccl6 Ccl9 Cd74 Cflar Chil1 Ctgf Egfr Erbb4 F2r Fgfr2 Flt4 Gas6 Gpnmb Gpr183 Havcr2 Mt3 Ntsr2 P2ry1 Pde8a Pdgfd Pdgfrb Prkcdbp Ptpn11 Tek Tlr4 Trem2', symbol_set=set([u'Pdgfd', u'Mt3', u'Ptpn11', u'Ctgf', u'Cd74', u'Ntsr2', u'C3', u'Angpt1', u'Fgfr2', u'Havcr2', u'Ccl6', u'Ccl9', u'F2r', u'Prkcdbp', u'Flt4', u'P2ry1', u'Pdgfrb', 'Chil1', u'Tek', u'Erbb4', u'Gpr183', u'Egfr', u'Gpnmb', u'Cflar', u'Tlr4', u'Trem2', u'Pde8a', u'Gas6']), geneids='ENSMUSG00000037060 ENSMUSG00000019122 ENSMUSG00000019997 ENSMUSG00000027765 ENSMUSG00000022309 ENSMUSG00000024620 ENSMUSG00000006386 ENSMUSG00000048376 ENSMUSG00000018927 ENSMUSG00000020591 ENSMUSG00000062209 ENSMUSG00000024164 ENSMUSG00000020357 ENSMUSG00000064246 ENSMUSG00000051212 ENSMUSG00000023992 ENSMUSG00000031451 ENSMUSG00000030849 ENSMUSG00000025584 ENSMUSG00000031760 ENSMUSG00000043733 ENSMUSG00000024610 ENSMUSG00000020399 ENSMUSG00000026031 ENSMUSG00000032006 ENSMUSG00000029816 ENSMUSG00000020122 ENSMUSG00000039005', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=1, D1='A', GO_name='positive regulation of ERK1 and ERK2 cascade'),
    Nt(p_uncorrected=0.00019063196751369248, study_count=14, study_n=1397, namespace='biological_process', p_fdr_bh=0.019011989728957616, study_items=set([u'ENSMUSG00000030789', u'ENSMUSG00000025809', u'ENSMUSG00000028874', u'ENSMUSG00000042284', u'ENSMUSG00000031425', u'ENSMUSG00000043733', u'ENSMUSG00000030579', u'ENSMUSG00000026043', u'ENSMUSG00000039115', u'ENSMUSG00000019997', u'ENSMUSG00000022817', u'ENSMUSG00000021457', u'ENSMUSG00000020758', u'ENSMUSG00000027111']), NS='BP', pop_items=set([u'ENSMUSG00000033721', u'ENSMUSG00000028041', u'ENSMUSG00000021457', u'ENSMUSG00000004508', u'ENSMUSG00000019997', u'ENSMUSG00000058715', u'ENSMUSG00000000555', u'ENSMUSG00000040945', u'ENSMUSG00000027009', u'ENSMUSG00000020857', u'ENSMUSG00000027646', u'ENSMUSG00000042284', u'ENSMUSG00000004364', u'ENSMUSG00000021065', u'ENSMUSG00000026043', u'ENSMUSG00000028874', u'ENSMUSG00000022817', u'ENSMUSG00000001507', u'ENSMUSG00000020758', u'ENSMUSG00000027087', u'ENSMUSG00000015647', u'ENSMUSG00000038264', u'ENSMUSG00000034116', u'ENSMUSG00000030789', u'ENSMUSG00000030786', u'ENSMUSG00000025809', u'ENSMUSG00000026768', u'ENSMUSG00000029528', u'ENSMUSG00000030579', u'ENSMUSG00000029217', u'ENSMUSG00000025348', u'ENSMUSG00000037712', u'ENSMUSG00000043733', u'ENSMUSG00000020689', u'ENSMUSG00000029860', u'ENSMUSG00000000290', u'ENSMUSG00000059456', u'ENSMUSG00000022607', u'ENSMUSG00000024965', u'ENSMUSG00000031425', u'ENSMUSG00000007815', u'ENSMUSG00000058230', u'ENSMUSG00000027111', u'ENSMUSG00000039115', u'ENSMUSG00000030890', u'ENSMUSG00000020120', u'ENSMUSG00000062352', u'ENSMUSG00000031955']), pop_n=13836, p_sm_bonferroni=1.0, is_obsolete=False, GO='GO:0007229', name='integrin-mediated signaling pathway', pop_count=48, alt_ids=[], level=4, depth=6, enrichment='e', Cluster='Late Increase', geneid_set=set([u'ENSMUSG00000027111', u'ENSMUSG00000030789', u'ENSMUSG00000025809', u'ENSMUSG00000028874', u'ENSMUSG00000042284', u'ENSMUSG00000031425', u'ENSMUSG00000030579', u'ENSMUSG00000026043', u'ENSMUSG00000019997', u'ENSMUSG00000039115', u'ENSMUSG00000022817', u'ENSMUSG00000021457', u'ENSMUSG00000020758', u'ENSMUSG00000043733']), symbols=u'Col3a1 Ctgf Fgr Itga1 Itga6 Itga9 Itgax Itgb1 Itgb4 Itgb5 Plp1 Ptpn11 Syk Tyrobp', symbol_set=set([u'Itgax', u'Itgb1', u'Itgb5', u'Itgb4', u'Itga9', u'Tyrobp', u'Itga1', u'Ptpn11', u'Fgr', u'Syk', u'Ctgf', u'Itga6', u'Col3a1', u'Plp1']), geneids='ENSMUSG00000030789 ENSMUSG00000025809 ENSMUSG00000039115 ENSMUSG00000028874 ENSMUSG00000042284 ENSMUSG00000021457 ENSMUSG00000043733 ENSMUSG00000030579 ENSMUSG00000026043 ENSMUSG00000031425 ENSMUSG00000019997 ENSMUSG00000022817 ENSMUSG00000020758 ENSMUSG00000027111', format_txt=1, hdr_idx=1, is_hdrgo=True, is_usrgo=True, hdr1usr01='**', dcnt=0, D1='AB', GO_name='integrin-mediated signaling pathway'),
    Nt(p_uncorrected=2.453835471009441e-05, study_count=6, study_n=1397, namespace='biological_process', p_fdr_bh=0.003793679716455514, study_items=set([u'ENSMUSG00000004558', u'ENSMUSG00000028163', u'ENSMUSG00000026177', u'ENSMUSG00000029816', u'ENSMUSG00000014361', u'ENSMUSG00000002602']), NS='BP', pop_items=set([u'ENSMUSG00000074272', u'ENSMUSG00000002602', u'ENSMUSG00000028163', u'ENSMUSG00000026177', u'ENSMUSG00000029816', u'ENSMUSG00000014361', u'ENSMUSG00000006445', u'ENSMUSG00000004558']), pop_n=13836, p_sm_bonferroni=0.3717806122126404, is_obsolete=False, GO='GO:0001818', name='negative regulation of cytokine production', pop_count=8, alt_ids=[], level=5, depth=5, enrichment='e', Cluster='Late Increase', geneid_set=set([u'ENSMUSG00000026177', u'ENSMUSG00000029816', u'ENSMUSG00000014361', u'ENSMUSG00000004558', u'ENSMUSG00000028163', u'ENSMUSG00000002602']), symbols=u'Axl Gpnmb Mertk Ndrg2 Nfkb1 Slc11a1', symbol_set=set([u'Slc11a1', u'Gpnmb', u'Mertk', u'Nfkb1', u'Ndrg2', u'Axl']), geneids='ENSMUSG00000026177 ENSMUSG00000002602 ENSMUSG00000028163 ENSMUSG00000004558 ENSMUSG00000029816 ENSMUSG00000014361', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=149, D1='A', GO_name='negative regulation of cytokine production'),
    Nt(p_uncorrected=1.3292346588531142e-05, study_count=17, study_n=1397, namespace='biological_process', p_fdr_bh=0.0023148545191130497, study_items=set([u'ENSMUSG00000020053', u'ENSMUSG00000040152', u'ENSMUSG00000026395', u'ENSMUSG00000024610', u'ENSMUSG00000042626', u'ENSMUSG00000029999', u'ENSMUSG00000004054', u'ENSMUSG00000028864', u'ENSMUSG00000021457', u'ENSMUSG00000024998', u'ENSMUSG00000042284', u'ENSMUSG00000037706', u'ENSMUSG00000076617', u'ENSMUSG00000031714', u'ENSMUSG00000036585', u'ENSMUSG00000043733', u'ENSMUSG00000039005']), NS='BP', pop_items=set([u'ENSMUSG00000020170', u'ENSMUSG00000009376', u'ENSMUSG00000021732', u'ENSMUSG00000028068', u'ENSMUSG00000021457', u'ENSMUSG00000028864', u'ENSMUSG00000030525', u'ENSMUSG00000005534', u'ENSMUSG00000031714', u'ENSMUSG00000029616', u'ENSMUSG00000029528', u'ENSMUSG00000029468', u'ENSMUSG00000019828', u'ENSMUSG00000029026', u'ENSMUSG00000036273', u'ENSMUSG00000005672', u'ENSMUSG00000004054', u'ENSMUSG00000042284', u'ENSMUSG00000036585', u'ENSMUSG00000018821', u'ENSMUSG00000032911', u'ENSMUSG00000049107', u'ENSMUSG00000004936', u'ENSMUSG00000076617', u'ENSMUSG00000018909', u'ENSMUSG00000027358', u'ENSMUSG00000042626', u'ENSMUSG00000026395', u'ENSMUSG00000020053', u'ENSMUSG00000020623', u'ENSMUSG00000055737', u'ENSMUSG00000055471', u'ENSMUSG00000021253', u'ENSMUSG00000059146', u'ENSMUSG00000029999', u'ENSMUSG00000018932', u'ENSMUSG00000021994', u'ENSMUSG00000071369', u'ENSMUSG00000038668', u'ENSMUSG00000027954', u'ENSMUSG00000022982', u'ENSMUSG00000043733', u'ENSMUSG00000040152', u'ENSMUSG00000040687', u'ENSMUSG00000024610', u'ENSMUSG00000020859', u'ENSMUSG00000005161', u'ENSMUSG00000063239', u'ENSMUSG00000024998', u'ENSMUSG00000035027', u'ENSMUSG00000037706', u'ENSMUSG00000039005', u'ENSMUSG00000058444', u'ENSMUSG00000020312']), pop_n=13836, p_sm_bonferroni=0.20139234316283533, is_obsolete=False, GO='GO:0000187', name='activation of MAPK activity', pop_count=54, alt_ids=[], level=9, depth=13, enrichment='e', Cluster='Late Increase', geneid_set=set([u'ENSMUSG00000020053', u'ENSMUSG00000029999', u'ENSMUSG00000021457', u'ENSMUSG00000042284', u'ENSMUSG00000076617', u'ENSMUSG00000031714', u'ENSMUSG00000043733', u'ENSMUSG00000040152', u'ENSMUSG00000024610', u'ENSMUSG00000004054', u'ENSMUSG00000028864', u'ENSMUSG00000036585', u'ENSMUSG00000024998', u'ENSMUSG00000037706', u'ENSMUSG00000039005', u'ENSMUSG00000042626', u'ENSMUSG00000026395']), symbols=u'Cd74 Cd81 Fgf1 Gab1 Hgf Igf1 Ighm Itga1 Map3k11 Plce1 Ptpn11 Ptprc Shc1 Syk Tgfa Thbs1 Tlr4', symbol_set=set([u'Tgfa', u'Cd74', u'Igf1', u'Shc1', u'Syk', u'Itga1', u'Ptpn11', u'Cd81', u'Gab1', u'Map3k11', u'Plce1', u'Tlr4', u'Hgf', u'Ptprc', u'Thbs1', u'Ighm', u'Fgf1']), geneids='ENSMUSG00000020053 ENSMUSG00000039005 ENSMUSG00000040152 ENSMUSG00000024610 ENSMUSG00000042626 ENSMUSG00000029999 ENSMUSG00000004054 ENSMUSG00000028864 ENSMUSG00000021457 ENSMUSG00000043733 ENSMUSG00000042284 ENSMUSG00000076617 ENSMUSG00000037706 ENSMUSG00000031714 ENSMUSG00000036585 ENSMUSG00000024998 ENSMUSG00000026395', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=6, D1='A', GO_name='activation of MAPK activity'),
    Nt(p_uncorrected=0.0002884808220448508, study_count=8, study_n=1397, namespace='biological_process', p_fdr_bh=0.026814557882218003, study_items=set([u'ENSMUSG00000076441', u'ENSMUSG00000030711', u'ENSMUSG00000041417', u'ENSMUSG00000057329', u'ENSMUSG00000028370', u'ENSMUSG00000033400', u'ENSMUSG00000032281', u'ENSMUSG00000035237']), NS='BP', pop_items=set([u'ENSMUSG00000033022', u'ENSMUSG00000076441', u'ENSMUSG00000030711', u'ENSMUSG00000041417', u'ENSMUSG00000027792', u'ENSMUSG00000031932', u'ENSMUSG00000057329', u'ENSMUSG00000041837', u'ENSMUSG00000028048', u'ENSMUSG00000028370', u'ENSMUSG00000004936', u'ENSMUSG00000033400', u'ENSMUSG00000066551', u'ENSMUSG00000015846', u'ENSMUSG00000024778', u'ENSMUSG00000032281', u'ENSMUSG00000031555', u'ENSMUSG00000035237', u'ENSMUSG00000028766']), pop_n=13836, p_sm_bonferroni=1.0, is_obsolete=False, GO='GO:0051384', name='response to glucocorticoid', pop_count=19, alt_ids=[], level=6, depth=7, enrichment='e', Cluster='Late Increase', geneid_set=set([u'ENSMUSG00000076441', u'ENSMUSG00000030711', u'ENSMUSG00000041417', u'ENSMUSG00000057329', u'ENSMUSG00000028370', u'ENSMUSG00000033400', u'ENSMUSG00000032281', u'ENSMUSG00000035237']), symbols=u'Acsbg1 Agl Ass1 Bcl2 Lcat Pappa Pik3r1 Sult1a1', symbol_set=set([u'Agl', u'Lcat', u'Sult1a1', u'Pappa', u'Acsbg1', u'Pik3r1', u'Ass1', u'Bcl2']), geneids='ENSMUSG00000076441 ENSMUSG00000030711 ENSMUSG00000041417 ENSMUSG00000057329 ENSMUSG00000028370 ENSMUSG00000033400 ENSMUSG00000032281 ENSMUSG00000035237', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=10, D1='F', GO_name='response to glucocorticoid'),
    Nt(p_uncorrected=0.00012176927711120854, study_count=19, study_n=1397, namespace='biological_process', p_fdr_bh=0.013768106847103886, study_items=set([u'ENSMUSG00000034957', u'ENSMUSG00000048402', u'ENSMUSG00000024529', u'ENSMUSG00000032440', u'ENSMUSG00000030849', u'ENSMUSG00000075254', u'ENSMUSG00000031565', u'ENSMUSG00000013584', u'ENSMUSG00000026923', u'ENSMUSG00000036585', u'ENSMUSG00000064246', u'ENSMUSG00000021796', u'ENSMUSG00000031591', u'ENSMUSG00000029705', u'ENSMUSG00000028583', u'ENSMUSG00000019997', u'ENSMUSG00000024781', u'ENSMUSG00000021318', u'ENSMUSG00000020053']), NS='BP', pop_items=set([u'ENSMUSG00000026923', u'ENSMUSG00000022306', u'ENSMUSG00000022382', u'ENSMUSG00000024392', u'ENSMUSG00000013584', u'ENSMUSG00000030218', u'ENSMUSG00000016194', u'ENSMUSG00000024140', u'ENSMUSG00000021994', u'ENSMUSG00000019997', u'ENSMUSG00000001280', u'ENSMUSG00000058454', u'ENSMUSG00000039963', u'ENSMUSG00000034957', u'ENSMUSG00000029231', u'ENSMUSG00000040040', u'ENSMUSG00000021318', u'ENSMUSG00000030849', u'ENSMUSG00000034394', u'ENSMUSG00000040385', u'ENSMUSG00000031565', u'ENSMUSG00000032440', u'ENSMUSG00000006932', u'ENSMUSG00000036585', u'ENSMUSG00000021796', u'ENSMUSG00000041058', u'ENSMUSG00000021732', u'ENSMUSG00000015647', u'ENSMUSG00000031840', u'ENSMUSG00000028978', u'ENSMUSG00000001507', u'ENSMUSG00000022114', u'ENSMUSG00000042608', u'ENSMUSG00000030067', u'ENSMUSG00000020053', u'ENSMUSG00000048402', u'ENSMUSG00000018593', u'ENSMUSG00000075254', u'ENSMUSG00000061393', u'ENSMUSG00000022528', u'ENSMUSG00000055653', u'ENSMUSG00000008575', u'ENSMUSG00000064246', u'ENSMUSG00000021217', u'ENSMUSG00000029563', u'ENSMUSG00000022414', u'ENSMUSG00000055024', u'ENSMUSG00000000957', u'ENSMUSG00000024781', u'ENSMUSG00000036545', u'ENSMUSG00000066551', u'ENSMUSG00000062960', u'ENSMUSG00000023951', u'ENSMUSG00000039994', u'ENSMUSG00000046318', u'ENSMUSG00000024990', u'ENSMUSG00000024529', u'ENSMUSG00000027676', u'ENSMUSG00000031591', u'ENSMUSG00000056962', u'ENSMUSG00000032558', u'ENSMUSG00000028583', u'ENSMUSG00000041415', u'ENSMUSG00000028086', u'ENSMUSG00000027109', u'ENSMUSG00000067860', u'ENSMUSG00000032327', u'ENSMUSG00000021835', u'ENSMUSG00000024563', u'ENSMUSG00000037169', u'ENSMUSG00000021974', u'ENSMUSG00000062797', u'ENSMUSG00000063172', u'ENSMUSG00000036676', u'ENSMUSG00000029705']), pop_n=13836, p_sm_bonferroni=1.0, is_obsolete=False, GO='GO:0030324', name='lung development', pop_count=75, alt_ids=[], level=3, depth=4, enrichment='e', Cluster='Late Increase', geneid_set=set([u'ENSMUSG00000020053', u'ENSMUSG00000048402', u'ENSMUSG00000026923', u'ENSMUSG00000075254', u'ENSMUSG00000013584', u'ENSMUSG00000064246', u'ENSMUSG00000031591', u'ENSMUSG00000029705', u'ENSMUSG00000019997', u'ENSMUSG00000024781', u'ENSMUSG00000021318', u'ENSMUSG00000031565', u'ENSMUSG00000034957', u'ENSMUSG00000024529', u'ENSMUSG00000030849', u'ENSMUSG00000032440', u'ENSMUSG00000036585', u'ENSMUSG00000021796', u'ENSMUSG00000028583']), symbols=u'Aldh1a2 Asah1 Bmpr1a Cebpa Chil1 Ctgf Cux1 Fgf1 Fgfr1 Fgfr2 Gli2 Gli3 Heg1 Igf1 Lipa Lox Notch1 Pdpn Tgfbr2', symbol_set=set([u'Lipa', u'Tgfbr2', 'Chil1', u'Igf1', u'Heg1', u'Gli3', u'Notch1', u'Pdpn', u'Gli2', u'Cux1', u'Ctgf', u'Bmpr1a', u'Fgf1', u'Cebpa', u'Fgfr1', u'Fgfr2', u'Lox', u'Aldh1a2', u'Asah1']), geneids='ENSMUSG00000020053 ENSMUSG00000034957 ENSMUSG00000024529 ENSMUSG00000032440 ENSMUSG00000030849 ENSMUSG00000031591 ENSMUSG00000013584 ENSMUSG00000026923 ENSMUSG00000075254 ENSMUSG00000036585 ENSMUSG00000064246 ENSMUSG00000021796 ENSMUSG00000048402 ENSMUSG00000029705 ENSMUSG00000028583 ENSMUSG00000019997 ENSMUSG00000024781 ENSMUSG00000021318 ENSMUSG00000031565', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=2, D1='CE', GO_name='lung development'),
    Nt(p_uncorrected=0.0004824033146617481, study_count=10, study_n=1397, namespace='biological_process', p_fdr_bh=0.038216743220339834, study_items=set([u'ENSMUSG00000020053', u'ENSMUSG00000024087', u'ENSMUSG00000017344', u'ENSMUSG00000022469', u'ENSMUSG00000057329', u'ENSMUSG00000028128', u'ENSMUSG00000024620', u'ENSMUSG00000027200', u'ENSMUSG00000021822', u'ENSMUSG00000021756']), NS='BP', pop_items=set([u'ENSMUSG00000021756', u'ENSMUSG00000006304', u'ENSMUSG00000053819', u'ENSMUSG00000020516', u'ENSMUSG00000049775', u'ENSMUSG00000026313', u'ENSMUSG00000022346', u'ENSMUSG00000024620', u'ENSMUSG00000027646', u'ENSMUSG00000042903', u'ENSMUSG00000049044', u'ENSMUSG00000021822', u'ENSMUSG00000020053', u'ENSMUSG00000048779', u'ENSMUSG00000017831', u'ENSMUSG00000039217', u'ENSMUSG00000000489', u'ENSMUSG00000038418', u'ENSMUSG00000020689', u'ENSMUSG00000027750', u'ENSMUSG00000024087', u'ENSMUSG00000017344', u'ENSMUSG00000022607', u'ENSMUSG00000033307', u'ENSMUSG00000022469', u'ENSMUSG00000057329', u'ENSMUSG00000028128', u'ENSMUSG00000027200', u'ENSMUSG00000017776', u'ENSMUSG00000031870']), pop_n=13836, p_sm_bonferroni=1.0, is_obsolete=False, GO='GO:0014911', name='positive regulation of smooth muscle cell migration', pop_count=30, alt_ids=[], level=7, depth=8, enrichment='e', Cluster='Late Increase', geneid_set=set([u'ENSMUSG00000020053', u'ENSMUSG00000024087', u'ENSMUSG00000017344', u'ENSMUSG00000022469', u'ENSMUSG00000057329', u'ENSMUSG00000028128', u'ENSMUSG00000024620', u'ENSMUSG00000027200', u'ENSMUSG00000021822', u'ENSMUSG00000021756']), symbols=u'Bcl2 Cyp1b1 F3 Igf1 Il6st Pdgfrb Plau Rapgef3 Sema6d Vtn', symbol_set=set([u'Pdgfrb', u'F3', u'Cyp1b1', u'Plau', u'Vtn', u'Igf1', u'Rapgef3', u'Sema6d', u'Il6st', u'Bcl2']), geneids='ENSMUSG00000020053 ENSMUSG00000024087 ENSMUSG00000017344 ENSMUSG00000022469 ENSMUSG00000057329 ENSMUSG00000028128 ENSMUSG00000024620 ENSMUSG00000027200 ENSMUSG00000021822 ENSMUSG00000021756', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=2, D1='A', GO_name='positive regulation of smooth muscle cell migration'),
    Nt(p_uncorrected=0.00011161245496326497, study_count=8, study_n=1397, namespace='biological_process', p_fdr_bh=0.013008002347295596, study_items=set([u'ENSMUSG00000022309', u'ENSMUSG00000025809', u'ENSMUSG00000001930', u'ENSMUSG00000030428', u'ENSMUSG00000032537', u'ENSMUSG00000031451', u'ENSMUSG00000022091', u'ENSMUSG00000027111']), NS='BP', pop_items=set([u'ENSMUSG00000000555', u'ENSMUSG00000022309', u'ENSMUSG00000002250', u'ENSMUSG00000030707', u'ENSMUSG00000025809', u'ENSMUSG00000001930', u'ENSMUSG00000048758', u'ENSMUSG00000030428', u'ENSMUSG00000032537', u'ENSMUSG00000027111', u'ENSMUSG00000027087', u'ENSMUSG00000035725', u'ENSMUSG00000036867', u'ENSMUSG00000031451', u'ENSMUSG00000022091', u'ENSMUSG00000020437', u'ENSMUSG00000020689']), pop_n=13836, p_sm_bonferroni=1.0, is_obsolete=False, GO='GO:0031589', name='cell-substrate adhesion', pop_count=17, alt_ids=[], level=3, depth=3, enrichment='e', Cluster='Late Increase', geneid_set=set([u'ENSMUSG00000022309', u'ENSMUSG00000025809', u'ENSMUSG00000001930', u'ENSMUSG00000030428', u'ENSMUSG00000032537', u'ENSMUSG00000031451', u'ENSMUSG00000022091', u'ENSMUSG00000027111']), symbols=u'Angpt1 Ephb1 Gas6 Itga6 Itgb1 Sorbs3 Ttyh1 Vwf', symbol_set=set([u'Itgb1', u'Ephb1', u'Itga6', u'Ttyh1', u'Vwf', u'Angpt1', u'Sorbs3', u'Gas6']), geneids='ENSMUSG00000022309 ENSMUSG00000025809 ENSMUSG00000001930 ENSMUSG00000030428 ENSMUSG00000032537 ENSMUSG00000031451 ENSMUSG00000022091 ENSMUSG00000027111', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=19, D1='P', GO_name='cell-substrate adhesion'),
    Nt(p_uncorrected=7.004820861182938e-05, study_count=16, study_n=1397, namespace='biological_process', p_fdr_bh=0.009149141454119198, study_items=set([u'ENSMUSG00000062209', u'ENSMUSG00000003534', u'ENSMUSG00000030849', u'ENSMUSG00000026674', u'ENSMUSG00000004043', u'ENSMUSG00000024620', u'ENSMUSG00000029648', u'ENSMUSG00000021457', u'ENSMUSG00000053158', u'ENSMUSG00000020467', u'ENSMUSG00000042453', u'ENSMUSG00000028874', u'ENSMUSG00000020122', u'ENSMUSG00000006386', u'ENSMUSG00000020357', u'ENSMUSG00000031565']), NS='BP', pop_items=set([u'ENSMUSG00000026674', u'ENSMUSG00000038379', u'ENSMUSG00000062209', u'ENSMUSG00000024620', u'ENSMUSG00000026842', u'ENSMUSG00000026596', u'ENSMUSG00000021457', u'ENSMUSG00000028664', u'ENSMUSG00000022897', u'ENSMUSG00000000127', u'ENSMUSG00000016526', u'ENSMUSG00000005534', u'ENSMUSG00000028630', u'ENSMUSG00000005672', u'ENSMUSG00000029231', u'ENSMUSG00000035683', u'ENSMUSG00000030849', u'ENSMUSG00000037012', u'ENSMUSG00000004266', u'ENSMUSG00000031565', u'ENSMUSG00000053158', u'ENSMUSG00000024621', u'ENSMUSG00000020385', u'ENSMUSG00000031805', u'ENSMUSG00000027646', u'ENSMUSG00000042453', u'ENSMUSG00000032316', u'ENSMUSG00000019843', u'ENSMUSG00000068917', u'ENSMUSG00000058835', u'ENSMUSG00000031016', u'ENSMUSG00000029648', u'ENSMUSG00000026034', u'ENSMUSG00000029528', u'ENSMUSG00000000489', u'ENSMUSG00000006386', u'ENSMUSG00000024789', u'ENSMUSG00000029217', u'ENSMUSG00000020357', u'ENSMUSG00000042228', u'ENSMUSG00000062960', u'ENSMUSG00000028530', u'ENSMUSG00000024247', u'ENSMUSG00000022607', u'ENSMUSG00000059456', u'ENSMUSG00000026117', u'ENSMUSG00000054252', u'ENSMUSG00000028874', u'ENSMUSG00000020467', u'ENSMUSG00000026782', u'ENSMUSG00000026235', u'ENSMUSG00000004043', u'ENSMUSG00000003283', u'ENSMUSG00000020122', u'ENSMUSG00000003534']), pop_n=13836, p_sm_bonferroni=1.0, is_obsolete=False, GO='GO:0018108', name='peptidyl-tyrosine phosphorylation', pop_count=55, alt_ids=[], level=7, depth=9, enrichment='e', Cluster='Late Increase', geneid_set=set([u'ENSMUSG00000062209', u'ENSMUSG00000026674', u'ENSMUSG00000053158', u'ENSMUSG00000021457', u'ENSMUSG00000020467', u'ENSMUSG00000020357', u'ENSMUSG00000031565', u'ENSMUSG00000030849', u'ENSMUSG00000004043', u'ENSMUSG00000024620', u'ENSMUSG00000029648', u'ENSMUSG00000042453', u'ENSMUSG00000028874', u'ENSMUSG00000020122', u'ENSMUSG00000006386', u'ENSMUSG00000003534']), symbols=u'Ddr1 Ddr2 Efemp1 Egfr Erbb4 Fes Fgfr1 Fgfr2 Fgr Flt1 Flt4 Pdgfrb Reln Stat5a Syk Tek', symbol_set=set([u'Reln', u'Pdgfrb', u'Tek', u'Erbb4', u'Ddr2', u'Ddr1', u'Egfr', u'Fgr', u'Syk', u'Stat5a', u'Fes', u'Efemp1', u'Flt4', u'Flt1', u'Fgfr2', u'Fgfr1']), geneids='ENSMUSG00000021457 ENSMUSG00000026674 ENSMUSG00000030849 ENSMUSG00000029648 ENSMUSG00000004043 ENSMUSG00000062209 ENSMUSG00000024620 ENSMUSG00000006386 ENSMUSG00000020357 ENSMUSG00000053158 ENSMUSG00000020467 ENSMUSG00000042453 ENSMUSG00000028874 ENSMUSG00000020122 ENSMUSG00000003534 ENSMUSG00000031565', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=15, D1='BD', GO_name='peptidyl-tyrosine phosphorylation'),
    Nt(p_uncorrected='', study_count='', study_n='', namespace='', p_fdr_bh='', study_items='', NS='BP', pop_items='', pop_n='', p_sm_bonferroni='', is_obsolete='', GO='GO:0042592', name='', pop_count='', alt_ids='', level=3, depth=3, enrichment='', Cluster='', geneid_set='', symbols='', symbol_set='', geneids='', format_txt=1, hdr_idx=1, is_hdrgo=True, is_usrgo=False, hdr1usr01='*', dcnt=264, D1='A', GO_name='homeostatic process'),
    Nt(p_uncorrected='', study_count='', study_n='', namespace='', p_fdr_bh='', study_items='', NS='BP', pop_items='', pop_n='', p_sm_bonferroni='', is_obsolete='', GO='GO:0050900', name='', pop_count='', alt_ids='', level=2, depth=6, enrichment='', Cluster='', geneid_set='', symbols='', symbol_set='', geneids='', format_txt=1, hdr_idx=1, is_hdrgo=True, is_usrgo=False, hdr1usr01='*', dcnt=58, D1='BCLM', GO_name='leukocyte migration'),
    Nt(p_uncorrected='', study_count='', study_n='', namespace='', p_fdr_bh='', study_items='', NS='BP', pop_items='', pop_n='', p_sm_bonferroni='', is_obsolete='', GO='GO:0007272', name='', pop_count='', alt_ids='', level=3, depth=3, enrichment='', Cluster='', geneid_set='', symbols='', symbol_set='', geneids='', format_txt=1, hdr_idx=1, is_hdrgo=True, is_usrgo=False, hdr1usr01='*', dcnt=13, D1='BC', GO_name='ensheathment of neurons'),
    Nt(p_uncorrected=0.0005660627202574551, study_count=6, study_n=1397, namespace='biological_process', p_fdr_bh=0.042041256248140695, study_items=set([u'ENSMUSG00000020717', u'ENSMUSG00000075254', u'ENSMUSG00000042745', u'ENSMUSG00000036885', u'ENSMUSG00000037242', u'ENSMUSG00000022025']), NS='BP', pop_items=set([u'ENSMUSG00000009376', u'ENSMUSG00000040040', u'ENSMUSG00000075254', u'ENSMUSG00000020717', u'ENSMUSG00000001435', u'ENSMUSG00000004846', u'ENSMUSG00000042745', u'ENSMUSG00000036885', u'ENSMUSG00000014813', u'ENSMUSG00000037242', u'ENSMUSG00000022025', u'ENSMUSG00000015468']), pop_n=13836, p_sm_bonferroni=1.0, is_obsolete=False, GO='GO:0001886', name='endothelial cell morphogenesis', pop_count=12, alt_ids=[], level=7, depth=8, enrichment='e', Cluster='Late Increase', geneid_set=set([u'ENSMUSG00000042745', u'ENSMUSG00000020717', u'ENSMUSG00000036885', u'ENSMUSG00000075254', u'ENSMUSG00000037242', u'ENSMUSG00000022025']), symbols=u'Arhgef26 Clic4 Cnmd Heg1 Id1 Pecam1', symbol_set=set([u'Pecam1', u'Clic4', u'Heg1', 'Cnmd', u'Id1', u'Arhgef26']), geneids='ENSMUSG00000075254 ENSMUSG00000020717 ENSMUSG00000042745 ENSMUSG00000036885 ENSMUSG00000037242 ENSMUSG00000022025', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=0, D1='BCEH', GO_name='endothelial cell morphogenesis'),
    Nt(p_uncorrected=5.731121779726956e-05, study_count=5, study_n=1397, namespace='biological_process', p_fdr_bh=0.007822723070688568, study_items=set([u'ENSMUSG00000053279', u'ENSMUSG00000013584', u'ENSMUSG00000028138', u'ENSMUSG00000066026', u'ENSMUSG00000052914']), NS='BP', pop_items=set([u'ENSMUSG00000013584', u'ENSMUSG00000053279', u'ENSMUSG00000066026', u'ENSMUSG00000009281', u'ENSMUSG00000028138', u'ENSMUSG00000052914']), pop_n=13836, p_sm_bonferroni=0.868322260846431, is_obsolete=False, GO='GO:0001523', name='retinoid metabolic process', pop_count=6, alt_ids=[], level=7, depth=8, enrichment='e', Cluster='Late Increase', geneid_set=set([u'ENSMUSG00000028138', u'ENSMUSG00000013584', u'ENSMUSG00000053279', u'ENSMUSG00000066026', u'ENSMUSG00000052914']), symbols=u'Adh5 Aldh1a1 Aldh1a2 Cyp2j6 Dhrs3', symbol_set=set([u'Dhrs3', u'Cyp2j6', u'Aldh1a2', u'Adh5', u'Aldh1a1']), geneids='ENSMUSG00000053279 ENSMUSG00000013584 ENSMUSG00000028138 ENSMUSG00000066026 ENSMUSG00000052914', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=10, D1='BCD', GO_name='retinoid metabolic process'),
    Nt(p_uncorrected='', study_count='', study_n='', namespace='', p_fdr_bh='', study_items='', NS='BP', pop_items='', pop_n='', p_sm_bonferroni='', is_obsolete='', GO='GO:0010941', name='', pop_count='', alt_ids='', level=4, depth=4, enrichment='', Cluster='', geneid_set='', symbols='', symbol_set='', geneids='', format_txt=1, hdr_idx=1, is_hdrgo=True, is_usrgo=False, hdr1usr01='*', dcnt=335, D1='A', GO_name='regulation of cell death'),
    Nt(p_uncorrected='', study_count='', study_n='', namespace='', p_fdr_bh='', study_items='', NS='BP', pop_items='', pop_n='', p_sm_bonferroni='', is_obsolete='', GO='GO:0006325', name='', pop_count='', alt_ids='', level=4, depth=4, enrichment='', Cluster='', geneid_set='', symbols='', symbol_set='', geneids='', format_txt=1, hdr_idx=1, is_hdrgo=True, is_usrgo=False, hdr1usr01='*', dcnt=185, D1='BH', GO_name='chromatin organization'),
    Nt(p_uncorrected='', study_count='', study_n='', namespace='', p_fdr_bh='', study_items='', NS='BP', pop_items='', pop_n='', p_sm_bonferroni='', is_obsolete='', GO='GO:0033993', name='', pop_count='', alt_ids='', level=4, depth=4, enrichment='', Cluster='', geneid_set='', symbols='', symbol_set='', geneids='', format_txt=1, hdr_idx=1, is_hdrgo=True, is_usrgo=False, hdr1usr01='*', dcnt=125, D1='F', GO_name='response to lipid'),
    Nt(p_uncorrected='', study_count='', study_n='', namespace='', p_fdr_bh='', study_items='', NS='BP', pop_items='', pop_n='', p_sm_bonferroni='', is_obsolete='', GO='GO:0008283', name='', pop_count='', alt_ids='', level=2, depth=2, enrichment='', Cluster='', geneid_set='', symbols='', symbol_set='', geneids='', format_txt=1, hdr_idx=1, is_hdrgo=True, is_usrgo=False, hdr1usr01='*', dcnt=159, D1='C', GO_name='cell proliferation'),
    Nt(p_uncorrected=0.00023340604007175578, study_count=9, study_n=1397, namespace='biological_process', p_fdr_bh=0.02296321372160501, study_items=set([u'ENSMUSG00000029669', u'ENSMUSG00000031486', u'ENSMUSG00000037411', u'ENSMUSG00000006386', u'ENSMUSG00000032035', u'ENSMUSG00000038650', u'ENSMUSG00000022505', u'ENSMUSG00000042745', u'ENSMUSG00000018500']), NS='BP', pop_items=set([u'ENSMUSG00000020716', u'ENSMUSG00000031486', u'ENSMUSG00000023905', u'ENSMUSG00000027954', u'ENSMUSG00000022425', u'ENSMUSG00000021266', u'ENSMUSG00000018500', u'ENSMUSG00000000555', u'ENSMUSG00000037568', u'ENSMUSG00000029669', u'ENSMUSG00000006386', u'ENSMUSG00000032035', u'ENSMUSG00000022505', u'ENSMUSG00000042745', u'ENSMUSG00000039745', u'ENSMUSG00000021256', u'ENSMUSG00000030123', u'ENSMUSG00000031987', u'ENSMUSG00000006445', u'ENSMUSG00000001034', u'ENSMUSG00000059456', u'ENSMUSG00000037411', u'ENSMUSG00000038650']), pop_n=13836, p_sm_bonferroni=1.0, is_obsolete=False, GO='GO:0045765', name='regulation of angiogenesis', pop_count=23, alt_ids=[], level=5, depth=6, enrichment='e', Cluster='Late Increase', geneid_set=set([u'ENSMUSG00000029669', u'ENSMUSG00000031486', u'ENSMUSG00000037411', u'ENSMUSG00000006386', u'ENSMUSG00000032035', u'ENSMUSG00000038650', u'ENSMUSG00000018500', u'ENSMUSG00000042745', u'ENSMUSG00000022505']), symbols=u'Adgra2 Adora2b Emp2 Ets1 Id1 Rnh1 Serpine1 Tek Tspan12', symbol_set=set([u'Adora2b', u'Tek', u'Tspan12', u'Ets1', 'Adgra2', u'Emp2', u'Rnh1', u'Id1', u'Serpine1']), geneids='ENSMUSG00000029669 ENSMUSG00000031486 ENSMUSG00000037411 ENSMUSG00000006386 ENSMUSG00000032035 ENSMUSG00000038650 ENSMUSG00000018500 ENSMUSG00000042745 ENSMUSG00000022505', format_txt=1, hdr_idx=1, is_hdrgo=True, is_usrgo=True, hdr1usr01='**', dcnt=17, D1='A', GO_name='regulation of angiogenesis'),
    Nt(p_uncorrected=2.872098408196702e-10, study_count=28, study_n=1397, namespace='biological_process', p_fdr_bh=3.1082259273277313e-07, study_items=set([u'ENSMUSG00000061436', u'ENSMUSG00000006386', u'ENSMUSG00000015839', u'ENSMUSG00000036478', u'ENSMUSG00000036585', u'ENSMUSG00000010051', u'ENSMUSG00000050335', u'ENSMUSG00000028194', u'ENSMUSG00000029484', u'ENSMUSG00000032440', u'ENSMUSG00000029648', u'ENSMUSG00000028864', u'ENSMUSG00000019803', u'ENSMUSG00000023031', u'ENSMUSG00000040552', u'ENSMUSG00000015305', u'ENSMUSG00000024164', u'ENSMUSG00000015340', u'ENSMUSG00000064246', u'ENSMUSG00000016494', u'ENSMUSG00000032359', u'ENSMUSG00000024087', u'ENSMUSG00000040152', u'ENSMUSG00000022469', u'ENSMUSG00000037411', u'ENSMUSG00000028128', u'ENSMUSG00000052336', u'ENSMUSG00000032035']), NS='BP', pop_items=set([u'ENSMUSG00000015053', u'ENSMUSG00000031380', u'ENSMUSG00000020484', u'ENSMUSG00000021681', u'ENSMUSG00000021576', u'ENSMUSG00000016933', u'ENSMUSG00000006386', u'ENSMUSG00000019579', u'ENSMUSG00000015839', u'ENSMUSG00000000530', u'ENSMUSG00000036478', u'ENSMUSG00000030525', u'ENSMUSG00000021994', u'ENSMUSG00000032035', u'ENSMUSG00000031778', u'ENSMUSG00000015468', u'ENSMUSG00000022469', u'ENSMUSG00000029106', u'ENSMUSG00000010051', u'ENSMUSG00000037568', u'ENSMUSG00000050335', u'ENSMUSG00000015305', u'ENSMUSG00000029484', u'ENSMUSG00000040552', u'ENSMUSG00000032440', u'ENSMUSG00000029648', u'ENSMUSG00000028864', u'ENSMUSG00000036585', u'ENSMUSG00000019803', u'ENSMUSG00000004951', u'ENSMUSG00000022952', u'ENSMUSG00000021109', u'ENSMUSG00000028978', u'ENSMUSG00000020063', u'ENSMUSG00000061436', u'ENSMUSG00000023031', u'ENSMUSG00000017146', u'ENSMUSG00000022231', u'ENSMUSG00000026814', u'ENSMUSG00000028194', u'ENSMUSG00000024164', u'ENSMUSG00000024087', u'ENSMUSG00000050965', u'ENSMUSG00000015340', u'ENSMUSG00000064246', u'ENSMUSG00000004791', u'ENSMUSG00000016494', u'ENSMUSG00000027399', u'ENSMUSG00000024962', u'ENSMUSG00000002688', u'ENSMUSG00000030341', u'ENSMUSG00000032359', u'ENSMUSG00000061878', u'ENSMUSG00000020689', u'ENSMUSG00000046318', u'ENSMUSG00000021583', u'ENSMUSG00000041187', u'ENSMUSG00000040152', u'ENSMUSG00000052821', u'ENSMUSG00000000290', u'ENSMUSG00000005413', u'ENSMUSG00000062960', u'ENSMUSG00000028128', u'ENSMUSG00000054364', u'ENSMUSG00000059456', u'ENSMUSG00000004655', u'ENSMUSG00000052336', u'ENSMUSG00000022255', u'ENSMUSG00000046207', u'ENSMUSG00000026078', u'ENSMUSG00000028108', u'ENSMUSG00000001240', u'ENSMUSG00000052889', u'ENSMUSG00000037411', u'ENSMUSG00000023951']), pop_n=13836, p_sm_bonferroni=4.351516298258824e-06, is_obsolete=False, GO='GO:0045766', name='positive regulation of angiogenesis', pop_count=75, alt_ids=[], level=6, depth=7, enrichment='e', Cluster='Late Increase', geneid_set=set([u'ENSMUSG00000061436', u'ENSMUSG00000028128', u'ENSMUSG00000016494', u'ENSMUSG00000028194', u'ENSMUSG00000024164', u'ENSMUSG00000015340', u'ENSMUSG00000029648', u'ENSMUSG00000064246', u'ENSMUSG00000015839', u'ENSMUSG00000036478', u'ENSMUSG00000019803', u'ENSMUSG00000032359', u'ENSMUSG00000010051', u'ENSMUSG00000024087', u'ENSMUSG00000050335', u'ENSMUSG00000015305', u'ENSMUSG00000040152', u'ENSMUSG00000029484', u'ENSMUSG00000022469', u'ENSMUSG00000037411', u'ENSMUSG00000032440', u'ENSMUSG00000006386', u'ENSMUSG00000028864', u'ENSMUSG00000036585', u'ENSMUSG00000023031', u'ENSMUSG00000052336', u'ENSMUSG00000032035', u'ENSMUSG00000040552']), symbols=u'Anxa3 Btg1 C3 C3ar1 Cd34 Cela1 Chil1 Ctsh Cx3cr1 Cybb Cyp1b1 Ddah1 Ets1 F3 Fgf1 Flt1 Hgf Hipk2 Hyal1 Lgals3 Nfe2l2 Nr2e1 Rapgef3 Sash1 Serpine1 Tek Tgfbr2 Thbs1', symbol_set=set([u'Cyp1b1', u'Hgf', u'Lgals3', u'Ctsh', u'Anxa3', u'Btg1', u'Cd34', u'Ddah1', u'C3', u'Cela1', u'Tgfbr2', u'Cx3cr1', u'Nfe2l2', u'Hyal1', u'Thbs1', u'Tek', u'Nr2e1', u'Serpine1', u'Fgf1', u'Flt1', 'Chil1', u'F3', u'C3ar1', u'Cybb', u'Hipk2', u'Ets1', u'Rapgef3', u'Sash1']), geneids='ENSMUSG00000061436 ENSMUSG00000029648 ENSMUSG00000015839 ENSMUSG00000036478 ENSMUSG00000032035 ENSMUSG00000010051 ENSMUSG00000050335 ENSMUSG00000015305 ENSMUSG00000029484 ENSMUSG00000032440 ENSMUSG00000006386 ENSMUSG00000028864 ENSMUSG00000036585 ENSMUSG00000023031 ENSMUSG00000032359 ENSMUSG00000028194 ENSMUSG00000024164 ENSMUSG00000015340 ENSMUSG00000064246 ENSMUSG00000016494 ENSMUSG00000040552 ENSMUSG00000024087 ENSMUSG00000040152 ENSMUSG00000022469 ENSMUSG00000037411 ENSMUSG00000028128 ENSMUSG00000052336 ENSMUSG00000019803', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=5, D1='A', GO_name='positive regulation of angiogenesis'),
    Nt(p_uncorrected=7.466568074537685e-05, study_count=94, study_n=1397, namespace='biological_process', p_fdr_bh=0.009668886572420552, study_items=set([u'ENSMUSG00000002812', u'ENSMUSG00000034957', u'ENSMUSG00000001761', u'ENSMUSG00000036606', u'ENSMUSG00000051910', u'ENSMUSG00000042453', u'ENSMUSG00000028583', u'ENSMUSG00000038612', u'ENSMUSG00000020372', u'ENSMUSG00000063506', u'ENSMUSG00000061524', u'ENSMUSG00000027878', u'ENSMUSG00000023066', u'ENSMUSG00000010461', u'ENSMUSG00000020105', u'ENSMUSG00000003812', u'ENSMUSG00000079470', u'ENSMUSG00000025931', u'ENSMUSG00000046731', u'ENSMUSG00000021127', u'ENSMUSG00000029710', u'ENSMUSG00000030272', u'ENSMUSG00000040010', u'ENSMUSG00000020844', u'ENSMUSG00000024913', u'ENSMUSG00000048402', u'ENSMUSG00000037016', u'ENSMUSG00000022309', u'ENSMUSG00000041703', u'ENSMUSG00000022150', u'ENSMUSG00000002274', u'ENSMUSG00000042745', u'ENSMUSG00000027253', u'ENSMUSG00000016028', u'ENSMUSG00000062209', u'ENSMUSG00000039361', u'ENSMUSG00000075254', u'ENSMUSG00000027239', u'ENSMUSG00000029705', u'ENSMUSG00000026249', u'ENSMUSG00000023008', u'ENSMUSG00000032006', u'ENSMUSG00000020644', u'ENSMUSG00000032278', u'ENSMUSG00000020122', u'ENSMUSG00000022025', u'ENSMUSG00000026923', u'ENSMUSG00000021453', u'ENSMUSG00000028780', u'ENSMUSG00000048782', u'ENSMUSG00000028150', u'ENSMUSG00000030701', u'ENSMUSG00000004558', u'ENSMUSG00000024620', u'ENSMUSG00000019803', u'ENSMUSG00000031785', u'ENSMUSG00000024420', u'ENSMUSG00000027200', u'ENSMUSG00000020231', u'ENSMUSG00000022297', u'ENSMUSG00000026586', u'ENSMUSG00000040596', u'ENSMUSG00000068270', u'ENSMUSG00000007872', u'ENSMUSG00000025555', u'ENSMUSG00000069170', u'ENSMUSG00000028042', u'ENSMUSG00000062078', u'ENSMUSG00000057103', u'ENSMUSG00000029778', u'ENSMUSG00000021366', u'ENSMUSG00000028517', u'ENSMUSG00000046160', u'ENSMUSG00000036192', u'ENSMUSG00000045817', u'ENSMUSG00000028173', u'ENSMUSG00000035158', u'ENSMUSG00000029648', u'ENSMUSG00000018654', u'ENSMUSG00000036585', u'ENSMUSG00000038648', u'ENSMUSG00000039004', u'ENSMUSG00000024063', u'ENSMUSG00000021540', u'ENSMUSG00000074637', u'ENSMUSG00000022678', u'ENSMUSG00000055254', u'ENSMUSG00000027168', u'ENSMUSG00000031320', u'ENSMUSG00000021136', u'ENSMUSG00000044786', u'ENSMUSG00000037621', u'ENSMUSG00000002007', u'ENSMUSG00000028599']), NS='BP', pop_items=set([u'ENSMUSG00000026494', u'ENSMUSG00000026491', u'ENSMUSG00000047907', u'ENSMUSG00000029516', u'ENSMUSG00000059325', u'ENSMUSG00000008999', u'ENSMUSG00000059327', u'ENSMUSG00000016481', u'ENSMUSG00000028344', u'ENSMUSG00000004891', u'ENSMUSG00000030447', u'ENSMUSG00000045005', u'ENSMUSG00000034401', u'ENSMUSG00000026249', u'ENSMUSG00000030180', u'ENSMUSG00000027668', u'ENSMUSG00000033726', u'ENSMUSG00000026790', u'ENSMUSG00000004056', u'ENSMUSG00000030592', u'ENSMUSG00000026167', u'ENSMUSG00000042453', u'ENSMUSG00000049295', u'ENSMUSG00000015120', u'ENSMUSG00000049354', u'ENSMUSG00000024042', u'ENSMUSG00000048078', u'ENSMUSG00000014303', u'ENSMUSG00000021217', u'ENSMUSG00000022098', u'ENSMUSG00000068154', u'ENSMUSG00000051379', u'ENSMUSG00000028347', u'ENSMUSG00000023068', u'ENSMUSG00000059824', u'ENSMUSG00000023066', u'ENSMUSG00000035725', u'ENSMUSG00000036036', u'ENSMUSG00000006095', u'ENSMUSG00000020105', u'ENSMUSG00000036030', u'ENSMUSG00000032419', u'ENSMUSG00000020513', u'ENSMUSG00000020364', u'ENSMUSG00000025931', u'ENSMUSG00000090258', u'ENSMUSG00000042460', u'ENSMUSG00000002812', u'ENSMUSG00000020530', u'ENSMUSG00000015468', u'ENSMUSG00000070814', u'ENSMUSG00000022309', u'ENSMUSG00000022710', u'ENSMUSG00000043051', u'ENSMUSG00000002274', u'ENSMUSG00000021281', u'ENSMUSG00000006958', u'ENSMUSG00000021136', u'ENSMUSG00000026930', u'ENSMUSG00000026833', u'ENSMUSG00000026311', u'ENSMUSG00000036766', u'ENSMUSG00000029705', u'ENSMUSG00000028796', u'ENSMUSG00000066568', u'ENSMUSG00000022231', u'ENSMUSG00000001300', u'ENSMUSG00000050071', u'ENSMUSG00000025231', u'ENSMUSG00000036856', u'ENSMUSG00000058440', u'ENSMUSG00000055254', u'ENSMUSG00000074637', u'ENSMUSG00000000627', u'ENSMUSG00000026610', u'ENSMUSG00000059049', u'ENSMUSG00000049313', u'ENSMUSG00000039062', u'ENSMUSG00000039108', u'ENSMUSG00000032744', u'ENSMUSG00000035984', u'ENSMUSG00000025158', u'ENSMUSG00000028572', u'ENSMUSG00000020827', u'ENSMUSG00000036606', u'ENSMUSG00000010175', u'ENSMUSG00000027239', u'ENSMUSG00000028150', u'ENSMUSG00000030701', u'ENSMUSG00000027230', u'ENSMUSG00000029778', u'ENSMUSG00000015605', u'ENSMUSG00000031906', u'ENSMUSG00000008318', u'ENSMUSG00000030772', u'ENSMUSG00000061911', u'ENSMUSG00000030123', u'ENSMUSG00000037211', u'ENSMUSG00000030533', u'ENSMUSG00000039852', u'ENSMUSG00000007989', u'ENSMUSG00000030539', u'ENSMUSG00000027751', u'ENSMUSG00000068270', u'ENSMUSG00000007872', u'ENSMUSG00000040836', u'ENSMUSG00000028389', u'ENSMUSG00000031548', u'ENSMUSG00000040297', u'ENSMUSG00000000325', u'ENSMUSG00000010797', u'ENSMUSG00000032064', u'ENSMUSG00000035764', u'ENSMUSG00000019647', u'ENSMUSG00000053552', u'ENSMUSG00000039781', u'ENSMUSG00000025876', u'ENSMUSG00000062078', u'ENSMUSG00000028519', u'ENSMUSG00000021366', u'ENSMUSG00000015501', u'ENSMUSG00000029071', u'ENSMUSG00000051243', u'ENSMUSG00000036192', u'ENSMUSG00000026235', u'ENSMUSG00000006418', u'ENSMUSG00000045817', u'ENSMUSG00000018604', u'ENSMUSG00000044813', u'ENSMUSG00000047003', u'ENSMUSG00000042903', u'ENSMUSG00000002981', u'ENSMUSG00000056596', u'ENSMUSG00000032280', u'ENSMUSG00000021848', u'ENSMUSG00000063506', u'ENSMUSG00000040596', u'ENSMUSG00000038264', u'ENSMUSG00000059146', u'ENSMUSG00000067860', u'ENSMUSG00000022678', u'ENSMUSG00000039087', u'ENSMUSG00000036208', u'ENSMUSG00000031954', u'ENSMUSG00000029672', u'ENSMUSG00000036617', u'ENSMUSG00000001227', u'ENSMUSG00000048616', u'ENSMUSG00000028851', u'ENSMUSG00000047261', u'ENSMUSG00000037621', u'ENSMUSG00000038146', u'ENSMUSG00000063281', u'ENSMUSG00000020099', u'ENSMUSG00000040249', u'ENSMUSG00000035277', u'ENSMUSG00000029754', u'ENSMUSG00000036432', u'ENSMUSG00000020694', u'ENSMUSG00000025358', u'ENSMUSG00000059552', u'ENSMUSG00000000126', u'ENSMUSG00000029594', u'ENSMUSG00000001761', u'ENSMUSG00000027276', u'ENSMUSG00000034488', u'ENSMUSG00000020950', u'ENSMUSG00000006673', u'ENSMUSG00000034480', u'ENSMUSG00000020895', u'ENSMUSG00000005583', u'ENSMUSG00000060475', u'ENSMUSG00000038612', u'ENSMUSG00000039745', u'ENSMUSG00000020186', u'ENSMUSG00000000085', u'ENSMUSG00000027878', u'ENSMUSG00000037001', u'ENSMUSG00000045648', u'ENSMUSG00000023277', u'ENSMUSG00000026159', u'ENSMUSG00000031971', u'ENSMUSG00000038593', u'ENSMUSG00000026259', u'ENSMUSG00000023473', u'ENSMUSG00000020745', u'ENSMUSG00000046731', u'ENSMUSG00000079259', u'ENSMUSG00000022382', u'ENSMUSG00000028780', u'ENSMUSG00000034023', u'ENSMUSG00000040010', u'ENSMUSG00000017386', u'ENSMUSG00000022995', u'ENSMUSG00000045515', u'ENSMUSG00000027004', u'ENSMUSG00000035754', u'ENSMUSG00000023015', u'ENSMUSG00000022150', u'ENSMUSG00000030272', u'ENSMUSG00000023980', u'ENSMUSG00000056493', u'ENSMUSG00000004934', u'ENSMUSG00000000811', u'ENSMUSG00000020052', u'ENSMUSG00000031391', u'ENSMUSG00000069763', u'ENSMUSG00000039361', u'ENSMUSG00000075254', u'ENSMUSG00000027434', u'ENSMUSG00000039910', u'ENSMUSG00000048915', u'ENSMUSG00000044674', u'ENSMUSG00000033276', u'ENSMUSG00000047787', u'ENSMUSG00000036099', u'ENSMUSG00000026321', u'ENSMUSG00000024182', u'ENSMUSG00000063972', u'ENSMUSG00000021974', u'ENSMUSG00000032278', u'ENSMUSG00000028354', u'ENSMUSG00000024754', u'ENSMUSG00000026921', u'ENSMUSG00000026923', u'ENSMUSG00000025932', u'ENSMUSG00000035279', u'ENSMUSG00000050199', u'ENSMUSG00000048416', u'ENSMUSG00000029710', u'ENSMUSG00000028664', u'ENSMUSG00000028661', u'ENSMUSG00000028718', u'ENSMUSG00000031785', u'ENSMUSG00000048782', u'ENSMUSG00000022201', u'ENSMUSG00000046982', u'ENSMUSG00000024620', u'ENSMUSG00000025223', u'ENSMUSG00000001729', u'ENSMUSG00000036840', u'ENSMUSG00000068747', u'ENSMUSG00000009418', u'ENSMUSG00000026586', u'ENSMUSG00000038797', u'ENSMUSG00000024807', u'ENSMUSG00000038793', u'ENSMUSG00000066043', u'ENSMUSG00000043557', u'ENSMUSG00000045671', u'ENSMUSG00000050069', u'ENSMUSG00000025316', u'ENSMUSG00000024247', u'ENSMUSG00000042156', u'ENSMUSG00000030201', u'ENSMUSG00000067071', u'ENSMUSG00000028042', u'ENSMUSG00000038080', u'ENSMUSG00000028289', u'ENSMUSG00000038976', u'ENSMUSG00000040998', u'ENSMUSG00000040850', u'ENSMUSG00000041911', u'ENSMUSG00000068206', u'ENSMUSG00000023456', u'ENSMUSG00000040693', u'ENSMUSG00000020096', u'ENSMUSG00000035011', u'ENSMUSG00000018654', u'ENSMUSG00000053626', u'ENSMUSG00000034889', u'ENSMUSG00000038648', u'ENSMUSG00000003421', u'ENSMUSG00000063160', u'ENSMUSG00000026064', u'ENSMUSG00000003812', u'ENSMUSG00000004328', u'ENSMUSG00000037017', u'ENSMUSG00000014329', u'ENSMUSG00000021278', u'ENSMUSG00000024063', u'ENSMUSG00000021540', u'ENSMUSG00000024381', u'ENSMUSG00000030341', u'ENSMUSG00000031217', u'ENSMUSG00000050310', u'ENSMUSG00000068740', u'ENSMUSG00000040389', u'ENSMUSG00000031661', u'ENSMUSG00000021098', u'ENSMUSG00000031320', u'ENSMUSG00000032128', u'ENSMUSG00000019979', u'ENSMUSG00000032125', u'ENSMUSG00000031283', u'ENSMUSG00000031284', u'ENSMUSG00000031285', u'ENSMUSG00000035293', u'ENSMUSG00000021835', u'ENSMUSG00000074221', u'ENSMUSG00000024140', u'ENSMUSG00000001103', u'ENSMUSG00000036196', u'ENSMUSG00000046058', u'ENSMUSG00000020308', u'ENSMUSG00000045328', u'ENSMUSG00000038255', u'ENSMUSG00000047193', u'ENSMUSG00000022568', u'ENSMUSG00000048826', u'ENSMUSG00000026883', u'ENSMUSG00000029610', u'ENSMUSG00000025001', u'ENSMUSG00000032228', u'ENSMUSG00000021493', u'ENSMUSG00000046985', u'ENSMUSG00000021945', u'ENSMUSG00000022240', u'ENSMUSG00000051910', u'ENSMUSG00000029291', u'ENSMUSG00000020063', u'ENSMUSG00000010592', u'ENSMUSG00000063632', u'ENSMUSG00000027797', u'ENSMUSG00000040312', u'ENSMUSG00000040310', u'ENSMUSG00000021693', u'ENSMUSG00000040254', u'ENSMUSG00000061524', u'ENSMUSG00000032940', u'ENSMUSG00000000489', u'ENSMUSG00000057098', u'ENSMUSG00000024969', u'ENSMUSG00000029335', u'ENSMUSG00000033066', u'ENSMUSG00000024962', u'ENSMUSG00000038518', u'ENSMUSG00000037643', u'ENSMUSG00000033486', u'ENSMUSG00000034336', u'ENSMUSG00000027087', u'ENSMUSG00000035632', u'ENSMUSG00000041775', u'ENSMUSG00000070697', u'ENSMUSG00000051703', u'ENSMUSG00000023092', u'ENSMUSG00000009569', u'ENSMUSG00000023905', u'ENSMUSG00000032482', u'ENSMUSG00000037995', u'ENSMUSG00000020844', u'ENSMUSG00000028556', u'ENSMUSG00000035842', u'ENSMUSG00000048402', u'ENSMUSG00000037016', u'ENSMUSG00000034832', u'ENSMUSG00000041319', u'ENSMUSG00000041702', u'ENSMUSG00000041703', u'ENSMUSG00000027314', u'ENSMUSG00000027860', u'ENSMUSG00000074001', u'ENSMUSG00000027722', u'ENSMUSG00000016181', u'ENSMUSG00000026141', u'ENSMUSG00000016028', u'ENSMUSG00000062209', u'ENSMUSG00000072115', u'ENSMUSG00000001419', u'ENSMUSG00000004791', u'ENSMUSG00000031310', u'ENSMUSG00000044461', u'ENSMUSG00000032368', u'ENSMUSG00000023008', u'ENSMUSG00000035062', u'ENSMUSG00000045180', u'ENSMUSG00000049382', u'ENSMUSG00000032006', u'ENSMUSG00000020644', u'ENSMUSG00000053477', u'ENSMUSG00000020122', u'ENSMUSG00000009207', u'ENSMUSG00000022025', u'ENSMUSG00000021743', u'ENSMUSG00000031380', u'ENSMUSG00000074505', u'ENSMUSG00000021994', u'ENSMUSG00000073639', u'ENSMUSG00000029020', u'ENSMUSG00000061013', u'ENSMUSG00000039994', u'ENSMUSG00000056820', u'ENSMUSG00000019803', u'ENSMUSG00000024427', u'ENSMUSG00000001157', u'ENSMUSG00000015092', u'ENSMUSG00000024420', u'ENSMUSG00000049791', u'ENSMUSG00000001521', u'ENSMUSG00000025810', u'ENSMUSG00000011658', u'ENSMUSG00000015312', u'ENSMUSG00000021820', u'ENSMUSG00000026915', u'ENSMUSG00000020231', u'ENSMUSG00000063063', u'ENSMUSG00000028583', u'ENSMUSG00000050288', u'ENSMUSG00000020547', u'ENSMUSG00000036745', u'ENSMUSG00000057666', u'ENSMUSG00000046318', u'ENSMUSG00000022602', u'ENSMUSG00000032217', u'ENSMUSG00000022607', u'ENSMUSG00000025555', u'ENSMUSG00000022960', u'ENSMUSG00000021395', u'ENSMUSG00000069170', u'ENSMUSG00000032911', u'ENSMUSG00000057103', u'ENSMUSG00000042408', u'ENSMUSG00000029381', u'ENSMUSG00000029576', u'ENSMUSG00000034957', u'ENSMUSG00000029570', u'ENSMUSG00000028517', u'ENSMUSG00000046160', u'ENSMUSG00000046167', u'ENSMUSG00000004558', u'ENSMUSG00000024253', u'ENSMUSG00000037375', u'ENSMUSG00000050600', u'ENSMUSG00000052087', u'ENSMUSG00000028173', u'ENSMUSG00000027210', u'ENSMUSG00000036585', u'ENSMUSG00000022911', u'ENSMUSG00000036940', u'ENSMUSG00000027351', u'ENSMUSG00000034460', u'ENSMUSG00000027358', u'ENSMUSG00000029502', u'ENSMUSG00000020166', u'ENSMUSG00000049421', u'ENSMUSG00000063275', u'ENSMUSG00000063273', u'ENSMUSG00000020160', u'ENSMUSG00000046449', u'ENSMUSG00000037239', u'ENSMUSG00000024098', u'ENSMUSG00000042369', u'ENSMUSG00000052534', u'ENSMUSG00000028291', u'ENSMUSG00000040669', u'ENSMUSG00000041362', u'ENSMUSG00000056962', u'ENSMUSG00000038777', u'ENSMUSG00000040913', u'ENSMUSG00000037348', u'ENSMUSG00000020372', u'ENSMUSG00000040506', u'ENSMUSG00000042446', u'ENSMUSG00000003410', u'ENSMUSG00000014773', u'ENSMUSG00000002007', u'ENSMUSG00000063531', u'ENSMUSG00000060798', u'ENSMUSG00000035158', u'ENSMUSG00000030218', u'ENSMUSG00000025856', u'ENSMUSG00000004661', u'ENSMUSG00000044337', u'ENSMUSG00000002799', u'ENSMUSG00000018169', u'ENSMUSG00000026556', u'ENSMUSG00000053838', u'ENSMUSG00000018160', u'ENSMUSG00000044548', u'ENSMUSG00000059857', u'ENSMUSG00000023079', u'ENSMUSG00000059854', u'ENSMUSG00000038742', u'ENSMUSG00000034675', u'ENSMUSG00000078202', u'ENSMUSG00000022074', u'ENSMUSG00000019843', u'ENSMUSG00000057969', u'ENSMUSG00000038122', u'ENSMUSG00000045333', u'ENSMUSG00000027551', u'ENSMUSG00000031075', u'ENSMUSG00000075706', u'ENSMUSG00000005958', u'ENSMUSG00000026890', u'ENSMUSG00000039830', u'ENSMUSG00000039834', u'ENSMUSG00000021488', u'ENSMUSG00000021483', u'ENSMUSG00000022114', u'ENSMUSG00000054364', u'ENSMUSG00000060534', u'ENSMUSG00000037894', u'ENSMUSG00000039004', u'ENSMUSG00000028832', u'ENSMUSG00000063626', u'ENSMUSG00000079470', u'ENSMUSG00000038331', u'ENSMUSG00000056947', u'ENSMUSG00000021127', u'ENSMUSG00000021681', u'ENSMUSG00000038564', u'ENSMUSG00000033075', u'ENSMUSG00000024913', u'ENSMUSG00000029231', u'ENSMUSG00000028882', u'ENSMUSG00000028883', u'ENSMUSG00000028886', u'ENSMUSG00000054469', u'ENSMUSG00000037652', u'ENSMUSG00000048001', u'ENSMUSG00000025207', u'ENSMUSG00000067786', u'ENSMUSG00000042745', u'ENSMUSG00000052516', u'ENSMUSG00000036904', u'ENSMUSG00000027253', u'ENSMUSG00000060985', u'ENSMUSG00000059921', u'ENSMUSG00000032776', u'ENSMUSG00000040929', u'ENSMUSG00000037984', u'ENSMUSG00000025020', u'ENSMUSG00000031558', u'ENSMUSG00000024068', u'ENSMUSG00000057315', u'ENSMUSG00000046010', u'ENSMUSG00000028019', u'ENSMUSG00000069565', u'ENSMUSG00000030771', u'ENSMUSG00000070576', u'ENSMUSG00000034457', u'ENSMUSG00000035517', u'ENSMUSG00000016344', u'ENSMUSG00000035513', u'ENSMUSG00000020484', u'ENSMUSG00000021635', u'ENSMUSG00000086040', u'ENSMUSG00000004768', u'ENSMUSG00000039110', u'ENSMUSG00000043969', u'ENSMUSG00000030077', u'ENSMUSG00000030093', u'ENSMUSG00000038065', u'ENSMUSG00000028064', u'ENSMUSG00000003934', u'ENSMUSG00000021451', u'ENSMUSG00000021453', u'ENSMUSG00000041936', u'ENSMUSG00000021224', u'ENSMUSG00000030557', u'ENSMUSG00000026121', u'ENSMUSG00000062232', u'ENSMUSG00000040289', u'ENSMUSG00000040123', u'ENSMUSG00000018736', u'ENSMUSG00000032076', u'ENSMUSG00000050947', u'ENSMUSG00000032179', u'ENSMUSG00000020656', u'ENSMUSG00000047414', u'ENSMUSG00000002768', u'ENSMUSG00000032078', u'ENSMUSG00000025969', u'ENSMUSG00000055639', u'ENSMUSG00000022297', u'ENSMUSG00000030323', u'ENSMUSG00000022389', u'ENSMUSG00000073489', u'ENSMUSG00000021313', u'ENSMUSG00000022883', u'ENSMUSG00000021319', u'ENSMUSG00000047084', u'ENSMUSG00000056427', u'ENSMUSG00000022048', u'ENSMUSG00000010461', u'ENSMUSG00000032101', u'ENSMUSG00000003233', u'ENSMUSG00000001127', u'ENSMUSG00000071350', u'ENSMUSG00000010505', u'ENSMUSG00000030499', u'ENSMUSG00000006215', u'ENSMUSG00000048731', u'ENSMUSG00000006711', u'ENSMUSG00000027680', u'ENSMUSG00000041075', u'ENSMUSG00000024793', u'ENSMUSG00000036698', u'ENSMUSG00000002190', u'ENSMUSG00000043099', u'ENSMUSG00000001627', u'ENSMUSG00000029648', u'ENSMUSG00000036550', u'ENSMUSG00000058886', u'ENSMUSG00000044786', u'ENSMUSG00000015942', u'ENSMUSG00000063659', u'ENSMUSG00000022812', u'ENSMUSG00000029469', u'ENSMUSG00000026768', u'ENSMUSG00000009828', u'ENSMUSG00000019789', u'ENSMUSG00000062960', u'ENSMUSG00000023951', u'ENSMUSG00000041773', u'ENSMUSG00000027168', u'ENSMUSG00000034701', u'ENSMUSG00000048450', u'ENSMUSG00000020888', u'ENSMUSG00000027200', u'ENSMUSG00000036955', u'ENSMUSG00000052133', u'ENSMUSG00000061462', u'ENSMUSG00000028599']), pop_n=13836, p_sm_bonferroni=1.0, is_obsolete=False, GO='GO:0007275', name='multicellular organism development', pop_count=625, alt_ids=[], level=3, depth=3, enrichment='e', Cluster='Late Increase', geneid_set=set([u'ENSMUSG00000026923', u'ENSMUSG00000037621', u'ENSMUSG00000035158', u'ENSMUSG00000021453', u'ENSMUSG00000029710', u'ENSMUSG00000021540', u'ENSMUSG00000002812', u'ENSMUSG00000019803', u'ENSMUSG00000034957', u'ENSMUSG00000027239', u'ENSMUSG00000001761', u'ENSMUSG00000028150', u'ENSMUSG00000030701', u'ENSMUSG00000004558', u'ENSMUSG00000062078', u'ENSMUSG00000024620', u'ENSMUSG00000036606', u'ENSMUSG00000031785', u'ENSMUSG00000051910', u'ENSMUSG00000042453', u'ENSMUSG00000028583', u'ENSMUSG00000038612', u'ENSMUSG00000020372', u'ENSMUSG00000024420', u'ENSMUSG00000026586', u'ENSMUSG00000063506', u'ENSMUSG00000061524', u'ENSMUSG00000040596', u'ENSMUSG00000002007', u'ENSMUSG00000027878', u'ENSMUSG00000021366', u'ENSMUSG00000068270', u'ENSMUSG00000010461', u'ENSMUSG00000025555', u'ENSMUSG00000023066', u'ENSMUSG00000007872', u'ENSMUSG00000020105', u'ENSMUSG00000039004', u'ENSMUSG00000079470', u'ENSMUSG00000025931', u'ENSMUSG00000046731', u'ENSMUSG00000028042', u'ENSMUSG00000021127', u'ENSMUSG00000057103', u'ENSMUSG00000029778', u'ENSMUSG00000028780', u'ENSMUSG00000030272', u'ENSMUSG00000020231', u'ENSMUSG00000044786', u'ENSMUSG00000040010', u'ENSMUSG00000020844', u'ENSMUSG00000028517', u'ENSMUSG00000022297', u'ENSMUSG00000046160', u'ENSMUSG00000024913', u'ENSMUSG00000036192', u'ENSMUSG00000048402', u'ENSMUSG00000037016', u'ENSMUSG00000022309', u'ENSMUSG00000045817', u'ENSMUSG00000041703', u'ENSMUSG00000028173', u'ENSMUSG00000022150', u'ENSMUSG00000029648', u'ENSMUSG00000018654', u'ENSMUSG00000002274', u'ENSMUSG00000038648', u'ENSMUSG00000036585', u'ENSMUSG00000042745', u'ENSMUSG00000027253', u'ENSMUSG00000003812', u'ENSMUSG00000016028', u'ENSMUSG00000062209', u'ENSMUSG00000024063', u'ENSMUSG00000039361', u'ENSMUSG00000075254', u'ENSMUSG00000048782', u'ENSMUSG00000029705', u'ENSMUSG00000074637', u'ENSMUSG00000022678', u'ENSMUSG00000055254', u'ENSMUSG00000026249', u'ENSMUSG00000027168', u'ENSMUSG00000031320', u'ENSMUSG00000023008', u'ENSMUSG00000021136', u'ENSMUSG00000027200', u'ENSMUSG00000032006', u'ENSMUSG00000020644', u'ENSMUSG00000032278', u'ENSMUSG00000020122', u'ENSMUSG00000069170', u'ENSMUSG00000022025', u'ENSMUSG00000028599']), symbols=u'Adcyap1r1 Adgrg1 Adgrv1 Angpt1 Arhgap22 Atoh8 Bmp6 Camk1 Cebpa Celsr1 Cnmd Creb3l2 Cux1 Dab2 Dip2a Dnase2a Egfr Ephb4 Erbb4 Eya4 Farp1 Fgf1 Flii Flt1 Fmnl3 Frem2 Fzd6 Gadd45g Gli2 Heg1 Hivep1 Id1 Id2 Id3 Ikzf1 Insc Kctd11 Lbh Lrig3 Lrp4 Lrp5 Mcl1 Mdk Metrn Mitf Nat8f1 Nde1 Ndrg2 Notch1 Notch2 Nr2e1 Ntrk2 Nxn Olig1 Paqr5 Paqr8 Pax6 Pdgfd Pdgfrb Pdpn Picalm Plekhb1 Plpp3 Plxnb2 Pogk Prrx1 Qk Rack1 Reln Rorb Rorc Rps4x Rttn Sema3c Sema6d Serpine2 Shroom4 Slc7a5 Smad5 Smo Smoc1 Sox2 Sox6 Srpk3 Tnfrsf1b Utp14b Wls Zbtb7b Zfp36 Zfp36l1 Zfp36l2 Zfp521 Zic2 Zic5', symbol_set=set([u'Pogk', u'Cux1', u'Nde1', u'Creb3l2', u'Zfp36', u'Fgf1', u'Mitf', u'Kctd11', u'Pdgfrb', u'Cebpa', u'Nr2e1', u'Sox2', u'Sox6', u'Picalm', u'Sema3c', u'Fzd6', u'Erbb4', u'Egfr', u'Zfp36l1', u'Zfp36l2', u'Lbh', u'Zbtb7b', u'Smo', u'Reln', u'Atoh8', u'Tnfrsf1b', 'Cnmd', u'Ndrg2', u'Angpt1', u'Hivep1', u'Srpk3', u'Lrig3', u'Wls', u'Plekhb1', u'Frem2', u'Flii', u'Sema6d', u'Adcyap1r1', 'Plpp3', u'Ephb4', u'Dip2a', u'Slc7a5', u'Gadd45g', u'Utp14b', u'Eya4', u'Smoc1', u'Olig1', u'Dnase2a', u'Pdgfd', u'Heg1', u'Pdpn', 'Nat8f1', 'Adgrv1', u'Insc', u'Lrp4', u'Lrp5', u'Smad5', u'Notch1', u'Notch2', u'Rps4x', u'Rttn', u'Rorc', u'Rorb', u'Ntrk2', u'Arhgap22', u'Pax6', u'Mcl1', u'Prrx1', u'Serpine2', u'Flt1', u'Paqr8', u'Zfp521', u'Paqr5', 'Adgrg1', u'Ikzf1', u'Id2', u'Id3', u'Id1', u'Dab2', u'Plxnb2', u'Shroom4', u'Metrn', u'Camk1', u'Fmnl3', u'Celsr1', u'Qk', u'Nxn', u'Bmp6', u'Farp1', u'Mdk', u'Gli2', u'Zic5', u'Zic2', 'Rack1']), geneids='ENSMUSG00000062209 ENSMUSG00000002812 ENSMUSG00000034957 ENSMUSG00000001761 ENSMUSG00000036606 ENSMUSG00000051910 ENSMUSG00000042453 ENSMUSG00000028583 ENSMUSG00000038612 ENSMUSG00000020372 ENSMUSG00000063506 ENSMUSG00000061524 ENSMUSG00000027878 ENSMUSG00000040010 ENSMUSG00000010461 ENSMUSG00000020105 ENSMUSG00000003812 ENSMUSG00000079470 ENSMUSG00000025931 ENSMUSG00000046731 ENSMUSG00000021127 ENSMUSG00000028780 ENSMUSG00000030272 ENSMUSG00000023066 ENSMUSG00000020844 ENSMUSG00000024913 ENSMUSG00000048402 ENSMUSG00000037016 ENSMUSG00000022309 ENSMUSG00000041703 ENSMUSG00000022150 ENSMUSG00000002274 ENSMUSG00000042745 ENSMUSG00000027253 ENSMUSG00000016028 ENSMUSG00000021136 ENSMUSG00000039361 ENSMUSG00000075254 ENSMUSG00000048782 ENSMUSG00000029705 ENSMUSG00000026249 ENSMUSG00000023008 ENSMUSG00000032006 ENSMUSG00000020644 ENSMUSG00000032278 ENSMUSG00000020122 ENSMUSG00000022025 ENSMUSG00000026923 ENSMUSG00000021453 ENSMUSG00000029710 ENSMUSG00000027239 ENSMUSG00000028150 ENSMUSG00000030701 ENSMUSG00000004558 ENSMUSG00000024620 ENSMUSG00000019803 ENSMUSG00000031785 ENSMUSG00000024420 ENSMUSG00000027200 ENSMUSG00000020231 ENSMUSG00000022297 ENSMUSG00000026586 ENSMUSG00000040596 ENSMUSG00000068270 ENSMUSG00000007872 ENSMUSG00000025555 ENSMUSG00000069170 ENSMUSG00000028042 ENSMUSG00000062078 ENSMUSG00000057103 ENSMUSG00000029778 ENSMUSG00000021366 ENSMUSG00000028517 ENSMUSG00000046160 ENSMUSG00000036192 ENSMUSG00000045817 ENSMUSG00000028173 ENSMUSG00000035158 ENSMUSG00000029648 ENSMUSG00000018654 ENSMUSG00000036585 ENSMUSG00000038648 ENSMUSG00000039004 ENSMUSG00000024063 ENSMUSG00000021540 ENSMUSG00000074637 ENSMUSG00000022678 ENSMUSG00000055254 ENSMUSG00000027168 ENSMUSG00000031320 ENSMUSG00000044786 ENSMUSG00000037621 ENSMUSG00000002007 ENSMUSG00000028599', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=22, D1='CEJ', GO_name='multicellular organism development'),
    Nt(p_uncorrected=3.624571589136256e-07, study_count=69, study_n=1397, namespace='biological_process', p_fdr_bh=0.00013728971036750854, study_items=set([u'ENSMUSG00000038539', u'ENSMUSG00000057103', u'ENSMUSG00000024620', u'ENSMUSG00000035158', u'ENSMUSG00000029455', u'ENSMUSG00000068290', u'ENSMUSG00000027985', u'ENSMUSG00000029304', u'ENSMUSG00000003031', u'ENSMUSG00000023010', u'ENSMUSG00000026193', u'ENSMUSG00000033685', u'ENSMUSG00000048402', u'ENSMUSG00000063856', u'ENSMUSG00000020919', u'ENSMUSG00000050335', u'ENSMUSG00000001761', u'ENSMUSG00000007613', u'ENSMUSG00000026796', u'ENSMUSG00000022150', u'ENSMUSG00000006386', u'ENSMUSG00000028864', u'ENSMUSG00000019803', u'ENSMUSG00000022136', u'ENSMUSG00000041417', u'ENSMUSG00000015149', u'ENSMUSG00000042745', u'ENSMUSG00000022037', u'ENSMUSG00000032359', u'ENSMUSG00000019920', u'ENSMUSG00000020053', u'ENSMUSG00000062209', u'ENSMUSG00000038612', u'ENSMUSG00000025860', u'ENSMUSG00000003849', u'ENSMUSG00000064325', u'ENSMUSG00000037815', u'ENSMUSG00000022122', u'ENSMUSG00000029999', u'ENSMUSG00000020357', u'ENSMUSG00000033006', u'ENSMUSG00000029084', u'ENSMUSG00000026285', u'ENSMUSG00000031451', u'ENSMUSG00000022309', u'ENSMUSG00000021318', u'ENSMUSG00000051234', u'ENSMUSG00000022781', u'ENSMUSG00000022488', u'ENSMUSG00000030720', u'ENSMUSG00000040152', u'ENSMUSG00000000567', u'ENSMUSG00000027187', u'ENSMUSG00000029915', u'ENSMUSG00000024610', u'ENSMUSG00000057329', u'ENSMUSG00000031328', u'ENSMUSG00000028163', u'ENSMUSG00000026031', u'ENSMUSG00000062312', u'ENSMUSG00000022051', u'ENSMUSG00000031760', u'ENSMUSG00000032060', u'ENSMUSG00000002602', u'ENSMUSG00000004043', u'ENSMUSG00000020122', u'ENSMUSG00000026074', u'ENSMUSG00000026317', u'ENSMUSG00000014776']), NS='BP', pop_items=set([u'ENSMUSG00000034926', u'ENSMUSG00000028341', u'ENSMUSG00000030189', u'ENSMUSG00000026796', u'ENSMUSG00000004056', u'ENSMUSG00000019777', u'ENSMUSG00000019772', u'ENSMUSG00000022010', u'ENSMUSG00000027944', u'ENSMUSG00000028333', u'ENSMUSG00000042745', u'ENSMUSG00000040888', u'ENSMUSG00000037815', u'ENSMUSG00000019986', u'ENSMUSG00000021559', u'ENSMUSG00000042350', u'ENSMUSG00000040152', u'ENSMUSG00000042429', u'ENSMUSG00000078566', u'ENSMUSG00000002307', u'ENSMUSG00000020361', u'ENSMUSG00000022781', u'ENSMUSG00000026942', u'ENSMUSG00000031642', u'ENSMUSG00000022309', u'ENSMUSG00000053175', u'ENSMUSG00000019823', u'ENSMUSG00000063810', u'ENSMUSG00000006386', u'ENSMUSG00000024190', u'ENSMUSG00000020048', u'ENSMUSG00000079562', u'ENSMUSG00000028800', u'ENSMUSG00000024639', u'ENSMUSG00000028657', u'ENSMUSG00000024610', u'ENSMUSG00000000787', u'ENSMUSG00000007613', u'ENSMUSG00000037148', u'ENSMUSG00000050697', u'ENSMUSG00000059363', u'ENSMUSG00000027835', u'ENSMUSG00000037366', u'ENSMUSG00000033685', u'ENSMUSG00000020919', u'ENSMUSG00000048218', u'ENSMUSG00000061878', u'ENSMUSG00000030538', u'ENSMUSG00000031429', u'ENSMUSG00000000441', u'ENSMUSG00000031548', u'ENSMUSG00000062312', u'ENSMUSG00000032060', u'ENSMUSG00000022122', u'ENSMUSG00000024392', u'ENSMUSG00000024395', u'ENSMUSG00000024397', u'ENSMUSG00000031616', u'ENSMUSG00000044702', u'ENSMUSG00000052957', u'ENSMUSG00000020484', u'ENSMUSG00000026234', u'ENSMUSG00000022051', u'ENSMUSG00000003541', u'ENSMUSG00000032115', u'ENSMUSG00000063856', u'ENSMUSG00000001131', u'ENSMUSG00000003228', u'ENSMUSG00000028495', u'ENSMUSG00000005871', u'ENSMUSG00000024789', u'ENSMUSG00000022672', u'ENSMUSG00000028756', u'ENSMUSG00000003644', u'ENSMUSG00000054387', u'ENSMUSG00000017491', u'ENSMUSG00000029910', u'ENSMUSG00000008136', u'ENSMUSG00000007659', u'ENSMUSG00000025907', u'ENSMUSG00000019942', u'ENSMUSG00000018965', u'ENSMUSG00000048251', u'ENSMUSG00000029752', u'ENSMUSG00000039145', u'ENSMUSG00000036432', u'ENSMUSG00000024975', u'ENSMUSG00000029455', u'ENSMUSG00000015994', u'ENSMUSG00000029591', u'ENSMUSG00000025993', u'ENSMUSG00000031760', u'ENSMUSG00000001761', u'ENSMUSG00000030629', u'ENSMUSG00000027177', u'ENSMUSG00000021109', u'ENSMUSG00000021103', u'ENSMUSG00000042608', u'ENSMUSG00000038612', u'ENSMUSG00000041741', u'ENSMUSG00000020184', u'ENSMUSG00000045038', u'ENSMUSG00000018697', u'ENSMUSG00000035828', u'ENSMUSG00000005514', u'ENSMUSG00000004069', u'ENSMUSG00000000567', u'ENSMUSG00000042500', u'ENSMUSG00000030059', u'ENSMUSG00000002413', u'ENSMUSG00000031870', u'ENSMUSG00000023067', u'ENSMUSG00000027951', u'ENSMUSG00000030271', u'ENSMUSG00000045515', u'ENSMUSG00000041417', u'ENSMUSG00000022150', u'ENSMUSG00000023010', u'ENSMUSG00000032405', u'ENSMUSG00000032402', u'ENSMUSG00000020053', u'ENSMUSG00000020052', u'ENSMUSG00000075256', u'ENSMUSG00000087260', u'ENSMUSG00000020357', u'ENSMUSG00000003283', u'ENSMUSG00000039910', u'ENSMUSG00000031155', u'ENSMUSG00000031628', u'ENSMUSG00000078812', u'ENSMUSG00000026285', u'ENSMUSG00000029036', u'ENSMUSG00000033307', u'ENSMUSG00000003604', u'ENSMUSG00000021877', u'ENSMUSG00000024026', u'ENSMUSG00000089682', u'ENSMUSG00000009772', u'ENSMUSG00000003031', u'ENSMUSG00000034612', u'ENSMUSG00000022449', u'ENSMUSG00000030654', u'ENSMUSG00000038542', u'ENSMUSG00000029361', u'ENSMUSG00000028718', u'ENSMUSG00000022200', u'ENSMUSG00000001642', u'ENSMUSG00000024620', u'ENSMUSG00000024621', u'ENSMUSG00000028864', u'ENSMUSG00000079037', u'ENSMUSG00000000631', u'ENSMUSG00000020225', u'ENSMUSG00000035086', u'ENSMUSG00000020704', u'ENSMUSG00000057113', u'ENSMUSG00000026585', u'ENSMUSG00000027297', u'ENSMUSG00000025364', u'ENSMUSG00000001729', u'ENSMUSG00000025001', u'ENSMUSG00000001034', u'ENSMUSG00000027598', u'ENSMUSG00000027187', u'ENSMUSG00000059456', u'ENSMUSG00000027223', u'ENSMUSG00000057342', u'ENSMUSG00000029915', u'ENSMUSG00000028964', u'ENSMUSG00000004040', u'ENSMUSG00000068290', u'ENSMUSG00000031928', u'ENSMUSG00000028410', u'ENSMUSG00000050335', u'ENSMUSG00000035158', u'ENSMUSG00000027985', u'ENSMUSG00000032350', u'ENSMUSG00000032359', u'ENSMUSG00000022114', u'ENSMUSG00000021546', u'ENSMUSG00000000915', u'ENSMUSG00000025860', u'ENSMUSG00000028854', u'ENSMUSG00000029999', u'ENSMUSG00000025868', u'ENSMUSG00000030341', u'ENSMUSG00000031668', u'ENSMUSG00000041319', u'ENSMUSG00000023043', u'ENSMUSG00000031328', u'ENSMUSG00000017716', u'ENSMUSG00000021835', u'ENSMUSG00000026361', u'ENSMUSG00000021936', u'ENSMUSG00000020516', u'ENSMUSG00000019579', u'ENSMUSG00000001288', u'ENSMUSG00000029207', u'ENSMUSG00000002250', u'ENSMUSG00000029104', u'ENSMUSG00000026317', u'ENSMUSG00000090877', u'ENSMUSG00000053754', u'ENSMUSG00000025507', u'ENSMUSG00000020063', u'ENSMUSG00000026705', u'ENSMUSG00000020423', u'ENSMUSG00000052293', u'ENSMUSG00000039239', u'ENSMUSG00000024962', u'ENSMUSG00000022488', u'ENSMUSG00000027496', u'ENSMUSG00000030965', u'ENSMUSG00000037992', u'ENSMUSG00000029535', u'ENSMUSG00000059552', u'ENSMUSG00000059263', u'ENSMUSG00000028416', u'ENSMUSG00000052684', u'ENSMUSG00000048402', u'ENSMUSG00000052593', u'ENSMUSG00000037012', u'ENSMUSG00000027646', u'ENSMUSG00000030867', u'ENSMUSG00000041498', u'ENSMUSG00000040359', u'ENSMUSG00000015149', u'ENSMUSG00000026142', u'ENSMUSG00000062209', u'ENSMUSG00000054611', u'ENSMUSG00000064325', u'ENSMUSG00000002289', u'ENSMUSG00000022982', u'ENSMUSG00000004655', u'ENSMUSG00000035064', u'ENSMUSG00000000308', u'ENSMUSG00000026031', u'ENSMUSG00000022020', u'ENSMUSG00000020122', u'ENSMUSG00000030314', u'ENSMUSG00000032187', u'ENSMUSG00000021994', u'ENSMUSG00000021868', u'ENSMUSG00000032463', u'ENSMUSG00000002602', u'ENSMUSG00000019803', u'ENSMUSG00000024039', u'ENSMUSG00000001151', u'ENSMUSG00000025422', u'ENSMUSG00000024740', u'ENSMUSG00000005087', u'ENSMUSG00000044167', u'ENSMUSG00000038412', u'ENSMUSG00000019969', u'ENSMUSG00000025889', u'ENSMUSG00000022607', u'ENSMUSG00000057329', u'ENSMUSG00000034342', u'ENSMUSG00000047242', u'ENSMUSG00000022961', u'ENSMUSG00000038160', u'ENSMUSG00000032604', u'ENSMUSG00000044014', u'ENSMUSG00000057103', u'ENSMUSG00000028680', u'ENSMUSG00000024953', u'ENSMUSG00000028518', u'ENSMUSG00000023944', u'ENSMUSG00000005533', u'ENSMUSG00000024927', u'ENSMUSG00000028179', u'ENSMUSG00000027193', u'ENSMUSG00000024997', u'ENSMUSG00000030720', u'ENSMUSG00000035642', u'ENSMUSG00000038845', u'ENSMUSG00000045827', u'ENSMUSG00000034460', u'ENSMUSG00000033730', u'ENSMUSG00000029501', u'ENSMUSG00000063273', u'ENSMUSG00000028195', u'ENSMUSG00000021701', u'ENSMUSG00000028354', u'ENSMUSG00000031451', u'ENSMUSG00000031450', u'ENSMUSG00000004043', u'ENSMUSG00000027678', u'ENSMUSG00000026074', u'ENSMUSG00000014776', u'ENSMUSG00000021555', u'ENSMUSG00000024073', u'ENSMUSG00000024079', u'ENSMUSG00000029053', u'ENSMUSG00000018160', u'ENSMUSG00000004264', u'ENSMUSG00000032788', u'ENSMUSG00000022174', u'ENSMUSG00000053113', u'ENSMUSG00000019966', u'ENSMUSG00000024176', u'ENSMUSG00000057367', u'ENSMUSG00000032253', u'ENSMUSG00000020079', u'ENSMUSG00000022255', u'ENSMUSG00000022812', u'ENSMUSG00000024778', u'ENSMUSG00000021670', u'ENSMUSG00000013663', u'ENSMUSG00000015709', u'ENSMUSG00000021486', u'ENSMUSG00000029304', u'ENSMUSG00000028639', u'ENSMUSG00000006818', u'ENSMUSG00000036867', u'ENSMUSG00000048482', u'ENSMUSG00000003849', u'ENSMUSG00000029547', u'ENSMUSG00000023912', u'ENSMUSG00000024537', u'ENSMUSG00000059278', u'ENSMUSG00000046010', u'ENSMUSG00000020857', u'ENSMUSG00000043535', u'ENSMUSG00000041245', u'ENSMUSG00000035455', u'ENSMUSG00000018604', u'ENSMUSG00000019428', u'ENSMUSG00000030890', u'ENSMUSG00000030093', u'ENSMUSG00000028261', u'ENSMUSG00000026196', u'ENSMUSG00000026193', u'ENSMUSG00000027746', u'ENSMUSG00000042557', u'ENSMUSG00000022136', u'ENSMUSG00000031781', u'ENSMUSG00000022037', u'ENSMUSG00000026048', u'ENSMUSG00000019920', u'ENSMUSG00000029084', u'ENSMUSG00000004535', u'ENSMUSG00000021318', u'ENSMUSG00000068686', u'ENSMUSG00000051234', u'ENSMUSG00000060803', u'ENSMUSG00000001127', u'ENSMUSG00000010911', u'ENSMUSG00000002580', u'ENSMUSG00000022684', u'ENSMUSG00000019970', u'ENSMUSG00000027568', u'ENSMUSG00000022508', u'ENSMUSG00000026864', u'ENSMUSG00000029863', u'ENSMUSG00000079110', u'ENSMUSG00000020326', u'ENSMUSG00000038539', u'ENSMUSG00000033006', u'ENSMUSG00000062960', u'ENSMUSG00000023951', u'ENSMUSG00000000184', u'ENSMUSG00000025980', u'ENSMUSG00000020390', u'ENSMUSG00000028163', u'ENSMUSG00000048450']), pop_n=13836, p_sm_bonferroni=0.005491588414700341, is_obsolete=False, GO='GO:0043066', name='negative regulation of apoptotic process', pop_count=366, alt_ids=['GO:0006916'], level=7, depth=7, enrichment='e', Cluster='Late Increase', geneid_set=set([u'ENSMUSG00000022150', u'ENSMUSG00000006386', u'ENSMUSG00000003031', u'ENSMUSG00000029455', u'ENSMUSG00000026193', u'ENSMUSG00000033685', u'ENSMUSG00000020919', u'ENSMUSG00000001761', u'ENSMUSG00000026796', u'ENSMUSG00000024620', u'ENSMUSG00000028864', u'ENSMUSG00000019803', u'ENSMUSG00000022136', u'ENSMUSG00000022037', u'ENSMUSG00000019920', u'ENSMUSG00000038612', u'ENSMUSG00000037815', u'ENSMUSG00000029084', u'ENSMUSG00000021318', u'ENSMUSG00000051234', u'ENSMUSG00000022781', u'ENSMUSG00000022488', u'ENSMUSG00000000567', u'ENSMUSG00000040152', u'ENSMUSG00000027187', u'ENSMUSG00000057329', u'ENSMUSG00000062312', u'ENSMUSG00000032060', u'ENSMUSG00000002602', u'ENSMUSG00000022122', u'ENSMUSG00000020053', u'ENSMUSG00000004043', u'ENSMUSG00000057103', u'ENSMUSG00000068290', u'ENSMUSG00000029304', u'ENSMUSG00000031760', u'ENSMUSG00000048402', u'ENSMUSG00000050335', u'ENSMUSG00000041417', u'ENSMUSG00000030720', u'ENSMUSG00000035158', u'ENSMUSG00000027985', u'ENSMUSG00000023010', u'ENSMUSG00000063856', u'ENSMUSG00000015149', u'ENSMUSG00000042745', u'ENSMUSG00000032359', u'ENSMUSG00000038539', u'ENSMUSG00000062209', u'ENSMUSG00000022051', u'ENSMUSG00000025860', u'ENSMUSG00000003849', u'ENSMUSG00000029999', u'ENSMUSG00000064325', u'ENSMUSG00000020357', u'ENSMUSG00000033006', u'ENSMUSG00000031451', u'ENSMUSG00000022309', u'ENSMUSG00000026285', u'ENSMUSG00000029915', u'ENSMUSG00000024610', u'ENSMUSG00000031328', u'ENSMUSG00000028163', u'ENSMUSG00000007613', u'ENSMUSG00000026031', u'ENSMUSG00000020122', u'ENSMUSG00000026074', u'ENSMUSG00000026317', u'ENSMUSG00000014776']), symbols=u'Aldh2 Angpt1 Atf5 Axl Bcl2 Bnip3l Cat Cd38 Cd74 Cdkn1b Cflar Clec5a Cln3 Cln8 Clu Cryab Ctnna1 Ctsh Dab2 Ddrgk1 Dnajc3 Ednrb Egfr Erbb2 Erbb4 Fam129b Flna Flt4 Fn1 Gas6 Gli2 Gli3 Gpx1 Hgf Hhip Id1 Igf1 Lef1 Lgals3 Lims1 Map4k4 Mcl1 Mitf Mt3 Nat8f1 Nckap1l Nfkb1 Nol3 Nqo1 Nr2e1 Pak2 Pdcd1 Pdgfrb Pik3r1 Rnf7 Sirt2 Smo Sox10 Sox9 Spp1 Stat5a Stat5b Tek Tgfa Tgfbr1 Thbs1 Tmbim6 Ucp2 Xiap', symbol_set=set([u'Nfkb1', u'Igf1', u'Bnip3l', u'Fn1', u'Flna', u'Mt3', u'Cryab', u'Id1', u'Smo', u'Lgals3', u'Clec5a', u'Cln8', u'Fam129b', u'Hgf', u'Clu', u'Ucp2', u'Lef1', u'Nqo1', u'Cd38', u'Tmbim6', u'Map4k4', u'Stat5b', u'Xiap', 'Nat8f1', u'Cd74', u'Gpx1', u'Lims1', u'Spp1', u'Nol3', u'Mitf', u'Rnf7', u'Angpt1', u'Flt4', u'Bcl2', u'Tgfa', u'Ctsh', u'Tgfbr1', u'Cflar', u'Sirt2', u'Cdkn1b', u'Aldh2', u'Thbs1', u'Dab2', u'Atf5', u'Nckap1l', u'Nr2e1', u'Pik3r1', u'Pdcd1', u'Ednrb', u'Cat', u'Ctnna1', u'Axl', u'Hhip', u'Erbb2', u'Pdgfrb', u'Tek', u'Erbb4', u'Sox10', u'Egfr', u'Dnajc3', u'Gli2', u'Gli3', u'Stat5a', u'Sox9', u'Cln3', u'Ddrgk1', u'Gas6', u'Pak2', u'Mcl1']), geneids='ENSMUSG00000038539 ENSMUSG00000024610 ENSMUSG00000057103 ENSMUSG00000024620 ENSMUSG00000035158 ENSMUSG00000029455 ENSMUSG00000068290 ENSMUSG00000027985 ENSMUSG00000022781 ENSMUSG00000026796 ENSMUSG00000003031 ENSMUSG00000028864 ENSMUSG00000026193 ENSMUSG00000031760 ENSMUSG00000033685 ENSMUSG00000048402 ENSMUSG00000063856 ENSMUSG00000020919 ENSMUSG00000022309 ENSMUSG00000001761 ENSMUSG00000007613 ENSMUSG00000002602 ENSMUSG00000022150 ENSMUSG00000006386 ENSMUSG00000023010 ENSMUSG00000019803 ENSMUSG00000022136 ENSMUSG00000041417 ENSMUSG00000015149 ENSMUSG00000042745 ENSMUSG00000022037 ENSMUSG00000032359 ENSMUSG00000051234 ENSMUSG00000019920 ENSMUSG00000020053 ENSMUSG00000062209 ENSMUSG00000038612 ENSMUSG00000025860 ENSMUSG00000003849 ENSMUSG00000064325 ENSMUSG00000037815 ENSMUSG00000029999 ENSMUSG00000020357 ENSMUSG00000033006 ENSMUSG00000029084 ENSMUSG00000031451 ENSMUSG00000050335 ENSMUSG00000021318 ENSMUSG00000026285 ENSMUSG00000029304 ENSMUSG00000022488 ENSMUSG00000030720 ENSMUSG00000040152 ENSMUSG00000000567 ENSMUSG00000027187 ENSMUSG00000029915 ENSMUSG00000004043 ENSMUSG00000057329 ENSMUSG00000031328 ENSMUSG00000028163 ENSMUSG00000062312 ENSMUSG00000022051 ENSMUSG00000026031 ENSMUSG00000032060 ENSMUSG00000022122 ENSMUSG00000020122 ENSMUSG00000026074 ENSMUSG00000026317 ENSMUSG00000014776', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=90, D1='A', GO_name='negative regulation of apoptotic process'),
    Nt(p_uncorrected='', study_count='', study_n='', namespace='', p_fdr_bh='', study_items='', NS='BP', pop_items='', pop_n='', p_sm_bonferroni='', is_obsolete='', GO='GO:0006468', name='', pop_count='', alt_ids='', level=6, depth=7, enrichment='', Cluster='', geneid_set='', symbols='', symbol_set='', geneids='', format_txt=1, hdr_idx=1, is_hdrgo=True, is_usrgo=False, hdr1usr01='*', dcnt=97, D1='BD', GO_name='protein phosphorylation'),
    Nt(p_uncorrected='', study_count='', study_n='', namespace='', p_fdr_bh='', study_items='', NS='BP', pop_items='', pop_n='', p_sm_bonferroni='', is_obsolete='', GO='GO:0019216', name='', pop_count='', alt_ids='', level=5, depth=5, enrichment='', Cluster='', geneid_set='', symbols='', symbol_set='', geneids='', format_txt=1, hdr_idx=1, is_hdrgo=True, is_usrgo=False, hdr1usr01='*', dcnt=267, D1='A', GO_name='regulation of lipid metabolic process'),
    Nt(p_uncorrected=0.00044925982953889274, study_count=5, study_n=1397, namespace='biological_process', p_fdr_bh=0.03781519820746535, study_items=set([u'ENSMUSG00000025351', u'ENSMUSG00000031328', u'ENSMUSG00000022150', u'ENSMUSG00000022505', u'ENSMUSG00000019920']), NS='BP', pop_items=set([u'ENSMUSG00000031328', u'ENSMUSG00000022150', u'ENSMUSG00000024395', u'ENSMUSG00000024713', u'ENSMUSG00000022099', u'ENSMUSG00000025351', u'ENSMUSG00000022505', u'ENSMUSG00000019920']), pop_n=13836, p_sm_bonferroni=1.0, is_obsolete=False, GO='GO:2001046', name='positive regulation of integrin-mediated signaling pathway', pop_count=8, alt_ids=[], level=6, depth=7, enrichment='e', Cluster='Late Increase', geneid_set=set([u'ENSMUSG00000025351', u'ENSMUSG00000031328', u'ENSMUSG00000022150', u'ENSMUSG00000022505', u'ENSMUSG00000019920']), symbols=u'Cd63 Dab2 Emp2 Flna Lims1', symbol_set=set([u'Flna', u'Emp2', u'Cd63', u'Lims1', u'Dab2']), geneids='ENSMUSG00000025351 ENSMUSG00000031328 ENSMUSG00000022150 ENSMUSG00000022505 ENSMUSG00000019920', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=0, D1='A', GO_name='positive regulation of integrin-mediated signaling pathway'),
    Nt(p_uncorrected=9.990149045304981e-05, study_count=39, study_n=1397, namespace='biological_process', p_fdr_bh=0.012351011267362396, study_items=set([u'ENSMUSG00000029771', u'ENSMUSG00000052384', u'ENSMUSG00000038521', u'ENSMUSG00000013707', u'ENSMUSG00000021457', u'ENSMUSG00000017707', u'ENSMUSG00000036887', u'ENSMUSG00000024371', u'ENSMUSG00000050335', u'ENSMUSG00000002602', u'ENSMUSG00000026471', u'ENSMUSG00000053158', u'ENSMUSG00000003184', u'ENSMUSG00000023224', u'ENSMUSG00000037523', u'ENSMUSG00000036908', u'ENSMUSG00000028874', u'ENSMUSG00000076617', u'ENSMUSG00000014932', u'ENSMUSG00000039005', u'ENSMUSG00000060591', u'ENSMUSG00000024164', u'ENSMUSG00000033777', u'ENSMUSG00000059883', u'ENSMUSG00000015340', u'ENSMUSG00000044583', u'ENSMUSG00000022575', u'ENSMUSG00000078942', u'ENSMUSG00000078945', u'ENSMUSG00000029915', u'ENSMUSG00000034317', u'ENSMUSG00000044827', u'ENSMUSG00000028163', u'ENSMUSG00000020399', u'ENSMUSG00000004707', u'ENSMUSG00000051439', u'ENSMUSG00000026365', u'ENSMUSG00000023992', u'ENSMUSG00000038147']), NS='BP', pop_items=set([u'ENSMUSG00000028099', u'ENSMUSG00000035834', u'ENSMUSG00000045322', u'ENSMUSG00000028874', u'ENSMUSG00000031103', u'ENSMUSG00000021703', u'ENSMUSG00000024079', u'ENSMUSG00000074151', u'ENSMUSG00000016481', u'ENSMUSG00000055172', u'ENSMUSG00000036887', u'ENSMUSG00000009585', u'ENSMUSG00000020455', u'ENSMUSG00000047123', u'ENSMUSG00000022476', u'ENSMUSG00000024371', u'ENSMUSG00000042228', u'ENSMUSG00000000266', u'ENSMUSG00000017707', u'ENSMUSG00000071369', u'ENSMUSG00000026399', u'ENSMUSG00000037523', u'ENSMUSG00000038628', u'ENSMUSG00000020115', u'ENSMUSG00000076617', u'ENSMUSG00000000776', u'ENSMUSG00000019843', u'ENSMUSG00000035235', u'ENSMUSG00000015217', u'ENSMUSG00000028530', u'ENSMUSG00000039236', u'ENSMUSG00000036908', u'ENSMUSG00000024164', u'ENSMUSG00000026842', u'ENSMUSG00000020275', u'ENSMUSG00000024045', u'ENSMUSG00000015340', u'ENSMUSG00000075705', u'ENSMUSG00000025280', u'ENSMUSG00000022791', u'ENSMUSG00000005566', u'ENSMUSG00000026596', u'ENSMUSG00000029605', u'ENSMUSG00000026896', u'ENSMUSG00000025199', u'ENSMUSG00000014599', u'ENSMUSG00000022607', u'ENSMUSG00000030966', u'ENSMUSG00000032312', u'ENSMUSG00000051439', u'ENSMUSG00000038058', u'ENSMUSG00000025512', u'ENSMUSG00000050199', u'ENSMUSG00000026154', u'ENSMUSG00000001366', u'ENSMUSG00000000275', u'ENSMUSG00000027951', u'ENSMUSG00000021326', u'ENSMUSG00000070390', u'ENSMUSG00000036986', u'ENSMUSG00000025139', u'ENSMUSG00000004707', u'ENSMUSG00000025034', u'ENSMUSG00000026883', u'ENSMUSG00000058715', u'ENSMUSG00000032691', u'ENSMUSG00000018446', u'ENSMUSG00000006519', u'ENSMUSG00000027995', u'ENSMUSG00000028885', u'ENSMUSG00000029826', u'ENSMUSG00000027646', u'ENSMUSG00000003184', u'ENSMUSG00000031805', u'ENSMUSG00000016024', u'ENSMUSG00000054072', u'ENSMUSG00000051675', u'ENSMUSG00000037860', u'ENSMUSG00000036905', u'ENSMUSG00000004933', u'ENSMUSG00000031392', u'ENSMUSG00000060591', u'ENSMUSG00000055204', u'ENSMUSG00000041000', u'ENSMUSG00000045932', u'ENSMUSG00000072115', u'ENSMUSG00000033777', u'ENSMUSG00000059883', u'ENSMUSG00000027598', u'ENSMUSG00000003283', u'ENSMUSG00000033124', u'ENSMUSG00000044583', u'ENSMUSG00000002688', u'ENSMUSG00000039853', u'ENSMUSG00000078942', u'ENSMUSG00000078945', u'ENSMUSG00000027639', u'ENSMUSG00000033307', u'ENSMUSG00000034889', u'ENSMUSG00000000787', u'ENSMUSG00000034453', u'ENSMUSG00000020641', u'ENSMUSG00000024457', u'ENSMUSG00000023992', u'ENSMUSG00000025532', u'ENSMUSG00000000386', u'ENSMUSG00000052384', u'ENSMUSG00000070034', u'ENSMUSG00000027427', u'ENSMUSG00000026928', u'ENSMUSG00000035279', u'ENSMUSG00000030793', u'ENSMUSG00000021457', u'ENSMUSG00000074896', u'ENSMUSG00000024948', u'ENSMUSG00000031639', u'ENSMUSG00000020823', u'ENSMUSG00000028041', u'ENSMUSG00000025498', u'ENSMUSG00000032508', u'ENSMUSG00000002602', u'ENSMUSG00000053647', u'ENSMUSG00000053158', u'ENSMUSG00000024621', u'ENSMUSG00000066232', u'ENSMUSG00000036896', u'ENSMUSG00000025225', u'ENSMUSG00000071203', u'ENSMUSG00000030880', u'ENSMUSG00000032175', u'ENSMUSG00000041135', u'ENSMUSG00000014932', u'ENSMUSG00000021624', u'ENSMUSG00000020707', u'ENSMUSG00000017830', u'ENSMUSG00000046879', u'ENSMUSG00000024349', u'ENSMUSG00000033454', u'ENSMUSG00000022514', u'ENSMUSG00000022887', u'ENSMUSG00000023973', u'ENSMUSG00000043496', u'ENSMUSG00000057982', u'ENSMUSG00000036712', u'ENSMUSG00000025492', u'ENSMUSG00000032109', u'ENSMUSG00000060802', u'ENSMUSG00000029798', u'ENSMUSG00000032344', u'ENSMUSG00000059456', u'ENSMUSG00000026117', u'ENSMUSG00000040296', u'ENSMUSG00000032690', u'ENSMUSG00000056851', u'ENSMUSG00000038160', u'ENSMUSG00000022043', u'ENSMUSG00000034317', u'ENSMUSG00000001128', u'ENSMUSG00000029771', u'ENSMUSG00000013707', u'ENSMUSG00000032661', u'ENSMUSG00000038521', u'ENSMUSG00000020399', u'ENSMUSG00000031750', u'ENSMUSG00000046718', u'ENSMUSG00000024927', u'ENSMUSG00000031537', u'ENSMUSG00000024483', u'ENSMUSG00000050335', u'ENSMUSG00000032688', u'ENSMUSG00000026471', u'ENSMUSG00000032905', u'ENSMUSG00000038517', u'ENSMUSG00000023341', u'ENSMUSG00000000127', u'ENSMUSG00000023224', u'ENSMUSG00000015947', u'ENSMUSG00000027514', u'ENSMUSG00000002983', u'ENSMUSG00000039005', u'ENSMUSG00000041827', u'ENSMUSG00000028059', u'ENSMUSG00000054717', u'ENSMUSG00000018899', u'ENSMUSG00000021277', u'ENSMUSG00000024789', u'ENSMUSG00000033538', u'ENSMUSG00000028291', u'ENSMUSG00000029217', u'ENSMUSG00000022575', u'ENSMUSG00000066839', u'ENSMUSG00000029561', u'ENSMUSG00000029915', u'ENSMUSG00000056612', u'ENSMUSG00000044827', u'ENSMUSG00000028163', u'ENSMUSG00000043279', u'ENSMUSG00000026365', u'ENSMUSG00000032322', u'ENSMUSG00000034459', u'ENSMUSG00000039936', u'ENSMUSG00000021423', u'ENSMUSG00000038147', u'ENSMUSG00000050132', u'ENSMUSG00000032041', u'ENSMUSG00000046034']), pop_n=13836, p_sm_bonferroni=1.0, is_obsolete=False, GO='GO:0045087', name='innate immune response', pop_count=206, alt_ids=['GO:0002226'], level=3, depth=4, enrichment='e', Cluster='Late Increase', geneid_set=set([u'ENSMUSG00000029771', u'ENSMUSG00000052384', u'ENSMUSG00000038521', u'ENSMUSG00000013707', u'ENSMUSG00000021457', u'ENSMUSG00000003184', u'ENSMUSG00000036887', u'ENSMUSG00000020399', u'ENSMUSG00000024371', u'ENSMUSG00000050335', u'ENSMUSG00000002602', u'ENSMUSG00000026471', u'ENSMUSG00000053158', u'ENSMUSG00000017707', u'ENSMUSG00000023224', u'ENSMUSG00000037523', u'ENSMUSG00000036908', u'ENSMUSG00000076617', u'ENSMUSG00000014932', u'ENSMUSG00000039005', u'ENSMUSG00000059883', u'ENSMUSG00000024164', u'ENSMUSG00000033777', u'ENSMUSG00000060591', u'ENSMUSG00000015340', u'ENSMUSG00000044583', u'ENSMUSG00000022575', u'ENSMUSG00000078942', u'ENSMUSG00000078945', u'ENSMUSG00000029915', u'ENSMUSG00000034317', u'ENSMUSG00000044827', u'ENSMUSG00000028163', u'ENSMUSG00000028874', u'ENSMUSG00000004707', u'ENSMUSG00000051439', u'ENSMUSG00000026365', u'ENSMUSG00000023992', u'ENSMUSG00000038147']), symbols=u'Axl C1qa C1s1 C2 C3 Cd14 Cd84 Cfh Clec5a Cybb Fes Fgr Gsdmd Havcr2 Ifitm2 Ighm Irak4 Irf3 Irf5 Lgals3 Ly9 Mavs Mr1 Naip2 Naip6 Nfkb1 Nrros Serinc3 Serping1 Syk Tlr1 Tlr13 Tlr4 Tlr7 Tnfaip8l2 Trem2 Trim59 Unc93b1 Yes1', symbol_set=set([u'Ifitm2', u'Tnfaip8l2', u'Naip6', u'Mr1', u'Naip2', u'Cd14', u'Tlr13', u'Fes', u'Lgals3', u'Nfkb1', u'Mavs', u'Yes1', u'Irf3', u'Irf5', u'Syk', u'Ly9', u'C1qa', u'Trim59', u'Irak4', u'C3', u'C2', u'Ighm', u'Havcr2', u'Tlr7', u'Cd84', u'Serping1', u'Axl', u'Clec5a', 'C1s1', u'Cfh', u'Gsdmd', u'Serinc3', u'Cybb', u'Tlr1', 'Nrros', u'Tlr4', u'Trem2', u'Unc93b1', u'Fgr']), geneids='ENSMUSG00000029771 ENSMUSG00000013707 ENSMUSG00000038521 ENSMUSG00000052384 ENSMUSG00000021457 ENSMUSG00000017707 ENSMUSG00000036887 ENSMUSG00000024371 ENSMUSG00000050335 ENSMUSG00000002602 ENSMUSG00000026471 ENSMUSG00000053158 ENSMUSG00000003184 ENSMUSG00000023224 ENSMUSG00000037523 ENSMUSG00000036908 ENSMUSG00000028874 ENSMUSG00000076617 ENSMUSG00000014932 ENSMUSG00000039005 ENSMUSG00000060591 ENSMUSG00000024164 ENSMUSG00000033777 ENSMUSG00000059883 ENSMUSG00000015340 ENSMUSG00000044583 ENSMUSG00000022575 ENSMUSG00000078942 ENSMUSG00000078945 ENSMUSG00000029915 ENSMUSG00000034317 ENSMUSG00000044827 ENSMUSG00000028163 ENSMUSG00000020399 ENSMUSG00000004707 ENSMUSG00000051439 ENSMUSG00000026365 ENSMUSG00000023992 ENSMUSG00000038147', format_txt=1, hdr_idx=1, is_hdrgo=True, is_usrgo=True, hdr1usr01='**', dcnt=26, D1='FL', GO_name='innate immune response'),
    Nt(p_uncorrected=4.101611509947174e-07, study_count=42, study_n=1397, namespace='biological_process', p_fdr_bh=0.00014796075235049913, study_items=set([u'ENSMUSG00000021457', u'ENSMUSG00000026923', u'ENSMUSG00000020717', u'ENSMUSG00000031486', u'ENSMUSG00000028024', u'ENSMUSG00000026193', u'ENSMUSG00000029648', u'ENSMUSG00000029710', u'ENSMUSG00000019997', u'ENSMUSG00000037242', u'ENSMUSG00000018377', u'ENSMUSG00000028868', u'ENSMUSG00000030849', u'ENSMUSG00000029669', u'ENSMUSG00000031565', u'ENSMUSG00000006386', u'ENSMUSG00000036585', u'ENSMUSG00000031785', u'ENSMUSG00000032135', u'ENSMUSG00000021822', u'ENSMUSG00000020154', u'ENSMUSG00000020611', u'ENSMUSG00000042626', u'ENSMUSG00000045092', u'ENSMUSG00000023008', u'ENSMUSG00000021540', u'ENSMUSG00000063506', u'ENSMUSG00000029999', u'ENSMUSG00000020357', u'ENSMUSG00000022309', u'ENSMUSG00000020573', u'ENSMUSG00000039191', u'ENSMUSG00000024087', u'ENSMUSG00000032231', u'ENSMUSG00000022469', u'ENSMUSG00000031328', u'ENSMUSG00000032238', u'ENSMUSG00000032537', u'ENSMUSG00000007613', u'ENSMUSG00000033191', u'ENSMUSG00000025902', u'ENSMUSG00000007655']), NS='BP', pop_items=set([u'ENSMUSG00000033721', u'ENSMUSG00000056174', u'ENSMUSG00000028029', u'ENSMUSG00000063531', u'ENSMUSG00000028024', u'ENSMUSG00000025856', u'ENSMUSG00000006386', u'ENSMUSG00000019579', u'ENSMUSG00000046020', u'ENSMUSG00000021266', u'ENSMUSG00000020458', u'ENSMUSG00000026883', u'ENSMUSG00000044337', u'ENSMUSG00000037242', u'ENSMUSG00000018377', u'ENSMUSG00000022469', u'ENSMUSG00000046207', u'ENSMUSG00000048661', u'ENSMUSG00000027665', u'ENSMUSG00000029669', u'ENSMUSG00000018160', u'ENSMUSG00000038742', u'ENSMUSG00000062604', u'ENSMUSG00000032135', u'ENSMUSG00000021109', u'ENSMUSG00000020063', u'ENSMUSG00000020611', u'ENSMUSG00000032625', u'ENSMUSG00000026814', u'ENSMUSG00000063506', u'ENSMUSG00000009741', u'ENSMUSG00000039745', u'ENSMUSG00000000392', u'ENSMUSG00000024087', u'ENSMUSG00000009621', u'ENSMUSG00000046034', u'ENSMUSG00000036427', u'ENSMUSG00000005958', u'ENSMUSG00000024962', u'ENSMUSG00000006445', u'ENSMUSG00000057315', u'ENSMUSG00000023068', u'ENSMUSG00000050711', u'ENSMUSG00000028108', u'ENSMUSG00000021281', u'ENSMUSG00000031503', u'ENSMUSG00000031502', u'ENSMUSG00000054364', u'ENSMUSG00000027087', u'ENSMUSG00000005413', u'ENSMUSG00000062352', u'ENSMUSG00000013663', u'ENSMUSG00000022382', u'ENSMUSG00000021681', u'ENSMUSG00000021576', u'ENSMUSG00000026193', u'ENSMUSG00000027954', u'ENSMUSG00000035725', u'ENSMUSG00000019997', u'ENSMUSG00000004565', u'ENSMUSG00000030671', u'ENSMUSG00000031565', u'ENSMUSG00000052684', u'ENSMUSG00000022309', u'ENSMUSG00000026029', u'ENSMUSG00000041415', u'ENSMUSG00000045005', u'ENSMUSG00000030605', u'ENSMUSG00000027314', u'ENSMUSG00000039217', u'ENSMUSG00000035352', u'ENSMUSG00000036904', u'ENSMUSG00000049001', u'ENSMUSG00000042626', u'ENSMUSG00000045216', u'ENSMUSG00000020573', u'ENSMUSG00000069763', u'ENSMUSG00000072115', u'ENSMUSG00000024109', u'ENSMUSG00000002289', u'ENSMUSG00000004791', u'ENSMUSG00000019880', u'ENSMUSG00000030849', u'ENSMUSG00000002688', u'ENSMUSG00000020357', u'ENSMUSG00000034353', u'ENSMUSG00000030770', u'ENSMUSG00000023008', u'ENSMUSG00000025393', u'ENSMUSG00000001300', u'ENSMUSG00000020484', u'ENSMUSG00000026234', u'ENSMUSG00000001098', u'ENSMUSG00000021974', u'ENSMUSG00000005148', u'ENSMUSG00000026921', u'ENSMUSG00000031380', u'ENSMUSG00000026923', u'ENSMUSG00000028064', u'ENSMUSG00000020717', u'ENSMUSG00000039062', u'ENSMUSG00000021457', u'ENSMUSG00000029710', u'ENSMUSG00000028664', u'ENSMUSG00000027835', u'ENSMUSG00000030093', u'ENSMUSG00000022443', u'ENSMUSG00000037362', u'ENSMUSG00000028868', u'ENSMUSG00000057722', u'ENSMUSG00000010660', u'ENSMUSG00000000530', u'ENSMUSG00000031785', u'ENSMUSG00000032487', u'ENSMUSG00000023905', u'ENSMUSG00000028978', u'ENSMUSG00000020154', u'ENSMUSG00000025810', u'ENSMUSG00000035086', u'ENSMUSG00000025969', u'ENSMUSG00000059588', u'ENSMUSG00000031486', u'ENSMUSG00000021822', u'ENSMUSG00000021256', u'ENSMUSG00000001435', u'ENSMUSG00000030538', u'ENSMUSG00000044562', u'ENSMUSG00000039191', u'ENSMUSG00000046318', u'ENSMUSG00000032011', u'ENSMUSG00000041187', u'ENSMUSG00000022607', u'ENSMUSG00000059456', u'ENSMUSG00000042460', u'ENSMUSG00000035385', u'ENSMUSG00000033191', u'ENSMUSG00000031990', u'ENSMUSG00000008398', u'ENSMUSG00000000600', u'ENSMUSG00000001240', u'ENSMUSG00000032911', u'ENSMUSG00000028041', u'ENSMUSG00000033933', u'ENSMUSG00000070327', u'ENSMUSG00000059439', u'ENSMUSG00000066392', u'ENSMUSG00000017417', u'ENSMUSG00000022665', u'ENSMUSG00000028763', u'ENSMUSG00000028284', u'ENSMUSG00000024486', u'ENSMUSG00000007613', u'ENSMUSG00000044813', u'ENSMUSG00000020937', u'ENSMUSG00000029648', u'ENSMUSG00000036585', u'ENSMUSG00000068196', u'ENSMUSG00000050965', u'ENSMUSG00000032125', u'ENSMUSG00000044791', u'ENSMUSG00000004328', u'ENSMUSG00000045092', u'ENSMUSG00000006705', u'ENSMUSG00000063273', u'ENSMUSG00000021540', u'ENSMUSG00000020160', u'ENSMUSG00000029999', u'ENSMUSG00000030123', u'ENSMUSG00000031740', u'ENSMUSG00000031668', u'ENSMUSG00000062960', u'ENSMUSG00000023951', u'ENSMUSG00000032231', u'ENSMUSG00000041445', u'ENSMUSG00000025473', u'ENSMUSG00000031328', u'ENSMUSG00000032238', u'ENSMUSG00000032537', u'ENSMUSG00000021835', u'ENSMUSG00000053436', u'ENSMUSG00000026078', u'ENSMUSG00000025902', u'ENSMUSG00000024140', u'ENSMUSG00000007655', u'ENSMUSG00000020099']), pop_n=13836, p_sm_bonferroni=0.006214351598720963, is_obsolete=False, GO='GO:0001525', name='angiogenesis', pop_count=185, alt_ids=[], level=3, depth=3, enrichment='e', Cluster='Late Increase', geneid_set=set([u'ENSMUSG00000026923', u'ENSMUSG00000020717', u'ENSMUSG00000031486', u'ENSMUSG00000028024', u'ENSMUSG00000029710', u'ENSMUSG00000021457', u'ENSMUSG00000026193', u'ENSMUSG00000019997', u'ENSMUSG00000037242', u'ENSMUSG00000018377', u'ENSMUSG00000028868', u'ENSMUSG00000030849', u'ENSMUSG00000029669', u'ENSMUSG00000031565', u'ENSMUSG00000032231', u'ENSMUSG00000029648', u'ENSMUSG00000036585', u'ENSMUSG00000031785', u'ENSMUSG00000032135', u'ENSMUSG00000021822', u'ENSMUSG00000020154', u'ENSMUSG00000020611', u'ENSMUSG00000042626', u'ENSMUSG00000045092', u'ENSMUSG00000021540', u'ENSMUSG00000063506', u'ENSMUSG00000029999', u'ENSMUSG00000020357', u'ENSMUSG00000006386', u'ENSMUSG00000022309', u'ENSMUSG00000020573', u'ENSMUSG00000039191', u'ENSMUSG00000024087', u'ENSMUSG00000023008', u'ENSMUSG00000022469', u'ENSMUSG00000031328', u'ENSMUSG00000032238', u'ENSMUSG00000032537', u'ENSMUSG00000007613', u'ENSMUSG00000033191', u'ENSMUSG00000025902', u'ENSMUSG00000007655']), symbols=u'Adgra2 Adgrg1 Angpt1 Anxa2 Arhgap22 Cav1 Clic4 Ctgf Cyp1b1 Enpep Ephb1 Ephb4 Fgf1 Fgfr1 Fgfr2 Flna Flt1 Flt4 Fmnl3 Fn1 Gna13 Mcam Notch1 Pecam1 Pik3cg Plau Ptprb Rapgef3 Rbpj Rora S1pr1 Shc1 Smad5 Sox17 Syk Tek Tgfa Tgfbr1 Tie1 Tspan12 Vezf1 Wasf2', symbol_set=set([u'Cyp1b1', u'Fn1', u'Rbpj', u'Ctgf', u'Plau', u'Flna', u'Cav1', u'Pecam1', u'Clic4', u'Anxa2', u'Wasf2', u'Syk', u'Smad5', u'Notch1', u'Mcam', u'Pik3cg', u'Gna13', u'Angpt1', u'Fgfr2', u'Fgfr1', u'Tgfa', u'Tgfbr1', u'Shc1', u'Enpep', u'Fmnl3', u'Tspan12', u'Rora', u'Arhgap22', u'Ephb1', u'Vezf1', u'Flt4', u'Fgf1', u'Flt1', u'Tek', u'Ephb4', u'S1pr1', u'Sox17', 'Adgra2', u'Ptprb', 'Adgrg1', u'Rapgef3', u'Tie1']), geneids='ENSMUSG00000026923 ENSMUSG00000039191 ENSMUSG00000020717 ENSMUSG00000031486 ENSMUSG00000028024 ENSMUSG00000029710 ENSMUSG00000021457 ENSMUSG00000026193 ENSMUSG00000019997 ENSMUSG00000031565 ENSMUSG00000018377 ENSMUSG00000028868 ENSMUSG00000022309 ENSMUSG00000029669 ENSMUSG00000037242 ENSMUSG00000006386 ENSMUSG00000036585 ENSMUSG00000031785 ENSMUSG00000032135 ENSMUSG00000021822 ENSMUSG00000020154 ENSMUSG00000020611 ENSMUSG00000042626 ENSMUSG00000045092 ENSMUSG00000021540 ENSMUSG00000029648 ENSMUSG00000063506 ENSMUSG00000029999 ENSMUSG00000020357 ENSMUSG00000030849 ENSMUSG00000020573 ENSMUSG00000032231 ENSMUSG00000024087 ENSMUSG00000023008 ENSMUSG00000022469 ENSMUSG00000031328 ENSMUSG00000032238 ENSMUSG00000032537 ENSMUSG00000007613 ENSMUSG00000033191 ENSMUSG00000025902 ENSMUSG00000007655', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=8, D1='CE', GO_name='angiogenesis'),
    Nt(p_uncorrected=6.2954127580094645e-06, study_count=9, study_n=1397, namespace='biological_process', p_fdr_bh=0.0013247472041194638, study_items=set([u'ENSMUSG00000041112', u'ENSMUSG00000059498', u'ENSMUSG00000015243', u'ENSMUSG00000026656', u'ENSMUSG00000056870', u'ENSMUSG00000037902', u'ENSMUSG00000023992', u'ENSMUSG00000076617', u'ENSMUSG00000026879']), NS='BP', pop_items=set([u'ENSMUSG00000041112', u'ENSMUSG00000001847', u'ENSMUSG00000059498', u'ENSMUSG00000015243', u'ENSMUSG00000004319', u'ENSMUSG00000026656', u'ENSMUSG00000030605', u'ENSMUSG00000024397', u'ENSMUSG00000056870', u'ENSMUSG00000015947', u'ENSMUSG00000037902', u'ENSMUSG00000023992', u'ENSMUSG00000076617', u'ENSMUSG00000058715', u'ENSMUSG00000022443', u'ENSMUSG00000026879']), pop_n=13836, p_sm_bonferroni=0.09538179869660139, is_obsolete=False, GO='GO:0006911', name='phagocytosis, engulfment', pop_count=16, alt_ids=[], level=6, depth=6, enrichment='e', Cluster='Late Increase', geneid_set=set([u'ENSMUSG00000041112', u'ENSMUSG00000059498', u'ENSMUSG00000015243', u'ENSMUSG00000026656', u'ENSMUSG00000056870', u'ENSMUSG00000037902', u'ENSMUSG00000076617', u'ENSMUSG00000023992', u'ENSMUSG00000026879']), symbols=u'Abca1 Elmo1 Fcgr2b Fcgr3 Gsn Gulp1 Ighm Sirpa Trem2', symbol_set=set([u'Sirpa', u'Gulp1', u'Trem2', u'Fcgr2b', u'Ighm', u'Abca1', u'Fcgr3', u'Elmo1', u'Gsn']), geneids='ENSMUSG00000041112 ENSMUSG00000059498 ENSMUSG00000015243 ENSMUSG00000026656 ENSMUSG00000056870 ENSMUSG00000037902 ENSMUSG00000076617 ENSMUSG00000023992 ENSMUSG00000026879', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=1, D1='BH', GO_name='phagocytosis, engulfment'),
    Nt(p_uncorrected='', study_count='', study_n='', namespace='', p_fdr_bh='', study_items='', NS='BP', pop_items='', pop_n='', p_sm_bonferroni='', is_obsolete='', GO='GO:0006259', name='', pop_count='', alt_ids='', level=4, depth=6, enrichment='', Cluster='', geneid_set='', symbols='', symbol_set='', geneids='', format_txt=1, hdr_idx=1, is_hdrgo=True, is_usrgo=False, hdr1usr01='*', dcnt=302, D1='BD', GO_name='DNA metabolic process'),
    Nt(p_uncorrected=1.6026201500926644e-10, study_count=92, study_n=1397, namespace='biological_process', p_fdr_bh=3.0597720239381384e-07, study_items=set([u'ENSMUSG00000004894', u'ENSMUSG00000004892', u'ENSMUSG00000019997', u'ENSMUSG00000025351', u'ENSMUSG00000052911', u'ENSMUSG00000020717', u'ENSMUSG00000004591', u'ENSMUSG00000042284', u'ENSMUSG00000042453', u'ENSMUSG00000021823', u'ENSMUSG00000032332', u'ENSMUSG00000023885', u'ENSMUSG00000020758', u'ENSMUSG00000019846', u'ENSMUSG00000037966', u'ENSMUSG00000037815', u'ENSMUSG00000022790', u'ENSMUSG00000030577', u'ENSMUSG00000022091', u'ENSMUSG00000025608', u'ENSMUSG00000040152', u'ENSMUSG00000036634', u'ENSMUSG00000038816', u'ENSMUSG00000032796', u'ENSMUSG00000060843', u'ENSMUSG00000021614', u'ENSMUSG00000031871', u'ENSMUSG00000029710', u'ENSMUSG00000029304', u'ENSMUSG00000024696', u'ENSMUSG00000037016', u'ENSMUSG00000022491', u'ENSMUSG00000024593', u'ENSMUSG00000050840', u'ENSMUSG00000034101', u'ENSMUSG00000016028', u'ENSMUSG00000001946', u'ENSMUSG00000030789', u'ENSMUSG00000001552', u'ENSMUSG00000046240', u'ENSMUSG00000028465', u'ENSMUSG00000017344', u'ENSMUSG00000033306', u'ENSMUSG00000028583', u'ENSMUSG00000071648', u'ENSMUSG00000029816', u'ENSMUSG00000039115', u'ENSMUSG00000053475', u'ENSMUSG00000035273', u'ENSMUSG00000059898', u'ENSMUSG00000026840', u'ENSMUSG00000019899', u'ENSMUSG00000037206', u'ENSMUSG00000026193', u'ENSMUSG00000005397', u'ENSMUSG00000033278', u'ENSMUSG00000053158', u'ENSMUSG00000031785', u'ENSMUSG00000032135', u'ENSMUSG00000025809', u'ENSMUSG00000076439', u'ENSMUSG00000029163', u'ENSMUSG00000024087', u'ENSMUSG00000029797', u'ENSMUSG00000004707', u'ENSMUSG00000041731', u'ENSMUSG00000053024', u'ENSMUSG00000019818', u'ENSMUSG00000022687', u'ENSMUSG00000028369', u'ENSMUSG00000001930', u'ENSMUSG00000021365', u'ENSMUSG00000028517', u'ENSMUSG00000022505', u'ENSMUSG00000002980', u'ENSMUSG00000022817', u'ENSMUSG00000027111', u'ENSMUSG00000027962', u'ENSMUSG00000021702', u'ENSMUSG00000030342', u'ENSMUSG00000012819', u'ENSMUSG00000016494', u'ENSMUSG00000041329', u'ENSMUSG00000039013', u'ENSMUSG00000054793', u'ENSMUSG00000030428', u'ENSMUSG00000032537', u'ENSMUSG00000052336', u'ENSMUSG00000028859', u'ENSMUSG00000038147', u'ENSMUSG00000037625', u'ENSMUSG00000032737']), NS='BP', pop_items=set([u'ENSMUSG00000028029', u'ENSMUSG00000004894', u'ENSMUSG00000027386', u'ENSMUSG00000030110', u'ENSMUSG00000038156', u'ENSMUSG00000051790', u'ENSMUSG00000037405', u'ENSMUSG00000032336', u'ENSMUSG00000042453', u'ENSMUSG00000015647', u'ENSMUSG00000032332', u'ENSMUSG00000023885', u'ENSMUSG00000020758', u'ENSMUSG00000037815', u'ENSMUSG00000028339', u'ENSMUSG00000051379', u'ENSMUSG00000052911', u'ENSMUSG00000022091', u'ENSMUSG00000006445', u'ENSMUSG00000040152', u'ENSMUSG00000021803', u'ENSMUSG00000032796', u'ENSMUSG00000018171', u'ENSMUSG00000060843', u'ENSMUSG00000022762', u'ENSMUSG00000019851', u'ENSMUSG00000004892', u'ENSMUSG00000000325', u'ENSMUSG00000063887', u'ENSMUSG00000079562', u'ENSMUSG00000037712', u'ENSMUSG00000034101', u'ENSMUSG00000026837', u'ENSMUSG00000022439', u'ENSMUSG00000022438', u'ENSMUSG00000046240', u'ENSMUSG00000001300', u'ENSMUSG00000022865', u'ENSMUSG00000033444', u'ENSMUSG00000059049', u'ENSMUSG00000059898', u'ENSMUSG00000026596', u'ENSMUSG00000045689', u'ENSMUSG00000037362', u'ENSMUSG00000025650', u'ENSMUSG00000023328', u'ENSMUSG00000048218', u'ENSMUSG00000061080', u'ENSMUSG00000001435', u'ENSMUSG00000021728', u'ENSMUSG00000030538', u'ENSMUSG00000027750', u'ENSMUSG00000036510', u'ENSMUSG00000032340', u'ENSMUSG00000006411', u'ENSMUSG00000004707', u'ENSMUSG00000032572', u'ENSMUSG00000039787', u'ENSMUSG00000034066', u'ENSMUSG00000051323', u'ENSMUSG00000021365', u'ENSMUSG00000022892', u'ENSMUSG00000051242', u'ENSMUSG00000026479', u'ENSMUSG00000026478', u'ENSMUSG00000026576', u'ENSMUSG00000007594', u'ENSMUSG00000002980', u'ENSMUSG00000001507', u'ENSMUSG00000064115', u'ENSMUSG00000023118', u'ENSMUSG00000039115', u'ENSMUSG00000033880', u'ENSMUSG00000022371', u'ENSMUSG00000054793', u'ENSMUSG00000031955', u'ENSMUSG00000024304', u'ENSMUSG00000005338', u'ENSMUSG00000028859', u'ENSMUSG00000038147', u'ENSMUSG00000037625', u'ENSMUSG00000033152', u'ENSMUSG00000000127', u'ENSMUSG00000025351', u'ENSMUSG00000003166', u'ENSMUSG00000034488', u'ENSMUSG00000013236', u'ENSMUSG00000020598', u'ENSMUSG00000046191', u'ENSMUSG00000037966', u'ENSMUSG00000021823', u'ENSMUSG00000029528', u'ENSMUSG00000050761', u'ENSMUSG00000045038', u'ENSMUSG00000028402', u'ENSMUSG00000018697', u'ENSMUSG00000030577', u'ENSMUSG00000052698', u'ENSMUSG00000038816', u'ENSMUSG00000021613', u'ENSMUSG00000021614', u'ENSMUSG00000023473', u'ENSMUSG00000062352', u'ENSMUSG00000031871', u'ENSMUSG00000055447', u'ENSMUSG00000048001', u'ENSMUSG00000024053', u'ENSMUSG00000059674', u'ENSMUSG00000035725', u'ENSMUSG00000032087', u'ENSMUSG00000002900', u'ENSMUSG00000027009', u'ENSMUSG00000032011', u'ENSMUSG00000032012', u'ENSMUSG00000022443', u'ENSMUSG00000038048', u'ENSMUSG00000021806', u'ENSMUSG00000048163', u'ENSMUSG00000023988', u'ENSMUSG00000031391', u'ENSMUSG00000027435', u'ENSMUSG00000031626', u'ENSMUSG00000022636', u'ENSMUSG00000019889', u'ENSMUSG00000026442', u'ENSMUSG00000047787', u'ENSMUSG00000017344', u'ENSMUSG00000053166', u'ENSMUSG00000047033', u'ENSMUSG00000024180', u'ENSMUSG00000029816', u'ENSMUSG00000047139', u'ENSMUSG00000026921', u'ENSMUSG00000035273', u'ENSMUSG00000026849', u'ENSMUSG00000026842', u'ENSMUSG00000026840', u'ENSMUSG00000029710', u'ENSMUSG00000022528', u'ENSMUSG00000005397', u'ENSMUSG00000028661', u'ENSMUSG00000032076', u'ENSMUSG00000022203', u'ENSMUSG00000033278', u'ENSMUSG00000049100', u'ENSMUSG00000035776', u'ENSMUSG00000026587', u'ENSMUSG00000076439', u'ENSMUSG00000023972', u'ENSMUSG00000027298', u'ENSMUSG00000041187', u'ENSMUSG00000034275', u'ENSMUSG00000043313', u'ENSMUSG00000059456', u'ENSMUSG00000033306', u'ENSMUSG00000041731', u'ENSMUSG00000048347', u'ENSMUSG00000027612', u'ENSMUSG00000028047', u'ENSMUSG00000028369', u'ENSMUSG00000028041', u'ENSMUSG00000028364', u'ENSMUSG00000028413', u'ENSMUSG00000035493', u'ENSMUSG00000031990', u'ENSMUSG00000040998', u'ENSMUSG00000023348', u'ENSMUSG00000012017', u'ENSMUSG00000040690', u'ENSMUSG00000017167', u'ENSMUSG00000068196', u'ENSMUSG00000062300', u'ENSMUSG00000031841', u'ENSMUSG00000051486', u'ENSMUSG00000027962', u'ENSMUSG00000037016', u'ENSMUSG00000039385', u'ENSMUSG00000030342', u'ENSMUSG00000068740', u'ENSMUSG00000004609', u'ENSMUSG00000032537', u'ENSMUSG00000035000', u'ENSMUSG00000032737', u'ENSMUSG00000039683', u'ENSMUSG00000056174', u'ENSMUSG00000021186', u'ENSMUSG00000026312', u'ENSMUSG00000039953', u'ENSMUSG00000049612', u'ENSMUSG00000002885', u'ENSMUSG00000006932', u'ENSMUSG00000029161', u'ENSMUSG00000022240', u'ENSMUSG00000064293', u'ENSMUSG00000079465', u'ENSMUSG00000026814', u'ENSMUSG00000044043', u'ENSMUSG00000036422', u'ENSMUSG00000015829', u'ENSMUSG00000024965', u'ENSMUSG00000051678', u'ENSMUSG00000025608', u'ENSMUSG00000026141', u'ENSMUSG00000020900', u'ENSMUSG00000070695', u'ENSMUSG00000016028', u'ENSMUSG00000023905', u'ENSMUSG00000034902', u'ENSMUSG00000031561', u'ENSMUSG00000000555', u'ENSMUSG00000052593', u'ENSMUSG00000050272', u'ENSMUSG00000043458', u'ENSMUSG00000027646', u'ENSMUSG00000052613', u'ENSMUSG00000000392', u'ENSMUSG00000050840', u'ENSMUSG00000027087', u'ENSMUSG00000051177', u'ENSMUSG00000033960', u'ENSMUSG00000024109', u'ENSMUSG00000001552', u'ENSMUSG00000055022', u'ENSMUSG00000050505', u'ENSMUSG00000063687', u'ENSMUSG00000039488', u'ENSMUSG00000000303', u'ENSMUSG00000000305', u'ENSMUSG00000026131', u'ENSMUSG00000071648', u'ENSMUSG00000040037', u'ENSMUSG00000053475', u'ENSMUSG00000022026', u'ENSMUSG00000000738', u'ENSMUSG00000070305', u'ENSMUSG00000038119', u'ENSMUSG00000032036', u'ENSMUSG00000020340', u'ENSMUSG00000019899', u'ENSMUSG00000032462', u'ENSMUSG00000053158', u'ENSMUSG00000078716', u'ENSMUSG00000061981', u'ENSMUSG00000047414', u'ENSMUSG00000022321', u'ENSMUSG00000024421', u'ENSMUSG00000005087', u'ENSMUSG00000063063', u'ENSMUSG00000001119', u'ENSMUSG00000033295', u'ENSMUSG00000046387', u'ENSMUSG00000028776', u'ENSMUSG00000024087', u'ENSMUSG00000022607', u'ENSMUSG00000029797', u'ENSMUSG00000022802', u'ENSMUSG00000047910', u'ENSMUSG00000049336', u'ENSMUSG00000059974', u'ENSMUSG00000001930', u'ENSMUSG00000025370', u'ENSMUSG00000066392', u'ENSMUSG00000028517', u'ENSMUSG00000043719', u'ENSMUSG00000006651', u'ENSMUSG00000027356', u'ENSMUSG00000028195', u'ENSMUSG00000021702', u'ENSMUSG00000016494', u'ENSMUSG00000028909', u'ENSMUSG00000031910', u'ENSMUSG00000045062', u'ENSMUSG00000030428', u'ENSMUSG00000052336', u'ENSMUSG00000032322', u'ENSMUSG00000046743', u'ENSMUSG00000039013', u'ENSMUSG00000045498', u'ENSMUSG00000031772', u'ENSMUSG00000019997', u'ENSMUSG00000044337', u'ENSMUSG00000031778', u'ENSMUSG00000031673', u'ENSMUSG00000022178', u'ENSMUSG00000050965', u'ENSMUSG00000020717', u'ENSMUSG00000042286', u'ENSMUSG00000004591', u'ENSMUSG00000042284', u'ENSMUSG00000019966', u'ENSMUSG00000032135', u'ENSMUSG00000074505', u'ENSMUSG00000019969', u'ENSMUSG00000019846', u'ENSMUSG00000040452', u'ENSMUSG00000022790', u'ENSMUSG00000022656', u'ENSMUSG00000036634', u'ENSMUSG00000054364', u'ENSMUSG00000037892', u'ENSMUSG00000021681', u'ENSMUSG00000067028', u'ENSMUSG00000029304', u'ENSMUSG00000024696', u'ENSMUSG00000001847', u'ENSMUSG00000036256', u'ENSMUSG00000030607', u'ENSMUSG00000030605', u'ENSMUSG00000036862', u'ENSMUSG00000024593', u'ENSMUSG00000038235', u'ENSMUSG00000001946', u'ENSMUSG00000030789', u'ENSMUSG00000030786', u'ENSMUSG00000051599', u'ENSMUSG00000020994', u'ENSMUSG00000031555', u'ENSMUSG00000028465', u'ENSMUSG00000030770', u'ENSMUSG00000030075', u'ENSMUSG00000027322', u'ENSMUSG00000030077', u'ENSMUSG00000026235', u'ENSMUSG00000041329', u'ENSMUSG00000031954', u'ENSMUSG00000007815', u'ENSMUSG00000030092', u'ENSMUSG00000068036', u'ENSMUSG00000048027', u'ENSMUSG00000037206', u'ENSMUSG00000026193', u'ENSMUSG00000031302', u'ENSMUSG00000031785', u'ENSMUSG00000050947', u'ENSMUSG00000045876', u'ENSMUSG00000039419', u'ENSMUSG00000032174', u'ENSMUSG00000047307', u'ENSMUSG00000008153', u'ENSMUSG00000020032', u'ENSMUSG00000025809', u'ENSMUSG00000025964', u'ENSMUSG00000073591', u'ENSMUSG00000026991', u'ENSMUSG00000029163', u'ENSMUSG00000068040', u'ENSMUSG00000032452', u'ENSMUSG00000002341', u'ENSMUSG00000053024', u'ENSMUSG00000039542', u'ENSMUSG00000019818', u'ENSMUSG00000039546', u'ENSMUSG00000022687', u'ENSMUSG00000044393', u'ENSMUSG00000020241', u'ENSMUSG00000022505', u'ENSMUSG00000029860', u'ENSMUSG00000028583', u'ENSMUSG00000036825', u'ENSMUSG00000022817', u'ENSMUSG00000027111', u'ENSMUSG00000044022', u'ENSMUSG00000026768', u'ENSMUSG00000012819', u'ENSMUSG00000045657', u'ENSMUSG00000025348', u'ENSMUSG00000020689', u'ENSMUSG00000029576', u'ENSMUSG00000054555', u'ENSMUSG00000041592', u'ENSMUSG00000000290', u'ENSMUSG00000035566', u'ENSMUSG00000022491', u'ENSMUSG00000025743', u'ENSMUSG00000036957']), pop_n=13836, p_sm_bonferroni=2.428129789405396e-06, is_obsolete=False, GO='GO:0007155', name='cell adhesion', pop_count=375, alt_ids=[], level=2, depth=2, enrichment='e', Cluster='Late Increase', geneid_set=set([u'ENSMUSG00000033278', u'ENSMUSG00000035273', u'ENSMUSG00000020717', u'ENSMUSG00000026840', u'ENSMUSG00000004894', u'ENSMUSG00000019899', u'ENSMUSG00000037206', u'ENSMUSG00000004892', u'ENSMUSG00000019997', u'ENSMUSG00000025351', u'ENSMUSG00000030577', u'ENSMUSG00000031785', u'ENSMUSG00000059898', u'ENSMUSG00000053158', u'ENSMUSG00000004591', u'ENSMUSG00000042284', u'ENSMUSG00000026193', u'ENSMUSG00000042453', u'ENSMUSG00000021823', u'ENSMUSG00000032332', u'ENSMUSG00000023885', u'ENSMUSG00000020758', u'ENSMUSG00000019846', u'ENSMUSG00000037966', u'ENSMUSG00000028583', u'ENSMUSG00000037815', u'ENSMUSG00000076439', u'ENSMUSG00000022790', u'ENSMUSG00000052911', u'ENSMUSG00000022091', u'ENSMUSG00000029163', u'ENSMUSG00000024087', u'ENSMUSG00000025608', u'ENSMUSG00000040152', u'ENSMUSG00000036634', u'ENSMUSG00000038816', u'ENSMUSG00000032796', u'ENSMUSG00000004707', u'ENSMUSG00000029797', u'ENSMUSG00000041731', u'ENSMUSG00000060843', u'ENSMUSG00000053024', u'ENSMUSG00000021614', u'ENSMUSG00000019818', u'ENSMUSG00000031871', u'ENSMUSG00000022687', u'ENSMUSG00000028369', u'ENSMUSG00000029710', u'ENSMUSG00000001930', u'ENSMUSG00000029304', u'ENSMUSG00000021365', u'ENSMUSG00000024696', u'ENSMUSG00000028517', u'ENSMUSG00000005397', u'ENSMUSG00000022505', u'ENSMUSG00000037016', u'ENSMUSG00000022491', u'ENSMUSG00000025809', u'ENSMUSG00000002980', u'ENSMUSG00000024593', u'ENSMUSG00000022817', u'ENSMUSG00000050840', u'ENSMUSG00000034101', u'ENSMUSG00000027111', u'ENSMUSG00000016028', u'ENSMUSG00000027962', u'ENSMUSG00000001946', u'ENSMUSG00000030789', u'ENSMUSG00000021702', u'ENSMUSG00000032135', u'ENSMUSG00000030342', u'ENSMUSG00000001552', u'ENSMUSG00000012819', u'ENSMUSG00000016494', u'ENSMUSG00000041329', u'ENSMUSG00000046240', u'ENSMUSG00000028465', u'ENSMUSG00000039013', u'ENSMUSG00000028859', u'ENSMUSG00000017344', u'ENSMUSG00000054793', u'ENSMUSG00000033306', u'ENSMUSG00000071648', u'ENSMUSG00000030428', u'ENSMUSG00000032537', u'ENSMUSG00000052336', u'ENSMUSG00000029816', u'ENSMUSG00000039115', u'ENSMUSG00000053475', u'ENSMUSG00000038147', u'ENSMUSG00000037625', u'ENSMUSG00000032737']), symbols=u'Adgrg1 Atp1b2 Bcam Bcan Boc Cadm4 Cd164 Cd22 Cd34 Cd63 Cd84 Cd9 Cdh20 Cdh23 Cdh5 Celsr1 Cldn11 Cntn2 Col12a1 Csf3r Ctgf Ctnna1 Ctnna3 Ctnnal1 Ctnnd1 Cx3cr1 Cyp1b1 Dsc3 Emilin1 Emp2 Ephb1 Ephb4 Esam Fes Fn1 Frem2 Glycam1 Gpnmb Hapln2 Hepacam Hpse Igsf11 Inppl1 Islr Itga1 Itga6 Itga9 Itgax Itgb1 Itgb4 Itgb5 Jup Lama1 Lama2 Lama4 Lamb2 Lamc3 Lpp Lpxn Ly9 Mag Mcam Megf10 Mog Nedd9 Nid1 Ninj1 Pdpn Pecam1 Pgm5 Pkn2 Plpp3 Podxl Ptprm Reln Rom1 Siglecf Sorbs3 Spp1 Sspo Svep1 Thbs1 Thbs2 Thbs4 Tln1 Tnfaip6 Ttyh1 Vcam1 Vcan Vcl Vtn Vwf', symbol_set=set([u'Cyp1b1', u'Rom1', u'Islr', u'Tnfaip6', u'Megf10', u'Itgb1', u'Pecam1', u'Cldn11', u'Itgb5', u'Itgb4', u'Lpxn', u'Cd34', u'Ly9', u'Tln1', u'Spp1', u'Lamb2', u'Mog', u'Csf3r', u'Cx3cr1', u'Thbs4', u'Thbs2', u'Thbs1', u'Glycam1', u'Ttyh1', u'Vtn', u'Ctnna1', u'Ctnna3', u'Sspo', u'Ninj1', u'Gpnmb', u'Nid1', u'Cd22', u'Lamc3', u'Ptprm', u'Hepacam', u'Bcan', u'Bcam', u'Fn1', u'Pkn2', u'Cd164', u'Reln', u'Itgax', u'Mcam', u'Nedd9', u'Emilin1', u'Cdh20', u'Cdh23', u'Cd84', u'Frem2', u'Sorbs3', u'Boc', u'Lama1', 'Plpp3', u'Ephb1', u'Lama4', u'Ephb4', u'Itga1', u'Itga6', u'Hpse', u'Pdpn', u'Igsf11', u'Ctgf', u'Fes', u'Jup', u'Vcam1', u'Itga9', u'Svep1', u'Lama2', u'Celsr1', u'Col12a1', u'Cd63', u'Inppl1', u'Vcan', u'Dsc3', u'Cntn2', 'Adgrg1', u'Vwf', u'Ctnnd1', u'Pgm5', 'Siglecf', u'Vcl', u'Esam', u'Cadm4', u'Ctnnal1', u'Emp2', u'Mag', u'Cdh5', u'Cd9', u'Lpp', u'Podxl', u'Atp1b2', u'Hapln2']), geneids='ENSMUSG00000004894 ENSMUSG00000004892 ENSMUSG00000019997 ENSMUSG00000025351 ENSMUSG00000030577 ENSMUSG00000059898 ENSMUSG00000004591 ENSMUSG00000042284 ENSMUSG00000042453 ENSMUSG00000021823 ENSMUSG00000032332 ENSMUSG00000023885 ENSMUSG00000020758 ENSMUSG00000019846 ENSMUSG00000037966 ENSMUSG00000037815 ENSMUSG00000022790 ENSMUSG00000052911 ENSMUSG00000022091 ENSMUSG00000025608 ENSMUSG00000040152 ENSMUSG00000036634 ENSMUSG00000038816 ENSMUSG00000032796 ENSMUSG00000060843 ENSMUSG00000021614 ENSMUSG00000031871 ENSMUSG00000029710 ENSMUSG00000029304 ENSMUSG00000024696 ENSMUSG00000037016 ENSMUSG00000022491 ENSMUSG00000024593 ENSMUSG00000050840 ENSMUSG00000034101 ENSMUSG00000016028 ENSMUSG00000001946 ENSMUSG00000030789 ENSMUSG00000032135 ENSMUSG00000001552 ENSMUSG00000046240 ENSMUSG00000028465 ENSMUSG00000017344 ENSMUSG00000033306 ENSMUSG00000071648 ENSMUSG00000029816 ENSMUSG00000041329 ENSMUSG00000053475 ENSMUSG00000035273 ENSMUSG00000020717 ENSMUSG00000026840 ENSMUSG00000019899 ENSMUSG00000037206 ENSMUSG00000026193 ENSMUSG00000005397 ENSMUSG00000033278 ENSMUSG00000053158 ENSMUSG00000031785 ENSMUSG00000028583 ENSMUSG00000025809 ENSMUSG00000076439 ENSMUSG00000029163 ENSMUSG00000024087 ENSMUSG00000029797 ENSMUSG00000004707 ENSMUSG00000041731 ENSMUSG00000053024 ENSMUSG00000019818 ENSMUSG00000022687 ENSMUSG00000028369 ENSMUSG00000001930 ENSMUSG00000021365 ENSMUSG00000028517 ENSMUSG00000022505 ENSMUSG00000002980 ENSMUSG00000022817 ENSMUSG00000027111 ENSMUSG00000027962 ENSMUSG00000021702 ENSMUSG00000030342 ENSMUSG00000012819 ENSMUSG00000016494 ENSMUSG00000039115 ENSMUSG00000028859 ENSMUSG00000054793 ENSMUSG00000030428 ENSMUSG00000032537 ENSMUSG00000052336 ENSMUSG00000039013 ENSMUSG00000038147 ENSMUSG00000037625 ENSMUSG00000032737', format_txt=1, hdr_idx=1, is_hdrgo=True, is_usrgo=True, hdr1usr01='**', dcnt=98, D1='P', GO_name='cell adhesion'),
    Nt(p_uncorrected='', study_count='', study_n='', namespace='', p_fdr_bh='', study_items='', NS='BP', pop_items='', pop_n='', p_sm_bonferroni='', is_obsolete='', GO='GO:0080134', name='', pop_count='', alt_ids='', level=4, depth=4, enrichment='', Cluster='', geneid_set='', symbols='', symbol_set='', geneids='', format_txt=1, hdr_idx=1, is_hdrgo=True, is_usrgo=False, hdr1usr01='*', dcnt=960, D1='A', GO_name='regulation of response to stress'),
    Nt(p_uncorrected='', study_count='', study_n='', namespace='', p_fdr_bh='', study_items='', NS='BP', pop_items='', pop_n='', p_sm_bonferroni='', is_obsolete='', GO='GO:0040011', name='', pop_count='', alt_ids='', level=1, depth=1, enrichment='', Cluster='', geneid_set='', symbols='', symbol_set='', geneids='', format_txt=1, hdr_idx=1, is_hdrgo=True, is_usrgo=False, hdr1usr01='*', dcnt=403, D1='M', GO_name='locomotion'),
    Nt(p_uncorrected=3.374326040417259e-05, study_count=36, study_n=1397, namespace='biological_process', p_fdr_bh=0.004963535324112805, study_items=set([u'ENSMUSG00000026923', u'ENSMUSG00000021127', u'ENSMUSG00000013584', u'ENSMUSG00000028780', u'ENSMUSG00000031714', u'ENSMUSG00000033016', u'ENSMUSG00000048402', u'ENSMUSG00000037016', u'ENSMUSG00000031665', u'ENSMUSG00000015755', u'ENSMUSG00000034227', u'ENSMUSG00000032440', u'ENSMUSG00000006386', u'ENSMUSG00000026510', u'ENSMUSG00000021796', u'ENSMUSG00000026043', u'ENSMUSG00000042745', u'ENSMUSG00000042626', u'ENSMUSG00000034462', u'ENSMUSG00000027962', u'ENSMUSG00000062209', u'ENSMUSG00000021614', u'ENSMUSG00000075254', u'ENSMUSG00000020709', u'ENSMUSG00000021318', u'ENSMUSG00000043733', u'ENSMUSG00000024529', u'ENSMUSG00000040711', u'ENSMUSG00000039191', u'ENSMUSG00000000567', u'ENSMUSG00000007872', u'ENSMUSG00000062312', u'ENSMUSG00000007613', u'ENSMUSG00000050953', u'ENSMUSG00000020644', u'ENSMUSG00000038679']), NS='BP', pop_items=set([u'ENSMUSG00000015053', u'ENSMUSG00000040363', u'ENSMUSG00000023972', u'ENSMUSG00000059325', u'ENSMUSG00000046020', u'ENSMUSG00000037325', u'ENSMUSG00000059552', u'ENSMUSG00000023809', u'ENSMUSG00000033016', u'ENSMUSG00000066406', u'ENSMUSG00000018160', u'ENSMUSG00000030607', u'ENSMUSG00000006932', u'ENSMUSG00000021796', u'ENSMUSG00000004698', u'ENSMUSG00000000378', u'ENSMUSG00000033953', u'ENSMUSG00000019969', u'ENSMUSG00000005583', u'ENSMUSG00000048310', u'ENSMUSG00000020612', u'ENSMUSG00000003865', u'ENSMUSG00000038122', u'ENSMUSG00000026814', u'ENSMUSG00000024169', u'ENSMUSG00000059146', u'ENSMUSG00000039239', u'ENSMUSG00000020184', u'ENSMUSG00000000489', u'ENSMUSG00000075704', u'ENSMUSG00000009995', u'ENSMUSG00000079487', u'ENSMUSG00000051379', u'ENSMUSG00000024962', u'ENSMUSG00000008855', u'ENSMUSG00000002496', u'ENSMUSG00000040711', u'ENSMUSG00000000567', u'ENSMUSG00000061322', u'ENSMUSG00000047193', u'ENSMUSG00000024563', u'ENSMUSG00000034520', u'ENSMUSG00000018581', u'ENSMUSG00000054008', u'ENSMUSG00000021816', u'ENSMUSG00000024294', u'ENSMUSG00000013663', u'ENSMUSG00000009569', u'ENSMUSG00000013584', u'ENSMUSG00000038564', u'ENSMUSG00000031714', u'ENSMUSG00000048402', u'ENSMUSG00000037016', u'ENSMUSG00000026029', u'ENSMUSG00000049577', u'ENSMUSG00000015755', u'ENSMUSG00000027009', u'ENSMUSG00000034227', u'ENSMUSG00000022306', u'ENSMUSG00000006386', u'ENSMUSG00000006818', u'ENSMUSG00000021048', u'ENSMUSG00000022855', u'ENSMUSG00000042745', u'ENSMUSG00000004936', u'ENSMUSG00000042626', u'ENSMUSG00000062209', u'ENSMUSG00000073102', u'ENSMUSG00000021614', u'ENSMUSG00000075254', u'ENSMUSG00000026836', u'ENSMUSG00000042323', u'ENSMUSG00000039910', u'ENSMUSG00000039765', u'ENSMUSG00000031628', u'ENSMUSG00000043733', u'ENSMUSG00000041957', u'ENSMUSG00000039191', u'ENSMUSG00000011256', u'ENSMUSG00000024858', u'ENSMUSG00000022865', u'ENSMUSG00000022141', u'ENSMUSG00000024990', u'ENSMUSG00000034218', u'ENSMUSG00000023991', u'ENSMUSG00000038679', u'ENSMUSG00000026923', u'ENSMUSG00000050295', u'ENSMUSG00000055024', u'ENSMUSG00000020716', u'ENSMUSG00000061393', u'ENSMUSG00000028576', u'ENSMUSG00000037369', u'ENSMUSG00000032187', u'ENSMUSG00000028780', u'ENSMUSG00000026510', u'ENSMUSG00000040040', u'ENSMUSG00000031665', u'ENSMUSG00000043639', u'ENSMUSG00000057530', u'ENSMUSG00000031902', u'ENSMUSG00000030067', u'ENSMUSG00000002603', u'ENSMUSG00000021127', u'ENSMUSG00000002210', u'ENSMUSG00000006134', u'ENSMUSG00000026043', u'ENSMUSG00000015605', u'ENSMUSG00000025810', u'ENSMUSG00000025969', u'ENSMUSG00000048878', u'ENSMUSG00000059588', u'ENSMUSG00000076431', u'ENSMUSG00000063358', u'ENSMUSG00000020709', u'ENSMUSG00000030247', u'ENSMUSG00000062908', u'ENSMUSG00000022883', u'ENSMUSG00000017405', u'ENSMUSG00000021318', u'ENSMUSG00000037486', u'ENSMUSG00000024529', u'ENSMUSG00000025314', u'ENSMUSG00000007872', u'ENSMUSG00000049488', u'ENSMUSG00000062991', u'ENSMUSG00000062312', u'ENSMUSG00000066191', u'ENSMUSG00000050953', u'ENSMUSG00000034781', u'ENSMUSG00000051747', u'ENSMUSG00000024639', u'ENSMUSG00000021650', u'ENSMUSG00000001240', u'ENSMUSG00000038369', u'ENSMUSG00000039632', u'ENSMUSG00000019971', u'ENSMUSG00000020900', u'ENSMUSG00000046169', u'ENSMUSG00000039801', u'ENSMUSG00000032855', u'ENSMUSG00000025076', u'ENSMUSG00000031616', u'ENSMUSG00000027070', u'ENSMUSG00000035152', u'ENSMUSG00000007613', u'ENSMUSG00000032440', u'ENSMUSG00000022262', u'ENSMUSG00000001098', u'ENSMUSG00000009090', u'ENSMUSG00000021835', u'ENSMUSG00000034462', u'ENSMUSG00000027358', u'ENSMUSG00000027962', u'ENSMUSG00000014329', u'ENSMUSG00000020644', u'ENSMUSG00000027204', u'ENSMUSG00000031740', u'ENSMUSG00000015846', u'ENSMUSG00000022672', u'ENSMUSG00000058444', u'ENSMUSG00000027676', u'ENSMUSG00000055320', u'ENSMUSG00000056962', u'ENSMUSG00000026273', u'ENSMUSG00000048450', u'ENSMUSG00000024713', u'ENSMUSG00000020888', u'ENSMUSG00000032327', u'ENSMUSG00000051331', u'ENSMUSG00000035027', u'ENSMUSG00000063172', u'ENSMUSG00000025907', u'ENSMUSG00000018395']), pop_n=13836, p_sm_bonferroni=0.5112441383836189, is_obsolete=False, GO='GO:0007507', name='heart development', pop_count=174, alt_ids=['GO:0007511'], level=3, depth=4, enrichment='e', Cluster='Late Increase', geneid_set=set([u'ENSMUSG00000026923', u'ENSMUSG00000021127', u'ENSMUSG00000013584', u'ENSMUSG00000028780', u'ENSMUSG00000031714', u'ENSMUSG00000033016', u'ENSMUSG00000048402', u'ENSMUSG00000037016', u'ENSMUSG00000021318', u'ENSMUSG00000007613', u'ENSMUSG00000034227', u'ENSMUSG00000032440', u'ENSMUSG00000006386', u'ENSMUSG00000026510', u'ENSMUSG00000021796', u'ENSMUSG00000026043', u'ENSMUSG00000042745', u'ENSMUSG00000042626', u'ENSMUSG00000034462', u'ENSMUSG00000027962', u'ENSMUSG00000062209', u'ENSMUSG00000020644', u'ENSMUSG00000075254', u'ENSMUSG00000020709', u'ENSMUSG00000031665', u'ENSMUSG00000043733', u'ENSMUSG00000024529', u'ENSMUSG00000040711', u'ENSMUSG00000039191', u'ENSMUSG00000000567', u'ENSMUSG00000007872', u'ENSMUSG00000062312', u'ENSMUSG00000015755', u'ENSMUSG00000050953', u'ENSMUSG00000021614', u'ENSMUSG00000038679']), symbols=u'Adap2 Aldh1a2 Bmpr1a Col3a1 Erbb2 Erbb4 Foxj1 Frem2 Gab1 Gja1 Gli2 Gli3 Heg1 Id1 Id2 Id3 Lox Nfatc1 Notch1 Pkd2 Ptpn11 Rbpj Sall1 Sema3c Sh3pxd2b Shc1 Sox9 Tab2 Tek Tgfbr1 Tgfbr2 Trp53bp2 Trps1 Vcam1 Vcan Zfp36l1', symbol_set=set([u'Trps1', u'Heg1', u'Tgfbr2', u'Ptpn11', u'Id2', u'Id3', u'Gab1', u'Lox', u'Gja1', u'Pkd2', u'Notch1', u'Vcam1', u'Col3a1', u'Rbpj', u'Nfatc1', u'Tgfbr1', u'Shc1', u'Frem2', u'Adap2', u'Sh3pxd2b', u'Id1', u'Aldh1a2', u'Erbb2', u'Foxj1', u'Sema3c', u'Tek', u'Erbb4', u'Bmpr1a', u'Vcan', u'Zfp36l1', u'Trp53bp2', u'Gli2', u'Gli3', u'Sox9', u'Sall1', u'Tab2']), geneids='ENSMUSG00000026923 ENSMUSG00000021127 ENSMUSG00000013584 ENSMUSG00000028780 ENSMUSG00000031714 ENSMUSG00000033016 ENSMUSG00000048402 ENSMUSG00000037016 ENSMUSG00000021318 ENSMUSG00000007613 ENSMUSG00000034227 ENSMUSG00000032440 ENSMUSG00000006386 ENSMUSG00000026510 ENSMUSG00000021796 ENSMUSG00000026043 ENSMUSG00000042745 ENSMUSG00000042626 ENSMUSG00000034462 ENSMUSG00000027962 ENSMUSG00000062209 ENSMUSG00000020644 ENSMUSG00000075254 ENSMUSG00000020709 ENSMUSG00000031665 ENSMUSG00000043733 ENSMUSG00000024529 ENSMUSG00000040711 ENSMUSG00000039191 ENSMUSG00000000567 ENSMUSG00000007872 ENSMUSG00000062312 ENSMUSG00000015755 ENSMUSG00000050953 ENSMUSG00000021614 ENSMUSG00000038679', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=2, D1='CE', GO_name='heart development'),
    Nt(p_uncorrected=0.0002532499102161318, study_count=11, study_n=1397, namespace='biological_process', p_fdr_bh=0.024230178913747787, study_items=set([u'ENSMUSG00000022309', u'ENSMUSG00000040152', u'ENSMUSG00000015305', u'ENSMUSG00000029484', u'ENSMUSG00000031486', u'ENSMUSG00000006386', u'ENSMUSG00000032035', u'ENSMUSG00000021340', u'ENSMUSG00000037621', u'ENSMUSG00000036585', u'ENSMUSG00000020357']), NS='BP', pop_items=set([u'ENSMUSG00000030093', u'ENSMUSG00000031486', u'ENSMUSG00000021576', u'ENSMUSG00000059439', u'ENSMUSG00000021340', u'ENSMUSG00000021994', u'ENSMUSG00000032035', u'ENSMUSG00000010175', u'ENSMUSG00000022309', u'ENSMUSG00000029484', u'ENSMUSG00000006386', u'ENSMUSG00000036585', u'ENSMUSG00000050965', u'ENSMUSG00000018593', u'ENSMUSG00000067336', u'ENSMUSG00000015305', u'ENSMUSG00000055633', u'ENSMUSG00000020357', u'ENSMUSG00000002688', u'ENSMUSG00000031980', u'ENSMUSG00000062960', u'ENSMUSG00000023951', u'ENSMUSG00000020689', u'ENSMUSG00000046318', u'ENSMUSG00000041187', u'ENSMUSG00000040152', u'ENSMUSG00000059456', u'ENSMUSG00000054364', u'ENSMUSG00000031955', u'ENSMUSG00000021835', u'ENSMUSG00000037621', u'ENSMUSG00000062352', u'ENSMUSG00000020580']), pop_n=13836, p_sm_bonferroni=1.0, is_obsolete=False, GO='GO:0010595', name='positive regulation of endothelial cell migration', pop_count=33, alt_ids=[], level=6, depth=9, enrichment='e', Cluster='Late Increase', geneid_set=set([u'ENSMUSG00000022309', u'ENSMUSG00000015305', u'ENSMUSG00000040152', u'ENSMUSG00000029484', u'ENSMUSG00000031486', u'ENSMUSG00000006386', u'ENSMUSG00000032035', u'ENSMUSG00000021340', u'ENSMUSG00000037621', u'ENSMUSG00000036585', u'ENSMUSG00000020357']), symbols=u'Adgra2 Angpt1 Anxa3 Atoh8 Ets1 Fgf1 Flt4 Gpld1 Sash1 Tek Thbs1', symbol_set=set([u'Anxa3', u'Tek', u'Gpld1', u'Thbs1', 'Adgra2', u'Ets1', u'Flt4', u'Angpt1', u'Atoh8', u'Fgf1', u'Sash1']), geneids='ENSMUSG00000022309 ENSMUSG00000040152 ENSMUSG00000015305 ENSMUSG00000029484 ENSMUSG00000031486 ENSMUSG00000006386 ENSMUSG00000020357 ENSMUSG00000036585 ENSMUSG00000021340 ENSMUSG00000037621 ENSMUSG00000032035', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=5, D1='A', GO_name='positive regulation of endothelial cell migration'),
    Nt(p_uncorrected=0.0006483368396215944, study_count=10, study_n=1397, namespace='biological_process', p_fdr_bh=0.047453871773462684, study_items=set([u'ENSMUSG00000049493', u'ENSMUSG00000052397', u'ENSMUSG00000020919', u'ENSMUSG00000001761', u'ENSMUSG00000004043', u'ENSMUSG00000057329', u'ENSMUSG00000041235', u'ENSMUSG00000018654', u'ENSMUSG00000040711', u'ENSMUSG00000024978']), NS='BP', pop_items=set([u'ENSMUSG00000048583', u'ENSMUSG00000020713', u'ENSMUSG00000042817', u'ENSMUSG00000025958', u'ENSMUSG00000031755', u'ENSMUSG00000024978', u'ENSMUSG00000049493', u'ENSMUSG00000020919', u'ENSMUSG00000001761', u'ENSMUSG00000005506', u'ENSMUSG00000041235', u'ENSMUSG00000018654', u'ENSMUSG00000022556', u'ENSMUSG00000027274', u'ENSMUSG00000022770', u'ENSMUSG00000011751', u'ENSMUSG00000052397', u'ENSMUSG00000055737', u'ENSMUSG00000075707', u'ENSMUSG00000032383', u'ENSMUSG00000031980', u'ENSMUSG00000021983', u'ENSMUSG00000005069', u'ENSMUSG00000040711', u'ENSMUSG00000053164', u'ENSMUSG00000032259', u'ENSMUSG00000014599', u'ENSMUSG00000004043', u'ENSMUSG00000057329', u'ENSMUSG00000022141', u'ENSMUSG00000025235']), pop_n=13836, p_sm_bonferroni=1.0, is_obsolete=False, GO='GO:0040018', name='positive regulation of multicellular organism growth', pop_count=31, alt_ids=[], level=5, depth=6, enrichment='e', Cluster='Late Increase', geneid_set=set([u'ENSMUSG00000049493', u'ENSMUSG00000052397', u'ENSMUSG00000020919', u'ENSMUSG00000001761', u'ENSMUSG00000004043', u'ENSMUSG00000057329', u'ENSMUSG00000041235', u'ENSMUSG00000018654', u'ENSMUSG00000040711', u'ENSMUSG00000024978']), symbols=u'Bcl2 Chd7 Ezr Gpam Ikzf1 Pls1 Sh3pxd2b Smo Stat5a Stat5b', symbol_set=set([u'Pls1', u'Gpam', u'Chd7', u'Ezr', u'Smo', u'Stat5b', u'Stat5a', u'Sh3pxd2b', u'Ikzf1', u'Bcl2']), geneids='ENSMUSG00000049493 ENSMUSG00000052397 ENSMUSG00000040711 ENSMUSG00000001761 ENSMUSG00000004043 ENSMUSG00000057329 ENSMUSG00000041235 ENSMUSG00000018654 ENSMUSG00000020919 ENSMUSG00000024978', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=0, D1='A', GO_name='positive regulation of multicellular organism growth'),
    Nt(p_uncorrected='', study_count='', study_n='', namespace='', p_fdr_bh='', study_items='', NS='BP', pop_items='', pop_n='', p_sm_bonferroni='', is_obsolete='', GO='GO:0048856', name='', pop_count='', alt_ids='', level=2, depth=2, enrichment='', Cluster='', geneid_set='', symbols='', symbol_set='', geneids='', format_txt=1, hdr_idx=1, is_hdrgo=True, is_usrgo=False, hdr1usr01='*', dcnt=1025, D1='E', GO_name='anatomical structure development'),
    Nt(p_uncorrected=0.0006749090679732751, study_count=9, study_n=1397, namespace='biological_process', p_fdr_bh=0.04869308232791949, study_items=set([u'ENSMUSG00000026923', u'ENSMUSG00000030849', u'ENSMUSG00000039191', u'ENSMUSG00000000567', u'ENSMUSG00000031328', u'ENSMUSG00000027985', u'ENSMUSG00000007613', u'ENSMUSG00000026383', u'ENSMUSG00000033016']), NS='BP', pop_items=set([u'ENSMUSG00000026923', u'ENSMUSG00000020846', u'ENSMUSG00000038545', u'ENSMUSG00000030849', u'ENSMUSG00000007613', u'ENSMUSG00000000693', u'ENSMUSG00000002603', u'ENSMUSG00000027985', u'ENSMUSG00000033016', u'ENSMUSG00000034205', u'ENSMUSG00000021109', u'ENSMUSG00000033953', u'ENSMUSG00000027358', u'ENSMUSG00000022812', u'ENSMUSG00000020358', u'ENSMUSG00000039239', u'ENSMUSG00000005566', u'ENSMUSG00000019487', u'ENSMUSG00000027654', u'ENSMUSG00000039191', u'ENSMUSG00000000567', u'ENSMUSG00000031328', u'ENSMUSG00000048450', u'ENSMUSG00000048616', u'ENSMUSG00000029287', u'ENSMUSG00000026383']), pop_n=13836, p_sm_bonferroni=1.0, is_obsolete=False, GO='GO:0001837', name='epithelial to mesenchymal transition', pop_count=26, alt_ids=[], level=6, depth=6, enrichment='e', Cluster='Late Increase', geneid_set=set([u'ENSMUSG00000026923', u'ENSMUSG00000030849', u'ENSMUSG00000039191', u'ENSMUSG00000000567', u'ENSMUSG00000031328', u'ENSMUSG00000027985', u'ENSMUSG00000007613', u'ENSMUSG00000026383', u'ENSMUSG00000033016']), symbols=u'Epb41l5 Fgfr2 Flna Lef1 Nfatc1 Notch1 Rbpj Sox9 Tgfbr1', symbol_set=set([u'Nfatc1', u'Tgfbr1', 'Epb41l5', u'Rbpj', u'Notch1', u'Sox9', u'Flna', u'Lef1', u'Fgfr2']), geneids='ENSMUSG00000026923 ENSMUSG00000030849 ENSMUSG00000039191 ENSMUSG00000000567 ENSMUSG00000031328 ENSMUSG00000027985 ENSMUSG00000007613 ENSMUSG00000026383 ENSMUSG00000033016', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=12, D1='BCE', GO_name='epithelial to mesenchymal transition'),
    Nt(p_uncorrected=3.614732234018528e-06, study_count=8, study_n=1397, namespace='biological_process', p_fdr_bh=0.0009127801346269119, study_items=set([u'ENSMUSG00000015243', u'ENSMUSG00000026600', u'ENSMUSG00000021242', u'ENSMUSG00000002985', u'ENSMUSG00000026944', u'ENSMUSG00000024030', u'ENSMUSG00000007655', u'ENSMUSG00000024413']), NS='BP', pop_items=set([u'ENSMUSG00000028879', u'ENSMUSG00000018800', u'ENSMUSG00000015243', u'ENSMUSG00000035722', u'ENSMUSG00000021242', u'ENSMUSG00000024413', u'ENSMUSG00000002985', u'ENSMUSG00000037936', u'ENSMUSG00000026944', u'ENSMUSG00000024030', u'ENSMUSG00000007655', u'ENSMUSG00000026600']), pop_n=13836, p_sm_bonferroni=0.05476680807761472, is_obsolete=False, GO='GO:0033344', name='cholesterol efflux', pop_count=12, alt_ids=[], level=7, depth=8, enrichment='e', Cluster='Late Increase', geneid_set=set([u'ENSMUSG00000015243', u'ENSMUSG00000024413', u'ENSMUSG00000021242', u'ENSMUSG00000002985', u'ENSMUSG00000026944', u'ENSMUSG00000024030', u'ENSMUSG00000007655', u'ENSMUSG00000026600']), symbols=u'Abca1 Abca2 Abcg1 Apoe Cav1 Npc1 Npc2 Soat1', symbol_set=set([u'Abcg1', u'Apoe', u'Npc2', u'Npc1', u'Soat1', u'Abca2', u'Abca1', u'Cav1']), geneids='ENSMUSG00000015243 ENSMUSG00000026600 ENSMUSG00000021242 ENSMUSG00000002985 ENSMUSG00000026944 ENSMUSG00000024030 ENSMUSG00000007655 ENSMUSG00000024413', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=0, D1='CG', GO_name='cholesterol efflux'),
    Nt(p_uncorrected=0.0005660627202574551, study_count=6, study_n=1397, namespace='biological_process', p_fdr_bh=0.042041256248140695, study_items=set([u'ENSMUSG00000020053', u'ENSMUSG00000020919', u'ENSMUSG00000022901', u'ENSMUSG00000004043', u'ENSMUSG00000000732', u'ENSMUSG00000024978']), NS='BP', pop_items=set([u'ENSMUSG00000020053', u'ENSMUSG00000048583', u'ENSMUSG00000020919', u'ENSMUSG00000022901', u'ENSMUSG00000039217', u'ENSMUSG00000004043', u'ENSMUSG00000000732', u'ENSMUSG00000030793', u'ENSMUSG00000031805', u'ENSMUSG00000039323', u'ENSMUSG00000047139', u'ENSMUSG00000024978']), pop_n=13836, p_sm_bonferroni=1.0, is_obsolete=False, GO='GO:0042104', name='positive regulation of activated T cell proliferation', pop_count=12, alt_ids=[], level=9, depth=10, enrichment='e', Cluster='Late Increase', geneid_set=set([u'ENSMUSG00000020053', u'ENSMUSG00000020919', u'ENSMUSG00000022901', u'ENSMUSG00000004043', u'ENSMUSG00000000732', u'ENSMUSG00000024978']), symbols=u'Cd86 Gpam Icosl Igf1 Stat5a Stat5b', symbol_set=set([u'Igf1', u'Cd86', u'Stat5b', u'Stat5a', u'Gpam', u'Icosl']), geneids='ENSMUSG00000020053 ENSMUSG00000020919 ENSMUSG00000022901 ENSMUSG00000004043 ENSMUSG00000000732 ENSMUSG00000024978', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=0, D1='A', GO_name='positive regulation of activated T cell proliferation'),
    Nt(p_uncorrected=0.0005921810051337039, study_count=32, study_n=1397, namespace='biological_process', p_fdr_bh=0.0437665093111256, study_items=set([u'ENSMUSG00000021248', u'ENSMUSG00000029416', u'ENSMUSG00000025935', u'ENSMUSG00000027423', u'ENSMUSG00000028419', u'ENSMUSG00000052688', u'ENSMUSG00000018672', u'ENSMUSG00000042312', u'ENSMUSG00000033039', u'ENSMUSG00000025351', u'ENSMUSG00000050732', u'ENSMUSG00000041417', u'ENSMUSG00000028955', u'ENSMUSG00000022150', u'ENSMUSG00000022365', u'ENSMUSG00000033577', u'ENSMUSG00000042870', u'ENSMUSG00000001506', u'ENSMUSG00000038024', u'ENSMUSG00000068874', u'ENSMUSG00000027882', u'ENSMUSG00000019173', u'ENSMUSG00000029560', u'ENSMUSG00000027808', u'ENSMUSG00000040848', u'ENSMUSG00000055371', u'ENSMUSG00000035805', u'ENSMUSG00000002365', u'ENSMUSG00000005656', u'ENSMUSG00000028923', u'ENSMUSG00000018567', u'ENSMUSG00000032733']), NS='BP', pop_items=set([u'ENSMUSG00000020198', u'ENSMUSG00000003872', u'ENSMUSG00000002015', u'ENSMUSG00000023923', u'ENSMUSG00000002395', u'ENSMUSG00000037321', u'ENSMUSG00000030298', u'ENSMUSG00000028437', u'ENSMUSG00000026491', u'ENSMUSG00000041879', u'ENSMUSG00000020817', u'ENSMUSG00000027663', u'ENSMUSG00000034951', u'ENSMUSG00000027706', u'ENSMUSG00000026797', u'ENSMUSG00000026792', u'ENSMUSG00000018672', u'ENSMUSG00000062444', u'ENSMUSG00000029518', u'ENSMUSG00000019478', u'ENSMUSG00000015023', u'ENSMUSG00000024045', u'ENSMUSG00000039509', u'ENSMUSG00000006005', u'ENSMUSG00000032096', u'ENSMUSG00000016637', u'ENSMUSG00000045503', u'ENSMUSG00000021357', u'ENSMUSG00000042229', u'ENSMUSG00000021218', u'ENSMUSG00000032382', u'ENSMUSG00000002718', u'ENSMUSG00000005656', u'ENSMUSG00000031342', u'ENSMUSG00000017288', u'ENSMUSG00000037325', u'ENSMUSG00000022765', u'ENSMUSG00000036391', u'ENSMUSG00000031242', u'ENSMUSG00000000711', u'ENSMUSG00000032892', u'ENSMUSG00000062580', u'ENSMUSG00000040701', u'ENSMUSG00000026339', u'ENSMUSG00000024191', u'ENSMUSG00000001376', u'ENSMUSG00000010392', u'ENSMUSG00000051853', u'ENSMUSG00000068874', u'ENSMUSG00000026726', u'ENSMUSG00000019726', u'ENSMUSG00000058569', u'ENSMUSG00000022538', u'ENSMUSG00000030662', u'ENSMUSG00000028657', u'ENSMUSG00000025235', u'ENSMUSG00000034190', u'ENSMUSG00000046230', u'ENSMUSG00000020219', u'ENSMUSG00000021038', u'ENSMUSG00000024581', u'ENSMUSG00000027534', u'ENSMUSG00000029415', u'ENSMUSG00000029416', u'ENSMUSG00000002059', u'ENSMUSG00000002058', u'ENSMUSG00000006930', u'ENSMUSG00000028572', u'ENSMUSG00000020986', u'ENSMUSG00000024535', u'ENSMUSG00000030704', u'ENSMUSG00000038291', u'ENSMUSG00000000538', u'ENSMUSG00000024533', u'ENSMUSG00000041236', u'ENSMUSG00000028096', u'ENSMUSG00000028975', u'ENSMUSG00000047767', u'ENSMUSG00000064068', u'ENSMUSG00000030082', u'ENSMUSG00000014550', u'ENSMUSG00000020290', u'ENSMUSG00000039623', u'ENSMUSG00000006058', u'ENSMUSG00000028373', u'ENSMUSG00000040594', u'ENSMUSG00000030245', u'ENSMUSG00000030534', u'ENSMUSG00000063145', u'ENSMUSG00000052798', u'ENSMUSG00000031337', u'ENSMUSG00000028385', u'ENSMUSG00000026111', u'ENSMUSG00000024319', u'ENSMUSG00000020149', u'ENSMUSG00000031834', u'ENSMUSG00000025484', u'ENSMUSG00000017774', u'ENSMUSG00000003438', u'ENSMUSG00000021248', u'ENSMUSG00000036291', u'ENSMUSG00000020003', u'ENSMUSG00000031753', u'ENSMUSG00000031202', u'ENSMUSG00000018567', u'ENSMUSG00000031755', u'ENSMUSG00000051329', u'ENSMUSG00000048076', u'ENSMUSG00000026577', u'ENSMUSG00000027287', u'ENSMUSG00000026470', u'ENSMUSG00000056185', u'ENSMUSG00000031729', u'ENSMUSG00000022013', u'ENSMUSG00000021929', u'ENSMUSG00000003226', u'ENSMUSG00000019861', u'ENSMUSG00000001506', u'ENSMUSG00000054702', u'ENSMUSG00000027575', u'ENSMUSG00000022829', u'ENSMUSG00000004768', u'ENSMUSG00000044147', u'ENSMUSG00000028758', u'ENSMUSG00000047187', u'ENSMUSG00000020440', u'ENSMUSG00000024787', u'ENSMUSG00000026878', u'ENSMUSG00000000743', u'ENSMUSG00000063646', u'ENSMUSG00000008036', u'ENSMUSG00000027787', u'ENSMUSG00000032939', u'ENSMUSG00000027782', u'ENSMUSG00000042590', u'ENSMUSG00000021660', u'ENSMUSG00000026718', u'ENSMUSG00000036435', u'ENSMUSG00000024875', u'ENSMUSG00000025351', u'ENSMUSG00000030754', u'ENSMUSG00000043463', u'ENSMUSG00000025354', u'ENSMUSG00000015291', u'ENSMUSG00000028614', u'ENSMUSG00000033124', u'ENSMUSG00000002984', u'ENSMUSG00000043262', u'ENSMUSG00000034247', u'ENSMUSG00000020386', u'ENSMUSG00000029359', u'ENSMUSG00000033128', u'ENSMUSG00000020955', u'ENSMUSG00000020952', u'ENSMUSG00000034893', u'ENSMUSG00000052533', u'ENSMUSG00000020894', u'ENSMUSG00000034484', u'ENSMUSG00000020590', u'ENSMUSG00000054808', u'ENSMUSG00000037649', u'ENSMUSG00000020876', u'ENSMUSG00000037257', u'ENSMUSG00000024150', u'ENSMUSG00000027879', u'ENSMUSG00000052584', u'ENSMUSG00000028923', u'ENSMUSG00000030058', u'ENSMUSG00000018661', u'ENSMUSG00000027099', u'ENSMUSG00000019868', u'ENSMUSG00000020740', u'ENSMUSG00000062352', u'ENSMUSG00000031979', u'ENSMUSG00000079316', u'ENSMUSG00000030172', u'ENSMUSG00000031488', u'ENSMUSG00000030279', u'ENSMUSG00000068798', u'ENSMUSG00000044982', u'ENSMUSG00000067851', u'ENSMUSG00000022159', u'ENSMUSG00000031479', u'ENSMUSG00000022150', u'ENSMUSG00000044528', u'ENSMUSG00000040022', u'ENSMUSG00000019906', u'ENSMUSG00000026433', u'ENSMUSG00000020132', u'ENSMUSG00000040029', u'ENSMUSG00000004931', u'ENSMUSG00000027438', u'ENSMUSG00000027742', u'ENSMUSG00000022905', u'ENSMUSG00000030301', u'ENSMUSG00000020056', u'ENSMUSG00000070939', u'ENSMUSG00000036992', u'ENSMUSG00000031158', u'ENSMUSG00000034593', u'ENSMUSG00000029146', u'ENSMUSG00000002365', u'ENSMUSG00000056832', u'ENSMUSG00000063801', u'ENSMUSG00000021877', u'ENSMUSG00000001143', u'ENSMUSG00000004843', u'ENSMUSG00000031988', u'ENSMUSG00000079657', u'ENSMUSG00000022338', u'ENSMUSG00000004849', u'ENSMUSG00000025793', u'ENSMUSG00000026927', u'ENSMUSG00000005907', u'ENSMUSG00000003033', u'ENSMUSG00000038467', u'ENSMUSG00000003037', u'ENSMUSG00000020792', u'ENSMUSG00000034687', u'ENSMUSG00000022443', u'ENSMUSG00000050192', u'ENSMUSG00000003731', u'ENSMUSG00000022200', u'ENSMUSG00000025935', u'ENSMUSG00000024339', u'ENSMUSG00000033577', u'ENSMUSG00000029392', u'ENSMUSG00000034203', u'ENSMUSG00000014077', u'ENSMUSG00000074582', u'ENSMUSG00000029763', u'ENSMUSG00000029408', u'ENSMUSG00000024983', u'ENSMUSG00000032757', u'ENSMUSG00000029401', u'ENSMUSG00000029407', u'ENSMUSG00000029560', u'ENSMUSG00000027291', u'ENSMUSG00000034973', u'ENSMUSG00000048439', u'ENSMUSG00000024247', u'ENSMUSG00000000131', u'ENSMUSG00000028550', u'ENSMUSG00000034473', u'ENSMUSG00000014402', u'ENSMUSG00000006024', u'ENSMUSG00000020175', u'ENSMUSG00000061244', u'ENSMUSG00000008301', u'ENSMUSG00000020843', u'ENSMUSG00000028049', u'ENSMUSG00000039637', u'ENSMUSG00000077450', u'ENSMUSG00000031993', u'ENSMUSG00000055013', u'ENSMUSG00000059588', u'ENSMUSG00000035152', u'ENSMUSG00000031539', u'ENSMUSG00000032353', u'ENSMUSG00000019715', u'ENSMUSG00000009090', u'ENSMUSG00000031840', u'ENSMUSG00000002031', u'ENSMUSG00000020671', u'ENSMUSG00000036989', u'ENSMUSG00000002741', u'ENSMUSG00000002372', u'ENSMUSG00000024065', u'ENSMUSG00000021278', u'ENSMUSG00000062169', u'ENSMUSG00000034152', u'ENSMUSG00000021375', u'ENSMUSG00000031667', u'ENSMUSG00000051256', u'ENSMUSG00000042271', u'ENSMUSG00000032127', u'ENSMUSG00000019971', u'ENSMUSG00000022946', u'ENSMUSG00000031691', u'ENSMUSG00000031696', u'ENSMUSG00000079614', u'ENSMUSG00000038039', u'ENSMUSG00000073678', u'ENSMUSG00000029125', u'ENSMUSG00000002957', u'ENSMUSG00000020454', u'ENSMUSG00000003779', u'ENSMUSG00000032549', u'ENSMUSG00000078441', u'ENSMUSG00000022365', u'ENSMUSG00000024663', u'ENSMUSG00000012535', u'ENSMUSG00000041073', u'ENSMUSG00000026705', u'ENSMUSG00000038456', u'ENSMUSG00000010154', u'ENSMUSG00000028136', u'ENSMUSG00000055371', u'ENSMUSG00000033419', u'ENSMUSG00000001855', u'ENSMUSG00000001998', u'ENSMUSG00000025607', u'ENSMUSG00000037646', u'ENSMUSG00000020946', u'ENSMUSG00000041779', u'ENSMUSG00000054277', u'ENSMUSG00000029430', u'ENSMUSG00000060992', u'ENSMUSG00000029434', u'ENSMUSG00000037997', u'ENSMUSG00000028552', u'ENSMUSG00000028419', u'ENSMUSG00000052688', u'ENSMUSG00000028007', u'ENSMUSG00000005674', u'ENSMUSG00000020283', u'ENSMUSG00000035933', u'ENSMUSG00000001150', u'ENSMUSG00000028955', u'ENSMUSG00000050373', u'ENSMUSG00000024870', u'ENSMUSG00000020739', u'ENSMUSG00000004771', u'ENSMUSG00000018909', u'ENSMUSG00000023460', u'ENSMUSG00000024104', u'ENSMUSG00000027882', u'ENSMUSG00000002319', u'ENSMUSG00000044465', u'ENSMUSG00000031367', u'ENSMUSG00000031813', u'ENSMUSG00000028999', u'ENSMUSG00000022142', u'ENSMUSG00000020128', u'ENSMUSG00000074909', u'ENSMUSG00000060090', u'ENSMUSG00000002778', u'ENSMUSG00000030314', u'ENSMUSG00000027429', u'ENSMUSG00000030629', u'ENSMUSG00000027423', u'ENSMUSG00000027422', u'ENSMUSG00000046562', u'ENSMUSG00000032180', u'ENSMUSG00000044768', u'ENSMUSG00000031143', u'ENSMUSG00000033365', u'ENSMUSG00000031149', u'ENSMUSG00000051355', u'ENSMUSG00000019804', u'ENSMUSG00000040722', u'ENSMUSG00000032504', u'ENSMUSG00000019802', u'ENSMUSG00000032264', u'ENSMUSG00000049659', u'ENSMUSG00000025816', u'ENSMUSG00000062110', u'ENSMUSG00000011658', u'ENSMUSG00000027699', u'ENSMUSG00000033933', u'ENSMUSG00000020541', u'ENSMUSG00000027519', u'ENSMUSG00000002820', u'ENSMUSG00000053119', u'ENSMUSG00000033106', u'ENSMUSG00000025035', u'ENSMUSG00000028879', u'ENSMUSG00000022350', u'ENSMUSG00000040034', u'ENSMUSG00000034560', u'ENSMUSG00000024737', u'ENSMUSG00000025885', u'ENSMUSG00000029790', u'ENSMUSG00000034602', u'ENSMUSG00000024797', u'ENSMUSG00000022808', u'ENSMUSG00000062797', u'ENSMUSG00000062421', u'ENSMUSG00000040188', u'ENSMUSG00000019066', u'ENSMUSG00000038520', u'ENSMUSG00000019790', u'ENSMUSG00000025371', u'ENSMUSG00000021062', u'ENSMUSG00000033039', u'ENSMUSG00000034789', u'ENSMUSG00000034867', u'ENSMUSG00000050732', u'ENSMUSG00000035392', u'ENSMUSG00000030727', u'ENSMUSG00000036943', u'ENSMUSG00000028998', u'ENSMUSG00000051735', u'ENSMUSG00000063550', u'ENSMUSG00000015747', u'ENSMUSG00000034216', u'ENSMUSG00000021700', u'ENSMUSG00000030519', u'ENSMUSG00000063406', u'ENSMUSG00000028354', u'ENSMUSG00000042364', u'ENSMUSG00000037234', u'ENSMUSG00000034940', u'ENSMUSG00000035805', u'ENSMUSG00000078812', u'ENSMUSG00000020806', u'ENSMUSG00000031916', u'ENSMUSG00000031529', u'ENSMUSG00000040667', u'ENSMUSG00000031913', u'ENSMUSG00000046032', u'ENSMUSG00000027076', u'ENSMUSG00000003411', u'ENSMUSG00000032733', u'ENSMUSG00000063172', u'ENSMUSG00000018481', u'ENSMUSG00000039016', u'ENSMUSG00000053317', u'ENSMUSG00000064181', u'ENSMUSG00000049969', u'ENSMUSG00000036882', u'ENSMUSG00000026553', u'ENSMUSG00000053293', u'ENSMUSG00000053291', u'ENSMUSG00000032422', u'ENSMUSG00000021824', u'ENSMUSG00000038740', u'ENSMUSG00000066232', u'ENSMUSG00000001440', u'ENSMUSG00000019969', u'ENSMUSG00000038024', u'ENSMUSG00000020375', u'ENSMUSG00000056268', u'ENSMUSG00000027411', u'ENSMUSG00000035325', u'ENSMUSG00000029608', u'ENSMUSG00000048832', u'ENSMUSG00000063895', u'ENSMUSG00000002949', u'ENSMUSG00000049562', u'ENSMUSG00000032258', u'ENSMUSG00000021952', u'ENSMUSG00000054364', u'ENSMUSG00000009907', u'ENSMUSG00000020078', u'ENSMUSG00000024772', u'ENSMUSG00000079477', u'ENSMUSG00000017978', u'ENSMUSG00000019518', u'ENSMUSG00000021124', u'ENSMUSG00000061536', u'ENSMUSG00000021687', u'ENSMUSG00000021686', u'ENSMUSG00000022427', u'ENSMUSG00000021484', u'ENSMUSG00000024357', u'ENSMUSG00000019173', u'ENSMUSG00000030872', u'ENSMUSG00000043614', u'ENSMUSG00000022855', u'ENSMUSG00000073639', u'ENSMUSG00000027522', u'ENSMUSG00000035351', u'ENSMUSG00000027255', u'ENSMUSG00000004394', u'ENSMUSG00000009470', u'ENSMUSG00000035919', u'ENSMUSG00000027808', u'ENSMUSG00000068264', u'ENSMUSG00000027804', u'ENSMUSG00000034826', u'ENSMUSG00000034353', u'ENSMUSG00000021619', u'ENSMUSG00000024851', u'ENSMUSG00000052566', u'ENSMUSG00000020484', u'ENSMUSG00000074030', u'ENSMUSG00000041891', u'ENSMUSG00000031950', u'ENSMUSG00000026605', u'ENSMUSG00000078713', u'ENSMUSG00000027739', u'ENSMUSG00000033916', u'ENSMUSG00000030091', u'ENSMUSG00000032583', u'ENSMUSG00000030098', u'ENSMUSG00000042312', u'ENSMUSG00000022100', u'ENSMUSG00000004626', u'ENSMUSG00000026280', u'ENSMUSG00000030806', u'ENSMUSG00000026289', u'ENSMUSG00000018733', u'ENSMUSG00000020650', u'ENSMUSG00000061315', u'ENSMUSG00000053799', u'ENSMUSG00000066278', u'ENSMUSG00000030327', u'ENSMUSG00000017831', u'ENSMUSG00000031600', u'ENSMUSG00000031731', u'ENSMUSG00000022841', u'ENSMUSG00000051343', u'ENSMUSG00000032458', u'ENSMUSG00000032513', u'ENSMUSG00000036678', u'ENSMUSG00000022722', u'ENSMUSG00000060279', u'ENSMUSG00000021079', u'ENSMUSG00000001240', u'ENSMUSG00000045302', u'ENSMUSG00000036057', u'ENSMUSG00000022663', u'ENSMUSG00000021013', u'ENSMUSG00000024480', u'ENSMUSG00000055681', u'ENSMUSG00000010609', u'ENSMUSG00000024487', u'ENSMUSG00000054423', u'ENSMUSG00000079111', u'ENSMUSG00000024645', u'ENSMUSG00000020088', u'ENSMUSG00000042870', u'ENSMUSG00000027115', u'ENSMUSG00000067150', u'ENSMUSG00000028693', u'ENSMUSG00000029462', u'ENSMUSG00000034187', u'ENSMUSG00000025340', u'ENSMUSG00000034813', u'ENSMUSG00000041417', u'ENSMUSG00000030982', u'ENSMUSG00000060216', u'ENSMUSG00000027162', u'ENSMUSG00000040848', u'ENSMUSG00000024897', u'ENSMUSG00000005069', u'ENSMUSG00000038301', u'ENSMUSG00000067825']), pop_n=13836, p_sm_bonferroni=1.0, is_obsolete=False, GO='GO:0015031', name='protein transport', pop_count=539, alt_ids=['GO:0015831'], level=4, depth=5, enrichment='p', Cluster='Late Increase', geneid_set=set([u'ENSMUSG00000021248', u'ENSMUSG00000029416', u'ENSMUSG00000025935', u'ENSMUSG00000027423', u'ENSMUSG00000028419', u'ENSMUSG00000052688', u'ENSMUSG00000022365', u'ENSMUSG00000042312', u'ENSMUSG00000033039', u'ENSMUSG00000025351', u'ENSMUSG00000050732', u'ENSMUSG00000041417', u'ENSMUSG00000028955', u'ENSMUSG00000022150', u'ENSMUSG00000018672', u'ENSMUSG00000033577', u'ENSMUSG00000042870', u'ENSMUSG00000001506', u'ENSMUSG00000038024', u'ENSMUSG00000068874', u'ENSMUSG00000027882', u'ENSMUSG00000019173', u'ENSMUSG00000029560', u'ENSMUSG00000027808', u'ENSMUSG00000040848', u'ENSMUSG00000055371', u'ENSMUSG00000035805', u'ENSMUSG00000002365', u'ENSMUSG00000005656', u'ENSMUSG00000028923', u'ENSMUSG00000018567', u'ENSMUSG00000032733']), symbols=u'Cd63 Chmp5 Col1a1 Copz2 Dab2 Dennd4c Derl1 Gabarap Micall1 Mlc1 Myo6 Necap2 Pik3r1 Rab5c Rab7b S100a13 Selenbp1 Serp1 Sft2d2 Slc15a4 Snx33 Snx5 Snx6 Snx8 Snx9 Stam2 Stxbp3 Tmed10 Tom1 Tram1 Vamp3 Vamp8', symbol_set=set([u'Copz2', u'Necap2', u'Tom1', u'Derl1', u'Dab2', 'Rab7b', u'Rab5c', u'Selenbp1', u'Myo6', u'Gabarap', u'Sft2d2', u'S100a13', u'Snx9', u'Chmp5', u'Tmed10', u'Vamp3', u'Snx6', u'Snx5', u'Micall1', u'Vamp8', u'Stam2', u'Snx8', u'Tram1', 'Stxbp3', u'Pik3r1', u'Col1a1', u'Cd63', u'Serp1', u'Mlc1', u'Dennd4c', u'Snx33', u'Slc15a4']), geneids='ENSMUSG00000021248 ENSMUSG00000029416 ENSMUSG00000025935 ENSMUSG00000027423 ENSMUSG00000028419 ENSMUSG00000018567 ENSMUSG00000022365 ENSMUSG00000042312 ENSMUSG00000033039 ENSMUSG00000025351 ENSMUSG00000050732 ENSMUSG00000041417 ENSMUSG00000028955 ENSMUSG00000022150 ENSMUSG00000018672 ENSMUSG00000033577 ENSMUSG00000042870 ENSMUSG00000001506 ENSMUSG00000038024 ENSMUSG00000068874 ENSMUSG00000027882 ENSMUSG00000019173 ENSMUSG00000029560 ENSMUSG00000027808 ENSMUSG00000040848 ENSMUSG00000055371 ENSMUSG00000035805 ENSMUSG00000002365 ENSMUSG00000005656 ENSMUSG00000028923 ENSMUSG00000052688 ENSMUSG00000032733', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=225, D1='G', GO_name='protein transport'),
    Nt(p_uncorrected=0.00047602038734059613, study_count=29, study_n=1397, namespace='biological_process', p_fdr_bh=0.0381597084052771, study_items=set([u'ENSMUSG00000061436', u'ENSMUSG00000008734', u'ENSMUSG00000045382', u'ENSMUSG00000019997', u'ENSMUSG00000027765', u'ENSMUSG00000041417', u'ENSMUSG00000030720', u'ENSMUSG00000022150', u'ENSMUSG00000006386', u'ENSMUSG00000036585', u'ENSMUSG00000037523', u'ENSMUSG00000021846', u'ENSMUSG00000070509', u'ENSMUSG00000020372', u'ENSMUSG00000026483', u'ENSMUSG00000024164', u'ENSMUSG00000032633', u'ENSMUSG00000020357', u'ENSMUSG00000032841', u'ENSMUSG00000031451', u'ENSMUSG00000025584', u'ENSMUSG00000004451', u'ENSMUSG00000032231', u'ENSMUSG00000000567', u'ENSMUSG00000022469', u'ENSMUSG00000062312', u'ENSMUSG00000029816', u'ENSMUSG00000022122', u'ENSMUSG00000020122']), NS='BP', pop_items=set([u'ENSMUSG00000048583', u'ENSMUSG00000019579', u'ENSMUSG00000059714', u'ENSMUSG00000019997', u'ENSMUSG00000029616', u'ENSMUSG00000034160', u'ENSMUSG00000004056', u'ENSMUSG00000037526', u'ENSMUSG00000070348', u'ENSMUSG00000037523', u'ENSMUSG00000021451', u'ENSMUSG00000020614', u'ENSMUSG00000019969', u'ENSMUSG00000021846', u'ENSMUSG00000013921', u'ENSMUSG00000020623', u'ENSMUSG00000020372', u'ENSMUSG00000026814', u'ENSMUSG00000024164', u'ENSMUSG00000026842', u'ENSMUSG00000021408', u'ENSMUSG00000002948', u'ENSMUSG00000000567', u'ENSMUSG00000040016', u'ENSMUSG00000027358', u'ENSMUSG00000002307', u'ENSMUSG00000066551', u'ENSMUSG00000021057', u'ENSMUSG00000022847', u'ENSMUSG00000020580', u'ENSMUSG00000061436', u'ENSMUSG00000020366', u'ENSMUSG00000041936', u'ENSMUSG00000018209', u'ENSMUSG00000015837', u'ENSMUSG00000006699', u'ENSMUSG00000026483', u'ENSMUSG00000001847', u'ENSMUSG00000052593', u'ENSMUSG00000041417', u'ENSMUSG00000022150', u'ENSMUSG00000006386', u'ENSMUSG00000022855', u'ENSMUSG00000027523', u'ENSMUSG00000036904', u'ENSMUSG00000018909', u'ENSMUSG00000030265', u'ENSMUSG00000020357', u'ENSMUSG00000009281', u'ENSMUSG00000055024', u'ENSMUSG00000042249', u'ENSMUSG00000044674', u'ENSMUSG00000061878', u'ENSMUSG00000030774', u'ENSMUSG00000033307', u'ENSMUSG00000036273', u'ENSMUSG00000035992', u'ENSMUSG00000024182', u'ENSMUSG00000020484', u'ENSMUSG00000029816', u'ENSMUSG00000024454', u'ENSMUSG00000020122', u'ENSMUSG00000042632', u'ENSMUSG00000014547', u'ENSMUSG00000034165', u'ENSMUSG00000038119', u'ENSMUSG00000042817', u'ENSMUSG00000067336', u'ENSMUSG00000028068', u'ENSMUSG00000066129', u'ENSMUSG00000024621', u'ENSMUSG00000025147', u'ENSMUSG00000031639', u'ENSMUSG00000021994', u'ENSMUSG00000028756', u'ENSMUSG00000027584', u'ENSMUSG00000057531', u'ENSMUSG00000002603', u'ENSMUSG00000053647', u'ENSMUSG00000071369', u'ENSMUSG00000051615', u'ENSMUSG00000000148', u'ENSMUSG00000001729', u'ENSMUSG00000000142', u'ENSMUSG00000032171', u'ENSMUSG00000063065', u'ENSMUSG00000000838', u'ENSMUSG00000052155', u'ENSMUSG00000029394', u'ENSMUSG00000020063', u'ENSMUSG00000044716', u'ENSMUSG00000030538', u'ENSMUSG00000033352', u'ENSMUSG00000000441', u'ENSMUSG00000022607', u'ENSMUSG00000028871', u'ENSMUSG00000025499', u'ENSMUSG00000005417', u'ENSMUSG00000003233', u'ENSMUSG00000062312', u'ENSMUSG00000027347', u'ENSMUSG00000022122', u'ENSMUSG00000036295', u'ENSMUSG00000070509', u'ENSMUSG00000059970', u'ENSMUSG00000024397', u'ENSMUSG00000031750', u'ENSMUSG00000028289', u'ENSMUSG00000008734', u'ENSMUSG00000005534', u'ENSMUSG00000045382', u'ENSMUSG00000028760', u'ENSMUSG00000029071', u'ENSMUSG00000031616', u'ENSMUSG00000029521', u'ENSMUSG00000027765', u'ENSMUSG00000025162', u'ENSMUSG00000061374', u'ENSMUSG00000030720', u'ENSMUSG00000071984', u'ENSMUSG00000036585', u'ENSMUSG00000036106', u'ENSMUSG00000050965', u'ENSMUSG00000058594', u'ENSMUSG00000028991', u'ENSMUSG00000027692', u'ENSMUSG00000061603', u'ENSMUSG00000038264', u'ENSMUSG00000029468', u'ENSMUSG00000028195', u'ENSMUSG00000032633', u'ENSMUSG00000021549', u'ENSMUSG00000032841', u'ENSMUSG00000031451', u'ENSMUSG00000031667', u'ENSMUSG00000025584', u'ENSMUSG00000004451', u'ENSMUSG00000062960', u'ENSMUSG00000023951', u'ENSMUSG00000000184', u'ENSMUSG00000032231', u'ENSMUSG00000022469', u'ENSMUSG00000030854', u'ENSMUSG00000027859', u'ENSMUSG00000020888', u'ENSMUSG00000021835', u'ENSMUSG00000060216', u'ENSMUSG00000025907']), pop_n=13836, p_sm_bonferroni=1.0, is_obsolete=False, GO='GO:0001934', name='positive regulation of protein phosphorylation', pop_count=148, alt_ids=[], level=8, depth=9, enrichment='e', Cluster='Late Increase', geneid_set=set([u'ENSMUSG00000061436', u'ENSMUSG00000020372', u'ENSMUSG00000026483', u'ENSMUSG00000024164', u'ENSMUSG00000032633', u'ENSMUSG00000020357', u'ENSMUSG00000031451', u'ENSMUSG00000008734', u'ENSMUSG00000032841', u'ENSMUSG00000020122', u'ENSMUSG00000045382', u'ENSMUSG00000019997', u'ENSMUSG00000025584', u'ENSMUSG00000004451', u'ENSMUSG00000032231', u'ENSMUSG00000027765', u'ENSMUSG00000041417', u'ENSMUSG00000000567', u'ENSMUSG00000030720', u'ENSMUSG00000022469', u'ENSMUSG00000022150', u'ENSMUSG00000006386', u'ENSMUSG00000036585', u'ENSMUSG00000062312', u'ENSMUSG00000037523', u'ENSMUSG00000021846', u'ENSMUSG00000029816', u'ENSMUSG00000022122', u'ENSMUSG00000070509']), symbols=u'Anxa2 C3 Cln3 Ctgf Cxcr4 Dab2 Ednrb Egfr Erbb2 Fam129a Fgf1 Flcn Flt4 Gas6 Gpnmb Gprc5b Hipk2 Mavs P2ry1 Pde8a Peli2 Pik3r1 Prr5l Rack1 Ralb Rapgef3 Rgma Sox9 Tek', symbol_set=set([u'Peli2', u'Gpnmb', u'Ctgf', u'Fam129a', u'Dab2', u'Mavs', u'Ralb', u'Gprc5b', u'Flcn', u'Anxa2', u'C3', u'Rgma', u'Ednrb', u'Sox9', u'Pik3r1', u'Cxcr4', u'Flt4', u'P2ry1', u'Fgf1', u'Erbb2', u'Tek', u'Egfr', u'Prr5l', u'Hipk2', u'Cln3', u'Rapgef3', 'Rack1', u'Pde8a', u'Gas6']), geneids='ENSMUSG00000061436 ENSMUSG00000008734 ENSMUSG00000045382 ENSMUSG00000019997 ENSMUSG00000027765 ENSMUSG00000041417 ENSMUSG00000030720 ENSMUSG00000022150 ENSMUSG00000006386 ENSMUSG00000036585 ENSMUSG00000037523 ENSMUSG00000021846 ENSMUSG00000070509 ENSMUSG00000020372 ENSMUSG00000026483 ENSMUSG00000024164 ENSMUSG00000032633 ENSMUSG00000020357 ENSMUSG00000032841 ENSMUSG00000031451 ENSMUSG00000025584 ENSMUSG00000004451 ENSMUSG00000032231 ENSMUSG00000000567 ENSMUSG00000022469 ENSMUSG00000062312 ENSMUSG00000029816 ENSMUSG00000022122 ENSMUSG00000020122', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=85, D1='A', GO_name='positive regulation of protein phosphorylation'),
    Nt(p_uncorrected=7.690733397979356e-06, study_count=11, study_n=1397, namespace='biological_process', p_fdr_bh=0.0015331881804313847, study_items=set([u'ENSMUSG00000024066', u'ENSMUSG00000022018', u'ENSMUSG00000040152', u'ENSMUSG00000033278', u'ENSMUSG00000022025', u'ENSMUSG00000002985', u'ENSMUSG00000007613', u'ENSMUSG00000050953', u'ENSMUSG00000037621', u'ENSMUSG00000007655', u'ENSMUSG00000000058']), NS='BP', pop_items=set([u'ENSMUSG00000020716', u'ENSMUSG00000028029', u'ENSMUSG00000022025', u'ENSMUSG00000000530', u'ENSMUSG00000016918', u'ENSMUSG00000054428', u'ENSMUSG00000030551', u'ENSMUSG00000033278', u'ENSMUSG00000090935', u'ENSMUSG00000002985', u'ENSMUSG00000018593', u'ENSMUSG00000026104', u'ENSMUSG00000025428', u'ENSMUSG00000024066', u'ENSMUSG00000026814', u'ENSMUSG00000021256', u'ENSMUSG00000040152', u'ENSMUSG00000022018', u'ENSMUSG00000007613', u'ENSMUSG00000050953', u'ENSMUSG00000037621', u'ENSMUSG00000007655', u'ENSMUSG00000000600', u'ENSMUSG00000000058']), pop_n=13836, p_sm_bonferroni=0.11652230171278523, is_obsolete=False, GO='GO:0001937', name='negative regulation of endothelial cell proliferation', pop_count=24, alt_ids=[], level=7, depth=7, enrichment='e', Cluster='Late Increase', geneid_set=set([u'ENSMUSG00000024066', u'ENSMUSG00000000058', u'ENSMUSG00000040152', u'ENSMUSG00000033278', u'ENSMUSG00000022025', u'ENSMUSG00000002985', u'ENSMUSG00000007613', u'ENSMUSG00000050953', u'ENSMUSG00000037621', u'ENSMUSG00000007655', u'ENSMUSG00000022018']), symbols=u'Apoe Atoh8 Cav1 Cav2 Cnmd Gja1 Ptprm Rgcc Tgfbr1 Thbs1 Xdh', symbol_set=set([u'Gja1', u'Tgfbr1', u'Apoe', 'Cnmd', u'Cav1', u'Thbs1', 'Rgcc', u'Ptprm', u'Xdh', u'Cav2', u'Atoh8']), geneids='ENSMUSG00000024066 ENSMUSG00000022018 ENSMUSG00000040152 ENSMUSG00000033278 ENSMUSG00000022025 ENSMUSG00000002985 ENSMUSG00000007613 ENSMUSG00000050953 ENSMUSG00000037621 ENSMUSG00000007655 ENSMUSG00000000058', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=2, D1='A', GO_name='negative regulation of endothelial cell proliferation'),
    Nt(p_uncorrected=5.434739893839826e-06, study_count=9, study_n=1397, namespace='biological_process', p_fdr_bh=0.0011933586106024233, study_items=set([u'ENSMUSG00000050335', u'ENSMUSG00000020715', u'ENSMUSG00000062078', u'ENSMUSG00000021127', u'ENSMUSG00000006498', u'ENSMUSG00000027763', u'ENSMUSG00000028821', u'ENSMUSG00000040613', u'ENSMUSG00000014776']), NS='BP', pop_items=set([u'ENSMUSG00000028180', u'ENSMUSG00000030216', u'ENSMUSG00000021645', u'ENSMUSG00000039148', u'ENSMUSG00000062604', u'ENSMUSG00000021716', u'ENSMUSG00000020262', u'ENSMUSG00000021713', u'ENSMUSG00000015165', u'ENSMUSG00000032621', u'ENSMUSG00000018379', u'ENSMUSG00000020863', u'ENSMUSG00000024604', u'ENSMUSG00000031683', u'ENSMUSG00000050335', u'ENSMUSG00000059005', u'ENSMUSG00000014980', u'ENSMUSG00000021494', u'ENSMUSG00000001767', u'ENSMUSG00000005506', u'ENSMUSG00000005682', u'ENSMUSG00000032423', u'ENSMUSG00000027176', u'ENSMUSG00000040767', u'ENSMUSG00000019470', u'ENSMUSG00000061479', u'ENSMUSG00000028820', u'ENSMUSG00000028821', u'ENSMUSG00000042167', u'ENSMUSG00000034120', u'ENSMUSG00000022774', u'ENSMUSG00000021413', u'ENSMUSG00000007670', u'ENSMUSG00000024287', u'ENSMUSG00000028330', u'ENSMUSG00000018974', u'ENSMUSG00000034544', u'ENSMUSG00000033712', u'ENSMUSG00000056305', u'ENSMUSG00000020180', u'ENSMUSG00000023932', u'ENSMUSG00000020273', u'ENSMUSG00000043702', u'ENSMUSG00000032940', u'ENSMUSG00000030204', u'ENSMUSG00000034931', u'ENSMUSG00000043962', u'ENSMUSG00000041781', u'ENSMUSG00000029279', u'ENSMUSG00000028134', u'ENSMUSG00000028137', u'ENSMUSG00000059708', u'ENSMUSG00000030056', u'ENSMUSG00000027498', u'ENSMUSG00000027014', u'ENSMUSG00000034724', u'ENSMUSG00000022160', u'ENSMUSG00000031189', u'ENSMUSG00000003660', u'ENSMUSG00000042502', u'ENSMUSG00000035125', u'ENSMUSG00000054679', u'ENSMUSG00000053453', u'ENSMUSG00000015656', u'ENSMUSG00000021810', u'ENSMUSG00000021111', u'ENSMUSG00000078765', u'ENSMUSG00000004865', u'ENSMUSG00000027404', u'ENSMUSG00000090553', u'ENSMUSG00000029538', u'ENSMUSG00000027905', u'ENSMUSG00000021127', u'ENSMUSG00000021681', u'ENSMUSG00000024384', u'ENSMUSG00000027951', u'ENSMUSG00000029439', u'ENSMUSG00000034022', u'ENSMUSG00000038446', u'ENSMUSG00000035597', u'ENSMUSG00000004642', u'ENSMUSG00000014776', u'ENSMUSG00000003119', u'ENSMUSG00000018446', u'ENSMUSG00000060121', u'ENSMUSG00000025134', u'ENSMUSG00000025047', u'ENSMUSG00000028882', u'ENSMUSG00000041319', u'ENSMUSG00000028639', u'ENSMUSG00000044847', u'ENSMUSG00000031370', u'ENSMUSG00000024097', u'ENSMUSG00000061136', u'ENSMUSG00000040383', u'ENSMUSG00000028382', u'ENSMUSG00000078676', u'ENSMUSG00000028809', u'ENSMUSG00000005687', u'ENSMUSG00000071172', u'ENSMUSG00000022858', u'ENSMUSG00000019432', u'ENSMUSG00000022019', u'ENSMUSG00000051177', u'ENSMUSG00000027881', u'ENSMUSG00000033222', u'ENSMUSG00000023087', u'ENSMUSG00000021134', u'ENSMUSG00000020409', u'ENSMUSG00000029427', u'ENSMUSG00000039218', u'ENSMUSG00000028676', u'ENSMUSG00000027433', u'ENSMUSG00000031256', u'ENSMUSG00000028790', u'ENSMUSG00000037070', u'ENSMUSG00000025024', u'ENSMUSG00000020994', u'ENSMUSG00000031157', u'ENSMUSG00000051695', u'ENSMUSG00000004096', u'ENSMUSG00000022983', u'ENSMUSG00000035585', u'ENSMUSG00000029227', u'ENSMUSG00000063808', u'ENSMUSG00000037262', u'ENSMUSG00000040621', u'ENSMUSG00000008373', u'ENSMUSG00000029701', u'ENSMUSG00000037475', u'ENSMUSG00000063800', u'ENSMUSG00000030779', u'ENSMUSG00000046201', u'ENSMUSG00000002477', u'ENSMUSG00000032297', u'ENSMUSG00000020485', u'ENSMUSG00000022332', u'ENSMUSG00000007050', u'ENSMUSG00000026035', u'ENSMUSG00000021039', u'ENSMUSG00000021500', u'ENSMUSG00000022023', u'ENSMUSG00000037149', u'ENSMUSG00000059208', u'ENSMUSG00000020715', u'ENSMUSG00000032580', u'ENSMUSG00000074088', u'ENSMUSG00000020719', u'ENSMUSG00000020850', u'ENSMUSG00000052144', u'ENSMUSG00000033760', u'ENSMUSG00000066800', u'ENSMUSG00000027620', u'ENSMUSG00000028651', u'ENSMUSG00000030512', u'ENSMUSG00000036779', u'ENSMUSG00000034681', u'ENSMUSG00000037361', u'ENSMUSG00000009076', u'ENSMUSG00000008658', u'ENSMUSG00000037275', u'ENSMUSG00000031311', u'ENSMUSG00000043639', u'ENSMUSG00000029625', u'ENSMUSG00000032469', u'ENSMUSG00000040720', u'ENSMUSG00000040824', u'ENSMUSG00000065990', u'ENSMUSG00000011306', u'ENSMUSG00000024234', u'ENSMUSG00000041459', u'ENSMUSG00000005469', u'ENSMUSG00000005150', u'ENSMUSG00000001158', u'ENSMUSG00000032078', u'ENSMUSG00000022139', u'ENSMUSG00000002107', u'ENSMUSG00000066148', u'ENSMUSG00000029290', u'ENSMUSG00000031134', u'ENSMUSG00000071645', u'ENSMUSG00000092607', u'ENSMUSG00000029402', u'ENSMUSG00000016921', u'ENSMUSG00000055760', u'ENSMUSG00000005481', u'ENSMUSG00000020464', u'ENSMUSG00000028274', u'ENSMUSG00000037197', u'ENSMUSG00000032040', u'ENSMUSG00000020783', u'ENSMUSG00000055531', u'ENSMUSG00000020781', u'ENSMUSG00000004980', u'ENSMUSG00000079043', u'ENSMUSG00000061360', u'ENSMUSG00000021546', u'ENSMUSG00000016018', u'ENSMUSG00000034274', u'ENSMUSG00000027593', u'ENSMUSG00000042650', u'ENSMUSG00000033565', u'ENSMUSG00000034820', u'ENSMUSG00000024735', u'ENSMUSG00000022961', u'ENSMUSG00000060373', u'ENSMUSG00000003435', u'ENSMUSG00000002455', u'ENSMUSG00000061028', u'ENSMUSG00000041777', u'ENSMUSG00000024007', u'ENSMUSG00000038406', u'ENSMUSG00000023007', u'ENSMUSG00000021650', u'ENSMUSG00000034575', u'ENSMUSG00000025872', u'ENSMUSG00000038611', u'ENSMUSG00000024268', u'ENSMUSG00000024019', u'ENSMUSG00000035851', u'ENSMUSG00000041297', u'ENSMUSG00000003527', u'ENSMUSG00000000838', u'ENSMUSG00000024949', u'ENSMUSG00000044155', u'ENSMUSG00000031754', u'ENSMUSG00000030224', u'ENSMUSG00000042079', u'ENSMUSG00000002524', u'ENSMUSG00000050188', u'ENSMUSG00000029647', u'ENSMUSG00000023118', u'ENSMUSG00000031723', u'ENSMUSG00000030435', u'ENSMUSG00000027763', u'ENSMUSG00000002625', u'ENSMUSG00000078348', u'ENSMUSG00000022635', u'ENSMUSG00000015748', u'ENSMUSG00000063919', u'ENSMUSG00000037296', u'ENSMUSG00000039630', u'ENSMUSG00000034889', u'ENSMUSG00000052551', u'ENSMUSG00000006498', u'ENSMUSG00000037958', u'ENSMUSG00000068856', u'ENSMUSG00000024400', u'ENSMUSG00000031792', u'ENSMUSG00000042389', u'ENSMUSG00000021431', u'ENSMUSG00000040613', u'ENSMUSG00000031848', u'ENSMUSG00000033732', u'ENSMUSG00000029038', u'ENSMUSG00000009535', u'ENSMUSG00000046441', u'ENSMUSG00000002129', u'ENSMUSG00000020018', u'ENSMUSG00000007850', u'ENSMUSG00000074102', u'ENSMUSG00000029817', u'ENSMUSG00000090115', u'ENSMUSG00000008333', u'ENSMUSG00000031590', u'ENSMUSG00000022283', u'ENSMUSG00000028911', u'ENSMUSG00000002052', u'ENSMUSG00000024095', u'ENSMUSG00000025586', u'ENSMUSG00000022194', u'ENSMUSG00000029404', u'ENSMUSG00000010608', u'ENSMUSG00000025982', u'ENSMUSG00000022119', u'ENSMUSG00000022185', u'ENSMUSG00000028902', u'ENSMUSG00000062078', u'ENSMUSG00000029345', u'ENSMUSG00000024491', u'ENSMUSG00000027998', u'ENSMUSG00000036054', u'ENSMUSG00000056962', u'ENSMUSG00000042109', u'ENSMUSG00000053536', u'ENSMUSG00000028609', u'ENSMUSG00000054309', u'ENSMUSG00000026058', u'ENSMUSG00000025576', u'ENSMUSG00000044221', u'ENSMUSG00000027079', u'ENSMUSG00000020929', u'ENSMUSG00000039449', u'ENSMUSG00000060475', u'ENSMUSG00000029169']), pop_n=13836, p_sm_bonferroni=0.08234174413156721, is_obsolete=False, GO='GO:0006397', name='mRNA processing', pop_count=295, alt_ids=[], level=6, depth=8, enrichment='p', Cluster='Late Increase', geneid_set=set([u'ENSMUSG00000050335', u'ENSMUSG00000020715', u'ENSMUSG00000062078', u'ENSMUSG00000021127', u'ENSMUSG00000006498', u'ENSMUSG00000027763', u'ENSMUSG00000028821', u'ENSMUSG00000040613', u'ENSMUSG00000014776']), symbols=u'Apobec1 Ern1 Lgals3 Mbnl1 Nol3 Ptbp1 Qk Syf2 Zfp36l1', symbol_set=set([u'Syf2', u'Zfp36l1', u'Apobec1', u'Nol3', u'Lgals3', u'Mbnl1', u'Ptbp1', u'Qk', u'Ern1']), geneids='ENSMUSG00000050335 ENSMUSG00000020715 ENSMUSG00000027763 ENSMUSG00000021127 ENSMUSG00000006498 ENSMUSG00000062078 ENSMUSG00000028821 ENSMUSG00000040613 ENSMUSG00000014776', format_txt=1, hdr_idx=1, is_hdrgo=True, is_usrgo=True, hdr1usr01='**', dcnt=18, D1='BD', GO_name='mRNA processing'),
]
