"""GOATOOLS GOEA on 2015 Gjoneska data using go-basic.obo: fmt(1.2) rel(2017-01-12) 47,943 GO Terms"""

# Created: 2017-01-13
import collections as cx

nt_fields = [
    "p_uncorrected",
    "study_count",
    "study_n",
    "namespace",
    "p_fdr_bh",
    "study_items",
    "NS",
    "pop_items",
    "pop_n",
    "p_sm_bonferroni",
    "is_obsolete",
    "GO",
    "name",
    "pop_count",
    "alt_ids",
    "level",
    "depth",
    "enrichment",
    "Cluster",
    "geneid_set",
    "symbols",
    "symbol_set",
    "geneids",
    "format_txt",
    "hdr_idx",
    "is_hdrgo",
    "is_usrgo",
    "hdr1usr01",
    "dcnt",
    "D1",
    "GO_name",
]

Nt = cx.namedtuple("Nt", " ".join(nt_fields))

# 94 items
nts = [
    Nt(p_uncorrected=0.0001407420189929343, study_count=16, study_n=1139, namespace='biological_process', p_fdr_bh=0.01791917924169704, study_items=set([u'ENSMUSG00000024163', u'ENSMUSG00000026494', u'ENSMUSG00000024479', u'ENSMUSG00000026764', u'ENSMUSG00000020848', u'ENSMUSG00000026585', u'ENSMUSG00000027799', u'ENSMUSG00000031729', u'ENSMUSG00000074657', u'ENSMUSG00000002496', u'ENSMUSG00000020598', u'ENSMUSG00000005338', u'ENSMUSG00000034926', u'ENSMUSG00000026062', u'ENSMUSG00000059003', u'ENSMUSG00000022428']), NS='BP', pop_items=set([u'ENSMUSG00000026494', u'ENSMUSG00000029512', u'ENSMUSG00000021294', u'ENSMUSG00000019794', u'ENSMUSG00000029518', u'ENSMUSG00000031755', u'ENSMUSG00000021245', u'ENSMUSG00000047804', u'ENSMUSG00000031775', u'ENSMUSG00000022508', u'ENSMUSG00000034926', u'ENSMUSG00000022089', u'ENSMUSG00000059552', u'ENSMUSG00000020372', u'ENSMUSG00000028763', u'ENSMUSG00000059003', u'ENSMUSG00000020848', u'ENSMUSG00000037325', u'ENSMUSG00000027284', u'ENSMUSG00000044345', u'ENSMUSG00000040040', u'ENSMUSG00000026024', u'ENSMUSG00000022428', u'ENSMUSG00000024194', u'ENSMUSG00000026764', u'ENSMUSG00000006930', u'ENSMUSG00000043051', u'ENSMUSG00000031729', u'ENSMUSG00000000531', u'ENSMUSG00000035112', u'ENSMUSG00000020598', u'ENSMUSG00000022770', u'ENSMUSG00000004846', u'ENSMUSG00000027375', u'ENSMUSG00000027253', u'ENSMUSG00000024163', u'ENSMUSG00000031393', u'ENSMUSG00000020705', u'ENSMUSG00000021278', u'ENSMUSG00000032826', u'ENSMUSG00000044037', u'ENSMUSG00000026585', u'ENSMUSG00000027799', u'ENSMUSG00000024382', u'ENSMUSG00000038241', u'ENSMUSG00000039166', u'ENSMUSG00000006464', u'ENSMUSG00000039662', u'ENSMUSG00000023959', u'ENSMUSG00000010376', u'ENSMUSG00000040860', u'ENSMUSG00000020734', u'ENSMUSG00000057113', u'ENSMUSG00000024479', u'ENSMUSG00000002496', u'ENSMUSG00000007655', u'ENSMUSG00000032259', u'ENSMUSG00000028080', u'ENSMUSG00000025235', u'ENSMUSG00000034813', u'ENSMUSG00000091636', u'ENSMUSG00000026062', u'ENSMUSG00000035863', u'ENSMUSG00000074657', u'ENSMUSG00000028649', u'ENSMUSG00000005338', u'ENSMUSG00000037706', u'ENSMUSG00000026039', u'ENSMUSG00000006740', u'ENSMUSG00000026213']), pop_n=13836, p_sm_bonferroni=1.0, is_obsolete=False, GO='GO:0008104', name='protein localization', pop_count=70, alt_ids=[], level=3, depth=3, enrichment='e', Cluster='Late Decrease', geneid_set=set([u'ENSMUSG00000024163', u'ENSMUSG00000026494', u'ENSMUSG00000026764', u'ENSMUSG00000026585', u'ENSMUSG00000027799', u'ENSMUSG00000034926', u'ENSMUSG00000059003', u'ENSMUSG00000020848', u'ENSMUSG00000024479', u'ENSMUSG00000002496', u'ENSMUSG00000022428', u'ENSMUSG00000031729', u'ENSMUSG00000074657', u'ENSMUSG00000020598', u'ENSMUSG00000005338', u'ENSMUSG00000026062']), symbols=u'Cadm3 Cby1 Dhcr24 Doc2b Grin2a Ist1 Kif26b Kif5a Kif5c Kifap3 Mal2 Mapk8ip3 Nbea Nrcam Slc9a2 Tsc2', symbol_set=set([u'Doc2b', u'Slc9a2', u'Nrcam', u'Kif5a', u'Kif5c', u'Mal2', u'Kif26b', u'Cadm3', 'Ist1', u'Nbea', u'Grin2a', u'Kifap3', u'Mapk8ip3', u'Tsc2', u'Cby1', u'Dhcr24']), geneids='ENSMUSG00000024163 ENSMUSG00000002496 ENSMUSG00000026494 ENSMUSG00000020848 ENSMUSG00000026585 ENSMUSG00000026764 ENSMUSG00000027799 ENSMUSG00000031729 ENSMUSG00000074657 ENSMUSG00000034926 ENSMUSG00000020598 ENSMUSG00000005338 ENSMUSG00000024479 ENSMUSG00000026062 ENSMUSG00000059003 ENSMUSG00000022428', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=441, D1='G', GO_name='protein localization'),
    Nt(p_uncorrected=1.2665686637593492e-06, study_count=12, study_n=1139, namespace='biological_process', p_fdr_bh=0.00029984034100965465, study_items=set([u'ENSMUSG00000070570', u'ENSMUSG00000045903', u'ENSMUSG00000028222', u'ENSMUSG00000024083', u'ENSMUSG00000052087', u'ENSMUSG00000038128', u'ENSMUSG00000038738', u'ENSMUSG00000027273', u'ENSMUSG00000020524', u'ENSMUSG00000062202', u'ENSMUSG00000038418', u'ENSMUSG00000013787']), NS='BP', pop_items=set([u'ENSMUSG00000028222', u'ENSMUSG00000020431', u'ENSMUSG00000005949', u'ENSMUSG00000039652', u'ENSMUSG00000029053', u'ENSMUSG00000028991', u'ENSMUSG00000013787', u'ENSMUSG00000042453', u'ENSMUSG00000027273', u'ENSMUSG00000015605', u'ENSMUSG00000061762', u'ENSMUSG00000031393', u'ENSMUSG00000062202', u'ENSMUSG00000038128', u'ENSMUSG00000038738', u'ENSMUSG00000026080', u'ENSMUSG00000026959', u'ENSMUSG00000020524', u'ENSMUSG00000055254', u'ENSMUSG00000038418', u'ENSMUSG00000000184', u'ENSMUSG00000070570', u'ENSMUSG00000022376', u'ENSMUSG00000045903', u'ENSMUSG00000005102', u'ENSMUSG00000024083', u'ENSMUSG00000032259', u'ENSMUSG00000019970', u'ENSMUSG00000052087']), pop_n=13836, p_sm_bonferroni=0.019189781824617898, is_obsolete=False, GO='GO:0007616', name='long-term memory', pop_count=29, alt_ids=[], level=5, depth=7, enrichment='e', Cluster='Late Decrease', geneid_set=set([u'ENSMUSG00000070570', u'ENSMUSG00000020524', u'ENSMUSG00000028222', u'ENSMUSG00000024083', u'ENSMUSG00000052087', u'ENSMUSG00000038128', u'ENSMUSG00000038738', u'ENSMUSG00000027273', u'ENSMUSG00000045903', u'ENSMUSG00000062202', u'ENSMUSG00000038418', u'ENSMUSG00000013787']), symbols=u'Btbd9 Calb1 Camk4 Egr1 Ehmt2 Gria1 Npas4 Pja2 Rgs14 Shank1 Slc17a7 Snap25', symbol_set=set([u'Snap25', u'Rgs14', u'Slc17a7', u'Egr1', u'Gria1', u'Camk4', u'Calb1', u'Ehmt2', u'Btbd9', u'Pja2', u'Npas4', u'Shank1']), geneids='ENSMUSG00000070570 ENSMUSG00000045903 ENSMUSG00000028222 ENSMUSG00000024083 ENSMUSG00000013787 ENSMUSG00000038128 ENSMUSG00000038738 ENSMUSG00000027273 ENSMUSG00000062202 ENSMUSG00000020524 ENSMUSG00000052087 ENSMUSG00000038418', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=0, D1='CJN', GO_name='long-term memory'),
    Nt(p_uncorrected=6.003636102572195e-07, study_count=11, study_n=1139, namespace='biological_process', p_fdr_bh=0.00015958086068433566, study_items=set([u'ENSMUSG00000057182', u'ENSMUSG00000069601', u'ENSMUSG00000061576', u'ENSMUSG00000030525', u'ENSMUSG00000054934', u'ENSMUSG00000023033', u'ENSMUSG00000060882', u'ENSMUSG00000022416', u'ENSMUSG00000075318', u'ENSMUSG00000020524', u'ENSMUSG00000063142']), NS='BP', pop_items=set([u'ENSMUSG00000061576', u'ENSMUSG00000021478', u'ENSMUSG00000054934', u'ENSMUSG00000030525', u'ENSMUSG00000068696', u'ENSMUSG00000040724', u'ENSMUSG00000023033', u'ENSMUSG00000075316', u'ENSMUSG00000037610', u'ENSMUSG00000075318', u'ENSMUSG00000063142', u'ENSMUSG00000064329', u'ENSMUSG00000069601', u'ENSMUSG00000047976', u'ENSMUSG00000029470', u'ENSMUSG00000022416', u'ENSMUSG00000020524', u'ENSMUSG00000034810', u'ENSMUSG00000057182', u'ENSMUSG00000030739', u'ENSMUSG00000056073', u'ENSMUSG00000032511', u'ENSMUSG00000060882']), pop_n=13836, p_sm_bonferroni=0.009096109059007132, is_obsolete=False, GO='GO:0019228', name='neuronal action potential', pop_count=23, alt_ids=[], level=5, depth=5, enrichment='e', Cluster='Late Decrease', geneid_set=set([u'ENSMUSG00000057182', u'ENSMUSG00000069601', u'ENSMUSG00000061576', u'ENSMUSG00000022416', u'ENSMUSG00000054934', u'ENSMUSG00000023033', u'ENSMUSG00000063142', u'ENSMUSG00000030525', u'ENSMUSG00000075318', u'ENSMUSG00000020524', u'ENSMUSG00000060882']), symbols=u'Ank3 Cacna1i Chrna7 Dpp6 Gria1 Kcnd2 Kcnma1 Kcnmb4 Scn2a Scn3a Scn8a', symbol_set=set([u'Cacna1i', u'Kcnd2', u'Kcnmb4', u'Gria1', u'Scn8a', u'Kcnma1', 'Scn2a', u'Ank3', u'Chrna7', u'Scn3a', u'Dpp6']), geneids='ENSMUSG00000057182 ENSMUSG00000069601 ENSMUSG00000061576 ENSMUSG00000022416 ENSMUSG00000054934 ENSMUSG00000023033 ENSMUSG00000063142 ENSMUSG00000030525 ENSMUSG00000075318 ENSMUSG00000020524 ENSMUSG00000060882', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=0, D1='A', GO_name='neuronal action potential'),
    Nt(p_uncorrected=5.051105557716913e-06, study_count=18, study_n=1139, namespace='biological_process', p_fdr_bh=0.0009938870169476485, study_items=set([u'ENSMUSG00000037541', u'ENSMUSG00000030209', u'ENSMUSG00000050321', u'ENSMUSG00000031137', u'ENSMUSG00000061751', u'ENSMUSG00000021701', u'ENSMUSG00000026768', u'ENSMUSG00000052135', u'ENSMUSG00000063434', u'ENSMUSG00000025318', u'ENSMUSG00000030376', u'ENSMUSG00000003575', u'ENSMUSG00000030525', u'ENSMUSG00000074923', u'ENSMUSG00000024883', u'ENSMUSG00000018634', u'ENSMUSG00000022623', u'ENSMUSG00000059003']), NS='BP', pop_items=set([u'ENSMUSG00000048583', u'ENSMUSG00000013662', u'ENSMUSG00000013663', u'ENSMUSG00000032487', u'ENSMUSG00000039519', u'ENSMUSG00000020091', u'ENSMUSG00000027950', u'ENSMUSG00000037996', u'ENSMUSG00000025958', u'ENSMUSG00000021478', u'ENSMUSG00000030376', u'ENSMUSG00000042644', u'ENSMUSG00000030525', u'ENSMUSG00000006307', u'ENSMUSG00000059003', u'ENSMUSG00000024798', u'ENSMUSG00000022623', u'ENSMUSG00000037541', u'ENSMUSG00000000555', u'ENSMUSG00000010609', u'ENSMUSG00000048616', u'ENSMUSG00000040907', u'ENSMUSG00000056755', u'ENSMUSG00000025888', u'ENSMUSG00000047250', u'ENSMUSG00000024883', u'ENSMUSG00000034997', u'ENSMUSG00000025318', u'ENSMUSG00000019969', u'ENSMUSG00000001507', u'ENSMUSG00000018634', u'ENSMUSG00000024742', u'ENSMUSG00000051177', u'ENSMUSG00000020053', u'ENSMUSG00000031393', u'ENSMUSG00000030209', u'ENSMUSG00000031137', u'ENSMUSG00000061751', u'ENSMUSG00000018411', u'ENSMUSG00000021701', u'ENSMUSG00000026768', u'ENSMUSG00000039059', u'ENSMUSG00000063434', u'ENSMUSG00000028541', u'ENSMUSG00000037058', u'ENSMUSG00000064023', u'ENSMUSG00000039913', u'ENSMUSG00000026959', u'ENSMUSG00000074923', u'ENSMUSG00000022681', u'ENSMUSG00000027365', u'ENSMUSG00000050321', u'ENSMUSG00000024261', u'ENSMUSG00000035283', u'ENSMUSG00000035722', u'ENSMUSG00000053004', u'ENSMUSG00000034987', u'ENSMUSG00000033208', u'ENSMUSG00000027859', u'ENSMUSG00000052336', u'ENSMUSG00000079055', u'ENSMUSG00000003575', u'ENSMUSG00000023017', u'ENSMUSG00000044288', u'ENSMUSG00000049112', u'ENSMUSG00000052135', u'ENSMUSG00000042632']), pop_n=13836, p_sm_bonferroni=0.07652930030496895, is_obsolete=False, GO='GO:0007613', name='memory', pop_count=67, alt_ids=[], level=4, depth=6, enrichment='e', Cluster='Late Decrease', geneid_set=set([u'ENSMUSG00000059003', u'ENSMUSG00000030209', u'ENSMUSG00000031137', u'ENSMUSG00000061751', u'ENSMUSG00000021701', u'ENSMUSG00000026768', u'ENSMUSG00000030376', u'ENSMUSG00000030525', u'ENSMUSG00000024883', u'ENSMUSG00000063434', u'ENSMUSG00000074923', u'ENSMUSG00000037541', u'ENSMUSG00000050321', u'ENSMUSG00000018634', u'ENSMUSG00000025318', u'ENSMUSG00000022623', u'ENSMUSG00000003575', u'ENSMUSG00000052135']), symbols=u'Chrna7 Crhr1 Crtc1 Fgf13 Foxo6 Grin2a Grin2b Itga8 Jph3 Kalrn Neto1 Pak6 Plk2 Rin1 Shank2 Shank3 Slc8a2 Sorcs3', symbol_set=set([u'Itga8', u'Crtc1', u'Sorcs3', u'Jph3', u'Kalrn', u'Plk2', u'Rin1', u'Shank2', u'Grin2b', u'Neto1', u'Grin2a', u'Foxo6', u'Fgf13', u'Chrna7', u'Slc8a2', u'Shank3', u'Pak6', u'Crhr1']), geneids='ENSMUSG00000037541 ENSMUSG00000030209 ENSMUSG00000050321 ENSMUSG00000031137 ENSMUSG00000061751 ENSMUSG00000021701 ENSMUSG00000026768 ENSMUSG00000052135 ENSMUSG00000063434 ENSMUSG00000025318 ENSMUSG00000030376 ENSMUSG00000003575 ENSMUSG00000030525 ENSMUSG00000074923 ENSMUSG00000024883 ENSMUSG00000018634 ENSMUSG00000022623 ENSMUSG00000059003', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=4, D1='CJN', GO_name='memory'),
    Nt(p_uncorrected='', study_count='', study_n='', namespace='', p_fdr_bh='', study_items='', NS='BP', pop_items='', pop_n='', p_sm_bonferroni='', is_obsolete='', GO='GO:0007610', name='', pop_count='', alt_ids='', level=1, depth=1, enrichment='', Cluster='', geneid_set='', symbols='', symbol_set='', geneids='', format_txt=1, hdr_idx=1, is_hdrgo=True, is_usrgo=False, hdr1usr01='*', dcnt=220, D1='N', GO_name='behavior'),
    Nt(p_uncorrected=8.901635446472504e-10, study_count=97, study_n=1139, namespace='biological_process', p_fdr_bh=5.187256871134804e-07, study_items=set([u'ENSMUSG00000053199', u'ENSMUSG00000047904', u'ENSMUSG00000020196', u'ENSMUSG00000000861', u'ENSMUSG00000029055', u'ENSMUSG00000017631', u'ENSMUSG00000036882', u'ENSMUSG00000048251', u'ENSMUSG00000040009', u'ENSMUSG00000058230', u'ENSMUSG00000002489', u'ENSMUSG00000022176', u'ENSMUSG00000013033', u'ENSMUSG00000031906', u'ENSMUSG00000023886', u'ENSMUSG00000052298', u'ENSMUSG00000021559', u'ENSMUSG00000048078', u'ENSMUSG00000038128', u'ENSMUSG00000039585', u'ENSMUSG00000029602', u'ENSMUSG00000002496', u'ENSMUSG00000021057', u'ENSMUSG00000040563', u'ENSMUSG00000059456', u'ENSMUSG00000023473', u'ENSMUSG00000019699', u'ENSMUSG00000062232', u'ENSMUSG00000030257', u'ENSMUSG00000059173', u'ENSMUSG00000028004', u'ENSMUSG00000028005', u'ENSMUSG00000044667', u'ENSMUSG00000026113', u'ENSMUSG00000019828', u'ENSMUSG00000037014', u'ENSMUSG00000032773', u'ENSMUSG00000009681', u'ENSMUSG00000023915', u'ENSMUSG00000044067', u'ENSMUSG00000022637', u'ENSMUSG00000021549', u'ENSMUSG00000026322', u'ENSMUSG00000024462', u'ENSMUSG00000056486', u'ENSMUSG00000044933', u'ENSMUSG00000021373', u'ENSMUSG00000028782', u'ENSMUSG00000030525', u'ENSMUSG00000027584', u'ENSMUSG00000071658', u'ENSMUSG00000046093', u'ENSMUSG00000027335', u'ENSMUSG00000032177', u'ENSMUSG00000018634', u'ENSMUSG00000048216', u'ENSMUSG00000034209', u'ENSMUSG00000030084', u'ENSMUSG00000021721', u'ENSMUSG00000058297', u'ENSMUSG00000063358', u'ENSMUSG00000033697', u'ENSMUSG00000067629', u'ENSMUSG00000040836', u'ENSMUSG00000024524', u'ENSMUSG00000031834', u'ENSMUSG00000024639', u'ENSMUSG00000047842', u'ENSMUSG00000025876', u'ENSMUSG00000023192', u'ENSMUSG00000055723', u'ENSMUSG00000049336', u'ENSMUSG00000015501', u'ENSMUSG00000023868', u'ENSMUSG00000069601', u'ENSMUSG00000073557', u'ENSMUSG00000039809', u'ENSMUSG00000039087', u'ENSMUSG00000050600', u'ENSMUSG00000052087', u'ENSMUSG00000029765', u'ENSMUSG00000024883', u'ENSMUSG00000048240', u'ENSMUSG00000040276', u'ENSMUSG00000026482', u'ENSMUSG00000021676', u'ENSMUSG00000045318', u'ENSMUSG00000049583', u'ENSMUSG00000024122', u'ENSMUSG00000068037', u'ENSMUSG00000068740', u'ENSMUSG00000033342', u'ENSMUSG00000036591', u'ENSMUSG00000023353', u'ENSMUSG00000016150', u'ENSMUSG00000043004', u'ENSMUSG00000050132']), NS='BP', pop_items=set([u'ENSMUSG00000053199', u'ENSMUSG00000029513', u'ENSMUSG00000029512', u'ENSMUSG00000028184', u'ENSMUSG00000047904', u'ENSMUSG00000003974', u'ENSMUSG00000020196', u'ENSMUSG00000042190', u'ENSMUSG00000056679', u'ENSMUSG00000050558', u'ENSMUSG00000038894', u'ENSMUSG00000045005', u'ENSMUSG00000027995', u'ENSMUSG00000038390', u'ENSMUSG00000052229', u'ENSMUSG00000005057', u'ENSMUSG00000027669', u'ENSMUSG00000035133', u'ENSMUSG00000013033', u'ENSMUSG00000062312', u'ENSMUSG00000026167', u'ENSMUSG00000038587', u'ENSMUSG00000031906', u'ENSMUSG00000030595', u'ENSMUSG00000023886', u'ENSMUSG00000020611', u'ENSMUSG00000055471', u'ENSMUSG00000048779', u'ENSMUSG00000022391', u'ENSMUSG00000049892', u'ENSMUSG00000063506', u'ENSMUSG00000021408', u'ENSMUSG00000040495', u'ENSMUSG00000031887', u'ENSMUSG00000004677', u'ENSMUSG00000042228', u'ENSMUSG00000002496', u'ENSMUSG00000052821', u'ENSMUSG00000042429', u'ENSMUSG00000040407', u'ENSMUSG00000032413', u'ENSMUSG00000026424', u'ENSMUSG00000026425', u'ENSMUSG00000028634', u'ENSMUSG00000026942', u'ENSMUSG00000018209', u'ENSMUSG00000044667', u'ENSMUSG00000058715', u'ENSMUSG00000056529', u'ENSMUSG00000043895', u'ENSMUSG00000033389', u'ENSMUSG00000044288', u'ENSMUSG00000021886', u'ENSMUSG00000019828', u'ENSMUSG00000032562', u'ENSMUSG00000001173', u'ENSMUSG00000047123', u'ENSMUSG00000070366', u'ENSMUSG00000021136', u'ENSMUSG00000009681', u'ENSMUSG00000022122', u'ENSMUSG00000035268', u'ENSMUSG00000038349', u'ENSMUSG00000024122', u'ENSMUSG00000044067', u'ENSMUSG00000036402', u'ENSMUSG00000024639', u'ENSMUSG00000028656', u'ENSMUSG00000028894', u'ENSMUSG00000036246', u'ENSMUSG00000024610', u'ENSMUSG00000036362', u'ENSMUSG00000055980', u'ENSMUSG00000007613', u'ENSMUSG00000036856', u'ENSMUSG00000027247', u'ENSMUSG00000035615', u'ENSMUSG00000037148', u'ENSMUSG00000024998', u'ENSMUSG00000033446', u'ENSMUSG00000039106', u'ENSMUSG00000020716', u'ENSMUSG00000061393', u'ENSMUSG00000055723', u'ENSMUSG00000024830', u'ENSMUSG00000025154', u'ENSMUSG00000046793', u'ENSMUSG00000027584', u'ENSMUSG00000020919', u'ENSMUSG00000036564', u'ENSMUSG00000000538', u'ENSMUSG00000045613', u'ENSMUSG00000000532', u'ENSMUSG00000045967', u'ENSMUSG00000000530', u'ENSMUSG00000000531', u'ENSMUSG00000046093', u'ENSMUSG00000030494', u'ENSMUSG00000034997', u'ENSMUSG00000027335', u'ENSMUSG00000029778', u'ENSMUSG00000028978', u'ENSMUSG00000027339', u'ENSMUSG00000018634', u'ENSMUSG00000048216', u'ENSMUSG00000049295', u'ENSMUSG00000030084', u'ENSMUSG00000021721', u'ENSMUSG00000063358', u'ENSMUSG00000041907', u'ENSMUSG00000030536', u'ENSMUSG00000044562', u'ENSMUSG00000004633', u'ENSMUSG00000031543', u'ENSMUSG00000000441', u'ENSMUSG00000005125', u'ENSMUSG00000031932', u'ENSMUSG00000040836', u'ENSMUSG00000026113', u'ENSMUSG00000045867', u'ENSMUSG00000028080', u'ENSMUSG00000050953', u'ENSMUSG00000031834', u'ENSMUSG00000011171', u'ENSMUSG00000025876', u'ENSMUSG00000046961', u'ENSMUSG00000021366', u'ENSMUSG00000045382', u'ENSMUSG00000052920', u'ENSMUSG00000015501', u'ENSMUSG00000023755', u'ENSMUSG00000031616', u'ENSMUSG00000068696', u'ENSMUSG00000039087', u'ENSMUSG00000023055', u'ENSMUSG00000049532', u'ENSMUSG00000033597', u'ENSMUSG00000032528', u'ENSMUSG00000003228', u'ENSMUSG00000027577', u'ENSMUSG00000048078', u'ENSMUSG00000031111', u'ENSMUSG00000045318', u'ENSMUSG00000024789', u'ENSMUSG00000025584', u'ENSMUSG00000024787', u'ENSMUSG00000044149', u'ENSMUSG00000040061', u'ENSMUSG00000033342', u'ENSMUSG00000049744', u'ENSMUSG00000022580', u'ENSMUSG00000050132', u'ENSMUSG00000020099', u'ENSMUSG00000042594', u'ENSMUSG00000045502', u'ENSMUSG00000048251', u'ENSMUSG00000048865', u'ENSMUSG00000021669', u'ENSMUSG00000024974', u'ENSMUSG00000028108', u'ENSMUSG00000025358', u'ENSMUSG00000023800', u'ENSMUSG00000030766', u'ENSMUSG00000001761', u'ENSMUSG00000001768', u'ENSMUSG00000037523', u'ENSMUSG00000028583', u'ENSMUSG00000021109', u'ENSMUSG00000050783', u'ENSMUSG00000052539', u'ENSMUSG00000060477', u'ENSMUSG00000020591', u'ENSMUSG00000039031', u'ENSMUSG00000032714', u'ENSMUSG00000032492', u'ENSMUSG00000034930', u'ENSMUSG00000049929', u'ENSMUSG00000061950', u'ENSMUSG00000031570', u'ENSMUSG00000000567', u'ENSMUSG00000035283', u'ENSMUSG00000026786', u'ENSMUSG00000008859', u'ENSMUSG00000035431', u'ENSMUSG00000040563', u'ENSMUSG00000050199', u'ENSMUSG00000023473', u'ENSMUSG00000002413', u'ENSMUSG00000002147', u'ENSMUSG00000041468', u'ENSMUSG00000040016', u'ENSMUSG00000062232', u'ENSMUSG00000031486', u'ENSMUSG00000027950', u'ENSMUSG00000030272', u'ENSMUSG00000021478', u'ENSMUSG00000059173', u'ENSMUSG00000068798', u'ENSMUSG00000051043', u'ENSMUSG00000031714', u'ENSMUSG00000044456', u'ENSMUSG00000041417', u'ENSMUSG00000023015', u'ENSMUSG00000040146', u'ENSMUSG00000019907', u'ENSMUSG00000038760', u'ENSMUSG00000018593', u'ENSMUSG00000026430', u'ENSMUSG00000040029', u'ENSMUSG00000021772', u'ENSMUSG00000031392', u'ENSMUSG00000031398', u'ENSMUSG00000042804', u'ENSMUSG00000070939', u'ENSMUSG00000051212', u'ENSMUSG00000044674', u'ENSMUSG00000022637', u'ENSMUSG00000029146', u'ENSMUSG00000019889', u'ENSMUSG00000032470', u'ENSMUSG00000053164', u'ENSMUSG00000026322', u'ENSMUSG00000053004', u'ENSMUSG00000024182', u'ENSMUSG00000024451', u'ENSMUSG00000029816', u'ENSMUSG00000037872', u'ENSMUSG00000079227', u'ENSMUSG00000032766', u'ENSMUSG00000010660', u'ENSMUSG00000025795', u'ENSMUSG00000052142', u'ENSMUSG00000029713', u'ENSMUSG00000028782', u'ENSMUSG00000010067', u'ENSMUSG00000057614', u'ENSMUSG00000015396', u'ENSMUSG00000062190', u'ENSMUSG00000057722', u'ENSMUSG00000021549', u'ENSMUSG00000047259', u'ENSMUSG00000033278', u'ENSMUSG00000024620', u'ENSMUSG00000024235', u'ENSMUSG00000025225', u'ENSMUSG00000001729', u'ENSMUSG00000050663', u'ENSMUSG00000034209', u'ENSMUSG00000076432', u'ENSMUSG00000059588', u'ENSMUSG00000029765', u'ENSMUSG00000033450', u'ENSMUSG00000036501', u'ENSMUSG00000033697', u'ENSMUSG00000067629', u'ENSMUSG00000059456', u'ENSMUSG00000027223', u'ENSMUSG00000024524', u'ENSMUSG00000034471', u'ENSMUSG00000034472', u'ENSMUSG00000004043', u'ENSMUSG00000004040', u'ENSMUSG00000023192', u'ENSMUSG00000020176', u'ENSMUSG00000008734', u'ENSMUSG00000062585', u'ENSMUSG00000016664', u'ENSMUSG00000056755', u'ENSMUSG00000073557', u'ENSMUSG00000028284', u'ENSMUSG00000050534', u'ENSMUSG00000027765', u'ENSMUSG00000041354', u'ENSMUSG00000004730', u'ENSMUSG00000026069', u'ENSMUSG00000031842', u'ENSMUSG00000026104', u'ENSMUSG00000039005', u'ENSMUSG00000045092', u'ENSMUSG00000030222', u'ENSMUSG00000069601', u'ENSMUSG00000028214', u'ENSMUSG00000024387', u'ENSMUSG00000021277', u'ENSMUSG00000030047', u'ENSMUSG00000030341', u'ENSMUSG00000031216', u'ENSMUSG00000031214', u'ENSMUSG00000021373', u'ENSMUSG00000068036', u'ENSMUSG00000031748', u'ENSMUSG00000004451', u'ENSMUSG00000029064', u'ENSMUSG00000056055', u'ENSMUSG00000049907', u'ENSMUSG00000026566', u'ENSMUSG00000044827', u'ENSMUSG00000078624', u'ENSMUSG00000027297', u'ENSMUSG00000021936', u'ENSMUSG00000043004', u'ENSMUSG00000007989', u'ENSMUSG00000045322', u'ENSMUSG00000049148', u'ENSMUSG00000024798', u'ENSMUSG00000020516', u'ENSMUSG00000026888', u'ENSMUSG00000074785', u'ENSMUSG00000026883', u'ENSMUSG00000029101', u'ENSMUSG00000024462', u'ENSMUSG00000002885', u'ENSMUSG00000036606', u'ENSMUSG00000025507', u'ENSMUSG00000039358', u'ENSMUSG00000043670', u'ENSMUSG00000041075', u'ENSMUSG00000050029', u'ENSMUSG00000052298', u'ENSMUSG00000021699', u'ENSMUSG00000041380', u'ENSMUSG00000032826', u'ENSMUSG00000034009', u'ENSMUSG00000004952', u'ENSMUSG00000058396', u'ENSMUSG00000015355', u'ENSMUSG00000028136', u'ENSMUSG00000024960', u'ENSMUSG00000059013', u'ENSMUSG00000022489', u'ENSMUSG00000041225', u'ENSMUSG00000021057', u'ENSMUSG00000021051', u'ENSMUSG00000034330', u'ENSMUSG00000016028', u'ENSMUSG00000052056', u'ENSMUSG00000004591', u'ENSMUSG00000036437', u'ENSMUSG00000019699', u'ENSMUSG00000029430', u'ENSMUSG00000037999', u'ENSMUSG00000037992', u'ENSMUSG00000025139', u'ENSMUSG00000021466', u'ENSMUSG00000028004', u'ENSMUSG00000028005', u'ENSMUSG00000031561', u'ENSMUSG00000052681', u'ENSMUSG00000049807', u'ENSMUSG00000037014', u'ENSMUSG00000028522', u'ENSMUSG00000037010', u'ENSMUSG00000025739', u'ENSMUSG00000035835', u'ENSMUSG00000000001', u'ENSMUSG00000045730', u'ENSMUSG00000040653', u'ENSMUSG00000040229', u'ENSMUSG00000018500', u'ENSMUSG00000032641', u'ENSMUSG00000040552', u'ENSMUSG00000018909', u'ENSMUSG00000051177', u'ENSMUSG00000062209', u'ENSMUSG00000046722', u'ENSMUSG00000030265', u'ENSMUSG00000024109', u'ENSMUSG00000064325', u'ENSMUSG00000063446', u'ENSMUSG00000044583', u'ENSMUSG00000042249', u'ENSMUSG00000004798', u'ENSMUSG00000028172', u'ENSMUSG00000030545', u'ENSMUSG00000052372', u'ENSMUSG00000032360', u'ENSMUSG00000040133', u'ENSMUSG00000000149', u'ENSMUSG00000040033', u'ENSMUSG00000002489', u'ENSMUSG00000020122', u'ENSMUSG00000020121', u'ENSMUSG00000022148', u'ENSMUSG00000016128', u'ENSMUSG00000063234', u'ENSMUSG00000034165', u'ENSMUSG00000031385', u'ENSMUSG00000030629', u'ENSMUSG00000000732', u'ENSMUSG00000021303', u'ENSMUSG00000029090', u'ENSMUSG00000031639', u'ENSMUSG00000021994', u'ENSMUSG00000019235', u'ENSMUSG00000002910', u'ENSMUSG00000039904', u'ENSMUSG00000032508', u'ENSMUSG00000004558', u'ENSMUSG00000053113', u'ENSMUSG00000047415', u'ENSMUSG00000049791', u'ENSMUSG00000037846', u'ENSMUSG00000022329', u'ENSMUSG00000063065', u'ENSMUSG00000056222', u'ENSMUSG00000021067', u'ENSMUSG00000038205', u'ENSMUSG00000020541', u'ENSMUSG00000058297', u'ENSMUSG00000043398', u'ENSMUSG00000050288', u'ENSMUSG00000052151', u'ENSMUSG00000022514', u'ENSMUSG00000074886', u'ENSMUSG00000089872', u'ENSMUSG00000022799', u'ENSMUSG00000033569', u'ENSMUSG00000025499', u'ENSMUSG00000038607', u'ENSMUSG00000037605', u'ENSMUSG00000006728', u'ENSMUSG00000049112', u'ENSMUSG00000036834', u'ENSMUSG00000069170', u'ENSMUSG00000032911', u'ENSMUSG00000039167', u'ENSMUSG00000044014', u'ENSMUSG00000058230', u'ENSMUSG00000049336', u'ENSMUSG00000016933', u'ENSMUSG00000026678', u'ENSMUSG00000029470', u'ENSMUSG00000029576', u'ENSMUSG00000041696', u'ENSMUSG00000034781', u'ENSMUSG00000023868', u'ENSMUSG00000050730', u'ENSMUSG00000050600', u'ENSMUSG00000052087', u'ENSMUSG00000020937', u'ENSMUSG00000041624', u'ENSMUSG00000000127', u'ENSMUSG00000024883', u'ENSMUSG00000030257', u'ENSMUSG00000048376', u'ENSMUSG00000056486', u'ENSMUSG00000041741', u'ENSMUSG00000041219', u'ENSMUSG00000036949', u'ENSMUSG00000021709', u'ENSMUSG00000017386', u'ENSMUSG00000026482', u'ENSMUSG00000028195', u'ENSMUSG00000049583', u'ENSMUSG00000028057', u'ENSMUSG00000027531', u'ENSMUSG00000016496', u'ENSMUSG00000031451', u'ENSMUSG00000031450', u'ENSMUSG00000031453', u'ENSMUSG00000050541', u'ENSMUSG00000026102', u'ENSMUSG00000027852', u'ENSMUSG00000031523', u'ENSMUSG00000041444', u'ENSMUSG00000023353', u'ENSMUSG00000052336', u'ENSMUSG00000026173', u'ENSMUSG00000016150', u'ENSMUSG00000026072', u'ENSMUSG00000032041', u'ENSMUSG00000045087', u'ENSMUSG00000021552', u'ENSMUSG00000087141', u'ENSMUSG00000021559', u'ENSMUSG00000063239', u'ENSMUSG00000000861', u'ENSMUSG00000029055', u'ENSMUSG00000044337', u'ENSMUSG00000017631', u'ENSMUSG00000036882', u'ENSMUSG00000019990', u'ENSMUSG00000029053', u'ENSMUSG00000031355', u'ENSMUSG00000004347', u'ENSMUSG00000040009', u'ENSMUSG00000047344', u'ENSMUSG00000044933', u'ENSMUSG00000026000', u'ENSMUSG00000022176', u'ENSMUSG00000040003', u'ENSMUSG00000018166', u'ENSMUSG00000066232', u'ENSMUSG00000049511', u'ENSMUSG00000022074', u'ENSMUSG00000004815', u'ENSMUSG00000024176', u'ENSMUSG00000033256', u'ENSMUSG00000024287', u'ENSMUSG00000000766', u'ENSMUSG00000038128', u'ENSMUSG00000074794', u'ENSMUSG00000039831', u'ENSMUSG00000029602', u'ENSMUSG00000057315', u'ENSMUSG00000032259', u'ENSMUSG00000061718', u'ENSMUSG00000075270', u'ENSMUSG00000054162', u'ENSMUSG00000063626', u'ENSMUSG00000024778', u'ENSMUSG00000038811', u'ENSMUSG00000026821', u'ENSMUSG00000032812', u'ENSMUSG00000021684', u'ENSMUSG00000015709', u'ENSMUSG00000069094', u'ENSMUSG00000047842', u'ENSMUSG00000060216', u'ENSMUSG00000030671', u'ENSMUSG00000029309', u'ENSMUSG00000058099', u'ENSMUSG00000050164', u'ENSMUSG00000022490', u'ENSMUSG00000034226', u'ENSMUSG00000024211', u'ENSMUSG00000027523', u'ENSMUSG00000036904', u'ENSMUSG00000042626', u'ENSMUSG00000059921', u'ENSMUSG00000032773', u'ENSMUSG00000033777', u'ENSMUSG00000059883', u'ENSMUSG00000039059', u'ENSMUSG00000023915', u'ENSMUSG00000046159', u'ENSMUSG00000035697', u'ENSMUSG00000028121', u'ENSMUSG00000091735', u'ENSMUSG00000028945', u'ENSMUSG00000026626', u'ENSMUSG00000027634', u'ENSMUSG00000034987', u'ENSMUSG00000024858', u'ENSMUSG00000030898', u'ENSMUSG00000034792', u'ENSMUSG00000004768', u'ENSMUSG00000039116', u'ENSMUSG00000032586', u'ENSMUSG00000030093', u'ENSMUSG00000021756', u'ENSMUSG00000033910', u'ENSMUSG00000059203', u'ENSMUSG00000021759', u'ENSMUSG00000068740', u'ENSMUSG00000038069', u'ENSMUSG00000048027', u'ENSMUSG00000050511', u'ENSMUSG00000052783', u'ENSMUSG00000060450', u'ENSMUSG00000030525', u'ENSMUSG00000030259', u'ENSMUSG00000053965', u'ENSMUSG00000035172', u'ENSMUSG00000051615', u'ENSMUSG00000071658', u'ENSMUSG00000040125', u'ENSMUSG00000036894', u'ENSMUSG00000053646', u'ENSMUSG00000053647', u'ENSMUSG00000031785', u'ENSMUSG00000035773', u'ENSMUSG00000045875', u'ENSMUSG00000059810', u'ENSMUSG00000032177', u'ENSMUSG00000038668', u'ENSMUSG00000017837', u'ENSMUSG00000022297', u'ENSMUSG00000067586', u'ENSMUSG00000032192', u'ENSMUSG00000057455', u'ENSMUSG00000042129', u'ENSMUSG00000001127', u'ENSMUSG00000060735', u'ENSMUSG00000049649', u'ENSMUSG00000048965', u'ENSMUSG00000030733', u'ENSMUSG00000041119', u'ENSMUSG00000027568', u'ENSMUSG00000074939', u'ENSMUSG00000026867', u'ENSMUSG00000039809', u'ENSMUSG00000043999', u'ENSMUSG00000057672', u'ENSMUSG00000029641', u'ENSMUSG00000021448', u'ENSMUSG00000024096', u'ENSMUSG00000036357', u'ENSMUSG00000017843', u'ENSMUSG00000036353', u'ENSMUSG00000049044', u'ENSMUSG00000058881', u'ENSMUSG00000043659', u'ENSMUSG00000048240', u'ENSMUSG00000040276', u'ENSMUSG00000021676', u'ENSMUSG00000026640', u'ENSMUSG00000047875', u'ENSMUSG00000039154', u'ENSMUSG00000046280', u'ENSMUSG00000030123', u'ENSMUSG00000020684', u'ENSMUSG00000009828', u'ENSMUSG00000034255', u'ENSMUSG00000036452', u'ENSMUSG00000038910', u'ENSMUSG00000039585', u'ENSMUSG00000020392', u'ENSMUSG00000036591', u'ENSMUSG00000028163', u'ENSMUSG00000027164', u'ENSMUSG00000068037', u'ENSMUSG00000018819', u'ENSMUSG00000040372']), pop_n=13836, p_sm_bonferroni=1.348686786495049e-05, is_obsolete=False, GO='GO:0007165', name='signal transduction', pop_count=624, alt_ids=['GO:0023033'], level=2, depth=4, enrichment='e', Cluster='Late Decrease', geneid_set=set([u'ENSMUSG00000053199', u'ENSMUSG00000021373', u'ENSMUSG00000047904', u'ENSMUSG00000068740', u'ENSMUSG00000020196', u'ENSMUSG00000000861', u'ENSMUSG00000025876', u'ENSMUSG00000028782', u'ENSMUSG00000030257', u'ENSMUSG00000029055', u'ENSMUSG00000017631', u'ENSMUSG00000036882', u'ENSMUSG00000027584', u'ENSMUSG00000046093', u'ENSMUSG00000071658', u'ENSMUSG00000048251', u'ENSMUSG00000040009', u'ENSMUSG00000058230', u'ENSMUSG00000002489', u'ENSMUSG00000022176', u'ENSMUSG00000013033', u'ENSMUSG00000031906', u'ENSMUSG00000027335', u'ENSMUSG00000032177', u'ENSMUSG00000023886', u'ENSMUSG00000018634', u'ENSMUSG00000048216', u'ENSMUSG00000034209', u'ENSMUSG00000052298', u'ENSMUSG00000030084', u'ENSMUSG00000021721', u'ENSMUSG00000021559', u'ENSMUSG00000048078', u'ENSMUSG00000063358', u'ENSMUSG00000038128', u'ENSMUSG00000039585', u'ENSMUSG00000029602', u'ENSMUSG00000033697', u'ENSMUSG00000002496', u'ENSMUSG00000016150', u'ENSMUSG00000067629', u'ENSMUSG00000059456', u'ENSMUSG00000039809', u'ENSMUSG00000026113', u'ENSMUSG00000021057', u'ENSMUSG00000040563', u'ENSMUSG00000040836', u'ENSMUSG00000015501', u'ENSMUSG00000024639', u'ENSMUSG00000023473', u'ENSMUSG00000026482', u'ENSMUSG00000047842', u'ENSMUSG00000019699', u'ENSMUSG00000023192', u'ENSMUSG00000055723', u'ENSMUSG00000062232', u'ENSMUSG00000049336', u'ENSMUSG00000024122', u'ENSMUSG00000030525', u'ENSMUSG00000059173', u'ENSMUSG00000028004', u'ENSMUSG00000028005', u'ENSMUSG00000044667', u'ENSMUSG00000024524', u'ENSMUSG00000023868', u'ENSMUSG00000073557', u'ENSMUSG00000019828', u'ENSMUSG00000037014', u'ENSMUSG00000009681', u'ENSMUSG00000050600', u'ENSMUSG00000052087', u'ENSMUSG00000029765', u'ENSMUSG00000024883', u'ENSMUSG00000058297', u'ENSMUSG00000021676', u'ENSMUSG00000048240', u'ENSMUSG00000040276', u'ENSMUSG00000069601', u'ENSMUSG00000032773', u'ENSMUSG00000045318', u'ENSMUSG00000031834', u'ENSMUSG00000021549', u'ENSMUSG00000023915', u'ENSMUSG00000044067', u'ENSMUSG00000022637', u'ENSMUSG00000039087', u'ENSMUSG00000033342', u'ENSMUSG00000036591', u'ENSMUSG00000026322', u'ENSMUSG00000023353', u'ENSMUSG00000024462', u'ENSMUSG00000056486', u'ENSMUSG00000044933', u'ENSMUSG00000068037', u'ENSMUSG00000043004', u'ENSMUSG00000050132', u'ENSMUSG00000049583']), symbols=u'Abr Adgrb2 Adgrl1 Adra1d Adra2c Agap3 Akap5 Akt3 Ank3 Arhgap20 Arhgap21 Arhgap33 Arhgap35 Arhgap39 Bcl11a Bcl11b Bcr Cabin1 Camk4 Cap2 Cblb Cdc42se2 Celsr2 Celsr3 Chn1 Chrm1 Chrna7 Crhr1 Dapk1 Diras2 Gabbr1 Gabbr2 Gnal Gnaq Gnaz Gng2 Gng3 Gng7 Gpr161 Gpr22 Gpr85 Grm1 Grm2 Grm5 Gucy1b3 Hivep2 Hpcal4 Htr1a Htr4 Inpp4a Iqgap2 Mapk1 Mas1 Myo9a Npy2r Oprl1 Pacsin1 Pde10a Pde1a Pde4a Pdpk1 Pik3r2 Plch2 Plppr2 Plppr4 Plppr5 Plxna1 Plxna4 Ppp1r12b Ptk2b Rapgef2 Rasa1 Rasal1 Rasl10a Rem2 Rgl1 Rgs14 Rin1 Rras2 Rreb1 Sarm1 Smoc2 Smpd3 Spock2 Srgap3 Sstr2 Sstr3 Sstr4 Syngap1 Tenm1 Tenm2 Tenm4 Tiam1 Tnfrsf21 Tsc2 Unc5a Zfp831', symbol_set=set([u'Hpcal4', u'Gpr22', u'Iqgap2', u'Mas1', u'Cabin1', u'Rgl1', u'Gabbr1', u'Rin1', u'Inpp4a', u'Npy2r', u'Oprl1', 'Adgrb2', u'Tiam1', u'Akt3', 'Adgrl1', u'Pacsin1', u'Htr1a', u'Plxna1', u'Unc5a', u'Cdc42se2', u'Plxna4', u'Smpd3', u'Rasa1', u'Gnaq', u'Bcl11a', u'Rem2', u'Gnaz', u'Sstr3', u'Sstr2', u'Sstr4', u'Gnal', u'Bcl11b', u'Adra1d', u'Gng7', u'Tnfrsf21', u'Agap3', u'Gng2', u'Gng3', u'Hivep2', u'Rreb1', u'Rasl10a', u'Pdpk1', u'Gabbr2', u'Crhr1', u'Rgs14', u'Rras2', u'Cap2', u'Syngap1', u'Ptk2b', u'Smoc2', u'Gpr85', u'Diras2', u'Pde1a', u'Srgap3', u'Arhgap33', 'Arhgap35', u'Myo9a', u'Pde4a', u'Arhgap39', 'Plppr4', 'Plppr5', 'Plppr2', u'Celsr3', u'Celsr2', u'Arhgap21', u'Chrna7', u'Pik3r2', u'Adra2c', u'Mapk1', u'Ank3', u'Sarm1', u'Abr', u'Rasal1', u'Tsc2', u'Dapk1', 'Tenm2', 'Tenm1', u'Ppp1r12b', 'Tenm4', u'Akap5', u'Spock2', u'Camk4', u'Zfp831', u'Plch2', u'Htr4', u'Bcr', u'Cblb', u'Chn1', u'Chrm1', u'Pde10a', u'Arhgap20', u'Rapgef2', u'Gucy1b3', u'Grm5', u'Gpr161', u'Grm1', u'Grm2']), geneids='ENSMUSG00000053199 ENSMUSG00000047904 ENSMUSG00000020196 ENSMUSG00000000861 ENSMUSG00000029055 ENSMUSG00000017631 ENSMUSG00000036882 ENSMUSG00000048251 ENSMUSG00000040009 ENSMUSG00000024462 ENSMUSG00000002489 ENSMUSG00000022176 ENSMUSG00000013033 ENSMUSG00000031906 ENSMUSG00000023886 ENSMUSG00000052298 ENSMUSG00000021559 ENSMUSG00000048078 ENSMUSG00000038128 ENSMUSG00000039585 ENSMUSG00000029602 ENSMUSG00000002496 ENSMUSG00000021057 ENSMUSG00000040563 ENSMUSG00000059456 ENSMUSG00000023473 ENSMUSG00000019699 ENSMUSG00000062232 ENSMUSG00000030257 ENSMUSG00000059173 ENSMUSG00000028004 ENSMUSG00000028005 ENSMUSG00000063358 ENSMUSG00000044667 ENSMUSG00000024524 ENSMUSG00000019828 ENSMUSG00000037014 ENSMUSG00000032773 ENSMUSG00000009681 ENSMUSG00000023915 ENSMUSG00000044067 ENSMUSG00000022637 ENSMUSG00000026322 ENSMUSG00000058230 ENSMUSG00000056486 ENSMUSG00000044933 ENSMUSG00000068037 ENSMUSG00000028782 ENSMUSG00000030525 ENSMUSG00000027584 ENSMUSG00000071658 ENSMUSG00000046093 ENSMUSG00000027335 ENSMUSG00000032177 ENSMUSG00000018634 ENSMUSG00000048216 ENSMUSG00000034209 ENSMUSG00000030084 ENSMUSG00000029765 ENSMUSG00000058297 ENSMUSG00000024122 ENSMUSG00000033697 ENSMUSG00000067629 ENSMUSG00000040836 ENSMUSG00000026113 ENSMUSG00000031834 ENSMUSG00000024639 ENSMUSG00000047842 ENSMUSG00000025876 ENSMUSG00000023192 ENSMUSG00000055723 ENSMUSG00000049336 ENSMUSG00000015501 ENSMUSG00000023868 ENSMUSG00000069601 ENSMUSG00000073557 ENSMUSG00000039809 ENSMUSG00000039087 ENSMUSG00000050600 ENSMUSG00000052087 ENSMUSG00000021721 ENSMUSG00000024883 ENSMUSG00000048240 ENSMUSG00000040276 ENSMUSG00000026482 ENSMUSG00000021676 ENSMUSG00000045318 ENSMUSG00000049583 ENSMUSG00000021549 ENSMUSG00000021373 ENSMUSG00000068740 ENSMUSG00000033342 ENSMUSG00000036591 ENSMUSG00000023353 ENSMUSG00000016150 ENSMUSG00000043004 ENSMUSG00000050132', format_txt=1, hdr_idx=1, is_hdrgo=True, is_usrgo=True, hdr1usr01='**', dcnt=724, D1='AB', GO_name='signal transduction'),
    Nt(p_uncorrected=5.4811850339899943e-11, study_count=32, study_n=1139, namespace='biological_process', p_fdr_bh=1.3778716776436982e-07, study_items=set([u'ENSMUSG00000026824', u'ENSMUSG00000024112', u'ENSMUSG00000021730', u'ENSMUSG00000058248', u'ENSMUSG00000000197', u'ENSMUSG00000056258', u'ENSMUSG00000003352', u'ENSMUSG00000027827', u'ENSMUSG00000043301', u'ENSMUSG00000042604', u'ENSMUSG00000025221', u'ENSMUSG00000023033', u'ENSMUSG00000015968', u'ENSMUSG00000004110', u'ENSMUSG00000004113', u'ENSMUSG00000034656', u'ENSMUSG00000020704', u'ENSMUSG00000028033', u'ENSMUSG00000074575', u'ENSMUSG00000062785', u'ENSMUSG00000051331', u'ENSMUSG00000028931', u'ENSMUSG00000045053', u'ENSMUSG00000057914', u'ENSMUSG00000016346', u'ENSMUSG00000037579', u'ENSMUSG00000024589', u'ENSMUSG00000063142', u'ENSMUSG00000049281', u'ENSMUSG00000040118', u'ENSMUSG00000020882', u'ENSMUSG00000060882']), NS='BP', pop_items=set([u'ENSMUSG00000064210', u'ENSMUSG00000045246', u'ENSMUSG00000026880', u'ENSMUSG00000050556', u'ENSMUSG00000037242', u'ENSMUSG00000009731', u'ENSMUSG00000034402', u'ENSMUSG00000040164', u'ENSMUSG00000038319', u'ENSMUSG00000034659', u'ENSMUSG00000042604', u'ENSMUSG00000075316', u'ENSMUSG00000015968', u'ENSMUSG00000004110', u'ENSMUSG00000004113', u'ENSMUSG00000038026', u'ENSMUSG00000063142', u'ENSMUSG00000028033', u'ENSMUSG00000015340', u'ENSMUSG00000092083', u'ENSMUSG00000053519', u'ENSMUSG00000048677', u'ENSMUSG00000033486', u'ENSMUSG00000022843', u'ENSMUSG00000049281', u'ENSMUSG00000026824', u'ENSMUSG00000024112', u'ENSMUSG00000027895', u'ENSMUSG00000040896', u'ENSMUSG00000044216', u'ENSMUSG00000045053', u'ENSMUSG00000039672', u'ENSMUSG00000056258', u'ENSMUSG00000003352', u'ENSMUSG00000035681', u'ENSMUSG00000019194', u'ENSMUSG00000028631', u'ENSMUSG00000079436', u'ENSMUSG00000064329', u'ENSMUSG00000038077', u'ENSMUSG00000028931', u'ENSMUSG00000016346', u'ENSMUSG00000037579', u'ENSMUSG00000024589', u'ENSMUSG00000042529', u'ENSMUSG00000070304', u'ENSMUSG00000032741', u'ENSMUSG00000069806', u'ENSMUSG00000010066', u'ENSMUSG00000021991', u'ENSMUSG00000043301', u'ENSMUSG00000046480', u'ENSMUSG00000028096', u'ENSMUSG00000053395', u'ENSMUSG00000040724', u'ENSMUSG00000025221', u'ENSMUSG00000023033', u'ENSMUSG00000007041', u'ENSMUSG00000020704', u'ENSMUSG00000047959', u'ENSMUSG00000059742', u'ENSMUSG00000058743', u'ENSMUSG00000030247', u'ENSMUSG00000051331', u'ENSMUSG00000064267', u'ENSMUSG00000043673', u'ENSMUSG00000058248', u'ENSMUSG00000057914', u'ENSMUSG00000031930', u'ENSMUSG00000032511', u'ENSMUSG00000000197', u'ENSMUSG00000034656', u'ENSMUSG00000040118', u'ENSMUSG00000020331', u'ENSMUSG00000060882', u'ENSMUSG00000024957', u'ENSMUSG00000021730', u'ENSMUSG00000019146', u'ENSMUSG00000041695', u'ENSMUSG00000017412', u'ENSMUSG00000044708', u'ENSMUSG00000022342', u'ENSMUSG00000027827', u'ENSMUSG00000079056', u'ENSMUSG00000050963', u'ENSMUSG00000062785', u'ENSMUSG00000066189', u'ENSMUSG00000051497', u'ENSMUSG00000058975', u'ENSMUSG00000028051', u'ENSMUSG00000074575', u'ENSMUSG00000047976', u'ENSMUSG00000018470', u'ENSMUSG00000023959', u'ENSMUSG00000045404', u'ENSMUSG00000029088', u'ENSMUSG00000022949', u'ENSMUSG00000051726', u'ENSMUSG00000020723', u'ENSMUSG00000020882', u'ENSMUSG00000040373']), pop_n=13836, p_sm_bonferroni=8.304543444998241e-07, is_obsolete=False, GO='GO:0034765', name='regulation of ion transmembrane transport', pop_count=101, alt_ids=[], level=6, depth=6, enrichment='e', Cluster='Late Decrease', geneid_set=set([u'ENSMUSG00000026824', u'ENSMUSG00000024112', u'ENSMUSG00000021730', u'ENSMUSG00000058248', u'ENSMUSG00000000197', u'ENSMUSG00000045053', u'ENSMUSG00000056258', u'ENSMUSG00000003352', u'ENSMUSG00000027827', u'ENSMUSG00000043301', u'ENSMUSG00000025221', u'ENSMUSG00000042604', u'ENSMUSG00000023033', u'ENSMUSG00000015968', u'ENSMUSG00000004110', u'ENSMUSG00000004113', u'ENSMUSG00000034656', u'ENSMUSG00000020704', u'ENSMUSG00000028033', u'ENSMUSG00000074575', u'ENSMUSG00000062785', u'ENSMUSG00000051331', u'ENSMUSG00000028931', u'ENSMUSG00000057914', u'ENSMUSG00000016346', u'ENSMUSG00000037579', u'ENSMUSG00000024589', u'ENSMUSG00000063142', u'ENSMUSG00000049281', u'ENSMUSG00000040118', u'ENSMUSG00000020882', u'ENSMUSG00000060882']), symbols=u'Asic2 Cacna1a Cacna1b Cacna1c Cacna1d Cacna1e Cacna1h Cacna2d1 Cacnb1 Cacnb2 Cacnb3 Hcn1 Kcna4 Kcnab1 Kcnab2 Kcnc3 Kcnd2 Kcng1 Kcng3 Kcnh1 Kcnh3 Kcnip2 Kcnj3 Kcnj6 Kcnma1 Kcnq2 Kcnq3 Kcnq5 Nalcn Nedd4l Scn3b Scn8a', symbol_set=set([u'Kcnj3', u'Cacna1h', u'Kcnh1', u'Kcnj6', u'Kcnh3', u'Cacna1a', u'Cacna1b', u'Cacna1c', u'Cacna1d', u'Cacna1e', u'Kcnma1', u'Nedd4l', u'Scn3b', u'Kcnc3', u'Hcn1', u'Kcng1', u'Cacnb1', u'Kcng3', u'Scn8a', 'Asic2', u'Kcna4', u'Cacna2d1', u'Kcnab1', u'Kcnab2', u'Kcnd2', u'Nalcn', u'Kcnq5', u'Kcnq2', u'Kcnq3', u'Cacnb3', u'Cacnb2', u'Kcnip2']), geneids='ENSMUSG00000026824 ENSMUSG00000024112 ENSMUSG00000021730 ENSMUSG00000058248 ENSMUSG00000000197 ENSMUSG00000045053 ENSMUSG00000056258 ENSMUSG00000003352 ENSMUSG00000027827 ENSMUSG00000043301 ENSMUSG00000025221 ENSMUSG00000042604 ENSMUSG00000023033 ENSMUSG00000015968 ENSMUSG00000004110 ENSMUSG00000004113 ENSMUSG00000034656 ENSMUSG00000020704 ENSMUSG00000028033 ENSMUSG00000074575 ENSMUSG00000062785 ENSMUSG00000051331 ENSMUSG00000028931 ENSMUSG00000057914 ENSMUSG00000016346 ENSMUSG00000037579 ENSMUSG00000024589 ENSMUSG00000063142 ENSMUSG00000049281 ENSMUSG00000040118 ENSMUSG00000020882 ENSMUSG00000060882', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=235, D1='A', GO_name='regulation of ion transmembrane transport'),
    Nt(p_uncorrected=6.192282630713962e-09, study_count=12, study_n=1139, namespace='biological_process', p_fdr_bh=2.8430083072105223e-06, study_items=set([u'ENSMUSG00000057182', u'ENSMUSG00000024112', u'ENSMUSG00000018965', u'ENSMUSG00000000197', u'ENSMUSG00000049281', u'ENSMUSG00000022416', u'ENSMUSG00000004110', u'ENSMUSG00000023033', u'ENSMUSG00000051331', u'ENSMUSG00000004113', u'ENSMUSG00000075318', u'ENSMUSG00000034656']), NS='BP', pop_items=set([u'ENSMUSG00000064329', u'ENSMUSG00000057182', u'ENSMUSG00000024112', u'ENSMUSG00000018965', u'ENSMUSG00000048677', u'ENSMUSG00000032741', u'ENSMUSG00000032511', u'ENSMUSG00000033486', u'ENSMUSG00000038319', u'ENSMUSG00000000197', u'ENSMUSG00000075316', u'ENSMUSG00000034656', u'ENSMUSG00000049281', u'ENSMUSG00000022416', u'ENSMUSG00000004110', u'ENSMUSG00000023033', u'ENSMUSG00000051331', u'ENSMUSG00000004113', u'ENSMUSG00000075318', u'ENSMUSG00000034810']), pop_n=13836, p_sm_bonferroni=9.381927413794724e-05, is_obsolete=False, GO='GO:0086010', name='membrane depolarization during action potential', pop_count=20, alt_ids=[], level=5, depth=5, enrichment='e', Cluster='Late Decrease', geneid_set=set([u'ENSMUSG00000057182', u'ENSMUSG00000024112', u'ENSMUSG00000018965', u'ENSMUSG00000000197', u'ENSMUSG00000049281', u'ENSMUSG00000022416', u'ENSMUSG00000004110', u'ENSMUSG00000023033', u'ENSMUSG00000051331', u'ENSMUSG00000004113', u'ENSMUSG00000075318', u'ENSMUSG00000034656']), symbols=u'Cacna1a Cacna1b Cacna1c Cacna1e Cacna1h Cacna1i Nalcn Scn2a Scn3a Scn3b Scn8a Ywhah', symbol_set=set([u'Cacna1h', u'Cacna1i', u'Nalcn', u'Cacna1a', u'Cacna1b', u'Cacna1c', u'Scn8a', u'Cacna1e', u'Ywhah', 'Scn2a', u'Scn3a', u'Scn3b']), geneids='ENSMUSG00000057182 ENSMUSG00000024112 ENSMUSG00000018965 ENSMUSG00000000197 ENSMUSG00000049281 ENSMUSG00000022416 ENSMUSG00000004110 ENSMUSG00000023033 ENSMUSG00000051331 ENSMUSG00000004113 ENSMUSG00000075318 ENSMUSG00000034656', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=7, D1='A', GO_name='membrane depolarization during action potential'),
    Nt(p_uncorrected=0.0004915718501337365, study_count=9, study_n=1139, namespace='biological_process', p_fdr_bh=0.04899871777221212, study_items=set([u'ENSMUSG00000051790', u'ENSMUSG00000002496', u'ENSMUSG00000061751', u'ENSMUSG00000006435', u'ENSMUSG00000038738', u'ENSMUSG00000063887', u'ENSMUSG00000031302', u'ENSMUSG00000052135', u'ENSMUSG00000022623']), NS='BP', pop_items=set([u'ENSMUSG00000006435', u'ENSMUSG00000039671', u'ENSMUSG00000063887', u'ENSMUSG00000031302', u'ENSMUSG00000022623', u'ENSMUSG00000035863', u'ENSMUSG00000051790', u'ENSMUSG00000001847', u'ENSMUSG00000032827', u'ENSMUSG00000039652', u'ENSMUSG00000002985', u'ENSMUSG00000020224', u'ENSMUSG00000038668', u'ENSMUSG00000019969', u'ENSMUSG00000028991', u'ENSMUSG00000021546', u'ENSMUSG00000000838', u'ENSMUSG00000048076', u'ENSMUSG00000061751', u'ENSMUSG00000030272', u'ENSMUSG00000056201', u'ENSMUSG00000038738', u'ENSMUSG00000042688', u'ENSMUSG00000002496', u'ENSMUSG00000034708', u'ENSMUSG00000062991', u'ENSMUSG00000029454', u'ENSMUSG00000024431', u'ENSMUSG00000005610', u'ENSMUSG00000052135']), pop_n=13836, p_sm_bonferroni=1.0, is_obsolete=False, GO='GO:0060999', name='positive regulation of dendritic spine development', pop_count=30, alt_ids=[], level=9, depth=11, enrichment='e', Cluster='Late Decrease', geneid_set=set([u'ENSMUSG00000051790', u'ENSMUSG00000002496', u'ENSMUSG00000061751', u'ENSMUSG00000006435', u'ENSMUSG00000038738', u'ENSMUSG00000063887', u'ENSMUSG00000031302', u'ENSMUSG00000052135', u'ENSMUSG00000022623']), symbols=u'Foxo6 Kalrn Neurl1a Nlgn1 Nlgn2 Nlgn3 Shank1 Shank3 Tsc2', symbol_set=set([u'Neurl1a', u'Nlgn2', u'Nlgn3', u'Nlgn1', u'Kalrn', u'Shank3', u'Foxo6', u'Tsc2', u'Shank1']), geneids='ENSMUSG00000051790 ENSMUSG00000002496 ENSMUSG00000061751 ENSMUSG00000006435 ENSMUSG00000038738 ENSMUSG00000063887 ENSMUSG00000031302 ENSMUSG00000052135 ENSMUSG00000022623', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=1, D1='A', GO_name='positive regulation of dendritic spine development'),
    Nt(p_uncorrected=0.00023396808843157167, study_count=7, study_n=1139, namespace='biological_process', p_fdr_bh=0.02645410826736375, study_items=set([u'ENSMUSG00000002496', u'ENSMUSG00000037110', u'ENSMUSG00000038807', u'ENSMUSG00000030583', u'ENSMUSG00000056486', u'ENSMUSG00000040797', u'ENSMUSG00000042700']), NS='BP', pop_items=set([u'ENSMUSG00000041351', u'ENSMUSG00000002496', u'ENSMUSG00000036452', u'ENSMUSG00000026490', u'ENSMUSG00000027652', u'ENSMUSG00000037110', u'ENSMUSG00000001995', u'ENSMUSG00000039031', u'ENSMUSG00000038807', u'ENSMUSG00000030583', u'ENSMUSG00000056486', u'ENSMUSG00000056917', u'ENSMUSG00000021027', u'ENSMUSG00000038860', u'ENSMUSG00000040797', u'ENSMUSG00000041688', u'ENSMUSG00000042700']), pop_n=13836, p_sm_bonferroni=1.0, is_obsolete=False, GO='GO:0051056', name='regulation of small GTPase mediated signal transduction', pop_count=17, alt_ids=[], level=6, depth=7, enrichment='e', Cluster='Late Decrease', geneid_set=set([u'ENSMUSG00000002496', u'ENSMUSG00000056486', u'ENSMUSG00000037110', u'ENSMUSG00000042700', u'ENSMUSG00000040797', u'ENSMUSG00000038807', u'ENSMUSG00000030583']), symbols=u'Chn1 Iqsec3 Ralgapa2 Rap1gap2 Sipa1l1 Sipa1l3 Tsc2', symbol_set=set([u'Tsc2', u'Chn1', u'Sipa1l1', u'Iqsec3', u'Rap1gap2', u'Sipa1l3', u'Ralgapa2']), geneids='ENSMUSG00000002496 ENSMUSG00000037110 ENSMUSG00000038807 ENSMUSG00000030583 ENSMUSG00000056486 ENSMUSG00000040797 ENSMUSG00000042700', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=26, D1='A', GO_name='regulation of small GTPase mediated signal transduction'),
    Nt(p_uncorrected=1.3406311370767758e-06, study_count=13, study_n=1139, namespace='biological_process', p_fdr_bh=0.00030775609633106407, study_items=set([u'ENSMUSG00000051790', u'ENSMUSG00000002496', u'ENSMUSG00000029104', u'ENSMUSG00000045903', u'ENSMUSG00000061751', u'ENSMUSG00000037541', u'ENSMUSG00000022619', u'ENSMUSG00000038738', u'ENSMUSG00000041078', u'ENSMUSG00000046230', u'ENSMUSG00000031302', u'ENSMUSG00000022623', u'ENSMUSG00000020886']), NS='BP', pop_items=set([u'ENSMUSG00000013663', u'ENSMUSG00000031393', u'ENSMUSG00000027950', u'ENSMUSG00000070880', u'ENSMUSG00000021478', u'ENSMUSG00000031302', u'ENSMUSG00000022623', u'ENSMUSG00000000884', u'ENSMUSG00000033768', u'ENSMUSG00000051790', u'ENSMUSG00000029104', u'ENSMUSG00000029071', u'ENSMUSG00000026317', u'ENSMUSG00000022619', u'ENSMUSG00000019803', u'ENSMUSG00000027274', u'ENSMUSG00000039419', u'ENSMUSG00000041078', u'ENSMUSG00000028991', u'ENSMUSG00000037541', u'ENSMUSG00000061751', u'ENSMUSG00000024109', u'ENSMUSG00000038738', u'ENSMUSG00000028351', u'ENSMUSG00000031592', u'ENSMUSG00000026959', u'ENSMUSG00000002496', u'ENSMUSG00000045903', u'ENSMUSG00000025235', u'ENSMUSG00000046230', u'ENSMUSG00000041552', u'ENSMUSG00000020091', u'ENSMUSG00000049112', u'ENSMUSG00000020886']), pop_n=13836, p_sm_bonferroni=0.020311902357850232, is_obsolete=False, GO='GO:0035176', name='social behavior', pop_count=34, alt_ids=[], level=3, depth=3, enrichment='e', Cluster='Late Decrease', geneid_set=set([u'ENSMUSG00000051790', u'ENSMUSG00000002496', u'ENSMUSG00000029104', u'ENSMUSG00000031302', u'ENSMUSG00000061751', u'ENSMUSG00000037541', u'ENSMUSG00000022619', u'ENSMUSG00000038738', u'ENSMUSG00000041078', u'ENSMUSG00000046230', u'ENSMUSG00000045903', u'ENSMUSG00000022623', u'ENSMUSG00000020886']), symbols=u'Dlg4 Grid1 Htt Kalrn Mapk8ip2 Nlgn2 Nlgn3 Npas4 Shank1 Shank2 Shank3 Tsc2 Vps13a', symbol_set=set([u'Nlgn2', u'Nlgn3', u'Kalrn', u'Npas4', u'Shank3', u'Htt', u'Shank1', u'Vps13a', u'Grid1', u'Tsc2', u'Shank2', u'Mapk8ip2', u'Dlg4']), geneids='ENSMUSG00000037541 ENSMUSG00000002496 ENSMUSG00000029104 ENSMUSG00000045903 ENSMUSG00000061751 ENSMUSG00000051790 ENSMUSG00000022619 ENSMUSG00000038738 ENSMUSG00000041078 ENSMUSG00000046230 ENSMUSG00000031302 ENSMUSG00000022623 ENSMUSG00000020886', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=0, D1='IN', GO_name='social behavior'),
    Nt(p_uncorrected=1.2370265285215944e-07, study_count=19, study_n=1139, namespace='biological_process', p_fdr_bh=4.0743888986153645e-05, study_items=set([u'ENSMUSG00000037541', u'ENSMUSG00000030209', u'ENSMUSG00000031302', u'ENSMUSG00000031137', u'ENSMUSG00000022973', u'ENSMUSG00000045903', u'ENSMUSG00000052087', u'ENSMUSG00000049583', u'ENSMUSG00000022208', u'ENSMUSG00000029104', u'ENSMUSG00000026596', u'ENSMUSG00000025318', u'ENSMUSG00000030376', u'ENSMUSG00000074923', u'ENSMUSG00000021314', u'ENSMUSG00000028664', u'ENSMUSG00000059003', u'ENSMUSG00000063434', u'ENSMUSG00000022623']), NS='BP', pop_items=set([u'ENSMUSG00000059003', u'ENSMUSG00000030310', u'ENSMUSG00000008892', u'ENSMUSG00000013662', u'ENSMUSG00000032487', u'ENSMUSG00000027950', u'ENSMUSG00000037996', u'ENSMUSG00000026596', u'ENSMUSG00000000326', u'ENSMUSG00000030376', u'ENSMUSG00000028664', u'ENSMUSG00000023826', u'ENSMUSG00000031302', u'ENSMUSG00000063434', u'ENSMUSG00000022623', u'ENSMUSG00000031137', u'ENSMUSG00000037541', u'ENSMUSG00000029104', u'ENSMUSG00000037685', u'ENSMUSG00000079055', u'ENSMUSG00000002997', u'ENSMUSG00000005102', u'ENSMUSG00000052087', u'ENSMUSG00000022208', u'ENSMUSG00000029838', u'ENSMUSG00000047250', u'ENSMUSG00000055254', u'ENSMUSG00000022240', u'ENSMUSG00000022973', u'ENSMUSG00000021314', u'ENSMUSG00000039419', u'ENSMUSG00000017740', u'ENSMUSG00000048482', u'ENSMUSG00000042453', u'ENSMUSG00000045903', u'ENSMUSG00000062014', u'ENSMUSG00000031393', u'ENSMUSG00000030209', u'ENSMUSG00000035898', u'ENSMUSG00000027792', u'ENSMUSG00000024109', u'ENSMUSG00000049583', u'ENSMUSG00000039059', u'ENSMUSG00000020402', u'ENSMUSG00000026080', u'ENSMUSG00000021478', u'ENSMUSG00000039913', u'ENSMUSG00000026959', u'ENSMUSG00000074923', u'ENSMUSG00000053164', u'ENSMUSG00000027568', u'ENSMUSG00000052684', u'ENSMUSG00000021877', u'ENSMUSG00000028546', u'ENSMUSG00000025318', u'ENSMUSG00000036678', u'ENSMUSG00000032327', u'ENSMUSG00000063239', u'ENSMUSG00000053024']), pop_n=13836, p_sm_bonferroni=0.0018742188933630677, is_obsolete=False, GO='GO:0007612', name='learning', pop_count=59, alt_ids=[], level=4, depth=6, enrichment='e', Cluster='Late Decrease', geneid_set=set([u'ENSMUSG00000030209', u'ENSMUSG00000031137', u'ENSMUSG00000049583', u'ENSMUSG00000026596', u'ENSMUSG00000030376', u'ENSMUSG00000021314', u'ENSMUSG00000028664', u'ENSMUSG00000031302', u'ENSMUSG00000063434', u'ENSMUSG00000074923', u'ENSMUSG00000037541', u'ENSMUSG00000029104', u'ENSMUSG00000059003', u'ENSMUSG00000052087', u'ENSMUSG00000022208', u'ENSMUSG00000025318', u'ENSMUSG00000022623', u'ENSMUSG00000022973', u'ENSMUSG00000045903']), symbols=u'Abl2 Amph Ephb2 Fgf13 Grin2a Grin2b Grm5 Htt Jph3 Jph4 Nlgn3 Npas4 Pak6 Rgs14 Shank2 Shank3 Slc8a2 Sorcs3 Synj1', symbol_set=set([u'Ephb2', u'Amph', u'Slc8a2', u'Nlgn3', u'Sorcs3', u'Rgs14', u'Npas4', u'Grin2b', u'Jph3', u'Htt', u'Synj1', u'Jph4', u'Fgf13', u'Grm5', u'Pak6', u'Abl2', u'Shank3', u'Shank2', u'Grin2a']), geneids='ENSMUSG00000037541 ENSMUSG00000029104 ENSMUSG00000045903 ENSMUSG00000031137 ENSMUSG00000030376 ENSMUSG00000052087 ENSMUSG00000049583 ENSMUSG00000022208 ENSMUSG00000030209 ENSMUSG00000026596 ENSMUSG00000025318 ENSMUSG00000022973 ENSMUSG00000074923 ENSMUSG00000021314 ENSMUSG00000028664 ENSMUSG00000031302 ENSMUSG00000063434 ENSMUSG00000022623 ENSMUSG00000059003', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=14, D1='CJN', GO_name='learning'),
    Nt(p_uncorrected=0.00014812003725583547, study_count=7, study_n=1139, namespace='biological_process', p_fdr_bh=0.018098118423090025, study_items=set([u'ENSMUSG00000053550', u'ENSMUSG00000003863', u'ENSMUSG00000053930', u'ENSMUSG00000030376', u'ENSMUSG00000002028', u'ENSMUSG00000037217', u'ENSMUSG00000034799']), NS='BP', pop_items=set([u'ENSMUSG00000028456', u'ENSMUSG00000031840', u'ENSMUSG00000003863', u'ENSMUSG00000030376', u'ENSMUSG00000056073', u'ENSMUSG00000022494', u'ENSMUSG00000002028', u'ENSMUSG00000048482', u'ENSMUSG00000036104', u'ENSMUSG00000031144', u'ENSMUSG00000022415', u'ENSMUSG00000037217', u'ENSMUSG00000053930', u'ENSMUSG00000053550', u'ENSMUSG00000022935', u'ENSMUSG00000034799']), pop_n=13836, p_sm_bonferroni=1.0, is_obsolete=False, GO='GO:0048172', name='regulation of short-term neuronal synaptic plasticity', pop_count=16, alt_ids=[], level=5, depth=8, enrichment='e', Cluster='Late Decrease', geneid_set=set([u'ENSMUSG00000030376', u'ENSMUSG00000002028', u'ENSMUSG00000037217', u'ENSMUSG00000053930', u'ENSMUSG00000003863', u'ENSMUSG00000053550', u'ENSMUSG00000034799']), symbols=u'Kmt2a Ppfia3 Shisa6 Shisa7 Slc8a2 Syn1 Unc13a', symbol_set=set(['Kmt2a', u'Ppfia3', u'Shisa6', u'Shisa7', u'Unc13a', u'Slc8a2', u'Syn1']), geneids='ENSMUSG00000053550 ENSMUSG00000053930 ENSMUSG00000003863 ENSMUSG00000030376 ENSMUSG00000002028 ENSMUSG00000037217 ENSMUSG00000034799', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=2, D1='A', GO_name='regulation of short-term neuronal synaptic plasticity'),
    Nt(p_uncorrected=6.837147798318499e-05, study_count=5, study_n=1139, namespace='biological_process', p_fdr_bh=0.009466346466222046, study_items=set([u'ENSMUSG00000028664', u'ENSMUSG00000005672', u'ENSMUSG00000049583', u'ENSMUSG00000006435', u'ENSMUSG00000022623']), NS='BP', pop_items=set([u'ENSMUSG00000049583', u'ENSMUSG00000006435', u'ENSMUSG00000022623', u'ENSMUSG00000028664', u'ENSMUSG00000048482', u'ENSMUSG00000005672', u'ENSMUSG00000062960']), pop_n=13836, p_sm_bonferroni=1.0, is_obsolete=False, GO='GO:0048170', name='positive regulation of long-term neuronal synaptic plasticity', pop_count=7, alt_ids=[], level=6, depth=9, enrichment='e', Cluster='Late Decrease', geneid_set=set([u'ENSMUSG00000028664', u'ENSMUSG00000006435', u'ENSMUSG00000049583', u'ENSMUSG00000005672', u'ENSMUSG00000022623']), symbols=u'Ephb2 Grm5 Kit Neurl1a Shank3', symbol_set=set([u'Ephb2', u'Grm5', u'Neurl1a', u'Shank3', u'Kit']), geneids='ENSMUSG00000028664 ENSMUSG00000006435 ENSMUSG00000049583 ENSMUSG00000005672 ENSMUSG00000022623', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=0, D1='A', GO_name='positive regulation of long-term neuronal synaptic plasticity'),
    Nt(p_uncorrected='', study_count='', study_n='', namespace='', p_fdr_bh='', study_items='', NS='BP', pop_items='', pop_n='', p_sm_bonferroni='', is_obsolete='', GO='GO:0097485', name='', pop_count='', alt_ids='', level=4, depth=4, enrichment='', Cluster='', geneid_set='', symbols='', symbol_set='', geneids='', format_txt=1, hdr_idx=1, is_hdrgo=True, is_usrgo=False, hdr1usr01='*', dcnt=34, D1='BC', GO_name='neuron projection guidance'),
    Nt(p_uncorrected=0.00023396808843157167, study_count=7, study_n=1139, namespace='biological_process', p_fdr_bh=0.02645410826736375, study_items=set([u'ENSMUSG00000030209', u'ENSMUSG00000061751', u'ENSMUSG00000053310', u'ENSMUSG00000003575', u'ENSMUSG00000059003', u'ENSMUSG00000022623', u'ENSMUSG00000029361']), NS='BP', pop_items=set([u'ENSMUSG00000021546', u'ENSMUSG00000030209', u'ENSMUSG00000053310', u'ENSMUSG00000005102', u'ENSMUSG00000032259', u'ENSMUSG00000030854', u'ENSMUSG00000035283', u'ENSMUSG00000025958', u'ENSMUSG00000021478', u'ENSMUSG00000022623', u'ENSMUSG00000042453', u'ENSMUSG00000003575', u'ENSMUSG00000039536', u'ENSMUSG00000059003', u'ENSMUSG00000061751', u'ENSMUSG00000039652', u'ENSMUSG00000029361']), pop_n=13836, p_sm_bonferroni=1.0, is_obsolete=False, GO='GO:1900273', name='positive regulation of long-term synaptic potentiation', pop_count=17, alt_ids=[], level=4, depth=8, enrichment='e', Cluster='Late Decrease', geneid_set=set([u'ENSMUSG00000029361', u'ENSMUSG00000030209', u'ENSMUSG00000053310', u'ENSMUSG00000061751', u'ENSMUSG00000059003', u'ENSMUSG00000003575', u'ENSMUSG00000022623']), symbols=u'Crtc1 Grin2a Grin2b Kalrn Nos1 Nrgn Shank3', symbol_set=set([u'Nos1', u'Nrgn', u'Kalrn', u'Grin2b', u'Crtc1', u'Grin2a', u'Shank3']), geneids='ENSMUSG00000030209 ENSMUSG00000061751 ENSMUSG00000053310 ENSMUSG00000003575 ENSMUSG00000059003 ENSMUSG00000022623 ENSMUSG00000029361', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=0, D1='A', GO_name='positive regulation of long-term synaptic potentiation'),
    Nt(p_uncorrected=1.0969449200467629e-10, study_count=24, study_n=1139, namespace='biological_process', p_fdr_bh=1.3849843736357086e-07, study_items=set([u'ENSMUSG00000024112', u'ENSMUSG00000032839', u'ENSMUSG00000030376', u'ENSMUSG00000000197', u'ENSMUSG00000020866', u'ENSMUSG00000003352', u'ENSMUSG00000057378', u'ENSMUSG00000019943', u'ENSMUSG00000030592', u'ENSMUSG00000015968', u'ENSMUSG00000004110', u'ENSMUSG00000054640', u'ENSMUSG00000063873', u'ENSMUSG00000034656', u'ENSMUSG00000021313', u'ENSMUSG00000030102', u'ENSMUSG00000051331', u'ENSMUSG00000009647', u'ENSMUSG00000004113', u'ENSMUSG00000057914', u'ENSMUSG00000041710', u'ENSMUSG00000040118', u'ENSMUSG00000020882', u'ENSMUSG00000027748']), NS='BP', pop_items=set([u'ENSMUSG00000027716', u'ENSMUSG00000024112', u'ENSMUSG00000028207', u'ENSMUSG00000031934', u'ENSMUSG00000019146', u'ENSMUSG00000064210', u'ENSMUSG00000032839', u'ENSMUSG00000037996', u'ENSMUSG00000069806', u'ENSMUSG00000009292', u'ENSMUSG00000030376', u'ENSMUSG00000000197', u'ENSMUSG00000020866', u'ENSMUSG00000032855', u'ENSMUSG00000003352', u'ENSMUSG00000018507', u'ENSMUSG00000010066', u'ENSMUSG00000021991', u'ENSMUSG00000057378', u'ENSMUSG00000020788', u'ENSMUSG00000052428', u'ENSMUSG00000030287', u'ENSMUSG00000023017', u'ENSMUSG00000019943', u'ENSMUSG00000053395', u'ENSMUSG00000042644', u'ENSMUSG00000030592', u'ENSMUSG00000034656', u'ENSMUSG00000036353', u'ENSMUSG00000034462', u'ENSMUSG00000032741', u'ENSMUSG00000004110', u'ENSMUSG00000054640', u'ENSMUSG00000004113', u'ENSMUSG00000066189', u'ENSMUSG00000030302', u'ENSMUSG00000032754', u'ENSMUSG00000049686', u'ENSMUSG00000021541', u'ENSMUSG00000026819', u'ENSMUSG00000029467', u'ENSMUSG00000015968', u'ENSMUSG00000021313', u'ENSMUSG00000030102', u'ENSMUSG00000051331', u'ENSMUSG00000009647', u'ENSMUSG00000014158', u'ENSMUSG00000031451', u'ENSMUSG00000079055', u'ENSMUSG00000063873', u'ENSMUSG00000048677', u'ENSMUSG00000026463', u'ENSMUSG00000057914', u'ENSMUSG00000041710', u'ENSMUSG00000032570', u'ENSMUSG00000033486', u'ENSMUSG00000027365', u'ENSMUSG00000031997', u'ENSMUSG00000027087', u'ENSMUSG00000040118', u'ENSMUSG00000020882', u'ENSMUSG00000017412', u'ENSMUSG00000027748', u'ENSMUSG00000020723', u'ENSMUSG00000040373']), pop_n=13836, p_sm_bonferroni=1.6619812483628506e-06, is_obsolete=False, GO='GO:0070588', name='calcium ion transmembrane transport', pop_count=65, alt_ids=[], level=8, depth=9, enrichment='e', Cluster='Late Decrease', geneid_set=set([u'ENSMUSG00000024112', u'ENSMUSG00000032839', u'ENSMUSG00000021313', u'ENSMUSG00000030376', u'ENSMUSG00000030102', u'ENSMUSG00000000197', u'ENSMUSG00000020866', u'ENSMUSG00000003352', u'ENSMUSG00000057378', u'ENSMUSG00000040118', u'ENSMUSG00000004113', u'ENSMUSG00000057914', u'ENSMUSG00000041710', u'ENSMUSG00000019943', u'ENSMUSG00000009647', u'ENSMUSG00000030592', u'ENSMUSG00000051331', u'ENSMUSG00000015968', u'ENSMUSG00000004110', u'ENSMUSG00000054640', u'ENSMUSG00000020882', u'ENSMUSG00000063873', u'ENSMUSG00000027748', u'ENSMUSG00000034656']), symbols=u'Atp2b1 Cacna1a Cacna1b Cacna1c Cacna1d Cacna1e Cacna1g Cacna1h Cacna2d1 Cacnb1 Cacnb2 Cacnb3 Itpr1 Mcu Nalcn Ryr1 Ryr2 Ryr3 Slc24a3 Slc8a1 Slc8a2 Trpc1 Trpc4 Trpc5', symbol_set=set([u'Cacna1h', u'Cacna1a', u'Cacna1b', u'Cacna1c', u'Cacna1d', u'Cacna1e', u'Cacna1g', u'Cacnb3', u'Cacnb2', u'Ryr3', u'Ryr2', u'Trpc1', u'Trpc4', u'Trpc5', 'Mcu', u'Cacna2d1', u'Slc8a1', u'Slc8a2', u'Itpr1', u'Nalcn', u'Slc24a3', u'Ryr1', u'Atp2b1', u'Cacnb1']), geneids='ENSMUSG00000024112 ENSMUSG00000032839 ENSMUSG00000030376 ENSMUSG00000000197 ENSMUSG00000020866 ENSMUSG00000003352 ENSMUSG00000057378 ENSMUSG00000019943 ENSMUSG00000030592 ENSMUSG00000015968 ENSMUSG00000004110 ENSMUSG00000054640 ENSMUSG00000004113 ENSMUSG00000034656 ENSMUSG00000021313 ENSMUSG00000030102 ENSMUSG00000051331 ENSMUSG00000009647 ENSMUSG00000063873 ENSMUSG00000057914 ENSMUSG00000041710 ENSMUSG00000040118 ENSMUSG00000020882 ENSMUSG00000027748', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=13, D1='G', GO_name='calcium ion transmembrane transport'),
    Nt(p_uncorrected=2.6778182772284598e-09, study_count=12, study_n=1139, namespace='biological_process', p_fdr_bh=1.5026527673440145e-06, study_items=set([u'ENSMUSG00000031012', u'ENSMUSG00000024112', u'ENSMUSG00000057914', u'ENSMUSG00000027748', u'ENSMUSG00000015968', u'ENSMUSG00000051331', u'ENSMUSG00000020866', u'ENSMUSG00000022416', u'ENSMUSG00000004110', u'ENSMUSG00000054640', u'ENSMUSG00000004113', u'ENSMUSG00000034656']), NS='BP', pop_items=set([u'ENSMUSG00000031012', u'ENSMUSG00000024112', u'ENSMUSG00000037434', u'ENSMUSG00000057914', u'ENSMUSG00000014158', u'ENSMUSG00000027748', u'ENSMUSG00000015968', u'ENSMUSG00000020111', u'ENSMUSG00000020866', u'ENSMUSG00000028969', u'ENSMUSG00000022416', u'ENSMUSG00000004110', u'ENSMUSG00000054640', u'ENSMUSG00000051331', u'ENSMUSG00000004113', u'ENSMUSG00000021371', u'ENSMUSG00000053004', u'ENSMUSG00000034656', u'ENSMUSG00000049686']), pop_n=13836, p_sm_bonferroni=4.057162471828839e-05, is_obsolete=False, GO='GO:0070509', name='calcium ion import', pop_count=19, alt_ids=[], level=9, depth=9, enrichment='e', Cluster='Late Decrease', geneid_set=set([u'ENSMUSG00000031012', u'ENSMUSG00000024112', u'ENSMUSG00000057914', u'ENSMUSG00000027748', u'ENSMUSG00000022416', u'ENSMUSG00000051331', u'ENSMUSG00000020866', u'ENSMUSG00000015968', u'ENSMUSG00000004110', u'ENSMUSG00000054640', u'ENSMUSG00000004113', u'ENSMUSG00000034656']), symbols=u'Cacna1a Cacna1b Cacna1c Cacna1d Cacna1e Cacna1g Cacna1h Cacna1i Cacnb2 Cask Slc8a1 Trpc4', symbol_set=set([u'Cacna1h', u'Cacna1i', u'Cacnb2', u'Cacna1b', u'Cacna1c', u'Cacna1d', u'Cacna1e', u'Cask', u'Cacna1g', u'Trpc4', u'Cacna1a', u'Slc8a1']), geneids='ENSMUSG00000031012 ENSMUSG00000024112 ENSMUSG00000057914 ENSMUSG00000027748 ENSMUSG00000015968 ENSMUSG00000051331 ENSMUSG00000020866 ENSMUSG00000022416 ENSMUSG00000004110 ENSMUSG00000054640 ENSMUSG00000004113 ENSMUSG00000034656', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=14, D1='G', GO_name='calcium ion import'),
    Nt(p_uncorrected=1.3771023717693195e-05, study_count=7, study_n=1139, namespace='biological_process', p_fdr_bh=0.002370963413031473, study_items=set([u'ENSMUSG00000030209', u'ENSMUSG00000024083', u'ENSMUSG00000022016', u'ENSMUSG00000026163', u'ENSMUSG00000032177', u'ENSMUSG00000023868', u'ENSMUSG00000061603']), NS='BP', pop_items=set([u'ENSMUSG00000030209', u'ENSMUSG00000039166', u'ENSMUSG00000036273', u'ENSMUSG00000024083', u'ENSMUSG00000091636', u'ENSMUSG00000022016', u'ENSMUSG00000018428', u'ENSMUSG00000026163', u'ENSMUSG00000032177', u'ENSMUSG00000023868', u'ENSMUSG00000024847', u'ENSMUSG00000061603']), pop_n=13836, p_sm_bonferroni=0.2086447803467696, is_obsolete=False, GO='GO:0010738', name='regulation of protein kinase A signaling', pop_count=12, alt_ids=[], level=6, depth=7, enrichment='e', Cluster='Late Decrease', geneid_set=set([u'ENSMUSG00000030209', u'ENSMUSG00000022016', u'ENSMUSG00000026163', u'ENSMUSG00000024083', u'ENSMUSG00000032177', u'ENSMUSG00000023868', u'ENSMUSG00000061603']), symbols=u'Akap11 Akap6 Grin2b Pde10a Pde4a Pja2 Sphkap', symbol_set=set([u'Akap6', u'Grin2b', u'Sphkap', u'Akap11', u'Pde4a', u'Pja2', u'Pde10a']), geneids='ENSMUSG00000030209 ENSMUSG00000024083 ENSMUSG00000022016 ENSMUSG00000026163 ENSMUSG00000032177 ENSMUSG00000023868 ENSMUSG00000061603', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=1, D1='A', GO_name='regulation of protein kinase A signaling'),
    Nt(p_uncorrected='', study_count='', study_n='', namespace='', p_fdr_bh='', study_items='', NS='BP', pop_items='', pop_n='', p_sm_bonferroni='', is_obsolete='', GO='GO:0022604', name='', pop_count='', alt_ids='', level=5, depth=5, enrichment='', Cluster='', geneid_set='', symbols='', symbol_set='', geneids='', format_txt=1, hdr_idx=1, is_hdrgo=True, is_usrgo=False, hdr1usr01='*', dcnt=108, D1='A', GO_name='regulation of cell morphogenesis'),
    Nt(p_uncorrected=1.3591492374317983e-05, study_count=17, study_n=1139, namespace='biological_process', p_fdr_bh=0.0023669505857849627, study_items=set([u'ENSMUSG00000024589', u'ENSMUSG00000020704', u'ENSMUSG00000024112', u'ENSMUSG00000021730', u'ENSMUSG00000063142', u'ENSMUSG00000022416', u'ENSMUSG00000037579', u'ENSMUSG00000020651', u'ENSMUSG00000058248', u'ENSMUSG00000020866', u'ENSMUSG00000034656', u'ENSMUSG00000041670', u'ENSMUSG00000030525', u'ENSMUSG00000003378', u'ENSMUSG00000059003', u'ENSMUSG00000024873', u'ENSMUSG00000061576']), NS='BP', pop_items=set([u'ENSMUSG00000059003', u'ENSMUSG00000024112', u'ENSMUSG00000021730', u'ENSMUSG00000019146', u'ENSMUSG00000014444', u'ENSMUSG00000035226', u'ENSMUSG00000028020', u'ENSMUSG00000058248', u'ENSMUSG00000017412', u'ENSMUSG00000020866', u'ENSMUSG00000044708', u'ENSMUSG00000030525', u'ENSMUSG00000003378', u'ENSMUSG00000036196', u'ENSMUSG00000032890', u'ENSMUSG00000024873', u'ENSMUSG00000061576', u'ENSMUSG00000020651', u'ENSMUSG00000034402', u'ENSMUSG00000036273', u'ENSMUSG00000023017', u'ENSMUSG00000001985', u'ENSMUSG00000019848', u'ENSMUSG00000037386', u'ENSMUSG00000026514', u'ENSMUSG00000032892', u'ENSMUSG00000034320', u'ENSMUSG00000022770', u'ENSMUSG00000020734', u'ENSMUSG00000022935', u'ENSMUSG00000034656', u'ENSMUSG00000020591', u'ENSMUSG00000064329', u'ENSMUSG00000027577', u'ENSMUSG00000027950', u'ENSMUSG00000038260', u'ENSMUSG00000059742', u'ENSMUSG00000028051', u'ENSMUSG00000047976', u'ENSMUSG00000031075', u'ENSMUSG00000020331', u'ENSMUSG00000022416', u'ENSMUSG00000026959', u'ENSMUSG00000038319', u'ENSMUSG00000020704', u'ENSMUSG00000033885', u'ENSMUSG00000041482', u'ENSMUSG00000023259', u'ENSMUSG00000027674', u'ENSMUSG00000001901', u'ENSMUSG00000039908', u'ENSMUSG00000037624', u'ENSMUSG00000031930', u'ENSMUSG00000056073', u'ENSMUSG00000037579', u'ENSMUSG00000005357', u'ENSMUSG00000052374', u'ENSMUSG00000024589', u'ENSMUSG00000020664', u'ENSMUSG00000045103', u'ENSMUSG00000063142', u'ENSMUSG00000041670', u'ENSMUSG00000040441', u'ENSMUSG00000006740', u'ENSMUSG00000040569']), pop_n=13836, p_sm_bonferroni=0.20592470096329177, is_obsolete=False, GO='GO:0042391', name='regulation of membrane potential', pop_count=65, alt_ids=[], level=3, depth=3, enrichment='e', Cluster='Late Decrease', geneid_set=set([u'ENSMUSG00000020704', u'ENSMUSG00000024112', u'ENSMUSG00000021730', u'ENSMUSG00000030525', u'ENSMUSG00000058248', u'ENSMUSG00000020866', u'ENSMUSG00000022416', u'ENSMUSG00000003378', u'ENSMUSG00000059003', u'ENSMUSG00000024873', u'ENSMUSG00000061576', u'ENSMUSG00000020651', u'ENSMUSG00000037579', u'ENSMUSG00000024589', u'ENSMUSG00000034656', u'ENSMUSG00000041670', u'ENSMUSG00000063142']), symbols=u'Asic2 Cacna1a Cacna1g Cacna1h Cacna1i Chrna7 Cnih2 Dpp6 Grik5 Grin2a Hcn1 Kcnh1 Kcnh3 Kcnma1 Nedd4l Rims1 Slc26a4', symbol_set=set([u'Cacna1h', u'Cacna1i', u'Cnih2', u'Kcnh1', u'Grin2a', u'Kcnh3', u'Hcn1', u'Cacna1a', u'Grik5', u'Cacna1g', u'Nedd4l', u'Chrna7', u'Slc26a4', u'Kcnma1', 'Asic2', u'Rims1', u'Dpp6']), geneids='ENSMUSG00000024589 ENSMUSG00000020704 ENSMUSG00000024112 ENSMUSG00000021730 ENSMUSG00000063142 ENSMUSG00000030525 ENSMUSG00000037579 ENSMUSG00000020651 ENSMUSG00000058248 ENSMUSG00000020866 ENSMUSG00000034656 ENSMUSG00000041670 ENSMUSG00000022416 ENSMUSG00000003378 ENSMUSG00000059003 ENSMUSG00000024873 ENSMUSG00000061576', format_txt=1, hdr_idx=1, is_hdrgo=True, is_usrgo=True, hdr1usr01='**', dcnt=133, D1='A', GO_name='regulation of membrane potential'),
    Nt(p_uncorrected=1.5179302518319415e-08, study_count=13, study_n=1139, namespace='biological_process', p_fdr_bh=6.388378123751596e-06, study_items=set([u'ENSMUSG00000051790', u'ENSMUSG00000050321', u'ENSMUSG00000063887', u'ENSMUSG00000059456', u'ENSMUSG00000038738', u'ENSMUSG00000022623', u'ENSMUSG00000007207', u'ENSMUSG00000034675', u'ENSMUSG00000041670', u'ENSMUSG00000031302', u'ENSMUSG00000036473', u'ENSMUSG00000020886', u'ENSMUSG00000059003']), NS='BP', pop_items=set([u'ENSMUSG00000059003', u'ENSMUSG00000030093', u'ENSMUSG00000013663', u'ENSMUSG00000007207', u'ENSMUSG00000063887', u'ENSMUSG00000029071', u'ENSMUSG00000022623', u'ENSMUSG00000029053', u'ENSMUSG00000051790', u'ENSMUSG00000031302', u'ENSMUSG00000030806', u'ENSMUSG00000036473', u'ENSMUSG00000042121', u'ENSMUSG00000034675', u'ENSMUSG00000042453', u'ENSMUSG00000022812', u'ENSMUSG00000024109', u'ENSMUSG00000042589', u'ENSMUSG00000038738', u'ENSMUSG00000026959', u'ENSMUSG00000050321', u'ENSMUSG00000059456', u'ENSMUSG00000037386', u'ENSMUSG00000041670', u'ENSMUSG00000020886']), pop_n=13836, p_sm_bonferroni=0.00022998161245505746, is_obsolete=False, GO='GO:2000463', name='positive regulation of excitatory postsynaptic potential', pop_count=25, alt_ids=[], level=5, depth=7, enrichment='e', Cluster='Late Decrease', geneid_set=set([u'ENSMUSG00000051790', u'ENSMUSG00000050321', u'ENSMUSG00000036473', u'ENSMUSG00000041670', u'ENSMUSG00000059456', u'ENSMUSG00000038738', u'ENSMUSG00000007207', u'ENSMUSG00000034675', u'ENSMUSG00000063887', u'ENSMUSG00000031302', u'ENSMUSG00000022623', u'ENSMUSG00000020886', u'ENSMUSG00000059003']), symbols=u'Dbn1 Dlg4 Grin2a Neto1 Nlgn1 Nlgn2 Nlgn3 Ptk2b Rims1 Shank1 Shank3 Stx1a Tbc1d24', symbol_set=set([u'Stx1a', u'Nlgn2', u'Nlgn3', u'Nlgn1', u'Ptk2b', u'Grin2a', u'Tbc1d24', u'Neto1', u'Dbn1', u'Shank3', u'Rims1', u'Shank1', u'Dlg4']), geneids='ENSMUSG00000051790 ENSMUSG00000050321 ENSMUSG00000041670 ENSMUSG00000059456 ENSMUSG00000036473 ENSMUSG00000007207 ENSMUSG00000034675 ENSMUSG00000038738 ENSMUSG00000063887 ENSMUSG00000031302 ENSMUSG00000022623 ENSMUSG00000020886 ENSMUSG00000059003', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=0, D1='A', GO_name='positive regulation of excitatory postsynaptic potential'),
    Nt(p_uncorrected=0.00014812003725583547, study_count=7, study_n=1139, namespace='biological_process', p_fdr_bh=0.018098118423090025, study_items=set([u'ENSMUSG00000019828', u'ENSMUSG00000036095', u'ENSMUSG00000049583', u'ENSMUSG00000034731', u'ENSMUSG00000032532', u'ENSMUSG00000040479', u'ENSMUSG00000022861']), NS='BP', pop_items=set([u'ENSMUSG00000068206', u'ENSMUSG00000040249', u'ENSMUSG00000019828', u'ENSMUSG00000032578', u'ENSMUSG00000036095', u'ENSMUSG00000049583', u'ENSMUSG00000034731', u'ENSMUSG00000000276', u'ENSMUSG00000048376', u'ENSMUSG00000022861', u'ENSMUSG00000049511', u'ENSMUSG00000004815', u'ENSMUSG00000040479', u'ENSMUSG00000025357', u'ENSMUSG00000031616', u'ENSMUSG00000032532']), pop_n=13836, p_sm_bonferroni=1.0, is_obsolete=False, GO='GO:0007205', name='protein kinase C-activating G-protein coupled receptor signaling pathway', pop_count=16, alt_ids=[], level=4, depth=6, enrichment='e', Cluster='Late Decrease', geneid_set=set([u'ENSMUSG00000019828', u'ENSMUSG00000022861', u'ENSMUSG00000036095', u'ENSMUSG00000040479', u'ENSMUSG00000049583', u'ENSMUSG00000034731', u'ENSMUSG00000032532']), symbols=u'Cck Dgkb Dgkg Dgkh Dgkz Grm1 Grm5', symbol_set=set([u'Dgkz', u'Dgkg', u'Dgkh', u'Cck', u'Dgkb', u'Grm5', u'Grm1']), geneids='ENSMUSG00000019828 ENSMUSG00000036095 ENSMUSG00000049583 ENSMUSG00000034731 ENSMUSG00000022861 ENSMUSG00000040479 ENSMUSG00000032532', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=0, D1='AB', GO_name='protein kinase C-activating G-protein coupled receptor signaling pathway'),
    Nt(p_uncorrected=6.370807453023531e-07, study_count=10, study_n=1139, namespace='biological_process', p_fdr_bh=0.00016642086848406813, study_items=set([u'ENSMUSG00000025920', u'ENSMUSG00000061751', u'ENSMUSG00000031284', u'ENSMUSG00000026341', u'ENSMUSG00000027296', u'ENSMUSG00000025372', u'ENSMUSG00000057897', u'ENSMUSG00000002489', u'ENSMUSG00000020152', u'ENSMUSG00000034675']), NS='BP', pop_items=set([u'ENSMUSG00000035064', u'ENSMUSG00000027184', u'ENSMUSG00000061751', u'ENSMUSG00000028613', u'ENSMUSG00000020152', u'ENSMUSG00000002489', u'ENSMUSG00000030309', u'ENSMUSG00000026341', u'ENSMUSG00000031284', u'ENSMUSG00000073125', u'ENSMUSG00000042589', u'ENSMUSG00000027296', u'ENSMUSG00000025372', u'ENSMUSG00000042453', u'ENSMUSG00000057897', u'ENSMUSG00000072964', u'ENSMUSG00000025920', u'ENSMUSG00000034675', u'ENSMUSG00000020745']), pop_n=13836, p_sm_bonferroni=0.009652410372075952, is_obsolete=False, GO='GO:0061003', name='positive regulation of dendritic spine morphogenesis', pop_count=19, alt_ids=[], level=8, depth=12, enrichment='e', Cluster='Late Decrease', geneid_set=set([u'ENSMUSG00000061751', u'ENSMUSG00000020152', u'ENSMUSG00000026341', u'ENSMUSG00000031284', u'ENSMUSG00000027296', u'ENSMUSG00000025372', u'ENSMUSG00000057897', u'ENSMUSG00000002489', u'ENSMUSG00000025920', u'ENSMUSG00000034675']), symbols=u'Actr2 Actr3 Baiap2 Camk2b Dbn1 Itpka Kalrn Pak3 Stau2 Tiam1', symbol_set=set([u'Stau2', u'Kalrn', u'Camk2b', u'Itpka', u'Tiam1', u'Dbn1', u'Baiap2', u'Actr3', u'Actr2', u'Pak3']), geneids='ENSMUSG00000025920 ENSMUSG00000061751 ENSMUSG00000002489 ENSMUSG00000026341 ENSMUSG00000031284 ENSMUSG00000027296 ENSMUSG00000025372 ENSMUSG00000057897 ENSMUSG00000020152 ENSMUSG00000034675', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=0, D1='A', GO_name='positive regulation of dendritic spine morphogenesis'),
    Nt(p_uncorrected=2.904439393630325e-09, study_count=17, study_n=1139, namespace='biological_process', p_fdr_bh=1.5174193535480363e-06, study_items=set([u'ENSMUSG00000059003', u'ENSMUSG00000030209', u'ENSMUSG00000045903', u'ENSMUSG00000028222', u'ENSMUSG00000062232', u'ENSMUSG00000067629', u'ENSMUSG00000021701', u'ENSMUSG00000022208', u'ENSMUSG00000029104', u'ENSMUSG00000051391', u'ENSMUSG00000027296', u'ENSMUSG00000025372', u'ENSMUSG00000032356', u'ENSMUSG00000020524', u'ENSMUSG00000018634', u'ENSMUSG00000022623', u'ENSMUSG00000042700']), NS='BP', pop_items=set([u'ENSMUSG00000034987', u'ENSMUSG00000028222', u'ENSMUSG00000062232', u'ENSMUSG00000037992', u'ENSMUSG00000025372', u'ENSMUSG00000059003', u'ENSMUSG00000022623', u'ENSMUSG00000029104', u'ENSMUSG00000010609', u'ENSMUSG00000037428', u'ENSMUSG00000022208', u'ENSMUSG00000051391', u'ENSMUSG00000033577', u'ENSMUSG00000022240', u'ENSMUSG00000032356', u'ENSMUSG00000048482', u'ENSMUSG00000019969', u'ENSMUSG00000005583', u'ENSMUSG00000018634', u'ENSMUSG00000019433', u'ENSMUSG00000042700', u'ENSMUSG00000030302', u'ENSMUSG00000031393', u'ENSMUSG00000030209', u'ENSMUSG00000021701', u'ENSMUSG00000027296', u'ENSMUSG00000033396', u'ENSMUSG00000026959', u'ENSMUSG00000020524', u'ENSMUSG00000036306', u'ENSMUSG00000045903', u'ENSMUSG00000025551', u'ENSMUSG00000053004', u'ENSMUSG00000042429', u'ENSMUSG00000067629', u'ENSMUSG00000039652', u'ENSMUSG00000020091', u'ENSMUSG00000039542', u'ENSMUSG00000028969']), pop_n=13836, p_sm_bonferroni=4.4005161252893054e-05, is_obsolete=False, GO='GO:0048167', name='regulation of synaptic plasticity', pop_count=39, alt_ids=[], level=3, depth=6, enrichment='e', Cluster='Late Decrease', geneid_set=set([u'ENSMUSG00000030209', u'ENSMUSG00000028222', u'ENSMUSG00000062232', u'ENSMUSG00000021701', u'ENSMUSG00000027296', u'ENSMUSG00000025372', u'ENSMUSG00000059003', u'ENSMUSG00000022623', u'ENSMUSG00000029104', u'ENSMUSG00000020524', u'ENSMUSG00000067629', u'ENSMUSG00000022208', u'ENSMUSG00000051391', u'ENSMUSG00000032356', u'ENSMUSG00000045903', u'ENSMUSG00000018634', u'ENSMUSG00000042700']), symbols=u'Baiap2 Calb1 Crhr1 Gria1 Grin2a Grin2b Htt Itpka Jph4 Npas4 Plk2 Rapgef2 Rasgrf1 Shank3 Sipa1l1 Syngap1 Ywhag', symbol_set=set([u'Itpka', u'Gria1', u'Jph4', u'Sipa1l1', u'Plk2', u'Calb1', u'Ywhag', u'Grin2b', u'Crhr1', u'Grin2a', u'Rapgef2', u'Npas4', u'Baiap2', u'Htt', u'Shank3', u'Syngap1', u'Rasgrf1']), geneids='ENSMUSG00000059003 ENSMUSG00000029104 ENSMUSG00000045903 ENSMUSG00000028222 ENSMUSG00000062232 ENSMUSG00000067629 ENSMUSG00000021701 ENSMUSG00000022208 ENSMUSG00000030209 ENSMUSG00000051391 ENSMUSG00000027296 ENSMUSG00000025372 ENSMUSG00000032356 ENSMUSG00000020524 ENSMUSG00000018634 ENSMUSG00000022623 ENSMUSG00000042700', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=28, D1='A', GO_name='regulation of synaptic plasticity'),
    Nt(p_uncorrected=3.850664079770119e-06, study_count=26, study_n=1139, namespace='biological_process', p_fdr_bh=0.00080693689663426, study_items=set([u'ENSMUSG00000025876', u'ENSMUSG00000062232', u'ENSMUSG00000069227', u'ENSMUSG00000049556', u'ENSMUSG00000022421', u'ENSMUSG00000063887', u'ENSMUSG00000036473', u'ENSMUSG00000048895', u'ENSMUSG00000030020', u'ENSMUSG00000024091', u'ENSMUSG00000056602', u'ENSMUSG00000017167', u'ENSMUSG00000032356', u'ENSMUSG00000041570', u'ENSMUSG00000041609', u'ENSMUSG00000026933', u'ENSMUSG00000031391', u'ENSMUSG00000028960', u'ENSMUSG00000059456', u'ENSMUSG00000042292', u'ENSMUSG00000044433', u'ENSMUSG00000030077', u'ENSMUSG00000024772', u'ENSMUSG00000028833', u'ENSMUSG00000020900', u'ENSMUSG00000032328']), NS='BP', pop_items=set([u'ENSMUSG00000029512', u'ENSMUSG00000029518', u'ENSMUSG00000031065', u'ENSMUSG00000048895', u'ENSMUSG00000030020', u'ENSMUSG00000032547', u'ENSMUSG00000006930', u'ENSMUSG00000056602', u'ENSMUSG00000034958', u'ENSMUSG00000064293', u'ENSMUSG00000070509', u'ENSMUSG00000041609', u'ENSMUSG00000032827', u'ENSMUSG00000020423', u'ENSMUSG00000051379', u'ENSMUSG00000052911', u'ENSMUSG00000042228', u'ENSMUSG00000028745', u'ENSMUSG00000041570', u'ENSMUSG00000026933', u'ENSMUSG00000042292', u'ENSMUSG00000069227', u'ENSMUSG00000032796', u'ENSMUSG00000024772', u'ENSMUSG00000026255', u'ENSMUSG00000020900', u'ENSMUSG00000020366', u'ENSMUSG00000013663', u'ENSMUSG00000062232', u'ENSMUSG00000044433', u'ENSMUSG00000005804', u'ENSMUSG00000028556', u'ENSMUSG00000022421', u'ENSMUSG00000063887', u'ENSMUSG00000067851', u'ENSMUSG00000031565', u'ENSMUSG00000022305', u'ENSMUSG00000028661', u'ENSMUSG00000004771', u'ENSMUSG00000042626', u'ENSMUSG00000067242', u'ENSMUSG00000031391', u'ENSMUSG00000028833', u'ENSMUSG00000090247', u'ENSMUSG00000055022', u'ENSMUSG00000053483', u'ENSMUSG00000031157', u'ENSMUSG00000031095', u'ENSMUSG00000021983', u'ENSMUSG00000001018', u'ENSMUSG00000032479', u'ENSMUSG00000032575', u'ENSMUSG00000036718', u'ENSMUSG00000041488', u'ENSMUSG00000024456', u'ENSMUSG00000031393', u'ENSMUSG00000033278', u'ENSMUSG00000030314', u'ENSMUSG00000026849', u'ENSMUSG00000026697', u'ENSMUSG00000020828', u'ENSMUSG00000018736', u'ENSMUSG00000036473', u'ENSMUSG00000027581', u'ENSMUSG00000053398', u'ENSMUSG00000057531', u'ENSMUSG00000009569', u'ENSMUSG00000022382', u'ENSMUSG00000049556', u'ENSMUSG00000019889', u'ENSMUSG00000079036', u'ENSMUSG00000022324', u'ENSMUSG00000039419', u'ENSMUSG00000038664', u'ENSMUSG00000038982', u'ENSMUSG00000015605', u'ENSMUSG00000027500', u'ENSMUSG00000026667', u'ENSMUSG00000005087', u'ENSMUSG00000026917', u'ENSMUSG00000025809', u'ENSMUSG00000057667', u'ENSMUSG00000002900', u'ENSMUSG00000021097', u'ENSMUSG00000059456', u'ENSMUSG00000022044', u'ENSMUSG00000053024', u'ENSMUSG00000028960', u'ENSMUSG00000039542', u'ENSMUSG00000028969', u'ENSMUSG00000025876', u'ENSMUSG00000035314', u'ENSMUSG00000028364', u'ENSMUSG00000058056', u'ENSMUSG00000016541', u'ENSMUSG00000022892', u'ENSMUSG00000033039', u'ENSMUSG00000030077', u'ENSMUSG00000018012', u'ENSMUSG00000031537', u'ENSMUSG00000026478', u'ENSMUSG00000024256', u'ENSMUSG00000024091', u'ENSMUSG00000017167', u'ENSMUSG00000018820', u'ENSMUSG00000032356', u'ENSMUSG00000005533', u'ENSMUSG00000027859', u'ENSMUSG00000025089', u'ENSMUSG00000038264', u'ENSMUSG00000060708', u'ENSMUSG00000005871', u'ENSMUSG00000025104', u'ENSMUSG00000047139', u'ENSMUSG00000070733', u'ENSMUSG00000057506', u'ENSMUSG00000026276', u'ENSMUSG00000021936', u'ENSMUSG00000022105', u'ENSMUSG00000032328']), pop_n=13836, p_sm_bonferroni=0.058341411472597075, is_obsolete=False, GO='GO:0031175', name='neuron projection development', pop_count=120, alt_ids=[], level=4, depth=4, enrichment='e', Cluster='Late Decrease', geneid_set=set([u'ENSMUSG00000025876', u'ENSMUSG00000026933', u'ENSMUSG00000031391', u'ENSMUSG00000062232', u'ENSMUSG00000044433', u'ENSMUSG00000056602', u'ENSMUSG00000020900', u'ENSMUSG00000022421', u'ENSMUSG00000063887', u'ENSMUSG00000030077', u'ENSMUSG00000036473', u'ENSMUSG00000048895', u'ENSMUSG00000030020', u'ENSMUSG00000041570', u'ENSMUSG00000024091', u'ENSMUSG00000042292', u'ENSMUSG00000069227', u'ENSMUSG00000049556', u'ENSMUSG00000017167', u'ENSMUSG00000059456', u'ENSMUSG00000024772', u'ENSMUSG00000032356', u'ENSMUSG00000028833', u'ENSMUSG00000028960', u'ENSMUSG00000041609', u'ENSMUSG00000032328']), symbols=u'Camsap1 Camsap2 Camsap3 Ccdc64 Cdk5r1 Chl1 Cntnap1 Ehd1 Fry Gprin1 L1cam Lingo1 Mkl1 Myh10 Ncdn Nlgn1 Nptxr Prickle2 Ptk2b Rapgef2 Rasgrf1 Tbc1d24 Tmem30a Ube4b Unc5a Vapa', symbol_set=set([u'Ube4b', u'Gprin1', u'Ncdn', u'Tbc1d24', u'Fry', u'Nlgn1', u'Mkl1', u'Cntnap1', u'Tmem30a', u'Myh10', u'Rasgrf1', u'Ehd1', u'Camsap2', u'Camsap3', u'Camsap1', u'Cdk5r1', u'Chl1', u'Ccdc64', u'Prickle2', u'Lingo1', u'Unc5a', u'Vapa', u'Ptk2b', u'Nptxr', u'Rapgef2', u'L1cam']), geneids='ENSMUSG00000025876 ENSMUSG00000062232 ENSMUSG00000069227 ENSMUSG00000049556 ENSMUSG00000022421 ENSMUSG00000063887 ENSMUSG00000036473 ENSMUSG00000048895 ENSMUSG00000030020 ENSMUSG00000024091 ENSMUSG00000056602 ENSMUSG00000017167 ENSMUSG00000032356 ENSMUSG00000041609 ENSMUSG00000026933 ENSMUSG00000031391 ENSMUSG00000059456 ENSMUSG00000028960 ENSMUSG00000041570 ENSMUSG00000042292 ENSMUSG00000044433 ENSMUSG00000030077 ENSMUSG00000024772 ENSMUSG00000028833 ENSMUSG00000020900 ENSMUSG00000032328', format_txt=1, hdr_idx=1, is_hdrgo=True, is_usrgo=True, hdr1usr01='**', dcnt=15, D1='BCH', GO_name='neuron projection development'),
    Nt(p_uncorrected=1.4514756566138748e-08, study_count=58, study_n=1139, namespace='biological_process', p_fdr_bh=6.283230763816233e-06, study_items=set([u'ENSMUSG00000019699', u'ENSMUSG00000020027', u'ENSMUSG00000041014', u'ENSMUSG00000020785', u'ENSMUSG00000021536', u'ENSMUSG00000053310', u'ENSMUSG00000039145', u'ENSMUSG00000021559', u'ENSMUSG00000032936', u'ENSMUSG00000078816', u'ENSMUSG00000028005', u'ENSMUSG00000057897', u'ENSMUSG00000028519', u'ENSMUSG00000029055', u'ENSMUSG00000005672', u'ENSMUSG00000022637', u'ENSMUSG00000020451', u'ENSMUSG00000021662', u'ENSMUSG00000053137', u'ENSMUSG00000009681', u'ENSMUSG00000027347', u'ENSMUSG00000031511', u'ENSMUSG00000025658', u'ENSMUSG00000027646', u'ENSMUSG00000032500', u'ENSMUSG00000050965', u'ENSMUSG00000032356', u'ENSMUSG00000040479', u'ENSMUSG00000005580', u'ENSMUSG00000061603', u'ENSMUSG00000061751', u'ENSMUSG00000028078', u'ENSMUSG00000024122', u'ENSMUSG00000038128', u'ENSMUSG00000063358', u'ENSMUSG00000038485', u'ENSMUSG00000045038', u'ENSMUSG00000034799', u'ENSMUSG00000039585', u'ENSMUSG00000029602', u'ENSMUSG00000017631', u'ENSMUSG00000052087', u'ENSMUSG00000024242', u'ENSMUSG00000018334', u'ENSMUSG00000021892', u'ENSMUSG00000036095', u'ENSMUSG00000025170', u'ENSMUSG00000052889', u'ENSMUSG00000026527', u'ENSMUSG00000024617', u'ENSMUSG00000031833', u'ENSMUSG00000041992', u'ENSMUSG00000056486', u'ENSMUSG00000004929', u'ENSMUSG00000022861', u'ENSMUSG00000002489', u'ENSMUSG00000020827', u'ENSMUSG00000020580']), NS='BP', pop_items=set([u'ENSMUSG00000033721', u'ENSMUSG00000002012', u'ENSMUSG00000042594', u'ENSMUSG00000003233', u'ENSMUSG00000020937', u'ENSMUSG00000021662', u'ENSMUSG00000020305', u'ENSMUSG00000029516', u'ENSMUSG00000062604', u'ENSMUSG00000062151', u'ENSMUSG00000020190', u'ENSMUSG00000021559', u'ENSMUSG00000032936', u'ENSMUSG00000059495', u'ENSMUSG00000006386', u'ENSMUSG00000020694', u'ENSMUSG00000004508', u'ENSMUSG00000021990', u'ENSMUSG00000023800', u'ENSMUSG00000021180', u'ENSMUSG00000019997', u'ENSMUSG00000036737', u'ENSMUSG00000017631', u'ENSMUSG00000033016', u'ENSMUSG00000020451', u'ENSMUSG00000024070', u'ENSMUSG00000026173', u'ENSMUSG00000021948', u'ENSMUSG00000026311', u'ENSMUSG00000039954', u'ENSMUSG00000005057', u'ENSMUSG00000004266', u'ENSMUSG00000002489', u'ENSMUSG00000026247', u'ENSMUSG00000034247', u'ENSMUSG00000004591', u'ENSMUSG00000004056', u'ENSMUSG00000022376', u'ENSMUSG00000034751', u'ENSMUSG00000053113', u'ENSMUSG00000004951', u'ENSMUSG00000040479', u'ENSMUSG00000020599', u'ENSMUSG00000004815', u'ENSMUSG00000019969', u'ENSMUSG00000020611', u'ENSMUSG00000039145', u'ENSMUSG00000048310', u'ENSMUSG00000020890', u'ENSMUSG00000028530', u'ENSMUSG00000027797', u'ENSMUSG00000024160', u'ENSMUSG00000020372', u'ENSMUSG00000034799', u'ENSMUSG00000032946', u'ENSMUSG00000024042', u'ENSMUSG00000038451', u'ENSMUSG00000058396', u'ENSMUSG00000038128', u'ENSMUSG00000015981', u'ENSMUSG00000024969', u'ENSMUSG00000021215', u'ENSMUSG00000009621', u'ENSMUSG00000013646', u'ENSMUSG00000004677', u'ENSMUSG00000022957', u'ENSMUSG00000022419', u'ENSMUSG00000039585', u'ENSMUSG00000024960', u'ENSMUSG00000042228', u'ENSMUSG00000021219', u'ENSMUSG00000021959', u'ENSMUSG00000021892', u'ENSMUSG00000013698', u'ENSMUSG00000053693', u'ENSMUSG00000021895', u'ENSMUSG00000050711', u'ENSMUSG00000032259', u'ENSMUSG00000037643', u'ENSMUSG00000038910', u'ENSMUSG00000025195', u'ENSMUSG00000023277', u'ENSMUSG00000000276', u'ENSMUSG00000024515', u'ENSMUSG00000022840', u'ENSMUSG00000032413', u'ENSMUSG00000024563', u'ENSMUSG00000038058', u'ENSMUSG00000034330', u'ENSMUSG00000035032', u'ENSMUSG00000026620', u'ENSMUSG00000006494', u'ENSMUSG00000002413', u'ENSMUSG00000020580', u'ENSMUSG00000026094', u'ENSMUSG00000019699', u'ENSMUSG00000041014', u'ENSMUSG00000025880', u'ENSMUSG00000020633', u'ENSMUSG00000024290', u'ENSMUSG00000028249', u'ENSMUSG00000020431', u'ENSMUSG00000030272', u'ENSMUSG00000025915', u'ENSMUSG00000075590', u'ENSMUSG00000021200', u'ENSMUSG00000029055', u'ENSMUSG00000018209', u'ENSMUSG00000004085', u'ENSMUSG00000005672', u'ENSMUSG00000010067', u'ENSMUSG00000028756', u'ENSMUSG00000025730', u'ENSMUSG00000022220', u'ENSMUSG00000037013', u'ENSMUSG00000032562', u'ENSMUSG00000036707', u'ENSMUSG00000019822', u'ENSMUSG00000022490', u'ENSMUSG00000023015', u'ENSMUSG00000027646', u'ENSMUSG00000024190', u'ENSMUSG00000031805', u'ENSMUSG00000031833', u'ENSMUSG00000035112', u'ENSMUSG00000061718', u'ENSMUSG00000026430', u'ENSMUSG00000020700', u'ENSMUSG00000029053', u'ENSMUSG00000024769', u'ENSMUSG00000032312', u'ENSMUSG00000042626', u'ENSMUSG00000051177', u'ENSMUSG00000037989', u'ENSMUSG00000034116', u'ENSMUSG00000009681', u'ENSMUSG00000004952', u'ENSMUSG00000059883', u'ENSMUSG00000025949', u'ENSMUSG00000034853', u'ENSMUSG00000029148', u'ENSMUSG00000039483', u'ENSMUSG00000028469', u'ENSMUSG00000078816', u'ENSMUSG00000066406', u'ENSMUSG00000002688', u'ENSMUSG00000038349', u'ENSMUSG00000026490', u'ENSMUSG00000024006', u'ENSMUSG00000035697', u'ENSMUSG00000029602', u'ENSMUSG00000032578', u'ENSMUSG00000027030', u'ENSMUSG00000036095', u'ENSMUSG00000030815', u'ENSMUSG00000028944', u'ENSMUSG00000000787', u'ENSMUSG00000024186', u'ENSMUSG00000024789', u'ENSMUSG00000041245', u'ENSMUSG00000030750', u'ENSMUSG00000026288', u'ENSMUSG00000056486', u'ENSMUSG00000004929', u'ENSMUSG00000022861', u'ENSMUSG00000031511', u'ENSMUSG00000025537', u'ENSMUSG00000020122', u'ENSMUSG00000048175', u'ENSMUSG00000035109', u'ENSMUSG00000039911', u'ENSMUSG00000020027', u'ENSMUSG00000039831', u'ENSMUSG00000033910', u'ENSMUSG00000024620', u'ENSMUSG00000027931', u'ENSMUSG00000024998', u'ENSMUSG00000021457', u'ENSMUSG00000031309', u'ENSMUSG00000009772', u'ENSMUSG00000004865', u'ENSMUSG00000017677', u'ENSMUSG00000024948', u'ENSMUSG00000002699', u'ENSMUSG00000020827', u'ENSMUSG00000029364', u'ENSMUSG00000031628', u'ENSMUSG00000010609', u'ENSMUSG00000031285', u'ENSMUSG00000017376', u'ENSMUSG00000037003', u'ENSMUSG00000036273', u'ENSMUSG00000035910', u'ENSMUSG00000025658', u'ENSMUSG00000010660', u'ENSMUSG00000032502', u'ENSMUSG00000032500', u'ENSMUSG00000001482', u'ENSMUSG00000033542', u'ENSMUSG00000056153', u'ENSMUSG00000027508', u'ENSMUSG00000020654', u'ENSMUSG00000000149', u'ENSMUSG00000001729', u'ENSMUSG00000032175', u'ENSMUSG00000022329', u'ENSMUSG00000021820', u'ENSMUSG00000027699', u'ENSMUSG00000063065', u'ENSMUSG00000021108', u'ENSMUSG00000061751', u'ENSMUSG00000021448', u'ENSMUSG00000028078', u'ENSMUSG00000027692', u'ENSMUSG00000039621', u'ENSMUSG00000024122', u'ENSMUSG00000005580', u'ENSMUSG00000017400', u'ENSMUSG00000032199', u'ENSMUSG00000034974', u'ENSMUSG00000020785', u'ENSMUSG00000037426', u'ENSMUSG00000057455', u'ENSMUSG00000004633', u'ENSMUSG00000027347', u'ENSMUSG00000024242', u'ENSMUSG00000018334', u'ENSMUSG00000041187', u'ENSMUSG00000016179', u'ENSMUSG00000033781', u'ENSMUSG00000028708', u'ENSMUSG00000033985', u'ENSMUSG00000005413', u'ENSMUSG00000026117', u'ENSMUSG00000034377', u'ENSMUSG00000053414', u'ENSMUSG00000001630', u'ENSMUSG00000040751', u'ENSMUSG00000057897', u'ENSMUSG00000001127', u'ENSMUSG00000022469', u'ENSMUSG00000034761', u'ENSMUSG00000036834', u'ENSMUSG00000014426', u'ENSMUSG00000026527', u'ENSMUSG00000060275', u'ENSMUSG00000028005', u'ENSMUSG00000032911', u'ENSMUSG00000048960', u'ENSMUSG00000053310', u'ENSMUSG00000021536', u'ENSMUSG00000031133', u'ENSMUSG00000029674', u'ENSMUSG00000016933', u'ENSMUSG00000061578', u'ENSMUSG00000019970', u'ENSMUSG00000029471', u'ENSMUSG00000024952', u'ENSMUSG00000024617', u'ENSMUSG00000028519', u'ENSMUSG00000031442', u'ENSMUSG00000029071', u'ENSMUSG00000030509', u'ENSMUSG00000005968', u'ENSMUSG00000036246', u'ENSMUSG00000068206', u'ENSMUSG00000037509', u'ENSMUSG00000040061', u'ENSMUSG00000037112', u'ENSMUSG00000053137', u'ENSMUSG00000045962', u'ENSMUSG00000020032', u'ENSMUSG00000053819', u'ENSMUSG00000035390', u'ENSMUSG00000050965', u'ENSMUSG00000068335', u'ENSMUSG00000026778', u'ENSMUSG00000026779', u'ENSMUSG00000023809', u'ENSMUSG00000038485', u'ENSMUSG00000041997', u'ENSMUSG00000057672', u'ENSMUSG00000003810', u'ENSMUSG00000048379', u'ENSMUSG00000061603', u'ENSMUSG00000022812', u'ENSMUSG00000031659', u'ENSMUSG00000028059', u'ENSMUSG00000021279', u'ENSMUSG00000058099', u'ENSMUSG00000074582', u'ENSMUSG00000032356', u'ENSMUSG00000063358', u'ENSMUSG00000042046', u'ENSMUSG00000009828', u'ENSMUSG00000038145', u'ENSMUSG00000000441', u'ENSMUSG00000029217', u'ENSMUSG00000031453', u'ENSMUSG00000025357', u'ENSMUSG00000028456', u'ENSMUSG00000022994', u'ENSMUSG00000020120', u'ENSMUSG00000053046', u'ENSMUSG00000003644', u'ENSMUSG00000025170', u'ENSMUSG00000022637', u'ENSMUSG00000046997', u'ENSMUSG00000029287', u'ENSMUSG00000030733', u'ENSMUSG00000037104', u'ENSMUSG00000025665', u'ENSMUSG00000028458', u'ENSMUSG00000020888', u'ENSMUSG00000041992', u'ENSMUSG00000044786', u'ENSMUSG00000049044', u'ENSMUSG00000053436', u'ENSMUSG00000061132', u'ENSMUSG00000045038', u'ENSMUSG00000026074', u'ENSMUSG00000052889', u'ENSMUSG00000052087', u'ENSMUSG00000020312']), pop_n=13836, p_sm_bonferroni=0.00021991307673356817, is_obsolete=False, GO='GO:0035556', name='intracellular signal transduction', pop_count=324, alt_ids=['GO:0007242', 'GO:0007243', 'GO:0023013', 'GO:0023034'], level=3, depth=5, enrichment='e', Cluster='Late Decrease', geneid_set=set([u'ENSMUSG00000019699', u'ENSMUSG00000020027', u'ENSMUSG00000041014', u'ENSMUSG00000021536', u'ENSMUSG00000053310', u'ENSMUSG00000020827', u'ENSMUSG00000039145', u'ENSMUSG00000021559', u'ENSMUSG00000032936', u'ENSMUSG00000034799', u'ENSMUSG00000028005', u'ENSMUSG00000057897', u'ENSMUSG00000028519', u'ENSMUSG00000029055', u'ENSMUSG00000005672', u'ENSMUSG00000022637', u'ENSMUSG00000020451', u'ENSMUSG00000021662', u'ENSMUSG00000061751', u'ENSMUSG00000041992', u'ENSMUSG00000053137', u'ENSMUSG00000025658', u'ENSMUSG00000027646', u'ENSMUSG00000032500', u'ENSMUSG00000050965', u'ENSMUSG00000032356', u'ENSMUSG00000040479', u'ENSMUSG00000005580', u'ENSMUSG00000061603', u'ENSMUSG00000002489', u'ENSMUSG00000009681', u'ENSMUSG00000028078', u'ENSMUSG00000024122', u'ENSMUSG00000038128', u'ENSMUSG00000063358', u'ENSMUSG00000038485', u'ENSMUSG00000045038', u'ENSMUSG00000078816', u'ENSMUSG00000020785', u'ENSMUSG00000029602', u'ENSMUSG00000017631', u'ENSMUSG00000024242', u'ENSMUSG00000018334', u'ENSMUSG00000021892', u'ENSMUSG00000039585', u'ENSMUSG00000036095', u'ENSMUSG00000025170', u'ENSMUSG00000026527', u'ENSMUSG00000024617', u'ENSMUSG00000020580', u'ENSMUSG00000031833', u'ENSMUSG00000027347', u'ENSMUSG00000056486', u'ENSMUSG00000004929', u'ENSMUSG00000022861', u'ENSMUSG00000031511', u'ENSMUSG00000052889', u'ENSMUSG00000052087']), symbols=u'Abr Adcy2 Adcy9 Akap6 Akt3 Arhgef28 Arhgef7 Bcr Camk1d Camk2a Camk2b Camk4 Camkk1 Camkv Cblb Chn1 Cnksr2 Dab1 Dapk1 Dclk2 Dclk3 Dgkb Dgkg Dgkz Gucy1b3 Kalrn Kit Ksr1 Limk2 Map4k3 Mapk1 Mapk11 Mast3 Mink1 Myo9a Nrg3 Nrgn Pdpk1 Plch2 Prkca Prkcb Prkce Prkcg Rab40b Rapgef5 Rasal1 Rasgrf1 Rasgrp1 Rgs14 Rgs7 Rock2 Sh3bp5 Socs2 Socs7 Src Thop1 Tiam1 Unc13a', symbol_set=set([u'Dgkz', u'Socs7', u'Dgkb', u'Thop1', u'Socs2', u'Kalrn', u'Src', u'Camk2a', u'Camk2b', u'Camkv', 'Arhgef28', u'Abr', u'Myo9a', u'Rasal1', u'Dab1', u'Kit', u'Dgkg', u'Dapk1', u'Rasgrf1', u'Map4k3', u'Nrgn', u'Limk2', u'Cnksr2', u'Sh3bp5', u'Camkk1', u'Rgs7', u'Mapk11', u'Ksr1', u'Rab40b', u'Mast3', u'Mink1', u'Akap6', u'Prkcb', u'Camk1d', u'Adcy2', u'Prkca', u'Arhgef7', u'Unc13a', u'Prkce', u'Adcy9', 'Prkcg', u'Camk4', u'Plch2', u'Tiam1', u'Chn1', u'Akt3', u'Rock2', u'Pdpk1', u'Bcr', u'Cblb', u'Rgs14', u'Rasgrp1', u'Dclk3', u'Dclk2', u'Rapgef5', u'Mapk1', u'Gucy1b3', u'Nrg3']), geneids='ENSMUSG00000019699 ENSMUSG00000020027 ENSMUSG00000041014 ENSMUSG00000021536 ENSMUSG00000053310 ENSMUSG00000039145 ENSMUSG00000021559 ENSMUSG00000032936 ENSMUSG00000078816 ENSMUSG00000028005 ENSMUSG00000057897 ENSMUSG00000028519 ENSMUSG00000020827 ENSMUSG00000005672 ENSMUSG00000020785 ENSMUSG00000020451 ENSMUSG00000021662 ENSMUSG00000053137 ENSMUSG00000029055 ENSMUSG00000061751 ENSMUSG00000041992 ENSMUSG00000002489 ENSMUSG00000025658 ENSMUSG00000027646 ENSMUSG00000032500 ENSMUSG00000050965 ENSMUSG00000032356 ENSMUSG00000040479 ENSMUSG00000005580 ENSMUSG00000017631 ENSMUSG00000009681 ENSMUSG00000028078 ENSMUSG00000024122 ENSMUSG00000038128 ENSMUSG00000063358 ENSMUSG00000038485 ENSMUSG00000045038 ENSMUSG00000061603 ENSMUSG00000034799 ENSMUSG00000022637 ENSMUSG00000029602 ENSMUSG00000052087 ENSMUSG00000024242 ENSMUSG00000018334 ENSMUSG00000021892 ENSMUSG00000039585 ENSMUSG00000036095 ENSMUSG00000025170 ENSMUSG00000026527 ENSMUSG00000024617 ENSMUSG00000031833 ENSMUSG00000027347 ENSMUSG00000056486 ENSMUSG00000004929 ENSMUSG00000022861 ENSMUSG00000031511 ENSMUSG00000052889 ENSMUSG00000020580', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=137, D1='AB', GO_name='intracellular signal transduction'),
    Nt(p_uncorrected=4.548104950065257e-05, study_count=10, study_n=1139, namespace='biological_process', p_fdr_bh=0.006722874291032251, study_items=set([u'ENSMUSG00000030209', u'ENSMUSG00000050321', u'ENSMUSG00000041670', u'ENSMUSG00000067629', u'ENSMUSG00000049583', u'ENSMUSG00000025889', u'ENSMUSG00000038418', u'ENSMUSG00000057897', u'ENSMUSG00000059003', u'ENSMUSG00000020886']), NS='BP', pop_items=set([u'ENSMUSG00000020716', u'ENSMUSG00000021478', u'ENSMUSG00000031144', u'ENSMUSG00000003037', u'ENSMUSG00000057897', u'ENSMUSG00000059003', u'ENSMUSG00000039358', u'ENSMUSG00000048482', u'ENSMUSG00000004771', u'ENSMUSG00000022935', u'ENSMUSG00000030209', u'ENSMUSG00000017831', u'ENSMUSG00000030265', u'ENSMUSG00000049583', u'ENSMUSG00000022415', u'ENSMUSG00000026959', u'ENSMUSG00000031980', u'ENSMUSG00000038418', u'ENSMUSG00000025889', u'ENSMUSG00000050321', u'ENSMUSG00000032259', u'ENSMUSG00000067629', u'ENSMUSG00000025499', u'ENSMUSG00000056073', u'ENSMUSG00000033208', u'ENSMUSG00000041670', u'ENSMUSG00000020886', u'ENSMUSG00000044708']), pop_n=13836, p_sm_bonferroni=0.689083380984387, is_obsolete=False, GO='GO:0048169', name='regulation of long-term neuronal synaptic plasticity', pop_count=28, alt_ids=[], level=5, depth=8, enrichment='e', Cluster='Late Decrease', geneid_set=set([u'ENSMUSG00000030209', u'ENSMUSG00000050321', u'ENSMUSG00000057897', u'ENSMUSG00000067629', u'ENSMUSG00000049583', u'ENSMUSG00000025889', u'ENSMUSG00000020886', u'ENSMUSG00000041670', u'ENSMUSG00000059003', u'ENSMUSG00000038418']), symbols=u'Camk2b Dlg4 Egr1 Grin2a Grin2b Grm5 Neto1 Rims1 Snca Syngap1', symbol_set=set([u'Syngap1', u'Dlg4', u'Egr1', u'Camk2b', u'Grin2b', u'Grin2a', u'Snca', u'Neto1', u'Grm5', u'Rims1']), geneids='ENSMUSG00000025889 ENSMUSG00000050321 ENSMUSG00000057897 ENSMUSG00000067629 ENSMUSG00000049583 ENSMUSG00000030209 ENSMUSG00000020886 ENSMUSG00000041670 ENSMUSG00000059003 ENSMUSG00000038418', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=2, D1='A', GO_name='regulation of long-term neuronal synaptic plasticity'),
    Nt(p_uncorrected=1.8279698729713566e-07, study_count=11, study_n=1139, namespace='biological_process', p_fdr_bh=5.769910738622713e-05, study_items=set([u'ENSMUSG00000030209', u'ENSMUSG00000050321', u'ENSMUSG00000061751', u'ENSMUSG00000025889', u'ENSMUSG00000024617', u'ENSMUSG00000025318', u'ENSMUSG00000006476', u'ENSMUSG00000032356', u'ENSMUSG00000028833', u'ENSMUSG00000028664', u'ENSMUSG00000020886']), NS='BP', pop_items=set([u'ENSMUSG00000001847', u'ENSMUSG00000050321', u'ENSMUSG00000025586', u'ENSMUSG00000054477', u'ENSMUSG00000061751', u'ENSMUSG00000020886', u'ENSMUSG00000037428', u'ENSMUSG00000030209', u'ENSMUSG00000033208', u'ENSMUSG00000025889', u'ENSMUSG00000006476', u'ENSMUSG00000024617', u'ENSMUSG00000031144', u'ENSMUSG00000053024', u'ENSMUSG00000032356', u'ENSMUSG00000028833', u'ENSMUSG00000028664', u'ENSMUSG00000026959', u'ENSMUSG00000025318', u'ENSMUSG00000031574', u'ENSMUSG00000022812']), pop_n=13836, p_sm_bonferroni=0.0027695571545389023, is_obsolete=False, GO='GO:0048168', name='regulation of neuronal synaptic plasticity', pop_count=21, alt_ids=[], level=4, depth=7, enrichment='e', Cluster='Late Decrease', geneid_set=set([u'ENSMUSG00000030209', u'ENSMUSG00000050321', u'ENSMUSG00000061751', u'ENSMUSG00000025889', u'ENSMUSG00000024617', u'ENSMUSG00000025318', u'ENSMUSG00000006476', u'ENSMUSG00000032356', u'ENSMUSG00000028833', u'ENSMUSG00000028664', u'ENSMUSG00000020886']), symbols=u'Camk2a Dlg4 Ephb2 Grin2b Jph3 Kalrn Ncdn Neto1 Nsmf Rasgrf1 Snca', symbol_set=set([u'Ephb2', 'Nsmf', u'Rasgrf1', u'Kalrn', u'Ncdn', u'Camk2a', u'Grin2b', u'Jph3', u'Snca', u'Neto1', u'Dlg4']), geneids='ENSMUSG00000025889 ENSMUSG00000050321 ENSMUSG00000061751 ENSMUSG00000030209 ENSMUSG00000024617 ENSMUSG00000025318 ENSMUSG00000006476 ENSMUSG00000032356 ENSMUSG00000028833 ENSMUSG00000028664 ENSMUSG00000020886', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=7, D1='A', GO_name='regulation of neuronal synaptic plasticity'),
    Nt(p_uncorrected=3.941213804431076e-06, study_count=8, study_n=1139, namespace='biological_process', p_fdr_bh=0.00080693689663426, study_items=set([u'ENSMUSG00000037541', u'ENSMUSG00000021721', u'ENSMUSG00000060780', u'ENSMUSG00000026596', u'ENSMUSG00000030077', u'ENSMUSG00000002028', u'ENSMUSG00000025318', u'ENSMUSG00000022623']), NS='BP', pop_items=set([u'ENSMUSG00000037541', u'ENSMUSG00000027577', u'ENSMUSG00000036273', u'ENSMUSG00000030854', u'ENSMUSG00000060780', u'ENSMUSG00000002028', u'ENSMUSG00000026596', u'ENSMUSG00000025318', u'ENSMUSG00000022623', u'ENSMUSG00000028351', u'ENSMUSG00000057880', u'ENSMUSG00000001507', u'ENSMUSG00000021721', u'ENSMUSG00000030077']), pop_n=13836, p_sm_bonferroni=0.05971333035093524, is_obsolete=False, GO='GO:0035640', name='exploration behavior', pop_count=14, alt_ids=[], level=3, depth=3, enrichment='e', Cluster='Late Decrease', geneid_set=set([u'ENSMUSG00000037541', u'ENSMUSG00000021721', u'ENSMUSG00000060780', u'ENSMUSG00000026596', u'ENSMUSG00000030077', u'ENSMUSG00000002028', u'ENSMUSG00000025318', u'ENSMUSG00000022623']), symbols=u'Abl2 Chl1 Htr1a Jph3 Kmt2a Lrrtm1 Shank2 Shank3', symbol_set=set(['Kmt2a', u'Htr1a', u'Jph3', u'Lrrtm1', u'Chl1', u'Abl2', u'Shank3', u'Shank2']), geneids='ENSMUSG00000037541 ENSMUSG00000021721 ENSMUSG00000060780 ENSMUSG00000026596 ENSMUSG00000030077 ENSMUSG00000002028 ENSMUSG00000025318 ENSMUSG00000022623', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=1, D1='CN', GO_name='exploration behavior'),
    Nt(p_uncorrected=0.00031773577761303894, study_count=6, study_n=1139, namespace='biological_process', p_fdr_bh=0.034633199759821244, study_items=set([u'ENSMUSG00000051790', u'ENSMUSG00000045038', u'ENSMUSG00000015829', u'ENSMUSG00000018634', u'ENSMUSG00000022623', u'ENSMUSG00000020886']), NS='BP', pop_items=set([u'ENSMUSG00000051790', u'ENSMUSG00000061080', u'ENSMUSG00000036273', u'ENSMUSG00000020886', u'ENSMUSG00000070880', u'ENSMUSG00000035000', u'ENSMUSG00000026904', u'ENSMUSG00000045038', u'ENSMUSG00000001285', u'ENSMUSG00000015829', u'ENSMUSG00000018634', u'ENSMUSG00000022623', u'ENSMUSG00000045573']), pop_n=13836, p_sm_bonferroni=1.0, is_obsolete=False, GO='GO:0035641', name='locomotory exploration behavior', pop_count=13, alt_ids=[], level=3, depth=4, enrichment='e', Cluster='Late Decrease', geneid_set=set([u'ENSMUSG00000051790', u'ENSMUSG00000045038', u'ENSMUSG00000015829', u'ENSMUSG00000018634', u'ENSMUSG00000022623', u'ENSMUSG00000020886']), symbols=u'Crhr1 Dlg4 Nlgn2 Prkce Shank3 Tnr', symbol_set=set([u'Nlgn2', u'Dlg4', u'Tnr', u'Prkce', u'Shank3', u'Crhr1']), geneids='ENSMUSG00000051790 ENSMUSG00000045038 ENSMUSG00000015829 ENSMUSG00000018634 ENSMUSG00000022623 ENSMUSG00000020886', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=0, D1='CN', GO_name='locomotory exploration behavior'),
    Nt(p_uncorrected=7.834939945665469e-06, study_count=8, study_n=1139, namespace='biological_process', p_fdr_bh=0.0014476484770338722, study_items=set([u'ENSMUSG00000059456', u'ENSMUSG00000021559', u'ENSMUSG00000022619', u'ENSMUSG00000032356', u'ENSMUSG00000063887', u'ENSMUSG00000024873', u'ENSMUSG00000031302', u'ENSMUSG00000020886']), NS='BP', pop_items=set([u'ENSMUSG00000021708', u'ENSMUSG00000005583', u'ENSMUSG00000029167', u'ENSMUSG00000000766', u'ENSMUSG00000021680', u'ENSMUSG00000021559', u'ENSMUSG00000022619', u'ENSMUSG00000024109', u'ENSMUSG00000020886', u'ENSMUSG00000063887', u'ENSMUSG00000059456', u'ENSMUSG00000042453', u'ENSMUSG00000031302', u'ENSMUSG00000024873', u'ENSMUSG00000032356']), pop_n=13836, p_sm_bonferroni=0.11870717511677752, is_obsolete=False, GO='GO:2000310', name='regulation of N-methyl-D-aspartate selective glutamate receptor activity', pop_count=15, alt_ids=[], level=5, depth=9, enrichment='e', Cluster='Late Decrease', geneid_set=set([u'ENSMUSG00000059456', u'ENSMUSG00000021559', u'ENSMUSG00000022619', u'ENSMUSG00000020886', u'ENSMUSG00000032356', u'ENSMUSG00000063887', u'ENSMUSG00000031302', u'ENSMUSG00000024873']), symbols=u'Cnih2 Dapk1 Dlg4 Mapk8ip2 Nlgn1 Nlgn3 Ptk2b Rasgrf1', symbol_set=set([u'Cnih2', u'Rasgrf1', u'Nlgn1', u'Ptk2b', u'Dapk1', u'Nlgn3', u'Mapk8ip2', u'Dlg4']), geneids='ENSMUSG00000059456 ENSMUSG00000021559 ENSMUSG00000022619 ENSMUSG00000020886 ENSMUSG00000063887 ENSMUSG00000031302 ENSMUSG00000024873 ENSMUSG00000032356', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=2, D1='A', GO_name='regulation of N-methyl-D-aspartate selective glutamate receptor activity'),
    Nt(p_uncorrected=0.00035577417772678983, study_count=7, study_n=1139, namespace='biological_process', p_fdr_bh=0.03749401315808619, study_items=set([u'ENSMUSG00000051790', u'ENSMUSG00000022619', u'ENSMUSG00000038738', u'ENSMUSG00000063887', u'ENSMUSG00000020827', u'ENSMUSG00000031302', u'ENSMUSG00000024873']), NS='BP', pop_items=set([u'ENSMUSG00000051790', u'ENSMUSG00000020723', u'ENSMUSG00000005583', u'ENSMUSG00000063887', u'ENSMUSG00000019146', u'ENSMUSG00000053395', u'ENSMUSG00000024109', u'ENSMUSG00000069806', u'ENSMUSG00000022619', u'ENSMUSG00000022494', u'ENSMUSG00000026514', u'ENSMUSG00000024873', u'ENSMUSG00000038738', u'ENSMUSG00000046182', u'ENSMUSG00000020827', u'ENSMUSG00000031302', u'ENSMUSG00000066189', u'ENSMUSG00000040373']), pop_n=13836, p_sm_bonferroni=1.0, is_obsolete=False, GO='GO:2000311', name='regulation of alpha-amino-3-hydroxy-5-methyl-4-isoxazole propionate selective glutamate receptor activity', pop_count=18, alt_ids=[], level=5, depth=9, enrichment='e', Cluster='Late Decrease', geneid_set=set([u'ENSMUSG00000051790', u'ENSMUSG00000024873', u'ENSMUSG00000063887', u'ENSMUSG00000020827', u'ENSMUSG00000031302', u'ENSMUSG00000022619', u'ENSMUSG00000038738']), symbols=u'Cnih2 Mapk8ip2 Mink1 Nlgn1 Nlgn2 Nlgn3 Shank1', symbol_set=set([u'Mink1', u'Cnih2', u'Nlgn2', u'Nlgn3', u'Nlgn1', u'Shank1', u'Mapk8ip2']), geneids='ENSMUSG00000051790 ENSMUSG00000022619 ENSMUSG00000038738 ENSMUSG00000063887 ENSMUSG00000020827 ENSMUSG00000031302 ENSMUSG00000024873', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=1, D1='A', GO_name='regulation of alpha-amino-3-hydroxy-5-methyl-4-isoxazole propionate selective glutamate receptor activity'),
    Nt(p_uncorrected=1.315293722016836e-05, study_count=19, study_n=1139, namespace='biological_process', p_fdr_bh=0.0023172110677066376, study_items=set([u'ENSMUSG00000048240', u'ENSMUSG00000019828', u'ENSMUSG00000004113', u'ENSMUSG00000028222', u'ENSMUSG00000026587', u'ENSMUSG00000060780', u'ENSMUSG00000049583', u'ENSMUSG00000029104', u'ENSMUSG00000046230', u'ENSMUSG00000030519', u'ENSMUSG00000024077', u'ENSMUSG00000023033', u'ENSMUSG00000027273', u'ENSMUSG00000074923', u'ENSMUSG00000004110', u'ENSMUSG00000059003', u'ENSMUSG00000022623', u'ENSMUSG00000020886', u'ENSMUSG00000060166']), NS='BP', pop_items=set([u'ENSMUSG00000021010', u'ENSMUSG00000021665', u'ENSMUSG00000013663', u'ENSMUSG00000028222', u'ENSMUSG00000027950', u'ENSMUSG00000024077', u'ENSMUSG00000021478', u'ENSMUSG00000021743', u'ENSMUSG00000031996', u'ENSMUSG00000008734', u'ENSMUSG00000036437', u'ENSMUSG00000022892', u'ENSMUSG00000022982', u'ENSMUSG00000023826', u'ENSMUSG00000013089', u'ENSMUSG00000022623', u'ENSMUSG00000045573', u'ENSMUSG00000000766', u'ENSMUSG00000020283', u'ENSMUSG00000019828', u'ENSMUSG00000059003', u'ENSMUSG00000000552', u'ENSMUSG00000026024', u'ENSMUSG00000022840', u'ENSMUSG00000041235', u'ENSMUSG00000052613', u'ENSMUSG00000033577', u'ENSMUSG00000025630', u'ENSMUSG00000025232', u'ENSMUSG00000018900', u'ENSMUSG00000023033', u'ENSMUSG00000042453', u'ENSMUSG00000027273', u'ENSMUSG00000004110', u'ENSMUSG00000061313', u'ENSMUSG00000004113', u'ENSMUSG00000032172', u'ENSMUSG00000016028', u'ENSMUSG00000030302', u'ENSMUSG00000027577', u'ENSMUSG00000048240', u'ENSMUSG00000035898', u'ENSMUSG00000041380', u'ENSMUSG00000038248', u'ENSMUSG00000026587', u'ENSMUSG00000057880', u'ENSMUSG00000049583', u'ENSMUSG00000029104', u'ENSMUSG00000046230', u'ENSMUSG00000028541', u'ENSMUSG00000038417', u'ENSMUSG00000030519', u'ENSMUSG00000012819', u'ENSMUSG00000039913', u'ENSMUSG00000031748', u'ENSMUSG00000074923', u'ENSMUSG00000033792', u'ENSMUSG00000050541', u'ENSMUSG00000052512', u'ENSMUSG00000022489', u'ENSMUSG00000050272', u'ENSMUSG00000032259', u'ENSMUSG00000060166', u'ENSMUSG00000060780', u'ENSMUSG00000062991', u'ENSMUSG00000028546', u'ENSMUSG00000062014', u'ENSMUSG00000040037', u'ENSMUSG00000034472', u'ENSMUSG00000024897', u'ENSMUSG00000020160', u'ENSMUSG00000068696', u'ENSMUSG00000025579', u'ENSMUSG00000075324', u'ENSMUSG00000025533', u'ENSMUSG00000006818', u'ENSMUSG00000020886', u'ENSMUSG00000064373']), pop_n=13836, p_sm_bonferroni=0.1992801518227708, is_obsolete=False, GO='GO:0007626', name='locomotory behavior', pop_count=78, alt_ids=[], level=2, depth=2, enrichment='e', Cluster='Late Decrease', geneid_set=set([u'ENSMUSG00000048240', u'ENSMUSG00000024077', u'ENSMUSG00000028222', u'ENSMUSG00000026587', u'ENSMUSG00000049583', u'ENSMUSG00000029104', u'ENSMUSG00000030519', u'ENSMUSG00000060166', u'ENSMUSG00000059003', u'ENSMUSG00000074923', u'ENSMUSG00000019828', u'ENSMUSG00000060780', u'ENSMUSG00000046230', u'ENSMUSG00000022623', u'ENSMUSG00000023033', u'ENSMUSG00000027273', u'ENSMUSG00000004110', u'ENSMUSG00000004113', u'ENSMUSG00000020886']), symbols=u'Apba2 Astn1 Cacna1b Cacna1e Calb1 Dlg4 Gng7 Grin2a Grm1 Grm5 Htt Lrrtm1 Pak6 Scn8a Shank3 Snap25 Strn Vps13a Zdhhc8', symbol_set=set([u'Snap25', u'Shank3', u'Grin2a', u'Apba2', u'Zdhhc8', u'Cacna1b', u'Scn8a', u'Cacna1e', u'Calb1', u'Gng7', u'Astn1', u'Htt', u'Lrrtm1', u'Strn', u'Grm5', u'Pak6', u'Vps13a', u'Grm1', u'Dlg4']), geneids='ENSMUSG00000048240 ENSMUSG00000019828 ENSMUSG00000029104 ENSMUSG00000060780 ENSMUSG00000028222 ENSMUSG00000026587 ENSMUSG00000049583 ENSMUSG00000024077 ENSMUSG00000046230 ENSMUSG00000030519 ENSMUSG00000023033 ENSMUSG00000027273 ENSMUSG00000060166 ENSMUSG00000074923 ENSMUSG00000004110 ENSMUSG00000004113 ENSMUSG00000022623 ENSMUSG00000020886 ENSMUSG00000059003', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=16, D1='N', GO_name='locomotory behavior'),
    Nt(p_uncorrected='', study_count='', study_n='', namespace='', p_fdr_bh='', study_items='', NS='BP', pop_items='', pop_n='', p_sm_bonferroni='', is_obsolete='', GO='GO:0006629', name='', pop_count='', alt_ids='', level=3, depth=3, enrichment='', Cluster='', geneid_set='', symbols='', symbol_set='', geneids='', format_txt=1, hdr_idx=1, is_hdrgo=True, is_usrgo=False, hdr1usr01='*', dcnt=661, D1='CD', GO_name='lipid metabolic process'),
    Nt(p_uncorrected=6.456662554004553e-05, study_count=20, study_n=1139, namespace='biological_process', p_fdr_bh=0.009224157521931068, study_items=set([u'ENSMUSG00000026824', u'ENSMUSG00000034187', u'ENSMUSG00000027827', u'ENSMUSG00000045053', u'ENSMUSG00000025221', u'ENSMUSG00000016346', u'ENSMUSG00000037579', u'ENSMUSG00000028033', u'ENSMUSG00000054934', u'ENSMUSG00000074575', u'ENSMUSG00000058248', u'ENSMUSG00000042604', u'ENSMUSG00000043301', u'ENSMUSG00000060882', u'ENSMUSG00000021730', u'ENSMUSG00000062785', u'ENSMUSG00000056258', u'ENSMUSG00000063873', u'ENSMUSG00000063142', u'ENSMUSG00000028931']), NS='BP', pop_items=set([u'ENSMUSG00000018470', u'ENSMUSG00000045246', u'ENSMUSG00000025358', u'ENSMUSG00000050556', u'ENSMUSG00000009731', u'ENSMUSG00000034402', u'ENSMUSG00000040164', u'ENSMUSG00000040907', u'ENSMUSG00000038319', u'ENSMUSG00000042604', u'ENSMUSG00000043673', u'ENSMUSG00000038026', u'ENSMUSG00000063142', u'ENSMUSG00000026812', u'ENSMUSG00000028033', u'ENSMUSG00000053519', u'ENSMUSG00000092083', u'ENSMUSG00000054477', u'ENSMUSG00000009907', u'ENSMUSG00000032412', u'ENSMUSG00000039463', u'ENSMUSG00000041771', u'ENSMUSG00000026824', u'ENSMUSG00000027895', u'ENSMUSG00000040896', u'ENSMUSG00000044216', u'ENSMUSG00000039672', u'ENSMUSG00000056258', u'ENSMUSG00000035681', u'ENSMUSG00000034187', u'ENSMUSG00000000794', u'ENSMUSG00000028631', u'ENSMUSG00000024597', u'ENSMUSG00000038077', u'ENSMUSG00000036760', u'ENSMUSG00000033161', u'ENSMUSG00000027827', u'ENSMUSG00000004655', u'ENSMUSG00000043301', u'ENSMUSG00000001901', u'ENSMUSG00000016346', u'ENSMUSG00000037579', u'ENSMUSG00000017756', u'ENSMUSG00000031791', u'ENSMUSG00000041329', u'ENSMUSG00000049265', u'ENSMUSG00000042529', u'ENSMUSG00000057123', u'ENSMUSG00000003031', u'ENSMUSG00000045053', u'ENSMUSG00000033998', u'ENSMUSG00000040724', u'ENSMUSG00000025221', u'ENSMUSG00000017740', u'ENSMUSG00000013495', u'ENSMUSG00000047959', u'ENSMUSG00000059742', u'ENSMUSG00000058740', u'ENSMUSG00000058743', u'ENSMUSG00000030247', u'ENSMUSG00000002908', u'ENSMUSG00000030249', u'ENSMUSG00000029088', u'ENSMUSG00000063873', u'ENSMUSG00000058248', u'ENSMUSG00000079436', u'ENSMUSG00000020331', u'ENSMUSG00000060882', u'ENSMUSG00000044708', u'ENSMUSG00000021730', u'ENSMUSG00000054934', u'ENSMUSG00000041695', u'ENSMUSG00000024957', u'ENSMUSG00000022342', u'ENSMUSG00000026576', u'ENSMUSG00000079056', u'ENSMUSG00000037610', u'ENSMUSG00000050963', u'ENSMUSG00000062785', u'ENSMUSG00000017765', u'ENSMUSG00000051497', u'ENSMUSG00000058975', u'ENSMUSG00000028051', u'ENSMUSG00000074575', u'ENSMUSG00000047976', u'ENSMUSG00000028420', u'ENSMUSG00000045404', u'ENSMUSG00000028931', u'ENSMUSG00000007097', u'ENSMUSG00000037341', u'ENSMUSG00000052726', u'ENSMUSG00000051726', u'ENSMUSG00000022742', u'ENSMUSG00000037624']), pop_n=13836, p_sm_bonferroni=0.9782489435572299, is_obsolete=False, GO='GO:0006813', name='potassium ion transport', pop_count=94, alt_ids=['GO:0015458'], level=7, depth=7, enrichment='e', Cluster='Late Decrease', geneid_set=set([u'ENSMUSG00000026824', u'ENSMUSG00000021730', u'ENSMUSG00000028033', u'ENSMUSG00000054934', u'ENSMUSG00000074575', u'ENSMUSG00000058248', u'ENSMUSG00000056258', u'ENSMUSG00000028931', u'ENSMUSG00000043301', u'ENSMUSG00000034187', u'ENSMUSG00000027827', u'ENSMUSG00000045053', u'ENSMUSG00000016346', u'ENSMUSG00000037579', u'ENSMUSG00000025221', u'ENSMUSG00000042604', u'ENSMUSG00000063142', u'ENSMUSG00000062785', u'ENSMUSG00000063873', u'ENSMUSG00000060882']), symbols=u'Hcn1 Kcna4 Kcnab1 Kcnab2 Kcnc3 Kcnd2 Kcng1 Kcng3 Kcnh1 Kcnh3 Kcnip2 Kcnj3 Kcnj6 Kcnma1 Kcnmb4 Kcnq2 Kcnq3 Kcnq5 Nsf Slc24a3', symbol_set=set([u'Kcnj3', u'Kcng3', u'Kcnh1', u'Kcnmb4', u'Kcnh3', u'Kcnc3', u'Hcn1', u'Kcng1', u'Kcnq5', u'Kcnab1', u'Kcnq3', u'Nsf', u'Kcnab2', u'Kcnq2', u'Kcnma1', u'Kcnd2', u'Kcna4', u'Slc24a3', u'Kcnip2', u'Kcnj6']), geneids='ENSMUSG00000026824 ENSMUSG00000034187 ENSMUSG00000027827 ENSMUSG00000021730 ENSMUSG00000063142 ENSMUSG00000016346 ENSMUSG00000037579 ENSMUSG00000028033 ENSMUSG00000054934 ENSMUSG00000074575 ENSMUSG00000058248 ENSMUSG00000025221 ENSMUSG00000042604 ENSMUSG00000043301 ENSMUSG00000045053 ENSMUSG00000062785 ENSMUSG00000056258 ENSMUSG00000063873 ENSMUSG00000060882 ENSMUSG00000028931', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=7, D1='G', GO_name='potassium ion transport'),
    Nt(p_uncorrected=4.089421702866741e-09, study_count=68, study_n=1139, namespace='biological_process', p_fdr_bh=2.065294274004466e-06, study_items=set([u'ENSMUSG00000026824', u'ENSMUSG00000024112', u'ENSMUSG00000021730', u'ENSMUSG00000033981', u'ENSMUSG00000032839', u'ENSMUSG00000034145', u'ENSMUSG00000054934', u'ENSMUSG00000058248', u'ENSMUSG00000000197', u'ENSMUSG00000003378', u'ENSMUSG00000055078', u'ENSMUSG00000030525', u'ENSMUSG00000048827', u'ENSMUSG00000003352', u'ENSMUSG00000056258', u'ENSMUSG00000059003', u'ENSMUSG00000019894', u'ENSMUSG00000057378', u'ENSMUSG00000027827', u'ENSMUSG00000028931', u'ENSMUSG00000019943', u'ENSMUSG00000032017', u'ENSMUSG00000045053', u'ENSMUSG00000042604', u'ENSMUSG00000001986', u'ENSMUSG00000030592', u'ENSMUSG00000025221', u'ENSMUSG00000023033', u'ENSMUSG00000043301', u'ENSMUSG00000029211', u'ENSMUSG00000015968', u'ENSMUSG00000004110', u'ENSMUSG00000054640', u'ENSMUSG00000063873', u'ENSMUSG00000024403', u'ENSMUSG00000029151', u'ENSMUSG00000030209', u'ENSMUSG00000020704', u'ENSMUSG00000070570', u'ENSMUSG00000028033', u'ENSMUSG00000074575', u'ENSMUSG00000033676', u'ENSMUSG00000030102', u'ENSMUSG00000062785', u'ENSMUSG00000009647', u'ENSMUSG00000039156', u'ENSMUSG00000030000', u'ENSMUSG00000020524', u'ENSMUSG00000019302', u'ENSMUSG00000033793', u'ENSMUSG00000021313', u'ENSMUSG00000027748', u'ENSMUSG00000004113', u'ENSMUSG00000030376', u'ENSMUSG00000057914', u'ENSMUSG00000041710', u'ENSMUSG00000052459', u'ENSMUSG00000016346', u'ENSMUSG00000037579', u'ENSMUSG00000051331', u'ENSMUSG00000063142', u'ENSMUSG00000049281', u'ENSMUSG00000040118', u'ENSMUSG00000021114', u'ENSMUSG00000020882', u'ENSMUSG00000034656', u'ENSMUSG00000060882', u'ENSMUSG00000041078']), NS='BP', pop_items=set([u'ENSMUSG00000033720', u'ENSMUSG00000023015', u'ENSMUSG00000028020', u'ENSMUSG00000055078', u'ENSMUSG00000050556', u'ENSMUSG00000037242', u'ENSMUSG00000064356', u'ENSMUSG00000064357', u'ENSMUSG00000034402', u'ENSMUSG00000028931', u'ENSMUSG00000040907', u'ENSMUSG00000037408', u'ENSMUSG00000030592', u'ENSMUSG00000051154', u'ENSMUSG00000018770', u'ENSMUSG00000063142', u'ENSMUSG00000030209', u'ENSMUSG00000049686', u'ENSMUSG00000015340', u'ENSMUSG00000006567', u'ENSMUSG00000022094', u'ENSMUSG00000018459', u'ENSMUSG00000053519', u'ENSMUSG00000031343', u'ENSMUSG00000052459', u'ENSMUSG00000006611', u'ENSMUSG00000060961', u'ENSMUSG00000056073', u'ENSMUSG00000026389', u'ENSMUSG00000032412', u'ENSMUSG00000018585', u'ENSMUSG00000018589', u'ENSMUSG00000021339', u'ENSMUSG00000058248', u'ENSMUSG00000019210', u'ENSMUSG00000005802', u'ENSMUSG00000056258', u'ENSMUSG00000003352', u'ENSMUSG00000003617', u'ENSMUSG00000009687', u'ENSMUSG00000020402', u'ENSMUSG00000036760', u'ENSMUSG00000025189', u'ENSMUSG00000000563', u'ENSMUSG00000033161', u'ENSMUSG00000089774', u'ENSMUSG00000029221', u'ENSMUSG00000041654', u'ENSMUSG00000025781', u'ENSMUSG00000039105', u'ENSMUSG00000026614', u'ENSMUSG00000032741', u'ENSMUSG00000059363', u'ENSMUSG00000036565', u'ENSMUSG00000046480', u'ENSMUSG00000028096', u'ENSMUSG00000013275', u'ENSMUSG00000042644', u'ENSMUSG00000021629', u'ENSMUSG00000063354', u'ENSMUSG00000006057', u'ENSMUSG00000059742', u'ENSMUSG00000024121', u'ENSMUSG00000030247', u'ENSMUSG00000064267', u'ENSMUSG00000022935', u'ENSMUSG00000052310', u'ENSMUSG00000031934', u'ENSMUSG00000040118', u'ENSMUSG00000038717', u'ENSMUSG00000060882', u'ENSMUSG00000044708', u'ENSMUSG00000030237', u'ENSMUSG00000030235', u'ENSMUSG00000034145', u'ENSMUSG00000063796', u'ENSMUSG00000022890', u'ENSMUSG00000031209', u'ENSMUSG00000036196', u'ENSMUSG00000026576', u'ENSMUSG00000031684', u'ENSMUSG00000022199', u'ENSMUSG00000019943', u'ENSMUSG00000002984', u'ENSMUSG00000061171', u'ENSMUSG00000024403', u'ENSMUSG00000001138', u'ENSMUSG00000022758', u'ENSMUSG00000027577', u'ENSMUSG00000038260', u'ENSMUSG00000058975', u'ENSMUSG00000009647', u'ENSMUSG00000040693', u'ENSMUSG00000029212', u'ENSMUSG00000058441', u'ENSMUSG00000029211', u'ENSMUSG00000025572', u'ENSMUSG00000022949', u'ENSMUSG00000054414', u'ENSMUSG00000020723', u'ENSMUSG00000028854', u'ENSMUSG00000037624', u'ENSMUSG00000007653', u'ENSMUSG00000032839', u'ENSMUSG00000054894', u'ENSMUSG00000059003', u'ENSMUSG00000036534', u'ENSMUSG00000025993', u'ENSMUSG00000024270', u'ENSMUSG00000001985', u'ENSMUSG00000016252', u'ENSMUSG00000038319', u'ENSMUSG00000042604', u'ENSMUSG00000062683', u'ENSMUSG00000004110', u'ENSMUSG00000004113', u'ENSMUSG00000028033', u'ENSMUSG00000000560', u'ENSMUSG00000092083', u'ENSMUSG00000027716', u'ENSMUSG00000015653', u'ENSMUSG00000049281', u'ENSMUSG00000040569', u'ENSMUSG00000010803', u'ENSMUSG00000021474', u'ENSMUSG00000024112', u'ENSMUSG00000027895', u'ENSMUSG00000040896', u'ENSMUSG00000038267', u'ENSMUSG00000063698', u'ENSMUSG00000030376', u'ENSMUSG00000004567', u'ENSMUSG00000019087', u'ENSMUSG00000030287', u'ENSMUSG00000023017', u'ENSMUSG00000032017', u'ENSMUSG00000040414', u'ENSMUSG00000036026', u'ENSMUSG00000021771', u'ENSMUSG00000030302', u'ENSMUSG00000015575', u'ENSMUSG00000033379', u'ENSMUSG00000020524', u'ENSMUSG00000034591', u'ENSMUSG00000032570', u'ENSMUSG00000047037', u'ENSMUSG00000001260', u'ENSMUSG00000025790', u'ENSMUSG00000020411', u'ENSMUSG00000010064', u'ENSMUSG00000010066', u'ENSMUSG00000030650', u'ENSMUSG00000025892', u'ENSMUSG00000025221', u'ENSMUSG00000027130', u'ENSMUSG00000002105', u'ENSMUSG00000020704', u'ENSMUSG00000047959', u'ENSMUSG00000032754', u'ENSMUSG00000035805', u'ENSMUSG00000046079', u'ENSMUSG00000030000', u'ENSMUSG00000020805', u'ENSMUSG00000044216', u'ENSMUSG00000036578', u'ENSMUSG00000006641', u'ENSMUSG00000041736', u'ENSMUSG00000027340', u'ENSMUSG00000038497', u'ENSMUSG00000013495', u'ENSMUSG00000070639', u'ENSMUSG00000021730', u'ENSMUSG00000021733', u'ENSMUSG00000054934', u'ENSMUSG00000031997', u'ENSMUSG00000030500', u'ENSMUSG00000027827', u'ENSMUSG00000050963', u'ENSMUSG00000004285', u'ENSMUSG00000017765', u'ENSMUSG00000026065', u'ENSMUSG00000021541', u'ENSMUSG00000030340', u'ENSMUSG00000024069', u'ENSMUSG00000074575', u'ENSMUSG00000018470', u'ENSMUSG00000021371', u'ENSMUSG00000019302', u'ENSMUSG00000023169', u'ENSMUSG00000064105', u'ENSMUSG00000038257', u'ENSMUSG00000048827', u'ENSMUSG00000003378', u'ENSMUSG00000003072', u'ENSMUSG00000009731', u'ENSMUSG00000057378', u'ENSMUSG00000018900', u'ENSMUSG00000034659', u'ENSMUSG00000041078', u'ENSMUSG00000015968', u'ENSMUSG00000046822', u'ENSMUSG00000043673', u'ENSMUSG00000034656', u'ENSMUSG00000033147', u'ENSMUSG00000038690', u'ENSMUSG00000033792', u'ENSMUSG00000033793', u'ENSMUSG00000054477', u'ENSMUSG00000048677', u'ENSMUSG00000045246', u'ENSMUSG00000025212', u'ENSMUSG00000036570', u'ENSMUSG00000033486', u'ENSMUSG00000022843', u'ENSMUSG00000021114', u'ENSMUSG00000041771', u'ENSMUSG00000033981', u'ENSMUSG00000014444', u'ENSMUSG00000009292', u'ENSMUSG00000035594', u'ENSMUSG00000025036', u'ENSMUSG00000039672', u'ENSMUSG00000005674', u'ENSMUSG00000035681', u'ENSMUSG00000068323', u'ENSMUSG00000023267', u'ENSMUSG00000035112', u'ENSMUSG00000020734', u'ENSMUSG00000032313', u'ENSMUSG00000028962', u'ENSMUSG00000064329', u'ENSMUSG00000027884', u'ENSMUSG00000038077', u'ENSMUSG00000006273', u'ENSMUSG00000055026', u'ENSMUSG00000042246', u'ENSMUSG00000004319', u'ENSMUSG00000004317', u'ENSMUSG00000017756', u'ENSMUSG00000061306', u'ENSMUSG00000002771', u'ENSMUSG00000019935', u'ENSMUSG00000075224', u'ENSMUSG00000038115', u'ENSMUSG00000034714', u'ENSMUSG00000039908', u'ENSMUSG00000001986', u'ENSMUSG00000029151', u'ENSMUSG00000021991', u'ENSMUSG00000019894', u'ENSMUSG00000034320', u'ENSMUSG00000033998', u'ENSMUSG00000040724', u'ENSMUSG00000007041', u'ENSMUSG00000025428', u'ENSMUSG00000032269', u'ENSMUSG00000058740', u'ENSMUSG00000038366', u'ENSMUSG00000058743', u'ENSMUSG00000020788', u'ENSMUSG00000022452', u'ENSMUSG00000024327', u'ENSMUSG00000034566', u'ENSMUSG00000079436', u'ENSMUSG00000000605', u'ENSMUSG00000020331', u'ENSMUSG00000025393', u'ENSMUSG00000020334', u'ENSMUSG00000019146', u'ENSMUSG00000029470', u'ENSMUSG00000041695', u'ENSMUSG00000033033', u'ENSMUSG00000000197', u'ENSMUSG00000024957', u'ENSMUSG00000013160', u'ENSMUSG00000045665', u'ENSMUSG00000049872', u'ENSMUSG00000079055', u'ENSMUSG00000079056', u'ENSMUSG00000034462', u'ENSMUSG00000051497', u'ENSMUSG00000028051', u'ENSMUSG00000031791', u'ENSMUSG00000030452', u'ENSMUSG00000030102', u'ENSMUSG00000045404', u'ENSMUSG00000007097', u'ENSMUSG00000037344', u'ENSMUSG00000037434', u'ENSMUSG00000037341', u'ENSMUSG00000027994', u'ENSMUSG00000030428', u'ENSMUSG00000026177', u'ENSMUSG00000064210', u'ENSMUSG00000006576', u'ENSMUSG00000070304', u'ENSMUSG00000090122', u'ENSMUSG00000031775', u'ENSMUSG00000029054', u'ENSMUSG00000018507', u'ENSMUSG00000052428', u'ENSMUSG00000040164', u'ENSMUSG00000020111', u'ENSMUSG00000075316', u'ENSMUSG00000038023', u'ENSMUSG00000054640', u'ENSMUSG00000063873', u'ENSMUSG00000038026', u'ENSMUSG00000028532', u'ENSMUSG00000031075', u'ENSMUSG00000048833', u'ENSMUSG00000026959', u'ENSMUSG00000032554', u'ENSMUSG00000036636', u'ENSMUSG00000039463', u'ENSMUSG00000039347', u'ENSMUSG00000066150', u'ENSMUSG00000066152', u'ENSMUSG00000026824', u'ENSMUSG00000020432', u'ENSMUSG00000020436', u'ENSMUSG00000019194', u'ENSMUSG00000000794', u'ENSMUSG00000000792', u'ENSMUSG00000050856', u'ENSMUSG00000028631', u'ENSMUSG00000037656', u'ENSMUSG00000014158', u'ENSMUSG00000066705', u'ENSMUSG00000024597', u'ENSMUSG00000033676', u'ENSMUSG00000043301', u'ENSMUSG00000070570', u'ENSMUSG00000023259', u'ENSMUSG00000041710', u'ENSMUSG00000016346', u'ENSMUSG00000037579', u'ENSMUSG00000045962', u'ENSMUSG00000041329', u'ENSMUSG00000041482', u'ENSMUSG00000049265', u'ENSMUSG00000042529', u'ENSMUSG00000008892', u'ENSMUSG00000069806', u'ENSMUSG00000030525', u'ENSMUSG00000045053', u'ENSMUSG00000027748', u'ENSMUSG00000053395', u'ENSMUSG00000023030', u'ENSMUSG00000023032', u'ENSMUSG00000023033', u'ENSMUSG00000022132', u'ENSMUSG00000017740', u'ENSMUSG00000019734', u'ENSMUSG00000026519', u'ENSMUSG00000027950', u'ENSMUSG00000022295', u'ENSMUSG00000053897', u'ENSMUSG00000021313', u'ENSMUSG00000051331', u'ENSMUSG00000002908', u'ENSMUSG00000054720', u'ENSMUSG00000029088', u'ENSMUSG00000071424', u'ENSMUSG00000026463', u'ENSMUSG00000057914', u'ENSMUSG00000032511', u'ENSMUSG00000029016', u'ENSMUSG00000031129', u'ENSMUSG00000026904', u'ENSMUSG00000028420', u'ENSMUSG00000017412', u'ENSMUSG00000019558', u'ENSMUSG00000022342', u'ENSMUSG00000022956', u'ENSMUSG00000037610', u'ENSMUSG00000062785', u'ENSMUSG00000066189', u'ENSMUSG00000029468', u'ENSMUSG00000029467', u'ENSMUSG00000039156', u'ENSMUSG00000047976', u'ENSMUSG00000033007', u'ENSMUSG00000023959', u'ENSMUSG00000031532', u'ENSMUSG00000042682', u'ENSMUSG00000022462', u'ENSMUSG00000025986', u'ENSMUSG00000030987', u'ENSMUSG00000030737', u'ENSMUSG00000027163', u'ENSMUSG00000051726', u'ENSMUSG00000020882', u'ENSMUSG00000027365', u'ENSMUSG00000040373']), pop_n=13836, p_sm_bonferroni=6.195882822013399e-05, is_obsolete=False, GO='GO:0006811', name='ion transport', pop_count=395, alt_ids=[], level=4, depth=4, enrichment='e', Cluster='Late Decrease', geneid_set=set([u'ENSMUSG00000032839', u'ENSMUSG00000055078', u'ENSMUSG00000030525', u'ENSMUSG00000029151', u'ENSMUSG00000003378', u'ENSMUSG00000059003', u'ENSMUSG00000019894', u'ENSMUSG00000057378', u'ENSMUSG00000028931', u'ENSMUSG00000027748', u'ENSMUSG00000025221', u'ENSMUSG00000001986', u'ENSMUSG00000030592', u'ENSMUSG00000042604', u'ENSMUSG00000023033', u'ENSMUSG00000041078', u'ENSMUSG00000015968', u'ENSMUSG00000004110', u'ENSMUSG00000054640', u'ENSMUSG00000029211', u'ENSMUSG00000063142', u'ENSMUSG00000004113', u'ENSMUSG00000030209', u'ENSMUSG00000020704', u'ENSMUSG00000028033', u'ENSMUSG00000021313', u'ENSMUSG00000051331', u'ENSMUSG00000030000', u'ENSMUSG00000033793', u'ENSMUSG00000063873', u'ENSMUSG00000030376', u'ENSMUSG00000057914', u'ENSMUSG00000052459', u'ENSMUSG00000033981', u'ENSMUSG00000034656', u'ENSMUSG00000049281', u'ENSMUSG00000040118', u'ENSMUSG00000021114', u'ENSMUSG00000060882', u'ENSMUSG00000026824', u'ENSMUSG00000024112', u'ENSMUSG00000021730', u'ENSMUSG00000048827', u'ENSMUSG00000034145', u'ENSMUSG00000054934', u'ENSMUSG00000058248', u'ENSMUSG00000000197', u'ENSMUSG00000056258', u'ENSMUSG00000003352', u'ENSMUSG00000027827', u'ENSMUSG00000043301', u'ENSMUSG00000019943', u'ENSMUSG00000032017', u'ENSMUSG00000062785', u'ENSMUSG00000024403', u'ENSMUSG00000039156', u'ENSMUSG00000074575', u'ENSMUSG00000033676', u'ENSMUSG00000030102', u'ENSMUSG00000009647', u'ENSMUSG00000020524', u'ENSMUSG00000019302', u'ENSMUSG00000045053', u'ENSMUSG00000070570', u'ENSMUSG00000041710', u'ENSMUSG00000016346', u'ENSMUSG00000037579', u'ENSMUSG00000020882']), symbols=u'Add2 Asic2 Atp2b1 Atp6v0a1 Atp6v1a Atp6v1d Atp6v1g2 Atp6v1h Cacna1a Cacna1b Cacna1c Cacna1d Cacna1e Cacna1h Cacna2d1 Cacnb1 Cacnb2 Cacnb3 Chrna7 Gabra4 Gabra5 Gabrb3 Gria1 Gria2 Gria3 Grid1 Grik4 Grik5 Grin2a Grin2b Hcn1 Itpr1 Kcna4 Kcnab1 Kcnab2 Kcnc3 Kcnd2 Kcng1 Kcng3 Kcnh1 Kcnh3 Kcnip2 Kcnj3 Kcnj6 Kcnma1 Kcnmb4 Kcnq2 Kcnq3 Kcnq5 Mcu Nalcn Pkd1l3 Ryr1 Ryr2 Ryr3 Scn3b Scn8a Slc17a7 Slc24a3 Slc30a3 Slc6a15 Slc8a1 Slc8a2 Stim2 Tmem63c Trpc1 Trpc4 Trpc5', symbol_set=set([u'Kcnj3', u'Atp6v1d', u'Gria1', u'Atp6v1a', u'Kcnj6', u'Kcnh3', u'Pkd1l3', u'Cacna1a', u'Cacna1b', u'Cacna1c', u'Cacna1d', u'Cacna1e', u'Slc24a3', u'Gabra5', u'Stim2', u'Kcnh1', u'Gabrb3', u'Slc6a15', u'Itpr1', u'Grid1', u'Kcnmb4', u'Kcnc3', u'Ryr1', u'Cacnb2', u'Ryr3', u'Ryr2', u'Scn8a', u'Cacnb1', 'Asic2', u'Grin2b', u'Cacna1h', u'Grin2a', u'Scn3b', u'Trpc4', u'Trpc5', u'Kcna4', u'Cacna2d1', u'Slc30a3', u'Atp6v0a1', u'Kcnq3', u'Slc17a7', u'Add2', u'Grik4', u'Kcnab1', u'Grik5', u'Kcnab2', u'Chrna7', u'Slc8a1', u'Gabra4', u'Slc8a2', 'Mcu', u'Atp6v1h', u'Kcng3', u'Tmem63c', u'Kcnd2', u'Nalcn', u'Gria2', u'Gria3', u'Kcnq5', u'Kcnq2', u'Kcnma1', u'Hcn1', u'Cacnb3', u'Atp6v1g2', u'Kcng1', u'Atp2b1', u'Trpc1', u'Kcnip2']), geneids='ENSMUSG00000026824 ENSMUSG00000043301 ENSMUSG00000024112 ENSMUSG00000021730 ENSMUSG00000058248 ENSMUSG00000033981 ENSMUSG00000033793 ENSMUSG00000030525 ENSMUSG00000034145 ENSMUSG00000054934 ENSMUSG00000030376 ENSMUSG00000000197 ENSMUSG00000045053 ENSMUSG00000003352 ENSMUSG00000029151 ENSMUSG00000003378 ENSMUSG00000056258 ENSMUSG00000059003 ENSMUSG00000019894 ENSMUSG00000032839 ENSMUSG00000063873 ENSMUSG00000027827 ENSMUSG00000028931 ENSMUSG00000019943 ENSMUSG00000032017 ENSMUSG00000042604 ENSMUSG00000001986 ENSMUSG00000030592 ENSMUSG00000025221 ENSMUSG00000023033 ENSMUSG00000041078 ENSMUSG00000015968 ENSMUSG00000004110 ENSMUSG00000054640 ENSMUSG00000024403 ENSMUSG00000034656 ENSMUSG00000057378 ENSMUSG00000030209 ENSMUSG00000020704 ENSMUSG00000074575 ENSMUSG00000028033 ENSMUSG00000021313 ENSMUSG00000033676 ENSMUSG00000030102 ENSMUSG00000051331 ENSMUSG00000009647 ENSMUSG00000039156 ENSMUSG00000030000 ENSMUSG00000020524 ENSMUSG00000019302 ENSMUSG00000029211 ENSMUSG00000070570 ENSMUSG00000004113 ENSMUSG00000052459 ENSMUSG00000057914 ENSMUSG00000041710 ENSMUSG00000048827 ENSMUSG00000016346 ENSMUSG00000037579 ENSMUSG00000062785 ENSMUSG00000063142 ENSMUSG00000049281 ENSMUSG00000040118 ENSMUSG00000021114 ENSMUSG00000020882 ENSMUSG00000027748 ENSMUSG00000060882 ENSMUSG00000055078', format_txt=1, hdr_idx=1, is_hdrgo=True, is_usrgo=True, hdr1usr01='**', dcnt=657, D1='G', GO_name='ion transport'),
    Nt(p_uncorrected=5.4811850339899943e-11, study_count=33, study_n=1139, namespace='biological_process', p_fdr_bh=1.3778716776436982e-07, study_items=set([u'ENSMUSG00000024112', u'ENSMUSG00000032839', u'ENSMUSG00000030376', u'ENSMUSG00000000197', u'ENSMUSG00000024617', u'ENSMUSG00000057897', u'ENSMUSG00000030525', u'ENSMUSG00000048827', u'ENSMUSG00000003352', u'ENSMUSG00000059003', u'ENSMUSG00000057378', u'ENSMUSG00000019943', u'ENSMUSG00000030592', u'ENSMUSG00000015968', u'ENSMUSG00000004110', u'ENSMUSG00000054640', u'ENSMUSG00000004113', u'ENSMUSG00000034656', u'ENSMUSG00000030209', u'ENSMUSG00000039156', u'ENSMUSG00000021313', u'ENSMUSG00000030102', u'ENSMUSG00000051331', u'ENSMUSG00000009647', u'ENSMUSG00000022416', u'ENSMUSG00000063873', u'ENSMUSG00000057914', u'ENSMUSG00000041710', u'ENSMUSG00000028161', u'ENSMUSG00000040118', u'ENSMUSG00000020882', u'ENSMUSG00000052889', u'ENSMUSG00000027748']), NS='BP', pop_items=set([u'ENSMUSG00000032839', u'ENSMUSG00000057897', u'ENSMUSG00000048827', u'ENSMUSG00000018507', u'ENSMUSG00000059003', u'ENSMUSG00000033016', u'ENSMUSG00000057378', u'ENSMUSG00000003161', u'ENSMUSG00000052428', u'ENSMUSG00000030592', u'ENSMUSG00000020111', u'ENSMUSG00000021820', u'ENSMUSG00000015968', u'ENSMUSG00000004110', u'ENSMUSG00000054640', u'ENSMUSG00000004113', u'ENSMUSG00000034656', u'ENSMUSG00000030209', u'ENSMUSG00000049686', u'ENSMUSG00000022416', u'ENSMUSG00000026959', u'ENSMUSG00000018340', u'ENSMUSG00000028532', u'ENSMUSG00000052821', u'ENSMUSG00000048677', u'ENSMUSG00000027716', u'ENSMUSG00000033486', u'ENSMUSG00000041771', u'ENSMUSG00000024112', u'ENSMUSG00000027950', u'ENSMUSG00000037996', u'ENSMUSG00000009292', u'ENSMUSG00000030376', u'ENSMUSG00000003352', u'ENSMUSG00000004567', u'ENSMUSG00000038260', u'ENSMUSG00000030287', u'ENSMUSG00000023017', u'ENSMUSG00000014158', u'ENSMUSG00000039579', u'ENSMUSG00000030302', u'ENSMUSG00000031997', u'ENSMUSG00000034353', u'ENSMUSG00000041710', u'ENSMUSG00000032570', u'ENSMUSG00000024617', u'ENSMUSG00000009647', u'ENSMUSG00000079227', u'ENSMUSG00000020723', u'ENSMUSG00000032741', u'ENSMUSG00000069806', u'ENSMUSG00000030525', u'ENSMUSG00000010066', u'ENSMUSG00000021991', u'ENSMUSG00000030707', u'ENSMUSG00000027748', u'ENSMUSG00000053395', u'ENSMUSG00000042644', u'ENSMUSG00000059588', u'ENSMUSG00000032754', u'ENSMUSG00000021313', u'ENSMUSG00000051331', u'ENSMUSG00000020788', u'ENSMUSG00000022452', u'ENSMUSG00000063873', u'ENSMUSG00000026463', u'ENSMUSG00000057914', u'ENSMUSG00000031934', u'ENSMUSG00000000197', u'ENSMUSG00000040118', u'ENSMUSG00000001240', u'ENSMUSG00000019146', u'ENSMUSG00000016933', u'ENSMUSG00000029470', u'ENSMUSG00000017412', u'ENSMUSG00000032855', u'ENSMUSG00000010609', u'ENSMUSG00000019943', u'ENSMUSG00000053819', u'ENSMUSG00000050234', u'ENSMUSG00000034462', u'ENSMUSG00000066189', u'ENSMUSG00000027577', u'ENSMUSG00000029468', u'ENSMUSG00000021541', u'ENSMUSG00000029467', u'ENSMUSG00000039156', u'ENSMUSG00000030102', u'ENSMUSG00000012819', u'ENSMUSG00000021371', u'ENSMUSG00000079055', u'ENSMUSG00000031532', u'ENSMUSG00000042682', u'ENSMUSG00000030987', u'ENSMUSG00000027994', u'ENSMUSG00000028161', u'ENSMUSG00000020882', u'ENSMUSG00000007655', u'ENSMUSG00000052889', u'ENSMUSG00000027365', u'ENSMUSG00000040373']), pop_n=13836, p_sm_bonferroni=8.304543444998241e-07, is_obsolete=False, GO='GO:0006816', name='calcium ion transport', pop_count=101, alt_ids=[], level=8, depth=8, enrichment='e', Cluster='Late Decrease', geneid_set=set([u'ENSMUSG00000024112', u'ENSMUSG00000032839', u'ENSMUSG00000030376', u'ENSMUSG00000000197', u'ENSMUSG00000028161', u'ENSMUSG00000057897', u'ENSMUSG00000030525', u'ENSMUSG00000048827', u'ENSMUSG00000003352', u'ENSMUSG00000059003', u'ENSMUSG00000057378', u'ENSMUSG00000019943', u'ENSMUSG00000030592', u'ENSMUSG00000015968', u'ENSMUSG00000004110', u'ENSMUSG00000054640', u'ENSMUSG00000004113', u'ENSMUSG00000034656', u'ENSMUSG00000030209', u'ENSMUSG00000039156', u'ENSMUSG00000021313', u'ENSMUSG00000030102', u'ENSMUSG00000051331', u'ENSMUSG00000009647', u'ENSMUSG00000022416', u'ENSMUSG00000063873', u'ENSMUSG00000057914', u'ENSMUSG00000041710', u'ENSMUSG00000024617', u'ENSMUSG00000040118', u'ENSMUSG00000020882', u'ENSMUSG00000052889', u'ENSMUSG00000027748']), symbols=u'Atp2b1 Cacna1a Cacna1b Cacna1c Cacna1d Cacna1e Cacna1h Cacna1i Cacna2d1 Cacnb1 Cacnb2 Cacnb3 Camk2a Camk2b Chrna7 Grin2a Grin2b Itpr1 Mcu Nalcn Pkd1l3 Ppp3ca Prkcb Ryr1 Ryr2 Ryr3 Slc24a3 Slc8a1 Slc8a2 Stim2 Trpc1 Trpc4 Trpc5', symbol_set=set([u'Cacna1h', u'Cacna1i', u'Pkd1l3', u'Cacna1a', u'Cacna1b', u'Cacna1c', u'Cacna1d', u'Cacna1e', u'Camk2b', u'Cacnb3', u'Cacnb2', u'Ryr3', u'Ryr2', u'Grin2b', u'Grin2a', u'Trpc4', u'Trpc5', 'Mcu', u'Itpr1', u'Prkcb', u'Camk2a', u'Chrna7', u'Ppp3ca', u'Slc8a1', u'Slc8a2', u'Stim2', u'Cacna2d1', u'Nalcn', u'Slc24a3', u'Ryr1', u'Atp2b1', u'Trpc1', u'Cacnb1']), geneids='ENSMUSG00000024112 ENSMUSG00000032839 ENSMUSG00000030376 ENSMUSG00000000197 ENSMUSG00000028161 ENSMUSG00000057897 ENSMUSG00000030525 ENSMUSG00000048827 ENSMUSG00000003352 ENSMUSG00000059003 ENSMUSG00000057378 ENSMUSG00000019943 ENSMUSG00000030592 ENSMUSG00000015968 ENSMUSG00000004110 ENSMUSG00000054640 ENSMUSG00000004113 ENSMUSG00000034656 ENSMUSG00000030209 ENSMUSG00000039156 ENSMUSG00000021313 ENSMUSG00000030102 ENSMUSG00000051331 ENSMUSG00000009647 ENSMUSG00000022416 ENSMUSG00000063873 ENSMUSG00000057914 ENSMUSG00000041710 ENSMUSG00000024617 ENSMUSG00000040118 ENSMUSG00000020882 ENSMUSG00000052889 ENSMUSG00000027748', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=28, D1='G', GO_name='calcium ion transport'),
    Nt(p_uncorrected=0.00047981942121337617, study_count=10, study_n=1139, namespace='biological_process', p_fdr_bh=0.048464960338692416, study_items=set([u'ENSMUSG00000021557', u'ENSMUSG00000029223', u'ENSMUSG00000026596', u'ENSMUSG00000026235', u'ENSMUSG00000023033', u'ENSMUSG00000034656', u'ENSMUSG00000028519', u'ENSMUSG00000011751', u'ENSMUSG00000051331', u'ENSMUSG00000063142']), NS='BP', pop_items=set([u'ENSMUSG00000061436', u'ENSMUSG00000021557', u'ENSMUSG00000030314', u'ENSMUSG00000003934', u'ENSMUSG00000028020', u'ENSMUSG00000005949', u'ENSMUSG00000017412', u'ENSMUSG00000044708', u'ENSMUSG00000059363', u'ENSMUSG00000028519', u'ENSMUSG00000018411', u'ENSMUSG00000026317', u'ENSMUSG00000022307', u'ENSMUSG00000041235', u'ENSMUSG00000068329', u'ENSMUSG00000052613', u'ENSMUSG00000060240', u'ENSMUSG00000023033', u'ENSMUSG00000022111', u'ENSMUSG00000034656', u'ENSMUSG00000064329', u'ENSMUSG00000051331', u'ENSMUSG00000021478', u'ENSMUSG00000011751', u'ENSMUSG00000032368', u'ENSMUSG00000029223', u'ENSMUSG00000032259', u'ENSMUSG00000025232', u'ENSMUSG00000024182', u'ENSMUSG00000026235', u'ENSMUSG00000026596', u'ENSMUSG00000053024', u'ENSMUSG00000063142', u'ENSMUSG00000032046', u'ENSMUSG00000060216', u'ENSMUSG00000024413']), pop_n=13836, p_sm_bonferroni=1.0, is_obsolete=False, GO='GO:0007628', name='adult walking behavior', pop_count=36, alt_ids=[], level=4, depth=5, enrichment='e', Cluster='Late Decrease', geneid_set=set([u'ENSMUSG00000021557', u'ENSMUSG00000029223', u'ENSMUSG00000026596', u'ENSMUSG00000026235', u'ENSMUSG00000023033', u'ENSMUSG00000063142', u'ENSMUSG00000028519', u'ENSMUSG00000011751', u'ENSMUSG00000051331', u'ENSMUSG00000034656']), symbols=u'Abl2 Agtpbp1 Cacna1a Cacna1c Dab1 Epha4 Kcnma1 Scn8a Sptbn4 Uchl1', symbol_set=set(['Sptbn4', u'Agtpbp1', u'Epha4', u'Scn8a', u'Kcnma1', u'Cacna1c', u'Cacna1a', u'Dab1', u'Abl2', u'Uchl1']), geneids='ENSMUSG00000021557 ENSMUSG00000029223 ENSMUSG00000026596 ENSMUSG00000026235 ENSMUSG00000023033 ENSMUSG00000063142 ENSMUSG00000028519 ENSMUSG00000011751 ENSMUSG00000051331 ENSMUSG00000034656', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=0, D1='CJN', GO_name='adult walking behavior'),
    Nt(p_uncorrected='', study_count='', study_n='', namespace='', p_fdr_bh='', study_items='', NS='BP', pop_items='', pop_n='', p_sm_bonferroni='', is_obsolete='', GO='GO:0006950', name='', pop_count='', alt_ids='', level=2, depth=2, enrichment='', Cluster='', geneid_set='', symbols='', symbol_set='', geneids='', format_txt=1, hdr_idx=1, is_hdrgo=True, is_usrgo=False, hdr1usr01='*', dcnt=491, D1='F', GO_name='response to stress'),
    Nt(p_uncorrected=0.00014501917599067806, study_count=9, study_n=1139, namespace='biological_process', p_fdr_bh=0.018098118423090025, study_items=set([u'ENSMUSG00000029104', u'ENSMUSG00000030209', u'ENSMUSG00000030525', u'ENSMUSG00000038255', u'ENSMUSG00000038738', u'ENSMUSG00000055078', u'ENSMUSG00000015829', u'ENSMUSG00000024883', u'ENSMUSG00000027273']), NS='BP', pop_items=set([u'ENSMUSG00000027950', u'ENSMUSG00000038255', u'ENSMUSG00000021478', u'ENSMUSG00000055078', u'ENSMUSG00000030525', u'ENSMUSG00000045730', u'ENSMUSG00000056755', u'ENSMUSG00000029104', u'ENSMUSG00000059991', u'ENSMUSG00000026317', u'ENSMUSG00000030720', u'ENSMUSG00000023017', u'ENSMUSG00000024883', u'ENSMUSG00000042453', u'ENSMUSG00000027273', u'ENSMUSG00000039358', u'ENSMUSG00000015605', u'ENSMUSG00000061762', u'ENSMUSG00000030209', u'ENSMUSG00000020423', u'ENSMUSG00000038738', u'ENSMUSG00000015829', u'ENSMUSG00000026959', u'ENSMUSG00000028657', u'ENSMUSG00000032259', u'ENSMUSG00000028969']), pop_n=13836, p_sm_bonferroni=1.0, is_obsolete=False, GO='GO:0008306', name='associative learning', pop_count=26, alt_ids=[], level=5, depth=7, enrichment='e', Cluster='Late Decrease', geneid_set=set([u'ENSMUSG00000029104', u'ENSMUSG00000015829', u'ENSMUSG00000030209', u'ENSMUSG00000038255', u'ENSMUSG00000024883', u'ENSMUSG00000055078', u'ENSMUSG00000030525', u'ENSMUSG00000038738', u'ENSMUSG00000027273']), symbols=u'Chrna7 Gabra5 Grin2b Htt Neurod2 Rin1 Shank1 Snap25 Tnr', symbol_set=set([u'Neurod2', u'Snap25', u'Tnr', u'Rin1', u'Grin2b', u'Htt', u'Gabra5', u'Chrna7', u'Shank1']), geneids='ENSMUSG00000029104 ENSMUSG00000015829 ENSMUSG00000038255 ENSMUSG00000030209 ENSMUSG00000024883 ENSMUSG00000027273 ENSMUSG00000030525 ENSMUSG00000038738 ENSMUSG00000055078', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=4, D1='CJN', GO_name='associative learning'),
    Nt(p_uncorrected=0.0004915718501337365, study_count=9, study_n=1139, namespace='biological_process', p_fdr_bh=0.04899871777221212, study_items=set([u'ENSMUSG00000059003', u'ENSMUSG00000070570', u'ENSMUSG00000030209', u'ENSMUSG00000045903', u'ENSMUSG00000025889', u'ENSMUSG00000022619', u'ENSMUSG00000028161', u'ENSMUSG00000003378', u'ENSMUSG00000031302']), NS='BP', pop_items=set([u'ENSMUSG00000009376', u'ENSMUSG00000042429', u'ENSMUSG00000000632', u'ENSMUSG00000029470', u'ENSMUSG00000003378', u'ENSMUSG00000023942', u'ENSMUSG00000059003', u'ENSMUSG00000031302', u'ENSMUSG00000036273', u'ENSMUSG00000022619', u'ENSMUSG00000045730', u'ENSMUSG00000036104', u'ENSMUSG00000038665', u'ENSMUSG00000048482', u'ENSMUSG00000020734', u'ENSMUSG00000005583', u'ENSMUSG00000031393', u'ENSMUSG00000030209', u'ENSMUSG00000046876', u'ENSMUSG00000000766', u'ENSMUSG00000032827', u'ENSMUSG00000022935', u'ENSMUSG00000026959', u'ENSMUSG00000071424', u'ENSMUSG00000070570', u'ENSMUSG00000025889', u'ENSMUSG00000045903', u'ENSMUSG00000056073', u'ENSMUSG00000028161', u'ENSMUSG00000028969']), pop_n=13836, p_sm_bonferroni=1.0, is_obsolete=False, GO='GO:0060079', name='excitatory postsynaptic potential', pop_count=30, alt_ids=[], level=5, depth=5, enrichment='e', Cluster='Late Decrease', geneid_set=set([u'ENSMUSG00000070570', u'ENSMUSG00000030209', u'ENSMUSG00000045903', u'ENSMUSG00000031302', u'ENSMUSG00000025889', u'ENSMUSG00000022619', u'ENSMUSG00000028161', u'ENSMUSG00000003378', u'ENSMUSG00000059003']), symbols=u'Grik5 Grin2a Grin2b Mapk8ip2 Nlgn3 Npas4 Ppp3ca Slc17a7 Snca', symbol_set=set([u'Npas4', u'Nlgn3', u'Slc17a7', u'Grik5', u'Grin2b', u'Grin2a', u'Snca', u'Ppp3ca', u'Mapk8ip2']), geneids='ENSMUSG00000059003 ENSMUSG00000070570 ENSMUSG00000025889 ENSMUSG00000045903 ENSMUSG00000030209 ENSMUSG00000028161 ENSMUSG00000022619 ENSMUSG00000003378 ENSMUSG00000031302', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=2, D1='A', GO_name='excitatory postsynaptic potential'),
    Nt(p_uncorrected=5.51212922810342e-09, study_count=19, study_n=1139, namespace='biological_process', p_fdr_bh=2.609820935468591e-06, study_items=set([u'ENSMUSG00000051790', u'ENSMUSG00000014592', u'ENSMUSG00000028341', u'ENSMUSG00000009681', u'ENSMUSG00000017167', u'ENSMUSG00000020900', u'ENSMUSG00000033565', u'ENSMUSG00000063142', u'ENSMUSG00000022208', u'ENSMUSG00000026596', u'ENSMUSG00000025318', u'ENSMUSG00000020886', u'ENSMUSG00000057897', u'ENSMUSG00000015829', u'ENSMUSG00000038738', u'ENSMUSG00000017631', u'ENSMUSG00000022623', u'ENSMUSG00000034656', u'ENSMUSG00000008658']), NS='BP', pop_items=set([u'ENSMUSG00000028224', u'ENSMUSG00000021665', u'ENSMUSG00000057897', u'ENSMUSG00000048000', u'ENSMUSG00000022208', u'ENSMUSG00000000594', u'ENSMUSG00000021684', u'ENSMUSG00000026596', u'ENSMUSG00000062762', u'ENSMUSG00000031996', u'ENSMUSG00000028341', u'ENSMUSG00000022892', u'ENSMUSG00000017631', u'ENSMUSG00000022623', u'ENSMUSG00000018012', u'ENSMUSG00000008658', u'ENSMUSG00000051790', u'ENSMUSG00000032394', u'ENSMUSG00000034593', u'ENSMUSG00000026317', u'ENSMUSG00000030720', u'ENSMUSG00000005360', u'ENSMUSG00000017167', u'ENSMUSG00000031960', u'ENSMUSG00000020734', u'ENSMUSG00000022055', u'ENSMUSG00000063142', u'ENSMUSG00000038664', u'ENSMUSG00000030302', u'ENSMUSG00000009681', u'ENSMUSG00000026842', u'ENSMUSG00000060708', u'ENSMUSG00000024109', u'ENSMUSG00000038738', u'ENSMUSG00000023959', u'ENSMUSG00000015829', u'ENSMUSG00000020745', u'ENSMUSG00000014592', u'ENSMUSG00000041309', u'ENSMUSG00000031367', u'ENSMUSG00000020900', u'ENSMUSG00000033565', u'ENSMUSG00000025232', u'ENSMUSG00000025318', u'ENSMUSG00000022840', u'ENSMUSG00000068696', u'ENSMUSG00000034656', u'ENSMUSG00000025579', u'ENSMUSG00000030894', u'ENSMUSG00000020886']), pop_n=13836, p_sm_bonferroni=8.351426993499492e-05, is_obsolete=False, GO='GO:0050885', name='neuromuscular process controlling balance', pop_count=50, alt_ids=[], level=5, depth=5, enrichment='e', Cluster='Late Decrease', geneid_set=set([u'ENSMUSG00000057897', u'ENSMUSG00000009681', u'ENSMUSG00000026596', u'ENSMUSG00000038738', u'ENSMUSG00000028341', u'ENSMUSG00000015829', u'ENSMUSG00000017631', u'ENSMUSG00000022623', u'ENSMUSG00000008658', u'ENSMUSG00000051790', u'ENSMUSG00000014592', u'ENSMUSG00000020900', u'ENSMUSG00000033565', u'ENSMUSG00000034656', u'ENSMUSG00000022208', u'ENSMUSG00000017167', u'ENSMUSG00000025318', u'ENSMUSG00000020886', u'ENSMUSG00000063142']), symbols=u'Abl2 Abr Bcr Cacna1a Camk2b Camta1 Cntnap1 Dlg4 Jph3 Jph4 Kcnma1 Myh10 Nlgn2 Nr4a3 Rbfox1 Rbfox2 Shank1 Shank3 Tnr', symbol_set=set([u'Myh10', u'Cacna1a', u'Nlgn2', u'Rbfox2', u'Rbfox1', u'Tnr', u'Nr4a3', u'Kcnma1', u'Camk2b', u'Cntnap1', u'Jph3', u'Abr', u'Bcr', u'Jph4', u'Camta1', u'Abl2', u'Shank3', u'Shank1', u'Dlg4']), geneids='ENSMUSG00000051790 ENSMUSG00000014592 ENSMUSG00000057897 ENSMUSG00000009681 ENSMUSG00000063142 ENSMUSG00000020900 ENSMUSG00000033565 ENSMUSG00000034656 ENSMUSG00000022208 ENSMUSG00000017167 ENSMUSG00000025318 ENSMUSG00000026596 ENSMUSG00000028341 ENSMUSG00000015829 ENSMUSG00000038738 ENSMUSG00000017631 ENSMUSG00000022623 ENSMUSG00000020886 ENSMUSG00000008658', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=0, D1='J', GO_name='neuromuscular process controlling balance'),
    Nt(p_uncorrected='', study_count='', study_n='', namespace='', p_fdr_bh='', study_items='', NS='BP', pop_items='', pop_n='', p_sm_bonferroni='', is_obsolete='', GO='GO:0072578', name='', pop_count='', alt_ids='', level=5, depth=7, enrichment='', Cluster='', geneid_set='', symbols='', symbol_set='', geneids='', format_txt=1, hdr_idx=1, is_hdrgo=True, is_usrgo=False, hdr1usr01='*', dcnt=5, D1='BCGH', GO_name='neurotransmitter-gated ion channel clustering'),
    Nt(p_uncorrected=0.00035635521713183366, study_count=5, study_n=1139, namespace='biological_process', p_fdr_bh=0.03749401315808619, study_items=set([u'ENSMUSG00000033953', u'ENSMUSG00000021816', u'ENSMUSG00000021057', u'ENSMUSG00000061603', u'ENSMUSG00000028161']), NS='BP', pop_items=set([u'ENSMUSG00000074272', u'ENSMUSG00000029550', u'ENSMUSG00000028161', u'ENSMUSG00000052488', u'ENSMUSG00000021057', u'ENSMUSG00000021816', u'ENSMUSG00000028854', u'ENSMUSG00000033953', u'ENSMUSG00000061603']), pop_n=13836, p_sm_bonferroni=1.0, is_obsolete=False, GO='GO:0051533', name='positive regulation of NFAT protein import into nucleus', pop_count=9, alt_ids=[], level=8, depth=12, enrichment='e', Cluster='Late Decrease', geneid_set=set([u'ENSMUSG00000033953', u'ENSMUSG00000021057', u'ENSMUSG00000028161', u'ENSMUSG00000061603', u'ENSMUSG00000021816']), symbols=u'Akap5 Akap6 Ppp3ca Ppp3cb Ppp3r1', symbol_set=set([u'Akap5', u'Akap6', u'Ppp3cb', u'Ppp3r1', u'Ppp3ca']), geneids='ENSMUSG00000033953 ENSMUSG00000021057 ENSMUSG00000028161 ENSMUSG00000021816 ENSMUSG00000061603', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=0, D1='A', GO_name='positive regulation of NFAT protein import into nucleus'),
    Nt(p_uncorrected=1.9778037189877205e-05, study_count=13, study_n=1139, namespace='biological_process', p_fdr_bh=0.003140561656845994, study_items=set([u'ENSMUSG00000033214', u'ENSMUSG00000036333', u'ENSMUSG00000058835', u'ENSMUSG00000062098', u'ENSMUSG00000033565', u'ENSMUSG00000055407', u'ENSMUSG00000022619', u'ENSMUSG00000024617', u'ENSMUSG00000026596', u'ENSMUSG00000068740', u'ENSMUSG00000020827', u'ENSMUSG00000020580', u'ENSMUSG00000034656']), NS='BP', pop_items=set([u'ENSMUSG00000048960', u'ENSMUSG00000028546', u'ENSMUSG00000025959', u'ENSMUSG00000026596', u'ENSMUSG00000029571', u'ENSMUSG00000055407', u'ENSMUSG00000020827', u'ENSMUSG00000029071', u'ENSMUSG00000030557', u'ENSMUSG00000025630', u'ENSMUSG00000001847', u'ENSMUSG00000024924', u'ENSMUSG00000028613', u'ENSMUSG00000057531', u'ENSMUSG00000035910', u'ENSMUSG00000062098', u'ENSMUSG00000044548', u'ENSMUSG00000022619', u'ENSMUSG00000023030', u'ENSMUSG00000027253', u'ENSMUSG00000034656', u'ENSMUSG00000027797', u'ENSMUSG00000058835', u'ENSMUSG00000063063', u'ENSMUSG00000039361', u'ENSMUSG00000033214', u'ENSMUSG00000025809', u'ENSMUSG00000044042', u'ENSMUSG00000036333', u'ENSMUSG00000028883', u'ENSMUSG00000068740', u'ENSMUSG00000033792', u'ENSMUSG00000039852', u'ENSMUSG00000019843', u'ENSMUSG00000050272', u'ENSMUSG00000033565', u'ENSMUSG00000025555', u'ENSMUSG00000031285', u'ENSMUSG00000024617', u'ENSMUSG00000021936', u'ENSMUSG00000020580', u'ENSMUSG00000028969']), pop_n=13836, p_sm_bonferroni=0.29965704146382954, is_obsolete=False, GO='GO:0048813', name='dendrite morphogenesis', pop_count=42, alt_ids=[], level=6, depth=8, enrichment='e', Cluster='Late Decrease', geneid_set=set([u'ENSMUSG00000033214', u'ENSMUSG00000036333', u'ENSMUSG00000058835', u'ENSMUSG00000062098', u'ENSMUSG00000033565', u'ENSMUSG00000068740', u'ENSMUSG00000022619', u'ENSMUSG00000026596', u'ENSMUSG00000024617', u'ENSMUSG00000055407', u'ENSMUSG00000020827', u'ENSMUSG00000020580', u'ENSMUSG00000034656']), symbols=u'Abi1 Abl2 Btbd3 Cacna1a Camk2a Celsr2 Kidins220 Map6 Mapk8ip2 Mink1 Rbfox2 Rock2 Slitrk5', symbol_set=set([u'Camk2a', u'Mink1', u'Slitrk5', u'Rbfox2', u'Cacna1a', u'Abi1', u'Celsr2', u'Rock2', u'Kidins220', 'Map6', u'Mapk8ip2', u'Abl2', u'Btbd3']), geneids='ENSMUSG00000033214 ENSMUSG00000036333 ENSMUSG00000058835 ENSMUSG00000022619 ENSMUSG00000062098 ENSMUSG00000033565 ENSMUSG00000068740 ENSMUSG00000024617 ENSMUSG00000026596 ENSMUSG00000055407 ENSMUSG00000020827 ENSMUSG00000020580 ENSMUSG00000034656', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=0, D1='BCEH', GO_name='dendrite morphogenesis'),
    Nt(p_uncorrected='', study_count='', study_n='', namespace='', p_fdr_bh='', study_items='', NS='BP', pop_items='', pop_n='', p_sm_bonferroni='', is_obsolete='', GO='GO:0051960', name='', pop_count='', alt_ids='', level=5, depth=5, enrichment='', Cluster='', geneid_set='', symbols='', symbol_set='', geneids='', format_txt=1, hdr_idx=1, is_hdrgo=True, is_usrgo=False, hdr1usr01='*', dcnt=262, D1='A', GO_name='regulation of nervous system development'),
    Nt(p_uncorrected=3.122233557523593e-05, study_count=9, study_n=1139, namespace='biological_process', p_fdr_bh=0.004683659468320788, study_items=set([u'ENSMUSG00000026675', u'ENSMUSG00000021670', u'ENSMUSG00000001467', u'ENSMUSG00000059743', u'ENSMUSG00000021273', u'ENSMUSG00000006517', u'ENSMUSG00000034926', u'ENSMUSG00000033105', u'ENSMUSG00000045294']), NS='BP', pop_items=set([u'ENSMUSG00000026675', u'ENSMUSG00000001467', u'ENSMUSG00000031168', u'ENSMUSG00000027952', u'ENSMUSG00000006517', u'ENSMUSG00000034926', u'ENSMUSG00000050697', u'ENSMUSG00000028518', u'ENSMUSG00000041939', u'ENSMUSG00000058454', u'ENSMUSG00000024799', u'ENSMUSG00000018042', u'ENSMUSG00000002985', u'ENSMUSG00000021670', u'ENSMUSG00000059743', u'ENSMUSG00000021273', u'ENSMUSG00000045294', u'ENSMUSG00000033105', u'ENSMUSG00000003721', u'ENSMUSG00000031400', u'ENSMUSG00000031349', u'ENSMUSG00000027875']), pop_n=13836, p_sm_bonferroni=0.47304960630039955, is_obsolete=False, GO='GO:0006695', name='cholesterol biosynthetic process', pop_count=22, alt_ids=[], level=6, depth=7, enrichment='e', Cluster='Late Decrease', geneid_set=set([u'ENSMUSG00000026675', u'ENSMUSG00000021670', u'ENSMUSG00000001467', u'ENSMUSG00000059743', u'ENSMUSG00000021273', u'ENSMUSG00000006517', u'ENSMUSG00000034926', u'ENSMUSG00000033105', u'ENSMUSG00000045294']), symbols=u'Cyp51 Dhcr24 Fdft1 Fdps Hmgcr Hsd17b7 Insig1 Lss Mvd', symbol_set=set([u'Fdps', u'Cyp51', u'Mvd', u'Lss', u'Hmgcr', u'Insig1', u'Dhcr24', u'Fdft1', u'Hsd17b7']), geneids='ENSMUSG00000021670 ENSMUSG00000026675 ENSMUSG00000001467 ENSMUSG00000059743 ENSMUSG00000021273 ENSMUSG00000006517 ENSMUSG00000034926 ENSMUSG00000033105 ENSMUSG00000045294', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=3, D1='CD', GO_name='cholesterol biosynthetic process'),
    Nt(p_uncorrected=0.00016865694937338938, study_count=11, study_n=1139, namespace='biological_process', p_fdr_bh=0.019963448749657987, study_items=set([u'ENSMUSG00000026675', u'ENSMUSG00000021670', u'ENSMUSG00000001467', u'ENSMUSG00000059743', u'ENSMUSG00000021273', u'ENSMUSG00000031604', u'ENSMUSG00000006517', u'ENSMUSG00000034926', u'ENSMUSG00000031708', u'ENSMUSG00000033105', u'ENSMUSG00000032018']), NS='BP', pop_items=set([u'ENSMUSG00000026675', u'ENSMUSG00000001467', u'ENSMUSG00000031168', u'ENSMUSG00000063730', u'ENSMUSG00000027952', u'ENSMUSG00000026499', u'ENSMUSG00000018042', u'ENSMUSG00000006517', u'ENSMUSG00000034926', u'ENSMUSG00000050697', u'ENSMUSG00000028518', u'ENSMUSG00000041939', u'ENSMUSG00000018167', u'ENSMUSG00000058454', u'ENSMUSG00000024799', u'ENSMUSG00000027195', u'ENSMUSG00000042289', u'ENSMUSG00000032018', u'ENSMUSG00000021594', u'ENSMUSG00000034308', u'ENSMUSG00000026456', u'ENSMUSG00000050370', u'ENSMUSG00000028470', u'ENSMUSG00000052534', u'ENSMUSG00000032051', u'ENSMUSG00000021670', u'ENSMUSG00000059743', u'ENSMUSG00000021273', u'ENSMUSG00000031604', u'ENSMUSG00000031708', u'ENSMUSG00000033105', u'ENSMUSG00000029311', u'ENSMUSG00000031574', u'ENSMUSG00000028603', u'ENSMUSG00000031349', u'ENSMUSG00000027875', u'ENSMUSG00000021252', u'ENSMUSG00000041736']), pop_n=13836, p_sm_bonferroni=1.0, is_obsolete=False, GO='GO:0006694', name='steroid biosynthetic process', pop_count=38, alt_ids=[], level=5, depth=5, enrichment='e', Cluster='Late Decrease', geneid_set=set([u'ENSMUSG00000026675', u'ENSMUSG00000021670', u'ENSMUSG00000001467', u'ENSMUSG00000059743', u'ENSMUSG00000021273', u'ENSMUSG00000031604', u'ENSMUSG00000006517', u'ENSMUSG00000034926', u'ENSMUSG00000031708', u'ENSMUSG00000033105', u'ENSMUSG00000032018']), symbols=u'Cyp51 Dhcr24 Fdft1 Fdps Hmgcr Hsd17b7 Lss Msmo1 Mvd Sc5d Tecr', symbol_set=set(['Msmo1', u'Fdps', u'Cyp51', u'Tecr', u'Sc5d', u'Mvd', u'Lss', u'Hmgcr', u'Dhcr24', u'Fdft1', u'Hsd17b7']), geneids='ENSMUSG00000021670 ENSMUSG00000026675 ENSMUSG00000001467 ENSMUSG00000059743 ENSMUSG00000021273 ENSMUSG00000031604 ENSMUSG00000006517 ENSMUSG00000034926 ENSMUSG00000031708 ENSMUSG00000033105 ENSMUSG00000032018', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=26, D1='CD', GO_name='steroid biosynthetic process'),
    Nt(p_uncorrected=6.581060415466352e-07, study_count=18, study_n=1139, namespace='biological_process', p_fdr_bh=0.0001689994006012385, study_items=set([u'ENSMUSG00000051790', u'ENSMUSG00000052581', u'ENSMUSG00000020704', u'ENSMUSG00000032452', u'ENSMUSG00000071862', u'ENSMUSG00000033214', u'ENSMUSG00000060780', u'ENSMUSG00000026341', u'ENSMUSG00000013033', u'ENSMUSG00000050965', u'ENSMUSG00000059146', u'ENSMUSG00000034730', u'ENSMUSG00000028782', u'ENSMUSG00000063887', u'ENSMUSG00000028664', u'ENSMUSG00000048304', u'ENSMUSG00000031302', u'ENSMUSG00000025920']), NS='BP', pop_items=set([u'ENSMUSG00000030093', u'ENSMUSG00000045083', u'ENSMUSG00000036295', u'ENSMUSG00000028184', u'ENSMUSG00000035274', u'ENSMUSG00000055003', u'ENSMUSG00000033707', u'ENSMUSG00000046699', u'ENSMUSG00000020704', u'ENSMUSG00000066392', u'ENSMUSG00000028782', u'ENSMUSG00000063887', u'ENSMUSG00000048304', u'ENSMUSG00000028664', u'ENSMUSG00000031302', u'ENSMUSG00000051790', u'ENSMUSG00000033214', u'ENSMUSG00000039953', u'ENSMUSG00000024647', u'ENSMUSG00000002885', u'ENSMUSG00000013033', u'ENSMUSG00000050965', u'ENSMUSG00000048218', u'ENSMUSG00000047414', u'ENSMUSG00000034730', u'ENSMUSG00000023885', u'ENSMUSG00000050947', u'ENSMUSG00000031393', u'ENSMUSG00000008153', u'ENSMUSG00000071862', u'ENSMUSG00000024109', u'ENSMUSG00000059146', u'ENSMUSG00000042589', u'ENSMUSG00000073125', u'ENSMUSG00000022514', u'ENSMUSG00000048482', u'ENSMUSG00000048915', u'ENSMUSG00000051379', u'ENSMUSG00000055254', u'ENSMUSG00000047085', u'ENSMUSG00000072964', u'ENSMUSG00000035064', u'ENSMUSG00000052581', u'ENSMUSG00000047787', u'ENSMUSG00000033569', u'ENSMUSG00000032452', u'ENSMUSG00000005958', u'ENSMUSG00000060780', u'ENSMUSG00000026341', u'ENSMUSG00000032537', u'ENSMUSG00000037605', u'ENSMUSG00000075478', u'ENSMUSG00000034648', u'ENSMUSG00000049112', u'ENSMUSG00000042846', u'ENSMUSG00000036790', u'ENSMUSG00000025920', u'ENSMUSG00000074736', u'ENSMUSG00000022674']), pop_n=13836, p_sm_bonferroni=0.00997096463547307, is_obsolete=False, GO='GO:0051965', name='positive regulation of synapse assembly', pop_count=59, alt_ids=[], level=5, depth=7, enrichment='e', Cluster='Late Decrease', geneid_set=set([u'ENSMUSG00000020704', u'ENSMUSG00000071862', u'ENSMUSG00000033214', u'ENSMUSG00000059146', u'ENSMUSG00000028782', u'ENSMUSG00000063887', u'ENSMUSG00000028664', u'ENSMUSG00000031302', u'ENSMUSG00000051790', u'ENSMUSG00000052581', u'ENSMUSG00000032452', u'ENSMUSG00000060780', u'ENSMUSG00000026341', u'ENSMUSG00000013033', u'ENSMUSG00000050965', u'ENSMUSG00000034730', u'ENSMUSG00000048304', u'ENSMUSG00000025920']), symbols=u'Actr3 Adgrb1 Adgrb2 Adgrl1 Asic2 Clstn2 Ephb2 Lrrtm1 Lrrtm2 Lrrtm4 Nlgn1 Nlgn2 Nlgn3 Ntrk3 Prkca Slitrk3 Slitrk5 Stau2', symbol_set=set([u'Ephb2', u'Stau2', u'Slitrk5', u'Nlgn2', u'Nlgn3', u'Nlgn1', u'Prkca', 'Adgrl1', u'Ntrk3', u'Lrrtm4', u'Lrrtm1', u'Clstn2', u'Lrrtm2', 'Asic2', u'Actr3', 'Adgrb1', 'Adgrb2', u'Slitrk3']), geneids='ENSMUSG00000051790 ENSMUSG00000033214 ENSMUSG00000020704 ENSMUSG00000071862 ENSMUSG00000032452 ENSMUSG00000052581 ENSMUSG00000059146 ENSMUSG00000026341 ENSMUSG00000013033 ENSMUSG00000050965 ENSMUSG00000034730 ENSMUSG00000028782 ENSMUSG00000063887 ENSMUSG00000028664 ENSMUSG00000048304 ENSMUSG00000031302 ENSMUSG00000025920 ENSMUSG00000060780', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=5, D1='A', GO_name='positive regulation of synapse assembly'),
    Nt(p_uncorrected='', study_count='', study_n='', namespace='', p_fdr_bh='', study_items='', NS='BP', pop_items='', pop_n='', p_sm_bonferroni='', is_obsolete='', GO='GO:0099536', name='', pop_count='', alt_ids='', level=4, depth=4, enrichment='', Cluster='', geneid_set='', symbols='', symbol_set='', geneids='', format_txt=1, hdr_idx=1, is_hdrgo=True, is_usrgo=False, hdr1usr01='*', dcnt=42, D1='BCQ', GO_name='synaptic signaling'),
    Nt(p_uncorrected=8.952169517034117e-07, study_count=13, study_n=1139, namespace='biological_process', p_fdr_bh=0.00021876503282674823, study_items=set([u'ENSMUSG00000051790', u'ENSMUSG00000052581', u'ENSMUSG00000025889', u'ENSMUSG00000060681', u'ENSMUSG00000069601', u'ENSMUSG00000071862', u'ENSMUSG00000063531', u'ENSMUSG00000060780', u'ENSMUSG00000031202', u'ENSMUSG00000032336', u'ENSMUSG00000063887', u'ENSMUSG00000015829', u'ENSMUSG00000031302']), NS='BP', pop_items=set([u'ENSMUSG00000030093', u'ENSMUSG00000022382', u'ENSMUSG00000063531', u'ENSMUSG00000049939', u'ENSMUSG00000031202', u'ENSMUSG00000063887', u'ENSMUSG00000029071', u'ENSMUSG00000051790', u'ENSMUSG00000018411', u'ENSMUSG00000031302', u'ENSMUSG00000034593', u'ENSMUSG00000044548', u'ENSMUSG00000006932', u'ENSMUSG00000022240', u'ENSMUSG00000032336', u'ENSMUSG00000000223', u'ENSMUSG00000023036', u'ENSMUSG00000034891', u'ENSMUSG00000027253', u'ENSMUSG00000032171', u'ENSMUSG00000030302', u'ENSMUSG00000026812', u'ENSMUSG00000069601', u'ENSMUSG00000071862', u'ENSMUSG00000064023', u'ENSMUSG00000015829', u'ENSMUSG00000052911', u'ENSMUSG00000026442', u'ENSMUSG00000052581', u'ENSMUSG00000025889', u'ENSMUSG00000060681', u'ENSMUSG00000048988', u'ENSMUSG00000060780']), pop_n=13836, p_sm_bonferroni=0.013563432035258392, is_obsolete=False, GO='GO:0050808', name='synapse organization', pop_count=33, alt_ids=[], level=3, depth=3, enrichment='e', Cluster='Late Decrease', geneid_set=set([u'ENSMUSG00000051790', u'ENSMUSG00000052581', u'ENSMUSG00000025889', u'ENSMUSG00000060681', u'ENSMUSG00000069601', u'ENSMUSG00000071862', u'ENSMUSG00000063531', u'ENSMUSG00000060780', u'ENSMUSG00000031202', u'ENSMUSG00000032336', u'ENSMUSG00000063887', u'ENSMUSG00000015829', u'ENSMUSG00000031302']), symbols=u'Ank3 Lrrtm1 Lrrtm2 Lrrtm4 Nlgn1 Nlgn2 Nlgn3 Nptn Rab39b Sema3e Slc9a6 Snca Tnr', symbol_set=set([u'Slc9a6', u'Nlgn2', u'Rab39b', u'Nlgn1', u'Snca', u'Nptn', u'Lrrtm4', u'Tnr', u'Ank3', u'Lrrtm1', u'Lrrtm2', u'Sema3e', u'Nlgn3']), geneids='ENSMUSG00000051790 ENSMUSG00000052581 ENSMUSG00000025889 ENSMUSG00000060681 ENSMUSG00000069601 ENSMUSG00000071862 ENSMUSG00000063531 ENSMUSG00000060780 ENSMUSG00000031202 ENSMUSG00000032336 ENSMUSG00000063887 ENSMUSG00000015829 ENSMUSG00000031302', format_txt=1, hdr_idx=1, is_hdrgo=True, is_usrgo=True, hdr1usr01='**', dcnt=21, D1='BCH', GO_name='synapse organization'),
    Nt(p_uncorrected=6.743146363374786e-07, study_count=77, study_n=1139, namespace='biological_process', p_fdr_bh=0.00017027568425248562, study_items=set([u'ENSMUSG00000019699', u'ENSMUSG00000034902', u'ENSMUSG00000042817', u'ENSMUSG00000067336', u'ENSMUSG00000039145', u'ENSMUSG00000021559', u'ENSMUSG00000046709', u'ENSMUSG00000026596', u'ENSMUSG00000027646', u'ENSMUSG00000038970', u'ENSMUSG00000028289', u'ENSMUSG00000018547', u'ENSMUSG00000057897', u'ENSMUSG00000028664', u'ENSMUSG00000020827', u'ENSMUSG00000005672', u'ENSMUSG00000020451', u'ENSMUSG00000031833', u'ENSMUSG00000023050', u'ENSMUSG00000037012', u'ENSMUSG00000021385', u'ENSMUSG00000053137', u'ENSMUSG00000041720', u'ENSMUSG00000022263', u'ENSMUSG00000032500', u'ENSMUSG00000009681', u'ENSMUSG00000050965', u'ENSMUSG00000030397', u'ENSMUSG00000005469', u'ENSMUSG00000057177', u'ENSMUSG00000004936', u'ENSMUSG00000000308', u'ENSMUSG00000004933', u'ENSMUSG00000026207', u'ENSMUSG00000024242', u'ENSMUSG00000062044', u'ENSMUSG00000031012', u'ENSMUSG00000040479', u'ENSMUSG00000061751', u'ENSMUSG00000029403', u'ENSMUSG00000021701', u'ENSMUSG00000020015', u'ENSMUSG00000059146', u'ENSMUSG00000032599', u'ENSMUSG00000039058', u'ENSMUSG00000038128', u'ENSMUSG00000024122', u'ENSMUSG00000020990', u'ENSMUSG00000022791', u'ENSMUSG00000045038', u'ENSMUSG00000055540', u'ENSMUSG00000078816', u'ENSMUSG00000024867', u'ENSMUSG00000020785', u'ENSMUSG00000026834', u'ENSMUSG00000074923', u'ENSMUSG00000028078', u'ENSMUSG00000028126', u'ENSMUSG00000001034', u'ENSMUSG00000032384', u'ENSMUSG00000033526', u'ENSMUSG00000020277', u'ENSMUSG00000059456', u'ENSMUSG00000029916', u'ENSMUSG00000031284', u'ENSMUSG00000027296', u'ENSMUSG00000028926', u'ENSMUSG00000026235', u'ENSMUSG00000024617', u'ENSMUSG00000036095', u'ENSMUSG00000022861', u'ENSMUSG00000026489', u'ENSMUSG00000015599', u'ENSMUSG00000063358', u'ENSMUSG00000052889', u'ENSMUSG00000020580', u'ENSMUSG00000074305']), NS='BP', pop_items=set([u'ENSMUSG00000002012', u'ENSMUSG00000040084', u'ENSMUSG00000029512', u'ENSMUSG00000026490', u'ENSMUSG00000028028', u'ENSMUSG00000029516', u'ENSMUSG00000020190', u'ENSMUSG00000017405', u'ENSMUSG00000024210', u'ENSMUSG00000016528', u'ENSMUSG00000030110', u'ENSMUSG00000016526', u'ENSMUSG00000020785', u'ENSMUSG00000015599', u'ENSMUSG00000027665', u'ENSMUSG00000041720', u'ENSMUSG00000004054', u'ENSMUSG00000004056', u'ENSMUSG00000002409', u'ENSMUSG00000075419', u'ENSMUSG00000035032', u'ENSMUSG00000040479', u'ENSMUSG00000055471', u'ENSMUSG00000033862', u'ENSMUSG00000024042', u'ENSMUSG00000021408', u'ENSMUSG00000049091', u'ENSMUSG00000038861', u'ENSMUSG00000042228', u'ENSMUSG00000006445', u'ENSMUSG00000021559', u'ENSMUSG00000059981', u'ENSMUSG00000053693', u'ENSMUSG00000061288', u'ENSMUSG00000028708', u'ENSMUSG00000035725', u'ENSMUSG00000037989', u'ENSMUSG00000020366', u'ENSMUSG00000024290', u'ENSMUSG00000022781', u'ENSMUSG00000018209', u'ENSMUSG00000029635', u'ENSMUSG00000062312', u'ENSMUSG00000031644', u'ENSMUSG00000050931', u'ENSMUSG00000006386', u'ENSMUSG00000003752', u'ENSMUSG00000001270', u'ENSMUSG00000024769', u'ENSMUSG00000050002', u'ENSMUSG00000006728', u'ENSMUSG00000031012', u'ENSMUSG00000009681', u'ENSMUSG00000031016', u'ENSMUSG00000033191', u'ENSMUSG00000026836', u'ENSMUSG00000026834', u'ENSMUSG00000028792', u'ENSMUSG00000022433', u'ENSMUSG00000030849', u'ENSMUSG00000025949', u'ENSMUSG00000025239', u'ENSMUSG00000020766', u'ENSMUSG00000025236', u'ENSMUSG00000024617', u'ENSMUSG00000007613', u'ENSMUSG00000000628', u'ENSMUSG00000022861', u'ENSMUSG00000034218', u'ENSMUSG00000020715', u'ENSMUSG00000061393', u'ENSMUSG00000026596', u'ENSMUSG00000024830', u'ENSMUSG00000030409', u'ENSMUSG00000050697', u'ENSMUSG00000028573', u'ENSMUSG00000020827', u'ENSMUSG00000045962', u'ENSMUSG00000000532', u'ENSMUSG00000000530', u'ENSMUSG00000026201', u'ENSMUSG00000026207', u'ENSMUSG00000014554', u'ENSMUSG00000024782', u'ENSMUSG00000028078', u'ENSMUSG00000032599', u'ENSMUSG00000024122', u'ENSMUSG00000038967', u'ENSMUSG00000042064', u'ENSMUSG00000028948', u'ENSMUSG00000040936', u'ENSMUSG00000000441', u'ENSMUSG00000016179', u'ENSMUSG00000026117', u'ENSMUSG00000052920', u'ENSMUSG00000031833', u'ENSMUSG00000003534', u'ENSMUSG00000032478', u'ENSMUSG00000035769', u'ENSMUSG00000025877', u'ENSMUSG00000022897', u'ENSMUSG00000023050', u'ENSMUSG00000026575', u'ENSMUSG00000053137', u'ENSMUSG00000032113', u'ENSMUSG00000032440', u'ENSMUSG00000053819', u'ENSMUSG00000003228', u'ENSMUSG00000024404', u'ENSMUSG00000059146', u'ENSMUSG00000031112', u'ENSMUSG00000029186', u'ENSMUSG00000020258', u'ENSMUSG00000024789', u'ENSMUSG00000022672', u'ENSMUSG00000029217', u'ENSMUSG00000028756', u'ENSMUSG00000058444', u'ENSMUSG00000020444', u'ENSMUSG00000053046', u'ENSMUSG00000003644', u'ENSMUSG00000057342', u'ENSMUSG00000025060', u'ENSMUSG00000029916', u'ENSMUSG00000003762', u'ENSMUSG00000024712', u'ENSMUSG00000034663', u'ENSMUSG00000025574', u'ENSMUSG00000038145', u'ENSMUSG00000001127', u'ENSMUSG00000019942', u'ENSMUSG00000039145', u'ENSMUSG00000020694', u'ENSMUSG00000025358', u'ENSMUSG00000029454', u'ENSMUSG00000000127', u'ENSMUSG00000023809', u'ENSMUSG00000020389', u'ENSMUSG00000021754', u'ENSMUSG00000020385', u'ENSMUSG00000021108', u'ENSMUSG00000020897', u'ENSMUSG00000026778', u'ENSMUSG00000035232', u'ENSMUSG00000048310', u'ENSMUSG00000025758', u'ENSMUSG00000020623', u'ENSMUSG00000029521', u'ENSMUSG00000028032', u'ENSMUSG00000045038', u'ENSMUSG00000032384', u'ENSMUSG00000037251', u'ENSMUSG00000025199', u'ENSMUSG00000040648', u'ENSMUSG00000055540', u'ENSMUSG00000025059', u'ENSMUSG00000035824', u'ENSMUSG00000028926', u'ENSMUSG00000040390', u'ENSMUSG00000032308', u'ENSMUSG00000026622', u'ENSMUSG00000026620', u'ENSMUSG00000002413', u'ENSMUSG00000061207', u'ENSMUSG00000062234', u'ENSMUSG00000017291', u'ENSMUSG00000027952', u'ENSMUSG00000030275', u'ENSMUSG00000030272', u'ENSMUSG00000029366', u'ENSMUSG00000042724', u'ENSMUSG00000073563', u'ENSMUSG00000031478', u'ENSMUSG00000042349', u'ENSMUSG00000031805', u'ENSMUSG00000026437', u'ENSMUSG00000040021', u'ENSMUSG00000004936', u'ENSMUSG00000004933', u'ENSMUSG00000032409', u'ENSMUSG00000031392', u'ENSMUSG00000062044', u'ENSMUSG00000034290', u'ENSMUSG00000020357', u'ENSMUSG00000003283', u'ENSMUSG00000031155', u'ENSMUSG00000039913', u'ENSMUSG00000002963', u'ENSMUSG00000002688', u'ENSMUSG00000036095', u'ENSMUSG00000032571', u'ENSMUSG00000032577', u'ENSMUSG00000025537', u'ENSMUSG00000074305', u'ENSMUSG00000018846', u'ENSMUSG00000040325', u'ENSMUSG00000026842', u'ENSMUSG00000009772', u'ENSMUSG00000029245', u'ENSMUSG00000029710', u'ENSMUSG00000028664', u'ENSMUSG00000030655', u'ENSMUSG00000028661', u'ENSMUSG00000028719', u'ENSMUSG00000033276', u'ENSMUSG00000036273', u'ENSMUSG00000028862', u'ENSMUSG00000024620', u'ENSMUSG00000024621', u'ENSMUSG00000021385', u'ENSMUSG00000024235', u'ENSMUSG00000034751', u'ENSMUSG00000005469', u'ENSMUSG00000001729', u'ENSMUSG00000041135', u'ENSMUSG00000026667', u'ENSMUSG00000026662', u'ENSMUSG00000020700', u'ENSMUSG00000029403', u'ENSMUSG00000009555', u'ENSMUSG00000027297', u'ENSMUSG00000034974', u'ENSMUSG00000025007', u'ENSMUSG00000001034', u'ENSMUSG00000041187', u'ENSMUSG00000024247', u'ENSMUSG00000059456', u'ENSMUSG00000034371', u'ENSMUSG00000026749', u'ENSMUSG00000018932', u'ENSMUSG00000028969', u'ENSMUSG00000029674', u'ENSMUSG00000033628', u'ENSMUSG00000026274', u'ENSMUSG00000008730', u'ENSMUSG00000038970', u'ENSMUSG00000028289', u'ENSMUSG00000063410', u'ENSMUSG00000028458', u'ENSMUSG00000028284', u'ENSMUSG00000031537', u'ENSMUSG00000025162', u'ENSMUSG00000005672', u'ENSMUSG00000035878', u'ENSMUSG00000031432', u'ENSMUSG00000050965', u'ENSMUSG00000040451', u'ENSMUSG00000002748', u'ENSMUSG00000003810', u'ENSMUSG00000021279', u'ENSMUSG00000020015', u'ENSMUSG00000015133', u'ENSMUSG00000024383', u'ENSMUSG00000024843', u'ENSMUSG00000031668', u'ENSMUSG00000029063', u'ENSMUSG00000029062', u'ENSMUSG00000050271', u'ENSMUSG00000026074', u'ENSMUSG00000052430', u'ENSMUSG00000019970', u'ENSMUSG00000027296', u'ENSMUSG00000032537', u'ENSMUSG00000021428', u'ENSMUSG00000053436', u'ENSMUSG00000021936', u'ENSMUSG00000022836', u'ENSMUSG00000029162', u'ENSMUSG00000062604', u'ENSMUSG00000020516', u'ENSMUSG00000031065', u'ENSMUSG00000021180', u'ENSMUSG00000029613', u'ENSMUSG00000036737', u'ENSMUSG00000020451', u'ENSMUSG00000019577', u'ENSMUSG00000021948', u'ENSMUSG00000039954', u'ENSMUSG00000032547', u'ENSMUSG00000027298', u'ENSMUSG00000002550', u'ENSMUSG00000037885', u'ENSMUSG00000057897', u'ENSMUSG00000025915', u'ENSMUSG00000037738', u'ENSMUSG00000024242', u'ENSMUSG00000027797', u'ENSMUSG00000026817', u'ENSMUSG00000024079', u'ENSMUSG00000015981', u'ENSMUSG00000024969', u'ENSMUSG00000029334', u'ENSMUSG00000033065', u'ENSMUSG00000033526', u'ENSMUSG00000027496', u'ENSMUSG00000037643', u'ENSMUSG00000000276', u'ENSMUSG00000020941', u'ENSMUSG00000025648', u'ENSMUSG00000021115', u'ENSMUSG00000052504', u'ENSMUSG00000020580', u'ENSMUSG00000019699', u'ENSMUSG00000023908', u'ENSMUSG00000033703', u'ENSMUSG00000020638', u'ENSMUSG00000025139', u'ENSMUSG00000034902', u'ENSMUSG00000004085', u'ENSMUSG00000031565', u'ENSMUSG00000028527', u'ENSMUSG00000035683', u'ENSMUSG00000037012', u'ENSMUSG00000028959', u'ENSMUSG00000025357', u'ENSMUSG00000027646', u'ENSMUSG00000030867', u'ENSMUSG00000035112', u'ENSMUSG00000046707', u'ENSMUSG00000032316', u'ENSMUSG00000032312', u'ENSMUSG00000062209', u'ENSMUSG00000033966', u'ENSMUSG00000042978', u'ENSMUSG00000014361', u'ENSMUSG00000004798', u'ENSMUSG00000031314', u'ENSMUSG00000035064', u'ENSMUSG00000039197', u'ENSMUSG00000027030', u'ENSMUSG00000030815', u'ENSMUSG00000000308', u'ENSMUSG00000069089', u'ENSMUSG00000026034', u'ENSMUSG00000020122', u'ENSMUSG00000042817', u'ENSMUSG00000026558', u'ENSMUSG00000042249', u'ENSMUSG00000004591', u'ENSMUSG00000027177', u'ENSMUSG00000030660', u'ENSMUSG00000019235', u'ENSMUSG00000028530', u'ENSMUSG00000017376', u'ENSMUSG00000032462', u'ENSMUSG00000002602', u'ENSMUSG00000053158', u'ENSMUSG00000032500', u'ENSMUSG00000037847', u'ENSMUSG00000022329', u'ENSMUSG00000068917', u'ENSMUSG00000063065', u'ENSMUSG00000027379', u'ENSMUSG00000027692', u'ENSMUSG00000074886', u'ENSMUSG00000050890', u'ENSMUSG00000089872', u'ENSMUSG00000020573', u'ENSMUSG00000074923', u'ENSMUSG00000022607', u'ENSMUSG00000078816', u'ENSMUSG00000028874', u'ENSMUSG00000001630', u'ENSMUSG00000028876', u'ENSMUSG00000042608', u'ENSMUSG00000037601', u'ENSMUSG00000034761', u'ENSMUSG00000026674', u'ENSMUSG00000061578', u'ENSMUSG00000028680', u'ENSMUSG00000029471', u'ENSMUSG00000024952', u'ENSMUSG00000025375', u'ENSMUSG00000028518', u'ENSMUSG00000005534', u'ENSMUSG00000005533', u'ENSMUSG00000024558', u'ENSMUSG00000037112', u'ENSMUSG00000034744', u'ENSMUSG00000035390', u'ENSMUSG00000070644', u'ENSMUSG00000005034', u'ENSMUSG00000026779', u'ENSMUSG00000028991', u'ENSMUSG00000038481', u'ENSMUSG00000037593', u'ENSMUSG00000021701', u'ENSMUSG00000035891', u'ENSMUSG00000026489', u'ENSMUSG00000042046', u'ENSMUSG00000031450', u'ENSMUSG00000025175', u'ENSMUSG00000005102', u'ENSMUSG00000004040', u'ENSMUSG00000042567', u'ENSMUSG00000041440', u'ENSMUSG00000026277', u'ENSMUSG00000025178', u'ENSMUSG00000063179', u'ENSMUSG00000021196', u'ENSMUSG00000041997', u'ENSMUSG00000031853', u'ENSMUSG00000035027', u'ENSMUSG00000027079', u'ENSMUSG00000002007', u'ENSMUSG00000052889', u'ENSMUSG00000024070', u'ENSMUSG00000025854', u'ENSMUSG00000029648', u'ENSMUSG00000026094', u'ENSMUSG00000029056', u'ENSMUSG00000029053', u'ENSMUSG00000032788', u'ENSMUSG00000031292', u'ENSMUSG00000018166', u'ENSMUSG00000021796', u'ENSMUSG00000071369', u'ENSMUSG00000021820', u'ENSMUSG00000057963', u'ENSMUSG00000020115', u'ENSMUSG00000004815', u'ENSMUSG00000026393', u'ENSMUSG00000019843', u'ENSMUSG00000021413', u'ENSMUSG00000035828', u'ENSMUSG00000020277', u'ENSMUSG00000020272', u'ENSMUSG00000038128', u'ENSMUSG00000003345', u'ENSMUSG00000022791', u'ENSMUSG00000039936', u'ENSMUSG00000003068', u'ENSMUSG00000005958', u'ENSMUSG00000002948', u'ENSMUSG00000005951', u'ENSMUSG00000021959', u'ENSMUSG00000021483', u'ENSMUSG00000022253', u'ENSMUSG00000029283', u'ENSMUSG00000028479', u'ENSMUSG00000022812', u'ENSMUSG00000034135', u'ENSMUSG00000018547', u'ENSMUSG00000061436', u'ENSMUSG00000026737', u'ENSMUSG00000003119', u'ENSMUSG00000022550', u'ENSMUSG00000029231', u'ENSMUSG00000037795', u'ENSMUSG00000024576', u'ENSMUSG00000030602', u'ENSMUSG00000028630', u'ENSMUSG00000021044', u'ENSMUSG00000089917', u'ENSMUSG00000046854', u'ENSMUSG00000051590', u'ENSMUSG00000059883', u'ENSMUSG00000039058', u'ENSMUSG00000007411', u'ENSMUSG00000020990', u'ENSMUSG00000020857', u'ENSMUSG00000061878', u'ENSMUSG00000028126', u'ENSMUSG00000030774', u'ENSMUSG00000041245', u'ENSMUSG00000024858', u'ENSMUSG00000026235', u'ENSMUSG00000041323', u'ENSMUSG00000030890', u'ENSMUSG00000009376', u'ENSMUSG00000064090', u'ENSMUSG00000067336', u'ENSMUSG00000021457', u'ENSMUSG00000031309', u'ENSMUSG00000052783', u'ENSMUSG00000024867', u'ENSMUSG00000041939', u'ENSMUSG00000031303', u'ENSMUSG00000030397', u'ENSMUSG00000026281', u'ENSMUSG00000030802', u'ENSMUSG00000055254', u'ENSMUSG00000032175', u'ENSMUSG00000022033', u'ENSMUSG00000014932', u'ENSMUSG00000014426', u'ENSMUSG00000061751', u'ENSMUSG00000020032', u'ENSMUSG00000060733', u'ENSMUSG00000056458', u'ENSMUSG00000033352', u'ENSMUSG00000033985', u'ENSMUSG00000053414', u'ENSMUSG00000004865', u'ENSMUSG00000046947', u'ENSMUSG00000024006', u'ENSMUSG00000021918', u'ENSMUSG00000032294', u'ENSMUSG00000025417', u'ENSMUSG00000038379', u'ENSMUSG00000033610', u'ENSMUSG00000031284', u'ENSMUSG00000046709', u'ENSMUSG00000041297', u'ENSMUSG00000025665', u'ENSMUSG00000057672', u'ENSMUSG00000022617', u'ENSMUSG00000022263', u'ENSMUSG00000020080', u'ENSMUSG00000033618', u'ENSMUSG00000052155', u'ENSMUSG00000006494', u'ENSMUSG00000039253', u'ENSMUSG00000040274', u'ENSMUSG00000033557', u'ENSMUSG00000057177', u'ENSMUSG00000063358', u'ENSMUSG00000009828', u'ENSMUSG00000042688', u'ENSMUSG00000024948', u'ENSMUSG00000062960', u'ENSMUSG00000001755', u'ENSMUSG00000054252', u'ENSMUSG00000032594', u'ENSMUSG00000025742', u'ENSMUSG00000027207', u'ENSMUSG00000024899', u'ENSMUSG00000061462', u'ENSMUSG00000027365']), pop_n=13836, p_sm_bonferroni=0.010216541055149138, is_obsolete=False, GO='GO:0016310', name='phosphorylation', pop_count=529, alt_ids=[], level=5, depth=5, enrichment='e', Cluster='Late Decrease', geneid_set=set([u'ENSMUSG00000042817', u'ENSMUSG00000067336', u'ENSMUSG00000039145', u'ENSMUSG00000021559', u'ENSMUSG00000026596', u'ENSMUSG00000022263', u'ENSMUSG00000018547', u'ENSMUSG00000057897', u'ENSMUSG00000028664', u'ENSMUSG00000020827', u'ENSMUSG00000020451', u'ENSMUSG00000041720', u'ENSMUSG00000032500', u'ENSMUSG00000021385', u'ENSMUSG00000005469', u'ENSMUSG00000026207', u'ENSMUSG00000001034', u'ENSMUSG00000046709', u'ENSMUSG00000040479', u'ENSMUSG00000061751', u'ENSMUSG00000029403', u'ENSMUSG00000028078', u'ENSMUSG00000059146', u'ENSMUSG00000032599', u'ENSMUSG00000024122', u'ENSMUSG00000038128', u'ENSMUSG00000027296', u'ENSMUSG00000022791', u'ENSMUSG00000045038', u'ENSMUSG00000020785', u'ENSMUSG00000074923', u'ENSMUSG00000033526', u'ENSMUSG00000024242', u'ENSMUSG00000032384', u'ENSMUSG00000055540', u'ENSMUSG00000059456', u'ENSMUSG00000028926', u'ENSMUSG00000031833', u'ENSMUSG00000036095', u'ENSMUSG00000015599', u'ENSMUSG00000020580', u'ENSMUSG00000019699', u'ENSMUSG00000038970', u'ENSMUSG00000028289', u'ENSMUSG00000034902', u'ENSMUSG00000005672', u'ENSMUSG00000023050', u'ENSMUSG00000037012', u'ENSMUSG00000053137', u'ENSMUSG00000027646', u'ENSMUSG00000050965', u'ENSMUSG00000030397', u'ENSMUSG00000021701', u'ENSMUSG00000004936', u'ENSMUSG00000004933', u'ENSMUSG00000062044', u'ENSMUSG00000031012', u'ENSMUSG00000009681', u'ENSMUSG00000057177', u'ENSMUSG00000020015', u'ENSMUSG00000039058', u'ENSMUSG00000026834', u'ENSMUSG00000020990', u'ENSMUSG00000078816', u'ENSMUSG00000024867', u'ENSMUSG00000026489', u'ENSMUSG00000028126', u'ENSMUSG00000020277', u'ENSMUSG00000000308', u'ENSMUSG00000029916', u'ENSMUSG00000031284', u'ENSMUSG00000024617', u'ENSMUSG00000026235', u'ENSMUSG00000022861', u'ENSMUSG00000063358', u'ENSMUSG00000052889', u'ENSMUSG00000074305']), symbols=u'Abl2 Acvr1c Agk Ak5 Akt3 Bcr Bmpr2 Camk1d Camk2a Camk2b Camk4 Camkk1 Cask Cdk14 Cdk17 Cdkl1 Cdkl2 Ckmt1 Coq8a Csnk1g1 Dapk1 Dclk2 Dclk3 Dgkb Dgkg Dgkz Epha4 Epha6 Epha7 Ephb2 Flt3 Gsk3a Hk1 Ip6k2 Ippk Itpka Kalrn Kit Limk2 Lmtk2 Lmtk3 Map2k1 Map3k12 Map4k3 Mapk1 Mapk10 Mapk11 Mapk7 Mark4 Mast3 Matk Mink1 Ntrk3 Pak3 Pak6 Pdpk1 Peak1 Pfkl Pi4ka Pip4k2b Pip5k1a Pip5k1b Pip5k1c Plk2 Ppip5k1 Prkaca Prkca Prkcb Prkce Prkcg Ptk2b Rock2 Speg Src Tnk2 Trio Ttbk1', symbol_set=set([u'Dgkz', u'Mapk1', u'Acvr1c', u'Src', u'Kalrn', u'Ckmt1', u'Gsk3a', u'Camk2a', u'Camk2b', u'Cdk17', u'Map3k12', u'Csnk1g1', u'Bmpr2', u'Dgkb', u'Speg', u'Ip6k2', u'Dapk1', u'Lmtk2', u'Agk', u'Map4k3', u'Pi4ka', u'Limk2', u'Epha6', u'Pip5k1a', u'Epha4', u'Matk', u'Camkk1', u'Cdk14', u'Kit', 'Prkcg', u'Map2k1', u'Ntrk3', u'Ppip5k1', u'Mapk10', u'Mapk11', u'Ak5', 'Coq8a', u'Pfkl', u'Dgkg', u'Mink1', u'Prkcb', u'Lmtk3', u'Camk1d', u'Prkca', u'Cdkl1', u'Plk2', u'Prkce', u'Camk4', u'Cask', u'Cdkl2', u'Mark4', u'Akt3', u'Prkaca', u'Mapk7', u'Pak3', u'Pip5k1c', u'Pdpk1', u'Abl2', u'Flt3', u'Bcr', u'Ephb2', u'Tnk2', u'Trio', u'Rock2', 'Peak1', u'Hk1', u'Dclk3', u'Dclk2', u'Itpka', u'Epha7', u'Ptk2b', u'Mast3', u'Pip5k1b', u'Pak6', u'Ttbk1', u'Ippk', u'Pip4k2b']), geneids='ENSMUSG00000019699 ENSMUSG00000057897 ENSMUSG00000042817 ENSMUSG00000067336 ENSMUSG00000039145 ENSMUSG00000021559 ENSMUSG00000046709 ENSMUSG00000026596 ENSMUSG00000027646 ENSMUSG00000038970 ENSMUSG00000057177 ENSMUSG00000028289 ENSMUSG00000018547 ENSMUSG00000034902 ENSMUSG00000028664 ENSMUSG00000020827 ENSMUSG00000005672 ENSMUSG00000020451 ENSMUSG00000031833 ENSMUSG00000023050 ENSMUSG00000037012 ENSMUSG00000050965 ENSMUSG00000053137 ENSMUSG00000041720 ENSMUSG00000022263 ENSMUSG00000032500 ENSMUSG00000033526 ENSMUSG00000021385 ENSMUSG00000061751 ENSMUSG00000030397 ENSMUSG00000005469 ENSMUSG00000028078 ENSMUSG00000004936 ENSMUSG00000004933 ENSMUSG00000026207 ENSMUSG00000024242 ENSMUSG00000039058 ENSMUSG00000031012 ENSMUSG00000040479 ENSMUSG00000009681 ENSMUSG00000062044 ENSMUSG00000020277 ENSMUSG00000021701 ENSMUSG00000020015 ENSMUSG00000059146 ENSMUSG00000032599 ENSMUSG00000024122 ENSMUSG00000038128 ENSMUSG00000026489 ENSMUSG00000029403 ENSMUSG00000020990 ENSMUSG00000022791 ENSMUSG00000045038 ENSMUSG00000055540 ENSMUSG00000078816 ENSMUSG00000024867 ENSMUSG00000020785 ENSMUSG00000026834 ENSMUSG00000074923 ENSMUSG00000028926 ENSMUSG00000001034 ENSMUSG00000032384 ENSMUSG00000028126 ENSMUSG00000000308 ENSMUSG00000029916 ENSMUSG00000031284 ENSMUSG00000027296 ENSMUSG00000024617 ENSMUSG00000059456 ENSMUSG00000026235 ENSMUSG00000036095 ENSMUSG00000022861 ENSMUSG00000015599 ENSMUSG00000063358 ENSMUSG00000052889 ENSMUSG00000020580 ENSMUSG00000074305', format_txt=1, hdr_idx=1, is_hdrgo=True, is_usrgo=True, hdr1usr01='**', dcnt=138, D1='BD', GO_name='phosphorylation'),
    Nt(p_uncorrected=5.80788210390272e-06, study_count=10, study_n=1139, namespace='biological_process', p_fdr_bh=0.0011138635665345583, study_items=set([u'ENSMUSG00000051790', u'ENSMUSG00000059003', u'ENSMUSG00000005469', u'ENSMUSG00000020524', u'ENSMUSG00000062202', u'ENSMUSG00000028161', u'ENSMUSG00000032336', u'ENSMUSG00000063887', u'ENSMUSG00000015829', u'ENSMUSG00000031302']), NS='BP', pop_items=set([u'ENSMUSG00000009376', u'ENSMUSG00000003974', u'ENSMUSG00000032482', u'ENSMUSG00000063887', u'ENSMUSG00000038976', u'ENSMUSG00000023826', u'ENSMUSG00000059003', u'ENSMUSG00000051790', u'ENSMUSG00000031302', u'ENSMUSG00000025892', u'ENSMUSG00000032336', u'ENSMUSG00000042453', u'ENSMUSG00000005469', u'ENSMUSG00000049107', u'ENSMUSG00000062202', u'ENSMUSG00000015829', u'ENSMUSG00000020524', u'ENSMUSG00000033885', u'ENSMUSG00000028613', u'ENSMUSG00000032259', u'ENSMUSG00000056073', u'ENSMUSG00000028161', u'ENSMUSG00000020091']), pop_n=13836, p_sm_bonferroni=0.08799522175623012, is_obsolete=False, GO='GO:0050804', name='modulation of synaptic transmission', pop_count=23, alt_ids=[], level=4, depth=5, enrichment='e', Cluster='Late Decrease', geneid_set=set([u'ENSMUSG00000051790', u'ENSMUSG00000020524', u'ENSMUSG00000063887', u'ENSMUSG00000031302', u'ENSMUSG00000062202', u'ENSMUSG00000028161', u'ENSMUSG00000032336', u'ENSMUSG00000005469', u'ENSMUSG00000015829', u'ENSMUSG00000059003']), symbols=u'Btbd9 Gria1 Grin2a Nlgn1 Nlgn2 Nlgn3 Nptn Ppp3ca Prkaca Tnr', symbol_set=set([u'Nlgn2', u'Nlgn3', u'Nlgn1', u'Gria1', u'Nptn', u'Tnr', u'Grin2a', u'Btbd9', u'Prkaca', u'Ppp3ca']), geneids='ENSMUSG00000051790 ENSMUSG00000020524 ENSMUSG00000063887 ENSMUSG00000062202 ENSMUSG00000028161 ENSMUSG00000032336 ENSMUSG00000005469 ENSMUSG00000015829 ENSMUSG00000031302 ENSMUSG00000059003', format_txt=1, hdr_idx=1, is_hdrgo=True, is_usrgo=True, hdr1usr01='**', dcnt=126, D1='A', GO_name='modulation of synaptic transmission'),
    Nt(p_uncorrected='', study_count='', study_n='', namespace='', p_fdr_bh='', study_items='', NS='BP', pop_items='', pop_n='', p_sm_bonferroni='', is_obsolete='', GO='GO:0023052', name='', pop_count='', alt_ids='', level=1, depth=1, enrichment='', Cluster='', geneid_set='', symbols='', symbol_set='', geneids='', format_txt=1, hdr_idx=1, is_hdrgo=True, is_usrgo=False, hdr1usr01='*', dcnt=118, D1='Q', GO_name='signaling'),
    Nt(p_uncorrected='', study_count='', study_n='', namespace='', p_fdr_bh='', study_items='', NS='BP', pop_items='', pop_n='', p_sm_bonferroni='', is_obsolete='', GO='GO:0023051', name='', pop_count='', alt_ids='', level=3, depth=3, enrichment='', Cluster='', geneid_set='', symbols='', symbol_set='', geneids='', format_txt=1, hdr_idx=1, is_hdrgo=True, is_usrgo=False, hdr1usr01='*', dcnt=1395, D1='A', GO_name='regulation of signaling'),
    Nt(p_uncorrected=2.2000205203132044e-07, study_count=27, study_n=1139, namespace='biological_process', p_fdr_bh=6.802553245564358e-05, study_items=set([u'ENSMUSG00000025876', u'ENSMUSG00000026494', u'ENSMUSG00000049336', u'ENSMUSG00000038970', u'ENSMUSG00000028341', u'ENSMUSG00000028664', u'ENSMUSG00000048895', u'ENSMUSG00000060534', u'ENSMUSG00000058230', u'ENSMUSG00000029121', u'ENSMUSG00000032012', u'ENSMUSG00000020598', u'ENSMUSG00000024163', u'ENSMUSG00000056427', u'ENSMUSG00000031391', u'ENSMUSG00000069601', u'ENSMUSG00000029765', u'ENSMUSG00000039239', u'ENSMUSG00000025020', u'ENSMUSG00000031558', u'ENSMUSG00000022883', u'ENSMUSG00000022231', u'ENSMUSG00000020900', u'ENSMUSG00000030077', u'ENSMUSG00000026235', u'ENSMUSG00000074657', u'ENSMUSG00000047261']), NS='BP', pop_items=set([u'ENSMUSG00000026494', u'ENSMUSG00000032537', u'ENSMUSG00000005958', u'ENSMUSG00000008999', u'ENSMUSG00000021262', u'ENSMUSG00000059714', u'ENSMUSG00000028341', u'ENSMUSG00000029207', u'ENSMUSG00000003070', u'ENSMUSG00000048895', u'ENSMUSG00000032547', u'ENSMUSG00000058230', u'ENSMUSG00000064293', u'ENSMUSG00000042453', u'ENSMUSG00000020598', u'ENSMUSG00000024163', u'ENSMUSG00000028039', u'ENSMUSG00000039239', u'ENSMUSG00000051379', u'ENSMUSG00000052911', u'ENSMUSG00000060534', u'ENSMUSG00000074657', u'ENSMUSG00000049764', u'ENSMUSG00000021294', u'ENSMUSG00000063626', u'ENSMUSG00000027954', u'ENSMUSG00000022995', u'ENSMUSG00000048402', u'ENSMUSG00000001847', u'ENSMUSG00000028883', u'ENSMUSG00000024515', u'ENSMUSG00000029121', u'ENSMUSG00000000247', u'ENSMUSG00000032012', u'ENSMUSG00000048482', u'ENSMUSG00000052516', u'ENSMUSG00000067242', u'ENSMUSG00000059921', u'ENSMUSG00000031391', u'ENSMUSG00000031398', u'ENSMUSG00000056121', u'ENSMUSG00000025020', u'ENSMUSG00000031558', u'ENSMUSG00000048915', u'ENSMUSG00000022636', u'ENSMUSG00000022231', u'ENSMUSG00000000305', u'ENSMUSG00000001300', u'ENSMUSG00000030077', u'ENSMUSG00000026235', u'ENSMUSG00000025437', u'ENSMUSG00000036916', u'ENSMUSG00000038777', u'ENSMUSG00000000627', u'ENSMUSG00000021743', u'ENSMUSG00000035277', u'ENSMUSG00000003934', u'ENSMUSG00000025959', u'ENSMUSG00000024621', u'ENSMUSG00000019899', u'ENSMUSG00000029245', u'ENSMUSG00000028780', u'ENSMUSG00000028664', u'ENSMUSG00000021994', u'ENSMUSG00000028661', u'ENSMUSG00000030403', u'ENSMUSG00000034684', u'ENSMUSG00000004151', u'ENSMUSG00000022324', u'ENSMUSG00000047414', u'ENSMUSG00000049336', u'ENSMUSG00000025810', u'ENSMUSG00000025969', u'ENSMUSG00000021013', u'ENSMUSG00000049107', u'ENSMUSG00000029765', u'ENSMUSG00000029168', u'ENSMUSG00000022883', u'ENSMUSG00000021318', u'ENSMUSG00000056427', u'ENSMUSG00000022048', u'ENSMUSG00000020900', u'ENSMUSG00000020902', u'ENSMUSG00000032340', u'ENSMUSG00000053024', u'ENSMUSG00000019647', u'ENSMUSG00000022687', u'ENSMUSG00000025876', u'ENSMUSG00000062380', u'ENSMUSG00000038970', u'ENSMUSG00000029071', u'ENSMUSG00000026442', u'ENSMUSG00000052957', u'ENSMUSG00000032118', u'ENSMUSG00000043153', u'ENSMUSG00000025085', u'ENSMUSG00000021848', u'ENSMUSG00000030223', u'ENSMUSG00000069601', u'ENSMUSG00000038535', u'ENSMUSG00000019194', u'ENSMUSG00000031217', u'ENSMUSG00000037032', u'ENSMUSG00000047379', u'ENSMUSG00000027168', u'ENSMUSG00000006740', u'ENSMUSG00000032128', u'ENSMUSG00000061731', u'ENSMUSG00000048616', u'ENSMUSG00000047261', u'ENSMUSG00000020099']), pop_n=13836, p_sm_bonferroni=0.003333251090326536, is_obsolete=False, GO='GO:0007411', name='axon guidance', pop_count=111, alt_ids=['GO:0008040'], level=5, depth=5, enrichment='e', Cluster='Late Decrease', geneid_set=set([u'ENSMUSG00000025876', u'ENSMUSG00000026494', u'ENSMUSG00000031391', u'ENSMUSG00000069601', u'ENSMUSG00000047261', u'ENSMUSG00000029765', u'ENSMUSG00000024163', u'ENSMUSG00000049336', u'ENSMUSG00000039239', u'ENSMUSG00000022231', u'ENSMUSG00000038970', u'ENSMUSG00000031558', u'ENSMUSG00000022883', u'ENSMUSG00000028341', u'ENSMUSG00000028664', u'ENSMUSG00000048895', u'ENSMUSG00000026235', u'ENSMUSG00000025020', u'ENSMUSG00000058230', u'ENSMUSG00000029121', u'ENSMUSG00000056427', u'ENSMUSG00000032012', u'ENSMUSG00000030077', u'ENSMUSG00000060534', u'ENSMUSG00000074657', u'ENSMUSG00000020598', u'ENSMUSG00000020900']), symbols=u'Ank3 Arhgap35 Cdk5r1 Chl1 Crmp1 Dcc Epha4 Ephb2 Gap43 Kif26b Kif5a L1cam Lmtk2 Mapk8ip3 Myh10 Nectin1 Nr4a3 Nrcam Plxna4 Robo1 Sema5a Slit1 Slit2 Slit3 Tenm2 Tgfb2 Unc5a', symbol_set=set([u'Robo1', u'Kif5a', 'Nectin1', 'Arhgap35', u'Crmp1', u'Tgfb2', u'Gap43', u'Epha4', u'Dcc', 'Tenm2', u'Myh10', u'Lmtk2', u'Nr4a3', u'Cdk5r1', u'Slit2', u'Slit1', u'Chl1', u'Ephb2', u'Sema5a', u'Nrcam', u'Unc5a', u'Kif26b', u'Plxna4', u'Ank3', u'L1cam', u'Slit3', u'Mapk8ip3']), geneids='ENSMUSG00000025876 ENSMUSG00000026494 ENSMUSG00000049336 ENSMUSG00000038970 ENSMUSG00000028341 ENSMUSG00000028664 ENSMUSG00000048895 ENSMUSG00000060534 ENSMUSG00000058230 ENSMUSG00000029121 ENSMUSG00000032012 ENSMUSG00000020598 ENSMUSG00000024163 ENSMUSG00000056427 ENSMUSG00000031391 ENSMUSG00000069601 ENSMUSG00000029765 ENSMUSG00000039239 ENSMUSG00000025020 ENSMUSG00000031558 ENSMUSG00000022883 ENSMUSG00000022231 ENSMUSG00000020900 ENSMUSG00000030077 ENSMUSG00000026235 ENSMUSG00000074657 ENSMUSG00000047261', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=31, D1='BC', GO_name='axon guidance'),
    Nt(p_uncorrected=6.872801209718336e-05, study_count=14, study_n=1139, namespace='biological_process', p_fdr_bh=0.009466346466222046, study_items=set([u'ENSMUSG00000021670', u'ENSMUSG00000029104', u'ENSMUSG00000050321', u'ENSMUSG00000067629', u'ENSMUSG00000035168', u'ENSMUSG00000052087', u'ENSMUSG00000026596', u'ENSMUSG00000002028', u'ENSMUSG00000051331', u'ENSMUSG00000004110', u'ENSMUSG00000031302', u'ENSMUSG00000018634', u'ENSMUSG00000005672', u'ENSMUSG00000059003']), NS='BP', pop_items=set([u'ENSMUSG00000059003', u'ENSMUSG00000020716', u'ENSMUSG00000027950', u'ENSMUSG00000021684', u'ENSMUSG00000021478', u'ENSMUSG00000005949', u'ENSMUSG00000022892', u'ENSMUSG00000019890', u'ENSMUSG00000005672', u'ENSMUSG00000031367', u'ENSMUSG00000025485', u'ENSMUSG00000031302', u'ENSMUSG00000036564', u'ENSMUSG00000035910', u'ENSMUSG00000052087', u'ENSMUSG00000027210', u'ENSMUSG00000058886', u'ENSMUSG00000032405', u'ENSMUSG00000061313', u'ENSMUSG00000039358', u'ENSMUSG00000021109', u'ENSMUSG00000004110', u'ENSMUSG00000051331', u'ENSMUSG00000028991', u'ENSMUSG00000018634', u'ENSMUSG00000021670', u'ENSMUSG00000031393', u'ENSMUSG00000046876', u'ENSMUSG00000030265', u'ENSMUSG00000025809', u'ENSMUSG00000029104', u'ENSMUSG00000025958', u'ENSMUSG00000028541', u'ENSMUSG00000022489', u'ENSMUSG00000026596', u'ENSMUSG00000007097', u'ENSMUSG00000026959', u'ENSMUSG00000050541', u'ENSMUSG00000050321', u'ENSMUSG00000037032', u'ENSMUSG00000032259', u'ENSMUSG00000067629', u'ENSMUSG00000035168', u'ENSMUSG00000053004', u'ENSMUSG00000034987', u'ENSMUSG00000019970', u'ENSMUSG00000048616', u'ENSMUSG00000002028', u'ENSMUSG00000061718', u'ENSMUSG00000040907', u'ENSMUSG00000002413', u'ENSMUSG00000001105', u'ENSMUSG00000028969']), pop_n=13836, p_sm_bonferroni=1.0, is_obsolete=False, GO='GO:0008542', name='visual learning', pop_count=53, alt_ids=[], level=4, depth=8, enrichment='e', Cluster='Late Decrease', geneid_set=set([u'ENSMUSG00000021670', u'ENSMUSG00000029104', u'ENSMUSG00000050321', u'ENSMUSG00000067629', u'ENSMUSG00000035168', u'ENSMUSG00000052087', u'ENSMUSG00000026596', u'ENSMUSG00000002028', u'ENSMUSG00000051331', u'ENSMUSG00000004110', u'ENSMUSG00000031302', u'ENSMUSG00000018634', u'ENSMUSG00000005672', u'ENSMUSG00000059003']), symbols=u'Abl2 Cacna1c Cacna1e Crhr1 Grin2a Hmgcr Htt Kit Kmt2a Neto1 Nlgn3 Rgs14 Syngap1 Tanc1', symbol_set=set([u'Rgs14', u'Nlgn3', u'Cacna1c', u'Tanc1', 'Kmt2a', u'Kit', u'Cacna1e', u'Syngap1', u'Htt', u'Hmgcr', u'Neto1', u'Abl2', u'Grin2a', u'Crhr1']), geneids='ENSMUSG00000021670 ENSMUSG00000029104 ENSMUSG00000050321 ENSMUSG00000067629 ENSMUSG00000005672 ENSMUSG00000052087 ENSMUSG00000026596 ENSMUSG00000002028 ENSMUSG00000051331 ENSMUSG00000035168 ENSMUSG00000004110 ENSMUSG00000031302 ENSMUSG00000018634 ENSMUSG00000059003', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=0, D1='CFJN', GO_name='visual learning'),
    Nt(p_uncorrected=9.813776661937422e-05, study_count=11, study_n=1139, namespace='biological_process', p_fdr_bh=0.013019984549877149, study_items=set([u'ENSMUSG00000048240', u'ENSMUSG00000030209', u'ENSMUSG00000061751', u'ENSMUSG00000021721', u'ENSMUSG00000026344', u'ENSMUSG00000038255', u'ENSMUSG00000022619', u'ENSMUSG00000028004', u'ENSMUSG00000032532', u'ENSMUSG00000004110', u'ENSMUSG00000055078']), NS='BP', pop_items=set([u'ENSMUSG00000054814', u'ENSMUSG00000008892', u'ENSMUSG00000021684', u'ENSMUSG00000021478', u'ENSMUSG00000020516', u'ENSMUSG00000028004', u'ENSMUSG00000055078', u'ENSMUSG00000056755', u'ENSMUSG00000045573', u'ENSMUSG00000028156', u'ENSMUSG00000027239', u'ENSMUSG00000041380', u'ENSMUSG00000024533', u'ENSMUSG00000026024', u'ENSMUSG00000022619', u'ENSMUSG00000019803', u'ENSMUSG00000058886', u'ENSMUSG00000004110', u'ENSMUSG00000048240', u'ENSMUSG00000031393', u'ENSMUSG00000030209', u'ENSMUSG00000024256', u'ENSMUSG00000061751', u'ENSMUSG00000021721', u'ENSMUSG00000020402', u'ENSMUSG00000038255', u'ENSMUSG00000048482', u'ENSMUSG00000045983', u'ENSMUSG00000028351', u'ENSMUSG00000026344', u'ENSMUSG00000057329', u'ENSMUSG00000056073', u'ENSMUSG00000035000', u'ENSMUSG00000032532', u'ENSMUSG00000020883', u'ENSMUSG00000026385']), pop_n=13836, p_sm_bonferroni=1.0, is_obsolete=False, GO='GO:0001662', name='behavioral fear response', pop_count=36, alt_ids=[], level=3, depth=5, enrichment='e', Cluster='Late Decrease', geneid_set=set([u'ENSMUSG00000048240', u'ENSMUSG00000030209', u'ENSMUSG00000061751', u'ENSMUSG00000021721', u'ENSMUSG00000026344', u'ENSMUSG00000038255', u'ENSMUSG00000022619', u'ENSMUSG00000028004', u'ENSMUSG00000032532', u'ENSMUSG00000004110', u'ENSMUSG00000055078']), symbols=u'Cacna1e Cck Gabra5 Gng7 Grin2b Htr1a Kalrn Lypd1 Mapk8ip2 Neurod2 Npy2r', symbol_set=set([u'Neurod2', u'Lypd1', u'Kalrn', u'Cacna1e', u'Grin2b', u'Gng7', u'Npy2r', u'Cck', u'Gabra5', u'Htr1a', u'Mapk8ip2']), geneids='ENSMUSG00000048240 ENSMUSG00000030209 ENSMUSG00000061751 ENSMUSG00000021721 ENSMUSG00000026344 ENSMUSG00000038255 ENSMUSG00000022619 ENSMUSG00000028004 ENSMUSG00000032532 ENSMUSG00000004110 ENSMUSG00000055078', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=0, D1='CFJN', GO_name='behavioral fear response'),
    Nt(p_uncorrected='', study_count='', study_n='', namespace='', p_fdr_bh='', study_items='', NS='BP', pop_items='', pop_n='', p_sm_bonferroni='', is_obsolete='', GO='GO:0050767', name='', pop_count='', alt_ids='', level=6, depth=6, enrichment='', Cluster='', geneid_set='', symbols='', symbol_set='', geneids='', format_txt=1, hdr_idx=1, is_hdrgo=True, is_usrgo=False, hdr1usr01='*', dcnt=208, D1='A', GO_name='regulation of neurogenesis'),
    Nt(p_uncorrected=0.00031773577761303894, study_count=6, study_n=1139, namespace='biological_process', p_fdr_bh=0.034633199759821244, study_items=set([u'ENSMUSG00000041957', u'ENSMUSG00000051331', u'ENSMUSG00000020866', u'ENSMUSG00000049281', u'ENSMUSG00000015968', u'ENSMUSG00000040118']), NS='BP', pop_items=set([u'ENSMUSG00000041957', u'ENSMUSG00000064329', u'ENSMUSG00000019194', u'ENSMUSG00000046480', u'ENSMUSG00000039672', u'ENSMUSG00000032511', u'ENSMUSG00000070304', u'ENSMUSG00000041695', u'ENSMUSG00000051331', u'ENSMUSG00000020866', u'ENSMUSG00000049281', u'ENSMUSG00000015968', u'ENSMUSG00000040118']), pop_n=13836, p_sm_bonferroni=1.0, is_obsolete=False, GO='GO:0086002', name='cardiac muscle cell action potential involved in contraction', pop_count=13, alt_ids=[], level=6, depth=6, enrichment='e', Cluster='Late Decrease', geneid_set=set([u'ENSMUSG00000041957', u'ENSMUSG00000051331', u'ENSMUSG00000020866', u'ENSMUSG00000049281', u'ENSMUSG00000015968', u'ENSMUSG00000040118']), symbols=u'Cacna1c Cacna1d Cacna1g Cacna2d1 Pkp2 Scn3b', symbol_set=set([u'Cacna1c', u'Cacna1d', u'Cacna1g', u'Pkp2', u'Cacna2d1', u'Scn3b']), geneids='ENSMUSG00000041957 ENSMUSG00000051331 ENSMUSG00000020866 ENSMUSG00000049281 ENSMUSG00000015968 ENSMUSG00000040118', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=2, D1='A', GO_name='cardiac muscle cell action potential involved in contraction'),
    Nt(p_uncorrected=9.752941922374294e-05, study_count=16, study_n=1139, namespace='biological_process', p_fdr_bh=0.013019984549877149, study_items=set([u'ENSMUSG00000060681', u'ENSMUSG00000021730', u'ENSMUSG00000016346', u'ENSMUSG00000037579', u'ENSMUSG00000028033', u'ENSMUSG00000074575', u'ENSMUSG00000058248', u'ENSMUSG00000042604', u'ENSMUSG00000000197', u'ENSMUSG00000060882', u'ENSMUSG00000062785', u'ENSMUSG00000056258', u'ENSMUSG00000025221', u'ENSMUSG00000026062', u'ENSMUSG00000063142', u'ENSMUSG00000045053']), NS='BP', pop_items=set([u'ENSMUSG00000021730', u'ENSMUSG00000027895', u'ENSMUSG00000031129', u'ENSMUSG00000033854', u'ENSMUSG00000090122', u'ENSMUSG00000058248', u'ENSMUSG00000000197', u'ENSMUSG00000024957', u'ENSMUSG00000046410', u'ENSMUSG00000056258', u'ENSMUSG00000050556', u'ENSMUSG00000039672', u'ENSMUSG00000009731', u'ENSMUSG00000035681', u'ENSMUSG00000022342', u'ENSMUSG00000040164', u'ENSMUSG00000033998', u'ENSMUSG00000079056', u'ENSMUSG00000036760', u'ENSMUSG00000025221', u'ENSMUSG00000028631', u'ENSMUSG00000040724', u'ENSMUSG00000038319', u'ENSMUSG00000042604', u'ENSMUSG00000036353', u'ENSMUSG00000037610', u'ENSMUSG00000014786', u'ENSMUSG00000050963', u'ENSMUSG00000062785', u'ENSMUSG00000026062', u'ENSMUSG00000043673', u'ENSMUSG00000026065', u'ENSMUSG00000063142', u'ENSMUSG00000013495', u'ENSMUSG00000040896', u'ENSMUSG00000047959', u'ENSMUSG00000028854', u'ENSMUSG00000058975', u'ENSMUSG00000038077', u'ENSMUSG00000059742', u'ENSMUSG00000028051', u'ENSMUSG00000050138', u'ENSMUSG00000058740', u'ENSMUSG00000028033', u'ENSMUSG00000074575', u'ENSMUSG00000047976', u'ENSMUSG00000028420', u'ENSMUSG00000034402', u'ENSMUSG00000045404', u'ENSMUSG00000029088', u'ENSMUSG00000092083', u'ENSMUSG00000060681', u'ENSMUSG00000054477', u'ENSMUSG00000037341', u'ENSMUSG00000041695', u'ENSMUSG00000053519', u'ENSMUSG00000037624', u'ENSMUSG00000045053', u'ENSMUSG00000016346', u'ENSMUSG00000037579', u'ENSMUSG00000051726', u'ENSMUSG00000045246', u'ENSMUSG00000039463', u'ENSMUSG00000031791', u'ENSMUSG00000020331', u'ENSMUSG00000049265', u'ENSMUSG00000060882', u'ENSMUSG00000044708']), pop_n=13836, p_sm_bonferroni=1.0, is_obsolete=False, GO='GO:0071805', name='potassium ion transmembrane transport', pop_count=68, alt_ids=[], level=4, depth=9, enrichment='e', Cluster='Late Decrease', geneid_set=set([u'ENSMUSG00000021730', u'ENSMUSG00000028033', u'ENSMUSG00000074575', u'ENSMUSG00000058248', u'ENSMUSG00000000197', u'ENSMUSG00000056258', u'ENSMUSG00000060681', u'ENSMUSG00000045053', u'ENSMUSG00000016346', u'ENSMUSG00000037579', u'ENSMUSG00000042604', u'ENSMUSG00000063142', u'ENSMUSG00000062785', u'ENSMUSG00000026062', u'ENSMUSG00000025221', u'ENSMUSG00000060882']), symbols=u'Hcn1 Kcna4 Kcnc3 Kcnd2 Kcng1 Kcng3 Kcnh1 Kcnh3 Kcnip2 Kcnma1 Kcnq2 Kcnq3 Kcnq5 Nalcn Slc9a2 Slc9a6', symbol_set=set([u'Kcnc3', u'Slc9a6', u'Kcng3', u'Kcnh1', u'Slc9a2', u'Kcnh3', u'Nalcn', u'Hcn1', u'Kcng1', u'Kcnq5', u'Kcnq2', u'Kcnq3', u'Kcnma1', u'Kcnd2', u'Kcna4', u'Kcnip2']), geneids='ENSMUSG00000074575 ENSMUSG00000060681 ENSMUSG00000021730 ENSMUSG00000016346 ENSMUSG00000037579 ENSMUSG00000028033 ENSMUSG00000042604 ENSMUSG00000058248 ENSMUSG00000025221 ENSMUSG00000000197 ENSMUSG00000063142 ENSMUSG00000062785 ENSMUSG00000056258 ENSMUSG00000026062 ENSMUSG00000060882 ENSMUSG00000045053', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=5, D1='BCG', GO_name='potassium ion transmembrane transport'),
    Nt(p_uncorrected=8.967800210856022e-05, study_count=7, study_n=1139, namespace='biological_process', p_fdr_bh=0.012131351874524965, study_items=set([u'ENSMUSG00000002496', u'ENSMUSG00000031284', u'ENSMUSG00000026341', u'ENSMUSG00000037316', u'ENSMUSG00000045038', u'ENSMUSG00000031511', u'ENSMUSG00000054640']), NS='BP', pop_items=set([u'ENSMUSG00000022099', u'ENSMUSG00000026674', u'ENSMUSG00000040152', u'ENSMUSG00000002496', u'ENSMUSG00000002603', u'ENSMUSG00000030774', u'ENSMUSG00000026341', u'ENSMUSG00000031284', u'ENSMUSG00000037316', u'ENSMUSG00000045038', u'ENSMUSG00000001729', u'ENSMUSG00000031511', u'ENSMUSG00000054640', u'ENSMUSG00000031565', u'ENSMUSG00000020689']), pop_n=13836, p_sm_bonferroni=1.0, is_obsolete=False, GO='GO:0010763', name='positive regulation of fibroblast migration', pop_count=15, alt_ids=[], level=7, depth=8, enrichment='e', Cluster='Late Decrease', geneid_set=set([u'ENSMUSG00000002496', u'ENSMUSG00000037316', u'ENSMUSG00000045038', u'ENSMUSG00000054640', u'ENSMUSG00000031511', u'ENSMUSG00000026341', u'ENSMUSG00000031284']), symbols=u'Actr3 Arhgef7 Bag4 Pak3 Prkce Slc8a1 Tsc2', symbol_set=set([u'Bag4', u'Tsc2', u'Prkce', u'Arhgef7', u'Slc8a1', u'Actr3', u'Pak3']), geneids='ENSMUSG00000002496 ENSMUSG00000031284 ENSMUSG00000026341 ENSMUSG00000037316 ENSMUSG00000045038 ENSMUSG00000031511 ENSMUSG00000054640', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=0, D1='A', GO_name='positive regulation of fibroblast migration'),
    Nt(p_uncorrected=6.837147798318499e-05, study_count=5, study_n=1139, namespace='biological_process', p_fdr_bh=0.009466346466222046, study_items=set([u'ENSMUSG00000026235', u'ENSMUSG00000021068', u'ENSMUSG00000025128', u'ENSMUSG00000026872', u'ENSMUSG00000031673']), NS='BP', pop_items=set([u'ENSMUSG00000026235', u'ENSMUSG00000035764', u'ENSMUSG00000026872', u'ENSMUSG00000035456', u'ENSMUSG00000021068', u'ENSMUSG00000025128', u'ENSMUSG00000031673']), pop_n=13836, p_sm_bonferroni=1.0, is_obsolete=False, GO='GO:0021957', name='corticospinal tract morphogenesis', pop_count=7, alt_ids=[], level=9, depth=11, enrichment='e', Cluster='Late Decrease', geneid_set=set([u'ENSMUSG00000026235', u'ENSMUSG00000021068', u'ENSMUSG00000025128', u'ENSMUSG00000026872', u'ENSMUSG00000031673']), symbols=u'Bhlhe22 Cdh11 Epha4 Nin Zeb2', symbol_set=set([u'Cdh11', u'Bhlhe22', u'Epha4', u'Nin', u'Zeb2']), geneids='ENSMUSG00000026235 ENSMUSG00000021068 ENSMUSG00000025128 ENSMUSG00000026872 ENSMUSG00000031673', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=0, D1='BCEH', GO_name='corticospinal tract morphogenesis'),
    Nt(p_uncorrected=1.4241811172299513e-05, study_count=10, study_n=1139, namespace='biological_process', p_fdr_bh=0.002382583034603534, study_items=set([u'ENSMUSG00000021670', u'ENSMUSG00000022351', u'ENSMUSG00000001467', u'ENSMUSG00000059743', u'ENSMUSG00000021273', u'ENSMUSG00000031604', u'ENSMUSG00000006517', u'ENSMUSG00000034926', u'ENSMUSG00000045294', u'ENSMUSG00000032018']), NS='BP', pop_items=set([u'ENSMUSG00000001467', u'ENSMUSG00000031168', u'ENSMUSG00000027952', u'ENSMUSG00000050370', u'ENSMUSG00000006517', u'ENSMUSG00000034926', u'ENSMUSG00000050697', u'ENSMUSG00000028518', u'ENSMUSG00000041939', u'ENSMUSG00000058454', u'ENSMUSG00000024799', u'ENSMUSG00000032018', u'ENSMUSG00000026456', u'ENSMUSG00000018042', u'ENSMUSG00000021252', u'ENSMUSG00000021670', u'ENSMUSG00000059743', u'ENSMUSG00000021273', u'ENSMUSG00000031604', u'ENSMUSG00000003721', u'ENSMUSG00000004880', u'ENSMUSG00000045294', u'ENSMUSG00000022351', u'ENSMUSG00000031349', u'ENSMUSG00000027875']), pop_n=13836, p_sm_bonferroni=0.21577768107150994, is_obsolete=False, GO='GO:0016126', name='sterol biosynthetic process', pop_count=25, alt_ids=[], level=5, depth=6, enrichment='e', Cluster='Late Decrease', geneid_set=set([u'ENSMUSG00000021670', u'ENSMUSG00000022351', u'ENSMUSG00000001467', u'ENSMUSG00000059743', u'ENSMUSG00000021273', u'ENSMUSG00000031604', u'ENSMUSG00000006517', u'ENSMUSG00000034926', u'ENSMUSG00000045294', u'ENSMUSG00000032018']), symbols=u'Cyp51 Dhcr24 Fdft1 Fdps Hmgcr Insig1 Msmo1 Mvd Sc5d Sqle', symbol_set=set(['Msmo1', u'Fdps', u'Cyp51', u'Sc5d', u'Mvd', u'Hmgcr', u'Insig1', u'Fdft1', u'Sqle', u'Dhcr24']), geneids='ENSMUSG00000021670 ENSMUSG00000022351 ENSMUSG00000001467 ENSMUSG00000059743 ENSMUSG00000021273 ENSMUSG00000031604 ENSMUSG00000006517 ENSMUSG00000034926 ENSMUSG00000045294 ENSMUSG00000032018', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=7, D1='CD', GO_name='sterol biosynthetic process'),
    Nt(p_uncorrected=2.7712893450742414e-05, study_count=7, study_n=1139, namespace='biological_process', p_fdr_bh=0.004198780486721983, study_items=set([u'ENSMUSG00000048895', u'ENSMUSG00000030209', u'ENSMUSG00000020300', u'ENSMUSG00000059456', u'ENSMUSG00000033981', u'ENSMUSG00000024617', u'ENSMUSG00000059003']), NS='BP', pop_items=set([u'ENSMUSG00000048895', u'ENSMUSG00000030209', u'ENSMUSG00000020300', u'ENSMUSG00000030720', u'ENSMUSG00000059456', u'ENSMUSG00000033981', u'ENSMUSG00000024617', u'ENSMUSG00000040907', u'ENSMUSG00000022892', u'ENSMUSG00000026959', u'ENSMUSG00000039579', u'ENSMUSG00000022935', u'ENSMUSG00000059003']), pop_n=13836, p_sm_bonferroni=0.4198780486721983, is_obsolete=False, GO='GO:0035235', name='ionotropic glutamate receptor signaling pathway', pop_count=13, alt_ids=[], level=5, depth=7, enrichment='e', Cluster='Late Decrease', geneid_set=set([u'ENSMUSG00000048895', u'ENSMUSG00000030209', u'ENSMUSG00000020300', u'ENSMUSG00000059456', u'ENSMUSG00000059003', u'ENSMUSG00000033981', u'ENSMUSG00000024617']), symbols=u'Camk2a Cdk5r1 Cpeb4 Gria2 Grin2a Grin2b Ptk2b', symbol_set=set([u'Gria2', u'Cpeb4', u'Camk2a', u'Grin2b', u'Ptk2b', u'Grin2a', u'Cdk5r1']), geneids='ENSMUSG00000048895 ENSMUSG00000030209 ENSMUSG00000020300 ENSMUSG00000059456 ENSMUSG00000033981 ENSMUSG00000024617 ENSMUSG00000059003', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=3, D1='AB', GO_name='ionotropic glutamate receptor signaling pathway'),
    Nt(p_uncorrected='', study_count='', study_n='', namespace='', p_fdr_bh='', study_items='', NS='BP', pop_items='', pop_n='', p_sm_bonferroni='', is_obsolete='', GO='GO:0006874', name='', pop_count='', alt_ids='', level=8, depth=9, enrichment='', Cluster='', geneid_set='', symbols='', symbol_set='', geneids='', format_txt=1, hdr_idx=1, is_hdrgo=True, is_usrgo=False, hdr1usr01='*', dcnt=36, D1='ABC', GO_name='cellular calcium ion homeostasis'),
    Nt(p_uncorrected=0.000412782873936067, study_count=15, study_n=1139, namespace='biological_process', p_fdr_bh=0.04283611865072158, study_items=set([u'ENSMUSG00000068205', u'ENSMUSG00000031229', u'ENSMUSG00000029238', u'ENSMUSG00000031422', u'ENSMUSG00000035401', u'ENSMUSG00000063358', u'ENSMUSG00000028086', u'ENSMUSG00000024767', u'ENSMUSG00000030451', u'ENSMUSG00000028426', u'ENSMUSG00000024947', u'ENSMUSG00000043909', u'ENSMUSG00000054051', u'ENSMUSG00000027104', u'ENSMUSG00000043535']), NS='BP', pop_items=set([u'ENSMUSG00000033721', u'ENSMUSG00000047617', u'ENSMUSG00000026496', u'ENSMUSG00000003873', u'ENSMUSG00000047757', u'ENSMUSG00000053914', u'ENSMUSG00000046591', u'ENSMUSG00000031583', u'ENSMUSG00000016528', u'ENSMUSG00000041974', u'ENSMUSG00000007080', u'ENSMUSG00000027845', u'ENSMUSG00000027663', u'ENSMUSG00000028933', u'ENSMUSG00000027067', u'ENSMUSG00000019470', u'ENSMUSG00000017146', u'ENSMUSG00000020752', u'ENSMUSG00000021400', u'ENSMUSG00000030166', u'ENSMUSG00000042228', u'ENSMUSG00000059981', u'ENSMUSG00000031347', u'ENSMUSG00000061288', u'ENSMUSG00000023067', u'ENSMUSG00000035726', u'ENSMUSG00000026439', u'ENSMUSG00000026429', u'ENSMUSG00000025932', u'ENSMUSG00000036390', u'ENSMUSG00000039615', u'ENSMUSG00000025939', u'ENSMUSG00000069495', u'ENSMUSG00000024429', u'ENSMUSG00000056394', u'ENSMUSG00000073684', u'ENSMUSG00000031644', u'ENSMUSG00000053175', u'ENSMUSG00000022710', u'ENSMUSG00000024193', u'ENSMUSG00000024767', u'ENSMUSG00000006599', u'ENSMUSG00000036781', u'ENSMUSG00000046806', u'ENSMUSG00000021133', u'ENSMUSG00000058761', u'ENSMUSG00000069089', u'ENSMUSG00000024906', u'ENSMUSG00000022545', u'ENSMUSG00000029387', u'ENSMUSG00000005370', u'ENSMUSG00000034218', u'ENSMUSG00000038225', u'ENSMUSG00000027242', u'ENSMUSG00000068264', u'ENSMUSG00000025159', u'ENSMUSG00000030400', u'ENSMUSG00000041238', u'ENSMUSG00000020914', u'ENSMUSG00000030493', u'ENSMUSG00000040204', u'ENSMUSG00000004018', u'ENSMUSG00000092118', u'ENSMUSG00000025269', u'ENSMUSG00000051768', u'ENSMUSG00000039623', u'ENSMUSG00000063358', u'ENSMUSG00000035486', u'ENSMUSG00000030538', u'ENSMUSG00000026187', u'ENSMUSG00000031422', u'ENSMUSG00000035764', u'ENSMUSG00000021245', u'ENSMUSG00000025878', u'ENSMUSG00000031201', u'ENSMUSG00000025077', u'ENSMUSG00000044702', u'ENSMUSG00000003549', u'ENSMUSG00000036061', u'ENSMUSG00000032113', u'ENSMUSG00000029003', u'ENSMUSG00000061175', u'ENSMUSG00000038005', u'ENSMUSG00000062270', u'ENSMUSG00000061607', u'ENSMUSG00000024151', u'ENSMUSG00000005871', u'ENSMUSG00000022672', u'ENSMUSG00000017550', u'ENSMUSG00000001228', u'ENSMUSG00000012483', u'ENSMUSG00000036202', u'ENSMUSG00000015971', u'ENSMUSG00000064289', u'ENSMUSG00000079109', u'ENSMUSG00000046295', u'ENSMUSG00000021668', u'ENSMUSG00000024974', u'ENSMUSG00000020694', u'ENSMUSG00000020697', u'ENSMUSG00000025358', u'ENSMUSG00000030726', u'ENSMUSG00000029591', u'ENSMUSG00000030750', u'ENSMUSG00000030994', u'ENSMUSG00000022471', u'ENSMUSG00000030990', u'ENSMUSG00000025616', u'ENSMUSG00000020381', u'ENSMUSG00000020380', u'ENSMUSG00000020898', u'ENSMUSG00000034329', u'ENSMUSG00000037487', u'ENSMUSG00000035234', u'ENSMUSG00000029524', u'ENSMUSG00000039748', u'ENSMUSG00000029521', u'ENSMUSG00000033712', u'ENSMUSG00000023932', u'ENSMUSG00000020185', u'ENSMUSG00000003868', u'ENSMUSG00000042185', u'ENSMUSG00000038069', u'ENSMUSG00000031575', u'ENSMUSG00000030051', u'ENSMUSG00000021615', u'ENSMUSG00000059772', u'ENSMUSG00000017291', u'ENSMUSG00000021470', u'ENSMUSG00000028329', u'ENSMUSG00000034023', u'ENSMUSG00000030271', u'ENSMUSG00000045102', u'ENSMUSG00000022945', u'ENSMUSG00000032397', u'ENSMUSG00000078578', u'ENSMUSG00000014850', u'ENSMUSG00000042349', u'ENSMUSG00000078671', u'ENSMUSG00000002661', u'ENSMUSG00000078773', u'ENSMUSG00000032409', u'ENSMUSG00000022906', u'ENSMUSG00000002963', u'ENSMUSG00000031628', u'ENSMUSG00000031095', u'ENSMUSG00000049717', u'ENSMUSG00000036097', u'ENSMUSG00000028354', u'ENSMUSG00000018841', u'ENSMUSG00000031820', u'ENSMUSG00000026842', u'ENSMUSG00000020413', u'ENSMUSG00000028669', u'ENSMUSG00000020415', u'ENSMUSG00000030655', u'ENSMUSG00000010067', u'ENSMUSG00000038544', u'ENSMUSG00000021597', u'ENSMUSG00000006288', u'ENSMUSG00000036278', u'ENSMUSG00000025899', u'ENSMUSG00000034206', u'ENSMUSG00000020228', u'ENSMUSG00000014074', u'ENSMUSG00000000148', u'ENSMUSG00000001729', u'ENSMUSG00000041133', u'ENSMUSG00000025384', u'ENSMUSG00000033458', u'ENSMUSG00000033596', u'ENSMUSG00000001924', u'ENSMUSG00000059586', u'ENSMUSG00000002109', u'ENSMUSG00000026669', u'ENSMUSG00000005481', u'ENSMUSG00000009555', u'ENSMUSG00000028560', u'ENSMUSG00000055884', u'ENSMUSG00000024521', u'ENSMUSG00000027342', u'ENSMUSG00000026219', u'ENSMUSG00000043909', u'ENSMUSG00000021258', u'ENSMUSG00000055401', u'ENSMUSG00000040850', u'ENSMUSG00000031446', u'ENSMUSG00000031536', u'ENSMUSG00000031928', u'ENSMUSG00000049932', u'ENSMUSG00000037355', u'ENSMUSG00000028914', u'ENSMUSG00000035401', u'ENSMUSG00000026107', u'ENSMUSG00000058594', u'ENSMUSG00000002748', u'ENSMUSG00000003813', u'ENSMUSG00000001517', u'ENSMUSG00000030346', u'ENSMUSG00000021276', u'ENSMUSG00000090112', u'ENSMUSG00000024382', u'ENSMUSG00000026082', u'ENSMUSG00000073705', u'ENSMUSG00000052934', u'ENSMUSG00000035390', u'ENSMUSG00000033454', u'ENSMUSG00000040174', u'ENSMUSG00000002083', u'ENSMUSG00000019970', u'ENSMUSG00000049502', u'ENSMUSG00000032534', u'ENSMUSG00000053436', u'ENSMUSG00000006335', u'ENSMUSG00000027544', u'ENSMUSG00000074781', u'ENSMUSG00000038425', u'ENSMUSG00000029920', u'ENSMUSG00000025507', u'ENSMUSG00000070348', u'ENSMUSG00000028820', u'ENSMUSG00000022248', u'ENSMUSG00000020063', u'ENSMUSG00000039354', u'ENSMUSG00000007646', u'ENSMUSG00000025261', u'ENSMUSG00000039231', u'ENSMUSG00000020423', u'ENSMUSG00000021690', u'ENSMUSG00000021694', u'ENSMUSG00000021287', u'ENSMUSG00000028629', u'ENSMUSG00000025218', u'ENSMUSG00000022400', u'ENSMUSG00000047989', u'ENSMUSG00000036875', u'ENSMUSG00000068205', u'ENSMUSG00000059552', u'ENSMUSG00000035842', u'ENSMUSG00000028411', u'ENSMUSG00000059263', u'ENSMUSG00000020287', u'ENSMUSG00000000552', u'ENSMUSG00000034345', u'ENSMUSG00000037461', u'ENSMUSG00000018750', u'ENSMUSG00000021461', u'ENSMUSG00000014243', u'ENSMUSG00000031311', u'ENSMUSG00000031314', u'ENSMUSG00000037262', u'ENSMUSG00000022141', u'ENSMUSG00000048668', u'ENSMUSG00000038774', u'ENSMUSG00000031229', u'ENSMUSG00000055932', u'ENSMUSG00000027424', u'ENSMUSG00000036086', u'ENSMUSG00000029026', u'ENSMUSG00000039994', u'ENSMUSG00000032267', u'ENSMUSG00000090083', u'ENSMUSG00000054051', u'ENSMUSG00000079235', u'ENSMUSG00000024742', u'ENSMUSG00000001524', u'ENSMUSG00000024740', u'ENSMUSG00000026914', u'ENSMUSG00000038369', u'ENSMUSG00000063065', u'ENSMUSG00000035365', u'ENSMUSG00000044167', u'ENSMUSG00000020546', u'ENSMUSG00000043987', u'ENSMUSG00000030079', u'ENSMUSG00000033102', u'ENSMUSG00000037761', u'ENSMUSG00000057329', u'ENSMUSG00000028702', u'ENSMUSG00000024735', u'ENSMUSG00000020471', u'ENSMUSG00000027104', u'ENSMUSG00000032498', u'ENSMUSG00000028680', u'ENSMUSG00000039738', u'ENSMUSG00000025374', u'ENSMUSG00000030034', u'ENSMUSG00000035960', u'ENSMUSG00000030641', u'ENSMUSG00000037111', u'ENSMUSG00000070520', u'ENSMUSG00000027353', u'ENSMUSG00000030451', u'ENSMUSG00000028426', u'ENSMUSG00000040865', u'ENSMUSG00000031986', u'ENSMUSG00000027671', u'ENSMUSG00000028453', u'ENSMUSG00000028452', u'ENSMUSG00000041997', u'ENSMUSG00000020608', u'ENSMUSG00000026077', u'ENSMUSG00000028224', u'ENSMUSG00000000355', u'ENSMUSG00000021264', u'ENSMUSG00000053110', u'ENSMUSG00000038028', u'ENSMUSG00000019841', u'ENSMUSG00000019969', u'ENSMUSG00000024283', u'ENSMUSG00000018189', u'ENSMUSG00000041147', u'ENSMUSG00000003068', u'ENSMUSG00000009628', u'ENSMUSG00000032555', u'ENSMUSG00000022314', u'ENSMUSG00000038644', u'ENSMUSG00000061436', u'ENSMUSG00000032815', u'ENSMUSG00000029730', u'ENSMUSG00000038685', u'ENSMUSG00000028884', u'ENSMUSG00000030609', u'ENSMUSG00000029238', u'ENSMUSG00000035354', u'ENSMUSG00000034154', u'ENSMUSG00000049300', u'ENSMUSG00000004221', u'ENSMUSG00000024824', u'ENSMUSG00000045751', u'ENSMUSG00000025144', u'ENSMUSG00000043535', u'ENSMUSG00000028089', u'ENSMUSG00000024854', u'ENSMUSG00000037570', u'ENSMUSG00000037474', u'ENSMUSG00000030779', u'ENSMUSG00000028086', u'ENSMUSG00000027323', u'ENSMUSG00000021635', u'ENSMUSG00000035105', u'ENSMUSG00000042489', u'ENSMUSG00000021639', u'ENSMUSG00000030094', u'ENSMUSG00000027933', u'ENSMUSG00000026196', u'ENSMUSG00000030254', u'ENSMUSG00000030528', u'ENSMUSG00000073436', u'ENSMUSG00000031826', u'ENSMUSG00000039187', u'ENSMUSG00000066440', u'ENSMUSG00000032376', u'ENSMUSG00000040433', u'ENSMUSG00000020156', u'ENSMUSG00000026048', u'ENSMUSG00000022292', u'ENSMUSG00000061755', u'ENSMUSG00000000838', u'ENSMUSG00000030322', u'ENSMUSG00000020032', u'ENSMUSG00000061759', u'ENSMUSG00000051238', u'ENSMUSG00000051235', u'ENSMUSG00000020235', u'ENSMUSG00000010461', u'ENSMUSG00000032512', u'ENSMUSG00000002221', u'ENSMUSG00000032298', u'ENSMUSG00000021911', u'ENSMUSG00000019432', u'ENSMUSG00000021918', u'ENSMUSG00000060862', u'ENSMUSG00000020474', u'ENSMUSG00000022508', u'ENSMUSG00000002835', u'ENSMUSG00000044627', u'ENSMUSG00000047388', u'ENSMUSG00000058298', u'ENSMUSG00000022346', u'ENSMUSG00000030086', u'ENSMUSG00000034674', u'ENSMUSG00000024317', u'ENSMUSG00000000751', u'ENSMUSG00000036822', u'ENSMUSG00000026648', u'ENSMUSG00000024943', u'ENSMUSG00000035958', u'ENSMUSG00000024947', u'ENSMUSG00000058317', u'ENSMUSG00000025066', u'ENSMUSG00000023953', u'ENSMUSG00000030744', u'ENSMUSG00000037032', u'ENSMUSG00000030983', u'ENSMUSG00000020390', u'ENSMUSG00000028886', u'ENSMUSG00000027164', u'ENSMUSG00000052139', u'ENSMUSG00000016308']), pop_n=13836, p_sm_bonferroni=1.0, is_obsolete=False, GO='GO:0006974', name='cellular response to DNA damage stimulus', pop_count=400, alt_ids=['GO:0034984'], level=4, depth=4, enrichment='p', Cluster='Late Decrease', geneid_set=set([u'ENSMUSG00000068205', u'ENSMUSG00000031229', u'ENSMUSG00000029238', u'ENSMUSG00000031422', u'ENSMUSG00000035401', u'ENSMUSG00000063358', u'ENSMUSG00000028086', u'ENSMUSG00000024767', u'ENSMUSG00000030451', u'ENSMUSG00000028426', u'ENSMUSG00000024947', u'ENSMUSG00000043909', u'ENSMUSG00000054051', u'ENSMUSG00000027104', u'ENSMUSG00000043535']), symbols=u'Atf2 Atrx Clock Emsy Ercc6 Fbxw7 Herc2 Macrod2 Mapk1 Men1 Morf4l2 Otub1 Rad23b Setx Trp53bp1', symbol_set=set(['Emsy', u'Rad23b', u'Clock', u'Setx', u'Trp53bp1', u'Herc2', u'Ercc6', u'Men1', u'Mapk1', u'Macrod2', u'Atrx', u'Atf2', u'Otub1', u'Morf4l2', u'Fbxw7']), geneids='ENSMUSG00000068205 ENSMUSG00000031229 ENSMUSG00000029238 ENSMUSG00000031422 ENSMUSG00000035401 ENSMUSG00000063358 ENSMUSG00000028086 ENSMUSG00000024767 ENSMUSG00000030451 ENSMUSG00000028426 ENSMUSG00000024947 ENSMUSG00000043909 ENSMUSG00000054051 ENSMUSG00000027104 ENSMUSG00000043535', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=80, D1='BF', GO_name='cellular response to DNA damage stimulus'),
    Nt(p_uncorrected=4.766912339121224e-08, study_count=25, study_n=1139, namespace='biological_process', p_fdr_bh=1.7615485085372115e-05, study_items=set([u'ENSMUSG00000043811', u'ENSMUSG00000048251', u'ENSMUSG00000019790', u'ENSMUSG00000034902', u'ENSMUSG00000044667', u'ENSMUSG00000033214', u'ENSMUSG00000049556', u'ENSMUSG00000025427', u'ENSMUSG00000021066', u'ENSMUSG00000011751', u'ENSMUSG00000063160', u'ENSMUSG00000069601', u'ENSMUSG00000061751', u'ENSMUSG00000025020', u'ENSMUSG00000031558', u'ENSMUSG00000029223', u'ENSMUSG00000040490', u'ENSMUSG00000020900', u'ENSMUSG00000052727', u'ENSMUSG00000031284', u'ENSMUSG00000035513', u'ENSMUSG00000032532', u'ENSMUSG00000039114', u'ENSMUSG00000048304', u'ENSMUSG00000015222']), NS='BP', pop_items=set([u'ENSMUSG00000029512', u'ENSMUSG00000048251', u'ENSMUSG00000026923', u'ENSMUSG00000046699', u'ENSMUSG00000059714', u'ENSMUSG00000030849', u'ENSMUSG00000032547', u'ENSMUSG00000059857', u'ENSMUSG00000021066', u'ENSMUSG00000011751', u'ENSMUSG00000027797', u'ENSMUSG00000039233', u'ENSMUSG00000040490', u'ENSMUSG00000003068', u'ENSMUSG00000033396', u'ENSMUSG00000020671', u'ENSMUSG00000033419', u'ENSMUSG00000032259', u'ENSMUSG00000028832', u'ENSMUSG00000048304', u'ENSMUSG00000015222', u'ENSMUSG00000043811', u'ENSMUSG00000020431', u'ENSMUSG00000028556', u'ENSMUSG00000034902', u'ENSMUSG00000044667', u'ENSMUSG00000020536', u'ENSMUSG00000026024', u'ENSMUSG00000030600', u'ENSMUSG00000039361', u'ENSMUSG00000025020', u'ENSMUSG00000031558', u'ENSMUSG00000004798', u'ENSMUSG00000021983', u'ENSMUSG00000043733', u'ENSMUSG00000029223', u'ENSMUSG00000030774', u'ENSMUSG00000026131', u'ENSMUSG00000035513', u'ENSMUSG00000039114', u'ENSMUSG00000041559', u'ENSMUSG00000036790', u'ENSMUSG00000075224', u'ENSMUSG00000028064', u'ENSMUSG00000025959', u'ENSMUSG00000025958', u'ENSMUSG00000049556', u'ENSMUSG00000003037', u'ENSMUSG00000021994', u'ENSMUSG00000021224', u'ENSMUSG00000043631', u'ENSMUSG00000025427', u'ENSMUSG00000050947', u'ENSMUSG00000063063', u'ENSMUSG00000061751', u'ENSMUSG00000055003', u'ENSMUSG00000045045', u'ENSMUSG00000020900', u'ENSMUSG00000057329', u'ENSMUSG00000020902', u'ENSMUSG00000024527', u'ENSMUSG00000053024', u'ENSMUSG00000021390', u'ENSMUSG00000028969', u'ENSMUSG00000033585', u'ENSMUSG00000019790', u'ENSMUSG00000022892', u'ENSMUSG00000029071', u'ENSMUSG00000005533', u'ENSMUSG00000018411', u'ENSMUSG00000035390', u'ENSMUSG00000017485', u'ENSMUSG00000075478', u'ENSMUSG00000031840', u'ENSMUSG00000021645', u'ENSMUSG00000063160', u'ENSMUSG00000022812', u'ENSMUSG00000069601', u'ENSMUSG00000033214', u'ENSMUSG00000005871', u'ENSMUSG00000017781', u'ENSMUSG00000029580', u'ENSMUSG00000006782', u'ENSMUSG00000068748', u'ENSMUSG00000027168', u'ENSMUSG00000053046', u'ENSMUSG00000041362', u'ENSMUSG00000052727', u'ENSMUSG00000031284', u'ENSMUSG00000032532', u'ENSMUSG00000036957']), pop_n=13836, p_sm_bonferroni=0.0007222348885002566, is_obsolete=False, GO='GO:0007409', name='axonogenesis', pop_count=91, alt_ids=['GO:0007410'], level=6, depth=8, enrichment='e', Cluster='Late Decrease', geneid_set=set([u'ENSMUSG00000043811', u'ENSMUSG00000069601', u'ENSMUSG00000048251', u'ENSMUSG00000019790', u'ENSMUSG00000025020', u'ENSMUSG00000031558', u'ENSMUSG00000034902', u'ENSMUSG00000048304', u'ENSMUSG00000044667', u'ENSMUSG00000033214', u'ENSMUSG00000029223', u'ENSMUSG00000061751', u'ENSMUSG00000040490', u'ENSMUSG00000020900', u'ENSMUSG00000052727', u'ENSMUSG00000031284', u'ENSMUSG00000049556', u'ENSMUSG00000035513', u'ENSMUSG00000025427', u'ENSMUSG00000032532', u'ENSMUSG00000021066', u'ENSMUSG00000039114', u'ENSMUSG00000011751', u'ENSMUSG00000063160', u'ENSMUSG00000015222']), symbols=u'Ank3 Atl1 Bcl11b Cck Kalrn Lingo1 Lrfn2 Map1b Map2 Myh10 Nrn1 Ntng2 Numbl Pak3 Pip5k1c Plppr4 Rnf165 Rtn4r Slit1 Slit2 Slitrk3 Slitrk5 Sptbn4 Stxbp5 Uchl1', symbol_set=set([u'Myh10', u'Cck', u'Ntng2', u'Kalrn', 'Map1b', u'Rnf165', u'Pip5k1c', u'Atl1', u'Lrfn2', 'Plppr4', u'Nrn1', 'Map2', u'Rtn4r', u'Stxbp5', u'Slit2', u'Slit1', 'Sptbn4', u'Slitrk5', u'Slitrk3', u'Lingo1', u'Bcl11b', u'Ank3', u'Numbl', u'Uchl1', u'Pak3']), geneids='ENSMUSG00000043811 ENSMUSG00000048251 ENSMUSG00000019790 ENSMUSG00000034902 ENSMUSG00000044667 ENSMUSG00000033214 ENSMUSG00000049556 ENSMUSG00000025427 ENSMUSG00000021066 ENSMUSG00000011751 ENSMUSG00000063160 ENSMUSG00000069601 ENSMUSG00000061751 ENSMUSG00000040490 ENSMUSG00000031558 ENSMUSG00000029223 ENSMUSG00000025020 ENSMUSG00000020900 ENSMUSG00000052727 ENSMUSG00000031284 ENSMUSG00000035513 ENSMUSG00000032532 ENSMUSG00000039114 ENSMUSG00000048304 ENSMUSG00000015222', format_txt=1, hdr_idx=1, is_hdrgo=True, is_usrgo=True, hdr1usr01='**', dcnt=23, D1='BCEH', GO_name='axonogenesis'),
    Nt(p_uncorrected='', study_count='', study_n='', namespace='', p_fdr_bh='', study_items='', NS='BP', pop_items='', pop_n='', p_sm_bonferroni='', is_obsolete='', GO='GO:0032879', name='', pop_count='', alt_ids='', level=3, depth=3, enrichment='', Cluster='', geneid_set='', symbols='', symbol_set='', geneids='', format_txt=1, hdr_idx=1, is_hdrgo=True, is_usrgo=False, hdr1usr01='*', dcnt=1780, D1='A', GO_name='regulation of localization'),
    Nt(p_uncorrected=0.0001651888337117618, study_count=38, study_n=1139, namespace='biological_process', p_fdr_bh=0.019706897791865376, study_items=set([u'ENSMUSG00000024112', u'ENSMUSG00000021730', u'ENSMUSG00000032839', u'ENSMUSG00000058248', u'ENSMUSG00000000197', u'ENSMUSG00000029151', u'ENSMUSG00000042078', u'ENSMUSG00000056258', u'ENSMUSG00000019082', u'ENSMUSG00000057378', u'ENSMUSG00000027827', u'ENSMUSG00000045053', u'ENSMUSG00000027748', u'ENSMUSG00000046329', u'ENSMUSG00000020651', u'ENSMUSG00000030592', u'ENSMUSG00000042604', u'ENSMUSG00000023033', u'ENSMUSG00000015968', u'ENSMUSG00000004110', u'ENSMUSG00000054640', u'ENSMUSG00000004113', u'ENSMUSG00000063142', u'ENSMUSG00000070570', u'ENSMUSG00000028033', u'ENSMUSG00000074575', u'ENSMUSG00000062785', u'ENSMUSG00000030102', u'ENSMUSG00000051331', u'ENSMUSG00000021313', u'ENSMUSG00000063873', u'ENSMUSG00000030376', u'ENSMUSG00000041710', u'ENSMUSG00000034656', u'ENSMUSG00000016346', u'ENSMUSG00000037579', u'ENSMUSG00000053025', u'ENSMUSG00000060882']), NS='BP', pop_items=set([u'ENSMUSG00000033720', u'ENSMUSG00000032839', u'ENSMUSG00000024096', u'ENSMUSG00000037321', u'ENSMUSG00000045246', u'ENSMUSG00000022404', u'ENSMUSG00000020865', u'ENSMUSG00000018507', u'ENSMUSG00000050556', u'ENSMUSG00000009731', u'ENSMUSG00000057378', u'ENSMUSG00000034402', u'ENSMUSG00000040164', u'ENSMUSG00000002984', u'ENSMUSG00000024270', u'ENSMUSG00000050144', u'ENSMUSG00000026791', u'ENSMUSG00000034320', u'ENSMUSG00000030592', u'ENSMUSG00000042604', u'ENSMUSG00000029924', u'ENSMUSG00000015968', u'ENSMUSG00000004110', u'ENSMUSG00000054640', u'ENSMUSG00000063873', u'ENSMUSG00000016319', u'ENSMUSG00000025759', u'ENSMUSG00000020620', u'ENSMUSG00000037490', u'ENSMUSG00000071253', u'ENSMUSG00000040584', u'ENSMUSG00000026819', u'ENSMUSG00000092083', u'ENSMUSG00000028033', u'ENSMUSG00000030102', u'ENSMUSG00000021432', u'ENSMUSG00000020873', u'ENSMUSG00000039838', u'ENSMUSG00000048833', u'ENSMUSG00000033147', u'ENSMUSG00000022094', u'ENSMUSG00000018459', u'ENSMUSG00000055782', u'ENSMUSG00000027010', u'ENSMUSG00000036949', u'ENSMUSG00000048677', u'ENSMUSG00000025212', u'ENSMUSG00000036636', u'ENSMUSG00000027716', u'ENSMUSG00000033486', u'ENSMUSG00000020805', u'ENSMUSG00000037089', u'ENSMUSG00000031974', u'ENSMUSG00000020102', u'ENSMUSG00000022003', u'ENSMUSG00000039463', u'ENSMUSG00000040569', u'ENSMUSG00000041771', u'ENSMUSG00000020744', u'ENSMUSG00000018999', u'ENSMUSG00000021474', u'ENSMUSG00000024112', u'ENSMUSG00000021265', u'ENSMUSG00000027895', u'ENSMUSG00000024818', u'ENSMUSG00000040896', u'ENSMUSG00000022822', u'ENSMUSG00000009292', u'ENSMUSG00000002346', u'ENSMUSG00000045100', u'ENSMUSG00000030376', u'ENSMUSG00000025036', u'ENSMUSG00000029016', u'ENSMUSG00000005802', u'ENSMUSG00000056258', u'ENSMUSG00000005674', u'ENSMUSG00000028645', u'ENSMUSG00000031378', u'ENSMUSG00000035681', u'ENSMUSG00000030287', u'ENSMUSG00000041945', u'ENSMUSG00000022843', u'ENSMUSG00000019080', u'ENSMUSG00000000197', u'ENSMUSG00000000792', u'ENSMUSG00000037455', u'ENSMUSG00000028631', u'ENSMUSG00000018900', u'ENSMUSG00000026220', u'ENSMUSG00000021771', u'ENSMUSG00000014158', u'ENSMUSG00000032313', u'ENSMUSG00000024597', u'ENSMUSG00000064329', u'ENSMUSG00000031333', u'ENSMUSG00000033965', u'ENSMUSG00000038077', u'ENSMUSG00000055296', u'ENSMUSG00000023088', u'ENSMUSG00000020402', u'ENSMUSG00000041920', u'ENSMUSG00000066595', u'ENSMUSG00000000605', u'ENSMUSG00000019838', u'ENSMUSG00000020331', u'ENSMUSG00000028127', u'ENSMUSG00000023259', u'ENSMUSG00000029221', u'ENSMUSG00000004319', u'ENSMUSG00000041710', u'ENSMUSG00000016346', u'ENSMUSG00000037579', u'ENSMUSG00000017756', u'ENSMUSG00000020334', u'ENSMUSG00000041654', u'ENSMUSG00000019935', u'ENSMUSG00000008892', u'ENSMUSG00000026614', u'ENSMUSG00000032741', u'ENSMUSG00000037434', u'ENSMUSG00000040322', u'ENSMUSG00000009378', u'ENSMUSG00000031633', u'ENSMUSG00000039908', u'ENSMUSG00000020829', u'ENSMUSG00000029151', u'ENSMUSG00000027896', u'ENSMUSG00000026198', u'ENSMUSG00000019082', u'ENSMUSG00000038319', u'ENSMUSG00000045053', u'ENSMUSG00000024339', u'ENSMUSG00000017740', u'ENSMUSG00000027748', u'ENSMUSG00000051111', u'ENSMUSG00000013275', u'ENSMUSG00000042644', u'ENSMUSG00000040724', u'ENSMUSG00000020651', u'ENSMUSG00000089774', u'ENSMUSG00000021629', u'ENSMUSG00000023033', u'ENSMUSG00000029802', u'ENSMUSG00000028976', u'ENSMUSG00000075316', u'ENSMUSG00000001082', u'ENSMUSG00000038212', u'ENSMUSG00000050822', u'ENSMUSG00000002105', u'ENSMUSG00000063354', u'ENSMUSG00000029408', u'ENSMUSG00000047959', u'ENSMUSG00000004902', u'ENSMUSG00000070570', u'ENSMUSG00000030089', u'ENSMUSG00000059742', u'ENSMUSG00000053897', u'ENSMUSG00000032754', u'ENSMUSG00000046329', u'ENSMUSG00000021313', u'ENSMUSG00000046822', u'ENSMUSG00000032988', u'ENSMUSG00000051331', u'ENSMUSG00000030249', u'ENSMUSG00000064267', u'ENSMUSG00000063698', u'ENSMUSG00000004113', u'ENSMUSG00000029650', u'ENSMUSG00000058248', u'ENSMUSG00000024327', u'ENSMUSG00000037762', u'ENSMUSG00000032511', u'ENSMUSG00000052310', u'ENSMUSG00000031934', u'ENSMUSG00000028970', u'ENSMUSG00000015112', u'ENSMUSG00000040447', u'ENSMUSG00000050953', u'ENSMUSG00000006641', u'ENSMUSG00000053025', u'ENSMUSG00000027340', u'ENSMUSG00000004317', u'ENSMUSG00000038497', u'ENSMUSG00000024036', u'ENSMUSG00000060882', u'ENSMUSG00000043673', u'ENSMUSG00000032902', u'ENSMUSG00000040441', u'ENSMUSG00000021730', u'ENSMUSG00000031129', u'ENSMUSG00000021240', u'ENSMUSG00000063796', u'ENSMUSG00000036298', u'ENSMUSG00000018566', u'ENSMUSG00000031997', u'ENSMUSG00000030500', u'ENSMUSG00000027775', u'ENSMUSG00000010122', u'ENSMUSG00000042078', u'ENSMUSG00000059149', u'ENSMUSG00000036196', u'ENSMUSG00000003153', u'ENSMUSG00000003528', u'ENSMUSG00000025161', u'ENSMUSG00000032449', u'ENSMUSG00000022342', u'ENSMUSG00000027827', u'ENSMUSG00000044367', u'ENSMUSG00000022199', u'ENSMUSG00000042476', u'ENSMUSG00000032114', u'ENSMUSG00000038178', u'ENSMUSG00000050963', u'ENSMUSG00000062785', u'ENSMUSG00000027074', u'ENSMUSG00000017765', u'ENSMUSG00000038486', u'ENSMUSG00000026065', u'ENSMUSG00000038267', u'ENSMUSG00000038260', u'ENSMUSG00000058975', u'ENSMUSG00000021541', u'ENSMUSG00000028973', u'ENSMUSG00000028051', u'ENSMUSG00000024069', u'ENSMUSG00000074575', u'ENSMUSG00000047976', u'ENSMUSG00000030450', u'ENSMUSG00000032842', u'ENSMUSG00000079055', u'ENSMUSG00000030741', u'ENSMUSG00000054099', u'ENSMUSG00000058441', u'ENSMUSG00000037344', u'ENSMUSG00000025986', u'ENSMUSG00000049624', u'ENSMUSG00000037341', u'ENSMUSG00000034656', u'ENSMUSG00000034258', u'ENSMUSG00000032122', u'ENSMUSG00000089911', u'ENSMUSG00000051726', u'ENSMUSG00000054414', u'ENSMUSG00000024650', u'ENSMUSG00000028854', u'ENSMUSG00000027365', u'ENSMUSG00000040938', u'ENSMUSG00000063142']), pop_n=13836, p_sm_bonferroni=1.0, is_obsolete=False, GO='GO:0055085', name='transmembrane transport', pop_count=248, alt_ids=[], level=4, depth=4, enrichment='e', Cluster='Late Decrease', geneid_set=set([u'ENSMUSG00000024112', u'ENSMUSG00000021730', u'ENSMUSG00000032839', u'ENSMUSG00000058248', u'ENSMUSG00000000197', u'ENSMUSG00000029151', u'ENSMUSG00000042078', u'ENSMUSG00000056258', u'ENSMUSG00000019082', u'ENSMUSG00000057378', u'ENSMUSG00000027827', u'ENSMUSG00000045053', u'ENSMUSG00000027748', u'ENSMUSG00000046329', u'ENSMUSG00000020651', u'ENSMUSG00000030592', u'ENSMUSG00000042604', u'ENSMUSG00000023033', u'ENSMUSG00000015968', u'ENSMUSG00000004110', u'ENSMUSG00000054640', u'ENSMUSG00000004113', u'ENSMUSG00000063142', u'ENSMUSG00000053025', u'ENSMUSG00000028033', u'ENSMUSG00000074575', u'ENSMUSG00000062785', u'ENSMUSG00000030102', u'ENSMUSG00000051331', u'ENSMUSG00000021313', u'ENSMUSG00000070570', u'ENSMUSG00000063873', u'ENSMUSG00000030376', u'ENSMUSG00000041710', u'ENSMUSG00000016346', u'ENSMUSG00000037579', u'ENSMUSG00000034656', u'ENSMUSG00000060882']), symbols=u'Cacna1a Cacna1b Cacna1c Cacna1d Cacna1e Cacna1h Hcn1 Itpr1 Kcna4 Kcnab1 Kcnc3 Kcnd2 Kcng1 Kcng3 Kcnh1 Kcnh3 Kcnma1 Kcnq2 Kcnq3 Kcnq5 Nalcn Ryr1 Ryr2 Ryr3 Scn8a Slc17a7 Slc24a3 Slc25a22 Slc25a23 Slc26a4 Slc30a3 Slc8a1 Slc8a2 Sv2b Svop Trpc1 Trpc4 Trpc5', symbol_set=set([u'Cacna1h', u'Ryr2', u'Kcnh1', u'Kcnh3', u'Cacna1a', u'Cacna1b', u'Cacna1c', u'Cacna1d', u'Cacna1e', u'Kcnma1', u'Slc8a2', u'Kcnc3', u'Hcn1', u'Kcng1', u'Ryr3', u'Kcng3', u'Scn8a', u'Svop', u'Trpc1', u'Trpc4', u'Trpc5', u'Kcna4', u'Itpr1', u'Slc30a3', u'Slc17a7', u'Kcnab1', u'Slc8a1', u'Ryr1', u'Kcnd2', u'Nalcn', u'Slc24a3', u'Kcnq5', u'Kcnq2', u'Kcnq3', u'Slc25a22', u'Slc25a23', u'Slc26a4', u'Sv2b']), geneids='ENSMUSG00000024112 ENSMUSG00000021730 ENSMUSG00000032839 ENSMUSG00000030376 ENSMUSG00000000197 ENSMUSG00000029151 ENSMUSG00000042078 ENSMUSG00000056258 ENSMUSG00000019082 ENSMUSG00000057378 ENSMUSG00000027827 ENSMUSG00000045053 ENSMUSG00000063142 ENSMUSG00000027748 ENSMUSG00000046329 ENSMUSG00000020651 ENSMUSG00000030592 ENSMUSG00000042604 ENSMUSG00000023033 ENSMUSG00000015968 ENSMUSG00000004110 ENSMUSG00000054640 ENSMUSG00000004113 ENSMUSG00000034656 ENSMUSG00000074575 ENSMUSG00000028033 ENSMUSG00000021313 ENSMUSG00000062785 ENSMUSG00000030102 ENSMUSG00000051331 ENSMUSG00000070570 ENSMUSG00000063873 ENSMUSG00000058248 ENSMUSG00000041710 ENSMUSG00000016346 ENSMUSG00000037579 ENSMUSG00000053025 ENSMUSG00000060882', format_txt=1, hdr_idx=1, is_hdrgo=True, is_usrgo=True, hdr1usr01='**', dcnt=338, D1='G', GO_name='transmembrane transport'),
    Nt(p_uncorrected=1.4241811172299513e-05, study_count=10, study_n=1139, namespace='biological_process', p_fdr_bh=0.002382583034603534, study_items=set([u'ENSMUSG00000056427', u'ENSMUSG00000047712', u'ENSMUSG00000058230', u'ENSMUSG00000026235', u'ENSMUSG00000025020', u'ENSMUSG00000056486', u'ENSMUSG00000015222', u'ENSMUSG00000028664', u'ENSMUSG00000034656', u'ENSMUSG00000042700']), NS='BP', pop_items=set([u'ENSMUSG00000030093', u'ENSMUSG00000047712', u'ENSMUSG00000027954', u'ENSMUSG00000030110', u'ENSMUSG00000028664', u'ENSMUSG00000058230', u'ENSMUSG00000034616', u'ENSMUSG00000050587', u'ENSMUSG00000042121', u'ENSMUSG00000024304', u'ENSMUSG00000029291', u'ENSMUSG00000034656', u'ENSMUSG00000042700', u'ENSMUSG00000026728', u'ENSMUSG00000025020', u'ENSMUSG00000024969', u'ENSMUSG00000005958', u'ENSMUSG00000026959', u'ENSMUSG00000056427', u'ENSMUSG00000060012', u'ENSMUSG00000026235', u'ENSMUSG00000056486', u'ENSMUSG00000022812', u'ENSMUSG00000037926', u'ENSMUSG00000015222']), pop_n=13836, p_sm_bonferroni=0.21577768107150994, is_obsolete=False, GO='GO:0050770', name='regulation of axonogenesis', pop_count=25, alt_ids=[], level=7, depth=9, enrichment='e', Cluster='Late Decrease', geneid_set=set([u'ENSMUSG00000056427', u'ENSMUSG00000047712', u'ENSMUSG00000058230', u'ENSMUSG00000026235', u'ENSMUSG00000025020', u'ENSMUSG00000056486', u'ENSMUSG00000034656', u'ENSMUSG00000028664', u'ENSMUSG00000015222', u'ENSMUSG00000042700']), symbols=u'Arhgap35 Cacna1a Chn1 Epha4 Ephb2 Map2 Sipa1l1 Slit1 Slit3 Ust', symbol_set=set([u'Ephb2', u'Cacna1a', u'Epha4', 'Map2', u'Chn1', u'Ust', u'Slit3', 'Arhgap35', u'Slit1', u'Sipa1l1']), geneids='ENSMUSG00000056427 ENSMUSG00000047712 ENSMUSG00000058230 ENSMUSG00000026235 ENSMUSG00000025020 ENSMUSG00000056486 ENSMUSG00000015222 ENSMUSG00000028664 ENSMUSG00000034656 ENSMUSG00000042700', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=37, D1='A', GO_name='regulation of axonogenesis'),
    Nt(p_uncorrected=9.094262277365838e-11, study_count=20, study_n=1139, namespace='biological_process', p_fdr_bh=1.3778716776436982e-07, study_items=set([u'ENSMUSG00000037541', u'ENSMUSG00000030209', u'ENSMUSG00000059003', u'ENSMUSG00000041670', u'ENSMUSG00000071862', u'ENSMUSG00000059456', u'ENSMUSG00000052087', u'ENSMUSG00000060780', u'ENSMUSG00000025889', u'ENSMUSG00000063358', u'ENSMUSG00000030376', u'ENSMUSG00000027273', u'ENSMUSG00000057897', u'ENSMUSG00000015829', u'ENSMUSG00000034799', u'ENSMUSG00000021701', u'ENSMUSG00000031302', u'ENSMUSG00000018634', u'ENSMUSG00000022623', u'ENSMUSG00000063887']), NS='BP', pop_items=set([u'ENSMUSG00000013663', u'ENSMUSG00000037996', u'ENSMUSG00000021478', u'ENSMUSG00000030376', u'ENSMUSG00000020932', u'ENSMUSG00000057897', u'ENSMUSG00000059003', u'ENSMUSG00000024798', u'ENSMUSG00000022623', u'ENSMUSG00000029053', u'ENSMUSG00000037541', u'ENSMUSG00000002413', u'ENSMUSG00000031302', u'ENSMUSG00000030805', u'ENSMUSG00000026249', u'ENSMUSG00000052087', u'ENSMUSG00000042644', u'ENSMUSG00000019803', u'ENSMUSG00000042453', u'ENSMUSG00000027273', u'ENSMUSG00000020894', u'ENSMUSG00000018634', u'ENSMUSG00000021708', u'ENSMUSG00000031393', u'ENSMUSG00000030209', u'ENSMUSG00000049303', u'ENSMUSG00000071862', u'ENSMUSG00000021701', u'ENSMUSG00000063358', u'ENSMUSG00000015829', u'ENSMUSG00000034799', u'ENSMUSG00000079055', u'ENSMUSG00000055254', u'ENSMUSG00000063887', u'ENSMUSG00000025889', u'ENSMUSG00000059456', u'ENSMUSG00000060780', u'ENSMUSG00000009894', u'ENSMUSG00000041488', u'ENSMUSG00000041670', u'ENSMUSG00000026385']), pop_n=13836, p_sm_bonferroni=1.377871677643698e-06, is_obsolete=False, GO='GO:0060291', name='long-term synaptic potentiation', pop_count=41, alt_ids=[], level=4, depth=7, enrichment='e', Cluster='Late Decrease', geneid_set=set([u'ENSMUSG00000030209', u'ENSMUSG00000063887', u'ENSMUSG00000071862', u'ENSMUSG00000021701', u'ENSMUSG00000063358', u'ENSMUSG00000030376', u'ENSMUSG00000057897', u'ENSMUSG00000015829', u'ENSMUSG00000034799', u'ENSMUSG00000059003', u'ENSMUSG00000022623', u'ENSMUSG00000037541', u'ENSMUSG00000025889', u'ENSMUSG00000031302', u'ENSMUSG00000059456', u'ENSMUSG00000052087', u'ENSMUSG00000060780', u'ENSMUSG00000027273', u'ENSMUSG00000041670', u'ENSMUSG00000018634']), symbols=u'Camk2b Crhr1 Grin2a Grin2b Lrrtm1 Lrrtm2 Mapk1 Nlgn1 Nlgn3 Plk2 Ptk2b Rgs14 Rims1 Shank2 Shank3 Slc8a2 Snap25 Snca Tnr Unc13a', symbol_set=set([u'Snap25', u'Rgs14', u'Grin2a', u'Nlgn1', u'Snca', u'Plk2', u'Ptk2b', u'Camk2b', u'Rims1', u'Grin2b', u'Crhr1', u'Tnr', u'Mapk1', u'Lrrtm1', u'Lrrtm2', u'Unc13a', u'Slc8a2', u'Shank3', u'Shank2', u'Nlgn3']), geneids='ENSMUSG00000037541 ENSMUSG00000025889 ENSMUSG00000059003 ENSMUSG00000057897 ENSMUSG00000071862 ENSMUSG00000063358 ENSMUSG00000021701 ENSMUSG00000052087 ENSMUSG00000060780 ENSMUSG00000030209 ENSMUSG00000059456 ENSMUSG00000030376 ENSMUSG00000027273 ENSMUSG00000041670 ENSMUSG00000015829 ENSMUSG00000034799 ENSMUSG00000031302 ENSMUSG00000018634 ENSMUSG00000022623 ENSMUSG00000063887', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=0, D1='A', GO_name='long-term synaptic potentiation'),
    Nt(p_uncorrected=0.00045744749207056603, study_count=8, study_n=1139, namespace='biological_process', p_fdr_bh=0.04682964157000774, study_items=set([u'ENSMUSG00000041957', u'ENSMUSG00000057914', u'ENSMUSG00000054889', u'ENSMUSG00000051331', u'ENSMUSG00000020866', u'ENSMUSG00000049281', u'ENSMUSG00000015968', u'ENSMUSG00000040118']), NS='BP', pop_items=set([u'ENSMUSG00000044393', u'ENSMUSG00000057123', u'ENSMUSG00000040896', u'ENSMUSG00000070304', u'ENSMUSG00000090122', u'ENSMUSG00000041695', u'ENSMUSG00000020866', u'ENSMUSG00000039672', u'ENSMUSG00000019194', u'ENSMUSG00000046480', u'ENSMUSG00000054889', u'ENSMUSG00000038319', u'ENSMUSG00000015968', u'ENSMUSG00000038260', u'ENSMUSG00000032826', u'ENSMUSG00000001552', u'ENSMUSG00000051331', u'ENSMUSG00000041957', u'ENSMUSG00000057914', u'ENSMUSG00000032511', u'ENSMUSG00000060843', u'ENSMUSG00000049281', u'ENSMUSG00000040118', u'ENSMUSG00000007655']), pop_n=13836, p_sm_bonferroni=1.0, is_obsolete=False, GO='GO:0086091', name='regulation of heart rate by cardiac conduction', pop_count=24, alt_ids=[], level=4, depth=8, enrichment='e', Cluster='Late Decrease', geneid_set=set([u'ENSMUSG00000041957', u'ENSMUSG00000057914', u'ENSMUSG00000054889', u'ENSMUSG00000051331', u'ENSMUSG00000020866', u'ENSMUSG00000049281', u'ENSMUSG00000015968', u'ENSMUSG00000040118']), symbols=u'Cacna1c Cacna1d Cacna1g Cacna2d1 Cacnb2 Dsp Pkp2 Scn3b', symbol_set=set([u'Cacnb2', u'Cacna1c', u'Cacna1d', u'Dsp', u'Cacna1g', u'Pkp2', u'Cacna2d1', u'Scn3b']), geneids='ENSMUSG00000041957 ENSMUSG00000057914 ENSMUSG00000054889 ENSMUSG00000051331 ENSMUSG00000020866 ENSMUSG00000049281 ENSMUSG00000015968 ENSMUSG00000040118', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=0, D1='ACJQ', GO_name='regulation of heart rate by cardiac conduction'),
    Nt(p_uncorrected=1.4751096423859753e-05, study_count=16, study_n=1139, namespace='biological_process', p_fdr_bh=0.0024031598055688076, study_items=set([u'ENSMUSG00000048895', u'ENSMUSG00000019699', u'ENSMUSG00000023050', u'ENSMUSG00000005469', u'ENSMUSG00000038970', u'ENSMUSG00000028078', u'ENSMUSG00000039145', u'ENSMUSG00000032936', u'ENSMUSG00000024617', u'ENSMUSG00000024122', u'ENSMUSG00000050965', u'ENSMUSG00000032500', u'ENSMUSG00000057897', u'ENSMUSG00000020785', u'ENSMUSG00000063358', u'ENSMUSG00000037012']), NS='BP', pop_items=set([u'ENSMUSG00000019699', u'ENSMUSG00000002012', u'ENSMUSG00000032440', u'ENSMUSG00000038379', u'ENSMUSG00000000532', u'ENSMUSG00000039145', u'ENSMUSG00000007613', u'ENSMUSG00000030272', u'ENSMUSG00000032936', u'ENSMUSG00000029471', u'ENSMUSG00000038970', u'ENSMUSG00000022897', u'ENSMUSG00000027177', u'ENSMUSG00000057897', u'ENSMUSG00000036737', u'ENSMUSG00000048895', u'ENSMUSG00000023050', u'ENSMUSG00000037012', u'ENSMUSG00000036273', u'ENSMUSG00000032113', u'ENSMUSG00000019942', u'ENSMUSG00000053819', u'ENSMUSG00000032500', u'ENSMUSG00000050965', u'ENSMUSG00000013629', u'ENSMUSG00000021820', u'ENSMUSG00000005469', u'ENSMUSG00000001729', u'ENSMUSG00000061436', u'ENSMUSG00000028991', u'ENSMUSG00000022033', u'ENSMUSG00000048310', u'ENSMUSG00000022812', u'ENSMUSG00000027797', u'ENSMUSG00000029521', u'ENSMUSG00000042978', u'ENSMUSG00000028078', u'ENSMUSG00000017376', u'ENSMUSG00000024122', u'ENSMUSG00000016179', u'ENSMUSG00000026836', u'ENSMUSG00000003068', u'ENSMUSG00000042064', u'ENSMUSG00000034974', u'ENSMUSG00000020785', u'ENSMUSG00000031314', u'ENSMUSG00000021948', u'ENSMUSG00000027030', u'ENSMUSG00000030815', u'ENSMUSG00000057329', u'ENSMUSG00000031529', u'ENSMUSG00000040390', u'ENSMUSG00000024858', u'ENSMUSG00000024617', u'ENSMUSG00000026034', u'ENSMUSG00000025537', u'ENSMUSG00000021936', u'ENSMUSG00000063358', u'ENSMUSG00000028969']), pop_n=13836, p_sm_bonferroni=0.22349386191789913, is_obsolete=False, GO='GO:0018107', name='peptidyl-threonine phosphorylation', pop_count=59, alt_ids=[], level=7, depth=9, enrichment='e', Cluster='Late Decrease', geneid_set=set([u'ENSMUSG00000019699', u'ENSMUSG00000028078', u'ENSMUSG00000039145', u'ENSMUSG00000032936', u'ENSMUSG00000024122', u'ENSMUSG00000038970', u'ENSMUSG00000032500', u'ENSMUSG00000057897', u'ENSMUSG00000020785', u'ENSMUSG00000048895', u'ENSMUSG00000023050', u'ENSMUSG00000037012', u'ENSMUSG00000024617', u'ENSMUSG00000050965', u'ENSMUSG00000005469', u'ENSMUSG00000063358']), symbols=u'Akt3 Camk1d Camk2a Camk2b Camkk1 Camkv Cdk5r1 Dclk2 Dclk3 Hk1 Lmtk2 Map3k12 Mapk1 Pdpk1 Prkaca Prkca', symbol_set=set([u'Camk2a', u'Camk1d', u'Mapk1', u'Prkca', u'Hk1', u'Map3k12', u'Dclk3', u'Camkv', u'Camkk1', u'Akt3', u'Cdk5r1', u'Camk2b', u'Prkaca', u'Pdpk1', u'Dclk2', u'Lmtk2']), geneids='ENSMUSG00000019699 ENSMUSG00000048895 ENSMUSG00000023050 ENSMUSG00000037012 ENSMUSG00000050965 ENSMUSG00000028078 ENSMUSG00000039145 ENSMUSG00000024122 ENSMUSG00000024617 ENSMUSG00000032936 ENSMUSG00000057897 ENSMUSG00000038970 ENSMUSG00000032500 ENSMUSG00000005469 ENSMUSG00000020785 ENSMUSG00000063358', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=10, D1='BD', GO_name='peptidyl-threonine phosphorylation'),
    Nt(p_uncorrected=6.514321528919704e-05, study_count=26, study_n=1139, namespace='biological_process', p_fdr_bh=0.009224157521931068, study_items=set([u'ENSMUSG00000019699', u'ENSMUSG00000039145', u'ENSMUSG00000032936', u'ENSMUSG00000038970', u'ENSMUSG00000057897', u'ENSMUSG00000048895', u'ENSMUSG00000023050', u'ENSMUSG00000037012', u'ENSMUSG00000027646', u'ENSMUSG00000032500', u'ENSMUSG00000050965', u'ENSMUSG00000005469', u'ENSMUSG00000028078', u'ENSMUSG00000021701', u'ENSMUSG00000063358', u'ENSMUSG00000038128', u'ENSMUSG00000024122', u'ENSMUSG00000045038', u'ENSMUSG00000078816', u'ENSMUSG00000020785', u'ENSMUSG00000001034', u'ENSMUSG00000032384', u'ENSMUSG00000024617', u'ENSMUSG00000031833', u'ENSMUSG00000015599', u'ENSMUSG00000052889']), NS='BP', pop_items=set([u'ENSMUSG00000002012', u'ENSMUSG00000029512', u'ENSMUSG00000024070', u'ENSMUSG00000020190', u'ENSMUSG00000032936', u'ENSMUSG00000020694', u'ENSMUSG00000025358', u'ENSMUSG00000029454', u'ENSMUSG00000016528', u'ENSMUSG00000023809', u'ENSMUSG00000029053', u'ENSMUSG00000048895', u'ENSMUSG00000021948', u'ENSMUSG00000039954', u'ENSMUSG00000050310', u'ENSMUSG00000004591', u'ENSMUSG00000027177', u'ENSMUSG00000004056', u'ENSMUSG00000021820', u'ENSMUSG00000024576', u'ENSMUSG00000020115', u'ENSMUSG00000004815', u'ENSMUSG00000035232', u'ENSMUSG00000025915', u'ENSMUSG00000039145', u'ENSMUSG00000048310', u'ENSMUSG00000025199', u'ENSMUSG00000027797', u'ENSMUSG00000029521', u'ENSMUSG00000038128', u'ENSMUSG00000000489', u'ENSMUSG00000015981', u'ENSMUSG00000003345', u'ENSMUSG00000045038', u'ENSMUSG00000003068', u'ENSMUSG00000053693', u'ENSMUSG00000021959', u'ENSMUSG00000032384', u'ENSMUSG00000037643', u'ENSMUSG00000040390', u'ENSMUSG00000029283', u'ENSMUSG00000021115', u'ENSMUSG00000006494', u'ENSMUSG00000019699', u'ENSMUSG00000057897', u'ENSMUSG00000030272', u'ENSMUSG00000022781', u'ENSMUSG00000035725', u'ENSMUSG00000018209', u'ENSMUSG00000073563', u'ENSMUSG00000026749', u'ENSMUSG00000037012', u'ENSMUSG00000036707', u'ENSMUSG00000027646', u'ENSMUSG00000042349', u'ENSMUSG00000030867', u'ENSMUSG00000040021', u'ENSMUSG00000032409', u'ENSMUSG00000042978', u'ENSMUSG00000078816', u'ENSMUSG00000002688', u'ENSMUSG00000031314', u'ENSMUSG00000027030', u'ENSMUSG00000030815', u'ENSMUSG00000002205', u'ENSMUSG00000032577', u'ENSMUSG00000024617', u'ENSMUSG00000024858', u'ENSMUSG00000007613', u'ENSMUSG00000042489', u'ENSMUSG00000026034', u'ENSMUSG00000025537', u'ENSMUSG00000030890', u'ENSMUSG00000061436', u'ENSMUSG00000064090', u'ENSMUSG00000021457', u'ENSMUSG00000022433', u'ENSMUSG00000030409', u'ENSMUSG00000030655', u'ENSMUSG00000036273', u'ENSMUSG00000032500', u'ENSMUSG00000034751', u'ENSMUSG00000005469', u'ENSMUSG00000001729', u'ENSMUSG00000022033', u'ENSMUSG00000026667', u'ENSMUSG00000063065', u'ENSMUSG00000021108', u'ENSMUSG00000028078', u'ENSMUSG00000039456', u'ENSMUSG00000024122', u'ENSMUSG00000038967', u'ENSMUSG00000042064', u'ENSMUSG00000034974', u'ENSMUSG00000020785', u'ENSMUSG00000001034', u'ENSMUSG00000041187', u'ENSMUSG00000016179', u'ENSMUSG00000028708', u'ENSMUSG00000057329', u'ENSMUSG00000001630', u'ENSMUSG00000031833', u'ENSMUSG00000015599', u'ENSMUSG00000024006', u'ENSMUSG00000028969', u'ENSMUSG00000038379', u'ENSMUSG00000031529', u'ENSMUSG00000090100', u'ENSMUSG00000029471', u'ENSMUSG00000038970', u'ENSMUSG00000022897', u'ENSMUSG00000032855', u'ENSMUSG00000057672', u'ENSMUSG00000031537', u'ENSMUSG00000023050', u'ENSMUSG00000032440', u'ENSMUSG00000053819', u'ENSMUSG00000035390', u'ENSMUSG00000050965', u'ENSMUSG00000026778', u'ENSMUSG00000026779', u'ENSMUSG00000028991', u'ENSMUSG00000003810', u'ENSMUSG00000022812', u'ENSMUSG00000021701', u'ENSMUSG00000025162', u'ENSMUSG00000063358', u'ENSMUSG00000034218', u'ENSMUSG00000022672', u'ENSMUSG00000031668', u'ENSMUSG00000031451', u'ENSMUSG00000028756', u'ENSMUSG00000019942', u'ENSMUSG00000053046', u'ENSMUSG00000019970', u'ENSMUSG00000031285', u'ENSMUSG00000053436', u'ENSMUSG00000021936', u'ENSMUSG00000052889']), pop_n=13836, p_sm_bonferroni=0.9869848548466243, is_obsolete=False, GO='GO:0018105', name='peptidyl-serine phosphorylation', pop_count=139, alt_ids=[], level=7, depth=9, enrichment='e', Cluster='Late Decrease', geneid_set=set([u'ENSMUSG00000019699', u'ENSMUSG00000001034', u'ENSMUSG00000028078', u'ENSMUSG00000039145', u'ENSMUSG00000015599', u'ENSMUSG00000032936', u'ENSMUSG00000038128', u'ENSMUSG00000063358', u'ENSMUSG00000038970', u'ENSMUSG00000045038', u'ENSMUSG00000024617', u'ENSMUSG00000057897', u'ENSMUSG00000078816', u'ENSMUSG00000020785', u'ENSMUSG00000048895', u'ENSMUSG00000023050', u'ENSMUSG00000032384', u'ENSMUSG00000037012', u'ENSMUSG00000027646', u'ENSMUSG00000032500', u'ENSMUSG00000031833', u'ENSMUSG00000050965', u'ENSMUSG00000005469', u'ENSMUSG00000021701', u'ENSMUSG00000052889', u'ENSMUSG00000024122']), symbols=u'Akt3 Camk1d Camk2a Camk2b Camk4 Camkk1 Camkv Cdk5r1 Csnk1g1 Dclk2 Dclk3 Hk1 Lmtk2 Map3k12 Mapk1 Mapk7 Mast3 Pdpk1 Plk2 Prkaca Prkca Prkcb Prkce Prkcg Src Ttbk1', symbol_set=set([u'Camk2a', u'Camk2b', u'Camkv', u'Map3k12', u'Csnk1g1', u'Lmtk2', u'Camkk1', u'Src', u'Akt3', u'Prkcb', u'Camk1d', u'Prkca', u'Plk2', u'Prkce', u'Camk4', 'Prkcg', u'Mapk1', u'Cdk5r1', u'Mapk7', u'Pdpk1', u'Hk1', u'Dclk3', u'Dclk2', u'Mast3', u'Prkaca', u'Ttbk1']), geneids='ENSMUSG00000019699 ENSMUSG00000039145 ENSMUSG00000032936 ENSMUSG00000038970 ENSMUSG00000057897 ENSMUSG00000048895 ENSMUSG00000023050 ENSMUSG00000037012 ENSMUSG00000027646 ENSMUSG00000032500 ENSMUSG00000050965 ENSMUSG00000005469 ENSMUSG00000028078 ENSMUSG00000021701 ENSMUSG00000024122 ENSMUSG00000038128 ENSMUSG00000063358 ENSMUSG00000045038 ENSMUSG00000078816 ENSMUSG00000020785 ENSMUSG00000001034 ENSMUSG00000032384 ENSMUSG00000024617 ENSMUSG00000031833 ENSMUSG00000015599 ENSMUSG00000052889', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=16, D1='BD', GO_name='peptidyl-serine phosphorylation'),
    Nt(p_uncorrected=7.276990217974559e-06, study_count=9, study_n=1139, namespace='biological_process', p_fdr_bh=0.0013781709849066568, study_items=set([u'ENSMUSG00000026235', u'ENSMUSG00000026764', u'ENSMUSG00000030067', u'ENSMUSG00000029765', u'ENSMUSG00000033004', u'ENSMUSG00000025020', u'ENSMUSG00000025427', u'ENSMUSG00000056486', u'ENSMUSG00000031558']), NS='BP', pop_items=set([u'ENSMUSG00000062312', u'ENSMUSG00000045382', u'ENSMUSG00000028883', u'ENSMUSG00000026764', u'ENSMUSG00000061353', u'ENSMUSG00000029765', u'ENSMUSG00000025427', u'ENSMUSG00000033004', u'ENSMUSG00000030067', u'ENSMUSG00000037868', u'ENSMUSG00000056486', u'ENSMUSG00000031558', u'ENSMUSG00000017724', u'ENSMUSG00000048616', u'ENSMUSG00000025020', u'ENSMUSG00000022636', u'ENSMUSG00000025810', u'ENSMUSG00000026235', u'ENSMUSG00000028969']), pop_n=13836, p_sm_bonferroni=0.11025367879253255, is_obsolete=False, GO='GO:0008045', name='motor neuron axon guidance', pop_count=19, alt_ids=[], level=6, depth=6, enrichment='e', Cluster='Late Decrease', geneid_set=set([u'ENSMUSG00000033004', u'ENSMUSG00000026764', u'ENSMUSG00000030067', u'ENSMUSG00000029765', u'ENSMUSG00000026235', u'ENSMUSG00000025020', u'ENSMUSG00000025427', u'ENSMUSG00000056486', u'ENSMUSG00000031558']), symbols=u'Chn1 Epha4 Foxp1 Kif5c Mycbp2 Plxna4 Rnf165 Slit1 Slit2', symbol_set=set([u'Foxp1', u'Rnf165', u'Epha4', u'Plxna4', u'Chn1', u'Mycbp2', u'Slit1', u'Kif5c', u'Slit2']), geneids='ENSMUSG00000033004 ENSMUSG00000029765 ENSMUSG00000030067 ENSMUSG00000026764 ENSMUSG00000026235 ENSMUSG00000025020 ENSMUSG00000025427 ENSMUSG00000056486 ENSMUSG00000031558', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=7, D1='BC', GO_name='motor neuron axon guidance'),
    Nt(p_uncorrected=3.941213804431076e-06, study_count=8, study_n=1139, namespace='biological_process', p_fdr_bh=0.00080693689663426, study_items=set([u'ENSMUSG00000051790', u'ENSMUSG00000020704', u'ENSMUSG00000060780', u'ENSMUSG00000038738', u'ENSMUSG00000003279', u'ENSMUSG00000063887', u'ENSMUSG00000032589', u'ENSMUSG00000020886']), NS='BP', pop_items=set([u'ENSMUSG00000051790', u'ENSMUSG00000020704', u'ENSMUSG00000020886', u'ENSMUSG00000060780', u'ENSMUSG00000024109', u'ENSMUSG00000032589', u'ENSMUSG00000003279', u'ENSMUSG00000042453', u'ENSMUSG00000007617', u'ENSMUSG00000063887', u'ENSMUSG00000038738', u'ENSMUSG00000061601', u'ENSMUSG00000028969', u'ENSMUSG00000021288']), pop_n=13836, p_sm_bonferroni=0.05971333035093524, is_obsolete=False, GO='GO:0035418', name='protein localization to synapse', pop_count=14, alt_ids=[], level=4, depth=4, enrichment='e', Cluster='Late Decrease', geneid_set=set([u'ENSMUSG00000051790', u'ENSMUSG00000020704', u'ENSMUSG00000060780', u'ENSMUSG00000038738', u'ENSMUSG00000003279', u'ENSMUSG00000063887', u'ENSMUSG00000032589', u'ENSMUSG00000020886']), symbols=u'Asic2 Bsn Dlg4 Dlgap1 Lrrtm1 Nlgn1 Nlgn2 Shank1', symbol_set=set([u'Nlgn2', u'Dlg4', u'Nlgn1', 'Asic2', u'Bsn', u'Dlgap1', u'Lrrtm1', u'Shank1']), geneids='ENSMUSG00000051790 ENSMUSG00000020704 ENSMUSG00000060780 ENSMUSG00000038738 ENSMUSG00000003279 ENSMUSG00000063887 ENSMUSG00000032589 ENSMUSG00000020886', format_txt=1, hdr_idx=1, is_hdrgo=True, is_usrgo=True, hdr1usr01='**', dcnt=10, D1='G', GO_name='protein localization to synapse'),
    Nt(p_uncorrected=0.00035635521713183366, study_count=5, study_n=1139, namespace='biological_process', p_fdr_bh=0.03749401315808619, study_items=set([u'ENSMUSG00000058589', u'ENSMUSG00000050321', u'ENSMUSG00000063887', u'ENSMUSG00000020886', u'ENSMUSG00000000881']), NS='BP', pop_items=set([u'ENSMUSG00000050321', u'ENSMUSG00000000881', u'ENSMUSG00000024109', u'ENSMUSG00000042453', u'ENSMUSG00000020728', u'ENSMUSG00000063887', u'ENSMUSG00000022770', u'ENSMUSG00000058589', u'ENSMUSG00000020886']), pop_n=13836, p_sm_bonferroni=1.0, is_obsolete=False, GO='GO:0097120', name='receptor localization to synapse', pop_count=9, alt_ids=[], level=4, depth=4, enrichment='e', Cluster='Late Decrease', geneid_set=set([u'ENSMUSG00000058589', u'ENSMUSG00000050321', u'ENSMUSG00000020886', u'ENSMUSG00000063887', u'ENSMUSG00000000881']), symbols=u'Anks1b Dlg3 Dlg4 Neto1 Nlgn1', symbol_set=set([u'Anks1b', u'Neto1', u'Dlg3', u'Dlg4', u'Nlgn1']), geneids='ENSMUSG00000058589 ENSMUSG00000000881 ENSMUSG00000050321 ENSMUSG00000063887 ENSMUSG00000020886', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=2, D1='G', GO_name='receptor localization to synapse'),
    Nt(p_uncorrected='', study_count='', study_n='', namespace='', p_fdr_bh='', study_items='', NS='BP', pop_items='', pop_n='', p_sm_bonferroni='', is_obsolete='', GO='GO:0048812', name='', pop_count='', alt_ids='', level=5, depth=7, enrichment='', Cluster='', geneid_set='', symbols='', symbol_set='', geneids='', format_txt=1, hdr_idx=1, is_hdrgo=True, is_usrgo=False, hdr1usr01='*', dcnt=27, D1='BCEH', GO_name='neuron projection morphogenesis'),
    Nt(p_uncorrected='', study_count='', study_n='', namespace='', p_fdr_bh='', study_items='', NS='BP', pop_items='', pop_n='', p_sm_bonferroni='', is_obsolete='', GO='GO:0050877', name='', pop_count='', alt_ids='', level=3, depth=3, enrichment='', Cluster='', geneid_set='', symbols='', symbol_set='', geneids='', format_txt=1, hdr_idx=1, is_hdrgo=True, is_usrgo=False, hdr1usr01='*', dcnt=96, D1='J', GO_name='neurological system process'),
    Nt(p_uncorrected=0.0001582088054011058, study_count=8, study_n=1139, namespace='biological_process', p_fdr_bh=0.01916433156070763, study_items=set([u'ENSMUSG00000023192', u'ENSMUSG00000019828', u'ENSMUSG00000061751', u'ENSMUSG00000049583', u'ENSMUSG00000033981', u'ENSMUSG00000022619', u'ENSMUSG00000005469', u'ENSMUSG00000031302']), NS='BP', pop_items=set([u'ENSMUSG00000044288', u'ENSMUSG00000023192', u'ENSMUSG00000019828', u'ENSMUSG00000005583', u'ENSMUSG00000026249', u'ENSMUSG00000061751', u'ENSMUSG00000036273', u'ENSMUSG00000024211', u'ENSMUSG00000003974', u'ENSMUSG00000033981', u'ENSMUSG00000043051', u'ENSMUSG00000022619', u'ENSMUSG00000031214', u'ENSMUSG00000038665', u'ENSMUSG00000005469', u'ENSMUSG00000035864', u'ENSMUSG00000019969', u'ENSMUSG00000031302', u'ENSMUSG00000056755', u'ENSMUSG00000063239', u'ENSMUSG00000049583']), pop_n=13836, p_sm_bonferroni=1.0, is_obsolete=False, GO='GO:0051966', name='regulation of synaptic transmission, glutamatergic', pop_count=21, alt_ids=[], level=5, depth=6, enrichment='e', Cluster='Late Decrease', geneid_set=set([u'ENSMUSG00000023192', u'ENSMUSG00000019828', u'ENSMUSG00000061751', u'ENSMUSG00000049583', u'ENSMUSG00000033981', u'ENSMUSG00000022619', u'ENSMUSG00000005469', u'ENSMUSG00000031302']), symbols=u'Gria2 Grm1 Grm2 Grm5 Kalrn Mapk8ip2 Nlgn3 Prkaca', symbol_set=set([u'Nlgn3', u'Gria2', u'Kalrn', u'Prkaca', u'Grm2', u'Grm5', u'Grm1', u'Mapk8ip2']), geneids='ENSMUSG00000023192 ENSMUSG00000019828 ENSMUSG00000061751 ENSMUSG00000049583 ENSMUSG00000033981 ENSMUSG00000022619 ENSMUSG00000005469 ENSMUSG00000031302', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=6, D1='A', GO_name='regulation of synaptic transmission, glutamatergic'),
    Nt(p_uncorrected=4.888557845373037e-06, study_count=14, study_n=1139, namespace='biological_process', p_fdr_bh=0.0009745597357269327, study_items=set([u'ENSMUSG00000027660', u'ENSMUSG00000029104', u'ENSMUSG00000040276', u'ENSMUSG00000049336', u'ENSMUSG00000038065', u'ENSMUSG00000048078', u'ENSMUSG00000039239', u'ENSMUSG00000038255', u'ENSMUSG00000034701', u'ENSMUSG00000033676', u'ENSMUSG00000055078', u'ENSMUSG00000016150', u'ENSMUSG00000031971', u'ENSMUSG00000063659']), NS='BP', pop_items=set([u'ENSMUSG00000035086', u'ENSMUSG00000038065', u'ENSMUSG00000033585', u'ENSMUSG00000020052', u'ENSMUSG00000049336', u'ENSMUSG00000002393', u'ENSMUSG00000038255', u'ENSMUSG00000055078', u'ENSMUSG00000031971', u'ENSMUSG00000029050', u'ENSMUSG00000048402', u'ENSMUSG00000027660', u'ENSMUSG00000029104', u'ENSMUSG00000029026', u'ENSMUSG00000035139', u'ENSMUSG00000068329', u'ENSMUSG00000006818', u'ENSMUSG00000049107', u'ENSMUSG00000022952', u'ENSMUSG00000019969', u'ENSMUSG00000005583', u'ENSMUSG00000025810', u'ENSMUSG00000063659', u'ENSMUSG00000025759', u'ENSMUSG00000055471', u'ENSMUSG00000034394', u'ENSMUSG00000045216', u'ENSMUSG00000040276', u'ENSMUSG00000048078', u'ENSMUSG00000039239', u'ENSMUSG00000033676', u'ENSMUSG00000035958', u'ENSMUSG00000021983', u'ENSMUSG00000023951', u'ENSMUSG00000031918', u'ENSMUSG00000038417', u'ENSMUSG00000037475', u'ENSMUSG00000034701', u'ENSMUSG00000020484', u'ENSMUSG00000038718', u'ENSMUSG00000016150', u'ENSMUSG00000039542', u'ENSMUSG00000007653']), pop_n=13836, p_sm_bonferroni=0.07406653991524688, is_obsolete=False, GO='GO:0048666', name='neuron development', pop_count=43, alt_ids=[], level=4, depth=5, enrichment='e', Cluster='Late Decrease', geneid_set=set([u'ENSMUSG00000027660', u'ENSMUSG00000029104', u'ENSMUSG00000040276', u'ENSMUSG00000016150', u'ENSMUSG00000049336', u'ENSMUSG00000048078', u'ENSMUSG00000039239', u'ENSMUSG00000038065', u'ENSMUSG00000038255', u'ENSMUSG00000033676', u'ENSMUSG00000055078', u'ENSMUSG00000034701', u'ENSMUSG00000031971', u'ENSMUSG00000063659']), symbols=u'Ccsap Gabra5 Gabrb3 Htt Mturn Neurod1 Neurod2 Pacsin1 Skil Tenm1 Tenm2 Tenm4 Tgfb2 Zbtb18', symbol_set=set([u'Neurod2', u'Tgfb2', u'Neurod1', 'Ccsap', 'Mturn', 'Zbtb18', 'Tenm2', 'Tenm1', u'Htt', u'Skil', 'Tenm4', u'Gabra5', u'Gabrb3', u'Pacsin1']), geneids='ENSMUSG00000027660 ENSMUSG00000029104 ENSMUSG00000040276 ENSMUSG00000016150 ENSMUSG00000049336 ENSMUSG00000034701 ENSMUSG00000039239 ENSMUSG00000038065 ENSMUSG00000038255 ENSMUSG00000033676 ENSMUSG00000048078 ENSMUSG00000055078 ENSMUSG00000031971 ENSMUSG00000063659', format_txt=1, hdr_idx=1, is_hdrgo=True, is_usrgo=True, hdr1usr01='**', dcnt=29, D1='BCE', GO_name='neuron development'),
    Nt(p_uncorrected=3.4638456267496855e-06, study_count=69, study_n=1139, namespace='biological_process', p_fdr_bh=0.0007605902187084708, study_items=set([u'ENSMUSG00000019699', u'ENSMUSG00000042817', u'ENSMUSG00000067336', u'ENSMUSG00000039145', u'ENSMUSG00000021559', u'ENSMUSG00000032936', u'ENSMUSG00000026596', u'ENSMUSG00000027646', u'ENSMUSG00000038970', u'ENSMUSG00000059146', u'ENSMUSG00000028289', u'ENSMUSG00000057897', u'ENSMUSG00000028664', u'ENSMUSG00000020827', u'ENSMUSG00000005672', u'ENSMUSG00000020612', u'ENSMUSG00000020451', u'ENSMUSG00000031833', u'ENSMUSG00000023050', u'ENSMUSG00000037012', u'ENSMUSG00000029869', u'ENSMUSG00000053137', u'ENSMUSG00000026027', u'ENSMUSG00000022263', u'ENSMUSG00000032500', u'ENSMUSG00000009681', u'ENSMUSG00000050965', u'ENSMUSG00000030397', u'ENSMUSG00000005469', u'ENSMUSG00000057177', u'ENSMUSG00000004936', u'ENSMUSG00000004933', u'ENSMUSG00000026207', u'ENSMUSG00000024242', u'ENSMUSG00000062044', u'ENSMUSG00000031012', u'ENSMUSG00000061751', u'ENSMUSG00000029403', u'ENSMUSG00000021701', u'ENSMUSG00000020015', u'ENSMUSG00000049583', u'ENSMUSG00000039239', u'ENSMUSG00000057230', u'ENSMUSG00000038128', u'ENSMUSG00000026834', u'ENSMUSG00000020990', u'ENSMUSG00000022791', u'ENSMUSG00000045038', u'ENSMUSG00000024122', u'ENSMUSG00000078816', u'ENSMUSG00000020785', u'ENSMUSG00000074923', u'ENSMUSG00000028078', u'ENSMUSG00000001034', u'ENSMUSG00000018334', u'ENSMUSG00000032384', u'ENSMUSG00000055540', u'ENSMUSG00000059456', u'ENSMUSG00000046709', u'ENSMUSG00000031284', u'ENSMUSG00000028926', u'ENSMUSG00000024617', u'ENSMUSG00000026235', u'ENSMUSG00000015599', u'ENSMUSG00000063358', u'ENSMUSG00000052889', u'ENSMUSG00000020580', u'ENSMUSG00000021816', u'ENSMUSG00000074305']), NS='BP', pop_items=set([u'ENSMUSG00000002012', u'ENSMUSG00000029513', u'ENSMUSG00000029512', u'ENSMUSG00000026490', u'ENSMUSG00000028028', u'ENSMUSG00000029516', u'ENSMUSG00000020190', u'ENSMUSG00000074886', u'ENSMUSG00000040084', u'ENSMUSG00000024210', u'ENSMUSG00000016528', u'ENSMUSG00000030110', u'ENSMUSG00000016526', u'ENSMUSG00000089872', u'ENSMUSG00000027665', u'ENSMUSG00000004054', u'ENSMUSG00000004056', u'ENSMUSG00000002409', u'ENSMUSG00000035032', u'ENSMUSG00000020612', u'ENSMUSG00000055471', u'ENSMUSG00000033862', u'ENSMUSG00000024042', u'ENSMUSG00000021408', u'ENSMUSG00000031284', u'ENSMUSG00000042228', u'ENSMUSG00000006445', u'ENSMUSG00000021559', u'ENSMUSG00000059981', u'ENSMUSG00000053693', u'ENSMUSG00000061288', u'ENSMUSG00000022607', u'ENSMUSG00000032796', u'ENSMUSG00000035725', u'ENSMUSG00000021816', u'ENSMUSG00000020366', u'ENSMUSG00000024290', u'ENSMUSG00000022781', u'ENSMUSG00000018209', u'ENSMUSG00000029635', u'ENSMUSG00000062312', u'ENSMUSG00000031644', u'ENSMUSG00000006386', u'ENSMUSG00000024769', u'ENSMUSG00000031012', u'ENSMUSG00000020573', u'ENSMUSG00000009681', u'ENSMUSG00000031016', u'ENSMUSG00000015599', u'ENSMUSG00000057230', u'ENSMUSG00000026834', u'ENSMUSG00000069089', u'ENSMUSG00000022433', u'ENSMUSG00000030849', u'ENSMUSG00000029148', u'ENSMUSG00000024617', u'ENSMUSG00000007613', u'ENSMUSG00000034218', u'ENSMUSG00000020715', u'ENSMUSG00000061393', u'ENSMUSG00000066800', u'ENSMUSG00000024830', u'ENSMUSG00000030409', u'ENSMUSG00000050697', u'ENSMUSG00000020827', u'ENSMUSG00000028150', u'ENSMUSG00000045962', u'ENSMUSG00000000532', u'ENSMUSG00000000530', u'ENSMUSG00000027330', u'ENSMUSG00000026201', u'ENSMUSG00000026207', u'ENSMUSG00000014554', u'ENSMUSG00000046709', u'ENSMUSG00000028078', u'ENSMUSG00000046707', u'ENSMUSG00000024122', u'ENSMUSG00000035486', u'ENSMUSG00000038967', u'ENSMUSG00000042064', u'ENSMUSG00000040936', u'ENSMUSG00000018334', u'ENSMUSG00000000441', u'ENSMUSG00000016179', u'ENSMUSG00000026117', u'ENSMUSG00000052920', u'ENSMUSG00000031833', u'ENSMUSG00000003534', u'ENSMUSG00000022897', u'ENSMUSG00000022892', u'ENSMUSG00000048310', u'ENSMUSG00000023050', u'ENSMUSG00000053137', u'ENSMUSG00000032113', u'ENSMUSG00000019942', u'ENSMUSG00000053819', u'ENSMUSG00000031681', u'ENSMUSG00000061175', u'ENSMUSG00000003228', u'ENSMUSG00000024404', u'ENSMUSG00000035305', u'ENSMUSG00000059146', u'ENSMUSG00000031112', u'ENSMUSG00000056201', u'ENSMUSG00000020258', u'ENSMUSG00000024789', u'ENSMUSG00000029217', u'ENSMUSG00000028756', u'ENSMUSG00000058444', u'ENSMUSG00000033885', u'ENSMUSG00000053046', u'ENSMUSG00000003644', u'ENSMUSG00000034544', u'ENSMUSG00000025060', u'ENSMUSG00000029674', u'ENSMUSG00000034663', u'ENSMUSG00000038145', u'ENSMUSG00000001127', u'ENSMUSG00000032440', u'ENSMUSG00000039145', u'ENSMUSG00000032936', u'ENSMUSG00000020694', u'ENSMUSG00000025358', u'ENSMUSG00000029454', u'ENSMUSG00000000127', u'ENSMUSG00000023809', u'ENSMUSG00000020389', u'ENSMUSG00000021754', u'ENSMUSG00000027177', u'ENSMUSG00000027379', u'ENSMUSG00000020897', u'ENSMUSG00000026778', u'ENSMUSG00000069539', u'ENSMUSG00000025758', u'ENSMUSG00000020623', u'ENSMUSG00000029521', u'ENSMUSG00000002068', u'ENSMUSG00000005566', u'ENSMUSG00000032384', u'ENSMUSG00000037251', u'ENSMUSG00000025199', u'ENSMUSG00000055540', u'ENSMUSG00000027303', u'ENSMUSG00000028926', u'ENSMUSG00000040390', u'ENSMUSG00000032308', u'ENSMUSG00000026622', u'ENSMUSG00000026620', u'ENSMUSG00000002413', u'ENSMUSG00000062234', u'ENSMUSG00000017291', u'ENSMUSG00000030272', u'ENSMUSG00000075590', u'ENSMUSG00000073563', u'ENSMUSG00000041417', u'ENSMUSG00000050567', u'ENSMUSG00000031478', u'ENSMUSG00000042349', u'ENSMUSG00000031805', u'ENSMUSG00000026437', u'ENSMUSG00000040021', u'ENSMUSG00000004936', u'ENSMUSG00000020941', u'ENSMUSG00000004933', u'ENSMUSG00000032409', u'ENSMUSG00000031392', u'ENSMUSG00000062044', u'ENSMUSG00000034290', u'ENSMUSG00000020357', u'ENSMUSG00000003283', u'ENSMUSG00000031155', u'ENSMUSG00000039913', u'ENSMUSG00000078816', u'ENSMUSG00000002688', u'ENSMUSG00000032571', u'ENSMUSG00000002205', u'ENSMUSG00000032577', u'ENSMUSG00000054693', u'ENSMUSG00000025537', u'ENSMUSG00000074305', u'ENSMUSG00000026842', u'ENSMUSG00000020413', u'ENSMUSG00000009772', u'ENSMUSG00000029245', u'ENSMUSG00000029710', u'ENSMUSG00000028664', u'ENSMUSG00000028661', u'ENSMUSG00000033276', u'ENSMUSG00000036273', u'ENSMUSG00000028862', u'ENSMUSG00000024620', u'ENSMUSG00000024621', u'ENSMUSG00000042724', u'ENSMUSG00000024235', u'ENSMUSG00000034751', u'ENSMUSG00000005469', u'ENSMUSG00000001729', u'ENSMUSG00000041135', u'ENSMUSG00000026667', u'ENSMUSG00000020700', u'ENSMUSG00000029403', u'ENSMUSG00000026584', u'ENSMUSG00000009555', u'ENSMUSG00000027297', u'ENSMUSG00000034974', u'ENSMUSG00000027298', u'ENSMUSG00000001034', u'ENSMUSG00000041187', u'ENSMUSG00000024247', u'ENSMUSG00000059456', u'ENSMUSG00000026749', u'ENSMUSG00000018932', u'ENSMUSG00000028969', u'ENSMUSG00000033628', u'ENSMUSG00000008730', u'ENSMUSG00000038970', u'ENSMUSG00000028289', u'ENSMUSG00000063410', u'ENSMUSG00000028284', u'ENSMUSG00000068206', u'ENSMUSG00000031537', u'ENSMUSG00000025162', u'ENSMUSG00000005672', u'ENSMUSG00000050965', u'ENSMUSG00000003810', u'ENSMUSG00000021279', u'ENSMUSG00000021540', u'ENSMUSG00000024387', u'ENSMUSG00000020015', u'ENSMUSG00000015133', u'ENSMUSG00000024383', u'ENSMUSG00000024382', u'ENSMUSG00000031668', u'ENSMUSG00000029062', u'ENSMUSG00000037012', u'ENSMUSG00000026074', u'ENSMUSG00000052430', u'ENSMUSG00000002731', u'ENSMUSG00000019970', u'ENSMUSG00000032537', u'ENSMUSG00000053436', u'ENSMUSG00000021936', u'ENSMUSG00000022836', u'ENSMUSG00000042854', u'ENSMUSG00000062604', u'ENSMUSG00000020516', u'ENSMUSG00000031065', u'ENSMUSG00000021180', u'ENSMUSG00000029613', u'ENSMUSG00000036737', u'ENSMUSG00000020451', u'ENSMUSG00000019577', u'ENSMUSG00000021948', u'ENSMUSG00000039954', u'ENSMUSG00000032547', u'ENSMUSG00000070348', u'ENSMUSG00000037885', u'ENSMUSG00000039456', u'ENSMUSG00000057897', u'ENSMUSG00000025915', u'ENSMUSG00000037738', u'ENSMUSG00000024242', u'ENSMUSG00000027797', u'ENSMUSG00000027796', u'ENSMUSG00000024079', u'ENSMUSG00000039239', u'ENSMUSG00000020427', u'ENSMUSG00000000489', u'ENSMUSG00000015981', u'ENSMUSG00000024969', u'ENSMUSG00000029334', u'ENSMUSG00000027496', u'ENSMUSG00000037643', u'ENSMUSG00000007411', u'ENSMUSG00000024563', u'ENSMUSG00000021115', u'ENSMUSG00000052504', u'ENSMUSG00000020580', u'ENSMUSG00000019699', u'ENSMUSG00000023908', u'ENSMUSG00000037992', u'ENSMUSG00000027810', u'ENSMUSG00000004085', u'ENSMUSG00000031565', u'ENSMUSG00000067713', u'ENSMUSG00000035683', u'ENSMUSG00000050271', u'ENSMUSG00000028959', u'ENSMUSG00000027646', u'ENSMUSG00000030867', u'ENSMUSG00000035112', u'ENSMUSG00000032316', u'ENSMUSG00000032312', u'ENSMUSG00000062209', u'ENSMUSG00000033966', u'ENSMUSG00000042978', u'ENSMUSG00000026836', u'ENSMUSG00000014361', u'ENSMUSG00000004798', u'ENSMUSG00000031314', u'ENSMUSG00000035064', u'ENSMUSG00000027030', u'ENSMUSG00000030815', u'ENSMUSG00000026034', u'ENSMUSG00000020122', u'ENSMUSG00000003068', u'ENSMUSG00000042817', u'ENSMUSG00000042249', u'ENSMUSG00000025958', u'ENSMUSG00000004591', u'ENSMUSG00000020385', u'ENSMUSG00000021994', u'ENSMUSG00000019235', u'ENSMUSG00000028530', u'ENSMUSG00000017376', u'ENSMUSG00000002602', u'ENSMUSG00000002603', u'ENSMUSG00000053158', u'ENSMUSG00000032500', u'ENSMUSG00000022329', u'ENSMUSG00000068917', u'ENSMUSG00000063065', u'ENSMUSG00000024576', u'ENSMUSG00000027692', u'ENSMUSG00000017405', u'ENSMUSG00000050890', u'ENSMUSG00000020785', u'ENSMUSG00000042608', u'ENSMUSG00000074923', u'ENSMUSG00000028708', u'ENSMUSG00000021108', u'ENSMUSG00000028874', u'ENSMUSG00000001630', u'ENSMUSG00000028876', u'ENSMUSG00000006728', u'ENSMUSG00000033191', u'ENSMUSG00000034761', u'ENSMUSG00000020890', u'ENSMUSG00000026674', u'ENSMUSG00000061578', u'ENSMUSG00000028680', u'ENSMUSG00000029471', u'ENSMUSG00000024952', u'ENSMUSG00000025375', u'ENSMUSG00000028518', u'ENSMUSG00000005534', u'ENSMUSG00000005533', u'ENSMUSG00000011960', u'ENSMUSG00000024558', u'ENSMUSG00000037112', u'ENSMUSG00000035390', u'ENSMUSG00000005034', u'ENSMUSG00000026779', u'ENSMUSG00000028991', u'ENSMUSG00000038481', u'ENSMUSG00000027358', u'ENSMUSG00000037593', u'ENSMUSG00000021701', u'ENSMUSG00000049583', u'ENSMUSG00000042046', u'ENSMUSG00000031451', u'ENSMUSG00000031450', u'ENSMUSG00000005102', u'ENSMUSG00000042567', u'ENSMUSG00000026274', u'ENSMUSG00000026277', u'ENSMUSG00000028458', u'ENSMUSG00000041997', u'ENSMUSG00000031853', u'ENSMUSG00000035027', u'ENSMUSG00000045038', u'ENSMUSG00000002007', u'ENSMUSG00000052889', u'ENSMUSG00000020601', u'ENSMUSG00000024070', u'ENSMUSG00000069631', u'ENSMUSG00000025854', u'ENSMUSG00000025855', u'ENSMUSG00000029648', u'ENSMUSG00000026094', u'ENSMUSG00000029053', u'ENSMUSG00000031292', u'ENSMUSG00000018166', u'ENSMUSG00000021796', u'ENSMUSG00000071369', u'ENSMUSG00000021820', u'ENSMUSG00000020115', u'ENSMUSG00000026393', u'ENSMUSG00000019843', u'ENSMUSG00000021413', u'ENSMUSG00000035828', u'ENSMUSG00000013846', u'ENSMUSG00000020272', u'ENSMUSG00000038128', u'ENSMUSG00000003345', u'ENSMUSG00000022791', u'ENSMUSG00000026596', u'ENSMUSG00000005958', u'ENSMUSG00000002948', u'ENSMUSG00000021959', u'ENSMUSG00000026027', u'ENSMUSG00000021483', u'ENSMUSG00000029833', u'ENSMUSG00000029283', u'ENSMUSG00000022812', u'ENSMUSG00000034135', u'ENSMUSG00000061436', u'ENSMUSG00000003119', u'ENSMUSG00000029231', u'ENSMUSG00000022556', u'ENSMUSG00000030602', u'ENSMUSG00000028630', u'ENSMUSG00000021044', u'ENSMUSG00000037989', u'ENSMUSG00000051590', u'ENSMUSG00000059883', u'ENSMUSG00000020990', u'ENSMUSG00000028469', u'ENSMUSG00000030774', u'ENSMUSG00000041245', u'ENSMUSG00000024858', u'ENSMUSG00000026235', u'ENSMUSG00000030890', u'ENSMUSG00000009376', u'ENSMUSG00000064090', u'ENSMUSG00000067336', u'ENSMUSG00000027931', u'ENSMUSG00000021457', u'ENSMUSG00000031309', u'ENSMUSG00000052783', u'ENSMUSG00000031303', u'ENSMUSG00000030397', u'ENSMUSG00000030802', u'ENSMUSG00000041431', u'ENSMUSG00000055254', u'ENSMUSG00000032178', u'ENSMUSG00000032175', u'ENSMUSG00000022033', u'ENSMUSG00000014932', u'ENSMUSG00000014426', u'ENSMUSG00000061751', u'ENSMUSG00000020032', u'ENSMUSG00000074698', u'ENSMUSG00000056458', u'ENSMUSG00000033352', u'ENSMUSG00000033985', u'ENSMUSG00000053414', u'ENSMUSG00000004865', u'ENSMUSG00000024006', u'ENSMUSG00000021918', u'ENSMUSG00000024002', u'ENSMUSG00000038379', u'ENSMUSG00000017716', u'ENSMUSG00000041297', u'ENSMUSG00000060477', u'ENSMUSG00000057672', u'ENSMUSG00000029647', u'ENSMUSG00000029869', u'ENSMUSG00000022263', u'ENSMUSG00000033618', u'ENSMUSG00000052155', u'ENSMUSG00000006494', u'ENSMUSG00000040274', u'ENSMUSG00000029468', u'ENSMUSG00000057177', u'ENSMUSG00000063358', u'ENSMUSG00000024941', u'ENSMUSG00000009828', u'ENSMUSG00000042688', u'ENSMUSG00000024948', u'ENSMUSG00000062960', u'ENSMUSG00000054252', u'ENSMUSG00000025665', u'ENSMUSG00000061462', u'ENSMUSG00000027365']), pop_n=13836, p_sm_bonferroni=0.052480725090884486, is_obsolete=False, GO='GO:0006468', name='protein phosphorylation', pop_count=475, alt_ids=[], level=6, depth=7, enrichment='e', Cluster='Late Decrease', geneid_set=set([u'ENSMUSG00000042817', u'ENSMUSG00000067336', u'ENSMUSG00000039145', u'ENSMUSG00000021559', u'ENSMUSG00000032936', u'ENSMUSG00000026596', u'ENSMUSG00000022263', u'ENSMUSG00000057897', u'ENSMUSG00000028664', u'ENSMUSG00000020827', u'ENSMUSG00000020451', u'ENSMUSG00000032500', u'ENSMUSG00000005469', u'ENSMUSG00000020612', u'ENSMUSG00000001034', u'ENSMUSG00000046709', u'ENSMUSG00000061751', u'ENSMUSG00000029403', u'ENSMUSG00000028078', u'ENSMUSG00000059146', u'ENSMUSG00000039239', u'ENSMUSG00000024122', u'ENSMUSG00000038128', u'ENSMUSG00000022791', u'ENSMUSG00000045038', u'ENSMUSG00000020785', u'ENSMUSG00000074923', u'ENSMUSG00000024242', u'ENSMUSG00000018334', u'ENSMUSG00000032384', u'ENSMUSG00000055540', u'ENSMUSG00000059456', u'ENSMUSG00000028926', u'ENSMUSG00000031833', u'ENSMUSG00000015599', u'ENSMUSG00000026207', u'ENSMUSG00000020580', u'ENSMUSG00000021816', u'ENSMUSG00000019699', u'ENSMUSG00000038970', u'ENSMUSG00000028289', u'ENSMUSG00000063358', u'ENSMUSG00000005672', u'ENSMUSG00000023050', u'ENSMUSG00000037012', u'ENSMUSG00000029869', u'ENSMUSG00000053137', u'ENSMUSG00000026027', u'ENSMUSG00000027646', u'ENSMUSG00000050965', u'ENSMUSG00000030397', u'ENSMUSG00000021701', u'ENSMUSG00000004936', u'ENSMUSG00000004933', u'ENSMUSG00000062044', u'ENSMUSG00000031012', u'ENSMUSG00000009681', u'ENSMUSG00000057177', u'ENSMUSG00000020015', u'ENSMUSG00000049583', u'ENSMUSG00000057230', u'ENSMUSG00000026834', u'ENSMUSG00000020990', u'ENSMUSG00000078816', u'ENSMUSG00000031284', u'ENSMUSG00000024617', u'ENSMUSG00000026235', u'ENSMUSG00000052889', u'ENSMUSG00000074305']), symbols=u'Aak1 Abl2 Acvr1c Akt3 Bcr Bmpr2 Camk1d Camk2a Camk2b Camk4 Camkk1 Camkv Cask Cdk14 Cdk17 Cdkl1 Cdkl2 Csnk1g1 Dapk1 Dclk2 Dclk3 Epha4 Epha6 Epha7 Ephb2 Ephb6 Flt3 Grm5 Gsk3a Hk1 Kalrn Kit Ksr1 Limk2 Lmtk2 Lmtk3 Map2k1 Map3k12 Map4k3 Mapk1 Mapk10 Mapk11 Mapk7 Mark4 Mast3 Matk Mink1 Ntrk3 Pak3 Pak6 Pdpk1 Peak1 Plk2 Ppp3cb Prkaca Prkar1a Prkca Prkcb Prkce Prkcg Ptk2b Rock2 Speg Src Stradb Tgfb2 Tnk2 Trio Ttbk1', symbol_set=set([u'Acvr1c', u'Src', u'Kalrn', u'Gsk3a', u'Camk2a', u'Camk2b', u'Camkv', u'Map3k12', u'Csnk1g1', u'Bmpr2', u'Speg', u'Matk', u'Dapk1', u'Lmtk2', u'Tgfb2', u'Abl2', u'Ephb6', u'Limk2', u'Epha6', u'Epha4', u'Cdkl1', u'Map2k1', u'Cdk14', u'Kit', u'Stradb', u'Prkca', u'Camkk1', u'Mapk10', u'Mapk11', u'Ksr1', u'Map4k3', u'Mink1', u'Prkcb', u'Lmtk3', u'Camk1d', u'Mapk1', u'Ppp3cb', u'Plk2', u'Prkce', u'Camk4', u'Cask', u'Cdkl2', u'Mark4', u'Akt3', u'Prkaca', u'Mapk7', u'Pak3', u'Pdpk1', u'Ntrk3', u'Flt3', u'Bcr', u'Ephb2', u'Tnk2', u'Trio', u'Rock2', 'Peak1', u'Hk1', u'Aak1', u'Dclk3', u'Dclk2', u'Epha7', u'Ptk2b', u'Mast3', u'Prkar1a', u'Grm5', u'Pak6', u'Ttbk1', u'Cdk17', 'Prkcg']), geneids='ENSMUSG00000019699 ENSMUSG00000042817 ENSMUSG00000067336 ENSMUSG00000039145 ENSMUSG00000021559 ENSMUSG00000032936 ENSMUSG00000026596 ENSMUSG00000027646 ENSMUSG00000038970 ENSMUSG00000057177 ENSMUSG00000028289 ENSMUSG00000057897 ENSMUSG00000028664 ENSMUSG00000020827 ENSMUSG00000005672 ENSMUSG00000020451 ENSMUSG00000031833 ENSMUSG00000023050 ENSMUSG00000037012 ENSMUSG00000029869 ENSMUSG00000053137 ENSMUSG00000026027 ENSMUSG00000022263 ENSMUSG00000032500 ENSMUSG00000050965 ENSMUSG00000059146 ENSMUSG00000061751 ENSMUSG00000030397 ENSMUSG00000005469 ENSMUSG00000028078 ENSMUSG00000004936 ENSMUSG00000004933 ENSMUSG00000020612 ENSMUSG00000024242 ENSMUSG00000046709 ENSMUSG00000031012 ENSMUSG00000009681 ENSMUSG00000062044 ENSMUSG00000029403 ENSMUSG00000021701 ENSMUSG00000020015 ENSMUSG00000049583 ENSMUSG00000039239 ENSMUSG00000024122 ENSMUSG00000038128 ENSMUSG00000026834 ENSMUSG00000020990 ENSMUSG00000022791 ENSMUSG00000045038 ENSMUSG00000078816 ENSMUSG00000020785 ENSMUSG00000074923 ENSMUSG00000001034 ENSMUSG00000018334 ENSMUSG00000032384 ENSMUSG00000055540 ENSMUSG00000063358 ENSMUSG00000059456 ENSMUSG00000031284 ENSMUSG00000028926 ENSMUSG00000024617 ENSMUSG00000026235 ENSMUSG00000057230 ENSMUSG00000015599 ENSMUSG00000026207 ENSMUSG00000052889 ENSMUSG00000020580 ENSMUSG00000021816 ENSMUSG00000074305', format_txt=1, hdr_idx=1, is_hdrgo=True, is_usrgo=True, hdr1usr01='**', dcnt=97, D1='BD', GO_name='protein phosphorylation'),
    Nt(p_uncorrected=2.4193462100652037e-06, study_count=7, study_n=1139, namespace='biological_process', p_fdr_bh=0.0005390516827749692, study_items=set([u'ENSMUSG00000003352', u'ENSMUSG00000021313', u'ENSMUSG00000030376', u'ENSMUSG00000020866', u'ENSMUSG00000022416', u'ENSMUSG00000040118', u'ENSMUSG00000054640']), NS='BP', pop_items=set([u'ENSMUSG00000079055', u'ENSMUSG00000003352', u'ENSMUSG00000042644', u'ENSMUSG00000021313', u'ENSMUSG00000030376', u'ENSMUSG00000020866', u'ENSMUSG00000045875', u'ENSMUSG00000022416', u'ENSMUSG00000040118', u'ENSMUSG00000054640']), pop_n=13836, p_sm_bonferroni=0.036655514428697904, is_obsolete=False, GO='GO:0060402', name='calcium ion transport into cytosol', pop_count=10, alt_ids=[], level=4, depth=12, enrichment='e', Cluster='Late Decrease', geneid_set=set([u'ENSMUSG00000021313', u'ENSMUSG00000030376', u'ENSMUSG00000020866', u'ENSMUSG00000054640', u'ENSMUSG00000022416', u'ENSMUSG00000040118', u'ENSMUSG00000003352']), symbols=u'Cacna1g Cacna1i Cacna2d1 Cacnb3 Ryr2 Slc8a1 Slc8a2', symbol_set=set([u'Cacna1i', u'Slc8a2', u'Cacnb3', u'Ryr2', u'Cacna1g', u'Slc8a1', u'Cacna2d1']), geneids='ENSMUSG00000054640 ENSMUSG00000021313 ENSMUSG00000030376 ENSMUSG00000020866 ENSMUSG00000022416 ENSMUSG00000040118 ENSMUSG00000003352', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=11, D1='ABCG', GO_name='calcium ion transport into cytosol'),
    Nt(p_uncorrected=0.00045744749207056603, study_count=8, study_n=1139, namespace='biological_process', p_fdr_bh=0.04682964157000774, study_items=set([u'ENSMUSG00000020704', u'ENSMUSG00000024112', u'ENSMUSG00000030525', u'ENSMUSG00000021313', u'ENSMUSG00000058248', u'ENSMUSG00000000197', u'ENSMUSG00000022416', u'ENSMUSG00000056258']), NS='BP', pop_items=set([u'ENSMUSG00000024112', u'ENSMUSG00000037996', u'ENSMUSG00000009292', u'ENSMUSG00000058248', u'ENSMUSG00000033033', u'ENSMUSG00000000197', u'ENSMUSG00000030525', u'ENSMUSG00000056258', u'ENSMUSG00000049872', u'ENSMUSG00000035681', u'ENSMUSG00000023017', u'ENSMUSG00000004285', u'ENSMUSG00000020704', u'ENSMUSG00000038260', u'ENSMUSG00000033965', u'ENSMUSG00000021313', u'ENSMUSG00000029470', u'ENSMUSG00000022416', u'ENSMUSG00000018340', u'ENSMUSG00000019838', u'ENSMUSG00000050953', u'ENSMUSG00000049265', u'ENSMUSG00000024411', u'ENSMUSG00000018589']), pop_n=13836, p_sm_bonferroni=1.0, is_obsolete=False, GO='GO:0034220', name='ion transmembrane transport', pop_count=24, alt_ids=[], level=5, depth=5, enrichment='e', Cluster='Late Decrease', geneid_set=set([u'ENSMUSG00000020704', u'ENSMUSG00000024112', u'ENSMUSG00000022416', u'ENSMUSG00000021313', u'ENSMUSG00000058248', u'ENSMUSG00000000197', u'ENSMUSG00000030525', u'ENSMUSG00000056258']), symbols=u'Asic2 Cacna1h Cacna1i Chrna7 Kcnh1 Kcnq3 Nalcn Ryr2', symbol_set=set([u'Cacna1h', u'Cacna1i', u'Kcnh1', u'Nalcn', u'Ryr2', u'Kcnq3', 'Asic2', u'Chrna7']), geneids='ENSMUSG00000020704 ENSMUSG00000024112 ENSMUSG00000022416 ENSMUSG00000021313 ENSMUSG00000058248 ENSMUSG00000000197 ENSMUSG00000030525 ENSMUSG00000056258', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=228, D1='G', GO_name='ion transmembrane transport'),
    Nt(p_uncorrected=7.443706488702072e-06, study_count=6, study_n=1139, namespace='biological_process', p_fdr_bh=0.0013923407038311738, study_items=set([u'ENSMUSG00000051790', u'ENSMUSG00000048895', u'ENSMUSG00000026587', u'ENSMUSG00000063887', u'ENSMUSG00000015829', u'ENSMUSG00000031302']), NS='BP', pop_items=set([u'ENSMUSG00000048895', u'ENSMUSG00000051790', u'ENSMUSG00000026587', u'ENSMUSG00000030110', u'ENSMUSG00000024109', u'ENSMUSG00000063887', u'ENSMUSG00000015829', u'ENSMUSG00000031302']), pop_n=13836, p_sm_bonferroni=0.1127795970103251, is_obsolete=False, GO='GO:0007158', name='neuron cell-cell adhesion', pop_count=8, alt_ids=[], level=4, depth=5, enrichment='e', Cluster='Late Decrease', geneid_set=set([u'ENSMUSG00000051790', u'ENSMUSG00000048895', u'ENSMUSG00000063887', u'ENSMUSG00000015829', u'ENSMUSG00000026587', u'ENSMUSG00000031302']), symbols=u'Astn1 Cdk5r1 Nlgn1 Nlgn2 Nlgn3 Tnr', symbol_set=set([u'Nlgn2', u'Nlgn3', u'Tnr', u'Nlgn1', u'Astn1', u'Cdk5r1']), geneids='ENSMUSG00000048895 ENSMUSG00000051790 ENSMUSG00000026587 ENSMUSG00000063887 ENSMUSG00000015829 ENSMUSG00000031302', format_txt=1, hdr_idx=1, is_hdrgo=True, is_usrgo=True, hdr1usr01='**', dcnt=0, D1='CP', GO_name='neuron cell-cell adhesion'),
    Nt(p_uncorrected=1.7487795455354238e-10, study_count=36, study_n=1139, namespace='biological_process', p_fdr_bh=1.6743955073247553e-07, study_items=set([u'ENSMUSG00000059003', u'ENSMUSG00000023192', u'ENSMUSG00000047904', u'ENSMUSG00000033981', u'ENSMUSG00000063142', u'ENSMUSG00000054934', u'ENSMUSG00000036510', u'ENSMUSG00000020866', u'ENSMUSG00000055078', u'ENSMUSG00000020827', u'ENSMUSG00000003352', u'ENSMUSG00000000881', u'ENSMUSG00000027584', u'ENSMUSG00000033214', u'ENSMUSG00000037014', u'ENSMUSG00000044933', u'ENSMUSG00000021721', u'ENSMUSG00000034656', u'ENSMUSG00000030209', u'ENSMUSG00000047879', u'ENSMUSG00000049583', u'ENSMUSG00000030519', u'ENSMUSG00000036422', u'ENSMUSG00000034799', u'ENSMUSG00000020524', u'ENSMUSG00000070570', u'ENSMUSG00000025889', u'ENSMUSG00000057914', u'ENSMUSG00000026322', u'ENSMUSG00000078816', u'ENSMUSG00000003279', u'ENSMUSG00000003378', u'ENSMUSG00000051331', u'ENSMUSG00000053025', u'ENSMUSG00000028004', u'ENSMUSG00000020882']), NS='BP', pop_items=set([u'ENSMUSG00000063260', u'ENSMUSG00000047904', u'ENSMUSG00000009376', u'ENSMUSG00000062151', u'ENSMUSG00000020308', u'ENSMUSG00000028020', u'ENSMUSG00000020866', u'ENSMUSG00000055078', u'ENSMUSG00000029054', u'ENSMUSG00000003378', u'ENSMUSG00000059003', u'ENSMUSG00000033768', u'ENSMUSG00000039953', u'ENSMUSG00000023072', u'ENSMUSG00000044933', u'ENSMUSG00000006932', u'ENSMUSG00000049511', u'ENSMUSG00000034891', u'ENSMUSG00000022770', u'ENSMUSG00000050783', u'ENSMUSG00000034656', u'ENSMUSG00000047910', u'ENSMUSG00000030209', u'ENSMUSG00000000766', u'ENSMUSG00000041380', u'ENSMUSG00000030201', u'ENSMUSG00000044043', u'ENSMUSG00000036422', u'ENSMUSG00000034799', u'ENSMUSG00000033396', u'ENSMUSG00000026959', u'ENSMUSG00000051242', u'ENSMUSG00000024960', u'ENSMUSG00000017765', u'ENSMUSG00000033419', u'ENSMUSG00000031343', u'ENSMUSG00000056073', u'ENSMUSG00000003279', u'ENSMUSG00000035431', u'ENSMUSG00000034520', u'ENSMUSG00000020745', u'ENSMUSG00000027400', u'ENSMUSG00000028249', u'ENSMUSG00000020436', u'ENSMUSG00000028004', u'ENSMUSG00000003352', u'ENSMUSG00000000881', u'ENSMUSG00000037014', u'ENSMUSG00000043458', u'ENSMUSG00000024211', u'ENSMUSG00000045731', u'ENSMUSG00000045573', u'ENSMUSG00000051678', u'ENSMUSG00000061762', u'ENSMUSG00000004931', u'ENSMUSG00000031393', u'ENSMUSG00000030307', u'ENSMUSG00000024109', u'ENSMUSG00000020402', u'ENSMUSG00000051599', u'ENSMUSG00000063687', u'ENSMUSG00000020524', u'ENSMUSG00000070570', u'ENSMUSG00000028613', u'ENSMUSG00000026322', u'ENSMUSG00000032360', u'ENSMUSG00000017756', u'ENSMUSG00000063239', u'ENSMUSG00000001260', u'ENSMUSG00000020961', u'ENSMUSG00000030310', u'ENSMUSG00000008892', u'ENSMUSG00000039106', u'ENSMUSG00000050511', u'ENSMUSG00000078816', u'ENSMUSG00000022523', u'ENSMUSG00000031144', u'ENSMUSG00000041936', u'ENSMUSG00000020827', u'ENSMUSG00000033577', u'ENSMUSG00000045689', u'ENSMUSG00000027584', u'ENSMUSG00000034593', u'ENSMUSG00000025892', u'ENSMUSG00000051111', u'ENSMUSG00000052301', u'ENSMUSG00000057914', u'ENSMUSG00000034997', u'ENSMUSG00000017740', u'ENSMUSG00000045876', u'ENSMUSG00000019433', u'ENSMUSG00000027130', u'ENSMUSG00000029763', u'ENSMUSG00000021721', u'ENSMUSG00000046191', u'ENSMUSG00000046387', u'ENSMUSG00000051331', u'ENSMUSG00000073591', u'ENSMUSG00000025889', u'ENSMUSG00000036510', u'ENSMUSG00000025551', u'ENSMUSG00000033981', u'ENSMUSG00000063142', u'ENSMUSG00000048347', u'ENSMUSG00000047033', u'ENSMUSG00000047307', u'ENSMUSG00000001018', u'ENSMUSG00000023192', u'ENSMUSG00000068615', u'ENSMUSG00000044014', u'ENSMUSG00000053004', u'ENSMUSG00000054934', u'ENSMUSG00000043313', u'ENSMUSG00000066392', u'ENSMUSG00000056755', u'ENSMUSG00000050534', u'ENSMUSG00000033214', u'ENSMUSG00000024798', u'ENSMUSG00000026103', u'ENSMUSG00000037610', u'ENSMUSG00000051486', u'ENSMUSG00000038486', u'ENSMUSG00000044022', u'ENSMUSG00000047879', u'ENSMUSG00000049583', u'ENSMUSG00000030519', u'ENSMUSG00000030108', u'ENSMUSG00000030109', u'ENSMUSG00000045657', u'ENSMUSG00000028456', u'ENSMUSG00000045062', u'ENSMUSG00000024897', u'ENSMUSG00000053025', u'ENSMUSG00000020882', u'ENSMUSG00000000058', u'ENSMUSG00000045498']), pop_n=13836, p_sm_bonferroni=2.6495758894407207e-06, is_obsolete=False, GO='GO:0007268', name='chemical synaptic transmission', pop_count=136, alt_ids=[], level=7, depth=7, enrichment='e', Cluster='Late Decrease', geneid_set=set([u'ENSMUSG00000023192', u'ENSMUSG00000047904', u'ENSMUSG00000054934', u'ENSMUSG00000036510', u'ENSMUSG00000020866', u'ENSMUSG00000055078', u'ENSMUSG00000003352', u'ENSMUSG00000020827', u'ENSMUSG00000059003', u'ENSMUSG00000078816', u'ENSMUSG00000027584', u'ENSMUSG00000033214', u'ENSMUSG00000000881', u'ENSMUSG00000044933', u'ENSMUSG00000047879', u'ENSMUSG00000051331', u'ENSMUSG00000063142', u'ENSMUSG00000053025', u'ENSMUSG00000030209', u'ENSMUSG00000021721', u'ENSMUSG00000049583', u'ENSMUSG00000030519', u'ENSMUSG00000037014', u'ENSMUSG00000034799', u'ENSMUSG00000020524', u'ENSMUSG00000070570', u'ENSMUSG00000025889', u'ENSMUSG00000057914', u'ENSMUSG00000026322', u'ENSMUSG00000033981', u'ENSMUSG00000003279', u'ENSMUSG00000003378', u'ENSMUSG00000036422', u'ENSMUSG00000034656', u'ENSMUSG00000028004', u'ENSMUSG00000020882']), symbols=u'Apba2 Cacna1a Cacna1c Cacna1g Cacnb1 Cacnb2 Cacnb3 Cdh8 Dlg3 Dlgap1 Gabra5 Gria1 Gria2 Grik5 Grin2a Grin2b Grm2 Grm5 Htr1a Htr4 Kcnma1 Kcnmb4 Mink1 Npy2r Oprl1 Pcdh8 Prkcg Slc17a7 Slitrk5 Snca Sstr2 Sstr3 Sstr4 Sv2b Unc13a Usp14', symbol_set=set([u'Pcdh8', u'Cacna1a', u'Cacna1c', u'Cacna1g', u'Sstr3', u'Sstr2', u'Sstr4', u'Snca', u'Kcnmb4', u'Cacnb3', u'Cacnb2', u'Cacnb1', u'Grin2b', u'Cdh8', u'Npy2r', u'Grin2a', u'Oprl1', u'Mink1', u'Slc17a7', u'Apba2', u'Grik5', 'Prkcg', u'Htr4', u'Usp14', u'Gabra5', u'Htr1a', u'Dlg3', u'Slitrk5', u'Gria2', u'Gria1', u'Kcnma1', u'Dlgap1', u'Unc13a', u'Grm5', u'Sv2b', u'Grm2']), geneids='ENSMUSG00000059003 ENSMUSG00000023192 ENSMUSG00000047904 ENSMUSG00000063142 ENSMUSG00000054934 ENSMUSG00000036510 ENSMUSG00000028004 ENSMUSG00000055078 ENSMUSG00000003352 ENSMUSG00000003378 ENSMUSG00000000881 ENSMUSG00000078816 ENSMUSG00000027584 ENSMUSG00000033214 ENSMUSG00000037014 ENSMUSG00000044933 ENSMUSG00000047879 ENSMUSG00000034656 ENSMUSG00000030209 ENSMUSG00000021721 ENSMUSG00000049583 ENSMUSG00000030519 ENSMUSG00000036422 ENSMUSG00000034799 ENSMUSG00000020524 ENSMUSG00000070570 ENSMUSG00000025889 ENSMUSG00000057914 ENSMUSG00000026322 ENSMUSG00000033981 ENSMUSG00000003279 ENSMUSG00000051331 ENSMUSG00000053025 ENSMUSG00000020866 ENSMUSG00000020882 ENSMUSG00000020827', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=12, D1='BCQ', GO_name='chemical synaptic transmission'),
    Nt(p_uncorrected='', study_count='', study_n='', namespace='', p_fdr_bh='', study_items='', NS='BP', pop_items='', pop_n='', p_sm_bonferroni='', is_obsolete='', GO='GO:0007155', name='', pop_count='', alt_ids='', level=2, depth=2, enrichment='', Cluster='', geneid_set='', symbols='', symbol_set='', geneids='', format_txt=1, hdr_idx=1, is_hdrgo=True, is_usrgo=False, hdr1usr01='*', dcnt=98, D1='P', GO_name='cell adhesion'),
    Nt(p_uncorrected=7.934356582946771e-06, study_count=18, study_n=1139, namespace='biological_process', p_fdr_bh=0.0014483546576894762, study_items=set([u'ENSMUSG00000050505', u'ENSMUSG00000031391', u'ENSMUSG00000041592', u'ENSMUSG00000032452', u'ENSMUSG00000034275', u'ENSMUSG00000005338', u'ENSMUSG00000032012', u'ENSMUSG00000036510', u'ENSMUSG00000025370', u'ENSMUSG00000051323', u'ENSMUSG00000036422', u'ENSMUSG00000046743', u'ENSMUSG00000022883', u'ENSMUSG00000068740', u'ENSMUSG00000023473', u'ENSMUSG00000051375', u'ENSMUSG00000032087', u'ENSMUSG00000031673']), NS='BP', pop_items=set([u'ENSMUSG00000044393', u'ENSMUSG00000031385', u'ENSMUSG00000059898', u'ENSMUSG00000074505', u'ENSMUSG00000050505', u'ENSMUSG00000037995', u'ENSMUSG00000025370', u'ENSMUSG00000006411', u'ENSMUSG00000008153', u'ENSMUSG00000030110', u'ENSMUSG00000031561', u'ENSMUSG00000074272', u'ENSMUSG00000036606', u'ENSMUSG00000032087', u'ENSMUSG00000031673', u'ENSMUSG00000026312', u'ENSMUSG00000039953', u'ENSMUSG00000022661', u'ENSMUSG00000033278', u'ENSMUSG00000032036', u'ENSMUSG00000040511', u'ENSMUSG00000032012', u'ENSMUSG00000052613', u'ENSMUSG00000032076', u'ENSMUSG00000062300', u'ENSMUSG00000048218', u'ENSMUSG00000049100', u'ENSMUSG00000036862', u'ENSMUSG00000022321', u'ENSMUSG00000031841', u'ENSMUSG00000052516', u'ENSMUSG00000050840', u'ENSMUSG00000021803', u'ENSMUSG00000012819', u'ENSMUSG00000016028', u'ENSMUSG00000001946', u'ENSMUSG00000031391', u'ENSMUSG00000045876', u'ENSMUSG00000064115', u'ENSMUSG00000033295', u'ENSMUSG00000032462', u'ENSMUSG00000040452', u'ENSMUSG00000039385', u'ENSMUSG00000044043', u'ENSMUSG00000037892', u'ENSMUSG00000036422', u'ENSMUSG00000046743', u'ENSMUSG00000022883', u'ENSMUSG00000068740', u'ENSMUSG00000051375', u'ENSMUSG00000022656', u'ENSMUSG00000005338', u'ENSMUSG00000000303', u'ENSMUSG00000051678', u'ENSMUSG00000000305', u'ENSMUSG00000041592', u'ENSMUSG00000032452', u'ENSMUSG00000034275', u'ENSMUSG00000054793', u'ENSMUSG00000053141', u'ENSMUSG00000053166', u'ENSMUSG00000051323', u'ENSMUSG00000024304', u'ENSMUSG00000050947', u'ENSMUSG00000048347', u'ENSMUSG00000059674', u'ENSMUSG00000036510', u'ENSMUSG00000023473', u'ENSMUSG00000031871']), pop_n=13836, p_sm_bonferroni=0.12021343658822653, is_obsolete=False, GO='GO:0007156', name='homophilic cell adhesion via plasma membrane adhesion molecules', pop_count=69, alt_ids=[], level=5, depth=5, enrichment='e', Cluster='Late Decrease', geneid_set=set([u'ENSMUSG00000031391', u'ENSMUSG00000068740', u'ENSMUSG00000036510', u'ENSMUSG00000051323', u'ENSMUSG00000036422', u'ENSMUSG00000046743', u'ENSMUSG00000022883', u'ENSMUSG00000050505', u'ENSMUSG00000051375', u'ENSMUSG00000032087', u'ENSMUSG00000031673', u'ENSMUSG00000041592', u'ENSMUSG00000032452', u'ENSMUSG00000034275', u'ENSMUSG00000032012', u'ENSMUSG00000025370', u'ENSMUSG00000005338', u'ENSMUSG00000023473']), symbols=u'Cadm3 Cdh11 Cdh8 Cdh9 Celsr2 Celsr3 Clstn2 Dscaml1 Fat4 Igsf9b L1cam Nectin1 Pcdh1 Pcdh19 Pcdh20 Pcdh8 Robo1 Sdk2', symbol_set=set([u'Pcdh8', u'Cdh11', u'Sdk2', u'Pcdh20', u'Igsf9b', u'Robo1', u'Pcdh1', u'L1cam', u'Celsr3', u'Celsr2', u'Cdh9', u'Cdh8', 'Nectin1', u'Clstn2', u'Fat4', u'Pcdh19', u'Cadm3', u'Dscaml1']), geneids='ENSMUSG00000031391 ENSMUSG00000041592 ENSMUSG00000032452 ENSMUSG00000034275 ENSMUSG00000050505 ENSMUSG00000051375 ENSMUSG00000032012 ENSMUSG00000036510 ENSMUSG00000025370 ENSMUSG00000051323 ENSMUSG00000036422 ENSMUSG00000046743 ENSMUSG00000022883 ENSMUSG00000068740 ENSMUSG00000005338 ENSMUSG00000023473 ENSMUSG00000032087 ENSMUSG00000031673', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=0, D1='P', GO_name='homophilic cell adhesion via plasma membrane adhesion molecules'),
    Nt(p_uncorrected='', study_count='', study_n='', namespace='', p_fdr_bh='', study_items='', NS='BP', pop_items='', pop_n='', p_sm_bonferroni='', is_obsolete='', GO='GO:0051179', name='', pop_count='', alt_ids='', level=1, depth=1, enrichment='', Cluster='', geneid_set='', symbols='', symbol_set='', geneids='', format_txt=1, hdr_idx=1, is_hdrgo=True, is_usrgo=False, hdr1usr01='*', dcnt=2176, D1='G', GO_name='localization'),
    Nt(p_uncorrected=7.787958194621933e-11, study_count=72, study_n=1139, namespace='biological_process', p_fdr_bh=1.3778716776436982e-07, study_items=set([u'ENSMUSG00000006711', u'ENSMUSG00000052727', u'ENSMUSG00000057897', u'ENSMUSG00000062232', u'ENSMUSG00000063531', u'ENSMUSG00000039145', u'ENSMUSG00000038255', u'ENSMUSG00000042599', u'ENSMUSG00000038970', u'ENSMUSG00000051323', u'ENSMUSG00000028289', u'ENSMUSG00000029712', u'ENSMUSG00000063887', u'ENSMUSG00000028519', u'ENSMUSG00000028664', u'ENSMUSG00000000881', u'ENSMUSG00000032087', u'ENSMUSG00000051243', u'ENSMUSG00000030397', u'ENSMUSG00000008658', u'ENSMUSG00000060534', u'ENSMUSG00000046230', u'ENSMUSG00000009418', u'ENSMUSG00000029121', u'ENSMUSG00000026833', u'ENSMUSG00000032336', u'ENSMUSG00000063160', u'ENSMUSG00000045903', u'ENSMUSG00000003410', u'ENSMUSG00000022231', u'ENSMUSG00000025867', u'ENSMUSG00000031391', u'ENSMUSG00000031137', u'ENSMUSG00000061751', u'ENSMUSG00000029765', u'ENSMUSG00000061911', u'ENSMUSG00000057177', u'ENSMUSG00000026768', u'ENSMUSG00000059146', u'ENSMUSG00000037984', u'ENSMUSG00000019261', u'ENSMUSG00000025020', u'ENSMUSG00000036422', u'ENSMUSG00000031558', u'ENSMUSG00000022883', u'ENSMUSG00000033066', u'ENSMUSG00000043557', u'ENSMUSG00000001419', u'ENSMUSG00000025128', u'ENSMUSG00000041609', u'ENSMUSG00000043535', u'ENSMUSG00000056427', u'ENSMUSG00000036792', u'ENSMUSG00000075318', u'ENSMUSG00000062098', u'ENSMUSG00000034275', u'ENSMUSG00000030584', u'ENSMUSG00000047261', u'ENSMUSG00000034701', u'ENSMUSG00000035513', u'ENSMUSG00000026235', u'ENSMUSG00000010505', u'ENSMUSG00000040506', u'ENSMUSG00000038738', u'ENSMUSG00000031511', u'ENSMUSG00000039114', u'ENSMUSG00000046449', u'ENSMUSG00000050132', u'ENSMUSG00000041773', u'ENSMUSG00000034675', u'ENSMUSG00000056486', u'ENSMUSG00000030077']), NS='BP', pop_items=set([u'ENSMUSG00000000738', u'ENSMUSG00000003873', u'ENSMUSG00000029516', u'ENSMUSG00000026965', u'ENSMUSG00000000902', u'ENSMUSG00000039145', u'ENSMUSG00000007989', u'ENSMUSG00000038255', u'ENSMUSG00000028020', u'ENSMUSG00000042599', u'ENSMUSG00000046020', u'ENSMUSG00000004891', u'ENSMUSG00000035390', u'ENSMUSG00000030447', u'ENSMUSG00000030110', u'ENSMUSG00000021451', u'ENSMUSG00000026249', u'ENSMUSG00000022475', u'ENSMUSG00000032228', u'ENSMUSG00000005057', u'ENSMUSG00000058886', u'ENSMUSG00000031511', u'ENSMUSG00000044548', u'ENSMUSG00000055493', u'ENSMUSG00000040003', u'ENSMUSG00000006932', u'ENSMUSG00000031517', u'ENSMUSG00000021796', u'ENSMUSG00000064293', u'ENSMUSG00000032336', u'ENSMUSG00000021820', u'ENSMUSG00000004698', u'ENSMUSG00000075415', u'ENSMUSG00000041609', u'ENSMUSG00000005583', u'ENSMUSG00000057969', u'ENSMUSG00000024501', u'ENSMUSG00000023883', u'ENSMUSG00000055471', u'ENSMUSG00000027797', u'ENSMUSG00000026812', u'ENSMUSG00000027314', u'ENSMUSG00000045333', u'ENSMUSG00000021693', u'ENSMUSG00000040254', u'ENSMUSG00000061524', u'ENSMUSG00000022048', u'ENSMUSG00000014303', u'ENSMUSG00000042182', u'ENSMUSG00000040374', u'ENSMUSG00000068154', u'ENSMUSG00000005958', u'ENSMUSG00000033066', u'ENSMUSG00000026890', u'ENSMUSG00000019261', u'ENSMUSG00000039830', u'ENSMUSG00000025128', u'ENSMUSG00000025089', u'ENSMUSG00000008855', u'ENSMUSG00000005045', u'ENSMUSG00000063531', u'ENSMUSG00000034813', u'ENSMUSG00000006398', u'ENSMUSG00000040010', u'ENSMUSG00000060534', u'ENSMUSG00000034336', u'ENSMUSG00000006095', u'ENSMUSG00000026425', u'ENSMUSG00000028832', u'ENSMUSG00000014773', u'ENSMUSG00000022108', u'ENSMUSG00000026259', u'ENSMUSG00000041773', u'ENSMUSG00000020745', u'ENSMUSG00000029712', u'ENSMUSG00000026826', u'ENSMUSG00000046731', u'ENSMUSG00000022892', u'ENSMUSG00000013663', u'ENSMUSG00000026768', u'ENSMUSG00000048001', u'ENSMUSG00000021577', u'ENSMUSG00000020458', u'ENSMUSG00000030272', u'ENSMUSG00000032482', u'ENSMUSG00000032481', u'ENSMUSG00000037995', u'ENSMUSG00000075590', u'ENSMUSG00000068798', u'ENSMUSG00000063887', u'ENSMUSG00000000881', u'ENSMUSG00000006699', u'ENSMUSG00000022995', u'ENSMUSG00000045515', u'ENSMUSG00000028883', u'ENSMUSG00000028969', u'ENSMUSG00000029600', u'ENSMUSG00000029121', u'ENSMUSG00000027313', u'ENSMUSG00000000247', u'ENSMUSG00000043051', u'ENSMUSG00000025207', u'ENSMUSG00000002274', u'ENSMUSG00000010505', u'ENSMUSG00000015149', u'ENSMUSG00000026223', u'ENSMUSG00000048482', u'ENSMUSG00000052516', u'ENSMUSG00000045903', u'ENSMUSG00000049001', u'ENSMUSG00000052512', u'ENSMUSG00000037892', u'ENSMUSG00000020053', u'ENSMUSG00000020052', u'ENSMUSG00000026930', u'ENSMUSG00000031391', u'ENSMUSG00000026833', u'ENSMUSG00000027434', u'ENSMUSG00000037984', u'ENSMUSG00000001419', u'ENSMUSG00000055022', u'ENSMUSG00000025020', u'ENSMUSG00000031558', u'ENSMUSG00000048915', u'ENSMUSG00000055373', u'ENSMUSG00000019647', u'ENSMUSG00000004798', u'ENSMUSG00000063446', u'ENSMUSG00000043535', u'ENSMUSG00000026317', u'ENSMUSG00000022231', u'ENSMUSG00000031217', u'ENSMUSG00000032368', u'ENSMUSG00000028949', u'ENSMUSG00000035062', u'ENSMUSG00000001300', u'ENSMUSG00000050071', u'ENSMUSG00000035513', u'ENSMUSG00000030075', u'ENSMUSG00000046230', u'ENSMUSG00000026235', u'ENSMUSG00000004558', u'ENSMUSG00000035456', u'ENSMUSG00000036131', u'ENSMUSG00000062098', u'ENSMUSG00000039114', u'ENSMUSG00000041120', u'ENSMUSG00000038777', u'ENSMUSG00000000627', u'ENSMUSG00000030894', u'ENSMUSG00000021743', u'ENSMUSG00000030092', u'ENSMUSG00000035277', u'ENSMUSG00000031385', u'ENSMUSG00000028064', u'ENSMUSG00000003934', u'ENSMUSG00000032740', u'ENSMUSG00000059857', u'ENSMUSG00000035314', u'ENSMUSG00000029245', u'ENSMUSG00000032187', u'ENSMUSG00000028780', u'ENSMUSG00000028664', u'ENSMUSG00000062209', u'ENSMUSG00000021224', u'ENSMUSG00000057897', u'ENSMUSG00000028661', u'ENSMUSG00000030397', u'ENSMUSG00000008658', u'ENSMUSG00000030557', u'ENSMUSG00000040040', u'ENSMUSG00000048782', u'ENSMUSG00000047554', u'ENSMUSG00000007880', u'ENSMUSG00000026121', u'ENSMUSG00000053647', u'ENSMUSG00000062232', u'ENSMUSG00000018736', u'ENSMUSG00000031785', u'ENSMUSG00000037935', u'ENSMUSG00000049107', u'ENSMUSG00000040631', u'ENSMUSG00000028657', u'ENSMUSG00000049100', u'ENSMUSG00000066043', u'ENSMUSG00000025810', u'ENSMUSG00000022031', u'ENSMUSG00000024423', u'ENSMUSG00000031283', u'ENSMUSG00000027699', u'ENSMUSG00000000838', u'ENSMUSG00000022297', u'ENSMUSG00000031137', u'ENSMUSG00000009418', u'ENSMUSG00000029765', u'ENSMUSG00000033295', u'ENSMUSG00000021250', u'ENSMUSG00000029291', u'ENSMUSG00000005089', u'ENSMUSG00000020547', u'ENSMUSG00000050947', u'ENSMUSG00000036745', u'ENSMUSG00000029168', u'ENSMUSG00000022883', u'ENSMUSG00000001729', u'ENSMUSG00000030539', u'ENSMUSG00000032128', u'ENSMUSG00000043557', u'ENSMUSG00000025369', u'ENSMUSG00000075318', u'ENSMUSG00000047084', u'ENSMUSG00000056427', u'ENSMUSG00000022353', u'ENSMUSG00000036078', u'ENSMUSG00000022935', u'ENSMUSG00000032216', u'ENSMUSG00000005102', u'ENSMUSG00000034275', u'ENSMUSG00000025551', u'ENSMUSG00000063632', u'ENSMUSG00000032517', u'ENSMUSG00000032340', u'ENSMUSG00000062991', u'ENSMUSG00000062312', u'ENSMUSG00000035764', u'ENSMUSG00000067071', u'ENSMUSG00000037601', u'ENSMUSG00000028556', u'ENSMUSG00000003527', u'ENSMUSG00000034675', u'ENSMUSG00000069171', u'ENSMUSG00000069170', u'ENSMUSG00000006711', u'ENSMUSG00000021221', u'ENSMUSG00000034701', u'ENSMUSG00000027560', u'ENSMUSG00000025969', u'ENSMUSG00000034958', u'ENSMUSG00000038976', u'ENSMUSG00000038970', u'ENSMUSG00000051323', u'ENSMUSG00000028289', u'ENSMUSG00000043991', u'ENSMUSG00000016541', u'ENSMUSG00000028519', u'ENSMUSG00000045382', u'ENSMUSG00000031239', u'ENSMUSG00000053819', u'ENSMUSG00000030077', u'ENSMUSG00000046167', u'ENSMUSG00000051243', u'ENSMUSG00000020319', u'ENSMUSG00000024099', u'ENSMUSG00000067860', u'ENSMUSG00000061751', u'ENSMUSG00000024921', u'ENSMUSG00000024256', u'ENSMUSG00000002688', u'ENSMUSG00000032087', u'ENSMUSG00000060798', u'ENSMUSG00000031432', u'ENSMUSG00000063919', u'ENSMUSG00000022261', u'ENSMUSG00000061911', u'ENSMUSG00000019864', u'ENSMUSG00000075478', u'ENSMUSG00000056596', u'ENSMUSG00000050272', u'ENSMUSG00000021645', u'ENSMUSG00000063160', u'ENSMUSG00000038175', u'ENSMUSG00000027692', u'ENSMUSG00000022812', u'ENSMUSG00000020167', u'ENSMUSG00000038264', u'ENSMUSG00000025867', u'ENSMUSG00000059146', u'ENSMUSG00000025158', u'ENSMUSG00000003410', u'ENSMUSG00000057177', u'ENSMUSG00000021702', u'ENSMUSG00000004768', u'ENSMUSG00000020918', u'ENSMUSG00000046449', u'ENSMUSG00000024068', u'ENSMUSG00000038738', u'ENSMUSG00000044147', u'ENSMUSG00000053477', u'ENSMUSG00000031214', u'ENSMUSG00000042369', u'ENSMUSG00000022678', u'ENSMUSG00000057778', u'ENSMUSG00000027419', u'ENSMUSG00000048978', u'ENSMUSG00000055254', u'ENSMUSG00000023951', u'ENSMUSG00000018143', u'ENSMUSG00000027200', u'ENSMUSG00000027671', u'ENSMUSG00000053046', u'ENSMUSG00000023018', u'ENSMUSG00000028907', u'ENSMUSG00000056486', u'ENSMUSG00000030584', u'ENSMUSG00000052727', u'ENSMUSG00000031285', u'ENSMUSG00000001227', u'ENSMUSG00000036792', u'ENSMUSG00000032537', u'ENSMUSG00000027763', u'ENSMUSG00000036422', u'ENSMUSG00000036955', u'ENSMUSG00000040506', u'ENSMUSG00000047261', u'ENSMUSG00000041703', u'ENSMUSG00000040957', u'ENSMUSG00000037621', u'ENSMUSG00000052133', u'ENSMUSG00000022103', u'ENSMUSG00000050132', u'ENSMUSG00000035910']), pop_n=13836, p_sm_bonferroni=1.179953546067169e-06, is_obsolete=False, GO='GO:0007399', name='nervous system development', pop_count=321, alt_ids=[], level=4, depth=4, enrichment='e', Cluster='Late Decrease', geneid_set=set([u'ENSMUSG00000063531', u'ENSMUSG00000039145', u'ENSMUSG00000038255', u'ENSMUSG00000042599', u'ENSMUSG00000029712', u'ENSMUSG00000057897', u'ENSMUSG00000028664', u'ENSMUSG00000030397', u'ENSMUSG00000008658', u'ENSMUSG00000062098', u'ENSMUSG00000032336', u'ENSMUSG00000041609', u'ENSMUSG00000031137', u'ENSMUSG00000009418', u'ENSMUSG00000029765', u'ENSMUSG00000061911', u'ENSMUSG00000059146', u'ENSMUSG00000039114', u'ENSMUSG00000036422', u'ENSMUSG00000022883', u'ENSMUSG00000033066', u'ENSMUSG00000043557', u'ENSMUSG00000025128', u'ENSMUSG00000075318', u'ENSMUSG00000056427', u'ENSMUSG00000034275', u'ENSMUSG00000060534', u'ENSMUSG00000010505', u'ENSMUSG00000046449', u'ENSMUSG00000041773', u'ENSMUSG00000006711', u'ENSMUSG00000034701', u'ENSMUSG00000062232', u'ENSMUSG00000038738', u'ENSMUSG00000038970', u'ENSMUSG00000051323', u'ENSMUSG00000028289', u'ENSMUSG00000063887', u'ENSMUSG00000028519', u'ENSMUSG00000000881', u'ENSMUSG00000032087', u'ENSMUSG00000051243', u'ENSMUSG00000061751', u'ENSMUSG00000029121', u'ENSMUSG00000034675', u'ENSMUSG00000063160', u'ENSMUSG00000045903', u'ENSMUSG00000035513', u'ENSMUSG00000025867', u'ENSMUSG00000031391', u'ENSMUSG00000026833', u'ENSMUSG00000057177', u'ENSMUSG00000026768', u'ENSMUSG00000037984', u'ENSMUSG00000019261', u'ENSMUSG00000025020', u'ENSMUSG00000031558', u'ENSMUSG00000001419', u'ENSMUSG00000043535', u'ENSMUSG00000022231', u'ENSMUSG00000030584', u'ENSMUSG00000052727', u'ENSMUSG00000046230', u'ENSMUSG00000026235', u'ENSMUSG00000056486', u'ENSMUSG00000040506', u'ENSMUSG00000047261', u'ENSMUSG00000031511', u'ENSMUSG00000003410', u'ENSMUSG00000050132', u'ENSMUSG00000036792', u'ENSMUSG00000030077']), symbols=u'Actl6b Ambra1 Arhgef7 Bhlhe22 Btbd3 C77370 Camk1d Camk2b Ccdc64 Chl1 Chn1 Cplx2 Crmp1 D130043K22Rik Dab1 Dbn1 Dcc Dlg3 Dpf1 Dscaml1 Elavl3 Enc1 Epha4 Epha7 Ephb2 Fgf13 Gap43 Gas7 Gsk3a Igsf9b Islr2 Itga8 Kalrn Kdm7a L1cam Lmtk2 Map1b Map1s Mark4 Mbd5 Mdga1 Mef2d Myt1 Myt1l Nav1 Neurod1 Neurod2 Neurod6 Nlgn1 Npas4 Nptn Nrn1 Ntng2 Ntrk3 Numbl Olfm1 Pcdh19 Pcdh8 Plxna4 Rapgef2 Rbfox1 Robo1 Sarm1 Scn2a Sema3e Sema5a Setx Shank1 Slit1 Slit2 Slit3 Vps13a', symbol_set=set([u'Pcdh8', u'Dscaml1', u'Robo1', u'Kalrn', u'Shank1', u'C77370', u'Gsk3a', u'Camk2b', u'Chl1', u'Dpf1', 'Kdm7a', u'Crmp1', u'Igsf9b', u'Dab1', u'Pcdh19', u'Vps13a', u'Islr2', u'Btbd3', u'Lmtk2', u'Cplx2', 'Map1b', u'Ntng2', u'Rbfox1', u'Nlgn1', u'Epha7', u'Epha4', u'Dcc', u'Nav1', u'Olfm1', 'Map1s', u'Rapgef2', u'Enc1', u'Arhgef7', u'Fgf13', u'Mbd5', u'Npas4', u'Ambra1', u'Neurod2', u'Dbn1', u'Neurod1', u'Nptn', u'Camk1d', u'Nrn1', u'Mef2d', u'Elavl3', u'Ntrk3', u'Mark4', 'Scn2a', u'Slit3', u'Slit2', u'Slit1', u'Myt1l', u'Setx', u'D130043K22Rik', u'Ephb2', u'Ccdc64', u'Dlg3', u'Sema3e', u'Gap43', u'Sema5a', u'Neurod6', u'Bhlhe22', u'Itga8', u'Plxna4', u'Mdga1', u'Actl6b', u'L1cam', u'Numbl', u'Chn1', u'Sarm1', u'Gas7', u'Myt1']), geneids='ENSMUSG00000061911 ENSMUSG00000006711 ENSMUSG00000052727 ENSMUSG00000063887 ENSMUSG00000062232 ENSMUSG00000063531 ENSMUSG00000039145 ENSMUSG00000038255 ENSMUSG00000042599 ENSMUSG00000038970 ENSMUSG00000051323 ENSMUSG00000028289 ENSMUSG00000029712 ENSMUSG00000057897 ENSMUSG00000028519 ENSMUSG00000028664 ENSMUSG00000000881 ENSMUSG00000032087 ENSMUSG00000051243 ENSMUSG00000030397 ENSMUSG00000008658 ENSMUSG00000060534 ENSMUSG00000046230 ENSMUSG00000061751 ENSMUSG00000075318 ENSMUSG00000029121 ENSMUSG00000037984 ENSMUSG00000059146 ENSMUSG00000032336 ENSMUSG00000041609 ENSMUSG00000045903 ENSMUSG00000035513 ENSMUSG00000056427 ENSMUSG00000025867 ENSMUSG00000031391 ENSMUSG00000031137 ENSMUSG00000009418 ENSMUSG00000029765 ENSMUSG00000026833 ENSMUSG00000057177 ENSMUSG00000026768 ENSMUSG00000019261 ENSMUSG00000001419 ENSMUSG00000025020 ENSMUSG00000036422 ENSMUSG00000031558 ENSMUSG00000022883 ENSMUSG00000033066 ENSMUSG00000043557 ENSMUSG00000038738 ENSMUSG00000025128 ENSMUSG00000063160 ENSMUSG00000043535 ENSMUSG00000022231 ENSMUSG00000039114 ENSMUSG00000062098 ENSMUSG00000034275 ENSMUSG00000030584 ENSMUSG00000036792 ENSMUSG00000034701 ENSMUSG00000030077 ENSMUSG00000026235 ENSMUSG00000010505 ENSMUSG00000040506 ENSMUSG00000047261 ENSMUSG00000031511 ENSMUSG00000003410 ENSMUSG00000046449 ENSMUSG00000050132 ENSMUSG00000041773 ENSMUSG00000034675 ENSMUSG00000056486', format_txt=1, hdr_idx=1, is_hdrgo=True, is_usrgo=True, hdr1usr01='**', dcnt=0, D1='E', GO_name='nervous system development'),
    Nt(p_uncorrected=0.00021351721224842812, study_count=4, study_n=1139, namespace='biological_process', p_fdr_bh=0.02488460986750719, study_items=set([u'ENSMUSG00000052581', u'ENSMUSG00000022623', u'ENSMUSG00000063887', u'ENSMUSG00000020886']), NS='BP', pop_items=set([u'ENSMUSG00000002985', u'ENSMUSG00000052581', u'ENSMUSG00000022623', u'ENSMUSG00000063887', u'ENSMUSG00000020886']), pop_n=13836, p_sm_bonferroni=1.0, is_obsolete=False, GO='GO:0097113', name='AMPA glutamate receptor clustering', pop_count=5, alt_ids=[], level=7, depth=9, enrichment='e', Cluster='Late Decrease', geneid_set=set([u'ENSMUSG00000052581', u'ENSMUSG00000022623', u'ENSMUSG00000063887', u'ENSMUSG00000020886']), symbols=u'Dlg4 Lrrtm4 Nlgn1 Shank3', symbol_set=set([u'Lrrtm4', u'Shank3', u'Dlg4', u'Nlgn1']), geneids='ENSMUSG00000052581 ENSMUSG00000063887 ENSMUSG00000022623 ENSMUSG00000020886', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=0, D1='BCGH', GO_name='AMPA glutamate receptor clustering'),
    Nt(p_uncorrected=1.1115181702075764e-05, study_count=4, study_n=1139, namespace='biological_process', p_fdr_bh=0.0019812484466841165, study_items=set([u'ENSMUSG00000071723', u'ENSMUSG00000016349', u'ENSMUSG00000060679', u'ENSMUSG00000032563']), NS='BP', pop_items=set([u'ENSMUSG00000021666', u'ENSMUSG00000000355', u'ENSMUSG00000020460', u'ENSMUSG00000045128', u'ENSMUSG00000028029', u'ENSMUSG00000061787', u'ENSMUSG00000024079', u'ENSMUSG00000037805', u'ENSMUSG00000003970', u'ENSMUSG00000020514', u'ENSMUSG00000005610', u'ENSMUSG00000021266', u'ENSMUSG00000046756', u'ENSMUSG00000057561', u'ENSMUSG00000029610', u'ENSMUSG00000026887', u'ENSMUSG00000028107', u'ENSMUSG00000028936', u'ENSMUSG00000060679', u'ENSMUSG00000047215', u'ENSMUSG00000027170', u'ENSMUSG00000039221', u'ENSMUSG00000049517', u'ENSMUSG00000022241', u'ENSMUSG00000034892', u'ENSMUSG00000007029', u'ENSMUSG00000019774', u'ENSMUSG00000027374', u'ENSMUSG00000054312', u'ENSMUSG00000023939', u'ENSMUSG00000023938', u'ENSMUSG00000068739', u'ENSMUSG00000020372', u'ENSMUSG00000008668', u'ENSMUSG00000015672', u'ENSMUSG00000058655', u'ENSMUSG00000026709', u'ENSMUSG00000023106', u'ENSMUSG00000028234', u'ENSMUSG00000022792', u'ENSMUSG00000024683', u'ENSMUSG00000034729', u'ENSMUSG00000024360', u'ENSMUSG00000039001', u'ENSMUSG00000042426', u'ENSMUSG00000044533', u'ENSMUSG00000030611', u'ENSMUSG00000028622', u'ENSMUSG00000022312', u'ENSMUSG00000025290', u'ENSMUSG00000056076', u'ENSMUSG00000030871', u'ENSMUSG00000074656', u'ENSMUSG00000034880', u'ENSMUSG00000026254', u'ENSMUSG00000030879', u'ENSMUSG00000021116', u'ENSMUSG00000035530', u'ENSMUSG00000019763', u'ENSMUSG00000029208', u'ENSMUSG00000012405', u'ENSMUSG00000064339', u'ENSMUSG00000020459', u'ENSMUSG00000057388', u'ENSMUSG00000031167', u'ENSMUSG00000029536', u'ENSMUSG00000055762', u'ENSMUSG00000001380', u'ENSMUSG00000021420', u'ENSMUSG00000038563', u'ENSMUSG00000016554', u'ENSMUSG00000027810', u'ENSMUSG00000003299', u'ENSMUSG00000004561', u'ENSMUSG00000058558', u'ENSMUSG00000040952', u'ENSMUSG00000030045', u'ENSMUSG00000025208', u'ENSMUSG00000024608', u'ENSMUSG00000045983', u'ENSMUSG00000027422', u'ENSMUSG00000032563', u'ENSMUSG00000001707', u'ENSMUSG00000021967', u'ENSMUSG00000079641', u'ENSMUSG00000032399', u'ENSMUSG00000024436', u'ENSMUSG00000031960', u'ENSMUSG00000021607', u'ENSMUSG00000028140', u'ENSMUSG00000036781', u'ENSMUSG00000050192', u'ENSMUSG00000070699', u'ENSMUSG00000028156', u'ENSMUSG00000003808', u'ENSMUSG00000018858', u'ENSMUSG00000059070', u'ENSMUSG00000062203', u'ENSMUSG00000018995', u'ENSMUSG00000033845', u'ENSMUSG00000023723', u'ENSMUSG00000028798', u'ENSMUSG00000024829', u'ENSMUSG00000078812', u'ENSMUSG00000043572', u'ENSMUSG00000073838', u'ENSMUSG00000071644', u'ENSMUSG00000063457', u'ENSMUSG00000016349', u'ENSMUSG00000029388', u'ENSMUSG00000040731', u'ENSMUSG00000046330', u'ENSMUSG00000028081', u'ENSMUSG00000016510', u'ENSMUSG00000028085', u'ENSMUSG00000028898', u'ENSMUSG00000034211', u'ENSMUSG00000006941', u'ENSMUSG00000075528', u'ENSMUSG00000022336', u'ENSMUSG00000026245', u'ENSMUSG00000020122', u'ENSMUSG00000022022', u'ENSMUSG00000093661', u'ENSMUSG00000024587', u'ENSMUSG00000026087', u'ENSMUSG00000060636', u'ENSMUSG00000026615', u'ENSMUSG00000025794', u'ENSMUSG00000026618', u'ENSMUSG00000031029', u'ENSMUSG00000018848', u'ENSMUSG00000024831', u'ENSMUSG00000023967', u'ENSMUSG00000034994', u'ENSMUSG00000004788', u'ENSMUSG00000062647', u'ENSMUSG00000038900', u'ENSMUSG00000028292', u'ENSMUSG00000071415', u'ENSMUSG00000033047', u'ENSMUSG00000026356', u'ENSMUSG00000028861', u'ENSMUSG00000002767', u'ENSMUSG00000053565', u'ENSMUSG00000064337', u'ENSMUSG00000035772', u'ENSMUSG00000030744', u'ENSMUSG00000057841', u'ENSMUSG00000001729', u'ENSMUSG00000029145', u'ENSMUSG00000007338', u'ENSMUSG00000030083', u'ENSMUSG00000059796', u'ENSMUSG00000056228', u'ENSMUSG00000031948', u'ENSMUSG00000039640', u'ENSMUSG00000047635', u'ENSMUSG00000025362', u'ENSMUSG00000022884', u'ENSMUSG00000017404', u'ENSMUSG00000038838', u'ENSMUSG00000059183', u'ENSMUSG00000022889', u'ENSMUSG00000057322', u'ENSMUSG00000004233', u'ENSMUSG00000058267', u'ENSMUSG00000032518', u'ENSMUSG00000026427', u'ENSMUSG00000032215', u'ENSMUSG00000040521', u'ENSMUSG00000003235', u'ENSMUSG00000062997', u'ENSMUSG00000012848', u'ENSMUSG00000059291', u'ENSMUSG00000010755', u'ENSMUSG00000027613', u'ENSMUSG00000040354', u'ENSMUSG00000036850', u'ENSMUSG00000058600', u'ENSMUSG00000019143', u'ENSMUSG00000021731', u'ENSMUSG00000029777', u'ENSMUSG00000037851', u'ENSMUSG00000030335', u'ENSMUSG00000005846', u'ENSMUSG00000020477', u'ENSMUSG00000028760', u'ENSMUSG00000016833', u'ENSMUSG00000043716', u'ENSMUSG00000030432', u'ENSMUSG00000033216', u'ENSMUSG00000035150', u'ENSMUSG00000029486', u'ENSMUSG00000049960', u'ENSMUSG00000037531', u'ENSMUSG00000052962', u'ENSMUSG00000029614', u'ENSMUSG00000024902', u'ENSMUSG00000021282', u'ENSMUSG00000019710', u'ENSMUSG00000019863', u'ENSMUSG00000047675', u'ENSMUSG00000057863', u'ENSMUSG00000003429', u'ENSMUSG00000061477', u'ENSMUSG00000067194', u'ENSMUSG00000037563', u'ENSMUSG00000071723', u'ENSMUSG00000025967', u'ENSMUSG00000074129', u'ENSMUSG00000024493', u'ENSMUSG00000070319', u'ENSMUSG00000024991', u'ENSMUSG00000048758', u'ENSMUSG00000041841', u'ENSMUSG00000026083', u'ENSMUSG00000073702', u'ENSMUSG00000031668', u'ENSMUSG00000006333', u'ENSMUSG00000045948', u'ENSMUSG00000060036', u'ENSMUSG00000046364', u'ENSMUSG00000030515', u'ENSMUSG00000029066', u'ENSMUSG00000029173', u'ENSMUSG00000058546', u'ENSMUSG00000042275', u'ENSMUSG00000031320', u'ENSMUSG00000022370', u'ENSMUSG00000030738', u'ENSMUSG00000001056', u'ENSMUSG00000041453', u'ENSMUSG00000046994', u'ENSMUSG00000019977', u'ENSMUSG00000035202', u'ENSMUSG00000027774', u'ENSMUSG00000063179', u'ENSMUSG00000037742', u'ENSMUSG00000039680', u'ENSMUSG00000028811', u'ENSMUSG00000008682', u'ENSMUSG00000000740', u'ENSMUSG00000024414', u'ENSMUSG00000062006', u'ENSMUSG00000067288']), pop_n=13836, p_sm_bonferroni=0.1684061179681499, is_obsolete=False, GO='GO:0006412', name='translation', pop_count=246, alt_ids=['GO:0006416', 'GO:0006453', 'GO:0043037'], level=5, depth=7, enrichment='p', Cluster='Late Decrease', geneid_set=set([u'ENSMUSG00000071723', u'ENSMUSG00000016349', u'ENSMUSG00000060679', u'ENSMUSG00000032563']), symbols=u'Eef1a2 Gspt2 Mrpl3 Mrps9', symbol_set=set([u'Gspt2', u'Eef1a2', u'Mrpl3', u'Mrps9']), geneids='ENSMUSG00000071723 ENSMUSG00000016349 ENSMUSG00000060679 ENSMUSG00000032563', format_txt=1, hdr_idx=1, is_hdrgo=True, is_usrgo=True, hdr1usr01='**', dcnt=5, D1='BD', GO_name='translation'),
]
