"""GOATOOLS GOEA on 2015 Gjoneska data using go-basic.obo: fmt(1.2) rel(2017-01-12) 47,943 GO Terms"""

# Created: 2017-01-13
import collections as cx

nt_fields = [
    "p_uncorrected",
    "study_count",
    "study_n",
    "namespace",
    "p_fdr_bh",
    "study_items",
    "NS",
    "pop_items",
    "pop_n",
    "p_sm_bonferroni",
    "is_obsolete",
    "GO",
    "name",
    "pop_count",
    "alt_ids",
    "level",
    "depth",
    "enrichment",
    "Cluster",
    "geneid_set",
    "symbols",
    "symbol_set",
    "geneids",
    "format_txt",
    "hdr_idx",
    "is_hdrgo",
    "is_usrgo",
    "hdr1usr01",
    "dcnt",
    "D1",
    "GO_name",
]

Nt = cx.namedtuple("Nt", " ".join(nt_fields))

# 60 items
nts = [
    Nt(p_uncorrected='', study_count='', study_n='', namespace='', p_fdr_bh='', study_items='', NS='BP', pop_items='', pop_n='', p_sm_bonferroni='', is_obsolete='', GO='GO:0042127', name='', pop_count='', alt_ids='', level=4, depth=4, enrichment='', Cluster='', geneid_set='', symbols='', symbol_set='', geneids='', format_txt=1, hdr_idx=1, is_hdrgo=True, is_usrgo=False, hdr1usr01='*', dcnt=271, D1='A', GO_name='regulation of cell proliferation'),
    Nt(p_uncorrected=8.314240949182051e-06, study_count=9, study_n=794, namespace='biological_process', p_fdr_bh=0.0038172443824562806, study_items=set([u'ENSMUSG00000079362', u'ENSMUSG00000040264', u'ENSMUSG00000029298', u'ENSMUSG00000060550', u'ENSMUSG00000028270', u'ENSMUSG00000028268', u'ENSMUSG00000041515', u'ENSMUSG00000073421', u'ENSMUSG00000024411']), NS='BP', pop_items=set([u'ENSMUSG00000040264', u'ENSMUSG00000026712', u'ENSMUSG00000026615', u'ENSMUSG00000021559', u'ENSMUSG00000019122', u'ENSMUSG00000028268', u'ENSMUSG00000031778', u'ENSMUSG00000032423', u'ENSMUSG00000018927', u'ENSMUSG00000035352', u'ENSMUSG00000029298', u'ENSMUSG00000079363', u'ENSMUSG00000079362', u'ENSMUSG00000040253', u'ENSMUSG00000074129', u'ENSMUSG00000028270', u'ENSMUSG00000057666', u'ENSMUSG00000034974', u'ENSMUSG00000073421', u'ENSMUSG00000000982', u'ENSMUSG00000023259', u'ENSMUSG00000035385', u'ENSMUSG00000060550', u'ENSMUSG00000041515', u'ENSMUSG00000018930', u'ENSMUSG00000024411']), pop_n=13836, p_sm_bonferroni=0.12596906462105725, is_obsolete=False, GO='GO:0071346', name='cellular response to interferon-gamma', pop_count=26, alt_ids=[], level=6, depth=6, enrichment='e', Cluster='Consistent Increase', geneid_set=set([u'ENSMUSG00000079362', u'ENSMUSG00000040264', u'ENSMUSG00000024411', u'ENSMUSG00000060550', u'ENSMUSG00000028270', u'ENSMUSG00000028268', u'ENSMUSG00000041515', u'ENSMUSG00000073421', u'ENSMUSG00000029298']), symbols=u'Aqp4 Gbp2 Gbp2b Gbp3 Gbp9 Gm43302 H2-Ab1 H2-Q7 Irf8', symbol_set=set(['Gbp2b', u'Aqp4', u'Gbp3', u'Gbp2', 'H2-Q7', u'Irf8', u'Gbp9', 'Gm43302', 'H2-Ab1']), geneids='ENSMUSG00000060550 ENSMUSG00000040264 ENSMUSG00000079362 ENSMUSG00000024411 ENSMUSG00000028270 ENSMUSG00000028268 ENSMUSG00000041515 ENSMUSG00000073421 ENSMUSG00000029298', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=0, D1='BF', GO_name='cellular response to interferon-gamma'),
    Nt(p_uncorrected=4.231056097074788e-05, study_count=14, study_n=794, namespace='biological_process', p_fdr_bh=0.014617539815196508, study_items=set([u'ENSMUSG00000024927', u'ENSMUSG00000060802', u'ENSMUSG00000035673', u'ENSMUSG00000032372', u'ENSMUSG00000047123', u'ENSMUSG00000030793', u'ENSMUSG00000020638', u'ENSMUSG00000032691', u'ENSMUSG00000056019', u'ENSMUSG00000006728', u'ENSMUSG00000028270', u'ENSMUSG00000018920', u'ENSMUSG00000041515', u'ENSMUSG00000022500']), NS='BP', pop_items=set([u'ENSMUSG00000020889', u'ENSMUSG00000026712', u'ENSMUSG00000034160', u'ENSMUSG00000037992', u'ENSMUSG00000059089', u'ENSMUSG00000028270', u'ENSMUSG00000026842', u'ENSMUSG00000030793', u'ENSMUSG00000020638', u'ENSMUSG00000056019', u'ENSMUSG00000056501', u'ENSMUSG00000026883', u'ENSMUSG00000022500', u'ENSMUSG00000058301', u'ENSMUSG00000003184', u'ENSMUSG00000024927', u'ENSMUSG00000002250', u'ENSMUSG00000042419', u'ENSMUSG00000022194', u'ENSMUSG00000009681', u'ENSMUSG00000003437', u'ENSMUSG00000002602', u'ENSMUSG00000032372', u'ENSMUSG00000032377', u'ENSMUSG00000047123', u'ENSMUSG00000016024', u'ENSMUSG00000018920', u'ENSMUSG00000035385', u'ENSMUSG00000030595', u'ENSMUSG00000026104', u'ENSMUSG00000005583', u'ENSMUSG00000041135', u'ENSMUSG00000021624', u'ENSMUSG00000021699', u'ENSMUSG00000015243', u'ENSMUSG00000022901', u'ENSMUSG00000039217', u'ENSMUSG00000028525', u'ENSMUSG00000002108', u'ENSMUSG00000024789', u'ENSMUSG00000075701', u'ENSMUSG00000034855', u'ENSMUSG00000020399', u'ENSMUSG00000031555', u'ENSMUSG00000020850', u'ENSMUSG00000019461', u'ENSMUSG00000005951', u'ENSMUSG00000006728', u'ENSMUSG00000032369', u'ENSMUSG00000059866', u'ENSMUSG00000060802', u'ENSMUSG00000060803', u'ENSMUSG00000051439', u'ENSMUSG00000035673', u'ENSMUSG00000019850', u'ENSMUSG00000028163', u'ENSMUSG00000024045', u'ENSMUSG00000027164', u'ENSMUSG00000032691', u'ENSMUSG00000020484', u'ENSMUSG00000026234', u'ENSMUSG00000044786', u'ENSMUSG00000005609', u'ENSMUSG00000053436', u'ENSMUSG00000026361', u'ENSMUSG00000021936', u'ENSMUSG00000041515', u'ENSMUSG00000039005', u'ENSMUSG00000034889', u'ENSMUSG00000037411', u'ENSMUSG00000028599']), pop_n=13836, p_sm_bonferroni=0.6410473092678012, is_obsolete=False, GO='GO:0071222', name='cellular response to lipopolysaccharide', pop_count=71, alt_ids=[], level=5, depth=6, enrichment='e', Cluster='Consistent Increase', geneid_set=set([u'ENSMUSG00000024927', u'ENSMUSG00000022500', u'ENSMUSG00000060802', u'ENSMUSG00000035673', u'ENSMUSG00000032372', u'ENSMUSG00000030793', u'ENSMUSG00000047123', u'ENSMUSG00000032691', u'ENSMUSG00000056019', u'ENSMUSG00000006728', u'ENSMUSG00000028270', u'ENSMUSG00000018920', u'ENSMUSG00000041515', u'ENSMUSG00000020638']), symbols=u'B2m Cdk4 Cmpk2 Cxcl16 Gbp2 Irf8 Litaf Nlrp3 Plscr2 Pycard Rela Sbno2 Ticam1 Zfp709', symbol_set=set([u'Sbno2', u'Irf8', u'Plscr2', u'Nlrp3', u'Ticam1', u'Zfp709', u'Gbp2', u'Cmpk2', u'Litaf', u'B2m', u'Cdk4', u'Pycard', u'Rela', u'Cxcl16']), geneids='ENSMUSG00000024927 ENSMUSG00000060802 ENSMUSG00000035673 ENSMUSG00000032372 ENSMUSG00000047123 ENSMUSG00000030793 ENSMUSG00000020638 ENSMUSG00000056019 ENSMUSG00000032691 ENSMUSG00000018920 ENSMUSG00000006728 ENSMUSG00000028270 ENSMUSG00000041515 ENSMUSG00000022500', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=0, D1='BF', GO_name='cellular response to lipopolysaccharide'),
    Nt(p_uncorrected=0.00018831346875026884, study_count=3, study_n=794, namespace='biological_process', p_fdr_bh=0.04322935401568671, study_items=set([u'ENSMUSG00000064210', u'ENSMUSG00000029468', u'ENSMUSG00000029470']), NS='BP', pop_items=set([u'ENSMUSG00000064210', u'ENSMUSG00000029468', u'ENSMUSG00000029470']), pop_n=13836, p_sm_bonferroni=1.0, is_obsolete=False, GO='GO:0035590', name='purinergic nucleotide receptor signaling pathway', pop_count=3, alt_ids=[], level=5, depth=7, enrichment='e', Cluster='Consistent Increase', geneid_set=set([u'ENSMUSG00000064210', u'ENSMUSG00000029468', u'ENSMUSG00000029470']), symbols=u'Ano6 P2rx4 P2rx7', symbol_set=set([u'Ano6', u'P2rx4', u'P2rx7']), geneids='ENSMUSG00000064210 ENSMUSG00000029468 ENSMUSG00000029470', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=1, D1='AB', GO_name='purinergic nucleotide receptor signaling pathway'),
    Nt(p_uncorrected='', study_count='', study_n='', namespace='', p_fdr_bh='', study_items='', NS='BP', pop_items='', pop_n='', p_sm_bonferroni='', is_obsolete='', GO='GO:0019222', name='', pop_count='', alt_ids='', level=3, depth=3, enrichment='', Cluster='', geneid_set='', symbols='', symbol_set='', geneids='', format_txt=1, hdr_idx=1, is_hdrgo=True, is_usrgo=False, hdr1usr01='*', dcnt=3356, D1='A', GO_name='regulation of metabolic process'),
    Nt(p_uncorrected=8.383267349436762e-07, study_count=10, study_n=794, namespace='biological_process', p_fdr_bh=0.0006048327791015066, study_items=set([u'ENSMUSG00000028191', u'ENSMUSG00000026029', u'ENSMUSG00000039304', u'ENSMUSG00000023905', u'ENSMUSG00000021408', u'ENSMUSG00000030793', u'ENSMUSG00000027322', u'ENSMUSG00000027248', u'ENSMUSG00000024778', u'ENSMUSG00000026942']), NS='BP', pop_items=set([u'ENSMUSG00000030339', u'ENSMUSG00000027466', u'ENSMUSG00000023905', u'ENSMUSG00000030793', u'ENSMUSG00000036986', u'ENSMUSG00000026942', u'ENSMUSG00000004446', u'ENSMUSG00000026029', u'ENSMUSG00000053647', u'ENSMUSG00000025507', u'ENSMUSG00000026223', u'ENSMUSG00000026395', u'ENSMUSG00000054499', u'ENSMUSG00000028191', u'ENSMUSG00000021408', u'ENSMUSG00000004637', u'ENSMUSG00000031980', u'ENSMUSG00000010047', u'ENSMUSG00000022781', u'ENSMUSG00000036712', u'ENSMUSG00000031548', u'ENSMUSG00000027322', u'ENSMUSG00000039304', u'ENSMUSG00000027248', u'ENSMUSG00000007655', u'ENSMUSG00000024778']), pop_n=13836, p_sm_bonferroni=0.012701488361131639, is_obsolete=False, GO='GO:2001238', name='positive regulation of extrinsic apoptotic signaling pathway', pop_count=26, alt_ids=[], level=7, depth=9, enrichment='e', Cluster='Consistent Increase', geneid_set=set([u'ENSMUSG00000027322', u'ENSMUSG00000028191', u'ENSMUSG00000026029', u'ENSMUSG00000023905', u'ENSMUSG00000021408', u'ENSMUSG00000030793', u'ENSMUSG00000039304', u'ENSMUSG00000027248', u'ENSMUSG00000024778', u'ENSMUSG00000026942']), symbols=u'Bcl10 Casp8 Fas Pdia3 Pycard Ripk1 Siglec1 Tnfrsf12a Tnfsf10 Traf2', symbol_set=set([u'Traf2', u'Tnfsf10', u'Fas', u'Pdia3', u'Casp8', u'Bcl10', u'Ripk1', u'Pycard', u'Tnfrsf12a', u'Siglec1']), geneids='ENSMUSG00000028191 ENSMUSG00000026029 ENSMUSG00000023905 ENSMUSG00000021408 ENSMUSG00000027322 ENSMUSG00000030793 ENSMUSG00000026942 ENSMUSG00000027248 ENSMUSG00000024778 ENSMUSG00000039304', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=3, D1='A', GO_name='positive regulation of extrinsic apoptotic signaling pathway'),
    Nt(p_uncorrected=3.19461130395962e-05, study_count=24, study_n=794, namespace='biological_process', p_fdr_bh=0.011805257528363953, study_items=set([u'ENSMUSG00000021451', u'ENSMUSG00000063450', u'ENSMUSG00000024397', u'ENSMUSG00000000555', u'ENSMUSG00000023348', u'ENSMUSG00000052593', u'ENSMUSG00000002603', u'ENSMUSG00000024621', u'ENSMUSG00000004056', u'ENSMUSG00000018920', u'ENSMUSG00000020689', u'ENSMUSG00000027087', u'ENSMUSG00000039621', u'ENSMUSG00000040254', u'ENSMUSG00000031740', u'ENSMUSG00000000957', u'ENSMUSG00000030538', u'ENSMUSG00000042228', u'ENSMUSG00000062960', u'ENSMUSG00000024965', u'ENSMUSG00000068748', u'ENSMUSG00000014599', u'ENSMUSG00000017774', u'ENSMUSG00000037926']), NS='BP', pop_items=set([u'ENSMUSG00000022836', u'ENSMUSG00000063531', u'ENSMUSG00000028228', u'ENSMUSG00000025856', u'ENSMUSG00000027985', u'ENSMUSG00000028431', u'ENSMUSG00000038894', u'ENSMUSG00000030110', u'ENSMUSG00000031778', u'ENSMUSG00000026697', u'ENSMUSG00000061353', u'ENSMUSG00000002489', u'ENSMUSG00000035133', u'ENSMUSG00000032035', u'ENSMUSG00000028583', u'ENSMUSG00000021822', u'ENSMUSG00000057969', u'ENSMUSG00000033717', u'ENSMUSG00000020372', u'ENSMUSG00000040254', u'ENSMUSG00000039239', u'ENSMUSG00000000489', u'ENSMUSG00000039936', u'ENSMUSG00000068154', u'ENSMUSG00000039621', u'ENSMUSG00000042228', u'ENSMUSG00000001506', u'ENSMUSG00000024965', u'ENSMUSG00000052353', u'ENSMUSG00000040152', u'ENSMUSG00000014599', u'ENSMUSG00000066551', u'ENSMUSG00000069135', u'ENSMUSG00000025499', u'ENSMUSG00000053475', u'ENSMUSG00000020074', u'ENSMUSG00000028249', u'ENSMUSG00000063450', u'ENSMUSG00000026193', u'ENSMUSG00000021478', u'ENSMUSG00000005672', u'ENSMUSG00000029231', u'ENSMUSG00000037685', u'ENSMUSG00000052593', u'ENSMUSG00000041417', u'ENSMUSG00000028195', u'ENSMUSG00000022150', u'ENSMUSG00000025207', u'ENSMUSG00000032402', u'ENSMUSG00000051675', u'ENSMUSG00000004936', u'ENSMUSG00000040552', u'ENSMUSG00000027087', u'ENSMUSG00000020053', u'ENSMUSG00000062209', u'ENSMUSG00000024101', u'ENSMUSG00000004056', u'ENSMUSG00000023088', u'ENSMUSG00000026836', u'ENSMUSG00000020859', u'ENSMUSG00000034855', u'ENSMUSG00000028466', u'ENSMUSG00000028019', u'ENSMUSG00000045991', u'ENSMUSG00000030774', u'ENSMUSG00000055980', u'ENSMUSG00000020484', u'ENSMUSG00000007613', u'ENSMUSG00000042524', u'ENSMUSG00000024456', u'ENSMUSG00000029816', u'ENSMUSG00000020122', u'ENSMUSG00000030890', u'ENSMUSG00000038777', u'ENSMUSG00000000627', u'ENSMUSG00000026923', u'ENSMUSG00000028064', u'ENSMUSG00000021451', u'ENSMUSG00000000957', u'ENSMUSG00000020828', u'ENSMUSG00000028780', u'ENSMUSG00000027835', u'ENSMUSG00000021224', u'ENSMUSG00000034684', u'ENSMUSG00000030707', u'ENSMUSG00000030805', u'ENSMUSG00000026121', u'ENSMUSG00000002603', u'ENSMUSG00000053647', u'ENSMUSG00000024620', u'ENSMUSG00000024621', u'ENSMUSG00000028864', u'ENSMUSG00000050357', u'ENSMUSG00000021904', u'ENSMUSG00000049107', u'ENSMUSG00000018920', u'ENSMUSG00000004655', u'ENSMUSG00000020659', u'ENSMUSG00000020689', u'ENSMUSG00000022031', u'ENSMUSG00000032135', u'ENSMUSG00000025809', u'ENSMUSG00000029291', u'ENSMUSG00000027695', u'ENSMUSG00000030530', u'ENSMUSG00000030539', u'ENSMUSG00000034974', u'ENSMUSG00000024397', u'ENSMUSG00000002900', u'ENSMUSG00000022607', u'ENSMUSG00000059456', u'ENSMUSG00000028874', u'ENSMUSG00000002580', u'ENSMUSG00000021338', u'ENSMUSG00000017774', u'ENSMUSG00000037926', u'ENSMUSG00000030538', u'ENSMUSG00000061878', u'ENSMUSG00000055723', u'ENSMUSG00000054836', u'ENSMUSG00000068290', u'ENSMUSG00000054693', u'ENSMUSG00000018565', u'ENSMUSG00000054808', u'ENSMUSG00000026864', u'ENSMUSG00000021360', u'ENSMUSG00000045382', u'ENSMUSG00000005534', u'ENSMUSG00000005871', u'ENSMUSG00000005533', u'ENSMUSG00000023348', u'ENSMUSG00000024486', u'ENSMUSG00000068566', u'ENSMUSG00000029648', u'ENSMUSG00000000127', u'ENSMUSG00000036585', u'ENSMUSG00000036106', u'ENSMUSG00000050965', u'ENSMUSG00000048376', u'ENSMUSG00000085795', u'ENSMUSG00000031841', u'ENSMUSG00000032050', u'ENSMUSG00000032359', u'ENSMUSG00000026064', u'ENSMUSG00000027358', u'ENSMUSG00000027111', u'ENSMUSG00000032006', u'ENSMUSG00000045092', u'ENSMUSG00000038264', u'ENSMUSG00000059146', u'ENSMUSG00000000555', u'ENSMUSG00000046761', u'ENSMUSG00000026479', u'ENSMUSG00000001435', u'ENSMUSG00000031740', u'ENSMUSG00000024789', u'ENSMUSG00000016496', u'ENSMUSG00000025586', u'ENSMUSG00000042682', u'ENSMUSG00000062960', u'ENSMUSG00000023951', u'ENSMUSG00000068748', u'ENSMUSG00000001227', u'ENSMUSG00000031955', u'ENSMUSG00000021835', u'ENSMUSG00000024300', u'ENSMUSG00000021936', u'ENSMUSG00000052133']), pop_n=13836, p_sm_bonferroni=0.484015558662922, is_obsolete=False, GO='GO:0030335', name='positive regulation of cell migration', pop_count=168, alt_ids=[], level=6, depth=7, enrichment='e', Cluster='Consistent Increase', geneid_set=set([u'ENSMUSG00000040254', u'ENSMUSG00000021451', u'ENSMUSG00000063450', u'ENSMUSG00000039621', u'ENSMUSG00000024397', u'ENSMUSG00000031740', u'ENSMUSG00000000957', u'ENSMUSG00000030538', u'ENSMUSG00000042228', u'ENSMUSG00000062960', u'ENSMUSG00000024965', u'ENSMUSG00000020689', u'ENSMUSG00000000555', u'ENSMUSG00000023348', u'ENSMUSG00000052593', u'ENSMUSG00000014599', u'ENSMUSG00000002603', u'ENSMUSG00000024621', u'ENSMUSG00000004056', u'ENSMUSG00000018920', u'ENSMUSG00000068748', u'ENSMUSG00000017774', u'ENSMUSG00000037926', u'ENSMUSG00000027087']), symbols=u'Adam17 Aif1 Akt2 Cib1 Csf1 Csf1r Cxcl16 Fermt3 Itga5 Itgav Itgb3 Kdr Lyn Mmp14 Mmp2 Myo1c Prex1 Ptprz1 Sema3d Sema4d Ssh2 Syne2 Tgfb1 Trip6', symbol_set=set([u'Ptprz1', u'Ssh2', u'Trip6', u'Tgfb1', u'Itgb3', u'Csf1', u'Itgav', u'Adam17', u'Syne2', u'Mmp2', u'Aif1', u'Mmp14', u'Prex1', u'Csf1r', u'Fermt3', u'Akt2', u'Sema4d', u'Sema3d', u'Myo1c', u'Itga5', u'Cib1', u'Lyn', u'Kdr', u'Cxcl16']), geneids='ENSMUSG00000021451 ENSMUSG00000063450 ENSMUSG00000024397 ENSMUSG00000000555 ENSMUSG00000023348 ENSMUSG00000052593 ENSMUSG00000002603 ENSMUSG00000024621 ENSMUSG00000004056 ENSMUSG00000018920 ENSMUSG00000068748 ENSMUSG00000027087 ENSMUSG00000039621 ENSMUSG00000040254 ENSMUSG00000031740 ENSMUSG00000000957 ENSMUSG00000030538 ENSMUSG00000042228 ENSMUSG00000062960 ENSMUSG00000024965 ENSMUSG00000020689 ENSMUSG00000014599 ENSMUSG00000017774 ENSMUSG00000037926', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=67, D1='A', GO_name='positive regulation of cell migration'),
    Nt(p_uncorrected=2.6840419359548623e-11, study_count=15, study_n=794, namespace='biological_process', p_fdr_bh=3.893361146121815e-07, study_items=set([u'ENSMUSG00000024349', u'ENSMUSG00000058163', u'ENSMUSG00000043263', u'ENSMUSG00000069874', u'ENSMUSG00000090942', u'ENSMUSG00000040264', u'ENSMUSG00000073489', u'ENSMUSG00000078922', u'ENSMUSG00000020464', u'ENSMUSG00000028270', u'ENSMUSG00000028268', u'ENSMUSG00000078920', u'ENSMUSG00000073555', u'ENSMUSG00000037860', u'ENSMUSG00000069893']), NS='BP', pop_items=set([u'ENSMUSG00000040264', u'ENSMUSG00000020307', u'ENSMUSG00000058163', u'ENSMUSG00000009293', u'ENSMUSG00000078922', u'ENSMUSG00000078920', u'ENSMUSG00000078921', u'ENSMUSG00000036199', u'ENSMUSG00000028268', u'ENSMUSG00000029203', u'ENSMUSG00000073555', u'ENSMUSG00000021494', u'ENSMUSG00000043263', u'ENSMUSG00000039997', u'ENSMUSG00000068329', u'ENSMUSG00000054072', u'ENSMUSG00000026104', u'ENSMUSG00000037860', u'ENSMUSG00000068606', u'ENSMUSG00000018899', u'ENSMUSG00000069874', u'ENSMUSG00000046879', u'ENSMUSG00000073489', u'ENSMUSG00000078853', u'ENSMUSG00000020464', u'ENSMUSG00000028270', u'ENSMUSG00000069893', u'ENSMUSG00000024349', u'ENSMUSG00000034459', u'ENSMUSG00000090942', u'ENSMUSG00000074896']), pop_n=13836, p_sm_bonferroni=4.066591937165212e-07, is_obsolete=False, GO='GO:0035458', name='cellular response to interferon-beta', pop_count=31, alt_ids=[], level=6, depth=6, enrichment='e', Cluster='Consistent Increase', geneid_set=set([u'ENSMUSG00000024349', u'ENSMUSG00000058163', u'ENSMUSG00000043263', u'ENSMUSG00000069874', u'ENSMUSG00000090942', u'ENSMUSG00000040264', u'ENSMUSG00000073489', u'ENSMUSG00000078922', u'ENSMUSG00000020464', u'ENSMUSG00000028270', u'ENSMUSG00000028268', u'ENSMUSG00000078920', u'ENSMUSG00000069893', u'ENSMUSG00000037860', u'ENSMUSG00000073555']), symbols=u'9930111J21Rik1 Aim2 F830016B08Rik Gbp2 Gbp2b Gbp3 Gm4951 Gm5431 Ifi204 Ifi209 Ifi47 Irgm2 Pnpt1 Tgtp1 Tmem173', symbol_set=set(['Gbp2b', u'Gm4951', u'9930111J21Rik1', u'F830016B08Rik', 'Ifi209', u'Gbp3', u'Tgtp1', u'Ifi204', u'Pnpt1', u'Aim2', u'Gbp2', u'Ifi47', u'Gm5431', u'Irgm2', u'Tmem173']), geneids='ENSMUSG00000024349 ENSMUSG00000058163 ENSMUSG00000043263 ENSMUSG00000069874 ENSMUSG00000078920 ENSMUSG00000090942 ENSMUSG00000040264 ENSMUSG00000073489 ENSMUSG00000078922 ENSMUSG00000020464 ENSMUSG00000028270 ENSMUSG00000028268 ENSMUSG00000037860 ENSMUSG00000073555 ENSMUSG00000069893', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=0, D1='BF', GO_name='cellular response to interferon-beta'),
    Nt(p_uncorrected=5.138075067296199e-05, study_count=4, study_n=794, namespace='biological_process', p_fdr_bh=0.015569395068920942, study_items=set([u'ENSMUSG00000058715', u'ENSMUSG00000031838', u'ENSMUSG00000015947', u'ENSMUSG00000061232']), NS='BP', pop_items=set([u'ENSMUSG00000015947', u'ENSMUSG00000059498', u'ENSMUSG00000031838', u'ENSMUSG00000058715', u'ENSMUSG00000061232']), pop_n=13836, p_sm_bonferroni=0.7784697534460471, is_obsolete=False, GO='GO:0042590', name='antigen processing and presentation of exogenous peptide antigen via MHC class I', pop_count=5, alt_ids=[], level=5, depth=5, enrichment='e', Cluster='Consistent Increase', geneid_set=set([u'ENSMUSG00000058715', u'ENSMUSG00000031838', u'ENSMUSG00000015947', u'ENSMUSG00000061232']), symbols=u'Fcer1g Fcgr1 H2-K1 Ifi30', symbol_set=set([u'Fcer1g', u'Fcgr1', u'Ifi30', 'H2-K1']), geneids='ENSMUSG00000015947 ENSMUSG00000031838 ENSMUSG00000058715 ENSMUSG00000061232', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=2, D1='L', GO_name='antigen processing and presentation of exogenous peptide antigen via MHC class I'),
    Nt(p_uncorrected='', study_count='', study_n='', namespace='', p_fdr_bh='', study_items='', NS='BP', pop_items='', pop_n='', p_sm_bonferroni='', is_obsolete='', GO='GO:0007165', name='', pop_count='', alt_ids='', level=2, depth=4, enrichment='', Cluster='', geneid_set='', symbols='', symbol_set='', geneids='', format_txt=1, hdr_idx=1, is_hdrgo=True, is_usrgo=False, hdr1usr01='*', dcnt=724, D1='AB', GO_name='signal transduction'),
    Nt(p_uncorrected='', study_count='', study_n='', namespace='', p_fdr_bh='', study_items='', NS='BP', pop_items='', pop_n='', p_sm_bonferroni='', is_obsolete='', GO='GO:0023051', name='', pop_count='', alt_ids='', level=3, depth=3, enrichment='', Cluster='', geneid_set='', symbols='', symbol_set='', geneids='', format_txt=1, hdr_idx=1, is_hdrgo=True, is_usrgo=False, hdr1usr01='*', dcnt=1395, D1='A', GO_name='regulation of signaling'),
    Nt(p_uncorrected='', study_count='', study_n='', namespace='', p_fdr_bh='', study_items='', NS='BP', pop_items='', pop_n='', p_sm_bonferroni='', is_obsolete='', GO='GO:0008219', name='', pop_count='', alt_ids='', level=3, depth=3, enrichment='', Cluster='', geneid_set='', symbols='', symbol_set='', geneids='', format_txt=1, hdr_idx=1, is_hdrgo=True, is_usrgo=False, hdr1usr01='*', dcnt=107, D1='BC', GO_name='cell death'),
    Nt(p_uncorrected=0.00014711294614682194, study_count=4, study_n=794, namespace='biological_process', p_fdr_bh=0.037148470784508315, study_items=set([u'ENSMUSG00000031101', u'ENSMUSG00000045005', u'ENSMUSG00000026942', u'ENSMUSG00000060802']), NS='BP', pop_items=set([u'ENSMUSG00000032688', u'ENSMUSG00000060802', u'ENSMUSG00000031101', u'ENSMUSG00000027164', u'ENSMUSG00000026942', u'ENSMUSG00000045005']), pop_n=13836, p_sm_bonferroni=1.0, is_obsolete=False, GO='GO:0002726', name='positive regulation of T cell cytokine production', pop_count=6, alt_ids=[], level=7, depth=9, enrichment='e', Cluster='Consistent Increase', geneid_set=set([u'ENSMUSG00000031101', u'ENSMUSG00000045005', u'ENSMUSG00000026942', u'ENSMUSG00000060802']), symbols=u'B2m Fzd5 Sash3 Traf2', symbol_set=set([u'Traf2', u'B2m', u'Sash3', u'Fzd5']), geneids='ENSMUSG00000031101 ENSMUSG00000045005 ENSMUSG00000026942 ENSMUSG00000060802', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=2, D1='A', GO_name='positive regulation of T cell cytokine production'),
    Nt(p_uncorrected='', study_count='', study_n='', namespace='', p_fdr_bh='', study_items='', NS='BP', pop_items='', pop_n='', p_sm_bonferroni='', is_obsolete='', GO='GO:0045595', name='', pop_count='', alt_ids='', level=4, depth=4, enrichment='', Cluster='', geneid_set='', symbols='', symbol_set='', geneids='', format_txt=1, hdr_idx=1, is_hdrgo=True, is_usrgo=False, hdr1usr01='*', dcnt=864, D1='A', GO_name='regulation of cell differentiation'),
    Nt(p_uncorrected=1.1301346989526834e-07, study_count=8, study_n=794, namespace='biological_process', p_fdr_bh=0.00010701669264895065, study_items=set([u'ENSMUSG00000060550', u'ENSMUSG00000073411', u'ENSMUSG00000060802', u'ENSMUSG00000067212', u'ENSMUSG00000035929', u'ENSMUSG00000073409', u'ENSMUSG00000053835', u'ENSMUSG00000061232']), NS='BP', pop_items=set([u'ENSMUSG00000060550', u'ENSMUSG00000073411', u'ENSMUSG00000053835', u'ENSMUSG00000060802', u'ENSMUSG00000024392', u'ENSMUSG00000035929', u'ENSMUSG00000056116', u'ENSMUSG00000079507', u'ENSMUSG00000073409', u'ENSMUSG00000016206', u'ENSMUSG00000067212', u'ENSMUSG00000061232', u'ENSMUSG00000026471']), pop_n=13836, p_sm_bonferroni=0.0017122670823832107, is_obsolete=False, GO='GO:0002474', name='antigen processing and presentation of peptide antigen via MHC class I', pop_count=13, alt_ids=[], level=4, depth=4, enrichment='e', Cluster='Consistent Increase', geneid_set=set([u'ENSMUSG00000073411', u'ENSMUSG00000060802', u'ENSMUSG00000067212', u'ENSMUSG00000035929', u'ENSMUSG00000061232', u'ENSMUSG00000073409', u'ENSMUSG00000053835', u'ENSMUSG00000060550']), symbols=u'B2m H2-D1 H2-K1 H2-Q4 H2-Q6 H2-Q7 H2-T23 H2-T24', symbol_set=set(['H2-K1', 'H2-D1', 'H2-Q4', 'H2-T23', 'H2-Q6', 'H2-T24', u'B2m', 'H2-Q7']), geneids='ENSMUSG00000073411 ENSMUSG00000060802 ENSMUSG00000053835 ENSMUSG00000035929 ENSMUSG00000061232 ENSMUSG00000067212 ENSMUSG00000060550 ENSMUSG00000073409', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=8, D1='L', GO_name='antigen processing and presentation of peptide antigen via MHC class I'),
    Nt(p_uncorrected='', study_count='', study_n='', namespace='', p_fdr_bh='', study_items='', NS='BP', pop_items='', pop_n='', p_sm_bonferroni='', is_obsolete='', GO='GO:0010941', name='', pop_count='', alt_ids='', level=4, depth=4, enrichment='', Cluster='', geneid_set='', symbols='', symbol_set='', geneids='', format_txt=1, hdr_idx=1, is_hdrgo=True, is_usrgo=False, hdr1usr01='*', dcnt=335, D1='A', GO_name='regulation of cell death'),
    Nt(p_uncorrected='', study_count='', study_n='', namespace='', p_fdr_bh='', study_items='', NS='BP', pop_items='', pop_n='', p_sm_bonferroni='', is_obsolete='', GO='GO:0033993', name='', pop_count='', alt_ids='', level=4, depth=4, enrichment='', Cluster='', geneid_set='', symbols='', symbol_set='', geneids='', format_txt=1, hdr_idx=1, is_hdrgo=True, is_usrgo=False, hdr1usr01='*', dcnt=125, D1='F', GO_name='response to lipid'),
    Nt(p_uncorrected=1.263279135958711e-06, study_count=10, study_n=794, namespace='biological_process', p_fdr_bh=0.0008321713995178447, study_items=set([u'ENSMUSG00000024927', u'ENSMUSG00000025888', u'ENSMUSG00000029468', u'ENSMUSG00000027995', u'ENSMUSG00000030793', u'ENSMUSG00000015947', u'ENSMUSG00000019810', u'ENSMUSG00000026433', u'ENSMUSG00000015950', u'ENSMUSG00000041515']), NS='BP', pop_items=set([u'ENSMUSG00000055447', u'ENSMUSG00000070034', u'ENSMUSG00000026656', u'ENSMUSG00000027684', u'ENSMUSG00000030793', u'ENSMUSG00000025372', u'ENSMUSG00000029468', u'ENSMUSG00000024927', u'ENSMUSG00000019804', u'ENSMUSG00000003184', u'ENSMUSG00000015947', u'ENSMUSG00000026433', u'ENSMUSG00000026104', u'ENSMUSG00000039005', u'ENSMUSG00000029684', u'ENSMUSG00000020525', u'ENSMUSG00000015478', u'ENSMUSG00000025888', u'ENSMUSG00000051439', u'ENSMUSG00000027995', u'ENSMUSG00000045827', u'ENSMUSG00000026177', u'ENSMUSG00000019810', u'ENSMUSG00000015950', u'ENSMUSG00000041515', u'ENSMUSG00000007655', u'ENSMUSG00000032041']), pop_n=13836, p_sm_bonferroni=0.01913994218891043, is_obsolete=False, GO='GO:0009617', name='response to bacterium', pop_count=27, alt_ids=['GO:0009618', 'GO:0009680'], level=5, depth=5, enrichment='e', Cluster='Consistent Increase', geneid_set=set([u'ENSMUSG00000024927', u'ENSMUSG00000025888', u'ENSMUSG00000029468', u'ENSMUSG00000027995', u'ENSMUSG00000030793', u'ENSMUSG00000015947', u'ENSMUSG00000019810', u'ENSMUSG00000026433', u'ENSMUSG00000015950', u'ENSMUSG00000041515']), symbols=u'Casp1 Fcgr1 Fuca2 Irf8 Ncf1 P2rx7 Pycard Rab29 Rela Tlr2', symbol_set=set([u'Ncf1', u'Casp1', 'Rab29', u'Irf8', u'Tlr2', u'P2rx7', u'Pycard', u'Rela', u'Fuca2', u'Fcgr1']), geneids='ENSMUSG00000024927 ENSMUSG00000025888 ENSMUSG00000029468 ENSMUSG00000027995 ENSMUSG00000030793 ENSMUSG00000015947 ENSMUSG00000019810 ENSMUSG00000026433 ENSMUSG00000015950 ENSMUSG00000041515', format_txt=1, hdr_idx=1, is_hdrgo=True, is_usrgo=True, hdr1usr01='**', dcnt=12, D1='F', GO_name='response to bacterium'),
    Nt(p_uncorrected='', study_count='', study_n='', namespace='', p_fdr_bh='', study_items='', NS='BP', pop_items='', pop_n='', p_sm_bonferroni='', is_obsolete='', GO='GO:0001816', name='', pop_count='', alt_ids='', level=3, depth=3, enrichment='', Cluster='', geneid_set='', symbols='', symbol_set='', geneids='', format_txt=1, hdr_idx=1, is_hdrgo=True, is_usrgo=False, hdr1usr01='*', dcnt=110, D1='CJ', GO_name='cytokine production'),
    Nt(p_uncorrected=8.063864985346781e-05, study_count=10, study_n=794, namespace='biological_process', p_fdr_bh=0.022625114517220202, study_items=set([u'ENSMUSG00000025492', u'ENSMUSG00000045322', u'ENSMUSG00000053175', u'ENSMUSG00000029826', u'ENSMUSG00000040725', u'ENSMUSG00000032690', u'ENSMUSG00000031639', u'ENSMUSG00000052776', u'ENSMUSG00000037921', u'ENSMUSG00000020075']), NS='BP', pop_items=set([u'ENSMUSG00000032661', u'ENSMUSG00000023341', u'ENSMUSG00000045322', u'ENSMUSG00000007659', u'ENSMUSG00000027951', u'ENSMUSG00000070583', u'ENSMUSG00000046718', u'ENSMUSG00000026469', u'ENSMUSG00000031639', u'ENSMUSG00000041827', u'ENSMUSG00000010051', u'ENSMUSG00000032508', u'ENSMUSG00000053175', u'ENSMUSG00000079017', u'ENSMUSG00000029826', u'ENSMUSG00000040725', u'ENSMUSG00000033777', u'ENSMUSG00000052776', u'ENSMUSG00000026896', u'ENSMUSG00000039236', u'ENSMUSG00000017830', u'ENSMUSG00000024079', u'ENSMUSG00000060591', u'ENSMUSG00000029561', u'ENSMUSG00000029605', u'ENSMUSG00000008683', u'ENSMUSG00000010047', u'ENSMUSG00000025492', u'ENSMUSG00000030421', u'ENSMUSG00000034459', u'ENSMUSG00000020075', u'ENSMUSG00000000787', u'ENSMUSG00000027770', u'ENSMUSG00000040296', u'ENSMUSG00000032690', u'ENSMUSG00000020641', u'ENSMUSG00000051451', u'ENSMUSG00000045932', u'ENSMUSG00000037921', u'ENSMUSG00000037149', u'ENSMUSG00000000386']), pop_n=13836, p_sm_bonferroni=1.0, is_obsolete=False, GO='GO:0009615', name='response to virus', pop_count=41, alt_ids=[], level=5, depth=5, enrichment='e', Cluster='Consistent Increase', geneid_set=set([u'ENSMUSG00000025492', u'ENSMUSG00000045322', u'ENSMUSG00000053175', u'ENSMUSG00000029826', u'ENSMUSG00000040725', u'ENSMUSG00000032690', u'ENSMUSG00000031639', u'ENSMUSG00000052776', u'ENSMUSG00000037921', u'ENSMUSG00000020075']), symbols=u'Bcl3 Ddx21 Ddx60 Hnrnpul1 Ifitm3 Oas1a Oas2 Tlr3 Tlr9 Zc3hav1', symbol_set=set([u'Ifitm3', u'Ddx21', u'Bcl3', u'Tlr3', u'Oas2', u'Zc3hav1', u'Ddx60', u'Oas1a', u'Tlr9', u'Hnrnpul1']), geneids='ENSMUSG00000025492 ENSMUSG00000045322 ENSMUSG00000053175 ENSMUSG00000029826 ENSMUSG00000032690 ENSMUSG00000040725 ENSMUSG00000031639 ENSMUSG00000052776 ENSMUSG00000037921 ENSMUSG00000020075', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=13, D1='F', GO_name='response to virus'),
    Nt(p_uncorrected='', study_count='', study_n='', namespace='', p_fdr_bh='', study_items='', NS='BP', pop_items='', pop_n='', p_sm_bonferroni='', is_obsolete='', GO='GO:0002682', name='', pop_count='', alt_ids='', level=3, depth=3, enrichment='', Cluster='', geneid_set='', symbols='', symbol_set='', geneids='', format_txt=1, hdr_idx=1, is_hdrgo=True, is_usrgo=False, hdr1usr01='*', dcnt=1201, D1='A', GO_name='regulation of immune system process'),
    Nt(p_uncorrected=0.00011413256783345521, study_count=7, study_n=794, namespace='biological_process', p_fdr_bh=0.030878973843654997, study_items=set([u'ENSMUSG00000027852', u'ENSMUSG00000053175', u'ENSMUSG00000031101', u'ENSMUSG00000030793', u'ENSMUSG00000022952', u'ENSMUSG00000041515', u'ENSMUSG00000045005']), NS='BP', pop_items=set([u'ENSMUSG00000025980', u'ENSMUSG00000027852', u'ENSMUSG00000022967', u'ENSMUSG00000053175', u'ENSMUSG00000039217', u'ENSMUSG00000025499', u'ENSMUSG00000031101', u'ENSMUSG00000028525', u'ENSMUSG00000030793', u'ENSMUSG00000020399', u'ENSMUSG00000050357', u'ENSMUSG00000026177', u'ENSMUSG00000041135', u'ENSMUSG00000022952', u'ENSMUSG00000016206', u'ENSMUSG00000021994', u'ENSMUSG00000041515', u'ENSMUSG00000045005', u'ENSMUSG00000051439', u'ENSMUSG00000042817', u'ENSMUSG00000039005']), pop_n=13836, p_sm_bonferroni=1.0, is_obsolete=False, GO='GO:0032729', name='positive regulation of interferon-gamma production', pop_count=21, alt_ids=[], level=6, depth=6, enrichment='e', Cluster='Consistent Increase', geneid_set=set([u'ENSMUSG00000027852', u'ENSMUSG00000022952', u'ENSMUSG00000053175', u'ENSMUSG00000031101', u'ENSMUSG00000045005', u'ENSMUSG00000041515', u'ENSMUSG00000030793']), symbols=u'Bcl3 Fzd5 Irf8 Nras Pycard Runx1 Sash3', symbol_set=set([u'Fzd5', u'Irf8', u'Nras', u'Runx1', u'Pycard', u'Sash3', u'Bcl3']), geneids='ENSMUSG00000027852 ENSMUSG00000053175 ENSMUSG00000031101 ENSMUSG00000030793 ENSMUSG00000022952 ENSMUSG00000041515 ENSMUSG00000045005', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=2, D1='A', GO_name='positive regulation of interferon-gamma production'),
    Nt(p_uncorrected=0.00018720354472778378, study_count=9, study_n=794, namespace='biological_process', p_fdr_bh=0.04322935401568671, study_items=set([u'ENSMUSG00000028191', u'ENSMUSG00000022346', u'ENSMUSG00000030793', u'ENSMUSG00000032691', u'ENSMUSG00000039304', u'ENSMUSG00000038058', u'ENSMUSG00000029249', u'ENSMUSG00000007815', u'ENSMUSG00000024778']), NS='BP', pop_items=set([u'ENSMUSG00000035199', u'ENSMUSG00000020366', u'ENSMUSG00000002015', u'ENSMUSG00000021576', u'ENSMUSG00000021559', u'ENSMUSG00000030793', u'ENSMUSG00000027381', u'ENSMUSG00000036199', u'ENSMUSG00000019997', u'ENSMUSG00000029249', u'ENSMUSG00000027282', u'ENSMUSG00000024959', u'ENSMUSG00000020349', u'ENSMUSG00000022556', u'ENSMUSG00000022346', u'ENSMUSG00000053647', u'ENSMUSG00000068329', u'ENSMUSG00000071369', u'ENSMUSG00000048376', u'ENSMUSG00000020063', u'ENSMUSG00000018909', u'ENSMUSG00000034485', u'ENSMUSG00000028191', u'ENSMUSG00000028195', u'ENSMUSG00000026834', u'ENSMUSG00000019054', u'ENSMUSG00000024947', u'ENSMUSG00000030417', u'ENSMUSG00000026181', u'ENSMUSG00000037787', u'ENSMUSG00000000787', u'ENSMUSG00000066643', u'ENSMUSG00000032691', u'ENSMUSG00000039304', u'ENSMUSG00000038058', u'ENSMUSG00000007815', u'ENSMUSG00000024778']), pop_n=13836, p_sm_bonferroni=1.0, is_obsolete=False, GO='GO:0043280', name='positive regulation of cysteine-type endopeptidase activity involved in apoptotic process', pop_count=37, alt_ids=[], level=8, depth=12, enrichment='e', Cluster='Consistent Increase', geneid_set=set([u'ENSMUSG00000028191', u'ENSMUSG00000022346', u'ENSMUSG00000030793', u'ENSMUSG00000032691', u'ENSMUSG00000039304', u'ENSMUSG00000038058', u'ENSMUSG00000029249', u'ENSMUSG00000007815', u'ENSMUSG00000024778']), symbols=u'Bcl10 Fas Myc Nlrp3 Nod1 Pycard Rest Rhoa Tnfsf10', symbol_set=set([u'Tnfsf10', u'Nlrp3', u'Fas', u'Rest', u'Rhoa', u'Nod1', u'Pycard', u'Myc', u'Bcl10']), geneids='ENSMUSG00000028191 ENSMUSG00000022346 ENSMUSG00000030793 ENSMUSG00000032691 ENSMUSG00000039304 ENSMUSG00000038058 ENSMUSG00000029249 ENSMUSG00000007815 ENSMUSG00000024778', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=7, D1='A', GO_name='positive regulation of cysteine-type endopeptidase activity involved in apoptotic process'),
    Nt(p_uncorrected='', study_count='', study_n='', namespace='', p_fdr_bh='', study_items='', NS='BP', pop_items='', pop_n='', p_sm_bonferroni='', is_obsolete='', GO='GO:0022610', name='', pop_count='', alt_ids='', level=1, depth=1, enrichment='', Cluster='', geneid_set='', symbols='', symbol_set='', geneids='', format_txt=1, hdr_idx=1, is_hdrgo=True, is_usrgo=False, hdr1usr01='*', dcnt=127, D1='P', GO_name='biological adhesion'),
    Nt(p_uncorrected=9.359622790877207e-05, study_count=17, study_n=794, namespace='biological_process', p_fdr_bh=0.025783208164469194, study_items=set([u'ENSMUSG00000024927', u'ENSMUSG00000022178', u'ENSMUSG00000029826', u'ENSMUSG00000026029', u'ENSMUSG00000045322', u'ENSMUSG00000021408', u'ENSMUSG00000000275', u'ENSMUSG00000047123', u'ENSMUSG00000026749', u'ENSMUSG00000025888', u'ENSMUSG00000002233', u'ENSMUSG00000026942', u'ENSMUSG00000038058', u'ENSMUSG00000031639', u'ENSMUSG00000020941', u'ENSMUSG00000022500', u'ENSMUSG00000047098']), NS='BP', pop_items=set([u'ENSMUSG00000067377', u'ENSMUSG00000027466', u'ENSMUSG00000045322', u'ENSMUSG00000059327', u'ENSMUSG00000028108', u'ENSMUSG00000074781', u'ENSMUSG00000022178', u'ENSMUSG00000066406', u'ENSMUSG00000068220', u'ENSMUSG00000000266', u'ENSMUSG00000006932', u'ENSMUSG00000015120', u'ENSMUSG00000037523', u'ENSMUSG00000019843', u'ENSMUSG00000035235', u'ENSMUSG00000026842', u'ENSMUSG00000021408', u'ENSMUSG00000045038', u'ENSMUSG00000031887', u'ENSMUSG00000027397', u'ENSMUSG00000027399', u'ENSMUSG00000025199', u'ENSMUSG00000057367', u'ENSMUSG00000000275', u'ENSMUSG00000037089', u'ENSMUSG00000022255', u'ENSMUSG00000020941', u'ENSMUSG00000038058', u'ENSMUSG00000055762', u'ENSMUSG00000026942', u'ENSMUSG00000025034', u'ENSMUSG00000023826', u'ENSMUSG00000022552', u'ENSMUSG00000026029', u'ENSMUSG00000029826', u'ENSMUSG00000003184', u'ENSMUSG00000047123', u'ENSMUSG00000020134', u'ENSMUSG00000051675', u'ENSMUSG00000031392', u'ENSMUSG00000004394', u'ENSMUSG00000041000', u'ENSMUSG00000059883', u'ENSMUSG00000031155', u'ENSMUSG00000032966', u'ENSMUSG00000002688', u'ENSMUSG00000055204', u'ENSMUSG00000034457', u'ENSMUSG00000041241', u'ENSMUSG00000032570', u'ENSMUSG00000031021', u'ENSMUSG00000053253', u'ENSMUSG00000026596', u'ENSMUSG00000078923', u'ENSMUSG00000031143', u'ENSMUSG00000039713', u'ENSMUSG00000042312', u'ENSMUSG00000031639', u'ENSMUSG00000047098', u'ENSMUSG00000004221', u'ENSMUSG00000032508', u'ENSMUSG00000024425', u'ENSMUSG00000060548', u'ENSMUSG00000041135', u'ENSMUSG00000027699', u'ENSMUSG00000030245', u'ENSMUSG00000028701', u'ENSMUSG00000046668', u'ENSMUSG00000021096', u'ENSMUSG00000057193', u'ENSMUSG00000025888', u'ENSMUSG00000059866', u'ENSMUSG00000025647', u'ENSMUSG00000005413', u'ENSMUSG00000033208', u'ENSMUSG00000026749', u'ENSMUSG00000050953', u'ENSMUSG00000030339', u'ENSMUSG00000037820', u'ENSMUSG00000036299', u'ENSMUSG00000008734', u'ENSMUSG00000022500', u'ENSMUSG00000028284', u'ENSMUSG00000024927', u'ENSMUSG00000028179', u'ENSMUSG00000032688', u'ENSMUSG00000024091', u'ENSMUSG00000022757', u'ENSMUSG00000035798', u'ENSMUSG00000002233', u'ENSMUSG00000039005', u'ENSMUSG00000021701', u'ENSMUSG00000033430', u'ENSMUSG00000036686', u'ENSMUSG00000029060', u'ENSMUSG00000028756', u'ENSMUSG00000028522', u'ENSMUSG00000003099', u'ENSMUSG00000031328', u'ENSMUSG00000027164', u'ENSMUSG00000020921', u'ENSMUSG00000025575', u'ENSMUSG00000052889', u'ENSMUSG00000032041', u'ENSMUSG00000030471']), pop_n=13836, p_sm_bonferroni=1.0, is_obsolete=False, GO='GO:0043123', name='positive regulation of I-kappaB kinase/NF-kappaB signaling', pop_count=105, alt_ids=[], level=7, depth=8, enrichment='e', Cluster='Consistent Increase', geneid_set=set([u'ENSMUSG00000045322', u'ENSMUSG00000021408', u'ENSMUSG00000026942', u'ENSMUSG00000031639', u'ENSMUSG00000022500', u'ENSMUSG00000047098', u'ENSMUSG00000024927', u'ENSMUSG00000022178', u'ENSMUSG00000025888', u'ENSMUSG00000026029', u'ENSMUSG00000029826', u'ENSMUSG00000000275', u'ENSMUSG00000047123', u'ENSMUSG00000026749', u'ENSMUSG00000002233', u'ENSMUSG00000038058', u'ENSMUSG00000020941']), symbols=u'Ajuba Casp1 Casp8 Litaf Map3k14 Nek6 Nod1 Rela Rhoc Ripk1 Rnf31 Ticam1 Tlr3 Tlr9 Traf2 Trim25 Zc3hav1', symbol_set=set([u'Nek6', u'Ticam1', u'Traf2', u'Casp1', u'Trim25', u'Litaf', u'Casp8', u'Ripk1', u'Tlr3', u'Nod1', u'Zc3hav1', u'Rhoc', u'Map3k14', u'Rela', u'Tlr9', 'Ajuba', u'Rnf31']), geneids='ENSMUSG00000024927 ENSMUSG00000022178 ENSMUSG00000025888 ENSMUSG00000026029 ENSMUSG00000045322 ENSMUSG00000021408 ENSMUSG00000000275 ENSMUSG00000047123 ENSMUSG00000026749 ENSMUSG00000002233 ENSMUSG00000026942 ENSMUSG00000029826 ENSMUSG00000031639 ENSMUSG00000020941 ENSMUSG00000022500 ENSMUSG00000047098 ENSMUSG00000038058', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=4, D1='A', GO_name='positive regulation of I-kappaB kinase/NF-kappaB signaling'),
    Nt(p_uncorrected=4.979940413768524e-05, study_count=37, study_n=794, namespace='biological_process', p_fdr_bh=0.015569395068920942, study_items=set([u'ENSMUSG00000034165', u'ENSMUSG00000022831', u'ENSMUSG00000028333', u'ENSMUSG00000004508', u'ENSMUSG00000024927', u'ENSMUSG00000052593', u'ENSMUSG00000028639', u'ENSMUSG00000022346', u'ENSMUSG00000004266', u'ENSMUSG00000030760', u'ENSMUSG00000024621', u'ENSMUSG00000045730', u'ENSMUSG00000021109', u'ENSMUSG00000027506', u'ENSMUSG00000000751', u'ENSMUSG00000025403', u'ENSMUSG00000027087', u'ENSMUSG00000022146', u'ENSMUSG00000056220', u'ENSMUSG00000027947', u'ENSMUSG00000032492', u'ENSMUSG00000006356', u'ENSMUSG00000003283', u'ENSMUSG00000030538', u'ENSMUSG00000027803', u'ENSMUSG00000042228', u'ENSMUSG00000062960', u'ENSMUSG00000029175', u'ENSMUSG00000029838', u'ENSMUSG00000033220', u'ENSMUSG00000004040', u'ENSMUSG00000005373', u'ENSMUSG00000014599', u'ENSMUSG00000026628', u'ENSMUSG00000006728', u'ENSMUSG00000002603', u'ENSMUSG00000037846']), NS='BP', pop_items=set([u'ENSMUSG00000028224', u'ENSMUSG00000014773', u'ENSMUSG00000068154', u'ENSMUSG00000022831', u'ENSMUSG00000030093', u'ENSMUSG00000062604', u'ENSMUSG00000025856', u'ENSMUSG00000001288', u'ENSMUSG00000015994', u'ENSMUSG00000001910', u'ENSMUSG00000019997', u'ENSMUSG00000021342', u'ENSMUSG00000036585', u'ENSMUSG00000018500', u'ENSMUSG00000018501', u'ENSMUSG00000051790', u'ENSMUSG00000002250', u'ENSMUSG00000030849', u'ENSMUSG00000001761', u'ENSMUSG00000018160', u'ENSMUSG00000002489', u'ENSMUSG00000004043', u'ENSMUSG00000030846', u'ENSMUSG00000048376', u'ENSMUSG00000006932', u'ENSMUSG00000032035', u'ENSMUSG00000053110', u'ENSMUSG00000052534', u'ENSMUSG00000070348', u'ENSMUSG00000021732', u'ENSMUSG00000019966', u'ENSMUSG00000021109', u'ENSMUSG00000022770', u'ENSMUSG00000019777', u'ENSMUSG00000016319', u'ENSMUSG00000004266', u'ENSMUSG00000028333', u'ENSMUSG00000027947', u'ENSMUSG00000010797', u'ENSMUSG00000020422', u'ENSMUSG00000032492', u'ENSMUSG00000059146', u'ENSMUSG00000039239', u'ENSMUSG00000000489', u'ENSMUSG00000033417', u'ENSMUSG00000003814', u'ENSMUSG00000025499', u'ENSMUSG00000039662', u'ENSMUSG00000029337', u'ENSMUSG00000031537', u'ENSMUSG00000032397', u'ENSMUSG00000030760', u'ENSMUSG00000031575', u'ENSMUSG00000000561', u'ENSMUSG00000030057', u'ENSMUSG00000007888', u'ENSMUSG00000003228', u'ENSMUSG00000027651', u'ENSMUSG00000000567', u'ENSMUSG00000034724', u'ENSMUSG00000021822', u'ENSMUSG00000056947', u'ENSMUSG00000006398', u'ENSMUSG00000032253', u'ENSMUSG00000024477', u'ENSMUSG00000014599', u'ENSMUSG00000026628', u'ENSMUSG00000004508', u'ENSMUSG00000027087', u'ENSMUSG00000029283', u'ENSMUSG00000059456', u'ENSMUSG00000033940', u'ENSMUSG00000016477', u'ENSMUSG00000059363', u'ENSMUSG00000020074', u'ENSMUSG00000031870', u'ENSMUSG00000061436', u'ENSMUSG00000026672', u'ENSMUSG00000055447', u'ENSMUSG00000013663', u'ENSMUSG00000020362', u'ENSMUSG00000032487', u'ENSMUSG00000013584', u'ENSMUSG00000015709', u'ENSMUSG00000006517', u'ENSMUSG00000028019', u'ENSMUSG00000033208', u'ENSMUSG00000027835', u'ENSMUSG00000018442', u'ENSMUSG00000038894', u'ENSMUSG00000028444', u'ENSMUSG00000005672', u'ENSMUSG00000024913', u'ENSMUSG00000045515', u'ENSMUSG00000052684', u'ENSMUSG00000030283', u'ENSMUSG00000032565', u'ENSMUSG00000045983', u'ENSMUSG00000004473', u'ENSMUSG00000028639', u'ENSMUSG00000037010', u'ENSMUSG00000047146', u'ENSMUSG00000022528', u'ENSMUSG00000029838', u'ENSMUSG00000045730', u'ENSMUSG00000021779', u'ENSMUSG00000019803', u'ENSMUSG00000041498', u'ENSMUSG00000040359', u'ENSMUSG00000054263', u'ENSMUSG00000022010', u'ENSMUSG00000028800', u'ENSMUSG00000027523', u'ENSMUSG00000029053', u'ENSMUSG00000061887', u'ENSMUSG00000027524', u'ENSMUSG00000011179', u'ENSMUSG00000020053', u'ENSMUSG00000062209', u'ENSMUSG00000069135', u'ENSMUSG00000026313', u'ENSMUSG00000030265', u'ENSMUSG00000021175', u'ENSMUSG00000037706', u'ENSMUSG00000020357', u'ENSMUSG00000025358', u'ENSMUSG00000023912', u'ENSMUSG00000003283', u'ENSMUSG00000004791', u'ENSMUSG00000020902', u'ENSMUSG00000034855', u'ENSMUSG00000055254', u'ENSMUSG00000033373', u'ENSMUSG00000027803', u'ENSMUSG00000028397', u'ENSMUSG00000078812', u'ENSMUSG00000067847', u'ENSMUSG00000022540', u'ENSMUSG00000039191', u'ENSMUSG00000030774', u'ENSMUSG00000024997', u'ENSMUSG00000041710', u'ENSMUSG00000001300', u'ENSMUSG00000054693', u'ENSMUSG00000020467', u'ENSMUSG00000061353', u'ENSMUSG00000005373', u'ENSMUSG00000041488', u'ENSMUSG00000030898', u'ENSMUSG00000056481', u'ENSMUSG00000022146', u'ENSMUSG00000020644', u'ENSMUSG00000021974', u'ENSMUSG00000048154', u'ENSMUSG00000020122', u'ENSMUSG00000031393', u'ENSMUSG00000035109', u'ENSMUSG00000031380', u'ENSMUSG00000026923', u'ENSMUSG00000036923', u'ENSMUSG00000021670', u'ENSMUSG00000021756', u'ENSMUSG00000023951', u'ENSMUSG00000024620', u'ENSMUSG00000047945', u'ENSMUSG00000033762', u'ENSMUSG00000028261', u'ENSMUSG00000003031', u'ENSMUSG00000050697', u'ENSMUSG00000042312', u'ENSMUSG00000032185', u'ENSMUSG00000027878', u'ENSMUSG00000017548', u'ENSMUSG00000031723', u'ENSMUSG00000030397', u'ENSMUSG00000050192', u'ENSMUSG00000033249', u'ENSMUSG00000006134', u'ENSMUSG00000010175', u'ENSMUSG00000020919', u'ENSMUSG00000030805', u'ENSMUSG00000024927', u'ENSMUSG00000057342', u'ENSMUSG00000002603', u'ENSMUSG00000087679', u'ENSMUSG00000048001', u'ENSMUSG00000022382', u'ENSMUSG00000024621', u'ENSMUSG00000028864', u'ENSMUSG00000062960', u'ENSMUSG00000026193', u'ENSMUSG00000037992', u'ENSMUSG00000049107', u'ENSMUSG00000034997', u'ENSMUSG00000031314', u'ENSMUSG00000005469', u'ENSMUSG00000022037', u'ENSMUSG00000027506', u'ENSMUSG00000008683', u'ENSMUSG00000038984', u'ENSMUSG00000040152', u'ENSMUSG00000001131', u'ENSMUSG00000024232', u'ENSMUSG00000056220', u'ENSMUSG00000073616', u'ENSMUSG00000059588', u'ENSMUSG00000020235', u'ENSMUSG00000057113', u'ENSMUSG00000034165', u'ENSMUSG00000053647', u'ENSMUSG00000025809', u'ENSMUSG00000028821', u'ENSMUSG00000001435', u'ENSMUSG00000006356', u'ENSMUSG00000033751', u'ENSMUSG00000042228', u'ENSMUSG00000048402', u'ENSMUSG00000031601', u'ENSMUSG00000020063', u'ENSMUSG00000030538', u'ENSMUSG00000044562', u'ENSMUSG00000037846', u'ENSMUSG00000040274', u'ENSMUSG00000061589', u'ENSMUSG00000022607', u'ENSMUSG00000034563', u'ENSMUSG00000057329', u'ENSMUSG00000031548', u'ENSMUSG00000035000', u'ENSMUSG00000020496', u'ENSMUSG00000062312', u'ENSMUSG00000017491', u'ENSMUSG00000020515', u'ENSMUSG00000006728', u'ENSMUSG00000037169', u'ENSMUSG00000022122', u'ENSMUSG00000039781', u'ENSMUSG00000061878', u'ENSMUSG00000026674', u'ENSMUSG00000002731', u'ENSMUSG00000055817', u'ENSMUSG00000044014', u'ENSMUSG00000073889', u'ENSMUSG00000028364', u'ENSMUSG00000007613', u'ENSMUSG00000068290', u'ENSMUSG00000038279', u'ENSMUSG00000008730', u'ENSMUSG00000024795', u'ENSMUSG00000031750', u'ENSMUSG00000043991', u'ENSMUSG00000029287', u'ENSMUSG00000021360', u'ENSMUSG00000005534', u'ENSMUSG00000021994', u'ENSMUSG00000031616', u'ENSMUSG00000022505', u'ENSMUSG00000052957', u'ENSMUSG00000020484', u'ENSMUSG00000032187', u'ENSMUSG00000050335', u'ENSMUSG00000024486', u'ENSMUSG00000022346', u'ENSMUSG00000031446', u'ENSMUSG00000024073', u'ENSMUSG00000076431', u'ENSMUSG00000027985', u'ENSMUSG00000000127', u'ENSMUSG00000063632', u'ENSMUSG00000030525', u'ENSMUSG00000031565', u'ENSMUSG00000021835', u'ENSMUSG00000085795', u'ENSMUSG00000046532', u'ENSMUSG00000038007', u'ENSMUSG00000026104', u'ENSMUSG00000022425', u'ENSMUSG00000032359', u'ENSMUSG00000000751', u'ENSMUSG00000025403', u'ENSMUSG00000027447', u'ENSMUSG00000032725', u'ENSMUSG00000045092', u'ENSMUSG00000034394', u'ENSMUSG00000001517', u'ENSMUSG00000038260', u'ENSMUSG00000029231', u'ENSMUSG00000039153', u'ENSMUSG00000029999', u'ENSMUSG00000026479', u'ENSMUSG00000024789', u'ENSMUSG00000068037', u'ENSMUSG00000038943', u'ENSMUSG00000028291', u'ENSMUSG00000052593', u'ENSMUSG00000031980', u'ENSMUSG00000021379', u'ENSMUSG00000030890', u'ENSMUSG00000042680', u'ENSMUSG00000000184', u'ENSMUSG00000074698', u'ENSMUSG00000028982', u'ENSMUSG00000032006', u'ENSMUSG00000032562', u'ENSMUSG00000029175', u'ENSMUSG00000054387', u'ENSMUSG00000033220', u'ENSMUSG00000057506', u'ENSMUSG00000004040', u'ENSMUSG00000024256', u'ENSMUSG00000054252', u'ENSMUSG00000027859', u'ENSMUSG00000048616', u'ENSMUSG00000062352', u'ENSMUSG00000028249', u'ENSMUSG00000032532', u'ENSMUSG00000007659', u'ENSMUSG00000006333', u'ENSMUSG00000054302', u'ENSMUSG00000018604', u'ENSMUSG00000016308', u'ENSMUSG00000025578']), pop_n=13836, p_sm_bonferroni=0.7545107720900691, is_obsolete=False, GO='GO:0008284', name='positive regulation of cell proliferation', pop_count=322, alt_ids=[], level=5, depth=5, enrichment='e', Cluster='Consistent Increase', geneid_set=set([u'ENSMUSG00000034165', u'ENSMUSG00000022831', u'ENSMUSG00000056220', u'ENSMUSG00000004508', u'ENSMUSG00000024927', u'ENSMUSG00000052593', u'ENSMUSG00000028639', u'ENSMUSG00000022346', u'ENSMUSG00000004266', u'ENSMUSG00000042228', u'ENSMUSG00000024621', u'ENSMUSG00000045730', u'ENSMUSG00000021109', u'ENSMUSG00000027506', u'ENSMUSG00000000751', u'ENSMUSG00000025403', u'ENSMUSG00000027087', u'ENSMUSG00000006728', u'ENSMUSG00000028333', u'ENSMUSG00000027947', u'ENSMUSG00000032492', u'ENSMUSG00000006356', u'ENSMUSG00000003283', u'ENSMUSG00000030538', u'ENSMUSG00000027803', u'ENSMUSG00000030760', u'ENSMUSG00000062960', u'ENSMUSG00000029838', u'ENSMUSG00000029175', u'ENSMUSG00000033220', u'ENSMUSG00000004040', u'ENSMUSG00000005373', u'ENSMUSG00000014599', u'ENSMUSG00000026628', u'ENSMUSG00000022146', u'ENSMUSG00000002603', u'ENSMUSG00000037846']), symbols=u'Acer3 Adam17 Adrb2 Anp32b Atf3 Ccnd3 Cdk4 Cib1 Crip2 Csf1 Csf1r Gab2 Hck Hcls1 Hif1a Il6ra Itgav Kdr Lyn Mlxipl Myc Osmr Pla2g4a Pth1r Ptn Ptpn6 Rac2 Rela Rpa1 Rtkn2 Shmt2 Slc35f6 Stat3 Tgfb1 Tpd52 Wwtr1 Ybx1', symbol_set=set([u'Acer3', 'Slc35f6', u'Rac2', u'Il6ra', u'Ccnd3', u'Gab2', u'Itgav', u'Hcls1', u'Hck', u'Rela', u'Tgfb1', u'Tpd52', u'Rpa1', u'Csf1', u'Hif1a', u'Anp32b', u'Adam17', u'Ybx1', u'Atf3', u'Stat3', u'Wwtr1', u'Rtkn2', u'Csf1r', u'Adrb2', u'Osmr', u'Pla2g4a', u'Lyn', u'Crip2', u'Pth1r', u'Ptn', u'Ptpn6', u'Mlxipl', u'Cib1', u'Cdk4', u'Myc', u'Shmt2', u'Kdr']), geneids='ENSMUSG00000034165 ENSMUSG00000022831 ENSMUSG00000056220 ENSMUSG00000062960 ENSMUSG00000004508 ENSMUSG00000024927 ENSMUSG00000052593 ENSMUSG00000028639 ENSMUSG00000022346 ENSMUSG00000004266 ENSMUSG00000002603 ENSMUSG00000024621 ENSMUSG00000045730 ENSMUSG00000021109 ENSMUSG00000027506 ENSMUSG00000000751 ENSMUSG00000025403 ENSMUSG00000027087 ENSMUSG00000022146 ENSMUSG00000028333 ENSMUSG00000027947 ENSMUSG00000032492 ENSMUSG00000006356 ENSMUSG00000042228 ENSMUSG00000003283 ENSMUSG00000030538 ENSMUSG00000027803 ENSMUSG00000030760 ENSMUSG00000037846 ENSMUSG00000029838 ENSMUSG00000029175 ENSMUSG00000014599 ENSMUSG00000004040 ENSMUSG00000005373 ENSMUSG00000033220 ENSMUSG00000026628 ENSMUSG00000006728', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=88, D1='A', GO_name='positive regulation of cell proliferation'),
    Nt(p_uncorrected=2.149389719025013e-08, study_count=14, study_n=794, namespace='biological_process', p_fdr_bh=2.5050310486883053e-05, study_items=set([u'ENSMUSG00000079227', u'ENSMUSG00000045322', u'ENSMUSG00000026928', u'ENSMUSG00000027995', u'ENSMUSG00000021408', u'ENSMUSG00000030793', u'ENSMUSG00000047123', u'ENSMUSG00000031101', u'ENSMUSG00000038058', u'ENSMUSG00000031639', u'ENSMUSG00000058715', u'ENSMUSG00000030341', u'ENSMUSG00000067212', u'ENSMUSG00000006519']), NS='BP', pop_items=set([u'ENSMUSG00000045322', u'ENSMUSG00000026928', u'ENSMUSG00000031101', u'ENSMUSG00000030793', u'ENSMUSG00000031639', u'ENSMUSG00000058715', u'ENSMUSG00000056529', u'ENSMUSG00000006519', u'ENSMUSG00000041417', u'ENSMUSG00000032508', u'ENSMUSG00000066551', u'ENSMUSG00000047123', u'ENSMUSG00000016024', u'ENSMUSG00000037523', u'ENSMUSG00000035385', u'ENSMUSG00000074582', u'ENSMUSG00000028800', u'ENSMUSG00000019777', u'ENSMUSG00000026234', u'ENSMUSG00000041135', u'ENSMUSG00000067212', u'ENSMUSG00000039005', u'ENSMUSG00000028059', u'ENSMUSG00000000982', u'ENSMUSG00000039217', u'ENSMUSG00000021408', u'ENSMUSG00000027551', u'ENSMUSG00000030341', u'ENSMUSG00000022037', u'ENSMUSG00000024789', u'ENSMUSG00000042682', u'ENSMUSG00000022708', u'ENSMUSG00000051439', u'ENSMUSG00000027995', u'ENSMUSG00000027347', u'ENSMUSG00000001123', u'ENSMUSG00000038058', u'ENSMUSG00000018930', u'ENSMUSG00000079227', u'ENSMUSG00000032041']), pop_n=13836, p_sm_bonferroni=0.0003256540363294797, is_obsolete=False, GO='GO:0032760', name='positive regulation of tumor necrosis factor production', pop_count=40, alt_ids=[], level=7, depth=7, enrichment='e', Cluster='Consistent Increase', geneid_set=set([u'ENSMUSG00000045322', u'ENSMUSG00000026928', u'ENSMUSG00000027995', u'ENSMUSG00000021408', u'ENSMUSG00000030793', u'ENSMUSG00000047123', u'ENSMUSG00000031101', u'ENSMUSG00000038058', u'ENSMUSG00000067212', u'ENSMUSG00000031639', u'ENSMUSG00000058715', u'ENSMUSG00000030341', u'ENSMUSG00000079227', u'ENSMUSG00000006519']), symbols=u'Card9 Ccr5 Cyba Fcer1g H2-T23 Nod1 Pycard Ripk1 Sash3 Ticam1 Tlr2 Tlr3 Tlr9 Tnfrsf1a', symbol_set=set([u'Ripk1', u'Fcer1g', u'Ticam1', 'H2-T23', u'Tnfrsf1a', u'Tlr2', u'Tlr3', u'Card9', u'Cyba', u'Nod1', u'Ccr5', u'Pycard', u'Tlr9', u'Sash3']), geneids='ENSMUSG00000079227 ENSMUSG00000045322 ENSMUSG00000026928 ENSMUSG00000027995 ENSMUSG00000021408 ENSMUSG00000030793 ENSMUSG00000030341 ENSMUSG00000038058 ENSMUSG00000067212 ENSMUSG00000031639 ENSMUSG00000058715 ENSMUSG00000047123 ENSMUSG00000031101 ENSMUSG00000006519', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=2, D1='A', GO_name='positive regulation of tumor necrosis factor production'),
    Nt(p_uncorrected=0.00018831346875026884, study_count=3, study_n=794, namespace='biological_process', p_fdr_bh=0.04322935401568671, study_items=set([u'ENSMUSG00000015947', u'ENSMUSG00000022216', u'ENSMUSG00000079197']), NS='BP', pop_items=set([u'ENSMUSG00000015947', u'ENSMUSG00000022216', u'ENSMUSG00000079197']), pop_n=13836, p_sm_bonferroni=1.0, is_obsolete=False, GO='GO:0019884', name='antigen processing and presentation of exogenous antigen', pop_count=3, alt_ids=[], level=3, depth=3, enrichment='e', Cluster='Consistent Increase', geneid_set=set([u'ENSMUSG00000015947', u'ENSMUSG00000022216', u'ENSMUSG00000079197']), symbols=u'Fcgr1 Psme1 Psme2', symbol_set=set([u'Psme2', u'Fcgr1', u'Psme1']), geneids='ENSMUSG00000015947 ENSMUSG00000022216 ENSMUSG00000079197', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=9, D1='L', GO_name='antigen processing and presentation of exogenous antigen'),
    Nt(p_uncorrected='', study_count='', study_n='', namespace='', p_fdr_bh='', study_items='', NS='BP', pop_items='', pop_n='', p_sm_bonferroni='', is_obsolete='', GO='GO:0034097', name='', pop_count='', alt_ids='', level=4, depth=4, enrichment='', Cluster='', geneid_set='', symbols='', symbol_set='', geneids='', format_txt=1, hdr_idx=1, is_hdrgo=True, is_usrgo=False, hdr1usr01='*', dcnt=59, D1='F', GO_name='response to cytokine'),
    Nt(p_uncorrected=0.00021235432852051886, study_count=5, study_n=794, namespace='biological_process', p_fdr_bh=0.04731441810903502, study_items=set([u'ENSMUSG00000079547', u'ENSMUSG00000058715', u'ENSMUSG00000031838', u'ENSMUSG00000036594', u'ENSMUSG00000073421']), NS='BP', pop_items=set([u'ENSMUSG00000037649', u'ENSMUSG00000031838', u'ENSMUSG00000024610', u'ENSMUSG00000036594', u'ENSMUSG00000027164', u'ENSMUSG00000060586', u'ENSMUSG00000036908', u'ENSMUSG00000026656', u'ENSMUSG00000079547', u'ENSMUSG00000058715', u'ENSMUSG00000073421']), pop_n=13836, p_sm_bonferroni=1.0, is_obsolete=False, GO='GO:0019886', name='antigen processing and presentation of exogenous peptide antigen via MHC class II', pop_count=11, alt_ids=['GO:0042591', 'GO:0048005'], level=5, depth=5, enrichment='e', Cluster='Consistent Increase', geneid_set=set([u'ENSMUSG00000079547', u'ENSMUSG00000058715', u'ENSMUSG00000031838', u'ENSMUSG00000036594', u'ENSMUSG00000073421']), symbols=u'Fcer1g H2-Aa H2-Ab1 H2-DMb1 Ifi30', symbol_set=set(['H2-Ab1', 'H2-DMb1', 'H2-Aa', u'Fcer1g', u'Ifi30']), geneids='ENSMUSG00000079547 ENSMUSG00000058715 ENSMUSG00000031838 ENSMUSG00000036594 ENSMUSG00000073421', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=0, D1='L', GO_name='antigen processing and presentation of exogenous peptide antigen via MHC class II'),
    Nt(p_uncorrected=5.500703269831228e-09, study_count=21, study_n=794, namespace='biological_process', p_fdr_bh=8.334115524121294e-06, study_items=set([u'ENSMUSG00000024927', u'ENSMUSG00000028191', u'ENSMUSG00000038058', u'ENSMUSG00000045322', u'ENSMUSG00000000290', u'ENSMUSG00000002603', u'ENSMUSG00000026321', u'ENSMUSG00000021408', u'ENSMUSG00000000275', u'ENSMUSG00000030793', u'ENSMUSG00000047123', u'ENSMUSG00000079110', u'ENSMUSG00000026942', u'ENSMUSG00000021108', u'ENSMUSG00000031639', u'ENSMUSG00000030538', u'ENSMUSG00000037860', u'ENSMUSG00000032691', u'ENSMUSG00000047098', u'ENSMUSG00000027995', u'ENSMUSG00000039853']), NS='BP', pop_items=set([u'ENSMUSG00000031537', u'ENSMUSG00000035235', u'ENSMUSG00000025034', u'ENSMUSG00000045322', u'ENSMUSG00000074781', u'ENSMUSG00000024079', u'ENSMUSG00000068290', u'ENSMUSG00000030793', u'ENSMUSG00000031639', u'ENSMUSG00000052688', u'ENSMUSG00000026942', u'ENSMUSG00000021180', u'ENSMUSG00000032185', u'ENSMUSG00000023755', u'ENSMUSG00000021994', u'ENSMUSG00000018548', u'ENSMUSG00000047098', u'ENSMUSG00000046532', u'ENSMUSG00000027466', u'ENSMUSG00000024927', u'ENSMUSG00000037405', u'ENSMUSG00000004221', u'ENSMUSG00000032688', u'ENSMUSG00000032508', u'ENSMUSG00000024997', u'ENSMUSG00000029238', u'ENSMUSG00000002603', u'ENSMUSG00000029840', u'ENSMUSG00000000266', u'ENSMUSG00000029287', u'ENSMUSG00000000127', u'ENSMUSG00000047123', u'ENSMUSG00000079110', u'ENSMUSG00000057113', u'ENSMUSG00000027187', u'ENSMUSG00000026778', u'ENSMUSG00000039853', u'ENSMUSG00000021108', u'ENSMUSG00000022037', u'ENSMUSG00000021024', u'ENSMUSG00000037860', u'ENSMUSG00000029053', u'ENSMUSG00000041135', u'ENSMUSG00000060477', u'ENSMUSG00000039005', u'ENSMUSG00000031392', u'ENSMUSG00000028059', u'ENSMUSG00000028191', u'ENSMUSG00000051675', u'ENSMUSG00000028179', u'ENSMUSG00000030265', u'ENSMUSG00000033618', u'ENSMUSG00000021408', u'ENSMUSG00000033430', u'ENSMUSG00000032497', u'ENSMUSG00000022514', u'ENSMUSG00000047921', u'ENSMUSG00000030538', u'ENSMUSG00000002688', u'ENSMUSG00000022255', u'ENSMUSG00000061878', u'ENSMUSG00000025199', u'ENSMUSG00000041343', u'ENSMUSG00000041187', u'ENSMUSG00000026305', u'ENSMUSG00000078923', u'ENSMUSG00000034457', u'ENSMUSG00000026321', u'ENSMUSG00000000290', u'ENSMUSG00000000275', u'ENSMUSG00000027164', u'ENSMUSG00000032691', u'ENSMUSG00000024617', u'ENSMUSG00000026031', u'ENSMUSG00000041000', u'ENSMUSG00000038058', u'ENSMUSG00000037643', u'ENSMUSG00000026171', u'ENSMUSG00000025473', u'ENSMUSG00000052889', u'ENSMUSG00000027995', u'ENSMUSG00000032041', u'ENSMUSG00000038147']), pop_n=13836, p_sm_bonferroni=8.334115524121294e-05, is_obsolete=False, GO='GO:0051092', name='positive regulation of NF-kappaB transcription factor activity', pop_count=83, alt_ids=[], level=5, depth=12, enrichment='e', Cluster='Consistent Increase', geneid_set=set([u'ENSMUSG00000028191', u'ENSMUSG00000021108', u'ENSMUSG00000045322', u'ENSMUSG00000021408', u'ENSMUSG00000030793', u'ENSMUSG00000026942', u'ENSMUSG00000031639', u'ENSMUSG00000030538', u'ENSMUSG00000032691', u'ENSMUSG00000047098', u'ENSMUSG00000039853', u'ENSMUSG00000024927', u'ENSMUSG00000000290', u'ENSMUSG00000002603', u'ENSMUSG00000026321', u'ENSMUSG00000000275', u'ENSMUSG00000047123', u'ENSMUSG00000079110', u'ENSMUSG00000038058', u'ENSMUSG00000037860', u'ENSMUSG00000027995']), symbols=u'Aim2 Bcl10 Capn3 Cib1 Itgb2 Nlrp3 Nod1 Prkch Pycard Rela Ripk1 Rnf31 Tgfb1 Ticam1 Tlr2 Tlr3 Tlr9 Tnfrsf11a Traf2 Trim14 Trim25', symbol_set=set([u'Nod1', u'Prkch', u'Traf2', u'Itgb2', u'Trim14', u'Nlrp3', u'Tgfb1', u'Trim25', u'Tlr2', u'Aim2', u'Ripk1', u'Tlr3', u'Cib1', u'Capn3', u'Tnfrsf11a', u'Pycard', u'Rela', u'Tlr9', u'Bcl10', u'Ticam1', u'Rnf31']), geneids='ENSMUSG00000024927 ENSMUSG00000028191 ENSMUSG00000038058 ENSMUSG00000045322 ENSMUSG00000000290 ENSMUSG00000002603 ENSMUSG00000026321 ENSMUSG00000021408 ENSMUSG00000000275 ENSMUSG00000030793 ENSMUSG00000032691 ENSMUSG00000079110 ENSMUSG00000026942 ENSMUSG00000021108 ENSMUSG00000031639 ENSMUSG00000030538 ENSMUSG00000037860 ENSMUSG00000047123 ENSMUSG00000047098 ENSMUSG00000027995 ENSMUSG00000039853', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=1, D1='A', GO_name='positive regulation of NF-kappaB transcription factor activity'),
    Nt(p_uncorrected=1.2060839744647535e-10, study_count=47, study_n=794, namespace='biological_process', p_fdr_bh=5.120588891920086e-07, study_items=set([u'ENSMUSG00000045322', u'ENSMUSG00000031103', u'ENSMUSG00000026928', u'ENSMUSG00000035279', u'ENSMUSG00000030793', u'ENSMUSG00000070390', u'ENSMUSG00000030966', u'ENSMUSG00000055172', u'ENSMUSG00000031639', u'ENSMUSG00000009585', u'ENSMUSG00000058715', u'ENSMUSG00000047123', u'ENSMUSG00000006519', u'ENSMUSG00000024927', u'ENSMUSG00000043496', u'ENSMUSG00000029826', u'ENSMUSG00000024621', u'ENSMUSG00000031805', u'ENSMUSG00000015947', u'ENSMUSG00000039853', u'ENSMUSG00000025225', u'ENSMUSG00000071203', u'ENSMUSG00000037860', u'ENSMUSG00000036905', u'ENSMUSG00000032312', u'ENSMUSG00000020707', u'ENSMUSG00000072115', u'ENSMUSG00000024349', u'ENSMUSG00000003283', u'ENSMUSG00000033538', u'ENSMUSG00000029217', u'ENSMUSG00000042228', u'ENSMUSG00000036896', u'ENSMUSG00000025492', u'ENSMUSG00000060802', u'ENSMUSG00000029798', u'ENSMUSG00000014599', u'ENSMUSG00000056612', u'ENSMUSG00000027639', u'ENSMUSG00000000275', u'ENSMUSG00000043279', u'ENSMUSG00000032690', u'ENSMUSG00000032691', u'ENSMUSG00000024457', u'ENSMUSG00000038058', u'ENSMUSG00000021423', u'ENSMUSG00000027995']), NS='BP', pop_items=set([u'ENSMUSG00000028099', u'ENSMUSG00000035834', u'ENSMUSG00000045322', u'ENSMUSG00000028874', u'ENSMUSG00000031103', u'ENSMUSG00000021703', u'ENSMUSG00000024079', u'ENSMUSG00000074151', u'ENSMUSG00000016481', u'ENSMUSG00000055172', u'ENSMUSG00000036887', u'ENSMUSG00000009585', u'ENSMUSG00000020455', u'ENSMUSG00000047123', u'ENSMUSG00000022476', u'ENSMUSG00000024371', u'ENSMUSG00000042228', u'ENSMUSG00000000266', u'ENSMUSG00000017707', u'ENSMUSG00000071369', u'ENSMUSG00000026399', u'ENSMUSG00000037523', u'ENSMUSG00000038628', u'ENSMUSG00000020115', u'ENSMUSG00000076617', u'ENSMUSG00000000776', u'ENSMUSG00000019843', u'ENSMUSG00000035235', u'ENSMUSG00000015217', u'ENSMUSG00000028530', u'ENSMUSG00000039236', u'ENSMUSG00000036908', u'ENSMUSG00000024164', u'ENSMUSG00000026842', u'ENSMUSG00000020275', u'ENSMUSG00000024045', u'ENSMUSG00000015340', u'ENSMUSG00000075705', u'ENSMUSG00000025280', u'ENSMUSG00000022791', u'ENSMUSG00000005566', u'ENSMUSG00000026596', u'ENSMUSG00000029605', u'ENSMUSG00000026896', u'ENSMUSG00000025199', u'ENSMUSG00000014599', u'ENSMUSG00000022607', u'ENSMUSG00000030966', u'ENSMUSG00000032312', u'ENSMUSG00000051439', u'ENSMUSG00000038058', u'ENSMUSG00000025512', u'ENSMUSG00000050199', u'ENSMUSG00000026154', u'ENSMUSG00000001366', u'ENSMUSG00000000275', u'ENSMUSG00000027951', u'ENSMUSG00000021326', u'ENSMUSG00000070390', u'ENSMUSG00000036986', u'ENSMUSG00000025139', u'ENSMUSG00000004707', u'ENSMUSG00000025034', u'ENSMUSG00000026883', u'ENSMUSG00000058715', u'ENSMUSG00000032691', u'ENSMUSG00000018446', u'ENSMUSG00000006519', u'ENSMUSG00000027995', u'ENSMUSG00000028885', u'ENSMUSG00000029826', u'ENSMUSG00000027646', u'ENSMUSG00000003184', u'ENSMUSG00000031805', u'ENSMUSG00000016024', u'ENSMUSG00000054072', u'ENSMUSG00000051675', u'ENSMUSG00000037860', u'ENSMUSG00000036905', u'ENSMUSG00000004933', u'ENSMUSG00000031392', u'ENSMUSG00000060591', u'ENSMUSG00000055204', u'ENSMUSG00000041000', u'ENSMUSG00000045932', u'ENSMUSG00000072115', u'ENSMUSG00000033777', u'ENSMUSG00000059883', u'ENSMUSG00000027598', u'ENSMUSG00000003283', u'ENSMUSG00000033124', u'ENSMUSG00000044583', u'ENSMUSG00000002688', u'ENSMUSG00000039853', u'ENSMUSG00000078942', u'ENSMUSG00000078945', u'ENSMUSG00000027639', u'ENSMUSG00000033307', u'ENSMUSG00000034889', u'ENSMUSG00000000787', u'ENSMUSG00000034453', u'ENSMUSG00000020641', u'ENSMUSG00000024457', u'ENSMUSG00000023992', u'ENSMUSG00000025532', u'ENSMUSG00000000386', u'ENSMUSG00000052384', u'ENSMUSG00000070034', u'ENSMUSG00000027427', u'ENSMUSG00000026928', u'ENSMUSG00000035279', u'ENSMUSG00000030793', u'ENSMUSG00000021457', u'ENSMUSG00000074896', u'ENSMUSG00000024948', u'ENSMUSG00000031639', u'ENSMUSG00000020823', u'ENSMUSG00000028041', u'ENSMUSG00000025498', u'ENSMUSG00000032508', u'ENSMUSG00000002602', u'ENSMUSG00000053647', u'ENSMUSG00000053158', u'ENSMUSG00000024621', u'ENSMUSG00000066232', u'ENSMUSG00000036896', u'ENSMUSG00000025225', u'ENSMUSG00000071203', u'ENSMUSG00000030880', u'ENSMUSG00000032175', u'ENSMUSG00000041135', u'ENSMUSG00000014932', u'ENSMUSG00000021624', u'ENSMUSG00000020707', u'ENSMUSG00000017830', u'ENSMUSG00000046879', u'ENSMUSG00000024349', u'ENSMUSG00000033454', u'ENSMUSG00000022514', u'ENSMUSG00000022887', u'ENSMUSG00000023973', u'ENSMUSG00000043496', u'ENSMUSG00000057982', u'ENSMUSG00000036712', u'ENSMUSG00000025492', u'ENSMUSG00000032109', u'ENSMUSG00000060802', u'ENSMUSG00000029798', u'ENSMUSG00000032344', u'ENSMUSG00000059456', u'ENSMUSG00000026117', u'ENSMUSG00000040296', u'ENSMUSG00000032690', u'ENSMUSG00000056851', u'ENSMUSG00000038160', u'ENSMUSG00000022043', u'ENSMUSG00000034317', u'ENSMUSG00000001128', u'ENSMUSG00000029771', u'ENSMUSG00000013707', u'ENSMUSG00000032661', u'ENSMUSG00000038521', u'ENSMUSG00000020399', u'ENSMUSG00000031750', u'ENSMUSG00000046718', u'ENSMUSG00000024927', u'ENSMUSG00000031537', u'ENSMUSG00000024483', u'ENSMUSG00000050335', u'ENSMUSG00000032688', u'ENSMUSG00000026471', u'ENSMUSG00000032905', u'ENSMUSG00000038517', u'ENSMUSG00000023341', u'ENSMUSG00000000127', u'ENSMUSG00000023224', u'ENSMUSG00000015947', u'ENSMUSG00000027514', u'ENSMUSG00000002983', u'ENSMUSG00000039005', u'ENSMUSG00000041827', u'ENSMUSG00000028059', u'ENSMUSG00000054717', u'ENSMUSG00000018899', u'ENSMUSG00000021277', u'ENSMUSG00000024789', u'ENSMUSG00000033538', u'ENSMUSG00000028291', u'ENSMUSG00000029217', u'ENSMUSG00000022575', u'ENSMUSG00000066839', u'ENSMUSG00000029561', u'ENSMUSG00000029915', u'ENSMUSG00000056612', u'ENSMUSG00000044827', u'ENSMUSG00000028163', u'ENSMUSG00000043279', u'ENSMUSG00000026365', u'ENSMUSG00000032322', u'ENSMUSG00000034459', u'ENSMUSG00000039936', u'ENSMUSG00000021423', u'ENSMUSG00000038147', u'ENSMUSG00000050132', u'ENSMUSG00000032041', u'ENSMUSG00000046034']), pop_n=13836, p_sm_bonferroni=1.8273378297115479e-06, is_obsolete=False, GO='GO:0045087', name='innate immune response', pop_count=206, alt_ids=['GO:0002226'], level=3, depth=4, enrichment='e', Cluster='Consistent Increase', geneid_set=set([u'ENSMUSG00000045322', u'ENSMUSG00000031103', u'ENSMUSG00000026928', u'ENSMUSG00000035279', u'ENSMUSG00000030793', u'ENSMUSG00000043279', u'ENSMUSG00000000275', u'ENSMUSG00000055172', u'ENSMUSG00000031639', u'ENSMUSG00000009585', u'ENSMUSG00000058715', u'ENSMUSG00000031805', u'ENSMUSG00000006519', u'ENSMUSG00000024927', u'ENSMUSG00000043496', u'ENSMUSG00000029826', u'ENSMUSG00000024621', u'ENSMUSG00000047123', u'ENSMUSG00000015947', u'ENSMUSG00000036896', u'ENSMUSG00000025225', u'ENSMUSG00000071203', u'ENSMUSG00000037860', u'ENSMUSG00000036905', u'ENSMUSG00000032312', u'ENSMUSG00000020707', u'ENSMUSG00000072115', u'ENSMUSG00000025492', u'ENSMUSG00000003283', u'ENSMUSG00000033538', u'ENSMUSG00000029217', u'ENSMUSG00000042228', u'ENSMUSG00000039853', u'ENSMUSG00000024349', u'ENSMUSG00000060802', u'ENSMUSG00000029798', u'ENSMUSG00000014599', u'ENSMUSG00000056612', u'ENSMUSG00000027639', u'ENSMUSG00000030966', u'ENSMUSG00000070390', u'ENSMUSG00000032690', u'ENSMUSG00000032691', u'ENSMUSG00000024457', u'ENSMUSG00000038058', u'ENSMUSG00000021423', u'ENSMUSG00000027995']), symbols=u'Aim2 Ang Apobec3 B2m C1qb C1qc C1ra Card9 Casp4 Csf1 Csf1r Csk Cyba Elf4 Fcer1g Fcgr1 Hck Herc6 Ifitm3 Jak3 Ly86 Lyn Naip5 Nfkb2 Nlrp1b Nlrp3 Nod1 Oas2 Ppp1r14b Pycard Rela Rnf135 Samhd1 Ssc5d Tec Ticam1 Tlr2 Tlr3 Tlr9 Tmem173 Tril Trim14 Trim21 Trim25 Trim26 Trim56 Zc3hav1', symbol_set=set([u'Ifitm3', u'Casp4', u'Tec', u'Csf1', u'Csk', u'Naip5', u'Aim2', u'Apobec3', u'Card9', u'Hck', u'Pycard', u'Nfkb2', u'Rela', u'Ticam1', u'Trim14', 'Ssc5d', u'C1qc', u'C1qb', u'B2m', u'Oas2', u'Herc6', u'Trim56', u'Ppp1r14b', u'Tmem173', u'Zc3hav1', u'Nlrp3', u'Ly86', u'Csf1r', u'Elf4', u'Tril', u'Fcer1g', u'Ang', u'Samhd1', u'Nlrp1b', u'Trim25', u'Trim26', u'C1ra', u'Trim21', u'Tlr2', u'Tlr3', u'Cyba', u'Nod1', u'Jak3', u'Lyn', u'Tlr9', u'Fcgr1', u'Rnf135']), geneids='ENSMUSG00000045322 ENSMUSG00000031103 ENSMUSG00000026928 ENSMUSG00000035279 ENSMUSG00000030793 ENSMUSG00000070390 ENSMUSG00000030966 ENSMUSG00000055172 ENSMUSG00000031639 ENSMUSG00000009585 ENSMUSG00000058715 ENSMUSG00000047123 ENSMUSG00000006519 ENSMUSG00000024927 ENSMUSG00000043496 ENSMUSG00000029826 ENSMUSG00000024621 ENSMUSG00000031805 ENSMUSG00000015947 ENSMUSG00000039853 ENSMUSG00000025225 ENSMUSG00000071203 ENSMUSG00000037860 ENSMUSG00000036905 ENSMUSG00000032312 ENSMUSG00000020707 ENSMUSG00000072115 ENSMUSG00000025492 ENSMUSG00000003283 ENSMUSG00000033538 ENSMUSG00000029217 ENSMUSG00000042228 ENSMUSG00000036896 ENSMUSG00000024349 ENSMUSG00000060802 ENSMUSG00000027639 ENSMUSG00000014599 ENSMUSG00000027995 ENSMUSG00000029798 ENSMUSG00000000275 ENSMUSG00000043279 ENSMUSG00000032690 ENSMUSG00000032691 ENSMUSG00000024457 ENSMUSG00000038058 ENSMUSG00000021423 ENSMUSG00000056612', format_txt=1, hdr_idx=1, is_hdrgo=True, is_usrgo=True, hdr1usr01='**', dcnt=26, D1='FL', GO_name='innate immune response'),
    Nt(p_uncorrected=3.5146529337187653e-06, study_count=5, study_n=794, namespace='biological_process', p_fdr_bh=0.0017177582773797745, study_items=set([u'ENSMUSG00000032691', u'ENSMUSG00000025888', u'ENSMUSG00000070390', u'ENSMUSG00000030793', u'ENSMUSG00000062210']), NS='BP', pop_items=set([u'ENSMUSG00000025888', u'ENSMUSG00000026471', u'ENSMUSG00000070390', u'ENSMUSG00000030793', u'ENSMUSG00000032691', u'ENSMUSG00000062210']), pop_n=13836, p_sm_bonferroni=0.05325050659877301, is_obsolete=False, GO='GO:0032611', name='interleukin-1 beta production', pop_count=6, alt_ids=[], level=5, depth=5, enrichment='e', Cluster='Consistent Increase', geneid_set=set([u'ENSMUSG00000062210', u'ENSMUSG00000025888', u'ENSMUSG00000070390', u'ENSMUSG00000030793', u'ENSMUSG00000032691']), symbols=u'Casp1 Nlrp1b Nlrp3 Pycard Tnfaip8', symbol_set=set([u'Pycard', u'Nlrp1b', u'Tnfaip8', u'Nlrp3', u'Casp1']), geneids='ENSMUSG00000062210 ENSMUSG00000025888 ENSMUSG00000070390 ENSMUSG00000030793 ENSMUSG00000032691', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=0, D1='CJ', GO_name='interleukin-1 beta production'),
    Nt(p_uncorrected=6.380037801368506e-05, study_count=5, study_n=794, namespace='biological_process', p_fdr_bh=0.01895371622128122, study_items=set([u'ENSMUSG00000037860', u'ENSMUSG00000025888', u'ENSMUSG00000033538', u'ENSMUSG00000070390', u'ENSMUSG00000071203']), NS='BP', pop_items=set([u'ENSMUSG00000078942', u'ENSMUSG00000025888', u'ENSMUSG00000078945', u'ENSMUSG00000070390', u'ENSMUSG00000033538', u'ENSMUSG00000071203', u'ENSMUSG00000010911', u'ENSMUSG00000037860', u'ENSMUSG00000022575']), pop_n=13836, p_sm_bonferroni=0.9666395272853423, is_obsolete=False, GO='GO:0070269', name='pyroptosis', pop_count=9, alt_ids=[], level=5, depth=5, enrichment='e', Cluster='Consistent Increase', geneid_set=set([u'ENSMUSG00000037860', u'ENSMUSG00000025888', u'ENSMUSG00000033538', u'ENSMUSG00000070390', u'ENSMUSG00000071203']), symbols=u'Aim2 Casp1 Casp4 Naip5 Nlrp1b', symbol_set=set([u'Naip5', u'Casp4', u'Casp1', u'Nlrp1b', u'Aim2']), geneids='ENSMUSG00000037860 ENSMUSG00000025888 ENSMUSG00000033538 ENSMUSG00000070390 ENSMUSG00000071203', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=0, D1='BC', GO_name='pyroptosis'),
    Nt(p_uncorrected=4.245077894981495e-05, study_count=6, study_n=794, namespace='biological_process', p_fdr_bh=0.014617539815196508, study_items=set([u'ENSMUSG00000025492', u'ENSMUSG00000069874', u'ENSMUSG00000030966', u'ENSMUSG00000036594', u'ENSMUSG00000078922', u'ENSMUSG00000018920']), NS='BP', pop_items=set([u'ENSMUSG00000025492', u'ENSMUSG00000004069', u'ENSMUSG00000046718', u'ENSMUSG00000069874', u'ENSMUSG00000060591', u'ENSMUSG00000030966', u'ENSMUSG00000025889', u'ENSMUSG00000036594', u'ENSMUSG00000078922', u'ENSMUSG00000026177', u'ENSMUSG00000018920', u'ENSMUSG00000038884', u'ENSMUSG00000060586']), pop_n=13836, p_sm_bonferroni=0.6431717518686463, is_obsolete=False, GO='GO:0034341', name='response to interferon-gamma', pop_count=13, alt_ids=[], level=5, depth=5, enrichment='e', Cluster='Consistent Increase', geneid_set=set([u'ENSMUSG00000078922', u'ENSMUSG00000025492', u'ENSMUSG00000018920', u'ENSMUSG00000069874', u'ENSMUSG00000030966', u'ENSMUSG00000036594']), symbols=u'Cxcl16 H2-Aa Ifitm3 Irgm2 Tgtp1 Trim21', symbol_set=set([u'Ifitm3', u'Tgtp1', 'H2-Aa', u'Trim21', u'Irgm2', u'Cxcl16']), geneids='ENSMUSG00000025492 ENSMUSG00000069874 ENSMUSG00000030966 ENSMUSG00000036594 ENSMUSG00000078922 ENSMUSG00000018920', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=1, D1='F', GO_name='response to interferon-gamma'),
    Nt(p_uncorrected=6.718708756207653e-10, study_count=14, study_n=794, namespace='biological_process', p_fdr_bh=1.6965859394217025e-06, study_items=set([u'ENSMUSG00000024927', u'ENSMUSG00000015396', u'ENSMUSG00000058163', u'ENSMUSG00000002603', u'ENSMUSG00000069874', u'ENSMUSG00000035279', u'ENSMUSG00000030341', u'ENSMUSG00000078920', u'ENSMUSG00000038058', u'ENSMUSG00000031639', u'ENSMUSG00000090942', u'ENSMUSG00000073555', u'ENSMUSG00000079227', u'ENSMUSG00000069893']), NS='BP', pop_items=set([u'ENSMUSG00000029417', u'ENSMUSG00000058163', u'ENSMUSG00000026656', u'ENSMUSG00000035279', u'ENSMUSG00000037321', u'ENSMUSG00000078920', u'ENSMUSG00000078921', u'ENSMUSG00000031639', u'ENSMUSG00000073555', u'ENSMUSG00000024927', u'ENSMUSG00000015396', u'ENSMUSG00000022556', u'ENSMUSG00000061353', u'ENSMUSG00000002603', u'ENSMUSG00000023078', u'ENSMUSG00000027447', u'ENSMUSG00000068606', u'ENSMUSG00000069874', u'ENSMUSG00000046879', u'ENSMUSG00000030120', u'ENSMUSG00000030341', u'ENSMUSG00000078853', u'ENSMUSG00000034855', u'ENSMUSG00000029371', u'ENSMUSG00000069893', u'ENSMUSG00000024610', u'ENSMUSG00000044827', u'ENSMUSG00000090942', u'ENSMUSG00000018819', u'ENSMUSG00000038058', u'ENSMUSG00000079227', u'ENSMUSG00000024308']), pop_n=13836, p_sm_bonferroni=1.0179515636530216e-05, is_obsolete=False, GO='GO:0006952', name='defense response', pop_count=32, alt_ids=['GO:0002217', 'GO:0042829'], level=3, depth=3, enrichment='e', Cluster='Consistent Increase', geneid_set=set([u'ENSMUSG00000024927', u'ENSMUSG00000015396', u'ENSMUSG00000058163', u'ENSMUSG00000002603', u'ENSMUSG00000069874', u'ENSMUSG00000035279', u'ENSMUSG00000030341', u'ENSMUSG00000078920', u'ENSMUSG00000038058', u'ENSMUSG00000031639', u'ENSMUSG00000090942', u'ENSMUSG00000069893', u'ENSMUSG00000079227', u'ENSMUSG00000073555']), symbols=u'9930111J21Rik1 Ccr5 Cd83 F830016B08Rik Gm4951 Gm5431 Ifi47 Irgm2 Nod1 Rela Ssc5d Tgfb1 Tlr3 Tnfrsf1a', symbol_set=set([u'Tgfb1', u'9930111J21Rik1', u'F830016B08Rik', 'Ssc5d', u'Cd83', u'Tnfrsf1a', u'Tlr3', u'Nod1', u'Ccr5', u'Ifi47', u'Gm5431', u'Rela', u'Irgm2', u'Gm4951']), geneids='ENSMUSG00000024927 ENSMUSG00000015396 ENSMUSG00000058163 ENSMUSG00000002603 ENSMUSG00000069874 ENSMUSG00000035279 ENSMUSG00000030341 ENSMUSG00000078920 ENSMUSG00000038058 ENSMUSG00000031639 ENSMUSG00000090942 ENSMUSG00000073555 ENSMUSG00000079227 ENSMUSG00000069893', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=93, D1='F', GO_name='defense response'),
    Nt(p_uncorrected='', study_count='', study_n='', namespace='', p_fdr_bh='', study_items='', NS='BP', pop_items='', pop_n='', p_sm_bonferroni='', is_obsolete='', GO='GO:0006950', name='', pop_count='', alt_ids='', level=2, depth=2, enrichment='', Cluster='', geneid_set='', symbols='', symbol_set='', geneids='', format_txt=1, hdr_idx=1, is_hdrgo=True, is_usrgo=False, hdr1usr01='*', dcnt=491, D1='F', GO_name='response to stress'),
    Nt(p_uncorrected='', study_count='', study_n='', namespace='', p_fdr_bh='', study_items='', NS='BP', pop_items='', pop_n='', p_sm_bonferroni='', is_obsolete='', GO='GO:0098542', name='', pop_count='', alt_ids='', level=4, depth=5, enrichment='', Cluster='', geneid_set='', symbols='', symbol_set='', geneids='', format_txt=1, hdr_idx=1, is_hdrgo=True, is_usrgo=False, hdr1usr01='*', dcnt=37, D1='F', GO_name='defense response to other organism'),
    Nt(p_uncorrected=5.139411452870194e-11, study_count=38, study_n=794, namespace='biological_process', p_fdr_bh=3.893361146121815e-07, study_items=set([u'ENSMUSG00000045322', u'ENSMUSG00000030793', u'ENSMUSG00000070390', u'ENSMUSG00000063415', u'ENSMUSG00000016528', u'ENSMUSG00000031639', u'ENSMUSG00000062585', u'ENSMUSG00000006519', u'ENSMUSG00000024927', u'ENSMUSG00000047557', u'ENSMUSG00000002603', u'ENSMUSG00000043496', u'ENSMUSG00000042286', u'ENSMUSG00000024621', u'ENSMUSG00000047250', u'ENSMUSG00000047123', u'ENSMUSG00000025083', u'ENSMUSG00000025225', u'ENSMUSG00000037731', u'ENSMUSG00000037860', u'ENSMUSG00000027087', u'ENSMUSG00000079227', u'ENSMUSG00000029468', u'ENSMUSG00000071203', u'ENSMUSG00000030341', u'ENSMUSG00000003283', u'ENSMUSG00000033538', u'ENSMUSG00000016495', u'ENSMUSG00000042228', u'ENSMUSG00000052821', u'ENSMUSG00000014599', u'ENSMUSG00000022040', u'ENSMUSG00000009281', u'ENSMUSG00000032691', u'ENSMUSG00000015950', u'ENSMUSG00000021423', u'ENSMUSG00000027995', u'ENSMUSG00000024778']), NS='BP', pop_items=set([u'ENSMUSG00000029199', u'ENSMUSG00000045322', u'ENSMUSG00000028029', u'ENSMUSG00000039145', u'ENSMUSG00000028108', u'ENSMUSG00000016528', u'ENSMUSG00000026883', u'ENSMUSG00000031778', u'ENSMUSG00000029053', u'ENSMUSG00000022475', u'ENSMUSG00000008845', u'ENSMUSG00000040552', u'ENSMUSG00000029371', u'ENSMUSG00000023078', u'ENSMUSG00000075316', u'ENSMUSG00000004698', u'ENSMUSG00000026778', u'ENSMUSG00000020592', u'ENSMUSG00000060477', u'ENSMUSG00000008855', u'ENSMUSG00000024164', u'ENSMUSG00000020275', u'ENSMUSG00000038128', u'ENSMUSG00000015340', u'ENSMUSG00000039936', u'ENSMUSG00000027399', u'ENSMUSG00000042228', u'ENSMUSG00000006445', u'ENSMUSG00000025199', u'ENSMUSG00000000982', u'ENSMUSG00000052821', u'ENSMUSG00000040152', u'ENSMUSG00000014599', u'ENSMUSG00000061762', u'ENSMUSG00000007836', u'ENSMUSG00000066551', u'ENSMUSG00000025512', u'ENSMUSG00000054008', u'ENSMUSG00000024778', u'ENSMUSG00000019850', u'ENSMUSG00000021180', u'ENSMUSG00000032487', u'ENSMUSG00000021680', u'ENSMUSG00000031425', u'ENSMUSG00000025139', u'ENSMUSG00000015839', u'ENSMUSG00000062585', u'ENSMUSG00000056529', u'ENSMUSG00000005672', u'ENSMUSG00000006519', u'ENSMUSG00000028885', u'ENSMUSG00000054509', u'ENSMUSG00000027312', u'ENSMUSG00000047123', u'ENSMUSG00000035352', u'ENSMUSG00000037860', u'ENSMUSG00000035356', u'ENSMUSG00000027087', u'ENSMUSG00000039217', u'ENSMUSG00000033777', u'ENSMUSG00000020400', u'ENSMUSG00000064246', u'ENSMUSG00000027221', u'ENSMUSG00000009281', u'ENSMUSG00000044583', u'ENSMUSG00000023915', u'ENSMUSG00000034855', u'ENSMUSG00000002688', u'ENSMUSG00000061878', u'ENSMUSG00000023913', u'ENSMUSG00000078942', u'ENSMUSG00000032508', u'ENSMUSG00000033307', u'ENSMUSG00000053004', u'ENSMUSG00000003283', u'ENSMUSG00000018476', u'ENSMUSG00000037872', u'ENSMUSG00000079227', u'ENSMUSG00000052384', u'ENSMUSG00000029417', u'ENSMUSG00000042286', u'ENSMUSG00000030793', u'ENSMUSG00000028577', u'ENSMUSG00000019122', u'ENSMUSG00000031639', u'ENSMUSG00000033467', u'ENSMUSG00000029026', u'ENSMUSG00000047557', u'ENSMUSG00000002602', u'ENSMUSG00000002603', u'ENSMUSG00000053647', u'ENSMUSG00000024621', u'ENSMUSG00000047250', u'ENSMUSG00000023031', u'ENSMUSG00000018927', u'ENSMUSG00000025225', u'ENSMUSG00000071203', u'ENSMUSG00000001729', u'ENSMUSG00000041135', u'ENSMUSG00000021624', u'ENSMUSG00000008318', u'ENSMUSG00000006344', u'ENSMUSG00000055633', u'ENSMUSG00000022074', u'ENSMUSG00000067586', u'ENSMUSG00000022514', u'ENSMUSG00000033350', u'ENSMUSG00000078945', u'ENSMUSG00000031536', u'ENSMUSG00000059866', u'ENSMUSG00000051439', u'ENSMUSG00000022040', u'ENSMUSG00000026117', u'ENSMUSG00000070390', u'ENSMUSG00000032691', u'ENSMUSG00000028964', u'ENSMUSG00000015950', u'ENSMUSG00000018932', u'ENSMUSG00000018930', u'ENSMUSG00000032911', u'ENSMUSG00000030339', u'ENSMUSG00000027684', u'ENSMUSG00000020573', u'ENSMUSG00000024952', u'ENSMUSG00000031750', u'ENSMUSG00000022508', u'ENSMUSG00000024793', u'ENSMUSG00000063415', u'ENSMUSG00000024927', u'ENSMUSG00000010051', u'ENSMUSG00000010054', u'ENSMUSG00000043496', u'ENSMUSG00000031681', u'ENSMUSG00000025083', u'ENSMUSG00000048376', u'ENSMUSG00000040451', u'ENSMUSG00000002983', u'ENSMUSG00000027358', u'ENSMUSG00000039004', u'ENSMUSG00000039005', u'ENSMUSG00000038264', u'ENSMUSG00000054717', u'ENSMUSG00000029468', u'ENSMUSG00000031537', u'ENSMUSG00000030341', u'ENSMUSG00000024789', u'ENSMUSG00000033538', u'ENSMUSG00000016495', u'ENSMUSG00000037731', u'ENSMUSG00000024781', u'ENSMUSG00000022575', u'ENSMUSG00000033885', u'ENSMUSG00000052430', u'ENSMUSG00000035385', u'ENSMUSG00000025473', u'ENSMUSG00000027995', u'ENSMUSG00000044827', u'ENSMUSG00000020399', u'ENSMUSG00000027858', u'ENSMUSG00000026177', u'ENSMUSG00000032322', u'ENSMUSG00000021936', u'ENSMUSG00000021423', u'ENSMUSG00000032041', u'ENSMUSG00000028599']), pop_n=13836, p_sm_bonferroni=7.786722292243632e-07, is_obsolete=False, GO='GO:0006954', name='inflammatory response', pop_count=165, alt_ids=[], level=4, depth=4, enrichment='e', Cluster='Consistent Increase', geneid_set=set([u'ENSMUSG00000045322', u'ENSMUSG00000030793', u'ENSMUSG00000063415', u'ENSMUSG00000016528', u'ENSMUSG00000031639', u'ENSMUSG00000062585', u'ENSMUSG00000006519', u'ENSMUSG00000024927', u'ENSMUSG00000027995', u'ENSMUSG00000047557', u'ENSMUSG00000002603', u'ENSMUSG00000043496', u'ENSMUSG00000042286', u'ENSMUSG00000024621', u'ENSMUSG00000047250', u'ENSMUSG00000047123', u'ENSMUSG00000025083', u'ENSMUSG00000025225', u'ENSMUSG00000037731', u'ENSMUSG00000037860', u'ENSMUSG00000027087', u'ENSMUSG00000029468', u'ENSMUSG00000071203', u'ENSMUSG00000030341', u'ENSMUSG00000003283', u'ENSMUSG00000033538', u'ENSMUSG00000016495', u'ENSMUSG00000009281', u'ENSMUSG00000042228', u'ENSMUSG00000052821', u'ENSMUSG00000014599', u'ENSMUSG00000022040', u'ENSMUSG00000070390', u'ENSMUSG00000032691', u'ENSMUSG00000015950', u'ENSMUSG00000021423', u'ENSMUSG00000079227', u'ENSMUSG00000024778']), symbols=u'Afap1l2 Aim2 Casp4 Ccr5 Cnr2 Csf1 Csf1r Cyba Cyp26b1 Cysltr1 Ephx2 Fas Hck Itgav Lxn Ly86 Lyn Mapkapk2 Naip5 Ncf1 Nfkb2 Nlrp1b Nlrp3 P2rx7 Plgrkt Ptgs1 Pycard Rarres2 Rela Stab1 Tgfb1 Themis2 Ticam1 Tlr2 Tlr3 Tlr9 Tnfrsf1a Tril', symbol_set=set([u'Casp4', u'Naip5', 'Plgrkt', u'Aim2', 'Themis2', u'Hck', u'Pycard', u'Rela', u'Mapkapk2', u'P2rx7', u'Tgfb1', u'Nfkb2', u'Stab1', u'Nlrp3', u'Tnfrsf1a', u'Fas', u'Csf1', u'Itgav', u'Lxn', u'Cysltr1', u'Ncf1', u'Afap1l2', u'Ticam1', u'Rarres2', u'Csf1r', u'Ephx2', u'Cyp26b1', u'Ccr5', u'Tril', u'Ptgs1', u'Cnr2', u'Nlrp1b', u'Tlr2', u'Tlr3', u'Cyba', u'Lyn', u'Tlr9', u'Ly86']), geneids='ENSMUSG00000045322 ENSMUSG00000030793 ENSMUSG00000070390 ENSMUSG00000063415 ENSMUSG00000016528 ENSMUSG00000031639 ENSMUSG00000062585 ENSMUSG00000006519 ENSMUSG00000024927 ENSMUSG00000047557 ENSMUSG00000002603 ENSMUSG00000043496 ENSMUSG00000042286 ENSMUSG00000024621 ENSMUSG00000047250 ENSMUSG00000047123 ENSMUSG00000025083 ENSMUSG00000025225 ENSMUSG00000037731 ENSMUSG00000037860 ENSMUSG00000027087 ENSMUSG00000079227 ENSMUSG00000029468 ENSMUSG00000071203 ENSMUSG00000030341 ENSMUSG00000009281 ENSMUSG00000033538 ENSMUSG00000016495 ENSMUSG00000042228 ENSMUSG00000052821 ENSMUSG00000014599 ENSMUSG00000022040 ENSMUSG00000003283 ENSMUSG00000032691 ENSMUSG00000015950 ENSMUSG00000021423 ENSMUSG00000027995 ENSMUSG00000024778', format_txt=1, hdr_idx=1, is_hdrgo=True, is_usrgo=True, hdr1usr01='**', dcnt=25, D1='F', GO_name='inflammatory response'),
    Nt(p_uncorrected=8.913005151044472e-08, study_count=20, study_n=794, namespace='biological_process', p_fdr_bh=9.002729402898319e-05, study_items=set([u'ENSMUSG00000079362', u'ENSMUSG00000073411', u'ENSMUSG00000073421', u'ENSMUSG00000034116', u'ENSMUSG00000045322', u'ENSMUSG00000061132', u'ENSMUSG00000026321', u'ENSMUSG00000036594', u'ENSMUSG00000032690', u'ENSMUSG00000030341', u'ENSMUSG00000061232', u'ENSMUSG00000020941', u'ENSMUSG00000060802', u'ENSMUSG00000027995', u'ENSMUSG00000079547', u'ENSMUSG00000041515', u'ENSMUSG00000022148', u'ENSMUSG00000079227', u'ENSMUSG00000024778', u'ENSMUSG00000039304']), NS='BP', pop_items=set([u'ENSMUSG00000045322', u'ENSMUSG00000026656', u'ENSMUSG00000032661', u'ENSMUSG00000059327', u'ENSMUSG00000060586', u'ENSMUSG00000031778', u'ENSMUSG00000002015', u'ENSMUSG00000061353', u'ENSMUSG00000029371', u'ENSMUSG00000023078', u'ENSMUSG00000021796', u'ENSMUSG00000022074', u'ENSMUSG00000036103', u'ENSMUSG00000079362', u'ENSMUSG00000006014', u'ENSMUSG00000027399', u'ENSMUSG00000029605', u'ENSMUSG00000000982', u'ENSMUSG00000037649', u'ENSMUSG00000045827', u'ENSMUSG00000032251', u'ENSMUSG00000029287', u'ENSMUSG00000020941', u'ENSMUSG00000024778', u'ENSMUSG00000031165', u'ENSMUSG00000022425', u'ENSMUSG00000061132', u'ENSMUSG00000032402', u'ENSMUSG00000036867', u'ENSMUSG00000035352', u'ENSMUSG00000061232', u'ENSMUSG00000034116', u'ENSMUSG00000039217', u'ENSMUSG00000044583', u'ENSMUSG00000034855', u'ENSMUSG00000022637', u'ENSMUSG00000031706', u'ENSMUSG00000037370', u'ENSMUSG00000032369', u'ENSMUSG00000001016', u'ENSMUSG00000017344', u'ENSMUSG00000024610', u'ENSMUSG00000026321', u'ENSMUSG00000034987', u'ENSMUSG00000021508', u'ENSMUSG00000022148', u'ENSMUSG00000079227', u'ENSMUSG00000052384', u'ENSMUSG00000029417', u'ENSMUSG00000056216', u'ENSMUSG00000019122', u'ENSMUSG00000002699', u'ENSMUSG00000073421', u'ENSMUSG00000032508', u'ENSMUSG00000018927', u'ENSMUSG00000079547', u'ENSMUSG00000008318', u'ENSMUSG00000029561', u'ENSMUSG00000056749', u'ENSMUSG00000036469', u'ENSMUSG00000033510', u'ENSMUSG00000028776', u'ENSMUSG00000060802', u'ENSMUSG00000026117', u'ENSMUSG00000032690', u'ENSMUSG00000022468', u'ENSMUSG00000039304', u'ENSMUSG00000018930', u'ENSMUSG00000030339', u'ENSMUSG00000006342', u'ENSMUSG00000028362', u'ENSMUSG00000024793', u'ENSMUSG00000005533', u'ENSMUSG00000041827', u'ENSMUSG00000021846', u'ENSMUSG00000038642', u'ENSMUSG00000039004', u'ENSMUSG00000034394', u'ENSMUSG00000030341', u'ENSMUSG00000016496', u'ENSMUSG00000073411', u'ENSMUSG00000035385', u'ENSMUSG00000027995', u'ENSMUSG00000044827', u'ENSMUSG00000036594', u'ENSMUSG00000027164', u'ENSMUSG00000041515', u'ENSMUSG00000028599']), pop_n=13836, p_sm_bonferroni=0.001350409410434748, is_obsolete=False, GO='GO:0006955', name='immune response', pop_count=88, alt_ids=[], level=2, depth=2, enrichment='e', Cluster='Consistent Increase', geneid_set=set([u'ENSMUSG00000079362', u'ENSMUSG00000034116', u'ENSMUSG00000045322', u'ENSMUSG00000030341', u'ENSMUSG00000073421', u'ENSMUSG00000073411', u'ENSMUSG00000060802', u'ENSMUSG00000061132', u'ENSMUSG00000026321', u'ENSMUSG00000036594', u'ENSMUSG00000032690', u'ENSMUSG00000079227', u'ENSMUSG00000020941', u'ENSMUSG00000024778', u'ENSMUSG00000079547', u'ENSMUSG00000041515', u'ENSMUSG00000022148', u'ENSMUSG00000027995', u'ENSMUSG00000061232', u'ENSMUSG00000039304']), symbols=u'B2m Blnk Ccr5 Fas Fyb Gm43302 H2-Aa H2-Ab1 H2-D1 H2-DMb1 H2-K1 Irf8 Map3k14 Oas2 Tlr2 Tlr9 Tnfrsf11a Tnfrsf1a Tnfsf10 Vav1', symbol_set=set([u'Fyb', 'H2-K1', 'H2-D1', u'Oas2', u'Tnfrsf1a', u'Vav1', 'H2-Ab1', u'Tnfsf10', u'Irf8', 'H2-Aa', 'H2-DMb1', u'Tlr2', u'B2m', 'Gm43302', u'Map3k14', u'Tnfrsf11a', u'Ccr5', u'Fas', u'Tlr9', u'Blnk']), geneids='ENSMUSG00000060802 ENSMUSG00000061232 ENSMUSG00000073421 ENSMUSG00000034116 ENSMUSG00000045322 ENSMUSG00000079227 ENSMUSG00000061132 ENSMUSG00000026321 ENSMUSG00000079362 ENSMUSG00000036594 ENSMUSG00000032690 ENSMUSG00000030341 ENSMUSG00000020941 ENSMUSG00000039304 ENSMUSG00000073411 ENSMUSG00000079547 ENSMUSG00000041515 ENSMUSG00000022148 ENSMUSG00000027995 ENSMUSG00000024778', format_txt=1, hdr_idx=1, is_hdrgo=True, is_usrgo=True, hdr1usr01='**', dcnt=107, D1='FL', GO_name='immune response'),
    Nt(p_uncorrected='', study_count='', study_n='', namespace='', p_fdr_bh='', study_items='', NS='BP', pop_items='', pop_n='', p_sm_bonferroni='', is_obsolete='', GO='GO:0032879', name='', pop_count='', alt_ids='', level=3, depth=3, enrichment='', Cluster='', geneid_set='', symbols='', symbol_set='', geneids='', format_txt=1, hdr_idx=1, is_hdrgo=True, is_usrgo=False, hdr1usr01='*', dcnt=1780, D1='A', GO_name='regulation of localization'),
    Nt(p_uncorrected=5.378962372457587e-07, study_count=7, study_n=794, namespace='biological_process', p_fdr_bh=0.0004289297837110785, study_items=set([u'ENSMUSG00000073411', u'ENSMUSG00000029468', u'ENSMUSG00000060802', u'ENSMUSG00000024339', u'ENSMUSG00000067212', u'ENSMUSG00000021871', u'ENSMUSG00000061232']), NS='BP', pop_items=set([u'ENSMUSG00000073411', u'ENSMUSG00000029468', u'ENSMUSG00000060802', u'ENSMUSG00000024339', u'ENSMUSG00000067212', u'ENSMUSG00000021871', u'ENSMUSG00000019998', u'ENSMUSG00000015656', u'ENSMUSG00000016206', u'ENSMUSG00000061232', u'ENSMUSG00000026395']), pop_n=13836, p_sm_bonferroni=0.00814966589051049, is_obsolete=False, GO='GO:0001916', name='positive regulation of T cell mediated cytotoxicity', pop_count=11, alt_ids=[], level=6, depth=9, enrichment='e', Cluster='Consistent Increase', geneid_set=set([u'ENSMUSG00000073411', u'ENSMUSG00000029468', u'ENSMUSG00000060802', u'ENSMUSG00000024339', u'ENSMUSG00000067212', u'ENSMUSG00000021871', u'ENSMUSG00000061232']), symbols=u'B2m H2-D1 H2-K1 H2-T23 P2rx7 Pnp Tap2', symbol_set=set(['H2-K1', 'H2-D1', u'Pnp', 'H2-T23', u'B2m', u'Tap2', u'P2rx7']), geneids='ENSMUSG00000073411 ENSMUSG00000029468 ENSMUSG00000060802 ENSMUSG00000024339 ENSMUSG00000067212 ENSMUSG00000021871 ENSMUSG00000061232', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=3, D1='A', GO_name='positive regulation of T cell mediated cytotoxicity'),
    Nt(p_uncorrected=1.1717303088250284e-05, study_count=5, study_n=794, namespace='biological_process', p_fdr_bh=0.004931357196946668, study_items=set([u'ENSMUSG00000057948', u'ENSMUSG00000052593', u'ENSMUSG00000053175', u'ENSMUSG00000025225', u'ENSMUSG00000043008']), NS='BP', pop_items=set([u'ENSMUSG00000052593', u'ENSMUSG00000053175', u'ENSMUSG00000043008', u'ENSMUSG00000022508', u'ENSMUSG00000025225', u'ENSMUSG00000057948', u'ENSMUSG00000005583']), pop_n=13836, p_sm_bonferroni=0.17752885909008007, is_obsolete=False, GO='GO:0002467', name='germinal center formation', pop_count=7, alt_ids=[], level=3, depth=5, enrichment='e', Cluster='Consistent Increase', geneid_set=set([u'ENSMUSG00000043008', u'ENSMUSG00000053175', u'ENSMUSG00000052593', u'ENSMUSG00000025225', u'ENSMUSG00000057948']), symbols=u'Adam17 Bcl3 Klhl6 Nfkb2 Unc13d', symbol_set=set([u'Klhl6', u'Nfkb2', u'Unc13d', u'Bcl3', u'Adam17']), geneids='ENSMUSG00000053175 ENSMUSG00000052593 ENSMUSG00000057948 ENSMUSG00000025225 ENSMUSG00000043008', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=0, D1='EFL', GO_name='germinal center formation'),
    Nt(p_uncorrected=1.935958720767685e-06, study_count=26, study_n=794, namespace='biological_process', p_fdr_bh=0.001128142714551969, study_items=set([u'ENSMUSG00000023972', u'ENSMUSG00000058056', u'ENSMUSG00000031995', u'ENSMUSG00000004508', u'ENSMUSG00000024835', u'ENSMUSG00000022568', u'ENSMUSG00000021990', u'ENSMUSG00000002603', u'ENSMUSG00000031805', u'ENSMUSG00000072115', u'ENSMUSG00000036862', u'ENSMUSG00000039286', u'ENSMUSG00000032312', u'ENSMUSG00000027087', u'ENSMUSG00000005087', u'ENSMUSG00000026814', u'ENSMUSG00000033295', u'ENSMUSG00000036995', u'ENSMUSG00000031740', u'ENSMUSG00000009621', u'ENSMUSG00000000957', u'ENSMUSG00000062960', u'ENSMUSG00000020689', u'ENSMUSG00000027654', u'ENSMUSG00000007815', u'ENSMUSG00000021998']), NS='BP', pop_items=set([u'ENSMUSG00000033721', u'ENSMUSG00000026490', u'ENSMUSG00000028024', u'ENSMUSG00000027544', u'ENSMUSG00000061136', u'ENSMUSG00000004508', u'ENSMUSG00000022568', u'ENSMUSG00000019997', u'ENSMUSG00000025351', u'ENSMUSG00000031805', u'ENSMUSG00000029053', u'ENSMUSG00000029648', u'ENSMUSG00000058230', u'ENSMUSG00000002489', u'ENSMUSG00000004263', u'ENSMUSG00000021065', u'ENSMUSG00000015647', u'ENSMUSG00000020592', u'ENSMUSG00000028530', u'ENSMUSG00000026814', u'ENSMUSG00000020422', u'ENSMUSG00000039239', u'ENSMUSG00000030685', u'ENSMUSG00000022791', u'ENSMUSG00000009621', u'ENSMUSG00000018849', u'ENSMUSG00000005958', u'ENSMUSG00000006445', u'ENSMUSG00000027654', u'ENSMUSG00000025608', u'ENSMUSG00000040152', u'ENSMUSG00000043061', u'ENSMUSG00000037643', u'ENSMUSG00000030967', u'ENSMUSG00000032312', u'ENSMUSG00000025510', u'ENSMUSG00000021763', u'ENSMUSG00000052504', u'ENSMUSG00000020745', u'ENSMUSG00000055447', u'ENSMUSG00000013663', u'ENSMUSG00000021338', u'ENSMUSG00000027954', u'ENSMUSG00000021994', u'ENSMUSG00000026782', u'ENSMUSG00000020282', u'ENSMUSG00000029231', u'ENSMUSG00000001847', u'ENSMUSG00000037014', u'ENSMUSG00000027009', u'ENSMUSG00000027646', u'ENSMUSG00000004364', u'ENSMUSG00000020135', u'ENSMUSG00000036862', u'ENSMUSG00000039286', u'ENSMUSG00000004933', u'ENSMUSG00000027087', u'ENSMUSG00000062209', u'ENSMUSG00000072115', u'ENSMUSG00000026837', u'ENSMUSG00000066877', u'ENSMUSG00000001552', u'ENSMUSG00000036995', u'ENSMUSG00000031626', u'ENSMUSG00000008475', u'ENSMUSG00000000957', u'ENSMUSG00000031555', u'ENSMUSG00000047139', u'ENSMUSG00000019889', u'ENSMUSG00000017615', u'ENSMUSG00000025239', u'ENSMUSG00000040732', u'ENSMUSG00000032475', u'ENSMUSG00000045180', u'ENSMUSG00000001300', u'ENSMUSG00000021877', u'ENSMUSG00000025437', u'ENSMUSG00000037902', u'ENSMUSG00000056481', u'ENSMUSG00000020121', u'ENSMUSG00000007815', u'ENSMUSG00000074305', u'ENSMUSG00000033444', u'ENSMUSG00000050295', u'ENSMUSG00000049313', u'ENSMUSG00000032740', u'ENSMUSG00000026596', u'ENSMUSG00000017670', u'ENSMUSG00000024835', u'ENSMUSG00000021998', u'ENSMUSG00000022528', u'ENSMUSG00000018736', u'ENSMUSG00000021990', u'ENSMUSG00000058571', u'ENSMUSG00000030707', u'ENSMUSG00000027239', u'ENSMUSG00000022200', u'ENSMUSG00000002603', u'ENSMUSG00000024620', u'ENSMUSG00000029787', u'ENSMUSG00000031785', u'ENSMUSG00000024232', u'ENSMUSG00000000148', u'ENSMUSG00000000631', u'ENSMUSG00000042453', u'ENSMUSG00000032175', u'ENSMUSG00000025429', u'ENSMUSG00000061665', u'ENSMUSG00000026755', u'ENSMUSG00000005087', u'ENSMUSG00000039629', u'ENSMUSG00000026587', u'ENSMUSG00000025809', u'ENSMUSG00000024122', u'ENSMUSG00000023972', u'ENSMUSG00000058056', u'ENSMUSG00000002900', u'ENSMUSG00000023008', u'ENSMUSG00000022602', u'ENSMUSG00000025810', u'ENSMUSG00000062991', u'ENSMUSG00000028701', u'ENSMUSG00000020149', u'ENSMUSG00000014791', u'ENSMUSG00000028969', u'ENSMUSG00000041112', u'ENSMUSG00000030134', u'ENSMUSG00000016933', u'ENSMUSG00000072437', u'ENSMUSG00000039637', u'ENSMUSG00000040990', u'ENSMUSG00000031995', u'ENSMUSG00000031990', u'ENSMUSG00000038976', u'ENSMUSG00000045382', u'ENSMUSG00000028514', u'ENSMUSG00000022505', u'ENSMUSG00000058325', u'ENSMUSG00000026478', u'ENSMUSG00000024486', u'ENSMUSG00000030720', u'ENSMUSG00000040511', u'ENSMUSG00000022261', u'ENSMUSG00000033295', u'ENSMUSG00000025743', u'ENSMUSG00000025089', u'ENSMUSG00000022812', u'ENSMUSG00000045092', u'ENSMUSG00000021279', u'ENSMUSG00000057177', u'ENSMUSG00000005871', u'ENSMUSG00000031740', u'ENSMUSG00000024789', u'ENSMUSG00000029581', u'ENSMUSG00000025348', u'ENSMUSG00000062960', u'ENSMUSG00000023951', u'ENSMUSG00000020689', u'ENSMUSG00000033392', u'ENSMUSG00000031955', u'ENSMUSG00000050357', u'ENSMUSG00000024304', u'ENSMUSG00000032322']), pop_n=13836, p_sm_bonferroni=0.029331710578351194, is_obsolete=False, GO='GO:0016477', name='cell migration', pop_count=163, alt_ids=[], level=3, depth=5, enrichment='e', Cluster='Consistent Increase', geneid_set=set([u'ENSMUSG00000058056', u'ENSMUSG00000026814', u'ENSMUSG00000072115', u'ENSMUSG00000000957', u'ENSMUSG00000005087', u'ENSMUSG00000036995', u'ENSMUSG00000031995', u'ENSMUSG00000004508', u'ENSMUSG00000024835', u'ENSMUSG00000022568', u'ENSMUSG00000023972', u'ENSMUSG00000021990', u'ENSMUSG00000020689', u'ENSMUSG00000027654', u'ENSMUSG00000007815', u'ENSMUSG00000031740', u'ENSMUSG00000002603', u'ENSMUSG00000062960', u'ENSMUSG00000031805', u'ENSMUSG00000033295', u'ENSMUSG00000036862', u'ENSMUSG00000039286', u'ENSMUSG00000009621', u'ENSMUSG00000032312', u'ENSMUSG00000027087', u'ENSMUSG00000021998']), symbols=u'Ang Asap3 Cd44 Coro1b Csk Dchs1 Eng Fam83d Fndc3b Gab2 Itgav Itgb3 Jak3 Kdr Lcp1 Mmp14 Mmp2 Palld Ptk7 Ptprf Rhoa Scrib Spata13 St14 Tgfb1 Vav2', symbol_set=set([u'Spata13', u'Csk', u'Eng', u'Gab2', u'Coro1b', u'Lcp1', u'Asap3', u'Dchs1', u'Tgfb1', u'Itgb3', u'Vav2', u'Palld', u'Itgav', u'Fndc3b', u'Mmp2', u'Fam83d', u'Mmp14', u'Ptk7', u'Rhoa', u'Ang', u'Cd44', u'Scrib', u'Ptprf', u'St14', u'Jak3', u'Kdr']), geneids='ENSMUSG00000000957 ENSMUSG00000058056 ENSMUSG00000031995 ENSMUSG00000004508 ENSMUSG00000024835 ENSMUSG00000021998 ENSMUSG00000021990 ENSMUSG00000002603 ENSMUSG00000031805 ENSMUSG00000072115 ENSMUSG00000036862 ENSMUSG00000039286 ENSMUSG00000032312 ENSMUSG00000027087 ENSMUSG00000005087 ENSMUSG00000026814 ENSMUSG00000033295 ENSMUSG00000036995 ENSMUSG00000031740 ENSMUSG00000009621 ENSMUSG00000023972 ENSMUSG00000062960 ENSMUSG00000020689 ENSMUSG00000027654 ENSMUSG00000007815 ENSMUSG00000022568', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=236, D1='BCM', GO_name='cell migration'),
    Nt(p_uncorrected=1.5494522500375623e-06, study_count=20, study_n=794, namespace='biological_process', p_fdr_bh=0.0009390300416127642, study_items=set([u'ENSMUSG00000056144', u'ENSMUSG00000024349', u'ENSMUSG00000029826', u'ENSMUSG00000009585', u'ENSMUSG00000045322', u'ENSMUSG00000027639', u'ENSMUSG00000026928', u'ENSMUSG00000033450', u'ENSMUSG00000000275', u'ENSMUSG00000040264', u'ENSMUSG00000032690', u'ENSMUSG00000047123', u'ENSMUSG00000030793', u'ENSMUSG00000057948', u'ENSMUSG00000031639', u'ENSMUSG00000025492', u'ENSMUSG00000037921', u'ENSMUSG00000032691', u'ENSMUSG00000043279', u'ENSMUSG00000062488']), NS='BP', pop_items=set([u'ENSMUSG00000029826', u'ENSMUSG00000045322', u'ENSMUSG00000070583', u'ENSMUSG00000024079', u'ENSMUSG00000009585', u'ENSMUSG00000020455', u'ENSMUSG00000024978', u'ENSMUSG00000021494', u'ENSMUSG00000022476', u'ENSMUSG00000066568', u'ENSMUSG00000061298', u'ENSMUSG00000017707', u'ENSMUSG00000037523', u'ENSMUSG00000038628', u'ENSMUSG00000020115', u'ENSMUSG00000000776', u'ENSMUSG00000026395', u'ENSMUSG00000056144', u'ENSMUSG00000039236', u'ENSMUSG00000066800', u'ENSMUSG00000029605', u'ENSMUSG00000026896', u'ENSMUSG00000061286', u'ENSMUSG00000078566', u'ENSMUSG00000003234', u'ENSMUSG00000045932', u'ENSMUSG00000020108', u'ENSMUSG00000000275', u'ENSMUSG00000027951', u'ENSMUSG00000036986', u'ENSMUSG00000056851', u'ENSMUSG00000041415', u'ENSMUSG00000035834', u'ENSMUSG00000003184', u'ENSMUSG00000047123', u'ENSMUSG00000036908', u'ENSMUSG00000057948', u'ENSMUSG00000021703', u'ENSMUSG00000022901', u'ENSMUSG00000030789', u'ENSMUSG00000044583', u'ENSMUSG00000034855', u'ENSMUSG00000024349', u'ENSMUSG00000032369', u'ENSMUSG00000035692', u'ENSMUSG00000034459', u'ENSMUSG00000034453', u'ENSMUSG00000022865', u'ENSMUSG00000020641', u'ENSMUSG00000040033', u'ENSMUSG00000025532', u'ENSMUSG00000000386', u'ENSMUSG00000079339', u'ENSMUSG00000032661', u'ENSMUSG00000029417', u'ENSMUSG00000030314', u'ENSMUSG00000027427', u'ENSMUSG00000026928', u'ENSMUSG00000046718', u'ENSMUSG00000030793', u'ENSMUSG00000074896', u'ENSMUSG00000031639', u'ENSMUSG00000062488', u'ENSMUSG00000028099', u'ENSMUSG00000022971', u'ENSMUSG00000032178', u'ENSMUSG00000030880', u'ENSMUSG00000035086', u'ENSMUSG00000027514', u'ENSMUSG00000033450', u'ENSMUSG00000030247', u'ENSMUSG00000029561', u'ENSMUSG00000029165', u'ENSMUSG00000020783', u'ENSMUSG00000030249', u'ENSMUSG00000025492', u'ENSMUSG00000027598', u'ENSMUSG00000032344', u'ENSMUSG00000057329', u'ENSMUSG00000027639', u'ENSMUSG00000040296', u'ENSMUSG00000032690', u'ENSMUSG00000032691', u'ENSMUSG00000022965', u'ENSMUSG00000022967', u'ENSMUSG00000019726', u'ENSMUSG00000022969', u'ENSMUSG00000037921', u'ENSMUSG00000029771', u'ENSMUSG00000020009', u'ENSMUSG00000040264', u'ENSMUSG00000043279', u'ENSMUSG00000024810', u'ENSMUSG00000041827', u'ENSMUSG00000022051', u'ENSMUSG00000017830', u'ENSMUSG00000023341', u'ENSMUSG00000040613', u'ENSMUSG00000018899', u'ENSMUSG00000060591', u'ENSMUSG00000010047', u'ENSMUSG00000005102', u'ENSMUSG00000034259', u'ENSMUSG00000038884']), pop_n=13836, p_sm_bonferroni=0.023475751040319105, is_obsolete=False, GO='GO:0051607', name='defense response to virus', pop_count=104, alt_ids=[], level=3, depth=6, enrichment='e', Cluster='Consistent Increase', geneid_set=set([u'ENSMUSG00000056144', u'ENSMUSG00000040264', u'ENSMUSG00000045322', u'ENSMUSG00000026928', u'ENSMUSG00000033450', u'ENSMUSG00000025492', u'ENSMUSG00000030793', u'ENSMUSG00000031639', u'ENSMUSG00000009585', u'ENSMUSG00000032691', u'ENSMUSG00000062488', u'ENSMUSG00000024349', u'ENSMUSG00000027639', u'ENSMUSG00000029826', u'ENSMUSG00000000275', u'ENSMUSG00000043279', u'ENSMUSG00000032690', u'ENSMUSG00000047123', u'ENSMUSG00000057948', u'ENSMUSG00000037921']), symbols=u'Apobec3 Card9 Ddx60 Gbp2b Ifit3b Ifitm3 Nlrp3 Oas2 Pycard Samhd1 Tagap Ticam1 Tlr3 Tlr9 Tmem173 Trim25 Trim34a Trim56 Unc13d Zc3hav1', symbol_set=set(['Gbp2b', u'Ifitm3', u'Trim56', u'Samhd1', u'Nlrp3', u'Tagap', u'Ticam1', u'Trim25', u'Ddx60', u'Unc13d', 'Ifit3b', u'Apobec3', u'Tlr3', u'Card9', u'Oas2', u'Zc3hav1', u'Tmem173', u'Pycard', u'Tlr9', u'Trim34a']), geneids='ENSMUSG00000056144 ENSMUSG00000024349 ENSMUSG00000033450 ENSMUSG00000040264 ENSMUSG00000045322 ENSMUSG00000027639 ENSMUSG00000026928 ENSMUSG00000029826 ENSMUSG00000000275 ENSMUSG00000025492 ENSMUSG00000030793 ENSMUSG00000032691 ENSMUSG00000032690 ENSMUSG00000057948 ENSMUSG00000031639 ENSMUSG00000009585 ENSMUSG00000037921 ENSMUSG00000047123 ENSMUSG00000043279 ENSMUSG00000062488', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=3, D1='FL', GO_name='defense response to virus'),
    Nt(p_uncorrected='', study_count='', study_n='', namespace='', p_fdr_bh='', study_items='', NS='BP', pop_items='', pop_n='', p_sm_bonferroni='', is_obsolete='', GO='GO:0048870', name='', pop_count='', alt_ids='', level=2, depth=4, enrichment='', Cluster='', geneid_set='', symbols='', symbol_set='', geneids='', format_txt=1, hdr_idx=1, is_hdrgo=True, is_usrgo=False, hdr1usr01='*', dcnt=261, D1='BCM', GO_name='cell motility'),
    Nt(p_uncorrected=2.7763769242448692e-05, study_count=11, study_n=794, namespace='biological_process', p_fdr_bh=0.011069707047166847, study_items=set([u'ENSMUSG00000032902', u'ENSMUSG00000048779', u'ENSMUSG00000024349', u'ENSMUSG00000029468', u'ENSMUSG00000002603', u'ENSMUSG00000004040', u'ENSMUSG00000036362', u'ENSMUSG00000004056', u'ENSMUSG00000036353', u'ENSMUSG00000002459', u'ENSMUSG00000052681']), NS='BP', pop_items=set([u'ENSMUSG00000031284', u'ENSMUSG00000030602', u'ENSMUSG00000022781', u'ENSMUSG00000003031', u'ENSMUSG00000068798', u'ENSMUSG00000052681', u'ENSMUSG00000030059', u'ENSMUSG00000028766', u'ENSMUSG00000034957', u'ENSMUSG00000027765', u'ENSMUSG00000022556', u'ENSMUSG00000002603', u'ENSMUSG00000031681', u'ENSMUSG00000004056', u'ENSMUSG00000036353', u'ENSMUSG00000027509', u'ENSMUSG00000026104', u'ENSMUSG00000021025', u'ENSMUSG00000001729', u'ENSMUSG00000027358', u'ENSMUSG00000032902', u'ENSMUSG00000048779', u'ENSMUSG00000027796', u'ENSMUSG00000029468', u'ENSMUSG00000021540', u'ENSMUSG00000039217', u'ENSMUSG00000057177', u'ENSMUSG00000035352', u'ENSMUSG00000026185', u'ENSMUSG00000020516', u'ENSMUSG00000024349', u'ENSMUSG00000024087', u'ENSMUSG00000030774', u'ENSMUSG00000004043', u'ENSMUSG00000004040', u'ENSMUSG00000048402', u'ENSMUSG00000036362', u'ENSMUSG00000025217', u'ENSMUSG00000024182', u'ENSMUSG00000028163', u'ENSMUSG00000002459', u'ENSMUSG00000002458', u'ENSMUSG00000000142', u'ENSMUSG00000034640']), pop_n=13836, p_sm_bonferroni=0.4206488677923401, is_obsolete=False, GO='GO:0071407', name='cellular response to organic cyclic compound', pop_count=44, alt_ids=[], level=5, depth=5, enrichment='e', Cluster='Consistent Increase', geneid_set=set([u'ENSMUSG00000032902', u'ENSMUSG00000048779', u'ENSMUSG00000024349', u'ENSMUSG00000029468', u'ENSMUSG00000002603', u'ENSMUSG00000004040', u'ENSMUSG00000036362', u'ENSMUSG00000004056', u'ENSMUSG00000036353', u'ENSMUSG00000002459', u'ENSMUSG00000052681']), symbols=u'Akt2 P2rx7 P2ry12 P2ry13 P2ry6 Rap1b Rgs20 Slc16a1 Stat3 Tgfb1 Tmem173', symbol_set=set([u'Tgfb1', u'Rgs20', u'Stat3', u'Slc16a1', u'Rap1b', u'P2ry12', u'P2ry13', u'Akt2', u'P2ry6', u'Tmem173', u'P2rx7']), geneids='ENSMUSG00000032902 ENSMUSG00000048779 ENSMUSG00000024349 ENSMUSG00000029468 ENSMUSG00000002603 ENSMUSG00000004040 ENSMUSG00000036362 ENSMUSG00000004056 ENSMUSG00000036353 ENSMUSG00000002459 ENSMUSG00000052681', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=122, D1='BF', GO_name='cellular response to organic cyclic compound'),
    Nt(p_uncorrected='', study_count='', study_n='', namespace='', p_fdr_bh='', study_items='', NS='BP', pop_items='', pop_n='', p_sm_bonferroni='', is_obsolete='', GO='GO:0050896', name='', pop_count='', alt_ids='', level=1, depth=1, enrichment='', Cluster='', geneid_set='', symbols='', symbol_set='', geneids='', format_txt=1, hdr_idx=1, is_hdrgo=True, is_usrgo=False, hdr1usr01='*', dcnt=2241, D1='F', GO_name='response to stimulus'),
    Nt(p_uncorrected=2.5263641063287124e-06, study_count=7, study_n=794, namespace='biological_process', p_fdr_bh=0.0013251369739822624, study_items=set([u'ENSMUSG00000025888', u'ENSMUSG00000029468', u'ENSMUSG00000030793', u'ENSMUSG00000032691', u'ENSMUSG00000033538', u'ENSMUSG00000037860', u'ENSMUSG00000079227']), NS='BP', pop_items=set([u'ENSMUSG00000000982', u'ENSMUSG00000025888', u'ENSMUSG00000029468', u'ENSMUSG00000030793', u'ENSMUSG00000032691', u'ENSMUSG00000066551', u'ENSMUSG00000033538', u'ENSMUSG00000031934', u'ENSMUSG00000022967', u'ENSMUSG00000021994', u'ENSMUSG00000037860', u'ENSMUSG00000022575', u'ENSMUSG00000079227']), pop_n=13836, p_sm_bonferroni=0.038276942574986324, is_obsolete=False, GO='GO:0050718', name='positive regulation of interleukin-1 beta secretion', pop_count=13, alt_ids=[], level=8, depth=11, enrichment='e', Cluster='Consistent Increase', geneid_set=set([u'ENSMUSG00000025888', u'ENSMUSG00000033538', u'ENSMUSG00000029468', u'ENSMUSG00000037860', u'ENSMUSG00000079227', u'ENSMUSG00000030793', u'ENSMUSG00000032691']), symbols=u'Aim2 Casp1 Casp4 Ccr5 Nlrp3 P2rx7 Pycard', symbol_set=set([u'Casp4', u'Nlrp3', u'Casp1', u'Aim2', u'Ccr5', u'Pycard', u'P2rx7']), geneids='ENSMUSG00000025888 ENSMUSG00000029468 ENSMUSG00000030793 ENSMUSG00000032691 ENSMUSG00000033538 ENSMUSG00000037860 ENSMUSG00000079227', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=0, D1='A', GO_name='positive regulation of interleukin-1 beta secretion'),
    Nt(p_uncorrected=4.858068668518285e-10, study_count=16, study_n=794, namespace='biological_process', p_fdr_bh=1.4720919679344106e-06, study_items=set([u'ENSMUSG00000040264', u'ENSMUSG00000052593', u'ENSMUSG00000038058', u'ENSMUSG00000060802', u'ENSMUSG00000072115', u'ENSMUSG00000026928', u'ENSMUSG00000067212', u'ENSMUSG00000035279', u'ENSMUSG00000062210', u'ENSMUSG00000003283', u'ENSMUSG00000015950', u'ENSMUSG00000028270', u'ENSMUSG00000028268', u'ENSMUSG00000027995', u'ENSMUSG00000029298', u'ENSMUSG00000029468']), NS='BP', pop_items=set([u'ENSMUSG00000058385', u'ENSMUSG00000040264', u'ENSMUSG00000015950', u'ENSMUSG00000028874', u'ENSMUSG00000026928', u'ENSMUSG00000067212', u'ENSMUSG00000035279', u'ENSMUSG00000028362', u'ENSMUSG00000062727', u'ENSMUSG00000028268', u'ENSMUSG00000022191', u'ENSMUSG00000022575', u'ENSMUSG00000052593', u'ENSMUSG00000032508', u'ENSMUSG00000069516', u'ENSMUSG00000079641', u'ENSMUSG00000016024', u'ENSMUSG00000020115', u'ENSMUSG00000041135', u'ENSMUSG00000029298', u'ENSMUSG00000054717', u'ENSMUSG00000029468', u'ENSMUSG00000072115', u'ENSMUSG00000068854', u'ENSMUSG00000040253', u'ENSMUSG00000027695', u'ENSMUSG00000037071', u'ENSMUSG00000021194', u'ENSMUSG00000003283', u'ENSMUSG00000028270', u'ENSMUSG00000018102', u'ENSMUSG00000062210', u'ENSMUSG00000006445', u'ENSMUSG00000060802', u'ENSMUSG00000027995', u'ENSMUSG00000047246', u'ENSMUSG00000020399', u'ENSMUSG00000038058', u'ENSMUSG00000024300', u'ENSMUSG00000079614', u'ENSMUSG00000032041', u'ENSMUSG00000069268']), pop_n=13836, p_sm_bonferroni=7.360459839672053e-06, is_obsolete=False, GO='GO:0050830', name='defense response to Gram-positive bacterium', pop_count=42, alt_ids=[], level=6, depth=7, enrichment='e', Cluster='Consistent Increase', geneid_set=set([u'ENSMUSG00000040264', u'ENSMUSG00000015950', u'ENSMUSG00000072115', u'ENSMUSG00000026928', u'ENSMUSG00000067212', u'ENSMUSG00000035279', u'ENSMUSG00000062210', u'ENSMUSG00000003283', u'ENSMUSG00000028270', u'ENSMUSG00000028268', u'ENSMUSG00000029468', u'ENSMUSG00000052593', u'ENSMUSG00000060802', u'ENSMUSG00000027995', u'ENSMUSG00000038058', u'ENSMUSG00000029298']), symbols=u'Adam17 Ang B2m Card9 Gbp2 Gbp2b Gbp3 Gbp9 H2-T23 Hck Ncf1 Nod1 P2rx7 Ssc5d Tlr2 Tnfaip8', symbol_set=set(['Gbp2b', u'Ncf1', u'Ang', u'Tnfaip8', 'Ssc5d', u'Gbp3', u'Gbp2', 'H2-T23', u'B2m', u'Tlr2', u'Card9', u'Nod1', u'Adam17', u'Hck', u'Gbp9', u'P2rx7']), geneids='ENSMUSG00000040264 ENSMUSG00000052593 ENSMUSG00000029468 ENSMUSG00000060802 ENSMUSG00000072115 ENSMUSG00000026928 ENSMUSG00000027995 ENSMUSG00000035279 ENSMUSG00000067212 ENSMUSG00000062210 ENSMUSG00000003283 ENSMUSG00000015950 ENSMUSG00000028270 ENSMUSG00000028268 ENSMUSG00000038058 ENSMUSG00000029298', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=0, D1='F', GO_name='defense response to Gram-positive bacterium'),
    Nt(p_uncorrected=1.3518814314355716e-10, study_count=61, study_n=794, namespace='biological_process', p_fdr_bh=5.120588891920086e-07, study_items=set([u'ENSMUSG00000040264', u'ENSMUSG00000045322', u'ENSMUSG00000026928', u'ENSMUSG00000067212', u'ENSMUSG00000035279', u'ENSMUSG00000030793', u'ENSMUSG00000070390', u'ENSMUSG00000055172', u'ENSMUSG00000031639', u'ENSMUSG00000009585', u'ENSMUSG00000031805', u'ENSMUSG00000047798', u'ENSMUSG00000024338', u'ENSMUSG00000024339', u'ENSMUSG00000043496', u'ENSMUSG00000029826', u'ENSMUSG00000024621', u'ENSMUSG00000073421', u'ENSMUSG00000047123', u'ENSMUSG00000024235', u'ENSMUSG00000027508', u'ENSMUSG00000071203', u'ENSMUSG00000079547', u'ENSMUSG00000025492', u'ENSMUSG00000037860', u'ENSMUSG00000036905', u'ENSMUSG00000032312', u'ENSMUSG00000061232', u'ENSMUSG00000038213', u'ENSMUSG00000020707', u'ENSMUSG00000028191', u'ENSMUSG00000057058', u'ENSMUSG00000037731', u'ENSMUSG00000024349', u'ENSMUSG00000030263', u'ENSMUSG00000003283', u'ENSMUSG00000032691', u'ENSMUSG00000033538', u'ENSMUSG00000020437', u'ENSMUSG00000029217', u'ENSMUSG00000062593', u'ENSMUSG00000042228', u'ENSMUSG00000036896', u'ENSMUSG00000015947', u'ENSMUSG00000030748', u'ENSMUSG00000021583', u'ENSMUSG00000073411', u'ENSMUSG00000060802', u'ENSMUSG00000029798', u'ENSMUSG00000014599', u'ENSMUSG00000027995', u'ENSMUSG00000027639', u'ENSMUSG00000000275', u'ENSMUSG00000036594', u'ENSMUSG00000032690', u'ENSMUSG00000040751', u'ENSMUSG00000038058', u'ENSMUSG00000021423', u'ENSMUSG00000031838', u'ENSMUSG00000043279', u'ENSMUSG00000060550']), NS='BP', pop_items=set([u'ENSMUSG00000035834', u'ENSMUSG00000045322', u'ENSMUSG00000028874', u'ENSMUSG00000004730', u'ENSMUSG00000021703', u'ENSMUSG00000024079', u'ENSMUSG00000074151', u'ENSMUSG00000060586', u'ENSMUSG00000016481', u'ENSMUSG00000024338', u'ENSMUSG00000055172', u'ENSMUSG00000036887', u'ENSMUSG00000009585', u'ENSMUSG00000031805', u'ENSMUSG00000022476', u'ENSMUSG00000024371', u'ENSMUSG00000042228', u'ENSMUSG00000017707', u'ENSMUSG00000032035', u'ENSMUSG00000071369', u'ENSMUSG00000026399', u'ENSMUSG00000037523', u'ENSMUSG00000038628', u'ENSMUSG00000020115', u'ENSMUSG00000000776', u'ENSMUSG00000019843', u'ENSMUSG00000015217', u'ENSMUSG00000035629', u'ENSMUSG00000039748', u'ENSMUSG00000039236', u'ENSMUSG00000049686', u'ENSMUSG00000024164', u'ENSMUSG00000035279', u'ENSMUSG00000024045', u'ENSMUSG00000038128', u'ENSMUSG00000075705', u'ENSMUSG00000041187', u'ENSMUSG00000038517', u'ENSMUSG00000046034', u'ENSMUSG00000062593', u'ENSMUSG00000029605', u'ENSMUSG00000026896', u'ENSMUSG00000037321', u'ENSMUSG00000037649', u'ENSMUSG00000014599', u'ENSMUSG00000000275', u'ENSMUSG00000024789', u'ENSMUSG00000051439', u'ENSMUSG00000038058', u'ENSMUSG00000025512', u'ENSMUSG00000050199', u'ENSMUSG00000034889', u'ENSMUSG00000024621', u'ENSMUSG00000027951', u'ENSMUSG00000020437', u'ENSMUSG00000070390', u'ENSMUSG00000036986', u'ENSMUSG00000030751', u'ENSMUSG00000025139', u'ENSMUSG00000000134', u'ENSMUSG00000026883', u'ENSMUSG00000015837', u'ENSMUSG00000032691', u'ENSMUSG00000018446', u'ENSMUSG00000018899', u'ENSMUSG00000028885', u'ENSMUSG00000029826', u'ENSMUSG00000028633', u'ENSMUSG00000027646', u'ENSMUSG00000003184', u'ENSMUSG00000047123', u'ENSMUSG00000024767', u'ENSMUSG00000016024', u'ENSMUSG00000054072', u'ENSMUSG00000036908', u'ENSMUSG00000037860', u'ENSMUSG00000036905', u'ENSMUSG00000032312', u'ENSMUSG00000061232', u'ENSMUSG00000001123', u'ENSMUSG00000031392', u'ENSMUSG00000028099', u'ENSMUSG00000055204', u'ENSMUSG00000022901', u'ENSMUSG00000045932', u'ENSMUSG00000033777', u'ENSMUSG00000059883', u'ENSMUSG00000027598', u'ENSMUSG00000030263', u'ENSMUSG00000039936', u'ENSMUSG00000003283', u'ENSMUSG00000051212', u'ENSMUSG00000044583', u'ENSMUSG00000023915', u'ENSMUSG00000002688', u'ENSMUSG00000022636', u'ENSMUSG00000021583', u'ENSMUSG00000078942', u'ENSMUSG00000031838', u'ENSMUSG00000078945', u'ENSMUSG00000025702', u'ENSMUSG00000027639', u'ENSMUSG00000033307', u'ENSMUSG00000024610', u'ENSMUSG00000000787', u'ENSMUSG00000034453', u'ENSMUSG00000026288', u'ENSMUSG00000028793', u'ENSMUSG00000034218', u'ENSMUSG00000023990', u'ENSMUSG00000025532', u'ENSMUSG00000060550', u'ENSMUSG00000000386', u'ENSMUSG00000052384', u'ENSMUSG00000070034', u'ENSMUSG00000028064', u'ENSMUSG00000027427', u'ENSMUSG00000026928', u'ENSMUSG00000000732', u'ENSMUSG00000020399', u'ENSMUSG00000046718', u'ENSMUSG00000013707', u'ENSMUSG00000030793', u'ENSMUSG00000021457', u'ENSMUSG00000074896', u'ENSMUSG00000024948', u'ENSMUSG00000031639', u'ENSMUSG00000020823', u'ENSMUSG00000025498', u'ENSMUSG00000047798', u'ENSMUSG00000026285', u'ENSMUSG00000032508', u'ENSMUSG00000024339', u'ENSMUSG00000002602', u'ENSMUSG00000053647', u'ENSMUSG00000060591', u'ENSMUSG00000041439', u'ENSMUSG00000032076', u'ENSMUSG00000024235', u'ENSMUSG00000001150', u'ENSMUSG00000027508', u'ENSMUSG00000036896', u'ENSMUSG00000071203', u'ENSMUSG00000079547', u'ENSMUSG00000030880', u'ENSMUSG00000041135', u'ENSMUSG00000024392', u'ENSMUSG00000022575', u'ENSMUSG00000021624', u'ENSMUSG00000020707', u'ENSMUSG00000038213', u'ENSMUSG00000057058', u'ENSMUSG00000027514', u'ENSMUSG00000037731', u'ENSMUSG00000030122', u'ENSMUSG00000024349', u'ENSMUSG00000033454', u'ENSMUSG00000022514', u'ENSMUSG00000022887', u'ENSMUSG00000036469', u'ENSMUSG00000023973', u'ENSMUSG00000043496', u'ENSMUSG00000020573', u'ENSMUSG00000034652', u'ENSMUSG00000036712', u'ENSMUSG00000025492', u'ENSMUSG00000032109', u'ENSMUSG00000060802', u'ENSMUSG00000029798', u'ENSMUSG00000032344', u'ENSMUSG00000059456', u'ENSMUSG00000026117', u'ENSMUSG00000040296', u'ENSMUSG00000032690', u'ENSMUSG00000040751', u'ENSMUSG00000032905', u'ENSMUSG00000020476', u'ENSMUSG00000004707', u'ENSMUSG00000038160', u'ENSMUSG00000038495', u'ENSMUSG00000001128', u'ENSMUSG00000029771', u'ENSMUSG00000058818', u'ENSMUSG00000040264', u'ENSMUSG00000056851', u'ENSMUSG00000032661', u'ENSMUSG00000067212', u'ENSMUSG00000038521', u'ENSMUSG00000036594', u'ENSMUSG00000031750', u'ENSMUSG00000022508', u'ENSMUSG00000073421', u'ENSMUSG00000041827', u'ENSMUSG00000050335', u'ENSMUSG00000044811', u'ENSMUSG00000026471', u'ENSMUSG00000017830', u'ENSMUSG00000019256', u'ENSMUSG00000023341', u'ENSMUSG00000023224', u'ENSMUSG00000015947', u'ENSMUSG00000020641', u'ENSMUSG00000026778', u'ENSMUSG00000039005', u'ENSMUSG00000026648', u'ENSMUSG00000028059', u'ENSMUSG00000028191', u'ENSMUSG00000054717', u'ENSMUSG00000038260', u'ENSMUSG00000046879', u'ENSMUSG00000021277', u'ENSMUSG00000030748', u'ENSMUSG00000033538', u'ENSMUSG00000028291', u'ENSMUSG00000029217', u'ENSMUSG00000051256', u'ENSMUSG00000066839', u'ENSMUSG00000073411', u'ENSMUSG00000005102', u'ENSMUSG00000029561', u'ENSMUSG00000029915', u'ENSMUSG00000027995', u'ENSMUSG00000044827', u'ENSMUSG00000043279', u'ENSMUSG00000027164', u'ENSMUSG00000026365', u'ENSMUSG00000032322', u'ENSMUSG00000032041', u'ENSMUSG00000034459', u'ENSMUSG00000045038', u'ENSMUSG00000021423', u'ENSMUSG00000038147', u'ENSMUSG00000052889', u'ENSMUSG00000050132', u'ENSMUSG00000032737']), pop_n=13836, p_sm_bonferroni=2.048235556768035e-06, is_obsolete=False, GO='GO:0002376', name='immune system process', pop_count=235, alt_ids=[], level=1, depth=1, enrichment='e', Cluster='Consistent Increase', geneid_set=set([u'ENSMUSG00000040264', u'ENSMUSG00000040751', u'ENSMUSG00000045322', u'ENSMUSG00000026928', u'ENSMUSG00000067212', u'ENSMUSG00000035279', u'ENSMUSG00000030793', u'ENSMUSG00000036594', u'ENSMUSG00000055172', u'ENSMUSG00000031639', u'ENSMUSG00000009585', u'ENSMUSG00000047123', u'ENSMUSG00000073411', u'ENSMUSG00000062593', u'ENSMUSG00000047798', u'ENSMUSG00000024338', u'ENSMUSG00000024339', u'ENSMUSG00000043496', u'ENSMUSG00000029826', u'ENSMUSG00000024621', u'ENSMUSG00000031805', u'ENSMUSG00000024235', u'ENSMUSG00000027508', u'ENSMUSG00000071203', u'ENSMUSG00000079547', u'ENSMUSG00000037860', u'ENSMUSG00000036905', u'ENSMUSG00000032312', u'ENSMUSG00000061232', u'ENSMUSG00000038213', u'ENSMUSG00000020707', u'ENSMUSG00000028191', u'ENSMUSG00000057058', u'ENSMUSG00000037731', u'ENSMUSG00000024349', u'ENSMUSG00000030263', u'ENSMUSG00000003283', u'ENSMUSG00000033538', u'ENSMUSG00000020437', u'ENSMUSG00000029217', u'ENSMUSG00000073421', u'ENSMUSG00000042228', u'ENSMUSG00000036896', u'ENSMUSG00000015947', u'ENSMUSG00000030748', u'ENSMUSG00000021583', u'ENSMUSG00000025492', u'ENSMUSG00000060802', u'ENSMUSG00000029798', u'ENSMUSG00000014599', u'ENSMUSG00000027995', u'ENSMUSG00000027639', u'ENSMUSG00000000275', u'ENSMUSG00000070390', u'ENSMUSG00000032690', u'ENSMUSG00000032691', u'ENSMUSG00000038058', u'ENSMUSG00000021423', u'ENSMUSG00000031838', u'ENSMUSG00000043279', u'ENSMUSG00000060550']), symbols=u'Aim2 Apobec3 B2m Bcl10 C1qb C1qc C1ra Card9 Casp4 Cd300lf Csf1 Csf1r Csk Erap1 Fcgr1 Gbp2b H2-Aa H2-Ab1 H2-D1 H2-DMb1 H2-K1 H2-Q7 H2-T23 Hck Herc6 Ifi30 Ifitm3 Il4ra Jak3 Lat2 Lilrb4a Lrmp Ly86 Lyn Map3k8 Myo1g Naip5 Nlrp1b Nlrp3 Nod1 Oas2 Pag1 Psmb8 Pycard Rnf135 Samhd1 Skap1 Ssc5d Tap2 Tapbpl Tec Themis2 Ticam1 Tlr2 Tlr3 Tlr9 Tmem173 Tril Trim25 Trim56 Zc3hav1', symbol_set=set(['Gbp2b', u'Ifitm3', u'Casp4', u'Tec', u'Csf1', u'Csk', u'Tapbpl', u'Naip5', u'Pag1', u'Ifi30', u'Aim2', u'Apobec3', u'Card9', 'H2-D1', u'Hck', u'Psmb8', u'Pycard', u'Bcl10', u'Ticam1', 'H2-K1', 'Ssc5d', 'H2-T23', u'Skap1', u'C1qc', u'C1qb', u'Cd300lf', u'B2m', u'Oas2', u'Herc6', u'Csf1r', u'Lrmp', u'Trim56', u'Tmem173', u'Zc3hav1', u'Map3k8', u'Tap2', u'Il4ra', u'Nlrp3', u'Lat2', 'Lilrb4a', 'H2-Q7', u'Ly86', 'H2-Aa', 'H2-DMb1', u'Tril', u'Erap1', u'Samhd1', u'Nlrp1b', u'Myo1g', 'H2-Ab1', u'C1ra', u'Tlr2', u'Tlr3', 'Themis2', u'Nod1', u'Jak3', u'Trim25', u'Lyn', u'Tlr9', u'Fcgr1', u'Rnf135']), geneids='ENSMUSG00000040264 ENSMUSG00000045322 ENSMUSG00000026928 ENSMUSG00000067212 ENSMUSG00000035279 ENSMUSG00000020437 ENSMUSG00000036594 ENSMUSG00000055172 ENSMUSG00000031639 ENSMUSG00000009585 ENSMUSG00000047123 ENSMUSG00000040751 ENSMUSG00000071203 ENSMUSG00000047798 ENSMUSG00000024338 ENSMUSG00000024339 ENSMUSG00000043496 ENSMUSG00000029826 ENSMUSG00000024621 ENSMUSG00000073421 ENSMUSG00000031805 ENSMUSG00000015947 ENSMUSG00000027508 ENSMUSG00000037731 ENSMUSG00000079547 ENSMUSG00000037860 ENSMUSG00000036905 ENSMUSG00000032312 ENSMUSG00000061232 ENSMUSG00000038213 ENSMUSG00000020707 ENSMUSG00000028191 ENSMUSG00000057058 ENSMUSG00000043279 ENSMUSG00000025492 ENSMUSG00000030263 ENSMUSG00000003283 ENSMUSG00000033538 ENSMUSG00000030793 ENSMUSG00000073411 ENSMUSG00000029217 ENSMUSG00000062593 ENSMUSG00000042228 ENSMUSG00000036896 ENSMUSG00000021583 ENSMUSG00000024349 ENSMUSG00000031838 ENSMUSG00000060802 ENSMUSG00000029798 ENSMUSG00000014599 ENSMUSG00000027995 ENSMUSG00000027639 ENSMUSG00000000275 ENSMUSG00000030748 ENSMUSG00000032690 ENSMUSG00000032691 ENSMUSG00000038058 ENSMUSG00000070390 ENSMUSG00000021423 ENSMUSG00000024235 ENSMUSG00000060550', format_txt=1, hdr_idx=1, is_hdrgo=True, is_usrgo=True, hdr1usr01='**', dcnt=572, D1='L', GO_name='immune system process'),
    Nt(p_uncorrected=2.9764833787115223e-05, study_count=5, study_n=794, namespace='biological_process', p_fdr_bh=0.011274174917714569, study_items=set([u'ENSMUSG00000036461', u'ENSMUSG00000022500', u'ENSMUSG00000042228', u'ENSMUSG00000032312', u'ENSMUSG00000038235']), NS='BP', pop_items=set([u'ENSMUSG00000036461', u'ENSMUSG00000021277', u'ENSMUSG00000022208', u'ENSMUSG00000030536', u'ENSMUSG00000022500', u'ENSMUSG00000042228', u'ENSMUSG00000032312', u'ENSMUSG00000038235']), pop_n=13836, p_sm_bonferroni=0.45096699670858276, is_obsolete=False, GO='GO:0001817', name='regulation of cytokine production', pop_count=8, alt_ids=[], level=4, depth=4, enrichment='e', Cluster='Consistent Increase', geneid_set=set([u'ENSMUSG00000042228', u'ENSMUSG00000022500', u'ENSMUSG00000036461', u'ENSMUSG00000032312', u'ENSMUSG00000038235']), symbols=u'Csk Elf1 F11r Litaf Lyn', symbol_set=set([u'Elf1', u'Lyn', u'Litaf', u'F11r', u'Csk']), geneids='ENSMUSG00000042228 ENSMUSG00000022500 ENSMUSG00000036461 ENSMUSG00000032312 ENSMUSG00000038235', format_txt=1, hdr_idx=1, is_hdrgo=True, is_usrgo=True, hdr1usr01='**', dcnt=476, D1='A', GO_name='regulation of cytokine production'),
    Nt(p_uncorrected=0.00018831346875026884, study_count=3, study_n=794, namespace='biological_process', p_fdr_bh=0.04322935401568671, study_items=set([u'ENSMUSG00000031639', u'ENSMUSG00000021408', u'ENSMUSG00000024778']), NS='BP', pop_items=set([u'ENSMUSG00000031639', u'ENSMUSG00000021408', u'ENSMUSG00000024778']), pop_n=13836, p_sm_bonferroni=1.0, is_obsolete=False, GO='GO:0097527', name='necroptotic signaling pathway', pop_count=3, alt_ids=[], level=3, depth=5, enrichment='e', Cluster='Consistent Increase', geneid_set=set([u'ENSMUSG00000031639', u'ENSMUSG00000021408', u'ENSMUSG00000024778']), symbols=u'Fas Ripk1 Tlr3', symbol_set=set([u'Ripk1', u'Tlr3', u'Fas']), geneids='ENSMUSG00000031639 ENSMUSG00000021408 ENSMUSG00000024778', format_txt=1, hdr_idx=1, is_hdrgo=True, is_usrgo=True, hdr1usr01='**', dcnt=0, D1='AB', GO_name='necroptotic signaling pathway'),
    Nt(p_uncorrected=1.1072215607900484e-06, study_count=14, study_n=794, namespace='biological_process', p_fdr_bh=0.0007625233576150012, study_items=set([u'ENSMUSG00000021583', u'ENSMUSG00000062593', u'ENSMUSG00000028191', u'ENSMUSG00000057058', u'ENSMUSG00000024339', u'ENSMUSG00000026321', u'ENSMUSG00000020437', u'ENSMUSG00000031805', u'ENSMUSG00000027508', u'ENSMUSG00000067212', u'ENSMUSG00000029217', u'ENSMUSG00000040751', u'ENSMUSG00000042228', u'ENSMUSG00000032312']), NS='BP', pop_items=set([u'ENSMUSG00000026648', u'ENSMUSG00000028064', u'ENSMUSG00000000732', u'ENSMUSG00000020437', u'ENSMUSG00000021457', u'ENSMUSG00000037321', u'ENSMUSG00000020476', u'ENSMUSG00000031990', u'ENSMUSG00000004707', u'ENSMUSG00000023990', u'ENSMUSG00000018446', u'ENSMUSG00000038260', u'ENSMUSG00000022636', u'ENSMUSG00000024339', u'ENSMUSG00000004730', u'ENSMUSG00000041439', u'ENSMUSG00000031805', u'ENSMUSG00000024767', u'ENSMUSG00000027508', u'ENSMUSG00000036908', u'ENSMUSG00000019843', u'ENSMUSG00000041135', u'ENSMUSG00000032312', u'ENSMUSG00000058818', u'ENSMUSG00000026812', u'ENSMUSG00000049686', u'ENSMUSG00000022901', u'ENSMUSG00000059456', u'ENSMUSG00000028191', u'ENSMUSG00000024789', u'ENSMUSG00000028793', u'ENSMUSG00000039936', u'ENSMUSG00000038128', u'ENSMUSG00000023915', u'ENSMUSG00000029217', u'ENSMUSG00000062593', u'ENSMUSG00000042228', u'ENSMUSG00000021583', u'ENSMUSG00000041187', u'ENSMUSG00000032216', u'ENSMUSG00000005102', u'ENSMUSG00000025702', u'ENSMUSG00000024610', u'ENSMUSG00000026321', u'ENSMUSG00000026117', u'ENSMUSG00000020399', u'ENSMUSG00000000134', u'ENSMUSG00000040751', u'ENSMUSG00000051212', u'ENSMUSG00000057058', u'ENSMUSG00000067212', u'ENSMUSG00000038147', u'ENSMUSG00000052889']), pop_n=13836, p_sm_bonferroni=0.016775513867530022, is_obsolete=False, GO='GO:0002250', name='adaptive immune response', pop_count=53, alt_ids=[], level=3, depth=3, enrichment='e', Cluster='Consistent Increase', geneid_set=set([u'ENSMUSG00000021583', u'ENSMUSG00000028191', u'ENSMUSG00000057058', u'ENSMUSG00000024339', u'ENSMUSG00000026321', u'ENSMUSG00000020437', u'ENSMUSG00000031805', u'ENSMUSG00000040751', u'ENSMUSG00000032312', u'ENSMUSG00000027508', u'ENSMUSG00000029217', u'ENSMUSG00000062593', u'ENSMUSG00000042228', u'ENSMUSG00000067212']), symbols=u'Bcl10 Csk Erap1 H2-T23 Jak3 Lat2 Lilrb4a Lyn Myo1g Pag1 Skap1 Tap2 Tec Tnfrsf11a', symbol_set=set([u'Erap1', u'Tap2', u'Csk', u'Lat2', u'Myo1g', u'Pag1', 'H2-T23', u'Skap1', u'Tnfrsf11a', 'Lilrb4a', u'Tec', u'Lyn', u'Bcl10', u'Jak3']), geneids='ENSMUSG00000021583 ENSMUSG00000062593 ENSMUSG00000028191 ENSMUSG00000057058 ENSMUSG00000024339 ENSMUSG00000026321 ENSMUSG00000020437 ENSMUSG00000031805 ENSMUSG00000027508 ENSMUSG00000067212 ENSMUSG00000029217 ENSMUSG00000040751 ENSMUSG00000042228 ENSMUSG00000032312', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=52, D1='FL', GO_name='adaptive immune response'),
    Nt(p_uncorrected=0.0001215684959084734, study_count=5, study_n=794, namespace='biological_process', p_fdr_bh=0.03175662554326346, study_items=set([u'ENSMUSG00000014599', u'ENSMUSG00000022105', u'ENSMUSG00000021408', u'ENSMUSG00000026029', u'ENSMUSG00000022831']), NS='BP', pop_items=set([u'ENSMUSG00000034394', u'ENSMUSG00000026029', u'ENSMUSG00000022831', u'ENSMUSG00000014599', u'ENSMUSG00000021408', u'ENSMUSG00000032501', u'ENSMUSG00000050965', u'ENSMUSG00000031750', u'ENSMUSG00000020644', u'ENSMUSG00000022105']), pop_n=13836, p_sm_bonferroni=1.0, is_obsolete=False, GO='GO:0045651', name='positive regulation of macrophage differentiation', pop_count=10, alt_ids=[], level=8, depth=9, enrichment='e', Cluster='Consistent Increase', geneid_set=set([u'ENSMUSG00000014599', u'ENSMUSG00000022105', u'ENSMUSG00000021408', u'ENSMUSG00000026029', u'ENSMUSG00000022831']), symbols=u'Casp8 Csf1 Hcls1 Rb1 Ripk1', symbol_set=set([u'Ripk1', u'Hcls1', u'Casp8', u'Csf1', u'Rb1']), geneids='ENSMUSG00000014599 ENSMUSG00000022105 ENSMUSG00000021408 ENSMUSG00000026029 ENSMUSG00000022831', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=1, D1='A', GO_name='positive regulation of macrophage differentiation'),
    Nt(p_uncorrected=2.1406708605252513e-09, study_count=10, study_n=794, namespace='biological_process', p_fdr_bh=4.05416302597726e-06, study_items=set([u'ENSMUSG00000040264', u'ENSMUSG00000027852', u'ENSMUSG00000053175', u'ENSMUSG00000069874', u'ENSMUSG00000030748', u'ENSMUSG00000028270', u'ENSMUSG00000028268', u'ENSMUSG00000047810', u'ENSMUSG00000041515', u'ENSMUSG00000029298']), NS='BP', pop_items=set([u'ENSMUSG00000040264', u'ENSMUSG00000027852', u'ENSMUSG00000030798', u'ENSMUSG00000053175', u'ENSMUSG00000025499', u'ENSMUSG00000069874', u'ENSMUSG00000028270', u'ENSMUSG00000040253', u'ENSMUSG00000026177', u'ENSMUSG00000030748', u'ENSMUSG00000054072', u'ENSMUSG00000019726', u'ENSMUSG00000028268', u'ENSMUSG00000047810', u'ENSMUSG00000041515', u'ENSMUSG00000029298']), pop_n=13836, p_sm_bonferroni=3.243330420781808e-05, is_obsolete=False, GO='GO:0042832', name='defense response to protozoan', pop_count=16, alt_ids=[], level=5, depth=6, enrichment='e', Cluster='Consistent Increase', geneid_set=set([u'ENSMUSG00000040264', u'ENSMUSG00000027852', u'ENSMUSG00000053175', u'ENSMUSG00000069874', u'ENSMUSG00000030748', u'ENSMUSG00000028270', u'ENSMUSG00000028268', u'ENSMUSG00000047810', u'ENSMUSG00000041515', u'ENSMUSG00000029298']), symbols=u'Bcl3 Ccdc88b Gbp2 Gbp2b Gbp3 Gbp9 Il4ra Irf8 Irgm2 Nras', symbol_set=set(['Gbp2b', u'Gbp9', u'Il4ra', u'Gbp3', u'Gbp2', u'Ccdc88b', u'Irf8', u'Nras', u'Irgm2', u'Bcl3']), geneids='ENSMUSG00000040264 ENSMUSG00000027852 ENSMUSG00000053175 ENSMUSG00000069874 ENSMUSG00000030748 ENSMUSG00000028270 ENSMUSG00000028268 ENSMUSG00000047810 ENSMUSG00000041515 ENSMUSG00000029298', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=1, D1='F', GO_name='defense response to protozoan'),
    Nt(p_uncorrected=2.9764833787115223e-05, study_count=5, study_n=794, namespace='biological_process', p_fdr_bh=0.011274174917714569, study_items=set([u'ENSMUSG00000028268', u'ENSMUSG00000062300', u'ENSMUSG00000040264', u'ENSMUSG00000029298', u'ENSMUSG00000028270']), NS='BP', pop_items=set([u'ENSMUSG00000037405', u'ENSMUSG00000040264', u'ENSMUSG00000040253', u'ENSMUSG00000062300', u'ENSMUSG00000037936', u'ENSMUSG00000028270', u'ENSMUSG00000028268', u'ENSMUSG00000029298']), pop_n=13836, p_sm_bonferroni=0.45096699670858276, is_obsolete=False, GO='GO:0044406', name='adhesion of symbiont to host', pop_count=8, alt_ids=['GO:0051825', 'GO:0051856'], level=2, depth=2, enrichment='e', Cluster='Consistent Increase', geneid_set=set([u'ENSMUSG00000028268', u'ENSMUSG00000062300', u'ENSMUSG00000040264', u'ENSMUSG00000029298', u'ENSMUSG00000028270']), symbols=u'Gbp2 Gbp2b Gbp3 Gbp9 Nectin2', symbol_set=set([u'Gbp3', 'Nectin2', u'Gbp9', 'Gbp2b', u'Gbp2']), geneids='ENSMUSG00000028268 ENSMUSG00000062300 ENSMUSG00000040264 ENSMUSG00000029298 ENSMUSG00000028270', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=22, D1='IP', GO_name='adhesion of symbiont to host'),
    Nt(p_uncorrected=6.627253573428696e-05, study_count=11, study_n=794, namespace='biological_process', p_fdr_bh=0.019309522863657343, study_items=set([u'ENSMUSG00000000555', u'ENSMUSG00000034116', u'ENSMUSG00000000290', u'ENSMUSG00000004508', u'ENSMUSG00000027087', u'ENSMUSG00000029217', u'ENSMUSG00000058715', u'ENSMUSG00000020120', u'ENSMUSG00000007815', u'ENSMUSG00000024965', u'ENSMUSG00000020689']), NS='BP', pop_items=set([u'ENSMUSG00000033721', u'ENSMUSG00000028041', u'ENSMUSG00000021457', u'ENSMUSG00000004508', u'ENSMUSG00000019997', u'ENSMUSG00000058715', u'ENSMUSG00000000555', u'ENSMUSG00000040945', u'ENSMUSG00000027009', u'ENSMUSG00000020857', u'ENSMUSG00000027646', u'ENSMUSG00000042284', u'ENSMUSG00000004364', u'ENSMUSG00000021065', u'ENSMUSG00000026043', u'ENSMUSG00000028874', u'ENSMUSG00000022817', u'ENSMUSG00000001507', u'ENSMUSG00000020758', u'ENSMUSG00000027087', u'ENSMUSG00000015647', u'ENSMUSG00000038264', u'ENSMUSG00000034116', u'ENSMUSG00000030789', u'ENSMUSG00000030786', u'ENSMUSG00000025809', u'ENSMUSG00000026768', u'ENSMUSG00000029528', u'ENSMUSG00000030579', u'ENSMUSG00000029217', u'ENSMUSG00000025348', u'ENSMUSG00000037712', u'ENSMUSG00000043733', u'ENSMUSG00000020689', u'ENSMUSG00000029860', u'ENSMUSG00000000290', u'ENSMUSG00000059456', u'ENSMUSG00000022607', u'ENSMUSG00000024965', u'ENSMUSG00000031425', u'ENSMUSG00000007815', u'ENSMUSG00000058230', u'ENSMUSG00000027111', u'ENSMUSG00000039115', u'ENSMUSG00000030890', u'ENSMUSG00000020120', u'ENSMUSG00000062352', u'ENSMUSG00000031955']), pop_n=13836, p_sm_bonferroni=1.0, is_obsolete=False, GO='GO:0007229', name='integrin-mediated signaling pathway', pop_count=48, alt_ids=[], level=4, depth=6, enrichment='e', Cluster='Consistent Increase', geneid_set=set([u'ENSMUSG00000000555', u'ENSMUSG00000034116', u'ENSMUSG00000000290', u'ENSMUSG00000004508', u'ENSMUSG00000024965', u'ENSMUSG00000029217', u'ENSMUSG00000058715', u'ENSMUSG00000020120', u'ENSMUSG00000007815', u'ENSMUSG00000027087', u'ENSMUSG00000020689']), symbols=u'Fcer1g Fermt3 Gab2 Itga5 Itgav Itgb2 Itgb3 Plek Rhoa Tec Vav1', symbol_set=set([u'Fcer1g', u'Itgb2', u'Vav1', u'Tec', u'Gab2', u'Itga5', u'Itgav', u'Fermt3', u'Itgb3', u'Rhoa', u'Plek']), geneids='ENSMUSG00000000555 ENSMUSG00000034116 ENSMUSG00000000290 ENSMUSG00000004508 ENSMUSG00000027087 ENSMUSG00000029217 ENSMUSG00000058715 ENSMUSG00000020120 ENSMUSG00000007815 ENSMUSG00000024965 ENSMUSG00000020689', format_txt=1, hdr_idx=1, is_hdrgo=True, is_usrgo=True, hdr1usr01='**', dcnt=0, D1='AB', GO_name='integrin-mediated signaling pathway'),
    Nt(p_uncorrected=1.36080987204659e-07, study_count=12, study_n=794, namespace='biological_process', p_fdr_bh=0.00012128017865516403, study_items=set([u'ENSMUSG00000027947', u'ENSMUSG00000029468', u'ENSMUSG00000045322', u'ENSMUSG00000026928', u'ENSMUSG00000027995', u'ENSMUSG00000030793', u'ENSMUSG00000047123', u'ENSMUSG00000038058', u'ENSMUSG00000031639', u'ENSMUSG00000058715', u'ENSMUSG00000079227', u'ENSMUSG00000006519']), NS='BP', pop_items=set([u'ENSMUSG00000031380', u'ENSMUSG00000045322', u'ENSMUSG00000026928', u'ENSMUSG00000030793', u'ENSMUSG00000028291', u'ENSMUSG00000052688', u'ENSMUSG00000031639', u'ENSMUSG00000021994', u'ENSMUSG00000058715', u'ENSMUSG00000024810', u'ENSMUSG00000018500', u'ENSMUSG00000006519', u'ENSMUSG00000032508', u'ENSMUSG00000024256', u'ENSMUSG00000034610', u'ENSMUSG00000047123', u'ENSMUSG00000016024', u'ENSMUSG00000041135', u'ENSMUSG00000039005', u'ENSMUSG00000028059', u'ENSMUSG00000027947', u'ENSMUSG00000029468', u'ENSMUSG00000027551', u'ENSMUSG00000044583', u'ENSMUSG00000027399', u'ENSMUSG00000022708', u'ENSMUSG00000025980', u'ENSMUSG00000027995', u'ENSMUSG00000040296', u'ENSMUSG00000066551', u'ENSMUSG00000038058', u'ENSMUSG00000022749', u'ENSMUSG00000079227']), pop_n=13836, p_sm_bonferroni=0.002061763037137789, is_obsolete=False, GO='GO:0032755', name='positive regulation of interleukin-6 production', pop_count=33, alt_ids=[], level=6, depth=6, enrichment='e', Cluster='Consistent Increase', geneid_set=set([u'ENSMUSG00000027947', u'ENSMUSG00000029468', u'ENSMUSG00000045322', u'ENSMUSG00000026928', u'ENSMUSG00000027995', u'ENSMUSG00000030793', u'ENSMUSG00000047123', u'ENSMUSG00000038058', u'ENSMUSG00000031639', u'ENSMUSG00000058715', u'ENSMUSG00000079227', u'ENSMUSG00000006519']), symbols=u'Card9 Ccr5 Cyba Fcer1g Il6ra Nod1 P2rx7 Pycard Ticam1 Tlr2 Tlr3 Tlr9', symbol_set=set([u'Ticam1', u'Fcer1g', u'Il6ra', u'Tlr2', u'Tlr3', u'Card9', u'Cyba', u'Nod1', u'Ccr5', u'Pycard', u'Tlr9', u'P2rx7']), geneids='ENSMUSG00000027947 ENSMUSG00000029468 ENSMUSG00000045322 ENSMUSG00000026928 ENSMUSG00000027995 ENSMUSG00000030793 ENSMUSG00000047123 ENSMUSG00000038058 ENSMUSG00000031639 ENSMUSG00000058715 ENSMUSG00000079227 ENSMUSG00000006519', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=2, D1='A', GO_name='positive regulation of interleukin-6 production'),
    Nt(p_uncorrected=7.956004359417217e-07, study_count=12, study_n=794, namespace='biological_process', p_fdr_bh=0.0006027071102476514, study_items=set([u'ENSMUSG00000079362', u'ENSMUSG00000038058', u'ENSMUSG00000053175', u'ENSMUSG00000069874', u'ENSMUSG00000042286', u'ENSMUSG00000030341', u'ENSMUSG00000015947', u'ENSMUSG00000015950', u'ENSMUSG00000071203', u'ENSMUSG00000058715', u'ENSMUSG00000041515', u'ENSMUSG00000061232']), NS='BP', pop_items=set([u'ENSMUSG00000039191', u'ENSMUSG00000042286', u'ENSMUSG00000021457', u'ENSMUSG00000022894', u'ENSMUSG00000056501', u'ENSMUSG00000058715', u'ENSMUSG00000030059', u'ENSMUSG00000021948', u'ENSMUSG00000053175', u'ENSMUSG00000069516', u'ENSMUSG00000023078', u'ENSMUSG00000015947', u'ENSMUSG00000016024', u'ENSMUSG00000037523', u'ENSMUSG00000020953', u'ENSMUSG00000071203', u'ENSMUSG00000061232', u'ENSMUSG00000079362', u'ENSMUSG00000015950', u'ENSMUSG00000069874', u'ENSMUSG00000055204', u'ENSMUSG00000030341', u'ENSMUSG00000006403', u'ENSMUSG00000067847', u'ENSMUSG00000026878', u'ENSMUSG00000027878', u'ENSMUSG00000078942', u'ENSMUSG00000078945', u'ENSMUSG00000035692', u'ENSMUSG00000029484', u'ENSMUSG00000045827', u'ENSMUSG00000044827', u'ENSMUSG00000026177', u'ENSMUSG00000020149', u'ENSMUSG00000038058', u'ENSMUSG00000019726', u'ENSMUSG00000016206', u'ENSMUSG00000041515']), pop_n=13836, p_sm_bonferroni=0.012054142204953025, is_obsolete=False, GO='GO:0042742', name='defense response to bacterium', pop_count=38, alt_ids=['GO:0042830'], level=5, depth=6, enrichment='e', Cluster='Consistent Increase', geneid_set=set([u'ENSMUSG00000079362', u'ENSMUSG00000015950', u'ENSMUSG00000053175', u'ENSMUSG00000069874', u'ENSMUSG00000042286', u'ENSMUSG00000030341', u'ENSMUSG00000015947', u'ENSMUSG00000038058', u'ENSMUSG00000071203', u'ENSMUSG00000058715', u'ENSMUSG00000041515', u'ENSMUSG00000061232']), symbols=u'Bcl3 Fcer1g Fcgr1 Gm43302 H2-K1 Irf8 Irgm2 Naip5 Ncf1 Nod1 Stab1 Tnfrsf1a', symbol_set=set([u'Ncf1', u'Stab1', u'Tnfrsf1a', u'Naip5', u'Irf8', u'Fcer1g', 'Gm43302', u'Nod1', u'Fcgr1', u'Irgm2', u'Bcl3', 'H2-K1']), geneids='ENSMUSG00000079362 ENSMUSG00000015950 ENSMUSG00000053175 ENSMUSG00000069874 ENSMUSG00000042286 ENSMUSG00000030341 ENSMUSG00000015947 ENSMUSG00000038058 ENSMUSG00000071203 ENSMUSG00000041515 ENSMUSG00000058715 ENSMUSG00000061232', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=8, D1='F', GO_name='defense response to bacterium'),
]
