"""GOATOOLS GOEA on 2015 Gjoneska data using go-basic.obo: fmt(1.2) rel(2017-01-12) 47,943 GO Terms"""

# Created: 2017-01-13
import collections as cx

nt_fields = [
    "p_uncorrected",
    "study_count",
    "study_n",
    "namespace",
    "p_fdr_bh",
    "study_items",
    "NS",
    "pop_items",
    "pop_n",
    "p_sm_bonferroni",
    "is_obsolete",
    "GO",
    "name",
    "pop_count",
    "alt_ids",
    "level",
    "depth",
    "enrichment",
    "Cluster",
    "geneid_set",
    "symbols",
    "symbol_set",
    "geneids",
    "format_txt",
    "hdr_idx",
    "is_hdrgo",
    "is_usrgo",
    "hdr1usr01",
    "dcnt",
    "D1",
    "GO_name",
]

Nt = cx.namedtuple("Nt", " ".join(nt_fields))

# 33 items
nts = [
    Nt(p_uncorrected='', study_count='', study_n='', namespace='', p_fdr_bh='', study_items='', NS='BP', pop_items='', pop_n='', p_sm_bonferroni='', is_obsolete='', GO='GO:0042391', name='', pop_count='', alt_ids='', level=3, depth=3, enrichment='', Cluster='', geneid_set='', symbols='', symbol_set='', geneids='', format_txt=1, hdr_idx=1, is_hdrgo=True, is_usrgo=False, hdr1usr01='*', dcnt=133, D1='A', GO_name='regulation of membrane potential'),
    Nt(p_uncorrected=8.125178516576727e-05, study_count=14, study_n=1029, namespace='biological_process', p_fdr_bh=0.027978313569239546, study_items=set([u'ENSMUSG00000031393', u'ENSMUSG00000024109', u'ENSMUSG00000027950', u'ENSMUSG00000037996', u'ENSMUSG00000020402', u'ENSMUSG00000002997', u'ENSMUSG00000026080', u'ENSMUSG00000039419', u'ENSMUSG00000027568', u'ENSMUSG00000039913', u'ENSMUSG00000048482', u'ENSMUSG00000026959', u'ENSMUSG00000037685', u'ENSMUSG00000017740']), NS='BP', pop_items=set([u'ENSMUSG00000059003', u'ENSMUSG00000030310', u'ENSMUSG00000008892', u'ENSMUSG00000013662', u'ENSMUSG00000032487', u'ENSMUSG00000027950', u'ENSMUSG00000037996', u'ENSMUSG00000026596', u'ENSMUSG00000000326', u'ENSMUSG00000030376', u'ENSMUSG00000028664', u'ENSMUSG00000023826', u'ENSMUSG00000031302', u'ENSMUSG00000063434', u'ENSMUSG00000022623', u'ENSMUSG00000031137', u'ENSMUSG00000037541', u'ENSMUSG00000029104', u'ENSMUSG00000037685', u'ENSMUSG00000079055', u'ENSMUSG00000002997', u'ENSMUSG00000005102', u'ENSMUSG00000052087', u'ENSMUSG00000022208', u'ENSMUSG00000029838', u'ENSMUSG00000047250', u'ENSMUSG00000055254', u'ENSMUSG00000022240', u'ENSMUSG00000022973', u'ENSMUSG00000021314', u'ENSMUSG00000039419', u'ENSMUSG00000017740', u'ENSMUSG00000048482', u'ENSMUSG00000042453', u'ENSMUSG00000045903', u'ENSMUSG00000062014', u'ENSMUSG00000031393', u'ENSMUSG00000030209', u'ENSMUSG00000035898', u'ENSMUSG00000027792', u'ENSMUSG00000024109', u'ENSMUSG00000049583', u'ENSMUSG00000039059', u'ENSMUSG00000020402', u'ENSMUSG00000026080', u'ENSMUSG00000021478', u'ENSMUSG00000039913', u'ENSMUSG00000026959', u'ENSMUSG00000074923', u'ENSMUSG00000053164', u'ENSMUSG00000027568', u'ENSMUSG00000052684', u'ENSMUSG00000021877', u'ENSMUSG00000028546', u'ENSMUSG00000025318', u'ENSMUSG00000036678', u'ENSMUSG00000032327', u'ENSMUSG00000063239', u'ENSMUSG00000053024']), pop_n=13836, p_sm_bonferroni=1.0, is_obsolete=False, GO='GO:0007612', name='learning', pop_count=59, alt_ids=[], level=4, depth=6, enrichment='e', Cluster='Consistent Decrease', geneid_set=set([u'ENSMUSG00000031393', u'ENSMUSG00000037996', u'ENSMUSG00000027950', u'ENSMUSG00000024109', u'ENSMUSG00000020402', u'ENSMUSG00000002997', u'ENSMUSG00000026080', u'ENSMUSG00000039419', u'ENSMUSG00000027568', u'ENSMUSG00000039913', u'ENSMUSG00000048482', u'ENSMUSG00000026959', u'ENSMUSG00000037685', u'ENSMUSG00000017740']), symbols=u'Atp8a1 Bdnf Chrnb2 Chst10 Cntnap2 Grin1 Mecp2 Nrxn1 Ntsr1 Pak7 Prkar2b Slc12a5 Slc24a2 Vdac1', symbol_set=set([u'Chst10', u'Atp8a1', u'Cntnap2', u'Mecp2', u'Chrnb2', u'Slc24a2', u'Nrxn1', u'Ntsr1', u'Slc12a5', u'Prkar2b', u'Grin1', u'Vdac1', u'Pak7', u'Bdnf']), geneids='ENSMUSG00000031393 ENSMUSG00000027568 ENSMUSG00000037996 ENSMUSG00000027950 ENSMUSG00000024109 ENSMUSG00000020402 ENSMUSG00000002997 ENSMUSG00000026080 ENSMUSG00000039419 ENSMUSG00000017740 ENSMUSG00000039913 ENSMUSG00000048482 ENSMUSG00000026959 ENSMUSG00000037685', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=14, D1='CJN', GO_name='learning'),
    Nt(p_uncorrected=7.719243784374061e-05, study_count=8, study_n=1029, namespace='biological_process', p_fdr_bh=0.02734428001006575, study_items=set([u'ENSMUSG00000067242', u'ENSMUSG00000039953', u'ENSMUSG00000022607', u'ENSMUSG00000056073', u'ENSMUSG00000030898', u'ENSMUSG00000008153', u'ENSMUSG00000035864', u'ENSMUSG00000029053']), NS='BP', pop_items=set([u'ENSMUSG00000021546', u'ENSMUSG00000067242', u'ENSMUSG00000025889', u'ENSMUSG00000039953', u'ENSMUSG00000032452', u'ENSMUSG00000022607', u'ENSMUSG00000035385', u'ENSMUSG00000005360', u'ENSMUSG00000032714', u'ENSMUSG00000033981', u'ENSMUSG00000030209', u'ENSMUSG00000033208', u'ENSMUSG00000056073', u'ENSMUSG00000030898', u'ENSMUSG00000008153', u'ENSMUSG00000062661', u'ENSMUSG00000035864', u'ENSMUSG00000035773', u'ENSMUSG00000020524', u'ENSMUSG00000020886', u'ENSMUSG00000029053']), pop_n=13836, p_sm_bonferroni=1.0, is_obsolete=False, GO='GO:0050806', name='positive regulation of synaptic transmission', pop_count=21, alt_ids=[], level=5, depth=6, enrichment='e', Cluster='Consistent Decrease', geneid_set=set([u'ENSMUSG00000067242', u'ENSMUSG00000039953', u'ENSMUSG00000022607', u'ENSMUSG00000056073', u'ENSMUSG00000030898', u'ENSMUSG00000008153', u'ENSMUSG00000035864', u'ENSMUSG00000029053']), symbols=u'Cckbr Clstn1 Clstn3 Grik2 Lgi1 Prkcz Ptk2 Syt1', symbol_set=set([u'Cckbr', u'Ptk2', u'Syt1', u'Grik2', u'Prkcz', u'Lgi1', u'Clstn1', u'Clstn3']), geneids='ENSMUSG00000067242 ENSMUSG00000008153 ENSMUSG00000022607 ENSMUSG00000056073 ENSMUSG00000030898 ENSMUSG00000039953 ENSMUSG00000035864 ENSMUSG00000029053', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=26, D1='A', GO_name='positive regulation of synaptic transmission'),
    Nt(p_uncorrected=5.5637294791844706e-05, study_count=6, study_n=1029, namespace='biological_process', p_fdr_bh=0.02161437572798049, study_items=set([u'ENSMUSG00000002010', u'ENSMUSG00000027406', u'ENSMUSG00000026827', u'ENSMUSG00000050627', u'ENSMUSG00000020321', u'ENSMUSG00000032279']), NS='BP', pop_items=set([u'ENSMUSG00000002010', u'ENSMUSG00000028452', u'ENSMUSG00000023019', u'ENSMUSG00000019179', u'ENSMUSG00000004789', u'ENSMUSG00000020456', u'ENSMUSG00000027406', u'ENSMUSG00000026827', u'ENSMUSG00000032279', u'ENSMUSG00000020321', u'ENSMUSG00000050627']), pop_n=13836, p_sm_bonferroni=0.8429606533912392, is_obsolete=False, GO='GO:0006734', name='NADH metabolic process', pop_count=11, alt_ids=[], level=8, depth=11, enrichment='e', Cluster='Consistent Decrease', geneid_set=set([u'ENSMUSG00000002010', u'ENSMUSG00000027406', u'ENSMUSG00000032279', u'ENSMUSG00000020321', u'ENSMUSG00000050627', u'ENSMUSG00000026827']), symbols=u'Gpd1l Gpd2 Idh3a Idh3b Idh3g Mdh1', symbol_set=set([u'Idh3a', u'Idh3b', u'Idh3g', u'Mdh1', u'Gpd2', u'Gpd1l']), geneids='ENSMUSG00000002010 ENSMUSG00000027406 ENSMUSG00000026827 ENSMUSG00000050627 ENSMUSG00000020321 ENSMUSG00000032279', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=6, D1='BCD', GO_name='NADH metabolic process'),
    Nt(p_uncorrected='', study_count='', study_n='', namespace='', p_fdr_bh='', study_items='', NS='BP', pop_items='', pop_n='', p_sm_bonferroni='', is_obsolete='', GO='GO:0050804', name='', pop_count='', alt_ids='', level=4, depth=5, enrichment='', Cluster='', geneid_set='', symbols='', symbol_set='', geneids='', format_txt=1, hdr_idx=1, is_hdrgo=True, is_usrgo=False, hdr1usr01='*', dcnt=126, D1='A', GO_name='modulation of synaptic transmission'),
    Nt(p_uncorrected=0.00014311463159587837, study_count=19, study_n=1029, namespace='biological_process', p_fdr_bh=0.04251627026096379, study_items=set([u'ENSMUSG00000070304', u'ENSMUSG00000022342', u'ENSMUSG00000040896', u'ENSMUSG00000029088', u'ENSMUSG00000019146', u'ENSMUSG00000046480', u'ENSMUSG00000059742', u'ENSMUSG00000053395', u'ENSMUSG00000092083', u'ENSMUSG00000050963', u'ENSMUSG00000044216', u'ENSMUSG00000017412', u'ENSMUSG00000024957', u'ENSMUSG00000019194', u'ENSMUSG00000050556', u'ENSMUSG00000021991', u'ENSMUSG00000038026', u'ENSMUSG00000066189', u'ENSMUSG00000051726']), NS='BP', pop_items=set([u'ENSMUSG00000064210', u'ENSMUSG00000045246', u'ENSMUSG00000026880', u'ENSMUSG00000050556', u'ENSMUSG00000037242', u'ENSMUSG00000009731', u'ENSMUSG00000034402', u'ENSMUSG00000040164', u'ENSMUSG00000038319', u'ENSMUSG00000034659', u'ENSMUSG00000042604', u'ENSMUSG00000075316', u'ENSMUSG00000015968', u'ENSMUSG00000004110', u'ENSMUSG00000004113', u'ENSMUSG00000038026', u'ENSMUSG00000063142', u'ENSMUSG00000028033', u'ENSMUSG00000015340', u'ENSMUSG00000092083', u'ENSMUSG00000053519', u'ENSMUSG00000048677', u'ENSMUSG00000033486', u'ENSMUSG00000022843', u'ENSMUSG00000049281', u'ENSMUSG00000026824', u'ENSMUSG00000024112', u'ENSMUSG00000027895', u'ENSMUSG00000040896', u'ENSMUSG00000044216', u'ENSMUSG00000045053', u'ENSMUSG00000039672', u'ENSMUSG00000056258', u'ENSMUSG00000003352', u'ENSMUSG00000035681', u'ENSMUSG00000019194', u'ENSMUSG00000028631', u'ENSMUSG00000079436', u'ENSMUSG00000064329', u'ENSMUSG00000038077', u'ENSMUSG00000028931', u'ENSMUSG00000016346', u'ENSMUSG00000037579', u'ENSMUSG00000024589', u'ENSMUSG00000042529', u'ENSMUSG00000070304', u'ENSMUSG00000032741', u'ENSMUSG00000069806', u'ENSMUSG00000010066', u'ENSMUSG00000021991', u'ENSMUSG00000043301', u'ENSMUSG00000046480', u'ENSMUSG00000028096', u'ENSMUSG00000053395', u'ENSMUSG00000040724', u'ENSMUSG00000025221', u'ENSMUSG00000023033', u'ENSMUSG00000007041', u'ENSMUSG00000020704', u'ENSMUSG00000047959', u'ENSMUSG00000059742', u'ENSMUSG00000058743', u'ENSMUSG00000030247', u'ENSMUSG00000051331', u'ENSMUSG00000064267', u'ENSMUSG00000043673', u'ENSMUSG00000058248', u'ENSMUSG00000057914', u'ENSMUSG00000031930', u'ENSMUSG00000032511', u'ENSMUSG00000000197', u'ENSMUSG00000034656', u'ENSMUSG00000040118', u'ENSMUSG00000020331', u'ENSMUSG00000060882', u'ENSMUSG00000024957', u'ENSMUSG00000021730', u'ENSMUSG00000019146', u'ENSMUSG00000041695', u'ENSMUSG00000017412', u'ENSMUSG00000044708', u'ENSMUSG00000022342', u'ENSMUSG00000027827', u'ENSMUSG00000079056', u'ENSMUSG00000050963', u'ENSMUSG00000062785', u'ENSMUSG00000066189', u'ENSMUSG00000051497', u'ENSMUSG00000058975', u'ENSMUSG00000028051', u'ENSMUSG00000074575', u'ENSMUSG00000047976', u'ENSMUSG00000018470', u'ENSMUSG00000023959', u'ENSMUSG00000045404', u'ENSMUSG00000029088', u'ENSMUSG00000022949', u'ENSMUSG00000051726', u'ENSMUSG00000020723', u'ENSMUSG00000020882', u'ENSMUSG00000040373']), pop_n=13836, p_sm_bonferroni=1.0, is_obsolete=False, GO='GO:0034765', name='regulation of ion transmembrane transport', pop_count=101, alt_ids=[], level=6, depth=6, enrichment='e', Cluster='Consistent Decrease', geneid_set=set([u'ENSMUSG00000070304', u'ENSMUSG00000019146', u'ENSMUSG00000059742', u'ENSMUSG00000040896', u'ENSMUSG00000019194', u'ENSMUSG00000044216', u'ENSMUSG00000017412', u'ENSMUSG00000024957', u'ENSMUSG00000050556', u'ENSMUSG00000021991', u'ENSMUSG00000029088', u'ENSMUSG00000092083', u'ENSMUSG00000022342', u'ENSMUSG00000046480', u'ENSMUSG00000053395', u'ENSMUSG00000051726', u'ENSMUSG00000050963', u'ENSMUSG00000038026', u'ENSMUSG00000066189']), symbols=u'Cacna2d3 Cacnb4 Cacng2 Cacng3 Cacng8 Kcnb1 Kcnb2 Kcnd3 Kcnf1 Kcnh7 Kcnip4 Kcnj4 Kcnj9 Kcnk4 Kcns2 Kcnv1 Scn1b Scn2b Scn4b', symbol_set=set([u'Kcnd3', u'Scn4b', u'Kcnj4', u'Kcnk4', u'Kcnj9', u'Kcnh7', u'Kcnf1', u'Cacnb4', u'Cacng8', u'Scn2b', u'Cacng3', u'Scn1b', u'Kcns2', u'Kcnb2', u'Cacna2d3', u'Cacng2', u'Kcnip4', u'Kcnb1', u'Kcnv1']), geneids='ENSMUSG00000019194 ENSMUSG00000022342 ENSMUSG00000092083 ENSMUSG00000019146 ENSMUSG00000046480 ENSMUSG00000053395 ENSMUSG00000040896 ENSMUSG00000070304 ENSMUSG00000044216 ENSMUSG00000051726 ENSMUSG00000017412 ENSMUSG00000024957 ENSMUSG00000066189 ENSMUSG00000050963 ENSMUSG00000050556 ENSMUSG00000021991 ENSMUSG00000038026 ENSMUSG00000059742 ENSMUSG00000029088', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=235, D1='A', GO_name='regulation of ion transmembrane transport'),
    Nt(p_uncorrected=5.182976234192633e-05, study_count=10, study_n=1029, namespace='biological_process', p_fdr_bh=0.021223587276825023, study_items=set([u'ENSMUSG00000070304', u'ENSMUSG00000026576', u'ENSMUSG00000032826', u'ENSMUSG00000040907', u'ENSMUSG00000032366', u'ENSMUSG00000019194', u'ENSMUSG00000024858', u'ENSMUSG00000046480', u'ENSMUSG00000045103', u'ENSMUSG00000028991']), NS='BP', pop_items=set([u'ENSMUSG00000009376', u'ENSMUSG00000070304', u'ENSMUSG00000053093', u'ENSMUSG00000032511', u'ENSMUSG00000090122', u'ENSMUSG00000018379', u'ENSMUSG00000045103', u'ENSMUSG00000045382', u'ENSMUSG00000019194', u'ENSMUSG00000010609', u'ENSMUSG00000026418', u'ENSMUSG00000040907', u'ENSMUSG00000053819', u'ENSMUSG00000038319', u'ENSMUSG00000054640', u'ENSMUSG00000028991', u'ENSMUSG00000020623', u'ENSMUSG00000021540', u'ENSMUSG00000032826', u'ENSMUSG00000026576', u'ENSMUSG00000021313', u'ENSMUSG00000009995', u'ENSMUSG00000024962', u'ENSMUSG00000040734', u'ENSMUSG00000032366', u'ENSMUSG00000024858', u'ENSMUSG00000046480', u'ENSMUSG00000051747', u'ENSMUSG00000049281', u'ENSMUSG00000018932', u'ENSMUSG00000025579']), pop_n=13836, p_sm_bonferroni=0.7852727292425258, is_obsolete=False, GO='GO:0060048', name='cardiac muscle contraction', pop_count=31, alt_ids=[], level=6, depth=6, enrichment='e', Cluster='Consistent Decrease', geneid_set=set([u'ENSMUSG00000070304', u'ENSMUSG00000026576', u'ENSMUSG00000032826', u'ENSMUSG00000040907', u'ENSMUSG00000032366', u'ENSMUSG00000019194', u'ENSMUSG00000024858', u'ENSMUSG00000046480', u'ENSMUSG00000045103', u'ENSMUSG00000028991']), symbols=u'Ank2 Atp1a3 Atp1b1 Dmd Grk2 Mtor Scn1b Scn2b Scn4b Tpm1', symbol_set=set([u'Dmd', 'Grk2', u'Mtor', u'Tpm1', u'Atp1b1', u'Scn2b', u'Ank2', u'Scn1b', u'Atp1a3', u'Scn4b']), geneids='ENSMUSG00000019194 ENSMUSG00000026576 ENSMUSG00000032826 ENSMUSG00000040907 ENSMUSG00000032366 ENSMUSG00000070304 ENSMUSG00000024858 ENSMUSG00000046480 ENSMUSG00000045103 ENSMUSG00000028991', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=0, D1='J', GO_name='cardiac muscle contraction'),
    Nt(p_uncorrected=8.746714329064149e-06, study_count=10, study_n=1029, namespace='biological_process', p_fdr_bh=0.005300858751986036, study_items=set([u'ENSMUSG00000028456', u'ENSMUSG00000006024', u'ENSMUSG00000008153', u'ENSMUSG00000004319', u'ENSMUSG00000056073', u'ENSMUSG00000021448', u'ENSMUSG00000017412', u'ENSMUSG00000026514', u'ENSMUSG00000026959', u'ENSMUSG00000028969']), NS='BP', pop_items=set([u'ENSMUSG00000006024', u'ENSMUSG00000003974', u'ENSMUSG00000036510', u'ENSMUSG00000017412', u'ENSMUSG00000023826', u'ENSMUSG00000003378', u'ENSMUSG00000024873', u'ENSMUSG00000026024', u'ENSMUSG00000024211', u'ENSMUSG00000031538', u'ENSMUSG00000045730', u'ENSMUSG00000026514', u'ENSMUSG00000022935', u'ENSMUSG00000034656', u'ENSMUSG00000027438', u'ENSMUSG00000008153', u'ENSMUSG00000021448', u'ENSMUSG00000028456', u'ENSMUSG00000034799', u'ENSMUSG00000026959', u'ENSMUSG00000071424', u'ENSMUSG00000070570', u'ENSMUSG00000004319', u'ENSMUSG00000056073', u'ENSMUSG00000002771', u'ENSMUSG00000028969']), pop_n=13836, p_sm_bonferroni=0.1325214687996509, is_obsolete=False, GO='GO:0035249', name='synaptic transmission, glutamatergic', pop_count=26, alt_ids=[], level=9, depth=9, enrichment='e', Cluster='Consistent Decrease', geneid_set=set([u'ENSMUSG00000028456', u'ENSMUSG00000006024', u'ENSMUSG00000008153', u'ENSMUSG00000004319', u'ENSMUSG00000056073', u'ENSMUSG00000017412', u'ENSMUSG00000026514', u'ENSMUSG00000026959', u'ENSMUSG00000021448', u'ENSMUSG00000028969']), symbols=u'Cacnb4 Cdk5 Clcn3 Clstn3 Cnih3 Grik2 Grin1 Napa Shc3 Unc13b', symbol_set=set([u'Cnih3', u'Shc3', u'Clcn3', u'Grik2', u'Cacnb4', u'Unc13b', u'Cdk5', u'Napa', u'Grin1', u'Clstn3']), geneids='ENSMUSG00000028456 ENSMUSG00000006024 ENSMUSG00000008153 ENSMUSG00000021448 ENSMUSG00000004319 ENSMUSG00000056073 ENSMUSG00000017412 ENSMUSG00000026514 ENSMUSG00000026959 ENSMUSG00000028969', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=0, D1='BCQ', GO_name='synaptic transmission, glutamatergic'),
    Nt(p_uncorrected='', study_count='', study_n='', namespace='', p_fdr_bh='', study_items='', NS='BP', pop_items='', pop_n='', p_sm_bonferroni='', is_obsolete='', GO='GO:0051186', name='', pop_count='', alt_ids='', level=3, depth=3, enrichment='', Cluster='', geneid_set='', symbols='', symbol_set='', geneids='', format_txt=1, hdr_idx=1, is_hdrgo=True, is_usrgo=False, hdr1usr01='*', dcnt=386, D1='BD', GO_name='cofactor metabolic process'),
    Nt(p_uncorrected=8.089989240395936e-08, study_count=22, study_n=1029, namespace='biological_process', p_fdr_bh=7.660714186327427e-05, study_items=set([u'ENSMUSG00000003872', u'ENSMUSG00000021687', u'ENSMUSG00000031065', u'ENSMUSG00000050556', u'ENSMUSG00000034593', u'ENSMUSG00000026797', u'ENSMUSG00000044912', u'ENSMUSG00000049044', u'ENSMUSG00000031840', u'ENSMUSG00000038453', u'ENSMUSG00000004771', u'ENSMUSG00000024743', u'ENSMUSG00000022829', u'ENSMUSG00000028456', u'ENSMUSG00000053046', u'ENSMUSG00000024261', u'ENSMUSG00000030774', u'ENSMUSG00000046314', u'ENSMUSG00000030731', u'ENSMUSG00000040722', u'ENSMUSG00000035226', u'ENSMUSG00000028969']), NS='BP', pop_items=set([u'ENSMUSG00000008859', u'ENSMUSG00000051586', u'ENSMUSG00000003872', u'ENSMUSG00000063260', u'ENSMUSG00000029763', u'ENSMUSG00000019066', u'ENSMUSG00000027978', u'ENSMUSG00000031993', u'ENSMUSG00000019790', u'ENSMUSG00000020437', u'ENSMUSG00000021357', u'ENSMUSG00000007207', u'ENSMUSG00000019124', u'ENSMUSG00000030731', u'ENSMUSG00000034902', u'ENSMUSG00000036435', u'ENSMUSG00000004626', u'ENSMUSG00000024101', u'ENSMUSG00000020792', u'ENSMUSG00000050556', u'ENSMUSG00000027287', u'ENSMUSG00000020536', u'ENSMUSG00000053841', u'ENSMUSG00000034593', u'ENSMUSG00000028969', u'ENSMUSG00000026797', u'ENSMUSG00000028860', u'ENSMUSG00000006930', u'ENSMUSG00000026696', u'ENSMUSG00000044912', u'ENSMUSG00000052301', u'ENSMUSG00000019906', u'ENSMUSG00000049044', u'ENSMUSG00000031840', u'ENSMUSG00000057948', u'ENSMUSG00000008226', u'ENSMUSG00000004771', u'ENSMUSG00000024743', u'ENSMUSG00000040722', u'ENSMUSG00000002741', u'ENSMUSG00000058420', u'ENSMUSG00000061244', u'ENSMUSG00000025867', u'ENSMUSG00000027882', u'ENSMUSG00000033615', u'ENSMUSG00000074582', u'ENSMUSG00000033595', u'ENSMUSG00000022829', u'ENSMUSG00000034152', u'ENSMUSG00000021567', u'ENSMUSG00000032890', u'ENSMUSG00000032202', u'ENSMUSG00000021687', u'ENSMUSG00000053799', u'ENSMUSG00000039714', u'ENSMUSG00000034799', u'ENSMUSG00000030660', u'ENSMUSG00000017978', u'ENSMUSG00000030337', u'ENSMUSG00000028456', u'ENSMUSG00000053046', u'ENSMUSG00000024261', u'ENSMUSG00000054453', u'ENSMUSG00000027162', u'ENSMUSG00000015668', u'ENSMUSG00000021281', u'ENSMUSG00000030774', u'ENSMUSG00000020877', u'ENSMUSG00000003283', u'ENSMUSG00000030616', u'ENSMUSG00000041488', u'ENSMUSG00000018171', u'ENSMUSG00000074030', u'ENSMUSG00000037386', u'ENSMUSG00000041670', u'ENSMUSG00000020900', u'ENSMUSG00000046314', u'ENSMUSG00000062151', u'ENSMUSG00000035226', u'ENSMUSG00000001018', u'ENSMUSG00000038453', u'ENSMUSG00000031065']), pop_n=13836, p_sm_bonferroni=0.0012257142698123883, is_obsolete=False, GO='GO:0006887', name='exocytosis', pop_count=82, alt_ids=['GO:0016194', 'GO:0016195'], level=4, depth=7, enrichment='e', Cluster='Consistent Decrease', geneid_set=set([u'ENSMUSG00000003872', u'ENSMUSG00000038453', u'ENSMUSG00000030731', u'ENSMUSG00000035226', u'ENSMUSG00000021687', u'ENSMUSG00000031065', u'ENSMUSG00000053046', u'ENSMUSG00000050556', u'ENSMUSG00000028456', u'ENSMUSG00000034593', u'ENSMUSG00000024261', u'ENSMUSG00000030774', u'ENSMUSG00000026797', u'ENSMUSG00000046314', u'ENSMUSG00000044912', u'ENSMUSG00000049044', u'ENSMUSG00000031840', u'ENSMUSG00000022829', u'ENSMUSG00000004771', u'ENSMUSG00000024743', u'ENSMUSG00000040722', u'ENSMUSG00000028969']), symbols=u'Brsk2 Cdk16 Cdk5 Kcnb1 Lin7b Myo5a Pak1 Rab11a Rab3a Rapgef4 Rims4 Scamp1 Scamp5 Srcin1 Stxbp1 Stxbp5l Stxbp6 Syt16 Syt3 Syt4 Syt7 Unc13b', symbol_set=set([u'Brsk2', u'Cdk16', u'Rims4', u'Myo5a', u'Stxbp5l', u'Srcin1', u'Lin7b', u'Syt3', u'Syt4', u'Syt7', u'Rab3a', u'Syt16', u'Scamp5', u'Scamp1', u'Stxbp1', u'Stxbp6', u'Rab11a', u'Rapgef4', u'Unc13b', u'Cdk5', u'Kcnb1', u'Pak1']), geneids='ENSMUSG00000003872 ENSMUSG00000021687 ENSMUSG00000031065 ENSMUSG00000050556 ENSMUSG00000034593 ENSMUSG00000026797 ENSMUSG00000044912 ENSMUSG00000049044 ENSMUSG00000031840 ENSMUSG00000038453 ENSMUSG00000004771 ENSMUSG00000024743 ENSMUSG00000022829 ENSMUSG00000028456 ENSMUSG00000053046 ENSMUSG00000024261 ENSMUSG00000030774 ENSMUSG00000046314 ENSMUSG00000030731 ENSMUSG00000040722 ENSMUSG00000035226 ENSMUSG00000028969', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=27, D1='BCG', GO_name='exocytosis'),
    Nt(p_uncorrected=2.235536728234709e-05, study_count=14, study_n=1029, namespace='biological_process', p_fdr_bh=0.01092600547402712, study_items=set([u'ENSMUSG00000031393', u'ENSMUSG00000046876', u'ENSMUSG00000036564', u'ENSMUSG00000040907', u'ENSMUSG00000027950', u'ENSMUSG00000027210', u'ENSMUSG00000022489', u'ENSMUSG00000061313', u'ENSMUSG00000026959', u'ENSMUSG00000028991', u'ENSMUSG00000002413', u'ENSMUSG00000001105', u'ENSMUSG00000028969', u'ENSMUSG00000037032']), NS='BP', pop_items=set([u'ENSMUSG00000059003', u'ENSMUSG00000020716', u'ENSMUSG00000027950', u'ENSMUSG00000021684', u'ENSMUSG00000021478', u'ENSMUSG00000005949', u'ENSMUSG00000022892', u'ENSMUSG00000019890', u'ENSMUSG00000005672', u'ENSMUSG00000031367', u'ENSMUSG00000025485', u'ENSMUSG00000031302', u'ENSMUSG00000036564', u'ENSMUSG00000035910', u'ENSMUSG00000052087', u'ENSMUSG00000027210', u'ENSMUSG00000058886', u'ENSMUSG00000032405', u'ENSMUSG00000061313', u'ENSMUSG00000039358', u'ENSMUSG00000021109', u'ENSMUSG00000004110', u'ENSMUSG00000051331', u'ENSMUSG00000028991', u'ENSMUSG00000018634', u'ENSMUSG00000021670', u'ENSMUSG00000031393', u'ENSMUSG00000046876', u'ENSMUSG00000030265', u'ENSMUSG00000025809', u'ENSMUSG00000029104', u'ENSMUSG00000025958', u'ENSMUSG00000028541', u'ENSMUSG00000022489', u'ENSMUSG00000026596', u'ENSMUSG00000007097', u'ENSMUSG00000026959', u'ENSMUSG00000050541', u'ENSMUSG00000050321', u'ENSMUSG00000037032', u'ENSMUSG00000032259', u'ENSMUSG00000067629', u'ENSMUSG00000035168', u'ENSMUSG00000053004', u'ENSMUSG00000034987', u'ENSMUSG00000019970', u'ENSMUSG00000048616', u'ENSMUSG00000002028', u'ENSMUSG00000061718', u'ENSMUSG00000040907', u'ENSMUSG00000002413', u'ENSMUSG00000001105', u'ENSMUSG00000028969']), pop_n=13836, p_sm_bonferroni=0.33870616969484074, is_obsolete=False, GO='GO:0008542', name='visual learning', pop_count=53, alt_ids=[], level=4, depth=8, enrichment='e', Cluster='Consistent Decrease', geneid_set=set([u'ENSMUSG00000031393', u'ENSMUSG00000046876', u'ENSMUSG00000036564', u'ENSMUSG00000040907', u'ENSMUSG00000027950', u'ENSMUSG00000027210', u'ENSMUSG00000022489', u'ENSMUSG00000061313', u'ENSMUSG00000026959', u'ENSMUSG00000028991', u'ENSMUSG00000002413', u'ENSMUSG00000001105', u'ENSMUSG00000028969', u'ENSMUSG00000037032']), symbols=u'Apbb1 Atp1a3 Atxn1 Braf Cdk5 Chrnb2 Ddhd2 Grin1 Ift20 Mecp2 Meis2 Mtor Ndrg4 Pde1b', symbol_set=set([u'Cdk5', u'Ddhd2', u'Ift20', u'Pde1b', u'Mecp2', u'Chrnb2', u'Meis2', u'Apbb1', u'Atp1a3', u'Braf', u'Mtor', u'Grin1', u'Ndrg4', u'Atxn1']), geneids='ENSMUSG00000031393 ENSMUSG00000022489 ENSMUSG00000036564 ENSMUSG00000040907 ENSMUSG00000027950 ENSMUSG00000027210 ENSMUSG00000046876 ENSMUSG00000061313 ENSMUSG00000026959 ENSMUSG00000028991 ENSMUSG00000002413 ENSMUSG00000001105 ENSMUSG00000028969 ENSMUSG00000037032', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=0, D1='CFJN', GO_name='visual learning'),
    Nt(p_uncorrected=4.664330199000883e-05, study_count=7, study_n=1029, namespace='biological_process', p_fdr_bh=0.02019121909858925, study_items=set([u'ENSMUSG00000048076', u'ENSMUSG00000026797', u'ENSMUSG00000054423', u'ENSMUSG00000040722', u'ENSMUSG00000035864', u'ENSMUSG00000050556', u'ENSMUSG00000028969']), NS='BP', pop_items=set([u'ENSMUSG00000024112', u'ENSMUSG00000048076', u'ENSMUSG00000026797', u'ENSMUSG00000022416', u'ENSMUSG00000054423', u'ENSMUSG00000007207', u'ENSMUSG00000020866', u'ENSMUSG00000090071', u'ENSMUSG00000035864', u'ENSMUSG00000062542', u'ENSMUSG00000050556', u'ENSMUSG00000020848', u'ENSMUSG00000040722', u'ENSMUSG00000028969', u'ENSMUSG00000063260']), pop_n=13836, p_sm_bonferroni=0.7066926684506238, is_obsolete=False, GO='GO:0045956', name='positive regulation of calcium ion-dependent exocytosis', pop_count=15, alt_ids=[], level=8, depth=10, enrichment='e', Cluster='Consistent Decrease', geneid_set=set([u'ENSMUSG00000028969', u'ENSMUSG00000048076', u'ENSMUSG00000040722', u'ENSMUSG00000035864', u'ENSMUSG00000026797', u'ENSMUSG00000050556', u'ENSMUSG00000054423']), symbols=u'Arf1 Cadps Cdk5 Kcnb1 Scamp5 Stxbp1 Syt1', symbol_set=set([u'Scamp5', u'Syt1', u'Arf1', u'Stxbp1', u'Cdk5', u'Kcnb1', u'Cadps']), geneids='ENSMUSG00000048076 ENSMUSG00000026797 ENSMUSG00000054423 ENSMUSG00000040722 ENSMUSG00000035864 ENSMUSG00000050556 ENSMUSG00000028969', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=9, D1='A', GO_name='positive regulation of calcium ion-dependent exocytosis'),
    Nt(p_uncorrected=0.00017242501601307062, study_count=9, study_n=1029, namespace='biological_process', p_fdr_bh=0.04749838941116424, study_items=set([u'ENSMUSG00000010803', u'ENSMUSG00000004319', u'ENSMUSG00000006576', u'ENSMUSG00000020436', u'ENSMUSG00000017740', u'ENSMUSG00000040441', u'ENSMUSG00000000605', u'ENSMUSG00000029212', u'ENSMUSG00000007653']), NS='BP', pop_items=set([u'ENSMUSG00000010803', u'ENSMUSG00000064210', u'ENSMUSG00000006576', u'ENSMUSG00000028020', u'ENSMUSG00000038257', u'ENSMUSG00000039908', u'ENSMUSG00000036196', u'ENSMUSG00000037242', u'ENSMUSG00000034320', u'ENSMUSG00000020651', u'ENSMUSG00000017740', u'ENSMUSG00000007041', u'ENSMUSG00000033676', u'ENSMUSG00000031075', u'ENSMUSG00000023959', u'ENSMUSG00000020436', u'ENSMUSG00000029212', u'ENSMUSG00000000560', u'ENSMUSG00000004319', u'ENSMUSG00000004317', u'ENSMUSG00000036636', u'ENSMUSG00000029016', u'ENSMUSG00000017756', u'ENSMUSG00000022843', u'ENSMUSG00000022949', u'ENSMUSG00000040441', u'ENSMUSG00000000605', u'ENSMUSG00000007653', u'ENSMUSG00000018589']), pop_n=13836, p_sm_bonferroni=1.0, is_obsolete=False, GO='GO:1902476', name='chloride transmembrane transport', pop_count=29, alt_ids=[], level=8, depth=8, enrichment='e', Cluster='Consistent Decrease', geneid_set=set([u'ENSMUSG00000010803', u'ENSMUSG00000004319', u'ENSMUSG00000006576', u'ENSMUSG00000020436', u'ENSMUSG00000017740', u'ENSMUSG00000040441', u'ENSMUSG00000000605', u'ENSMUSG00000029212', u'ENSMUSG00000007653']), symbols=u'Clcn3 Clcn4 Gabra1 Gabrb1 Gabrb2 Gabrg2 Slc12a5 Slc26a10 Slc4a3', symbol_set=set([u'Clcn3', u'Gabrg2', 'Clcn4', u'Slc12a5', u'Slc4a3', u'Gabrb1', u'Slc26a10', u'Gabra1', u'Gabrb2']), geneids='ENSMUSG00000010803 ENSMUSG00000004319 ENSMUSG00000006576 ENSMUSG00000020436 ENSMUSG00000017740 ENSMUSG00000040441 ENSMUSG00000000605 ENSMUSG00000029212 ENSMUSG00000007653', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=0, D1='G', GO_name='chloride transmembrane transport'),
    Nt(p_uncorrected=2.1139311392278813e-05, study_count=9, study_n=1029, namespace='biological_process', p_fdr_bh=0.01092600547402712, study_items=set([u'ENSMUSG00000072214', u'ENSMUSG00000034593', u'ENSMUSG00000030806', u'ENSMUSG00000021700', u'ENSMUSG00000022829', u'ENSMUSG00000049044', u'ENSMUSG00000031840', u'ENSMUSG00000020894', u'ENSMUSG00000061601']), NS='BP', pop_items=set([u'ENSMUSG00000019066', u'ENSMUSG00000019790', u'ENSMUSG00000007207', u'ENSMUSG00000027287', u'ENSMUSG00000072214', u'ENSMUSG00000024511', u'ENSMUSG00000030805', u'ENSMUSG00000030806', u'ENSMUSG00000006930', u'ENSMUSG00000049044', u'ENSMUSG00000020132', u'ENSMUSG00000020894', u'ENSMUSG00000061601', u'ENSMUSG00000031840', u'ENSMUSG00000033595', u'ENSMUSG00000021700', u'ENSMUSG00000022829', u'ENSMUSG00000034187', u'ENSMUSG00000034593', u'ENSMUSG00000008859', u'ENSMUSG00000079657', u'ENSMUSG00000037386', u'ENSMUSG00000003411']), pop_n=13836, p_sm_bonferroni=0.3202817069044163, is_obsolete=False, GO='GO:0017157', name='regulation of exocytosis', pop_count=23, alt_ids=[], level=5, depth=7, enrichment='e', Cluster='Consistent Decrease', geneid_set=set([u'ENSMUSG00000072214', u'ENSMUSG00000034593', u'ENSMUSG00000030806', u'ENSMUSG00000021700', u'ENSMUSG00000022829', u'ENSMUSG00000049044', u'ENSMUSG00000031840', u'ENSMUSG00000020894', u'ENSMUSG00000061601']), symbols=u'Myo5a Pclo Rab3a Rab3c Rapgef4 Sept5 Stx1b Stxbp5l Vamp2', symbol_set=set([u'Stx1b', u'Rapgef4', u'Vamp2', u'Rab3c', u'Rab3a', 'Sept5', u'Pclo', u'Myo5a', u'Stxbp5l']), geneids='ENSMUSG00000072214 ENSMUSG00000034593 ENSMUSG00000030806 ENSMUSG00000021700 ENSMUSG00000022829 ENSMUSG00000049044 ENSMUSG00000031840 ENSMUSG00000020894 ENSMUSG00000061601', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=63, D1='A', GO_name='regulation of exocytosis'),
    Nt(p_uncorrected='', study_count='', study_n='', namespace='', p_fdr_bh='', study_items='', NS='BP', pop_items='', pop_n='', p_sm_bonferroni='', is_obsolete='', GO='GO:0032501', name='', pop_count='', alt_ids='', level=1, depth=1, enrichment='', Cluster='', geneid_set='', symbols='', symbol_set='', geneids='', format_txt=1, hdr_idx=1, is_hdrgo=True, is_usrgo=False, hdr1usr01='*', dcnt=1011, D1='J', GO_name='multicellular organismal process'),
    Nt(p_uncorrected=4.125645536602021e-06, study_count=21, study_n=1029, namespace='biological_process', p_fdr_bh=0.0027177241532633572, study_items=set([u'ENSMUSG00000092083', u'ENSMUSG00000022342', u'ENSMUSG00000026576', u'ENSMUSG00000037341', u'ENSMUSG00000040907', u'ENSMUSG00000059742', u'ENSMUSG00000052726', u'ENSMUSG00000040896', u'ENSMUSG00000044216', u'ENSMUSG00000036760', u'ENSMUSG00000051726', u'ENSMUSG00000024957', u'ENSMUSG00000002908', u'ENSMUSG00000050963', u'ENSMUSG00000031791', u'ENSMUSG00000033161', u'ENSMUSG00000050556', u'ENSMUSG00000017740', u'ENSMUSG00000038026', u'ENSMUSG00000041771', u'ENSMUSG00000029088']), NS='BP', pop_items=set([u'ENSMUSG00000018470', u'ENSMUSG00000045246', u'ENSMUSG00000025358', u'ENSMUSG00000050556', u'ENSMUSG00000009731', u'ENSMUSG00000034402', u'ENSMUSG00000040164', u'ENSMUSG00000040907', u'ENSMUSG00000038319', u'ENSMUSG00000042604', u'ENSMUSG00000043673', u'ENSMUSG00000038026', u'ENSMUSG00000063142', u'ENSMUSG00000026812', u'ENSMUSG00000028033', u'ENSMUSG00000053519', u'ENSMUSG00000092083', u'ENSMUSG00000054477', u'ENSMUSG00000009907', u'ENSMUSG00000032412', u'ENSMUSG00000039463', u'ENSMUSG00000041771', u'ENSMUSG00000026824', u'ENSMUSG00000027895', u'ENSMUSG00000040896', u'ENSMUSG00000044216', u'ENSMUSG00000039672', u'ENSMUSG00000056258', u'ENSMUSG00000035681', u'ENSMUSG00000034187', u'ENSMUSG00000000794', u'ENSMUSG00000028631', u'ENSMUSG00000024597', u'ENSMUSG00000038077', u'ENSMUSG00000036760', u'ENSMUSG00000033161', u'ENSMUSG00000027827', u'ENSMUSG00000004655', u'ENSMUSG00000043301', u'ENSMUSG00000001901', u'ENSMUSG00000016346', u'ENSMUSG00000037579', u'ENSMUSG00000017756', u'ENSMUSG00000031791', u'ENSMUSG00000041329', u'ENSMUSG00000049265', u'ENSMUSG00000042529', u'ENSMUSG00000057123', u'ENSMUSG00000003031', u'ENSMUSG00000045053', u'ENSMUSG00000033998', u'ENSMUSG00000040724', u'ENSMUSG00000025221', u'ENSMUSG00000017740', u'ENSMUSG00000013495', u'ENSMUSG00000047959', u'ENSMUSG00000059742', u'ENSMUSG00000058740', u'ENSMUSG00000058743', u'ENSMUSG00000030247', u'ENSMUSG00000002908', u'ENSMUSG00000030249', u'ENSMUSG00000029088', u'ENSMUSG00000063873', u'ENSMUSG00000058248', u'ENSMUSG00000079436', u'ENSMUSG00000020331', u'ENSMUSG00000060882', u'ENSMUSG00000044708', u'ENSMUSG00000021730', u'ENSMUSG00000054934', u'ENSMUSG00000041695', u'ENSMUSG00000024957', u'ENSMUSG00000022342', u'ENSMUSG00000026576', u'ENSMUSG00000079056', u'ENSMUSG00000037610', u'ENSMUSG00000050963', u'ENSMUSG00000062785', u'ENSMUSG00000017765', u'ENSMUSG00000051497', u'ENSMUSG00000058975', u'ENSMUSG00000028051', u'ENSMUSG00000074575', u'ENSMUSG00000047976', u'ENSMUSG00000028420', u'ENSMUSG00000045404', u'ENSMUSG00000028931', u'ENSMUSG00000007097', u'ENSMUSG00000037341', u'ENSMUSG00000052726', u'ENSMUSG00000051726', u'ENSMUSG00000022742', u'ENSMUSG00000037624']), pop_n=13836, p_sm_bonferroni=0.06250765552505722, is_obsolete=False, GO='GO:0006813', name='potassium ion transport', pop_count=94, alt_ids=['GO:0015458'], level=7, depth=7, enrichment='e', Cluster='Consistent Decrease', geneid_set=set([u'ENSMUSG00000059742', u'ENSMUSG00000040896', u'ENSMUSG00000044216', u'ENSMUSG00000036760', u'ENSMUSG00000024957', u'ENSMUSG00000033161', u'ENSMUSG00000050556', u'ENSMUSG00000031791', u'ENSMUSG00000092083', u'ENSMUSG00000022342', u'ENSMUSG00000026576', u'ENSMUSG00000037341', u'ENSMUSG00000040907', u'ENSMUSG00000052726', u'ENSMUSG00000051726', u'ENSMUSG00000017740', u'ENSMUSG00000050963', u'ENSMUSG00000029088', u'ENSMUSG00000038026', u'ENSMUSG00000041771', u'ENSMUSG00000002908']), symbols=u'Atp1a1 Atp1a3 Atp1b1 Kcnb1 Kcnb2 Kcnd3 Kcnf1 Kcnh7 Kcnip4 Kcnj4 Kcnj9 Kcnk4 Kcnk9 Kcnn1 Kcns2 Kcnt2 Kcnv1 Slc12a5 Slc24a4 Slc9a7 Tmem38a', symbol_set=set([u'Tmem38a', u'Kcnh7', u'Slc9a7', u'Kcnk9', u'Kcnj4', u'Kcnk4', u'Kcnn1', u'Kcnj9', u'Kcnd3', u'Kcnf1', u'Atp1b1', u'Slc12a5', u'Kcnt2', u'Atp1a3', u'Atp1a1', u'Kcns2', u'Kcnb2', u'Kcnb1', u'Kcnip4', u'Slc24a4', u'Kcnv1']), geneids='ENSMUSG00000092083 ENSMUSG00000022342 ENSMUSG00000026576 ENSMUSG00000037341 ENSMUSG00000040907 ENSMUSG00000059742 ENSMUSG00000052726 ENSMUSG00000017740 ENSMUSG00000050963 ENSMUSG00000044216 ENSMUSG00000036760 ENSMUSG00000051726 ENSMUSG00000040896 ENSMUSG00000024957 ENSMUSG00000002908 ENSMUSG00000031791 ENSMUSG00000033161 ENSMUSG00000050556 ENSMUSG00000038026 ENSMUSG00000041771 ENSMUSG00000029088', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=7, D1='G', GO_name='potassium ion transport'),
    Nt(p_uncorrected=7.237675305058032e-05, study_count=16, study_n=1029, namespace='biological_process', p_fdr_bh=0.026745858182179085, study_items=set([u'ENSMUSG00000030302', u'ENSMUSG00000039953', u'ENSMUSG00000026576', u'ENSMUSG00000032826', u'ENSMUSG00000029467', u'ENSMUSG00000056073', u'ENSMUSG00000037996', u'ENSMUSG00000015342', u'ENSMUSG00000032570', u'ENSMUSG00000026463', u'ENSMUSG00000034997', u'ENSMUSG00000026959', u'ENSMUSG00000038486', u'ENSMUSG00000017412', u'ENSMUSG00000041771', u'ENSMUSG00000041468']), NS='BP', pop_items=set([u'ENSMUSG00000020303', u'ENSMUSG00000039953', u'ENSMUSG00000021665', u'ENSMUSG00000032570', u'ENSMUSG00000030592', u'ENSMUSG00000020788', u'ENSMUSG00000037996', u'ENSMUSG00000030376', u'ENSMUSG00000017412', u'ENSMUSG00000030409', u'ENSMUSG00000030659', u'ENSMUSG00000030525', u'ENSMUSG00000057378', u'ENSMUSG00000063873', u'ENSMUSG00000032462', u'ENSMUSG00000026576', u'ENSMUSG00000027887', u'ENSMUSG00000021814', u'ENSMUSG00000052488', u'ENSMUSG00000002603', u'ENSMUSG00000019943', u'ENSMUSG00000032826', u'ENSMUSG00000025809', u'ENSMUSG00000032114', u'ENSMUSG00000031376', u'ENSMUSG00000002985', u'ENSMUSG00000050965', u'ENSMUSG00000034997', u'ENSMUSG00000034462', u'ENSMUSG00000078201', u'ENSMUSG00000014158', u'ENSMUSG00000019969', u'ENSMUSG00000014813', u'ENSMUSG00000032492', u'ENSMUSG00000027524', u'ENSMUSG00000070730', u'ENSMUSG00000030302', u'ENSMUSG00000041380', u'ENSMUSG00000048939', u'ENSMUSG00000036622', u'ENSMUSG00000029467', u'ENSMUSG00000015342', u'ENSMUSG00000038094', u'ENSMUSG00000021313', u'ENSMUSG00000022533', u'ENSMUSG00000051331', u'ENSMUSG00000041809', u'ENSMUSG00000039156', u'ENSMUSG00000054640', u'ENSMUSG00000026959', u'ENSMUSG00000031862', u'ENSMUSG00000020689', u'ENSMUSG00000054455', u'ENSMUSG00000028455', u'ENSMUSG00000038486', u'ENSMUSG00000037434', u'ENSMUSG00000048677', u'ENSMUSG00000026463', u'ENSMUSG00000035385', u'ENSMUSG00000032648', u'ENSMUSG00000057329', u'ENSMUSG00000056073', u'ENSMUSG00000033208', u'ENSMUSG00000029234', u'ENSMUSG00000030987', u'ENSMUSG00000027087', u'ENSMUSG00000079055', u'ENSMUSG00000031770', u'ENSMUSG00000007655', u'ENSMUSG00000052889', u'ENSMUSG00000037940', u'ENSMUSG00000041771', u'ENSMUSG00000041468']), pop_n=13836, p_sm_bonferroni=1.0, is_obsolete=False, GO='GO:0006874', name='cellular calcium ion homeostasis', pop_count=73, alt_ids=[], level=8, depth=9, enrichment='e', Cluster='Consistent Decrease', geneid_set=set([u'ENSMUSG00000030302', u'ENSMUSG00000032570', u'ENSMUSG00000032826', u'ENSMUSG00000029467', u'ENSMUSG00000037996', u'ENSMUSG00000015342', u'ENSMUSG00000017412', u'ENSMUSG00000026959', u'ENSMUSG00000039953', u'ENSMUSG00000026576', u'ENSMUSG00000026463', u'ENSMUSG00000056073', u'ENSMUSG00000034997', u'ENSMUSG00000038486', u'ENSMUSG00000041771', u'ENSMUSG00000041468']), symbols=u'Ank2 Atp1b1 Atp2a2 Atp2b2 Atp2b4 Atp2c1 Cacnb4 Clstn1 Gpr12 Grik2 Grin1 Htr2a Slc24a2 Slc24a4 Sv2a Xk', symbol_set=set([u'Xk', u'Atp2c1', u'Gpr12', u'Atp2a2', u'Atp1b1', u'Grik2', u'Slc24a2', u'Cacnb4', u'Slc24a4', u'Ank2', u'Atp2b4', u'Htr2a', u'Sv2a', u'Grin1', u'Atp2b2', u'Clstn1']), geneids='ENSMUSG00000030302 ENSMUSG00000039953 ENSMUSG00000026576 ENSMUSG00000026463 ENSMUSG00000029467 ENSMUSG00000032570 ENSMUSG00000037996 ENSMUSG00000015342 ENSMUSG00000056073 ENSMUSG00000017412 ENSMUSG00000034997 ENSMUSG00000026959 ENSMUSG00000032826 ENSMUSG00000038486 ENSMUSG00000041771 ENSMUSG00000041468', format_txt=1, hdr_idx=1, is_hdrgo=True, is_usrgo=True, hdr1usr01='**', dcnt=36, D1='ABC', GO_name='cellular calcium ion homeostasis'),
    Nt(p_uncorrected=7.325761159793365e-09, study_count=63, study_n=1029, namespace='biological_process', p_fdr_bh=8.537892871694559e-06, study_items=set([u'ENSMUSG00000010803', u'ENSMUSG00000070304', u'ENSMUSG00000056073', u'ENSMUSG00000019146', u'ENSMUSG00000006576', u'ENSMUSG00000027950', u'ENSMUSG00000020436', u'ENSMUSG00000044216', u'ENSMUSG00000017412', u'ENSMUSG00000019210', u'ENSMUSG00000029054', u'ENSMUSG00000050556', u'ENSMUSG00000021991', u'ENSMUSG00000019194', u'ENSMUSG00000025189', u'ENSMUSG00000026576', u'ENSMUSG00000040907', u'ENSMUSG00000023017', u'ENSMUSG00000053395', u'ENSMUSG00000024957', u'ENSMUSG00000001985', u'ENSMUSG00000036026', u'ENSMUSG00000027130', u'ENSMUSG00000050963', u'ENSMUSG00000046822', u'ENSMUSG00000025428', u'ENSMUSG00000066189', u'ENSMUSG00000017740', u'ENSMUSG00000030302', u'ENSMUSG00000040896', u'ENSMUSG00000022295', u'ENSMUSG00000059742', u'ENSMUSG00000029467', u'ENSMUSG00000006273', u'ENSMUSG00000020402', u'ENSMUSG00000036760', u'ENSMUSG00000022342', u'ENSMUSG00000002908', u'ENSMUSG00000036578', u'ENSMUSG00000026959', u'ENSMUSG00000033161', u'ENSMUSG00000026904', u'ENSMUSG00000029212', u'ENSMUSG00000058441', u'ENSMUSG00000029088', u'ENSMUSG00000022199', u'ENSMUSG00000092083', u'ENSMUSG00000025986', u'ENSMUSG00000037341', u'ENSMUSG00000026463', u'ENSMUSG00000025212', u'ENSMUSG00000032570', u'ENSMUSG00000038026', u'ENSMUSG00000046480', u'ENSMUSG00000051726', u'ENSMUSG00000013160', u'ENSMUSG00000031791', u'ENSMUSG00000000605', u'ENSMUSG00000039347', u'ENSMUSG00000025393', u'ENSMUSG00000007653', u'ENSMUSG00000041771', u'ENSMUSG00000004319']), NS='BP', pop_items=set([u'ENSMUSG00000033720', u'ENSMUSG00000023015', u'ENSMUSG00000028020', u'ENSMUSG00000055078', u'ENSMUSG00000050556', u'ENSMUSG00000037242', u'ENSMUSG00000064356', u'ENSMUSG00000064357', u'ENSMUSG00000034402', u'ENSMUSG00000028931', u'ENSMUSG00000040907', u'ENSMUSG00000037408', u'ENSMUSG00000030592', u'ENSMUSG00000051154', u'ENSMUSG00000018770', u'ENSMUSG00000063142', u'ENSMUSG00000030209', u'ENSMUSG00000049686', u'ENSMUSG00000015340', u'ENSMUSG00000006567', u'ENSMUSG00000022094', u'ENSMUSG00000018459', u'ENSMUSG00000053519', u'ENSMUSG00000031343', u'ENSMUSG00000052459', u'ENSMUSG00000006611', u'ENSMUSG00000060961', u'ENSMUSG00000056073', u'ENSMUSG00000026389', u'ENSMUSG00000032412', u'ENSMUSG00000018585', u'ENSMUSG00000018589', u'ENSMUSG00000021339', u'ENSMUSG00000058248', u'ENSMUSG00000019210', u'ENSMUSG00000005802', u'ENSMUSG00000056258', u'ENSMUSG00000003352', u'ENSMUSG00000003617', u'ENSMUSG00000009687', u'ENSMUSG00000020402', u'ENSMUSG00000036760', u'ENSMUSG00000025189', u'ENSMUSG00000000563', u'ENSMUSG00000033161', u'ENSMUSG00000089774', u'ENSMUSG00000029221', u'ENSMUSG00000041654', u'ENSMUSG00000025781', u'ENSMUSG00000039105', u'ENSMUSG00000026614', u'ENSMUSG00000032741', u'ENSMUSG00000059363', u'ENSMUSG00000036565', u'ENSMUSG00000046480', u'ENSMUSG00000028096', u'ENSMUSG00000013275', u'ENSMUSG00000042644', u'ENSMUSG00000021629', u'ENSMUSG00000063354', u'ENSMUSG00000006057', u'ENSMUSG00000059742', u'ENSMUSG00000024121', u'ENSMUSG00000030247', u'ENSMUSG00000064267', u'ENSMUSG00000022935', u'ENSMUSG00000052310', u'ENSMUSG00000031934', u'ENSMUSG00000040118', u'ENSMUSG00000038717', u'ENSMUSG00000060882', u'ENSMUSG00000044708', u'ENSMUSG00000030237', u'ENSMUSG00000030235', u'ENSMUSG00000034145', u'ENSMUSG00000063796', u'ENSMUSG00000022890', u'ENSMUSG00000031209', u'ENSMUSG00000036196', u'ENSMUSG00000026576', u'ENSMUSG00000031684', u'ENSMUSG00000022199', u'ENSMUSG00000019943', u'ENSMUSG00000002984', u'ENSMUSG00000061171', u'ENSMUSG00000024403', u'ENSMUSG00000001138', u'ENSMUSG00000022758', u'ENSMUSG00000027577', u'ENSMUSG00000038260', u'ENSMUSG00000058975', u'ENSMUSG00000009647', u'ENSMUSG00000040693', u'ENSMUSG00000029212', u'ENSMUSG00000058441', u'ENSMUSG00000029211', u'ENSMUSG00000025572', u'ENSMUSG00000022949', u'ENSMUSG00000054414', u'ENSMUSG00000020723', u'ENSMUSG00000028854', u'ENSMUSG00000037624', u'ENSMUSG00000007653', u'ENSMUSG00000032839', u'ENSMUSG00000054894', u'ENSMUSG00000059003', u'ENSMUSG00000036534', u'ENSMUSG00000025993', u'ENSMUSG00000024270', u'ENSMUSG00000001985', u'ENSMUSG00000016252', u'ENSMUSG00000038319', u'ENSMUSG00000042604', u'ENSMUSG00000062683', u'ENSMUSG00000004110', u'ENSMUSG00000004113', u'ENSMUSG00000028033', u'ENSMUSG00000000560', u'ENSMUSG00000092083', u'ENSMUSG00000027716', u'ENSMUSG00000015653', u'ENSMUSG00000049281', u'ENSMUSG00000040569', u'ENSMUSG00000010803', u'ENSMUSG00000021474', u'ENSMUSG00000024112', u'ENSMUSG00000027895', u'ENSMUSG00000040896', u'ENSMUSG00000038267', u'ENSMUSG00000063698', u'ENSMUSG00000030376', u'ENSMUSG00000004567', u'ENSMUSG00000019087', u'ENSMUSG00000030287', u'ENSMUSG00000023017', u'ENSMUSG00000032017', u'ENSMUSG00000040414', u'ENSMUSG00000036026', u'ENSMUSG00000021771', u'ENSMUSG00000030302', u'ENSMUSG00000015575', u'ENSMUSG00000033379', u'ENSMUSG00000020524', u'ENSMUSG00000034591', u'ENSMUSG00000032570', u'ENSMUSG00000047037', u'ENSMUSG00000001260', u'ENSMUSG00000025790', u'ENSMUSG00000020411', u'ENSMUSG00000010064', u'ENSMUSG00000010066', u'ENSMUSG00000030650', u'ENSMUSG00000025892', u'ENSMUSG00000025221', u'ENSMUSG00000027130', u'ENSMUSG00000002105', u'ENSMUSG00000020704', u'ENSMUSG00000047959', u'ENSMUSG00000032754', u'ENSMUSG00000035805', u'ENSMUSG00000046079', u'ENSMUSG00000030000', u'ENSMUSG00000020805', u'ENSMUSG00000044216', u'ENSMUSG00000036578', u'ENSMUSG00000006641', u'ENSMUSG00000041736', u'ENSMUSG00000027340', u'ENSMUSG00000038497', u'ENSMUSG00000013495', u'ENSMUSG00000070639', u'ENSMUSG00000021730', u'ENSMUSG00000021733', u'ENSMUSG00000054934', u'ENSMUSG00000031997', u'ENSMUSG00000030500', u'ENSMUSG00000027827', u'ENSMUSG00000050963', u'ENSMUSG00000004285', u'ENSMUSG00000017765', u'ENSMUSG00000026065', u'ENSMUSG00000021541', u'ENSMUSG00000030340', u'ENSMUSG00000024069', u'ENSMUSG00000074575', u'ENSMUSG00000018470', u'ENSMUSG00000021371', u'ENSMUSG00000019302', u'ENSMUSG00000023169', u'ENSMUSG00000064105', u'ENSMUSG00000038257', u'ENSMUSG00000048827', u'ENSMUSG00000003378', u'ENSMUSG00000003072', u'ENSMUSG00000009731', u'ENSMUSG00000057378', u'ENSMUSG00000018900', u'ENSMUSG00000034659', u'ENSMUSG00000041078', u'ENSMUSG00000015968', u'ENSMUSG00000046822', u'ENSMUSG00000043673', u'ENSMUSG00000034656', u'ENSMUSG00000033147', u'ENSMUSG00000038690', u'ENSMUSG00000033792', u'ENSMUSG00000033793', u'ENSMUSG00000054477', u'ENSMUSG00000048677', u'ENSMUSG00000045246', u'ENSMUSG00000025212', u'ENSMUSG00000036570', u'ENSMUSG00000033486', u'ENSMUSG00000022843', u'ENSMUSG00000021114', u'ENSMUSG00000041771', u'ENSMUSG00000033981', u'ENSMUSG00000014444', u'ENSMUSG00000009292', u'ENSMUSG00000035594', u'ENSMUSG00000025036', u'ENSMUSG00000039672', u'ENSMUSG00000005674', u'ENSMUSG00000035681', u'ENSMUSG00000068323', u'ENSMUSG00000023267', u'ENSMUSG00000035112', u'ENSMUSG00000020734', u'ENSMUSG00000032313', u'ENSMUSG00000028962', u'ENSMUSG00000064329', u'ENSMUSG00000027884', u'ENSMUSG00000038077', u'ENSMUSG00000006273', u'ENSMUSG00000055026', u'ENSMUSG00000042246', u'ENSMUSG00000004319', u'ENSMUSG00000004317', u'ENSMUSG00000017756', u'ENSMUSG00000061306', u'ENSMUSG00000002771', u'ENSMUSG00000019935', u'ENSMUSG00000075224', u'ENSMUSG00000038115', u'ENSMUSG00000034714', u'ENSMUSG00000039908', u'ENSMUSG00000001986', u'ENSMUSG00000029151', u'ENSMUSG00000021991', u'ENSMUSG00000019894', u'ENSMUSG00000034320', u'ENSMUSG00000033998', u'ENSMUSG00000040724', u'ENSMUSG00000007041', u'ENSMUSG00000025428', u'ENSMUSG00000032269', u'ENSMUSG00000058740', u'ENSMUSG00000038366', u'ENSMUSG00000058743', u'ENSMUSG00000020788', u'ENSMUSG00000022452', u'ENSMUSG00000024327', u'ENSMUSG00000034566', u'ENSMUSG00000079436', u'ENSMUSG00000000605', u'ENSMUSG00000020331', u'ENSMUSG00000025393', u'ENSMUSG00000020334', u'ENSMUSG00000019146', u'ENSMUSG00000029470', u'ENSMUSG00000041695', u'ENSMUSG00000033033', u'ENSMUSG00000000197', u'ENSMUSG00000024957', u'ENSMUSG00000013160', u'ENSMUSG00000045665', u'ENSMUSG00000049872', u'ENSMUSG00000079055', u'ENSMUSG00000079056', u'ENSMUSG00000034462', u'ENSMUSG00000051497', u'ENSMUSG00000028051', u'ENSMUSG00000031791', u'ENSMUSG00000030452', u'ENSMUSG00000030102', u'ENSMUSG00000045404', u'ENSMUSG00000007097', u'ENSMUSG00000037344', u'ENSMUSG00000037434', u'ENSMUSG00000037341', u'ENSMUSG00000027994', u'ENSMUSG00000030428', u'ENSMUSG00000026177', u'ENSMUSG00000064210', u'ENSMUSG00000006576', u'ENSMUSG00000070304', u'ENSMUSG00000090122', u'ENSMUSG00000031775', u'ENSMUSG00000029054', u'ENSMUSG00000018507', u'ENSMUSG00000052428', u'ENSMUSG00000040164', u'ENSMUSG00000020111', u'ENSMUSG00000075316', u'ENSMUSG00000038023', u'ENSMUSG00000054640', u'ENSMUSG00000063873', u'ENSMUSG00000038026', u'ENSMUSG00000028532', u'ENSMUSG00000031075', u'ENSMUSG00000048833', u'ENSMUSG00000026959', u'ENSMUSG00000032554', u'ENSMUSG00000036636', u'ENSMUSG00000039463', u'ENSMUSG00000039347', u'ENSMUSG00000066150', u'ENSMUSG00000066152', u'ENSMUSG00000026824', u'ENSMUSG00000020432', u'ENSMUSG00000020436', u'ENSMUSG00000019194', u'ENSMUSG00000000794', u'ENSMUSG00000000792', u'ENSMUSG00000050856', u'ENSMUSG00000028631', u'ENSMUSG00000037656', u'ENSMUSG00000014158', u'ENSMUSG00000066705', u'ENSMUSG00000024597', u'ENSMUSG00000033676', u'ENSMUSG00000043301', u'ENSMUSG00000070570', u'ENSMUSG00000023259', u'ENSMUSG00000041710', u'ENSMUSG00000016346', u'ENSMUSG00000037579', u'ENSMUSG00000045962', u'ENSMUSG00000041329', u'ENSMUSG00000041482', u'ENSMUSG00000049265', u'ENSMUSG00000042529', u'ENSMUSG00000008892', u'ENSMUSG00000069806', u'ENSMUSG00000030525', u'ENSMUSG00000045053', u'ENSMUSG00000027748', u'ENSMUSG00000053395', u'ENSMUSG00000023030', u'ENSMUSG00000023032', u'ENSMUSG00000023033', u'ENSMUSG00000022132', u'ENSMUSG00000017740', u'ENSMUSG00000019734', u'ENSMUSG00000026519', u'ENSMUSG00000027950', u'ENSMUSG00000022295', u'ENSMUSG00000053897', u'ENSMUSG00000021313', u'ENSMUSG00000051331', u'ENSMUSG00000002908', u'ENSMUSG00000054720', u'ENSMUSG00000029088', u'ENSMUSG00000071424', u'ENSMUSG00000026463', u'ENSMUSG00000057914', u'ENSMUSG00000032511', u'ENSMUSG00000029016', u'ENSMUSG00000031129', u'ENSMUSG00000026904', u'ENSMUSG00000028420', u'ENSMUSG00000017412', u'ENSMUSG00000019558', u'ENSMUSG00000022342', u'ENSMUSG00000022956', u'ENSMUSG00000037610', u'ENSMUSG00000062785', u'ENSMUSG00000066189', u'ENSMUSG00000029468', u'ENSMUSG00000029467', u'ENSMUSG00000039156', u'ENSMUSG00000047976', u'ENSMUSG00000033007', u'ENSMUSG00000023959', u'ENSMUSG00000031532', u'ENSMUSG00000042682', u'ENSMUSG00000022462', u'ENSMUSG00000025986', u'ENSMUSG00000030987', u'ENSMUSG00000030737', u'ENSMUSG00000027163', u'ENSMUSG00000051726', u'ENSMUSG00000020882', u'ENSMUSG00000027365', u'ENSMUSG00000040373']), pop_n=13836, p_sm_bonferroni=0.00011099260733202927, is_obsolete=False, GO='GO:0006811', name='ion transport', pop_count=395, alt_ids=[], level=4, depth=4, enrichment='e', Cluster='Consistent Decrease', geneid_set=set([u'ENSMUSG00000010803', u'ENSMUSG00000070304', u'ENSMUSG00000032570', u'ENSMUSG00000019146', u'ENSMUSG00000006576', u'ENSMUSG00000027950', u'ENSMUSG00000020436', u'ENSMUSG00000044216', u'ENSMUSG00000017412', u'ENSMUSG00000019210', u'ENSMUSG00000029054', u'ENSMUSG00000050556', u'ENSMUSG00000021991', u'ENSMUSG00000019194', u'ENSMUSG00000025189', u'ENSMUSG00000026576', u'ENSMUSG00000040907', u'ENSMUSG00000023017', u'ENSMUSG00000053395', u'ENSMUSG00000001985', u'ENSMUSG00000036026', u'ENSMUSG00000027130', u'ENSMUSG00000050963', u'ENSMUSG00000046822', u'ENSMUSG00000025428', u'ENSMUSG00000066189', u'ENSMUSG00000017740', u'ENSMUSG00000030302', u'ENSMUSG00000040896', u'ENSMUSG00000022295', u'ENSMUSG00000059742', u'ENSMUSG00000029467', u'ENSMUSG00000031791', u'ENSMUSG00000006273', u'ENSMUSG00000020402', u'ENSMUSG00000004319', u'ENSMUSG00000036760', u'ENSMUSG00000022342', u'ENSMUSG00000002908', u'ENSMUSG00000026959', u'ENSMUSG00000033161', u'ENSMUSG00000026904', u'ENSMUSG00000029212', u'ENSMUSG00000038026', u'ENSMUSG00000058441', u'ENSMUSG00000029088', u'ENSMUSG00000092083', u'ENSMUSG00000025986', u'ENSMUSG00000037341', u'ENSMUSG00000026463', u'ENSMUSG00000025212', u'ENSMUSG00000056073', u'ENSMUSG00000036578', u'ENSMUSG00000046480', u'ENSMUSG00000051726', u'ENSMUSG00000013160', u'ENSMUSG00000022199', u'ENSMUSG00000000605', u'ENSMUSG00000039347', u'ENSMUSG00000025393', u'ENSMUSG00000007653', u'ENSMUSG00000041771', u'ENSMUSG00000024957']), symbols=u'Asic1 Atp1a1 Atp1a3 Atp1b1 Atp2a2 Atp2b2 Atp2b4 Atp2c1 Atp5a1 Atp5b Atp6v0d1 Atp6v0e2 Atp6v1b2 Atp6v1c1 Atp6v1e1 Cacna2d3 Cacnb4 Cacng2 Cacng3 Cacng8 Chrnb2 Clcn3 Clcn4 Cnnm1 Fxyd7 Gabra1 Gabrb1 Gabrb2 Gabrd Gabrg2 Grik2 Grik3 Grin1 Kcnb1 Kcnb2 Kcnd3 Kcnf1 Kcnh7 Kcnip4 Kcnj4 Kcnj9 Kcnk4 Kcnk9 Kcnn1 Kcns2 Kcnv1 Panx2 Scn1b Scn2b Scn4b Sfxn3 Slc12a5 Slc12a6 Slc22a17 Slc24a4 Slc39a10 Slc39a3 Slc4a10 Slc4a3 Slc9a7 Tmem38a Tmem63b Vdac1', symbol_set=set([u'Kcnh7', u'Vdac1', u'Kcnj4', u'Kcnn1', u'Atp5a1', u'Panx2', u'Slc39a10', u'Atp6v0e2', u'Atp1a3', u'Atp1a1', u'Kcnip4', u'Gabrb1', u'Grin1', 'Clcn4', u'Gabrb2', u'Kcnv1', u'Tmem38a', u'Atp6v0d1', u'Atp2a2', u'Kcnb2', u'Chrnb2', 'Asic1', u'Cacnb4', u'Slc39a3', u'Fxyd7', u'Sfxn3', u'Slc22a17', u'Cacna2d3', u'Atp6v1b2', u'Atp2c1', u'Kcnj9', u'Cnnm1', u'Slc9a7', u'Kcnk9', u'Slc4a10', u'Kcnk4', u'Gabrg2', u'Grik2', u'Grik3', u'Slc12a5', u'Scn2b', u'Slc12a6', u'Kcns2', u'Gabrd', u'Scn4b', u'Gabra1', u'Kcnb1', u'Atp6v1c1', u'Kcnd3', u'Tmem63b', u'Atp5b', u'Clcn3', u'Slc24a4', u'Atp6v1e1', u'Kcnf1', u'Atp1b1', u'Cacng8', u'Slc4a3', u'Atp2b2', u'Scn1b', u'Cacng2', u'Cacng3', u'Atp2b4']), geneids='ENSMUSG00000010803 ENSMUSG00000070304 ENSMUSG00000032570 ENSMUSG00000019146 ENSMUSG00000006576 ENSMUSG00000027950 ENSMUSG00000020436 ENSMUSG00000044216 ENSMUSG00000017412 ENSMUSG00000024957 ENSMUSG00000029054 ENSMUSG00000050556 ENSMUSG00000021991 ENSMUSG00000019194 ENSMUSG00000022342 ENSMUSG00000026576 ENSMUSG00000040907 ENSMUSG00000022199 ENSMUSG00000053395 ENSMUSG00000001985 ENSMUSG00000036026 ENSMUSG00000017740 ENSMUSG00000050963 ENSMUSG00000046822 ENSMUSG00000025428 ENSMUSG00000066189 ENSMUSG00000027130 ENSMUSG00000030302 ENSMUSG00000040896 ENSMUSG00000022295 ENSMUSG00000059742 ENSMUSG00000029467 ENSMUSG00000031791 ENSMUSG00000006273 ENSMUSG00000020402 ENSMUSG00000036760 ENSMUSG00000025189 ENSMUSG00000002908 ENSMUSG00000026959 ENSMUSG00000033161 ENSMUSG00000026904 ENSMUSG00000029212 ENSMUSG00000038026 ENSMUSG00000058441 ENSMUSG00000029088 ENSMUSG00000092083 ENSMUSG00000025986 ENSMUSG00000037341 ENSMUSG00000004319 ENSMUSG00000025212 ENSMUSG00000026463 ENSMUSG00000056073 ENSMUSG00000036578 ENSMUSG00000046480 ENSMUSG00000051726 ENSMUSG00000013160 ENSMUSG00000023017 ENSMUSG00000000605 ENSMUSG00000039347 ENSMUSG00000025393 ENSMUSG00000007653 ENSMUSG00000041771 ENSMUSG00000019210', format_txt=1, hdr_idx=1, is_hdrgo=True, is_usrgo=True, hdr1usr01='**', dcnt=657, D1='G', GO_name='ion transport'),
    Nt(p_uncorrected=3.6187137095571788e-09, study_count=165, study_n=1029, namespace='biological_process', p_fdr_bh=4.5689276177917345e-06, study_items=set([u'ENSMUSG00000003872', u'ENSMUSG00000052026', u'ENSMUSG00000006576', u'ENSMUSG00000031105', u'ENSMUSG00000017639', u'ENSMUSG00000029054', u'ENSMUSG00000050556', u'ENSMUSG00000031672', u'ENSMUSG00000025189', u'ENSMUSG00000040907', u'ENSMUSG00000026797', u'ENSMUSG00000032549', u'ENSMUSG00000001985', u'ENSMUSG00000050144', u'ENSMUSG00000034958', u'ENSMUSG00000005225', u'ENSMUSG00000021062', u'ENSMUSG00000033419', u'ENSMUSG00000029518', u'ENSMUSG00000046822', u'ENSMUSG00000002319', u'ENSMUSG00000012535', u'ENSMUSG00000038026', u'ENSMUSG00000001576', u'ENSMUSG00000059149', u'ENSMUSG00000048076', u'ENSMUSG00000059316', u'ENSMUSG00000015342', u'ENSMUSG00000029608', u'ENSMUSG00000026959', u'ENSMUSG00000064341', u'ENSMUSG00000027012', u'ENSMUSG00000092083', u'ENSMUSG00000025212', u'ENSMUSG00000025607', u'ENSMUSG00000056073', u'ENSMUSG00000037646', u'ENSMUSG00000030058', u'ENSMUSG00000034723', u'ENSMUSG00000018661', u'ENSMUSG00000020261', u'ENSMUSG00000039530', u'ENSMUSG00000039347', u'ENSMUSG00000020740', u'ENSMUSG00000041771', u'ENSMUSG00000010803', u'ENSMUSG00000018707', u'ENSMUSG00000027894', u'ENSMUSG00000018196', u'ENSMUSG00000040896', u'ENSMUSG00000020435', u'ENSMUSG00000021687', u'ENSMUSG00000020436', u'ENSMUSG00000044216', u'ENSMUSG00000028550', u'ENSMUSG00000019210', u'ENSMUSG00000067851', u'ENSMUSG00000036989', u'ENSMUSG00000019194', u'ENSMUSG00000023017', u'ENSMUSG00000004364', u'ENSMUSG00000036026', u'ENSMUSG00000032402', u'ENSMUSG00000004771', u'ENSMUSG00000030302', u'ENSMUSG00000022905', u'ENSMUSG00000006273', u'ENSMUSG00000020402', u'ENSMUSG00000036760', u'ENSMUSG00000034593', u'ENSMUSG00000033161', u'ENSMUSG00000068747', u'ENSMUSG00000024851', u'ENSMUSG00000004319', u'ENSMUSG00000032570', u'ENSMUSG00000003452', u'ENSMUSG00000031988', u'ENSMUSG00000020745', u'ENSMUSG00000031791', u'ENSMUSG00000024581', u'ENSMUSG00000040543', u'ENSMUSG00000070304', u'ENSMUSG00000053395', u'ENSMUSG00000064363', u'ENSMUSG00000031633', u'ENSMUSG00000031144', u'ENSMUSG00000037685', u'ENSMUSG00000021991', u'ENSMUSG00000020823', u'ENSMUSG00000031149', u'ENSMUSG00000003731', u'ENSMUSG00000030704', u'ENSMUSG00000026455', u'ENSMUSG00000029434', u'ENSMUSG00000030806', u'ENSMUSG00000046480', u'ENSMUSG00000040722', u'ENSMUSG00000030279', u'ENSMUSG00000029392', u'ENSMUSG00000026514', u'ENSMUSG00000017740', u'ENSMUSG00000025428', u'ENSMUSG00000025968', u'ENSMUSG00000027950', u'ENSMUSG00000022295', u'ENSMUSG00000059742', u'ENSMUSG00000024120', u'ENSMUSG00000002908', u'ENSMUSG00000034973', u'ENSMUSG00000029088', u'ENSMUSG00000026463', u'ENSMUSG00000032101', u'ENSMUSG00000036578', u'ENSMUSG00000023236', u'ENSMUSG00000017412', u'ENSMUSG00000013160', u'ENSMUSG00000040441', u'ENSMUSG00000000605', u'ENSMUSG00000025393', u'ENSMUSG00000031242', u'ENSMUSG00000024012', u'ENSMUSG00000006024', u'ENSMUSG00000031840', u'ENSMUSG00000019146', u'ENSMUSG00000036298', u'ENSMUSG00000026904', u'ENSMUSG00000030327', u'ENSMUSG00000024957', u'ENSMUSG00000064370', u'ENSMUSG00000003153', u'ENSMUSG00000032118', u'ENSMUSG00000022342', u'ENSMUSG00000026576', u'ENSMUSG00000022199', u'ENSMUSG00000026470', u'ENSMUSG00000056185', u'ENSMUSG00000054423', u'ENSMUSG00000009090', u'ENSMUSG00000041216', u'ENSMUSG00000050963', u'ENSMUSG00000036667', u'ENSMUSG00000038486', u'ENSMUSG00000066189', u'ENSMUSG00000027575', u'ENSMUSG00000074345', u'ENSMUSG00000027010', u'ENSMUSG00000021700', u'ENSMUSG00000022829', u'ENSMUSG00000029467', u'ENSMUSG00000020483', u'ENSMUSG00000029462', u'ENSMUSG00000017781', u'ENSMUSG00000064367', u'ENSMUSG00000024924', u'ENSMUSG00000019785', u'ENSMUSG00000029212', u'ENSMUSG00000058441', u'ENSMUSG00000025986', u'ENSMUSG00000037341', u'ENSMUSG00000007653', u'ENSMUSG00000051726', u'ENSMUSG00000024897', u'ENSMUSG00000038301', u'ENSMUSG00000035226', u'ENSMUSG00000038039']), NS='BP', pop_items=set([u'ENSMUSG00000020198', u'ENSMUSG00000002015', u'ENSMUSG00000006005', u'ENSMUSG00000018379', u'ENSMUSG00000046027', u'ENSMUSG00000028437', u'ENSMUSG00000034402', u'ENSMUSG00000049866', u'ENSMUSG00000034951', u'ENSMUSG00000034958', u'ENSMUSG00000018770', u'ENSMUSG00000023923', u'ENSMUSG00000071253', u'ENSMUSG00000024045', u'ENSMUSG00000021567', u'ENSMUSG00000052459', u'ENSMUSG00000052456', u'ENSMUSG00000045100', u'ENSMUSG00000017288', u'ENSMUSG00000053453', u'ENSMUSG00000021764', u'ENSMUSG00000021339', u'ENSMUSG00000018196', u'ENSMUSG00000015243', u'ENSMUSG00000024197', u'ENSMUSG00000024191', u'ENSMUSG00000010392', u'ENSMUSG00000018999', u'ENSMUSG00000032806', u'ENSMUSG00000058569', u'ENSMUSG00000036760', u'ENSMUSG00000022807', u'ENSMUSG00000030662', u'ENSMUSG00000021589', u'ENSMUSG00000020219', u'ENSMUSG00000024990', u'ENSMUSG00000027533', u'ENSMUSG00000041654', u'ENSMUSG00000027534', u'ENSMUSG00000007207', u'ENSMUSG00000059363', u'ENSMUSG00000020986', u'ENSMUSG00000033685', u'ENSMUSG00000024535', u'ENSMUSG00000024530', u'ENSMUSG00000036565', u'ENSMUSG00000024533', u'ENSMUSG00000041236', u'ENSMUSG00000030884', u'ENSMUSG00000047767', u'ENSMUSG00000030082', u'ENSMUSG00000059742', u'ENSMUSG00000030247', u'ENSMUSG00000030245', u'ENSMUSG00000030534', u'ENSMUSG00000031337', u'ENSMUSG00000030249', u'ENSMUSG00000031333', u'ENSMUSG00000026111', u'ENSMUSG00000031934', u'ENSMUSG00000015112', u'ENSMUSG00000000197', u'ENSMUSG00000039781', u'ENSMUSG00000025872', u'ENSMUSG00000062078', u'ENSMUSG00000034145', u'ENSMUSG00000047789', u'ENSMUSG00000031753', u'ENSMUSG00000031202', u'ENSMUSG00000031755', u'ENSMUSG00000031209', u'ENSMUSG00000056296', u'ENSMUSG00000026576', u'ENSMUSG00000026577', u'ENSMUSG00000031684', u'ENSMUSG00000040740', u'ENSMUSG00000003226', u'ENSMUSG00000038267', u'ENSMUSG00000036814', u'ENSMUSG00000038260', u'ENSMUSG00000058975', u'ENSMUSG00000009647', u'ENSMUSG00000047187', u'ENSMUSG00000029175', u'ENSMUSG00000022272', u'ENSMUSG00000024259', u'ENSMUSG00000042590', u'ENSMUSG00000029757', u'ENSMUSG00000043463', u'ENSMUSG00000046562', u'ENSMUSG00000016252', u'ENSMUSG00000018459', u'ENSMUSG00000034320', u'ENSMUSG00000042604', u'ENSMUSG00000034893', u'ENSMUSG00000052533', u'ENSMUSG00000020189', u'ENSMUSG00000046032', u'ENSMUSG00000049922', u'ENSMUSG00000028532', u'ENSMUSG00000035722', u'ENSMUSG00000018740', u'ENSMUSG00000020740', u'ENSMUSG00000020745', u'ENSMUSG00000020744', u'ENSMUSG00000021577', u'ENSMUSG00000063698', u'ENSMUSG00000044982', u'ENSMUSG00000067825', u'ENSMUSG00000032017', u'ENSMUSG00000044528', u'ENSMUSG00000078676', u'ENSMUSG00000019906', u'ENSMUSG00000021771', u'ENSMUSG00000004931', u'ENSMUSG00000027438', u'ENSMUSG00000022905', u'ENSMUSG00000022200', u'ENSMUSG00000043885', u'ENSMUSG00000078812', u'ENSMUSG00000019838', u'ENSMUSG00000030102', u'ENSMUSG00000004843', u'ENSMUSG00000079657', u'ENSMUSG00000001260', u'ENSMUSG00000004849', u'ENSMUSG00000071014', u'ENSMUSG00000038462', u'ENSMUSG00000038467', u'ENSMUSG00000030109', u'ENSMUSG00000037685', u'ENSMUSG00000030650', u'ENSMUSG00000037681', u'ENSMUSG00000021591', u'ENSMUSG00000033272', u'ENSMUSG00000037771', u'ENSMUSG00000014077', u'ENSMUSG00000024983', u'ENSMUSG00000001082', u'ENSMUSG00000032902', u'ENSMUSG00000037190', u'ENSMUSG00000027291', u'ENSMUSG00000036570', u'ENSMUSG00000000131', u'ENSMUSG00000036578', u'ENSMUSG00000041736', u'ENSMUSG00000027340', u'ENSMUSG00000002105', u'ENSMUSG00000059734', u'ENSMUSG00000054934', u'ENSMUSG00000020704', u'ENSMUSG00000030500', u'ENSMUSG00000055407', u'ENSMUSG00000031913', u'ENSMUSG00000031924', u'ENSMUSG00000041828', u'ENSMUSG00000025867', u'ENSMUSG00000034152', u'ENSMUSG00000030340', u'ENSMUSG00000021375', u'ENSMUSG00000021371', u'ENSMUSG00000051256', u'ENSMUSG00000031327', u'ENSMUSG00000026568', u'ENSMUSG00000031691', u'ENSMUSG00000031696', u'ENSMUSG00000025366', u'ENSMUSG00000031109', u'ENSMUSG00000073678', u'ENSMUSG00000031105', u'ENSMUSG00000038257', u'ENSMUSG00000005949', u'ENSMUSG00000003072', u'ENSMUSG00000057378', u'ENSMUSG00000034088', u'ENSMUSG00000029924', u'ENSMUSG00000046822', u'ENSMUSG00000043673', u'ENSMUSG00000026819', u'ENSMUSG00000028744', u'ENSMUSG00000025607', u'ENSMUSG00000042616', u'ENSMUSG00000021114', u'ENSMUSG00000029430', u'ENSMUSG00000029434', u'ENSMUSG00000033386', u'ENSMUSG00000037997', u'ENSMUSG00000009292', u'ENSMUSG00000035594', u'ENSMUSG00000028419', u'ENSMUSG00000028412', u'ENSMUSG00000025134', u'ENSMUSG00000035681', u'ENSMUSG00000035933', u'ENSMUSG00000016024', u'ENSMUSG00000021606', u'ENSMUSG00000020734', u'ENSMUSG00000032314', u'ENSMUSG00000013160', u'ENSMUSG00000064329', u'ENSMUSG00000044465', u'ENSMUSG00000016756', u'ENSMUSG00000017756', u'ENSMUSG00000017754', u'ENSMUSG00000061306', u'ENSMUSG00000019935', u'ENSMUSG00000027429', u'ENSMUSG00000027423', u'ENSMUSG00000027422', u'ENSMUSG00000039908', u'ENSMUSG00000033998', u'ENSMUSG00000019804', u'ENSMUSG00000078713', u'ENSMUSG00000019802', u'ENSMUSG00000032264', u'ENSMUSG00000054720', u'ENSMUSG00000032269', u'ENSMUSG00000027519', u'ENSMUSG00000058740', u'ENSMUSG00000058743', u'ENSMUSG00000038412', u'ENSMUSG00000037762', u'ENSMUSG00000024737', u'ENSMUSG00000022808', u'ENSMUSG00000062797', u'ENSMUSG00000022800', u'ENSMUSG00000062421', u'ENSMUSG00000040188', u'ENSMUSG00000019066', u'ENSMUSG00000038520', u'ENSMUSG00000019790', u'ENSMUSG00000041695', u'ENSMUSG00000024957', u'ENSMUSG00000027282', u'ENSMUSG00000027287', u'ENSMUSG00000050732', u'ENSMUSG00000079020', u'ENSMUSG00000030647', u'ENSMUSG00000051735', u'ENSMUSG00000041216', u'ENSMUSG00000030519', u'ENSMUSG00000031596', u'ENSMUSG00000037234', u'ENSMUSG00000037344', u'ENSMUSG00000037434', u'ENSMUSG00000037341', u'ENSMUSG00000031916', u'ENSMUSG00000027994', u'ENSMUSG00000027775', u'ENSMUSG00000030428', u'ENSMUSG00000026177', u'ENSMUSG00000022100', u'ENSMUSG00000025858', u'ENSMUSG00000006576', u'ENSMUSG00000031775', u'ENSMUSG00000040164', u'ENSMUSG00000026553', u'ENSMUSG00000038740', u'ENSMUSG00000066232', u'ENSMUSG00000063873', u'ENSMUSG00000031176', u'ENSMUSG00000035325', u'ENSMUSG00000029608', u'ENSMUSG00000063895', u'ENSMUSG00000026959', u'ENSMUSG00000017765', u'ENSMUSG00000049562', u'ENSMUSG00000022257', u'ENSMUSG00000039347', u'ENSMUSG00000025920', u'ENSMUSG00000066151', u'ENSMUSG00000066152', u'ENSMUSG00000026824', u'ENSMUSG00000021124', u'ENSMUSG00000021127', u'ENSMUSG00000057388', u'ENSMUSG00000020432', u'ENSMUSG00000020435', u'ENSMUSG00000020436', u'ENSMUSG00000028648', u'ENSMUSG00000024065', u'ENSMUSG00000028645', u'ENSMUSG00000034187', u'ENSMUSG00000005881', u'ENSMUSG00000002043', u'ENSMUSG00000034854', u'ENSMUSG00000068264', u'ENSMUSG00000017978', u'ENSMUSG00000066150', u'ENSMUSG00000016346', u'ENSMUSG00000074030', u'ENSMUSG00000020723', u'ENSMUSG00000069806', u'ENSMUSG00000009378', u'ENSMUSG00000042312', u'ENSMUSG00000045053', u'ENSMUSG00000053395', u'ENSMUSG00000020651', u'ENSMUSG00000020650', u'ENSMUSG00000061315', u'ENSMUSG00000017740', u'ENSMUSG00000061536', u'ENSMUSG00000044894', u'ENSMUSG00000032101', u'ENSMUSG00000032458', u'ENSMUSG00000060279', u'ENSMUSG00000053025', u'ENSMUSG00000001240', u'ENSMUSG00000045302', u'ENSMUSG00000032127', u'ENSMUSG00000044252', u'ENSMUSG00000017412', u'ENSMUSG00000024099', u'ENSMUSG00000001440', u'ENSMUSG00000024097', u'ENSMUSG00000024096', u'ENSMUSG00000054423', u'ENSMUSG00000020088', u'ENSMUSG00000067150', u'ENSMUSG00000024941', u'ENSMUSG00000019785', u'ENSMUSG00000031532', u'ENSMUSG00000030982', u'ENSMUSG00000060216', u'ENSMUSG00000030987', u'ENSMUSG00000027162', u'ENSMUSG00000027163', u'ENSMUSG00000027166', u'ENSMUSG00000024891', u'ENSMUSG00000051726', u'ENSMUSG00000024897', u'ENSMUSG00000020882', u'ENSMUSG00000027365', u'ENSMUSG00000040373', u'ENSMUSG00000033720', u'ENSMUSG00000003872', u'ENSMUSG00000026499', u'ENSMUSG00000030298', u'ENSMUSG00000043614', u'ENSMUSG00000020865', u'ENSMUSG00000037242', u'ENSMUSG00000027706', u'ENSMUSG00000037408', u'ENSMUSG00000004056', u'ENSMUSG00000000374', u'ENSMUSG00000031904', u'ENSMUSG00000019478', u'ENSMUSG00000015023', u'ENSMUSG00000006567', u'ENSMUSG00000021357', u'ENSMUSG00000003585', u'ENSMUSG00000027012', u'ENSMUSG00000027010', u'ENSMUSG00000031343', u'ENSMUSG00000027015', u'ENSMUSG00000006611', u'ENSMUSG00000026389', u'ENSMUSG00000022003', u'ENSMUSG00000026385', u'ENSMUSG00000025935', u'ENSMUSG00000026944', u'ENSMUSG00000029632', u'ENSMUSG00000003617', u'ENSMUSG00000029125', u'ENSMUSG00000068874', u'ENSMUSG00000040441', u'ENSMUSG00000075600', u'ENSMUSG00000020402', u'ENSMUSG00000029705', u'ENSMUSG00000022538', u'ENSMUSG00000028655', u'ENSMUSG00000089774', u'ENSMUSG00000048796', u'ENSMUSG00000034190', u'ENSMUSG00000060882', u'ENSMUSG00000029415', u'ENSMUSG00000029416', u'ENSMUSG00000002059', u'ENSMUSG00000002058', u'ENSMUSG00000078441', u'ENSMUSG00000002052', u'ENSMUSG00000035919', u'ENSMUSG00000038291', u'ENSMUSG00000046480', u'ENSMUSG00000028096', u'ENSMUSG00000013275', u'ENSMUSG00000021629', u'ENSMUSG00000004902', u'ENSMUSG00000034826', u'ENSMUSG00000001436', u'ENSMUSG00000024663', u'ENSMUSG00000028385', u'ENSMUSG00000017774', u'ENSMUSG00000036291', u'ENSMUSG00000024392', u'ENSMUSG00000036298', u'ENSMUSG00000063796', u'ENSMUSG00000032118', u'ENSMUSG00000032449', u'ENSMUSG00000032112', u'ENSMUSG00000002985', u'ENSMUSG00000002984', u'ENSMUSG00000019861', u'ENSMUSG00000021432', u'ENSMUSG00000024150', u'ENSMUSG00000024403', u'ENSMUSG00000019868', u'ENSMUSG00000027575', u'ENSMUSG00000022822', u'ENSMUSG00000022829', u'ENSMUSG00000032842', u'ENSMUSG00000054099', u'ENSMUSG00000054414', u'ENSMUSG00000022199', u'ENSMUSG00000000743', u'ENSMUSG00000008036', u'ENSMUSG00000032939', u'ENSMUSG00000026718', u'ENSMUSG00000056185', u'ENSMUSG00000036435', u'ENSMUSG00000054894', u'ENSMUSG00000030754', u'ENSMUSG00000074909', u'ENSMUSG00000024378', u'ENSMUSG00000030629', u'ENSMUSG00000020386', u'ENSMUSG00000001986', u'ENSMUSG00000062683', u'ENSMUSG00000004110', u'ENSMUSG00000018800', u'ENSMUSG00000020873', u'ENSMUSG00000027397', u'ENSMUSG00000020876', u'ENSMUSG00000037257', u'ENSMUSG00000031574', u'ENSMUSG00000000560', u'ENSMUSG00000092083', u'ENSMUSG00000005510', u'ENSMUSG00000027716', u'ENSMUSG00000026159', u'ENSMUSG00000031974', u'ENSMUSG00000022758', u'ENSMUSG00000040569', u'ENSMUSG00000031979', u'ENSMUSG00000030172', u'ENSMUSG00000031488', u'ENSMUSG00000027953', u'ENSMUSG00000027950', u'ENSMUSG00000027957', u'ENSMUSG00000030376', u'ENSMUSG00000005357', u'ENSMUSG00000006519', u'ENSMUSG00000031378', u'ENSMUSG00000031808', u'ENSMUSG00000030287', u'ENSMUSG00000041945', u'ENSMUSG00000023017', u'ENSMUSG00000023015', u'ENSMUSG00000040414', u'ENSMUSG00000022841', u'ENSMUSG00000022013', u'ENSMUSG00000022012', u'ENSMUSG00000000811', u'ENSMUSG00000070939', u'ENSMUSG00000031156', u'ENSMUSG00000031158', u'ENSMUSG00000020524', u'ENSMUSG00000056832', u'ENSMUSG00000047037', u'ENSMUSG00000028758', u'ENSMUSG00000020411', u'ENSMUSG00000003731', u'ENSMUSG00000025892', u'ENSMUSG00000046329', u'ENSMUSG00000029392', u'ENSMUSG00000074582', u'ENSMUSG00000026878', u'ENSMUSG00000052395', u'ENSMUSG00000061244', u'ENSMUSG00000029408', u'ENSMUSG00000029401', u'ENSMUSG00000029407', u'ENSMUSG00000029406', u'ENSMUSG00000029405', u'ENSMUSG00000046079', u'ENSMUSG00000048439', u'ENSMUSG00000034274', u'ENSMUSG00000042797', u'ENSMUSG00000035674', u'ENSMUSG00000006641', u'ENSMUSG00000066595', u'ENSMUSG00000021730', u'ENSMUSG00000021733', u'ENSMUSG00000028049', u'ENSMUSG00000064370', u'ENSMUSG00000025161', u'ENSMUSG00000049969', u'ENSMUSG00000032051', u'ENSMUSG00000020671', u'ENSMUSG00000032725', u'ENSMUSG00000024384', u'ENSMUSG00000017781', u'ENSMUSG00000018470', u'ENSMUSG00000019302', u'ENSMUSG00000032435', u'ENSMUSG00000032122', u'ENSMUSG00000019874', u'ENSMUSG00000044786', u'ENSMUSG00000079614', u'ENSMUSG00000024411', u'ENSMUSG00000020261', u'ENSMUSG00000002957', u'ENSMUSG00000032548', u'ENSMUSG00000032549', u'ENSMUSG00000026705', u'ENSMUSG00000033147', u'ENSMUSG00000055371', u'ENSMUSG00000030761', u'ENSMUSG00000033419', u'ENSMUSG00000001998', u'ENSMUSG00000037646', u'ENSMUSG00000037089', u'ENSMUSG00000041779', u'ENSMUSG00000000171', u'ENSMUSG00000041771', u'ENSMUSG00000060992', u'ENSMUSG00000038602', u'ENSMUSG00000033981', u'ENSMUSG00000014444', u'ENSMUSG00000021852', u'ENSMUSG00000041797', u'ENSMUSG00000020843', u'ENSMUSG00000005674', u'ENSMUSG00000061808', u'ENSMUSG00000020283', u'ENSMUSG00000041319', u'ENSMUSG00000023267', u'ENSMUSG00000018900', u'ENSMUSG00000000399', u'ENSMUSG00000018909', u'ENSMUSG00000023460', u'ENSMUSG00000055026', u'ENSMUSG00000000958', u'ENSMUSG00000004655', u'ENSMUSG00000031367', u'ENSMUSG00000031813', u'ENSMUSG00000003452', u'ENSMUSG00000026032', u'ENSMUSG00000041313', u'ENSMUSG00000031633', u'ENSMUSG00000031144', u'ENSMUSG00000031143', u'ENSMUSG00000029359', u'ENSMUSG00000031149', u'ENSMUSG00000038319', u'ENSMUSG00000026455', u'ENSMUSG00000040048', u'ENSMUSG00000049550', u'ENSMUSG00000062110', u'ENSMUSG00000011658', u'ENSMUSG00000035242', u'ENSMUSG00000038366', u'ENSMUSG00000020464', u'ENSMUSG00000057193', u'ENSMUSG00000028879', u'ENSMUSG00000022350', u'ENSMUSG00000022354', u'ENSMUSG00000025885', u'ENSMUSG00000034602', u'ENSMUSG00000069072', u'ENSMUSG00000020590', u'ENSMUSG00000025393', u'ENSMUSG00000032602', u'ENSMUSG00000009013', u'ENSMUSG00000061273', u'ENSMUSG00000029470', u'ENSMUSG00000025371', u'ENSMUSG00000023861', u'ENSMUSG00000057069', u'ENSMUSG00000034867', u'ENSMUSG00000035392', u'ENSMUSG00000034462', u'ENSMUSG00000021700', u'ENSMUSG00000028051', u'ENSMUSG00000064367', u'ENSMUSG00000063406', u'ENSMUSG00000064360', u'ENSMUSG00000064363', u'ENSMUSG00000045404', u'ENSMUSG00000028293', u'ENSMUSG00000064368', u'ENSMUSG00000035805', u'ENSMUSG00000028452', u'ENSMUSG00000032733', u'ENSMUSG00000032042', u'ENSMUSG00000018481', u'ENSMUSG00000039016', u'ENSMUSG00000064210', u'ENSMUSG00000045246', u'ENSMUSG00000064181', u'ENSMUSG00000053293', u'ENSMUSG00000053291', u'ENSMUSG00000032422', u'ENSMUSG00000020111', u'ENSMUSG00000075316', u'ENSMUSG00000024287', u'ENSMUSG00000062785', u'ENSMUSG00000039838', u'ENSMUSG00000002949', u'ENSMUSG00000032554', u'ENSMUSG00000036636', u'ENSMUSG00000054364', u'ENSMUSG00000020078', u'ENSMUSG00000024772', u'ENSMUSG00000019518', u'ENSMUSG00000019194', u'ENSMUSG00000024357', u'ENSMUSG00000018661', u'ENSMUSG00000024604', u'ENSMUSG00000037656', u'ENSMUSG00000073639', u'ENSMUSG00000037098', u'ENSMUSG00000071172', u'ENSMUSG00000014158', u'ENSMUSG00000018861', u'ENSMUSG00000024597', u'ENSMUSG00000004394', u'ENSMUSG00000058076', u'ENSMUSG00000027809', u'ENSMUSG00000027808', u'ENSMUSG00000027804', u'ENSMUSG00000020290', u'ENSMUSG00000005069', u'ENSMUSG00000021619', u'ENSMUSG00000023259', u'ENSMUSG00000037475', u'ENSMUSG00000027737', u'ENSMUSG00000037386', u'ENSMUSG00000041891', u'ENSMUSG00000031950', u'ENSMUSG00000041329', u'ENSMUSG00000040543', u'ENSMUSG00000027739', u'ENSMUSG00000040236', u'ENSMUSG00000010803', u'ENSMUSG00000015013', u'ENSMUSG00000061904', u'ENSMUSG00000004626', u'ENSMUSG00000026198', u'ENSMUSG00000026280', u'ENSMUSG00000030741', u'ENSMUSG00000030805', u'ENSMUSG00000030806', u'ENSMUSG00000026289', u'ENSMUSG00000051111', u'ENSMUSG00000023030', u'ENSMUSG00000023032', u'ENSMUSG00000023033', u'ENSMUSG00000026514', u'ENSMUSG00000066278', u'ENSMUSG00000019734', u'ENSMUSG00000026519', u'ENSMUSG00000025968', u'ENSMUSG00000000838', u'ENSMUSG00000022295', u'ENSMUSG00000022299', u'ENSMUSG00000051331', u'ENSMUSG00000031600', u'ENSMUSG00000025816', u'ENSMUSG00000029088', u'ENSMUSG00000071424', u'ENSMUSG00000031731', u'ENSMUSG00000026463', u'ENSMUSG00000025428', u'ENSMUSG00000022722', u'ENSMUSG00000003623', u'ENSMUSG00000019731', u'ENSMUSG00000060671', u'ENSMUSG00000031834', u'ENSMUSG00000059534', u'ENSMUSG00000020476', u'ENSMUSG00000003153', u'ENSMUSG00000022342', u'ENSMUSG00000028847', u'ENSMUSG00000029468', u'ENSMUSG00000029467', u'ENSMUSG00000039156', u'ENSMUSG00000029462', u'ENSMUSG00000025340', u'ENSMUSG00000026853', u'ENSMUSG00000034473', u'ENSMUSG00000042682', u'ENSMUSG00000028607', u'ENSMUSG00000025986', u'ENSMUSG00000028603', u'ENSMUSG00000034258', u'ENSMUSG00000028609', u'ENSMUSG00000021072', u'ENSMUSG00000021079', u'ENSMUSG00000029518', u'ENSMUSG00000002395', u'ENSMUSG00000028020', u'ENSMUSG00000042195', u'ENSMUSG00000064351', u'ENSMUSG00000064354', u'ENSMUSG00000064356', u'ENSMUSG00000064357', u'ENSMUSG00000025189', u'ENSMUSG00000028931', u'ENSMUSG00000018677', u'ENSMUSG00000018672', u'ENSMUSG00000036026', u'ENSMUSG00000028330', u'ENSMUSG00000001576', u'ENSMUSG00000032096', u'ENSMUSG00000016637', u'ENSMUSG00000045503', u'ENSMUSG00000042229', u'ENSMUSG00000032382', u'ENSMUSG00000002718', u'ENSMUSG00000053519', u'ENSMUSG00000042359', u'ENSMUSG00000020100', u'ENSMUSG00000032412', u'ENSMUSG00000018585', u'ENSMUSG00000018583', u'ENSMUSG00000018589', u'ENSMUSG00000036391', u'ENSMUSG00000000711', u'ENSMUSG00000058248', u'ENSMUSG00000019210', u'ENSMUSG00000044749', u'ENSMUSG00000032890', u'ENSMUSG00000032892', u'ENSMUSG00000062580', u'ENSMUSG00000002372', u'ENSMUSG00000002379', u'ENSMUSG00000001376', u'ENSMUSG00000051853', u'ENSMUSG00000026726', u'ENSMUSG00000033161', u'ENSMUSG00000024900', u'ENSMUSG00000024613', u'ENSMUSG00000024581', u'ENSMUSG00000024583', u'ENSMUSG00000049313', u'ENSMUSG00000026614', u'ENSMUSG00000039714', u'ENSMUSG00000020829', u'ENSMUSG00000020823', u'ENSMUSG00000030704', u'ENSMUSG00000000538', u'ENSMUSG00000030495', u'ENSMUSG00000041881', u'ENSMUSG00000019432', u'ENSMUSG00000063354', u'ENSMUSG00000033615', u'ENSMUSG00000014550', u'ENSMUSG00000039623', u'ENSMUSG00000040594', u'ENSMUSG00000040848', u'ENSMUSG00000063145', u'ENSMUSG00000057060', u'ENSMUSG00000005656', u'ENSMUSG00000040938', u'ENSMUSG00000040447', u'ENSMUSG00000019726', u'ENSMUSG00000040118', u'ENSMUSG00000038717', u'ENSMUSG00000003438', u'ENSMUSG00000040896', u'ENSMUSG00000021248', u'ENSMUSG00000030237', u'ENSMUSG00000025979', u'ENSMUSG00000030235', u'ENSMUSG00000021240', u'ENSMUSG00000051329', u'ENSMUSG00000029073', u'ENSMUSG00000031617', u'ENSMUSG00000049686', u'ENSMUSG00000045665', u'ENSMUSG00000026470', u'ENSMUSG00000022756', u'ENSMUSG00000039530', u'ENSMUSG00000031059', u'ENSMUSG00000020440', u'ENSMUSG00000029212', u'ENSMUSG00000029211', u'ENSMUSG00000049624', u'ENSMUSG00000025572', u'ENSMUSG00000034667', u'ENSMUSG00000028854', u'ENSMUSG00000007653', u'ENSMUSG00000021660', u'ENSMUSG00000009035', u'ENSMUSG00000021669', u'ENSMUSG00000022404', u'ENSMUSG00000025351', u'ENSMUSG00000025354', u'ENSMUSG00000028614', u'ENSMUSG00000025993', u'ENSMUSG00000036943', u'ENSMUSG00000034247', u'ENSMUSG00000034714', u'ENSMUSG00000021062', u'ENSMUSG00000028581', u'ENSMUSG00000061455', u'ENSMUSG00000016319', u'ENSMUSG00000034484', u'ENSMUSG00000025759', u'ENSMUSG00000020620', u'ENSMUSG00000020628', u'ENSMUSG00000028033', u'ENSMUSG00000064345', u'ENSMUSG00000064341', u'ENSMUSG00000013698', u'ENSMUSG00000052584', u'ENSMUSG00000028923', u'ENSMUSG00000031342', u'ENSMUSG00000050856', u'ENSMUSG00000002416', u'ENSMUSG00000079316', u'ENSMUSG00000021474', u'ENSMUSG00000024112', u'ENSMUSG00000067851', u'ENSMUSG00000010066', u'ENSMUSG00000037916', u'ENSMUSG00000032402', u'ENSMUSG00000020132', u'ENSMUSG00000020056', u'ENSMUSG00000015575', u'ENSMUSG00000033379', u'ENSMUSG00000017664', u'ENSMUSG00000021983', u'ENSMUSG00000002365', u'ENSMUSG00000032570', u'ENSMUSG00000021877', u'ENSMUSG00000024758', u'ENSMUSG00000040322', u'ENSMUSG00000042364', u'ENSMUSG00000010064', u'ENSMUSG00000019087', u'ENSMUSG00000019080', u'ENSMUSG00000019082', u'ENSMUSG00000050192', u'ENSMUSG00000033579', u'ENSMUSG00000024339', u'ENSMUSG00000010663', u'ENSMUSG00000033577', u'ENSMUSG00000001729', u'ENSMUSG00000010110', u'ENSMUSG00000024935', u'ENSMUSG00000020903', u'ENSMUSG00000023236', u'ENSMUSG00000037455', u'ENSMUSG00000063882', u'ENSMUSG00000038496', u'ENSMUSG00000038497', u'ENSMUSG00000015759', u'ENSMUSG00000039637', u'ENSMUSG00000031997', u'ENSMUSG00000031993', u'ENSMUSG00000055013', u'ENSMUSG00000031441', u'ENSMUSG00000040584', u'ENSMUSG00000027822', u'ENSMUSG00000027827', u'ENSMUSG00000026260', u'ENSMUSG00000031539', u'ENSMUSG00000019715', u'ENSMUSG00000031840', u'ENSMUSG00000004285', u'ENSMUSG00000026065', u'ENSMUSG00000021278', u'ENSMUSG00000062169', u'ENSMUSG00000031667', u'ENSMUSG00000026088', u'ENSMUSG00000022180', u'ENSMUSG00000056870', u'ENSMUSG00000039529', u'ENSMUSG00000038039', u'ENSMUSG00000052026', u'ENSMUSG00000003378', u'ENSMUSG00000020454', u'ENSMUSG00000022560', u'ENSMUSG00000009731', u'ENSMUSG00000003779', u'ENSMUSG00000047459', u'ENSMUSG00000022365', u'ENSMUSG00000034659', u'ENSMUSG00000015968', u'ENSMUSG00000012535', u'ENSMUSG00000034656', u'ENSMUSG00000013593', u'ENSMUSG00000023830', u'ENSMUSG00000025324', u'ENSMUSG00000024247', u'ENSMUSG00000042759', u'ENSMUSG00000048677', u'ENSMUSG00000025212', u'ENSMUSG00000034723', u'ENSMUSG00000020585', u'ENSMUSG00000029535', u'ENSMUSG00000028552', u'ENSMUSG00000028550', u'ENSMUSG00000052688', u'ENSMUSG00000025036', u'ENSMUSG00000025035', u'ENSMUSG00000028559', u'ENSMUSG00000028955', u'ENSMUSG00000062949', u'ENSMUSG00000024104', u'ENSMUSG00000024101', u'ENSMUSG00000033965', u'ENSMUSG00000006273', u'ENSMUSG00000042246', u'ENSMUSG00000039194', u'ENSMUSG00000020128', u'ENSMUSG00000002771', u'ENSMUSG00000060090', u'ENSMUSG00000002778', u'ENSMUSG00000070304', u'ENSMUSG00000020022', u'ENSMUSG00000014402', u'ENSMUSG00000032180', u'ENSMUSG00000044768', u'ENSMUSG00000017679', u'ENSMUSG00000021991', u'ENSMUSG00000019894', u'ENSMUSG00000032504', u'ENSMUSG00000024038', u'ENSMUSG00000001150', u'ENSMUSG00000024030', u'ENSMUSG00000024036', u'ENSMUSG00000027699', u'ENSMUSG00000032988', u'ENSMUSG00000002319', u'ENSMUSG00000033106', u'ENSMUSG00000024327', u'ENSMUSG00000037606', u'ENSMUSG00000079436', u'ENSMUSG00000000605', u'ENSMUSG00000020331', u'ENSMUSG00000020334', u'ENSMUSG00000019146', u'ENSMUSG00000033033', u'ENSMUSG00000024818', u'ENSMUSG00000010122', u'ENSMUSG00000033039', u'ENSMUSG00000022548', u'ENSMUSG00000055334', u'ENSMUSG00000024924', u'ENSMUSG00000079055', u'ENSMUSG00000079056', u'ENSMUSG00000030720', u'ENSMUSG00000030727', u'ENSMUSG00000038486', u'ENSMUSG00000015747', u'ENSMUSG00000051497', u'ENSMUSG00000034216', u'ENSMUSG00000059336', u'ENSMUSG00000030452', u'ENSMUSG00000030450', u'ENSMUSG00000031988', u'ENSMUSG00000030108', u'ENSMUSG00000040693', u'ENSMUSG00000007097', u'ENSMUSG00000027673', u'ENSMUSG00000020805', u'ENSMUSG00000020806', u'ENSMUSG00000070639', u'ENSMUSG00000031529', u'ENSMUSG00000040667', u'ENSMUSG00000027076', u'ENSMUSG00000003411', u'ENSMUSG00000063172', u'ENSMUSG00000020102', u'ENSMUSG00000033365', u'ENSMUSG00000021265', u'ENSMUSG00000029054', u'ENSMUSG00000036882', u'ENSMUSG00000031672', u'ENSMUSG00000039105', u'ENSMUSG00000004610', u'ENSMUSG00000031297', u'ENSMUSG00000026411', u'ENSMUSG00000038023', u'ENSMUSG00000022774', u'ENSMUSG00000038026', u'ENSMUSG00000038024', u'ENSMUSG00000007670', u'ENSMUSG00000056268', u'ENSMUSG00000031075', u'ENSMUSG00000026895', u'ENSMUSG00000009907', u'ENSMUSG00000039463', u'ENSMUSG00000021687', u'ENSMUSG00000021686', u'ENSMUSG00000022427', u'ENSMUSG00000022551', u'ENSMUSG00000025204', u'ENSMUSG00000028631', u'ENSMUSG00000035351', u'ENSMUSG00000066705', u'ENSMUSG00000009470', u'ENSMUSG00000039050', u'ENSMUSG00000089911', u'ENSMUSG00000025868', u'ENSMUSG00000046402', u'ENSMUSG00000028542', u'ENSMUSG00000043301', u'ENSMUSG00000074575', u'ENSMUSG00000034353', u'ENSMUSG00000028127', u'ENSMUSG00000028125', u'ENSMUSG00000052566', u'ENSMUSG00000020484', u'ENSMUSG00000034445', u'ENSMUSG00000016427', u'ENSMUSG00000020483', u'ENSMUSG00000042529', u'ENSMUSG00000033916', u'ENSMUSG00000008892', u'ENSMUSG00000024130', u'ENSMUSG00000028158', u'ENSMUSG00000018733', u'ENSMUSG00000018736', u'ENSMUSG00000035770', u'ENSMUSG00000037933', u'ENSMUSG00000020153', u'ENSMUSG00000053897', u'ENSMUSG00000032193', u'ENSMUSG00000002908', u'ENSMUSG00000036078', u'ENSMUSG00000032519', u'ENSMUSG00000023169', u'ENSMUSG00000032511', u'ENSMUSG00000002346', u'ENSMUSG00000032513', u'ENSMUSG00000036678', u'ENSMUSG00000021520', u'ENSMUSG00000024797', u'ENSMUSG00000024792', u'ENSMUSG00000019558', u'ENSMUSG00000024480', u'ENSMUSG00000024487', u'ENSMUSG00000024646', u'ENSMUSG00000079111', u'ENSMUSG00000022956', u'ENSMUSG00000024645', u'ENSMUSG00000037610', u'ENSMUSG00000024319', u'ENSMUSG00000027115', u'ENSMUSG00000019173', u'ENSMUSG00000048249', u'ENSMUSG00000033007', u'ENSMUSG00000030737', u'ENSMUSG00000014606', u'ENSMUSG00000000792', u'ENSMUSG00000037321', u'ENSMUSG00000037325', u'ENSMUSG00000055078', u'ENSMUSG00000050556', u'ENSMUSG00000041879', u'ENSMUSG00000020817', u'ENSMUSG00000027663', u'ENSMUSG00000020810', u'ENSMUSG00000040907', u'ENSMUSG00000026797', u'ENSMUSG00000026792', u'ENSMUSG00000026791', u'ENSMUSG00000030592', u'ENSMUSG00000051154', u'ENSMUSG00000062444', u'ENSMUSG00000049299', u'ENSMUSG00000031862', u'ENSMUSG00000031865', u'ENSMUSG00000063142', u'ENSMUSG00000030209', u'ENSMUSG00000059149', u'ENSMUSG00000048076', u'ENSMUSG00000015342', u'ENSMUSG00000039509', u'ENSMUSG00000015340', u'ENSMUSG00000024592', u'ENSMUSG00000022094', u'ENSMUSG00000055782', u'ENSMUSG00000040875', u'ENSMUSG00000060961', u'ENSMUSG00000056073', u'ENSMUSG00000040010', u'ENSMUSG00000022765', u'ENSMUSG00000022763', u'ENSMUSG00000031242', u'ENSMUSG00000021326', u'ENSMUSG00000005802', u'ENSMUSG00000056258', u'ENSMUSG00000003352', u'ENSMUSG00000036989', u'ENSMUSG00000040701', u'ENSMUSG00000026339', u'ENSMUSG00000029822', u'ENSMUSG00000034109', u'ENSMUSG00000009687', u'ENSMUSG00000035189', u'ENSMUSG00000029221', u'ENSMUSG00000033676', u'ENSMUSG00000011884', u'ENSMUSG00000025235', u'ENSMUSG00000046230', u'ENSMUSG00000021038', u'ENSMUSG00000025781', u'ENSMUSG00000048497', u'ENSMUSG00000053317', u'ENSMUSG00000032741', u'ENSMUSG00000028572', u'ENSMUSG00000025651', u'ENSMUSG00000009863', u'ENSMUSG00000042644', u'ENSMUSG00000028970', u'ENSMUSG00000028973', u'ENSMUSG00000028975', u'ENSMUSG00000028976', u'ENSMUSG00000050822', u'ENSMUSG00000064068', u'ENSMUSG00000006057', u'ENSMUSG00000070570', u'ENSMUSG00000006058', u'ENSMUSG00000028373', u'ENSMUSG00000024121', u'ENSMUSG00000024120', u'ENSMUSG00000052798', u'ENSMUSG00000064267', u'ENSMUSG00000018707', u'ENSMUSG00000052310', u'ENSMUSG00000020149', u'ENSMUSG00000020142', u'ENSMUSG00000024012', u'ENSMUSG00000020003', u'ENSMUSG00000018566', u'ENSMUSG00000018567', u'ENSMUSG00000044708', u'ENSMUSG00000036196', u'ENSMUSG00000044367', u'ENSMUSG00000019943', u'ENSMUSG00000061171', u'ENSMUSG00000036667', u'ENSMUSG00000014294', u'ENSMUSG00000001138', u'ENSMUSG00000044147', u'ENSMUSG00000024787', u'ENSMUSG00000058441', u'ENSMUSG00000073988', u'ENSMUSG00000022949', u'ENSMUSG00000037624', u'ENSMUSG00000022946', u'ENSMUSG00000027787', u'ENSMUSG00000027782', u'ENSMUSG00000033793', u'ENSMUSG00000032839', u'ENSMUSG00000024875', u'ENSMUSG00000059003', u'ENSMUSG00000024870', u'ENSMUSG00000024873', u'ENSMUSG00000001918', u'ENSMUSG00000033124', u'ENSMUSG00000001827', u'ENSMUSG00000021929', u'ENSMUSG00000024270', u'ENSMUSG00000050144', u'ENSMUSG00000033128', u'ENSMUSG00000020955', u'ENSMUSG00000020952', u'ENSMUSG00000041609', u'ENSMUSG00000062526', u'ENSMUSG00000054808', u'ENSMUSG00000059316', u'ENSMUSG00000027879', u'ENSMUSG00000026781', u'ENSMUSG00000030058', u'ENSMUSG00000015653', u'ENSMUSG00000027099', u'ENSMUSG00000054702', u'ENSMUSG00000049281', u'ENSMUSG00000027896', u'ENSMUSG00000027894', u'ENSMUSG00000027895', u'ENSMUSG00000027577', u'ENSMUSG00000004567', u'ENSMUSG00000055681', u'ENSMUSG00000022159', u'ENSMUSG00000031479', u'ENSMUSG00000022150', u'ENSMUSG00000004364', u'ENSMUSG00000040022', u'ENSMUSG00000026433', u'ENSMUSG00000040029', u'ENSMUSG00000030302', u'ENSMUSG00000034111', u'ENSMUSG00000030301', u'ENSMUSG00000030307', u'ENSMUSG00000030304', u'ENSMUSG00000038102', u'ENSMUSG00000036992', u'ENSMUSG00000029146', u'ENSMUSG00000063801', u'ENSMUSG00000022338', u'ENSMUSG00000025793', u'ENSMUSG00000025792', u'ENSMUSG00000025790', u'ENSMUSG00000026927', u'ENSMUSG00000005907', u'ENSMUSG00000003033', u'ENSMUSG00000003037', u'ENSMUSG00000020792', u'ENSMUSG00000028789', u'ENSMUSG00000034593', u'ENSMUSG00000034591', u'ENSMUSG00000025221', u'ENSMUSG00000040430', u'ENSMUSG00000034203', u'ENSMUSG00000038212', u'ENSMUSG00000013495', u'ENSMUSG00000029763', u'ENSMUSG00000077450', u'ENSMUSG00000047959', u'ENSMUSG00000032757', u'ENSMUSG00000032754', u'ENSMUSG00000029560', u'ENSMUSG00000039048', u'ENSMUSG00000025006', u'ENSMUSG00000034973', u'ENSMUSG00000004980', u'ENSMUSG00000062995', u'ENSMUSG00000045973', u'ENSMUSG00000028962', u'ENSMUSG00000033938', u'ENSMUSG00000006024', u'ENSMUSG00000020175', u'ENSMUSG00000008301', u'ENSMUSG00000028367', u'ENSMUSG00000028007', u'ENSMUSG00000042078', u'ENSMUSG00000063550', u'ENSMUSG00000035152', u'ENSMUSG00000042476', u'ENSMUSG00000032353', u'ENSMUSG00000009090', u'ENSMUSG00000050963', u'ENSMUSG00000002741', u'ENSMUSG00000074345', u'ENSMUSG00000021541', u'ENSMUSG00000024069', u'ENSMUSG00000068747', u'ENSMUSG00000042271', u'ENSMUSG00000036057', u'ENSMUSG00000019971', u'ENSMUSG00000063646', u'ENSMUSG00000021831', u'ENSMUSG00000064105', u'ENSMUSG00000048827', u'ENSMUSG00000006930', u'ENSMUSG00000005225', u'ENSMUSG00000041078', u'ENSMUSG00000022935', u'ENSMUSG00000024664', u'ENSMUSG00000024665', u'ENSMUSG00000041073', u'ENSMUSG00000037490', u'ENSMUSG00000022890', u'ENSMUSG00000020739', u'ENSMUSG00000038456', u'ENSMUSG00000024687', u'ENSMUSG00000038690', u'ENSMUSG00000010154', u'ENSMUSG00000074968', u'ENSMUSG00000033792', u'ENSMUSG00000030688', u'ENSMUSG00000001855', u'ENSMUSG00000054477', u'ENSMUSG00000005354', u'ENSMUSG00000033486', u'ENSMUSG00000022843', u'ENSMUSG00000020946', u'ENSMUSG00000044216', u'ENSMUSG00000041670', u'ENSMUSG00000054277', u'ENSMUSG00000022848', u'ENSMUSG00000039672', u'ENSMUSG00000041815', u'ENSMUSG00000050373', u'ENSMUSG00000019590', u'ENSMUSG00000026220', u'ENSMUSG00000004771', u'ENSMUSG00000036534', u'ENSMUSG00000030869', u'ENSMUSG00000027882', u'ENSMUSG00000027884', u'ENSMUSG00000027887', u'ENSMUSG00000038077', u'ENSMUSG00000041920', u'ENSMUSG00000004319', u'ENSMUSG00000004317', u'ENSMUSG00000022142', u'ENSMUSG00000040034', u'ENSMUSG00000031791', u'ENSMUSG00000030310', u'ENSMUSG00000030314', u'ENSMUSG00000038115', u'ENSMUSG00000001985', u'ENSMUSG00000022855', u'ENSMUSG00000029151', u'ENSMUSG00000051355', u'ENSMUSG00000040722', u'ENSMUSG00000040724', u'ENSMUSG00000028136', u'ENSMUSG00000029802', u'ENSMUSG00000015090', u'ENSMUSG00000049659', u'ENSMUSG00000007041', u'ENSMUSG00000021013', u'ENSMUSG00000020541', u'ENSMUSG00000020788', u'ENSMUSG00000028773', u'ENSMUSG00000020783', u'ENSMUSG00000022450', u'ENSMUSG00000022452', u'ENSMUSG00000004113', u'ENSMUSG00000034560', u'ENSMUSG00000034566', u'ENSMUSG00000029790', u'ENSMUSG00000007458', u'ENSMUSG00000029571', u'ENSMUSG00000023942', u'ENSMUSG00000034789', u'ENSMUSG00000049872', u'ENSMUSG00000053119', u'ENSMUSG00000038844', u'ENSMUSG00000028998', u'ENSMUSG00000028999', u'ENSMUSG00000020163', u'ENSMUSG00000028420', u'ENSMUSG00000028354', u'ENSMUSG00000034940', u'ENSMUSG00000032327', u'ENSMUSG00000018761', u'ENSMUSG00000032328', u'ENSMUSG00000075224', u'ENSMUSG00000017639', u'ENSMUSG00000018507', u'ENSMUSG00000052428', u'ENSMUSG00000018167', u'ENSMUSG00000021824', u'ENSMUSG00000054640', u'ENSMUSG00000020375', u'ENSMUSG00000027411', u'ENSMUSG00000000563', u'ENSMUSG00000048833', u'ENSMUSG00000048832', u'ENSMUSG00000032258', u'ENSMUSG00000021952', u'ENSMUSG00000021486', u'ENSMUSG00000079677', u'ENSMUSG00000021484', u'ENSMUSG00000079477', u'ENSMUSG00000050017', u'ENSMUSG00000010095', u'ENSMUSG00000000794', u'ENSMUSG00000005360', u'ENSMUSG00000030872', u'ENSMUSG00000037152', u'ENSMUSG00000027522', u'ENSMUSG00000027255', u'ENSMUSG00000026491', u'ENSMUSG00000023089', u'ENSMUSG00000023088', u'ENSMUSG00000020993', u'ENSMUSG00000024851', u'ENSMUSG00000041710', u'ENSMUSG00000037579', u'ENSMUSG00000041488', u'ENSMUSG00000004768', u'ENSMUSG00000041482', u'ENSMUSG00000049265', u'ENSMUSG00000030091', u'ENSMUSG00000030096', u'ENSMUSG00000030525', u'ENSMUSG00000027742', u'ENSMUSG00000027748', u'ENSMUSG00000030279', u'ENSMUSG00000003528', u'ENSMUSG00000053799', u'ENSMUSG00000022132', u'ENSMUSG00000081534', u'ENSMUSG00000030327', u'ENSMUSG00000017831', u'ENSMUSG00000073725', u'ENSMUSG00000031482', u'ENSMUSG00000031232', u'ENSMUSG00000021313', u'ENSMUSG00000051343', u'ENSMUSG00000057914', u'ENSMUSG00000029016', u'ENSMUSG00000026342', u'ENSMUSG00000031129', u'ENSMUSG00000020570', u'ENSMUSG00000026904', u'ENSMUSG00000022663', u'ENSMUSG00000022664', u'ENSMUSG00000025484', u'ENSMUSG00000022265', u'ENSMUSG00000025241', u'ENSMUSG00000025243', u'ENSMUSG00000042870', u'ENSMUSG00000066189', u'ENSMUSG00000005089', u'ENSMUSG00000028693', u'ENSMUSG00000047976', u'ENSMUSG00000023959', u'ENSMUSG00000041417', u'ENSMUSG00000022462', u'ENSMUSG00000038301', u'ENSMUSG00000002820', u'ENSMUSG00000021171', u'ENSMUSG00000028982', u'ENSMUSG00000035226']), pop_n=13836, p_sm_bonferroni=5.482713141350082e-05, is_obsolete=False, GO='GO:0006810', name='transport', pop_count=1426, alt_ids=['GO:0015457', 'GO:0015460'], level=3, depth=3, enrichment='e', Cluster='Consistent Decrease', geneid_set=set([u'ENSMUSG00000003872', u'ENSMUSG00000052026', u'ENSMUSG00000006576', u'ENSMUSG00000031105', u'ENSMUSG00000017639', u'ENSMUSG00000029054', u'ENSMUSG00000050556', u'ENSMUSG00000031672', u'ENSMUSG00000025189', u'ENSMUSG00000040907', u'ENSMUSG00000026797', u'ENSMUSG00000032549', u'ENSMUSG00000001985', u'ENSMUSG00000050144', u'ENSMUSG00000034958', u'ENSMUSG00000005225', u'ENSMUSG00000021062', u'ENSMUSG00000064341', u'ENSMUSG00000029518', u'ENSMUSG00000046822', u'ENSMUSG00000002319', u'ENSMUSG00000012535', u'ENSMUSG00000038026', u'ENSMUSG00000001576', u'ENSMUSG00000059149', u'ENSMUSG00000048076', u'ENSMUSG00000059316', u'ENSMUSG00000015342', u'ENSMUSG00000029608', u'ENSMUSG00000026959', u'ENSMUSG00000033419', u'ENSMUSG00000027012', u'ENSMUSG00000092083', u'ENSMUSG00000025212', u'ENSMUSG00000025607', u'ENSMUSG00000056073', u'ENSMUSG00000037646', u'ENSMUSG00000030058', u'ENSMUSG00000034723', u'ENSMUSG00000018661', u'ENSMUSG00000020261', u'ENSMUSG00000066189', u'ENSMUSG00000039347', u'ENSMUSG00000020740', u'ENSMUSG00000041771', u'ENSMUSG00000010803', u'ENSMUSG00000032101', u'ENSMUSG00000027894', u'ENSMUSG00000018196', u'ENSMUSG00000040896', u'ENSMUSG00000020435', u'ENSMUSG00000021687', u'ENSMUSG00000020436', u'ENSMUSG00000044216', u'ENSMUSG00000028550', u'ENSMUSG00000019210', u'ENSMUSG00000067851', u'ENSMUSG00000036989', u'ENSMUSG00000019194', u'ENSMUSG00000023017', u'ENSMUSG00000030279', u'ENSMUSG00000004364', u'ENSMUSG00000036026', u'ENSMUSG00000032402', u'ENSMUSG00000004771', u'ENSMUSG00000030302', u'ENSMUSG00000022905', u'ENSMUSG00000006273', u'ENSMUSG00000020402', u'ENSMUSG00000036760', u'ENSMUSG00000026455', u'ENSMUSG00000033161', u'ENSMUSG00000017781', u'ENSMUSG00000024851', u'ENSMUSG00000004319', u'ENSMUSG00000032570', u'ENSMUSG00000003452', u'ENSMUSG00000020745', u'ENSMUSG00000031791', u'ENSMUSG00000024581', u'ENSMUSG00000040543', u'ENSMUSG00000041216', u'ENSMUSG00000070304', u'ENSMUSG00000019785', u'ENSMUSG00000031633', u'ENSMUSG00000031144', u'ENSMUSG00000037685', u'ENSMUSG00000021991', u'ENSMUSG00000020823', u'ENSMUSG00000031149', u'ENSMUSG00000003731', u'ENSMUSG00000030704', u'ENSMUSG00000034593', u'ENSMUSG00000029434', u'ENSMUSG00000030806', u'ENSMUSG00000046480', u'ENSMUSG00000040722', u'ENSMUSG00000053395', u'ENSMUSG00000029392', u'ENSMUSG00000026514', u'ENSMUSG00000017740', u'ENSMUSG00000025428', u'ENSMUSG00000025968', u'ENSMUSG00000027950', u'ENSMUSG00000022295', u'ENSMUSG00000059742', u'ENSMUSG00000024120', u'ENSMUSG00000002908', u'ENSMUSG00000034973', u'ENSMUSG00000029088', u'ENSMUSG00000026463', u'ENSMUSG00000018707', u'ENSMUSG00000036578', u'ENSMUSG00000023236', u'ENSMUSG00000013160', u'ENSMUSG00000040441', u'ENSMUSG00000000605', u'ENSMUSG00000025393', u'ENSMUSG00000031242', u'ENSMUSG00000024012', u'ENSMUSG00000006024', u'ENSMUSG00000019146', u'ENSMUSG00000036298', u'ENSMUSG00000026904', u'ENSMUSG00000017412', u'ENSMUSG00000024957', u'ENSMUSG00000064370', u'ENSMUSG00000003153', u'ENSMUSG00000032118', u'ENSMUSG00000022342', u'ENSMUSG00000026576', u'ENSMUSG00000022199', u'ENSMUSG00000026470', u'ENSMUSG00000056185', u'ENSMUSG00000054423', u'ENSMUSG00000009090', u'ENSMUSG00000031840', u'ENSMUSG00000050963', u'ENSMUSG00000036667', u'ENSMUSG00000038486', u'ENSMUSG00000039530', u'ENSMUSG00000027575', u'ENSMUSG00000074345', u'ENSMUSG00000027010', u'ENSMUSG00000021700', u'ENSMUSG00000022829', u'ENSMUSG00000029467', u'ENSMUSG00000020483', u'ENSMUSG00000024924', u'ENSMUSG00000029462', u'ENSMUSG00000068747', u'ENSMUSG00000064367', u'ENSMUSG00000031988', u'ENSMUSG00000064363', u'ENSMUSG00000030327', u'ENSMUSG00000029212', u'ENSMUSG00000058441', u'ENSMUSG00000025986', u'ENSMUSG00000037341', u'ENSMUSG00000038039', u'ENSMUSG00000051726', u'ENSMUSG00000024897', u'ENSMUSG00000038301', u'ENSMUSG00000035226', u'ENSMUSG00000007653']), symbols=u'2610002M06Rik Ap1b1 Apba1 Arf1 Arfgap1 Arfgef1 Asic1 Atcay Atg4c Atp1a1 Atp1a3 Atp1b1 Atp2a2 Atp2b2 Atp2b4 Atp2c1 Atp5a1 Atp5b Atp6v0d1 Atp6v0e2 Atp6v1b2 Atp6v1c1 Atp6v1e1 Atp8a1 Bicd1 C2cd5 Cacna2d3 Cacnb4 Cacng2 Cacng3 Cacng8 Cadps Chrnb2 Clcn3 Clcn4 Clvs1 Clvs2 Cnih3 Cnnm1 Cog1 Copg1 Copg2 Cul3 Ddx25 Dopey1 Dync1h1 Dync1i2 Dynll2 Ergic1 Fez1 Fxyd7 Gabra1 Gabrb1 Gabrb2 Gabrd Gabrg2 Gcc2 Gga3 Glrx2 Got2 Grik2 Grik3 Grin1 Ipo4 Kcnb1 Kcnb2 Kcnd3 Kcnf1 Kcnh7 Kcnip4 Kcnj4 Kcnj9 Kcnk4 Kcnk9 Kcnn1 Kcns2 Kcnv1 Klhl12 Kpna1 Kpna6 Lin7b Lrpprc Mfsd4a Mtch1 Myo5a Napa Napg Ndufs1 Necap1 Osbp2 Pafah1b1 Panx2 Pitpna Pitpnm1 Pitpnm3 Plekha8 Praf2 Rab11a Rab11fip4 Rab15 Rab35 Rab3a Rab3c Rab6a Rab6b Rilpl1 Rims4 Rph3a Scamp1 Scamp5 Scg5 Scn1b Scn2b Scn4b Sec14l1 Sfxn3 Slc12a5 Slc22a17 Slc24a4 Slc25a12 Slc25a14 Slc25a4 Slc25a44 Slc26a10 Slc27a4 Slc2a13 Slc2a3 Slc36a1 Slc39a10 Slc39a3 Slc4a10 Slc4a3 Slc6a17 Slc6a7 Slc9a7 Smad3 Snap91 Snx10 Snx32 Sort1 Stx1b Stx6 Stxbp1 Stxbp5l Sv2a Syp Tcaf1 Tmem38a Tmem63b Tmx4 Tnfaip8l3 Tnpo3 Trim3 Tusc3 Vdac1 Vldlr Vps13b Vps26b Vps29 Vps33a Xk mt-Cytb mt-Nd1 mt-Nd4 mt-Nd5', symbol_set=set(['mt-Nd1', u'Cnih3', 'mt-Nd4', 'mt-Nd5', u'Mtch1', u'Slc22a17', u'Kcnh7', u'Kpna6', u'Kpna1', u'Rims4', u'Tnfaip8l3', u'Myo5a', u'Slc6a17', u'Cadps', u'Vps29', u'Atg4c', u'Rph3a', u'2610002M06Rik', u'Atp6v0d1', u'Slc39a3', u'Scamp5', u'Scamp1', u'Slc2a3', u'Praf2', u'Tmx4', u'Cacna2d3', u'Slc26a10', u'Gabra1', u'Slc25a14', u'Slc6a7', u'Atp2c1', u'Snx10', u'Slc25a4', u'Cacng8', u'Atp5b', u'Ipo4', u'Cacng3', u'Pitpna', u'Vps26b', u'Necap1', u'Kcnj4', u'Kcnj9', u'Dync1h1', u'Napg', u'Atp1a3', u'Atp1a1', u'Gabrb1', u'Grin1', u'Plekha8', u'Stxbp5l', u'Stx1b', u'Atcay', u'Arf1', u'Atp8a1', u'Gabrd', 'Mfsd4a', u'Slc25a12', u'Cnnm1', u'Tnpo3', u'Kcnk9', 'C2cd5', u'Rab11fip4', u'Kcnk4', u'Scg5', u'Slc36a1', u'Stxbp1', u'Rilpl1', u'Gga3', u'Pitpnm1', u'Pitpnm3', u'Scn4b', u'Cacng2', u'Slc12a5', u'Dync1i2', u'Slc2a13', u'Sv2a', u'Kcnb2', u'Kcnb1', u'Atp2b2', u'Atp2b4', u'Bicd1', 'Tcaf1', u'Slc25a44', u'Kcns2', u'Atp5a1', u'Ergic1', u'Vps33a', u'Copg2', 'Copg1', u'Vps13b', u'Lrpprc', u'Atp2a2', u'Fez1', u'Chrnb2', 'Asic1', 'mt-Cytb', u'Smad3', u'Snap91', u'Sfxn3', u'Vdac1', u'Cog1', u'Slc9a7', u'Apba1', u'Fxyd7', u'Panx2', u'Xk', u'Kcnd3', u'Clcn3', u'Sec14l1', u'Atp6v1e1', u'Rab6a', u'Rab6b', 'Clcn4', u'Slc4a3', u'Got2', u'Slc27a4', u'Ap1b1', u'Rab15', u'Cul3', u'Napa', u'Scn1b', u'Kcnf1', u'Kcnip4', u'Stx6', u'Trim3', u'Kcnv1', u'Tmem38a', u'Klhl12', u'Lin7b', u'Ddx25', u'Tusc3', u'Dopey1', u'Cacnb4', u'Ndufs1', u'Syp', u'Rab3c', u'Rab3a', u'Atp6v1b2', u'Gcc2', u'Vldlr', u'Slc39a10', u'Gabrg2', u'Grik2', u'Grik3', u'Rab11a', u'Gabrb2', u'Sort1', u'Clvs1', u'Atp6v1c1', u'Dynll2', u'Clvs2', u'Rab35', u'Tmem63b', u'Scn2b', u'Slc4a10', u'Slc24a4', u'Glrx2', u'Atp1b1', u'Arfgef1', u'Kcnn1', u'Arfgap1', u'Atp6v0e2', u'Snx32', u'Pafah1b1', u'Osbp2']), geneids='ENSMUSG00000003872 ENSMUSG00000020261 ENSMUSG00000006576 ENSMUSG00000031105 ENSMUSG00000017639 ENSMUSG00000029054 ENSMUSG00000050556 ENSMUSG00000031672 ENSMUSG00000025189 ENSMUSG00000040907 ENSMUSG00000026797 ENSMUSG00000032549 ENSMUSG00000001985 ENSMUSG00000050144 ENSMUSG00000034958 ENSMUSG00000005225 ENSMUSG00000021062 ENSMUSG00000064341 ENSMUSG00000029518 ENSMUSG00000046822 ENSMUSG00000002319 ENSMUSG00000012535 ENSMUSG00000038026 ENSMUSG00000001576 ENSMUSG00000059149 ENSMUSG00000041216 ENSMUSG00000059316 ENSMUSG00000015342 ENSMUSG00000029608 ENSMUSG00000026959 ENSMUSG00000033419 ENSMUSG00000027012 ENSMUSG00000027010 ENSMUSG00000025212 ENSMUSG00000025607 ENSMUSG00000056073 ENSMUSG00000037646 ENSMUSG00000030058 ENSMUSG00000034723 ENSMUSG00000018661 ENSMUSG00000066189 ENSMUSG00000039347 ENSMUSG00000020740 ENSMUSG00000020745 ENSMUSG00000010803 ENSMUSG00000032101 ENSMUSG00000027894 ENSMUSG00000018196 ENSMUSG00000027950 ENSMUSG00000020435 ENSMUSG00000021687 ENSMUSG00000020436 ENSMUSG00000044216 ENSMUSG00000028550 ENSMUSG00000019210 ENSMUSG00000067851 ENSMUSG00000036989 ENSMUSG00000019194 ENSMUSG00000023017 ENSMUSG00000004364 ENSMUSG00000036026 ENSMUSG00000032402 ENSMUSG00000004771 ENSMUSG00000030302 ENSMUSG00000022905 ENSMUSG00000006273 ENSMUSG00000020402 ENSMUSG00000036760 ENSMUSG00000092083 ENSMUSG00000034593 ENSMUSG00000033161 ENSMUSG00000068747 ENSMUSG00000024851 ENSMUSG00000004319 ENSMUSG00000032570 ENSMUSG00000003452 ENSMUSG00000031988 ENSMUSG00000041771 ENSMUSG00000020483 ENSMUSG00000024581 ENSMUSG00000040543 ENSMUSG00000070304 ENSMUSG00000053395 ENSMUSG00000064363 ENSMUSG00000031633 ENSMUSG00000031144 ENSMUSG00000037685 ENSMUSG00000021991 ENSMUSG00000020823 ENSMUSG00000031149 ENSMUSG00000003731 ENSMUSG00000030704 ENSMUSG00000026455 ENSMUSG00000029434 ENSMUSG00000030806 ENSMUSG00000046480 ENSMUSG00000040722 ENSMUSG00000030279 ENSMUSG00000029392 ENSMUSG00000026514 ENSMUSG00000017740 ENSMUSG00000025428 ENSMUSG00000025968 ENSMUSG00000030327 ENSMUSG00000022295 ENSMUSG00000059742 ENSMUSG00000024120 ENSMUSG00000002908 ENSMUSG00000034973 ENSMUSG00000029088 ENSMUSG00000026463 ENSMUSG00000018707 ENSMUSG00000036578 ENSMUSG00000023236 ENSMUSG00000013160 ENSMUSG00000040441 ENSMUSG00000000605 ENSMUSG00000025393 ENSMUSG00000031242 ENSMUSG00000040896 ENSMUSG00000024012 ENSMUSG00000006024 ENSMUSG00000019146 ENSMUSG00000036298 ENSMUSG00000026904 ENSMUSG00000017412 ENSMUSG00000024957 ENSMUSG00000064370 ENSMUSG00000003153 ENSMUSG00000048076 ENSMUSG00000032118 ENSMUSG00000022342 ENSMUSG00000026576 ENSMUSG00000022199 ENSMUSG00000026470 ENSMUSG00000056185 ENSMUSG00000054423 ENSMUSG00000009090 ENSMUSG00000052026 ENSMUSG00000031840 ENSMUSG00000050963 ENSMUSG00000036667 ENSMUSG00000038486 ENSMUSG00000039530 ENSMUSG00000027575 ENSMUSG00000074345 ENSMUSG00000021700 ENSMUSG00000022829 ENSMUSG00000029467 ENSMUSG00000031791 ENSMUSG00000029462 ENSMUSG00000017781 ENSMUSG00000064367 ENSMUSG00000024924 ENSMUSG00000019785 ENSMUSG00000029212 ENSMUSG00000058441 ENSMUSG00000025986 ENSMUSG00000037341 ENSMUSG00000038039 ENSMUSG00000051726 ENSMUSG00000024897 ENSMUSG00000038301 ENSMUSG00000035226 ENSMUSG00000007653', format_txt=1, hdr_idx=1, is_hdrgo=True, is_usrgo=True, hdr1usr01='**', dcnt=1661, D1='G', GO_name='transport'),
    Nt(p_uncorrected=7.760570526254552e-05, study_count=7, study_n=1029, namespace='biological_process', p_fdr_bh=0.02734428001006575, study_items=set([u'ENSMUSG00000028456', u'ENSMUSG00000056073', u'ENSMUSG00000036104', u'ENSMUSG00000031144', u'ENSMUSG00000022415', u'ENSMUSG00000031840', u'ENSMUSG00000048482']), NS='BP', pop_items=set([u'ENSMUSG00000028456', u'ENSMUSG00000031840', u'ENSMUSG00000003863', u'ENSMUSG00000030376', u'ENSMUSG00000056073', u'ENSMUSG00000022494', u'ENSMUSG00000002028', u'ENSMUSG00000048482', u'ENSMUSG00000036104', u'ENSMUSG00000031144', u'ENSMUSG00000022415', u'ENSMUSG00000037217', u'ENSMUSG00000053930', u'ENSMUSG00000053550', u'ENSMUSG00000022935', u'ENSMUSG00000034799']), pop_n=13836, p_sm_bonferroni=1.0, is_obsolete=False, GO='GO:0048172', name='regulation of short-term neuronal synaptic plasticity', pop_count=16, alt_ids=[], level=5, depth=8, enrichment='e', Cluster='Consistent Decrease', geneid_set=set([u'ENSMUSG00000028456', u'ENSMUSG00000036104', u'ENSMUSG00000031144', u'ENSMUSG00000022415', u'ENSMUSG00000031840', u'ENSMUSG00000048482', u'ENSMUSG00000056073']), symbols=u'Bdnf Grik2 Rab3a Rab3gap1 Syngr1 Syp Unc13b', symbol_set=set([u'Rab3gap1', u'Syngr1', u'Grik2', u'Syp', u'Unc13b', u'Rab3a', u'Bdnf']), geneids='ENSMUSG00000028456 ENSMUSG00000056073 ENSMUSG00000036104 ENSMUSG00000031144 ENSMUSG00000022415 ENSMUSG00000031840 ENSMUSG00000048482', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=2, D1='A', GO_name='regulation of short-term neuronal synaptic plasticity'),
    Nt(p_uncorrected=1.2969720404470315e-05, study_count=10, study_n=1029, namespace='biological_process', p_fdr_bh=0.0072779345869677685, study_items=set([u'ENSMUSG00000056553', u'ENSMUSG00000024261', u'ENSMUSG00000026797', u'ENSMUSG00000024109', u'ENSMUSG00000035390', u'ENSMUSG00000066392', u'ENSMUSG00000033419', u'ENSMUSG00000035864', u'ENSMUSG00000038665', u'ENSMUSG00000003872']), NS='BP', pop_items=set([u'ENSMUSG00000030093', u'ENSMUSG00000003872', u'ENSMUSG00000033768', u'ENSMUSG00000009394', u'ENSMUSG00000066392', u'ENSMUSG00000035864', u'ENSMUSG00000029071', u'ENSMUSG00000026452', u'ENSMUSG00000056553', u'ENSMUSG00000026797', u'ENSMUSG00000035390', u'ENSMUSG00000019906', u'ENSMUSG00000038665', u'ENSMUSG00000027273', u'ENSMUSG00000004113', u'ENSMUSG00000015668', u'ENSMUSG00000003863', u'ENSMUSG00000024109', u'ENSMUSG00000059602', u'ENSMUSG00000037217', u'ENSMUSG00000034799', u'ENSMUSG00000028657', u'ENSMUSG00000024261', u'ENSMUSG00000027162', u'ENSMUSG00000033419', u'ENSMUSG00000037386', u'ENSMUSG00000041670']), pop_n=13836, p_sm_bonferroni=0.19650423384812973, is_obsolete=False, GO='GO:0007269', name='neurotransmitter secretion', pop_count=27, alt_ids=['GO:0010554'], level=2, depth=9, enrichment='e', Cluster='Consistent Decrease', geneid_set=set([u'ENSMUSG00000003872', u'ENSMUSG00000056553', u'ENSMUSG00000024261', u'ENSMUSG00000026797', u'ENSMUSG00000024109', u'ENSMUSG00000035390', u'ENSMUSG00000066392', u'ENSMUSG00000035864', u'ENSMUSG00000038665', u'ENSMUSG00000033419']), symbols=u'Brsk1 Dgki Lin7b Nrxn1 Nrxn3 Ptprn2 Snap91 Stxbp1 Syt1 Syt4', symbol_set=set([u'Ptprn2', u'Snap91', u'Lin7b', u'Brsk1', u'Nrxn3', u'Syt4', u'Nrxn1', u'Stxbp1', u'Dgki', u'Syt1']), geneids='ENSMUSG00000003872 ENSMUSG00000024261 ENSMUSG00000026797 ENSMUSG00000066392 ENSMUSG00000024109 ENSMUSG00000035390 ENSMUSG00000038665 ENSMUSG00000035864 ENSMUSG00000056553 ENSMUSG00000033419', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=20, D1='ABCGT', GO_name='neurotransmitter secretion'),
    Nt(p_uncorrected=8.535449438619857e-05, study_count=24, study_n=1029, namespace='biological_process', p_fdr_bh=0.02811317270533249, study_items=set([u'ENSMUSG00000039106', u'ENSMUSG00000020436', u'ENSMUSG00000031144', u'ENSMUSG00000066392', u'ENSMUSG00000029054', u'ENSMUSG00000056755', u'ENSMUSG00000039953', u'ENSMUSG00000034593', u'ENSMUSG00000026103', u'ENSMUSG00000034997', u'ENSMUSG00000027130', u'ENSMUSG00000034891', u'ENSMUSG00000038486', u'ENSMUSG00000017740', u'ENSMUSG00000031393', u'ENSMUSG00000024109', u'ENSMUSG00000020402', u'ENSMUSG00000026959', u'ENSMUSG00000033419', u'ENSMUSG00000028456', u'ENSMUSG00000025551', u'ENSMUSG00000056073', u'ENSMUSG00000024897', u'ENSMUSG00000020745']), NS='BP', pop_items=set([u'ENSMUSG00000063260', u'ENSMUSG00000047904', u'ENSMUSG00000009376', u'ENSMUSG00000062151', u'ENSMUSG00000020308', u'ENSMUSG00000028020', u'ENSMUSG00000020866', u'ENSMUSG00000055078', u'ENSMUSG00000029054', u'ENSMUSG00000003378', u'ENSMUSG00000059003', u'ENSMUSG00000033768', u'ENSMUSG00000039953', u'ENSMUSG00000023072', u'ENSMUSG00000044933', u'ENSMUSG00000006932', u'ENSMUSG00000049511', u'ENSMUSG00000034891', u'ENSMUSG00000022770', u'ENSMUSG00000050783', u'ENSMUSG00000034656', u'ENSMUSG00000047910', u'ENSMUSG00000030209', u'ENSMUSG00000000766', u'ENSMUSG00000041380', u'ENSMUSG00000030201', u'ENSMUSG00000044043', u'ENSMUSG00000036422', u'ENSMUSG00000034799', u'ENSMUSG00000033396', u'ENSMUSG00000026959', u'ENSMUSG00000051242', u'ENSMUSG00000024960', u'ENSMUSG00000017765', u'ENSMUSG00000033419', u'ENSMUSG00000031343', u'ENSMUSG00000056073', u'ENSMUSG00000003279', u'ENSMUSG00000035431', u'ENSMUSG00000034520', u'ENSMUSG00000020745', u'ENSMUSG00000027400', u'ENSMUSG00000028249', u'ENSMUSG00000020436', u'ENSMUSG00000028004', u'ENSMUSG00000003352', u'ENSMUSG00000000881', u'ENSMUSG00000037014', u'ENSMUSG00000043458', u'ENSMUSG00000024211', u'ENSMUSG00000045731', u'ENSMUSG00000045573', u'ENSMUSG00000051678', u'ENSMUSG00000061762', u'ENSMUSG00000004931', u'ENSMUSG00000031393', u'ENSMUSG00000030307', u'ENSMUSG00000024109', u'ENSMUSG00000020402', u'ENSMUSG00000051599', u'ENSMUSG00000063687', u'ENSMUSG00000020524', u'ENSMUSG00000070570', u'ENSMUSG00000028613', u'ENSMUSG00000026322', u'ENSMUSG00000032360', u'ENSMUSG00000017756', u'ENSMUSG00000063239', u'ENSMUSG00000001260', u'ENSMUSG00000020961', u'ENSMUSG00000030310', u'ENSMUSG00000008892', u'ENSMUSG00000039106', u'ENSMUSG00000050511', u'ENSMUSG00000078816', u'ENSMUSG00000022523', u'ENSMUSG00000031144', u'ENSMUSG00000041936', u'ENSMUSG00000020827', u'ENSMUSG00000033577', u'ENSMUSG00000045689', u'ENSMUSG00000027584', u'ENSMUSG00000034593', u'ENSMUSG00000025892', u'ENSMUSG00000051111', u'ENSMUSG00000052301', u'ENSMUSG00000057914', u'ENSMUSG00000034997', u'ENSMUSG00000017740', u'ENSMUSG00000045876', u'ENSMUSG00000019433', u'ENSMUSG00000027130', u'ENSMUSG00000029763', u'ENSMUSG00000021721', u'ENSMUSG00000046191', u'ENSMUSG00000046387', u'ENSMUSG00000051331', u'ENSMUSG00000073591', u'ENSMUSG00000025889', u'ENSMUSG00000036510', u'ENSMUSG00000025551', u'ENSMUSG00000033981', u'ENSMUSG00000063142', u'ENSMUSG00000048347', u'ENSMUSG00000047033', u'ENSMUSG00000047307', u'ENSMUSG00000001018', u'ENSMUSG00000023192', u'ENSMUSG00000068615', u'ENSMUSG00000044014', u'ENSMUSG00000053004', u'ENSMUSG00000054934', u'ENSMUSG00000043313', u'ENSMUSG00000066392', u'ENSMUSG00000056755', u'ENSMUSG00000050534', u'ENSMUSG00000033214', u'ENSMUSG00000024798', u'ENSMUSG00000026103', u'ENSMUSG00000037610', u'ENSMUSG00000051486', u'ENSMUSG00000038486', u'ENSMUSG00000044022', u'ENSMUSG00000047879', u'ENSMUSG00000049583', u'ENSMUSG00000030519', u'ENSMUSG00000030108', u'ENSMUSG00000030109', u'ENSMUSG00000045657', u'ENSMUSG00000028456', u'ENSMUSG00000045062', u'ENSMUSG00000024897', u'ENSMUSG00000053025', u'ENSMUSG00000020882', u'ENSMUSG00000000058', u'ENSMUSG00000045498']), pop_n=13836, p_sm_bonferroni=1.0, is_obsolete=False, GO='GO:0007268', name='chemical synaptic transmission', pop_count=136, alt_ids=[], level=7, depth=7, enrichment='e', Cluster='Consistent Decrease', geneid_set=set([u'ENSMUSG00000031393', u'ENSMUSG00000039106', u'ENSMUSG00000024109', u'ENSMUSG00000020402', u'ENSMUSG00000020436', u'ENSMUSG00000031144', u'ENSMUSG00000066392', u'ENSMUSG00000029054', u'ENSMUSG00000026959', u'ENSMUSG00000056755', u'ENSMUSG00000033419', u'ENSMUSG00000028456', u'ENSMUSG00000039953', u'ENSMUSG00000034593', u'ENSMUSG00000025551', u'ENSMUSG00000056073', u'ENSMUSG00000026103', u'ENSMUSG00000034997', u'ENSMUSG00000027130', u'ENSMUSG00000034891', u'ENSMUSG00000024897', u'ENSMUSG00000038486', u'ENSMUSG00000020745', u'ENSMUSG00000017740']), symbols=u'Apba1 Clstn1 Fgf14 Gabrd Gabrg2 Gls Grik2 Grin1 Grm7 Htr2a Htr5a Mecp2 Myo5a Nrxn1 Nrxn3 Pafah1b1 Slc12a5 Slc12a6 Snap91 Sncb Sv2a Syp Unc13b Vdac1', symbol_set=set([u'Htr2a', u'Myo5a', u'Clstn1', u'Htr5a', u'Snap91', u'Syp', u'Gabrd', u'Vdac1', u'Fgf14', u'Apba1', u'Gabrg2', u'Grik2', u'Nrxn3', u'Nrxn1', u'Slc12a5', u'Slc12a6', u'Gls', u'Mecp2', u'Unc13b', u'Grin1', u'Sv2a', u'Sncb', u'Grm7', u'Pafah1b1']), geneids='ENSMUSG00000039106 ENSMUSG00000020436 ENSMUSG00000031144 ENSMUSG00000066392 ENSMUSG00000029054 ENSMUSG00000056755 ENSMUSG00000039953 ENSMUSG00000034593 ENSMUSG00000026103 ENSMUSG00000034997 ENSMUSG00000017740 ENSMUSG00000034891 ENSMUSG00000038486 ENSMUSG00000027130 ENSMUSG00000031393 ENSMUSG00000024109 ENSMUSG00000020402 ENSMUSG00000026959 ENSMUSG00000033419 ENSMUSG00000028456 ENSMUSG00000025551 ENSMUSG00000056073 ENSMUSG00000024897 ENSMUSG00000020745', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=12, D1='BCQ', GO_name='chemical synaptic transmission'),
    Nt(p_uncorrected=3.7599740043942885e-05, study_count=10, study_n=1029, namespace='biological_process', p_fdr_bh=0.017262838224417536, study_items=set([u'ENSMUSG00000031393', u'ENSMUSG00000046876', u'ENSMUSG00000032827', u'ENSMUSG00000042429', u'ENSMUSG00000036104', u'ENSMUSG00000056073', u'ENSMUSG00000038665', u'ENSMUSG00000048482', u'ENSMUSG00000026959', u'ENSMUSG00000028969']), NS='BP', pop_items=set([u'ENSMUSG00000009376', u'ENSMUSG00000042429', u'ENSMUSG00000000632', u'ENSMUSG00000029470', u'ENSMUSG00000003378', u'ENSMUSG00000023942', u'ENSMUSG00000059003', u'ENSMUSG00000031302', u'ENSMUSG00000036273', u'ENSMUSG00000022619', u'ENSMUSG00000045730', u'ENSMUSG00000036104', u'ENSMUSG00000038665', u'ENSMUSG00000048482', u'ENSMUSG00000020734', u'ENSMUSG00000005583', u'ENSMUSG00000031393', u'ENSMUSG00000030209', u'ENSMUSG00000046876', u'ENSMUSG00000000766', u'ENSMUSG00000032827', u'ENSMUSG00000022935', u'ENSMUSG00000026959', u'ENSMUSG00000071424', u'ENSMUSG00000070570', u'ENSMUSG00000025889', u'ENSMUSG00000045903', u'ENSMUSG00000056073', u'ENSMUSG00000028161', u'ENSMUSG00000028969']), pop_n=13836, p_sm_bonferroni=0.5696736614057787, is_obsolete=False, GO='GO:0060079', name='excitatory postsynaptic potential', pop_count=30, alt_ids=[], level=5, depth=5, enrichment='e', Cluster='Consistent Decrease', geneid_set=set([u'ENSMUSG00000031393', u'ENSMUSG00000046876', u'ENSMUSG00000032827', u'ENSMUSG00000042429', u'ENSMUSG00000036104', u'ENSMUSG00000056073', u'ENSMUSG00000038665', u'ENSMUSG00000048482', u'ENSMUSG00000026959', u'ENSMUSG00000028969']), symbols=u'Adora1 Atxn1 Bdnf Cdk5 Dgki Grik2 Grin1 Mecp2 Ppp1r9a Rab3gap1', symbol_set=set([u'Rab3gap1', u'Adora1', u'Mecp2', u'Dgki', u'Cdk5', u'Grin1', u'Ppp1r9a', u'Bdnf', u'Grik2', u'Atxn1']), geneids='ENSMUSG00000031393 ENSMUSG00000046876 ENSMUSG00000032827 ENSMUSG00000042429 ENSMUSG00000036104 ENSMUSG00000056073 ENSMUSG00000038665 ENSMUSG00000048482 ENSMUSG00000026959 ENSMUSG00000028969', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=2, D1='A', GO_name='excitatory postsynaptic potential'),
    Nt(p_uncorrected='', study_count='', study_n='', namespace='', p_fdr_bh='', study_items='', NS='BP', pop_items='', pop_n='', p_sm_bonferroni='', is_obsolete='', GO='GO:0032879', name='', pop_count='', alt_ids='', level=3, depth=3, enrichment='', Cluster='', geneid_set='', symbols='', symbol_set='', geneids='', format_txt=1, hdr_idx=1, is_hdrgo=True, is_usrgo=False, hdr1usr01='*', dcnt=1780, D1='A', GO_name='regulation of localization'),
    Nt(p_uncorrected='', study_count='', study_n='', namespace='', p_fdr_bh='', study_items='', NS='BP', pop_items='', pop_n='', p_sm_bonferroni='', is_obsolete='', GO='GO:0055085', name='', pop_count='', alt_ids='', level=4, depth=4, enrichment='', Cluster='', geneid_set='', symbols='', symbol_set='', geneids='', format_txt=1, hdr_idx=1, is_hdrgo=True, is_usrgo=False, hdr1usr01='*', dcnt=338, D1='G', GO_name='transmembrane transport'),
    Nt(p_uncorrected='', study_count='', study_n='', namespace='', p_fdr_bh='', study_items='', NS='BP', pop_items='', pop_n='', p_sm_bonferroni='', is_obsolete='', GO='GO:0050877', name='', pop_count='', alt_ids='', level=3, depth=3, enrichment='', Cluster='', geneid_set='', symbols='', symbol_set='', geneids='', format_txt=1, hdr_idx=1, is_hdrgo=True, is_usrgo=False, hdr1usr01='*', dcnt=96, D1='J', GO_name='neurological system process'),
    Nt(p_uncorrected='', study_count='', study_n='', namespace='', p_fdr_bh='', study_items='', NS='BP', pop_items='', pop_n='', p_sm_bonferroni='', is_obsolete='', GO='GO:0016192', name='', pop_count='', alt_ids='', level=4, depth=4, enrichment='', Cluster='', geneid_set='', symbols='', symbol_set='', geneids='', format_txt=1, hdr_idx=1, is_hdrgo=True, is_usrgo=False, hdr1usr01='*', dcnt=139, D1='G', GO_name='vesicle-mediated transport'),
    Nt(p_uncorrected=8.473228026685633e-05, study_count=44, study_n=1029, namespace='biological_process', p_fdr_bh=0.02811317270533249, study_items=set([u'ENSMUSG00000026826', u'ENSMUSG00000020458', u'ENSMUSG00000029245', u'ENSMUSG00000025158', u'ENSMUSG00000038976', u'ENSMUSG00000031517', u'ENSMUSG00000021221', u'ENSMUSG00000050272', u'ENSMUSG00000040003', u'ENSMUSG00000063919', u'ENSMUSG00000034958', u'ENSMUSG00000064293', u'ENSMUSG00000075478', u'ENSMUSG00000040631', u'ENSMUSG00000050947', u'ENSMUSG00000029291', u'ENSMUSG00000048482', u'ENSMUSG00000052516', u'ENSMUSG00000021820', u'ENSMUSG00000027797', u'ENSMUSG00000021693', u'ENSMUSG00000027692', u'ENSMUSG00000004698', u'ENSMUSG00000027419', u'ENSMUSG00000055022', u'ENSMUSG00000042182', u'ENSMUSG00000035390', u'ENSMUSG00000005045', u'ENSMUSG00000023951', u'ENSMUSG00000008855', u'ENSMUSG00000022048', u'ENSMUSG00000053046', u'ENSMUSG00000024921', u'ENSMUSG00000025551', u'ENSMUSG00000001227', u'ENSMUSG00000034336', u'ENSMUSG00000035456', u'ENSMUSG00000036955', u'ENSMUSG00000028969', u'ENSMUSG00000053477', u'ENSMUSG00000026259', u'ENSMUSG00000022812', u'ENSMUSG00000000627', u'ENSMUSG00000020745']), NS='BP', pop_items=set([u'ENSMUSG00000000738', u'ENSMUSG00000003873', u'ENSMUSG00000029516', u'ENSMUSG00000026965', u'ENSMUSG00000000902', u'ENSMUSG00000039145', u'ENSMUSG00000007989', u'ENSMUSG00000038255', u'ENSMUSG00000028020', u'ENSMUSG00000042599', u'ENSMUSG00000046020', u'ENSMUSG00000004891', u'ENSMUSG00000035390', u'ENSMUSG00000030447', u'ENSMUSG00000030110', u'ENSMUSG00000021451', u'ENSMUSG00000026249', u'ENSMUSG00000022475', u'ENSMUSG00000032228', u'ENSMUSG00000005057', u'ENSMUSG00000058886', u'ENSMUSG00000031511', u'ENSMUSG00000044548', u'ENSMUSG00000055493', u'ENSMUSG00000040003', u'ENSMUSG00000006932', u'ENSMUSG00000031517', u'ENSMUSG00000021796', u'ENSMUSG00000064293', u'ENSMUSG00000032336', u'ENSMUSG00000021820', u'ENSMUSG00000004698', u'ENSMUSG00000075415', u'ENSMUSG00000041609', u'ENSMUSG00000005583', u'ENSMUSG00000057969', u'ENSMUSG00000024501', u'ENSMUSG00000023883', u'ENSMUSG00000055471', u'ENSMUSG00000027797', u'ENSMUSG00000026812', u'ENSMUSG00000027314', u'ENSMUSG00000045333', u'ENSMUSG00000021693', u'ENSMUSG00000040254', u'ENSMUSG00000061524', u'ENSMUSG00000022048', u'ENSMUSG00000014303', u'ENSMUSG00000042182', u'ENSMUSG00000040374', u'ENSMUSG00000068154', u'ENSMUSG00000005958', u'ENSMUSG00000033066', u'ENSMUSG00000026890', u'ENSMUSG00000019261', u'ENSMUSG00000039830', u'ENSMUSG00000025128', u'ENSMUSG00000025089', u'ENSMUSG00000008855', u'ENSMUSG00000005045', u'ENSMUSG00000063531', u'ENSMUSG00000034813', u'ENSMUSG00000006398', u'ENSMUSG00000040010', u'ENSMUSG00000060534', u'ENSMUSG00000034336', u'ENSMUSG00000006095', u'ENSMUSG00000026425', u'ENSMUSG00000028832', u'ENSMUSG00000014773', u'ENSMUSG00000022108', u'ENSMUSG00000026259', u'ENSMUSG00000041773', u'ENSMUSG00000020745', u'ENSMUSG00000029712', u'ENSMUSG00000026826', u'ENSMUSG00000046731', u'ENSMUSG00000022892', u'ENSMUSG00000013663', u'ENSMUSG00000026768', u'ENSMUSG00000048001', u'ENSMUSG00000021577', u'ENSMUSG00000020458', u'ENSMUSG00000030272', u'ENSMUSG00000032482', u'ENSMUSG00000032481', u'ENSMUSG00000037995', u'ENSMUSG00000075590', u'ENSMUSG00000068798', u'ENSMUSG00000063887', u'ENSMUSG00000000881', u'ENSMUSG00000006699', u'ENSMUSG00000022995', u'ENSMUSG00000045515', u'ENSMUSG00000028883', u'ENSMUSG00000028969', u'ENSMUSG00000029600', u'ENSMUSG00000029121', u'ENSMUSG00000027313', u'ENSMUSG00000000247', u'ENSMUSG00000043051', u'ENSMUSG00000025207', u'ENSMUSG00000002274', u'ENSMUSG00000010505', u'ENSMUSG00000015149', u'ENSMUSG00000026223', u'ENSMUSG00000048482', u'ENSMUSG00000052516', u'ENSMUSG00000045903', u'ENSMUSG00000049001', u'ENSMUSG00000052512', u'ENSMUSG00000037892', u'ENSMUSG00000020053', u'ENSMUSG00000020052', u'ENSMUSG00000026930', u'ENSMUSG00000031391', u'ENSMUSG00000026833', u'ENSMUSG00000027434', u'ENSMUSG00000037984', u'ENSMUSG00000001419', u'ENSMUSG00000055022', u'ENSMUSG00000025020', u'ENSMUSG00000031558', u'ENSMUSG00000048915', u'ENSMUSG00000055373', u'ENSMUSG00000019647', u'ENSMUSG00000004798', u'ENSMUSG00000063446', u'ENSMUSG00000043535', u'ENSMUSG00000026317', u'ENSMUSG00000022231', u'ENSMUSG00000031217', u'ENSMUSG00000032368', u'ENSMUSG00000028949', u'ENSMUSG00000035062', u'ENSMUSG00000001300', u'ENSMUSG00000050071', u'ENSMUSG00000035513', u'ENSMUSG00000030075', u'ENSMUSG00000046230', u'ENSMUSG00000026235', u'ENSMUSG00000004558', u'ENSMUSG00000035456', u'ENSMUSG00000036131', u'ENSMUSG00000062098', u'ENSMUSG00000039114', u'ENSMUSG00000041120', u'ENSMUSG00000038777', u'ENSMUSG00000000627', u'ENSMUSG00000030894', u'ENSMUSG00000021743', u'ENSMUSG00000030092', u'ENSMUSG00000035277', u'ENSMUSG00000031385', u'ENSMUSG00000028064', u'ENSMUSG00000003934', u'ENSMUSG00000032740', u'ENSMUSG00000059857', u'ENSMUSG00000035314', u'ENSMUSG00000029245', u'ENSMUSG00000032187', u'ENSMUSG00000028780', u'ENSMUSG00000028664', u'ENSMUSG00000062209', u'ENSMUSG00000021224', u'ENSMUSG00000057897', u'ENSMUSG00000028661', u'ENSMUSG00000030397', u'ENSMUSG00000008658', u'ENSMUSG00000030557', u'ENSMUSG00000040040', u'ENSMUSG00000048782', u'ENSMUSG00000047554', u'ENSMUSG00000007880', u'ENSMUSG00000026121', u'ENSMUSG00000053647', u'ENSMUSG00000062232', u'ENSMUSG00000018736', u'ENSMUSG00000031785', u'ENSMUSG00000037935', u'ENSMUSG00000049107', u'ENSMUSG00000040631', u'ENSMUSG00000028657', u'ENSMUSG00000049100', u'ENSMUSG00000066043', u'ENSMUSG00000025810', u'ENSMUSG00000022031', u'ENSMUSG00000024423', u'ENSMUSG00000031283', u'ENSMUSG00000027699', u'ENSMUSG00000000838', u'ENSMUSG00000022297', u'ENSMUSG00000031137', u'ENSMUSG00000009418', u'ENSMUSG00000029765', u'ENSMUSG00000033295', u'ENSMUSG00000021250', u'ENSMUSG00000029291', u'ENSMUSG00000005089', u'ENSMUSG00000020547', u'ENSMUSG00000050947', u'ENSMUSG00000036745', u'ENSMUSG00000029168', u'ENSMUSG00000022883', u'ENSMUSG00000001729', u'ENSMUSG00000030539', u'ENSMUSG00000032128', u'ENSMUSG00000043557', u'ENSMUSG00000025369', u'ENSMUSG00000075318', u'ENSMUSG00000047084', u'ENSMUSG00000056427', u'ENSMUSG00000022353', u'ENSMUSG00000036078', u'ENSMUSG00000022935', u'ENSMUSG00000032216', u'ENSMUSG00000005102', u'ENSMUSG00000034275', u'ENSMUSG00000025551', u'ENSMUSG00000063632', u'ENSMUSG00000032517', u'ENSMUSG00000032340', u'ENSMUSG00000062991', u'ENSMUSG00000062312', u'ENSMUSG00000035764', u'ENSMUSG00000067071', u'ENSMUSG00000037601', u'ENSMUSG00000028556', u'ENSMUSG00000003527', u'ENSMUSG00000034675', u'ENSMUSG00000069171', u'ENSMUSG00000069170', u'ENSMUSG00000006711', u'ENSMUSG00000021221', u'ENSMUSG00000034701', u'ENSMUSG00000027560', u'ENSMUSG00000025969', u'ENSMUSG00000034958', u'ENSMUSG00000038976', u'ENSMUSG00000038970', u'ENSMUSG00000051323', u'ENSMUSG00000028289', u'ENSMUSG00000043991', u'ENSMUSG00000016541', u'ENSMUSG00000028519', u'ENSMUSG00000045382', u'ENSMUSG00000031239', u'ENSMUSG00000053819', u'ENSMUSG00000030077', u'ENSMUSG00000046167', u'ENSMUSG00000051243', u'ENSMUSG00000020319', u'ENSMUSG00000024099', u'ENSMUSG00000067860', u'ENSMUSG00000061751', u'ENSMUSG00000024921', u'ENSMUSG00000024256', u'ENSMUSG00000002688', u'ENSMUSG00000032087', u'ENSMUSG00000060798', u'ENSMUSG00000031432', u'ENSMUSG00000063919', u'ENSMUSG00000022261', u'ENSMUSG00000061911', u'ENSMUSG00000019864', u'ENSMUSG00000075478', u'ENSMUSG00000056596', u'ENSMUSG00000050272', u'ENSMUSG00000021645', u'ENSMUSG00000063160', u'ENSMUSG00000038175', u'ENSMUSG00000027692', u'ENSMUSG00000022812', u'ENSMUSG00000020167', u'ENSMUSG00000038264', u'ENSMUSG00000025867', u'ENSMUSG00000059146', u'ENSMUSG00000025158', u'ENSMUSG00000003410', u'ENSMUSG00000057177', u'ENSMUSG00000021702', u'ENSMUSG00000004768', u'ENSMUSG00000020918', u'ENSMUSG00000046449', u'ENSMUSG00000024068', u'ENSMUSG00000038738', u'ENSMUSG00000044147', u'ENSMUSG00000053477', u'ENSMUSG00000031214', u'ENSMUSG00000042369', u'ENSMUSG00000022678', u'ENSMUSG00000057778', u'ENSMUSG00000027419', u'ENSMUSG00000048978', u'ENSMUSG00000055254', u'ENSMUSG00000023951', u'ENSMUSG00000018143', u'ENSMUSG00000027200', u'ENSMUSG00000027671', u'ENSMUSG00000053046', u'ENSMUSG00000023018', u'ENSMUSG00000028907', u'ENSMUSG00000056486', u'ENSMUSG00000030584', u'ENSMUSG00000052727', u'ENSMUSG00000031285', u'ENSMUSG00000001227', u'ENSMUSG00000036792', u'ENSMUSG00000032537', u'ENSMUSG00000027763', u'ENSMUSG00000036422', u'ENSMUSG00000036955', u'ENSMUSG00000040506', u'ENSMUSG00000047261', u'ENSMUSG00000041703', u'ENSMUSG00000040957', u'ENSMUSG00000037621', u'ENSMUSG00000052133', u'ENSMUSG00000022103', u'ENSMUSG00000050132', u'ENSMUSG00000035910']), pop_n=13836, p_sm_bonferroni=1.0, is_obsolete=False, GO='GO:0007399', name='nervous system development', pop_count=321, alt_ids=[], level=4, depth=4, enrichment='e', Cluster='Consistent Decrease', geneid_set=set([u'ENSMUSG00000026826', u'ENSMUSG00000038976', u'ENSMUSG00000029245', u'ENSMUSG00000025158', u'ENSMUSG00000020458', u'ENSMUSG00000034958', u'ENSMUSG00000021221', u'ENSMUSG00000050272', u'ENSMUSG00000040003', u'ENSMUSG00000063919', u'ENSMUSG00000031517', u'ENSMUSG00000064293', u'ENSMUSG00000075478', u'ENSMUSG00000040631', u'ENSMUSG00000050947', u'ENSMUSG00000029291', u'ENSMUSG00000048482', u'ENSMUSG00000052516', u'ENSMUSG00000021820', u'ENSMUSG00000027797', u'ENSMUSG00000021693', u'ENSMUSG00000027692', u'ENSMUSG00000004698', u'ENSMUSG00000027419', u'ENSMUSG00000055022', u'ENSMUSG00000042182', u'ENSMUSG00000035390', u'ENSMUSG00000053046', u'ENSMUSG00000023951', u'ENSMUSG00000008855', u'ENSMUSG00000022048', u'ENSMUSG00000005045', u'ENSMUSG00000024921', u'ENSMUSG00000025551', u'ENSMUSG00000001227', u'ENSMUSG00000034336', u'ENSMUSG00000035456', u'ENSMUSG00000036955', u'ENSMUSG00000020745', u'ENSMUSG00000053477', u'ENSMUSG00000026259', u'ENSMUSG00000022812', u'ENSMUSG00000000627', u'ENSMUSG00000028969']), symbols=u'Amigo1 Atcay Bdnf Bend6 Brsk1 Brsk2 Camk2g Cdk5 Chd5 Cntn1 Cntn4 Dclk1 Dok4 Dpf3 Dpysl2 Dscam Epha5 Fgf14 Gpm6a Gsk3b Hdac5 Hdac9 Ina Kif1bp Kif2a Magi2 Ngef Nr4a2 Pafah1b1 Pcsk2 Ppp1r9b Prdm8 Rfng Robo2 Rtn4 Rufy3 Sema4f Sema6b Slitrk1 Smarca2 Srrm4 Tcf4 Tnik Vegfa', symbol_set=set([u'Tcf4', u'Dpysl2', u'Brsk2', u'Brsk1', u'Rtn4', u'Camk2g', u'Gsk3b', u'Vegfa', u'Magi2', u'Dscam', u'Prdm8', u'Bend6', u'Hdac5', u'Atcay', u'Hdac9', u'Epha5', u'Tnik', u'Smarca2', u'Ppp1r9b', u'Fgf14', u'Dpf3', u'Robo2', u'Cntn4', u'Nr4a2', u'Srrm4', u'Ngef', u'Sema6b', u'Sema4f', u'Chd5', u'Slitrk1', u'Pafah1b1', u'Dclk1', u'Ina', u'Pcsk2', u'Cntn1', u'Gpm6a', u'Cdk5', u'Dok4', u'Amigo1', u'Rfng', u'Bdnf', 'Kif1bp', u'Kif2a', u'Rufy3']), geneids='ENSMUSG00000026826 ENSMUSG00000038976 ENSMUSG00000029245 ENSMUSG00000025158 ENSMUSG00000020458 ENSMUSG00000034958 ENSMUSG00000021221 ENSMUSG00000024921 ENSMUSG00000040003 ENSMUSG00000035390 ENSMUSG00000031517 ENSMUSG00000050947 ENSMUSG00000064293 ENSMUSG00000075478 ENSMUSG00000040631 ENSMUSG00000021820 ENSMUSG00000004698 ENSMUSG00000048482 ENSMUSG00000052516 ENSMUSG00000022812 ENSMUSG00000027797 ENSMUSG00000021693 ENSMUSG00000027692 ENSMUSG00000029291 ENSMUSG00000027419 ENSMUSG00000055022 ENSMUSG00000042182 ENSMUSG00000053046 ENSMUSG00000023951 ENSMUSG00000008855 ENSMUSG00000022048 ENSMUSG00000005045 ENSMUSG00000050272 ENSMUSG00000063919 ENSMUSG00000025551 ENSMUSG00000001227 ENSMUSG00000034336 ENSMUSG00000035456 ENSMUSG00000036955 ENSMUSG00000020745 ENSMUSG00000053477 ENSMUSG00000026259 ENSMUSG00000000627 ENSMUSG00000028969', format_txt=1, hdr_idx=1, is_hdrgo=True, is_usrgo=True, hdr1usr01='**', dcnt=0, D1='E', GO_name='nervous system development'),
    Nt(p_uncorrected=0.000162654496292944, study_count=8, study_n=1029, namespace='biological_process', p_fdr_bh=0.04563663469137768, study_items=set([u'ENSMUSG00000024261', u'ENSMUSG00000030806', u'ENSMUSG00000024743', u'ENSMUSG00000068923', u'ENSMUSG00000030731', u'ENSMUSG00000004961', u'ENSMUSG00000029608', u'ENSMUSG00000035226']), NS='BP', pop_items=set([u'ENSMUSG00000068923', u'ENSMUSG00000032890', u'ENSMUSG00000026452', u'ENSMUSG00000030806', u'ENSMUSG00000020848', u'ENSMUSG00000028860', u'ENSMUSG00000027849', u'ENSMUSG00000052301', u'ENSMUSG00000027273', u'ENSMUSG00000062542', u'ENSMUSG00000024743', u'ENSMUSG00000034656', u'ENSMUSG00000049303', u'ENSMUSG00000058420', u'ENSMUSG00000029608', u'ENSMUSG00000024261', u'ENSMUSG00000054453', u'ENSMUSG00000027220', u'ENSMUSG00000030731', u'ENSMUSG00000004961', u'ENSMUSG00000037386', u'ENSMUSG00000041670', u'ENSMUSG00000035226']), pop_n=13836, p_sm_bonferroni=1.0, is_obsolete=False, GO='GO:0048791', name='calcium ion-regulated exocytosis of neurotransmitter', pop_count=23, alt_ids=[], level=3, depth=11, enrichment='e', Cluster='Consistent Decrease', geneid_set=set([u'ENSMUSG00000024261', u'ENSMUSG00000030806', u'ENSMUSG00000035226', u'ENSMUSG00000068923', u'ENSMUSG00000030731', u'ENSMUSG00000004961', u'ENSMUSG00000029608', u'ENSMUSG00000024743']), symbols=u'Rims4 Rph3a Stx1b Syt11 Syt3 Syt4 Syt5 Syt7', symbol_set=set([u'Rph3a', u'Stx1b', u'Syt3', u'Syt4', u'Syt5', u'Syt7', u'Syt11', u'Rims4']), geneids='ENSMUSG00000024261 ENSMUSG00000030806 ENSMUSG00000035226 ENSMUSG00000068923 ENSMUSG00000030731 ENSMUSG00000004961 ENSMUSG00000029608 ENSMUSG00000024743', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=2, D1='BCGT', GO_name='calcium ion-regulated exocytosis of neurotransmitter'),
    Nt(p_uncorrected='', study_count='', study_n='', namespace='', p_fdr_bh='', study_items='', NS='BP', pop_items='', pop_n='', p_sm_bonferroni='', is_obsolete='', GO='GO:0051960', name='', pop_count='', alt_ids='', level=5, depth=5, enrichment='', Cluster='', geneid_set='', symbols='', symbol_set='', geneids='', format_txt=1, hdr_idx=1, is_hdrgo=True, is_usrgo=False, hdr1usr01='*', dcnt=262, D1='A', GO_name='regulation of nervous system development'),
    Nt(p_uncorrected=2.44276282052035e-08, study_count=19, study_n=1029, namespace='biological_process', p_fdr_bh=2.6435928209788447e-05, study_items=set([u'ENSMUSG00000031393', u'ENSMUSG00000045083', u'ENSMUSG00000036295', u'ENSMUSG00000033569', u'ENSMUSG00000074736', u'ENSMUSG00000048218', u'ENSMUSG00000037605', u'ENSMUSG00000024109', u'ENSMUSG00000046699', u'ENSMUSG00000039953', u'ENSMUSG00000066392', u'ENSMUSG00000022674', u'ENSMUSG00000034648', u'ENSMUSG00000048482', u'ENSMUSG00000008153', u'ENSMUSG00000022514', u'ENSMUSG00000075478', u'ENSMUSG00000047085', u'ENSMUSG00000050947']), NS='BP', pop_items=set([u'ENSMUSG00000030093', u'ENSMUSG00000045083', u'ENSMUSG00000036295', u'ENSMUSG00000028184', u'ENSMUSG00000035274', u'ENSMUSG00000055003', u'ENSMUSG00000033707', u'ENSMUSG00000046699', u'ENSMUSG00000020704', u'ENSMUSG00000066392', u'ENSMUSG00000028782', u'ENSMUSG00000063887', u'ENSMUSG00000048304', u'ENSMUSG00000028664', u'ENSMUSG00000031302', u'ENSMUSG00000051790', u'ENSMUSG00000033214', u'ENSMUSG00000039953', u'ENSMUSG00000024647', u'ENSMUSG00000002885', u'ENSMUSG00000013033', u'ENSMUSG00000050965', u'ENSMUSG00000048218', u'ENSMUSG00000047414', u'ENSMUSG00000034730', u'ENSMUSG00000023885', u'ENSMUSG00000050947', u'ENSMUSG00000031393', u'ENSMUSG00000008153', u'ENSMUSG00000071862', u'ENSMUSG00000024109', u'ENSMUSG00000059146', u'ENSMUSG00000042589', u'ENSMUSG00000073125', u'ENSMUSG00000022514', u'ENSMUSG00000048482', u'ENSMUSG00000048915', u'ENSMUSG00000051379', u'ENSMUSG00000055254', u'ENSMUSG00000047085', u'ENSMUSG00000072964', u'ENSMUSG00000035064', u'ENSMUSG00000052581', u'ENSMUSG00000047787', u'ENSMUSG00000033569', u'ENSMUSG00000032452', u'ENSMUSG00000005958', u'ENSMUSG00000060780', u'ENSMUSG00000026341', u'ENSMUSG00000032537', u'ENSMUSG00000037605', u'ENSMUSG00000075478', u'ENSMUSG00000034648', u'ENSMUSG00000049112', u'ENSMUSG00000042846', u'ENSMUSG00000036790', u'ENSMUSG00000025920', u'ENSMUSG00000074736', u'ENSMUSG00000022674']), pop_n=13836, p_sm_bonferroni=0.0003701029949370383, is_obsolete=False, GO='GO:0051965', name='positive regulation of synapse assembly', pop_count=59, alt_ids=[], level=5, depth=7, enrichment='e', Cluster='Consistent Decrease', geneid_set=set([u'ENSMUSG00000031393', u'ENSMUSG00000045083', u'ENSMUSG00000036295', u'ENSMUSG00000074736', u'ENSMUSG00000024109', u'ENSMUSG00000046699', u'ENSMUSG00000008153', u'ENSMUSG00000066392', u'ENSMUSG00000022674', u'ENSMUSG00000075478', u'ENSMUSG00000047085', u'ENSMUSG00000022514', u'ENSMUSG00000039953', u'ENSMUSG00000033569', u'ENSMUSG00000037605', u'ENSMUSG00000048218', u'ENSMUSG00000050947', u'ENSMUSG00000034648', u'ENSMUSG00000048482']), symbols=u'Adgrb3 Adgrl3 Amigo1 Amigo2 Bdnf Clstn1 Clstn3 Il1rap Lingo2 Lrrc4b Lrrn1 Lrrn3 Mecp2 Nrxn1 Nrxn3 Slitrk1 Slitrk4 Syndig1 Ube2v2', symbol_set=set([u'Bdnf', u'Slitrk4', u'Lrrc4b', u'Lingo2', u'Slitrk1', u'Nrxn3', u'Mecp2', u'Amigo2', u'Lrrn3', u'Nrxn1', u'Lrrn1', 'Adgrl3', u'Il1rap', u'Amigo1', u'Ube2v2', 'Adgrb3', 'Syndig1', u'Clstn1', u'Clstn3']), geneids='ENSMUSG00000031393 ENSMUSG00000045083 ENSMUSG00000008153 ENSMUSG00000039953 ENSMUSG00000033569 ENSMUSG00000074736 ENSMUSG00000048218 ENSMUSG00000037605 ENSMUSG00000024109 ENSMUSG00000022514 ENSMUSG00000036295 ENSMUSG00000066392 ENSMUSG00000022674 ENSMUSG00000034648 ENSMUSG00000048482 ENSMUSG00000046699 ENSMUSG00000075478 ENSMUSG00000047085 ENSMUSG00000050947', format_txt=0, hdr_idx=0, is_hdrgo=False, is_usrgo=True, hdr1usr01='', dcnt=5, D1='A', GO_name='positive regulation of synapse assembly'),
    Nt(p_uncorrected='', study_count='', study_n='', namespace='', p_fdr_bh='', study_items='', NS='BP', pop_items='', pop_n='', p_sm_bonferroni='', is_obsolete='', GO='GO:0099531', name='', pop_count='', alt_ids='', level=1, depth=1, enrichment='', Cluster='', geneid_set='', symbols='', symbol_set='', geneids='', format_txt=1, hdr_idx=1, is_hdrgo=True, is_usrgo=False, hdr1usr01='*', dcnt=33, D1='T', GO_name='presynaptic process involved in chemical synaptic transmission'),
    Nt(p_uncorrected='', study_count='', study_n='', namespace='', p_fdr_bh='', study_items='', NS='BP', pop_items='', pop_n='', p_sm_bonferroni='', is_obsolete='', GO='GO:0099536', name='', pop_count='', alt_ids='', level=4, depth=4, enrichment='', Cluster='', geneid_set='', symbols='', symbol_set='', geneids='', format_txt=1, hdr_idx=1, is_hdrgo=True, is_usrgo=False, hdr1usr01='*', dcnt=42, D1='BCQ', GO_name='synaptic signaling'),
]
