"""Data downloaded from NCBI Gene data converted into Python data."""

# Copyright (C) 2014-2017, DV Klopfenstein. All rights reserved

downloaded = "2016_02_22" # 28212 items

import collections as cx

NtData = cx.namedtuple('NtData', 'tax_id Org_name GeneID CurrentID Status Symbol Aliases description other_designations map_location chromosome genomic_nucleotide_accession_version start_position_on_the_genomic_accession end_position_on_the_genomic_accession orientation exon_count OMIM no_hdr0')
GeneID2nt = {
  21846 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=21846, CurrentID=0, Status='live', Symbol='Tie1', Aliases='D430008P04Rik, TIE, tie-1', description='tyrosine kinase with immunoglobulin-like and EGF-like domains 1', other_designations='tyrosine kinase receptor 1', map_location='4 54.67 cM', chromosome='4', genomic_nucleotide_accession_version='NC_000070.6', start_position_on_the_genomic_accession=118471191, end_position_on_the_genomic_accession=118489849, orientation='minus', exon_count=23, OMIM='', no_hdr0=''),
  21855 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=21855, CurrentID=0, Status='live', Symbol='Timm17b', Aliases='17kDa, Sfc3, mTim17b', description='translocase of inner mitochondrial membrane 17b', other_designations='translocator of inner mitochondrial membrane 17 kDa, b|translocator of inner mitochondrial membrane 17b|translocator of inner mitochondrial membrane b', map_location='X 3.56 cM', chromosome='X', genomic_nucleotide_accession_version='NC_000086.7', start_position_on_the_genomic_accession=7899242, end_position_on_the_genomic_accession=7907652, orientation='plus', exon_count=6, OMIM='', no_hdr0=''),
  546144 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=546144, CurrentID=0, Status='live', Symbol='Wdr72', Aliases='AW558070, D230040E23', description='WD repeat domain 72', other_designations='', map_location='9 D', chromosome='9', genomic_nucleotide_accession_version='NC_000075.6', start_position_on_the_genomic_accession=74110331, end_position_on_the_genomic_accession=74283203, orientation='plus', exon_count=21, OMIM='', no_hdr0=''),
  21869 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=21869, CurrentID=0, Status='live', Symbol='Nkx2-1', Aliases='AV026640, Nkx2.1, T/EBP, Titf1, Ttf-1', description='NK2 homeobox 1', other_designations='thyroid nuclear factor 1|thyroid transcription factor 1|thyroid-specific enhancer-binding protein|tinman', map_location='12 C1-C3', chromosome='12', genomic_nucleotide_accession_version='NC_000078.6', start_position_on_the_genomic_accession=56531935, end_position_on_the_genomic_accession=56536908, orientation='minus', exon_count=5, OMIM='', no_hdr0=''),
  21873 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=21873, CurrentID=0, Status='live', Symbol='Tjp2', Aliases='ZO-2', description='tight junction protein 2', other_designations='Tight junction protein ZO-2 (Zonula occludens 2 protein) (Zona occludens 2 protein) (Tight junction protein 2)|zona occludens protein 2|zonula occludens protein 2', map_location='19 C1', chromosome='19', genomic_nucleotide_accession_version='NC_000085.6', start_position_on_the_genomic_accession=24094502, end_position_on_the_genomic_accession=24225128, orientation='minus', exon_count=27, OMIM='', no_hdr0=''),
  109260 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=109260, CurrentID=0, Status='live', Symbol='C030018P15Rik', Aliases='C78986', description='RIKEN cDNA C030018P15 gene', other_designations='', map_location='', chromosome='12', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  21888 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=21888, CurrentID=0, Status='live', Symbol='Tle4', Aliases='5730411M05Rik, AA792082, Bce-1, Bce1, ESTM13, ESTM14, Grg4, X83332, X83333, grg-4', description='transducin-like enhancer of split 4, homolog of Drosophila E(spl)', other_designations='B lymphocyte gene 1|groucho-related protein 4', map_location='19 9.11 cM', chromosome='19', genomic_nucleotide_accession_version='NC_000085.6', start_position_on_the_genomic_accession=14448072, end_position_on_the_genomic_accession=14598183, orientation='minus', exon_count=22, OMIM='', no_hdr0=''),
  21899 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=21899, CurrentID=0, Status='live', Symbol='Tlr6', Aliases='', description='toll-like receptor 6', other_designations='', map_location='5 33.54 cM', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=64952030, end_position_on_the_genomic_accession=64971173, orientation='minus', exon_count=6, OMIM='', no_hdr0=''),
  633570 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=633570, CurrentID=0, Status='live', Symbol='Gm7117', Aliases='EG633570', description='predicted pseudogene 7117', other_designations='', map_location='X D', chromosome='X', genomic_nucleotide_accession_version='NC_000086.6', start_position_on_the_genomic_accession=102920413, end_position_on_the_genomic_accession=102920871, orientation='minus', exon_count=1, OMIM='', no_hdr0=''),
  546205 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=546205, CurrentID=0, Status='live', Symbol='Gm5926', Aliases='EG546205', description='predicted gene 5926', other_designations='', map_location='X A3.1', chromosome='X', genomic_nucleotide_accession_version='NC_000086.7', start_position_on_the_genomic_accession=32649778, end_position_on_the_genomic_accession=32651426, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  546216 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=546216, CurrentID=0, Status='live', Symbol='Mszf17', Aliases='', description='mszf17', other_designations='', map_location='', chromosome='', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  677296 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=677296, CurrentID=0, Status='live', Symbol='Fcrl6', Aliases='ENSMUSG00000070504, FcRH6, mIFGP6, moFcRH6', description='Fc receptor-like 6', other_designations='cell surface glycoprotein gp42|fcR-like protein 6', map_location='1 H3', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=172596640, end_position_on_the_genomic_accession=172618322, orientation='minus', exon_count=9, OMIM='', no_hdr0=''),
  102640444 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102640444, CurrentID=0, Status='live', Symbol='Gm36504', Aliases='', description='predicted gene, 36504', other_designations='', map_location='6', chromosome='6', genomic_nucleotide_accession_version='NC_000072.6', start_position_on_the_genomic_accession=47668074, end_position_on_the_genomic_accession=47669121, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  100270744 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=100270744, CurrentID=0, Status='live', Symbol='Btbd18', Aliases='Btbd18-ps, Gm13718, OTTMUSG00000013494', description='BTB (POZ) domain containing 18', other_designations='BTB (POZ) domain containing 18, pseudogene', map_location='2', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=84659072, end_position_on_the_genomic_accession=84668837, orientation='plus', exon_count=5, OMIM='', no_hdr0=''),
  109339 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=109339, CurrentID=0, Status='live', Symbol='2700018L05Rik', Aliases='', description='RIKEN cDNA 2700018L05 gene', other_designations='', map_location='', chromosome='', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  546263 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=546263, CurrentID=0, Status='live', Symbol='Gm14459', Aliases='OTTMUSG00000016698', description='predicted gene 14459', other_designations='novel synovial sarcoma, X member B family member', map_location='X A1.1', chromosome='X', genomic_nucleotide_accession_version='NC_000086.7', start_position_on_the_genomic_accession=8513543, end_position_on_the_genomic_accession=8526726, orientation='minus', exon_count=8, OMIM='', no_hdr0=''),
  21984 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=21984, CurrentID=0, Status='live', Symbol='Tpbpa', Aliases='AV033951, Tb-1, Tb1, Tpbp, b2b1247Clo', description='trophoblast specific protein alpha', other_designations='Mutant line 1247|clone 4311', map_location='13 32.57 cM', chromosome='13', genomic_nucleotide_accession_version='NC_000079.6', start_position_on_the_genomic_accession=60938692, end_position_on_the_genomic_accession=60941935, orientation='minus', exon_count=5, OMIM='', no_hdr0=''),
  667804 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=667804, CurrentID=0, Status='live', Symbol='Gm14424', Aliases='OTTMUSG00000016592', description='predicted gene 14424', other_designations='', map_location='2 C3', chromosome='2', genomic_nucleotide_accession_version='NC_000068.6', start_position_on_the_genomic_accession=74588730, end_position_on_the_genomic_accession=74591799, orientation='plus', exon_count=3, OMIM='', no_hdr0=''),
  394252 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=394252, CurrentID=0, Status='live', Symbol='Serpinb3d', Aliases='Serpinb3l1', description='serine (or cysteine) peptidase inhibitor, clade B (ovalbumin), member 3D', other_designations='serine (or cysteine) proteinase inhibitor, clade B (ovalbumin), member 3D|serine proteinase inhibitor B3-like 1', map_location='1', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=107078163, end_position_on_the_genomic_accession=107084125, orientation='minus', exon_count=8, OMIM='', no_hdr0=''),
  546321 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=546321, CurrentID=0, Status='live', Symbol='Gm15365', Aliases='EG546321, OTTMUSG00000020738', description='predicted gene 15365', other_designations='', map_location='X A7.3', chromosome='X', genomic_nucleotide_accession_version='NC_000086.6', start_position_on_the_genomic_accession=71958356, end_position_on_the_genomic_accession=71959936, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  546325 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=546325, CurrentID=0, Status='live', Symbol='Gm5936', Aliases='EG546325', description='predicted gene 5936', other_designations='', map_location='X A7.3', chromosome='X', genomic_nucleotide_accession_version='NC_000086.7', start_position_on_the_genomic_accession=74836721, end_position_on_the_genomic_accession=74843369, orientation='plus', exon_count=5, OMIM='', no_hdr0=''),
  394430 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=394430, CurrentID=0, Status='live', Symbol='Ugt1a10', Aliases='A13, Ugt1a13', description='UDP glycosyltransferase 1 family, polypeptide A10', other_designations='UDP glycosyltransferase 1 family polypeptide A13', map_location='1 D', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=88055411, end_position_on_the_genomic_accession=88220002, orientation='plus', exon_count=5, OMIM='', no_hdr0=''),
  394432 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=394432, CurrentID=0, Status='live', Symbol='Ugt1a7c', Aliases="A10', A13, Ugt1a10", description='UDP glucuronosyltransferase 1 family, polypeptide A7C', other_designations='UDP glucuronosyltransferase 1 family, polypeptide A10|UDP glycosyltransferase 1 family, polypeptide A10|UDP-glucuronosyltransferase 1A7C|UDPGT 1-7C|UGT1*7C|UGT1-07C|UGT1.7C', map_location='1 D', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=88095001, end_position_on_the_genomic_accession=88220002, orientation='plus', exon_count=5, OMIM='', no_hdr0=''),
  394433 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=394433, CurrentID=0, Status='live', Symbol='Ugt1a5', Aliases='', description='UDP glucuronosyltransferase 1 family, polypeptide A5', other_designations='UDP glycosyltransferase 1 family, polypeptide A5', map_location='1 D', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=88166012, end_position_on_the_genomic_accession=88220002, orientation='plus', exon_count=5, OMIM='', no_hdr0=''),
  394434 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=394434, CurrentID=0, Status='live', Symbol='Ugt1a9', Aliases='UDPGT, UDPGT 1-9, UGT1-09, UGT1.9, UGTP4, Ugt1a12, mUGTBr/P', description='UDP glucuronosyltransferase 1 family, polypeptide A9', other_designations='UDP glycosyltransferase 1 family polypeptide A12|UDP-glucuronosyltransferase 1-7|UDP-glucuronosyltransferase 1A9', map_location='1 D', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=88070779, end_position_on_the_genomic_accession=88220002, orientation='plus', exon_count=5, OMIM='', no_hdr0=''),
  394435 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=394435, CurrentID=0, Status='live', Symbol='Ugt1a6b', Aliases="A9', Ugt1a9", description='UDP glucuronosyltransferase 1 family, polypeptide A6B', other_designations='UDP glycosyltransferase 1 family polypeptide A9', map_location='1 D', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=88103257, end_position_on_the_genomic_accession=88218998, orientation='plus', exon_count=6, OMIM='', no_hdr0=''),
  394436 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=394436, CurrentID=0, Status='live', Symbol='Ugt1a1', Aliases='Gnt1, UDPGT 1-1, UGT1A01, Udpgt-1a, UgtBr1', description='UDP glucuronosyltransferase 1 family, polypeptide A1', other_designations='UDP-glucuronosyltransferase 1 family, member 1|UDP-glucuronosyltransferase 1 family, polypeptide A1|UDP-glucuronosyltransferase 1A1|UDPGT|UGT1*1|UGT1-01|UGT1.1', map_location='1 44.55 cM', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=88211959, end_position_on_the_genomic_accession=88220002, orientation='plus', exon_count=5, OMIM='', no_hdr0=''),
  77696 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=77696, CurrentID=0, Status='live', Symbol='6720484G13Rik', Aliases='', description='RIKEN cDNA 6720484G13 gene', other_designations='', map_location='9', chromosome='9', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  263406 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=263406, CurrentID=0, Status='live', Symbol='Plekhg3', Aliases='BC030417', description='pleckstrin homology domain containing, family G (with RhoGef domain) member 3', other_designations='PH domain-containing family G member 3', map_location='12 C3', chromosome='12', genomic_nucleotide_accession_version='NC_000078.6', start_position_on_the_genomic_accession=76533247, end_position_on_the_genomic_accession=76579042, orientation='plus', exon_count=21, OMIM='', no_hdr0=''),
  546347 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=546347, CurrentID=0, Status='live', Symbol='Gm5941', Aliases='EG546347', description='predicted gene 5941', other_designations='', map_location='X', chromosome='X', genomic_nucleotide_accession_version='NC_000086.7', start_position_on_the_genomic_accession=92489949, end_position_on_the_genomic_accession=92490681, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  677440 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=677440, CurrentID=0, Status='live', Symbol='Clec2j', Aliases='Clrh, EG667622, Gm16457', description='C-type lectin domain family 2, member J', other_designations='lectin-like transmembrane protein', map_location='6 F3', chromosome='6', genomic_nucleotide_accession_version='NC_000072.6', start_position_on_the_genomic_accession=128654923, end_position_on_the_genomic_accession=128657089, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  102640476 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102640476, CurrentID=0, Status='live', Symbol='Gm36527', Aliases='Gm37156', description='predicted gene, 36527', other_designations='', map_location='1', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=151498034, end_position_on_the_genomic_accession=151500710, orientation='minus', exon_count=1, OMIM='', no_hdr0=''),
  263764 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=263764, CurrentID=0, Status='live', Symbol='Creg2', Aliases='A830098L22Rik', description='cellular repressor of E1A-stimulated genes 2', other_designations='', map_location='1 B', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=39618406, end_position_on_the_genomic_accession=39651510, orientation='minus', exon_count=5, OMIM='', no_hdr0=''),
  100271704 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=100271704, CurrentID=0, Status='live', Symbol='Gm17660', Aliases='Scpppq1', description='predicted gene, 17660', other_designations='secretory calcium-binding phosphoprotein proline-glutamine rich 1', map_location='5 50.54 cM', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=104070060, end_position_on_the_genomic_accession=104077608, orientation='minus', exon_count=10, OMIM='', no_hdr0=''),
  263803 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=263803, CurrentID=0, Status='live', Symbol='Pkn3', Aliases='AW209115, BC034126', description='protein kinase N3', other_designations='protein kinase PKN-beta|protein kinase PKNbeta|protein-kinase C-related kinase 3', map_location='2 B', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=30077544, end_position_on_the_genomic_accession=30091019, orientation='plus', exon_count=24, OMIM='', no_hdr0=''),
  100009600 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=100009600, CurrentID=0, Status='live', Symbol='Zglp1', Aliases='Glp1', description='zinc finger, GATA-like protein 1', other_designations='GATA-like 1|GATA-like protein 1|GLP-1', map_location='9 A3', chromosome='9', genomic_nucleotide_accession_version='NC_000075.6', start_position_on_the_genomic_accession=21062393, end_position_on_the_genomic_accession=21067093, orientation='minus', exon_count=5, OMIM='', no_hdr0=''),
  100009609 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=100009609, CurrentID=0, Status='live', Symbol='Vmn2r65', Aliases='ENSMUSG00000070600, V2ro', description='vomeronasal 2, receptor 65', other_designations='vomeronasal 2 receptor o|vomeronasal receptor Vmn2r65', map_location='7', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=84940169, end_position_on_the_genomic_accession=84964009, orientation='minus', exon_count=6, OMIM='', no_hdr0=''),
  100009614 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=100009614, CurrentID=0, Status='live', Symbol='Gm10024', Aliases='ENSMUSG00000057573', description='predicted gene 10024', other_designations='keratin associated protein LOC100009614', map_location='10', chromosome='10', genomic_nucleotide_accession_version='NC_000076.6', start_position_on_the_genomic_accession=77711446, end_position_on_the_genomic_accession=77712009, orientation='plus', exon_count=1, OMIM='', no_hdr0=''),
  263876 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=263876, CurrentID=0, Status='live', Symbol='Spata2', Aliases='AI504642, mKIAA0757', description='spermatogenesis associated 2', other_designations='', map_location='2 H3', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=167481136, end_position_on_the_genomic_accession=167492874, orientation='minus', exon_count=5, OMIM='', no_hdr0=''),
  100271882 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=100271882, CurrentID=0, Status='live', Symbol='Gm14139', Aliases='OTTMUSG00000015769', description='predicted gene 14139', other_designations='', map_location='2 G3', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=150181755, end_position_on_the_genomic_accession=150193279, orientation='plus', exon_count=4, OMIM='', no_hdr0=''),
  100271928 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=100271928, CurrentID=0, Status='live', Symbol='Gm15881', Aliases='OTTMUSG00000027193', description='predicted gene 15881', other_designations='myeloid-associated differentiation marker pseudogene|testis specific expressed protein 6', map_location='8', chromosome='8', genomic_nucleotide_accession_version='NC_000074.6', start_position_on_the_genomic_accession=58698849, end_position_on_the_genomic_accession=58700796, orientation='minus', exon_count=1, OMIM='', no_hdr0=''),
  677525 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=677525, CurrentID=0, Status='live', Symbol='LOC677525', Aliases='', description='sp110 nuclear body protein-like', other_designations='', map_location='1', chromosome='1', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  264064 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=264064, CurrentID=0, Status='live', Symbol='Cdk8', Aliases='', description='cyclin-dependent kinase 8', other_designations='cell division protein kinase 8|mediator complex subunit CDK8|mediator of RNA polymerase II transcription subunit CDK8', map_location='5 G3', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=146230736, end_position_on_the_genomic_accession=146302874, orientation='plus', exon_count=13, OMIM='', no_hdr0=''),
  264134 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=264134, CurrentID=0, Status='live', Symbol='Ttc26', Aliases='9330141E21Rik, 9430097H08Rik', description='tetratricopeptide repeat domain 26', other_designations='TPR repeat protein 26|protein hop-sterile|tetratricopeptide repeat protein 26', map_location='6 B1', chromosome='6', genomic_nucleotide_accession_version='NC_000072.6', start_position_on_the_genomic_accession=38381474, end_position_on_the_genomic_accession=38427647, orientation='plus', exon_count=18, OMIM='', no_hdr0=''),
  100534273 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=100534273, CurrentID=0, Status='live', Symbol='Fer1l5', Aliases='4930533C12Rik', description='fer-1-like 5 (C. elegans)', other_designations='fer-1-like 5 protein', map_location='1 B', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=36372199, end_position_on_the_genomic_accession=36422110, orientation='plus', exon_count=54, OMIM='', no_hdr0=''),
  102631503 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102631503, CurrentID=0, Status='live', Symbol='Gm29825', Aliases='', description='predicted gene, 29825', other_designations='', map_location='9', chromosome='9', genomic_nucleotide_accession_version='NC_000075.6', start_position_on_the_genomic_accession=114118054, end_position_on_the_genomic_accession=114192642, orientation='plus', exon_count=28, OMIM='', no_hdr0=''),
  546488 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=546488, CurrentID=0, Status='live', Symbol='Olfr785', Aliases='EG546488, MOR111-8P-ps1, Olfr785', description='olfactory receptor 785', other_designations='GA_x6K02T2PULF-11089673-11090600|MOR111-14_i|olfactory receptor MOR111-8P', map_location='10 D3', chromosome='10', genomic_nucleotide_accession_version='NC_000076.6', start_position_on_the_genomic_accession=129409368, end_position_on_the_genomic_accession=129410306, orientation='plus', exon_count=0, OMIM='', no_hdr0=''),
  102631521 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102631521, CurrentID=0, Status='live', Symbol='Gm29839', Aliases='', description='predicted gene, 29839', other_designations='', map_location='Y', chromosome='Y', genomic_nucleotide_accession_version='NC_000087.7', start_position_on_the_genomic_accession=39503482, end_position_on_the_genomic_accession=39517340, orientation='plus', exon_count=4, OMIM='', no_hdr0=''),
  102631522 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102631522, CurrentID=0, Status='live', Symbol='Gm29120', Aliases='', description='predicted gene 29120', other_designations='', map_location='Y', chromosome='Y', genomic_nucleotide_accession_version='NC_000087.7', start_position_on_the_genomic_accession=50501499, end_position_on_the_genomic_accession=50503965, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  218811 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=218811, CurrentID=0, Status='live', Symbol='Sec24c', Aliases='2610204K03Rik, mKIAA0079', description='Sec24 related gene family, member C (S. cerevisiae)', other_designations='', map_location='14 A3', chromosome='14', genomic_nucleotide_accession_version='NC_000080.6', start_position_on_the_genomic_accession=20674285, end_position_on_the_genomic_accession=20694852, orientation='plus', exon_count=26, OMIM='', no_hdr0=''),
  102631530 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102631530, CurrentID=0, Status='live', Symbol='Gm21762', Aliases='', description='predicted gene, 21762', other_designations='', map_location='13', chromosome='13', genomic_nucleotide_accession_version='NC_000079.6', start_position_on_the_genomic_accession=120214440, end_position_on_the_genomic_accession=120215828, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  102631538 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102631538, CurrentID=0, Status='live', Symbol='Gm29850', Aliases='', description='predicted gene, 29850', other_designations='', map_location='14', chromosome='14', genomic_nucleotide_accession_version='NC_000080.6', start_position_on_the_genomic_accession=57744941, end_position_on_the_genomic_accession=57753458, orientation='plus', exon_count=3, OMIM='', no_hdr0=''),
  102631559 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102631559, CurrentID=0, Status='live', Symbol='Gm29866', Aliases='', description='predicted gene, 29866', other_designations='', map_location='Y', chromosome='Y', genomic_nucleotide_accession_version='NC_000087.7', start_position_on_the_genomic_accession=20967492, end_position_on_the_genomic_accession=20993674, orientation='minus', exon_count=10, OMIM='', no_hdr0=''),
  102631563 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102631563, CurrentID=0, Status='live', Symbol='Gm21851', Aliases='', description='predicted gene, 21851', other_designations='', map_location='Y', chromosome='Y', genomic_nucleotide_accession_version='NC_000087.7', start_position_on_the_genomic_accession=56249470, end_position_on_the_genomic_accession=56251717, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  102631567 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102631567, CurrentID=0, Status='live', Symbol='Gm17188', Aliases='', description='predicted gene 17188', other_designations='', map_location='14 1.69 cM', chromosome='14', genomic_nucleotide_accession_version='NC_000080.6', start_position_on_the_genomic_accession=3027960, end_position_on_the_genomic_accession=3186287, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  109593 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=109593, CurrentID=0, Status='live', Symbol='Lmo3', Aliases='AI854781, BB106490, Rbtn-3, Rbtn3', description='LIM domain only 3', other_designations='LIM only 3|LMO-3|neuronal-specific transcription factor DAT1', map_location='6 69.02 cM', chromosome='6', genomic_nucleotide_accession_version='NC_000072.6', start_position_on_the_genomic_accession=138362918, end_position_on_the_genomic_accession=138581968, orientation='minus', exon_count=15, OMIM='', no_hdr0=''),
  102631585 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102631585, CurrentID=0, Status='live', Symbol='LOC102631585', Aliases='', description='gastrula zinc finger protein XlCGF17.1-like', other_designations='', map_location='', chromosome='4', genomic_nucleotide_accession_version='NC_000070.6', start_position_on_the_genomic_accession=147230278, end_position_on_the_genomic_accession=147259128, orientation='plus', exon_count=4, OMIM='', no_hdr0=''),
  102631589 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102631589, CurrentID=0, Status='live', Symbol='Gm10479', Aliases='ENSMUSG00000073184', description='predicted gene 10479', other_designations='', map_location='12 8.26 cM', chromosome='12', genomic_nucleotide_accession_version='NC_000078.6', start_position_on_the_genomic_accession=20322040, end_position_on_the_genomic_accession=20322651, orientation='plus', exon_count=1, OMIM='', no_hdr0=''),
  102631628 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102631628, CurrentID=0, Status='live', Symbol='Gm29494', Aliases='', description='predicted gene 29494', other_designations='', map_location='Y', chromosome='Y', genomic_nucleotide_accession_version='NC_000087.7', start_position_on_the_genomic_accession=39503124, end_position_on_the_genomic_accession=39506792, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  102631629 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102631629, CurrentID=0, Status='live', Symbol='Gm21843', Aliases='', description='predicted gene, 21843', other_designations='', map_location='Y', chromosome='Y', genomic_nucleotide_accession_version='NC_000087.7', start_position_on_the_genomic_accession=59830177, end_position_on_the_genomic_accession=59832581, orientation='plus', exon_count=3, OMIM='', no_hdr0=''),
  102631631 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102631631, CurrentID=0, Status='live', Symbol='Gm28125', Aliases='', description='predicted gene 28125', other_designations='', map_location='Y', chromosome='Y', genomic_nucleotide_accession_version='NC_000087.7', start_position_on_the_genomic_accession=82123433, end_position_on_the_genomic_accession=82128716, orientation='minus', exon_count=4, OMIM='', no_hdr0=''),
  240675 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=240675, CurrentID=0, Status='live', Symbol='Vwa2', Aliases='Amaco', description='von Willebrand factor A domain containing 2', other_designations='VWA-like domains, matrilins and collagens|a domain-containing protein similar to matrilin and collagen', map_location='19 D2', chromosome='19', genomic_nucleotide_accession_version='NC_000085.6', start_position_on_the_genomic_accession=56874416, end_position_on_the_genomic_accession=56912078, orientation='plus', exon_count=16, OMIM='', no_hdr0=''),
  100502916 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=100502916, CurrentID=0, Status='live', Symbol='Gm7284', Aliases='EG639992', description='predicted gene 7284', other_designations='', map_location='5', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=137000023, end_position_on_the_genomic_accession=137005604, orientation='plus', exon_count=6, OMIM='', no_hdr0=''),
  102631671 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102631671, CurrentID=0, Status='live', Symbol='Gm21819', Aliases='', description='predicted gene, 21819', other_designations='', map_location='Y', chromosome='Y', genomic_nucleotide_accession_version='NC_000087.7', start_position_on_the_genomic_accession=56323590, end_position_on_the_genomic_accession=56325909, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  102631681 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102631681, CurrentID=0, Status='live', Symbol='Gm29958', Aliases='', description='predicted gene, 29958', other_designations='', map_location='11', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=63619192, end_position_on_the_genomic_accession=63644391, orientation='plus', exon_count=5, OMIM='', no_hdr0=''),
  102631690 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102631690, CurrentID=0, Status='live', Symbol='Gm29964', Aliases='', description='predicted gene, 29964', other_designations='', map_location='4', chromosome='4', genomic_nucleotide_accession_version='NC_000070.6', start_position_on_the_genomic_accession=41882845, end_position_on_the_genomic_accession=41884547, orientation='plus', exon_count=1, OMIM='', no_hdr0=''),
  102631700 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102631700, CurrentID=0, Status='live', Symbol='Gm29377', Aliases='', description='predicted gene 29377', other_designations='', map_location='Y', chromosome='Y', genomic_nucleotide_accession_version='NC_000087.7', start_position_on_the_genomic_accession=66373342, end_position_on_the_genomic_accession=66378616, orientation='plus', exon_count=3, OMIM='', no_hdr0=''),
  102631705 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102631705, CurrentID=0, Status='live', Symbol='Gm29975', Aliases='', description='predicted gene, 29975', other_designations='', map_location='15', chromosome='15', genomic_nucleotide_accession_version='NC_000081.6', start_position_on_the_genomic_accession=27970010, end_position_on_the_genomic_accession=27973016, orientation='minus', exon_count=4, OMIM='', no_hdr0=''),
  102631713 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102631713, CurrentID=0, Status='live', Symbol='Gm29983', Aliases='', description='predicted gene, 29983', other_designations='', map_location='16', chromosome='16', genomic_nucleotide_accession_version='NC_000082.6', start_position_on_the_genomic_accession=92324107, end_position_on_the_genomic_accession=92333221, orientation='minus', exon_count=4, OMIM='', no_hdr0=''),
  102631717 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102631717, CurrentID=0, Status='live', Symbol='Gm29986', Aliases='', description='predicted gene, 29986', other_designations='', map_location='17', chromosome='17', genomic_nucleotide_accession_version='NC_000083.6', start_position_on_the_genomic_accession=18219105, end_position_on_the_genomic_accession=18234716, orientation='minus', exon_count=6, OMIM='', no_hdr0=''),
  240690 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=240690, CurrentID=0, Status='live', Symbol='St18', Aliases='AV348974, Myt3, NZF-3, Nzf3, mKIAA0535', description='suppression of tumorigenicity 18', other_designations='neural zinc finger protein NZF-3', map_location='1 A1', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=6487231, end_position_on_the_genomic_accession=6860940, orientation='plus', exon_count=30, OMIM='', no_hdr0=''),
  102631730 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102631730, CurrentID=0, Status='live', Symbol='4930512M02Rik', Aliases='', description='RIKEN cDNA 4930512M02 gene', other_designations='', map_location='11 A1', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=11589223, end_position_on_the_genomic_accession=11627818, orientation='minus', exon_count=4, OMIM='', no_hdr0=''),
  102631744 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102631744, CurrentID=0, Status='live', Symbol='Gm17174', Aliases='', description='predicted gene 17174', other_designations='', map_location='14 26.58 cM', chromosome='14', genomic_nucleotide_accession_version='NC_000080.6', start_position_on_the_genomic_accession=51571539, end_position_on_the_genomic_accession=51592189, orientation='minus', exon_count=5, OMIM='', no_hdr0=''),
  109625 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=109625, CurrentID=0, Status='live', Symbol='Es18', Aliases='Es-18', description='esterase 18', other_designations='', map_location='', chromosome='19', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  102631768 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102631768, CurrentID=0, Status='live', Symbol='Gm30022', Aliases='', description='predicted gene, 30022', other_designations='', map_location='3', chromosome='3', genomic_nucleotide_accession_version='NC_000069.6', start_position_on_the_genomic_accession=115906236, end_position_on_the_genomic_accession=115908163, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  102631773 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102631773, CurrentID=0, Status='live', Symbol='Gm29466', Aliases='', description='predicted gene 29466', other_designations='', map_location='Y', chromosome='Y', genomic_nucleotide_accession_version='NC_000087.7', start_position_on_the_genomic_accession=58034034, end_position_on_the_genomic_accession=58049097, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  100534622 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=100534622, CurrentID=0, Status='live', Symbol='Gm17449', Aliases='', description='predicted gene, 17449', other_designations='', map_location='13 34.54 cM', chromosome='13', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  102631775 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102631775, CurrentID=0, Status='live', Symbol='Gm21198', Aliases='', description='predicted gene, 21198', other_designations='', map_location='Y', chromosome='Y', genomic_nucleotide_accession_version='NC_000087.7', start_position_on_the_genomic_accession=78101490, end_position_on_the_genomic_accession=78103991, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  102631804 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102631804, CurrentID=0, Status='live', Symbol='Gm28671', Aliases='', description='predicted gene 28671', other_designations='', map_location='Y', chromosome='Y', genomic_nucleotide_accession_version='NC_000087.7', start_position_on_the_genomic_accession=89473681, end_position_on_the_genomic_accession=89475880, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  102631805 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102631805, CurrentID=0, Status='live', Symbol='LOC102631805', Aliases='', description='serine/threonine-protein kinase par-1-like', other_designations='', map_location='', chromosome='13', genomic_nucleotide_accession_version='NC_000079.6', start_position_on_the_genomic_accession=49787804, end_position_on_the_genomic_accession=49904523, orientation='plus', exon_count=16, OMIM='', no_hdr0=''),
  546543 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=546543, CurrentID=0, Status='live', Symbol='Gm5955', Aliases='', description='predicted gene 5955', other_designations='', map_location='12', chromosome='12', genomic_nucleotide_accession_version='NC_000078.6', start_position_on_the_genomic_accession=88124666, end_position_on_the_genomic_accession=88124887, orientation='plus', exon_count=1, OMIM='', no_hdr0=''),
  100141473 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=100141473, CurrentID=0, Status='live', Symbol='LOC100141473', Aliases='', description='low-density lipoprotein receptor domain class A containing protein', other_designations='', map_location='', chromosome='', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  100141474 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=100141474, CurrentID=0, Status='live', Symbol='4933428G20Rik', Aliases='', description='RIKEN cDNA 4933428G20 gene', other_designations='', map_location='11', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=97476180, end_position_on_the_genomic_accession=97500340, orientation='minus', exon_count=5, OMIM='', no_hdr0=''),
  102631848 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102631848, CurrentID=0, Status='live', Symbol='Gm28371', Aliases='', description='predicted gene 28371', other_designations='', map_location='Y', chromosome='Y', genomic_nucleotide_accession_version='NC_000087.7', start_position_on_the_genomic_accession=39988163, end_position_on_the_genomic_accession=39990562, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  102631852 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102631852, CurrentID=0, Status='live', Symbol='Gm30079', Aliases='', description='predicted gene, 30079', other_designations='', map_location='6', chromosome='6', genomic_nucleotide_accession_version='NC_000072.6', start_position_on_the_genomic_accession=17934266, end_position_on_the_genomic_accession=17942663, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  102631856 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102631856, CurrentID=0, Status='live', Symbol='Gm30083', Aliases='', description='predicted gene, 30083', other_designations='', map_location='14', chromosome='14', genomic_nucleotide_accession_version='NC_000080.6', start_position_on_the_genomic_accession=33975250, end_position_on_the_genomic_accession=34021506, orientation='minus', exon_count=22, OMIM='', no_hdr0=''),
  102631857 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102631857, CurrentID=0, Status='live', Symbol='Gm27017', Aliases='', description='predicted gene, 27017', other_designations='', map_location='14', chromosome='14', genomic_nucleotide_accession_version='NC_000080.6', start_position_on_the_genomic_accession=61680039, end_position_on_the_genomic_accession=61686642, orientation='plus', exon_count=3, OMIM='', no_hdr0=''),
  102631897 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102631897, CurrentID=0, Status='live', Symbol='Astx1c', Aliases='Gm14962, OTTMUSG00000018603', description='amplified spermatogenic transcripts X encoded 1C', other_designations='', map_location='X 49.81 cM', chromosome='X', genomic_nucleotide_accession_version='NC_000086.7', start_position_on_the_genomic_accession=125725844, end_position_on_the_genomic_accession=125737930, orientation='plus', exon_count=11, OMIM='', no_hdr0=''),
  102631909 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102631909, CurrentID=0, Status='live', Symbol='Gm30124', Aliases='', description='predicted gene, 30124', other_designations='', map_location='12', chromosome='12', genomic_nucleotide_accession_version='NC_000078.6', start_position_on_the_genomic_accession=20938602, end_position_on_the_genomic_accession=21039945, orientation='plus', exon_count=3, OMIM='', no_hdr0=''),
  102631913 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102631913, CurrentID=0, Status='live', Symbol='Gm21795', Aliases='', description='predicted gene, 21795', other_designations='', map_location='Y', chromosome='Y', genomic_nucleotide_accession_version='NC_000087.7', start_position_on_the_genomic_accession=35503065, end_position_on_the_genomic_accession=35503763, orientation='plus', exon_count=1, OMIM='', no_hdr0=''),
  109654 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=109654, CurrentID=0, Status='live', Symbol='Cd24c', Aliases='', description='CD24c antigen', other_designations='', map_location='', chromosome='14', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  328108 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=328108, CurrentID=0, Status='live', Symbol='Fam179b', Aliases='A430041B07Rik, BC062107, C130034K06, mKIAA0423', description='family with sequence similarity 179, member B', other_designations='', map_location='12 C1', chromosome='12', genomic_nucleotide_accession_version='NC_000078.6', start_position_on_the_genomic_accession=64965742, end_position_on_the_genomic_accession=65022573, orientation='plus', exon_count=22, OMIM='', no_hdr0=''),
  328113 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=328113, CurrentID=0, Status='live', Symbol='A230055C15', Aliases='', description='uncharacterized protein A230055C15', other_designations='', map_location='12 C1', chromosome='12', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  102631980 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102631980, CurrentID=0, Status='live', Symbol='Gm30172', Aliases='', description='predicted gene, 30172', other_designations='', map_location='11', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=5263754, end_position_on_the_genomic_accession=5275926, orientation='plus', exon_count=4, OMIM='', no_hdr0=''),
  102631985 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102631985, CurrentID=0, Status='live', Symbol='Gm30175', Aliases='', description='predicted gene, 30175', other_designations='', map_location='Y', chromosome='Y', genomic_nucleotide_accession_version='NC_000087.7', start_position_on_the_genomic_accession=24863290, end_position_on_the_genomic_accession=24873253, orientation='plus', exon_count=5, OMIM='', no_hdr0=''),
  102631990 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102631990, CurrentID=0, Status='live', Symbol='Gm21825', Aliases='', description='predicted gene, 21825', other_designations='', map_location='Y', chromosome='Y', genomic_nucleotide_accession_version='NC_000087.7', start_position_on_the_genomic_accession=82162734, end_position_on_the_genomic_accession=82163432, orientation='minus', exon_count=1, OMIM='', no_hdr0=''),
  102632010 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102632010, CurrentID=0, Status='live', Symbol='Gm30191', Aliases='', description='predicted gene, 30191', other_designations='', map_location='4', chromosome='4', genomic_nucleotide_accession_version='NC_000070.6', start_position_on_the_genomic_accession=134246453, end_position_on_the_genomic_accession=134250824, orientation='plus', exon_count=7, OMIM='', no_hdr0=''),
  102632017 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102632017, CurrentID=0, Status='live', Symbol='Gm30196', Aliases='', description='predicted gene, 30196', other_designations='modulator of retrovirus infection homolog', map_location='7', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=60293183, end_position_on_the_genomic_accession=60294091, orientation='plus', exon_count=1, OMIM='', no_hdr0=''),
  102632023 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102632023, CurrentID=0, Status='live', Symbol='Gm28603', Aliases='', description='predicted gene 28603', other_designations='', map_location='Y', chromosome='Y', genomic_nucleotide_accession_version='NC_000087.7', start_position_on_the_genomic_accession=46968697, end_position_on_the_genomic_accession=46971101, orientation='plus', exon_count=3, OMIM='', no_hdr0=''),
  102632097 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102632097, CurrentID=0, Status='live', Symbol='Gm30260', Aliases='', description='predicted gene, 30260', other_designations='', map_location='2', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=180497504, end_position_on_the_genomic_accession=180500413, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  102632102 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102632102, CurrentID=0, Status='live', Symbol='LOC102632102', Aliases='', description='zinc finger protein 69-like', other_designations='', map_location='', chromosome='12', genomic_nucleotide_accession_version='NC_000078.6', start_position_on_the_genomic_accession=18135912, end_position_on_the_genomic_accession=18187970, orientation='plus', exon_count=7, OMIM='', no_hdr0=''),
  102632105 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102632105, CurrentID=0, Status='live', Symbol='Gm21821', Aliases='', description='predicted gene, 21821', other_designations='', map_location='Y', chromosome='Y', genomic_nucleotide_accession_version='NC_000087.7', start_position_on_the_genomic_accession=32220190, end_position_on_the_genomic_accession=32223771, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  102632113 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102632113, CurrentID=0, Status='live', Symbol='LOC102632113', Aliases='', description='uncharacterized LOC102632113', other_designations='', map_location='', chromosome='14', genomic_nucleotide_accession_version='NC_000080.6', start_position_on_the_genomic_accession=7256208, end_position_on_the_genomic_accession=7264653, orientation='minus', exon_count=5, OMIM='', no_hdr0=''),
  264895 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=264895, CurrentID=0, Status='live', Symbol='Acsf2', Aliases='', description='acyl-CoA synthetase family member 2', other_designations='', map_location='11 D', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=94557102, end_position_on_the_genomic_accession=94601891, orientation='minus', exon_count=16, OMIM='', no_hdr0=''),
  102632135 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102632135, CurrentID=0, Status='live', Symbol='Gm30289', Aliases='', description='predicted gene, 30289', other_designations='', map_location='3', chromosome='3', genomic_nucleotide_accession_version='NC_000069.6', start_position_on_the_genomic_accession=40980026, end_position_on_the_genomic_accession=41040207, orientation='plus', exon_count=14, OMIM='', no_hdr0=''),
  102632138 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102632138, CurrentID=0, Status='live', Symbol='Gm30291', Aliases='', description='predicted gene, 30291', other_designations='', map_location='12', chromosome='12', genomic_nucleotide_accession_version='NC_000078.6', start_position_on_the_genomic_accession=22582407, end_position_on_the_genomic_accession=22585733, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  102632142 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102632142, CurrentID=0, Status='live', Symbol='LOC102632142', Aliases='', description='C3a anaphylatoxin chemotactic receptor-like', other_designations='', map_location='', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=44267617, end_position_on_the_genomic_accession=44273158, orientation='minus', exon_count=4, OMIM='', no_hdr0=''),
  102632145 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102632145, CurrentID=0, Status='live', Symbol='Gm21804', Aliases='', description='predicted gene, 21804', other_designations='', map_location='Y', chromosome='Y', genomic_nucleotide_accession_version='NC_000087.7', start_position_on_the_genomic_accession=28516659, end_position_on_the_genomic_accession=28518975, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  102632152 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102632152, CurrentID=0, Status='live', Symbol='Gm30302', Aliases='', description='predicted gene, 30302', other_designations='', map_location='13', chromosome='13', genomic_nucleotide_accession_version='NC_000079.6', start_position_on_the_genomic_accession=49784747, end_position_on_the_genomic_accession=49790401, orientation='minus', exon_count=4, OMIM='', no_hdr0=''),
  102632166 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102632166, CurrentID=0, Status='live', Symbol='Gm30312', Aliases='', description='predicted gene, 30312', other_designations='', map_location='Y', chromosome='Y', genomic_nucleotide_accession_version='NC_000087.7', start_position_on_the_genomic_accession=18243861, end_position_on_the_genomic_accession=18246312, orientation='plus', exon_count=3, OMIM='', no_hdr0=''),
  102632168 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102632168, CurrentID=0, Status='live', Symbol='Gm30314', Aliases='', description='predicted gene, 30314', other_designations='', map_location='9', chromosome='9', genomic_nucleotide_accession_version='NC_000075.6', start_position_on_the_genomic_accession=65832116, end_position_on_the_genomic_accession=65841198, orientation='plus', exon_count=5, OMIM='', no_hdr0=''),
  102632183 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102632183, CurrentID=0, Status='live', Symbol='Gm21865', Aliases='', description='predicted gene, 21865', other_designations='', map_location='Y', chromosome='Y', genomic_nucleotide_accession_version='NC_000087.7', start_position_on_the_genomic_accession=40290945, end_position_on_the_genomic_accession=40316922, orientation='minus', exon_count=10, OMIM='', no_hdr0=''),
  102632185 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102632185, CurrentID=0, Status='live', Symbol='Gm21808', Aliases='', description='predicted gene, 21808', other_designations='', map_location='Y', chromosome='Y', genomic_nucleotide_accession_version='NC_000087.7', start_position_on_the_genomic_accession=70780583, end_position_on_the_genomic_accession=70782934, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  102632202 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102632202, CurrentID=0, Status='live', Symbol='Gm30342', Aliases='', description='predicted gene, 30342', other_designations='', map_location='16', chromosome='16', genomic_nucleotide_accession_version='NC_000082.6', start_position_on_the_genomic_accession=92713510, end_position_on_the_genomic_accession=92714978, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  546611 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=546611, CurrentID=0, Status='live', Symbol='Klhl33', Aliases='EG546611', description='kelch-like 33', other_designations='', map_location='14 C1', chromosome='14', genomic_nucleotide_accession_version='NC_000080.6', start_position_on_the_genomic_accession=50891336, end_position_on_the_genomic_accession=50896531, orientation='minus', exon_count=4, OMIM='', no_hdr0=''),
  102632256 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102632256, CurrentID=0, Status='live', Symbol='LOC102632256', Aliases='', description='doublesex- and mab-3-related transcription factor C1-like', other_designations='', map_location='', chromosome='X', genomic_nucleotide_accession_version='NC_000086.7', start_position_on_the_genomic_accession=102776554, end_position_on_the_genomic_accession=102779496, orientation='plus', exon_count=5, OMIM='', no_hdr0=''),
  102632261 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102632261, CurrentID=0, Status='live', Symbol='Gm21803', Aliases='', description='predicted gene, 21803', other_designations='', map_location='Y', chromosome='Y', genomic_nucleotide_accession_version='NC_000087.7', start_position_on_the_genomic_accession=89844717, end_position_on_the_genomic_accession=89846930, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  22327 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=22327, CurrentID=0, Status='live', Symbol='Vbp1', Aliases='VBP-1', description='von Hippel-Lindau binding protein 1', other_designations='VHL-binding protein 1|von Hippel-Lindau-binding protein 1', map_location='X 38.25 cM', chromosome='X', genomic_nucleotide_accession_version='NC_000086.7', start_position_on_the_genomic_accession=75514278, end_position_on_the_genomic_accession=75534946, orientation='plus', exon_count=7, OMIM='', no_hdr0=''),
  102632285 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102632285, CurrentID=0, Status='live', Symbol='Gm38443', Aliases='', description='predicted gene, 38443', other_designations='', map_location='7', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=29575898, end_position_on_the_genomic_accession=29577893, orientation='plus', exon_count=1, OMIM='', no_hdr0=''),
  102632299 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102632299, CurrentID=0, Status='live', Symbol='Gm30411', Aliases='', description='predicted gene, 30411', other_designations='', map_location='13', chromosome='13', genomic_nucleotide_accession_version='NC_000079.6', start_position_on_the_genomic_accession=106712003, end_position_on_the_genomic_accession=106760897, orientation='minus', exon_count=7, OMIM='', no_hdr0=''),
  102632326 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102632326, CurrentID=0, Status='live', Symbol='Gm21350', Aliases='', description='predicted gene, 21350', other_designations='', map_location='Y', chromosome='Y', genomic_nucleotide_accession_version='NC_000087.7', start_position_on_the_genomic_accession=24894925, end_position_on_the_genomic_accession=24895608, orientation='plus', exon_count=1, OMIM='', no_hdr0=''),
  102632329 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102632329, CurrentID=0, Status='live', Symbol='Gm28689', Aliases='', description='predicted gene 28689', other_designations='', map_location='Y', chromosome='Y', genomic_nucleotide_accession_version='NC_000087.7', start_position_on_the_genomic_accession=60568903, end_position_on_the_genomic_accession=60586264, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  396184 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=396184, CurrentID=0, Status='live', Symbol='Flrt1', Aliases='AW742165, D630040I23Rik', description='fibronectin leucine rich transmembrane protein 1', other_designations='', map_location='19 A', chromosome='19', genomic_nucleotide_accession_version='NC_000085.6', start_position_on_the_genomic_accession=7087464, end_position_on_the_genomic_accession=7166030, orientation='minus', exon_count=4, OMIM='', no_hdr0=''),
  102632353 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102632353, CurrentID=0, Status='live', Symbol='Gm30447', Aliases='', description='predicted gene, 30447', other_designations='', map_location='9', chromosome='9', genomic_nucleotide_accession_version='NC_000075.6', start_position_on_the_genomic_accession=66350321, end_position_on_the_genomic_accession=66354154, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  102632367 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102632367, CurrentID=0, Status='live', Symbol='LOC102632367', Aliases='', description='doublesex- and mab-3-related transcription factor C1-like', other_designations='', map_location='', chromosome='X', genomic_nucleotide_accession_version='NC_000086.7', start_position_on_the_genomic_accession=102880507, end_position_on_the_genomic_accession=102882317, orientation='minus', exon_count=4, OMIM='', no_hdr0=''),
  632955 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=632955, CurrentID=0, Status='live', Symbol='Gm7097', Aliases='', description='predicted gene 7097', other_designations='', map_location='10', chromosome='10', genomic_nucleotide_accession_version='NC_000076.5', start_position_on_the_genomic_accession=69746983, end_position_on_the_genomic_accession=69748386, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  102632383 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102632383, CurrentID=0, Status='live', Symbol='LOC102632383', Aliases='', description='zinc finger protein 431-like', other_designations='', map_location='', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=121904357, end_position_on_the_genomic_accession=121956771, orientation='minus', exon_count=6, OMIM='', no_hdr0=''),
  102632386 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102632386, CurrentID=0, Status='live', Symbol='Gm30473', Aliases='', description='predicted gene, 30473', other_designations='', map_location='1', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=178067103, end_position_on_the_genomic_accession=178172707, orientation='plus', exon_count=18, OMIM='', no_hdr0=''),
  102632402 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102632402, CurrentID=0, Status='live', Symbol='Gm38445', Aliases='', description='predicted gene, 38445', other_designations='60S ribosomal protein L29', map_location='3', chromosome='3', genomic_nucleotide_accession_version='NC_000069.6', start_position_on_the_genomic_accession=149190093, end_position_on_the_genomic_accession=149211196, orientation='plus', exon_count=3, OMIM='', no_hdr0=''),
  546638 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=546638, CurrentID=0, Status='live', Symbol='Ube2d4', Aliases='EG546638, Gm5959', description='ubiquitin-conjugating enzyme E2D 4', other_designations='', map_location='15 D1', chromosome='15', genomic_nucleotide_accession_version='NC_000081.6', start_position_on_the_genomic_accession=58823827, end_position_on_the_genomic_accession=58847321, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  102632410 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102632410, CurrentID=0, Status='live', Symbol='Gm29002', Aliases='', description='predicted gene 29002', other_designations='', map_location='Y', chromosome='Y', genomic_nucleotide_accession_version='NC_000087.7', start_position_on_the_genomic_accession=66971135, end_position_on_the_genomic_accession=66973382, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  102632416 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102632416, CurrentID=0, Status='live', Symbol='LOC102632416', Aliases='', description='zinc finger protein 431-like', other_designations='', map_location='', chromosome='13', genomic_nucleotide_accession_version='NC_000079.6', start_position_on_the_genomic_accession=74433740, end_position_on_the_genomic_accession=74445174, orientation='minus', exon_count=4, OMIM='', no_hdr0=''),
  102632425 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102632425, CurrentID=0, Status='live', Symbol='Gm30500', Aliases='', description='predicted gene, 30500', other_designations='', map_location='14', chromosome='14', genomic_nucleotide_accession_version='NC_000080.6', start_position_on_the_genomic_accession=72472092, end_position_on_the_genomic_accession=72483794, orientation='minus', exon_count=11, OMIM='', no_hdr0=''),
  22355 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=22355, CurrentID=0, Status='live', Symbol='Vipr2', Aliases='VPAC2, VPAC2R, Vip2', description='vasoactive intestinal peptide receptor 2', other_designations='PACAP type III receptor|PACAP-R-3|PACAP-R3|VIP receptor subtype 2|VIP-R-2|VPAC2 receptor|pituitary adenylate cyclase-activating polypeptide type III receptor', map_location='12 F2', chromosome='12', genomic_nucleotide_accession_version='NC_000078.6', start_position_on_the_genomic_accession=116077726, end_position_on_the_genomic_accession=116159604, orientation='plus', exon_count=16, OMIM='', no_hdr0=''),
  328192 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=328192, CurrentID=0, Status='live', Symbol='9530076L18', Aliases='', description='uncharacterized protein 9530076L18', other_designations='', map_location='13 A1', chromosome='13', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  546648 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=546648, CurrentID=0, Status='live', Symbol='Klhdc7b', Aliases='EG546648, Gm306', description='kelch domain containing 7B', other_designations='', map_location='15 E3', chromosome='15', genomic_nucleotide_accession_version='NC_000081.6', start_position_on_the_genomic_accession=89386891, end_position_on_the_genomic_accession=89388708, orientation='plus', exon_count=1, OMIM='', no_hdr0=''),
  102632467 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102632467, CurrentID=0, Status='live', Symbol='Gm30531', Aliases='', description='predicted gene, 30531', other_designations='', map_location='17', chromosome='17', genomic_nucleotide_accession_version='NC_000083.6', start_position_on_the_genomic_accession=21630859, end_position_on_the_genomic_accession=21633530, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  102632470 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102632470, CurrentID=0, Status='live', Symbol='Gm30534', Aliases='', description='predicted gene, 30534', other_designations='', map_location='10', chromosome='10', genomic_nucleotide_accession_version='NC_000076.6', start_position_on_the_genomic_accession=26965973, end_position_on_the_genomic_accession=26966291, orientation='plus', exon_count=1, OMIM='', no_hdr0=''),
  102632483 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102632483, CurrentID=0, Status='live', Symbol='Gm17330', Aliases='', description='predicted gene, 17330', other_designations='', map_location='12 8.46 cM', chromosome='12', genomic_nucleotide_accession_version='NC_000078.6', start_position_on_the_genomic_accession=23886478, end_position_on_the_genomic_accession=24096232, orientation='minus', exon_count=10, OMIM='', no_hdr0=''),
  240817 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=240817, CurrentID=0, Status='live', Symbol='Teddm2', Aliases='5830403L16Rik, AJ554213, Me9, e92', description='transmembrane epididymal family member 2', other_designations='epididymal protein Me9', map_location='1 G3', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=153849542, end_position_on_the_genomic_accession=153851195, orientation='minus', exon_count=1, OMIM='', no_hdr0=''),
  102632492 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102632492, CurrentID=0, Status='live', Symbol='Gm30551', Aliases='', description='predicted gene, 30551', other_designations='', map_location='13', chromosome='13', genomic_nucleotide_accession_version='NC_000079.6', start_position_on_the_genomic_accession=103591552, end_position_on_the_genomic_accession=103708656, orientation='minus', exon_count=9, OMIM='', no_hdr0=''),
  109747 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=109747, CurrentID=0, Status='live', Symbol='Rasl3', Aliases='', description='RAS-like, family 3', other_designations='', map_location='', chromosome='17', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  102632506 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102632506, CurrentID=0, Status='live', Symbol='Gm12591', Aliases='OTTMUSG00000007634', description='predicted gene 12591', other_designations='', map_location='11 88.0 cM', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=121968290, end_position_on_the_genomic_accession=121969009, orientation='minus', exon_count=1, OMIM='', no_hdr0=''),
  102632525 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102632525, CurrentID=0, Status='live', Symbol='Gm21842', Aliases='', description='predicted gene, 21842', other_designations='', map_location='Y', chromosome='Y', genomic_nucleotide_accession_version='NC_000087.7', start_position_on_the_genomic_accession=32282610, end_position_on_the_genomic_accession=32296680, orientation='plus', exon_count=4, OMIM='', no_hdr0=''),
  102632527 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102632527, CurrentID=0, Status='live', Symbol='Gm28554', Aliases='', description='predicted gene 28554', other_designations='', map_location='Y', chromosome='Y', genomic_nucleotide_accession_version='NC_000087.7', start_position_on_the_genomic_accession=47356874, end_position_on_the_genomic_accession=47360483, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  102632538 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102632538, CurrentID=0, Status='live', Symbol='LOC102632538', Aliases='', description='mucin-1-like', other_designations='', map_location='', chromosome='3', genomic_nucleotide_accession_version='NC_000069.6', start_position_on_the_genomic_accession=38880583, end_position_on_the_genomic_accession=38886961, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  102632539 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102632539, CurrentID=0, Status='live', Symbol='Astx1b', Aliases='Gm14953, OTTMUSG00000018588', description='amplified spermatogenic transcripts X encoded 1B', other_designations='', map_location='X 49.81 cM', chromosome='X', genomic_nucleotide_accession_version='NC_000086.7', start_position_on_the_genomic_accession=124902081, end_position_on_the_genomic_accession=124914124, orientation='plus', exon_count=9, OMIM='', no_hdr0=''),
  102632553 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102632553, CurrentID=0, Status='live', Symbol='Gm30598', Aliases='', description='predicted gene, 30598', other_designations='', map_location='Y', chromosome='Y', genomic_nucleotide_accession_version='NC_000087.7', start_position_on_the_genomic_accession=21131674, end_position_on_the_genomic_accession=21136961, orientation='plus', exon_count=5, OMIM='', no_hdr0=''),
  102632554 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102632554, CurrentID=0, Status='live', Symbol='Gm30599', Aliases='', description='predicted gene, 30599', other_designations='', map_location='12', chromosome='12', genomic_nucleotide_accession_version='NC_000078.6', start_position_on_the_genomic_accession=113145603, end_position_on_the_genomic_accession=113147876, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  102632555 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102632555, CurrentID=0, Status='live', Symbol='Gm12873', Aliases='OTTMUSG00000008874', description='predicted gene 12873', other_designations='', map_location='4 57.26 cM', chromosome='4', genomic_nucleotide_accession_version='NC_000070.6', start_position_on_the_genomic_accession=122752037, end_position_on_the_genomic_accession=122793803, orientation='minus', exon_count=6, OMIM='', no_hdr0=''),
  102632574 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102632574, CurrentID=0, Status='live', Symbol='Gm30612', Aliases='', description='predicted gene, 30612', other_designations='', map_location='1', chromosome='1', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  109760 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=109760, CurrentID=0, Status='live', Symbol='Pol15', Aliases='Pol-15', description='viral polymerase 15', other_designations='', map_location='', chromosome='2', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  102632590 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102632590, CurrentID=0, Status='live', Symbol='Gm26851', Aliases='', description='predicted gene, 26851', other_designations='', map_location='X', chromosome='X', genomic_nucleotide_accession_version='NC_000086.7', start_position_on_the_genomic_accession=133687754, end_position_on_the_genomic_accession=133707257, orientation='plus', exon_count=4, OMIM='', no_hdr0=''),
  102632608 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102632608, CurrentID=0, Status='live', Symbol='Gm30638', Aliases='', description='predicted gene, 30638', other_designations='', map_location='Y', chromosome='Y', genomic_nucleotide_accession_version='NC_000087.7', start_position_on_the_genomic_accession=18494780, end_position_on_the_genomic_accession=18523961, orientation='plus', exon_count=8, OMIM='', no_hdr0=''),
  102632630 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102632630, CurrentID=0, Status='live', Symbol='Gm30656', Aliases='', description='predicted gene, 30656', other_designations='', map_location='13', chromosome='13', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  102632635 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102632635, CurrentID=0, Status='live', Symbol='Gm26843', Aliases='', description='predicted gene, 26843', other_designations='', map_location='8', chromosome='8', genomic_nucleotide_accession_version='NC_000074.6', start_position_on_the_genomic_accession=93565985, end_position_on_the_genomic_accession=93811667, orientation='minus', exon_count=21, OMIM='', no_hdr0=''),
  109771 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=109771, CurrentID=0, Status='live', Symbol='Tcp8', Aliases='Tcp-8', description='t-complex protein 8', other_designations='', map_location='', chromosome='17', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  102632650 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102632650, CurrentID=0, Status='live', Symbol='Gm30672', Aliases='', description='predicted gene, 30672', other_designations='', map_location='2', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=28721025, end_position_on_the_genomic_accession=28728868, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  102632652 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102632652, CurrentID=0, Status='live', Symbol='Gm30674', Aliases='', description='predicted gene, 30674', other_designations='', map_location='10', chromosome='10', genomic_nucleotide_accession_version='NC_000076.6', start_position_on_the_genomic_accession=3102270, end_position_on_the_genomic_accession=3104885, orientation='plus', exon_count=3, OMIM='', no_hdr0=''),
  102632676 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102632676, CurrentID=0, Status='live', Symbol='Gm28738', Aliases='', description='predicted gene 28738', other_designations='', map_location='Y', chromosome='Y', genomic_nucleotide_accession_version='NC_000087.7', start_position_on_the_genomic_accession=52383999, end_position_on_the_genomic_accession=52384574, orientation='plus', exon_count=1, OMIM='', no_hdr0=''),
  328231 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=328231, CurrentID=0, Status='live', Symbol='Gm5082', Aliases='A030008J09, EG328231', description='predicted gene 5082', other_designations='', map_location='13', chromosome='13', genomic_nucleotide_accession_version='NC_000079.6', start_position_on_the_genomic_accession=41648847, end_position_on_the_genomic_accession=41656950, orientation='plus', exon_count=6, OMIM='', no_hdr0=''),
  102632688 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102632688, CurrentID=0, Status='live', Symbol='Gm30694', Aliases='', description='predicted gene, 30694', other_designations='', map_location='1', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=157124720, end_position_on_the_genomic_accession=157128226, orientation='plus', exon_count=4, OMIM='', no_hdr0=''),
  102632693 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102632693, CurrentID=0, Status='live', Symbol='Gm30698', Aliases='', description='predicted gene, 30698', other_designations='', map_location='10', chromosome='10', genomic_nucleotide_accession_version='NC_000076.6', start_position_on_the_genomic_accession=29361396, end_position_on_the_genomic_accession=29362623, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  328233 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=328233, CurrentID=0, Status='live', Symbol='C230040D14', Aliases='', description='uncharacterized protein C230040D14', other_designations='', map_location='13 A5', chromosome='13', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  328234 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=328234, CurrentID=0, Status='live', Symbol='Rnf182', Aliases='C630023L15Rik', description='ring finger protein 182', other_designations='', map_location='13 A4', chromosome='13', genomic_nucleotide_accession_version='NC_000079.6', start_position_on_the_genomic_accession=43615158, end_position_on_the_genomic_accession=43670946, orientation='plus', exon_count=3, OMIM='', no_hdr0=''),
  102632705 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102632705, CurrentID=0, Status='live', Symbol='Gm21854', Aliases='', description='predicted gene, 21854', other_designations='', map_location='Y', chromosome='Y', genomic_nucleotide_accession_version='NC_000087.7', start_position_on_the_genomic_accession=5656949, end_position_on_the_genomic_accession=5659568, orientation='plus', exon_count=3, OMIM='', no_hdr0=''),
  102632739 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102632739, CurrentID=0, Status='live', Symbol='LOC102632739', Aliases='', description='dolichyl-diphosphooligosaccharide--protein glycosyltransferase subunit 4-like', other_designations='', map_location='', chromosome='18', genomic_nucleotide_accession_version='NC_000084.6', start_position_on_the_genomic_accession=38714367, end_position_on_the_genomic_accession=38714623, orientation='plus', exon_count=1, OMIM='', no_hdr0=''),
  102632742 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102632742, CurrentID=0, Status='live', Symbol='Scgb2b4-ps', Aliases='Abpbg4-ps', description='secretoglobin, family 2B, member 4, pseudogene', other_designations='', map_location='7', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=31399585, end_position_on_the_genomic_accession=31403178, orientation='minus', exon_count=4, OMIM='', no_hdr0=''),
  102632745 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102632745, CurrentID=0, Status='live', Symbol='Gm30737', Aliases='', description='predicted gene, 30737', other_designations='', map_location='Y', chromosome='Y', genomic_nucleotide_accession_version='NC_000087.7', start_position_on_the_genomic_accession=14402154, end_position_on_the_genomic_accession=14426602, orientation='plus', exon_count=7, OMIM='', no_hdr0=''),
  100504669 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=100504669, CurrentID=0, Status='live', Symbol='Gm20343', Aliases='', description='predicted gene, 20343', other_designations='', map_location='18 43.53 cM', chromosome='18', genomic_nucleotide_accession_version='NC_000084.6', start_position_on_the_genomic_accession=69771796, end_position_on_the_genomic_accession=69816825, orientation='plus', exon_count=5, OMIM='', no_hdr0=''),
  102632749 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102632749, CurrentID=0, Status='live', Symbol='Gm21801', Aliases='', description='predicted gene, 21801', other_designations='', map_location='Y', chromosome='Y', genomic_nucleotide_accession_version='NC_000087.7', start_position_on_the_genomic_accession=40388793, end_position_on_the_genomic_accession=40392178, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  102632750 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102632750, CurrentID=0, Status='live', Symbol='Gm28234', Aliases='', description='predicted gene 28234', other_designations='', map_location='Y', chromosome='Y', genomic_nucleotide_accession_version='NC_000087.7', start_position_on_the_genomic_accession=53154828, end_position_on_the_genomic_accession=53157473, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  102632767 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102632767, CurrentID=0, Status='live', Symbol='Gm30755', Aliases='', description='predicted gene, 30755', other_designations='', map_location='8', chromosome='8', genomic_nucleotide_accession_version='NC_000074.6', start_position_on_the_genomic_accession=12127521, end_position_on_the_genomic_accession=12142902, orientation='minus', exon_count=8, OMIM='', no_hdr0=''),
  328250 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=328250, CurrentID=0, Status='live', Symbol='Nutm2', Aliases='Fam22, Gm806', description='NUT family member 2', other_designations='NUT family member Gm806|protein FAM22', map_location='13 A5', chromosome='13', genomic_nucleotide_accession_version='NC_000079.6', start_position_on_the_genomic_accession=50467307, end_position_on_the_genomic_accession=50475355, orientation='plus', exon_count=7, OMIM='', no_hdr0=''),
  102632798 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102632798, CurrentID=0, Status='live', Symbol='Gm28446', Aliases='', description='predicted gene 28446', other_designations='', map_location='Y', chromosome='Y', genomic_nucleotide_accession_version='NC_000087.7', start_position_on_the_genomic_accession=63642339, end_position_on_the_genomic_accession=63644859, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  240869 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=240869, CurrentID=0, Status='live', Symbol='Zbtb37', Aliases='D430004I08Rik', description='zinc finger and BTB domain containing 37', other_designations='', map_location='1 H2.1', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=161008792, end_position_on_the_genomic_accession=161034864, orientation='minus', exon_count=9, OMIM='', no_hdr0=''),
  100498 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=100498, CurrentID=0, Status='live', Symbol='AA408213', Aliases='', description='expressed sequence AA408213', other_designations='', map_location='', chromosome='5', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  102632821 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102632821, CurrentID=0, Status='live', Symbol='LOC102632821', Aliases='', description='60S acidic ribosomal protein P1-like', other_designations='', map_location='', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=91030734, end_position_on_the_genomic_accession=91053940, orientation='minus', exon_count=10, OMIM='', no_hdr0=''),
  109801 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=109801, CurrentID=0, Status='live', Symbol='Glo1', Aliases='0610009E22Rik, 1110008E19Rik, 2510049H23Rik, AW550643, GLY1, Glo-1, Glo-1r, Glo-1s-r, Glo1-s, Qglo, Glo1', description='glyoxalase 1', other_designations='S-D-lactoylglutathione methylglyoxal lyase|aldoketomutase|glx I|glyoxalase 1 complex|glyoxalase 1 regulatory|glyoxalase 1 structural|glyoxalase I|ketone-aldehyde mutase|methylglyoxalase', map_location='17 15.69 cM', chromosome='17', genomic_nucleotide_accession_version='NC_000083.6', start_position_on_the_genomic_accession=30592861, end_position_on_the_genomic_accession=30612659, orientation='minus', exon_count=6, OMIM='', no_hdr0=''),
  102632826 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102632826, CurrentID=0, Status='live', Symbol='Gm17577', Aliases='', description='predicted gene, 17577', other_designations='', map_location='X 49.81 cM', chromosome='X', genomic_nucleotide_accession_version='NC_000086.7', start_position_on_the_genomic_accession=123246300, end_position_on_the_genomic_accession=123247561, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  102632837 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102632837, CurrentID=0, Status='live', Symbol='Rnf212b', Aliases='', description='ring finger protein 212B', other_designations='RING finger protein C14orf164 homolog', map_location='', chromosome='14', genomic_nucleotide_accession_version='NC_000080.6', start_position_on_the_genomic_accession=54783341, end_position_on_the_genomic_accession=54854110, orientation='plus', exon_count=18, OMIM='', no_hdr0=''),
  328258 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=328258, CurrentID=0, Status='live', Symbol='Slc25a48', Aliases='AU042651, E230025K15', description='solute carrier family 25, member 48', other_designations='putative mitochondrial carrier protein FLJ44862 homolog', map_location='13 B1', chromosome='13', genomic_nucleotide_accession_version='NC_000079.6', start_position_on_the_genomic_accession=56437963, end_position_on_the_genomic_accession=56472367, orientation='plus', exon_count=10, OMIM='', no_hdr0=''),
  109807 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=109807, CurrentID=0, Status='live', Symbol='H20', Aliases='H-20', description='histocompatibility 20', other_designations='', map_location='', chromosome='4', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  109808 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=109808, CurrentID=0, Status='live', Symbol='H21', Aliases='H-21', description='histocompatibility 21', other_designations='', map_location='', chromosome='4', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  102632885 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102632885, CurrentID=0, Status='live', Symbol='LOC102632885', Aliases='', description='atherin-like', other_designations='', map_location='', chromosome='8', genomic_nucleotide_accession_version='NC_000074.6', start_position_on_the_genomic_accession=18845063, end_position_on_the_genomic_accession=18848309, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  102632889 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102632889, CurrentID=0, Status='live', Symbol='Astx4c', Aliases='Gm14955, OTTMUSG00000018590', description='amplified spermatogenic transcripts X encoded 4C', other_designations='', map_location='X 49.81 cM', chromosome='X', genomic_nucleotide_accession_version='NC_000086.7', start_position_on_the_genomic_accession=125596506, end_position_on_the_genomic_accession=125608559, orientation='plus', exon_count=9, OMIM='', no_hdr0=''),
  102632901 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102632901, CurrentID=0, Status='live', Symbol='LOC102632901', Aliases='', description='uncharacterized LOC102632901', other_designations='', map_location='', chromosome='3', genomic_nucleotide_accession_version='NC_000069.6', start_position_on_the_genomic_accession=96456195, end_position_on_the_genomic_accession=96471234, orientation='plus', exon_count=6, OMIM='', no_hdr0=''),
  102632904 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102632904, CurrentID=0, Status='live', Symbol='Gm30858', Aliases='', description='predicted gene, 30858', other_designations='', map_location='Y', chromosome='Y', genomic_nucleotide_accession_version='NC_000087.7', start_position_on_the_genomic_accession=25376392, end_position_on_the_genomic_accession=25386365, orientation='plus', exon_count=5, OMIM='', no_hdr0=''),
  102632909 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102632909, CurrentID=0, Status='live', Symbol='Gm28843', Aliases='', description='predicted gene 28843', other_designations='', map_location='Y', chromosome='Y', genomic_nucleotide_accession_version='NC_000087.7', start_position_on_the_genomic_accession=70957961, end_position_on_the_genomic_accession=70984218, orientation='plus', exon_count=8, OMIM='', no_hdr0=''),
  634104 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=634104, CurrentID=0, Status='live', Symbol='Olfr287', Aliases='MOR286-1', description='olfactory receptor 287', other_designations='GA_x6K02T2NBG7-5548201-5549154|olfactory receptor MOR286-1', map_location='15 F1', chromosome='15', genomic_nucleotide_accession_version='NC_000081.6', start_position_on_the_genomic_accession=98204566, end_position_on_the_genomic_accession=98221056, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  240892 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=240892, CurrentID=0, Status='live', Symbol='Dusp27', Aliases='C130085G02Rik, Gm209', description='dual specificity phosphatase 27 (putative)', other_designations='', map_location='1 H2.3', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=166098148, end_position_on_the_genomic_accession=166127898, orientation='minus', exon_count=6, OMIM='', no_hdr0=''),
  109822 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=109822, CurrentID=0, Status='live', Symbol='Gig', Aliases='Rpo2-2', description='Gus intermingled gene', other_designations='', map_location='', chromosome='5', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  22441 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=22441, CurrentID=0, Status='live', Symbol='Xlr', Aliases='', description='X-linked lymphocyte-regulated', other_designations='X-linked gene family of B-cell surface antigens|X-linked lymphocyte-regulated complex', map_location='X A5', chromosome='X', genomic_nucleotide_accession_version='NC_000086.7', start_position_on_the_genomic_accession=53777118, end_position_on_the_genomic_accession=53797716, orientation='minus', exon_count=9, OMIM='', no_hdr0=''),
  102632968 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102632968, CurrentID=0, Status='live', Symbol='Gm30910', Aliases='', description='predicted gene, 30910', other_designations='', map_location='4', chromosome='4', genomic_nucleotide_accession_version='NC_000070.6', start_position_on_the_genomic_accession=146512849, end_position_on_the_genomic_accession=146721554, orientation='plus', exon_count=5, OMIM='', no_hdr0=''),
  102633001 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102633001, CurrentID=0, Status='live', Symbol='Gm30933', Aliases='', description='predicted gene, 30933', other_designations='', map_location='9', chromosome='9', genomic_nucleotide_accession_version='NC_000075.6', start_position_on_the_genomic_accession=30385943, end_position_on_the_genomic_accession=30427358, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  102633012 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102633012, CurrentID=0, Status='live', Symbol='Gm30942', Aliases='', description='predicted gene, 30942', other_designations='', map_location='11', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=23540666, end_position_on_the_genomic_accession=23542850, orientation='minus', exon_count=4, OMIM='', no_hdr0=''),
  102633023 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102633023, CurrentID=0, Status='live', Symbol='Gm21759', Aliases='', description='predicted gene, 21759', other_designations='', map_location='5', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=8176031, end_position_on_the_genomic_accession=8182090, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  102633032 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102633032, CurrentID=0, Status='live', Symbol='LOC102633032', Aliases='', description='uncharacterized LOC102633032', other_designations='', map_location='', chromosome='3', genomic_nucleotide_accession_version='NC_000069.6', start_position_on_the_genomic_accession=19623566, end_position_on_the_genomic_accession=19629477, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  109841 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=109841, CurrentID=0, Status='live', Symbol='Ly14', Aliases='Ly-14', description='lymphocyte antigen 14', other_designations='', map_location='', chromosome='7', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  240916 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=240916, CurrentID=0, Status='live', Symbol='Vsig8', Aliases='A030011M19, EG240916', description='V-set and immunoglobulin domain containing 8', other_designations='', map_location='1 H3', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=172555938, end_position_on_the_genomic_accession=172563717, orientation='plus', exon_count=10, OMIM='', no_hdr0=''),
  102633084 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102633084, CurrentID=0, Status='live', Symbol='Gm21902', Aliases='', description='predicted gene, 21902', other_designations='', map_location='Y', chromosome='Y', genomic_nucleotide_accession_version='NC_000087.7', start_position_on_the_genomic_accession=53191831, end_position_on_the_genomic_accession=53194312, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  240921 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=240921, CurrentID=0, Status='live', Symbol='Gm4955', Aliases='EG240921, Ifi206', description='predicted gene 4955', other_designations='', map_location='1 H3', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=173468413, end_position_on_the_genomic_accession=173486872, orientation='minus', exon_count=5, OMIM='', no_hdr0=''),
  102633131 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102633131, CurrentID=0, Status='live', Symbol='Gm31035', Aliases='', description='predicted gene, 31035', other_designations='', map_location='14', chromosome='14', genomic_nucleotide_accession_version='NC_000080.6', start_position_on_the_genomic_accession=7046923, end_position_on_the_genomic_accession=7205528, orientation='plus', exon_count=7, OMIM='', no_hdr0=''),
  102633156 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102633156, CurrentID=0, Status='live', Symbol='LOC102633156', Aliases='', description='zinc finger protein 14-like', other_designations='', map_location='', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=175306116, end_position_on_the_genomic_accession=175338330, orientation='minus', exon_count=7, OMIM='', no_hdr0=''),
  102633214 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102633214, CurrentID=0, Status='live', Symbol='Gm12925', Aliases='OTTMUSG00000009214', description='predicted gene 12925', other_designations='', map_location='4 57.42 cM', chromosome='4', genomic_nucleotide_accession_version='NC_000070.6', start_position_on_the_genomic_accession=123664557, end_position_on_the_genomic_accession=123679932, orientation='plus', exon_count=4, OMIM='', no_hdr0=''),
  102633225 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102633225, CurrentID=0, Status='live', Symbol='LOC102633225', Aliases='', description='disks large homolog 5-like', other_designations='', map_location='', chromosome='14', genomic_nucleotide_accession_version='NC_000080.6', start_position_on_the_genomic_accession=43229837, end_position_on_the_genomic_accession=43235375, orientation='minus', exon_count=5, OMIM='', no_hdr0=''),
  102633250 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102633250, CurrentID=0, Status='live', Symbol='Astx2', Aliases='Gm14952, OTTMUSG00000018584', description='amplified spermatogenic transcripts X encoded 2', other_designations='', map_location='X 49.81 cM', chromosome='X', genomic_nucleotide_accession_version='NC_000086.7', start_position_on_the_genomic_accession=123449002, end_position_on_the_genomic_accession=123461158, orientation='minus', exon_count=12, OMIM='', no_hdr0=''),
  102633253 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102633253, CurrentID=0, Status='live', Symbol='Gm21791', Aliases='', description='predicted gene, 21791', other_designations='', map_location='Y', chromosome='Y', genomic_nucleotide_accession_version='NC_000087.7', start_position_on_the_genomic_accession=25406464, end_position_on_the_genomic_accession=25408879, orientation='plus', exon_count=3, OMIM='', no_hdr0=''),
  102633269 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102633269, CurrentID=0, Status='live', Symbol='Gm10087', Aliases='ENSMUSG00000060777', description='predicted gene 10087', other_designations='', map_location='7 57.7 cM', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=110518597, end_position_on_the_genomic_accession=110527568, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  328329 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=328329, CurrentID=0, Status='live', Symbol='Mast4', Aliases='4930420O11Rik, AI642422, mKIAA0303', description='microtubule associated serine/threonine kinase family member 4', other_designations='mast4', map_location='13 D1', chromosome='13', genomic_nucleotide_accession_version='NC_000079.6', start_position_on_the_genomic_accession=102732488, end_position_on_the_genomic_accession=103335840, orientation='minus', exon_count=38, OMIM='', no_hdr0=''),
  102633301 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102633301, CurrentID=0, Status='live', Symbol='Gm31160', Aliases='', description='predicted gene, 31160', other_designations='', map_location='5', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=137166892, end_position_on_the_genomic_accession=137179164, orientation='minus', exon_count=12, OMIM='', no_hdr0=''),
  102633307 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102633307, CurrentID=0, Status='live', Symbol='Gm31166', Aliases='', description='predicted gene, 31166', other_designations='', map_location='19', chromosome='19', genomic_nucleotide_accession_version='NC_000085.6', start_position_on_the_genomic_accession=5510783, end_position_on_the_genomic_accession=5550374, orientation='plus', exon_count=4, OMIM='', no_hdr0=''),
  102633337 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102633337, CurrentID=0, Status='live', Symbol='Gm31186', Aliases='', description='predicted gene, 31186', other_designations='', map_location='Y', chromosome='Y', genomic_nucleotide_accession_version='NC_000087.7', start_position_on_the_genomic_accession=14801601, end_position_on_the_genomic_accession=14804036, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  102633345 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102633345, CurrentID=0, Status='live', Symbol='LOC102633345', Aliases='', description='uncharacterized LOC102633345', other_designations='', map_location='', chromosome='14', genomic_nucleotide_accession_version='NC_000080.6', start_position_on_the_genomic_accession=101727600, end_position_on_the_genomic_accession=101730158, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  102633346 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102633346, CurrentID=0, Status='live', Symbol='Gm31193', Aliases='', description='predicted gene, 31193', other_designations='', map_location='15', chromosome='15', genomic_nucleotide_accession_version='NC_000081.6', start_position_on_the_genomic_accession=8172551, end_position_on_the_genomic_accession=8173207, orientation='plus', exon_count=1, OMIM='', no_hdr0=''),
  102633361 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102633361, CurrentID=0, Status='live', Symbol='Gm31205', Aliases='', description='predicted gene, 31205', other_designations='', map_location='18', chromosome='18', genomic_nucleotide_accession_version='NC_000084.6', start_position_on_the_genomic_accession=40721525, end_position_on_the_genomic_accession=40778105, orientation='plus', exon_count=6, OMIM='', no_hdr0=''),
  102633363 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102633363, CurrentID=0, Status='live', Symbol='LOC102633363', Aliases='', description='zinc finger protein 14-like', other_designations='', map_location='', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=177735980, end_position_on_the_genomic_accession=177736997, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  102633377 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102633377, CurrentID=0, Status='live', Symbol='Gm21849', Aliases='', description='predicted gene, 21849', other_designations='', map_location='Y', chromosome='Y', genomic_nucleotide_accession_version='NC_000087.7', start_position_on_the_genomic_accession=51021061, end_position_on_the_genomic_accession=51023581, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  66203 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=66203, CurrentID=0, Status='live', Symbol='Lce1m', Aliases='1110059L13Rik, AI131654, Lce5a, Sprrl10', description='late cornified envelope 1M', other_designations='late cornified envelope 5A|small proline rich-like 10', map_location='3 F2', chromosome='3', genomic_nucleotide_accession_version='NC_000069.6', start_position_on_the_genomic_accession=93017807, end_position_on_the_genomic_accession=93019061, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  109897 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=109897, CurrentID=0, Status='live', Symbol='Cypr2', Aliases='', description='cytokine production 2', other_designations='', map_location='', chromosome='1', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  102633402 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102633402, CurrentID=0, Status='live', Symbol='Gm31236', Aliases='', description='predicted gene, 31236', other_designations='', map_location='10', chromosome='10', genomic_nucleotide_accession_version='NC_000076.6', start_position_on_the_genomic_accession=43477239, end_position_on_the_genomic_accession=43479470, orientation='minus', exon_count=4, OMIM='', no_hdr0=''),
  328353 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=328353, CurrentID=0, Status='live', Symbol='D030051J21Rik', Aliases='Gm742', description='RIKEN cDNA D030051J21 gene', other_designations='', map_location='14 A1', chromosome='14', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  102633416 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102633416, CurrentID=0, Status='live', Symbol='Gm31248', Aliases='', description='predicted gene, 31248', other_designations='', map_location='5', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=137178509, end_position_on_the_genomic_accession=137180497, orientation='minus', exon_count=1, OMIM='', no_hdr0=''),
  102633420 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102633420, CurrentID=0, Status='live', Symbol='Gm12223', Aliases='OTTMUSG00000005662', description='predicted gene 12223', other_designations='', map_location='11 32.13 cM', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=54131878, end_position_on_the_genomic_accession=54285277, orientation='plus', exon_count=20, OMIM='', no_hdr0=''),
  102633424 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102633424, CurrentID=0, Status='live', Symbol='Gm31255', Aliases='', description='predicted gene, 31255', other_designations='', map_location='5', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=104603949, end_position_on_the_genomic_accession=104642488, orientation='plus', exon_count=5, OMIM='', no_hdr0=''),
  100519 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=100519, CurrentID=0, Status='live', Symbol='AA516738', Aliases='', description='expressed sequence AA516738', other_designations='', map_location='', chromosome='5', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  102633451 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102633451, CurrentID=0, Status='live', Symbol='Gm29110', Aliases='', description='predicted gene 29110', other_designations='', map_location='Y', chromosome='Y', genomic_nucleotide_accession_version='NC_000087.7', start_position_on_the_genomic_accession=74470514, end_position_on_the_genomic_accession=74496943, orientation='plus', exon_count=10, OMIM='', no_hdr0=''),
  102633458 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102633458, CurrentID=0, Status='live', Symbol='Gm11100', Aliases='ENSMUSG00000079357', description='predicted gene 11100', other_designations='', map_location='14 7.08 cM', chromosome='14', genomic_nucleotide_accession_version='NC_000080.6', start_position_on_the_genomic_accession=13932894, end_position_on_the_genomic_accession=13949153, orientation='plus', exon_count=4, OMIM='', no_hdr0=''),
  328362 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=328362, CurrentID=0, Status='live', Symbol='Gm38408', Aliases='B930071L05', description='predicted gene, 38408', other_designations='uncharacterized protein B930071L05', map_location='14 A3', chromosome='14', genomic_nucleotide_accession_version='NC_000080.6', start_position_on_the_genomic_accession=25066904, end_position_on_the_genomic_accession=25080965, orientation='minus', exon_count=4, OMIM='', no_hdr0=''),
  102633470 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102633470, CurrentID=0, Status='live', Symbol='Gm31287', Aliases='', description='predicted gene, 31287', other_designations='', map_location='8', chromosome='8', genomic_nucleotide_accession_version='NC_000074.6', start_position_on_the_genomic_accession=19757175, end_position_on_the_genomic_accession=19761895, orientation='plus', exon_count=3, OMIM='', no_hdr0=''),
  328366 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=328366, CurrentID=0, Status='live', Symbol='C130057D09Rik', Aliases='', description='RIKEN cDNA C130057D09 gene', other_designations='', map_location='14 A3', chromosome='14', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  102633512 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102633512, CurrentID=0, Status='live', Symbol='Gm31322', Aliases='', description='predicted gene, 31322', other_designations='', map_location='16', chromosome='16', genomic_nucleotide_accession_version='NC_000082.6', start_position_on_the_genomic_accession=77589379, end_position_on_the_genomic_accession=77790662, orientation='plus', exon_count=22, OMIM='', no_hdr0=''),
  328370 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=328370, CurrentID=0, Status='live', Symbol='Rft1', Aliases='D930025H04', description='RFT1 homolog (S. cerevisiae)', other_designations='', map_location='14 B', chromosome='14', genomic_nucleotide_accession_version='NC_000080.6', start_position_on_the_genomic_accession=30654341, end_position_on_the_genomic_accession=30691317, orientation='plus', exon_count=13, OMIM='', no_hdr0=''),
  102633528 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102633528, CurrentID=0, Status='live', Symbol='Gm31335', Aliases='', description='predicted gene, 31335', other_designations='', map_location='Y', chromosome='Y', genomic_nucleotide_accession_version='NC_000087.7', start_position_on_the_genomic_accession=21769957, end_position_on_the_genomic_accession=21772258, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  102633531 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102633531, CurrentID=0, Status='live', Symbol='Gm28814', Aliases='', description='predicted gene 28814', other_designations='', map_location='Y', chromosome='Y', genomic_nucleotide_accession_version='NC_000087.7', start_position_on_the_genomic_accession=78902297, end_position_on_the_genomic_accession=78904894, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  328373 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=328373, CurrentID=0, Status='live', Symbol='A530028O18', Aliases='', description='uncharacterized protein A530028O18', other_designations='', map_location='14 A3', chromosome='14', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  102633570 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102633570, CurrentID=0, Status='live', Symbol='Gm21752', Aliases='', description='predicted gene, 21752', other_designations='', map_location='Y', chromosome='Y', genomic_nucleotide_accession_version='NC_000087.7', start_position_on_the_genomic_accession=87012753, end_position_on_the_genomic_accession=87015210, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  102633580 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102633580, CurrentID=0, Status='live', Symbol='Gm31371', Aliases='', description='predicted gene, 31371', other_designations='', map_location='8', chromosome='8', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  328381 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=328381, CurrentID=0, Status='live', Symbol='Sh2d4b', Aliases='A430109M18Rik, D030001E08', description='SH2 domain containing 4B', other_designations='', map_location='14 B', chromosome='14', genomic_nucleotide_accession_version='NC_000080.6', start_position_on_the_genomic_accession=40811521, end_position_on_the_genomic_accession=40902337, orientation='minus', exon_count=13, OMIM='', no_hdr0=''),
  102633642 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102633642, CurrentID=0, Status='live', Symbol='Gm28337', Aliases='', description='predicted gene 28337', other_designations='', map_location='Y', chromosome='Y', genomic_nucleotide_accession_version='NC_000087.7', start_position_on_the_genomic_accession=36413307, end_position_on_the_genomic_accession=36436819, orientation='minus', exon_count=9, OMIM='', no_hdr0=''),
  102633662 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102633662, CurrentID=0, Status='live', Symbol='Gm31433', Aliases='', description='predicted gene, 31433', other_designations='', map_location='9', chromosome='9', genomic_nucleotide_accession_version='NC_000075.6', start_position_on_the_genomic_accession=56543379, end_position_on_the_genomic_accession=56544198, orientation='plus', exon_count=1, OMIM='', no_hdr0=''),
  102633664 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102633664, CurrentID=0, Status='live', Symbol='Gm31435', Aliases='', description='predicted gene, 31435', other_designations='', map_location='17', chromosome='17', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  102633678 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102633678, CurrentID=0, Status='live', Symbol='Gm31444', Aliases='', description='predicted gene, 31444', other_designations='', map_location='X', chromosome='X', genomic_nucleotide_accession_version='NC_000086.7', start_position_on_the_genomic_accession=101699713, end_position_on_the_genomic_accession=101705665, orientation='plus', exon_count=4, OMIM='', no_hdr0=''),
  102633679 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102633679, CurrentID=0, Status='live', Symbol='Gm31445', Aliases='', description='predicted gene, 31445', other_designations='', map_location='7', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=61134552, end_position_on_the_genomic_accession=61290671, orientation='minus', exon_count=15, OMIM='', no_hdr0=''),
  102633696 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102633696, CurrentID=0, Status='live', Symbol='Gm17654', Aliases='', description='predicted gene, 17654', other_designations='', map_location='14 22.49 cM', chromosome='14', genomic_nucleotide_accession_version='NC_000080.6', start_position_on_the_genomic_accession=43575567, end_position_on_the_genomic_accession=43579149, orientation='minus', exon_count=4, OMIM='', no_hdr0=''),
  102633703 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102633703, CurrentID=0, Status='live', Symbol='Gm31464', Aliases='', description='predicted gene, 31464', other_designations='', map_location='8', chromosome='8', genomic_nucleotide_accession_version='NC_000074.6', start_position_on_the_genomic_accession=20083538, end_position_on_the_genomic_accession=20096472, orientation='plus', exon_count=5, OMIM='', no_hdr0=''),
  102633707 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102633707, CurrentID=0, Status='live', Symbol='Gm31467', Aliases='', description='predicted gene, 31467', other_designations='', map_location='1', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=193252381, end_position_on_the_genomic_accession=193281176, orientation='plus', exon_count=13, OMIM='', no_hdr0=''),
  102633718 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102633718, CurrentID=0, Status='live', Symbol='Gm31477', Aliases='', description='predicted gene, 31477', other_designations='', map_location='4', chromosome='4', genomic_nucleotide_accession_version='NC_000070.6', start_position_on_the_genomic_accession=153999363, end_position_on_the_genomic_accession=154002258, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  102633726 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102633726, CurrentID=0, Status='live', Symbol='Gm21906', Aliases='', description='predicted gene, 21906', other_designations='', map_location='Y', chromosome='Y', genomic_nucleotide_accession_version='NC_000087.7', start_position_on_the_genomic_accession=53485055, end_position_on_the_genomic_accession=53487830, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  102633740 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102633740, CurrentID=0, Status='live', Symbol='Gm31493', Aliases='', description='predicted gene, 31493', other_designations='', map_location='1', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=159976780, end_position_on_the_genomic_accession=160025763, orientation='minus', exon_count=9, OMIM='', no_hdr0=''),
  102633782 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102633782, CurrentID=0, Status='live', Symbol='Gm31526', Aliases='', description='predicted gene, 31526', other_designations='', map_location='5', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=104747044, end_position_on_the_genomic_accession=104751064, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  102633783 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102633783, CurrentID=0, Status='live', Symbol='LOC102633783', Aliases='', description='sp110 nuclear body protein-like', other_designations='', map_location='', chromosome='1', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  102633791 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102633791, CurrentID=0, Status='live', Symbol='Gm31532', Aliases='', description='predicted gene, 31532', other_designations='', map_location='17', chromosome='17', genomic_nucleotide_accession_version='NC_000083.6', start_position_on_the_genomic_accession=53688894, end_position_on_the_genomic_accession=53701224, orientation='plus', exon_count=4, OMIM='', no_hdr0=''),
  109963 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=109963, CurrentID=0, Status='live', Symbol='Fre2', Aliases='', description='Friend erythroleukemia 2', other_designations='', map_location='', chromosome='9', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  328417 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=328417, CurrentID=0, Status='live', Symbol='Parp4', Aliases='Adprtl1, C030027K23Rik, E230037B21Rik, Gm743, PARPL, PH5P, VAULT3, VPARP, p193', description='poly (ADP-ribose) polymerase family, member 4', other_designations='ADP-ribosyltransferase (NAD+; poly (ADP-ribose) polymerase)-like 1', map_location='14 C3', chromosome='14', genomic_nucleotide_accession_version='NC_000080.6', start_position_on_the_genomic_accession=56575619, end_position_on_the_genomic_accession=56659798, orientation='plus', exon_count=35, OMIM='', no_hdr0=''),
  102633827 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102633827, CurrentID=0, Status='live', Symbol='Gm31558', Aliases='', description='predicted gene, 31558', other_designations='', map_location='2', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=49246218, end_position_on_the_genomic_accession=49250045, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  102633837 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102633837, CurrentID=0, Status='live', Symbol='Gm31567', Aliases='', description='predicted gene, 31567', other_designations='', map_location='2', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=180116102, end_position_on_the_genomic_accession=180119687, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  66280 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=66280, CurrentID=0, Status='live', Symbol='1810028F09Rik', Aliases='', description='RIKEN cDNA 1810028F09 gene', other_designations='', map_location='14 C1', chromosome='14', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  102633842 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102633842, CurrentID=0, Status='live', Symbol='Gm31571', Aliases='', description='predicted gene, 31571', other_designations='', map_location='Y', chromosome='Y', genomic_nucleotide_accession_version='NC_000087.7', start_position_on_the_genomic_accession=22025179, end_position_on_the_genomic_accession=22051370, orientation='minus', exon_count=10, OMIM='', no_hdr0=''),
  102633843 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102633843, CurrentID=0, Status='live', Symbol='Gm31572', Aliases='', description='predicted gene, 31572', other_designations='', map_location='Y', chromosome='Y', genomic_nucleotide_accession_version='NC_000087.7', start_position_on_the_genomic_accession=25889482, end_position_on_the_genomic_accession=25899458, orientation='plus', exon_count=5, OMIM='', no_hdr0=''),
  266614 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=266614, CurrentID=0, Status='live', Symbol='Ly6g5b', Aliases='', description='lymphocyte antigen 6 complex, locus G5B', other_designations='Ly6g5b splicing isoform 611|Ly6g5b splicing isoform 707', map_location='17 B1', chromosome='17', genomic_nucleotide_accession_version='NC_000083.6', start_position_on_the_genomic_accession=35113944, end_position_on_the_genomic_accession=35115400, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  266620 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=266620, CurrentID=0, Status='live', Symbol='Defb36', Aliases='BD-36, Defb123, mBD-36', description='defensin beta 36', other_designations='defensin beta 123', map_location='2 H1', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=152604327, end_position_on_the_genomic_accession=152612729, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  100533 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=100533, CurrentID=0, Status='live', Symbol='AA536748', Aliases='', description='expressed sequence AA536748', other_designations='', map_location='', chromosome='5', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  266632 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=266632, CurrentID=0, Status='live', Symbol='Irak4', Aliases='8430405M07Rik, 9330209D03Rik, IRAK-4, NY-REN-64', description='interleukin-1 receptor-associated kinase 4', other_designations='', map_location='15 F1', chromosome='15', genomic_nucleotide_accession_version='NC_000081.6', start_position_on_the_genomic_accession=94543611, end_position_on_the_genomic_accession=94568317, orientation='plus', exon_count=13, OMIM='', no_hdr0=''),
  102633869 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102633869, CurrentID=0, Status='live', Symbol='LOC102633869', Aliases='', description='uncharacterized LOC102633869', other_designations='diacylglycerol kinase alpha', map_location='', chromosome='10', genomic_nucleotide_accession_version='NC_000076.6', start_position_on_the_genomic_accession=128737083, end_position_on_the_genomic_accession=128744930, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  266645 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=266645, CurrentID=0, Status='live', Symbol='Acmsd', Aliases='', description='amino carboxymuconate semialdehyde decarboxylase', other_designations='picolinate carboxylase', map_location='1 E3', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=127729413, end_position_on_the_genomic_accession=127767564, orientation='plus', exon_count=10, OMIM='', no_hdr0=''),
  102633888 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102633888, CurrentID=0, Status='live', Symbol='Gm31606', Aliases='', description='predicted gene, 31606', other_designations='', map_location='14', chromosome='14', genomic_nucleotide_accession_version='NC_000080.6', start_position_on_the_genomic_accession=39410074, end_position_on_the_genomic_accession=39411229, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  546886 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=546886, CurrentID=0, Status='live', Symbol='Cfap73', Aliases='Ccdc42b, Gm5988', description='cilia and flagella associated protein 73', other_designations='coiled-coil domain containing 42B', map_location='5', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=120628335, end_position_on_the_genomic_accession=120634235, orientation='minus', exon_count=7, OMIM='', no_hdr0=''),
  266690 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=266690, CurrentID=0, Status='live', Symbol='Cyb5r4', Aliases='2810034J18Rik, B5+B5R, C79736, Cb5cb5r, Ncb5or, b5/b5r, b5b5r', description='cytochrome b5 reductase 4', other_designations='N-terminal cytochrome b5 and cytochrome b5 oxidoreductase domain-containing protein|NADPH cytochrome B5 oxidoreductase|cb5/cb5R|cytochrome b-type NAD(P)H oxidoreductase|flavohemoprotein b5/b5R', map_location='9 E3.1', chromosome='9', genomic_nucleotide_accession_version='NC_000075.6', start_position_on_the_genomic_accession=87022008, end_position_on_the_genomic_accession=87077774, orientation='plus', exon_count=16, OMIM='', no_hdr0=''),
  266692 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=266692, CurrentID=0, Status='live', Symbol='Cpne1', Aliases='1810028N16Rik, mKIAA4108', description='copine I', other_designations='', map_location='2 H2', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=156071841, end_position_on_the_genomic_accession=156111965, orientation='minus', exon_count=17, OMIM='', no_hdr0=''),
  102633933 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102633933, CurrentID=0, Status='live', Symbol='Gm31635', Aliases='', description='predicted gene, 31635', other_designations='', map_location='8', chromosome='8', genomic_nucleotide_accession_version='NC_000074.6', start_position_on_the_genomic_accession=20512088, end_position_on_the_genomic_accession=20525738, orientation='plus', exon_count=5, OMIM='', no_hdr0=''),
  66296 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=66296, CurrentID=0, Status='live', Symbol='Haus2', Aliases='1700101G24Rik, 2410007P03Rik, AU020217, Cep27', description='HAUS augmin-like complex, subunit 2', other_designations='centrosomal protein 27|centrosomal protein of 27 kDa', map_location='2 F1', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=120609382, end_position_on_the_genomic_accession=120621560, orientation='plus', exon_count=7, OMIM='', no_hdr0=''),
  102633951 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102633951, CurrentID=0, Status='live', Symbol='Gm31649', Aliases='', description='predicted gene, 31649', other_designations='', map_location='7', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=13023708, end_position_on_the_genomic_accession=13024629, orientation='minus', exon_count=1, OMIM='', no_hdr0=''),
  22608 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=22608, CurrentID=0, Status='live', Symbol='Ybx1', Aliases='1700102N10Rik, C79409, EF1A, MSY1, Nsep1, YB-1, dbpB, mYB-1a', description='Y box protein 1', other_designations='CBF-A|CCAAT-binding transcription factor I subunit A|DNA binding protein B|DNA-binding protein B|EFI-A|Y-box binding protein 1|Y-box transcription factor|Y-box-binding protein 1|enhancer factor I subunit A|nuclease sensitive element binding protein 1', map_location='4 D1', chromosome='4', genomic_nucleotide_accession_version='NC_000070.6', start_position_on_the_genomic_accession=119277327, end_position_on_the_genomic_accession=119294659, orientation='minus', exon_count=8, OMIM='', no_hdr0=''),
  109990 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=109990, CurrentID=0, Status='live', Symbol='Saac', Aliases='', description='sialic acid O-acetylation', other_designations='', map_location='', chromosome='9', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  102633965 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102633965, CurrentID=0, Status='live', Symbol='Gm31662', Aliases='', description='predicted gene, 31662', other_designations='', map_location='15', chromosome='15', genomic_nucleotide_accession_version='NC_000081.6', start_position_on_the_genomic_accession=5866605, end_position_on_the_genomic_accession=5952363, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  266744 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=266744, CurrentID=0, Status='live', Symbol='Lgsn', Aliases='Gluld1, Lgs, lengsin', description='lengsin, lens protein with glutamine synthetase domain', other_designations='glutamate-ammonia ligase (glutamine synthase) domain containing 1|glutamate-ammonia ligase (glutamine synthetase) domain containing 1|glutamate-ammonia ligase domain-containing protein 1', map_location='1 B', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=31176435, end_position_on_the_genomic_accession=31204725, orientation='plus', exon_count=5, OMIM='', no_hdr0=''),
  102633986 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102633986, CurrentID=0, Status='live', Symbol='Gm31679', Aliases='', description='predicted gene, 31679', other_designations='', map_location='12', chromosome='12', genomic_nucleotide_accession_version='NC_000078.6', start_position_on_the_genomic_accession=69622309, end_position_on_the_genomic_accession=69625603, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  102633990 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102633990, CurrentID=0, Status='live', Symbol='Gm28907', Aliases='', description='predicted gene 28907', other_designations='', map_location='Y', chromosome='Y', genomic_nucleotide_accession_version='NC_000087.7', start_position_on_the_genomic_accession=53742140, end_position_on_the_genomic_accession=53747410, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  102633991 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102633991, CurrentID=0, Status='live', Symbol='Gm21918', Aliases='', description='predicted gene, 21918', other_designations='', map_location='Y', chromosome='Y', genomic_nucleotide_accession_version='NC_000087.7', start_position_on_the_genomic_accession=60681023, end_position_on_the_genomic_accession=60683427, orientation='plus', exon_count=3, OMIM='', no_hdr0=''),
  102634004 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102634004, CurrentID=0, Status='live', Symbol='Gm31694', Aliases='', description='predicted gene, 31694', other_designations='', map_location='16', chromosome='16', genomic_nucleotide_accession_version='NC_000082.6', start_position_on_the_genomic_accession=11675536, end_position_on_the_genomic_accession=11678670, orientation='plus', exon_count=3, OMIM='', no_hdr0=''),
  102634009 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102634009, CurrentID=0, Status='live', Symbol='Gm31699', Aliases='', description='predicted gene, 31699', other_designations='', map_location='2', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=30600986, end_position_on_the_genomic_accession=30615309, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  266781 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=266781, CurrentID=0, Status='live', Symbol='Snx17', Aliases='5830447M19Rik, AI790646, D5Ertd260e, b2b1625.1Clo, mKIAA0064', description='sorting nexin 17', other_designations='', map_location='5 B1', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=31193287, end_position_on_the_genomic_accession=31198900, orientation='plus', exon_count=16, OMIM='', no_hdr0=''),
  110001 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=110001, CurrentID=0, Status='live', Symbol='Dgsh', Aliases='', description='DiGeorge syndrome gene h', other_designations='', map_location='', chromosome='16', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  102634030 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102634030, CurrentID=0, Status='live', Symbol='Gm31714', Aliases='', description='predicted gene, 31714', other_designations='', map_location='13', chromosome='13', genomic_nucleotide_accession_version='NC_000079.6', start_position_on_the_genomic_accession=65397420, end_position_on_the_genomic_accession=65415122, orientation='minus', exon_count=4, OMIM='', no_hdr0=''),
  110003 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=110003, CurrentID=0, Status='live', Symbol='Pfn1-rs', Aliases='', description='prolifin 1, related sequence', other_designations='', map_location='', chromosome='15', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  266815 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=266815, CurrentID=0, Status='live', Symbol='Mill1', Aliases='5530400I18Rik', description='MHC I like leukocyte 1', other_designations='MHC I-like leukocyte 1', map_location='7 9.15 cM', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=18245232, end_position_on_the_genomic_accession=18266092, orientation='plus', exon_count=7, OMIM='', no_hdr0=''),
  22625 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=22625, CurrentID=0, Status='live', Symbol='Map3k19', Aliases='Ysk4', description='mitogen-activated protein kinase kinase kinase 19', other_designations='SPS1/STE20-related protein kinase YSK4|Yeast Sps1/Ste20-related kinase 4', map_location='1 E3', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=127814962, end_position_on_the_genomic_accession=127855613, orientation='minus', exon_count=14, OMIM='', no_hdr0=''),
  102634072 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102634072, CurrentID=0, Status='live', Symbol='Gm38457', Aliases='', description='predicted gene, 38457', other_designations='', map_location='5', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=64802302, end_position_on_the_genomic_accession=64804778, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  102634078 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102634078, CurrentID=0, Status='live', Symbol='LOC102634078', Aliases='', description='uncharacterized LOC102634078', other_designations='', map_location='', chromosome='15', genomic_nucleotide_accession_version='NC_000081.6', start_position_on_the_genomic_accession=8435112, end_position_on_the_genomic_accession=8445863, orientation='plus', exon_count=3, OMIM='', no_hdr0=''),
  667929 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=667929, CurrentID=0, Status='live', Symbol='Gm8882', Aliases='EG667929', description='predicted gene 8882', other_designations='', map_location='6 G1', chromosome='6', genomic_nucleotide_accession_version='NC_000072.6', start_position_on_the_genomic_accession=132361105, end_position_on_the_genomic_accession=132364134, orientation='minus', exon_count=4, OMIM='', no_hdr0=''),
  102634119 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102634119, CurrentID=0, Status='live', Symbol='Gm31780', Aliases='', description='predicted gene, 31780', other_designations='', map_location='1', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=16591021, end_position_on_the_genomic_accession=16596309, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  102634132 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102634132, CurrentID=0, Status='live', Symbol='LOC102634132', Aliases='', description='uncharacterized LOC102634132', other_designations='', map_location='', chromosome='4', genomic_nucleotide_accession_version='NC_000070.6', start_position_on_the_genomic_accession=78210727, end_position_on_the_genomic_accession=78220294, orientation='plus', exon_count=3, OMIM='', no_hdr0=''),
  110021 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=110021, CurrentID=0, Status='live', Symbol='Dvb11-2', Aliases='', description='V11<+> T cell deletion 2', other_designations='V11<+> T-cell deletion 2', map_location='', chromosome='12', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  632883 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=632883, CurrentID=0, Status='live', Symbol='Gm14989', Aliases='ENSMUSG00000072068, OTTMUSG00000018677', description='predicted gene 14989', other_designations='protein transport protein Sec61 subunit gamma-like', map_location='X', chromosome='X', genomic_nucleotide_accession_version='NC_000086.7', start_position_on_the_genomic_accession=138085607, end_position_on_the_genomic_accession=138085813, orientation='minus', exon_count=1, OMIM='', no_hdr0=''),
  102634165 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102634165, CurrentID=0, Status='live', Symbol='Gm31816', Aliases='', description='predicted gene, 31816', other_designations='', map_location='9', chromosome='9', genomic_nucleotide_accession_version='NC_000075.6', start_position_on_the_genomic_accession=47260688, end_position_on_the_genomic_accession=47371501, orientation='minus', exon_count=6, OMIM='', no_hdr0=''),
  102634181 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102634181, CurrentID=0, Status='live', Symbol='Gm21890', Aliases='', description='predicted gene, 21890', other_designations='', map_location='Y', chromosome='Y', genomic_nucleotide_accession_version='NC_000087.7', start_position_on_the_genomic_accession=25919546, end_position_on_the_genomic_accession=25921960, orientation='plus', exon_count=3, OMIM='', no_hdr0=''),
  102634182 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102634182, CurrentID=0, Status='live', Symbol='Gm31827', Aliases='', description='predicted gene, 31827', other_designations='', map_location='12', chromosome='12', genomic_nucleotide_accession_version='NC_000078.6', start_position_on_the_genomic_accession=69955546, end_position_on_the_genomic_accession=69956944, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  102634188 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102634188, CurrentID=0, Status='live', Symbol='Gm29639', Aliases='', description='predicted gene 29639', other_designations='', map_location='Y', chromosome='Y', genomic_nucleotide_accession_version='NC_000087.7', start_position_on_the_genomic_accession=67818582, end_position_on_the_genomic_accession=67829485, orientation='minus', exon_count=5, OMIM='', no_hdr0=''),
  102634203 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102634203, CurrentID=0, Status='live', Symbol='Gm31844', Aliases='', description='predicted gene, 31844', other_designations='', map_location='5', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=92074726, end_position_on_the_genomic_accession=92084165, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  791260 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=791260, CurrentID=0, Status='live', Symbol='Tomt', Aliases='Comt2, F930017I19Rik', description='transmembrane O-methyltransferase', other_designations='catechol O-methyltransferase 2|catechol-O-methyltransferase 2', map_location='7', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=101899803, end_position_on_the_genomic_accession=101906359, orientation='minus', exon_count=5, OMIM='', no_hdr0=''),
  791262 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=791262, CurrentID=0, Status='live', Symbol='Gm9912', Aliases='ENSMUSG00000053583', description='predicted gene 9912', other_designations='', map_location='', chromosome='3', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  102634208 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102634208, CurrentID=0, Status='live', Symbol='Gm31848', Aliases='', description='predicted gene, 31848', other_designations='', map_location='10', chromosome='10', genomic_nucleotide_accession_version='NC_000076.6', start_position_on_the_genomic_accession=39935551, end_position_on_the_genomic_accession=39943017, orientation='plus', exon_count=5, OMIM='', no_hdr0=''),
  102634222 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102634222, CurrentID=0, Status='live', Symbol='Gm17467', Aliases='', description='predicted gene, 17467', other_designations='', map_location='X 49.81 cM', chromosome='X', genomic_nucleotide_accession_version='NC_000086.7', start_position_on_the_genomic_accession=123677994, end_position_on_the_genomic_accession=123705445, orientation='minus', exon_count=4, OMIM='', no_hdr0=''),
  791286 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=791286, CurrentID=0, Status='live', Symbol='Gm9886', Aliases='ENSMUSG00000052663', description='predicted gene 9886', other_designations='', map_location='', chromosome='19', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  102634234 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102634234, CurrentID=0, Status='live', Symbol='Gm31866', Aliases='', description='predicted gene, 31866', other_designations='', map_location='8', chromosome='8', genomic_nucleotide_accession_version='NC_000074.6', start_position_on_the_genomic_accession=9687486, end_position_on_the_genomic_accession=9693849, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  791292 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=791292, CurrentID=0, Status='live', Symbol='Gm9936', Aliases='ENSMUSG00000054123', description='predicted gene 9936', other_designations='', map_location='', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=114855031, end_position_on_the_genomic_accession=114859377, orientation='minus', exon_count=1, OMIM='', no_hdr0=''),
  791301 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=791301, CurrentID=0, Status='live', Symbol='Gm10265', Aliases='ENSMUSG00000069334', description='predicted gene 10265', other_designations='', map_location='', chromosome='18', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  791305 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=791305, CurrentID=0, Status='live', Symbol='B430202K04Rik', Aliases='ENSMUSG00000052860', description='RIKEN cDNA B430202K04 gene', other_designations='', map_location='', chromosome='11', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  267019 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=267019, CurrentID=0, Status='live', Symbol='Rps15a', Aliases='A630031B11Rik', description='ribosomal protein S15A', other_designations='', map_location='7 F2', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=118104374, end_position_on_the_genomic_accession=118116147, orientation='minus', exon_count=5, OMIM='', no_hdr0=''),
  791312 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=791312, CurrentID=0, Status='live', Symbol='Gm9997', Aliases='ENSMUSG00000056391', description='predicted gene 9997', other_designations='', map_location='12', chromosome='12', genomic_nucleotide_accession_version='NC_000078.6', start_position_on_the_genomic_accession=70107218, end_position_on_the_genomic_accession=70113240, orientation='plus', exon_count=4, OMIM='', no_hdr0=''),
  110040 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=110040, CurrentID=0, Status='live', Symbol='Mis2', Aliases='', description='Mo-MuLV integration site 2', other_designations='', map_location='', chromosome='10', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  102634260 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102634260, CurrentID=0, Status='live', Symbol='Gm28423', Aliases='', description='predicted gene 28423', other_designations='', map_location='Y', chromosome='Y', genomic_nucleotide_accession_version='NC_000087.7', start_position_on_the_genomic_accession=79215340, end_position_on_the_genomic_accession=79216038, orientation='minus', exon_count=1, OMIM='', no_hdr0=''),
  791317 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=791317, CurrentID=0, Status='live', Symbol='Gm9921', Aliases='ENSMUSG00000053810', description='predicted gene 9921', other_designations='', map_location='', chromosome='12', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  110041 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=110041, CurrentID=0, Status='live', Symbol='Mse1', Aliases='Mse-1', description='esterase modifying locus 1', other_designations='', map_location='', chromosome='12', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  791323 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=791323, CurrentID=0, Status='live', Symbol='Gm9954', Aliases='ENSMUSG00000054714', description='predicted gene 9954', other_designations='', map_location='', chromosome='5', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  791326 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=791326, CurrentID=0, Status='live', Symbol='Gm9922', Aliases='ENSMUSG00000053821', description='predicted gene 9922', other_designations='', map_location='', chromosome='14', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  791330 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=791330, CurrentID=0, Status='live', Symbol='A230060F14Rik', Aliases='ENSMUSG00000055288', description='RIKEN cDNA A230060F14 gene', other_designations='', map_location='', chromosome='10', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  791332 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=791332, CurrentID=0, Status='live', Symbol='B930095I24Rik', Aliases='ENSMUSG00000030810', description='RIKEN cDNA B930095I24Rik gene', other_designations='', map_location='', chromosome='14', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  791333 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=791333, CurrentID=0, Status='live', Symbol='Gm10050', Aliases='ENSMUSG00000058898', description='predicted gene 10050', other_designations='', map_location='', chromosome='15', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  791335 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=791335, CurrentID=0, Status='live', Symbol='Gm9914', Aliases='ENSMUSG00000053632', description='predicted gene 9914', other_designations='', map_location='', chromosome='14', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  102634280 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102634280, CurrentID=0, Status='live', Symbol='Gm13486', Aliases='OTTMUSG00000012386', description='predicted gene 13486', other_designations='', map_location='2 28.96 cM', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=50401770, end_position_on_the_genomic_accession=50412930, orientation='plus', exon_count=5, OMIM='', no_hdr0=''),
  102634284 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102634284, CurrentID=0, Status='live', Symbol='Gm38462', Aliases='', description='predicted gene, 38462', other_designations='', map_location='2', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=74702998, end_position_on_the_genomic_accession=74712058, orientation='minus', exon_count=4, OMIM='', no_hdr0=''),
  791342 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=791342, CurrentID=0, Status='live', Symbol='Gm10097', Aliases='ENSMUSG00000061261', description='predicted gene 10097', other_designations='', map_location='', chromosome='10', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  110046 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=110046, CurrentID=0, Status='live', Symbol='Kifc4a', Aliases='', description='kinesin family member C4A', other_designations='', map_location='', chromosome='13', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  102634296 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102634296, CurrentID=0, Status='live', Symbol='LOC102634296', Aliases='', description='uncharacterized protein CXorf49 homolog', other_designations='', map_location='', chromosome='X', genomic_nucleotide_accession_version='NC_000086.7', start_position_on_the_genomic_accession=101790332, end_position_on_the_genomic_accession=101794455, orientation='minus', exon_count=6, OMIM='', no_hdr0=''),
  791354 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=791354, CurrentID=0, Status='live', Symbol='Gm9873', Aliases='ENSMUSG00000052368', description='predicted gene 9873', other_designations='', map_location='', chromosome='2', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  791355 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=791355, CurrentID=0, Status='live', Symbol='Arf4os', Aliases='4930570N19Rik, ENSMUSG00000053165', description='ADP-ribosylation factor 4, opposite strand', other_designations='', map_location='', chromosome='14', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  546954 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=546954, CurrentID=0, Status='live', Symbol='Gm6003', Aliases='EG546954', description='predicted gene 6003', other_designations='', map_location='7 B1', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=33165208, end_position_on_the_genomic_accession=33165675, orientation='plus', exon_count=1, OMIM='', no_hdr0=''),
  791358 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=791358, CurrentID=0, Status='live', Symbol='Gm10065', Aliases='ENSMUSG00000059459', description='predicted gene 10065', other_designations='', map_location='', chromosome='13', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  102634304 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102634304, CurrentID=0, Status='live', Symbol='LOC102634304', Aliases='', description='disks large homolog 5', other_designations='', map_location='', chromosome='14', genomic_nucleotide_accession_version='NC_000080.6', start_position_on_the_genomic_accession=43725102, end_position_on_the_genomic_accession=43727355, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  791362 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=791362, CurrentID=0, Status='live', Symbol='C130032M10Rik', Aliases='ENSMUSG00000052207', description='RIKEN cDNA C130032M10 gene', other_designations='', map_location='', chromosome='9', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  791363 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=791363, CurrentID=0, Status='live', Symbol='A730071L15Rik', Aliases='ENSMUSG00000053792', description='RIKEN cDNA A730071L15Rik gene', other_designations='', map_location='', chromosome='11', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  102634311 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102634311, CurrentID=0, Status='live', Symbol='Gm31924', Aliases='', description='predicted gene, 31924', other_designations='', map_location='11', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=115374052, end_position_on_the_genomic_accession=115376290, orientation='plus', exon_count=4, OMIM='', no_hdr0=''),
  102634314 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102634314, CurrentID=0, Status='live', Symbol='LOC102634314', Aliases='', description='PRAME family member 8-like', other_designations='', map_location='', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=93371946, end_position_on_the_genomic_accession=93375801, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  791371 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=791371, CurrentID=0, Status='live', Symbol='Gm9910', Aliases='ENSMUSG00000053568', description='predicted gene 9910', other_designations='', map_location='', chromosome='11', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  791373 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=791373, CurrentID=0, Status='live', Symbol='B930078G14Rik', Aliases='ENSMUSG00000053412', description='RIKEN cDNA B930078G14 gene', other_designations='', map_location='', chromosome='8', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  328505 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=328505, CurrentID=0, Status='live', Symbol='Skint7', Aliases='C130057D23Rik', description='selection and upkeep of intraepithelial T cells 7', other_designations='novel immunoglobulin V-set and CD80-like C2-set immunoglobulin domain containing protein|skint 7|skint-7', map_location='4 D1', chromosome='4', genomic_nucleotide_accession_version='NC_000070.6', start_position_on_the_genomic_accession=111972924, end_position_on_the_genomic_accession=111988260, orientation='plus', exon_count=9, OMIM='', no_hdr0=''),
  791386 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=791386, CurrentID=0, Status='live', Symbol='Gm10113', Aliases='ENSMUSG00000062282', description='predicted gene 10113', other_designations='', map_location='13', chromosome='13', genomic_nucleotide_accession_version='NC_000079.6', start_position_on_the_genomic_accession=46175428, end_position_on_the_genomic_accession=46191046, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  102634333 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102634333, CurrentID=0, Status='live', Symbol='LOC102634333', Aliases='', description='uncharacterized LOC102634333', other_designations='', map_location='', chromosome='3', genomic_nucleotide_accession_version='NC_000069.6', start_position_on_the_genomic_accession=138062242, end_position_on_the_genomic_accession=138081501, orientation='plus', exon_count=4, OMIM='', no_hdr0=''),
  791395 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=791395, CurrentID=0, Status='live', Symbol='D330020A13Rik', Aliases='ENSMUSG00000053059', description='RIKEN cDNA D330020A13 gene', other_designations='', map_location='', chromosome='6', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  791399 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=791399, CurrentID=0, Status='live', Symbol='Gm9884', Aliases='ENSMUSG00000052558', description='predicted gene 9884', other_designations='', map_location='', chromosome='1', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  791400 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=791400, CurrentID=0, Status='live', Symbol='B430203G13Rik', Aliases='ENSMUSG00000066577', description='RIKEN cDNA B430203G13 gene', other_designations='', map_location='', chromosome='12', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  791402 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=791402, CurrentID=0, Status='live', Symbol='9230104M06Rik', Aliases='ENSMUSG00000051997', description='RIKEN cDNA 9230104M06 gene', other_designations='', map_location='', chromosome='12', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  791404 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=791404, CurrentID=0, Status='live', Symbol='6530402D11Rik', Aliases='ENSMUSG00000055423', description='RIKEN cDNA 6530402D11 gene', other_designations='', map_location='', chromosome='16', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  791406 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=791406, CurrentID=0, Status='live', Symbol='Gm9979', Aliases='ENSMUSG00000055732', description='predicted gene 9979', other_designations='', map_location='13', chromosome='13', genomic_nucleotide_accession_version='NC_000079.6', start_position_on_the_genomic_accession=40704005, end_position_on_the_genomic_accession=40707949, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  634346 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=634346, CurrentID=0, Status='live', Symbol='Gm7135', Aliases='EG634346', description='predicted gene 7135', other_designations='', map_location='1 D', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=97346182, end_position_on_the_genomic_accession=97479091, orientation='plus', exon_count=14, OMIM='', no_hdr0=''),
  102634371 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102634371, CurrentID=0, Status='live', Symbol='Gm21749', Aliases='', description='predicted gene, 21749', other_designations='', map_location='Y', chromosome='Y', genomic_nucleotide_accession_version='NC_000087.7', start_position_on_the_genomic_accession=53781507, end_position_on_the_genomic_accession=53782205, orientation='minus', exon_count=1, OMIM='', no_hdr0=''),
  77869 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=77869, CurrentID=0, Status='live', Symbol='E130112B07Rik', Aliases='', description='RIKEN cDNA E130112B07 gene', other_designations='', map_location='13', chromosome='13', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  22687 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=22687, CurrentID=0, Status='live', Symbol='Zpr1', Aliases='AI303781, Zfp259, Znf259', description='ZPR1 zinc finger', other_designations='zinc finger protein 259', map_location='9 A5.2', chromosome='9', genomic_nucleotide_accession_version='NC_000075.6', start_position_on_the_genomic_accession=46273064, end_position_on_the_genomic_accession=46282643, orientation='plus', exon_count=14, OMIM='', no_hdr0=''),
  102634429 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102634429, CurrentID=0, Status='live', Symbol='LOC102634429', Aliases='', description='uncharacterized LOC102634429', other_designations='', map_location='', chromosome='15', genomic_nucleotide_accession_version='NC_000081.6', start_position_on_the_genomic_accession=73830051, end_position_on_the_genomic_accession=73839908, orientation='plus', exon_count=7, OMIM='', no_hdr0=''),
  102634430 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102634430, CurrentID=0, Status='live', Symbol='LOC102634430', Aliases='', description='PRAME family member 8-like', other_designations='', map_location='', chromosome='5', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  22693 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=22693, CurrentID=0, Status='live', Symbol='Zfp30', Aliases='2610306P15Rik, Zfp-30', description='zinc finger protein 30', other_designations='', map_location='7 17.26 cM', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=29784790, end_position_on_the_genomic_accession=29794540, orientation='plus', exon_count=5, OMIM='', no_hdr0=''),
  102634473 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102634473, CurrentID=0, Status='live', Symbol='Gm29669', Aliases='', description='predicted gene 29669', other_designations='', map_location='1', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=31117532, end_position_on_the_genomic_accession=31135201, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  22695 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=22695, CurrentID=0, Status='live', Symbol='Zfp36', Aliases='Gos24, Nup475, TIS11D, TISII, Tis11, Ttp, Zfp-36', description='zinc finger protein 36', other_designations='TPA-induced sequence 11|growth factor-inducible nuclear protein NUP475|tristetraproline', map_location='7 16.72 cM', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=28376784, end_position_on_the_genomic_accession=28379228, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  102634482 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102634482, CurrentID=0, Status='live', Symbol='Gm32056', Aliases='', description='predicted gene, 32056', other_designations='', map_location='10', chromosome='10', genomic_nucleotide_accession_version='NC_000076.6', start_position_on_the_genomic_accession=40239794, end_position_on_the_genomic_accession=40242282, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  328531 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=328531, CurrentID=0, Status='live', Symbol='9330182O14Rik', Aliases='', description='RIKEN cDNA 9330182O14 gene', other_designations='', map_location='15 B3.1', chromosome='15', genomic_nucleotide_accession_version='NC_000081.6', start_position_on_the_genomic_accession=40134365, end_position_on_the_genomic_accession=40150010, orientation='plus', exon_count=5, OMIM='', no_hdr0=''),
  102634487 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102634487, CurrentID=0, Status='live', Symbol='Gm32059', Aliases='', description='predicted gene, 32059', other_designations='', map_location='7', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=16041984, end_position_on_the_genomic_accession=16047666, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  102634493 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102634493, CurrentID=0, Status='live', Symbol='Gm28827', Aliases='', description='predicted gene 28827', other_designations='', map_location='Y', chromosome='Y', genomic_nucleotide_accession_version='NC_000087.7', start_position_on_the_genomic_accession=83030930, end_position_on_the_genomic_accession=83057283, orientation='plus', exon_count=11, OMIM='', no_hdr0=''),
  102634499 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102634499, CurrentID=0, Status='live', Symbol='LOC102634499', Aliases='', description='zinc finger protein 120-like', other_designations='', map_location='', chromosome='13', genomic_nucleotide_accession_version='NC_000079.6', start_position_on_the_genomic_accession=65510416, end_position_on_the_genomic_accession=65512944, orientation='plus', exon_count=3, OMIM='', no_hdr0=''),
  22701 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=22701, CurrentID=0, Status='live', Symbol='Zfp41', Aliases='CTfin92, Zfp-41', description='zinc finger protein 41', other_designations='', map_location='15 D3', chromosome='15', genomic_nucleotide_accession_version='NC_000081.6', start_position_on_the_genomic_accession=75616142, end_position_on_the_genomic_accession=75627446, orientation='plus', exon_count=5, OMIM='', no_hdr0=''),
  102634532 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102634532, CurrentID=0, Status='live', Symbol='Gm3642', Aliases='100042054', description='predicted gene 3642', other_designations='', map_location='14 4.07 cM', chromosome='14', genomic_nucleotide_accession_version='NC_000080.6', start_position_on_the_genomic_accession=6834594, end_position_on_the_genomic_accession=6840373, orientation='minus', exon_count=5, OMIM='', no_hdr0=''),
  110086 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=110086, CurrentID=0, Status='live', Symbol='Tcpm1', Aliases='Tpm1', description='T cell phenotype modifier 1', other_designations='T-cell phenotype modifier 1', map_location='', chromosome='11', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  102634559 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102634559, CurrentID=0, Status='live', Symbol='Gm29443', Aliases='', description='predicted gene 29443', other_designations='', map_location='7', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=16607501, end_position_on_the_genomic_accession=16633992, orientation='plus', exon_count=5, OMIM='', no_hdr0=''),
  328545 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=328545, CurrentID=0, Status='live', Symbol='B830032F12', Aliases='', description='uncharacterized protein B830032F12', other_designations='', map_location='15 D1', chromosome='15', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  102634570 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102634570, CurrentID=0, Status='live', Symbol='Gm28790', Aliases='', description='predicted gene 28790', other_designations='', map_location='Y', chromosome='Y', genomic_nucleotide_accession_version='NC_000087.7', start_position_on_the_genomic_accession=75055020, end_position_on_the_genomic_accession=75057537, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  102634579 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102634579, CurrentID=0, Status='live', Symbol='Gm32125', Aliases='', description='predicted gene, 32125', other_designations='', map_location='11', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=57832226, end_position_on_the_genomic_accession=57838969, orientation='minus', exon_count=4, OMIM='', no_hdr0=''),
  102634581 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102634581, CurrentID=0, Status='live', Symbol='LOC102634581', Aliases='', description='nuclear body protein SP140-like protein', other_designations='', map_location='', chromosome='1', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  102634596 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102634596, CurrentID=0, Status='live', Symbol='Gm32137', Aliases='', description='predicted gene, 32137', other_designations='', map_location='2', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=117423878, end_position_on_the_genomic_accession=117450490, orientation='plus', exon_count=3, OMIM='', no_hdr0=''),
  102634611 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102634611, CurrentID=0, Status='live', Symbol='Gm32151', Aliases='', description='predicted gene, 32151', other_designations='', map_location='12', chromosome='12', genomic_nucleotide_accession_version='NC_000078.6', start_position_on_the_genomic_accession=70347479, end_position_on_the_genomic_accession=70377269, orientation='plus', exon_count=4, OMIM='', no_hdr0=''),
  102634630 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102634630, CurrentID=0, Status='live', Symbol='Gm32168', Aliases='', description='predicted gene, 32168', other_designations='', map_location='15', chromosome='15', genomic_nucleotide_accession_version='NC_000081.6', start_position_on_the_genomic_accession=74411114, end_position_on_the_genomic_accession=74481140, orientation='minus', exon_count=6, OMIM='', no_hdr0=''),
  102634640 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102634640, CurrentID=0, Status='live', Symbol='Gm28806', Aliases='', description='predicted gene 28806', other_designations='', map_location='12', chromosome='12', genomic_nucleotide_accession_version='NC_000078.6', start_position_on_the_genomic_accession=30479212, end_position_on_the_genomic_accession=30553033, orientation='minus', exon_count=5, OMIM='', no_hdr0=''),
  102634647 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102634647, CurrentID=0, Status='live', Symbol='Gm29370', Aliases='', description='predicted gene 29370', other_designations='', map_location='Y', chromosome='Y', genomic_nucleotide_accession_version='NC_000087.7', start_position_on_the_genomic_accession=47854645, end_position_on_the_genomic_accession=47858352, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  102634672 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102634672, CurrentID=0, Status='live', Symbol='Gm32204', Aliases='', description='predicted gene, 32204', other_designations='', map_location='2', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=11925843, end_position_on_the_genomic_accession=11927868, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  328563 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=328563, CurrentID=0, Status='live', Symbol='Apol11b', Aliases='A330102K04Rik', description='apolipoprotein L 11b', other_designations='', map_location='15 E1', chromosome='15', genomic_nucleotide_accession_version='NC_000081.6', start_position_on_the_genomic_accession=77633951, end_position_on_the_genomic_accession=77643286, orientation='minus', exon_count=4, OMIM='', no_hdr0=''),
  102634681 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102634681, CurrentID=0, Status='live', Symbol='Gm32211', Aliases='', description='predicted gene, 32211', other_designations='', map_location='2', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=152802436, end_position_on_the_genomic_accession=152803840, orientation='plus', exon_count=1, OMIM='', no_hdr0=''),
  102634690 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102634690, CurrentID=0, Status='live', Symbol='Gm28098', Aliases='', description='predicted gene 28098', other_designations='', map_location='Y', chromosome='Y', genomic_nucleotide_accession_version='NC_000087.7', start_position_on_the_genomic_accession=8635543, end_position_on_the_genomic_accession=8637994, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  102634694 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102634694, CurrentID=0, Status='live', Symbol='Gm21868', Aliases='', description='predicted gene, 21868', other_designations='', map_location='Y', chromosome='Y', genomic_nucleotide_accession_version='NC_000087.7', start_position_on_the_genomic_accession=57457286, end_position_on_the_genomic_accession=57459535, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  102634696 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102634696, CurrentID=0, Status='live', Symbol='Gm28302', Aliases='', description='predicted gene 28302', other_designations='', map_location='Y', chromosome='Y', genomic_nucleotide_accession_version='NC_000087.7', start_position_on_the_genomic_accession=70049466, end_position_on_the_genomic_accession=70049972, orientation='minus', exon_count=1, OMIM='', no_hdr0=''),
  102634709 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102634709, CurrentID=0, Status='live', Symbol='LOC102634709', Aliases='', description='40S ribosomal protein S14', other_designations='', map_location='', chromosome='15', genomic_nucleotide_accession_version='NC_000081.6', start_position_on_the_genomic_accession=81972346, end_position_on_the_genomic_accession=81972897, orientation='plus', exon_count=1, OMIM='', no_hdr0=''),
  102634710 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102634710, CurrentID=0, Status='live', Symbol='Gm32229', Aliases='', description='predicted gene, 32229', other_designations='', map_location='1', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=33714183, end_position_on_the_genomic_accession=33721589, orientation='minus', exon_count=4, OMIM='', no_hdr0=''),
  102634715 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102634715, CurrentID=0, Status='live', Symbol='Gm32234', Aliases='', description='predicted gene, 32234', other_designations='', map_location='10', chromosome='10', genomic_nucleotide_accession_version='NC_000076.6', start_position_on_the_genomic_accession=40464674, end_position_on_the_genomic_accession=40466627, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  102634727 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102634727, CurrentID=0, Status='live', Symbol='Gm29485', Aliases='', description='predicted gene 29485', other_designations='', map_location='1', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=136522648, end_position_on_the_genomic_accession=136524805, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  102634746 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102634746, CurrentID=0, Status='live', Symbol='Gm13201', Aliases='OTTMUSG00000010938', description='predicted gene 13201', other_designations='', map_location='4 78.67 cM', chromosome='4', genomic_nucleotide_accession_version='NC_000070.6', start_position_on_the_genomic_accession=148056687, end_position_on_the_genomic_accession=148075450, orientation='minus', exon_count=12, OMIM='', no_hdr0=''),
  328577 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=328577, CurrentID=0, Status='live', Symbol='7530416G11Rik', Aliases='', description='RIKEN cDNA 7530416G11 gene', other_designations='', map_location='15 E2', chromosome='15', genomic_nucleotide_accession_version='NC_000081.6', start_position_on_the_genomic_accession=85472646, end_position_on_the_genomic_accession=85503227, orientation='minus', exon_count=6, OMIM='', no_hdr0=''),
  102634760 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102634760, CurrentID=0, Status='live', Symbol='Gm21751', Aliases='', description='predicted gene, 21751', other_designations='', map_location='Y', chromosome='Y', genomic_nucleotide_accession_version='NC_000087.7', start_position_on_the_genomic_accession=47890643, end_position_on_the_genomic_accession=47893047, orientation='plus', exon_count=3, OMIM='', no_hdr0=''),
  241196 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=241196, CurrentID=0, Status='live', Symbol='Serpinb13', Aliases='5430417G24, HUR7, HURPIN, PI13, headpin', description='serine (or cysteine) peptidase inhibitor, clade B (ovalbumin), member 13', other_designations='serine (or cysteine) proteinase inhibitor, clade B (ovalbumin), member 13', map_location='1 E2.1', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=106980984, end_position_on_the_genomic_accession=107001195, orientation='plus', exon_count=8, OMIM='', no_hdr0=''),
  110125 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=110125, CurrentID=0, Status='live', Symbol='Ifi15', Aliases='', description='interferon activated gene 15', other_designations='', map_location='', chromosome='17', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  102634768 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102634768, CurrentID=0, Status='live', Symbol='Gm32272', Aliases='', description='predicted gene, 32272', other_designations='', map_location='7', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=92147264, end_position_on_the_genomic_accession=92149476, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  102634788 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102634788, CurrentID=0, Status='live', Symbol='Gm32289', Aliases='', description='predicted gene, 32289', other_designations='', map_location='2', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=84714509, end_position_on_the_genomic_accession=84717758, orientation='plus', exon_count=3, OMIM='', no_hdr0=''),
  241201 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=241201, CurrentID=0, Status='live', Symbol='Cdh7', Aliases='9330156F07Rik, CDH7L1', description='cadherin 7, type 2', other_designations='', map_location='1 E2.1', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=109982327, end_position_on_the_genomic_accession=110141917, orientation='plus', exon_count=17, OMIM='', no_hdr0=''),
  102634810 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102634810, CurrentID=0, Status='live', Symbol='Gm32308', Aliases='', description='predicted gene, 32308', other_designations='', map_location='6', chromosome='6', genomic_nucleotide_accession_version='NC_000072.6', start_position_on_the_genomic_accession=98755324, end_position_on_the_genomic_accession=98758033, orientation='plus', exon_count=3, OMIM='', no_hdr0=''),
  102634829 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102634829, CurrentID=0, Status='live', Symbol='Gm28780', Aliases='', description='predicted gene 28780', other_designations='', map_location='Y', chromosome='Y', genomic_nucleotide_accession_version='NC_000087.7', start_position_on_the_genomic_accession=26402588, end_position_on_the_genomic_accession=26412565, orientation='plus', exon_count=5, OMIM='', no_hdr0=''),
  102634841 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102634841, CurrentID=0, Status='live', Symbol='Gm38469', Aliases='', description='predicted gene, 38469', other_designations='spidroin-2', map_location='15', chromosome='15', genomic_nucleotide_accession_version='NC_000081.6', start_position_on_the_genomic_accession=96134823, end_position_on_the_genomic_accession=96287487, orientation='minus', exon_count=4, OMIM='', no_hdr0=''),
  102634852 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102634852, CurrentID=0, Status='live', Symbol='LOC102634852', Aliases='', description='uncharacterized LOC102634852', other_designations='', map_location='', chromosome='4', genomic_nucleotide_accession_version='NC_000070.6', start_position_on_the_genomic_accession=71755746, end_position_on_the_genomic_accession=71757960, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  102634864 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102634864, CurrentID=0, Status='live', Symbol='Gm32347', Aliases='', description='predicted gene, 32347', other_designations='', map_location='Y', chromosome='Y', genomic_nucleotide_accession_version='NC_000087.7', start_position_on_the_genomic_accession=21426544, end_position_on_the_genomic_accession=21427119, orientation='plus', exon_count=1, OMIM='', no_hdr0=''),
  547049 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=547049, CurrentID=0, Status='live', Symbol='Iqcf2', Aliases='EG547049', description='IQ motif containing F2', other_designations='', map_location='9 F1', chromosome='9', genomic_nucleotide_accession_version='NC_000075.4', start_position_on_the_genomic_accession=106383067, end_position_on_the_genomic_accession=106383812, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  102634895 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102634895, CurrentID=0, Status='live', Symbol='Gm32370', Aliases='', description='predicted gene, 32370', other_designations='', map_location='12', chromosome='12', genomic_nucleotide_accession_version='NC_000078.6', start_position_on_the_genomic_accession=105901423, end_position_on_the_genomic_accession=105906788, orientation='minus', exon_count=6, OMIM='', no_hdr0=''),
  328606 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=328606, CurrentID=0, Status='live', Symbol='4731420N21', Aliases='', description='uncharacterized protein 4731420N21', other_designations='', map_location='15 F1', chromosome='15', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  102634936 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102634936, CurrentID=0, Status='live', Symbol='Gm21810', Aliases='', description='predicted gene, 21810', other_designations='', map_location='Y', chromosome='Y', genomic_nucleotide_accession_version='NC_000087.7', start_position_on_the_genomic_accession=33105081, end_position_on_the_genomic_accession=33107493, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  102634938 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102634938, CurrentID=0, Status='live', Symbol='Gm28350', Aliases='', description='predicted gene 28350', other_designations='', map_location='Y', chromosome='Y', genomic_nucleotide_accession_version='NC_000087.7', start_position_on_the_genomic_accession=57083473, end_position_on_the_genomic_accession=57085802, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  110154 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=110154, CurrentID=0, Status='live', Symbol='Ifi201', Aliases='', description='interferon activated gene 201', other_designations='', map_location='', chromosome='1', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  102634959 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102634959, CurrentID=0, Status='live', Symbol='Gm15926', Aliases='OTTMUSG00000027895', description='predicted gene 15926', other_designations='', map_location='7 2.43 cM', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=4208447, end_position_on_the_genomic_accession=4208647, orientation='plus', exon_count=1, OMIM='', no_hdr0=''),
  102634963 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102634963, CurrentID=0, Status='live', Symbol='Gm32419', Aliases='', description='predicted gene, 32419', other_designations='', map_location='Y', chromosome='Y', genomic_nucleotide_accession_version='NC_000087.7', start_position_on_the_genomic_accession=21490438, end_position_on_the_genomic_accession=21499361, orientation='minus', exon_count=4, OMIM='', no_hdr0=''),
  110158 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=110158, CurrentID=0, Status='live', Symbol='Si-r', Aliases='Suc-1', description='sucrase isomaltase, regulatory', other_designations='', map_location='', chromosome='3', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  231506 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=231506, CurrentID=0, Status='live', Symbol='Lin54', Aliases='4832414L08, AI461788, mKIAA2037', description='lin-54 homolog (C. elegans)', other_designations='', map_location='5 E4', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=100442033, end_position_on_the_genomic_accession=100500649, orientation='minus', exon_count=17, OMIM='', no_hdr0=''),
  102634981 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102634981, CurrentID=0, Status='live', Symbol='Gm32430', Aliases='', description='predicted gene, 32430', other_designations='', map_location='5', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=101763075, end_position_on_the_genomic_accession=101765374, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  102634987 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102634987, CurrentID=0, Status='live', Symbol='Gm32436', Aliases='', description='predicted gene, 32436', other_designations='', map_location='18', chromosome='18', genomic_nucleotide_accession_version='NC_000084.6', start_position_on_the_genomic_accession=24465939, end_position_on_the_genomic_accession=24467764, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  102635000 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102635000, CurrentID=0, Status='live', Symbol='Gm28194', Aliases='', description='predicted gene 28194', other_designations='', map_location='Y', chromosome='Y', genomic_nucleotide_accession_version='NC_000087.7', start_position_on_the_genomic_accession=48219003, end_position_on_the_genomic_accession=48234581, orientation='plus', exon_count=4, OMIM='', no_hdr0=''),
  102635033 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102635033, CurrentID=0, Status='live', Symbol='Gm32472', Aliases='', description='predicted gene, 32472', other_designations='', map_location='X', chromosome='X', genomic_nucleotide_accession_version='NC_000086.7', start_position_on_the_genomic_accession=74476168, end_position_on_the_genomic_accession=74477316, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  102635035 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102635035, CurrentID=0, Status='live', Symbol='Gm21805', Aliases='', description='predicted gene, 21805', other_designations='', map_location='Y', chromosome='Y', genomic_nucleotide_accession_version='NC_000087.7', start_position_on_the_genomic_accession=42735229, end_position_on_the_genomic_accession=42737632, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  102635053 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102635053, CurrentID=0, Status='live', Symbol='Gm16276', Aliases='OTTMUSG00000033046', description='predicted gene 16276', other_designations='', map_location='17 29.11 cM', chromosome='17', genomic_nucleotide_accession_version='NC_000083.6', start_position_on_the_genomic_accession=56014135, end_position_on_the_genomic_accession=56014664, orientation='minus', exon_count=1, OMIM='', no_hdr0=''),
  102635091 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102635091, CurrentID=0, Status='live', Symbol='Gm32514', Aliases='', description='predicted gene, 32514', other_designations='', map_location='2', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=90891602, end_position_on_the_genomic_accession=90893572, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  102635093 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102635093, CurrentID=0, Status='live', Symbol='Gm32516', Aliases='', description='predicted gene, 32516', other_designations='', map_location='10', chromosome='10', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  328633 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=328633, CurrentID=0, Status='live', Symbol='4930515I15', Aliases='', description='uncharacterized protein 4930515I15', other_designations='', map_location='16 A1', chromosome='16', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  102635098 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102635098, CurrentID=0, Status='live', Symbol='Gm29317', Aliases='', description='predicted gene 29317', other_designations='', map_location='Y', chromosome='Y', genomic_nucleotide_accession_version='NC_000087.7', start_position_on_the_genomic_accession=30097077, end_position_on_the_genomic_accession=30099479, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  102635099 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102635099, CurrentID=0, Status='live', Symbol='Gm21916', Aliases='', description='predicted gene, 21916', other_designations='', map_location='Y', chromosome='Y', genomic_nucleotide_accession_version='NC_000087.7', start_position_on_the_genomic_accession=33139685, end_position_on_the_genomic_accession=33155256, orientation='plus', exon_count=4, OMIM='', no_hdr0=''),
  102635106 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102635106, CurrentID=0, Status='live', Symbol='Gm29109', Aliases='', description='predicted gene 29109', other_designations='', map_location='Y', chromosome='Y', genomic_nucleotide_accession_version='NC_000087.7', start_position_on_the_genomic_accession=74366784, end_position_on_the_genomic_accession=74369279, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  102635107 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102635107, CurrentID=0, Status='live', Symbol='Gm32527', Aliases='', description='predicted gene, 32527', other_designations='', map_location='Y', chromosome='Y', genomic_nucleotide_accession_version='NC_000087.7', start_position_on_the_genomic_accession=90826402, end_position_on_the_genomic_accession=90830216, orientation='plus', exon_count=3, OMIM='', no_hdr0=''),
  102635127 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102635127, CurrentID=0, Status='live', Symbol='LOC102635127', Aliases='', description='myb-related transcription factor, partner of profilin-like', other_designations='', map_location='', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=92986211, end_position_on_the_genomic_accession=92989969, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  102635139 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102635139, CurrentID=0, Status='live', Symbol='Gm21755', Aliases='', description='predicted gene, 21755', other_designations='', map_location='Y', chromosome='Y', genomic_nucleotide_accession_version='NC_000087.7', start_position_on_the_genomic_accession=26432623, end_position_on_the_genomic_accession=26435036, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  102635181 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102635181, CurrentID=0, Status='live', Symbol='Gm32584', Aliases='', description='predicted gene, 32584', other_designations='', map_location='5', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=36630164, end_position_on_the_genomic_accession=36661659, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  102635218 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102635218, CurrentID=0, Status='live', Symbol='Gm21869', Aliases='', description='predicted gene, 21869', other_designations='', map_location='Y', chromosome='Y', genomic_nucleotide_accession_version='NC_000087.7', start_position_on_the_genomic_accession=74950655, end_position_on_the_genomic_accession=75027702, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  110202 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=110202, CurrentID=0, Status='live', Symbol='Aecp', Aliases='Acp', description='vitamin A enhanced cleft palate', other_designations='', map_location='', chromosome='17', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  102635246 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102635246, CurrentID=0, Status='live', Symbol='Gm29330', Aliases='', description='predicted gene 29330', other_designations='', map_location='Y', chromosome='Y', genomic_nucleotide_accession_version='NC_000087.7', start_position_on_the_genomic_accession=9267574, end_position_on_the_genomic_accession=9270026, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  102635250 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102635250, CurrentID=0, Status='live', Symbol='Gm21864', Aliases='', description='predicted gene, 21864', other_designations='', map_location='Y', chromosome='Y', genomic_nucleotide_accession_version='NC_000087.7', start_position_on_the_genomic_accession=83287762, end_position_on_the_genomic_accession=83290136, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  102635275 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102635275, CurrentID=0, Status='live', Symbol='Bach2it1', Aliases='Gm11932, OTTMUSG00000004929', description='BTB and CNC homology 2, intronic transcript 1', other_designations='', map_location='4 14.02 cM', chromosome='4', genomic_nucleotide_accession_version='NC_000070.6', start_position_on_the_genomic_accession=32237181, end_position_on_the_genomic_accession=32265835, orientation='plus', exon_count=3, OMIM='', no_hdr0=''),
  634504 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=634504, CurrentID=0, Status='live', Symbol='Gm7137', Aliases='', description='predicted gene 7137', other_designations='', map_location='10', chromosome='10', genomic_nucleotide_accession_version='NC_000076.6', start_position_on_the_genomic_accession=77787422, end_position_on_the_genomic_accession=77788200, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  102635315 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102635315, CurrentID=0, Status='live', Symbol='Gm32687', Aliases='', description='predicted gene, 32687', other_designations='', map_location='10', chromosome='10', genomic_nucleotide_accession_version='NC_000076.6', start_position_on_the_genomic_accession=81863437, end_position_on_the_genomic_accession=81881083, orientation='plus', exon_count=6, OMIM='', no_hdr0=''),
  110217 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=110217, CurrentID=0, Status='live', Symbol='Tsil', Aliases='', description='thymus specific insertion locus', other_designations='', map_location='', chromosome='17', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  102635325 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102635325, CurrentID=0, Status='live', Symbol='Gm21774', Aliases='', description='predicted gene, 21774', other_designations='', map_location='Y', chromosome='Y', genomic_nucleotide_accession_version='NC_000087.7', start_position_on_the_genomic_accession=42079608, end_position_on_the_genomic_accession=42082009, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  102635329 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102635329, CurrentID=0, Status='live', Symbol='Gm28533', Aliases='', description='predicted gene 28533', other_designations='', map_location='Y', chromosome='Y', genomic_nucleotide_accession_version='NC_000087.7', start_position_on_the_genomic_accession=57598164, end_position_on_the_genomic_accession=57600656, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  102635331 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102635331, CurrentID=0, Status='live', Symbol='Gm32699', Aliases='', description='predicted gene, 32699', other_designations='', map_location='13', chromosome='13', genomic_nucleotide_accession_version='NC_000079.6', start_position_on_the_genomic_accession=17941433, end_position_on_the_genomic_accession=17946648, orientation='plus', exon_count=4, OMIM='', no_hdr0=''),
  102635347 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102635347, CurrentID=0, Status='live', Symbol='Gm32710', Aliases='', description='predicted gene, 32710', other_designations='', map_location='9', chromosome='9', genomic_nucleotide_accession_version='NC_000075.6', start_position_on_the_genomic_accession=10904345, end_position_on_the_genomic_accession=10908409, orientation='plus', exon_count=3, OMIM='', no_hdr0=''),
  102635356 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102635356, CurrentID=0, Status='live', Symbol='Gm14197', Aliases='OTTMUSG00000015916', description='predicted gene 14197', other_designations='', map_location='2 76.38 cM', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=154284096, end_position_on_the_genomic_accession=154285279, orientation='minus', exon_count=1, OMIM='', no_hdr0=''),
  102635367 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102635367, CurrentID=0, Status='live', Symbol='Gm21802', Aliases='', description='predicted gene, 21802', other_designations='', map_location='Y', chromosome='Y', genomic_nucleotide_accession_version='NC_000087.7', start_position_on_the_genomic_accession=83361653, end_position_on_the_genomic_accession=83363993, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  102635377 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102635377, CurrentID=0, Status='live', Symbol='Gm32734', Aliases='', description='predicted gene, 32734', other_designations='', map_location='15', chromosome='15', genomic_nucleotide_accession_version='NC_000081.6', start_position_on_the_genomic_accession=77001074, end_position_on_the_genomic_accession=77002985, orientation='minus', exon_count=4, OMIM='', no_hdr0=''),
  102635385 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102635385, CurrentID=0, Status='live', Symbol='Gm32742', Aliases='', description='predicted gene, 32742', other_designations='', map_location='9', chromosome='9', genomic_nucleotide_accession_version='NC_000075.6', start_position_on_the_genomic_accession=51129755, end_position_on_the_genomic_accession=51168824, orientation='minus', exon_count=32, OMIM='', no_hdr0=''),
  102635420 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102635420, CurrentID=0, Status='live', Symbol='Gm32766', Aliases='', description='predicted gene, 32766', other_designations='', map_location='7', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=118358170, end_position_on_the_genomic_accession=118370075, orientation='minus', exon_count=5, OMIM='', no_hdr0=''),
  110236 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=110236, CurrentID=0, Status='live', Symbol='Igh-Sa3', Aliases='', description='immunoglobulin heavy chain Sa3', other_designations='', map_location='', chromosome='12', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  102635440 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102635440, CurrentID=0, Status='live', Symbol='Gm21922', Aliases='', description='predicted gene, 21922', other_designations='', map_location='Y', chromosome='Y', genomic_nucleotide_accession_version='NC_000087.7', start_position_on_the_genomic_accession=75465689, end_position_on_the_genomic_accession=75467940, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  102635442 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102635442, CurrentID=0, Status='live', Symbol='LOC102635442', Aliases='', description='uncharacterized LOC102635442', other_designations='', map_location='', chromosome='5', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  102635480 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102635480, CurrentID=0, Status='live', Symbol='Gm21894', Aliases='', description='predicted gene, 21894', other_designations='', map_location='Y', chromosome='Y', genomic_nucleotide_accession_version='NC_000087.7', start_position_on_the_genomic_accession=54655445, end_position_on_the_genomic_accession=54681463, orientation='plus', exon_count=10, OMIM='', no_hdr0=''),
  102635490 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102635490, CurrentID=0, Status='live', Symbol='Gm26660', Aliases='', description='predicted gene, 26660', other_designations='', map_location='14', chromosome='14', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  102635496 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102635496, CurrentID=0, Status='live', Symbol='Malrd1', Aliases='', description='MAM and LDL receptor class A domain containing 1', other_designations='', map_location='', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=15526479, end_position_on_the_genomic_accession=16255557, orientation='plus', exon_count=39, OMIM='', no_hdr0=''),
  268281 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=268281, CurrentID=0, Status='live', Symbol='Shprh', Aliases='2610103K11Rik, AA450458, AU024614, BC006883, D230017O13Rik, E130018M05', description='SNF2 histone linker PHD RING helicase', other_designations='SNF2, histone-linker, PHD and RING finger domain-containing helicase', map_location='10 A1', chromosome='10', genomic_nucleotide_accession_version='NC_000076.6', start_position_on_the_genomic_accession=11149321, end_position_on_the_genomic_accession=11217595, orientation='plus', exon_count=31, OMIM='', no_hdr0=''),
  102635515 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102635515, CurrentID=0, Status='live', Symbol='Gm29142', Aliases='', description='predicted gene 29142', other_designations='', map_location='Y', chromosome='Y', genomic_nucleotide_accession_version='NC_000087.7', start_position_on_the_genomic_accession=10085024, end_position_on_the_genomic_accession=10085614, orientation='minus', exon_count=1, OMIM='', no_hdr0=''),
  110250 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=110250, CurrentID=0, Status='live', Symbol='Hvmt1', Aliases='', description='heavy metal tolerance protein 1', other_designations='', map_location='', chromosome='1', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  268288 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=268288, CurrentID=0, Status='live', Symbol='Samd3', Aliases='Gm623', description='sterile alpha motif domain containing 3', other_designations='SAM domain-containing protein 3', map_location='10 A4', chromosome='10', genomic_nucleotide_accession_version='NC_000076.6', start_position_on_the_genomic_accession=26229618, end_position_on_the_genomic_accession=26272916, orientation='plus', exon_count=14, OMIM='', no_hdr0=''),
  102635521 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102635521, CurrentID=0, Status='live', Symbol='LOC102635521', Aliases='', description='uncharacterized LOC102635521', other_designations='', map_location='', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=66126441, end_position_on_the_genomic_accession=66189555, orientation='plus', exon_count=7, OMIM='', no_hdr0=''),
  268291 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=268291, CurrentID=0, Status='live', Symbol='Rnf217', Aliases='AU016819, Ibrdc1', description='ring finger protein 217', other_designations='IBR domain containing 1|IBR domain-containing protein 1', map_location='10 A4', chromosome='10', genomic_nucleotide_accession_version='NC_000076.6', start_position_on_the_genomic_accession=31501887, end_position_on_the_genomic_accession=31609725, orientation='minus', exon_count=6, OMIM='', no_hdr0=''),
  268294 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=268294, CurrentID=0, Status='live', Symbol='Zbtb24', Aliases='BC055367, Bif1, Bsg1, ZNF450', description='zinc finger and BTB domain containing 24', other_designations='BMP-induced factor 1|bone morphogenetic protein-induced factor 1|brain specific protein 1|zinc finger protein 450', map_location='10 B1', chromosome='10', genomic_nucleotide_accession_version='NC_000076.6', start_position_on_the_genomic_accession=41450356, end_position_on_the_genomic_accession=41465582, orientation='plus', exon_count=8, OMIM='', no_hdr0=''),
  268297 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=268297, CurrentID=0, Status='live', Symbol='Scml4', Aliases='9330161D17, mFLJ00197', description='sex comb on midleg-like 4 (Drosophila)', other_designations='', map_location='10 B2', chromosome='10', genomic_nucleotide_accession_version='NC_000076.6', start_position_on_the_genomic_accession=42860317, end_position_on_the_genomic_accession=42960782, orientation='plus', exon_count=11, OMIM='', no_hdr0=''),
  268301 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=268301, CurrentID=0, Status='live', Symbol='Sowahc', Aliases='4921515A04Rik, 9430099J10Rik, Ankrd57, C820004L04Rik', description='sosondowah ankyrin repeat domain family member C', other_designations='ankyrin repeat domain 57|ankyrin repeat domain-containing protein 57|protein sosondowah homolog C', map_location='10 B4', chromosome='10', genomic_nucleotide_accession_version='NC_000076.6', start_position_on_the_genomic_accession=59221922, end_position_on_the_genomic_accession=59226434, orientation='plus', exon_count=1, OMIM='', no_hdr0=''),
  102635547 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102635547, CurrentID=0, Status='live', Symbol='Gm28658', Aliases='', description='predicted gene 28658', other_designations='', map_location='Y', chromosome='Y', genomic_nucleotide_accession_version='NC_000087.7', start_position_on_the_genomic_accession=83388323, end_position_on_the_genomic_accession=83393102, orientation='minus', exon_count=6, OMIM='', no_hdr0=''),
  102635554 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102635554, CurrentID=0, Status='live', Symbol='LOC102635554', Aliases='', description='disks large homolog 5-like', other_designations='', map_location='', chromosome='14', genomic_nucleotide_accession_version='NC_000080.6', start_position_on_the_genomic_accession=41403027, end_position_on_the_genomic_accession=41408271, orientation='minus', exon_count=5, OMIM='', no_hdr0=''),
  102635563 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102635563, CurrentID=0, Status='live', Symbol='Gm11433', Aliases='OTTMUSG00000000984', description='predicted gene 11433', other_designations='', map_location='11 51.14 cM', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=83677518, end_position_on_the_genomic_accession=83680184, orientation='plus', exon_count=3, OMIM='', no_hdr0=''),
  102635564 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102635564, CurrentID=0, Status='live', Symbol='Gm32863', Aliases='', description='predicted gene, 32863', other_designations='', map_location='1', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=30948970, end_position_on_the_genomic_accession=30951023, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  102635566 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102635566, CurrentID=0, Status='live', Symbol='LOC102635566', Aliases='', description='uncharacterized protein C2orf16-like', other_designations='', map_location='', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=23330658, end_position_on_the_genomic_accession=23339650, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  268345 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=268345, CurrentID=0, Status='live', Symbol='Kcnc2', Aliases='AW047325, B230117I07, KShIIIA, Kv3.2', description='potassium voltage gated channel, Shaw-related subfamily, member 2', other_designations='shaw-like potassium channel|voltage-gated potassium channel Kv3.2', map_location='10 60.3 cM', chromosome='10', genomic_nucleotide_accession_version='NC_000076.6', start_position_on_the_genomic_accession=112270459, end_position_on_the_genomic_accession=112466304, orientation='plus', exon_count=12, OMIM='', no_hdr0=''),
  268354 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=268354, CurrentID=0, Status='live', Symbol='Fam19a2', Aliases='6330575M02, FAM19A2 TAFA-2, TAFA2, Tafa-2', description='family with sequence similarity 19, member A2', other_designations='chemokine-like protein TAFA-2', map_location='10 D2', chromosome='10', genomic_nucleotide_accession_version='NC_000076.6', start_position_on_the_genomic_accession=123264076, end_position_on_the_genomic_accession=123741204, orientation='plus', exon_count=8, OMIM='', no_hdr0=''),
  102635595 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102635595, CurrentID=0, Status='live', Symbol='Gm32886', Aliases='', description='predicted gene, 32886', other_designations='', map_location='15', chromosome='15', genomic_nucleotide_accession_version='NC_000081.6', start_position_on_the_genomic_accession=83257817, end_position_on_the_genomic_accession=83258319, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  102635601 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102635601, CurrentID=0, Status='live', Symbol='Gm32892', Aliases='', description='predicted gene, 32892', other_designations='', map_location='17', chromosome='17', genomic_nucleotide_accession_version='NC_000083.6', start_position_on_the_genomic_accession=22866892, end_position_on_the_genomic_accession=22873932, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  268373 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=268373, CurrentID=0, Status='live', Symbol='Ppia', Aliases='2700098C05, Cphn, CyP-18, CypA', description='peptidylprolyl isomerase A', other_designations='PPIase A|SP18|cyclophilin A|cyclosporin A-binding protein|rotamase A', map_location='11 3.97 cM', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=6415870, end_position_on_the_genomic_accession=6419810, orientation='plus', exon_count=5, OMIM='', no_hdr0=''),
  268379 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=268379, CurrentID=0, Status='live', Symbol='Abca13', Aliases='9830132L24, A930002G16Rik, AI956815', description='ATP-binding cassette, sub-family A (ABC1), member 13', other_designations='ATP-binding cassette transporter', map_location='11 A2', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=9191354, end_position_on_the_genomic_accession=9684871, orientation='plus', exon_count=63, OMIM='', no_hdr0=''),
  268390 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=268390, CurrentID=0, Status='live', Symbol='Ahsa2', Aliases='', description='AHA1, activator of heat shock protein ATPase 2', other_designations='', map_location='11 A3.2', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=23487882, end_position_on_the_genomic_accession=23498039, orientation='minus', exon_count=10, OMIM='', no_hdr0=''),
  268395 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=268395, CurrentID=0, Status='live', Symbol='Mpg', Aliases='9830006D05, AI326268, APNG, Aag, Mid1', description='N-methylpurine-DNA glycosylase', other_designations='3-alkyladenine DNA glycosylase|3-methyladenine DNA glycosidase|3-methyladenine DNA glycosylase|ADPG|alkylpurine-DNA-N-glycosylase', map_location='11 18.83 cM', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=32226425, end_position_on_the_genomic_accession=32232702, orientation='plus', exon_count=5, OMIM='', no_hdr0=''),
  268396 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=268396, CurrentID=0, Status='live', Symbol='Sh3pxd2b', Aliases='G431001E03Rik, TSK4, fad49', description='SH3 and PX domains 2B', other_designations='factor for adipocyte differentiation 49|tyrosine kinase substrate with four SH3 domains', map_location='11 A4', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=32347773, end_position_on_the_genomic_accession=32428183, orientation='plus', exon_count=14, OMIM='', no_hdr0=''),
  102635642 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102635642, CurrentID=0, Status='live', Symbol='Gm32929', Aliases='', description='predicted gene, 32929', other_designations='', map_location='2', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=117865629, end_position_on_the_genomic_accession=117867222, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  268417 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=268417, CurrentID=0, Status='live', Symbol='Zkscan17', Aliases='Nizp1, Zfp496, Znf496', description='zinc finger with KRAB and SCAN domains 17', other_designations='NSD1-interacting zinc finger protein 1|zinc finger protein with KRAB and SCAN domains 17', map_location='11 B1.3', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=59485520, end_position_on_the_genomic_accession=59506640, orientation='minus', exon_count=11, OMIM='', no_hdr0=''),
  102635650 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102635650, CurrentID=0, Status='live', Symbol='Gm32936', Aliases='', description='predicted gene, 32936', other_designations='', map_location='12', chromosome='12', genomic_nucleotide_accession_version='NC_000078.6', start_position_on_the_genomic_accession=60317888, end_position_on_the_genomic_accession=60318067, orientation='plus', exon_count=1, OMIM='', no_hdr0=''),
  268420 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=268420, CurrentID=0, Status='live', Symbol='Alkbh5', Aliases='AW050020, AW215868, Abh5, E130207K11, Ofoxd', description='alkB homolog 5, RNA demethylase', other_designations='alkB, alkylation repair homolog 5|alkylated DNA repair protein alkB homolog 5|alpha-ketoglutarate-dependent dioxygenase alkB homolog 5|oxoglutarate and iron-dependent oxygenase domain containing|probable alpha-ketoglutarate-dependent dioxygenase ABH5', map_location='11 B2', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=60537683, end_position_on_the_genomic_accession=60558512, orientation='plus', exon_count=4, OMIM='', no_hdr0=''),
  102635653 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102635653, CurrentID=0, Status='live', Symbol='Gm29573', Aliases='', description='predicted gene 29573', other_designations='', map_location='Y', chromosome='Y', genomic_nucleotide_accession_version='NC_000087.7', start_position_on_the_genomic_accession=76233640, end_position_on_the_genomic_accession=76255259, orientation='plus', exon_count=6, OMIM='', no_hdr0=''),
  102635661 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102635661, CurrentID=0, Status='live', Symbol='LOC102635661', Aliases='', description='myosin light polypeptide 6-like', other_designations='', map_location='', chromosome='8', genomic_nucleotide_accession_version='NC_000074.6', start_position_on_the_genomic_accession=105660167, end_position_on_the_genomic_accession=105660876, orientation='minus', exon_count=1, OMIM='', no_hdr0=''),
  110275 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=110275, CurrentID=0, Status='live', Symbol='Lvis4', Aliases='', description='lymphoid viral insertion site 4', other_designations='', map_location='', chromosome='12', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  399510 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=399510, CurrentID=0, Status='live', Symbol='Map4k5', Aliases='4432415E19Rik, GCKR, KHS, MAPKKKK5', description='mitogen-activated protein kinase kinase kinase kinase 5', other_designations='MAPK/ERK kinase kinase kinase 5|MEK kinase kinase 5|MEKKK 5|map4k5', map_location='12 C3', chromosome='12', genomic_nucleotide_accession_version='NC_000078.6', start_position_on_the_genomic_accession=69803757, end_position_on_the_genomic_accession=69893163, orientation='minus', exon_count=32, OMIM='', no_hdr0=''),
  268445 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=268445, CurrentID=0, Status='live', Symbol='Ankrd13b', Aliases='AW124583, B930093C12Rik', description='ankyrin repeat domain 13b', other_designations='', map_location='11 B5', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=77470485, end_position_on_the_genomic_accession=77489678, orientation='minus', exon_count=16, OMIM='', no_hdr0=''),
  268448 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=268448, CurrentID=0, Status='live', Symbol='Phf12', Aliases='2410142K10Rik, F630045O13, PF1, mKIAA1523', description='PHD finger protein 12', other_designations='PHD factor 1|PHD zinc finger transcription factor|phf12', map_location='11 B5', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=77982754, end_position_on_the_genomic_accession=78030539, orientation='plus', exon_count=16, OMIM='', no_hdr0=''),
  268449 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=268449, CurrentID=0, Status='live', Symbol='Rpl23a', Aliases='BC029892, MDA20', description='ribosomal protein L23A', other_designations='', map_location='11 B5', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=78180935, end_position_on_the_genomic_accession=78183584, orientation='minus', exon_count=5, OMIM='', no_hdr0=''),
  268451 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=268451, CurrentID=0, Status='live', Symbol='Rab11fip4', Aliases='A730072L08Rik, RAB11-FIP4, mKIAA1821', description='RAB11 family interacting protein 4 (class II)', other_designations='FIP4-Rab11|mRab11-FIP4A', map_location='11 46.88 cM', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=79591021, end_position_on_the_genomic_accession=79698023, orientation='plus', exon_count=17, OMIM='', no_hdr0=''),
  102635694 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102635694, CurrentID=0, Status='live', Symbol='Gm32966', Aliases='', description='predicted gene, 32966', other_designations='', map_location='14', chromosome='14', genomic_nucleotide_accession_version='NC_000080.6', start_position_on_the_genomic_accession=3972533, end_position_on_the_genomic_accession=4163200, orientation='minus', exon_count=8, OMIM='', no_hdr0=''),
  268465 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=268465, CurrentID=0, Status='live', Symbol='Eme1', Aliases='6820428D13', description='essential meiotic structure-specific endonuclease 1', other_designations='essential meiotic endonuclease 1 homolog 1', map_location='11 D', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=94644998, end_position_on_the_genomic_accession=94653785, orientation='minus', exon_count=10, OMIM='', no_hdr0=''),
  102635699 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102635699, CurrentID=0, Status='live', Symbol='Gm32970', Aliases='', description='predicted gene, 32970', other_designations='', map_location='15', chromosome='15', genomic_nucleotide_accession_version='NC_000081.6', start_position_on_the_genomic_accession=34744970, end_position_on_the_genomic_accession=34838442, orientation='minus', exon_count=11, OMIM='', no_hdr0=''),
  268469 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=268469, CurrentID=0, Status='live', Symbol='Zfp652', Aliases='9530033F24Rik, ZNF652', description='zinc finger protein 652', other_designations='', map_location='11 D', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=95749067, end_position_on_the_genomic_accession=95764715, orientation='plus', exon_count=5, OMIM='', no_hdr0=''),
  268470 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=268470, CurrentID=0, Status='live', Symbol='Ube2z', Aliases='AW049199, C030047H17Rik, D11Moh35', description='ubiquitin-conjugating enzyme E2Z', other_designations='E2 ubiquitin-conjugating enzyme Z|uba6-specific E2 conjugating enzyme 1|ubiquitin carrier protein Z|ubiquitin-conjugating enzyme E2Z (putative)|ubiquitin-protein ligase Z|use1', map_location='11 59.28 cM', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=96047431, end_position_on_the_genomic_accession=96065364, orientation='minus', exon_count=7, OMIM='', no_hdr0=''),
  102635707 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102635707, CurrentID=0, Status='live', Symbol='LOC102635707', Aliases='', description='uncharacterized LOC102635707', other_designations='', map_location='', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=75249369, end_position_on_the_genomic_accession=75322407, orientation='plus', exon_count=8, OMIM='', no_hdr0=''),
  399548 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=399548, CurrentID=0, Status='live', Symbol='Scn4b', Aliases='Gm1471', description='sodium channel, type IV, beta', other_designations='sodium channel accessory subunit|sodium channel beta 4 subunit|sodium channel, type IV, beta polypeptide|voltage gated sodium channel beta 4 subunit', map_location='9 A5.2', chromosome='9', genomic_nucleotide_accession_version='NC_000075.6', start_position_on_the_genomic_accession=45139042, end_position_on_the_genomic_accession=45154061, orientation='plus', exon_count=5, OMIM='', no_hdr0=''),
  399549 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=399549, CurrentID=0, Status='live', Symbol='H2-M10.6', Aliases='', description='histocompatibility 2, M region locus 10.6', other_designations='', map_location='17 B1', chromosome='17', genomic_nucleotide_accession_version='NC_000083.6', start_position_on_the_genomic_accession=36812175, end_position_on_the_genomic_accession=36815566, orientation='plus', exon_count=6, OMIM='', no_hdr0=''),
  268480 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=268480, CurrentID=0, Status='live', Symbol='Rapgefl1', Aliases='B230105J10', description='Rap guanine nucleotide exchange factor (GEF)-like 1', other_designations='', map_location='11 D', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=98836785, end_position_on_the_genomic_accession=98853006, orientation='plus', exon_count=15, OMIM='', no_hdr0=''),
  268481 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=268481, CurrentID=0, Status='live', Symbol='Krt222', Aliases='6330509G02Rik', description='keratin 222', other_designations='keratin-222', map_location='11 D', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=99232761, end_position_on_the_genomic_accession=99244281, orientation='minus', exon_count=6, OMIM='', no_hdr0=''),
  268482 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=268482, CurrentID=0, Status='live', Symbol='Krt12', Aliases='AI835216, K12, Krt-12, Krt1-12', description='keratin 12', other_designations='CK-12|Keratin, type I cytoskeletal 12 (Cytokeratin 12)|cytokeratin-12|keratin complex 1, acidic, gene 12|keratin-12', map_location='11 62.92 cM', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=99415664, end_position_on_the_genomic_accession=99422593, orientation='minus', exon_count=9, OMIM='', no_hdr0=''),
  399558 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=399558, CurrentID=0, Status='live', Symbol='Flrt2', Aliases='', description='fibronectin leucine rich transmembrane protein 2', other_designations='', map_location='12 E', chromosome='12', genomic_nucleotide_accession_version='NC_000078.6', start_position_on_the_genomic_accession=95692038, end_position_on_the_genomic_accession=95785215, orientation='plus', exon_count=4, OMIM='', no_hdr0=''),
  268490 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=268490, CurrentID=0, Status='live', Symbol='Lsm12', Aliases='1110032E16Rik, 1110059P07, 2600001B17Rik', description='LSM12 homolog', other_designations='', map_location='11 D', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=102163489, end_position_on_the_genomic_accession=102186270, orientation='minus', exon_count=6, OMIM='', no_hdr0=''),
  268491 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=268491, CurrentID=0, Status='live', Symbol='Meioc', Aliases='Gm1564, Gm663', description='meiosis specific with coiled-coil domain', other_designations='', map_location='11 E1', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=102664966, end_position_on_the_genomic_accession=102682240, orientation='plus', exon_count=8, OMIM='', no_hdr0=''),
  399566 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=399566, CurrentID=0, Status='live', Symbol='Btbd6', Aliases='', description='BTB (POZ) domain containing 6', other_designations='', map_location='12 F1', chromosome='12', genomic_nucleotide_accession_version='NC_000078.6', start_position_on_the_genomic_accession=112974998, end_position_on_the_genomic_accession=112979493, orientation='plus', exon_count=5, OMIM='', no_hdr0=''),
  399568 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=399568, CurrentID=0, Status='live', Symbol='BC052040', Aliases='', description='cDNA sequence BC052040', other_designations='', map_location='2 E4', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=115581618, end_position_on_the_genomic_accession=115778768, orientation='plus', exon_count=14, OMIM='', no_hdr0=''),
  399572 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=399572, CurrentID=0, Status='live', Symbol='E430010N07Rik', Aliases='', description='RIKEN cDNA E430010N07 gene', other_designations='', map_location='', chromosome='X', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  399573 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=399573, CurrentID=0, Status='live', Symbol='1110065F06Rik', Aliases='', description='RIKEN cDNA 1110065F06 gene', other_designations='', map_location='', chromosome='4', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  399574 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=399574, CurrentID=0, Status='live', Symbol='D630050G16Rik', Aliases='', description='RIKEN cDNA D630050G16 gene', other_designations='', map_location='', chromosome='5', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  399575 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=399575, CurrentID=0, Status='live', Symbol='D930021H04Rik', Aliases='', description='RIKEN cDNA D930021H04 gene', other_designations='', map_location='', chromosome='7', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  399577 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=399577, CurrentID=0, Status='live', Symbol='B230204D01Rik', Aliases='', description='RIKEN cDNA B230204D01 gene', other_designations='', map_location='', chromosome='6', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  399578 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=399578, CurrentID=0, Status='live', Symbol='8030447M02Rik', Aliases='', description='RIKEN cDNA 8030447M02 gene', other_designations='', map_location='', chromosome='2', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  399579 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=399579, CurrentID=0, Status='live', Symbol='6720462K09Rik', Aliases='', description='RIKEN cDNA 6720462K09 gene', other_designations='', map_location='', chromosome='4', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  399580 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=399580, CurrentID=0, Status='live', Symbol='C130051G18Rik', Aliases='', description='RIKEN cDNA C130051G18 gene', other_designations='', map_location='', chromosome='3', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  399581 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=399581, CurrentID=0, Status='live', Symbol='C130057M05Rik', Aliases='', description='RIKEN cDNA C130057M05 gene', other_designations='', map_location='', chromosome='2', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  268510 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=268510, CurrentID=0, Status='live', Symbol='Mgat5b', Aliases='C330018B01, GnT-IX, mGnTVB', description='mannoside acetylglucosaminyltransferase 5, isoenzyme B', other_designations='GNT-Vb|N-acetylglucosaminyl-transferase Vb|N-acetylglucosaminyltranferase VB|N-acetylglucosaminyltransferase IX|UDP-N-acetylglucosamine: alpha1,6-D-mannoside beta1,6-N-acetylglucosaminyltransferase b|alpha-mannoside beta-1,6-N-acetylglucosaminyltransferase B|beta1,6-N-acetylglucosaminyltransferase IX (GnT-IX)|glcNAc-T Vb|mannoside acetylglucosaminyltransferase 5B', map_location='11 E2', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=116918856, end_position_on_the_genomic_accession=116986944, orientation='plus', exon_count=18, OMIM='', no_hdr0=''),
  399583 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=399583, CurrentID=0, Status='live', Symbol='E330034L11Rik', Aliases='', description='RIKEN cDNA E330034L11 gene', other_designations='', map_location='', chromosome='3', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  268512 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=268512, CurrentID=0, Status='live', Symbol='Slc26a11', Aliases='F630021I08Rik', description='solute carrier family 26, member 11', other_designations='anion exchanger Slc26a11|novel sulfate transporter protein (Slc26a11)|slc26a11', map_location='11 E2', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=119355532, end_position_on_the_genomic_accession=119381076, orientation='plus', exon_count=17, OMIM='', no_hdr0=''),
  268515 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=268515, CurrentID=0, Status='live', Symbol='Bahcc1', Aliases='B930044J06, BC060615', description='BAH domain and coiled-coil containing 1', other_designations='', map_location='11 E2', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=120232904, end_position_on_the_genomic_accession=120292297, orientation='plus', exon_count=31, OMIM='', no_hdr0=''),
  399590 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=399590, CurrentID=0, Status='live', Symbol='C230011H18Rik', Aliases='', description='RIKEN cDNA C230011H18 gene', other_designations='', map_location='', chromosome='2', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  399591 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=399591, CurrentID=0, Status='live', Symbol='Tmsb15l', Aliases='4930488E11Rik, Tb15r, Tmsb15b1-Tmsb15b2, Tmsb15r', description='thymosin beta 15b like', other_designations='Tmsb15b1-Tmsb15b2 readthrough transcript', map_location='X F1', chromosome='X', genomic_nucleotide_accession_version='NC_000086.7', start_position_on_the_genomic_accession=136954988, end_position_on_the_genomic_accession=136976874, orientation='minus', exon_count=4, OMIM='', no_hdr0=''),
  399592 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=399592, CurrentID=0, Status='live', Symbol='8430406M14Rik', Aliases='', description='RIKEN cDNA 8430406M14 gene', other_designations='', map_location='', chromosome='7', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  399593 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=399593, CurrentID=0, Status='live', Symbol='8030497I03Rik', Aliases='', description='RIKEN cDNA 8030497I03 gene', other_designations='', map_location='', chromosome='2', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  399594 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=399594, CurrentID=0, Status='live', Symbol='D430013B06Rik', Aliases='', description='RIKEN cDNA D430013B06 gene', other_designations='', map_location='', chromosome='1', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  399597 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=399597, CurrentID=0, Status='live', Symbol='B130011D17Rik', Aliases='', description='RIKEN cDNA B130011D17 gene', other_designations='', map_location='', chromosome='8', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  399599 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=399599, CurrentID=0, Status='live', Symbol='Ccdc87', Aliases='4931419P11Rik', description='coiled-coil domain containing 87', other_designations='', map_location='19 A', chromosome='19', genomic_nucleotide_accession_version='NC_000085.6', start_position_on_the_genomic_accession=4839366, end_position_on_the_genomic_accession=4842528, orientation='plus', exon_count=1, OMIM='', no_hdr0=''),
  399600 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=399600, CurrentID=0, Status='live', Symbol='7030407E18Rik', Aliases='', description='RIKEN cDNA 7030407E18 gene', other_designations='', map_location='', chromosome='11', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  399601 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=399601, CurrentID=0, Status='live', Symbol='D830039D19Rik', Aliases='', description='RIKEN cDNA D830039D19 gene', other_designations='', map_location='', chromosome='10', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  399602 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=399602, CurrentID=0, Status='live', Symbol='9930024M15Rik', Aliases='', description='RIKEN cDNA 9930024M15 gene', other_designations='', map_location='', chromosome='10', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  399603 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=399603, CurrentID=0, Status='live', Symbol='Fam84b', Aliases='BF642811, D330050I23Rik', description='family with sequence similarity 84, member B', other_designations='', map_location='15 D1', chromosome='15', genomic_nucleotide_accession_version='NC_000081.6', start_position_on_the_genomic_accession=60818996, end_position_on_the_genomic_accession=60825080, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  399604 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=399604, CurrentID=0, Status='live', Symbol='C530014P21Rik', Aliases='', description='RIKEN cDNA C530014P21 gene', other_designations='', map_location='', chromosome='17', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  399605 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=399605, CurrentID=0, Status='live', Symbol='D330045E12Rik', Aliases='', description='RIKEN cDNA D330045E12 gene', other_designations='', map_location='', chromosome='17', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  268534 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=268534, CurrentID=0, Status='live', Symbol='Sntg2', Aliases='2210008K22Rik, 9530013L23, BB121248', description='syntrophin, gamma 2', other_designations='G2SYN|SYN5|syntrophin-5', map_location='12 B1', chromosome='12', genomic_nucleotide_accession_version='NC_000078.6', start_position_on_the_genomic_accession=30174480, end_position_on_the_genomic_accession=30373392, orientation='minus', exon_count=19, OMIM='', no_hdr0=''),
  399607 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=399607, CurrentID=0, Status='live', Symbol='D230019N24Rik', Aliases='', description='RIKEN cDNA D230019N24 gene', other_designations='', map_location='', chromosome='10', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  399608 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=399608, CurrentID=0, Status='live', Symbol='9430088F21Rik', Aliases='', description='RIKEN cDNA 9430088F21 gene', other_designations='', map_location='', chromosome='15', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  399611 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=399611, CurrentID=0, Status='live', Symbol='A230091C14Rik', Aliases='', description='RIKEN cDNA A230091C14 gene', other_designations='', map_location='', chromosome='13', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  399612 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=399612, CurrentID=0, Status='live', Symbol='9630010G10Rik', Aliases='', description='RIKEN cDNA 9630010G10 gene', other_designations='', map_location='', chromosome='17', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  399616 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=399616, CurrentID=0, Status='live', Symbol='A130078K24Rik', Aliases='', description='RIKEN cDNA A130078K24 gene', other_designations='', map_location='', chromosome='14', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  399617 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=399617, CurrentID=0, Status='live', Symbol='A130019P10Rik', Aliases='', description='RIKEN cDNA A130019P10 gene', other_designations='', map_location='', chromosome='10', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  399619 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=399619, CurrentID=0, Status='live', Symbol='A930027P06Rik', Aliases='', description='RIKEN cDNA A930027P06 gene', other_designations='', map_location='', chromosome='13', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  102635781 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102635781, CurrentID=0, Status='live', Symbol='Gm38481', Aliases='', description='predicted gene, 38481', other_designations='isopentenyl-diphosphate Delta-isomerase 1', map_location='2', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=53694370, end_position_on_the_genomic_accession=53696854, orientation='minus', exon_count=1, OMIM='', no_hdr0=''),
  399623 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=399623, CurrentID=0, Status='live', Symbol='5930433N17Rik', Aliases='', description='RIKEN cDNA 5930433N17 gene', other_designations='', map_location='', chromosome='13', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  399625 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=399625, CurrentID=0, Status='live', Symbol='2410003I16Rik', Aliases='', description='RIKEN cDNA 2410003I16 gene', other_designations='', map_location='', chromosome='16', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  399627 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=399627, CurrentID=0, Status='live', Symbol='D030007L05Rik', Aliases='', description='RIKEN cDNA D030007L05 gene', other_designations='', map_location='', chromosome='13', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  399629 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=399629, CurrentID=0, Status='live', Symbol='9530029O12Rik', Aliases='', description='RIKEN cDNA 9530029O12 gene', other_designations='', map_location='', chromosome='11', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  399631 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=399631, CurrentID=0, Status='live', Symbol='D130009B15Rik', Aliases='', description='RIKEN cDNA D130009B15 gene', other_designations='', map_location='', chromosome='14', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  399632 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=399632, CurrentID=0, Status='live', Symbol='A330001L22Rik', Aliases='', description='RIKEN cDNA A330001L22 gene', other_designations='', map_location='', chromosome='14', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  399635 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=399635, CurrentID=0, Status='live', Symbol='D230044B12Rik', Aliases='', description='RIKEN cDNA D230044B12 gene', other_designations='', map_location='', chromosome='15', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  268564 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=268564, CurrentID=0, Status='live', Symbol='Zbtb1', Aliases='9430077A12, AI256369, Bsg2, C430003J21Rik', description='zinc finger and BTB domain containing 1', other_designations='brain specific protein 2', map_location='12 C3', chromosome='12', genomic_nucleotide_accession_version='NC_000078.6', start_position_on_the_genomic_accession=76370192, end_position_on_the_genomic_accession=76396955, orientation='plus', exon_count=5, OMIM='', no_hdr0=''),
  399637 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=399637, CurrentID=0, Status='live', Symbol='C130079B09Rik', Aliases='', description='RIKEN cDNA C130079B09 gene', other_designations='', map_location='', chromosome='15', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  268566 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=268566, CurrentID=0, Status='live', Symbol='Gphn', Aliases='5730552E08Rik, AI662856, BC027112, C230040D23, GPH, GPHRYN, geph', description='gephyrin', other_designations='', map_location='12 D2', chromosome='12', genomic_nucleotide_accession_version='NC_000078.6', start_position_on_the_genomic_accession=78224153, end_position_on_the_genomic_accession=78684772, orientation='plus', exon_count=27, OMIM='', no_hdr0=''),
  268567 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=268567, CurrentID=0, Status='live', Symbol='Tmem229b', Aliases='6330442E10Rik, 9830138K24, AU019070', description='transmembrane protein 229B', other_designations='', map_location='12 C3', chromosome='12', genomic_nucleotide_accession_version='NC_000078.6', start_position_on_the_genomic_accession=78961795, end_position_on_the_genomic_accession=79007659, orientation='minus', exon_count=7, OMIM='', no_hdr0=''),
  399640 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=399640, CurrentID=0, Status='live', Symbol='A1300008O04Rik', Aliases='', description='RIKEN cDNA A1300008O04 gene', other_designations='', map_location='', chromosome='9', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  399641 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=399641, CurrentID=0, Status='live', Symbol='A7300091P13Rik', Aliases='', description='RIKEN cDNA A7300091P13 gene', other_designations='', map_location='', chromosome='16', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  102635802 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102635802, CurrentID=0, Status='live', Symbol='Gm33049', Aliases='', description='predicted gene, 33049', other_designations='', map_location='15', chromosome='15', genomic_nucleotide_accession_version='NC_000081.6', start_position_on_the_genomic_accession=88854441, end_position_on_the_genomic_accession=88862495, orientation='plus', exon_count=3, OMIM='', no_hdr0=''),
  268591 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=268591, CurrentID=0, Status='live', Symbol='Serpina5', Aliases='4933415L04, PAI-3, Pci', description='serine (or cysteine) peptidase inhibitor, clade A, member 5', other_designations='PAI3|alpha-1 antiproteinase|antitrypsin|plasminogen activator inhibitor 3|plasminogen activator inhibitor-3|protein C inhibitor|serine (or cysteine) proteinase inhibitor, clade A, member 5|serpin A5', map_location='12 F1', chromosome='12', genomic_nucleotide_accession_version='NC_000078.6', start_position_on_the_genomic_accession=104099313, end_position_on_the_genomic_accession=104106138, orientation='plus', exon_count=6, OMIM='', no_hdr0=''),
  102635825 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102635825, CurrentID=0, Status='live', Symbol='Gm28093', Aliases='', description='predicted gene 28093', other_designations='', map_location='Y', chromosome='Y', genomic_nucleotide_accession_version='NC_000087.7', start_position_on_the_genomic_accession=30360654, end_position_on_the_genomic_accession=30363056, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  268595 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=268595, CurrentID=0, Status='live', Symbol='D430019H16Rik', Aliases='AI852661', description='RIKEN cDNA D430019H16 gene', other_designations='', map_location='12 E', chromosome='12', genomic_nucleotide_accession_version='NC_000078.6', start_position_on_the_genomic_accession=105453856, end_position_on_the_genomic_accession=105493095, orientation='plus', exon_count=3, OMIM='', no_hdr0=''),
  399673 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=399673, CurrentID=0, Status='live', Symbol='Tdpoz2', Aliases='', description='TD and POZ domain containing 2', other_designations='TD and POZ domain containing gene 2|tdpoz2', map_location='3 F2.1', chromosome='3', genomic_nucleotide_accession_version='NC_000069.6', start_position_on_the_genomic_accession=93651542, end_position_on_the_genomic_accession=93652686, orientation='minus', exon_count=1, OMIM='', no_hdr0=''),
  399674 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=399674, CurrentID=0, Status='live', Symbol='Tdpoz3', Aliases='', description='TD and POZ domain containing 3', other_designations='TD and POZ domain containing gene 3|tdpoz3', map_location='3 F2.1', chromosome='3', genomic_nucleotide_accession_version='NC_000069.6', start_position_on_the_genomic_accession=93826020, end_position_on_the_genomic_accession=93827117, orientation='plus', exon_count=1, OMIM='', no_hdr0=''),
  399675 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=399675, CurrentID=0, Status='live', Symbol='Tdpoz4', Aliases='', description='TD and POZ domain containing 4', other_designations='tdpoz4', map_location='3 F2.1', chromosome='3', genomic_nucleotide_accession_version='NC_000069.6', start_position_on_the_genomic_accession=93796398, end_position_on_the_genomic_accession=93797510, orientation='plus', exon_count=1, OMIM='', no_hdr0=''),
  399676 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=399676, CurrentID=0, Status='live', Symbol='Tdpoz5', Aliases='', description='TD and POZ domain containing 5', other_designations='TD and POZ domain containing gene 5|tdpoz5', map_location='3 F2.1', chromosome='3', genomic_nucleotide_accession_version='NC_000069.6', start_position_on_the_genomic_accession=93960292, end_position_on_the_genomic_accession=93961314, orientation='minus', exon_count=1, OMIM='', no_hdr0=''),
  102635845 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102635845, CurrentID=0, Status='live', Symbol='Gm33084', Aliases='', description='predicted gene, 33084', other_designations='', map_location='16', chromosome='16', genomic_nucleotide_accession_version='NC_000082.6', start_position_on_the_genomic_accession=89288386, end_position_on_the_genomic_accession=89288631, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  328759 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=328759, CurrentID=0, Status='live', Symbol='Vmn2r95', Aliases='', description='vomeronasal 2, receptor 95', other_designations='vomeronasal receptor Vmn2r95', map_location='17 A3.2', chromosome='17', genomic_nucleotide_accession_version='NC_000083.6', start_position_on_the_genomic_accession=18424104, end_position_on_the_genomic_accession=18452324, orientation='plus', exon_count=6, OMIM='', no_hdr0=''),
  102635860 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102635860, CurrentID=0, Status='live', Symbol='Gm21724', Aliases='', description='predicted gene, 21724', other_designations='', map_location='Y', chromosome='Y', genomic_nucleotide_accession_version='NC_000087.7', start_position_on_the_genomic_accession=58368710, end_position_on_the_genomic_accession=58371114, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  102635873 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102635873, CurrentID=0, Status='live', Symbol='Gm33099', Aliases='', description='predicted gene, 33099', other_designations='', map_location='11', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=98334454, end_position_on_the_genomic_accession=98340908, orientation='plus', exon_count=5, OMIM='', no_hdr0=''),
  102635879 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102635879, CurrentID=0, Status='live', Symbol='LOC102635879', Aliases='', description='uncharacterized LOC102635879', other_designations='', map_location='', chromosome='17', genomic_nucleotide_accession_version='NC_000083.6', start_position_on_the_genomic_accession=80062220, end_position_on_the_genomic_accession=80063462, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  268656 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=268656, CurrentID=0, Status='live', Symbol='Sptlc1', Aliases='AW552086, C77762, E030036H05, Lcb1', description='serine palmitoyltransferase, long chain base subunit 1', other_designations='LCB 1|SPT 1|SPT1|long chain base biosynthesis protein 1|serine-palmitoyl-CoA transferase 1', map_location='13 B1', chromosome='13', genomic_nucleotide_accession_version='NC_000079.6', start_position_on_the_genomic_accession=53332748, end_position_on_the_genomic_accession=53377417, orientation='minus', exon_count=16, OMIM='', no_hdr0=''),
  328766 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=328766, CurrentID=0, Status='live', Symbol='Gm5092', Aliases='4933430A09', description='predicted gene 5092', other_designations='', map_location='17', chromosome='17', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  268663 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=268663, CurrentID=0, Status='live', Symbol='Cdhr2', Aliases='Gm624, PC-LKC, Pcdh24', description='cadherin-related family member 2', other_designations='protocadherin 24|protocadherin LKC', map_location='13 B1', chromosome='13', genomic_nucleotide_accession_version='NC_000079.6', start_position_on_the_genomic_accession=54701463, end_position_on_the_genomic_accession=54736662, orientation='plus', exon_count=32, OMIM='', no_hdr0=''),
  268670 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=268670, CurrentID=0, Status='live', Symbol='Zfp759', Aliases='BC028265, Rslcan-8, Rslcan8', description='zinc finger protein 759', other_designations='regulator of sex-limitation candidate 8', map_location='13 34.54 cM', chromosome='13', genomic_nucleotide_accession_version='NC_000079.6', start_position_on_the_genomic_accession=67125128, end_position_on_the_genomic_accession=67142404, orientation='plus', exon_count=7, OMIM='', no_hdr0=''),
  268686 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=268686, CurrentID=0, Status='live', Symbol='S100z', Aliases='Gm625', description='S100 calcium binding protein, zeta', other_designations='', map_location='13 D1', chromosome='13', genomic_nucleotide_accession_version='NC_000079.6', start_position_on_the_genomic_accession=95477266, end_position_on_the_genomic_accession=95479379, orientation='minus', exon_count=4, OMIM='', no_hdr0=''),
  268697 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=268697, CurrentID=0, Status='live', Symbol='Ccnb1', Aliases='Ccnb1-rs1-rs13, CycB1, Cycb-4, Cycb-5, Cycb1-rs1, Ccnb1', description='cyclin B1', other_designations='G2/mitotic-specific cyclin B1|cyclin B1, related sequence 1|cyclin B1, related sequence 13', map_location='13 53.23 cM', chromosome='13', genomic_nucleotide_accession_version='NC_000079.6', start_position_on_the_genomic_accession=100778732, end_position_on_the_genomic_accession=100786543, orientation='minus', exon_count=9, OMIM='', no_hdr0=''),
  268706 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=268706, CurrentID=0, Status='live', Symbol='Slc38a9', Aliases='4833412L08Rik, 6720411P22Rik, 9130023D20Rik, 9430067K09Rik, A730092C09', description='solute carrier family 38, member 9', other_designations='putative sodium-coupled neutral amino acid transporter 9|solute carrier family 38 member 9', map_location='13 D2.2', chromosome='13', genomic_nucleotide_accession_version='NC_000079.6', start_position_on_the_genomic_accession=112660691, end_position_on_the_genomic_accession=112738752, orientation='plus', exon_count=17, OMIM='', no_hdr0=''),
  268709 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=268709, CurrentID=0, Status='live', Symbol='Fam107a', Aliases='DRR1', description='family with sequence similarity 107, member A', other_designations='', map_location='14 A1', chromosome='14', genomic_nucleotide_accession_version='NC_000080.6', start_position_on_the_genomic_accession=8296270, end_position_on_the_genomic_accession=8318018, orientation='minus', exon_count=6, OMIM='', no_hdr0=''),
  102635944 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102635944, CurrentID=0, Status='live', Symbol='Gm33153', Aliases='', description='predicted gene, 33153', other_designations='', map_location='8', chromosome='8', genomic_nucleotide_accession_version='NC_000074.6', start_position_on_the_genomic_accession=54076070, end_position_on_the_genomic_accession=54077776, orientation='minus', exon_count=1, OMIM='', no_hdr0=''),
  268721 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=268721, CurrentID=0, Status='live', Symbol='Zswim8', Aliases='2310021P13Rik, 4832404P21Rik, Kiaa0913, mKIAA0913', description='zinc finger SWIM-type containing 8', other_designations='', map_location='14 A3', chromosome='14', genomic_nucleotide_accession_version='NC_000080.6', start_position_on_the_genomic_accession=20707319, end_position_on_the_genomic_accession=20723619, orientation='plus', exon_count=27, OMIM='', no_hdr0=''),
  634611 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=634611, CurrentID=0, Status='live', Symbol='Gm10760', Aliases='ENSMUSG00000074798', description='predicted gene 10760', other_designations='', map_location='13', chromosome='13', genomic_nucleotide_accession_version='NC_000079.6', start_position_on_the_genomic_accession=76382495, end_position_on_the_genomic_accession=76385232, orientation='minus', exon_count=1, OMIM='', no_hdr0=''),
  102635956 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102635956, CurrentID=0, Status='live', Symbol='Gm33161', Aliases='', description='predicted gene, 33161', other_designations='', map_location='2', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=127303523, end_position_on_the_genomic_accession=127310311, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  268729 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=268729, CurrentID=0, Status='live', Symbol='Gm626', Aliases='ENSMUSG00000071536, Frmpd2, Gm1582', description='predicted gene 626', other_designations='FERM and PDZ domain containing 2', map_location='14 B', chromosome='14', genomic_nucleotide_accession_version='NC_000080.6', start_position_on_the_genomic_accession=33471696, end_position_on_the_genomic_accession=33575269, orientation='plus', exon_count=31, OMIM='', no_hdr0=''),
  66634 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=66634, CurrentID=0, Status='live', Symbol='Mcm8', Aliases='5730432L01Rik', description='minichromosome maintenance 8 homologous recombination repair factor', other_designations='DNA replication licensing factor MCM8|minichromosome maintenance 8|minichromosome maintenance deficient 8', map_location='2 F3', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=132816141, end_position_on_the_genomic_accession=132844197, orientation='plus', exon_count=19, OMIM='', no_hdr0=''),
  268739 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=268739, CurrentID=0, Status='live', Symbol='Arhgef40', Aliases='E130112L23Rik, Gm669, Solo', description='Rho guanine nucleotide exchange factor (GEF) 40', other_designations='protein SOLO', map_location='14 C2', chromosome='14', genomic_nucleotide_accession_version='NC_000080.6', start_position_on_the_genomic_accession=51984681, end_position_on_the_genomic_accession=52006247, orientation='plus', exon_count=24, OMIM='', no_hdr0=''),
  268741 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=268741, CurrentID=0, Status='live', Symbol='Tox4', Aliases='5730589K01Rik, A630040M18, AA410149, LCP1', description='TOX high mobility group box family member 4', other_designations='epidermal Langerhans cell protein LCP1', map_location='14 C2', chromosome='14', genomic_nucleotide_accession_version='NC_000080.6', start_position_on_the_genomic_accession=52279146, end_position_on_the_genomic_accession=52295509, orientation='plus', exon_count=10, OMIM='', no_hdr0=''),
  268747 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=268747, CurrentID=0, Status='live', Symbol='Lrrc16b', Aliases='mFLJ00240', description='leucine rich repeat containing 16B', other_designations='', map_location='14 C3', chromosome='14', genomic_nucleotide_accession_version='NC_000080.6', start_position_on_the_genomic_accession=55490656, end_position_on_the_genomic_accession=55508272, orientation='plus', exon_count=40, OMIM='', no_hdr0=''),
  268749 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=268749, CurrentID=0, Status='live', Symbol='Rnf31', Aliases='AL033293, BC031509, Flj10111, HOIP, Paul, mFLJ00217', description='ring finger protein 31', other_designations='HOIL-1-interacting protein|putative Ariadne-like ubiquitin ligase', map_location='14 C3', chromosome='14', genomic_nucleotide_accession_version='NC_000080.6', start_position_on_the_genomic_accession=55591713, end_position_on_the_genomic_accession=55603671, orientation='plus', exon_count=21, OMIM='', no_hdr0=''),
  268752 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=268752, CurrentID=0, Status='live', Symbol='Wdfy2', Aliases='5830485M08, B130024L21Rik, ProF, ZFYVE22', description='WD repeat and FYVE domain containing 2', other_designations='WD40- and FYVE domain-containing protein 2|propeller-FYVE protein', map_location='14 D1', chromosome='14', genomic_nucleotide_accession_version='NC_000080.6', start_position_on_the_genomic_accession=62837690, end_position_on_the_genomic_accession=62961509, orientation='plus', exon_count=13, OMIM='', no_hdr0=''),
  268756 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=268756, CurrentID=0, Status='live', Symbol='Gulo', Aliases='5730581M22, AU018375, BC028822, GLO, LGO, sfx, unh, unhip', description='gulonolactone (L-) oxidase', other_designations='L-gulono-gamma-lactone oxidase', map_location='14 D1', chromosome='14', genomic_nucleotide_accession_version='NC_000080.6', start_position_on_the_genomic_accession=65986786, end_position_on_the_genomic_accession=66009254, orientation='minus', exon_count=12, OMIM='', no_hdr0=''),
  102635990 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102635990, CurrentID=0, Status='live', Symbol='LOC102635990', Aliases='', description='uncharacterized LOC102635990', other_designations='', map_location='', chromosome='10', genomic_nucleotide_accession_version='NC_000076.6', start_position_on_the_genomic_accession=82282114, end_position_on_the_genomic_accession=82354196, orientation='minus', exon_count=7, OMIM='', no_hdr0=''),
  268759 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=268759, CurrentID=0, Status='live', Symbol='9930012K11Rik', Aliases='', description='RIKEN cDNA 9930012K11 gene', other_designations='', map_location='14 D2', chromosome='14', genomic_nucleotide_accession_version='NC_000080.6', start_position_on_the_genomic_accession=70154405, end_position_on_the_genomic_accession=70159502, orientation='minus', exon_count=7, OMIM='', no_hdr0=''),
  102635992 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102635992, CurrentID=0, Status='live', Symbol='LOC102635992', Aliases='', description='major allergen I polypeptide chain 1-like', other_designations='', map_location='', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=32100869, end_position_on_the_genomic_accession=32102050, orientation='plus', exon_count=3, OMIM='', no_hdr0=''),
  268780 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=268780, CurrentID=0, Status='live', Symbol='Egflam', Aliases='5930412K08, AU040377', description='EGF-like, fibronectin type III and laminin G domains', other_designations='EGF-like, fibronectin type-III and laminin G-like domain-containing protein|nectican', map_location='15 A1', chromosome='15', genomic_nucleotide_accession_version='NC_000081.6', start_position_on_the_genomic_accession=7206120, end_position_on_the_genomic_accession=7398746, orientation='minus', exon_count=25, OMIM='', no_hdr0=''),
  268782 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=268782, CurrentID=0, Status='live', Symbol='Agxt2', Aliases='AI303810, AI663818', description='alanine-glyoxylate aminotransferase 2', other_designations='(R)-3-amino-2-methylpropionate--pyruvate transaminase|AGT 2|D-AIBAT|beta-ALAAT II|beta-alanine-pyruvate aminotransferase', map_location='15 A1', chromosome='15', genomic_nucleotide_accession_version='NC_000081.6', start_position_on_the_genomic_accession=10358516, end_position_on_the_genomic_accession=10410159, orientation='plus', exon_count=15, OMIM='', no_hdr0=''),
  268783 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=268783, CurrentID=0, Status='live', Symbol='Mtmr12', Aliases='3Pap, 4932703C11, C730015A02Rik, Pip3ap, mKIAA1682', description='myotubularin related protein 12', other_designations='phosphatidylinositol-3 phosphate 3-phosphatase adaptor subunit|phosphatidylinositol-3-phosphatase associated protein', map_location='15 A1', chromosome='15', genomic_nucleotide_accession_version='NC_000081.6', start_position_on_the_genomic_accession=12205094, end_position_on_the_genomic_accession=12272240, orientation='plus', exon_count=16, OMIM='', no_hdr0=''),
  110334 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=110334, CurrentID=0, Status='live', Symbol='Cdr3', Aliases='', description='cerebellar degeneration-related 3', other_designations='', map_location='11', chromosome='11', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  328789 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=328789, CurrentID=0, Status='live', Symbol='Lhfpl5', Aliases='9330179O15Rik, Tmhs, hscy', description='lipoma HMGIC fusion partner-like 5', other_designations='lipoma HMGIC fusion partner-like 5 protein|tetraspan transmembrane protein, hair cell stereocilia', map_location='17 B1', chromosome='17', genomic_nucleotide_accession_version='NC_000083.6', start_position_on_the_genomic_accession=28575371, end_position_on_the_genomic_accession=28583593, orientation='plus', exon_count=4, OMIM='', no_hdr0=''),
  102636036 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102636036, CurrentID=0, Status='live', Symbol='Gm33220', Aliases='', description='predicted gene, 33220', other_designations='', map_location='15', chromosome='15', genomic_nucleotide_accession_version='NC_000081.6', start_position_on_the_genomic_accession=35083843, end_position_on_the_genomic_accession=35155904, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  268807 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=268807, CurrentID=0, Status='live', Symbol='Klhl38', Aliases='8230402K04Rik', description='kelch-like 38', other_designations='', map_location='15 D1', chromosome='15', genomic_nucleotide_accession_version='NC_000081.6', start_position_on_the_genomic_accession=58314573, end_position_on_the_genomic_accession=58324169, orientation='minus', exon_count=4, OMIM='', no_hdr0=''),
  268816 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=268816, CurrentID=0, Status='live', Symbol='Mroh5', Aliases='Gm628', description='maestro heat-like repeat family member 5', other_designations='', map_location='15 D3', chromosome='15', genomic_nucleotide_accession_version='NC_000081.6', start_position_on_the_genomic_accession=73786936, end_position_on_the_genomic_accession=73839671, orientation='minus', exon_count=11, OMIM='', no_hdr0=''),
  268822 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=268822, CurrentID=0, Status='live', Symbol='Adck5', Aliases='A230108P17', description='aarF domain containing kinase 5', other_designations='', map_location='15 D3', chromosome='15', genomic_nucleotide_accession_version='NC_000081.6', start_position_on_the_genomic_accession=76576359, end_position_on_the_genomic_accession=76595812, orientation='plus', exon_count=15, OMIM='', no_hdr0=''),
  102636061 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102636061, CurrentID=0, Status='live', Symbol='Gm33237', Aliases='', description='predicted gene, 33237', other_designations='', map_location='12', chromosome='12', genomic_nucleotide_accession_version='NC_000078.6', start_position_on_the_genomic_accession=84269017, end_position_on_the_genomic_accession=84270681, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  102636063 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102636063, CurrentID=0, Status='live', Symbol='Gm21873', Aliases='', description='predicted gene, 21873', other_designations='', map_location='Y', chromosome='Y', genomic_nucleotide_accession_version='NC_000087.7', start_position_on_the_genomic_accession=80022421, end_position_on_the_genomic_accession=80024919, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  110342 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=110342, CurrentID=0, Status='live', Symbol='Tel14q', Aliases='', description='telomeric sequence, Chr 14, q arm', other_designations='', map_location='', chromosome='14', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  102636071 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102636071, CurrentID=0, Status='live', Symbol='Gm33244', Aliases='', description='predicted gene, 33244', other_designations='protein SPT2 homolog', map_location='6', chromosome='6', genomic_nucleotide_accession_version='NC_000072.6', start_position_on_the_genomic_accession=120037675, end_position_on_the_genomic_accession=120040535, orientation='plus', exon_count=4, OMIM='', no_hdr0=''),
  102636082 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102636082, CurrentID=0, Status='live', Symbol='Ccdc168', Aliases='', description='coiled-coil domain containing 168', other_designations='', map_location='', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=44055869, end_position_on_the_genomic_accession=44080198, orientation='minus', exon_count=4, OMIM='', no_hdr0=''),
  268853 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=268853, CurrentID=0, Status='live', Symbol='Gm671', Aliases='', description='predicted gene 671', other_designations='', map_location='15 F2', chromosome='15', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  268857 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=268857, CurrentID=0, Status='live', Symbol='Nlrc3', Aliases='CLR16.2, D230007K08Rik, mFLJ00348', description='NLR family, CARD domain containing 3', other_designations='Caterpiller 16.2|caterpillar 16.2', map_location='16 A1', chromosome='16', genomic_nucleotide_accession_version='NC_000082.6', start_position_on_the_genomic_accession=3943807, end_position_on_the_genomic_accession=3979032, orientation='minus', exon_count=20, OMIM='', no_hdr0=''),
  268859 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=268859, CurrentID=0, Status='live', Symbol='Rbfox1', Aliases='A2bp, A2bp1, Hrnbp1, fox-1', description='RNA binding protein, fox-1 homolog (C. elegans) 1', other_designations='ataxin 2 binding protein 1|ataxin-2-binding protein 1|fox-1 homolog A|hexaribonucleotide binding protein 1', map_location='16 3.34 cM', chromosome='16', genomic_nucleotide_accession_version='NC_000082.6', start_position_on_the_genomic_accession=5884793, end_position_on_the_genomic_accession=7412480, orientation='plus', exon_count=32, OMIM='', no_hdr0=''),
  268860 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=268860, CurrentID=0, Status='live', Symbol='Abat', Aliases='9630038C02Rik, AI255750, ENSMUSG00000051226, Gabaat, Gabat, Gm9851, I54, Laibat, X61497', description='4-aminobutyrate aminotransferase', other_designations='(S)-3-amino-2-methylpropionate transaminase|4-aminobutyrate transaminase|GABA aminotransferase|GABA transaminase|GABA transferase|beta-alanine oxoglutarate aminotransferase|gamma-amino-N-butyrate transaminase', map_location='16 A3', chromosome='16', genomic_nucleotide_accession_version='NC_000082.6', start_position_on_the_genomic_accession=8513429, end_position_on_the_genomic_accession=8621568, orientation='plus', exon_count=17, OMIM='', no_hdr0=''),
  102636102 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102636102, CurrentID=0, Status='live', Symbol='Gm33267', Aliases='', description='predicted gene, 33267', other_designations='', map_location='Y', chromosome='Y', genomic_nucleotide_accession_version='NC_000087.7', start_position_on_the_genomic_accession=17465675, end_position_on_the_genomic_accession=17473783, orientation='plus', exon_count=4, OMIM='', no_hdr0=''),
  268878 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=268878, CurrentID=0, Status='live', Symbol='Atp13a5', Aliases='C630015F21Rik', description='ATPase type 13A5', other_designations='P5-ATPase', map_location='16 B2', chromosome='16', genomic_nucleotide_accession_version='NC_000082.6', start_position_on_the_genomic_accession=29231851, end_position_on_the_genomic_accession=29378764, orientation='minus', exon_count=30, OMIM='', no_hdr0=''),
  268880 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=268880, CurrentID=0, Status='live', Symbol='Xxylt1', Aliases='AI480653', description='xyloside xylosyltransferase 1', other_designations='UDP-xylose:alpha-xyloside alpha-1,3-xylosyltransferase', map_location='16 B2', chromosome='16', genomic_nucleotide_accession_version='NC_000082.6', start_position_on_the_genomic_accession=30928348, end_position_on_the_genomic_accession=31081551, orientation='minus', exon_count=6, OMIM='', no_hdr0=''),
  268882 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=268882, CurrentID=0, Status='live', Symbol='Fbxo45', Aliases='2610017J04Rik, AI463119, BC026799', description='F-box protein 45', other_designations='F-box only protein 45|fbxo45|mFbxo45', map_location='16 B2', chromosome='16', genomic_nucleotide_accession_version='NC_000082.6', start_position_on_the_genomic_accession=32230112, end_position_on_the_genomic_accession=32247025, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  268885 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=268885, CurrentID=0, Status='live', Symbol='Stfa2l1', Aliases='', description='stefin A2 like 1', other_designations='', map_location='16 B3', chromosome='16', genomic_nucleotide_accession_version='NC_000082.6', start_position_on_the_genomic_accession=36156811, end_position_on_the_genomic_accession=36161948, orientation='plus', exon_count=3, OMIM='', no_hdr0=''),
  268890 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=268890, CurrentID=0, Status='live', Symbol='Lsamp', Aliases='5430428I19, AW046674, B130007O04Rik, D930023J12Rik, Lam, Lamp', description='limbic system-associated membrane protein', other_designations='', map_location='16 B5', chromosome='16', genomic_nucleotide_accession_version='NC_000082.6', start_position_on_the_genomic_accession=41532788, end_position_on_the_genomic_accession=42181679, orientation='plus', exon_count=9, OMIM='', no_hdr0=''),
  102636124 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102636124, CurrentID=0, Status='live', Symbol='LOC102636124', Aliases='', description='ATP synthase subunit f, mitochondrial-like', other_designations='', map_location='', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=18645735, end_position_on_the_genomic_accession=18668184, orientation='minus', exon_count=4, OMIM='', no_hdr0=''),
  102636131 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102636131, CurrentID=0, Status='live', Symbol='Gm13067', Aliases='OTTMUSG00000010272', description='predicted gene 13067', other_designations='', map_location='4 80.81 cM', chromosome='4', genomic_nucleotide_accession_version='NC_000070.6', start_position_on_the_genomic_accession=150029405, end_position_on_the_genomic_accession=150058717, orientation='plus', exon_count=8, OMIM='', no_hdr0=''),
  268902 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=268902, CurrentID=0, Status='live', Symbol='Robo2', Aliases='2600013A04Rik, 9430089E08Rik, BB097918, D230004I22Rik, mKIAA1568', description='roundabout homolog 2 (Drosophila)', other_designations='', map_location='16 C3.1', chromosome='16', genomic_nucleotide_accession_version='NC_000082.6', start_position_on_the_genomic_accession=73892061, end_position_on_the_genomic_accession=75447298, orientation='minus', exon_count=33, OMIM='', no_hdr0=''),
  268903 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=268903, CurrentID=0, Status='live', Symbol='Nrip1', Aliases='6030458L20Rik, 8430438I05Rik, 9630050P12, AA959574, AW456757, RIP140', description='nuclear receptor interacting protein 1', other_designations='nrip1|nuclear factor RIP140|receptor-interacting protein 140', map_location='16 C3.1', chromosome='16', genomic_nucleotide_accession_version='NC_000082.6', start_position_on_the_genomic_accession=76287403, end_position_on_the_genomic_accession=76374195, orientation='minus', exon_count=6, OMIM='', no_hdr0=''),
  268905 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=268905, CurrentID=0, Status='live', Symbol='Krtap13-1', Aliases='AA589563, KAP13.1', description='keratin associated protein 13-1', other_designations='', map_location='16 C3.3', chromosome='16', genomic_nucleotide_accession_version='NC_000082.6', start_position_on_the_genomic_accession=88728862, end_position_on_the_genomic_accession=88729611, orientation='plus', exon_count=1, OMIM='', no_hdr0=''),
  102636150 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102636150, CurrentID=0, Status='live', Symbol='Gm33300', Aliases='', description='predicted gene, 33300', other_designations='', map_location='7', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=137167848, end_position_on_the_genomic_accession=137173431, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  268930 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=268930, CurrentID=0, Status='live', Symbol='Pkmyt1', Aliases='6230424P17, AW209059, Myt1', description='protein kinase, membrane associated tyrosine/threonine 1', other_designations='MYT1 kinase|membrane-associated tyrosine-and threonine-specific cdc2-inhibitory kinase', map_location='17 A3.3', chromosome='17', genomic_nucleotide_accession_version='NC_000083.6', start_position_on_the_genomic_accession=23726336, end_position_on_the_genomic_accession=23736735, orientation='plus', exon_count=9, OMIM='', no_hdr0=''),
  268932 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=268932, CurrentID=0, Status='live', Symbol='Caskin1', Aliases='3300002N10Rik, C130061I24, C630036E02Rik, mKIAA1306', description='CASK interacting protein 1', other_designations='CASK-interacting protein 1', map_location='17 A3.3', chromosome='17', genomic_nucleotide_accession_version='NC_000083.6', start_position_on_the_genomic_accession=24487852, end_position_on_the_genomic_accession=24508909, orientation='plus', exon_count=22, OMIM='', no_hdr0=''),
  268933 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=268933, CurrentID=0, Status='live', Symbol='Wdr24', Aliases='BC037651', description='WD repeat domain 24', other_designations='', map_location='17 A3.3', chromosome='17', genomic_nucleotide_accession_version='NC_000083.6', start_position_on_the_genomic_accession=25823627, end_position_on_the_genomic_accession=25828730, orientation='plus', exon_count=9, OMIM='', no_hdr0=''),
  268934 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=268934, CurrentID=0, Status='live', Symbol='Grm4', Aliases='Gprc1d, mGluR4', description='glutamate receptor, metabotropic 4', other_designations='G protein-coupled receptor GRM4|G protein-coupled receptor, family C, group 1, member D', map_location='17 A3.3', chromosome='17', genomic_nucleotide_accession_version='NC_000083.6', start_position_on_the_genomic_accession=27422387, end_position_on_the_genomic_accession=27513679, orientation='minus', exon_count=17, OMIM='', no_hdr0=''),
  268935 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=268935, CurrentID=0, Status='live', Symbol='Scube3', Aliases='CEGF3, D030038I21Rik', description='signal peptide, CUB domain, EGF-like 3', other_designations='scube3|signal peptide, CUB and EGF-like domain containing protein 3', map_location='17 A3.3', chromosome='17', genomic_nucleotide_accession_version='NC_000083.6', start_position_on_the_genomic_accession=28142100, end_position_on_the_genomic_accession=28174851, orientation='plus', exon_count=23, OMIM='', no_hdr0=''),
  268936 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=268936, CurrentID=0, Status='live', Symbol='Brpf3', Aliases='AI413466, AW493400, mKIAA1286', description='bromodomain and PHD finger containing, 3', other_designations='', map_location='17 A3.3', chromosome='17', genomic_nucleotide_accession_version='NC_000083.6', start_position_on_the_genomic_accession=28800557, end_position_on_the_genomic_accession=28838789, orientation='plus', exon_count=16, OMIM='', no_hdr0=''),
  102636173 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102636173, CurrentID=0, Status='live', Symbol='Gm21880', Aliases='', description='predicted gene, 21880', other_designations='', map_location='Y', chromosome='Y', genomic_nucleotide_accession_version='NC_000087.7', start_position_on_the_genomic_accession=72103355, end_position_on_the_genomic_accession=72105875, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  102636174 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102636174, CurrentID=0, Status='live', Symbol='Gm21823', Aliases='', description='predicted gene, 21823', other_designations='', map_location='Y', chromosome='Y', genomic_nucleotide_accession_version='NC_000087.7', start_position_on_the_genomic_accession=79590278, end_position_on_the_genomic_accession=79592504, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  268949 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=268949, CurrentID=0, Status='live', Symbol='Dpcr1', Aliases='Gm630', description='diffuse panbronchiolitis critical region 1 (human)', other_designations='', map_location='17 B1', chromosome='17', genomic_nucleotide_accession_version='NC_000083.6', start_position_on_the_genomic_accession=35635755, end_position_on_the_genomic_accession=35643695, orientation='minus', exon_count=4, OMIM='', no_hdr0=''),
  268958 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=268958, CurrentID=0, Status='live', Symbol='Capn11', Aliases='', description='calpain 11', other_designations='CANP 11|calcium-activated neutral proteinase 11|calcium-dependent thiol protease|capn11', map_location='17 B3', chromosome='17', genomic_nucleotide_accession_version='NC_000083.6', start_position_on_the_genomic_accession=45630191, end_position_on_the_genomic_accession=45660090, orientation='minus', exon_count=23, OMIM='', no_hdr0=''),
  102636193 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102636193, CurrentID=0, Status='live', Symbol='Gm33328', Aliases='', description='predicted gene, 33328', other_designations='', map_location='8', chromosome='8', genomic_nucleotide_accession_version='NC_000074.6', start_position_on_the_genomic_accession=55346194, end_position_on_the_genomic_accession=55348447, orientation='plus', exon_count=1, OMIM='', no_hdr0=''),
  268970 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=268970, CurrentID=0, Status='live', Symbol='Arhgap28', Aliases='AU044757, AW550892, E130310N06', description='Rho GTPase activating protein 28', other_designations='rho-type GTPase-activating protein 28', map_location='17 E1.2', chromosome='17', genomic_nucleotide_accession_version='NC_000083.6', start_position_on_the_genomic_accession=67842706, end_position_on_the_genomic_accession=68004108, orientation='minus', exon_count=21, OMIM='', no_hdr0=''),
  268973 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=268973, CurrentID=0, Status='live', Symbol='Nlrc4', Aliases='9530011P19Rik, CLAN, CLAN1, CLANA, CLANB, CLANC, CLAND, Card12, IPAF', description='NLR family, CARD domain containing 4', other_designations='caspase recruitment domain family, member 12|caspase recruitment domain-containing protein 12|ice protease-activating factor', map_location='17 E2', chromosome='17', genomic_nucleotide_accession_version='NC_000083.6', start_position_on_the_genomic_accession=74425716, end_position_on_the_genomic_accession=74459143, orientation='minus', exon_count=11, OMIM='', no_hdr0=''),
  268977 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=268977, CurrentID=0, Status='live', Symbol='Ltbp1', Aliases='9430031G15Rik, 9830146M04, Ltbp-1, Tgfb, b2b1000Clo', description='latent transforming growth factor beta binding protein 1', other_designations='TGF-beta1-BP-1|latent TGF beta binding protein|latent transforming growth factor beta binding protein 1L|transforming growth factor beta-1-binding protein 1', map_location='17 E3', chromosome='17', genomic_nucleotide_accession_version='NC_000083.6', start_position_on_the_genomic_accession=75005529, end_position_on_the_genomic_accession=75392967, orientation='plus', exon_count=35, OMIM='', no_hdr0=''),
  268980 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=268980, CurrentID=0, Status='live', Symbol='Strn', Aliases='AU022939, D130055P19', description='striatin, calmodulin binding protein', other_designations='', map_location='17 E3', chromosome='17', genomic_nucleotide_accession_version='NC_000083.6', start_position_on_the_genomic_accession=78649908, end_position_on_the_genomic_accession=78737191, orientation='minus', exon_count=20, OMIM='', no_hdr0=''),
  268996 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=268996, CurrentID=0, Status='live', Symbol='Ss18', Aliases='D130059H17, Ssxt, Syt', description='synovial sarcoma translocation, Chromosome 18', other_designations='synovial sarcoma associated SS18-beta|synovial sarcoma associated SS18-delta|synovial sarcoma associated SS18-gamma|synovial sarcoma, translocated to X chromosome|synovial sarcoma-associated Ss18-alpha', map_location='18 B1', chromosome='18', genomic_nucleotide_accession_version='NC_000084.6', start_position_on_the_genomic_accession=14625629, end_position_on_the_genomic_accession=14683002, orientation='minus', exon_count=11, OMIM='', no_hdr0=''),
  102636230 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102636230, CurrentID=0, Status='live', Symbol='Gm33358', Aliases='', description='predicted gene, 33358', other_designations='', map_location='17', chromosome='17', genomic_nucleotide_accession_version='NC_000083.6', start_position_on_the_genomic_accession=27511782, end_position_on_the_genomic_accession=27520831, orientation='plus', exon_count=4, OMIM='', no_hdr0=''),
  269003 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=269003, CurrentID=0, Status='live', Symbol='Sap130', Aliases='2610304F09Rik, 6720406D06', description='Sin3A associated protein', other_designations='130 kDa Sin3-associated polypeptide|Sin3A associated protein, 130kDa|sin3-associated polypeptide p130', map_location='18 B2', chromosome='18', genomic_nucleotide_accession_version='NC_000084.6', start_position_on_the_genomic_accession=31634327, end_position_on_the_genomic_accession=31723068, orientation='plus', exon_count=23, OMIM='', no_hdr0=''),
  102636244 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102636244, CurrentID=0, Status='live', Symbol='Gm21912', Aliases='', description='predicted gene, 21912', other_designations='', map_location='Y', chromosome='Y', genomic_nucleotide_accession_version='NC_000087.7', start_position_on_the_genomic_accession=54489081, end_position_on_the_genomic_accession=54491401, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  328825 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=328825, CurrentID=0, Status='live', Symbol='Gm5093', Aliases='EG328825', description='predicted gene 5093', other_designations='', map_location='17 C', chromosome='17', genomic_nucleotide_accession_version='NC_000083.6', start_position_on_the_genomic_accession=46439503, end_position_on_the_genomic_accession=46440479, orientation='minus', exon_count=1, OMIM='', no_hdr0=''),
  269016 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=269016, CurrentID=0, Status='live', Symbol='Sh3rf2', Aliases='2310046K19, 9130023G24Rik, AI452083, Ppp1r39, RNF158', description='SH3 domain containing ring finger 2', other_designations='RING finger protein 158|SH3 domain-containing RING finger protein 2|protein phosphatase 1 regulatory subunit 39', map_location='18 B3', chromosome='18', genomic_nucleotide_accession_version='NC_000084.6', start_position_on_the_genomic_accession=42051743, end_position_on_the_genomic_accession=42158695, orientation='plus', exon_count=11, OMIM='', no_hdr0=''),
  269019 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=269019, CurrentID=0, Status='live', Symbol='Stk32a', Aliases='A930015B13Rik, YANK1', description='serine/threonine kinase 32A', other_designations='stk32a', map_location='18 B3', chromosome='18', genomic_nucleotide_accession_version='NC_000084.6', start_position_on_the_genomic_accession=43207697, end_position_on_the_genomic_accession=43317481, orientation='plus', exon_count=13, OMIM='', no_hdr0=''),
  269023 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=269023, CurrentID=0, Status='live', Symbol='Zfp608', Aliases='4932417D18Rik, D430007A19Rik, Znf608', description='zinc finger protein 608', other_designations='', map_location='18 D3', chromosome='18', genomic_nucleotide_accession_version='NC_000084.6', start_position_on_the_genomic_accession=54888045, end_position_on_the_genomic_accession=54992598, orientation='minus', exon_count=15, OMIM='', no_hdr0=''),
  102636259 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102636259, CurrentID=0, Status='live', Symbol='Gm33375', Aliases='', description='predicted gene, 33375', other_designations='', map_location='10', chromosome='10', genomic_nucleotide_accession_version='NC_000076.6', start_position_on_the_genomic_accession=42401423, end_position_on_the_genomic_accession=42403772, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  102636264 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102636264, CurrentID=0, Status='live', Symbol='Gm33378', Aliases='', description='predicted gene, 33378', other_designations='', map_location='10', chromosome='10', genomic_nucleotide_accession_version='NC_000076.6', start_position_on_the_genomic_accession=82011695, end_position_on_the_genomic_accession=82016869, orientation='plus', exon_count=3, OMIM='', no_hdr0=''),
  269033 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=269033, CurrentID=0, Status='live', Symbol='4930503L19Rik', Aliases='9930107F24, BB148262, Lars, Las2', description='RIKEN cDNA 4930503L19 gene', other_designations='', map_location='18 E2', chromosome='18', genomic_nucleotide_accession_version='NC_000084.6', start_position_on_the_genomic_accession=70452210, end_position_on_the_genomic_accession=70472504, orientation='minus', exon_count=9, OMIM='', no_hdr0=''),
  110375 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=110375, CurrentID=0, Status='live', Symbol='Tpm3-rs5', Aliases='', description='tropomyosin 3, related sequence 5', other_designations='', map_location='', chromosome='7', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  102636269 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102636269, CurrentID=0, Status='live', Symbol='Gm33383', Aliases='', description='predicted gene, 33383', other_designations='', map_location='X', chromosome='X', genomic_nucleotide_accession_version='NC_000086.7', start_position_on_the_genomic_accession=36401263, end_position_on_the_genomic_accession=36403446, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  102636271 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102636271, CurrentID=0, Status='live', Symbol='Gm33385', Aliases='', description='predicted gene, 33385', other_designations='', map_location='12', chromosome='12', genomic_nucleotide_accession_version='NC_000078.6', start_position_on_the_genomic_accession=108400606, end_position_on_the_genomic_accession=108411698, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  66686 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=66686, CurrentID=0, Status='live', Symbol='Dcbld1', Aliases='4631413K11Rik', description='discoidin, CUB and LCCL domain containing 1', other_designations='', map_location='10 B3', chromosome='10', genomic_nucleotide_accession_version='NC_000076.6', start_position_on_the_genomic_accession=52233584, end_position_on_the_genomic_accession=52321378, orientation='plus', exon_count=11, OMIM='', no_hdr0=''),
  102636279 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102636279, CurrentID=0, Status='live', Symbol='Gm33391', Aliases='', description='predicted gene, 33391', other_designations='', map_location='8', chromosome='8', genomic_nucleotide_accession_version='NC_000074.6', start_position_on_the_genomic_accession=86885018, end_position_on_the_genomic_accession=86926374, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  102636282 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102636282, CurrentID=0, Status='live', Symbol='Gm17124', Aliases='', description='predicted gene 17124', other_designations='', map_location='14 22.43 cM', chromosome='14', genomic_nucleotide_accession_version='NC_000080.6', start_position_on_the_genomic_accession=42595240, end_position_on_the_genomic_accession=42600157, orientation='minus', exon_count=5, OMIM='', no_hdr0=''),
  102636283 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102636283, CurrentID=0, Status='live', Symbol='Gm17093', Aliases='', description='predicted gene 17093', other_designations='', map_location='14 22.56 cM', chromosome='14', genomic_nucleotide_accession_version='NC_000080.6', start_position_on_the_genomic_accession=44518286, end_position_on_the_genomic_accession=44522978, orientation='plus', exon_count=5, OMIM='', no_hdr0=''),
  269053 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=269053, CurrentID=0, Status='live', Symbol='Gpr152', Aliases='A930009H15Rik, Gm673', description='G protein-coupled receptor 152', other_designations='putative G-protein coupled receptor', map_location='19 A', chromosome='19', genomic_nucleotide_accession_version='NC_000085.6', start_position_on_the_genomic_accession=4139799, end_position_on_the_genomic_accession=4145741, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  269060 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=269060, CurrentID=0, Status='live', Symbol='Dagla', Aliases='Nsddr', description='diacylglycerol lipase, alpha', other_designations='DGL-alpha|neural stem cell-derived dendrite regulator', map_location='19 A', chromosome='19', genomic_nucleotide_accession_version='NC_000085.6', start_position_on_the_genomic_accession=10245265, end_position_on_the_genomic_accession=10304962, orientation='minus', exon_count=21, OMIM='', no_hdr0=''),
  269061 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=269061, CurrentID=0, Status='live', Symbol='Cpsf7', Aliases='5730453I16Rik, AL022757, C330017N18Rik', description='cleavage and polyadenylation specific factor 7', other_designations='', map_location='19 A', chromosome='19', genomic_nucleotide_accession_version='NC_000085.6', start_position_on_the_genomic_accession=10525244, end_position_on_the_genomic_accession=10547735, orientation='plus', exon_count=14, OMIM='', no_hdr0=''),
  66689 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=66689, CurrentID=0, Status='live', Symbol='Klhl28', Aliases='2810440N09Rik, 4122402F11Rik, 4931401E10Rik, Btbd5', description='kelch-like 28', other_designations='BTB (POZ) domain containing 5|BTB/POZ domain-containing protein 5', map_location='12 C1', chromosome='12', genomic_nucleotide_accession_version='NC_000078.6', start_position_on_the_genomic_accession=64942198, end_position_on_the_genomic_accession=64965605, orientation='minus', exon_count=7, OMIM='', no_hdr0=''),
  110380 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=110380, CurrentID=0, Status='live', Symbol='Shroom2', Aliases='4832440C16, Apxl, C630003H05Rik, Shrm2', description='shroom family member 2', other_designations='', map_location='X 68.46 cM', chromosome='X', genomic_nucleotide_accession_version='NC_000086.7', start_position_on_the_genomic_accession=152609509, end_position_on_the_genomic_accession=152770251, orientation='minus', exon_count=13, OMIM='', no_hdr0=''),
  102636319 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102636319, CurrentID=0, Status='live', Symbol='Gm28247', Aliases='', description='predicted gene 28247', other_designations='', map_location='Y', chromosome='Y', genomic_nucleotide_accession_version='NC_000087.7', start_position_on_the_genomic_accession=26879367, end_position_on_the_genomic_accession=26881835, orientation='plus', exon_count=3, OMIM='', no_hdr0=''),
  269109 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=269109, CurrentID=0, Status='live', Symbol='Dpp10', Aliases='6430601K09Rik, DPP X, Dprp3', description='dipeptidylpeptidase 10', other_designations='dipeptidyl peptidase X', map_location='1 E2.3', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=123332138, end_position_on_the_genomic_accession=124845960, orientation='minus', exon_count=28, OMIM='', no_hdr0=''),
  102636344 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102636344, CurrentID=0, Status='live', Symbol='Gm33437', Aliases='', description='predicted gene, 33437', other_designations='', map_location='18', chromosome='18', genomic_nucleotide_accession_version='NC_000084.6', start_position_on_the_genomic_accession=26639744, end_position_on_the_genomic_accession=26752960, orientation='plus', exon_count=9, OMIM='', no_hdr0=''),
  269113 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=269113, CurrentID=0, Status='live', Symbol='Nup54', Aliases='3110079L04Rik, 54kDa', description='nucleoporin 54', other_designations='54 kDa nucleoporin|nucleoporin 54kDa|nucleoporin Nup54', map_location='5 E3', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=92415540, end_position_on_the_genomic_accession=92435265, orientation='minus', exon_count=15, OMIM='', no_hdr0=''),
  269116 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=269116, CurrentID=0, Status='live', Symbol='Nfasc', Aliases='AA387016, D430023G06Rik, NF, mKIAA0756', description='neurofascin', other_designations='', map_location='1 57.42 cM', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=132564690, end_position_on_the_genomic_accession=132741834, orientation='minus', exon_count=37, OMIM='', no_hdr0=''),
  102636351 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102636351, CurrentID=0, Status='live', Symbol='Astx4b', Aliases='Gm14956, OTTMUSG00000018591', description='amplified spermatogenic transcripts X encoded 4B', other_designations='', map_location='X 49.81 cM', chromosome='X', genomic_nucleotide_accession_version='NC_000086.7', start_position_on_the_genomic_accession=124650300, end_position_on_the_genomic_accession=124662377, orientation='plus', exon_count=11, OMIM='', no_hdr0=''),
  269120 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=269120, CurrentID=0, Status='live', Symbol='Optc', Aliases='', description='opticin', other_designations='oculoglycan', map_location='1 58.02 cM', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=133897193, end_position_on_the_genomic_accession=133909714, orientation='minus', exon_count=10, OMIM='', no_hdr0=''),
  269132 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=269132, CurrentID=0, Status='live', Symbol='Colgalt2', Aliases='AI427652, D730024P12, Glt25d2', description='collagen beta(1-O)galactosyltransferase 2', other_designations='glycosyltransferase 25 domain containing 2|glycosyltransferase 25 family member 2|hydroxylysine galactosyltransferase 2', map_location='1 G3', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=152399867, end_position_on_the_genomic_accession=152510695, orientation='plus', exon_count=12, OMIM='', no_hdr0=''),
  328845 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=328845, CurrentID=0, Status='live', Symbol='Acsbg2', Aliases='Bgr', description='acyl-CoA synthetase bubblegum family member 2', other_designations='bubblegum-related protein', map_location='17 D', chromosome='17', genomic_nucleotide_accession_version='NC_000083.6', start_position_on_the_genomic_accession=56843103, end_position_on_the_genomic_accession=56874504, orientation='minus', exon_count=17, OMIM='', no_hdr0=''),
  102636379 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102636379, CurrentID=0, Status='live', Symbol='LOC102636379', Aliases='', description='prothymosin alpha-like', other_designations='', map_location='', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=134730795, end_position_on_the_genomic_accession=134731678, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  269152 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=269152, CurrentID=0, Status='live', Symbol='Kif26b', Aliases='4832420M10, BC056349, D230039L06Rik', description='kinesin family member 26B', other_designations='N-11 kinesin|kinesin family protein 26b', map_location='1 83.16 cM', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=178525741, end_position_on_the_genomic_accession=178939200, orientation='plus', exon_count=17, OMIM='', no_hdr0=''),
  102636390 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102636390, CurrentID=0, Status='live', Symbol='Gm28739', Aliases='', description='predicted gene 28739', other_designations='', map_location='Y', chromosome='Y', genomic_nucleotide_accession_version='NC_000087.7', start_position_on_the_genomic_accession=81545199, end_position_on_the_genomic_accession=81545774, orientation='minus', exon_count=1, OMIM='', no_hdr0=''),
  269180 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=269180, CurrentID=0, Status='live', Symbol='Inpp4a', Aliases='107kDa, 9630012D15, D130048C09Rik, R74740', description='inositol polyphosphate-4-phosphatase, type I', other_designations='inositol polyphosphate 4-phosphatase type I', map_location='1 15.46 cM', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=37299838, end_position_on_the_genomic_accession=37410740, orientation='plus', exon_count=28, OMIM='', no_hdr0=''),
  269181 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=269181, CurrentID=0, Status='live', Symbol='Mgat4a', Aliases='9530018I07Rik, GnT-IVa, glcNAc-T-IVa', description='mannoside acetylglucosaminyltransferase 4, isoenzyme A', other_designations='N-acetylglucosaminyltransferase IVa|N-glycosyl-oligosaccharide-glycoprotein N-acetylglucosaminyltransferase IVa|UDP-N-acetylglucosamine: alpha-1,3-D-mannoside beta-1,4-N-acetylglucosaminyltransferase IVa', map_location='1 B', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=37439340, end_position_on_the_genomic_accession=37541047, orientation='minus', exon_count=17, OMIM='', no_hdr0=''),
  102636419 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102636419, CurrentID=0, Status='live', Symbol='Gm28553', Aliases='', description='predicted gene 28553', other_designations='', map_location='Y', chromosome='Y', genomic_nucleotide_accession_version='NC_000087.7', start_position_on_the_genomic_accession=48856480, end_position_on_the_genomic_accession=48882599, orientation='plus', exon_count=12, OMIM='', no_hdr0=''),
  102636421 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102636421, CurrentID=0, Status='live', Symbol='Gm21740', Aliases='', description='predicted gene, 21740', other_designations='', map_location='Y', chromosome='Y', genomic_nucleotide_accession_version='NC_000087.7', start_position_on_the_genomic_accession=54414835, end_position_on_the_genomic_accession=54417082, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  102636422 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102636422, CurrentID=0, Status='live', Symbol='Gm21826', Aliases='', description='predicted gene, 21826', other_designations='', map_location='Y', chromosome='Y', genomic_nucleotide_accession_version='NC_000087.7', start_position_on_the_genomic_accession=64925049, end_position_on_the_genomic_accession=64927569, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  102636423 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102636423, CurrentID=0, Status='live', Symbol='Gm21875', Aliases='', description='predicted gene, 21875', other_designations='', map_location='Y', chromosome='Y', genomic_nucleotide_accession_version='NC_000087.7', start_position_on_the_genomic_accession=75986716, end_position_on_the_genomic_accession=75989001, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  269198 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=269198, CurrentID=0, Status='live', Symbol='Nbeal1', Aliases='2310076G13Rik, A530050O19Rik, A530083I02Rik, AI662228, ALS2CR17', description='neurobeachin like 1', other_designations='', map_location='1 C2', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=60178629, end_position_on_the_genomic_accession=60334705, orientation='plus', exon_count=62, OMIM='', no_hdr0=''),
  269202 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=269202, CurrentID=0, Status='live', Symbol='BC019684', Aliases='', description='cDNA sequence BC019684', other_designations='', map_location='1 C2', chromosome='1', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  269204 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=269204, CurrentID=0, Status='live', Symbol='A730034C02', Aliases='', description='uncharacterized protein A730034C02', other_designations='', map_location='1 C3', chromosome='1', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  269209 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=269209, CurrentID=0, Status='live', Symbol='Stk36', Aliases='1700112N14Rik, B930045J24, FU, Fused, mKIAA1278', description='serine/threonine kinase 36', other_designations='fused homolog|serine/threonine kinase 36 (fused homolog, Drosophila)|stk36', map_location='1 C3', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=74601450, end_position_on_the_genomic_accession=74636894, orientation='plus', exon_count=28, OMIM='', no_hdr0=''),
  269224 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=269224, CurrentID=0, Status='live', Symbol='Pask', Aliases='mKIAA0135', description='PAS domain containing serine/threonine kinase', other_designations='PAS-kinase|paskin', map_location='1 D', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=93309437, end_position_on_the_genomic_accession=93343350, orientation='minus', exon_count=21, OMIM='', no_hdr0=''),
  328861 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=328861, CurrentID=0, Status='live', Symbol='D430006K04', Aliases='', description='uncharacterized protein D430006K04', other_designations='', map_location='17 E3', chromosome='17', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  269233 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=269233, CurrentID=0, Status='live', Symbol='Fam171a1', Aliases='9630050M13Rik, AA409679', description='family with sequence similarity 171, member A1', other_designations='', map_location='2 A1', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=3114202, end_position_on_the_genomic_accession=3227809, orientation='plus', exon_count=9, OMIM='', no_hdr0=''),
  269252 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=269252, CurrentID=0, Status='live', Symbol='Gtf3c4', Aliases='5330400C03, AI426938, AU014771, AU017413, KAT12, TFIIIC90', description='general transcription factor IIIC, polypeptide 4', other_designations='TF3C-delta|TFIIIC 90 kDa subunit|general transcription factor IIIC 4|transcription factor IIIC 90 kDa subunit|transcription factor IIIC subunit delta', map_location='2 A3', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=28822299, end_position_on_the_genomic_accession=28840360, orientation='minus', exon_count=7, OMIM='', no_hdr0=''),
  269254 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=269254, CurrentID=0, Status='live', Symbol='Setx', Aliases='A130090N03, A930037J23Rik, AOA2, AW060766, Als4, SCAR1, Sen1, mKIAA0625', description='senataxin', other_designations='SEN1 homolog|amyotrophic lateral sclerosis 4 homolog|amyotrophic lateral sclerosis 4 protein homolog', map_location='2 A3', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=29122588, end_position_on_the_genomic_accession=29182471, orientation='plus', exon_count=31, OMIM='', no_hdr0=''),
  269261 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=269261, CurrentID=0, Status='live', Symbol='Rpl12', Aliases='E430018F03', description='ribosomal protein L12', other_designations='', map_location='2 B', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=32961712, end_position_on_the_genomic_accession=32964045, orientation='plus', exon_count=7, OMIM='', no_hdr0=''),
  102636497 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102636497, CurrentID=0, Status='live', Symbol='Gm29258', Aliases='', description='predicted gene 29258', other_designations='', map_location='7', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=39307434, end_position_on_the_genomic_accession=39317627, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  102636501 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102636501, CurrentID=0, Status='live', Symbol='Gm28961', Aliases='', description='predicted gene 28961', other_designations='', map_location='Y', chromosome='Y', genomic_nucleotide_accession_version='NC_000087.7', start_position_on_the_genomic_accession=57705680, end_position_on_the_genomic_accession=57731917, orientation='plus', exon_count=13, OMIM='', no_hdr0=''),
  102636502 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102636502, CurrentID=0, Status='live', Symbol='Gm21790', Aliases='', description='predicted gene, 21790', other_designations='', map_location='Y', chromosome='Y', genomic_nucleotide_accession_version='NC_000087.7', start_position_on_the_genomic_accession=82019238, end_position_on_the_genomic_accession=82019921, orientation='minus', exon_count=1, OMIM='', no_hdr0=''),
  269275 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=269275, CurrentID=0, Status='live', Symbol='Acvr1c', Aliases='ACVRLK7, ALK7, Alk-7, C230097P10', description='activin A receptor, type IC', other_designations='ACTR-IC|activin receptor type IC|activin receptor-like kinase 7|acvr1c', map_location='2 C1.1', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=58267453, end_position_on_the_genomic_accession=58357896, orientation='minus', exon_count=11, OMIM='', no_hdr0=''),
  102636509 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102636509, CurrentID=0, Status='live', Symbol='Gm21754', Aliases='', description='predicted gene, 21754', other_designations='', map_location='14', chromosome='14', genomic_nucleotide_accession_version='NC_000080.6', start_position_on_the_genomic_accession=42499749, end_position_on_the_genomic_accession=42502219, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  241489 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=241489, CurrentID=0, Status='live', Symbol='Pde11a', Aliases='6330414F14Rik, A630086N24Rik, Gm350, PDE11A1', description='phosphodiesterase 11A', other_designations='cAMP and cGMP phosphodiesterase 11A', map_location='2 C3', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=75987026, end_position_on_the_genomic_accession=76339145, orientation='minus', exon_count=21, OMIM='', no_hdr0=''),
  110418 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=110418, CurrentID=0, Status='live', Symbol='Dxcp3', Aliases='Dcp3', description='dexamethasone induced cleft palate 3', other_designations='', map_location='', chromosome='17', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  269295 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=269295, CurrentID=0, Status='live', Symbol='Rtn4rl2', Aliases='Ngr2, Ngrh1, Ngrl3', description='reticulon 4 receptor-like 2', other_designations='nogo receptor-like 3|nogo-66 receptor homolog 1|nogo-66 receptor-related protein 2|rtn4rl2', map_location='2 D', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=84871309, end_position_on_the_genomic_accession=84888507, orientation='minus', exon_count=8, OMIM='', no_hdr0=''),
  102636530 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102636530, CurrentID=0, Status='live', Symbol='LOC102636530', Aliases='', description='ubiquitin-like protein 5', other_designations='', map_location='', chromosome='12', genomic_nucleotide_accession_version='NC_000078.6', start_position_on_the_genomic_accession=88124666, end_position_on_the_genomic_accession=88124935, orientation='plus', exon_count=1, OMIM='', no_hdr0=''),
  102636532 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102636532, CurrentID=0, Status='live', Symbol='Gm33571', Aliases='', description='predicted gene, 33571', other_designations='', map_location='Y', chromosome='Y', genomic_nucleotide_accession_version='NC_000087.7', start_position_on_the_genomic_accession=26241053, end_position_on_the_genomic_accession=26260149, orientation='minus', exon_count=8, OMIM='', no_hdr0=''),
  102636554 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102636554, CurrentID=0, Status='live', Symbol='Gm33589', Aliases='', description='predicted gene, 33589', other_designations='', map_location='1', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=58994769, end_position_on_the_genomic_accession=59022925, orientation='minus', exon_count=7, OMIM='', no_hdr0=''),
  102636558 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102636558, CurrentID=0, Status='live', Symbol='LOC102636558', Aliases='', description='component of Sp100-rs-like', other_designations='', map_location='', chromosome='1', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  269328 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=269328, CurrentID=0, Status='live', Symbol='Muc15', Aliases='4732460E09, D730046L02Rik, MUC-15', description='mucin 15', other_designations='', map_location='2 E3', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=110721494, end_position_on_the_genomic_accession=110739537, orientation='plus', exon_count=4, OMIM='', no_hdr0=''),
  102636566 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102636566, CurrentID=0, Status='live', Symbol='Gm10103', Aliases='EG383232, ENSMUSG00000061532', description='predicted gene 10103', other_designations='zinc finger protein 564-like', map_location='17 B1', chromosome='17', genomic_nucleotide_accession_version='NC_000083.6', start_position_on_the_genomic_accession=33144149, end_position_on_the_genomic_accession=33149964, orientation='plus', exon_count=3, OMIM='', no_hdr0=''),
  269336 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=269336, CurrentID=0, Status='live', Symbol='Ccdc32', Aliases='Gm631', description='coiled-coil domain containing 32', other_designations='', map_location='2 E5', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=119017779, end_position_on_the_genomic_accession=119029406, orientation='minus', exon_count=4, OMIM='', no_hdr0=''),
  269338 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=269338, CurrentID=0, Status='live', Symbol='Vps39', Aliases='A230065P22Rik, AW743070, Vam6, Vam6P, mVam6', description='vacuolar protein sorting 39 (yeast)', other_designations='', map_location='2 E5', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=120316461, end_position_on_the_genomic_accession=120353144, orientation='minus', exon_count=27, OMIM='', no_hdr0=''),
  269344 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=269344, CurrentID=0, Status='live', Symbol='Ell3', Aliases='A930015D22Rik', description='elongation factor RNA polymerase II-like 3', other_designations='', map_location='2 E5', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=121439025, end_position_on_the_genomic_accession=121444278, orientation='minus', exon_count=12, OMIM='', no_hdr0=''),
  269346 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=269346, CurrentID=0, Status='live', Symbol='Slc28a2', Aliases='2010208B10Rik, B430217P18, BB152493, Cnt2', description='solute carrier family 28 (sodium-coupled nucleoside transporter), member 2', other_designations='CNT 2|Na(+)/nucleoside cotransporter 2|SPNT|concentrative nucleoside transporter 2|purine-selective Na+ nucleoside cotransporter|sodium-coupled nucleoside transporter 2|sodium/purine nucleoside cotransporter|solute carrier family 28 member 2', map_location='2 E3', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=122426355, end_position_on_the_genomic_accession=122461152, orientation='plus', exon_count=19, OMIM='', no_hdr0=''),
  102636579 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102636579, CurrentID=0, Status='live', Symbol='Gm10298', Aliases='ENSMUSG00000070606', description='predicted gene 10298', other_designations='', map_location='7 28.25 cM', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=43387665, end_position_on_the_genomic_accession=43394383, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  269356 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=269356, CurrentID=0, Status='live', Symbol='Slc4a11', Aliases='AI503023, BTR1, NaBC1', description='solute carrier family 4, sodium bicarbonate transporter-like, member 11', other_designations='Sodium borate cotransporter 1|Solute carrier family 4 member 11|bicarbonate transporter-related protein 1', map_location='2 F1', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=130684107, end_position_on_the_genomic_accession=130697519, orientation='minus', exon_count=21, OMIM='', no_hdr0=''),
  102636596 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102636596, CurrentID=0, Status='live', Symbol='Gm33615', Aliases='', description='predicted gene, 33615', other_designations='', map_location='9', chromosome='9', genomic_nucleotide_accession_version='NC_000075.6', start_position_on_the_genomic_accession=74952085, end_position_on_the_genomic_accession=74953206, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  269378 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=269378, CurrentID=0, Status='live', Symbol='Ahcy', Aliases='AA987153, AL024110, CuBP, SAHH', description='S-adenosylhomocysteine hydrolase', other_designations='S-adenosyl-L-homocysteine hydrolase|adoHcyase|liver copper-binding protein', map_location='2 76.94 cM', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=155059310, end_position_on_the_genomic_accession=155074497, orientation='minus', exon_count=10, OMIM='', no_hdr0=''),
  102636616 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102636616, CurrentID=0, Status='live', Symbol='Gm20904', Aliases='', description='predicted gene, 20904', other_designations='', map_location='Y', chromosome='Y', genomic_nucleotide_accession_version='NC_000087.7', start_position_on_the_genomic_accession=76060916, end_position_on_the_genomic_accession=76063264, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  102636617 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102636617, CurrentID=0, Status='live', Symbol='Gm21782', Aliases='', description='predicted gene, 21782', other_designations='', map_location='Y', chromosome='Y', genomic_nucleotide_accession_version='NC_000087.7', start_position_on_the_genomic_accession=84489097, end_position_on_the_genomic_accession=84565023, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  269389 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=269389, CurrentID=0, Status='live', Symbol='Tox2', Aliases='AI851523, AV026525, BI987407, Gcx1, RxHMG1', description='TOX high mobility group box family member 2', other_designations='granulosa cell HMG-box protein 1', map_location='2', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=163202643, end_position_on_the_genomic_accession=163323102, orientation='plus', exon_count=13, OMIM='', no_hdr0=''),
  269397 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=269397, CurrentID=0, Status='live', Symbol='Ss18l1', Aliases='A230053O16Rik, CREST', description='synovial sarcoma translocation gene on chromosome 18-like 1', other_designations='SS18-like protein 1', map_location='2 H4', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=180042483, end_position_on_the_genomic_accession=180070201, orientation='plus', exon_count=12, OMIM='', no_hdr0=''),
  102636631 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102636631, CurrentID=0, Status='live', Symbol='Gm38490', Aliases='', description='predicted gene, 38490', other_designations='', map_location='16', chromosome='16', genomic_nucleotide_accession_version='NC_000082.6', start_position_on_the_genomic_accession=89092134, end_position_on_the_genomic_accession=89092349, orientation='plus', exon_count=1, OMIM='', no_hdr0=''),
  269400 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=269400, CurrentID=0, Status='live', Symbol='Rtel1', Aliases='AI451565, AW540478, Rtel', description='regulator of telomere elongation helicase 1', other_designations='DEAH helicase|regulator of telomere length', map_location='2 H4', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=181288028, end_position_on_the_genomic_accession=181356616, orientation='plus', exon_count=39, OMIM='', no_hdr0=''),
  269401 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=269401, CurrentID=0, Status='live', Symbol='Zfp512b', Aliases='Gm632, Znf512b', description='zinc finger protein 512B', other_designations='', map_location='2 H4', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=181582103, end_position_on_the_genomic_accession=181592798, orientation='minus', exon_count=17, OMIM='', no_hdr0=''),
  269423 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=269423, CurrentID=0, Status='live', Symbol='Abhd18', Aliases='2310068E01Rik, 3110057O12Rik, AI645591', description='abhydrolase domain containing 18', other_designations='', map_location='3 C', chromosome='3', genomic_nucleotide_accession_version='NC_000069.6', start_position_on_the_genomic_accession=40894249, end_position_on_the_genomic_accession=40937738, orientation='plus', exon_count=14, OMIM='', no_hdr0=''),
  269424 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=269424, CurrentID=0, Status='live', Symbol='Jade1', Aliases='AU041499, D530048A03Rik, Phf17, mKIAA1807', description='jade family PHD finger 1', other_designations='Jade1 PHD finger protein|PHD finger protein 17|jade family PHD finger protein 1', map_location='3 B', chromosome='3', genomic_nucleotide_accession_version='NC_000069.6', start_position_on_the_genomic_accession=41555734, end_position_on_the_genomic_accession=41616864, orientation='plus', exon_count=15, OMIM='', no_hdr0=''),
  102636667 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102636667, CurrentID=0, Status='live', Symbol='Gm33670', Aliases='', description='predicted gene, 33670', other_designations='', map_location='17', chromosome='17', genomic_nucleotide_accession_version='NC_000083.6', start_position_on_the_genomic_accession=34122130, end_position_on_the_genomic_accession=34127918, orientation='plus', exon_count=3, OMIM='', no_hdr0=''),
  269437 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=269437, CurrentID=0, Status='live', Symbol='Plch1', Aliases='BC042549, PLC-eta-1, PLCeta1, Plcl3', description='phospholipase C, eta 1', other_designations='phosphoinositide phospholipase C-eta-1|phospholipase C-like protein 3', map_location='3 E1', chromosome='3', genomic_nucleotide_accession_version='NC_000069.6', start_position_on_the_genomic_accession=63696232, end_position_on_the_genomic_accession=63899677, orientation='minus', exon_count=32, OMIM='', no_hdr0=''),
  110443 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=110443, CurrentID=0, Status='live', Symbol='31.MMHAP64FLC4', Aliases='ESTM57', description='DNA segment, 31.MMHAP64FLC4', other_designations='', map_location='', chromosome='16', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  102636690 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102636690, CurrentID=0, Status='live', Symbol='Gm33691', Aliases='', description='predicted gene, 33691', other_designations='', map_location='8', chromosome='8', genomic_nucleotide_accession_version='NC_000074.6', start_position_on_the_genomic_accession=13068774, end_position_on_the_genomic_accession=13071080, orientation='plus', exon_count=3, OMIM='', no_hdr0=''),
  102636698 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102636698, CurrentID=0, Status='live', Symbol='Gm33698', Aliases='', description='predicted gene, 33698', other_designations='', map_location='9', chromosome='9', genomic_nucleotide_accession_version='NC_000075.6', start_position_on_the_genomic_accession=15134581, end_position_on_the_genomic_accession=15138976, orientation='minus', exon_count=4, OMIM='', no_hdr0=''),
  102636701 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102636701, CurrentID=0, Status='live', Symbol='Gm33700', Aliases='', description='predicted gene, 33700', other_designations='', map_location='9', chromosome='9', genomic_nucleotide_accession_version='NC_000075.6', start_position_on_the_genomic_accession=98888085, end_position_on_the_genomic_accession=98889043, orientation='plus', exon_count=1, OMIM='', no_hdr0=''),
  269470 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=269470, CurrentID=0, Status='live', Symbol='Wdr3', Aliases='AW546279, D030020G18Rik', description='WD repeat domain 3', other_designations='', map_location='3 F2.2', chromosome='3', genomic_nucleotide_accession_version='NC_000069.6', start_position_on_the_genomic_accession=100138180, end_position_on_the_genomic_accession=100162403, orientation='minus', exon_count=27, OMIM='', no_hdr0=''),
  269473 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=269473, CurrentID=0, Status='live', Symbol='Lrig2', Aliases='4632419I10Rik, BB096938, LIG-2', description='leucine-rich repeats and immunoglobulin-like domains 2', other_designations='', map_location='3 F2.2', chromosome='3', genomic_nucleotide_accession_version='NC_000069.6', start_position_on_the_genomic_accession=104453980, end_position_on_the_genomic_accession=104511938, orientation='minus', exon_count=19, OMIM='', no_hdr0=''),
  102636718 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102636718, CurrentID=0, Status='live', Symbol='Gm29062', Aliases='', description='predicted gene 29062', other_designations='', map_location='Y', chromosome='Y', genomic_nucleotide_accession_version='NC_000087.7', start_position_on_the_genomic_accession=63834022, end_position_on_the_genomic_accession=63834597, orientation='minus', exon_count=1, OMIM='', no_hdr0=''),
  241525 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=241525, CurrentID=0, Status='live', Symbol='Ypel4', Aliases='', description='yippee-like 4 (Drosophila)', other_designations='', map_location='2 D', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=84733742, end_position_on_the_genomic_accession=84738655, orientation='plus', exon_count=6, OMIM='', no_hdr0=''),
  102636736 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102636736, CurrentID=0, Status='live', Symbol='Gm33726', Aliases='', description='predicted gene, 33726', other_designations='', map_location='16', chromosome='16', genomic_nucleotide_accession_version='NC_000082.6', start_position_on_the_genomic_accession=89106497, end_position_on_the_genomic_accession=89106661, orientation='minus', exon_count=1, OMIM='', no_hdr0=''),
  269513 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=269513, CurrentID=0, Status='live', Symbol='Nkain3', Aliases='C530048M05, E130310K16Rik', description='Na+/K+ transporting ATPase interacting 3', other_designations='Na(+)/K(+)-transporting ATPase subunit beta-1-interacting protein 3', map_location='4 A3', chromosome='4', genomic_nucleotide_accession_version='NC_000070.6', start_position_on_the_genomic_accession=20118336, end_position_on_the_genomic_accession=20780310, orientation='minus', exon_count=9, OMIM='', no_hdr0=''),
  269514 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=269514, CurrentID=0, Status='live', Symbol='Fbxl4', Aliases='AI836810, FBL4, FBL5', description='F-box and leucine-rich repeat protein 4', other_designations='', map_location='4 A3', chromosome='4', genomic_nucleotide_accession_version='NC_000070.6', start_position_on_the_genomic_accession=22357543, end_position_on_the_genomic_accession=22434091, orientation='plus', exon_count=12, OMIM='', no_hdr0=''),
  102636748 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102636748, CurrentID=0, Status='live', Symbol='Gm28171', Aliases='', description='predicted gene 28171', other_designations='', map_location='Y', chromosome='Y', genomic_nucleotide_accession_version='NC_000087.7', start_position_on_the_genomic_accession=5725849, end_position_on_the_genomic_accession=5795592, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  110456 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=110456, CurrentID=0, Status='live', Symbol='20.MMHAP88FLG2', Aliases='ESTM56', description='DNA segment, 20.MMHAP88FLG2', other_designations='', map_location='', chromosome='16', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  269523 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=269523, CurrentID=0, Status='live', Symbol='Vcp', Aliases='3110001E05, CDC48, p97, p97/VCP', description='valosin containing protein', other_designations='15S Mg(2+)-ATPase p97 subunit|AAA ATPase p97|Inv protein|TER ATPase|homolog of yeast cdc48|valosin-containing protein', map_location='4 22.95 cM', chromosome='4', genomic_nucleotide_accession_version='NC_000070.6', start_position_on_the_genomic_accession=42979964, end_position_on_the_genomic_accession=43000507, orientation='minus', exon_count=17, OMIM='', no_hdr0=''),
  102636758 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102636758, CurrentID=0, Status='live', Symbol='Gm33740', Aliases='', description='predicted gene, 33740', other_designations='', map_location='6', chromosome='6', genomic_nucleotide_accession_version='NC_000072.6', start_position_on_the_genomic_accession=86604762, end_position_on_the_genomic_accession=86627858, orientation='plus', exon_count=6, OMIM='', no_hdr0=''),
  269529 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=269529, CurrentID=0, Status='live', Symbol='Fbxo10', Aliases='FBX10, Gm634', description='F-box protein 10', other_designations='', map_location='4 B1', chromosome='4', genomic_nucleotide_accession_version='NC_000070.6', start_position_on_the_genomic_accession=45034248, end_position_on_the_genomic_accession=45084604, orientation='minus', exon_count=11, OMIM='', no_hdr0=''),
  102636763 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102636763, CurrentID=0, Status='live', Symbol='Gm33745', Aliases='', description='predicted gene, 33745', other_designations='', map_location='15', chromosome='15', genomic_nucleotide_accession_version='NC_000081.6', start_position_on_the_genomic_accession=100844194, end_position_on_the_genomic_accession=100851551, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  269536 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=269536, CurrentID=0, Status='live', Symbol='Tex10', Aliases='2610206N19Rik, 2810462N03Rik, BC006867', description='testis expressed gene 10', other_designations='clone 18330', map_location='4 B1', chromosome='4', genomic_nucleotide_accession_version='NC_000070.6', start_position_on_the_genomic_accession=48430858, end_position_on_the_genomic_accession=48473464, orientation='minus', exon_count=17, OMIM='', no_hdr0=''),
  102636769 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102636769, CurrentID=0, Status='live', Symbol='Gm33749', Aliases='', description='predicted gene, 33749', other_designations='', map_location='2', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=25644144, end_position_on_the_genomic_accession=25648801, orientation='plus', exon_count=3, OMIM='', no_hdr0=''),
  102636792 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102636792, CurrentID=0, Status='live', Symbol='LOC102636792', Aliases='', description='uncharacterized LOC102636792', other_designations='', map_location='', chromosome='14', genomic_nucleotide_accession_version='NC_000080.6', start_position_on_the_genomic_accession=5480536, end_position_on_the_genomic_accession=5492264, orientation='plus', exon_count=6, OMIM='', no_hdr0=''),
  102636807 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102636807, CurrentID=0, Status='live', Symbol='Gm33778', Aliases='', description='predicted gene, 33778', other_designations='', map_location='9', chromosome='9', genomic_nucleotide_accession_version='NC_000075.6', start_position_on_the_genomic_accession=98918782, end_position_on_the_genomic_accession=98919682, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  269582 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=269582, CurrentID=0, Status='live', Symbol='Clspn', Aliases='B130025E01, C85083, E130314M08Rik', description='claspin', other_designations='claspin homolog', map_location='4 D2.2', chromosome='4', genomic_nucleotide_accession_version='NC_000070.6', start_position_on_the_genomic_accession=126556951, end_position_on_the_genomic_accession=126594533, orientation='plus', exon_count=26, OMIM='', no_hdr0=''),
  269585 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=269585, CurrentID=0, Status='live', Symbol='Zscan20', Aliases='C130001F22, Zfp31, Zkscan20', description='zinc finger and SCAN domains 20', other_designations='zinc finger protein 31|zinc finger with KRAB and SCAN domains 20', map_location='4 D2.2', chromosome='4', genomic_nucleotide_accession_version='NC_000070.6', start_position_on_the_genomic_accession=128578670, end_position_on_the_genomic_accession=128610172, orientation='minus', exon_count=12, OMIM='', no_hdr0=''),
  269587 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=269587, CurrentID=0, Status='live', Symbol='Epb41', Aliases='4.1R, AI415518, D4Ertd442e, Elp-1, Elp1, Epb4.1, mKIAA4056', description='erythrocyte membrane protein band 4.1', other_designations='P4.1|Protein 4.1R|band 4.1|erythrocyte protein band 4.1', map_location='4 64.54 cM', chromosome='4', genomic_nucleotide_accession_version='NC_000070.6', start_position_on_the_genomic_accession=131923413, end_position_on_the_genomic_accession=132075579, orientation='minus', exon_count=26, OMIM='', no_hdr0=''),
  269589 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=269589, CurrentID=0, Status='live', Symbol='Sytl1', Aliases='9030417L18, PSGL-1, Slp1', description='synaptotagmin-like 1', other_designations='exophilin-7', map_location='4 D2.3', chromosome='4', genomic_nucleotide_accession_version='NC_000070.6', start_position_on_the_genomic_accession=133253090, end_position_on_the_genomic_accession=133263087, orientation='minus', exon_count=16, OMIM='', no_hdr0=''),
  102636822 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102636822, CurrentID=0, Status='live', Symbol='Gm28219', Aliases='', description='predicted gene 28219', other_designations='', map_location='Y', chromosome='Y', genomic_nucleotide_accession_version='NC_000087.7', start_position_on_the_genomic_accession=86148232, end_position_on_the_genomic_accession=86148795, orientation='minus', exon_count=1, OMIM='', no_hdr0=''),
  269593 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=269593, CurrentID=0, Status='live', Symbol='Luzp1', Aliases='2700072H04Rik, AI266952, Luzp, mFLJ00226', description='leucine zipper protein 1', other_designations='leucine zipper motif-containing protein', map_location='4 68.8 cM', chromosome='4', genomic_nucleotide_accession_version='NC_000070.6', start_position_on_the_genomic_accession=136469749, end_position_on_the_genomic_accession=136554725, orientation='plus', exon_count=7, OMIM='', no_hdr0=''),
  102636827 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102636827, CurrentID=0, Status='live', Symbol='Gm33789', Aliases='', description='predicted gene, 33789', other_designations='', map_location='8', chromosome='8', genomic_nucleotide_accession_version='NC_000074.6', start_position_on_the_genomic_accession=108700523, end_position_on_the_genomic_accession=108715114, orientation='minus', exon_count=4, OMIM='', no_hdr0=''),
  102636835 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102636835, CurrentID=0, Status='live', Symbol='Gm33795', Aliases='', description='predicted gene, 33795', other_designations='', map_location='1', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=51915458, end_position_on_the_genomic_accession=51916854, orientation='plus', exon_count=3, OMIM='', no_hdr0=''),
  269604 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=269604, CurrentID=0, Status='live', Symbol='Gpr157', Aliases='F730108M23Rik', description='G protein-coupled receptor 157', other_designations='novel 7 transmembrane receptor (Secretin family) domain containing protein', map_location='4 E2', chromosome='4', genomic_nucleotide_accession_version='NC_000070.6', start_position_on_the_genomic_accession=150087503, end_position_on_the_genomic_accession=150105927, orientation='plus', exon_count=4, OMIM='', no_hdr0=''),
  102636839 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102636839, CurrentID=0, Status='live', Symbol='Gm33798', Aliases='', description='predicted gene, 33798', other_designations='', map_location='16', chromosome='16', genomic_nucleotide_accession_version='NC_000082.6', start_position_on_the_genomic_accession=89122324, end_position_on_the_genomic_accession=89122479, orientation='minus', exon_count=1, OMIM='', no_hdr0=''),
  269608 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=269608, CurrentID=0, Status='live', Symbol='Plekhg5', Aliases='BC023181, Syx', description='pleckstrin homology domain containing, family G (with RhoGef domain) member 5', other_designations='PH domain-containing family G member 5|RhoA-specific guanine exchange factor SYX1|RhoA-specific guanine exchange factor SYX2|synectin-binding RhoA exchange factor', map_location='4 E2', chromosome='4', genomic_nucleotide_accession_version='NC_000070.6', start_position_on_the_genomic_accession=152072433, end_position_on_the_genomic_accession=152115404, orientation='plus', exon_count=25, OMIM='', no_hdr0=''),
  269610 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=269610, CurrentID=0, Status='live', Symbol='Chd5', Aliases='4930532L22Rik, AW060752, B230399N07Rik, CHD-5', description='chromodomain helicase DNA binding protein 5', other_designations='ATP-dependent helicase CHD5', map_location='4 E2', chromosome='4', genomic_nucleotide_accession_version='NC_000070.6', start_position_on_the_genomic_accession=152338651, end_position_on_the_genomic_accession=152390194, orientation='plus', exon_count=42, OMIM='', no_hdr0=''),
  269614 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=269614, CurrentID=0, Status='live', Symbol='Pank4', Aliases='D030031I12Rik, R75150', description='pantothenate kinase 4', other_designations='pantothenic acid kinase 4', map_location='4 E2', chromosome='4', genomic_nucleotide_accession_version='NC_000070.6', start_position_on_the_genomic_accession=154963948, end_position_on_the_genomic_accession=154980938, orientation='plus', exon_count=19, OMIM='', no_hdr0=''),
  269615 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=269615, CurrentID=0, Status='live', Symbol='Plch2', Aliases='A930027K05Rik, PLCeta2, Plc-eta2, Plcl4', description='phospholipase C, eta 2', other_designations='phosphoinositide phospholipase C-eta-2|phosphoinositide phospholipase C-like 4|phospholipase C-like protein 4', map_location='4 E2', chromosome='4', genomic_nucleotide_accession_version='NC_000070.6', start_position_on_the_genomic_accession=154983115, end_position_on_the_genomic_accession=155064091, orientation='minus', exon_count=30, OMIM='', no_hdr0=''),
  269623 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=269623, CurrentID=0, Status='live', Symbol='Rbm48', Aliases='AW548102, C030048B08Rik', description='RNA binding motif protein 48', other_designations='UPF0712 protein C7orf64 homolog', map_location='5 A1', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=3583978, end_position_on_the_genomic_accession=3596547, orientation='minus', exon_count=5, OMIM='', no_hdr0=''),
  269629 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=269629, CurrentID=0, Status='live', Symbol='Lhfpl3', Aliases='A930031L14Rik', description='lipoma HMGIC fusion partner-like 3', other_designations='', map_location='5 A3', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=22745636, end_position_on_the_genomic_accession=23275597, orientation='plus', exon_count=4, OMIM='', no_hdr0=''),
  269633 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=269633, CurrentID=0, Status='live', Symbol='Wdr86', Aliases='2810046M22Rik, BC059069', description='WD repeat domain 86', other_designations='', map_location='5 A3', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=24704229, end_position_on_the_genomic_accession=24730698, orientation='minus', exon_count=9, OMIM='', no_hdr0=''),
  503691 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=503691, CurrentID=0, Status='live', Symbol='A030001O10Rik', Aliases='', description='RIKEN cDNA A030001O10 gene', other_designations='', map_location='', chromosome='1', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  269637 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=269637, CurrentID=0, Status='live', Symbol='Cnpy1', Aliases='1500012D20Rik, 9630008K15Rik, AI853839', description='canopy FGF signaling regulator 1', other_designations='canopy 1 homolog', map_location='5 B1', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=28200826, end_position_on_the_genomic_accession=28237873, orientation='minus', exon_count=4, OMIM='', no_hdr0=''),
  269639 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=269639, CurrentID=0, Status='live', Symbol='Zfp512', Aliases='2500002M11Rik, AI450173, D230008H22, Znf512', description='zinc finger protein 512', other_designations='', map_location='5 B1', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=31452416, end_position_on_the_genomic_accession=31481754, orientation='plus', exon_count=15, OMIM='', no_hdr0=''),
  102636873 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102636873, CurrentID=0, Status='live', Symbol='LOC102636873', Aliases='', description='disks large homolog 5-like', other_designations='', map_location='', chromosome='14', genomic_nucleotide_accession_version='NC_000080.6', start_position_on_the_genomic_accession=44583163, end_position_on_the_genomic_accession=44588426, orientation='plus', exon_count=6, OMIM='', no_hdr0=''),
  269642 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=269642, CurrentID=0, Status='live', Symbol='Nat8l', Aliases='1110038O08Rik, Shati', description='N-acetyltransferase 8-like', other_designations='N-acetyltransferase 8-like protein|NAA synthetase|protein Shati', map_location='5 B2', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=33995984, end_position_on_the_genomic_accession=34005916, orientation='plus', exon_count=3, OMIM='', no_hdr0=''),
  269643 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=269643, CurrentID=0, Status='live', Symbol='Ppp2r2c', Aliases='6330548O06Rik, IMYPNO, IMYPNO1, PR52', description='protein phosphatase 2, regulatory subunit B, gamma', other_designations='PP2A subunit B isoform B55-gamma|PP2A subunit B isoform PR55-gamma|PP2A subunit B isoform R2-gamma|PP2A subunit B isoform gamma|protein phosphatase 2 (formerly 2A), regulatory subunit B (PR 52), gamma isoform', map_location='5 B3', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=36866843, end_position_on_the_genomic_accession=36955078, orientation='plus', exon_count=11, OMIM='', no_hdr0=''),
  102636907 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102636907, CurrentID=0, Status='live', Symbol='LOC102636907', Aliases='', description='putative uncharacterized protein ZNRD1-AS1 homolog', other_designations='', map_location='', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=130519656, end_position_on_the_genomic_accession=130530816, orientation='plus', exon_count=7, OMIM='', no_hdr0=''),
  102636909 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102636909, CurrentID=0, Status='live', Symbol='Gm33851', Aliases='', description='predicted gene, 33851', other_designations='', map_location='11', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=102295068, end_position_on_the_genomic_accession=102297917, orientation='plus', exon_count=4, OMIM='', no_hdr0=''),
  269682 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=269682, CurrentID=0, Status='live', Symbol='Golga3', Aliases='5330413L04, 5430416E01Rik, AI449376, AW490576, G1-499-14, Mea-2, Mea2, repro27', description='golgi autoantigen, golgin subfamily a, 3', other_designations='Mea2/Golga3|golgin-160|male-enhanced antigen 2', map_location='5 53.36 cM', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=110176659, end_position_on_the_genomic_accession=110226470, orientation='plus', exon_count=25, OMIM='', no_hdr0=''),
  269693 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=269693, CurrentID=0, Status='live', Symbol='Ccdc60', Aliases='AU018954, C130098D09', description='coiled-coil domain containing 60', other_designations='', map_location='5 F', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=116125581, end_position_on_the_genomic_accession=116288998, orientation='minus', exon_count=15, OMIM='', no_hdr0=''),
  269695 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=269695, CurrentID=0, Status='live', Symbol='Rnft2', Aliases='AW049082, B830028P19Rik, Tmem118', description='ring finger protein, transmembrane 2', other_designations='transmembrane protein 118', map_location='5 F', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=118190734, end_position_on_the_genomic_accession=118245111, orientation='minus', exon_count=15, OMIM='', no_hdr0=''),
  269700 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=269700, CurrentID=0, Status='live', Symbol='Gm15800', Aliases='A130010L24, AU042671, BC019639, EG545802, OTTMUSG00000026283, mKIAA0614', description='predicted gene 15800', other_designations='', map_location='5 F', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=121219339, end_position_on_the_genomic_accession=121368577, orientation='plus', exon_count=78, OMIM='', no_hdr0=''),
  269701 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=269701, CurrentID=0, Status='live', Symbol='Wdr66', Aliases='4930415N18Rik, 4933428F06Rik, 5031404N07', description='WD repeat domain 66', other_designations='', map_location='5 F', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=123254560, end_position_on_the_genomic_accession=123327484, orientation='plus', exon_count=21, OMIM='', no_hdr0=''),
  269702 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=269702, CurrentID=0, Status='live', Symbol='Mphosph9', Aliases='4930548D04Rik, 9630025B04Rik, AW413446, AW547060, B930097C17Rik, C87456, MPP-9, MPP9', description='M-phase phosphoprotein 9', other_designations='', map_location='5 F', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=124250959, end_position_on_the_genomic_accession=124330759, orientation='minus', exon_count=27, OMIM='', no_hdr0=''),
  269704 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=269704, CurrentID=0, Status='live', Symbol='Zfp664', Aliases='AW060232, D930038J03Rik, ZFOC1, Znf664', description='zinc finger protein 664', other_designations='zinc finger protein ZFOC1', map_location='5 F', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=124862705, end_position_on_the_genomic_accession=124888630, orientation='plus', exon_count=4, OMIM='', no_hdr0=''),
  102636938 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102636938, CurrentID=0, Status='live', Symbol='Gm21796', Aliases='', description='predicted gene, 21796', other_designations='', map_location='Y', chromosome='Y', genomic_nucleotide_accession_version='NC_000087.7', start_position_on_the_genomic_accession=86499614, end_position_on_the_genomic_accession=86502060, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  269713 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=269713, CurrentID=0, Status='live', Symbol='Clip2', Aliases='B230327O20, CLIP-115, Clip1, Cyln2, WSCR4, mKIAA0291, wbscr4', description='CAP-GLY domain containing linker protein 2', other_designations='cytoplasmic linker protein 1, 115 kDa|cytoplasmic linker protein 2', map_location='5 74.63 cM', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=134489383, end_position_on_the_genomic_accession=134552468, orientation='minus', exon_count=17, OMIM='', no_hdr0=''),
  269717 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=269717, CurrentID=0, Status='live', Symbol='Orai2', Aliases='A730041O15Rik, Tmem142b', description='ORAI calcium release-activated calcium modulator 2', other_designations='calcium release-activated calcium channel 2|transmembrane protein 142B', map_location='5 G2', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=136147459, end_position_on_the_genomic_accession=136170656, orientation='minus', exon_count=5, OMIM='', no_hdr0=''),
  102636950 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102636950, CurrentID=0, Status='live', Symbol='Gm33879', Aliases='', description='predicted gene, 33879', other_designations='', map_location='14', chromosome='14', genomic_nucleotide_accession_version='NC_000080.6', start_position_on_the_genomic_accession=59991059, end_position_on_the_genomic_accession=59995883, orientation='plus', exon_count=5, OMIM='', no_hdr0=''),
  269723 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=269723, CurrentID=0, Status='live', Symbol='BC030343', Aliases='', description='cDNA sequence BC030343', other_designations='', map_location='5 G2', chromosome='5', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  102636963 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102636963, CurrentID=0, Status='live', Symbol='Gm33888', Aliases='', description='predicted gene, 33888', other_designations='', map_location='16', chromosome='16', genomic_nucleotide_accession_version='NC_000082.6', start_position_on_the_genomic_accession=89129257, end_position_on_the_genomic_accession=89133106, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  328945 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=328945, CurrentID=0, Status='live', Symbol='B930099G20', Aliases='', description='uncharacterized protein B930099G20', other_designations='', map_location='18 B3', chromosome='18', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  102636976 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102636976, CurrentID=0, Status='live', Symbol='Gm21719', Aliases='', description='predicted gene, 21719', other_designations='', map_location='Y', chromosome='Y', genomic_nucleotide_accession_version='NC_000087.7', start_position_on_the_genomic_accession=6680551, end_position_on_the_genomic_accession=6681243, orientation='minus', exon_count=1, OMIM='', no_hdr0=''),
  102636981 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102636981, CurrentID=0, Status='live', Symbol='Gm33903', Aliases='', description='predicted gene, 33903', other_designations='', map_location='1', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=153486505, end_position_on_the_genomic_accession=153487526, orientation='plus', exon_count=3, OMIM='', no_hdr0=''),
  102636989 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102636989, CurrentID=0, Status='live', Symbol='LOC102636989', Aliases='', description='actin-like', other_designations='', map_location='', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=143866844, end_position_on_the_genomic_accession=143900060, orientation='plus', exon_count=14, OMIM='', no_hdr0=''),
  66805 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=66805, CurrentID=0, Status='live', Symbol='Tspan1', Aliases='9030418M05Rik', description='tetraspanin 1', other_designations='tetraspan 1|tspan-1', map_location='4 C7', chromosome='4', genomic_nucleotide_accession_version='NC_000070.6', start_position_on_the_genomic_accession=116161881, end_position_on_the_genomic_accession=116167621, orientation='minus', exon_count=8, OMIM='', no_hdr0=''),
  269774 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=269774, CurrentID=0, Status='live', Symbol='Aak1', Aliases='5530400K14Rik, 9630042K20, AU067724, AU067726, BC028270, C79663, D6Ertd245e, R75501, mKIAA1048', description='AP2 associated kinase 1', other_designations='adaptor-associated kinase 1', map_location='6 37.75 cM', chromosome='6', genomic_nucleotide_accession_version='NC_000072.6', start_position_on_the_genomic_accession=86849482, end_position_on_the_genomic_accession=87003227, orientation='plus', exon_count=21, OMIM='', no_hdr0=''),
  102637011 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102637011, CurrentID=0, Status='live', Symbol='Gm33926', Aliases='', description='predicted gene, 33926', other_designations='', map_location='7', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=67428888, end_position_on_the_genomic_accession=67436638, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  102637012 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102637012, CurrentID=0, Status='live', Symbol='LOC102637012', Aliases='', description='immunoglobulin superfamily member 22-like', other_designations='', map_location='7', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=47058069, end_position_on_the_genomic_accession=47075630, orientation='minus', exon_count=22, OMIM='', no_hdr0=''),
  102637013 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102637013, CurrentID=0, Status='live', Symbol='Gm21809', Aliases='', description='predicted gene, 21809', other_designations='', map_location='Y', chromosome='Y', genomic_nucleotide_accession_version='NC_000087.7', start_position_on_the_genomic_accession=16923140, end_position_on_the_genomic_accession=16924564, orientation='plus', exon_count=1, OMIM='', no_hdr0=''),
  269784 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=269784, CurrentID=0, Status='live', Symbol='Cntn4', Aliases='9630050B05, Axcam, BIG-2', description='contactin 4', other_designations='axonal-associated cell adhesion molecule|brain-derived immunoglobulin superfamily molecule|brain-derived immunoglobulin superfamily protein 2', map_location='6 E2', chromosome='6', genomic_nucleotide_accession_version='NC_000072.6', start_position_on_the_genomic_accession=105677651, end_position_on_the_genomic_accession=106700141, orientation='plus', exon_count=29, OMIM='', no_hdr0=''),
  269788 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=269788, CurrentID=0, Status='live', Symbol='Lhfpl4', Aliases='1190004M23Rik, AI604880, B230384L07, mKIAA4027', description='lipoma HMGIC fusion partner-like protein 4', other_designations='', map_location='6 E3', chromosome='6', genomic_nucleotide_accession_version='NC_000072.6', start_position_on_the_genomic_accession=113168087, end_position_on_the_genomic_accession=113195384, orientation='minus', exon_count=4, OMIM='', no_hdr0=''),
  269799 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=269799, CurrentID=0, Status='live', Symbol='Clec4a1', Aliases='BC049354, Dcir4', description='C-type lectin domain family 4, member a1', other_designations='dendritic cell inhibitory receptor 4', map_location='6 F2', chromosome='6', genomic_nucleotide_accession_version='NC_000072.6', start_position_on_the_genomic_accession=122921848, end_position_on_the_genomic_accession=122934619, orientation='plus', exon_count=6, OMIM='', no_hdr0=''),
  269800 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=269800, CurrentID=0, Status='live', Symbol='Zfp384', Aliases='BB163993, C130073D16Rik, Ciz, NP, Nmp4', description='zinc finger protein 384', other_designations='nuclear matrix protein 4', map_location='6 F2', chromosome='6', genomic_nucleotide_accession_version='NC_000072.6', start_position_on_the_genomic_accession=125009110, end_position_on_the_genomic_accession=125037870, orientation='plus', exon_count=14, OMIM='', no_hdr0=''),
  102637049 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102637049, CurrentID=0, Status='live', Symbol='Gm38493', Aliases='', description='predicted gene, 38493', other_designations='', map_location='12', chromosome='12', genomic_nucleotide_accession_version='NC_000078.6', start_position_on_the_genomic_accession=99392315, end_position_on_the_genomic_accession=99393803, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  102637051 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102637051, CurrentID=0, Status='live', Symbol='Gm29299', Aliases='', description='predicted gene 29299', other_designations='', map_location='Y', chromosome='Y', genomic_nucleotide_accession_version='NC_000087.7', start_position_on_the_genomic_accession=86603673, end_position_on_the_genomic_accession=86624865, orientation='plus', exon_count=6, OMIM='', no_hdr0=''),
  269823 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=269823, CurrentID=0, Status='live', Symbol='Pon3', Aliases='2810004E20, AI786302', description='paraoxonase 3', other_designations='', map_location='6 1.99 cM', chromosome='6', genomic_nucleotide_accession_version='NC_000072.6', start_position_on_the_genomic_accession=5220852, end_position_on_the_genomic_accession=5256250, orientation='minus', exon_count=10, OMIM='', no_hdr0=''),
  102637056 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102637056, CurrentID=0, Status='live', Symbol='Gm33962', Aliases='', description='predicted gene, 33962', other_designations='', map_location='6', chromosome='6', genomic_nucleotide_accession_version='NC_000072.6', start_position_on_the_genomic_accession=130868405, end_position_on_the_genomic_accession=130888785, orientation='minus', exon_count=6, OMIM='', no_hdr0=''),
  269831 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=269831, CurrentID=0, Status='live', Symbol='Tspan12', Aliases='9030619E17, AI426782, AI663988, AW111457, Tm4sf12', description='tetraspanin 12', other_designations='transmembrane 4 superfamily member 12|tspan-12', map_location='6 A3.1', chromosome='6', genomic_nucleotide_accession_version='NC_000072.6', start_position_on_the_genomic_accession=21771391, end_position_on_the_genomic_accession=21853349, orientation='minus', exon_count=10, OMIM='', no_hdr0=''),
  102637070 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102637070, CurrentID=0, Status='live', Symbol='LOC102637070', Aliases='', description='keratin-associated protein 20-2-like', other_designations='', map_location='', chromosome='16', genomic_nucleotide_accession_version='NC_000082.6', start_position_on_the_genomic_accession=89140944, end_position_on_the_genomic_accession=89141123, orientation='plus', exon_count=1, OMIM='', no_hdr0=''),
  102637083 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102637083, CurrentID=0, Status='live', Symbol='Gm33985', Aliases='', description='predicted gene, 33985', other_designations='', map_location='12', chromosome='12', genomic_nucleotide_accession_version='NC_000078.6', start_position_on_the_genomic_accession=23115687, end_position_on_the_genomic_accession=23150361, orientation='minus', exon_count=5, OMIM='', no_hdr0=''),
  269854 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=269854, CurrentID=0, Status='live', Symbol='Nat14', Aliases='BC047219', description='N-acetyltransferase 14', other_designations='', map_location='7 A1', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=4918888, end_position_on_the_genomic_accession=4925006, orientation='plus', exon_count=5, OMIM='', no_hdr0=''),
  269855 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=269855, CurrentID=0, Status='live', Symbol='Ssc5d', Aliases='A430110N23Rik, S5D-SRCRB', description='scavenger receptor cysteine rich family, 5 domains', other_designations='group B scavenger receptor cysteine-rich domain-containing|scavenger receptor cysteine rich domain containing (5 domains)|scavenger receptor cysteine-rich domain-containing protein LOC284297 homolog', map_location='7 A1', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=4925130, end_position_on_the_genomic_accession=4944828, orientation='plus', exon_count=14, OMIM='', no_hdr0=''),
  102637092 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102637092, CurrentID=0, Status='live', Symbol='Gm21872', Aliases='', description='predicted gene, 21872', other_designations='', map_location='Y', chromosome='Y', genomic_nucleotide_accession_version='NC_000087.7', start_position_on_the_genomic_accession=35567880, end_position_on_the_genomic_accession=35570165, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  269862 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=269862, CurrentID=0, Status='live', Symbol='Olfr1349', Aliases='MOR232-8', description='olfactory receptor 1349', other_designations='GA_x6K02T2QGBW-3245761-3244808|olfactory receptor MOR232-8', map_location='7 A1', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=6514199, end_position_on_the_genomic_accession=6520355, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  102637099 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102637099, CurrentID=0, Status='live', Symbol='Gm38495', Aliases='', description='predicted gene, 38495', other_designations='', map_location='6', chromosome='6', genomic_nucleotide_accession_version='NC_000072.6', start_position_on_the_genomic_accession=86994977, end_position_on_the_genomic_accession=87003227, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  269870 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=269870, CurrentID=0, Status='live', Symbol='Zfp446', Aliases='A630035I11Rik, A930031C22, AA120513, AV306632', description='zinc finger protein 446', other_designations='', map_location='7 A1', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=12976397, end_position_on_the_genomic_accession=12985717, orientation='plus', exon_count=6, OMIM='', no_hdr0=''),
  102637108 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102637108, CurrentID=0, Status='live', Symbol='Gm34003', Aliases='', description='predicted gene, 34003', other_designations='', map_location='2', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=51946163, end_position_on_the_genomic_accession=51948205, orientation='plus', exon_count=5, OMIM='', no_hdr0=''),
  269878 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=269878, CurrentID=0, Status='live', Symbol='Megf8', Aliases='AW049492, Egfl4, b2b1702.2Clo, b2b1702Clo, b2b288Clo, m687Ddg, mKIAA0817', description='multiple EGF-like-domains 8', other_designations='EGF-like protein 4|EGF-like-domain, multiple 4|epidermal growth factor-like protein 4|multiple EGF-like domains protein 8', map_location='7 A3', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=25316742, end_position_on_the_genomic_accession=25365917, orientation='plus', exon_count=41, OMIM='', no_hdr0=''),
  102637111 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102637111, CurrentID=0, Status='live', Symbol='Gm20541', Aliases='', description='predicted gene 20541', other_designations='', map_location='17 19.16 cM', chromosome='17', genomic_nucleotide_accession_version='NC_000083.6', start_position_on_the_genomic_accession=37995869, end_position_on_the_genomic_accession=38013369, orientation='plus', exon_count=5, OMIM='', no_hdr0=''),
  269881 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=269881, CurrentID=0, Status='live', Symbol='Map3k10', Aliases='BC028668, BC046514, MST, Mlk2', description='mitogen-activated protein kinase kinase kinase 10', other_designations='MKN28 derived nonreceptor_type|MKN28 kinase|mixed lineage kinase 2|serine/threonine kinase', map_location='7 A3', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=27656375, end_position_on_the_genomic_accession=27674607, orientation='minus', exon_count=12, OMIM='', no_hdr0=''),
  328971 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=328971, CurrentID=0, Status='live', Symbol='Spink10', Aliases='A230091H23Rik', description='serine peptidase inhibitor, Kazal type 10', other_designations='serine protease inhibitor Kazal type 10', map_location='18 E1', chromosome='18', genomic_nucleotide_accession_version='NC_000084.6', start_position_on_the_genomic_accession=62548911, end_position_on_the_genomic_accession=62662933, orientation='plus', exon_count=13, OMIM='', no_hdr0=''),
  102637124 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102637124, CurrentID=0, Status='live', Symbol='Gm21871', Aliases='', description='predicted gene, 21871', other_designations='', map_location='Y', chromosome='Y', genomic_nucleotide_accession_version='NC_000087.7', start_position_on_the_genomic_accession=22964787, end_position_on_the_genomic_accession=22965485, orientation='plus', exon_count=1, OMIM='', no_hdr0=''),
  102637125 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102637125, CurrentID=0, Status='live', Symbol='Gm28243', Aliases='', description='predicted gene 28243', other_designations='', map_location='Y', chromosome='Y', genomic_nucleotide_accession_version='NC_000087.7', start_position_on_the_genomic_accession=27147667, end_position_on_the_genomic_accession=27157642, orientation='plus', exon_count=5, OMIM='', no_hdr0=''),
  269902 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=269902, CurrentID=0, Status='live', Symbol='Vmn2r57', Aliases='D430014M15, EG269902', description='vomeronasal 2, receptor 57', other_designations='vomeronasal receptor Vmn2r57', map_location='7 B3', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=41399732, end_position_on_the_genomic_accession=41448641, orientation='minus', exon_count=6, OMIM='', no_hdr0=''),
  110521 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=110521, CurrentID=0, Status='live', Symbol='Hivep1', Aliases='Cryabp1', description='human immunodeficiency virus type I enhancer binding protein 1', other_designations='HIV type I enhancer binding protein 1|alpha A-CRYBP1|alpha A-crystallin-binding protein 1|alpha A-crystallin-binding protein I|alphaA-CRYBP1|crystallin, alpha binding protein 1|human immunodeficiency virus type I enhancer-binding protein 1|transcription factor alphaA-CRYBP1', map_location='13 20.72 cM', chromosome='13', genomic_nucleotide_accession_version='NC_000079.6', start_position_on_the_genomic_accession=42051969, end_position_on_the_genomic_accession=42185030, orientation='plus', exon_count=13, OMIM='', no_hdr0=''),
  102637158 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102637158, CurrentID=0, Status='live', Symbol='Gm34042', Aliases='', description='predicted gene, 34042', other_designations='', map_location='4', chromosome='4', genomic_nucleotide_accession_version='NC_000070.6', start_position_on_the_genomic_accession=146925490, end_position_on_the_genomic_accession=146930535, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  102637162 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102637162, CurrentID=0, Status='live', Symbol='Gm34046', Aliases='', description='predicted gene, 34046', other_designations='', map_location='10', chromosome='10', genomic_nucleotide_accession_version='NC_000076.6', start_position_on_the_genomic_accession=96095291, end_position_on_the_genomic_accession=96097858, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  102637163 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102637163, CurrentID=0, Status='live', Symbol='LOC102637163', Aliases='', description='major allergen I polypeptide chain 1-like', other_designations='', map_location='', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=32836570, end_position_on_the_genomic_accession=32837751, orientation='plus', exon_count=3, OMIM='', no_hdr0=''),
  269941 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=269941, CurrentID=0, Status='live', Symbol='Chsy1', Aliases='mKIAA0990', description='chondroitin sulfate synthase 1', other_designations='N-acetylgalactosaminyl-proteoglycan 3-beta-glucuronosyltransferase 1|N-acetylgalactosaminyltransferase 1|carbohydrate (chondroitin) synthase 1|chSy-1|chondroitin glucuronyltransferase 1|chondroitin synthase 1|glucuronosyl-N-acetylgalactosaminyl-proteoglycan 4-beta-N-acetylgalactosaminyltransferase 1', map_location='7 C', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=66109515, end_position_on_the_genomic_accession=66173798, orientation='plus', exon_count=4, OMIM='', no_hdr0=''),
  102637175 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102637175, CurrentID=0, Status='live', Symbol='Gm28368', Aliases='', description='predicted gene 28368', other_designations='', map_location='Y', chromosome='Y', genomic_nucleotide_accession_version='NC_000087.7', start_position_on_the_genomic_accession=87203289, end_position_on_the_genomic_accession=87203864, orientation='minus', exon_count=1, OMIM='', no_hdr0=''),
  269951 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=269951, CurrentID=0, Status='live', Symbol='Idh2', Aliases='E430004F23, IDPm, Idh-2', description='isocitrate dehydrogenase 2 (NADP+), mitochondrial', other_designations='ICD-M|IDH|IDP|NADP(+)-specific ICDH|NADP+-specific isocitrate dehydrogenase|oxalosuccinate decarboxylase', map_location='7 45.43 cM', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=80094846, end_position_on_the_genomic_accession=80115387, orientation='minus', exon_count=12, OMIM='', no_hdr0=''),
  269952 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=269952, CurrentID=0, Status='live', Symbol='Gdpgp1', Aliases='D330012F22Rik', description='GDP-D-glucose phosphorylase 1', other_designations='GDP-D-glucose phosphorylase C15orf58 homolog', map_location='7 D3', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=80232893, end_position_on_the_genomic_accession=80241420, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  269954 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=269954, CurrentID=0, Status='live', Symbol='Ttll13', Aliases='1700111A04Rik, 4921538O11, BC024578', description='tubulin tyrosine ligase-like family, member 13', other_designations='ttll13|tubulin--tyrosine ligase-like protein 13', map_location='7 D3', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=80246376, end_position_on_the_genomic_accession=80260821, orientation='plus', exon_count=17, OMIM='', no_hdr0=''),
  269955 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=269955, CurrentID=0, Status='live', Symbol='Rccd1', Aliases='5830436H09, E430018M08Rik', description='RCC1 domain containing 1', other_designations='', map_location='7 D3', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=80294598, end_position_on_the_genomic_accession=80324696, orientation='minus', exon_count=13, OMIM='', no_hdr0=''),
  102637189 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102637189, CurrentID=0, Status='live', Symbol='Gm34066', Aliases='', description='predicted gene, 34066', other_designations='', map_location='1', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=54442697, end_position_on_the_genomic_accession=54456948, orientation='minus', exon_count=6, OMIM='', no_hdr0=''),
  269959 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=269959, CurrentID=0, Status='live', Symbol='Adamtsl3', Aliases='9230119C12Rik, C130057K09, mKIAA1233', description='ADAMTS-like 3', other_designations='a disintegrin-like and metalloprotease (reprolysin type) with thrombospondin type 1 motif like, 3|punctin-2', map_location='7 D3', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=82335446, end_position_on_the_genomic_accession=82614450, orientation='plus', exon_count=31, OMIM='', no_hdr0=''),
  102637192 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102637192, CurrentID=0, Status='live', Symbol='LOC102637192', Aliases='', description='keratin-associated protein 20-2-like', other_designations='', map_location='', chromosome='16', genomic_nucleotide_accession_version='NC_000082.6', start_position_on_the_genomic_accession=89151139, end_position_on_the_genomic_accession=89151303, orientation='plus', exon_count=1, OMIM='', no_hdr0=''),
  269966 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=269966, CurrentID=0, Status='live', Symbol='Nup98', Aliases='4732457F17, AI849286, Nup96', description='nucleoporin 98', other_designations='', map_location='7 54.71 cM', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=102119400, end_position_on_the_genomic_accession=102210166, orientation='minus', exon_count=34, OMIM='', no_hdr0=''),
  102637210 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102637210, CurrentID=0, Status='live', Symbol='Gm21898', Aliases='', description='predicted gene, 21898', other_designations='', map_location='Y', chromosome='Y', genomic_nucleotide_accession_version='NC_000087.7', start_position_on_the_genomic_accession=36023410, end_position_on_the_genomic_accession=36025880, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  102637223 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102637223, CurrentID=0, Status='live', Symbol='Gm34092', Aliases='', description='predicted gene, 34092', other_designations='', map_location='14', chromosome='14', genomic_nucleotide_accession_version='NC_000080.6', start_position_on_the_genomic_accession=70552131, end_position_on_the_genomic_accession=70554980, orientation='plus', exon_count=3, OMIM='', no_hdr0=''),
  269994 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=269994, CurrentID=0, Status='live', Symbol='Gsg1l', Aliases='AI852434, C230098I05Rik, G630023A01Rik, Gm637, g1l', description='GSG1-like', other_designations='GSG1-like protein', map_location='7 F3', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=125878412, end_position_on_the_genomic_accession=126082772, orientation='minus', exon_count=9, OMIM='', no_hdr0=''),
  269997 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=269997, CurrentID=0, Status='live', Symbol='Zfp747', Aliases='6430604K15Rik', description='zinc finger protein 747', other_designations='', map_location='7 F3', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=127372537, end_position_on_the_genomic_accession=127376050, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  269999 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=269999, CurrentID=0, Status='live', Symbol='Orai3', Aliases='9930124N15, BC061259, Tmem142c', description='ORAI calcium release-activated calcium modulator 3', other_designations='calcium release-activated calcium channel 3|transmembrane protein 142C', map_location='7 F3', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=127769589, end_position_on_the_genomic_accession=127775150, orientation='plus', exon_count=4, OMIM='', no_hdr0=''),
  270004 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=270004, CurrentID=0, Status='live', Symbol='Foxi2', Aliases='B130055A05Rik', description='forkhead box I2', other_designations='foxi2', map_location='7 F3', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=135410367, end_position_on_the_genomic_accession=135413615, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  110537 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=110537, CurrentID=0, Status='live', Symbol='Lfo1', Aliases='Lfo-1, Lvfo-1', description='liver 40-50 thousand Mol. Wt. protein 1', other_designations='', map_location='', chromosome='7', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  102637244 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102637244, CurrentID=0, Status='live', Symbol='Gm13919', Aliases='OTTMUSG00000015064', description='predicted gene 13919', other_designations='', map_location='2 54.13 cM', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=102066174, end_position_on_the_genomic_accession=102067820, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  270014 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=270014, CurrentID=0, Status='live', Symbol='Stk29', Aliases='', description='serine/threonine kinase 29', other_designations='', map_location='7 F5', chromosome='7', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  270028 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=270028, CurrentID=0, Status='live', Symbol='Fam155a', Aliases='6430500D16, AW121567, Tmem28', description='family with sequence similarity 155, member A', other_designations='transmembrane protein 28', map_location='8 A1.1', chromosome='8', genomic_nucleotide_accession_version='NC_000074.6', start_position_on_the_genomic_accession=9206010, end_position_on_the_genomic_accession=9773363, orientation='minus', exon_count=8, OMIM='', no_hdr0=''),
  270035 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=270035, CurrentID=0, Status='live', Symbol='Letm2', Aliases='6030453H13, D030041N04Rik', description='leucine zipper-EF-hand containing transmembrane protein 2', other_designations='LETM1 and EF-hand domain-containing protein 2', map_location='8 A2', chromosome='8', genomic_nucleotide_accession_version='NC_000074.6', start_position_on_the_genomic_accession=25578481, end_position_on_the_genomic_accession=25597899, orientation='minus', exon_count=12, OMIM='', no_hdr0=''),
  102637269 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102637269, CurrentID=0, Status='live', Symbol='LOC102637269', Aliases='', description='protein transport protein Sec61 subunit gamma', other_designations='', map_location='', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=60522767, end_position_on_the_genomic_accession=60523208, orientation='minus', exon_count=1, OMIM='', no_hdr0=''),
  102637277 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102637277, CurrentID=0, Status='live', Symbol='Gm21994', Aliases='', description='predicted gene 21994', other_designations='', map_location='2', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=150254313, end_position_on_the_genomic_accession=150257214, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  270049 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=270049, CurrentID=0, Status='live', Symbol='Galntl6', Aliases='1700021K10Rik, 4930431L04Rik, A830023L05', description='UDP-N-acetyl-alpha-D-galactosamine:polypeptide N-acetylgalactosaminyltransferase-like 6', other_designations='UDP-N-acetyl-alpha-D-galactosamine:polypeptide N-acetylgalactosaminyltransferase 20', map_location='8 B3.1', chromosome='8', genomic_nucleotide_accession_version='NC_000074.6', start_position_on_the_genomic_accession=57772489, end_position_on_the_genomic_accession=58911627, orientation='minus', exon_count=12, OMIM='', no_hdr0=''),
  270058 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=270058, CurrentID=0, Status='live', Symbol='Map1s', Aliases='6430517J16Rik, Bpy2ip1, Map8, Mtap1s, VCY2IP1', description='microtubule-associated protein 1S', other_designations='BPY2 interacting protein 1|BPY2-interacting protein 1|MAP-1S|microtubule-associated protein 8', map_location='8 B3.3', chromosome='8', genomic_nucleotide_accession_version='NC_000074.6', start_position_on_the_genomic_accession=70905957, end_position_on_the_genomic_accession=70930112, orientation='plus', exon_count=8, OMIM='', no_hdr0=''),
  270066 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=270066, CurrentID=0, Status='live', Symbol='Slc35e1', Aliases='6030458H05, AA408278', description='solute carrier family 35, member E1', other_designations='', map_location='8 B3.3', chromosome='8', genomic_nucleotide_accession_version='NC_000074.6', start_position_on_the_genomic_accession=72477995, end_position_on_the_genomic_accession=72492614, orientation='minus', exon_count=6, OMIM='', no_hdr0=''),
  270076 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=270076, CurrentID=0, Status='live', Symbol='Gcdh', Aliases='9030411L18, AI266902, D17825, GCD', description='glutaryl-Coenzyme A dehydrogenase', other_designations='', map_location='8 41.28 cM', chromosome='8', genomic_nucleotide_accession_version='NC_000074.6', start_position_on_the_genomic_accession=84886387, end_position_on_the_genomic_accession=84893921, orientation='minus', exon_count=11, OMIM='', no_hdr0=''),
  241621 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=241621, CurrentID=0, Status='live', Symbol='Gm13981', Aliases='OTTMUSG00000015227', description='predicted gene 13981', other_designations='', map_location='2 E5', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=117055566, end_position_on_the_genomic_accession=117056046, orientation='plus', exon_count=1, OMIM='', no_hdr0=''),
  66859 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=66859, CurrentID=0, Status='live', Symbol='Slc16a9', Aliases='1200003C15Rik, 4930425B13Rik, AI552636', description='solute carrier family 16 (monocarboxylic acid transporters), member 9', other_designations='MCT 9|solute carrier family 16 member 9', map_location='10 B5.3', chromosome='10', genomic_nucleotide_accession_version='NC_000076.6', start_position_on_the_genomic_accession=70245276, end_position_on_the_genomic_accession=70285951, orientation='plus', exon_count=7, OMIM='', no_hdr0=''),
  270084 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=270084, CurrentID=0, Status='live', Symbol='Lpcat2', Aliases='A330042H22, Aytl1, Aytl1a, lpafat1', description='lysophosphatidylcholine acyltransferase 2', other_designations='1-AGP acyltransferase 11|1-AGPAT 11|1-acylglycerol-3-phosphate O-acyltransferase 11|1-acylglycerophosphocholine O-acyltransferase|1-alkylglycerophosphocholine O-acetyltransferase|LPC acyltransferase 2|LPCAT-2|acetyl-CoA:lyso-PAF acetyltransferase|acetyl-CoA:lyso-platelet-activating factor acetyltransferase|acyl-CoA:lysophosphatidylcholine acyltransferase member 1|acyltransferase like 1|acyltransferase like 1A|acyltransferase-like 1|lyso-PAF acetyltransferase|lysoPAFAT|lysoPAFAT/LPCAT2|lysoPC acyltransferase 2', map_location='8 C5', chromosome='8', genomic_nucleotide_accession_version='NC_000074.6', start_position_on_the_genomic_accession=92855330, end_position_on_the_genomic_accession=92919279, orientation='plus', exon_count=15, OMIM='', no_hdr0=''),
  270086 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=270086, CurrentID=0, Status='live', Symbol='Ogfod1', Aliases='4930415J21Rik, AA387199, AA939912, AW061076, mKIAA1612', description='2-oxoglutarate and iron-dependent oxygenase domain containing 1', other_designations='2-oxoglutarate and iron-dependent oxygenase domain-containing protein 1', map_location='8 C5', chromosome='8', genomic_nucleotide_accession_version='NC_000074.6', start_position_on_the_genomic_accession=94037141, end_position_on_the_genomic_accession=94067923, orientation='plus', exon_count=13, OMIM='', no_hdr0=''),
  270091 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=270091, CurrentID=0, Status='live', Symbol='Lrrc36', Aliases='BC036564', description='leucine rich repeat containing 36', other_designations='', map_location='8 D3', chromosome='8', genomic_nucleotide_accession_version='NC_000074.6', start_position_on_the_genomic_accession=105411389, end_position_on_the_genomic_accession=105464086, orientation='plus', exon_count=15, OMIM='', no_hdr0=''),
  270096 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=270096, CurrentID=0, Status='live', Symbol='Mon1b', Aliases='5031407H10, 5033413H12Rik', description='MON1 homolog b (yeast)', other_designations='', map_location='8 E1', chromosome='8', genomic_nucleotide_accession_version='NC_000074.6', start_position_on_the_genomic_accession=113635586, end_position_on_the_genomic_accession=113645192, orientation='plus', exon_count=6, OMIM='', no_hdr0=''),
  270097 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=270097, CurrentID=0, Status='live', Symbol='Vat1l', Aliases='9430073I07, AI427515, mKIAA1576', description='vesicle amine transport protein 1 homolog-like (T. californica)', other_designations='', map_location='8 E1', chromosome='8', genomic_nucleotide_accession_version='NC_000074.6', start_position_on_the_genomic_accession=114205582, end_position_on_the_genomic_accession=114374074, orientation='plus', exon_count=10, OMIM='', no_hdr0=''),
  270106 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=270106, CurrentID=0, Status='live', Symbol='Rpl13', Aliases='A52, L13', description='ribosomal protein L13', other_designations='', map_location='8 E1', chromosome='8', genomic_nucleotide_accession_version='NC_000074.6', start_position_on_the_genomic_accession=123102350, end_position_on_the_genomic_accession=123105244, orientation='plus', exon_count=6, OMIM='', no_hdr0=''),
  270109 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=270109, CurrentID=0, Status='live', Symbol='Pcnxl2', Aliases='A830048P05, AU067631, E330039K12Rik, mKIAA0435', description='pecanex-like 2 (Drosophila)', other_designations='', map_location='8 E2', chromosome='8', genomic_nucleotide_accession_version='NC_000074.6', start_position_on_the_genomic_accession=125751504, end_position_on_the_genomic_accession=125898317, orientation='minus', exon_count=36, OMIM='', no_hdr0=''),
  270110 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=270110, CurrentID=0, Status='live', Symbol='Irf2bp2', Aliases='E130305N23Rik, IRF-2BP2', description='interferon regulatory factor 2 binding protein 2', other_designations='IRF-2-binding protein 2', map_location='8 E2', chromosome='8', genomic_nucleotide_accession_version='NC_000074.6', start_position_on_the_genomic_accession=126588296, end_position_on_the_genomic_accession=126593436, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  270118 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=270118, CurrentID=0, Status='live', Symbol='Maml2', Aliases='5930431H10, BC032967', description='mastermind like 2 (Drosophila)', other_designations='', map_location='9 A1', chromosome='9', genomic_nucleotide_accession_version='NC_000075.6', start_position_on_the_genomic_accession=13619989, end_position_on_the_genomic_accession=13709533, orientation='plus', exon_count=6, OMIM='', no_hdr0=''),
  270120 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=270120, CurrentID=0, Status='live', Symbol='Fat3', Aliases='9430076A06Rik, D430038H04Rik, Gm1132, Gm510, MFAT3F', description='FAT atypical cadherin 3', other_designations='FAT tumor suppressor homolog 3|protocadherin Fat3', map_location='9 A2', chromosome='9', genomic_nucleotide_accession_version='NC_000075.6', start_position_on_the_genomic_accession=15910189, end_position_on_the_genomic_accession=16502879, orientation='minus', exon_count=29, OMIM='', no_hdr0=''),
  102637358 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102637358, CurrentID=0, Status='live', Symbol='Gm21271', Aliases='', description='predicted gene, 21271', other_designations='', map_location='Y', chromosome='Y', genomic_nucleotide_accession_version='NC_000087.7', start_position_on_the_genomic_accession=48594777, end_position_on_the_genomic_accession=48597096, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  102637361 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102637361, CurrentID=0, Status='live', Symbol='Gm29476', Aliases='', description='predicted gene 29476', other_designations='', map_location='Y', chromosome='Y', genomic_nucleotide_accession_version='NC_000087.7', start_position_on_the_genomic_accession=83956554, end_position_on_the_genomic_accession=83996102, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  102637362 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102637362, CurrentID=0, Status='live', Symbol='Gm34192', Aliases='', description='predicted gene, 34192', other_designations='', map_location='Y', chromosome='Y', genomic_nucleotide_accession_version='NC_000087.7', start_position_on_the_genomic_accession=90742017, end_position_on_the_genomic_accession=90743882, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  102637366 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102637366, CurrentID=0, Status='live', Symbol='Gm10037', Aliases='EG328280, ENSMUSG00000058246, Rslcan24', description='predicted gene 10037', other_designations='regulator of sex-limitation candidate 24', map_location='13 B3', chromosome='13', genomic_nucleotide_accession_version='NC_000079.6', start_position_on_the_genomic_accession=67830977, end_position_on_the_genomic_accession=67844879, orientation='plus', exon_count=7, OMIM='', no_hdr0=''),
  270150 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=270150, CurrentID=0, Status='live', Symbol='Ccdc153', Aliases='', description='coiled-coil domain containing 153', other_designations='', map_location='9 A5.2', chromosome='9', genomic_nucleotide_accession_version='NC_000075.6', start_position_on_the_genomic_accession=44240655, end_position_on_the_genomic_accession=44247306, orientation='plus', exon_count=7, OMIM='', no_hdr0=''),
  270151 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=270151, CurrentID=0, Status='live', Symbol='Nlrx1', Aliases='BC034204, NOD9', description='NLR family member X1', other_designations='nucleotide-binding domain and leucine-rich repeat containing', map_location='9 A5.2', chromosome='9', genomic_nucleotide_accession_version='NC_000075.6', start_position_on_the_genomic_accession=44252713, end_position_on_the_genomic_accession=44268599, orientation='minus', exon_count=12, OMIM='', no_hdr0=''),
  270152 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=270152, CurrentID=0, Status='live', Symbol='Amica1', Aliases='AMICA, Crea7, Gm638', description='adhesion molecule, interacts with CXADR antigen 1', other_designations='adhesion molecule AMICA|dendritic cell-specific protein CREA7|dendritic-cell specific protein Crea7|mCrea7', map_location='9 A5.2', chromosome='9', genomic_nucleotide_accession_version='NC_000075.6', start_position_on_the_genomic_accession=45079162, end_position_on_the_genomic_accession=45108531, orientation='plus', exon_count=15, OMIM='', no_hdr0=''),
  329015 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=329015, CurrentID=0, Status='live', Symbol='Atg2a', Aliases='1810013C15Rik, A830054M12, BC023754, mKIAA0404', description='autophagy related 2A', other_designations='ATG2 autophagy related 2 homolog A', map_location='19 A', chromosome='19', genomic_nucleotide_accession_version='NC_000085.6', start_position_on_the_genomic_accession=6241666, end_position_on_the_genomic_accession=6262304, orientation='plus', exon_count=40, OMIM='', no_hdr0=''),
  270156 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=270156, CurrentID=0, Status='live', Symbol='AU019823', Aliases='Gm639', description='expressed sequence AU019823', other_designations='', map_location='9 A5.3', chromosome='9', genomic_nucleotide_accession_version='NC_000075.6', start_position_on_the_genomic_accession=50605240, end_position_on_the_genomic_accession=50617589, orientation='minus', exon_count=7, OMIM='', no_hdr0=''),
  110562 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=110562, CurrentID=0, Status='live', Symbol='H2-T7', Aliases='H-2T7', description='histocompatibility 2, T region locus 7', other_designations='', map_location='', chromosome='17', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  270160 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=270160, CurrentID=0, Status='live', Symbol='Rab39', Aliases='C230094F14Rika, Rab39', description='RAB39, member RAS oncogene family', other_designations='rab-39', map_location='9 A5.3', chromosome='9', genomic_nucleotide_accession_version='NC_000075.6', start_position_on_the_genomic_accession=53684110, end_position_on_the_genomic_accession=53706232, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  270162 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=270162, CurrentID=0, Status='live', Symbol='Elmod1', Aliases='4831417L10, AI428506, AI834991', description='ELMO/CED-12 domain containing 1', other_designations='ELMO domain containing 1', map_location='9 A5.3', chromosome='9', genomic_nucleotide_accession_version='NC_000075.6', start_position_on_the_genomic_accession=53911457, end_position_on_the_genomic_accession=53975310, orientation='minus', exon_count=13, OMIM='', no_hdr0=''),
  270163 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=270163, CurrentID=0, Status='live', Symbol='Myo9a', Aliases='4732465J09Rik, C130068I12Rik, C230003M11', description='myosin IXa', other_designations='myosin-IXa|unconventional myosin-9a', map_location='9 32.13 cM', chromosome='9', genomic_nucleotide_accession_version='NC_000075.6', start_position_on_the_genomic_accession=59750856, end_position_on_the_genomic_accession=59928866, orientation='plus', exon_count=45, OMIM='', no_hdr0=''),
  270166 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=270166, CurrentID=0, Status='live', Symbol='Clpx', Aliases='AU014732, E330029I21', description='caseinolytic mitochondrial matrix peptidase chaperone subunit', other_designations='caseinolytic peptidase X|caseinolytic protease X', map_location='9 35.22 cM', chromosome='9', genomic_nucleotide_accession_version='NC_000075.6', start_position_on_the_genomic_accession=65294250, end_position_on_the_genomic_accession=65330658, orientation='plus', exon_count=14, OMIM='', no_hdr0=''),
  102637400 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102637400, CurrentID=0, Status='live', Symbol='Gm34220', Aliases='', description='predicted gene, 34220', other_designations='', map_location='12', chromosome='12', genomic_nucleotide_accession_version='NC_000078.6', start_position_on_the_genomic_accession=108790031, end_position_on_the_genomic_accession=108793414, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  110564 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=110564, CurrentID=0, Status='live', Symbol='Lth1', Aliases='Lth-1, Lvth-1', description='liver 30-40 thousand Mol. Wt. protein 1', other_designations='', map_location='', chromosome='13', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  102637417 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102637417, CurrentID=0, Status='live', Symbol='LOC102637417', Aliases='', description='keratin-associated protein 20-2-like', other_designations='', map_location='', chromosome='16', genomic_nucleotide_accession_version='NC_000082.6', start_position_on_the_genomic_accession=89169490, end_position_on_the_genomic_accession=89169648, orientation='plus', exon_count=1, OMIM='', no_hdr0=''),
  102637418 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102637418, CurrentID=0, Status='live', Symbol='LOC102637418', Aliases='', description='protein FAM205A-like', other_designations='', map_location='', chromosome='4', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  270190 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=270190, CurrentID=0, Status='live', Symbol='Ephb1', Aliases='9330129L11, AW488255, C130099E04Rik, Cek6, ENSMUSG00000074119, Elk, Elkh, Hek6, Net', description='Eph receptor B1', other_designations='', map_location='9 F1', chromosome='9', genomic_nucleotide_accession_version='NC_000075.6', start_position_on_the_genomic_accession=101922128, end_position_on_the_genomic_accession=102354693, orientation='minus', exon_count=16, OMIM='', no_hdr0=''),
  270192 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=270192, CurrentID=0, Status='live', Symbol='Rab6b', Aliases='9630015C03, AI844641, C330006L04Rik, D9Bwg0185e', description='RAB6B, member RAS oncogene family', other_designations='', map_location='9 54.88 cM', chromosome='9', genomic_nucleotide_accession_version='NC_000075.6', start_position_on_the_genomic_accession=103112074, end_position_on_the_genomic_accession=103185276, orientation='plus', exon_count=10, OMIM='', no_hdr0=''),
  270198 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=270198, CurrentID=0, Status='live', Symbol='Pfkfb4', Aliases='C230090D14', description='6-phosphofructo-2-kinase/fructose-2,6-biphosphatase 4', other_designations='6PF-2-K/Fru-2,6-P2ase 4|6PF-2-K/Fru-2,6-P2ase testis-type isozyme|PFK/FBPase 4', map_location='9 F2', chromosome='9', genomic_nucleotide_accession_version='NC_000075.6', start_position_on_the_genomic_accession=108988033, end_position_on_the_genomic_accession=109032236, orientation='plus', exon_count=18, OMIM='', no_hdr0=''),
  270201 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=270201, CurrentID=0, Status='live', Symbol='Klhl18', Aliases='A930041K15, AW545966', description='kelch-like 18', other_designations='', map_location='9 F2', chromosome='9', genomic_nucleotide_accession_version='NC_000075.6', start_position_on_the_genomic_accession=110425926, end_position_on_the_genomic_accession=110476700, orientation='minus', exon_count=11, OMIM='', no_hdr0=''),
  102637435 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102637435, CurrentID=0, Status='live', Symbol='Gm34243', Aliases='', description='predicted gene, 34243', other_designations='', map_location='13', chromosome='13', genomic_nucleotide_accession_version='NC_000079.6', start_position_on_the_genomic_accession=28069599, end_position_on_the_genomic_accession=28091606, orientation='plus', exon_count=6, OMIM='', no_hdr0=''),
  270210 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=270210, CurrentID=0, Status='live', Symbol='Zfp651', Aliases='4732420M22Rik, BC030045, R74626', description='zinc finger protein 651', other_designations='', map_location='9 F4', chromosome='9', genomic_nucleotide_accession_version='NC_000075.6', start_position_on_the_genomic_accession=121758638, end_position_on_the_genomic_accession=121771742, orientation='plus', exon_count=8, OMIM='', no_hdr0=''),
  102637473 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102637473, CurrentID=0, Status='live', Symbol='Gm21771', Aliases='', description='predicted gene, 21771', other_designations='', map_location='Y', chromosome='Y', genomic_nucleotide_accession_version='NC_000087.7', start_position_on_the_genomic_accession=27177693, end_position_on_the_genomic_accession=27180106, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  102637474 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102637474, CurrentID=0, Status='live', Symbol='Gm21745', Aliases='', description='predicted gene, 21745', other_designations='', map_location='Y', chromosome='Y', genomic_nucleotide_accession_version='NC_000087.7', start_position_on_the_genomic_accession=34028065, end_position_on_the_genomic_accession=34030476, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  102637475 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102637475, CurrentID=0, Status='live', Symbol='Gm29637', Aliases='', description='predicted gene 29637', other_designations='', map_location='Y', chromosome='Y', genomic_nucleotide_accession_version='NC_000087.7', start_position_on_the_genomic_accession=67544885, end_position_on_the_genomic_accession=67545460, orientation='plus', exon_count=1, OMIM='', no_hdr0=''),
  102637476 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102637476, CurrentID=0, Status='live', Symbol='Gm21757', Aliases='', description='predicted gene, 21757', other_designations='', map_location='Y', chromosome='Y', genomic_nucleotide_accession_version='NC_000087.7', start_position_on_the_genomic_accession=72449768, end_position_on_the_genomic_accession=72452243, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  102637484 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102637484, CurrentID=0, Status='live', Symbol='LOC102637484', Aliases='', description='disks large homolog 5-like', other_designations='', map_location='', chromosome='14', genomic_nucleotide_accession_version='NC_000080.6', start_position_on_the_genomic_accession=41946378, end_position_on_the_genomic_accession=41948599, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  102637485 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102637485, CurrentID=0, Status='live', Symbol='Gm34280', Aliases='', description='predicted gene, 34280', other_designations='', map_location='7', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=99693025, end_position_on_the_genomic_accession=99714226, orientation='plus', exon_count=6, OMIM='', no_hdr0=''),
  102637488 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102637488, CurrentID=0, Status='live', Symbol='LOC102637488', Aliases='', description='uncharacterized LOC102637488', other_designations='', map_location='', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=60114912, end_position_on_the_genomic_accession=60115773, orientation='minus', exon_count=1, OMIM='', no_hdr0=''),
  102637494 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102637494, CurrentID=0, Status='live', Symbol='Gm34287', Aliases='', description='predicted gene, 34287', other_designations='', map_location='1', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=183258235, end_position_on_the_genomic_accession=183275732, orientation='minus', exon_count=6, OMIM='', no_hdr0=''),
  102637505 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102637505, CurrentID=0, Status='live', Symbol='Gm34296', Aliases='', description='predicted gene, 34296', other_designations='', map_location='4', chromosome='4', genomic_nucleotide_accession_version='NC_000070.6', start_position_on_the_genomic_accession=133792037, end_position_on_the_genomic_accession=133815177, orientation='minus', exon_count=6, OMIM='', no_hdr0=''),
  102637507 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102637507, CurrentID=0, Status='live', Symbol='Gm34298', Aliases='', description='predicted gene, 34298', other_designations='', map_location='10', chromosome='10', genomic_nucleotide_accession_version='NC_000076.6', start_position_on_the_genomic_accession=103028985, end_position_on_the_genomic_accession=103032531, orientation='plus', exon_count=4, OMIM='', no_hdr0=''),
  102637516 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102637516, CurrentID=0, Status='live', Symbol='Gm29413', Aliases='', description='predicted gene 29413', other_designations='', map_location='Y', chromosome='Y', genomic_nucleotide_accession_version='NC_000087.7', start_position_on_the_genomic_accession=37681835, end_position_on_the_genomic_accession=37708046, orientation='minus', exon_count=9, OMIM='', no_hdr0=''),
  102637534 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102637534, CurrentID=0, Status='live', Symbol='Cpo', Aliases='', description='carboxypeptidase O', other_designations='', map_location='', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=63903504, end_position_on_the_genomic_accession=63936247, orientation='plus', exon_count=9, OMIM='', no_hdr0=''),
  102637548 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102637548, CurrentID=0, Status='live', Symbol='Gm17521', Aliases='', description='predicted gene, 17521', other_designations='', map_location='X 49.81 cM', chromosome='X', genomic_nucleotide_accession_version='NC_000086.7', start_position_on_the_genomic_accession=123017929, end_position_on_the_genomic_accession=123030236, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  102637550 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102637550, CurrentID=0, Status='live', Symbol='Gm28786', Aliases='', description='predicted gene 28786', other_designations='', map_location='Y', chromosome='Y', genomic_nucleotide_accession_version='NC_000087.7', start_position_on_the_genomic_accession=38883493, end_position_on_the_genomic_accession=38898565, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  102637552 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102637552, CurrentID=0, Status='live', Symbol='Gm34330', Aliases='', description='predicted gene, 34330', other_designations='', map_location='13', chromosome='13', genomic_nucleotide_accession_version='NC_000079.6', start_position_on_the_genomic_accession=44728868, end_position_on_the_genomic_accession=44730786, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  270328 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=270328, CurrentID=0, Status='live', Symbol='Gsdmc3', Aliases='9930109F21Rik', description='gasdermin C3', other_designations='gsdmc3', map_location='15 D1', chromosome='15', genomic_nucleotide_accession_version='NC_000081.6', start_position_on_the_genomic_accession=63857716, end_position_on_the_genomic_accession=63878583, orientation='minus', exon_count=13, OMIM='', no_hdr0=''),
  102637572 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102637572, CurrentID=0, Status='live', Symbol='Gm38499', Aliases='', description='predicted gene, 38499', other_designations='', map_location='7', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=19248771, end_position_on_the_genomic_accession=19257679, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  634881 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=634881, CurrentID=0, Status='live', Symbol='Gm7146', Aliases='EG634881', description='predicted pseudogene 7146', other_designations='', map_location='X E1', chromosome='X', genomic_nucleotide_accession_version='NC_000086.6', start_position_on_the_genomic_accession=111305626, end_position_on_the_genomic_accession=111312274, orientation='plus', exon_count=3, OMIM='', no_hdr0=''),
  102637593 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102637593, CurrentID=0, Status='live', Symbol='Gm34362', Aliases='', description='predicted gene, 34362', other_designations='', map_location='14', chromosome='14', genomic_nucleotide_accession_version='NC_000080.6', start_position_on_the_genomic_accession=45175041, end_position_on_the_genomic_accession=45176705, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  102637615 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102637615, CurrentID=0, Status='live', Symbol='LOC102637615', Aliases='', description='major allergen I polypeptide chain 1-like', other_designations='', map_location='', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=33063465, end_position_on_the_genomic_accession=33064646, orientation='plus', exon_count=3, OMIM='', no_hdr0=''),
  329055 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=329055, CurrentID=0, Status='live', Symbol='Gm5097', Aliases='EG329055', description='predicted gene 5097', other_designations='', map_location='19 C1', chromosome='19', genomic_nucleotide_accession_version='NC_000085.6', start_position_on_the_genomic_accession=33776534, end_position_on_the_genomic_accession=33787452, orientation='minus', exon_count=9, OMIM='', no_hdr0=''),
  102637634 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102637634, CurrentID=0, Status='live', Symbol='Gm34396', Aliases='', description='predicted gene, 34396', other_designations='', map_location='16', chromosome='16', genomic_nucleotide_accession_version='NC_000082.6', start_position_on_the_genomic_accession=89183315, end_position_on_the_genomic_accession=89183500, orientation='plus', exon_count=1, OMIM='', no_hdr0=''),
  102637650 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102637650, CurrentID=0, Status='live', Symbol='Gm17412', Aliases='', description='predicted gene, 17412', other_designations='', map_location='X 49.81 cM', chromosome='X', genomic_nucleotide_accession_version='NC_000086.7', start_position_on_the_genomic_accession=123479973, end_position_on_the_genomic_accession=123484462, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  66921 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=66921, CurrentID=0, Status='live', Symbol='Prpf38b', Aliases='1110021E09Rik, AU018955', description='PRP38 pre-mRNA processing factor 38 (yeast) domain containing B', other_designations='', map_location='3 G1', chromosome='3', genomic_nucleotide_accession_version='NC_000069.6', start_position_on_the_genomic_accession=108902807, end_position_on_the_genomic_accession=108911752, orientation='minus', exon_count=8, OMIM='', no_hdr0=''),
  102637705 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102637705, CurrentID=0, Status='live', Symbol='Gm20654', Aliases='', description='predicted gene 20654', other_designations='', map_location='15 34.37 cM', chromosome='15', genomic_nucleotide_accession_version='NC_000081.6', start_position_on_the_genomic_accession=75449315, end_position_on_the_genomic_accession=75454942, orientation='plus', exon_count=3, OMIM='', no_hdr0=''),
  241688 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=241688, CurrentID=0, Status='live', Symbol='Dzank1', Aliases='2810039F03Rik, 6330439K17Rik, 6430408C01, AI851115, Ankrd64', description='double zinc ribbon and ankyrin repeat domains 1', other_designations='ankyrin repeat-containing protein C20orf12 homolog|likely ortholog of H. sapiens chromosome 20 open reading frame 12 (C20orf12)', map_location='2 G1', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=144470555, end_position_on_the_genomic_accession=144527425, orientation='minus', exon_count=21, OMIM='', no_hdr0=''),
  102637746 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102637746, CurrentID=0, Status='live', Symbol='Gm34478', Aliases='', description='predicted gene, 34478', other_designations='', map_location='16', chromosome='16', genomic_nucleotide_accession_version='NC_000082.6', start_position_on_the_genomic_accession=89211487, end_position_on_the_genomic_accession=89211781, orientation='plus', exon_count=1, OMIM='', no_hdr0=''),
  110622 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=110622, CurrentID=0, Status='live', Symbol='H2-T12', Aliases='H-2T12', description='histocompatibility 2, T region locus 12', other_designations='', map_location='', chromosome='17', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  102637761 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102637761, CurrentID=0, Status='live', Symbol='Gm34491', Aliases='', description='predicted gene, 34491', other_designations='', map_location='X', chromosome='X', genomic_nucleotide_accession_version='NC_000086.7', start_position_on_the_genomic_accession=123920309, end_position_on_the_genomic_accession=123924798, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  102637762 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102637762, CurrentID=0, Status='live', Symbol='Gm21812', Aliases='', description='predicted gene, 21812', other_designations='', map_location='Y', chromosome='Y', genomic_nucleotide_accession_version='NC_000087.7', start_position_on_the_genomic_accession=9344971, end_position_on_the_genomic_accession=9347258, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  102637768 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102637768, CurrentID=0, Status='live', Symbol='Gm28107', Aliases='', description='predicted gene 28107', other_designations='', map_location='Y', chromosome='Y', genomic_nucleotide_accession_version='NC_000087.7', start_position_on_the_genomic_accession=87824754, end_position_on_the_genomic_accession=87827193, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  102637782 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102637782, CurrentID=0, Status='live', Symbol='Gm34507', Aliases='', description='predicted gene, 34507', other_designations='', map_location='17', chromosome='17', genomic_nucleotide_accession_version='NC_000083.6', start_position_on_the_genomic_accession=4907831, end_position_on_the_genomic_accession=4914351, orientation='plus', exon_count=4, OMIM='', no_hdr0=''),
  503845 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=503845, CurrentID=0, Status='live', Symbol='Ear12', Aliases='', description='eosinophil-associated, ribonuclease A family, member 12', other_designations='', map_location='', chromosome='14', genomic_nucleotide_accession_version='NC_000080.5', start_position_on_the_genomic_accession=44624652, end_position_on_the_genomic_accession=44625122, orientation='plus', exon_count=1, OMIM='', no_hdr0=''),
  102637800 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102637800, CurrentID=0, Status='live', Symbol='Gm34521', Aliases='', description='predicted gene, 34521', other_designations='', map_location='X', chromosome='X', genomic_nucleotide_accession_version='NC_000086.7', start_position_on_the_genomic_accession=109445438, end_position_on_the_genomic_accession=109558772, orientation='plus', exon_count=6, OMIM='', no_hdr0=''),
  110631 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=110631, CurrentID=0, Status='live', Symbol='H2-Q15', Aliases='Q15', description='histocompatibility 2, Q region locus 15', other_designations='', map_location='', chromosome='17', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  102637806 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102637806, CurrentID=0, Status='live', Symbol='LOC102637806', Aliases='', description='uncharacterized LOC102637806', other_designations='', map_location='', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=89930366, end_position_on_the_genomic_accession=89934593, orientation='plus', exon_count=5, OMIM='', no_hdr0=''),
  102637808 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102637808, CurrentID=0, Status='live', Symbol='LOC102637808', Aliases='', description='low-density lipoprotein receptor class A domain-containing protein 1-like', other_designations='', map_location='', chromosome='13', genomic_nucleotide_accession_version='NC_000079.6', start_position_on_the_genomic_accession=98279847, end_position_on_the_genomic_accession=98307677, orientation='plus', exon_count=7, OMIM='', no_hdr0=''),
  102637812 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102637812, CurrentID=0, Status='live', Symbol='Gm17027', Aliases='', description='predicted gene 17027', other_designations='', map_location='14 22.4 cM', chromosome='14', genomic_nucleotide_accession_version='NC_000080.6', start_position_on_the_genomic_accession=42159256, end_position_on_the_genomic_accession=42162612, orientation='minus', exon_count=4, OMIM='', no_hdr0=''),
  102637825 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102637825, CurrentID=0, Status='live', Symbol='Gm34538', Aliases='', description='predicted gene, 34538', other_designations='', map_location='9', chromosome='9', genomic_nucleotide_accession_version='NC_000075.6', start_position_on_the_genomic_accession=37034688, end_position_on_the_genomic_accession=37075741, orientation='plus', exon_count=7, OMIM='', no_hdr0=''),
  270599 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=270599, CurrentID=0, Status='live', Symbol='Gm648', Aliases='', description='predicted gene 648', other_designations='', map_location='X A5', chromosome='X', genomic_nucleotide_accession_version='NC_000086.7', start_position_on_the_genomic_accession=56543873, end_position_on_the_genomic_accession=56569162, orientation='minus', exon_count=9, OMIM='', no_hdr0=''),
  102637839 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102637839, CurrentID=0, Status='live', Symbol='LOC102637839', Aliases='', description='zinc finger protein 431-like', other_designations='', map_location='', chromosome='12', genomic_nucleotide_accession_version='NC_000078.6', start_position_on_the_genomic_accession=22243826, end_position_on_the_genomic_accession=22467255, orientation='minus', exon_count=9, OMIM='', no_hdr0=''),
  329093 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=329093, CurrentID=0, Status='live', Symbol='Cpa6', Aliases='9030616D13Rik', description='carboxypeptidase A6', other_designations='metallocarboxypeptidase', map_location='1 A2', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=10295791, end_position_on_the_genomic_accession=10720058, orientation='minus', exon_count=15, OMIM='', no_hdr0=''),
  270624 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=270624, CurrentID=0, Status='live', Symbol='Spin4', Aliases='9630042H07Rik', description='spindlin family, member 4', other_designations='novel Spin/Ssty repeat containing protein', map_location='X C3', chromosome='X', genomic_nucleotide_accession_version='NC_000086.7', start_position_on_the_genomic_accession=95022507, end_position_on_the_genomic_accession=95026682, orientation='minus', exon_count=1, OMIM='', no_hdr0=''),
  270627 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=270627, CurrentID=0, Status='live', Symbol='Taf1', Aliases='AU015687, B430306D02Rik, Ccg-1, Ccg1, KAT4, N-TAF1, TAFII250, Taf2a, p250', description='TATA-box binding protein associated factor 1', other_designations='TAF1 RNA polymerase II, TATA box binding protein (TBP)-associated factor|TAF1 RNA polymerase II, TATA box binding protein (TBP)-associated factor, neuron specific isoform|TBP-associated factor 250 kDa|cell cycle gene 1 protein|cell cycle, G1 phase defect|transcription initiation factor TFIID 250 kDa subunit', map_location='X 44.29 cM', chromosome='X', genomic_nucleotide_accession_version='NC_000086.7', start_position_on_the_genomic_accession=101527574, end_position_on_the_genomic_accession=101601789, orientation='plus', exon_count=42, OMIM='', no_hdr0=''),
  102637862 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102637862, CurrentID=0, Status='live', Symbol='Gm34566', Aliases='', description='predicted gene, 34566', other_designations='', map_location='16', chromosome='16', genomic_nucleotide_accession_version='NC_000082.6', start_position_on_the_genomic_accession=89215952, end_position_on_the_genomic_accession=89216160, orientation='plus', exon_count=1, OMIM='', no_hdr0=''),
  634929 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=634929, CurrentID=0, Status='live', Symbol='Scgb1b11', Aliases='Gm7147', description='secretoglobin, family 1B, member 11', other_designations='', map_location='7', chromosome='7', genomic_nucleotide_accession_version='NC_000073.5', start_position_on_the_genomic_accession=33007876, end_position_on_the_genomic_accession=33008270, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  102637881 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102637881, CurrentID=0, Status='live', Symbol='Gm34580', Aliases='', description='predicted gene, 34580', other_designations='', map_location='X', chromosome='X', genomic_nucleotide_accession_version='NC_000086.7', start_position_on_the_genomic_accession=124207745, end_position_on_the_genomic_accession=124208923, orientation='minus', exon_count=1, OMIM='', no_hdr0=''),
  102637882 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102637882, CurrentID=0, Status='live', Symbol='LOC102637882', Aliases='', description='pituitary homeobox 3-like', other_designations='', map_location='', chromosome='X', genomic_nucleotide_accession_version='NC_000086.7', start_position_on_the_genomic_accession=37940614, end_position_on_the_genomic_accession=37945671, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  102637885 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102637885, CurrentID=0, Status='live', Symbol='Gm28886', Aliases='', description='predicted gene 28886', other_designations='', map_location='Y', chromosome='Y', genomic_nucleotide_accession_version='NC_000087.7', start_position_on_the_genomic_accession=44334264, end_position_on_the_genomic_accession=44349842, orientation='minus', exon_count=4, OMIM='', no_hdr0=''),
  102637899 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102637899, CurrentID=0, Status='live', Symbol='Gm34595', Aliases='', description='predicted gene, 34595', other_designations='', map_location='8', chromosome='8', genomic_nucleotide_accession_version='NC_000074.6', start_position_on_the_genomic_accession=13220284, end_position_on_the_genomic_accession=13228716, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  270669 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=270669, CurrentID=0, Status='live', Symbol='Mbtps2', Aliases='9630032G22Rik, AI662535', description='membrane-bound transcription factor peptidase, site 2', other_designations='S2P endopeptidase|endopeptidase S2P|membrane-bound transcription factor protease, site 2|site-2 protease', map_location='X F4', chromosome='X', genomic_nucleotide_accession_version='NC_000086.7', start_position_on_the_genomic_accession=157547822, end_position_on_the_genomic_accession=157598715, orientation='minus', exon_count=11, OMIM='', no_hdr0=''),
  270672 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=270672, CurrentID=0, Status='live', Symbol='Map3k15', Aliases='BC031147, MEKK15', description='mitogen-activated protein kinase kinase kinase 15', other_designations='MAPK/ERK kinase kinase 15|MEK kinase 15|MEKK 15|map3k15', map_location='X F4', chromosome='X', genomic_nucleotide_accession_version='NC_000086.7', start_position_on_the_genomic_accession=159988433, end_position_on_the_genomic_accession=160123351, orientation='plus', exon_count=29, OMIM='', no_hdr0=''),
  102637912 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102637912, CurrentID=0, Status='live', Symbol='LOC102637912', Aliases='', description='sperm motility kinase W-like', other_designations='', map_location='', chromosome='17', genomic_nucleotide_accession_version='NC_000083.6', start_position_on_the_genomic_accession=53769789, end_position_on_the_genomic_accession=53788213, orientation='plus', exon_count=12, OMIM='', no_hdr0=''),
  270685 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=270685, CurrentID=0, Status='live', Symbol='Mthfd1l', Aliases='2410004L15Rik, AI647056, Fthfsdc1', description='methylenetetrahydrofolate dehydrogenase (NADP+ dependent) 1-like', other_designations='formyltetrahydrofolate synthetase domain containing 1', map_location='10 A1', chromosome='10', genomic_nucleotide_accession_version='NC_000076.6', start_position_on_the_genomic_accession=3970441, end_position_on_the_genomic_accession=4167081, orientation='plus', exon_count=30, OMIM='', no_hdr0=''),
  270711 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=270711, CurrentID=0, Status='live', Symbol='Fam26d', Aliases='4732454E20Rik, AI586164, Gm643', description='family with sequence similarity 26, member D', other_designations='', map_location='10 B1', chromosome='10', genomic_nucleotide_accession_version='NC_000076.6', start_position_on_the_genomic_accession=34038784, end_position_on_the_genomic_accession=34044313, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  241727 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=241727, CurrentID=0, Status='live', Symbol='Snph', Aliases='6430515A01, AW045671, AW556958, AW743098, mKIAA0374', description='syntaphilin', other_designations='', map_location='2 G3', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=151590549, end_position_on_the_genomic_accession=151633030, orientation='minus', exon_count=7, OMIM='', no_hdr0=''),
  102637953 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102637953, CurrentID=0, Status='live', Symbol='Gm38503', Aliases='', description='predicted gene, 38503', other_designations='', map_location='3', chromosome='3', genomic_nucleotide_accession_version='NC_000069.6', start_position_on_the_genomic_accession=65508983, end_position_on_the_genomic_accession=65520039, orientation='minus', exon_count=4, OMIM='', no_hdr0=''),
  102637954 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102637954, CurrentID=0, Status='live', Symbol='Gm34638', Aliases='', description='predicted gene, 34638', other_designations='', map_location='12', chromosome='12', genomic_nucleotide_accession_version='NC_000078.6', start_position_on_the_genomic_accession=91234246, end_position_on_the_genomic_accession=91236623, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  102637955 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102637955, CurrentID=0, Status='live', Symbol='Gm29531', Aliases='', description='predicted gene 29531', other_designations='', map_location='Y', chromosome='Y', genomic_nucleotide_accession_version='NC_000087.7', start_position_on_the_genomic_accession=34124896, end_position_on_the_genomic_accession=34128420, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  102637970 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102637970, CurrentID=0, Status='live', Symbol='Gm34650', Aliases='', description='predicted gene, 34650', other_designations='', map_location='16', chromosome='16', genomic_nucleotide_accession_version='NC_000082.6', start_position_on_the_genomic_accession=89222396, end_position_on_the_genomic_accession=89222646, orientation='plus', exon_count=1, OMIM='', no_hdr0=''),
  102637973 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102637973, CurrentID=0, Status='live', Symbol='Gm34653', Aliases='', description='predicted gene, 34653', other_designations='', map_location='2', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=34826316, end_position_on_the_genomic_accession=34839380, orientation='plus', exon_count=4, OMIM='', no_hdr0=''),
  241732 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=241732, CurrentID=0, Status='live', Symbol='Tspyl3', Aliases='AW212607, Gm36', description='TSPY-like 3', other_designations='', map_location='2 H1', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=153222370, end_position_on_the_genomic_accession=153225441, orientation='minus', exon_count=1, OMIM='', no_hdr0=''),
  102637988 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102637988, CurrentID=0, Status='live', Symbol='Astx1a', Aliases='Gm14959, OTTMUSG00000018598', description='amplified spermatogenic transcripts X encoded 1A', other_designations='', map_location='X 49.81 cM', chromosome='X', genomic_nucleotide_accession_version='NC_000086.7', start_position_on_the_genomic_accession=124398466, end_position_on_the_genomic_accession=124410529, orientation='plus', exon_count=9, OMIM='', no_hdr0=''),
  270757 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=270757, CurrentID=0, Status='live', Symbol='Bpifc', Aliases='4732454E24, Bpil2', description='BPI fold containing family C', other_designations='bactericidal/permeability-increasing protein-like 2', map_location='10 C1', chromosome='10', genomic_nucleotide_accession_version='NC_000076.6', start_position_on_the_genomic_accession=85959340, end_position_on_the_genomic_accession=86015898, orientation='minus', exon_count=17, OMIM='', no_hdr0=''),
  102637996 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102637996, CurrentID=0, Status='live', Symbol='Gm21733', Aliases='', description='predicted gene, 21733', other_designations='', map_location='Y', chromosome='Y', genomic_nucleotide_accession_version='NC_000087.7', start_position_on_the_genomic_accession=55483303, end_position_on_the_genomic_accession=55485551, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  102638030 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102638030, CurrentID=0, Status='live', Symbol='Gm21907', Aliases='', description='predicted gene, 21907', other_designations='', map_location='Y', chromosome='Y', genomic_nucleotide_accession_version='NC_000087.7', start_position_on_the_genomic_accession=23238452, end_position_on_the_genomic_accession=23240970, orientation='plus', exon_count=3, OMIM='', no_hdr0=''),
  102638032 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102638032, CurrentID=0, Status='live', Symbol='Gm28471', Aliases='', description='predicted gene 28471', other_designations='', map_location='Y', chromosome='Y', genomic_nucleotide_accession_version='NC_000087.7', start_position_on_the_genomic_accession=84591264, end_position_on_the_genomic_accession=84593923, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  270802 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=270802, CurrentID=0, Status='live', Symbol='BC048403', Aliases='E030027L10', description='cDNA sequence BC048403', other_designations='', map_location='10 D2', chromosome='10', genomic_nucleotide_accession_version='NC_000076.6', start_position_on_the_genomic_accession=121739603, end_position_on_the_genomic_accession=121757613, orientation='plus', exon_count=4, OMIM='', no_hdr0=''),
  102638047 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102638047, CurrentID=0, Status='live', Symbol='LOC102638047', Aliases='', description='sp110 nuclear body protein-like', other_designations='', map_location='', chromosome='1', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  102638055 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102638055, CurrentID=0, Status='live', Symbol='LOC102638055', Aliases='', description='zinc finger protein 501-like', other_designations='', map_location='', chromosome='4', genomic_nucleotide_accession_version='NC_000070.6', start_position_on_the_genomic_accession=147324732, end_position_on_the_genomic_accession=147391347, orientation='plus', exon_count=7, OMIM='', no_hdr0=''),
  102638079 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102638079, CurrentID=0, Status='live', Symbol='Gm34728', Aliases='', description='predicted gene, 34728', other_designations='', map_location='5', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=77433718, end_position_on_the_genomic_accession=77435531, orientation='plus', exon_count=3, OMIM='', no_hdr0=''),
  102638083 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102638083, CurrentID=0, Status='live', Symbol='LOC102638083', Aliases='', description='uncharacterized LOC102638083', other_designations='', map_location='', chromosome='16', genomic_nucleotide_accession_version='NC_000082.6', start_position_on_the_genomic_accession=18214227, end_position_on_the_genomic_accession=18220347, orientation='plus', exon_count=8, OMIM='', no_hdr0=''),
  102638085 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102638085, CurrentID=0, Status='live', Symbol='LOC102638085', Aliases='', description='uncharacterized protein C2orf16-like', other_designations='', map_location='', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=27940672, end_position_on_the_genomic_accession=27977335, orientation='plus', exon_count=8, OMIM='', no_hdr0=''),
  102638087 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102638087, CurrentID=0, Status='live', Symbol='Gm34733', Aliases='', description='predicted gene, 34733', other_designations='', map_location='16', chromosome='16', genomic_nucleotide_accession_version='NC_000082.6', start_position_on_the_genomic_accession=89226811, end_position_on_the_genomic_accession=89227103, orientation='plus', exon_count=1, OMIM='', no_hdr0=''),
  102638101 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102638101, CurrentID=0, Status='live', Symbol='Gm28510', Aliases='', description='predicted gene 28510', other_designations='', map_location='Y', chromosome='Y', genomic_nucleotide_accession_version='NC_000087.7', start_position_on_the_genomic_accession=10425481, end_position_on_the_genomic_accession=10444546, orientation='plus', exon_count=8, OMIM='', no_hdr0=''),
  102638103 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102638103, CurrentID=0, Status='live', Symbol='Gm20922', Aliases='', description='predicted gene, 20922', other_designations='', map_location='Y', chromosome='Y', genomic_nucleotide_accession_version='NC_000087.7', start_position_on_the_genomic_accession=37883006, end_position_on_the_genomic_accession=37885454, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  102638106 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102638106, CurrentID=0, Status='live', Symbol='Gm34747', Aliases='', description='predicted gene, 34747', other_designations='', map_location='13', chromosome='13', genomic_nucleotide_accession_version='NC_000079.6', start_position_on_the_genomic_accession=28959393, end_position_on_the_genomic_accession=29009022, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  102638110 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102638110, CurrentID=0, Status='live', Symbol='LOC102638110', Aliases='', description='uncharacterized LOC102638110', other_designations='', map_location='', chromosome='14', genomic_nucleotide_accession_version='NC_000080.6', start_position_on_the_genomic_accession=6022426, end_position_on_the_genomic_accession=6109100, orientation='minus', exon_count=24, OMIM='', no_hdr0=''),
  102638120 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102638120, CurrentID=0, Status='live', Symbol='Gm34758', Aliases='', description='predicted gene, 34758', other_designations='', map_location='14', chromosome='14', genomic_nucleotide_accession_version='NC_000080.6', start_position_on_the_genomic_accession=103346780, end_position_on_the_genomic_accession=103443597, orientation='plus', exon_count=6, OMIM='', no_hdr0=''),
  270893 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=270893, CurrentID=0, Status='live', Symbol='Tmem132e', Aliases='Gm644', description='transmembrane protein 132E', other_designations='', map_location='11 C', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=82387446, end_position_on_the_genomic_accession=82447618, orientation='plus', exon_count=10, OMIM='', no_hdr0=''),
  102638132 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102638132, CurrentID=0, Status='live', Symbol='Gm34768', Aliases='', description='predicted gene, 34768', other_designations='', map_location='2', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=11900089, end_position_on_the_genomic_accession=11916902, orientation='plus', exon_count=7, OMIM='', no_hdr0=''),
  270906 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=270906, CurrentID=0, Status='live', Symbol='Prr11', Aliases='B930067F20Rik', description='proline rich 11', other_designations='', map_location='11 C', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=87089156, end_position_on_the_genomic_accession=87108714, orientation='minus', exon_count=10, OMIM='', no_hdr0=''),
  102638147 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102638147, CurrentID=0, Status='live', Symbol='Gm34781', Aliases='', description='predicted gene, 34781', other_designations='', map_location='3', chromosome='3', genomic_nucleotide_accession_version='NC_000069.6', start_position_on_the_genomic_accession=105094996, end_position_on_the_genomic_accession=105098403, orientation='plus', exon_count=3, OMIM='', no_hdr0=''),
  102638154 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102638154, CurrentID=0, Status='live', Symbol='Gm21856', Aliases='', description='predicted gene, 21856', other_designations='', map_location='Y', chromosome='Y', genomic_nucleotide_accession_version='NC_000087.7', start_position_on_the_genomic_accession=44757856, end_position_on_the_genomic_accession=44760212, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  110692 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=110692, CurrentID=0, Status='live', Symbol='Hydk', Aliases='', description='histocompatibility Y antigen D<k>-restricted', other_designations='', map_location='Y', chromosome='Y', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  102638183 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102638183, CurrentID=0, Status='live', Symbol='LOC102638183', Aliases='', description='small nuclear ribonucleoprotein F', other_designations='', map_location='', chromosome='4', genomic_nucleotide_accession_version='NC_000070.6', start_position_on_the_genomic_accession=150315142, end_position_on_the_genomic_accession=150315616, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  102638196 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102638196, CurrentID=0, Status='live', Symbol='Gm34815', Aliases='', description='predicted gene, 34815', other_designations='', map_location='1', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=121483347, end_position_on_the_genomic_accession=121485413, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  67008 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=67008, CurrentID=0, Status='live', Symbol='Yae1d1', Aliases='1600012F09Rik', description='Yae1 domain containing 1', other_designations='', map_location='13 A2-A3', chromosome='13', genomic_nucleotide_accession_version='NC_000079.6', start_position_on_the_genomic_accession=17986640, end_position_on_the_genomic_accession=17993351, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  102638213 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102638213, CurrentID=0, Status='live', Symbol='Gm34826', Aliases='', description='predicted gene, 34826', other_designations='', map_location='16', chromosome='16', genomic_nucleotide_accession_version='NC_000082.6', start_position_on_the_genomic_accession=89230783, end_position_on_the_genomic_accession=89231006, orientation='plus', exon_count=1, OMIM='', no_hdr0=''),
  329154 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=329154, CurrentID=0, Status='live', Symbol='Ankrd44', Aliases='4930444A19Rik, A130096K20, E130014H08Rik, PP6-ARS-B', description='ankyrin repeat domain 44', other_designations='ankyrin repeat domain-containing protein 44|serine/threonine-protein phosphatase 6 regulatory subunit ARS-B', map_location='1 C1.1', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=54645340, end_position_on_the_genomic_accession=54926733, orientation='minus', exon_count=29, OMIM='', no_hdr0=''),
  102638228 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102638228, CurrentID=0, Status='live', Symbol='Gm29525', Aliases='', description='predicted gene 29525', other_designations='', map_location='Y', chromosome='Y', genomic_nucleotide_accession_version='NC_000087.7', start_position_on_the_genomic_accession=10496943, end_position_on_the_genomic_accession=10497518, orientation='minus', exon_count=1, OMIM='', no_hdr0=''),
  102638230 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102638230, CurrentID=0, Status='live', Symbol='Gm21908', Aliases='', description='predicted gene, 21908', other_designations='', map_location='Y', chromosome='Y', genomic_nucleotide_accession_version='NC_000087.7', start_position_on_the_genomic_accession=31231857, end_position_on_the_genomic_accession=31234270, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  271005 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=271005, CurrentID=0, Status='live', Symbol='Klhdc1', Aliases='', description='kelch domain containing 1', other_designations='', map_location='12 C2', chromosome='12', genomic_nucleotide_accession_version='NC_000078.6', start_position_on_the_genomic_accession=69226917, end_position_on_the_genomic_accession=69284646, orientation='plus', exon_count=17, OMIM='', no_hdr0=''),
  102638251 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102638251, CurrentID=0, Status='live', Symbol='Gm12536', Aliases='OTTMUSG00000007375', description='predicted gene 12536', other_designations='', map_location='4 31.66 cM', chromosome='4', genomic_nucleotide_accession_version='NC_000070.6', start_position_on_the_genomic_accession=57300860, end_position_on_the_genomic_accession=57302613, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  271022 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=271022, CurrentID=0, Status='live', Symbol='Gm10264', Aliases='EG271022, ENSMUSG00000069276', description='predicted gene 10264', other_designations='', map_location='12 D3', chromosome='12', genomic_nucleotide_accession_version='NC_000078.4', start_position_on_the_genomic_accession=88837087, end_position_on_the_genomic_accession=88842937, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  102638256 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102638256, CurrentID=0, Status='live', Symbol='Gm34862', Aliases='', description='predicted gene, 34862', other_designations='', map_location='2', chromosome='2', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  271036 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=271036, CurrentID=0, Status='live', Symbol='Catsperb', Aliases='4931410B03, 4932415G16Rik', description='catsper channel auxiliary subunit beta', other_designations='CatSper channel subunit beta|catSper-beta|cation channel, sperm-associated, beta', map_location='12 E', chromosome='12', genomic_nucleotide_accession_version='NC_000078.6', start_position_on_the_genomic_accession=101404645, end_position_on_the_genomic_accession=101626009, orientation='plus', exon_count=27, OMIM='', no_hdr0=''),
  271047 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=271047, CurrentID=0, Status='live', Symbol='Serpina3b', Aliases='6A1, A030003A19Rik', description='serine (or cysteine) peptidase inhibitor, clade A, member 3B', other_designations='alpha-1 antiproteinase|antitrypsin|serine (or cysteine) proteinase inhibitor, clade A, member 3B|serpin A3B', map_location='12 E', chromosome='12', genomic_nucleotide_accession_version='NC_000078.6', start_position_on_the_genomic_accession=104127531, end_position_on_the_genomic_accession=104139546, orientation='plus', exon_count=6, OMIM='', no_hdr0=''),
  102638291 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102638291, CurrentID=0, Status='live', Symbol='Gm34890', Aliases='', description='predicted gene, 34890', other_designations='', map_location='10', chromosome='10', genomic_nucleotide_accession_version='NC_000076.6', start_position_on_the_genomic_accession=128033554, end_position_on_the_genomic_accession=128034029, orientation='plus', exon_count=3, OMIM='', no_hdr0=''),
  102638305 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102638305, CurrentID=0, Status='live', Symbol='Gm21722', Aliases='', description='predicted gene, 21722', other_designations='', map_location='Y', chromosome='Y', genomic_nucleotide_accession_version='NC_000087.7', start_position_on_the_genomic_accession=80822746, end_position_on_the_genomic_accession=80825244, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  102638323 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102638323, CurrentID=0, Status='live', Symbol='Gm34914', Aliases='', description='predicted gene, 34914', other_designations='', map_location='16', chromosome='16', genomic_nucleotide_accession_version='NC_000082.6', start_position_on_the_genomic_accession=89237308, end_position_on_the_genomic_accession=89237834, orientation='plus', exon_count=1, OMIM='', no_hdr0=''),
  102638324 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102638324, CurrentID=0, Status='live', Symbol='Gm34915', Aliases='', description='predicted gene, 34915', other_designations='', map_location='9', chromosome='9', genomic_nucleotide_accession_version='NC_000075.6', start_position_on_the_genomic_accession=72922099, end_position_on_the_genomic_accession=72925896, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  102638337 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102638337, CurrentID=0, Status='live', Symbol='Gm34926', Aliases='', description='predicted gene, 34926', other_designations='', map_location='3', chromosome='3', genomic_nucleotide_accession_version='NC_000069.6', start_position_on_the_genomic_accession=144803842, end_position_on_the_genomic_accession=144805061, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  102638357 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102638357, CurrentID=0, Status='live', Symbol='Gm34942', Aliases='', description='predicted gene, 34942', other_designations='', map_location='16', chromosome='16', genomic_nucleotide_accession_version='NC_000082.6', start_position_on_the_genomic_accession=22163040, end_position_on_the_genomic_accession=22203047, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  271127 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=271127, CurrentID=0, Status='live', Symbol='Adamts16', Aliases='', description='a disintegrin-like and metallopeptidase (reprolysin type) with thrombospondin type 1 motif, 16', other_designations='ADAM-TS 16|ADAM-TS16|ADAMTS-16|a disintegrin-like and metallopetidase (reprolysin type) with thrombospondin type 1 motif, 16|a disintegrin-like and metalloprotease (reprolysin type) with thrombospondin type 1 motif, 16 preproprotein', map_location='13 35.97 cM', chromosome='13', genomic_nucleotide_accession_version='NC_000079.6', start_position_on_the_genomic_accession=70727798, end_position_on_the_genomic_accession=70841848, orientation='minus', exon_count=25, OMIM='', no_hdr0=''),
  102638361 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102638361, CurrentID=0, Status='live', Symbol='LOC102638361', Aliases='', description='UPF0586 protein C9orf41 homolog', other_designations='', map_location='', chromosome='9', genomic_nucleotide_accession_version='NC_000075.6', start_position_on_the_genomic_accession=78820647, end_position_on_the_genomic_accession=78822010, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  271144 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=271144, CurrentID=0, Status='live', Symbol='Ankdd1b', Aliases='9330128J19Rik', description='ankyrin repeat and death domain containing 1B', other_designations='ankyrin repeat and death domain-containing protein ENSP00000345065 homolog', map_location='13 D1', chromosome='13', genomic_nucleotide_accession_version='NC_000079.6', start_position_on_the_genomic_accession=96415030, end_position_on_the_genomic_accession=96471354, orientation='minus', exon_count=16, OMIM='', no_hdr0=''),
  102638416 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102638416, CurrentID=0, Status='live', Symbol='Gm21877', Aliases='', description='predicted gene, 21877', other_designations='', map_location='Y', chromosome='Y', genomic_nucleotide_accession_version='NC_000087.7', start_position_on_the_genomic_accession=62537113, end_position_on_the_genomic_accession=62539465, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  102638418 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102638418, CurrentID=0, Status='live', Symbol='Gm21813', Aliases='', description='predicted gene, 21813', other_designations='', map_location='Y', chromosome='Y', genomic_nucleotide_accession_version='NC_000087.7', start_position_on_the_genomic_accession=87447166, end_position_on_the_genomic_accession=87447864, orientation='minus', exon_count=1, OMIM='', no_hdr0=''),
  329188 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=329188, CurrentID=0, Status='live', Symbol='Gm816', Aliases='', description='predicted gene 816', other_designations='', map_location='1 C4', chromosome='1', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  102638437 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102638437, CurrentID=0, Status='live', Symbol='Gm35004', Aliases='', description='predicted gene, 35004', other_designations='', map_location='16', chromosome='16', genomic_nucleotide_accession_version='NC_000082.6', start_position_on_the_genomic_accession=89242633, end_position_on_the_genomic_accession=89242808, orientation='plus', exon_count=1, OMIM='', no_hdr0=''),
  271209 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=271209, CurrentID=0, Status='live', Symbol='Rp1l1', Aliases='BC031365, BE983540, Dcdc4, Rp1hl1', description='retinitis pigmentosa 1 homolog (human)-like 1', other_designations='retinitis pigmentosa 1-like protein 1', map_location='14 D1', chromosome='14', genomic_nucleotide_accession_version='NC_000080.6', start_position_on_the_genomic_accession=63992431, end_position_on_the_genomic_accession=64033506, orientation='plus', exon_count=4, OMIM='', no_hdr0=''),
  271221 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=271221, CurrentID=0, Status='live', Symbol='5031414D18Rik', Aliases='Gm744, Gm911, Kiaa0226l', description='RIKEN cDNA 5031414D18 gene', other_designations='', map_location='14 D3', chromosome='14', genomic_nucleotide_accession_version='NC_000080.6', start_position_on_the_genomic_accession=75015878, end_position_on_the_genomic_accession=75052537, orientation='plus', exon_count=15, OMIM='', no_hdr0=''),
  102638488 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102638488, CurrentID=0, Status='live', Symbol='Gm35040', Aliases='', description='predicted gene, 35040', other_designations='', map_location='7', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=79529961, end_position_on_the_genomic_accession=79556907, orientation='plus', exon_count=3, OMIM='', no_hdr0=''),
  271278 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=271278, CurrentID=0, Status='live', Symbol='BC024139', Aliases='6230424I18Rik', description='cDNA sequence BC024139', other_designations='', map_location='15 D3', chromosome='15', genomic_nucleotide_accession_version='NC_000081.6', start_position_on_the_genomic_accession=76119517, end_position_on_the_genomic_accession=76126556, orientation='minus', exon_count=16, OMIM='', no_hdr0=''),
  102638514 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102638514, CurrentID=0, Status='live', Symbol='Gm35060', Aliases='', description='predicted gene, 35060', other_designations='', map_location='18', chromosome='18', genomic_nucleotide_accession_version='NC_000084.6', start_position_on_the_genomic_accession=32458085, end_position_on_the_genomic_accession=32463065, orientation='minus', exon_count=8, OMIM='', no_hdr0=''),
  102638515 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102638515, CurrentID=0, Status='live', Symbol='LOC102638515', Aliases='', description='uncharacterized LOC102638515', other_designations='', map_location='', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=164485529, end_position_on_the_genomic_accession=164486870, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  102638521 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102638521, CurrentID=0, Status='live', Symbol='LOC102638521', Aliases='', description='60S ribosomal protein L23a', other_designations='', map_location='', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=34250424, end_position_on_the_genomic_accession=34251536, orientation='plus', exon_count=1, OMIM='', no_hdr0=''),
  102638532 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102638532, CurrentID=0, Status='live', Symbol='Gm21735', Aliases='', description='predicted gene, 21735', other_designations='', map_location='Y', chromosome='Y', genomic_nucleotide_accession_version='NC_000087.7', start_position_on_the_genomic_accession=38171386, end_position_on_the_genomic_accession=38248444, orientation='plus', exon_count=3, OMIM='', no_hdr0=''),
  102638536 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102638536, CurrentID=0, Status='live', Symbol='Gm28716', Aliases='', description='predicted gene 28716', other_designations='', map_location='Y', chromosome='Y', genomic_nucleotide_accession_version='NC_000087.7', start_position_on_the_genomic_accession=88140528, end_position_on_the_genomic_accession=88141103, orientation='minus', exon_count=1, OMIM='', no_hdr0=''),
  271305 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=271305, CurrentID=0, Status='live', Symbol='Phf21b', Aliases='A730032D07Rik', description='PHD finger protein 21B', other_designations='', map_location='15 E2', chromosome='15', genomic_nucleotide_accession_version='NC_000081.6', start_position_on_the_genomic_accession=84785376, end_position_on_the_genomic_accession=84856132, orientation='minus', exon_count=14, OMIM='', no_hdr0=''),
  67063 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=67063, CurrentID=0, Status='live', Symbol='Tmem246', Aliases='2810432L12Rik, 9330170P15Rik, AI835809', description='transmembrane protein 246', other_designations='transmembrane protein C9orf125 homolog', map_location='4 B1', chromosome='4', genomic_nucleotide_accession_version='NC_000070.6', start_position_on_the_genomic_accession=49584506, end_position_on_the_genomic_accession=49597870, orientation='minus', exon_count=4, OMIM='', no_hdr0=''),
  102638540 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102638540, CurrentID=0, Status='live', Symbol='Gm35077', Aliases='', description='predicted gene, 35077', other_designations='', map_location='6', chromosome='6', genomic_nucleotide_accession_version='NC_000072.6', start_position_on_the_genomic_accession=58497956, end_position_on_the_genomic_accession=58584255, orientation='minus', exon_count=7, OMIM='', no_hdr0=''),
  102638541 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102638541, CurrentID=0, Status='live', Symbol='Gm35078', Aliases='', description='predicted gene, 35078', other_designations='', map_location='14', chromosome='14', genomic_nucleotide_accession_version='NC_000080.6', start_position_on_the_genomic_accession=47296406, end_position_on_the_genomic_accession=47298405, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  102638546 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102638546, CurrentID=0, Status='live', Symbol='Gm35083', Aliases='', description='predicted gene, 35083', other_designations='', map_location='7', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=118323100, end_position_on_the_genomic_accession=118328651, orientation='minus', exon_count=6, OMIM='', no_hdr0=''),
  102638555 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102638555, CurrentID=0, Status='live', Symbol='Gm38510', Aliases='', description='predicted gene, 38510', other_designations='', map_location='1', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=85156899, end_position_on_the_genomic_accession=85317341, orientation='minus', exon_count=5, OMIM='', no_hdr0=''),
  102638557 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102638557, CurrentID=0, Status='live', Symbol='Gm35091', Aliases='', description='predicted gene, 35091', other_designations='', map_location='16', chromosome='16', genomic_nucleotide_accession_version='NC_000082.6', start_position_on_the_genomic_accession=89247120, end_position_on_the_genomic_accession=89247305, orientation='plus', exon_count=1, OMIM='', no_hdr0=''),
  102638561 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102638561, CurrentID=0, Status='live', Symbol='Gm35095', Aliases='', description='predicted gene, 35095', other_designations='', map_location='9', chromosome='9', genomic_nucleotide_accession_version='NC_000075.6', start_position_on_the_genomic_accession=121701297, end_position_on_the_genomic_accession=121704916, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  102638568 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102638568, CurrentID=0, Status='live', Symbol='Gm35102', Aliases='', description='predicted gene, 35102', other_designations='', map_location='11', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=4740521, end_position_on_the_genomic_accession=4751514, orientation='plus', exon_count=4, OMIM='', no_hdr0=''),
  102638573 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102638573, CurrentID=0, Status='live', Symbol='Gm10477', Aliases='ENSMUSG00000073173', description='predicted gene 10477', other_designations='', map_location='X 30.06 cM', chromosome='X', genomic_nucleotide_accession_version='NC_000086.7', start_position_on_the_genomic_accession=56521599, end_position_on_the_genomic_accession=56525690, orientation='plus', exon_count=4, OMIM='', no_hdr0=''),
  102638577 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102638577, CurrentID=0, Status='live', Symbol='Gm29213', Aliases='', description='predicted gene 29213', other_designations='', map_location='Y', chromosome='Y', genomic_nucleotide_accession_version='NC_000087.7', start_position_on_the_genomic_accession=46858522, end_position_on_the_genomic_accession=46873585, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  102638579 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102638579, CurrentID=0, Status='live', Symbol='Gm28897', Aliases='', description='predicted gene 28897', other_designations='', map_location='Y', chromosome='Y', genomic_nucleotide_accession_version='NC_000087.7', start_position_on_the_genomic_accession=80926978, end_position_on_the_genomic_accession=80953240, orientation='plus', exon_count=10, OMIM='', no_hdr0=''),
  271375 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=271375, CurrentID=0, Status='live', Symbol='Cd200r2', Aliases='AY230198, Cd200r1l', description='Cd200 receptor 2', other_designations='CD200 cell surface glycoprotein receptor|CD200 cell surface glycoprotein receptor-like 2|CD200 cell surface glycoprotein receptor-like c|CD200 receptor-like 2|CD200RLc|cell surface glycoprotein OX2 receptor 2', map_location='16 B4', chromosome='16', genomic_nucleotide_accession_version='NC_000082.6', start_position_on_the_genomic_accession=44867097, end_position_on_the_genomic_accession=44915840, orientation='plus', exon_count=6, OMIM='', no_hdr0=''),
  271377 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=271377, CurrentID=0, Status='live', Symbol='Zbtb11', Aliases='9230110G02Rik, ZNF-U69274', description='zinc finger and BTB domain containing 11', other_designations='', map_location='16 C1.1', chromosome='16', genomic_nucleotide_accession_version='NC_000082.6', start_position_on_the_genomic_accession=55972697, end_position_on_the_genomic_accession=56008913, orientation='plus', exon_count=12, OMIM='', no_hdr0=''),
  102638610 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102638610, CurrentID=0, Status='live', Symbol='Gm35134', Aliases='', description='predicted gene, 35134', other_designations='', map_location='Y', chromosome='Y', genomic_nucleotide_accession_version='NC_000087.7', start_position_on_the_genomic_accession=19114450, end_position_on_the_genomic_accession=19138897, orientation='plus', exon_count=7, OMIM='', no_hdr0=''),
  102638612 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102638612, CurrentID=0, Status='live', Symbol='Gm28879', Aliases='', description='predicted gene 28879', other_designations='', map_location='Y', chromosome='Y', genomic_nucleotide_accession_version='NC_000087.7', start_position_on_the_genomic_accession=27624476, end_position_on_the_genomic_accession=27626944, orientation='plus', exon_count=3, OMIM='', no_hdr0=''),
  664608 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=664608, CurrentID=0, Status='live', Symbol='Rhox4g', Aliases='Rhox4.6, Rhox4.7, Rhox4f', description='reproductive homeobox 4G', other_designations='reproductive homeobox 4F', map_location='X A3.2', chromosome='X', genomic_nucleotide_accession_version='NC_000086.7', start_position_on_the_genomic_accession=37646501, end_position_on_the_genomic_accession=37651327, orientation='minus', exon_count=4, OMIM='', no_hdr0=''),
  664609 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=664609, CurrentID=0, Status='live', Symbol='Rhox4a', Aliases='Rhox4, Rhox4.1', description='reproductive homeobox 4A', other_designations='', map_location='X A3.3', chromosome='X', genomic_nucleotide_accession_version='NC_000086.7', start_position_on_the_genomic_accession=37265318, end_position_on_the_genomic_accession=37270136, orientation='plus', exon_count=4, OMIM='', no_hdr0=''),
  664610 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=664610, CurrentID=0, Status='live', Symbol='Rhox4d', Aliases='Rhox4.4, Rhox4c', description='reproductive homeobox 4D', other_designations='', map_location='X A3.2', chromosome='X', genomic_nucleotide_accession_version='NC_000086.7', start_position_on_the_genomic_accession=37514389, end_position_on_the_genomic_accession=37519176, orientation='plus', exon_count=4, OMIM='', no_hdr0=''),
  102638638 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102638638, CurrentID=0, Status='live', Symbol='Gm14114', Aliases='OTTMUSG00000015697', description='predicted gene 14114', other_designations='', map_location='2 72.63 cM', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=146827212, end_position_on_the_genomic_accession=146840777, orientation='minus', exon_count=7, OMIM='', no_hdr0=''),
  271424 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=271424, CurrentID=0, Status='live', Symbol='Ip6k3', Aliases='D830007E07Rik, Ihpk3', description='inositol hexaphosphate kinase 3', other_designations='insP6 kinase 3', map_location='17 A3.3', chromosome='17', genomic_nucleotide_accession_version='NC_000083.6', start_position_on_the_genomic_accession=27143971, end_position_on_the_genomic_accession=27167764, orientation='minus', exon_count=6, OMIM='', no_hdr0=''),
  102638664 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102638664, CurrentID=0, Status='live', Symbol='Gm35174', Aliases='', description='predicted gene, 35174', other_designations='', map_location='16', chromosome='16', genomic_nucleotide_accession_version='NC_000082.6', start_position_on_the_genomic_accession=89250970, end_position_on_the_genomic_accession=89251267, orientation='plus', exon_count=1, OMIM='', no_hdr0=''),
  102638674 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102638674, CurrentID=0, Status='live', Symbol='LOC102638674', Aliases='', description='zinc finger protein 26-like', other_designations='', map_location='', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=177979700, end_position_on_the_genomic_accession=177985461, orientation='minus', exon_count=4, OMIM='', no_hdr0=''),
  102638680 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102638680, CurrentID=0, Status='live', Symbol='Gm35185', Aliases='', description='predicted gene, 35185', other_designations='', map_location='3', chromosome='3', genomic_nucleotide_accession_version='NC_000069.6', start_position_on_the_genomic_accession=91738353, end_position_on_the_genomic_accession=91740494, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  102638684 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102638684, CurrentID=0, Status='live', Symbol='Gm28656', Aliases='', description='predicted gene 28656', other_designations='', map_location='Y', chromosome='Y', genomic_nucleotide_accession_version='NC_000087.7', start_position_on_the_genomic_accession=12211244, end_position_on_the_genomic_accession=12212668, orientation='plus', exon_count=1, OMIM='', no_hdr0=''),
  102638688 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102638688, CurrentID=0, Status='live', Symbol='Gm28604', Aliases='', description='predicted gene 28604', other_designations='', map_location='Y', chromosome='Y', genomic_nucleotide_accession_version='NC_000087.7', start_position_on_the_genomic_accession=46920938, end_position_on_the_genomic_accession=46936010, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  271457 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=271457, CurrentID=0, Status='live', Symbol='Rab5a', Aliases='2410015H04Rik, AI663973, AU021172, nnyRab5a', description='RAB5A, member RAS oncogene family', other_designations='', map_location='17 27.82 cM', chromosome='17', genomic_nucleotide_accession_version='NC_000083.6', start_position_on_the_genomic_accession=53479234, end_position_on_the_genomic_accession=53507678, orientation='plus', exon_count=6, OMIM='', no_hdr0=''),
  102638696 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102638696, CurrentID=0, Status='live', Symbol='Gm26919', Aliases='', description='predicted gene, 26919', other_designations='', map_location='6', chromosome='6', genomic_nucleotide_accession_version='NC_000072.6', start_position_on_the_genomic_accession=130675432, end_position_on_the_genomic_accession=130677054, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  664703 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=664703, CurrentID=0, Status='live', Symbol='Cypt13', Aliases='', description='cysteine-rich perinuclear theca 13', other_designations='', map_location='X', chromosome='X', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  664705 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=664705, CurrentID=0, Status='live', Symbol='Cypt11', Aliases='', description='cysteine-rich perinuclear theca 11', other_designations='', map_location='X', chromosome='X', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  664723 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=664723, CurrentID=0, Status='live', Symbol='Cypt8', Aliases='', description='cysteine-rich perinuclear theca 8', other_designations='cysteine-rich perinuclear theca protein 8', map_location='', chromosome='X', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  271508 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=271508, CurrentID=0, Status='live', Symbol='4933408B17Rik', Aliases='', description='RIKEN cDNA 4933408B17 gene', other_designations='', map_location='18 B1', chromosome='18', genomic_nucleotide_accession_version='NC_000084.6', start_position_on_the_genomic_accession=34579579, end_position_on_the_genomic_accession=34597594, orientation='minus', exon_count=7, OMIM='', no_hdr0=''),
  664725 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=664725, CurrentID=0, Status='live', Symbol='Cypt7', Aliases='', description='cysteine-rich perinuclear theca 7', other_designations='cysteine-rich perinuclear theca protein 7', map_location='', chromosome='X', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  664726 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=664726, CurrentID=0, Status='live', Symbol='Cypt10', Aliases='', description='cysteine-rich perinuclear theca 10', other_designations='cysteine-rich perinuclear theca protein 10', map_location='', chromosome='9', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  102638745 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102638745, CurrentID=0, Status='live', Symbol='LOC102638745', Aliases='', description='zinc finger protein 431-like', other_designations='', map_location='', chromosome='12', genomic_nucleotide_accession_version='NC_000078.6', start_position_on_the_genomic_accession=23780803, end_position_on_the_genomic_accession=23782230, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  102638754 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102638754, CurrentID=0, Status='live', Symbol='LOC102638754', Aliases='', description='synaptonemal complex protein 2-like', other_designations='', map_location='', chromosome='13', genomic_nucleotide_accession_version='NC_000079.6', start_position_on_the_genomic_accession=41122627, end_position_on_the_genomic_accession=41141854, orientation='plus', exon_count=9, OMIM='', no_hdr0=''),
  102638774 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102638774, CurrentID=0, Status='live', Symbol='Gm35257', Aliases='', description='predicted gene, 35257', other_designations='', map_location='16', chromosome='16', genomic_nucleotide_accession_version='NC_000082.6', start_position_on_the_genomic_accession=89260831, end_position_on_the_genomic_accession=89261208, orientation='plus', exon_count=1, OMIM='', no_hdr0=''),
  102638775 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102638775, CurrentID=0, Status='live', Symbol='Gm21836', Aliases='', description='predicted gene, 21836', other_designations='', map_location='9', chromosome='9', genomic_nucleotide_accession_version='NC_000075.6', start_position_on_the_genomic_accession=124493542, end_position_on_the_genomic_accession=124494646, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  140474 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=140474, CurrentID=0, Status='live', Symbol='Muc4', Aliases='4933405I11Rik, Asgp', description='mucin 4', other_designations='ascites sialoglycoprotein|mucin 4, ASGP|pancreatic adenocarcinoma mucin|testis mucin', map_location='16 B3', chromosome='16', genomic_nucleotide_accession_version='NC_000082.6', start_position_on_the_genomic_accession=32735886, end_position_on_the_genomic_accession=32782391, orientation='plus', exon_count=25, OMIM='', no_hdr0=''),
  140475 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=140475, CurrentID=0, Status='live', Symbol='Bsnd', Aliases='', description='Bartter syndrome, infantile, with sensorineural deafness (Barttin)', other_designations='', map_location='4 C7', chromosome='4', genomic_nucleotide_accession_version='NC_000070.6', start_position_on_the_genomic_accession=106483456, end_position_on_the_genomic_accession=106492243, orientation='minus', exon_count=4, OMIM='', no_hdr0=''),
  140476 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=140476, CurrentID=0, Status='live', Symbol='Strc', Aliases='DFNB16', description='stereocilin', other_designations='', map_location='2 E5', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=121363248, end_position_on_the_genomic_accession=121381370, orientation='minus', exon_count=31, OMIM='', no_hdr0=''),
  140477 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=140477, CurrentID=0, Status='live', Symbol='Dmbx1', Aliases='Atx, Cdmx, Mbx, Otx3', description='diencephalon/mesencephalon homeobox 1', other_designations='diencephalon/mesencephalon-expressed brain homeobox gene 1 protein|dmbx1|homeobox gene Atx|orthodenticle homolog 3|paired-like homeobox protein DMBX1|paired-type homeobox Atx', map_location='4 53.07 cM', chromosome='4', genomic_nucleotide_accession_version='NC_000070.6', start_position_on_the_genomic_accession=115915119, end_position_on_the_genomic_accession=115939926, orientation='minus', exon_count=6, OMIM='', no_hdr0=''),
  140481 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=140481, CurrentID=0, Status='live', Symbol='Man2a2', Aliases='1700052O22Rik, 4931438M07Rik, AI480988, MX, Man IIx', description='mannosidase 2, alpha 2', other_designations='alpha mannosidase IIx|alpha-mannosidase IIx|mannosidase alpha class 2A member 2|mannosidase, alpha, class 2A, member 2|mannosyl-oligosaccharide 1,3-1,6-alpha-mannosidase', map_location='7 D2', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=80349097, end_position_on_the_genomic_accession=80371486, orientation='minus', exon_count=24, OMIM='', no_hdr0=''),
  140482 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=140482, CurrentID=0, Status='live', Symbol='Zfp358', Aliases='Zfend', description='zinc finger protein 358', other_designations='', map_location='8 1.92 cM', chromosome='8', genomic_nucleotide_accession_version='NC_000074.6', start_position_on_the_genomic_accession=3493075, end_position_on_the_genomic_accession=3497208, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  140483 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=140483, CurrentID=0, Status='live', Symbol='Hnmt', Aliases='1500031F01Rik, AI788969', description='histamine N-methyltransferase', other_designations='HMT', map_location='2 A3', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=24002911, end_position_on_the_genomic_accession=24049757, orientation='minus', exon_count=9, OMIM='', no_hdr0=''),
  140484 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=140484, CurrentID=0, Status='live', Symbol='Pofut1', Aliases='O-FucT-1, mKIAA0180', description='protein O-fucosyltransferase 1', other_designations='peptide-O-fucosyltransferase 1', map_location='2 H2', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=153241532, end_position_on_the_genomic_accession=153271029, orientation='plus', exon_count=8, OMIM='', no_hdr0=''),
  140486 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=140486, CurrentID=0, Status='live', Symbol='Igf2bp1', Aliases='AL024068, AW549074, CRD-BP, Crdbp, D030026A21Rik, D11Moh40e, D11Moh45, IMP-1, Neilsen, ZBP-1, Zbp1, mir-3063', description='insulin-like growth factor 2 mRNA binding protein 1', other_designations='IGF-II mRNA-binding protein 1|IGF2 mRNA-binding protein 1|VICKZ family member 1|coding region determinant binding protein|coding region determinant-binding protein|insulin-like growth factor 2 mRNA binding protein 1 dN CRDBP-2|insulin-like growth factor 2 mRNA binding protein 1 deltaN CRDBP|insulin-like growth factor 2, binding protein 1|zipcode binding protein 1|zipcode-binding protein 1', map_location='11 59.08 cM', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=95957163, end_position_on_the_genomic_accession=96005944, orientation='minus', exon_count=15, OMIM='', no_hdr0=''),
  140488 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=140488, CurrentID=0, Status='live', Symbol='Igf2bp3', Aliases='2610101N11Rik, AA522010, AL022933, AU045931, IMP-3, IMP3, Koc13, Neilsen, mimp3', description='insulin-like growth factor 2 mRNA binding protein 3', other_designations='IGF-II mRNA-binding protein 3|IGF2 mRNA-binding protein 3|VICKZ family member 3|insulin-like growth factor 2, binding protein 3|mIMP-3', map_location='6 23.82 cM', chromosome='6', genomic_nucleotide_accession_version='NC_000072.6', start_position_on_the_genomic_accession=49085218, end_position_on_the_genomic_accession=49215009, orientation='minus', exon_count=17, OMIM='', no_hdr0=''),
  102638793 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102638793, CurrentID=0, Status='live', Symbol='Gm29554', Aliases='', description='predicted gene 29554', other_designations='', map_location='Y', chromosome='Y', genomic_nucleotide_accession_version='NC_000087.7', start_position_on_the_genomic_accession=12275358, end_position_on_the_genomic_accession=12306657, orientation='plus', exon_count=7, OMIM='', no_hdr0=''),
  140491 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=140491, CurrentID=0, Status='live', Symbol='Ppp1r3a', Aliases='GM, RG1, RGL', description='protein phosphatase 1, regulatory (inhibitor) subunit 3A', other_designations='protein phosphatase 1 glycogen-associated regulatory subunit|protein phosphatase type-1 glycogen targeting subunit', map_location='6 A2', chromosome='6', genomic_nucleotide_accession_version='NC_000072.6', start_position_on_the_genomic_accession=14713822, end_position_on_the_genomic_accession=14755274, orientation='minus', exon_count=4, OMIM='', no_hdr0=''),
  140492 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=140492, CurrentID=0, Status='live', Symbol='Kcnn2', Aliases='KCa2.2, SK2, SKCA2, bc, fri', description='potassium intermediate/small conductance calcium-activated channel, subfamily N, member 2', other_designations='bouncy|small conductance calcium-activated potassium channel subfamily N member 2', map_location='18 C', chromosome='18', genomic_nucleotide_accession_version='NC_000084.6', start_position_on_the_genomic_accession=45268764, end_position_on_the_genomic_accession=45685887, orientation='plus', exon_count=13, OMIM='', no_hdr0=''),
  140493 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=140493, CurrentID=0, Status='live', Symbol='Kcnn3', Aliases='KCa2.3, SK3, SKCA3', description='potassium intermediate/small conductance calcium-activated channel, subfamily N, member 3', other_designations='SKCa 3|small conductance calcium-activated potassium channel 3', map_location='3 F2', chromosome='3', genomic_nucleotide_accession_version='NC_000069.6', start_position_on_the_genomic_accession=89520164, end_position_on_the_genomic_accession=89672494, orientation='plus', exon_count=8, OMIM='', no_hdr0=''),
  140494 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=140494, CurrentID=0, Status='live', Symbol='Atp6v0a4', Aliases='Atp6n1b, a4', description='ATPase, H+ transporting, lysosomal V0 subunit A4', other_designations='ATPase, H+ transporting, lysosomal (vacuolar proton pump) noncatalytic accessory protein 1B|V-ATPase 116 kDa|V-ATPase alpha 4|V-type proton ATPase 116 kDa subunit a|vacuolar proton translocating ATPase 100 kDa a4 subunit|vacuolar proton translocating ATPase 116 kDa subunit a kidney isoform', map_location='6 B1', chromosome='6', genomic_nucleotide_accession_version='NC_000072.6', start_position_on_the_genomic_accession=38048483, end_position_on_the_genomic_accession=38124586, orientation='minus', exon_count=21, OMIM='', no_hdr0=''),
  664783 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=664783, CurrentID=0, Status='live', Symbol='Dux', Aliases='AW8220734, Duxbl, EG664783, Dux', description='double homeobox', other_designations='homeobox protein', map_location='10', chromosome='10', genomic_nucleotide_accession_version='NC_000076.5', start_position_on_the_genomic_accession=57693399, end_position_on_the_genomic_accession=57695423, orientation='minus', exon_count=1, OMIM='', no_hdr0=''),
  140497 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=140497, CurrentID=0, Status='live', Symbol='AF251705', Aliases='CLM4, Cd300c, Cd300d, DIgR1, Igsf7, Lmir2, MAIR-II', description='cDNA sequence AF251705', other_designations='CLM|Cd300C antigen|Cd300D antigen|MAIR-2|dendritic cell-derived Ig-like receptor 1|dendritic cell-derived immunoglobulin receptor 1|immunoglobulin superfamily member 7|immunoglobulin superfamily, member 7|leukocyte mono-Ig-like receptor 2|myeloid-associated immunoglobulin-like receptor 2|myeloid-associated immunoglobulin-like receptor II', map_location='11 80.57 cM', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=114996721, end_position_on_the_genomic_accession=115004357, orientation='minus', exon_count=7, OMIM='', no_hdr0=''),
  140498 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=140498, CurrentID=0, Status='live', Symbol='Rxfp2', Aliases='Gpr106, Great, Lgr8', description='relaxin/insulin-like family peptide receptor 2', other_designations='G protein coupled receptor affecting testicular descent|G protein-coupled receptor 106|leucine-rich repeat-containing G protein-coupled receptor 8', map_location='5 89.23 cM', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=150017781, end_position_on_the_genomic_accession=150082550, orientation='plus', exon_count=22, OMIM='', no_hdr0=''),
  140499 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=140499, CurrentID=0, Status='live', Symbol='Ube2j2', Aliases='1200007B18Rik, 2400008G19Rik, 5730472G04Rik, AL022923, NCUBE-2, Ubc6, Ubc6p', description='ubiquitin-conjugating enzyme E2J 2', other_designations='Ubc6p homolog|non-canonical ubiquitin-conjugating enzyme 2|ubiquitin conjugating enzyme 6|ubiquitin-conjugating enzyme E2, J2 homolog', map_location='4 87.66 cM', chromosome='4', genomic_nucleotide_accession_version='NC_000070.6', start_position_on_the_genomic_accession=155943813, end_position_on_the_genomic_accession=155959604, orientation='plus', exon_count=9, OMIM='', no_hdr0=''),
  140500 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=140500, CurrentID=0, Status='live', Symbol='Acap3', Aliases='Centb5, Kiaa1716-hp, mKIAA1716', description='ArfGAP with coiled-coil, ankyrin repeat and PH domains 3', other_designations='centaurin, beta 5', map_location='4 87.66 cM', chromosome='4', genomic_nucleotide_accession_version='NC_000070.6', start_position_on_the_genomic_accession=155891875, end_position_on_the_genomic_accession=155907251, orientation='plus', exon_count=26, OMIM='', no_hdr0=''),
  102638806 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102638806, CurrentID=0, Status='live', Symbol='Gm35283', Aliases='', description='predicted gene, 35283', other_designations='', map_location='15', chromosome='15', genomic_nucleotide_accession_version='NC_000081.6', start_position_on_the_genomic_accession=76206445, end_position_on_the_genomic_accession=76211922, orientation='plus', exon_count=3, OMIM='', no_hdr0=''),
  664799 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=664799, CurrentID=0, Status='live', Symbol='Ctcfl', Aliases='Boris, OTTMUSG00000016680', description='CCCTC-binding factor (zinc finger protein)-like', other_designations='BORIS|Brother of the regulator of imprinted sites|CTCF paralog|CTCF-like protein|likely orthologue of H. sapiens CCCTC-binding factor-like protein (CTCFL)', map_location='2 H3', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=173093609, end_position_on_the_genomic_accession=173119525, orientation='minus', exon_count=11, OMIM='', no_hdr0=''),
  664804 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=664804, CurrentID=0, Status='live', Symbol='Gm7347', Aliases='EG664804', description='predicted gene 7347', other_designations='', map_location='5 B1', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=26049846, end_position_on_the_genomic_accession=26059600, orientation='minus', exon_count=5, OMIM='', no_hdr0=''),
  664805 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=664805, CurrentID=0, Status='live', Symbol='Skor2', Aliases='Corl2, EG664805, Fussel18, Gm7348', description='SKI family transcriptional corepressor 2', other_designations='LBX1 corepressor 1-like protein|functional Smad suppressor element on chromosome 18|fussel-18 homolog|ladybird homeobox corepressor 1-like protein|transcriptional corepressor Corl2', map_location='18 E3', chromosome='18', genomic_nucleotide_accession_version='NC_000084.6', start_position_on_the_genomic_accession=76846734, end_position_on_the_genomic_accession=76901032, orientation='plus', exon_count=10, OMIM='', no_hdr0=''),
  102638829 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102638829, CurrentID=0, Status='live', Symbol='Gm21779', Aliases='', description='predicted gene, 21779', other_designations='', map_location='Y', chromosome='Y', genomic_nucleotide_accession_version='NC_000087.7', start_position_on_the_genomic_accession=45385512, end_position_on_the_genomic_accession=45387930, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  664821 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=664821, CurrentID=0, Status='live', Symbol='Gm7356', Aliases='EG664821', description='predicted gene 7356', other_designations='', map_location='17 A2', chromosome='17', genomic_nucleotide_accession_version='NC_000083.6', start_position_on_the_genomic_accession=14000224, end_position_on_the_genomic_accession=14003393, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  664829 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=664829, CurrentID=0, Status='live', Symbol='Slx', Aliases='EG664958, Xmr', description='Sycp3 like X-linked', other_designations='', map_location='X A2', chromosome='X', genomic_nucleotide_accession_version='NC_000086.7', start_position_on_the_genomic_accession=26522657, end_position_on_the_genomic_accession=26545565, orientation='minus', exon_count=9, OMIM='', no_hdr0=''),
  664831 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=664831, CurrentID=0, Status='live', Symbol='Gm7358', Aliases='EG664831', description='predicted gene 7358', other_designations='', map_location='17 A2', chromosome='17', genomic_nucleotide_accession_version='NC_000083.6', start_position_on_the_genomic_accession=14057990, end_position_on_the_genomic_accession=14061201, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  140546 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=140546, CurrentID=0, Status='live', Symbol='Eri3', Aliases='PINT1, Prnpip1', description='exoribonuclease 3', other_designations='prion interactor 1|prion protein interacting protein 1|prion protein-interacting protein', map_location='4 D1', chromosome='4', genomic_nucleotide_accession_version='NC_000070.6', start_position_on_the_genomic_accession=117550293, end_position_on_the_genomic_accession=117674297, orientation='plus', exon_count=15, OMIM='', no_hdr0=''),
  664837 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=664837, CurrentID=0, Status='live', Symbol='Gm7361', Aliases='', description='predicted gene 7361', other_designations='', map_location='5 B1', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=26167708, end_position_on_the_genomic_accession=26264312, orientation='plus', exon_count=14, OMIM='', no_hdr0=''),
  329260 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=329260, CurrentID=0, Status='live', Symbol='Dennd1b', Aliases='4632404N19Rik, 4930467M19Rik, 6820401H01Rik, F730008N07Rik', description='DENN/MADD domain containing 1B', other_designations='ASL1/9AS1-1 fusion|connecdenn 2', map_location='1 F', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=138963446, end_position_on_the_genomic_accession=139176043, orientation='plus', exon_count=24, OMIM='', no_hdr0=''),
  664844 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=664844, CurrentID=0, Status='live', Symbol='Gm7365', Aliases='', description='predicted gene 7365', other_designations='', map_location='X', chromosome='X', genomic_nucleotide_accession_version='NC_000086.7', start_position_on_the_genomic_accession=26990271, end_position_on_the_genomic_accession=27011645, orientation='minus', exon_count=8, OMIM='', no_hdr0=''),
  140557 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=140557, CurrentID=0, Status='live', Symbol='Smc1b', Aliases='SMC-1B, SMC1beta, Smc1l2', description='structural maintenance of chromosomes 1B', other_designations='SMC protein 1B|SMC-1-beta|structural maintenace of chromosomes 1B', map_location='15 E3', chromosome='15', genomic_nucleotide_accession_version='NC_000081.6', start_position_on_the_genomic_accession=85064689, end_position_on_the_genomic_accession=85131957, orientation='minus', exon_count=25, OMIM='', no_hdr0=''),
  102638862 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102638862, CurrentID=0, Status='live', Symbol='Gm35324', Aliases='', description='predicted gene, 35324', other_designations='', map_location='X', chromosome='X', genomic_nucleotide_accession_version='NC_000086.7', start_position_on_the_genomic_accession=93253855, end_position_on_the_genomic_accession=93285177, orientation='minus', exon_count=20, OMIM='', no_hdr0=''),
  140559 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=140559, CurrentID=0, Status='live', Symbol='Igsf8', Aliases='ESTM34, EWI-2, KCT-4, PGRL', description='immunoglobulin superfamily, member 8', other_designations='CD81 partner 3|PG regulatory-like protein|glu-Trp-Ile EWI motif-containing protein 2|keratinocyte-associated transmembrane protein 4|prostaglandin regulatory-like protein', map_location='1 79.59 cM', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=172312407, end_position_on_the_genomic_accession=172319841, orientation='plus', exon_count=7, OMIM='', no_hdr0=''),
  102638870 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102638870, CurrentID=0, Status='live', Symbol='Gm29546', Aliases='', description='predicted gene 29546', other_designations='', map_location='Y', chromosome='Y', genomic_nucleotide_accession_version='NC_000087.7', start_position_on_the_genomic_accession=62715593, end_position_on_the_genomic_accession=62741845, orientation='plus', exon_count=8, OMIM='', no_hdr0=''),
  102638871 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102638871, CurrentID=0, Status='live', Symbol='Gm21720', Aliases='', description='predicted gene, 21720', other_designations='', map_location='Y', chromosome='Y', genomic_nucleotide_accession_version='NC_000087.7', start_position_on_the_genomic_accession=88952363, end_position_on_the_genomic_accession=88953061, orientation='minus', exon_count=1, OMIM='', no_hdr0=''),
  140570 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=140570, CurrentID=0, Status='live', Symbol='Plxnb2', Aliases='Debt, plexin-B2', description='plexin B2', other_designations='differentially expressed in brain tumors', map_location='15 44.68 cM', chromosome='15', genomic_nucleotide_accession_version='NC_000081.6', start_position_on_the_genomic_accession=89155546, end_position_on_the_genomic_accession=89181140, orientation='minus', exon_count=40, OMIM='', no_hdr0=''),
  140571 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=140571, CurrentID=0, Status='live', Symbol='Plxnb3', Aliases='AI451018, Plxn6', description='plexin B3', other_designations='plexin 6|plexin-6', map_location='X A7.3', chromosome='X', genomic_nucleotide_accession_version='NC_000086.7', start_position_on_the_genomic_accession=73756559, end_position_on_the_genomic_accession=73772510, orientation='plus', exon_count=33, OMIM='', no_hdr0=''),
  140577 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=140577, CurrentID=0, Status='live', Symbol='Ankrd6', Aliases='', description='ankyrin repeat domain 6', other_designations='diversin', map_location='4 A5', chromosome='4', genomic_nucleotide_accession_version='NC_000070.6', start_position_on_the_genomic_accession=32804027, end_position_on_the_genomic_accession=32950884, orientation='minus', exon_count=21, OMIM='', no_hdr0=''),
  102638882 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102638882, CurrentID=0, Status='live', Symbol='Gm35339', Aliases='Wdr97', description='predicted gene, 35339', other_designations='', map_location='15', chromosome='15', genomic_nucleotide_accession_version='NC_000081.6', start_position_on_the_genomic_accession=76354449, end_position_on_the_genomic_accession=76363853, orientation='plus', exon_count=24, OMIM='', no_hdr0=''),
  140579 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=140579, CurrentID=0, Status='live', Symbol='Elmo2', Aliases='1190002F24Rik, CED-12', description='engulfment and cell motility 2', other_designations='CED-12 homolog A', map_location='2 H3', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=165288031, end_position_on_the_genomic_accession=165326479, orientation='minus', exon_count=24, OMIM='', no_hdr0=''),
  140580 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=140580, CurrentID=0, Status='live', Symbol='Elmo1', Aliases='6330578D22Rik, C230095H21Rik, CED-12', description='engulfment and cell motility 1', other_designations='engulfment and cell motility 1, ced-12 homolog', map_location='13 A3.1', chromosome='13', genomic_nucleotide_accession_version='NC_000079.6', start_position_on_the_genomic_accession=20090240, end_position_on_the_genomic_accession=20608353, orientation='plus', exon_count=26, OMIM='', no_hdr0=''),
  402725 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=402725, CurrentID=0, Status='live', Symbol='C530045E16Rik', Aliases='', description='RIKEN cDNA C530045E16 gene', other_designations='', map_location='1', chromosome='1', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  402726 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=402726, CurrentID=0, Status='live', Symbol='A630028G03Rik', Aliases='', description='RIKEN cDNA A630028G03 gene', other_designations='', map_location='11', chromosome='11', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  102638887 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102638887, CurrentID=0, Status='live', Symbol='Gm35342', Aliases='', description='predicted gene, 35342', other_designations='', map_location='16', chromosome='16', genomic_nucleotide_accession_version='NC_000082.6', start_position_on_the_genomic_accession=89274509, end_position_on_the_genomic_accession=89274667, orientation='plus', exon_count=1, OMIM='', no_hdr0=''),
  102638888 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102638888, CurrentID=0, Status='live', Symbol='LOC102638888', Aliases='', description='uncharacterized LOC102638888', other_designations='', map_location='', chromosome='9', genomic_nucleotide_accession_version='NC_000075.6', start_position_on_the_genomic_accession=62341502, end_position_on_the_genomic_accession=62344600, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  402729 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=402729, CurrentID=0, Status='live', Symbol='9330184L24Rik', Aliases='', description='RIKEN cDNA 9330184L24 gene', other_designations='', map_location='X', chromosome='X', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  102638890 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102638890, CurrentID=0, Status='live', Symbol='LOC102638890', Aliases='', description='uncharacterized LOC102638890', other_designations='', map_location='', chromosome='10', genomic_nucleotide_accession_version='NC_000076.6', start_position_on_the_genomic_accession=24331374, end_position_on_the_genomic_accession=24595204, orientation='minus', exon_count=23, OMIM='', no_hdr0=''),
  613255 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=613255, CurrentID=0, Status='live', Symbol='AV226208', Aliases='', description='expressed sequence AV226208', other_designations='', map_location='', chromosome='3', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  402732 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=402732, CurrentID=0, Status='live', Symbol='A030012G06Rik', Aliases='', description='RIKEN cDNA A030012G06 gene', other_designations='', map_location='9', chromosome='9', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  402733 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=402733, CurrentID=0, Status='live', Symbol='A930009L07Rik', Aliases='', description='RIKEN cDNA A930009L07 gene', other_designations='', map_location='15', chromosome='15', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  402735 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=402735, CurrentID=0, Status='live', Symbol='B230114P17Rik', Aliases='', description='RIKEN cDNA B230114P17 gene', other_designations='', map_location='10', chromosome='10', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  102638896 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102638896, CurrentID=0, Status='live', Symbol='Gm35348', Aliases='', description='predicted gene, 35348', other_designations='', map_location='18', chromosome='18', genomic_nucleotide_accession_version='NC_000084.6', start_position_on_the_genomic_accession=36515548, end_position_on_the_genomic_accession=36516716, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  402737 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=402737, CurrentID=0, Status='live', Symbol='A130014A01Rik', Aliases='', description='RIKEN cDNA A130014A01 gene', other_designations='', map_location='8', chromosome='8', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  402738 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=402738, CurrentID=0, Status='live', Symbol='B230308H17Rik', Aliases='', description='RIKEN cDNA B230308H17 gene', other_designations='', map_location='8', chromosome='8', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  664883 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=664883, CurrentID=0, Status='live', Symbol='Nova1', Aliases='9430099M15Rik, G630039L02, Nova-1', description='neuro-oncological ventral antigen 1', other_designations='ventral neuron-specific protein 1', map_location='12 21.46 cM', chromosome='12', genomic_nucleotide_accession_version='NC_000078.6', start_position_on_the_genomic_accession=46694517, end_position_on_the_genomic_accession=46819194, orientation='minus', exon_count=10, OMIM='', no_hdr0=''),
  402740 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=402740, CurrentID=0, Status='live', Symbol='C030010F05Rik', Aliases='', description='RIKEN cDNA C030010F05 gene', other_designations='', map_location='13', chromosome='13', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  402741 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=402741, CurrentID=0, Status='live', Symbol='C030004N09Rik', Aliases='', description='RIKEN cDNA C030004N09 gene', other_designations='', map_location='4', chromosome='4', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  402742 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=402742, CurrentID=0, Status='live', Symbol='C130013N14Rik', Aliases='', description='RIKEN cDNA C130013N14 gene', other_designations='', map_location='1', chromosome='1', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  402743 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=402743, CurrentID=0, Status='live', Symbol='C130063K03Rik', Aliases='', description='RIKEN cDNA C130063K03 gene', other_designations='', map_location='2', chromosome='2', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  402744 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=402744, CurrentID=0, Status='live', Symbol='C130076G22Rik', Aliases='', description='RIKEN cDNA C130076G22 gene', other_designations='', map_location='19', chromosome='19', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  402745 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=402745, CurrentID=0, Status='live', Symbol='E430022E14Rik', Aliases='', description='RIKEN cDNA E430022E14 gene', other_designations='', map_location='8', chromosome='8', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  102638906 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102638906, CurrentID=0, Status='live', Symbol='Gm29300', Aliases='', description='predicted gene 29300', other_designations='', map_location='Y', chromosome='Y', genomic_nucleotide_accession_version='NC_000087.7', start_position_on_the_genomic_accession=55110002, end_position_on_the_genomic_accession=55112332, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  402749 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=402749, CurrentID=0, Status='live', Symbol='B430316J06Rik', Aliases='', description='RIKEN cDNA B430316J06 gene', other_designations='', map_location='6', chromosome='6', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  402750 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=402750, CurrentID=0, Status='live', Symbol='C130057G02Rik', Aliases='', description='RIKEN cDNA C130057G02 gene', other_designations='', map_location='14', chromosome='14', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  402751 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=402751, CurrentID=0, Status='live', Symbol='C430019N01Rik', Aliases='', description='RIKEN cDNA C430019N01 gene', other_designations='', map_location='5', chromosome='5', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  402752 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=402752, CurrentID=0, Status='live', Symbol='C130068B02Rik', Aliases='', description='RIKEN cDNA C130068B02 gene', other_designations='', map_location='17', chromosome='17', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  402753 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=402753, CurrentID=0, Status='live', Symbol='D630033A02Rik', Aliases='', description='RIKEN cDNA D630033A02 gene', other_designations='', map_location='10 D2', chromosome='10', genomic_nucleotide_accession_version='NC_000076.5', start_position_on_the_genomic_accession=122421996, end_position_on_the_genomic_accession=122422881, orientation='minus', exon_count=1, OMIM='', no_hdr0=''),
  402754 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=402754, CurrentID=0, Status='live', Symbol='5930427L02Rik', Aliases='', description='RIKEN cDNA 5930427L02 gene', other_designations='', map_location='9', chromosome='9', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  402755 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=402755, CurrentID=0, Status='live', Symbol='6030487A22Rik', Aliases='', description='RIKEN cDNA 6030487A22 gene', other_designations='', map_location='X', chromosome='X', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  402756 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=402756, CurrentID=0, Status='live', Symbol='6030495B02Rik', Aliases='', description='RIKEN cDNA 6030495B02 gene', other_designations='', map_location='1', chromosome='1', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  402758 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=402758, CurrentID=0, Status='live', Symbol='A330074H02Rik', Aliases='', description='RIKEN cDNA A330074H02 gene', other_designations='', map_location='7', chromosome='7', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  402759 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=402759, CurrentID=0, Status='live', Symbol='A330087D11Rik', Aliases='', description='RIKEN cDNA A330087D11 gene', other_designations='', map_location='7', chromosome='7', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  402760 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=402760, CurrentID=0, Status='live', Symbol='A430050A11Rik', Aliases='', description='RIKEN cDNA A430050A11 gene', other_designations='', map_location='1', chromosome='1', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  402761 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=402761, CurrentID=0, Status='live', Symbol='A530064N14Rik', Aliases='', description='RIKEN cDNA A530064N14 gene', other_designations='', map_location='9', chromosome='9', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  402762 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=402762, CurrentID=0, Status='live', Symbol='A630039O03Rik', Aliases='', description='RIKEN cDNA A630039O03 gene', other_designations='', map_location='3', chromosome='3', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  402763 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=402763, CurrentID=0, Status='live', Symbol='A630073K07Rik', Aliases='', description='RIKEN cDNA A630073K07 gene', other_designations='', map_location='2', chromosome='2', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  402764 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=402764, CurrentID=0, Status='live', Symbol='6030403N03Rik', Aliases='', description='RIKEN cDNA 6030403N03 gene', other_designations='', map_location='7', chromosome='7', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  402765 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=402765, CurrentID=0, Status='live', Symbol='6030422H21Rik', Aliases='', description='RIKEN cDNA 6030422H21 gene', other_designations='', map_location='17', chromosome='17', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  402766 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=402766, CurrentID=0, Status='live', Symbol='7030407A21Rik', Aliases='', description='RIKEN cDNA 7030407A21 gene', other_designations='', map_location='7', chromosome='7', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  402768 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=402768, CurrentID=0, Status='live', Symbol='B230209G03Rik', Aliases='', description='RIKEN cDNA B230209G03 gene', other_designations='', map_location='2', chromosome='2', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  271697 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=271697, CurrentID=0, Status='live', Symbol='Cdk15', Aliases='Als2cr7, Pftk2', description='cyclin-dependent kinase 15', other_designations='PFTAIRE protein kinase 2|amyotrophic lateral sclerosis 2 (juvenile) chromosome region, candidate 7|amyotrophic lateral sclerosis 2 chromosomal region candidate gene 7 protein homolog|cell division protein kinase 15|serine/threonine-protein kinase ALS2CR7|serine/threonine-protein kinase PFTAIRE-2', map_location='1 C1.3', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=59256889, end_position_on_the_genomic_accession=59352612, orientation='plus', exon_count=15, OMIM='', no_hdr0=''),
  402770 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=402770, CurrentID=0, Status='live', Symbol='C130083A15Rik', Aliases='', description='RIKEN cDNA C130083A15 gene', other_designations='', map_location='7', chromosome='7', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  402771 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=402771, CurrentID=0, Status='live', Symbol='C130090I23Rik', Aliases='', description='RIKEN cDNA C130090I23 gene', other_designations='', map_location='17', chromosome='17', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  402772 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=402772, CurrentID=0, Status='live', Symbol='C130098B18Rik', Aliases='', description='RIKEN cDNA C130098B18 gene', other_designations='', map_location='15', chromosome='15', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  140629 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=140629, CurrentID=0, Status='live', Symbol='Ubox5', Aliases='1500010O06Rik, C330018L13Rik, Rnf37, UIP5, Ubce7ip5, Ube7ip5', description='U box domain containing 5', other_designations='U-box domain-containing protein 5|UbcM4-interacting protein 5|ubiquitin conjugating enzyme 7 interacting protein 5|ubiquitin-conjugating enzyme 7-interacting protein 5', map_location='2 F3', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=130589996, end_position_on_the_genomic_accession=130630038, orientation='minus', exon_count=7, OMIM='', no_hdr0=''),
  140630 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=140630, CurrentID=0, Status='live', Symbol='Ube4a', Aliases='4732444G18Rik, 9930123J21Rik, UFD2b', description='ubiquitination factor E4A', other_designations='ubiquitination factor E4A, UFD2 homolog', map_location='9 A5.2', chromosome='9', genomic_nucleotide_accession_version='NC_000075.6', start_position_on_the_genomic_accession=44923127, end_position_on_the_genomic_accession=44965600, orientation='minus', exon_count=22, OMIM='', no_hdr0=''),
  402775 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=402775, CurrentID=0, Status='live', Symbol='D130095D21Rik', Aliases='', description='RIKEN cDNA D130095D21 gene', other_designations='', map_location='12', chromosome='12', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  329274 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=329274, CurrentID=0, Status='live', Symbol='Fam163a', Aliases='A230106N23Rik', description='family with sequence similarity 163, member A', other_designations='cebelin', map_location='1 G3', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=156075956, end_position_on_the_genomic_accession=156087888, orientation='minus', exon_count=4, OMIM='', no_hdr0=''),
  271711 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=271711, CurrentID=0, Status='live', Symbol='Tmem169', Aliases='A830020B06Rik', description='transmembrane protein 169', other_designations='', map_location='1 C3', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=72284362, end_position_on_the_genomic_accession=72303104, orientation='plus', exon_count=4, OMIM='', no_hdr0=''),
  664930 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=664930, CurrentID=0, Status='live', Symbol='Gm7410', Aliases='EG664930', description='predicted gene 7410', other_designations='', map_location='16 C2', chromosome='16', genomic_nucleotide_accession_version='NC_000082.5', start_position_on_the_genomic_accession=70226222, end_position_on_the_genomic_accession=70238963, orientation='plus', exon_count=3, OMIM='', no_hdr0=''),
  67134 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=67134, CurrentID=0, Status='live', Symbol='Nop56', Aliases='2310044F10Rik, Nol5a', description='NOP56 ribonucleoprotein', other_designations='56kDa with KKE/D repeat|NOP56 ribonucleoprotein homolog|nucleolar protein 5A', map_location='2 F3', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=130274367, end_position_on_the_genomic_accession=130279313, orientation='plus', exon_count=13, OMIM='', no_hdr0=''),
  102638978 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102638978, CurrentID=0, Status='live', Symbol='Gm35410', Aliases='', description='predicted gene, 35410', other_designations='', map_location='3', chromosome='3', genomic_nucleotide_accession_version='NC_000069.6', start_position_on_the_genomic_accession=84582329, end_position_on_the_genomic_accession=84584487, orientation='plus', exon_count=1, OMIM='', no_hdr0=''),
  664964 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=664964, CurrentID=0, Status='live', Symbol='Gm7427', Aliases='', description='predicted gene 7427', other_designations='', map_location='X A3.1', chromosome='X', genomic_nucleotide_accession_version='NC_000086.6', start_position_on_the_genomic_accession=28842648, end_position_on_the_genomic_accession=28898308, orientation='plus', exon_count=3, OMIM='', no_hdr0=''),
  664968 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=664968, CurrentID=0, Status='live', Symbol='Tmem238', Aliases='2210411K11Rik', description='transmembrane protein 238', other_designations='', map_location='7 A1', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=4784785, end_position_on_the_genomic_accession=4789560, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  664969 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=664969, CurrentID=0, Status='live', Symbol='Gm7429', Aliases='EG664969', description='predicted pseudogene 7429', other_designations='', map_location='X E1', chromosome='X', genomic_nucleotide_accession_version='NC_000086.7', start_position_on_the_genomic_accession=114980925, end_position_on_the_genomic_accession=114981385, orientation='minus', exon_count=1, OMIM='', no_hdr0=''),
  664976 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=664976, CurrentID=0, Status='live', Symbol='Gm7433', Aliases='EG664976', description='predicted gene 7433', other_designations='', map_location='11 D', chromosome='11', genomic_nucleotide_accession_version='NC_000077.5', start_position_on_the_genomic_accession=91286072, end_position_on_the_genomic_accession=91287591, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  664982 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=664982, CurrentID=0, Status='live', Symbol='Gm7437', Aliases='', description='predicted gene 7437', other_designations='', map_location='X', chromosome='X', genomic_nucleotide_accession_version='NC_000086.6', start_position_on_the_genomic_accession=29527778, end_position_on_the_genomic_accession=29577917, orientation='plus', exon_count=3, OMIM='', no_hdr0=''),
  30872 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=30872, CurrentID=0, Status='live', Symbol='C76453', Aliases='', description='EST C76453', other_designations='', map_location='', chromosome='14', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  664987 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=664987, CurrentID=0, Status='live', Symbol='Gm14393', Aliases='OTTMUSG00000016546', description='predicted gene 14393', other_designations='', map_location='2 H4', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=175060350, end_position_on_the_genomic_accession=175067769, orientation='minus', exon_count=4, OMIM='', no_hdr0=''),
  140703 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=140703, CurrentID=0, Status='live', Symbol='Emid1', Aliases='AW122071, CO-5, Emu1', description='EMI domain containing 1', other_designations='Emu1|emilin and multimerin domain-containing protein 1', map_location='11 A1', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=5106265, end_position_on_the_genomic_accession=5152298, orientation='minus', exon_count=21, OMIM='', no_hdr0=''),
  664994 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=664994, CurrentID=0, Status='live', Symbol='Isoc2a', Aliases='Isoc2', description='isochorismatase domain containing 2a', other_designations='isoc2a|isochorismatase domain-containing protein 2A, mitochondrial', map_location='7 A1', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=4877053, end_position_on_the_genomic_accession=4895717, orientation='plus', exon_count=6, OMIM='', no_hdr0=''),
  664996 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=664996, CurrentID=0, Status='live', Symbol='Gm7440', Aliases='', description='predicted gene 7440', other_designations='', map_location='X A3.1', chromosome='X', genomic_nucleotide_accession_version='NC_000086.6', start_position_on_the_genomic_accession=29841376, end_position_on_the_genomic_accession=29891525, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  140709 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=140709, CurrentID=0, Status='live', Symbol='Col26a1', Aliases='9430032K24Rik, BC002218, Col26a, Emid2, Emu2', description='collagen, type XXVI, alpha 1', other_designations='Collagen XXVI|EMI domain containing 2|EMI domain-containing protein 2|Emu2|alpha-1 type XXVI collagen|emilin and multimerin domain-containing protein 2|procollagen, type XXVI, alpha 1', map_location='5 G1', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=136741759, end_position_on_the_genomic_accession=136883376, orientation='minus', exon_count=19, OMIM='', no_hdr0=''),
  665001 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=665001, CurrentID=0, Status='live', Symbol='Gm14391', Aliases='OTTMUSG00000016543', description='predicted gene 14391', other_designations='', map_location='2', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=175185165, end_position_on_the_genomic_accession=175206924, orientation='minus', exon_count=6, OMIM='', no_hdr0=''),
  271786 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=271786, CurrentID=0, Status='live', Symbol='Galnt13', Aliases='A230002A12, A230020F20, BB182356', description='UDP-N-acetyl-alpha-D-galactosamine:polypeptide N-acetylgalactosaminyltransferase 13', other_designations='UDP-GalNAc:polypeptide N-acetylgalactosaminyltransferase 13|galNAc-T13|polypeptide GalNAc transferase 13|pp-GaNTase 13|pp-GalNAc-T13|protein-UDP acetylgalactosaminyltransferase 13', map_location='2 C1.1', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=54436387, end_position_on_the_genomic_accession=55118309, orientation='plus', exon_count=18, OMIM='', no_hdr0=''),
  102639021 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102639021, CurrentID=0, Status='live', Symbol='LOC102639021', Aliases='', description='zinc finger protein 69-like', other_designations='', map_location='', chromosome='12', genomic_nucleotide_accession_version='NC_000078.6', start_position_on_the_genomic_accession=20071570, end_position_on_the_genomic_accession=20111404, orientation='plus', exon_count=4, OMIM='', no_hdr0=''),
  102639024 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102639024, CurrentID=0, Status='live', Symbol='Gm28489', Aliases='', description='predicted gene 28489', other_designations='', map_location='Y', chromosome='Y', genomic_nucleotide_accession_version='NC_000087.7', start_position_on_the_genomic_accession=31464017, end_position_on_the_genomic_accession=31467753, orientation='plus', exon_count=4, OMIM='', no_hdr0=''),
  140721 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=140721, CurrentID=0, Status='live', Symbol='Caskin2', Aliases='1600028L06Rik, mKIAA1139', description='CASK-interacting protein 2', other_designations='', map_location='11 E2', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=115799183, end_position_on_the_genomic_accession=115813592, orientation='minus', exon_count=21, OMIM='', no_hdr0=''),
  140723 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=140723, CurrentID=0, Status='live', Symbol='Cacng5', Aliases='', description='calcium channel, voltage-dependent, gamma subunit 5', other_designations='TARP gamma-5|neuronal voltage-gated calcium channel gamma-5 subunit|transmembrane AMPAR regulatory protein gamma-5|voltage dependent calcium channel gamma 5 subunit', map_location='11 E1', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=107874604, end_position_on_the_genomic_accession=107915055, orientation='minus', exon_count=8, OMIM='', no_hdr0=''),
  665020 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=665020, CurrentID=0, Status='live', Symbol='LOC665020', Aliases='', description='uncharacterized LOC665020', other_designations='', map_location='5 C3.3', chromosome='5', genomic_nucleotide_accession_version='NT_166303.1', start_position_on_the_genomic_accession=39930, end_position_on_the_genomic_accession=42724, orientation='plus', exon_count=3, OMIM='', no_hdr0=''),
  102639037 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102639037, CurrentID=0, Status='live', Symbol='LOC102639037', Aliases='', description='uncharacterized LOC102639037', other_designations='', map_location='', chromosome='14', genomic_nucleotide_accession_version='NC_000080.6', start_position_on_the_genomic_accession=41767172, end_position_on_the_genomic_accession=41772477, orientation='minus', exon_count=5, OMIM='', no_hdr0=''),
  140740 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=140740, CurrentID=0, Status='live', Symbol='Sec63', Aliases='5730478J10Rik, AI649014, AW319215', description='SEC63-like (S. cerevisiae)', other_designations='', map_location='10 22.89 cM', chromosome='10', genomic_nucleotide_accession_version='NC_000076.6', start_position_on_the_genomic_accession=42761496, end_position_on_the_genomic_accession=42832514, orientation='plus', exon_count=21, OMIM='', no_hdr0=''),
  271813 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=271813, CurrentID=0, Status='live', Symbol='Agbl2', Aliases='4930524K04, A430081C19Rik, CCP2', description='ATP/GTP binding protein-like 2', other_designations='ATP/GTP-binding protein-like 2|carboxypeptidase 2, cytosolic', map_location='2 E1', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=90782587, end_position_on_the_genomic_accession=90834437, orientation='plus', exon_count=26, OMIM='', no_hdr0=''),
  140742 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=140742, CurrentID=0, Status='live', Symbol='Sesn1', Aliases='1110002G11Rik, AU044290, Pa26, Sest1', description='sestrin 1', other_designations='p53 regulated Pa26 nuclear protein|p53-regulated protein PA26', map_location='10 22.77 cM', chromosome='10', genomic_nucleotide_accession_version='NC_000076.6', start_position_on_the_genomic_accession=41810574, end_position_on_the_genomic_accession=41908436, orientation='plus', exon_count=11, OMIM='', no_hdr0=''),
  140743 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=140743, CurrentID=0, Status='live', Symbol='Rem2', Aliases='AW411893', description='rad and gem related GTP binding protein 2', other_designations='rad and Gem-like GTP-binding protein 2', map_location='14 C3', chromosome='14', genomic_nucleotide_accession_version='NC_000080.6', start_position_on_the_genomic_accession=54476100, end_position_on_the_genomic_accession=54480434, orientation='plus', exon_count=5, OMIM='', no_hdr0=''),
  665033 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=665033, CurrentID=0, Status='live', Symbol='Col6a5', Aliases='Col29a1, EG665033, Gm7455', description='collagen, type VI, alpha 5', other_designations='collagen alpha-1(XXIX) chain', map_location='9', chromosome='9', genomic_nucleotide_accession_version='NC_000075.6', start_position_on_the_genomic_accession=105856070, end_position_on_the_genomic_accession=105960643, orientation='minus', exon_count=41, OMIM='', no_hdr0=''),
  102639054 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102639054, CurrentID=0, Status='live', Symbol='LOC102639054', Aliases='', description='TBC1 domain family member 30-like', other_designations='', map_location='', chromosome='10', genomic_nucleotide_accession_version='NC_000076.6', start_position_on_the_genomic_accession=121329047, end_position_on_the_genomic_accession=121352299, orientation='minus', exon_count=7, OMIM='', no_hdr0=''),
  102639055 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102639055, CurrentID=0, Status='live', Symbol='Gm35459', Aliases='', description='predicted gene, 35459', other_designations='', map_location='11', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=5168251, end_position_on_the_genomic_accession=5169674, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  140762 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=140762, CurrentID=0, Status='live', Symbol='C87926', Aliases='', description='cDNA sequence, C87926', other_designations='79.ml.H11-L', map_location='', chromosome='10', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  140765 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=140765, CurrentID=0, Status='live', Symbol='Tmprss3', Aliases='', description='transmembrane protease, serine 3', other_designations='transmembrane proteinase serine 3', map_location='17 A3.3', chromosome='17', genomic_nucleotide_accession_version='NC_000083.6', start_position_on_the_genomic_accession=31179265, end_position_on_the_genomic_accession=31209743, orientation='minus', exon_count=14, OMIM='', no_hdr0=''),
  271842 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=271842, CurrentID=0, Status='live', Symbol='Rpusd2', Aliases='4921503C21Rik, 9630001E10, BB231107', description='RNA pseudouridylate synthase domain containing 2', other_designations='', map_location='2 E5', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=119034790, end_position_on_the_genomic_accession=119042198, orientation='plus', exon_count=3, OMIM='', no_hdr0=''),
  110843 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=110843, CurrentID=0, Status='live', Symbol='Fzd2-rs2', Aliases='Fz2-rs2', description='frizzled homolog 2, related sequence 2 (Drosophila)', other_designations='', map_location='', chromosome='11', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  271844 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=271844, CurrentID=0, Status='live', Symbol='Pla2g4f', Aliases='4732472I07Rik, Gm647, Pla2zeta', description='phospholipase A2, group IVF', other_designations='cPLA2-zeta', map_location='2 E5', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=120299952, end_position_on_the_genomic_accession=120314320, orientation='minus', exon_count=20, OMIM='', no_hdr0=''),
  271849 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=271849, CurrentID=0, Status='live', Symbol='Shc4', Aliases='6230417E10Rik, 9930029B02Rik, Gm685, RaLP', description='SHC (Src homology 2 domain containing) family, member 4', other_designations='SH2 domain protein C4|SHC-transforming protein D|mShcD|novel phosphotyrosine interaction domain (PTB/PID) and SH2 domains containing protein|rai-like protein RaLP|src homology 2 domain-containing-transforming protein C4', map_location='2 F1', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=125627447, end_position_on_the_genomic_accession=125724160, orientation='minus', exon_count=14, OMIM='', no_hdr0=''),
  140780 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=140780, CurrentID=0, Status='live', Symbol='Bmp2k', Aliases='4933417M22Rik, AA673486, AV128808, BIKE', description='BMP2 inducible kinase', other_designations='', map_location='5 E3', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=96997689, end_position_on_the_genomic_accession=97091048, orientation='plus', exon_count=17, OMIM='', no_hdr0=''),
  140781 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=140781, CurrentID=0, Status='live', Symbol='Myh7', Aliases='B-MHC, MyHC-I, Myhc-b, Myhcb, beta-MHC', description='myosin, heavy polypeptide 7, cardiac muscle, beta', other_designations='MYH-beta/slow|cardiac myosin heavy chain beta isoform|myHC-beta|myHC-slow|myosin heavy chain 7|myosin heavy chain slow isoform|myosin heavy chain, cardiac muscle beta isoform|myosin heavy chain, cardiac muscle, fetal', map_location='14 28.01 cM', chromosome='14', genomic_nucleotide_accession_version='NC_000080.6', start_position_on_the_genomic_accession=54970688, end_position_on_the_genomic_accession=54994549, orientation='minus', exon_count=41, OMIM='', no_hdr0=''),
  665070 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=665070, CurrentID=0, Status='live', Symbol='Gm7475', Aliases='EG665070', description='predicted gene 7475', other_designations='', map_location='2 A3', chromosome='2', genomic_nucleotide_accession_version='NC_000068.6', start_position_on_the_genomic_accession=25330823, end_position_on_the_genomic_accession=25333553, orientation='minus', exon_count=4, OMIM='', no_hdr0=''),
  102639087 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102639087, CurrentID=0, Status='live', Symbol='Gm35486', Aliases='', description='predicted gene, 35486', other_designations='', map_location='3', chromosome='3', genomic_nucleotide_accession_version='NC_000069.6', start_position_on_the_genomic_accession=84809932, end_position_on_the_genomic_accession=84820754, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  102639089 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102639089, CurrentID=0, Status='live', Symbol='Gm21768', Aliases='', description='predicted gene, 21768', other_designations='', map_location='Y', chromosome='Y', genomic_nucleotide_accession_version='NC_000087.7', start_position_on_the_genomic_accession=23800395, end_position_on_the_genomic_accession=23802877, orientation='plus', exon_count=3, OMIM='', no_hdr0=''),
  102639094 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102639094, CurrentID=0, Status='live', Symbol='Gm28102', Aliases='', description='predicted gene 28102', other_designations='', map_location='Y', chromosome='Y', genomic_nucleotide_accession_version='NC_000087.7', start_position_on_the_genomic_accession=88053298, end_position_on_the_genomic_accession=88079479, orientation='plus', exon_count=10, OMIM='', no_hdr0=''),
  140792 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=140792, CurrentID=0, Status='live', Symbol='Colec12', Aliases='CL-P1, SRCL, Scara4', description='collectin sub-family member 12', other_designations='collectin placenta protein 1|scavenger receptor with C-type lectin', map_location='18 A1', chromosome='18', genomic_nucleotide_accession_version='NC_000084.6', start_position_on_the_genomic_accession=9707648, end_position_on_the_genomic_accession=9877995, orientation='plus', exon_count=11, OMIM='', no_hdr0=''),
  140795 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=140795, CurrentID=0, Status='live', Symbol='P2ry14', Aliases='A330108O13Rik, Gpr105, P2Y14', description='purinergic receptor P2Y, G-protein coupled, 14', other_designations='G-protein coupled receptor 105|UDP-glucose receptor', map_location='3 28.96 cM', chromosome='3', genomic_nucleotide_accession_version='NC_000069.6', start_position_on_the_genomic_accession=59114623, end_position_on_the_genomic_accession=59153492, orientation='minus', exon_count=5, OMIM='', no_hdr0=''),
  102639105 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102639105, CurrentID=0, Status='live', Symbol='Gm35498', Aliases='', description='predicted gene, 35498', other_designations='', map_location='1', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=85112445, end_position_on_the_genomic_accession=85118523, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  140806 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=140806, CurrentID=0, Status='live', Symbol='Il25', Aliases='IL-17e, Il17e', description='interleukin 25', other_designations='interleukin 17E', map_location='14 C3', chromosome='14', genomic_nucleotide_accession_version='NC_000080.6', start_position_on_the_genomic_accession=54929401, end_position_on_the_genomic_accession=54935841, orientation='plus', exon_count=6, OMIM='', no_hdr0=''),
  665095 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=665095, CurrentID=0, Status='live', Symbol='Cyp2j8', Aliases='Cyp2j8-ps, OTTMUSG00000007938', description='cytochrome P450, family 2, subfamily j, polypeptide 8', other_designations='cytochrome P450, 2j8|cytochrome P450, family 2, subfamily j, polypeptide 8, pseudogene', map_location='4 C5', chromosome='4', genomic_nucleotide_accession_version='NC_000070.6', start_position_on_the_genomic_accession=96444283, end_position_on_the_genomic_accession=96507386, orientation='minus', exon_count=9, OMIM='', no_hdr0=''),
  140810 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=140810, CurrentID=0, Status='live', Symbol='Ttbk2', Aliases='2610507N02Rik, AI326283, B930008N24Rik, TTK, Ttbk, Ttbk1, mKIAA0847', description='tau tubulin kinase 2', other_designations='protein bartleby', map_location='2 F1', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=120732816, end_position_on_the_genomic_accession=120850584, orientation='minus', exon_count=17, OMIM='', no_hdr0=''),
  102639117 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102639117, CurrentID=0, Status='live', Symbol='LOC102639117', Aliases='', description='secretoglobin family 2A member 2-like', other_designations='', map_location='', chromosome='19', genomic_nucleotide_accession_version='NC_000085.6', start_position_on_the_genomic_accession=9847435, end_position_on_the_genomic_accession=9852046, orientation='plus', exon_count=3, OMIM='', no_hdr0=''),
  271887 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=271887, CurrentID=0, Status='live', Symbol='Rbbp8nl', Aliases='4732416F18', description='RBBP8 N-terminal like', other_designations='', map_location='2 H4', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=180275246, end_position_on_the_genomic_accession=180289900, orientation='minus', exon_count=14, OMIM='', no_hdr0=''),
  102639120 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102639120, CurrentID=0, Status='live', Symbol='Gm35508', Aliases='', description='predicted gene, 35508', other_designations='', map_location='7', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=42812755, end_position_on_the_genomic_accession=42815592, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  665113 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=665113, CurrentID=0, Status='live', Symbol='Tnik', Aliases='1500031A17Rik, 4831440I19Rik, AI451411, C530008O15Rik, C630040K21Rik', description='TRAF2 and NCK interacting kinase', other_designations='', map_location='3 A3', chromosome='3', genomic_nucleotide_accession_version='NC_000069.6', start_position_on_the_genomic_accession=28263214, end_position_on_the_genomic_accession=28670585, orientation='plus', exon_count=35, OMIM='', no_hdr0=''),
  102639132 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102639132, CurrentID=0, Status='live', Symbol='Gm21885', Aliases='', description='predicted gene, 21885', other_designations='', map_location='11', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=94279625, end_position_on_the_genomic_accession=94292598, orientation='plus', exon_count=4, OMIM='', no_hdr0=''),
  665119 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=665119, CurrentID=0, Status='live', Symbol='Sec14l5', Aliases='', description='SEC14-like lipid binding 5', other_designations='SEC14-like 5', map_location='16 A1', chromosome='16', genomic_nucleotide_accession_version='NC_000082.6', start_position_on_the_genomic_accession=5146901, end_position_on_the_genomic_accession=5187271, orientation='plus', exon_count=17, OMIM='', no_hdr0=''),
  102639145 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102639145, CurrentID=0, Status='live', Symbol='LOC102639145', Aliases='', description='protein PRRC2A-like', other_designations='', map_location='', chromosome='17', genomic_nucleotide_accession_version='NC_000083.6', start_position_on_the_genomic_accession=79354402, end_position_on_the_genomic_accession=79358020, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  665137 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=665137, CurrentID=0, Status='live', Symbol='Gm7511', Aliases='EG665137', description='predicted gene 7511', other_designations='RNA polymerase II, polypeptide H', map_location='12 C1', chromosome='12', genomic_nucleotide_accession_version='NC_000078.6', start_position_on_the_genomic_accession=55067511, end_position_on_the_genomic_accession=55068288, orientation='minus', exon_count=1, OMIM='', no_hdr0=''),
  102639159 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102639159, CurrentID=0, Status='live', Symbol='Gm21763', Aliases='', description='predicted gene, 21763', other_designations='', map_location='Y', chromosome='Y', genomic_nucleotide_accession_version='NC_000087.7', start_position_on_the_genomic_accession=19514195, end_position_on_the_genomic_accession=19516627, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  140858 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=140858, CurrentID=0, Status='live', Symbol='Wdr5', Aliases='2410008O07Rik, AA408785, AA960360, Big, Big-3', description='WD repeat domain 5', other_designations='BMP2-induced 3-kb gene protein|WD repeat-containing protein BIG-3', map_location='2 A3', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=27515147, end_position_on_the_genomic_accession=27536535, orientation='plus', exon_count=15, OMIM='', no_hdr0=''),
  140859 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=140859, CurrentID=0, Status='live', Symbol='Nek8', Aliases='4632401F23Rik, b2b1449Clo, jck', description='NIMA (never in mitosis gene a)-related expressed kinase 8', other_designations='NIMA-related expressed kinase 8|juvenile cystic kidney|never in mitosis A-related kinase 8|nimA-related protein kinase 8', map_location='11 46.74 cM', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=78166106, end_position_on_the_genomic_accession=78176695, orientation='minus', exon_count=15, OMIM='', no_hdr0=''),
  665149 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=665149, CurrentID=0, Status='live', Symbol='Sox5os5', Aliases='EG665149, Gm7518', description='SRY (sex determining region Y)-box 5, opposite strand 5', other_designations='Sox5 opposite strand transcript 5', map_location='6 G3', chromosome='6', genomic_nucleotide_accession_version='NC_000072.5', start_position_on_the_genomic_accession=144672089, end_position_on_the_genomic_accession=144673427, orientation='plus', exon_count=3, OMIM='', no_hdr0=''),
  665150 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=665150, CurrentID=0, Status='live', Symbol='Vmn1r57', Aliases='EG665150, Gm7519', description='vomeronasal 1 receptor 57', other_designations='vomernasal 1 receptor Vmn1r57', map_location='7', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=5220478, end_position_on_the_genomic_accession=5221410, orientation='plus', exon_count=1, OMIM='', no_hdr0=''),
  102639170 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102639170, CurrentID=0, Status='live', Symbol='LOC102639170', Aliases='', description='protein CDV3-like', other_designations='', map_location='', chromosome='14', genomic_nucleotide_accession_version='NC_000080.6', start_position_on_the_genomic_accession=43120702, end_position_on_the_genomic_accession=43134378, orientation='minus', exon_count=4, OMIM='', no_hdr0=''),
  665155 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=665155, CurrentID=0, Status='live', Symbol='Srp54b', Aliases='', description='signal recognition particle 54B', other_designations='SRP54', map_location='12 C1', chromosome='12', genomic_nucleotide_accession_version='NC_000078.6', start_position_on_the_genomic_accession=55155104, end_position_on_the_genomic_accession=55189213, orientation='plus', exon_count=16, OMIM='', no_hdr0=''),
  271944 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=271944, CurrentID=0, Status='live', Symbol='C2cd4d', Aliases='Gm659', description='C2 calcium-dependent domain containing 4D', other_designations='', map_location='3 F2.1', chromosome='3', genomic_nucleotide_accession_version='NC_000069.6', start_position_on_the_genomic_accession=94362444, end_position_on_the_genomic_accession=94364567, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  102639178 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102639178, CurrentID=0, Status='live', Symbol='Gm35549', Aliases='', description='predicted gene, 35549', other_designations='', map_location='9', chromosome='9', genomic_nucleotide_accession_version='NC_000075.6', start_position_on_the_genomic_accession=122835955, end_position_on_the_genomic_accession=122845227, orientation='minus', exon_count=4, OMIM='', no_hdr0=''),
  110861 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=110861, CurrentID=0, Status='live', Symbol='Evi5-rs1', Aliases='', description='ecotropic viral integration site 5 related sequence 1', other_designations='', map_location='', chromosome='10', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  665174 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=665174, CurrentID=0, Status='live', Symbol='Gm11543', Aliases='OTTMUSG00000002040', description='predicted gene 11543', other_designations='', map_location='11', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=94827679, end_position_on_the_genomic_accession=94831986, orientation='minus', exon_count=6, OMIM='', no_hdr0=''),
  140887 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=140887, CurrentID=0, Status='live', Symbol='Lnx2', Aliases='9630046H24, AW209022', description='ligand of numb-protein X 2', other_designations='numb-binding protein 2', map_location='5 G2', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=147016655, end_position_on_the_genomic_accession=147076572, orientation='minus', exon_count=11, OMIM='', no_hdr0=''),
  110863 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=110863, CurrentID=0, Status='live', Symbol='Gdc2', Aliases='Gdc-2', description='glycerolphosphate dehydrogenase 2, cytoplasmic embryonic', other_designations='', map_location='', chromosome='9', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  665180 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=665180, CurrentID=0, Status='live', Symbol='Clec2l', Aliases='AI414054, AW122724, Gm1064', description='C-type lectin domain family 2, member L', other_designations='C-type lectin domain family, member L', map_location='6 B1', chromosome='6', genomic_nucleotide_accession_version='NC_000072.6', start_position_on_the_genomic_accession=38663069, end_position_on_the_genomic_accession=38680865, orientation='plus', exon_count=5, OMIM='', no_hdr0=''),
  271970 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=271970, CurrentID=0, Status='live', Symbol='Arsj', Aliases='9330196J05Rik, D830047F08', description='arylsulfatase J', other_designations='ASJ', map_location='3 G1', chromosome='3', genomic_nucleotide_accession_version='NC_000069.6', start_position_on_the_genomic_accession=126363250, end_position_on_the_genomic_accession=126440379, orientation='plus', exon_count=3, OMIM='', no_hdr0=''),
  140904 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=140904, CurrentID=0, Status='live', Symbol='Caln1', Aliases='9630012C17Rik, Cabp8, MNCb-0849', description='calneuron 1', other_designations='calneuron I|calneuron-1|calneuron-I', map_location='5 F', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=130369356, end_position_on_the_genomic_accession=130846325, orientation='plus', exon_count=13, OMIM='', no_hdr0=''),
  271981 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=271981, CurrentID=0, Status='live', Symbol='Tbck', Aliases='1700120J03Rik, 9430001M19, A630047E20Rik, C030007I09Rikl, Tbck', description='TBC1 domain containing kinase', other_designations='', map_location='3 G3', chromosome='3', genomic_nucleotide_accession_version='NC_000069.6', start_position_on_the_genomic_accession=132683994, end_position_on_the_genomic_accession=132841688, orientation='plus', exon_count=28, OMIM='', no_hdr0=''),
  140917 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=140917, CurrentID=0, Status='live', Symbol='Dclre1b', Aliases='AI452214, Apollo, SNMIB, mSNM1B', description='DNA cross-link repair 1B', other_designations='DNA cross-link repair 1B protein|DNA cross-link repair 1B, PSO2 homolog|SNM1 homolog B', map_location='3 F2.2', chromosome='3', genomic_nucleotide_accession_version='NC_000069.6', start_position_on_the_genomic_accession=103800605, end_position_on_the_genomic_accession=103809387, orientation='minus', exon_count=4, OMIM='', no_hdr0=''),
  140918 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=140918, CurrentID=0, Status='live', Symbol='Slc7a12', Aliases='Asc-2, XAT1', description='solute carrier family 7 (cationic amino acid transporter, y+ system), member 12', other_designations='Asc-2,asc-type amino acid transporter 2|asc-type amino acid transporter 2', map_location='3 A1', chromosome='3', genomic_nucleotide_accession_version='NC_000069.6', start_position_on_the_genomic_accession=14480691, end_position_on_the_genomic_accession=14505819, orientation='plus', exon_count=4, OMIM='', no_hdr0=''),
  140919 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=140919, CurrentID=0, Status='live', Symbol='Slc17a6', Aliases='2900073D12Rik, DNPI, VGLUT2', description='solute carrier family 17 (sodium-dependent inorganic phosphate cotransporter), member 6', other_designations='differentiation-associated BNPI|differentiation-associated Na(+)-dependent inorganic phosphate cotransporter|solute carrier family 17 (vesicular glutamate transporter), member 6|solute carrier family 17 member 6', map_location='7 B5', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=51621830, end_position_on_the_genomic_accession=51671126, orientation='plus', exon_count=14, OMIM='', no_hdr0=''),
  665210 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=665210, CurrentID=0, Status='live', Symbol='Vmn2r91', Aliases='EG665210', description='vomeronasal 2, receptor 91', other_designations='', map_location='17 A3.2', chromosome='17', genomic_nucleotide_accession_version='NC_000083.6', start_position_on_the_genomic_accession=18085057, end_position_on_the_genomic_accession=18136643, orientation='plus', exon_count=6, OMIM='', no_hdr0=''),
  665211 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=665211, CurrentID=0, Status='live', Symbol='Gm14326', Aliases='OTTMUSG00000016327', description='predicted gene 14326', other_designations='', map_location='2 H4', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=177935993, end_position_on_the_genomic_accession=177958136, orientation='minus', exon_count=7, OMIM='', no_hdr0=''),
  102639229 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102639229, CurrentID=0, Status='live', Symbol='Gm35588', Aliases='', description='predicted gene, 35588', other_designations='', map_location='7', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=43253741, end_position_on_the_genomic_accession=43265639, orientation='plus', exon_count=5, OMIM='', no_hdr0=''),
  102639234 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102639234, CurrentID=0, Status='live', Symbol='Gm21879', Aliases='', description='predicted gene, 21879', other_designations='', map_location='Y', chromosome='Y', genomic_nucleotide_accession_version='NC_000087.7', start_position_on_the_genomic_accession=85016678, end_position_on_the_genomic_accession=85019048, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  102639239 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102639239, CurrentID=0, Status='live', Symbol='Gm35595', Aliases='', description='predicted gene, 35595', other_designations='', map_location='14', chromosome='14', genomic_nucleotide_accession_version='NC_000080.6', start_position_on_the_genomic_accession=62541291, end_position_on_the_genomic_accession=62546843, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  272009 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=272009, CurrentID=0, Status='live', Symbol='Srsf12', Aliases='B830039L16, Sfrs13b, Srrp, Srsf13b', description='serine/arginine-rich splicing factor 12', other_designations='serine-arginine repressor protein|serine/arginine-rich splicing factor 13B|splicing factor, arginine/serine-rich 13B', map_location='4 A5', chromosome='4', genomic_nucleotide_accession_version='NC_000070.6', start_position_on_the_genomic_accession=33208987, end_position_on_the_genomic_accession=33233344, orientation='plus', exon_count=5, OMIM='', no_hdr0=''),
  665227 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=665227, CurrentID=0, Status='live', Symbol='Vmn2r94', Aliases='EG665227', description='vomeronasal 2, receptor 94', other_designations='', map_location='17 A3.2', chromosome='17', genomic_nucleotide_accession_version='NC_000083.6', start_position_on_the_genomic_accession=18243570, end_position_on_the_genomic_accession=18277566, orientation='minus', exon_count=6, OMIM='', no_hdr0=''),
  403088 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=403088, CurrentID=0, Status='live', Symbol='Tcaf3', Aliases='Eapa2, Fam115e', description='TRPM8 channel-associated factor 3', other_designations='experimental autoimmune prostatitis antigen 2|family with sequence similarity 115, member E|protein FAM115E', map_location='6 B2.1', chromosome='6', genomic_nucleotide_accession_version='NC_000072.6', start_position_on_the_genomic_accession=42587213, end_position_on_the_genomic_accession=42597372, orientation='minus', exon_count=7, OMIM='', no_hdr0=''),
  110872 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=110872, CurrentID=0, Status='live', Symbol='Atp6v0c-rs2', Aliases='Atp6c-rs2, Atp6c3, Atpl-rs2', description='ATPase, H+ transporting, V0 subunit C, related sequence 2', other_designations='ATPase, H+ transporting, lysosomal 16kD, V0 subunit C, realted sequence 2|ATPase, H+ transporting, lysosomal 16kD, V0 subunit C, related sequence 2|ATPase, H+ transporting, lysosomal 3|ATPase, H+ transporting, lysosomal, related sequence 2|lysosomal 16kDa', map_location='', chromosome='6', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  665234 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=665234, CurrentID=0, Status='live', Symbol='Gm7546', Aliases='EG665234', description='predicted gene 7546', other_designations='', map_location='7 C', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=65579999, end_position_on_the_genomic_accession=65635854, orientation='minus', exon_count=4, OMIM='', no_hdr0=''),
  102639251 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102639251, CurrentID=0, Status='live', Symbol='Znf660', Aliases='', description='zinc finger protein 660', other_designations='', map_location='', chromosome='9', genomic_nucleotide_accession_version='NC_000075.6', start_position_on_the_genomic_accession=122903246, end_position_on_the_genomic_accession=122911295, orientation='plus', exon_count=3, OMIM='', no_hdr0=''),
  272027 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=272027, CurrentID=0, Status='live', Symbol='Tstd2', Aliases='3010020C06', description='thiosulfate sulfurtransferase (rhodanese)-like domain containing 2', other_designations='likely ortholog of H. sapiens chromosome 9 open reading frame 97 (C9orf97)', map_location='4 B1', chromosome='4', genomic_nucleotide_accession_version='NC_000070.6', start_position_on_the_genomic_accession=46114746, end_position_on_the_genomic_accession=46138581, orientation='minus', exon_count=13, OMIM='', no_hdr0=''),
  272031 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=272031, CurrentID=0, Status='live', Symbol='Plppr1', Aliases='E130309F12Rik, Lppr1, PRG-3, mKIAA4247', description='phospholipid phosphatase related 1', other_designations='plasticity-related gene 3 protein|plasticity-related protein 3', map_location='4 B1', chromosome='4', genomic_nucleotide_accession_version='NC_000070.6', start_position_on_the_genomic_accession=49059462, end_position_on_the_genomic_accession=49340261, orientation='plus', exon_count=10, OMIM='', no_hdr0=''),
  102639266 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102639266, CurrentID=0, Status='live', Symbol='LOC102639266', Aliases='', description='uncharacterized LOC102639266', other_designations='', map_location='', chromosome='Y', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  665255 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=665255, CurrentID=0, Status='live', Symbol='Vmn2r28', Aliases='EG665255', description='vomeronasal 2, receptor 28', other_designations='vomeronasal receptor Vmn2r28', map_location='7 A1', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=5480456, end_position_on_the_genomic_accession=5493851, orientation='minus', exon_count=6, OMIM='', no_hdr0=''),
  110878 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=110878, CurrentID=0, Status='live', Symbol='Nova2-rs1', Aliases='', description='neuro-oncological ventral antigen 2, related sequence 1', other_designations='', map_location='', chromosome='7', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  665270 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=665270, CurrentID=0, Status='live', Symbol='Plb1', Aliases='4632413E21Rik, 4930433E17Rik, 4930539A06Rik, BC033606', description='phospholipase B1', other_designations='PLB/LIP|phospholipase B|phospholipase B/lipase', map_location='5 B1', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=32232691, end_position_on_the_genomic_accession=32364356, orientation='plus', exon_count=61, OMIM='', no_hdr0=''),
  665273 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=665273, CurrentID=0, Status='live', Symbol='Gm7564', Aliases='EG665273', description='predicted gene 7564', other_designations='', map_location='11 D', chromosome='11', genomic_nucleotide_accession_version='NC_000077.5', start_position_on_the_genomic_accession=95685266, end_position_on_the_genomic_accession=95685870, orientation='minus', exon_count=1, OMIM='', no_hdr0=''),
  665276 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=665276, CurrentID=0, Status='live', Symbol='Gm20772', Aliases='', description='predicted gene, 20772', other_designations='', map_location='Y', chromosome='Y', genomic_nucleotide_accession_version='NC_000087.7', start_position_on_the_genomic_accession=17876355, end_position_on_the_genomic_accession=17877053, orientation='plus', exon_count=1, OMIM='', no_hdr0=''),
  665282 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=665282, CurrentID=0, Status='live', Symbol='Gm7568', Aliases='EG665282', description='predicted gene 7568', other_designations='', map_location='1 A3', chromosome='1', genomic_nucleotide_accession_version='NC_000067.5', start_position_on_the_genomic_accession=16243710, end_position_on_the_genomic_accession=16248938, orientation='plus', exon_count=3, OMIM='', no_hdr0=''),
  665283 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=665283, CurrentID=0, Status='live', Symbol='Gm11971', Aliases='OTTMUSG00000005112', description='predicted gene 11971', other_designations='', map_location='11 A1', chromosome='11', genomic_nucleotide_accession_version='NC_000077.5', start_position_on_the_genomic_accession=6353134, end_position_on_the_genomic_accession=6354045, orientation='plus', exon_count=1, OMIM='', no_hdr0=''),
  102639302 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102639302, CurrentID=0, Status='live', Symbol='Gm28459', Aliases='', description='predicted gene 28459', other_designations='', map_location='Y', chromosome='Y', genomic_nucleotide_accession_version='NC_000087.7', start_position_on_the_genomic_accession=45753175, end_position_on_the_genomic_accession=45755579, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  102639303 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102639303, CurrentID=0, Status='live', Symbol='Gm28353', Aliases='', description='predicted gene 28353', other_designations='', map_location='Y', chromosome='Y', genomic_nucleotide_accession_version='NC_000087.7', start_position_on_the_genomic_accession=55624234, end_position_on_the_genomic_accession=55626727, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  16651 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=16651, CurrentID=0, Status='live', Symbol='Sspn', Aliases='Krag', description='sarcospan', other_designations='K-ras oncogene-associated protein|Kras oncogene-associated|kirsten-Ras-associated protein', map_location='6 77.7 cM', chromosome='6', genomic_nucleotide_accession_version='NC_000072.6', start_position_on_the_genomic_accession=145931150, end_position_on_the_genomic_accession=145965225, orientation='plus', exon_count=5, OMIM='', no_hdr0=''),
  665290 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=665290, CurrentID=0, Status='live', Symbol='LOC665290', Aliases='', description='PRAME family member 12-like', other_designations='', map_location='5', chromosome='5', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  665301 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=665301, CurrentID=0, Status='live', Symbol='Gm20773', Aliases='', description='predicted gene, 20773', other_designations='', map_location='Y', chromosome='Y', genomic_nucleotide_accession_version='NC_000087.7', start_position_on_the_genomic_accession=13495642, end_position_on_the_genomic_accession=13496455, orientation='plus', exon_count=1, OMIM='', no_hdr0=''),
  665304 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=665304, CurrentID=0, Status='live', Symbol='Gm7578', Aliases='EG665304, Gm1694', description='predicted gene 7578', other_designations='', map_location='7 C', chromosome='7', genomic_nucleotide_accession_version='NC_000073.5', start_position_on_the_genomic_accession=74573923, end_position_on_the_genomic_accession=74588819, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  665305 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=665305, CurrentID=0, Status='live', Symbol='Gm7579', Aliases='EG665305', description='predicted gene 7579', other_designations='', map_location='7 F5', chromosome='7', genomic_nucleotide_accession_version='NC_000073.5', start_position_on_the_genomic_accession=149397722, end_position_on_the_genomic_accession=149398495, orientation='plus', exon_count=3, OMIM='', no_hdr0=''),
  403171 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=403171, CurrentID=0, Status='live', Symbol='Banf2', Aliases='4930517K23Rik, Baf-L, Baf-like, Gm115', description='barrier to autointegration factor 2', other_designations='barrier-to-autointegration factor 2|likely ortholog of H. sapiens Chromosome 20 open reading frame 179 (C20orf179)', map_location='2 G1', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=144033102, end_position_on_the_genomic_accession=144073979, orientation='plus', exon_count=4, OMIM='', no_hdr0=''),
  403172 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=403172, CurrentID=0, Status='live', Symbol='Defb21', Aliases='4930525K10Rik, Gm121', description='defensin beta 21', other_designations='', map_location='2 H1', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=152572744, end_position_on_the_genomic_accession=152574944, orientation='plus', exon_count=3, OMIM='', no_hdr0=''),
  403174 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=403174, CurrentID=0, Status='live', Symbol='Msantd1', Aliases='A930005I04Rik, Gm144', description='Myb/SANT-like DNA-binding domain containing 1', other_designations='', map_location='5 B2', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=34907775, end_position_on_the_genomic_accession=34923853, orientation='plus', exon_count=5, OMIM='', no_hdr0=''),
  403175 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=403175, CurrentID=0, Status='live', Symbol='Tigd4', Aliases='C130063O11Rik, Gm418', description='tigger transposable element derived 4', other_designations='', map_location='3 F1', chromosome='3', genomic_nucleotide_accession_version='NC_000069.6', start_position_on_the_genomic_accession=84593574, end_position_on_the_genomic_accession=84597032, orientation='plus', exon_count=1, OMIM='', no_hdr0=''),
  403178 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=403178, CurrentID=0, Status='live', Symbol='Plcxd1', Aliases='A330045H12Rik, Gm576', description='phosphatidylinositol-specific phospholipase C, X domain containing 1', other_designations='', map_location='5 F', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=110099225, end_position_on_the_genomic_accession=110105953, orientation='plus', exon_count=12, OMIM='', no_hdr0=''),
  403180 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=403180, CurrentID=0, Status='live', Symbol='Ccdc121', Aliases='6530421E24Rik, Gm755', description='coiled-coil domain containing 121', other_designations='', map_location='1 H5', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=181509633, end_position_on_the_genomic_accession=181511451, orientation='minus', exon_count=1, OMIM='', no_hdr0=''),
  403183 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=403183, CurrentID=0, Status='live', Symbol='Mettl21e', Aliases='4832428D23Rik, Gm991', description='methyltransferase like 21E', other_designations='methyltransferase-like protein 21C pseudogene 1 homolog|methyltransferase-like protein 21E pseudogene homolog|methyltransferase-like protein LOC121952 homolog', map_location='1 C1.1', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=44204070, end_position_on_the_genomic_accession=44218931, orientation='minus', exon_count=5, OMIM='', no_hdr0=''),
  403185 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=403185, CurrentID=0, Status='live', Symbol='4932443I19Rik', Aliases='A230061C02Rik, Gm1106', description='RIKEN cDNA 4932443I19 gene', other_designations='', map_location='8 A1.1', chromosome='8', genomic_nucleotide_accession_version='NC_000074.6', start_position_on_the_genomic_accession=13705449, end_position_on_the_genomic_accession=13743531, orientation='plus', exon_count=5, OMIM='', no_hdr0=''),
  403187 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=403187, CurrentID=0, Status='live', Symbol='Opa3', Aliases='D630048P19Rik, Gm1425, Gm472', description='optic atrophy 3', other_designations='', map_location='7 A3', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=19228389, end_position_on_the_genomic_accession=19246817, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  665338 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=665338, CurrentID=0, Status='live', Symbol='Gm7592', Aliases='EG665338', description='predicted gene 7592', other_designations='', map_location='1 C5', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=85549687, end_position_on_the_genomic_accession=85550577, orientation='plus', exon_count=1, OMIM='', no_hdr0=''),
  403200 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=403200, CurrentID=0, Status='live', Symbol='4930504O13Rik', Aliases='Gm524', description='RIKEN cDNA 4930504O13 gene', other_designations='', map_location='11 B1.3', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=58446143, end_position_on_the_genomic_accession=58452966, orientation='minus', exon_count=4, OMIM='', no_hdr0=''),
  403205 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=403205, CurrentID=0, Status='live', Symbol='Agr3', Aliases='BCMP11, E030025L21Rik, Gm888', description='anterior gradient 3', other_designations='anterior gradient homolog 3|anterior gradient protein 3 homolog', map_location='12 A3', chromosome='12', genomic_nucleotide_accession_version='NC_000078.6', start_position_on_the_genomic_accession=35925621, end_position_on_the_genomic_accession=35949737, orientation='plus', exon_count=10, OMIM='', no_hdr0=''),
  665350 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=665350, CurrentID=0, Status='live', Symbol='Gm7596', Aliases='EG665350', description='predicted gene 7596', other_designations='', map_location='5 B1', chromosome='5', genomic_nucleotide_accession_version='NC_000071.5', start_position_on_the_genomic_accession=32692443, end_position_on_the_genomic_accession=32695679, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  272158 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=272158, CurrentID=0, Status='live', Symbol='Poln', Aliases='POL4P', description='DNA polymerase N', other_designations='DNA-directed DNA polymerase nu', map_location='5 C1', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=34007179, end_position_on_the_genomic_accession=34169526, orientation='minus', exon_count=26, OMIM='', no_hdr0=''),
  665376 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=665376, CurrentID=0, Status='live', Symbol='Vmn2r99', Aliases='EG665376', description='vomeronasal 2, receptor 99', other_designations='vomeronasal receptor Vmn2r99', map_location='17 A3.2', chromosome='17', genomic_nucleotide_accession_version='NC_000083.6', start_position_on_the_genomic_accession=19362135, end_position_on_the_genomic_accession=19394590, orientation='plus', exon_count=6, OMIM='', no_hdr0=''),
  665378 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=665378, CurrentID=0, Status='live', Symbol='Gm7609', Aliases='EG665378', description='predicted pseudogene 7609', other_designations='', map_location='1 C5', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=85199592, end_position_on_the_genomic_accession=85215395, orientation='plus', exon_count=6, OMIM='', no_hdr0=''),
  102639403 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102639403, CurrentID=0, Status='live', Symbol='Gm29401', Aliases='', description='predicted gene 29401', other_designations='', map_location='Y', chromosome='Y', genomic_nucleotide_accession_version='NC_000087.7', start_position_on_the_genomic_accession=27892639, end_position_on_the_genomic_accession=27902596, orientation='plus', exon_count=5, OMIM='', no_hdr0=''),
  665389 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=665389, CurrentID=0, Status='live', Symbol='Gm7616', Aliases='EG665389', description='predicted gene 7616', other_designations='', map_location='9 B', chromosome='9', genomic_nucleotide_accession_version='NC_000075.6', start_position_on_the_genomic_accession=59951294, end_position_on_the_genomic_accession=59959044, orientation='plus', exon_count=4, OMIM='', no_hdr0=''),
  665413 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=665413, CurrentID=0, Status='live', Symbol='Gm7628', Aliases='EG665413', description='predicted gene 7628', other_designations='', map_location='9 F2', chromosome='9', genomic_nucleotide_accession_version='NC_000075.6', start_position_on_the_genomic_accession=109093844, end_position_on_the_genomic_accession=109098474, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  102639437 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102639437, CurrentID=0, Status='live', Symbol='Gm35751', Aliases='', description='predicted gene, 35751', other_designations='', map_location='18', chromosome='18', genomic_nucleotide_accession_version='NC_000084.6', start_position_on_the_genomic_accession=57803013, end_position_on_the_genomic_accession=57828506, orientation='plus', exon_count=4, OMIM='', no_hdr0=''),
  665433 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=665433, CurrentID=0, Status='live', Symbol='Hist1h2ao', Aliases='', description='histone cluster 1, H2ao', other_designations='', map_location='13 A3.1', chromosome='13', genomic_nucleotide_accession_version='NC_000079.6', start_position_on_the_genomic_accession=21810367, end_position_on_the_genomic_accession=21810918, orientation='plus', exon_count=1, OMIM='', no_hdr0=''),
  329360 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=329360, CurrentID=0, Status='live', Symbol='Rnf224', Aliases='Gm757', description='ring finger protein 224', other_designations='', map_location='2 A3', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=25234476, end_position_on_the_genomic_accession=25236787, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  102639466 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102639466, CurrentID=0, Status='live', Symbol='Gm35773', Aliases='', description='predicted gene, 35773', other_designations='', map_location='5', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=110961834, end_position_on_the_genomic_accession=110964515, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  665469 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=665469, CurrentID=0, Status='live', Symbol='Gm7647', Aliases='ENSMUSG00000073510', description='predicted gene 7647', other_designations='', map_location='5 E3', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=94963930, end_position_on_the_genomic_accession=94965702, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  102639490 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102639490, CurrentID=0, Status='live', Symbol='Gm21858', Aliases='', description='predicted gene, 21858', other_designations='', map_location='Y', chromosome='Y', genomic_nucleotide_accession_version='NC_000087.7', start_position_on_the_genomic_accession=55731739, end_position_on_the_genomic_accession=55757891, orientation='plus', exon_count=13, OMIM='', no_hdr0=''),
  329366 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=329366, CurrentID=0, Status='live', Symbol='Ccdc187', Aliases='4932418E24Rik', description='coiled-coil domain containing 187', other_designations='', map_location='2 A3', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=26243449, end_position_on_the_genomic_accession=26300476, orientation='minus', exon_count=31, OMIM='', no_hdr0=''),
  102639505 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102639505, CurrentID=0, Status='live', Symbol='LOC102639505', Aliases='', description='zinc finger protein 431-like', other_designations='', map_location='', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=175692024, end_position_on_the_genomic_accession=175704087, orientation='minus', exon_count=5, OMIM='', no_hdr0=''),
  403346 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=403346, CurrentID=0, Status='live', Symbol='A730062M13Rik', Aliases='', description='RIKEN cDNA A730062M13 gene', other_designations='', map_location='', chromosome='9', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  403347 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=403347, CurrentID=0, Status='live', Symbol='F830014O18Rik', Aliases='', description='RIKEN cDNA F830014O18 gene', other_designations='', map_location='', chromosome='1', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  403348 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=403348, CurrentID=0, Status='live', Symbol='D130084N16Rik', Aliases='', description='RIKEN cDNA D130084N16 gene', other_designations='', map_location='', chromosome='2', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  403351 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=403351, CurrentID=0, Status='live', Symbol='D430018B14Rik', Aliases='', description='RIKEN cDNA D430018B14 gene', other_designations='', map_location='', chromosome='13', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  403355 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=403355, CurrentID=0, Status='live', Symbol='Klra24', Aliases='Ly49x', description='killer cell lectin-like receptor, subfamily A, member 24', other_designations='', map_location='', chromosome='6', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  110917 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=110917, CurrentID=0, Status='live', Symbol='Lamr1-rs6', Aliases='67kDa, P40-rs6', description='laminin receptor 1 (ribosomal protein SA), related sequence 6', other_designations='laminin receptor 1 (67kD, ribosomal protein SA), related sequence 6', map_location='', chromosome='14', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  329372 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=329372, CurrentID=0, Status='live', Symbol='D2Bwg1423e', Aliases='A230069D13', description="DNA segment, Chr 2, Brigham & Women's Genetics 1423 expressed", other_designations='', map_location='2', chromosome='2', genomic_nucleotide_accession_version='NC_000068.6', start_position_on_the_genomic_accession=27297842, end_position_on_the_genomic_accession=27299773, orientation='minus', exon_count=1, OMIM='', no_hdr0=''),
  665525 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=665525, CurrentID=0, Status='live', Symbol='Vmn1r224', Aliases='EG665525, Gm7673', description='vomeronasal 1 receptor 224', other_designations='vomernasal 1 receptor Vmn1r224', map_location='17 A3.2', chromosome='17', genomic_nucleotide_accession_version='NC_000083.6', start_position_on_the_genomic_accession=20419163, end_position_on_the_genomic_accession=20420059, orientation='plus', exon_count=1, OMIM='', no_hdr0=''),
  102639543 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102639543, CurrentID=0, Status='live', Symbol='LOC102639543', Aliases='', description='pyrin domain-containing protein 3-like', other_designations='', map_location='', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=173468418, end_position_on_the_genomic_accession=173491318, orientation='minus', exon_count=9, OMIM='', no_hdr0=''),
  329375 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=329375, CurrentID=0, Status='live', Symbol='Cfap77', Aliases='1700101E01Rik, Gm823', description='cilia and flagella associated protein 77', other_designations='', map_location='2 A3', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=28927749, end_position_on_the_genomic_accession=29055274, orientation='minus', exon_count=7, OMIM='', no_hdr0=''),
  272322 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=272322, CurrentID=0, Status='live', Symbol='Arntl2', Aliases='4632430A05Rik, BMAL2, CLIF, MOP9, bHLHe6', description='aryl hydrocarbon receptor nuclear translocator-like 2', other_designations='brain and muscle ARNT-like 2|brain-muscle-ARNT-like protein 2', map_location='6 G3', chromosome='6', genomic_nucleotide_accession_version='NC_000072.6', start_position_on_the_genomic_accession=146796015, end_position_on_the_genomic_accession=146833529, orientation='plus', exon_count=18, OMIM='', no_hdr0=''),
  403395 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=403395, CurrentID=0, Status='live', Symbol='Clec3a', Aliases='1110019O10Rik, Clecsf1, Gm796', description='C-type lectin domain family 3, member a', other_designations='C-type calcium dependent, carbohydrate-recognition domain lectin, superfamily member 1, cartilage-derived', map_location='8 E1', chromosome='8', genomic_nucleotide_accession_version='NC_000074.6', start_position_on_the_genomic_accession=114418034, end_position_on_the_genomic_accession=114428133, orientation='plus', exon_count=3, OMIM='', no_hdr0=''),
  665540 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=665540, CurrentID=0, Status='live', Symbol='Gm7677', Aliases='EG665540', description='predicted gene 7677', other_designations='', map_location='8 B3.3', chromosome='8', genomic_nucleotide_accession_version='NC_000074.5', start_position_on_the_genomic_accession=71706085, end_position_on_the_genomic_accession=71710284, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  665551 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=665551, CurrentID=0, Status='live', Symbol='Gm7682', Aliases='', description='predicted gene 7682', other_designations='', map_location='5', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=94445818, end_position_on_the_genomic_accession=94448551, orientation='plus', exon_count=3, OMIM='', no_hdr0=''),
  102639574 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102639574, CurrentID=0, Status='live', Symbol='Gm35854', Aliases='', description='predicted gene, 35854', other_designations='', map_location='1', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=40680582, end_position_on_the_genomic_accession=40681877, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  665562 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=665562, CurrentID=0, Status='live', Symbol='Rpl31-ps12', Aliases='EG665562, Gm7689', description='ribosomal protein L31, pseudogene 1 2', other_designations='predicted pseudogene 7689', map_location='16 A3', chromosome='16', genomic_nucleotide_accession_version='NC_000082.6', start_position_on_the_genomic_accession=16819713, end_position_on_the_genomic_accession=16820196, orientation='minus', exon_count=1, OMIM='', no_hdr0=''),
  272347 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=272347, CurrentID=0, Status='live', Symbol='Zfp398', Aliases='5730513I23Rik', description='zinc finger protein 398', other_designations='', map_location='6 B3', chromosome='6', genomic_nucleotide_accession_version='NC_000072.6', start_position_on_the_genomic_accession=47835661, end_position_on_the_genomic_accession=47873537, orientation='plus', exon_count=8, OMIM='', no_hdr0=''),
  665574 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=665574, CurrentID=0, Status='live', Symbol='Gm7694', Aliases='EG665574', description='predicted gene 7694', other_designations='', map_location='1 H3', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=170298193, end_position_on_the_genomic_accession=170308170, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  272359 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=272359, CurrentID=0, Status='live', Symbol='Irf2bp1', Aliases='6330414O09Rik, C530033F24', description='interferon regulatory factor 2 binding protein 1', other_designations='IRF-2-binding protein 1|IRF-2BP1|probable E3 ubiquitin-protein ligase IRF2BP1', map_location='7 A3', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=19004065, end_position_on_the_genomic_accession=19006763, orientation='plus', exon_count=1, OMIM='', no_hdr0=''),
  665578 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=665578, CurrentID=0, Status='live', Symbol='Gm7697', Aliases='EG665578', description='predicted gene 7697', other_designations='', map_location='8 B3.3', chromosome='8', genomic_nucleotide_accession_version='NC_000074.6', start_position_on_the_genomic_accession=69482621, end_position_on_the_genomic_accession=69522923, orientation='minus', exon_count=12, OMIM='', no_hdr0=''),
  102639595 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102639595, CurrentID=0, Status='live', Symbol='Gm21829', Aliases='', description='predicted gene, 21829', other_designations='', map_location='Y', chromosome='Y', genomic_nucleotide_accession_version='NC_000087.7', start_position_on_the_genomic_accession=81351303, end_position_on_the_genomic_accession=81353829, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  102639597 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102639597, CurrentID=0, Status='live', Symbol='Gm35871', Aliases='', description='predicted gene, 35871', other_designations='', map_location='5', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=73251917, end_position_on_the_genomic_accession=73260203, orientation='minus', exon_count=4, OMIM='', no_hdr0=''),
  102639598 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102639598, CurrentID=0, Status='live', Symbol='Gm14296', Aliases='', description='predicted gene 14296', other_designations='novel KRAB box and zinc finger, C2H2 type domain containing protein|zinc finger protein 431-like', map_location='2 H4', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=176902774, end_position_on_the_genomic_accession=176927930, orientation='minus', exon_count=9, OMIM='', no_hdr0=''),
  102639603 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102639603, CurrentID=0, Status='live', Symbol='LOC102639603', Aliases='', description='uncharacterized LOC102639603', other_designations='', map_location='', chromosome='14', genomic_nucleotide_accession_version='NC_000080.6', start_position_on_the_genomic_accession=44138458, end_position_on_the_genomic_accession=44140599, orientation='plus', exon_count=4, OMIM='', no_hdr0=''),
  665596 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=665596, CurrentID=0, Status='live', Symbol='Hist1h2bq', Aliases='Gm13646, OTTMUSG00000013203', description='histone cluster 1, H2bq', other_designations='', map_location='13 A3.1', chromosome='13', genomic_nucleotide_accession_version='NC_000079.6', start_position_on_the_genomic_accession=21806412, end_position_on_the_genomic_accession=21810199, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  272381 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=272381, CurrentID=0, Status='live', Symbol='Lrrc4b', Aliases='A830007M12, Lrig4', description='leucine rich repeat containing 4B', other_designations='NGL-3|leucine-rich repeats and immunoglobulin-like domains 4|netrin-G3 ligand', map_location='7 B4', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=44442487, end_position_on_the_genomic_accession=44463351, orientation='plus', exon_count=3, OMIM='', no_hdr0=''),
  272382 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=272382, CurrentID=0, Status='live', Symbol='Spib', Aliases='Spi-B', description='Spi-B transcription factor (Spi-1/PU.1 related)', other_designations='Ets transcription factor Spi-B|Spi-1/PU.1 related', map_location='7 28.83 cM', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=44525995, end_position_on_the_genomic_accession=44532086, orientation='minus', exon_count=6, OMIM='', no_hdr0=''),
  272396 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=272396, CurrentID=0, Status='live', Symbol='Tarsl2', Aliases='A530046H20Rik', description='threonyl-tRNA synthetase-like 2', other_designations='probable threonyl-tRNA synthetase 2, cytoplasmic|thrRS|threonine--tRNA ligase|threonyl-tRNA synthetase|threonyl-tRNA synthetase-like protein 2', map_location='7 C', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=65644898, end_position_on_the_genomic_accession=65692093, orientation='plus', exon_count=19, OMIM='', no_hdr0=''),
  665615 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=665615, CurrentID=0, Status='live', Symbol='Gm7714', Aliases='EG665615', description='predicted gene 7714', other_designations='', map_location='5 E1', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=88268919, end_position_on_the_genomic_accession=88282835, orientation='plus', exon_count=3, OMIM='', no_hdr0=''),
  665622 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=665622, CurrentID=0, Status='live', Symbol='Hist1h2br', Aliases='Gm11277, OTTMUSG00000000449', description='histone cluster 1 H2br', other_designations='H2b histone family member', map_location='13 A3.1', chromosome='13', genomic_nucleotide_accession_version='NC_000079.6', start_position_on_the_genomic_accession=21833743, end_position_on_the_genomic_accession=21837530, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  272411 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=272411, CurrentID=0, Status='live', Symbol='B3gnt6', Aliases='BC039789, Core-3, Core3', description='UDP-GlcNAc:betaGal beta-1,3-N-acetylglucosaminyltransferase 6 (core 3 synthase)', other_designations='BGnT-6|beta-1,3-Gn-T6|beta-1,3-N-acetylglucosaminyltransferase 6|beta3Gn-T6|core 3 synthase', map_location='7 E2', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=98192415, end_position_on_the_genomic_accession=98199475, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  102639650 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102639650, CurrentID=0, Status='live', Symbol='Gm35911', Aliases='', description='predicted gene, 35911', other_designations='', map_location='5', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=99906083, end_position_on_the_genomic_accession=99934961, orientation='plus', exon_count=6, OMIM='', no_hdr0=''),
  665635 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=665635, CurrentID=0, Status='live', Symbol='Gm14486', Aliases='OTTMUSG00000016802', description='predicted gene 14486', other_designations='', map_location='2 B', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=30656190, end_position_on_the_genomic_accession=30685591, orientation='minus', exon_count=8, OMIM='', no_hdr0=''),
  102639653 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102639653, CurrentID=0, Status='live', Symbol='LOC102639653', Aliases='', description='zinc finger protein 14-like', other_designations='', map_location='', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=175737823, end_position_on_the_genomic_accession=175770046, orientation='plus', exon_count=7, OMIM='', no_hdr0=''),
  102639656 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102639656, CurrentID=0, Status='live', Symbol='Gm35915', Aliases='', description='predicted gene, 35915', other_designations='', map_location='9', chromosome='9', genomic_nucleotide_accession_version='NC_000075.6', start_position_on_the_genomic_accession=95406495, end_position_on_the_genomic_accession=95408556, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  272428 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=272428, CurrentID=0, Status='live', Symbol='Acsm5', Aliases='C730019D22, C730027J19Rik', description='acyl-CoA synthetase medium-chain family member 5', other_designations='', map_location='7 F2', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=119526131, end_position_on_the_genomic_accession=119543360, orientation='plus', exon_count=16, OMIM='', no_hdr0=''),
  665645 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=665645, CurrentID=0, Status='live', Symbol='Gm7728', Aliases='EG665645', description='predicted gene 7728', other_designations='', map_location='2 B', chromosome='2', genomic_nucleotide_accession_version='NC_000068.6', start_position_on_the_genomic_accession=30628164, end_position_on_the_genomic_accession=30638926, orientation='plus', exon_count=4, OMIM='', no_hdr0=''),
  665661 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=665661, CurrentID=0, Status='live', Symbol='Gm7735', Aliases='EG665661', description='predicted gene 7735', other_designations='', map_location='16 C3.3', chromosome='16', genomic_nucleotide_accession_version='NC_000082.5', start_position_on_the_genomic_accession=89169735, end_position_on_the_genomic_accession=89169893, orientation='plus', exon_count=1, OMIM='', no_hdr0=''),
  102639684 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102639684, CurrentID=0, Status='live', Symbol='Gm35938', Aliases='', description='predicted gene, 35938', other_designations='', map_location='16', chromosome='16', genomic_nucleotide_accession_version='NC_000082.6', start_position_on_the_genomic_accession=49562934, end_position_on_the_genomic_accession=49568000, orientation='minus', exon_count=5, OMIM='', no_hdr0=''),
  102639688 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102639688, CurrentID=0, Status='live', Symbol='Gm38522', Aliases='', description='predicted gene, 38522', other_designations='', map_location='17', chromosome='17', genomic_nucleotide_accession_version='NC_000083.6', start_position_on_the_genomic_accession=29282899, end_position_on_the_genomic_accession=29286911, orientation='plus', exon_count=1, OMIM='', no_hdr0=''),
  67255 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=67255, CurrentID=0, Status='live', Symbol='Zfp422', Aliases='2900028O21Rik, AU041373, KOX15, Krox-25-2, Krox-26, Krox25, Krox26, Znf22', description='zinc finger protein 422', other_designations='Kruppel type zinc finger protein Krox26|krox-25 protein|zinc finger protein Krox-25|zinc finger protein Krox-26', map_location='6 E3', chromosome='6', genomic_nucleotide_accession_version='NC_000072.6', start_position_on_the_genomic_accession=116624016, end_position_on_the_genomic_accession=116628999, orientation='minus', exon_count=4, OMIM='', no_hdr0=''),
  272465 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=272465, CurrentID=0, Status='live', Symbol='Tmem255b', Aliases='Fam70b, Gm687', description='transmembrane protein 255B', other_designations='family with sequence similarity 70, member B|protein FAM70B', map_location='8 A1.1', chromosome='8', genomic_nucleotide_accession_version='NC_000074.6', start_position_on_the_genomic_accession=13435165, end_position_on_the_genomic_accession=13483667, orientation='plus', exon_count=14, OMIM='', no_hdr0=''),
  110947 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=110947, CurrentID=0, Status='live', Symbol='Tceb1l-rs2', Aliases='15kDa, Ocp2-rs2', description='transcription elongation factor B (SIII), polypeptide 1-like, related sequence 2', other_designations='transcription elongation factor B (SIII), polypeptide 1 (15 kDa),-like, related sequence 2', map_location='', chromosome='11', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  102639700 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102639700, CurrentID=0, Status='live', Symbol='LOC102639700', Aliases='', description='zinc finger protein 431-like', other_designations='', map_location='', chromosome='12', genomic_nucleotide_accession_version='NC_000078.6', start_position_on_the_genomic_accession=24178970, end_position_on_the_genomic_accession=24217590, orientation='minus', exon_count=7, OMIM='', no_hdr0=''),
  102639702 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102639702, CurrentID=0, Status='live', Symbol='Gm35953', Aliases='', description='predicted gene, 35953', other_designations='', map_location='X', chromosome='X', genomic_nucleotide_accession_version='NC_000086.7', start_position_on_the_genomic_accession=56277085, end_position_on_the_genomic_accession=56293278, orientation='minus', exon_count=7, OMIM='', no_hdr0=''),
  665687 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=665687, CurrentID=0, Status='live', Symbol='Gm20777', Aliases='', description='predicted gene, 20777', other_designations='', map_location='Y', chromosome='Y', genomic_nucleotide_accession_version='NC_000087.7', start_position_on_the_genomic_accession=10750128, end_position_on_the_genomic_accession=10760496, orientation='minus', exon_count=4, OMIM='', no_hdr0=''),
  102639706 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102639706, CurrentID=0, Status='live', Symbol='Gm28776', Aliases='', description='predicted gene 28776', other_designations='', map_location='Y', chromosome='Y', genomic_nucleotide_accession_version='NC_000087.7', start_position_on_the_genomic_accession=38643452, end_position_on_the_genomic_accession=38645313, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  110949 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=110949, CurrentID=0, Status='live', Symbol='Atp5g1-rs4', Aliases='', description='ATP synthase, H+ transporting, mitochondrial F0 complex, subunit c (subunit 9), isoform 1, related sequence 4', other_designations='', map_location='', chromosome='11', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  102639713 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102639713, CurrentID=0, Status='live', Symbol='LOC102639713', Aliases='', description='zinc finger protein 120-like', other_designations='', map_location='', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=177054064, end_position_on_the_genomic_accession=177059740, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  665700 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=665700, CurrentID=0, Status='live', Symbol='Hmcn2', Aliases='D030068H01', description='hemicentin 2', other_designations='', map_location='2 B', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=31313991, end_position_on_the_genomic_accession=31460738, orientation='plus', exon_count=99, OMIM='', no_hdr0=''),
  110950 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=110950, CurrentID=0, Status='live', Symbol='Atp5g1-rs5', Aliases='', description='ATP synthase, H+ transporting, mitochondrial F0 complex, subunit c (subunit 9), isoform 1, related sequence 5', other_designations='', map_location='', chromosome='14', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  665719 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=665719, CurrentID=0, Status='live', Symbol='Gm7757', Aliases='EG665719', description='predicted gene 7757', other_designations='', map_location='9 F3', chromosome='9', genomic_nucleotide_accession_version='NC_000075.5', start_position_on_the_genomic_accession=114027206, end_position_on_the_genomic_accession=114061561, orientation='plus', exon_count=12, OMIM='', no_hdr0=''),
  665738 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=665738, CurrentID=0, Status='live', Symbol='Gm7762', Aliases='', description='predicted gene 7762', other_designations='zinc finger protein 709-like', map_location='13', chromosome='13', genomic_nucleotide_accession_version='NC_000079.6', start_position_on_the_genomic_accession=65336883, end_position_on_the_genomic_accession=65348585, orientation='minus', exon_count=4, OMIM='', no_hdr0=''),
  272538 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=272538, CurrentID=0, Status='live', Symbol='Tango6', Aliases='AW413431, E330010G16, Tmco7', description='transport and golgi organization 6', other_designations='transmembrane and coiled-coil domain-containing protein 7|transmembrane and coiled-coil domains 7|transport and Golgi organization 6 homolog', map_location='8 D3', chromosome='8', genomic_nucleotide_accession_version='NC_000074.6', start_position_on_the_genomic_accession=106683068, end_position_on_the_genomic_accession=106851439, orientation='plus', exon_count=18, OMIM='', no_hdr0=''),
  665755 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=665755, CurrentID=0, Status='live', Symbol='LOC665755', Aliases='', description='PRAME family member 8-like', other_designations='', map_location='5', chromosome='5', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  100861637 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=100861637, CurrentID=0, Status='live', Symbol='Gm21095', Aliases='', description='predicted gene, 21095', other_designations='', map_location='Y', chromosome='Y', genomic_nucleotide_accession_version='NC_000087.7', start_position_on_the_genomic_accession=84097279, end_position_on_the_genomic_accession=84123388, orientation='plus', exon_count=10, OMIM='', no_hdr0=''),
  272551 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=272551, CurrentID=0, Status='live', Symbol='Gins2', Aliases='2210013I18Rik, 4833427B12Rik, AI323585, Pfs2', description='GINS complex subunit 2 (Psf2 homolog)', other_designations='', map_location='8 E1', chromosome='8', genomic_nucleotide_accession_version='NC_000074.6', start_position_on_the_genomic_accession=120581266, end_position_on_the_genomic_accession=120589075, orientation='minus', exon_count=5, OMIM='', no_hdr0=''),
  665775 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=665775, CurrentID=0, Status='live', Symbol='Bod1l', Aliases='A230054D04Rik, AI853319, FAM44A, mKIAA1327', description='biorientation of chromosomes in cell division 1-like', other_designations='family with sequence similarity 44, member A', map_location='5 B3', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=41787538, end_position_on_the_genomic_accession=41844365, orientation='minus', exon_count=28, OMIM='', no_hdr0=''),
  67272 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=67272, CurrentID=0, Status='live', Symbol='Cmtm5', Aliases='1500005P16Rik, 2900052H21Rik, Cklfsf5', description='CKLF-like MARVEL transmembrane domain containing 5', other_designations='chemokine-like factor super family 5|chemokine-like factor super family five variant 4|chemokine-like factor superfamily 5|chemokine-like factor superfamily member 5', map_location='14 C3', chromosome='14', genomic_nucleotide_accession_version='NC_000080.6', start_position_on_the_genomic_accession=54936470, end_position_on_the_genomic_accession=54939277, orientation='plus', exon_count=5, OMIM='', no_hdr0=''),
  102639794 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102639794, CurrentID=0, Status='live', Symbol='LOC102639794', Aliases='', description='disks large homolog 5-like', other_designations='', map_location='', chromosome='14', genomic_nucleotide_accession_version='NC_000080.6', start_position_on_the_genomic_accession=41619873, end_position_on_the_genomic_accession=41624602, orientation='minus', exon_count=5, OMIM='', no_hdr0=''),
  665780 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=665780, CurrentID=0, Status='live', Symbol='Zscan4b', Aliases='EG665780', description='zinc finger and SCAN domain containing 4B', other_designations='', map_location='7 A1', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=10900740, end_position_on_the_genomic_accession=10905050, orientation='minus', exon_count=4, OMIM='', no_hdr0=''),
  102639802 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102639802, CurrentID=0, Status='live', Symbol='Gm36028', Aliases='', description='predicted gene, 36028', other_designations='', map_location='16', chromosome='16', genomic_nucleotide_accession_version='NC_000082.6', start_position_on_the_genomic_accession=37851019, end_position_on_the_genomic_accession=37865237, orientation='minus', exon_count=6, OMIM='', no_hdr0=''),
  635253 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=635253, CurrentID=0, Status='live', Symbol='Usp51', Aliases='AV136873', description='ubiquitin specific protease 51', other_designations='ubiquitin specific peptidase 51', map_location='X F3', chromosome='X', genomic_nucleotide_accession_version='NC_000086.7', start_position_on_the_genomic_accession=153006381, end_position_on_the_genomic_accession=153009913, orientation='plus', exon_count=3, OMIM='', no_hdr0=''),
  665802 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=665802, CurrentID=0, Status='live', Symbol='Gm7792', Aliases='EG665802', description='predicted gene 7792', other_designations='', map_location='5', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=93794612, end_position_on_the_genomic_accession=93855307, orientation='plus', exon_count=5, OMIM='', no_hdr0=''),
  272589 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=272589, CurrentID=0, Status='live', Symbol='Tbcel', Aliases='D330014K23, E130107N23Rik, Lrrc35', description='tubulin folding cofactor E-like', other_designations='leucine rich repeat containing 35|leucine-rich repeat-containing protein 35', map_location='9 A5.1', chromosome='9', genomic_nucleotide_accession_version='NC_000075.6', start_position_on_the_genomic_accession=42412316, end_position_on_the_genomic_accession=42472275, orientation='minus', exon_count=10, OMIM='', no_hdr0=''),
  102639825 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102639825, CurrentID=0, Status='live', Symbol='Gm36047', Aliases='', description='predicted gene, 36047', other_designations='', map_location='Y', chromosome='Y', genomic_nucleotide_accession_version='NC_000087.7', start_position_on_the_genomic_accession=24188534, end_position_on_the_genomic_accession=24214673, orientation='minus', exon_count=11, OMIM='', no_hdr0=''),
  102639828 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102639828, CurrentID=0, Status='live', Symbol='Gm36049', Aliases='', description='predicted gene, 36049', other_designations='', map_location='X', chromosome='X', genomic_nucleotide_accession_version='NC_000086.7', start_position_on_the_genomic_accession=161340853, end_position_on_the_genomic_accession=161364590, orientation='plus', exon_count=6, OMIM='', no_hdr0=''),
  100861646 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=100861646, CurrentID=0, Status='live', Symbol='Gm21103', Aliases='', description='predicted gene, 21103', other_designations='', map_location='14', chromosome='14', genomic_nucleotide_accession_version='NC_000080.6', start_position_on_the_genomic_accession=6296367, end_position_on_the_genomic_accession=6304815, orientation='minus', exon_count=6, OMIM='', no_hdr0=''),
  100861647 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=100861647, CurrentID=0, Status='live', Symbol='Gm21104', Aliases='', description='predicted gene, 21104', other_designations='', map_location='4', chromosome='4', genomic_nucleotide_accession_version='NC_000070.6', start_position_on_the_genomic_accession=42070757, end_position_on_the_genomic_accession=42072707, orientation='minus', exon_count=4, OMIM='', no_hdr0=''),
  102639847 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102639847, CurrentID=0, Status='live', Symbol='LOC102639847', Aliases='', description='uncharacterized LOC102639847', other_designations='', map_location='', chromosome='8', genomic_nucleotide_accession_version='NC_000074.6', start_position_on_the_genomic_accession=47412408, end_position_on_the_genomic_accession=47414164, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  102639854 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102639854, CurrentID=0, Status='live', Symbol='Gm36068', Aliases='', description='predicted gene, 36068', other_designations='', map_location='3', chromosome='3', genomic_nucleotide_accession_version='NC_000069.6', start_position_on_the_genomic_accession=51781351, end_position_on_the_genomic_accession=51794296, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  102639862 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102639862, CurrentID=0, Status='live', Symbol='Gm21734', Aliases='', description='predicted gene, 21734', other_designations='', map_location='Y', chromosome='Y', genomic_nucleotide_accession_version='NC_000087.7', start_position_on_the_genomic_accession=85234675, end_position_on_the_genomic_accession=85235373, orientation='minus', exon_count=1, OMIM='', no_hdr0=''),
  102639863 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102639863, CurrentID=0, Status='live', Symbol='Gm21777', Aliases='', description='predicted gene, 21777', other_designations='', map_location='Y', chromosome='Y', genomic_nucleotide_accession_version='NC_000087.7', start_position_on_the_genomic_accession=88260252, end_position_on_the_genomic_accession=88262743, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  272636 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=272636, CurrentID=0, Status='live', Symbol='Esyt3', Aliases='D930024E11, D9Ertd280e, Fam62c, mKIAA4186', description='extended synaptotagmin-like protein 3', other_designations='E-Syt3|family with sequence similarity 62 (C2 domain containing), member C|family with sequence similarity 62, member C', map_location='9 51.54 cM', chromosome='9', genomic_nucleotide_accession_version='NC_000075.6', start_position_on_the_genomic_accession=99308739, end_position_on_the_genomic_accession=99360405, orientation='minus', exon_count=25, OMIM='', no_hdr0=''),
  102639870 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102639870, CurrentID=0, Status='live', Symbol='Gm38523', Aliases='', description='predicted gene, 38523', other_designations='', map_location='8', chromosome='8', genomic_nucleotide_accession_version='NC_000074.6', start_position_on_the_genomic_accession=111058697, end_position_on_the_genomic_accession=111065265, orientation='minus', exon_count=11, OMIM='', no_hdr0=''),
  272643 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=272643, CurrentID=0, Status='live', Symbol='Prss43', Aliases='Gm661, Tessp3', description='protease, serine 43', other_designations='protease, serine, 43|testis serine protease 3', map_location='9 F3', chromosome='9', genomic_nucleotide_accession_version='NC_000075.6', start_position_on_the_genomic_accession=110826690, end_position_on_the_genomic_accession=110831507, orientation='plus', exon_count=6, OMIM='', no_hdr0=''),
  329430 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=329430, CurrentID=0, Status='live', Symbol='A330043C09Rik', Aliases='Gm825', description='RIKEN cDNA A330043C09 gene', other_designations='', map_location='2 C3', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=75147118, end_position_on_the_genomic_accession=75177658, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  100861656 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=100861656, CurrentID=0, Status='live', Symbol='Gm21110', Aliases='', description='predicted gene, 21110', other_designations='', map_location='12', chromosome='12', genomic_nucleotide_accession_version='NC_000078.6', start_position_on_the_genomic_accession=19186599, end_position_on_the_genomic_accession=19200357, orientation='plus', exon_count=5, OMIM='', no_hdr0=''),
  102639895 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102639895, CurrentID=0, Status='live', Symbol='Gm28870', Aliases='', description='predicted gene 28870', other_designations='', map_location='Y', chromosome='Y', genomic_nucleotide_accession_version='NC_000087.7', start_position_on_the_genomic_accession=50095861, end_position_on_the_genomic_accession=50122116, orientation='plus', exon_count=8, OMIM='', no_hdr0=''),
  102639902 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102639902, CurrentID=0, Status='live', Symbol='Gm36103', Aliases='', description='predicted gene, 36103', other_designations='', map_location='5', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=115731573, end_position_on_the_genomic_accession=115734566, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  100861659 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=100861659, CurrentID=0, Status='live', Symbol='Gm21111', Aliases='', description='predicted gene, 21111', other_designations='', map_location='Y', chromosome='Y', genomic_nucleotide_accession_version='NC_000087.7', start_position_on_the_genomic_accession=75539715, end_position_on_the_genomic_accession=75541915, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  329436 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=329436, CurrentID=0, Status='live', Symbol='Gm14461', Aliases='A830093M07, OTTMUSG00000016703', description='predicted gene 14461', other_designations='', map_location='2', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=78237547, end_position_on_the_genomic_accession=78302230, orientation='plus', exon_count=6, OMIM='', no_hdr0=''),
  665902 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=665902, CurrentID=0, Status='live', Symbol='Zscan4f', Aliases='C330039H09Rik', description='zinc finger and SCAN domain containing 4F', other_designations='', map_location='7 A1', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=11397915, end_position_on_the_genomic_accession=11402318, orientation='plus', exon_count=4, OMIM='', no_hdr0=''),
  102639919 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102639919, CurrentID=0, Status='live', Symbol='Gm36118', Aliases='', description='predicted gene, 36118', other_designations='', map_location='9', chromosome='9', genomic_nucleotide_accession_version='NC_000075.6', start_position_on_the_genomic_accession=21149889, end_position_on_the_genomic_accession=21168065, orientation='minus', exon_count=5, OMIM='', no_hdr0=''),
  100861663 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=100861663, CurrentID=0, Status='live', Symbol='Gm21115', Aliases='', description='predicted gene, 21115', other_designations='', map_location='7', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=38446453, end_position_on_the_genomic_accession=38452548, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  102639934 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102639934, CurrentID=0, Status='live', Symbol='Astx4d', Aliases='Gm14960, OTTMUSG00000018599', description='amplified spermatogenic transcripts X encoded 4D', other_designations='', map_location='X 49.81 cM', chromosome='X', genomic_nucleotide_accession_version='NC_000086.7', start_position_on_the_genomic_accession=125908603, end_position_on_the_genomic_accession=125920688, orientation='plus', exon_count=11, OMIM='', no_hdr0=''),
  102639938 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102639938, CurrentID=0, Status='live', Symbol='Gm21787', Aliases='', description='predicted gene, 21787', other_designations='', map_location='Y', chromosome='Y', genomic_nucleotide_accession_version='NC_000087.7', start_position_on_the_genomic_accession=38671811, end_position_on_the_genomic_accession=38674037, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  102639942 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102639942, CurrentID=0, Status='live', Symbol='Gm21899', Aliases='', description='predicted gene, 21899', other_designations='', map_location='Y', chromosome='Y', genomic_nucleotide_accession_version='NC_000087.7', start_position_on_the_genomic_accession=52328299, end_position_on_the_genomic_accession=52330819, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  665927 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=665927, CurrentID=0, Status='live', Symbol='Gm7849', Aliases='EG665927', description='predicted gene 7849', other_designations='novel defensin-related cryptidin', map_location='8 A2', chromosome='8', genomic_nucleotide_accession_version='NC_000074.6', start_position_on_the_genomic_accession=21455427, end_position_on_the_genomic_accession=21456517, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  665936 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=665936, CurrentID=0, Status='live', Symbol='Gm7855', Aliases='EG665936', description='predicted gene 7855', other_designations='', map_location='X E3', chromosome='X', genomic_nucleotide_accession_version='NC_000086.7', start_position_on_the_genomic_accession=134624937, end_position_on_the_genomic_accession=134628404, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  100861667 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=100861667, CurrentID=0, Status='live', Symbol='Gm21118', Aliases='', description='predicted gene, 21118', other_designations='', map_location='Y', chromosome='Y', genomic_nucleotide_accession_version='NC_000087.7', start_position_on_the_genomic_accession=70271441, end_position_on_the_genomic_accession=70272124, orientation='minus', exon_count=1, OMIM='', no_hdr0=''),
  665943 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=665943, CurrentID=0, Status='live', Symbol='E330014E10Rik', Aliases='', description='RIKEN cDNA E330014E10 gene', other_designations='', map_location='5 E3', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=95775870, end_position_on_the_genomic_accession=95804230, orientation='plus', exon_count=6, OMIM='', no_hdr0=''),
  100861668 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=100861668, CurrentID=0, Status='live', Symbol='Gm21119', Aliases='', description='predicted gene, 21119', other_designations='', map_location='8', chromosome='8', genomic_nucleotide_accession_version='NC_000074.6', start_position_on_the_genomic_accession=20614405, end_position_on_the_genomic_accession=20657119, orientation='plus', exon_count=12, OMIM='', no_hdr0=''),
  665956 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=665956, CurrentID=0, Status='live', Symbol='Gm7861', Aliases='EG665956', description='predicted gene 7861', other_designations='novel defensin-related cryptidin', map_location='8 A2', chromosome='8', genomic_nucleotide_accession_version='NC_000074.6', start_position_on_the_genomic_accession=21593487, end_position_on_the_genomic_accession=21594465, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  665975 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=665975, CurrentID=0, Status='live', Symbol='Gm7873', Aliases='EG665975', description='predicted gene 7873', other_designations='', map_location='16 A3', chromosome='16', genomic_nucleotide_accession_version='NC_000082.5', start_position_on_the_genomic_accession=18217972, end_position_on_the_genomic_accession=18220440, orientation='plus', exon_count=8, OMIM='', no_hdr0=''),
  102639995 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102639995, CurrentID=0, Status='live', Symbol='Gm36176', Aliases='', description='predicted gene, 36176', other_designations='', map_location='10', chromosome='10', genomic_nucleotide_accession_version='NC_000076.6', start_position_on_the_genomic_accession=77846805, end_position_on_the_genomic_accession=77847377, orientation='plus', exon_count=1, OMIM='', no_hdr0=''),
  665981 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=665981, CurrentID=0, Status='live', Symbol='Gm7876', Aliases='', description='predicted gene 7876', other_designations='alpha takusan-like', map_location='14', chromosome='14', genomic_nucleotide_accession_version='NC_000080.6', start_position_on_the_genomic_accession=4709232, end_position_on_the_genomic_accession=4717680, orientation='plus', exon_count=6, OMIM='', no_hdr0=''),
  102640001 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102640001, CurrentID=0, Status='live', Symbol='Gm29420', Aliases='', description='predicted gene 29420', other_designations='', map_location='Y', chromosome='Y', genomic_nucleotide_accession_version='NC_000087.7', start_position_on_the_genomic_accession=63121508, end_position_on_the_genomic_accession=63123974, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  102640003 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102640003, CurrentID=0, Status='live', Symbol='Gm36182', Aliases='', description='predicted gene, 36182', other_designations='', map_location='5', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=31405853, end_position_on_the_genomic_accession=31434777, orientation='minus', exon_count=5, OMIM='', no_hdr0=''),
  665992 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=665992, CurrentID=0, Status='live', Symbol='Krtap4-8', Aliases='OTTMUSG00000002541', description='keratin associated protein 4-8', other_designations='', map_location='11', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=99780014, end_position_on_the_genomic_accession=99780643, orientation='minus', exon_count=1, OMIM='', no_hdr0=''),
  665998 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=665998, CurrentID=0, Status='live', Symbol='Krtap4-9', Aliases='OTTMUSG00000002198', description='keratin associated protein 4-9', other_designations='', map_location='11', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=99785200, end_position_on_the_genomic_accession=99786257, orientation='plus', exon_count=1, OMIM='', no_hdr0=''),
  102640016 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102640016, CurrentID=0, Status='live', Symbol='Gm36191', Aliases='', description='predicted gene, 36191', other_designations='', map_location='7', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=135465235, end_position_on_the_genomic_accession=135467348, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  666002 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=666002, CurrentID=0, Status='live', Symbol='Vmn2r114', Aliases='EG666002, V2Rp3', description='vomeronasal 2, receptor 114', other_designations='vomeronasal 2 receptor p3', map_location='17 A3.3', chromosome='17', genomic_nucleotide_accession_version='NC_000083.6', start_position_on_the_genomic_accession=23290934, end_position_on_the_genomic_accession=23312313, orientation='minus', exon_count=6, OMIM='', no_hdr0=''),
  666004 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=666004, CurrentID=0, Status='live', Symbol='Gm7886', Aliases='EG666004', description='predicted gene 7886', other_designations='', map_location='3 B', chromosome='3', genomic_nucleotide_accession_version='NC_000069.5', start_position_on_the_genomic_accession=41188452, end_position_on_the_genomic_accession=41197629, orientation='plus', exon_count=3, OMIM='', no_hdr0=''),
  272790 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=272790, CurrentID=0, Status='live', Symbol='Magee2', Aliases='9630059J11Rik, BB131182, Mage-e2', description='melanoma antigen, family E, 2', other_designations='', map_location='X C3', chromosome='X', genomic_nucleotide_accession_version='NC_000086.7', start_position_on_the_genomic_accession=104854952, end_position_on_the_genomic_accession=104857267, orientation='minus', exon_count=1, OMIM='', no_hdr0=''),
  102640024 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102640024, CurrentID=0, Status='live', Symbol='LOC102640024', Aliases='', description='diamine acetyltransferase 1-like', other_designations='', map_location='', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=29794187, end_position_on_the_genomic_accession=29795527, orientation='minus', exon_count=1, OMIM='', no_hdr0=''),
  666009 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=666009, CurrentID=0, Status='live', Symbol='Gm7889', Aliases='EG666009', description='predicted gene 7889', other_designations='', map_location='1 D', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=93967806, end_position_on_the_genomic_accession=93985871, orientation='plus', exon_count=8, OMIM='', no_hdr0=''),
  100861679 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=100861679, CurrentID=0, Status='live', Symbol='Gm21129', Aliases='', description='predicted gene, 21129', other_designations='', map_location='7', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=38816064, end_position_on_the_genomic_accession=38826400, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  102640032 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102640032, CurrentID=0, Status='live', Symbol='Gm36202', Aliases='', description='predicted gene, 36202', other_designations='', map_location='17', chromosome='17', genomic_nucleotide_accession_version='NC_000083.6', start_position_on_the_genomic_accession=84386610, end_position_on_the_genomic_accession=84391500, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  102640043 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102640043, CurrentID=0, Status='live', Symbol='Gm36210', Aliases='', description='predicted gene, 36210', other_designations='', map_location='7', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=4897698, end_position_on_the_genomic_accession=4907809, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  666028 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=666028, CurrentID=0, Status='live', Symbol='Gm7897', Aliases='EG666028', description='predicted gene 7897', other_designations='', map_location='1 H3', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=173824708, end_position_on_the_genomic_accession=173841249, orientation='minus', exon_count=6, OMIM='', no_hdr0=''),
  102640049 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102640049, CurrentID=0, Status='live', Symbol='Gm28770', Aliases='', description='predicted gene 28770', other_designations='', map_location='Y', chromosome='Y', genomic_nucleotide_accession_version='NC_000087.7', start_position_on_the_genomic_accession=38746128, end_position_on_the_genomic_accession=38748466, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  102640052 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102640052, CurrentID=0, Status='live', Symbol='Gm21855', Aliases='', description='predicted gene, 21855', other_designations='', map_location='Y', chromosome='Y', genomic_nucleotide_accession_version='NC_000087.7', start_position_on_the_genomic_accession=73383269, end_position_on_the_genomic_accession=73385774, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  102640053 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102640053, CurrentID=0, Status='live', Symbol='Gm28700', Aliases='', description='predicted gene 28700', other_designations='', map_location='Y', chromosome='Y', genomic_nucleotide_accession_version='NC_000087.7', start_position_on_the_genomic_accession=77496205, end_position_on_the_genomic_accession=77507106, orientation='plus', exon_count=5, OMIM='', no_hdr0=''),
  102640055 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102640055, CurrentID=0, Status='live', Symbol='Gm21785', Aliases='', description='predicted gene, 21785', other_designations='', map_location='Y', chromosome='Y', genomic_nucleotide_accession_version='NC_000087.7', start_position_on_the_genomic_accession=85453699, end_position_on_the_genomic_accession=85456050, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  102640056 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102640056, CurrentID=0, Status='live', Symbol='Gm21792', Aliases='', description='predicted gene, 21792', other_designations='', map_location='Y', chromosome='Y', genomic_nucleotide_accession_version='NC_000087.7', start_position_on_the_genomic_accession=88401230, end_position_on_the_genomic_accession=88403645, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  67316 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=67316, CurrentID=0, Status='live', Symbol='1700037F03Rik', Aliases='', description='RIKEN cDNA 1700037F03 gene', other_designations='', map_location='13', chromosome='13', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  666048 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=666048, CurrentID=0, Status='live', Symbol='Trabd2b', Aliases='Gm12824, Hkat, OTTMUSG00000008561', description='TraB domain containing 2B', other_designations='TRAB domain-containing protein 2B|UPF0632 protein A|heart, kidney and adipose-enriched transmembrane protein', map_location='4', chromosome='4', genomic_nucleotide_accession_version='NC_000070.6', start_position_on_the_genomic_accession=114406194, end_position_on_the_genomic_accession=114615098, orientation='plus', exon_count=9, OMIM='', no_hdr0=''),
  666060 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=666060, CurrentID=0, Status='live', Symbol='Frmpd1', Aliases='BC031840, mKIAA0967', description='FERM and PDZ domain containing 1', other_designations='', map_location='4 B1', chromosome='4', genomic_nucleotide_accession_version='NC_000070.6', start_position_on_the_genomic_accession=45184417, end_position_on_the_genomic_accession=45285936, orientation='plus', exon_count=21, OMIM='', no_hdr0=''),
  666071 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=666071, CurrentID=0, Status='live', Symbol='Gm7915', Aliases='EG666071', description='predicted gene 7915', other_designations='', map_location='5 G2', chromosome='5', genomic_nucleotide_accession_version='NC_000071.5', start_position_on_the_genomic_accession=135027531, end_position_on_the_genomic_accession=135034165, orientation='plus', exon_count=3, OMIM='', no_hdr0=''),
  100861691 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=100861691, CurrentID=0, Status='live', Symbol='LOC100861691', Aliases='', description='X-linked lymphocyte-regulated protein PM1-like', other_designations='', map_location='', chromosome='Y', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  666085 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=666085, CurrentID=0, Status='live', Symbol='Vmn2r54', Aliases='EG666085, Gm1496, Gm470', description='vomeronasal 2, receptor 54', other_designations='V2R receptor|vomeronasal receptor Vmn2r54', map_location='7', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=12615233, end_position_on_the_genomic_accession=12636134, orientation='minus', exon_count=5, OMIM='', no_hdr0=''),
  666096 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=666096, CurrentID=0, Status='live', Symbol='Gm14594', Aliases='OTTMUSG00000017373', description='predicted gene 14594', other_designations='', map_location='X', chromosome='X', genomic_nucleotide_accession_version='NC_000086.7', start_position_on_the_genomic_accession=54440097, end_position_on_the_genomic_accession=54457011, orientation='plus', exon_count=6, OMIM='', no_hdr0=''),
  666099 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=666099, CurrentID=0, Status='live', Symbol='Gm7929', Aliases='EG666099', description='predicted gene 7929', other_designations='', map_location='14 B', chromosome='14', genomic_nucleotide_accession_version='NC_000080.5', start_position_on_the_genomic_accession=42042756, end_position_on_the_genomic_accession=42078395, orientation='minus', exon_count=8, OMIM='', no_hdr0=''),
  329470 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=329470, CurrentID=0, Status='live', Symbol='Accs', Aliases='2610203E10Rik, Phacs', description='1-aminocyclopropane-1-carboxylate synthase (non-functional)', other_designations='1-aminocyclopropane-1-carboxylate synthase homolog|ACC synthase-like protein 1', map_location='2 E1', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=93833467, end_position_on_the_genomic_accession=93849995, orientation='minus', exon_count=16, OMIM='', no_hdr0=''),
  666114 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=666114, CurrentID=0, Status='live', Symbol='Gm7936', Aliases='EG666114', description='predicted pseudogene 7936', other_designations='', map_location='18 B1', chromosome='18', genomic_nucleotide_accession_version='NC_000084.6', start_position_on_the_genomic_accession=30494903, end_position_on_the_genomic_accession=30495433, orientation='minus', exon_count=1, OMIM='', no_hdr0=''),
  666122 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=666122, CurrentID=0, Status='live', Symbol='Gm14595', Aliases='OTTMUSG00000017374', description='predicted gene 14595', other_designations='', map_location='X', chromosome='X', genomic_nucleotide_accession_version='NC_000086.7', start_position_on_the_genomic_accession=54713174, end_position_on_the_genomic_accession=54730013, orientation='plus', exon_count=6, OMIM='', no_hdr0=''),
  102640139 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102640139, CurrentID=0, Status='live', Symbol='LOC102640139', Aliases='', description='predicted GPI-anchored protein 58', other_designations='', map_location='', chromosome='Un', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  102640144 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102640144, CurrentID=0, Status='live', Symbol='Gm17167', Aliases='', description='predicted gene 17167', other_designations='', map_location='4 22.32 cM', chromosome='4', genomic_nucleotide_accession_version='NC_000070.6', start_position_on_the_genomic_accession=42232086, end_position_on_the_genomic_accession=42233788, orientation='plus', exon_count=1, OMIM='', no_hdr0=''),
  666133 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=666133, CurrentID=0, Status='live', Symbol='Gm7942', Aliases='EG666133', description='predicted gene 7942', other_designations='', map_location='5 E3', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=95109011, end_position_on_the_genomic_accession=95112068, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  666135 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=666135, CurrentID=0, Status='live', Symbol='Gm14590', Aliases='OTTMUSG00000017363', description='predicted gene 14590', other_designations='', map_location='X', chromosome='X', genomic_nucleotide_accession_version='NC_000086.7', start_position_on_the_genomic_accession=54810820, end_position_on_the_genomic_accession=54827792, orientation='plus', exon_count=6, OMIM='', no_hdr0=''),
  666138 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=666138, CurrentID=0, Status='live', Symbol='Gm7945', Aliases='EG666138', description='predicted gene 7945', other_designations='', map_location='14 B', chromosome='14', genomic_nucleotide_accession_version='NC_000080.5', start_position_on_the_genomic_accession=42194917, end_position_on_the_genomic_accession=42199642, orientation='minus', exon_count=6, OMIM='', no_hdr0=''),
  666145 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=666145, CurrentID=0, Status='live', Symbol='1700016G14Rik', Aliases='', description='RIKEN cDNA 1700016G14 gene', other_designations='', map_location='13 A3.1', chromosome='13', genomic_nucleotide_accession_version='NC_000079.6', start_position_on_the_genomic_accession=24733875, end_position_on_the_genomic_accession=24746592, orientation='plus', exon_count=3, OMIM='', no_hdr0=''),
  67334 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=67334, CurrentID=0, Status='live', Symbol='Hypm', Aliases='1700054O13Rik, H2al3', description='huntingtin interacting protein M', other_designations='huntingtin yeast partner M', map_location='X A1.2', chromosome='X', genomic_nucleotide_accession_version='NC_000086.7', start_position_on_the_genomic_accession=9846947, end_position_on_the_genomic_accession=9847500, orientation='plus', exon_count=1, OMIM='', no_hdr0=''),
  666151 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=666151, CurrentID=0, Status='live', Symbol='Gm7950', Aliases='EG666151', description='predicted pseudogene 7950', other_designations='', map_location='X A5', chromosome='X', genomic_nucleotide_accession_version='NC_000086.7', start_position_on_the_genomic_accession=55019202, end_position_on_the_genomic_accession=55036109, orientation='plus', exon_count=6, OMIM='', no_hdr0=''),
  666152 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=666152, CurrentID=0, Status='live', Symbol='Gm7951', Aliases='EG666152', description='predicted gene 7951', other_designations='', map_location='14 B', chromosome='14', genomic_nucleotide_accession_version='NC_000080.5', start_position_on_the_genomic_accession=42690770, end_position_on_the_genomic_accession=42696198, orientation='minus', exon_count=5, OMIM='', no_hdr0=''),
  102640171 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102640171, CurrentID=0, Status='live', Symbol='Gm38525', Aliases='', description='predicted gene, 38525', other_designations='', map_location='7', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=104355396, end_position_on_the_genomic_accession=104369881, orientation='minus', exon_count=8, OMIM='', no_hdr0=''),
  666156 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=666156, CurrentID=0, Status='live', Symbol='Gm7954', Aliases='EG666156', description='predicted gene 7954', other_designations='', map_location='14 B', chromosome='14', genomic_nucleotide_accession_version='NC_000080.5', start_position_on_the_genomic_accession=42261033, end_position_on_the_genomic_accession=42266948, orientation='minus', exon_count=7, OMIM='', no_hdr0=''),
  666161 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=666161, CurrentID=0, Status='live', Symbol='Gm7958', Aliases='EG666161', description='predicted gene 7958', other_designations='', map_location='X A5', chromosome='X', genomic_nucleotide_accession_version='NC_000086.7', start_position_on_the_genomic_accession=55095566, end_position_on_the_genomic_accession=55112454, orientation='plus', exon_count=6, OMIM='', no_hdr0=''),
  666168 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=666168, CurrentID=0, Status='live', Symbol='Cyp4a31', Aliases='', description='cytochrome P450, family 4, subfamily a, polypeptide 31', other_designations='', map_location='4 D1', chromosome='4', genomic_nucleotide_accession_version='NC_000070.6', start_position_on_the_genomic_accession=115563626, end_position_on_the_genomic_accession=115579015, orientation='plus', exon_count=12, OMIM='', no_hdr0=''),
  666173 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=666173, CurrentID=0, Status='live', Symbol='Vps13b', Aliases='1810042B05Rik, 2310042E16Rik, 4732488H20, C330002D13Rik, C87206, Coh1, D230005K13, mKIAA0532, mKIAA5032', description='vacuolar protein sorting 13B (yeast)', other_designations='Cohen syndrome homolog 1|cohen syndrome protein 1 homolog', map_location='15 B3.1', chromosome='15', genomic_nucleotide_accession_version='NC_000081.6', start_position_on_the_genomic_accession=35369882, end_position_on_the_genomic_accession=35931229, orientation='plus', exon_count=66, OMIM='', no_hdr0=''),
  102640196 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102640196, CurrentID=0, Status='live', Symbol='Gm36323', Aliases='', description='predicted gene, 36323', other_designations='', map_location='3', chromosome='3', genomic_nucleotide_accession_version='NC_000069.6', start_position_on_the_genomic_accession=91628563, end_position_on_the_genomic_accession=91630704, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  666184 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=666184, CurrentID=0, Status='live', Symbol='Gm15080', Aliases='OTTMUSG00000018964, Ott-like', description='predicted gene 15080', other_designations='', map_location='X', chromosome='X', genomic_nucleotide_accession_version='NC_000086.7', start_position_on_the_genomic_accession=147992993, end_position_on_the_genomic_accession=148033174, orientation='plus', exon_count=7, OMIM='', no_hdr0=''),
  666185 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=666185, CurrentID=0, Status='live', Symbol='Gm7969', Aliases='', description='predicted gene 7969', other_designations='', map_location='13', chromosome='13', genomic_nucleotide_accession_version='NC_000079.6', start_position_on_the_genomic_accession=67949751, end_position_on_the_genomic_accession=67954507, orientation='plus', exon_count=3, OMIM='', no_hdr0=''),
  666186 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=666186, CurrentID=0, Status='live', Symbol='Gm7970', Aliases='EG666186', description='predicted gene 7970', other_designations='', map_location='14 B', chromosome='14', genomic_nucleotide_accession_version='NC_000080.6', start_position_on_the_genomic_accession=41550837, end_position_on_the_genomic_accession=41555653, orientation='minus', exon_count=5, OMIM='', no_hdr0=''),
  666187 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=666187, CurrentID=0, Status='live', Symbol='Gm7971', Aliases='', description='predicted gene 7971', other_designations='', map_location='5', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=95590835, end_position_on_the_genomic_accession=95595018, orientation='minus', exon_count=4, OMIM='', no_hdr0=''),
  666190 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=666190, CurrentID=0, Status='live', Symbol='Gm7972', Aliases='EG666190', description='predicted gene 7972', other_designations='', map_location='9 D', chromosome='9', genomic_nucleotide_accession_version='NC_000075.6', start_position_on_the_genomic_accession=75470338, end_position_on_the_genomic_accession=75486685, orientation='plus', exon_count=10, OMIM='', no_hdr0=''),
  100861709 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=100861709, CurrentID=0, Status='live', Symbol='Gm21155', Aliases='', description='predicted gene, 21155', other_designations='', map_location='Y', chromosome='Y', genomic_nucleotide_accession_version='NC_000087.7', start_position_on_the_genomic_accession=76500784, end_position_on_the_genomic_accession=76501467, orientation='minus', exon_count=1, OMIM='', no_hdr0=''),
  666203 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=666203, CurrentID=0, Status='live', Symbol='Gm7978', Aliases='EG666203', description='predicted gene 7978', other_designations='', map_location='5', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=95732092, end_position_on_the_genomic_accession=95736173, orientation='minus', exon_count=4, OMIM='', no_hdr0=''),
  666207 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=666207, CurrentID=0, Status='live', Symbol='Gm7980', Aliases='EG666207', description='predicted gene 7980', other_designations='', map_location='14 B', chromosome='14', genomic_nucleotide_accession_version='NC_000080.6', start_position_on_the_genomic_accession=41902530, end_position_on_the_genomic_accession=41907360, orientation='minus', exon_count=5, OMIM='', no_hdr0=''),
  666209 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=666209, CurrentID=0, Status='live', Symbol='Gm7982', Aliases='EG666209', description='predicted gene 7982', other_designations='', map_location='5 E3', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=95686406, end_position_on_the_genomic_accession=95746555, orientation='plus', exon_count=6, OMIM='', no_hdr0=''),
  102640232 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102640232, CurrentID=0, Status='live', Symbol='Gm36349', Aliases='', description='predicted gene, 36349', other_designations='', map_location='13', chromosome='13', genomic_nucleotide_accession_version='NC_000079.6', start_position_on_the_genomic_accession=61912762, end_position_on_the_genomic_accession=61914649, orientation='plus', exon_count=3, OMIM='', no_hdr0=''),
  666218 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=666218, CurrentID=0, Status='live', Symbol='Gm847', Aliases='', description='predicted gene 847', other_designations='', map_location='9 F4', chromosome='9', genomic_nucleotide_accession_version='NC_000075.5', start_position_on_the_genomic_accession=122656464, end_position_on_the_genomic_accession=122680440, orientation='plus', exon_count=7, OMIM='', no_hdr0=''),
  666228 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=666228, CurrentID=0, Status='live', Symbol='Gm7991', Aliases='EG666228', description='predicted gene 7991', other_designations='', map_location='14 B', chromosome='14', genomic_nucleotide_accession_version='NC_000080.5', start_position_on_the_genomic_accession=42645871, end_position_on_the_genomic_accession=42648109, orientation='plus', exon_count=3, OMIM='', no_hdr0=''),
  666233 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=666233, CurrentID=0, Status='live', Symbol='Gm7995', Aliases='100041950, Gm3586', description='predicted gene 7995', other_designations='', map_location='14', chromosome='14', genomic_nucleotide_accession_version='NC_000080.6', start_position_on_the_genomic_accession=42219313, end_position_on_the_genomic_accession=42325396, orientation='plus', exon_count=8, OMIM='', no_hdr0=''),
  666238 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=666238, CurrentID=0, Status='live', Symbol='Gm7998', Aliases='', description='predicted gene 7998', other_designations='', map_location='13 B3', chromosome='13', genomic_nucleotide_accession_version='NC_000079.5', start_position_on_the_genomic_accession=68367965, end_position_on_the_genomic_accession=68370697, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  666244 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=666244, CurrentID=0, Status='live', Symbol='Tmsb15b1', Aliases='Tm15b', description='thymosin beta 15b1', other_designations='', map_location='X', chromosome='X', genomic_nucleotide_accession_version='NC_000086.7', start_position_on_the_genomic_accession=136974022, end_position_on_the_genomic_accession=136976874, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  102640263 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102640263, CurrentID=0, Status='live', Symbol='Gm36375', Aliases='', description='predicted gene, 36375', other_designations='', map_location='12', chromosome='12', genomic_nucleotide_accession_version='NC_000078.6', start_position_on_the_genomic_accession=100487661, end_position_on_the_genomic_accession=100493910, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  102640264 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102640264, CurrentID=0, Status='live', Symbol='Gm21895', Aliases='', description='predicted gene, 21895', other_designations='', map_location='Y', chromosome='Y', genomic_nucleotide_accession_version='NC_000087.7', start_position_on_the_genomic_accession=65789540, end_position_on_the_genomic_accession=65792021, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  102640268 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102640268, CurrentID=0, Status='live', Symbol='Gm2956', Aliases='100040767, Gm36379', description='predicted gene 2956', other_designations='', map_location='14', chromosome='14', genomic_nucleotide_accession_version='NC_000080.6', start_position_on_the_genomic_accession=3331977, end_position_on_the_genomic_accession=3353742, orientation='plus', exon_count=14, OMIM='', no_hdr0=''),
  666253 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=666253, CurrentID=0, Status='live', Symbol='Gm8005', Aliases='EG666253', description='predicted gene 8005', other_designations='', map_location='14 B', chromosome='14', genomic_nucleotide_accession_version='NC_000080.6', start_position_on_the_genomic_accession=42434261, end_position_on_the_genomic_accession=42439663, orientation='minus', exon_count=5, OMIM='', no_hdr0=''),
  67352 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=67352, CurrentID=0, Status='live', Symbol='1700093E11Rik', Aliases='', description='RIKEN cDNA 1700093E11 gene', other_designations='', map_location='2', chromosome='2', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  102640292 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102640292, CurrentID=0, Status='live', Symbol='LOC102640292', Aliases='', description='uncharacterized LOC102640292', other_designations='', map_location='', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=59869731, end_position_on_the_genomic_accession=59905152, orientation='minus', exon_count=14, OMIM='', no_hdr0=''),
  102640293 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102640293, CurrentID=0, Status='live', Symbol='Gm36398', Aliases='', description='predicted gene, 36398', other_designations='', map_location='Y', chromosome='Y', genomic_nucleotide_accession_version='NC_000087.7', start_position_on_the_genomic_accession=13531052, end_position_on_the_genomic_accession=13533498, orientation='plus', exon_count=3, OMIM='', no_hdr0=''),
  666279 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=666279, CurrentID=0, Status='live', Symbol='Dspp', Aliases='Dmp2, Dmp3, Dpp, Dsp', description='dentin sialophosphoprotein', other_designations='DMP-3|dentin matrix protein 3', map_location='5 50.59 cM', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=104170712, end_position_on_the_genomic_accession=104180127, orientation='plus', exon_count=5, OMIM='', no_hdr0=''),
  102640296 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102640296, CurrentID=0, Status='live', Symbol='Gm12881', Aliases='OTTMUSG00000008903', description='predicted gene 12881', other_designations='', map_location='4 56.8 cM', chromosome='4', genomic_nucleotide_accession_version='NC_000070.6', start_position_on_the_genomic_accession=121120874, end_position_on_the_genomic_accession=121130213, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  666285 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=666285, CurrentID=0, Status='live', Symbol='Gm8024', Aliases='EG666285', description='predicted gene 8024', other_designations='', map_location='14 B', chromosome='14', genomic_nucleotide_accession_version='NC_000080.5', start_position_on_the_genomic_accession=43098131, end_position_on_the_genomic_accession=43103114, orientation='minus', exon_count=5, OMIM='', no_hdr0=''),
  666290 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=666290, CurrentID=0, Status='live', Symbol='Gm8026', Aliases='EG666290', description='predicted gene 8026', other_designations='', map_location='1 B', chromosome='1', genomic_nucleotide_accession_version='NC_000067.5', start_position_on_the_genomic_accession=36059830, end_position_on_the_genomic_accession=36067883, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  329502 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=329502, CurrentID=0, Status='live', Symbol='Pla2g4e', Aliases='2310026J01Rik, C230096D22, Pla2epsilon', description='phospholipase A2, group IVE', other_designations='cPLA2-epsilon|phospholipase A2, group 4E', map_location='2 E5', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=120166412, end_position_on_the_genomic_accession=120245625, orientation='minus', exon_count=24, OMIM='', no_hdr0=''),
  666298 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=666298, CurrentID=0, Status='live', Symbol='Gm8032', Aliases='EG666298', description='predicted gene 8032', other_designations='', map_location='14 B', chromosome='14', genomic_nucleotide_accession_version='NC_000080.6', start_position_on_the_genomic_accession=42557053, end_position_on_the_genomic_accession=42567023, orientation='plus', exon_count=5, OMIM='', no_hdr0=''),
  666299 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=666299, CurrentID=0, Status='live', Symbol='Gm8033', Aliases='', description='predicted gene 8033', other_designations='', map_location='17 A3.3', chromosome='17', genomic_nucleotide_accession_version='NC_000083.5', start_position_on_the_genomic_accession=24616069, end_position_on_the_genomic_accession=24625542, orientation='plus', exon_count=3, OMIM='', no_hdr0=''),
  102640318 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102640318, CurrentID=0, Status='live', Symbol='Gm36415', Aliases='', description='predicted gene, 36415', other_designations='', map_location='10', chromosome='10', genomic_nucleotide_accession_version='NC_000076.6', start_position_on_the_genomic_accession=25000033, end_position_on_the_genomic_accession=25249838, orientation='plus', exon_count=4, OMIM='', no_hdr0=''),
  102640325 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102640325, CurrentID=0, Status='live', Symbol='LOC102640325', Aliases='', description='uncharacterized LOC102640325', other_designations='', map_location='', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=6397958, end_position_on_the_genomic_accession=6409771, orientation='plus', exon_count=3, OMIM='', no_hdr0=''),
  666311 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=666311, CurrentID=0, Status='live', Symbol='Zscan25', Aliases='EG666311, Zfp498', description='zinc finger and SCAN domain containing 25', other_designations='zinc finger protein 498', map_location='5 G2', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=145280468, end_position_on_the_genomic_accession=145291495, orientation='plus', exon_count=6, OMIM='', no_hdr0=''),
  666317 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=666317, CurrentID=0, Status='live', Symbol='Prl2c1', Aliases='Ghd22', description='Prolactin family 2, subfamily c, member 1', other_designations='growth hormone d22', map_location='13 A3.1', chromosome='13', genomic_nucleotide_accession_version='NC_000079.6', start_position_on_the_genomic_accession=27849327, end_position_on_the_genomic_accession=27857791, orientation='plus', exon_count=5, OMIM='', no_hdr0=''),
  666329 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=666329, CurrentID=0, Status='live', Symbol='Gm3317', Aliases='100041401', description='predicted gene 3317', other_designations='alpha22-takusan', map_location='14', chromosome='14', genomic_nucleotide_accession_version='NC_000080.6', start_position_on_the_genomic_accession=5148982, end_position_on_the_genomic_accession=5170292, orientation='plus', exon_count=10, OMIM='', no_hdr0=''),
  666331 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=666331, CurrentID=0, Status='live', Symbol='LOC666331', Aliases='', description='uncharacterized LOC666331', other_designations='', map_location='11 D', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=101610700, end_position_on_the_genomic_accession=101616638, orientation='plus', exon_count=4, OMIM='', no_hdr0=''),
  329509 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=329509, CurrentID=0, Status='live', Symbol='1810024B03Rik', Aliases='', description='RIKEN cDNA 1810024B03 gene', other_designations='', map_location='2 F1', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=127186165, end_position_on_the_genomic_accession=127208280, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  404194 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=404194, CurrentID=0, Status='live', Symbol='Gfral', Aliases='AY457637, Gral', description='GDNF family receptor alpha like', other_designations='GDNF receptor alpha-like', map_location='9 D', chromosome='9', genomic_nucleotide_accession_version='NC_000075.6', start_position_on_the_genomic_accession=76164102, end_position_on_the_genomic_accession=76213657, orientation='minus', exon_count=9, OMIM='', no_hdr0=''),
  666339 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=666339, CurrentID=0, Status='live', Symbol='Muc3', Aliases='', description='mucin 3, intestinal', other_designations='CAAA01224633.1', map_location='5 76.22 cM', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=137134924, end_position_on_the_genomic_accession=137166048, orientation='minus', exon_count=14, OMIM='', no_hdr0=''),
  100861734 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=100861734, CurrentID=0, Status='live', Symbol='Gm21173', Aliases='', description='predicted gene, 21173', other_designations='', map_location='Y', chromosome='Y', genomic_nucleotide_accession_version='NC_000087.7', start_position_on_the_genomic_accession=76761583, end_position_on_the_genomic_accession=76787711, orientation='plus', exon_count=11, OMIM='', no_hdr0=''),
  666348 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=666348, CurrentID=0, Status='live', Symbol='Apol7e', Aliases='ENSMUSG00000071716', description='apolipoprotein L 7e', other_designations='', map_location='15 E1', chromosome='15', genomic_nucleotide_accession_version='NC_000081.6', start_position_on_the_genomic_accession=77695719, end_position_on_the_genomic_accession=77719288, orientation='plus', exon_count=6, OMIM='', no_hdr0=''),
  102640367 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102640367, CurrentID=0, Status='live', Symbol='Gm21881', Aliases='', description='predicted gene, 21881', other_designations='', map_location='Y', chromosome='Y', genomic_nucleotide_accession_version='NC_000087.7', start_position_on_the_genomic_accession=85814092, end_position_on_the_genomic_accession=85816443, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  102640370 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102640370, CurrentID=0, Status='live', Symbol='Gm14409', Aliases='OTTMUSG00000016577', description='predicted gene 14409', other_designations='', map_location='2 99.28 cM', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=177264488, end_position_on_the_genomic_accession=177265430, orientation='minus', exon_count=1, OMIM='', no_hdr0=''),
  404212 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=404212, CurrentID=0, Status='live', Symbol='Pisrt1', Aliases='', description='polled intersex syndrome regulated transcript 1', other_designations='', map_location='', chromosome='9', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  102640376 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102640376, CurrentID=0, Status='live', Symbol='Gm36448', Aliases='', description='predicted gene, 36448', other_designations='', map_location='14', chromosome='14', genomic_nucleotide_accession_version='NC_000080.6', start_position_on_the_genomic_accession=52538595, end_position_on_the_genomic_accession=52541084, orientation='minus', exon_count=5, OMIM='', no_hdr0=''),
  404222 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=404222, CurrentID=0, Status='live', Symbol='Olfr231', Aliases='MOR105-4-ps1, Olfr244, Olfr244-ps1, Olfr425, Olfr425-ps1, Olfr231', description='olfactory receptor 231', other_designations='GA_x6K02T02K39-452-3|GA_x6K02T2LER7-6-623|GA_x6K02T2P20D-21053942-21054499|olfactory receptor 231, pseudogene 1|olfactory receptor 244, pseudogene 1|olfactory receptor 425, pseudogene 1', map_location='1 H3', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=174117091, end_position_on_the_genomic_accession=174118014, orientation='minus', exon_count=1, OMIM='', no_hdr0=''),
  102640387 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102640387, CurrentID=0, Status='live', Symbol='Gm36457', Aliases='', description='predicted gene, 36457', other_designations='', map_location='16', chromosome='16', genomic_nucleotide_accession_version='NC_000082.6', start_position_on_the_genomic_accession=65562505, end_position_on_the_genomic_accession=65563519, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  666372 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=666372, CurrentID=0, Status='live', Symbol='Gm8066', Aliases='EG666372', description='predicted gene 8066', other_designations='', map_location='5 G2', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=137509602, end_position_on_the_genomic_accession=137517578, orientation='plus', exon_count=3, OMIM='', no_hdr0=''),
  666376 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=666376, CurrentID=0, Status='live', Symbol='Gm8068', Aliases='EG666376', description='predicted gene 8068', other_designations='', map_location='14 C1', chromosome='14', genomic_nucleotide_accession_version='NC_000080.6', start_position_on_the_genomic_accession=41688152, end_position_on_the_genomic_accession=41701875, orientation='minus', exon_count=6, OMIM='', no_hdr0=''),
  666377 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=666377, CurrentID=0, Status='live', Symbol='Gm8069', Aliases='EG666377', description='predicted pseudogene 8069', other_designations='', map_location='5 C1', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=54651558, end_position_on_the_genomic_accession=54652187, orientation='minus', exon_count=1, OMIM='', no_hdr0=''),
  404235 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=404235, CurrentID=0, Status='live', Symbol='Mrgpra5', Aliases='MrgA5', description='MAS-related GPR, member A5', other_designations='', map_location='7 B3', chromosome='7', genomic_nucleotide_accession_version='NC_000073.5', start_position_on_the_genomic_accession=54757823, end_position_on_the_genomic_accession=54811605, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  404236 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=404236, CurrentID=0, Status='live', Symbol='Mrgpra7', Aliases='MrgA7', description='MAS-related GPR, member A7', other_designations='', map_location='', chromosome='', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  404237 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=404237, CurrentID=0, Status='live', Symbol='Mrgpra8', Aliases='MrgA8', description='MAS-related GPR, member A8', other_designations='', map_location='', chromosome='7', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  404238 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=404238, CurrentID=0, Status='live', Symbol='Mrgprb3', Aliases='MrgB3', description='MAS-related GPR, member B3', other_designations='', map_location='7 B4', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=48642863, end_position_on_the_genomic_accession=48643801, orientation='minus', exon_count=1, OMIM='', no_hdr0=''),
  404239 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=404239, CurrentID=0, Status='live', Symbol='Mrgprb5', Aliases='Mgrg11, MrgB5', description='MAS-related GPR, member B5', other_designations='Mas-related G protein-coupled receptor g11', map_location='7 B4', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=48168017, end_position_on_the_genomic_accession=48168985, orientation='minus', exon_count=1, OMIM='', no_hdr0=''),
  404240 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=404240, CurrentID=0, Status='live', Symbol='Mrgprb8', Aliases='MrgB8', description='MAS-related GPR, member B8', other_designations='', map_location='7 B4', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=48388526, end_position_on_the_genomic_accession=48389648, orientation='plus', exon_count=1, OMIM='', no_hdr0=''),
  102640401 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102640401, CurrentID=0, Status='live', Symbol='Gm36468', Aliases='', description='predicted gene, 36468', other_designations='', map_location='Y', chromosome='Y', genomic_nucleotide_accession_version='NC_000087.7', start_position_on_the_genomic_accession=24350158, end_position_on_the_genomic_accession=24360118, orientation='plus', exon_count=5, OMIM='', no_hdr0=''),
  404242 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=404242, CurrentID=0, Status='live', Symbol='Mrgprx1', Aliases='MrgC11, Mrgprc11', description='MAS-related GPR, member X1', other_designations='MAS-related GPR, member C11|mas-related G-protein coupled receptor member C11|mrgprx1|sensory neuron-specific G-protein coupled receptor 1', map_location='7 B4', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=48020971, end_position_on_the_genomic_accession=48027597, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  404243 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=404243, CurrentID=0, Status='live', Symbol='Mrgpra10', Aliases='MrgA10', description='MAS-related GPR, member A10', other_designations='', map_location='', chromosome='', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  404244 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=404244, CurrentID=0, Status='live', Symbol='Mrgpra11', Aliases='MrgA11', description='MAS-related GPR, member A11', other_designations='', map_location='', chromosome='', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  666389 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=666389, CurrentID=0, Status='live', Symbol='Gm12447', Aliases='OTTMUSG00000006886', description='predicted gene 12447', other_designations='', map_location='4 B1', chromosome='4', genomic_nucleotide_accession_version='NC_000070.6', start_position_on_the_genomic_accession=46304143, end_position_on_the_genomic_accession=46327767, orientation='plus', exon_count=4, OMIM='', no_hdr0=''),
  404246 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=404246, CurrentID=0, Status='live', Symbol='Mrgpra13', Aliases='MrgA13', description='MAS-related GPR, member A13', other_designations='', map_location='', chromosome='', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  404247 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=404247, CurrentID=0, Status='live', Symbol='Mrgpra14', Aliases='MrgA14', description='MAS-related GPR, member A14', other_designations='', map_location='', chromosome='7', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  404248 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=404248, CurrentID=0, Status='live', Symbol='Mrgpra15', Aliases='MrgA15', description='MAS-related GPR, member A15', other_designations='', map_location='', chromosome='', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  404249 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=404249, CurrentID=0, Status='live', Symbol='Mrgpra16', Aliases='Gm486, MrgA16', description='MAS-related GPR, member A16', other_designations='', map_location='7', chromosome='7', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  404250 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=404250, CurrentID=0, Status='live', Symbol='Mrgpra19', Aliases='MrgA19', description='MAS-related GPR, member A19', other_designations='', map_location='', chromosome='', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  100861743 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=100861743, CurrentID=0, Status='live', Symbol='Gm21180', Aliases='', description='predicted gene, 21180', other_designations='', map_location='Y', chromosome='Y', genomic_nucleotide_accession_version='NC_000087.7', start_position_on_the_genomic_accession=77073914, end_position_on_the_genomic_accession=77076246, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  666396 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=666396, CurrentID=0, Status='live', Symbol='Gm8082', Aliases='EG666396', description='predicted gene 8082', other_designations='', map_location='14 C1', chromosome='14', genomic_nucleotide_accession_version='NC_000080.5', start_position_on_the_genomic_accession=43666417, end_position_on_the_genomic_accession=43672298, orientation='minus', exon_count=7, OMIM='', no_hdr0=''),
  666414 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=666414, CurrentID=0, Status='live', Symbol='Gm8089', Aliases='EG666414', description='predicted gene 8089', other_designations='', map_location='1 E2.1', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=107291922, end_position_on_the_genomic_accession=107302354, orientation='minus', exon_count=4, OMIM='', no_hdr0=''),
  404284 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=404284, CurrentID=0, Status='live', Symbol='Vmn1r59', Aliases='V1rd10', description='vomeronasal 1 receptor 59', other_designations='vomernasal 1 receptor Vmn1r59|vomeronasal 1 receptor, D10', map_location='7 A1', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=5453827, end_position_on_the_genomic_accession=5454759, orientation='minus', exon_count=1, OMIM='', no_hdr0=''),
  404285 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=404285, CurrentID=0, Status='live', Symbol='Vmn1r64', Aliases='V1rd11', description='vomeronasal 1 receptor 64', other_designations='vomernasal 1 receptor Vmn1r64|vomeronasal 1 receptor, D11', map_location='7 A1', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=5883580, end_position_on_the_genomic_accession=5884542, orientation='minus', exon_count=1, OMIM='', no_hdr0=''),
  404286 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=404286, CurrentID=0, Status='live', Symbol='Vmn1r179', Aliases='V1rd17', description='vomeronasal 1 receptor 179', other_designations='vomernasal 1 receptor Vmn1r179|vomeronasal 1 receptor, D17', map_location='7 A3', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=23928386, end_position_on_the_genomic_accession=23929357, orientation='plus', exon_count=1, OMIM='', no_hdr0=''),
  404287 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=404287, CurrentID=0, Status='live', Symbol='V1rd19', Aliases='Vmn1r182', description='vomeronasal 1 receptor, D19', other_designations='vomernasal 1 receptor Vmn1r182', map_location='7 A3', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=24003111, end_position_on_the_genomic_accession=24004028, orientation='plus', exon_count=1, OMIM='', no_hdr0=''),
  404288 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=404288, CurrentID=0, Status='live', Symbol='V1rd18', Aliases='', description='vomeronasal 1 receptor, D18', other_designations='', map_location='', chromosome='7', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  404289 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=404289, CurrentID=0, Status='live', Symbol='Vmn1r181', Aliases='V1rd20', description='vomeronasal 1 receptor 181', other_designations='vomernasal 1 receptor Vmn1r181', map_location='7 A3', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=23983961, end_position_on_the_genomic_accession=23985048, orientation='plus', exon_count=1, OMIM='', no_hdr0=''),
  404290 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=404290, CurrentID=0, Status='live', Symbol='Vmn1r93', Aliases='V1rd21', description='vomeronasal 1 receptor 93', other_designations='vomernasal 1 receptor Vmn1r93|vomeronasal 1 receptor, D21', map_location='7 A3', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=20138123, end_position_on_the_genomic_accession=20139088, orientation='minus', exon_count=1, OMIM='', no_hdr0=''),
  404291 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=404291, CurrentID=0, Status='live', Symbol='Vmn1r174', Aliases='V1rd22', description='vomeronasal 1 receptor 174', other_designations='vomernasal 1 receptor Vmn1r174', map_location='7 A3', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=23753911, end_position_on_the_genomic_accession=23754852, orientation='plus', exon_count=1, OMIM='', no_hdr0=''),
  666436 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=666436, CurrentID=0, Status='live', Symbol='Gm8104', Aliases='EG666436', description='predicted gene 8104', other_designations='', map_location='14 C1', chromosome='14', genomic_nucleotide_accession_version='NC_000080.5', start_position_on_the_genomic_accession=43779160, end_position_on_the_genomic_accession=43788606, orientation='plus', exon_count=4, OMIM='', no_hdr0=''),
  666445 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=666445, CurrentID=0, Status='live', Symbol='Gm13035', Aliases='OTTMUSG00000010106', description='predicted gene 13035', other_designations='', map_location='4 E1', chromosome='4', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  404307 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=404307, CurrentID=0, Status='live', Symbol='Olfr100', Aliases='GA_x5J8B7TUCE2-427-5, GA_x5J8B7W5KGR-1200441-1200915, GA_x6K02T2PSCP-1740421-1739495', description='olfactory receptor 100', other_designations='olfactory receptor GA_x5J8B7TUCE2-427-5|olfactory receptor GA_x5J8B7W5KGR-1200441-1200915', map_location='17', chromosome='17', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  404308 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=404308, CurrentID=0, Status='live', Symbol='Olfr118', Aliases='MOR263-13', description='olfactory receptor 118', other_designations='GA_x5J8B7TVMCU-697-290|GA_x5J8B7TYMFE-883-533|GA_x6K02T2PSCP-2131124-2132089', map_location='17 B1', chromosome='17', genomic_nucleotide_accession_version='NC_000083.6', start_position_on_the_genomic_accession=37672025, end_position_on_the_genomic_accession=37672990, orientation='plus', exon_count=1, OMIM='', no_hdr0=''),
  404309 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=404309, CurrentID=0, Status='live', Symbol='Olfr192', Aliases='', description='olfactory receptor 192', other_designations='GA_x54KRFPKG5P-55327126-55326203|MOR183-11_p', map_location='16 C1.3', chromosome='16', genomic_nucleotide_accession_version='NC_000082.6', start_position_on_the_genomic_accession=59098066, end_position_on_the_genomic_accession=59098990, orientation='minus', exon_count=1, OMIM='', no_hdr0=''),
  404310 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=404310, CurrentID=0, Status='live', Symbol='Olfr199', Aliases='GA_x5J8B7W8B52-93129-93296, MOR182-14', description='olfactory receptor 199', other_designations='GA_x54KRFPKG5P-55430495-55429569|olfactory receptor GA_x5J8B7W8B52-93129-93296', map_location='16 C1.3', chromosome='16', genomic_nucleotide_accession_version='NC_000082.6', start_position_on_the_genomic_accession=59215685, end_position_on_the_genomic_accession=59221914, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  404311 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=404311, CurrentID=0, Status='live', Symbol='Olfr209', Aliases='MOR182-6', description='olfactory receptor 209', other_designations='GA_x54KRFPKG5P-55590495-55589578', map_location='16', chromosome='16', genomic_nucleotide_accession_version='NC_000082.6', start_position_on_the_genomic_accession=59361224, end_position_on_the_genomic_accession=59362240, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  404312 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=404312, CurrentID=0, Status='live', Symbol='Olfr250', Aliases='MOR170-14', description='olfactory receptor 250', other_designations='GA_x6K02T2MYUG-19447-18473', map_location='9', chromosome='9', genomic_nucleotide_accession_version='NC_000075.6', start_position_on_the_genomic_accession=38367548, end_position_on_the_genomic_accession=38368543, orientation='plus', exon_count=1, OMIM='', no_hdr0=''),
  404313 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=404313, CurrentID=0, Status='live', Symbol='Olfr251', Aliases='MOR170-15', description='olfactory receptor 251', other_designations='GA_x6K02T2MYUG-9124-8183', map_location='9', chromosome='9', genomic_nucleotide_accession_version='NC_000075.6', start_position_on_the_genomic_accession=38377883, end_position_on_the_genomic_accession=38378833, orientation='plus', exon_count=1, OMIM='', no_hdr0=''),
  404314 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=404314, CurrentID=0, Status='live', Symbol='Olfr257', Aliases='', description='olfactory receptor 257', other_designations='GA_x6K02T2N22H-3824-2865', map_location='', chromosome='15', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  404315 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=404315, CurrentID=0, Status='live', Symbol='Olfr372', Aliases='MOR282-1', description='olfactory receptor 372', other_designations='', map_location='8 B3.3', chromosome='8', genomic_nucleotide_accession_version='NC_000074.6', start_position_on_the_genomic_accession=72057660, end_position_on_the_genomic_accession=72058675, orientation='plus', exon_count=1, OMIM='', no_hdr0=''),
  404316 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=404316, CurrentID=0, Status='live', Symbol='Olfr403', Aliases='IA7, MOR125-5_p, Olfr43', description='olfactory receptor 403', other_designations='GA_x6K02T2P1NL-4348188-4349129|olfactory receptor 43', map_location='11 B5', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=74186249, end_position_on_the_genomic_accession=74196446, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  404317 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=404317, CurrentID=0, Status='live', Symbol='Olfr592', Aliases='MOR0-3P, MOR32-13, Olfr1525-ps1', description='olfactory receptor 592', other_designations='GA_x6K02T2PBJ9-5902266-5903204|olfactory receptor 1525, pseudogene 1|olfactory receptor MOR0-3P', map_location='7 E3', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=103186603, end_position_on_the_genomic_accession=103187541, orientation='plus', exon_count=1, OMIM='', no_hdr0=''),
  404318 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=404318, CurrentID=0, Status='live', Symbol='Olfr681', Aliases='MOR4014', description='olfactory receptor 681', other_designations='', map_location='7 E3', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=105121459, end_position_on_the_genomic_accession=105122406, orientation='plus', exon_count=1, OMIM='', no_hdr0=''),
  404319 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=404319, CurrentID=0, Status='live', Symbol='Olfr750', Aliases='GA_x5J8B7W5WBF-6267395-6266441, GA_x6K02T2PMLR-6808276-6807281, MOR103-18', description='olfactory receptor 750', other_designations='', map_location='14 C1', chromosome='14', genomic_nucleotide_accession_version='NC_000080.6', start_position_on_the_genomic_accession=51070311, end_position_on_the_genomic_accession=51071442, orientation='minus', exon_count=1, OMIM='', no_hdr0=''),
  404321 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=404321, CurrentID=0, Status='live', Symbol='Olfr776', Aliases='MOR111-12', description='olfactory receptor 776', other_designations='GA_x6K02T2PULF-10947193-10948131', map_location='10 D3', chromosome='10', genomic_nucleotide_accession_version='NC_000076.6', start_position_on_the_genomic_accession=129260963, end_position_on_the_genomic_accession=129261901, orientation='plus', exon_count=1, OMIM='', no_hdr0=''),
  404322 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=404322, CurrentID=0, Status='live', Symbol='Olfr924', Aliases='MOR171-27P, MOR171-47, Olfr1520-ps1', description='olfactory receptor 924', other_designations='GA_x6K02T2PVTD-32543982-32544908|olfactory receptor 1520, pseudogene 1|olfactory receptor MOR171-27P', map_location='9 A5.1', chromosome='9', genomic_nucleotide_accession_version='NC_000075.6', start_position_on_the_genomic_accession=38848116, end_position_on_the_genomic_accession=38849042, orientation='plus', exon_count=1, OMIM='', no_hdr0=''),
  100861755 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=100861755, CurrentID=0, Status='live', Symbol='Gm21190', Aliases='', description='predicted gene, 21190', other_designations='', map_location='5', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=15524452, end_position_on_the_genomic_accession=15529882, orientation='minus', exon_count=5, OMIM='', no_hdr0=''),
  404324 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=404324, CurrentID=0, Status='live', Symbol='Olfr1051', Aliases='GA_x5J8B7W3KVV-25848-25992, MOR187-5', description='olfactory receptor 1051', other_designations='GA_x6K02T2Q125-47756192-47755266|olfactory receptor GA_x5J8B7W3KVV-25848-25992', map_location='2 D', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=86275559, end_position_on_the_genomic_accession=86276485, orientation='minus', exon_count=1, OMIM='', no_hdr0=''),
  404325 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=404325, CurrentID=0, Status='live', Symbol='Olfr1057', Aliases='GA_x5J8B7TRQ4E-1174-939, GA_x5J8B7TY464-2-187, MOR185-11', description='olfactory receptor 1057', other_designations='GA_x6K02T2Q125-47844843-47843896|olfactory receptor GA_x5J8B7TRQ4E-1174-939|olfactory receptor GA_x5J8B7TY464-2-187', map_location='2 D', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=86374463, end_position_on_the_genomic_accession=86375410, orientation='minus', exon_count=1, OMIM='', no_hdr0=''),
  404327 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=404327, CurrentID=0, Status='live', Symbol='Olfr1113', Aliases='MOR264-25', description='olfactory receptor 1113', other_designations='GA_x6K02T2Q125-48697747-48698727', map_location='2 D', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=87212894, end_position_on_the_genomic_accession=87213874, orientation='plus', exon_count=1, OMIM='', no_hdr0=''),
  404328 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=404328, CurrentID=0, Status='live', Symbol='Olfr1118', Aliases='MOR264-22-ps, Olfr1118', description='olfactory receptor 1118', other_designations='GA_x5J8B7TRNDS-1-558|GA_x5J8B7TRNDT-725-75|GA_x5J8B7W3Y5M-637727-637885|GA_x6K02T2Q125-48795705-48796673|olfactory receptor 1118, pseudogene', map_location='2 D', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=87308764, end_position_on_the_genomic_accession=87309759, orientation='plus', exon_count=1, OMIM='', no_hdr0=''),
  404329 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=404329, CurrentID=0, Status='live', Symbol='Olfr1173', Aliases='', description='olfactory receptor 1173', other_designations='GA_x6K02T2Q125-49759783-49758845|MOR174-20_p', map_location='2 D', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=88274109, end_position_on_the_genomic_accession=88275047, orientation='minus', exon_count=1, OMIM='', no_hdr0=''),
  404330 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=404330, CurrentID=0, Status='live', Symbol='Olfr1198', Aliases='GA_x5J8B7W62NC-67655-66851, GA_x6K02T2Q125-50221692-50220766, MOR225-13', description='olfactory receptor 1198', other_designations='', map_location='2 E1', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=88745960, end_position_on_the_genomic_accession=88746886, orientation='minus', exon_count=1, OMIM='', no_hdr0=''),
  404331 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=404331, CurrentID=0, Status='live', Symbol='Olfr1252', Aliases='GA_x5J8B7W62NC-992588-991951', description='olfactory receptor 1252', other_designations='GA_x6K02T2Q125-51162884-51161940|MOR231-22_p|olfactory receptor GA_x5J8B7W62NC-992588-991951', map_location='2 E1', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=89721165, end_position_on_the_genomic_accession=89722109, orientation='minus', exon_count=1, OMIM='', no_hdr0=''),
  102640495 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102640495, CurrentID=0, Status='live', Symbol='Gm17657', Aliases='', description='predicted gene, 17657', other_designations='', map_location='17 15.41 cM', chromosome='17', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  404336 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=404336, CurrentID=0, Status='live', Symbol='Olfr1380', Aliases='GA_x5J8B7W6C8B-3023-2886', description='olfactory receptor 1380', other_designations='GA_x6K02T2QP88-5871967-5871032|MOR256-66_i|olfactory receptor GA_x5J8B7W6C8B-3023-2886', map_location='11 B1.2', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=49563923, end_position_on_the_genomic_accession=49564858, orientation='plus', exon_count=1, OMIM='', no_hdr0=''),
  404337 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=404337, CurrentID=0, Status='live', Symbol='Olfr1383', Aliases='MOR256-56', description='olfactory receptor 1383', other_designations='GA_x6K02T2QP88-5912627-5911692|odorant receptor|olfactory receptor GA_x5J8B7W6B6J-2556603-2556836', map_location='11 B1.2', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=49523725, end_position_on_the_genomic_accession=49524660, orientation='plus', exon_count=1, OMIM='', no_hdr0=''),
  404339 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=404339, CurrentID=0, Status='live', Symbol='Olfr1480', Aliases='MOR202-44', description='olfactory receptor 1480', other_designations='GA_x6K02T2RE5P-3862389-3863336', map_location='19 A', chromosome='19', genomic_nucleotide_accession_version='NC_000085.6', start_position_on_the_genomic_accession=13527924, end_position_on_the_genomic_accession=13530622, orientation='plus', exon_count=3, OMIM='', no_hdr0=''),
  102640500 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102640500, CurrentID=0, Status='live', Symbol='LOC102640500', Aliases='', description='keratin-associated protein 10-8-like', other_designations='', map_location='', chromosome='10', genomic_nucleotide_accession_version='NC_000076.6', start_position_on_the_genomic_accession=77776217, end_position_on_the_genomic_accession=77776944, orientation='minus', exon_count=1, OMIM='', no_hdr0=''),
  666485 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=666485, CurrentID=0, Status='live', Symbol='Gm8127', Aliases='EG666485', description='predicted gene 8127', other_designations='', map_location='14 C1', chromosome='14', genomic_nucleotide_accession_version='NC_000080.6', start_position_on_the_genomic_accession=43291067, end_position_on_the_genomic_accession=43293896, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  404346 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=404346, CurrentID=0, Status='live', Symbol='Olfr322', Aliases='GA_x5J8B7U1E65-1-838, MOR256-64, OTTMUSG00000005755, Olfr179, Olfr179-ps1, Olfr216, Olfr216-ps1-ps1, Olfr322', description='olfactory receptor 322', other_designations='GA_x6K02SYUNE5-2-727|GA_x6K02SYUPNB-557-3|GA_x6K02T2NKPP-754816-754257|olfactory receptor 216|olfactory receptor GA_x5J8B7U1E65-1-838', map_location='11 B1.3', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=58665561, end_position_on_the_genomic_accession=58666544, orientation='plus', exon_count=1, OMIM='', no_hdr0=''),
  666498 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=666498, CurrentID=0, Status='live', Symbol='Gm13149', Aliases='OTTMUSG00000010668', description='predicted gene 13149', other_designations='', map_location='4 E1', chromosome='4', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  404355 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=404355, CurrentID=0, Status='live', Symbol='Olfr238', Aliases='Olfr238-ps1', description='olfactory receptor 238', other_designations='GA_x6K02T09NAV-632-486|olfactory receptor 238, pseudogene 1', map_location='', chromosome='', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  666502 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=666502, CurrentID=0, Status='live', Symbol='Gm8138', Aliases='EG666502', description='predicted gene 8138', other_designations='', map_location='14 C1', chromosome='14', genomic_nucleotide_accession_version='NC_000080.6', start_position_on_the_genomic_accession=43412570, end_position_on_the_genomic_accession=43416340, orientation='minus', exon_count=5, OMIM='', no_hdr0=''),
  666504 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=666504, CurrentID=0, Status='live', Symbol='Gm8140', Aliases='EG666504', description='predicted gene 8140', other_designations='', map_location='15 D3', chromosome='15', genomic_nucleotide_accession_version='NC_000081.6', start_position_on_the_genomic_accession=76533208, end_position_on_the_genomic_accession=76535299, orientation='minus', exon_count=7, OMIM='', no_hdr0=''),
  666505 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=666505, CurrentID=0, Status='live', Symbol='Gm16490', Aliases='ENSMUSG00000060500', description='predicted gene 16490', other_designations='', map_location='18 B2', chromosome='18', genomic_nucleotide_accession_version='NC_000084.5', start_position_on_the_genomic_accession=35929972, end_position_on_the_genomic_accession=35931242, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  404364 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=404364, CurrentID=0, Status='live', Symbol='Olfr256', Aliases='Olfr256-ps1', description='olfactory receptor 256', other_designations='GA_x6K02T2N21T-9571-9122|olfactory receptor 256, pseudogene 1', map_location='', chromosome='', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  102640527 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102640527, CurrentID=0, Status='live', Symbol='Gm36566', Aliases='', description='predicted gene, 36566', other_designations='', map_location='19', chromosome='19', genomic_nucleotide_accession_version='NC_000085.6', start_position_on_the_genomic_accession=32754378, end_position_on_the_genomic_accession=32757067, orientation='minus', exon_count=1, OMIM='', no_hdr0=''),
  102902673 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102902673, CurrentID=0, Status='live', Symbol='Gm21992', Aliases='Rbm14-rbm4', description='predicted gene 21992', other_designations='Rbm14/Rbm4 fusion|transcriptional coactivator CoAZ', map_location='19', chromosome='19', genomic_nucleotide_accession_version='NC_000085.6', start_position_on_the_genomic_accession=4784293, end_position_on_the_genomic_accession=4811634, orientation='minus', exon_count=4, OMIM='', no_hdr0=''),
  404376 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=404376, CurrentID=0, Status='live', Symbol='Olfr302', Aliases='Olfr302-ps1', description='olfactory receptor 302', other_designations='GA_x6K02T2NHDJ-9695951-9695766|olfactory receptor 302, pseudogene 1', map_location='7', chromosome='7', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  666527 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=666527, CurrentID=0, Status='live', Symbol='Gm8148', Aliases='EG666527, Gm680', description='predicted gene 8148', other_designations='', map_location='5 E5', chromosome='5', genomic_nucleotide_accession_version='NC_000071.5', start_position_on_the_genomic_accession=102499237, end_position_on_the_genomic_accession=102500801, orientation='plus', exon_count=3, OMIM='', no_hdr0=''),
  666528 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=666528, CurrentID=0, Status='live', Symbol='Zfp541', Aliases='EG666528, Znf541', description='zinc finger protein 541', other_designations='spermatogenic cell HDAC-interacting protein 1', map_location='7 A2', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=16061775, end_position_on_the_genomic_accession=16096340, orientation='plus', exon_count=21, OMIM='', no_hdr0=''),
  666532 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=666532, CurrentID=0, Status='live', Symbol='Gm13139', Aliases='OTTMUSG00000010657', description='predicted gene 13139', other_designations='novel KRAB box domain containing protein', map_location='4 E1', chromosome='4', genomic_nucleotide_accession_version='NC_000070.6', start_position_on_the_genomic_accession=147131931, end_position_on_the_genomic_accession=147181762, orientation='plus', exon_count=7, OMIM='', no_hdr0=''),
  30924 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=30924, CurrentID=0, Status='live', Symbol='Angptl3', Aliases='hypl', description='angiopoietin-like 3', other_designations='angiopoietin-like protein 3', map_location='4 45.6 cM', chromosome='4', genomic_nucleotide_accession_version='NC_000070.6', start_position_on_the_genomic_accession=99030955, end_position_on_the_genomic_accession=99038188, orientation='plus', exon_count=7, OMIM='', no_hdr0=''),
  666555 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=666555, CurrentID=0, Status='live', Symbol='Gm8160', Aliases='', description='predicted gene 8160', other_designations='', map_location='14 A1', chromosome='14', genomic_nucleotide_accession_version='NC_000080.5', start_position_on_the_genomic_accession=4688530, end_position_on_the_genomic_accession=4725343, orientation='plus', exon_count=3, OMIM='', no_hdr0=''),
  102640572 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102640572, CurrentID=0, Status='live', Symbol='Gm29391', Aliases='', description='predicted gene 29391', other_designations='', map_location='Y', chromosome='Y', genomic_nucleotide_accession_version='NC_000087.7', start_position_on_the_genomic_accession=88913048, end_position_on_the_genomic_accession=88916675, orientation='minus', exon_count=4, OMIM='', no_hdr0=''),
  102640586 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102640586, CurrentID=0, Status='live', Symbol='LOC102640586', Aliases='', description='collagen alpha-1(II) chain-like', other_designations='', map_location='', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=95180965, end_position_on_the_genomic_accession=95259963, orientation='minus', exon_count=5, OMIM='', no_hdr0=''),
  102640594 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102640594, CurrentID=0, Status='live', Symbol='Gm28710', Aliases='', description='predicted gene 28710', other_designations='', map_location='5', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=16791828, end_position_on_the_genomic_accession=16882358, orientation='plus', exon_count=21, OMIM='', no_hdr0=''),
  102640597 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102640597, CurrentID=0, Status='live', Symbol='Gm29571', Aliases='', description='predicted gene 29571', other_designations='', map_location='10', chromosome='10', genomic_nucleotide_accession_version='NC_000076.6', start_position_on_the_genomic_accession=25536252, end_position_on_the_genomic_accession=25703341, orientation='plus', exon_count=18, OMIM='', no_hdr0=''),
  666584 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=666584, CurrentID=0, Status='live', Symbol='BC024063', Aliases='', description='cDNA sequence BC024063', other_designations='', map_location='10 C1', chromosome='10', genomic_nucleotide_accession_version='NC_000076.6', start_position_on_the_genomic_accession=82082465, end_position_on_the_genomic_accession=82112100, orientation='plus', exon_count=4, OMIM='', no_hdr0=''),
  102640611 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102640611, CurrentID=0, Status='live', Symbol='Gm21896', Aliases='', description='predicted gene, 21896', other_designations='', map_location='Y', chromosome='Y', genomic_nucleotide_accession_version='NC_000087.7', start_position_on_the_genomic_accession=35235339, end_position_on_the_genomic_accession=35236037, orientation='plus', exon_count=1, OMIM='', no_hdr0=''),
  329554 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=329554, CurrentID=0, Status='live', Symbol='Gm826', Aliases='', description='predicted gene 826', other_designations='putative novel', map_location='2 H2', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=160311393, end_position_on_the_genomic_accession=160349013, orientation='minus', exon_count=5, OMIM='', no_hdr0=''),
  30926 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=30926, CurrentID=0, Status='live', Symbol='Glrx3', Aliases='PICOT, Txnl2', description='glutaredoxin 3', other_designations='PKC interacting cousin of thioredoxin|PKC-interacting cousin of thioredoxin|PKC-theta-interacting protein|PKCq-interacting protein|thioredoxin-like 2|thioredoxin-like protein 2', map_location='7 F5', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=137437643, end_position_on_the_genomic_accession=137468594, orientation='plus', exon_count=12, OMIM='', no_hdr0=''),
  404467 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=404467, CurrentID=0, Status='live', Symbol='Olfr1071', Aliases='', description='olfactory receptor 1071', other_designations='GA_x6K02T2Q125-47962802-47962551', map_location='2', chromosome='2', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  404473 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=404473, CurrentID=0, Status='live', Symbol='Olfr1082', Aliases='GA_x5J8B7W4CQV-18360-18784, MOR192-4_p-ps1, Olfr1082', description='olfactory receptor 1082', other_designations='GA_x6K02T2Q125-48079993-48079157|olfactory receptor 1082, pseudogene 1|olfactory receptor GA_x5J8B7W4CQV-18360-18784', map_location='2 D', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=86593885, end_position_on_the_genomic_accession=86598809, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  102640642 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102640642, CurrentID=0, Status='live', Symbol='Astx3', Aliases='Gm14961, OTTMUSG00000018601', description='amplified spermatogenic transcripts X encoded 3', other_designations='', map_location='X 49.81 cM', chromosome='X', genomic_nucleotide_accession_version='NC_000086.7', start_position_on_the_genomic_accession=126033361, end_position_on_the_genomic_accession=126045433, orientation='plus', exon_count=11, OMIM='', no_hdr0=''),
  666638 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=666638, CurrentID=0, Status='live', Symbol='Gm8207', Aliases='EG666638', description='predicted gene 8207', other_designations='', map_location='14 C1', chromosome='14', genomic_nucleotide_accession_version='NC_000080.5', start_position_on_the_genomic_accession=44715967, end_position_on_the_genomic_accession=44718264, orientation='plus', exon_count=4, OMIM='', no_hdr0=''),
  100861784 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=100861784, CurrentID=0, Status='live', Symbol='LOC100861784', Aliases='', description='ubiquitin-conjugating enzyme E2 L3-like', other_designations='', map_location='', chromosome='3', genomic_nucleotide_accession_version='NC_000069.6', start_position_on_the_genomic_accession=74242261, end_position_on_the_genomic_accession=74296871, orientation='minus', exon_count=4, OMIM='', no_hdr0=''),
  666642 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=666642, CurrentID=0, Status='live', Symbol='Gm8210', Aliases='EG666642', description='predicted pseudogene 8210', other_designations='', map_location='1 B', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=43189057, end_position_on_the_genomic_accession=43189765, orientation='plus', exon_count=1, OMIM='', no_hdr0=''),
  11287 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11287, CurrentID=0, Status='live', Symbol='Pzp', Aliases='A1m, A2m, AI893533, MAM', description='pregnancy zone protein', other_designations='alpha 1 macroglobulin|alpha-2-M|alpha-2-macroglobulin', map_location='6 F1-G3', chromosome='6', genomic_nucleotide_accession_version='NC_000072.6', start_position_on_the_genomic_accession=128483567, end_position_on_the_genomic_accession=128526720, orientation='minus', exon_count=36, OMIM='', no_hdr0=''),
  666648 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=666648, CurrentID=0, Status='live', Symbol='Gm8213', Aliases='EG666648', description='predicted pseudogene 8213', other_designations='', map_location='6 E3', chromosome='6', genomic_nucleotide_accession_version='NC_000072.6', start_position_on_the_genomic_accession=116195367, end_position_on_the_genomic_accession=116208008, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  666649 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=666649, CurrentID=0, Status='live', Symbol='Gm8214', Aliases='EG666649', description='predicted gene 8214', other_designations='', map_location='1 H5', chromosome='1', genomic_nucleotide_accession_version='NC_000067.5', start_position_on_the_genomic_accession=185505657, end_position_on_the_genomic_accession=185506076, orientation='minus', exon_count=1, OMIM='', no_hdr0=''),
  102640673 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102640673, CurrentID=0, Status='live', Symbol='LOC102640673', Aliases='', description='zinc finger protein 431-like', other_designations='', map_location='', chromosome='17', genomic_nucleotide_accession_version='NC_000083.6', start_position_on_the_genomic_accession=17234827, end_position_on_the_genomic_accession=17266475, orientation='plus', exon_count=4, OMIM='', no_hdr0=''),
  11298 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11298, CurrentID=0, Status='live', Symbol='Aanat', Aliases='AA-NAT, Nat-2, Nat4, Snat', description='arylalkylamine N-acetyltransferase', other_designations='aralkylamine N-acetyltransferase|serotonin acetylase', map_location='11 E2', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=116591721, end_position_on_the_genomic_accession=116597680, orientation='plus', exon_count=6, OMIM='', no_hdr0=''),
  666660 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=666660, CurrentID=0, Status='live', Symbol='Gm8220', Aliases='EG666660', description='predicted gene 8220', other_designations='', map_location='14 C1', chromosome='14', genomic_nucleotide_accession_version='NC_000080.6', start_position_on_the_genomic_accession=44285590, end_position_on_the_genomic_accession=44291058, orientation='plus', exon_count=6, OMIM='', no_hdr0=''),
  11302 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11302, CurrentID=0, Status='live', Symbol='Aatk', Aliases='AATYK, aatyk1, mKIAA0641', description='apoptosis-associated tyrosine kinase', other_designations='apoptosis-associated tyrosine kinase 1B|brain apoptosis-associated tyrosine kinase|lemur tyrosine kinase 1', map_location='11 E2', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=120007311, end_position_on_the_genomic_accession=120047182, orientation='minus', exon_count=15, OMIM='', no_hdr0=''),
  11303 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11303, CurrentID=0, Status='live', Symbol='Abca1', Aliases='ABC-1, Abc1', description='ATP-binding cassette, sub-family A (ABC1), member 1', other_designations='ATP-binding cassette 1|ATP-binding cassette transporter 1', map_location='4 A5-B3', chromosome='4', genomic_nucleotide_accession_version='NC_000070.6', start_position_on_the_genomic_accession=53030789, end_position_on_the_genomic_accession=53159988, orientation='minus', exon_count=52, OMIM='', no_hdr0=''),
  11304 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11304, CurrentID=0, Status='live', Symbol='Abca4', Aliases='AW050280, Abc10, Abcr, D430003I15Rik, RmP', description='ATP-binding cassette, sub-family A (ABC1), member 4', other_designations='ATP-binding cassette 10|ATP-binding cassette sub-family A member 4|RIM ABC transporter|Rim protein', map_location='3 52.94 cM', chromosome='3', genomic_nucleotide_accession_version='NC_000069.6', start_position_on_the_genomic_accession=122043893, end_position_on_the_genomic_accession=122180070, orientation='plus', exon_count=54, OMIM='', no_hdr0=''),
  11305 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11305, CurrentID=0, Status='live', Symbol='Abca2', Aliases='AI413825, Abc2, D2H0S1474E, mKIAA1062', description='ATP-binding cassette, sub-family A (ABC1), member 2', other_designations='ATP-binding cassette 2|ATP-binding cassette transporter 2', map_location='2 A2-B', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=25428604, end_position_on_the_genomic_accession=25448544, orientation='plus', exon_count=50, OMIM='', no_hdr0=''),
  11306 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11306, CurrentID=0, Status='live', Symbol='Abcb7', Aliases='AA517758, AU019072, Abc7', description='ATP-binding cassette, sub-family B (MDR/TAP), member 7', other_designations='ABC transporter 7 protein|ATP-binding cassette 7|ATP-binding cassette transporter 7', map_location='X C-D', chromosome='X', genomic_nucleotide_accession_version='NC_000086.7', start_position_on_the_genomic_accession=104280565, end_position_on_the_genomic_accession=104413846, orientation='minus', exon_count=16, OMIM='', no_hdr0=''),
  11307 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11307, CurrentID=0, Status='live', Symbol='Abcg1', Aliases='AW413978, Abc8, White', description='ATP-binding cassette, sub-family G (WHITE), member 1', other_designations='ATP-binding cassette 8|ATP-binding cassette transporter 8|ATP-binding cassette, subfamily G, member 1|white protein homolog', map_location='17', chromosome='17', genomic_nucleotide_accession_version='NC_000083.6', start_position_on_the_genomic_accession=31057694, end_position_on_the_genomic_accession=31117984, orientation='plus', exon_count=15, OMIM='', no_hdr0=''),
  11308 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11308, CurrentID=0, Status='live', Symbol='Abi1', Aliases='E3B1, NAP1, Ssh3bp1, abi-1', description='abl-interactor 1', other_designations='abelson interactor 1|ablphilin-1|eps8 SH3 domain-binding protein|eps8 binding protein|eps8-binding protein|spectrin SH3 domain binding protein 1|spectrin SH3 domain-binding protein 1', map_location='2 15.18 cM', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=22939989, end_position_on_the_genomic_accession=23040241, orientation='minus', exon_count=11, OMIM='', no_hdr0=''),
  102640691 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102640691, CurrentID=0, Status='live', Symbol='Gm28678', Aliases='', description='predicted gene 28678', other_designations='', map_location='Y', chromosome='Y', genomic_nucleotide_accession_version='NC_000087.7', start_position_on_the_genomic_accession=73606859, end_position_on_the_genomic_accession=73607557, orientation='minus', exon_count=1, OMIM='', no_hdr0=''),
  102640692 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102640692, CurrentID=0, Status='live', Symbol='Gm21919', Aliases='', description='predicted gene, 21919', other_designations='', map_location='Y', chromosome='Y', genomic_nucleotide_accession_version='NC_000087.7', start_position_on_the_genomic_accession=81868582, end_position_on_the_genomic_accession=81872020, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  666678 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=666678, CurrentID=0, Status='live', Symbol='Gm8232', Aliases='EG666678', description='predicted gene 8232', other_designations='', map_location='14 C1', chromosome='14', genomic_nucleotide_accession_version='NC_000080.6', start_position_on_the_genomic_accession=44433563, end_position_on_the_genomic_accession=44438946, orientation='plus', exon_count=6, OMIM='', no_hdr0=''),
  666684 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=666684, CurrentID=0, Status='live', Symbol='Gm8237', Aliases='EG666684', description='predicted gene 8237', other_designations='', map_location='14 A1', chromosome='14', genomic_nucleotide_accession_version='NC_000080.5', start_position_on_the_genomic_accession=5990997, end_position_on_the_genomic_accession=5995686, orientation='minus', exon_count=4, OMIM='', no_hdr0=''),
  666688 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=666688, CurrentID=0, Status='live', Symbol='Gm8239', Aliases='EG666688', description='predicted gene 8239', other_designations='', map_location='6 B3', chromosome='6', genomic_nucleotide_accession_version='NC_000072.6', start_position_on_the_genomic_accession=56574097, end_position_on_the_genomic_accession=56652508, orientation='minus', exon_count=4, OMIM='', no_hdr0=''),
  404545 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=404545, CurrentID=0, Status='live', Symbol='Ano7', Aliases='Ngep, Ngep-L, Pcanap5, Tmem16g', description='anoctamin 7', other_designations='prostate cancer associated protein 5|transmembrane protein 16g', map_location='1 D', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=93373796, end_position_on_the_genomic_accession=93404304, orientation='plus', exon_count=25, OMIM='', no_hdr0=''),
  404549 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=404549, CurrentID=0, Status='live', Symbol='Ifna14', Aliases='OTTMUSG00000007662', description='interferon alpha 14', other_designations='', map_location='4 C4', chromosome='4', genomic_nucleotide_accession_version='NC_000070.6', start_position_on_the_genomic_accession=88571229, end_position_on_the_genomic_accession=88571798, orientation='minus', exon_count=1, OMIM='', no_hdr0=''),
  102640710 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102640710, CurrentID=0, Status='live', Symbol='Gm36712', Aliases='', description='predicted gene, 36712', other_designations='', map_location='16', chromosome='16', genomic_nucleotide_accession_version='NC_000082.6', start_position_on_the_genomic_accession=91651803, end_position_on_the_genomic_accession=91653026, orientation='plus', exon_count=1, OMIM='', no_hdr0=''),
  102640717 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102640717, CurrentID=0, Status='live', Symbol='Gm36718', Aliases='', description='predicted gene, 36718', other_designations='transcription elongation factor 1 homolog', map_location='18', chromosome='18', genomic_nucleotide_accession_version='NC_000084.6', start_position_on_the_genomic_accession=80019299, end_position_on_the_genomic_accession=80020297, orientation='plus', exon_count=1, OMIM='', no_hdr0=''),
  214239 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=214239, CurrentID=0, Status='live', Symbol='A430105I19Rik', Aliases='Gm353', description='RIKEN cDNA A430105I19 gene', other_designations='', map_location='2 E5', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=118754145, end_position_on_the_genomic_accession=118762951, orientation='minus', exon_count=12, OMIM='', no_hdr0=''),
  666704 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=666704, CurrentID=0, Status='live', Symbol='Samd1', Aliases='AA589507', description='sterile alpha motif domain containing 1', other_designations='SAM domain-containing protein 1|sterile alpha motif domain-containing protein 1', map_location='8 C3', chromosome='8', genomic_nucleotide_accession_version='NC_000074.6', start_position_on_the_genomic_accession=83997672, end_position_on_the_genomic_accession=84000386, orientation='plus', exon_count=5, OMIM='', no_hdr0=''),
  666706 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=666706, CurrentID=0, Status='live', Symbol='Gm8246', Aliases='100041804, EG666706, Gm3518', description='predicted gene 8246', other_designations='', map_location='14 A1', chromosome='14', genomic_nucleotide_accession_version='NC_000080.6', start_position_on_the_genomic_accession=5470533, end_position_on_the_genomic_accession=5477830, orientation='minus', exon_count=6, OMIM='', no_hdr0=''),
  666707 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=666707, CurrentID=0, Status='live', Symbol='Gm8247', Aliases='EG666707', description='predicted gene 8247', other_designations='', map_location='14 C1', chromosome='14', genomic_nucleotide_accession_version='NC_000080.5', start_position_on_the_genomic_accession=45202834, end_position_on_the_genomic_accession=45208077, orientation='plus', exon_count=6, OMIM='', no_hdr0=''),
  102640724 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102640724, CurrentID=0, Status='live', Symbol='Gm36724', Aliases='', description='predicted gene, 36724', other_designations='', map_location='3', chromosome='3', genomic_nucleotide_accession_version='NC_000069.6', start_position_on_the_genomic_accession=95315352, end_position_on_the_genomic_accession=95318389, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  11350 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11350, CurrentID=0, Status='live', Symbol='Abl1', Aliases='AI325092, Abl, E430008G22Rik, c-Abl', description='c-abl oncogene 1, non-receptor tyrosine kinase', other_designations='Abelson murine leukemia oncogene|Abelson tyrosine-protein kinase 1|abelson murine leukemia viral oncogene homolog 1|c-abl oncogene 1, receptor tyrosine kinase|c-abl protein, type II|c-abl protein, type III|p150|proto-oncogene c-Abl|proto-oncogene tyrosine-protein kinase ABL1|v-abl Abelson murine leukemia oncogene 1', map_location='2 B', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=31688252, end_position_on_the_genomic_accession=31807093, orientation='plus', exon_count=17, OMIM='', no_hdr0=''),
  11352 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11352, CurrentID=0, Status='live', Symbol='Abl2', Aliases='AA536808, Abll, Arg', description='v-abl Abelson murine leukemia viral oncogene 2 (arg, Abelson-related gene)', other_designations='Abelson-related gene protein|abelson murine leukemia viral oncogene homolog 2|abl2|tyrosine kinase ARG|tyrosine-protein kinase ABL2|tyrosine-protein kinase ARG|v-abl Abelson murine leukemia viral oncogene homolog 2 (arg, Abelson-related gene)', map_location='1 67.71 cM', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=156558171, end_position_on_the_genomic_accession=156649619, orientation='plus', exon_count=13, OMIM='', no_hdr0=''),
  102640729 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102640729, CurrentID=0, Status='live', Symbol='Gm21845', Aliases='', description='predicted gene, 21845', other_designations='', map_location='Y', chromosome='Y', genomic_nucleotide_accession_version='NC_000087.7', start_position_on_the_genomic_accession=24381817, end_position_on_the_genomic_accession=24382500, orientation='plus', exon_count=1, OMIM='', no_hdr0=''),
  11354 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11354, CurrentID=0, Status='live', Symbol='Scgb1b27', Aliases='Abp, Abpa, Abpa27, Sal-1, Tcp', description='secretoglobin, family 1B, member 27', other_designations='androgen binding protein alpha|androgen-binding protein|major allergen 1-like; lacrimal gland protein|salivary androgen-binding alpha subunit|salivary androgen-binding protein alpha subunit', map_location='7 19.38 cM', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=34021567, end_position_on_the_genomic_accession=34022881, orientation='plus', exon_count=3, OMIM='', no_hdr0=''),
  11363 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11363, CurrentID=0, Status='live', Symbol='Acadl', Aliases='AA960361, AU018452, C79855, LCAD', description='acyl-Coenzyme A dehydrogenase, long-chain', other_designations='acetyl-Coenzyme A dehydrogenase, long-chain', map_location='1 33.64 cM', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=66830839, end_position_on_the_genomic_accession=66863309, orientation='minus', exon_count=11, OMIM='', no_hdr0=''),
  11364 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11364, CurrentID=0, Status='live', Symbol='Acadm', Aliases='AU018656, MCAD', description='acyl-Coenzyme A dehydrogenase, medium chain', other_designations='', map_location='3 78.77 cM', chromosome='3', genomic_nucleotide_accession_version='NC_000069.6', start_position_on_the_genomic_accession=153922353, end_position_on_the_genomic_accession=153944643, orientation='minus', exon_count=12, OMIM='', no_hdr0=''),
  11370 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11370, CurrentID=0, Status='live', Symbol='Acadvl', Aliases='vlcad', description='acyl-Coenzyme A dehydrogenase, very long chain', other_designations='MVLCAD', map_location='11 42.96 cM', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=70010183, end_position_on_the_genomic_accession=70015428, orientation='minus', exon_count=20, OMIM='', no_hdr0=''),
  666731 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=666731, CurrentID=0, Status='live', Symbol='Trim43c', Aliases='EG666731, Trim43', description='tripartite motif-containing 43C', other_designations='trim43c|tripartite motif-containing 43', map_location='9 E3.1', chromosome='9', genomic_nucleotide_accession_version='NC_000075.6', start_position_on_the_genomic_accession=88839023, end_position_on_the_genomic_accession=88848198, orientation='plus', exon_count=7, OMIM='', no_hdr0=''),
  666744 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=666744, CurrentID=0, Status='live', Symbol='Gm8267', Aliases='EG666744', description='predicted gene 8267', other_designations='', map_location='14', chromosome='14', genomic_nucleotide_accession_version='NC_000080.6', start_position_on_the_genomic_accession=44717167, end_position_on_the_genomic_accession=44724987, orientation='minus', exon_count=5, OMIM='', no_hdr0=''),
  666747 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=666747, CurrentID=0, Status='live', Symbol='Trim43b', Aliases='EG666747, Gm8269', description='tripartite motif-containing 43B', other_designations='trim43b', map_location='9 E3.1', chromosome='9', genomic_nucleotide_accession_version='NC_000075.6', start_position_on_the_genomic_accession=89084624, end_position_on_the_genomic_accession=89092835, orientation='minus', exon_count=7, OMIM='', no_hdr0=''),
  666749 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=666749, CurrentID=0, Status='live', Symbol='Gm11623', Aliases='OTTMUSG00000002831', description='predicted gene 11623', other_designations='', map_location='11 E1', chromosome='11', genomic_nucleotide_accession_version='NC_000077.5', start_position_on_the_genomic_accession=104650154, end_position_on_the_genomic_accession=104676582, orientation='plus', exon_count=9, OMIM='', no_hdr0=''),
  666750 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=666750, CurrentID=0, Status='live', Symbol='Gm8271', Aliases='EG666750', description='predicted gene 8271', other_designations='alpha takusan-like', map_location='14 A1', chromosome='14', genomic_nucleotide_accession_version='NC_000080.6', start_position_on_the_genomic_accession=5185793, end_position_on_the_genomic_accession=5192984, orientation='plus', exon_count=5, OMIM='', no_hdr0=''),
  102640767 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102640767, CurrentID=0, Status='live', Symbol='Gm29424', Aliases='', description='predicted gene 29424', other_designations='', map_location='Y', chromosome='Y', genomic_nucleotide_accession_version='NC_000087.7', start_position_on_the_genomic_accession=70337891, end_position_on_the_genomic_accession=70340680, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  666765 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=666765, CurrentID=0, Status='live', Symbol='Gm8279', Aliases='ENSMUSG00000072743, Gm10412', description='predicted gene 8279', other_designations='', map_location='14', chromosome='14', genomic_nucleotide_accession_version='NC_000080.6', start_position_on_the_genomic_accession=5131582, end_position_on_the_genomic_accession=5139639, orientation='plus', exon_count=5, OMIM='', no_hdr0=''),
  67437 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=67437, CurrentID=0, Status='live', Symbol='Ssr3', Aliases='0610038P07Rik, AL022999, AU022074, AW553833, TRAPG', description='signal sequence receptor, gamma', other_designations='SSR-gamma|TRAP-gamma|signal sequence receptor subunit gamma|translocon-associated protein gamma', map_location='3 E1', chromosome='3', genomic_nucleotide_accession_version='NC_000069.6', start_position_on_the_genomic_accession=65379657, end_position_on_the_genomic_accession=65392553, orientation='minus', exon_count=5, OMIM='', no_hdr0=''),
  11409 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11409, CurrentID=0, Status='live', Symbol='Acads', Aliases='AI196007, Bcd-1, Bcd1, Hdlq8, SCAD', description='acyl-Coenzyme A dehydrogenase, short chain', other_designations='butyryl-CoA dehydrogenase', map_location='5 F', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=115110299, end_position_on_the_genomic_accession=115119346, orientation='minus', exon_count=10, OMIM='', no_hdr0=''),
  11416 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11416, CurrentID=0, Status='live', Symbol='Slc33a1', Aliases='AI315656, AI788741, Acatn, D630022N01Rik', description='solute carrier family 33 (acetyl-CoA transporter), member 1', other_designations='AT-1|acetyl-CoA transporter 1|solute carrier family 33 member 1', map_location='3 E1-E3', chromosome='3', genomic_nucleotide_accession_version='NC_000069.6', start_position_on_the_genomic_accession=63942323, end_position_on_the_genomic_accession=63964733, orientation='minus', exon_count=6, OMIM='', no_hdr0=''),
  404634 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=404634, CurrentID=0, Status='live', Symbol='H2afy2', Aliases='macroH2A2', description='H2A histone family, member Y2', other_designations='histone macroH2A2|mH2A2', map_location='10 B4', chromosome='10', genomic_nucleotide_accession_version='NC_000076.6', start_position_on_the_genomic_accession=61738647, end_position_on_the_genomic_accession=61784104, orientation='minus', exon_count=10, OMIM='', no_hdr0=''),
  11419 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11419, CurrentID=0, Status='live', Symbol='Asic1', Aliases='AI843610, ASIC, ASIC1a, Accn2, B530003N02Rik, BNaC2', description='acid-sensing (proton-gated) ion channel 1', other_designations='acid sensing ion channel|amiloride-sensitive cation channel 2, neuronal|brain sodium channel 2|degenerin 2', map_location='15 F3', chromosome='15', genomic_nucleotide_accession_version='NC_000081.6', start_position_on_the_genomic_accession=99670266, end_position_on_the_genomic_accession=99701130, orientation='plus', exon_count=14, OMIM='', no_hdr0=''),
  11421 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11421, CurrentID=0, Status='live', Symbol='Ace', Aliases='AW208573, CD143', description='angiotensin I converting enzyme (peptidyl-dipeptidase A) 1', other_designations='angiotensin converting enzyme|dipeptidyl carboxypeptidase I|dipeptidyl peptidase|kininase II', map_location='11 68.84 cM', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=105967945, end_position_on_the_genomic_accession=105989964, orientation='plus', exon_count=26, OMIM='', no_hdr0=''),
  11423 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11423, CurrentID=0, Status='live', Symbol='Ache', Aliases='', description='acetylcholinesterase', other_designations='', map_location='5 76.32 cM', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=137285849, end_position_on_the_genomic_accession=137294466, orientation='plus', exon_count=7, OMIM='', no_hdr0=''),
  102640800 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102640800, CurrentID=0, Status='live', Symbol='Gm36782', Aliases='', description='predicted gene, 36782', other_designations='', map_location='Y', chromosome='Y', genomic_nucleotide_accession_version='NC_000087.7', start_position_on_the_genomic_accession=39450598, end_position_on_the_genomic_accession=39464456, orientation='plus', exon_count=4, OMIM='', no_hdr0=''),
  11425 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11425, CurrentID=0, Status='live', Symbol='Apoc4', Aliases='Acl, apo-CIV, apoC-IV', description='apolipoprotein C-IV', other_designations='apolipoprotein C2-linked|apolipoprotein C4', map_location='7 9.94 cM', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=19678084, end_position_on_the_genomic_accession=19681460, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  11426 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11426, CurrentID=0, Status='live', Symbol='Macf1', Aliases='ABP620, Acf7, Aclp7, MACF, R74989, mKIAA0465', description='microtubule-actin crosslinking factor 1', other_designations='actin cross-linking family 7|actin-crosslinking protein 7|trabeculin alpha', map_location='4 57.42 cM', chromosome='4', genomic_nucleotide_accession_version='NC_000070.6', start_position_on_the_genomic_accession=123349633, end_position_on_the_genomic_accession=123687315, orientation='minus', exon_count=112, OMIM='', no_hdr0=''),
  11428 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11428, CurrentID=0, Status='live', Symbol='Aco1', Aliases='Aco-1, Irebp, Irp1', description='aconitase 1', other_designations='IRE-BP 1|citrate hydro-lyase|cytoplasmic aconitase|iron regulatory protein 1|iron-responsive element-binding protein 1', map_location='4 20.24 cM', chromosome='4', genomic_nucleotide_accession_version='NC_000070.6', start_position_on_the_genomic_accession=40143265, end_position_on_the_genomic_accession=40199009, orientation='plus', exon_count=21, OMIM='', no_hdr0=''),
  11429 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11429, CurrentID=0, Status='live', Symbol='Aco2', Aliases='Aco-2, Aco3, D10Wsu183e', description='aconitase 2, mitochondrial', other_designations='citrate hydro-lyase', map_location='15 E1', chromosome='15', genomic_nucleotide_accession_version='NC_000081.6', start_position_on_the_genomic_accession=81872463, end_position_on_the_genomic_accession=81915137, orientation='plus', exon_count=18, OMIM='', no_hdr0=''),
  11430 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11430, CurrentID=0, Status='live', Symbol='Acox1', Aliases='AOX, Acox, D130055E20Rik, Paox', description='acyl-Coenzyme A oxidase 1, palmitoyl', other_designations='palmitoyl-CoA oxidase|peroxisomal fatty acyl-coenzyme A oxidase|peroxisomal straight-chain Acyl-CoA oxidase', map_location='11 E2', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=116171883, end_position_on_the_genomic_accession=116199045, orientation='minus', exon_count=15, OMIM='', no_hdr0=''),
  11431 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11431, CurrentID=0, Status='live', Symbol='Acp1', Aliases='4632432E04Rik, AI427468, Acp-1, LMW-PTP', description='acid phosphatase 1, soluble', other_designations='LMW-PTPase|low molecular weight cytosolic acid phosphatase', map_location='12 A2', chromosome='12', genomic_nucleotide_accession_version='NC_000078.6', start_position_on_the_genomic_accession=30893326, end_position_on_the_genomic_accession=30911621, orientation='minus', exon_count=7, OMIM='', no_hdr0=''),
  11432 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11432, CurrentID=0, Status='live', Symbol='Acp2', Aliases='Acp-2, LAP', description='acid phosphatase 2, lysosomal', other_designations='', map_location='2 50.54 cM', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=91202812, end_position_on_the_genomic_accession=91214098, orientation='plus', exon_count=12, OMIM='', no_hdr0=''),
  102640809 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102640809, CurrentID=0, Status='live', Symbol='Gm36789', Aliases='', description='predicted gene, 36789', other_designations='', map_location='14', chromosome='14', genomic_nucleotide_accession_version='NC_000080.6', start_position_on_the_genomic_accession=56963320, end_position_on_the_genomic_accession=57004964, orientation='plus', exon_count=5, OMIM='', no_hdr0=''),
  666794 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=666794, CurrentID=0, Status='live', Symbol='Rbm24', Aliases='6330546B05Rik, AI606861', description='RNA binding motif protein 24', other_designations='RNA-binding motif protein 24', map_location='13 A5', chromosome='13', genomic_nucleotide_accession_version='NC_000079.6', start_position_on_the_genomic_accession=46418180, end_position_on_the_genomic_accession=46431099, orientation='plus', exon_count=5, OMIM='', no_hdr0=''),
  11435 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11435, CurrentID=0, Status='live', Symbol='Chrna1', Aliases='AI385656, AI608266, Achr-1, Acra', description='cholinergic receptor, nicotinic, alpha polypeptide 1 (muscle)', other_designations='', map_location='2 43.76 cM', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=73563281, end_position_on_the_genomic_accession=73580338, orientation='minus', exon_count=9, OMIM='', no_hdr0=''),
  11438 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11438, CurrentID=0, Status='live', Symbol='Chrna4', Aliases='Acra-4, Acra4, EBN1, ENFL1', description='cholinergic receptor, nicotinic, alpha polypeptide 4', other_designations='a4 nicotinic receptor|acetylcholine receptor alpha 4 neural|acetylcholine receptor, neuronal, nicotinic, alpha-4 subunit|alpha4 nAChR|alpha4-nAChR', map_location='2 103.54 cM', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=181022311, end_position_on_the_genomic_accession=181043580, orientation='minus', exon_count=7, OMIM='', no_hdr0=''),
  11440 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11440, CurrentID=0, Status='live', Symbol='Chrna6', Aliases='Acra6, Nica6', description='cholinergic receptor, nicotinic, alpha polypeptide 6', other_designations='acetylcholine receptor alpha 6 neural|alpha6 nAChR|nicotinic acetylcholine receptor subunit alpha 6', map_location='8 A3', chromosome='8', genomic_nucleotide_accession_version='NC_000074.6', start_position_on_the_genomic_accession=27403212, end_position_on_the_genomic_accession=27413944, orientation='minus', exon_count=6, OMIM='', no_hdr0=''),
  11441 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11441, CurrentID=0, Status='live', Symbol='Chrna7', Aliases='Acra7, alpha7, nAchR', description='cholinergic receptor, nicotinic, alpha polypeptide 7', other_designations='acetylcholine receptor alpha 7 neural|alpha7 nicotinic receptor|alpha7-nAChR', map_location='7 34.47 cM', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=63098692, end_position_on_the_genomic_accession=63212526, orientation='minus', exon_count=10, OMIM='', no_hdr0=''),
  11443 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11443, CurrentID=0, Status='live', Symbol='Chrnb1', Aliases='Achr-2, Acrb', description='cholinergic receptor, nicotinic, beta polypeptide 1 (muscle)', other_designations='AChR beta|acetylcholine receptor beta', map_location='11 42.87 cM', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=69784036, end_position_on_the_genomic_accession=69795974, orientation='minus', exon_count=11, OMIM='', no_hdr0=''),
  11444 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11444, CurrentID=0, Status='live', Symbol='Chrnb2', Aliases='Acrb-2, Acrb2, C030030P04Rik, [b]2-nAchR', description='cholinergic receptor, nicotinic, beta polypeptide 2 (neuronal)', other_designations='acetylcholine receptor beta 2 neural', map_location='3 39.19 cM', chromosome='3', genomic_nucleotide_accession_version='NC_000069.6', start_position_on_the_genomic_accession=89753448, end_position_on_the_genomic_accession=89764632, orientation='minus', exon_count=6, OMIM='', no_hdr0=''),
  666806 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=666806, CurrentID=0, Status='live', Symbol='Gm8300', Aliases='EG666806', description='predicted gene 8300', other_designations='', map_location='12 D2', chromosome='12', genomic_nucleotide_accession_version='NC_000078.6', start_position_on_the_genomic_accession=87514316, end_position_on_the_genomic_accession=87518265, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  11447 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11447, CurrentID=0, Status='live', Symbol='Chrnd', Aliases='Achr-4, Acrd, L10076', description='cholinergic receptor, nicotinic, delta polypeptide', other_designations='AChR delta subunit', map_location='1 44.07 cM', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=87190597, end_position_on_the_genomic_accession=87200070, orientation='plus', exon_count=12, OMIM='', no_hdr0=''),
  11448 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11448, CurrentID=0, Status='live', Symbol='Chrne', Aliases='AChrepsilon, Acre, nAChRE', description='cholinergic receptor, nicotinic, epsilon polypeptide', other_designations='AchR epsilon subunit|nicotinic acetylcholine receptor epsilon subunit', map_location='11 43.14 cM', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=70614883, end_position_on_the_genomic_accession=70619835, orientation='minus', exon_count=12, OMIM='', no_hdr0=''),
  11449 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11449, CurrentID=0, Status='live', Symbol='Chrng', Aliases='Achr-3, Acrg', description='cholinergic receptor, nicotinic, gamma polypeptide', other_designations='chrng variant N1|chrng variant N2|nicotinic acetylcholine receptor gamma subunit', map_location='1 44.07 cM', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=87205811, end_position_on_the_genomic_accession=87212410, orientation='plus', exon_count=12, OMIM='', no_hdr0=''),
  11450 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11450, CurrentID=0, Status='live', Symbol='Adipoq', Aliases='30kDa, APN, Acdc, Acrp30, Ad, GBP28, adipo, apM1', description='adiponectin, C1Q and collagen domain containing', other_designations='30 kDa adipocyte complement-related protein|adipocyte complement related protein|adipocyte complement-related 30 kDa protein|adipocyte, C1Q and collagen domain containing|adipocyte, C1q and collagen domain-containing protein|adipocyte-specific protein AdipoQ', map_location='16 13.96 cM', chromosome='16', genomic_nucleotide_accession_version='NC_000082.6', start_position_on_the_genomic_accession=23146536, end_position_on_the_genomic_accession=23157968, orientation='plus', exon_count=3, OMIM='', no_hdr0=''),
  11451 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11451, CurrentID=0, Status='live', Symbol='Acrv1', Aliases='Msa63, SP-10', description='acrosomal vesicle protein 1', other_designations='MSA-63', map_location='9 20.67 cM', chromosome='9', genomic_nucleotide_accession_version='NC_000075.6', start_position_on_the_genomic_accession=36693220, end_position_on_the_genomic_accession=36698837, orientation='plus', exon_count=4, OMIM='', no_hdr0=''),
  102640833 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102640833, CurrentID=0, Status='live', Symbol='Gm36807', Aliases='', description='predicted gene, 36807', other_designations='', map_location='10', chromosome='10', genomic_nucleotide_accession_version='NC_000076.6', start_position_on_the_genomic_accession=87018931, end_position_on_the_genomic_accession=87058829, orientation='minus', exon_count=7, OMIM='', no_hdr0=''),
  11459 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11459, CurrentID=0, Status='live', Symbol='Acta1', Aliases='AA959943, Acta-2, Acts, Actsk-1', description='actin, alpha 1, skeletal muscle', other_designations='alpha-actin-1', map_location='8 72.26 cM', chromosome='8', genomic_nucleotide_accession_version='NC_000074.6', start_position_on_the_genomic_accession=123891758, end_position_on_the_genomic_accession=123894775, orientation='minus', exon_count=8, OMIM='', no_hdr0=''),
  11461 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11461, CurrentID=0, Status='live', Symbol='Actb', Aliases='Actx, E430023M04Rik, beta-actin', description='actin, beta', other_designations='A-X actin-like protein|actin, beta, cytoplasmic|melanoma X-actin', map_location='5 81.8 cM', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=142903116, end_position_on_the_genomic_accession=142906724, orientation='minus', exon_count=6, OMIM='', no_hdr0=''),
  102640839 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102640839, CurrentID=0, Status='live', Symbol='Gm12963', Aliases='OTTMUSG00000009508', description='predicted gene 12963', other_designations='', map_location='4 63.43 cM', chromosome='4', genomic_nucleotide_accession_version='NC_000070.6', start_position_on_the_genomic_accession=130025489, end_position_on_the_genomic_accession=130048422, orientation='minus', exon_count=6, OMIM='', no_hdr0=''),
  11464 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11464, CurrentID=0, Status='live', Symbol='Actc1', Aliases='Actc-1', description='actin, alpha, cardiac muscle 1', other_designations='actin alpha cardiac|alpha-cardiac actin|alphac-actin', map_location='2 57.55 cM', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=114047289, end_position_on_the_genomic_accession=114052811, orientation='minus', exon_count=7, OMIM='', no_hdr0=''),
  11465 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11465, CurrentID=0, Status='live', Symbol='Actg1', Aliases='AL023024, Actg, Actl, E51', description='actin, gamma, cytoplasmic 1', other_designations='beta-actin FE-3|gamma-actin', map_location='11 E2', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=120345689, end_position_on_the_genomic_accession=120348491, orientation='minus', exon_count=7, OMIM='', no_hdr0=''),
  11468 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11468, CurrentID=0, Status='live', Symbol='Actg2', Aliases='ACTA3, Act-4, Act4, SMGA', description='actin, gamma 2, smooth muscle, enteric', other_designations='alpha-actin-3|gamma-2-actin|smooth muscle gamma-actin', map_location='6 35.94 cM', chromosome='6', genomic_nucleotide_accession_version='NC_000072.6', start_position_on_the_genomic_accession=83512909, end_position_on_the_genomic_accession=83536251, orientation='minus', exon_count=9, OMIM='', no_hdr0=''),
  11470 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11470, CurrentID=0, Status='live', Symbol='Actl7a', Aliases='Tact2', description='actin-like 7a', other_designations='T-actin-2|actin-like Tact2|actin-like-7-alpha|t-actin 2|testis-specific actin-2', map_location='4 31.66 cM', chromosome='4', genomic_nucleotide_accession_version='NC_000070.6', start_position_on_the_genomic_accession=56743422, end_position_on_the_genomic_accession=56744925, orientation='plus', exon_count=1, OMIM='', no_hdr0=''),
  11471 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11471, CurrentID=0, Status='live', Symbol='Actl7b', Aliases='Tact1', description='actin-like 7b', other_designations='T-actin-1|actin-like-7-beta|t-actin 1|testis-specific actin-1', map_location='4 27.0 cM', chromosome='4', genomic_nucleotide_accession_version='NC_000070.6', start_position_on_the_genomic_accession=56740005, end_position_on_the_genomic_accession=56741425, orientation='minus', exon_count=1, OMIM='', no_hdr0=''),
  11472 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11472, CurrentID=0, Status='live', Symbol='Actn2', Aliases='1110008F24Rik', description='actinin alpha 2', other_designations='F-actin cross-linking protein|alpha-actinin skeletal muscle', map_location='13 4.54 cM', chromosome='13', genomic_nucleotide_accession_version='NC_000079.6', start_position_on_the_genomic_accession=12269426, end_position_on_the_genomic_accession=12340732, orientation='minus', exon_count=21, OMIM='', no_hdr0=''),
  11474 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11474, CurrentID=0, Status='live', Symbol='Actn3', Aliases='', description='actinin alpha 3', other_designations='F-actin cross-linking protein|alpha-actinin skeletal muscle', map_location='19 4.12 cM', chromosome='19', genomic_nucleotide_accession_version='NC_000085.6', start_position_on_the_genomic_accession=4861216, end_position_on_the_genomic_accession=4877909, orientation='minus', exon_count=21, OMIM='', no_hdr0=''),
  11475 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11475, CurrentID=0, Status='live', Symbol='Acta2', Aliases='0610041G09Rik, Actvs, SMalphaA, a-SMA, alphaSMA', description='actin, alpha 2, smooth muscle, aorta', other_designations='actin, alpha, vascular smooth muscle|alpha-actin-2', map_location='19 C3', chromosome='19', genomic_nucleotide_accession_version='NC_000085.6', start_position_on_the_genomic_accession=34240336, end_position_on_the_genomic_accession=34255585, orientation='minus', exon_count=10, OMIM='', no_hdr0=''),
  11477 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11477, CurrentID=0, Status='live', Symbol='Acvr1', Aliases='ALK2, ActR-I, ActRIA, Acvr, Acvrlk2, Alk-2, Alk8, D330013D15Rik, SKR1, Tsk7L', description='activin A receptor, type 1', other_designations='TGF-B superfamily receptor type I|TSK-7L|TSR-I|activin receptor type I|serine/threonine-protein kinase receptor R1', map_location='2 C1.1', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=58446438, end_position_on_the_genomic_accession=58566828, orientation='minus', exon_count=14, OMIM='', no_hdr0=''),
  11479 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11479, CurrentID=0, Status='live', Symbol='Acvr1b', Aliases='6820432J04, ActR-IB, ActRIB, Acvrlk4, Alk4, SKR2', description='activin A receptor, type 1B', other_designations='ALK-4|activin receptor type IB|activin receptor-like kinase 4|serine/threonine-protein kinase receptor R2', map_location='15 56.48 cM', chromosome='15', genomic_nucleotide_accession_version='NC_000081.6', start_position_on_the_genomic_accession=101174125, end_position_on_the_genomic_accession=101212601, orientation='plus', exon_count=9, OMIM='', no_hdr0=''),
  11480 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11480, CurrentID=0, Status='live', Symbol='Acvr2a', Aliases='ActrIIa, Acvr2, TactrII', description='activin receptor IIA', other_designations='ACTR-IIA|activin receptor type IIA', map_location='2 28.38 cM', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=48814109, end_position_on_the_genomic_accession=48903264, orientation='plus', exon_count=12, OMIM='', no_hdr0=''),
  11481 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11481, CurrentID=0, Status='live', Symbol='Acvr2b', Aliases='4930516B21Rik, ActRIIB', description='activin receptor IIB', other_designations='activin receptor type IIB', map_location='9 F3', chromosome='9', genomic_nucleotide_accession_version='NC_000075.6', start_position_on_the_genomic_accession=119401583, end_position_on_the_genomic_accession=119442134, orientation='plus', exon_count=11, OMIM='', no_hdr0=''),
  11482 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11482, CurrentID=0, Status='live', Symbol='Acvrl1', Aliases='AI115505, AI427544, Acvrlk1, Alk1', description='activin A receptor, type II-like 1', other_designations='SKR3|TGF-B superfamily receptor type I|TSR-I|activin receptor-like kinase 1|activin receptor-like kinase-1', map_location='15 F3', chromosome='15', genomic_nucleotide_accession_version='NC_000081.6', start_position_on_the_genomic_accession=101128522, end_position_on_the_genomic_accession=101145336, orientation='plus', exon_count=13, OMIM='', no_hdr0=''),
  11484 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11484, CurrentID=0, Status='live', Symbol='Aspa', Aliases='Acy-2, Acy2, nur7', description='aspartoacylase', other_designations='aminoacylase-2|aspartoacylase (aminoacylase) 2', map_location='11 B4', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=73304988, end_position_on_the_genomic_accession=73326868, orientation='minus', exon_count=10, OMIM='', no_hdr0=''),
  11486 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11486, CurrentID=0, Status='live', Symbol='Ada', Aliases='', description='adenosine deaminase', other_designations='adenosine aminohydrolase', map_location='2 H3', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=163726571, end_position_on_the_genomic_accession=163750239, orientation='minus', exon_count=12, OMIM='', no_hdr0=''),
  11487 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11487, CurrentID=0, Status='live', Symbol='Adam10', Aliases='1700031C13Rik, MADM, kuz, kuzbanian', description='a disintegrin and metallopeptidase domain 10', other_designations='ADAM 10|a disintegrin and metalloprotease domain (ADAM) 10|a disintegrin and metalloprotease domain 10|kuzbanian protein homolog|mammalian disintegrin-metalloprotease', map_location='9 39.53 cM', chromosome='9', genomic_nucleotide_accession_version='NC_000075.6', start_position_on_the_genomic_accession=70679001, end_position_on_the_genomic_accession=70780229, orientation='plus', exon_count=17, OMIM='', no_hdr0=''),
  11488 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11488, CurrentID=0, Status='live', Symbol='Adam11', Aliases='AW060611, Mdc', description='a disintegrin and metallopeptidase domain 11', other_designations='a disintegrin and metalloprotease domain (ADAM) 11|a disintegrin and metalloprotease domain 11|metalloproteinase-like, disintegrin-like, and cysteine-rich protein', map_location='11 66.48 cM', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=102761439, end_position_on_the_genomic_accession=102780262, orientation='plus', exon_count=27, OMIM='', no_hdr0=''),
  11489 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11489, CurrentID=0, Status='live', Symbol='Adam12', Aliases='Mltna, mKIAA4001', description='a disintegrin and metallopeptidase domain 12 (meltrin alpha)', other_designations='ADAM 12|a disintegrin and metalloprotease domain 12|a disintegrin and metalloproteinase domain 12 (meltrin alpha)|meltrin alpha|meltrin-alpha', map_location='7 F4', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=133883196, end_position_on_the_genomic_accession=134232149, orientation='minus', exon_count=24, OMIM='', no_hdr0=''),
  11490 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11490, CurrentID=0, Status='live', Symbol='Adam15', Aliases='MDC15, metargidin', description='a disintegrin and metallopeptidase domain 15 (metargidin)', other_designations='AD56|ADAM 15|MDC-15|a disintegrin and metalloprotease domain 15 (metargidin)|a disintegrin and metalloproteinase domain 15 (metargidin)|disintegrin and metalloprotease 15|metalloprotease RGD disintegrin protein|metalloproteinase-like, disintegrin-like, and cysteine-rich protein 15', map_location='3 39.07 cM', chromosome='3', genomic_nucleotide_accession_version='NC_000069.6', start_position_on_the_genomic_accession=89339640, end_position_on_the_genomic_accession=89350010, orientation='minus', exon_count=25, OMIM='', no_hdr0=''),
  11491 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11491, CurrentID=0, Status='live', Symbol='Adam17', Aliases='CD156b, Tace', description='a disintegrin and metallopeptidase domain 17', other_designations='TNF-alpha convertase|TNF-alpha converting enzyme|a disintegrin and metalloproteinase domain 17', map_location='12 8.3 cM', chromosome='12', genomic_nucleotide_accession_version='NC_000078.6', start_position_on_the_genomic_accession=21323509, end_position_on_the_genomic_accession=21373632, orientation='minus', exon_count=20, OMIM='', no_hdr0=''),
  11492 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11492, CurrentID=0, Status='live', Symbol='Adam19', Aliases='AL024287, MADDAM, MTLNB, Mltnb', description='a disintegrin and metallopeptidase domain 19 (meltrin beta)', other_designations='MDC beta|Mel beta|a disintegrin and metalloproteinase domain 19 (meltrin beta)|adamalysin 19', map_location='11 A5-B1.1', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=46054502, end_position_on_the_genomic_accession=46147347, orientation='plus', exon_count=24, OMIM='', no_hdr0=''),
  404710 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=404710, CurrentID=0, Status='live', Symbol='Iqgap3', Aliases='AI593484, D030034H08', description='IQ motif containing GTPase activating protein 3', other_designations='', map_location='3 38.78 cM', chromosome='3', genomic_nucleotide_accession_version='NC_000069.6', start_position_on_the_genomic_accession=88082051, end_position_on_the_genomic_accession=88121048, orientation='plus', exon_count=38, OMIM='', no_hdr0=''),
  11495 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11495, CurrentID=0, Status='live', Symbol='Adam2', Aliases='AI323749, Ftnb, Ph30-beta', description='a disintegrin and metallopeptidase domain 2', other_designations='ADAM 2|PH-30|PH30|a disintegrin and metalloprotease domain 2 (fertilin beta)|fertilin beta|fertilin subunit beta', map_location='14 34.36 cM', chromosome='14', genomic_nucleotide_accession_version='NC_000080.6', start_position_on_the_genomic_accession=66027329, end_position_on_the_genomic_accession=66077856, orientation='minus', exon_count=21, OMIM='', no_hdr0=''),
  11496 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11496, CurrentID=0, Status='live', Symbol='Adam22', Aliases='2900022I03Rik, AI854032, MDC2', description='a disintegrin and metallopeptidase domain 22', other_designations='a disintegrin and metalloprotease domain (ADAM) 22', map_location='5 3.39 cM', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=8072348, end_position_on_the_genomic_accession=8368268, orientation='minus', exon_count=35, OMIM='', no_hdr0=''),
  100861820 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=100861820, CurrentID=0, Status='live', Symbol='Gm21244', Aliases='', description='predicted gene, 21244', other_designations='', map_location='Y', chromosome='Y', genomic_nucleotide_accession_version='NC_000087.7', start_position_on_the_genomic_accession=7165100, end_position_on_the_genomic_accession=7169304, orientation='minus', exon_count=4, OMIM='', no_hdr0=''),
  11498 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11498, CurrentID=0, Status='live', Symbol='Adam4', Aliases='AV274654, tMDCV', description='a disintegrin and metallopeptidase domain 4', other_designations='a disintegrin and metalloprotease domain (ADAM) 4|a disintegrin and metalloprotease domain 4', map_location='12 D1', chromosome='12', genomic_nucleotide_accession_version='NC_000078.6', start_position_on_the_genomic_accession=81419549, end_position_on_the_genomic_accession=81421878, orientation='minus', exon_count=1, OMIM='', no_hdr0=''),
  11499 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11499, CurrentID=0, Status='live', Symbol='Adam5', Aliases='tMDC II, tMDCII', description='a disintegrin and metallopeptidase domain 5', other_designations='a disintegrin and metalloprotease domain (ADAM) 5|a disintegrin and metalloprotease domain 5|transmembrane metalloproteinase-like, disintegrin-like, and cysteine-rich protein II', map_location='8 13.26 cM', chromosome='8', genomic_nucleotide_accession_version='NC_000074.6', start_position_on_the_genomic_accession=24727093, end_position_on_the_genomic_accession=24824369, orientation='minus', exon_count=22, OMIM='', no_hdr0=''),
  11500 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11500, CurrentID=0, Status='live', Symbol='Adam7', Aliases='ADAM 7, EAP1, EAPI', description='a disintegrin and metallopeptidase domain 7', other_designations='a disintegrin and metalloprotease domain (ADAM) 7|epididymal apical protein I', map_location='14 D2', chromosome='14', genomic_nucleotide_accession_version='NC_000080.6', start_position_on_the_genomic_accession=68497336, end_position_on_the_genomic_accession=68533689, orientation='minus', exon_count=23, OMIM='', no_hdr0=''),
  11501 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11501, CurrentID=0, Status='live', Symbol='Adam8', Aliases='ADAM 8, CD156, CD156a, E430039A18Rik, MS2', description='a disintegrin and metallopeptidase domain 8', other_designations='a disintegrin and metalloprotease domain 8|cell surface antigen MS2|macrophage cysteine-rich glycoprotein', map_location='7 F3-F5', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=139978932, end_position_on_the_genomic_accession=139993121, orientation='minus', exon_count=26, OMIM='', no_hdr0=''),
  102640878 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102640878, CurrentID=0, Status='live', Symbol='Gm21910', Aliases='', description='predicted gene, 21910', other_designations='', map_location='Y', chromosome='Y', genomic_nucleotide_accession_version='NC_000087.7', start_position_on_the_genomic_accession=66338549, end_position_on_the_genomic_accession=66339247, orientation='plus', exon_count=1, OMIM='', no_hdr0=''),
  67453 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=67453, CurrentID=0, Status='live', Symbol='Slc25a46', Aliases='1200007B05Rik, AI325987', description='solute carrier family 25, member 46', other_designations='', map_location='18 B1', chromosome='18', genomic_nucleotide_accession_version='NC_000084.6', start_position_on_the_genomic_accession=31580168, end_position_on_the_genomic_accession=31609902, orientation='minus', exon_count=9, OMIM='', no_hdr0=''),
  11504 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11504, CurrentID=0, Status='live', Symbol='Adamts1', Aliases='ADAM-TS1, ADAMTS, ADAMTS-1, C3-C5, METH-1, METH1', description='a disintegrin-like and metallopeptidase (reprolysin type) with thrombospondin type 1 motif, 1', other_designations='ADAM-TS 1', map_location='16 C3-C5', chromosome='16', genomic_nucleotide_accession_version='NC_000082.6', start_position_on_the_genomic_accession=85793827, end_position_on_the_genomic_accession=85803115, orientation='minus', exon_count=9, OMIM='', no_hdr0=''),
  666866 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=666866, CurrentID=0, Status='live', Symbol='Gm14701', Aliases='EG666866, OTTMUSG00000017751', description='predicted gene 14701', other_designations='', map_location='X A7.1', chromosome='X', genomic_nucleotide_accession_version='NC_000086.5', start_position_on_the_genomic_accession=64874524, end_position_on_the_genomic_accession=64874811, orientation='plus', exon_count=1, OMIM='', no_hdr0=''),
  11512 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11512, CurrentID=0, Status='live', Symbol='Adcy6', Aliases='AC6, mKIAA0422', description='adenylate cyclase 6', other_designations='ATP pyrophosphate-lyase 6|adenylate cyclase type VI|adenylyl cyclase 6|ca(2+)-inhibitable adenylyl cyclase', map_location='15 F', chromosome='15', genomic_nucleotide_accession_version='NC_000081.6', start_position_on_the_genomic_accession=98589978, end_position_on_the_genomic_accession=98610140, orientation='minus', exon_count=24, OMIM='', no_hdr0=''),
  11513 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11513, CurrentID=0, Status='live', Symbol='Adcy7', Aliases='AA407758', description='adenylate cyclase 7', other_designations='ATP pyrophosphate-lyase 7|adenylate cyclase type VII|adenylyl cyclase 7|adenylyl cyclase type VII', map_location='8 43.06 cM', chromosome='8', genomic_nucleotide_accession_version='NC_000074.6', start_position_on_the_genomic_accession=88272367, end_position_on_the_genomic_accession=88329965, orientation='plus', exon_count=35, OMIM='', no_hdr0=''),
  11514 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11514, CurrentID=0, Status='live', Symbol='Adcy8', Aliases='AC8, AW060868', description='adenylate cyclase 8', other_designations='ATP pyrophosphate-lyase 8|adenylate cyclase type VIII|adenylyl cyclase 8|ca(2+)/calmodulin-activated adenylyl cyclase', map_location='15 29.03 cM', chromosome='15', genomic_nucleotide_accession_version='NC_000081.6', start_position_on_the_genomic_accession=64699035, end_position_on_the_genomic_accession=64922296, orientation='minus', exon_count=18, OMIM='', no_hdr0=''),
  11515 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11515, CurrentID=0, Status='live', Symbol='Adcy9', Aliases='AC9, ACtp10, AW125421, D16Wsu65e, mKIAA0520', description='adenylate cyclase 9', other_designations='ATP pyrophosphate-lyase 9|adenylate cyclase type IX|adenylyl cyclase 9|adenylyl cyclase type 10', map_location='16 B1', chromosome='16', genomic_nucleotide_accession_version='NC_000082.6', start_position_on_the_genomic_accession=4284886, end_position_on_the_genomic_accession=4437236, orientation='minus', exon_count=12, OMIM='', no_hdr0=''),
  11516 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11516, CurrentID=0, Status='live', Symbol='Adcyap1', Aliases='PACAP', description='adenylate cyclase activating polypeptide 1', other_designations='', map_location='17 E5', chromosome='17', genomic_nucleotide_accession_version='NC_000083.6', start_position_on_the_genomic_accession=93198904, end_position_on_the_genomic_accession=93206541, orientation='plus', exon_count=6, OMIM='', no_hdr0=''),
  11517 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11517, CurrentID=0, Status='live', Symbol='Adcyap1r1', Aliases='2900024I10Rik, AI846590, PAC1, PAC1R, PACAP1-R', description='adenylate cyclase activating polypeptide 1 receptor 1', other_designations='PACAP type I receptor', map_location='6 B3', chromosome='6', genomic_nucleotide_accession_version='NC_000072.6', start_position_on_the_genomic_accession=55451501, end_position_on_the_genomic_accession=55501455, orientation='plus', exon_count=18, OMIM='', no_hdr0=''),
  11518 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11518, CurrentID=0, Status='live', Symbol='Add1', Aliases='AI256389', description='adducin 1 (alpha)', other_designations='erythrocyte adducin subunit alpha', map_location='5 17.9 cM', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=34573669, end_position_on_the_genomic_accession=34632305, orientation='plus', exon_count=20, OMIM='', no_hdr0=''),
  11519 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11519, CurrentID=0, Status='live', Symbol='Add2', Aliases='2900072M03Rik, add97', description='adducin 2 (beta)', other_designations='erythrocyte adducin subunit beta|snoRNA MBII-396', map_location='6 37.55 cM', chromosome='6', genomic_nucleotide_accession_version='NC_000072.6', start_position_on_the_genomic_accession=86028681, end_position_on_the_genomic_accession=86124409, orientation='plus', exon_count=17, OMIM='', no_hdr0=''),
  11520 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11520, CurrentID=0, Status='live', Symbol='Plin2', Aliases='AA407157, ADPH, Adfp, Adrp', description='perilipin 2', other_designations='adipophilin|adipose differentiation related protein|adipose differentiation-related protein', map_location='4 40.69 cM', chromosome='4', genomic_nucleotide_accession_version='NC_000070.6', start_position_on_the_genomic_accession=86626910, end_position_on_the_genomic_accession=86670059, orientation='minus', exon_count=10, OMIM='', no_hdr0=''),
  100861824 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=100861824, CurrentID=0, Status='live', Symbol='Gm21247', Aliases='', description='predicted gene, 21247', other_designations='', map_location='Y', chromosome='Y', genomic_nucleotide_accession_version='NC_000087.7', start_position_on_the_genomic_accession=46755790, end_position_on_the_genomic_accession=46758104, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  11522 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11522, CurrentID=0, Status='live', Symbol='Adh1', Aliases='ADH-AA, AI194826, Adh-1, Adh-1-t, Adh-1e, Adh-1t, Adh-3e-e, Adh1-t, Adh1tl, Adh3-e, Adh1', description='alcohol dehydrogenase 1 (class I)', other_designations='ADH-A2|alcohol dehydrogenase 1 temporal, liver|alcohol dehydrogenase 1, complex|alcohol dehydrogenase 1, electrophoretic|alcohol dehydrogenase 3, electrophoretic|alcohol dehydrogenase A subunit|class I alcohol dehydrogenase', map_location='3 64.16 cM', chromosome='3', genomic_nucleotide_accession_version='NC_000069.6', start_position_on_the_genomic_accession=138277645, end_position_on_the_genomic_accession=138290691, orientation='plus', exon_count=9, OMIM='', no_hdr0=''),
  100861825 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=100861825, CurrentID=0, Status='live', Symbol='Gm21248', Aliases='', description='predicted gene, 21248', other_designations='', map_location='Y', chromosome='Y', genomic_nucleotide_accession_version='NC_000087.7', start_position_on_the_genomic_accession=79958259, end_position_on_the_genomic_accession=79960588, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  11529 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11529, CurrentID=0, Status='live', Symbol='Adh7', Aliases='AI325182, Adh-3, Adh-3e, Adh-3t, Adh3, Adh3-e, Adh3-t, Adh4, Adt-1', description='alcohol dehydrogenase 7 (class IV), mu or sigma polypeptide', other_designations='ADH-C2|IV ADH|alcohol dehydrogenase 3 complex|alcohol dehydrogenase 3 temporal|alcohol dehydrogenase 4|alcohol dehydrogenase class IV mu/sigma chain|gastric alcohol dehydrogenase|retinol dehydrogenase', map_location='3 64.13 cM', chromosome='3', genomic_nucleotide_accession_version='NC_000069.6', start_position_on_the_genomic_accession=138198053, end_position_on_the_genomic_accession=138232042, orientation='plus', exon_count=13, OMIM='', no_hdr0=''),
  11532 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11532, CurrentID=0, Status='live', Symbol='Adh5', Aliases='Adh-5, Adh3, GSNOR', description='alcohol dehydrogenase 5 (class III), chi polypeptide', other_designations='ADH-B2|FALDH|FDH|GSH-FDH|S-(hydroxymethyl)glutathione dehydrogenase|S-nitrosoglutathione reductase|alcohol dehydrogenase 2|alcohol dehydrogenase B2|alcohol dehydrogenase class-III|glutathione-dependent formaldehyde dehydrogenase', map_location='3 G3', chromosome='3', genomic_nucleotide_accession_version='NC_000069.6', start_position_on_the_genomic_accession=138437200, end_position_on_the_genomic_accession=138455499, orientation='plus', exon_count=10, OMIM='', no_hdr0=''),
  11534 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11534, CurrentID=0, Status='live', Symbol='Adk', Aliases='2310026J05Rik, 5033405D03Rik, AI255373, AI987814, Ak', description='adenosine kinase', other_designations="adenosine 5'-phosphotransferase", map_location='14 A2-B', chromosome='14', genomic_nucleotide_accession_version='NC_000080.6', start_position_on_the_genomic_accession=21052573, end_position_on_the_genomic_accession=21448569, orientation='plus', exon_count=14, OMIM='', no_hdr0=''),
  11535 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11535, CurrentID=0, Status='live', Symbol='Adm', Aliases='AM', description='adrenomedullin', other_designations='', map_location='7 57.7 cM', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=110627669, end_position_on_the_genomic_accession=110629819, orientation='plus', exon_count=4, OMIM='', no_hdr0=''),
  11536 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11536, CurrentID=0, Status='live', Symbol='Gpr182', Aliases='AM-R, Admr, G10-D, Gpcr17, Gpcr22, MB10, NOW', description='G protein-coupled receptor 182', other_designations='G10D|adrenomedullin receptor', map_location='10 75.07 cM', chromosome='10', genomic_nucleotide_accession_version='NC_000076.6', start_position_on_the_genomic_accession=127749602, end_position_on_the_genomic_accession=127751798, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  102640913 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102640913, CurrentID=0, Status='live', Symbol='Gm36864', Aliases='', description='predicted gene, 36864', other_designations='', map_location='7', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=44236139, end_position_on_the_genomic_accession=44244313, orientation='plus', exon_count=6, OMIM='', no_hdr0=''),
  11538 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11538, CurrentID=0, Status='live', Symbol='Adnp', Aliases='AA589558, mKIAA0784', description='activity-dependent neuroprotective protein', other_designations='', map_location='2 H3', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=168180965, end_position_on_the_genomic_accession=168207062, orientation='minus', exon_count=4, OMIM='', no_hdr0=''),
  11539 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11539, CurrentID=0, Status='live', Symbol='Adora1', Aliases='A1-AR, A1AR, A1R, AA1R, AI848715, BB176431, Ri', description='adenosine A1 receptor', other_designations='', map_location='1 E4', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=134199215, end_position_on_the_genomic_accession=134235457, orientation='minus', exon_count=4, OMIM='', no_hdr0=''),
  11540 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11540, CurrentID=0, Status='live', Symbol='Adora2a', Aliases='A2AAR, A2aR, AA2AR', description='adenosine A2a receptor', other_designations='', map_location='10 B5.3', chromosome='10', genomic_nucleotide_accession_version='NC_000076.6', start_position_on_the_genomic_accession=75316860, end_position_on_the_genomic_accession=75334792, orientation='plus', exon_count=7, OMIM='', no_hdr0=''),
  11541 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11541, CurrentID=0, Status='live', Symbol='Adora2b', Aliases='A2BAR, A2BR, A2b, AA2BR, AI480866, AI605384', description='adenosine A2b receptor', other_designations='A2b, Rs', map_location='11 B2', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=62248984, end_position_on_the_genomic_accession=62266452, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  11542 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11542, CurrentID=0, Status='live', Symbol='Adora3', Aliases='A3AR, A3R, AA3R, ARA3, Gpcr2', description='adenosine A3 receptor', other_designations='G-protein coupled receptor 2', map_location='3 46.45 cM', chromosome='3', genomic_nucleotide_accession_version='NC_000069.6', start_position_on_the_genomic_accession=105904421, end_position_on_the_genomic_accession=105908928, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  11544 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11544, CurrentID=0, Status='live', Symbol='Adprh', Aliases='Arh1', description='ADP-ribosylarginine hydrolase', other_designations='ADP-ribose-L-arginine cleaving enzyme|[Protein ADP-ribosylarginine] hydrolase', map_location='16 B4', chromosome='16', genomic_nucleotide_accession_version='NC_000082.6', start_position_on_the_genomic_accession=38445399, end_position_on_the_genomic_accession=38452689, orientation='minus', exon_count=4, OMIM='', no_hdr0=''),
  11545 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11545, CurrentID=0, Status='live', Symbol='Parp1', Aliases='5830444G22Rik, AI893648, ARTD1, Adprp, Adprt1, C80510, PARP, PPOL, parp-1, sPARP-1', description='poly (ADP-ribose) polymerase family, member 1', other_designations='ADP-ribosyltransferase (NAD+, poly (ADP-ribose) polymerase) 1|ADP-ribosyltransferase (NAD+; poly (ADP-ribose) polymerase) 1|ADP-ribosyltransferase diphtheria toxin-like 1|ADPRT 1|NAD(+) ADP-ribosyltransferase 1|msPARP|poly(ADP-ribose) polymerase|poly[ADP-ribose] synthase 1|poly[ADP-ribose] synthetase 1', map_location='1 H5', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=180568975, end_position_on_the_genomic_accession=180601254, orientation='plus', exon_count=23, OMIM='', no_hdr0=''),
  11546 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11546, CurrentID=0, Status='live', Symbol='Parp2', Aliases='ARTD2, Adprt2, Adprtl2, Aspartl2, C78626, PARP-2', description='poly (ADP-ribose) polymerase family, member 2', other_designations='ADP-ribosyltransferase (NAD+, poly(ADP-ribose) polymerase)-like 2|ADP-ribosyltransferase (NAD+; poly (ADP-ribose) polymerase) 2|ADP-ribosyltransferase (NAD+; poly(ADP-ribose) polymerase)-like 2|ADP-ribosyltransferase diphtheria toxin-like 2|ADPRT-2|NAD(+) ADP-ribosyltransferase 2|mPARP-2|pADPRT-2|poly[ADP-ribose] synthase 2|poly[ADP-ribose] synthetase 2', map_location='14 C1', chromosome='14', genomic_nucleotide_accession_version='NC_000080.6', start_position_on_the_genomic_accession=50807898, end_position_on_the_genomic_accession=50821301, orientation='plus', exon_count=16, OMIM='', no_hdr0=''),
  666907 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=666907, CurrentID=0, Status='live', Symbol='Ms4a4a', Aliases='EG666907', description='membrane-spanning 4-domains, subfamily A, member 4A', other_designations='', map_location='19 A', chromosome='19', genomic_nucleotide_accession_version='NC_000085.6', start_position_on_the_genomic_accession=11375488, end_position_on_the_genomic_accession=11392915, orientation='plus', exon_count=7, OMIM='', no_hdr0=''),
  11548 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11548, CurrentID=0, Status='live', Symbol='Adra1b', Aliases='[a]1b', description='adrenergic receptor, alpha 1b', other_designations='alpha-1B adrenoceptor|alpha-1B adrenoreceptor|alpha1B-adrenergic receptor', map_location='11 25.81 cM', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=43774605, end_position_on_the_genomic_accession=43901251, orientation='minus', exon_count=5, OMIM='', no_hdr0=''),
  11549 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11549, CurrentID=0, Status='live', Symbol='Adra1a', Aliases='Adra1c', description='adrenergic receptor, alpha 1a', other_designations='alpha-1A adrenoceptor|alpha-1A adrenoreceptor|alpha-1C adrenergic receptor', map_location='14 D1', chromosome='14', genomic_nucleotide_accession_version='NC_000080.6', start_position_on_the_genomic_accession=66635017, end_position_on_the_genomic_accession=66771240, orientation='plus', exon_count=6, OMIM='', no_hdr0=''),
  11550 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11550, CurrentID=0, Status='live', Symbol='Adra1d', Aliases='Adra-1, Adra1, Adra1a, Gpcr8, Spr8, [a]1d, alpha1D-AR', description='adrenergic receptor, alpha 1d', other_designations='alpha-1A adrenergic receptor|alpha-1D adrenoceptor|alpha-1D adrenoreceptor', map_location='2 63.5 cM', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=131545357, end_position_on_the_genomic_accession=131562285, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  11551 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11551, CurrentID=0, Status='live', Symbol='Adra2a', Aliases='AW122659, Adra-2, Adra-2a, alpha(2A)AR, alpha2-C10, alpha2A, alpha2A-AR', description='adrenergic receptor, alpha 2a', other_designations='alpha-2A adrenoceptor|alpha-2A adrenoreceptor|alpha-2AAR|alpha2A-adrenergic receptor|subtype alpha2-C10', map_location='19 49.04 cM', chromosome='19', genomic_nucleotide_accession_version='NC_000085.6', start_position_on_the_genomic_accession=54045182, end_position_on_the_genomic_accession=54048982, orientation='plus', exon_count=1, OMIM='', no_hdr0=''),
  11552 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11552, CurrentID=0, Status='live', Symbol='Adra2b', Aliases='Adra-2b, [a]2B, alpha2-C2, alpha2B', description='adrenergic receptor, alpha 2b', other_designations='alpha-2B adrenoceptor|alpha-2B adrenoreceptor|alpha-2BAR|subtype alpha2-C2', map_location='2 61.95 cM', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=127363286, end_position_on_the_genomic_accession=127367221, orientation='plus', exon_count=1, OMIM='', no_hdr0=''),
  11553 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11553, CurrentID=0, Status='live', Symbol='Adra2c', Aliases='Adra-2c, [a]2C, alpha2-C4, alpha2C', description='adrenergic receptor, alpha 2c', other_designations='alpha-2 adrenergic receptor subtype C4|alpha-2C adrenoceptor|alpha-2C adrenoreceptor|alpha-2CAR|subtype alpha2-C4', map_location='5 18.09 cM', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=35278566, end_position_on_the_genomic_accession=35281763, orientation='plus', exon_count=1, OMIM='', no_hdr0=''),
  11554 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11554, CurrentID=0, Status='live', Symbol='Adrb1', Aliases='Adrb-1, beta-AR', description='adrenergic receptor, beta 1', other_designations='beta 1-AR|beta-1 adrenoceptor|beta-1 adrenoreceptor|cardiac beta adrenergic receptor', map_location='19 51.96 cM', chromosome='19', genomic_nucleotide_accession_version='NC_000085.6', start_position_on_the_genomic_accession=56722372, end_position_on_the_genomic_accession=56724862, orientation='plus', exon_count=1, OMIM='', no_hdr0=''),
  11555 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11555, CurrentID=0, Status='live', Symbol='Adrb2', Aliases='Adrb-2, Badm, Gpcr7', description='adrenergic receptor, beta 2', other_designations='beta 2-AR|beta-2 adrenoceptor|beta-2 adrenoreceptor', map_location='18 35.1 cM', chromosome='18', genomic_nucleotide_accession_version='NC_000084.6', start_position_on_the_genomic_accession=62177713, end_position_on_the_genomic_accession=62179981, orientation='minus', exon_count=1, OMIM='', no_hdr0=''),
  11556 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11556, CurrentID=0, Status='live', Symbol='Adrb3', Aliases='Adrb-3', description='adrenergic receptor, beta 3', other_designations='Beta-3 AR|Beta-3 adrenoceptor|beta 3-AR|beta-3 adrenoreceptor|beta3-adrenergic receptor', map_location='8 A2-A4', chromosome='8', genomic_nucleotide_accession_version='NC_000074.6', start_position_on_the_genomic_accession=27225776, end_position_on_the_genomic_accession=27230805, orientation='minus', exon_count=6, OMIM='', no_hdr0=''),
  666918 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=666918, CurrentID=0, Status='live', Symbol='Gm8362', Aliases='EG666918', description='predicted gene 8362', other_designations='alpha takusan-like', map_location='14 A1', chromosome='14', genomic_nucleotide_accession_version='NC_000080.6', start_position_on_the_genomic_accession=6766017, end_position_on_the_genomic_accession=6774348, orientation='minus', exon_count=5, OMIM='', no_hdr0=''),
  666921 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=666921, CurrentID=0, Status='live', Symbol='Gm12886', Aliases='OTTMUSG00000008908', description='predicted gene 12886', other_designations='', map_location='4 D2.2', chromosome='4', genomic_nucleotide_accession_version='NC_000070.6', start_position_on_the_genomic_accession=121414735, end_position_on_the_genomic_accession=121423099, orientation='minus', exon_count=4, OMIM='', no_hdr0=''),
  11564 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11564, CurrentID=0, Status='live', Symbol='Adsl', Aliases='Adl, Asl', description='adenylosuccinate lyase', other_designations='ASase|adenylosuccinase|adenylosuccinate lyase 1', map_location='15 37.95 cM', chromosome='15', genomic_nucleotide_accession_version='NC_000081.6', start_position_on_the_genomic_accession=80948490, end_position_on_the_genomic_accession=80970947, orientation='plus', exon_count=13, OMIM='', no_hdr0=''),
  11565 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11565, CurrentID=0, Status='live', Symbol='Adssl1', Aliases='AI528595, Adss, Adss1', description='adenylosuccinate synthetase like 1', other_designations='AMPSase 1|IMP--aspartate ligase 1|M-type adenylosuccinate synthetase|adSS 1|adenylosuccinate synthetase 1, muscle|adenylosuccinate synthetase, basic isozyme|adenylosuccinate synthetase, muscle isozyme', map_location='12 F1', chromosome='12', genomic_nucleotide_accession_version='NC_000078.6', start_position_on_the_genomic_accession=112620047, end_position_on_the_genomic_accession=112641355, orientation='plus', exon_count=13, OMIM='', no_hdr0=''),
  11566 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11566, CurrentID=0, Status='live', Symbol='Adss', Aliases='AI314886, AS2, Adss', description='adenylosuccinate synthetase, non muscle', other_designations='AMPSase 2|IMP--aspartate ligase 2|L-type adenylosuccinate synthetase|adSS 2|adenylosuccinate synthetase 2, non muscle|adenylosuccinate synthetase, acidic isozyme|adenylosuccinate synthetase, liver isozyme|adenylosuccinate synthetase, non-muscle isozyme', map_location='1 H4', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=177763178, end_position_on_the_genomic_accession=177796694, orientation='minus', exon_count=13, OMIM='', no_hdr0=''),
  11567 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11567, CurrentID=0, Status='live', Symbol='Avil', Aliases='Advil, DOC6', description='advillin', other_designations='actin-binding protein DOC6|p92', map_location='10 D3', chromosome='10', genomic_nucleotide_accession_version='NC_000076.6', start_position_on_the_genomic_accession=127000075, end_position_on_the_genomic_accession=127020994, orientation='plus', exon_count=21, OMIM='', no_hdr0=''),
  11568 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11568, CurrentID=0, Status='live', Symbol='Aebp1', Aliases='ACLP', description='AE binding protein 1', other_designations='aortic carboxypeptidase-like protein', map_location='11 A1', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=5861853, end_position_on_the_genomic_accession=5872225, orientation='plus', exon_count=22, OMIM='', no_hdr0=''),
  11569 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11569, CurrentID=0, Status='live', Symbol='Aebp2', Aliases='AU023766, B230313N05Rik', description='AE binding protein 2', other_designations='AE-binding protein 2|adipocyte enhancer-binding protein 2', map_location='6 G1', chromosome='6', genomic_nucleotide_accession_version='NC_000072.6', start_position_on_the_genomic_accession=140622454, end_position_on_the_genomic_accession=140677634, orientation='plus', exon_count=13, OMIM='', no_hdr0=''),
  666931 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=666931, CurrentID=0, Status='live', Symbol='Gm10573', Aliases='ENSMUSG00000073763, OTTMUSG00000008953', description='predicted gene 10573', other_designations='', map_location='4 D2.2', chromosome='4', genomic_nucleotide_accession_version='NC_000070.6', start_position_on_the_genomic_accession=122299722, end_position_on_the_genomic_accession=122313819, orientation='minus', exon_count=4, OMIM='', no_hdr0=''),
  11572 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11572, CurrentID=0, Status='live', Symbol='Crisp3', Aliases='Aeg2, CRISP-3, CRS3, SGP28', description='cysteine-rich secretory protein 3', other_designations='SCP 2|acidic epididymal glycoprotein 2|sperm-coating glycoprotein 2', map_location='17 19.45 cM', chromosome='17', genomic_nucleotide_accession_version='NC_000083.6', start_position_on_the_genomic_accession=40221777, end_position_on_the_genomic_accession=40242258, orientation='minus', exon_count=8, OMIM='', no_hdr0=''),
  102640950 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102640950, CurrentID=0, Status='live', Symbol='Gm28890', Aliases='', description='predicted gene 28890', other_designations='', map_location='Y', chromosome='Y', genomic_nucleotide_accession_version='NC_000087.7', start_position_on_the_genomic_accession=60148337, end_position_on_the_genomic_accession=60152044, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  11576 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11576, CurrentID=0, Status='live', Symbol='Afp', Aliases='', description='alpha fetoprotein', other_designations='alpha-1-fetoprotein|alpha-fetoglobulin|alpha-foetoprotein', map_location='5 44.77 cM', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=90490714, end_position_on_the_genomic_accession=90508907, orientation='plus', exon_count=15, OMIM='', no_hdr0=''),
  666938 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=666938, CurrentID=0, Status='live', Symbol='Bend4', Aliases='D330027G24Rik, EG666938', description='BEN domain containing 4', other_designations='bend4', map_location='5', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=67392147, end_position_on_the_genomic_accession=67428250, orientation='minus', exon_count=6, OMIM='', no_hdr0=''),
  11593 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11593, CurrentID=0, Status='live', Symbol='Aga', Aliases='AW060726', description='aspartylglucosaminidase', other_designations='N4-(N-acetyl-beta-glucosaminyl)-L-asparagine amidase|glycosylasparaginase', map_location='8 B3', chromosome='8', genomic_nucleotide_accession_version='NC_000074.6', start_position_on_the_genomic_accession=53511687, end_position_on_the_genomic_accession=53523422, orientation='plus', exon_count=10, OMIM='', no_hdr0=''),
  11595 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11595, CurrentID=0, Status='live', Symbol='Acan', Aliases='Agc, Agc1, Cspg1, b2b183Clo, cmd', description='aggrecan', other_designations='CSPCP|aggrecan 1|cartilage-specific proteoglycan core protein', map_location='7 44.88 cM', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=79053202, end_position_on_the_genomic_accession=79115099, orientation='plus', exon_count=18, OMIM='', no_hdr0=''),
  11596 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11596, CurrentID=0, Status='live', Symbol='Ager', Aliases='RAGE', description='advanced glycosylation end product-specific receptor', other_designations='advanced glycation end-products receptor|receptor for advanced glycation end-products variant 20|receptor for advanced glycosylation end products', map_location='17 B1', chromosome='17', genomic_nucleotide_accession_version='NC_000083.6', start_position_on_the_genomic_accession=34597410, end_position_on_the_genomic_accession=34600937, orientation='plus', exon_count=10, OMIM='', no_hdr0=''),
  11600 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11600, CurrentID=0, Status='live', Symbol='Angpt1', Aliases='1110046O21Rik, Ang-1, Ang1', description='angiopoietin 1', other_designations='', map_location='15 16.69 cM', chromosome='15', genomic_nucleotide_accession_version='NC_000081.6', start_position_on_the_genomic_accession=42424667, end_position_on_the_genomic_accession=42676977, orientation='minus', exon_count=10, OMIM='', no_hdr0=''),
  11601 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11601, CurrentID=0, Status='live', Symbol='Angpt2', Aliases='Agpt2, Ang-2, Ang2', description='angiopoietin 2', other_designations='', map_location='8 10.3 cM', chromosome='8', genomic_nucleotide_accession_version='NC_000074.6', start_position_on_the_genomic_accession=18690263, end_position_on_the_genomic_accession=18741562, orientation='minus', exon_count=9, OMIM='', no_hdr0=''),
  11602 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11602, CurrentID=0, Status='live', Symbol='Angpt4', Aliases='Agpt4, Ang3', description='angiopoietin 4', other_designations='ANG-3|ANG-4|angiopoietin 3|angiopoietin-3', map_location='2 74.83 cM', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=151911332, end_position_on_the_genomic_accession=151944654, orientation='plus', exon_count=9, OMIM='', no_hdr0=''),
  11603 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11603, CurrentID=0, Status='live', Symbol='Agrn', Aliases='Agrin, nmf380', description='agrin', other_designations='', map_location='4 88.55 cM', chromosome='4', genomic_nucleotide_accession_version='NC_000070.6', start_position_on_the_genomic_accession=156165290, end_position_on_the_genomic_accession=156197519, orientation='minus', exon_count=43, OMIM='', no_hdr0=''),
  11604 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11604, CurrentID=0, Status='live', Symbol='Agrp', Aliases='Agrt, Art', description='agouti related neuropeptide', other_designations='agouti related protein|orexigenic neuropeptide', map_location='8 D1-D2', chromosome='8', genomic_nucleotide_accession_version='NC_000074.6', start_position_on_the_genomic_accession=105566695, end_position_on_the_genomic_accession=105579845, orientation='minus', exon_count=6, OMIM='', no_hdr0=''),
  11605 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11605, CurrentID=0, Status='live', Symbol='Gla', Aliases='Ags', description='galactosidase, alpha', other_designations='alpha-D-galactosidase A|alpha-D-galactoside galactohydrolase|melibiase', map_location='X E-F1', chromosome='X', genomic_nucleotide_accession_version='NC_000086.7', start_position_on_the_genomic_accession=134588169, end_position_on_the_genomic_accession=134601005, orientation='minus', exon_count=7, OMIM='', no_hdr0=''),
  11606 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11606, CurrentID=0, Status='live', Symbol='Agt', Aliases='AI265500, AngI, AngII, Aogen, Serpina8', description='angiotensinogen (serpin peptidase inhibitor, clade A, member 8)', other_designations='angiotensin I|angiotensin ll|serpin A8', map_location='8 72.81 cM', chromosome='8', genomic_nucleotide_accession_version='NC_000074.6', start_position_on_the_genomic_accession=124556587, end_position_on_the_genomic_accession=124569707, orientation='minus', exon_count=5, OMIM='', no_hdr0=''),
  11607 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11607, CurrentID=0, Status='live', Symbol='Agtr1a', Aliases='1810074K20Rik, AG2S, AI551199, AT1, AT1a, AT2R1, AT2R1A, Agtr-1a, Agtr1, Angtr-1a', description='angiotensin II receptor, type 1a', other_designations='angiotensin II type-1A receptor|angiotensin receptor 1|angiotensin receptor 1a', map_location='13 13.19 cM', chromosome='13', genomic_nucleotide_accession_version='NC_000079.6', start_position_on_the_genomic_accession=30336356, end_position_on_the_genomic_accession=30382867, orientation='plus', exon_count=4, OMIM='', no_hdr0=''),
  11608 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11608, CurrentID=0, Status='live', Symbol='Agtr1b', Aliases='AT1B, AT2R1B, Agtr-1b, Angtr-1b', description='angiotensin II receptor, type 1b', other_designations='AT3|angiotensin II type-1B receptor', map_location='3 6.37 cM', chromosome='3', genomic_nucleotide_accession_version='NC_000069.6', start_position_on_the_genomic_accession=20314473, end_position_on_the_genomic_accession=20367177, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  11609 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11609, CurrentID=0, Status='live', Symbol='Agtr2', Aliases='AI316812, AW107640', description='angiotensin II receptor, type 2', other_designations='AT2 receptor|angiotensin II type-2 receptor', map_location='X 16.71 cM', chromosome='X', genomic_nucleotide_accession_version='NC_000086.7', start_position_on_the_genomic_accession=21484549, end_position_on_the_genomic_accession=21488833, orientation='plus', exon_count=3, OMIM='', no_hdr0=''),
  142682 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=142682, CurrentID=0, Status='live', Symbol='Zcchc14', Aliases='AA792890, BDG29', description='zinc finger, CCHC domain containing 14', other_designations='BDG-29 protein', map_location='8 E1', chromosome='8', genomic_nucleotide_accession_version='NC_000074.6', start_position_on_the_genomic_accession=121598697, end_position_on_the_genomic_accession=121652761, orientation='minus', exon_count=13, OMIM='', no_hdr0=''),
  11611 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11611, CurrentID=0, Status='live', Symbol='Agxt', Aliases='AGT, Agt11, SPT, Agxt', description='alanine-glyoxylate aminotransferase', other_designations='alanine--glyoxylate aminotransferase|alanine-glyoxylate aminotransferase 1|serine-pyruvate aminotransferase', map_location='1 47.0 cM', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=93135240, end_position_on_the_genomic_accession=93145421, orientation='plus', exon_count=11, OMIM='', no_hdr0=''),
  11614 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11614, CurrentID=0, Status='live', Symbol='Nr0b1', Aliases='AHX, Ahc, Ahch, DAX-1, Dax1', description='nuclear receptor subfamily 0, group B, member 1', other_designations='adrenal hypoplasia congenita-like protein|adrenal hypoplasia, congenital homolog|nuclear receptor DAX-1', map_location='X 39.67 cM', chromosome='X', genomic_nucleotide_accession_version='NC_000086.7', start_position_on_the_genomic_accession=86191775, end_position_on_the_genomic_accession=86195944, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  142687 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=142687, CurrentID=0, Status='live', Symbol='Asb14', Aliases='Asb-14', description='ankyrin repeat and SOCS box-containing 14', other_designations='ankyrin repeat and SOCS box-containing protein 14|ankyrin repeat domain-containing SOCS box protein 14', map_location='14 A3', chromosome='14', genomic_nucleotide_accession_version='NC_000080.6', start_position_on_the_genomic_accession=26894591, end_position_on_the_genomic_accession=26916100, orientation='plus', exon_count=10, OMIM='', no_hdr0=''),
  142688 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=142688, CurrentID=0, Status='live', Symbol='Asb13', Aliases='2210015B19Rik, 6430573K02Rik, Asb-13, C85285', description='ankyrin repeat and SOCS box-containing 13', other_designations='ankyrin repeat and SOCS box-containing protein 13|ankyrin repeat domain-containing SOCS box protein 13', map_location='13 A1', chromosome='13', genomic_nucleotide_accession_version='NC_000079.6', start_position_on_the_genomic_accession=3634012, end_position_on_the_genomic_accession=3651779, orientation='plus', exon_count=7, OMIM='', no_hdr0=''),
  666980 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=666980, CurrentID=0, Status='live', Symbol='Gm8400', Aliases='EG666980', description='predicted gene 8400', other_designations='', map_location='4 E2', chromosome='4', genomic_nucleotide_accession_version='NC_000070.5', start_position_on_the_genomic_accession=151450395, end_position_on_the_genomic_accession=151453171, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  11622 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11622, CurrentID=0, Status='live', Symbol='Ahr', Aliases='Ah, Ahhe, In, bHLHe76, Ahr', description='aryl-hydrocarbon receptor', other_designations='ah receptor|dioxin receptor', map_location='12 15.78 cM', chromosome='12', genomic_nucleotide_accession_version='NC_000078.6', start_position_on_the_genomic_accession=35497979, end_position_on_the_genomic_accession=35534989, orientation='minus', exon_count=11, OMIM='', no_hdr0=''),
  11624 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11624, CurrentID=0, Status='live', Symbol='Ahrr', Aliases='mKIAA1234', description='aryl-hydrocarbon receptor repressor', other_designations='ahR repressor', map_location='13 C2', chromosome='13', genomic_nucleotide_accession_version='NC_000079.6', start_position_on_the_genomic_accession=74211117, end_position_on_the_genomic_accession=74292330, orientation='minus', exon_count=15, OMIM='', no_hdr0=''),
  11625 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11625, CurrentID=0, Status='live', Symbol='Ahsg', Aliases='', description='alpha-2-HS-glycoprotein', other_designations='countertrypin|fetuin-A', map_location='16 13.74 cM', chromosome='16', genomic_nucleotide_accession_version='NC_000082.6', start_position_on_the_genomic_accession=22892015, end_position_on_the_genomic_accession=22899451, orientation='plus', exon_count=7, OMIM='', no_hdr0=''),
  11628 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11628, CurrentID=0, Status='live', Symbol='Aicda', Aliases='Aid, Arp2', description='activation-induced cytidine deaminase', other_designations='activation induced deaminase|cytidine aminohydrolase', map_location='6 F2', chromosome='6', genomic_nucleotide_accession_version='NC_000072.6', start_position_on_the_genomic_accession=122553809, end_position_on_the_genomic_accession=122564180, orientation='plus', exon_count=5, OMIM='', no_hdr0=''),
  11629 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11629, CurrentID=0, Status='live', Symbol='Aif1', Aliases='AI607846, AIF-1, D17H6S50E, G1, Iba1', description='allograft inflammatory factor 1', other_designations='ionized calcium binding adapter molecule 1|ionized calcium-binding adapter molecule 1|testis specific', map_location='17 18.59 cM', chromosome='17', genomic_nucleotide_accession_version='NC_000083.6', start_position_on_the_genomic_accession=35170991, end_position_on_the_genomic_accession=35176087, orientation='minus', exon_count=8, OMIM='', no_hdr0=''),
  11630 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11630, CurrentID=0, Status='live', Symbol='Aim1', Aliases='AI462491, AI463325', description='absent in melanoma 1', other_designations='', map_location='10 23.14 cM', chromosome='10', genomic_nucleotide_accession_version='NC_000076.6', start_position_on_the_genomic_accession=43950307, end_position_on_the_genomic_accession=44148924, orientation='minus', exon_count=23, OMIM='', no_hdr0=''),
  11632 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11632, CurrentID=0, Status='live', Symbol='Aip', Aliases='AA408703, AW476050, Ara9, D19Bwg1412e, Fkbp16, Xap2', description='aryl-hydrocarbon receptor-interacting protein', other_designations='', map_location='19 3.82 cM', chromosome='19', genomic_nucleotide_accession_version='NC_000085.6', start_position_on_the_genomic_accession=4113756, end_position_on_the_genomic_accession=4127236, orientation='minus', exon_count=9, OMIM='', no_hdr0=''),
  11634 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11634, CurrentID=0, Status='live', Symbol='Aire', Aliases='', description='autoimmune regulator (autoimmune polyendocrinopathy candidiasis ectodermal dystrophy)', other_designations='APECED protein homolog|autoimmune polyendocrinopathy candidiasis ectodermal dystrophy protein homolog|autoimmune regulator AIRE1a', map_location='10 39.72 cM', chromosome='10', genomic_nucleotide_accession_version='NC_000076.6', start_position_on_the_genomic_accession=78030022, end_position_on_the_genomic_accession=78043610, orientation='minus', exon_count=15, OMIM='', no_hdr0=''),
  11636 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11636, CurrentID=0, Status='live', Symbol='Ak1', Aliases='Ak-1, B430205N08Rik', description='adenylate kinase 1', other_designations='cytosolic adenylate kinase', map_location='2 22.09 cM', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=32621758, end_position_on_the_genomic_accession=32635058, orientation='plus', exon_count=10, OMIM='', no_hdr0=''),
  11637 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11637, CurrentID=0, Status='live', Symbol='Ak2', Aliases='Ak-2, D4Ertd220e', description='adenylate kinase 2', other_designations='AK 2|ATP-AMP transphosphorylase 2|ATP:AMP phosphotransferase|adenylate monophosphate kinase', map_location='4 62.62 cM', chromosome='4', genomic_nucleotide_accession_version='NC_000070.6', start_position_on_the_genomic_accession=128993217, end_position_on_the_genomic_accession=129011529, orientation='plus', exon_count=7, OMIM='', no_hdr0=''),
  11639 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11639, CurrentID=0, Status='live', Symbol='Ak4', Aliases='AK 4, Ak-3, Ak-4, Ak3, Ak3l1, D4Ertd274e', description='adenylate kinase 4', other_designations='AK 4|ATP-AMP transphosphorylase|GTP:AMP phosphotransferase AK4, mitochondrial|adenylate kinase 3 alpha-like 1|adenylate kinase 3-like 1|adenylate kinase isoenzyme 4, mitochondrial', map_location='4 46.84 cM', chromosome='4', genomic_nucleotide_accession_version='NC_000070.6', start_position_on_the_genomic_accession=101419289, end_position_on_the_genomic_accession=101467771, orientation='plus', exon_count=7, OMIM='', no_hdr0=''),
  11640 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11640, CurrentID=0, Status='live', Symbol='Akap1', Aliases='AKAP121, AKAP84, Akap, C76494, C81186, DAKAP1, S-AKAP84', description='A kinase (PRKA) anchor protein 1', other_designations='D-AKAP-1|PRKA1|S-AKAP|a kinase anchor protein 1, mitochondrial|dual specificity A-kinase-anchoring protein 1|protein kinase A-anchoring protein 1|spermatid A-kinase anchor protein', map_location='11 C', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=88830792, end_position_on_the_genomic_accession=88864586, orientation='minus', exon_count=14, OMIM='', no_hdr0=''),
  11641 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11641, CurrentID=0, Status='live', Symbol='Akap2', Aliases='AA959716, AI649048, Akap-2, Akap-kl, B230340M18Rik, Prka2', description='A kinase (PRKA) anchor protein 2', other_designations='AKAP expressed in kidney and lung|protein kinase A-anchoring protein 2', map_location='4 B3', chromosome='4', genomic_nucleotide_accession_version='NC_000070.6', start_position_on_the_genomic_accession=57845248, end_position_on_the_genomic_accession=57896984, orientation='plus', exon_count=5, OMIM='', no_hdr0=''),
  11642 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11642, CurrentID=0, Status='live', Symbol='Akap3', Aliases='Prka3', description='A kinase (PRKA) anchor protein 3', other_designations='A-kinase anchor protein 110 kDa|AKAP 110|AKAP-3|Protein kinase A-anchoring protein 3', map_location='6 F3', chromosome='6', genomic_nucleotide_accession_version='NC_000072.6', start_position_on_the_genomic_accession=126853098, end_position_on_the_genomic_accession=126874308, orientation='plus', exon_count=6, OMIM='', no_hdr0=''),
  11643 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11643, CurrentID=0, Status='live', Symbol='Akap4', Aliases='AKAP-4, AKAP82, Fsc1, PRKA4, mAKAP82, p82', description='A kinase (PRKA) anchor protein 4', other_designations='A-kinase anchor protein 82 kDa|major sperm fibrous sheath protein|protein kinase A-anchoring protein 4', map_location='X 3.17 cM', chromosome='X', genomic_nucleotide_accession_version='NC_000086.7', start_position_on_the_genomic_accession=7067515, end_position_on_the_genomic_accession=7078609, orientation='plus', exon_count=7, OMIM='', no_hdr0=''),
  11647 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11647, CurrentID=0, Status='live', Symbol='Alpl', Aliases='APTNAP, Akp-2, Akp2, TNAP, TNSALP', description='alkaline phosphatase, liver/bone/kidney', other_designations='alkaline phosphatase 2, liver', map_location='4 70.02 cM', chromosome='4', genomic_nucleotide_accession_version='NC_000070.6', start_position_on_the_genomic_accession=137741731, end_position_on_the_genomic_accession=137796384, orientation='minus', exon_count=18, OMIM='', no_hdr0=''),
  11648 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11648, CurrentID=0, Status='live', Symbol='Akp3', Aliases='Akp-3, IAP, dIAP', description='alkaline phosphatase 3, intestine, not Mn requiring', other_designations='intestinal alkaline phosphatase', map_location='1 44.06 cM', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=87125008, end_position_on_the_genomic_accession=87127912, orientation='plus', exon_count=11, OMIM='', no_hdr0=''),
  11650 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11650, CurrentID=0, Status='live', Symbol='Alppl2', Aliases='Akp5, C77216, D1Ertd816e, EAP', description='alkaline phosphatase, placental-like 2', other_designations='alkaline phosphatase 5|embryonic alkaline phosphatase|embryonic-type alkaline phosphatase', map_location='1 44.05 cM', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=87086690, end_position_on_the_genomic_accession=87096250, orientation='minus', exon_count=15, OMIM='', no_hdr0=''),
  11651 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11651, CurrentID=0, Status='live', Symbol='Akt1', Aliases='Akt, PKB, PKB/Akt, PKBalpha, Rac', description='thymoma viral proto-oncogene 1', other_designations='AKT1 kinase|Akt1m protein|PKB alpha|RAC-PK-alpha|protein kinase B alpha|protein kinase B-alpha|proto-oncogene c-AKT|related to A and C kinases', map_location='12 61.2 cM', chromosome='12', genomic_nucleotide_accession_version='NC_000078.6', start_position_on_the_genomic_accession=112653821, end_position_on_the_genomic_accession=112674802, orientation='minus', exon_count=16, OMIM='', no_hdr0=''),
  11652 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11652, CurrentID=0, Status='live', Symbol='Akt2', Aliases='2410016A19Rik, AW554154, PKB, PKBbeta', description='thymoma viral proto-oncogene 2', other_designations='PKB beta|RAC-PK-beta|RAC-beta serine/threonine protein kinase|protein kinase Akt-2|protein kinase B beta|protein kinase B, beta', map_location='7 B1', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=27591557, end_position_on_the_genomic_accession=27639453, orientation='plus', exon_count=20, OMIM='', no_hdr0=''),
  11655 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11655, CurrentID=0, Status='live', Symbol='Alas1', Aliases='ALAS, ALAS-N, Alas-1, Alas-h', description='aminolevulinic acid synthase 1', other_designations='5-aminolevulinic acid synthase 1|aminolevulinate synthase H|delta-ALA synthase 1|delta-aminolevulinate synthase 1|succinyl-CoA: glycine C-succinyl transferase', map_location='9 F1', chromosome='9', genomic_nucleotide_accession_version='NC_000075.6', start_position_on_the_genomic_accession=106233455, end_position_on_the_genomic_accession=106247954, orientation='minus', exon_count=12, OMIM='', no_hdr0=''),
  11656 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11656, CurrentID=0, Status='live', Symbol='Alas2', Aliases='ALAS, ALAS-E, ALASE, Alas-2', description='aminolevulinic acid synthase 2, erythroid', other_designations='5-aminolevulinic acid synthase 2|delta-ALA synthase 2|delta-aminolevulinate synthase 2|erythroid-specific ALAS', map_location='X 68.46 cM', chromosome='X', genomic_nucleotide_accession_version='NC_000086.7', start_position_on_the_genomic_accession=150547417, end_position_on_the_genomic_accession=150570622, orientation='plus', exon_count=11, OMIM='', no_hdr0=''),
  11657 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11657, CurrentID=0, Status='live', Symbol='Alb', Aliases='Alb-11, BCL002, Alb', description='albumin', other_designations='albumin 1', map_location='5 44.7 cM', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=90460889, end_position_on_the_genomic_accession=90476603, orientation='plus', exon_count=15, OMIM='', no_hdr0=''),
  11658 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11658, CurrentID=0, Status='live', Symbol='Alcam', Aliases='AI853494, BEN, CD166, DM-GRASP, MuSC, SC1', description='activated leukocyte cell adhesion molecule', other_designations='', map_location='16 B5', chromosome='16', genomic_nucleotide_accession_version='NC_000082.6', start_position_on_the_genomic_accession=52248996, end_position_on_the_genomic_accession=52453255, orientation='minus', exon_count=16, OMIM='', no_hdr0=''),
  102641037 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102641037, CurrentID=0, Status='live', Symbol='LOC102641037', Aliases='', description='Y-linked testis-specific protein 1-like', other_designations='', map_location='', chromosome='Y', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  102641039 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102641039, CurrentID=0, Status='live', Symbol='LOC102641039', Aliases='', description='Y-linked testis-specific protein 1-like', other_designations='', map_location='', chromosome='Y', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  667024 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=667024, CurrentID=0, Status='live', Symbol='Gm8426', Aliases='EG667024', description='predicted gene 8426', other_designations='', map_location='3 F1', chromosome='3', genomic_nucleotide_accession_version='NC_000069.5', start_position_on_the_genomic_accession=86352555, end_position_on_the_genomic_accession=86355182, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  11666 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11666, CurrentID=0, Status='live', Symbol='Abcd1', Aliases='ALDP, Ald, Aldgh', description='ATP-binding cassette, sub-family D (ALD), member 1', other_designations='ATP-binding cassette, sub-family D, member 1|X-linked adrenoleukodystrophy (ALD) gene homolog|adrenoleukodystrophy protein', map_location='X B', chromosome='X', genomic_nucleotide_accession_version='NC_000086.7', start_position_on_the_genomic_accession=73716597, end_position_on_the_genomic_accession=73738287, orientation='plus', exon_count=10, OMIM='', no_hdr0=''),
  11668 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11668, CurrentID=0, Status='live', Symbol='Aldh1a1', Aliases='Ahd-2, Ahd2, Aldh1, Aldh1a2, E1, Raldh1', description='aldehyde dehydrogenase family 1, subfamily A1', other_designations='ALDH-E1|ALHDII|RALDH 1|alcohol dehydrogenase family 1, subfamily A1|alcohol dehydrogenase family 1, subfamily A2|aldehyde dehydrogenase 1, liver cytosolic (class 1)|aldehyde dehydrogenase family 1 member A1|aldehyde dehydrogenase, cytosolic', map_location='19 13.91 cM', chromosome='19', genomic_nucleotide_accession_version='NC_000085.6', start_position_on_the_genomic_accession=20601982, end_position_on_the_genomic_accession=20643462, orientation='plus', exon_count=13, OMIM='', no_hdr0=''),
  11669 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11669, CurrentID=0, Status='live', Symbol='Aldh2', Aliases='AHD-M1, ALDH-E2, ALDHI, Ahd-5, Ahd5', description='aldehyde dehydrogenase 2, mitochondrial', other_designations='ALDH class 2', map_location='5 F-G1', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=121567687, end_position_on_the_genomic_accession=121593824, orientation='minus', exon_count=13, OMIM='', no_hdr0=''),
  11670 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11670, CurrentID=0, Status='live', Symbol='Aldh3a1', Aliases='Ahd-4, Ahd4, Aldh, Aldh3', description='aldehyde dehydrogenase family 3, subfamily A1', other_designations='alcohol dehydrogenase family 3, subfamily A1|aldehyde dehydrogenase 3, stomach cytosolic (class 3)|aldehyde dehydrogenase 4|aldehyde dehydrogenase family 3 member A1|dioxin-inducible aldehyde dehydrogenase 3', map_location='11 37.96 cM', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=61207537, end_position_on_the_genomic_accession=61218418, orientation='plus', exon_count=15, OMIM='', no_hdr0=''),
  11671 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11671, CurrentID=0, Status='live', Symbol='Aldh3a2', Aliases='AI194803, Ahd-3, Ahd-3r, Ahd3, Ahd3-r, Aldh4, Aldh4-r, FALDH', description='aldehyde dehydrogenase family 3, subfamily A2', other_designations='alcohol dehydrogenase family 3, subfamily A2|aldehyde dehydrogenase 3|aldehyde dehydrogenase 4, liver microsomal (class 3) regulator|aldehyde dehydrogenase family 3 member A2', map_location='11 37.96 cM', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=61224486, end_position_on_the_genomic_accession=61267465, orientation='minus', exon_count=14, OMIM='', no_hdr0=''),
  667034 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=667034, CurrentID=0, Status='live', Symbol='Pnp2', Aliases='', description='purine-nucleoside phosphorylase 2', other_designations='', map_location='14 C1', chromosome='14', genomic_nucleotide_accession_version='NC_000080.6', start_position_on_the_genomic_accession=50956141, end_position_on_the_genomic_accession=50964749, orientation='plus', exon_count=7, OMIM='', no_hdr0=''),
  11676 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11676, CurrentID=0, Status='live', Symbol='Aldoc', Aliases='AI847350, AU040929, Aldo3, Scrg2', description='aldolase C, fructose-bisphosphate', other_designations='aldolase 3, C isoform|brain-type aldolase|scrapie responsive gene 2|scrapie-responsive protein 2|zebrin II', map_location='11 46.74 cM', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=78323073, end_position_on_the_genomic_accession=78327781, orientation='plus', exon_count=9, OMIM='', no_hdr0=''),
  11677 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11677, CurrentID=0, Status='live', Symbol='Akr1b3', Aliases='ALR2, AR, Ahr-1, Ahr1, Akr1b1, Aldor1, Aldr1', description='aldo-keto reductase family 1, member B3 (aldose reductase)', other_designations='aldehyde reductase 1|aldo-keto reductase family 1, member B1 (aldose reductase)', map_location='6 B1', chromosome='6', genomic_nucleotide_accession_version='NC_000072.6', start_position_on_the_genomic_accession=34303930, end_position_on_the_genomic_accession=34317489, orientation='minus', exon_count=10, OMIM='', no_hdr0=''),
  102641055 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102641055, CurrentID=0, Status='live', Symbol='LOC102641055', Aliases='', description='60S ribosomal protein L29', other_designations='', map_location='', chromosome='4', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  11682 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11682, CurrentID=0, Status='live', Symbol='Alk', Aliases='CD246, Tcrz', description='anaplastic lymphoma kinase', other_designations='', map_location='17 43.77 cM', chromosome='17', genomic_nucleotide_accession_version='NC_000083.6', start_position_on_the_genomic_accession=71868988, end_position_on_the_genomic_accession=72605410, orientation='minus', exon_count=29, OMIM='', no_hdr0=''),
  11684 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11684, CurrentID=0, Status='live', Symbol='Alox12', Aliases='9930022G08Rikp, P-12LO, Alox12', description='arachidonate 12-lipoxygenase', other_designations='12S-LOX|12S-lipoxygenase|lipoxin synthase 12-LO|platelet-type lipoxygenase 12', map_location='11 42.99 cM', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=70241455, end_position_on_the_genomic_accession=70255386, orientation='minus', exon_count=15, OMIM='', no_hdr0=''),
  11685 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11685, CurrentID=0, Status='live', Symbol='Alox12e', Aliases='8-LOX, AW259591, Alox12-ps1, Alox12-ps2, Aloxe, e-LOX1', description='arachidonate lipoxygenase, epidermal', other_designations='12-LOX|arachidonate 12-lipoxygenase, epidermal', map_location='11 42.99 cM', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=70315503, end_position_on_the_genomic_accession=70322727, orientation='minus', exon_count=15, OMIM='', no_hdr0=''),
  11686 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11686, CurrentID=0, Status='live', Symbol='Alox12b', Aliases='12R-LOX, Aloxe2, e-LOX2', description='arachidonate 12-lipoxygenase, 12R type', other_designations='12R-lipoxygenase|epidermis-type lipoxygenase 12|epidermis-type lipoxygenase 2', map_location='11 42.38 cM', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=69157072, end_position_on_the_genomic_accession=69169791, orientation='plus', exon_count=15, OMIM='', no_hdr0=''),
  11687 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11687, CurrentID=0, Status='live', Symbol='Alox15', Aliases='12-LO, 12/15-LO, 15-LOX, Alox12l, L-12LO', description='arachidonate 15-lipoxygenase', other_designations='12-LOX|12/15-lipoxygenase|arachidonate 12-lipoxygenase, leukocyte-type|arachidonate omega-6 lipoxygenase', map_location='11 42.99 cM', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=70344147, end_position_on_the_genomic_accession=70375918, orientation='minus', exon_count=15, OMIM='', no_hdr0=''),
  11688 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11688, CurrentID=0, Status='live', Symbol='Alox8', Aliases='15-LOX-2, 15-LOX-B, 8-LOX, 8S-LOX, Alox15b', description='arachidonate 8-lipoxygenase', other_designations='15-lipoxygenase 2|8S-lipoxygenase|arachidonate 15-lipoxygenase B|arachidonate 15-lipoxygenase type II|arachidonate 15-lipoxygenase, second type', map_location='11 B4', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=69183885, end_position_on_the_genomic_accession=69197843, orientation='minus', exon_count=14, OMIM='', no_hdr0=''),
  11689 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11689, CurrentID=0, Status='live', Symbol='Alox5', Aliases='5-LO, 5-LOX, 5LO, 5LX, AI850497, F730011J02', description='arachidonate 5-lipoxygenase', other_designations='5-lipoxygenase', map_location='6 53.79 cM', chromosome='6', genomic_nucleotide_accession_version='NC_000072.6', start_position_on_the_genomic_accession=116410069, end_position_on_the_genomic_accession=116461210, orientation='minus', exon_count=14, OMIM='', no_hdr0=''),
  11690 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11690, CurrentID=0, Status='live', Symbol='Alox5ap', Aliases='Flap', description='arachidonate 5-lipoxygenase activating protein', other_designations='MK-886-binding protein', map_location='5 G3', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=149265058, end_position_on_the_genomic_accession=149288047, orientation='plus', exon_count=5, OMIM='', no_hdr0=''),
  100381255 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=100381255, CurrentID=0, Status='live', Symbol='BC026863', Aliases='', description='cDNA sequence BC026863', other_designations='', map_location='', chromosome='2', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  11692 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11692, CurrentID=0, Status='live', Symbol='Gfer', Aliases='Alr, ERV1', description='growth factor, erv1 (S. cerevisiae)-like (augmenter of liver regeneration)', other_designations='augmenter of liver regeneration', map_location='17 12.48 cM', chromosome='17', genomic_nucleotide_accession_version='NC_000083.6', start_position_on_the_genomic_accession=24693189, end_position_on_the_genomic_accession=24696227, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  11694 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11694, CurrentID=0, Status='live', Symbol='Alx3', Aliases='', description='aristaless-like homeobox 3', other_designations='proline-rich transcription factor Alx3', map_location='3 46.83 cM', chromosome='3', genomic_nucleotide_accession_version='NC_000069.6', start_position_on_the_genomic_accession=107595031, end_position_on_the_genomic_accession=107605875, orientation='plus', exon_count=4, OMIM='', no_hdr0=''),
  667055 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=667055, CurrentID=0, Status='live', Symbol='Gm9992', Aliases='ENSMUSG00000056133', description='predicted gene 9992', other_designations='preditcted gene, ENSMUSG00000056133', map_location='17 A1', chromosome='17', genomic_nucleotide_accession_version='NC_000083.6', start_position_on_the_genomic_accession=7363646, end_position_on_the_genomic_accession=7397328, orientation='minus', exon_count=13, OMIM='', no_hdr0=''),
  100381256 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=100381256, CurrentID=0, Status='live', Symbol='A330027G23Rik', Aliases='', description='RIKEN cDNA A330027G23 gene', other_designations='', map_location='', chromosome='4', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  11698 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11698, CurrentID=0, Status='live', Symbol='Ambn', Aliases='', description='ameloblastin', other_designations='', map_location='5 43.63 cM', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=88455991, end_position_on_the_genomic_accession=88468531, orientation='plus', exon_count=11, OMIM='', no_hdr0=''),
  11699 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11699, CurrentID=0, Status='live', Symbol='Ambp', Aliases='AI194774, ASPI, HI-30, Intin4, Itil, UTI', description='alpha 1 microglobulin/bikunin', other_designations='Urinary Trypsin Inhibitor|ulinastatin', map_location='4 C1-C3', chromosome='4', genomic_nucleotide_accession_version='NC_000070.6', start_position_on_the_genomic_accession=63143279, end_position_on_the_genomic_accession=63154142, orientation='minus', exon_count=10, OMIM='', no_hdr0=''),
  667060 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=667060, CurrentID=0, Status='live', Symbol='Vmn2r5', Aliases='EG667060', description='vomeronasal 2, receptor 5', other_designations='', map_location='3 E1', chromosome='3', genomic_nucleotide_accession_version='NC_000069.6', start_position_on_the_genomic_accession=64490783, end_position_on_the_genomic_accession=64534962, orientation='minus', exon_count=7, OMIM='', no_hdr0=''),
  11702 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11702, CurrentID=0, Status='live', Symbol='Amd1', Aliases='AdoMetDC, Amd-1, SAMDC, SAMDC 1, adoMetDC1', description='S-adenosylmethionine decarboxylase 1', other_designations='adoMetDC 1', map_location='10 B2', chromosome='10', genomic_nucleotide_accession_version='NC_000076.6', start_position_on_the_genomic_accession=40287458, end_position_on_the_genomic_accession=40302188, orientation='minus', exon_count=8, OMIM='', no_hdr0=''),
  667063 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=667063, CurrentID=0, Status='live', Symbol='Gm8439', Aliases='EG667063, Gm1664', description='predicted gene 8439', other_designations='', map_location='4 D2.2', chromosome='4', genomic_nucleotide_accession_version='NC_000070.6', start_position_on_the_genomic_accession=120588745, end_position_on_the_genomic_accession=120609673, orientation='plus', exon_count=3, OMIM='', no_hdr0=''),
  11704 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11704, CurrentID=0, Status='live', Symbol='Amelx', Aliases='ALGN, AMGL, AMGX, Amel, Amg, LRAP, Rgsc888', description='amelogenin, X-linked', other_designations='amelogenin X chromosome|enamel matrix protein|leucine-rich amelogenin peptide', map_location='X 78.95 cM', chromosome='X', genomic_nucleotide_accession_version='NC_000086.7', start_position_on_the_genomic_accession=169175044, end_position_on_the_genomic_accession=169187287, orientation='minus', exon_count=9, OMIM='', no_hdr0=''),
  11705 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11705, CurrentID=0, Status='live', Symbol='Amh', Aliases='MIS', description='anti-Mullerian hormone', other_designations='Mullerian inhibiting substance|anti-Muellerian hormone|muellerian-inhibiting substance', map_location='10 39.72 cM', chromosome='10', genomic_nucleotide_accession_version='NC_000076.6', start_position_on_the_genomic_accession=80805021, end_position_on_the_genomic_accession=80807679, orientation='plus', exon_count=5, OMIM='', no_hdr0=''),
  667067 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=667067, CurrentID=0, Status='live', Symbol='Vmn1r91', Aliases='EG667067, Gm8442', description='vomeronasal 1 receptor 91', other_designations='vomernasal 1 receptor Vmn1r91', map_location='7 A3', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=20101158, end_position_on_the_genomic_accession=20102081, orientation='plus', exon_count=1, OMIM='', no_hdr0=''),
  667069 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=667069, CurrentID=0, Status='live', Symbol='Vmn2r6', Aliases='EG620718, EG667069', description='vomeronasal 2, receptor 6', other_designations='', map_location='3 E1', chromosome='3', genomic_nucleotide_accession_version='NC_000069.6', start_position_on_the_genomic_accession=64537501, end_position_on_the_genomic_accession=64565434, orientation='minus', exon_count=6, OMIM='', no_hdr0=''),
  102641086 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102641086, CurrentID=0, Status='live', Symbol='LOC102641086', Aliases='', description='DNA-directed RNA polymerases I, II, and III subunit RPABC4', other_designations='', map_location='', chromosome='17', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  11717 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11717, CurrentID=0, Status='live', Symbol='Ampd3', Aliases='', description='adenosine monophosphate deaminase 3', other_designations='AMP deaminase H-type|heart-type AMPD', map_location='7 E2-E3', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=110767837, end_position_on_the_genomic_accession=110812409, orientation='plus', exon_count=20, OMIM='', no_hdr0=''),
  11720 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11720, CurrentID=0, Status='live', Symbol='Mat1a', Aliases='AI046368, AdoMet, Ams, MAT, MATA1, SAMS, SAMS1', description='methionine adenosyltransferase I, alpha', other_designations='adoMet synthetase 1', map_location='14 C1', chromosome='14', genomic_nucleotide_accession_version='NC_000080.6', start_position_on_the_genomic_accession=41105012, end_position_on_the_genomic_accession=41124428, orientation='plus', exon_count=10, OMIM='', no_hdr0=''),
  11722 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11722, CurrentID=0, Status='live', Symbol='Amy1', Aliases='Amy-1a, C030014B17Rik, Amy1', description='amylase 1, salivary', other_designations='1,4-alpha-D-glucan glucanohydrolase 1|alpha amylase 1|salivary and hepatic alpha-amylase', map_location='3 49.35 cM', chromosome='3', genomic_nucleotide_accession_version='NC_000069.6', start_position_on_the_genomic_accession=113555952, end_position_on_the_genomic_accession=113577750, orientation='minus', exon_count=12, OMIM='', no_hdr0=''),
  11727 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11727, CurrentID=0, Status='live', Symbol='Ang', Aliases='AI3855861, Rnase5, Rnase5a, Ang', description='angiogenin, ribonuclease, RNase A family, 5', other_designations='RNase 5|angiogenin, ribonuclease A family, member 1|angiogenin-1|ribonuclease 5', map_location='14 B-C1', chromosome='14', genomic_nucleotide_accession_version='NC_000080.6', start_position_on_the_genomic_accession=51091077, end_position_on_the_genomic_accession=51102009, orientation='plus', exon_count=3, OMIM='', no_hdr0=''),
  11730 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11730, CurrentID=0, Status='live', Symbol='Ang3', Aliases='Angl, Ef-5, Rnase5c', description='angiogenin, ribonuclease A family, member 3', other_designations='angiogenin related protein 2', map_location='14 C1', chromosome='14', genomic_nucleotide_accession_version='NC_000080.5', start_position_on_the_genomic_accession=44534734, end_position_on_the_genomic_accession=44540745, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  11731 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11731, CurrentID=0, Status='live', Symbol='Ang2', Aliases='Angrp, Raa3, Rnase5b', description='angiogenin, ribonuclease A family, member 2', other_designations='angiogenin related protein|angiogenin-related protein|ribonuclease A a3', map_location='14 C1', chromosome='14', genomic_nucleotide_accession_version='NC_000080.6', start_position_on_the_genomic_accession=51195486, end_position_on_the_genomic_accession=51195923, orientation='minus', exon_count=1, OMIM='', no_hdr0=''),
  11732 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11732, CurrentID=0, Status='live', Symbol='Ank', Aliases='Ankh, D15Ertd221e, ank, mKIAA1581', description='progressive ankylosis', other_designations='fn54 protein', map_location='15 10.23 cM', chromosome='15', genomic_nucleotide_accession_version='NC_000081.6', start_position_on_the_genomic_accession=27466677, end_position_on_the_genomic_accession=27594909, orientation='plus', exon_count=12, OMIM='', no_hdr0=''),
  11733 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11733, CurrentID=0, Status='live', Symbol='Ank1', Aliases='Ank-1, nb, pale', description='ankyrin 1, erythroid', other_designations='erythrocyte ankyrin|normoblastic anemia', map_location='8 11.42 cM', chromosome='8', genomic_nucleotide_accession_version='NC_000074.6', start_position_on_the_genomic_accession=22974836, end_position_on_the_genomic_accession=23150502, orientation='plus', exon_count=48, OMIM='', no_hdr0=''),
  667094 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=667094, CurrentID=0, Status='live', Symbol='Gm8453', Aliases='EG667094, Vmn1r145', description='predicted gene 8453', other_designations='', map_location='7 A3', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=22228564, end_position_on_the_genomic_accession=22229484, orientation='minus', exon_count=1, OMIM='', no_hdr0=''),
  11735 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11735, CurrentID=0, Status='live', Symbol='Ank3', Aliases='2900054D09Rik, AI314020, Ank-3, AnkG, Ankyrin-3, Ankyrin-G', description='ankyrin 3, epithelial', other_designations='brain-specific ankyrin-G', map_location='10 36.1 cM', chromosome='10', genomic_nucleotide_accession_version='NC_000076.6', start_position_on_the_genomic_accession=69533580, end_position_on_the_genomic_accession=70027436, orientation='plus', exon_count=51, OMIM='', no_hdr0=''),
  11736 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11736, CurrentID=0, Status='live', Symbol='Ankfy1', Aliases='Ankhzn, ZFYVE14, mKIAA1255', description='ankyrin repeat and FYVE domain containing 1', other_designations='Rabankyrin-5|ankyrin repeat and FYVE domain-containing protein 1|ankyrin repeat hooked to a zinc finger motif|ankyrin repeat hooked to zinc finger motif|ankyrin repeats hooked to a zinc finger motif|rank-5', map_location='11 B4', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=72690002, end_position_on_the_genomic_accession=72772146, orientation='plus', exon_count=25, OMIM='', no_hdr0=''),
  11737 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11737, CurrentID=0, Status='live', Symbol='Anp32a', Aliases='Anp32, I1PP2A, LANP, PHAP1, W91701, pp32', description='acidic (leucine-rich) nuclear phosphoprotein 32 family, member A', other_designations='acidic nuclear phosphoprotein 32|acidic nuclear phosphoprotein pp32|leucine-rich acidic nuclear protein|potent heat-stable protein phosphatase 2A inhibitor I1PP2A|vacidic (leucine-rich) nuclear phosphoprotein 32 family, member A', map_location='9 33.68 cM', chromosome='9', genomic_nucleotide_accession_version='NC_000075.6', start_position_on_the_genomic_accession=62341343, end_position_on_the_genomic_accession=62378804, orientation='plus', exon_count=9, OMIM='', no_hdr0=''),
  102641114 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102641114, CurrentID=0, Status='live', Symbol='LOC102641114', Aliases='', description='selection and upkeep of intraepithelial T-cells protein 5-like', other_designations='', map_location='', chromosome='Un', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  11739 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11739, CurrentID=0, Status='live', Symbol='Slc25a4', Aliases='AU019225, Ant1', description='solute carrier family 25 (mitochondrial carrier, adenine nucleotide translocator), member 4', other_designations='ADP,ATP carrier protein 1|ADP,ATP carrier protein, heart/skeletal muscle|ANT 1|adenine nucleotide translocase-1|adenine nucleotide translocator 1, skeletal muscle|mANC1|solute carrier family 25 member 4', map_location='8 26.22 cM', chromosome='8', genomic_nucleotide_accession_version='NC_000074.6', start_position_on_the_genomic_accession=46207339, end_position_on_the_genomic_accession=46211009, orientation='minus', exon_count=4, OMIM='', no_hdr0=''),
  11740 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11740, CurrentID=0, Status='live', Symbol='Slc25a5', Aliases='Ant2', description='solute carrier family 25 (mitochondrial carrier, adenine nucleotide translocator), member 5', other_designations='ADP, ATP carrier protein 2|ADP,ATP carrier protein 2|adenine nucleotide translocase|adenine nucleotide translocator 2, fibroblast', map_location='X A4', chromosome='X', genomic_nucleotide_accession_version='NC_000086.7', start_position_on_the_genomic_accession=36795652, end_position_on_the_genomic_accession=36798806, orientation='plus', exon_count=4, OMIM='', no_hdr0=''),
  667103 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=667103, CurrentID=0, Status='live', Symbol='Gm13570', Aliases='OTTMUSG00000012817', description='predicted gene 13570', other_designations='', map_location='2 C1.1', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=60098145, end_position_on_the_genomic_accession=60101483, orientation='minus', exon_count=1, OMIM='', no_hdr0=''),
  11744 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11744, CurrentID=0, Status='live', Symbol='Anxa11', Aliases='A830099O17Rik, Anx11', description='annexin A11', other_designations='Annexin A11 (Annexin XI) (Calcyclin-associated annexin 50) (CAP-50)|CAP-50|annexin XI|annexin-11|calcyclin-associated annexin 50', map_location='14 15.06 cM', chromosome='14', genomic_nucleotide_accession_version='NC_000080.6', start_position_on_the_genomic_accession=25842151, end_position_on_the_genomic_accession=25886804, orientation='plus', exon_count=16, OMIM='', no_hdr0=''),
  11745 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11745, CurrentID=0, Status='live', Symbol='Anxa3', Aliases='Anx3', description='annexin A3', other_designations='35-alpha calcimedin|PAP-III|annexin III|annexin-3|lipocortin III|placental anticoagulant protein III', map_location='5 47.29 cM', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=96793385, end_position_on_the_genomic_accession=96845968, orientation='plus', exon_count=13, OMIM='', no_hdr0=''),
  11746 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11746, CurrentID=0, Status='live', Symbol='Anxa4', Aliases='AI265406, AIV, AW106930, Anx4, Xanx-4', description='annexin A4', other_designations='annexin IV|annexin-4', map_location='6 37.75 cM', chromosome='6', genomic_nucleotide_accession_version='NC_000072.6', start_position_on_the_genomic_accession=86736840, end_position_on_the_genomic_accession=86793593, orientation='minus', exon_count=17, OMIM='', no_hdr0=''),
  11747 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11747, CurrentID=0, Status='live', Symbol='Anxa5', Aliases='Anx5, R74653', description='annexin A5', other_designations='CBP-I|PAP-I|PP4|VAC-alpha|anchorin CII|annexin V|annexin-5|calphobindin I|endonexin II|lipocortin V|placental anticoagulant protein 4|placental anticoagulant protein I|thromboplastin inhibitor|vascular anticoagulant-alpha', map_location='3 17.46 cM', chromosome='3', genomic_nucleotide_accession_version='NC_000069.6', start_position_on_the_genomic_accession=36448923, end_position_on_the_genomic_accession=36475887, orientation='minus', exon_count=13, OMIM='', no_hdr0=''),
  11749 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11749, CurrentID=0, Status='live', Symbol='Anxa6', Aliases='AW107198, Anx6, AnxVI, Cabm, Camb', description='annexin A6', other_designations='67 kDa calelectrin|CPB-II|annexin VI, p68|annexin-6|calphobindin-II|chromobindin-20|lipocortin VI|p68|p70', map_location='11 32.13 cM', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=54978962, end_position_on_the_genomic_accession=55033471, orientation='minus', exon_count=26, OMIM='', no_hdr0=''),
  11750 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11750, CurrentID=0, Status='live', Symbol='Anxa7', Aliases='AI265384, AI316497, Anx7, synexin', description='annexin A7', other_designations='annexin VII|annexin-7', map_location='14 11.53 cM', chromosome='14', genomic_nucleotide_accession_version='NC_000080.6', start_position_on_the_genomic_accession=20455261, end_position_on_the_genomic_accession=20480133, orientation='minus', exon_count=14, OMIM='', no_hdr0=''),
  11752 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11752, CurrentID=0, Status='live', Symbol='Anxa8', Aliases='AI466995, Anx8', description='annexin A8', other_designations='annexin 8|annexin VIII', map_location='14 20.8 cM', chromosome='14', genomic_nucleotide_accession_version='NC_000080.6', start_position_on_the_genomic_accession=34085979, end_position_on_the_genomic_accession=34100571, orientation='plus', exon_count=12, OMIM='', no_hdr0=''),
  11754 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11754, CurrentID=0, Status='live', Symbol='Aoc3', Aliases='SSAO, VAP1', description='amine oxidase, copper containing 3', other_designations='VAP-1|copper amine oxidase|semicarbazide-sensitive amine oxidase|vascular adhesion protein 1', map_location='11 B2-B5', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=101330606, end_position_on_the_genomic_accession=101339430, orientation='plus', exon_count=6, OMIM='', no_hdr0=''),
  11757 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11757, CurrentID=0, Status='live', Symbol='Prdx3', Aliases='AW822249, Aop1, D0Tohi1, Ef2l, Mer5, Prx3, SP22, TDXM', description='peroxiredoxin 3', other_designations='AOP-1|Prx III|anti-oxidant protein 1|antioxidant protein|mitochondrial Trx dependent peroxide reductase|mitochondrial thioredoxin dependent peroxide reductase|perioredoxin-3|peroxiredoxin III', map_location='19 56.52 cM', chromosome='19', genomic_nucleotide_accession_version='NC_000085.6', start_position_on_the_genomic_accession=60864066, end_position_on_the_genomic_accession=60874538, orientation='minus', exon_count=7, OMIM='', no_hdr0=''),
  11758 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11758, CurrentID=0, Status='live', Symbol='Prdx6', Aliases='1-Cys Prx, 1-cysPrx, 9430088D19Rik, AA690119, Aop2, Brp-12, CP-3, GPx, Ltw-4, Ltw4, Lvtw-4, NSGPx, ORF06, Prdx5, aiPLA2', description='peroxiredoxin 6', other_designations='1-Cys peroxiredoxin|acidic calcium-independent phospholipase A2|anti-oxidant protein 2, related sequence 3|antioxidant protein 2|non-selenium glutathione peroxidase|peroxiredoxin 5, related sequence 3|peroxiredoxin 6, related sequence 3', map_location='1 69.75 cM', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=161240112, end_position_on_the_genomic_accession=161251210, orientation='minus', exon_count=6, OMIM='', no_hdr0=''),
  11761 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11761, CurrentID=0, Status='live', Symbol='Aox1', Aliases='AI196512, AI255253, Ao, Aox-1, Aox-2, Aox2, Moro, Ro', description='aldehyde oxidase 1', other_designations='aldehyde oxidase 2|azaheterocycle hydroxylase 1|retinal oxidase', map_location='1 C1-C2', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=58029809, end_position_on_the_genomic_accession=58106410, orientation='plus', exon_count=36, OMIM='', no_hdr0=''),
  11764 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11764, CurrentID=0, Status='live', Symbol='Ap1b1', Aliases='Adtb1, b2b1660Clo', description='adaptor protein complex AP-1, beta 1 subunit', other_designations='Mutant line 1660|adapter-related protein complex 1 subunit beta-1|adaptor protein complex AP-1 subunit beta-1|adaptor-related protein complex 1 subunit beta-1|adaptor-related protein complex AP-1, beta 1 subunit|beta-1-adaptin|beta-adaptin 1|beta-prime adaptin|beta1-adaptin|clathrin assembly protein complex 1 beta large chain|golgi adaptor HA1/AP1 adaptin beta subunit', map_location='11 A2', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=4947521, end_position_on_the_genomic_accession=5042794, orientation='plus', exon_count=25, OMIM='', no_hdr0=''),
  11765 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11765, CurrentID=0, Status='live', Symbol='Ap1g1', Aliases='AA409002, AU041323, AW551707, Adtg, D8Ertd374e', description='adaptor protein complex AP-1, gamma 1 subunit', other_designations='adapter-related protein complex 1 subunit gamma-1|adaptor protein complex AP-1 subunit gamma-1|adaptor-related protein complex 1 subunit gamma-1|clathrin assembly protein complex 1 gamma-1 large chain|gamma-adaptin|gamma1-adaptin|golgi adaptor HA1/AP1 adaptin subunit gamma-1', map_location='8 57.26 cM', chromosome='8', genomic_nucleotide_accession_version='NC_000074.6', start_position_on_the_genomic_accession=109778583, end_position_on_the_genomic_accession=109864210, orientation='plus', exon_count=24, OMIM='', no_hdr0=''),
  11766 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11766, CurrentID=0, Status='live', Symbol='Ap1g2', Aliases='Adtg2, G2ad', description='adaptor protein complex AP-1, gamma 2 subunit', other_designations='gamma 2-adaptin', map_location='14 C3', chromosome='14', genomic_nucleotide_accession_version='NC_000080.6', start_position_on_the_genomic_accession=55098835, end_position_on_the_genomic_accession=55106593, orientation='minus', exon_count=22, OMIM='', no_hdr0=''),
  11767 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11767, CurrentID=0, Status='live', Symbol='Ap1m1', Aliases='AA408894, AP47, Adtm1A, Cltnm, [m]1A, mu1A', description='adaptor-related protein complex AP-1, mu subunit 1', other_designations='AP-mu chain family member mu1A|adapter-related protein complex 1 subunit mu-1|adaptor protein complex AP-1 mu-1 subunit|adaptor protein complex AP-1 subunit mu-1|adaptor-related protein complex 1 mu-1 subunit|adaptor-related protein complex 1 subunit mu-1|clathrin assembly protein complex 1 medium chain 1|clathrin assembly protein complex 1 mu-1 medium chain 1|clathrin coat assembly protein AP47|clathrin coat-associated protein AP47|golgi adaptor HA1/AP1 adaptin mu-1 subunit|mu-adaptin 1|mu1A-adaptin', map_location='8 34.92 cM', chromosome='8', genomic_nucleotide_accession_version='NC_000074.6', start_position_on_the_genomic_accession=72240050, end_position_on_the_genomic_accession=72257385, orientation='plus', exon_count=13, OMIM='', no_hdr0=''),
  11768 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11768, CurrentID=0, Status='live', Symbol='Ap1m2', Aliases='D9Ertd818e, [m]1B, mu1B', description='adaptor protein complex AP-1, mu 2 subunit', other_designations='AP-mu chain family member mu1B|adaptor protein complex AP-1 mu-2 subunit|adaptor protein complex AP-1 subunit mu-2|adaptor-related protein complex 1 mu-2 subunit|adaptor-related protein complex 1 subunit mu-2|adaptor-related protein complex AP-1, mu 2 subunit|clathrin assembly protein complex 1 medium chain 2|clathrin assembly protein complex 1 mu-2 medium chain 2|golgi adaptor HA1/AP1 adaptin mu-2 subunit|mu-adaptin 2|mu1B-adaptin', map_location='9 7.76 cM', chromosome='9', genomic_nucleotide_accession_version='NC_000075.6', start_position_on_the_genomic_accession=21294613, end_position_on_the_genomic_accession=21312349, orientation='minus', exon_count=11, OMIM='', no_hdr0=''),
  11769 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11769, CurrentID=0, Status='live', Symbol='Ap1s1', Aliases='AP19', description='adaptor protein complex AP-1, sigma 1', other_designations='HA1 19 kDa subunit|adapter-related protein complex 1 sigma-1A subunit|adapter-related protein complex 1 subunit sigma-1A|adaptor protein complex AP-1 sigma-1A subunit|adaptor protein complex AP-1 subunit sigma-1A|adaptor-related protein complex 1 subunit sigma-1A|adaptor-related protein complex AP-1, sigma 1|clathrin assembly protein complex 1 sigma-1A small chain|clathrin coat assembly protein AP19|golgi adaptor HA1/AP1 adaptin sigma-1A subunit|sigma 1a subunit of AP-1 clathrin|sigma-adaptin 1A|sigma1A-adaptin', map_location='5 G1', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=137034993, end_position_on_the_genomic_accession=137046060, orientation='minus', exon_count=6, OMIM='', no_hdr0=''),
  11770 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11770, CurrentID=0, Status='live', Symbol='Fabp4', Aliases='422/aP2, ALBP/Ap2, Ap2, Lbpl', description='fatty acid binding protein 4, adipocyte', other_designations='3T3-L1 lipid-binding protein|A-FABP|AFABP|ALBP|P15|P2 adipocyte protein|adipocyte lipid-binding protein|adipocyte protein aP2|adipocyte-type fatty acid-binding protein|fatty acid-binding protein 4|myelin P2 protein homolog|protein 422', map_location='3 2.56 cM', chromosome='3', genomic_nucleotide_accession_version='NC_000069.6', start_position_on_the_genomic_accession=10204342, end_position_on_the_genomic_accession=10208597, orientation='minus', exon_count=4, OMIM='', no_hdr0=''),
  11771 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11771, CurrentID=0, Status='live', Symbol='Ap2a1', Aliases='Adtaa', description='adaptor-related protein complex 2, alpha 1 subunit', other_designations='100 kDa coated vesicle protein A|adapter-related protein complex 2 alpha-1 subunit|adapter-related protein complex 2 subunit alpha-1|adaptor protein complex AP-2 subunit alpha-1|adaptor protein complex AP-2, alpha 1 subunit|adaptor-related protein complex 2 subunit alpha-1|adaptor-related protein complex AP-2, alpha 1 subunit|alpha-adaptin A|alpha1-adaptin|clathrin assembly protein complex 2 alpha-A large chain|plasma membrane adaptor HA2/AP2 adaptin alpha A subunit', map_location='7 B2', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=44900373, end_position_on_the_genomic_accession=44929490, orientation='minus', exon_count=25, OMIM='', no_hdr0=''),
  11772 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11772, CurrentID=0, Status='live', Symbol='Ap2a2', Aliases='2410074K14Rik, AF006990, AW146353, Adtab, C78001, L25', description='adaptor-related protein complex 2, alpha 2 subunit', other_designations='100 kDa coated vesicle protein C|adapter-related protein complex 2 alpha-2 subunit|adapter-related protein complex 2 subunit alpha-2|adaptor protein complex AP-2 subunit alpha-2|adaptor protein complex AP-2, alpha 2 subunit|adaptor-related protein complex 2 subunit alpha-2|adaptor-related protein complex AP-2, alpha 2 subunit|alpha-C adaptin|alpha-adaptin C|alpha2-adaptin|clathrin assembly protein complex 2 alpha-C large chain|plasma membrane adaptor HA2/AP2 adaptin alpha C subunit', map_location='7 F5', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=141562180, end_position_on_the_genomic_accession=141633011, orientation='plus', exon_count=23, OMIM='', no_hdr0=''),
  11773 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11773, CurrentID=0, Status='live', Symbol='Ap2m1', Aliases='', description='adaptor-related protein complex 2, mu 1 subunit', other_designations='AP-2 mu chain|adapter-related protein complex 2 mu subunit|adaptor protein complex AP-2 subunit mu|adaptor protein complex AP-2, mu1|adaptor-related protein complex 2 subunit mu|adaptor-related protein complex AP-2, mu1|clathrin assembly protein complex 2 medium chain|clathrin assembly protein complex 2 mu medium chain|clathrin coat assembly protein AP50|clathrin coat-associated protein AP50|clathrin-associated AP-2|mu2-adaptin|plasma membrane adaptor AP-2 50 kDa protein', map_location='16 A3', chromosome='16', genomic_nucleotide_accession_version='NC_000082.6', start_position_on_the_genomic_accession=20535480, end_position_on_the_genomic_accession=20544909, orientation='plus', exon_count=12, OMIM='', no_hdr0=''),
  11774 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11774, CurrentID=0, Status='live', Symbol='Ap3b1', Aliases='AP-3, AU015684, C78395, Hps2, beta3A, pe, pearl, rim2', description='adaptor-related protein complex 3, beta 1 subunit', other_designations='adapter-related protein complex 3 subunit beta-1|adaptor protein complex AP-3 beta-1 subunit|adaptor protein complex AP-3 subunit beta-1|adaptor-related protein complex 3 subunit beta-1|adaptor-related protein complex AP-3, beta 1 subunit|beta-3A-adaptin|beta3A-adaptin|clathrin assembly protein complex 3 beta-1 large chain|recombination induced mutation 2', map_location='13 49.22 cM', chromosome='13', genomic_nucleotide_accession_version='NC_000079.6', start_position_on_the_genomic_accession=94358952, end_position_on_the_genomic_accession=94566316, orientation='plus', exon_count=28, OMIM='', no_hdr0=''),
  667135 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=667135, CurrentID=0, Status='live', Symbol='Vmn1r104', Aliases='EG667135, Gm8477', description='vomeronasal 1 receptor 104', other_designations='vomernasal 1 receptor Vmn1r104', map_location='7 A3', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=20533837, end_position_on_the_genomic_accession=20534760, orientation='plus', exon_count=1, OMIM='', no_hdr0=''),
  11776 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11776, CurrentID=0, Status='live', Symbol='Ap3d1', Aliases='AA407035, Ap3d, Bolvr, mBLVR1, mh, mocha', description='adaptor-related protein complex 3, delta 1 subunit', other_designations='AP-3 complex subunit delta|adapter-related protein complex 3 subunit delta-1|adaptor-related protein complex 3 subunit delta-1|adaptor-related protein complex 3, delta subunit|adaptor-related protein complex AP-3, delta subunit|delta-adaptin', map_location='10 39.72 cM', chromosome='10', genomic_nucleotide_accession_version='NC_000076.6', start_position_on_the_genomic_accession=80706956, end_position_on_the_genomic_accession=80742282, orientation='minus', exon_count=33, OMIM='', no_hdr0=''),
  11777 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11777, CurrentID=0, Status='live', Symbol='Ap3s1', Aliases='', description='adaptor-related protein complex 3, sigma 1 subunit', other_designations='AP-3 complex sigma-3A subunit|adapter-related protein complex 3 sigma-1 subunit|adaptor-related protein complex AP-3, sigma 1 subunit|sigma-3A-adaptin|sigma-adaptin 3a', map_location='18 C', chromosome='18', genomic_nucleotide_accession_version='NC_000084.6', start_position_on_the_genomic_accession=46741876, end_position_on_the_genomic_accession=46790826, orientation='plus', exon_count=7, OMIM='', no_hdr0=''),
  11778 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11778, CurrentID=0, Status='live', Symbol='Ap3s2', Aliases='[s]3B', description='adaptor-related protein complex 3, sigma 2 subunit', other_designations='AP-3 complex sigma-3B subunit|AP-3 complex subunit sigma-3B|adapter-related protein complex 3 sigma-2 subunit|adapter-related protein complex 3 subunit sigma-2|adaptor-related protein complex 3 subunit sigma-2|adaptor-related protein complex AP-3, sigma 2 subunit|sigma 3B|sigma-3B-adaptin|sigma-adaptin 3b|sigma3B-adaptin', map_location='7 D3', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=79875325, end_position_on_the_genomic_accession=79920640, orientation='minus', exon_count=6, OMIM='', no_hdr0=''),
  11781 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11781, CurrentID=0, Status='live', Symbol='Ap4m1', Aliases='4930443L05Rik, Ap4m4', description='adaptor-related protein complex AP-4, mu 1', other_designations='AP-4 adapter complex mu subunit|AP-4 adaptor complex mu subunit|adapter-related protein complex 4 mu-1 subunit|adapter-related protein complex 4 subunit mu-1|adaptor-related protein complex 4 subunit mu-1|adaptor-related protein complex AP-4 mu4 subunit|mu subunit of AP-4|mu-ARP2|mu-adaptin-related protein 2|mu4|mu4-adaptin', map_location='5 G1', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=138172021, end_position_on_the_genomic_accession=138178687, orientation='plus', exon_count=15, OMIM='', no_hdr0=''),
  11782 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11782, CurrentID=0, Status='live', Symbol='Ap4s1', Aliases='AI314282', description='adaptor-related protein complex AP-4, sigma 1', other_designations='AP-4 adapter complex subunit sigma-1|AP-4 adaptor complex subunit sigma-1|adapter-related protein complex 4 subunit sigma-1|adaptor-related protein complex 4 subunit sigma-1|sigma-1 subunit of AP-4|sigma-4-adaptin|sigma4-adaptin', map_location='12 C1', chromosome='12', genomic_nucleotide_accession_version='NC_000078.6', start_position_on_the_genomic_accession=51689888, end_position_on_the_genomic_accession=51738939, orientation='plus', exon_count=9, OMIM='', no_hdr0=''),
  11783 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11783, CurrentID=0, Status='live', Symbol='Apaf1', Aliases='6230400I06Rik, Apaf-1l, fog, mKIAA0413, Apaf1', description='apoptotic peptidase activating factor 1', other_designations='apoptotic protease activating factor 1|forebrain overgrowth', map_location='10 C3-D1', chromosome='10', genomic_nucleotide_accession_version='NC_000076.6', start_position_on_the_genomic_accession=90989311, end_position_on_the_genomic_accession=91082743, orientation='minus', exon_count=27, OMIM='', no_hdr0=''),
  11784 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11784, CurrentID=0, Status='live', Symbol='Apba2', Aliases='X11-like, X11L, XllL, mXllL', description='amyloid beta (A4) precursor protein-binding, family A, member 2', other_designations='Mint 2|adapter protein X11beta|mint-2|neuron-specific X11L protein|neuronal Munc18-1-interacting protein 2', map_location='7 34.65 cM', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=64501706, end_position_on_the_genomic_accession=64753878, orientation='plus', exon_count=18, OMIM='', no_hdr0=''),
  11785 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11785, CurrentID=0, Status='live', Symbol='Apbb1', Aliases='Fe65, Rir', description='amyloid beta (A4) precursor protein-binding, family B, member 1', other_designations='', map_location='7 55.9 cM', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=105558465, end_position_on_the_genomic_accession=105581653, orientation='minus', exon_count=19, OMIM='', no_hdr0=''),
  11787 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11787, CurrentID=0, Status='live', Symbol='Apbb2', Aliases='2310007D03Rik, FE65L1, Rirl1, TR2L, Zfra', description='amyloid beta (A4) precursor protein-binding, family B, member 2', other_designations='zinc finger-like protein', map_location='5 C3.1', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=66298725, end_position_on_the_genomic_accession=66618817, orientation='minus', exon_count=20, OMIM='', no_hdr0=''),
  11789 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11789, CurrentID=0, Status='live', Symbol='Apc', Aliases='AI047805, AU020952, AW124434, CC1, Min, mAPC', description='adenomatosis polyposis coli', other_designations='multiple intestinal neoplasia', map_location='18 18.53 cM', chromosome='18', genomic_nucleotide_accession_version='NC_000084.6', start_position_on_the_genomic_accession=34220307, end_position_on_the_genomic_accession=34322190, orientation='plus', exon_count=19, OMIM='', no_hdr0=''),
  11790 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11790, CurrentID=0, Status='live', Symbol='Speg', Aliases='AW125581, Apeg1, BPEG, D1Bwg1450e, SPEGalpha, SPEGbeta, mKIAA1297', description='SPEG complex locus', other_designations='APEG-1|aortic preferentially expressed gene 1|aortic preferentially expressed protein 1', map_location='1 38.88 cM', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=75375297, end_position_on_the_genomic_accession=75432320, orientation='plus', exon_count=49, OMIM='', no_hdr0=''),
  11792 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11792, CurrentID=0, Status='live', Symbol='Apex1', Aliases='APE, Apex, HAP1, Ref-1', description='apurinic/apyrimidinic endonuclease 1', other_designations='AP endonuclease 1|APEN|APEX nuclease|apurinic-apyrimidinic endonuclease 1|redox factor-1', map_location='14 C3', chromosome='14', genomic_nucleotide_accession_version='NC_000080.6', start_position_on_the_genomic_accession=50924944, end_position_on_the_genomic_accession=50927188, orientation='plus', exon_count=5, OMIM='', no_hdr0=''),
  11793 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11793, CurrentID=0, Status='live', Symbol='Atg5', Aliases='2010107M05Rik, 3110067M24Rik, AW319544, Apg5ll, C88337, Paddy, Atg5', description='autophagy related 5', other_designations='autophagy-related 5', map_location='10 23.24 cM', chromosome='10', genomic_nucleotide_accession_version='NC_000076.6', start_position_on_the_genomic_accession=44268358, end_position_on_the_genomic_accession=44364299, orientation='plus', exon_count=9, OMIM='', no_hdr0=''),
  11796 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11796, CurrentID=0, Status='live', Symbol='Birc3', Aliases='AW107670, Api1, Api2, Birc2, HIAP2, IAP1, IAP2, MIAP1, MIAP2, MIHB, MIHC, RNF49, cIAP-1, cIAP-2, cIAP1, cIAP2', description='baculoviral IAP repeat-containing 3', other_designations='IAP-1|apoptosis inhibitor 1|baculoviral IAP repeat-containing 2|inhibitor of apoptosis protein 1|mIAP-1', map_location='9 A2', chromosome='9', genomic_nucleotide_accession_version='NC_000075.6', start_position_on_the_genomic_accession=7848699, end_position_on_the_genomic_accession=7873213, orientation='minus', exon_count=13, OMIM='', no_hdr0=''),
  11797 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11797, CurrentID=0, Status='live', Symbol='Birc2', Aliases='AW146227, Api1, Api2, Birc3, C330006D17Rik, HIAP1, HIAP2, IAP1, IAP2, MIAP1, MIAP2, MIHB, MIHC, RNF48, cIAP1, cIAP2, mcIAP1', description='baculoviral IAP repeat-containing 2', other_designations='IAP-2|apoptosis inhibitor 2|baculoviral IAP repeat-containing 3|inhibitor of apoptosis protein 2|mIAP-2', map_location='9 A1', chromosome='9', genomic_nucleotide_accession_version='NC_000075.6', start_position_on_the_genomic_accession=7818226, end_position_on_the_genomic_accession=7837133, orientation='minus', exon_count=8, OMIM='', no_hdr0=''),
  11798 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11798, CurrentID=0, Status='live', Symbol='Xiap', Aliases='1110015C02Rik, Aipa, Api3, Birc4, IAP3, ILP-1, MIHA', description='X-linked inhibitor of apoptosis', other_designations='IAP homolog A|X-linked IAP|baculoviral IAP repeat-containing protein 4|inhibitor of apoptosis protein 3', map_location='X A3-A5', chromosome='X', genomic_nucleotide_accession_version='NC_000086.7', start_position_on_the_genomic_accession=42060402, end_position_on_the_genomic_accession=42109664, orientation='plus', exon_count=11, OMIM='', no_hdr0=''),
  11799 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11799, CurrentID=0, Status='live', Symbol='Birc5', Aliases='AAC-11, Api4, TIAP, survivin40', description='baculoviral IAP repeat-containing 5', other_designations='apoptosis inhibitor 4|apoptosis inhibitor survivin|survivin', map_location='11 E2', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=117849237, end_position_on_the_genomic_accession=117855743, orientation='plus', exon_count=3, OMIM='', no_hdr0=''),
  11800 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11800, CurrentID=0, Status='live', Symbol='Api5', Aliases='AAC-11, AI196452, API-5', description='apoptosis inhibitor 5', other_designations='apoptosis inhibitory protein 5', map_location='2 E1', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=94411727, end_position_on_the_genomic_accession=94438181, orientation='minus', exon_count=14, OMIM='', no_hdr0=''),
  11801 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11801, CurrentID=0, Status='live', Symbol='Cd5l', Aliases='1/6, AAC-11, AI047839, Api6, CT2, Pdp, Sp-alpha', description='CD5 antigen-like', other_designations='AIM/Spalpha|CT-2|Pdp 1/6|apoptosis inhibitor 6|apoptosis inhibitor expressed by macrophages', map_location='3 F1', chromosome='3', genomic_nucleotide_accession_version='NC_000069.6', start_position_on_the_genomic_accession=87357881, end_position_on_the_genomic_accession=87371074, orientation='plus', exon_count=6, OMIM='', no_hdr0=''),
  11803 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11803, CurrentID=0, Status='live', Symbol='Aplp1', Aliases='', description='amyloid beta (A4) precursor-like protein 1', other_designations='APLP|APLP-1', map_location='7 18.32 cM', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=30434980, end_position_on_the_genomic_accession=30445582, orientation='minus', exon_count=17, OMIM='', no_hdr0=''),
  11804 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11804, CurrentID=0, Status='live', Symbol='Aplp2', Aliases='AI790698, APLP-2', description='amyloid beta (A4) precursor-like protein 2', other_designations='CDEBP|CDEI box-binding protein', map_location='9 A2-B', chromosome='9', genomic_nucleotide_accession_version='NC_000075.6', start_position_on_the_genomic_accession=31149557, end_position_on_the_genomic_accession=31211843, orientation='minus', exon_count=19, OMIM='', no_hdr0=''),
  11806 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11806, CurrentID=0, Status='live', Symbol='Apoa1', Aliases='Alp-1, Apoa-1, Brp-14, Ltw-1, Lvtw-1, Sep-1, Sep-2, Sep2, apo-AI, apoA-I', description='apolipoprotein A-I', other_designations='apolipoprotein A1', map_location='9 A2-A4', chromosome='9', genomic_nucleotide_accession_version='NC_000075.6', start_position_on_the_genomic_accession=46228630, end_position_on_the_genomic_accession=46230469, orientation='plus', exon_count=4, OMIM='', no_hdr0=''),
  11807 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11807, CurrentID=0, Status='live', Symbol='Apoa2', Aliases='Alp-2, Apo-AII, ApoA-II, ApoAII, Apoa-2, Hdl-1', description='apolipoprotein A-II', other_designations='apolipoprotein A2', map_location='1 79.22 cM', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=171225011, end_position_on_the_genomic_accession=171226379, orientation='plus', exon_count=4, OMIM='', no_hdr0=''),
  11808 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11808, CurrentID=0, Status='live', Symbol='Apoa4', Aliases='Apoa-4', description='apolipoprotein A-IV', other_designations='apo-AIV|apoA-IV|apolipoprotein A4', map_location='9 25.36 cM', chromosome='9', genomic_nucleotide_accession_version='NC_000075.6', start_position_on_the_genomic_accession=46240844, end_position_on_the_genomic_accession=46243458, orientation='plus', exon_count=3, OMIM='', no_hdr0=''),
  11810 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11810, CurrentID=0, Status='live', Symbol='Apobec1', Aliases='Cdar1', description='apolipoprotein B mRNA editing enzyme, catalytic polypeptide 1', other_designations='apolipoprotein B editing complex 1|mRNA(cytosine(6666)) deaminase 1', map_location='6 57.68 cM', chromosome='6', genomic_nucleotide_accession_version='NC_000072.6', start_position_on_the_genomic_accession=122577792, end_position_on_the_genomic_accession=122603041, orientation='minus', exon_count=10, OMIM='', no_hdr0=''),
  11811 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11811, CurrentID=0, Status='live', Symbol='Apobec2', Aliases='Arp1', description='apolipoprotein B mRNA editing enzyme, catalytic polypeptide 2', other_designations='apolipoprotein B editing complex 2|mRNA(cytosine(6666)) deaminase 2|probable C->U-editing enzyme APOBEC-2', map_location='17 24.02 cM', chromosome='17', genomic_nucleotide_accession_version='NC_000083.6', start_position_on_the_genomic_accession=48419231, end_position_on_the_genomic_accession=48432728, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  11812 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11812, CurrentID=0, Status='live', Symbol='Apoc1', Aliases='Apo-CIB, ApoC-IB, apo-CI, apoC-I', description='apolipoprotein C-I', other_designations='apolipoprotein C1', map_location='7 9.94 cM', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=19689480, end_position_on_the_genomic_accession=19692659, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  11813 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11813, CurrentID=0, Status='live', Symbol='Apoc2', Aliases='apo-CII, apoC-II', description='apolipoprotein C-II', other_designations='apolipoprotein C2', map_location='7 9.94 cM', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=19671579, end_position_on_the_genomic_accession=19677941, orientation='minus', exon_count=5, OMIM='', no_hdr0=''),
  11814 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11814, CurrentID=0, Status='live', Symbol='Apoc3', Aliases='apo-CIII, apoC-III', description='apolipoprotein C-III', other_designations='apolipoprotein C3', map_location='9 25.36 cM', chromosome='9', genomic_nucleotide_accession_version='NC_000075.6', start_position_on_the_genomic_accession=46233050, end_position_on_the_genomic_accession=46235636, orientation='minus', exon_count=5, OMIM='', no_hdr0=''),
  11815 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11815, CurrentID=0, Status='live', Symbol='Apod', Aliases='', description='apolipoprotein D', other_designations='', map_location='16 21.41 cM', chromosome='16', genomic_nucleotide_accession_version='NC_000082.6', start_position_on_the_genomic_accession=31296192, end_position_on_the_genomic_accession=31314808, orientation='minus', exon_count=6, OMIM='', no_hdr0=''),
  11816 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11816, CurrentID=0, Status='live', Symbol='Apoe', Aliases='AI255918, Apo-E', description='apolipoprotein E', other_designations='', map_location='7 9.94 cM', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=19696244, end_position_on_the_genomic_accession=19699166, orientation='minus', exon_count=4, OMIM='', no_hdr0=''),
  11818 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11818, CurrentID=0, Status='live', Symbol='Apoh', Aliases='B2GPI, beta-2-GPI, beta2-GPI', description='apolipoprotein H', other_designations='APC inhibitor|activated protein C-binding protein|apo-H|beta(2)GPI|beta-2-glycoprotein I', map_location='11 D', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=108395297, end_position_on_the_genomic_accession=108414396, orientation='plus', exon_count=8, OMIM='', no_hdr0=''),
  11819 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11819, CurrentID=0, Status='live', Symbol='Nr2f2', Aliases='2700033K02Rik, 9430015G03Rik, ARP-1, Aporp1, COUP-TF2, COUP-TFII, COUPTFB, EAR3, SVP40, Tcfcoup2', description='nuclear receptor subfamily 2, group F, member 2', other_designations='COUP transcription factor II|COUP-TF II|apolipoprotein AI regulatory protein 1|apolipoprotein regulatory protein 1', map_location='7 38.66 cM', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=70351946, end_position_on_the_genomic_accession=70366746, orientation='minus', exon_count=5, OMIM='', no_hdr0=''),
  11820 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11820, CurrentID=0, Status='live', Symbol='App', Aliases='Abeta, Abpp, Adap, Ag, Cvap, E030013M08Rik, betaApp', description='amyloid beta (A4) precursor protein', other_designations='alzheimer disease amyloid A4 protein homolog|amyloidogenic glycoprotein|appican|protease nexin II', map_location='16 C3-qter', chromosome='16', genomic_nucleotide_accession_version='NC_000082.6', start_position_on_the_genomic_accession=84954436, end_position_on_the_genomic_accession=85173952, orientation='minus', exon_count=19, OMIM='', no_hdr0=''),
  11821 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11821, CurrentID=0, Status='live', Symbol='Aprt', Aliases='C85684', description='adenine phosphoribosyl transferase', other_designations='', map_location='8 71.91 cM', chromosome='8', genomic_nucleotide_accession_version='NC_000074.6', start_position_on_the_genomic_accession=122574637, end_position_on_the_genomic_accession=122576907, orientation='minus', exon_count=5, OMIM='', no_hdr0=''),
  102641200 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102641200, CurrentID=0, Status='live', Symbol='LOC102641200', Aliases='', description='TBC1 domain family member 1-like', other_designations='', map_location='', chromosome='Un', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  11826 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11826, CurrentID=0, Status='live', Symbol='Aqp1', Aliases='CHIP28', description='aquaporin 1', other_designations='AQP-1|DER2|aquaporin-CHIP|delayed early response protein 2|growth factor-induced delayed early response protein|water channel protein for red blood cells and kidney proximal tubule', map_location='6 27.38 cM', chromosome='6', genomic_nucleotide_accession_version='NC_000072.6', start_position_on_the_genomic_accession=55336299, end_position_on_the_genomic_accession=55348555, orientation='plus', exon_count=4, OMIM='', no_hdr0=''),
  11827 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11827, CurrentID=0, Status='live', Symbol='Aqp2', Aliases='AQP-CD, WCH-CD, cph, jpk', description='aquaporin 2', other_designations='ADH water channel|AQP-2|aquaporin-CD|collecting duct water channel protein|water channel protein for renal collecting duct', map_location='15 56.13 cM', chromosome='15', genomic_nucleotide_accession_version='NC_000081.6', start_position_on_the_genomic_accession=99579056, end_position_on_the_genomic_accession=99584545, orientation='plus', exon_count=4, OMIM='', no_hdr0=''),
  11828 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11828, CurrentID=0, Status='live', Symbol='Aqp3', Aliases='AQP-2', description='aquaporin 3', other_designations='AQP-3|aquaglyceroporin-3', map_location='4 B1', chromosome='4', genomic_nucleotide_accession_version='NC_000070.6', start_position_on_the_genomic_accession=41092724, end_position_on_the_genomic_accession=41098183, orientation='minus', exon_count=6, OMIM='', no_hdr0=''),
  11829 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11829, CurrentID=0, Status='live', Symbol='Aqp4', Aliases='WCH4', description='aquaporin 4', other_designations='mercurial-insensitive water channel', map_location='18 8.74 cM', chromosome='18', genomic_nucleotide_accession_version='NC_000084.6', start_position_on_the_genomic_accession=15389394, end_position_on_the_genomic_accession=15410977, orientation='minus', exon_count=10, OMIM='', no_hdr0=''),
  11830 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11830, CurrentID=0, Status='live', Symbol='Aqp5', Aliases='', description='aquaporin 5', other_designations='AQP-5', map_location='15 56.13 cM', chromosome='15', genomic_nucleotide_accession_version='NC_000081.6', start_position_on_the_genomic_accession=99591028, end_position_on_the_genomic_accession=99594829, orientation='plus', exon_count=4, OMIM='', no_hdr0=''),
  11831 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11831, CurrentID=0, Status='live', Symbol='Aqp6', Aliases='AI790337', description='aquaporin 6', other_designations='AQP-6', map_location='15 56.13 cM', chromosome='15', genomic_nucleotide_accession_version='NC_000081.6', start_position_on_the_genomic_accession=99599053, end_position_on_the_genomic_accession=99605477, orientation='plus', exon_count=5, OMIM='', no_hdr0=''),
  11832 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11832, CurrentID=0, Status='live', Symbol='Aqp7', Aliases='AQP7L, AQPap', description='aquaporin 7', other_designations='AQP-7|aquaglyceroporin-7', map_location='4 B1', chromosome='4', genomic_nucleotide_accession_version='NC_000070.6', start_position_on_the_genomic_accession=41033074, end_position_on_the_genomic_accession=41048215, orientation='minus', exon_count=9, OMIM='', no_hdr0=''),
  11833 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11833, CurrentID=0, Status='live', Symbol='Aqp8', Aliases='AI255744, AQP-8', description='aquaporin 8', other_designations='', map_location='7 F3', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=123462294, end_position_on_the_genomic_accession=123468003, orientation='plus', exon_count=6, OMIM='', no_hdr0=''),
  11834 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11834, CurrentID=0, Status='live', Symbol='Aqr', Aliases='AW495846, mKIAA0560', description='aquarius', other_designations='', map_location='2 E5-F2', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=114101161, end_position_on_the_genomic_accession=114175339, orientation='minus', exon_count=36, OMIM='', no_hdr0=''),
  11835 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11835, CurrentID=0, Status='live', Symbol='Ar', Aliases='AW320017, Tfm', description='androgen receptor', other_designations='dihydrotestosterone receptor|nuclear receptor subfamily 3 group C member 4|testicular feminization', map_location='X 42.82 cM', chromosome='X', genomic_nucleotide_accession_version='NC_000086.7', start_position_on_the_genomic_accession=98149750, end_position_on_the_genomic_accession=98317147, orientation='plus', exon_count=8, OMIM='', no_hdr0=''),
  11836 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11836, CurrentID=0, Status='live', Symbol='Araf', Aliases='1200013E08Rik, A-Raf, AW4954441, Araf', description='Araf proto-oncogene, serine/threonine kinase', other_designations='A-Raf proto-oncogene serine/threonine-protein kinase|proto-oncogene A-Raf|raf-related oncogene|v-raf murine sarcoma 3611 viral oncogene homolog 1', map_location='X A2-A3.1', chromosome='X', genomic_nucleotide_accession_version='NC_000086.7', start_position_on_the_genomic_accession=20797787, end_position_on_the_genomic_accession=20860521, orientation='plus', exon_count=17, OMIM='', no_hdr0=''),
  11837 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11837, CurrentID=0, Status='live', Symbol='Rplp0', Aliases='36B4, Arbp, L10E', description='ribosomal protein, large, P0', other_designations='60S ribosomal protein L10E|acidic ribosomal phosphoprotein P0', map_location='5 F', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=115559467, end_position_on_the_genomic_accession=115563729, orientation='plus', exon_count=7, OMIM='', no_hdr0=''),
  11838 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11838, CurrentID=0, Status='live', Symbol='Arc', Aliases='Arc3.1, C86064, arg3.1, mArc', description='activity regulated cytoskeletal-associated protein', other_designations='ARC/ARG3.1|activity-regulated gene 3.1 protein homolog|arc', map_location='15 34.25 cM', chromosome='15', genomic_nucleotide_accession_version='NC_000081.6', start_position_on_the_genomic_accession=74669081, end_position_on_the_genomic_accession=74672570, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  11839 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11839, CurrentID=0, Status='live', Symbol='Areg', Aliases='AR, Mcub, Sdgf', description='amphiregulin', other_designations='schwannoma-derived growth factor', map_location='5 44.78 cM', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=91139615, end_position_on_the_genomic_accession=91148432, orientation='plus', exon_count=6, OMIM='', no_hdr0=''),
  11840 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11840, CurrentID=0, Status='live', Symbol='Arf1', Aliases='', description='ADP-ribosylation factor 1', other_designations='', map_location='11 B2', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=59211411, end_position_on_the_genomic_accession=59228267, orientation='minus', exon_count=7, OMIM='', no_hdr0=''),
  11841 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11841, CurrentID=0, Status='live', Symbol='Arf2', Aliases='', description='ADP-ribosylation factor 2', other_designations='', map_location='11 67.64 cM', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=103966718, end_position_on_the_genomic_accession=103985337, orientation='plus', exon_count=6, OMIM='', no_hdr0=''),
  11842 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11842, CurrentID=0, Status='live', Symbol='Arf3', Aliases='5430400P17Rik, AI854770', description='ADP-ribosylation factor 3', other_designations='', map_location='15 F2', chromosome='15', genomic_nucleotide_accession_version='NC_000081.6', start_position_on_the_genomic_accession=98737624, end_position_on_the_genomic_accession=98763118, orientation='minus', exon_count=5, OMIM='', no_hdr0=''),
  11843 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11843, CurrentID=0, Status='live', Symbol='Arf4', Aliases='AA407803', description='ADP-ribosylation factor 4', other_designations='', map_location='14 16.09 cM', chromosome='14', genomic_nucleotide_accession_version='NC_000080.6', start_position_on_the_genomic_accession=26638197, end_position_on_the_genomic_accession=26657258, orientation='plus', exon_count=6, OMIM='', no_hdr0=''),
  11844 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11844, CurrentID=0, Status='live', Symbol='Arf5', Aliases='', description='ADP-ribosylation factor 5', other_designations='', map_location='6 A3.3', chromosome='6', genomic_nucleotide_accession_version='NC_000072.6', start_position_on_the_genomic_accession=28423640, end_position_on_the_genomic_accession=28426499, orientation='plus', exon_count=6, OMIM='', no_hdr0=''),
  11845 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11845, CurrentID=0, Status='live', Symbol='Arf6', Aliases='AI788669, AW496366', description='ADP-ribosylation factor 6', other_designations='', map_location='12 C2', chromosome='12', genomic_nucleotide_accession_version='NC_000078.6', start_position_on_the_genomic_accession=69372150, end_position_on_the_genomic_accession=69375980, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  11846 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11846, CurrentID=0, Status='live', Symbol='Arg1', Aliases='AI, AI256583, Arg-1, PGIF', description='arginase, liver', other_designations='arginase 1, liver|arginase I|liver-type arginase|type I arginase', map_location='10 A4', chromosome='10', genomic_nucleotide_accession_version='NC_000076.6', start_position_on_the_genomic_accession=24915207, end_position_on_the_genomic_accession=24927470, orientation='minus', exon_count=8, OMIM='', no_hdr0=''),
  11847 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11847, CurrentID=0, Status='live', Symbol='Arg2', Aliases='AII, AU022422', description='arginase type II', other_designations='kidney-type arginase|non-hepatic arginase|type II arginase', map_location='12 C3', chromosome='12', genomic_nucleotide_accession_version='NC_000078.6', start_position_on_the_genomic_accession=79130788, end_position_on_the_genomic_accession=79156301, orientation='plus', exon_count=8, OMIM='', no_hdr0=''),
  11848 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11848, CurrentID=0, Status='live', Symbol='Rhoa', Aliases='Arha, Arha1, Arha2', description='ras homolog gene family, member A', other_designations='aplysia ras-related homolog A', map_location='9 F2', chromosome='9', genomic_nucleotide_accession_version='NC_000075.6', start_position_on_the_genomic_accession=108306205, end_position_on_the_genomic_accession=108337939, orientation='plus', exon_count=7, OMIM='', no_hdr0=''),
  100861879 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=100861879, CurrentID=0, Status='live', Symbol='Gm21292', Aliases='', description='predicted gene, 21292', other_designations='', map_location='Y', chromosome='Y', genomic_nucleotide_accession_version='NC_000087.7', start_position_on_the_genomic_accession=9131005, end_position_on_the_genomic_accession=9132555, orientation='minus', exon_count=1, OMIM='', no_hdr0=''),
  11852 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11852, CurrentID=0, Status='live', Symbol='Rhob', Aliases='AA017882, Arh6, Arhb', description='ras homolog gene family, member B', other_designations='aplysia ras-related homolog B|ras homolog B|ras homolog gene family, member AB', map_location='12 A1.1', chromosome='12', genomic_nucleotide_accession_version='NC_000078.6', start_position_on_the_genomic_accession=8497758, end_position_on_the_genomic_accession=8499985, orientation='minus', exon_count=1, OMIM='', no_hdr0=''),
  11853 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11853, CurrentID=0, Status='live', Symbol='Rhoc', Aliases='AI324259, Arh9, Arhc', description='ras homolog gene family, member C', other_designations='SIG-61|aplysia ras-related homolog 9 (RhoC)|ras homolog 9 (RhoC)|silica-induced gene 61 protein', map_location='3 F2.2', chromosome='3', genomic_nucleotide_accession_version='NC_000069.6', start_position_on_the_genomic_accession=104789034, end_position_on_the_genomic_accession=104794459, orientation='plus', exon_count=5, OMIM='', no_hdr0=''),
  11854 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11854, CurrentID=0, Status='live', Symbol='Rhod', Aliases='AI326383, Arhd, Rho, RhoHP1, RhoM', description='ras homolog gene family, member D', other_designations='aplysia ras-related homolog D|ras homolog D (RhoD)', map_location='19 A', chromosome='19', genomic_nucleotide_accession_version='NC_000085.6', start_position_on_the_genomic_accession=4425457, end_position_on_the_genomic_accession=4439432, orientation='minus', exon_count=5, OMIM='', no_hdr0=''),
  11855 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11855, CurrentID=0, Status='live', Symbol='Arhgap5', Aliases='p190-B, p190B', description='Rho GTPase activating protein 5', other_designations='rho-type GTPase-activating protein 5', map_location='12 22.16 cM', chromosome='12', genomic_nucleotide_accession_version='NC_000078.6', start_position_on_the_genomic_accession=52503771, end_position_on_the_genomic_accession=52571978, orientation='plus', exon_count=8, OMIM='', no_hdr0=''),
  11856 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11856, CurrentID=0, Status='live', Symbol='Arhgap6', Aliases='AI504284, RhoGAPX-1', description='Rho GTPase activating protein 6', other_designations='rho-type GTPase-activating protein 6|rho-type GTPase-activating protein RhoGAPX-1', map_location='X F5', chromosome='X', genomic_nucleotide_accession_version='NC_000086.7', start_position_on_the_genomic_accession=168795094, end_position_on_the_genomic_accession=169304440, orientation='plus', exon_count=16, OMIM='', no_hdr0=''),
  11857 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11857, CurrentID=0, Status='live', Symbol='Arhgdib', Aliases='D4, Gdid4, Ly-GDI', description='Rho, GDP dissociation inhibitor (GDI) beta', other_designations='rho GDI 2|rho-GDI beta', map_location='6 G1', chromosome='6', genomic_nucleotide_accession_version='NC_000072.6', start_position_on_the_genomic_accession=136923655, end_position_on_the_genomic_accession=136941899, orientation='minus', exon_count=9, OMIM='', no_hdr0=''),
  11858 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11858, CurrentID=0, Status='live', Symbol='Rnd2', Aliases='Arhn, Rohn', description='Rho family GTPase 2', other_designations='aplysia ras-related homolog N (RhoN)|ras homolog N (RhoN)|ras homolog gene family, member N|rho-related GTP-binding protein Rho7|rho7', map_location='11 C-D', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=101468338, end_position_on_the_genomic_accession=101471306, orientation='plus', exon_count=5, OMIM='', no_hdr0=''),
  11859 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11859, CurrentID=0, Status='live', Symbol='Phox2a', Aliases='Arix, Phox2, Pmx2, Pmx2a', description='paired-like homeobox 2a', other_designations='PHOX2A homeodomain protein|aristaless homeobox gene homolog|aristaless homeobox protein homolog|paired mesoderm homeobox 2a', map_location='7 54.66 cM', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=101818313, end_position_on_the_genomic_accession=101822726, orientation='plus', exon_count=3, OMIM='', no_hdr0=''),
  11861 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11861, CurrentID=0, Status='live', Symbol='Arl4a', Aliases='AI467555, Arl4', description='ADP-ribosylation factor-like 4A', other_designations='ADP-ribosylation factor-like 4|ADP-ribosylation-like 4', map_location='12 18.06 cM', chromosome='12', genomic_nucleotide_accession_version='NC_000078.6', start_position_on_the_genomic_accession=40033291, end_position_on_the_genomic_accession=40037987, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  102641238 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102641238, CurrentID=0, Status='live', Symbol='LOC102641238', Aliases='', description='uncharacterized LOC102641238', other_designations='', map_location='', chromosome='6', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  11863 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11863, CurrentID=0, Status='live', Symbol='Arnt', Aliases='D3Ertd557e, Drnt, ESTM42, Hif1b, W08714, bHLHe2, mKIAA4051', description='aryl hydrocarbon receptor nuclear translocator', other_designations='HIF-1-beta|HIF1-beta|dioxin receptor, nuclear translocator|hypoxia-inducible factor 1-beta', map_location='3 40.74 cM', chromosome='3', genomic_nucleotide_accession_version='NC_000069.6', start_position_on_the_genomic_accession=95434368, end_position_on_the_genomic_accession=95497240, orientation='plus', exon_count=23, OMIM='', no_hdr0=''),
  11864 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11864, CurrentID=0, Status='live', Symbol='Arnt2', Aliases='Hif-2b, bHLHe1, mKIAA0307', description='aryl hydrocarbon receptor nuclear translocator 2', other_designations='ARNT protein 2', map_location='7 48.35 cM', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=84246274, end_position_on_the_genomic_accession=84410171, orientation='minus', exon_count=22, OMIM='', no_hdr0=''),
  11865 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11865, CurrentID=0, Status='live', Symbol='Arntl', Aliases="Arnt3, BMAL1b, Bmal1, MOP3, bHLHe5, bmal1b'", description='aryl hydrocarbon receptor nuclear translocator-like', other_designations='brain and muscle ARNT-like 1', map_location='7 F2-F3', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=113178473, end_position_on_the_genomic_accession=113314126, orientation='plus', exon_count=24, OMIM='', no_hdr0=''),
  11867 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11867, CurrentID=0, Status='live', Symbol='Arpc1b', Aliases='41kDa, AA408064, AA408534, AA571392, AF007010, AW208418, L72, SOP2Hs, p41-ARC', description='actin related protein 2/3 complex, subunit 1B', other_designations='arp2/3 complex 41 kDa subunit', map_location='5 G2', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=145114256, end_position_on_the_genomic_accession=145128186, orientation='plus', exon_count=10, OMIM='', no_hdr0=''),
  102641244 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102641244, CurrentID=0, Status='live', Symbol='Gm27239', Aliases='', description='predicted gene 27239', other_designations='', map_location='18', chromosome='18', genomic_nucleotide_accession_version='NC_000084.6', start_position_on_the_genomic_accession=80986757, end_position_on_the_genomic_accession=80991150, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  11870 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11870, CurrentID=0, Status='live', Symbol='Art1', Aliases='ADPRT, ARTC1, Yac-1', description='ADP-ribosyltransferase 1', other_designations='ADP-ribosyltransferase C2 and C3 toxin-like 1|mono(ADP-ribosyl)transferase 1', map_location='7 54.71 cM', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=102101706, end_position_on_the_genomic_accession=102111758, orientation='plus', exon_count=6, OMIM='', no_hdr0=''),
  11871 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11871, CurrentID=0, Status='live', Symbol='Art2a-ps', Aliases='ARTC2, Art2a, Ly92a, Rt-6, Rt6, Rt6-1', description='ADP-ribosyltransferase 2a, pseudogene', other_designations='ADP-ribosyltransferase 2a pseudogene|ADP-ribosyltransferase C2 and C3 toxin-like 2|T-cell NAD(P)(+)--arginine ADP-ribosyltransferase 1|T-cell differentiation marker Rt6 homolog 1|T-cell mono(ADP-ribosyl)transferase 1|mono(ADP-ribosyl)transferase 2A', map_location='7 54.6 cM', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=101552453, end_position_on_the_genomic_accession=101560865, orientation='minus', exon_count=4, OMIM='', no_hdr0=''),
  11872 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11872, CurrentID=0, Status='live', Symbol='Art2b', Aliases='ART2.2, ARTC2, Art, Ly92b, Rt-6, Rt6, Rt6-2', description='ADP-ribosyltransferase 2b', other_designations='ADP-ribosyltransferase C2 and C3 toxin-like 2|T-cell NAD(P)(+)--arginine ADP-ribosyltransferase 2|T-cell differentiation marker Rt6 homolog 2|T-cell mono(ADP-ribosyl)transferase 2|mono(ADP-ribosyl)transferase 2B', map_location='7 54.61 cM', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=101575729, end_position_on_the_genomic_accession=101585583, orientation='minus', exon_count=4, OMIM='', no_hdr0=''),
  11875 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11875, CurrentID=0, Status='live', Symbol='Art5', Aliases='ARTC5, Yac-2', description='ADP-ribosyltransferase 5', other_designations='ADP-ribosyltransferase C2 and C3 toxin-like 5|NAD(P)(+)--arginine ADP-ribosyltransferase 5|mono(ADP-ribosyl)transferase 5', map_location='7 54.71 cM', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=102096879, end_position_on_the_genomic_accession=102100306, orientation='minus', exon_count=6, OMIM='', no_hdr0=''),
  11876 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11876, CurrentID=0, Status='live', Symbol='Artn', Aliases='neublastin', description='artemin', other_designations='', map_location='4 D1', chromosome='4', genomic_nucleotide_accession_version='NC_000070.6', start_position_on_the_genomic_accession=117926160, end_position_on_the_genomic_accession=117930791, orientation='minus', exon_count=5, OMIM='', no_hdr0=''),
  11877 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11877, CurrentID=0, Status='live', Symbol='Arvcf', Aliases='', description='armadillo repeat gene deleted in velo-cardio-facial syndrome', other_designations='', map_location='16 11.37 cM', chromosome='16', genomic_nucleotide_accession_version='NC_000082.6', start_position_on_the_genomic_accession=18348182, end_position_on_the_genomic_accession=18407076, orientation='plus', exon_count=21, OMIM='', no_hdr0=''),
  11878 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11878, CurrentID=0, Status='live', Symbol='Arx', Aliases='', description='aristaless related homeobox', other_designations='aristaless-related homeobox', map_location='X 41.05 cM', chromosome='X', genomic_nucleotide_accession_version='NC_000086.7', start_position_on_the_genomic_accession=93286450, end_position_on_the_genomic_accession=93298357, orientation='plus', exon_count=6, OMIM='', no_hdr0=''),
  667240 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=667240, CurrentID=0, Status='live', Symbol='Vmn1r121', Aliases='EG667240, Gm8533', description='vomeronasal 1 receptor 121', other_designations='vomernasal 1 receptor Vmn1r121', map_location='7 A3', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=21097569, end_position_on_the_genomic_accession=21098513, orientation='minus', exon_count=1, OMIM='', no_hdr0=''),
  11881 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11881, CurrentID=0, Status='live', Symbol='Arsb', Aliases='1110007C02Rik, AI480648, As-1, As-1r, As-1s, As-1t, As1, As1-r, As1-s, As1-t, Asr-1, Ast-1', description='arylsulfatase B', other_designations='ASB|G4S|N-acetylgalactosamine-4-sulfatase|arylsulfatase B complex|arylsulfatase B regulation|arylsulfatase B structural|arylsulfatase B temporal regulation', map_location='13 47.88 cM', chromosome='13', genomic_nucleotide_accession_version='NC_000079.6', start_position_on_the_genomic_accession=93771023, end_position_on_the_genomic_accession=93943016, orientation='plus', exon_count=10, OMIM='', no_hdr0=''),
  102641258 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102641258, CurrentID=0, Status='live', Symbol='LOC102641258', Aliases='', description='apolipoprotein L3-like', other_designations='', map_location='', chromosome='15', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  11883 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11883, CurrentID=0, Status='live', Symbol='Arsa', Aliases='AS-A, ASA, AW212749, As-2, As2, TISP73', description='arylsulfatase A', other_designations='cerebroside-sulfatase', map_location='15 E', chromosome='15', genomic_nucleotide_accession_version='NC_000081.6', start_position_on_the_genomic_accession=89472476, end_position_on_the_genomic_accession=89477424, orientation='minus', exon_count=8, OMIM='', no_hdr0=''),
  11886 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11886, CurrentID=0, Status='live', Symbol='Asah1', Aliases='2310081N20Rik, AC, Asah', description='N-acylsphingosine amidohydrolase 1', other_designations='ACDase|acid CDase|acylsphingosine deacylase', map_location='8 A4', chromosome='8', genomic_nucleotide_accession_version='NC_000074.6', start_position_on_the_genomic_accession=41340643, end_position_on_the_genomic_accession=41374697, orientation='minus', exon_count=14, OMIM='', no_hdr0=''),
  102641264 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102641264, CurrentID=0, Status='live', Symbol='LOC102641264', Aliases='', description='muscle M-line assembly protein unc-89-like', other_designations='', map_location='', chromosome='2', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  11889 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11889, CurrentID=0, Status='live', Symbol='Asgr1', Aliases='ASGPR1, Asgr, Asgr-1, HL-1', description='asialoglycoprotein receptor 1', other_designations='ASGP-R 1|ASGPR 1|hepatic lectin 1', map_location='11 42.98 cM', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=70054124, end_position_on_the_genomic_accession=70057895, orientation='plus', exon_count=10, OMIM='', no_hdr0=''),
  667250 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=667250, CurrentID=0, Status='live', Symbol='Gm12657', Aliases='H3mm12, OTTMUSG00000007855', description='predicted gene 12657', other_designations='', map_location='4 C5', chromosome='4', genomic_nucleotide_accession_version='NC_000070.6', start_position_on_the_genomic_accession=94593650, end_position_on_the_genomic_accession=94600319, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  11891 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11891, CurrentID=0, Status='live', Symbol='Rab27a', Aliases='2210402C08Rik, 2410003M20Rik, 4933437C11Rik, ash', description='RAB27A, member RAS oncogene family', other_designations='ashen', map_location='9 40.08 cM', chromosome='9', genomic_nucleotide_accession_version='NC_000075.6', start_position_on_the_genomic_accession=73044810, end_position_on_the_genomic_accession=73097623, orientation='plus', exon_count=9, OMIM='', no_hdr0=''),
  667253 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=667253, CurrentID=0, Status='live', Symbol='Gm8539', Aliases='', description='predicted gene 8539', other_designations='', map_location='5', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=21613795, end_position_on_the_genomic_accession=21614551, orientation='minus', exon_count=1, OMIM='', no_hdr0=''),
  667256 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=667256, CurrentID=0, Status='live', Symbol='4921511M17Rik', Aliases='', description='RIKEN cDNA 4921511M17 gene', other_designations='', map_location='X F3', chromosome='X', genomic_nucleotide_accession_version='NC_000086.7', start_position_on_the_genomic_accession=154022780, end_position_on_the_genomic_accession=154033830, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  11898 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11898, CurrentID=0, Status='live', Symbol='Ass1', Aliases='AA408052, ASS, Ass-1, fold', description='argininosuccinate synthetase 1', other_designations='arginosuccinate synthetase 1|citrulline--aspartate ligase', map_location='2 21.81 cM', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=31470270, end_position_on_the_genomic_accession=31520670, orientation='plus', exon_count=16, OMIM='', no_hdr0=''),
  11899 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11899, CurrentID=0, Status='live', Symbol='Astn1', Aliases='Astn, GC14, mKIAA0289', description='astrotactin 1', other_designations='neuronal migration protein GC14', map_location='1 H1', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=158362102, end_position_on_the_genomic_accession=158691786, orientation='plus', exon_count=25, OMIM='', no_hdr0=''),
  102641276 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102641276, CurrentID=0, Status='live', Symbol='LOC102641276', Aliases='', description='guanine nucleotide-binding protein G(I)/G(S)/G(O) subunit gamma-5', other_designations='', map_location='', chromosome='6', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  667262 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=667262, CurrentID=0, Status='live', Symbol='Vmn1r117', Aliases='EG667262, Gm8544', description='vomeronasal 1 receptor 117', other_designations='vomernasal 1 receptor Vmn1r117', map_location='7 A3', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=20883198, end_position_on_the_genomic_accession=20884121, orientation='minus', exon_count=1, OMIM='', no_hdr0=''),
  11905 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11905, CurrentID=0, Status='live', Symbol='Serpinc1', Aliases='AI114908, ATIII, At-3, At3', description='serine (or cysteine) peptidase inhibitor, clade C (antithrombin), member 1', other_designations='anti-thrombin 3|antithrombin|serine (or cysteine) proteinase inhibitor, clade C (antithrombin), member 1|serpin C1|serpin peptidase inhibitor, clade C, member 1', map_location='1 69.75 cM', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=160978606, end_position_on_the_genomic_accession=161003015, orientation='plus', exon_count=9, OMIM='', no_hdr0=''),
  11906 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11906, CurrentID=0, Status='live', Symbol='Zfhx3', Aliases='A230102L03Rik, Atbf1, Sci, WBP9, mKIAA4228', description='zinc finger homeobox 3', other_designations='AT motif binding factor 1|AT motif-binding factor 1|AT-binding transcription factor 1|ZFH-3|alpha-fetoprotein enhancer-binding protein|zinc finger homeodomain protein 3', map_location='8 E1', chromosome='8', genomic_nucleotide_accession_version='NC_000074.6', start_position_on_the_genomic_accession=108704034, end_position_on_the_genomic_accession=108961636, orientation='plus', exon_count=12, OMIM='', no_hdr0=''),
  11907 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11907, CurrentID=0, Status='live', Symbol='Ate1', Aliases='AI225793, AW547406', description='arginyltransferase 1', other_designations='R-transferase 1|arginine-tRNA--protein transferase 1|arginine-tRNA-protein transferase 1', map_location='7 F3', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=130391493, end_position_on_the_genomic_accession=130520371, orientation='minus', exon_count=16, OMIM='', no_hdr0=''),
  11908 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11908, CurrentID=0, Status='live', Symbol='Atf1', Aliases='', description='activating transcription factor 1', other_designations='TCR-ATF1|cAMP-dependent transcription factor ATF-1', map_location='15 F3', chromosome='15', genomic_nucleotide_accession_version='NC_000081.6', start_position_on_the_genomic_accession=100227859, end_position_on_the_genomic_accession=100261248, orientation='plus', exon_count=9, OMIM='', no_hdr0=''),
  11909 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11909, CurrentID=0, Status='live', Symbol='Atf2', Aliases='Atf-2, CRE-BP, Creb2, D130078H02Rik, D18875, Tg(Gzma-Klra1)7Wum, mXBP', description='activating transcription factor 2', other_designations='cAMP response element-binding protein CRE-BP1|cAMP-dependent transcription factor ATF-2', map_location='2 C3', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=73816509, end_position_on_the_genomic_accession=73892639, orientation='minus', exon_count=19, OMIM='', no_hdr0=''),
  11910 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11910, CurrentID=0, Status='live', Symbol='Atf3', Aliases='LRG-21', description='activating transcription factor 3', other_designations='cAMP-dependent transcription factor ATF-3|transcription factor LRG-21', map_location='1 96.28 cM', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=191170296, end_position_on_the_genomic_accession=191183333, orientation='minus', exon_count=4, OMIM='', no_hdr0=''),
  11911 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11911, CurrentID=0, Status='live', Symbol='Atf4', Aliases='Atf-4, C/ATF, CREB2, TAXREB67', description='activating transcription factor 4', other_designations='c/EBP-related ATF|cAMP-dependent transcription factor ATF-4|tax-responsive enhancer element-binding protein 67 homolog|taxREB67 homolog', map_location='15 37.85 cM', chromosome='15', genomic_nucleotide_accession_version='NC_000081.6', start_position_on_the_genomic_accession=80255184, end_position_on_the_genomic_accession=80257545, orientation='plus', exon_count=4, OMIM='', no_hdr0=''),
  667273 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=667273, CurrentID=0, Status='live', Symbol='Vmn1r115', Aliases='EG667273, Gm8549', description='vomeronasal 1 receptor 115', other_designations='vomernasal 1 receptor Vmn1r115', map_location='7 A3', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=20844098, end_position_on_the_genomic_accession=20844985, orientation='minus', exon_count=1, OMIM='', no_hdr0=''),
  667277 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=667277, CurrentID=0, Status='live', Symbol='C1rb', Aliases='Gm8551, mC1rB', description='complement component 1, r subcomponent B', other_designations='complement component 1 subcomponent r-B|complement component 1, r-B subcomponent|complement component C1rb', map_location='6', chromosome='6', genomic_nucleotide_accession_version='NC_000072.6', start_position_on_the_genomic_accession=124570430, end_position_on_the_genomic_accession=124581044, orientation='plus', exon_count=11, OMIM='', no_hdr0=''),
  667278 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=667278, CurrentID=0, Status='live', Symbol='Mup-ps16', Aliases='EG667278, Gm8552', description='major urinary protein, pseudogene 16', other_designations='', map_location='4 B3', chromosome='4', genomic_nucleotide_accession_version='NC_000070.6', start_position_on_the_genomic_accession=61783061, end_position_on_the_genomic_accession=61801283, orientation='plus', exon_count=10, OMIM='', no_hdr0=''),
  102641295 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102641295, CurrentID=0, Status='live', Symbol='LOC102641295', Aliases='', description='Y-linked testis-specific protein 1-like', other_designations='', map_location='', chromosome='Un', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  11920 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11920, CurrentID=0, Status='live', Symbol='Atm', Aliases='AI256621, C030026E19Rik', description='ataxia telangiectasia mutated', other_designations='A-T mutated homolog|ataxia telangiectasia gene mutated in human beings|ataxia telangiectasia mutated homolog', map_location='9 C-D', chromosome='9', genomic_nucleotide_accession_version='NC_000075.6', start_position_on_the_genomic_accession=53437122, end_position_on_the_genomic_accession=53536816, orientation='minus', exon_count=64, OMIM='', no_hdr0=''),
  667281 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=667281, CurrentID=0, Status='live', Symbol='H60b', Aliases='EG667281', description='histocompatibility 60b', other_designations='', map_location='10 A3', chromosome='10', genomic_nucleotide_accession_version='NC_000076.6', start_position_on_the_genomic_accession=22273474, end_position_on_the_genomic_accession=22289144, orientation='plus', exon_count=7, OMIM='', no_hdr0=''),
  11922 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11922, CurrentID=0, Status='live', Symbol='Neurod6', Aliases='Atoh2, Math-2, Math2, Nex, Nex1m, bHLHa2', description='neurogenic differentiation 6', other_designations='atonal homolog 2|helix-loop-helix protein mATH-2|protein NEX-1|protein atonal homolog 2', map_location='6 27.53 cM', chromosome='6', genomic_nucleotide_accession_version='NC_000072.6', start_position_on_the_genomic_accession=55677818, end_position_on_the_genomic_accession=55681263, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  11923 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11923, CurrentID=0, Status='live', Symbol='Neurod4', Aliases='AI846749, ATH-3, Atoh3, MATH-3, Math3, bHLHa4', description='neurogenic differentiation 4', other_designations='atonal homolog 3|helix-loop-helix protein mATH-3|protein atonal homolog 3', map_location='10 77.81 cM', chromosome='10', genomic_nucleotide_accession_version='NC_000076.6', start_position_on_the_genomic_accession=130268152, end_position_on_the_genomic_accession=130280240, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  11924 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11924, CurrentID=0, Status='live', Symbol='Neurog2', Aliases='Atoh4, Math4A, bHLHa8, ngn-2, ngn2', description='neurogenin 2', other_designations='atonal homolog 4|helix-loop-helix protein mATH-4A|protein atonal homolog 4', map_location='3 H1', chromosome='3', genomic_nucleotide_accession_version='NC_000069.6', start_position_on_the_genomic_accession=127633145, end_position_on_the_genomic_accession=127635631, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  11925 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11925, CurrentID=0, Status='live', Symbol='Neurog3', Aliases='Atoh5, Math4B, bHLHa7, ngn3', description='neurogenin 3', other_designations='NGN-3|Neurogenin 3 (Atonal protein homolog 5) (Helix-loop-helix protein mATH-4B) (MATH4B)|atonal homolog 5|helix-loop-helix protein mATH-4B|protein atonal homolog 5', map_location='10 B4', chromosome='10', genomic_nucleotide_accession_version='NC_000076.6', start_position_on_the_genomic_accession=62133090, end_position_on_the_genomic_accession=62134763, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  11927 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11927, CurrentID=0, Status='live', Symbol='Atox1', Aliases='AI256639, Atx1', description='antioxidant 1 copper chaperone', other_designations='ATX1 (antioxidant protein 1) homolog 1|metal transport protein ATX1', map_location='11 33.07 cM', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=55446643, end_position_on_the_genomic_accession=55461138, orientation='minus', exon_count=4, OMIM='', no_hdr0=''),
  11928 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11928, CurrentID=0, Status='live', Symbol='Atp1a1', Aliases='Atpa-1, BC010319', description='ATPase, Na+/K+ transporting, alpha 1 polypeptide', other_designations='Na(+)/K(+) ATPase alpha-1 subunit|sodium pump subunit alpha-1', map_location='3 F3', chromosome='3', genomic_nucleotide_accession_version='NC_000069.6', start_position_on_the_genomic_accession=101576219, end_position_on_the_genomic_accession=101604707, orientation='minus', exon_count=23, OMIM='', no_hdr0=''),
  11931 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11931, CurrentID=0, Status='live', Symbol='Atp1b1', Aliases='Atp4b, Atpb, Atpb-1, NKbeta1', description='ATPase, Na+/K+ transporting, beta 1 polypeptide', other_designations='sodium/potassium ATPase beta subunit|sodium/potassium-dependent ATPase subunit beta-1', map_location='1 71.75 cM', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=164437099, end_position_on_the_genomic_accession=164458355, orientation='minus', exon_count=6, OMIM='', no_hdr0=''),
  11932 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11932, CurrentID=0, Status='live', Symbol='Atp1b2', Aliases='Amog, Atpb-2', description='ATPase, Na+/K+ transporting, beta 2 polypeptide', other_designations='adhesion molecule in glia|glial cell adhesion molecule|snoRNA MBI-85|sodium/potassium-dependent ATPase subunit beta-2', map_location='11 42.86 cM', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=69599750, end_position_on_the_genomic_accession=69605960, orientation='minus', exon_count=7, OMIM='', no_hdr0=''),
  11933 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11933, CurrentID=0, Status='live', Symbol='Atp1b3', Aliases='AA409958, AI664000, AW212096', description='ATPase, Na+/K+ transporting, beta 3 polypeptide', other_designations='ATPB-3|ATPase, Na+/K+ beta 3 polypeptide|Na K-ATPase beta-3 subunit|sodium/potassium-dependent ATPase subunit beta-3', map_location='9 50.31 cM', chromosome='9', genomic_nucleotide_accession_version='NC_000075.6', start_position_on_the_genomic_accession=96332662, end_position_on_the_genomic_accession=96364905, orientation='minus', exon_count=8, OMIM='', no_hdr0=''),
  102641310 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102641310, CurrentID=0, Status='live', Symbol='LOC102641310', Aliases='', description='zinc finger protein 120-like', other_designations='', map_location='', chromosome='Un', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  11936 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11936, CurrentID=0, Status='live', Symbol='Fxyd2', Aliases='Atp1g1', description='FXYD domain-containing ion transport regulator 2', other_designations='ATPase, Na+/K+ transporting, gamma 1 polypeptide|Na(+)/K(+) ATPase subunit gamma|sodium pump gamma chain|sodium/potassium-transporting ATPase gamma chain', map_location='9 B', chromosome='9', genomic_nucleotide_accession_version='NC_000075.6', start_position_on_the_genomic_accession=45399709, end_position_on_the_genomic_accession=45410278, orientation='plus', exon_count=8, OMIM='', no_hdr0=''),
  11937 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11937, CurrentID=0, Status='live', Symbol='Atp2a1', Aliases='SERCA1', description='ATPase, Ca++ transporting, cardiac muscle, fast twitch 1', other_designations='SR Ca(2+)-ATPase 1|calcium pump 1|calcium-transporting ATPase sarcoplasmic reticulum type, fast twitch skeletal muscle isoform|endoplasmic reticulum class 1/2 Ca(2+) ATPase', map_location='7 69.04 cM', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=126445860, end_position_on_the_genomic_accession=126463103, orientation='minus', exon_count=23, OMIM='', no_hdr0=''),
  11938 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11938, CurrentID=0, Status='live', Symbol='Atp2a2', Aliases='9530097L16Rik, D5Wsu150e, SERCA2, SERCA2B, Serca2a, mKIAA4195', description='ATPase, Ca++ transporting, cardiac muscle, slow twitch 2', other_designations='SERCA2a isoform|SR Ca(2+)-ATPase 2|calcium pump 2|calcium-transporting ATPase sarcoplasmic reticulum type, slow twitch skeletal muscle isoform|endoplasmic reticulum class 1/2 Ca(2+) ATPase|sarco/endoplasmic reticulum Ca2+-ATPase 2', map_location='5 F', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=122453513, end_position_on_the_genomic_accession=122502225, orientation='minus', exon_count=21, OMIM='', no_hdr0=''),
  102641315 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102641315, CurrentID=0, Status='live', Symbol='LOC102641315', Aliases='', description='NADH dehydrogenase [ubiquinone] iron-sulfur protein 5', other_designations='', map_location='', chromosome='7', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  11941 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11941, CurrentID=0, Status='live', Symbol='Atp2b2', Aliases='D6Abb2e, Gena300, PMCA2, Tmy, dfw, jog, wms, wri', description='ATPase, Ca++ transporting, plasma membrane 2', other_designations='deaf waddler|plasma membrane calcium ATPase|plasma membrane calcium pump|wriggle', map_location='6 52.85 cM', chromosome='6', genomic_nucleotide_accession_version='NC_000072.6', start_position_on_the_genomic_accession=113743842, end_position_on_the_genomic_accession=114042613, orientation='minus', exon_count=30, OMIM='', no_hdr0=''),
  102641318 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102641318, CurrentID=0, Status='live', Symbol='LOC102641318', Aliases='', description='kalirin-like', other_designations='', map_location='', chromosome='Un', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  102641319 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102641319, CurrentID=0, Status='live', Symbol='LOC102641319', Aliases='', description='disks large homolog 5-like', other_designations='', map_location='', chromosome='14', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  11944 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11944, CurrentID=0, Status='live', Symbol='Atp4a', Aliases='', description='ATPase, H+/K+ exchanging, gastric, alpha polypeptide', other_designations='ATPase, H+/K+ exchanging, alpha polypeptide|ATPase, H+/K+ transporting, alpha polypeptide|H+/K+-ATPase alpha|H+K+-transporting alpha 1|gastric H(+)/K(+) ATPase subunit alpha|proton pump', map_location='7 19.2 cM', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=30712209, end_position_on_the_genomic_accession=30725534, orientation='plus', exon_count=22, OMIM='', no_hdr0=''),
  11945 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11945, CurrentID=0, Status='live', Symbol='Atp4b', Aliases='AV080843', description='ATPase, H+/K+ exchanging, beta polypeptide', other_designations='ATPase, H+/K+ transporting, beta polypeptide, gastric specific|H+,K+-ATPase|H+/K+-ATPase beta|H,K-ATPase-Beta|gastric H(+)/K(+) ATPase subunit beta|proton pump beta chain', map_location='8 5.89 cM', chromosome='8', genomic_nucleotide_accession_version='NC_000074.6', start_position_on_the_genomic_accession=13386209, end_position_on_the_genomic_accession=13396778, orientation='minus', exon_count=7, OMIM='', no_hdr0=''),
  11946 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11946, CurrentID=0, Status='live', Symbol='Atp5a1', Aliases='AI035633, AL022851, AL023067, Atpm, D18Ertd206e, Mom2', description='ATP synthase, H+ transporting, mitochondrial F1 complex, alpha subunit 1', other_designations='ATP synthase, H+ transporting, mitochondrial F1 complex, alpha subunit|modifier of Min 2', map_location='18 52.38 cM', chromosome='18', genomic_nucleotide_accession_version='NC_000084.6', start_position_on_the_genomic_accession=77773768, end_position_on_the_genomic_accession=77782869, orientation='plus', exon_count=12, OMIM='', no_hdr0=''),
  11947 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11947, CurrentID=0, Status='live', Symbol='Atp5b', Aliases='', description='ATP synthase, H+ transporting mitochondrial F1 complex, beta subunit', other_designations='ATP synthase, H+ transporting mitochondrial F1 complex, alpha subunit|mitochondrial ATP synthase, H+ transporting F1 complex beta subunit', map_location='10 D3', chromosome='10', genomic_nucleotide_accession_version='NC_000076.6', start_position_on_the_genomic_accession=128083307, end_position_on_the_genomic_accession=128090388, orientation='plus', exon_count=10, OMIM='', no_hdr0=''),
  11949 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11949, CurrentID=0, Status='live', Symbol='Atp5c1', Aliases='1700094F02Rik', description='ATP synthase, H+ transporting, mitochondrial F1 complex, gamma polypeptide 1', other_designations='ATP synthase gamma-subunit gene encoding a mitochondrial protein|F-ATPase gamma subunit|F1 gamma', map_location='2 A1', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=10056030, end_position_on_the_genomic_accession=10080510, orientation='minus', exon_count=10, OMIM='', no_hdr0=''),
  11950 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11950, CurrentID=0, Status='live', Symbol='Atp5f1', Aliases='C76477', description='ATP synthase, H+ transporting, mitochondrial F0 complex, subunit B1', other_designations='ATP synthase subunit b, mitochondrial|ATPase subunit b', map_location='3 46.46 cM', chromosome='3', genomic_nucleotide_accession_version='NC_000069.6', start_position_on_the_genomic_accession=105942698, end_position_on_the_genomic_accession=105960248, orientation='minus', exon_count=10, OMIM='', no_hdr0=''),
  11951 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11951, CurrentID=0, Status='live', Symbol='Atp5g1', Aliases='', description='ATP synthase, H+ transporting, mitochondrial F0 complex, subunit C1 (subunit 9)', other_designations='ATP synthase lipid-binding protein, mitochondrial|ATP synthase proteolipid P1|ATP synthase, H+ transporting, mitochondrial F0 complex, subunit c (subunit 9)|ATPase protein 9|ATPase subunit c', map_location='11 D', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=96072793, end_position_on_the_genomic_accession=96075694, orientation='minus', exon_count=5, OMIM='', no_hdr0=''),
  102641328 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102641328, CurrentID=0, Status='live', Symbol='LOC102641328', Aliases='', description='60S ribosomal protein L11-like', other_designations='', map_location='', chromosome='14', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  67528 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=67528, CurrentID=0, Status='live', Symbol='Nudt7', Aliases='1300007B24Rik, 2210404C19Rik', description='nudix (nucleoside diphosphate linked moiety X)-type motif 7', other_designations='coenzyme A diphosphatase|nucleoside diphosphate-linked moiety X motif 7|nudix motif 7', map_location='8 E1', chromosome='8', genomic_nucleotide_accession_version='NC_000074.6', start_position_on_the_genomic_accession=114133574, end_position_on_the_genomic_accession=114154739, orientation='plus', exon_count=6, OMIM='', no_hdr0=''),
  102641332 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102641332, CurrentID=0, Status='live', Symbol='LOC102641332', Aliases='', description='GTP-binding nuclear protein Ran', other_designations='', map_location='', chromosome='9', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  11957 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11957, CurrentID=0, Status='live', Symbol='Atp5j', Aliases='CF6', description='ATP synthase, H+ transporting, mitochondrial F0 complex, subunit F', other_designations='ATP synthase coupling factor VI|ATPase subunit F6', map_location='16 C3.3', chromosome='16', genomic_nucleotide_accession_version='NC_000082.6', start_position_on_the_genomic_accession=84827866, end_position_on_the_genomic_accession=84835648, orientation='minus', exon_count=6, OMIM='', no_hdr0=''),
  11958 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11958, CurrentID=0, Status='live', Symbol='Atp5k', Aliases='2610008D24Rik, Atp5i, Lfm1', description='ATP synthase, H+ transporting, mitochondrial F1F0 complex, subunit E', other_designations='ATPase subunit e', map_location='5 53.11 cM', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=108433253, end_position_on_the_genomic_accession=108434378, orientation='minus', exon_count=4, OMIM='', no_hdr0=''),
  11964 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11964, CurrentID=0, Status='live', Symbol='Atp6v1a', Aliases='AI647066, Atp6a1, Atp6a21, VA68, VPP2, Atp6v1a', description='ATPase, H+ transporting, lysosomal V1 subunit A', other_designations='70-kDa subunit|ATPase, H+ transporting, V1 subunit A|ATPase, H+ transporting, V1 subunit A1|ATPase, H+ transporting, lysosomal (vacuolar proton pump), alpha 70 kDa|ATPase, H+ transporting, lysosomal 70kD, V1 subunit A|V-ATPase 69 kDa subunit|V-ATPase subunit A|lysosomal 70kDa|vacuolar proton pump subunit alpha', map_location='16 B4', chromosome='16', genomic_nucleotide_accession_version='NC_000082.6', start_position_on_the_genomic_accession=44085402, end_position_on_the_genomic_accession=44139700, orientation='minus', exon_count=16, OMIM='', no_hdr0=''),
  67530 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=67530, CurrentID=0, Status='live', Symbol='Uqcrb', Aliases='2210415M14Rik, QP-C, QPC, UQBC, UQBP, UQPC', description='ubiquinol-cytochrome c reductase binding protein', other_designations='complex III subunit 7|complex III subunit VII|ubiquinol-cytochrome c reductase complex 14 kDa protein', map_location='13 B3', chromosome='13', genomic_nucleotide_accession_version='NC_000079.6', start_position_on_the_genomic_accession=66900621, end_position_on_the_genomic_accession=66905350, orientation='minus', exon_count=4, OMIM='', no_hdr0=''),
  11966 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11966, CurrentID=0, Status='live', Symbol='Atp6v1b2', Aliases='AI194269, AI790362, Atp6b2, HO57, R74844', description='ATPase, H+ transporting, lysosomal V1 subunit B2', other_designations='ATPase, H+ transporting, V1 subunit B|ATPase, H+ transporting, lysosomal (vacuolar proton pump), beta 56/58 kDa|ATPase, H+ transporting, lysosomal 56/58kD, V1 subunit B|V-ATPase subunit B 2|endomembrane proton pump 58 kDa subunit|lysosomal 56/58kDa|vacuolar proton pump subunit B 2', map_location='8 B3.3', chromosome='8', genomic_nucleotide_accession_version='NC_000074.6', start_position_on_the_genomic_accession=69088736, end_position_on_the_genomic_accession=69113718, orientation='plus', exon_count=14, OMIM='', no_hdr0=''),
  102641347 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102641347, CurrentID=0, Status='live', Symbol='LOC102641347', Aliases='', description='NADH dehydrogenase [ubiquinone] 1 subunit C2', other_designations='', map_location='', chromosome='15', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  11972 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11972, CurrentID=0, Status='live', Symbol='Atp6v0d1', Aliases='AI267038, Ac39, Atp6d, P39, VATX, Vma6', description='ATPase, H+ transporting, lysosomal V0 subunit D1', other_designations='ATPase, H+ transporting, V0 subunit D|ATPase, H+ transporting, lysosomal (vacuolar proton pump), 42 kDa|ATPase, H+ transporting, lysosomal 38kDa, V0 subunit D|V-ATPase 40 kDa accessory protein|V-ATPase AC39 subunit|V-ATPase subunit d 1|lysosomal 38kDa|physophilin|vacuolar proton pump subunit d 1', map_location='8 D3', chromosome='8', genomic_nucleotide_accession_version='NC_000074.6', start_position_on_the_genomic_accession=105524470, end_position_on_the_genomic_accession=105566040, orientation='minus', exon_count=8, OMIM='', no_hdr0=''),
  11973 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11973, CurrentID=0, Status='live', Symbol='Atp6v1e1', Aliases='2410029D23Rik, Atp6e, Atp6e2, Atp6v1e, D6Ertd385e, E2, P31, Vma4', description='ATPase, H+ transporting, lysosomal V1 subunit E1', other_designations='ATPase, H+ transporting lysosomal (vacuolar proton pump), 32 kDa|ATPase, H+ transporting, V1 subunit E|ATPase, H+ transporting, lysosomal 31kDa, V1 subunit E|H(+)-ATPase E-like protein|H+ ATPase subunit E|V-ATPase 31 kDa subunit|V-ATPase subunit E 1|VATPase, H+ transporting, lysosomal V1 subunit E1|lysosomal 31kDa|vacuolar proton pump subunit E 1', map_location='6 57.01 cM', chromosome='6', genomic_nucleotide_accession_version='NC_000072.6', start_position_on_the_genomic_accession=120795244, end_position_on_the_genomic_accession=120822685, orientation='minus', exon_count=9, OMIM='', no_hdr0=''),
  11974 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11974, CurrentID=0, Status='live', Symbol='Atp6v0e', Aliases='Atp6k1, M9.2, Atp6v0e', description='ATPase, H+ transporting, lysosomal V0 subunit E', other_designations='ATPase, H+ transporting lysosomal (vacuolar proton pump), 9.2 kDa|ATPase, H+ transporting, V0 subunit e|ATPase, H+ transporting, lysosomal 9kD V0 subunit E|V-ATPase subunit e 1|lysosomal 9kDa|vacuolar proton pump subunit e 1', map_location='17 A3.3', chromosome='17', genomic_nucleotide_accession_version='NC_000083.6', start_position_on_the_genomic_accession=26676369, end_position_on_the_genomic_accession=26699647, orientation='plus', exon_count=5, OMIM='', no_hdr0=''),
  11975 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11975, CurrentID=0, Status='live', Symbol='Atp6v0a1', Aliases='AA959968, ATP6a1, Atp6n1, Atp6n1a, Atpv0a1, Vpp-1, Vpp1', description='ATPase, H+ transporting, lysosomal V0 subunit A1', other_designations='ATPase, H+ transporting, lysosomal (vacuolar proton pump) noncatalytic accessory protein 1 (110/160 kDa)|ATPase, H+ transporting, lysosomal (vacuolar proton pump) noncatalytic accessory protein 1A (110/160 kDa)|ATPase, H+ transporting, lysosomal V0 subunit a|V-ATPase 116 kDa|V-ATPase a1|V-type proton ATPase 116 kDa subunit a|clathrin-coated vesicle/synaptic vesicle proton pump 116 kDa subunit|vacuolar adenosine triphosphatase subunit Ac116|vacuolar proton pump subunit 1|vacuolar proton translocating ATPase 116 kDa subunit a', map_location='11 64.04 cM', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=101009447, end_position_on_the_genomic_accession=101063719, orientation='plus', exon_count=23, OMIM='', no_hdr0=''),
  11977 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11977, CurrentID=0, Status='live', Symbol='Atp7a', Aliases='MNK', description='ATPase, Cu++ transporting, alpha polypeptide', other_designations='Menkes protein|copper pump 1|menkes disease-associated protein homolog', map_location='X 47.36 cM', chromosome='X', genomic_nucleotide_accession_version='NC_000086.7', start_position_on_the_genomic_accession=106027224, end_position_on_the_genomic_accession=106128160, orientation='plus', exon_count=23, OMIM='', no_hdr0=''),
  11979 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11979, CurrentID=0, Status='live', Symbol='Atp7b', Aliases='Atp7a, WND, tx', description='ATPase, Cu++ transporting, beta polypeptide', other_designations='Wilson protein|copper pump 2|toxic milk|wilson disease-associated protein homolog', map_location='8 10.78 cM', chromosome='8', genomic_nucleotide_accession_version='NC_000074.6', start_position_on_the_genomic_accession=21992783, end_position_on_the_genomic_accession=22060074, orientation='minus', exon_count=24, OMIM='', no_hdr0=''),
  11980 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11980, CurrentID=0, Status='live', Symbol='Atp8a1', Aliases='AI481521, AI853962, APLT, AW743152, AW822227, Atp3a2, B230107D19Rik, ClassI', description='ATPase, aminophospholipid transporter (APLT), class I, type 8A, member 1', other_designations='ATPase 8A1, aminophospholipid transporter (APLT), class I|ATPase 8A1, p type|ATPase class I type 8A member 1|P4-ATPase flippase complex alpha subunit ATP8A1|chromaffin granule ATPase II|probable phospholipid-transporting ATPase IA', map_location='5 C3.1', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=67618139, end_position_on_the_genomic_accession=67847487, orientation='minus', exon_count=42, OMIM='', no_hdr0=''),
  11981 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11981, CurrentID=0, Status='live', Symbol='Atp9a', Aliases='IIa', description='ATPase, class II, type 9A', other_designations='ATPase 9A, class II|ATPase 9A, p type|ATPase, class 2', map_location='2 H3', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=168634438, end_position_on_the_genomic_accession=168742136, orientation='minus', exon_count=33, OMIM='', no_hdr0=''),
  11982 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11982, CurrentID=0, Status='live', Symbol='Atp10a', Aliases='Atp10c, pfatp', description='ATPase, class V, type 10A', other_designations='ATPase 10A, class V|ATPase, class 5|P-locus fat-associated ATPase|P4-ATPase flippase complex alpha subunit ATP10A', map_location='7 C', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=58656143, end_position_on_the_genomic_accession=58830035, orientation='plus', exon_count=23, OMIM='', no_hdr0=''),
  67533 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=67533, CurrentID=0, Status='live', Symbol='Ppfibp1', Aliases='4632409B19Rik, AW214454, AW261454', description='PTPRF interacting protein, binding protein 1 (liprin beta 1)', other_designations='PTPRF-interacting protein-binding protein 1|protein tyrosine phosphatase receptor type f polypeptide-interacting protein-binding protein 1', map_location='6 G3', chromosome='6', genomic_nucleotide_accession_version='NC_000072.6', start_position_on_the_genomic_accession=146888080, end_position_on_the_genomic_accession=147032025, orientation='plus', exon_count=34, OMIM='', no_hdr0=''),
  11984 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11984, CurrentID=0, Status='live', Symbol='Atp6v0c', Aliases='Atp6c, Atp6c2, Atp6l, Atpl, Atpl-rs1, PL16, VATL, Vma3', description='ATPase, H+ transporting, lysosomal V0 subunit C', other_designations='ATPase, H+ transporting, lysosomal (vacuolar proton pump) 16 kDa|ATPase, H+ transporting, lysosomal 16kD, V0 subunit C|ATPase, H+ transporting, lysosomal 2|H(+)-ATPase (mvp)|V-ATPase 16 kDa proteolipid subunit|vacuolar proton pump 16 kDa proteolipid subunit', map_location='17 A3.3', chromosome='17', genomic_nucleotide_accession_version='NC_000083.6', start_position_on_the_genomic_accession=24163866, end_position_on_the_genomic_accession=24169429, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  11987 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11987, CurrentID=0, Status='live', Symbol='Slc7a1', Aliases='4831426K01Rik, AI447493, Atrc-1, Atrc1, Cat1, Rec-1, Rev-1, mCAT-1', description='solute carrier family 7 (cationic amino acid transporter, y+ system), member 1', other_designations='CAT-1|ERR|cationic amino acid transporter 1|ecotropic retroviral leukemia receptor|ecotropic retrovirus receptor|solute carrier family 7 member 1|system Y+ basic amino acid transporter', map_location='5 88.48 cM', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=148327410, end_position_on_the_genomic_accession=148399904, orientation='minus', exon_count=15, OMIM='', no_hdr0=''),
  11988 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11988, CurrentID=0, Status='live', Symbol='Slc7a2', Aliases='20.5, AI158848, Atrc2, CAT-2, Cat2, Tea', description='solute carrier family 7 (cationic amino acid transporter, y+ system), member 2', other_designations='T-cell early activation protein|amino acid transporter, cationic 2 (low affinity)|cationic amino acid transporter 2A|cationic amino acid transporter 2B|low affinity cationic amino acid transporter 2|solute carrier family 7 member 2', map_location='8 23.89 cM', chromosome='8', genomic_nucleotide_accession_version='NC_000074.6', start_position_on_the_genomic_accession=40862367, end_position_on_the_genomic_accession=40922070, orientation='plus', exon_count=16, OMIM='', no_hdr0=''),
  11989 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11989, CurrentID=0, Status='live', Symbol='Slc7a3', Aliases='Atrc3, CAT-3, CAT3, SLC7A1, SLC7A2', description='solute carrier family 7 (cationic amino acid transporter, y+ system), member 3', other_designations='amino acid transporter, cationic 3|cationic amino acid transporter y+|solute carrier family 7 member 3', map_location='X C3', chromosome='X', genomic_nucleotide_accession_version='NC_000086.7', start_position_on_the_genomic_accession=101079204, end_position_on_the_genomic_accession=101090452, orientation='minus', exon_count=15, OMIM='', no_hdr0=''),
  11990 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11990, CurrentID=0, Status='live', Symbol='Atrn', Aliases='AW558010, Mgca, mKIAA0548, mahogany, mg', description='attractin', other_designations='protein mahogany', map_location='2 63.26 cM', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=130906447, end_position_on_the_genomic_accession=131030333, orientation='plus', exon_count=30, OMIM='', no_hdr0=''),
  11991 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11991, CurrentID=0, Status='live', Symbol='Hnrnpd', Aliases='Auf1, Hnrpd', description='heterogeneous nuclear ribonucleoprotein D', other_designations='AU-rich element RNA-binding protein 1|hnRNP D0', map_location='5 E3', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=99955935, end_position_on_the_genomic_accession=99979015, orientation='minus', exon_count=10, OMIM='', no_hdr0=''),
  11992 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11992, CurrentID=0, Status='live', Symbol='Auh', Aliases='C77140, W91705', description='AU RNA binding protein/enoyl-coenzyme A hydratase', other_designations='AU-binding enoyl-CoA hydratase|AU-specific RNA-binding enoyl-CoA hydratase|muAUH', map_location='13 B1', chromosome='13', genomic_nucleotide_accession_version='NC_000079.6', start_position_on_the_genomic_accession=52835102, end_position_on_the_genomic_accession=52929706, orientation='minus', exon_count=13, OMIM='', no_hdr0=''),
  11993 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11993, CurrentID=0, Status='live', Symbol='Aup1', Aliases='AA589454', description='ancient ubiquitous protein 1', other_designations='', map_location='6 35.94 cM', chromosome='6', genomic_nucleotide_accession_version='NC_000072.6', start_position_on_the_genomic_accession=83054521, end_position_on_the_genomic_accession=83057682, orientation='plus', exon_count=12, OMIM='', no_hdr0=''),
  11994 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11994, CurrentID=0, Status='live', Symbol='Pcdh15', Aliases='BB078305, ENSMUSG00000046980, Gm9815, Ush1f, av, nmf19, roda', description='protocadherin 15', other_designations='Ames waltzer|protocadherin 15 CD2|protocadherin 15 CD3 isoform', map_location='10 37.43 cM', chromosome='10', genomic_nucleotide_accession_version='NC_000076.6', start_position_on_the_genomic_accession=73100028, end_position_on_the_genomic_accession=74649737, orientation='plus', exon_count=46, OMIM='', no_hdr0=''),
  11997 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11997, CurrentID=0, Status='live', Symbol='Akr1b7', Aliases='AR, Avdp, MVDP', description='aldo-keto reductase family 1, member B7', other_designations='aldehyde reductase|androgen regulated vas deferens protein|vas deferens androgen-dependent protein', map_location='6 14.95 cM', chromosome='6', genomic_nucleotide_accession_version='NC_000072.6', start_position_on_the_genomic_accession=34412362, end_position_on_the_genomic_accession=34423137, orientation='plus', exon_count=10, OMIM='', no_hdr0=''),
  11998 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11998, CurrentID=0, Status='live', Symbol='Avp', Aliases='Vp, Vsp', description='arginine vasopressin', other_designations='AVP-NPII|pre-pro-arginine-vasopressin-neurophysin II|prepro-AVP-NP II', map_location='2 63.24 cM', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=130580677, end_position_on_the_genomic_accession=130582541, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  12000 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12000, CurrentID=0, Status='live', Symbol='Avpr2', Aliases='ADHR, DI1, DIR, ND1, V2R, VPV2R', description='arginine vasopressin receptor 2', other_designations='antidiuretic hormone receptor|nephrogenic diabetes insipidus|renal-type arginine vasopressin receptor', map_location='X 37.46 cM', chromosome='X', genomic_nucleotide_accession_version='NC_000086.7', start_position_on_the_genomic_accession=73890591, end_position_on_the_genomic_accession=73894428, orientation='plus', exon_count=4, OMIM='', no_hdr0=''),
  102641378 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102641378, CurrentID=0, Status='live', Symbol='LOC102641378', Aliases='', description='disks large homolog 5-like', other_designations='', map_location='', chromosome='14', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  12005 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12005, CurrentID=0, Status='live', Symbol='Axin1', Aliases='AI316800, Axin, Fu, Kb, Ki, fused, kinky, knobbly', description='axin 1', other_designations='axis inhibition protein 1|protein Fused', map_location='17 13.07 cM', chromosome='17', genomic_nucleotide_accession_version='NC_000083.6', start_position_on_the_genomic_accession=26130972, end_position_on_the_genomic_accession=26195811, orientation='plus', exon_count=14, OMIM='', no_hdr0=''),
  12006 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12006, CurrentID=0, Status='live', Symbol='Axin2', Aliases='Axi1, Axil, Conductin', description='axin2', other_designations='axin-like protein|axis inhibition protein 2', map_location='11 71.83 cM', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=108917828, end_position_on_the_genomic_accession=108950783, orientation='plus', exon_count=15, OMIM='', no_hdr0=''),
  100861905 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=100861905, CurrentID=0, Status='live', Symbol='Gm21316', Aliases='', description='predicted gene, 21316', other_designations='', map_location='Y', chromosome='Y', genomic_nucleotide_accession_version='NC_000087.7', start_position_on_the_genomic_accession=49842792, end_position_on_the_genomic_accession=49919837, orientation='minus', exon_count=4, OMIM='', no_hdr0=''),
  12009 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12009, CurrentID=0, Status='live', Symbol='Cep131', Aliases='AZ1, Azi, Azi1', description='centrosomal protein 131', other_designations='5-azacytidine induced gene 1|5-azacytidine-induced protein 1|pre-acrosome localization protein 1', map_location='11 E2', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=120064429, end_position_on_the_genomic_accession=120086859, orientation='minus', exon_count=27, OMIM='', no_hdr0=''),
  12010 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12010, CurrentID=0, Status='live', Symbol='B2m', Aliases='Ly-m11, beta2-m, beta2m', description='beta-2 microglobulin', other_designations='', map_location='2 F1-F3', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=122147687, end_position_on_the_genomic_accession=122153082, orientation='plus', exon_count=4, OMIM='', no_hdr0=''),
  12012 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12012, CurrentID=0, Status='live', Symbol='Baat', Aliases='AI118337, AI158864, BAT', description='bile acid-Coenzyme A: amino acid N-acyltransferase', other_designations='BACAT|bile acid-Coenzyme A dehydrogenase: amino acid n-acyltransferase|glycine N-choloyltransferase|long-chain fatty-acyl-CoA hydrolase|taurine N-acyltransferase', map_location='4 26.51 cM', chromosome='4', genomic_nucleotide_accession_version='NC_000070.6', start_position_on_the_genomic_accession=49489416, end_position_on_the_genomic_accession=49507912, orientation='minus', exon_count=4, OMIM='', no_hdr0=''),
  667373 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=667373, CurrentID=0, Status='live', Symbol='Ifit1bl1', Aliases='Gm14446, Ifit1c, OTTMUSG00000016644', description='interferon induced protein with tetratricpeptide repeats 1B like 1', other_designations='', map_location='19', chromosome='19', genomic_nucleotide_accession_version='NC_000085.6', start_position_on_the_genomic_accession=34592888, end_position_on_the_genomic_accession=34663000, orientation='minus', exon_count=4, OMIM='', no_hdr0=''),
  12014 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12014, CurrentID=0, Status='live', Symbol='Bach2', Aliases='E030004N02Rik', description='BTB and CNC homology, basic leucine zipper transcription factor 2', other_designations='BTB and CNC homolog 2|BTB and CNC homology 2|Transcription regulator protein BACH2 (BTB and CNC homolog 2)', map_location='4 A4', chromosome='4', genomic_nucleotide_accession_version='NC_000070.6', start_position_on_the_genomic_accession=32238574, end_position_on_the_genomic_accession=32586108, orientation='plus', exon_count=10, OMIM='', no_hdr0=''),
  12015 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12015, CurrentID=0, Status='live', Symbol='Bad', Aliases='AI325008, Bbc2', description='BCL2-associated agonist of cell death', other_designations='bcl-2-binding component 6|bcl-xL/Bcl-2-associated death promoter|bcl2 antagonist of cell death', map_location='19 A', chromosome='19', genomic_nucleotide_accession_version='NC_000085.6', start_position_on_the_genomic_accession=6941861, end_position_on_the_genomic_accession=6951905, orientation='plus', exon_count=5, OMIM='', no_hdr0=''),
  12017 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12017, CurrentID=0, Status='live', Symbol='Bag1', Aliases='BAG-1, Rap46', description='BCL2-associated athanogene 1', other_designations='Bcl-2-binding protein|bcl-2-associated athanogene 1', map_location='4 B1', chromosome='4', genomic_nucleotide_accession_version='NC_000070.6', start_position_on_the_genomic_accession=40936398, end_position_on_the_genomic_accession=40948294, orientation='minus', exon_count=7, OMIM='', no_hdr0=''),
  12018 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12018, CurrentID=0, Status='live', Symbol='Bak1', Aliases='Bak, N-BAK1, N-Bak', description='BCL2-antagonist/killer 1', other_designations='Bcl2 homologous antagonist/killer|apoptosis regulator BAK', map_location='17 B', chromosome='17', genomic_nucleotide_accession_version='NC_000083.6', start_position_on_the_genomic_accession=27019812, end_position_on_the_genomic_accession=27028839, orientation='minus', exon_count=7, OMIM='', no_hdr0=''),
  667379 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=667379, CurrentID=0, Status='live', Symbol='Spin2-ps2', Aliases='EG667379, Gm14757, OTTMUSG00000017900', description='spindlin family, member 2, pseudogene 2', other_designations='', map_location='X', chromosome='X', genomic_nucleotide_accession_version='NC_000086.7', start_position_on_the_genomic_accession=74677210, end_position_on_the_genomic_accession=74679384, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  12020 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12020, CurrentID=0, Status='live', Symbol='Nkx3-2', Aliases='Bapx1, NKX3.2, Nkx-3.2', description='NK3 homeobox 2', other_designations='bagpipe homeobox gene 1 homolog|bagpipe homeobox protein homolog 1|homeobox protein NK-3 homolog B|homeodomain protein Nkx-3.2', map_location='5 22.58 cM', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=41761483, end_position_on_the_genomic_accession=41764220, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  12021 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12021, CurrentID=0, Status='live', Symbol='Bard1', Aliases='ENSMUSG00000060893, ENSMUSG00000073653', description='BRCA1 associated RING domain 1', other_designations='BARD-1', map_location='1 C3', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=71027531, end_position_on_the_genomic_accession=71103233, orientation='minus', exon_count=11, OMIM='', no_hdr0=''),
  12022 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12022, CurrentID=0, Status='live', Symbol='Barx1', Aliases='', description='BarH-like homeobox 1', other_designations='', map_location='13 24.9 cM', chromosome='13', genomic_nucleotide_accession_version='NC_000079.6', start_position_on_the_genomic_accession=48663036, end_position_on_the_genomic_accession=48666507, orientation='plus', exon_count=4, OMIM='', no_hdr0=''),
  12023 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12023, CurrentID=0, Status='live', Symbol='Barx2', Aliases='2310006E12Rikb, Barx2', description='BarH-like homeobox 2', other_designations='homeodomain transcription factor BARX2', map_location='9 A4', chromosome='9', genomic_nucleotide_accession_version='NC_000075.6', start_position_on_the_genomic_accession=31846044, end_position_on_the_genomic_accession=31913285, orientation='minus', exon_count=4, OMIM='', no_hdr0=''),
  67540 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=67540, CurrentID=0, Status='live', Symbol='4931428A05Rik', Aliases='', description='RIKEN cDNA 4931428A05 gene', other_designations='', map_location='1', chromosome='1', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  667387 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=667387, CurrentID=0, Status='live', Symbol='Xlr4d-ps', Aliases='OTTMUSG00000017730, Xlr4d', description='X-linked lymphocyte-regulated 4D, pseudogene', other_designations='', map_location='X', chromosome='X', genomic_nucleotide_accession_version='NC_000086.7', start_position_on_the_genomic_accession=74730688, end_position_on_the_genomic_accession=74733950, orientation='plus', exon_count=3, OMIM='', no_hdr0=''),
  12028 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12028, CurrentID=0, Status='live', Symbol='Bax', Aliases='', description='BCL2-associated X protein', other_designations='', map_location='7 B5', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=45461695, end_position_on_the_genomic_accession=45466903, orientation='minus', exon_count=7, OMIM='', no_hdr0=''),
  12029 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12029, CurrentID=0, Status='live', Symbol='Bcl6b', Aliases='Bazf', description='B cell CLL/lymphoma 6, member B', other_designations='B-cell CLL/lymphoma 6, member B|BcL6-associated zinc finger protein', map_location='11 B4', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=70224127, end_position_on_the_genomic_accession=70229798, orientation='minus', exon_count=9, OMIM='', no_hdr0=''),
  67541 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=67541, CurrentID=0, Status='live', Symbol='4932416J16Rik', Aliases='', description='RIKEN cDNA 4932416J16 gene', other_designations='', map_location='4', chromosome='4', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  12032 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12032, CurrentID=0, Status='live', Symbol='Bcan', Aliases='Cspg7', description='brevican', other_designations='', map_location='3 38.78 cM', chromosome='3', genomic_nucleotide_accession_version='NC_000069.6', start_position_on_the_genomic_accession=87987531, end_position_on_the_genomic_accession=88000893, orientation='minus', exon_count=15, OMIM='', no_hdr0=''),
  12033 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12033, CurrentID=0, Status='live', Symbol='Bcap29', Aliases='AW208404, Bap29', description='B cell receptor associated protein 29', other_designations='BCR-associated protein 29', map_location='12 13.63 cM', chromosome='12', genomic_nucleotide_accession_version='NC_000078.6', start_position_on_the_genomic_accession=31595354, end_position_on_the_genomic_accession=31634658, orientation='minus', exon_count=8, OMIM='', no_hdr0=''),
  12034 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12034, CurrentID=0, Status='live', Symbol='Phb2', Aliases='AU044498, BAP, Bap37, Bcap37, REA', description='prohibitin 2', other_designations='B-cell receptor-associated protein 37|B-cell receptor-associated protein BAP37|phb2|repressor of estrogen receptor activity', map_location='6 59.17 cM', chromosome='6', genomic_nucleotide_accession_version='NC_000072.6', start_position_on_the_genomic_accession=124712289, end_position_on_the_genomic_accession=124716945, orientation='plus', exon_count=10, OMIM='', no_hdr0=''),
  12035 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12035, CurrentID=0, Status='live', Symbol='Bcat1', Aliases='BCATc, Eca39', description='branched chain aminotransferase 1, cytosolic', other_designations='BCAT(c)', map_location='6 77.27 cM', chromosome='6', genomic_nucleotide_accession_version='NC_000072.6', start_position_on_the_genomic_accession=144993835, end_position_on_the_genomic_accession=145076157, orientation='minus', exon_count=13, OMIM='', no_hdr0=''),
  12036 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12036, CurrentID=0, Status='live', Symbol='Bcat2', Aliases='Bcat-2, Eca40', description='branched chain aminotransferase 2, mitochondrial', other_designations='BCAT(m)', map_location='7 29.36 cM', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=45569855, end_position_on_the_genomic_accession=45589710, orientation='plus', exon_count=15, OMIM='', no_hdr0=''),
  12038 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12038, CurrentID=0, Status='live', Symbol='Bche', Aliases='C730038G20Rik', description='butyrylcholinesterase', other_designations='acylcholine acylhydrolase|butyrylcholine esterase|choline esterase II|pseudocholinesterase', map_location='3 E3', chromosome='3', genomic_nucleotide_accession_version='NC_000069.6', start_position_on_the_genomic_accession=73635805, end_position_on_the_genomic_accession=73708437, orientation='minus', exon_count=5, OMIM='', no_hdr0=''),
  12039 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12039, CurrentID=0, Status='live', Symbol='Bckdha', Aliases='', description='branched chain ketoacid dehydrogenase E1, alpha polypeptide', other_designations='BCKAD E1[a]|BCKDE1A|BCKDH E1-alpha|branched-chain alpha-keto acid dehydrogenase E1 component alpha chain', map_location='7 A3', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=25629852, end_position_on_the_genomic_accession=25658784, orientation='minus', exon_count=10, OMIM='', no_hdr0=''),
  12040 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12040, CurrentID=0, Status='live', Symbol='Bckdhb', Aliases='BCKDE1B, BCKDH E1-beta', description='branched chain ketoacid dehydrogenase E1, beta polypeptide', other_designations='branched-chain alpha-keto acid dehydrogenase E1 component beta chain', map_location='9 E2', chromosome='9', genomic_nucleotide_accession_version='NC_000075.6', start_position_on_the_genomic_accession=83925111, end_position_on_the_genomic_accession=84124240, orientation='plus', exon_count=13, OMIM='', no_hdr0=''),
  12041 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12041, CurrentID=0, Status='live', Symbol='Bckdk', Aliases='AI327402', description='branched chain ketoacid dehydrogenase kinase', other_designations='BCKD-kinase|BCKDHKIN|branched-chain alpha-ketoacid dehydrogenase kinase', map_location='7 F3', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=127904073, end_position_on_the_genomic_accession=127909664, orientation='plus', exon_count=12, OMIM='', no_hdr0=''),
  12042 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12042, CurrentID=0, Status='live', Symbol='Bcl10', Aliases='AI132454, BCL-10, C81403, CARMEN, CIPER, CLAP, ME10, cE10', description='B cell leukemia/lymphoma 10', other_designations='B-cell CLL/lymphoma 10|B-cell leukemia/lymphoma 10|CARD-containing molecule enhancing NF-kappa-B|CARD-like apoptotic protein|CED-3/ICH-1 prodomain homologous E10-like regulator|cellular homolog of vCARMEN|cellular-E10|mammalian CARD-containing adapter molecule E10', map_location='3 H3', chromosome='3', genomic_nucleotide_accession_version='NC_000069.6', start_position_on_the_genomic_accession=145924262, end_position_on_the_genomic_accession=145934366, orientation='plus', exon_count=3, OMIM='', no_hdr0=''),
  12043 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12043, CurrentID=0, Status='live', Symbol='Bcl2', Aliases='AW986256, Bcl-2, C430015F12Rik, D630044D05Rik, D830018M01Rik', description='B cell leukemia/lymphoma 2', other_designations='B-cell leukemia/lymphoma 2', map_location='1 49.76 cM', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=106538178, end_position_on_the_genomic_accession=106714290, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  12044 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12044, CurrentID=0, Status='live', Symbol='Bcl2a1a', Aliases='A1, BB218357, Bcl2a1, Bfl-1, Hbpa1', description='B cell leukemia/lymphoma 2 related protein A1a', other_designations='A1-A|B-cell leukemia/lymphoma 2 related protein A1a|hemopoietic-specific early response protein|protein BFL-1', map_location='9 47.24 cM', chromosome='9', genomic_nucleotide_accession_version='NC_000075.6', start_position_on_the_genomic_accession=88956920, end_position_on_the_genomic_accession=88962416, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  12045 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12045, CurrentID=0, Status='live', Symbol='Bcl2a1b', Aliases='A1-b', description='B cell leukemia/lymphoma 2 related protein A1b', other_designations='anti-apoptotic protein A1-b', map_location='9 E3.1', chromosome='9', genomic_nucleotide_accession_version='NC_000075.6', start_position_on_the_genomic_accession=89199273, end_position_on_the_genomic_accession=89207838, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  12046 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12046, CurrentID=0, Status='live', Symbol='Bcl2a1c', Aliases='A1-c', description='B cell leukemia/lymphoma 2 related protein A1c', other_designations='B-cell leukemia/lymphoma 2 related protein A1c|hematopoietic-specific early-response A1-c protein', map_location='9 F3', chromosome='9', genomic_nucleotide_accession_version='NC_000075.6', start_position_on_the_genomic_accession=114330135, end_position_on_the_genomic_accession=114330578, orientation='plus', exon_count=1, OMIM='', no_hdr0=''),
  12047 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12047, CurrentID=0, Status='live', Symbol='Bcl2a1d', Aliases='A1-d', description='B cell leukemia/lymphoma 2 related protein A1d', other_designations='B-cell leukemia/lymphoma 2 related protein A1d', map_location='9 E3.1', chromosome='9', genomic_nucleotide_accession_version='NC_000075.6', start_position_on_the_genomic_accession=88723288, end_position_on_the_genomic_accession=88731850, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  12048 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12048, CurrentID=0, Status='live', Symbol='Bcl2l1', Aliases='Bcl(X)L, Bcl-XL, Bcl2l, BclX, bcl-x, bcl2-L-1', description='BCL2-like 1', other_designations='B-cell leukemia/lymphoma x|anti-apoptosis regulatory protein|apoptosis regulator Bcl-X', map_location='2 H1', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=152758732, end_position_on_the_genomic_accession=152832581, orientation='minus', exon_count=9, OMIM='', no_hdr0=''),
  12049 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12049, CurrentID=0, Status='live', Symbol='Bcl2l10', Aliases='AA420380, AU023065, Boo, C85687, Diva', description='Bcl2-like 10', other_designations='anti-apoptotic protein Boo|apoptosis regulator Bcl-B|bcl-2 homolog Diva|bcl2-L-10', map_location='9 D', chromosome='9', genomic_nucleotide_accession_version='NC_000075.6', start_position_on_the_genomic_accession=75347758, end_position_on_the_genomic_accession=75351640, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  12050 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12050, CurrentID=0, Status='live', Symbol='Bcl2l2', Aliases='AW048834, Bcl-w, Gtrgal2, Gtrosa41, bclw, c98', description='BCL2-like 2', other_designations='apoptosis regulator Bcl-W|bcl2-L-2', map_location='14 27.98 cM', chromosome='14', genomic_nucleotide_accession_version='NC_000080.6', start_position_on_the_genomic_accession=54883366, end_position_on_the_genomic_accession=54889095, orientation='plus', exon_count=5, OMIM='', no_hdr0=''),
  12051 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12051, CurrentID=0, Status='live', Symbol='Bcl3', Aliases='AI528691, Bcl-3', description='B cell leukemia/lymphoma 3', other_designations='B-cell CLL/lymphoma 3|B-cell leukemia/lymphoma 3', map_location='7 9.95 cM', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=19808462, end_position_on_the_genomic_accession=19822811, orientation='minus', exon_count=9, OMIM='', no_hdr0=''),
  12053 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12053, CurrentID=0, Status='live', Symbol='Bcl6', Aliases='Bcl5', description='B cell leukemia/lymphoma 6', other_designations='B-cell leukemia/lymphoma 5|B-cell leukemia/lymphoma 6', map_location='16 15.26 cM', chromosome='16', genomic_nucleotide_accession_version='NC_000082.6', start_position_on_the_genomic_accession=23965052, end_position_on_the_genomic_accession=23988612, orientation='minus', exon_count=10, OMIM='', no_hdr0=''),
  12054 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12054, CurrentID=0, Status='live', Symbol='Bcl7b', Aliases='', description='B cell CLL/lymphoma 7B', other_designations='B-cell CLL/lymphoma 7B', map_location='5 G2', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=135168372, end_position_on_the_genomic_accession=135181852, orientation='plus', exon_count=6, OMIM='', no_hdr0=''),
  12055 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12055, CurrentID=0, Status='live', Symbol='Bcl7c', Aliases='C230096E12Rik', description='B cell CLL/lymphoma 7C', other_designations='B-cell CLL/lymphoma 7C|B-cell chronic lymphocytic leukemia/lymphoma 7C protein', map_location='7 F4', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=127661454, end_position_on_the_genomic_accession=127708780, orientation='minus', exon_count=7, OMIM='', no_hdr0=''),
  12057 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12057, CurrentID=0, Status='live', Symbol='Opn1sw', Aliases='AW551857, Bcp', description='opsin 1 (cone pigments), short-wave-sensitive (color blindness, tritan)', other_designations='BOP|S opsin|SWS opsin|UV cone pigment|blue cone opsin|blue cone photoreceptor pigment|blue cone pigment|blue opsin|blue visual pigment protein|blue-sensitive opsin|blue/UV opsin|short wavelength sensitive opsin|short wavelength-sensitive cone opsin', map_location='6 A3.3', chromosome='6', genomic_nucleotide_accession_version='NC_000072.6', start_position_on_the_genomic_accession=29376671, end_position_on_the_genomic_accession=29388729, orientation='minus', exon_count=7, OMIM='', no_hdr0=''),
  102641436 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102641436, CurrentID=0, Status='live', Symbol='LOC102641436', Aliases='', description='eukaryotic translation initiation factor 5', other_designations='', map_location='', chromosome='10', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  12061 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12061, CurrentID=0, Status='live', Symbol='Bdkrb1', Aliases='B1BKR, B1R, BKR1, BRADYB1, Bdkrb', description='bradykinin receptor, beta 1', other_designations='BK-1 receptor|kinin B1', map_location='12 F1', chromosome='12', genomic_nucleotide_accession_version='NC_000078.6', start_position_on_the_genomic_accession=105604091, end_position_on_the_genomic_accession=105605428, orientation='plus', exon_count=1, OMIM='', no_hdr0=''),
  12062 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12062, CurrentID=0, Status='live', Symbol='Bdkrb2', Aliases='B(2), B2, B2R, BK-2, BK2, BK2R, BKR2, BRB2', description='bradykinin receptor, beta 2', other_designations='BK-2 receptor|kinin B2', map_location='12 55.76 cM', chromosome='12', genomic_nucleotide_accession_version='NC_000078.6', start_position_on_the_genomic_accession=105563172, end_position_on_the_genomic_accession=105595244, orientation='plus', exon_count=5, OMIM='', no_hdr0=''),
  12064 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12064, CurrentID=0, Status='live', Symbol='Bdnf', Aliases='', description='brain derived neurotrophic factor', other_designations='', map_location='2 56.63 cM', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=109674700, end_position_on_the_genomic_accession=109727043, orientation='plus', exon_count=9, OMIM='', no_hdr0=''),
  12068 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12068, CurrentID=0, Status='live', Symbol='Bet1', Aliases='AW555236, Bet-1', description='Bet1 golgi vesicular membrane trafficking protein', other_designations='blocked early in transport 1 homolog|golgi vesicular membrane trafficking protein p18|golgi vesicular membrane-trafficking protein p18|mBET1', map_location='6 A1', chromosome='6', genomic_nucleotide_accession_version='NC_000072.6', start_position_on_the_genomic_accession=4076904, end_position_on_the_genomic_accession=4086995, orientation='minus', exon_count=5, OMIM='', no_hdr0=''),
  12069 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12069, CurrentID=0, Status='live', Symbol='Bex2', Aliases='AL024066, Bex1', description='brain expressed X-linked 2', other_designations='brain-expressed X-linked protein 2 homolog', map_location='X 57.37 cM', chromosome='X', genomic_nucleotide_accession_version='NC_000086.7', start_position_on_the_genomic_accession=136066565, end_position_on_the_genomic_accession=136068236, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  12070 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12070, CurrentID=0, Status='live', Symbol='Ngfrap1', Aliases='AL033356, Bex3, DXWsu67e, Gcap27, Nade', description='nerve growth factor receptor (TNFRSF16) associated protein 1', other_designations='brain expressed X-linked 3|brain-expressed X-linked protein 3 homolog|granule cell antiserum positive 27|nerve growth factor receptor-associated protein 1|p75NTR-associated Cell Death Executor', map_location='X 57.64 cM', chromosome='X', genomic_nucleotide_accession_version='NC_000086.7', start_position_on_the_genomic_accession=136270253, end_position_on_the_genomic_accession=136271978, orientation='plus', exon_count=3, OMIM='', no_hdr0=''),
  12075 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12075, CurrentID=0, Status='live', Symbol='Bfsp1', Aliases='CP95', description='beaded filament structural protein 1, in lens-CP94', other_designations='beaded filament structural protein in lens-CP94|lens fiber cell beaded-filament structural protein CP 95', map_location='2 G', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=143826528, end_position_on_the_genomic_accession=143915274, orientation='minus', exon_count=12, OMIM='', no_hdr0=''),
  67549 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=67549, CurrentID=0, Status='live', Symbol='Gpr89', Aliases='4933412D19Rika, SH120, Gpr89', description='G protein-coupled receptor 89', other_designations='protein GPR89', map_location='3 F2', chromosome='3', genomic_nucleotide_accession_version='NC_000069.6', start_position_on_the_genomic_accession=96871066, end_position_on_the_genomic_accession=96905343, orientation='minus', exon_count=14, OMIM='', no_hdr0=''),
  667444 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=667444, CurrentID=0, Status='live', Symbol='Vmn1r139', Aliases='EG667444, Gm8636', description='vomeronasal 1 receptor 139', other_designations='vomernasal 1 receptor Vmn1r139', map_location='7 A3', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=22096867, end_position_on_the_genomic_accession=22097760, orientation='plus', exon_count=1, OMIM='', no_hdr0=''),
  102641463 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102641463, CurrentID=0, Status='live', Symbol='Gm17175', Aliases='', description='predicted gene 17175', other_designations='', map_location='14 26.58 cM', chromosome='14', genomic_nucleotide_accession_version='NC_000080.6', start_position_on_the_genomic_accession=51563960, end_position_on_the_genomic_accession=51570889, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  102641464 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102641464, CurrentID=0, Status='live', Symbol='LOC102641464', Aliases='', description='prostaglandin E synthase 3', other_designations='', map_location='', chromosome='6', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  12091 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12091, CurrentID=0, Status='live', Symbol='Glb1', Aliases='AW125515, Bge, Bgl, Bgl-e, Bgl-s, Bgl-t, Bgs, Bgt, C130097A14Rik', description='galactosidase, beta 1', other_designations='acid beta-galactosidase|lactase', map_location='9 64.4 cM', chromosome='9', genomic_nucleotide_accession_version='NC_000075.6', start_position_on_the_genomic_accession=114401078, end_position_on_the_genomic_accession=114474379, orientation='plus', exon_count=16, OMIM='', no_hdr0=''),
  102641470 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102641470, CurrentID=0, Status='live', Symbol='LOC102641470', Aliases='', description='E3 ubiquitin-protein ligase Midline-1-like', other_designations='', map_location='', chromosome='Un', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  12095 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12095, CurrentID=0, Status='live', Symbol='Bglap3', Aliases='AI461847, Bglap-rs1, OC-X, ORG, mOC-X', description='bone gamma-carboxyglutamate protein 3', other_designations='bone gamma-carboxyglutamate protein, related sequence 1|gamma-carboxyglutamic acid-containing protein 3|nephrocalcin', map_location='3 38.81 cM', chromosome='3', genomic_nucleotide_accession_version='NC_000069.6', start_position_on_the_genomic_accession=88368615, end_position_on_the_genomic_accession=88372749, orientation='minus', exon_count=7, OMIM='', no_hdr0=''),
  12096 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12096, CurrentID=0, Status='live', Symbol='Bglap', Aliases='BGP1, OC, OG1, mOC-A, Bglap', description='bone gamma carboxyglutamate protein', other_designations='bone Gla protein|bone gamma carboxyglutamate protein 1|gamma-carboxyglutamic acid-containing protein', map_location='3 38.82 cM', chromosome='3', genomic_nucleotide_accession_version='NC_000069.6', start_position_on_the_genomic_accession=88383495, end_position_on_the_genomic_accession=88384466, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  12097 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12097, CurrentID=0, Status='live', Symbol='Bglap2', Aliases='BGP2, Bglap1, Bgp, Og2, mOC-B', description='bone gamma-carboxyglutamate protein 2', other_designations='bone Gla protein 2|gamma-carboxyglutamic acid-containing protein 2|osteocalcin', map_location='3 38.81 cM', chromosome='3', genomic_nucleotide_accession_version='NC_000069.6', start_position_on_the_genomic_accession=88377736, end_position_on_the_genomic_accession=88378699, orientation='minus', exon_count=4, OMIM='', no_hdr0=''),
  667464 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=667464, CurrentID=0, Status='live', Symbol='Vmn1r142', Aliases='EG667464, Gm8647', description='vomeronasal 1 receptor 142', other_designations='vomernasal 1 receptor Vmn1r142', map_location='7 A3', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=22163118, end_position_on_the_genomic_accession=22164035, orientation='minus', exon_count=1, OMIM='', no_hdr0=''),
  667466 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=667466, CurrentID=0, Status='live', Symbol='Gm15454', Aliases='EG667466, OTTMUSG00000022097', description='predicted gene 15454', other_designations='', map_location='1 E4', chromosome='1', genomic_nucleotide_accession_version='NC_000067.4', start_position_on_the_genomic_accession=136334428, end_position_on_the_genomic_accession=136335128, orientation='plus', exon_count=1, OMIM='', no_hdr0=''),
  667469 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=667469, CurrentID=0, Status='live', Symbol='Vmn1r143', Aliases='EG667469, Gm8650', description='vomeronasal 1 receptor 143', other_designations='vomernasal 1 receptor Vmn1r143', map_location='7 A3', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=22189377, end_position_on_the_genomic_accession=22190300, orientation='plus', exon_count=1, OMIM='', no_hdr0=''),
  12111 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12111, CurrentID=0, Status='live', Symbol='Bgn', Aliases='BG, DSPG1, PG-S1, PGI, SLRR1A', description='biglycan', other_designations='bone/cartilage proteoglycan I', map_location='X B', chromosome='X', genomic_nucleotide_accession_version='NC_000086.7', start_position_on_the_genomic_accession=73483612, end_position_on_the_genomic_accession=73495936, orientation='plus', exon_count=9, OMIM='', no_hdr0=''),
  667472 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=667472, CurrentID=0, Status='live', Symbol='Gm8653', Aliases='EG667472, Vmn1r144', description='predicted gene 8653', other_designations='', map_location='7 A3', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=22200341, end_position_on_the_genomic_accession=22201264, orientation='minus', exon_count=1, OMIM='', no_hdr0=''),
  67555 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=67555, CurrentID=0, Status='live', Symbol='Mgat4d', Aliases='4933434I20Rik, GnT1IP, GnT1IP-L', description='MGAT4 family, member C', other_designations='GlcNAcT-I inhibitory protein|glycosyltransferase 54 domain-containing protein', map_location='8 C2', chromosome='8', genomic_nucleotide_accession_version='NC_000074.6', start_position_on_the_genomic_accession=83339402, end_position_on_the_genomic_accession=83382299, orientation='plus', exon_count=16, OMIM='', no_hdr0=''),
  12116 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12116, CurrentID=0, Status='live', Symbol='Bhmt', Aliases='', description='betaine-homocysteine methyltransferase', other_designations='', map_location='13 D1', chromosome='13', genomic_nucleotide_accession_version='NC_000079.6', start_position_on_the_genomic_accession=93616891, end_position_on_the_genomic_accession=93637758, orientation='minus', exon_count=8, OMIM='', no_hdr0=''),
  12121 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12121, CurrentID=0, Status='live', Symbol='Bicd1', Aliases='B830009D06Rik', description='bicaudal D homolog 1 (Drosophila)', other_designations='bic-D 1', map_location='6 G3', chromosome='6', genomic_nucleotide_accession_version='NC_000072.6', start_position_on_the_genomic_accession=149408819, end_position_on_the_genomic_accession=149563329, orientation='plus', exon_count=11, OMIM='', no_hdr0=''),
  12122 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12122, CurrentID=0, Status='live', Symbol='Bid', Aliases='2700049M22Rik, AI875481, AU022477', description='BH3 interacting domain death agonist', other_designations='p22 BID', map_location='6 57.02 cM', chromosome='6', genomic_nucleotide_accession_version='NC_000072.6', start_position_on_the_genomic_accession=120893119, end_position_on_the_genomic_accession=120917142, orientation='minus', exon_count=9, OMIM='', no_hdr0=''),
  12123 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12123, CurrentID=0, Status='live', Symbol='Hrk', Aliases='AI838259, Bid3, DP5, harakiri', description='harakiri, BCL2 interacting protein (contains only BH3 domain)', other_designations='BH3 interacting (with BCL2 family) domain, apoptosis agonist|BH3-interacting domain-containing protein 3|neuronal death protein DP5', map_location='5 F', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=118169764, end_position_on_the_genomic_accession=118189478, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  12124 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12124, CurrentID=0, Status='live', Symbol='Bik', Aliases='Biklk, Blk, Nbk', description='BCL2-interacting killer', other_designations='apoptosis inducer NBK|bik-like killer protein', map_location='15 E1', chromosome='15', genomic_nucleotide_accession_version='NC_000081.6', start_position_on_the_genomic_accession=83526792, end_position_on_the_genomic_accession=83544635, orientation='plus', exon_count=9, OMIM='', no_hdr0=''),
  12125 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12125, CurrentID=0, Status='live', Symbol='Bcl2l11', Aliases='1500006F24Rik, Bim, Bod, bcl2-L-11', description='BCL2-like 11 (apoptosis facilitator)', other_designations='Bcl2 interacting mediator of cell death|bcl2-interacting mediator of cell death', map_location='2 F3-G1', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=128126038, end_position_on_the_genomic_accession=128162547, orientation='plus', exon_count=7, OMIM='', no_hdr0=''),
  667488 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=667488, CurrentID=0, Status='live', Symbol='Gm270', Aliases='', description='predicted gene 270', other_designations='', map_location='13 A5', chromosome='13', genomic_nucleotide_accession_version='NC_000079.6', start_position_on_the_genomic_accession=49764316, end_position_on_the_genomic_accession=49766106, orientation='plus', exon_count=1, OMIM='', no_hdr0=''),
  12140 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12140, CurrentID=0, Status='live', Symbol='Fabp7', Aliases='B-FABP, BFABP, Blbp, MRG', description='fatty acid binding protein 7, brain', other_designations='brain lipid binding protein|brain lipid-binding protein|brain-type fatty acid-binding protein|fatty acid-binding protein 7|mammary-derived growth inhibitor-related', map_location='10 B4', chromosome='10', genomic_nucleotide_accession_version='NC_000076.6', start_position_on_the_genomic_accession=57784923, end_position_on_the_genomic_accession=57788450, orientation='plus', exon_count=4, OMIM='', no_hdr0=''),
  12142 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12142, CurrentID=0, Status='live', Symbol='Prdm1', Aliases='Blimp-1, Blimp1, PRDI-BF1, ZNFPR1A1, b2b1765Clo', description='PR domain containing 1, with ZNF domain', other_designations='B lymphocyte induced maturation protein|B lymphocyte-induced maturation protein 1|PR domain containing 1 with ZNF domain|PR domain-containing protein 1|beta-interferon gene positive regulatory domain I-binding factor', map_location='10 23.24 cM', chromosome='10', genomic_nucleotide_accession_version='NC_000076.6', start_position_on_the_genomic_accession=44437174, end_position_on_the_genomic_accession=44528560, orientation='minus', exon_count=12, OMIM='', no_hdr0=''),
  12143 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12143, CurrentID=0, Status='live', Symbol='Blk', Aliases='', description='B lymphoid kinase', other_designations='b lymphocyte kinase|p55-Blk', map_location='14 33.25 cM', chromosome='14', genomic_nucleotide_accession_version='NC_000080.6', start_position_on_the_genomic_accession=63372831, end_position_on_the_genomic_accession=63417187, orientation='minus', exon_count=14, OMIM='', no_hdr0=''),
  12144 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12144, CurrentID=0, Status='live', Symbol='Blm', Aliases='', description='Bloom syndrome, RecQ helicase-like', other_designations='Bloom syndrome homolog|mBLM|recQ helicase homolog', map_location='7 45.65 cM', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=80454993, end_position_on_the_genomic_accession=80535119, orientation='minus', exon_count=23, OMIM='', no_hdr0=''),
  12145 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12145, CurrentID=0, Status='live', Symbol='Cxcr5', Aliases='Blr1, CXC-R5, CXCR-5, Gpcr6, MDR15', description='chemokine (C-X-C motif) receptor 5', other_designations='burkitt lymphoma receptor 1 homolog|chemochine (C-X-C motif) receptor 5', map_location='9 24.84 cM', chromosome='9', genomic_nucleotide_accession_version='NC_000075.6', start_position_on_the_genomic_accession=44511534, end_position_on_the_genomic_accession=44561874, orientation='minus', exon_count=4, OMIM='', no_hdr0=''),
  667507 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=667507, CurrentID=0, Status='live', Symbol='Gm8674', Aliases='EG667507', description='predicted gene 8674', other_designations='', map_location='13 A5', chromosome='13', genomic_nucleotide_accession_version='NC_000079.6', start_position_on_the_genomic_accession=49899049, end_position_on_the_genomic_accession=49904674, orientation='minus', exon_count=4, OMIM='', no_hdr0=''),
  12151 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12151, CurrentID=0, Status='live', Symbol='Bmi1', Aliases='AW546694, Bmi-1, Pcgf4', description='Bmi1 polycomb ring finger oncogene', other_designations='B lymphoma Mo-MLV insertion region 1|polycomb group RING finger protein 4|polycomb group ring finger 4', map_location='2 12.9 cM', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=18677018, end_position_on_the_genomic_accession=18686629, orientation='plus', exon_count=12, OMIM='', no_hdr0=''),
  667512 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=667512, CurrentID=0, Status='live', Symbol='Gm8677', Aliases='EG667512, Vmn1r153', description='predicted gene 8677', other_designations='', map_location='7 A3', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=22533964, end_position_on_the_genomic_accession=22534887, orientation='minus', exon_count=1, OMIM='', no_hdr0=''),
  12153 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12153, CurrentID=0, Status='live', Symbol='Bmp1', Aliases='Pcp, Tld', description='bone morphogenetic protein 1', other_designations='mammalian tolloid protein|procollagen C-proteinase', map_location='14 36.32 cM', chromosome='14', genomic_nucleotide_accession_version='NC_000080.6', start_position_on_the_genomic_accession=70474555, end_position_on_the_genomic_accession=70520712, orientation='minus', exon_count=23, OMIM='', no_hdr0=''),
  12154 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12154, CurrentID=0, Status='live', Symbol='Bmp10', Aliases='', description='bone morphogenetic protein 10', other_designations='BMP-10', map_location='6 D2', chromosome='6', genomic_nucleotide_accession_version='NC_000072.6', start_position_on_the_genomic_accession=87429002, end_position_on_the_genomic_accession=87434512, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  12155 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12155, CurrentID=0, Status='live', Symbol='Bmp15', Aliases='AU0153