"""Data downloaded from NCBI Gene data converted into Python data."""

# Copyright (C) 2014-2017, DV Klopfenstein. All rights reserved

downloaded = "2016_02_22" # 21955 items

import collections as cx

NtData = cx.namedtuple('NtData', 'tax_id Org_name GeneID CurrentID Status Symbol Aliases description other_designations map_location chromosome genomic_nucleotide_accession_version start_position_on_the_genomic_accession end_position_on_the_genomic_accession orientation exon_count OMIM no_hdr0')
GeneID2nt = {
  21846 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=21846, CurrentID=0, Status='live', Symbol='Tie1', Aliases='D430008P04Rik, TIE, tie-1', description='tyrosine kinase with immunoglobulin-like and EGF-like domains 1', other_designations='tyrosine kinase receptor 1', map_location='4 54.67 cM', chromosome='4', genomic_nucleotide_accession_version='NC_000070.6', start_position_on_the_genomic_accession=118471191, end_position_on_the_genomic_accession=118489849, orientation='minus', exon_count=23, OMIM='', no_hdr0=''),
  21855 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=21855, CurrentID=0, Status='live', Symbol='Timm17b', Aliases='17kDa, Sfc3, mTim17b', description='translocase of inner mitochondrial membrane 17b', other_designations='translocator of inner mitochondrial membrane 17 kDa, b|translocator of inner mitochondrial membrane 17b|translocator of inner mitochondrial membrane b', map_location='X 3.56 cM', chromosome='X', genomic_nucleotide_accession_version='NC_000086.7', start_position_on_the_genomic_accession=7899242, end_position_on_the_genomic_accession=7907652, orientation='plus', exon_count=6, OMIM='', no_hdr0=''),
  546144 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=546144, CurrentID=0, Status='live', Symbol='Wdr72', Aliases='AW558070, D230040E23', description='WD repeat domain 72', other_designations='', map_location='9 D', chromosome='9', genomic_nucleotide_accession_version='NC_000075.6', start_position_on_the_genomic_accession=74110331, end_position_on_the_genomic_accession=74283203, orientation='plus', exon_count=21, OMIM='', no_hdr0=''),
  21869 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=21869, CurrentID=0, Status='live', Symbol='Nkx2-1', Aliases='AV026640, Nkx2.1, T/EBP, Titf1, Ttf-1', description='NK2 homeobox 1', other_designations='thyroid nuclear factor 1|thyroid transcription factor 1|thyroid-specific enhancer-binding protein|tinman', map_location='12 C1-C3', chromosome='12', genomic_nucleotide_accession_version='NC_000078.6', start_position_on_the_genomic_accession=56531935, end_position_on_the_genomic_accession=56536908, orientation='minus', exon_count=5, OMIM='', no_hdr0=''),
  21873 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=21873, CurrentID=0, Status='live', Symbol='Tjp2', Aliases='ZO-2', description='tight junction protein 2', other_designations='Tight junction protein ZO-2 (Zonula occludens 2 protein) (Zona occludens 2 protein) (Tight junction protein 2)|zona occludens protein 2|zonula occludens protein 2', map_location='19 C1', chromosome='19', genomic_nucleotide_accession_version='NC_000085.6', start_position_on_the_genomic_accession=24094502, end_position_on_the_genomic_accession=24225128, orientation='minus', exon_count=27, OMIM='', no_hdr0=''),
  21899 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=21899, CurrentID=0, Status='live', Symbol='Tlr6', Aliases='', description='toll-like receptor 6', other_designations='', map_location='5 33.54 cM', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=64952030, end_position_on_the_genomic_accession=64971173, orientation='minus', exon_count=6, OMIM='', no_hdr0=''),
  21925 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=21925, CurrentID=0, Status='live', Symbol='Tnnc2', Aliases='Tncs', description='troponin C2, fast', other_designations='STNC|troponin C, fast skeletal', map_location='2 H3', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=164777161, end_position_on_the_genomic_accession=164779734, orientation='minus', exon_count=6, OMIM='', no_hdr0=''),
  677296 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=677296, CurrentID=0, Status='live', Symbol='Fcrl6', Aliases='ENSMUSG00000070504, FcRH6, mIFGP6, moFcRH6', description='Fc receptor-like 6', other_designations='cell surface glycoprotein gp42|fcR-like protein 6', map_location='1 H3', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=172596640, end_position_on_the_genomic_accession=172618322, orientation='minus', exon_count=9, OMIM='', no_hdr0=''),
  394252 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=394252, CurrentID=0, Status='live', Symbol='Serpinb3d', Aliases='Serpinb3l1', description='serine (or cysteine) peptidase inhibitor, clade B (ovalbumin), member 3D', other_designations='serine (or cysteine) proteinase inhibitor, clade B (ovalbumin), member 3D|serine proteinase inhibitor B3-like 1', map_location='1', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=107078163, end_position_on_the_genomic_accession=107084125, orientation='minus', exon_count=8, OMIM='', no_hdr0=''),
  394430 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=394430, CurrentID=0, Status='live', Symbol='Ugt1a10', Aliases='A13, Ugt1a13', description='UDP glycosyltransferase 1 family, polypeptide A10', other_designations='UDP glycosyltransferase 1 family polypeptide A13', map_location='1 D', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=88055411, end_position_on_the_genomic_accession=88220002, orientation='plus', exon_count=5, OMIM='', no_hdr0=''),
  394432 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=394432, CurrentID=0, Status='live', Symbol='Ugt1a7c', Aliases="A10', A13, Ugt1a10", description='UDP glucuronosyltransferase 1 family, polypeptide A7C', other_designations='UDP glucuronosyltransferase 1 family, polypeptide A10|UDP glycosyltransferase 1 family, polypeptide A10|UDP-glucuronosyltransferase 1A7C|UDPGT 1-7C|UGT1*7C|UGT1-07C|UGT1.7C', map_location='1 D', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=88095001, end_position_on_the_genomic_accession=88220002, orientation='plus', exon_count=5, OMIM='', no_hdr0=''),
  394433 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=394433, CurrentID=0, Status='live', Symbol='Ugt1a5', Aliases='', description='UDP glucuronosyltransferase 1 family, polypeptide A5', other_designations='UDP glycosyltransferase 1 family, polypeptide A5', map_location='1 D', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=88166012, end_position_on_the_genomic_accession=88220002, orientation='plus', exon_count=5, OMIM='', no_hdr0=''),
  394434 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=394434, CurrentID=0, Status='live', Symbol='Ugt1a9', Aliases='UDPGT, UDPGT 1-9, UGT1-09, UGT1.9, UGTP4, Ugt1a12, mUGTBr/P', description='UDP glucuronosyltransferase 1 family, polypeptide A9', other_designations='UDP glycosyltransferase 1 family polypeptide A12|UDP-glucuronosyltransferase 1-7|UDP-glucuronosyltransferase 1A9', map_location='1 D', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=88070779, end_position_on_the_genomic_accession=88220002, orientation='plus', exon_count=5, OMIM='', no_hdr0=''),
  394435 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=394435, CurrentID=0, Status='live', Symbol='Ugt1a6b', Aliases="A9', Ugt1a9", description='UDP glucuronosyltransferase 1 family, polypeptide A6B', other_designations='UDP glycosyltransferase 1 family polypeptide A9', map_location='1 D', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=88103257, end_position_on_the_genomic_accession=88218998, orientation='plus', exon_count=6, OMIM='', no_hdr0=''),
  394436 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=394436, CurrentID=0, Status='live', Symbol='Ugt1a1', Aliases='Gnt1, UDPGT 1-1, UGT1A01, Udpgt-1a, UgtBr1', description='UDP glucuronosyltransferase 1 family, polypeptide A1', other_designations='UDP-glucuronosyltransferase 1 family, member 1|UDP-glucuronosyltransferase 1 family, polypeptide A1|UDP-glucuronosyltransferase 1A1|UDPGT|UGT1*1|UGT1-01|UGT1.1', map_location='1 44.55 cM', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=88211959, end_position_on_the_genomic_accession=88220002, orientation='plus', exon_count=5, OMIM='', no_hdr0=''),
  263406 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=263406, CurrentID=0, Status='live', Symbol='Plekhg3', Aliases='BC030417', description='pleckstrin homology domain containing, family G (with RhoGef domain) member 3', other_designations='PH domain-containing family G member 3', map_location='12 C3', chromosome='12', genomic_nucleotide_accession_version='NC_000078.6', start_position_on_the_genomic_accession=76533247, end_position_on_the_genomic_accession=76579042, orientation='plus', exon_count=21, OMIM='', no_hdr0=''),
  263764 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=263764, CurrentID=0, Status='live', Symbol='Creg2', Aliases='A830098L22Rik', description='cellular repressor of E1A-stimulated genes 2', other_designations='', map_location='1 B', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=39618406, end_position_on_the_genomic_accession=39651510, orientation='minus', exon_count=5, OMIM='', no_hdr0=''),
  100271704 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=100271704, CurrentID=0, Status='live', Symbol='Gm17660', Aliases='Scpppq1', description='predicted gene, 17660', other_designations='secretory calcium-binding phosphoprotein proline-glutamine rich 1', map_location='5 50.54 cM', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=104070060, end_position_on_the_genomic_accession=104077608, orientation='minus', exon_count=10, OMIM='', no_hdr0=''),
  263803 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=263803, CurrentID=0, Status='live', Symbol='Pkn3', Aliases='AW209115, BC034126', description='protein kinase N3', other_designations='protein kinase PKN-beta|protein kinase PKNbeta|protein-kinase C-related kinase 3', map_location='2 B', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=30077544, end_position_on_the_genomic_accession=30091019, orientation='plus', exon_count=24, OMIM='', no_hdr0=''),
  100009600 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=100009600, CurrentID=0, Status='live', Symbol='Zglp1', Aliases='Glp1', description='zinc finger, GATA-like protein 1', other_designations='GATA-like 1|GATA-like protein 1|GLP-1', map_location='9 A3', chromosome='9', genomic_nucleotide_accession_version='NC_000075.6', start_position_on_the_genomic_accession=21062393, end_position_on_the_genomic_accession=21067093, orientation='minus', exon_count=5, OMIM='', no_hdr0=''),
  263876 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=263876, CurrentID=0, Status='live', Symbol='Spata2', Aliases='AI504642, mKIAA0757', description='spermatogenesis associated 2', other_designations='', map_location='2 H3', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=167481136, end_position_on_the_genomic_accession=167492874, orientation='minus', exon_count=5, OMIM='', no_hdr0=''),
  264064 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=264064, CurrentID=0, Status='live', Symbol='Cdk8', Aliases='', description='cyclin-dependent kinase 8', other_designations='cell division protein kinase 8|mediator complex subunit CDK8|mediator of RNA polymerase II transcription subunit CDK8', map_location='5 G3', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=146230736, end_position_on_the_genomic_accession=146302874, orientation='plus', exon_count=13, OMIM='', no_hdr0=''),
  264134 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=264134, CurrentID=0, Status='live', Symbol='Ttc26', Aliases='9330141E21Rik, 9430097H08Rik', description='tetratricopeptide repeat domain 26', other_designations='TPR repeat protein 26|protein hop-sterile|tetratricopeptide repeat protein 26', map_location='6 B1', chromosome='6', genomic_nucleotide_accession_version='NC_000072.6', start_position_on_the_genomic_accession=38381474, end_position_on_the_genomic_accession=38427647, orientation='plus', exon_count=18, OMIM='', no_hdr0=''),
  100534273 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=100534273, CurrentID=0, Status='live', Symbol='Fer1l5', Aliases='4930533C12Rik', description='fer-1-like 5 (C. elegans)', other_designations='fer-1-like 5 protein', map_location='1 B', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=36372199, end_position_on_the_genomic_accession=36422110, orientation='plus', exon_count=54, OMIM='', no_hdr0=''),
  109569 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=109569, CurrentID=0, Status='live', Symbol='Rn7s8', Aliases='Rn7s-8', description='7S RNA 8', other_designations='', map_location='', chromosome='8', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  109593 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=109593, CurrentID=0, Status='live', Symbol='Lmo3', Aliases='AI854781, BB106490, Rbtn-3, Rbtn3', description='LIM domain only 3', other_designations='LIM only 3|LMO-3|neuronal-specific transcription factor DAT1', map_location='6 69.02 cM', chromosome='6', genomic_nucleotide_accession_version='NC_000072.6', start_position_on_the_genomic_accession=138362918, end_position_on_the_genomic_accession=138581968, orientation='minus', exon_count=15, OMIM='', no_hdr0=''),
  240672 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=240672, CurrentID=0, Status='live', Symbol='Dusp5', Aliases='Gm337', description='dual specificity phosphatase 5', other_designations='', map_location='19 D2', chromosome='19', genomic_nucleotide_accession_version='NC_000085.6', start_position_on_the_genomic_accession=53529318, end_position_on_the_genomic_accession=53541322, orientation='plus', exon_count=4, OMIM='', no_hdr0=''),
  240675 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=240675, CurrentID=0, Status='live', Symbol='Vwa2', Aliases='Amaco', description='von Willebrand factor A domain containing 2', other_designations='VWA-like domains, matrilins and collagens|a domain-containing protein similar to matrilin and collagen', map_location='19 D2', chromosome='19', genomic_nucleotide_accession_version='NC_000085.6', start_position_on_the_genomic_accession=56874416, end_position_on_the_genomic_accession=56912078, orientation='plus', exon_count=16, OMIM='', no_hdr0=''),
  22258 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=22258, CurrentID=0, Status='live', Symbol='Usp4', Aliases='F730026I20Rik, Unp, mKIAA4155', description='ubiquitin specific peptidase 4 (proto-oncogene)', other_designations='deubiquitinating enzyme 4|ubiquitin specific protease 4 (proto-oncogene)|ubiquitin thioesterase 4|ubiquitin thiolesterase 4|ubiquitin-specific-processing protease 4|ubiquitous nuclear protein', map_location='9 59.25 cM', chromosome='9', genomic_nucleotide_accession_version='NC_000075.6', start_position_on_the_genomic_accession=108347820, end_position_on_the_genomic_accession=108392529, orientation='plus', exon_count=22, OMIM='', no_hdr0=''),
  328108 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=328108, CurrentID=0, Status='live', Symbol='Fam179b', Aliases='A430041B07Rik, BC062107, C130034K06, mKIAA0423', description='family with sequence similarity 179, member B', other_designations='', map_location='12 C1', chromosome='12', genomic_nucleotide_accession_version='NC_000078.6', start_position_on_the_genomic_accession=64965742, end_position_on_the_genomic_accession=65022573, orientation='plus', exon_count=22, OMIM='', no_hdr0=''),
  264895 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=264895, CurrentID=0, Status='live', Symbol='Acsf2', Aliases='', description='acyl-CoA synthetase family member 2', other_designations='', map_location='11 D', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=94557102, end_position_on_the_genomic_accession=94601891, orientation='minus', exon_count=16, OMIM='', no_hdr0=''),
  102632135 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102632135, CurrentID=0, Status='live', Symbol='Gm30289', Aliases='', description='predicted gene, 30289', other_designations='', map_location='3', chromosome='3', genomic_nucleotide_accession_version='NC_000069.6', start_position_on_the_genomic_accession=40980026, end_position_on_the_genomic_accession=41040207, orientation='plus', exon_count=14, OMIM='', no_hdr0=''),
  22327 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=22327, CurrentID=0, Status='live', Symbol='Vbp1', Aliases='VBP-1', description='von Hippel-Lindau binding protein 1', other_designations='VHL-binding protein 1|von Hippel-Lindau-binding protein 1', map_location='X 38.25 cM', chromosome='X', genomic_nucleotide_accession_version='NC_000086.7', start_position_on_the_genomic_accession=75514278, end_position_on_the_genomic_accession=75534946, orientation='plus', exon_count=7, OMIM='', no_hdr0=''),
  396184 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=396184, CurrentID=0, Status='live', Symbol='Flrt1', Aliases='AW742165, D630040I23Rik', description='fibronectin leucine rich transmembrane protein 1', other_designations='', map_location='19 A', chromosome='19', genomic_nucleotide_accession_version='NC_000085.6', start_position_on_the_genomic_accession=7087464, end_position_on_the_genomic_accession=7166030, orientation='minus', exon_count=4, OMIM='', no_hdr0=''),
  546643 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=546643, CurrentID=0, Status='live', Symbol='I830127L07Rik', Aliases='', description='RIKEN cDNA I830127L07 gene', other_designations='', map_location='15 D3', chromosome='15', genomic_nucleotide_accession_version='NC_000081.6', start_position_on_the_genomic_accession=75131292, end_position_on_the_genomic_accession=75135194, orientation='minus', exon_count=4, OMIM='', no_hdr0=''),
  240817 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=240817, CurrentID=0, Status='live', Symbol='Teddm2', Aliases='5830403L16Rik, AJ554213, Me9, e92', description='transmembrane epididymal family member 2', other_designations='epididymal protein Me9', map_location='1 G3', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=153849542, end_position_on_the_genomic_accession=153851195, orientation='minus', exon_count=1, OMIM='', no_hdr0=''),
  328234 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=328234, CurrentID=0, Status='live', Symbol='Rnf182', Aliases='C630023L15Rik', description='ring finger protein 182', other_designations='', map_location='13 A4', chromosome='13', genomic_nucleotide_accession_version='NC_000079.6', start_position_on_the_genomic_accession=43615158, end_position_on_the_genomic_accession=43670946, orientation='plus', exon_count=3, OMIM='', no_hdr0=''),
  328250 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=328250, CurrentID=0, Status='live', Symbol='Nutm2', Aliases='Fam22, Gm806', description='NUT family member 2', other_designations='NUT family member Gm806|protein FAM22', map_location='13 A5', chromosome='13', genomic_nucleotide_accession_version='NC_000079.6', start_position_on_the_genomic_accession=50467307, end_position_on_the_genomic_accession=50475355, orientation='plus', exon_count=7, OMIM='', no_hdr0=''),
  240869 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=240869, CurrentID=0, Status='live', Symbol='Zbtb37', Aliases='D430004I08Rik', description='zinc finger and BTB domain containing 37', other_designations='', map_location='1 H2.1', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=161008792, end_position_on_the_genomic_accession=161034864, orientation='minus', exon_count=9, OMIM='', no_hdr0=''),
  109801 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=109801, CurrentID=0, Status='live', Symbol='Glo1', Aliases='0610009E22Rik, 1110008E19Rik, 2510049H23Rik, AW550643, GLY1, Glo-1, Glo-1r, Glo-1s-r, Glo1-s, Qglo, Glo1', description='glyoxalase 1', other_designations='S-D-lactoylglutathione methylglyoxal lyase|aldoketomutase|glx I|glyoxalase 1 complex|glyoxalase 1 regulatory|glyoxalase 1 structural|glyoxalase I|ketone-aldehyde mutase|methylglyoxalase', map_location='17 15.69 cM', chromosome='17', genomic_nucleotide_accession_version='NC_000083.6', start_position_on_the_genomic_accession=30592861, end_position_on_the_genomic_accession=30612659, orientation='minus', exon_count=6, OMIM='', no_hdr0=''),
  328258 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=328258, CurrentID=0, Status='live', Symbol='Slc25a48', Aliases='AU042651, E230025K15', description='solute carrier family 25, member 48', other_designations='putative mitochondrial carrier protein FLJ44862 homolog', map_location='13 B1', chromosome='13', genomic_nucleotide_accession_version='NC_000079.6', start_position_on_the_genomic_accession=56437963, end_position_on_the_genomic_accession=56472367, orientation='plus', exon_count=10, OMIM='', no_hdr0=''),
  240880 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=240880, CurrentID=0, Status='live', Symbol='Scyl3', Aliases='1200016D23Rik, 6030457O16, AW214499, Pace1', description='SCY1-like 3 (S. cerevisiae)', other_designations='SCY1-like protein 3|ezrin-binding partner PACE-1|ezrin-binding protein PACE-1', map_location='1 H2.2', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=163927958, end_position_on_the_genomic_accession=163955126, orientation='plus', exon_count=16, OMIM='', no_hdr0=''),
  634104 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=634104, CurrentID=0, Status='live', Symbol='Olfr287', Aliases='MOR286-1', description='olfactory receptor 287', other_designations='GA_x6K02T2NBG7-5548201-5549154|olfactory receptor MOR286-1', map_location='15 F1', chromosome='15', genomic_nucleotide_accession_version='NC_000081.6', start_position_on_the_genomic_accession=98204566, end_position_on_the_genomic_accession=98221056, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  240892 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=240892, CurrentID=0, Status='live', Symbol='Dusp27', Aliases='C130085G02Rik, Gm209', description='dual specificity phosphatase 27 (putative)', other_designations='', map_location='1 H2.3', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=166098148, end_position_on_the_genomic_accession=166127898, orientation='minus', exon_count=6, OMIM='', no_hdr0=''),
  22441 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=22441, CurrentID=0, Status='live', Symbol='Xlr', Aliases='', description='X-linked lymphocyte-regulated', other_designations='X-linked gene family of B-cell surface antigens|X-linked lymphocyte-regulated complex', map_location='X A5', chromosome='X', genomic_nucleotide_accession_version='NC_000086.7', start_position_on_the_genomic_accession=53777118, end_position_on_the_genomic_accession=53797716, orientation='minus', exon_count=9, OMIM='', no_hdr0=''),
  240921 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=240921, CurrentID=0, Status='live', Symbol='Gm4955', Aliases='EG240921, Ifi206', description='predicted gene 4955', other_designations='', map_location='1 H3', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=173468413, end_position_on_the_genomic_accession=173486872, orientation='minus', exon_count=5, OMIM='', no_hdr0=''),
  328329 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=328329, CurrentID=0, Status='live', Symbol='Mast4', Aliases='4930420O11Rik, AI642422, mKIAA0303', description='microtubule associated serine/threonine kinase family member 4', other_designations='mast4', map_location='13 D1', chromosome='13', genomic_nucleotide_accession_version='NC_000079.6', start_position_on_the_genomic_accession=102732488, end_position_on_the_genomic_accession=103335840, orientation='minus', exon_count=38, OMIM='', no_hdr0=''),
  66203 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=66203, CurrentID=0, Status='live', Symbol='Lce1m', Aliases='1110059L13Rik, AI131654, Lce5a, Sprrl10', description='late cornified envelope 1M', other_designations='late cornified envelope 5A|small proline rich-like 10', map_location='3 F2', chromosome='3', genomic_nucleotide_accession_version='NC_000069.6', start_position_on_the_genomic_accession=93017807, end_position_on_the_genomic_accession=93019061, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  102633458 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102633458, CurrentID=0, Status='live', Symbol='Gm11100', Aliases='ENSMUSG00000079357', description='predicted gene 11100', other_designations='', map_location='14 7.08 cM', chromosome='14', genomic_nucleotide_accession_version='NC_000080.6', start_position_on_the_genomic_accession=13932894, end_position_on_the_genomic_accession=13949153, orientation='plus', exon_count=4, OMIM='', no_hdr0=''),
  328370 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=328370, CurrentID=0, Status='live', Symbol='Rft1', Aliases='D930025H04', description='RFT1 homolog (S. cerevisiae)', other_designations='', map_location='14 B', chromosome='14', genomic_nucleotide_accession_version='NC_000080.6', start_position_on_the_genomic_accession=30654341, end_position_on_the_genomic_accession=30691317, orientation='plus', exon_count=13, OMIM='', no_hdr0=''),
  328381 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=328381, CurrentID=0, Status='live', Symbol='Sh2d4b', Aliases='A430109M18Rik, D030001E08', description='SH2 domain containing 4B', other_designations='', map_location='14 B', chromosome='14', genomic_nucleotide_accession_version='NC_000080.6', start_position_on_the_genomic_accession=40811521, end_position_on_the_genomic_accession=40902337, orientation='minus', exon_count=13, OMIM='', no_hdr0=''),
  328401 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=328401, CurrentID=0, Status='live', Symbol='Rnase9', Aliases='ESRL, Rak1', description='ribonuclease, RNase A family, 9 (non-active)', other_designations='epididymal RNase|ribonuclease A family, member 9|ribonuclease A k1|ribonuclease-like protein 9', map_location='14 B-C1', chromosome='14', genomic_nucleotide_accession_version='NC_000080.6', start_position_on_the_genomic_accession=51038459, end_position_on_the_genomic_accession=51041905, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  109963 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=109963, CurrentID=0, Status='live', Symbol='Fre2', Aliases='', description='Friend erythroleukemia 2', other_designations='', map_location='', chromosome='9', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  328417 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=328417, CurrentID=0, Status='live', Symbol='Parp4', Aliases='Adprtl1, C030027K23Rik, E230037B21Rik, Gm743, PARPL, PH5P, VAULT3, VPARP, p193', description='poly (ADP-ribose) polymerase family, member 4', other_designations='ADP-ribosyltransferase (NAD+; poly (ADP-ribose) polymerase)-like 1', map_location='14 C3', chromosome='14', genomic_nucleotide_accession_version='NC_000080.6', start_position_on_the_genomic_accession=56575619, end_position_on_the_genomic_accession=56659798, orientation='plus', exon_count=35, OMIM='', no_hdr0=''),
  266614 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=266614, CurrentID=0, Status='live', Symbol='Ly6g5b', Aliases='', description='lymphocyte antigen 6 complex, locus G5B', other_designations='Ly6g5b splicing isoform 611|Ly6g5b splicing isoform 707', map_location='17 B1', chromosome='17', genomic_nucleotide_accession_version='NC_000083.6', start_position_on_the_genomic_accession=35113944, end_position_on_the_genomic_accession=35115400, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  266615 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=266615, CurrentID=0, Status='live', Symbol='Svet1', Aliases='', description='subventricular expressed transcript 1', other_designations='', map_location='', chromosome='8', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  266620 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=266620, CurrentID=0, Status='live', Symbol='Defb36', Aliases='BD-36, Defb123, mBD-36', description='defensin beta 36', other_designations='defensin beta 123', map_location='2 H1', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=152604327, end_position_on_the_genomic_accession=152612729, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  266632 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=266632, CurrentID=0, Status='live', Symbol='Irak4', Aliases='8430405M07Rik, 9330209D03Rik, IRAK-4, NY-REN-64', description='interleukin-1 receptor-associated kinase 4', other_designations='', map_location='15 F1', chromosome='15', genomic_nucleotide_accession_version='NC_000081.6', start_position_on_the_genomic_accession=94543611, end_position_on_the_genomic_accession=94568317, orientation='plus', exon_count=13, OMIM='', no_hdr0=''),
  266645 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=266645, CurrentID=0, Status='live', Symbol='Acmsd', Aliases='', description='amino carboxymuconate semialdehyde decarboxylase', other_designations='picolinate carboxylase', map_location='1 E3', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=127729413, end_position_on_the_genomic_accession=127767564, orientation='plus', exon_count=10, OMIM='', no_hdr0=''),
  790956 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=790956, CurrentID=0, Status='live', Symbol='Rs5-8s1', Aliases='', description='5.8S ribosomal RNA', other_designations='', map_location='', chromosome='17', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  266690 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=266690, CurrentID=0, Status='live', Symbol='Cyb5r4', Aliases='2810034J18Rik, B5+B5R, C79736, Cb5cb5r, Ncb5or, b5/b5r, b5b5r', description='cytochrome b5 reductase 4', other_designations='N-terminal cytochrome b5 and cytochrome b5 oxidoreductase domain-containing protein|NADPH cytochrome B5 oxidoreductase|cb5/cb5R|cytochrome b-type NAD(P)H oxidoreductase|flavohemoprotein b5/b5R', map_location='9 E3.1', chromosome='9', genomic_nucleotide_accession_version='NC_000075.6', start_position_on_the_genomic_accession=87022008, end_position_on_the_genomic_accession=87077774, orientation='plus', exon_count=16, OMIM='', no_hdr0=''),
  266692 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=266692, CurrentID=0, Status='live', Symbol='Cpne1', Aliases='1810028N16Rik, mKIAA4108', description='copine I', other_designations='', map_location='2 H2', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=156071841, end_position_on_the_genomic_accession=156111965, orientation='minus', exon_count=17, OMIM='', no_hdr0=''),
  66296 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=66296, CurrentID=0, Status='live', Symbol='Haus2', Aliases='1700101G24Rik, 2410007P03Rik, AU020217, Cep27', description='HAUS augmin-like complex, subunit 2', other_designations='centrosomal protein 27|centrosomal protein of 27 kDa', map_location='2 F1', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=120609382, end_position_on_the_genomic_accession=120621560, orientation='plus', exon_count=7, OMIM='', no_hdr0=''),
  22608 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=22608, CurrentID=0, Status='live', Symbol='Ybx1', Aliases='1700102N10Rik, C79409, EF1A, MSY1, Nsep1, YB-1, dbpB, mYB-1a', description='Y box protein 1', other_designations='CBF-A|CCAAT-binding transcription factor I subunit A|DNA binding protein B|DNA-binding protein B|EFI-A|Y-box binding protein 1|Y-box transcription factor|Y-box-binding protein 1|enhancer factor I subunit A|nuclease sensitive element binding protein 1', map_location='4 D1', chromosome='4', genomic_nucleotide_accession_version='NC_000070.6', start_position_on_the_genomic_accession=119277327, end_position_on_the_genomic_accession=119294659, orientation='minus', exon_count=8, OMIM='', no_hdr0=''),
  109990 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=109990, CurrentID=0, Status='live', Symbol='Saac', Aliases='', description='sialic acid O-acetylation', other_designations='', map_location='', chromosome='9', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  266744 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=266744, CurrentID=0, Status='live', Symbol='Lgsn', Aliases='Gluld1, Lgs, lengsin', description='lengsin, lens protein with glutamine synthetase domain', other_designations='glutamate-ammonia ligase (glutamine synthase) domain containing 1|glutamate-ammonia ligase (glutamine synthetase) domain containing 1|glutamate-ammonia ligase domain-containing protein 1', map_location='1 B', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=31176435, end_position_on_the_genomic_accession=31204725, orientation='plus', exon_count=5, OMIM='', no_hdr0=''),
  266781 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=266781, CurrentID=0, Status='live', Symbol='Snx17', Aliases='5830447M19Rik, AI790646, D5Ertd260e, b2b1625.1Clo, mKIAA0064', description='sorting nexin 17', other_designations='', map_location='5 B1', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=31193287, end_position_on_the_genomic_accession=31198900, orientation='plus', exon_count=16, OMIM='', no_hdr0=''),
  791070 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=791070, CurrentID=0, Status='live', Symbol='Mir744', Aliases='Mirn744, mir-744, mmu-mir-744', description='microRNA 744', other_designations='', map_location='11', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=65734733, end_position_on_the_genomic_accession=65734832, orientation='minus', exon_count=1, OMIM='', no_hdr0=''),
  791071 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=791071, CurrentID=0, Status='live', Symbol='Mir758', Aliases='Mirn758, mir-758, mmu-mir-758', description='microRNA 758', other_designations='', map_location='12', chromosome='12', genomic_nucleotide_accession_version='NC_000078.6', start_position_on_the_genomic_accession=109712810, end_position_on_the_genomic_accession=109712890, orientation='plus', exon_count=1, OMIM='', no_hdr0=''),
  791073 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=791073, CurrentID=0, Status='live', Symbol='Mir762', Aliases='Mirn762, mir-762, mmu-mir-762', description='microRNA 762', other_designations='', map_location='7', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=127708487, end_position_on_the_genomic_accession=127708562, orientation='plus', exon_count=1, OMIM='', no_hdr0=''),
  791074 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=791074, CurrentID=0, Status='live', Symbol='Mir802', Aliases='Mirn802, mir-802, mmu-mir-802', description='microRNA 802', other_designations='', map_location='16', chromosome='16', genomic_nucleotide_accession_version='NC_000082.6', start_position_on_the_genomic_accession=93369720, end_position_on_the_genomic_accession=93369816, orientation='plus', exon_count=1, OMIM='', no_hdr0=''),
  791081 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=791081, CurrentID=0, Status='live', Symbol='Mir764', Aliases='Mirn764, mir-764, mmu-mir-764', description='microRNA 764', other_designations='', map_location='X', chromosome='X', genomic_nucleotide_accession_version='NC_000086.7', start_position_on_the_genomic_accession=147002259, end_position_on_the_genomic_accession=147002366, orientation='plus', exon_count=1, OMIM='', no_hdr0=''),
  266815 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=266815, CurrentID=0, Status='live', Symbol='Mill1', Aliases='5530400I18Rik', description='MHC I like leukocyte 1', other_designations='MHC I-like leukocyte 1', map_location='7 9.15 cM', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=18245232, end_position_on_the_genomic_accession=18266092, orientation='plus', exon_count=7, OMIM='', no_hdr0=''),
  791260 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=791260, CurrentID=0, Status='live', Symbol='Tomt', Aliases='Comt2, F930017I19Rik', description='transmembrane O-methyltransferase', other_designations='catechol O-methyltransferase 2|catechol-O-methyltransferase 2', map_location='7', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=101899803, end_position_on_the_genomic_accession=101906359, orientation='minus', exon_count=5, OMIM='', no_hdr0=''),
  267019 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=267019, CurrentID=0, Status='live', Symbol='Rps15a', Aliases='A630031B11Rik', description='ribosomal protein S15A', other_designations='', map_location='7 F2', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=118104374, end_position_on_the_genomic_accession=118116147, orientation='minus', exon_count=5, OMIM='', no_hdr0=''),
  791364 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=791364, CurrentID=0, Status='live', Symbol='Hottip', Aliases='ENSMUSG00000055408, Gm15053, OTTMUSG00000018874', description='Hoxa distal transcript antisense RNA', other_designations='', map_location='6', chromosome='6', genomic_nucleotide_accession_version='NC_000072.6', start_position_on_the_genomic_accession=52262775, end_position_on_the_genomic_accession=52267603, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  328505 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=328505, CurrentID=0, Status='live', Symbol='Skint7', Aliases='C130057D23Rik', description='selection and upkeep of intraepithelial T cells 7', other_designations='novel immunoglobulin V-set and CD80-like C2-set immunoglobulin domain containing protein|skint 7|skint-7', map_location='4 D1', chromosome='4', genomic_nucleotide_accession_version='NC_000070.6', start_position_on_the_genomic_accession=111972924, end_position_on_the_genomic_accession=111988260, orientation='plus', exon_count=9, OMIM='', no_hdr0=''),
  22687 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=22687, CurrentID=0, Status='live', Symbol='Zpr1', Aliases='AI303781, Zfp259, Znf259', description='ZPR1 zinc finger', other_designations='zinc finger protein 259', map_location='9 A5.2', chromosome='9', genomic_nucleotide_accession_version='NC_000075.6', start_position_on_the_genomic_accession=46273064, end_position_on_the_genomic_accession=46282643, orientation='plus', exon_count=14, OMIM='', no_hdr0=''),
  22695 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=22695, CurrentID=0, Status='live', Symbol='Zfp36', Aliases='Gos24, Nup475, TIS11D, TISII, Tis11, Ttp, Zfp-36', description='zinc finger protein 36', other_designations='TPA-induced sequence 11|growth factor-inducible nuclear protein NUP475|tristetraproline', map_location='7 16.72 cM', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=28376784, end_position_on_the_genomic_accession=28379228, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  22701 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=22701, CurrentID=0, Status='live', Symbol='Zfp41', Aliases='CTfin92, Zfp-41', description='zinc finger protein 41', other_designations='', map_location='15 D3', chromosome='15', genomic_nucleotide_accession_version='NC_000081.6', start_position_on_the_genomic_accession=75616142, end_position_on_the_genomic_accession=75627446, orientation='plus', exon_count=5, OMIM='', no_hdr0=''),
  328563 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=328563, CurrentID=0, Status='live', Symbol='Apol11b', Aliases='A330102K04Rik', description='apolipoprotein L 11b', other_designations='', map_location='15 E1', chromosome='15', genomic_nucleotide_accession_version='NC_000081.6', start_position_on_the_genomic_accession=77633951, end_position_on_the_genomic_accession=77643286, orientation='minus', exon_count=4, OMIM='', no_hdr0=''),
  241196 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=241196, CurrentID=0, Status='live', Symbol='Serpinb13', Aliases='5430417G24, HUR7, HURPIN, PI13, headpin', description='serine (or cysteine) peptidase inhibitor, clade B (ovalbumin), member 13', other_designations='serine (or cysteine) proteinase inhibitor, clade B (ovalbumin), member 13', map_location='1 E2.1', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=106980984, end_position_on_the_genomic_accession=107001195, orientation='plus', exon_count=8, OMIM='', no_hdr0=''),
  100144395 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=100144395, CurrentID=0, Status='live', Symbol='Nct1', Aliases='', description='non-coding in testis 1', other_designations='', map_location='', chromosome='2', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  100144396 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=100144396, CurrentID=0, Status='live', Symbol='Nct2', Aliases='', description='non-coding in testis 2', other_designations='', map_location='', chromosome='2', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  241201 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=241201, CurrentID=0, Status='live', Symbol='Cdh7', Aliases='9330156F07Rik, CDH7L1', description='cadherin 7, type 2', other_designations='', map_location='1 E2.1', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=109982327, end_position_on_the_genomic_accession=110141917, orientation='plus', exon_count=17, OMIM='', no_hdr0=''),
  110158 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=110158, CurrentID=0, Status='live', Symbol='Si-r', Aliases='Suc-1', description='sucrase isomaltase, regulatory', other_designations='', map_location='', chromosome='3', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  231506 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=231506, CurrentID=0, Status='live', Symbol='Lin54', Aliases='4832414L08, AI461788, mKIAA2037', description='lin-54 homolog (C. elegans)', other_designations='', map_location='5 E4', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=100442033, end_position_on_the_genomic_accession=100500649, orientation='minus', exon_count=17, OMIM='', no_hdr0=''),
  399101 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=399101, CurrentID=0, Status='live', Symbol='Snhg3', Aliases='Rnu17d, U17HG', description='small nucleolar RNA host gene 3', other_designations='RNA, U17d small nucleolar|small nucleolar RNA host gene (non-protein coding) 3', map_location='4 D2.3', chromosome='4', genomic_nucleotide_accession_version='NC_000070.6', start_position_on_the_genomic_accession=132351933, end_position_on_the_genomic_accession=132353686, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  102635290 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102635290, CurrentID=0, Status='live', Symbol='Ttc39aos1', Aliases='Gm12750, OTTMUSG00000008290, lincRNA-EPS', description='Ttc39a opposite strand RNA 1', other_designations='lincRNA erythroid prosurvival', map_location='4 51.29 cM', chromosome='4', genomic_nucleotide_accession_version='NC_000070.6', start_position_on_the_genomic_accession=109402273, end_position_on_the_genomic_accession=109406267, orientation='minus', exon_count=5, OMIM='', no_hdr0=''),
  102635415 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102635415, CurrentID=0, Status='live', Symbol='Halr1', Aliases='Gm15055, Haunt, Linchoxa1, OTTMUSG00000018881, linc-Evx1, linc-Hoxa1, linc1547', description='Hoxa adjacent long noncoding RNA 1', other_designations='long intergenic non-coding Hoxa1 regulatory RNA', map_location='6 25.4 cM', chromosome='6', genomic_nucleotide_accession_version='NC_000072.6', start_position_on_the_genomic_accession=52102949, end_position_on_the_genomic_accession=52113684, orientation='plus', exon_count=3, OMIM='', no_hdr0=''),
  102635496 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102635496, CurrentID=0, Status='live', Symbol='Malrd1', Aliases='', description='MAM and LDL receptor class A domain containing 1', other_designations='', map_location='', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=15526479, end_position_on_the_genomic_accession=16255557, orientation='plus', exon_count=39, OMIM='', no_hdr0=''),
  268281 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=268281, CurrentID=0, Status='live', Symbol='Shprh', Aliases='2610103K11Rik, AA450458, AU024614, BC006883, D230017O13Rik, E130018M05', description='SNF2 histone linker PHD RING helicase', other_designations='SNF2, histone-linker, PHD and RING finger domain-containing helicase', map_location='10 A1', chromosome='10', genomic_nucleotide_accession_version='NC_000076.6', start_position_on_the_genomic_accession=11149321, end_position_on_the_genomic_accession=11217595, orientation='plus', exon_count=31, OMIM='', no_hdr0=''),
  268288 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=268288, CurrentID=0, Status='live', Symbol='Samd3', Aliases='Gm623', description='sterile alpha motif domain containing 3', other_designations='SAM domain-containing protein 3', map_location='10 A4', chromosome='10', genomic_nucleotide_accession_version='NC_000076.6', start_position_on_the_genomic_accession=26229618, end_position_on_the_genomic_accession=26272916, orientation='plus', exon_count=14, OMIM='', no_hdr0=''),
  268291 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=268291, CurrentID=0, Status='live', Symbol='Rnf217', Aliases='AU016819, Ibrdc1', description='ring finger protein 217', other_designations='IBR domain containing 1|IBR domain-containing protein 1', map_location='10 A4', chromosome='10', genomic_nucleotide_accession_version='NC_000076.6', start_position_on_the_genomic_accession=31501887, end_position_on_the_genomic_accession=31609725, orientation='minus', exon_count=6, OMIM='', no_hdr0=''),
  268294 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=268294, CurrentID=0, Status='live', Symbol='Zbtb24', Aliases='BC055367, Bif1, Bsg1, ZNF450', description='zinc finger and BTB domain containing 24', other_designations='BMP-induced factor 1|bone morphogenetic protein-induced factor 1|brain specific protein 1|zinc finger protein 450', map_location='10 B1', chromosome='10', genomic_nucleotide_accession_version='NC_000076.6', start_position_on_the_genomic_accession=41450356, end_position_on_the_genomic_accession=41465582, orientation='plus', exon_count=8, OMIM='', no_hdr0=''),
  268297 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=268297, CurrentID=0, Status='live', Symbol='Scml4', Aliases='9330161D17, mFLJ00197', description='sex comb on midleg-like 4 (Drosophila)', other_designations='', map_location='10 B2', chromosome='10', genomic_nucleotide_accession_version='NC_000076.6', start_position_on_the_genomic_accession=42860317, end_position_on_the_genomic_accession=42960782, orientation='plus', exon_count=11, OMIM='', no_hdr0=''),
  268301 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=268301, CurrentID=0, Status='live', Symbol='Sowahc', Aliases='4921515A04Rik, 9430099J10Rik, Ankrd57, C820004L04Rik', description='sosondowah ankyrin repeat domain family member C', other_designations='ankyrin repeat domain 57|ankyrin repeat domain-containing protein 57|protein sosondowah homolog C', map_location='10 B4', chromosome='10', genomic_nucleotide_accession_version='NC_000076.6', start_position_on_the_genomic_accession=59221922, end_position_on_the_genomic_accession=59226434, orientation='plus', exon_count=1, OMIM='', no_hdr0=''),
  241327 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=241327, CurrentID=0, Status='live', Symbol='Olfml2a', Aliases='4932431K08Rik, mFLJ00237', description='olfactomedin-like 2A', other_designations='photomedin-1', map_location='2 B', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=38931980, end_position_on_the_genomic_accession=38960585, orientation='plus', exon_count=8, OMIM='', no_hdr0=''),
  268345 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=268345, CurrentID=0, Status='live', Symbol='Kcnc2', Aliases='AW047325, B230117I07, KShIIIA, Kv3.2', description='potassium voltage gated channel, Shaw-related subfamily, member 2', other_designations='shaw-like potassium channel|voltage-gated potassium channel Kv3.2', map_location='10 60.3 cM', chromosome='10', genomic_nucleotide_accession_version='NC_000076.6', start_position_on_the_genomic_accession=112270459, end_position_on_the_genomic_accession=112466304, orientation='plus', exon_count=12, OMIM='', no_hdr0=''),
  268354 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=268354, CurrentID=0, Status='live', Symbol='Fam19a2', Aliases='6330575M02, FAM19A2 TAFA-2, TAFA2, Tafa-2', description='family with sequence similarity 19, member A2', other_designations='chemokine-like protein TAFA-2', map_location='10 D2', chromosome='10', genomic_nucleotide_accession_version='NC_000076.6', start_position_on_the_genomic_accession=123264076, end_position_on_the_genomic_accession=123741204, orientation='plus', exon_count=8, OMIM='', no_hdr0=''),
  268373 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=268373, CurrentID=0, Status='live', Symbol='Ppia', Aliases='2700098C05, Cphn, CyP-18, CypA', description='peptidylprolyl isomerase A', other_designations='PPIase A|SP18|cyclophilin A|cyclosporin A-binding protein|rotamase A', map_location='11 3.97 cM', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=6415870, end_position_on_the_genomic_accession=6419810, orientation='plus', exon_count=5, OMIM='', no_hdr0=''),
  268379 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=268379, CurrentID=0, Status='live', Symbol='Abca13', Aliases='9830132L24, A930002G16Rik, AI956815', description='ATP-binding cassette, sub-family A (ABC1), member 13', other_designations='ATP-binding cassette transporter', map_location='11 A2', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=9191354, end_position_on_the_genomic_accession=9684871, orientation='plus', exon_count=63, OMIM='', no_hdr0=''),
  268390 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=268390, CurrentID=0, Status='live', Symbol='Ahsa2', Aliases='', description='AHA1, activator of heat shock protein ATPase 2', other_designations='', map_location='11 A3.2', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=23487882, end_position_on_the_genomic_accession=23498039, orientation='minus', exon_count=10, OMIM='', no_hdr0=''),
  268395 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=268395, CurrentID=0, Status='live', Symbol='Mpg', Aliases='9830006D05, AI326268, APNG, Aag, Mid1', description='N-methylpurine-DNA glycosylase', other_designations='3-alkyladenine DNA glycosylase|3-methyladenine DNA glycosidase|3-methyladenine DNA glycosylase|ADPG|alkylpurine-DNA-N-glycosylase', map_location='11 18.83 cM', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=32226425, end_position_on_the_genomic_accession=32232702, orientation='plus', exon_count=5, OMIM='', no_hdr0=''),
  268396 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=268396, CurrentID=0, Status='live', Symbol='Sh3pxd2b', Aliases='G431001E03Rik, TSK4, fad49', description='SH3 and PX domains 2B', other_designations='factor for adipocyte differentiation 49|tyrosine kinase substrate with four SH3 domains', map_location='11 A4', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=32347773, end_position_on_the_genomic_accession=32428183, orientation='plus', exon_count=14, OMIM='', no_hdr0=''),
  268417 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=268417, CurrentID=0, Status='live', Symbol='Zkscan17', Aliases='Nizp1, Zfp496, Znf496', description='zinc finger with KRAB and SCAN domains 17', other_designations='NSD1-interacting zinc finger protein 1|zinc finger protein with KRAB and SCAN domains 17', map_location='11 B1.3', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=59485520, end_position_on_the_genomic_accession=59506640, orientation='minus', exon_count=11, OMIM='', no_hdr0=''),
  268420 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=268420, CurrentID=0, Status='live', Symbol='Alkbh5', Aliases='AW050020, AW215868, Abh5, E130207K11, Ofoxd', description='alkB homolog 5, RNA demethylase', other_designations='alkB, alkylation repair homolog 5|alkylated DNA repair protein alkB homolog 5|alpha-ketoglutarate-dependent dioxygenase alkB homolog 5|oxoglutarate and iron-dependent oxygenase domain containing|probable alpha-ketoglutarate-dependent dioxygenase ABH5', map_location='11 B2', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=60537683, end_position_on_the_genomic_accession=60558512, orientation='plus', exon_count=4, OMIM='', no_hdr0=''),
  399510 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=399510, CurrentID=0, Status='live', Symbol='Map4k5', Aliases='4432415E19Rik, GCKR, KHS, MAPKKKK5', description='mitogen-activated protein kinase kinase kinase kinase 5', other_designations='MAPK/ERK kinase kinase kinase 5|MEK kinase kinase 5|MEKKK 5|map4k5', map_location='12 C3', chromosome='12', genomic_nucleotide_accession_version='NC_000078.6', start_position_on_the_genomic_accession=69803757, end_position_on_the_genomic_accession=69893163, orientation='minus', exon_count=32, OMIM='', no_hdr0=''),
  268445 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=268445, CurrentID=0, Status='live', Symbol='Ankrd13b', Aliases='AW124583, B930093C12Rik', description='ankyrin repeat domain 13b', other_designations='', map_location='11 B5', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=77470485, end_position_on_the_genomic_accession=77489678, orientation='minus', exon_count=16, OMIM='', no_hdr0=''),
  268448 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=268448, CurrentID=0, Status='live', Symbol='Phf12', Aliases='2410142K10Rik, F630045O13, PF1, mKIAA1523', description='PHD finger protein 12', other_designations='PHD factor 1|PHD zinc finger transcription factor|phf12', map_location='11 B5', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=77982754, end_position_on_the_genomic_accession=78030539, orientation='plus', exon_count=16, OMIM='', no_hdr0=''),
  268449 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=268449, CurrentID=0, Status='live', Symbol='Rpl23a', Aliases='BC029892, MDA20', description='ribosomal protein L23A', other_designations='', map_location='11 B5', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=78180935, end_position_on_the_genomic_accession=78183584, orientation='minus', exon_count=5, OMIM='', no_hdr0=''),
  268451 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=268451, CurrentID=0, Status='live', Symbol='Rab11fip4', Aliases='A730072L08Rik, RAB11-FIP4, mKIAA1821', description='RAB11 family interacting protein 4 (class II)', other_designations='FIP4-Rab11|mRab11-FIP4A', map_location='11 46.88 cM', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=79591021, end_position_on_the_genomic_accession=79698023, orientation='plus', exon_count=17, OMIM='', no_hdr0=''),
  268465 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=268465, CurrentID=0, Status='live', Symbol='Eme1', Aliases='6820428D13', description='essential meiotic structure-specific endonuclease 1', other_designations='essential meiotic endonuclease 1 homolog 1', map_location='11 D', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=94644998, end_position_on_the_genomic_accession=94653785, orientation='minus', exon_count=10, OMIM='', no_hdr0=''),
  268469 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=268469, CurrentID=0, Status='live', Symbol='Zfp652', Aliases='9530033F24Rik, ZNF652', description='zinc finger protein 652', other_designations='', map_location='11 D', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=95749067, end_position_on_the_genomic_accession=95764715, orientation='plus', exon_count=5, OMIM='', no_hdr0=''),
  268470 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=268470, CurrentID=0, Status='live', Symbol='Ube2z', Aliases='AW049199, C030047H17Rik, D11Moh35', description='ubiquitin-conjugating enzyme E2Z', other_designations='E2 ubiquitin-conjugating enzyme Z|uba6-specific E2 conjugating enzyme 1|ubiquitin carrier protein Z|ubiquitin-conjugating enzyme E2Z (putative)|ubiquitin-protein ligase Z|use1', map_location='11 59.28 cM', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=96047431, end_position_on_the_genomic_accession=96065364, orientation='minus', exon_count=7, OMIM='', no_hdr0=''),
  399548 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=399548, CurrentID=0, Status='live', Symbol='Scn4b', Aliases='Gm1471', description='sodium channel, type IV, beta', other_designations='sodium channel accessory subunit|sodium channel beta 4 subunit|sodium channel, type IV, beta polypeptide|voltage gated sodium channel beta 4 subunit', map_location='9 A5.2', chromosome='9', genomic_nucleotide_accession_version='NC_000075.6', start_position_on_the_genomic_accession=45139042, end_position_on_the_genomic_accession=45154061, orientation='plus', exon_count=5, OMIM='', no_hdr0=''),
  399549 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=399549, CurrentID=0, Status='live', Symbol='H2-M10.6', Aliases='', description='histocompatibility 2, M region locus 10.6', other_designations='', map_location='17 B1', chromosome='17', genomic_nucleotide_accession_version='NC_000083.6', start_position_on_the_genomic_accession=36812175, end_position_on_the_genomic_accession=36815566, orientation='plus', exon_count=6, OMIM='', no_hdr0=''),
  268480 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=268480, CurrentID=0, Status='live', Symbol='Rapgefl1', Aliases='B230105J10', description='Rap guanine nucleotide exchange factor (GEF)-like 1', other_designations='', map_location='11 D', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=98836785, end_position_on_the_genomic_accession=98853006, orientation='plus', exon_count=15, OMIM='', no_hdr0=''),
  268481 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=268481, CurrentID=0, Status='live', Symbol='Krt222', Aliases='6330509G02Rik', description='keratin 222', other_designations='keratin-222', map_location='11 D', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=99232761, end_position_on_the_genomic_accession=99244281, orientation='minus', exon_count=6, OMIM='', no_hdr0=''),
  268482 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=268482, CurrentID=0, Status='live', Symbol='Krt12', Aliases='AI835216, K12, Krt-12, Krt1-12', description='keratin 12', other_designations='CK-12|Keratin, type I cytoskeletal 12 (Cytokeratin 12)|cytokeratin-12|keratin complex 1, acidic, gene 12|keratin-12', map_location='11 62.92 cM', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=99415664, end_position_on_the_genomic_accession=99422593, orientation='minus', exon_count=9, OMIM='', no_hdr0=''),
  399558 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=399558, CurrentID=0, Status='live', Symbol='Flrt2', Aliases='', description='fibronectin leucine rich transmembrane protein 2', other_designations='', map_location='12 E', chromosome='12', genomic_nucleotide_accession_version='NC_000078.6', start_position_on_the_genomic_accession=95692038, end_position_on_the_genomic_accession=95785215, orientation='plus', exon_count=4, OMIM='', no_hdr0=''),
  268490 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=268490, CurrentID=0, Status='live', Symbol='Lsm12', Aliases='1110032E16Rik, 1110059P07, 2600001B17Rik', description='LSM12 homolog', other_designations='', map_location='11 D', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=102163489, end_position_on_the_genomic_accession=102186270, orientation='minus', exon_count=6, OMIM='', no_hdr0=''),
  268491 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=268491, CurrentID=0, Status='live', Symbol='Meioc', Aliases='Gm1564, Gm663', description='meiosis specific with coiled-coil domain', other_designations='', map_location='11 E1', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=102664966, end_position_on_the_genomic_accession=102682240, orientation='plus', exon_count=8, OMIM='', no_hdr0=''),
  399566 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=399566, CurrentID=0, Status='live', Symbol='Btbd6', Aliases='', description='BTB (POZ) domain containing 6', other_designations='', map_location='12 F1', chromosome='12', genomic_nucleotide_accession_version='NC_000078.6', start_position_on_the_genomic_accession=112974998, end_position_on_the_genomic_accession=112979493, orientation='plus', exon_count=5, OMIM='', no_hdr0=''),
  399568 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=399568, CurrentID=0, Status='live', Symbol='BC052040', Aliases='', description='cDNA sequence BC052040', other_designations='', map_location='2 E4', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=115581618, end_position_on_the_genomic_accession=115778768, orientation='plus', exon_count=14, OMIM='', no_hdr0=''),
  268510 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=268510, CurrentID=0, Status='live', Symbol='Mgat5b', Aliases='C330018B01, GnT-IX, mGnTVB', description='mannoside acetylglucosaminyltransferase 5, isoenzyme B', other_designations='GNT-Vb|N-acetylglucosaminyl-transferase Vb|N-acetylglucosaminyltranferase VB|N-acetylglucosaminyltransferase IX|UDP-N-acetylglucosamine: alpha1,6-D-mannoside beta1,6-N-acetylglucosaminyltransferase b|alpha-mannoside beta-1,6-N-acetylglucosaminyltransferase B|beta1,6-N-acetylglucosaminyltransferase IX (GnT-IX)|glcNAc-T Vb|mannoside acetylglucosaminyltransferase 5B', map_location='11 E2', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=116918856, end_position_on_the_genomic_accession=116986944, orientation='plus', exon_count=18, OMIM='', no_hdr0=''),
  268512 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=268512, CurrentID=0, Status='live', Symbol='Slc26a11', Aliases='F630021I08Rik', description='solute carrier family 26, member 11', other_designations='anion exchanger Slc26a11|novel sulfate transporter protein (Slc26a11)|slc26a11', map_location='11 E2', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=119355532, end_position_on_the_genomic_accession=119381076, orientation='plus', exon_count=17, OMIM='', no_hdr0=''),
  268515 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=268515, CurrentID=0, Status='live', Symbol='Bahcc1', Aliases='B930044J06, BC060615', description='BAH domain and coiled-coil containing 1', other_designations='', map_location='11 E2', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=120232904, end_position_on_the_genomic_accession=120292297, orientation='plus', exon_count=31, OMIM='', no_hdr0=''),
  399591 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=399591, CurrentID=0, Status='live', Symbol='Tmsb15l', Aliases='4930488E11Rik, Tb15r, Tmsb15b1-Tmsb15b2, Tmsb15r', description='thymosin beta 15b like', other_designations='Tmsb15b1-Tmsb15b2 readthrough transcript', map_location='X F1', chromosome='X', genomic_nucleotide_accession_version='NC_000086.7', start_position_on_the_genomic_accession=136954988, end_position_on_the_genomic_accession=136976874, orientation='minus', exon_count=4, OMIM='', no_hdr0=''),
  399599 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=399599, CurrentID=0, Status='live', Symbol='Ccdc87', Aliases='4931419P11Rik', description='coiled-coil domain containing 87', other_designations='', map_location='19 A', chromosome='19', genomic_nucleotide_accession_version='NC_000085.6', start_position_on_the_genomic_accession=4839366, end_position_on_the_genomic_accession=4842528, orientation='plus', exon_count=1, OMIM='', no_hdr0=''),
  399603 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=399603, CurrentID=0, Status='live', Symbol='Fam84b', Aliases='BF642811, D330050I23Rik', description='family with sequence similarity 84, member B', other_designations='', map_location='15 D1', chromosome='15', genomic_nucleotide_accession_version='NC_000081.6', start_position_on_the_genomic_accession=60818996, end_position_on_the_genomic_accession=60825080, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  268534 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=268534, CurrentID=0, Status='live', Symbol='Sntg2', Aliases='2210008K22Rik, 9530013L23, BB121248', description='syntrophin, gamma 2', other_designations='G2SYN|SYN5|syntrophin-5', map_location='12 B1', chromosome='12', genomic_nucleotide_accession_version='NC_000078.6', start_position_on_the_genomic_accession=30174480, end_position_on_the_genomic_accession=30373392, orientation='minus', exon_count=19, OMIM='', no_hdr0=''),
  268564 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=268564, CurrentID=0, Status='live', Symbol='Zbtb1', Aliases='9430077A12, AI256369, Bsg2, C430003J21Rik', description='zinc finger and BTB domain containing 1', other_designations='brain specific protein 2', map_location='12 C3', chromosome='12', genomic_nucleotide_accession_version='NC_000078.6', start_position_on_the_genomic_accession=76370192, end_position_on_the_genomic_accession=76396955, orientation='plus', exon_count=5, OMIM='', no_hdr0=''),
  268566 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=268566, CurrentID=0, Status='live', Symbol='Gphn', Aliases='5730552E08Rik, AI662856, BC027112, C230040D23, GPH, GPHRYN, geph', description='gephyrin', other_designations='', map_location='12 D2', chromosome='12', genomic_nucleotide_accession_version='NC_000078.6', start_position_on_the_genomic_accession=78224153, end_position_on_the_genomic_accession=78684772, orientation='plus', exon_count=27, OMIM='', no_hdr0=''),
  268567 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=268567, CurrentID=0, Status='live', Symbol='Tmem229b', Aliases='6330442E10Rik, 9830138K24, AU019070', description='transmembrane protein 229B', other_designations='', map_location='12 C3', chromosome='12', genomic_nucleotide_accession_version='NC_000078.6', start_position_on_the_genomic_accession=78961795, end_position_on_the_genomic_accession=79007659, orientation='minus', exon_count=7, OMIM='', no_hdr0=''),
  268591 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=268591, CurrentID=0, Status='live', Symbol='Serpina5', Aliases='4933415L04, PAI-3, Pci', description='serine (or cysteine) peptidase inhibitor, clade A, member 5', other_designations='PAI3|alpha-1 antiproteinase|antitrypsin|plasminogen activator inhibitor 3|plasminogen activator inhibitor-3|protein C inhibitor|serine (or cysteine) proteinase inhibitor, clade A, member 5|serpin A5', map_location='12 F1', chromosome='12', genomic_nucleotide_accession_version='NC_000078.6', start_position_on_the_genomic_accession=104099313, end_position_on_the_genomic_accession=104106138, orientation='plus', exon_count=6, OMIM='', no_hdr0=''),
  268595 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=268595, CurrentID=0, Status='live', Symbol='D430019H16Rik', Aliases='AI852661', description='RIKEN cDNA D430019H16 gene', other_designations='', map_location='12 E', chromosome='12', genomic_nucleotide_accession_version='NC_000078.6', start_position_on_the_genomic_accession=105453856, end_position_on_the_genomic_accession=105493095, orientation='plus', exon_count=3, OMIM='', no_hdr0=''),
  399673 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=399673, CurrentID=0, Status='live', Symbol='Tdpoz2', Aliases='', description='TD and POZ domain containing 2', other_designations='TD and POZ domain containing gene 2|tdpoz2', map_location='3 F2.1', chromosome='3', genomic_nucleotide_accession_version='NC_000069.6', start_position_on_the_genomic_accession=93651542, end_position_on_the_genomic_accession=93652686, orientation='minus', exon_count=1, OMIM='', no_hdr0=''),
  399674 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=399674, CurrentID=0, Status='live', Symbol='Tdpoz3', Aliases='', description='TD and POZ domain containing 3', other_designations='TD and POZ domain containing gene 3|tdpoz3', map_location='3 F2.1', chromosome='3', genomic_nucleotide_accession_version='NC_000069.6', start_position_on_the_genomic_accession=93826020, end_position_on_the_genomic_accession=93827117, orientation='plus', exon_count=1, OMIM='', no_hdr0=''),
  399675 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=399675, CurrentID=0, Status='live', Symbol='Tdpoz4', Aliases='', description='TD and POZ domain containing 4', other_designations='tdpoz4', map_location='3 F2.1', chromosome='3', genomic_nucleotide_accession_version='NC_000069.6', start_position_on_the_genomic_accession=93796398, end_position_on_the_genomic_accession=93797510, orientation='plus', exon_count=1, OMIM='', no_hdr0=''),
  399676 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=399676, CurrentID=0, Status='live', Symbol='Tdpoz5', Aliases='', description='TD and POZ domain containing 5', other_designations='TD and POZ domain containing gene 5|tdpoz5', map_location='3 F2.1', chromosome='3', genomic_nucleotide_accession_version='NC_000069.6', start_position_on_the_genomic_accession=93960292, end_position_on_the_genomic_accession=93961314, orientation='minus', exon_count=1, OMIM='', no_hdr0=''),
  268656 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=268656, CurrentID=0, Status='live', Symbol='Sptlc1', Aliases='AW552086, C77762, E030036H05, Lcb1', description='serine palmitoyltransferase, long chain base subunit 1', other_designations='LCB 1|SPT 1|SPT1|long chain base biosynthesis protein 1|serine-palmitoyl-CoA transferase 1', map_location='13 B1', chromosome='13', genomic_nucleotide_accession_version='NC_000079.6', start_position_on_the_genomic_accession=53332748, end_position_on_the_genomic_accession=53377417, orientation='minus', exon_count=16, OMIM='', no_hdr0=''),
  268663 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=268663, CurrentID=0, Status='live', Symbol='Cdhr2', Aliases='Gm624, PC-LKC, Pcdh24', description='cadherin-related family member 2', other_designations='protocadherin 24|protocadherin LKC', map_location='13 B1', chromosome='13', genomic_nucleotide_accession_version='NC_000079.6', start_position_on_the_genomic_accession=54701463, end_position_on_the_genomic_accession=54736662, orientation='plus', exon_count=32, OMIM='', no_hdr0=''),
  268670 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=268670, CurrentID=0, Status='live', Symbol='Zfp759', Aliases='BC028265, Rslcan-8, Rslcan8', description='zinc finger protein 759', other_designations='regulator of sex-limitation candidate 8', map_location='13 34.54 cM', chromosome='13', genomic_nucleotide_accession_version='NC_000079.6', start_position_on_the_genomic_accession=67125128, end_position_on_the_genomic_accession=67142404, orientation='plus', exon_count=7, OMIM='', no_hdr0=''),
  268686 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=268686, CurrentID=0, Status='live', Symbol='S100z', Aliases='Gm625', description='S100 calcium binding protein, zeta', other_designations='', map_location='13 D1', chromosome='13', genomic_nucleotide_accession_version='NC_000079.6', start_position_on_the_genomic_accession=95477266, end_position_on_the_genomic_accession=95479379, orientation='minus', exon_count=4, OMIM='', no_hdr0=''),
  268697 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=268697, CurrentID=0, Status='live', Symbol='Ccnb1', Aliases='Ccnb1-rs1-rs13, CycB1, Cycb-4, Cycb-5, Cycb1-rs1, Ccnb1', description='cyclin B1', other_designations='G2/mitotic-specific cyclin B1|cyclin B1, related sequence 1|cyclin B1, related sequence 13', map_location='13 53.23 cM', chromosome='13', genomic_nucleotide_accession_version='NC_000079.6', start_position_on_the_genomic_accession=100778732, end_position_on_the_genomic_accession=100786543, orientation='minus', exon_count=9, OMIM='', no_hdr0=''),
  110319 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=110319, CurrentID=0, Status='live', Symbol='Tcrb-V8', Aliases='', description='T cell receptor beta, variable 8', other_designations='T-cell receptor beta, variable 8', map_location='', chromosome='6', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  268706 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=268706, CurrentID=0, Status='live', Symbol='Slc38a9', Aliases='4833412L08Rik, 6720411P22Rik, 9130023D20Rik, 9430067K09Rik, A730092C09', description='solute carrier family 38, member 9', other_designations='putative sodium-coupled neutral amino acid transporter 9|solute carrier family 38 member 9', map_location='13 D2.2', chromosome='13', genomic_nucleotide_accession_version='NC_000079.6', start_position_on_the_genomic_accession=112660691, end_position_on_the_genomic_accession=112738752, orientation='plus', exon_count=17, OMIM='', no_hdr0=''),
  268709 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=268709, CurrentID=0, Status='live', Symbol='Fam107a', Aliases='DRR1', description='family with sequence similarity 107, member A', other_designations='', map_location='14 A1', chromosome='14', genomic_nucleotide_accession_version='NC_000080.6', start_position_on_the_genomic_accession=8296270, end_position_on_the_genomic_accession=8318018, orientation='minus', exon_count=6, OMIM='', no_hdr0=''),
  268721 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=268721, CurrentID=0, Status='live', Symbol='Zswim8', Aliases='2310021P13Rik, 4832404P21Rik, Kiaa0913, mKIAA0913', description='zinc finger SWIM-type containing 8', other_designations='', map_location='14 A3', chromosome='14', genomic_nucleotide_accession_version='NC_000080.6', start_position_on_the_genomic_accession=20707319, end_position_on_the_genomic_accession=20723619, orientation='plus', exon_count=27, OMIM='', no_hdr0=''),
  268729 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=268729, CurrentID=0, Status='live', Symbol='Gm626', Aliases='ENSMUSG00000071536, Frmpd2, Gm1582', description='predicted gene 626', other_designations='FERM and PDZ domain containing 2', map_location='14 B', chromosome='14', genomic_nucleotide_accession_version='NC_000080.6', start_position_on_the_genomic_accession=33471696, end_position_on_the_genomic_accession=33575269, orientation='plus', exon_count=31, OMIM='', no_hdr0=''),
  66634 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=66634, CurrentID=0, Status='live', Symbol='Mcm8', Aliases='5730432L01Rik', description='minichromosome maintenance 8 homologous recombination repair factor', other_designations='DNA replication licensing factor MCM8|minichromosome maintenance 8|minichromosome maintenance deficient 8', map_location='2 F3', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=132816141, end_position_on_the_genomic_accession=132844197, orientation='plus', exon_count=19, OMIM='', no_hdr0=''),
  268739 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=268739, CurrentID=0, Status='live', Symbol='Arhgef40', Aliases='E130112L23Rik, Gm669, Solo', description='Rho guanine nucleotide exchange factor (GEF) 40', other_designations='protein SOLO', map_location='14 C2', chromosome='14', genomic_nucleotide_accession_version='NC_000080.6', start_position_on_the_genomic_accession=51984681, end_position_on_the_genomic_accession=52006247, orientation='plus', exon_count=24, OMIM='', no_hdr0=''),
  268741 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=268741, CurrentID=0, Status='live', Symbol='Tox4', Aliases='5730589K01Rik, A630040M18, AA410149, LCP1', description='TOX high mobility group box family member 4', other_designations='epidermal Langerhans cell protein LCP1', map_location='14 C2', chromosome='14', genomic_nucleotide_accession_version='NC_000080.6', start_position_on_the_genomic_accession=52279146, end_position_on_the_genomic_accession=52295509, orientation='plus', exon_count=10, OMIM='', no_hdr0=''),
  268747 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=268747, CurrentID=0, Status='live', Symbol='Lrrc16b', Aliases='mFLJ00240', description='leucine rich repeat containing 16B', other_designations='', map_location='14 C3', chromosome='14', genomic_nucleotide_accession_version='NC_000080.6', start_position_on_the_genomic_accession=55490656, end_position_on_the_genomic_accession=55508272, orientation='plus', exon_count=40, OMIM='', no_hdr0=''),
  268749 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=268749, CurrentID=0, Status='live', Symbol='Rnf31', Aliases='AL033293, BC031509, Flj10111, HOIP, Paul, mFLJ00217', description='ring finger protein 31', other_designations='HOIL-1-interacting protein|putative Ariadne-like ubiquitin ligase', map_location='14 C3', chromosome='14', genomic_nucleotide_accession_version='NC_000080.6', start_position_on_the_genomic_accession=55591713, end_position_on_the_genomic_accession=55603671, orientation='plus', exon_count=21, OMIM='', no_hdr0=''),
  268752 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=268752, CurrentID=0, Status='live', Symbol='Wdfy2', Aliases='5830485M08, B130024L21Rik, ProF, ZFYVE22', description='WD repeat and FYVE domain containing 2', other_designations='WD40- and FYVE domain-containing protein 2|propeller-FYVE protein', map_location='14 D1', chromosome='14', genomic_nucleotide_accession_version='NC_000080.6', start_position_on_the_genomic_accession=62837690, end_position_on_the_genomic_accession=62961509, orientation='plus', exon_count=13, OMIM='', no_hdr0=''),
  268755 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=268755, CurrentID=0, Status='live', Symbol='Mir124a-1hg', Aliases='A930011O12Rik, Rncr3, mir-124-1, mir-3078', description='Mir124-1 host gene (non-protein coding)', other_designations='', map_location='14 D1', chromosome='14', genomic_nucleotide_accession_version='NC_000080.6', start_position_on_the_genomic_accession=64588115, end_position_on_the_genomic_accession=64593961, orientation='plus', exon_count=4, OMIM='', no_hdr0=''),
  268756 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=268756, CurrentID=0, Status='live', Symbol='Gulo', Aliases='5730581M22, AU018375, BC028822, GLO, LGO, sfx, unh, unhip', description='gulonolactone (L-) oxidase', other_designations='L-gulono-gamma-lactone oxidase', map_location='14 D1', chromosome='14', genomic_nucleotide_accession_version='NC_000080.6', start_position_on_the_genomic_accession=65986786, end_position_on_the_genomic_accession=66009254, orientation='minus', exon_count=12, OMIM='', no_hdr0=''),
  268759 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=268759, CurrentID=0, Status='live', Symbol='9930012K11Rik', Aliases='', description='RIKEN cDNA 9930012K11 gene', other_designations='', map_location='14 D2', chromosome='14', genomic_nucleotide_accession_version='NC_000080.6', start_position_on_the_genomic_accession=70154405, end_position_on_the_genomic_accession=70159502, orientation='minus', exon_count=7, OMIM='', no_hdr0=''),
  268780 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=268780, CurrentID=0, Status='live', Symbol='Egflam', Aliases='5930412K08, AU040377', description='EGF-like, fibronectin type III and laminin G domains', other_designations='EGF-like, fibronectin type-III and laminin G-like domain-containing protein|nectican', map_location='15 A1', chromosome='15', genomic_nucleotide_accession_version='NC_000081.6', start_position_on_the_genomic_accession=7206120, end_position_on_the_genomic_accession=7398746, orientation='minus', exon_count=25, OMIM='', no_hdr0=''),
  268782 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=268782, CurrentID=0, Status='live', Symbol='Agxt2', Aliases='AI303810, AI663818', description='alanine-glyoxylate aminotransferase 2', other_designations='(R)-3-amino-2-methylpropionate--pyruvate transaminase|AGT 2|D-AIBAT|beta-ALAAT II|beta-alanine-pyruvate aminotransferase', map_location='15 A1', chromosome='15', genomic_nucleotide_accession_version='NC_000081.6', start_position_on_the_genomic_accession=10358516, end_position_on_the_genomic_accession=10410159, orientation='plus', exon_count=15, OMIM='', no_hdr0=''),
  268783 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=268783, CurrentID=0, Status='live', Symbol='Mtmr12', Aliases='3Pap, 4932703C11, C730015A02Rik, Pip3ap, mKIAA1682', description='myotubularin related protein 12', other_designations='phosphatidylinositol-3 phosphate 3-phosphatase adaptor subunit|phosphatidylinositol-3-phosphatase associated protein', map_location='15 A1', chromosome='15', genomic_nucleotide_accession_version='NC_000081.6', start_position_on_the_genomic_accession=12205094, end_position_on_the_genomic_accession=12272240, orientation='plus', exon_count=16, OMIM='', no_hdr0=''),
  328789 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=328789, CurrentID=0, Status='live', Symbol='Lhfpl5', Aliases='9330179O15Rik, Tmhs, hscy', description='lipoma HMGIC fusion partner-like 5', other_designations='lipoma HMGIC fusion partner-like 5 protein|tetraspan transmembrane protein, hair cell stereocilia', map_location='17 B1', chromosome='17', genomic_nucleotide_accession_version='NC_000083.6', start_position_on_the_genomic_accession=28575371, end_position_on_the_genomic_accession=28583593, orientation='plus', exon_count=4, OMIM='', no_hdr0=''),
  268807 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=268807, CurrentID=0, Status='live', Symbol='Klhl38', Aliases='8230402K04Rik', description='kelch-like 38', other_designations='', map_location='15 D1', chromosome='15', genomic_nucleotide_accession_version='NC_000081.6', start_position_on_the_genomic_accession=58314573, end_position_on_the_genomic_accession=58324169, orientation='minus', exon_count=4, OMIM='', no_hdr0=''),
  268822 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=268822, CurrentID=0, Status='live', Symbol='Adck5', Aliases='A230108P17', description='aarF domain containing kinase 5', other_designations='', map_location='15 D3', chromosome='15', genomic_nucleotide_accession_version='NC_000081.6', start_position_on_the_genomic_accession=76576359, end_position_on_the_genomic_accession=76595812, orientation='plus', exon_count=15, OMIM='', no_hdr0=''),
  268857 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=268857, CurrentID=0, Status='live', Symbol='Nlrc3', Aliases='CLR16.2, D230007K08Rik, mFLJ00348', description='NLR family, CARD domain containing 3', other_designations='Caterpiller 16.2|caterpillar 16.2', map_location='16 A1', chromosome='16', genomic_nucleotide_accession_version='NC_000082.6', start_position_on_the_genomic_accession=3943807, end_position_on_the_genomic_accession=3979032, orientation='minus', exon_count=20, OMIM='', no_hdr0=''),
  268859 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=268859, CurrentID=0, Status='live', Symbol='Rbfox1', Aliases='A2bp, A2bp1, Hrnbp1, fox-1', description='RNA binding protein, fox-1 homolog (C. elegans) 1', other_designations='ataxin 2 binding protein 1|ataxin-2-binding protein 1|fox-1 homolog A|hexaribonucleotide binding protein 1', map_location='16 3.34 cM', chromosome='16', genomic_nucleotide_accession_version='NC_000082.6', start_position_on_the_genomic_accession=5884793, end_position_on_the_genomic_accession=7412480, orientation='plus', exon_count=32, OMIM='', no_hdr0=''),
  268860 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=268860, CurrentID=0, Status='live', Symbol='Abat', Aliases='9630038C02Rik, AI255750, ENSMUSG00000051226, Gabaat, Gabat, Gm9851, I54, Laibat, X61497', description='4-aminobutyrate aminotransferase', other_designations='(S)-3-amino-2-methylpropionate transaminase|4-aminobutyrate transaminase|GABA aminotransferase|GABA transaminase|GABA transferase|beta-alanine oxoglutarate aminotransferase|gamma-amino-N-butyrate transaminase', map_location='16 A3', chromosome='16', genomic_nucleotide_accession_version='NC_000082.6', start_position_on_the_genomic_accession=8513429, end_position_on_the_genomic_accession=8621568, orientation='plus', exon_count=17, OMIM='', no_hdr0=''),
  268878 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=268878, CurrentID=0, Status='live', Symbol='Atp13a5', Aliases='C630015F21Rik', description='ATPase type 13A5', other_designations='P5-ATPase', map_location='16 B2', chromosome='16', genomic_nucleotide_accession_version='NC_000082.6', start_position_on_the_genomic_accession=29231851, end_position_on_the_genomic_accession=29378764, orientation='minus', exon_count=30, OMIM='', no_hdr0=''),
  268880 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=268880, CurrentID=0, Status='live', Symbol='Xxylt1', Aliases='AI480653', description='xyloside xylosyltransferase 1', other_designations='UDP-xylose:alpha-xyloside alpha-1,3-xylosyltransferase', map_location='16 B2', chromosome='16', genomic_nucleotide_accession_version='NC_000082.6', start_position_on_the_genomic_accession=30928348, end_position_on_the_genomic_accession=31081551, orientation='minus', exon_count=6, OMIM='', no_hdr0=''),
  268882 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=268882, CurrentID=0, Status='live', Symbol='Fbxo45', Aliases='2610017J04Rik, AI463119, BC026799', description='F-box protein 45', other_designations='F-box only protein 45|fbxo45|mFbxo45', map_location='16 B2', chromosome='16', genomic_nucleotide_accession_version='NC_000082.6', start_position_on_the_genomic_accession=32230112, end_position_on_the_genomic_accession=32247025, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  268885 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=268885, CurrentID=0, Status='live', Symbol='Stfa2l1', Aliases='', description='stefin A2 like 1', other_designations='', map_location='16 B3', chromosome='16', genomic_nucleotide_accession_version='NC_000082.6', start_position_on_the_genomic_accession=36156811, end_position_on_the_genomic_accession=36161948, orientation='plus', exon_count=3, OMIM='', no_hdr0=''),
  268890 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=268890, CurrentID=0, Status='live', Symbol='Lsamp', Aliases='5430428I19, AW046674, B130007O04Rik, D930023J12Rik, Lam, Lamp', description='limbic system-associated membrane protein', other_designations='', map_location='16 B5', chromosome='16', genomic_nucleotide_accession_version='NC_000082.6', start_position_on_the_genomic_accession=41532788, end_position_on_the_genomic_accession=42181679, orientation='plus', exon_count=9, OMIM='', no_hdr0=''),
  102636131 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102636131, CurrentID=0, Status='live', Symbol='Gm13067', Aliases='OTTMUSG00000010272', description='predicted gene 13067', other_designations='', map_location='4 80.81 cM', chromosome='4', genomic_nucleotide_accession_version='NC_000070.6', start_position_on_the_genomic_accession=150029405, end_position_on_the_genomic_accession=150058717, orientation='plus', exon_count=8, OMIM='', no_hdr0=''),
  268902 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=268902, CurrentID=0, Status='live', Symbol='Robo2', Aliases='2600013A04Rik, 9430089E08Rik, BB097918, D230004I22Rik, mKIAA1568', description='roundabout homolog 2 (Drosophila)', other_designations='', map_location='16 C3.1', chromosome='16', genomic_nucleotide_accession_version='NC_000082.6', start_position_on_the_genomic_accession=73892061, end_position_on_the_genomic_accession=75447298, orientation='minus', exon_count=33, OMIM='', no_hdr0=''),
  268903 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=268903, CurrentID=0, Status='live', Symbol='Nrip1', Aliases='6030458L20Rik, 8430438I05Rik, 9630050P12, AA959574, AW456757, RIP140', description='nuclear receptor interacting protein 1', other_designations='nrip1|nuclear factor RIP140|receptor-interacting protein 140', map_location='16 C3.1', chromosome='16', genomic_nucleotide_accession_version='NC_000082.6', start_position_on_the_genomic_accession=76287403, end_position_on_the_genomic_accession=76374195, orientation='minus', exon_count=6, OMIM='', no_hdr0=''),
  268930 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=268930, CurrentID=0, Status='live', Symbol='Pkmyt1', Aliases='6230424P17, AW209059, Myt1', description='protein kinase, membrane associated tyrosine/threonine 1', other_designations='MYT1 kinase|membrane-associated tyrosine-and threonine-specific cdc2-inhibitory kinase', map_location='17 A3.3', chromosome='17', genomic_nucleotide_accession_version='NC_000083.6', start_position_on_the_genomic_accession=23726336, end_position_on_the_genomic_accession=23736735, orientation='plus', exon_count=9, OMIM='', no_hdr0=''),
  268932 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=268932, CurrentID=0, Status='live', Symbol='Caskin1', Aliases='3300002N10Rik, C130061I24, C630036E02Rik, mKIAA1306', description='CASK interacting protein 1', other_designations='CASK-interacting protein 1', map_location='17 A3.3', chromosome='17', genomic_nucleotide_accession_version='NC_000083.6', start_position_on_the_genomic_accession=24487852, end_position_on_the_genomic_accession=24508909, orientation='plus', exon_count=22, OMIM='', no_hdr0=''),
  268933 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=268933, CurrentID=0, Status='live', Symbol='Wdr24', Aliases='BC037651', description='WD repeat domain 24', other_designations='', map_location='17 A3.3', chromosome='17', genomic_nucleotide_accession_version='NC_000083.6', start_position_on_the_genomic_accession=25823627, end_position_on_the_genomic_accession=25828730, orientation='plus', exon_count=9, OMIM='', no_hdr0=''),
  268934 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=268934, CurrentID=0, Status='live', Symbol='Grm4', Aliases='Gprc1d, mGluR4', description='glutamate receptor, metabotropic 4', other_designations='G protein-coupled receptor GRM4|G protein-coupled receptor, family C, group 1, member D', map_location='17 A3.3', chromosome='17', genomic_nucleotide_accession_version='NC_000083.6', start_position_on_the_genomic_accession=27422387, end_position_on_the_genomic_accession=27513679, orientation='minus', exon_count=17, OMIM='', no_hdr0=''),
  268935 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=268935, CurrentID=0, Status='live', Symbol='Scube3', Aliases='CEGF3, D030038I21Rik', description='signal peptide, CUB domain, EGF-like 3', other_designations='scube3|signal peptide, CUB and EGF-like domain containing protein 3', map_location='17 A3.3', chromosome='17', genomic_nucleotide_accession_version='NC_000083.6', start_position_on_the_genomic_accession=28142100, end_position_on_the_genomic_accession=28174851, orientation='plus', exon_count=23, OMIM='', no_hdr0=''),
  268936 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=268936, CurrentID=0, Status='live', Symbol='Brpf3', Aliases='AI413466, AW493400, mKIAA1286', description='bromodomain and PHD finger containing, 3', other_designations='', map_location='17 A3.3', chromosome='17', genomic_nucleotide_accession_version='NC_000083.6', start_position_on_the_genomic_accession=28800557, end_position_on_the_genomic_accession=28838789, orientation='plus', exon_count=16, OMIM='', no_hdr0=''),
  268949 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=268949, CurrentID=0, Status='live', Symbol='Dpcr1', Aliases='Gm630', description='diffuse panbronchiolitis critical region 1 (human)', other_designations='', map_location='17 B1', chromosome='17', genomic_nucleotide_accession_version='NC_000083.6', start_position_on_the_genomic_accession=35635755, end_position_on_the_genomic_accession=35643695, orientation='minus', exon_count=4, OMIM='', no_hdr0=''),
  268958 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=268958, CurrentID=0, Status='live', Symbol='Capn11', Aliases='', description='calpain 11', other_designations='CANP 11|calcium-activated neutral proteinase 11|calcium-dependent thiol protease|capn11', map_location='17 B3', chromosome='17', genomic_nucleotide_accession_version='NC_000083.6', start_position_on_the_genomic_accession=45630191, end_position_on_the_genomic_accession=45660090, orientation='minus', exon_count=23, OMIM='', no_hdr0=''),
  268970 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=268970, CurrentID=0, Status='live', Symbol='Arhgap28', Aliases='AU044757, AW550892, E130310N06', description='Rho GTPase activating protein 28', other_designations='rho-type GTPase-activating protein 28', map_location='17 E1.2', chromosome='17', genomic_nucleotide_accession_version='NC_000083.6', start_position_on_the_genomic_accession=67842706, end_position_on_the_genomic_accession=68004108, orientation='minus', exon_count=21, OMIM='', no_hdr0=''),
  268973 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=268973, CurrentID=0, Status='live', Symbol='Nlrc4', Aliases='9530011P19Rik, CLAN, CLAN1, CLANA, CLANB, CLANC, CLAND, Card12, IPAF', description='NLR family, CARD domain containing 4', other_designations='caspase recruitment domain family, member 12|caspase recruitment domain-containing protein 12|ice protease-activating factor', map_location='17 E2', chromosome='17', genomic_nucleotide_accession_version='NC_000083.6', start_position_on_the_genomic_accession=74425716, end_position_on_the_genomic_accession=74459143, orientation='minus', exon_count=11, OMIM='', no_hdr0=''),
  268977 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=268977, CurrentID=0, Status='live', Symbol='Ltbp1', Aliases='9430031G15Rik, 9830146M04, Ltbp-1, Tgfb, b2b1000Clo', description='latent transforming growth factor beta binding protein 1', other_designations='TGF-beta1-BP-1|latent TGF beta binding protein|latent transforming growth factor beta binding protein 1L|transforming growth factor beta-1-binding protein 1', map_location='17 E3', chromosome='17', genomic_nucleotide_accession_version='NC_000083.6', start_position_on_the_genomic_accession=75005529, end_position_on_the_genomic_accession=75392967, orientation='plus', exon_count=35, OMIM='', no_hdr0=''),
  268980 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=268980, CurrentID=0, Status='live', Symbol='Strn', Aliases='AU022939, D130055P19', description='striatin, calmodulin binding protein', other_designations='', map_location='17 E3', chromosome='17', genomic_nucleotide_accession_version='NC_000083.6', start_position_on_the_genomic_accession=78649908, end_position_on_the_genomic_accession=78737191, orientation='minus', exon_count=20, OMIM='', no_hdr0=''),
  268996 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=268996, CurrentID=0, Status='live', Symbol='Ss18', Aliases='D130059H17, Ssxt, Syt', description='synovial sarcoma translocation, Chromosome 18', other_designations='synovial sarcoma associated SS18-beta|synovial sarcoma associated SS18-delta|synovial sarcoma associated SS18-gamma|synovial sarcoma, translocated to X chromosome|synovial sarcoma-associated Ss18-alpha', map_location='18 B1', chromosome='18', genomic_nucleotide_accession_version='NC_000084.6', start_position_on_the_genomic_accession=14625629, end_position_on_the_genomic_accession=14683002, orientation='minus', exon_count=11, OMIM='', no_hdr0=''),
  269003 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=269003, CurrentID=0, Status='live', Symbol='Sap130', Aliases='2610304F09Rik, 6720406D06', description='Sin3A associated protein', other_designations='130 kDa Sin3-associated polypeptide|Sin3A associated protein, 130kDa|sin3-associated polypeptide p130', map_location='18 B2', chromosome='18', genomic_nucleotide_accession_version='NC_000084.6', start_position_on_the_genomic_accession=31634327, end_position_on_the_genomic_accession=31723068, orientation='plus', exon_count=23, OMIM='', no_hdr0=''),
  269016 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=269016, CurrentID=0, Status='live', Symbol='Sh3rf2', Aliases='2310046K19, 9130023G24Rik, AI452083, Ppp1r39, RNF158', description='SH3 domain containing ring finger 2', other_designations='RING finger protein 158|SH3 domain-containing RING finger protein 2|protein phosphatase 1 regulatory subunit 39', map_location='18 B3', chromosome='18', genomic_nucleotide_accession_version='NC_000084.6', start_position_on_the_genomic_accession=42051743, end_position_on_the_genomic_accession=42158695, orientation='plus', exon_count=11, OMIM='', no_hdr0=''),
  269019 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=269019, CurrentID=0, Status='live', Symbol='Stk32a', Aliases='A930015B13Rik, YANK1', description='serine/threonine kinase 32A', other_designations='stk32a', map_location='18 B3', chromosome='18', genomic_nucleotide_accession_version='NC_000084.6', start_position_on_the_genomic_accession=43207697, end_position_on_the_genomic_accession=43317481, orientation='plus', exon_count=13, OMIM='', no_hdr0=''),
  269023 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=269023, CurrentID=0, Status='live', Symbol='Zfp608', Aliases='4932417D18Rik, D430007A19Rik, Znf608', description='zinc finger protein 608', other_designations='', map_location='18 D3', chromosome='18', genomic_nucleotide_accession_version='NC_000084.6', start_position_on_the_genomic_accession=54888045, end_position_on_the_genomic_accession=54992598, orientation='minus', exon_count=15, OMIM='', no_hdr0=''),
  102636264 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102636264, CurrentID=0, Status='live', Symbol='Gm33378', Aliases='', description='predicted gene, 33378', other_designations='', map_location='10', chromosome='10', genomic_nucleotide_accession_version='NC_000076.6', start_position_on_the_genomic_accession=82011695, end_position_on_the_genomic_accession=82016869, orientation='plus', exon_count=3, OMIM='', no_hdr0=''),
  269033 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=269033, CurrentID=0, Status='live', Symbol='4930503L19Rik', Aliases='9930107F24, BB148262, Lars, Las2', description='RIKEN cDNA 4930503L19 gene', other_designations='', map_location='18 E2', chromosome='18', genomic_nucleotide_accession_version='NC_000084.6', start_position_on_the_genomic_accession=70452210, end_position_on_the_genomic_accession=70472504, orientation='minus', exon_count=9, OMIM='', no_hdr0=''),
  269037 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=269037, CurrentID=0, Status='live', Symbol='Ctif', Aliases='Gm672', description='CBP80/20-dependent translation initiation factor', other_designations='', map_location='18 E3', chromosome='18', genomic_nucleotide_accession_version='NC_000084.6', start_position_on_the_genomic_accession=75431205, end_position_on_the_genomic_accession=75697696, orientation='minus', exon_count=13, OMIM='', no_hdr0=''),
  66686 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=66686, CurrentID=0, Status='live', Symbol='Dcbld1', Aliases='4631413K11Rik', description='discoidin, CUB and LCCL domain containing 1', other_designations='', map_location='10 B3', chromosome='10', genomic_nucleotide_accession_version='NC_000076.6', start_position_on_the_genomic_accession=52233584, end_position_on_the_genomic_accession=52321378, orientation='plus', exon_count=11, OMIM='', no_hdr0=''),
  269053 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=269053, CurrentID=0, Status='live', Symbol='Gpr152', Aliases='A930009H15Rik, Gm673', description='G protein-coupled receptor 152', other_designations='putative G-protein coupled receptor', map_location='19 A', chromosome='19', genomic_nucleotide_accession_version='NC_000085.6', start_position_on_the_genomic_accession=4139799, end_position_on_the_genomic_accession=4145741, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  269060 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=269060, CurrentID=0, Status='live', Symbol='Dagla', Aliases='Nsddr', description='diacylglycerol lipase, alpha', other_designations='DGL-alpha|neural stem cell-derived dendrite regulator', map_location='19 A', chromosome='19', genomic_nucleotide_accession_version='NC_000085.6', start_position_on_the_genomic_accession=10245265, end_position_on_the_genomic_accession=10304962, orientation='minus', exon_count=21, OMIM='', no_hdr0=''),
  269061 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=269061, CurrentID=0, Status='live', Symbol='Cpsf7', Aliases='5730453I16Rik, AL022757, C330017N18Rik', description='cleavage and polyadenylation specific factor 7', other_designations='', map_location='19 A', chromosome='19', genomic_nucleotide_accession_version='NC_000085.6', start_position_on_the_genomic_accession=10525244, end_position_on_the_genomic_accession=10547735, orientation='plus', exon_count=14, OMIM='', no_hdr0=''),
  66689 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=66689, CurrentID=0, Status='live', Symbol='Klhl28', Aliases='2810440N09Rik, 4122402F11Rik, 4931401E10Rik, Btbd5', description='kelch-like 28', other_designations='BTB (POZ) domain containing 5|BTB/POZ domain-containing protein 5', map_location='12 C1', chromosome='12', genomic_nucleotide_accession_version='NC_000078.6', start_position_on_the_genomic_accession=64942198, end_position_on_the_genomic_accession=64965605, orientation='minus', exon_count=7, OMIM='', no_hdr0=''),
  110380 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=110380, CurrentID=0, Status='live', Symbol='Shroom2', Aliases='4832440C16, Apxl, C630003H05Rik, Shrm2', description='shroom family member 2', other_designations='', map_location='X 68.46 cM', chromosome='X', genomic_nucleotide_accession_version='NC_000086.7', start_position_on_the_genomic_accession=152609509, end_position_on_the_genomic_accession=152770251, orientation='minus', exon_count=13, OMIM='', no_hdr0=''),
  269109 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=269109, CurrentID=0, Status='live', Symbol='Dpp10', Aliases='6430601K09Rik, DPP X, Dprp3', description='dipeptidylpeptidase 10', other_designations='dipeptidyl peptidase X', map_location='1 E2.3', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=123332138, end_position_on_the_genomic_accession=124845960, orientation='minus', exon_count=28, OMIM='', no_hdr0=''),
  269113 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=269113, CurrentID=0, Status='live', Symbol='Nup54', Aliases='3110079L04Rik, 54kDa', description='nucleoporin 54', other_designations='54 kDa nucleoporin|nucleoporin 54kDa|nucleoporin Nup54', map_location='5 E3', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=92415540, end_position_on_the_genomic_accession=92435265, orientation='minus', exon_count=15, OMIM='', no_hdr0=''),
  269116 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=269116, CurrentID=0, Status='live', Symbol='Nfasc', Aliases='AA387016, D430023G06Rik, NF, mKIAA0756', description='neurofascin', other_designations='', map_location='1 57.42 cM', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=132564690, end_position_on_the_genomic_accession=132741834, orientation='minus', exon_count=37, OMIM='', no_hdr0=''),
  269120 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=269120, CurrentID=0, Status='live', Symbol='Optc', Aliases='', description='opticin', other_designations='oculoglycan', map_location='1 58.02 cM', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=133897193, end_position_on_the_genomic_accession=133909714, orientation='minus', exon_count=10, OMIM='', no_hdr0=''),
  269132 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=269132, CurrentID=0, Status='live', Symbol='Colgalt2', Aliases='AI427652, D730024P12, Glt25d2', description='collagen beta(1-O)galactosyltransferase 2', other_designations='glycosyltransferase 25 domain containing 2|glycosyltransferase 25 family member 2|hydroxylysine galactosyltransferase 2', map_location='1 G3', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=152399867, end_position_on_the_genomic_accession=152510695, orientation='plus', exon_count=12, OMIM='', no_hdr0=''),
  328845 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=328845, CurrentID=0, Status='live', Symbol='Acsbg2', Aliases='Bgr', description='acyl-CoA synthetase bubblegum family member 2', other_designations='bubblegum-related protein', map_location='17 D', chromosome='17', genomic_nucleotide_accession_version='NC_000083.6', start_position_on_the_genomic_accession=56843103, end_position_on_the_genomic_accession=56874504, orientation='minus', exon_count=17, OMIM='', no_hdr0=''),
  269152 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=269152, CurrentID=0, Status='live', Symbol='Kif26b', Aliases='4832420M10, BC056349, D230039L06Rik', description='kinesin family member 26B', other_designations='N-11 kinesin|kinesin family protein 26b', map_location='1 83.16 cM', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=178525741, end_position_on_the_genomic_accession=178939200, orientation='plus', exon_count=17, OMIM='', no_hdr0=''),
  269180 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=269180, CurrentID=0, Status='live', Symbol='Inpp4a', Aliases='107kDa, 9630012D15, D130048C09Rik, R74740', description='inositol polyphosphate-4-phosphatase, type I', other_designations='inositol polyphosphate 4-phosphatase type I', map_location='1 15.46 cM', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=37299838, end_position_on_the_genomic_accession=37410740, orientation='plus', exon_count=28, OMIM='', no_hdr0=''),
  269181 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=269181, CurrentID=0, Status='live', Symbol='Mgat4a', Aliases='9530018I07Rik, GnT-IVa, glcNAc-T-IVa', description='mannoside acetylglucosaminyltransferase 4, isoenzyme A', other_designations='N-acetylglucosaminyltransferase IVa|N-glycosyl-oligosaccharide-glycoprotein N-acetylglucosaminyltransferase IVa|UDP-N-acetylglucosamine: alpha-1,3-D-mannoside beta-1,4-N-acetylglucosaminyltransferase IVa', map_location='1 B', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=37439340, end_position_on_the_genomic_accession=37541047, orientation='minus', exon_count=17, OMIM='', no_hdr0=''),
  269198 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=269198, CurrentID=0, Status='live', Symbol='Nbeal1', Aliases='2310076G13Rik, A530050O19Rik, A530083I02Rik, AI662228, ALS2CR17', description='neurobeachin like 1', other_designations='', map_location='1 C2', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=60178629, end_position_on_the_genomic_accession=60334705, orientation='plus', exon_count=62, OMIM='', no_hdr0=''),
  269209 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=269209, CurrentID=0, Status='live', Symbol='Stk36', Aliases='1700112N14Rik, B930045J24, FU, Fused, mKIAA1278', description='serine/threonine kinase 36', other_designations='fused homolog|serine/threonine kinase 36 (fused homolog, Drosophila)|stk36', map_location='1 C3', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=74601450, end_position_on_the_genomic_accession=74636894, orientation='plus', exon_count=28, OMIM='', no_hdr0=''),
  269224 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=269224, CurrentID=0, Status='live', Symbol='Pask', Aliases='mKIAA0135', description='PAS domain containing serine/threonine kinase', other_designations='PAS-kinase|paskin', map_location='1 D', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=93309437, end_position_on_the_genomic_accession=93343350, orientation='minus', exon_count=21, OMIM='', no_hdr0=''),
  269233 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=269233, CurrentID=0, Status='live', Symbol='Fam171a1', Aliases='9630050M13Rik, AA409679', description='family with sequence similarity 171, member A1', other_designations='', map_location='2 A1', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=3114202, end_position_on_the_genomic_accession=3227809, orientation='plus', exon_count=9, OMIM='', no_hdr0=''),
  269252 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=269252, CurrentID=0, Status='live', Symbol='Gtf3c4', Aliases='5330400C03, AI426938, AU014771, AU017413, KAT12, TFIIIC90', description='general transcription factor IIIC, polypeptide 4', other_designations='TF3C-delta|TFIIIC 90 kDa subunit|general transcription factor IIIC 4|transcription factor IIIC 90 kDa subunit|transcription factor IIIC subunit delta', map_location='2 A3', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=28822299, end_position_on_the_genomic_accession=28840360, orientation='minus', exon_count=7, OMIM='', no_hdr0=''),
  269254 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=269254, CurrentID=0, Status='live', Symbol='Setx', Aliases='A130090N03, A930037J23Rik, AOA2, AW060766, Als4, SCAR1, Sen1, mKIAA0625', description='senataxin', other_designations='SEN1 homolog|amyotrophic lateral sclerosis 4 homolog|amyotrophic lateral sclerosis 4 protein homolog', map_location='2 A3', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=29122588, end_position_on_the_genomic_accession=29182471, orientation='plus', exon_count=31, OMIM='', no_hdr0=''),
  269261 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=269261, CurrentID=0, Status='live', Symbol='Rpl12', Aliases='E430018F03', description='ribosomal protein L12', other_designations='', map_location='2 B', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=32961712, end_position_on_the_genomic_accession=32964045, orientation='plus', exon_count=7, OMIM='', no_hdr0=''),
  269275 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=269275, CurrentID=0, Status='live', Symbol='Acvr1c', Aliases='ACVRLK7, ALK7, Alk-7, C230097P10', description='activin A receptor, type IC', other_designations='ACTR-IC|activin receptor type IC|activin receptor-like kinase 7|acvr1c', map_location='2 C1.1', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=58267453, end_position_on_the_genomic_accession=58357896, orientation='minus', exon_count=11, OMIM='', no_hdr0=''),
  241489 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=241489, CurrentID=0, Status='live', Symbol='Pde11a', Aliases='6330414F14Rik, A630086N24Rik, Gm350, PDE11A1', description='phosphodiesterase 11A', other_designations='cAMP and cGMP phosphodiesterase 11A', map_location='2 C3', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=75987026, end_position_on_the_genomic_accession=76339145, orientation='minus', exon_count=21, OMIM='', no_hdr0=''),
  269295 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=269295, CurrentID=0, Status='live', Symbol='Rtn4rl2', Aliases='Ngr2, Ngrh1, Ngrl3', description='reticulon 4 receptor-like 2', other_designations='nogo receptor-like 3|nogo-66 receptor homolog 1|nogo-66 receptor-related protein 2|rtn4rl2', map_location='2 D', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=84871309, end_position_on_the_genomic_accession=84888507, orientation='minus', exon_count=8, OMIM='', no_hdr0=''),
  269328 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=269328, CurrentID=0, Status='live', Symbol='Muc15', Aliases='4732460E09, D730046L02Rik, MUC-15', description='mucin 15', other_designations='', map_location='2 E3', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=110721494, end_position_on_the_genomic_accession=110739537, orientation='plus', exon_count=4, OMIM='', no_hdr0=''),
  269336 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=269336, CurrentID=0, Status='live', Symbol='Ccdc32', Aliases='Gm631', description='coiled-coil domain containing 32', other_designations='', map_location='2 E5', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=119017779, end_position_on_the_genomic_accession=119029406, orientation='minus', exon_count=4, OMIM='', no_hdr0=''),
  269338 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=269338, CurrentID=0, Status='live', Symbol='Vps39', Aliases='A230065P22Rik, AW743070, Vam6, Vam6P, mVam6', description='vacuolar protein sorting 39 (yeast)', other_designations='', map_location='2 E5', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=120316461, end_position_on_the_genomic_accession=120353144, orientation='minus', exon_count=27, OMIM='', no_hdr0=''),
  269344 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=269344, CurrentID=0, Status='live', Symbol='Ell3', Aliases='A930015D22Rik', description='elongation factor RNA polymerase II-like 3', other_designations='', map_location='2 E5', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=121439025, end_position_on_the_genomic_accession=121444278, orientation='minus', exon_count=12, OMIM='', no_hdr0=''),
  269346 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=269346, CurrentID=0, Status='live', Symbol='Slc28a2', Aliases='2010208B10Rik, B430217P18, BB152493, Cnt2', description='solute carrier family 28 (sodium-coupled nucleoside transporter), member 2', other_designations='CNT 2|Na(+)/nucleoside cotransporter 2|SPNT|concentrative nucleoside transporter 2|purine-selective Na+ nucleoside cotransporter|sodium-coupled nucleoside transporter 2|sodium/purine nucleoside cotransporter|solute carrier family 28 member 2', map_location='2 E3', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=122426355, end_position_on_the_genomic_accession=122461152, orientation='plus', exon_count=19, OMIM='', no_hdr0=''),
  269356 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=269356, CurrentID=0, Status='live', Symbol='Slc4a11', Aliases='AI503023, BTR1, NaBC1', description='solute carrier family 4, sodium bicarbonate transporter-like, member 11', other_designations='Sodium borate cotransporter 1|Solute carrier family 4 member 11|bicarbonate transporter-related protein 1', map_location='2 F1', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=130684107, end_position_on_the_genomic_accession=130697519, orientation='minus', exon_count=21, OMIM='', no_hdr0=''),
  269378 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=269378, CurrentID=0, Status='live', Symbol='Ahcy', Aliases='AA987153, AL024110, CuBP, SAHH', description='S-adenosylhomocysteine hydrolase', other_designations='S-adenosyl-L-homocysteine hydrolase|adoHcyase|liver copper-binding protein', map_location='2 76.94 cM', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=155059310, end_position_on_the_genomic_accession=155074497, orientation='minus', exon_count=10, OMIM='', no_hdr0=''),
  269389 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=269389, CurrentID=0, Status='live', Symbol='Tox2', Aliases='AI851523, AV026525, BI987407, Gcx1, RxHMG1', description='TOX high mobility group box family member 2', other_designations='granulosa cell HMG-box protein 1', map_location='2', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=163202643, end_position_on_the_genomic_accession=163323102, orientation='plus', exon_count=13, OMIM='', no_hdr0=''),
  269397 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=269397, CurrentID=0, Status='live', Symbol='Ss18l1', Aliases='A230053O16Rik, CREST', description='synovial sarcoma translocation gene on chromosome 18-like 1', other_designations='SS18-like protein 1', map_location='2 H4', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=180042483, end_position_on_the_genomic_accession=180070201, orientation='plus', exon_count=12, OMIM='', no_hdr0=''),
  269400 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=269400, CurrentID=0, Status='live', Symbol='Rtel1', Aliases='AI451565, AW540478, Rtel', description='regulator of telomere elongation helicase 1', other_designations='DEAH helicase|regulator of telomere length', map_location='2 H4', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=181288028, end_position_on_the_genomic_accession=181356616, orientation='plus', exon_count=39, OMIM='', no_hdr0=''),
  269401 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=269401, CurrentID=0, Status='live', Symbol='Zfp512b', Aliases='Gm632, Znf512b', description='zinc finger protein 512B', other_designations='', map_location='2 H4', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=181582103, end_position_on_the_genomic_accession=181592798, orientation='minus', exon_count=17, OMIM='', no_hdr0=''),
  269423 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=269423, CurrentID=0, Status='live', Symbol='Abhd18', Aliases='2310068E01Rik, 3110057O12Rik, AI645591', description='abhydrolase domain containing 18', other_designations='', map_location='3 C', chromosome='3', genomic_nucleotide_accession_version='NC_000069.6', start_position_on_the_genomic_accession=40894249, end_position_on_the_genomic_accession=40937738, orientation='plus', exon_count=14, OMIM='', no_hdr0=''),
  269424 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=269424, CurrentID=0, Status='live', Symbol='Jade1', Aliases='AU041499, D530048A03Rik, Phf17, mKIAA1807', description='jade family PHD finger 1', other_designations='Jade1 PHD finger protein|PHD finger protein 17|jade family PHD finger protein 1', map_location='3 B', chromosome='3', genomic_nucleotide_accession_version='NC_000069.6', start_position_on_the_genomic_accession=41555734, end_position_on_the_genomic_accession=41616864, orientation='plus', exon_count=15, OMIM='', no_hdr0=''),
  269437 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=269437, CurrentID=0, Status='live', Symbol='Plch1', Aliases='BC042549, PLC-eta-1, PLCeta1, Plcl3', description='phospholipase C, eta 1', other_designations='phosphoinositide phospholipase C-eta-1|phospholipase C-like protein 3', map_location='3 E1', chromosome='3', genomic_nucleotide_accession_version='NC_000069.6', start_position_on_the_genomic_accession=63696232, end_position_on_the_genomic_accession=63899677, orientation='minus', exon_count=32, OMIM='', no_hdr0=''),
  269470 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=269470, CurrentID=0, Status='live', Symbol='Wdr3', Aliases='AW546279, D030020G18Rik', description='WD repeat domain 3', other_designations='', map_location='3 F2.2', chromosome='3', genomic_nucleotide_accession_version='NC_000069.6', start_position_on_the_genomic_accession=100138180, end_position_on_the_genomic_accession=100162403, orientation='minus', exon_count=27, OMIM='', no_hdr0=''),
  269473 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=269473, CurrentID=0, Status='live', Symbol='Lrig2', Aliases='4632419I10Rik, BB096938, LIG-2', description='leucine-rich repeats and immunoglobulin-like domains 2', other_designations='', map_location='3 F2.2', chromosome='3', genomic_nucleotide_accession_version='NC_000069.6', start_position_on_the_genomic_accession=104453980, end_position_on_the_genomic_accession=104511938, orientation='minus', exon_count=19, OMIM='', no_hdr0=''),
  269513 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=269513, CurrentID=0, Status='live', Symbol='Nkain3', Aliases='C530048M05, E130310K16Rik', description='Na+/K+ transporting ATPase interacting 3', other_designations='Na(+)/K(+)-transporting ATPase subunit beta-1-interacting protein 3', map_location='4 A3', chromosome='4', genomic_nucleotide_accession_version='NC_000070.6', start_position_on_the_genomic_accession=20118336, end_position_on_the_genomic_accession=20780310, orientation='minus', exon_count=9, OMIM='', no_hdr0=''),
  269514 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=269514, CurrentID=0, Status='live', Symbol='Fbxl4', Aliases='AI836810, FBL4, FBL5', description='F-box and leucine-rich repeat protein 4', other_designations='', map_location='4 A3', chromosome='4', genomic_nucleotide_accession_version='NC_000070.6', start_position_on_the_genomic_accession=22357543, end_position_on_the_genomic_accession=22434091, orientation='plus', exon_count=12, OMIM='', no_hdr0=''),
  269523 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=269523, CurrentID=0, Status='live', Symbol='Vcp', Aliases='3110001E05, CDC48, p97, p97/VCP', description='valosin containing protein', other_designations='15S Mg(2+)-ATPase p97 subunit|AAA ATPase p97|Inv protein|TER ATPase|homolog of yeast cdc48|valosin-containing protein', map_location='4 22.95 cM', chromosome='4', genomic_nucleotide_accession_version='NC_000070.6', start_position_on_the_genomic_accession=42979964, end_position_on_the_genomic_accession=43000507, orientation='minus', exon_count=17, OMIM='', no_hdr0=''),
  269529 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=269529, CurrentID=0, Status='live', Symbol='Fbxo10', Aliases='FBX10, Gm634', description='F-box protein 10', other_designations='', map_location='4 B1', chromosome='4', genomic_nucleotide_accession_version='NC_000070.6', start_position_on_the_genomic_accession=45034248, end_position_on_the_genomic_accession=45084604, orientation='minus', exon_count=11, OMIM='', no_hdr0=''),
  269536 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=269536, CurrentID=0, Status='live', Symbol='Tex10', Aliases='2610206N19Rik, 2810462N03Rik, BC006867', description='testis expressed gene 10', other_designations='clone 18330', map_location='4 B1', chromosome='4', genomic_nucleotide_accession_version='NC_000070.6', start_position_on_the_genomic_accession=48430858, end_position_on_the_genomic_accession=48473464, orientation='minus', exon_count=17, OMIM='', no_hdr0=''),
  269582 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=269582, CurrentID=0, Status='live', Symbol='Clspn', Aliases='B130025E01, C85083, E130314M08Rik', description='claspin', other_designations='claspin homolog', map_location='4 D2.2', chromosome='4', genomic_nucleotide_accession_version='NC_000070.6', start_position_on_the_genomic_accession=126556951, end_position_on_the_genomic_accession=126594533, orientation='plus', exon_count=26, OMIM='', no_hdr0=''),
  269585 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=269585, CurrentID=0, Status='live', Symbol='Zscan20', Aliases='C130001F22, Zfp31, Zkscan20', description='zinc finger and SCAN domains 20', other_designations='zinc finger protein 31|zinc finger with KRAB and SCAN domains 20', map_location='4 D2.2', chromosome='4', genomic_nucleotide_accession_version='NC_000070.6', start_position_on_the_genomic_accession=128578670, end_position_on_the_genomic_accession=128610172, orientation='minus', exon_count=12, OMIM='', no_hdr0=''),
  269587 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=269587, CurrentID=0, Status='live', Symbol='Epb41', Aliases='4.1R, AI415518, D4Ertd442e, Elp-1, Elp1, Epb4.1, mKIAA4056', description='erythrocyte membrane protein band 4.1', other_designations='P4.1|Protein 4.1R|band 4.1|erythrocyte protein band 4.1', map_location='4 64.54 cM', chromosome='4', genomic_nucleotide_accession_version='NC_000070.6', start_position_on_the_genomic_accession=131923413, end_position_on_the_genomic_accession=132075579, orientation='minus', exon_count=26, OMIM='', no_hdr0=''),
  269589 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=269589, CurrentID=0, Status='live', Symbol='Sytl1', Aliases='9030417L18, PSGL-1, Slp1', description='synaptotagmin-like 1', other_designations='exophilin-7', map_location='4 D2.3', chromosome='4', genomic_nucleotide_accession_version='NC_000070.6', start_position_on_the_genomic_accession=133253090, end_position_on_the_genomic_accession=133263087, orientation='minus', exon_count=16, OMIM='', no_hdr0=''),
  269593 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=269593, CurrentID=0, Status='live', Symbol='Luzp1', Aliases='2700072H04Rik, AI266952, Luzp, mFLJ00226', description='leucine zipper protein 1', other_designations='leucine zipper motif-containing protein', map_location='4 68.8 cM', chromosome='4', genomic_nucleotide_accession_version='NC_000070.6', start_position_on_the_genomic_accession=136469749, end_position_on_the_genomic_accession=136554725, orientation='plus', exon_count=7, OMIM='', no_hdr0=''),
  269604 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=269604, CurrentID=0, Status='live', Symbol='Gpr157', Aliases='F730108M23Rik', description='G protein-coupled receptor 157', other_designations='novel 7 transmembrane receptor (Secretin family) domain containing protein', map_location='4 E2', chromosome='4', genomic_nucleotide_accession_version='NC_000070.6', start_position_on_the_genomic_accession=150087503, end_position_on_the_genomic_accession=150105927, orientation='plus', exon_count=4, OMIM='', no_hdr0=''),
  269608 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=269608, CurrentID=0, Status='live', Symbol='Plekhg5', Aliases='BC023181, Syx', description='pleckstrin homology domain containing, family G (with RhoGef domain) member 5', other_designations='PH domain-containing family G member 5|RhoA-specific guanine exchange factor SYX1|RhoA-specific guanine exchange factor SYX2|synectin-binding RhoA exchange factor', map_location='4 E2', chromosome='4', genomic_nucleotide_accession_version='NC_000070.6', start_position_on_the_genomic_accession=152072433, end_position_on_the_genomic_accession=152115404, orientation='plus', exon_count=25, OMIM='', no_hdr0=''),
  269610 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=269610, CurrentID=0, Status='live', Symbol='Chd5', Aliases='4930532L22Rik, AW060752, B230399N07Rik, CHD-5', description='chromodomain helicase DNA binding protein 5', other_designations='ATP-dependent helicase CHD5', map_location='4 E2', chromosome='4', genomic_nucleotide_accession_version='NC_000070.6', start_position_on_the_genomic_accession=152338651, end_position_on_the_genomic_accession=152390194, orientation='plus', exon_count=42, OMIM='', no_hdr0=''),
  269614 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=269614, CurrentID=0, Status='live', Symbol='Pank4', Aliases='D030031I12Rik, R75150', description='pantothenate kinase 4', other_designations='pantothenic acid kinase 4', map_location='4 E2', chromosome='4', genomic_nucleotide_accession_version='NC_000070.6', start_position_on_the_genomic_accession=154963948, end_position_on_the_genomic_accession=154980938, orientation='plus', exon_count=19, OMIM='', no_hdr0=''),
  269615 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=269615, CurrentID=0, Status='live', Symbol='Plch2', Aliases='A930027K05Rik, PLCeta2, Plc-eta2, Plcl4', description='phospholipase C, eta 2', other_designations='phosphoinositide phospholipase C-eta-2|phosphoinositide phospholipase C-like 4|phospholipase C-like protein 4', map_location='4 E2', chromosome='4', genomic_nucleotide_accession_version='NC_000070.6', start_position_on_the_genomic_accession=154983115, end_position_on_the_genomic_accession=155064091, orientation='minus', exon_count=30, OMIM='', no_hdr0=''),
  269623 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=269623, CurrentID=0, Status='live', Symbol='Rbm48', Aliases='AW548102, C030048B08Rik', description='RNA binding motif protein 48', other_designations='UPF0712 protein C7orf64 homolog', map_location='5 A1', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=3583978, end_position_on_the_genomic_accession=3596547, orientation='minus', exon_count=5, OMIM='', no_hdr0=''),
  269629 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=269629, CurrentID=0, Status='live', Symbol='Lhfpl3', Aliases='A930031L14Rik', description='lipoma HMGIC fusion partner-like 3', other_designations='', map_location='5 A3', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=22745636, end_position_on_the_genomic_accession=23275597, orientation='plus', exon_count=4, OMIM='', no_hdr0=''),
  269630 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=269630, CurrentID=0, Status='live', Symbol='5031425E22Rik', Aliases='', description='RIKEN cDNA 5031425E22 gene', other_designations='', map_location='5 A3', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=23431808, end_position_on_the_genomic_accession=23434353, orientation='minus', exon_count=1, OMIM='', no_hdr0=''),
  269633 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=269633, CurrentID=0, Status='live', Symbol='Wdr86', Aliases='2810046M22Rik, BC059069', description='WD repeat domain 86', other_designations='', map_location='5 A3', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=24704229, end_position_on_the_genomic_accession=24730698, orientation='minus', exon_count=9, OMIM='', no_hdr0=''),
  269637 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=269637, CurrentID=0, Status='live', Symbol='Cnpy1', Aliases='1500012D20Rik, 9630008K15Rik, AI853839', description='canopy FGF signaling regulator 1', other_designations='canopy 1 homolog', map_location='5 B1', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=28200826, end_position_on_the_genomic_accession=28237873, orientation='minus', exon_count=4, OMIM='', no_hdr0=''),
  269639 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=269639, CurrentID=0, Status='live', Symbol='Zfp512', Aliases='2500002M11Rik, AI450173, D230008H22, Znf512', description='zinc finger protein 512', other_designations='', map_location='5 B1', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=31452416, end_position_on_the_genomic_accession=31481754, orientation='plus', exon_count=15, OMIM='', no_hdr0=''),
  269642 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=269642, CurrentID=0, Status='live', Symbol='Nat8l', Aliases='1110038O08Rik, Shati', description='N-acetyltransferase 8-like', other_designations='N-acetyltransferase 8-like protein|NAA synthetase|protein Shati', map_location='5 B2', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=33995984, end_position_on_the_genomic_accession=34005916, orientation='plus', exon_count=3, OMIM='', no_hdr0=''),
  269643 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=269643, CurrentID=0, Status='live', Symbol='Ppp2r2c', Aliases='6330548O06Rik, IMYPNO, IMYPNO1, PR52', description='protein phosphatase 2, regulatory subunit B, gamma', other_designations='PP2A subunit B isoform B55-gamma|PP2A subunit B isoform PR55-gamma|PP2A subunit B isoform R2-gamma|PP2A subunit B isoform gamma|protein phosphatase 2 (formerly 2A), regulatory subunit B (PR 52), gamma isoform', map_location='5 B3', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=36866843, end_position_on_the_genomic_accession=36955078, orientation='plus', exon_count=11, OMIM='', no_hdr0=''),
  269682 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=269682, CurrentID=0, Status='live', Symbol='Golga3', Aliases='5330413L04, 5430416E01Rik, AI449376, AW490576, G1-499-14, Mea-2, Mea2, repro27', description='golgi autoantigen, golgin subfamily a, 3', other_designations='Mea2/Golga3|golgin-160|male-enhanced antigen 2', map_location='5 53.36 cM', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=110176659, end_position_on_the_genomic_accession=110226470, orientation='plus', exon_count=25, OMIM='', no_hdr0=''),
  269693 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=269693, CurrentID=0, Status='live', Symbol='Ccdc60', Aliases='AU018954, C130098D09', description='coiled-coil domain containing 60', other_designations='', map_location='5 F', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=116125581, end_position_on_the_genomic_accession=116288998, orientation='minus', exon_count=15, OMIM='', no_hdr0=''),
  269695 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=269695, CurrentID=0, Status='live', Symbol='Rnft2', Aliases='AW049082, B830028P19Rik, Tmem118', description='ring finger protein, transmembrane 2', other_designations='transmembrane protein 118', map_location='5 F', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=118190734, end_position_on_the_genomic_accession=118245111, orientation='minus', exon_count=15, OMIM='', no_hdr0=''),
  269700 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=269700, CurrentID=0, Status='live', Symbol='Gm15800', Aliases='A130010L24, AU042671, BC019639, EG545802, OTTMUSG00000026283, mKIAA0614', description='predicted gene 15800', other_designations='', map_location='5 F', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=121219339, end_position_on_the_genomic_accession=121368577, orientation='plus', exon_count=78, OMIM='', no_hdr0=''),
  269701 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=269701, CurrentID=0, Status='live', Symbol='Wdr66', Aliases='4930415N18Rik, 4933428F06Rik, 5031404N07', description='WD repeat domain 66', other_designations='', map_location='5 F', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=123254560, end_position_on_the_genomic_accession=123327484, orientation='plus', exon_count=21, OMIM='', no_hdr0=''),
  269702 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=269702, CurrentID=0, Status='live', Symbol='Mphosph9', Aliases='4930548D04Rik, 9630025B04Rik, AW413446, AW547060, B930097C17Rik, C87456, MPP-9, MPP9', description='M-phase phosphoprotein 9', other_designations='', map_location='5 F', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=124250959, end_position_on_the_genomic_accession=124330759, orientation='minus', exon_count=27, OMIM='', no_hdr0=''),
  269704 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=269704, CurrentID=0, Status='live', Symbol='Zfp664', Aliases='AW060232, D930038J03Rik, ZFOC1, Znf664', description='zinc finger protein 664', other_designations='zinc finger protein ZFOC1', map_location='5 F', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=124862705, end_position_on_the_genomic_accession=124888630, orientation='plus', exon_count=4, OMIM='', no_hdr0=''),
  269713 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=269713, CurrentID=0, Status='live', Symbol='Clip2', Aliases='B230327O20, CLIP-115, Clip1, Cyln2, WSCR4, mKIAA0291, wbscr4', description='CAP-GLY domain containing linker protein 2', other_designations='cytoplasmic linker protein 1, 115 kDa|cytoplasmic linker protein 2', map_location='5 74.63 cM', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=134489383, end_position_on_the_genomic_accession=134552468, orientation='minus', exon_count=17, OMIM='', no_hdr0=''),
  269717 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=269717, CurrentID=0, Status='live', Symbol='Orai2', Aliases='A730041O15Rik, Tmem142b', description='ORAI calcium release-activated calcium modulator 2', other_designations='calcium release-activated calcium channel 2|transmembrane protein 142B', map_location='5 G2', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=136147459, end_position_on_the_genomic_accession=136170656, orientation='minus', exon_count=5, OMIM='', no_hdr0=''),
  66805 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=66805, CurrentID=0, Status='live', Symbol='Tspan1', Aliases='9030418M05Rik', description='tetraspanin 1', other_designations='tetraspan 1|tspan-1', map_location='4 C7', chromosome='4', genomic_nucleotide_accession_version='NC_000070.6', start_position_on_the_genomic_accession=116161881, end_position_on_the_genomic_accession=116167621, orientation='minus', exon_count=8, OMIM='', no_hdr0=''),
  269774 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=269774, CurrentID=0, Status='live', Symbol='Aak1', Aliases='5530400K14Rik, 9630042K20, AU067724, AU067726, BC028270, C79663, D6Ertd245e, R75501, mKIAA1048', description='AP2 associated kinase 1', other_designations='adaptor-associated kinase 1', map_location='6 37.75 cM', chromosome='6', genomic_nucleotide_accession_version='NC_000072.6', start_position_on_the_genomic_accession=86849482, end_position_on_the_genomic_accession=87003227, orientation='plus', exon_count=21, OMIM='', no_hdr0=''),
  269784 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=269784, CurrentID=0, Status='live', Symbol='Cntn4', Aliases='9630050B05, Axcam, BIG-2', description='contactin 4', other_designations='axonal-associated cell adhesion molecule|brain-derived immunoglobulin superfamily molecule|brain-derived immunoglobulin superfamily protein 2', map_location='6 E2', chromosome='6', genomic_nucleotide_accession_version='NC_000072.6', start_position_on_the_genomic_accession=105677651, end_position_on_the_genomic_accession=106700141, orientation='plus', exon_count=29, OMIM='', no_hdr0=''),
  269788 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=269788, CurrentID=0, Status='live', Symbol='Lhfpl4', Aliases='1190004M23Rik, AI604880, B230384L07, mKIAA4027', description='lipoma HMGIC fusion partner-like protein 4', other_designations='', map_location='6 E3', chromosome='6', genomic_nucleotide_accession_version='NC_000072.6', start_position_on_the_genomic_accession=113168087, end_position_on_the_genomic_accession=113195384, orientation='minus', exon_count=4, OMIM='', no_hdr0=''),
  269799 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=269799, CurrentID=0, Status='live', Symbol='Clec4a1', Aliases='BC049354, Dcir4', description='C-type lectin domain family 4, member a1', other_designations='dendritic cell inhibitory receptor 4', map_location='6 F2', chromosome='6', genomic_nucleotide_accession_version='NC_000072.6', start_position_on_the_genomic_accession=122921848, end_position_on_the_genomic_accession=122934619, orientation='plus', exon_count=6, OMIM='', no_hdr0=''),
  269800 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=269800, CurrentID=0, Status='live', Symbol='Zfp384', Aliases='BB163993, C130073D16Rik, Ciz, NP, Nmp4', description='zinc finger protein 384', other_designations='nuclear matrix protein 4', map_location='6 F2', chromosome='6', genomic_nucleotide_accession_version='NC_000072.6', start_position_on_the_genomic_accession=125009110, end_position_on_the_genomic_accession=125037870, orientation='plus', exon_count=14, OMIM='', no_hdr0=''),
  269823 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=269823, CurrentID=0, Status='live', Symbol='Pon3', Aliases='2810004E20, AI786302', description='paraoxonase 3', other_designations='', map_location='6 1.99 cM', chromosome='6', genomic_nucleotide_accession_version='NC_000072.6', start_position_on_the_genomic_accession=5220852, end_position_on_the_genomic_accession=5256250, orientation='minus', exon_count=10, OMIM='', no_hdr0=''),
  269831 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=269831, CurrentID=0, Status='live', Symbol='Tspan12', Aliases='9030619E17, AI426782, AI663988, AW111457, Tm4sf12', description='tetraspanin 12', other_designations='transmembrane 4 superfamily member 12|tspan-12', map_location='6 A3.1', chromosome='6', genomic_nucleotide_accession_version='NC_000072.6', start_position_on_the_genomic_accession=21771391, end_position_on_the_genomic_accession=21853349, orientation='minus', exon_count=10, OMIM='', no_hdr0=''),
  269846 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=269846, CurrentID=0, Status='live', Symbol='Trbv31', Aliases='Gm16809, Tcrb-V14', description='T cell receptor beta, variable 31', other_designations='T-cell receptor beta, variable 14|T-cell receptor beta, variable 31', map_location='6 B1', chromosome='6', genomic_nucleotide_accession_version='NC_000072.6', start_position_on_the_genomic_accession=41557693, end_position_on_the_genomic_accession=41558371, orientation='minus', exon_count=0, OMIM='', no_hdr0=''),
  269854 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=269854, CurrentID=0, Status='live', Symbol='Nat14', Aliases='BC047219', description='N-acetyltransferase 14', other_designations='', map_location='7 A1', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=4918888, end_position_on_the_genomic_accession=4925006, orientation='plus', exon_count=5, OMIM='', no_hdr0=''),
  269855 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=269855, CurrentID=0, Status='live', Symbol='Ssc5d', Aliases='A430110N23Rik, S5D-SRCRB', description='scavenger receptor cysteine rich family, 5 domains', other_designations='group B scavenger receptor cysteine-rich domain-containing|scavenger receptor cysteine rich domain containing (5 domains)|scavenger receptor cysteine-rich domain-containing protein LOC284297 homolog', map_location='7 A1', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=4925130, end_position_on_the_genomic_accession=4944828, orientation='plus', exon_count=14, OMIM='', no_hdr0=''),
  269862 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=269862, CurrentID=0, Status='live', Symbol='Olfr1349', Aliases='MOR232-8', description='olfactory receptor 1349', other_designations='GA_x6K02T2QGBW-3245761-3244808|olfactory receptor MOR232-8', map_location='7 A1', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=6514199, end_position_on_the_genomic_accession=6520355, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  269870 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=269870, CurrentID=0, Status='live', Symbol='Zfp446', Aliases='A630035I11Rik, A930031C22, AA120513, AV306632', description='zinc finger protein 446', other_designations='', map_location='7 A1', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=12976397, end_position_on_the_genomic_accession=12985717, orientation='plus', exon_count=6, OMIM='', no_hdr0=''),
  328968 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=328968, CurrentID=0, Status='live', Symbol='Mir143hg', Aliases='Carmen, E330013P06, Gm16908', description='Mir143 and Mir145 host gene (non-protein coding)', other_designations='Mir143 and Mir145 host gene (non-coding RNA)|cardiac mesoderm enhancer-associated noncoding RNA', map_location='18 E1', chromosome='18', genomic_nucleotide_accession_version='NC_000084.6', start_position_on_the_genomic_accession=61645878, end_position_on_the_genomic_accession=61665538, orientation='minus', exon_count=5, OMIM='', no_hdr0=''),
  269878 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=269878, CurrentID=0, Status='live', Symbol='Megf8', Aliases='AW049492, Egfl4, b2b1702.2Clo, b2b1702Clo, b2b288Clo, m687Ddg, mKIAA0817', description='multiple EGF-like-domains 8', other_designations='EGF-like protein 4|EGF-like-domain, multiple 4|epidermal growth factor-like protein 4|multiple EGF-like domains protein 8', map_location='7 A3', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=25316742, end_position_on_the_genomic_accession=25365917, orientation='plus', exon_count=41, OMIM='', no_hdr0=''),
  269881 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=269881, CurrentID=0, Status='live', Symbol='Map3k10', Aliases='BC028668, BC046514, MST, Mlk2', description='mitogen-activated protein kinase kinase kinase 10', other_designations='MKN28 derived nonreceptor_type|MKN28 kinase|mixed lineage kinase 2|serine/threonine kinase', map_location='7 A3', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=27656375, end_position_on_the_genomic_accession=27674607, orientation='minus', exon_count=12, OMIM='', no_hdr0=''),
  328971 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=328971, CurrentID=0, Status='live', Symbol='Spink10', Aliases='A230091H23Rik', description='serine peptidase inhibitor, Kazal type 10', other_designations='serine protease inhibitor Kazal type 10', map_location='18 E1', chromosome='18', genomic_nucleotide_accession_version='NC_000084.6', start_position_on_the_genomic_accession=62548911, end_position_on_the_genomic_accession=62662933, orientation='plus', exon_count=13, OMIM='', no_hdr0=''),
  269902 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=269902, CurrentID=0, Status='live', Symbol='Vmn2r57', Aliases='D430014M15, EG269902', description='vomeronasal 2, receptor 57', other_designations='vomeronasal receptor Vmn2r57', map_location='7 B3', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=41399732, end_position_on_the_genomic_accession=41448641, orientation='minus', exon_count=6, OMIM='', no_hdr0=''),
  110521 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=110521, CurrentID=0, Status='live', Symbol='Hivep1', Aliases='Cryabp1', description='human immunodeficiency virus type I enhancer binding protein 1', other_designations='HIV type I enhancer binding protein 1|alpha A-CRYBP1|alpha A-crystallin-binding protein 1|alpha A-crystallin-binding protein I|alphaA-CRYBP1|crystallin, alpha binding protein 1|human immunodeficiency virus type I enhancer-binding protein 1|transcription factor alphaA-CRYBP1', map_location='13 20.72 cM', chromosome='13', genomic_nucleotide_accession_version='NC_000079.6', start_position_on_the_genomic_accession=42051969, end_position_on_the_genomic_accession=42185030, orientation='plus', exon_count=13, OMIM='', no_hdr0=''),
  269941 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=269941, CurrentID=0, Status='live', Symbol='Chsy1', Aliases='mKIAA0990', description='chondroitin sulfate synthase 1', other_designations='N-acetylgalactosaminyl-proteoglycan 3-beta-glucuronosyltransferase 1|N-acetylgalactosaminyltransferase 1|carbohydrate (chondroitin) synthase 1|chSy-1|chondroitin glucuronyltransferase 1|chondroitin synthase 1|glucuronosyl-N-acetylgalactosaminyl-proteoglycan 4-beta-N-acetylgalactosaminyltransferase 1', map_location='7 C', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=66109515, end_position_on_the_genomic_accession=66173798, orientation='plus', exon_count=4, OMIM='', no_hdr0=''),
  269951 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=269951, CurrentID=0, Status='live', Symbol='Idh2', Aliases='E430004F23, IDPm, Idh-2', description='isocitrate dehydrogenase 2 (NADP+), mitochondrial', other_designations='ICD-M|IDH|IDP|NADP(+)-specific ICDH|NADP+-specific isocitrate dehydrogenase|oxalosuccinate decarboxylase', map_location='7 45.43 cM', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=80094846, end_position_on_the_genomic_accession=80115387, orientation='minus', exon_count=12, OMIM='', no_hdr0=''),
  269952 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=269952, CurrentID=0, Status='live', Symbol='Gdpgp1', Aliases='D330012F22Rik', description='GDP-D-glucose phosphorylase 1', other_designations='GDP-D-glucose phosphorylase C15orf58 homolog', map_location='7 D3', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=80232893, end_position_on_the_genomic_accession=80241420, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  269954 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=269954, CurrentID=0, Status='live', Symbol='Ttll13', Aliases='1700111A04Rik, 4921538O11, BC024578', description='tubulin tyrosine ligase-like family, member 13', other_designations='ttll13|tubulin--tyrosine ligase-like protein 13', map_location='7 D3', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=80246376, end_position_on_the_genomic_accession=80260821, orientation='plus', exon_count=17, OMIM='', no_hdr0=''),
  269955 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=269955, CurrentID=0, Status='live', Symbol='Rccd1', Aliases='5830436H09, E430018M08Rik', description='RCC1 domain containing 1', other_designations='', map_location='7 D3', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=80294598, end_position_on_the_genomic_accession=80324696, orientation='minus', exon_count=13, OMIM='', no_hdr0=''),
  269959 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=269959, CurrentID=0, Status='live', Symbol='Adamtsl3', Aliases='9230119C12Rik, C130057K09, mKIAA1233', description='ADAMTS-like 3', other_designations='a disintegrin-like and metalloprotease (reprolysin type) with thrombospondin type 1 motif like, 3|punctin-2', map_location='7 D3', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=82335446, end_position_on_the_genomic_accession=82614450, orientation='plus', exon_count=31, OMIM='', no_hdr0=''),
  269966 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=269966, CurrentID=0, Status='live', Symbol='Nup98', Aliases='4732457F17, AI849286, Nup96', description='nucleoporin 98', other_designations='', map_location='7 54.71 cM', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=102119400, end_position_on_the_genomic_accession=102210166, orientation='minus', exon_count=34, OMIM='', no_hdr0=''),
  269980 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=269980, CurrentID=0, Status='live', Symbol='Gm5053', Aliases='EG269980', description='predicted gene 5053', other_designations='', map_location='7 E3', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=108527727, end_position_on_the_genomic_accession=108529070, orientation='minus', exon_count=0, OMIM='', no_hdr0=''),
  269994 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=269994, CurrentID=0, Status='live', Symbol='Gsg1l', Aliases='AI852434, C230098I05Rik, G630023A01Rik, Gm637, g1l', description='GSG1-like', other_designations='GSG1-like protein', map_location='7 F3', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=125878412, end_position_on_the_genomic_accession=126082772, orientation='minus', exon_count=9, OMIM='', no_hdr0=''),
  269997 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=269997, CurrentID=0, Status='live', Symbol='Zfp747', Aliases='6430604K15Rik', description='zinc finger protein 747', other_designations='', map_location='7 F3', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=127372537, end_position_on_the_genomic_accession=127376050, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  269999 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=269999, CurrentID=0, Status='live', Symbol='Orai3', Aliases='9930124N15, BC061259, Tmem142c', description='ORAI calcium release-activated calcium modulator 3', other_designations='calcium release-activated calcium channel 3|transmembrane protein 142C', map_location='7 F3', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=127769589, end_position_on_the_genomic_accession=127775150, orientation='plus', exon_count=4, OMIM='', no_hdr0=''),
  270004 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=270004, CurrentID=0, Status='live', Symbol='Foxi2', Aliases='B130055A05Rik', description='forkhead box I2', other_designations='foxi2', map_location='7 F3', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=135410367, end_position_on_the_genomic_accession=135413615, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  270028 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=270028, CurrentID=0, Status='live', Symbol='Fam155a', Aliases='6430500D16, AW121567, Tmem28', description='family with sequence similarity 155, member A', other_designations='transmembrane protein 28', map_location='8 A1.1', chromosome='8', genomic_nucleotide_accession_version='NC_000074.6', start_position_on_the_genomic_accession=9206010, end_position_on_the_genomic_accession=9773363, orientation='minus', exon_count=8, OMIM='', no_hdr0=''),
  270035 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=270035, CurrentID=0, Status='live', Symbol='Letm2', Aliases='6030453H13, D030041N04Rik', description='leucine zipper-EF-hand containing transmembrane protein 2', other_designations='LETM1 and EF-hand domain-containing protein 2', map_location='8 A2', chromosome='8', genomic_nucleotide_accession_version='NC_000074.6', start_position_on_the_genomic_accession=25578481, end_position_on_the_genomic_accession=25597899, orientation='minus', exon_count=12, OMIM='', no_hdr0=''),
  270049 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=270049, CurrentID=0, Status='live', Symbol='Galntl6', Aliases='1700021K10Rik, 4930431L04Rik, A830023L05', description='UDP-N-acetyl-alpha-D-galactosamine:polypeptide N-acetylgalactosaminyltransferase-like 6', other_designations='UDP-N-acetyl-alpha-D-galactosamine:polypeptide N-acetylgalactosaminyltransferase 20', map_location='8 B3.1', chromosome='8', genomic_nucleotide_accession_version='NC_000074.6', start_position_on_the_genomic_accession=57772489, end_position_on_the_genomic_accession=58911627, orientation='minus', exon_count=12, OMIM='', no_hdr0=''),
  270058 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=270058, CurrentID=0, Status='live', Symbol='Map1s', Aliases='6430517J16Rik, Bpy2ip1, Map8, Mtap1s, VCY2IP1', description='microtubule-associated protein 1S', other_designations='BPY2 interacting protein 1|BPY2-interacting protein 1|MAP-1S|microtubule-associated protein 8', map_location='8 B3.3', chromosome='8', genomic_nucleotide_accession_version='NC_000074.6', start_position_on_the_genomic_accession=70905957, end_position_on_the_genomic_accession=70930112, orientation='plus', exon_count=8, OMIM='', no_hdr0=''),
  270066 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=270066, CurrentID=0, Status='live', Symbol='Slc35e1', Aliases='6030458H05, AA408278', description='solute carrier family 35, member E1', other_designations='', map_location='8 B3.3', chromosome='8', genomic_nucleotide_accession_version='NC_000074.6', start_position_on_the_genomic_accession=72477995, end_position_on_the_genomic_accession=72492614, orientation='minus', exon_count=6, OMIM='', no_hdr0=''),
  270076 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=270076, CurrentID=0, Status='live', Symbol='Gcdh', Aliases='9030411L18, AI266902, D17825, GCD', description='glutaryl-Coenzyme A dehydrogenase', other_designations='', map_location='8 41.28 cM', chromosome='8', genomic_nucleotide_accession_version='NC_000074.6', start_position_on_the_genomic_accession=84886387, end_position_on_the_genomic_accession=84893921, orientation='minus', exon_count=11, OMIM='', no_hdr0=''),
  66859 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=66859, CurrentID=0, Status='live', Symbol='Slc16a9', Aliases='1200003C15Rik, 4930425B13Rik, AI552636', description='solute carrier family 16 (monocarboxylic acid transporters), member 9', other_designations='MCT 9|solute carrier family 16 member 9', map_location='10 B5.3', chromosome='10', genomic_nucleotide_accession_version='NC_000076.6', start_position_on_the_genomic_accession=70245276, end_position_on_the_genomic_accession=70285951, orientation='plus', exon_count=7, OMIM='', no_hdr0=''),
  270084 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=270084, CurrentID=0, Status='live', Symbol='Lpcat2', Aliases='A330042H22, Aytl1, Aytl1a, lpafat1', description='lysophosphatidylcholine acyltransferase 2', other_designations='1-AGP acyltransferase 11|1-AGPAT 11|1-acylglycerol-3-phosphate O-acyltransferase 11|1-acylglycerophosphocholine O-acyltransferase|1-alkylglycerophosphocholine O-acetyltransferase|LPC acyltransferase 2|LPCAT-2|acetyl-CoA:lyso-PAF acetyltransferase|acetyl-CoA:lyso-platelet-activating factor acetyltransferase|acyl-CoA:lysophosphatidylcholine acyltransferase member 1|acyltransferase like 1|acyltransferase like 1A|acyltransferase-like 1|lyso-PAF acetyltransferase|lysoPAFAT|lysoPAFAT/LPCAT2|lysoPC acyltransferase 2', map_location='8 C5', chromosome='8', genomic_nucleotide_accession_version='NC_000074.6', start_position_on_the_genomic_accession=92855330, end_position_on_the_genomic_accession=92919279, orientation='plus', exon_count=15, OMIM='', no_hdr0=''),
  270086 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=270086, CurrentID=0, Status='live', Symbol='Ogfod1', Aliases='4930415J21Rik, AA387199, AA939912, AW061076, mKIAA1612', description='2-oxoglutarate and iron-dependent oxygenase domain containing 1', other_designations='2-oxoglutarate and iron-dependent oxygenase domain-containing protein 1', map_location='8 C5', chromosome='8', genomic_nucleotide_accession_version='NC_000074.6', start_position_on_the_genomic_accession=94037141, end_position_on_the_genomic_accession=94067923, orientation='plus', exon_count=13, OMIM='', no_hdr0=''),
  270091 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=270091, CurrentID=0, Status='live', Symbol='Lrrc36', Aliases='BC036564', description='leucine rich repeat containing 36', other_designations='', map_location='8 D3', chromosome='8', genomic_nucleotide_accession_version='NC_000074.6', start_position_on_the_genomic_accession=105411389, end_position_on_the_genomic_accession=105464086, orientation='plus', exon_count=15, OMIM='', no_hdr0=''),
  270096 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=270096, CurrentID=0, Status='live', Symbol='Mon1b', Aliases='5031407H10, 5033413H12Rik', description='MON1 homolog b (yeast)', other_designations='', map_location='8 E1', chromosome='8', genomic_nucleotide_accession_version='NC_000074.6', start_position_on_the_genomic_accession=113635586, end_position_on_the_genomic_accession=113645192, orientation='plus', exon_count=6, OMIM='', no_hdr0=''),
  270097 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=270097, CurrentID=0, Status='live', Symbol='Vat1l', Aliases='9430073I07, AI427515, mKIAA1576', description='vesicle amine transport protein 1 homolog-like (T. californica)', other_designations='', map_location='8 E1', chromosome='8', genomic_nucleotide_accession_version='NC_000074.6', start_position_on_the_genomic_accession=114205582, end_position_on_the_genomic_accession=114374074, orientation='plus', exon_count=10, OMIM='', no_hdr0=''),
  270106 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=270106, CurrentID=0, Status='live', Symbol='Rpl13', Aliases='A52, L13', description='ribosomal protein L13', other_designations='', map_location='8 E1', chromosome='8', genomic_nucleotide_accession_version='NC_000074.6', start_position_on_the_genomic_accession=123102350, end_position_on_the_genomic_accession=123105244, orientation='plus', exon_count=6, OMIM='', no_hdr0=''),
  270109 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=270109, CurrentID=0, Status='live', Symbol='Pcnxl2', Aliases='A830048P05, AU067631, E330039K12Rik, mKIAA0435', description='pecanex-like 2 (Drosophila)', other_designations='', map_location='8 E2', chromosome='8', genomic_nucleotide_accession_version='NC_000074.6', start_position_on_the_genomic_accession=125751504, end_position_on_the_genomic_accession=125898317, orientation='minus', exon_count=36, OMIM='', no_hdr0=''),
  270110 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=270110, CurrentID=0, Status='live', Symbol='Irf2bp2', Aliases='E130305N23Rik, IRF-2BP2', description='interferon regulatory factor 2 binding protein 2', other_designations='IRF-2-binding protein 2', map_location='8 E2', chromosome='8', genomic_nucleotide_accession_version='NC_000074.6', start_position_on_the_genomic_accession=126588296, end_position_on_the_genomic_accession=126593436, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  270118 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=270118, CurrentID=0, Status='live', Symbol='Maml2', Aliases='5930431H10, BC032967', description='mastermind like 2 (Drosophila)', other_designations='', map_location='9 A1', chromosome='9', genomic_nucleotide_accession_version='NC_000075.6', start_position_on_the_genomic_accession=13619989, end_position_on_the_genomic_accession=13709533, orientation='plus', exon_count=6, OMIM='', no_hdr0=''),
  270120 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=270120, CurrentID=0, Status='live', Symbol='Fat3', Aliases='9430076A06Rik, D430038H04Rik, Gm1132, Gm510, MFAT3F', description='FAT atypical cadherin 3', other_designations='FAT tumor suppressor homolog 3|protocadherin Fat3', map_location='9 A2', chromosome='9', genomic_nucleotide_accession_version='NC_000075.6', start_position_on_the_genomic_accession=15910189, end_position_on_the_genomic_accession=16502879, orientation='minus', exon_count=29, OMIM='', no_hdr0=''),
  270151 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=270151, CurrentID=0, Status='live', Symbol='Nlrx1', Aliases='BC034204, NOD9', description='NLR family member X1', other_designations='nucleotide-binding domain and leucine-rich repeat containing', map_location='9 A5.2', chromosome='9', genomic_nucleotide_accession_version='NC_000075.6', start_position_on_the_genomic_accession=44252713, end_position_on_the_genomic_accession=44268599, orientation='minus', exon_count=12, OMIM='', no_hdr0=''),
  270152 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=270152, CurrentID=0, Status='live', Symbol='Amica1', Aliases='AMICA, Crea7, Gm638', description='adhesion molecule, interacts with CXADR antigen 1', other_designations='adhesion molecule AMICA|dendritic cell-specific protein CREA7|dendritic-cell specific protein Crea7|mCrea7', map_location='9 A5.2', chromosome='9', genomic_nucleotide_accession_version='NC_000075.6', start_position_on_the_genomic_accession=45079162, end_position_on_the_genomic_accession=45108531, orientation='plus', exon_count=15, OMIM='', no_hdr0=''),
  329015 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=329015, CurrentID=0, Status='live', Symbol='Atg2a', Aliases='1810013C15Rik, A830054M12, BC023754, mKIAA0404', description='autophagy related 2A', other_designations='ATG2 autophagy related 2 homolog A', map_location='19 A', chromosome='19', genomic_nucleotide_accession_version='NC_000085.6', start_position_on_the_genomic_accession=6241666, end_position_on_the_genomic_accession=6262304, orientation='plus', exon_count=40, OMIM='', no_hdr0=''),
  270156 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=270156, CurrentID=0, Status='live', Symbol='AU019823', Aliases='Gm639', description='expressed sequence AU019823', other_designations='', map_location='9 A5.3', chromosome='9', genomic_nucleotide_accession_version='NC_000075.6', start_position_on_the_genomic_accession=50605240, end_position_on_the_genomic_accession=50617589, orientation='minus', exon_count=7, OMIM='', no_hdr0=''),
  270160 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=270160, CurrentID=0, Status='live', Symbol='Rab39', Aliases='C230094F14Rika, Rab39', description='RAB39, member RAS oncogene family', other_designations='rab-39', map_location='9 A5.3', chromosome='9', genomic_nucleotide_accession_version='NC_000075.6', start_position_on_the_genomic_accession=53684110, end_position_on_the_genomic_accession=53706232, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  270162 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=270162, CurrentID=0, Status='live', Symbol='Elmod1', Aliases='4831417L10, AI428506, AI834991', description='ELMO/CED-12 domain containing 1', other_designations='ELMO domain containing 1', map_location='9 A5.3', chromosome='9', genomic_nucleotide_accession_version='NC_000075.6', start_position_on_the_genomic_accession=53911457, end_position_on_the_genomic_accession=53975310, orientation='minus', exon_count=13, OMIM='', no_hdr0=''),
  270163 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=270163, CurrentID=0, Status='live', Symbol='Myo9a', Aliases='4732465J09Rik, C130068I12Rik, C230003M11', description='myosin IXa', other_designations='myosin-IXa|unconventional myosin-9a', map_location='9 32.13 cM', chromosome='9', genomic_nucleotide_accession_version='NC_000075.6', start_position_on_the_genomic_accession=59750856, end_position_on_the_genomic_accession=59928866, orientation='plus', exon_count=45, OMIM='', no_hdr0=''),
  270166 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=270166, CurrentID=0, Status='live', Symbol='Clpx', Aliases='AU014732, E330029I21', description='caseinolytic mitochondrial matrix peptidase chaperone subunit', other_designations='caseinolytic peptidase X|caseinolytic protease X', map_location='9 35.22 cM', chromosome='9', genomic_nucleotide_accession_version='NC_000075.6', start_position_on_the_genomic_accession=65294250, end_position_on_the_genomic_accession=65330658, orientation='plus', exon_count=14, OMIM='', no_hdr0=''),
  110564 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=110564, CurrentID=0, Status='live', Symbol='Lth1', Aliases='Lth-1, Lvth-1', description='liver 30-40 thousand Mol. Wt. protein 1', other_designations='', map_location='', chromosome='13', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  270190 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=270190, CurrentID=0, Status='live', Symbol='Ephb1', Aliases='9330129L11, AW488255, C130099E04Rik, Cek6, ENSMUSG00000074119, Elk, Elkh, Hek6, Net', description='Eph receptor B1', other_designations='', map_location='9 F1', chromosome='9', genomic_nucleotide_accession_version='NC_000075.6', start_position_on_the_genomic_accession=101922128, end_position_on_the_genomic_accession=102354693, orientation='minus', exon_count=16, OMIM='', no_hdr0=''),
  270192 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=270192, CurrentID=0, Status='live', Symbol='Rab6b', Aliases='9630015C03, AI844641, C330006L04Rik, D9Bwg0185e', description='RAB6B, member RAS oncogene family', other_designations='', map_location='9 54.88 cM', chromosome='9', genomic_nucleotide_accession_version='NC_000075.6', start_position_on_the_genomic_accession=103112074, end_position_on_the_genomic_accession=103185276, orientation='plus', exon_count=10, OMIM='', no_hdr0=''),
  270198 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=270198, CurrentID=0, Status='live', Symbol='Pfkfb4', Aliases='C230090D14', description='6-phosphofructo-2-kinase/fructose-2,6-biphosphatase 4', other_designations='6PF-2-K/Fru-2,6-P2ase 4|6PF-2-K/Fru-2,6-P2ase testis-type isozyme|PFK/FBPase 4', map_location='9 F2', chromosome='9', genomic_nucleotide_accession_version='NC_000075.6', start_position_on_the_genomic_accession=108988033, end_position_on_the_genomic_accession=109032236, orientation='plus', exon_count=18, OMIM='', no_hdr0=''),
  270201 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=270201, CurrentID=0, Status='live', Symbol='Klhl18', Aliases='A930041K15, AW545966', description='kelch-like 18', other_designations='', map_location='9 F2', chromosome='9', genomic_nucleotide_accession_version='NC_000075.6', start_position_on_the_genomic_accession=110425926, end_position_on_the_genomic_accession=110476700, orientation='minus', exon_count=11, OMIM='', no_hdr0=''),
  270210 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=270210, CurrentID=0, Status='live', Symbol='Zfp651', Aliases='4732420M22Rik, BC030045, R74626', description='zinc finger protein 651', other_designations='', map_location='9 F4', chromosome='9', genomic_nucleotide_accession_version='NC_000075.6', start_position_on_the_genomic_accession=121758638, end_position_on_the_genomic_accession=121771742, orientation='plus', exon_count=8, OMIM='', no_hdr0=''),
  270328 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=270328, CurrentID=0, Status='live', Symbol='Gsdmc3', Aliases='9930109F21Rik', description='gasdermin C3', other_designations='gsdmc3', map_location='15 D1', chromosome='15', genomic_nucleotide_accession_version='NC_000081.6', start_position_on_the_genomic_accession=63857716, end_position_on_the_genomic_accession=63878583, orientation='minus', exon_count=13, OMIM='', no_hdr0=''),
  66921 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=66921, CurrentID=0, Status='live', Symbol='Prpf38b', Aliases='1110021E09Rik, AU018955', description='PRP38 pre-mRNA processing factor 38 (yeast) domain containing B', other_designations='', map_location='3 G1', chromosome='3', genomic_nucleotide_accession_version='NC_000069.6', start_position_on_the_genomic_accession=108902807, end_position_on_the_genomic_accession=108911752, orientation='minus', exon_count=8, OMIM='', no_hdr0=''),
  241688 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=241688, CurrentID=0, Status='live', Symbol='Dzank1', Aliases='2810039F03Rik, 6330439K17Rik, 6430408C01, AI851115, Ankrd64', description='double zinc ribbon and ankyrin repeat domains 1', other_designations='ankyrin repeat-containing protein C20orf12 homolog|likely ortholog of H. sapiens chromosome 20 open reading frame 12 (C20orf12)', map_location='2 G1', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=144470555, end_position_on_the_genomic_accession=144527425, orientation='minus', exon_count=21, OMIM='', no_hdr0=''),
  329093 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=329093, CurrentID=0, Status='live', Symbol='Cpa6', Aliases='9030616D13Rik', description='carboxypeptidase A6', other_designations='metallocarboxypeptidase', map_location='1 A2', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=10295791, end_position_on_the_genomic_accession=10720058, orientation='minus', exon_count=15, OMIM='', no_hdr0=''),
  270624 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=270624, CurrentID=0, Status='live', Symbol='Spin4', Aliases='9630042H07Rik', description='spindlin family, member 4', other_designations='novel Spin/Ssty repeat containing protein', map_location='X C3', chromosome='X', genomic_nucleotide_accession_version='NC_000086.7', start_position_on_the_genomic_accession=95022507, end_position_on_the_genomic_accession=95026682, orientation='minus', exon_count=1, OMIM='', no_hdr0=''),
  270627 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=270627, CurrentID=0, Status='live', Symbol='Taf1', Aliases='AU015687, B430306D02Rik, Ccg-1, Ccg1, KAT4, N-TAF1, TAFII250, Taf2a, p250', description='TATA-box binding protein associated factor 1', other_designations='TAF1 RNA polymerase II, TATA box binding protein (TBP)-associated factor|TAF1 RNA polymerase II, TATA box binding protein (TBP)-associated factor, neuron specific isoform|TBP-associated factor 250 kDa|cell cycle gene 1 protein|cell cycle, G1 phase defect|transcription initiation factor TFIID 250 kDa subunit', map_location='X 44.29 cM', chromosome='X', genomic_nucleotide_accession_version='NC_000086.7', start_position_on_the_genomic_accession=101527574, end_position_on_the_genomic_accession=101601789, orientation='plus', exon_count=42, OMIM='', no_hdr0=''),
  270669 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=270669, CurrentID=0, Status='live', Symbol='Mbtps2', Aliases='9630032G22Rik, AI662535', description='membrane-bound transcription factor peptidase, site 2', other_designations='S2P endopeptidase|endopeptidase S2P|membrane-bound transcription factor protease, site 2|site-2 protease', map_location='X F4', chromosome='X', genomic_nucleotide_accession_version='NC_000086.7', start_position_on_the_genomic_accession=157547822, end_position_on_the_genomic_accession=157598715, orientation='minus', exon_count=11, OMIM='', no_hdr0=''),
  270672 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=270672, CurrentID=0, Status='live', Symbol='Map3k15', Aliases='BC031147, MEKK15', description='mitogen-activated protein kinase kinase kinase 15', other_designations='MAPK/ERK kinase kinase 15|MEK kinase 15|MEKK 15|map3k15', map_location='X F4', chromosome='X', genomic_nucleotide_accession_version='NC_000086.7', start_position_on_the_genomic_accession=159988433, end_position_on_the_genomic_accession=160123351, orientation='plus', exon_count=29, OMIM='', no_hdr0=''),
  270685 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=270685, CurrentID=0, Status='live', Symbol='Mthfd1l', Aliases='2410004L15Rik, AI647056, Fthfsdc1', description='methylenetetrahydrofolate dehydrogenase (NADP+ dependent) 1-like', other_designations='formyltetrahydrofolate synthetase domain containing 1', map_location='10 A1', chromosome='10', genomic_nucleotide_accession_version='NC_000076.6', start_position_on_the_genomic_accession=3970441, end_position_on_the_genomic_accession=4167081, orientation='plus', exon_count=30, OMIM='', no_hdr0=''),
  270711 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=270711, CurrentID=0, Status='live', Symbol='Fam26d', Aliases='4732454E20Rik, AI586164, Gm643', description='family with sequence similarity 26, member D', other_designations='', map_location='10 B1', chromosome='10', genomic_nucleotide_accession_version='NC_000076.6', start_position_on_the_genomic_accession=34038784, end_position_on_the_genomic_accession=34044313, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  241727 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=241727, CurrentID=0, Status='live', Symbol='Snph', Aliases='6430515A01, AW045671, AW556958, AW743098, mKIAA0374', description='syntaphilin', other_designations='', map_location='2 G3', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=151590549, end_position_on_the_genomic_accession=151633030, orientation='minus', exon_count=7, OMIM='', no_hdr0=''),
  241732 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=241732, CurrentID=0, Status='live', Symbol='Tspyl3', Aliases='AW212607, Gm36', description='TSPY-like 3', other_designations='', map_location='2 H1', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=153222370, end_position_on_the_genomic_accession=153225441, orientation='minus', exon_count=1, OMIM='', no_hdr0=''),
  270757 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=270757, CurrentID=0, Status='live', Symbol='Bpifc', Aliases='4732454E24, Bpil2', description='BPI fold containing family C', other_designations='bactericidal/permeability-increasing protein-like 2', map_location='10 C1', chromosome='10', genomic_nucleotide_accession_version='NC_000076.6', start_position_on_the_genomic_accession=85959340, end_position_on_the_genomic_accession=86015898, orientation='minus', exon_count=17, OMIM='', no_hdr0=''),
  270802 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=270802, CurrentID=0, Status='live', Symbol='BC048403', Aliases='E030027L10', description='cDNA sequence BC048403', other_designations='', map_location='10 D2', chromosome='10', genomic_nucleotide_accession_version='NC_000076.6', start_position_on_the_genomic_accession=121739603, end_position_on_the_genomic_accession=121757613, orientation='plus', exon_count=4, OMIM='', no_hdr0=''),
  270893 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=270893, CurrentID=0, Status='live', Symbol='Tmem132e', Aliases='Gm644', description='transmembrane protein 132E', other_designations='', map_location='11 C', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=82387446, end_position_on_the_genomic_accession=82447618, orientation='plus', exon_count=10, OMIM='', no_hdr0=''),
  270906 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=270906, CurrentID=0, Status='live', Symbol='Prr11', Aliases='B930067F20Rik', description='proline rich 11', other_designations='', map_location='11 C', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=87089156, end_position_on_the_genomic_accession=87108714, orientation='minus', exon_count=10, OMIM='', no_hdr0=''),
  67008 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=67008, CurrentID=0, Status='live', Symbol='Yae1d1', Aliases='1600012F09Rik', description='Yae1 domain containing 1', other_designations='', map_location='13 A2-A3', chromosome='13', genomic_nucleotide_accession_version='NC_000079.6', start_position_on_the_genomic_accession=17986640, end_position_on_the_genomic_accession=17993351, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  329154 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=329154, CurrentID=0, Status='live', Symbol='Ankrd44', Aliases='4930444A19Rik, A130096K20, E130014H08Rik, PP6-ARS-B', description='ankyrin repeat domain 44', other_designations='ankyrin repeat domain-containing protein 44|serine/threonine-protein phosphatase 6 regulatory subunit ARS-B', map_location='1 C1.1', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=54645340, end_position_on_the_genomic_accession=54926733, orientation='minus', exon_count=29, OMIM='', no_hdr0=''),
  271005 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=271005, CurrentID=0, Status='live', Symbol='Klhdc1', Aliases='', description='kelch domain containing 1', other_designations='', map_location='12 C2', chromosome='12', genomic_nucleotide_accession_version='NC_000078.6', start_position_on_the_genomic_accession=69226917, end_position_on_the_genomic_accession=69284646, orientation='plus', exon_count=17, OMIM='', no_hdr0=''),
  329160 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=329160, CurrentID=0, Status='live', Symbol='9130024F11Rik', Aliases='B530002L08, EG329160', description='RIKEN cDNA 9130024F11 gene', other_designations='', map_location='1 C1.3', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=56971469, end_position_on_the_genomic_accession=56975196, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  271036 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=271036, CurrentID=0, Status='live', Symbol='Catsperb', Aliases='4931410B03, 4932415G16Rik', description='catsper channel auxiliary subunit beta', other_designations='CatSper channel subunit beta|catSper-beta|cation channel, sperm-associated, beta', map_location='12 E', chromosome='12', genomic_nucleotide_accession_version='NC_000078.6', start_position_on_the_genomic_accession=101404645, end_position_on_the_genomic_accession=101626009, orientation='plus', exon_count=27, OMIM='', no_hdr0=''),
  271047 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=271047, CurrentID=0, Status='live', Symbol='Serpina3b', Aliases='6A1, A030003A19Rik', description='serine (or cysteine) peptidase inhibitor, clade A, member 3B', other_designations='alpha-1 antiproteinase|antitrypsin|serine (or cysteine) proteinase inhibitor, clade A, member 3B|serpin A3B', map_location='12 E', chromosome='12', genomic_nucleotide_accession_version='NC_000078.6', start_position_on_the_genomic_accession=104127531, end_position_on_the_genomic_accession=104139546, orientation='plus', exon_count=6, OMIM='', no_hdr0=''),
  271127 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=271127, CurrentID=0, Status='live', Symbol='Adamts16', Aliases='', description='a disintegrin-like and metallopeptidase (reprolysin type) with thrombospondin type 1 motif, 16', other_designations='ADAM-TS 16|ADAM-TS16|ADAMTS-16|a disintegrin-like and metallopetidase (reprolysin type) with thrombospondin type 1 motif, 16|a disintegrin-like and metalloprotease (reprolysin type) with thrombospondin type 1 motif, 16 preproprotein', map_location='13 35.97 cM', chromosome='13', genomic_nucleotide_accession_version='NC_000079.6', start_position_on_the_genomic_accession=70727798, end_position_on_the_genomic_accession=70841848, orientation='minus', exon_count=25, OMIM='', no_hdr0=''),
  271144 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=271144, CurrentID=0, Status='live', Symbol='Ankdd1b', Aliases='9330128J19Rik', description='ankyrin repeat and death domain containing 1B', other_designations='ankyrin repeat and death domain-containing protein ENSP00000345065 homolog', map_location='13 D1', chromosome='13', genomic_nucleotide_accession_version='NC_000079.6', start_position_on_the_genomic_accession=96415030, end_position_on_the_genomic_accession=96471354, orientation='minus', exon_count=16, OMIM='', no_hdr0=''),
  271209 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=271209, CurrentID=0, Status='live', Symbol='Rp1l1', Aliases='BC031365, BE983540, Dcdc4, Rp1hl1', description='retinitis pigmentosa 1 homolog (human)-like 1', other_designations='retinitis pigmentosa 1-like protein 1', map_location='14 D1', chromosome='14', genomic_nucleotide_accession_version='NC_000080.6', start_position_on_the_genomic_accession=63992431, end_position_on_the_genomic_accession=64033506, orientation='plus', exon_count=4, OMIM='', no_hdr0=''),
  271221 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=271221, CurrentID=0, Status='live', Symbol='5031414D18Rik', Aliases='Gm744, Gm911, Kiaa0226l', description='RIKEN cDNA 5031414D18 gene', other_designations='', map_location='14 D3', chromosome='14', genomic_nucleotide_accession_version='NC_000080.6', start_position_on_the_genomic_accession=75015878, end_position_on_the_genomic_accession=75052537, orientation='plus', exon_count=15, OMIM='', no_hdr0=''),
  271278 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=271278, CurrentID=0, Status='live', Symbol='BC024139', Aliases='6230424I18Rik', description='cDNA sequence BC024139', other_designations='', map_location='15 D3', chromosome='15', genomic_nucleotide_accession_version='NC_000081.6', start_position_on_the_genomic_accession=76119517, end_position_on_the_genomic_accession=76126556, orientation='minus', exon_count=16, OMIM='', no_hdr0=''),
  271305 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=271305, CurrentID=0, Status='live', Symbol='Phf21b', Aliases='A730032D07Rik', description='PHD finger protein 21B', other_designations='', map_location='15 E2', chromosome='15', genomic_nucleotide_accession_version='NC_000081.6', start_position_on_the_genomic_accession=84785376, end_position_on_the_genomic_accession=84856132, orientation='minus', exon_count=14, OMIM='', no_hdr0=''),
  67063 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=67063, CurrentID=0, Status='live', Symbol='Tmem246', Aliases='2810432L12Rik, 9330170P15Rik, AI835809', description='transmembrane protein 246', other_designations='transmembrane protein C9orf125 homolog', map_location='4 B1', chromosome='4', genomic_nucleotide_accession_version='NC_000070.6', start_position_on_the_genomic_accession=49584506, end_position_on_the_genomic_accession=49597870, orientation='minus', exon_count=4, OMIM='', no_hdr0=''),
  271375 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=271375, CurrentID=0, Status='live', Symbol='Cd200r2', Aliases='AY230198, Cd200r1l', description='Cd200 receptor 2', other_designations='CD200 cell surface glycoprotein receptor|CD200 cell surface glycoprotein receptor-like 2|CD200 cell surface glycoprotein receptor-like c|CD200 receptor-like 2|CD200RLc|cell surface glycoprotein OX2 receptor 2', map_location='16 B4', chromosome='16', genomic_nucleotide_accession_version='NC_000082.6', start_position_on_the_genomic_accession=44867097, end_position_on_the_genomic_accession=44915840, orientation='plus', exon_count=6, OMIM='', no_hdr0=''),
  271377 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=271377, CurrentID=0, Status='live', Symbol='Zbtb11', Aliases='9230110G02Rik, ZNF-U69274', description='zinc finger and BTB domain containing 11', other_designations='', map_location='16 C1.1', chromosome='16', genomic_nucleotide_accession_version='NC_000082.6', start_position_on_the_genomic_accession=55972697, end_position_on_the_genomic_accession=56008913, orientation='plus', exon_count=12, OMIM='', no_hdr0=''),
  664608 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=664608, CurrentID=0, Status='live', Symbol='Rhox4g', Aliases='Rhox4.6, Rhox4.7, Rhox4f', description='reproductive homeobox 4G', other_designations='reproductive homeobox 4F', map_location='X A3.2', chromosome='X', genomic_nucleotide_accession_version='NC_000086.7', start_position_on_the_genomic_accession=37646501, end_position_on_the_genomic_accession=37651327, orientation='minus', exon_count=4, OMIM='', no_hdr0=''),
  664609 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=664609, CurrentID=0, Status='live', Symbol='Rhox4a', Aliases='Rhox4, Rhox4.1', description='reproductive homeobox 4A', other_designations='', map_location='X A3.3', chromosome='X', genomic_nucleotide_accession_version='NC_000086.7', start_position_on_the_genomic_accession=37265318, end_position_on_the_genomic_accession=37270136, orientation='plus', exon_count=4, OMIM='', no_hdr0=''),
  664610 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=664610, CurrentID=0, Status='live', Symbol='Rhox4d', Aliases='Rhox4.4, Rhox4c', description='reproductive homeobox 4D', other_designations='', map_location='X A3.2', chromosome='X', genomic_nucleotide_accession_version='NC_000086.7', start_position_on_the_genomic_accession=37514389, end_position_on_the_genomic_accession=37519176, orientation='plus', exon_count=4, OMIM='', no_hdr0=''),
  271424 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=271424, CurrentID=0, Status='live', Symbol='Ip6k3', Aliases='D830007E07Rik, Ihpk3', description='inositol hexaphosphate kinase 3', other_designations='insP6 kinase 3', map_location='17 A3.3', chromosome='17', genomic_nucleotide_accession_version='NC_000083.6', start_position_on_the_genomic_accession=27143971, end_position_on_the_genomic_accession=27167764, orientation='minus', exon_count=6, OMIM='', no_hdr0=''),
  241846 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=241846, CurrentID=0, Status='live', Symbol='Lsm14b', Aliases='9430078B04, BC040823', description='LSM family member 14B', other_designations='LSM14 homolog B|RNA-associated protein 55B|mRAP55B', map_location='2 H4', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=180024902, end_position_on_the_genomic_accession=180035466, orientation='plus', exon_count=10, OMIM='', no_hdr0=''),
  271457 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=271457, CurrentID=0, Status='live', Symbol='Rab5a', Aliases='2410015H04Rik, AI663973, AU021172, nnyRab5a', description='RAB5A, member RAS oncogene family', other_designations='', map_location='17 27.82 cM', chromosome='17', genomic_nucleotide_accession_version='NC_000083.6', start_position_on_the_genomic_accession=53479234, end_position_on_the_genomic_accession=53507678, orientation='plus', exon_count=6, OMIM='', no_hdr0=''),
  140474 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=140474, CurrentID=0, Status='live', Symbol='Muc4', Aliases='4933405I11Rik, Asgp', description='mucin 4', other_designations='ascites sialoglycoprotein|mucin 4, ASGP|pancreatic adenocarcinoma mucin|testis mucin', map_location='16 B3', chromosome='16', genomic_nucleotide_accession_version='NC_000082.6', start_position_on_the_genomic_accession=32735886, end_position_on_the_genomic_accession=32782391, orientation='plus', exon_count=25, OMIM='', no_hdr0=''),
  140475 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=140475, CurrentID=0, Status='live', Symbol='Bsnd', Aliases='', description='Bartter syndrome, infantile, with sensorineural deafness (Barttin)', other_designations='', map_location='4 C7', chromosome='4', genomic_nucleotide_accession_version='NC_000070.6', start_position_on_the_genomic_accession=106483456, end_position_on_the_genomic_accession=106492243, orientation='minus', exon_count=4, OMIM='', no_hdr0=''),
  140476 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=140476, CurrentID=0, Status='live', Symbol='Strc', Aliases='DFNB16', description='stereocilin', other_designations='', map_location='2 E5', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=121363248, end_position_on_the_genomic_accession=121381370, orientation='minus', exon_count=31, OMIM='', no_hdr0=''),
  140477 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=140477, CurrentID=0, Status='live', Symbol='Dmbx1', Aliases='Atx, Cdmx, Mbx, Otx3', description='diencephalon/mesencephalon homeobox 1', other_designations='diencephalon/mesencephalon-expressed brain homeobox gene 1 protein|dmbx1|homeobox gene Atx|orthodenticle homolog 3|paired-like homeobox protein DMBX1|paired-type homeobox Atx', map_location='4 53.07 cM', chromosome='4', genomic_nucleotide_accession_version='NC_000070.6', start_position_on_the_genomic_accession=115915119, end_position_on_the_genomic_accession=115939926, orientation='minus', exon_count=6, OMIM='', no_hdr0=''),
  140481 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=140481, CurrentID=0, Status='live', Symbol='Man2a2', Aliases='1700052O22Rik, 4931438M07Rik, AI480988, MX, Man IIx', description='mannosidase 2, alpha 2', other_designations='alpha mannosidase IIx|alpha-mannosidase IIx|mannosidase alpha class 2A member 2|mannosidase, alpha, class 2A, member 2|mannosyl-oligosaccharide 1,3-1,6-alpha-mannosidase', map_location='7 D2', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=80349097, end_position_on_the_genomic_accession=80371486, orientation='minus', exon_count=24, OMIM='', no_hdr0=''),
  140482 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=140482, CurrentID=0, Status='live', Symbol='Zfp358', Aliases='Zfend', description='zinc finger protein 358', other_designations='', map_location='8 1.92 cM', chromosome='8', genomic_nucleotide_accession_version='NC_000074.6', start_position_on_the_genomic_accession=3493075, end_position_on_the_genomic_accession=3497208, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  140483 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=140483, CurrentID=0, Status='live', Symbol='Hnmt', Aliases='1500031F01Rik, AI788969', description='histamine N-methyltransferase', other_designations='HMT', map_location='2 A3', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=24002911, end_position_on_the_genomic_accession=24049757, orientation='minus', exon_count=9, OMIM='', no_hdr0=''),
  140484 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=140484, CurrentID=0, Status='live', Symbol='Pofut1', Aliases='O-FucT-1, mKIAA0180', description='protein O-fucosyltransferase 1', other_designations='peptide-O-fucosyltransferase 1', map_location='2 H2', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=153241532, end_position_on_the_genomic_accession=153271029, orientation='plus', exon_count=8, OMIM='', no_hdr0=''),
  140486 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=140486, CurrentID=0, Status='live', Symbol='Igf2bp1', Aliases='AL024068, AW549074, CRD-BP, Crdbp, D030026A21Rik, D11Moh40e, D11Moh45, IMP-1, Neilsen, ZBP-1, Zbp1, mir-3063', description='insulin-like growth factor 2 mRNA binding protein 1', other_designations='IGF-II mRNA-binding protein 1|IGF2 mRNA-binding protein 1|VICKZ family member 1|coding region determinant binding protein|coding region determinant-binding protein|insulin-like growth factor 2 mRNA binding protein 1 dN CRDBP-2|insulin-like growth factor 2 mRNA binding protein 1 deltaN CRDBP|insulin-like growth factor 2, binding protein 1|zipcode binding protein 1|zipcode-binding protein 1', map_location='11 59.08 cM', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=95957163, end_position_on_the_genomic_accession=96005944, orientation='minus', exon_count=15, OMIM='', no_hdr0=''),
  140488 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=140488, CurrentID=0, Status='live', Symbol='Igf2bp3', Aliases='2610101N11Rik, AA522010, AL022933, AU045931, IMP-3, IMP3, Koc13, Neilsen, mimp3', description='insulin-like growth factor 2 mRNA binding protein 3', other_designations='IGF-II mRNA-binding protein 3|IGF2 mRNA-binding protein 3|VICKZ family member 3|insulin-like growth factor 2, binding protein 3|mIMP-3', map_location='6 23.82 cM', chromosome='6', genomic_nucleotide_accession_version='NC_000072.6', start_position_on_the_genomic_accession=49085218, end_position_on_the_genomic_accession=49215009, orientation='minus', exon_count=17, OMIM='', no_hdr0=''),
  140489 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=140489, CurrentID=0, Status='live', Symbol='Bhlhe23', Aliases='A930001L02Rik, BETA4, Bhlhb4', description='basic helix-loop-helix family, member e23', other_designations='basic helix-loop-helix domain containing, class B4|beta-cell E-box transactivating factor 4|class B basic helix-loop-helix protein 4', map_location='2 103.34 cM', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=180774381, end_position_on_the_genomic_accession=180776900, orientation='minus', exon_count=1, OMIM='', no_hdr0=''),
  140491 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=140491, CurrentID=0, Status='live', Symbol='Ppp1r3a', Aliases='GM, RG1, RGL', description='protein phosphatase 1, regulatory (inhibitor) subunit 3A', other_designations='protein phosphatase 1 glycogen-associated regulatory subunit|protein phosphatase type-1 glycogen targeting subunit', map_location='6 A2', chromosome='6', genomic_nucleotide_accession_version='NC_000072.6', start_position_on_the_genomic_accession=14713822, end_position_on_the_genomic_accession=14755274, orientation='minus', exon_count=4, OMIM='', no_hdr0=''),
  140492 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=140492, CurrentID=0, Status='live', Symbol='Kcnn2', Aliases='KCa2.2, SK2, SKCA2, bc, fri', description='potassium intermediate/small conductance calcium-activated channel, subfamily N, member 2', other_designations='bouncy|small conductance calcium-activated potassium channel subfamily N member 2', map_location='18 C', chromosome='18', genomic_nucleotide_accession_version='NC_000084.6', start_position_on_the_genomic_accession=45268764, end_position_on_the_genomic_accession=45685887, orientation='plus', exon_count=13, OMIM='', no_hdr0=''),
  140493 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=140493, CurrentID=0, Status='live', Symbol='Kcnn3', Aliases='KCa2.3, SK3, SKCA3', description='potassium intermediate/small conductance calcium-activated channel, subfamily N, member 3', other_designations='SKCa 3|small conductance calcium-activated potassium channel 3', map_location='3 F2', chromosome='3', genomic_nucleotide_accession_version='NC_000069.6', start_position_on_the_genomic_accession=89520164, end_position_on_the_genomic_accession=89672494, orientation='plus', exon_count=8, OMIM='', no_hdr0=''),
  140494 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=140494, CurrentID=0, Status='live', Symbol='Atp6v0a4', Aliases='Atp6n1b, a4', description='ATPase, H+ transporting, lysosomal V0 subunit A4', other_designations='ATPase, H+ transporting, lysosomal (vacuolar proton pump) noncatalytic accessory protein 1B|V-ATPase 116 kDa|V-ATPase alpha 4|V-type proton ATPase 116 kDa subunit a|vacuolar proton translocating ATPase 100 kDa a4 subunit|vacuolar proton translocating ATPase 116 kDa subunit a kidney isoform', map_location='6 B1', chromosome='6', genomic_nucleotide_accession_version='NC_000072.6', start_position_on_the_genomic_accession=38048483, end_position_on_the_genomic_accession=38124586, orientation='minus', exon_count=21, OMIM='', no_hdr0=''),
  664783 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=664783, CurrentID=0, Status='live', Symbol='Dux', Aliases='AW8220734, Duxbl, EG664783, Dux', description='double homeobox', other_designations='homeobox protein', map_location='10', chromosome='10', genomic_nucleotide_accession_version='NC_000076.5', start_position_on_the_genomic_accession=57693399, end_position_on_the_genomic_accession=57695423, orientation='minus', exon_count=1, OMIM='', no_hdr0=''),
  140497 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=140497, CurrentID=0, Status='live', Symbol='AF251705', Aliases='CLM4, Cd300c, Cd300d, DIgR1, Igsf7, Lmir2, MAIR-II', description='cDNA sequence AF251705', other_designations='CLM|Cd300C antigen|Cd300D antigen|MAIR-2|dendritic cell-derived Ig-like receptor 1|dendritic cell-derived immunoglobulin receptor 1|immunoglobulin superfamily member 7|immunoglobulin superfamily, member 7|leukocyte mono-Ig-like receptor 2|myeloid-associated immunoglobulin-like receptor 2|myeloid-associated immunoglobulin-like receptor II', map_location='11 80.57 cM', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=114996721, end_position_on_the_genomic_accession=115004357, orientation='minus', exon_count=7, OMIM='', no_hdr0=''),
  140498 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=140498, CurrentID=0, Status='live', Symbol='Rxfp2', Aliases='Gpr106, Great, Lgr8', description='relaxin/insulin-like family peptide receptor 2', other_designations='G protein coupled receptor affecting testicular descent|G protein-coupled receptor 106|leucine-rich repeat-containing G protein-coupled receptor 8', map_location='5 89.23 cM', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=150017781, end_position_on_the_genomic_accession=150082550, orientation='plus', exon_count=22, OMIM='', no_hdr0=''),
  140499 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=140499, CurrentID=0, Status='live', Symbol='Ube2j2', Aliases='1200007B18Rik, 2400008G19Rik, 5730472G04Rik, AL022923, NCUBE-2, Ubc6, Ubc6p', description='ubiquitin-conjugating enzyme E2J 2', other_designations='Ubc6p homolog|non-canonical ubiquitin-conjugating enzyme 2|ubiquitin conjugating enzyme 6|ubiquitin-conjugating enzyme E2, J2 homolog', map_location='4 87.66 cM', chromosome='4', genomic_nucleotide_accession_version='NC_000070.6', start_position_on_the_genomic_accession=155943813, end_position_on_the_genomic_accession=155959604, orientation='plus', exon_count=9, OMIM='', no_hdr0=''),
  140500 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=140500, CurrentID=0, Status='live', Symbol='Acap3', Aliases='Centb5, Kiaa1716-hp, mKIAA1716', description='ArfGAP with coiled-coil, ankyrin repeat and PH domains 3', other_designations='centaurin, beta 5', map_location='4 87.66 cM', chromosome='4', genomic_nucleotide_accession_version='NC_000070.6', start_position_on_the_genomic_accession=155891875, end_position_on_the_genomic_accession=155907251, orientation='plus', exon_count=26, OMIM='', no_hdr0=''),
  664799 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=664799, CurrentID=0, Status='live', Symbol='Ctcfl', Aliases='Boris, OTTMUSG00000016680', description='CCCTC-binding factor (zinc finger protein)-like', other_designations='BORIS|Brother of the regulator of imprinted sites|CTCF paralog|CTCF-like protein|likely orthologue of H. sapiens CCCTC-binding factor-like protein (CTCFL)', map_location='2 H3', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=173093609, end_position_on_the_genomic_accession=173119525, orientation='minus', exon_count=11, OMIM='', no_hdr0=''),
  664805 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=664805, CurrentID=0, Status='live', Symbol='Skor2', Aliases='Corl2, EG664805, Fussel18, Gm7348', description='SKI family transcriptional corepressor 2', other_designations='LBX1 corepressor 1-like protein|functional Smad suppressor element on chromosome 18|fussel-18 homolog|ladybird homeobox corepressor 1-like protein|transcriptional corepressor Corl2', map_location='18 E3', chromosome='18', genomic_nucleotide_accession_version='NC_000084.6', start_position_on_the_genomic_accession=76846734, end_position_on_the_genomic_accession=76901032, orientation='plus', exon_count=10, OMIM='', no_hdr0=''),
  664829 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=664829, CurrentID=0, Status='live', Symbol='Slx', Aliases='EG664958, Xmr', description='Sycp3 like X-linked', other_designations='', map_location='X A2', chromosome='X', genomic_nucleotide_accession_version='NC_000086.7', start_position_on_the_genomic_accession=26522657, end_position_on_the_genomic_accession=26545565, orientation='minus', exon_count=9, OMIM='', no_hdr0=''),
  241877 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=241877, CurrentID=0, Status='live', Symbol='Slc10a5', Aliases='Gm405, mP5', description='solute carrier family 10 (sodium/bile acid cotransporter family), member 5', other_designations='Na(+)/bile acid cotransporter 5|solute carrier family 10 member 5', map_location='3 A1', chromosome='3', genomic_nucleotide_accession_version='NC_000069.6', start_position_on_the_genomic_accession=10331734, end_position_on_the_genomic_accession=10335656, orientation='minus', exon_count=1, OMIM='', no_hdr0=''),
  140546 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=140546, CurrentID=0, Status='live', Symbol='Eri3', Aliases='PINT1, Prnpip1', description='exoribonuclease 3', other_designations='prion interactor 1|prion protein interacting protein 1|prion protein-interacting protein', map_location='4 D1', chromosome='4', genomic_nucleotide_accession_version='NC_000070.6', start_position_on_the_genomic_accession=117550293, end_position_on_the_genomic_accession=117674297, orientation='plus', exon_count=15, OMIM='', no_hdr0=''),
  329260 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=329260, CurrentID=0, Status='live', Symbol='Dennd1b', Aliases='4632404N19Rik, 4930467M19Rik, 6820401H01Rik, F730008N07Rik', description='DENN/MADD domain containing 1B', other_designations='ASL1/9AS1-1 fusion|connecdenn 2', map_location='1 F', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=138963446, end_position_on_the_genomic_accession=139176043, orientation='plus', exon_count=24, OMIM='', no_hdr0=''),
  140557 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=140557, CurrentID=0, Status='live', Symbol='Smc1b', Aliases='SMC-1B, SMC1beta, Smc1l2', description='structural maintenance of chromosomes 1B', other_designations='SMC protein 1B|SMC-1-beta|structural maintenace of chromosomes 1B', map_location='15 E3', chromosome='15', genomic_nucleotide_accession_version='NC_000081.6', start_position_on_the_genomic_accession=85064689, end_position_on_the_genomic_accession=85131957, orientation='minus', exon_count=25, OMIM='', no_hdr0=''),
  140559 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=140559, CurrentID=0, Status='live', Symbol='Igsf8', Aliases='ESTM34, EWI-2, KCT-4, PGRL', description='immunoglobulin superfamily, member 8', other_designations='CD81 partner 3|PG regulatory-like protein|glu-Trp-Ile EWI motif-containing protein 2|keratinocyte-associated transmembrane protein 4|prostaglandin regulatory-like protein', map_location='1 79.59 cM', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=172312407, end_position_on_the_genomic_accession=172319841, orientation='plus', exon_count=7, OMIM='', no_hdr0=''),
  271639 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=271639, CurrentID=0, Status='live', Symbol='Adcy10', Aliases='4930431D04Rik, 4931412F17, Sacy, sAC', description='adenylate cyclase 10', other_designations='germ cell soluble adenylyl cyclase|testicular soluble adenylyl cyclase', map_location='1 H2.3', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=165483869, end_position_on_the_genomic_accession=165576778, orientation='plus', exon_count=35, OMIM='', no_hdr0=''),
  140570 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=140570, CurrentID=0, Status='live', Symbol='Plxnb2', Aliases='Debt, plexin-B2', description='plexin B2', other_designations='differentially expressed in brain tumors', map_location='15 44.68 cM', chromosome='15', genomic_nucleotide_accession_version='NC_000081.6', start_position_on_the_genomic_accession=89155546, end_position_on_the_genomic_accession=89181140, orientation='minus', exon_count=40, OMIM='', no_hdr0=''),
  140571 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=140571, CurrentID=0, Status='live', Symbol='Plxnb3', Aliases='AI451018, Plxn6', description='plexin B3', other_designations='plexin 6|plexin-6', map_location='X A7.3', chromosome='X', genomic_nucleotide_accession_version='NC_000086.7', start_position_on_the_genomic_accession=73756559, end_position_on_the_genomic_accession=73772510, orientation='plus', exon_count=33, OMIM='', no_hdr0=''),
  664862 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=664862, CurrentID=0, Status='live', Symbol='Gpr137b-ps', Aliases='2310041G17Rik, ENSMUSG00000075118', description='G protein-coupled receptor 137B, pseudogene', other_designations='', map_location='13 A1', chromosome='13', genomic_nucleotide_accession_version='NC_000079.6', start_position_on_the_genomic_accession=12614065, end_position_on_the_genomic_accession=12650395, orientation='minus', exon_count=7, OMIM='', no_hdr0=''),
  140577 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=140577, CurrentID=0, Status='live', Symbol='Ankrd6', Aliases='', description='ankyrin repeat domain 6', other_designations='diversin', map_location='4 A5', chromosome='4', genomic_nucleotide_accession_version='NC_000070.6', start_position_on_the_genomic_accession=32804027, end_position_on_the_genomic_accession=32950884, orientation='minus', exon_count=21, OMIM='', no_hdr0=''),
  140579 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=140579, CurrentID=0, Status='live', Symbol='Elmo2', Aliases='1190002F24Rik, CED-12', description='engulfment and cell motility 2', other_designations='CED-12 homolog A', map_location='2 H3', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=165288031, end_position_on_the_genomic_accession=165326479, orientation='minus', exon_count=24, OMIM='', no_hdr0=''),
  140580 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=140580, CurrentID=0, Status='live', Symbol='Elmo1', Aliases='6330578D22Rik, C230095H21Rik, CED-12', description='engulfment and cell motility 1', other_designations='engulfment and cell motility 1, ced-12 homolog', map_location='13 A3.1', chromosome='13', genomic_nucleotide_accession_version='NC_000079.6', start_position_on_the_genomic_accession=20090240, end_position_on_the_genomic_accession=20608353, orientation='plus', exon_count=26, OMIM='', no_hdr0=''),
  402734 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=402734, CurrentID=0, Status='live', Symbol='C730036E19Rik', Aliases='lncLSTR', description='RIKEN cDNA C730036E19 gene', other_designations='liver-specific triglyceride regulator', map_location='1', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=151138034, end_position_on_the_genomic_accession=151144095, orientation='plus', exon_count=7, OMIM='', no_hdr0=''),
  664883 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=664883, CurrentID=0, Status='live', Symbol='Nova1', Aliases='9430099M15Rik, G630039L02, Nova-1', description='neuro-oncological ventral antigen 1', other_designations='ventral neuron-specific protein 1', map_location='12 21.46 cM', chromosome='12', genomic_nucleotide_accession_version='NC_000078.6', start_position_on_the_genomic_accession=46694517, end_position_on_the_genomic_accession=46819194, orientation='minus', exon_count=10, OMIM='', no_hdr0=''),
  271697 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=271697, CurrentID=0, Status='live', Symbol='Cdk15', Aliases='Als2cr7, Pftk2', description='cyclin-dependent kinase 15', other_designations='PFTAIRE protein kinase 2|amyotrophic lateral sclerosis 2 (juvenile) chromosome region, candidate 7|amyotrophic lateral sclerosis 2 chromosomal region candidate gene 7 protein homolog|cell division protein kinase 15|serine/threonine-protein kinase ALS2CR7|serine/threonine-protein kinase PFTAIRE-2', map_location='1 C1.3', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=59256889, end_position_on_the_genomic_accession=59352612, orientation='plus', exon_count=15, OMIM='', no_hdr0=''),
  140629 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=140629, CurrentID=0, Status='live', Symbol='Ubox5', Aliases='1500010O06Rik, C330018L13Rik, Rnf37, UIP5, Ubce7ip5, Ube7ip5', description='U box domain containing 5', other_designations='U-box domain-containing protein 5|UbcM4-interacting protein 5|ubiquitin conjugating enzyme 7 interacting protein 5|ubiquitin-conjugating enzyme 7-interacting protein 5', map_location='2 F3', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=130589996, end_position_on_the_genomic_accession=130630038, orientation='minus', exon_count=7, OMIM='', no_hdr0=''),
  140630 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=140630, CurrentID=0, Status='live', Symbol='Ube4a', Aliases='4732444G18Rik, 9930123J21Rik, UFD2b', description='ubiquitination factor E4A', other_designations='ubiquitination factor E4A, UFD2 homolog', map_location='9 A5.2', chromosome='9', genomic_nucleotide_accession_version='NC_000075.6', start_position_on_the_genomic_accession=44923127, end_position_on_the_genomic_accession=44965600, orientation='minus', exon_count=22, OMIM='', no_hdr0=''),
  329274 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=329274, CurrentID=0, Status='live', Symbol='Fam163a', Aliases='A230106N23Rik', description='family with sequence similarity 163, member A', other_designations='cebelin', map_location='1 G3', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=156075956, end_position_on_the_genomic_accession=156087888, orientation='minus', exon_count=4, OMIM='', no_hdr0=''),
  271711 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=271711, CurrentID=0, Status='live', Symbol='Tmem169', Aliases='A830020B06Rik', description='transmembrane protein 169', other_designations='', map_location='1 C3', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=72284362, end_position_on_the_genomic_accession=72303104, orientation='plus', exon_count=4, OMIM='', no_hdr0=''),
  67134 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=67134, CurrentID=0, Status='live', Symbol='Nop56', Aliases='2310044F10Rik, Nol5a', description='NOP56 ribonucleoprotein', other_designations='56kDa with KKE/D repeat|NOP56 ribonucleoprotein homolog|nucleolar protein 5A', map_location='2 F3', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=130274367, end_position_on_the_genomic_accession=130279313, orientation='plus', exon_count=13, OMIM='', no_hdr0=''),
  664968 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=664968, CurrentID=0, Status='live', Symbol='Tmem238', Aliases='2210411K11Rik', description='transmembrane protein 238', other_designations='', map_location='7 A1', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=4784785, end_position_on_the_genomic_accession=4789560, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  140703 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=140703, CurrentID=0, Status='live', Symbol='Emid1', Aliases='AW122071, CO-5, Emu1', description='EMI domain containing 1', other_designations='Emu1|emilin and multimerin domain-containing protein 1', map_location='11 A1', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=5106265, end_position_on_the_genomic_accession=5152298, orientation='minus', exon_count=21, OMIM='', no_hdr0=''),
  664994 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=664994, CurrentID=0, Status='live', Symbol='Isoc2a', Aliases='Isoc2', description='isochorismatase domain containing 2a', other_designations='isoc2a|isochorismatase domain-containing protein 2A, mitochondrial', map_location='7 A1', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=4877053, end_position_on_the_genomic_accession=4895717, orientation='plus', exon_count=6, OMIM='', no_hdr0=''),
  140709 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=140709, CurrentID=0, Status='live', Symbol='Col26a1', Aliases='9430032K24Rik, BC002218, Col26a, Emid2, Emu2', description='collagen, type XXVI, alpha 1', other_designations='Collagen XXVI|EMI domain containing 2|EMI domain-containing protein 2|Emu2|alpha-1 type XXVI collagen|emilin and multimerin domain-containing protein 2|procollagen, type XXVI, alpha 1', map_location='5 G1', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=136741759, end_position_on_the_genomic_accession=136883376, orientation='minus', exon_count=19, OMIM='', no_hdr0=''),
  665001 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=665001, CurrentID=0, Status='live', Symbol='Gm14391', Aliases='OTTMUSG00000016543', description='predicted gene 14391', other_designations='', map_location='2', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=175185165, end_position_on_the_genomic_accession=175206924, orientation='minus', exon_count=6, OMIM='', no_hdr0=''),
  271786 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=271786, CurrentID=0, Status='live', Symbol='Galnt13', Aliases='A230002A12, A230020F20, BB182356', description='UDP-N-acetyl-alpha-D-galactosamine:polypeptide N-acetylgalactosaminyltransferase 13', other_designations='UDP-GalNAc:polypeptide N-acetylgalactosaminyltransferase 13|galNAc-T13|polypeptide GalNAc transferase 13|pp-GaNTase 13|pp-GalNAc-T13|protein-UDP acetylgalactosaminyltransferase 13', map_location='2 C1.1', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=54436387, end_position_on_the_genomic_accession=55118309, orientation='plus', exon_count=18, OMIM='', no_hdr0=''),
  140721 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=140721, CurrentID=0, Status='live', Symbol='Caskin2', Aliases='1600028L06Rik, mKIAA1139', description='CASK-interacting protein 2', other_designations='', map_location='11 E2', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=115799183, end_position_on_the_genomic_accession=115813592, orientation='minus', exon_count=21, OMIM='', no_hdr0=''),
  140723 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=140723, CurrentID=0, Status='live', Symbol='Cacng5', Aliases='', description='calcium channel, voltage-dependent, gamma subunit 5', other_designations='TARP gamma-5|neuronal voltage-gated calcium channel gamma-5 subunit|transmembrane AMPAR regulatory protein gamma-5|voltage dependent calcium channel gamma 5 subunit', map_location='11 E1', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=107874604, end_position_on_the_genomic_accession=107915055, orientation='minus', exon_count=8, OMIM='', no_hdr0=''),
  140740 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=140740, CurrentID=0, Status='live', Symbol='Sec63', Aliases='5730478J10Rik, AI649014, AW319215', description='SEC63-like (S. cerevisiae)', other_designations='', map_location='10 22.89 cM', chromosome='10', genomic_nucleotide_accession_version='NC_000076.6', start_position_on_the_genomic_accession=42761496, end_position_on_the_genomic_accession=42832514, orientation='plus', exon_count=21, OMIM='', no_hdr0=''),
  271813 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=271813, CurrentID=0, Status='live', Symbol='Agbl2', Aliases='4930524K04, A430081C19Rik, CCP2', description='ATP/GTP binding protein-like 2', other_designations='ATP/GTP-binding protein-like 2|carboxypeptidase 2, cytosolic', map_location='2 E1', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=90782587, end_position_on_the_genomic_accession=90834437, orientation='plus', exon_count=26, OMIM='', no_hdr0=''),
  140742 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=140742, CurrentID=0, Status='live', Symbol='Sesn1', Aliases='1110002G11Rik, AU044290, Pa26, Sest1', description='sestrin 1', other_designations='p53 regulated Pa26 nuclear protein|p53-regulated protein PA26', map_location='10 22.77 cM', chromosome='10', genomic_nucleotide_accession_version='NC_000076.6', start_position_on_the_genomic_accession=41810574, end_position_on_the_genomic_accession=41908436, orientation='plus', exon_count=11, OMIM='', no_hdr0=''),
  140743 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=140743, CurrentID=0, Status='live', Symbol='Rem2', Aliases='AW411893', description='rad and gem related GTP binding protein 2', other_designations='rad and Gem-like GTP-binding protein 2', map_location='14 C3', chromosome='14', genomic_nucleotide_accession_version='NC_000080.6', start_position_on_the_genomic_accession=54476100, end_position_on_the_genomic_accession=54480434, orientation='plus', exon_count=5, OMIM='', no_hdr0=''),
  665033 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=665033, CurrentID=0, Status='live', Symbol='Col6a5', Aliases='Col29a1, EG665033, Gm7455', description='collagen, type VI, alpha 5', other_designations='collagen alpha-1(XXIX) chain', map_location='9', chromosome='9', genomic_nucleotide_accession_version='NC_000075.6', start_position_on_the_genomic_accession=105856070, end_position_on_the_genomic_accession=105960643, orientation='minus', exon_count=41, OMIM='', no_hdr0=''),
  140765 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=140765, CurrentID=0, Status='live', Symbol='Tmprss3', Aliases='', description='transmembrane protease, serine 3', other_designations='transmembrane proteinase serine 3', map_location='17 A3.3', chromosome='17', genomic_nucleotide_accession_version='NC_000083.6', start_position_on_the_genomic_accession=31179265, end_position_on_the_genomic_accession=31209743, orientation='minus', exon_count=14, OMIM='', no_hdr0=''),
  271842 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=271842, CurrentID=0, Status='live', Symbol='Rpusd2', Aliases='4921503C21Rik, 9630001E10, BB231107', description='RNA pseudouridylate synthase domain containing 2', other_designations='', map_location='2 E5', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=119034790, end_position_on_the_genomic_accession=119042198, orientation='plus', exon_count=3, OMIM='', no_hdr0=''),
  271844 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=271844, CurrentID=0, Status='live', Symbol='Pla2g4f', Aliases='4732472I07Rik, Gm647, Pla2zeta', description='phospholipase A2, group IVF', other_designations='cPLA2-zeta', map_location='2 E5', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=120299952, end_position_on_the_genomic_accession=120314320, orientation='minus', exon_count=20, OMIM='', no_hdr0=''),
  271849 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=271849, CurrentID=0, Status='live', Symbol='Shc4', Aliases='6230417E10Rik, 9930029B02Rik, Gm685, RaLP', description='SHC (Src homology 2 domain containing) family, member 4', other_designations='SH2 domain protein C4|SHC-transforming protein D|mShcD|novel phosphotyrosine interaction domain (PTB/PID) and SH2 domains containing protein|rai-like protein RaLP|src homology 2 domain-containing-transforming protein C4', map_location='2 F1', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=125627447, end_position_on_the_genomic_accession=125724160, orientation='minus', exon_count=14, OMIM='', no_hdr0=''),
  140780 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=140780, CurrentID=0, Status='live', Symbol='Bmp2k', Aliases='4933417M22Rik, AA673486, AV128808, BIKE', description='BMP2 inducible kinase', other_designations='', map_location='5 E3', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=96997689, end_position_on_the_genomic_accession=97091048, orientation='plus', exon_count=17, OMIM='', no_hdr0=''),
  140781 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=140781, CurrentID=0, Status='live', Symbol='Myh7', Aliases='B-MHC, MyHC-I, Myhc-b, Myhcb, beta-MHC', description='myosin, heavy polypeptide 7, cardiac muscle, beta', other_designations='MYH-beta/slow|cardiac myosin heavy chain beta isoform|myHC-beta|myHC-slow|myosin heavy chain 7|myosin heavy chain slow isoform|myosin heavy chain, cardiac muscle beta isoform|myosin heavy chain, cardiac muscle, fetal', map_location='14 28.01 cM', chromosome='14', genomic_nucleotide_accession_version='NC_000080.6', start_position_on_the_genomic_accession=54970688, end_position_on_the_genomic_accession=54994549, orientation='minus', exon_count=41, OMIM='', no_hdr0=''),
  140792 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=140792, CurrentID=0, Status='live', Symbol='Colec12', Aliases='CL-P1, SRCL, Scara4', description='collectin sub-family member 12', other_designations='collectin placenta protein 1|scavenger receptor with C-type lectin', map_location='18 A1', chromosome='18', genomic_nucleotide_accession_version='NC_000084.6', start_position_on_the_genomic_accession=9707648, end_position_on_the_genomic_accession=9877995, orientation='plus', exon_count=11, OMIM='', no_hdr0=''),
  140795 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=140795, CurrentID=0, Status='live', Symbol='P2ry14', Aliases='A330108O13Rik, Gpr105, P2Y14', description='purinergic receptor P2Y, G-protein coupled, 14', other_designations='G-protein coupled receptor 105|UDP-glucose receptor', map_location='3 28.96 cM', chromosome='3', genomic_nucleotide_accession_version='NC_000069.6', start_position_on_the_genomic_accession=59114623, end_position_on_the_genomic_accession=59153492, orientation='minus', exon_count=5, OMIM='', no_hdr0=''),
  140806 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=140806, CurrentID=0, Status='live', Symbol='Il25', Aliases='IL-17e, Il17e', description='interleukin 25', other_designations='interleukin 17E', map_location='14 C3', chromosome='14', genomic_nucleotide_accession_version='NC_000080.6', start_position_on_the_genomic_accession=54929401, end_position_on_the_genomic_accession=54935841, orientation='plus', exon_count=6, OMIM='', no_hdr0=''),
  140810 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=140810, CurrentID=0, Status='live', Symbol='Ttbk2', Aliases='2610507N02Rik, AI326283, B930008N24Rik, TTK, Ttbk, Ttbk1, mKIAA0847', description='tau tubulin kinase 2', other_designations='protein bartleby', map_location='2 F1', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=120732816, end_position_on_the_genomic_accession=120850584, orientation='minus', exon_count=17, OMIM='', no_hdr0=''),
  271887 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=271887, CurrentID=0, Status='live', Symbol='Rbbp8nl', Aliases='4732416F18', description='RBBP8 N-terminal like', other_designations='', map_location='2 H4', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=180275246, end_position_on_the_genomic_accession=180289900, orientation='minus', exon_count=14, OMIM='', no_hdr0=''),
  665113 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=665113, CurrentID=0, Status='live', Symbol='Tnik', Aliases='1500031A17Rik, 4831440I19Rik, AI451411, C530008O15Rik, C630040K21Rik', description='TRAF2 and NCK interacting kinase', other_designations='', map_location='3 A3', chromosome='3', genomic_nucleotide_accession_version='NC_000069.6', start_position_on_the_genomic_accession=28263214, end_position_on_the_genomic_accession=28670585, orientation='plus', exon_count=35, OMIM='', no_hdr0=''),
  665119 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=665119, CurrentID=0, Status='live', Symbol='Sec14l5', Aliases='', description='SEC14-like lipid binding 5', other_designations='SEC14-like 5', map_location='16 A1', chromosome='16', genomic_nucleotide_accession_version='NC_000082.6', start_position_on_the_genomic_accession=5146901, end_position_on_the_genomic_accession=5187271, orientation='plus', exon_count=17, OMIM='', no_hdr0=''),
  140858 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=140858, CurrentID=0, Status='live', Symbol='Wdr5', Aliases='2410008O07Rik, AA408785, AA960360, Big, Big-3', description='WD repeat domain 5', other_designations='BMP2-induced 3-kb gene protein|WD repeat-containing protein BIG-3', map_location='2 A3', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=27515147, end_position_on_the_genomic_accession=27536535, orientation='plus', exon_count=15, OMIM='', no_hdr0=''),
  140859 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=140859, CurrentID=0, Status='live', Symbol='Nek8', Aliases='4632401F23Rik, b2b1449Clo, jck', description='NIMA (never in mitosis gene a)-related expressed kinase 8', other_designations='NIMA-related expressed kinase 8|juvenile cystic kidney|never in mitosis A-related kinase 8|nimA-related protein kinase 8', map_location='11 46.74 cM', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=78166106, end_position_on_the_genomic_accession=78176695, orientation='minus', exon_count=15, OMIM='', no_hdr0=''),
  665155 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=665155, CurrentID=0, Status='live', Symbol='Srp54b', Aliases='', description='signal recognition particle 54B', other_designations='SRP54', map_location='12 C1', chromosome='12', genomic_nucleotide_accession_version='NC_000078.6', start_position_on_the_genomic_accession=55155104, end_position_on_the_genomic_accession=55189213, orientation='plus', exon_count=16, OMIM='', no_hdr0=''),
  140887 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=140887, CurrentID=0, Status='live', Symbol='Lnx2', Aliases='9630046H24, AW209022', description='ligand of numb-protein X 2', other_designations='numb-binding protein 2', map_location='5 G2', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=147016655, end_position_on_the_genomic_accession=147076572, orientation='minus', exon_count=11, OMIM='', no_hdr0=''),
  271970 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=271970, CurrentID=0, Status='live', Symbol='Arsj', Aliases='9330196J05Rik, D830047F08', description='arylsulfatase J', other_designations='ASJ', map_location='3 G1', chromosome='3', genomic_nucleotide_accession_version='NC_000069.6', start_position_on_the_genomic_accession=126363250, end_position_on_the_genomic_accession=126440379, orientation='plus', exon_count=3, OMIM='', no_hdr0=''),
  140904 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=140904, CurrentID=0, Status='live', Symbol='Caln1', Aliases='9630012C17Rik, Cabp8, MNCb-0849', description='calneuron 1', other_designations='calneuron I|calneuron-1|calneuron-I', map_location='5 F', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=130369356, end_position_on_the_genomic_accession=130846325, orientation='plus', exon_count=13, OMIM='', no_hdr0=''),
  271981 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=271981, CurrentID=0, Status='live', Symbol='Tbck', Aliases='1700120J03Rik, 9430001M19, A630047E20Rik, C030007I09Rikl, Tbck', description='TBC1 domain containing kinase', other_designations='', map_location='3 G3', chromosome='3', genomic_nucleotide_accession_version='NC_000069.6', start_position_on_the_genomic_accession=132683994, end_position_on_the_genomic_accession=132841688, orientation='plus', exon_count=28, OMIM='', no_hdr0=''),
  140917 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=140917, CurrentID=0, Status='live', Symbol='Dclre1b', Aliases='AI452214, Apollo, SNMIB, mSNM1B', description='DNA cross-link repair 1B', other_designations='DNA cross-link repair 1B protein|DNA cross-link repair 1B, PSO2 homolog|SNM1 homolog B', map_location='3 F2.2', chromosome='3', genomic_nucleotide_accession_version='NC_000069.6', start_position_on_the_genomic_accession=103800605, end_position_on_the_genomic_accession=103809387, orientation='minus', exon_count=4, OMIM='', no_hdr0=''),
  140918 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=140918, CurrentID=0, Status='live', Symbol='Slc7a12', Aliases='Asc-2, XAT1', description='solute carrier family 7 (cationic amino acid transporter, y+ system), member 12', other_designations='Asc-2,asc-type amino acid transporter 2|asc-type amino acid transporter 2', map_location='3 A1', chromosome='3', genomic_nucleotide_accession_version='NC_000069.6', start_position_on_the_genomic_accession=14480691, end_position_on_the_genomic_accession=14505819, orientation='plus', exon_count=4, OMIM='', no_hdr0=''),
  140919 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=140919, CurrentID=0, Status='live', Symbol='Slc17a6', Aliases='2900073D12Rik, DNPI, VGLUT2', description='solute carrier family 17 (sodium-dependent inorganic phosphate cotransporter), member 6', other_designations='differentiation-associated BNPI|differentiation-associated Na(+)-dependent inorganic phosphate cotransporter|solute carrier family 17 (vesicular glutamate transporter), member 6|solute carrier family 17 member 6', map_location='7 B5', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=51621830, end_position_on_the_genomic_accession=51671126, orientation='plus', exon_count=14, OMIM='', no_hdr0=''),
  665211 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=665211, CurrentID=0, Status='live', Symbol='Gm14326', Aliases='OTTMUSG00000016327', description='predicted gene 14326', other_designations='', map_location='2 H4', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=177935993, end_position_on_the_genomic_accession=177958136, orientation='minus', exon_count=7, OMIM='', no_hdr0=''),
  329324 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=329324, CurrentID=0, Status='live', Symbol='Syt14', Aliases='B230320I09Rik, sytXIV', description='synaptotagmin XIV', other_designations='', map_location='1 H6', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=192891233, end_position_on_the_genomic_accession=193035862, orientation='minus', exon_count=14, OMIM='', no_hdr0=''),
  403088 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=403088, CurrentID=0, Status='live', Symbol='Tcaf3', Aliases='Eapa2, Fam115e', description='TRPM8 channel-associated factor 3', other_designations='experimental autoimmune prostatitis antigen 2|family with sequence similarity 115, member E|protein FAM115E', map_location='6 B2.1', chromosome='6', genomic_nucleotide_accession_version='NC_000072.6', start_position_on_the_genomic_accession=42587213, end_position_on_the_genomic_accession=42597372, orientation='minus', exon_count=7, OMIM='', no_hdr0=''),
  272027 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=272027, CurrentID=0, Status='live', Symbol='Tstd2', Aliases='3010020C06', description='thiosulfate sulfurtransferase (rhodanese)-like domain containing 2', other_designations='likely ortholog of H. sapiens chromosome 9 open reading frame 97 (C9orf97)', map_location='4 B1', chromosome='4', genomic_nucleotide_accession_version='NC_000070.6', start_position_on_the_genomic_accession=46114746, end_position_on_the_genomic_accession=46138581, orientation='minus', exon_count=13, OMIM='', no_hdr0=''),
  272031 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=272031, CurrentID=0, Status='live', Symbol='Plppr1', Aliases='E130309F12Rik, Lppr1, PRG-3, mKIAA4247', description='phospholipid phosphatase related 1', other_designations='plasticity-related gene 3 protein|plasticity-related protein 3', map_location='4 B1', chromosome='4', genomic_nucleotide_accession_version='NC_000070.6', start_position_on_the_genomic_accession=49059462, end_position_on_the_genomic_accession=49340261, orientation='plus', exon_count=10, OMIM='', no_hdr0=''),
  665270 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=665270, CurrentID=0, Status='live', Symbol='Plb1', Aliases='4632413E21Rik, 4930433E17Rik, 4930539A06Rik, BC033606', description='phospholipase B1', other_designations='PLB/LIP|phospholipase B|phospholipase B/lipase', map_location='5 B1', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=32232691, end_position_on_the_genomic_accession=32364356, orientation='plus', exon_count=61, OMIM='', no_hdr0=''),
  403171 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=403171, CurrentID=0, Status='live', Symbol='Banf2', Aliases='4930517K23Rik, Baf-L, Baf-like, Gm115', description='barrier to autointegration factor 2', other_designations='barrier-to-autointegration factor 2|likely ortholog of H. sapiens Chromosome 20 open reading frame 179 (C20orf179)', map_location='2 G1', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=144033102, end_position_on_the_genomic_accession=144073979, orientation='plus', exon_count=4, OMIM='', no_hdr0=''),
  403174 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=403174, CurrentID=0, Status='live', Symbol='Msantd1', Aliases='A930005I04Rik, Gm144', description='Myb/SANT-like DNA-binding domain containing 1', other_designations='', map_location='5 B2', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=34907775, end_position_on_the_genomic_accession=34923853, orientation='plus', exon_count=5, OMIM='', no_hdr0=''),
  403175 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=403175, CurrentID=0, Status='live', Symbol='Tigd4', Aliases='C130063O11Rik, Gm418', description='tigger transposable element derived 4', other_designations='', map_location='3 F1', chromosome='3', genomic_nucleotide_accession_version='NC_000069.6', start_position_on_the_genomic_accession=84593574, end_position_on_the_genomic_accession=84597032, orientation='plus', exon_count=1, OMIM='', no_hdr0=''),
  403178 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=403178, CurrentID=0, Status='live', Symbol='Plcxd1', Aliases='A330045H12Rik, Gm576', description='phosphatidylinositol-specific phospholipase C, X domain containing 1', other_designations='', map_location='5 F', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=110099225, end_position_on_the_genomic_accession=110105953, orientation='plus', exon_count=12, OMIM='', no_hdr0=''),
  403180 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=403180, CurrentID=0, Status='live', Symbol='Ccdc121', Aliases='6530421E24Rik, Gm755', description='coiled-coil domain containing 121', other_designations='', map_location='1 H5', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=181509633, end_position_on_the_genomic_accession=181511451, orientation='minus', exon_count=1, OMIM='', no_hdr0=''),
  403183 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=403183, CurrentID=0, Status='live', Symbol='Mettl21e', Aliases='4832428D23Rik, Gm991', description='methyltransferase like 21E', other_designations='methyltransferase-like protein 21C pseudogene 1 homolog|methyltransferase-like protein 21E pseudogene homolog|methyltransferase-like protein LOC121952 homolog', map_location='1 C1.1', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=44204070, end_position_on_the_genomic_accession=44218931, orientation='minus', exon_count=5, OMIM='', no_hdr0=''),
  403187 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=403187, CurrentID=0, Status='live', Symbol='Opa3', Aliases='D630048P19Rik, Gm1425, Gm472', description='optic atrophy 3', other_designations='', map_location='7 A3', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=19228389, end_position_on_the_genomic_accession=19246817, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  403200 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=403200, CurrentID=0, Status='live', Symbol='4930504O13Rik', Aliases='Gm524', description='RIKEN cDNA 4930504O13 gene', other_designations='', map_location='11 B1.3', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=58446143, end_position_on_the_genomic_accession=58452966, orientation='minus', exon_count=4, OMIM='', no_hdr0=''),
  403205 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=403205, CurrentID=0, Status='live', Symbol='Agr3', Aliases='BCMP11, E030025L21Rik, Gm888', description='anterior gradient 3', other_designations='anterior gradient homolog 3|anterior gradient protein 3 homolog', map_location='12 A3', chromosome='12', genomic_nucleotide_accession_version='NC_000078.6', start_position_on_the_genomic_accession=35925621, end_position_on_the_genomic_accession=35949737, orientation='plus', exon_count=10, OMIM='', no_hdr0=''),
  272158 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=272158, CurrentID=0, Status='live', Symbol='Poln', Aliases='POL4P', description='DNA polymerase N', other_designations='DNA-directed DNA polymerase nu', map_location='5 C1', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=34007179, end_position_on_the_genomic_accession=34169526, orientation='minus', exon_count=26, OMIM='', no_hdr0=''),
  665378 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=665378, CurrentID=0, Status='live', Symbol='Gm7609', Aliases='EG665378', description='predicted pseudogene 7609', other_designations='', map_location='1 C5', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=85199592, end_position_on_the_genomic_accession=85215395, orientation='plus', exon_count=6, OMIM='', no_hdr0=''),
  665433 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=665433, CurrentID=0, Status='live', Symbol='Hist1h2ao', Aliases='', description='histone cluster 1, H2ao', other_designations='', map_location='13 A3.1', chromosome='13', genomic_nucleotide_accession_version='NC_000079.6', start_position_on_the_genomic_accession=21810367, end_position_on_the_genomic_accession=21810918, orientation='plus', exon_count=1, OMIM='', no_hdr0=''),
  329360 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=329360, CurrentID=0, Status='live', Symbol='Rnf224', Aliases='Gm757', description='ring finger protein 224', other_designations='', map_location='2 A3', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=25234476, end_position_on_the_genomic_accession=25236787, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  329366 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=329366, CurrentID=0, Status='live', Symbol='Ccdc187', Aliases='4932418E24Rik', description='coiled-coil domain containing 187', other_designations='', map_location='2 A3', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=26243449, end_position_on_the_genomic_accession=26300476, orientation='minus', exon_count=31, OMIM='', no_hdr0=''),
  329375 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=329375, CurrentID=0, Status='live', Symbol='Cfap77', Aliases='1700101E01Rik, Gm823', description='cilia and flagella associated protein 77', other_designations='', map_location='2 A3', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=28927749, end_position_on_the_genomic_accession=29055274, orientation='minus', exon_count=7, OMIM='', no_hdr0=''),
  272322 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=272322, CurrentID=0, Status='live', Symbol='Arntl2', Aliases='4632430A05Rik, BMAL2, CLIF, MOP9, bHLHe6', description='aryl hydrocarbon receptor nuclear translocator-like 2', other_designations='brain and muscle ARNT-like 2|brain-muscle-ARNT-like protein 2', map_location='6 G3', chromosome='6', genomic_nucleotide_accession_version='NC_000072.6', start_position_on_the_genomic_accession=146796015, end_position_on_the_genomic_accession=146833529, orientation='plus', exon_count=18, OMIM='', no_hdr0=''),
  403395 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=403395, CurrentID=0, Status='live', Symbol='Clec3a', Aliases='1110019O10Rik, Clecsf1, Gm796', description='C-type lectin domain family 3, member a', other_designations='C-type calcium dependent, carbohydrate-recognition domain lectin, superfamily member 1, cartilage-derived', map_location='8 E1', chromosome='8', genomic_nucleotide_accession_version='NC_000074.6', start_position_on_the_genomic_accession=114418034, end_position_on_the_genomic_accession=114428133, orientation='plus', exon_count=3, OMIM='', no_hdr0=''),
  102639566 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102639566, CurrentID=0, Status='live', Symbol='Ptgs2os2', Aliases='Gm26687, Linc-cox2, Lincrna-cox2', description='prostaglandin-endoperoxide synthase 2, opposite strand 2', other_designations='long non-coding RNA Cox2', map_location='1', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=150159043, end_position_on_the_genomic_accession=150164948, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  272347 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=272347, CurrentID=0, Status='live', Symbol='Zfp398', Aliases='5730513I23Rik', description='zinc finger protein 398', other_designations='', map_location='6 B3', chromosome='6', genomic_nucleotide_accession_version='NC_000072.6', start_position_on_the_genomic_accession=47835661, end_position_on_the_genomic_accession=47873537, orientation='plus', exon_count=8, OMIM='', no_hdr0=''),
  272359 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=272359, CurrentID=0, Status='live', Symbol='Irf2bp1', Aliases='6330414O09Rik, C530033F24', description='interferon regulatory factor 2 binding protein 1', other_designations='IRF-2-binding protein 1|IRF-2BP1|probable E3 ubiquitin-protein ligase IRF2BP1', map_location='7 A3', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=19004065, end_position_on_the_genomic_accession=19006763, orientation='plus', exon_count=1, OMIM='', no_hdr0=''),
  102639598 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102639598, CurrentID=0, Status='live', Symbol='Gm14296', Aliases='', description='predicted gene 14296', other_designations='novel KRAB box and zinc finger, C2H2 type domain containing protein|zinc finger protein 431-like', map_location='2 H4', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=176902774, end_position_on_the_genomic_accession=176927930, orientation='minus', exon_count=9, OMIM='', no_hdr0=''),
  665596 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=665596, CurrentID=0, Status='live', Symbol='Hist1h2bq', Aliases='Gm13646, OTTMUSG00000013203', description='histone cluster 1, H2bq', other_designations='', map_location='13 A3.1', chromosome='13', genomic_nucleotide_accession_version='NC_000079.6', start_position_on_the_genomic_accession=21806412, end_position_on_the_genomic_accession=21810199, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  272381 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=272381, CurrentID=0, Status='live', Symbol='Lrrc4b', Aliases='A830007M12, Lrig4', description='leucine rich repeat containing 4B', other_designations='NGL-3|leucine-rich repeats and immunoglobulin-like domains 4|netrin-G3 ligand', map_location='7 B4', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=44442487, end_position_on_the_genomic_accession=44463351, orientation='plus', exon_count=3, OMIM='', no_hdr0=''),
  272382 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=272382, CurrentID=0, Status='live', Symbol='Spib', Aliases='Spi-B', description='Spi-B transcription factor (Spi-1/PU.1 related)', other_designations='Ets transcription factor Spi-B|Spi-1/PU.1 related', map_location='7 28.83 cM', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=44525995, end_position_on_the_genomic_accession=44532086, orientation='minus', exon_count=6, OMIM='', no_hdr0=''),
  272396 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=272396, CurrentID=0, Status='live', Symbol='Tarsl2', Aliases='A530046H20Rik', description='threonyl-tRNA synthetase-like 2', other_designations='probable threonyl-tRNA synthetase 2, cytoplasmic|thrRS|threonine--tRNA ligase|threonyl-tRNA synthetase|threonyl-tRNA synthetase-like protein 2', map_location='7 C', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=65644898, end_position_on_the_genomic_accession=65692093, orientation='plus', exon_count=19, OMIM='', no_hdr0=''),
  665622 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=665622, CurrentID=0, Status='live', Symbol='Hist1h2br', Aliases='Gm11277, OTTMUSG00000000449', description='histone cluster 1 H2br', other_designations='H2b histone family member', map_location='13 A3.1', chromosome='13', genomic_nucleotide_accession_version='NC_000079.6', start_position_on_the_genomic_accession=21833743, end_position_on_the_genomic_accession=21837530, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  272411 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=272411, CurrentID=0, Status='live', Symbol='B3gnt6', Aliases='BC039789, Core-3, Core3', description='UDP-GlcNAc:betaGal beta-1,3-N-acetylglucosaminyltransferase 6 (core 3 synthase)', other_designations='BGnT-6|beta-1,3-Gn-T6|beta-1,3-N-acetylglucosaminyltransferase 6|beta3Gn-T6|core 3 synthase', map_location='7 E2', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=98192415, end_position_on_the_genomic_accession=98199475, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  272428 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=272428, CurrentID=0, Status='live', Symbol='Acsm5', Aliases='C730019D22, C730027J19Rik', description='acyl-CoA synthetase medium-chain family member 5', other_designations='', map_location='7 F2', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=119526131, end_position_on_the_genomic_accession=119543360, orientation='plus', exon_count=16, OMIM='', no_hdr0=''),
  272465 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=272465, CurrentID=0, Status='live', Symbol='Tmem255b', Aliases='Fam70b, Gm687', description='transmembrane protein 255B', other_designations='family with sequence similarity 70, member B|protein FAM70B', map_location='8 A1.1', chromosome='8', genomic_nucleotide_accession_version='NC_000074.6', start_position_on_the_genomic_accession=13435165, end_position_on_the_genomic_accession=13483667, orientation='plus', exon_count=14, OMIM='', no_hdr0=''),
  665700 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=665700, CurrentID=0, Status='live', Symbol='Hmcn2', Aliases='D030068H01', description='hemicentin 2', other_designations='', map_location='2 B', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=31313991, end_position_on_the_genomic_accession=31460738, orientation='plus', exon_count=99, OMIM='', no_hdr0=''),
  272538 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=272538, CurrentID=0, Status='live', Symbol='Tango6', Aliases='AW413431, E330010G16, Tmco7', description='transport and golgi organization 6', other_designations='transmembrane and coiled-coil domain-containing protein 7|transmembrane and coiled-coil domains 7|transport and Golgi organization 6 homolog', map_location='8 D3', chromosome='8', genomic_nucleotide_accession_version='NC_000074.6', start_position_on_the_genomic_accession=106683068, end_position_on_the_genomic_accession=106851439, orientation='plus', exon_count=18, OMIM='', no_hdr0=''),
  272551 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=272551, CurrentID=0, Status='live', Symbol='Gins2', Aliases='2210013I18Rik, 4833427B12Rik, AI323585, Pfs2', description='GINS complex subunit 2 (Psf2 homolog)', other_designations='', map_location='8 E1', chromosome='8', genomic_nucleotide_accession_version='NC_000074.6', start_position_on_the_genomic_accession=120581266, end_position_on_the_genomic_accession=120589075, orientation='minus', exon_count=5, OMIM='', no_hdr0=''),
  665775 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=665775, CurrentID=0, Status='live', Symbol='Bod1l', Aliases='A230054D04Rik, AI853319, FAM44A, mKIAA1327', description='biorientation of chromosomes in cell division 1-like', other_designations='family with sequence similarity 44, member A', map_location='5 B3', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=41787538, end_position_on_the_genomic_accession=41844365, orientation='minus', exon_count=28, OMIM='', no_hdr0=''),
  67272 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=67272, CurrentID=0, Status='live', Symbol='Cmtm5', Aliases='1500005P16Rik, 2900052H21Rik, Cklfsf5', description='CKLF-like MARVEL transmembrane domain containing 5', other_designations='chemokine-like factor super family 5|chemokine-like factor super family five variant 4|chemokine-like factor superfamily 5|chemokine-like factor superfamily member 5', map_location='14 C3', chromosome='14', genomic_nucleotide_accession_version='NC_000080.6', start_position_on_the_genomic_accession=54936470, end_position_on_the_genomic_accession=54939277, orientation='plus', exon_count=5, OMIM='', no_hdr0=''),
  665780 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=665780, CurrentID=0, Status='live', Symbol='Zscan4b', Aliases='EG665780', description='zinc finger and SCAN domain containing 4B', other_designations='', map_location='7 A1', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=10900740, end_position_on_the_genomic_accession=10905050, orientation='minus', exon_count=4, OMIM='', no_hdr0=''),
  635253 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=635253, CurrentID=0, Status='live', Symbol='Usp51', Aliases='AV136873', description='ubiquitin specific protease 51', other_designations='ubiquitin specific peptidase 51', map_location='X F3', chromosome='X', genomic_nucleotide_accession_version='NC_000086.7', start_position_on_the_genomic_accession=153006381, end_position_on_the_genomic_accession=153009913, orientation='plus', exon_count=3, OMIM='', no_hdr0=''),
  272589 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=272589, CurrentID=0, Status='live', Symbol='Tbcel', Aliases='D330014K23, E130107N23Rik, Lrrc35', description='tubulin folding cofactor E-like', other_designations='leucine rich repeat containing 35|leucine-rich repeat-containing protein 35', map_location='9 A5.1', chromosome='9', genomic_nucleotide_accession_version='NC_000075.6', start_position_on_the_genomic_accession=42412316, end_position_on_the_genomic_accession=42472275, orientation='minus', exon_count=10, OMIM='', no_hdr0=''),
  665848 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=665848, CurrentID=0, Status='live', Symbol='Zscan4e', Aliases='EG665848', description='zinc finger and SCAN domain containing 4E', other_designations='', map_location='7 A1', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=11306369, end_position_on_the_genomic_accession=11310682, orientation='minus', exon_count=0, OMIM='', no_hdr0=''),
  272636 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=272636, CurrentID=0, Status='live', Symbol='Esyt3', Aliases='D930024E11, D9Ertd280e, Fam62c, mKIAA4186', description='extended synaptotagmin-like protein 3', other_designations='E-Syt3|family with sequence similarity 62 (C2 domain containing), member C|family with sequence similarity 62, member C', map_location='9 51.54 cM', chromosome='9', genomic_nucleotide_accession_version='NC_000075.6', start_position_on_the_genomic_accession=99308739, end_position_on_the_genomic_accession=99360405, orientation='minus', exon_count=25, OMIM='', no_hdr0=''),
  272643 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=272643, CurrentID=0, Status='live', Symbol='Prss43', Aliases='Gm661, Tessp3', description='protease, serine 43', other_designations='protease, serine, 43|testis serine protease 3', map_location='9 F3', chromosome='9', genomic_nucleotide_accession_version='NC_000075.6', start_position_on_the_genomic_accession=110826690, end_position_on_the_genomic_accession=110831507, orientation='plus', exon_count=6, OMIM='', no_hdr0=''),
  665902 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=665902, CurrentID=0, Status='live', Symbol='Zscan4f', Aliases='C330039H09Rik', description='zinc finger and SCAN domain containing 4F', other_designations='', map_location='7 A1', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=11397915, end_position_on_the_genomic_accession=11402318, orientation='plus', exon_count=4, OMIM='', no_hdr0=''),
  665943 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=665943, CurrentID=0, Status='live', Symbol='E330014E10Rik', Aliases='', description='RIKEN cDNA E330014E10 gene', other_designations='', map_location='5 E3', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=95775870, end_position_on_the_genomic_accession=95804230, orientation='plus', exon_count=6, OMIM='', no_hdr0=''),
  100861668 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=100861668, CurrentID=0, Status='live', Symbol='Gm21119', Aliases='', description='predicted gene, 21119', other_designations='', map_location='8', chromosome='8', genomic_nucleotide_accession_version='NC_000074.6', start_position_on_the_genomic_accession=20614405, end_position_on_the_genomic_accession=20657119, orientation='plus', exon_count=12, OMIM='', no_hdr0=''),
  666002 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=666002, CurrentID=0, Status='live', Symbol='Vmn2r114', Aliases='EG666002, V2Rp3', description='vomeronasal 2, receptor 114', other_designations='vomeronasal 2 receptor p3', map_location='17 A3.3', chromosome='17', genomic_nucleotide_accession_version='NC_000083.6', start_position_on_the_genomic_accession=23290934, end_position_on_the_genomic_accession=23312313, orientation='minus', exon_count=6, OMIM='', no_hdr0=''),
  272790 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=272790, CurrentID=0, Status='live', Symbol='Magee2', Aliases='9630059J11Rik, BB131182, Mage-e2', description='melanoma antigen, family E, 2', other_designations='', map_location='X C3', chromosome='X', genomic_nucleotide_accession_version='NC_000086.7', start_position_on_the_genomic_accession=104854952, end_position_on_the_genomic_accession=104857267, orientation='minus', exon_count=1, OMIM='', no_hdr0=''),
  666048 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=666048, CurrentID=0, Status='live', Symbol='Trabd2b', Aliases='Gm12824, Hkat, OTTMUSG00000008561', description='TraB domain containing 2B', other_designations='TRAB domain-containing protein 2B|UPF0632 protein A|heart, kidney and adipose-enriched transmembrane protein', map_location='4', chromosome='4', genomic_nucleotide_accession_version='NC_000070.6', start_position_on_the_genomic_accession=114406194, end_position_on_the_genomic_accession=114615098, orientation='plus', exon_count=9, OMIM='', no_hdr0=''),
  666060 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=666060, CurrentID=0, Status='live', Symbol='Frmpd1', Aliases='BC031840, mKIAA0967', description='FERM and PDZ domain containing 1', other_designations='', map_location='4 B1', chromosome='4', genomic_nucleotide_accession_version='NC_000070.6', start_position_on_the_genomic_accession=45184417, end_position_on_the_genomic_accession=45285936, orientation='plus', exon_count=21, OMIM='', no_hdr0=''),
  329470 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=329470, CurrentID=0, Status='live', Symbol='Accs', Aliases='2610203E10Rik, Phacs', description='1-aminocyclopropane-1-carboxylate synthase (non-functional)', other_designations='1-aminocyclopropane-1-carboxylate synthase homolog|ACC synthase-like protein 1', map_location='2 E1', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=93833467, end_position_on_the_genomic_accession=93849995, orientation='minus', exon_count=16, OMIM='', no_hdr0=''),
  666145 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=666145, CurrentID=0, Status='live', Symbol='1700016G14Rik', Aliases='', description='RIKEN cDNA 1700016G14 gene', other_designations='', map_location='13 A3.1', chromosome='13', genomic_nucleotide_accession_version='NC_000079.6', start_position_on_the_genomic_accession=24733875, end_position_on_the_genomic_accession=24746592, orientation='plus', exon_count=3, OMIM='', no_hdr0=''),
  666173 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=666173, CurrentID=0, Status='live', Symbol='Vps13b', Aliases='1810042B05Rik, 2310042E16Rik, 4732488H20, C330002D13Rik, C87206, Coh1, D230005K13, mKIAA0532, mKIAA5032', description='vacuolar protein sorting 13B (yeast)', other_designations='Cohen syndrome homolog 1|cohen syndrome protein 1 homolog', map_location='15 B3.1', chromosome='15', genomic_nucleotide_accession_version='NC_000081.6', start_position_on_the_genomic_accession=35369882, end_position_on_the_genomic_accession=35931229, orientation='plus', exon_count=66, OMIM='', no_hdr0=''),
  666185 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=666185, CurrentID=0, Status='live', Symbol='Gm7969', Aliases='', description='predicted gene 7969', other_designations='', map_location='13', chromosome='13', genomic_nucleotide_accession_version='NC_000079.6', start_position_on_the_genomic_accession=67949751, end_position_on_the_genomic_accession=67954507, orientation='plus', exon_count=3, OMIM='', no_hdr0=''),
  666279 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=666279, CurrentID=0, Status='live', Symbol='Dspp', Aliases='Dmp2, Dmp3, Dpp, Dsp', description='dentin sialophosphoprotein', other_designations='DMP-3|dentin matrix protein 3', map_location='5 50.59 cM', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=104170712, end_position_on_the_genomic_accession=104180127, orientation='plus', exon_count=5, OMIM='', no_hdr0=''),
  329502 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=329502, CurrentID=0, Status='live', Symbol='Pla2g4e', Aliases='2310026J01Rik, C230096D22, Pla2epsilon', description='phospholipase A2, group IVE', other_designations='cPLA2-epsilon|phospholipase A2, group 4E', map_location='2 E5', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=120166412, end_position_on_the_genomic_accession=120245625, orientation='minus', exon_count=24, OMIM='', no_hdr0=''),
  666317 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=666317, CurrentID=0, Status='live', Symbol='Prl2c1', Aliases='Ghd22', description='Prolactin family 2, subfamily c, member 1', other_designations='growth hormone d22', map_location='13 A3.1', chromosome='13', genomic_nucleotide_accession_version='NC_000079.6', start_position_on_the_genomic_accession=27849327, end_position_on_the_genomic_accession=27857791, orientation='plus', exon_count=5, OMIM='', no_hdr0=''),
  404194 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=404194, CurrentID=0, Status='live', Symbol='Gfral', Aliases='AY457637, Gral', description='GDNF family receptor alpha like', other_designations='GDNF receptor alpha-like', map_location='9 D', chromosome='9', genomic_nucleotide_accession_version='NC_000075.6', start_position_on_the_genomic_accession=76164102, end_position_on_the_genomic_accession=76213657, orientation='minus', exon_count=9, OMIM='', no_hdr0=''),
  666339 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=666339, CurrentID=0, Status='live', Symbol='Muc3', Aliases='', description='mucin 3, intestinal', other_designations='CAAA01224633.1', map_location='5 76.22 cM', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=137134924, end_position_on_the_genomic_accession=137166048, orientation='minus', exon_count=14, OMIM='', no_hdr0=''),
  666348 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=666348, CurrentID=0, Status='live', Symbol='Apol7e', Aliases='ENSMUSG00000071716', description='apolipoprotein L 7e', other_designations='', map_location='15 E1', chromosome='15', genomic_nucleotide_accession_version='NC_000081.6', start_position_on_the_genomic_accession=77695719, end_position_on_the_genomic_accession=77719288, orientation='plus', exon_count=6, OMIM='', no_hdr0=''),
  404212 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=404212, CurrentID=0, Status='live', Symbol='Pisrt1', Aliases='', description='polled intersex syndrome regulated transcript 1', other_designations='', map_location='', chromosome='9', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  404238 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=404238, CurrentID=0, Status='live', Symbol='Mrgprb3', Aliases='MrgB3', description='MAS-related GPR, member B3', other_designations='', map_location='7 B4', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=48642863, end_position_on_the_genomic_accession=48643801, orientation='minus', exon_count=1, OMIM='', no_hdr0=''),
  404239 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=404239, CurrentID=0, Status='live', Symbol='Mrgprb5', Aliases='Mgrg11, MrgB5', description='MAS-related GPR, member B5', other_designations='Mas-related G protein-coupled receptor g11', map_location='7 B4', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=48168017, end_position_on_the_genomic_accession=48168985, orientation='minus', exon_count=1, OMIM='', no_hdr0=''),
  404240 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=404240, CurrentID=0, Status='live', Symbol='Mrgprb8', Aliases='MrgB8', description='MAS-related GPR, member B8', other_designations='', map_location='7 B4', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=48388526, end_position_on_the_genomic_accession=48389648, orientation='plus', exon_count=1, OMIM='', no_hdr0=''),
  404242 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=404242, CurrentID=0, Status='live', Symbol='Mrgprx1', Aliases='MrgC11, Mrgprc11', description='MAS-related GPR, member X1', other_designations='MAS-related GPR, member C11|mas-related G-protein coupled receptor member C11|mrgprx1|sensory neuron-specific G-protein coupled receptor 1', map_location='7 B4', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=48020971, end_position_on_the_genomic_accession=48027597, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  404284 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=404284, CurrentID=0, Status='live', Symbol='Vmn1r59', Aliases='V1rd10', description='vomeronasal 1 receptor 59', other_designations='vomernasal 1 receptor Vmn1r59|vomeronasal 1 receptor, D10', map_location='7 A1', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=5453827, end_position_on_the_genomic_accession=5454759, orientation='minus', exon_count=1, OMIM='', no_hdr0=''),
  404285 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=404285, CurrentID=0, Status='live', Symbol='Vmn1r64', Aliases='V1rd11', description='vomeronasal 1 receptor 64', other_designations='vomernasal 1 receptor Vmn1r64|vomeronasal 1 receptor, D11', map_location='7 A1', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=5883580, end_position_on_the_genomic_accession=5884542, orientation='minus', exon_count=1, OMIM='', no_hdr0=''),
  404286 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=404286, CurrentID=0, Status='live', Symbol='Vmn1r179', Aliases='V1rd17', description='vomeronasal 1 receptor 179', other_designations='vomernasal 1 receptor Vmn1r179|vomeronasal 1 receptor, D17', map_location='7 A3', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=23928386, end_position_on_the_genomic_accession=23929357, orientation='plus', exon_count=1, OMIM='', no_hdr0=''),
  404287 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=404287, CurrentID=0, Status='live', Symbol='V1rd19', Aliases='Vmn1r182', description='vomeronasal 1 receptor, D19', other_designations='vomernasal 1 receptor Vmn1r182', map_location='7 A3', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=24003111, end_position_on_the_genomic_accession=24004028, orientation='plus', exon_count=1, OMIM='', no_hdr0=''),
  404289 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=404289, CurrentID=0, Status='live', Symbol='Vmn1r181', Aliases='V1rd20', description='vomeronasal 1 receptor 181', other_designations='vomernasal 1 receptor Vmn1r181', map_location='7 A3', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=23983961, end_position_on_the_genomic_accession=23985048, orientation='plus', exon_count=1, OMIM='', no_hdr0=''),
  404290 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=404290, CurrentID=0, Status='live', Symbol='Vmn1r93', Aliases='V1rd21', description='vomeronasal 1 receptor 93', other_designations='vomernasal 1 receptor Vmn1r93|vomeronasal 1 receptor, D21', map_location='7 A3', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=20138123, end_position_on_the_genomic_accession=20139088, orientation='minus', exon_count=1, OMIM='', no_hdr0=''),
  404291 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=404291, CurrentID=0, Status='live', Symbol='Vmn1r174', Aliases='V1rd22', description='vomeronasal 1 receptor 174', other_designations='vomernasal 1 receptor Vmn1r174', map_location='7 A3', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=23753911, end_position_on_the_genomic_accession=23754852, orientation='plus', exon_count=1, OMIM='', no_hdr0=''),
  404308 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=404308, CurrentID=0, Status='live', Symbol='Olfr118', Aliases='MOR263-13', description='olfactory receptor 118', other_designations='GA_x5J8B7TVMCU-697-290|GA_x5J8B7TYMFE-883-533|GA_x6K02T2PSCP-2131124-2132089', map_location='17 B1', chromosome='17', genomic_nucleotide_accession_version='NC_000083.6', start_position_on_the_genomic_accession=37672025, end_position_on_the_genomic_accession=37672990, orientation='plus', exon_count=1, OMIM='', no_hdr0=''),
  404316 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=404316, CurrentID=0, Status='live', Symbol='Olfr403', Aliases='IA7, MOR125-5_p, Olfr43', description='olfactory receptor 403', other_designations='GA_x6K02T2P1NL-4348188-4349129|olfactory receptor 43', map_location='11 B5', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=74186249, end_position_on_the_genomic_accession=74196446, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  404317 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=404317, CurrentID=0, Status='live', Symbol='Olfr592', Aliases='MOR0-3P, MOR32-13, Olfr1525-ps1', description='olfactory receptor 592', other_designations='GA_x6K02T2PBJ9-5902266-5903204|olfactory receptor 1525, pseudogene 1|olfactory receptor MOR0-3P', map_location='7 E3', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=103186603, end_position_on_the_genomic_accession=103187541, orientation='plus', exon_count=1, OMIM='', no_hdr0=''),
  404318 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=404318, CurrentID=0, Status='live', Symbol='Olfr681', Aliases='MOR4014', description='olfactory receptor 681', other_designations='', map_location='7 E3', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=105121459, end_position_on_the_genomic_accession=105122406, orientation='plus', exon_count=1, OMIM='', no_hdr0=''),
  404319 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=404319, CurrentID=0, Status='live', Symbol='Olfr750', Aliases='GA_x5J8B7W5WBF-6267395-6266441, GA_x6K02T2PMLR-6808276-6807281, MOR103-18', description='olfactory receptor 750', other_designations='', map_location='14 C1', chromosome='14', genomic_nucleotide_accession_version='NC_000080.6', start_position_on_the_genomic_accession=51070311, end_position_on_the_genomic_accession=51071442, orientation='minus', exon_count=1, OMIM='', no_hdr0=''),
  404322 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=404322, CurrentID=0, Status='live', Symbol='Olfr924', Aliases='MOR171-27P, MOR171-47, Olfr1520-ps1', description='olfactory receptor 924', other_designations='GA_x6K02T2PVTD-32543982-32544908|olfactory receptor 1520, pseudogene 1|olfactory receptor MOR171-27P', map_location='9 A5.1', chromosome='9', genomic_nucleotide_accession_version='NC_000075.6', start_position_on_the_genomic_accession=38848116, end_position_on_the_genomic_accession=38849042, orientation='plus', exon_count=1, OMIM='', no_hdr0=''),
  666468 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=666468, CurrentID=0, Status='live', Symbol='Atg4a', Aliases='AI627006, AV169859, Apg4al, Autl2, Atg4a', description='autophagy related 4A, cysteine peptidase', other_designations='APG4 (ATG4) autophagy-related homolog A|AUT-like 2 cysteine endopeptidase|AUT-like 2, cysteine endopeptidase|autophagin 2|autophagin-2|autophagy 4 homolog A|autophagy-related 4A|autophagy-related cysteine endopeptidase 2|autophagy-related protein 4 homolog A|cysteine protease APG4A', map_location='X F1', chromosome='X', genomic_nucleotide_accession_version='NC_000086.7', start_position_on_the_genomic_accession=141158699, end_position_on_the_genomic_accession=141164270, orientation='plus', exon_count=12, OMIM='', no_hdr0=''),
  404325 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=404325, CurrentID=0, Status='live', Symbol='Olfr1057', Aliases='GA_x5J8B7TRQ4E-1174-939, GA_x5J8B7TY464-2-187, MOR185-11', description='olfactory receptor 1057', other_designations='GA_x6K02T2Q125-47844843-47843896|olfactory receptor GA_x5J8B7TRQ4E-1174-939|olfactory receptor GA_x5J8B7TY464-2-187', map_location='2 D', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=86374463, end_position_on_the_genomic_accession=86375410, orientation='minus', exon_count=1, OMIM='', no_hdr0=''),
  404330 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=404330, CurrentID=0, Status='live', Symbol='Olfr1198', Aliases='GA_x5J8B7W62NC-67655-66851, GA_x6K02T2Q125-50221692-50220766, MOR225-13', description='olfactory receptor 1198', other_designations='', map_location='2 E1', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=88745960, end_position_on_the_genomic_accession=88746886, orientation='minus', exon_count=1, OMIM='', no_hdr0=''),
  404331 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=404331, CurrentID=0, Status='live', Symbol='Olfr1252', Aliases='GA_x5J8B7W62NC-992588-991951', description='olfactory receptor 1252', other_designations='GA_x6K02T2Q125-51162884-51161940|MOR231-22_p|olfactory receptor GA_x5J8B7W62NC-992588-991951', map_location='2 E1', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=89721165, end_position_on_the_genomic_accession=89722109, orientation='minus', exon_count=1, OMIM='', no_hdr0=''),
  404335 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=404335, CurrentID=0, Status='live', Symbol='Olfr1535', Aliases='MOR256-36, MOR256-63, Olfr1365', description='olfactory receptor 1535', other_designations='GA_x6K02T2QHY8-11688984-11689964|olfactory receptor 1365|olfactory receptor MOR256-36', map_location='13 A3.1', chromosome='13', genomic_nucleotide_accession_version='NC_000079.6', start_position_on_the_genomic_accession=21555040, end_position_on_the_genomic_accession=21556020, orientation='minus', exon_count=1, OMIM='', no_hdr0=''),
  404337 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=404337, CurrentID=0, Status='live', Symbol='Olfr1383', Aliases='MOR256-56', description='olfactory receptor 1383', other_designations='GA_x6K02T2QP88-5912627-5911692|odorant receptor|olfactory receptor GA_x5J8B7W6B6J-2556603-2556836', map_location='11 B1.2', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=49523725, end_position_on_the_genomic_accession=49524660, orientation='plus', exon_count=1, OMIM='', no_hdr0=''),
  404346 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=404346, CurrentID=0, Status='live', Symbol='Olfr322', Aliases='GA_x5J8B7U1E65-1-838, MOR256-64, OTTMUSG00000005755, Olfr179, Olfr179-ps1, Olfr216, Olfr216-ps1-ps1, Olfr322', description='olfactory receptor 322', other_designations='GA_x6K02SYUNE5-2-727|GA_x6K02SYUPNB-557-3|GA_x6K02T2NKPP-754816-754257|olfactory receptor 216|olfactory receptor GA_x5J8B7U1E65-1-838', map_location='11 B1.3', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=58665561, end_position_on_the_genomic_accession=58666544, orientation='plus', exon_count=1, OMIM='', no_hdr0=''),
  666528 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=666528, CurrentID=0, Status='live', Symbol='Zfp541', Aliases='EG666528, Znf541', description='zinc finger protein 541', other_designations='spermatogenic cell HDAC-interacting protein 1', map_location='7 A2', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=16061775, end_position_on_the_genomic_accession=16096340, orientation='plus', exon_count=21, OMIM='', no_hdr0=''),
  666532 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=666532, CurrentID=0, Status='live', Symbol='Gm13139', Aliases='OTTMUSG00000010657', description='predicted gene 13139', other_designations='novel KRAB box domain containing protein', map_location='4 E1', chromosome='4', genomic_nucleotide_accession_version='NC_000070.6', start_position_on_the_genomic_accession=147131931, end_position_on_the_genomic_accession=147181762, orientation='plus', exon_count=7, OMIM='', no_hdr0=''),
  30924 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=30924, CurrentID=0, Status='live', Symbol='Angptl3', Aliases='hypl', description='angiopoietin-like 3', other_designations='angiopoietin-like protein 3', map_location='4 45.6 cM', chromosome='4', genomic_nucleotide_accession_version='NC_000070.6', start_position_on_the_genomic_accession=99030955, end_position_on_the_genomic_accession=99038188, orientation='plus', exon_count=7, OMIM='', no_hdr0=''),
  30926 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=30926, CurrentID=0, Status='live', Symbol='Glrx3', Aliases='PICOT, Txnl2', description='glutaredoxin 3', other_designations='PKC interacting cousin of thioredoxin|PKC-interacting cousin of thioredoxin|PKC-theta-interacting protein|PKCq-interacting protein|thioredoxin-like 2|thioredoxin-like protein 2', map_location='7 F5', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=137437643, end_position_on_the_genomic_accession=137468594, orientation='plus', exon_count=12, OMIM='', no_hdr0=''),
  404473 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=404473, CurrentID=0, Status='live', Symbol='Olfr1082', Aliases='GA_x5J8B7W4CQV-18360-18784, MOR192-4_p-ps1, Olfr1082', description='olfactory receptor 1082', other_designations='GA_x6K02T2Q125-48079993-48079157|olfactory receptor 1082, pseudogene 1|olfactory receptor GA_x5J8B7W4CQV-18360-18784', map_location='2 D', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=86593885, end_position_on_the_genomic_accession=86598809, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  11287 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11287, CurrentID=0, Status='live', Symbol='Pzp', Aliases='A1m, A2m, AI893533, MAM', description='pregnancy zone protein', other_designations='alpha 1 macroglobulin|alpha-2-M|alpha-2-macroglobulin', map_location='6 F1-G3', chromosome='6', genomic_nucleotide_accession_version='NC_000072.6', start_position_on_the_genomic_accession=128483567, end_position_on_the_genomic_accession=128526720, orientation='minus', exon_count=36, OMIM='', no_hdr0=''),
  11298 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11298, CurrentID=0, Status='live', Symbol='Aanat', Aliases='AA-NAT, Nat-2, Nat4, Snat', description='arylalkylamine N-acetyltransferase', other_designations='aralkylamine N-acetyltransferase|serotonin acetylase', map_location='11 E2', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=116591721, end_position_on_the_genomic_accession=116597680, orientation='plus', exon_count=6, OMIM='', no_hdr0=''),
  11302 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11302, CurrentID=0, Status='live', Symbol='Aatk', Aliases='AATYK, aatyk1, mKIAA0641', description='apoptosis-associated tyrosine kinase', other_designations='apoptosis-associated tyrosine kinase 1B|brain apoptosis-associated tyrosine kinase|lemur tyrosine kinase 1', map_location='11 E2', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=120007311, end_position_on_the_genomic_accession=120047182, orientation='minus', exon_count=15, OMIM='', no_hdr0=''),
  11303 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11303, CurrentID=0, Status='live', Symbol='Abca1', Aliases='ABC-1, Abc1', description='ATP-binding cassette, sub-family A (ABC1), member 1', other_designations='ATP-binding cassette 1|ATP-binding cassette transporter 1', map_location='4 A5-B3', chromosome='4', genomic_nucleotide_accession_version='NC_000070.6', start_position_on_the_genomic_accession=53030789, end_position_on_the_genomic_accession=53159988, orientation='minus', exon_count=52, OMIM='', no_hdr0=''),
  11304 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11304, CurrentID=0, Status='live', Symbol='Abca4', Aliases='AW050280, Abc10, Abcr, D430003I15Rik, RmP', description='ATP-binding cassette, sub-family A (ABC1), member 4', other_designations='ATP-binding cassette 10|ATP-binding cassette sub-family A member 4|RIM ABC transporter|Rim protein', map_location='3 52.94 cM', chromosome='3', genomic_nucleotide_accession_version='NC_000069.6', start_position_on_the_genomic_accession=122043893, end_position_on_the_genomic_accession=122180070, orientation='plus', exon_count=54, OMIM='', no_hdr0=''),
  11305 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11305, CurrentID=0, Status='live', Symbol='Abca2', Aliases='AI413825, Abc2, D2H0S1474E, mKIAA1062', description='ATP-binding cassette, sub-family A (ABC1), member 2', other_designations='ATP-binding cassette 2|ATP-binding cassette transporter 2', map_location='2 A2-B', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=25428604, end_position_on_the_genomic_accession=25448544, orientation='plus', exon_count=50, OMIM='', no_hdr0=''),
  11306 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11306, CurrentID=0, Status='live', Symbol='Abcb7', Aliases='AA517758, AU019072, Abc7', description='ATP-binding cassette, sub-family B (MDR/TAP), member 7', other_designations='ABC transporter 7 protein|ATP-binding cassette 7|ATP-binding cassette transporter 7', map_location='X C-D', chromosome='X', genomic_nucleotide_accession_version='NC_000086.7', start_position_on_the_genomic_accession=104280565, end_position_on_the_genomic_accession=104413846, orientation='minus', exon_count=16, OMIM='', no_hdr0=''),
  11307 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11307, CurrentID=0, Status='live', Symbol='Abcg1', Aliases='AW413978, Abc8, White', description='ATP-binding cassette, sub-family G (WHITE), member 1', other_designations='ATP-binding cassette 8|ATP-binding cassette transporter 8|ATP-binding cassette, subfamily G, member 1|white protein homolog', map_location='17', chromosome='17', genomic_nucleotide_accession_version='NC_000083.6', start_position_on_the_genomic_accession=31057694, end_position_on_the_genomic_accession=31117984, orientation='plus', exon_count=15, OMIM='', no_hdr0=''),
  11308 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11308, CurrentID=0, Status='live', Symbol='Abi1', Aliases='E3B1, NAP1, Ssh3bp1, abi-1', description='abl-interactor 1', other_designations='abelson interactor 1|ablphilin-1|eps8 SH3 domain-binding protein|eps8 binding protein|eps8-binding protein|spectrin SH3 domain binding protein 1|spectrin SH3 domain-binding protein 1', map_location='2 15.18 cM', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=22939989, end_position_on_the_genomic_accession=23040241, orientation='minus', exon_count=11, OMIM='', no_hdr0=''),
  404545 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=404545, CurrentID=0, Status='live', Symbol='Ano7', Aliases='Ngep, Ngep-L, Pcanap5, Tmem16g', description='anoctamin 7', other_designations='prostate cancer associated protein 5|transmembrane protein 16g', map_location='1 D', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=93373796, end_position_on_the_genomic_accession=93404304, orientation='plus', exon_count=25, OMIM='', no_hdr0=''),
  404549 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=404549, CurrentID=0, Status='live', Symbol='Ifna14', Aliases='OTTMUSG00000007662', description='interferon alpha 14', other_designations='', map_location='4 C4', chromosome='4', genomic_nucleotide_accession_version='NC_000070.6', start_position_on_the_genomic_accession=88571229, end_position_on_the_genomic_accession=88571798, orientation='minus', exon_count=1, OMIM='', no_hdr0=''),
  11350 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11350, CurrentID=0, Status='live', Symbol='Abl1', Aliases='AI325092, Abl, E430008G22Rik, c-Abl', description='c-abl oncogene 1, non-receptor tyrosine kinase', other_designations='Abelson murine leukemia oncogene|Abelson tyrosine-protein kinase 1|abelson murine leukemia viral oncogene homolog 1|c-abl oncogene 1, receptor tyrosine kinase|c-abl protein, type II|c-abl protein, type III|p150|proto-oncogene c-Abl|proto-oncogene tyrosine-protein kinase ABL1|v-abl Abelson murine leukemia oncogene 1', map_location='2 B', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=31688252, end_position_on_the_genomic_accession=31807093, orientation='plus', exon_count=17, OMIM='', no_hdr0=''),
  11352 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11352, CurrentID=0, Status='live', Symbol='Abl2', Aliases='AA536808, Abll, Arg', description='v-abl Abelson murine leukemia viral oncogene 2 (arg, Abelson-related gene)', other_designations='Abelson-related gene protein|abelson murine leukemia viral oncogene homolog 2|abl2|tyrosine kinase ARG|tyrosine-protein kinase ABL2|tyrosine-protein kinase ARG|v-abl Abelson murine leukemia viral oncogene homolog 2 (arg, Abelson-related gene)', map_location='1 67.71 cM', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=156558171, end_position_on_the_genomic_accession=156649619, orientation='plus', exon_count=13, OMIM='', no_hdr0=''),
  11354 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11354, CurrentID=0, Status='live', Symbol='Scgb1b27', Aliases='Abp, Abpa, Abpa27, Sal-1, Tcp', description='secretoglobin, family 1B, member 27', other_designations='androgen binding protein alpha|androgen-binding protein|major allergen 1-like; lacrimal gland protein|salivary androgen-binding alpha subunit|salivary androgen-binding protein alpha subunit', map_location='7 19.38 cM', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=34021567, end_position_on_the_genomic_accession=34022881, orientation='plus', exon_count=3, OMIM='', no_hdr0=''),
  11358 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11358, CurrentID=0, Status='live', Symbol='ac', Aliases='', description='absent corpus callosum', other_designations='', map_location='', chromosome='', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  11363 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11363, CurrentID=0, Status='live', Symbol='Acadl', Aliases='AA960361, AU018452, C79855, LCAD', description='acyl-Coenzyme A dehydrogenase, long-chain', other_designations='acetyl-Coenzyme A dehydrogenase, long-chain', map_location='1 33.64 cM', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=66830839, end_position_on_the_genomic_accession=66863309, orientation='minus', exon_count=11, OMIM='', no_hdr0=''),
  11364 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11364, CurrentID=0, Status='live', Symbol='Acadm', Aliases='AU018656, MCAD', description='acyl-Coenzyme A dehydrogenase, medium chain', other_designations='', map_location='3 78.77 cM', chromosome='3', genomic_nucleotide_accession_version='NC_000069.6', start_position_on_the_genomic_accession=153922353, end_position_on_the_genomic_accession=153944643, orientation='minus', exon_count=12, OMIM='', no_hdr0=''),
  11370 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11370, CurrentID=0, Status='live', Symbol='Acadvl', Aliases='vlcad', description='acyl-Coenzyme A dehydrogenase, very long chain', other_designations='MVLCAD', map_location='11 42.96 cM', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=70010183, end_position_on_the_genomic_accession=70015428, orientation='minus', exon_count=20, OMIM='', no_hdr0=''),
  666731 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=666731, CurrentID=0, Status='live', Symbol='Trim43c', Aliases='EG666731, Trim43', description='tripartite motif-containing 43C', other_designations='trim43c|tripartite motif-containing 43', map_location='9 E3.1', chromosome='9', genomic_nucleotide_accession_version='NC_000075.6', start_position_on_the_genomic_accession=88839023, end_position_on_the_genomic_accession=88848198, orientation='plus', exon_count=7, OMIM='', no_hdr0=''),
  666747 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=666747, CurrentID=0, Status='live', Symbol='Trim43b', Aliases='EG666747, Gm8269', description='tripartite motif-containing 43B', other_designations='trim43b', map_location='9 E3.1', chromosome='9', genomic_nucleotide_accession_version='NC_000075.6', start_position_on_the_genomic_accession=89084624, end_position_on_the_genomic_accession=89092835, orientation='minus', exon_count=7, OMIM='', no_hdr0=''),
  67437 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=67437, CurrentID=0, Status='live', Symbol='Ssr3', Aliases='0610038P07Rik, AL022999, AU022074, AW553833, TRAPG', description='signal sequence receptor, gamma', other_designations='SSR-gamma|TRAP-gamma|signal sequence receptor subunit gamma|translocon-associated protein gamma', map_location='3 E1', chromosome='3', genomic_nucleotide_accession_version='NC_000069.6', start_position_on_the_genomic_accession=65379657, end_position_on_the_genomic_accession=65392553, orientation='minus', exon_count=5, OMIM='', no_hdr0=''),
  11409 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11409, CurrentID=0, Status='live', Symbol='Acads', Aliases='AI196007, Bcd-1, Bcd1, Hdlq8, SCAD', description='acyl-Coenzyme A dehydrogenase, short chain', other_designations='butyryl-CoA dehydrogenase', map_location='5 F', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=115110299, end_position_on_the_genomic_accession=115119346, orientation='minus', exon_count=10, OMIM='', no_hdr0=''),
  11416 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11416, CurrentID=0, Status='live', Symbol='Slc33a1', Aliases='AI315656, AI788741, Acatn, D630022N01Rik', description='solute carrier family 33 (acetyl-CoA transporter), member 1', other_designations='AT-1|acetyl-CoA transporter 1|solute carrier family 33 member 1', map_location='3 E1-E3', chromosome='3', genomic_nucleotide_accession_version='NC_000069.6', start_position_on_the_genomic_accession=63942323, end_position_on_the_genomic_accession=63964733, orientation='minus', exon_count=6, OMIM='', no_hdr0=''),
  404634 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=404634, CurrentID=0, Status='live', Symbol='H2afy2', Aliases='macroH2A2', description='H2A histone family, member Y2', other_designations='histone macroH2A2|mH2A2', map_location='10 B4', chromosome='10', genomic_nucleotide_accession_version='NC_000076.6', start_position_on_the_genomic_accession=61738647, end_position_on_the_genomic_accession=61784104, orientation='minus', exon_count=10, OMIM='', no_hdr0=''),
  11419 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11419, CurrentID=0, Status='live', Symbol='Asic1', Aliases='AI843610, ASIC, ASIC1a, Accn2, B530003N02Rik, BNaC2', description='acid-sensing (proton-gated) ion channel 1', other_designations='acid sensing ion channel|amiloride-sensitive cation channel 2, neuronal|brain sodium channel 2|degenerin 2', map_location='15 F3', chromosome='15', genomic_nucleotide_accession_version='NC_000081.6', start_position_on_the_genomic_accession=99670266, end_position_on_the_genomic_accession=99701130, orientation='plus', exon_count=14, OMIM='', no_hdr0=''),
  11421 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11421, CurrentID=0, Status='live', Symbol='Ace', Aliases='AW208573, CD143', description='angiotensin I converting enzyme (peptidyl-dipeptidase A) 1', other_designations='angiotensin converting enzyme|dipeptidyl carboxypeptidase I|dipeptidyl peptidase|kininase II', map_location='11 68.84 cM', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=105967945, end_position_on_the_genomic_accession=105989964, orientation='plus', exon_count=26, OMIM='', no_hdr0=''),
  11423 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11423, CurrentID=0, Status='live', Symbol='Ache', Aliases='', description='acetylcholinesterase', other_designations='', map_location='5 76.32 cM', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=137285849, end_position_on_the_genomic_accession=137294466, orientation='plus', exon_count=7, OMIM='', no_hdr0=''),
  11425 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11425, CurrentID=0, Status='live', Symbol='Apoc4', Aliases='Acl, apo-CIV, apoC-IV', description='apolipoprotein C-IV', other_designations='apolipoprotein C2-linked|apolipoprotein C4', map_location='7 9.94 cM', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=19678084, end_position_on_the_genomic_accession=19681460, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  11426 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11426, CurrentID=0, Status='live', Symbol='Macf1', Aliases='ABP620, Acf7, Aclp7, MACF, R74989, mKIAA0465', description='microtubule-actin crosslinking factor 1', other_designations='actin cross-linking family 7|actin-crosslinking protein 7|trabeculin alpha', map_location='4 57.42 cM', chromosome='4', genomic_nucleotide_accession_version='NC_000070.6', start_position_on_the_genomic_accession=123349633, end_position_on_the_genomic_accession=123687315, orientation='minus', exon_count=112, OMIM='', no_hdr0=''),
  11428 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11428, CurrentID=0, Status='live', Symbol='Aco1', Aliases='Aco-1, Irebp, Irp1', description='aconitase 1', other_designations='IRE-BP 1|citrate hydro-lyase|cytoplasmic aconitase|iron regulatory protein 1|iron-responsive element-binding protein 1', map_location='4 20.24 cM', chromosome='4', genomic_nucleotide_accession_version='NC_000070.6', start_position_on_the_genomic_accession=40143265, end_position_on_the_genomic_accession=40199009, orientation='plus', exon_count=21, OMIM='', no_hdr0=''),
  11429 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11429, CurrentID=0, Status='live', Symbol='Aco2', Aliases='Aco-2, Aco3, D10Wsu183e', description='aconitase 2, mitochondrial', other_designations='citrate hydro-lyase', map_location='15 E1', chromosome='15', genomic_nucleotide_accession_version='NC_000081.6', start_position_on_the_genomic_accession=81872463, end_position_on_the_genomic_accession=81915137, orientation='plus', exon_count=18, OMIM='', no_hdr0=''),
  11430 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11430, CurrentID=0, Status='live', Symbol='Acox1', Aliases='AOX, Acox, D130055E20Rik, Paox', description='acyl-Coenzyme A oxidase 1, palmitoyl', other_designations='palmitoyl-CoA oxidase|peroxisomal fatty acyl-coenzyme A oxidase|peroxisomal straight-chain Acyl-CoA oxidase', map_location='11 E2', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=116171883, end_position_on_the_genomic_accession=116199045, orientation='minus', exon_count=15, OMIM='', no_hdr0=''),
  11431 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11431, CurrentID=0, Status='live', Symbol='Acp1', Aliases='4632432E04Rik, AI427468, Acp-1, LMW-PTP', description='acid phosphatase 1, soluble', other_designations='LMW-PTPase|low molecular weight cytosolic acid phosphatase', map_location='12 A2', chromosome='12', genomic_nucleotide_accession_version='NC_000078.6', start_position_on_the_genomic_accession=30893326, end_position_on_the_genomic_accession=30911621, orientation='minus', exon_count=7, OMIM='', no_hdr0=''),
  11432 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11432, CurrentID=0, Status='live', Symbol='Acp2', Aliases='Acp-2, LAP', description='acid phosphatase 2, lysosomal', other_designations='', map_location='2 50.54 cM', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=91202812, end_position_on_the_genomic_accession=91214098, orientation='plus', exon_count=12, OMIM='', no_hdr0=''),
  11433 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11433, CurrentID=0, Status='live', Symbol='Acp5', Aliases='TRACP, TRAP', description='acid phosphatase 5, tartrate resistant', other_designations='TR-AP|acid phosphatase type V|tartrate-resistant acid ATPase|trATPase|type 5 acid phosphatase', map_location='9 8.38 cM', chromosome='9', genomic_nucleotide_accession_version='NC_000075.6', start_position_on_the_genomic_accession=22126727, end_position_on_the_genomic_accession=22135746, orientation='minus', exon_count=8, OMIM='', no_hdr0=''),
  11434 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11434, CurrentID=0, Status='live', Symbol='Acr', Aliases='', description='acrosin prepropeptide', other_designations='preproacrosin', map_location='15 E-F', chromosome='15', genomic_nucleotide_accession_version='NC_000081.6', start_position_on_the_genomic_accession=89567562, end_position_on_the_genomic_accession=89578904, orientation='plus', exon_count=5, OMIM='', no_hdr0=''),
  11435 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11435, CurrentID=0, Status='live', Symbol='Chrna1', Aliases='AI385656, AI608266, Achr-1, Acra', description='cholinergic receptor, nicotinic, alpha polypeptide 1 (muscle)', other_designations='', map_location='2 43.76 cM', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=73563281, end_position_on_the_genomic_accession=73580338, orientation='minus', exon_count=9, OMIM='', no_hdr0=''),
  11438 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11438, CurrentID=0, Status='live', Symbol='Chrna4', Aliases='Acra-4, Acra4, EBN1, ENFL1', description='cholinergic receptor, nicotinic, alpha polypeptide 4', other_designations='a4 nicotinic receptor|acetylcholine receptor alpha 4 neural|acetylcholine receptor, neuronal, nicotinic, alpha-4 subunit|alpha4 nAChR|alpha4-nAChR', map_location='2 103.54 cM', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=181022311, end_position_on_the_genomic_accession=181043580, orientation='minus', exon_count=7, OMIM='', no_hdr0=''),
  11440 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11440, CurrentID=0, Status='live', Symbol='Chrna6', Aliases='Acra6, Nica6', description='cholinergic receptor, nicotinic, alpha polypeptide 6', other_designations='acetylcholine receptor alpha 6 neural|alpha6 nAChR|nicotinic acetylcholine receptor subunit alpha 6', map_location='8 A3', chromosome='8', genomic_nucleotide_accession_version='NC_000074.6', start_position_on_the_genomic_accession=27403212, end_position_on_the_genomic_accession=27413944, orientation='minus', exon_count=6, OMIM='', no_hdr0=''),
  11441 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11441, CurrentID=0, Status='live', Symbol='Chrna7', Aliases='Acra7, alpha7, nAchR', description='cholinergic receptor, nicotinic, alpha polypeptide 7', other_designations='acetylcholine receptor alpha 7 neural|alpha7 nicotinic receptor|alpha7-nAChR', map_location='7 34.47 cM', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=63098692, end_position_on_the_genomic_accession=63212526, orientation='minus', exon_count=10, OMIM='', no_hdr0=''),
  11443 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11443, CurrentID=0, Status='live', Symbol='Chrnb1', Aliases='Achr-2, Acrb', description='cholinergic receptor, nicotinic, beta polypeptide 1 (muscle)', other_designations='AChR beta|acetylcholine receptor beta', map_location='11 42.87 cM', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=69784036, end_position_on_the_genomic_accession=69795974, orientation='minus', exon_count=11, OMIM='', no_hdr0=''),
  11444 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11444, CurrentID=0, Status='live', Symbol='Chrnb2', Aliases='Acrb-2, Acrb2, C030030P04Rik, [b]2-nAchR', description='cholinergic receptor, nicotinic, beta polypeptide 2 (neuronal)', other_designations='acetylcholine receptor beta 2 neural', map_location='3 39.19 cM', chromosome='3', genomic_nucleotide_accession_version='NC_000069.6', start_position_on_the_genomic_accession=89753448, end_position_on_the_genomic_accession=89764632, orientation='minus', exon_count=6, OMIM='', no_hdr0=''),
  666806 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=666806, CurrentID=0, Status='live', Symbol='Gm8300', Aliases='EG666806', description='predicted gene 8300', other_designations='', map_location='12 D2', chromosome='12', genomic_nucleotide_accession_version='NC_000078.6', start_position_on_the_genomic_accession=87514316, end_position_on_the_genomic_accession=87518265, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  11447 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11447, CurrentID=0, Status='live', Symbol='Chrnd', Aliases='Achr-4, Acrd, L10076', description='cholinergic receptor, nicotinic, delta polypeptide', other_designations='AChR delta subunit', map_location='1 44.07 cM', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=87190597, end_position_on_the_genomic_accession=87200070, orientation='plus', exon_count=12, OMIM='', no_hdr0=''),
  11448 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11448, CurrentID=0, Status='live', Symbol='Chrne', Aliases='AChrepsilon, Acre, nAChRE', description='cholinergic receptor, nicotinic, epsilon polypeptide', other_designations='AchR epsilon subunit|nicotinic acetylcholine receptor epsilon subunit', map_location='11 43.14 cM', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=70614883, end_position_on_the_genomic_accession=70619835, orientation='minus', exon_count=12, OMIM='', no_hdr0=''),
  11449 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11449, CurrentID=0, Status='live', Symbol='Chrng', Aliases='Achr-3, Acrg', description='cholinergic receptor, nicotinic, gamma polypeptide', other_designations='chrng variant N1|chrng variant N2|nicotinic acetylcholine receptor gamma subunit', map_location='1 44.07 cM', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=87205811, end_position_on_the_genomic_accession=87212410, orientation='plus', exon_count=12, OMIM='', no_hdr0=''),
  11450 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11450, CurrentID=0, Status='live', Symbol='Adipoq', Aliases='30kDa, APN, Acdc, Acrp30, Ad, GBP28, adipo, apM1', description='adiponectin, C1Q and collagen domain containing', other_designations='30 kDa adipocyte complement-related protein|adipocyte complement related protein|adipocyte complement-related 30 kDa protein|adipocyte, C1Q and collagen domain containing|adipocyte, C1q and collagen domain-containing protein|adipocyte-specific protein AdipoQ', map_location='16 13.96 cM', chromosome='16', genomic_nucleotide_accession_version='NC_000082.6', start_position_on_the_genomic_accession=23146536, end_position_on_the_genomic_accession=23157968, orientation='plus', exon_count=3, OMIM='', no_hdr0=''),
  11451 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11451, CurrentID=0, Status='live', Symbol='Acrv1', Aliases='Msa63, SP-10', description='acrosomal vesicle protein 1', other_designations='MSA-63', map_location='9 20.67 cM', chromosome='9', genomic_nucleotide_accession_version='NC_000075.6', start_position_on_the_genomic_accession=36693220, end_position_on_the_genomic_accession=36698837, orientation='plus', exon_count=4, OMIM='', no_hdr0=''),
  11459 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11459, CurrentID=0, Status='live', Symbol='Acta1', Aliases='AA959943, Acta-2, Acts, Actsk-1', description='actin, alpha 1, skeletal muscle', other_designations='alpha-actin-1', map_location='8 72.26 cM', chromosome='8', genomic_nucleotide_accession_version='NC_000074.6', start_position_on_the_genomic_accession=123891758, end_position_on_the_genomic_accession=123894775, orientation='minus', exon_count=8, OMIM='', no_hdr0=''),
  11461 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11461, CurrentID=0, Status='live', Symbol='Actb', Aliases='Actx, E430023M04Rik, beta-actin', description='actin, beta', other_designations='A-X actin-like protein|actin, beta, cytoplasmic|melanoma X-actin', map_location='5 81.8 cM', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=142903116, end_position_on_the_genomic_accession=142906724, orientation='minus', exon_count=6, OMIM='', no_hdr0=''),
  11464 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11464, CurrentID=0, Status='live', Symbol='Actc1', Aliases='Actc-1', description='actin, alpha, cardiac muscle 1', other_designations='actin alpha cardiac|alpha-cardiac actin|alphac-actin', map_location='2 57.55 cM', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=114047289, end_position_on_the_genomic_accession=114052811, orientation='minus', exon_count=7, OMIM='', no_hdr0=''),
  11465 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11465, CurrentID=0, Status='live', Symbol='Actg1', Aliases='AL023024, Actg, Actl, E51', description='actin, gamma, cytoplasmic 1', other_designations='beta-actin FE-3|gamma-actin', map_location='11 E2', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=120345689, end_position_on_the_genomic_accession=120348491, orientation='minus', exon_count=7, OMIM='', no_hdr0=''),
  11468 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11468, CurrentID=0, Status='live', Symbol='Actg2', Aliases='ACTA3, Act-4, Act4, SMGA', description='actin, gamma 2, smooth muscle, enteric', other_designations='alpha-actin-3|gamma-2-actin|smooth muscle gamma-actin', map_location='6 35.94 cM', chromosome='6', genomic_nucleotide_accession_version='NC_000072.6', start_position_on_the_genomic_accession=83512909, end_position_on_the_genomic_accession=83536251, orientation='minus', exon_count=9, OMIM='', no_hdr0=''),
  11470 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11470, CurrentID=0, Status='live', Symbol='Actl7a', Aliases='Tact2', description='actin-like 7a', other_designations='T-actin-2|actin-like Tact2|actin-like-7-alpha|t-actin 2|testis-specific actin-2', map_location='4 31.66 cM', chromosome='4', genomic_nucleotide_accession_version='NC_000070.6', start_position_on_the_genomic_accession=56743422, end_position_on_the_genomic_accession=56744925, orientation='plus', exon_count=1, OMIM='', no_hdr0=''),
  11471 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11471, CurrentID=0, Status='live', Symbol='Actl7b', Aliases='Tact1', description='actin-like 7b', other_designations='T-actin-1|actin-like-7-beta|t-actin 1|testis-specific actin-1', map_location='4 27.0 cM', chromosome='4', genomic_nucleotide_accession_version='NC_000070.6', start_position_on_the_genomic_accession=56740005, end_position_on_the_genomic_accession=56741425, orientation='minus', exon_count=1, OMIM='', no_hdr0=''),
  11472 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11472, CurrentID=0, Status='live', Symbol='Actn2', Aliases='1110008F24Rik', description='actinin alpha 2', other_designations='F-actin cross-linking protein|alpha-actinin skeletal muscle', map_location='13 4.54 cM', chromosome='13', genomic_nucleotide_accession_version='NC_000079.6', start_position_on_the_genomic_accession=12269426, end_position_on_the_genomic_accession=12340732, orientation='minus', exon_count=21, OMIM='', no_hdr0=''),
  11474 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11474, CurrentID=0, Status='live', Symbol='Actn3', Aliases='', description='actinin alpha 3', other_designations='F-actin cross-linking protein|alpha-actinin skeletal muscle', map_location='19 4.12 cM', chromosome='19', genomic_nucleotide_accession_version='NC_000085.6', start_position_on_the_genomic_accession=4861216, end_position_on_the_genomic_accession=4877909, orientation='minus', exon_count=21, OMIM='', no_hdr0=''),
  11475 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11475, CurrentID=0, Status='live', Symbol='Acta2', Aliases='0610041G09Rik, Actvs, SMalphaA, a-SMA, alphaSMA', description='actin, alpha 2, smooth muscle, aorta', other_designations='actin, alpha, vascular smooth muscle|alpha-actin-2', map_location='19 C3', chromosome='19', genomic_nucleotide_accession_version='NC_000085.6', start_position_on_the_genomic_accession=34240336, end_position_on_the_genomic_accession=34255585, orientation='minus', exon_count=10, OMIM='', no_hdr0=''),
  11477 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11477, CurrentID=0, Status='live', Symbol='Acvr1', Aliases='ALK2, ActR-I, ActRIA, Acvr, Acvrlk2, Alk-2, Alk8, D330013D15Rik, SKR1, Tsk7L', description='activin A receptor, type 1', other_designations='TGF-B superfamily receptor type I|TSK-7L|TSR-I|activin receptor type I|serine/threonine-protein kinase receptor R1', map_location='2 C1.1', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=58446438, end_position_on_the_genomic_accession=58566828, orientation='minus', exon_count=14, OMIM='', no_hdr0=''),
  11479 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11479, CurrentID=0, Status='live', Symbol='Acvr1b', Aliases='6820432J04, ActR-IB, ActRIB, Acvrlk4, Alk4, SKR2', description='activin A receptor, type 1B', other_designations='ALK-4|activin receptor type IB|activin receptor-like kinase 4|serine/threonine-protein kinase receptor R2', map_location='15 56.48 cM', chromosome='15', genomic_nucleotide_accession_version='NC_000081.6', start_position_on_the_genomic_accession=101174125, end_position_on_the_genomic_accession=101212601, orientation='plus', exon_count=9, OMIM='', no_hdr0=''),
  11480 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11480, CurrentID=0, Status='live', Symbol='Acvr2a', Aliases='ActrIIa, Acvr2, TactrII', description='activin receptor IIA', other_designations='ACTR-IIA|activin receptor type IIA', map_location='2 28.38 cM', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=48814109, end_position_on_the_genomic_accession=48903264, orientation='plus', exon_count=12, OMIM='', no_hdr0=''),
  11481 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11481, CurrentID=0, Status='live', Symbol='Acvr2b', Aliases='4930516B21Rik, ActRIIB', description='activin receptor IIB', other_designations='activin receptor type IIB', map_location='9 F3', chromosome='9', genomic_nucleotide_accession_version='NC_000075.6', start_position_on_the_genomic_accession=119401583, end_position_on_the_genomic_accession=119442134, orientation='plus', exon_count=11, OMIM='', no_hdr0=''),
  11482 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11482, CurrentID=0, Status='live', Symbol='Acvrl1', Aliases='AI115505, AI427544, Acvrlk1, Alk1', description='activin A receptor, type II-like 1', other_designations='SKR3|TGF-B superfamily receptor type I|TSR-I|activin receptor-like kinase 1|activin receptor-like kinase-1', map_location='15 F3', chromosome='15', genomic_nucleotide_accession_version='NC_000081.6', start_position_on_the_genomic_accession=101128522, end_position_on_the_genomic_accession=101145336, orientation='plus', exon_count=13, OMIM='', no_hdr0=''),
  11484 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11484, CurrentID=0, Status='live', Symbol='Aspa', Aliases='Acy-2, Acy2, nur7', description='aspartoacylase', other_designations='aminoacylase-2|aspartoacylase (aminoacylase) 2', map_location='11 B4', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=73304988, end_position_on_the_genomic_accession=73326868, orientation='minus', exon_count=10, OMIM='', no_hdr0=''),
  11486 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11486, CurrentID=0, Status='live', Symbol='Ada', Aliases='', description='adenosine deaminase', other_designations='adenosine aminohydrolase', map_location='2 H3', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=163726571, end_position_on_the_genomic_accession=163750239, orientation='minus', exon_count=12, OMIM='', no_hdr0=''),
  11487 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11487, CurrentID=0, Status='live', Symbol='Adam10', Aliases='1700031C13Rik, MADM, kuz, kuzbanian', description='a disintegrin and metallopeptidase domain 10', other_designations='ADAM 10|a disintegrin and metalloprotease domain (ADAM) 10|a disintegrin and metalloprotease domain 10|kuzbanian protein homolog|mammalian disintegrin-metalloprotease', map_location='9 39.53 cM', chromosome='9', genomic_nucleotide_accession_version='NC_000075.6', start_position_on_the_genomic_accession=70679001, end_position_on_the_genomic_accession=70780229, orientation='plus', exon_count=17, OMIM='', no_hdr0=''),
  11488 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11488, CurrentID=0, Status='live', Symbol='Adam11', Aliases='AW060611, Mdc', description='a disintegrin and metallopeptidase domain 11', other_designations='a disintegrin and metalloprotease domain (ADAM) 11|a disintegrin and metalloprotease domain 11|metalloproteinase-like, disintegrin-like, and cysteine-rich protein', map_location='11 66.48 cM', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=102761439, end_position_on_the_genomic_accession=102780262, orientation='plus', exon_count=27, OMIM='', no_hdr0=''),
  11489 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11489, CurrentID=0, Status='live', Symbol='Adam12', Aliases='Mltna, mKIAA4001', description='a disintegrin and metallopeptidase domain 12 (meltrin alpha)', other_designations='ADAM 12|a disintegrin and metalloprotease domain 12|a disintegrin and metalloproteinase domain 12 (meltrin alpha)|meltrin alpha|meltrin-alpha', map_location='7 F4', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=133883196, end_position_on_the_genomic_accession=134232149, orientation='minus', exon_count=24, OMIM='', no_hdr0=''),
  11490 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11490, CurrentID=0, Status='live', Symbol='Adam15', Aliases='MDC15, metargidin', description='a disintegrin and metallopeptidase domain 15 (metargidin)', other_designations='AD56|ADAM 15|MDC-15|a disintegrin and metalloprotease domain 15 (metargidin)|a disintegrin and metalloproteinase domain 15 (metargidin)|disintegrin and metalloprotease 15|metalloprotease RGD disintegrin protein|metalloproteinase-like, disintegrin-like, and cysteine-rich protein 15', map_location='3 39.07 cM', chromosome='3', genomic_nucleotide_accession_version='NC_000069.6', start_position_on_the_genomic_accession=89339640, end_position_on_the_genomic_accession=89350010, orientation='minus', exon_count=25, OMIM='', no_hdr0=''),
  11491 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11491, CurrentID=0, Status='live', Symbol='Adam17', Aliases='CD156b, Tace', description='a disintegrin and metallopeptidase domain 17', other_designations='TNF-alpha convertase|TNF-alpha converting enzyme|a disintegrin and metalloproteinase domain 17', map_location='12 8.3 cM', chromosome='12', genomic_nucleotide_accession_version='NC_000078.6', start_position_on_the_genomic_accession=21323509, end_position_on_the_genomic_accession=21373632, orientation='minus', exon_count=20, OMIM='', no_hdr0=''),
  11492 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11492, CurrentID=0, Status='live', Symbol='Adam19', Aliases='AL024287, MADDAM, MTLNB, Mltnb', description='a disintegrin and metallopeptidase domain 19 (meltrin beta)', other_designations='MDC beta|Mel beta|a disintegrin and metalloproteinase domain 19 (meltrin beta)|adamalysin 19', map_location='11 A5-B1.1', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=46054502, end_position_on_the_genomic_accession=46147347, orientation='plus', exon_count=24, OMIM='', no_hdr0=''),
  404710 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=404710, CurrentID=0, Status='live', Symbol='Iqgap3', Aliases='AI593484, D030034H08', description='IQ motif containing GTPase activating protein 3', other_designations='', map_location='3 38.78 cM', chromosome='3', genomic_nucleotide_accession_version='NC_000069.6', start_position_on_the_genomic_accession=88082051, end_position_on_the_genomic_accession=88121048, orientation='plus', exon_count=38, OMIM='', no_hdr0=''),
  11495 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11495, CurrentID=0, Status='live', Symbol='Adam2', Aliases='AI323749, Ftnb, Ph30-beta', description='a disintegrin and metallopeptidase domain 2', other_designations='ADAM 2|PH-30|PH30|a disintegrin and metalloprotease domain 2 (fertilin beta)|fertilin beta|fertilin subunit beta', map_location='14 34.36 cM', chromosome='14', genomic_nucleotide_accession_version='NC_000080.6', start_position_on_the_genomic_accession=66027329, end_position_on_the_genomic_accession=66077856, orientation='minus', exon_count=21, OMIM='', no_hdr0=''),
  11496 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11496, CurrentID=0, Status='live', Symbol='Adam22', Aliases='2900022I03Rik, AI854032, MDC2', description='a disintegrin and metallopeptidase domain 22', other_designations='a disintegrin and metalloprotease domain (ADAM) 22', map_location='5 3.39 cM', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=8072348, end_position_on_the_genomic_accession=8368268, orientation='minus', exon_count=35, OMIM='', no_hdr0=''),
  11497 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11497, CurrentID=0, Status='live', Symbol='Adam3', Aliases='Cyrn1, Taz83, tMDC', description='a disintegrin and metallopeptidase domain 3 (cyritestin)', other_designations='', map_location='8 13.09 cM', chromosome='8', genomic_nucleotide_accession_version='NC_000074.6', start_position_on_the_genomic_accession=24677232, end_position_on_the_genomic_accession=24726044, orientation='minus', exon_count=23, OMIM='', no_hdr0=''),
  11498 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11498, CurrentID=0, Status='live', Symbol='Adam4', Aliases='AV274654, tMDCV', description='a disintegrin and metallopeptidase domain 4', other_designations='a disintegrin and metalloprotease domain (ADAM) 4|a disintegrin and metalloprotease domain 4', map_location='12 D1', chromosome='12', genomic_nucleotide_accession_version='NC_000078.6', start_position_on_the_genomic_accession=81419549, end_position_on_the_genomic_accession=81421878, orientation='minus', exon_count=1, OMIM='', no_hdr0=''),
  11499 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11499, CurrentID=0, Status='live', Symbol='Adam5', Aliases='tMDC II, tMDCII', description='a disintegrin and metallopeptidase domain 5', other_designations='a disintegrin and metalloprotease domain (ADAM) 5|a disintegrin and metalloprotease domain 5|transmembrane metalloproteinase-like, disintegrin-like, and cysteine-rich protein II', map_location='8 13.26 cM', chromosome='8', genomic_nucleotide_accession_version='NC_000074.6', start_position_on_the_genomic_accession=24727093, end_position_on_the_genomic_accession=24824369, orientation='minus', exon_count=22, OMIM='', no_hdr0=''),
  11500 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11500, CurrentID=0, Status='live', Symbol='Adam7', Aliases='ADAM 7, EAP1, EAPI', description='a disintegrin and metallopeptidase domain 7', other_designations='a disintegrin and metalloprotease domain (ADAM) 7|epididymal apical protein I', map_location='14 D2', chromosome='14', genomic_nucleotide_accession_version='NC_000080.6', start_position_on_the_genomic_accession=68497336, end_position_on_the_genomic_accession=68533689, orientation='minus', exon_count=23, OMIM='', no_hdr0=''),
  11501 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11501, CurrentID=0, Status='live', Symbol='Adam8', Aliases='ADAM 8, CD156, CD156a, E430039A18Rik, MS2', description='a disintegrin and metallopeptidase domain 8', other_designations='a disintegrin and metalloprotease domain 8|cell surface antigen MS2|macrophage cysteine-rich glycoprotein', map_location='7 F3-F5', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=139978932, end_position_on_the_genomic_accession=139993121, orientation='minus', exon_count=26, OMIM='', no_hdr0=''),
  11502 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11502, CurrentID=0, Status='live', Symbol='Adam9', Aliases='AU020942, MDC9, Mltng, mKIAA0021', description='a disintegrin and metallopeptidase domain 9 (meltrin gamma)', other_designations='a disintegrin and metalloproteinase domain 9 (meltrin gamma)|metalloprotease/disintegrin/cysteine-rich protein 9|myeloma cell metalloproteinase', map_location='8 13.7 cM', chromosome='8', genomic_nucleotide_accession_version='NC_000074.6', start_position_on_the_genomic_accession=24949611, end_position_on_the_genomic_accession=25016933, orientation='minus', exon_count=23, OMIM='', no_hdr0=''),
  11504 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11504, CurrentID=0, Status='live', Symbol='Adamts1', Aliases='ADAM-TS1, ADAMTS, ADAMTS-1, C3-C5, METH-1, METH1', description='a disintegrin-like and metallopeptidase (reprolysin type) with thrombospondin type 1 motif, 1', other_designations='ADAM-TS 1', map_location='16 C3-C5', chromosome='16', genomic_nucleotide_accession_version='NC_000082.6', start_position_on_the_genomic_accession=85793827, end_position_on_the_genomic_accession=85803115, orientation='minus', exon_count=9, OMIM='', no_hdr0=''),
  11512 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11512, CurrentID=0, Status='live', Symbol='Adcy6', Aliases='AC6, mKIAA0422', description='adenylate cyclase 6', other_designations='ATP pyrophosphate-lyase 6|adenylate cyclase type VI|adenylyl cyclase 6|ca(2+)-inhibitable adenylyl cyclase', map_location='15 F', chromosome='15', genomic_nucleotide_accession_version='NC_000081.6', start_position_on_the_genomic_accession=98589978, end_position_on_the_genomic_accession=98610140, orientation='minus', exon_count=24, OMIM='', no_hdr0=''),
  11513 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11513, CurrentID=0, Status='live', Symbol='Adcy7', Aliases='AA407758', description='adenylate cyclase 7', other_designations='ATP pyrophosphate-lyase 7|adenylate cyclase type VII|adenylyl cyclase 7|adenylyl cyclase type VII', map_location='8 43.06 cM', chromosome='8', genomic_nucleotide_accession_version='NC_000074.6', start_position_on_the_genomic_accession=88272367, end_position_on_the_genomic_accession=88329965, orientation='plus', exon_count=35, OMIM='', no_hdr0=''),
  11514 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11514, CurrentID=0, Status='live', Symbol='Adcy8', Aliases='AC8, AW060868', description='adenylate cyclase 8', other_designations='ATP pyrophosphate-lyase 8|adenylate cyclase type VIII|adenylyl cyclase 8|ca(2+)/calmodulin-activated adenylyl cyclase', map_location='15 29.03 cM', chromosome='15', genomic_nucleotide_accession_version='NC_000081.6', start_position_on_the_genomic_accession=64699035, end_position_on_the_genomic_accession=64922296, orientation='minus', exon_count=18, OMIM='', no_hdr0=''),
  11515 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11515, CurrentID=0, Status='live', Symbol='Adcy9', Aliases='AC9, ACtp10, AW125421, D16Wsu65e, mKIAA0520', description='adenylate cyclase 9', other_designations='ATP pyrophosphate-lyase 9|adenylate cyclase type IX|adenylyl cyclase 9|adenylyl cyclase type 10', map_location='16 B1', chromosome='16', genomic_nucleotide_accession_version='NC_000082.6', start_position_on_the_genomic_accession=4284886, end_position_on_the_genomic_accession=4437236, orientation='minus', exon_count=12, OMIM='', no_hdr0=''),
  11516 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11516, CurrentID=0, Status='live', Symbol='Adcyap1', Aliases='PACAP', description='adenylate cyclase activating polypeptide 1', other_designations='', map_location='17 E5', chromosome='17', genomic_nucleotide_accession_version='NC_000083.6', start_position_on_the_genomic_accession=93198904, end_position_on_the_genomic_accession=93206541, orientation='plus', exon_count=6, OMIM='', no_hdr0=''),
  11517 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11517, CurrentID=0, Status='live', Symbol='Adcyap1r1', Aliases='2900024I10Rik, AI846590, PAC1, PAC1R, PACAP1-R', description='adenylate cyclase activating polypeptide 1 receptor 1', other_designations='PACAP type I receptor', map_location='6 B3', chromosome='6', genomic_nucleotide_accession_version='NC_000072.6', start_position_on_the_genomic_accession=55451501, end_position_on_the_genomic_accession=55501455, orientation='plus', exon_count=18, OMIM='', no_hdr0=''),
  11518 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11518, CurrentID=0, Status='live', Symbol='Add1', Aliases='AI256389', description='adducin 1 (alpha)', other_designations='erythrocyte adducin subunit alpha', map_location='5 17.9 cM', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=34573669, end_position_on_the_genomic_accession=34632305, orientation='plus', exon_count=20, OMIM='', no_hdr0=''),
  11519 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11519, CurrentID=0, Status='live', Symbol='Add2', Aliases='2900072M03Rik, add97', description='adducin 2 (beta)', other_designations='erythrocyte adducin subunit beta|snoRNA MBII-396', map_location='6 37.55 cM', chromosome='6', genomic_nucleotide_accession_version='NC_000072.6', start_position_on_the_genomic_accession=86028681, end_position_on_the_genomic_accession=86124409, orientation='plus', exon_count=17, OMIM='', no_hdr0=''),
  11520 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11520, CurrentID=0, Status='live', Symbol='Plin2', Aliases='AA407157, ADPH, Adfp, Adrp', description='perilipin 2', other_designations='adipophilin|adipose differentiation related protein|adipose differentiation-related protein', map_location='4 40.69 cM', chromosome='4', genomic_nucleotide_accession_version='NC_000070.6', start_position_on_the_genomic_accession=86626910, end_position_on_the_genomic_accession=86670059, orientation='minus', exon_count=10, OMIM='', no_hdr0=''),
  11522 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11522, CurrentID=0, Status='live', Symbol='Adh1', Aliases='ADH-AA, AI194826, Adh-1, Adh-1-t, Adh-1e, Adh-1t, Adh-3e-e, Adh1-t, Adh1tl, Adh3-e, Adh1', description='alcohol dehydrogenase 1 (class I)', other_designations='ADH-A2|alcohol dehydrogenase 1 temporal, liver|alcohol dehydrogenase 1, complex|alcohol dehydrogenase 1, electrophoretic|alcohol dehydrogenase 3, electrophoretic|alcohol dehydrogenase A subunit|class I alcohol dehydrogenase', map_location='3 64.16 cM', chromosome='3', genomic_nucleotide_accession_version='NC_000069.6', start_position_on_the_genomic_accession=138277645, end_position_on_the_genomic_accession=138290691, orientation='plus', exon_count=9, OMIM='', no_hdr0=''),
  404739 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=404739, CurrentID=0, Status='live', Symbol='Iglj2', Aliases='Igl-J2', description='immunoglobulin lambda joining 2', other_designations='immunoglobulin lambda chain, joining region 2', map_location='16 A3', chromosome='16', genomic_nucleotide_accession_version='NC_000082.6', start_position_on_the_genomic_accession=19200198, end_position_on_the_genomic_accession=19200235, orientation='minus', exon_count=0, OMIM='', no_hdr0=''),
  11529 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11529, CurrentID=0, Status='live', Symbol='Adh7', Aliases='AI325182, Adh-3, Adh-3e, Adh-3t, Adh3, Adh3-e, Adh3-t, Adh4, Adt-1', description='alcohol dehydrogenase 7 (class IV), mu or sigma polypeptide', other_designations='ADH-C2|IV ADH|alcohol dehydrogenase 3 complex|alcohol dehydrogenase 3 temporal|alcohol dehydrogenase 4|alcohol dehydrogenase class IV mu/sigma chain|gastric alcohol dehydrogenase|retinol dehydrogenase', map_location='3 64.13 cM', chromosome='3', genomic_nucleotide_accession_version='NC_000069.6', start_position_on_the_genomic_accession=138198053, end_position_on_the_genomic_accession=138232042, orientation='plus', exon_count=13, OMIM='', no_hdr0=''),
  11532 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11532, CurrentID=0, Status='live', Symbol='Adh5', Aliases='Adh-5, Adh3, GSNOR', description='alcohol dehydrogenase 5 (class III), chi polypeptide', other_designations='ADH-B2|FALDH|FDH|GSH-FDH|S-(hydroxymethyl)glutathione dehydrogenase|S-nitrosoglutathione reductase|alcohol dehydrogenase 2|alcohol dehydrogenase B2|alcohol dehydrogenase class-III|glutathione-dependent formaldehyde dehydrogenase', map_location='3 G3', chromosome='3', genomic_nucleotide_accession_version='NC_000069.6', start_position_on_the_genomic_accession=138437200, end_position_on_the_genomic_accession=138455499, orientation='plus', exon_count=10, OMIM='', no_hdr0=''),
  11534 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11534, CurrentID=0, Status='live', Symbol='Adk', Aliases='2310026J05Rik, 5033405D03Rik, AI255373, AI987814, Ak', description='adenosine kinase', other_designations="adenosine 5'-phosphotransferase", map_location='14 A2-B', chromosome='14', genomic_nucleotide_accession_version='NC_000080.6', start_position_on_the_genomic_accession=21052573, end_position_on_the_genomic_accession=21448569, orientation='plus', exon_count=14, OMIM='', no_hdr0=''),
  11535 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11535, CurrentID=0, Status='live', Symbol='Adm', Aliases='AM', description='adrenomedullin', other_designations='', map_location='7 57.7 cM', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=110627669, end_position_on_the_genomic_accession=110629819, orientation='plus', exon_count=4, OMIM='', no_hdr0=''),
  11536 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11536, CurrentID=0, Status='live', Symbol='Gpr182', Aliases='AM-R, Admr, G10-D, Gpcr17, Gpcr22, MB10, NOW', description='G protein-coupled receptor 182', other_designations='G10D|adrenomedullin receptor', map_location='10 75.07 cM', chromosome='10', genomic_nucleotide_accession_version='NC_000076.6', start_position_on_the_genomic_accession=127749602, end_position_on_the_genomic_accession=127751798, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  11537 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11537, CurrentID=0, Status='live', Symbol='Cfd', Aliases='Adn, DF', description='complement factor D (adipsin)', other_designations='28 kDa adipocyte protein|C3 convertase activator|D component (adipsin) of complement|adipsin|properdin factor D', map_location='10 39.72 cM', chromosome='10', genomic_nucleotide_accession_version='NC_000076.6', start_position_on_the_genomic_accession=79890853, end_position_on_the_genomic_accession=79892660, orientation='plus', exon_count=5, OMIM='', no_hdr0=''),
  11538 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11538, CurrentID=0, Status='live', Symbol='Adnp', Aliases='AA589558, mKIAA0784', description='activity-dependent neuroprotective protein', other_designations='', map_location='2 H3', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=168180965, end_position_on_the_genomic_accession=168207062, orientation='minus', exon_count=4, OMIM='', no_hdr0=''),
  11539 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11539, CurrentID=0, Status='live', Symbol='Adora1', Aliases='A1-AR, A1AR, A1R, AA1R, AI848715, BB176431, Ri', description='adenosine A1 receptor', other_designations='', map_location='1 E4', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=134199215, end_position_on_the_genomic_accession=134235457, orientation='minus', exon_count=4, OMIM='', no_hdr0=''),
  11540 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11540, CurrentID=0, Status='live', Symbol='Adora2a', Aliases='A2AAR, A2aR, AA2AR', description='adenosine A2a receptor', other_designations='', map_location='10 B5.3', chromosome='10', genomic_nucleotide_accession_version='NC_000076.6', start_position_on_the_genomic_accession=75316860, end_position_on_the_genomic_accession=75334792, orientation='plus', exon_count=7, OMIM='', no_hdr0=''),
  11541 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11541, CurrentID=0, Status='live', Symbol='Adora2b', Aliases='A2BAR, A2BR, A2b, AA2BR, AI480866, AI605384', description='adenosine A2b receptor', other_designations='A2b, Rs', map_location='11 B2', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=62248984, end_position_on_the_genomic_accession=62266452, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  11542 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11542, CurrentID=0, Status='live', Symbol='Adora3', Aliases='A3AR, A3R, AA3R, ARA3, Gpcr2', description='adenosine A3 receptor', other_designations='G-protein coupled receptor 2', map_location='3 46.45 cM', chromosome='3', genomic_nucleotide_accession_version='NC_000069.6', start_position_on_the_genomic_accession=105904421, end_position_on_the_genomic_accession=105908928, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  102640920 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=102640920, CurrentID=0, Status='live', Symbol='Gm36869', Aliases='', description='predicted gene, 36869', other_designations='', map_location='5', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=138341770, end_position_on_the_genomic_accession=138359898, orientation='plus', exon_count=8, OMIM='', no_hdr0=''),
  11545 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11545, CurrentID=0, Status='live', Symbol='Parp1', Aliases='5830444G22Rik, AI893648, ARTD1, Adprp, Adprt1, C80510, PARP, PPOL, parp-1, sPARP-1', description='poly (ADP-ribose) polymerase family, member 1', other_designations='ADP-ribosyltransferase (NAD+, poly (ADP-ribose) polymerase) 1|ADP-ribosyltransferase (NAD+; poly (ADP-ribose) polymerase) 1|ADP-ribosyltransferase diphtheria toxin-like 1|ADPRT 1|NAD(+) ADP-ribosyltransferase 1|msPARP|poly(ADP-ribose) polymerase|poly[ADP-ribose] synthase 1|poly[ADP-ribose] synthetase 1', map_location='1 H5', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=180568975, end_position_on_the_genomic_accession=180601254, orientation='plus', exon_count=23, OMIM='', no_hdr0=''),
  11546 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11546, CurrentID=0, Status='live', Symbol='Parp2', Aliases='ARTD2, Adprt2, Adprtl2, Aspartl2, C78626, PARP-2', description='poly (ADP-ribose) polymerase family, member 2', other_designations='ADP-ribosyltransferase (NAD+, poly(ADP-ribose) polymerase)-like 2|ADP-ribosyltransferase (NAD+; poly (ADP-ribose) polymerase) 2|ADP-ribosyltransferase (NAD+; poly(ADP-ribose) polymerase)-like 2|ADP-ribosyltransferase diphtheria toxin-like 2|ADPRT-2|NAD(+) ADP-ribosyltransferase 2|mPARP-2|pADPRT-2|poly[ADP-ribose] synthase 2|poly[ADP-ribose] synthetase 2', map_location='14 C1', chromosome='14', genomic_nucleotide_accession_version='NC_000080.6', start_position_on_the_genomic_accession=50807898, end_position_on_the_genomic_accession=50821301, orientation='plus', exon_count=16, OMIM='', no_hdr0=''),
  11548 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11548, CurrentID=0, Status='live', Symbol='Adra1b', Aliases='[a]1b', description='adrenergic receptor, alpha 1b', other_designations='alpha-1B adrenoceptor|alpha-1B adrenoreceptor|alpha1B-adrenergic receptor', map_location='11 25.81 cM', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=43774605, end_position_on_the_genomic_accession=43901251, orientation='minus', exon_count=5, OMIM='', no_hdr0=''),
  11549 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11549, CurrentID=0, Status='live', Symbol='Adra1a', Aliases='Adra1c', description='adrenergic receptor, alpha 1a', other_designations='alpha-1A adrenoceptor|alpha-1A adrenoreceptor|alpha-1C adrenergic receptor', map_location='14 D1', chromosome='14', genomic_nucleotide_accession_version='NC_000080.6', start_position_on_the_genomic_accession=66635017, end_position_on_the_genomic_accession=66771240, orientation='plus', exon_count=6, OMIM='', no_hdr0=''),
  11550 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11550, CurrentID=0, Status='live', Symbol='Adra1d', Aliases='Adra-1, Adra1, Adra1a, Gpcr8, Spr8, [a]1d, alpha1D-AR', description='adrenergic receptor, alpha 1d', other_designations='alpha-1A adrenergic receptor|alpha-1D adrenoceptor|alpha-1D adrenoreceptor', map_location='2 63.5 cM', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=131545357, end_position_on_the_genomic_accession=131562285, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  11551 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11551, CurrentID=0, Status='live', Symbol='Adra2a', Aliases='AW122659, Adra-2, Adra-2a, alpha(2A)AR, alpha2-C10, alpha2A, alpha2A-AR', description='adrenergic receptor, alpha 2a', other_designations='alpha-2A adrenoceptor|alpha-2A adrenoreceptor|alpha-2AAR|alpha2A-adrenergic receptor|subtype alpha2-C10', map_location='19 49.04 cM', chromosome='19', genomic_nucleotide_accession_version='NC_000085.6', start_position_on_the_genomic_accession=54045182, end_position_on_the_genomic_accession=54048982, orientation='plus', exon_count=1, OMIM='', no_hdr0=''),
  11552 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11552, CurrentID=0, Status='live', Symbol='Adra2b', Aliases='Adra-2b, [a]2B, alpha2-C2, alpha2B', description='adrenergic receptor, alpha 2b', other_designations='alpha-2B adrenoceptor|alpha-2B adrenoreceptor|alpha-2BAR|subtype alpha2-C2', map_location='2 61.95 cM', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=127363286, end_position_on_the_genomic_accession=127367221, orientation='plus', exon_count=1, OMIM='', no_hdr0=''),
  11553 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11553, CurrentID=0, Status='live', Symbol='Adra2c', Aliases='Adra-2c, [a]2C, alpha2-C4, alpha2C', description='adrenergic receptor, alpha 2c', other_designations='alpha-2 adrenergic receptor subtype C4|alpha-2C adrenoceptor|alpha-2C adrenoreceptor|alpha-2CAR|subtype alpha2-C4', map_location='5 18.09 cM', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=35278566, end_position_on_the_genomic_accession=35281763, orientation='plus', exon_count=1, OMIM='', no_hdr0=''),
  11554 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11554, CurrentID=0, Status='live', Symbol='Adrb1', Aliases='Adrb-1, beta-AR', description='adrenergic receptor, beta 1', other_designations='beta 1-AR|beta-1 adrenoceptor|beta-1 adrenoreceptor|cardiac beta adrenergic receptor', map_location='19 51.96 cM', chromosome='19', genomic_nucleotide_accession_version='NC_000085.6', start_position_on_the_genomic_accession=56722372, end_position_on_the_genomic_accession=56724862, orientation='plus', exon_count=1, OMIM='', no_hdr0=''),
  11555 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11555, CurrentID=0, Status='live', Symbol='Adrb2', Aliases='Adrb-2, Badm, Gpcr7', description='adrenergic receptor, beta 2', other_designations='beta 2-AR|beta-2 adrenoceptor|beta-2 adrenoreceptor', map_location='18 35.1 cM', chromosome='18', genomic_nucleotide_accession_version='NC_000084.6', start_position_on_the_genomic_accession=62177713, end_position_on_the_genomic_accession=62179981, orientation='minus', exon_count=1, OMIM='', no_hdr0=''),
  11556 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11556, CurrentID=0, Status='live', Symbol='Adrb3', Aliases='Adrb-3', description='adrenergic receptor, beta 3', other_designations='Beta-3 AR|Beta-3 adrenoceptor|beta 3-AR|beta-3 adrenoreceptor|beta3-adrenergic receptor', map_location='8 A2-A4', chromosome='8', genomic_nucleotide_accession_version='NC_000074.6', start_position_on_the_genomic_accession=27225776, end_position_on_the_genomic_accession=27230805, orientation='minus', exon_count=6, OMIM='', no_hdr0=''),
  11564 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11564, CurrentID=0, Status='live', Symbol='Adsl', Aliases='Adl, Asl', description='adenylosuccinate lyase', other_designations='ASase|adenylosuccinase|adenylosuccinate lyase 1', map_location='15 37.95 cM', chromosome='15', genomic_nucleotide_accession_version='NC_000081.6', start_position_on_the_genomic_accession=80948490, end_position_on_the_genomic_accession=80970947, orientation='plus', exon_count=13, OMIM='', no_hdr0=''),
  11565 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11565, CurrentID=0, Status='live', Symbol='Adssl1', Aliases='AI528595, Adss, Adss1', description='adenylosuccinate synthetase like 1', other_designations='AMPSase 1|IMP--aspartate ligase 1|M-type adenylosuccinate synthetase|adSS 1|adenylosuccinate synthetase 1, muscle|adenylosuccinate synthetase, basic isozyme|adenylosuccinate synthetase, muscle isozyme', map_location='12 F1', chromosome='12', genomic_nucleotide_accession_version='NC_000078.6', start_position_on_the_genomic_accession=112620047, end_position_on_the_genomic_accession=112641355, orientation='plus', exon_count=13, OMIM='', no_hdr0=''),
  11566 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11566, CurrentID=0, Status='live', Symbol='Adss', Aliases='AI314886, AS2, Adss', description='adenylosuccinate synthetase, non muscle', other_designations='AMPSase 2|IMP--aspartate ligase 2|L-type adenylosuccinate synthetase|adSS 2|adenylosuccinate synthetase 2, non muscle|adenylosuccinate synthetase, acidic isozyme|adenylosuccinate synthetase, liver isozyme|adenylosuccinate synthetase, non-muscle isozyme', map_location='1 H4', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=177763178, end_position_on_the_genomic_accession=177796694, orientation='minus', exon_count=13, OMIM='', no_hdr0=''),
  11567 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11567, CurrentID=0, Status='live', Symbol='Avil', Aliases='Advil, DOC6', description='advillin', other_designations='actin-binding protein DOC6|p92', map_location='10 D3', chromosome='10', genomic_nucleotide_accession_version='NC_000076.6', start_position_on_the_genomic_accession=127000075, end_position_on_the_genomic_accession=127020994, orientation='plus', exon_count=21, OMIM='', no_hdr0=''),
  11568 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11568, CurrentID=0, Status='live', Symbol='Aebp1', Aliases='ACLP', description='AE binding protein 1', other_designations='aortic carboxypeptidase-like protein', map_location='11 A1', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=5861853, end_position_on_the_genomic_accession=5872225, orientation='plus', exon_count=22, OMIM='', no_hdr0=''),
  11569 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11569, CurrentID=0, Status='live', Symbol='Aebp2', Aliases='AU023766, B230313N05Rik', description='AE binding protein 2', other_designations='AE-binding protein 2|adipocyte enhancer-binding protein 2', map_location='6 G1', chromosome='6', genomic_nucleotide_accession_version='NC_000072.6', start_position_on_the_genomic_accession=140622454, end_position_on_the_genomic_accession=140677634, orientation='plus', exon_count=13, OMIM='', no_hdr0=''),
  11571 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11571, CurrentID=0, Status='live', Symbol='Crisp1', Aliases='AW324342, Aeg1, CRISP-1', description='cysteine-rich secretory protein 1', other_designations='SCP 1|acidic epididymal glycoprotein 1|sperm-coating glycoprotein 1', map_location='17 19.47 cM', chromosome='17', genomic_nucleotide_accession_version='NC_000083.6', start_position_on_the_genomic_accession=40293758, end_position_on_the_genomic_accession=40319246, orientation='minus', exon_count=8, OMIM='', no_hdr0=''),
  11572 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11572, CurrentID=0, Status='live', Symbol='Crisp3', Aliases='Aeg2, CRISP-3, CRS3, SGP28', description='cysteine-rich secretory protein 3', other_designations='SCP 2|acidic epididymal glycoprotein 2|sperm-coating glycoprotein 2', map_location='17 19.45 cM', chromosome='17', genomic_nucleotide_accession_version='NC_000083.6', start_position_on_the_genomic_accession=40221777, end_position_on_the_genomic_accession=40242258, orientation='minus', exon_count=8, OMIM='', no_hdr0=''),
  11576 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11576, CurrentID=0, Status='live', Symbol='Afp', Aliases='', description='alpha fetoprotein', other_designations='alpha-1-fetoprotein|alpha-fetoglobulin|alpha-foetoprotein', map_location='5 44.77 cM', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=90490714, end_position_on_the_genomic_accession=90508907, orientation='plus', exon_count=15, OMIM='', no_hdr0=''),
  666938 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=666938, CurrentID=0, Status='live', Symbol='Bend4', Aliases='D330027G24Rik, EG666938', description='BEN domain containing 4', other_designations='bend4', map_location='5', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=67392147, end_position_on_the_genomic_accession=67428250, orientation='minus', exon_count=6, OMIM='', no_hdr0=''),
  11592 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11592, CurrentID=0, Status='live', Symbol='ag', Aliases='', description='agitans', other_designations='', map_location='', chromosome='14', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  11593 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11593, CurrentID=0, Status='live', Symbol='Aga', Aliases='AW060726', description='aspartylglucosaminidase', other_designations='N4-(N-acetyl-beta-glucosaminyl)-L-asparagine amidase|glycosylasparaginase', map_location='8 B3', chromosome='8', genomic_nucleotide_accession_version='NC_000074.6', start_position_on_the_genomic_accession=53511687, end_position_on_the_genomic_accession=53523422, orientation='plus', exon_count=10, OMIM='', no_hdr0=''),
  11595 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11595, CurrentID=0, Status='live', Symbol='Acan', Aliases='Agc, Agc1, Cspg1, b2b183Clo, cmd', description='aggrecan', other_designations='CSPCP|aggrecan 1|cartilage-specific proteoglycan core protein', map_location='7 44.88 cM', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=79053202, end_position_on_the_genomic_accession=79115099, orientation='plus', exon_count=18, OMIM='', no_hdr0=''),
  11596 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11596, CurrentID=0, Status='live', Symbol='Ager', Aliases='RAGE', description='advanced glycosylation end product-specific receptor', other_designations='advanced glycation end-products receptor|receptor for advanced glycation end-products variant 20|receptor for advanced glycosylation end products', map_location='17 B1', chromosome='17', genomic_nucleotide_accession_version='NC_000083.6', start_position_on_the_genomic_accession=34597410, end_position_on_the_genomic_accession=34600937, orientation='plus', exon_count=10, OMIM='', no_hdr0=''),
  11600 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11600, CurrentID=0, Status='live', Symbol='Angpt1', Aliases='1110046O21Rik, Ang-1, Ang1', description='angiopoietin 1', other_designations='', map_location='15 16.69 cM', chromosome='15', genomic_nucleotide_accession_version='NC_000081.6', start_position_on_the_genomic_accession=42424667, end_position_on_the_genomic_accession=42676977, orientation='minus', exon_count=10, OMIM='', no_hdr0=''),
  11601 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11601, CurrentID=0, Status='live', Symbol='Angpt2', Aliases='Agpt2, Ang-2, Ang2', description='angiopoietin 2', other_designations='', map_location='8 10.3 cM', chromosome='8', genomic_nucleotide_accession_version='NC_000074.6', start_position_on_the_genomic_accession=18690263, end_position_on_the_genomic_accession=18741562, orientation='minus', exon_count=9, OMIM='', no_hdr0=''),
  11602 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11602, CurrentID=0, Status='live', Symbol='Angpt4', Aliases='Agpt4, Ang3', description='angiopoietin 4', other_designations='ANG-3|ANG-4|angiopoietin 3|angiopoietin-3', map_location='2 74.83 cM', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=151911332, end_position_on_the_genomic_accession=151944654, orientation='plus', exon_count=9, OMIM='', no_hdr0=''),
  11603 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11603, CurrentID=0, Status='live', Symbol='Agrn', Aliases='Agrin, nmf380', description='agrin', other_designations='', map_location='4 88.55 cM', chromosome='4', genomic_nucleotide_accession_version='NC_000070.6', start_position_on_the_genomic_accession=156165290, end_position_on_the_genomic_accession=156197519, orientation='minus', exon_count=43, OMIM='', no_hdr0=''),
  11604 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11604, CurrentID=0, Status='live', Symbol='Agrp', Aliases='Agrt, Art', description='agouti related neuropeptide', other_designations='agouti related protein|orexigenic neuropeptide', map_location='8 D1-D2', chromosome='8', genomic_nucleotide_accession_version='NC_000074.6', start_position_on_the_genomic_accession=105566695, end_position_on_the_genomic_accession=105579845, orientation='minus', exon_count=6, OMIM='', no_hdr0=''),
  11605 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11605, CurrentID=0, Status='live', Symbol='Gla', Aliases='Ags', description='galactosidase, alpha', other_designations='alpha-D-galactosidase A|alpha-D-galactoside galactohydrolase|melibiase', map_location='X E-F1', chromosome='X', genomic_nucleotide_accession_version='NC_000086.7', start_position_on_the_genomic_accession=134588169, end_position_on_the_genomic_accession=134601005, orientation='minus', exon_count=7, OMIM='', no_hdr0=''),
  11606 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11606, CurrentID=0, Status='live', Symbol='Agt', Aliases='AI265500, AngI, AngII, Aogen, Serpina8', description='angiotensinogen (serpin peptidase inhibitor, clade A, member 8)', other_designations='angiotensin I|angiotensin ll|serpin A8', map_location='8 72.81 cM', chromosome='8', genomic_nucleotide_accession_version='NC_000074.6', start_position_on_the_genomic_accession=124556587, end_position_on_the_genomic_accession=124569707, orientation='minus', exon_count=5, OMIM='', no_hdr0=''),
  11607 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11607, CurrentID=0, Status='live', Symbol='Agtr1a', Aliases='1810074K20Rik, AG2S, AI551199, AT1, AT1a, AT2R1, AT2R1A, Agtr-1a, Agtr1, Angtr-1a', description='angiotensin II receptor, type 1a', other_designations='angiotensin II type-1A receptor|angiotensin receptor 1|angiotensin receptor 1a', map_location='13 13.19 cM', chromosome='13', genomic_nucleotide_accession_version='NC_000079.6', start_position_on_the_genomic_accession=30336356, end_position_on_the_genomic_accession=30382867, orientation='plus', exon_count=4, OMIM='', no_hdr0=''),
  11608 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11608, CurrentID=0, Status='live', Symbol='Agtr1b', Aliases='AT1B, AT2R1B, Agtr-1b, Angtr-1b', description='angiotensin II receptor, type 1b', other_designations='AT3|angiotensin II type-1B receptor', map_location='3 6.37 cM', chromosome='3', genomic_nucleotide_accession_version='NC_000069.6', start_position_on_the_genomic_accession=20314473, end_position_on_the_genomic_accession=20367177, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  11609 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11609, CurrentID=0, Status='live', Symbol='Agtr2', Aliases='AI316812, AW107640', description='angiotensin II receptor, type 2', other_designations='AT2 receptor|angiotensin II type-2 receptor', map_location='X 16.71 cM', chromosome='X', genomic_nucleotide_accession_version='NC_000086.7', start_position_on_the_genomic_accession=21484549, end_position_on_the_genomic_accession=21488833, orientation='plus', exon_count=3, OMIM='', no_hdr0=''),
  142682 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=142682, CurrentID=0, Status='live', Symbol='Zcchc14', Aliases='AA792890, BDG29', description='zinc finger, CCHC domain containing 14', other_designations='BDG-29 protein', map_location='8 E1', chromosome='8', genomic_nucleotide_accession_version='NC_000074.6', start_position_on_the_genomic_accession=121598697, end_position_on_the_genomic_accession=121652761, orientation='minus', exon_count=13, OMIM='', no_hdr0=''),
  11611 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11611, CurrentID=0, Status='live', Symbol='Agxt', Aliases='AGT, Agt11, SPT, Agxt', description='alanine-glyoxylate aminotransferase', other_designations='alanine--glyoxylate aminotransferase|alanine-glyoxylate aminotransferase 1|serine-pyruvate aminotransferase', map_location='1 47.0 cM', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=93135240, end_position_on_the_genomic_accession=93145421, orientation='plus', exon_count=11, OMIM='', no_hdr0=''),
  11614 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11614, CurrentID=0, Status='live', Symbol='Nr0b1', Aliases='AHX, Ahc, Ahch, DAX-1, Dax1', description='nuclear receptor subfamily 0, group B, member 1', other_designations='adrenal hypoplasia congenita-like protein|adrenal hypoplasia, congenital homolog|nuclear receptor DAX-1', map_location='X 39.67 cM', chromosome='X', genomic_nucleotide_accession_version='NC_000086.7', start_position_on_the_genomic_accession=86191775, end_position_on_the_genomic_accession=86195944, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  142687 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=142687, CurrentID=0, Status='live', Symbol='Asb14', Aliases='Asb-14', description='ankyrin repeat and SOCS box-containing 14', other_designations='ankyrin repeat and SOCS box-containing protein 14|ankyrin repeat domain-containing SOCS box protein 14', map_location='14 A3', chromosome='14', genomic_nucleotide_accession_version='NC_000080.6', start_position_on_the_genomic_accession=26894591, end_position_on_the_genomic_accession=26916100, orientation='plus', exon_count=10, OMIM='', no_hdr0=''),
  142688 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=142688, CurrentID=0, Status='live', Symbol='Asb13', Aliases='2210015B19Rik, 6430573K02Rik, Asb-13, C85285', description='ankyrin repeat and SOCS box-containing 13', other_designations='ankyrin repeat and SOCS box-containing protein 13|ankyrin repeat domain-containing SOCS box protein 13', map_location='13 A1', chromosome='13', genomic_nucleotide_accession_version='NC_000079.6', start_position_on_the_genomic_accession=3634012, end_position_on_the_genomic_accession=3651779, orientation='plus', exon_count=7, OMIM='', no_hdr0=''),
  11622 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11622, CurrentID=0, Status='live', Symbol='Ahr', Aliases='Ah, Ahhe, In, bHLHe76, Ahr', description='aryl-hydrocarbon receptor', other_designations='ah receptor|dioxin receptor', map_location='12 15.78 cM', chromosome='12', genomic_nucleotide_accession_version='NC_000078.6', start_position_on_the_genomic_accession=35497979, end_position_on_the_genomic_accession=35534989, orientation='minus', exon_count=11, OMIM='', no_hdr0=''),
  11624 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11624, CurrentID=0, Status='live', Symbol='Ahrr', Aliases='mKIAA1234', description='aryl-hydrocarbon receptor repressor', other_designations='ahR repressor', map_location='13 C2', chromosome='13', genomic_nucleotide_accession_version='NC_000079.6', start_position_on_the_genomic_accession=74211117, end_position_on_the_genomic_accession=74292330, orientation='minus', exon_count=15, OMIM='', no_hdr0=''),
  11625 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11625, CurrentID=0, Status='live', Symbol='Ahsg', Aliases='', description='alpha-2-HS-glycoprotein', other_designations='countertrypin|fetuin-A', map_location='16 13.74 cM', chromosome='16', genomic_nucleotide_accession_version='NC_000082.6', start_position_on_the_genomic_accession=22892015, end_position_on_the_genomic_accession=22899451, orientation='plus', exon_count=7, OMIM='', no_hdr0=''),
  11628 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11628, CurrentID=0, Status='live', Symbol='Aicda', Aliases='Aid, Arp2', description='activation-induced cytidine deaminase', other_designations='activation induced deaminase|cytidine aminohydrolase', map_location='6 F2', chromosome='6', genomic_nucleotide_accession_version='NC_000072.6', start_position_on_the_genomic_accession=122553809, end_position_on_the_genomic_accession=122564180, orientation='plus', exon_count=5, OMIM='', no_hdr0=''),
  11629 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11629, CurrentID=0, Status='live', Symbol='Aif1', Aliases='AI607846, AIF-1, D17H6S50E, G1, Iba1', description='allograft inflammatory factor 1', other_designations='ionized calcium binding adapter molecule 1|ionized calcium-binding adapter molecule 1|testis specific', map_location='17 18.59 cM', chromosome='17', genomic_nucleotide_accession_version='NC_000083.6', start_position_on_the_genomic_accession=35170991, end_position_on_the_genomic_accession=35176087, orientation='minus', exon_count=8, OMIM='', no_hdr0=''),
  11630 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11630, CurrentID=0, Status='live', Symbol='Aim1', Aliases='AI462491, AI463325', description='absent in melanoma 1', other_designations='', map_location='10 23.14 cM', chromosome='10', genomic_nucleotide_accession_version='NC_000076.6', start_position_on_the_genomic_accession=43950307, end_position_on_the_genomic_accession=44148924, orientation='minus', exon_count=23, OMIM='', no_hdr0=''),
  11632 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11632, CurrentID=0, Status='live', Symbol='Aip', Aliases='AA408703, AW476050, Ara9, D19Bwg1412e, Fkbp16, Xap2', description='aryl-hydrocarbon receptor-interacting protein', other_designations='', map_location='19 3.82 cM', chromosome='19', genomic_nucleotide_accession_version='NC_000085.6', start_position_on_the_genomic_accession=4113756, end_position_on_the_genomic_accession=4127236, orientation='minus', exon_count=9, OMIM='', no_hdr0=''),
  11634 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11634, CurrentID=0, Status='live', Symbol='Aire', Aliases='', description='autoimmune regulator (autoimmune polyendocrinopathy candidiasis ectodermal dystrophy)', other_designations='APECED protein homolog|autoimmune polyendocrinopathy candidiasis ectodermal dystrophy protein homolog|autoimmune regulator AIRE1a', map_location='10 39.72 cM', chromosome='10', genomic_nucleotide_accession_version='NC_000076.6', start_position_on_the_genomic_accession=78030022, end_position_on_the_genomic_accession=78043610, orientation='minus', exon_count=15, OMIM='', no_hdr0=''),
  11636 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11636, CurrentID=0, Status='live', Symbol='Ak1', Aliases='Ak-1, B430205N08Rik', description='adenylate kinase 1', other_designations='cytosolic adenylate kinase', map_location='2 22.09 cM', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=32621758, end_position_on_the_genomic_accession=32635058, orientation='plus', exon_count=10, OMIM='', no_hdr0=''),
  11637 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11637, CurrentID=0, Status='live', Symbol='Ak2', Aliases='Ak-2, D4Ertd220e', description='adenylate kinase 2', other_designations='AK 2|ATP-AMP transphosphorylase 2|ATP:AMP phosphotransferase|adenylate monophosphate kinase', map_location='4 62.62 cM', chromosome='4', genomic_nucleotide_accession_version='NC_000070.6', start_position_on_the_genomic_accession=128993217, end_position_on_the_genomic_accession=129011529, orientation='plus', exon_count=7, OMIM='', no_hdr0=''),
  11639 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11639, CurrentID=0, Status='live', Symbol='Ak4', Aliases='AK 4, Ak-3, Ak-4, Ak3, Ak3l1, D4Ertd274e', description='adenylate kinase 4', other_designations='AK 4|ATP-AMP transphosphorylase|GTP:AMP phosphotransferase AK4, mitochondrial|adenylate kinase 3 alpha-like 1|adenylate kinase 3-like 1|adenylate kinase isoenzyme 4, mitochondrial', map_location='4 46.84 cM', chromosome='4', genomic_nucleotide_accession_version='NC_000070.6', start_position_on_the_genomic_accession=101419289, end_position_on_the_genomic_accession=101467771, orientation='plus', exon_count=7, OMIM='', no_hdr0=''),
  11640 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11640, CurrentID=0, Status='live', Symbol='Akap1', Aliases='AKAP121, AKAP84, Akap, C76494, C81186, DAKAP1, S-AKAP84', description='A kinase (PRKA) anchor protein 1', other_designations='D-AKAP-1|PRKA1|S-AKAP|a kinase anchor protein 1, mitochondrial|dual specificity A-kinase-anchoring protein 1|protein kinase A-anchoring protein 1|spermatid A-kinase anchor protein', map_location='11 C', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=88830792, end_position_on_the_genomic_accession=88864586, orientation='minus', exon_count=14, OMIM='', no_hdr0=''),
  11641 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11641, CurrentID=0, Status='live', Symbol='Akap2', Aliases='AA959716, AI649048, Akap-2, Akap-kl, B230340M18Rik, Prka2', description='A kinase (PRKA) anchor protein 2', other_designations='AKAP expressed in kidney and lung|protein kinase A-anchoring protein 2', map_location='4 B3', chromosome='4', genomic_nucleotide_accession_version='NC_000070.6', start_position_on_the_genomic_accession=57845248, end_position_on_the_genomic_accession=57896984, orientation='plus', exon_count=5, OMIM='', no_hdr0=''),
  11642 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11642, CurrentID=0, Status='live', Symbol='Akap3', Aliases='Prka3', description='A kinase (PRKA) anchor protein 3', other_designations='A-kinase anchor protein 110 kDa|AKAP 110|AKAP-3|Protein kinase A-anchoring protein 3', map_location='6 F3', chromosome='6', genomic_nucleotide_accession_version='NC_000072.6', start_position_on_the_genomic_accession=126853098, end_position_on_the_genomic_accession=126874308, orientation='plus', exon_count=6, OMIM='', no_hdr0=''),
  11643 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11643, CurrentID=0, Status='live', Symbol='Akap4', Aliases='AKAP-4, AKAP82, Fsc1, PRKA4, mAKAP82, p82', description='A kinase (PRKA) anchor protein 4', other_designations='A-kinase anchor protein 82 kDa|major sperm fibrous sheath protein|protein kinase A-anchoring protein 4', map_location='X 3.17 cM', chromosome='X', genomic_nucleotide_accession_version='NC_000086.7', start_position_on_the_genomic_accession=7067515, end_position_on_the_genomic_accession=7078609, orientation='plus', exon_count=7, OMIM='', no_hdr0=''),
  11647 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11647, CurrentID=0, Status='live', Symbol='Alpl', Aliases='APTNAP, Akp-2, Akp2, TNAP, TNSALP', description='alkaline phosphatase, liver/bone/kidney', other_designations='alkaline phosphatase 2, liver', map_location='4 70.02 cM', chromosome='4', genomic_nucleotide_accession_version='NC_000070.6', start_position_on_the_genomic_accession=137741731, end_position_on_the_genomic_accession=137796384, orientation='minus', exon_count=18, OMIM='', no_hdr0=''),
  11648 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11648, CurrentID=0, Status='live', Symbol='Akp3', Aliases='Akp-3, IAP, dIAP', description='alkaline phosphatase 3, intestine, not Mn requiring', other_designations='intestinal alkaline phosphatase', map_location='1 44.06 cM', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=87125008, end_position_on_the_genomic_accession=87127912, orientation='plus', exon_count=11, OMIM='', no_hdr0=''),
  11650 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11650, CurrentID=0, Status='live', Symbol='Alppl2', Aliases='Akp5, C77216, D1Ertd816e, EAP', description='alkaline phosphatase, placental-like 2', other_designations='alkaline phosphatase 5|embryonic alkaline phosphatase|embryonic-type alkaline phosphatase', map_location='1 44.05 cM', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=87086690, end_position_on_the_genomic_accession=87096250, orientation='minus', exon_count=15, OMIM='', no_hdr0=''),
  11651 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11651, CurrentID=0, Status='live', Symbol='Akt1', Aliases='Akt, PKB, PKB/Akt, PKBalpha, Rac', description='thymoma viral proto-oncogene 1', other_designations='AKT1 kinase|Akt1m protein|PKB alpha|RAC-PK-alpha|protein kinase B alpha|protein kinase B-alpha|proto-oncogene c-AKT|related to A and C kinases', map_location='12 61.2 cM', chromosome='12', genomic_nucleotide_accession_version='NC_000078.6', start_position_on_the_genomic_accession=112653821, end_position_on_the_genomic_accession=112674802, orientation='minus', exon_count=16, OMIM='', no_hdr0=''),
  11652 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11652, CurrentID=0, Status='live', Symbol='Akt2', Aliases='2410016A19Rik, AW554154, PKB, PKBbeta', description='thymoma viral proto-oncogene 2', other_designations='PKB beta|RAC-PK-beta|RAC-beta serine/threonine protein kinase|protein kinase Akt-2|protein kinase B beta|protein kinase B, beta', map_location='7 B1', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=27591557, end_position_on_the_genomic_accession=27639453, orientation='plus', exon_count=20, OMIM='', no_hdr0=''),
  11655 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11655, CurrentID=0, Status='live', Symbol='Alas1', Aliases='ALAS, ALAS-N, Alas-1, Alas-h', description='aminolevulinic acid synthase 1', other_designations='5-aminolevulinic acid synthase 1|aminolevulinate synthase H|delta-ALA synthase 1|delta-aminolevulinate synthase 1|succinyl-CoA: glycine C-succinyl transferase', map_location='9 F1', chromosome='9', genomic_nucleotide_accession_version='NC_000075.6', start_position_on_the_genomic_accession=106233455, end_position_on_the_genomic_accession=106247954, orientation='minus', exon_count=12, OMIM='', no_hdr0=''),
  11656 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11656, CurrentID=0, Status='live', Symbol='Alas2', Aliases='ALAS, ALAS-E, ALASE, Alas-2', description='aminolevulinic acid synthase 2, erythroid', other_designations='5-aminolevulinic acid synthase 2|delta-ALA synthase 2|delta-aminolevulinate synthase 2|erythroid-specific ALAS', map_location='X 68.46 cM', chromosome='X', genomic_nucleotide_accession_version='NC_000086.7', start_position_on_the_genomic_accession=150547417, end_position_on_the_genomic_accession=150570622, orientation='plus', exon_count=11, OMIM='', no_hdr0=''),
  11657 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11657, CurrentID=0, Status='live', Symbol='Alb', Aliases='Alb-11, BCL002, Alb', description='albumin', other_designations='albumin 1', map_location='5 44.7 cM', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=90460889, end_position_on_the_genomic_accession=90476603, orientation='plus', exon_count=15, OMIM='', no_hdr0=''),
  11658 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11658, CurrentID=0, Status='live', Symbol='Alcam', Aliases='AI853494, BEN, CD166, DM-GRASP, MuSC, SC1', description='activated leukocyte cell adhesion molecule', other_designations='', map_location='16 B5', chromosome='16', genomic_nucleotide_accession_version='NC_000082.6', start_position_on_the_genomic_accession=52248996, end_position_on_the_genomic_accession=52453255, orientation='minus', exon_count=16, OMIM='', no_hdr0=''),
  11666 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11666, CurrentID=0, Status='live', Symbol='Abcd1', Aliases='ALDP, Ald, Aldgh', description='ATP-binding cassette, sub-family D (ALD), member 1', other_designations='ATP-binding cassette, sub-family D, member 1|X-linked adrenoleukodystrophy (ALD) gene homolog|adrenoleukodystrophy protein', map_location='X B', chromosome='X', genomic_nucleotide_accession_version='NC_000086.7', start_position_on_the_genomic_accession=73716597, end_position_on_the_genomic_accession=73738287, orientation='plus', exon_count=10, OMIM='', no_hdr0=''),
  11668 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11668, CurrentID=0, Status='live', Symbol='Aldh1a1', Aliases='Ahd-2, Ahd2, Aldh1, Aldh1a2, E1, Raldh1', description='aldehyde dehydrogenase family 1, subfamily A1', other_designations='ALDH-E1|ALHDII|RALDH 1|alcohol dehydrogenase family 1, subfamily A1|alcohol dehydrogenase family 1, subfamily A2|aldehyde dehydrogenase 1, liver cytosolic (class 1)|aldehyde dehydrogenase family 1 member A1|aldehyde dehydrogenase, cytosolic', map_location='19 13.91 cM', chromosome='19', genomic_nucleotide_accession_version='NC_000085.6', start_position_on_the_genomic_accession=20601982, end_position_on_the_genomic_accession=20643462, orientation='plus', exon_count=13, OMIM='', no_hdr0=''),
  11669 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11669, CurrentID=0, Status='live', Symbol='Aldh2', Aliases='AHD-M1, ALDH-E2, ALDHI, Ahd-5, Ahd5', description='aldehyde dehydrogenase 2, mitochondrial', other_designations='ALDH class 2', map_location='5 F-G1', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=121567687, end_position_on_the_genomic_accession=121593824, orientation='minus', exon_count=13, OMIM='', no_hdr0=''),
  11670 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11670, CurrentID=0, Status='live', Symbol='Aldh3a1', Aliases='Ahd-4, Ahd4, Aldh, Aldh3', description='aldehyde dehydrogenase family 3, subfamily A1', other_designations='alcohol dehydrogenase family 3, subfamily A1|aldehyde dehydrogenase 3, stomach cytosolic (class 3)|aldehyde dehydrogenase 4|aldehyde dehydrogenase family 3 member A1|dioxin-inducible aldehyde dehydrogenase 3', map_location='11 37.96 cM', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=61207537, end_position_on_the_genomic_accession=61218418, orientation='plus', exon_count=15, OMIM='', no_hdr0=''),
  11671 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11671, CurrentID=0, Status='live', Symbol='Aldh3a2', Aliases='AI194803, Ahd-3, Ahd-3r, Ahd3, Ahd3-r, Aldh4, Aldh4-r, FALDH', description='aldehyde dehydrogenase family 3, subfamily A2', other_designations='alcohol dehydrogenase family 3, subfamily A2|aldehyde dehydrogenase 3|aldehyde dehydrogenase 4, liver microsomal (class 3) regulator|aldehyde dehydrogenase family 3 member A2', map_location='11 37.96 cM', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=61224486, end_position_on_the_genomic_accession=61267465, orientation='minus', exon_count=14, OMIM='', no_hdr0=''),
  667034 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=667034, CurrentID=0, Status='live', Symbol='Pnp2', Aliases='', description='purine-nucleoside phosphorylase 2', other_designations='', map_location='14 C1', chromosome='14', genomic_nucleotide_accession_version='NC_000080.6', start_position_on_the_genomic_accession=50956141, end_position_on_the_genomic_accession=50964749, orientation='plus', exon_count=7, OMIM='', no_hdr0=''),
  11676 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11676, CurrentID=0, Status='live', Symbol='Aldoc', Aliases='AI847350, AU040929, Aldo3, Scrg2', description='aldolase C, fructose-bisphosphate', other_designations='aldolase 3, C isoform|brain-type aldolase|scrapie responsive gene 2|scrapie-responsive protein 2|zebrin II', map_location='11 46.74 cM', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=78323073, end_position_on_the_genomic_accession=78327781, orientation='plus', exon_count=9, OMIM='', no_hdr0=''),
  11677 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11677, CurrentID=0, Status='live', Symbol='Akr1b3', Aliases='ALR2, AR, Ahr-1, Ahr1, Akr1b1, Aldor1, Aldr1', description='aldo-keto reductase family 1, member B3 (aldose reductase)', other_designations='aldehyde reductase 1|aldo-keto reductase family 1, member B1 (aldose reductase)', map_location='6 B1', chromosome='6', genomic_nucleotide_accession_version='NC_000072.6', start_position_on_the_genomic_accession=34303930, end_position_on_the_genomic_accession=34317489, orientation='minus', exon_count=10, OMIM='', no_hdr0=''),
  11682 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11682, CurrentID=0, Status='live', Symbol='Alk', Aliases='CD246, Tcrz', description='anaplastic lymphoma kinase', other_designations='', map_location='17 43.77 cM', chromosome='17', genomic_nucleotide_accession_version='NC_000083.6', start_position_on_the_genomic_accession=71868988, end_position_on_the_genomic_accession=72605410, orientation='minus', exon_count=29, OMIM='', no_hdr0=''),
  11684 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11684, CurrentID=0, Status='live', Symbol='Alox12', Aliases='9930022G08Rikp, P-12LO, Alox12', description='arachidonate 12-lipoxygenase', other_designations='12S-LOX|12S-lipoxygenase|lipoxin synthase 12-LO|platelet-type lipoxygenase 12', map_location='11 42.99 cM', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=70241455, end_position_on_the_genomic_accession=70255386, orientation='minus', exon_count=15, OMIM='', no_hdr0=''),
  11685 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11685, CurrentID=0, Status='live', Symbol='Alox12e', Aliases='8-LOX, AW259591, Alox12-ps1, Alox12-ps2, Aloxe, e-LOX1', description='arachidonate lipoxygenase, epidermal', other_designations='12-LOX|arachidonate 12-lipoxygenase, epidermal', map_location='11 42.99 cM', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=70315503, end_position_on_the_genomic_accession=70322727, orientation='minus', exon_count=15, OMIM='', no_hdr0=''),
  11686 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11686, CurrentID=0, Status='live', Symbol='Alox12b', Aliases='12R-LOX, Aloxe2, e-LOX2', description='arachidonate 12-lipoxygenase, 12R type', other_designations='12R-lipoxygenase|epidermis-type lipoxygenase 12|epidermis-type lipoxygenase 2', map_location='11 42.38 cM', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=69157072, end_position_on_the_genomic_accession=69169791, orientation='plus', exon_count=15, OMIM='', no_hdr0=''),
  11687 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11687, CurrentID=0, Status='live', Symbol='Alox15', Aliases='12-LO, 12/15-LO, 15-LOX, Alox12l, L-12LO', description='arachidonate 15-lipoxygenase', other_designations='12-LOX|12/15-lipoxygenase|arachidonate 12-lipoxygenase, leukocyte-type|arachidonate omega-6 lipoxygenase', map_location='11 42.99 cM', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=70344147, end_position_on_the_genomic_accession=70375918, orientation='minus', exon_count=15, OMIM='', no_hdr0=''),
  11688 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11688, CurrentID=0, Status='live', Symbol='Alox8', Aliases='15-LOX-2, 15-LOX-B, 8-LOX, 8S-LOX, Alox15b', description='arachidonate 8-lipoxygenase', other_designations='15-lipoxygenase 2|8S-lipoxygenase|arachidonate 15-lipoxygenase B|arachidonate 15-lipoxygenase type II|arachidonate 15-lipoxygenase, second type', map_location='11 B4', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=69183885, end_position_on_the_genomic_accession=69197843, orientation='minus', exon_count=14, OMIM='', no_hdr0=''),
  11689 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11689, CurrentID=0, Status='live', Symbol='Alox5', Aliases='5-LO, 5-LOX, 5LO, 5LX, AI850497, F730011J02', description='arachidonate 5-lipoxygenase', other_designations='5-lipoxygenase', map_location='6 53.79 cM', chromosome='6', genomic_nucleotide_accession_version='NC_000072.6', start_position_on_the_genomic_accession=116410069, end_position_on_the_genomic_accession=116461210, orientation='minus', exon_count=14, OMIM='', no_hdr0=''),
  11690 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11690, CurrentID=0, Status='live', Symbol='Alox5ap', Aliases='Flap', description='arachidonate 5-lipoxygenase activating protein', other_designations='MK-886-binding protein', map_location='5 G3', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=149265058, end_position_on_the_genomic_accession=149288047, orientation='plus', exon_count=5, OMIM='', no_hdr0=''),
  11692 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11692, CurrentID=0, Status='live', Symbol='Gfer', Aliases='Alr, ERV1', description='growth factor, erv1 (S. cerevisiae)-like (augmenter of liver regeneration)', other_designations='augmenter of liver regeneration', map_location='17 12.48 cM', chromosome='17', genomic_nucleotide_accession_version='NC_000083.6', start_position_on_the_genomic_accession=24693189, end_position_on_the_genomic_accession=24696227, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  11694 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11694, CurrentID=0, Status='live', Symbol='Alx3', Aliases='', description='aristaless-like homeobox 3', other_designations='proline-rich transcription factor Alx3', map_location='3 46.83 cM', chromosome='3', genomic_nucleotide_accession_version='NC_000069.6', start_position_on_the_genomic_accession=107595031, end_position_on_the_genomic_accession=107605875, orientation='plus', exon_count=4, OMIM='', no_hdr0=''),
  11695 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11695, CurrentID=0, Status='live', Symbol='Alx4', Aliases='lst', description='aristaless-like homeobox 4', other_designations="ALX-4|Aristaless-like 4|Strong's luxoid|aristaless 4", map_location='2 51.62 cM', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=93642434, end_position_on_the_genomic_accession=93681341, orientation='plus', exon_count=5, OMIM='', no_hdr0=''),
  11697 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11697, CurrentID=0, Status='live', Symbol='am', Aliases='', description='amputated', other_designations='', map_location='', chromosome='8', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  11698 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11698, CurrentID=0, Status='live', Symbol='Ambn', Aliases='', description='ameloblastin', other_designations='', map_location='5 43.63 cM', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=88455991, end_position_on_the_genomic_accession=88468531, orientation='plus', exon_count=11, OMIM='', no_hdr0=''),
  11699 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11699, CurrentID=0, Status='live', Symbol='Ambp', Aliases='AI194774, ASPI, HI-30, Intin4, Itil, UTI', description='alpha 1 microglobulin/bikunin', other_designations='Urinary Trypsin Inhibitor|ulinastatin', map_location='4 C1-C3', chromosome='4', genomic_nucleotide_accession_version='NC_000070.6', start_position_on_the_genomic_accession=63143279, end_position_on_the_genomic_accession=63154142, orientation='minus', exon_count=10, OMIM='', no_hdr0=''),
  11702 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11702, CurrentID=0, Status='live', Symbol='Amd1', Aliases='AdoMetDC, Amd-1, SAMDC, SAMDC 1, adoMetDC1', description='S-adenosylmethionine decarboxylase 1', other_designations='adoMetDC 1', map_location='10 B2', chromosome='10', genomic_nucleotide_accession_version='NC_000076.6', start_position_on_the_genomic_accession=40287458, end_position_on_the_genomic_accession=40302188, orientation='minus', exon_count=8, OMIM='', no_hdr0=''),
  11704 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11704, CurrentID=0, Status='live', Symbol='Amelx', Aliases='ALGN, AMGL, AMGX, Amel, Amg, LRAP, Rgsc888', description='amelogenin, X-linked', other_designations='amelogenin X chromosome|enamel matrix protein|leucine-rich amelogenin peptide', map_location='X 78.95 cM', chromosome='X', genomic_nucleotide_accession_version='NC_000086.7', start_position_on_the_genomic_accession=169175044, end_position_on_the_genomic_accession=169187287, orientation='minus', exon_count=9, OMIM='', no_hdr0=''),
  11705 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11705, CurrentID=0, Status='live', Symbol='Amh', Aliases='MIS', description='anti-Mullerian hormone', other_designations='Mullerian inhibiting substance|anti-Muellerian hormone|muellerian-inhibiting substance', map_location='10 39.72 cM', chromosome='10', genomic_nucleotide_accession_version='NC_000076.6', start_position_on_the_genomic_accession=80805021, end_position_on_the_genomic_accession=80807679, orientation='plus', exon_count=5, OMIM='', no_hdr0=''),
  11717 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11717, CurrentID=0, Status='live', Symbol='Ampd3', Aliases='', description='adenosine monophosphate deaminase 3', other_designations='AMP deaminase H-type|heart-type AMPD', map_location='7 E2-E3', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=110767837, end_position_on_the_genomic_accession=110812409, orientation='plus', exon_count=20, OMIM='', no_hdr0=''),
  11720 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11720, CurrentID=0, Status='live', Symbol='Mat1a', Aliases='AI046368, AdoMet, Ams, MAT, MATA1, SAMS, SAMS1', description='methionine adenosyltransferase I, alpha', other_designations='adoMet synthetase 1', map_location='14 C1', chromosome='14', genomic_nucleotide_accession_version='NC_000080.6', start_position_on_the_genomic_accession=41105012, end_position_on_the_genomic_accession=41124428, orientation='plus', exon_count=10, OMIM='', no_hdr0=''),
  11722 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11722, CurrentID=0, Status='live', Symbol='Amy1', Aliases='Amy-1a, C030014B17Rik, Amy1', description='amylase 1, salivary', other_designations='1,4-alpha-D-glucan glucanohydrolase 1|alpha amylase 1|salivary and hepatic alpha-amylase', map_location='3 49.35 cM', chromosome='3', genomic_nucleotide_accession_version='NC_000069.6', start_position_on_the_genomic_accession=113555952, end_position_on_the_genomic_accession=113577750, orientation='minus', exon_count=12, OMIM='', no_hdr0=''),
  11727 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11727, CurrentID=0, Status='live', Symbol='Ang', Aliases='AI3855861, Rnase5, Rnase5a, Ang', description='angiogenin, ribonuclease, RNase A family, 5', other_designations='RNase 5|angiogenin, ribonuclease A family, member 1|angiogenin-1|ribonuclease 5', map_location='14 B-C1', chromosome='14', genomic_nucleotide_accession_version='NC_000080.6', start_position_on_the_genomic_accession=51091077, end_position_on_the_genomic_accession=51102009, orientation='plus', exon_count=3, OMIM='', no_hdr0=''),
  11731 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11731, CurrentID=0, Status='live', Symbol='Ang2', Aliases='Angrp, Raa3, Rnase5b', description='angiogenin, ribonuclease A family, member 2', other_designations='angiogenin related protein|angiogenin-related protein|ribonuclease A a3', map_location='14 C1', chromosome='14', genomic_nucleotide_accession_version='NC_000080.6', start_position_on_the_genomic_accession=51195486, end_position_on_the_genomic_accession=51195923, orientation='minus', exon_count=1, OMIM='', no_hdr0=''),
  11732 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11732, CurrentID=0, Status='live', Symbol='Ank', Aliases='Ankh, D15Ertd221e, ank, mKIAA1581', description='progressive ankylosis', other_designations='fn54 protein', map_location='15 10.23 cM', chromosome='15', genomic_nucleotide_accession_version='NC_000081.6', start_position_on_the_genomic_accession=27466677, end_position_on_the_genomic_accession=27594909, orientation='plus', exon_count=12, OMIM='', no_hdr0=''),
  11733 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11733, CurrentID=0, Status='live', Symbol='Ank1', Aliases='Ank-1, nb, pale', description='ankyrin 1, erythroid', other_designations='erythrocyte ankyrin|normoblastic anemia', map_location='8 11.42 cM', chromosome='8', genomic_nucleotide_accession_version='NC_000074.6', start_position_on_the_genomic_accession=22974836, end_position_on_the_genomic_accession=23150502, orientation='plus', exon_count=48, OMIM='', no_hdr0=''),
  11735 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11735, CurrentID=0, Status='live', Symbol='Ank3', Aliases='2900054D09Rik, AI314020, Ank-3, AnkG, Ankyrin-3, Ankyrin-G', description='ankyrin 3, epithelial', other_designations='brain-specific ankyrin-G', map_location='10 36.1 cM', chromosome='10', genomic_nucleotide_accession_version='NC_000076.6', start_position_on_the_genomic_accession=69533580, end_position_on_the_genomic_accession=70027436, orientation='plus', exon_count=51, OMIM='', no_hdr0=''),
  11736 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11736, CurrentID=0, Status='live', Symbol='Ankfy1', Aliases='Ankhzn, ZFYVE14, mKIAA1255', description='ankyrin repeat and FYVE domain containing 1', other_designations='Rabankyrin-5|ankyrin repeat and FYVE domain-containing protein 1|ankyrin repeat hooked to a zinc finger motif|ankyrin repeat hooked to zinc finger motif|ankyrin repeats hooked to a zinc finger motif|rank-5', map_location='11 B4', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=72690002, end_position_on_the_genomic_accession=72772146, orientation='plus', exon_count=25, OMIM='', no_hdr0=''),
  11737 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11737, CurrentID=0, Status='live', Symbol='Anp32a', Aliases='Anp32, I1PP2A, LANP, PHAP1, W91701, pp32', description='acidic (leucine-rich) nuclear phosphoprotein 32 family, member A', other_designations='acidic nuclear phosphoprotein 32|acidic nuclear phosphoprotein pp32|leucine-rich acidic nuclear protein|potent heat-stable protein phosphatase 2A inhibitor I1PP2A|vacidic (leucine-rich) nuclear phosphoprotein 32 family, member A', map_location='9 33.68 cM', chromosome='9', genomic_nucleotide_accession_version='NC_000075.6', start_position_on_the_genomic_accession=62341343, end_position_on_the_genomic_accession=62378804, orientation='plus', exon_count=9, OMIM='', no_hdr0=''),
  11739 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11739, CurrentID=0, Status='live', Symbol='Slc25a4', Aliases='AU019225, Ant1', description='solute carrier family 25 (mitochondrial carrier, adenine nucleotide translocator), member 4', other_designations='ADP,ATP carrier protein 1|ADP,ATP carrier protein, heart/skeletal muscle|ANT 1|adenine nucleotide translocase-1|adenine nucleotide translocator 1, skeletal muscle|mANC1|solute carrier family 25 member 4', map_location='8 26.22 cM', chromosome='8', genomic_nucleotide_accession_version='NC_000074.6', start_position_on_the_genomic_accession=46207339, end_position_on_the_genomic_accession=46211009, orientation='minus', exon_count=4, OMIM='', no_hdr0=''),
  11740 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11740, CurrentID=0, Status='live', Symbol='Slc25a5', Aliases='Ant2', description='solute carrier family 25 (mitochondrial carrier, adenine nucleotide translocator), member 5', other_designations='ADP, ATP carrier protein 2|ADP,ATP carrier protein 2|adenine nucleotide translocase|adenine nucleotide translocator 2, fibroblast', map_location='X A4', chromosome='X', genomic_nucleotide_accession_version='NC_000086.7', start_position_on_the_genomic_accession=36795652, end_position_on_the_genomic_accession=36798806, orientation='plus', exon_count=4, OMIM='', no_hdr0=''),
  11743 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11743, CurrentID=0, Status='live', Symbol='anx', Aliases='', description='anorexia', other_designations='', map_location='', chromosome='2', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  11744 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11744, CurrentID=0, Status='live', Symbol='Anxa11', Aliases='A830099O17Rik, Anx11', description='annexin A11', other_designations='Annexin A11 (Annexin XI) (Calcyclin-associated annexin 50) (CAP-50)|CAP-50|annexin XI|annexin-11|calcyclin-associated annexin 50', map_location='14 15.06 cM', chromosome='14', genomic_nucleotide_accession_version='NC_000080.6', start_position_on_the_genomic_accession=25842151, end_position_on_the_genomic_accession=25886804, orientation='plus', exon_count=16, OMIM='', no_hdr0=''),
  11745 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11745, CurrentID=0, Status='live', Symbol='Anxa3', Aliases='Anx3', description='annexin A3', other_designations='35-alpha calcimedin|PAP-III|annexin III|annexin-3|lipocortin III|placental anticoagulant protein III', map_location='5 47.29 cM', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=96793385, end_position_on_the_genomic_accession=96845968, orientation='plus', exon_count=13, OMIM='', no_hdr0=''),
  11746 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11746, CurrentID=0, Status='live', Symbol='Anxa4', Aliases='AI265406, AIV, AW106930, Anx4, Xanx-4', description='annexin A4', other_designations='annexin IV|annexin-4', map_location='6 37.75 cM', chromosome='6', genomic_nucleotide_accession_version='NC_000072.6', start_position_on_the_genomic_accession=86736840, end_position_on_the_genomic_accession=86793593, orientation='minus', exon_count=17, OMIM='', no_hdr0=''),
  11747 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11747, CurrentID=0, Status='live', Symbol='Anxa5', Aliases='Anx5, R74653', description='annexin A5', other_designations='CBP-I|PAP-I|PP4|VAC-alpha|anchorin CII|annexin V|annexin-5|calphobindin I|endonexin II|lipocortin V|placental anticoagulant protein 4|placental anticoagulant protein I|thromboplastin inhibitor|vascular anticoagulant-alpha', map_location='3 17.46 cM', chromosome='3', genomic_nucleotide_accession_version='NC_000069.6', start_position_on_the_genomic_accession=36448923, end_position_on_the_genomic_accession=36475887, orientation='minus', exon_count=13, OMIM='', no_hdr0=''),
  11749 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11749, CurrentID=0, Status='live', Symbol='Anxa6', Aliases='AW107198, Anx6, AnxVI, Cabm, Camb', description='annexin A6', other_designations='67 kDa calelectrin|CPB-II|annexin VI, p68|annexin-6|calphobindin-II|chromobindin-20|lipocortin VI|p68|p70', map_location='11 32.13 cM', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=54978962, end_position_on_the_genomic_accession=55033471, orientation='minus', exon_count=26, OMIM='', no_hdr0=''),
  11750 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11750, CurrentID=0, Status='live', Symbol='Anxa7', Aliases='AI265384, AI316497, Anx7, synexin', description='annexin A7', other_designations='annexin VII|annexin-7', map_location='14 11.53 cM', chromosome='14', genomic_nucleotide_accession_version='NC_000080.6', start_position_on_the_genomic_accession=20455261, end_position_on_the_genomic_accession=20480133, orientation='minus', exon_count=14, OMIM='', no_hdr0=''),
  11752 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11752, CurrentID=0, Status='live', Symbol='Anxa8', Aliases='AI466995, Anx8', description='annexin A8', other_designations='annexin 8|annexin VIII', map_location='14 20.8 cM', chromosome='14', genomic_nucleotide_accession_version='NC_000080.6', start_position_on_the_genomic_accession=34085979, end_position_on_the_genomic_accession=34100571, orientation='plus', exon_count=12, OMIM='', no_hdr0=''),
  11754 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11754, CurrentID=0, Status='live', Symbol='Aoc3', Aliases='SSAO, VAP1', description='amine oxidase, copper containing 3', other_designations='VAP-1|copper amine oxidase|semicarbazide-sensitive amine oxidase|vascular adhesion protein 1', map_location='11 B2-B5', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=101330606, end_position_on_the_genomic_accession=101339430, orientation='plus', exon_count=6, OMIM='', no_hdr0=''),
  11757 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11757, CurrentID=0, Status='live', Symbol='Prdx3', Aliases='AW822249, Aop1, D0Tohi1, Ef2l, Mer5, Prx3, SP22, TDXM', description='peroxiredoxin 3', other_designations='AOP-1|Prx III|anti-oxidant protein 1|antioxidant protein|mitochondrial Trx dependent peroxide reductase|mitochondrial thioredoxin dependent peroxide reductase|perioredoxin-3|peroxiredoxin III', map_location='19 56.52 cM', chromosome='19', genomic_nucleotide_accession_version='NC_000085.6', start_position_on_the_genomic_accession=60864066, end_position_on_the_genomic_accession=60874538, orientation='minus', exon_count=7, OMIM='', no_hdr0=''),
  11758 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11758, CurrentID=0, Status='live', Symbol='Prdx6', Aliases='1-Cys Prx, 1-cysPrx, 9430088D19Rik, AA690119, Aop2, Brp-12, CP-3, GPx, Ltw-4, Ltw4, Lvtw-4, NSGPx, ORF06, Prdx5, aiPLA2', description='peroxiredoxin 6', other_designations='1-Cys peroxiredoxin|acidic calcium-independent phospholipase A2|anti-oxidant protein 2, related sequence 3|antioxidant protein 2|non-selenium glutathione peroxidase|peroxiredoxin 5, related sequence 3|peroxiredoxin 6, related sequence 3', map_location='1 69.75 cM', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=161240112, end_position_on_the_genomic_accession=161251210, orientation='minus', exon_count=6, OMIM='', no_hdr0=''),
  11761 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11761, CurrentID=0, Status='live', Symbol='Aox1', Aliases='AI196512, AI255253, Ao, Aox-1, Aox-2, Aox2, Moro, Ro', description='aldehyde oxidase 1', other_designations='aldehyde oxidase 2|azaheterocycle hydroxylase 1|retinal oxidase', map_location='1 C1-C2', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=58029809, end_position_on_the_genomic_accession=58106410, orientation='plus', exon_count=36, OMIM='', no_hdr0=''),
  11764 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11764, CurrentID=0, Status='live', Symbol='Ap1b1', Aliases='Adtb1, b2b1660Clo', description='adaptor protein complex AP-1, beta 1 subunit', other_designations='Mutant line 1660|adapter-related protein complex 1 subunit beta-1|adaptor protein complex AP-1 subunit beta-1|adaptor-related protein complex 1 subunit beta-1|adaptor-related protein complex AP-1, beta 1 subunit|beta-1-adaptin|beta-adaptin 1|beta-prime adaptin|beta1-adaptin|clathrin assembly protein complex 1 beta large chain|golgi adaptor HA1/AP1 adaptin beta subunit', map_location='11 A2', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=4947521, end_position_on_the_genomic_accession=5042794, orientation='plus', exon_count=25, OMIM='', no_hdr0=''),
  11765 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11765, CurrentID=0, Status='live', Symbol='Ap1g1', Aliases='AA409002, AU041323, AW551707, Adtg, D8Ertd374e', description='adaptor protein complex AP-1, gamma 1 subunit', other_designations='adapter-related protein complex 1 subunit gamma-1|adaptor protein complex AP-1 subunit gamma-1|adaptor-related protein complex 1 subunit gamma-1|clathrin assembly protein complex 1 gamma-1 large chain|gamma-adaptin|gamma1-adaptin|golgi adaptor HA1/AP1 adaptin subunit gamma-1', map_location='8 57.26 cM', chromosome='8', genomic_nucleotide_accession_version='NC_000074.6', start_position_on_the_genomic_accession=109778583, end_position_on_the_genomic_accession=109864210, orientation='plus', exon_count=24, OMIM='', no_hdr0=''),
  11766 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11766, CurrentID=0, Status='live', Symbol='Ap1g2', Aliases='Adtg2, G2ad', description='adaptor protein complex AP-1, gamma 2 subunit', other_designations='gamma 2-adaptin', map_location='14 C3', chromosome='14', genomic_nucleotide_accession_version='NC_000080.6', start_position_on_the_genomic_accession=55098835, end_position_on_the_genomic_accession=55106593, orientation='minus', exon_count=22, OMIM='', no_hdr0=''),
  11767 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11767, CurrentID=0, Status='live', Symbol='Ap1m1', Aliases='AA408894, AP47, Adtm1A, Cltnm, [m]1A, mu1A', description='adaptor-related protein complex AP-1, mu subunit 1', other_designations='AP-mu chain family member mu1A|adapter-related protein complex 1 subunit mu-1|adaptor protein complex AP-1 mu-1 subunit|adaptor protein complex AP-1 subunit mu-1|adaptor-related protein complex 1 mu-1 subunit|adaptor-related protein complex 1 subunit mu-1|clathrin assembly protein complex 1 medium chain 1|clathrin assembly protein complex 1 mu-1 medium chain 1|clathrin coat assembly protein AP47|clathrin coat-associated protein AP47|golgi adaptor HA1/AP1 adaptin mu-1 subunit|mu-adaptin 1|mu1A-adaptin', map_location='8 34.92 cM', chromosome='8', genomic_nucleotide_accession_version='NC_000074.6', start_position_on_the_genomic_accession=72240050, end_position_on_the_genomic_accession=72257385, orientation='plus', exon_count=13, OMIM='', no_hdr0=''),
  11768 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11768, CurrentID=0, Status='live', Symbol='Ap1m2', Aliases='D9Ertd818e, [m]1B, mu1B', description='adaptor protein complex AP-1, mu 2 subunit', other_designations='AP-mu chain family member mu1B|adaptor protein complex AP-1 mu-2 subunit|adaptor protein complex AP-1 subunit mu-2|adaptor-related protein complex 1 mu-2 subunit|adaptor-related protein complex 1 subunit mu-2|adaptor-related protein complex AP-1, mu 2 subunit|clathrin assembly protein complex 1 medium chain 2|clathrin assembly protein complex 1 mu-2 medium chain 2|golgi adaptor HA1/AP1 adaptin mu-2 subunit|mu-adaptin 2|mu1B-adaptin', map_location='9 7.76 cM', chromosome='9', genomic_nucleotide_accession_version='NC_000075.6', start_position_on_the_genomic_accession=21294613, end_position_on_the_genomic_accession=21312349, orientation='minus', exon_count=11, OMIM='', no_hdr0=''),
  11769 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11769, CurrentID=0, Status='live', Symbol='Ap1s1', Aliases='AP19', description='adaptor protein complex AP-1, sigma 1', other_designations='HA1 19 kDa subunit|adapter-related protein complex 1 sigma-1A subunit|adapter-related protein complex 1 subunit sigma-1A|adaptor protein complex AP-1 sigma-1A subunit|adaptor protein complex AP-1 subunit sigma-1A|adaptor-related protein complex 1 subunit sigma-1A|adaptor-related protein complex AP-1, sigma 1|clathrin assembly protein complex 1 sigma-1A small chain|clathrin coat assembly protein AP19|golgi adaptor HA1/AP1 adaptin sigma-1A subunit|sigma 1a subunit of AP-1 clathrin|sigma-adaptin 1A|sigma1A-adaptin', map_location='5 G1', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=137034993, end_position_on_the_genomic_accession=137046060, orientation='minus', exon_count=6, OMIM='', no_hdr0=''),
  11770 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11770, CurrentID=0, Status='live', Symbol='Fabp4', Aliases='422/aP2, ALBP/Ap2, Ap2, Lbpl', description='fatty acid binding protein 4, adipocyte', other_designations='3T3-L1 lipid-binding protein|A-FABP|AFABP|ALBP|P15|P2 adipocyte protein|adipocyte lipid-binding protein|adipocyte protein aP2|adipocyte-type fatty acid-binding protein|fatty acid-binding protein 4|myelin P2 protein homolog|protein 422', map_location='3 2.56 cM', chromosome='3', genomic_nucleotide_accession_version='NC_000069.6', start_position_on_the_genomic_accession=10204342, end_position_on_the_genomic_accession=10208597, orientation='minus', exon_count=4, OMIM='', no_hdr0=''),
  11771 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11771, CurrentID=0, Status='live', Symbol='Ap2a1', Aliases='Adtaa', description='adaptor-related protein complex 2, alpha 1 subunit', other_designations='100 kDa coated vesicle protein A|adapter-related protein complex 2 alpha-1 subunit|adapter-related protein complex 2 subunit alpha-1|adaptor protein complex AP-2 subunit alpha-1|adaptor protein complex AP-2, alpha 1 subunit|adaptor-related protein complex 2 subunit alpha-1|adaptor-related protein complex AP-2, alpha 1 subunit|alpha-adaptin A|alpha1-adaptin|clathrin assembly protein complex 2 alpha-A large chain|plasma membrane adaptor HA2/AP2 adaptin alpha A subunit', map_location='7 B2', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=44900373, end_position_on_the_genomic_accession=44929490, orientation='minus', exon_count=25, OMIM='', no_hdr0=''),
  11772 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11772, CurrentID=0, Status='live', Symbol='Ap2a2', Aliases='2410074K14Rik, AF006990, AW146353, Adtab, C78001, L25', description='adaptor-related protein complex 2, alpha 2 subunit', other_designations='100 kDa coated vesicle protein C|adapter-related protein complex 2 alpha-2 subunit|adapter-related protein complex 2 subunit alpha-2|adaptor protein complex AP-2 subunit alpha-2|adaptor protein complex AP-2, alpha 2 subunit|adaptor-related protein complex 2 subunit alpha-2|adaptor-related protein complex AP-2, alpha 2 subunit|alpha-C adaptin|alpha-adaptin C|alpha2-adaptin|clathrin assembly protein complex 2 alpha-C large chain|plasma membrane adaptor HA2/AP2 adaptin alpha C subunit', map_location='7 F5', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=141562180, end_position_on_the_genomic_accession=141633011, orientation='plus', exon_count=23, OMIM='', no_hdr0=''),
  11773 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11773, CurrentID=0, Status='live', Symbol='Ap2m1', Aliases='', description='adaptor-related protein complex 2, mu 1 subunit', other_designations='AP-2 mu chain|adapter-related protein complex 2 mu subunit|adaptor protein complex AP-2 subunit mu|adaptor protein complex AP-2, mu1|adaptor-related protein complex 2 subunit mu|adaptor-related protein complex AP-2, mu1|clathrin assembly protein complex 2 medium chain|clathrin assembly protein complex 2 mu medium chain|clathrin coat assembly protein AP50|clathrin coat-associated protein AP50|clathrin-associated AP-2|mu2-adaptin|plasma membrane adaptor AP-2 50 kDa protein', map_location='16 A3', chromosome='16', genomic_nucleotide_accession_version='NC_000082.6', start_position_on_the_genomic_accession=20535480, end_position_on_the_genomic_accession=20544909, orientation='plus', exon_count=12, OMIM='', no_hdr0=''),
  11774 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11774, CurrentID=0, Status='live', Symbol='Ap3b1', Aliases='AP-3, AU015684, C78395, Hps2, beta3A, pe, pearl, rim2', description='adaptor-related protein complex 3, beta 1 subunit', other_designations='adapter-related protein complex 3 subunit beta-1|adaptor protein complex AP-3 beta-1 subunit|adaptor protein complex AP-3 subunit beta-1|adaptor-related protein complex 3 subunit beta-1|adaptor-related protein complex AP-3, beta 1 subunit|beta-3A-adaptin|beta3A-adaptin|clathrin assembly protein complex 3 beta-1 large chain|recombination induced mutation 2', map_location='13 49.22 cM', chromosome='13', genomic_nucleotide_accession_version='NC_000079.6', start_position_on_the_genomic_accession=94358952, end_position_on_the_genomic_accession=94566316, orientation='plus', exon_count=28, OMIM='', no_hdr0=''),
  11775 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11775, CurrentID=0, Status='live', Symbol='Ap3b2', Aliases='AI549966, AU042881, Naptb, [b]-NAP, beta-NAP, beta3B', description='adaptor-related protein complex 3, beta 2 subunit', other_designations='AP-3 complex beta-2 subunit|adapter-related protein complex 3 subunit beta-2|adaptor protein complex AP-3 beta-2 subunit|adaptor protein complex AP-3 subunit beta-2|adaptor-related protein complex 3 subunit beta-2|adaptor-related protein complex AP-3, beta 2 subunit|beta-3B-adaptin|beta3B-adaptin|clathrin assembly protein complex 3 beta-2 large chain', map_location='7 45.71 cM', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=81460399, end_position_on_the_genomic_accession=81494038, orientation='minus', exon_count=27, OMIM='', no_hdr0=''),
  11776 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11776, CurrentID=0, Status='live', Symbol='Ap3d1', Aliases='AA407035, Ap3d, Bolvr, mBLVR1, mh, mocha', description='adaptor-related protein complex 3, delta 1 subunit', other_designations='AP-3 complex subunit delta|adapter-related protein complex 3 subunit delta-1|adaptor-related protein complex 3 subunit delta-1|adaptor-related protein complex 3, delta subunit|adaptor-related protein complex AP-3, delta subunit|delta-adaptin', map_location='10 39.72 cM', chromosome='10', genomic_nucleotide_accession_version='NC_000076.6', start_position_on_the_genomic_accession=80706956, end_position_on_the_genomic_accession=80742282, orientation='minus', exon_count=33, OMIM='', no_hdr0=''),
  11777 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11777, CurrentID=0, Status='live', Symbol='Ap3s1', Aliases='', description='adaptor-related protein complex 3, sigma 1 subunit', other_designations='AP-3 complex sigma-3A subunit|adapter-related protein complex 3 sigma-1 subunit|adaptor-related protein complex AP-3, sigma 1 subunit|sigma-3A-adaptin|sigma-adaptin 3a', map_location='18 C', chromosome='18', genomic_nucleotide_accession_version='NC_000084.6', start_position_on_the_genomic_accession=46741876, end_position_on_the_genomic_accession=46790826, orientation='plus', exon_count=7, OMIM='', no_hdr0=''),
  11778 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11778, CurrentID=0, Status='live', Symbol='Ap3s2', Aliases='[s]3B', description='adaptor-related protein complex 3, sigma 2 subunit', other_designations='AP-3 complex sigma-3B subunit|AP-3 complex subunit sigma-3B|adapter-related protein complex 3 sigma-2 subunit|adapter-related protein complex 3 subunit sigma-2|adaptor-related protein complex 3 subunit sigma-2|adaptor-related protein complex AP-3, sigma 2 subunit|sigma 3B|sigma-3B-adaptin|sigma-adaptin 3b|sigma3B-adaptin', map_location='7 D3', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=79875325, end_position_on_the_genomic_accession=79920640, orientation='minus', exon_count=6, OMIM='', no_hdr0=''),
  11781 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11781, CurrentID=0, Status='live', Symbol='Ap4m1', Aliases='4930443L05Rik, Ap4m4', description='adaptor-related protein complex AP-4, mu 1', other_designations='AP-4 adapter complex mu subunit|AP-4 adaptor complex mu subunit|adapter-related protein complex 4 mu-1 subunit|adapter-related protein complex 4 subunit mu-1|adaptor-related protein complex 4 subunit mu-1|adaptor-related protein complex AP-4 mu4 subunit|mu subunit of AP-4|mu-ARP2|mu-adaptin-related protein 2|mu4|mu4-adaptin', map_location='5 G1', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=138172021, end_position_on_the_genomic_accession=138178687, orientation='plus', exon_count=15, OMIM='', no_hdr0=''),
  11782 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11782, CurrentID=0, Status='live', Symbol='Ap4s1', Aliases='AI314282', description='adaptor-related protein complex AP-4, sigma 1', other_designations='AP-4 adapter complex subunit sigma-1|AP-4 adaptor complex subunit sigma-1|adapter-related protein complex 4 subunit sigma-1|adaptor-related protein complex 4 subunit sigma-1|sigma-1 subunit of AP-4|sigma-4-adaptin|sigma4-adaptin', map_location='12 C1', chromosome='12', genomic_nucleotide_accession_version='NC_000078.6', start_position_on_the_genomic_accession=51689888, end_position_on_the_genomic_accession=51738939, orientation='plus', exon_count=9, OMIM='', no_hdr0=''),
  11783 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11783, CurrentID=0, Status='live', Symbol='Apaf1', Aliases='6230400I06Rik, Apaf-1l, fog, mKIAA0413, Apaf1', description='apoptotic peptidase activating factor 1', other_designations='apoptotic protease activating factor 1|forebrain overgrowth', map_location='10 C3-D1', chromosome='10', genomic_nucleotide_accession_version='NC_000076.6', start_position_on_the_genomic_accession=90989311, end_position_on_the_genomic_accession=91082743, orientation='minus', exon_count=27, OMIM='', no_hdr0=''),
  11784 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11784, CurrentID=0, Status='live', Symbol='Apba2', Aliases='X11-like, X11L, XllL, mXllL', description='amyloid beta (A4) precursor protein-binding, family A, member 2', other_designations='Mint 2|adapter protein X11beta|mint-2|neuron-specific X11L protein|neuronal Munc18-1-interacting protein 2', map_location='7 34.65 cM', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=64501706, end_position_on_the_genomic_accession=64753878, orientation='plus', exon_count=18, OMIM='', no_hdr0=''),
  11785 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11785, CurrentID=0, Status='live', Symbol='Apbb1', Aliases='Fe65, Rir', description='amyloid beta (A4) precursor protein-binding, family B, member 1', other_designations='', map_location='7 55.9 cM', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=105558465, end_position_on_the_genomic_accession=105581653, orientation='minus', exon_count=19, OMIM='', no_hdr0=''),
  11787 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11787, CurrentID=0, Status='live', Symbol='Apbb2', Aliases='2310007D03Rik, FE65L1, Rirl1, TR2L, Zfra', description='amyloid beta (A4) precursor protein-binding, family B, member 2', other_designations='zinc finger-like protein', map_location='5 C3.1', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=66298725, end_position_on_the_genomic_accession=66618817, orientation='minus', exon_count=20, OMIM='', no_hdr0=''),
  11789 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11789, CurrentID=0, Status='live', Symbol='Apc', Aliases='AI047805, AU020952, AW124434, CC1, Min, mAPC', description='adenomatosis polyposis coli', other_designations='multiple intestinal neoplasia', map_location='18 18.53 cM', chromosome='18', genomic_nucleotide_accession_version='NC_000084.6', start_position_on_the_genomic_accession=34220307, end_position_on_the_genomic_accession=34322190, orientation='plus', exon_count=19, OMIM='', no_hdr0=''),
  11790 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11790, CurrentID=0, Status='live', Symbol='Speg', Aliases='AW125581, Apeg1, BPEG, D1Bwg1450e, SPEGalpha, SPEGbeta, mKIAA1297', description='SPEG complex locus', other_designations='APEG-1|aortic preferentially expressed gene 1|aortic preferentially expressed protein 1', map_location='1 38.88 cM', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=75375297, end_position_on_the_genomic_accession=75432320, orientation='plus', exon_count=49, OMIM='', no_hdr0=''),
  11792 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11792, CurrentID=0, Status='live', Symbol='Apex1', Aliases='APE, Apex, HAP1, Ref-1', description='apurinic/apyrimidinic endonuclease 1', other_designations='AP endonuclease 1|APEN|APEX nuclease|apurinic-apyrimidinic endonuclease 1|redox factor-1', map_location='14 C3', chromosome='14', genomic_nucleotide_accession_version='NC_000080.6', start_position_on_the_genomic_accession=50924944, end_position_on_the_genomic_accession=50927188, orientation='plus', exon_count=5, OMIM='', no_hdr0=''),
  11793 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11793, CurrentID=0, Status='live', Symbol='Atg5', Aliases='2010107M05Rik, 3110067M24Rik, AW319544, Apg5ll, C88337, Paddy, Atg5', description='autophagy related 5', other_designations='autophagy-related 5', map_location='10 23.24 cM', chromosome='10', genomic_nucleotide_accession_version='NC_000076.6', start_position_on_the_genomic_accession=44268358, end_position_on_the_genomic_accession=44364299, orientation='plus', exon_count=9, OMIM='', no_hdr0=''),
  11796 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11796, CurrentID=0, Status='live', Symbol='Birc3', Aliases='AW107670, Api1, Api2, Birc2, HIAP2, IAP1, IAP2, MIAP1, MIAP2, MIHB, MIHC, RNF49, cIAP-1, cIAP-2, cIAP1, cIAP2', description='baculoviral IAP repeat-containing 3', other_designations='IAP-1|apoptosis inhibitor 1|baculoviral IAP repeat-containing 2|inhibitor of apoptosis protein 1|mIAP-1', map_location='9 A2', chromosome='9', genomic_nucleotide_accession_version='NC_000075.6', start_position_on_the_genomic_accession=7848699, end_position_on_the_genomic_accession=7873213, orientation='minus', exon_count=13, OMIM='', no_hdr0=''),
  11797 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11797, CurrentID=0, Status='live', Symbol='Birc2', Aliases='AW146227, Api1, Api2, Birc3, C330006D17Rik, HIAP1, HIAP2, IAP1, IAP2, MIAP1, MIAP2, MIHB, MIHC, RNF48, cIAP1, cIAP2, mcIAP1', description='baculoviral IAP repeat-containing 2', other_designations='IAP-2|apoptosis inhibitor 2|baculoviral IAP repeat-containing 3|inhibitor of apoptosis protein 2|mIAP-2', map_location='9 A1', chromosome='9', genomic_nucleotide_accession_version='NC_000075.6', start_position_on_the_genomic_accession=7818226, end_position_on_the_genomic_accession=7837133, orientation='minus', exon_count=8, OMIM='', no_hdr0=''),
  11798 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11798, CurrentID=0, Status='live', Symbol='Xiap', Aliases='1110015C02Rik, Aipa, Api3, Birc4, IAP3, ILP-1, MIHA', description='X-linked inhibitor of apoptosis', other_designations='IAP homolog A|X-linked IAP|baculoviral IAP repeat-containing protein 4|inhibitor of apoptosis protein 3', map_location='X A3-A5', chromosome='X', genomic_nucleotide_accession_version='NC_000086.7', start_position_on_the_genomic_accession=42060402, end_position_on_the_genomic_accession=42109664, orientation='plus', exon_count=11, OMIM='', no_hdr0=''),
  11799 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11799, CurrentID=0, Status='live', Symbol='Birc5', Aliases='AAC-11, Api4, TIAP, survivin40', description='baculoviral IAP repeat-containing 5', other_designations='apoptosis inhibitor 4|apoptosis inhibitor survivin|survivin', map_location='11 E2', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=117849237, end_position_on_the_genomic_accession=117855743, orientation='plus', exon_count=3, OMIM='', no_hdr0=''),
  11800 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11800, CurrentID=0, Status='live', Symbol='Api5', Aliases='AAC-11, AI196452, API-5', description='apoptosis inhibitor 5', other_designations='apoptosis inhibitory protein 5', map_location='2 E1', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=94411727, end_position_on_the_genomic_accession=94438181, orientation='minus', exon_count=14, OMIM='', no_hdr0=''),
  11801 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11801, CurrentID=0, Status='live', Symbol='Cd5l', Aliases='1/6, AAC-11, AI047839, Api6, CT2, Pdp, Sp-alpha', description='CD5 antigen-like', other_designations='AIM/Spalpha|CT-2|Pdp 1/6|apoptosis inhibitor 6|apoptosis inhibitor expressed by macrophages', map_location='3 F1', chromosome='3', genomic_nucleotide_accession_version='NC_000069.6', start_position_on_the_genomic_accession=87357881, end_position_on_the_genomic_accession=87371074, orientation='plus', exon_count=6, OMIM='', no_hdr0=''),
  11803 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11803, CurrentID=0, Status='live', Symbol='Aplp1', Aliases='', description='amyloid beta (A4) precursor-like protein 1', other_designations='APLP|APLP-1', map_location='7 18.32 cM', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=30434980, end_position_on_the_genomic_accession=30445582, orientation='minus', exon_count=17, OMIM='', no_hdr0=''),
  11804 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11804, CurrentID=0, Status='live', Symbol='Aplp2', Aliases='AI790698, APLP-2', description='amyloid beta (A4) precursor-like protein 2', other_designations='CDEBP|CDEI box-binding protein', map_location='9 A2-B', chromosome='9', genomic_nucleotide_accession_version='NC_000075.6', start_position_on_the_genomic_accession=31149557, end_position_on_the_genomic_accession=31211843, orientation='minus', exon_count=19, OMIM='', no_hdr0=''),
  11806 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11806, CurrentID=0, Status='live', Symbol='Apoa1', Aliases='Alp-1, Apoa-1, Brp-14, Ltw-1, Lvtw-1, Sep-1, Sep-2, Sep2, apo-AI, apoA-I', description='apolipoprotein A-I', other_designations='apolipoprotein A1', map_location='9 A2-A4', chromosome='9', genomic_nucleotide_accession_version='NC_000075.6', start_position_on_the_genomic_accession=46228630, end_position_on_the_genomic_accession=46230469, orientation='plus', exon_count=4, OMIM='', no_hdr0=''),
  11807 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11807, CurrentID=0, Status='live', Symbol='Apoa2', Aliases='Alp-2, Apo-AII, ApoA-II, ApoAII, Apoa-2, Hdl-1', description='apolipoprotein A-II', other_designations='apolipoprotein A2', map_location='1 79.22 cM', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=171225011, end_position_on_the_genomic_accession=171226379, orientation='plus', exon_count=4, OMIM='', no_hdr0=''),
  11808 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11808, CurrentID=0, Status='live', Symbol='Apoa4', Aliases='Apoa-4', description='apolipoprotein A-IV', other_designations='apo-AIV|apoA-IV|apolipoprotein A4', map_location='9 25.36 cM', chromosome='9', genomic_nucleotide_accession_version='NC_000075.6', start_position_on_the_genomic_accession=46240844, end_position_on_the_genomic_accession=46243458, orientation='plus', exon_count=3, OMIM='', no_hdr0=''),
  11810 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11810, CurrentID=0, Status='live', Symbol='Apobec1', Aliases='Cdar1', description='apolipoprotein B mRNA editing enzyme, catalytic polypeptide 1', other_designations='apolipoprotein B editing complex 1|mRNA(cytosine(6666)) deaminase 1', map_location='6 57.68 cM', chromosome='6', genomic_nucleotide_accession_version='NC_000072.6', start_position_on_the_genomic_accession=122577792, end_position_on_the_genomic_accession=122603041, orientation='minus', exon_count=10, OMIM='', no_hdr0=''),
  11811 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11811, CurrentID=0, Status='live', Symbol='Apobec2', Aliases='Arp1', description='apolipoprotein B mRNA editing enzyme, catalytic polypeptide 2', other_designations='apolipoprotein B editing complex 2|mRNA(cytosine(6666)) deaminase 2|probable C->U-editing enzyme APOBEC-2', map_location='17 24.02 cM', chromosome='17', genomic_nucleotide_accession_version='NC_000083.6', start_position_on_the_genomic_accession=48419231, end_position_on_the_genomic_accession=48432728, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  11812 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11812, CurrentID=0, Status='live', Symbol='Apoc1', Aliases='Apo-CIB, ApoC-IB, apo-CI, apoC-I', description='apolipoprotein C-I', other_designations='apolipoprotein C1', map_location='7 9.94 cM', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=19689480, end_position_on_the_genomic_accession=19692659, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  11813 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11813, CurrentID=0, Status='live', Symbol='Apoc2', Aliases='apo-CII, apoC-II', description='apolipoprotein C-II', other_designations='apolipoprotein C2', map_location='7 9.94 cM', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=19671579, end_position_on_the_genomic_accession=19677941, orientation='minus', exon_count=5, OMIM='', no_hdr0=''),
  11814 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11814, CurrentID=0, Status='live', Symbol='Apoc3', Aliases='apo-CIII, apoC-III', description='apolipoprotein C-III', other_designations='apolipoprotein C3', map_location='9 25.36 cM', chromosome='9', genomic_nucleotide_accession_version='NC_000075.6', start_position_on_the_genomic_accession=46233050, end_position_on_the_genomic_accession=46235636, orientation='minus', exon_count=5, OMIM='', no_hdr0=''),
  11815 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11815, CurrentID=0, Status='live', Symbol='Apod', Aliases='', description='apolipoprotein D', other_designations='', map_location='16 21.41 cM', chromosome='16', genomic_nucleotide_accession_version='NC_000082.6', start_position_on_the_genomic_accession=31296192, end_position_on_the_genomic_accession=31314808, orientation='minus', exon_count=6, OMIM='', no_hdr0=''),
  11816 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11816, CurrentID=0, Status='live', Symbol='Apoe', Aliases='AI255918, Apo-E', description='apolipoprotein E', other_designations='', map_location='7 9.94 cM', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=19696244, end_position_on_the_genomic_accession=19699166, orientation='minus', exon_count=4, OMIM='', no_hdr0=''),
  11818 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11818, CurrentID=0, Status='live', Symbol='Apoh', Aliases='B2GPI, beta-2-GPI, beta2-GPI', description='apolipoprotein H', other_designations='APC inhibitor|activated protein C-binding protein|apo-H|beta(2)GPI|beta-2-glycoprotein I', map_location='11 D', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=108395297, end_position_on_the_genomic_accession=108414396, orientation='plus', exon_count=8, OMIM='', no_hdr0=''),
  11819 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11819, CurrentID=0, Status='live', Symbol='Nr2f2', Aliases='2700033K02Rik, 9430015G03Rik, ARP-1, Aporp1, COUP-TF2, COUP-TFII, COUPTFB, EAR3, SVP40, Tcfcoup2', description='nuclear receptor subfamily 2, group F, member 2', other_designations='COUP transcription factor II|COUP-TF II|apolipoprotein AI regulatory protein 1|apolipoprotein regulatory protein 1', map_location='7 38.66 cM', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=70351946, end_position_on_the_genomic_accession=70366746, orientation='minus', exon_count=5, OMIM='', no_hdr0=''),
  11820 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11820, CurrentID=0, Status='live', Symbol='App', Aliases='Abeta, Abpp, Adap, Ag, Cvap, E030013M08Rik, betaApp', description='amyloid beta (A4) precursor protein', other_designations='alzheimer disease amyloid A4 protein homolog|amyloidogenic glycoprotein|appican|protease nexin II', map_location='16 C3-qter', chromosome='16', genomic_nucleotide_accession_version='NC_000082.6', start_position_on_the_genomic_accession=84954436, end_position_on_the_genomic_accession=85173952, orientation='minus', exon_count=19, OMIM='', no_hdr0=''),
  11821 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11821, CurrentID=0, Status='live', Symbol='Aprt', Aliases='C85684', description='adenine phosphoribosyl transferase', other_designations='', map_location='8 71.91 cM', chromosome='8', genomic_nucleotide_accession_version='NC_000074.6', start_position_on_the_genomic_accession=122574637, end_position_on_the_genomic_accession=122576907, orientation='minus', exon_count=5, OMIM='', no_hdr0=''),
  11826 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11826, CurrentID=0, Status='live', Symbol='Aqp1', Aliases='CHIP28', description='aquaporin 1', other_designations='AQP-1|DER2|aquaporin-CHIP|delayed early response protein 2|growth factor-induced delayed early response protein|water channel protein for red blood cells and kidney proximal tubule', map_location='6 27.38 cM', chromosome='6', genomic_nucleotide_accession_version='NC_000072.6', start_position_on_the_genomic_accession=55336299, end_position_on_the_genomic_accession=55348555, orientation='plus', exon_count=4, OMIM='', no_hdr0=''),
  11827 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11827, CurrentID=0, Status='live', Symbol='Aqp2', Aliases='AQP-CD, WCH-CD, cph, jpk', description='aquaporin 2', other_designations='ADH water channel|AQP-2|aquaporin-CD|collecting duct water channel protein|water channel protein for renal collecting duct', map_location='15 56.13 cM', chromosome='15', genomic_nucleotide_accession_version='NC_000081.6', start_position_on_the_genomic_accession=99579056, end_position_on_the_genomic_accession=99584545, orientation='plus', exon_count=4, OMIM='', no_hdr0=''),
  11828 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11828, CurrentID=0, Status='live', Symbol='Aqp3', Aliases='AQP-2', description='aquaporin 3', other_designations='AQP-3|aquaglyceroporin-3', map_location='4 B1', chromosome='4', genomic_nucleotide_accession_version='NC_000070.6', start_position_on_the_genomic_accession=41092724, end_position_on_the_genomic_accession=41098183, orientation='minus', exon_count=6, OMIM='', no_hdr0=''),
  11829 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11829, CurrentID=0, Status='live', Symbol='Aqp4', Aliases='WCH4', description='aquaporin 4', other_designations='mercurial-insensitive water channel', map_location='18 8.74 cM', chromosome='18', genomic_nucleotide_accession_version='NC_000084.6', start_position_on_the_genomic_accession=15389394, end_position_on_the_genomic_accession=15410977, orientation='minus', exon_count=10, OMIM='', no_hdr0=''),
  11830 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11830, CurrentID=0, Status='live', Symbol='Aqp5', Aliases='', description='aquaporin 5', other_designations='AQP-5', map_location='15 56.13 cM', chromosome='15', genomic_nucleotide_accession_version='NC_000081.6', start_position_on_the_genomic_accession=99591028, end_position_on_the_genomic_accession=99594829, orientation='plus', exon_count=4, OMIM='', no_hdr0=''),
  11831 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11831, CurrentID=0, Status='live', Symbol='Aqp6', Aliases='AI790337', description='aquaporin 6', other_designations='AQP-6', map_location='15 56.13 cM', chromosome='15', genomic_nucleotide_accession_version='NC_000081.6', start_position_on_the_genomic_accession=99599053, end_position_on_the_genomic_accession=99605477, orientation='plus', exon_count=5, OMIM='', no_hdr0=''),
  11832 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11832, CurrentID=0, Status='live', Symbol='Aqp7', Aliases='AQP7L, AQPap', description='aquaporin 7', other_designations='AQP-7|aquaglyceroporin-7', map_location='4 B1', chromosome='4', genomic_nucleotide_accession_version='NC_000070.6', start_position_on_the_genomic_accession=41033074, end_position_on_the_genomic_accession=41048215, orientation='minus', exon_count=9, OMIM='', no_hdr0=''),
  11833 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11833, CurrentID=0, Status='live', Symbol='Aqp8', Aliases='AI255744, AQP-8', description='aquaporin 8', other_designations='', map_location='7 F3', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=123462294, end_position_on_the_genomic_accession=123468003, orientation='plus', exon_count=6, OMIM='', no_hdr0=''),
  11834 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11834, CurrentID=0, Status='live', Symbol='Aqr', Aliases='AW495846, mKIAA0560', description='aquarius', other_designations='', map_location='2 E5-F2', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=114101161, end_position_on_the_genomic_accession=114175339, orientation='minus', exon_count=36, OMIM='', no_hdr0=''),
  11835 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11835, CurrentID=0, Status='live', Symbol='Ar', Aliases='AW320017, Tfm', description='androgen receptor', other_designations='dihydrotestosterone receptor|nuclear receptor subfamily 3 group C member 4|testicular feminization', map_location='X 42.82 cM', chromosome='X', genomic_nucleotide_accession_version='NC_000086.7', start_position_on_the_genomic_accession=98149750, end_position_on_the_genomic_accession=98317147, orientation='plus', exon_count=8, OMIM='', no_hdr0=''),
  11836 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11836, CurrentID=0, Status='live', Symbol='Araf', Aliases='1200013E08Rik, A-Raf, AW4954441, Araf', description='Araf proto-oncogene, serine/threonine kinase', other_designations='A-Raf proto-oncogene serine/threonine-protein kinase|proto-oncogene A-Raf|raf-related oncogene|v-raf murine sarcoma 3611 viral oncogene homolog 1', map_location='X A2-A3.1', chromosome='X', genomic_nucleotide_accession_version='NC_000086.7', start_position_on_the_genomic_accession=20797787, end_position_on_the_genomic_accession=20860521, orientation='plus', exon_count=17, OMIM='', no_hdr0=''),
  11837 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11837, CurrentID=0, Status='live', Symbol='Rplp0', Aliases='36B4, Arbp, L10E', description='ribosomal protein, large, P0', other_designations='60S ribosomal protein L10E|acidic ribosomal phosphoprotein P0', map_location='5 F', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=115559467, end_position_on_the_genomic_accession=115563729, orientation='plus', exon_count=7, OMIM='', no_hdr0=''),
  11838 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11838, CurrentID=0, Status='live', Symbol='Arc', Aliases='Arc3.1, C86064, arg3.1, mArc', description='activity regulated cytoskeletal-associated protein', other_designations='ARC/ARG3.1|activity-regulated gene 3.1 protein homolog|arc', map_location='15 34.25 cM', chromosome='15', genomic_nucleotide_accession_version='NC_000081.6', start_position_on_the_genomic_accession=74669081, end_position_on_the_genomic_accession=74672570, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  11839 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11839, CurrentID=0, Status='live', Symbol='Areg', Aliases='AR, Mcub, Sdgf', description='amphiregulin', other_designations='schwannoma-derived growth factor', map_location='5 44.78 cM', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=91139615, end_position_on_the_genomic_accession=91148432, orientation='plus', exon_count=6, OMIM='', no_hdr0=''),
  11840 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11840, CurrentID=0, Status='live', Symbol='Arf1', Aliases='', description='ADP-ribosylation factor 1', other_designations='', map_location='11 B2', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=59211411, end_position_on_the_genomic_accession=59228267, orientation='minus', exon_count=7, OMIM='', no_hdr0=''),
  11841 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11841, CurrentID=0, Status='live', Symbol='Arf2', Aliases='', description='ADP-ribosylation factor 2', other_designations='', map_location='11 67.64 cM', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=103966718, end_position_on_the_genomic_accession=103985337, orientation='plus', exon_count=6, OMIM='', no_hdr0=''),
  11842 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11842, CurrentID=0, Status='live', Symbol='Arf3', Aliases='5430400P17Rik, AI854770', description='ADP-ribosylation factor 3', other_designations='', map_location='15 F2', chromosome='15', genomic_nucleotide_accession_version='NC_000081.6', start_position_on_the_genomic_accession=98737624, end_position_on_the_genomic_accession=98763118, orientation='minus', exon_count=5, OMIM='', no_hdr0=''),
  11843 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11843, CurrentID=0, Status='live', Symbol='Arf4', Aliases='AA407803', description='ADP-ribosylation factor 4', other_designations='', map_location='14 16.09 cM', chromosome='14', genomic_nucleotide_accession_version='NC_000080.6', start_position_on_the_genomic_accession=26638197, end_position_on_the_genomic_accession=26657258, orientation='plus', exon_count=6, OMIM='', no_hdr0=''),
  11844 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11844, CurrentID=0, Status='live', Symbol='Arf5', Aliases='', description='ADP-ribosylation factor 5', other_designations='', map_location='6 A3.3', chromosome='6', genomic_nucleotide_accession_version='NC_000072.6', start_position_on_the_genomic_accession=28423640, end_position_on_the_genomic_accession=28426499, orientation='plus', exon_count=6, OMIM='', no_hdr0=''),
  11845 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11845, CurrentID=0, Status='live', Symbol='Arf6', Aliases='AI788669, AW496366', description='ADP-ribosylation factor 6', other_designations='', map_location='12 C2', chromosome='12', genomic_nucleotide_accession_version='NC_000078.6', start_position_on_the_genomic_accession=69372150, end_position_on_the_genomic_accession=69375980, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  11846 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11846, CurrentID=0, Status='live', Symbol='Arg1', Aliases='AI, AI256583, Arg-1, PGIF', description='arginase, liver', other_designations='arginase 1, liver|arginase I|liver-type arginase|type I arginase', map_location='10 A4', chromosome='10', genomic_nucleotide_accession_version='NC_000076.6', start_position_on_the_genomic_accession=24915207, end_position_on_the_genomic_accession=24927470, orientation='minus', exon_count=8, OMIM='', no_hdr0=''),
  11847 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11847, CurrentID=0, Status='live', Symbol='Arg2', Aliases='AII, AU022422', description='arginase type II', other_designations='kidney-type arginase|non-hepatic arginase|type II arginase', map_location='12 C3', chromosome='12', genomic_nucleotide_accession_version='NC_000078.6', start_position_on_the_genomic_accession=79130788, end_position_on_the_genomic_accession=79156301, orientation='plus', exon_count=8, OMIM='', no_hdr0=''),
  11848 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11848, CurrentID=0, Status='live', Symbol='Rhoa', Aliases='Arha, Arha1, Arha2', description='ras homolog gene family, member A', other_designations='aplysia ras-related homolog A', map_location='9 F2', chromosome='9', genomic_nucleotide_accession_version='NC_000075.6', start_position_on_the_genomic_accession=108306205, end_position_on_the_genomic_accession=108337939, orientation='plus', exon_count=7, OMIM='', no_hdr0=''),
  11852 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11852, CurrentID=0, Status='live', Symbol='Rhob', Aliases='AA017882, Arh6, Arhb', description='ras homolog gene family, member B', other_designations='aplysia ras-related homolog B|ras homolog B|ras homolog gene family, member AB', map_location='12 A1.1', chromosome='12', genomic_nucleotide_accession_version='NC_000078.6', start_position_on_the_genomic_accession=8497758, end_position_on_the_genomic_accession=8499985, orientation='minus', exon_count=1, OMIM='', no_hdr0=''),
  11853 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11853, CurrentID=0, Status='live', Symbol='Rhoc', Aliases='AI324259, Arh9, Arhc', description='ras homolog gene family, member C', other_designations='SIG-61|aplysia ras-related homolog 9 (RhoC)|ras homolog 9 (RhoC)|silica-induced gene 61 protein', map_location='3 F2.2', chromosome='3', genomic_nucleotide_accession_version='NC_000069.6', start_position_on_the_genomic_accession=104789034, end_position_on_the_genomic_accession=104794459, orientation='plus', exon_count=5, OMIM='', no_hdr0=''),
  11854 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11854, CurrentID=0, Status='live', Symbol='Rhod', Aliases='AI326383, Arhd, Rho, RhoHP1, RhoM', description='ras homolog gene family, member D', other_designations='aplysia ras-related homolog D|ras homolog D (RhoD)', map_location='19 A', chromosome='19', genomic_nucleotide_accession_version='NC_000085.6', start_position_on_the_genomic_accession=4425457, end_position_on_the_genomic_accession=4439432, orientation='minus', exon_count=5, OMIM='', no_hdr0=''),
  11855 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11855, CurrentID=0, Status='live', Symbol='Arhgap5', Aliases='p190-B, p190B', description='Rho GTPase activating protein 5', other_designations='rho-type GTPase-activating protein 5', map_location='12 22.16 cM', chromosome='12', genomic_nucleotide_accession_version='NC_000078.6', start_position_on_the_genomic_accession=52503771, end_position_on_the_genomic_accession=52571978, orientation='plus', exon_count=8, OMIM='', no_hdr0=''),
  11856 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11856, CurrentID=0, Status='live', Symbol='Arhgap6', Aliases='AI504284, RhoGAPX-1', description='Rho GTPase activating protein 6', other_designations='rho-type GTPase-activating protein 6|rho-type GTPase-activating protein RhoGAPX-1', map_location='X F5', chromosome='X', genomic_nucleotide_accession_version='NC_000086.7', start_position_on_the_genomic_accession=168795094, end_position_on_the_genomic_accession=169304440, orientation='plus', exon_count=16, OMIM='', no_hdr0=''),
  11857 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11857, CurrentID=0, Status='live', Symbol='Arhgdib', Aliases='D4, Gdid4, Ly-GDI', description='Rho, GDP dissociation inhibitor (GDI) beta', other_designations='rho GDI 2|rho-GDI beta', map_location='6 G1', chromosome='6', genomic_nucleotide_accession_version='NC_000072.6', start_position_on_the_genomic_accession=136923655, end_position_on_the_genomic_accession=136941899, orientation='minus', exon_count=9, OMIM='', no_hdr0=''),
  11858 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11858, CurrentID=0, Status='live', Symbol='Rnd2', Aliases='Arhn, Rohn', description='Rho family GTPase 2', other_designations='aplysia ras-related homolog N (RhoN)|ras homolog N (RhoN)|ras homolog gene family, member N|rho-related GTP-binding protein Rho7|rho7', map_location='11 C-D', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=101468338, end_position_on_the_genomic_accession=101471306, orientation='plus', exon_count=5, OMIM='', no_hdr0=''),
  11859 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11859, CurrentID=0, Status='live', Symbol='Phox2a', Aliases='Arix, Phox2, Pmx2, Pmx2a', description='paired-like homeobox 2a', other_designations='PHOX2A homeodomain protein|aristaless homeobox gene homolog|aristaless homeobox protein homolog|paired mesoderm homeobox 2a', map_location='7 54.66 cM', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=101818313, end_position_on_the_genomic_accession=101822726, orientation='plus', exon_count=3, OMIM='', no_hdr0=''),
  11861 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11861, CurrentID=0, Status='live', Symbol='Arl4a', Aliases='AI467555, Arl4', description='ADP-ribosylation factor-like 4A', other_designations='ADP-ribosylation factor-like 4|ADP-ribosylation-like 4', map_location='12 18.06 cM', chromosome='12', genomic_nucleotide_accession_version='NC_000078.6', start_position_on_the_genomic_accession=40033291, end_position_on_the_genomic_accession=40037987, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  11863 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11863, CurrentID=0, Status='live', Symbol='Arnt', Aliases='D3Ertd557e, Drnt, ESTM42, Hif1b, W08714, bHLHe2, mKIAA4051', description='aryl hydrocarbon receptor nuclear translocator', other_designations='HIF-1-beta|HIF1-beta|dioxin receptor, nuclear translocator|hypoxia-inducible factor 1-beta', map_location='3 40.74 cM', chromosome='3', genomic_nucleotide_accession_version='NC_000069.6', start_position_on_the_genomic_accession=95434368, end_position_on_the_genomic_accession=95497240, orientation='plus', exon_count=23, OMIM='', no_hdr0=''),
  11864 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11864, CurrentID=0, Status='live', Symbol='Arnt2', Aliases='Hif-2b, bHLHe1, mKIAA0307', description='aryl hydrocarbon receptor nuclear translocator 2', other_designations='ARNT protein 2', map_location='7 48.35 cM', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=84246274, end_position_on_the_genomic_accession=84410171, orientation='minus', exon_count=22, OMIM='', no_hdr0=''),
  11865 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11865, CurrentID=0, Status='live', Symbol='Arntl', Aliases="Arnt3, BMAL1b, Bmal1, MOP3, bHLHe5, bmal1b'", description='aryl hydrocarbon receptor nuclear translocator-like', other_designations='brain and muscle ARNT-like 1', map_location='7 F2-F3', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=113178473, end_position_on_the_genomic_accession=113314126, orientation='plus', exon_count=24, OMIM='', no_hdr0=''),
  11867 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11867, CurrentID=0, Status='live', Symbol='Arpc1b', Aliases='41kDa, AA408064, AA408534, AA571392, AF007010, AW208418, L72, SOP2Hs, p41-ARC', description='actin related protein 2/3 complex, subunit 1B', other_designations='arp2/3 complex 41 kDa subunit', map_location='5 G2', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=145114256, end_position_on_the_genomic_accession=145128186, orientation='plus', exon_count=10, OMIM='', no_hdr0=''),
  11870 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11870, CurrentID=0, Status='live', Symbol='Art1', Aliases='ADPRT, ARTC1, Yac-1', description='ADP-ribosyltransferase 1', other_designations='ADP-ribosyltransferase C2 and C3 toxin-like 1|mono(ADP-ribosyl)transferase 1', map_location='7 54.71 cM', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=102101706, end_position_on_the_genomic_accession=102111758, orientation='plus', exon_count=6, OMIM='', no_hdr0=''),
  11871 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11871, CurrentID=0, Status='live', Symbol='Art2a-ps', Aliases='ARTC2, Art2a, Ly92a, Rt-6, Rt6, Rt6-1', description='ADP-ribosyltransferase 2a, pseudogene', other_designations='ADP-ribosyltransferase 2a pseudogene|ADP-ribosyltransferase C2 and C3 toxin-like 2|T-cell NAD(P)(+)--arginine ADP-ribosyltransferase 1|T-cell differentiation marker Rt6 homolog 1|T-cell mono(ADP-ribosyl)transferase 1|mono(ADP-ribosyl)transferase 2A', map_location='7 54.6 cM', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=101552453, end_position_on_the_genomic_accession=101560865, orientation='minus', exon_count=4, OMIM='', no_hdr0=''),
  11872 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11872, CurrentID=0, Status='live', Symbol='Art2b', Aliases='ART2.2, ARTC2, Art, Ly92b, Rt-6, Rt6, Rt6-2', description='ADP-ribosyltransferase 2b', other_designations='ADP-ribosyltransferase C2 and C3 toxin-like 2|T-cell NAD(P)(+)--arginine ADP-ribosyltransferase 2|T-cell differentiation marker Rt6 homolog 2|T-cell mono(ADP-ribosyl)transferase 2|mono(ADP-ribosyl)transferase 2B', map_location='7 54.61 cM', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=101575729, end_position_on_the_genomic_accession=101585583, orientation='minus', exon_count=4, OMIM='', no_hdr0=''),
  11875 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11875, CurrentID=0, Status='live', Symbol='Art5', Aliases='ARTC5, Yac-2', description='ADP-ribosyltransferase 5', other_designations='ADP-ribosyltransferase C2 and C3 toxin-like 5|NAD(P)(+)--arginine ADP-ribosyltransferase 5|mono(ADP-ribosyl)transferase 5', map_location='7 54.71 cM', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=102096879, end_position_on_the_genomic_accession=102100306, orientation='minus', exon_count=6, OMIM='', no_hdr0=''),
  11876 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11876, CurrentID=0, Status='live', Symbol='Artn', Aliases='neublastin', description='artemin', other_designations='', map_location='4 D1', chromosome='4', genomic_nucleotide_accession_version='NC_000070.6', start_position_on_the_genomic_accession=117926160, end_position_on_the_genomic_accession=117930791, orientation='minus', exon_count=5, OMIM='', no_hdr0=''),
  11877 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11877, CurrentID=0, Status='live', Symbol='Arvcf', Aliases='', description='armadillo repeat gene deleted in velo-cardio-facial syndrome', other_designations='', map_location='16 11.37 cM', chromosome='16', genomic_nucleotide_accession_version='NC_000082.6', start_position_on_the_genomic_accession=18348182, end_position_on_the_genomic_accession=18407076, orientation='plus', exon_count=21, OMIM='', no_hdr0=''),
  11878 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11878, CurrentID=0, Status='live', Symbol='Arx', Aliases='', description='aristaless related homeobox', other_designations='aristaless-related homeobox', map_location='X 41.05 cM', chromosome='X', genomic_nucleotide_accession_version='NC_000086.7', start_position_on_the_genomic_accession=93286450, end_position_on_the_genomic_accession=93298357, orientation='plus', exon_count=6, OMIM='', no_hdr0=''),
  11881 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11881, CurrentID=0, Status='live', Symbol='Arsb', Aliases='1110007C02Rik, AI480648, As-1, As-1r, As-1s, As-1t, As1, As1-r, As1-s, As1-t, Asr-1, Ast-1', description='arylsulfatase B', other_designations='ASB|G4S|N-acetylgalactosamine-4-sulfatase|arylsulfatase B complex|arylsulfatase B regulation|arylsulfatase B structural|arylsulfatase B temporal regulation', map_location='13 47.88 cM', chromosome='13', genomic_nucleotide_accession_version='NC_000079.6', start_position_on_the_genomic_accession=93771023, end_position_on_the_genomic_accession=93943016, orientation='plus', exon_count=10, OMIM='', no_hdr0=''),
  11883 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11883, CurrentID=0, Status='live', Symbol='Arsa', Aliases='AS-A, ASA, AW212749, As-2, As2, TISP73', description='arylsulfatase A', other_designations='cerebroside-sulfatase', map_location='15 E', chromosome='15', genomic_nucleotide_accession_version='NC_000081.6', start_position_on_the_genomic_accession=89472476, end_position_on_the_genomic_accession=89477424, orientation='minus', exon_count=8, OMIM='', no_hdr0=''),
  11885 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11885, CurrentID=0, Status='live', Symbol='asa', Aliases='', description='anti-sarcolemmal autoantibodies', other_designations='', map_location='', chromosome='14', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  11886 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11886, CurrentID=0, Status='live', Symbol='Asah1', Aliases='2310081N20Rik, AC, Asah', description='N-acylsphingosine amidohydrolase 1', other_designations='ACDase|acid CDase|acylsphingosine deacylase', map_location='8 A4', chromosome='8', genomic_nucleotide_accession_version='NC_000074.6', start_position_on_the_genomic_accession=41340643, end_position_on_the_genomic_accession=41374697, orientation='minus', exon_count=14, OMIM='', no_hdr0=''),
  11889 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11889, CurrentID=0, Status='live', Symbol='Asgr1', Aliases='ASGPR1, Asgr, Asgr-1, HL-1', description='asialoglycoprotein receptor 1', other_designations='ASGP-R 1|ASGPR 1|hepatic lectin 1', map_location='11 42.98 cM', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=70054124, end_position_on_the_genomic_accession=70057895, orientation='plus', exon_count=10, OMIM='', no_hdr0=''),
  11890 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11890, CurrentID=0, Status='live', Symbol='Asgr2', Aliases='ASGPR2, Asgr, Asgr-2, HL-2', description='asialoglycoprotein receptor 2', other_designations='hepatic lectin 2', map_location='11 42.99 cM', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=70092307, end_position_on_the_genomic_accession=70106187, orientation='plus', exon_count=9, OMIM='', no_hdr0=''),
  11891 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11891, CurrentID=0, Status='live', Symbol='Rab27a', Aliases='2210402C08Rik, 2410003M20Rik, 4933437C11Rik, ash', description='RAB27A, member RAS oncogene family', other_designations='ashen', map_location='9 40.08 cM', chromosome='9', genomic_nucleotide_accession_version='NC_000075.6', start_position_on_the_genomic_accession=73044810, end_position_on_the_genomic_accession=73097623, orientation='plus', exon_count=9, OMIM='', no_hdr0=''),
  11893 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11893, CurrentID=0, Status='live', Symbol='asp1', Aliases='Ias, asp-1', description='audiogenic seizure prone 1', other_designations='', map_location='', chromosome='12', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  11894 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11894, CurrentID=0, Status='live', Symbol='asp2', Aliases='asp, asp-2', description='audiogenic seizure prone 2', other_designations='', map_location='', chromosome='4', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  667256 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=667256, CurrentID=0, Status='live', Symbol='4921511M17Rik', Aliases='', description='RIKEN cDNA 4921511M17 gene', other_designations='', map_location='X F3', chromosome='X', genomic_nucleotide_accession_version='NC_000086.7', start_position_on_the_genomic_accession=154022780, end_position_on_the_genomic_accession=154033830, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  11898 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11898, CurrentID=0, Status='live', Symbol='Ass1', Aliases='AA408052, ASS, Ass-1, fold', description='argininosuccinate synthetase 1', other_designations='arginosuccinate synthetase 1|citrulline--aspartate ligase', map_location='2 21.81 cM', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=31470270, end_position_on_the_genomic_accession=31520670, orientation='plus', exon_count=16, OMIM='', no_hdr0=''),
  11899 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11899, CurrentID=0, Status='live', Symbol='Astn1', Aliases='Astn, GC14, mKIAA0289', description='astrotactin 1', other_designations='neuronal migration protein GC14', map_location='1 H1', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=158362102, end_position_on_the_genomic_accession=158691786, orientation='plus', exon_count=25, OMIM='', no_hdr0=''),
  11904 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11904, CurrentID=0, Status='live', Symbol='at', Aliases='', description='atrichosis', other_designations='', map_location='', chromosome='10', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  11905 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11905, CurrentID=0, Status='live', Symbol='Serpinc1', Aliases='AI114908, ATIII, At-3, At3', description='serine (or cysteine) peptidase inhibitor, clade C (antithrombin), member 1', other_designations='anti-thrombin 3|antithrombin|serine (or cysteine) proteinase inhibitor, clade C (antithrombin), member 1|serpin C1|serpin peptidase inhibitor, clade C, member 1', map_location='1 69.75 cM', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=160978606, end_position_on_the_genomic_accession=161003015, orientation='plus', exon_count=9, OMIM='', no_hdr0=''),
  11906 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11906, CurrentID=0, Status='live', Symbol='Zfhx3', Aliases='A230102L03Rik, Atbf1, Sci, WBP9, mKIAA4228', description='zinc finger homeobox 3', other_designations='AT motif binding factor 1|AT motif-binding factor 1|AT-binding transcription factor 1|ZFH-3|alpha-fetoprotein enhancer-binding protein|zinc finger homeodomain protein 3', map_location='8 E1', chromosome='8', genomic_nucleotide_accession_version='NC_000074.6', start_position_on_the_genomic_accession=108704034, end_position_on_the_genomic_accession=108961636, orientation='plus', exon_count=12, OMIM='', no_hdr0=''),
  11907 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11907, CurrentID=0, Status='live', Symbol='Ate1', Aliases='AI225793, AW547406', description='arginyltransferase 1', other_designations='R-transferase 1|arginine-tRNA--protein transferase 1|arginine-tRNA-protein transferase 1', map_location='7 F3', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=130391493, end_position_on_the_genomic_accession=130520371, orientation='minus', exon_count=16, OMIM='', no_hdr0=''),
  11908 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11908, CurrentID=0, Status='live', Symbol='Atf1', Aliases='', description='activating transcription factor 1', other_designations='TCR-ATF1|cAMP-dependent transcription factor ATF-1', map_location='15 F3', chromosome='15', genomic_nucleotide_accession_version='NC_000081.6', start_position_on_the_genomic_accession=100227859, end_position_on_the_genomic_accession=100261248, orientation='plus', exon_count=9, OMIM='', no_hdr0=''),
  11909 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11909, CurrentID=0, Status='live', Symbol='Atf2', Aliases='Atf-2, CRE-BP, Creb2, D130078H02Rik, D18875, Tg(Gzma-Klra1)7Wum, mXBP', description='activating transcription factor 2', other_designations='cAMP response element-binding protein CRE-BP1|cAMP-dependent transcription factor ATF-2', map_location='2 C3', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=73816509, end_position_on_the_genomic_accession=73892639, orientation='minus', exon_count=19, OMIM='', no_hdr0=''),
  11910 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11910, CurrentID=0, Status='live', Symbol='Atf3', Aliases='LRG-21', description='activating transcription factor 3', other_designations='cAMP-dependent transcription factor ATF-3|transcription factor LRG-21', map_location='1 96.28 cM', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=191170296, end_position_on_the_genomic_accession=191183333, orientation='minus', exon_count=4, OMIM='', no_hdr0=''),
  11911 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11911, CurrentID=0, Status='live', Symbol='Atf4', Aliases='Atf-4, C/ATF, CREB2, TAXREB67', description='activating transcription factor 4', other_designations='c/EBP-related ATF|cAMP-dependent transcription factor ATF-4|tax-responsive enhancer element-binding protein 67 homolog|taxREB67 homolog', map_location='15 37.85 cM', chromosome='15', genomic_nucleotide_accession_version='NC_000081.6', start_position_on_the_genomic_accession=80255184, end_position_on_the_genomic_accession=80257545, orientation='plus', exon_count=4, OMIM='', no_hdr0=''),
  667277 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=667277, CurrentID=0, Status='live', Symbol='C1rb', Aliases='Gm8551, mC1rB', description='complement component 1, r subcomponent B', other_designations='complement component 1 subcomponent r-B|complement component 1, r-B subcomponent|complement component C1rb', map_location='6', chromosome='6', genomic_nucleotide_accession_version='NC_000072.6', start_position_on_the_genomic_accession=124570430, end_position_on_the_genomic_accession=124581044, orientation='plus', exon_count=11, OMIM='', no_hdr0=''),
  11920 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11920, CurrentID=0, Status='live', Symbol='Atm', Aliases='AI256621, C030026E19Rik', description='ataxia telangiectasia mutated', other_designations='A-T mutated homolog|ataxia telangiectasia gene mutated in human beings|ataxia telangiectasia mutated homolog', map_location='9 C-D', chromosome='9', genomic_nucleotide_accession_version='NC_000075.6', start_position_on_the_genomic_accession=53437122, end_position_on_the_genomic_accession=53536816, orientation='minus', exon_count=64, OMIM='', no_hdr0=''),
  11921 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11921, CurrentID=0, Status='live', Symbol='Atoh1', Aliases='Hath1, MATH-1, Math1, bHLHa14', description='atonal bHLH transcription factor 1', other_designations='atonal homolog 1|helix-loop-helix protein mATH-1', map_location='6 30.03 cM', chromosome='6', genomic_nucleotide_accession_version='NC_000072.6', start_position_on_the_genomic_accession=64729146, end_position_on_the_genomic_accession=64731243, orientation='plus', exon_count=1, OMIM='', no_hdr0=''),
  11922 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11922, CurrentID=0, Status='live', Symbol='Neurod6', Aliases='Atoh2, Math-2, Math2, Nex, Nex1m, bHLHa2', description='neurogenic differentiation 6', other_designations='atonal homolog 2|helix-loop-helix protein mATH-2|protein NEX-1|protein atonal homolog 2', map_location='6 27.53 cM', chromosome='6', genomic_nucleotide_accession_version='NC_000072.6', start_position_on_the_genomic_accession=55677818, end_position_on_the_genomic_accession=55681263, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  11923 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11923, CurrentID=0, Status='live', Symbol='Neurod4', Aliases='AI846749, ATH-3, Atoh3, MATH-3, Math3, bHLHa4', description='neurogenic differentiation 4', other_designations='atonal homolog 3|helix-loop-helix protein mATH-3|protein atonal homolog 3', map_location='10 77.81 cM', chromosome='10', genomic_nucleotide_accession_version='NC_000076.6', start_position_on_the_genomic_accession=130268152, end_position_on_the_genomic_accession=130280240, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  11924 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11924, CurrentID=0, Status='live', Symbol='Neurog2', Aliases='Atoh4, Math4A, bHLHa8, ngn-2, ngn2', description='neurogenin 2', other_designations='atonal homolog 4|helix-loop-helix protein mATH-4A|protein atonal homolog 4', map_location='3 H1', chromosome='3', genomic_nucleotide_accession_version='NC_000069.6', start_position_on_the_genomic_accession=127633145, end_position_on_the_genomic_accession=127635631, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  11925 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11925, CurrentID=0, Status='live', Symbol='Neurog3', Aliases='Atoh5, Math4B, bHLHa7, ngn3', description='neurogenin 3', other_designations='NGN-3|Neurogenin 3 (Atonal protein homolog 5) (Helix-loop-helix protein mATH-4B) (MATH4B)|atonal homolog 5|helix-loop-helix protein mATH-4B|protein atonal homolog 5', map_location='10 B4', chromosome='10', genomic_nucleotide_accession_version='NC_000076.6', start_position_on_the_genomic_accession=62133090, end_position_on_the_genomic_accession=62134763, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  11927 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11927, CurrentID=0, Status='live', Symbol='Atox1', Aliases='AI256639, Atx1', description='antioxidant 1 copper chaperone', other_designations='ATX1 (antioxidant protein 1) homolog 1|metal transport protein ATX1', map_location='11 33.07 cM', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=55446643, end_position_on_the_genomic_accession=55461138, orientation='minus', exon_count=4, OMIM='', no_hdr0=''),
  11928 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11928, CurrentID=0, Status='live', Symbol='Atp1a1', Aliases='Atpa-1, BC010319', description='ATPase, Na+/K+ transporting, alpha 1 polypeptide', other_designations='Na(+)/K(+) ATPase alpha-1 subunit|sodium pump subunit alpha-1', map_location='3 F3', chromosome='3', genomic_nucleotide_accession_version='NC_000069.6', start_position_on_the_genomic_accession=101576219, end_position_on_the_genomic_accession=101604707, orientation='minus', exon_count=23, OMIM='', no_hdr0=''),
  11931 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11931, CurrentID=0, Status='live', Symbol='Atp1b1', Aliases='Atp4b, Atpb, Atpb-1, NKbeta1', description='ATPase, Na+/K+ transporting, beta 1 polypeptide', other_designations='sodium/potassium ATPase beta subunit|sodium/potassium-dependent ATPase subunit beta-1', map_location='1 71.75 cM', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=164437099, end_position_on_the_genomic_accession=164458355, orientation='minus', exon_count=6, OMIM='', no_hdr0=''),
  11932 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11932, CurrentID=0, Status='live', Symbol='Atp1b2', Aliases='Amog, Atpb-2', description='ATPase, Na+/K+ transporting, beta 2 polypeptide', other_designations='adhesion molecule in glia|glial cell adhesion molecule|snoRNA MBI-85|sodium/potassium-dependent ATPase subunit beta-2', map_location='11 42.86 cM', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=69599750, end_position_on_the_genomic_accession=69605960, orientation='minus', exon_count=7, OMIM='', no_hdr0=''),
  11933 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11933, CurrentID=0, Status='live', Symbol='Atp1b3', Aliases='AA409958, AI664000, AW212096', description='ATPase, Na+/K+ transporting, beta 3 polypeptide', other_designations='ATPB-3|ATPase, Na+/K+ beta 3 polypeptide|Na K-ATPase beta-3 subunit|sodium/potassium-dependent ATPase subunit beta-3', map_location='9 50.31 cM', chromosome='9', genomic_nucleotide_accession_version='NC_000075.6', start_position_on_the_genomic_accession=96332662, end_position_on_the_genomic_accession=96364905, orientation='minus', exon_count=8, OMIM='', no_hdr0=''),
  11936 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11936, CurrentID=0, Status='live', Symbol='Fxyd2', Aliases='Atp1g1', description='FXYD domain-containing ion transport regulator 2', other_designations='ATPase, Na+/K+ transporting, gamma 1 polypeptide|Na(+)/K(+) ATPase subunit gamma|sodium pump gamma chain|sodium/potassium-transporting ATPase gamma chain', map_location='9 B', chromosome='9', genomic_nucleotide_accession_version='NC_000075.6', start_position_on_the_genomic_accession=45399709, end_position_on_the_genomic_accession=45410278, orientation='plus', exon_count=8, OMIM='', no_hdr0=''),
  11937 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11937, CurrentID=0, Status='live', Symbol='Atp2a1', Aliases='SERCA1', description='ATPase, Ca++ transporting, cardiac muscle, fast twitch 1', other_designations='SR Ca(2+)-ATPase 1|calcium pump 1|calcium-transporting ATPase sarcoplasmic reticulum type, fast twitch skeletal muscle isoform|endoplasmic reticulum class 1/2 Ca(2+) ATPase', map_location='7 69.04 cM', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=126445860, end_position_on_the_genomic_accession=126463103, orientation='minus', exon_count=23, OMIM='', no_hdr0=''),
  11938 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11938, CurrentID=0, Status='live', Symbol='Atp2a2', Aliases='9530097L16Rik, D5Wsu150e, SERCA2, SERCA2B, Serca2a, mKIAA4195', description='ATPase, Ca++ transporting, cardiac muscle, slow twitch 2', other_designations='SERCA2a isoform|SR Ca(2+)-ATPase 2|calcium pump 2|calcium-transporting ATPase sarcoplasmic reticulum type, slow twitch skeletal muscle isoform|endoplasmic reticulum class 1/2 Ca(2+) ATPase|sarco/endoplasmic reticulum Ca2+-ATPase 2', map_location='5 F', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=122453513, end_position_on_the_genomic_accession=122502225, orientation='minus', exon_count=21, OMIM='', no_hdr0=''),
  11941 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11941, CurrentID=0, Status='live', Symbol='Atp2b2', Aliases='D6Abb2e, Gena300, PMCA2, Tmy, dfw, jog, wms, wri', description='ATPase, Ca++ transporting, plasma membrane 2', other_designations='deaf waddler|plasma membrane calcium ATPase|plasma membrane calcium pump|wriggle', map_location='6 52.85 cM', chromosome='6', genomic_nucleotide_accession_version='NC_000072.6', start_position_on_the_genomic_accession=113743842, end_position_on_the_genomic_accession=114042613, orientation='minus', exon_count=30, OMIM='', no_hdr0=''),
  11944 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11944, CurrentID=0, Status='live', Symbol='Atp4a', Aliases='', description='ATPase, H+/K+ exchanging, gastric, alpha polypeptide', other_designations='ATPase, H+/K+ exchanging, alpha polypeptide|ATPase, H+/K+ transporting, alpha polypeptide|H+/K+-ATPase alpha|H+K+-transporting alpha 1|gastric H(+)/K(+) ATPase subunit alpha|proton pump', map_location='7 19.2 cM', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=30712209, end_position_on_the_genomic_accession=30725534, orientation='plus', exon_count=22, OMIM='', no_hdr0=''),
  11945 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11945, CurrentID=0, Status='live', Symbol='Atp4b', Aliases='AV080843', description='ATPase, H+/K+ exchanging, beta polypeptide', other_designations='ATPase, H+/K+ transporting, beta polypeptide, gastric specific|H+,K+-ATPase|H+/K+-ATPase beta|H,K-ATPase-Beta|gastric H(+)/K(+) ATPase subunit beta|proton pump beta chain', map_location='8 5.89 cM', chromosome='8', genomic_nucleotide_accession_version='NC_000074.6', start_position_on_the_genomic_accession=13386209, end_position_on_the_genomic_accession=13396778, orientation='minus', exon_count=7, OMIM='', no_hdr0=''),
  11946 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11946, CurrentID=0, Status='live', Symbol='Atp5a1', Aliases='AI035633, AL022851, AL023067, Atpm, D18Ertd206e, Mom2', description='ATP synthase, H+ transporting, mitochondrial F1 complex, alpha subunit 1', other_designations='ATP synthase, H+ transporting, mitochondrial F1 complex, alpha subunit|modifier of Min 2', map_location='18 52.38 cM', chromosome='18', genomic_nucleotide_accession_version='NC_000084.6', start_position_on_the_genomic_accession=77773768, end_position_on_the_genomic_accession=77782869, orientation='plus', exon_count=12, OMIM='', no_hdr0=''),
  11947 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11947, CurrentID=0, Status='live', Symbol='Atp5b', Aliases='', description='ATP synthase, H+ transporting mitochondrial F1 complex, beta subunit', other_designations='ATP synthase, H+ transporting mitochondrial F1 complex, alpha subunit|mitochondrial ATP synthase, H+ transporting F1 complex beta subunit', map_location='10 D3', chromosome='10', genomic_nucleotide_accession_version='NC_000076.6', start_position_on_the_genomic_accession=128083307, end_position_on_the_genomic_accession=128090388, orientation='plus', exon_count=10, OMIM='', no_hdr0=''),
  11949 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11949, CurrentID=0, Status='live', Symbol='Atp5c1', Aliases='1700094F02Rik', description='ATP synthase, H+ transporting, mitochondrial F1 complex, gamma polypeptide 1', other_designations='ATP synthase gamma-subunit gene encoding a mitochondrial protein|F-ATPase gamma subunit|F1 gamma', map_location='2 A1', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=10056030, end_position_on_the_genomic_accession=10080510, orientation='minus', exon_count=10, OMIM='', no_hdr0=''),
  11950 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11950, CurrentID=0, Status='live', Symbol='Atp5f1', Aliases='C76477', description='ATP synthase, H+ transporting, mitochondrial F0 complex, subunit B1', other_designations='ATP synthase subunit b, mitochondrial|ATPase subunit b', map_location='3 46.46 cM', chromosome='3', genomic_nucleotide_accession_version='NC_000069.6', start_position_on_the_genomic_accession=105942698, end_position_on_the_genomic_accession=105960248, orientation='minus', exon_count=10, OMIM='', no_hdr0=''),
  11951 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11951, CurrentID=0, Status='live', Symbol='Atp5g1', Aliases='', description='ATP synthase, H+ transporting, mitochondrial F0 complex, subunit C1 (subunit 9)', other_designations='ATP synthase lipid-binding protein, mitochondrial|ATP synthase proteolipid P1|ATP synthase, H+ transporting, mitochondrial F0 complex, subunit c (subunit 9)|ATPase protein 9|ATPase subunit c', map_location='11 D', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=96072793, end_position_on_the_genomic_accession=96075694, orientation='minus', exon_count=5, OMIM='', no_hdr0=''),
  11957 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11957, CurrentID=0, Status='live', Symbol='Atp5j', Aliases='CF6', description='ATP synthase, H+ transporting, mitochondrial F0 complex, subunit F', other_designations='ATP synthase coupling factor VI|ATPase subunit F6', map_location='16 C3.3', chromosome='16', genomic_nucleotide_accession_version='NC_000082.6', start_position_on_the_genomic_accession=84827866, end_position_on_the_genomic_accession=84835648, orientation='minus', exon_count=6, OMIM='', no_hdr0=''),
  11958 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11958, CurrentID=0, Status='live', Symbol='Atp5k', Aliases='2610008D24Rik, Atp5i, Lfm1', description='ATP synthase, H+ transporting, mitochondrial F1F0 complex, subunit E', other_designations='ATPase subunit e', map_location='5 53.11 cM', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=108433253, end_position_on_the_genomic_accession=108434378, orientation='minus', exon_count=4, OMIM='', no_hdr0=''),
  11964 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11964, CurrentID=0, Status='live', Symbol='Atp6v1a', Aliases='AI647066, Atp6a1, Atp6a21, VA68, VPP2, Atp6v1a', description='ATPase, H+ transporting, lysosomal V1 subunit A', other_designations='70-kDa subunit|ATPase, H+ transporting, V1 subunit A|ATPase, H+ transporting, V1 subunit A1|ATPase, H+ transporting, lysosomal (vacuolar proton pump), alpha 70 kDa|ATPase, H+ transporting, lysosomal 70kD, V1 subunit A|V-ATPase 69 kDa subunit|V-ATPase subunit A|lysosomal 70kDa|vacuolar proton pump subunit alpha', map_location='16 B4', chromosome='16', genomic_nucleotide_accession_version='NC_000082.6', start_position_on_the_genomic_accession=44085402, end_position_on_the_genomic_accession=44139700, orientation='minus', exon_count=16, OMIM='', no_hdr0=''),
  11966 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11966, CurrentID=0, Status='live', Symbol='Atp6v1b2', Aliases='AI194269, AI790362, Atp6b2, HO57, R74844', description='ATPase, H+ transporting, lysosomal V1 subunit B2', other_designations='ATPase, H+ transporting, V1 subunit B|ATPase, H+ transporting, lysosomal (vacuolar proton pump), beta 56/58 kDa|ATPase, H+ transporting, lysosomal 56/58kD, V1 subunit B|V-ATPase subunit B 2|endomembrane proton pump 58 kDa subunit|lysosomal 56/58kDa|vacuolar proton pump subunit B 2', map_location='8 B3.3', chromosome='8', genomic_nucleotide_accession_version='NC_000074.6', start_position_on_the_genomic_accession=69088736, end_position_on_the_genomic_accession=69113718, orientation='plus', exon_count=14, OMIM='', no_hdr0=''),
  11972 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11972, CurrentID=0, Status='live', Symbol='Atp6v0d1', Aliases='AI267038, Ac39, Atp6d, P39, VATX, Vma6', description='ATPase, H+ transporting, lysosomal V0 subunit D1', other_designations='ATPase, H+ transporting, V0 subunit D|ATPase, H+ transporting, lysosomal (vacuolar proton pump), 42 kDa|ATPase, H+ transporting, lysosomal 38kDa, V0 subunit D|V-ATPase 40 kDa accessory protein|V-ATPase AC39 subunit|V-ATPase subunit d 1|lysosomal 38kDa|physophilin|vacuolar proton pump subunit d 1', map_location='8 D3', chromosome='8', genomic_nucleotide_accession_version='NC_000074.6', start_position_on_the_genomic_accession=105524470, end_position_on_the_genomic_accession=105566040, orientation='minus', exon_count=8, OMIM='', no_hdr0=''),
  11973 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11973, CurrentID=0, Status='live', Symbol='Atp6v1e1', Aliases='2410029D23Rik, Atp6e, Atp6e2, Atp6v1e, D6Ertd385e, E2, P31, Vma4', description='ATPase, H+ transporting, lysosomal V1 subunit E1', other_designations='ATPase, H+ transporting lysosomal (vacuolar proton pump), 32 kDa|ATPase, H+ transporting, V1 subunit E|ATPase, H+ transporting, lysosomal 31kDa, V1 subunit E|H(+)-ATPase E-like protein|H+ ATPase subunit E|V-ATPase 31 kDa subunit|V-ATPase subunit E 1|VATPase, H+ transporting, lysosomal V1 subunit E1|lysosomal 31kDa|vacuolar proton pump subunit E 1', map_location='6 57.01 cM', chromosome='6', genomic_nucleotide_accession_version='NC_000072.6', start_position_on_the_genomic_accession=120795244, end_position_on_the_genomic_accession=120822685, orientation='minus', exon_count=9, OMIM='', no_hdr0=''),
  11974 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11974, CurrentID=0, Status='live', Symbol='Atp6v0e', Aliases='Atp6k1, M9.2, Atp6v0e', description='ATPase, H+ transporting, lysosomal V0 subunit E', other_designations='ATPase, H+ transporting lysosomal (vacuolar proton pump), 9.2 kDa|ATPase, H+ transporting, V0 subunit e|ATPase, H+ transporting, lysosomal 9kD V0 subunit E|V-ATPase subunit e 1|lysosomal 9kDa|vacuolar proton pump subunit e 1', map_location='17 A3.3', chromosome='17', genomic_nucleotide_accession_version='NC_000083.6', start_position_on_the_genomic_accession=26676369, end_position_on_the_genomic_accession=26699647, orientation='plus', exon_count=5, OMIM='', no_hdr0=''),
  11975 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11975, CurrentID=0, Status='live', Symbol='Atp6v0a1', Aliases='AA959968, ATP6a1, Atp6n1, Atp6n1a, Atpv0a1, Vpp-1, Vpp1', description='ATPase, H+ transporting, lysosomal V0 subunit A1', other_designations='ATPase, H+ transporting, lysosomal (vacuolar proton pump) noncatalytic accessory protein 1 (110/160 kDa)|ATPase, H+ transporting, lysosomal (vacuolar proton pump) noncatalytic accessory protein 1A (110/160 kDa)|ATPase, H+ transporting, lysosomal V0 subunit a|V-ATPase 116 kDa|V-ATPase a1|V-type proton ATPase 116 kDa subunit a|clathrin-coated vesicle/synaptic vesicle proton pump 116 kDa subunit|vacuolar adenosine triphosphatase subunit Ac116|vacuolar proton pump subunit 1|vacuolar proton translocating ATPase 116 kDa subunit a', map_location='11 64.04 cM', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=101009447, end_position_on_the_genomic_accession=101063719, orientation='plus', exon_count=23, OMIM='', no_hdr0=''),
  11977 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11977, CurrentID=0, Status='live', Symbol='Atp7a', Aliases='MNK', description='ATPase, Cu++ transporting, alpha polypeptide', other_designations='Menkes protein|copper pump 1|menkes disease-associated protein homolog', map_location='X 47.36 cM', chromosome='X', genomic_nucleotide_accession_version='NC_000086.7', start_position_on_the_genomic_accession=106027224, end_position_on_the_genomic_accession=106128160, orientation='plus', exon_count=23, OMIM='', no_hdr0=''),
  11979 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11979, CurrentID=0, Status='live', Symbol='Atp7b', Aliases='Atp7a, WND, tx', description='ATPase, Cu++ transporting, beta polypeptide', other_designations='Wilson protein|copper pump 2|toxic milk|wilson disease-associated protein homolog', map_location='8 10.78 cM', chromosome='8', genomic_nucleotide_accession_version='NC_000074.6', start_position_on_the_genomic_accession=21992783, end_position_on_the_genomic_accession=22060074, orientation='minus', exon_count=24, OMIM='', no_hdr0=''),
  11980 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11980, CurrentID=0, Status='live', Symbol='Atp8a1', Aliases='AI481521, AI853962, APLT, AW743152, AW822227, Atp3a2, B230107D19Rik, ClassI', description='ATPase, aminophospholipid transporter (APLT), class I, type 8A, member 1', other_designations='ATPase 8A1, aminophospholipid transporter (APLT), class I|ATPase 8A1, p type|ATPase class I type 8A member 1|P4-ATPase flippase complex alpha subunit ATP8A1|chromaffin granule ATPase II|probable phospholipid-transporting ATPase IA', map_location='5 C3.1', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=67618139, end_position_on_the_genomic_accession=67847487, orientation='minus', exon_count=42, OMIM='', no_hdr0=''),
  11981 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11981, CurrentID=0, Status='live', Symbol='Atp9a', Aliases='IIa', description='ATPase, class II, type 9A', other_designations='ATPase 9A, class II|ATPase 9A, p type|ATPase, class 2', map_location='2 H3', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=168634438, end_position_on_the_genomic_accession=168742136, orientation='minus', exon_count=33, OMIM='', no_hdr0=''),
  11982 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11982, CurrentID=0, Status='live', Symbol='Atp10a', Aliases='Atp10c, pfatp', description='ATPase, class V, type 10A', other_designations='ATPase 10A, class V|ATPase, class 5|P-locus fat-associated ATPase|P4-ATPase flippase complex alpha subunit ATP10A', map_location='7 C', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=58656143, end_position_on_the_genomic_accession=58830035, orientation='plus', exon_count=23, OMIM='', no_hdr0=''),
  11983 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11983, CurrentID=0, Status='live', Symbol='Atpif1', Aliases='Atpi, IF(1), If1', description='ATPase inhibitory factor 1', other_designations='inhibitor of F(1)F(o)-ATPase', map_location='4 D2.3', chromosome='4', genomic_nucleotide_accession_version='NC_000070.6', start_position_on_the_genomic_accession=132530555, end_position_on_the_genomic_accession=132535409, orientation='minus', exon_count=4, OMIM='', no_hdr0=''),
  11984 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11984, CurrentID=0, Status='live', Symbol='Atp6v0c', Aliases='Atp6c, Atp6c2, Atp6l, Atpl, Atpl-rs1, PL16, VATL, Vma3', description='ATPase, H+ transporting, lysosomal V0 subunit C', other_designations='ATPase, H+ transporting, lysosomal (vacuolar proton pump) 16 kDa|ATPase, H+ transporting, lysosomal 16kD, V0 subunit C|ATPase, H+ transporting, lysosomal 2|H(+)-ATPase (mvp)|V-ATPase 16 kDa proteolipid subunit|vacuolar proton pump 16 kDa proteolipid subunit', map_location='17 A3.3', chromosome='17', genomic_nucleotide_accession_version='NC_000083.6', start_position_on_the_genomic_accession=24163866, end_position_on_the_genomic_accession=24169429, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  11987 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11987, CurrentID=0, Status='live', Symbol='Slc7a1', Aliases='4831426K01Rik, AI447493, Atrc-1, Atrc1, Cat1, Rec-1, Rev-1, mCAT-1', description='solute carrier family 7 (cationic amino acid transporter, y+ system), member 1', other_designations='CAT-1|ERR|cationic amino acid transporter 1|ecotropic retroviral leukemia receptor|ecotropic retrovirus receptor|solute carrier family 7 member 1|system Y+ basic amino acid transporter', map_location='5 88.48 cM', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=148327410, end_position_on_the_genomic_accession=148399904, orientation='minus', exon_count=15, OMIM='', no_hdr0=''),
  11988 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11988, CurrentID=0, Status='live', Symbol='Slc7a2', Aliases='20.5, AI158848, Atrc2, CAT-2, Cat2, Tea', description='solute carrier family 7 (cationic amino acid transporter, y+ system), member 2', other_designations='T-cell early activation protein|amino acid transporter, cationic 2 (low affinity)|cationic amino acid transporter 2A|cationic amino acid transporter 2B|low affinity cationic amino acid transporter 2|solute carrier family 7 member 2', map_location='8 23.89 cM', chromosome='8', genomic_nucleotide_accession_version='NC_000074.6', start_position_on_the_genomic_accession=40862367, end_position_on_the_genomic_accession=40922070, orientation='plus', exon_count=16, OMIM='', no_hdr0=''),
  11989 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11989, CurrentID=0, Status='live', Symbol='Slc7a3', Aliases='Atrc3, CAT-3, CAT3, SLC7A1, SLC7A2', description='solute carrier family 7 (cationic amino acid transporter, y+ system), member 3', other_designations='amino acid transporter, cationic 3|cationic amino acid transporter y+|solute carrier family 7 member 3', map_location='X C3', chromosome='X', genomic_nucleotide_accession_version='NC_000086.7', start_position_on_the_genomic_accession=101079204, end_position_on_the_genomic_accession=101090452, orientation='minus', exon_count=15, OMIM='', no_hdr0=''),
  11990 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11990, CurrentID=0, Status='live', Symbol='Atrn', Aliases='AW558010, Mgca, mKIAA0548, mahogany, mg', description='attractin', other_designations='protein mahogany', map_location='2 63.26 cM', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=130906447, end_position_on_the_genomic_accession=131030333, orientation='plus', exon_count=30, OMIM='', no_hdr0=''),
  11991 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11991, CurrentID=0, Status='live', Symbol='Hnrnpd', Aliases='Auf1, Hnrpd', description='heterogeneous nuclear ribonucleoprotein D', other_designations='AU-rich element RNA-binding protein 1|hnRNP D0', map_location='5 E3', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=99955935, end_position_on_the_genomic_accession=99979015, orientation='minus', exon_count=10, OMIM='', no_hdr0=''),
  11992 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11992, CurrentID=0, Status='live', Symbol='Auh', Aliases='C77140, W91705', description='AU RNA binding protein/enoyl-coenzyme A hydratase', other_designations='AU-binding enoyl-CoA hydratase|AU-specific RNA-binding enoyl-CoA hydratase|muAUH', map_location='13 B1', chromosome='13', genomic_nucleotide_accession_version='NC_000079.6', start_position_on_the_genomic_accession=52835102, end_position_on_the_genomic_accession=52929706, orientation='minus', exon_count=13, OMIM='', no_hdr0=''),
  11993 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11993, CurrentID=0, Status='live', Symbol='Aup1', Aliases='AA589454', description='ancient ubiquitous protein 1', other_designations='', map_location='6 35.94 cM', chromosome='6', genomic_nucleotide_accession_version='NC_000072.6', start_position_on_the_genomic_accession=83054521, end_position_on_the_genomic_accession=83057682, orientation='plus', exon_count=12, OMIM='', no_hdr0=''),
  11994 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11994, CurrentID=0, Status='live', Symbol='Pcdh15', Aliases='BB078305, ENSMUSG00000046980, Gm9815, Ush1f, av, nmf19, roda', description='protocadherin 15', other_designations='Ames waltzer|protocadherin 15 CD2|protocadherin 15 CD3 isoform', map_location='10 37.43 cM', chromosome='10', genomic_nucleotide_accession_version='NC_000076.6', start_position_on_the_genomic_accession=73100028, end_position_on_the_genomic_accession=74649737, orientation='plus', exon_count=46, OMIM='', no_hdr0=''),
  11997 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11997, CurrentID=0, Status='live', Symbol='Akr1b7', Aliases='AR, Avdp, MVDP', description='aldo-keto reductase family 1, member B7', other_designations='aldehyde reductase|androgen regulated vas deferens protein|vas deferens androgen-dependent protein', map_location='6 14.95 cM', chromosome='6', genomic_nucleotide_accession_version='NC_000072.6', start_position_on_the_genomic_accession=34412362, end_position_on_the_genomic_accession=34423137, orientation='plus', exon_count=10, OMIM='', no_hdr0=''),
  11998 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=11998, CurrentID=0, Status='live', Symbol='Avp', Aliases='Vp, Vsp', description='arginine vasopressin', other_designations='AVP-NPII|pre-pro-arginine-vasopressin-neurophysin II|prepro-AVP-NP II', map_location='2 63.24 cM', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=130580677, end_position_on_the_genomic_accession=130582541, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  12000 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12000, CurrentID=0, Status='live', Symbol='Avpr2', Aliases='ADHR, DI1, DIR, ND1, V2R, VPV2R', description='arginine vasopressin receptor 2', other_designations='antidiuretic hormone receptor|nephrogenic diabetes insipidus|renal-type arginine vasopressin receptor', map_location='X 37.46 cM', chromosome='X', genomic_nucleotide_accession_version='NC_000086.7', start_position_on_the_genomic_accession=73890591, end_position_on_the_genomic_accession=73894428, orientation='plus', exon_count=4, OMIM='', no_hdr0=''),
  12005 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12005, CurrentID=0, Status='live', Symbol='Axin1', Aliases='AI316800, Axin, Fu, Kb, Ki, fused, kinky, knobbly', description='axin 1', other_designations='axis inhibition protein 1|protein Fused', map_location='17 13.07 cM', chromosome='17', genomic_nucleotide_accession_version='NC_000083.6', start_position_on_the_genomic_accession=26130972, end_position_on_the_genomic_accession=26195811, orientation='plus', exon_count=14, OMIM='', no_hdr0=''),
  12006 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12006, CurrentID=0, Status='live', Symbol='Axin2', Aliases='Axi1, Axil, Conductin', description='axin2', other_designations='axin-like protein|axis inhibition protein 2', map_location='11 71.83 cM', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=108917828, end_position_on_the_genomic_accession=108950783, orientation='plus', exon_count=15, OMIM='', no_hdr0=''),
  12007 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12007, CurrentID=0, Status='live', Symbol='Azgp1', Aliases='Zag', description='alpha-2-glycoprotein 1, zinc', other_designations='major histocompatibility complex class I-like protein|zn-alpha-2-GP', map_location='5 76.92 cM', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=137981521, end_position_on_the_genomic_accession=137990233, orientation='plus', exon_count=4, OMIM='', no_hdr0=''),
  12009 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12009, CurrentID=0, Status='live', Symbol='Cep131', Aliases='AZ1, Azi, Azi1', description='centrosomal protein 131', other_designations='5-azacytidine induced gene 1|5-azacytidine-induced protein 1|pre-acrosome localization protein 1', map_location='11 E2', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=120064429, end_position_on_the_genomic_accession=120086859, orientation='minus', exon_count=27, OMIM='', no_hdr0=''),
  12010 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12010, CurrentID=0, Status='live', Symbol='B2m', Aliases='Ly-m11, beta2-m, beta2m', description='beta-2 microglobulin', other_designations='', map_location='2 F1-F3', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=122147687, end_position_on_the_genomic_accession=122153082, orientation='plus', exon_count=4, OMIM='', no_hdr0=''),
  12012 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12012, CurrentID=0, Status='live', Symbol='Baat', Aliases='AI118337, AI158864, BAT', description='bile acid-Coenzyme A: amino acid N-acyltransferase', other_designations='BACAT|bile acid-Coenzyme A dehydrogenase: amino acid n-acyltransferase|glycine N-choloyltransferase|long-chain fatty-acyl-CoA hydrolase|taurine N-acyltransferase', map_location='4 26.51 cM', chromosome='4', genomic_nucleotide_accession_version='NC_000070.6', start_position_on_the_genomic_accession=49489416, end_position_on_the_genomic_accession=49507912, orientation='minus', exon_count=4, OMIM='', no_hdr0=''),
  667373 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=667373, CurrentID=0, Status='live', Symbol='Ifit1bl1', Aliases='Gm14446, Ifit1c, OTTMUSG00000016644', description='interferon induced protein with tetratricpeptide repeats 1B like 1', other_designations='', map_location='19', chromosome='19', genomic_nucleotide_accession_version='NC_000085.6', start_position_on_the_genomic_accession=34592888, end_position_on_the_genomic_accession=34663000, orientation='minus', exon_count=4, OMIM='', no_hdr0=''),
  12014 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12014, CurrentID=0, Status='live', Symbol='Bach2', Aliases='E030004N02Rik', description='BTB and CNC homology, basic leucine zipper transcription factor 2', other_designations='BTB and CNC homolog 2|BTB and CNC homology 2|Transcription regulator protein BACH2 (BTB and CNC homolog 2)', map_location='4 A4', chromosome='4', genomic_nucleotide_accession_version='NC_000070.6', start_position_on_the_genomic_accession=32238574, end_position_on_the_genomic_accession=32586108, orientation='plus', exon_count=10, OMIM='', no_hdr0=''),
  12015 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12015, CurrentID=0, Status='live', Symbol='Bad', Aliases='AI325008, Bbc2', description='BCL2-associated agonist of cell death', other_designations='bcl-2-binding component 6|bcl-xL/Bcl-2-associated death promoter|bcl2 antagonist of cell death', map_location='19 A', chromosome='19', genomic_nucleotide_accession_version='NC_000085.6', start_position_on_the_genomic_accession=6941861, end_position_on_the_genomic_accession=6951905, orientation='plus', exon_count=5, OMIM='', no_hdr0=''),
  12017 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12017, CurrentID=0, Status='live', Symbol='Bag1', Aliases='BAG-1, Rap46', description='BCL2-associated athanogene 1', other_designations='Bcl-2-binding protein|bcl-2-associated athanogene 1', map_location='4 B1', chromosome='4', genomic_nucleotide_accession_version='NC_000070.6', start_position_on_the_genomic_accession=40936398, end_position_on_the_genomic_accession=40948294, orientation='minus', exon_count=7, OMIM='', no_hdr0=''),
  12018 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12018, CurrentID=0, Status='live', Symbol='Bak1', Aliases='Bak, N-BAK1, N-Bak', description='BCL2-antagonist/killer 1', other_designations='Bcl2 homologous antagonist/killer|apoptosis regulator BAK', map_location='17 B', chromosome='17', genomic_nucleotide_accession_version='NC_000083.6', start_position_on_the_genomic_accession=27019812, end_position_on_the_genomic_accession=27028839, orientation='minus', exon_count=7, OMIM='', no_hdr0=''),
  12020 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12020, CurrentID=0, Status='live', Symbol='Nkx3-2', Aliases='Bapx1, NKX3.2, Nkx-3.2', description='NK3 homeobox 2', other_designations='bagpipe homeobox gene 1 homolog|bagpipe homeobox protein homolog 1|homeobox protein NK-3 homolog B|homeodomain protein Nkx-3.2', map_location='5 22.58 cM', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=41761483, end_position_on_the_genomic_accession=41764220, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  12021 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12021, CurrentID=0, Status='live', Symbol='Bard1', Aliases='ENSMUSG00000060893, ENSMUSG00000073653', description='BRCA1 associated RING domain 1', other_designations='BARD-1', map_location='1 C3', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=71027531, end_position_on_the_genomic_accession=71103233, orientation='minus', exon_count=11, OMIM='', no_hdr0=''),
  12022 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12022, CurrentID=0, Status='live', Symbol='Barx1', Aliases='', description='BarH-like homeobox 1', other_designations='', map_location='13 24.9 cM', chromosome='13', genomic_nucleotide_accession_version='NC_000079.6', start_position_on_the_genomic_accession=48663036, end_position_on_the_genomic_accession=48666507, orientation='plus', exon_count=4, OMIM='', no_hdr0=''),
  12023 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12023, CurrentID=0, Status='live', Symbol='Barx2', Aliases='2310006E12Rikb, Barx2', description='BarH-like homeobox 2', other_designations='homeodomain transcription factor BARX2', map_location='9 A4', chromosome='9', genomic_nucleotide_accession_version='NC_000075.6', start_position_on_the_genomic_accession=31846044, end_position_on_the_genomic_accession=31913285, orientation='minus', exon_count=4, OMIM='', no_hdr0=''),
  12028 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12028, CurrentID=0, Status='live', Symbol='Bax', Aliases='', description='BCL2-associated X protein', other_designations='', map_location='7 B5', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=45461695, end_position_on_the_genomic_accession=45466903, orientation='minus', exon_count=7, OMIM='', no_hdr0=''),
  12029 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12029, CurrentID=0, Status='live', Symbol='Bcl6b', Aliases='Bazf', description='B cell CLL/lymphoma 6, member B', other_designations='B-cell CLL/lymphoma 6, member B|BcL6-associated zinc finger protein', map_location='11 B4', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=70224127, end_position_on_the_genomic_accession=70229798, orientation='minus', exon_count=9, OMIM='', no_hdr0=''),
  12032 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12032, CurrentID=0, Status='live', Symbol='Bcan', Aliases='Cspg7', description='brevican', other_designations='', map_location='3 38.78 cM', chromosome='3', genomic_nucleotide_accession_version='NC_000069.6', start_position_on_the_genomic_accession=87987531, end_position_on_the_genomic_accession=88000893, orientation='minus', exon_count=15, OMIM='', no_hdr0=''),
  12033 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12033, CurrentID=0, Status='live', Symbol='Bcap29', Aliases='AW208404, Bap29', description='B cell receptor associated protein 29', other_designations='BCR-associated protein 29', map_location='12 13.63 cM', chromosome='12', genomic_nucleotide_accession_version='NC_000078.6', start_position_on_the_genomic_accession=31595354, end_position_on_the_genomic_accession=31634658, orientation='minus', exon_count=8, OMIM='', no_hdr0=''),
  12034 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12034, CurrentID=0, Status='live', Symbol='Phb2', Aliases='AU044498, BAP, Bap37, Bcap37, REA', description='prohibitin 2', other_designations='B-cell receptor-associated protein 37|B-cell receptor-associated protein BAP37|phb2|repressor of estrogen receptor activity', map_location='6 59.17 cM', chromosome='6', genomic_nucleotide_accession_version='NC_000072.6', start_position_on_the_genomic_accession=124712289, end_position_on_the_genomic_accession=124716945, orientation='plus', exon_count=10, OMIM='', no_hdr0=''),
  12035 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12035, CurrentID=0, Status='live', Symbol='Bcat1', Aliases='BCATc, Eca39', description='branched chain aminotransferase 1, cytosolic', other_designations='BCAT(c)', map_location='6 77.27 cM', chromosome='6', genomic_nucleotide_accession_version='NC_000072.6', start_position_on_the_genomic_accession=144993835, end_position_on_the_genomic_accession=145076157, orientation='minus', exon_count=13, OMIM='', no_hdr0=''),
  12036 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12036, CurrentID=0, Status='live', Symbol='Bcat2', Aliases='Bcat-2, Eca40', description='branched chain aminotransferase 2, mitochondrial', other_designations='BCAT(m)', map_location='7 29.36 cM', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=45569855, end_position_on_the_genomic_accession=45589710, orientation='plus', exon_count=15, OMIM='', no_hdr0=''),
  12038 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12038, CurrentID=0, Status='live', Symbol='Bche', Aliases='C730038G20Rik', description='butyrylcholinesterase', other_designations='acylcholine acylhydrolase|butyrylcholine esterase|choline esterase II|pseudocholinesterase', map_location='3 E3', chromosome='3', genomic_nucleotide_accession_version='NC_000069.6', start_position_on_the_genomic_accession=73635805, end_position_on_the_genomic_accession=73708437, orientation='minus', exon_count=5, OMIM='', no_hdr0=''),
  12039 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12039, CurrentID=0, Status='live', Symbol='Bckdha', Aliases='', description='branched chain ketoacid dehydrogenase E1, alpha polypeptide', other_designations='BCKAD E1[a]|BCKDE1A|BCKDH E1-alpha|branched-chain alpha-keto acid dehydrogenase E1 component alpha chain', map_location='7 A3', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=25629852, end_position_on_the_genomic_accession=25658784, orientation='minus', exon_count=10, OMIM='', no_hdr0=''),
  12040 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12040, CurrentID=0, Status='live', Symbol='Bckdhb', Aliases='BCKDE1B, BCKDH E1-beta', description='branched chain ketoacid dehydrogenase E1, beta polypeptide', other_designations='branched-chain alpha-keto acid dehydrogenase E1 component beta chain', map_location='9 E2', chromosome='9', genomic_nucleotide_accession_version='NC_000075.6', start_position_on_the_genomic_accession=83925111, end_position_on_the_genomic_accession=84124240, orientation='plus', exon_count=13, OMIM='', no_hdr0=''),
  12041 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12041, CurrentID=0, Status='live', Symbol='Bckdk', Aliases='AI327402', description='branched chain ketoacid dehydrogenase kinase', other_designations='BCKD-kinase|BCKDHKIN|branched-chain alpha-ketoacid dehydrogenase kinase', map_location='7 F3', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=127904073, end_position_on_the_genomic_accession=127909664, orientation='plus', exon_count=12, OMIM='', no_hdr0=''),
  12042 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12042, CurrentID=0, Status='live', Symbol='Bcl10', Aliases='AI132454, BCL-10, C81403, CARMEN, CIPER, CLAP, ME10, cE10', description='B cell leukemia/lymphoma 10', other_designations='B-cell CLL/lymphoma 10|B-cell leukemia/lymphoma 10|CARD-containing molecule enhancing NF-kappa-B|CARD-like apoptotic protein|CED-3/ICH-1 prodomain homologous E10-like regulator|cellular homolog of vCARMEN|cellular-E10|mammalian CARD-containing adapter molecule E10', map_location='3 H3', chromosome='3', genomic_nucleotide_accession_version='NC_000069.6', start_position_on_the_genomic_accession=145924262, end_position_on_the_genomic_accession=145934366, orientation='plus', exon_count=3, OMIM='', no_hdr0=''),
  12043 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12043, CurrentID=0, Status='live', Symbol='Bcl2', Aliases='AW986256, Bcl-2, C430015F12Rik, D630044D05Rik, D830018M01Rik', description='B cell leukemia/lymphoma 2', other_designations='B-cell leukemia/lymphoma 2', map_location='1 49.76 cM', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=106538178, end_position_on_the_genomic_accession=106714290, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  12044 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12044, CurrentID=0, Status='live', Symbol='Bcl2a1a', Aliases='A1, BB218357, Bcl2a1, Bfl-1, Hbpa1', description='B cell leukemia/lymphoma 2 related protein A1a', other_designations='A1-A|B-cell leukemia/lymphoma 2 related protein A1a|hemopoietic-specific early response protein|protein BFL-1', map_location='9 47.24 cM', chromosome='9', genomic_nucleotide_accession_version='NC_000075.6', start_position_on_the_genomic_accession=88956920, end_position_on_the_genomic_accession=88962416, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  12045 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12045, CurrentID=0, Status='live', Symbol='Bcl2a1b', Aliases='A1-b', description='B cell leukemia/lymphoma 2 related protein A1b', other_designations='anti-apoptotic protein A1-b', map_location='9 E3.1', chromosome='9', genomic_nucleotide_accession_version='NC_000075.6', start_position_on_the_genomic_accession=89199273, end_position_on_the_genomic_accession=89207838, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  12047 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12047, CurrentID=0, Status='live', Symbol='Bcl2a1d', Aliases='A1-d', description='B cell leukemia/lymphoma 2 related protein A1d', other_designations='B-cell leukemia/lymphoma 2 related protein A1d', map_location='9 E3.1', chromosome='9', genomic_nucleotide_accession_version='NC_000075.6', start_position_on_the_genomic_accession=88723288, end_position_on_the_genomic_accession=88731850, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  12048 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12048, CurrentID=0, Status='live', Symbol='Bcl2l1', Aliases='Bcl(X)L, Bcl-XL, Bcl2l, BclX, bcl-x, bcl2-L-1', description='BCL2-like 1', other_designations='B-cell leukemia/lymphoma x|anti-apoptosis regulatory protein|apoptosis regulator Bcl-X', map_location='2 H1', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=152758732, end_position_on_the_genomic_accession=152832581, orientation='minus', exon_count=9, OMIM='', no_hdr0=''),
  12049 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12049, CurrentID=0, Status='live', Symbol='Bcl2l10', Aliases='AA420380, AU023065, Boo, C85687, Diva', description='Bcl2-like 10', other_designations='anti-apoptotic protein Boo|apoptosis regulator Bcl-B|bcl-2 homolog Diva|bcl2-L-10', map_location='9 D', chromosome='9', genomic_nucleotide_accession_version='NC_000075.6', start_position_on_the_genomic_accession=75347758, end_position_on_the_genomic_accession=75351640, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  12050 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12050, CurrentID=0, Status='live', Symbol='Bcl2l2', Aliases='AW048834, Bcl-w, Gtrgal2, Gtrosa41, bclw, c98', description='BCL2-like 2', other_designations='apoptosis regulator Bcl-W|bcl2-L-2', map_location='14 27.98 cM', chromosome='14', genomic_nucleotide_accession_version='NC_000080.6', start_position_on_the_genomic_accession=54883366, end_position_on_the_genomic_accession=54889095, orientation='plus', exon_count=5, OMIM='', no_hdr0=''),
  12051 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12051, CurrentID=0, Status='live', Symbol='Bcl3', Aliases='AI528691, Bcl-3', description='B cell leukemia/lymphoma 3', other_designations='B-cell CLL/lymphoma 3|B-cell leukemia/lymphoma 3', map_location='7 9.95 cM', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=19808462, end_position_on_the_genomic_accession=19822811, orientation='minus', exon_count=9, OMIM='', no_hdr0=''),
  12053 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12053, CurrentID=0, Status='live', Symbol='Bcl6', Aliases='Bcl5', description='B cell leukemia/lymphoma 6', other_designations='B-cell leukemia/lymphoma 5|B-cell leukemia/lymphoma 6', map_location='16 15.26 cM', chromosome='16', genomic_nucleotide_accession_version='NC_000082.6', start_position_on_the_genomic_accession=23965052, end_position_on_the_genomic_accession=23988612, orientation='minus', exon_count=10, OMIM='', no_hdr0=''),
  12054 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12054, CurrentID=0, Status='live', Symbol='Bcl7b', Aliases='', description='B cell CLL/lymphoma 7B', other_designations='B-cell CLL/lymphoma 7B', map_location='5 G2', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=135168372, end_position_on_the_genomic_accession=135181852, orientation='plus', exon_count=6, OMIM='', no_hdr0=''),
  12055 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12055, CurrentID=0, Status='live', Symbol='Bcl7c', Aliases='C230096E12Rik', description='B cell CLL/lymphoma 7C', other_designations='B-cell CLL/lymphoma 7C|B-cell chronic lymphocytic leukemia/lymphoma 7C protein', map_location='7 F4', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=127661454, end_position_on_the_genomic_accession=127708780, orientation='minus', exon_count=7, OMIM='', no_hdr0=''),
  12057 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12057, CurrentID=0, Status='live', Symbol='Opn1sw', Aliases='AW551857, Bcp', description='opsin 1 (cone pigments), short-wave-sensitive (color blindness, tritan)', other_designations='BOP|S opsin|SWS opsin|UV cone pigment|blue cone opsin|blue cone photoreceptor pigment|blue cone pigment|blue opsin|blue visual pigment protein|blue-sensitive opsin|blue/UV opsin|short wavelength sensitive opsin|short wavelength-sensitive cone opsin', map_location='6 A3.3', chromosome='6', genomic_nucleotide_accession_version='NC_000072.6', start_position_on_the_genomic_accession=29376671, end_position_on_the_genomic_accession=29388729, orientation='minus', exon_count=7, OMIM='', no_hdr0=''),
  12061 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12061, CurrentID=0, Status='live', Symbol='Bdkrb1', Aliases='B1BKR, B1R, BKR1, BRADYB1, Bdkrb', description='bradykinin receptor, beta 1', other_designations='BK-1 receptor|kinin B1', map_location='12 F1', chromosome='12', genomic_nucleotide_accession_version='NC_000078.6', start_position_on_the_genomic_accession=105604091, end_position_on_the_genomic_accession=105605428, orientation='plus', exon_count=1, OMIM='', no_hdr0=''),
  12062 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12062, CurrentID=0, Status='live', Symbol='Bdkrb2', Aliases='B(2), B2, B2R, BK-2, BK2, BK2R, BKR2, BRB2', description='bradykinin receptor, beta 2', other_designations='BK-2 receptor|kinin B2', map_location='12 55.76 cM', chromosome='12', genomic_nucleotide_accession_version='NC_000078.6', start_position_on_the_genomic_accession=105563172, end_position_on_the_genomic_accession=105595244, orientation='plus', exon_count=5, OMIM='', no_hdr0=''),
  12064 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12064, CurrentID=0, Status='live', Symbol='Bdnf', Aliases='', description='brain derived neurotrophic factor', other_designations='', map_location='2 56.63 cM', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=109674700, end_position_on_the_genomic_accession=109727043, orientation='plus', exon_count=9, OMIM='', no_hdr0=''),
  12067 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12067, CurrentID=0, Status='live', Symbol='Ube2n-ps1', Aliases='1500026J17Rik, Benh-ps1', description='ubiquitin-conjugating enzyme E2N, pseudogene 1', other_designations='bendless homolog, pseudogene 1', map_location='5 40.68 cM', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=76231885, end_position_on_the_genomic_accession=76233097, orientation='minus', exon_count=0, OMIM='', no_hdr0=''),
  12068 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12068, CurrentID=0, Status='live', Symbol='Bet1', Aliases='AW555236, Bet-1', description='Bet1 golgi vesicular membrane trafficking protein', other_designations='blocked early in transport 1 homolog|golgi vesicular membrane trafficking protein p18|golgi vesicular membrane-trafficking protein p18|mBET1', map_location='6 A1', chromosome='6', genomic_nucleotide_accession_version='NC_000072.6', start_position_on_the_genomic_accession=4076904, end_position_on_the_genomic_accession=4086995, orientation='minus', exon_count=5, OMIM='', no_hdr0=''),
  12069 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12069, CurrentID=0, Status='live', Symbol='Bex2', Aliases='AL024066, Bex1', description='brain expressed X-linked 2', other_designations='brain-expressed X-linked protein 2 homolog', map_location='X 57.37 cM', chromosome='X', genomic_nucleotide_accession_version='NC_000086.7', start_position_on_the_genomic_accession=136066565, end_position_on_the_genomic_accession=136068236, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  12070 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12070, CurrentID=0, Status='live', Symbol='Ngfrap1', Aliases='AL033356, Bex3, DXWsu67e, Gcap27, Nade', description='nerve growth factor receptor (TNFRSF16) associated protein 1', other_designations='brain expressed X-linked 3|brain-expressed X-linked protein 3 homolog|granule cell antiserum positive 27|nerve growth factor receptor-associated protein 1|p75NTR-associated Cell Death Executor', map_location='X 57.64 cM', chromosome='X', genomic_nucleotide_accession_version='NC_000086.7', start_position_on_the_genomic_accession=136270253, end_position_on_the_genomic_accession=136271978, orientation='plus', exon_count=3, OMIM='', no_hdr0=''),
  12075 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12075, CurrentID=0, Status='live', Symbol='Bfsp1', Aliases='CP95', description='beaded filament structural protein 1, in lens-CP94', other_designations='beaded filament structural protein in lens-CP94|lens fiber cell beaded-filament structural protein CP 95', map_location='2 G', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=143826528, end_position_on_the_genomic_accession=143915274, orientation='minus', exon_count=12, OMIM='', no_hdr0=''),
  67549 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=67549, CurrentID=0, Status='live', Symbol='Gpr89', Aliases='4933412D19Rika, SH120, Gpr89', description='G protein-coupled receptor 89', other_designations='protein GPR89', map_location='3 F2', chromosome='3', genomic_nucleotide_accession_version='NC_000069.6', start_position_on_the_genomic_accession=96871066, end_position_on_the_genomic_accession=96905343, orientation='minus', exon_count=14, OMIM='', no_hdr0=''),
  12091 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12091, CurrentID=0, Status='live', Symbol='Glb1', Aliases='AW125515, Bge, Bgl, Bgl-e, Bgl-s, Bgl-t, Bgs, Bgt, C130097A14Rik', description='galactosidase, beta 1', other_designations='acid beta-galactosidase|lactase', map_location='9 64.4 cM', chromosome='9', genomic_nucleotide_accession_version='NC_000075.6', start_position_on_the_genomic_accession=114401078, end_position_on_the_genomic_accession=114474379, orientation='plus', exon_count=16, OMIM='', no_hdr0=''),
  12095 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12095, CurrentID=0, Status='live', Symbol='Bglap3', Aliases='AI461847, Bglap-rs1, OC-X, ORG, mOC-X', description='bone gamma-carboxyglutamate protein 3', other_designations='bone gamma-carboxyglutamate protein, related sequence 1|gamma-carboxyglutamic acid-containing protein 3|nephrocalcin', map_location='3 38.81 cM', chromosome='3', genomic_nucleotide_accession_version='NC_000069.6', start_position_on_the_genomic_accession=88368615, end_position_on_the_genomic_accession=88372749, orientation='minus', exon_count=7, OMIM='', no_hdr0=''),
  12096 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12096, CurrentID=0, Status='live', Symbol='Bglap', Aliases='BGP1, OC, OG1, mOC-A, Bglap', description='bone gamma carboxyglutamate protein', other_designations='bone Gla protein|bone gamma carboxyglutamate protein 1|gamma-carboxyglutamic acid-containing protein', map_location='3 38.82 cM', chromosome='3', genomic_nucleotide_accession_version='NC_000069.6', start_position_on_the_genomic_accession=88383495, end_position_on_the_genomic_accession=88384466, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  12097 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12097, CurrentID=0, Status='live', Symbol='Bglap2', Aliases='BGP2, Bglap1, Bgp, Og2, mOC-B', description='bone gamma-carboxyglutamate protein 2', other_designations='bone Gla protein 2|gamma-carboxyglutamic acid-containing protein 2|osteocalcin', map_location='3 38.81 cM', chromosome='3', genomic_nucleotide_accession_version='NC_000069.6', start_position_on_the_genomic_accession=88377736, end_position_on_the_genomic_accession=88378699, orientation='minus', exon_count=4, OMIM='', no_hdr0=''),
  12111 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12111, CurrentID=0, Status='live', Symbol='Bgn', Aliases='BG, DSPG1, PG-S1, PGI, SLRR1A', description='biglycan', other_designations='bone/cartilage proteoglycan I', map_location='X B', chromosome='X', genomic_nucleotide_accession_version='NC_000086.7', start_position_on_the_genomic_accession=73483612, end_position_on_the_genomic_accession=73495936, orientation='plus', exon_count=9, OMIM='', no_hdr0=''),
  12116 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12116, CurrentID=0, Status='live', Symbol='Bhmt', Aliases='', description='betaine-homocysteine methyltransferase', other_designations='', map_location='13 D1', chromosome='13', genomic_nucleotide_accession_version='NC_000079.6', start_position_on_the_genomic_accession=93616891, end_position_on_the_genomic_accession=93637758, orientation='minus', exon_count=8, OMIM='', no_hdr0=''),
  12121 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12121, CurrentID=0, Status='live', Symbol='Bicd1', Aliases='B830009D06Rik', description='bicaudal D homolog 1 (Drosophila)', other_designations='bic-D 1', map_location='6 G3', chromosome='6', genomic_nucleotide_accession_version='NC_000072.6', start_position_on_the_genomic_accession=149408819, end_position_on_the_genomic_accession=149563329, orientation='plus', exon_count=11, OMIM='', no_hdr0=''),
  12122 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12122, CurrentID=0, Status='live', Symbol='Bid', Aliases='2700049M22Rik, AI875481, AU022477', description='BH3 interacting domain death agonist', other_designations='p22 BID', map_location='6 57.02 cM', chromosome='6', genomic_nucleotide_accession_version='NC_000072.6', start_position_on_the_genomic_accession=120893119, end_position_on_the_genomic_accession=120917142, orientation='minus', exon_count=9, OMIM='', no_hdr0=''),
  12123 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12123, CurrentID=0, Status='live', Symbol='Hrk', Aliases='AI838259, Bid3, DP5, harakiri', description='harakiri, BCL2 interacting protein (contains only BH3 domain)', other_designations='BH3 interacting (with BCL2 family) domain, apoptosis agonist|BH3-interacting domain-containing protein 3|neuronal death protein DP5', map_location='5 F', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=118169764, end_position_on_the_genomic_accession=118189478, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  12124 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12124, CurrentID=0, Status='live', Symbol='Bik', Aliases='Biklk, Blk, Nbk', description='BCL2-interacting killer', other_designations='apoptosis inducer NBK|bik-like killer protein', map_location='15 E1', chromosome='15', genomic_nucleotide_accession_version='NC_000081.6', start_position_on_the_genomic_accession=83526792, end_position_on_the_genomic_accession=83544635, orientation='plus', exon_count=9, OMIM='', no_hdr0=''),
  12125 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12125, CurrentID=0, Status='live', Symbol='Bcl2l11', Aliases='1500006F24Rik, Bim, Bod, bcl2-L-11', description='BCL2-like 11 (apoptosis facilitator)', other_designations='Bcl2 interacting mediator of cell death|bcl2-interacting mediator of cell death', map_location='2 F3-G1', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=128126038, end_position_on_the_genomic_accession=128162547, orientation='plus', exon_count=7, OMIM='', no_hdr0=''),
  12131 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12131, CurrentID=0, Status='live', Symbol='Bkm1', Aliases='Bkm-1', description='banded krait minor satellite DNA 1', other_designations='', map_location='', chromosome='Y', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  12140 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12140, CurrentID=0, Status='live', Symbol='Fabp7', Aliases='B-FABP, BFABP, Blbp, MRG', description='fatty acid binding protein 7, brain', other_designations='brain lipid binding protein|brain lipid-binding protein|brain-type fatty acid-binding protein|fatty acid-binding protein 7|mammary-derived growth inhibitor-related', map_location='10 B4', chromosome='10', genomic_nucleotide_accession_version='NC_000076.6', start_position_on_the_genomic_accession=57784923, end_position_on_the_genomic_accession=57788450, orientation='plus', exon_count=4, OMIM='', no_hdr0=''),
  12142 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12142, CurrentID=0, Status='live', Symbol='Prdm1', Aliases='Blimp-1, Blimp1, PRDI-BF1, ZNFPR1A1, b2b1765Clo', description='PR domain containing 1, with ZNF domain', other_designations='B lymphocyte induced maturation protein|B lymphocyte-induced maturation protein 1|PR domain containing 1 with ZNF domain|PR domain-containing protein 1|beta-interferon gene positive regulatory domain I-binding factor', map_location='10 23.24 cM', chromosome='10', genomic_nucleotide_accession_version='NC_000076.6', start_position_on_the_genomic_accession=44437174, end_position_on_the_genomic_accession=44528560, orientation='minus', exon_count=12, OMIM='', no_hdr0=''),
  12143 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12143, CurrentID=0, Status='live', Symbol='Blk', Aliases='', description='B lymphoid kinase', other_designations='b lymphocyte kinase|p55-Blk', map_location='14 33.25 cM', chromosome='14', genomic_nucleotide_accession_version='NC_000080.6', start_position_on_the_genomic_accession=63372831, end_position_on_the_genomic_accession=63417187, orientation='minus', exon_count=14, OMIM='', no_hdr0=''),
  12144 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12144, CurrentID=0, Status='live', Symbol='Blm', Aliases='', description='Bloom syndrome, RecQ helicase-like', other_designations='Bloom syndrome homolog|mBLM|recQ helicase homolog', map_location='7 45.65 cM', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=80454993, end_position_on_the_genomic_accession=80535119, orientation='minus', exon_count=23, OMIM='', no_hdr0=''),
  12145 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12145, CurrentID=0, Status='live', Symbol='Cxcr5', Aliases='Blr1, CXC-R5, CXCR-5, Gpcr6, MDR15', description='chemokine (C-X-C motif) receptor 5', other_designations='burkitt lymphoma receptor 1 homolog|chemochine (C-X-C motif) receptor 5', map_location='9 24.84 cM', chromosome='9', genomic_nucleotide_accession_version='NC_000075.6', start_position_on_the_genomic_accession=44511534, end_position_on_the_genomic_accession=44561874, orientation='minus', exon_count=4, OMIM='', no_hdr0=''),
  12151 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12151, CurrentID=0, Status='live', Symbol='Bmi1', Aliases='AW546694, Bmi-1, Pcgf4', description='Bmi1 polycomb ring finger oncogene', other_designations='B lymphoma Mo-MLV insertion region 1|polycomb group RING finger protein 4|polycomb group ring finger 4', map_location='2 12.9 cM', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=18677018, end_position_on_the_genomic_accession=18686629, orientation='plus', exon_count=12, OMIM='', no_hdr0=''),
  12153 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12153, CurrentID=0, Status='live', Symbol='Bmp1', Aliases='Pcp, Tld', description='bone morphogenetic protein 1', other_designations='mammalian tolloid protein|procollagen C-proteinase', map_location='14 36.32 cM', chromosome='14', genomic_nucleotide_accession_version='NC_000080.6', start_position_on_the_genomic_accession=70474555, end_position_on_the_genomic_accession=70520712, orientation='minus', exon_count=23, OMIM='', no_hdr0=''),
  12154 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12154, CurrentID=0, Status='live', Symbol='Bmp10', Aliases='', description='bone morphogenetic protein 10', other_designations='BMP-10', map_location='6 D2', chromosome='6', genomic_nucleotide_accession_version='NC_000072.6', start_position_on_the_genomic_accession=87429002, end_position_on_the_genomic_accession=87434512, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  12155 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12155, CurrentID=0, Status='live', Symbol='Bmp15', Aliases='AU015375, AU018861, AU021453, Bmp-15, C86824, C87336, GDF-9B', description='bone morphogenetic protein 15', other_designations='growth/differentiation factor 9B', map_location='X 2.81 cM', chromosome='X', genomic_nucleotide_accession_version='NC_000086.7', start_position_on_the_genomic_accession=6314106, end_position_on_the_genomic_accession=6320723, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  12156 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12156, CurrentID=0, Status='live', Symbol='Bmp2', Aliases='AI467020a, Bmp2', description='bone morphogenetic protein 2', other_designations='bone morphogenetic protein 2A', map_location='2 65.21 cM', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=133552159, end_position_on_the_genomic_accession=133562896, orientation='plus', exon_count=3, OMIM='', no_hdr0=''),
  12159 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12159, CurrentID=0, Status='live', Symbol='Bmp4', Aliases='Bmp-4, Bmp2b, Bmp2b-1, Bmp2b1', description='bone morphogenetic protein 4', other_designations='bone morphogenetic protein 2B', map_location='14 23.95 cM', chromosome='14', genomic_nucleotide_accession_version='NC_000080.6', start_position_on_the_genomic_accession=46383520, end_position_on_the_genomic_accession=46390599, orientation='minus', exon_count=8, OMIM='', no_hdr0=''),
  12160 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12160, CurrentID=0, Status='live', Symbol='Bmp5', Aliases='AU023399, se', description='bone morphogenetic protein 5', other_designations='', map_location='9 42.34 cM', chromosome='9', genomic_nucleotide_accession_version='NC_000075.6', start_position_on_the_genomic_accession=75775365, end_position_on_the_genomic_accession=75899017, orientation='plus', exon_count=7, OMIM='', no_hdr0=''),
  12161 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12161, CurrentID=0, Status='live', Symbol='Bmp6', Aliases='D13Wsu115e, Vgr1', description='bone morphogenetic protein 6', other_designations='VG-1-related protein', map_location='13 18.15 cM', chromosome='13', genomic_nucleotide_accession_version='NC_000079.6', start_position_on_the_genomic_accession=38345716, end_position_on_the_genomic_accession=38499728, orientation='plus', exon_count=7, OMIM='', no_hdr0=''),
  12162 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12162, CurrentID=0, Status='live', Symbol='Bmp7', Aliases='OP1', description='bone morphogenetic protein 7', other_designations='osteogenic protein 1', map_location='2 95.54 cM', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=172868012, end_position_on_the_genomic_accession=172940321, orientation='minus', exon_count=7, OMIM='', no_hdr0=''),
  12163 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12163, CurrentID=0, Status='live', Symbol='Bmp8a', Aliases='Bmp7r1, OP-2, OP2', description='bone morphogenetic protein 8a', other_designations='osteogenic protein 2', map_location='4 57.42 cM', chromosome='4', genomic_nucleotide_accession_version='NC_000070.6', start_position_on_the_genomic_accession=123312645, end_position_on_the_genomic_accession=123343252, orientation='minus', exon_count=7, OMIM='', no_hdr0=''),
  12164 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12164, CurrentID=0, Status='live', Symbol='Bmp8b', Aliases='Op3', description='bone morphogenetic protein 8b', other_designations='', map_location='4 57.38 cM', chromosome='4', genomic_nucleotide_accession_version='NC_000070.6', start_position_on_the_genomic_accession=123104307, end_position_on_the_genomic_accession=123126094, orientation='plus', exon_count=7, OMIM='', no_hdr0=''),
  12165 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12165, CurrentID=0, Status='live', Symbol='Gdf2', Aliases='Bmp9', description='growth differentiation factor 2', other_designations='BMP-9|GDF-2|bone morphogenetic protein 9', map_location='14 B', chromosome='14', genomic_nucleotide_accession_version='NC_000080.6', start_position_on_the_genomic_accession=33941039, end_position_on_the_genomic_accession=33947198, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  12166 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12166, CurrentID=0, Status='live', Symbol='Bmpr1a', Aliases='1110037I22Rik, ALK3, AU045487, BMPR-IA, Bmpr', description='bone morphogenetic protein receptor, type 1A', other_designations='ALK-3|BMP type-1A receptor|BMP-2/BMP-4 receptor|BMPR-1A|SKR5|activin receptor-like kinase 3|serine/threonine-protein kinase receptor R5', map_location='14 20.81 cM', chromosome='14', genomic_nucleotide_accession_version='NC_000080.6', start_position_on_the_genomic_accession=34411061, end_position_on_the_genomic_accession=34503532, orientation='minus', exon_count=14, OMIM='', no_hdr0=''),
  12167 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12167, CurrentID=0, Status='live', Symbol='Bmpr1b', Aliases='AI385617, ALK-6, AV355320, Acvrlk6, Alk6, BMPR-1B, BMPR-IB, CFK-43a, SKR6', description='bone morphogenetic protein receptor, type 1B', other_designations='BMP type-1B receptor|activin receptor-like kinase 6|serine/threonine-protein kinase receptor R6', map_location='3 H1', chromosome='3', genomic_nucleotide_accession_version='NC_000069.6', start_position_on_the_genomic_accession=141837136, end_position_on_the_genomic_accession=142169590, orientation='minus', exon_count=19, OMIM='', no_hdr0=''),
  12168 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12168, CurrentID=0, Status='live', Symbol='Bmpr2', Aliases='2610024H22Rik, AL117858, AW546137, BB189135, BMP-2, BMPR-2, BMPR-II, BMPRII, BRK-3, Gm20272', description='bone morphogenetic protein receptor, type II (serine/threonine kinase)', other_designations='BMP type II receptor|BMP type-2 receptor|bone morphogenic protein receptor, type II (serine/threonine kinase)', map_location='1 C1.3', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=59764270, end_position_on_the_genomic_accession=59878081, orientation='plus', exon_count=13, OMIM='', no_hdr0=''),
  12169 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12169, CurrentID=0, Status='live', Symbol='Bmx', Aliases='Etk, Etk/Bmx, Tyro8', description='BMX non-receptor tyrosine kinase', other_designations='TYRO8 protein tyrosine kinase 8|bone marrow tyrosine kinase gene in chromosome X protein homolog', map_location='X F', chromosome='X', genomic_nucleotide_accession_version='NC_000086.7', start_position_on_the_genomic_accession=164192842, end_position_on_the_genomic_accession=164258193, orientation='minus', exon_count=19, OMIM='', no_hdr0=''),
  12173 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12173, CurrentID=0, Status='live', Symbol='Bnc1', Aliases='AI047752, AW546376, Bnc', description='basonuclin 1', other_designations='', map_location='7 D3', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=81966657, end_position_on_the_genomic_accession=81992299, orientation='minus', exon_count=6, OMIM='', no_hdr0=''),
  12175 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12175, CurrentID=0, Status='live', Symbol='Bnip2', Aliases='5730523P12Rik, BNIP2beta, Nip21', description='BCL2/adenovirus E1B interacting protein 2', other_designations='BCL2/adenovirus E1B 19 kDa-interacting protein 2 beta|BCL2/adenovirus E1B 19kDa-interacting protein 1, NIP2|BCL2/adenovirus E1B interacting protein 1, NIP2', map_location='9 D', chromosome='9', genomic_nucleotide_accession_version='NC_000075.6', start_position_on_the_genomic_accession=69989425, end_position_on_the_genomic_accession=70011659, orientation='plus', exon_count=11, OMIM='', no_hdr0=''),
  12176 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12176, CurrentID=0, Status='live', Symbol='Bnip3', Aliases='Nip3', description='BCL2/adenovirus E1B interacting protein 3', other_designations='BCL2/adenovirus E1B 19 kDa-interacting protein 1, NIP3|BCL2/adenovirus E1B 19kDa-interacting protein 1, NIP3|BCL2/adenovirus E1B interacting protein 1, NIP3', map_location='7 F5', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=138890836, end_position_on_the_genomic_accession=138909506, orientation='minus', exon_count=6, OMIM='', no_hdr0=''),
  12177 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12177, CurrentID=0, Status='live', Symbol='Bnip3l', Aliases='C86132, D14Ertd719e, Nip3L, Nix', description='BCL2/adenovirus E1B interacting protein 3-like', other_designations='BCL2/adenovirus E1B 19 kDa-interacting protein 3-like|BCL2/adenovirus E1B 19kDa-interacting protein 3-like|NIP3-like protein X', map_location='14 34.6 cM', chromosome='14', genomic_nucleotide_accession_version='NC_000080.6', start_position_on_the_genomic_accession=66985238, end_position_on_the_genomic_accession=67008894, orientation='minus', exon_count=8, OMIM='', no_hdr0=''),
  12180 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12180, CurrentID=0, Status='live', Symbol='Smyd1', Aliases='4632404M21Rik, Bop, C78565, Zmynd18', description='SET and MYND domain containing 1', other_designations='CD8b-opposite|CD8beta opposite strand|SET and MYND domain-containing protein 1|m-BOP|zinc finger protein BOP', map_location='6 32.14 cM', chromosome='6', genomic_nucleotide_accession_version='NC_000072.6', start_position_on_the_genomic_accession=71213940, end_position_on_the_genomic_accession=71262281, orientation='minus', exon_count=10, OMIM='', no_hdr0=''),
  12181 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12181, CurrentID=0, Status='live', Symbol='Bop1', Aliases='AU020183, AW146150, D18861, Erb1p, Kiaa0124, mKIAA0124', description='block of proliferation 1', other_designations='block of proliferation 1 protein', map_location='15 35.91 cM', chromosome='15', genomic_nucleotide_accession_version='NC_000081.6', start_position_on_the_genomic_accession=76452996, end_position_on_the_genomic_accession=76477269, orientation='minus', exon_count=16, OMIM='', no_hdr0=''),
  12182 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12182, CurrentID=0, Status='live', Symbol='Bst1', Aliases='114/A10, A530073F09, BP-3, Bp3, Bsta1, CD157, Ly65', description='bone marrow stromal cell antigen 1', other_designations='ADP-ribosyl cyclase 2|BP-3 alloantigen|BST-1|antigen BP3|bone marrow stromal antigen 1|cADPr hydrolase 2|cyclic ADP-ribose hydrolase 2|leukocyte antigen 65|ly-65', map_location='5 23.84 cM', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=43818880, end_position_on_the_genomic_accession=43843468, orientation='plus', exon_count=9, OMIM='', no_hdr0=''),
  12183 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12183, CurrentID=0, Status='live', Symbol='Bpgm', Aliases='AI323730, AL022789, C86192', description='2,3-bisphosphoglycerate mutase', other_designations='2,3-bisphosphoglycerate mutase, erythrocyte|2,3-bisphosphoglycerate synthase|BPG-dependent PGAM', map_location='6 B1', chromosome='6', genomic_nucleotide_accession_version='NC_000072.6', start_position_on_the_genomic_accession=34476254, end_position_on_the_genomic_accession=34505610, orientation='plus', exon_count=3, OMIM='', no_hdr0=''),
  12189 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12189, CurrentID=0, Status='live', Symbol='Brca1', Aliases='', description='breast cancer 1, early onset', other_designations='breast cancer 1|breast cancer associated 1', map_location='11 D', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=101488754, end_position_on_the_genomic_accession=101551956, orientation='minus', exon_count=24, OMIM='', no_hdr0=''),
  12190 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12190, CurrentID=0, Status='live', Symbol='Brca2', Aliases='Fancd1, RAB163', description='breast cancer 2, early onset', other_designations='breast cancer 2|fanconi anemia group D1 protein homolog', map_location='5 89.52 cM', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=150522021, end_position_on_the_genomic_accession=150570147, orientation='plus', exon_count=27, OMIM='', no_hdr0=''),
  12192 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12192, CurrentID=0, Status='live', Symbol='Zfp36l1', Aliases='AW742437, AW743212, Berg36, Brf1, D530020L18Rik, ERF1, TIS11b, cMG1', description='zinc finger protein 36, C3H type-like 1', other_designations='butyrate response factor 1', map_location='12 C3', chromosome='12', genomic_nucleotide_accession_version='NC_000078.6', start_position_on_the_genomic_accession=80107760, end_position_on_the_genomic_accession=80113013, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  12193 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12193, CurrentID=0, Status='live', Symbol='Zfp36l2', Aliases='Brf2, ERF2, Tis11d', description='zinc finger protein 36, C3H type-like 2', other_designations='ZFP36-like 2|butyrate response factor 2', map_location='17 E4', chromosome='17', genomic_nucleotide_accession_version='NC_000083.6', start_position_on_the_genomic_accession=84183924, end_position_on_the_genomic_accession=84187947, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  12209 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12209, CurrentID=0, Status='live', Symbol='Brs3', Aliases='BRS-3', description='bombesin-like receptor 3', other_designations='', map_location='X A7.1-A7.2', chromosome='X', genomic_nucleotide_accession_version='NC_000086.7', start_position_on_the_genomic_accession=57043074, end_position_on_the_genomic_accession=57048758, orientation='plus', exon_count=4, OMIM='', no_hdr0=''),
  12211 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12211, CurrentID=0, Status='live', Symbol='Birc6', Aliases='A430032G04Rik, A430040A19Rik, AA501170, Bruce, D630005A10Rik, mKIAA1289', description='baculoviral IAP repeat-containing 6', other_designations='BIR repeat-containing ubiquitin-conjugating enzyme|apollon|baculovirus inhibitor of apoptosis repeat containing ubiquitin-conjugating enzyme|baculovirus inhibitor of apoptosis repeat containing ubiquitin-conjugating enzyme; accccbaculoviral IAP repeat-containing 6|ubiquitin-conjugating BIR domain enzyme apollon', map_location='17 E3', chromosome='17', genomic_nucleotide_accession_version='NC_000083.6', start_position_on_the_genomic_accession=74528216, end_position_on_the_genomic_accession=74703356, orientation='plus', exon_count=75, OMIM='', no_hdr0=''),
  12212 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12212, CurrentID=0, Status='live', Symbol='Chic1', Aliases='Brx', description='cysteine-rich hydrophobic domain 1', other_designations='brain X-linked protein|cystein-rich hydrophobic domain 1|cysteine-rich hydrophobic domain 1 protein', map_location='X 42.3 cM', chromosome='X', genomic_nucleotide_accession_version='NC_000086.7', start_position_on_the_genomic_accession=103356328, end_position_on_the_genomic_accession=103409096, orientation='plus', exon_count=7, OMIM='', no_hdr0=''),
  12215 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12215, CurrentID=0, Status='live', Symbol='Bsg', Aliases='AI115436, AI325119, CD147, EMMPRIN, HT-7', description='basigin', other_designations='5A11/Basigin|HT7 antigen|basic immunoglobulin superfamily|gp 42|membrane glycoprotein gp42|neurothelin', map_location='10 39.72 cM', chromosome='10', genomic_nucleotide_accession_version='NC_000076.6', start_position_on_the_genomic_accession=79704358, end_position_on_the_genomic_accession=79711979, orientation='plus', exon_count=8, OMIM='', no_hdr0=''),
  12217 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12217, CurrentID=0, Status='live', Symbol='Bsn', Aliases='', description='bassoon', other_designations='presynaptic cytomatrix protein', map_location='9 F', chromosome='9', genomic_nucleotide_accession_version='NC_000075.6', start_position_on_the_genomic_accession=108096022, end_position_on_the_genomic_accession=108191938, orientation='minus', exon_count=13, OMIM='', no_hdr0=''),
  12223 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12223, CurrentID=0, Status='live', Symbol='Btc', Aliases='Bcn', description='betacellulin, epidermal growth factor family member', other_designations='probetacellulin', map_location='5 44.78 cM', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=91357261, end_position_on_the_genomic_accession=91402994, orientation='minus', exon_count=6, OMIM='', no_hdr0=''),
  12224 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12224, CurrentID=0, Status='live', Symbol='Klf5', Aliases='4930520J07Rik, Bteb2, CKLF, IKLF', description='Kruppel-like factor 5', other_designations='BTE-binding protein 2|basic transcription element binding protein 2|basic transcription element-binding protein 2|intestinal-enriched krueppel-like factor|transcription factor BTEB2', map_location='14 E2.2', chromosome='14', genomic_nucleotide_accession_version='NC_000080.6', start_position_on_the_genomic_accession=99298691, end_position_on_the_genomic_accession=99313412, orientation='plus', exon_count=4, OMIM='', no_hdr0=''),
  12226 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12226, CurrentID=0, Status='live', Symbol='Btg1', Aliases='AI426953, AW546738', description='B cell translocation gene 1, anti-proliferative', other_designations='B-cell translocation gene 1 protein|B-cell translocation gene 1, anti-proliferative', map_location='10 C3', chromosome='10', genomic_nucleotide_accession_version='NC_000076.6', start_position_on_the_genomic_accession=96617001, end_position_on_the_genomic_accession=96622813, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  12227 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12227, CurrentID=0, Status='live', Symbol='Btg2', Aliases='AA959598, APRO1, Pc3, TIS21', description='B cell translocation gene 2, anti-proliferative', other_designations='B-cell translocation gene 2, anti-proliferative|BTG family member 2|NGF-inducible protein TIS21', map_location='1 58.1 cM', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=134074865, end_position_on_the_genomic_accession=134079155, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  12228 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12228, CurrentID=0, Status='live', Symbol='Btg3', Aliases='ANA, tob5', description='B cell translocation gene 3', other_designations='BTG family member 3|abundant in neuroepithelium area protein', map_location='16 C3.1', chromosome='16', genomic_nucleotide_accession_version='NC_000082.6', start_position_on_the_genomic_accession=78359860, end_position_on_the_genomic_accession=78377181, orientation='minus', exon_count=6, OMIM='', no_hdr0=''),
  12229 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12229, CurrentID=0, Status='live', Symbol='Btk', Aliases='AI528679, xid', description='Bruton agammaglobulinemia tyrosine kinase', other_designations="ATK|B-cell progenitor kinase|BPK|Bruton's tyrosine kinase|Tyrosine-protein kinase BTK (Brutons tyrosine kinase) (Agammaglobulinaemia tyrosine kinase) (ATK) (B cell progenitor kinase) (BPK) (Kinase EMB)|X-linked immune deficiency|agammaglobulinaemia tyrosine kinase|agammaglobulinemia tyrosine kinase|bruton tyrosine kinase|kinase EMB", map_location='X 56.18 cM', chromosome='X', genomic_nucleotide_accession_version='NC_000086.7', start_position_on_the_genomic_accession=134542334, end_position_on_the_genomic_accession=134583623, orientation='minus', exon_count=21, OMIM='', no_hdr0=''),
  12231 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12231, CurrentID=0, Status='live', Symbol='Btn1a1', Aliases='Btn', description='butyrophilin, subfamily 1, member A1', other_designations='BT', map_location='13 9.72 cM', chromosome='13', genomic_nucleotide_accession_version='NC_000079.6', start_position_on_the_genomic_accession=23456984, end_position_on_the_genomic_accession=23465914, orientation='minus', exon_count=8, OMIM='', no_hdr0=''),
  12234 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12234, CurrentID=0, Status='live', Symbol='Btrc', Aliases='Beta-Trcp1, E3RS-IkappaB, E3RSIkappaB, FWD1, Fbw1a, HOS, Slimb, b-TrCP, beta-TrCP', description='beta-transducin repeat containing protein', other_designations='E3RSIkappaB|HOS|SCF b-TRCP|beta-TrCP|btrc', map_location='19 D1', chromosome='19', genomic_nucleotide_accession_version='NC_000085.6', start_position_on_the_genomic_accession=45363714, end_position_on_the_genomic_accession=45533343, orientation='plus', exon_count=21, OMIM='', no_hdr0=''),
  12235 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12235, CurrentID=0, Status='live', Symbol='Bub1', Aliases='AL022991a, C80208, D2Xrf87, Bub1', description='BUB1, mitotic checkpoint serine/threonine kinase', other_designations='budding uninhibited by benzimidazoles 1 homolog|mBUB1', map_location='2 62.1 cM', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=127800200, end_position_on_the_genomic_accession=127831876, orientation='minus', exon_count=25, OMIM='', no_hdr0=''),
  12236 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12236, CurrentID=0, Status='live', Symbol='Bub1b', Aliases='AU045529, BUBR1', description='BUB1B, mitotic checkpoint serine/threonine kinase', other_designations='MAD3/BUB1-related protein kinase|budding uninhibited by benzimidazoles 1 beta|budding uninhibited by benzimidazoles 1 homolog, beta|mitotic checkpoint kinase MAD3L', map_location='2 E5', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=118598203, end_position_on_the_genomic_accession=118641592, orientation='plus', exon_count=23, OMIM='', no_hdr0=''),
  12237 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12237, CurrentID=0, Status='live', Symbol='Bub3', Aliases='AU019800, AU021329, AU043350, AW146323, C78067', description='BUB3 mitotic checkpoint protein', other_designations='WD repeat type I transmembrane protein A72.5|budding uninhibited by benzimidazoles 3 homolog', map_location='7 74.36 cM', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=131560370, end_position_on_the_genomic_accession=131571898, orientation='plus', exon_count=10, OMIM='', no_hdr0=''),
  12238 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12238, CurrentID=0, Status='live', Symbol='Commd3', Aliases='AW550818, Bup, D2Ertd542e', description='COMM domain containing 3', other_designations='Bmi1 upstream|bmi-1 upstream gene protein', map_location='2 12.9 cM', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=18672462, end_position_on_the_genomic_accession=18676216, orientation='plus', exon_count=8, OMIM='', no_hdr0=''),
  667612 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=667612, CurrentID=0, Status='live', Symbol='Ncr3-ps', Aliases='1C7, EG667612, Gm8726, Ly117, Ncr3', description='natural cytotoxicity triggering receptor 3, pseudogene', other_designations='lymphocyte antigen 117', map_location='17', chromosome='17', genomic_nucleotide_accession_version='NC_000083.6', start_position_on_the_genomic_accession=35180536, end_position_on_the_genomic_accession=35184809, orientation='plus', exon_count=0, OMIM='', no_hdr0=''),
  111269 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=111269, CurrentID=0, Status='live', Symbol='Hprt-ps1', Aliases='D17Rp10, RP10', description='hypoxanthine guanine phosphoribosyl transferase pseudogene 1', other_designations='', map_location='', chromosome='17', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  12256 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12256, CurrentID=0, Status='live', Symbol='Bxv1', Aliases='Bxv-1, Xmv-43, Xmv43', description='B10 xenotropic virus 1', other_designations='', map_location='', chromosome='1', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  12257 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12257, CurrentID=0, Status='live', Symbol='Tspo', Aliases='Bzrp, IBP, PBR1, Tspo', description='translocator protein', other_designations='PKBS|benzodiazepine receptor, peripheral|isoquinoline-binding protein|mitochondrial benzodiazepine receptor|peripheral-type benzodiazepine receptor', map_location='15 39.4 cM', chromosome='15', genomic_nucleotide_accession_version='NC_000081.6', start_position_on_the_genomic_accession=83563573, end_position_on_the_genomic_accession=83574203, orientation='plus', exon_count=4, OMIM='', no_hdr0=''),
  12258 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12258, CurrentID=0, Status='live', Symbol='Serping1', Aliases='C1INH, C1nh', description='serine (or cysteine) peptidase inhibitor, clade G, member 1', other_designations='C1 Inh|C1 esterase inhibitor|C1 inhibitor|C1-inhibiting factor|complement component 1 inhibitor|serine (or cysteine) proteinase inhibitor, clade G (C1 inhibitor), member 1|serine (or cysteine) proteinase inhibitor, clade G, member 1|serpin G1', map_location='2 D', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=84765360, end_position_on_the_genomic_accession=84775445, orientation='minus', exon_count=8, OMIM='', no_hdr0=''),
  12259 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12259, CurrentID=0, Status='live', Symbol='C1qa', Aliases='AI255395, C1q', description='complement component 1, q subcomponent, alpha polypeptide', other_designations='', map_location='4 69.05 cM', chromosome='4', genomic_nucleotide_accession_version='NC_000070.6', start_position_on_the_genomic_accession=136895916, end_position_on_the_genomic_accession=136898844, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  12260 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12260, CurrentID=0, Status='live', Symbol='C1qb', Aliases='', description='complement component 1, q subcomponent, beta polypeptide', other_designations='', map_location='4 69.05 cM', chromosome='4', genomic_nucleotide_accession_version='NC_000070.6', start_position_on_the_genomic_accession=136880145, end_position_on_the_genomic_accession=136886177, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  12261 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12261, CurrentID=0, Status='live', Symbol='C1qbp', Aliases='AA407365, AA986492, D11Wsu182e, HABP1, P32, gC1qBP', description='complement component 1, q subcomponent binding protein', other_designations='GC1q-R protein|glycoprotein gC1qBP', map_location='11 43.21 cM', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=70977846, end_position_on_the_genomic_accession=70983026, orientation='minus', exon_count=6, OMIM='', no_hdr0=''),
  12262 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12262, CurrentID=0, Status='live', Symbol='C1qc', Aliases='AI385742, C1qg, Ciqc', description='complement component 1, q subcomponent, C chain', other_designations='complement component 1, q subcomponent, c polypeptide|complement component 1, q subcomponent, gamma polypeptide', map_location='4 69.05 cM', chromosome='4', genomic_nucleotide_accession_version='NC_000070.6', start_position_on_the_genomic_accession=136889802, end_position_on_the_genomic_accession=136892914, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  12263 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12263, CurrentID=0, Status='live', Symbol='C2', Aliases='', description='complement component 2 (within H-2S)', other_designations='MHC complement component C2|classical-complement pathway C3/C5 convertase|complement factor C2', map_location='17 18.41 cM', chromosome='17', genomic_nucleotide_accession_version='NC_000083.6', start_position_on_the_genomic_accession=34862602, end_position_on_the_genomic_accession=34882100, orientation='minus', exon_count=18, OMIM='', no_hdr0=''),
  12265 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12265, CurrentID=0, Status='live', Symbol='Ciita', Aliases='C2ta, EG669998, Gm9475, Mhc2ta', description='class II transactivator', other_designations='', map_location='16 A1', chromosome='16', genomic_nucleotide_accession_version='NC_000082.6', start_position_on_the_genomic_accession=10480015, end_position_on_the_genomic_accession=10528606, orientation='plus', exon_count=24, OMIM='', no_hdr0=''),
  12266 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12266, CurrentID=0, Status='live', Symbol='C3', Aliases='AI255234, ASP, HSE-MSF, Plp', description='complement component 3', other_designations='acylation stimulating protein|complement component 3d|complement factor 3', map_location='17 E1-E3', chromosome='17', genomic_nucleotide_accession_version='NC_000083.6', start_position_on_the_genomic_accession=57203968, end_position_on_the_genomic_accession=57228136, orientation='minus', exon_count=42, OMIM='', no_hdr0=''),
  12267 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12267, CurrentID=0, Status='live', Symbol='C3ar1', Aliases='AZ3B, C3AR, HNFAG09', description='complement component 3a receptor 1', other_designations='C3a-R|anaphylatoxin C3a receptor', map_location='6 F1', chromosome='6', genomic_nucleotide_accession_version='NC_000072.6', start_position_on_the_genomic_accession=122847140, end_position_on_the_genomic_accession=122856157, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  12268 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12268, CurrentID=0, Status='live', Symbol='C4b', Aliases='C4, Ss', description='complement component 4B (Chido blood group)', other_designations='complement component 4 (within H-2S)|complement component 4B (Childo blood group)', map_location='17 18.29 cM', chromosome='17', genomic_nucleotide_accession_version='NC_000083.6', start_position_on_the_genomic_accession=34728046, end_position_on_the_genomic_accession=34743901, orientation='minus', exon_count=42, OMIM='', no_hdr0=''),
  12269 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12269, CurrentID=0, Status='live', Symbol='C4bp', Aliases='AI195242a, C4bp', description='complement component 4 binding protein', other_designations='', map_location='1 56.89 cM', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=130635921, end_position_on_the_genomic_accession=130661618, orientation='minus', exon_count=11, OMIM='', no_hdr0=''),
  12270 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12270, CurrentID=0, Status='live', Symbol='C4bp-ps1', Aliases='C4bpb', description='complement component 4 binding protein, pseudogene 1', other_designations='', map_location='1 56.89 cM', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=130670202, end_position_on_the_genomic_accession=130681571, orientation='minus', exon_count=6, OMIM='', no_hdr0=''),
  12273 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12273, CurrentID=0, Status='live', Symbol='C5ar1', Aliases='C5aR, C5r1, Cd88, D7Msu1', description='complement component 5a receptor 1', other_designations='C5a anaphylatoxin receptor|C5a ligand|C5a-R|complement component 5, receptor 1', map_location='7 8.77 cM', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=16246743, end_position_on_the_genomic_accession=16259540, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  12274 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12274, CurrentID=0, Status='live', Symbol='C6', Aliases='AW111623', description='complement component 6', other_designations='', map_location='15 1.97 cM', chromosome='15', genomic_nucleotide_accession_version='NC_000081.6', start_position_on_the_genomic_accession=4727068, end_position_on_the_genomic_accession=4823967, orientation='plus', exon_count=21, OMIM='', no_hdr0=''),
  12279 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12279, CurrentID=0, Status='live', Symbol='C9', Aliases='', description='complement component 9', other_designations='', map_location='15 A1', chromosome='15', genomic_nucleotide_accession_version='NC_000081.6', start_position_on_the_genomic_accession=6445333, end_position_on_the_genomic_accession=6498476, orientation='plus', exon_count=11, OMIM='', no_hdr0=''),
  12281 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12281, CurrentID=0, Status='live', Symbol='cab', Aliases='', description='cardiac abnormality', other_designations='', map_location='', chromosome='', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  12282 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12282, CurrentID=0, Status='live', Symbol='Hyou1', Aliases='AI415631, CBP-140, Cab140, Grp170, Orp150', description='hypoxia up-regulated 1', other_designations='140 kDa Ca(2+)-binding protein|150-kDa oxygen regulated protein|170 kDa glucose regulated protein GRP170|GRP-170|calcium binding protein 140|calcium binding protein, 140 kDa', map_location='9 B', chromosome='9', genomic_nucleotide_accession_version='NC_000075.6', start_position_on_the_genomic_accession=44379490, end_position_on_the_genomic_accession=44392369, orientation='plus', exon_count=26, OMIM='', no_hdr0=''),
  12283 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12283, CurrentID=0, Status='live', Symbol='Cab39', Aliases='AA408805, AA960512, C78372, MO25, MO25alpha', description='calcium binding protein 39', other_designations='calcium binding protein, 39 kDa', map_location='1 C5', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=85793410, end_position_on_the_genomic_accession=85851577, orientation='plus', exon_count=11, OMIM='', no_hdr0=''),
  12285 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12285, CurrentID=0, Status='live', Symbol='cac', Aliases='cat', description='recessive cataract', other_designations='', map_location='', chromosome='', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  12286 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12286, CurrentID=0, Status='live', Symbol='Cacna1a', Aliases='APCA, BI, Caca1a, Cacnl1a4, Cav2.1, Ccha1a, EA2, FHM, HPCA, MHP, MHP1, SCA6, alpha1A, la, nmf352, rkr, smrl, tg', description='calcium channel, voltage-dependent, P/Q type, alpha 1A subunit', other_designations='brain calcium channel I|calcium channel, L type, alpha-1 polypeptide|leaner|rocker|tottering|voltage-gated calcium channel subunit alpha Cav2.1', map_location='8 40.95 cM', chromosome='8', genomic_nucleotide_accession_version='NC_000074.6', start_position_on_the_genomic_accession=84338633, end_position_on_the_genomic_accession=84640249, orientation='plus', exon_count=55, OMIM='', no_hdr0=''),
  12287 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12287, CurrentID=0, Status='live', Symbol='Cacna1b', Aliases='AW050276, AW060892, AW822256, Cav2.2, Cchn1a, alpha(1B)', description='calcium channel, voltage-dependent, N type, alpha 1B subunit', other_designations='BIII|brain calcium channel III|calcium channel, L type, alpha-1 polypeptide|calcium channel, voltage-dependent, L type, alpha 1B subunit|voltage-gated calcium channel subunit alpha Cav2.2', map_location='2 A2', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=24603860, end_position_on_the_genomic_accession=24763195, orientation='minus', exon_count=52, OMIM='', no_hdr0=''),
  12288 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12288, CurrentID=0, Status='live', Symbol='Cacna1c', Aliases='Cav1.2, Cchl1a1, D930026N18Rik, MBC, MELC-CC', description='calcium channel, voltage-dependent, L type, alpha 1C subunit', other_designations='brain class C|calcium channel voltage-dependent alpha1c subunit|calcium channel, L type, alpha-1 polypeptide, isoform 1, cardiac muscle|neuronal voltage-gated calcium channel alpha 1C subunit|skeletal muscle-specific calcium channel|voltage-gated calcium channel subunit alpha Cav1.2', map_location='6 55.86 cM', chromosome='6', genomic_nucleotide_accession_version='NC_000072.6', start_position_on_the_genomic_accession=118587240, end_position_on_the_genomic_accession=119198921, orientation='minus', exon_count=53, OMIM='', no_hdr0=''),
  12289 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12289, CurrentID=0, Status='live', Symbol='Cacna1d', Aliases='8430418G19Rik, C79217, Cach3, Cacn4, Cacnl1a2, Cav1.3, Cchl1a, Cchl1a2, D-LTCC', description='calcium channel, voltage-dependent, L type, alpha 1D subunit', other_designations='Cav1.3alpha1|alpha 1 E|calcium channel, L type, alpha-1 polypeptide|voltage-gated calcium channel subunit alpha Cav1.3', map_location='14 B', chromosome='14', genomic_nucleotide_accession_version='NC_000080.6', start_position_on_the_genomic_accession=30039941, end_position_on_the_genomic_accession=30492363, orientation='minus', exon_count=54, OMIM='', no_hdr0=''),
  12290 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12290, CurrentID=0, Status='live', Symbol='Cacna1e', Aliases='A430040I15, BII, Cach6, Cacnl1a6, Cav2.3, Cchra1, alpha1E', description='calcium channel, voltage-dependent, R type, alpha 1E subunit', other_designations='brain calcium channel II|calcium channel, L type, alpha-1 polypeptide|calcium channel, voltage-dependent, L type, alpha 1E subunit|voltage-gated calcium channel subunit alpha Cav2.3', map_location='1 66.14 cM', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=154390806, end_position_on_the_genomic_accession=154884782, orientation='minus', exon_count=54, OMIM='', no_hdr0=''),
  12291 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12291, CurrentID=0, Status='live', Symbol='Cacna1g', Aliases='Cav3.1d, [a]1G, a1G, alpha-1G, mKIAA1123', description='calcium channel, voltage-dependent, T type, alpha 1G subunit', other_designations='', map_location='11 D', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=94408391, end_position_on_the_genomic_accession=94474390, orientation='minus', exon_count=39, OMIM='', no_hdr0=''),
  12292 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12292, CurrentID=0, Status='live', Symbol='Cacna1s', Aliases='AW493108, Cav1.1, Cchl1a3, fmd, mdg, sj', description='calcium channel, voltage-dependent, L type, alpha 1S subunit', other_designations='DHPR alpha1s|calcium channel, L type, alpha-1 polypeptide, isoform 3, skeletal muscle|dihydropyridine receptor alpha 1S|muscle dysgenesis|voltage-gated calcium channel subunit alpha Cav1.1', map_location='1 F', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=136052805, end_position_on_the_genomic_accession=136119822, orientation='plus', exon_count=46, OMIM='', no_hdr0=''),
  12293 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12293, CurrentID=0, Status='live', Symbol='Cacna2d1', Aliases='Ca(v)alpha2delta1, Cacna2, Cchl2a', description='calcium channel, voltage-dependent, alpha2/delta subunit 1', other_designations='dihydropyridine-sensitive calcium channel alpha 2|voltage-gated calcium channel subunit alpha-2/delta-1', map_location='5 6.56 cM', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=15934691, end_position_on_the_genomic_accession=16374511, orientation='plus', exon_count=44, OMIM='', no_hdr0=''),
  12294 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12294, CurrentID=0, Status='live', Symbol='Cacna2d3', Aliases='Cacnad3, alapha2delta3', description='calcium channel, voltage-dependent, alpha2/delta subunit 3', other_designations='calcium channel, voltage dependent, alpha2/delta subunit 3|voltage-gated calcium channel subunit alpha-2/delta-3', map_location='14 B', chromosome='14', genomic_nucleotide_accession_version='NC_000080.6', start_position_on_the_genomic_accession=28904943, end_position_on_the_genomic_accession=29721864, orientation='minus', exon_count=38, OMIM='', no_hdr0=''),
  12295 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12295, CurrentID=0, Status='live', Symbol='Cacnb1', Aliases='CAB1, Cchb1, Cchlb1', description='calcium channel, voltage-dependent, beta 1 subunit', other_designations='calcium channel voltage-dependent subunit beta 1|voltage-dependent calcium channel beta1 subunit', map_location='11 61.5 cM', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=98001508, end_position_on_the_genomic_accession=98022975, orientation='minus', exon_count=18, OMIM='', no_hdr0=''),
  12296 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12296, CurrentID=0, Status='live', Symbol='Cacnb2', Aliases='AW060387, CAB2, Cavbeta2, Cchb2', description='calcium channel, voltage-dependent, beta 2 subunit', other_designations='voltage-gated calcium channel beta2 subunit transcript variant X13', map_location='2 10.7 cM', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=14604049, end_position_on_the_genomic_accession=14988811, orientation='plus', exon_count=20, OMIM='', no_hdr0=''),
  12297 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12297, CurrentID=0, Status='live', Symbol='Cacnb3', Aliases='Beta3, CAB3, Ca(v)beta3, Cchb3', description='calcium channel, voltage-dependent, beta 3 subunit', other_designations='calcium channel voltage-dependent subunit beta 3', map_location='15 54.64 cM', chromosome='15', genomic_nucleotide_accession_version='NC_000081.6', start_position_on_the_genomic_accession=98626873, end_position_on_the_genomic_accession=98644536, orientation='plus', exon_count=21, OMIM='', no_hdr0=''),
  12298 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12298, CurrentID=0, Status='live', Symbol='Cacnb4', Aliases='3110038O15Rik, Cchb4, lh', description='calcium channel, voltage-dependent, beta 4 subunit', other_designations='CAB4|calcium channel voltage-dependent subunit beta 4', map_location='2 29.98 cM', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=52428320, end_position_on_the_genomic_accession=52676609, orientation='minus', exon_count=17, OMIM='', no_hdr0=''),
  12299 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12299, CurrentID=0, Status='live', Symbol='Cacng1', Aliases='', description='calcium channel, voltage-dependent, gamma subunit 1', other_designations='dihydropyridine receptor gamma 1|dihydropyridine-sensitive L-type, skeletal muscle calcium channel subunit gamma', map_location='11 E1', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=107703218, end_position_on_the_genomic_accession=107716476, orientation='minus', exon_count=4, OMIM='', no_hdr0=''),
  12300 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12300, CurrentID=0, Status='live', Symbol='Cacng2', Aliases='AW060990, B230105C07Rik, B930041E13Rik, stargazer, stargazin, stg, wag, waggler', description='calcium channel, voltage-dependent, gamma subunit 2', other_designations='TARP gamma 2|TARP gamma-2|neuronal voltage-gated calcium channel gamma-2 subunit|transmembrane AMPAR regulatory protein gamma-2', map_location='15 36.92 cM', chromosome='15', genomic_nucleotide_accession_version='NC_000081.6', start_position_on_the_genomic_accession=77993623, end_position_on_the_genomic_accession=78119280, orientation='minus', exon_count=5, OMIM='', no_hdr0=''),
  12301 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12301, CurrentID=0, Status='live', Symbol='Cacybp', Aliases='SIP', description='calcyclin binding protein', other_designations='siah-interacting protein', map_location='1 H1', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=160202367, end_position_on_the_genomic_accession=160212892, orientation='minus', exon_count=6, OMIM='', no_hdr0=''),
  667663 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=667663, CurrentID=0, Status='live', Symbol='Myo3a', Aliases='9030416P08Rik', description='myosin IIIA', other_designations='', map_location='2 A3', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=22542413, end_position_on_the_genomic_accession=22618252, orientation='plus', exon_count=34, OMIM='', no_hdr0=''),
  12304 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12304, CurrentID=0, Status='live', Symbol='Pdia4', Aliases='AI987846, Cai, ERp-72, Erp72', description='protein disulfide isomerase associated 4', other_designations='ER protein 72|calcium binding protein, intestinal|endoplasmic reticulum protein 72|endoplasmic reticulum resident protein 72', map_location='6 22.94 cM', chromosome='6', genomic_nucleotide_accession_version='NC_000072.6', start_position_on_the_genomic_accession=47796141, end_position_on_the_genomic_accession=47813512, orientation='minus', exon_count=11, OMIM='', no_hdr0=''),
  12305 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12305, CurrentID=0, Status='live', Symbol='Ddr1', Aliases='6030432F18, AI323681, CD167a, Cak, Nep, PTK3A', description='discoidin domain receptor family, member 1', other_designations='CD167 antigen-like family member A|cell adhesion kinase|discoidin receptor tyrosine kinase|epithelial discoidin domain receptor 1|protein-tyrosine kinase MPK-6|tyrosine kinase DDR|tyrosine-protein kinase CAK', map_location='17 18.7 cM', chromosome='17', genomic_nucleotide_accession_version='NC_000083.6', start_position_on_the_genomic_accession=35681567, end_position_on_the_genomic_accession=35704629, orientation='minus', exon_count=25, OMIM='', no_hdr0=''),
  12306 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12306, CurrentID=0, Status='live', Symbol='Anxa2', Aliases='AW215814, Cal1h', description='annexin A2', other_designations='33-kDa calcimedin|33-kDa lymphocyte Ca<2+>- binding protein|33kDa lymphocyte Ca<2+>- binding protein|36-kDa calelectrin|PAP-IV|annexin II|annexin-2|calpactin I heavy chain|calpactin-1 heavy chain|chromobindin 8|chromobindin-8|lipocortin II|p36|placental anticoagulant protein IV|protein I', map_location='9 38.58 cM', chromosome='9', genomic_nucleotide_accession_version='NC_000075.6', start_position_on_the_genomic_accession=69453683, end_position_on_the_genomic_accession=69491795, orientation='plus', exon_count=14, OMIM='', no_hdr0=''),
  12307 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12307, CurrentID=0, Status='live', Symbol='Calb1', Aliases='Brain-2, CB, Calb, Calb-1', description='calbindin 1', other_designations='CalbindinD28K|D-28K|PCD-29|calbindin 1, 28kDa|calbindin D28|calbindin-28K|calbindin-D (28k)|spot 35 protein|vitamin D-dependent calcium-binding protein, avian-type', map_location='4 6.66 cM', chromosome='4', genomic_nucleotide_accession_version='NC_000070.6', start_position_on_the_genomic_accession=15881264, end_position_on_the_genomic_accession=15906709, orientation='plus', exon_count=11, OMIM='', no_hdr0=''),
  12308 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12308, CurrentID=0, Status='live', Symbol='Calb2', Aliases='CR', description='calbindin 2', other_designations='', map_location='8 E1', chromosome='8', genomic_nucleotide_accession_version='NC_000074.6', start_position_on_the_genomic_accession=110142538, end_position_on_the_genomic_accession=110168206, orientation='minus', exon_count=11, OMIM='', no_hdr0=''),
  12309 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12309, CurrentID=0, Status='live', Symbol='S100g', Aliases='AU042539, CABP1, CaBP-D9K, Cabp9k, Calb3', description='S100 calcium binding protein G', other_designations="CABP|S100 calcium-binding protein G|calbindin 3, (vitamin D-dependent calcium binding protein)|calbindin D9k|calbindin-D9K major form|cytidine 5'-triphosphate synthase 2|vitamin D-dependent calcium-binding protein, intestinal", map_location='X F4', chromosome='X', genomic_nucleotide_accession_version='NC_000086.7', start_position_on_the_genomic_accession=162961992, end_position_on_the_genomic_accession=162964599, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  12310 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12310, CurrentID=0, Status='live', Symbol='Calca', Aliases='CA, CGRP-1, CGRP1, Calc, Calc1, Cgrp, Ct, Ctn', description='calcitonin/calcitonin-related polypeptide, alpha', other_designations='alpha-type CGRP|calcitonin gene-related peptide I', map_location='7 59.99 cM', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=114625985, end_position_on_the_genomic_accession=114636460, orientation='minus', exon_count=7, OMIM='', no_hdr0=''),
  12311 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12311, CurrentID=0, Status='live', Symbol='Calcr', Aliases='Clr', description='calcitonin receptor', other_designations='CT-R', map_location='6 1.81 cM', chromosome='6', genomic_nucleotide_accession_version='NC_000072.6', start_position_on_the_genomic_accession=3685720, end_position_on_the_genomic_accession=3764732, orientation='minus', exon_count=17, OMIM='', no_hdr0=''),
  12313 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12313, CurrentID=0, Status='live', Symbol='Calm1', Aliases='AI256814, AI327027, AI461935, AL024000, CaM, Calm', description='calmodulin 1', other_designations='', map_location='12 E', chromosome='12', genomic_nucleotide_accession_version='NC_000078.6', start_position_on_the_genomic_accession=100199541, end_position_on_the_genomic_accession=100209806, orientation='plus', exon_count=6, OMIM='', no_hdr0=''),
  12314 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12314, CurrentID=0, Status='live', Symbol='Calm2', Aliases='1500001E21Rik, AL024017', description='calmodulin 2', other_designations='caM', map_location='17 E4', chromosome='17', genomic_nucleotide_accession_version='NC_000083.6', start_position_on_the_genomic_accession=87433401, end_position_on_the_genomic_accession=87446935, orientation='minus', exon_count=6, OMIM='', no_hdr0=''),
  12315 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12315, CurrentID=0, Status='live', Symbol='Calm3', Aliases='CaMA, R75142', description='calmodulin 3', other_designations='caM', map_location='7 9.15 cM', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=16915379, end_position_on_the_genomic_accession=16924032, orientation='minus', exon_count=6, OMIM='', no_hdr0=''),
  12316 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12316, CurrentID=0, Status='live', Symbol='Aspm', Aliases='Calmbp1, D330028K02Rik, MCPH5, Sha1', description='asp (abnormal spindle)-like, microcephaly associated (Drosophila)', other_designations='calmodulin binding protein 1|calmodulin-binding protein 1|calmodulin-binding protein Sha1|spindle and hydroxyurea checkpoint abnormal protein', map_location='1 F', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=139454773, end_position_on_the_genomic_accession=139494091, orientation='plus', exon_count=29, OMIM='', no_hdr0=''),
  12317 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12317, CurrentID=0, Status='live', Symbol='Calr', Aliases='CRTegulin, Calr', description='calreticulin', other_designations='CRP55|ERp60|HACBP|endoplasmic reticulum resident protein 60', map_location='8 41.21 cM', chromosome='8', genomic_nucleotide_accession_version='NC_000074.6', start_position_on_the_genomic_accession=84842088, end_position_on_the_genomic_accession=84846931, orientation='minus', exon_count=9, OMIM='', no_hdr0=''),
  12319 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12319, CurrentID=0, Status='live', Symbol='Car8', Aliases='AW546993, Ca8, Cals, Cals1, Carp, wdl', description='carbonic anhydrase 8', other_designations='CA-RP VIII|CA-VIII|carbonic anhydrase VIII|carbonic anhydrase-like sequence 1', map_location='4 3.53 cM', chromosome='4', genomic_nucleotide_accession_version='NC_000070.6', start_position_on_the_genomic_accession=8141493, end_position_on_the_genomic_accession=8239041, orientation='minus', exon_count=9, OMIM='', no_hdr0=''),
  12321 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12321, CurrentID=0, Status='live', Symbol='Calu', Aliases='9530075H20Rik', description='calumenin', other_designations='crocalbin', map_location='6 A3.3', chromosome='6', genomic_nucleotide_accession_version='NC_000072.6', start_position_on_the_genomic_accession=29348106, end_position_on_the_genomic_accession=29376675, orientation='plus', exon_count=8, OMIM='', no_hdr0=''),
  12322 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12322, CurrentID=0, Status='live', Symbol='Camk2a', Aliases='CaMKII, R74975, mKIAA0968', description='calcium/calmodulin-dependent protein kinase II alpha', other_designations='CaMK II|alpha-CaMKII|caM kinase II subunit alpha|caMK-II subunit alpha', map_location='18 34.41 cM', chromosome='18', genomic_nucleotide_accession_version='NC_000084.6', start_position_on_the_genomic_accession=60925580, end_position_on_the_genomic_accession=60988152, orientation='plus', exon_count=19, OMIM='', no_hdr0=''),
  667683 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=667683, CurrentID=0, Status='live', Symbol='Igkv4-59', Aliases='EG667683, Gm8760, kk4', description='immunoglobulin kappa variable 4-59', other_designations='immunoglobulin kappa chain variable 4-59|monoclonal antibody kappa light chain', map_location='6 C1', chromosome='6', genomic_nucleotide_accession_version='NC_000072.6', start_position_on_the_genomic_accession=69438218, end_position_on_the_genomic_accession=69438741, orientation='minus', exon_count=0, OMIM='', no_hdr0=''),
  12325 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12325, CurrentID=0, Status='live', Symbol='Camk2g', Aliases='Camkg', description='calcium/calmodulin-dependent protein kinase II gamma', other_designations='Ca2+/calmodulin-dependent protein kinase II|CaMK II|caMK-II subunit gamma', map_location='14 A3', chromosome='14', genomic_nucleotide_accession_version='NC_000080.6', start_position_on_the_genomic_accession=20734873, end_position_on_the_genomic_accession=20794130, orientation='minus', exon_count=23, OMIM='', no_hdr0=''),
  12326 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12326, CurrentID=0, Status='live', Symbol='Camk4', Aliases='A430110E23Rik, AI666733, CaMKIV, CaMKIV/Gr, D18Bwg0362e', description='calcium/calmodulin-dependent protein kinase IV', other_designations='CAM kinase-GR|Ca2+/calmodulin-dependent protein kinase type IV/Gr|caMK IV', map_location='18 18.15 cM', chromosome='18', genomic_nucleotide_accession_version='NC_000084.6', start_position_on_the_genomic_accession=32934957, end_position_on_the_genomic_accession=33195767, orientation='plus', exon_count=16, OMIM='', no_hdr0=''),
  12328 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12328, CurrentID=0, Status='live', Symbol='Caml', Aliases='AI385748g, Caml', description='calcium modulating ligand', other_designations='', map_location='13 30.06 cM', chromosome='13', genomic_nucleotide_accession_version='NC_000079.6', start_position_on_the_genomic_accession=55623005, end_position_on_the_genomic_accession=55632416, orientation='plus', exon_count=4, OMIM='', no_hdr0=''),
  12329 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12329, CurrentID=0, Status='live', Symbol='can', Aliases='', description='cartilage anomaly', other_designations='', map_location='', chromosome='', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  12330 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12330, CurrentID=0, Status='live', Symbol='Canx', Aliases='1110069N15Rik, AI988026, Cnx, D11Ertd153e', description='calnexin', other_designations='', map_location='11 30.46 cM', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=50293957, end_position_on_the_genomic_accession=50325673, orientation='minus', exon_count=15, OMIM='', no_hdr0=''),
  12331 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12331, CurrentID=0, Status='live', Symbol='Cap1', Aliases='', description='CAP, adenylate cyclase-associated protein 1 (yeast)', other_designations='CAP 1|adenylyl cyclase-associated CAP protein, yeast homolog 1', map_location='4 D1', chromosome='4', genomic_nucleotide_accession_version='NC_000070.6', start_position_on_the_genomic_accession=122859048, end_position_on_the_genomic_accession=122886071, orientation='minus', exon_count=13, OMIM='', no_hdr0=''),
  12332 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12332, CurrentID=0, Status='live', Symbol='Capg', Aliases='gCap39, mbh1', description='capping protein (actin filament), gelsolin-like', other_designations='actin regulatory protein CAP-G|actin-capping protein GCAP39|myc basic motif homolog 1', map_location='6 C3', chromosome='6', genomic_nucleotide_accession_version='NC_000072.6', start_position_on_the_genomic_accession=72544391, end_position_on_the_genomic_accession=72562983, orientation='plus', exon_count=14, OMIM='', no_hdr0=''),
  12333 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12333, CurrentID=0, Status='live', Symbol='Capn1', Aliases='Capa-1, Capa1, mu-calpin', description='calpain 1', other_designations='CANP 1|calcium-activated neutral proteinase 1|calpain mu-type|calpain-1 large subunit|micromolar-calpain|mu-calpain|muCANP', map_location='19 4.34 cM', chromosome='19', genomic_nucleotide_accession_version='NC_000085.6', start_position_on_the_genomic_accession=5988545, end_position_on_the_genomic_accession=6015825, orientation='minus', exon_count=23, OMIM='', no_hdr0=''),
  12334 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12334, CurrentID=0, Status='live', Symbol='Capn2', Aliases='AI326419, Capa-2, Capa2, m-calpain, m-calpin', description='calpain 2', other_designations='80 kDa M-calpain subunit|CALP80|CANP 2|calcium-activated neutral proteinase 2|calpain M-type|calpain-2 large subunit|cysteine proteinase|m-calpain 80 kDa large subunit|m-calpain large subunit|millimolar-calpain', map_location='1 H5', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=182467259, end_position_on_the_genomic_accession=182517483, orientation='minus', exon_count=21, OMIM='', no_hdr0=''),
  12335 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12335, CurrentID=0, Status='live', Symbol='Capn3', Aliases='AI323605, Capa-3, Capa3, Lp82, p94', description='calpain 3', other_designations='CANP 3|calcium-activated neutral proteinase 3|calpain L3|calpain p94|muscle-specific calcium-activated neutral protease 3|skeletal muscle specific calpain p94', map_location='2 60.31 cM', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=120463593, end_position_on_the_genomic_accession=120504919, orientation='plus', exon_count=25, OMIM='', no_hdr0=''),
  12336 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12336, CurrentID=0, Status='live', Symbol='Capns1', Aliases='Capa-4, Capa4, Capn4, D7Ertd146e', description='calpain, small subunit 1', other_designations='CANP small subunit|CDPS|CSS1|calcium-activated neutral proteinase small subunit|calcium-dependent protease small subunit 1|calpain 4|calpain regulatory subunit', map_location='7 17.31 cM', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=30186942, end_position_on_the_genomic_accession=30198794, orientation='minus', exon_count=14, OMIM='', no_hdr0=''),
  12337 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12337, CurrentID=0, Status='live', Symbol='Capn5', Aliases='nCL-3', description='calpain 5', other_designations='new calpain 3', map_location='7 E2', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=98121559, end_position_on_the_genomic_accession=98179298, orientation='minus', exon_count=20, OMIM='', no_hdr0=''),
  12338 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12338, CurrentID=0, Status='live', Symbol='Capn6', Aliases='', description='calpain 6', other_designations='', map_location='X F2', chromosome='X', genomic_nucleotide_accession_version='NC_000086.7', start_position_on_the_genomic_accession=143802236, end_position_on_the_genomic_accession=143827412, orientation='minus', exon_count=13, OMIM='', no_hdr0=''),
  12339 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12339, CurrentID=0, Status='live', Symbol='Capn7', Aliases='AU022319, PalBH', description='calpain 7', other_designations='palB homolog', map_location='14 B', chromosome='14', genomic_nucleotide_accession_version='NC_000080.6', start_position_on_the_genomic_accession=31336620, end_position_on_the_genomic_accession=31371991, orientation='plus', exon_count=22, OMIM='', no_hdr0=''),
  12340 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12340, CurrentID=0, Status='live', Symbol='Capza1', Aliases='CAPZ, CAZ1, Cappa1', description='capping protein (actin filament) muscle Z-line, alpha 1', other_designations='F-actin capping protein alpha-1 subunit|capZ alpha-1|capping protein alpha 1', map_location='3 45.88 cM', chromosome='3', genomic_nucleotide_accession_version='NC_000069.6', start_position_on_the_genomic_accession=104822785, end_position_on_the_genomic_accession=104864505, orientation='minus', exon_count=10, OMIM='', no_hdr0=''),
  12343 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12343, CurrentID=0, Status='live', Symbol='Capza2', Aliases='1110053K06Rik, AW208808, Cappa2', description='capping protein (actin filament) muscle Z-line, alpha 2', other_designations='capZ alpha-2|capping protein alpha 2', map_location='6 7.96 cM', chromosome='6', genomic_nucleotide_accession_version='NC_000072.6', start_position_on_the_genomic_accession=17637098, end_position_on_the_genomic_accession=17666534, orientation='plus', exon_count=10, OMIM='', no_hdr0=''),
  12344 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12344, CurrentID=0, Status='live', Symbol='Capza3', Aliases='510-4, Cappa3, Gsg3, Tex8, repro32', description='capping protein (actin filament) muscle Z-line, alpha 3', other_designations='capZ alpha-3|capping protein alpha 3|cp alpha3|germ cell-specific protein 3', map_location='6 69.77 cM', chromosome='6', genomic_nucleotide_accession_version='NC_000072.6', start_position_on_the_genomic_accession=140041525, end_position_on_the_genomic_accession=140042789, orientation='plus', exon_count=1, OMIM='', no_hdr0=''),
  12345 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12345, CurrentID=0, Status='live', Symbol='Capzb', Aliases='1700120C01Rik, AI325129, CPB1, CPB2, CPbeat2, CPbeta1, CPbeta2, Cappb1', description='capping protein (actin filament) muscle Z-line, beta', other_designations='capZ beta|capping protein beta 1', map_location='4 70.59 cM', chromosome='4', genomic_nucleotide_accession_version='NC_000070.6', start_position_on_the_genomic_accession=139192899, end_position_on_the_genomic_accession=139291820, orientation='plus', exon_count=12, OMIM='', no_hdr0=''),
  12346 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12346, CurrentID=0, Status='live', Symbol='Car1', Aliases='AW555628, Ca1, Car-1', description='carbonic anhydrase 1', other_designations='CA I|CA-I|carbonate dehydratase I|carbonic anhydrase I', map_location='3 3.18 cM', chromosome='3', genomic_nucleotide_accession_version='NC_000069.6', start_position_on_the_genomic_accession=14766214, end_position_on_the_genomic_accession=14808365, orientation='minus', exon_count=9, OMIM='', no_hdr0=''),
  12348 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12348, CurrentID=0, Status='live', Symbol='Car11', Aliases='Ca11', description='carbonic anhydrase 11', other_designations='CA-RP II|CA-RP XI|CA-XI|CARP XI|CARP-2|carbonic anhydrase-related protein 2', map_location='7 B2', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=45699848, end_position_on_the_genomic_accession=45704671, orientation='plus', exon_count=9, OMIM='', no_hdr0=''),
  12349 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12349, CurrentID=0, Status='live', Symbol='Car2', Aliases='AI131712, CAII, Ca2, Car-2, Ltw-5, Lvtw-5', description='carbonic anhydrase 2', other_designations='CA II|CA-II|carbonate dehydratase II|carbonic anhydrase II', map_location='3 3.23 cM', chromosome='3', genomic_nucleotide_accession_version='NC_000069.6', start_position_on_the_genomic_accession=14886278, end_position_on_the_genomic_accession=14900770, orientation='plus', exon_count=8, OMIM='', no_hdr0=''),
  12350 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12350, CurrentID=0, Status='live', Symbol='Car3', Aliases='BB219044, Ca3, Car-3', description='carbonic anhydrase 3', other_designations='CA-III|carbonate dehydratase III|carbonic anhydrase III', map_location='3 A2', chromosome='3', genomic_nucleotide_accession_version='NC_000069.6', start_position_on_the_genomic_accession=14863490, end_position_on_the_genomic_accession=14872536, orientation='plus', exon_count=8, OMIM='', no_hdr0=''),
  12351 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12351, CurrentID=0, Status='live', Symbol='Car4', Aliases='AW456718, Ca4', description='carbonic anhydrase 4', other_designations='CA IV|CA-IV|carbonate dehydratase IV|carbonic anhydrase IV', map_location='11 C', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=84957754, end_position_on_the_genomic_accession=84966054, orientation='plus', exon_count=9, OMIM='', no_hdr0=''),
  12352 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12352, CurrentID=0, Status='live', Symbol='Car5a', Aliases='CAV, Ca5a, Car5', description='carbonic anhydrase 5a, mitochondrial', other_designations='CA Y|CA-VA|carbonate dehydratase VA|carbonic anhydrase 5, mitochondrial|carbonic anhydrase 5b, mitochondrial|carbonic anhydrase VA', map_location='8 70.81 cM', chromosome='8', genomic_nucleotide_accession_version='NC_000074.6', start_position_on_the_genomic_accession=121916135, end_position_on_the_genomic_accession=121944912, orientation='minus', exon_count=7, OMIM='', no_hdr0=''),
  12353 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12353, CurrentID=0, Status='live', Symbol='Car6', Aliases='Ca6, DOC1', description='carbonic anhydrase 6', other_designations='CA-VI|carbonate dehydratase VI|carbonic anhydrase VI|salivary carbonic anhydrase|secreted carbonic anhydrase', map_location='4 E2', chromosome='4', genomic_nucleotide_accession_version='NC_000070.6', start_position_on_the_genomic_accession=150187015, end_position_on_the_genomic_accession=150201135, orientation='minus', exon_count=8, OMIM='', no_hdr0=''),
  12354 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12354, CurrentID=0, Status='live', Symbol='Car7', Aliases='AV343731, Ca7', description='carbonic anhydrase 7', other_designations='CA-VII|carbonate dehydratase VII|carbonic anhydrase VII', map_location='8 D1', chromosome='8', genomic_nucleotide_accession_version='NC_000074.6', start_position_on_the_genomic_accession=104534700, end_position_on_the_genomic_accession=104550347, orientation='plus', exon_count=11, OMIM='', no_hdr0=''),
  12355 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12355, CurrentID=0, Status='live', Symbol='Nr1i3', Aliases='AA209988, AI551208, CAR, CAR-beta, Care2, ESTM32, MB67', description='nuclear receptor subfamily 1, group I, member 3', other_designations='constitutive androstane receptor|constitutively transactivates RAREs|orphan nuclear receptor MB67', map_location='1 79.21 cM', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=171213935, end_position_on_the_genomic_accession=171218845, orientation='plus', exon_count=9, OMIM='', no_hdr0=''),
  12359 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12359, CurrentID=0, Status='live', Symbol='Cat', Aliases='2210418N07, Cas-1, Cas1, Cs-1', description='catalase', other_designations='catalase 1', map_location='2 54.43 cM', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=103453904, end_position_on_the_genomic_accession=103485153, orientation='minus', exon_count=13, OMIM='', no_hdr0=''),
  12361 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12361, CurrentID=0, Status='live', Symbol='Cask', Aliases='DXPri1, DXRib1, LIN-2, Pals3, mLin-2', description='calcium/calmodulin-dependent serine protein kinase (MAGUK family)', other_designations='', map_location='X 8.43 cM', chromosome='X', genomic_nucleotide_accession_version='NC_000086.7', start_position_on_the_genomic_accession=13517080, end_position_on_the_genomic_accession=13846784, orientation='minus', exon_count=28, OMIM='', no_hdr0=''),
  12362 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12362, CurrentID=0, Status='live', Symbol='Casp1', Aliases='ICE, Il1bc', description='caspase 1', other_designations='CASP-1|IL-1 beta-converting enzyme|IL-1B converting enzyme|IL-1BC|interleukin 1 beta-converting enzyme|interleukin-1 beta convertase|interleukin-1 beta-converting enzyme|p45', map_location='9 2.46 cM', chromosome='9', genomic_nucleotide_accession_version='NC_000075.6', start_position_on_the_genomic_accession=5298517, end_position_on_the_genomic_accession=5307281, orientation='plus', exon_count=10, OMIM='', no_hdr0=''),
  12363 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12363, CurrentID=0, Status='live', Symbol='Casp4', Aliases='CASP-11, CASP-4, Casp11, Caspl, ich-3', description='caspase 4, apoptosis-related cysteine peptidase', other_designations='caspase 11, apoptosis-related cysteine peptidase|caspase 11, apoptosis-related cysteine protease|caspase 4, apoptosis-related cysteine protease|caspase-11 short form splicing|protease ICH-3', map_location='9 2.46 cM', chromosome='9', genomic_nucleotide_accession_version='NC_000075.6', start_position_on_the_genomic_accession=5308825, end_position_on_the_genomic_accession=5336791, orientation='plus', exon_count=9, OMIM='', no_hdr0=''),
  12364 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12364, CurrentID=0, Status='live', Symbol='Casp12', Aliases='', description='caspase 12', other_designations='CASP-12', map_location='9 2.46 cM', chromosome='9', genomic_nucleotide_accession_version='NC_000075.6', start_position_on_the_genomic_accession=5345442, end_position_on_the_genomic_accession=5373034, orientation='plus', exon_count=11, OMIM='', no_hdr0=''),
  12365 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12365, CurrentID=0, Status='live', Symbol='Casp14', Aliases='MICE, mini-ICE', description='caspase 14', other_designations='CASP-14', map_location='10 C1', chromosome='10', genomic_nucleotide_accession_version='NC_000076.6', start_position_on_the_genomic_accession=78711995, end_position_on_the_genomic_accession=78718347, orientation='minus', exon_count=8, OMIM='', no_hdr0=''),
  12366 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12366, CurrentID=0, Status='live', Symbol='Casp2', Aliases='CASP-2, ICH-1, NEDD-2, Nedd2', description='caspase 2', other_designations='neural precursor cell expressed developmentally down-regulated protein 2|protease ICH-1', map_location='6 20.54 cM', chromosome='6', genomic_nucleotide_accession_version='NC_000072.6', start_position_on_the_genomic_accession=42264791, end_position_on_the_genomic_accession=42282508, orientation='plus', exon_count=12, OMIM='', no_hdr0=''),
  12367 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12367, CurrentID=0, Status='live', Symbol='Casp3', Aliases='A830040C14Rik, AC-3, CASP-3, CC3, CPP-32, CPP32, Lice, SCA-1, Yama, mldy', description='caspase 3', other_designations='SREBP cleavage activity 1|apopain|caspase 3, apoptosis related cysteine protease|cysteine protease CPP32|protein Yama', map_location='8 26.39 cM', chromosome='8', genomic_nucleotide_accession_version='NC_000074.6', start_position_on_the_genomic_accession=46617291, end_position_on_the_genomic_accession=46639698, orientation='plus', exon_count=7, OMIM='', no_hdr0=''),
  12368 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12368, CurrentID=0, Status='live', Symbol='Casp6', Aliases='CASP-6, Mch2', description='caspase 6', other_designations='apoptotic protease Mch-2', map_location='3 H1', chromosome='3', genomic_nucleotide_accession_version='NC_000069.6', start_position_on_the_genomic_accession=129901425, end_position_on_the_genomic_accession=129914102, orientation='plus', exon_count=7, OMIM='', no_hdr0=''),
  12369 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12369, CurrentID=0, Status='live', Symbol='Casp7', Aliases='AI314680, CMH-1, ICE-IAP3, Mch3, caspase-7, mCASP-7', description='caspase 7', other_designations='CASP-7|apoptotic protease Mch-3|cysteine protease LICE2', map_location='19 51.84 cM', chromosome='19', genomic_nucleotide_accession_version='NC_000085.6', start_position_on_the_genomic_accession=56396091, end_position_on_the_genomic_accession=56442347, orientation='plus', exon_count=8, OMIM='', no_hdr0=''),
  12370 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12370, CurrentID=0, Status='live', Symbol='Casp8', Aliases='CASP-8, FLICE, MACH, Mch5', description='caspase 8', other_designations='Fas-linked ICE-like protease', map_location='1 B', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=58795229, end_position_on_the_genomic_accession=58847503, orientation='plus', exon_count=11, OMIM='', no_hdr0=''),
  12371 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12371, CurrentID=0, Status='live', Symbol='Casp9', Aliases='AI115399, APAF-3, AW493809, CASP-9, Caspase-9, ICE-LAP6, Mch6', description='caspase 9', other_designations='ICE-like apoptotic protease 6|apoptotic protease Mch-6|apoptotic protease-activating factor 3', map_location='4 E1', chromosome='4', genomic_nucleotide_accession_version='NC_000070.6', start_position_on_the_genomic_accession=141793612, end_position_on_the_genomic_accession=141815978, orientation='plus', exon_count=9, OMIM='', no_hdr0=''),
  12372 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12372, CurrentID=0, Status='live', Symbol='Casq1', Aliases='CSQ, CSQ-1, CSQ1, sCSQ', description='calsequestrin 1', other_designations='calmitine|calsequestrin, skeletal muscle isoform', map_location='1 79.54 cM', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=172209894, end_position_on_the_genomic_accession=172219895, orientation='minus', exon_count=11, OMIM='', no_hdr0=''),
  12373 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12373, CurrentID=0, Status='live', Symbol='Casq2', Aliases='AA033488, AW146219, Csq2, ESTM52, cCSQ', description='calsequestrin 2', other_designations='calsequestrin, cardiac muscle isoform|cardiac calsequestrin', map_location='3 F3', chromosome='3', genomic_nucleotide_accession_version='NC_000069.6', start_position_on_the_genomic_accession=102086420, end_position_on_the_genomic_accession=102146517, orientation='plus', exon_count=12, OMIM='', no_hdr0=''),
  12374 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12374, CurrentID=0, Status='live', Symbol='Casr', Aliases='CaR, Gprc2a', description='calcium-sensing receptor', other_designations='G protein coupled receptor, family C, group 2, member A|G protein-coupled receptor, family C, group 2, member A|PCaR1|cation sensing receptor|parathyroid cell calcium-sensing receptor', map_location='16 25.57 cM', chromosome='16', genomic_nucleotide_accession_version='NC_000082.6', start_position_on_the_genomic_accession=36490585, end_position_on_the_genomic_accession=36562141, orientation='minus', exon_count=13, OMIM='', no_hdr0=''),
  12380 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12380, CurrentID=0, Status='live', Symbol='Cast', Aliases='', description='calpastatin', other_designations='calpain inhibitor|calpastatin type III', map_location='13 C1', chromosome='13', genomic_nucleotide_accession_version='NC_000079.6', start_position_on_the_genomic_accession=74692366, end_position_on_the_genomic_accession=74808874, orientation='minus', exon_count=35, OMIM='', no_hdr0=''),
  667742 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=667742, CurrentID=0, Status='live', Symbol='Piezo2', Aliases='5930434P17, 9030411M15Rik, 9430028L06Rik, Fam38b, Fam38b2', description='piezo-type mechanosensitive ion channel component 2', other_designations='family with sequence similarity 38, member B|family with sequence similarity 38, member B2|protein PIEZO2', map_location='18 E1', chromosome='18', genomic_nucleotide_accession_version='NC_000084.6', start_position_on_the_genomic_accession=63010213, end_position_on_the_genomic_accession=63387307, orientation='minus', exon_count=55, OMIM='', no_hdr0=''),
  12385 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12385, CurrentID=0, Status='live', Symbol='Ctnna1', Aliases='2010010M04Rik, AA517462, AI988031, Catna1', description='catenin (cadherin associated protein), alpha 1', other_designations='102 kDa cadherin-associated protein|CAP102|alpha E catenin|alpha E-catenin|alpha(E)-catenin|cadherin associated protein|catenin alpha 1', map_location='18 18.89 cM', chromosome='18', genomic_nucleotide_accession_version='NC_000084.6', start_position_on_the_genomic_accession=35118912, end_position_on_the_genomic_accession=35254775, orientation='plus', exon_count=20, OMIM='', no_hdr0=''),
  12386 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12386, CurrentID=0, Status='live', Symbol='Ctnna2', Aliases='AI481747, Catna, Catna2, cdf, chp', description='catenin (cadherin associated protein), alpha 2', other_designations='alpha N-catenin|alpha(N)-catenin|cadherin associated protein|catenin alpha 2|cerebellar deficient folia', map_location='6 B3-D', chromosome='6', genomic_nucleotide_accession_version='NC_000072.6', start_position_on_the_genomic_accession=76881637, end_position_on_the_genomic_accession=77979694, orientation='minus', exon_count=21, OMIM='', no_hdr0=''),
  12387 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12387, CurrentID=0, Status='live', Symbol='Ctnnb1', Aliases='Bfc, Catnb, Mesc', description='catenin (cadherin associated protein), beta 1', other_designations='beta-catenin', map_location='9 72.19 cM', chromosome='9', genomic_nucleotide_accession_version='NC_000075.6', start_position_on_the_genomic_accession=120933400, end_position_on_the_genomic_accession=120960507, orientation='plus', exon_count=15, OMIM='', no_hdr0=''),
  12388 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12388, CurrentID=0, Status='live', Symbol='Ctnnd1', Aliases='AA409437, AU019353, Catns, Ctnnd, P120, mKIAA0384', description='catenin (cadherin associated protein), delta 1', other_designations='CAS|cadherin-associated Src substrate|catenin src|p120 catenin|p120(cas)|p120(ctn)|p120-catenin', map_location='2 49.45 cM', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=84600781, end_position_on_the_genomic_accession=84658972, orientation='minus', exon_count=23, OMIM='', no_hdr0=''),
  12389 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12389, CurrentID=0, Status='live', Symbol='Cav1', Aliases='Cav, Cav-1', description='caveolin 1, caveolae protein', other_designations='caveolin, caveolae protein 1|caveolin, caveolae protein, 22 kDa', map_location='6 A2', chromosome='6', genomic_nucleotide_accession_version='NC_000072.6', start_position_on_the_genomic_accession=17306335, end_position_on_the_genomic_accession=17341328, orientation='plus', exon_count=6, OMIM='', no_hdr0=''),
  12390 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12390, CurrentID=0, Status='live', Symbol='Cav2', Aliases='AI447843', description='caveolin 2', other_designations='', map_location='6 A2', chromosome='6', genomic_nucleotide_accession_version='NC_000072.6', start_position_on_the_genomic_accession=17281185, end_position_on_the_genomic_accession=17289130, orientation='plus', exon_count=3, OMIM='', no_hdr0=''),
  12391 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12391, CurrentID=0, Status='live', Symbol='Cav3', Aliases='AI385751, Cav-3, M-cav', description='caveolin 3', other_designations='M-caveolin', map_location='6 E1', chromosome='6', genomic_nucleotide_accession_version='NC_000072.6', start_position_on_the_genomic_accession=112459505, end_position_on_the_genomic_accession=112472872, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  12393 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12393, CurrentID=0, Status='live', Symbol='Runx2', Aliases='AML3, Cbf, Cbfa-1, Cbfa1, LS3, Osf2, PEBP2aA, Pebp2a1, Pebpa2a', description='runt related transcription factor 2', other_designations='AKV core binding factor|CBF-alpha-1|PEA2-alpha A|PEBP2 alpha A|SL3-3 enhancer factor 1 alpha A subunit|acute myeloid leukemia 3 protein|core binding factor alpha 1|osteoblast-specific transcription factor 2|polyomavirus enhancer-binding protein 2 alpha A subunit|runt domain, alpha subunit 1', map_location='17 21.33 cM', chromosome='17', genomic_nucleotide_accession_version='NC_000083.6', start_position_on_the_genomic_accession=44495986, end_position_on_the_genomic_accession=44814831, orientation='minus', exon_count=11, OMIM='', no_hdr0=''),
  12394 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12394, CurrentID=0, Status='live', Symbol='Runx1', Aliases='AML1, CBF-alpha-2, Cbfa2, Pebp2a2, Pebpa2b', description='runt related transcription factor 1', other_designations='SL3-3 enhancer factor 1 alpha B subunit|SL3/AKV core-binding factor alpha B subunit|acute myeloid leukemia 1 protein|core binding factor alpha 2|core-binding factor subunit alpha-2|oncogene AML-1|polyomavirus enhancer-binding protein 2 alpha B subunit|runt domain, alpha subunit 2', map_location='16 53.7 cM', chromosome='16', genomic_nucleotide_accession_version='NC_000082.6', start_position_on_the_genomic_accession=92601466, end_position_on_the_genomic_accession=92826074, orientation='minus', exon_count=8, OMIM='', no_hdr0=''),
  12395 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12395, CurrentID=0, Status='live', Symbol='Runx1t1', Aliases='Cbfa2t1h, ETO, MTG8', description='runt-related transcription factor 1; translocated to, 1 (cyclin D-related)', other_designations='CBFA2T1 identified gene homolog|acute myelogenous leukemia 1 translocation 1 protein', map_location='4 A', chromosome='4', genomic_nucleotide_accession_version='NC_000070.6', start_position_on_the_genomic_accession=13743182, end_position_on_the_genomic_accession=13895056, orientation='plus', exon_count=14, OMIM='', no_hdr0=''),
  12396 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12396, CurrentID=0, Status='live', Symbol='Cbfa2t2', Aliases='A430091M07, C330013D05Rikh, MTGR1, Cbfa2t2', description='core-binding factor, runt domain, alpha subunit 2, translocated to, 2 (human)', other_designations='CBFA2T2 identified gene homolog|MTG8-like protein|MTG8-related protein 1|core-binding factor runt domain alpha subunit 2 translocated to 2 homolog|core-binding factor, runt domain, alpha subunit 2, translocated to, 2 homolog', map_location='2 C3.2', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=154436463, end_position_on_the_genomic_accession=154539356, orientation='plus', exon_count=12, OMIM='', no_hdr0=''),
  12398 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12398, CurrentID=0, Status='live', Symbol='Cbfa2t3', Aliases='A630044F12Rik, AI465270, AW229127h, ETO-2, Eto2, MTGR2, Cbfa2t3', description='core-binding factor, runt domain, alpha subunit 2, translocated to, 3 (human)', other_designations='ETO/MTG8-related protein ETO-2|MTG8-related protein 2|eight twenty one protein 2|myeloid translocation gene-related protein 2', map_location='8 E1', chromosome='8', genomic_nucleotide_accession_version='NC_000074.6', start_position_on_the_genomic_accession=122625136, end_position_on_the_genomic_accession=122699639, orientation='minus', exon_count=14, OMIM='', no_hdr0=''),
  12399 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12399, CurrentID=0, Status='live', Symbol='Runx3', Aliases='AML2, Cbfa3, Pebp2a3', description='runt related transcription factor 3', other_designations='CBF-alpha-3|PEA2-alpha C|PEBP2-alpha C|SL3-3 enhancer factor 1 alpha C subunit|SL3/AKV core-binding factor alpha C subunit|acute myeloid leukemia 2 protein|core binding factor alpha 3|core-binding factor subunit alpha-3|oncogene AML-2|polyomavirus enhancer-binding protein 2 alpha C subunit|runt domain, alpha subunit 3|transcription factor AML2/CBFA3', map_location='4 67.19 cM', chromosome='4', genomic_nucleotide_accession_version='NC_000070.6', start_position_on_the_genomic_accession=135120645, end_position_on_the_genomic_accession=135177990, orientation='plus', exon_count=7, OMIM='', no_hdr0=''),
  12400 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12400, CurrentID=0, Status='live', Symbol='Cbfb', Aliases='AI893578, PEA2, PEBP2b, Pebp2, Pebpb2', description='core binding factor beta', other_designations='CBF-beta|PEA2-beta|PEBP2-beta|SL3-3 enhancer factor 1 subunit beta|SL3/AKV core-binding factor beta subunit|polyomavirus enhancer-binding protein 2 beta subunit', map_location='8 53.04 cM', chromosome='8', genomic_nucleotide_accession_version='NC_000074.6', start_position_on_the_genomic_accession=105170674, end_position_on_the_genomic_accession=105217989, orientation='plus', exon_count=6, OMIM='', no_hdr0=''),
  12401 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12401, CurrentID=0, Status='live', Symbol='Serpina6', Aliases='Cbg', description='serine (or cysteine) peptidase inhibitor, clade A, member 6', other_designations='corticosteroid binding globulin|serine (or cysteine) proteinase inhibitor, clade A, member 6|serpin A6|transcortin', map_location='12 52.98 cM', chromosome='12', genomic_nucleotide_accession_version='NC_000078.6', start_position_on_the_genomic_accession=103646632, end_position_on_the_genomic_accession=103657071, orientation='minus', exon_count=5, OMIM='', no_hdr0=''),
  12402 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12402, CurrentID=0, Status='live', Symbol='Cbl', Aliases='4732447J05Rik-2, c-Cbl, cbl, Cbl', description='Casitas B-lineage lymphoma', other_designations='casitas B-lineage lymphoma proto-oncogene|proto-oncogene c-CBL|signal transduction protein CBL', map_location='9 24.72 cM', chromosome='9', genomic_nucleotide_accession_version='NC_000075.6', start_position_on_the_genomic_accession=44145040, end_position_on_the_genomic_accession=44234046, orientation='minus', exon_count=16, OMIM='', no_hdr0=''),
  12404 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12404, CurrentID=0, Status='live', Symbol='Cbln1', Aliases='AI323299', description='cerebellin 1 precursor protein', other_designations='brain protein D3|precerebellin', map_location='8 42.16 cM', chromosome='8', genomic_nucleotide_accession_version='NC_000074.6', start_position_on_the_genomic_accession=87468853, end_position_on_the_genomic_accession=87472592, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  12405 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12405, CurrentID=0, Status='live', Symbol='Cbln2', Aliases='6330593N19Rik, A730004O05', description='cerebellin 2 precursor protein', other_designations='', map_location='18 58.63 cM', chromosome='18', genomic_nucleotide_accession_version='NC_000084.6', start_position_on_the_genomic_accession=86711053, end_position_on_the_genomic_accession=86718285, orientation='plus', exon_count=6, OMIM='', no_hdr0=''),
  12406 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12406, CurrentID=0, Status='live', Symbol='Serpinh1', Aliases='BERF-1, Cbp1, Cbp2, Hsp47, J6, Serpinh2, gp46', description='serine (or cysteine) peptidase inhibitor, clade H, member 1', other_designations='47 kDa heat shock protein|beta enolase repressor factor 1|collagen binding protein 1|colligin|serine (or cysteine) proteinase inhibitor, clade H (heat shock protein 47), member 1|serine (or cysteine) proteinase inhibitor, clade H (heat shock protein 47), member 2|serine protease inhibitor J6', map_location='7 E2', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=99345375, end_position_on_the_genomic_accession=99353239, orientation='minus', exon_count=7, OMIM='', no_hdr0=''),
  12408 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12408, CurrentID=0, Status='live', Symbol='Cbr1', Aliases='AW261796, CR, Cbr', description='carbonyl reductase 1', other_designations='15-hydroxyprostaglandin dehydrogenase|Carbonyl reductase [NADPH] 1 (NADPH-dependent carbonyl reductase 1)|NADPH-dependent carbonyl reductase 1|prostaglandin 9-ketoreductase|prostaglandin-E(2) 9-reductase', map_location='16 54.53 cM', chromosome='16', genomic_nucleotide_accession_version='NC_000082.6', start_position_on_the_genomic_accession=93607837, end_position_on_the_genomic_accession=93610349, orientation='plus', exon_count=3, OMIM='', no_hdr0=''),
  12409 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12409, CurrentID=0, Status='live', Symbol='Cbr2', Aliases='MLCR', description='carbonyl reductase 2', other_designations='AP27|LCR|NADPH-dependent carbonyl reductase 2|adipocyte protein P27|lung carbonyl reductase', map_location='11 84.47 cM', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=120729485, end_position_on_the_genomic_accession=120732025, orientation='minus', exon_count=8, OMIM='', no_hdr0=''),
  12411 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12411, CurrentID=0, Status='live', Symbol='Cbs', Aliases='AI047524, AI303044, HIP4', description='cystathionine beta-synthase', other_designations='beta-thionase|serine sulfhydrase', map_location='17 A-C', chromosome='17', genomic_nucleotide_accession_version='NC_000083.6', start_position_on_the_genomic_accession=31612623, end_position_on_the_genomic_accession=31637233, orientation='minus', exon_count=18, OMIM='', no_hdr0=''),
  667772 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=667772, CurrentID=0, Status='live', Symbol='Myh15', Aliases='EG667772', description='myosin, heavy chain 15', other_designations='', map_location='16 B5', chromosome='16', genomic_nucleotide_accession_version='NC_000082.6', start_position_on_the_genomic_accession=49057486, end_position_on_the_genomic_accession=49199104, orientation='plus', exon_count=41, OMIM='', no_hdr0=''),
  12416 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12416, CurrentID=0, Status='live', Symbol='Cbx2', Aliases='M33, MOD2, pc', description='chromobox 2', other_designations='M33 polycomb-like protein|chromobox homolog 2|modifier 3 protein|polycomb', map_location='11 83.33 cM', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=119023019, end_position_on_the_genomic_accession=119031274, orientation='plus', exon_count=6, OMIM='', no_hdr0=''),
  12417 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12417, CurrentID=0, Status='live', Symbol='Cbx3', Aliases='HP1g, M32', description='chromobox 3', other_designations='HP1 gamma|chromobox homolog 3|heterochromatin protein 1 gamma|heterochromatin protein 1 homolog gamma|modifier 2 protein', map_location='6 B-C', chromosome='6', genomic_nucleotide_accession_version='NC_000072.6', start_position_on_the_genomic_accession=51470616, end_position_on_the_genomic_accession=51483704, orientation='plus', exon_count=6, OMIM='', no_hdr0=''),
  12418 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12418, CurrentID=0, Status='live', Symbol='Cbx4', Aliases='MPc2, PC2', description='chromobox 4', other_designations='chromobox homolog 4|chromobox protein homolog 4|polycomb 2 homolog', map_location='11 83.34 cM', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=119077571, end_position_on_the_genomic_accession=119086237, orientation='minus', exon_count=5, OMIM='', no_hdr0=''),
  12419 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12419, CurrentID=0, Status='live', Symbol='Cbx5', Aliases='2610029O15Rik, C75991, HP1, Hp1a, Hp1alpha', description='chromobox 5', other_designations='HP1 alpha|chromobox homolog 5|heterochromatin protein 1 alpha|heterochromatin protein 1 homolog alpha|mHP1(alpha)', map_location='15 F3', chromosome='15', genomic_nucleotide_accession_version='NC_000081.6', start_position_on_the_genomic_accession=103191546, end_position_on_the_genomic_accession=103239904, orientation='minus', exon_count=7, OMIM='', no_hdr0=''),
  12420 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12420, CurrentID=0, Status='live', Symbol='cby', Aliases='', description='chubby', other_designations='', map_location='', chromosome='', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  12421 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12421, CurrentID=0, Status='live', Symbol='Rb1cc1', Aliases='2900055E04Rik, 5930404L04Rik, Cc1, FIP200, LaXp180', description='RB1-inducible coiled-coil 1', other_designations='200 kDa FAK family kinase-interacting protein|FAK family kinase-interacting protein of 200 kDa|coiled coil forming protein 1|coiled-coil-forming protein 1', map_location='1 A2', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=6214642, end_position_on_the_genomic_accession=6276372, orientation='plus', exon_count=27, OMIM='', no_hdr0=''),
  12424 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12424, CurrentID=0, Status='live', Symbol='Cck', Aliases='', description='cholecystokinin', other_designations='', map_location='9 F4', chromosome='9', genomic_nucleotide_accession_version='NC_000075.6', start_position_on_the_genomic_accession=121489824, end_position_on_the_genomic_accession=121495694, orientation='minus', exon_count=4, OMIM='', no_hdr0=''),
  12425 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12425, CurrentID=0, Status='live', Symbol='Cckar', Aliases='AW106902', description='cholecystokinin A receptor', other_designations='CCK-A receptor|CCK-AR|CCK1-R|cholecystokinin-1 receptor', map_location='5 29.52 cM', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=53698485, end_position_on_the_genomic_accession=53707704, orientation='minus', exon_count=5, OMIM='', no_hdr0=''),
  12426 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12426, CurrentID=0, Status='live', Symbol='Cckbr', Aliases='CCK-BR, CCK2-R, CCK2R, CCKR-2', description='cholecystokinin B receptor', other_designations='CCK-B receptor|CCK-B/gastrin receptor|CCK2/gastrin receptor|cholecystokinin-2 receptor', map_location='7 55.86 cM', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=105425558, end_position_on_the_genomic_accession=105436339, orientation='plus', exon_count=5, OMIM='', no_hdr0=''),
  12427 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12427, CurrentID=0, Status='live', Symbol='Ccna1', Aliases='', description='cyclin A1', other_designations='', map_location='3 C', chromosome='3', genomic_nucleotide_accession_version='NC_000069.6', start_position_on_the_genomic_accession=55045469, end_position_on_the_genomic_accession=55055330, orientation='minus', exon_count=10, OMIM='', no_hdr0=''),
  12428 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12428, CurrentID=0, Status='live', Symbol='Ccna2', Aliases='AA408589, Ccn-1, Ccn1, Ccna, CycA2, Cyca', description='cyclin A2', other_designations='Cyclin A2 (Cyclin A)|cyclin-A', map_location='3 17.67 cM', chromosome='3', genomic_nucleotide_accession_version='NC_000069.6', start_position_on_the_genomic_accession=36564865, end_position_on_the_genomic_accession=36571996, orientation='minus', exon_count=8, OMIM='', no_hdr0=''),
  12442 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12442, CurrentID=0, Status='live', Symbol='Ccnb2', Aliases='CycB2', description='cyclin B2', other_designations='G2/mitotic-specific cyclin B2', map_location='9 D', chromosome='9', genomic_nucleotide_accession_version='NC_000075.6', start_position_on_the_genomic_accession=70407689, end_position_on_the_genomic_accession=70421554, orientation='minus', exon_count=9, OMIM='', no_hdr0=''),
  667803 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=667803, CurrentID=0, Status='live', Symbol='C920025E04Rik', Aliases='H2-T11', description='RIKEN cDNA C920025E04 gene', other_designations='', map_location='17 B1', chromosome='17', genomic_nucleotide_accession_version='NC_000083.6', start_position_on_the_genomic_accession=36109030, end_position_on_the_genomic_accession=36111729, orientation='minus', exon_count=7, OMIM='', no_hdr0=''),
  12444 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12444, CurrentID=0, Status='live', Symbol='Ccnd2', Aliases='2600016F06Rik, AI256817, BF642806, C86853, Vin-1, Vin1, cD2', description='cyclin D2', other_designations='', map_location='6 61.92 cM', chromosome='6', genomic_nucleotide_accession_version='NC_000072.6', start_position_on_the_genomic_accession=127125162, end_position_on_the_genomic_accession=127152188, orientation='minus', exon_count=7, OMIM='', no_hdr0=''),
  12445 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12445, CurrentID=0, Status='live', Symbol='Ccnd3', Aliases='9230106B05Rik, AA682053, AL024085, AW146355, C78795', description='cyclin D3', other_designations='', map_location='17 23.37 cM', chromosome='17', genomic_nucleotide_accession_version='NC_000083.6', start_position_on_the_genomic_accession=47504738, end_position_on_the_genomic_accession=47599689, orientation='plus', exon_count=10, OMIM='', no_hdr0=''),
  12447 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12447, CurrentID=0, Status='live', Symbol='Ccne1', Aliases='AW538188, CycE1', description='cyclin E1', other_designations='', map_location='7 25.35 cM', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=38097984, end_position_on_the_genomic_accession=38107490, orientation='minus', exon_count=12, OMIM='', no_hdr0=''),
  12448 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12448, CurrentID=0, Status='live', Symbol='Ccne2', Aliases='', description='cyclin E2', other_designations='', map_location='4 A2', chromosome='4', genomic_nucleotide_accession_version='NC_000070.6', start_position_on_the_genomic_accession=11189214, end_position_on_the_genomic_accession=11204779, orientation='plus', exon_count=14, OMIM='', no_hdr0=''),
  12449 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12449, CurrentID=0, Status='live', Symbol='Ccnf', Aliases='CycF, Fbxo1', description='cyclin F', other_designations='G2/mitotic-specific cyclin-F', map_location='17 12.32 cM', chromosome='17', genomic_nucleotide_accession_version='NC_000083.6', start_position_on_the_genomic_accession=24223230, end_position_on_the_genomic_accession=24251409, orientation='minus', exon_count=17, OMIM='', no_hdr0=''),
  12450 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12450, CurrentID=0, Status='live', Symbol='Ccng1', Aliases='AI314029', description='cyclin G1', other_designations='cyclin-G', map_location='11 B1.1', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=40748552, end_position_on_the_genomic_accession=40755315, orientation='minus', exon_count=6, OMIM='', no_hdr0=''),
  12452 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12452, CurrentID=0, Status='live', Symbol='Ccng2', Aliases='', description='cyclin G2', other_designations='', map_location='5 E3.3-F1.3', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=93267573, end_position_on_the_genomic_accession=93276231, orientation='plus', exon_count=8, OMIM='', no_hdr0=''),
  12453 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12453, CurrentID=0, Status='live', Symbol='Ccni', Aliases='', description='cyclin I', other_designations='', map_location='5 E3.3-F1.3', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=93181933, end_position_on_the_genomic_accession=93206495, orientation='minus', exon_count=8, OMIM='', no_hdr0=''),
  12454 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12454, CurrentID=0, Status='live', Symbol='Ccnk', Aliases='AW123198, AW413594, CPR4, CycK', description='cyclin K', other_designations='', map_location='12 59.23 cM', chromosome='12', genomic_nucleotide_accession_version='NC_000078.6', start_position_on_the_genomic_accession=108179446, end_position_on_the_genomic_accession=108203362, orientation='plus', exon_count=13, OMIM='', no_hdr0=''),
  12455 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12455, CurrentID=0, Status='live', Symbol='Ccnt1', Aliases='2810478G24Rik, AI115585, CycT1', description='cyclin T1', other_designations='cyclin-T', map_location='15 F2', chromosome='15', genomic_nucleotide_accession_version='NC_000081.6', start_position_on_the_genomic_accession=98543211, end_position_on_the_genomic_accession=98568497, orientation='minus', exon_count=9, OMIM='', no_hdr0=''),
  12457 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12457, CurrentID=0, Status='live', Symbol='Noct', Aliases='AU043840, Ccr4, Ccrn4l', description='nocturnin', other_designations='CCR4 carbon catabolite repression 4-like|CCR4 protein homolog|carbon catabolite repression 4 homolog|carbon catabolite repression 4-like protein|circadian deadenylase NOC', map_location='3 B-D', chromosome='3', genomic_nucleotide_accession_version='NC_000069.6', start_position_on_the_genomic_accession=51224447, end_position_on_the_genomic_accession=51251654, orientation='plus', exon_count=4, OMIM='', no_hdr0=''),
  12458 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12458, CurrentID=0, Status='live', Symbol='Ccr6', Aliases='CC-CKR-6, CCR-6, Cmkbr6, KY411', description='chemokine (C-C motif) receptor 6', other_designations='', map_location='17 A1', chromosome='17', genomic_nucleotide_accession_version='NC_000083.6', start_position_on_the_genomic_accession=8236043, end_position_on_the_genomic_accession=8257141, orientation='plus', exon_count=10, OMIM='', no_hdr0=''),
  12460 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12460, CurrentID=0, Status='live', Symbol='Ccs', Aliases='Ccsd', description='copper chaperone for superoxide dismutase', other_designations='superoxide dismutase copper chaperone', map_location='19 4.11 cM', chromosome='19', genomic_nucleotide_accession_version='NC_000085.6', start_position_on_the_genomic_accession=4825366, end_position_on_the_genomic_accession=4839327, orientation='minus', exon_count=8, OMIM='', no_hdr0=''),
  12461 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12461, CurrentID=0, Status='live', Symbol='Cct2', Aliases='Cctb', description='chaperonin containing Tcp1, subunit 2 (beta)', other_designations='CCT-beta|TCP-1-beta|chaperonin subunit 2 (beta)', map_location='10 D2', chromosome='10', genomic_nucleotide_accession_version='NC_000076.6', start_position_on_the_genomic_accession=117050997, end_position_on_the_genomic_accession=117063814, orientation='minus', exon_count=17, OMIM='', no_hdr0=''),
  12462 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12462, CurrentID=0, Status='live', Symbol='Cct3', Aliases='AL024092, Cctg, Tcp1-rs3, TriC-P5', description='chaperonin containing Tcp1, subunit 3 (gamma)', other_designations='CCT-gamma|TCP-1-gamma|chaperonin subunit 3 (gamma)|matricin', map_location='3 F', chromosome='3', genomic_nucleotide_accession_version='NC_000069.6', start_position_on_the_genomic_accession=88297135, end_position_on_the_genomic_accession=88321766, orientation='plus', exon_count=14, OMIM='', no_hdr0=''),
  667823 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=667823, CurrentID=0, Status='live', Symbol='Trim5', Aliases='EG667823, Gm8833', description='tripartite motif-containing 5', other_designations='', map_location='7 E3', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=104263386, end_position_on_the_genomic_accession=104288421, orientation='minus', exon_count=8, OMIM='', no_hdr0=''),
  12464 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12464, CurrentID=0, Status='live', Symbol='Cct4', Aliases='2610204B21Rik, A45, C78323, Cctd', description='chaperonin containing Tcp1, subunit 4 (delta)', other_designations='CCT-delta|T complex protein 1, delta|TCP-1 delta|TCP-1-delta|chaperonin subunit 4 (delta)', map_location='11 14.25 cM', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=22990593, end_position_on_the_genomic_accession=23003336, orientation='plus', exon_count=14, OMIM='', no_hdr0=''),
  12465 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12465, CurrentID=0, Status='live', Symbol='Cct5', Aliases='Ccte, TCPE, mKIAA0098', description='chaperonin containing Tcp1, subunit 5 (epsilon)', other_designations='CCT-epsilon|TCP-1-epsilon|chaperonin subunit 5 (epsilon)', map_location='15 B3.2', chromosome='15', genomic_nucleotide_accession_version='NC_000081.6', start_position_on_the_genomic_accession=31590813, end_position_on_the_genomic_accession=31601804, orientation='minus', exon_count=12, OMIM='', no_hdr0=''),
  12466 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12466, CurrentID=0, Status='live', Symbol='Cct6a', Aliases='CCT-zeta, CCT-zeta-1, Cct6, Cctz-1, TCP-1-zeta', description='chaperonin containing Tcp1, subunit 6a (zeta)', other_designations='chaperonin containing TCP-1|chaperonin subunit 6a (zeta)', map_location='5 G1.3', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=129844962, end_position_on_the_genomic_accession=129846443, orientation='plus', exon_count=13, OMIM='', no_hdr0=''),
  12467 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12467, CurrentID=0, Status='live', Symbol='Cct6b', Aliases='CCT-zeta-2, CCTzeta-2, Cctz-2, TCP-1-zeta-2', description='chaperonin containing Tcp1, subunit 6b (zeta)', other_designations='chaperonin subunit 6b (zeta)', map_location='11 B5', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=82719248, end_position_on_the_genomic_accession=82764321, orientation='minus', exon_count=16, OMIM='', no_hdr0=''),
  12468 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12468, CurrentID=0, Status='live', Symbol='Cct7', Aliases='AA408524, AL022769, Ccth, Cctz', description='chaperonin containing Tcp1, subunit 7 (eta)', other_designations='CCT-eta|TCP-1-eta|chaperonin containing t-complex subunit eta|chaperonin subunit 7 (eta)', map_location='6 D1', chromosome='6', genomic_nucleotide_accession_version='NC_000072.6', start_position_on_the_genomic_accession=85451505, end_position_on_the_genomic_accession=85468477, orientation='plus', exon_count=12, OMIM='', no_hdr0=''),
  12469 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12469, CurrentID=0, Status='live', Symbol='Cct8', Aliases='AI132397, Cctq, Tcpq', description='chaperonin containing Tcp1, subunit 8 (theta)', other_designations='CCT-theta|TCP-1-theta|chaperonin subunit 8 (theta)', map_location='16 C3.3', chromosome='16', genomic_nucleotide_accession_version='NC_000082.6', start_position_on_the_genomic_accession=87483325, end_position_on_the_genomic_accession=87495869, orientation='minus', exon_count=15, OMIM='', no_hdr0=''),
  12475 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12475, CurrentID=0, Status='live', Symbol='Cd14', Aliases='', description='CD14 antigen', other_designations='myeloid cell-specific leucine-rich glycoprotein', map_location='18 19.46 cM', chromosome='18', genomic_nucleotide_accession_version='NC_000084.6', start_position_on_the_genomic_accession=36725064, end_position_on_the_genomic_accession=36726815, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  12476 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12476, CurrentID=0, Status='live', Symbol='Cd151', Aliases='PETA-3, SFA-1, Tspan24', description='CD151 antigen', other_designations='GP27|membrane glycoprotein SFA-1|platelet-endothelial tetraspan antigen 3', map_location='7 86.82 cM', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=141467362, end_position_on_the_genomic_accession=141471481, orientation='plus', exon_count=9, OMIM='', no_hdr0=''),
  12477 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12477, CurrentID=0, Status='live', Symbol='Ctla4', Aliases='Cd152, Ctla-4, Ly-56', description='cytotoxic T-lymphocyte-associated protein 4', other_designations='CD152 antigen|cytotoxic T-lymphocyte-associated antigen 4', map_location='1 C', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=60909025, end_position_on_the_genomic_accession=60915832, orientation='plus', exon_count=4, OMIM='', no_hdr0=''),
  667838 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=667838, CurrentID=0, Status='live', Symbol='Naip3', Aliases='Birc1c, EG667838, Mitf, Naip-rs5, pORF1, pORF2', description='NLR family, apoptosis inhibitory protein 3', other_designations='baculoviral IAP repeat-containing 1c|neuronal apoptosis inhibitory protein 3|neuronal apoptosis inhibitory protein related sequence 5', map_location='13 53.13 cM', chromosome='13', genomic_nucleotide_accession_version='NC_000079.6', start_position_on_the_genomic_accession=100340005, end_position_on_the_genomic_accession=100389242, orientation='minus', exon_count=0, OMIM='', no_hdr0=''),
  12479 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12479, CurrentID=0, Status='live', Symbol='Cd1d1', Aliases='AI747460, CD1.1, Cd1a, Cd1d, Ly-38', description='CD1d1 antigen', other_designations='T-cell surface glycoprotein CD1d1', map_location='3 37.91 cM', chromosome='3', genomic_nucleotide_accession_version='NC_000069.6', start_position_on_the_genomic_accession=86995834, end_position_on_the_genomic_accession=86999340, orientation='minus', exon_count=6, OMIM='', no_hdr0=''),
  12480 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12480, CurrentID=0, Status='live', Symbol='Cd1d2', Aliases='CD1.2, Cd1b, Ly-38', description='CD1d2 antigen', other_designations='T-cell surface glycoprotein CD1d2', map_location='3 37.88 cM', chromosome='3', genomic_nucleotide_accession_version='NC_000069.6', start_position_on_the_genomic_accession=86986586, end_position_on_the_genomic_accession=86989533, orientation='plus', exon_count=6, OMIM='', no_hdr0=''),
  12481 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12481, CurrentID=0, Status='live', Symbol='Cd2', Aliases='LFA-2, Ly-37, Ly37', description='CD2 antigen', other_designations='LFA-3 receptor|T-cell surface antigen T11/Leu-5|lymphocyte antigen 37', map_location='3 44.17 cM', chromosome='3', genomic_nucleotide_accession_version='NC_000069.6', start_position_on_the_genomic_accession=101275908, end_position_on_the_genomic_accession=101287939, orientation='minus', exon_count=5, OMIM='', no_hdr0=''),
  12482 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12482, CurrentID=0, Status='live', Symbol='Ms4a1', Aliases='AA960661, Cd20, Ly-44, Ms4a2', description='membrane-spanning 4-domains, subfamily A, member 1', other_designations='B-cell differentiation antigen Ly-44|CD20 antigen|lymphocyte antigen 44|membrane-spanning 4-domains, subfamily A, member 2', map_location='19 B', chromosome='19', genomic_nucleotide_accession_version='NC_000085.6', start_position_on_the_genomic_accession=11250603, end_position_on_the_genomic_accession=11266151, orientation='minus', exon_count=7, OMIM='', no_hdr0=''),
  12483 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12483, CurrentID=0, Status='live', Symbol='Cd22', Aliases='A530093D23, Lyb-8, Lyb8', description='CD22 antigen', other_designations='B-lymphocyte cell adhesion molecule|BL-CAM|T-cell surface antigen Leu-14|sialic acid-binding Ig-like lectin 2|siglec-2', map_location='7 19.26 cM', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=30865404, end_position_on_the_genomic_accession=30880342, orientation='minus', exon_count=17, OMIM='', no_hdr0=''),
  12484 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12484, CurrentID=0, Status='live', Symbol='Cd24a', Aliases='Cd24, HSA, Ly-52, nectadrin', description='CD24a antigen', other_designations='M1/69-J11D heat stable antigen|R13-Ag|X62 heat stable antigen|cluster of differentiation 24|heat stable antigen|lymphocyte antigen 52', map_location='10 23.01 cM', chromosome='10', genomic_nucleotide_accession_version='NC_000076.6', start_position_on_the_genomic_accession=43579169, end_position_on_the_genomic_accession=43584265, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  12487 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12487, CurrentID=0, Status='live', Symbol='Cd28', Aliases='', description='CD28 antigen', other_designations='', map_location='1 C1-C3', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=60746388, end_position_on_the_genomic_accession=60773359, orientation='plus', exon_count=4, OMIM='', no_hdr0=''),
  12488 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12488, CurrentID=0, Status='live', Symbol='Cd2ap', Aliases='AL024079, C78928, METS-1, Mets1', description='CD2-associated protein', other_designations='SH3 domain-containing adapter protein|SH3 domain-containing adaptor protein METS-1|mesenchyme to epithelium transition protein, SH3 domains|mesenchyme-to-epithelium transition protein with SH3 domains 1', map_location='17 B3', chromosome='17', genomic_nucleotide_accession_version='NC_000083.6', start_position_on_the_genomic_accession=42749098, end_position_on_the_genomic_accession=42876712, orientation='minus', exon_count=21, OMIM='', no_hdr0=''),
  12489 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12489, CurrentID=0, Status='live', Symbol='Cd33', Aliases='Siglec-3, gp67', description='CD33 antigen', other_designations='sialic acid-binding Ig-like lectin 3', map_location='7 28.25 cM', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=43527399, end_position_on_the_genomic_accession=43544428, orientation='minus', exon_count=10, OMIM='', no_hdr0=''),
  12490 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12490, CurrentID=0, Status='live', Symbol='Cd34', Aliases='AU040960', description='CD34 antigen', other_designations='cluster designation 34', map_location='1 98.38 cM', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=194938821, end_position_on_the_genomic_accession=194961292, orientation='plus', exon_count=8, OMIM='', no_hdr0=''),
  12491 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12491, CurrentID=0, Status='live', Symbol='Cd36', Aliases='FAT, GPIV, Scarb3', description='CD36 antigen', other_designations='GPIIIB|PAS IV|PAS-4|fatty acid translocase|glycoprotein IIIb|platelet glycoprotein IV', map_location='5 8.11 cM', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=17781690, end_position_on_the_genomic_accession=17888959, orientation='minus', exon_count=18, OMIM='', no_hdr0=''),
  12492 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12492, CurrentID=0, Status='live', Symbol='Scarb2', Aliases='9330185J12Rik, Cd36l2, LGP85, LIMP II, LIMP-2, MLGP85', description='scavenger receptor class B, member 2', other_designations='85 kDa lysosomal membrane sialoglycoprotein|CD36 antigen (collagen type I receptor, thrombospondin receptor)-like 2|lysosome membrane protein II', map_location='5 E3', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=92443873, end_position_on_the_genomic_accession=92505608, orientation='minus', exon_count=12, OMIM='', no_hdr0=''),
  12493 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12493, CurrentID=0, Status='live', Symbol='Cd37', Aliases='Tspan26', description='CD37 antigen', other_designations='', map_location='7 29.2 cM', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=45233632, end_position_on_the_genomic_accession=45239235, orientation='minus', exon_count=9, OMIM='', no_hdr0=''),
  12494 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12494, CurrentID=0, Status='live', Symbol='Cd38', Aliases='ADPRC 1-rs1, I-19, Cd38', description='CD38 antigen', other_designations="2'-phospho-ADP-ribosyl cyclase|2'-phospho-ADP-ribosyl cyclase/2'-phospho-cyclic-ADP-ribose transferase|2'-phospho-cyclic-ADP-ribose transferase|ADP-ribosyl cyclase 1|NIM-R5 antigen|cADPr hydrolase 1|cyclic ADP-ribose hydrolase 1", map_location='5 23.85 cM', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=43868827, end_position_on_the_genomic_accession=43912374, orientation='plus', exon_count=8, OMIM='', no_hdr0=''),
  12495 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12495, CurrentID=0, Status='live', Symbol='Entpd1', Aliases='2610206B08Rik, AA408691, Cd39, NTPDase-1', description='ectonucleoside triphosphate diphosphohydrolase 1', other_designations='CD39 antigen|NTPDase 1|ecto-ATP diphosphohydrolase 1|ecto-ATPDase 1|ecto-ATPase 1|ectoapyrase|lymphoid cell activation antigen', map_location='19 34.25 cM', chromosome='19', genomic_nucleotide_accession_version='NC_000085.6', start_position_on_the_genomic_accession=40612365, end_position_on_the_genomic_accession=40741602, orientation='plus', exon_count=13, OMIM='', no_hdr0=''),
  12496 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12496, CurrentID=0, Status='live', Symbol='Entpd2', Aliases='Cd39l1, NTPDase2', description='ectonucleoside triphosphate diphosphohydrolase 2', other_designations='CD39 antigen-like 1|NTPDase 2|ecto-ATP diphosphohydrolase 2|ecto-ATPDase 2|ecto-ATPase 2', map_location='2 A3', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=25395874, end_position_on_the_genomic_accession=25401323, orientation='plus', exon_count=9, OMIM='', no_hdr0=''),
  12497 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12497, CurrentID=0, Status='live', Symbol='Entpd6', Aliases='2700026H11Rik, Cd39l2, NTPDase-6', description='ectonucleoside triphosphate diphosphohydrolase 6', other_designations='CD39 antigen-like 2', map_location='2 G3', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=150749038, end_position_on_the_genomic_accession=150771675, orientation='plus', exon_count=14, OMIM='', no_hdr0=''),
  12499 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12499, CurrentID=0, Status='live', Symbol='Entpd5', Aliases='AI196558, AI987697, Cd39l4, ER-UDPase, NTPDase-5, NTPDase5, Pcph, mNTPase', description='ectonucleoside triphosphate diphosphohydrolase 5', other_designations='CD39 antigen-like 4|GDPase ENTPD5|NTPDase 5|UDPase ENTPD5|guanosine-diphosphatase ENTPD5|nucleoside diphosphatase|uridine-diphosphatase ENTPD5', map_location='12 E', chromosome='12', genomic_nucleotide_accession_version='NC_000078.6', start_position_on_the_genomic_accession=84373875, end_position_on_the_genomic_accession=84409029, orientation='minus', exon_count=20, OMIM='', no_hdr0=''),
  12500 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12500, CurrentID=0, Status='live', Symbol='Cd3d', Aliases='T3d', description='CD3 antigen, delta polypeptide', other_designations='T-cell receptor T3 delta chain', map_location='9 24.84 cM', chromosome='9', genomic_nucleotide_accession_version='NC_000075.6', start_position_on_the_genomic_accession=44981769, end_position_on_the_genomic_accession=44987052, orientation='plus', exon_count=6, OMIM='', no_hdr0=''),
  12501 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12501, CurrentID=0, Status='live', Symbol='Cd3e', Aliases='AI504783, CD3, CD3epsilon, T3e', description='CD3 antigen, epsilon polypeptide', other_designations='T-cell surface antigen T3/Leu-4 epsilon chain', map_location='9 24.84 cM', chromosome='9', genomic_nucleotide_accession_version='NC_000075.6', start_position_on_the_genomic_accession=44998735, end_position_on_the_genomic_accession=45009662, orientation='minus', exon_count=8, OMIM='', no_hdr0=''),
  12502 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12502, CurrentID=0, Status='live', Symbol='Cd3g', Aliases='Ctg-3, Ctg3, T3g', description='CD3 antigen, gamma polypeptide', other_designations='T-cell receptor T3 gamma chain', map_location='9 24.84 cM', chromosome='9', genomic_nucleotide_accession_version='NC_000075.6', start_position_on_the_genomic_accession=44969572, end_position_on_the_genomic_accession=44980431, orientation='minus', exon_count=7, OMIM='', no_hdr0=''),
  12503 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12503, CurrentID=0, Status='live', Symbol='Cd247', Aliases='4930549J05Rik, A430104F18Rik, AW552088, Cd3, Cd3-eta, Cd3-zeta, Cd3h, Cd3z, Cd3zeta, T3z, Tcrk, Tcrz', description='CD247 antigen', other_designations='CD3 antigen, zeta polypeptide|CD3-zeta/eta|T-cell receptor T3 eta chain|T-cell surface glycoprotein CD3 zeta chain', map_location='1 G-H', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=165780357, end_position_on_the_genomic_accession=165871153, orientation='plus', exon_count=15, OMIM='', no_hdr0=''),
  12504 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12504, CurrentID=0, Status='live', Symbol='Cd4', Aliases='L3T4, Ly-4', description='CD4 antigen', other_designations='T-cell differentiation antigen L3T4|T-cell surface antigen T4/Leu-3|T-cell surface glycoprotein CD4 precursor (T-cell surface antigen T4/Leu-3) (T-cell differentiation antigen L3T4)', map_location='6 59.17 cM', chromosome='6', genomic_nucleotide_accession_version='NC_000072.6', start_position_on_the_genomic_accession=124864693, end_position_on_the_genomic_accession=124888248, orientation='minus', exon_count=10, OMIM='', no_hdr0=''),
  667865 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=667865, CurrentID=0, Status='live', Symbol='Igkv6-17', Aliases='Igk-V19-17', description='immunoglobulin kappa variable 6-17', other_designations='Ig kappa chain V-V region MPC11|Ig kappa chain V19-17|V kappa 19-17|immunoglobulin kappa chain variable 19 (V19)-17', map_location='6 C1', chromosome='6', genomic_nucleotide_accession_version='NC_000072.6', start_position_on_the_genomic_accession=70371469, end_position_on_the_genomic_accession=70371993, orientation='plus', exon_count=0, OMIM='', no_hdr0=''),
  12506 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12506, CurrentID=0, Status='live', Symbol='Cd48', Aliases='AI449234, AW610730, BCM1, BLAST, BLAST-1, BLAST1, Bcm-1, MEM-102, SLAMF2, Sgp-60', description='CD48 antigen', other_designations='BCM1 surface antigen|HM48-1|MRC OX-45 surface antigen|SLAM family member 2|signaling lymphocytic activation molecule 2', map_location='1 79.54 cM', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=171681421, end_position_on_the_genomic_accession=171705257, orientation='plus', exon_count=7, OMIM='', no_hdr0=''),
  12507 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12507, CurrentID=0, Status='live', Symbol='Cd5', Aliases='Ly-1, Ly-12, Ly-A, Lyt-1', description='CD5 antigen', other_designations='lymphocyte antigen 1', map_location='19 7.16 cM', chromosome='19', genomic_nucleotide_accession_version='NC_000085.6', start_position_on_the_genomic_accession=10718107, end_position_on_the_genomic_accession=10739026, orientation='minus', exon_count=11, OMIM='', no_hdr0=''),
  12508 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12508, CurrentID=0, Status='live', Symbol='Cd53', Aliases='AI323659, Ox-44, Tspan25', description='CD53 antigen', other_designations='cell surface glycoprotein CD53', map_location='3 46.53 cM', chromosome='3', genomic_nucleotide_accession_version='NC_000069.6', start_position_on_the_genomic_accession=106758861, end_position_on_the_genomic_accession=106790149, orientation='minus', exon_count=8, OMIM='', no_hdr0=''),
  12509 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12509, CurrentID=0, Status='live', Symbol='Cd59a', Aliases='AA987121, Cd59, protectin', description='CD59a antigen', other_designations='CD59 antigen|MAC-IP|MAC-inhibitory protein|MACIF|membrane attack complex inhibition factor', map_location='2 54.53 cM', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=104095801, end_position_on_the_genomic_accession=104115413, orientation='plus', exon_count=6, OMIM='', no_hdr0=''),
  12511 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12511, CurrentID=0, Status='live', Symbol='Cd6', Aliases='', description='CD6 antigen', other_designations='', map_location='19 7.16 cM', chromosome='19', genomic_nucleotide_accession_version='NC_000085.6', start_position_on_the_genomic_accession=10789339, end_position_on_the_genomic_accession=10830059, orientation='minus', exon_count=13, OMIM='', no_hdr0=''),
  12512 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12512, CurrentID=0, Status='live', Symbol='Cd63', Aliases='C75951, ME491, Tspan30', description='CD63 antigen', other_designations='melanoma 1 antigen', map_location='10 77.19 cM', chromosome='10', genomic_nucleotide_accession_version='NC_000076.6', start_position_on_the_genomic_accession=128908919, end_position_on_the_genomic_accession=128912822, orientation='plus', exon_count=10, OMIM='', no_hdr0=''),
  12514 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12514, CurrentID=0, Status='live', Symbol='Cd68', Aliases='Lamp4, Scard1, gp110', description='CD68 antigen', other_designations='', map_location='11 42.86 cM', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=69664213, end_position_on_the_genomic_accession=69666170, orientation='minus', exon_count=6, OMIM='', no_hdr0=''),
  12515 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12515, CurrentID=0, Status='live', Symbol='Cd69', Aliases='5830438K24Rik, AI452015, AIM, VEA', description='CD69 antigen', other_designations='Very Early Activation Antigen', map_location='6 63.21 cM', chromosome='6', genomic_nucleotide_accession_version='NC_000072.6', start_position_on_the_genomic_accession=129267324, end_position_on_the_genomic_accession=129275369, orientation='minus', exon_count=6, OMIM='', no_hdr0=''),
  12516 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12516, CurrentID=0, Status='live', Symbol='Cd7', Aliases='', description='CD7 antigen', other_designations='', map_location='11 84.85 cM', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=121036747, end_position_on_the_genomic_accession=121039478, orientation='minus', exon_count=4, OMIM='', no_hdr0=''),
  12517 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12517, CurrentID=0, Status='live', Symbol='Cd72', Aliases='CD72c, Ly-19, Ly-32, Ly-m19, Lyb-2', description='CD72 antigen', other_designations='lymphocyte antigen 32', map_location='4 23.04 cM', chromosome='4', genomic_nucleotide_accession_version='NC_000070.6', start_position_on_the_genomic_accession=43447724, end_position_on_the_genomic_accession=43455468, orientation='minus', exon_count=9, OMIM='', no_hdr0=''),
  12518 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12518, CurrentID=0, Status='live', Symbol='Cd79a', Aliases='Ig-alpha, Iga, Igalpha, Ly-54, Ly54, mb-1', description='CD79A antigen (immunoglobulin-associated alpha)', other_designations='Ig alpha|MB-1 membrane glycoprotein|immunoglobulin-associated alpha|membrane-bound immunoglobulin-associated protein|surface IgM-associated protein', map_location='7 13.49 cM', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=24897511, end_position_on_the_genomic_accession=24902197, orientation='plus', exon_count=5, OMIM='', no_hdr0=''),
  12519 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12519, CurrentID=0, Status='live', Symbol='Cd80', Aliases='B71, Cd28l, Ly-53, Ly53, MIC17, TSA1', description='CD80 antigen', other_designations='B7 protein|activation B7-1 antigen', map_location='16 B5', chromosome='16', genomic_nucleotide_accession_version='NC_000082.6', start_position_on_the_genomic_accession=38455568, end_position_on_the_genomic_accession=38498546, orientation='plus', exon_count=8, OMIM='', no_hdr0=''),
  12520 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12520, CurrentID=0, Status='live', Symbol='Cd81', Aliases='Tapa-1, Tapa1, Tspan28', description='CD81 antigen', other_designations='26 kDa cell surface protein TAPA-1|target of the antiproliferative antibody 1', map_location='7 88.1 cM', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=143052750, end_position_on_the_genomic_accession=143067930, orientation='plus', exon_count=8, OMIM='', no_hdr0=''),
  12521 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12521, CurrentID=0, Status='live', Symbol='Cd82', Aliases='AA682076, AL023070, C33, IA4, Kai1, Tspan27', description='CD82 antigen', other_designations='C33 antigen|inducible membrane protein R2|kangai 1 (suppression of tumorigenicity 6, prostate)|metastasis suppressor Kangai-1 homolog', map_location='2 51.62 cM', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=93419102, end_position_on_the_genomic_accession=93462950, orientation='minus', exon_count=17, OMIM='', no_hdr0=''),
  667882 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=667882, CurrentID=0, Status='live', Symbol='Usp-ps', Aliases='Usp17, Usp17-3', description='ubiquitin specific peptidase, pseudogene (USP17 homolog)', other_designations='ubiquitin specific peptidase 17 (homolog)|ubiquitin specific protease 17', map_location='7 E3', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=104647249, end_position_on_the_genomic_accession=104653154, orientation='plus', exon_count=0, OMIM='', no_hdr0=''),
  12523 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12523, CurrentID=0, Status='live', Symbol='Cd84', Aliases='A130013D22Rik, CDw84, SLAMF5', description='CD84 antigen', other_designations='leukocyte differentiation antigen CD84|signaling lymphocytic activation molecule 5', map_location='1 79.54 cM', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=171839697, end_position_on_the_genomic_accession=171890718, orientation='plus', exon_count=11, OMIM='', no_hdr0=''),
  12524 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12524, CurrentID=0, Status='live', Symbol='Cd86', Aliases='B7, B7-2, B7.2, B70, CLS1, Cd28l2, ETC-1, Ly-58, Ly58, MB7, MB7-2, TS/A-2', description='CD86 antigen', other_designations='activation B7-2 antigen|early T cell costimulatory molecule-1|early T-cell costimulatory molecule 1', map_location='16 B5', chromosome='16', genomic_nucleotide_accession_version='NC_000082.6', start_position_on_the_genomic_accession=36568956, end_position_on_the_genomic_accession=36666077, orientation='minus', exon_count=13, OMIM='', no_hdr0=''),
  12525 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12525, CurrentID=0, Status='live', Symbol='Cd8a', Aliases='BB154331, Ly-2, Ly-35, Ly-B, Lyt-2', description='CD8 antigen, alpha chain', other_designations='Lyt-2.1 lymphocyte differentiation antigen (AA at 100)|T-cell surface glycoprotein Lyt-2', map_location='6 C', chromosome='6', genomic_nucleotide_accession_version='NC_000072.6', start_position_on_the_genomic_accession=71352772, end_position_on_the_genomic_accession=71379171, orientation='plus', exon_count=6, OMIM='', no_hdr0=''),
  12526 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12526, CurrentID=0, Status='live', Symbol='Cd8b1', Aliases='Cd8b, Ly-3, Ly-C, Lyt-3', description='CD8 antigen, beta chain 1', other_designations='T-cell membrane glycoprotein Ly-3|T-cell surface glycoprotein Lyt-3|lymphocyte antigen 3', map_location='6 32.14 cM', chromosome='6', genomic_nucleotide_accession_version='NC_000072.6', start_position_on_the_genomic_accession=71322812, end_position_on_the_genomic_accession=71337451, orientation='plus', exon_count=6, OMIM='', no_hdr0=''),
  12527 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12527, CurrentID=0, Status='live', Symbol='Cd9', Aliases='Tspan29', description='CD9 antigen', other_designations='', map_location='6 59.32 cM', chromosome='6', genomic_nucleotide_accession_version='NC_000072.6', start_position_on_the_genomic_accession=125460266, end_position_on_the_genomic_accession=125494755, orientation='minus', exon_count=8, OMIM='', no_hdr0=''),
  12530 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12530, CurrentID=0, Status='live', Symbol='Cdc25a', Aliases='D9Ertd393e', description='cell division cycle 25A', other_designations='dual specificity phosphatase Cdc25A', map_location='9 59.81 cM', chromosome='9', genomic_nucleotide_accession_version='NC_000075.6', start_position_on_the_genomic_accession=109875337, end_position_on_the_genomic_accession=109893895, orientation='plus', exon_count=15, OMIM='', no_hdr0=''),
  12531 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12531, CurrentID=0, Status='live', Symbol='Cdc25b', Aliases='AI604853', description='cell division cycle 25B', other_designations='dual specificity phosphatase Cdc25B', map_location='2 63.29 cM', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=131186436, end_position_on_the_genomic_accession=131198511, orientation='plus', exon_count=16, OMIM='', no_hdr0=''),
  12532 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12532, CurrentID=0, Status='live', Symbol='Cdc25c', Aliases='Cdc25', description='cell division cycle 25C', other_designations='cell cycle phosphatase CDC25C|cell division cycle control protein 25C|dual specificity phosphatase Cdc25C', map_location='18 18.71 cM', chromosome='18', genomic_nucleotide_accession_version='NC_000084.6', start_position_on_the_genomic_accession=34732993, end_position_on_the_genomic_accession=34752130, orientation='minus', exon_count=15, OMIM='', no_hdr0=''),
  12534 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12534, CurrentID=0, Status='live', Symbol='Cdk1', Aliases='Cdc2, Cdc2a, p34<CDC2>', description='cyclin-dependent kinase 1', other_designations='cell cycle p34 CDC2 kinase protein|cell division control protein 2 homolog|cell division cycle 2 homolog A|cell division cycle control protein 2a|cell division protein kinase 1|p34 protein kinase', map_location='10 36.07 cM', chromosome='10', genomic_nucleotide_accession_version='NC_000076.6', start_position_on_the_genomic_accession=69336635, end_position_on_the_genomic_accession=69352912, orientation='minus', exon_count=8, OMIM='', no_hdr0=''),
  12537 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12537, CurrentID=0, Status='live', Symbol='Cdk11b', Aliases='AA989746, CDK11-p110, CDK11-p46, CDK11-p58, Cdc11b, Cdc2l1, Cdc2l2, Cdk11, p58', description='cyclin-dependent kinase 11B', other_designations='PITSLRE proteins|PITSLRE serine/threonine-protein kinase CDC2L1|cell division cycle 2 homolog-like 1|cell division cycle 2 homolog-like 2|cell division cycle 2-like 1|cell division cycle 2-like 2|cell division cycle 2-like protein kinase 1|cell division protein kinase 11|cyclin-dependent kinase 11|galactosyltransferase-associated protein kinase p58/GTA', map_location='4 86.73 cM', chromosome='4', genomic_nucleotide_accession_version='NC_000070.6', start_position_on_the_genomic_accession=155624846, end_position_on_the_genomic_accession=155649935, orientation='plus', exon_count=23, OMIM='', no_hdr0=''),
  12539 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12539, CurrentID=0, Status='live', Symbol='Cdc37', Aliases='p50, p50Cdc37', description='cell division cycle 37', other_designations='cell division cycle 37 homolog|hsp90 chaperone protein kinase-targeting subunit', map_location='9 A3', chromosome='9', genomic_nucleotide_accession_version='NC_000075.6', start_position_on_the_genomic_accession=21138541, end_position_on_the_genomic_accession=21149977, orientation='minus', exon_count=8, OMIM='', no_hdr0=''),
  12540 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12540, CurrentID=0, Status='live', Symbol='Cdc42', Aliases='AI747189, AU018915', description='cell division cycle 42', other_designations='G25K GTP-binding protein|cell division cycle 42 homolog', map_location='4 69.83 cM', chromosome='4', genomic_nucleotide_accession_version='NC_000070.6', start_position_on_the_genomic_accession=137319696, end_position_on_the_genomic_accession=137357759, orientation='minus', exon_count=7, OMIM='', no_hdr0=''),
  12544 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12544, CurrentID=0, Status='live', Symbol='Cdc45', Aliases='Cdc45l', description='cell division cycle 45', other_designations='CDC45-related protein|PORC-PI-1|cell division cycle 45 homolog', map_location='16 11.63 cM', chromosome='16', genomic_nucleotide_accession_version='NC_000082.6', start_position_on_the_genomic_accession=18780447, end_position_on_the_genomic_accession=18811972, orientation='minus', exon_count=20, OMIM='', no_hdr0=''),
  12545 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12545, CurrentID=0, Status='live', Symbol='Cdc7', Aliases='AI597260l1, muCdc7, Cdc7', description='cell division cycle 7 (S. cerevisiae)', other_designations='CDC7-related kinase|cell division cycle 7-like 1', map_location='5 E', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=106964315, end_position_on_the_genomic_accession=106984440, orientation='plus', exon_count=13, OMIM='', no_hdr0=''),
  12549 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12549, CurrentID=0, Status='live', Symbol='Arhgap31', Aliases='5830477L08Rik, AU041750, Cdgap, D330026I07Rik', description='Rho GTPase activating protein 31', other_designations='CDC42 GTPase-activating protein', map_location='16 B4', chromosome='16', genomic_nucleotide_accession_version='NC_000082.6', start_position_on_the_genomic_accession=38598343, end_position_on_the_genomic_accession=38713035, orientation='minus', exon_count=12, OMIM='', no_hdr0=''),
  12550 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12550, CurrentID=0, Status='live', Symbol='Cdh1', Aliases='AA960649, ARC-1, E-cad, Ecad, L-CAM, UVO, Um', description='cadherin 1', other_designations='E-cadherin|epithelial cadherin|uvomorulin', map_location='8 D', chromosome='8', genomic_nucleotide_accession_version='NC_000074.6', start_position_on_the_genomic_accession=106603368, end_position_on_the_genomic_accession=106670246, orientation='plus', exon_count=16, OMIM='', no_hdr0=''),
  12552 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12552, CurrentID=0, Status='live', Symbol='Cdh11', Aliases='Cad11, OSF-4', description='cadherin 11', other_designations='OB-cadherin|osteoblast cadherin|osteoblast-cadherin', map_location='8 50.44 cM', chromosome='8', genomic_nucleotide_accession_version='NC_000074.6', start_position_on_the_genomic_accession=102632095, end_position_on_the_genomic_accession=102785480, orientation='minus', exon_count=15, OMIM='', no_hdr0=''),
  12554 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12554, CurrentID=0, Status='live', Symbol='Cdh13', Aliases='4932416G01Rik, Cdht, Tcad', description='cadherin 13', other_designations='H-cadherin|T-cadherin|heart cadherin', map_location='8 65.97 cM', chromosome='8', genomic_nucleotide_accession_version='NC_000074.6', start_position_on_the_genomic_accession=118032249, end_position_on_the_genomic_accession=119324929, orientation='plus', exon_count=18, OMIM='', no_hdr0=''),
  12555 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12555, CurrentID=0, Status='live', Symbol='Cdh15', Aliases='AI323380, Cdh14, Mcad', description='cadherin 15', other_designations='M-cadherin|cadherin-14|muscle cadherin', map_location='8 71.99 cM', chromosome='8', genomic_nucleotide_accession_version='NC_000074.6', start_position_on_the_genomic_accession=122848374, end_position_on_the_genomic_accession=122867397, orientation='plus', exon_count=14, OMIM='', no_hdr0=''),
  12556 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12556, CurrentID=0, Status='live', Symbol='Cdh16', Aliases='', description='cadherin 16', other_designations='KSP-cadherin|kidney-specific cadherin', map_location='8 53.04 cM', chromosome='8', genomic_nucleotide_accession_version='NC_000074.6', start_position_on_the_genomic_accession=104601915, end_position_on_the_genomic_accession=104624396, orientation='minus', exon_count=19, OMIM='', no_hdr0=''),
  12557 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12557, CurrentID=0, Status='live', Symbol='Cdh17', Aliases='HPT-1, HPT-1/LI', description='cadherin 17', other_designations='BILL-cadherin|LI-cadherin|P130|liver-intestine cadherin', map_location='4 A2', chromosome='4', genomic_nucleotide_accession_version='NC_000070.6', start_position_on_the_genomic_accession=11758157, end_position_on_the_genomic_accession=11817905, orientation='plus', exon_count=20, OMIM='', no_hdr0=''),
  12558 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12558, CurrentID=0, Status='live', Symbol='Cdh2', Aliases='CDHN, N-CAD, Ncad', description='cadherin 2', other_designations='N-cadherin|neural cadherin', map_location='18 10.1 cM', chromosome='18', genomic_nucleotide_accession_version='NC_000084.6', start_position_on_the_genomic_accession=16588877, end_position_on_the_genomic_accession=16809049, orientation='minus', exon_count=17, OMIM='', no_hdr0=''),
  12560 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12560, CurrentID=0, Status='live', Symbol='Cdh3', Aliases='AI385538, Cadp, Cdhp, P-cadherin, Pcad', description='cadherin 3', other_designations='RPE-specific cadherin|placental cadherin', map_location='8 53.16 cM', chromosome='8', genomic_nucleotide_accession_version='NC_000074.6', start_position_on_the_genomic_accession=106510852, end_position_on_the_genomic_accession=106556911, orientation='plus', exon_count=16, OMIM='', no_hdr0=''),
  12561 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12561, CurrentID=0, Status='live', Symbol='Cdh4', Aliases='AW120700, R-CAD, R-Cadh, Rcad', description='cadherin 4', other_designations='R-cadherin|retina cadherin|retinal cadherin', map_location='2 101.86 cM', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=179442478, end_position_on_the_genomic_accession=179899377, orientation='plus', exon_count=18, OMIM='', no_hdr0=''),
  12562 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12562, CurrentID=0, Status='live', Symbol='Cdh5', Aliases='7B4, AA408225, Cd144, VE-Cad, VECD, VEcad, Vec', description='cadherin 5', other_designations='7B4/cadherin-5|VE-cadherin|vascular endothelial cadherin', map_location='8 53.04 cM', chromosome='8', genomic_nucleotide_accession_version='NC_000074.6', start_position_on_the_genomic_accession=104101613, end_position_on_the_genomic_accession=104144504, orientation='plus', exon_count=13, OMIM='', no_hdr0=''),
  12563 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12563, CurrentID=0, Status='live', Symbol='Cdh6', Aliases='cad6', description='cadherin 6', other_designations='K-cadherin|kidney cadherin', map_location='15 A1', chromosome='15', genomic_nucleotide_accession_version='NC_000081.6', start_position_on_the_genomic_accession=13028699, end_position_on_the_genomic_accession=13173689, orientation='minus', exon_count=13, OMIM='', no_hdr0=''),
  667924 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=667924, CurrentID=0, Status='live', Symbol='Igkv3-10', Aliases='IgK21-10, Igk-V21-10', description='immunoglobulin kappa variable 3-10', other_designations='Ig kappa chain V-III region MOPC 63|V-kappa-21B|immunoglobulin kappa chain variable 21 (V21)-10|immunoglobulin kappa chain variable 3-10', map_location='6 C1', chromosome='6', genomic_nucleotide_accession_version='NC_000072.6', start_position_on_the_genomic_accession=70572633, end_position_on_the_genomic_accession=70573230, orientation='plus', exon_count=0, OMIM='', no_hdr0=''),
  12565 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12565, CurrentID=0, Status='live', Symbol='Cdh9', Aliases='', description='cadherin 9', other_designations='T1-cadherin', map_location='15 A2', chromosome='15', genomic_nucleotide_accession_version='NC_000081.6', start_position_on_the_genomic_accession=16728549, end_position_on_the_genomic_accession=16857097, orientation='plus', exon_count=14, OMIM='', no_hdr0=''),
  12566 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12566, CurrentID=0, Status='live', Symbol='Cdk2', Aliases='A630093N05Rik', description='cyclin-dependent kinase 2', other_designations='cell division protein kinase 2', map_location='10 D3', chromosome='10', genomic_nucleotide_accession_version='NC_000076.6', start_position_on_the_genomic_accession=128697938, end_position_on_the_genomic_accession=128705051, orientation='minus', exon_count=9, OMIM='', no_hdr0=''),
  12567 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12567, CurrentID=0, Status='live', Symbol='Cdk4', Aliases='Crk3', description='cyclin-dependent kinase 4', other_designations='PSK-J3|cell division protein kinase 4|cyclin dependent kinase 4|p34<PSK-J3>/cdk4|serine/threonine kinase', map_location='10 D3', chromosome='10', genomic_nucleotide_accession_version='NC_000076.6', start_position_on_the_genomic_accession=127063537, end_position_on_the_genomic_accession=127067288, orientation='plus', exon_count=8, OMIM='', no_hdr0=''),
  12568 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12568, CurrentID=0, Status='live', Symbol='Cdk5', Aliases='AW048668, Crk6', description='cyclin-dependent kinase 5', other_designations='CR6 protein kinase|TPKII catalytic subunit|cell division protein kinase 5|serine/threonine-protein kinase PSSALRE|tau protein kinase II catalytic subunit', map_location='5 11.73 cM', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=24407597, end_position_on_the_genomic_accession=24423591, orientation='minus', exon_count=14, OMIM='', no_hdr0=''),
  12569 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12569, CurrentID=0, Status='live', Symbol='Cdk5r1', Aliases='Cdk5r, D11Bwg0379e, p25, p35', description='cyclin-dependent kinase 5, regulatory subunit 1 (p35)', other_designations='CDK5 activator 1|TPKII regulatory subunit|cyclin-dependent kinase 5 regulatory subunit 1|cyclin-dependent kinase 5, regulatory subunit (p35) 1', map_location='11 47.94 cM', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=80477046, end_position_on_the_genomic_accession=80481179, orientation='plus', exon_count=1, OMIM='', no_hdr0=''),
  12570 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12570, CurrentID=0, Status='live', Symbol='Cdk5r2', Aliases='B230310J22Rik, p39', description='cyclin-dependent kinase 5, regulatory subunit 2 (p39)', other_designations='CDK5 activator 2|cyclin-dependent kinase 5 regulatory subunit 2|p39I', map_location='1 C3', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=74855029, end_position_on_the_genomic_accession=74857732, orientation='plus', exon_count=1, OMIM='', no_hdr0=''),
  12571 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12571, CurrentID=0, Status='live', Symbol='Cdk6', Aliases='AI504062, Crk2', description='cyclin-dependent kinase 6', other_designations='CR2 protein kinase|cell division protein kinase 6|serine/threonine-protein kinase PLSTIRE', map_location='5 2.04 cM', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=3343891, end_position_on_the_genomic_accession=3531008, orientation='plus', exon_count=8, OMIM='', no_hdr0=''),
  12572 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12572, CurrentID=0, Status='live', Symbol='Cdk7', Aliases='AI323415, AI528512, C230069N13, Cdkn7, Crk4', description='cyclin-dependent kinase 7', other_designations='39 kDa protein kinase|CAK|CDK-activating kinase|CR4 protein kinase|CRK4 PK (CDC2-related-kinase-4 protein kinase)|P39 Mo15|TFIIH basal transcription factor complex kinase subunit|cell division protein kinase 7|cyclin-dependent kinase 7 (homolog of Xenopus MO15 cdk-activating kinase)|protein-tyrosine kinase MPK-7', map_location='13 53.23 cM', chromosome='13', genomic_nucleotide_accession_version='NC_000079.6', start_position_on_the_genomic_accession=100697024, end_position_on_the_genomic_accession=100730942, orientation='minus', exon_count=12, OMIM='', no_hdr0=''),
  12575 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12575, CurrentID=0, Status='live', Symbol='Cdkn1a', Aliases='CAP20, CDKI, CIP1, Cdkn1, P21, SDI1, Waf1, mda6, p21Cip1, p21WAF', description='cyclin-dependent kinase inhibitor 1A (P21)', other_designations='CDK-interacting protein 1|melanoma differentiation-associated protein', map_location='17 15.12 cM', chromosome='17', genomic_nucleotide_accession_version='NC_000083.6', start_position_on_the_genomic_accession=29090986, end_position_on_the_genomic_accession=29100722, orientation='plus', exon_count=4, OMIM='', no_hdr0=''),
  12576 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12576, CurrentID=0, Status='live', Symbol='Cdkn1b', Aliases='AA408329, AI843786, Kip1, p27, p27Kip1', description='cyclin-dependent kinase inhibitor 1B', other_designations='cyclin-dependent kinase inhibitor p27', map_location='6 65.77 cM', chromosome='6', genomic_nucleotide_accession_version='NC_000072.6', start_position_on_the_genomic_accession=134920401, end_position_on_the_genomic_accession=134925525, orientation='plus', exon_count=3, OMIM='', no_hdr0=''),
  12577 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12577, CurrentID=0, Status='live', Symbol='Cdkn1c', Aliases='AL024410, CDKI, Kip2, p57(kip2), p57Kip2', description='cyclin-dependent kinase inhibitor 1C (P57)', other_designations='cyclin-dependent kinase inhibitor p57', map_location='7 88.22 cM', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=143458339, end_position_on_the_genomic_accession=143461072, orientation='minus', exon_count=4, OMIM='', no_hdr0=''),
  12578 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12578, CurrentID=0, Status='live', Symbol='Cdkn2a', Aliases='ARF-INK4a, Arf, INK4a-ARF, Ink4a/Arf, MTS1, Pctr1, p16, p16(INK4a), p16INK4a, p19<ARF>, p19ARF', description='cyclin-dependent kinase inhibitor 2A', other_designations='CDK4I|alternative reading frame|cdkn2a|cyclin-dependent kinase 4 inhibitor A|cyclin-dependent kinase inhibitor 2A (p16, inhibits CDK4)|cyclin-dependent kinase inhibitor 2A, isoforms 1/2|cyclin-dependent kinase inhibitor protein|mitochondrial smARF|p16-INK4|p16-INK4a', map_location='4 C3-C6', chromosome='4', genomic_nucleotide_accession_version='NC_000070.6', start_position_on_the_genomic_accession=89274473, end_position_on_the_genomic_accession=89294619, orientation='minus', exon_count=4, OMIM='', no_hdr0=''),
  12579 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12579, CurrentID=0, Status='live', Symbol='Cdkn2b', Aliases='AV083695, INK4b, MTS2, p15, p15(INK4b), p15INK4b', description='cyclin-dependent kinase inhibitor 2B (p15, inhibits CDK4)', other_designations='cyclin-dependent kinase inhibitor p15|cyclin-dependent kinase inhibitor p15INK4b|cyclin-dependent kinase inhibitor protein|p14-INK4b|p15-INK4b', map_location='4 C3-C6', chromosome='4', genomic_nucleotide_accession_version='NC_000070.6', start_position_on_the_genomic_accession=89306289, end_position_on_the_genomic_accession=89311032, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  667940 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=667940, CurrentID=0, Status='live', Symbol='Igkv3-5', Aliases='Gm16774, IgK21-5, Igk-V21-5', description='immunoglobulin kappa chain variable 3-5', other_designations='V-kappa-21C|immunoglobulin kappa chain variable 21 (V21)-5', map_location='6 C1', chromosome='6', genomic_nucleotide_accession_version='NC_000072.6', start_position_on_the_genomic_accession=70663298, end_position_on_the_genomic_accession=70663895, orientation='plus', exon_count=0, OMIM='', no_hdr0=''),
  12581 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12581, CurrentID=0, Status='live', Symbol='Cdkn2d', Aliases='INK4d, p19, p19INK4d', description='cyclin-dependent kinase inhibitor 2D (p19, inhibits CDK4)', other_designations='p19-INK4d', map_location='9 A3', chromosome='9', genomic_nucleotide_accession_version='NC_000075.6', start_position_on_the_genomic_accession=21288459, end_position_on_the_genomic_accession=21291402, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  12582 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12582, CurrentID=0, Status='live', Symbol='cdm', Aliases='', description='cadmium resistance', other_designations='', map_location='', chromosome='3', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  12583 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12583, CurrentID=0, Status='live', Symbol='Cdo1', Aliases='1300002L19Rik, Cdo, D18Ucla3', description='cysteine dioxygenase 1, cytosolic', other_designations='CDO-I|cysteine dioxygenase type I|cytosolic cysteine dioxygenase 1', map_location='18 24.75 cM', chromosome='18', genomic_nucleotide_accession_version='NC_000084.6', start_position_on_the_genomic_accession=46713205, end_position_on_the_genomic_accession=46728542, orientation='minus', exon_count=5, OMIM='', no_hdr0=''),
  12585 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12585, CurrentID=0, Status='live', Symbol='Cdr2', Aliases='AA617262', description='cerebellar degeneration-related 2', other_designations='', map_location='7 65.04 cM', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=120957036, end_position_on_the_genomic_accession=120982312, orientation='minus', exon_count=5, OMIM='', no_hdr0=''),
  12587 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12587, CurrentID=0, Status='live', Symbol='Mia', Aliases='CD-RAP, Cdrap1, Mia', description='melanoma inhibitory activity', other_designations='cartilage derived retinoic acid sensitive protein|cartilage-derived retinoic acid-sensitive protein|melanoma inhibitory activity 1|melanoma inhibitory activity protein|melanoma-inhibitory-activity', map_location='7 15.84 cM', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=27179741, end_position_on_the_genomic_accession=27181149, orientation='minus', exon_count=4, OMIM='', no_hdr0=''),
  12589 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12589, CurrentID=0, Status='live', Symbol='Ift81', Aliases='AW060663, Cdv-1, Cdv-1r, Cdv1', description='intraflagellar transport 81', other_designations='carnitine deficiency-associated gene expressed in ventricle 1|carnitine deficiency-associated protein expressed in ventricle 1|intraflagellar transport 81 homolog', map_location='5 62.44 cM', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=122540265, end_position_on_the_genomic_accession=122614546, orientation='minus', exon_count=20, OMIM='', no_hdr0=''),
  12590 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12590, CurrentID=0, Status='live', Symbol='Cdx1', Aliases='Cdx, Cdx-1', description='caudal type homeobox 1', other_designations='caudal type homeo box 1|caudal type homeobox transcription factor 1|caudal-type homeobox protein 1', map_location='18 34.41 cM', chromosome='18', genomic_nucleotide_accession_version='NC_000084.6', start_position_on_the_genomic_accession=61018862, end_position_on_the_genomic_accession=61036199, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  12591 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12591, CurrentID=0, Status='live', Symbol='Cdx2', Aliases='Cdx-2', description='caudal type homeobox 2', other_designations='caudal type homeo box 2|caudal-type homeobox protein 2', map_location='5 G2-G3', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=147300900, end_position_on_the_genomic_accession=147307249, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  12592 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12592, CurrentID=0, Status='live', Symbol='Cdx4', Aliases='Cdx-3, Cdx-4, Cdx3', description='caudal type homeobox 4', other_designations='caudal type homeo box 4|caudal-type homeobox protein 4', map_location='X 46.06 cM', chromosome='X', genomic_nucleotide_accession_version='NC_000086.7', start_position_on_the_genomic_accession=103321398, end_position_on_the_genomic_accession=103330224, orientation='plus', exon_count=3, OMIM='', no_hdr0=''),
  12593 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12593, CurrentID=0, Status='live', Symbol='Cdyl', Aliases='AI325931', description='chromodomain protein, Y chromosome-like', other_designations='CDY-like', map_location='13 14.39 cM', chromosome='13', genomic_nucleotide_accession_version='NC_000079.6', start_position_on_the_genomic_accession=35659811, end_position_on_the_genomic_accession=35874064, orientation='plus', exon_count=12, OMIM='', no_hdr0=''),
  12606 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12606, CurrentID=0, Status='live', Symbol='Cebpa', Aliases='C/ebpalpha, CBF-A, Cebp', description='CCAAT/enhancer binding protein (C/EBP), alpha', other_designations='C/EBP alpha', map_location='7 21.02 cM', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=35119293, end_position_on_the_genomic_accession=35121928, orientation='plus', exon_count=1, OMIM='', no_hdr0=''),
  12607 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12607, CurrentID=0, Status='live', Symbol='Cebpz', Aliases='AI848081, CBF2, Cbf, Cebpa-rs1', description='CCAAT/enhancer binding protein zeta', other_designations='CCAAT-binding factor|CCAAT-box-binding transcription factor|CCAAT/enhancer binding protein alpha (C/EBP) related sequence 1', map_location='17 E3', chromosome='17', genomic_nucleotide_accession_version='NC_000083.6', start_position_on_the_genomic_accession=78919003, end_position_on_the_genomic_accession=78937070, orientation='minus', exon_count=16, OMIM='', no_hdr0=''),
  12608 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12608, CurrentID=0, Status='live', Symbol='Cebpb', Aliases='C/EBPbeta, CRP2, IL-6DBP, LAP, LIP, NF-IL6, NF-M, Nfil6', description='CCAAT/enhancer binding protein (C/EBP), beta', other_designations='AGP/EBP|C/EBP BETA|interleukin-6-dependent-binding protein|liver-enriched transcriptional activator|nuclear protein Il6', map_location='2 87.58 cM', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=167688915, end_position_on_the_genomic_accession=167690432, orientation='plus', exon_count=1, OMIM='', no_hdr0=''),
  12609 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12609, CurrentID=0, Status='live', Symbol='Cebpd', Aliases='c/EBPdelta', description='CCAAT/enhancer binding protein (C/EBP), delta', other_designations='C/EBP delta|c/EBP-related protein 3', map_location='16 10.09 cM', chromosome='16', genomic_nucleotide_accession_version='NC_000082.6', start_position_on_the_genomic_accession=15887286, end_position_on_the_genomic_accession=15889545, orientation='plus', exon_count=1, OMIM='', no_hdr0=''),
  12611 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12611, CurrentID=0, Status='live', Symbol='Cebpg', Aliases='C/EBP[g], C/EBPgamma, GPE1-BP, Gpe1bp, Ig/EBP', description='CCAAT/enhancer binding protein (C/EBP), gamma', other_designations='G-CSF promoter element 1 binding protein|GPE1-BP (C/EBP gamma)|GPE1-binding protein|IG/EBP-1|c/EBP gamma|granulocyte colony-stimulating factor promoter element 1-binding protein|immunoglobulin enhancer-binding protein 1', map_location='7 B1', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=35046422, end_position_on_the_genomic_accession=35056590, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  12613 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12613, CurrentID=0, Status='live', Symbol='Cel', Aliases='1810036E18Rik, BAL', description='carboxyl ester lipase', other_designations='BSSL|bile salt-stimulated lipase|cholesterol esterase|pancreatic lysophospholipase|sterol esterase', map_location='2 19.38 cM', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=28555819, end_position_on_the_genomic_accession=28563362, orientation='minus', exon_count=11, OMIM='', no_hdr0=''),
  12614 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12614, CurrentID=0, Status='live', Symbol='Celsr1', Aliases='Adgrc1, Crsh, Scy, crash', description='cadherin, EGF LAG seven-pass G-type receptor 1', other_designations='cadherin, EGF LAG seven-pass G-type receptor 1 (flamingo homolog, Drosophila)|seven-pass transmembrane receptor', map_location='15 40.42 cM', chromosome='15', genomic_nucleotide_accession_version='NC_000081.6', start_position_on_the_genomic_accession=85898758, end_position_on_the_genomic_accession=86034217, orientation='minus', exon_count=37, OMIM='', no_hdr0=''),
  12615 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12615, CurrentID=0, Status='live', Symbol='Cenpa', Aliases='Cenp-A', description='centromere protein A', other_designations='centromere autoantigen A|centrosomin A', map_location='5 16.76 cM', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=30666876, end_position_on_the_genomic_accession=30674837, orientation='plus', exon_count=8, OMIM='', no_hdr0=''),
  12616 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12616, CurrentID=0, Status='live', Symbol='Cenpb', Aliases='CENP-B', description='centromere protein B', other_designations='centromere autoantigen B', map_location='2 63.29 cM', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=131177289, end_position_on_the_genomic_accession=131180012, orientation='minus', exon_count=1, OMIM='', no_hdr0=''),
  12617 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12617, CurrentID=0, Status='live', Symbol='Cenpc1', Aliases='CENP-C, Cenpc', description='centromere protein C1', other_designations='CENP-C 1|CENTROMERE PROTEIN C (CENP-C) (CENTROMERE AUTOANTIGEN C)|centromere autoantigen C1', map_location='5 E2-E5', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=86012018, end_position_on_the_genomic_accession=86066019, orientation='minus', exon_count=20, OMIM='', no_hdr0=''),
  12622 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12622, CurrentID=0, Status='live', Symbol='Cer1', Aliases='Cerl, Cerl1, Cerr1, cer-1', description='cerberus 1, DAN family BMP antagonist', other_designations='cer-l|cerberus 1 homolog|cerberus homolog|cerberus-like protein|cerberus-related protein', map_location='4 39.4 cM', chromosome='4', genomic_nucleotide_accession_version='NC_000070.6', start_position_on_the_genomic_accession=82879909, end_position_on_the_genomic_accession=82892647, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  12623 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12623, CurrentID=0, Status='live', Symbol='Ces1g', Aliases='Ces-1, Ces1, Ses-1', description='carboxylesterase 1G', other_designations='ES-x|acyl coenzyme A:cholesterol acyltransferase|acyl-coenzyme A:cholesterol acyltransferase|carboxylesterase 1', map_location='8 45.29 cM', chromosome='8', genomic_nucleotide_accession_version='NC_000074.6', start_position_on_the_genomic_accession=93302369, end_position_on_the_genomic_accession=93337209, orientation='minus', exon_count=14, OMIM='', no_hdr0=''),
  12626 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12626, CurrentID=0, Status='live', Symbol='Cetn3', Aliases='MmCEN3', description='centrin 3', other_designations='', map_location='13 C3', chromosome='13', genomic_nucleotide_accession_version='NC_000079.6', start_position_on_the_genomic_accession=81783247, end_position_on_the_genomic_accession=81797157, orientation='plus', exon_count=6, OMIM='', no_hdr0=''),
  12627 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12627, CurrentID=0, Status='live', Symbol='Cfc1', Aliases='AV265756, b2b970Clo, cryptic', description='cripto, FRL-1, cryptic family 1', other_designations='', map_location='1 B', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=34535648, end_position_on_the_genomic_accession=34544311, orientation='plus', exon_count=6, OMIM='', no_hdr0=''),
  12628 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12628, CurrentID=0, Status='live', Symbol='Cfh', Aliases='Mud-1, NOM, Sas-1, Sas1', description='complement component factor h', other_designations='complement factor H related protein 3A4/5G4|protein beta-1-H', map_location='1 F', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=140085855, end_position_on_the_genomic_accession=140183411, orientation='minus', exon_count=22, OMIM='', no_hdr0=''),
  12630 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12630, CurrentID=0, Status='live', Symbol='Cfi', Aliases='', description='complement component factor i', other_designations='C3B/C4B inactivator', map_location='3 59.21 cM', chromosome='3', genomic_nucleotide_accession_version='NC_000069.6', start_position_on_the_genomic_accession=129835889, end_position_on_the_genomic_accession=129875329, orientation='plus', exon_count=15, OMIM='', no_hdr0=''),
  12631 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12631, CurrentID=0, Status='live', Symbol='Cfl1', Aliases='AA959946, Cof', description='cofilin 1, non-muscle', other_designations='cofilin, non-muscle isoform|n-cofilin', map_location='19 A', chromosome='19', genomic_nucleotide_accession_version='NC_000085.6', start_position_on_the_genomic_accession=5490455, end_position_on_the_genomic_accession=5494031, orientation='plus', exon_count=4, OMIM='', no_hdr0=''),
  667992 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=667992, CurrentID=0, Status='live', Symbol='Tas2r103', Aliases='EG667992, T2R3, TRB2, Tas2r10, Tas2r3, mGR03, mt2r63', description='taste receptor, type 2, member 103', other_designations='T2R10|T2R103|taste receptor family B member 2|taste receptor type 2 member 10', map_location='6 64.03 cM', chromosome='6', genomic_nucleotide_accession_version='NC_000072.6', start_position_on_the_genomic_accession=133036163, end_position_on_the_genomic_accession=133037101, orientation='minus', exon_count=1, OMIM='', no_hdr0=''),
  12633 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12633, CurrentID=0, Status='live', Symbol='Cflar', Aliases='2310024N18Rik, A430105C05Rik, CLARP, Cash, Casper, ENSMUSG00000072980, FLAME, FLAME-1, Flip, Gm9845, I-FLICE, MRIT, c-Flip', description='CASP8 and FADD-like apoptosis regulator', other_designations='FADD-like antiapoptotic molecule 1|MACH-related inducer of toxicity|caspase homolog|caspase-eight-related protein|caspase-like apoptosis regulatory protein|cellular FLICE-like inhibitory protein|inhibitor of FLICE|usurpin', map_location='1 29.16 cM', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=58711310, end_position_on_the_genomic_accession=58759209, orientation='plus', exon_count=14, OMIM='', no_hdr0=''),
  12638 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12638, CurrentID=0, Status='live', Symbol='Cftr', Aliases='AW495489, Abcc7', description='cystic fibrosis transmembrane conductance regulator', other_designations='ATP-binding cassette sub-family C member 7|ATP-binding cassette transporter sub-family C member 7|ATP-binding cassette, subfamily c, member 7|cAMP-dependent chloride channel|channel conductance-controlling ATPase|cystic fibrosis transmembrane conductance regulator homolog|cystic fibrosis transmembrane conductance regulator homolog; ATP-binding cassette, subfamily c, member 7', map_location='6 8.1 cM', chromosome='6', genomic_nucleotide_accession_version='NC_000072.6', start_position_on_the_genomic_accession=18170262, end_position_on_the_genomic_accession=18322774, orientation='plus', exon_count=28, OMIM='', no_hdr0=''),
  12640 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12640, CurrentID=0, Status='live', Symbol='Cga', Aliases='CG-alpha, FSHA, GPHA1, GPHalpha, HCG, LHA, Tsha, aGSU, alpha-GSU, alphaGSU, alphaSU', description='glycoprotein hormones, alpha subunit', other_designations='FSH-alpha|LSH-alpha|TSH-alpha|anterior pituitary glycoprotein hormones common subunit alpha|follicle-stimulating hormone alpha chain|follitropin alpha chain|luteinizing hormone alpha chain|lutropin alpha chain|thyroid-stimulating hormone alpha chain|thyrotropin alpha chain', map_location='4 16.86 cM', chromosome='4', genomic_nucleotide_accession_version='NC_000070.6', start_position_on_the_genomic_accession=34893779, end_position_on_the_genomic_accession=34907374, orientation='plus', exon_count=5, OMIM='', no_hdr0=''),
  12642 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12642, CurrentID=0, Status='live', Symbol='Ch25h', Aliases='AI462618, m25OH', description='cholesterol 25-hydroxylase', other_designations='cholesterol 25-monooxygenase', map_location='19 C1', chromosome='19', genomic_nucleotide_accession_version='NC_000085.6', start_position_on_the_genomic_accession=34473783, end_position_on_the_genomic_accession=34475135, orientation='minus', exon_count=1, OMIM='', no_hdr0=''),
  12643 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12643, CurrentID=0, Status='live', Symbol='Chad', Aliases='SLRR4A', description='chondroadherin', other_designations='cartilage leucine-rich protein', map_location='11 58.9 cM', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=94565074, end_position_on_the_genomic_accession=94569127, orientation='plus', exon_count=4, OMIM='', no_hdr0=''),
  111334 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=111334, CurrentID=0, Status='live', Symbol='Cd1', Aliases='', description='CD1 antigen complex', other_designations='', map_location='', chromosome='3', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  12647 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12647, CurrentID=0, Status='live', Symbol='Chat', Aliases='B230380D24Rik', description='choline acetyltransferase', other_designations='CHOACTase|choline acetylase', map_location='14 19.4 cM', chromosome='14', genomic_nucleotide_accession_version='NC_000080.6', start_position_on_the_genomic_accession=32408203, end_position_on_the_genomic_accession=32465909, orientation='minus', exon_count=16, OMIM='', no_hdr0=''),
  12648 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12648, CurrentID=0, Status='live', Symbol='Chd1', Aliases='4930525N21Rik, AI851787, AW555109', description='chromodomain helicase DNA binding protein 1', other_designations='ATP-dependent helicase CHD1|CHD-1', map_location='17 8.95 cM', chromosome='17', genomic_nucleotide_accession_version='NC_000083.6', start_position_on_the_genomic_accession=15704967, end_position_on_the_genomic_accession=15772612, orientation='plus', exon_count=36, OMIM='', no_hdr0=''),
  12649 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12649, CurrentID=0, Status='live', Symbol='Chek1', Aliases='C85740, Chk1, rad27', description='checkpoint kinase 1', other_designations='CHK1 checkpoint homolog|checkpoint kinase 1 homolog|checkpoint kinase-1|rad27 homolog', map_location='9 A5.3', chromosome='9', genomic_nucleotide_accession_version='NC_000075.6', start_position_on_the_genomic_accession=36708482, end_position_on_the_genomic_accession=36726658, orientation='minus', exon_count=13, OMIM='', no_hdr0=''),
  12651 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12651, CurrentID=0, Status='live', Symbol='Chkb', Aliases='Chetk, Chkl, Ck, Ck/Ek, Ck/Ek-beta, Ckb, Ckekb, Ek', description='choline kinase beta', other_designations='choline/ethanolamine kinase-b|choline/ethanolaminekinase|ethanolamine kinase', map_location='15 E3', chromosome='15', genomic_nucleotide_accession_version='NC_000081.6', start_position_on_the_genomic_accession=89426349, end_position_on_the_genomic_accession=89429927, orientation='minus', exon_count=11, OMIM='', no_hdr0=''),
  12652 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12652, CurrentID=0, Status='live', Symbol='Chga', Aliases='ChrA, cgA', description='chromogranin A', other_designations='', map_location='12 51.66 cM', chromosome='12', genomic_nucleotide_accession_version='NC_000078.6', start_position_on_the_genomic_accession=102554969, end_position_on_the_genomic_accession=102565027, orientation='plus', exon_count=8, OMIM='', no_hdr0=''),
  12653 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12653, CurrentID=0, Status='live', Symbol='Chgb', Aliases='Scg-1', description='chromogranin B', other_designations='cgB|chromogranin-B|secretogranin I|sgI', map_location='2 F-G', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=132781278, end_position_on_the_genomic_accession=132795072, orientation='plus', exon_count=5, OMIM='', no_hdr0=''),
  12654 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12654, CurrentID=0, Status='live', Symbol='Chil1', Aliases='AW208766, Brp39, Chi3l1, Gp39', description='chitinase-like 1', other_designations='CGP-39|GP-39|breast regression protein 39|cartilage glycoprotein 39|chitinase 3-like 1', map_location='1 58.15 cM', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=134182164, end_position_on_the_genomic_accession=134190031, orientation='plus', exon_count=11, OMIM='', no_hdr0=''),
  12655 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12655, CurrentID=0, Status='live', Symbol='Chil3', Aliases='AI505981, Chi3l3, ECF-L, Ym1', description='chitinase-like 3', other_designations='beta-N-acetylhexosaminidase Ym1|eosinophil chemotactic cytokine|eosinophil chemotactic factor-L|secreted protein Ym1', map_location='3 46.49 cM', chromosome='3', genomic_nucleotide_accession_version='NC_000069.6', start_position_on_the_genomic_accession=106147554, end_position_on_the_genomic_accession=106167564, orientation='minus', exon_count=11, OMIM='', no_hdr0=''),
  242408 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=242408, CurrentID=0, Status='live', Symbol='Fam221b', Aliases='4930412F15Rik', description='family with sequence similarity 221, member B', other_designations='uncharacterized protein C9orf128 homolog', map_location='4 B1', chromosome='4', genomic_nucleotide_accession_version='NC_000070.6', start_position_on_the_genomic_accession=43659622, end_position_on_the_genomic_accession=43668859, orientation='minus', exon_count=7, OMIM='', no_hdr0=''),
  12659 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12659, CurrentID=0, Status='live', Symbol='Ovgp1', Aliases='120kDa, AU016433, AU019448, Chit5, MOGP, OGP, muc9', description='oviductal glycoprotein 1', other_designations='chitinase 5|estrogen-dependent oviduct protein|mucin 9|oviduct glycoprotein OGP|oviductal glycoprotein 1, 120kD|oviductin', map_location='3 F3', chromosome='3', genomic_nucleotide_accession_version='NC_000069.6', start_position_on_the_genomic_accession=105973802, end_position_on_the_genomic_accession=105987423, orientation='plus', exon_count=11, OMIM='', no_hdr0=''),
  12660 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12660, CurrentID=0, Status='live', Symbol='Chka', Aliases='CK, CK/EK-alpha, Chetk-alpha, Chk, ChoK, EK, EtnK-alpha', description='choline kinase alpha', other_designations='choline/ethanolamine kinase alpha|ethanolamine kinase', map_location='19 3.57 cM', chromosome='19', genomic_nucleotide_accession_version='NC_000085.6', start_position_on_the_genomic_accession=3851585, end_position_on_the_genomic_accession=3894369, orientation='plus', exon_count=15, OMIM='', no_hdr0=''),
  12661 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12661, CurrentID=0, Status='live', Symbol='Chl1', Aliases='A530023M13Rik, AI465420, CALL, LICAM2', description='cell adhesion molecule L1-like', other_designations='cell adhesion molecule with homology to L1CAM|chl1-like protein|close homolog of L1', map_location='6 E1', chromosome='6', genomic_nucleotide_accession_version='NC_000072.6', start_position_on_the_genomic_accession=103510582, end_position_on_the_genomic_accession=103733038, orientation='plus', exon_count=30, OMIM='', no_hdr0=''),
  12662 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12662, CurrentID=0, Status='live', Symbol='Chm', Aliases='Rep-1', description='choroidermia (RAB escort protein 1)', other_designations='choroideraemia protein homolog|choroideremia protein homolog|rab escort protein 1', map_location='X E1', chromosome='X', genomic_nucleotide_accession_version='NC_000086.7', start_position_on_the_genomic_accession=113040590, end_position_on_the_genomic_accession=113185539, orientation='minus', exon_count=18, OMIM='', no_hdr0=''),
  12663 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12663, CurrentID=0, Status='live', Symbol='Chml', Aliases='AI450814, E030003F13Rik, REP-2, Rep2', description='choroideremia-like', other_designations='choroideraemia-like protein|choroideremia-like protein|rab escort protein 2|rab escort protein-2', map_location='1 H5-H6', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=175682237, end_position_on_the_genomic_accession=175688353, orientation='minus', exon_count=1, OMIM='', no_hdr0=''),
  12667 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12667, CurrentID=0, Status='live', Symbol='Chrd', Aliases='Chd', description='chordin', other_designations='', map_location='16 12.51 cM', chromosome='16', genomic_nucleotide_accession_version='NC_000082.6', start_position_on_the_genomic_accession=20731417, end_position_on_the_genomic_accession=20742384, orientation='plus', exon_count=24, OMIM='', no_hdr0=''),
  12669 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12669, CurrentID=0, Status='live', Symbol='Chrm1', Aliases='Chrm-1, M1, M1R', description='cholinergic receptor, muscarinic 1, CNS', other_designations='AChR M1|m1 muscarinic acetylcholine receptor protein', map_location='19 A', chromosome='19', genomic_nucleotide_accession_version='NC_000085.6', start_position_on_the_genomic_accession=8664005, end_position_on_the_genomic_accession=8683606, orientation='plus', exon_count=3, OMIM='', no_hdr0=''),
  12671 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12671, CurrentID=0, Status='live', Symbol='Chrm3', Aliases='Chrm-3, M3, M3R', description='cholinergic receptor, muscarinic 3, cardiac', other_designations='AChR M3|mm3 mAChR|muscarinic acetylcholine receptor 3', map_location='13 3.72 cM', chromosome='13', genomic_nucleotide_accession_version='NC_000079.6', start_position_on_the_genomic_accession=9875488, end_position_on_the_genomic_accession=10360803, orientation='minus', exon_count=5, OMIM='', no_hdr0=''),
  12672 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12672, CurrentID=0, Status='live', Symbol='Chrm4', Aliases='Chrm-4, M4', description='cholinergic receptor, muscarinic 4', other_designations='AChR M4|mm4 mAChR|muscarinic acetylcholine receptor 4', map_location='2 50.63 cM', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=91919619, end_position_on_the_genomic_accession=91929835, orientation='plus', exon_count=3, OMIM='', no_hdr0=''),
  12675 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12675, CurrentID=0, Status='live', Symbol='Chuk', Aliases='AI2566581, Fbx24, Fbxo24, IKBKA, IKK1, Ikka, NFKBIKA, Chuk', description='conserved helix-loop-helix ubiquitous kinase', other_designations='I kappa B kinase 1|I-kappa-B kinase 1|I-kappa-B kinase alpha|IKK alpha|IKK-A|IkappaB kinase alpha|nuclear factor NF-kappa-B inhibitor kinase alpha', map_location='19 36.71 cM', chromosome='19', genomic_nucleotide_accession_version='NC_000085.6', start_position_on_the_genomic_accession=44073334, end_position_on_the_genomic_accession=44107506, orientation='minus', exon_count=21, OMIM='', no_hdr0=''),
  12677 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12677, CurrentID=0, Status='live', Symbol='Vsx2', Aliases='Chx10, Hox-10, Hox10, or', description='visual system homeobox 2', other_designations='C. elegans ceh-10 homeo domain containing homolog|ceh-10 homeodomain-containing homolog|homeobox protein CHX10|ocular retardation', map_location='12 39.28 cM', chromosome='12', genomic_nucleotide_accession_version='NC_000078.6', start_position_on_the_genomic_accession=84569828, end_position_on_the_genomic_accession=84595457, orientation='plus', exon_count=5, OMIM='', no_hdr0=''),
  12683 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12683, CurrentID=0, Status='live', Symbol='Cidea', Aliases='AW212747', description='cell death-inducing DNA fragmentation factor, alpha subunit-like effector A', other_designations='cell death-inducing DFFA-like effector A', map_location='18 E1', chromosome='18', genomic_nucleotide_accession_version='NC_000084.6', start_position_on_the_genomic_accession=67343564, end_position_on_the_genomic_accession=67367794, orientation='plus', exon_count=5, OMIM='', no_hdr0=''),
  12684 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12684, CurrentID=0, Status='live', Symbol='Cideb', Aliases='1110030C18Rik, AI790179, CIDE-B', description='cell death-inducing DNA fragmentation factor, alpha subunit-like effector B', other_designations='DFFA-like B|cell death-inducing DFFA-like effector B', map_location='14 C1', chromosome='14', genomic_nucleotide_accession_version='NC_000080.6', start_position_on_the_genomic_accession=55754052, end_position_on_the_genomic_accession=55758424, orientation='minus', exon_count=5, OMIM='', no_hdr0=''),
  12686 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12686, CurrentID=0, Status='live', Symbol='Elovl3', Aliases='CIN-2, Cig30', description='elongation of very long chain fatty acids (FEN1/Elo2, SUR4/Elo3, yeast)-like 3', other_designations='3-keto acyl-CoA synthase Elovl3|ELOVL FA elongase 3|ELOVL fatty acid elongase 3|cold inducible glycoprotein 30|cold-inducible glycoprotein of 30 kDa|elongation of very long chain fatty acids-like 3|very long chain 3-ketoacyl-CoA synthase 3|very long chain 3-oxoacyl-CoA synthase 3|very-long-chain 3-oxoacyl-CoA synthase 3', map_location='19 38.75 cM', chromosome='19', genomic_nucleotide_accession_version='NC_000085.6', start_position_on_the_genomic_accession=46131899, end_position_on_the_genomic_accession=46135694, orientation='plus', exon_count=5, OMIM='', no_hdr0=''),
  111341 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=111341, CurrentID=0, Status='live', Symbol='Ph', Aliases='', description='patch deletion region', other_designations='', map_location='', chromosome='5', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  12695 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12695, CurrentID=0, Status='live', Symbol='Inadl', Aliases='Cipp, Patj', description='InaD-like (Drosophila)', other_designations='PALS1-associated tight junction protein|channel-interacting PDZ domain protein|channel-interacting PDZ domain-containing protein|inactivation no after-potential D-like protein|novel ankyrin-repeat protein|protein associated to tight junctions', map_location='4 C6', chromosome='4', genomic_nucleotide_accession_version='NC_000070.6', start_position_on_the_genomic_accession=98395534, end_position_on_the_genomic_accession=98719603, orientation='plus', exon_count=48, OMIM='', no_hdr0=''),
  12696 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12696, CurrentID=0, Status='live', Symbol='Cirbp', Aliases='Cirp, R74941', description='cold inducible RNA binding protein', other_designations='A18 hnRNP|cold inducible RNA-binding protein|glycine-rich RNA-binding protein CIRP', map_location='10 39.72 cM', chromosome='10', genomic_nucleotide_accession_version='NC_000076.6', start_position_on_the_genomic_accession=80165990, end_position_on_the_genomic_accession=80172691, orientation='plus', exon_count=10, OMIM='', no_hdr0=''),
  12700 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12700, CurrentID=0, Status='live', Symbol='Cish', Aliases='CIS-1, CIS1, Cis, F17, F23, SOCS', description='cytokine inducible SH2-containing protein', other_designations='cytokine-inducible SH2 protein|suppressor of cytokine signaling', map_location='9 57.99 cM', chromosome='9', genomic_nucleotide_accession_version='NC_000075.6', start_position_on_the_genomic_accession=107296685, end_position_on_the_genomic_accession=107301962, orientation='plus', exon_count=4, OMIM='', no_hdr0=''),
  12702 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12702, CurrentID=0, Status='live', Symbol='Socs3', Aliases='Cis3, Cish3, EF-10, Ef10, SSI-3, Ssi3', description='suppressor of cytokine signaling 3', other_designations='CIS-3|E2a-Pbx1 target gene in fibroblasts 10|STAT-induced STAT inhibitor 3|cytokine inducible SH2-containing protein 3', map_location='11 E2', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=117966079, end_position_on_the_genomic_accession=117970341, orientation='minus', exon_count=4, OMIM='', no_hdr0=''),
  12703 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12703, CurrentID=0, Status='live', Symbol='Socs1', Aliases='Cish1, Cish7, JAB, SOCS-1, SSI-1', description='suppressor of cytokine signaling 1', other_designations='JAK2-binding protein|STAT-induced STAT inhibitor 1|cytokine inducible SH2-containing protein 1|cytokine inducible SH2-containing protein 7', map_location='16 5.81 cM', chromosome='16', genomic_nucleotide_accession_version='NC_000082.6', start_position_on_the_genomic_accession=10783808, end_position_on_the_genomic_accession=10785536, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  12704 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12704, CurrentID=0, Status='live', Symbol='Cit', Aliases='C030025P15Rik, CRIK, CRIK-SK-k, Cit', description='citron', other_designations='citron kinase|citron-N|rho-interacting, serine/threonine-protein kinase 21', map_location='5 F', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=115845224, end_position_on_the_genomic_accession=116008586, orientation='plus', exon_count=54, OMIM='', no_hdr0=''),
  12705 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12705, CurrentID=0, Status='live', Symbol='Cited1', Aliases='AI316840, AU019144, Msg1', description='Cbp/p300-interacting transactivator with Glu/Asp-rich carboxy-terminal domain 1', other_designations='melanocyte-specific protein 1', map_location='X 45.25 cM', chromosome='X', genomic_nucleotide_accession_version='NC_000086.7', start_position_on_the_genomic_accession=102247378, end_position_on_the_genomic_accession=102252181, orientation='minus', exon_count=5, OMIM='', no_hdr0=''),
  12709 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12709, CurrentID=0, Status='live', Symbol='Ckb', Aliases='B-CK, Bck, Ck-3, Ck3b, Ckb', description='creatine kinase, brain', other_designations='creatine kinase B chain', map_location='12 61.09 cM', chromosome='12', genomic_nucleotide_accession_version='NC_000078.6', start_position_on_the_genomic_accession=111669355, end_position_on_the_genomic_accession=111672338, orientation='minus', exon_count=8, OMIM='', no_hdr0=''),
  12715 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12715, CurrentID=0, Status='live', Symbol='Ckm', Aliases='Ckmm, M-CK, MCK', description='creatine kinase, muscle', other_designations='creatine kinase M chain', map_location='7 9.67 cM', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=19411094, end_position_on_the_genomic_accession=19421583, orientation='plus', exon_count=8, OMIM='', no_hdr0=''),
  12716 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12716, CurrentID=0, Status='live', Symbol='Ckmt1', Aliases='Mt-CK, ScCKmit, UbCKmit, mi-CK', description='creatine kinase, mitochondrial 1, ubiquitous', other_designations='U-MtCK|acidic-type mitochondrial creatine kinase|mia-CK|ubiquitous mitochondrial creatine kinase', map_location='2 F1-F3', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=121357751, end_position_on_the_genomic_accession=121363737, orientation='plus', exon_count=11, OMIM='', no_hdr0=''),
  12717 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12717, CurrentID=0, Status='live', Symbol='ckr', Aliases='', description='chakragati', other_designations='', map_location='', chromosome='16', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  12721 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12721, CurrentID=0, Status='live', Symbol='Coro1a', Aliases='Clabp, Lmb3, TACO, p57', description='coronin, actin binding protein 1A', other_designations='clipin-A|coronin 1|coronin-like actin binding protein|coronin-like protein A|coronin-like protein p57|tryptophan aspartate-containing coat protein', map_location='7 F3', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=126699774, end_position_on_the_genomic_accession=126704816, orientation='minus', exon_count=13, OMIM='', no_hdr0=''),
  12722 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12722, CurrentID=0, Status='live', Symbol='Clca3a1', Aliases='Cacc, Clca1', description='chloride channel accessory 3A1', other_designations='chloride channel calcium activated 1', map_location='3 H2-H3', chromosome='3', genomic_nucleotide_accession_version='NC_000069.6', start_position_on_the_genomic_accession=144729697, end_position_on_the_genomic_accession=144760972, orientation='minus', exon_count=17, OMIM='', no_hdr0=''),
  12723 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12723, CurrentID=0, Status='live', Symbol='Clcn1', Aliases='Clc-1, Clc1, SMCC1, adr, mto, myotonia, nmf355', description='chloride channel, voltage-sensitive 1', other_designations='arrested development of righting response|chloride channel 1|chloride channel protein, skeletal muscle', map_location='6 20.57 cM', chromosome='6', genomic_nucleotide_accession_version='NC_000072.6', start_position_on_the_genomic_accession=42282593, end_position_on_the_genomic_accession=42315759, orientation='plus', exon_count=25, OMIM='', no_hdr0=''),
  12724 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12724, CurrentID=0, Status='live', Symbol='Clcn2', Aliases='AL118368, ClC-2, Clc2, nmf240', description='chloride channel, voltage-sensitive 2', other_designations='chloride channel 2', map_location='16 12.5 cM', chromosome='16', genomic_nucleotide_accession_version='NC_000082.6', start_position_on_the_genomic_accession=20702966, end_position_on_the_genomic_accession=20717741, orientation='minus', exon_count=25, OMIM='', no_hdr0=''),
  12725 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12725, CurrentID=0, Status='live', Symbol='Clcn3', Aliases='Clc3', description='chloride channel, voltage-sensitive 3', other_designations='chloride channel 3|chloride channel protein 3|chloride transporter ClC-3|clC-3', map_location='8 30.9 cM', chromosome='8', genomic_nucleotide_accession_version='NC_000074.6', start_position_on_the_genomic_accession=60910389, end_position_on_the_genomic_accession=60983311, orientation='minus', exon_count=17, OMIM='', no_hdr0=''),
  12727 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12727, CurrentID=0, Status='live', Symbol='Clcn4', Aliases='Clc4-2-2, Clcn4', description='chloride channel, voltage-sensitive 4', other_designations='chloride channel 4-2|chloride channel protein 4|chloride transporter ClC-4|clC-4|voltage-gated chloride channel ClC-4A', map_location='7 4.23 cM', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=7282309, end_position_on_the_genomic_accession=7300851, orientation='minus', exon_count=15, OMIM='', no_hdr0=''),
  12728 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12728, CurrentID=0, Status='live', Symbol='Clcn5', Aliases='5430408K11Rik, ClC-5, Clc5, D930009B12Rik, DXImx42e, Sfc13, T25545', description='chloride channel 5', other_designations='chloride channel protein 5|chloride transporter ClC-5', map_location='X 3.21 cM', chromosome='X', genomic_nucleotide_accession_version='NC_000086.7', start_position_on_the_genomic_accession=7153810, end_position_on_the_genomic_accession=7319359, orientation='minus', exon_count=19, OMIM='', no_hdr0=''),
  12729 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12729, CurrentID=0, Status='live', Symbol='Clns1a', Aliases='2610036D06Rik, 2610100O04Rik, Clci, Clcni, ICLN', description='chloride channel, nucleotide-sensitive, 1A', other_designations='chloride channel current inducer|chloride channel regulator|chloride channel, nucleotide sensitive 1A|chloride conductance regulatory protein ICln|chloride ion current inducer protein|i(Cln)', map_location='7 E3', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=97696657, end_position_on_the_genomic_accession=97720793, orientation='plus', exon_count=7, OMIM='', no_hdr0=''),
  12733 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12733, CurrentID=0, Status='live', Symbol='Clcnka', Aliases='C75963, CLC-K1, Clcnk1', description='chloride channel, voltage-sensitive Ka', other_designations='chloride channel K1|chloride channel Ka|putative basolateral cTAL chloride channel ClC-Ka', map_location='4 E1', chromosome='4', genomic_nucleotide_accession_version='NC_000070.6', start_position_on_the_genomic_accession=141384611, end_position_on_the_genomic_accession=141398706, orientation='minus', exon_count=20, OMIM='', no_hdr0=''),
  12737 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12737, CurrentID=0, Status='live', Symbol='Cldn1', Aliases='AI596271', description='claudin 1', other_designations='', map_location='16 B2', chromosome='16', genomic_nucleotide_accession_version='NC_000082.6', start_position_on_the_genomic_accession=26356645, end_position_on_the_genomic_accession=26371839, orientation='minus', exon_count=4, OMIM='', no_hdr0=''),
  12738 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12738, CurrentID=0, Status='live', Symbol='Cldn2', Aliases='AL022813', description='claudin 2', other_designations='', map_location='X F1', chromosome='X', genomic_nucleotide_accession_version='NC_000086.7', start_position_on_the_genomic_accession=139800808, end_position_on_the_genomic_accession=139811386, orientation='plus', exon_count=6, OMIM='', no_hdr0=''),
  12739 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12739, CurrentID=0, Status='live', Symbol='Cldn3', Aliases='AI182374, Cpetr2, mRVP1', description='claudin 3', other_designations='CPE-R 2|CPE-receptor 2|clostridium perfringens enterotoxin receptor 2', map_location='5 74.93 cM', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=134986214, end_position_on_the_genomic_accession=134987476, orientation='plus', exon_count=1, OMIM='', no_hdr0=''),
  12740 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12740, CurrentID=0, Status='live', Symbol='Cldn4', Aliases='Cep-r, Cpetr, Cpetr1', description='claudin 4', other_designations='CPE-R|CPE-receptor|clostridium perfringens enterotoxin receptor', map_location='5 74.9 cM', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=134945123, end_position_on_the_genomic_accession=134946934, orientation='minus', exon_count=1, OMIM='', no_hdr0=''),
  668101 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=668101, CurrentID=0, Status='live', Symbol='Sirpb1b', Aliases='', description='signal-regulatory protein beta 1B', other_designations='', map_location='3', chromosome='3', genomic_nucleotide_accession_version='NC_000069.6', start_position_on_the_genomic_accession=15495754, end_position_on_the_genomic_accession=15575065, orientation='minus', exon_count=8, OMIM='', no_hdr0=''),
  12744 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12744, CurrentID=0, Status='live', Symbol='clf2', Aliases='', description='cleft lip 2', other_designations='', map_location='', chromosome='13', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  12745 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12745, CurrentID=0, Status='live', Symbol='Clgn', Aliases='4930459O04Rik, AI528775, Cln', description='calmegin', other_designations='A2/6|MEG 1 antigen|calnexin-T', map_location='8 39.97 cM', chromosome='8', genomic_nucleotide_accession_version='NC_000074.6', start_position_on_the_genomic_accession=83389826, end_position_on_the_genomic_accession=83428552, orientation='plus', exon_count=17, OMIM='', no_hdr0=''),
  12747 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12747, CurrentID=0, Status='live', Symbol='Clk1', Aliases='STY', description='CDC-like kinase 1', other_designations='protein kinase STY', map_location='1 29.09 cM', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=58411988, end_position_on_the_genomic_accession=58424088, orientation='minus', exon_count=13, OMIM='', no_hdr0=''),
  12748 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12748, CurrentID=0, Status='live', Symbol='Clk2', Aliases='AU041688', description='CDC-like kinase 2', other_designations='', map_location='3 F1', chromosome='3', genomic_nucleotide_accession_version='NC_000069.6', start_position_on_the_genomic_accession=89164805, end_position_on_the_genomic_accession=89177087, orientation='plus', exon_count=13, OMIM='', no_hdr0=''),
  668110 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=668110, CurrentID=0, Status='live', Symbol='Syce1l', Aliases='4930481F22Rik, MMRP, PSESS, mmrp2', description='synaptonemal complex central element protein 1 like', other_designations='meiosis-related protein|predicted second spermatocyte specific protein', map_location='8 E1', chromosome='8', genomic_nucleotide_accession_version='NC_000074.6', start_position_on_the_genomic_accession=113643213, end_position_on_the_genomic_accession=113655533, orientation='plus', exon_count=12, OMIM='', no_hdr0=''),
  12751 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12751, CurrentID=0, Status='live', Symbol='Tpp1', Aliases='Cln2, LPIC, TPP-1, TPP-I', description='tripeptidyl peptidase I', other_designations='ceroid-lipofuscinosis, neuronal 2|lysosomal pepstatin-insensitive protease|tripeptidyl aminopeptidase|tripeptidyl-peptidase I', map_location='7 55.97 cM', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=105744847, end_position_on_the_genomic_accession=105752282, orientation='minus', exon_count=14, OMIM='', no_hdr0=''),
  12752 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12752, CurrentID=0, Status='live', Symbol='Cln3', Aliases='AI323623', description='ceroid lipofuscinosis, neuronal 3, juvenile (Batten, Spielmeyer-Vogt disease)', other_designations='', map_location='7 69.16 cM', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=126571400, end_position_on_the_genomic_accession=126585817, orientation='minus', exon_count=20, OMIM='', no_hdr0=''),
  12753 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12753, CurrentID=0, Status='live', Symbol='Clock', Aliases='5330400M04Rik, KAT13D', description='circadian locomotor output cycles kaput', other_designations='', map_location='5 40.63 cM', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=76209868, end_position_on_the_genomic_accession=76305007, orientation='minus', exon_count=23, OMIM='', no_hdr0=''),
  12757 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12757, CurrentID=0, Status='live', Symbol='Clta', Aliases='AV026556, Lca', description='clathrin, light polypeptide (Lca)', other_designations='clathryn light chain (LCA2)', map_location='4 B1', chromosome='4', genomic_nucleotide_accession_version='NC_000070.6', start_position_on_the_genomic_accession=44003816, end_position_on_the_genomic_accession=44032848, orientation='plus', exon_count=9, OMIM='', no_hdr0=''),
  12759 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12759, CurrentID=0, Status='live', Symbol='Clu', Aliases='AI893575, ApoJ, Cli, D14Ucla3, SP-40, Sgp-2, Sgp2, Sugp-2', description='clusterin', other_designations='Apolipoprotein J|clustrin|complement lysis inhibitor|sulfated glycoprotein 2|testosterone repressed prostate message|testosterone repressed prostate message-2', map_location='14 34.36 cM', chromosome='14', genomic_nucleotide_accession_version='NC_000080.6', start_position_on_the_genomic_accession=65968483, end_position_on_the_genomic_accession=65981547, orientation='plus', exon_count=11, OMIM='', no_hdr0=''),
  12763 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12763, CurrentID=0, Status='live', Symbol='Cmah', Aliases='', description='cytidine monophospho-N-acetylneuraminic acid hydroxylase', other_designations='CMP-N-acetylneuraminate monooxygenase|CMP-N-acetylneuraminic acid hydroxylase|CMP-Neu5Ac hydroxylase|CMP-NeuAc hydroxylase', map_location='13 A3.2', chromosome='13', genomic_nucleotide_accession_version='NC_000079.6', start_position_on_the_genomic_accession=24326980, end_position_on_the_genomic_accession=24477289, orientation='plus', exon_count=23, OMIM='', no_hdr0=''),
  12764 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12764, CurrentID=0, Status='live', Symbol='Cmas', Aliases='AW208911, CMPNeu5Ac, D6Bwg0250e', description='cytidine monophospho-N-acetylneuraminic acid synthetase', other_designations='CMP-N-acetylneuraminic acid synthase|CMP-N-acetylneuraminic acid synthetase|CMP-Neu5Ac synthase|CMP-NeuNAc synthase|CMP-NeuNAc synthetase|CMP-sialic acid synthetase', map_location='6 74.66 cM', chromosome='6', genomic_nucleotide_accession_version='NC_000072.6', start_position_on_the_genomic_accession=142756686, end_position_on_the_genomic_accession=142775714, orientation='plus', exon_count=8, OMIM='', no_hdr0=''),
  12765 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12765, CurrentID=0, Status='live', Symbol='Cxcr2', Aliases='CD128, CDw128, Cmkar2, Gpcr16, IL-8Rh, IL-8rb, IL8RA, Il8rb, mIL-8RH', description='chemokine (C-X-C motif) receptor 2', other_designations='CXC-R2|CXCR-2|GRO/MGSA receptor|IL-8 receptor alpha chain|IL-8R B|chemokine (C-X-C) receptor 2|high affinity interleukin-8 receptor B|interleukin 8 receptor, beta|interleukin-8 receptor type B', map_location='1 38.41 cM', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=74153994, end_position_on_the_genomic_accession=74161246, orientation='plus', exon_count=3, OMIM='', no_hdr0=''),
  12766 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12766, CurrentID=0, Status='live', Symbol='Cxcr3', Aliases='Cd183, Cmkar3', description='chemokine (C-X-C motif) receptor 3', other_designations='IP-10 receptor|interferon-inducible protein 10 receptor', map_location='X 44.58 cM', chromosome='X', genomic_nucleotide_accession_version='NC_000086.7', start_position_on_the_genomic_accession=101731536, end_position_on_the_genomic_accession=101734147, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  12767 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12767, CurrentID=0, Status='live', Symbol='Cxcr4', Aliases='CD184, Cmkar4, LESTR, PB-CKR, PBSF/SDF-1, Sdf1r, b2b220Clo', description='chemokine (C-X-C motif) receptor 4', other_designations='CXC-R4|CXCR-4|SDF-1 receptor|chemokine (C-X-C) receptor 4|chemokine receptor 4|fusin|leukocyte-derived seven transmembrane domain receptor|leukocyte-expressed seven-transmembrane-domain|pre-B-cell-derived chemokine receptor|stromal cell-derived factor 1 receptor', map_location='1 56.43 cM', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=128588199, end_position_on_the_genomic_accession=128592315, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  12768 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12768, CurrentID=0, Status='live', Symbol='Ccr1', Aliases='Cmkbr1, Mip-1a-R', description='chemokine (C-C motif) receptor 1', other_designations='C-C CKR-1|CC-CKR-1|CCR-1|MIP-1 alpha R|MIP-1 alphaR|MIP-1alpha-R|RANTES-R|chemokine (C-C) receptor 1|macrophage inflammatory protein 1-alpha receptor', map_location='9 F', chromosome='9', genomic_nucleotide_accession_version='NC_000075.6', start_position_on_the_genomic_accession=123962126, end_position_on_the_genomic_accession=123968692, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  12769 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12769, CurrentID=0, Status='live', Symbol='Ccr9', Aliases='A130091K22Rik, Cmkbr10, GPR-9-6', description='chemokine (C-C motif) receptor 9', other_designations='C-C CKR-9|CC-CKR-9|CCR-9|chemokine C-C receptor 10', map_location='9 F', chromosome='9', genomic_nucleotide_accession_version='NC_000075.6', start_position_on_the_genomic_accession=123767211, end_position_on_the_genomic_accession=123783457, orientation='plus', exon_count=4, OMIM='', no_hdr0=''),
  12770 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12770, CurrentID=0, Status='live', Symbol='Ccr1l1', Aliases='Cmkbr1l1', description='chemokine (C-C motif) receptor 1-like 1', other_designations='MIP-1 alphaRL1|chemokine (C-C) receptor 1-like 1|macrophage inflammatory protein 1 alpha receptor-like 1|macrophage inflammatory protein-1 alpha receptor-like 1', map_location='9 75.05 cM', chromosome='9', genomic_nucleotide_accession_version='NC_000075.6', start_position_on_the_genomic_accession=123976949, end_position_on_the_genomic_accession=123978408, orientation='minus', exon_count=1, OMIM='', no_hdr0=''),
  12771 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12771, CurrentID=0, Status='live', Symbol='Ccr3', Aliases='CC-CKR3, CKR3, Cmkbr1l2, Cmkbr3', description='chemokine (C-C motif) receptor 3', other_designations='C-C CKR-3|CC chemokine receptor 3|CC-CKR-3|CCR-3|MIP-1 alpha RL2|MIP-1 alphaRL2|chemokine (C-C) receptor 1,-like 2|chemokine (C-C) receptor 3|macrophage inflammatory protein 1-alpha receptor-like 2', map_location='9 F', chromosome='9', genomic_nucleotide_accession_version='NC_000075.6', start_position_on_the_genomic_accession=124013629, end_position_on_the_genomic_accession=124031689, orientation='plus', exon_count=4, OMIM='', no_hdr0=''),
  12772 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12772, CurrentID=0, Status='live', Symbol='Ccr2', Aliases='Cc-ckr-2a, Ccr2b, Ckr2, Ckr2a, Ckr2b, Cmkbr2, mJe-r, Ccr2', description='chemokine (C-C motif) receptor 2', other_designations='C-C CHEMOKINE RECEPTOR TYPE 2 (C-C CKR-2) (CC-CKR-2) (CCR-2) (CCR2) (JE/FIC RECEPTOR) (MCP-1 RECEPTOR)|C-C CKR-2|CCR-2|JE/FIC receptor|MCP-1 receptor|MIP-1 alphaR|chemoattractant protein-1 receptor|chemokine (C-C) receptor 2', map_location='9 F', chromosome='9', genomic_nucleotide_accession_version='NC_000075.6', start_position_on_the_genomic_accession=124101918, end_position_on_the_genomic_accession=124109140, orientation='plus', exon_count=5, OMIM='', no_hdr0=''),
  12773 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12773, CurrentID=0, Status='live', Symbol='Ccr4', Aliases='C-C CKR-4, CHEMR1, Cmkbr4, LESTR, Sdf1r', description='chemokine (C-C motif) receptor 4', other_designations='chemokine (C-C) receptor 4|fusin|leukocyte-expressed seven-transmembrane-domain receptor', map_location='9 64.49 cM', chromosome='9', genomic_nucleotide_accession_version='NC_000075.6', start_position_on_the_genomic_accession=114490316, end_position_on_the_genomic_accession=114505473, orientation='minus', exon_count=6, OMIM='', no_hdr0=''),
  12774 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12774, CurrentID=0, Status='live', Symbol='Ccr5', Aliases='AM4-7, CD195, Cmkbr5', description='chemokine (C-C motif) receptor 5', other_designations='C-C CKR-5|CC-CKR-5|CCR-5|MIP-1 alpha receptor|chemokine (C-C) receptor 5', map_location='9 75.05 cM', chromosome='9', genomic_nucleotide_accession_version='NC_000075.6', start_position_on_the_genomic_accession=124121543, end_position_on_the_genomic_accession=124127183, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  12775 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12775, CurrentID=0, Status='live', Symbol='Ccr7', Aliases='CC-CKR-7, CCR-7, CD197, Cdw197, Cmkbr7, EBI1, Ebi1h', description='chemokine (C-C motif) receptor 7', other_designations='EBV-induced G-protein coupled receptor 1|MIP-3 beta receptor|chemokine (C-C) receptor 7|epstein-Barr virus-induced G-protein coupled receptor 1', map_location='11 D', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=99144199, end_position_on_the_genomic_accession=99155077, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  12776 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12776, CurrentID=0, Status='live', Symbol='Ccr8', Aliases='C-C, C-C CKR-8, CC-CKR-8, CCR-8, CKR-8, Cmkbr8, mCCR8', description='chemokine (C-C motif) receptor 8', other_designations='C-C motif chemokine receptor 8', map_location='9 F4', chromosome='9', genomic_nucleotide_accession_version='NC_000075.6', start_position_on_the_genomic_accession=120092133, end_position_on_the_genomic_accession=120094906, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  12777 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12777, CurrentID=0, Status='live', Symbol='Ccr10', Aliases='Cmkbr9, Gpr2', description='chemokine (C-C motif) receptor 10', other_designations='C-C CKR-10|CC-CKR-10|CCR-10|G protein-coupled receptor 2|G-protein coupled receptor 2|chemokine C-C receptor 9', map_location='11 64.34 cM', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=101172922, end_position_on_the_genomic_accession=101175695, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  12778 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12778, CurrentID=0, Status='live', Symbol='Ackr3', Aliases='AW541270, CXC-R7, CXCR-7, Cmkor1, Cxcr7, RDC-1, Rdc1', description='atypical chemokine receptor 3', other_designations='C-X-C chemokine receptor type 7|G-protein coupled receptor RDC1 homolog|chemokine (C-X-C motif) receptor 7|chemokine orphan receptor 1', map_location='1 45.28 cM', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=90203980, end_position_on_the_genomic_accession=90215724, orientation='plus', exon_count=3, OMIM='', no_hdr0=''),
  12780 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12780, CurrentID=0, Status='live', Symbol='Abcc2', Aliases='AI173996, Abc30, Cmoat, Mrp2, cMRP', description='ATP-binding cassette, sub-family C (CFTR/MRP), member 2', other_designations='ATP-binding cassette sub-family C member 2|multidrug resistance protein 2', map_location='19 36.67 cM', chromosome='19', genomic_nucleotide_accession_version='NC_000085.6', start_position_on_the_genomic_accession=43782308, end_position_on_the_genomic_accession=43838332, orientation='plus', exon_count=33, OMIM='', no_hdr0=''),
  12785 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12785, CurrentID=0, Status='live', Symbol='Cnbp', Aliases='AA4087101, Znf9, Cnbp', description='cellular nucleic acid binding protein', other_designations='cellular nucleic acid binding protein 1|zinc finger protein 9', map_location='6 D1-D2', chromosome='6', genomic_nucleotide_accession_version='NC_000072.6', start_position_on_the_genomic_accession=87842615, end_position_on_the_genomic_accession=87851106, orientation='minus', exon_count=5, OMIM='', no_hdr0=''),
  12788 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12788, CurrentID=0, Status='live', Symbol='Cnga1', Aliases='Cncg', description='cyclic nucleotide gated channel alpha 1', other_designations='CNG channel alpha-1|CNG-1|CNG1|cyclic nucleotide gated channel, cGMP gated|cyclic nucleotide-gated cation channel 1|cyclic nucleotide-gated channel alpha-1|cyclic nucleotide-gated channel, photoreceptor|rod photoreceptor cGMP-gated channel subunit alpha', map_location='5 38.44 cM', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=72603696, end_position_on_the_genomic_accession=72642752, orientation='minus', exon_count=10, OMIM='', no_hdr0=''),
  12789 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12789, CurrentID=0, Status='live', Symbol='Cnga2', Aliases='CNG2, Cnca, Cncg4, OCNC1', description='cyclic nucleotide gated channel alpha 2', other_designations='CNG channel alpha-2|cyclic nucleotide gated channel 4|cyclic nucleotide-gated cation channel 2', map_location='X A6', chromosome='X', genomic_nucleotide_accession_version='NC_000086.7', start_position_on_the_genomic_accession=71991875, end_position_on_the_genomic_accession=72010218, orientation='plus', exon_count=9, OMIM='', no_hdr0=''),
  12790 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12790, CurrentID=0, Status='live', Symbol='Cnga3', Aliases='CNG3', description='cyclic nucleotide gated channel alpha 3', other_designations='CNG channel alpha-3|CNG-3|cone photoreceptor cGMP-gated channel subunit alpha|cyclic nucleotide-gated channel alpha-3', map_location='1 B', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=37218278, end_position_on_the_genomic_accession=37263384, orientation='plus', exon_count=8, OMIM='', no_hdr0=''),
  12793 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12793, CurrentID=0, Status='live', Symbol='Cnih1', Aliases='0610007J15, CNIH-1, Cnih', description='cornichon family AMPA receptor auxiliary protein 1', other_designations='cornichon homolog 1', map_location='14 C1', chromosome='14', genomic_nucleotide_accession_version='NC_000080.6', start_position_on_the_genomic_accession=46775567, end_position_on_the_genomic_accession=46788888, orientation='minus', exon_count=7, OMIM='', no_hdr0=''),
  12794 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12794, CurrentID=0, Status='live', Symbol='Cnih2', Aliases='CNIH-2, Cnil', description='cornichon family AMPA receptor auxiliary protein 2', other_designations='cornichon homolog 2|cornichon-like protein', map_location='19 A', chromosome='19', genomic_nucleotide_accession_version='NC_000085.6', start_position_on_the_genomic_accession=5092868, end_position_on_the_genomic_accession=5098521, orientation='minus', exon_count=6, OMIM='', no_hdr0=''),
  12795 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12795, CurrentID=0, Status='live', Symbol='Plk3', Aliases='Cnk, Fnk, PLK-3, PRK', description='polo-like kinase 3', other_designations='FGF-inducible kinase|cytokine-inducible serine/threonine-protein kinase', map_location='4 D1', chromosome='4', genomic_nucleotide_accession_version='NC_000070.6', start_position_on_the_genomic_accession=117128655, end_position_on_the_genomic_accession=117133952, orientation='minus', exon_count=15, OMIM='', no_hdr0=''),
  12796 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12796, CurrentID=0, Status='live', Symbol='Camp', Aliases='CAP18, Cnlp, Cramp, FALL39, MCLP', description='cathelicidin antimicrobial peptide', other_designations='CLP|cathelin-like protein|cathelin-related antimicrobial peptide', map_location='9 59.8 cM', chromosome='9', genomic_nucleotide_accession_version='NC_000075.6', start_position_on_the_genomic_accession=109847377, end_position_on_the_genomic_accession=109849456, orientation='minus', exon_count=4, OMIM='', no_hdr0=''),
  12797 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12797, CurrentID=0, Status='live', Symbol='Cnn1', Aliases='CN, CnnI', description='calponin 1', other_designations='basic calponin|calponin H1, smooth muscle', map_location='9 A2-A4', chromosome='9', genomic_nucleotide_accession_version='NC_000075.6', start_position_on_the_genomic_accession=22099221, end_position_on_the_genomic_accession=22109221, orientation='plus', exon_count=9, OMIM='', no_hdr0=''),
  12798 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12798, CurrentID=0, Status='live', Symbol='Cnn2', Aliases='AA408047, AI324678, Calpo2', description='calponin 2', other_designations='calponin H2, smooth muscle|h2-calponin|neutral calponin', map_location='10 C1', chromosome='10', genomic_nucleotide_accession_version='NC_000076.6', start_position_on_the_genomic_accession=79988600, end_position_on_the_genomic_accession=79995400, orientation='plus', exon_count=7, OMIM='', no_hdr0=''),
  12799 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12799, CurrentID=0, Status='live', Symbol='Cnp', Aliases='CNPase-1, Cnp1, Cnp', description="2',3'-cyclic nucleotide 3' phosphodiesterase", other_designations='cyclic nucleotide phosphodiesterase 1', map_location='11 63.47 cM', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=100574909, end_position_on_the_genomic_accession=100591521, orientation='plus', exon_count=5, OMIM='', no_hdr0=''),
  12801 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12801, CurrentID=0, Status='live', Symbol='Cnr1', Aliases='CB-R, CB1, CB1R', description='cannabinoid receptor 1 (brain)', other_designations='brain-type cannabinoid receptor|striatal cannabinoid receptor type 1 protein', map_location='4 16.28 cM', chromosome='4', genomic_nucleotide_accession_version='NC_000070.6', start_position_on_the_genomic_accession=33923844, end_position_on_the_genomic_accession=33948831, orientation='plus', exon_count=9, OMIM='', no_hdr0=''),
  12802 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12802, CurrentID=0, Status='live', Symbol='Cnr2', Aliases='CB-2, CB2, CB2-R', description='cannabinoid receptor 2 (macrophage)', other_designations='cannabinoid receptor 2 (spleen)', map_location='4 D3', chromosome='4', genomic_nucleotide_accession_version='NC_000070.6', start_position_on_the_genomic_accession=135895404, end_position_on_the_genomic_accession=135920215, orientation='plus', exon_count=3, OMIM='', no_hdr0=''),
  12803 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12803, CurrentID=0, Status='live', Symbol='Cntf', Aliases='AI429687', description='ciliary neurotrophic factor', other_designations='', map_location='19 8.73 cM', chromosome='19', genomic_nucleotide_accession_version='NC_000085.6', start_position_on_the_genomic_accession=12763528, end_position_on_the_genomic_accession=12765632, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  12804 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12804, CurrentID=0, Status='live', Symbol='Cntfr', Aliases='Cntfralpha', description='ciliary neurotrophic factor receptor', other_designations='CNTF receptor subunit alpha', map_location='4 21.81 cM', chromosome='4', genomic_nucleotide_accession_version='NC_000070.6', start_position_on_the_genomic_accession=41657498, end_position_on_the_genomic_accession=41697091, orientation='minus', exon_count=16, OMIM='', no_hdr0=''),
  12805 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12805, CurrentID=0, Status='live', Symbol='Cntn1', Aliases='AW495098, CNTN, F3cam, usl', description='contactin 1', other_designations='neural cell surface protein F3', map_location='15 F', chromosome='15', genomic_nucleotide_accession_version='NC_000081.6', start_position_on_the_genomic_accession=92051142, end_position_on_the_genomic_accession=92341967, orientation='plus', exon_count=27, OMIM='', no_hdr0=''),
  668166 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=668166, CurrentID=0, Status='live', Symbol='Zxdb', Aliases='Zxda', description='zinc finger, X-linked, duplicated B', other_designations='zinc finger X-linked protein ZXDA/ZXDB', map_location='X C3', chromosome='X', genomic_nucleotide_accession_version='NC_000086.7', start_position_on_the_genomic_accession=94724569, end_position_on_the_genomic_accession=94730191, orientation='plus', exon_count=1, OMIM='', no_hdr0=''),
  12807 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12807, CurrentID=0, Status='live', Symbol='Hps3', Aliases='coa', description='Hermansky-Pudlak syndrome 3', other_designations='Hermansky-Pudlak syndrome 3 homolog|cocoa protein', map_location='3 6.12 cM', chromosome='3', genomic_nucleotide_accession_version='NC_000069.6', start_position_on_the_genomic_accession=19995945, end_position_on_the_genomic_accession=20035376, orientation='minus', exon_count=17, OMIM='', no_hdr0=''),
  12808 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12808, CurrentID=0, Status='live', Symbol='Cobl', Aliases='', description='cordon-bleu WH2 repeat', other_designations='', map_location='11 7.3 cM', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=12236676, end_position_on_the_genomic_accession=12464997, orientation='minus', exon_count=18, OMIM='', no_hdr0=''),
  12810 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12810, CurrentID=0, Status='live', Symbol='Coch', Aliases='AW122937-5B2, D12H14S564E, Coch', description='cochlin', other_designations='coagulation factor C homolog (Limulus polyphemus)', map_location='12 22.11 cM', chromosome='12', genomic_nucleotide_accession_version='NC_000078.6', start_position_on_the_genomic_accession=51593341, end_position_on_the_genomic_accession=51605773, orientation='plus', exon_count=12, OMIM='', no_hdr0=''),
  12812 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12812, CurrentID=0, Status='live', Symbol='Coil', Aliases='C79982, Cln80, p80, p80-coilin', description='coilin', other_designations='nuclear phosphoprotein of Cajal body', map_location='11 D', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=88973935, end_position_on_the_genomic_accession=88991613, orientation='plus', exon_count=7, OMIM='', no_hdr0=''),
  668173 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=668173, CurrentID=0, Status='live', Symbol='Pex10', Aliases='AV128229, Gm142', description='peroxisomal biogenesis factor 10', other_designations='peroxin-10|peroxisome assembly protein 10', map_location='4 E2', chromosome='4', genomic_nucleotide_accession_version='NC_000070.6', start_position_on_the_genomic_accession=155067030, end_position_on_the_genomic_accession=155072406, orientation='plus', exon_count=6, OMIM='', no_hdr0=''),
  12814 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12814, CurrentID=0, Status='live', Symbol='Col11a1', Aliases='C530001D20Rik, cho', description='collagen, type XI, alpha 1', other_designations='a1(XI) collagen|pro-alpha1(XI) collagen|procollagen, type XI, alpha 1', map_location='3 49.35 cM', chromosome='3', genomic_nucleotide_accession_version='NC_000069.6', start_position_on_the_genomic_accession=114030479, end_position_on_the_genomic_accession=114220327, orientation='plus', exon_count=69, OMIM='', no_hdr0=''),
  12815 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12815, CurrentID=0, Status='live', Symbol='Col11a2', Aliases='', description='collagen, type XI, alpha 2', other_designations='procollagen, type XI, alpha 2', map_location='17 17.98 cM', chromosome='17', genomic_nucleotide_accession_version='NC_000083.6', start_position_on_the_genomic_accession=34038486, end_position_on_the_genomic_accession=34066684, orientation='plus', exon_count=68, OMIM='', no_hdr0=''),
  12816 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12816, CurrentID=0, Status='live', Symbol='Col12a1', Aliases='', description='collagen, type XII, alpha 1', other_designations='procollagen, type XII, alpha 1', map_location='9 43.82 cM', chromosome='9', genomic_nucleotide_accession_version='NC_000075.6', start_position_on_the_genomic_accession=79598987, end_position_on_the_genomic_accession=79720841, orientation='minus', exon_count=66, OMIM='', no_hdr0=''),
  12817 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12817, CurrentID=0, Status='live', Symbol='Col13a1', Aliases='', description='collagen, type XIII, alpha 1', other_designations='procollagen, type XIII, alpha 1|type XIII collagen', map_location='10 B4', chromosome='10', genomic_nucleotide_accession_version='NC_000076.6', start_position_on_the_genomic_accession=61838235, end_position_on_the_genomic_accession=61979209, orientation='minus', exon_count=45, OMIM='', no_hdr0=''),
  12818 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12818, CurrentID=0, Status='live', Symbol='Col14a1', Aliases='5730412L22Rik, AW108078', description='collagen, type XIV, alpha 1', other_designations='col14a1|procollagen, type XIV, alpha 1', map_location='15 D', chromosome='15', genomic_nucleotide_accession_version='NC_000081.6', start_position_on_the_genomic_accession=55307706, end_position_on_the_genomic_accession=55520803, orientation='plus', exon_count=49, OMIM='', no_hdr0=''),
  12819 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12819, CurrentID=0, Status='live', Symbol='Col15a1', Aliases='', description='collagen, type XV, alpha 1', other_designations='procollagen type XV|procollagen, type XV|type XV collagen', map_location='4 B1-B3', chromosome='4', genomic_nucleotide_accession_version='NC_000070.6', start_position_on_the_genomic_accession=47207633, end_position_on_the_genomic_accession=47313167, orientation='plus', exon_count=42, OMIM='', no_hdr0=''),
  12821 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12821, CurrentID=0, Status='live', Symbol='Col17a1', Aliases='BP180, Bpag, Bpag2', description='collagen, type XVII, alpha 1', other_designations='180 kDa bullous pemphigoid antigen 2|bullous pemphigoid antigen 2|procollagen, type XVII, alpha 1', map_location='19 40.07 cM', chromosome='19', genomic_nucleotide_accession_version='NC_000085.6', start_position_on_the_genomic_accession=47646341, end_position_on_the_genomic_accession=47692042, orientation='minus', exon_count=54, OMIM='', no_hdr0=''),
  12822 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12822, CurrentID=0, Status='live', Symbol='Col18a1', Aliases='', description='collagen, type XVIII, alpha 1', other_designations='endostatin|procollagen, type XVIII, alpha 1', map_location='10 39.72 cM', chromosome='10', genomic_nucleotide_accession_version='NC_000076.6', start_position_on_the_genomic_accession=77052178, end_position_on_the_genomic_accession=77166530, orientation='minus', exon_count=44, OMIM='', no_hdr0=''),
  12823 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12823, CurrentID=0, Status='live', Symbol='Col19a1', Aliases='', description='collagen, type XIX, alpha 1', other_designations='col19a1|collagen alpha-1(Y) chain|procollagen, type XIX, alpha 1', map_location='1 A3', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=24257683, end_position_on_the_genomic_accession=24588036, orientation='minus', exon_count=52, OMIM='', no_hdr0=''),
  12824 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12824, CurrentID=0, Status='live', Symbol='Col2a1', Aliases='Col2, Col2a, Col2a-1, Del1, Dmm, Lpk, Rgsc856', description='collagen, type II, alpha 1', other_designations='alpha-1 type II collagen|chondrocalcin|procollagen, type II, alpha 1', map_location='15 53.97 cM', chromosome='15', genomic_nucleotide_accession_version='NC_000081.6', start_position_on_the_genomic_accession=97975602, end_position_on_the_genomic_accession=98004724, orientation='minus', exon_count=55, OMIM='', no_hdr0=''),
  12825 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12825, CurrentID=0, Status='live', Symbol='Col3a1', Aliases='AW550625, Col3a-1, Tsk-2, Tsk2', description='collagen, type III, alpha 1', other_designations='procollagen, type III, alpha 1', map_location='1 23.67 cM', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=45311538, end_position_on_the_genomic_accession=45349706, orientation='plus', exon_count=51, OMIM='', no_hdr0=''),
  12826 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12826, CurrentID=0, Status='live', Symbol='Col4a1', Aliases='Bru, Col4a-1, Raw, Svc', description='collagen, type IV, alpha 1', other_designations='alpha1(IV) collagen|procollagen, type IV, alpha 1', map_location='8 5.53 cM', chromosome='8', genomic_nucleotide_accession_version='NC_000074.6', start_position_on_the_genomic_accession=11198423, end_position_on_the_genomic_accession=11312826, orientation='minus', exon_count=53, OMIM='', no_hdr0=''),
  12827 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12827, CurrentID=0, Status='live', Symbol='Col4a2', Aliases='Col4a-2', description='collagen, type IV, alpha 2', other_designations='canstatin|procollagen, type IV, alpha 2', map_location='8 5.62 cM', chromosome='8', genomic_nucleotide_accession_version='NC_000074.6', start_position_on_the_genomic_accession=11312829, end_position_on_the_genomic_accession=11449287, orientation='plus', exon_count=48, OMIM='', no_hdr0=''),
  12828 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12828, CurrentID=0, Status='live', Symbol='Col4a3', Aliases='[a]3(IV), alpha3(IV)', description='collagen, type IV, alpha 3', other_designations='col4a3|collagen type IV alpha3 chain|procollagen, type IV, alpha 3|tumstatin', map_location='1 C5', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=82586921, end_position_on_the_genomic_accession=82722059, orientation='plus', exon_count=52, OMIM='', no_hdr0=''),
  12829 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12829, CurrentID=0, Status='live', Symbol='Col4a4', Aliases='E130010M05Rik, [a]4(IV)', description='collagen, type IV, alpha 4', other_designations='col4a4|procollagen, type IV, alpha 4', map_location='1 C5', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=82448419, end_position_on_the_genomic_accession=82586849, orientation='minus', exon_count=50, OMIM='', no_hdr0=''),
  12830 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12830, CurrentID=0, Status='live', Symbol='Col4a5', Aliases='', description='collagen, type IV, alpha 5', other_designations='collagen type IV alpha5 chain|procollagen type IV alpha 5|procollagen, type IV, alpha 5', map_location='X 62.16 cM', chromosome='X', genomic_nucleotide_accession_version='NC_000086.7', start_position_on_the_genomic_accession=141475369, end_position_on_the_genomic_accession=141689236, orientation='plus', exon_count=53, OMIM='', no_hdr0=''),
  12831 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12831, CurrentID=0, Status='live', Symbol='Col5a1', Aliases='AI413331', description='collagen, type V, alpha 1', other_designations='alpha1(V) collagen|pro-alpha1(V) collagen|procollagen type V alpha 1|procollagen, type V, alpha 1', map_location='2 A2-B', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=27886395, end_position_on_the_genomic_accession=28039510, orientation='plus', exon_count=67, OMIM='', no_hdr0=''),
  12832 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12832, CurrentID=0, Status='live', Symbol='Col5a2', Aliases='1110014L14Rik', description='collagen, type V, alpha 2', other_designations='procollagen, type V, alpha 2', map_location='1 C1', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=45374331, end_position_on_the_genomic_accession=45503282, orientation='minus', exon_count=54, OMIM='', no_hdr0=''),
  12833 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12833, CurrentID=0, Status='live', Symbol='Col6a1', Aliases='AI747156, Col6a-1', description='collagen, type VI, alpha 1', other_designations='procollagen, type VI, alpha 1', map_location='10 39.71 cM', chromosome='10', genomic_nucleotide_accession_version='NC_000076.6', start_position_on_the_genomic_accession=76708792, end_position_on_the_genomic_accession=76726044, orientation='minus', exon_count=35, OMIM='', no_hdr0=''),
  12834 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12834, CurrentID=0, Status='live', Symbol='Col6a2', Aliases='Col6a-2', description='collagen, type VI, alpha 2', other_designations='procollagen, type VI, alpha 2', map_location='10 39.32 cM', chromosome='10', genomic_nucleotide_accession_version='NC_000076.6', start_position_on_the_genomic_accession=76595756, end_position_on_the_genomic_accession=76623625, orientation='minus', exon_count=29, OMIM='', no_hdr0=''),
  12835 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12835, CurrentID=0, Status='live', Symbol='Col6a3', Aliases='AI507288, Col6a-3', description='collagen, type VI, alpha 3', other_designations='collagen alpha 3 chain type VI|collagen alpha3(VI)|procollagen, type VI, alpha 3|type VI collagen alpha 3 subunit', map_location='1 45.53 cM', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=90766860, end_position_on_the_genomic_accession=90843971, orientation='minus', exon_count=44, OMIM='', no_hdr0=''),
  12836 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12836, CurrentID=0, Status='live', Symbol='Col7a1', Aliases='AW209154', description='collagen, type VII, alpha 1', other_designations='LC collagen|col7a1|long-chain collagen|procollagen, type VII, alpha 1', map_location='9 59.63 cM', chromosome='9', genomic_nucleotide_accession_version='NC_000075.6', start_position_on_the_genomic_accession=108953575, end_position_on_the_genomic_accession=108984875, orientation='plus', exon_count=119, OMIM='', no_hdr0=''),
  12837 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12837, CurrentID=0, Status='live', Symbol='Col8a1', Aliases='Col8a-1', description='collagen, type VIII, alpha 1', other_designations='procollagen type VIII alpha 1|procollagen, type VIII, alpha 1', map_location='16 C1.1', chromosome='16', genomic_nucleotide_accession_version='NC_000082.6', start_position_on_the_genomic_accession=57624256, end_position_on_the_genomic_accession=57754737, orientation='minus', exon_count=4, OMIM='', no_hdr0=''),
  12839 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12839, CurrentID=0, Status='live', Symbol='Col9a1', Aliases='Col9a-1', description='collagen, type IX, alpha 1', other_designations='alpha 1 type IX collagen|procollagen, type IX, alpha 1', map_location='1 9.95 cM', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=24177590, end_position_on_the_genomic_accession=24252738, orientation='plus', exon_count=40, OMIM='', no_hdr0=''),
  12840 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12840, CurrentID=0, Status='live', Symbol='Col9a2', Aliases='AI427499, Col9a-2', description='collagen, type IX, alpha 2', other_designations='procollagen, type IX, alpha 2', map_location='4 56.78 cM', chromosome='4', genomic_nucleotide_accession_version='NC_000070.6', start_position_on_the_genomic_accession=121039566, end_position_on_the_genomic_accession=121055325, orientation='plus', exon_count=32, OMIM='', no_hdr0=''),
  12841 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12841, CurrentID=0, Status='live', Symbol='Col9a3', Aliases='AV006866', description='collagen, type IX, alpha 3', other_designations='procollagen, type IX, alpha 3', map_location='2 103.14 cM', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=180597795, end_position_on_the_genomic_accession=180622185, orientation='plus', exon_count=33, OMIM='', no_hdr0=''),
  12842 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12842, CurrentID=0, Status='live', Symbol='Col1a1', Aliases='Col1a-1, Cola-1, Cola1, Mov-13, Mov13', description='collagen, type I, alpha 1', other_designations='alpha-1 type 1 collagen|alpha-1 type I collagen|procollagen, type I, alpha 1', map_location='11 D', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=94936270, end_position_on_the_genomic_accession=94951867, orientation='plus', exon_count=51, OMIM='', no_hdr0=''),
  12843 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12843, CurrentID=0, Status='live', Symbol='Col1a2', Aliases='AA960264, AI325291, Col1a-2, Cola-2, Cola2, oim', description='collagen, type I, alpha 2', other_designations='alpha-2 type I collagen|collagen COL1A2|procollagen, type I, alpha 2', map_location='6 1.81 cM', chromosome='6', genomic_nucleotide_accession_version='NC_000072.6', start_position_on_the_genomic_accession=4505697, end_position_on_the_genomic_accession=4541543, orientation='plus', exon_count=52, OMIM='', no_hdr0=''),
  12845 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12845, CurrentID=0, Status='live', Symbol='Comp', Aliases='TSP5', description='cartilage oligomeric matrix protein', other_designations='thrombospondin-5', map_location='8 34.15 cM', chromosome='8', genomic_nucleotide_accession_version='NC_000074.6', start_position_on_the_genomic_accession=70373548, end_position_on_the_genomic_accession=70382066, orientation='plus', exon_count=20, OMIM='', no_hdr0=''),
  12846 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12846, CurrentID=0, Status='live', Symbol='Comt', Aliases='Comt1, D16Wsu103e, D330014B15Rik', description='catechol-O-methyltransferase', other_designations='catechol-O-methyltransferase 1', map_location='16 11.4 cM', chromosome='16', genomic_nucleotide_accession_version='NC_000082.6', start_position_on_the_genomic_accession=18406882, end_position_on_the_genomic_accession=18426716, orientation='minus', exon_count=7, OMIM='', no_hdr0=''),
  12847 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12847, CurrentID=0, Status='live', Symbol='Copa', Aliases='AU040324, xenin', description='coatomer protein complex subunit alpha', other_designations='alpha-COP|alpha-coat protein', map_location='1 79.54 cM', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=172082529, end_position_on_the_genomic_accession=172122332, orientation='plus', exon_count=34, OMIM='', no_hdr0=''),
  12848 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12848, CurrentID=0, Status='live', Symbol='Cops2', Aliases='AI315723, C85265, Csn2, Sgn2, TRIP-15, Trip15', description='COP9 signalosome subunit 2', other_designations='COP9 (constitutive photomorphogenic) homolog, subunit 2|JAB1-containing signalosome subunit 2|TR-interacting protein 15|alien homolog|alien-like|thyroid receptor-interacting protein 15', map_location='2 61.76 cM', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=125830302, end_position_on_the_genomic_accession=125859082, orientation='minus', exon_count=13, OMIM='', no_hdr0=''),
  12850 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12850, CurrentID=0, Status='live', Symbol='Coq7', Aliases='clk-1', description='demethyl-Q 7', other_designations='DMQ hydroxylase|coenzyme Q biosynthesis protein 7 homolog|timing protein clk-1 homolog|ubiquinone biosynthesis monooxygenase COQ7|ubiquinone biosynthesis protein COQ7 homolog', map_location='7 63.44 cM', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=118509659, end_position_on_the_genomic_accession=118533368, orientation='minus', exon_count=8, OMIM='', no_hdr0=''),
  668212 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=668212, CurrentID=0, Status='live', Symbol='Efr3b', Aliases='AI852640, C030014M07Rik, mKIAA0953', description='EFR3 homolog B', other_designations='', map_location='12 A1.1', chromosome='12', genomic_nucleotide_accession_version='NC_000078.6', start_position_on_the_genomic_accession=3962554, end_position_on_the_genomic_accession=4039094, orientation='minus', exon_count=24, OMIM='', no_hdr0=''),
  12854 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12854, CurrentID=0, Status='live', Symbol='Cort', Aliases='CST, PCST', description='cortistatin', other_designations='', map_location='4 78.89 cM', chromosome='4', genomic_nucleotide_accession_version='NC_000070.6', start_position_on_the_genomic_accession=149125191, end_position_on_the_genomic_accession=149126741, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  12856 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12856, CurrentID=0, Status='live', Symbol='Cox17', Aliases='AI037035', description='cytochrome c oxidase assembly protein 17', other_designations='cytochrome c oxidase subunit XVII assembly protein homolog|cytochrome c oxidase, subunit XVII assembly protein homolog', map_location='16 B3', chromosome='16', genomic_nucleotide_accession_version='NC_000082.6', start_position_on_the_genomic_accession=38346984, end_position_on_the_genomic_accession=38352763, orientation='plus', exon_count=4, OMIM='', no_hdr0=''),
  12857 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12857, CurrentID=0, Status='live', Symbol='Cox4i1', Aliases='AL024441, COX, COX IV-1, COXIV, Cox4, Cox4a, IV-1', description='cytochrome c oxidase subunit IV isoform 1', other_designations='cytochrome c oxidase polypeptide IV|cytochrome c oxidase, subunit IVa', map_location='8 69.99 cM', chromosome='8', genomic_nucleotide_accession_version='NC_000074.6', start_position_on_the_genomic_accession=120668225, end_position_on_the_genomic_accession=120674209, orientation='plus', exon_count=5, OMIM='', no_hdr0=''),
  668218 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=668218, CurrentID=0, Status='live', Symbol='Bin2', Aliases='', description='bridging integrator 2', other_designations='', map_location='15 F1', chromosome='15', genomic_nucleotide_accession_version='NC_000081.6', start_position_on_the_genomic_accession=100641082, end_position_on_the_genomic_accession=100669576, orientation='minus', exon_count=12, OMIM='', no_hdr0=''),
  12859 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12859, CurrentID=0, Status='live', Symbol='Cox5b', Aliases='', description='cytochrome c oxidase subunit Vb', other_designations='cytochrome c oxidase polypeptide Vb', map_location='1 B', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=36691487, end_position_on_the_genomic_accession=36693388, orientation='plus', exon_count=4, OMIM='', no_hdr0=''),
  12861 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12861, CurrentID=0, Status='live', Symbol='Cox6a1', Aliases='VIaL', description='cytochrome c oxidase subunit VIa polypeptide 1', other_designations='cytochrome c oxidase polypeptide VIa-liver|subunit VIaL (liver-type)', map_location='5 56.06 cM', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=115345654, end_position_on_the_genomic_accession=115348955, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  12862 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12862, CurrentID=0, Status='live', Symbol='Cox6a2', Aliases='CoxVIaH, VIaH', description='cytochrome c oxidase subunit VIa polypeptide 2', other_designations='cytochrome c oxidase polypeptide VIa-heart|subunit VIaH (heart-type)', map_location='7 70.04 cM', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=128205435, end_position_on_the_genomic_accession=128206366, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  12864 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12864, CurrentID=0, Status='live', Symbol='Cox6c', Aliases='', description='cytochrome c oxidase subunit VIc', other_designations='cytochrome c oxidase polypeptide VIc', map_location='15 B3.3', chromosome='15', genomic_nucleotide_accession_version='NC_000081.6', start_position_on_the_genomic_accession=35931976, end_position_on_the_genomic_accession=35938246, orientation='minus', exon_count=4, OMIM='', no_hdr0=''),
  12865 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12865, CurrentID=0, Status='live', Symbol='Cox7a1', Aliases='COX7A, COX7AH, COX7AM', description='cytochrome c oxidase subunit VIIa 1', other_designations='cytochrome c oxidase subunit VIIa-H|cytochrome c oxidase subunit VIIa-M|cytochrome c oxidase subunit VIIa-heart|cytochrome c oxidase subunit VIIa-muscle|cytochrome c oxidase, subunit VIIa 1', map_location='7 17.31 cM', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=30184171, end_position_on_the_genomic_accession=30186030, orientation='plus', exon_count=4, OMIM='', no_hdr0=''),
  12866 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12866, CurrentID=0, Status='live', Symbol='Cox7a2', Aliases='COX7AL, Cox7a3, CoxVIIa-L', description='cytochrome c oxidase subunit VIIa 2', other_designations='cytochrome c oxidase subunit VIIa 3|cytochrome c oxidase subunit VIIa-L|cytochrome c oxidase subunit VIIa-liver/heart', map_location='9 43.82 cM', chromosome='9', genomic_nucleotide_accession_version='NC_000075.6', start_position_on_the_genomic_accession=79755241, end_position_on_the_genomic_accession=79759853, orientation='minus', exon_count=4, OMIM='', no_hdr0=''),
  12867 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12867, CurrentID=0, Status='live', Symbol='Cox7c', Aliases='COXVIIc1, Cox7c', description='cytochrome c oxidase subunit VIIc', other_designations='cytochrome c oxidase polypeptide VIIc', map_location='13 C3', chromosome='13', genomic_nucleotide_accession_version='NC_000079.6', start_position_on_the_genomic_accession=86044798, end_position_on_the_genomic_accession=86046795, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  12868 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12868, CurrentID=0, Status='live', Symbol='Cox8a', Aliases='COX8L', description='cytochrome c oxidase subunit VIIIa', other_designations='COX VIII-L|cytochrome c oxidase polypeptide VIII-liver|cytochrome c oxidase subunit 8-2', map_location='19 A', chromosome='19', genomic_nucleotide_accession_version='NC_000085.6', start_position_on_the_genomic_accession=7215158, end_position_on_the_genomic_accession=7217616, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  12869 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12869, CurrentID=0, Status='live', Symbol='Cox8b', Aliases='Cox8h, CoxVIII-H', description='cytochrome c oxidase subunit VIIIb', other_designations='COX VIII-H|cytochrome c oxidase polypeptide VIII-heart|cytochrome c oxidase subunit 8-1|cytochrome c oxidase subunit 8H|cytochrome c oxidase subunit VIII-H', map_location='7 86.11 cM', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=140898942, end_position_on_the_genomic_accession=140900446, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  12870 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12870, CurrentID=0, Status='live', Symbol='Cp', Aliases='D3Ertd555e', description='ceruloplasmin', other_designations='ferroxidase', map_location='3 D', chromosome='3', genomic_nucleotide_accession_version='NC_000069.6', start_position_on_the_genomic_accession=19956987, end_position_on_the_genomic_accession=20009750, orientation='plus', exon_count=22, OMIM='', no_hdr0=''),
  12873 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12873, CurrentID=0, Status='live', Symbol='Cpa3', Aliases='MC-CPA', description='carboxypeptidase A3, mast cell', other_designations='', map_location='3 6.25 cM', chromosome='3', genomic_nucleotide_accession_version='NC_000069.6', start_position_on_the_genomic_accession=20215616, end_position_on_the_genomic_accession=20242209, orientation='minus', exon_count=11, OMIM='', no_hdr0=''),
  12874 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12874, CurrentID=0, Status='live', Symbol='Cpd', Aliases='AA960140, AW322530, D830034L15Rik', description='carboxypeptidase D', other_designations='gp180|metallocarboxypeptidase D', map_location='11 46.05 cM', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=76777208, end_position_on_the_genomic_accession=76847008, orientation='minus', exon_count=21, OMIM='', no_hdr0=''),
  12876 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12876, CurrentID=0, Status='live', Symbol='Cpe', Aliases='CPH, Cph-1, Cph1, R74677, fat', description='carboxypeptidase E', other_designations='carboxypeptidase H|enkephalin convertase|prohormone-processing carboxypeptidase', map_location='8 32.3 cM', chromosome='8', genomic_nucleotide_accession_version='NC_000074.6', start_position_on_the_genomic_accession=64592542, end_position_on_the_genomic_accession=64693040, orientation='minus', exon_count=9, OMIM='', no_hdr0=''),
  12877 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12877, CurrentID=0, Status='live', Symbol='Cpeb1', Aliases='AU024112, Cpeb, mCPEB', description='cytoplasmic polyadenylation element binding protein 1', other_designations='CPE-BP1|CPE-binding protein 1|mCPEB-1', map_location='7 D3', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=81347026, end_position_on_the_genomic_accession=81455457, orientation='minus', exon_count=17, OMIM='', no_hdr0=''),
  12879 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12879, CurrentID=0, Status='live', Symbol='Cys1', Aliases='2900006B19Rik, AV218859, Ccap, ck, cpk', description='cystin 1', other_designations='cilia-associated protein|congenital polycystic kidneys|cystin cilia associated protein', map_location='12 8.49 cM', chromosome='12', genomic_nucleotide_accession_version='NC_000078.6', start_position_on_the_genomic_accession=24665833, end_position_on_the_genomic_accession=24681795, orientation='minus', exon_count=4, OMIM='', no_hdr0=''),
  329828 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=329828, CurrentID=0, Status='live', Symbol='AI464131', Aliases='AA408153, AI604836, Gm762, Kiaa1161, NET37', description='expressed sequence AI464131', other_designations='', map_location='4 A5', chromosome='4', genomic_nucleotide_accession_version='NC_000070.6', start_position_on_the_genomic_accession=41491847, end_position_on_the_genomic_accession=41503136, orientation='minus', exon_count=4, OMIM='', no_hdr0=''),
  12890 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12890, CurrentID=0, Status='live', Symbol='Cplx2', Aliases='921-L, AI413745, AW492120', description='complexin 2', other_designations='CPX II|complexin II|synaphin-1', map_location='13 B1', chromosome='13', genomic_nucleotide_accession_version='NC_000079.6', start_position_on_the_genomic_accession=54371349, end_position_on_the_genomic_accession=54383917, orientation='plus', exon_count=4, OMIM='', no_hdr0=''),
  12891 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12891, CurrentID=0, Status='live', Symbol='Cpne6', Aliases='AU067659, BB076446', description='copine VI', other_designations='N-copine|copine 6|neuronal copine|neuronal-copine', map_location='14 C3', chromosome='14', genomic_nucleotide_accession_version='NC_000080.6', start_position_on_the_genomic_accession=55510063, end_position_on_the_genomic_accession=55517431, orientation='plus', exon_count=18, OMIM='', no_hdr0=''),
  12892 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12892, CurrentID=0, Status='live', Symbol='Cpox', Aliases='CPX, Cpo, HCP, cac, nct', description='coproporphyrinogen oxidase', other_designations='COX|Coproporphyrinogen III oxidase, mitochondrial precursor (Coproporphyrinogenase) (Coprogen oxidase) (COX)|clone 560|coprogen oxidase|coproporphyrinogen-III oxidase, mitochondrial|coproporphyrinogenase', map_location='16 C1.1', chromosome='16', genomic_nucleotide_accession_version='NC_000082.6', start_position_on_the_genomic_accession=58670208, end_position_on_the_genomic_accession=58680391, orientation='plus', exon_count=7, OMIM='', no_hdr0=''),
  668253 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=668253, CurrentID=0, Status='live', Symbol='Dleu2', Aliases='1810047A16Rik, 4932411A06Rik, 7730401J12Rik, AI197277, AI788824, Alt1, Gm9069, Leu2', description='deleted in lymphocytic leukemia, 2', other_designations='', map_location='14 33.16 cM', chromosome='14', genomic_nucleotide_accession_version='NC_000080.6', start_position_on_the_genomic_accession=61602836, end_position_on_the_genomic_accession=61682373, orientation='minus', exon_count=7, OMIM='', no_hdr0=''),
  12894 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12894, CurrentID=0, Status='live', Symbol='Cpt1a', Aliases='C730027G07, CPTI, Cpt1', description='carnitine palmitoyltransferase 1a, liver', other_designations='CPT I|CPT1-L|CPTI-L|L-CPT I|carnitine O-palmitoyltransferase I, liver isoform|carnitine palmitoyltransferase 1, liver', map_location='19 3.08 cM', chromosome='19', genomic_nucleotide_accession_version='NC_000085.6', start_position_on_the_genomic_accession=3322326, end_position_on_the_genomic_accession=3385735, orientation='plus', exon_count=25, OMIM='', no_hdr0=''),
  12895 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12895, CurrentID=0, Status='live', Symbol='Cpt1b', Aliases='Cpt1, Cpt1-m, Cpti, Cpti-m, M-cpti', description='carnitine palmitoyltransferase 1b, muscle', other_designations='muscle-type carnitine palmitoyltransferase I', map_location='15 44.89 cM', chromosome='15', genomic_nucleotide_accession_version='NC_000081.6', start_position_on_the_genomic_accession=89416405, end_position_on_the_genomic_accession=89425862, orientation='minus', exon_count=19, OMIM='', no_hdr0=''),
  12896 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12896, CurrentID=0, Status='live', Symbol='Cpt2', Aliases='AI323697, CPTII', description='carnitine palmitoyltransferase 2', other_designations='CPT II|carnitine palmitoyltransferase II', map_location='4 50.18 cM', chromosome='4', genomic_nucleotide_accession_version='NC_000070.6', start_position_on_the_genomic_accession=107903982, end_position_on_the_genomic_accession=107923589, orientation='minus', exon_count=5, OMIM='', no_hdr0=''),
  668257 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=668257, CurrentID=0, Status='live', Symbol='Dgat2l6', Aliases='9930021F22Rik', description='diacylglycerol O-acyltransferase 2-like 6', other_designations='', map_location='X C3', chromosome='X', genomic_nucleotide_accession_version='NC_000086.7', start_position_on_the_genomic_accession=100516094, end_position_on_the_genomic_accession=100546108, orientation='plus', exon_count=10, OMIM='', no_hdr0=''),
  12902 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12902, CurrentID=0, Status='live', Symbol='Cr2', Aliases='C3DR, CD21, CD35, Cr-1, Cr-2, Cr1', description='complement receptor 2', other_designations='complement C3d receptor|complement receptor type 1|expressed in B lymphocytes', map_location='1 98.44 cM', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=195136811, end_position_on_the_genomic_accession=195177190, orientation='minus', exon_count=26, OMIM='', no_hdr0=''),
  12903 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12903, CurrentID=0, Status='live', Symbol='Crabp1', Aliases='AI326249, CRABP-I, Crabp-1, CrabpI, Rbp-5', description='cellular retinoic acid binding protein I', other_designations='cellular retinoic acid-binding protein I', map_location='9 29.76 cM', chromosome='9', genomic_nucleotide_accession_version='NC_000075.6', start_position_on_the_genomic_accession=54764748, end_position_on_the_genomic_accession=54773110, orientation='plus', exon_count=4, OMIM='', no_hdr0=''),
  12904 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12904, CurrentID=0, Status='live', Symbol='Crabp2', Aliases='AI893628, Crabp-2, CrabpII', description='cellular retinoic acid binding protein II', other_designations='CRABP-II|cellular retinoic acid-binding protein II', map_location='3', chromosome='3', genomic_nucleotide_accession_version='NC_000069.6', start_position_on_the_genomic_accession=87948693, end_position_on_the_genomic_accession=87953372, orientation='plus', exon_count=4, OMIM='', no_hdr0=''),
  12905 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12905, CurrentID=0, Status='live', Symbol='Cradd', Aliases='RAIDD', description='CASP2 and RIPK1 domain containing adaptor with death domain', other_designations='CASP2 and RIPK1 domain-containing adaptor with death domain|RIP-associated protein with a death domain|caspase and RIP adapter with death domain', map_location='10 49.26 cM', chromosome='10', genomic_nucleotide_accession_version='NC_000076.6', start_position_on_the_genomic_accession=95174739, end_position_on_the_genomic_accession=95324345, orientation='minus', exon_count=5, OMIM='', no_hdr0=''),
  67687 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=67687, CurrentID=0, Status='live', Symbol='1700011L22Rik', Aliases='', description='RIKEN cDNA 1700011L22 gene', other_designations='', map_location='8 C2', chromosome='8', genomic_nucleotide_accession_version='NC_000074.6', start_position_on_the_genomic_accession=79210423, end_position_on_the_genomic_accession=79248897, orientation='minus', exon_count=8, OMIM='', no_hdr0=''),
  12908 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12908, CurrentID=0, Status='live', Symbol='Crat', Aliases='AW107812, CARAT', description='carnitine acetyltransferase', other_designations='CAT|carnitine acetylase', map_location='2 21.69 cM', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=30400476, end_position_on_the_genomic_accession=30415748, orientation='minus', exon_count=17, OMIM='', no_hdr0=''),
  12909 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12909, CurrentID=0, Status='live', Symbol='Crcp', Aliases='AL022669', description='calcitonin gene-related peptide-receptor component protein', other_designations='CGRP-RCP|CGRP-receptor component protein|CGRPRCP|RNA polymerase III subunit C9', map_location='5 G1.3', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=130029306, end_position_on_the_genomic_accession=130060787, orientation='plus', exon_count=6, OMIM='', no_hdr0=''),
  12912 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12912, CurrentID=0, Status='live', Symbol='Creb1', Aliases='2310001E10Rik, 3526402H21Rik, AV083133, Creb, Creb-1', description='cAMP responsive element binding protein 1', other_designations='cAMP-responsive element-binding protein 1', map_location='1 32.74 cM', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=64532804, end_position_on_the_genomic_accession=64604548, orientation='plus', exon_count=12, OMIM='', no_hdr0=''),
  12913 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12913, CurrentID=0, Status='live', Symbol='Creb3', Aliases='AU044960, AW538053, C80076, LZIP, LZIP-1, LZIP-2, Luman', description='cAMP responsive element binding protein 3', other_designations='CREB-3|cAMP-responsive element-binding protein 3|transcription factor LZIP', map_location='4 23.05 cM', chromosome='4', genomic_nucleotide_accession_version='NC_000070.6', start_position_on_the_genomic_accession=43562634, end_position_on_the_genomic_accession=43567060, orientation='plus', exon_count=9, OMIM='', no_hdr0=''),
  12914 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12914, CurrentID=0, Status='live', Symbol='Crebbp', Aliases='AW558298, CBP, CBP/p300, KAT3A, p300/CBP', description='CREB binding protein', other_designations='', map_location='16 2.4 cM', chromosome='16', genomic_nucleotide_accession_version='NC_000082.6', start_position_on_the_genomic_accession=4081334, end_position_on_the_genomic_accession=4213454, orientation='minus', exon_count=31, OMIM='', no_hdr0=''),
  12915 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12915, CurrentID=0, Status='live', Symbol='Atf6b', Aliases='AA617266, ATF6beta, Creb-rp, Crebl1', description='activating transcription factor 6 beta', other_designations='ATF6-beta|cAMP response element binding protein-related protein|cAMP response element-binding protein-related protein|cAMP responsive element binding protein-like 1|cAMP-dependent transcription factor ATF-6 beta|cAMP-responsive element-binding protein-like 1', map_location='17 18.22 cM', chromosome='17', genomic_nucleotide_accession_version='NC_000083.6', start_position_on_the_genomic_accession=34647146, end_position_on_the_genomic_accession=34655074, orientation='plus', exon_count=18, OMIM='', no_hdr0=''),
  12916 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12916, CurrentID=0, Status='live', Symbol='Crem', Aliases='ICER, ICERI', description='cAMP responsive element modulator', other_designations='cAMP responsive element moderator|inducible cAMP early repressor', map_location='18 A', chromosome='18', genomic_nucleotide_accession_version='NC_000084.6', start_position_on_the_genomic_accession=3266354, end_position_on_the_genomic_accession=3340355, orientation='minus', exon_count=16, OMIM='', no_hdr0=''),
  12917 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12917, CurrentID=0, Status='live', Symbol='crf', Aliases='', description='cream fur', other_designations='', map_location='', chromosome='13', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  12918 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12918, CurrentID=0, Status='live', Symbol='Crh', Aliases='CRF, Gm1347', description='corticotropin releasing hormone', other_designations='corticotropin releasing factor|corticotropin-releasing factor|corticotropin-releasing hormone', map_location='3 5.75 cM', chromosome='3', genomic_nucleotide_accession_version='NC_000069.6', start_position_on_the_genomic_accession=19693401, end_position_on_the_genomic_accession=19695396, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  12919 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12919, CurrentID=0, Status='live', Symbol='Crhbp', Aliases='CRH-BP', description='corticotropin releasing hormone binding protein', other_designations='CRF-BP|CRF-binding protein|corticotropin-releasing hormone-binding protein', map_location='13 49.5 cM', chromosome='13', genomic_nucleotide_accession_version='NC_000079.6', start_position_on_the_genomic_accession=95431376, end_position_on_the_genomic_accession=95444831, orientation='minus', exon_count=7, OMIM='', no_hdr0=''),
  12921 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12921, CurrentID=0, Status='live', Symbol='Crhr1', Aliases='CRFR1, Crhr', description='corticotropin releasing hormone receptor 1', other_designations='CRF 1 receptor|CRF-R-1|CRF-R1|CRF-R1alpha|CRFR-1|CRH receptor subtype-1 isoform-3|CRH-R-1|CRH-R1|corticotropin-releasing hormone receptor 1', map_location='11 67.77 cM', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=104131998, end_position_on_the_genomic_accession=104175518, orientation='plus', exon_count=13, OMIM='', no_hdr0=''),
  12922 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12922, CurrentID=0, Status='live', Symbol='Crhr2', Aliases='CRF-R2, CRFR2alpha, CRFR2beta, Crfr2', description='corticotropin releasing hormone receptor 2', other_designations='CRF 2 receptor|CRF-R-2|CRF-RB|CRFR-2|CRH-R-2|CRH-R2|corticotropin releasing factor receptor type 2 beta|corticotropin-releasing factor 2|corticotropin-releasing hormone receptor 2', map_location='6 27.33 cM', chromosome='6', genomic_nucleotide_accession_version='NC_000072.6', start_position_on_the_genomic_accession=55090048, end_position_on_the_genomic_accession=55133016, orientation='minus', exon_count=14, OMIM='', no_hdr0=''),
  12924 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12924, CurrentID=0, Status='live', Symbol='cri', Aliases='', description='cribriform degeneration', other_designations='', map_location='', chromosome='4', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  12925 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12925, CurrentID=0, Status='live', Symbol='Crip1', Aliases='CRHP, CRP1, Crip', description='cysteine-rich protein 1 (intestinal)', other_designations='CRP-1|cysteine rich intestinal protein|cysteine-rich intestinal protein', map_location='12 61.59 cM', chromosome='12', genomic_nucleotide_accession_version='NC_000078.6', start_position_on_the_genomic_accession=113152012, end_position_on_the_genomic_accession=113153879, orientation='plus', exon_count=5, OMIM='', no_hdr0=''),
  12927 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12927, CurrentID=0, Status='live', Symbol='Bcar1', Aliases='AI385681, Cas, Crkas', description='breast cancer anti-estrogen resistance 1', other_designations='CRK-associated substrate|p130 Cas|p130cas|v-crk-associated tyrosine kinase substrate', map_location='8 D3', chromosome='8', genomic_nucleotide_accession_version='NC_000074.6', start_position_on_the_genomic_accession=111710474, end_position_on_the_genomic_accession=111743849, orientation='minus', exon_count=9, OMIM='', no_hdr0=''),
  12928 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12928, CurrentID=0, Status='live', Symbol='Crk', Aliases='Crk-I-II, Crk-III, Crk3, CrkIII, Crko, c-Crk, p38, Crk', description='v-crk avian sarcoma virus CT10 oncogene homolog', other_designations='CT-10 related kinase 3|avian sarcoma virus CT10 (v-crk) oncogene homolog|proto-oncogene c-crk|v-crk sarcoma virus CT10 oncogene homolog|v-crk sarcoma virus CT10 oncogene-like protein', map_location='11 A-D', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=75679248, end_position_on_the_genomic_accession=75708428, orientation='plus', exon_count=4, OMIM='', no_hdr0=''),
  12929 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12929, CurrentID=0, Status='live', Symbol='Crkl', Aliases='1110025F07Rik, AA589403, AI325100, Crkol', description='v-crk avian sarcoma virus CT10 oncogene homolog-like', other_designations='v-crk sarcoma virus CT10 oncogene homolog (avian)-like', map_location='16 A3', chromosome='16', genomic_nucleotide_accession_version='NC_000082.6', start_position_on_the_genomic_accession=17451985, end_position_on_the_genomic_accession=17487440, orientation='plus', exon_count=3, OMIM='', no_hdr0=''),
  12931 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12931, CurrentID=0, Status='live', Symbol='Crlf1', Aliases='CLF-1, CRLM-3, CRLM3, NR6, NR6.1', description='cytokine receptor-like factor 1', other_designations='cytokine receptor like molecule 3|cytokine receptor-like molecule 3|cytokine-like factor 1|novel cytokine receptor 6', map_location='8 34.15 cM', chromosome='8', genomic_nucleotide_accession_version='NC_000074.6', start_position_on_the_genomic_accession=70493107, end_position_on_the_genomic_accession=70504081, orientation='plus', exon_count=9, OMIM='', no_hdr0=''),
  12933 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12933, CurrentID=0, Status='live', Symbol='Crmp1', Aliases='CRMP-1, DRP-1, Dpysl1, ULIP-3, Ulip3', description='collapsin response mediator protein 1', other_designations='unc-33-like phosphoprotein 3', map_location='5 19.96 cM', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=37242058, end_position_on_the_genomic_accession=37292163, orientation='plus', exon_count=15, OMIM='', no_hdr0=''),
  12934 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12934, CurrentID=0, Status='live', Symbol='Dpysl2', Aliases='AI851130, Crmp2, DRP2, Musunc33, TOAD-64, Ulip2', description='dihydropyrimidinase-like 2', other_designations='DRP-2|ULIP-2|collapsin response mediator protein 2|unc-33-like phosphoprotein 2', map_location='14 34.6 cM', chromosome='14', genomic_nucleotide_accession_version='NC_000080.6', start_position_on_the_genomic_accession=66802864, end_position_on_the_genomic_accession=66910919, orientation='minus', exon_count=15, OMIM='', no_hdr0=''),
  12936 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12936, CurrentID=0, Status='live', Symbol='Pcdha4', Aliases='Cnr1, Crnr1, R75250', description='protocadherin alpha 4', other_designations='PCDH-alpha-4|cadherin-related neuronal receptor 1', map_location='18 B2-B3', chromosome='18', genomic_nucleotide_accession_version='NC_000084.6', start_position_on_the_genomic_accession=36952689, end_position_on_the_genomic_accession=37187657, orientation='plus', exon_count=4, OMIM='', no_hdr0=''),
  12937 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12937, CurrentID=0, Status='live', Symbol='Pcdha6', Aliases='CNR, Cnr2, Crnr2', description='protocadherin alpha 6', other_designations='cadherin-related neuronal receptor 2', map_location='18 B2-B3', chromosome='18', genomic_nucleotide_accession_version='NC_000084.6', start_position_on_the_genomic_accession=36967756, end_position_on_the_genomic_accession=37187657, orientation='plus', exon_count=4, OMIM='', no_hdr0=''),
  12939 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12939, CurrentID=0, Status='live', Symbol='Pcdha7', Aliases='Cnr4, Crnr4', description='protocadherin alpha 7', other_designations='cadherin-related neuronal receptor 4', map_location='18 B2-B3', chromosome='18', genomic_nucleotide_accession_version='NC_000084.6', start_position_on_the_genomic_accession=36973924, end_position_on_the_genomic_accession=37187657, orientation='plus', exon_count=4, OMIM='', no_hdr0=''),
  12941 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12941, CurrentID=0, Status='live', Symbol='Pcdha5', Aliases='Cnr6, Crnr6', description='protocadherin alpha 5', other_designations='cadherin-related neuronal receptor 6', map_location='18 B2-B3', chromosome='18', genomic_nucleotide_accession_version='NC_000084.6', start_position_on_the_genomic_accession=36960440, end_position_on_the_genomic_accession=37187657, orientation='plus', exon_count=4, OMIM='', no_hdr0=''),
  12942 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12942, CurrentID=0, Status='live', Symbol='Pcdha11', Aliases='A830022B16Rik, Cnr7, Crnr7', description='protocadherin alpha 11', other_designations='cadherin-related neuronal receptor 7', map_location='18 B3', chromosome='18', genomic_nucleotide_accession_version='NC_000084.6', start_position_on_the_genomic_accession=37010858, end_position_on_the_genomic_accession=37187657, orientation='plus', exon_count=4, OMIM='', no_hdr0=''),
  12943 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12943, CurrentID=0, Status='live', Symbol='Pcdha10', Aliases='Cnr3, Cnr8, Crnr3, Crnr8, Pcdha14', description='protocadherin alpha 10', other_designations='PCDH-alpha-10|cadherin-related neuronal receptor 3|protocadherin alpha 14', map_location='18 B3', chromosome='18', genomic_nucleotide_accession_version='NC_000084.6', start_position_on_the_genomic_accession=37005320, end_position_on_the_genomic_accession=37187657, orientation='plus', exon_count=4, OMIM='', no_hdr0=''),
  12944 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12944, CurrentID=0, Status='live', Symbol='Crp', Aliases='AI255847', description='C-reactive protein, pentraxin-related', other_designations='C-reactive protein, petaxin related', map_location='1 80.13 cM', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=172698056, end_position_on_the_genomic_accession=172699966, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  12945 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12945, CurrentID=0, Status='live', Symbol='Dmbt1', Aliases='CRP, CRP-[a], CRP-[b], Crpd, DBMT1, gp300, p80', description='deleted in malignant brain tumors 1', other_designations='apactin|crp-ductin|deleted in malignant brain tumors 1 pseudogene|ebnerin|glycoprotein 300|hensin|mucin-like glycoprotein|muclin|vomeroglandin', map_location='7 F4', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=131032054, end_position_on_the_genomic_accession=131121628, orientation='plus', exon_count=51, OMIM='', no_hdr0=''),
  12946 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12946, CurrentID=0, Status='live', Symbol='Cr1l', Aliases='Crry, Mcp, mCRY', description='complement component (3b/4b) receptor 1-like', other_designations='complement receptor related protein|complement regulatory protein Crry|protein p65', map_location='1 98.43 cM', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=195098747, end_position_on_the_genomic_accession=195131570, orientation='minus', exon_count=11, OMIM='', no_hdr0=''),
  12947 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12947, CurrentID=0, Status='live', Symbol='Crry-ps', Aliases='Crrx, Mcp-ps, mCRX', description='complement receptor related protein, pseudogene', other_designations='', map_location='8 35.31 cM', chromosome='8', genomic_nucleotide_accession_version='NC_000074.6', start_position_on_the_genomic_accession=73612902, end_position_on_the_genomic_accession=73614459, orientation='minus', exon_count=0, OMIM='', no_hdr0=''),
  12948 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12948, CurrentID=0, Status='live', Symbol='crsp', Aliases='', description='cryptorchidism with white spotting, deletion region', other_designations='', map_location='', chromosome='5', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  12950 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12950, CurrentID=0, Status='live', Symbol='Hapln1', Aliases='BB099155, CLP, Crtl1, Crtl1l, LP, LP-1', description='hyaluronan and proteoglycan link protein 1', other_designations='cartilage link protein 1|cartilage linking protein 1|cartilage-link protein|cartilage-linking protein 1|link protein|proteoglycan link protein', map_location='13 45.5 cM', chromosome='13', genomic_nucleotide_accession_version='NC_000079.6', start_position_on_the_genomic_accession=89540529, end_position_on_the_genomic_accession=89611832, orientation='plus', exon_count=5, OMIM='', no_hdr0=''),
  12951 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12951, CurrentID=0, Status='live', Symbol='Crx', Aliases='Crx1', description='cone-rod homeobox', other_designations='cone-rod homeobox containing', map_location='7 8.6 cM', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=15865947, end_position_on_the_genomic_accession=15879955, orientation='minus', exon_count=5, OMIM='', no_hdr0=''),
  12952 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12952, CurrentID=0, Status='live', Symbol='Cry1', Aliases='AU020726, AU021000, Phll1', description='cryptochrome 1 (photolyase-like)', other_designations='', map_location='10 C', chromosome='10', genomic_nucleotide_accession_version='NC_000076.6', start_position_on_the_genomic_accession=85131700, end_position_on_the_genomic_accession=85185054, orientation='minus', exon_count=15, OMIM='', no_hdr0=''),
  12953 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12953, CurrentID=0, Status='live', Symbol='Cry2', Aliases='AV006279, D130054K12Rik', description='cryptochrome 2 (photolyase-like)', other_designations='', map_location='2 E', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=92403646, end_position_on_the_genomic_accession=92434069, orientation='minus', exon_count=12, OMIM='', no_hdr0=''),
  12954 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12954, CurrentID=0, Status='live', Symbol='Cryaa', Aliases='Acry-1, Crya-1, Crya1, DAcry-1, lop18', description='crystallin, alpha A', other_designations='alpha-crystallin|crystallin, alpha 1|lens opacity 18', map_location='17 A3-B', chromosome='17', genomic_nucleotide_accession_version='NC_000083.6', start_position_on_the_genomic_accession=31674348, end_position_on_the_genomic_accession=31681730, orientation='plus', exon_count=5, OMIM='', no_hdr0=''),
  12955 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12955, CurrentID=0, Status='live', Symbol='Cryab', Aliases='Crya-2, Crya2, HspB5, P23', description='crystallin, alpha B', other_designations='alpha B-crystallin|alpha(B)-crystallin|crystallin, alpha 2|heat shock protein CryAB|heat shock protein HspB5', map_location='9 27.75 cM', chromosome='9', genomic_nucleotide_accession_version='NC_000075.6', start_position_on_the_genomic_accession=50751325, end_position_on_the_genomic_accession=50756636, orientation='plus', exon_count=5, OMIM='', no_hdr0=''),
  12957 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12957, CurrentID=0, Status='live', Symbol='Cryba1', Aliases='BA3/A1, Cryb', description='crystallin, beta A1', other_designations='beta-A1-crystallin|beta-A3/A1-crystallin', map_location='11 B-C1', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=77718732, end_position_on_the_genomic_accession=77725781, orientation='minus', exon_count=6, OMIM='', no_hdr0=''),
  12958 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12958, CurrentID=0, Status='live', Symbol='Cryba2', Aliases='E130107M19Rik', description='crystallin, beta A2', other_designations='beta-A2 crystallin|betaA2-crystallin|lens structural protein', map_location='1 38.54 cM', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=74889934, end_position_on_the_genomic_accession=74898843, orientation='minus', exon_count=10, OMIM='', no_hdr0=''),
  12959 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12959, CurrentID=0, Status='live', Symbol='Cryba4', Aliases='', description='crystallin, beta A4', other_designations='beta-A4 crystallin', map_location='5 F', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=112246492, end_position_on_the_genomic_accession=112263555, orientation='minus', exon_count=9, OMIM='', no_hdr0=''),
  406176 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=406176, CurrentID=0, Status='live', Symbol='Olfr151', Aliases='M71, MOR171-2', description='olfactory receptor 151', other_designations='GA_x6K02T2PVTD-31408136-31407207|M71 odorant receptor|odorant receptor M71|olfactory receptor 171-2|olfactory receptor 7H', map_location='9 A4', chromosome='9', genomic_nucleotide_accession_version='NC_000075.6', start_position_on_the_genomic_accession=37729977, end_position_on_the_genomic_accession=37731061, orientation='minus', exon_count=1, OMIM='', no_hdr0=''),
  12961 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12961, CurrentID=0, Status='live', Symbol='Crybb2', Aliases='Cryb-2', description='crystallin, beta B2', other_designations='beta-crystallin Bp', map_location='5 55.38 cM', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=113058258, end_position_on_the_genomic_accession=113070111, orientation='minus', exon_count=10, OMIM='', no_hdr0=''),
  12962 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12962, CurrentID=0, Status='live', Symbol='Crybb3', Aliases='AI852419', description='crystallin, beta B3', other_designations='beta-B3 crystallin', map_location='5 55.38 cM', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=113075839, end_position_on_the_genomic_accession=113082233, orientation='minus', exon_count=6, OMIM='', no_hdr0=''),
  12964 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12964, CurrentID=0, Status='live', Symbol='Cryga', Aliases='Cryg-4, DGcry-4', description='crystallin, gamma A', other_designations='gamma-A-crystallin|gamma-crystallin 4', map_location='1 32.84 cM', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=65100389, end_position_on_the_genomic_accession=65103363, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  12965 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12965, CurrentID=0, Status='live', Symbol='Crygb', Aliases='Cryg-3, DGcry-3, Nop', description='crystallin, gamma B', other_designations='gamma-B-crystallin|gamma-crystallin 3|gammaB-crystallin|nuclear opacity', map_location='1 32.82 cM', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=65080222, end_position_on_the_genomic_accession=65082290, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  12966 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12966, CurrentID=0, Status='live', Symbol='Crygc', Aliases='Cryg-5', description='crystallin, gamma C', other_designations='gamma-C-crystallin|gammaC-crystallin', map_location='1 32.81 cM', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=65071525, end_position_on_the_genomic_accession=65073532, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  12967 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12967, CurrentID=0, Status='live', Symbol='Crygd', Aliases='Aey4, Cryg-1, DGcry-1, Lop12', description='crystallin, gamma D', other_designations='gamma-D-crystallin|gamma-crystallin 1|lens opacity 12', map_location='1 32.8 cM', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=65061838, end_position_on_the_genomic_accession=65063440, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  12968 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12968, CurrentID=0, Status='live', Symbol='Cryge', Aliases='Cryg-2, Cryg-6, DGcry-2, Elo', description='crystallin, gamma E', other_designations='eye lens obsolescence|gamma-E-crystallin', map_location='1 32.8 cM', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=65048555, end_position_on_the_genomic_accession=65057116, orientation='minus', exon_count=4, OMIM='', no_hdr0=''),
  12969 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12969, CurrentID=0, Status='live', Symbol='Crygf', Aliases='3110001K11Rik, Cryg-2, DGcry-2, Len-2', description='crystallin, gamma F', other_designations='gamma-F-crystallin', map_location='1 33.31 cM', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=65926522, end_position_on_the_genomic_accession=65928304, orientation='plus', exon_count=3, OMIM='', no_hdr0=''),
  406186 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=406186, CurrentID=0, Status='live', Symbol='Olfr142', Aliases='K20, MOR227-2', description='olfactory receptor 142', other_designations='GA_x6K02T2Q125-51607674-51606757|olfactory receptor 227-2|olfactory receptor 4C', map_location='2 E1', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=90252069, end_position_on_the_genomic_accession=90252986, orientation='minus', exon_count=1, OMIM='', no_hdr0=''),
  12971 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12971, CurrentID=0, Status='live', Symbol='Crym', Aliases='', description='crystallin, mu', other_designations='NADP-regulated thyroid-hormone-binding protein|mu-crystallin homolog|thiomorpholine-carboxylate dehydrogenase', map_location='7 64.47 cM', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=120186384, end_position_on_the_genomic_accession=120201988, orientation='minus', exon_count=8, OMIM='', no_hdr0=''),
  12972 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12972, CurrentID=0, Status='live', Symbol='Cryz', Aliases='Sez9', description='crystallin, zeta', other_designations='NADPH:quinone reductase|quinone reductase|zeta-crystallin', map_location='3 H4', chromosome='3', genomic_nucleotide_accession_version='NC_000069.6', start_position_on_the_genomic_accession=154596711, end_position_on_the_genomic_accession=154623182, orientation='plus', exon_count=9, OMIM='', no_hdr0=''),
  12973 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12973, CurrentID=0, Status='live', Symbol='crz', Aliases='', description='control of early proliferation of Trypanosoma cruzi', other_designations='', map_location='', chromosome='', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  12974 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12974, CurrentID=0, Status='live', Symbol='Cs', Aliases='2610511A05Rik, 9030605P22Rik, Ahl4, BB234005, Cis', description='citrate synthase', other_designations='citrate (Si)-synthase', map_location='10 D3', chromosome='10', genomic_nucleotide_accession_version='NC_000076.6', start_position_on_the_genomic_accession=128337832, end_position_on_the_genomic_accession=128362479, orientation='plus', exon_count=11, OMIM='', no_hdr0=''),
  12977 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12977, CurrentID=0, Status='live', Symbol='Csf1', Aliases='C87615, Csfm, MCSF, op', description='colony stimulating factor 1 (macrophage)', other_designations='osteopetrosis', map_location='3 F3', chromosome='3', genomic_nucleotide_accession_version='NC_000069.6', start_position_on_the_genomic_accession=107741048, end_position_on_the_genomic_accession=107760469, orientation='minus', exon_count=10, OMIM='', no_hdr0=''),
  12978 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12978, CurrentID=0, Status='live', Symbol='Csf1r', Aliases='AI323359, CD115, CSF-1R, Csfmr, Fim-2, Fms, M-CSF-R, M-CSFR', description='colony stimulating factor 1 receptor', other_designations='CSF-1 receptor|CSF-1-R|c-fms|proto-oncogene c-Fms|proto-oncogene fms', map_location='18 D', chromosome='18', genomic_nucleotide_accession_version='NC_000084.6', start_position_on_the_genomic_accession=61096808, end_position_on_the_genomic_accession=61131139, orientation='plus', exon_count=25, OMIM='', no_hdr0=''),
  12981 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12981, CurrentID=0, Status='live', Symbol='Csf2', Aliases='Csfgm, GMCSF, Gm-CSf, MGI-IGM', description='colony stimulating factor 2 (granulocyte-macrophage)', other_designations='CSF|colony-stimulating factor|granulocyte-macrophage colony stimulating factor 2|put. GM-CSF', map_location='11 32.13 cM', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=54247270, end_position_on_the_genomic_accession=54249899, orientation='minus', exon_count=5, OMIM='', no_hdr0=''),
  12982 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12982, CurrentID=0, Status='live', Symbol='Csf2ra', Aliases='CD116, Csfgmra, GM-CSF-Ra, GM-CSFR', description='colony stimulating factor 2 receptor, alpha, low-affinity (granulocyte-macrophage)', other_designations='GM-CSF-R-alpha|GM-CSFRalpha|GMCSFR-alpha|GMR-alpha|colony stimulating factor 2 receptor alpha chain', map_location='19 56.89 cM', chromosome='19', genomic_nucleotide_accession_version='NC_000085.6', start_position_on_the_genomic_accession=61224401, end_position_on_the_genomic_accession=61228465, orientation='minus', exon_count=12, OMIM='', no_hdr0=''),
  12983 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12983, CurrentID=0, Status='live', Symbol='Csf2rb', Aliases='AI848964, AIC2B, Bc, CDw1311, Csfgmrb, Il3r, Il3rb, Il3rb1, Il5rb, Csf2rb', description='colony stimulating factor 2 receptor, beta, low-affinity (granulocyte-macrophage)', other_designations='CD131 antigen|GM-CSF/IL-3/IL-5 receptor common beta subunit|GM-CSF/IL-3/IL-5 receptor common beta-chain|beta c|colony stimulating factor 2 receptor, beta 1, low-affinity (granulocyte-macrophage)|common beta chain', map_location='15 37.36 cM', chromosome='15', genomic_nucleotide_accession_version='NC_000081.6', start_position_on_the_genomic_accession=78325797, end_position_on_the_genomic_accession=78351001, orientation='plus', exon_count=15, OMIM='', no_hdr0=''),
  12984 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12984, CurrentID=0, Status='live', Symbol='Csf2rb2', Aliases='AIC2A, BetaIl3, Bil3, Csfgmrb, Il3r, Il3rb, Il3rb2', description='colony stimulating factor 2 receptor, beta 2, low-affinity (granulocyte-macrophage)', other_designations='IL-3 receptor class 2 subunit beta|IL-3R class 2 subunit beta|colony-stimulating factor 2 receptor subunit beta-2|interleukin-3 receptor class II beta chain', map_location='15 37.22 cM', chromosome='15', genomic_nucleotide_accession_version='NC_000081.6', start_position_on_the_genomic_accession=78282507, end_position_on_the_genomic_accession=78305721, orientation='minus', exon_count=14, OMIM='', no_hdr0=''),
  12985 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12985, CurrentID=0, Status='live', Symbol='Csf3', Aliases='Csfg, G-CSF, MGI-IG', description='colony stimulating factor 3 (granulocyte)', other_designations='', map_location='11 62.45 cM', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=98701095, end_position_on_the_genomic_accession=98704836, orientation='plus', exon_count=4, OMIM='', no_hdr0=''),
  12986 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12986, CurrentID=0, Status='live', Symbol='Csf3r', Aliases='Cd114, Csfgr, G-CSF-R, G-CSFR', description='colony stimulating factor 3 receptor (granulocyte)', other_designations='G-CSF receptor', map_location='4 59.77 cM', chromosome='4', genomic_nucleotide_accession_version='NC_000070.6', start_position_on_the_genomic_accession=126023441, end_position_on_the_genomic_accession=126044975, orientation='plus', exon_count=20, OMIM='', no_hdr0=''),
  12988 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12988, CurrentID=0, Status='live', Symbol='Csk', Aliases='AW212630, p50CSK', description='c-src tyrosine kinase', other_designations='C-Src kinase|protein-tyrosine kinase MPK-2', map_location='9 31.18 cM', chromosome='9', genomic_nucleotide_accession_version='NC_000075.6', start_position_on_the_genomic_accession=57626646, end_position_on_the_genomic_accession=57653626, orientation='minus', exon_count=17, OMIM='', no_hdr0=''),
  12990 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12990, CurrentID=0, Status='live', Symbol='Csn1s1', Aliases='AA959832, AW212882, Csna', description='casein alpha s1', other_designations='alpha-casein', map_location='5 43.56 cM', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=87666208, end_position_on_the_genomic_accession=87682578, orientation='plus', exon_count=34, OMIM='', no_hdr0=''),
  12991 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12991, CurrentID=0, Status='live', Symbol='Csn2', Aliases='Csnb', description='casein beta', other_designations='', map_location='5 43.56 cM', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=87692619, end_position_on_the_genomic_accession=87699429, orientation='minus', exon_count=9, OMIM='', no_hdr0=''),
  12992 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12992, CurrentID=0, Status='live', Symbol='Csn1s2b', Aliases='AW987150, Csnd, Csne', description='casein alpha s2-like B', other_designations='casein delta|epsilon-casein', map_location='5 43.56 cM', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=87808121, end_position_on_the_genomic_accession=87824421, orientation='plus', exon_count=12, OMIM='', no_hdr0=''),
  12993 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12993, CurrentID=0, Status='live', Symbol='Csn1s2a', Aliases='Csng, PP22', description='casein alpha s2-like A', other_designations='gamma casein|milk protein', map_location='5 43.56 cM', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=87774567, end_position_on_the_genomic_accession=87788797, orientation='plus', exon_count=14, OMIM='', no_hdr0=''),
  12994 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12994, CurrentID=0, Status='live', Symbol='Csn3', Aliases='AW208918, CSN10, Csnk', description='casein kappa', other_designations='', map_location='5 43.56 cM', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=87925575, end_position_on_the_genomic_accession=87932545, orientation='plus', exon_count=6, OMIM='', no_hdr0=''),
  12995 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=12995, CurrentID=0, Status='live', Symbol='Csnk2a1', Aliases='Csnk2a1-rs4', description='casein kinase 2, alpha 1 polypeptide', other_designations='CK II alpha|casein kinase II, alpha 1 polypeptide|casein kinase II, alpha 1 related sequence 4', map_location='2 G3', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=152226731, end_position_on_the_genomic_accession=152281856, orientation='plus', exon_count=14, OMIM='', no_hdr0=''),
  668357 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=668357, CurrentID=0, Status='live', Symbol='Dmrtc1c2', Aliases='', description='DMRT-like family C1c2', other_designations='', map_location='X D', chromosome='X', genomic_nucleotide_accession_version='NC_000086.7', start_position_on_the_genomic_accession=102847636, end_position_on_the_genomic_accession=102857207, orientation='minus', exon_count=12, OMIM='', no_hdr0=''),
  668359 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=668359, CurrentID=0, Status='live', Symbol='Gm9125', Aliases='EG668359', description='predicted gene 9125', other_designations='', map_location='3', chromosome='3', genomic_nucleotide_accession_version='NC_000069.6', start_position_on_the_genomic_accession=94047981, end_position_on_the_genomic_accession=94054885, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  13000 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=13000, CurrentID=0, Status='live', Symbol='Csnk2a2', Aliases='1110035J23Rik, C77789, CK2', description='casein kinase 2, alpha prime polypeptide', other_designations="CK II alpha'|casein kinase II, alpha 2, polypeptide", map_location='8 47.12 cM', chromosome='8', genomic_nucleotide_accession_version='NC_000074.6', start_position_on_the_genomic_accession=95446096, end_position_on_the_genomic_accession=95488904, orientation='minus', exon_count=12, OMIM='', no_hdr0=''),
  406217 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=406217, CurrentID=0, Status='live', Symbol='Bex4', Aliases='', description='brain expressed gene 4', other_designations='BEX1-like protein 1|brain expressed X-linked 4|brain expressed, X-linked 4|brain-expressed X-linked protein 4 homolog', map_location='X', chromosome='X', genomic_nucleotide_accession_version='NC_000086.7', start_position_on_the_genomic_accession=136139045, end_position_on_the_genomic_accession=136140439, orientation='plus', exon_count=3, OMIM='', no_hdr0=''),
  406218 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=406218, CurrentID=0, Status='live', Symbol='Panx2', Aliases='', description='pannexin 2', other_designations='', map_location='15', chromosome='15', genomic_nucleotide_accession_version='NC_000081.6', start_position_on_the_genomic_accession=89059726, end_position_on_the_genomic_accession=89073571, orientation='plus', exon_count=4, OMIM='', no_hdr0=''),
  406219 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=406219, CurrentID=0, Status='live', Symbol='Krt83', Aliases='Krt2-25, Krt87', description='keratin 83', other_designations='K83|keratin complex 2, basic, gene 25|keratin-83|krt83|type II hair keratin Hb3|type-II keratin Kb23|type-II keratin Kb25', map_location='15 F2', chromosome='15', genomic_nucleotide_accession_version='NC_000081.6', start_position_on_the_genomic_accession=101431490, end_position_on_the_genomic_accession=101438804, orientation='minus', exon_count=9, OMIM='', no_hdr0=''),
  406220 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=406220, CurrentID=0, Status='live', Symbol='Krt77', Aliases='4732484G22Rik, K1emb, Krt239, mK1b', description='keratin 77', other_designations='CK-1B|K77|cytokeratin-1B|embryonic type II keratin 1|embryonic type II keratin-1|keratin 1b|keratin complex 2, basic, gene 39|keratin-77|type II keratin Kb39|type-II intermediate filament protein|type-II keratin Kb39', map_location='15 F3', chromosome='15', genomic_nucleotide_accession_version='NC_000081.6', start_position_on_the_genomic_accession=101858731, end_position_on_the_genomic_accession=101869706, orientation='minus', exon_count=10, OMIM='', no_hdr0=''),
  406221 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=406221, CurrentID=0, Status='live', Symbol='Krt40', Aliases='CK-40, K40', description='keratin 40', other_designations='cytokeratin-40|keratin-40', map_location='11', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=99537485, end_position_on_the_genomic_accession=99543203, orientation='minus', exon_count=7, OMIM='', no_hdr0=''),
  13006 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=13006, CurrentID=0, Status='live', Symbol='Smc3', Aliases='Bamacan, Cspg6, HCAP, Mmip1, SMC-3, SmcD', description='structural maintenance of chromosomes 3', other_designations='SMC protein 3|basement membrane-associated chondroitin proteoglycan|chondroitin sulfate proteoglycan 6|chromosome segregation protein SmcD|mad member-interacting protein 1|structural maintenace of chromosomes 3', map_location='19 D2', chromosome='19', genomic_nucleotide_accession_version='NC_000085.6', start_position_on_the_genomic_accession=53600396, end_position_on_the_genomic_accession=53645831, orientation='plus', exon_count=29, OMIM='', no_hdr0=''),
  13007 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=13007, CurrentID=0, Status='live', Symbol='Csrp1', Aliases='AA408841, AA959891, AW545626, CRP1, Csrp', description='cysteine and glycine-rich protein 1', other_designations='CRP|cysteine rich protein 1|cysteine-rich protein 1', map_location='1 E4', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=135729197, end_position_on_the_genomic_accession=135752229, orientation='plus', exon_count=6, OMIM='', no_hdr0=''),
  13008 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=13008, CurrentID=0, Status='live', Symbol='Csrp2', Aliases='AW551867, Crp2, SmLim', description='cysteine and glycine-rich protein 2', other_designations='DLP-1|cysteine-rich protein 2|double LIM protein 1', map_location='10 D1', chromosome='10', genomic_nucleotide_accession_version='NC_000076.6', start_position_on_the_genomic_accession=110920176, end_position_on_the_genomic_accession=110939514, orientation='plus', exon_count=6, OMIM='', no_hdr0=''),
  13009 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=13009, CurrentID=0, Status='live', Symbol='Csrp3', Aliases='CRP3, MLP, MMLP', description='cysteine and glycine-rich protein 3', other_designations='LIM domain protein, cardiac|cardiac LIM protein|cysteine-rich protein 3|muscle LIM protein', map_location='7 B4', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=48830398, end_position_on_the_genomic_accession=48848051, orientation='minus', exon_count=7, OMIM='', no_hdr0=''),
  13010 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=13010, CurrentID=0, Status='live', Symbol='Cst3', Aliases='CysC', description='cystatin C', other_designations='cystatin 3|cystatin-3', map_location='2 73.6 cM', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=148871732, end_position_on_the_genomic_accession=148875468, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  13011 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=13011, CurrentID=0, Status='live', Symbol='Cst7', Aliases='Cmap', description='cystatin F (leukocystatin)', other_designations='cystatin 7|cystatin-7|cystatin-like metastasis-associated protein', map_location='2 G1-G3', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=150570415, end_position_on_the_genomic_accession=150578944, orientation='plus', exon_count=4, OMIM='', no_hdr0=''),
  13012 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=13012, CurrentID=0, Status='live', Symbol='Cst8', Aliases='Cres, Cst-rs1', description='cystatin 8 (cystatin-related epididymal spermatogenic)', other_designations='cystatin-related epididymal spermatogenic protein|cystatin-related epididymal-specific protein', map_location='2 73.56 cM', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=148798839, end_position_on_the_genomic_accession=148805596, orientation='plus', exon_count=6, OMIM='', no_hdr0=''),
  13013 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=13013, CurrentID=0, Status='live', Symbol='Cst9', Aliases='M12, cresp, testatin', description='cystatin 9', other_designations='', map_location='2 H1', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=148835147, end_position_on_the_genomic_accession=148838737, orientation='plus', exon_count=3, OMIM='', no_hdr0=''),
  13014 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=13014, CurrentID=0, Status='live', Symbol='Cstb', Aliases='AA960480, Stfb', description='cystatin B', other_designations='stefin-B', map_location='10 39.72 cM', chromosome='10', genomic_nucleotide_accession_version='NC_000076.6', start_position_on_the_genomic_accession=78425670, end_position_on_the_genomic_accession=78427622, orientation='plus', exon_count=3, OMIM='', no_hdr0=''),
  13016 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=13016, CurrentID=0, Status='live', Symbol='Ctbp1', Aliases='BARS, CtBP3/BARS, D4S115h, D5H4S115, D5H4S115E', description='C-terminal binding protein 1', other_designations='', map_location='5 17.52 cM', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=33247723, end_position_on_the_genomic_accession=33275004, orientation='minus', exon_count=10, OMIM='', no_hdr0=''),
  13017 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=13017, CurrentID=0, Status='live', Symbol='Ctbp2', Aliases='AA407280, D7Ertd45e, Gtrgeo6, Ribeye', description='C-terminal binding protein 2', other_designations='gene trap ROSA b-geo 6', map_location='7 76.32 cM', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=132986417, end_position_on_the_genomic_accession=133123877, orientation='minus', exon_count=17, OMIM='', no_hdr0=''),
  13018 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=13018, CurrentID=0, Status='live', Symbol='Ctcf', Aliases='AW108038', description='CCCTC-binding factor', other_designations='11-zinc finger protein|CTCFL paralog', map_location='8 D3', chromosome='8', genomic_nucleotide_accession_version='NC_000074.6', start_position_on_the_genomic_accession=105636538, end_position_on_the_genomic_accession=105682922, orientation='plus', exon_count=14, OMIM='', no_hdr0=''),
  13019 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=13019, CurrentID=0, Status='live', Symbol='Ctf1', Aliases='CT-1', description='cardiotrophin 1', other_designations='', map_location='7 F3', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=127712704, end_position_on_the_genomic_accession=127718188, orientation='plus', exon_count=4, OMIM='', no_hdr0=''),
  668381 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=668381, CurrentID=0, Status='live', Symbol='Scgb1b12', Aliases='Abpa12, EG668381, Gm9140', description='secretoglobin, family 1B, member 12', other_designations='', map_location='7 B1', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=32334188, end_position_on_the_genomic_accession=32335501, orientation='plus', exon_count=3, OMIM='', no_hdr0=''),
  13024 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=13024, CurrentID=0, Status='live', Symbol='Ctla2a', Aliases='Ctla-2a', description='cytotoxic T lymphocyte-associated protein 2 alpha', other_designations='cytotoxic T lymphocyte-associated protein 2-alpha|cytotoxic T-lymphocyte-associated protein 2-alpha', map_location='13 32.56 cM', chromosome='13', genomic_nucleotide_accession_version='NC_000079.6', start_position_on_the_genomic_accession=60934155, end_position_on_the_genomic_accession=60936625, orientation='minus', exon_count=5, OMIM='', no_hdr0=''),
  13025 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=13025, CurrentID=0, Status='live', Symbol='Ctla2b', Aliases='AW545568, Ctla-2b', description='cytotoxic T lymphocyte-associated protein 2 beta', other_designations='cytotoxic T lymphocyte-associated protein 2-beta|cytotoxic T-lymphocyte-associated protein 2-beta', map_location='13', chromosome='13', genomic_nucleotide_accession_version='NC_000079.6', start_position_on_the_genomic_accession=60895351, end_position_on_the_genomic_accession=60897932, orientation='minus', exon_count=4, OMIM='', no_hdr0=''),
  13026 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=13026, CurrentID=0, Status='live', Symbol='Pcyt1a', Aliases='CTalpha, Cctalpha, Ctpct, Cttalpha', description='phosphate cytidylyltransferase 1, choline, alpha isoform', other_designations='CCT A|CCT-alpha|CT A|CTP phosphocholine cytidylyl transferase|CTP:phosphocholine cytidylyltransferase A|CTP:phosphocholine cytidylyltransferase alpha|phosphorylcholine transferase A', map_location='16 22.69 cM', chromosome='16', genomic_nucleotide_accession_version='NC_000082.6', start_position_on_the_genomic_accession=32430921, end_position_on_the_genomic_accession=32475065, orientation='plus', exon_count=9, OMIM='', no_hdr0=''),
  13030 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=13030, CurrentID=0, Status='live', Symbol='Ctsb', Aliases='CB', description='cathepsin B', other_designations='cathepsin B1', map_location='14 33.24 cM', chromosome='14', genomic_nucleotide_accession_version='NC_000080.6', start_position_on_the_genomic_accession=63122462, end_position_on_the_genomic_accession=63145923, orientation='plus', exon_count=10, OMIM='', no_hdr0=''),
  13032 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=13032, CurrentID=0, Status='live', Symbol='Ctsc', Aliases='AI047818, CatC, DPP1, DPPI', description='cathepsin C', other_designations='cathepsin J|dipeptidyl peptidase I|dipeptidyl transferase', map_location='7 D3-E1.1', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=88278023, end_position_on_the_genomic_accession=88310875, orientation='plus', exon_count=10, OMIM='', no_hdr0=''),
  13033 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=13033, CurrentID=0, Status='live', Symbol='Ctsd', Aliases='CD, CatD', description='cathepsin D', other_designations='', map_location='7 F5', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=142375916, end_position_on_the_genomic_accession=142387870, orientation='minus', exon_count=9, OMIM='', no_hdr0=''),
  13034 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=13034, CurrentID=0, Status='live', Symbol='Ctse', Aliases='A430072O03Rik, C920004C08Rik, CE, CatE', description='cathepsin E', other_designations='', map_location='1 F', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=131638314, end_position_on_the_genomic_accession=131675507, orientation='plus', exon_count=10, OMIM='', no_hdr0=''),
  13035 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=13035, CurrentID=0, Status='live', Symbol='Ctsg', Aliases='CatG, VSP', description='cathepsin G', other_designations='vimentin-specific protease', map_location='14 28.19 cM', chromosome='14', genomic_nucleotide_accession_version='NC_000080.6', start_position_on_the_genomic_accession=56099881, end_position_on_the_genomic_accession=56102574, orientation='minus', exon_count=5, OMIM='', no_hdr0=''),
  13036 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=13036, CurrentID=0, Status='live', Symbol='Ctsh', Aliases='AL022844', description='cathepsin H', other_designations='Cat H|cathepsin B3|cathepsin BA', map_location='9 47.4 cM', chromosome='9', genomic_nucleotide_accession_version='NC_000075.6', start_position_on_the_genomic_accession=90054267, end_position_on_the_genomic_accession=90076095, orientation='plus', exon_count=13, OMIM='', no_hdr0=''),
  13038 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=13038, CurrentID=0, Status='live', Symbol='Ctsk', Aliases='AI323530, MMS10-Q, Ms10q, catK', description='cathepsin K', other_designations='Cat K', map_location='3 40.74 cM', chromosome='3', genomic_nucleotide_accession_version='NC_000069.6', start_position_on_the_genomic_accession=95499210, end_position_on_the_genomic_accession=95509387, orientation='plus', exon_count=9, OMIM='', no_hdr0=''),
  13039 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=13039, CurrentID=0, Status='live', Symbol='Ctsl', Aliases='1190035F06Rik, CatL1, MEP, fs, nkt, Ctsl', description='cathepsin L', other_designations='Cat L|major excreted protein|p39 cysteine proteinase', map_location='13 33.26 cM', chromosome='13', genomic_nucleotide_accession_version='NC_000079.6', start_position_on_the_genomic_accession=64363214, end_position_on_the_genomic_accession=64370883, orientation='minus', exon_count=10, OMIM='', no_hdr0=''),
  13040 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=13040, CurrentID=0, Status='live', Symbol='Ctss', Aliases='Cats', description='cathepsin S', other_designations='Cat S', map_location='3 40.74 cM', chromosome='3', genomic_nucleotide_accession_version='NC_000069.6', start_position_on_the_genomic_accession=95526786, end_position_on_the_genomic_accession=95556405, orientation='plus', exon_count=9, OMIM='', no_hdr0=''),
  13041 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=13041, CurrentID=0, Status='live', Symbol='Ctsw', Aliases='lymphopain', description='cathepsin W', other_designations='', map_location='19 A', chromosome='19', genomic_nucleotide_accession_version='NC_000085.6', start_position_on_the_genomic_accession=5465240, end_position_on_the_genomic_accession=5470387, orientation='minus', exon_count=10, OMIM='', no_hdr0=''),
  13043 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=13043, CurrentID=0, Status='live', Symbol='Cttn', Aliases='1110020L01Rik, Ems1', description='cortactin', other_designations='mammary tumor and squamous cell carcinoma associated (p80/85 src substrate)', map_location='7 F5', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=144435723, end_position_on_the_genomic_accession=144471004, orientation='minus', exon_count=19, OMIM='', no_hdr0=''),
  13046 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=13046, CurrentID=0, Status='live', Symbol='Celf1', Aliases='1600010O03Rik, AA407467, Brunol2, CUG-BP, CUG-BP1, CUGBP, Cugbp1, D2Wsu101e, HNAB50, NAB50', description='CUGBP, Elav-like family member 1', other_designations='50 kDa nuclear polyadenylated RNA-binding protein|CELF-1|CUG triplet repeat RNA-binding protein 1|CUG triplet repeat, RNA binding protein 1|CUG-BP- and ETR-3-like factor 1|EDEN-BP homolog|RNA-binding protein BRUNOL-2|brain protein F41|bruno-like protein 2|deadenylation factor CUG-BP|deadenylation factor EDEN-BP|embryo deadenylation element-binding protein homolog', map_location='2 50.44 cM', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=90940387, end_position_on_the_genomic_accession=91019497, orientation='plus', exon_count=16, OMIM='', no_hdr0=''),
  13047 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=13047, CurrentID=0, Status='live', Symbol='Cux1', Aliases='CDP, Cutl1, Cux, Cux-1', description='cut-like homeobox 1', other_designations='CCAAT displacement protein|Cux/CDP homeoprotein|cut-like 1|homeobox protein cut-like 1|homeobox protein cux-1', map_location='5 75.96 cM', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=136248135, end_position_on_the_genomic_accession=136567490, orientation='minus', exon_count=34, OMIM='', no_hdr0=''),
  13048 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=13048, CurrentID=0, Status='live', Symbol='Cux2', Aliases='1700051K22Rik, Cutl2, Cux-2, ENSMUSG00000072641', description='cut-like homeobox 2', other_designations='homeobox protein Cux-2', map_location='5 62.02 cM', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=121857962, end_position_on_the_genomic_accession=122050562, orientation='minus', exon_count=31, OMIM='', no_hdr0=''),
  13049 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=13049, CurrentID=0, Status='live', Symbol='cw', Aliases='thd', description='curly whiskers', other_designations='tail hair depletion', map_location='', chromosome='9', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  13051 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=13051, CurrentID=0, Status='live', Symbol='Cx3cr1', Aliases='', description='chemokine (C-X3-C motif) receptor 1', other_designations='C-X3-C CKR-1|chemokine (C-X3-C) receptor 1|fractalkine receptor', map_location='9 F4', chromosome='9', genomic_nucleotide_accession_version='NC_000075.6', start_position_on_the_genomic_accession=120048683, end_position_on_the_genomic_accession=120068296, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  13052 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=13052, CurrentID=0, Status='live', Symbol='Cxadr', Aliases='2610206D03Rik, AU016810, AW553441, CAR, MCAR, MCVADR', description='coxsackie virus and adenovirus receptor', other_designations='', map_location='16 C', chromosome='16', genomic_nucleotide_accession_version='NC_000082.6', start_position_on_the_genomic_accession=78301460, end_position_on_the_genomic_accession=78359785, orientation='plus', exon_count=9, OMIM='', no_hdr0=''),
  13056 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=13056, CurrentID=0, Status='live', Symbol='Cyb561', Aliases='', description='cytochrome b-561', other_designations='', map_location='11 68.81 cM', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=105933702, end_position_on_the_genomic_accession=105945114, orientation='minus', exon_count=10, OMIM='', no_hdr0=''),
  13057 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=13057, CurrentID=0, Status='live', Symbol='Cyba', Aliases='b558, nmf333, p22-phox, p22phox', description='cytochrome b-245, alpha polypeptide', other_designations='cytochrome b(558) alpha chain|cytochrome b558 subunit alpha|cytochrome beta-558|neutrophil cytochrome b 22 kDa polypeptide|p22 phagocyte B-cytochrome|p22 phox|superoxide-generating NADPH oxidase light chain subunit', map_location='8 E1', chromosome='8', genomic_nucleotide_accession_version='NC_000074.6', start_position_on_the_genomic_accession=122424771, end_position_on_the_genomic_accession=122432965, orientation='minus', exon_count=6, OMIM='', no_hdr0=''),
  13058 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=13058, CurrentID=0, Status='live', Symbol='Cybb', Aliases='C88302, CGD91-phox, Cgd, Cyd, Nox2, gp91-1, gp91phox', description='cytochrome b-245, beta polypeptide', other_designations='NADPH oxidase 2|cytochrome b558 subunit beta|heme-binding membrane glycoprotein gp91phox|neutrophil cytochrome b 91 kDa polypeptide|p22 phagocyte B-cytochrome', map_location='X A1.1', chromosome='X', genomic_nucleotide_accession_version='NC_000086.7', start_position_on_the_genomic_accession=9435254, end_position_on_the_genomic_accession=9487766, orientation='minus', exon_count=14, OMIM='', no_hdr0=''),
  668419 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=668419, CurrentID=0, Status='live', Symbol='Scgb2b33', Aliases='Abpbg33, EG668419, Gm9161', description='secretoglobin, family 2B, member 33', other_designations='', map_location='7 B1', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=33111669, end_position_on_the_genomic_accession=33113458, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  13063 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=13063, CurrentID=0, Status='live', Symbol='Cycs', Aliases='', description='cytochrome c, somatic', other_designations='', map_location='6 24.32 cM', chromosome='6', genomic_nucleotide_accession_version='NC_000072.6', start_position_on_the_genomic_accession=50562563, end_position_on_the_genomic_accession=50566474, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  13067 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=13067, CurrentID=0, Status='live', Symbol='Cyct', Aliases='T-Cc', description='cytochrome c, testis', other_designations='', map_location='2 44.94 cM', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=76353942, end_position_on_the_genomic_accession=76360453, orientation='minus', exon_count=5, OMIM='', no_hdr0=''),
  13070 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=13070, CurrentID=0, Status='live', Symbol='Cyp11a1', Aliases='Cyp11a, Cypxia1, D9Ertd411e, P450scc, Scc, cscc', description='cytochrome P450, family 11, subfamily a, polypeptide 1', other_designations='cholesterol desmolase|cholesterol side chain cleavage|cytochrome P450 11A1|cytochrome P450 side-chain cleavage enzyme|cytochrome P450(scc)|cytochrome P450, 11a, cholesterol side-chain cleavage', map_location='9 31.63 cM', chromosome='9', genomic_nucleotide_accession_version='NC_000075.6', start_position_on_the_genomic_accession=58015017, end_position_on_the_genomic_accession=58027023, orientation='plus', exon_count=9, OMIM='', no_hdr0=''),
  13072 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=13072, CurrentID=0, Status='live', Symbol='Cyp11b2', Aliases='Cpn2, Cyp11b, Cyp11b-2', description='cytochrome P450, family 11, subfamily b, polypeptide 2', other_designations='CYPXIB2|aldosterone synthase|cytochrome P450C11|steroid 11-beta-hydroxylase|steroid-11-beta-hydroxylase', map_location='15 34.29 cM', chromosome='15', genomic_nucleotide_accession_version='NC_000081.6', start_position_on_the_genomic_accession=74851010, end_position_on_the_genomic_accession=74856318, orientation='minus', exon_count=9, OMIM='', no_hdr0=''),
  668433 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=668433, CurrentID=0, Status='live', Symbol='4930544D05Rik', Aliases='', description='RIKEN cDNA 4930544D05 gene', other_designations='', map_location='11 B3', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=70615834, end_position_on_the_genomic_accession=70616892, orientation='plus', exon_count=4, OMIM='', no_hdr0=''),
  13074 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=13074, CurrentID=0, Status='live', Symbol='Cyp17a1', Aliases='Cyp17, p450c17', description='cytochrome P450, family 17, subfamily a, polypeptide 1', other_designations='17-alpha-hydroxyprogesterone aldolase|CYPXVII|cytochrome P450 17A1|cytochrome P450, 17|cytochrome P450, 17a1|cytochrome P450-C17|cytochrome P450c17|steroid 17-alpha hydroxylase', map_location='19 38.97 cM', chromosome='19', genomic_nucleotide_accession_version='NC_000085.6', start_position_on_the_genomic_accession=46667165, end_position_on_the_genomic_accession=46673000, orientation='minus', exon_count=8, OMIM='', no_hdr0=''),
  13075 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=13075, CurrentID=0, Status='live', Symbol='Cyp19a1', Aliases='Ar, ArKO, Cyp19, Int-5, Int5, p450arom', description='cytochrome P450, family 19, subfamily a, polypeptide 1', other_designations='CYPXIX|cytochrome P-450AROM|cytochrome P450 19A1|cytochrome P450, 19, aromatase|estrogen synthase', map_location='9 29.49 cM', chromosome='9', genomic_nucleotide_accession_version='NC_000075.6', start_position_on_the_genomic_accession=54165862, end_position_on_the_genomic_accession=54229532, orientation='minus', exon_count=15, OMIM='', no_hdr0=''),
  13076 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=13076, CurrentID=0, Status='live', Symbol='Cyp1a1', Aliases='AHH, AHRR, CP11, Cyp1a2, P450-1', description='cytochrome P450, family 1, subfamily a, polypeptide 1', other_designations='CYPIA1|aromatic compound inducible|cytochrome P450 family 1 subfamily a polypeptide 2|cytochrome P450 subfamily I, polypeptide 1|cytochrome P450, 1a1, aromatic compound inducible|cytochrome P450-P1', map_location='9 31.34 cM', chromosome='9', genomic_nucleotide_accession_version='NC_000075.6', start_position_on_the_genomic_accession=57687928, end_position_on_the_genomic_accession=57703824, orientation='plus', exon_count=8, OMIM='', no_hdr0=''),
  13077 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=13077, CurrentID=0, Status='live', Symbol='Cyp1a2', Aliases='CP12, Cyp1a1, P450-3', description='cytochrome P450, family 1, subfamily a, polypeptide 2', other_designations='CYPIA2|aromatic compound inducible|cholesterol 25-hydroxylase|cytochrome P450 family 1 subfamily a polypeptide 1|cytochrome P450, 1a2, aromatic compound inducible|cytochrome P450-P2|cytochrome P450-P3', map_location='9 31.3 cM', chromosome='9', genomic_nucleotide_accession_version='NC_000075.6', start_position_on_the_genomic_accession=57676937, end_position_on_the_genomic_accession=57683655, orientation='minus', exon_count=7, OMIM='', no_hdr0=''),
  13078 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=13078, CurrentID=0, Status='live', Symbol='Cyp1b1', Aliases='CP1B, P4501b1', description='cytochrome P450, family 1, subfamily b, polypeptide 1', other_designations='CYPIB1|benz[a]anthracene inducible|cytochrome P450, 1b1, benz[a]anthracene inducible|cytochrome P450CMEF|cytochrome P450EF', map_location='17 E3', chromosome='17', genomic_nucleotide_accession_version='NC_000083.6', start_position_on_the_genomic_accession=79696282, end_position_on_the_genomic_accession=79715065, orientation='minus', exon_count=8, OMIM='', no_hdr0=''),
  13079 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=13079, CurrentID=0, Status='live', Symbol='Cyp21a1', Aliases='21-OH, 21OH, 21OHA, 21OHB, CYP21OH-A, Cyp21, Cyp21-ps1, Cyp21B, Cyp21a2-ps, Cyp21a2ps, Oh21-1, Oh21-2', description='cytochrome P450, family 21, subfamily a, polypeptide 1', other_designations='21-OHase|21-hydroxylase|cytochrome P-450|cytochrome P-450c21|cytochrome P450 21|cytochrome P450 XXI|cytochrome P450 hydroxylase A|cytochrome P450, 21, pseudogene|cytochrome P450, 21, steroid 21 hydroxylase|cytochrome P450, family 21, subfamily a, polypeptide 2, pseudogene|cytochrome P450-C21|steroid 21 hydroxylase', map_location='17 18.36 cM', chromosome='17', genomic_nucleotide_accession_version='NC_000083.6', start_position_on_the_genomic_accession=34801348, end_position_on_the_genomic_accession=34804426, orientation='minus', exon_count=10, OMIM='', no_hdr0=''),
  13081 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=13081, CurrentID=0, Status='live', Symbol='Cyp24a1', Aliases='24-OHase, CP24, Cyp24', description='cytochrome P450, family 24, subfamily a, polypeptide 1', other_designations='25-hydroxyvitamin D-24-hydroxylase|cytochrome P450 24A1|cytochrome P450, 24|cytochrome P450, 24a1|cytochrome P450-CC24|vitamin D(3) 24-hydroxylase', map_location='2 91.91 cM', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=170482965, end_position_on_the_genomic_accession=170497138, orientation='minus', exon_count=12, OMIM='', no_hdr0=''),
  13082 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=13082, CurrentID=0, Status='live', Symbol='Cyp26a1', Aliases='Cyp26, P450RA, P450RAI, RAH', description='cytochrome P450, family 26, subfamily a, polypeptide 1', other_designations='cytochrome P450, 26, retinoic acid A1|cytochrome P450RAI|retinoic acid 4-hydroxylase|retinoic acid hydrolase|retinoic acid-metabolizing cytochrome', map_location='19 C2-C3', chromosome='19', genomic_nucleotide_accession_version='NC_000085.6', start_position_on_the_genomic_accession=37697808, end_position_on_the_genomic_accession=37701536, orientation='plus', exon_count=7, OMIM='', no_hdr0=''),
  13085 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=13085, CurrentID=0, Status='live', Symbol='Cyp2a12', Aliases='', description='cytochrome P450, family 2, subfamily a, polypeptide 12', other_designations='CYPIIA12|cytochrome P450, 2a12|steroid hormones 7-alpha-hydroxylase|testosterone 7-alpha-hydroxylase', map_location='7 A3', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=27029090, end_position_on_the_genomic_accession=27036818, orientation='plus', exon_count=9, OMIM='', no_hdr0=''),
  13086 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=13086, CurrentID=0, Status='live', Symbol='Cyp2a4', Aliases='AI893559, Cyp15a1, D7Ucla4', description='cytochrome P450, family 2, subfamily a, polypeptide 4', other_designations='CYPIIA4|cytochrome P450, 2a4|cytochrome P450-15-alpha|cytochrome P450-IIA3.1|testosterone 15-alpha-hydroxylase|testosterone 15alpha-hydroxylase', map_location='7 14.39 cM', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=26307192, end_position_on_the_genomic_accession=26315088, orientation='plus', exon_count=9, OMIM='', no_hdr0=''),
  13087 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=13087, CurrentID=0, Status='live', Symbol='Cyp2a5', Aliases='CYPIIA5, Coh, Cyp15a2', description='cytochrome P450, family 2, subfamily a, polypeptide 5', other_designations='coumarin 7-hydroxylase|cytochrome P450, 2a5|cytochrome P450-15-COH|cytochrome P450-IIA3.2', map_location='7 15.54 cM', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=26835339, end_position_on_the_genomic_accession=26843264, orientation='plus', exon_count=9, OMIM='', no_hdr0=''),
  13088 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=13088, CurrentID=0, Status='live', Symbol='Cyp2b10', Aliases='Cyp2b, Cyp2b20, p16', description='cytochrome P450, family 2, subfamily b, polypeptide 10', other_designations='CYPIIB10|CYPIIB20|P24|cytochrome P450 2B20|cytochrome P450 clone PF3/46|cytochrome P450, 2b10, phenobarbitol inducible, type b|cytochrome P450, 2b20|cytochrome P450, family 2, subfamily b, polypeptide 20|cytochrome P450-16-alpha|phenobarbitol inducible, type b|testosterone 16-alpha hydroxylase', map_location='7 14.11 cM', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=25897658, end_position_on_the_genomic_accession=25926624, orientation='plus', exon_count=9, OMIM='', no_hdr0=''),
  13089 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=13089, CurrentID=0, Status='live', Symbol='Cyp2b13', Aliases='', description='cytochrome P450, family 2, subfamily b, polypeptide 13', other_designations='cytochrome P450, 2b13, phenobarbitol inducible, type c|phenobarbital inducible, type c', map_location='7 14.11 cM', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=26061344, end_position_on_the_genomic_accession=26096197, orientation='plus', exon_count=15, OMIM='', no_hdr0=''),
  13090 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=13090, CurrentID=0, Status='live', Symbol='Cyp2b19', Aliases='CYPIIB19', description='cytochrome P450, family 2, subfamily b, polypeptide 19', other_designations='cytochrome P450, 2b19', map_location='7 15.44 cM', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=26757187, end_position_on_the_genomic_accession=26772630, orientation='plus', exon_count=9, OMIM='', no_hdr0=''),
  13094 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=13094, CurrentID=0, Status='live', Symbol='Cyp2b9', Aliases='Cyp2b', description='cytochrome P450, family 2, subfamily b, polypeptide 9', other_designations='16alphaoh-a|CYPIIB9|cytochrome P450 clone PF26|cytochrome P450, 2b9, phenobarbitol inducible, type a|cytochrome P450-16-alpha|phenobarbitol inducible, type a|testosterone 16-alpha hydroxylase', map_location='7 14.11 cM', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=26173339, end_position_on_the_genomic_accession=26210661, orientation='plus', exon_count=11, OMIM='', no_hdr0=''),
  13095 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=13095, CurrentID=0, Status='live', Symbol='Cyp2c29', Aliases='AHOH, AHOHase, AI159681, AI196010, Ah-2, Ahh-1, Cyp2c, P450-2C', description='cytochrome P450, family 2, subfamily c, polypeptide 29', other_designations='CYPIIC29|aldehyde oxygenase|cytochrome P-450 MUT-2|cytochrome P450, 2c29', map_location='19 D2', chromosome='19', genomic_nucleotide_accession_version='NC_000085.6', start_position_on_the_genomic_accession=39287044, end_position_on_the_genomic_accession=39330713, orientation='plus', exon_count=9, OMIM='', no_hdr0=''),
  13096 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=13096, CurrentID=0, Status='live', Symbol='Cyp2c37', Aliases='', description='cytochrome P450, family 2. subfamily c, polypeptide 37', other_designations='CYPIIC37|cytochrome P450, 2c37', map_location='19 C3', chromosome='19', genomic_nucleotide_accession_version='NC_000085.6', start_position_on_the_genomic_accession=39992424, end_position_on_the_genomic_accession=40012243, orientation='plus', exon_count=9, OMIM='', no_hdr0=''),
  13097 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=13097, CurrentID=0, Status='live', Symbol='Cyp2c38', Aliases='', description='cytochrome P450, family 2, subfamily c, polypeptide 38', other_designations='CYPIIC38|cytochrome P450, 2c38', map_location='19 C3', chromosome='19', genomic_nucleotide_accession_version='NC_000085.6', start_position_on_the_genomic_accession=39389556, end_position_on_the_genomic_accession=39463089, orientation='minus', exon_count=10, OMIM='', no_hdr0=''),
  13098 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=13098, CurrentID=0, Status='live', Symbol='Cyp2c39', Aliases='CYPIIC39', description='cytochrome P450, family 2, subfamily c, polypeptide 39', other_designations='cytochrome P450, 2c39', map_location='19 C3', chromosome='19', genomic_nucleotide_accession_version='NC_000085.6', start_position_on_the_genomic_accession=39510822, end_position_on_the_genomic_accession=39568529, orientation='plus', exon_count=9, OMIM='', no_hdr0=''),
  13099 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=13099, CurrentID=0, Status='live', Symbol='Cyp2c40', Aliases='AI265721, AI662255', description='cytochrome P450, family 2, subfamily c, polypeptide 40', other_designations='CYPIIC40|cytochrome P450, 2c40', map_location='19 C3', chromosome='19', genomic_nucleotide_accession_version='NC_000085.6', start_position_on_the_genomic_accession=39767073, end_position_on_the_genomic_accession=39812814, orientation='minus', exon_count=9, OMIM='', no_hdr0=''),
  13101 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=13101, CurrentID=0, Status='live', Symbol='Cyp2d10', Aliases='AI303445, Cyp2d, P450-2D', description='cytochrome P450, family 2, subfamily d, polypeptide 10', other_designations='CYPIID10|cytochrome P450, 2d10|cytochrome P450-16-alpha|cytochrome P450CB|testosterone 16-alpha hydroxylase', map_location='15 38.58 cM', chromosome='15', genomic_nucleotide_accession_version='NC_000081.6', start_position_on_the_genomic_accession=82402845, end_position_on_the_genomic_accession=82407208, orientation='minus', exon_count=9, OMIM='', no_hdr0=''),
  13105 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=13105, CurrentID=0, Status='live', Symbol='Cyp2d9', Aliases='Cyp2d, P450-2D', description='cytochrome P450, family 2, subfamily d, polypeptide 9', other_designations='CYPIID9|cytochrome P450, 2d9|cytochrome P450-16-alpha|cytochrome P450CA|testosterone 16-alpha hydroxylase|testosterone 16alpha-hydroxylase', map_location='15 38.6 cM', chromosome='15', genomic_nucleotide_accession_version='NC_000081.6', start_position_on_the_genomic_accession=82452377, end_position_on_the_genomic_accession=82456827, orientation='plus', exon_count=9, OMIM='', no_hdr0=''),
  13106 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=13106, CurrentID=0, Status='live', Symbol='Cyp2e1', Aliases='Cyp2e', description='cytochrome P450, family 2, subfamily e, polypeptide 1', other_designations='4-nitrophenol 2-hydroxylase|CYPIIE1|cytochrome P450, 2e1, ethanol inducible|cytochrome P450-ALC|cytochrome P450-J', map_location='7 85.94 cM', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=140763832, end_position_on_the_genomic_accession=140774981, orientation='plus', exon_count=9, OMIM='', no_hdr0=''),
  13107 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=13107, CurrentID=0, Status='live', Symbol='Cyp2f2', Aliases='Cyp2f', description='cytochrome P450, family 2, subfamily f, polypeptide 2', other_designations='CYPIIF2|cytochrome P450, 2f2|cytochrome P450-NAH-2|naphthalene dehydrogenase|naphthalene hydroxylase', map_location='7 A3', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=27119955, end_position_on_the_genomic_accession=27133660, orientation='plus', exon_count=10, OMIM='', no_hdr0=''),
  13108 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=13108, CurrentID=0, Status='live', Symbol='Cyp2g1', Aliases='', description='cytochrome P450, family 2, subfamily g, polypeptide 1', other_designations='cytochrome P450, 2g1', map_location='7 A3', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=26808927, end_position_on_the_genomic_accession=26821197, orientation='plus', exon_count=9, OMIM='', no_hdr0=''),
  13109 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=13109, CurrentID=0, Status='live', Symbol='Cyp2j5', Aliases='', description='cytochrome P450, family 2, subfamily j, polypeptide 5', other_designations='CYPIIJ5|arachidonic acid epoxygenase|cytochrome P450, 2j5', map_location='4 44.71 cM', chromosome='4', genomic_nucleotide_accession_version='NC_000070.6', start_position_on_the_genomic_accession=96627432, end_position_on_the_genomic_accession=96664170, orientation='minus', exon_count=9, OMIM='', no_hdr0=''),
  13110 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=13110, CurrentID=0, Status='live', Symbol='Cyp2j6', Aliases='', description='cytochrome P450, family 2, subfamily j, polypeptide 6', other_designations='CYPIIJ6|arachidonic acid epoxygenase|cytochrome P450, 2j6', map_location='4 44.62 cM', chromosome='4', genomic_nucleotide_accession_version='NC_000070.6', start_position_on_the_genomic_accession=96516138, end_position_on_the_genomic_accession=96560835, orientation='minus', exon_count=13, OMIM='', no_hdr0=''),
  13112 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=13112, CurrentID=0, Status='live', Symbol='Cyp3a11', Aliases='AI256190, Cyp3a, IIIAm1, Pcn', description='cytochrome P450, family 3, subfamily a, polypeptide 11', other_designations='CYPIIIA11|cytochrome P-450IIIAM1|cytochrome P-450UT|cytochrome P450, steroid inducible 3a11|steroid inducible', map_location='5 85.17 cM', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=145854607, end_position_on_the_genomic_accession=145879854, orientation='minus', exon_count=13, OMIM='', no_hdr0=''),
  13113 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=13113, CurrentID=0, Status='live', Symbol='Cyp3a13', Aliases='IIIAm2', description='cytochrome P450, family 3, subfamily a, polypeptide 13', other_designations='CYPIIIA13|cytochrome P450, steroid inducible 3a13', map_location='5 76.89 cM', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=137892933, end_position_on_the_genomic_accession=137921619, orientation='minus', exon_count=13, OMIM='', no_hdr0=''),
  13114 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=13114, CurrentID=0, Status='live', Symbol='Cyp3a16', Aliases='', description='cytochrome P450, family 3, subfamily a, polypeptide 16', other_designations='CYPIIIA16|cytochrome P450, 3a16', map_location='5 85.17 cM', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=145436309, end_position_on_the_genomic_accession=145469737, orientation='minus', exon_count=14, OMIM='', no_hdr0=''),
  13115 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=13115, CurrentID=0, Status='live', Symbol='Cyp27b1', Aliases='Cp2b, Cyp1, Cyp27b, Cyp40, P450c1, Pddr, Vdd1, Vddr, VddrI, Vdr', description='cytochrome P450, family 27, subfamily b, polypeptide 1', other_designations='1alpha(OH)ase|25(OH)D 1alpha-hydroxylase|25-OHD-1 alpha-hydroxylase|25-hydroxyvitamin D(3) 1-alpha-hydroxylase|25-hydroxyvitamin D-1 alpha hydroxylase, mitochondrial precursor (25-OHD-1 alpha-hydroxylase) (25-hydroxyvitamin D3 1-alpha-hydroxylase) (VD3 1A hydroxylase) (P450C1 alpha) (P450VD1-alpha)|25-hydroxyvitamin D3 1alpha-hydroxylase|P450VD1alpha|VD3 1A hydroxylase|calcidiol 1-monooxygenase|cytochrome P450 subfamily XXVIIB polypeptide 1|cytochrome P450, 27b1|cytochrome P450, 40 (25-hydroxyvitamin D3 1 alpha-hydroxylase)|cytochrome P450C1 alpha|cytochrome P450VD1-alpha|cytochrome p450 27B1', map_location='10 D3', chromosome='10', genomic_nucleotide_accession_version='NC_000076.6', start_position_on_the_genomic_accession=127048246, end_position_on_the_genomic_accession=127053422, orientation='plus', exon_count=9, OMIM='', no_hdr0=''),
  13116 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=13116, CurrentID=0, Status='live', Symbol='Cyp46a1', Aliases='Cyp46', description='cytochrome P450, family 46, subfamily a, polypeptide 1', other_designations='CH24H|cholestrol 24-hydroxylase|cytochrome P450 46A1|cytochrome P450, 46 (cholesterol 24-hydroxylase)|cytochrome P450, 46a1 (cholesterol 24-hydroxylase)', map_location='12 F2', chromosome='12', genomic_nucleotide_accession_version='NC_000078.6', start_position_on_the_genomic_accession=108334261, end_position_on_the_genomic_accession=108362248, orientation='plus', exon_count=15, OMIM='', no_hdr0=''),
  13117 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=13117, CurrentID=0, Status='live', Symbol='Cyp4a10', Aliases='AI647584, Cyp4a, D4Rp1, RP1', description='cytochrome P450, family 4, subfamily a, polypeptide 10', other_designations='CYPIVA10|cyp4a10|cytochrome P450, 4a10|cytochrome P450-LA-omega 1|cytochrome P452|lauric acid omega-hydroxylase|long-chain fatty acid omega-monooxygenase', map_location='4 53.05 cM', chromosome='4', genomic_nucleotide_accession_version='NC_000070.6', start_position_on_the_genomic_accession=115518287, end_position_on_the_genomic_accession=115533649, orientation='plus', exon_count=13, OMIM='', no_hdr0=''),
  13118 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=13118, CurrentID=0, Status='live', Symbol='Cyp4a12b', Aliases='BC060945, Cyp4a12', description='cytochrome P450, family 4, subfamily a, polypeptide 12B', other_designations='cytochrome P450, family 4, subfamily a, polypeptide 12', map_location='4 D1', chromosome='4', genomic_nucleotide_accession_version='NC_000070.6', start_position_on_the_genomic_accession=115411624, end_position_on_the_genomic_accession=115439034, orientation='plus', exon_count=12, OMIM='', no_hdr0=''),
  13119 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=13119, CurrentID=0, Status='live', Symbol='Cyp4a14', Aliases='AI314743', description='cytochrome P450, family 4, subfamily a, polypeptide 14', other_designations='CYPIVA14|cyp4a14|cytochrome P450, 4a14|cytochrome P450-LA-omega 3|lauric acid omega-hydroxylase 3|long-chain fatty acid omega-monooxygenase', map_location='4 53.04 cM', chromosome='4', genomic_nucleotide_accession_version='NC_000070.6', start_position_on_the_genomic_accession=115486200, end_position_on_the_genomic_accession=115496159, orientation='minus', exon_count=13, OMIM='', no_hdr0=''),
  13120 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=13120, CurrentID=0, Status='live', Symbol='Cyp4b1', Aliases='', description='cytochrome P450, family 4, subfamily b, polypeptide 1', other_designations='CYPIVB1|cytochrome P450, subfamily IV B, polypeptide 1', map_location='4 53.06 cM', chromosome='4', genomic_nucleotide_accession_version='NC_000070.6', start_position_on_the_genomic_accession=115624728, end_position_on_the_genomic_accession=115647705, orientation='minus', exon_count=12, OMIM='', no_hdr0=''),
  13121 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=13121, CurrentID=0, Status='live', Symbol='Cyp51', Aliases='AI426508, CYPLIa1, Ldm, P450-14DM, P450LI, Cyp51', description='cytochrome P450, family 51', other_designations='cytochrome P450 51A1|cytochrome P450, 51|cytochrome P450-14DM|cytochrome P45014DM|cytochrome P450LI|lanosterol 14-alpha-demethylase|sterol 14-alpha demethylase', map_location='5 A2', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=4080674, end_position_on_the_genomic_accession=4104697, orientation='minus', exon_count=10, OMIM='', no_hdr0=''),
  13122 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=13122, CurrentID=0, Status='live', Symbol='Cyp7a1', Aliases='', description='cytochrome P450, family 7, subfamily a, polypeptide 1', other_designations='CYPVII|cholesterol 7 alpha hydroxylase|cholesterol 7-alpha-hydroxylase|cytochrome P450 7A1|cytochrome P450, 7a1', map_location='4 A1', chromosome='4', genomic_nucleotide_accession_version='NC_000070.6', start_position_on_the_genomic_accession=6264113, end_position_on_the_genomic_accession=6275631, orientation='minus', exon_count=7, OMIM='', no_hdr0=''),
  13123 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=13123, CurrentID=0, Status='live', Symbol='Cyp7b1', Aliases='AW261589, D3Ertd552e, hct-1', description='cytochrome P450, family 7, subfamily b, polypeptide 1', other_designations='cytochrome P450 7B1|cytochrome P450, 7b1|hippocampal transcript 1 protein|oxysterol 7-alpha-hydroxylase', map_location='3 4.98 cM', chromosome='3', genomic_nucleotide_accession_version='NC_000069.6', start_position_on_the_genomic_accession=18071950, end_position_on_the_genomic_accession=18243893, orientation='minus', exon_count=7, OMIM='', no_hdr0=''),
  13124 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=13124, CurrentID=0, Status='live', Symbol='Cyp8b1', Aliases='', description='cytochrome P450, family 8, subfamily b, polypeptide 1', other_designations='7-alpha-hydroxy-4-cholesten-3-one 12-alpha-hydroxylase|CYPVIIIB1|cytochrome P450 8B1|cytochrome P450, 8b1, sterol 12 alpha-hydrolase|sterol 12-alpha-hydrolase|sterol 12-alpha-hydroxylase', map_location='9 F4', chromosome='9', genomic_nucleotide_accession_version='NC_000075.6', start_position_on_the_genomic_accession=121914356, end_position_on_the_genomic_accession=121916305, orientation='minus', exon_count=1, OMIM='', no_hdr0=''),
  13131 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=13131, CurrentID=0, Status='live', Symbol='Dab1', Aliases='AI956902, C630028C02Rik, scm, scr, scrambler, yot', description='disabled 1', other_designations='yotari', map_location='4 47.79 cM', chromosome='4', genomic_nucleotide_accession_version='NC_000070.6', start_position_on_the_genomic_accession=103619546, end_position_on_the_genomic_accession=104744844, orientation='plus', exon_count=25, OMIM='', no_hdr0=''),
  13132 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=13132, CurrentID=0, Status='live', Symbol='Dab2', Aliases='5730435J12Rik, AA960054, AI957090, D15Wsu122e, D630005B22Rik, Doc-2, Doc2, p96', description='disabled 2, mitogen-responsive phosphoprotein', other_designations='adaptor molecule disabled-2|differentially expressed in ovarian carcinoma 2|mitogen-responsive phosphoprotein', map_location='15 2.15 cM', chromosome='15', genomic_nucleotide_accession_version='NC_000081.6', start_position_on_the_genomic_accession=6299788, end_position_on_the_genomic_accession=6440715, orientation='plus', exon_count=17, OMIM='', no_hdr0=''),
  13134 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=13134, CurrentID=0, Status='live', Symbol='Dach1', Aliases='Dac, Dach', description='dachshund 1 (Drosophila)', other_designations='', map_location='14 E3', chromosome='14', genomic_nucleotide_accession_version='NC_000080.6', start_position_on_the_genomic_accession=97786846, end_position_on_the_genomic_accession=98169765, orientation='minus', exon_count=12, OMIM='', no_hdr0=''),
  13135 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=13135, CurrentID=0, Status='live', Symbol='Dad1', Aliases='AI323713', description='defender against cell death 1', other_designations='DAD-1|oligosaccharyl transferase subunit DAD1', map_location='14 27.7 cM', chromosome='14', genomic_nucleotide_accession_version='NC_000080.6', start_position_on_the_genomic_accession=54235485, end_position_on_the_genomic_accession=54253929, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  13136 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=13136, CurrentID=0, Status='live', Symbol='Cd55', Aliases='Daf, Daf-GPI, Daf1, GPI-DAF', description='CD55 molecule, decay accelerating factor for complement', other_designations='CD55 antigen|Cromer blood group|GPI anchor addition signal|complement-glycosylphosphatidylinositol|decay accelerating factor 1', map_location='1 56.89 cM', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=130437196, end_position_on_the_genomic_accession=130463012, orientation='minus', exon_count=12, OMIM='', no_hdr0=''),
  13137 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=13137, CurrentID=0, Status='live', Symbol='Cd55b', Aliases='AI323748, Daf, Daf-TM, Daf2, TM-DAF', description='CD55 molecule, decay accelerating factor for complement B', other_designations='complement-transmembrane|decay accelerating factor 2', map_location='1 56.89 cM', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=130388528, end_position_on_the_genomic_accession=130423037, orientation='minus', exon_count=11, OMIM='', no_hdr0=''),
  13138 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=13138, CurrentID=0, Status='live', Symbol='Dag1', Aliases='D9Wsu13e, DG, Dp427, Dp71', description='dystroglycan 1', other_designations='dystrophin associated glycoprotein 1', map_location='9 59.08 cM', chromosome='9', genomic_nucleotide_accession_version='NC_000075.6', start_position_on_the_genomic_accession=108204861, end_position_on_the_genomic_accession=108263958, orientation='minus', exon_count=6, OMIM='', no_hdr0=''),
  13139 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=13139, CurrentID=0, Status='live', Symbol='Dgka', Aliases='80kDa, AW146112, Dagk1', description='diacylglycerol kinase, alpha', other_designations='80 kDa diacylglycerol kinase|DAG kinase alpha|DGK-alpha|diacylglycerol kinase alpha Flt2-Pr2|diglyceride kinase alpha|truncated diacylglycerol kinase alpha Flt1-Pr1|truncated diacylglycerol kinase alpha Flt1-Pr2', map_location='10 77.14 cM', chromosome='10', genomic_nucleotide_accession_version='NC_000076.6', start_position_on_the_genomic_accession=128720134, end_position_on_the_genomic_accession=128748420, orientation='minus', exon_count=29, OMIM='', no_hdr0=''),
  668501 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=668501, CurrentID=0, Status='live', Symbol='Zfp507', Aliases='1810022O10Rik, A230056M16Rik, AL024009, AU021817, BB105092, Gm480, Znf507, mKIAA1084', description='zinc finger protein 507', other_designations='', map_location='7 B2', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=35772343, end_position_on_the_genomic_accession=35802989, orientation='minus', exon_count=8, OMIM='', no_hdr0=''),
  13142 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=13142, CurrentID=0, Status='live', Symbol='Dao', Aliases='AI987963, DAAO, DAMOX-1, Dao1, Dao', description='D-amino acid oxidase', other_designations='D-amino acid oxidase 1', map_location='5 55.93 cM', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=113999636, end_position_on_the_genomic_accession=114025675, orientation='plus', exon_count=13, OMIM='', no_hdr0=''),
  13143 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=13143, CurrentID=0, Status='live', Symbol='Dapk2', Aliases='', description='death-associated protein kinase 2', other_designations='DAP kinase 2|DAP-kinase-related protein 1 beta isoform|DRP-1|death-associated kinase 2', map_location='9 35.75 cM', chromosome='9', genomic_nucleotide_accession_version='NC_000075.6', start_position_on_the_genomic_accession=66158226, end_position_on_the_genomic_accession=66272242, orientation='plus', exon_count=12, OMIM='', no_hdr0=''),
  13144 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=13144, CurrentID=0, Status='live', Symbol='Dapk3', Aliases='ZIPK, dlk', description='death-associated protein kinase 3', other_designations='DAP kinase 3|DAP-like kinase|MYPT1 kinase|ZIP kinase|ZIP-kinase|death-associated kinase 3', map_location='10 39.72 cM', chromosome='10', genomic_nucleotide_accession_version='NC_000076.6', start_position_on_the_genomic_accession=81182987, end_position_on_the_genomic_accession=81193197, orientation='plus', exon_count=11, OMIM='', no_hdr0=''),
  67728 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=67728, CurrentID=0, Status='live', Symbol='Dph2', Aliases='9130020C19Rik, AI467389l2, Dph2', description='DPH2 homolog', other_designations='DPH2-like 2|diphthamide biosynthesis protein 2 homolog-like 2|diptheria toxin resistance protein required for diphthamide biosynthesis (Saccharomyces)-like 1|diptheria toxin resistance protein required for diphthamide biosynthesis (Saccharomyces)-like 2', map_location='4 D2.1', chromosome='4', genomic_nucleotide_accession_version='NC_000070.6', start_position_on_the_genomic_accession=117888643, end_position_on_the_genomic_accession=117892048, orientation='minus', exon_count=6, OMIM='', no_hdr0=''),
  13162 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=13162, CurrentID=0, Status='live', Symbol='Slc6a3', Aliases='DAT, Dat1', description='solute carrier family 6 (neurotransmitter transporter, dopamine), member 3', other_designations='DA transporter|dopamine transporter 1|solute carrier family 6 member 3', map_location='13 40.1 cM', chromosome='13', genomic_nucleotide_accession_version='NC_000079.6', start_position_on_the_genomic_accession=73535528, end_position_on_the_genomic_accession=73578672, orientation='plus', exon_count=15, OMIM='', no_hdr0=''),
  13163 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=13163, CurrentID=0, Status='live', Symbol='Daxx', Aliases='', description='Fas death domain-associated protein', other_designations='death-domain associated protein', map_location='17 17.98 cM', chromosome='17', genomic_nucleotide_accession_version='NC_000083.6', start_position_on_the_genomic_accession=33909381, end_position_on_the_genomic_accession=33915590, orientation='plus', exon_count=9, OMIM='', no_hdr0=''),
  13164 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=13164, CurrentID=0, Status='live', Symbol='Dazl', Aliases='Daz-like, Dazh1, Dazla, Tpx-2, Tpx2, Dazl', description='deleted in azoospermia-like', other_designations='DAZ-like autosomal|deleted in azoospermia-like 1', map_location='17 B1', chromosome='17', genomic_nucleotide_accession_version='NC_000083.6', start_position_on_the_genomic_accession=50279393, end_position_on_the_genomic_accession=50293620, orientation='minus', exon_count=12, OMIM='', no_hdr0=''),
  13166 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=13166, CurrentID=0, Status='live', Symbol='Dbh', Aliases='', description='dopamine beta hydroxylase', other_designations='dopamine beta-monooxygenase', map_location='2 19.29 cM', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=27165507, end_position_on_the_genomic_accession=27183204, orientation='plus', exon_count=12, OMIM='', no_hdr0=''),
  13167 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=13167, CurrentID=0, Status='live', Symbol='Dbi', Aliases='ACBD1, Acbp, EP, endozepine', description='diazepam binding inhibitor', other_designations='acyl-CoA binding protein|diazepam binding inhibitor, splice form 1b|diazepam-binding inhibitor', map_location='1 E2', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=120113280, end_position_on_the_genomic_accession=120121096, orientation='minus', exon_count=5, OMIM='', no_hdr0=''),
  13168 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=13168, CurrentID=0, Status='live', Symbol='Dbil5', Aliases='ELP', description='diazepam binding inhibitor-like 5', other_designations='endozepine-like peptide', map_location='11 B5', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=76217613, end_position_on_the_genomic_accession=76218665, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  13169 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=13169, CurrentID=0, Status='live', Symbol='Dbnl', Aliases='Abp1, SH3P7, mAbp1', description='drebrin-like', other_designations='SH3 domain-containing protein 7|actin-binding protein 1|dbnl', map_location='11 3.87 cM', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=5788483, end_position_on_the_genomic_accession=5800980, orientation='plus', exon_count=13, OMIM='', no_hdr0=''),
  13170 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=13170, CurrentID=0, Status='live', Symbol='Dbp', Aliases='', description='D site albumin promoter binding protein', other_designations='albumin D box-binding protein|albumin D-element-binding protein', map_location='7 29.45 cM', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=45705095, end_position_on_the_genomic_accession=45710203, orientation='plus', exon_count=5, OMIM='', no_hdr0=''),
  13171 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=13171, CurrentID=0, Status='live', Symbol='Dbt', Aliases='D3Wsu60e', description='dihydrolipoamide branched chain transacylase E2', other_designations='BCKAD E2|BCKAD-E2|BCKADE2|branched-chain alpha-keto acid dehydrogenase complex component E2|branched-chain alpha-ketoacid dehydrogenase, E2 subunit|dihydrolipoamide acetyltransferase component of branched-chain alpha-keto acid dehydrogenase complex|dihydrolipoyl transacylase|dihydrolipoyllysine-residue (2-methylpropanoyl)transferase|part of the BCKAD complex', map_location='3 50.37 cM', chromosome='3', genomic_nucleotide_accession_version='NC_000069.6', start_position_on_the_genomic_accession=116513079, end_position_on_the_genomic_accession=116549981, orientation='plus', exon_count=11, OMIM='', no_hdr0=''),
  13172 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=13172, CurrentID=0, Status='live', Symbol='Dbx1', Aliases='AI426026, Dbx', description='developing brain homeobox 1', other_designations='Mmox C|developing brain homeobox protein 1', map_location='7 31.44 cM', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=49631499, end_position_on_the_genomic_accession=49636835, orientation='minus', exon_count=4, OMIM='', no_hdr0=''),
  13175 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=13175, CurrentID=0, Status='live', Symbol='Dclk1', Aliases='1700113D08Rik, 2810480F11Rik, AI836758, Click-I, Cpg16, Dcamkl1, Dcl, Dclk, mKIAA0369', description='doublecortin-like kinase 1', other_designations='CLICK-I beta|doublecortin and calcium/calmodulin-dependent protein kinase-like 1|doublecortin-like and CAM kinase-like 1', map_location='3 D', chromosome='3', genomic_nucleotide_accession_version='NC_000069.6', start_position_on_the_genomic_accession=55242369, end_position_on_the_genomic_accession=55539068, orientation='plus', exon_count=21, OMIM='', no_hdr0=''),
  13176 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=13176, CurrentID=0, Status='live', Symbol='Dcc', Aliases='C030036D22Rik, Igdcc1', description='deleted in colorectal carcinoma', other_designations='tumor suppressor protein DCC', map_location='18 45.24 cM', chromosome='18', genomic_nucleotide_accession_version='NC_000084.6', start_position_on_the_genomic_accession=71253613, end_position_on_the_genomic_accession=72351231, orientation='minus', exon_count=29, OMIM='', no_hdr0=''),
  13177 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=13177, CurrentID=0, Status='live', Symbol='Eci1', Aliases='Dci, eci', description='enoyl-Coenzyme A delta isomerase 1', other_designations='3,2 trans-enoyl-Coenyme A isomerase|3,2-trans-enoyl-CoA isomerase, mitochondrial|D3,D2-enoyl-CoA isomerase|delta(3),Delta(2)-enoyl-CoA isomerase|dodecenoyl-CoA isomerase|dodecenoyl-Coenzyme A delta isomerase (3,2 trans-enoyl-Coenyme A isomerase)', map_location='17 A3.3', chromosome='17', genomic_nucleotide_accession_version='NC_000083.6', start_position_on_the_genomic_accession=24426683, end_position_on_the_genomic_accession=24439316, orientation='plus', exon_count=7, OMIM='', no_hdr0=''),
  13178 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=13178, CurrentID=0, Status='live', Symbol='Dck', Aliases='', description='deoxycytidine kinase', other_designations='', map_location='5 E2', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=88765013, end_position_on_the_genomic_accession=88783277, orientation='plus', exon_count=7, OMIM='', no_hdr0=''),
  13179 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=13179, CurrentID=0, Status='live', Symbol='Dcn', Aliases='DC, DSPG2, PG40, PGII, PGS2, SLRR1B', description='decorin', other_designations='bone proteoglycan II', map_location='10 50.27 cM', chromosome='10', genomic_nucleotide_accession_version='NC_000076.6', start_position_on_the_genomic_accession=97479500, end_position_on_the_genomic_accession=97518162, orientation='plus', exon_count=9, OMIM='', no_hdr0=''),
  13180 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=13180, CurrentID=0, Status='live', Symbol='Pcbd1', Aliases='Dcoh, Pcbd, Pcd, Phs', description='pterin 4 alpha carbinolamine dehydratase/dimerization cofactor of hepatocyte nuclear factor 1 alpha (TCF1) 1', other_designations='4-alpha-hydroxy-tetrahydropterin dehydratase|6-pyruvoyl-tetrahydropterin synthase/dimerization cofactor of hepatocyte nuclear factor 1 alpha (TCF1)|dimerization cofactor of HNF1|phenylalanine hydroxylase-stimulating protein|pterin carbinolamine dehydratase', map_location='10 32.14 cM', chromosome='10', genomic_nucleotide_accession_version='NC_000076.6', start_position_on_the_genomic_accession=61089331, end_position_on_the_genomic_accession=61094329, orientation='plus', exon_count=4, OMIM='', no_hdr0=''),
  668542 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=668542, CurrentID=0, Status='live', Symbol='Ighv1-62', Aliases='IgVH', description='immunoglobulin heavy variable V1-62', other_designations='anti-RNA antibody 564 immunoglobulin G heavy chain|anti-RNA antibody 564 immunoglobulin M heavy chain|immunoglobulin G2a gamma chain|immunoglobulin gamma-chain|low affinity anti-nucleosome binding monoclonal antibody|moderate affinity anti-nucleosome binding monoclonal antibody', map_location='12 F2', chromosome='12', genomic_nucleotide_accession_version='NC_000078.6', start_position_on_the_genomic_accession=115371986, end_position_on_the_genomic_accession=115372278, orientation='minus', exon_count=0, OMIM='', no_hdr0=''),
  67733 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=67733, CurrentID=0, Status='live', Symbol='Itgb3bp', Aliases='4930471O16Rik, AU022583', description='integrin beta 3 binding protein (beta3-endonexin)', other_designations='CENP-R|beta3-endonexin|nuclear receptor-interacting factor 3', map_location='4 C6', chromosome='4', genomic_nucleotide_accession_version='NC_000070.6', start_position_on_the_genomic_accession=99765402, end_position_on_the_genomic_accession=99830689, orientation='minus', exon_count=10, OMIM='', no_hdr0=''),
  13184 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=13184, CurrentID=0, Status='live', Symbol='Dcpp1', Aliases='BC005655, C86550, Dcpp, Dcpp-1, p20', description='demilune cell and parotid protein 1', other_designations='common salivary protein 1', map_location='17 12.11 cM', chromosome='17', genomic_nucleotide_accession_version='NC_000083.6', start_position_on_the_genomic_accession=23880876, end_position_on_the_genomic_accession=23882853, orientation='plus', exon_count=4, OMIM='', no_hdr0=''),
  13185 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=13185, CurrentID=0, Status='live', Symbol='Dscr3', Aliases='AW538125, Dcra', description='Down syndrome critical region gene 3', other_designations='Down syndrome critical region gene A|Down syndrome critical region protein A homolog', map_location='16 C4', chromosome='16', genomic_nucleotide_accession_version='NC_000082.6', start_position_on_the_genomic_accession=94497724, end_position_on_the_genomic_accession=94526629, orientation='minus', exon_count=8, OMIM='', no_hdr0=''),
  13190 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=13190, CurrentID=0, Status='live', Symbol='Dct', Aliases='DT, TRP-2, TRP2, Tyrp-2, Tyrp2, slaty, slt', description='dopachrome tautomerase', other_designations='L-dopachrome Delta-isomerase|SLATY locus protein|tyrosinase-related protein 2|tyrosinase-related protein-2', map_location='14 61.6 cM', chromosome='14', genomic_nucleotide_accession_version='NC_000080.6', start_position_on_the_genomic_accession=118012790, end_position_on_the_genomic_accession=118052323, orientation='minus', exon_count=10, OMIM='', no_hdr0=''),
  13191 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=13191, CurrentID=0, Status='live', Symbol='Dctn1', Aliases='AL022633, Glued, p150, p150<glued>', description='dynactin 1', other_designations='150 kDa dynein-associated polypeptide|DAP-150|DP-150|dynactin 1, retrograde axonal transport|p150-glued', map_location='6 35.94 cM', chromosome='6', genomic_nucleotide_accession_version='NC_000072.6', start_position_on_the_genomic_accession=83165915, end_position_on_the_genomic_accession=83200118, orientation='plus', exon_count=35, OMIM='', no_hdr0=''),
  13193 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=13193, CurrentID=0, Status='live', Symbol='Dcx', Aliases='Dbct', description='doublecortin', other_designations='doublecortex|doublin|lis-X|lissencephalin-X|lissencephaly, X-linked (doublecortin)', map_location='X F2', chromosome='X', genomic_nucleotide_accession_version='NC_000086.7', start_position_on_the_genomic_accession=143855842, end_position_on_the_genomic_accession=143933270, orientation='minus', exon_count=7, OMIM='', no_hdr0=''),
  13194 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=13194, CurrentID=0, Status='live', Symbol='Ddb1', Aliases='127kDa, AA408517, p127-Ddb1', description='damage specific DNA binding protein 1', other_designations='DDB p127 subunit|DNA repair protein|UV-damaged DNA-binding factor|damage-specific DNA-binding protein 1|damage-specific DNA-binding protein, DNA repair|damaged-DNA recognition protein 1', map_location='19 centromere', chromosome='19', genomic_nucleotide_accession_version='NC_000085.6', start_position_on_the_genomic_accession=10605568, end_position_on_the_genomic_accession=10629822, orientation='plus', exon_count=28, OMIM='', no_hdr0=''),
  13195 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=13195, CurrentID=0, Status='live', Symbol='Ddc', Aliases='Aadc', description='dopa decarboxylase', other_designations='', map_location='11 A1-A4', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=11814101, end_position_on_the_genomic_accession=11898144, orientation='minus', exon_count=19, OMIM='', no_hdr0=''),
  13196 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=13196, CurrentID=0, Status='live', Symbol='Asap1', Aliases='AV239055, DEF-1, Ddef1, PAP, mKIAA1249, s19', description='ArfGAP with SH3 domain, ankyrin repeat and PH domain1', other_designations='130 kDa phosphatidylinositol 4,5-biphosphate-dependent ARF1 GTPase-activating protein|130 kDa phosphatidylinositol 4,5-bisphosphate-dependent ARF1 GTPase-activating protein|ADP-ribosylation factor-directed GTPase-activating protein 1|ARF GTPase-activating protein 1|PIP2-dependent ARF1 GAP|development and differentiation-enhancing factor 1', map_location='15 D3', chromosome='15', genomic_nucleotide_accession_version='NC_000081.6', start_position_on_the_genomic_accession=64086840, end_position_on_the_genomic_accession=64382919, orientation='minus', exon_count=35, OMIM='', no_hdr0=''),
  13197 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=13197, CurrentID=0, Status='live', Symbol='Gadd45a', Aliases='AA545191, Ddit1, GADD45', description='growth arrest and DNA-damage-inducible 45 alpha', other_designations='DDIT-1|DNA damage-inducible transcript 1 protein|DNA-damage inducible transcript 1|DNA-damage-inducible transcript 1|Gadd45alpha|growth arrest and DNA-damage-inducible protein GADD45 alpha|growth arrest and DNA-damage-inducible, alpha', map_location='6 C1', chromosome='6', genomic_nucleotide_accession_version='NC_000072.6', start_position_on_the_genomic_accession=67035096, end_position_on_the_genomic_accession=67037407, orientation='minus', exon_count=4, OMIM='', no_hdr0=''),
  13198 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=13198, CurrentID=0, Status='live', Symbol='Ddit3', Aliases='CHOP-10, CHOP10, chop, gadd153', description='DNA-damage inducible transcript 3', other_designations='C/EBP homoologous protein 10|C/EBP zeta|CCAAT/enhancer-binding protein homologous protein|DDIT-3|c/EBP-homologous protein 10|growth arrest and DNA-damage-inducible protein GADD153', map_location='10 D3', chromosome='10', genomic_nucleotide_accession_version='NC_000076.6', start_position_on_the_genomic_accession=127290793, end_position_on_the_genomic_accession=127296288, orientation='plus', exon_count=5, OMIM='', no_hdr0=''),
  13199 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=13199, CurrentID=0, Status='live', Symbol='Ddn', Aliases='Gm748', description='dendrin', other_designations='', map_location='15 54.69 cM', chromosome='15', genomic_nucleotide_accession_version='NC_000081.6', start_position_on_the_genomic_accession=98803782, end_position_on_the_genomic_accession=98807925, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  13200 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=13200, CurrentID=0, Status='live', Symbol='Ddost', Aliases='', description='dolichyl-di-phosphooligosaccharide-protein glycotransferase', other_designations='DDOST 48 kDa subunit|oligosaccharyl transferase 48 kDa subunit', map_location='4 D3', chromosome='4', genomic_nucleotide_accession_version='NC_000070.6', start_position_on_the_genomic_accession=138304738, end_position_on_the_genomic_accession=138312611, orientation='plus', exon_count=11, OMIM='', no_hdr0=''),
  13202 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=13202, CurrentID=0, Status='live', Symbol='Ddt', Aliases='C78655', description='D-dopachrome tautomerase', other_designations='', map_location='10 38.58 cM', chromosome='10', genomic_nucleotide_accession_version='NC_000076.6', start_position_on_the_genomic_accession=75771233, end_position_on_the_genomic_accession=75773374, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  13204 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=13204, CurrentID=0, Status='live', Symbol='Dhx15', Aliases='DBP1, DEAH9, Ddx15, HRH2, mDEAH9', description='DEAH (Asp-Glu-Ala-His) box polypeptide 15', other_designations='DEAD/H (Asp-Glu-Ala-Asp/His) box polypeptide 15 (RNA helicase A)|DEAH box protein 15|putative pre-mRNA-splicing factor ATP-dependent RNA helicase DHX15', map_location='5 C1', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=52150203, end_position_on_the_genomic_accession=52190546, orientation='minus', exon_count=14, OMIM='', no_hdr0=''),
  13205 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=13205, CurrentID=0, Status='live', Symbol='Ddx3x', Aliases='D1Pas1-rs2, Ddx3, Fin14', description='DEAD/H (Asp-Glu-Ala-Asp/His) box polypeptide 3, X-linked', other_designations='D-E-A-D (aspartate-glutamate-alanine-aspartate) box polypeptide 3|D1Pas1-related sequence 2|DEAD (aspartate-glutamate-alanine-aspartate) box polypeptide 3|DEAD box RNA helicase DEAD3|DEAD box protein 3, X-chromosomal|DEAD-box protein 3 (DEAD-box RNA helicase DEAD3) (mDEAD3) (Embryonic RNA helicase) (D1PAS1 related sequence 2)|embryonic RNA helicase|fibroblast growth factor inducible 14|mDEAD3', map_location='X 8.17 cM', chromosome='X', genomic_nucleotide_accession_version='NC_000086.7', start_position_on_the_genomic_accession=13280496, end_position_on_the_genomic_accession=13293983, orientation='plus', exon_count=17, OMIM='', no_hdr0=''),
  13206 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=13206, CurrentID=0, Status='live', Symbol='Ddx4', Aliases='AV206478, Mvh, VASA', description='DEAD (Asp-Glu-Ala-Asp) box polypeptide 4', other_designations="D-E-A-D (aspartate-glutamate-alanine-aspartate) box polypeptide 4|DEAD (aspartate-glutamate-alanine-aspartate) box polypeptide 4|DEAD box polypeptide 4|DEAD box protein 4|DEAD/H (Asp-Glu-Ala-Asp/His) box polypeptide 4|mvh / m'vasa|vasa homolog", map_location='13 63.87 cM', chromosome='13', genomic_nucleotide_accession_version='NC_000079.6', start_position_on_the_genomic_accession=112598333, end_position_on_the_genomic_accession=112652629, orientation='minus', exon_count=23, OMIM='', no_hdr0=''),
  13207 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=13207, CurrentID=0, Status='live', Symbol='Ddx5', Aliases='2600009A06Rik, G17P1, HUMP68, Hlr1, p68', description='DEAD (Asp-Glu-Ala-Asp) box polypeptide 5', other_designations='D-E-A-D (aspartate-glutamate-alanine-aspartate) box polypeptide 5|DEAD (aspartate-glutamate-alanine-aspartate) box polypeptide 5|DEAD box RNA helicase DEAD1|DEAD box protein 5|DEAD/H (Asp-Glu-Ala-Asp/His) box polypeptide 5|RNA helicase p68|mDEAD1|p68 RNA helicase', map_location='11 E2', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=106780355, end_position_on_the_genomic_accession=106789268, orientation='minus', exon_count=15, OMIM='', no_hdr0=''),
  13209 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=13209, CurrentID=0, Status='live', Symbol='Ddx6', Aliases='1110001P04Rik, E230023J21Rik, HLR2, mRCK/P54, p54, rck', description='DEAD (Asp-Glu-Ala-Asp) box polypeptide 6', other_designations='ATP-dependent RNA helicase p54|D-E-A-D (aspartate-glutamate-alanine-aspartate) box polypeptide 6|DEAD (aspartate-glutamate-alanine-aspartate) box polypeptide 6|DEAD box protein 6|DEAD/H (Asp-Glu-Ala-Asp/His) box polypeptide 6|oncogene RCK homolog', map_location='9 B', chromosome='9', genomic_nucleotide_accession_version='NC_000075.6', start_position_on_the_genomic_accession=44602716, end_position_on_the_genomic_accession=44640731, orientation='plus', exon_count=16, OMIM='', no_hdr0=''),
  13211 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=13211, CurrentID=0, Status='live', Symbol='Dhx9', Aliases='AI326842, Ddx9, HEL-5, NDHII, RHA, mHEL-5', description='DEAH (Asp-Glu-Ala-His) box polypeptide 9', other_designations='D-E-A-D (aspartate-glutamate-alanine-aspartate) box polypeptide 9|DEAD (aspartate-glutamate-alanine-aspartate) box polypeptide 9|DEAD/H (Asp-Glu-Ala-Asp/His) box polypeptide 9|DEAH box protein 9|RNA helicase|leukophysin|nuclear DNA helicase II', map_location='1 65.37 cM', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=153455756, end_position_on_the_genomic_accession=153487686, orientation='minus', exon_count=29, OMIM='', no_hdr0=''),
  13214 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=13214, CurrentID=0, Status='live', Symbol='Defb1', Aliases='AW260221, BD-1', description='defensin beta 1', other_designations='', map_location='8 A4', chromosome='8', genomic_nucleotide_accession_version='NC_000074.6', start_position_on_the_genomic_accession=21776555, end_position_on_the_genomic_accession=21795185, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  13215 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=13215, CurrentID=0, Status='live', Symbol='Defb2', Aliases='BD-2', description='defensin beta 2', other_designations='', map_location='8 A4', chromosome='8', genomic_nucleotide_accession_version='NC_000074.6', start_position_on_the_genomic_accession=21839926, end_position_on_the_genomic_accession=21843482, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  13216 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=13216, CurrentID=0, Status='live', Symbol='Defa1', Aliases='Defcr, Defcr1', description='defensin, alpha 1', other_designations='cryptdin-1|defensin related cryptdin peptide 1|defensin-1|defensin-related cryptdin peptide', map_location='8', chromosome='8', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  13218 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=13218, CurrentID=0, Status='live', Symbol='Defa-rs1', Aliases='2010300L12Rik, 2010319H24Rik, CRS1C, CRS1C-2, CRS1C-4, CRS1C-5, Defcr-rs1', description='defensin, alpha, related sequence 1', other_designations='cryptdin-related protein 1C|defensin related sequence cryptdin peptide (paneth cells)|defensin-related cryptdin-related sequence 1|testis defensin', map_location='8 10.35 cM', chromosome='8', genomic_nucleotide_accession_version='NC_000074.6', start_position_on_the_genomic_accession=21325888, end_position_on_the_genomic_accession=21327020, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  13222 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=13222, CurrentID=0, Status='live', Symbol='Defa-rs2', Aliases='CRS4C, CRS4C-1, CRS4C1d, CRS4C1e, CRS4C1f, CRS4C1g, CRS4C1h, CRS4C1i, CRS4C1j, Defcr-rs2, Defcr-rs3', description='defensin, alpha, related sequence 2', other_designations='cryptdin related sequence peptide|cryptdin-related protein 4C-1|defensin related cryptdin, related sequence 2', map_location='', chromosome='8', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  13226 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=13226, CurrentID=0, Status='live', Symbol='Defa-rs7', Aliases='CRS4C-2, CRS4C2, CRS4C2b, CRS4C2c, CRS4C2d, CRS4C3a, CRS4C3a2, CRS4C3b, CRS4C3c, CRS4C3d, CRS4C3e, Defcr-rs7', description='defensin, alpha, related sequence 7', other_designations='cryptdin related sequence peptide|cryptdin-related protein 4C-2|defensin related cryptdin, related sequence 7|defensin-related cryptdin-related sequence 7', map_location='8 A2', chromosome='8', genomic_nucleotide_accession_version='NC_000074.6', start_position_on_the_genomic_accession=21191573, end_position_on_the_genomic_accession=21192550, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  13236 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=13236, CurrentID=0, Status='live', Symbol='Defa25', Aliases='Defcr-2, Defcr2, Defcr25', description='defensin, alpha, 25', other_designations='defensin related cryptdin 2|defensin-related cryptdin-25', map_location='8', chromosome='8', genomic_nucleotide_accession_version='NC_000074.6', start_position_on_the_genomic_accession=21084442, end_position_on_the_genomic_accession=21085285, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  13237 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=13237, CurrentID=0, Status='live', Symbol='Defa3', Aliases='Defa27, Defcr-3, Defcr3', description='defensin, alpha, 3', other_designations='defensin, alpha, 27|defensin-related cryptdin-3', map_location='8 A2', chromosome='8', genomic_nucleotide_accession_version='NC_000074.6', start_position_on_the_genomic_accession=21287409, end_position_on_the_genomic_accession=21288377, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  13238 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=13238, CurrentID=0, Status='live', Symbol='Defa4', Aliases='Crp4, Defa28, Defcr4', description='defensin, alpha, 4', other_designations='alpha-defensin, 28|defensin related cryptdin 4', map_location='8 A2', chromosome='8', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  13239 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=13239, CurrentID=0, Status='live', Symbol='Defa5', Aliases='Defa29, Defcr29, Defcr5', description='defensin, alpha, 5', other_designations='defensin, alpha, 29|defensin-related cryptdin-5', map_location='8 A2', chromosome='8', genomic_nucleotide_accession_version='NC_000074.6', start_position_on_the_genomic_accession=21297394, end_position_on_the_genomic_accession=21298375, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  13240 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=13240, CurrentID=0, Status='live', Symbol='Defa6', Aliases='Defcr6', description='defensin, alpha, 6', other_designations='alpha-defensin, 6|cryptdin-2|defensin related cryptdin 6|defensin-related cryptdin-6/12', map_location='8 A2', chromosome='8', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  13244 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=13244, CurrentID=0, Status='live', Symbol='Degs1', Aliases='AA536663, Degs, Des1, Mdes', description='delta(4)-desaturase, sphingolipid 1', other_designations='degenerative spermatocyte homolog 1|dihydroceramide desaturase', map_location='1 H5', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=182275770, end_position_on_the_genomic_accession=182282759, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  13259 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=13259, CurrentID=0, Status='live', Symbol='Del(10)1H', Aliases='Del1H', description='deletion, Chr 10, Harwell 1', other_designations='', map_location='', chromosome='10', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  13268 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=13268, CurrentID=0, Status='live', Symbol='Del(13)36H', Aliases='Del36H, Svea', description='deletion, Chr 13, Harwell 36', other_designations='Del(13)Svea36H|small with variable eye anomalies', map_location='', chromosome='13', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  668661 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=668661, CurrentID=0, Status='live', Symbol='2410002F23Rik', Aliases='', description='RIKEN cDNA 2410002F23 gene', other_designations='', map_location='7 B4', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=44246720, end_position_on_the_genomic_accession=44252319, orientation='plus', exon_count=8, OMIM='', no_hdr0=''),
  13321 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=13321, CurrentID=0, Status='live', Symbol='Del(7)Tyr<c-3H>-p', Aliases='D7Ssb3Hp, Del(7)Tyrc-3H-p, Tyr<c-3H>', description='deletion, Chr 7, Tyr c-3H, proximal', other_designations='', map_location='', chromosome='7', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  242519 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=242519, CurrentID=0, Status='live', Symbol='Ifna12', Aliases='', description='interferon alpha 12', other_designations='IFN alpha 12|IFN-alpha-12', map_location='4 C4', chromosome='4', genomic_nucleotide_accession_version='NC_000070.6', start_position_on_the_genomic_accession=88602580, end_position_on_the_genomic_accession=88603376, orientation='minus', exon_count=1, OMIM='', no_hdr0=''),
  13332 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=13332, CurrentID=0, Status='live', Symbol='Del(Y)1Ct-d', Aliases='Del(Y)1H', description='deletion, Chr Y, 1 Cattanach, distal breakpoint', other_designations='deletion, Chr Y, Yd1, Rlll, Cattanach, distal breakpoint', map_location='', chromosome='Y', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  13333 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=13333, CurrentID=0, Status='live', Symbol='Del(Y)1Ct-p', Aliases='Del(Y)1H', description='deletion, Chr Y, 1 Cattanach, proximal breakpoint', other_designations='deletion, Chr Y, Yd1, Rlll, Cattanach, proximal breakpoint', map_location='', chromosome='Y', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  13334 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=13334, CurrentID=0, Status='live', Symbol='Del(Y)B10.BR-Y<del>/Ms', Aliases='Del(Y)B10.BR-Y<del>/Ma', description='deletion, Chr Y, B10.BR-Y<del>, Mishima', other_designations='Del(B10.Br-Y<del>)', map_location='', chromosome='Y', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  242521 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=242521, CurrentID=0, Status='live', Symbol='Klhl9', Aliases='8030469P05, C530050O22Rik, ENSMUSG00000070923, mKIAA1354', description='kelch-like 9', other_designations='', map_location='4 C4', chromosome='4', genomic_nucleotide_accession_version='NC_000070.6', start_position_on_the_genomic_accession=88718292, end_position_on_the_genomic_accession=88722508, orientation='minus', exon_count=1, OMIM='', no_hdr0=''),
  13340 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=13340, CurrentID=0, Status='live', Symbol='Slc29a2', Aliases='Der12, Ent2, Hnp36', description='solute carrier family 29 (nucleoside transporters), member 2', other_designations='36 kDa hydrophobic nucleolar protein|36 kDa nucleolar protein HNP36|delayed early response gene 12|delayed-early response protein 12|equilibrative NBMPR-insensitive nucleoside transporter|equilibrative nitrobenzylmercaptopurine riboside-insensitive nucleoside transporter|nucleoside transporter, ei-type|solute carrier family 29 member 2', map_location='19 A', chromosome='19', genomic_nucleotide_accession_version='NC_000085.6', start_position_on_the_genomic_accession=5023407, end_position_on_the_genomic_accession=5031972, orientation='plus', exon_count=13, OMIM='', no_hdr0=''),
  13345 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=13345, CurrentID=0, Status='live', Symbol='Twist2', Aliases='Dermo1, bHLHa39', description='twist basic helix-loop-helix transcription factor 2', other_designations='dermis-expressed protein 1|twist homolog 2', map_location='1 D', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=91801477, end_position_on_the_genomic_accession=91848027, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  13346 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=13346, CurrentID=0, Status='live', Symbol='Des', Aliases='', description='desmin', other_designations='', map_location='1 C3', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=75360292, end_position_on_the_genomic_accession=75368579, orientation='plus', exon_count=9, OMIM='', no_hdr0=''),
  13347 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=13347, CurrentID=0, Status='live', Symbol='Dffa', Aliases='A330085O09Rik, DFF35, Dff45, ICAD, ICAD-L, ICAD-S', description='DNA fragmentation factor, alpha subunit', other_designations='DNA fragmentation factor 45 kDa subunit|inhibitor of CAD', map_location='4 E2', chromosome='4', genomic_nucleotide_accession_version='NC_000070.6', start_position_on_the_genomic_accession=149104142, end_position_on_the_genomic_accession=149120653, orientation='plus', exon_count=6, OMIM='', no_hdr0=''),
  13349 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=13349, CurrentID=0, Status='live', Symbol='Ackr1', Aliases='AA162249, CCBP1, CD234, Darc, Dfy, ESTM35, FY, GPD', description='atypical chemokine receptor 1 (Duffy blood group)', other_designations='Duffy antigen receptor for chemokines|Duffy blood group, chemokine receptor|duffy antigen/chemokine receptor|glycoprotein D', map_location='1 80.33 cM', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=173331886, end_position_on_the_genomic_accession=173333503, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  13350 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=13350, CurrentID=0, Status='live', Symbol='Dgat1', Aliases='ARAT, C75990, D15Ertd23e, Dgat', description='diacylglycerol O-acyltransferase 1', other_designations='acyl-CoA retinol O-fatty-acyltransferase|diacylglycerol acyltransferase 1|diglyceride acyltransferase|retinol O-fatty-acyltransferase', map_location='15 35.99 cM', chromosome='15', genomic_nucleotide_accession_version='NC_000081.6', start_position_on_the_genomic_accession=76502014, end_position_on_the_genomic_accession=76512020, orientation='minus', exon_count=18, OMIM='', no_hdr0=''),
  13353 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=13353, CurrentID=0, Status='live', Symbol='Dgcr6', Aliases='', description='DiGeorge syndrome critical region gene 6', other_designations='DiGeorge syndrome chromosome region 6|diGeorge syndrome critical region 6 homolog', map_location='16 B2', chromosome='16', genomic_nucleotide_accession_version='NC_000082.6', start_position_on_the_genomic_accession=18052860, end_position_on_the_genomic_accession=18071632, orientation='plus', exon_count=8, OMIM='', no_hdr0=''),
  13356 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=13356, CurrentID=0, Status='live', Symbol='Dgcr2', Aliases='9930034O06Rik, DGS-C, Dgsc, Idd, Lan, Sez12, mKIAA0163', description='DiGeorge syndrome critical region gene 2', other_designations='DiGeorge syndrome gene c|DiGeorge syndrome protein C|seizure-related membrane-bound adhesion protein', map_location='16 A-B1', chromosome='16', genomic_nucleotide_accession_version='NC_000082.6', start_position_on_the_genomic_accession=17840355, end_position_on_the_genomic_accession=17894098, orientation='minus', exon_count=12, OMIM='', no_hdr0=''),
  13358 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=13358, CurrentID=0, Status='live', Symbol='Slc25a1', Aliases='1300019P08Rik, 2610100G11Rik, AI194714, Ctp, Dgsj, Slc20a3', description='solute carrier family 25 (mitochondrial carrier, citrate transporter), member 1', other_designations='DiGeorge syndrome gene j|citrate transport protein|solute carrier family 25 member 1|tricarboxylate carrier protein', map_location='16 11.11 cM', chromosome='16', genomic_nucleotide_accession_version='NC_000082.6', start_position_on_the_genomic_accession=17925211, end_position_on_the_genomic_accession=17928219, orientation='minus', exon_count=9, OMIM='', no_hdr0=''),
  13360 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=13360, CurrentID=0, Status='live', Symbol='Dhcr7', Aliases='AA409147', description='7-dehydrocholesterol reductase', other_designations='7-DHC reductase|sterol Delta(7)-reductase', map_location='7 F5', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=143823167, end_position_on_the_genomic_accession=143848410, orientation='plus', exon_count=14, OMIM='', no_hdr0=''),
  13361 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=13361, CurrentID=0, Status='live', Symbol='Dhfr', Aliases='8430436I03Rik, AA607882, AI662710, AW555094', description='dihydrofolate reductase', other_designations='', map_location='13 47.64 cM', chromosome='13', genomic_nucleotide_accession_version='NC_000079.6', start_position_on_the_genomic_accession=92354783, end_position_on_the_genomic_accession=92389053, orientation='plus', exon_count=6, OMIM='', no_hdr0=''),
  13363 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=13363, CurrentID=0, Status='live', Symbol='Dhh', Aliases='C78960', description='desert hedgehog', other_designations='HHG-3', map_location='15 55.05 cM', chromosome='15', genomic_nucleotide_accession_version='NC_000081.6', start_position_on_the_genomic_accession=98881630, end_position_on_the_genomic_accession=98898572, orientation='minus', exon_count=5, OMIM='', no_hdr0=''),
  668725 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=668725, CurrentID=0, Status='live', Symbol='Mrgpra9', Aliases='EG668725, MrgA9', description='MAS-related GPR, member A9', other_designations='G-protein coupled adenine receptor', map_location='7 B4', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=47234919, end_position_on_the_genomic_accession=47252848, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  13367 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=13367, CurrentID=0, Status='live', Symbol='Diaph1', Aliases='D18Wsu154e, Dia1, Diap1, Drf1, p140mDia', description='diaphanous related formin 1', other_designations='diaphanous homolog 1|diaphanous-related formin-1', map_location='18 19.71 cM', chromosome='18', genomic_nucleotide_accession_version='NC_000084.6', start_position_on_the_genomic_accession=37843601, end_position_on_the_genomic_accession=37935617, orientation='minus', exon_count=29, OMIM='', no_hdr0=''),
  13368 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=13368, CurrentID=0, Status='live', Symbol='Dffb', Aliases='40kDa, 5730477D02Rik, CAD, CPAN, DFF40, Didff', description='DNA fragmentation factor, beta subunit', other_designations='DFF-40|DNA fragmentation factor 40 kDa subunit|DNA fragmentation factor, 40 kD, beta subunit|DNase inhibited by DNA fragmentation factor|caspase-activated DNase|caspase-activated deoxyribonuclease', map_location='4 E2', chromosome='4', genomic_nucleotide_accession_version='NC_000070.6', start_position_on_the_genomic_accession=153964447, end_position_on_the_genomic_accession=153975121, orientation='minus', exon_count=10, OMIM='', no_hdr0=''),
  13370 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=13370, CurrentID=0, Status='live', Symbol='Dio1', Aliases='5DI, D1, ITDI1, TXDI1', description='deiodinase, iodothyronine, type I', other_designations="DIOI|type 1 DI|type-I 5'-deiodinase", map_location='4 50.18 cM', chromosome='4', genomic_nucleotide_accession_version='NC_000070.6', start_position_on_the_genomic_accession=107291465, end_position_on_the_genomic_accession=107307143, orientation='minus', exon_count=4, OMIM='', no_hdr0=''),
  13371 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=13371, CurrentID=0, Status='live', Symbol='Dio2', Aliases='5DII, AI324267, DIOII', description='deiodinase, iodothyronine, type II', other_designations="iodothyronine type II deiodinase|type 2 DI|type-II 5' deiodinase|type-II 5'-deiodinase", map_location='12 D3', chromosome='12', genomic_nucleotide_accession_version='NC_000078.6', start_position_on_the_genomic_accession=90724552, end_position_on_the_genomic_accession=90738438, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  13380 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=13380, CurrentID=0, Status='live', Symbol='Dkk1', Aliases='mdkk-1', description='dickkopf WNT signaling pathway inhibitor 1', other_designations='dickkopf homolog 1|dickkopf-1|dickkopf-like protein 1|dkk-1', map_location='19 C2', chromosome='19', genomic_nucleotide_accession_version='NC_000085.6', start_position_on_the_genomic_accession=30545876, end_position_on_the_genomic_accession=30549496, orientation='minus', exon_count=4, OMIM='', no_hdr0=''),
  13382 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=13382, CurrentID=0, Status='live', Symbol='Dld', Aliases='', description='dihydrolipoamide dehydrogenase', other_designations='branched chain alpha-keto acid dehydrogenase complex subunit E3', map_location='12 13.43 cM', chromosome='12', genomic_nucleotide_accession_version='NC_000078.6', start_position_on_the_genomic_accession=31331562, end_position_on_the_genomic_accession=31351471, orientation='minus', exon_count=14, OMIM='', no_hdr0=''),
  13383 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=13383, CurrentID=0, Status='live', Symbol='Dlg1', Aliases='B130052P05Rik, Dlgh1, E-dlg/SAP97, SAP-97, SAP97, mKIAA4187', description='discs, large homolog 1 (Drosophila)', other_designations='embryo-dlg/synapse-associated protein 97', map_location='16 22.4 cM', chromosome='16', genomic_nucleotide_accession_version='NC_000082.6', start_position_on_the_genomic_accession=31663443, end_position_on_the_genomic_accession=31873356, orientation='plus', exon_count=31, OMIM='', no_hdr0=''),
  13384 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=13384, CurrentID=0, Status='live', Symbol='Mpp3', Aliases='6430514B01, Dlgh3', description='membrane protein, palmitoylated 3 (MAGUK p55 subfamily member 3)', other_designations='Mpp3 membrane protein, palmitoylated 3|discs large homolog 3', map_location='11 65.48 cM', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=101999652, end_position_on_the_genomic_accession=102027048, orientation='minus', exon_count=20, OMIM='', no_hdr0=''),
  13385 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=13385, CurrentID=0, Status='live', Symbol='Dlg4', Aliases='Dlgh4, PSD-95, PSD95, SAP90, SAP90A', description='discs, large homolog 4 (Drosophila)', other_designations='PSD-95 alpha 2b|PSD-95 beta|SAP-90|discs large homolog 4|postsynaptic density protein 95|synapse-associated protein 90', map_location='11 B4', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=70018455, end_position_on_the_genomic_accession=70045532, orientation='plus', exon_count=22, OMIM='', no_hdr0=''),
  13386 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=13386, CurrentID=0, Status='live', Symbol='Dlk1', Aliases='AW742678, DLK-1, DlkI, FA1, Ly107, Peg9, SCP1, ZOG, pG2, pref-1', description='delta-like 1 homolog (Drosophila)', other_designations='adipocyte differentiation inhibitor protein|fetal antigen 1|preadipocyte factor 1|stromal cell derived protein 1', map_location='12 E-F1', chromosome='12', genomic_nucleotide_accession_version='NC_000078.6', start_position_on_the_genomic_accession=109452823, end_position_on_the_genomic_accession=109463336, orientation='plus', exon_count=7, OMIM='', no_hdr0=''),
  13388 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=13388, CurrentID=0, Status='live', Symbol='Dll1', Aliases='Delta1', description='delta-like 1 (Drosophila)', other_designations='delta like-1|drosophila Delta homolog 1', map_location='17 8.95 cM', chromosome='17', genomic_nucleotide_accession_version='NC_000083.6', start_position_on_the_genomic_accession=15367354, end_position_on_the_genomic_accession=15376113, orientation='minus', exon_count=10, OMIM='', no_hdr0=''),
  13389 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=13389, CurrentID=0, Status='live', Symbol='Dll3', Aliases='pu, pudgy', description='delta-like 3 (Drosophila)', other_designations='M-Delta-3|delta3|drosophila Delta homolog 3', map_location='7 16.67 cM', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=28293555, end_position_on_the_genomic_accession=28301785, orientation='minus', exon_count=9, OMIM='', no_hdr0=''),
  13390 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=13390, CurrentID=0, Status='live', Symbol='Dlx1', Aliases='Dlx, Dlx-1', description='distal-less homeobox 1', other_designations='DII B', map_location='2 42.61 cM', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=71528041, end_position_on_the_genomic_accession=71533981, orientation='plus', exon_count=4, OMIM='', no_hdr0=''),
  13392 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=13392, CurrentID=0, Status='live', Symbol='Dlx2', Aliases='AW121999, Dlx-2, Tes-1', description='distal-less homeobox 2', other_designations='DII A|homeobox protein TES-1', map_location='2 42.65 cM', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=71543408, end_position_on_the_genomic_accession=71546754, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  13393 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=13393, CurrentID=0, Status='live', Symbol='Dlx3', Aliases='AV237891, Dlx-3', description='distal-less homeobox 3', other_designations='DII C', map_location='11 59.01 cM', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=95120117, end_position_on_the_genomic_accession=95125293, orientation='plus', exon_count=3, OMIM='', no_hdr0=''),
  13394 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=13394, CurrentID=0, Status='live', Symbol='Dlx4', Aliases='Dlx-4, Dlx7', description='distal-less homeobox 4', other_designations='DII D|distal-less homeo box 7|homeobox protein DLX-7', map_location='11 59.01 cM', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=95140447, end_position_on_the_genomic_accession=95146499, orientation='minus', exon_count=5, OMIM='', no_hdr0=''),
  13395 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=13395, CurrentID=0, Status='live', Symbol='Dlx5', Aliases='AI385752', description='distal-less homeobox 5', other_designations='', map_location='6 2.83 cM', chromosome='6', genomic_nucleotide_accession_version='NC_000072.6', start_position_on_the_genomic_accession=6877801, end_position_on_the_genomic_accession=6882068, orientation='minus', exon_count=5, OMIM='', no_hdr0=''),
  13396 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=13396, CurrentID=0, Status='live', Symbol='Dlx6', Aliases='', description='distal-less homeobox 6', other_designations='', map_location='6 2.83 cM', chromosome='6', genomic_nucleotide_accession_version='NC_000072.6', start_position_on_the_genomic_accession=6863334, end_position_on_the_genomic_accession=6867970, orientation='plus', exon_count=4, OMIM='', no_hdr0=''),
  668758 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=668758, CurrentID=0, Status='live', Symbol='Fbxw28', Aliases='Gm9337', description='F-box and WD-40 domain protein 28', other_designations='', map_location='9', chromosome='9', genomic_nucleotide_accession_version='NC_000075.6', start_position_on_the_genomic_accession=109322886, end_position_on_the_genomic_accession=109339659, orientation='minus', exon_count=11, OMIM='', no_hdr0=''),
  13400 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=13400, CurrentID=0, Status='live', Symbol='Dmpk', Aliases='DM, DMK, Dm15, MDPK, MT-PK', description='dystrophia myotonica-protein kinase', other_designations='DM-kinase|dystrophia myotonica kinase, B15|myotonic dystrophy protein kinase', map_location='7 9.46 cM', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=19083834, end_position_on_the_genomic_accession=19093821, orientation='plus', exon_count=15, OMIM='', no_hdr0=''),
  13401 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=13401, CurrentID=0, Status='live', Symbol='Dmwd', Aliases='DMR-N9, Dm9', description='dystrophia myotonica-containing WD repeat motif', other_designations='dystrophia myotonica linked gene, N9|dystrophia myotonica-containing WD repeat motif protein', map_location='7 9.46 cM', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=19076089, end_position_on_the_genomic_accession=19082776, orientation='plus', exon_count=6, OMIM='', no_hdr0=''),
  13404 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=13404, CurrentID=0, Status='live', Symbol='Dmc1', Aliases='Dmc1h, Lim15, Mei11, sgdp', description='DNA meiotic recombinase 1', other_designations='DMC1 dosage suppressor of mck1 homolog, meiosis-specific homologous recombination|disrupted meiotic cDNA 1 homolog', map_location='15 37.79 cM', chromosome='15', genomic_nucleotide_accession_version='NC_000081.6', start_position_on_the_genomic_accession=79561497, end_position_on_the_genomic_accession=79605154, orientation='minus', exon_count=14, OMIM='', no_hdr0=''),
  13405 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=13405, CurrentID=0, Status='live', Symbol='Dmd', Aliases='DXSmh7, DXSmh9, Dp427, Dp71, dys, mdx, pke', description='dystrophin, muscular dystrophy', other_designations='X-linked muscular dystrophy', map_location='X C', chromosome='X', genomic_nucleotide_accession_version='NC_000086.7', start_position_on_the_genomic_accession=82310713, end_position_on_the_genomic_accession=85205050, orientation='plus', exon_count=85, OMIM='', no_hdr0=''),
  13406 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=13406, CurrentID=0, Status='live', Symbol='Dmp1', Aliases='AV020965, Dmp, PP', description='dentin matrix protein 1', other_designations='AG1|DMP-1|serine rich acidic phosphoprotein', map_location='5 50.61 cM', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=104197558, end_position_on_the_genomic_accession=104214109, orientation='plus', exon_count=7, OMIM='', no_hdr0=''),
  13409 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=13409, CurrentID=0, Status='live', Symbol='Tmc1', Aliases='4933416G09Rik, Beethoven, Bth, CWEA1, dn', description='transmembrane channel-like gene family 1', other_designations='deafness protein|transmembrane cochlear-expressed protein 1|transmembrane, cochlear expressed 1', map_location='19 13.98 cM', chromosome='19', genomic_nucleotide_accession_version='NC_000085.6', start_position_on_the_genomic_accession=20783458, end_position_on_the_genomic_accession=21037152, orientation='minus', exon_count=23, OMIM='', no_hdr0=''),
  13411 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=13411, CurrentID=0, Status='live', Symbol='Dnah11', Aliases='Dnahc11, b2b1203Clo, b2b1279Clo, b2b1289Clo, b2b1727Clo, b2b598Clo, iv, lrd', description='dynein, axonemal, heavy chain 11', other_designations='dynein, axon, heavy chain 11|situs inversus viscerum', map_location='12 63.25 cM', chromosome='12', genomic_nucleotide_accession_version='NC_000078.6', start_position_on_the_genomic_accession=117877982, end_position_on_the_genomic_accession=118199043, orientation='minus', exon_count=87, OMIM='', no_hdr0=''),
  13417 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=13417, CurrentID=0, Status='live', Symbol='Dnah8', Aliases='ATPase, Dnahc8, Hst6.7b, P1-Loop', description='dynein, axonemal, heavy chain 8', other_designations='axonemal beta dynein heavy chain 8|axonemal dynein heavy chain 8 Dnahc8|ciliary dynein heavy chain 8|dynein, axon, heavy chain 8', map_location='17 A3.3', chromosome='17', genomic_nucleotide_accession_version='NC_000083.6', start_position_on_the_genomic_accession=30626936, end_position_on_the_genomic_accession=30875762, orientation='plus', exon_count=95, OMIM='', no_hdr0=''),
  13418 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=13418, CurrentID=0, Status='live', Symbol='Dnajc1', Aliases='4733401K02Rik, AA960110, D230036H06Rik, Dnajl1, ERdj1, ERj1p, MTJ1', description='DnaJ heat shock protein family (Hsp40) member C1', other_designations='DnaJ (Hsp40) homolog, subfamily C, member 1|DnaJ-like protein 1|dnaJ protein homolog MTJ1', map_location='2 A2', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=18206333, end_position_on_the_genomic_accession=18392851, orientation='minus', exon_count=13, OMIM='', no_hdr0=''),
  13419 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=13419, CurrentID=0, Status='live', Symbol='Dnase1', Aliases='AI788650, DNaseI, Dnl1', description='deoxyribonuclease I', other_designations='', map_location='16 2.37 cM', chromosome='16', genomic_nucleotide_accession_version='NC_000082.6', start_position_on_the_genomic_accession=4036786, end_position_on_the_genomic_accession=4040024, orientation='plus', exon_count=10, OMIM='', no_hdr0=''),
  13421 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=13421, CurrentID=0, Status='live', Symbol='Dnase1l3', Aliases='DNasegamma, Dhp2, Lsd', description='deoxyribonuclease 1-like 3', other_designations='DNase I homolog protein DHP2|DNase I-like 3|DNase gamma|LS-DNase|deoxyribonuclease I-like 3|liver and spleen DNase|macrophage specific DNase I', map_location='14 A1', chromosome='14', genomic_nucleotide_accession_version='NC_000080.6', start_position_on_the_genomic_accession=7965187, end_position_on_the_genomic_accession=7994653, orientation='minus', exon_count=9, OMIM='', no_hdr0=''),
  13423 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=13423, CurrentID=0, Status='live', Symbol='Dnase2a', Aliases='Dnase2', description='deoxyribonuclease II alpha', other_designations='DNase II alpha|acid DNase|lysosomal DNase II', map_location='8 41.31 cM', chromosome='8', genomic_nucleotide_accession_version='NC_000074.6', start_position_on_the_genomic_accession=84908624, end_position_on_the_genomic_accession=84911461, orientation='plus', exon_count=6, OMIM='', no_hdr0=''),
  13424 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=13424, CurrentID=0, Status='live', Symbol='Dync1h1', Aliases='9930018I23Rik, AI894280, DHC1, DHC1a, DNCL, Dnchc1, Dnec1, Dnecl, Loa, MAP1C, P22, Swl, mKIAA0325', description='dynein cytoplasmic 1 heavy chain 1', other_designations='cytoplasmic dynein heavy chain 1|dynein heavy chain, cytosolic|dynein heavy chain, retrograde transport|dynein, cytoplasmic, heavy chain 1|legs at odd angle|sprawling', map_location='12 60.7 cM', chromosome='12', genomic_nucleotide_accession_version='NC_000078.6', start_position_on_the_genomic_accession=110601395, end_position_on_the_genomic_accession=110666944, orientation='plus', exon_count=77, OMIM='', no_hdr0=''),
  13426 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=13426, CurrentID=0, Status='live', Symbol='Dync1i1', Aliases='DH IC-1, DHIC-1, DIC, Dncic1, IC74', description='dynein cytoplasmic 1 intermediate chain 1', other_designations='Dynein intermediate chain 1, cytosolic (DH IC-1) (Cytoplasmic dynein intermediate chain 1)|cytoplasmic dynein intermediate chain 1 isoform 1.6|dynein, cytoplasmic, intermediate chain 1', map_location='6 2.26 cM', chromosome='6', genomic_nucleotide_accession_version='NC_000072.6', start_position_on_the_genomic_accession=5725633, end_position_on_the_genomic_accession=6028039, orientation='plus', exon_count=17, OMIM='', no_hdr0=''),
  13427 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=13427, CurrentID=0, Status='live', Symbol='Dync1i2', Aliases='3110079H08Rik, AW554389, Dncic2', description='dynein cytoplasmic 1 intermediate chain 2', other_designations='DH IC-2|cytoplasmic dynein intermediate chain 2 isoform 2.1|cytoplasmic dynein intermediate chain 2 isoform 2.2|cytoplasmic dynein intermediate chain 2 isoform 2.5|dynein intermediate chain 2, cytosolic|dynein, cytoplasmic, intermediate chain 2', map_location='2 42.38 cM', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=71211706, end_position_on_the_genomic_accession=71263303, orientation='plus', exon_count=21, OMIM='', no_hdr0=''),
  13429 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=13429, CurrentID=0, Status='live', Symbol='Dnm1', Aliases='AI838169, Dnm, Ftfl, mKIAA4093', description='dynamin 1', other_designations='', map_location='2 22.09 cM', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=32308471, end_position_on_the_genomic_accession=32353339, orientation='minus', exon_count=27, OMIM='', no_hdr0=''),
  13430 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=13430, CurrentID=0, Status='live', Symbol='Dnm2', Aliases='Dyn2, Udnm, b2b2159Clo', description='dynamin 2', other_designations='', map_location='9 7.79 cM', chromosome='9', genomic_nucleotide_accession_version='NC_000075.6', start_position_on_the_genomic_accession=21424908, end_position_on_the_genomic_accession=21507759, orientation='plus', exon_count=25, OMIM='', no_hdr0=''),
  13433 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=13433, CurrentID=0, Status='live', Symbol='Dnmt1', Aliases='Cxxc9, Dnmto, MCMT, MTase, Met-1, Met1, MommeD2, m.MmuI, Dnmt1', description='DNA methyltransferase (cytosine-5) 1', other_designations='DNA MTase MmuI|DNA methyltransferase MmuI', map_location='9 7.66 cM', chromosome='9', genomic_nucleotide_accession_version='NC_000075.6', start_position_on_the_genomic_accession=20907205, end_position_on_the_genomic_accession=20959888, orientation='minus', exon_count=41, OMIM='', no_hdr0=''),
  13434 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=13434, CurrentID=0, Status='live', Symbol='Trdmt1', Aliases='Dnmt2, Rnmt2', description='tRNA aspartic acid methyltransferase 1', other_designations='DNA (cytosine-5)-methyltransferase-like protein 2|DNA MTase homolog MmuIIP|DNA methyltransferase 2|DNA methyltransferase homolog MmuIIP|m.MmuIIP|met-2|tRNA (cytosine-5-)-methyltransferase', map_location='2 A1', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=13509014, end_position_on_the_genomic_accession=13544971, orientation='minus', exon_count=13, OMIM='', no_hdr0=''),
  67775 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=67775, CurrentID=0, Status='live', Symbol='Rtp4', Aliases='5830458K16Rik, Ifrg28', description='receptor transporter protein 4', other_designations='28 kDa interferon-responsive protein|28kD interferon alpha responsive protein|receptor transporting protein 4', map_location='16 B1', chromosome='16', genomic_nucleotide_accession_version='NC_000082.6', start_position_on_the_genomic_accession=23601379, end_position_on_the_genomic_accession=23614222, orientation='plus', exon_count=4, OMIM='', no_hdr0=''),
  13436 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=13436, CurrentID=0, Status='live', Symbol='Dnmt3b', Aliases='MmuIIIB', description='DNA methyltransferase 3B', other_designations='DNA MTase MmuIIIB|DNA methyltransferase MmuIIIB', map_location='2 A2-A3', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=153649165, end_position_on_the_genomic_accession=153687730, orientation='plus', exon_count=25, OMIM='', no_hdr0=''),
  13437 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=13437, CurrentID=0, Status='live', Symbol='Dnpep', Aliases='AA407814', description='aspartyl aminopeptidase', other_designations='', map_location='1 C3-C4', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=75308565, end_position_on_the_genomic_accession=75317654, orientation='minus', exon_count=16, OMIM='', no_hdr0=''),
  13445 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=13445, CurrentID=0, Status='live', Symbol='Cdk2ap1', Aliases='Apc10, Cdkap1, DORC1, Doc1, ST19, doc-1, p12', description='CDK2 (cyclin-dependent kinase 2)-associated protein 1', other_designations='CDK2-associated protein 1|deleted in oral cancer 1|putative oral cancer suppressor', map_location='5 F', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=124345439, end_position_on_the_genomic_accession=124354628, orientation='minus', exon_count=4, OMIM='', no_hdr0=''),
  13446 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=13446, CurrentID=0, Status='live', Symbol='Doc2a', Aliases='', description='double C2, alpha', other_designations='doc2-alpha', map_location='7 F4', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=126847349, end_position_on_the_genomic_accession=126852705, orientation='plus', exon_count=11, OMIM='', no_hdr0=''),
  13447 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=13447, CurrentID=0, Status='live', Symbol='Doc2b', Aliases='', description='double C2, beta', other_designations='doc2-beta|double C2 protein beta', map_location='11 B5', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=75769090, end_position_on_the_genomic_accession=75796057, orientation='minus', exon_count=9, OMIM='', no_hdr0=''),
  13448 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=13448, CurrentID=0, Status='live', Symbol='Dok1', Aliases='AW557123, p62DOK', description='docking protein 1', other_designations='downstream of tyrosine kinase 1|p62(dok)', map_location='6 35.94 cM', chromosome='6', genomic_nucleotide_accession_version='NC_000072.6', start_position_on_the_genomic_accession=83030932, end_position_on_the_genomic_accession=83033471, orientation='minus', exon_count=5, OMIM='', no_hdr0=''),
  13449 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=13449, CurrentID=0, Status='live', Symbol='Dok2', Aliases='DokR, Frip', description='docking protein 2', other_designations='IL-Four Receptor Interacting Protein|IL-four receptor-interacting protein|dok-R|dok-related protein|downstream of tyrosine kinase 2|p56 dok-2|p56(dok-2)', map_location='14 D2-D3', chromosome='14', genomic_nucleotide_accession_version='NC_000080.6', start_position_on_the_genomic_accession=70764528, end_position_on_the_genomic_accession=70778494, orientation='plus', exon_count=8, OMIM='', no_hdr0=''),
  13476 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=13476, CurrentID=0, Status='live', Symbol='Reep5', Aliases='AI324241, AU022809, AW495741, DP1/TB2, Dp1, R74856, TB2/DP1', description='receptor accessory protein 5', other_designations='GP106|deleted in polyposis 1|polyposis locus protein 1 homolog|protein TB2 homolog|receptor expression enhancing protein 5', map_location='18 B1', chromosome='18', genomic_nucleotide_accession_version='NC_000084.6', start_position_on_the_genomic_accession=34344885, end_position_on_the_genomic_accession=34373415, orientation='minus', exon_count=5, OMIM='', no_hdr0=''),
  13478 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=13478, CurrentID=0, Status='live', Symbol='Dpagt1', Aliases='AU021132, Dpagt2, GPT, Gnpta', description='dolichyl-phosphate (UDP-N-acetylglucosamine) acetylglucosaminephosphotransferase 1 (GlcNAc-1-P transferase)', other_designations='G1PT|N-acetylglucosamine-1-phosphate transferase|UDP-N-acetylglucosamine lysosomal enzyme N-acetylglucosamine phosphotransferase|dolichyl-phosphate alpha-N-acetylglucosaminephosphotransferase 2|glcNAc-1-P transferase', map_location='9 24.84 cM', chromosome='9', genomic_nucleotide_accession_version='NC_000075.6', start_position_on_the_genomic_accession=44326017, end_position_on_the_genomic_accession=44333606, orientation='plus', exon_count=10, OMIM='', no_hdr0=''),
  13479 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=13479, CurrentID=0, Status='live', Symbol='Dpep1', Aliases='AI327012, MBD', description='dipeptidase 1 (renal)', other_designations='MBD-1|membrane bound dipeptidase type II|membrane-bound dipeptidase 1|microsomal dipeptidase|renal dipeptidase', map_location='8 72.08 cM', chromosome='8', genomic_nucleotide_accession_version='NC_000074.6', start_position_on_the_genomic_accession=123186235, end_position_on_the_genomic_accession=123201812, orientation='plus', exon_count=11, OMIM='', no_hdr0=''),
  13480 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=13480, CurrentID=0, Status='live', Symbol='Dpm1', Aliases='AI118379, AI194292', description='dolichol-phosphate (beta-D) mannosyltransferase 1', other_designations='DPM synthase subunit 1|MPD synthase|dolichol-phosphate mannose synthase subunit 1|dolichyl-phosphate beta-D-mannosyltransferase subunit 1|mannose-P-dolichol synthase subunit 1', map_location='2 H3', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=168209048, end_position_on_the_genomic_accession=168230379, orientation='minus', exon_count=9, OMIM='', no_hdr0=''),
  13481 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=13481, CurrentID=0, Status='live', Symbol='Dpm2', Aliases='AW557993, R75484', description='dolichol-phosphate (beta-D) mannosyltransferase 2', other_designations='DPM synthase subunit 2|dolichol-phosphate mannose synthase subunit 2', map_location='2 B', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=32570858, end_position_on_the_genomic_accession=32573571, orientation='plus', exon_count=4, OMIM='', no_hdr0=''),
  13482 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=13482, CurrentID=0, Status='live', Symbol='Dpp4', Aliases='Cd26, Dpp-4, THAM', description='dipeptidylpeptidase 4', other_designations='DPP IV|T-cell activation antigen CD26|dipeptidyl peptidase IV|thymocyte-activating molecule', map_location='2 C2-D', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=62330073, end_position_on_the_genomic_accession=62412317, orientation='minus', exon_count=30, OMIM='', no_hdr0=''),
  13483 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=13483, CurrentID=0, Status='live', Symbol='Dpp6', Aliases='B930011P16Rik, D5Buc3, D5Buc4, D5Buc5, DPP VI, Dpp-6, Gm1377, In(5)6H-p, Peplb, Rw', description='dipeptidylpeptidase 6', other_designations='DPPX|dipeptidyl aminopeptidase-related protein|dipeptidyl peptidase IV-like protein|dipeptidyl peptidase VI|dipeptidylpeptidase VI|inversion, Chr 5, Harwell 6, proximal', map_location='5 12.92 cM', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=26817357, end_position_on_the_genomic_accession=27727500, orientation='plus', exon_count=29, OMIM='', no_hdr0=''),
  13486 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=13486, CurrentID=0, Status='live', Symbol='Dr1', Aliases='1700121L09Rikl, NC2, NC2beta, Dr1', description='down-regulator of transcription 1', other_designations='NC2-beta|TATA-binding protein-associated phosphoprotein|negative cofactor 2-beta', map_location='5 52.82 cM', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=108268897, end_position_on_the_genomic_accession=108280521, orientation='plus', exon_count=3, OMIM='', no_hdr0=''),
  13487 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=13487, CurrentID=0, Status='live', Symbol='Slc26a3', Aliases='9030623B18Rik, 9130013M11Rik, AV376035, Dra', description='solute carrier family 26, member 3', other_designations='down-regulated in adenoma', map_location='12 13.45 cM', chromosome='12', genomic_nucleotide_accession_version='NC_000078.6', start_position_on_the_genomic_accession=31390876, end_position_on_the_genomic_accession=31473922, orientation='plus', exon_count=24, OMIM='', no_hdr0=''),
  13488 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=13488, CurrentID=0, Status='live', Symbol='Drd1', Aliases='C030036C15Rik, Drd-1a, Gpcr15, Drd1', description='dopamine receptor D1', other_designations='D1 receptor|D1A dopamine receptor|G protein-coupled receptor DRD1|dopamine D1 receptor|dopamine receptor D1A', map_location='13 28.4 cM', chromosome='13', genomic_nucleotide_accession_version='NC_000079.6', start_position_on_the_genomic_accession=54051183, end_position_on_the_genomic_accession=54055658, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  13489 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=13489, CurrentID=0, Status='live', Symbol='Drd2', Aliases='D2R, Drd-2', description='dopamine receptor D2', other_designations='D2 receptor|dopamine D2 receptor|dopamine receptor 2', map_location='9 26.72 cM', chromosome='9', genomic_nucleotide_accession_version='NC_000075.6', start_position_on_the_genomic_accession=49340428, end_position_on_the_genomic_accession=49408174, orientation='plus', exon_count=8, OMIM='', no_hdr0=''),
  13490 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=13490, CurrentID=0, Status='live', Symbol='Drd3', Aliases='D3R', description='dopamine receptor D3', other_designations='dopamine D3 receptor|dopamine receptor 3', map_location='16 28.44 cM', chromosome='16', genomic_nucleotide_accession_version='NC_000082.6', start_position_on_the_genomic_accession=43754015, end_position_on_the_genomic_accession=43823846, orientation='plus', exon_count=8, OMIM='', no_hdr0=''),
  13491 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=13491, CurrentID=0, Status='live', Symbol='Drd4', Aliases='AW125663, D4R, Drd-4', description='dopamine receptor D4', other_designations='d(2C) dopamine receptor|dopamine D4 receptor|dopamine receptor 4', map_location='7 86.6 cM', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=141291976, end_position_on_the_genomic_accession=141296238, orientation='plus', exon_count=4, OMIM='', no_hdr0=''),
  13492 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=13492, CurrentID=0, Status='live', Symbol='Drd5', Aliases='D5R, Drd-5, Drd1b, Gpcr1', description='dopamine receptor D5', other_designations='d(5) dopamine receptor|dopamine D5 receptor|dopamine receptor 5', map_location='5 20.4 cM', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=38319509, end_position_on_the_genomic_accession=38322310, orientation='plus', exon_count=1, OMIM='', no_hdr0=''),
  13494 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=13494, CurrentID=0, Status='live', Symbol='Drg1', Aliases='AA408859, AI132520, Nedd3', description='developmentally regulated GTP binding protein 1', other_designations='DRG-1|GTP-binding protein|NEDD-3|neural precursor cell expressed developmentally down-regulated protein 3', map_location='11 A1', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=3249922, end_position_on_the_genomic_accession=3266386, orientation='minus', exon_count=9, OMIM='', no_hdr0=''),
  13495 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=13495, CurrentID=0, Status='live', Symbol='Drg2', Aliases='AI255295, AI461605', description='developmentally regulated GTP binding protein 2', other_designations='DRG-2|developmentally regulated GTP-binding protein 2', map_location='11 37.81 cM', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=60454617, end_position_on_the_genomic_accession=60468724, orientation='plus', exon_count=13, OMIM='', no_hdr0=''),
  13496 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=13496, CurrentID=0, Status='live', Symbol='Arid3a', Aliases='Bright, Dri1, Dril1', description='AT rich interactive domain 3A (BRIGHT-like)', other_designations='ARID domain-containing protein 3A|AT rich interactive domain 3A (Bright like)|B-cell regulator of IgH transcription|dead ringer homolog 1|dead ringer-like protein 1', map_location='10 C1', chromosome='10', genomic_nucleotide_accession_version='NC_000076.6', start_position_on_the_genomic_accession=79927043, end_position_on_the_genomic_accession=79955018, orientation='plus', exon_count=13, OMIM='', no_hdr0=''),
  13497 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=13497, CurrentID=0, Status='live', Symbol='Drp2', Aliases='AW495265, DRP-2', description='dystrophin related protein 2', other_designations='', map_location='X E3', chromosome='X', genomic_nucleotide_accession_version='NC_000086.7', start_position_on_the_genomic_accession=134404628, end_position_on_the_genomic_accession=134456574, orientation='plus', exon_count=24, OMIM='', no_hdr0=''),
  13498 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=13498, CurrentID=0, Status='live', Symbol='Atn1', Aliases='Atr1, Drpla, atrophin-1', description='atrophin 1', other_designations='dentatorubral pallidoluysian atrophy|dentatorubral-pallidoluysian atrophy protein homolog', map_location='6 59.17 cM', chromosome='6', genomic_nucleotide_accession_version='NC_000072.6', start_position_on_the_genomic_accession=124742544, end_position_on_the_genomic_accession=124756487, orientation='minus', exon_count=10, OMIM='', no_hdr0=''),
  13499 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=13499, CurrentID=0, Status='live', Symbol='Drr1', Aliases='Drr1ab, Drr1c, Drr1', description='developmentally regulated repeat element-containing transcript 1', other_designations='', map_location='', chromosome='X', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  13505 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=13505, CurrentID=0, Status='live', Symbol='Dsc1', Aliases='1110020A10Rik, AI507491', description='desmocollin 1', other_designations='', map_location='18 A2', chromosome='18', genomic_nucleotide_accession_version='NC_000084.6', start_position_on_the_genomic_accession=20083471, end_position_on_the_genomic_accession=20114773, orientation='minus', exon_count=17, OMIM='', no_hdr0=''),
  13506 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=13506, CurrentID=0, Status='live', Symbol='Dsc2', Aliases='AW228162', description='desmocollin 2', other_designations='epithelial type 2 desmocollin', map_location='18 11.14 cM', chromosome='18', genomic_nucleotide_accession_version='NC_000084.6', start_position_on_the_genomic_accession=20030633, end_position_on_the_genomic_accession=20059552, orientation='minus', exon_count=17, OMIM='', no_hdr0=''),
  13507 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=13507, CurrentID=0, Status='live', Symbol='Dsc3', Aliases='5430426I24Rik', description='desmocollin 3', other_designations='', map_location='18 11.11 cM', chromosome='18', genomic_nucleotide_accession_version='NC_000084.6', start_position_on_the_genomic_accession=19960930, end_position_on_the_genomic_accession=20002413, orientation='minus', exon_count=18, OMIM='', no_hdr0=''),
  13508 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=13508, CurrentID=0, Status='live', Symbol='Dscam', Aliases='4932410A21Rik', description='Down syndrome cell adhesion molecule', other_designations='', map_location='16 C', chromosome='16', genomic_nucleotide_accession_version='NC_000082.6', start_position_on_the_genomic_accession=96587452, end_position_on_the_genomic_accession=97170735, orientation='minus', exon_count=34, OMIM='', no_hdr0=''),
  13510 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=13510, CurrentID=0, Status='live', Symbol='Dsg1a', Aliases='DG1, DGI, Dsg1, dsg1-alpha', description='desmoglein 1 alpha', other_designations='desmosomal glycoprotein I', map_location='18 11.29 cM', chromosome='18', genomic_nucleotide_accession_version='NC_000084.6', start_position_on_the_genomic_accession=20310873, end_position_on_the_genomic_accession=20343353, orientation='plus', exon_count=15, OMIM='', no_hdr0=''),
  13511 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=13511, CurrentID=0, Status='live', Symbol='Dsg2', Aliases='AA408168, D18Ertd293e', description='desmoglein 2', other_designations='', map_location='18 11.42 cM', chromosome='18', genomic_nucleotide_accession_version='NC_000084.6', start_position_on_the_genomic_accession=20558116, end_position_on_the_genomic_accession=20604526, orientation='plus', exon_count=15, OMIM='', no_hdr0=''),
  13512 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=13512, CurrentID=0, Status='live', Symbol='Dsg3', Aliases='bal', description='desmoglein 3', other_designations='130 kDa pemphigus vulgaris antigen homolog', map_location='18 11.39 cM', chromosome='18', genomic_nucleotide_accession_version='NC_000084.6', start_position_on_the_genomic_accession=20510304, end_position_on_the_genomic_accession=20541310, orientation='plus', exon_count=16, OMIM='', no_hdr0=''),
  13516 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=13516, CurrentID=0, Status='live', Symbol='Epyc', Aliases='Dspg3, PG-Lb, SLRR3B', description='epiphycan', other_designations='dermatan sulfate proteoglycan 3|dermatan sulphate proteoglycan 3|proteoglycan-Lb|small chondroitin/dermatan sulfate proteoglycan', map_location='10 C2-C3', chromosome='10', genomic_nucleotide_accession_version='NC_000076.6', start_position_on_the_genomic_accession=97644068, end_position_on_the_genomic_accession=97681908, orientation='plus', exon_count=9, OMIM='', no_hdr0=''),
  13518 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=13518, CurrentID=0, Status='live', Symbol='Dst', Aliases='2310001O04Rik, A830042E19Rik, AW554249, BP230, BPAG1-n, Bpag, Bpag1, Macf2, ah, athetoid, dt, mKIAA0728, nmf203, nmf339', description='dystonin', other_designations='BPA|bullous pemphigoid antigen 1|bullous pemphigoid antigen 1, isoforms 1/2/3/4|bullous pemphigoid antigen 1, isoforms 6/7|dystonia musculorum protein|hemidesmosomal plaque protein|microtubule actin cross-linking factor 2', map_location='1 12.91 cM', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=33908208, end_position_on_the_genomic_accession=34308662, orientation='plus', exon_count=111, OMIM='', no_hdr0=''),
  668880 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=668880, CurrentID=0, Status='live', Symbol='Stard9', Aliases='4831403C07Rik, E230025N21Rik, Kif16a, mKIAA1300', description='START domain containing 9', other_designations='N-3 kinesin|START domain-containing protein 9|StAR-related lipid transfer protein 9|kinesin 16A|kinesin family member 16A|kinesin-like protein Kif16a', map_location='2 E5', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=120629091, end_position_on_the_genomic_accession=120716086, orientation='plus', exon_count=35, OMIM='', no_hdr0=''),
  13521 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=13521, CurrentID=0, Status='live', Symbol='Slc26a2', Aliases='Dtd, ST-OB', description='solute carrier family 26 (sulfate transporter), member 2', other_designations='diastrophic dysplasia protein homolog|solute carrier family 26 member 2', map_location='18 D3', chromosome='18', genomic_nucleotide_accession_version='NC_000084.6', start_position_on_the_genomic_accession=61196854, end_position_on_the_genomic_accession=61211596, orientation='minus', exon_count=4, OMIM='', no_hdr0=''),
  13522 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=13522, CurrentID=0, Status='live', Symbol='Adam28', Aliases='C130072N01Rik, D430033C21Rik, Dtgn1, MDC-L, MDCL, TECADAM, eMDCII', description='a disintegrin and metallopeptidase domain 28', other_designations='ADAM 28|a disintegrin and metalloprotease domain 28|a disintegrin and metalloproteinase domain 28|disintegrin 1|metalloproteinase-disintegrin domain containing protein TECADAM|thymic epithelial cell-ADAM', map_location='14 D2', chromosome='14', genomic_nucleotide_accession_version='NC_000080.6', start_position_on_the_genomic_accession=68604994, end_position_on_the_genomic_accession=68655887, orientation='minus', exon_count=24, OMIM='', no_hdr0=''),
  13524 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=13524, CurrentID=0, Status='live', Symbol='Adam18', Aliases='Adam27, Dtgn3, Tmdc3, tMDCIII', description='a disintegrin and metallopeptidase domain 18', other_designations='ADAM 18|ADAM 27|disintegrin 3|disintegrin and metalloproteinase domain-containing protein 27|tMDC III|transmembrane metalloproteinase-like, disintegrin-like, and cysteine-rich protein III', map_location='8 A3', chromosome='8', genomic_nucleotide_accession_version='NC_000074.6', start_position_on_the_genomic_accession=24602246, end_position_on_the_genomic_accession=24674770, orientation='minus', exon_count=20, OMIM='', no_hdr0=''),
  67790 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=67790, CurrentID=0, Status='live', Symbol='Rab39b', Aliases='6330580M05Rik', description='RAB39B, member RAS oncogene family', other_designations='', map_location='X A7.3', chromosome='X', genomic_nucleotide_accession_version='NC_000086.7', start_position_on_the_genomic_accession=75572045, end_position_on_the_genomic_accession=75578231, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  13526 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=13526, CurrentID=0, Status='live', Symbol='Adam24', Aliases='Dtgn5', description='a disintegrin and metallopeptidase domain 24 (testase 1)', other_designations='ADAM 24|a disintegrin and metalloproteinase domain 24 (testase 1)|disintegrin 5|testase 1|testase-1', map_location='8 A4', chromosome='8', genomic_nucleotide_accession_version='NC_000074.6', start_position_on_the_genomic_accession=40675094, end_position_on_the_genomic_accession=40682199, orientation='plus', exon_count=3, OMIM='', no_hdr0=''),
  13527 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=13527, CurrentID=0, Status='live', Symbol='Dtna', Aliases='2210407P21Rik, DTN-A, Dtn, Gm19389, a-DB-1, adbn', description='dystrobrevin alpha', other_designations='alpha-dystrobrevin', map_location='18 12.08 cM', chromosome='18', genomic_nucleotide_accession_version='NC_000084.6', start_position_on_the_genomic_accession=23310020, end_position_on_the_genomic_accession=23659719, orientation='plus', exon_count=29, OMIM='', no_hdr0=''),
  13528 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=13528, CurrentID=0, Status='live', Symbol='Dtnb', Aliases='', description='dystrobrevin, beta', other_designations='DTN-B|beta-dystrobrevin|mDTN-B', map_location='12 1.88 cM', chromosome='12', genomic_nucleotide_accession_version='NC_000078.6', start_position_on_the_genomic_accession=3572391, end_position_on_the_genomic_accession=3782611, orientation='plus', exon_count=22, OMIM='', no_hdr0=''),
  13529 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=13529, CurrentID=0, Status='live', Symbol='Prl8a2', Aliases='D/tPRP, DPRP, Dtprp, Ghd11, mdPRP', description='prolactin family 8, subfamily a, member 2', other_designations='decidual/trophoblast prolactin-related protein|growth hormone d11', map_location='13 12.41 cM', chromosome='13', genomic_nucleotide_accession_version='NC_000079.6', start_position_on_the_genomic_accession=27345673, end_position_on_the_genomic_accession=27354216, orientation='plus', exon_count=6, OMIM='', no_hdr0=''),
  13531 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=13531, CurrentID=0, Status='live', Symbol='Usp17la', Aliases='Dub1, USP17-A', description='ubiquitin specific peptidase 17-like A', other_designations='deubiquitinating enzyme 1|ubiquitin carboxyl-terminal hydrolase DUB-1|ubiquitin thioesterase DUB-1|ubiquitin thiolesterase DUB-1|ubiquitin-specific-processing protease DUB-1', map_location='7 55.69 cM', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=104857016, end_position_on_the_genomic_accession=104862667, orientation='plus', exon_count=3, OMIM='', no_hdr0=''),
  13532 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=13532, CurrentID=0, Status='live', Symbol='Usp17lc', Aliases='Dub-2, Dub2, Dub2b, Usp17l5', description='ubiquitin specific peptidase 17-like C', other_designations='ubiquitin specific peptidase 17-like 5', map_location='7 54.85 cM', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=103416696, end_position_on_the_genomic_accession=103419174, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  668894 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=668894, CurrentID=0, Status='live', Symbol='Gm14025', Aliases='OTTMUSG00000015417', description='predicted gene 14025', other_designations='', map_location='2 F1', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=129024141, end_position_on_the_genomic_accession=129065905, orientation='minus', exon_count=11, OMIM='', no_hdr0=''),
  13537 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=13537, CurrentID=0, Status='live', Symbol='Dusp2', Aliases='PAC1', description='dual specificity phosphatase 2', other_designations='dual specificity protein phosphatase PAC-1', map_location='2 F1', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=127336159, end_position_on_the_genomic_accession=127338377, orientation='plus', exon_count=4, OMIM='', no_hdr0=''),
  13542 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=13542, CurrentID=0, Status='live', Symbol='Dvl1', Aliases='Dvl, mKIAA4029', description='dishevelled segment polarity protein 1', other_designations='DSH homolog 1|dishevelled, dsh homolog 1|dishevelled-1', map_location='4 87.61 cM', chromosome='4', genomic_nucleotide_accession_version='NC_000070.6', start_position_on_the_genomic_accession=155847317, end_position_on_the_genomic_accession=155859303, orientation='plus', exon_count=18, OMIM='', no_hdr0=''),
  13543 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=13543, CurrentID=0, Status='live', Symbol='Dvl2', Aliases='', description='dishevelled segment polarity protein 2', other_designations='DSH homolog 2|dishevelled 2, dsh homolog|dishevelled-2', map_location='11 42.96 cM', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=70000626, end_position_on_the_genomic_accession=70010109, orientation='plus', exon_count=15, OMIM='', no_hdr0=''),
  13544 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=13544, CurrentID=0, Status='live', Symbol='Dvl3', Aliases='', description='dishevelled segment polarity protein 3', other_designations='DSH homolog 3|dishevelled 3, dsh homolog|dishevelled-3', map_location='16 12.46 cM', chromosome='16', genomic_nucleotide_accession_version='NC_000082.6', start_position_on_the_genomic_accession=20516938, end_position_on_the_genomic_accession=20532548, orientation='plus', exon_count=16, OMIM='', no_hdr0=''),
  13548 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=13548, CurrentID=0, Status='live', Symbol='Dyrk1a', Aliases='2310043O08Rik, D16Ertd272e, D16Ertd493e, Dyrk, ENSMUSG00000074897, Gm10783, Mnbh, Mp86, mmb', description='dual-specificity tyrosine-(Y)-phosphorylation regulated kinase 1a', other_designations='dual specificity YAK1-related kinase|protein kinase minibrain homolog', map_location='16 55.3 cM', chromosome='16', genomic_nucleotide_accession_version='NC_000082.6', start_position_on_the_genomic_accession=94569951, end_position_on_the_genomic_accession=94695519, orientation='plus', exon_count=15, OMIM='', no_hdr0=''),
  13549 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=13549, CurrentID=0, Status='live', Symbol='Dyrk1b', Aliases='Mirk', description='dual-specificity tyrosine-(Y)-phosphorylation regulated kinase 1b', other_designations='', map_location='7 A3', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=28179483, end_position_on_the_genomic_accession=28187793, orientation='plus', exon_count=13, OMIM='', no_hdr0=''),
  13555 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=13555, CurrentID=0, Status='live', Symbol='E2f1', Aliases='E2F-1, mKIAA4009', description='E2F transcription factor 1', other_designations='', map_location='2 76.79 cM', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=154559400, end_position_on_the_genomic_accession=154569892, orientation='minus', exon_count=8, OMIM='', no_hdr0=''),
  668917 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=668917, CurrentID=0, Status='live', Symbol='Zfp133-ps', Aliases='OTTMUSG00000003825, Zfp133', description='zinc finger protein 133, pseudogene', other_designations='', map_location='2 G1', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=144459280, end_position_on_the_genomic_accession=144467794, orientation='plus', exon_count=3, OMIM='', no_hdr0=''),
  13559 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=13559, CurrentID=0, Status='live', Symbol='E2f5', Aliases='AU024671, E2F-5', description='E2F transcription factor 5', other_designations='', map_location='3 A1', chromosome='3', genomic_nucleotide_accession_version='NC_000069.6', start_position_on_the_genomic_accession=14578602, end_position_on_the_genomic_accession=14606309, orientation='plus', exon_count=9, OMIM='', no_hdr0=''),
  13560 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=13560, CurrentID=0, Status='live', Symbol='E4f1', Aliases='p120E4F, phi-AP3', description='E4F transcription factor 1', other_designations='putative E3 ubiquitin-protein ligase E4F1|transcription factor E4F|transcription factor phi AP3', map_location='17 12.39 cM', chromosome='17', genomic_nucleotide_accession_version='NC_000083.6', start_position_on_the_genomic_accession=24443778, end_position_on_the_genomic_accession=24455590, orientation='minus', exon_count=14, OMIM='', no_hdr0=''),
  67797 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=67797, CurrentID=0, Status='live', Symbol='Snrnp48', Aliases='1110050F08Rik, 6530403A03Rik, C6orf151', description='small nuclear ribonucleoprotein 48 (U11/U12)', other_designations='U11/U12 snRNP 48 kDa protein', map_location='13 A5', chromosome='13', genomic_nucleotide_accession_version='NC_000079.6', start_position_on_the_genomic_accession=38204911, end_position_on_the_genomic_accession=38227663, orientation='plus', exon_count=10, OMIM='', no_hdr0=''),
  668929 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=668929, CurrentID=0, Status='live', Symbol='Rad21l', Aliases='Gm14160, MeiRAD21L1, Rad21l', description='RAD21-like (S. pombe)', other_designations='', map_location='2', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=151644366, end_position_on_the_genomic_accession=151670622, orientation='minus', exon_count=14, OMIM='', no_hdr0=''),
  668940 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=668940, CurrentID=0, Status='live', Symbol='Myh7b', Aliases='Myh14', description='myosin, heavy chain 7B, cardiac muscle, beta', other_designations='myosin heavy chain 7B, cardiac muscle beta isoform', map_location='2 H1', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=155611243, end_position_on_the_genomic_accession=155634307, orientation='plus', exon_count=43, OMIM='', no_hdr0=''),
  13586 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=13586, CurrentID=0, Status='live', Symbol='Ear1', Aliases='EAR-1, ECP 1, Raf1', description='eosinophil-associated, ribonuclease A family, member 1', other_designations='RNase 3-1|eosinophil secondary granule ribonuclease 1|eosinophil-associated ribonuclease 1|ribonuclease 3-1|ribonuclease A f1', map_location='14 C1', chromosome='14', genomic_nucleotide_accession_version='NC_000080.6', start_position_on_the_genomic_accession=43818765, end_position_on_the_genomic_accession=43819639, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  13587 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=13587, CurrentID=0, Status='live', Symbol='Ear2', Aliases='EAR-13, EAR-2, ECP, ECP 2, Raf3, Rnase2', description='eosinophil-associated, ribonuclease A family, member 2', other_designations='RNase 3-2|eosinophil secondary granule ribonuclease 2|eosinophil-associated ribonuclease 13|eosinophil-associated ribonuclease 2|eosinophil-derived neurotoxin, liver|ribonuclease 3-2|ribonuclease A f3', map_location='14 C1', chromosome='14', genomic_nucleotide_accession_version='NC_000080.6', start_position_on_the_genomic_accession=44102654, end_position_on_the_genomic_accession=44103531, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  13589 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=13589, CurrentID=0, Status='live', Symbol='Mapre1', Aliases='5530600P05Rik, AI462499, AI504412, AW260097, BIM1p, D2Ertd459e, Eb1', description='microtubule-associated protein, RP/EB family, member 1', other_designations='APC-binding protein EB1|adenomatosis polyposis coli binding protein Eb1|end-binding protein 1', map_location='2 75.95 cM', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=153741287, end_position_on_the_genomic_accession=153773317, orientation='plus', exon_count=7, OMIM='', no_hdr0=''),
  13590 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=13590, CurrentID=0, Status='live', Symbol='Lefty1', Aliases='AI450052, Ebaf, Leftb, Stra3, Tgfb4, lefty, lefty-1', description='left right determination factor 1', other_designations='TGF-beta-4|left-right determination, factor B|protein lefty-1|stimulated by retinoic acid gene 3 protein|transforming growth factor beta-4', map_location='1 F', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=180935039, end_position_on_the_genomic_accession=180938401, orientation='plus', exon_count=4, OMIM='', no_hdr0=''),
  13591 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=13591, CurrentID=0, Status='live', Symbol='Ebf1', Aliases='Ebf, O/E-1, OE-1, Olf-1, Olf1', description='early B cell factor 1', other_designations='early B-cell factor', map_location='11 26.45 cM', chromosome='11', genomic_nucleotide_accession_version='NC_000077.6', start_position_on_the_genomic_accession=44618100, end_position_on_the_genomic_accession=45008096, orientation='plus', exon_count=17, OMIM='', no_hdr0=''),
  13592 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=13592, CurrentID=0, Status='live', Symbol='Ebf2', Aliases='D14Ggc1e, EBF-2, Mmot1, O/E-3, OE-3', description='early B cell factor 2', other_designations='MET-mesencephalon-olfactory TF1|MET-mesencephalon-olfactory transcription factor 1|Olf-1/EBF-like 3|metencephalon-mesencephalon-olfactory transcription factor 1', map_location='14 D-E1', chromosome='14', genomic_nucleotide_accession_version='NC_000080.6', start_position_on_the_genomic_accession=67233292, end_position_on_the_genomic_accession=67430952, orientation='plus', exon_count=17, OMIM='', no_hdr0=''),
  13593 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=13593, CurrentID=0, Status='live', Symbol='Ebf3', Aliases='3110018A08Rik, O/E-2, mKIAA4201', description='early B cell factor 3', other_designations='EBF-3|OE-2|Olf-1/EBF-like 2|early B-cell factor 3', map_location='7 F3-F4', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=137193671, end_position_on_the_genomic_accession=137322810, orientation='minus', exon_count=20, OMIM='', no_hdr0=''),
  13595 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=13595, CurrentID=0, Status='live', Symbol='Ebp', Aliases='AI255399, Pabp, SI, Td, mSI', description='phenylalkylamine Ca2+ antagonist (emopamil) binding protein', other_designations='D8-D7 sterol isomerase|cholestenol Delta-isomerase|delta(8)-Delta(7) sterol isomerase|tattered', map_location='X 3.7 cM', chromosome='X', genomic_nucleotide_accession_version='NC_000086.7', start_position_on_the_genomic_accession=8185331, end_position_on_the_genomic_accession=8193512, orientation='minus', exon_count=5, OMIM='', no_hdr0=''),
  13599 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=13599, CurrentID=0, Status='live', Symbol='Ecel1', Aliases='DINE, xce', description='endothelin converting enzyme-like 1', other_designations='damage-induced neuronal endopeptidase', map_location='1 D', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=87142874, end_position_on_the_genomic_accession=87157085, orientation='minus', exon_count=23, OMIM='', no_hdr0=''),
  13600 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=13600, CurrentID=0, Status='live', Symbol='Eclb', Aliases='ecl', description='epistatic circling B C57L/J', other_designations='', map_location='4 69.05 cM', chromosome='4', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  13601 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=13601, CurrentID=0, Status='live', Symbol='Ecm1', Aliases='AI663821, p85', description='extracellular matrix protein 1', other_designations='secretory component p85', map_location='3 40.91 cM', chromosome='3', genomic_nucleotide_accession_version='NC_000069.6', start_position_on_the_genomic_accession=95734147, end_position_on_the_genomic_accession=95739819, orientation='minus', exon_count=11, OMIM='', no_hdr0=''),
  13602 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=13602, CurrentID=0, Status='live', Symbol='Sparcl1', Aliases='Ecm2, Sc1, hevin, mast9', description='SPARC-like 1', other_designations='SPARC-like 1 (mast9, hevin)|extracellular matrix protein 2|matrix glycoprotein Sc1', map_location='5 E4', chromosome='5', genomic_nucleotide_accession_version='NC_000071.6', start_position_on_the_genomic_accession=104079108, end_position_on_the_genomic_accession=104114088, orientation='minus', exon_count=12, OMIM='', no_hdr0=''),
  13603 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=13603, CurrentID=0, Status='live', Symbol='Opn3', Aliases='ERO, Ecpn', description='opsin 3', other_designations='encephalopsin|opsin (encephalopsin)|panopsin', map_location='1 H3', chromosome='1', genomic_nucleotide_accession_version='NC_000067.6', start_position_on_the_genomic_accession=175662421, end_position_on_the_genomic_accession=175692902, orientation='minus', exon_count=5, OMIM='', no_hdr0=''),
  13605 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=13605, CurrentID=0, Status='live', Symbol='Ect2', Aliases='AI528536, mKIAA4037', description='ect2 oncogene', other_designations='epithelial cell-transforming sequence 2 oncogene', map_location='3 B', chromosome='3', genomic_nucleotide_accession_version='NC_000069.6', start_position_on_the_genomic_accession=27097222, end_position_on_the_genomic_accession=27153878, orientation='minus', exon_count=25, OMIM='', no_hdr0=''),
  13607 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=13607, CurrentID=0, Status='live', Symbol='Eda', Aliases='EDA1, Ed1-A1, Eda-A2, HED, Ta, Tnlg7c, XLHED, tabby, Eda', description='ectodysplasin-A', other_designations='EDA protein homolog|tumor necrosis factor ligand 7c', map_location='X 43.59 cM', chromosome='X', genomic_nucleotide_accession_version='NC_000086.7', start_position_on_the_genomic_accession=99975606, end_position_on_the_genomic_accession=100400760, orientation='plus', exon_count=10, OMIM='', no_hdr0=''),
  13608 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=13608, CurrentID=0, Status='live', Symbol='Edar', Aliases='ED1R, ED3, ED5, EDA-A1R, EDA3, dl', description='ectodysplasin-A receptor', other_designations='anhidrotic ectodysplasin receptor 1|downless|ectodermal dysplasia receptor', map_location='10 B3', chromosome='10', genomic_nucleotide_accession_version='NC_000076.6', start_position_on_the_genomic_accession=58600780, end_position_on_the_genomic_accession=58675696, orientation='minus', exon_count=13, OMIM='', no_hdr0=''),
  13609 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=13609, CurrentID=0, Status='live', Symbol='S1pr1', Aliases='AI849002, Edg1, Lpb1, S1p, S1p1', description='sphingosine-1-phosphate receptor 1', other_designations='S1P receptor 1|S1P receptor Edg-1|endothelial differentiation G-protein coupled receptor 1|endothelial differentiation sphingolipid G-protein-coupled receptor 1|lysophospholipid receptor B1|sphingosine 1-phosphate receptor Edg-1', map_location='3 G1', chromosome='3', genomic_nucleotide_accession_version='NC_000069.6', start_position_on_the_genomic_accession=115710433, end_position_on_the_genomic_accession=115715055, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  13610 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=13610, CurrentID=0, Status='live', Symbol='S1pr3', Aliases='AI132464, Edg3, Lpb3, S1p3', description='sphingosine-1-phosphate receptor 3', other_designations='S1P receptor Edg-3|S1p receptor 3|endothelial differentiation G-protein coupled receptor 3|endothelial differentiation sphingolipid G-protein-coupled receptor 3|lysophospholipid receptor B3|sphingosine 1-phosphate receptor Edg-3', map_location='13 B1', chromosome='13', genomic_nucleotide_accession_version='NC_000079.6', start_position_on_the_genomic_accession=51408618, end_position_on_the_genomic_accession=51422797, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  13611 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=13611, CurrentID=0, Status='live', Symbol='S1pr4', Aliases='Edg6, Lpc1, S1p4', description='sphingosine-1-phosphate receptor 4', other_designations='S1P receptor Edg-6|S1p receptor 4|endothelial differentiation G-protein coupled receptor 6|endothelial differentiation G-protein-coupled receptor 6|lysophospholipid receptor C1|sphingosine 1-phosphate receptor Edg-6', map_location='10 C1', chromosome='10', genomic_nucleotide_accession_version='NC_000076.6', start_position_on_the_genomic_accession=81497745, end_position_on_the_genomic_accession=81500137, orientation='minus', exon_count=1, OMIM='', no_hdr0=''),
  13612 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=13612, CurrentID=0, Status='live', Symbol='Edil3', Aliases='Del-1, Del1', description='EGF-like repeats and discoidin I-like domains 3', other_designations='developmental endothelial locus-1|developmentally-regulated endothelial cell locus 1 protein|integrin-binding protein DEL1', map_location='13 C3', chromosome='13', genomic_nucleotide_accession_version='NC_000079.6', start_position_on_the_genomic_accession=88821472, end_position_on_the_genomic_accession=89323225, orientation='plus', exon_count=11, OMIM='', no_hdr0=''),
  13614 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=13614, CurrentID=0, Status='live', Symbol='Edn1', Aliases='ET-1, PPET1, preproET', description='endothelin 1', other_designations='preproendothelin-1', map_location='13 20.82 cM', chromosome='13', genomic_nucleotide_accession_version='NC_000079.6', start_position_on_the_genomic_accession=42301270, end_position_on_the_genomic_accession=42307989, orientation='plus', exon_count=5, OMIM='', no_hdr0=''),
  13615 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=13615, CurrentID=0, Status='live', Symbol='Edn2', Aliases='ET-2, PPET2, VIC', description='endothelin 2', other_designations='preproendothelin-2|vasoactive intestinal contractor peptide', map_location='4 D2.2', chromosome='4', genomic_nucleotide_accession_version='NC_000070.6', start_position_on_the_genomic_accession=120161424, end_position_on_the_genomic_accession=120167360, orientation='plus', exon_count=5, OMIM='', no_hdr0=''),
  13616 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=13616, CurrentID=0, Status='live', Symbol='Edn3', Aliases='ET-3, PPET3, ls, tmgc48', description='endothelin 3', other_designations='preproendothelin-3', map_location='2 98.1 cM', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=174760758, end_position_on_the_genomic_accession=174784042, orientation='plus', exon_count=5, OMIM='', no_hdr0=''),
  13617 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=13617, CurrentID=0, Status='live', Symbol='Ednra', Aliases='ET-AR, ETa, Gpcr10', description='endothelin receptor type A', other_designations='ET-A|G-protein coupled receptor 10|endothelin A receptor', map_location='8 C2', chromosome='8', genomic_nucleotide_accession_version='NC_000074.6', start_position_on_the_genomic_accession=77663029, end_position_on_the_genomic_accession=77724452, orientation='minus', exon_count=8, OMIM='', no_hdr0=''),
  13618 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=13618, CurrentID=0, Status='live', Symbol='Ednrb', Aliases='ET-B, ET-BR, ETR-b, ETb, Sox10m1', description='endothelin receptor type B', other_designations='endothelin receptor non-selective type|piebald', map_location='14 53.05 cM', chromosome='14', genomic_nucleotide_accession_version='NC_000080.6', start_position_on_the_genomic_accession=103814615, end_position_on_the_genomic_accession=103844476, orientation='minus', exon_count=9, OMIM='', no_hdr0=''),
  13619 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=13619, CurrentID=0, Status='live', Symbol='Phc1', Aliases='AW557034, Edr, Edr1, Mph1, Rae-28, rae28', description='polyhomeotic-like 1 (Drosophila)', other_designations='early development regulator1 (homolog of polyhomeotic 1)|early development regulatory protein 1', map_location='6 F3', chromosome='6', genomic_nucleotide_accession_version='NC_000072.6', start_position_on_the_genomic_accession=122317731, end_position_on_the_genomic_accession=122340227, orientation='minus', exon_count=18, OMIM='', no_hdr0=''),
  13623 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=13623, CurrentID=0, Status='live', Symbol='Edv', Aliases='', description='endogenous sequence related to the Duplan murine retrovirus', other_designations='murine leukemia virus gag, pol, and env pseudogene', map_location='', chromosome='10', genomic_nucleotide_accession_version='', start_position_on_the_genomic_accession='', end_position_on_the_genomic_accession='', orientation='', exon_count='', OMIM='', no_hdr0=''),
  13626 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=13626, CurrentID=0, Status='live', Symbol='Eed', Aliases='ENSMUSG00000039373, l(7)5Rn, l7Rn5, lusk', description='embryonic ectoderm development', other_designations='lethal, Chr 7, Rinchik 5', map_location='7', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=89954654, end_position_on_the_genomic_accession=89981419, orientation='minus', exon_count=12, OMIM='', no_hdr0=''),
  13627 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=13627, CurrentID=0, Status='live', Symbol='Eef1a1', Aliases='', description='eukaryotic translation elongation factor 1 alpha 1', other_designations='EF-1-alpha-1|EF-Tu|eEF1A-1|elongation factor 1 A-1|elongation factor Tu|eukaryotic elongation factor 1 A-1', map_location='9 E1', chromosome='9', genomic_nucleotide_accession_version='NC_000075.6', start_position_on_the_genomic_accession=78478453, end_position_on_the_genomic_accession=78481724, orientation='minus', exon_count=8, OMIM='', no_hdr0=''),
  13628 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=13628, CurrentID=0, Status='live', Symbol='Eef1a2', Aliases='Eef1a, S1, wasted, wst', description='eukaryotic translation elongation factor 1 alpha 2', other_designations='EF-1-alpha-2|eEF1A-2|eukaryotic elongation factor 1 A-2|statin-S1', map_location='2 103.6 cM', chromosome='2', genomic_nucleotide_accession_version='NC_000068.7', start_position_on_the_genomic_accession=181147692, end_position_on_the_genomic_accession=181157015, orientation='minus', exon_count=8, OMIM='', no_hdr0=''),
  13629 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=13629, CurrentID=0, Status='live', Symbol='Eef2', Aliases='Ef-2', description='eukaryotic translation elongation factor 2', other_designations='', map_location='10 C1', chromosome='10', genomic_nucleotide_accession_version='NC_000076.6', start_position_on_the_genomic_accession=81176631, end_position_on_the_genomic_accession=81182509, orientation='plus', exon_count=14, OMIM='', no_hdr0=''),
  13631 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=13631, CurrentID=0, Status='live', Symbol='Eef2k', Aliases='C86191, eEF-2K', description='eukaryotic elongation factor-2 kinase', other_designations='calcium/calmodulin-dependent eukaryotic elongation factor 2 kinase|eEF-2 kinase|eukaroytic elongation factor 2 kinase', map_location='7 F3', chromosome='7', genomic_nucleotide_accession_version='NC_000073.6', start_position_on_the_genomic_accession=120842831, end_position_on_the_genomic_accession=120907219, orientation='plus', exon_count=21, OMIM='', no_hdr0=''),
  13636 : NtData(tax_id=10090, Org_name='Mus musculus', GeneID=13636, CurrentID=0, Status='live', Symbol='Efna1', Aliases='AI325262, B61, Efl1, Epl1, Eplg1, Lerk1', description='ephrin A1', other_designations='EPH-related receptor tyrosine kinase ligand 1|immediate early response protein B61', map_location='3 39.04 cM', chromosome='3', genomic_nucleotide_accession_version='NC_000069.6', start_position_on_the_genomic_accession=89271730, end_position_on_the_genomic_accession=89280951, orient